/**
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.eventlevelremark.EventLevelRemarkController', {
	extend: 'Academia.controller.base.BaseController',
	alias: 'widget.eventlevelremarkcontroller',
	stores: ['eventlevelremark.EventLevelRemarkGridStore', 'eventlevelremark.EventLevelRemarkComboStore','common.picklist.StudentActiveInactiveStatusStore','common.picklist.StudentActiveInactiveStatusStoreForMarkSheet',
			'exam.eventLevelRemark.RemarkALStore',
			'exam.eventLevelRemark.MappedRemarkALStore'
	 ],  
	model: [],
	views: [
		'eventlevelremark.EventLevelRemarkStructure', 'eventlevelremark.EventLevelRemarkTab', 'eventlevelremark.EventLevelRemarkFilter',
		'eventlevelremark.EventLevelRemarkGrid','examinationattendancerule.EventLevelRemarkAddWindow' ,
		'examinationattendancerule.EventLevelRemarkAddForm',
		'eventlevelremark.ApplyALToRemarkWindow',
		'eventlevelremark.MappedALToRemarkWindow'
	],
	refs: [{ 
		ref: 'eventlevelremarkaddwindow',
		selector: 'eventlevelremarkaddwindow'    
	},{
		ref: 'eventlevelremarkaddform',
		selector: 'eventlevelremarkaddform'     
	},{
		ref: 'eventlevelremarkstructure',
		selector: 'eventlevelremarkstructure'
	}, {
		ref: 'eventlevelremarktab',
		selector: 'eventlevelremarktab'
	}, {
		ref: 'eventlevelremarkfilter',
		selector: 'eventlevelremarkfilter'
	}, {
		ref: 'eventlevelremarkgrid',
		selector: 'eventlevelremarkgrid'
	}, {
		ref: 'applyALToRemarkWindow',
		selector: 'applyALToRemarkWindow'
	}, {
		ref: 'mappedALToRemarkWindow',
		selector: 'mappedALToRemarkWindow'
	}],
	config: {
		EVENT_LEVEL_REMARK_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EVENT_LEVEL_REMARK_PRIVILEGES')
	},
	init: function() {
		this.control({
			'eventlevelremarktab':{
				afterrender: function(structure){
					var grid = structure.down('eventlevelremarkgrid');
					this.getGridHeaderFreezeForEventLevelRemarkGrid(grid, structure);
					structure.body.on('scroll', function() {
				    	if(Ext.query('.x-boundlist:visible').length) {
							var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
							if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse && boundListCombo.xtype != 'multiselectcombofield'){
								boundListCombo.collapse();
							}
						}
				    });
				}
			},
			'eventlevelremarkfilter button[itemId=resetBtn]': {
				click: this.resetFilter
			},
			
			'eventlevelremarkfilter button[itemId=quickSearchId]': {
				click: this.searchEventLevelRemark
			},
			
			'eventlevelremarkfilter customcombobox[itemId=remarkCodeOrName]': {
				select: this.setRemarkStatus
			},
			
			'eventlevelremarkgrid': {
				afterrender: this.onRemarkGridRender,
				cellclick: this.showMappedAL,
				selectionchange: function(sm, selected) {
					var applyToBtn = sm.view.up('grid').down('#applyToBtnId');
					if(selected.length) {
						applyToBtn.enable();
			    	}
			    	else {
			    		applyToBtn.disable();
			    	}
				}
			},
			
			'eventlevelremarkgrid button[itemId=btnAdd]':{   
				click: function(button){
					var me = this;
					var window=me.showWindow('eventlevelremarkaddwindow');
					 var grid = this.getEventlevelremarkgrid();
					this.OpenAddRemarkWindowNew(false, grid);          
				}
			},
			'eventlevelremarkgrid button[itemId=btnEdit]': {
				click: function(button) {
					var me = this;

					var examcancellationgrid = this.getEventlevelremarkgrid();
					if (examcancellationgrid.getSelectionModel().getSelection().length > 0) {
						var selectedRecord = examcancellationgrid.getSelectionModel().getSelection()[0];
						var window = me.showWindow('eventlevelremarkaddwindow');

						this.OpenAddRemarkWindowNew(true,examcancellationgrid);
						window.down('#remarkCodeId').setValue(selectedRecord.data.remarkCode);
						window.down('#remarkNameId').setValue(selectedRecord.data.remarkName);
						window.down('#studentStatus').setValue(selectedRecord.data.status);
						window.down('#reamrkDesc').setValue(selectedRecord.data.remarkDescription);
						var form = me.getEventlevelremarkaddform();
						var gradeForm = form.getForm();
						var publishmarksonstudentportaltt = gradeForm.findField('publishmarksonstudentportal').items.items;
						var publishremarkStportaltt = gradeForm.findField('publishremarkStportal').items.items;
						var publishmarksonmarksheett = gradeForm.findField('publishmarksonmarksheet').items.items;

						var contributeInTheSgpaCgpa = gradeForm.findField('publishremarksonmarksheet').items.items;
						var facltyAccessRadioGrp = gradeForm.findField('whetherAccessToFaculty');

						if (selectedRecord.data.isPublishmarksonstudentportal) {
							publishmarksonstudentportaltt[0].setValue(true);
						}
						else {
							publishmarksonstudentportaltt[1].setValue(true);
						}
						if (selectedRecord.data.isPublishremarksonstudentportal) {
							publishremarkStportaltt[0].setValue(true);
						}
						else {
							publishremarkStportaltt[1].setValue(true);
						}
						if (selectedRecord.data.isPublishmarksonmarksheet) {
							publishmarksonmarksheett[0].setValue(true);

						}
						else {
							publishmarksonmarksheett[1].setValue(true);
						}
						if (selectedRecord.data.isPublishremarksonmarksheet) {
							contributeInTheSgpaCgpa[0].setValue(true);
						}
						else {
							contributeInTheSgpaCgpa[1].setValue(true);
						}
						if (!selectedRecord.data.whetherAccessToFaculty) {
							facltyAccessRadioGrp.setValue({whetherAccessToFacultyId:false})
						}
						else {
							facltyAccessRadioGrp.setValue({whetherAccessToFacultyId:true});
						}
						

					}
					else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}

			},
			
			'eventlevelremarkgrid button[itemId=btnDelete]': { 
                click : this.deleteEventLevelRecord
            },
			
			'eventlevelremarkgrid button[itemId=btnView]':{   
				click: function(button){
					var me = this;
					var examcancellationgrid = this.getEventlevelremarkgrid();
					if (examcancellationgrid.getSelectionModel().getSelection().length > 0) {
					var selectedRecord = examcancellationgrid.getSelectionModel().getSelection()[0];
					var window = me.showWindow('eventlevelremarkaddwindow');


					window.down('#remarkCodeId').setValue(selectedRecord.data.remarkCode);
					window.down('#remarkNameId').setValue(selectedRecord.data.remarkName);
					window.down('#studentStatus').setValue(selectedRecord.data.status);
					window.down('#reamrkDesc').setValue(selectedRecord.data.remarkDescription);
					var form = me.getEventlevelremarkaddform();
					var gradeForm = form.getForm();
					var publishmarksonstudentportaltt = gradeForm.findField('publishmarksonstudentportal').items.items;
					var publishremarkStportaltt = gradeForm.findField('publishremarkStportal').items.items;
					var publishmarksonmarksheett = gradeForm.findField('publishmarksonmarksheet').items.items;

					var contributeInTheSgpaCgpa = gradeForm.findField('publishremarksonmarksheet').items.items;
					var facltyAccessRadioGrp = gradeForm.findField('whetherAccessToFaculty');

					if (selectedRecord.data.isPublishmarksonstudentportal) {
						publishmarksonstudentportaltt[0].setValue(true);
					}
					else {
						publishmarksonstudentportaltt[1].setValue(true);
					}
					if (selectedRecord.data.isPublishremarksonstudentportal) {
						publishremarkStportaltt[0].setValue(true);
					}
					else {
						publishremarkStportaltt[1].setValue(true);
					}
					if (selectedRecord.data.isPublishmarksonmarksheet) {
						publishmarksonmarksheett[0].setValue(true);

					}
					else {
						publishmarksonmarksheett[1].setValue(true);
					}
					if (selectedRecord.data.isPublishremarksonmarksheet) {
						contributeInTheSgpaCgpa[0].setValue(true);
					}
					else {
						contributeInTheSgpaCgpa[1].setValue(true);
					}
					if (!selectedRecord.data.whetherAccessToFaculty) {
						facltyAccessRadioGrp.setValue({whetherAccessToFacultyId:false})
					}
					else {
						facltyAccessRadioGrp.setValue({whetherAccessToFacultyId:true});
					}
			        if (form) {
			            form.down('#remarksSubmitBtn').setVisible(false);
			            form.down('#remarksResetBtn').setVisible(false);
			            form.down('#cancleBtn').setVisible(true);
			            form = form.getForm();
			            toggleReadOnlyFormItems(form, true);
			            window.setHeight(window.getHeight() - 1);
			            window.setHeight(window.getHeight() + 1);
			        }
					}
					else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			
			'eventlevelremarkaddform button[itemId=remarksSubmitBtn]':{ 
				click: function(button){
					button.setDisabled(true);
					var me = this;
					this.saveRemarkAddedRemarkNew(button);
					}
			},
			'eventlevelremarkgrid button[itemId=applyToBtnId]': {
				click: this.applyALToRemark
			},
			'applyALToRemarkWindow textfield[itemId=academyLocationItemId]': {
				change: this.filterAcademyLocation
			},
			'applyALToRemarkWindow button[itemId=btnLinkAlItemId]': {
				click: this.mapUnmapAL
			},
			'applyALToRemarkWindow': {
				beforeclose: function(win) {
					win.down('#academyLocationItemId').reset();
				}
			}
		});
	},

		resetFilter: function(btn) {
		btn.up('form').getForm().reset();
	},
	
	OpenAddRemarkWindowNew: function(editable, grid) {
        var me = this;  
        var formWindow=me.getEventlevelremarkaddform();
        if (!formWindow) {

            Ext.widget('eventlevelremarkaddwindow');
            formWindow = me.getEventlevelremarkaddform();
        }
        Ext.apply(formWindow,{
            isEdit:null,
            setIsEdit : function(isEdit){
                formWindow.isEdit = isEdit;
            },
            getIsEdit:function(){
                return formWindow.isEdit;
            }
        });
        formWindow.setIsEdit(editable);
       },
	
	searchEventLevelRemark: function(btn) {
		var filterForm = this.getEventlevelremarkfilter();
		var filterVals = filterForm.getValues();
		var grid = this.getEventlevelremarkgrid();
		var store = grid.getStore();
		store.getProxy().extraParams = {
			eventRemarkId: filterVals.remarkCodeOrName,
			status: filterVals.status
		};
		this.resetPageSetting(store, grid);
		store.pageSize = 10;
		store.sorters.removeAll();
		grid.getSelectionModel().deselectAll();
		store.load();
	},
	
	setRemarkStatus: function(combo, record) {
		var statusVal = record[0].get('status') ? 'ACTIVE' : 'INACTIVE';
		combo.nextSibling().setValue(statusVal);
	},
	
	deleteEventLevelRecord:function(){
		var grid = this .getEventlevelremarkgrid();
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getMegaMenuTranslation('EVENT_LEVEL_REMARK'), getCommonTranslation('DELETE_REMARK_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var record = grid.getSelectionModel().getSelection()[0];
					var id = record.get("id");

					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.PATH_DELETE_EVENT_LEVEL_REMARKS+"?id="+id,
						headers : {
							'Content-Type' : 'application/json'
						},
					
						success: function(form, action) {
								showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('DELETE_SUCCESS'));
								grid.getStore().reload();
							}
					});
				}
			});
			
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	 saveRemarkAddedRemarkNew: function(btn) { 
        var me = this;
        var form=me.getEventlevelremarkaddform();
        var formValues = form.getForm().getValues();
        var formWindow=me.getEventlevelremarkaddwindow();
         var formWindowValue = me.getEventlevelremarkaddform();    
        var grid=me.getEventlevelremarkgrid(); 
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'));
        var id=null;
            var selectedRecord = grid.getSelectionModel().getSelection()[0];
            if(selectedRecord!=null){
         id =selectedRecord.data.id;
         }
        var jsonData = {
                remarkCode: formValues.remarkCode,  
                remarkName:formValues.remarkName, 
                remarkDescription:formValues.reamrkDesc,
                status:formValues.studentStatus,
                isPublishmarksonstudentportal:formValues.ispublishmarksonstudentportalId,
                isPublishremarksonstudentportal:formValues.ispublishremarkStportalId, 
                isPublishmarksonmarksheet:formValues.ispublishmarksonmarksheetId,
                isPublishremarksonmarksheet:formValues.ispublishremarksonmarksheetId,
                whetherAccessToFaculty: formValues.whetherAccessToFacultyId
        }
        var submitUrl = SERVERURL.PATH_SAVE_EVENT_LEVEL_REMARKS;
        var successMessage = 'RECORD_SAVED_SUCCESSFULLY';
        if(!isNullOrEmpty(id) && formWindowValue.getIsEdit()) {     
            jsonData.id = id;
            submitUrl = SERVERURL.PATH_UPDATE_EVENT_LEVEL_REMARKS;
            successMessage  = 'RECORD_UPDATE_SUCCESS';
        }
        var formData = Ext.encode(jsonData);
        var filterForm = this.getEventlevelremarkfilter();
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,  													 
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData : formData, 
            success: function(form, action) {  	                        
                Ext.getBody().unmask();  
                if(form.responseText==="CodeDuplicateNameSuccess"){
                btn.setDisabled(false); 
                showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('DUPLICATE_REMARK_CODE'));
                
                }else if(form.responseText==="CodeSuccessNameDuplicate"){
	             btn.setDisabled(false); 
                showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('DUPLICATE_REMARK_NAME'));
                }else if(form.responseText==="CodeDuplicateNameDuplicate"){
	            btn.setDisabled(false); 
                showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('DUPLICATE_REMARK_CODE'));              
                }else {
                    
                    grid.getSelectionModel().deselectAll();
                    showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation(successMessage));
                    formWindow.close();
                    grid.getStore().reload();
                    filterForm.down('#remarkCodeOrName').getStore().load();

                }
            }
        });
        // formWindow.close();
},
	onRemarkGridRender: function (grid) {
		var me = this;
	    var associatedAcadLocationIds = new Array();
	    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    var permissionsMap = this.getEVENT_LEVEL_REMARK_PERMISSIONS();
	    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    var btnAdd = grid.down('#btnAdd');
	    var btnEdit = grid.down('#btnEdit');
	    var btnView = grid.down('#btnView');
	    var btnDelete = grid.down('#btnDelete');
	    var btnExportToPDF = grid.down('#btnExportToPDF');
	    var btnExportToExcel = grid.down('#btnExportToExcel');
	    var btnApplyTo = grid.down('#applyToBtnId');
	    
	    btnAdd.setVisible(false);
	    btnEdit.setVisible(false);
	    btnView.setVisible(false);
	    btnDelete.setVisible(false);
	    btnExportToPDF.setVisible(false);
	    btnExportToExcel.setVisible(false);
	    btnApplyTo.setVisible(false);
	    Ext.each(permissionList, function (privilege) {
	        if (privilege == "CREATE") {
	            btnAdd.setVisible(true);
	        }
	        if (privilege == "UPDATE") {
	            btnEdit.setVisible(true);
	        }
	        if (privilege == "VIEW") {
	            btnView.setVisible(true);
	        }
	        if (privilege == "DELETE") {
	            btnDelete.setVisible(true);
	        }
	        if (privilege == "EXPORT") {
	            btnExportToPDF.setVisible(true);
	            btnExportToExcel.setVisible(true);
	        }
	        if(privilege == "APPLY_TO") {
	        	btnApplyTo.setVisible(true);
	        }
	    });
	    setTimeout(function(){
	    	me.addDataGridConfigButton(grid, me.getEVENT_LEVEL_REMARK_PERMISSIONS());
	    }, 1500);
	},
	
	applyALToRemark: function(btn) {
		var grid = this .getEventlevelremarkgrid();
		if (grid.getSelectionModel().getCount() > 0) {
			var window = this.getApplyALToRemarkWindow();
			if(!window) {
				Ext.widget('applyALToRemarkWindow');
				window = this.getApplyALToRemarkWindow();
			}
			window.show();
			window.setWidth(window.getWidth() + 5);
			var selected = grid.getSelectionModel().getSelection()[0];
			var store = window.down('grid').getStore();
			store.getProxy().extraParams = {
				id: selected.get('id')
			};
			this.resetPageSetting(store, window.down('grid'));
			store.pageSize = 100;
			store.sorters.removeAll();
			store.load({
				callback: function(records) {
					window.center();
					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'));
					Ext.Ajax.request({
			            type: 'rest',
			            url: SERVERURL.PATH_FIND_MAPPED_ACADEMY_LOCATION,  													 
			            method: 'GET',
			            headers: {
			                'Content-Type': 'application/json'
			            },
			            params: {
			            	id: selected.get('id')
			            }, 
			            success: function(response, action) {  	                        
			                Ext.getBody().unmask();  
			                try {
			                	var data = Ext.decode(response.responseText).rows;
			                	var recs = [];
			                	for(var i = 0; i < data.length; i++) {
			                		var rec = store.findRecord('academyLocationId', data[i].academyLocationId, 0, false, false, true);
			                		if(rec) {
			                			recs.push(rec);
			                		}
			                	}
			                	window.down('grid').getSelectionModel().select(recs);
			                }
			                catch(e) {
			                	console.log(e);
			                }
			            }
			        });
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	filterAcademyLocation: function(cmp, val) {
		var grid = cmp.up('window').down('grid');
		var store = grid.getStore();
		var selection = grid.getSelectionModel().getSelection();
		if(val.length >= 3) {
			store.filter({
			    property: 'academyLocationName',
			    value: val,
			    anyMatch: true,
			    caseSensitive: false
			});
		}
		if(val.length == 0) {
			store.clearFilter();
		}
		grid.getSelectionModel().select(selection);
	},
	
	showMappedAL: function(view, CellEl, ColIdx, record, RowEl, rowIndex, e,eopts) {
		if(ColIdx == 3 && e.target.tagName == 'A') {
			var window = this.getMappedALToRemarkWindow();
			if(!window) {
				Ext.widget('mappedALToRemarkWindow');
				window = this.getMappedALToRemarkWindow();
			}
			window.show();
			window.setWidth(window.getWidth() + 5);
			var selected = this .getEventlevelremarkgrid().getSelectionModel().getSelection()[0];
			var store = window.down('grid').getStore();
			store.getProxy().extraParams = {
				id: selected.get('id')
			};
			this.resetPageSetting(store, window.down('grid'));
			store.pageSize = 100;
			store.sorters.removeAll();
			store.load({
				callback: function(records) {
					window.center();
				}
			});
		}
	},
	
	mapUnmapAL: function(btn) {
		var remarkGrid = this .getEventlevelremarkgrid();
		var grid = btn.up('grid');
		var selection = grid.getSelectionModel().getSelection();
		var remarkId = remarkGrid.getSelectionModel().getSelection()[0].get('id');
		var selectedAL = [];
		for(var i = 0; i < selection.length; i++) {
			selectedAL.push({
				academyLocationId: selection[i].get('academyLocationId'),
				academyLocationName: selection[i].get('academyLocationName')
			});
		}
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_MAP_REMARK_ACADEMY_LOCATIONS,
			jsonData: {
				remarkId: remarkId,
				academyLocations: selectedAL
			},
			method: 'POST',
			success: function(frm, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getMegaMenuTranslation('EVENT_LEVEL_REMARK'), getCommonTranslation('SUCCESS'));
				btn.up('window').close();
				remarkGrid.getStore().reload();
			}
		});
	}
});