/**
 * @author Pushpendra
 * 
 */
Ext.define('Academia.controller.examCenter.sequenceManagement.CreateSequenceHeaderController', {
	//extend : 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
	models : ['examCenter.sequenceManagement.CreateSequenceHeaderModel'],
	stores : ['examCenter.createSequence.CreateSequenceGrid'],
	views : ['examCenter.ExamCenter','examCenter.sequenceManagement.CreateSequenceHeaderForm',
	         'examCenter.sequenceManagement.CreateSequenceSearch','examCenter.sequenceManagement.CreateSequenceStructure',
	         'examCenter.sequenceManagement.CreateSequenceGrid'
	         ],	           
    config:{
	        	 /*
	            	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	             		   	 */
	             	   	/**
	             	        * @cfg {Array} CREATE_AND_ASSIGN_SEQUENCE_PERMISSION array (required)
	             	        * The array of permissions to use for Access control wise enabling and disabling buttons.
	             	        * @accessor
	             	        */
    	       CREATESEQUENCE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREATESEQUENCE_PRIVILEGES')
	       },          
	          refs : [{
	        	  ref : 'createsequenceheaderform',
	        	  selector : 'createsequenceheaderform'
	          },{
	        	  ref : 'createSequenceheaderForm',
	        	  selector : 'createsequenceheaderform form'
	          },{
	        	  ref : 'createsequencegrid',
	        	  selector : 'createsequencegrid'
	          },{
	        	  ref : 'createsequencesearch',
	        	  selector : 'createsequencesearch'
	          },{
	        	  ref : 'createsequencestructure',
	        	  selector : 'createsequencestructure'
	          }],
	          init : function() {
	        	  this.control({
	        		  'createsequenceheaderform' :{
	        			  afterrender:function(form){
	        				  var $this = this;
	        				  var filter = form.down('form');
	        				  form.body.on('click',function() {
	          						$this.hideInvalidIconFromField(filter);
	        			       });
	        			  }
	        		  },
	        		 /* 'createsequencestructure':{
	        			  afterrender : function(structure){
	     					 var grid = structure.down('createsequencegrid');
	     	   				 this.getGridHeaderFreeze(grid,structure);
	     				 }
	        		  },*/
	        		  'createsequencesearch button[itemId=searchBtn]':{
		      				click : this.loadCreateSeqGrid
		      			},
	        		  'createsequencegrid button[itemId=btnAdd]':{
		      				click : this.showCreateSeqWindow
		      			},
		      		  'createsequencegrid button[itemId=btnEdit]':{
		      			  /**
		      			   * This functionality is removed as discussed with  nilesh sir
		      			   */
		      				click : this.editCreateSeqWindow
		      			},
	      			 'createsequencegrid button[itemId=btnView]':{
		      				click : this.viewCreateSeqWindow
		      			},
	      			 'createsequencegrid button[itemId=btnDelete]':{
		      				click : this.deleteCreateSeq
		      			},
	        		  'createsequenceheaderform textfield[itemId=sequenceName]':{
	      				blur : function(response){
	      					//this.UniquenessCheck(response);
	      				}
	      			},
	        		  'createsequenceheaderform button[itemId=submitBtn]' : {
	        			  click : this.addSequenceHeader
	        		  },
	      			'createsequenceheaderform button[itemId=cancelBtn]' : { 
	        			  click : function(){
	        				 this.getCreatesequenceheaderform().close();
	        			  }
	        		  },
	        		'createsequencegrid' :{
	    	        	  render:function(grid){
	    	        		  this.doAccessControlValidation(grid, this.getCREATESEQUENCE_PERMISSION());
	    	        		  this.getGridHeaderFreezeForAssessmentSchemeMapUnmap(grid, grid.up('createsequencestructure'));
	    	        	  },
	        		  beforerender:function(grid){
	        			  grid.getStore().removeAll();
	        		  },
	        		  selectionchange: this.onMethodSelectionChange
	    	          },
	    	         'createsequencestructure':{
	    		        	afterrender : function(structure){
	    		        		//var container = structure.items.items[0];
	    		        		//var grid = structure.down('createsequencegrid');
	    		        		//this.getGridHeaderFreeze(grid,structure);
	    		        	}
	    	    		} 
	        	  });
	          },
	          UniquenessCheck : function(response){
	      		var $this = this;
	      		var tabStcrFrm = $this.getCreateSequenceheaderForm().getForm();
	      		var sequenceNameToChk = tabStcrFrm.findField("sequenceName").getValue();
	      		var submitBtn= tabStcrFrm.findField('submitBtn');
	      		var value = response.getValue();
	      		Ext.Ajax.request({
	      			method: "GET",
	      			type: 'rest',
	      			url: SERVERURL.SEQUENCE_HEADER_CHECK_UNIQUENESS+'?sequenceName='+sequenceNameToChk,
	      			headers: {
	      				'Content-Type': 'application/json'
	      			},
	      			success:function(form, action){
	      				var mssg = form.responseText;
	      				if(mssg=="false"){
	      					tabStcrFrm.findField("sequenceName").reset();
	      					showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('SEQUENCE_NAME_EXISTS'));
	      					//submitBtn.setDisabled(true);
	      					
	      				}else {
	      					addSequenceHeader();
	      				}
	      			}
	      		});
	      	}, 
	      	loadCreateSeqGrid:function(){
	      		 var form = this.getCreatesequencesearch().getForm();
	      		 var searchForm = form = this.getCreatesequencesearch();
	      		var grid = this.getCreatesequencegrid();
	      		var values = form.getValues();
	      		/*var prefixNumber = "";*/
	      		var sequenceName = values.sequenceName;
	      		
	      		var store = this.getStore('examCenter.createSequence.CreateSequenceGrid');
	      		this.resetPageSetting(store, grid);
	      		this.resetGridSetting(grid);
	      		 store.getProxy().extraParams = {	
	      			/*prefixNumber: prefixNumber,*/
	      			sequenceName:sequenceName
                  };
	      		grid.getSelectionModel().deselectAll();
		       	    store.load({
						 callback: function(rec, operation, success) {
								 if (success) {
									 if(store.data.length > 0){
									 
									 var pdfButton = grid.down('#btnExportToPDF');
									 var excelButton = grid.down('#btnExportToExcel');
									 pdfButton.disabled = false;
									 excelButton.disabled = false;
								 }
								}
							 }
						 });
		       	 grid.config.searchFilterForm = searchForm;
				 console.log('Store...0',store );
				 
	      	},
	          addSequenceHeader:function(){
	        	  var $this=this;
	        	  var sequenceForm = $this.getCreateSequenceheaderForm().getForm();
	      		  var sequenceNameToChk = sequenceForm.findField("sequenceName").getValue();
                  var submitBtn= $this.getCreateSequenceheaderForm().down('#submitBtn');
                  var sequenceId = sequenceForm.findField("id").getValue();
                if(sequenceNameToChk!=null && isNullOrEmpty(sequenceId)){ 
	              submitBtn.disable();     
	      		Ext.Ajax.request({
	      			method: "GET",
	      			type: 'rest',
	      			url: SERVERURL.SEQUENCE_HEADER_CHECK_UNIQUENESS+'?sequenceName='+sequenceNameToChk,
	      			headers: {
	      				'Content-Type': 'application/json'
	      			},
	      			success:function(successform, action){
	      				var mssg = successform.responseText;
	      				var form = $this.getCreateSequenceheaderForm().getForm(); 
	      				if(mssg=="false"){
	      					form.findField("sequenceName").reset();
	      					showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('SEQUENCE_NAME_EXISTS'));
                               
	      				}else{
	        	 			var value = form.getValues();
			        	  	var createExamCenter = new Academia.model.examCenter.sequenceManagement.CreateSequenceHeaderModel();

	        	 			createExamCenter.set("sequenceName",value.sequenceName);
	        	  			createExamCenter.set("isResultPublish",value.isResultPublish);

	        				var submitUrl;
	  						if (form.findField('id').getSubmitValue() == null
	  							|| form.findField('id').getSubmitValue() == "") {
	  							submitUrl = SERVERURL.SEQUENCE_HEADER_CREATE;
	  						} else {
	  							createExamCenter.set("id", value.id);
	  							submitUrl = SERVERURL.SEQ_UPDATE;
	  						}
	  		 				var formData = Ext.encode(createExamCenter.data);
	  	    				$this.applyWindowMask();
	  						Ext.Ajax.request({   
	  							type : 'rest',
	  							url : submitUrl,
	  							jsonData : formData,
	  							method : 'POST',
	  							success : function(form, action) {
	  								$this.hideWindowMask();
	  								showSuccessMessage(getExaminationTranslation('EVALUATION_MASTER'),getCommonTranslation('SUCCESS'));
	  			    				$this.getCreatesequenceheaderform().close();
	  			    				$this.getCreatesequencegrid().getStore().reload();
	  							}
	  						});  
					          // submitBtn.disable();  
						}
	      			}
	      		});   }
                else {
                	var vals = sequenceForm.getValues();
                	var createExamCenterModel = new Academia.model.examCenter.sequenceManagement.CreateSequenceHeaderModel();

                	createExamCenterModel.set("sequenceName", vals.sequenceName);
                	createExamCenterModel.set("isResultPublish", vals.isResultPublish);
                	createExamCenterModel.set("id", vals.id);
                	
                	var submitData = Ext.encode(createExamCenterModel.data);
                	submitBtn.disable();
                	$this.applyWindowMask();
                	Ext.Ajax.request({
                	    type: 'rest',
                	    url: SERVERURL.SEQ_UPDATE,
                	    jsonData: submitData,
                	    method: 'POST',
                	    success: function (form, action) {
                	        $this.hideWindowMask();
                	        showSuccessMessage(getExaminationTranslation('EVALUATION_MASTER'), getCommonTranslation('SUCCESS'));
                	        $this.getCreatesequenceheaderform().close();
                	        var grid = $this.getCreatesequencegrid();
                	        grid.getSelectionModel().deselectAll();
                	        grid.getStore().reload();
                	    }
                	});
                }
	          },
	          showCreateSeqWindow:function(){  
	  	        	var formWindow = this.getCreatesequenceheaderform();
	  				if (!formWindow) {
	  					Ext.widget('createsequenceheaderform');
	  					formWindow = this.getCreatesequenceheaderform();
	  				}
	  				formWindow.show();
	          },
	          editCreateSeqWindow:function(){
	        	  var $this = this;
					var grid = $this.getCreatesequencegrid();
					if (grid.getSelectionModel().getCount() > 0) {
						$this.showCreateSeqWindow();
						var records = grid.getSelectionModel().getSelection();
						if (records != undefined && records != ""&& records != null) {
							var id = records[0].data.id;
					Ext.Ajax.request({
								type : 'rest',
								url : SERVERURL.SEQ_FIND_BY_ID,
								params : {
									id : id
								},
						        method : 'GET',
						        success : function(response) {
						        var form = $this.getCreateSequenceheaderForm().getForm();
						        var data = Ext.decode(response.responseText);
						    	var createExamCenter = new Academia.model.examCenter.sequenceManagement.CreateSequenceHeaderModel(data);
								form.loadRecord(createExamCenter);
						    	form.findField('sequenceName').setReadOnly(true);
						    	form.findField('resultPublish').setValue({
						    		isResultPublish: data.isResultPublish
						    	});
							}
						});
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
	          },
	          viewCreateSeqWindow:function(){
					this.editCreateSeqWindow();
				      var form = this.getCreateSequenceheaderForm();
					if (form) {
						form.down('#submitBtn').hide();
						form.down('#cancelBtn').hide();
						form = form.getForm();
						toggleReadOnlyFormItems(form, true);
					}
	          },
	          deleteCreateSeq:function(){
        		var this$ = this;
				var grid = this$.getCreatesequencegrid();
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getExaminationTranslation('EVALUATION_MASTER'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
					function(btn, text) {
						if (btn == 'yes') {
							var records = grid.getSelectionModel().getSelection()[0];
							var id = records.data.id;
							Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								url : SERVERURL.SEQ_DELETE+ '?id='+ id,
								headers : {
									'Content-Type' : 'application/json'
								},     
								params : {
									id : id
								},
								success : function(response) {
								    var data = Ext.decode(response.responseText);
								    if(data == false){
								    	showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation("exception_database_dataintegrity"));
								    }else{
									showSuccessMessage(getExaminationTranslation('EVALUATION_MASTER'),getCommonTranslation('SUCCESS'));
									this$.getCreatesequencegrid().getStore().reload();
								    }
								}
							});
					  }
				   });
				}else{
					showWarningMessage(getExaminationTranslation('SEQUENCE'),getCommonTranslation('PLEASE_SELECT_RECORD'));	
				}
	         },
	         
	         onMethodSelectionChange: function(sm, selected) {
        		 var grid = sm.view.up('grid');
        		 var editBtn = grid.down('#btnEdit');
	        	 if(selected.length) {
	        		 editBtn.enable();
	        	 }
	        	 else {
	        		 editBtn.disable();
	        	 }
	         }
});
