/**
 * @author Ashutosh.Bhawsar
 * 
 **/
Ext.define('Academia.controller.examcancellation.ExamCancellationController', {
	extend: 'Academia.controller.base.BaseController',
	models: [
	],
	stores: [
		'examcancellation.ExamCancellationGridStore',
		'examinationcenters.reports.CriteriaBasedGradeListStore',
		'common.picklist.StudentActiveInactiveStatusStore',
		'examcancellation.ExamCancellationStatusEnumStore',
		'examcancellation.ExamCancellationNameListStore',
		'examcancellation.ExamCancellationMappedProgramBatchGridStore',
		'examcancellation.ExamCancellationProgramAssociatedGridStore',
		'examcancellation.ECALProgramBatchList',
		'user.UserAcademyLocationStore',
		'common.AssignedProgramStore',
		'examinationcenters.reports.ExaminationReportStudentStore',
		'examcancellation.ExamCancellationReqStatusEnumStore',
		'examcancellation.ExamCancellationRequestGridStore',
		'examinationcenters.studentportal.revaluation.RevaluationApprovalRejectedStore',
		'examcancellation.ExamCancellationNameStore'
	],
	views: [
		'baselayout.contentarea.ContentPanel',/**/
		'examcancellation.ExamCancellationStructure',
		'examcancellation.ExamCancellationGrid',
		'examcancellation.ExamCancellationFilter',
		'examcancellation.ExamCancellationSetUpForm',
		'examcancellation.ExamCancellationSetUpWindow',
		'examcancellation.ExamCancellationAddMappingStructure',
		'examcancellation.ExamCancellationApplyToStructure',
		'examcancellation.ECAddMappingTabStructure',
		'examcancellation.ECAddMappingAcademyLocationTab',
		'examcancellation.ECAddMappingProgramTab',
		'examcancellation.ECAddMappingProgramBatchTab',
		'examcancellation.ExamCancellationProgressTracker',
		'examcancellation.ExamCancellationApplyToWindow',
		'examcancellation.ECProgramsAssociatedGridWindow',
		'examcancellation.ExamCancellationRequestStructure',
		'examcancellation.ExamCancellationRequestFilter',
		'examcancellation.ExamCancellationRequestGrid',
		'examcancellation.ExamCancellationApproveRejectWin'
	],
	config: {
		EXAMINATION_EXAM_CANCELLATION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_EXAM_CANCELLATION_PRIVILEGES'),
		EXAM_CANCELLATION_PRIVILEGES_APPLY_TO_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_CANCELLATION_PRIVILEGES_APPLY_TO'),
		EXAMINATION_EXAM_CANCELLATION_REQUEST_PRIVILEGES :Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_EXAM_CANCELLATION_REQUEST_PRIVILEGES')
		
	},
	refs: [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	}, {
		ref: 'examcancellationstructure',
		selector: 'examcancellationstructure'
	}, {
		ref: 'examcancellationgrid',
		selector: 'examcancellationgrid'
	}, {
		ref: 'examcancellationfilter',
		selector: 'examcancellationfilter'
	}, {
		ref: 'examcancellationsetupform',
		selector: 'examcancellationsetupform'
	}, {
		ref: 'examcancellationsetupwindow',
		selector: 'examcancellationsetupwindow'
	},{
		ref: 'examcancellationapplytostructure',
		selector: 'examcancellationapplytostructure'
	},{
		ref: 'ecaddmappingtabstructure',
		selector: 'ecaddmappingtabstructure'
	},{
		ref: 'ecaddmappingacademylocationtab',
		selector: 'ecaddmappingacademylocationtab'
	},{
		ref: 'ecaddmappingprogramtab',
		selector: 'ecaddmappingprogramtab'
	},{
		ref: 'ecaddmappingprogrambatchtab',
		selector: 'ecaddmappingprogrambatchtab'
	},{
		ref: 'examcancellationaddmappingstructure',
		selector: 'examcancellationaddmappingstructure'
	},{
		ref: 'examcancellationprogresstracker',
		selector: 'examcancellationprogresstracker'
	},{
		ref: 'examcancellationapplytowindow',
		selector: 'examcancellationapplytowindow'
	},{
		ref: 'ecprogramsassociatedgridwindow',
		selector: 'ecprogramsassociatedgridwindow'
	},{
		ref:'examcancellationrequeststructure',
		selector:'examcancellationrequeststructure'
	},{
		ref:'examcancellationrequestfilter',
		selector:'examcancellationrequestfilter'
	},{
		ref:'examcancellationrequestgrid',
		selector:'examcancellationrequestgrid'
	},{
		ref:'examcancellationapproverejectwin',
		selector:'examcancellationapproverejectwin'
	}],
	init: function() {
		this.control({
			'examcancellationsetupwindow':{
				 afterrender:function(window){
     				$this = this;
     				var filterForm = window.down('form');
     				window.body.on('click',function() {
   						$this.hideInvalidIconFromField(filterForm);
 			       });
     			}  
			},
            'examcancellationrequeststructure': {
            		afterrender: function(structure) {
    					var $this = this;
    					var grid = structure.down('examcancellationrequestgrid');
    					var structureNew = structure.up();
    					if(structure.closable ==  true){
    						 this.getGridHeaderFreeze(grid,structure,true);
    					}
    					else {
    						this.getGridHeaderFreeze(grid,structureNew,true);
    					}
    					
    					setTimeout(function() {
    						$this.addDataGridConfigButton(grid, $this.getEXAMINATION_EXAM_CANCELLATION_REQUEST_PRIVILEGES());
    					}, 1500);
    				}
            	
            },
			'examcancellationstructure': {
				afterrender: function(structure) {
					var $this = this;
					var grid = structure.down('examcancellationgrid');
					var form = structure.down('form');
	                this.getGridHeaderFreeze(grid,form);
					setTimeout(function() {
						$this.addDataGridConfigButton(grid, $this.getEXAMINATION_EXAM_CANCELLATION_PRIVILEGES());
					}, 1500);
				}
			},

			'examcancellationgrid': { 
				render: function(grid) {
					var $this = this;
						 grid.getStore().getProxy().extraParams={
							examCancellationId:null
						}
						grid.getStore().load();
					this.doAccessControlValidation(grid, this.getEXAMINATION_EXAM_CANCELLATION_PRIVILEGES());
					$this.disableMoreActionPivileges(grid, this.getEXAMINATION_EXAM_CANCELLATION_PRIVILEGES());
				},
				selectionchange: function(row, record) {
					var me = this;
					var grid = me.getExamcancellationgrid();
					var btnApplyTo = grid.down('#btnApplyTo');
					btnApplyTo.setDisabled(!grid.getSelectionModel().getSelection().length);
				},
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var me = this;
					var examcancellationgrid = View.up('grid');
					var columnName = View.getGridColumns()[ColIdx].dataIndex;
					if (e.target.tagName == 'A' && columnName == 'mappedPrograms') {
						var examCancellationId = record.data.id;
						var ecprogramsassociatedgridwindow = me.showWindow('ecprogramsassociatedgridwindow');
						ecProgramsassociatedgridwindowStore = ecprogramsassociatedgridwindow.down('grid').getStore();
						ecProgramsassociatedgridwindowStore.removeAll();
						ecProgramsassociatedgridwindowStore.getProxy().extraParams = {
							examCancellationId: examCancellationId
						};
						ecProgramsassociatedgridwindowStore.loadPage(1);
					}
					if(e.target.tagName == 'A' && columnName == "requestReceived"){
						this.openExamCancellationReqTab('REQUEST_RECEIVED');
					
					}
					if(e.target.tagName == 'A' && columnName == "requestApproved"){
						this.openExamCancellationReqTab('REQUEST_APPROVED');
						
					}
					
 			   },
			},
			'examcancellationgrid button[itemId=btnApplyTo]': {
				click: function(button) {
					var me = this;
					var examcancellationgrid = button.up('grid');
					var gridRecord = examcancellationgrid.getSelectionModel().getSelection()[0];
					if (examcancellationgrid.getSelectionModel().getCount() > 0) {
						var examCancellationId = gridRecord.data.id;
						var examCancellationName = gridRecord.data.examCancellationName;
						var contentpanel = me.getContentPanel();
						var applyToTab = Ext.widget('examcancellationapplytostructure', {
							examCancellationId: examCancellationId,
							examCancellationName: examCancellationName,
							sort:null
						});
						var tabName = getCommonTranslation('APPLY_TO');
						var getcontroller = this.getController('menu.CoreERPNavigationController');
						var getTab = getcontroller.getTab(tabName);
						if (getTab != null) {
							contentpanel.remove(getTab, true);
						}
						openTab(contentpanel, tabName, applyToTab,CONSTANTS.MENU_COLOR_FOUR);
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'examcancellationapplytostructure':{
				afterrender: function(structure){
					var me = this;
					var applyToGrid = structure.down('grid');
					var examCancellationId = structure.examCancellationId;
					var applyToGridStore = applyToGrid.getStore();
					applyToGridStore.getProxy().extraParams={
						examCancellationId: examCancellationId,
					};
					this.resetPageSetting(applyToGridStore, applyToGrid)
					applyToGridStore.load();
					
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
					var permissionListThree = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
							associatedAcadLocationIds, me.getEXAM_CANCELLATION_PRIVILEGES_APPLY_TO_PRIVILEGES());

					var btnAdd_Apply_To = structure.down('#btnAdd');
					var btnView_Apply_To = structure.down('#btnView');
					var btnDelete_Apply_To = structure.down('#btnDelete');

					btnAdd_Apply_To.setVisible(false);
					btnView_Apply_To.setVisible(false);
					btnDelete_Apply_To.setVisible(false);

					if((Ext.Array.contains(permissionListThree, 'CREATE'))){
						btnAdd_Apply_To.setVisible(true);
					}

					if((Ext.Array.contains(permissionListThree, 'VIEW'))){
						btnView_Apply_To.setVisible(true);
					}

					if((Ext.Array.contains(permissionListThree, 'DELETE'))){
						btnDelete_Apply_To.setVisible(true);
					} 
			}
			},
			'examcancellationapplytostructure grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var applyToGrid = row.view.up('grid');

						var btnView= applyToGrid.down('#btnView');
						var btnDelete= applyToGrid.down('#btnDelete');

						btnView.setDisabled(!applyToGrid.getSelectionModel().getSelection().length);
						btnDelete.setDisabled(!applyToGrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				}
			},
			'examcancellationsetupform': {
				beforerender: function(obj) {
					var me = this;
					me.saveDFRInfo(me.getCurrentAcademyLocation());
				}
			},
			'examcancellationfilter button[itemId=quickSearchId]': {
				click: function(obj) {
					this.loadExamCancellationGridData(obj);
				}
			},
			'examcancellationfilter button[itemId=resetBtn]': {
				click: function(obj) {
					var form = obj.up('form').getForm();
					form.reset();
				}
			},
			'examcancellationfilter customcombobox[itemId=examCancellationName]': {
				 select:function(obj, rec){
					var form = obj.up('form').getForm();
					var status = form.findField("status");
					status.reset();
				}
			},
			'examcancellationgrid button[itemId=btnAdd]': {
				click: function(button) {
					var me = this;
					var examcancellationsetupwindow = me.showWindow('examcancellationsetupwindow');
					var form = examcancellationsetupwindow.down('form');
					form.down('#status').getStore().load({
						callback: function(record, operation, success) {
							form.down('#status').setValue(record[0].data.id);
						}
					});
				}
			},

			'examcancellationgrid button[itemId=btnEdit]': {
				click: function(button) {
					var me = this;
					var examcancellationgrid = button.up('grid');
					if (examcancellationgrid.getSelectionModel().getSelection().length > 0) {
						var selectedRecord = examcancellationgrid.getSelectionModel().getSelection()[0];
						var formRecord = {
							id: selectedRecord.data.id,
							examCancellationName: selectedRecord.data.examCancellationName,
							maximumCourse: selectedRecord.data.maximumCourse
						};

						var examcancellationsetupwindow = me.showWindow('examcancellationsetupwindow');
						examcancellationsetupwindow.setTitle(getExaminationTranslation('EDIT_EXAM_CANCELLATION_DETAILS'))
						var form = examcancellationsetupwindow.down('form');
						form.down('[name=status]').getStore().load({
							callback: function(records, operation, success) {
								form.getForm().setValues(formRecord);
								if (selectedRecord.data.autoApprove) {
									form.down('[name=autoApprove]').setValue(true);
								} else {
									form.down('[name=autoApprove]').setValue(false);
								}
								form.down('#status').setValue(selectedRecord.data.status);
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}

				}
			},

			'examcancellationgrid button[itemId=btnDelete]': {
				click: function(button) {
					var me = this;
					var examcancellationgrid = button.up('grid');
					var gridRecord = examcancellationgrid.getSelectionModel().getSelection()[0];
					var jsonData = [];
					if (examcancellationgrid.getSelectionModel().getCount() > 0) {
						var submitUrl = SERVERURL.PATH_DELETE_EXAM_CANCELLATION;
						showConfirmMessage(getExaminationTranslation('EXAM_CANCELLATION'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'), function(btn, text) {
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type: 'rest',
									url: submitUrl + '?id=' + gridRecord.data.id,
									method: 'DELETE',
									success: function(response, action) {
										if (response.responseText === "Dependency Exist") {
											Ext.getBody().unmask();
											examcancellationgrid.getStore().loadPage(1);
											showWarningMessage(getExaminationTranslation('EXAM_CANCELLATION'), getExaminationTranslation('RECORD_CANNOT_BE_DELETED_AS_IT_IS_USED_AS_A_REFERENCE'));
										} else {
											Ext.getBody().unmask();
											examcancellationgrid.getStore().loadPage(1);
											showSuccessMessage(getExaminationTranslation('EXAM_CANCELLATION'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
										}
										}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},

			'examcancellationsetupwindow button[itemId=examCancellatationSubmitBtn]': {
				click: function(button) {
					var me = this;
					var form = button.up('form');
					var formWindow = button.up('window');
					me.saveExamCancellationSetup(form, formWindow);
				}
			},
			'examcancellationsetupwindow button[itemId=examCancellatationCancelBtn]': {
				click: function(button) {
					var formWindow = button.up('window');
					formWindow.close();
				}
			},
			'examcancellationaddmappingstructure':{
				afterrender: function(structure){
					var me = this;
					
					var ecProgresstracker = structure.down('examcancellationprogresstracker');
					ecProgresstracker.setVisible(true);
					var progresstracker1 = ecProgresstracker.down("#progresstracker1");
					var progresstracker2 = ecProgresstracker.down("#progresstracker2");
					var progresstracker3 = ecProgresstracker.down("#progresstracker3");
					
					progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker1.textEl.addCls("inProgressCss-progress-text");
					progresstracker1.updateText("Step 1 In Progress");
					
					progresstracker2.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.addCls("x-progress-text x-progress-text-back");
					progresstracker2.updateText("");
					
					var academyLocationTab = structure.down('ecaddmappingacademylocationtab');
					var programBatchTab = structure.down('ecaddmappingprogrambatchtab');
					
					academyLocationTab.down('#examCancellationLabelName').setText(getExaminationTranslation('EXAM_CANCELLATION')+': '+structure.examCancellationName);
					
					academyLocationTab.setDisabled(false);
					programBatchTab.setDisabled(true);
					
					academyLocationTab.down('grid').getStore().load();
					academyLocationTab.down('#academyLocationCombo').getStore().load();
				}
			},
			'examcancellationapplytostructure button[itemId=btnAdd]': {
				click: function(button) {
					var me = this;
					var applyToStructure = button.up('examcancellationapplytostructure');
					var examCancellationId = applyToStructure.examCancellationId;
					var examCancellationName = applyToStructure.examCancellationName;
					var contentpanel = me.getContentPanel();
					var addMappingTab = Ext.widget('examcancellationaddmappingstructure', {
						examCancellationId: examCancellationId,
						examCancellationName: examCancellationName
					});
					var tabName = getCommonTranslation('ADD_MAPPING');
					var getcontroller = this.getController('menu.CoreERPNavigationController');
					var getTab = getcontroller.getTab(tabName);
					if (getTab != null) {
						contentpanel.remove(getTab, true);
					}
					openTab(contentpanel, tabName, addMappingTab);
				}
			},
			'examcancellationapplytostructure button[itemId=btnView]': {
				click: function(button) {
					var me = this;
					var applyToStructure = button.up('examcancellationapplytostructure');
					var applyToGrid = button.up('grid');
					var applyToRecord = applyToGrid.getSelectionModel().getSelection()[0];

					var formRecord = {
						examCancellationName: applyToStructure.examCancellationName,
						academyLocationName: applyToRecord.get('academyLocationName'),
						programName: applyToRecord.get('programName'),
						batchName: applyToRecord.get('batchName')
					};
					var examcancellationapplytowindow = me.showWindow('examcancellationapplytowindow');
					setTimeout(function() {
						var form = examcancellationapplytowindow.down('form');
						form.getForm().setValues(formRecord);
					}, 300);
				}
			},
			'examcancellationapplytowindow button[itemId=applyToWindowCancelBtn]':{
				click: function(button){
					var window = button.up('examcancellationapplytowindow');
					window.close();
				}
			},
			
			'examcancellationapplytostructure button[itemId=btnDelete]':{
				click: function(button){
					var me = this;
					var applyToGrid = button.up('grid');
					var gridRecord=applyToGrid.getSelectionModel().getSelection()[0];
					if(applyToGrid.getSelectionModel().getCount() > 0){
						var submitUrl = SERVERURL.EXAM_CANCELLATION_ASSOCIATED_PROGRAM_DELETE;
						showConfirmMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl+ '?id='+ gridRecord.data.id,
									method : 'DELETE',
									success : function(response, action) {
										Ext.getBody().unmask();
										applyToGrid.getStore().loadPage(1);
										applyToGrid.getSelectionModel().deselectAll();
										showSuccessMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
									}
								});
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			
			'ecaddmappingacademylocationtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var ecaddmappingacademylocationtabgrid = row.view.up('grid');

						var btnNext= ecaddmappingacademylocationtabgrid.down('#academyLocationNextBtn');

						btnNext.setDisabled(!ecaddmappingacademylocationtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				},
				afterrender: function(grid) {
					this.getGridHeaderFreezeForExamCancellationAddMapping(grid, grid.up('examcancellationaddmappingstructure').up('panel'));
				}
			},
			'ecaddmappingacademylocationtab combo[itemId=academyLocationCombo]':{
				select: function(combo){
					var me = this;
					var alId = combo.getValue();

					var grid = combo.up('grid');
					var store = grid.getStore();
					store.clearFilter();
					store.filterBy(function(record, id){
						return (record.get('id') == alId);
					});
					var gridDom = grid.el ? grid.el.dom : null;
                    gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount();
					
				}
			},
			'ecaddmappingacademylocationtab button[itemId=academyLocationResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#academyLocationCombo').reset();
					grid.down('#academyLocationCombo').clearValue();
					grid.down('#academyLocationCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			'ecaddmappingacademylocationtab button[itemId=academyLocationNextBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var ecaddmappingtabstructure = button.up('ecaddmappingtabstructure');
					
					var selectedRecords = grid.getSelectionModel().getSelection();
					var selectedAls = [];
					Ext.each(selectedRecords, function(selectedRecord){
						selectedAls.push(selectedRecord.get('id'));
					});
					
					var structure = button.up('examcancellationaddmappingstructure');
					
					var degreeremarkprogresstracker = structure.down('examcancellationprogresstracker');
					degreeremarkprogresstracker.setVisible(true);
					var progresstracker1 = degreeremarkprogresstracker.down("#progresstracker1");
					var progresstracker2 = degreeremarkprogresstracker.down("#progresstracker2");
					
					for(var i = 0; i < 11; i ++ ){
		    			progresstracker1.updateProgress((i * 0.1), '');
		    		}
		    		progresstracker1.textEl.addCls("custom-progress-text");
		    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
		    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
		    		for(var i = 0; i < 11; i ++ ){
		    			progresstracker2.updateProgress((i * 0.1), '');
		    		}
		    		progresstracker2.textEl.addCls("custom-progress-text");
		    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
		    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
					
					
					var academyLocationTab = structure.down('ecaddmappingacademylocationtab');
					var programBatchTab = structure.down('ecaddmappingprogrambatchtab');
					
					programBatchTab.down('#examCancellationLabelName').setText(getExaminationTranslation('EXAM_CANCELLATION')+': '+structure.examCancellationName);
					
					academyLocationTab.setDisabled(false);
					programBatchTab.setDisabled(false);
					
					ecaddmappingtabstructure.setActiveTab(1);
					
					programBatchTab.down('grid').getStore().getProxy().extraParams={
						'academyLocationIds':selectedAls.join()
					};
					programBatchTab.down('grid').getStore().load();
					programBatchTab.down('#batchCombo').getStore().getProxy().extraParams={
						'academyLocationIds':selectedAls.join()
					};
					programBatchTab.down('#batchCombo').getStore().load();
				}
			},
			
			'ecaddmappingprogrambatchtab grid':{
				selectionchange: function(row, record){
					var me = this;
					try{
						var ecaddmappingprogrambatchtabgrid = row.view.up('grid');

						var btnSubmit= ecaddmappingprogrambatchtabgrid.down('#batchSubmitBtn');

						btnSubmit.setDisabled(!ecaddmappingprogrambatchtabgrid.getSelectionModel().getSelection().length);
					}
					catch(e){}
				},
				afterrender: function(grid) {
					this.getGridHeaderFreezeForExamCancellationAddMapping(grid, grid.up('examcancellationaddmappingstructure').up('panel'));
				}
			},
			'ecaddmappingprogrambatchtab combo[itemId=batchCombo]':{
				select: function(combo){
					var me = this;
					var batchId = combo.getValue();

					var grid = combo.up('grid');
					var store  = grid.getStore();
					store.clearFilter();
					store.filterBy(function(record, id){
						return (record.get('batchId') == batchId);
					});
					var gridDom = grid.el ? grid.el.dom : null;
                    gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount();
				}
			},
			'ecaddmappingprogrambatchtab button[itemId=batchResetBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					grid.getStore().clearFilter();
					
					grid.down('#batchCombo').reset();
					grid.down('#batchCombo').clearValue();
					grid.down('#batchCombo').getStore().clearFilter();
					
					grid.getSelectionModel().deselectAll();
				}
			},
			
			'ecaddmappingprogrambatchtab button[itemId=batchSubmitBtn]':{
				click: function(button){
					var me = this;
					var grid = button.up('grid');
					var gridRecord = grid.getSelectionModel().getSelection();
					var examCancellationId = button.up('examcancellationaddmappingstructure').examCancellationId;
					var examCancellationName=button.up('examcancellationaddmappingstructure').examCancellationName;
					
					var formData = [];
					Ext.each(gridRecord, function(currentRecord){
						formData.push({
							examCancellationId:examCancellationId,
							academyLocationId:currentRecord.get('academyLocationId'),
							programId:currentRecord.get('programId'),
							batchId:currentRecord.get('batchId'),
							examCancellationName:examCancellationName
						});
					});
					me.saveAllMappings(formData);
				}
			},
			'examcancellationrequestfilter' :{
				afterrender: function(){
					var $this = this;
					var currentAcademyArray = [];
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					
					var gridStore = this.getExamcancellationrequestgrid().getStore();
					var examCancellationRequestStructure = this.getExamcancellationrequeststructure();
					examCancellationReqFilter.down('#statusNameItemId').setValue(examCancellationRequestStructure.config.status);
					var statusValue = examCancellationReqFilter.down('#statusNameItemId').getValue();
						
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
					var approveStatus = examCancellationReqFilter.down('#approveStatus');
					
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
					var associatedAcadLocationIds = new Array();
	                var batchName  = examCancellationReqFilter.down('#batchName');
                    var examCancellationGrid = $this.getExamcancellationgrid();

                    if(!isNullOrEmpty(examCancellationGrid)){
                    	var record = examCancellationGrid.getSelectionModel().getSelection()[0];
                    	if(!isNullOrEmpty(record)){
                    		var examCancellationId = record.data.id;
                    	}
                    }
					academyLocation.getStore().getProxy().extraParams={
	                	   id:$this.getCurrentlyLoggedInUser().id
	                }; 
					academyLocation.getStore().load({
  					   callback:function(record) {
  						   for( i = 0;i < record.length; i++) {
  							   if(record[i].data.id == $this.getCurrentAcademyLocation()) {
  								// academyLocation.setValue(record[i].data.id);
					 			associatedAcadLocationIds.push(record[i].data.id); 
  							   }
		                      
  						  }
		 				  academicTerm.getStore().load({
							    callback:function(records,values,data,eval){
								Ext.Array.each(records,function(val){
 				    			if(val.get('sequence') == 1){
 				    				currentAcademyArray.push(val);
 				    			}
 				    			});

 				    			if(currentAcademyArray.length == 1){
 				    			academicTerm.setValue(currentAcademyArray[0].data.id); 
								program.reset();
								program.getStore().getProxy().extraParams={
	                	  			 academicTermId:currentAcademyArray[0].data.id,
									 academyLocationIds: associatedAcadLocationIds.join()
	                			}; 
 				    			} else {
								program.reset();
								program.getStore().getProxy().extraParams={
	                	  			 //academicTermId:currentAcademyArray[0].data.id,
									 academyLocationIds: associatedAcadLocationIds.join()
	                			}; 
								}
								program.getStore().load({
		    	                callback: function(record, operation, success) {
		    	                				 if (success) {
		    	                				   if (record.length == 1) {
		    										   program.setValue(record[0].data.id);
		    	                				       batchName.getStore().getProxy().extraParams={
		    		                					   academyLocationIds:academyLocation.getValue(),
		    		                					   programId:record[0].data.id,
		    		                					   academicTermId:academicTerm.getValue()
		    	                				       };
		    	                				       batchName.reset();
		    	                				  	   batchName.getStore().load({
		            								   callback: function(record, operation, success) {
		            									   if (success) {
		            									   batchName.setDisabled(false);
		            									   if (record.length == 1) {
		            										   batchName.setValue(record[0].data.id);
		            									   }
		            								  }
		    	                				   }
		    	                				   });
 													admissionField.reset();
													admissionField.getStore().getProxy().extraParams={
	                	  								 academyLocationIds:academyLocation.getValue(),
		    		                					 programId:record[0].data.id,
		    		                					 academicTermId:academicTerm.getValue()
	                								}; 
													admissionField.getStore().load();
		    	                				   } else {
						 								 batchName.setDisabled(true).reset();
														 admissionField.reset();
													     admissionField.getStore().getProxy().extraParams={
	                	  								   academyLocationIds:academyLocation.getValue(),
		    		                					   academicTermId:academicTerm.getValue()
	                								     }; 
													    admissionField.getStore().load();
													 }
		    	                				} else {
		    	                					  batchName.setDisabled(false).reset();
		            						}
		    	                		 }
		            	       });
								
							}
							});
  					   }
  				   });
					var structure = $this.getExamcancellationrequeststructure();
					var filter = $this.getExamcancellationrequestfilter();
					var statusNameItemId = filter.down('#statusNameItemId').getValue();
					if(statusNameItemId == "REQUEST_APPROVED" && structure.closable == false) {
						if(!isNullOrEmpty(examCancellationGrid)){
						examCancellationName.getStore().getProxy().extraParams={
							examCancellationName:record.data.examCancellationName
						};
						examCancellationName.getStore().load({
							 callback:function(record) {
									examCancellationName.setValue(record[0].data.id);
								}
						});
						}
					}
					else if(statusNameItemId == "REQUEST_RECEIVED" && structure.closable == false){
							if(!isNullOrEmpty(examCancellationGrid)){
						examCancellationName.getStore().getProxy().extraParams={
							examCancellationName:record.data.examCancellationName
						};
						examCancellationName.getStore().load({
							 callback:function(record) {
									examCancellationName.setValue(record[0].data.id);
								}
						});
						}
					}
						 
					approveStatus.getStore().load({
						callback:function(records, Val){
							 if(statusValue == 'REQUEST_APPROVED' && examCancellationRequestStructure.closable == false){
								approveStatus.setValue(records[1].data.id);
								
							}
						}
					});
				setTimeout(function() {
					var grid = $this.getExamcancellationrequestgrid();
					var structure = $this.getExamcancellationrequeststructure();
					var gridStore = $this.getExamcancellationrequestgrid().getStore();
					var filter = $this.getExamcancellationrequestfilter();
					var statusNameItemId = filter.down('#statusNameItemId').getValue();
					var approveStatus = filter.down('#approveStatus');
					if(statusNameItemId == "REQUEST_APPROVED" && structure.closable == false) {
						gridStore.getProxy().extraParams = {
							approvalStatus : "APPROVED",
							examCancellationId:examCancellationId
					    }
						gridStore.load();
					}
					else if(statusNameItemId == "REQUEST_RECEIVED" && structure.closable == false){
							gridStore.getProxy().extraParams = {
								approvalStatus : approveStatus.getValue(),
								examCancellationId:examCancellationId
						    }
							gridStore.load();
						
					}
					else if(structure.closable == true ){
						if(gridStore.data.items.length >0){
							gridStore.removeAll();
						}
						
					}
					
					}, 1500);
				}
			},
			'examcancellationrequestfilter button[itemId=resetBtn]': {
				click: function(obj) {
					var form = obj.up('form').getForm();
					form.reset();
					var $this = this;
					var currentAcademyArray = [];
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					var structure = this.getExamcancellationrequeststructure();
					var approveStatus = examCancellationReqFilter.down('#approveStatus');
					var examCancellationRequestStructure = this.getExamcancellationrequeststructure();
					examCancellationReqFilter.down('#statusNameItemId').setValue(examCancellationRequestStructure.config.status);
					
					var statusValue = examCancellationReqFilter.down('#statusNameItemId').getValue();
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
				    var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
					var associatedAcadLocationIds = new Array();
					var batchName  = examCancellationReqFilter.down('#batchName');
					var fromDate  = examCancellationReqFilter.down('#fromDate');
					var tillDate  = examCancellationReqFilter.down('#tillDate');
					fromDate.setMinValue(null);
					tillDate.setMinValue(null);
					fromDate.setMaxValue(null);
					tillDate.setMaxValue(null);
					fromDate.reset();
					tillDate.reset();
					examCancellationName.reset();
	                batchName.setDisabled(true).reset();
	                
	                examCancellationName.getStore().getProxy().extraParams={
	                	academyLocationId:null
	                }
	                examCancellationName.getStore().load({
	                	/*callback:function(record, operation, success) {
	                		if (success && record.length == 1) {
	                			examCancellationName.setValue(record[0].data.id);
	                		}
	                	}*/
	                });
					academyLocation.getStore().getProxy().extraParams={
	                	   id:$this.getCurrentlyLoggedInUser().id
	                }; 
					academyLocation.getStore().load({
  					   callback:function(record) {
  						   for( i = 0;i < record.length; i++) {
  							   if(record[i].data.id == $this.getCurrentAcademyLocation()) {
  								// academyLocation.setValue(record[i].data.id);
					 			associatedAcadLocationIds.push(record[i].data.id); 
  							   }
		                      
  						  }
		 				  academicTerm.getStore().load({
							    callback:function(records,values,data,eval){
								Ext.Array.each(records,function(val){
 				    			if(val.get('sequence') == 1){
 				    				currentAcademyArray.push(val);
 				    			}
 				    			});

 				    			if(currentAcademyArray.length == 1){
 				    			academicTerm.setValue(currentAcademyArray[0].data.id); 
								program.reset();
								program.getStore().getProxy().extraParams={
	                	  			 academicTermId:currentAcademyArray[0].data.id,
									 academyLocationIds: associatedAcadLocationIds.join()
	                			}; 
 				    			} else {
								program.reset();
								program.getStore().getProxy().extraParams={
	                	  			 //academicTermId:currentAcademyArray[0].data.id,
									 academyLocationIds: associatedAcadLocationIds.join()
	                			}; 
								}
								program.getStore().load({
		    	                callback: function(record, operation, success) {
		    	                				 if (success) {
		    	                				   if (record.length == 1) {
		    										   program.setValue(record[0].data.id);
		    	                				       batchName.getStore().getProxy().extraParams={
		    		                					   academyLocationIds:academyLocation.getValue(),
		    		                					   programId:record[0].data.id,
		    		                					   academicTermId:academicTerm.getValue()
		    	                				       };
		    	                				       batchName.reset();
		    	                				  	   batchName.getStore().load({
		            								   callback: function(record, operation, success) {
		            									   if (success) {
		            									   batchId.setDisabled(false);
		            									   if (record.length == 1) {
		            										   batchName.setValue(record[0].data.id);
		            									   }
		            								  }
		    	                				   }
		    	                				   });
 													admissionField.reset();
													admissionField.getStore().getProxy().extraParams={
	                	  								 academyLocationIds:academyLocation.getValue(),
		    		                					 programId:record[0].data.id,
		    		                					 academicTermId:academicTerm.getValue()
	                								}; 
													admissionField.getStore().load();
		    	                				   } else {
						 								 batchName.setDisabled(true).reset();
														 admissionField.reset();
													     admissionField.getStore().getProxy().extraParams={
	                	  								   academyLocationIds:academyLocation.getValue(),
		    		                					   academicTermId:academicTerm.getValue()
	                								     }; 
													    admissionField.getStore().load();
													 }
		    	                				} else {
		    	                					  batchId.setDisabled(false).reset();
		            						}
		    	                		 }
		            	       });
								
							}
							});
  					   }
  				   });
					approveStatus.getStore().load({
						callback:function(records, Val){
						 if(statusValue == 'REQUEST_APPROVED'){
								approveStatus.setValue(records[1].data.id);
							}
						}
					});
				}
			},
			
			'examcancellationrequestfilter button[itemId=quickSearchId]': {
				click: function(obj) {
					this.loadExamCancellationRequestGridData(obj);
				}
			},
			
			'examcancellationrequestgrid':{
				afterrender:function(grid){
					this.disableButtonByPivileges(grid, this.getEXAMINATION_EXAM_CANCELLATION_REQUEST_PRIVILEGES());
				},
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var me = this;
					var examcancellationrequestgrid = View.up('grid');
					var approveRejectBtn = examcancellationrequestgrid.down('#approveRejectBtn');
					
					var columnName = View.getGridColumns()[ColIdx].dataIndex;
					if (e.target.tagName == 'A' && columnName == 'documentId') {
					  if (!isNullOrEmpty(record.data.documentId)) {
		            	    me.getDocumentController().downloadDocumentFile(record.data.documentId);
		              }
					}
 			   },
 			
 			  deselect:function(column, selected,eOpts) {
 				  var grid = this.getExamcancellationrequestgrid();
 	 				var records =  grid.getStore().data.items;
 	 				var btn = grid.down('#approveRejectBtn');
 	 				
 	 				var flagArray = [];
 	 				for(var i = 0;i< records.length;i++){
		    			var requestStatus = records[i].data.status;
		    			var isSelect = column.view.isSelected(i);
		    			
		    			if(isSelect && requestStatus ==  "APPLIED"){
		    				flagArray.push(records[i]);
		    				
		    			}
		    		}
	    			 if(flagArray.length < 1){
	    				 btn.setDisabled(true);
	    			 }
	    			
 			  },
 			  select: function(column, selected,eOpts){
 				  var grid = this.getExamcancellationrequestgrid();
 	 				var records =  grid.getStore().data.items;
 	 				var btn = grid.down('#approveRejectBtn');
 	 				if(selected.data.status==="APPROVED" || selected.data.status==="CANCELLED" ||selected.data.status==="REJECTED"){
 	 					grid.getSelectionModel().deselect(eOpts);
 	 				}
 	 				if(selected.data.status==="APPLIED"){
 	 					btn.setDisabled(false);
 	 				}
 			  }
			},
			'examcancellationrequestgrid button[itemId=approveRejectBtn]':{
				click:function(){
					var examCancellationWimdow = this.getExamcancellationapproverejectwin();
					if(isNullOrEmpty(examCancellationWimdow)){
						examCancellationWimdow = Ext.widget('examcancellationapproverejectwin');
					}
					 var grid = this.getExamcancellationrequestgrid();
					 var recordLength = grid.getSelectionModel().getCount();
					 var statusArray =[];
					 if(recordLength > 0){
						 var records = grid.getSelectionModel().getSelection();
						 for(var i in records){
							 if(records[i].data.status==="APPLIED"){
								 statusArray.push(records[i].data.status);
							 }
						 }
						 if(statusArray[0] =="APPLIED" )
							 examCancellationWimdow.show();
						 }
					 else{
						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					 }
				}
			},
			
			'examcancellationapproverejectwin' :{
				afterrender: function() {
					var examCancellationWimdow = this.getExamcancellationapproverejectwin();
					var status=examCancellationWimdow.down('#status');
					status.getStore().load({
						callback:function(record, operation, success) {
							status.setValue(record[0].data.value);
						}
					});
					
				}
			},
			'examcancellationapproverejectwin button#submitBtn' : {
	          click : function(obj, record) {
	                obj.setDisabled(true);
					var $this=this; 
					var examCancellationWimdow = this.getExamcancellationapproverejectwin();
					var status=examCancellationWimdow.down('#status').getValue();
					var approvalRemark=examCancellationWimdow.down('#approvalRemark').getValue();
					var examcancellationRequestgrid = $this.getExamcancellationrequestgrid();
					var gridRecord = examcancellationRequestgrid.getSelectionModel().getSelection();
	                if(gridRecord.length>0){
						   var arrayData=[];
	                       for(var i in gridRecord) {
	                		 if(!isNullOrEmpty(gridRecord[i].data.id)) {
		                			json={
		                				 'value':approvalRemark,
		                				 'code':status,
										 'id':gridRecord[i].data.id
	                				      }
 									arrayData.push(json);
	                		  }
						    }
	                		//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

	                		Ext.Ajax.request({
  	    	            	type: 'rest',
  	    	            	url: SERVERURL.PATH_EXAM_CANCELLATION_REQUEST_SAVE_REQUEST,
  	    	            	jsonData: arrayData,
  	    	            	method: 'POST',
       	                	success : function(response, action) {
							   Ext.getBody().unmask();
							     if(status == "Approved"){
							    	 showSuccessMessage(getCommonTranslation('EXAM_CANCELLATION_REQUESTS'), getCommonTranslation('EXAM_CANCELLATION_REQUEST_HAS_BEEN_APPROVED'));
    	                				
							     }
							     else if(status == "Rejected"){
							    	 showSuccessMessage(getCommonTranslation('EXAM_CANCELLATION_REQUESTS'), getCommonTranslation('EXAM_CANCELLATION_REQUEST_HAS_BEEN_REJECTED'));
    	                				
							     }
       		                			examcancellationRequestgrid.getSelectionModel().deselectAll();
       	                				examcancellationRequestgrid.getStore().load({
       	                					callback:function(record){
       	                					 var store = examcancellationRequestgrid.getStore();
											 if(store.getRange().length == 0){
												 examcancellationRequestgrid.down('#approveRejectBtn').setDisabled(true);
											 }
											 else{
												 examcancellationRequestgrid.down('#approveRejectBtn').setDisabled(false);
											 }
       	                				  }
       	                				});
       	                				examCancellationWimdow.close();
       	                		}
       	                	 }); 
	                				   
	                	     } else {
	                		      showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                 		 }
						}
	          },
			
			'examcancellationapproverejectwin button[itemId=cancelBtn]' :{
				click:function(){
					var examCancellationWimdow = this.getExamcancellationapproverejectwin();
					if(!isNullOrEmpty(examCancellationWimdow)){
						examCancellationWimdow.close();
					}
				}
			},
			'examcancellationrequestfilter customcombobox[itemId=academyLocationItemId]':{
				select:function(combo,records){
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					
					program.reset();
					program.getStore().getProxy().extraParams={
	                	  			 academicTermId:academicTerm.getValue(),
									 academyLocationIds: records[0].data.id
	                }; 
					program.getStore().load();
					 var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
					examCancellationName.reset();
					examCancellationName.getStore().getProxy().extraParams={
	                	  			 academicTermId:academicTerm.getValue(),
									 academyLocationId: records[0].data.id
	                }; 
					examCancellationName.getStore().load({
	                	callback:function(record, operation, success) {
	                		if (success && record.length == 1) {
	                			examCancellationName.setValue(record[0].data.id);
	                		}
	                	}
	                });
				}
			},
			'examcancellationrequestfilter customcombobox[itemId=academicTermItemId]':{
				select:function(combo,records){
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					var batchName  = examCancellationReqFilter.down('#batchName');
					var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
					 var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
				    examCancellationName.reset();
					
					//sending current AL for V2D-302433
					var alId;
					var me = this;
					if(isNullOrEmpty(academyLocation.getValue())){
						alId = me.getCurrentlyLoggedInUser().id;	
					}else{
					 	alId = academyLocation.getValue()
					}


					program.reset();
					program.getStore().getProxy().extraParams={
						academicTermId:records[0].data.id,
						academyLocationIds: alId
	                }; 
					program.getStore().load({
		    	               callback: function(record, operation, success) {
		    	                				 if (success) {
		    	                				   if (record.length == 1) {
		    										   program.setValue(record[0].data.id);
		    	                				       batchName.getStore().getProxy().extraParams={
		    		                					   academyLocationIds:alId,
		    		                					   programId:record[0].data.id,
		    		                					   academicTermId:academicTerm.getValue()
		    	                				       };
		    	                				       batchName.reset();
		    	                				  	   batchName.getStore().load({
		            								   callback: function(record, operation, success) {
		            									   if (success) {
		            									   batchName.setDisabled(false);
		            									   if (record.length == 1) {
		            										   batchName.setValue(record[0].data.id);
																examCancellationName.getStore().getProxy().extraParams={
									                	  		academicTermId:academicTerm.getValue(),
																batchId :record[0].data.id,
																academyLocationId: alId
						              					  }; 
		            									   }
		            								  }
		    	                				   }
		    	                				   });
 													admissionField.reset();
													admissionField.getStore().getProxy().extraParams={
	                	  								 academyLocationIds:academyLocation.getValue(),
		    		                					 programId:program.getValue(),
		    		                					 academicTermId:academicTerm.getValue()
	                								}; 
													admissionField.getStore().load();
													examCancellationName.getStore().getProxy().extraParams={
							                	  		academicTermId:academicTerm.getValue(),
														programId:program.getValue(),
														academyLocationId: academyLocation.getValue()
						              			   }; 
													examCancellationName.getStore().load({
									                	callback:function(record, operation, success) {
									                		if (success && record.length == 1) {
									                			examCancellationName.setValue(record[0].data.id);
									                		}
									                	}
									                });
		    	                				   } else {
						 								 batchName.setDisabled(true).reset();
														 admissionField.reset();
													     admissionField.getStore().getProxy().extraParams={
	                	  								   academyLocationIds:academyLocation.getValue(),
		    		                					   academicTermId:academicTerm.getValue()
	                								     }; 
													    admissionField.getStore().load();
													    examCancellationName.getStore().getProxy().extraParams={
								                	  		academicTermId:academicTerm.getValue(),
															academyLocationId: academyLocation.getValue()
							              			   }; 
													    examCancellationName.getStore().load({
										                	callback:function(record, operation, success) {
										                		if (success && record.length == 1) {
										                			examCancellationName.setValue(record[0].data.id);
										                		}
										                	}
										                });
													 }
		    	                				} else {
		    	                					  batchId.setDisabled(false).reset();
		            						}
		    	                		 }
		            	       });
				}
			},
			'examcancellationrequestfilter customcombobox[itemId=programNameItemId]':{
				select:function(combo,records){
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var batchName  = examCancellationReqFilter.down('#batchName');
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
					var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
					examCancellationName.reset();
					
					//sending current AL for V2D-302433
					var alId;
					var me = this;
					if(isNullOrEmpty(academyLocation.getValue())){
						alId = me.getCurrentlyLoggedInUser().id;	
					}else{
					 	alId = academyLocation.getValue()
					}
					
					batchName.enable();
					batchName.reset();
					batchName.getStore().getProxy().extraParams={
	    	  			 academicTermId:academicTerm.getValue(),
					  	 programId:records[0].data.id,
						 academyLocationIds:alId
	                }; 
					batchName.getStore().load({
		            	callback: function(record, operation, success) {
		            			if (success) {
		            				 batchName.setDisabled(false);
		            				 if (record.length == 1) {
		            				 batchName.setValue(record[0].data.id);
 										 admissionField.reset();
				   						 admissionField.getStore().getProxy().extraParams={
	                	   				    academyLocationIds:academyLocation.getValue(),
		    		     				    academicTermId:academicTerm.getValue(),
 										    programId:records[0].data.id,
											batchId:record[0].data.id
	                				     }; 
									     admissionField.getStore().load();
										examCancellationName.getStore().getProxy().extraParams={
				                	  		academicTermId: academicTerm.getValue(),
											batchId:batchName.getValue(),
											academyLocationId: academyLocation.getValue()
			              			  	}; 
		            				 } else {
										 admissionField.reset();
				   						 admissionField.getStore().getProxy().extraParams={
	                	   				   academyLocationIds:academyLocation.getValue(),
		    		     				   academicTermId:academicTerm.getValue(),
 										   programId:program.getValue(),
	                				     }; 
									     admissionField.getStore().load();
										 examCancellationName.getStore().getProxy().extraParams={
					                	  		academicTermId: academicTerm.getValue(),
												programId:program.getValue(),
												academyLocationId: academyLocation.getValue()
			              			    }; 
		                             }
		            				 examCancellationName.getStore().load({
		         	                	callback:function(record, operation, success) {
		         	                		if (success && record.length == 1) {
		         	                			examCancellationName.setValue(record[0].data.id);
		         	                		}
		         	                	}
		         	                });
		            			 }
		    	              }
		    	         });
				  }
			 },
			
			'examcancellationrequestfilter customcombobox[itemId=batchName]':{
				select:function(combo,records){
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var batchName  = examCancellationReqFilter.down('#batchName');
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
					 var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
				    examCancellationName.reset();
					admissionField.reset();
				    admissionField.getStore().getProxy().extraParams={
	                	    academyLocationIds:academyLocation.getValue(),
		    		        academicTermId:academicTerm.getValue(),
 							programId:program.getValue(),
							batchId:records[0].data.id,
	                }; 
					admissionField.getStore().load();
					examCancellationName.getStore().getProxy().extraParams={
		    	  		academicTermId: academicTerm.getValue(),
						programId:program.getValue(),
						academyLocationId: academyLocation.getValue()
		  			  };
					examCancellationName.getStore().load({
	                	callback:function(record, operation, success) {
	                		if (success && record.length == 1) {
	                			examCancellationName.setValue(record[0].data.id);
	                		}
	                	}
	                });
					
				}
			},
			'examcancellationrequestfilter customcombobox[itemId=admissionCodeSTDName]':{
				select:function(combo,records){
					var examCancellationReqFilter = this.getExamcancellationrequestfilter();
					var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
					var batchName  = examCancellationReqFilter.down('#batchName');
					var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
					var program = examCancellationReqFilter.down('#programNameItemId');
					var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
					var examCancellationName  = examCancellationReqFilter.down('#examCancellationName');
				    examCancellationName.reset();
					examCancellationName.getStore().getProxy().extraParams={
        	  		academicTermId: academicTerm.getValue(),
						programId:program.getValue(),
						academyLocationId: academyLocation.getValue(),
						admissionId:admissionField.getValue(),
						batchId:batchName.getValue()
      			  	};
					examCancellationName.getStore().load({
	                	callback:function(record, operation, success) {
	                		if (success && record.length == 1) {
	                			examCancellationName.setValue(record[0].data.id);
	                		}
	                	}
	                });
					
				}
			}
		});
	},
	disableMoreActionPivileges: function(gridReference, permissionsMap) {

		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var button = gridReference.down('#btnApplyTo');
		button.setVisible(false);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'APPLY') {
				if (!isNullOrEmpty(button)) {
					button.setVisible(true);
				}
			}
		});
	},
	disableButtonByPivileges :function(gridReference, permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var button = gridReference.down('#approveRejectBtn');
		var exportPdfBtn = gridReference.down('#btnExportToPDF');
		var exportExcelbtn = gridReference.down('#btnExportToExcel');
		button.setVisible(false);
		exportPdfBtn.setVisible(false);
		exportExcelbtn.setVisible(false);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'APPROVE_OR_REJECT') {
				if (!isNullOrEmpty(button)) {
					button.setVisible(true);
				}
			}
			else if (privilege === 'EXPORT') {
				if (!isNullOrEmpty(button)) {
					exportPdfBtn.setVisible(true);
					exportExcelbtn.setVisible(true);
				}
			}
		});
	},
	saveDFRInfo: function(academyLocationId) {
		Ext.Ajax.request({
			url: SERVERURL.COMMON_FORM_FIELD_INFO,
			method: 'GET',
			async: false,
			params: {
				academyLocationId: academyLocationId,
				languageCode: 'en'
			},
			success: function(response) {
				var json = JSON.parse(response.responseText);
				var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
				fieldInfo.set("formFieldsInfo", json);
			}
		});

	},

	saveExamCancellationSetup: function(form, formWindow) {
		var me = this;
		var formValues = form.getForm().getValues();		
		var id = formValues.id;
		var programMarkingType = formValues.markingType;
		var examCancellationName = formValues.examCancellationName;
		var btn = formWindow.down('#examCancellatationSubmitBtn');
		btn.setDisabled(true);
		var isUpdate = false;
		var submitUrl = SERVERURL.PATH_SAVE_UPDATE_EXAM_CANCELLATION;
		if (isNullOrEmpty(id)) {
			isUpdate = false;
			var formData = {
				examCancellationName: formValues.examCancellationName,
				maximumCourse: formValues.maximumCourse,
				status: formValues.status,
				autoApprove: formValues.autoApprove
			};
		} else {
			isUpdate = true;
			var formData = {
				id: id,
				examCancellationName: formValues.examCancellationName,
				maximumCourse: formValues.maximumCourse,
				status: formValues.status,
				autoApprove: formValues.autoApprove
			};
		}

		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: submitUrl,
			jsonData: formData,
			method: 'POST',
			success: function(response, form) {
				Ext.getBody().unmask();
				formWindow.close();
				me.getExamcancellationgrid().getStore().loadPage(1);
				me.getExamcancellationgrid().getSelectionModel().deselectAll();
				if (response.responseText === "Dependency Exist") {
					showWarningMessage(getExaminationTranslation('EXAM_CANCELLATION'), getExaminationTranslation('RECORD_CANNOT_BE_EDITED_AS_IT_IS_USED_AS_A_REFERENCE'));
				}
				else if (response.responseText === "NOT_UNIQUE") {
					showWarningMessage(getExaminationTranslation('EXAM_CANCELLATION'), getExaminationTranslation('DUPLICATE_EXAM_CANCELLATION_NAME'));
				}
				else {
					if (isUpdate) {
						showSuccessMessage(getExaminationTranslation('EXAM_CANCELLATION'), getExaminationTranslation('EXAM_CANCELLATION_UPDATED_SUCCESSFULLY'));
					} else {
						showSuccessMessage(getExaminationTranslation('EXAM_CANCELLATION'), getExaminationTranslation('EXAM_CANCELLATION_ADDED_SUCCESSFULLY'));
					}
				}
			},
			failure: function(result, request) {
				showWarningMessage(getExaminationTranslation('EXAM_CANCELLATION'), getExaminationTranslation('RECORD_CANNOT_BE_EDITED_AS_IT_IS_USED_AS_A_REFERENCE'));
				return false;
			}
		});
	},

	loadExamCancellationGridData: function() {
		var $this = this;
		var form = $this.getExamcancellationfilter()
		var filterForm = $this.getExamcancellationfilter().getForm();
		var examcancellationgrid = $this.getExamcancellationgrid();
		var filterFormValues = filterForm.getValues();

		var examCancellationName = filterForm.findField('examCancellationName');
		var status = filterForm.findField('status');

		examcancellationgrid.getStore().getProxy().extraParams = {
			examCancellationName: examCancellationName.getValue(),
			status: status.getValue()
		};
		$this.resetGridSetting(examcancellationgrid);
		examcancellationgrid.getSelectionModel().deselectAll();
		$this.resetPageSetting(examcancellationgrid.getStore(), examcancellationgrid); 
		examcancellationgrid.getStore().pageSize = 100;
		examcancellationgrid.getStore().load();
		examcancellationgrid.config.searchFilterForm = form;
	},
	
	saveAllMappings: function(formData){
		var me = this;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.EC_ASSOCIATED_PROGRAM_SAVE_ALL_URL,
			jsonData: formData,
			method: 'POST',
			success: function(response, form) {
				Ext.getBody().unmask();
				var responseJson = Ext.decode(response.responseText);
				if(responseJson.length==0){
					showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('EXAM_CANCELLATION_MAPPED_SUCCESS_MSG'));	
					try{
						me.getContentPanel().getActiveTab().close();
						me.getExamcancellationapplytostructure().down('grid').getStore().loadPage(1);
					}
					catch(e){}
				}
				else if(responseJson.length>0){
					
					var notMappedArray = [];
					Ext.each(responseJson, function(currentRecord){
						if(currentRecord.examCancellationId!=me.getContentPanel().getActiveTab().down('examcancellationaddmappingstructure').examCancellationId){
							notMappedArray.push(currentRecord);
						}
					});
					
					if(notMappedArray.length==0){
						showWarningMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('EXAM_CANCELLATION_ALREADY_MAPPED_MSG'));	
						try{
							me.getContentPanel().getActiveTab().close();
							me.getExamcancellationapplytostructure().down('grid').getStore().loadPage(1);
						}
						catch(e){}
					}
					else{
						var responseJson = notMappedArray;
						var messageText = getExaminationTranslation('OTHER_EXAM_CANCELLATION_IS_ALREADY_MAPPED_WITH_THE_FOLLOWING_PROGRAMS_AND_BATCHES');
						messageText = messageText + "<p style=\"height: auto;max-height:100px;display:block;float:left;width:100%;overflow-y:auto;\">";
						Ext.each(responseJson, function(currentBatchDetail){
							messageText = messageText+currentBatchDetail.programName+" and "+currentBatchDetail.batchName+"<br />";
						});
						messageText = messageText+"</p><br />"+getExaminationTranslation('DO_YOU_STILL_WANT_TO_MAP_THE_EXAM_CANCELLATION');

						var newFormData = [];
						Ext.each(responseJson, function(currentRecord){
							newFormData.push({
								examCancellationId:me.getContentPanel().getActiveTab().down('examcancellationaddmappingstructure').examCancellationId,
								academyLocationId:currentRecord.academyLocationId,
								programId:currentRecord.programId,
								batchId:currentRecord.batchId,
								id:currentRecord.id,
								examCancellationName:me.getContentPanel().getActiveTab().down('examcancellationaddmappingstructure').examCancellationName,
							});
						});

						showConfirmMessage(getCommonTranslation('APPLY_TO'),messageText, function(btn, text) {
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.EC_ASSOCIATED_PROGRAM_SAVE_UPDATE_URL,
									jsonData: newFormData,
									method: 'POST',
									success: function(form, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getExaminationTranslation('EXAM_CANCELLATION_MAPPED_SUCCESS_MSG'));	
										try{
											me.getContentPanel().getActiveTab().close();
											me.getExamcancellationapplytostructure().down('grid').getStore().loadPage(1);
										}
										catch(e){}
									}
								});
							}
							else{
								Ext.getBody().unmask();
								//showSuccessMessage(getCommonTranslation('ADD_MAPPING'), getCommonTranslation('DEGREE_CLASSIFICATION_MAPPED_SUCCESS_MSG'));	
								try{
									me.getContentPanel().getActiveTab().close();
									me.getExamcancellationapplytostructure().down('grid').getStore().loadPage(1);
								}
								catch(e){}
							}
						});
					}
				}
				else{
					showWarningMessage(getCommonTranslation('ALERT'),response.responseText);
				}
			},
			failure: function(response){
				console.log(response);
			}
		});
	},
	
	loadExamCancellationRequestGridData : function() {
		var $this = this;
		var examCancellationReqFilter=$this.getExamcancellationrequestfilter()
		var filterForm = $this.getExamcancellationrequestfilter().getForm();
		var examcancellationRequestgrid = $this.getExamcancellationrequestgrid();
		var filterFormValues = filterForm.getValues();

		var academyLocation  = examCancellationReqFilter.down('#academyLocationItemId');
		var batchName  = examCancellationReqFilter.down('#batchName');
		var academicTerm = examCancellationReqFilter.down('#academicTermItemId');
		var program = examCancellationReqFilter.down('#programNameItemId');
		var admissionField = examCancellationReqFilter.down('#admissionCodeSTDName');
		var approveStatus = examCancellationReqFilter.down('#approveStatus');
		var fromDate = examCancellationReqFilter.down('#fromDate');
		var tillDate = examCancellationReqFilter.down('#tillDate');
		var examCancellationName = examCancellationReqFilter.down('#examCancellationName');

		examcancellationRequestgrid.getStore().getProxy().extraParams = {
			academyLocationId: academyLocation.getValue(),
			academicTermId: academicTerm.getValue(),
			programId: program.getValue(),
			batchId: batchName.getValue(),
			admissionId: admissionField.getValue(),
			approvalStatus: approveStatus.getValue(),
			fromDate: fromDate.getValue(),
			tillDate: tillDate.getValue(),
			examCancellationId:examCancellationName.getValue()
		};
		$this.resetGridSetting(examcancellationRequestgrid);
		examcancellationRequestgrid.getSelectionModel().deselectAll();
		examcancellationRequestgrid.getStore().load();
		examcancellationRequestgrid.down('#approveRejectBtn').setDisabled(true);
		examcancellationRequestgrid.config.searchFilterForm = examCancellationReqFilter;
	},
	
	getDocumentController : function() {
	    		    	var this$ = this;
	    		    	return this$.getController('Academia.controller.document.DocumentController');
    },
    openExamCancellationReqTab: function(statusValue){
      	var permissionsMap = this.getEXAMINATION_EXAM_CANCELLATION_REQUEST_PRIVILEGES();
    	var privilegeArray = [];
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var flag = true; 
		Ext.each(permissionList, function(privilege) {
			if (privilege == 'VIEW') {
				 flag = false;
			}
		});
		 if(flag){
				showErrorMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('HRM_YOU_DO_NOT_HAVE_PERMISSION_ACCESS_MSG'));
				return;
			}
		 else{
			 var examCancellationRequestStructure = Ext.widget('examcancellationrequeststructure', {							
				});
			
			
    			var contentPanel = this.getContentPanel();
    			 var structure = contentPanel.down('examcancellationrequeststructure');
    			 
    			   if(structure != null && structure.itemId == "examcancellationrequeststructureId"){
    				   contentPanel.remove(structure);
    			   }
    	       	   var tabName =  getCommonTranslation('EXAM_CANCELLATION_REQUESTS');
    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
    	       	   var getTab=getcontroller.getTab(tabName);
    	       	   if(getTab!=null){
    	       		   contentPanel.remove(getTab, true);
    	       	   }
    	       	examCancellationRequestStructure.config.status = statusValue;
    	        openTab(contentPanel, tabName, examCancellationRequestStructure,CONSTANTS.MENU_COLOR_FOUR);
    	        
    	        
    			
		 }
    }

});