/**
 * @Author Ankush.solanki
 */
Ext.define('Academia.controller.examinationOBEAttainment.ObeAttainmenRuleController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['examinationOBEAttainment.AttainmentLevelGridModel'],
	
	stores : ['examinationOBEAttainment.AttainmentRuleGridStore',
			  'examinationOBEAttainment.AttainmentLevelGridStore'],
			  
	views : ['baselayout.contentarea.ContentPanel',
			 'examinationOBEAttainment.obeAttainmentRuleStructure',
			 'examinationOBEAttainment.AttainmentRuleGrid',
			 'examinationOBEAttainment.AttainmentLevelGrid','examinationOBEAttainment.ExamAttainmentLevelAddForm',
			 'examinationOBEAttainment.ExamAttainmentLevelAddWindow'],	
	config:{
		OBE_ATTAINMENT_RULES_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('OBE_ATTAINMENT_RULES_PRIVILEGES'),
		},	
	refs : [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	},{
			ref:'attainmentrulegrid',
			selector:'attainmentrulegrid'
	},{
		ref:'attainmentlevelgrid',
		selector:'attainmentlevelgrid'
},{
	ref:'examattainmentleveladdwindow',
	selector:'examattainmentleveladdwindow'
}],
	init : function() {
		this.control({
			'examattainmentleveladdwindow button[itemId=submitBtn]':{
				click: function(button){
					var me = this;
					var form = button.up('form');
					var formWindow = button.up('window');
					me.saveAttainmentRule(form, formWindow);
				}
			},
			'examattainmentleveladdwindow button[itemId=cancelBtn]':{
				click: function(button){
					var formWindow = button.up('window');
					formWindow.close();
				}
			},
			'attainmentrulegrid':{
				afterrender:function(grid){
					var me = this;
					me.doAccessControlValidation(grid,this.getOBE_ATTAINMENT_RULES_PRIVILEGES());
					me.resetPageSetting(grid.getStore(), grid);
					grid.getStore().getProxy().extraParams = {
			               limit: grid.getStore().pageSize,
			               sort:null
	                };
					grid.getStore().load();
				},
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var me = this;
					var degreeclassificationgrid = View.up('grid');
					if (e.target.tagName == 'A') {
						var classificationId = record.data.id;
						var programsassociatedgridwindow = me.showWindow('programsassociatedgridwindow');
						programsassociatedgridwindowStore = programsassociatedgridwindow.down('grid').getStore();
						programsassociatedgridwindowStore.removeAll();
						programsassociatedgridwindowStore.getProxy().extraParams = {
							classificationId: classificationId
						};
						programsassociatedgridwindowStore.load();
					}
 			   },
 			   selectionchange: function(row, record){
 				   var me = this;
 				   try{
 					   var attainmentrulegrid = row.view.up('grid');
 					   var btnEdit_dc= attainmentrulegrid.down('#btnEdit');
 					   var btnDelete_dc= attainmentrulegrid.down('#btnDelete');

 					  btnEdit_dc.setDisabled(!attainmentrulegrid.getSelectionModel().getSelection().length);
 					  btnDelete_dc.setDisabled(!attainmentrulegrid.getSelectionModel().getSelection().length);

 					   var attainmentlevelgrid = attainmentrulegrid.up('obeattainmentrulestructure').down('attainmentlevelgrid');
 					   var attainmentlevelgridStore = attainmentlevelgrid.getStore();
 					   var btnAdd_cr = attainmentlevelgrid.down('#btnAdd');
 					   var btnSave = attainmentlevelgrid.down('#btnSaveItemId');
    				   attainmentlevelgrid.getSelectionModel().deselectAll();
 					   if(attainmentrulegrid.getSelectionModel().getSelection().length){
 						   var attainmentRuleId = record[0].data.id;
 						  attainmentlevelgridStore.getProxy().extraParams = {
 							 attainmentRuleId: attainmentRuleId
 						   }
 						   btnAdd_cr.setDisabled(false);
 						   btnSave.setDisabled(false);
 						   attainmentlevelgridStore.load({
 							  callback: function(records, operation, success) {
 								 if(!isNullOrEmpty(records) && records.length>0){
 									 btnAdd_cr.setVisible(false);
 								 }else{
 									 btnAdd_cr.setVisible(true);
 								 }
 							  }
 						   });
 					   }
 					   else{
 						   attainmentlevelgridStore.removeAll();
 						   btnEdit_cr.setDisabled(true);
 						   btnDelete_cr.setDisabled(true);
 					   }
 				   }
 				   catch(e){}
 			   }
			},
			'attainmentrulegrid button[itemId=btnAdd]':{
				click: function(button){
					var me = this;
					var examattainmentleveladdwindow = me.showWindow('examattainmentleveladdwindow');
				}
			},
			'attainmentrulegrid button[itemId=btnEdit]':{
				click: function(button){
					var me = this;
					var attainmentrulegrid = button.up('grid');
					var levelGrid = me.getAttainmentlevelgrid();
					var selectedRecord = attainmentrulegrid.getSelectionModel().getSelection()[0];
					var formRecord = {
							id:selectedRecord.data.id,
							examAttainmentRuleName:selectedRecord.data.value
							
					};
					var examattainmentleveladdwindow = me.showWindow('examattainmentleveladdwindow');
					var form = examattainmentleveladdwindow.down('form');
					form.getForm().setValues(formRecord);
				}
			},
			'attainmentrulegrid button[itemId=btnDelete]':{
				click: function(button){
					var me = this;
					var attainmentrulegrid = button.up('grid');
					var gridRecord=attainmentrulegrid.getSelectionModel().getSelection()[0];
					var jsonData=[];
					if(attainmentrulegrid.getSelectionModel().getCount() > 0){
						var submitUrl = SERVERURL.PATH_ATTAINMENT_RULE_DELETE;
						showConfirmMessage(getExaminationTranslation('ATTAINMENT_RULES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl+ '?id='+ gridRecord.data.id,
									method : 'DELETE',
									success : function(response, action) {
										if(response.responseText=="SUCCESS"){
											Ext.getBody().unmask();
											attainmentrulegrid.getStore().loadPage(1);
											attainmentrulegrid.getSelectionModel().deselectAll();
											showSuccessMessage(getExaminationTranslation('ATTAINMENT_RULES'), getExaminationTranslation('ATTAINMENT_RULE_DELETE_SUCCESS'));
										}else if(response.responseText=="DEPENDENCY_EXIST"){
											Ext.getBody().unmask();
											showWarningMessage(getExaminationTranslation('ATTAINMENT_RULES'), getErrorTranslation('cannot_delete_awardee_as_already_used'));
										}
									}
								});
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'attainmentlevelgrid button[itemId=btnAdd]':{
   			 click: function(button) {
				 var grid = this.getAttainmentlevelgrid();
				 var getAttainmentLevelStruc = grid.up('attainmentlevelgrid');
				 this.addNewRowInAttainmentRuleDetailsGrid(1, grid, getAttainmentLevelStruc);
			 }
			},
			'attainmentlevelgrid': {
				 render: function(grid) {
    				 var structure = grid.up('obeattainmentrulestructure');
         	         this.getGridHeaderFreeze(grid,structure);
         	         this.doAccessControlValidation(grid,this.getOBE_ATTAINMENT_RULES_PRIVILEGES());
    			 },
    			 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				 var $this = this;
    				 var grid = $this.getAttainmentlevelgrid();
    				 var getAttainmentLevelStruc = grid.up('attainmentlevelgrid');
    				 var saveBtn = grid.down('#btnSaveItemId');
    				 var columnName = grid.columnManager.columns[cellIndex].dataIndex;
    				 if(record.length >0){
    					 saveBtn.enable();
    				 }
    				 if(record.data.isAttainmentRuleMapping){
    				
    					 if(columnName == "deleteButton"){
    						 showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('cannot_delete_awardee_as_already_used'));
    						 return false;
    					 }
    					 showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('CAMPAIGN_MASTER_DEPENDENCY_EXIST_ON_EDIT'));
    					 return false;
    				 }else if(record.data.isAttainmentRuleMapping && columnName == "deleteButton"){
    					
    				 }
    				 if (e.target.tagName == 'DIV') {
    					 if (columnName == "addButton") {
    						 if (e.target.className == "addButtonClsForGridActionCls") {
    							 if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
    								 var serialNo;
    								 if (grid.getStore() != null)
    									 serialNo = grid.getStore().getCount();
    								 this.addNewRowInAttainmentRuleDetailsGrid(serialNo + 1, grid, getAttainmentLevelStruc);
    							 }
    						 }
    					 } else if (columnName == "deleteButton") {
    						 if (e.target.className == "deleteButtonClsForGridActionCls") {
    							 var mapAttainmentLevelStructure = $this.getAttainmentlevelgrid();
    							 var titleMessage = getExaminationTranslation('ATTAINMENT_LEVELS');
    							 $this.deleteAttainmentLevelDetails(grid,record,mapAttainmentLevelStructure,titleMessage,rowIndex);

    						 }
    					 }
    				 }
    			 }
    		 },
    		 'attainmentlevelgrid button[itemId=btnSaveItemId]':{
		 			click: function(obj){
		 				this.examSaveManageAttainmentLevelrecord()
		 			}
				}
		});
	},
	saveAttainmentRule: function(form, formWindow) {
		var me = this;
		var formValues = form.getForm().getValues();
		var id = formValues.id;
		var examAttainmentRuleName = formValues.examAttainmentRuleName;
		var submitUrl, isUpdate = false;
		var message=getExaminationTranslation('ATTAINMENT_RULE_ADD_SUCCESS');
		if (isNullOrEmpty(id)) {
			submitUrl = SERVERURL.PATH_ATTAINMENT_RULE_CREATE,
			isUpdate = false;
			var formData = {
					value: examAttainmentRuleName
			};
		} else {
			submitUrl = SERVERURL.PATH_ATTAINMENT_RULE_UPDATE,
			isUpdate = true;
			var formData = {
					id:id,
					value: examAttainmentRuleName,
			};
		}

		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: submitUrl,
			jsonData: formData,
			method: 'POST',
			success: function(response, form) {
				Ext.getBody().unmask();
				if(response.responseText=="SUCCESS"){
					if (isUpdate) {
						message=getExaminationTranslation('ATTAINMENT_RULE_UPDATE_SUCCESS');	
					}
					showSuccessMessage(getExaminationTranslation('ATTAINMENT_RULES'),message);
					formWindow.close();
					me.getAttainmentrulegrid().getSelectionModel().deselectAll();
					me.getAttainmentrulegrid().getStore().loadPage(1);
					me.getAttainmentlevelgrid().down('#btnSaveItemId').disable();
				}else if(response.responseText == 'DUPLICATE'){
					message=getExaminationTranslation('ATTAINMENT_RULE_DUPLICATE');	
					showWarningMessage(getExaminationTranslation('ATTAINMENT_RULES'),message);
				}else{
					message=getErrorTranslation('CAMPAIGN_MASTER_DEPENDENCY_EXIST_ON_EDIT')	;
					showWarningMessage(getExaminationTranslation('ATTAINMENT_RULES'),message);
				}
				
			}
		});
	},
	 addNewRowInAttainmentRuleDetailsGrid: function(serialNo, grid, getcourseoutcomestructure) {
		 var $this = this;
		 var ObjModel = [];
		 var attainmentLevelGridModel = new Academia.model.examinationOBEAttainment.AttainmentLevelGridModel();
		 attainmentLevelGridModel.set("serialNo", serialNo);
		 attainmentLevelGridModel.set("id",'');
		 attainmentLevelGridModel.set("name",'');
		 attainmentLevelGridModel.set("percentageRangeFrom", '');
		 attainmentLevelGridModel.set("percentageRangeTo", '');
		 attainmentLevelGridModel.set("levelValue", '');
		 attainmentLevelGridModel.set("percentageRangeFrom", '');
		 attainmentLevelGridModel.set("isEditable", 'ADD');
		 attainmentLevelGridModel.set("isAddDeleteRow", true);
		 ObjModel.push(attainmentLevelGridModel);
		 grid.getStore().loadRawData(ObjModel, true);
		 if(serialNo == 1){
			 grid.down('#btnAdd').hide();
			 grid.down('#btnSaveItemId').setDisabled(false);
		 }
	 },
	 deleteAttainmentLevelDetails: function(grid,record,mapAttainmentLevelStructure,titleMessage,rowIndex){
		 if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
			 if (grid.getStore().getRange().length > 0) {
				 var id = record.get('id');
				 if(!isNullOrEmpty(id)){
					 showConfirmMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						 if (btn == 'yes') {
							 Ext.Ajax.request({
								 type: 'rest',
								 url: SERVERURL.PATH_ATTAINMENT_LEVEL_DELETE + '?id=' + id,
								 method: 'DELETE',
								 headers: {
									 'Content-Type': 'application/json'
								 },
								 success: function(form, action) {
									 if(form.responseText=="DEPENDENCY_EXIST"){
										 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'),getErrorTranslation('cannot_delete_awardee_as_already_used'));
										 Ext.getBody().unmask();
									 }else{
									 grid.getStore().removeAt(rowIndex);
									 var models = grid.getStore().getRange();
									 grid.getStore().loadRawData(models, true);
									 if(models.length == 0){
										 grid.down('#btnAdd').show();
										 grid.down('#btnSaveItemId').setDisabled(true);
									 }
									 showSuccessMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('ATTAINMENT_LEVEL_DELETE_SUCCESS'));
								 }
							 }
							 });
						 }
					 });
				 }
				 else{
					 grid.getStore().removeAt(rowIndex);
					 var models = grid.getStore().getRange();
					 for (var i = 0; i < models.length; i++) {
						 models[i].data.serialNo = i + 1;
					 }
					 grid.getStore().loadRawData(models, true);
					 if(models.length == 0){
						 grid.down('#btnAdd').show();
						 grid.down('#btnSaveItemId').setDisabled(true);
					 }
				 }
			 }
	 }},
	 examSaveManageAttainmentLevelrecord: function(obj){
		 var $this=this;
			// var contentPanel = $this.getContentpanel();
		     var message=getExaminationTranslation('ATTAINMENT_LEVEL_ADD_SUCCESS');
			 var attainmentLevelGrid = $this.getAttainmentlevelgrid();
			 var jsonStaffDetail = [];
			 var ruleGrid =this.getAttainmentrulegrid();
			 var attainmentLevelGridStore = attainmentLevelGrid.getStore();
			 if(ruleGrid.getSelectionModel().getSelection().length>0){
				 var attainmentRuleId = ruleGrid.getSelectionModel().getSelection()[0].data.id;
				 var flagIsSave = true;
				 if(attainmentLevelGridStore.getCount()==0){
					 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('PLEASE_SELECT_ATTAINMENT_LEVELS'));
					 flagIsSave = false;
					 return false;
				 }
				 if(attainmentLevelGridStore.getCount()>0){
					 attainmentLevelGridStore.data.items.every(function(obj){
						 if (isNullOrEmpty(obj.data.name)) {
							 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('PLEASE_FILL_ATTAINMENT_LEVEL_NAME'));
							 flagIsSave = false;
							 return false;
						 }else if (isNullOrEmpty(obj.data.percentageRangeFrom)) {
							 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('PLEASE_FILL_ATTAINMENT_LEVEL_PERCENTAGE_RANGE_FROM'));
							 flagIsSave = false;
							 return false;
						 }else if (isNullOrEmpty(obj.data.percentageRangeTo) ) {
							 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('PLEASE_FILL_ATTAINMENT_LEVEL_PERCENTAGE_RANGE_TO'));
							 flagIsSave = false;
							 return false;
						 }else if (isNullOrEmpty(obj.data.levelValue) ) {
							 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('PLEASE_FILL_ATTAINMENT_LEVEL_VALUE'));
							 flagIsSave = false;
							 return false;
						 }else if (!isNullOrEmpty(obj.data.percentageRangeTo) && !isNullOrEmpty(obj.data.percentageRangeFrom) &&  obj.data.percentageRangeFrom >= obj.data.percentageRangeTo) {
							 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), getExaminationTranslation('MIN_AND_MAX_CHECK'));
							 flagIsSave = false;
							 return false;
						 }else{
								 var jsonObj = {
									 "id":obj.data.id,
									 "name":obj.data.name,
									 "levelValue":obj.data.levelValue,
									 "percentageRangeFrom":obj.data.percentageRangeFrom,
									 "percentageRangeTo":obj.data.percentageRangeTo,
									 "attainmentRuleId":attainmentRuleId
							 }
							 jsonStaffDetail.push(jsonObj);
							 return true;
						 }
					 });
				 }
				 if(flagIsSave){
					 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					 Ext.Ajax.request({
						 type: 'rest',
						 url: SERVERURL.PATH_ATTAINMENT_LEVEL_SAVEALL,
						 jsonData: jsonStaffDetail,
						 method: 'POST',
						 success: function(frm, action) {
							 if(frm.responseText=="ADD_SUCCESS"){
								 message =getExaminationTranslation('ATTAINMENT_LEVEL_ADD_SUCCESS');
								 Ext.getBody().unmask();
								 attainmentLevelGridStore.reload();
								 showSuccessMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), message);
							 }else if(frm.responseText=="UPDATE_SUCCESS"){
								 message =getExaminationTranslation('ATTAINMENT_LEVEL_UPDATE_SUCCESS'); 
								 Ext.getBody().unmask();
								 attainmentLevelGridStore.reload();
								 showSuccessMessage(getExaminationTranslation('ATTAINMENT_LEVELS'), message);
							 }else{
								 showWarningMessage(getExaminationTranslation('ATTAINMENT_LEVELS'),getExaminationTranslation(frm.responseText));
								 Ext.getBody().unmask(); 
							 }
							 
						 }
					 });
				 } 
			 }
			
		 }
});