/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.evaluation.applyrule.ApplyRuleController', {
	//extend : 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
	models : ['examinationcenters.evaluation.applyrule.ApplyRuleGridModel'],
	
	stores : ['examinationcenters.evaluation.applyrule.RuleAppliedFor','examinationcenters.evaluation.applyrule.BussinessRule','examinationcenters.evaluation.applyrule.RuleAppliedOn',
	          'examinationcenters.evaluation.applyrule.ApplyRuleGridStore'],
	views : ['examinationcenters.evalution.applyrule.ApplyRuleGrid','examinationcenters.evalution.applyrule.ApplyRuleWindow'],	           
	config:{
     	 /*
         	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
          		   	 */
          	   	/**
          	        * @cfg {Array} Assessment Scheme Apply Rule array (required)
          	        * The array of permissions to use for Access control wise enabling and disabling buttons.
          	        * @accessor
          	        */
   	 /**
      * These permission are for Assessment Scheme Apply rule normal grid.
      */
   	   EVALUATION_PLAN_APPLY_RULE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EVALUATION_PLAN_APPLY_RULE_PRIVILEGES')
      },
	
	refs : [
	           {
				 ref : 'applyrulegrid',
				 selector : 'applyrulegrid'
			   },{
				 ref : 'applyrulewindow',
				 selector : 'applyrulewindow'
			   },{
				 ref : 'applyRuleForm',
				 selector : 'applyrulewindow form'
			   },{
				 ref : 'evaluationplanbasicdetailform',
				 selector : 'evaluationplanbasicdetailform'
			   }
	          ],
	          init : function() {
	        	  this.control({
        			  'applyrulegrid button[itemId=btnAdd]':{
        				  click:function(){
        					  var $this=this;
        					  $this.openApplyRuleWindow();
        					  /**
        					   *Load data when window will open 
        					   */
        					  $this.loadDefaultDataOnApplyRuleWindowOpen();
        				  }
        			  } ,
        			  'applyrulegrid button[itemId=btnDelete]':{
        				  click:function(){
        					  this.deleteApplyRule();
        				  }
        			  },
        			  'applyrulegrid button[itemId=btnEdit]':{
        				  click:function(){
        					  /**
        					   * Edit is not in functionality
        					   */
        					  //this.editApplyRule();
        				  }
        			  },
        			  'applyrulewindow button[itemId=btnSave]':{
        				  click:function(){
        					  this.saveApplyRuleData();
        				  }
        			  },
        			  'applyrulewindow button[itemId=btnCancel]':{
        				  click:function(obj){
        					  obj.up('window').close();
        				  }
        			  },
        			  'applyrulegrid':{
        				  render:function(grid){
        					  var evalBasicform=this.getEvaluationplanbasicdetailform().getForm();
        					  var evalPlanId=evalBasicform.findField('id').getValue();
        					  var store=grid.getStore();
        					   store.getProxy().extraParams = {
        						   evalPlanId:evalPlanId
                    			};
                    		   store.load();
                    		   /**
                    		    * Privilages in grid
                    		    */
    	                	   this.doAccessControlValidation(grid, this.getEVALUATION_PLAN_APPLY_RULE_PERMISSION());
    	                	   var form=this.getEvaluationplanbasicdetailform().getForm();
    	      			    	var masterViewMode=form.findField('masterViewMode').getValue();
    	      			    	/**
    	   		        	 * if masterViewMode true then Assessment Scheme will only view mode. 
    	   		        	 */
    	   		        	if(masterViewMode){
    	   		        		grid.down('#btnAdd').setVisible(false);
    	   		        		grid.down('#btnEdit').setVisible(false);
    	   		        		grid.down('#btnDelete').setVisible(false);
    	   		        	}
        				  }
        			  },
        			  'applyrulewindow groupingcombobox[itemId=ruleAppliedForItemId]':{
        				  select:function(obj,rec){
        					  var data=rec[0].data;
        					  var form=obj.up('form').getForm();
        					  var ruleAppliedForLevelField= form.findField('ruleAppliedForLevel');
        					  ruleAppliedForLevelField.setValue(data.level);
        					  
        					  var evalBasicform=this.getEvaluationplanbasicdetailform().getForm();
        					  var evalPlanId=evalBasicform.findField('id').getValue();
        					  
        					  var ruleAppliedForLevelField= form.findField('ruleAppliedForLevel');
        					  ruleAppliedForLevelField.setValue(data.code);
        					  
        					  var ruleAppliedOnField= form.findField('ruleAppliedOn');
        					  
        					  var ruleAppliedOnStore=ruleAppliedOnField.getStore();
        					 // if(ruleAppliedOnStore.data.items.lenght>0){
        						 // ruleAppliedOnStore.removeAll();
            					  ruleAppliedOnField.reset();
            					  ruleAppliedOnField.setDisabled(false);
            					  ruleAppliedOnField.setReadOnly(true);
        					  //}
            					  
        					  ruleAppliedOnStore.getProxy().extraParams = {
        						  levelName:data.code,
        						  levelId:data.levelId
                   			   };
        					  ruleAppliedOnStore.load({
        						  callback: function(records, operation, success) {
        							  var arr = [];
        							  for(var i in records){
        								  arr.push(records[i].data.levelId)
        							  }
									ruleAppliedOnField.expand();
        							  ruleAppliedOnField.setValue(arr);
									ruleAppliedOnField.collapse();
	      	            		   }	
        					  });
        				  }
        			  }
	        	  });
	          },
	          openApplyRuleWindow:function(){
	      	    	var formWindow = this.getApplyrulewindow();
	      			if (!formWindow) {
	      				Ext.widget('applyrulewindow');
	      				formWindow = this.getApplyrulewindow();
	      			}
	      			formWindow.show();
	           },
	           /**
	            * This function is used to load store when window will open
	            */
	           loadDefaultDataOnApplyRuleWindowOpen:function(){
	        	   var $this=this;
	        	   var evalBasicform=$this.getEvaluationplanbasicdetailform().getForm();
				   var evalPlanId=evalBasicform.findField('id').getValue();
				  
				   var store=$this.getStore('examinationcenters.evaluation.applyrule.RuleAppliedFor');
					  store.getProxy().extraParams = {
						  evalPlanId: evalPlanId
  				      };
					  store.load();
					 
				//   var ruleAppliedOnStore=$this.getStore('examinationcenters.evaluation.applyrule.RuleAppliedOn');	  
				   //       ruleAppliedOnStore.removeAll();
				 
				  $this.getApplyRuleForm().getForm().reset();
	           },
	           /**
	            * This function is used to save apply rule data
	            */
	           saveApplyRuleData:function(){
	        	   var $this=this;
	        	   var form=$this.getApplyRuleForm().getForm();
	        	   var formValues=form.getValues();
                 
	        	   var evalBasicform=$this.getEvaluationplanbasicdetailform().getForm();
				   var evalPlanId=evalBasicform.findField('id').getValue();
	        	   
	        	   var ruleAppliedOnField=form.findField('ruleAppliedOn');
	        	   var ruleAppliedOnStore=ruleAppliedOnField.getStore();
	        	   
	        	   
	        	   var ruleAppliedForLevelOneId=null;
	        	   var ruleAppliedForLevelTwoId=null;
	        	   var ruleAppliedForLevelThreeId=null;
	        	   var ruleAppliedForLevelFourId=null;
	        	   var ruleAppliedForLevelZeroId=null;
	        	   
	        	   if(formValues.ruleAppliedForLevel=='Assessment Scheme'){
	        		   ruleAppliedForLevelZeroId=formValues.ruleAppliedFor;
	        	   }else if(formValues.ruleAppliedForLevel=='Assessment Type'){
	        		   ruleAppliedForLevelOneId=formValues.ruleAppliedFor;
	        	   }else if(formValues.ruleAppliedForLevel=='Assessment Sub Type'){
	        		   ruleAppliedForLevelTwoId=formValues.ruleAppliedFor;
	        	   }else if(formValues.ruleAppliedForLevel=='Assessment Method'){
	        		   ruleAppliedForLevelThreeId=formValues.ruleAppliedFor;
	        	   }/*else if(formValues.ruleAppliedForLevel=='4'){
	        		   ruleAppliedForLevelFourId=formValues.ruleAppliedFor;
	        	   }*/
	        	   
	        	   var submitArray=[];
	        	   
	        	   Ext.Array.each(formValues.ruleAppliedOn, function(value) {	
	        		   var valueSequenceId=null;
	        		   if(Ext.isObject(value)){
						   valueSequenceId=value.data.levelId;
                      }else{
                    	   valueSequenceId=value;
                      }
	        		   //var selectData=ruleAppliedOnStore.findRecord( "sequenceId", valueSequenceId, 0, false, false, true);
	        		   var ruleAppliedOnLevelOneId=null;
		        	   var ruleAppliedOnLevelTwoId=null;
		        	   var ruleAppliedOnLevelThreeId=null;
		        	   var ruleAppliedOnLevelFourId=null;
		        	   
		        	   if(formValues.ruleAppliedForLevel=='Assessment Scheme'){
		        		   ruleAppliedOnLevelOneId=valueSequenceId;
		        	   }else if(formValues.ruleAppliedForLevel=='Assessment Type'){
		        		   ruleAppliedOnLevelTwoId=valueSequenceId;
		        	   }else if(formValues.ruleAppliedForLevel=='Assessment Sub Type'){
		        		   ruleAppliedOnLevelThreeId=valueSequenceId;
		        	   }else if(formValues.ruleAppliedForLevel=='Assessment Method'){
		        		   ruleAppliedOnLevelFourId=valueSequenceId;
		        	   }
		        	   
		        	   var data={
		        			     "ruleName":formValues.ruleName,
		        				 "description":formValues.description,
		        				 "businessRule":formValues.businessRule,
		        				 "ruleAppliedForLevelZeroId":ruleAppliedForLevelZeroId,
		        				 "ruleAppliedForLevelOneId":ruleAppliedForLevelOneId,
		        				 "ruleAppliedForLevelTwoId":ruleAppliedForLevelTwoId,
		        				 "ruleAppliedForLevelThreeId":ruleAppliedForLevelThreeId,
		        				 //"ruleAppliedForLevelFourId":ruleAppliedForLevelFourId,
		        				 "ruleAppliedOnLevelOneId":ruleAppliedOnLevelOneId,
		        				 "ruleAppliedOnLevelTwoId":ruleAppliedOnLevelTwoId,
		        				 "ruleAppliedOnLevelThreeId":ruleAppliedOnLevelThreeId,
		        				 "ruleAppliedOnLevelFourId":ruleAppliedOnLevelFourId,
		        			     "evaluationPlanId":evalPlanId,
		        			      //"sequenceIdDerived":selectData.data.sequenceId
		        	           };
		        	   submitArray.push(data);
	        	   });
	        	   
	        	   console.log('submitArray',submitArray);
	        	   if(submitArray.length>0){
	        		   $this.applyWindowMask();
	        		   Ext.Ajax.request({
	  			   		 type: 'rest',
	  			   		 url: SERVERURL.APPLY_RULE_CREATE_URL,
	  			   		 jsonData: submitArray,
	  			   		 method: 'POST',
	  			   		 success: function(obj, action) {
	  			   		$this.hideWindowMask();
	  			   			 if(obj.responseText!=""){
	  			   	   			showSuccessMessage(getExaminationTranslation('EVALUATION_PLAN_TYPE'), getCommonTranslation('SUCCESS')); 
	  			   	   	        $this.getApplyrulewindow().close();
	  			   	   	        Ext.defer(function() {
	  			   	   	        	$this.getApplyrulegrid().getStore().load();
	  			   	   	        }, 250, this);
	  			   			 }
	  			   		    }
	  			   	    });
	        	   }
	           },
	           editApplyRule:function(){
		        	var $this = this;
					var grid = $this.getApplyrulegrid();
				 	if (grid.getSelectionModel().getCount() > 0) {
				 		$this.openApplyRuleWindow();
				 		var form=$this.getApplyRuleForm().getForm();
				 		var records = grid.getSelectionModel().getSelection()[0];
				 		
				 		form.findField('ruleName').setValue(records.data.ruleName);
				 		var ruleAppliedForLevelZeroId=records.data.ruleAppliedForLevelZeroId;
				 		var ruleAppliedForLevelOneId=records.data.ruleAppliedForLevelOneId;
			        	var ruleAppliedForLevelTwoId=records.data.ruleAppliedForLevelTwoId;
			        	var ruleAppliedForLevelThreeId=records.data.ruleAppliedForLevelThreeId;
			        	var ruleAppliedForLevelFourId=records.data.ruleAppliedForLevelFourId;
			        	
			        	var ruleAppliedForId=null;
			        	
			        	   if (ruleAppliedForLevelZeroId!=null){
			        		   ruleAppliedForId=ruleAppliedForLevelZeroId;
			        	   }else if(ruleAppliedForLevelOneId!=null){
			        		   ruleAppliedForId=ruleAppliedForLevelOneId;
			        	   }else if(ruleAppliedForLevelTwoId!=null){
			        		   ruleAppliedForId=ruleAppliedForLevelTwoId;
			        	   }else if(ruleAppliedForLevelThreeId!=null){
			        		   ruleAppliedForId=ruleAppliedForLevelThreeId;
			        	   }else if(ruleAppliedForLevelFourId!=null){
			        		   ruleAppliedForId=ruleAppliedForLevelFourId;
			        	   }
			        	
						var ruleAppliedForField=form.findField('ruleAppliedFor');
					    var store=ruleAppliedForField.getStore();
						  store.getProxy().extraParams = {
	  					     id: records.data.evaluationPlanId
	  				      };
						  store.load({
				 			callback:function(callbackrec, options, success){
				 				ruleAppliedForField.setValue(ruleAppliedForId);
				 			}
					    });
						
						var ruleAppliedOnField =form.findField('ruleAppliedOn');  
						var ruleAppliedOnStore=ruleAppliedOnField.getStore();
						 $this.applyWindowMask();
						  Ext.Ajax.request({
								type : 'rest',
								url : SERVERURL.APPLIED_RULE_ON_SELECTED_VALUE_URL,
								params : {
									id:ruleAppliedForId,
									evalPlanId:records.data.evaluationPlanId,
									level:records.data.evaluationPlanLevel
								},
						        method : 'GET',
						        success : function(response) {
						        	 $this.hideWindowMask();
						        var data = Ext.decode(response.responseText);
						        ruleAppliedOnStore.getProxy().extraParams = {
					        	      evalPlanId:records.data.evaluationPlanId,
	        						  level:records.data.evaluationPlanLevel
			  				      };
					           ruleAppliedOnStore.load({
					        	   callback:function(){
					        		   var getSelectRuleOnData=[];
					        		   Ext.Array.each(data, function(value) {	
								        	  getSelectRuleOnData.push(value.sequenceId);
								          });
					        		   ruleAppliedOnField.setValue(getSelectRuleOnData);
				        		     }   
					            });
						      }
						  });
						  
						form.findField('description').setValue(records.data.description);
						  
				 		var bussinessRuleField=form.findField('businessRule');
				 		if(records.data.businessRule!=null){
				 			bussinessRuleField.getStore().load({
					 			callback:function(success,rec){	
					 				bussinessRuleField.setValue(records.data.businessRule);
					 			}
					 		});
				 		}
				 	}else{
				 		 $this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					} 
	           },
	           deleteApplyRule:function(){
		        	  var $this = this;
						var grid = $this.getApplyrulegrid();
						if (grid.getSelectionModel().getCount() > 0) {
							showConfirmMessage(getExaminationTranslation('APPLY_RULE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
							function(btn, text) {
								if (btn == 'yes') {
									var records = grid.getSelectionModel().getSelection()[0];
									var ruleAppliedForLevelZeroId=records.data.ruleAppliedForLevelZeroId;
									var ruleAppliedForLevelOneId=records.data.ruleAppliedForLevelOneId;
						        	var ruleAppliedForLevelTwoId=records.data.ruleAppliedForLevelTwoId;
						        	var ruleAppliedForLevelThreeId=records.data.ruleAppliedForLevelThreeId;
						        	var ruleAppliedForLevelFourId=records.data.ruleAppliedForLevelFourId;
						        	
						        	var id=null;
						        	var level=records.data.evaluationPlanLevel;
						        	if(ruleAppliedForLevelZeroId!=null){
						        		id=ruleAppliedForLevelZeroId;
						        	}else if(ruleAppliedForLevelOneId!=null){
						        		id=ruleAppliedForLevelOneId;
						        	   }else if(ruleAppliedForLevelTwoId!=null){
						        		   id=ruleAppliedForLevelTwoId;
						        	   }else if(ruleAppliedForLevelThreeId!=null){
						        		   id=ruleAppliedForLevelThreeId;
						        	   }else if(ruleAppliedForLevelFourId!=null){
						        		   id=ruleAppliedForLevelFourId;
						        	   }
									
									Ext.Ajax.request({
										method : "DELETE",
										type : 'rest',
										url : SERVERURL.APPLY_RULE_DELETE_URL+ '?id='+ id+'&level='+level,
										headers : {
											'Content-Type' : 'application/json'
										},
										success : function(form,action) {
											showSuccessMessage(getExaminationTranslation('APPLY_RULE'),getCommonTranslation('SUCCESS'));
											grid.getStore().reload();
										}
									});
							  }
						   });
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						} 
		          }
	         
});
