/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailAdd','examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesFormModel',
	          'common.IdValueCodeDataModel','examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailAddForDateField','genericmodels.dropdowns.EnumCombo'],
	stores : ['examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesFormStore','examinationcenters.evaluationgroup.evaluationgroupdetail.ApplicationFlag',
	          'enquiry.AcademicBatchStore','enquiry.BatchAndStartEndDateStore','examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupFeePlan',
	          'examinationcenters.evaluationgrouplisting.applicationdetail.EvaluationGroupSeatType','coursetransaction.coursereading.DistributionMode',
	          'examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterName','examinationcenters.CenterResponisble',
	          'examinationcenters.evaluationgroup.EvaluationGroupStatus','examinationcenters.evaluationgroup.EvaluationGroupListStore','transport.serviceRoute.WeekDays'
	          ],
	views : ['examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailForm','examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesWindow','examinationcenters.evaluationgroup.AssessmentGroupsGridView'],	           
	          refs : [{
				 ref : 'evalgroupdetailform',
				 selector : 'evalgroupdetailform'
			    },{
				 ref : 'defineruleswindow',
				 selector : 'defineruleswindow'
			    },{
				 ref : 'defineRulesForm',
				 selector : 'defineruleswindow form'
			    },{
	              	 ref: 'assessmentGroupsGridView',
	            	 selector: 'assessmentGroupsGridView[itemId=evalgroupmastergridItemId]'
	             },{
	              	 ref: 'manageevalgrouptabstructure',
	            	 selector: 'manageevalgrouptabstructure'
	             }
			    
	          ],
	          init : function() {
	        	  this.control({
	        		'evalgroupdetailform':{
	        			 beforerender : function(obj){
								var $this= this;
								var form = $this.getEvalgroupdetailform().getForm();
								var evalStage = form.findField('evaluationStage').hide();
								var numberOfBatchesInADay=form.findField('numberOfBatchesInADay');
								evalStage.getStore().load({
		        					 callback: function(records, operation, success) {
		        						 evalStage.setValue(records[1].data.id);
	      	            		   	 }	   
								});
	        			 }
	        		 },
	        		 'evalgroupdetailform button[itemId=submitBtn]':{
	        			click:function(btn){
	        				this.saveEvalGroupFormData(btn);
	        			}
	        		 },
	        		 
		        		 
	        		 'evalgroupdetailform button[itemId=cancelBtn]':{
	        			click:function(obj){
                           var evalGroupForm=obj.up('form').getForm()
                           var values = evalGroupForm.getValues();
                           evalGroupForm.findField('batchId').setDisabled(true);
                           evalGroupForm.findField('seatTypeId').setDisabled(true);
                           evalGroupForm.findField('feePlanId').setDisabled(true);
                           evalGroupForm.findField('feePlanBillingDate').setDisabled(true);
                           evalGroupForm.findField('selectedCenters').setDisabled(true);
                           var examdateFrom=evalGroupForm.findField('examdateFrom');
	        			   examdateFrom.setMaxValue(0);
                           evalGroupForm.reset();
                           evalGroupForm.findField('evaluationStage').setValue('COURSE_EXECUTION').hide();
                           evalGroupForm.findField('evaluationGroupStatus').setValue(values.evaluationGroupStatus);
                           evalGroupForm.findField('evaluationGroupStatusText').setValue(values.evaluationGroupStatusText);
                           evalGroupForm.findField('evaluationGroupStatusUpdate').setValue(values.evaluationGroupStatusUpdate);
	        			}
		        	  },
	        		 'evalgroupdetailform button[itemId=defineRulesBtn]':{
		        			click:function(){
		        				this.checkDataIsInStoreOrNot();
		        			}
		        	 },
		        	 'evalgroupdetailform customcombobox[itemId=programItemId]':{
	        			 select:function(obj,rec){
	        				
	        				 var programId=rec[0].data.id;
	        				 var form=obj.up('form').getForm();
	        				 var batch = form.findField('batchId');
	        				 batch.enable();
	        				 batch.getStore().getProxy().extraParams = {
	        					 id: programId
	        				 };
	        				 batch.getStore().load();
	        			 }
	        		 },
	        		 'evalgroupdetailform customcombobox[itemId=batchItemId]':{
	        			 select:function(obj,rec){
	        				 var batchId=rec[0].data.id;
	        				 var form=obj.up('form').getForm();
	        				 
	        				 var seatType = form.findField('seatTypeId');
	        				 seatType.enable();
	        				 seatType.getStore().getProxy().extraParams = {
	        					 batchId: batchId
	        				 };
	        				 seatType.getStore().load();
	        				 
	        				 var feePlanId = form.findField('feePlanId');
	        				 feePlanId.enable();
	        				 feePlanId.getStore().getProxy().extraParams = {
	        					 programBatchId: batchId,
	        					 stageName : 'Assessment Group',//getExaminationTranslation("CNTRL_EVALUATION_GROUP"),
	        					 feePlanType:'Exam' //getExaminationTranslation("CNTRL_EXAM")
	        				 };
	        				 feePlanId.getStore().load();
	        				 var examdateFrom=form.findField('examdateFrom');
		        			 var examdateTill=form.findField('examdateTill');
		        		/*	 examdateFrom.setMinValue(dateRender(rec[0].data.startDate));
		        			 examdateFrom.setMaxValue(dateRender(rec[0].data.tillDate));
		        			 examdateTill.setMinValue(dateRender(rec[0].data.startDate));
		        			 examdateTill.setMaxValue(dateRender(rec[0].data.tillDate));*/
	        			 }
	        		 },
	        		 'evalgroupdetailform radiogroup[itemId=hallTicketReqItemId]':{
		        			change:function(obj,value){
		        				var form=obj.up('form').getForm();
		        				var distributionModeId=form.findField('distributionModeId');
		        				//var hallTicketTemplate=form.findField('hallTicketTemplate');
		        				//var hallTicketFormat=form.findField('hallTicketFormat');
		        				/**
		        				 * hall ticket template and format fields are hidden as discussed with puspendra sir
		        				 */
		        				if(value.hallTicketGenerationRequired){
		        					distributionModeId.setVisible(true);
		        				//	hallTicketTemplate.setVisible(true);
		        				//	hallTicketFormat.setVisible(true);
		        					distributionModeId.reset();
		        					//hallTicketTemplate.reset();
		        					//hallTicketFormat.reset();
		        				}else{
		        					distributionModeId.setVisible(false);
		        					//hallTicketTemplate.setVisible(false);
		        				//	hallTicketFormat.setVisible(false);
		        				}
		        			}
		        	   },
		        	   'evalgroupdetailform radiogroup[itemId=examSchedule]':{ 
		        			change:function(obj,value){
								var $this= this;   
								
		        				var form=obj.up('form').getForm();
								
		        				var examSkipDaysId=form.findField('examSkipDays');
		        				var noOfDaySkipId=form.findField('noOfDaySkip');
                                var noofBatchesInaDays=form.findField('numberOfBatchesInADay');
								
								var centers=form.findField('selectedCenters');
							
		        				if(value.examScheduleRequire){     
		        					examSkipDaysId.setVisible(true);    
		        					noOfDaySkipId.setVisible(true);   
 								//examSkipDaysId.allowBlank=false;   
		        					$this.setAllowBlank(examSkipDaysId,false);      
		        					examSkipDaysId.reset();
									noofBatchesInaDays.setValue(1);
									noofBatchesInaDays.setEditable(false);
		  		                    noofBatchesInaDays.setReadOnly(true);
									centers.reset();
			        				var noOfBatchesValues=noofBatchesInaDays.getValue();
			        				var intervalBetweenBatches=form.findField('intervalBetweenBatches');
			        				if(noOfBatchesValues>1&&noOfBatchesValues!=null){
			        					intervalBetweenBatches.setVisible(true);
			        				}else if(noOfBatchesValues==1){
			        					intervalBetweenBatches.setVisible(false);
			        					intervalBetweenBatches.reset();
			        				}
            
		        				}else{
		        				//	examSkipDaysId.allowBlank=true;
  									$this.setAllowBlank(examSkipDaysId,true); 
  									examSkipDaysId.reset();
		        					examSkipDaysId.setVisible(false);   
		        					noOfDaySkipId.reset();
		        					noOfDaySkipId.setVisible(false);
									noofBatchesInaDays.reset();
									noofBatchesInaDays.setValue(1);  
 									noofBatchesInaDays.setReadOnly(false); 
								    noofBatchesInaDays.setEditable(true);
								   }
		        			}
		        	   },
		        		 'evalgroupdetailform numberfield[itemId=numberOfBatchesInADayItemId]':{
			        			blur:function(obj,value){
			        				var form=obj.up('form').getForm();
			        				var noOfBatchesValues=form.findField('numberOfBatchesInADay').getValue();
			        				var intervalBetweenBatches=form.findField('intervalBetweenBatches');
			        				if(noOfBatchesValues>1&&noOfBatchesValues!=null){
			        					
			        					intervalBetweenBatches.setVisible(true);
			        				}else if(noOfBatchesValues==1){
			        					intervalBetweenBatches.setVisible(false);
			        					intervalBetweenBatches.reset();
			        				}
			        			}
			        	   },
			        	   'defineruleswindow button[itemId=btnCancel]':{
			        			click:function(obj){
			        			  obj.up('window').close();
			        			}
		        		  },
			        	   'defineruleswindow button[itemId=btnSave]':{
			        			click:function(){
			        			  this.saveDefineRulesData();
			        			}
		        		 },
			        	  'defineruleswindow textfield[itemId=entryCriteriaItemId]':{
			        			blur:function(obj){
			        				var form=obj.up('form').getForm();
			        				var entryCriteria=form.findField('entryCriteria');
		        					entryCriteria.nextSibling().allowBlank=true;
			        				if(entryCriteria.getValue()!=""){
			        					entryCriteria.nextSibling().allowBlank=false;
			        				}
			        				//form.isValid();
			        			}
			        	  },
			        	  'defineruleswindow textfield[itemId=exitCriteriaItemId]':{
			        			blur:function(obj){
			        				var form=obj.up('form').getForm();
			        				var exitCriteria=form.findField('exitCriteria');
			        				exitCriteria.nextSibling().allowBlank=true;
			        				if(exitCriteria.getValue()!=""){
			        					exitCriteria.nextSibling().allowBlank=false;
			        				}
			        				// form.isValid();
			        			}
			        	  },
			        	  'evalgroupdetailform datefield[itemId=examdateFromItemId]':{
			        			blur:function(obj){
			        				var form=obj.up('form').getForm();
			        				var examdateFrom=form.findField('examdateFrom');
			        				var examdateTill=form.findField('examdateTill');
			        				examdateTill.setMinValue(examdateFrom.getValue());
			        				
			        				var applicationStartDate=form.findField('applicationStartDate');
			        				var applicationTillDate=form.findField('applicationTillDate');
			        				var studentRescheduleTillDate=form.findField('studentRescheduleTillDate');
			        				applicationStartDate.setMaxValue(examdateFrom.getValue());
			        				if(!obj.up('evalgroupdetailform').isEditFlow) {
			        					applicationTillDate.setMaxValue(examdateFrom.getValue());
			        				}
			        				studentRescheduleTillDate.setMaxValue(examdateFrom.getValue());
			        			}
			        	  },
			        	  'evalgroupdetailform datefield[itemId=examdateTillItemId]':{
			        			blur:function(obj){
			        				var form=obj.up('form').getForm();
			        				var examdateFrom=form.findField('examdateFrom');
			        				var examdateTill=form.findField('examdateTill');
			        				examdateFrom.setMaxValue(examdateTill.getValue());
			        			}
			        	  },
			        	  'evalgroupdetailform datefield[itemId=applicationStartDateItemId]':{
			        			blur:function(obj){
			        				var form=obj.up('form').getForm();
			        				var applicationStartDate=form.findField('applicationStartDate');
			        				var applicationTillDate=form.findField('applicationTillDate');
			        				applicationTillDate.setMinValue(applicationStartDate.getValue());
			        			}
			        	  },
			        	  'evalgroupdetailform datefield[itemId=applicationTillDateItemId]':{
			        			blur:function(obj){
			        				var form=obj.up('form').getForm();
			        				var applicationStartDate=form.findField('applicationStartDate');
			        				var applicationTillDate=form.findField('applicationTillDate');
			        				applicationStartDate.setMaxValue(applicationTillDate.getValue());
			        			}
			        	  },
			        	  'evalgroupdetailform textfield[itemId=evaluationGroupCodeItemId]':{
			        		    blur:function(obj){
			        		    	this.checkEvaluationGroupIsExistOrNot();
			        				 var form=obj.up('form').getForm();
			        				  var printNameInMarksheetField=form.findField('evaluationGroupCodePrintName');
			        				  printNameInMarksheetField.setValue(obj.getValue());
			        			}
			        	  },
			        	  'evalgroupdetailform customcombobox[itemId=feePlanItemId]':{
			        			select:function(obj){
			        				var form=obj.up('form').getForm();
			        				var feePlanBillingDate=form.findField('feePlanBillingDate');
			        				//feePlanBillingDate.allowBlank=false;
			        				feePlanBillingDate.enable();
			        				//form.isValid();
			        			}
			        	  },
			        	  'evalgroupdetailform customcombobox[itemId=applicationFlagItemId]':{
			        			select:function(obj,rec){
			        				var form=obj.up('form').getForm();
			        				var data=rec[0].data.id;
			        				
			        				var applicationStartDate=form.findField('applicationStartDate');
			        				var applicationTillDate=form.findField('applicationTillDate');
			        				var onlineSubmission=form.findField('onlineSubmission');
			        				var feePlanId=form.findField('feePlanId');
			        				applicationStartDate.setVisible(false);
		        					applicationTillDate.setVisible(false);
		        					onlineSubmission.setVisible(false);
		        					applicationStartDate.reset();
		        					applicationTillDate.setVisible(false);
		        					onlineSubmission.setVisible(false);
		        					
		        					feePlanId.allowBlank=true;
			        				if(data==getExaminationTranslation('CNTRL_APPLICATION_REQUIRED')){
			        					applicationStartDate.setVisible(true);
			        					applicationTillDate.setVisible(true);
			        					onlineSubmission.setVisible(true);
			        					//this.checkOnApplicationFormat();
			        				}else if(data==getExaminationTranslation('CNTRL_ALL_PERSONS_WHO_PAY_FEES_COVERED')){
			        					//feePlanId.allowBlank=false;
			        				}
			        				//form.isValid();
			        			}
			        	  },
			        	  'evalgroupdetailform radiogroup[itemId=studentRescheduleItemId]':{
			        		  change:function(obj,val){
			        			  /**
			        			   * whetherStudentReschedule is by default set to false and disabled.So, this functionlity will not run 
			        			   */
			        			  var form=obj.up('form').getForm();
			        			  var studentRescheduleTillDate=form.findField('studentRescheduleTillDate');
			        			  studentRescheduleTillDate.setVisible(true);
			        			  if(!val.whetherStudentReschedule){
			        				  studentRescheduleTillDate.setVisible(false);
			        			  }
			        		  }
			        	  },
			        	  'evalgroupdetailform radiogroup[itemId=onlineSubmissionItemId]':{
			        		  change:function(obj,val){
			        			  /**
			        			   * This funtionality is hidden as discussed with pushpendra sir 
			        			   */
			        			//  this.checkOnApplicationFormat();
			        		  }
			        	  },
			        	  'evalgroupdetailform customcombobox[itemId=centerTypeItemId]':{
			        		  select:function(obj,rec){
			        			  var data=rec[0].data.value;
                                  var centerValue=data;
			        			  var form=obj.up('form').getForm();
			        			  var selectedCentersField=form.findField('selectedCenters');
			        			  selectedCentersField.reset();
			        			  selectedCentersField.enable();
			        			  selectedCentersField.getStore().getProxy().extraParams = {
			        				  centerType:data
			        				 };
			        			  selectedCentersField.getStore().load();
			        		  }
			        	  },
			        	  
			        	 'evalgroupdetailform combobox[itemId=evaluationGroupStatus]':{
			        		 afterrender:function(obj,rec){
			        			  var $this=this;
			        		  }
			        	  },
			        	  'evalgroupdetailform multiselectcombofield[name=selectedCenters]': {
								beforeselect: function(combo, record, index, eOpts) {
									var examSchedule = combo.up('form').down('#examSchedule');
									if(examSchedule.getValue().examScheduleRequire) {
										var valueLength = combo.getPicker().getSelectionModel().getSelection().length;
										if(valueLength > 0) {
											return false;
										}
									}
								},
								expand:function(cmp){
									var examSchedule = cmp.up('form').down('#examSchedule');
									if(examSchedule.getValue().examScheduleRequire) {
										Ext.apply(cmp,{
											addAllSelector:false
										});
										if(typeof cmp.allSelector == 'object'){
											cmp.allSelector.setStyle('display','none');
										}
										
									}else{
										Ext.apply(cmp,{
											addAllSelector:true
										});
										if(typeof cmp.allSelector == 'object'){
											cmp.allSelector.setStyle('display','block');
										}
									}
								}
							}
	        	  });
	          },
	          openDefineRuleWindow:function(){
	        	    	var formWindow = this.getDefineruleswindow();
	        			if (!formWindow) {
	        				Ext.widget('defineruleswindow');
	        				formWindow = this.getDefineruleswindow();
	        			}
	        			formWindow.show();
	          },
	          /**
	           * Check evaluation group code is exist or not
	           */
	          checkEvaluationGroupIsExistOrNot:function(){
	        	    var $this=this;
	        	    var form=$this.getEvalgroupdetailform().getForm();
	        	    var evalGroupId =  form.findField('id').getValue();
	  				var programId=form.findField('programId').getValue();
	  				var batchId=form.findField('batchId').getValue();
	  				var evaluationGroupCodeField=form.findField('evaluationGroupCode');
	  				var evaluationGroupCode=evaluationGroupCodeField.getValue();
	  				if(programId>0&&programId!=null&&batchId>0&&batchId!=null&&evaluationGroupCode!=null){
	  					var data='?evaluationGroupCode='+evaluationGroupCode+'&programId='+programId+'&batchId='+batchId+'&evalGroupId='+evalGroupId;
	      				var uniqCheckUrl=SERVERURL.CHECK_UNIQUE_FOR_EVALUATION_GROUP_NAME_URL+data;
	      				
	      				Ext.Ajax.request({
	      					 type: 'rest',
	      					 url: uniqCheckUrl,
	      					 method: 'GET',
	      					 success: function(resp, action) {
	      						 if(resp.responseText=="true"){
	      							 evaluationGroupCodeField.reset();
	      							 showWarningMessage(getExaminationTranslation('EVALUATION_GROUP'),getExaminationTranslation('EVAL_GROUP_DUPLICATE_WRNING_MSG'));
	      						 }
	      					 }
	      				 });
	  				}else{
	  					 evaluationGroupCodeField.reset();
	  					 showWarningMessage(getExaminationTranslation('EVALUATION_GROUP'),getExaminationTranslation('SELECT_PROGRAM_BATCH'));
	  				}
	          },
	          /**
	           *check data in store while open define rule window  
	           */
	          checkDataIsInStoreOrNot:function(){
	        	  var  $this=this;
	        	  $this.openDefineRuleWindow();
	        	  var deineRulesForm =$this.getDefineRulesForm();
	        	  var form =deineRulesForm.getForm();
	        	  var evalGroupDetailForm =$this.getEvalgroupdetailform().getForm();
	        	  var wetherEditableValue=evalGroupDetailForm.findField('wetherEditable').getValue();
	        	  /**
	        	   * If wetherEditable is false then save is not in deine rules window 
	        	   */
	        	  
	        	  if(wetherEditableValue=="false"){
	        		  toggleReadOnlyFormItems(form, true);
	        		  deineRulesForm.down('#btnSave').setVisible(false);
	        	  }
	        	  var store=$this.getStore('examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesFormStore');
	        	  if(store.data.items.length>0&&store.data.items!=null){
	        		  var data=store.data.items[0].data;
	        		  form.findField('ageMax').setValue(data.ageMax);
	        		  form.findField('ageMin').setValue(data.ageMin);
	        		  form.findField('droolsRuleRanking').setValue(data.droolsRuleRanking);
	        		  form.findField('droolsRuleRankingDescription').setValue(data.droolsRuleRankingDescription);
	        		  form.findField('entryCriteria').setValue(data.entryCriteria);
	        		  form.findField('entryCriteriaDescription').setValue(data.entryCriteriaDescription);
	        		  form.findField('exitCriteria').setValue(data.exitCriteria);
	        		  form.findField('exitCriteriaDescription').setValue(data.exitCriteriaDescription);
	        		  form.findField('maxAttempts').setValue(data.maxAttempts);
	        	  }
	          },
	          saveDefineRulesData:function(){
	        	  var  $this=this;
	        	  var form =$this.getDefineRulesForm().getForm();
	        	  var formValues=form.getValues();	 
	        	  var store=$this.getStore('examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesFormStore');
	        	  var submitData=new Academia.model.examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesFormModel();
	        	  submitData.set("droolsRuleRanking",formValues.droolsRuleRanking);
	        	  submitData.set("droolsRuleRankingDescription",formValues.droolsRuleRankingDescription);
	        	  submitData.set("entryCriteria",formValues.entryCriteria);
	        	  submitData.set("exitCriteria",formValues.exitCriteria);
	        	  submitData.set("entryCriteriaDescription",formValues.entryCriteriaDescription);
	        	  submitData.set("exitCriteriaDescription",formValues.exitCriteriaDescription);
	        	  submitData.set("maxAttempts",formValues.maxAttempts);
	        	  submitData.set("ageMin",formValues.ageMin);
	        	  submitData.set("ageMax",formValues.ageMax);
	        	  store.loadRawData(submitData);
	        	  $this.getDefineruleswindow().close();
	        	  showSuccessMessage(getExaminationTranslation('DEFINE_NAMES'), getExaminationTranslation('DEFINE_RULES_SUCCESS_MSG'));
	          },
	          saveEvalGroupFormData:function(btn){
	        	  btn.setDisabled(true);
	        	  var  $this=this;
	        	  var grid = $this.getAssessmentGroupsGridView();
	        	  var form =$this.getEvalgroupdetailform().getForm();
	        	  var formValues=form.getValues();
	        	  var seatTypeId=[];
	        	  var selectedCentersId=[];
	        	  var examSkipDays=[];
	        	  if(formValues.seatTypeId!=null && formValues.seatTypeId.length>0){
		        	  Ext.each(formValues.seatTypeId, function (value) {
		        		  
		        		  var seatId=null;
		        		  if(Ext.isObject(value)){
		        			     seatId=value.get("id");
		                      }else{
		                    	  seatId=value;
		                      }
		        		  
		        		  var seatData={
		        				  "id":seatId
		        		  };
		        		  seatTypeId.push(seatData);
		        	  });
	        	  }
	        	  if(formValues.examSkipDays!=null && formValues.examSkipDays.length>0){
		        	  Ext.each(formValues.examSkipDays, function (value) {
		        		  
		        		  var examDaySKipId=null;
		        		  if(Ext.isObject(value)){
		        			  examDaySKipId=value.get("value");
		                      }else{
		                    	  examDaySKipId=value;
		                      }
		        		  var examDaySKipData={
		        				  "value":examDaySKipId
		        		  };
		        		  examSkipDays.push(examDaySKipData);
		        	  });
	        	  }
	        	  var json=[];
	        	  var isScheduleDatePassed=true;
	        	  var noScheduleDate;

	        	  if(!isNullOrEmpty(formValues.id)){
	        	  Ext.Ajax.request({
	        		  type : 'rest',
	        		  url : SERVERURL.PATH_SCHEDULE_DATE_COVERED_BY_EVALUATION_GROUP_ID,
	        		  async:false,
	        		  params: {
	        			  evaluationGroupId: formValues.id,
	        		  },
	        		  method : 'GET',
	        		  success : function(resp, action) {
	        			  var isScheduleDate = Ext.decode(resp.responseText);
	        			  if(isScheduleDate.length==0){
	        				  isScheduleDatePassed=true;
	        			  }else{
	        				  for (var i in isScheduleDate) {
	        					  json.push({
	        						  "scheduleDate":isScheduleDate[i].date,
	        					  });
	        				  }
	        			  }
	        		  }
	        	  });
	        	  
	        	  
	        	  for(var i=0;i<json.length;i++){
						if(json[i].scheduleDate>Date.parse(formValues.examdateTill)){
							isScheduleDatePassed=false;
						}
					}
	        	  } else{
	        		  isScheduleDatePassed=true;
	        	  }
	        	  if(formValues.selectedCenters!=null && formValues.selectedCenters.length>0){
		        	  Ext.each(formValues.selectedCenters, function (value) {
		        		  var centerId=null;
		        		  if(Ext.isObject(value)){
		        			    centerId=value.get("id");
		                      }else{
		                    	centerId=value;
		                      }
		        		  var centerData={
		        				  "id":centerId
		        		  };
		        		  selectedCentersId.push(centerData);
		        	  });
	        	  }
	        	  var submitData=new Academia.model.examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupDetailAdd();
	        	  submitData.set("programId",formValues.programId);
	        	  submitData.set("batchId",formValues.batchId);
	        	  submitData.set("evaluationStage",formValues.evaluationStage);
	        	  if(!isNullOrEmpty(formValues.evaluationGroupCode)){
	        		  submitData.set("evaluationGroupCode",formValues.evaluationGroupCode);
	        	  }else{
	        		  submitData.set("evaluationGroupCode",formValues.evaluationGroupCodeUpdate);
	        	  }
				  submitData.set("evaluationGroupCodePrintName",formValues.evaluationGroupCodePrintName);
	        	  submitData.set("seatTypes",seatTypeId);
	        	  submitData.set("examSkipDay",examSkipDays);
	        	  submitData.set("examdateFrom",formValues.examdateFrom);
	        	  submitData.set("examdateTill",formValues.examdateTill);
	        	  submitData.set("hallTicketGenerationRequired",formValues.hallTicketGenerationRequired);
	        	  submitData.set("isAutoExamSchedule",formValues.examScheduleRequire);
	        	  submitData.set("noOfDaysToSkip",form.findField('noOfDaySkip').value);
	        	  submitData.set("distributionModeId",formValues.distributionModeId);
	        	  submitData.set("hallTicketTemplate",0);//hard cord values
	        	  submitData.set("hallTicketFormat",0);//hard cord values
	        	  submitData.set("numberOfBatchesInADay",formValues.numberOfBatchesInADay);
	        	  submitData.set("startTimeOfFirstBatch",formValues.startTimeOfFirstBatch);
	        	  submitData.set("durationOfEachBatch",formValues.durationOfEachBatch);
	        	  submitData.set("intervalBetweenBatches",formValues.intervalBetweenBatches);
	        	  submitData.set("centerType",formValues.centerType);
	        	  submitData.set("feePlanId",formValues.feePlanId);
	        	  submitData.set("feePlanBillingDate",formValues.feePlanBillingDate);
	        	  submitData.set("applicationFlag",formValues.applicationFlag);
	        	  submitData.set("applicationFormat",0);
	        	  submitData.set("applicationStartDate",formValues.applicationStartDate);
	        	  submitData.set("whetherMultipleBatches",true);
	        	  submitData.set("applicationTillDate",formValues.applicationTillDate);
	        	  submitData.set("whetherOnlineSubmission",false);/**This field is by default set to false becoz field is disabled at the UI side.*/
	        	  submitData.set("whetherStudentSelectCenter",formValues.whetherStudentSelectCenter);
	        	  submitData.set("whetherStudentReschedule",false);/**This field is by default set to false becoz field is disabled at the UI side.*/
	        	  submitData.set("whetherResultsApproved",formValues.whetherResultsApproved);
	        	  if(!isNullOrEmpty(formValues.evaluationGroupStatusText)){
	        		  submitData.set("evaluationGroupStatus",formValues.evaluationGroupStatusText);   
	        	  }else{
	        		  submitData.set("evaluationGroupStatus",formValues.evaluationGroupStatus);   
	        	  }
	        	  submitData.set("studentCanChoosePartOfEvaluationGroup",formValues.studentCanChoosePartOfEvaluationGroup);
	        	  submitData.set("studentRescheduleTillDate",formValues.studentRescheduleTillDate);
	        	  submitData.set("selectedCenters",selectedCentersId);
	        	  submitData.set("approverId",formValues.approverId);
	        	  if(!isNullOrEmpty(formValues.academicTerm)){
	        		  submitData.set("academicTermId",formValues.academicTerm);   
	        	  }
	        	  /**
	        	   * Values of define rules window from store 
	        	   */
	        	  var store=$this.getStore('examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesFormStore');
	        	  if(store.data.items.length>0&&store.data.items!=null){
	        		  var defineRuleData=store.data.items[0].data;
	        		  submitData.set("droolsRuleRanking",defineRuleData.droolsRuleRanking);
		        	  submitData.set("droolsRuleRankingDescription",defineRuleData.droolsRuleRankingDescription);
		        	  submitData.set("entryCriteria",defineRuleData.entryCriteria);
		        	  submitData.set("exitCriteria",defineRuleData.exitCriteria);
		        	  submitData.set("entryCriteriaDescription",defineRuleData.entryCriteriaDescription);
		        	  submitData.set("exitCriteriaDescription",defineRuleData.exitCriteriaDescription);
		        	  submitData.set("maxAttempts",defineRuleData.maxAttempts);
		        	  submitData.set("ageMin",defineRuleData.ageMin);
		        	  submitData.set("ageMax",defineRuleData.ageMax);
	        	  }
	        	 
	        	  var createEvalGorupCreate=true;
	        	  if(formValues.id>0&&formValues.id!=""){
	        		  submitData.set("id",formValues.id);
	        	   /**
					 * evaluationGroupCode this field is used to show field at the time of showing eval group name.
					 * evaluationGroupCodeUpdate this is used to send data at the time of update in hidden.
					 */
	        		 // submitData.set("evaluationGroupCode",formValues.evaluationGroupCode);
	        		  submitUrl = SERVERURL.EVAL_GROUP_DETAIL_UPDATE_URL;
	        		  createEvalGorupCreate=false;
	        	  }else{
	        		  createEvalGorupCreate=true;
	        		  submitUrl = SERVERURL.CREATE_EVAL_GROUP_DETAIL_URL;
	        	  }
	        	  delete submitData.data.seatTypeId;
	        	  var fData = Ext.encode(submitData.data);
	        	  /**
					* Here we save the data
					*/
	        	  
	        	  
	        	  if(isScheduleDatePassed){
	        	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					 Ext.Ajax.request({
	             		 type: 'rest',
	             		 url: submitUrl,
	             		 jsonData: fData,
	             		 method: 'POST',
	             		 success: function(resp, action) {
	             			 Ext.getBody().unmask();
	             			 var data = Ext.decode(resp.responseText);
	             			 if(data==false){
	             			   showWarningMessage(getExaminationTranslation('EVALUATION_GROUP'),getExaminationTranslation('EVAL_GROUP_EVAL_EVENT_WARNING_MSG'));
	             			 }else {
	             				 
	             				 if(createEvalGorupCreate){
	             				 
	             			 /**
	             			  * Save id after creating eval group and enable other tabs. 
	             			  * And make evaluationGroupCode ReadOnly
	             			  */
	             			 form.findField('id').setValue(data);
	             			 form.findField('evaluationGroupCode').setDisabled(true);
	             			 var tabStructure=$this.getManageevalgrouptabstructure();
	                       	
			   	               	 tabStructure.items.items[1].enable();
			   	               	 tabStructure.items.items[2].enable();
			   	               	 tabStructure.items.items[3].enable();
			   	               	 tabStructure.items.items[4].enable();
			   	               	 tabStructure.items.items[5].enable();
			   	           /**
							 * evaluationGroupCode this field is used show field at the time of showing eval group name.
							 * evaluationGroupCodeUpdate this is used to send data at the time of update in hidden.
							 */
			   	             var evaluationGroupCodeField=form.findField('evaluationGroupCode');
			   	             var evaluationGroupCodeUpdateField=form.findField('evaluationGroupCodeUpdate');
							      evaluationGroupCodeUpdateField.enable();  	 
							      evaluationGroupCodeUpdateField.setValue(evaluationGroupCodeField.getValue());
							      
	             			 }
	             				 
	             		     store.removeAll();
	             			 showSuccessMessage(getExaminationTranslation('EVALUATION_GROUP'), getExaminationTranslation('EVAL_GROUP_DETAIL_SUCCESS_MSG'));
	             			 grid.getStore().reload();
	             		   }
	             			Ext.defer(function() {
	             				btn.setDisabled(false);
	             			}, 1000);
	             		 }
	             	 });
	        	  } else{
	        		  showWarningMessage(getExaminationTranslation('EVALUATION_GROUP'),getExaminationTranslation('EVALUATION_GROUP_END_DATE_WARINING'));
	        	  }
	          },
	          checkOnApplicationFormat:function(){
	        	  var $this=this;
	        	  var form =$this.getEvalgroupdetailform().getForm();
	        	  var formValues=form.getValues();
	        	  
	        	  var applicationFormat=form.findField('applicationFormat');
	        	  if(!formValues.whetherOnlineSubmission&&formValues.applicationFlag==getExaminationTranslation('CNTRL_APPLICATION_REQUIRED')){
	        		
	        		  applicationFormat.setVisible(true);
	        	  }
	          }
});