/**
 * @author sumit.meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.evaluationresult.EvaluationResultController', {
	extend : 'Academia.controller.base.BaseController',
	models : [],
	stores : ['common.ProgramByAcademyLocationStore','common.BatchesByProgramId','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','examinationcenters.evaluationresult.EvaluationResultCourseByPBS',
	          'examinationcenters.evaluationresult.EvaluationLevel','course.CourseComboStore','coursetransaction.sectionmanagement.CoruseVariantSectionStore',
	          'examinationcenters.evaluationresult.EvaluationResultCourse','examinationcenters.evaluationresult.EvaluationResultStudent',
	          'attendance.StudentSearch','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
	          'attendance.AdmissionSearchByStudent','servicerequest.placementrequest.PlacementPrograms','examinationcenters.repetitioncompletion.RnCProgramsByVariantNAcadLocId',
	          'examinationcenters.remark.CourseEvaluationRemark','examinationcenters.reports.ExaminationReportProgramStore','examinationcenters.reports.ExaminationReportCourseStore',
	          'attendance.VariantMappedToPlan','attendance.VariantMapping','common.CurrentBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','servicerequest.withdrawfromcourseprogramservice.Courses',
	          'program.programDetails.programBatches.courseParameter.EvaluationResultStudentStore','committee.committee.CommitteeALMappingComboStore','examinationcenters.evaluationresult.AcademyLocationExamCenter',
		  	  'examinationcenters.reports.ExaminationReportStudentStore'],
	views : ['examinationcenters.evaluationresult.EvaluationResultStructure','examinationcenters.evaluationresult.EvaluationResultProgramFilter',
	         'examinationcenters.evaluationresult.EvaluationResultCourseFilter','examinationcenters.evaluationresult.EvaluationResultStudentFilter',
	         'examinationcenters.evaluationresult.EvaluationResultProgramGrid','examinationcenters.evaluationresult.EvaluationResultCourseGrid',
	         'examinationcenters.evaluationresult.EvaluationResultStudentGrid','studentPortal.EvaluationResultStructureForPortal',
	         'examinationcenters.evaluationresult.EvaluationResultSearchTab'
	],	
       refs : [{
    	   ref : 'evaluationresultstructure',
    	   selector : 'evaluationresultstructure' 
       },{
    	   ref : 'evaluationresultprogramfilter',
    	   selector : 'evaluationresultprogramfilter' 
       },{
    	   ref : 'evaluationresultcoursefilter',
    	   selector : 'evaluationresultcoursefilter' 
       },{
    	   ref : 'evaluationresultstudentfilter',
    	   selector : 'evaluationresultstudentfilter' 
       },{
    	   ref : 'evaluationresultprogramgrid',
    	   selector : 'evaluationresultprogramgrid' 
       },{
    	   ref : 'evaluationresultcoursegrid',
    	   selector : 'evaluationresultcoursegrid' 
       },{
    	   ref : 'evaluationresultstudentgrid',
    	   selector : 'evaluationresultstudentgrid' 
       },{
			ref : 'evaluationresultstructureforportal',
    	   selector : 'evaluationresultstructureforportal' 
		}, {
			ref: 'evaluationresultsearchtab',
			selector: 'evaluationresultsearchtab'
		}],
       init : function() {
    	   this.control({
    		   'evaluationresultprogramgrid':{
    			   afterrender:function(grid){
    				   grid.query('#btnExportToPDF')[0].setDisabled(true);
                       grid.query('#btnExportToExcel')[0].setDisabled(true);
                      
    			   }
    		   },
    		   'evaluationresultstructure':{
    			   render:function(obj){
    				   var academyLocationId=this.getCurrentAcademyLocation();
    				   var form=this.getEvaluationresultprogramfilter().getForm();
    				   var programField=form.findField('programId');
    				   var als = [];
    				   als.push(academyLocationId);
    				   programField.getStore().getProxy().extraParams = {
    					   academyLocationIds:als.join()
	   					};
    				   programField.getStore().load();
    				   
    				   var courseFilter=this.getEvaluationresultcoursefilter().getForm();
    				   var courseField=courseFilter.findField('courseId');
    				   courseField.getStore().getProxy().extraParams = {
    					   academyLocationIds:als.join()
	   					};
    				   courseField.getStore().load();
    				   
    				    var programGrid=this.getEvaluationresultprogramgrid();
                        var studentGrid=this.getEvaluationresultstudentgrid();
						var courseGrid=this.getEvaluationresultcoursegrid(); 
						programGrid.getStore().removeAll();
						studentGrid.getStore().removeAll();
						courseGrid.getStore().removeAll();
    				   
    			   },
    			   
    			   afterrender : function() {
    				   var $this = this;
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   $this.getEvaluationresultprogramfilter().down('#periodItemId').setVisible(false);
    				   } else {
    					   $this.getEvaluationresultprogramfilter().down('#periodItemId').setVisible(true);
    				   }
    			   }
    		   },
    		   'evaluationresultstructure radiogroup[itemId=evaluationResultRadioItemId]':{
    			   change:function(obj,nv,ov){
                        var $this=this;
                        var programFilter=$this.getEvaluationresultprogramfilter();
                        var courseFilter=$this.getEvaluationresultcoursefilter();
                        var studentFilter=$this.getEvaluationresultstudentfilter();

						/**grid Stores should be clear on radio click V2D-411242 **/
						var programGrid=this.getEvaluationresultprogramgrid();
                        var studentGrid=this.getEvaluationresultstudentgrid();
						var courseGrid=this.getEvaluationresultcoursegrid(); 
						programGrid.getStore().removeAll();
						studentGrid.getStore().removeAll();
						courseGrid.getStore().removeAll();
                        /**end V2D-411242 **/
                        
						 var alinfomodel = Academia.model.authentication.ALInfoModel;
						 var wheatherSchool = alinfomodel.get('wheatherSchool');
                        
                        programFilter.setVisible(false);
                        courseFilter.setVisible(false);
                        studentFilter.setVisible(false);
                        
                        programFilter.getForm().reset();
                        courseFilter.getForm().reset();
                        studentFilter.getForm().reset();
                        
                        var programGrid=$this.getEvaluationresultprogramgrid();
                        programGrid.setVisible(false);
                        
                        var courseGrid=$this.getEvaluationresultcoursegrid();
                        courseGrid.setVisible(false);
                        
                        var studentGrid=$this.getEvaluationresultstudentgrid();
                        studentGrid.setVisible(false);
                        
                        if(nv.evaluationResult==0){
                        	programFilter.setVisible(true);
                        	programGrid.setVisible(true);
                        	$this.resetByProgBatchSection();
							 if(wheatherSchool) {
								 programFilter.down('#periodItemId').setVisible(false);
							 }
                        }else if(nv.evaluationResult==1){
                        	courseFilter.setVisible(true);
                        	courseGrid.setVisible(true);
                        	//$this.resetByCourse();
							 if(wheatherSchool) {
								 courseFilter.down('#periodItemId').setVisible(false);
							 }
                        }else if(nv.evaluationResult==2){
							studentFilter.setVisible(true);
                        	studentGrid.setVisible(true);
							//$this.resetByStudent();
							 if(wheatherSchool) {
								 studentFilter.down('#periodItemId').setVisible(false);
							 }
                        	
                        var studentFilter=this.getEvaluationresultstudentfilter().getForm();
						var evaluationLevel=studentFilter.findField('evaluationLevel');
						evaluationLevel.enable();
          			    var studentField=studentFilter.findField('studentId');
          			    studentField.reset();
                        var admissionField=studentFilter.findField('admissionId');
                        admissionField.reset();
                        //admissionField.setDisabled(true);
                    	/**
                    	 * Load data in student combo 
                    	 */
                         /*  var studentFilter=this.getEvaluationresultstudentfilter().getForm();
         				   var studentField=studentFilter.findField('studentId');
         				   studentField.getStore().getProxy().extraParams = {
         					   restrictToAL:true
     	   					   };
         				   studentField.getStore().load();
         				   
         				  var admissionField=studentFilter.findField('admissionId');
	       				   admissionField.getStore().getProxy().extraParams = {
	       					   restrictToAL:true
	   	   					   };
	       				   admissionField.getStore().load();*/
						   
						   if (this.getCurrentLoggedPortalId() == 1) {
						       var locationId = this.getCurrentAcademyLocation();
						       var locationCombo = studentFilter.findField('academyLocationComboExamination');
							   locationCombo.getStore().load({
								   callback: function(records, operation, success) {
									   if (success) {
										   locationCombo.setValue(locationId);
									   }
								   }
							   });

							   studentField.getStore().getProxy().extraParams = {
								   academyLocationIds: locationId != null 
								                          ? locationId.toString() 
								                          : null,
														  eventId:null ,
														  whetherMarksheet:true 
								};
							   studentField.getStore().load();
							   admissionField.getStore().getProxy().extraParams = {
								academyLocationId: locationId,
								isResultScreen:"yes"
								};
							   admissionField.getStore().load();					   
													   
						   }
						  
	                    }
    			   }
    		   },
    		   /**
    		    * Program batch and period Block
    		    */
    		   'evaluationresultprogramfilter customcombobox[itemId=programItemId]':{
    			   select:function(obj,record){
    				   var $this=this;
    				  // var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				  /* var batchField=form.findField('batchId');
    				   batchField.enable();
    				   batchField.getStore().getProxy().extraParams = {
    					   id:data
	   					   };
    				   batchField.getStore().load();*/

    				   var batchField=$this.getEvaluationresultprogramfilter().down('#batchItemId');
    				   var periodField=$this.getEvaluationresultprogramfilter().down('#periodItemId');
    				   var sectionField=$this.getEvaluationresultprogramfilter().down('#sectionItemId');
    				   var courseField=$this.getEvaluationresultprogramfilter().down('#courseItemId');
    				   
    				   batchField.reset();
    				   batchField.enable();
					   courseField.reset();
					   courseField.disable();  
    				   periodField.reset();
    				   periodField.disable();
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   periodField.setVisible(false);
    				   }
    				   var programId = record[0].get("id");
    				   if(programId > 0){
    					   var batchStore = batchField.getStore();

    					   batchStore.getProxy().extraParams = {
    						   programId: programId
    					   };
    					   batchStore.load({
    						   callback: function(records, operation, success) {
    							   if (success) {
    								   var batchId = 0;
    								   for(var i=0,j=0; i<records.length; i++){
    									   if (records.length == 1) {
    										   batchId = records[i].data.id;
    									   } else if(records[i].data.isCurrentPeriodOfProgram){
    										   if(j==0){
    											   batchId = records[i].data.id;
    											   j++;
    										   } else {
    											   batchId = 0;
    											   sectionField.reset();
    											   sectionField.disable();
    											   courseField.reset();
												   courseField.readOnly(true);
    											   return;
    										   }
    									   }
    								   }
    							   }
    							   if(batchId > 0){
    								   batchField.setValue(batchId);
    								   var periodStore = periodField.getStore();
    								   periodStore.getProxy().extraParams = {
    									   id : batchId
    								   };
    								   periodStore.load({
    									   callback: function(records, operation, success) {
    										   if (success) {
    											   if(records.length == 0){
    												   if(wheatherSchool) {
    													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    													   sectionField.reset();
    													   sectionField.enable();
    													   courseField.reset();
    													   courseField.enable();
    													  // $this.getEvaluationresultprogramfilter().down('#searchBtn').disable();
    												   }
    											   } else if(records.length == 1){
    												   periodField.enable();
    												   periodField.allowBlank=true;
    												   periodField.setValue(records[0].data.id);
    												   sectionField.reset();
    												   sectionField.enable();
    												   sectionField.getStore().getProxy().extraParams = {
    													   periodId: records[0].data.id
    												   };
    												   sectionField.getStore().load();
    												   if(wheatherSchool) {
    													   periodField.setVisible(false);
    												   }
    												   $this.loadCourseByProgramBatchPeriodSection();
    											   } else {
    												   periodField.enable();
    												   periodField.setVisible(true);
    												   sectionField.reset();
    												   sectionField.disable();
    												   $this.loadCourseByProgramBatchPeriodSection();
    											   }
    										   }
    									   }
    								   });
    							   }
    						   }
    					   });
    				   }
    				   
    				   
    				   
    				   /**
    				      * Load courses of PBS by Program,batch,period and section
    				      */
    			   }
    		   },
    		   'evaluationresultprogramfilter customcombobox[itemId=batchItemId]':{
    			   select:function(obj,record){
    				   var $this=this;
    				   // var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();

    				   var periodField=$this.getEvaluationresultprogramfilter().down('#periodItemId');
    				   var sectionField=$this.getEvaluationresultprogramfilter().down('#sectionItemId');
    				   var searchBtnField=$this.getEvaluationresultprogramfilter().down('#searchBtn');
    				   var courseField=$this.getEvaluationresultprogramfilter().down('#courseItemId');
    				   
    				   var batchId = record[0].get("id");
    				   periodField.enable();
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   periodField.setVisible(false);
    				   }
    				   if(batchId > 0){
    					   var periodStore = periodField.getStore();
    					   periodStore.getProxy().extraParams = {
    						   id : batchId
    					   };
    					   periodStore.load({
    						   callback: function(records, operation, success) {
    							  
    								   if(records.length == 0){
    									   if(wheatherSchool) {
    										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    										   sectionField.reset();
    										   sectionField.enable();
											   courseField.reset();
											 //  courseField.enable();
											  // $this.getEvaluationresultprogramfilter().down('#searchBtn').disable();
    									   }
    								   } else if(records.length == 1){
    									   periodField.enable();
    									   periodField.allowBlank=true;
    									   periodField.setValue(records[0].data.id);
    									   sectionField.reset();
    									   sectionField.enable();
    									   sectionField.getStore().getProxy().extraParams = {
    										   periodId: records[0].data.id
    									   };
    									   sectionField.getStore().load();
    									   if(wheatherSchool) {
    										   periodField.setVisible(false);
    									   }
    									   $this.loadCourseByProgramBatchPeriodSection();
    								   } else {
    									   periodField.setVisible(true);
    									   periodField.enable();
    									   $this.loadCourseByProgramBatchPeriodSection();
    								   }
    							  
    						   }
    					   });
    				   }


    				   /*   var periodField=form.findField('periodId');
    				   periodField.enable();
    				   periodField.getStore().getProxy().extraParams = {
    					   id:data
	   					   };
    				   periodField.getStore().load();*/
    				   /**
    				    * Load courses of PBS by Program,batch,period and section
    				    */
    			   }
    		   },
    		   'evaluationresultprogramfilter customcombobox[itemId=periodItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				   var sectionField=form.findField('sectionId');
    				   sectionField.enable();
    				   sectionField.getStore().getProxy().extraParams = {
    					   periodId:data
	   					   };
    				   sectionField.getStore().load();
    				   /**
  				      * Load courses of PBS by Program,batch,period and section
  				      */
  			       this.loadCourseByProgramBatchPeriodSection();
    			   }
    		   },
    		   'evaluationresultprogramfilter multiselectcombofield[itemId=sectionItemId]':{
    			   change:function(obj,rec){
    				   /**
  				      * Load courses of PBS by Program,batch,period and section
  				      */
  			       this.loadCourseByProgramBatchPeriodSection();
    			   }
    		   },
    		   'evaluationresultprogramfilter button[itemId=searchBtn]':{
    			   click:function(obj){
						
    				   var filterForm = obj.up('form');
    				   var form=obj.up('form').getForm();
    				   var formValues=form.getValues();
    				   var programGrid=this.getEvaluationresultprogramgrid();
    				   var columnModel=[];

    				   //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				     
    				   columnModel.push({
      					   header:getExaminationTranslation('ADMISSION_ID'),
      					   dataIndex:'ADMISSION_CODE',
      					   flex:.1
      				   },{
      					   header:getExaminationTranslation('STUDENT_ID'),
      					   dataIndex:'STUDENT_CODE',
      					   flex:.1
      				   },{
      					   header:getExaminationTranslation('STUDENT_NAME'),
      					   dataIndex:'STUDENT_NAME',
      					   flex:.1
      				   },{
      					   header:getExaminationTranslation('PERIOD_RANK'),
      					   dataIndex:'PERIOD_RANK',
      					   flex:.1
      				   },{
      					   header:getExaminationTranslation('SECTION_RANK'),
      					   dataIndex:'SECTION_RANK',
      					   hidden:true,
      					   flex:.1
      				   });
    				   
                  var gridModel=['id','version','STUDENT_NAME','PERIOD_RANK','SECTION_RANK',
                                 'ADMISSION_ID','ADMISSION_CODE','STUDENT_CODE'];

                  /**
                   * Dynamic columns and store are creating according to the course code.
                   */
    				   if(!isNullOrEmpty(formValues.courseId)){
    					   
    					   for(var i=0;i<formValues.courseId.length;i++){
    						   var index=2;
    			       			  if(Ext.isObject(formValues.courseId[i])){
									   var code=(formValues.courseId[i].get('code'));
										code = code.replace(/ ?\./g,"");
										code = code.replace (/ /g, ""); 
    			       				   var datIndex=code+"_MARKS";
    			       				   var data={
    			    						   header:formValues.courseId[i].get('code')+" Marks/Grade",
    			          					   dataIndex:datIndex,
    			          					   flex:.1,
    			          					   renderer:function(value,meta,record){
    			          						 return getExaminationTranslation(value);
    			          					   }
    			    				     };
    			       				 columnModel.splice(2,0, data);
    			       				 gridModel.push(datIndex);
    			                     }else{
										  var code=(formValues.courseId[i]); 
										  code = code.replace(/ ?\./g,"");
										  code = code.replace (/ /g, ""); 
    			                    	 var datIndex=code+"_MARKS";
    			                    	 var data={
      			    						   header:formValues.courseId[i]+" Marks/Grade",
      			          					   dataIndex:datIndex,
      			          					   flex:.1,
      			          					   renderer:function(value,meta,record){
      			          						   return getExaminationTranslation(value);
      			          					   }
      			    				     };
    			                    	 columnModel.splice(index,0, data);
    			                    	 gridModel.push(datIndex);
    			                     }
    			       			    index++;
    			       		     }
    				   }
    				   
    				   Ext.define('EvaluationResultProgramModel', {
    					    extend: 'Ext.data.Model',
    					    fields: gridModel
    					});
    				   
    				   var evaluationResultProgramStore = Ext.create('Ext.data.Store', {
    					    model: 'EvaluationResultProgramModel',
      	            	    autoLoad : false,
      	            		proxy : {
      	            			type : 'rest',
      	            			api:{
      	            				read:SERVERURL.EVALUATION_RESULT_PROGRAM_GRID_URL
      	            			},
      	            			reader: {
      	            				type:'json',
      	            				root:'rows',
      	            				property:'records'
      	            			}
      	            		  }
      	            	    });
    				   programGrid.reconfigure(evaluationResultProgramStore,columnModel);
    				   
    				   var sectionIdsArray=[];
                       if(!isNullOrEmpty(formValues.sectionId)){
    					 for(var j=0;j<formValues.sectionId.length;j++){
    						 if(Ext.isObject(formValues.sectionId[j])){
    							     sectionIdsArray.push(formValues.sectionId[j].data.sectionId);	  
			                     }else{
			                    	 sectionIdsArray.push(formValues.sectionId[j]);
			                     }
    					   }
                       }
    				   programGrid.getStore().getProxy().extraParams = {
    		    			  programId:formValues.programId,
    		    			  batchId:formValues.batchId,
    		    			  periodId:formValues.periodId,
    		    			  sectionIds:sectionIdsArray.join()
    		   				   };
    				   programGrid.getStore().load({
    					   callback:function(record){
    						   if(record.length >0){
    							   programGrid.query('#btnExportToPDF')[0].setDisabled(false);
    							   programGrid.query('#btnExportToExcel')[0].setDisabled(false);
    	                            
    						   }
    					   }
    				   });
    				   programGrid.config.searchFilterForm = filterForm;
    				 	/*var taskDelay = new Ext.util.DelayedTask(function(){
				      		Ext.getBody().unmask();
				      	  });
				      	taskDelay.delay(1000);*/
    				   
    			   }
    		   },
    		   'evaluationresultprogramfilter button[itemId=resetBtn]':{
    			   click:function(obj){
    				   this.resetByProgBatchSection(obj);
    			   }
    		   },
    		   /**
    		    * Program batch and period block ends
    		    */
    		   /**
    		    *Course Block Start 
    		    */
    		   'evaluationresultcoursefilter customcombobox[itemId=courseItemId]':{
    			   select:function(obj,rec){
    				   var $this = this;
    				   var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				   var courseField=form.findField('variantId');
    				   form.findField('programId').reset();
    				   form.findField('batchId').reset();
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   form.findField('sectionId').clearValue();
    				   form.findField('evaluationLevel').reset();
    				   form.findField('variantId').reset();
    				   
    				   form.findField('programId').disable();
    				   form.findField('batchId').disable();
    				   form.findField('periodId').disable();
    				   form.findField('sectionId').disable();
    				   form.findField('variantId').disable();
    				   
    				   courseField.enable();
    				   courseField.getStore().getProxy().extraParams = {
    					   courseId:data,
    					   academyLocationId:$this.getCurrentAcademyLocation()
 		   				   };
    				   courseField.getStore().load();
    				  // form.isValid();
    			   }
    		   },
    		   /**
    		    * Load program filter by course Variant
    		    */
    		   'evaluationresultcoursefilter customcombobox[itemId=variantItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				   var programField=form.findField('programId');
    				   programField.enable();
    				   programField.reset();
    				   programField.getStore().getProxy().extraParams = {
    					   courseVariantIds:data
 		   				   };
    				   programField.getStore().load();
    				   form.findField('batchId').reset();
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   //form.isValid();
    			   }
    		   },
    		   /**
    		    * Load courses filters. Load course by program
    		    */
    		   'evaluationresultcoursefilter customcombobox[itemId=programItemId]':{
    			   select:function(obj,record){
    				   var $this=this;
    				  // var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();

    				   var batchField=$this.getEvaluationresultcoursefilter().down('#batchItemId');
    				   var periodField=$this.getEvaluationresultcoursefilter().down('#periodItemId');
    				   var sectionField=$this.getEvaluationresultcoursefilter().down('#sectionItemId');
    				   batchField.reset();
    				   batchField.enable();
    				   periodField.reset();
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   periodField.setVisible(false);
    				   }
    				   var programId = record[0].get("id");
    				   if(programId > 0){
    					   var store = this.getStore('common.CurrentBatchStore');

    					   store.getProxy().extraParams = {
    						   programId: programId
    					   };
    					   store.load({
    						   callback: function(records, operation, success) {
    							   if (success) {
    								   var batchId = 0;
    								   for(var i=0,j=0; i<records.length; i++){
    									   if (records.length == 1) {
    										   batchId = records[i].data.id;
    									   } else if(records[i].data.isCurrentPeriodOfProgram){
    										   if(j==0){
    											   batchId = records[i].data.id;
    											   j++;
    										   } else {
    											   batchId = 0;
    											   sectionField.reset();
    											   sectionField.disable();
    											   return;
    										   }
    									   }
    								   }
    							   }
    							   if(batchId > 0){
    								   batchField.setValue(batchId);
    								   var store = $this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
    								   store.getProxy().extraParams = {
    									   id : batchId
    								   };
    								   store.load({
    									   callback: function(records, operation, success) {
    										   if (success) {
    											   if(records.length == 0){
    												   if(wheatherSchool) {
    													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    													   sectionField.reset();
    													   sectionField.enable();
    													   sectionField.getStore().loadRawData([]);
    												   }
    											   } else if(records.length == 1){
    												   periodField.enable();
    												   periodField.setValue(records[0].data.id);
    												   sectionField.reset();
    												   sectionField.enable();
    												   sectionField.getStore().getProxy().extraParams = {
    													   periodId: records[0].data.id
    												   };
    												   sectionField.getStore().load();
    												   if(wheatherSchool) {
    													   periodField.setVisible(false);
    												   }
    											   } else {
    												   periodField.enable();
    												   periodField.setVisible(true);
    												   sectionField.reset();
    												   sectionField.disable();
    											   }
    										   }
    									   }
    								   });
    							   }
    						   }
    					   });
    				   }

    				   /* form.findField('batchId').reset();
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   var batchField=form.findField('batchId');
    				   batchField.enable();
    				   batchField.getStore().getProxy().extraParams = {
    					   id:data
	   					   };
    				   batchField.getStore().load();*/

    				 ///  form.isValid();
    			   }
    		   },
    		   /**
    		    * Load courses filters. Load period by batch
    		    */
    		   'evaluationresultcoursefilter customcombobox[itemId=batchItemId]':{
    			   select:function(obj,record){
    				   var $this=this;
    				   //var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				   
    				   var periodField=$this.getEvaluationresultcoursefilter().down('#periodItemId');
    				   var sectionField=$this.getEvaluationresultcoursefilter().down('#sectionItemId');
    				   
    				   var batchId = record[0].get("id");
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   periodField.setVisible(false);
    				   }
    				   if(batchId > 0){
    					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
    					   store.getProxy().extraParams = {
    						   id : batchId
    					   };
    					   store.load({
    						   callback: function(records, operation, success) {
    							   if (success) {
    								   if(records.length == 0){
    									   if(wheatherSchool) {
    										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    										   sectionField.reset();
    										   sectionField.enable();
    										   sectionField.getStore().loadRawData([]);
    									   }
    								   } else if(records.length == 1){
    									   periodField.enable();
    									   periodField.allowBlank=true;
    									   periodField.setValue(records[0].data.id);
    									   sectionField.reset();
    									   sectionField.enable();
    									   sectionField.getStore().getProxy().extraParams = {
    										   periodId: records[0].data.id
    									   };
    									   sectionField.getStore().load();
    									   if(wheatherSchool) {
    										   periodField.setVisible(false);
    									   }
    									   $this.loadCourseByProgramBatchPeriodSection();
    								   } else {
    									   periodField.setVisible(true);
    									   periodField.enable();
    									   $this.loadCourseByProgramBatchPeriodSection();
    								   }
    							   }
    						   }
    					   });
    				   }

    				   
    				  /* form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   var periodField=form.findField('periodId');
    				   periodField.enable();
    				   periodField.getStore().getProxy().extraParams = {
    					   id:data
	   					   };
    				   periodField.getStore().load();*/
    				   
    				 //  form.isValid();
    			   }
    		   },
    		   /**
    		    * Load courses filters. Load sections by period
    		    */
    		   'evaluationresultcoursefilter customcombobox[itemId=periodItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				   form.findField('sectionId').reset();
    				   var sectionField=form.findField('sectionId');
    				   sectionField.enable();
    				   sectionField.getStore().getProxy().extraParams = {
    					   periodId:data
	   					   };
    				   sectionField.getStore().load();
    				  // form.isValid();
    			   }
    		   },'evaluationresultcoursefilter customcombobox[itemId=evaluationLevel]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
					   var formValues=form.getValues();
					   var courseGrid=this.getEvaluationresultcoursegrid();
    				   form.findField('sectionId').reset();
					    if(formValues.evaluationLevel==getExaminationTranslation("CNTRL_EVENT")){ 
                    	   courseGrid.columns[3].setVisible(true);
						   courseGrid.columns[4].setVisible(false);
                       }else{
							courseGrid.columns[3].setVisible(false);
							 courseGrid.columns[4].setVisible(true); 
							}
    				   
    			   }
    		   },
    		   'evaluationresultcoursefilter button[itemId=searchBtn]':{
    			   click:function(obj){
    				   var $this = this;
    				   var filterForm = obj.up('form');
    				   var form=obj.up('form').getForm();
    				   var formValues=form.getValues();
    				   var courseGrid=this.getEvaluationresultcoursegrid();
    				   //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				      	
    				   var sectionIdsArray=[];
                       if(!isNullOrEmpty(formValues.sectionId)){ 
    					 for(var j=0;j<formValues.sectionId.length;j++){
    						 if(Ext.isObject(formValues.sectionId[j])){
    							     sectionIdsArray.push(formValues.sectionId[j].data.sectionId);	  
			                     }else{
			                    	 sectionIdsArray.push(formValues.sectionId[j]);
			                     }
    					   }
                       }

                       
                       if(formValues.evaluationLevel==getExaminationTranslation("CNTRL_EVENT")){ 
                    	   courseGrid.columns[3].setVisible(true);
						   courseGrid.columns[4].setVisible(false);
                       }else{
							courseGrid.columns[3].setVisible(false); 
							 courseGrid.columns[4].setVisible(true);
							}
                       
    				   courseGrid.getStore().getProxy().extraParams = {
    					   periodId:formValues.periodId,
    					   courseId:formValues.courseId,
						   courseVariantId:formValues.variantId,
						   programId:formValues.programId,
						   batchId:formValues.batchId,
						   sectionIds:sectionIdsArray.join(),
						   courseEventEnum:formValues.evaluationLevel,
						   sort:null
	   					   };
    				   // courseGrid.getStore().load();  /*comment for V2D-433654 */
    				   courseGrid.config.searchFilterForm = filterForm;
    				   /*var taskDelay = new Ext.util.DelayedTask(function(){
				      		Ext.getBody().unmask();
				      	  });
				      	taskDelay.delay(1000);*/
    				   $this.resetPageSetting(courseGrid.getStore(), courseGrid);
    				   courseGrid.getStore().load();     
    				 //  courseGrid.getSelectionModel().deselectAll();
    				 //  courseGrid.getStore().pageSize=100;
    			   }
    		   },
    		   'evaluationresultcoursefilter button[itemId=resetBtn]':{
    			   click:function(obj){
    				   this.resetByCourse();
    			   }
    		   },
    		   /**
    		    *Student Block Start 
    		    */
    		   'evaluationresultstudentfilter':{
    			   render : function(form){
    				   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
    					   var $this = this;
    					   var student = form.down("#studentItemId");
    					   var admission = form.down("#admissionItemId");
    					   var academyLocationComboExamination = form.down("#academyLocationComboExamination");
    					   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    					   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
    					   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
    					   var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
                           var admissionId = null
    					   var programId = form.down("#programItemId");
                           var academyLocationIds = new Ext.util.HashMap();
                           var programIds = new Ext.util.HashMap();
       						var periodIds = new Ext.util.HashMap();
       						var currentProgram=new Ext.util.HashMap();
    					   var batchCombo = form.down("#batchItemId");
    					   var alinfomodel = Academia.model.authentication.ALInfoModel;
    					   var wheatherSchool = alinfomodel.get('wheatherSchool');
    					   form.getForm().findField('variantId').getStore().removeAll();
    					   
    					   Ext.each(studentPortalInfo.pastProgramBatchDetails, function(currentRecord){
    							academyLocationIds.add(parseInt(currentRecord.academyLocationId),currentRecord.academyLocationId);
    							programIds.add(parseInt(currentRecord.programId),currentRecord.programId);
    	           	    	});
    					   //V2D-38321
    					   if(wheatherSchool){
    						   form.down("#periodItemId").setVisible(false);
    						   form.down("#periodItemId").allowBlank=true;
    					   }else{
    						   form.down("#periodItemId").setVisible(true);
    						   form.down("#periodItemId").allowBlank=false;
    					   }
    					   var academyLocationIdsArray = academyLocationIds.getKeys();
    	     				var programIdsArray = programIds.getKeys();
    	     				if(academyLocationIdsArray.length==1){
    	     					academyLocationComboExamination.hide();
    						}
    						else{
    							academyLocationComboExamination.show();
    						}
    					   programId.setDisabled(false);
    					   academyLocationComboExamination.getStore().getProxy().extraParams = {
    						   academyLocationIds:academyLocationIdsArray.join()
							  
						   };
    					   academyLocationComboExamination.getStore().load({
							   callback : function(records, success){
								   if(success){
									   if(records.length>0){
										   academyLocationComboExamination.setValue($this.getCurrentAcademyLocation())
									   }
									  
								   }
							   }
						   });
    					   student.allowBlank=true;
    					   admission.allowBlank=true;
    					   student.setVisible(false);
    					   admission.setVisible(false);
    					   programId.getStore().getProxy().extraParams = {
    						   programIds :programIdsArray.join(),
							   academyLocationIds:$this.getCurrentAcademyLocation()
						   };
    					   programId.getStore().load({
    						   callback : function(records, success){
    							   if(success){
    								   form.down("#programItemId").setValue(studentprogramId);
    								   form.getForm().findField('evaluationLevel').setDisabled(false);
    								   form.getForm().findField('variantId').setDisabled(false);
    								   form.down("#batchItemId").setDisabled(false);
    								   batchCombo.getStore().getProxy().extraParams = { 
    									   programId:studentprogramId,
    									   studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
    									   onlyCurrentRecord:false
    								   };
    								   batchCombo.getStore().load({
    									   callback : function(records, success){
    										   if(success){
    											   form.down("#batchItemId").setValue(studentbatchId);
    											   var periodField=form.getForm().findField('periodId');
    											   periodField.setDisabled(false);
    											   periodField.getStore().getProxy().extraParams = {
    												   id:studentbatchId,
    												   studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
    												   onlyCurrentRecords:false
    											   };
    											   periodField.getStore().load({
    												   callback : function(records, success){
    													   if(success){
    														   if(records.length>0){
    															   periodField.setValue(records[0].get('id'));
    															   var sectionField=form.getForm().findField('sectionId');
    															   sectionField.setDisabled(false);
    															   sectionField.getStore().getProxy().extraParams = {
    																   periodId:records[0].get('id'),
    			    												   studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
    			    												   onlyCurrentRecords:false
    															   };
    															   sectionField.getStore().load({
    																   callback : function(records, success){
    																	   if(success){
    																		   if(records.length==1){
    																			   sectionField.setValue(records[0].get('sectionId'));
    																		   }
    																	   }
    																   }
    															   });
    														   }
    														   else{
    															   periodField.setValue(studentperiodId);
    														   }
    														   /*
    														    * Load course by program batch and period
    														    */
    														   $this.loadCoursesByProgramBatchAndPeriod();
    													   }
    												   }
    											   });
    										   }
    									   }
    								   });
    							   }
    						   }
    					   });
    				   }
    			   }
    		   },
    		   'evaluationresultstudentfilter customcombobox[itemId=studentItemId]':{
    			   select:function(obj,rec){
    				   var $this = this;
    				   var form=obj.up('form').getForm();
    				   var admissionField=form.findField('admissionId');
    				   form.findField('admissionId').reset();
    				   form.findField('batchId').reset();
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   form.findField('courseId').reset();
    				   form.findField('variantId').reset();
    				   form.findField('variantId').getStore().removeAll();
    				   form.findField('evaluationLevel').reset();
					   var alId=form.findField('academyLocationComboExamination');
					   var studId=form.findField('studentId');
    				   admissionField.enable();
    				   admissionField.getStore().getProxy().extraParams = {
    					   studentId:studId.getValue(),
    					   admissionId:null,
						   academyLocationId:alId.getValue(),
						   isResultScreen:"Yes"
    					};
    				   admissionField.getStore().load({
	            		   callback: function(records, success) {
	            			   if (success) {
	            				   if(records.length>0){
	            					   admissionField.setValue(records[0].data.id);
	            					   /**
	                				    * Load program of student by admissionId and studentId 
	                				    */
	            					   $this.loadProgramByAdmissionStudent();
	            				   }		 
	            			   }
	            		   }	   
	            	   });	
    				  
    			   }
    		   },
    		   'evaluationresultstudentfilter customcombobox[itemId=admissionItemId]':{
    			   select:function(obj,rec){
    				   var $this = this;
    				   var form=obj.up('form').getForm();
    				   form.findField('batchId').reset();
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   form.findField('courseId').reset();
    				   form.findField('variantId').reset();
    				   form.findField('variantId').getStore().removeAll();
    				   form.findField('evaluationLevel').reset();
					   var admissionId=form.findField('admissionId');
    				   
    				   var studentIdField = form.findField("studentId");
    				   studentIdField.getStore().getProxy().extraParams = {
    					   admissionId:admissionId.getValue(),
    					   studentId:null
    					};
    				   studentIdField.getStore().load({
	            		   callback: function(records, success) {
	            			   if (success) {
	            				   if(records.length>0){
	            					   studentIdField.setValue(records[0].data.id);
	            					   /**
	                				    * Load program of student by admissionId and studentId 
	                				    */
	                				   $this.loadProgramByAdmissionStudent();
	            				   }		 
	            			   }
	            		   }	   
	            	   });	
    			   }
    		   },
    		   
    		   'evaluationresultstudentfilter customcombobox[itemId=courseItemId]':{
					select:function(obj,rec){
						var data=rec[0].data.id;
						var filterForm=obj.up('form').getForm();
						var variantField=filterForm.findField('variantId');
						variantField.reset();
						variantField.enable();
						variantField.getStore().getProxy().extraParams = {
							courseId:data
	   					   };
						variantField.getStore().load({ 
							callback:function(rec,success){
								if(rec.length==1){
									variantField.setValue(rec[0].data.id);
							  }
							}
						});
					}
    		   },
    		   
    		   'evaluationresultstudentfilter customcombobox[itemId=evaluationLevelItemId]':{
					select:function(obj,rec){
						var $this=this;
						var filterForm=obj.up('form').getForm();
						filterForm.findField('courseId').reset();
						filterForm.findField('variantId').reset();
						filterForm.findField('variantId').getStore().removeAll();
					$this.getEvaluationresultstudentfilter().down('#searchBtn').enable(); //V2D-401826
					}
   		   },
    		   
    		   /*'evaluationresultstudentfilter customcombobox[itemId=courseItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.courseId;
    				   var form=obj.up('form').getForm();
    				   
    				   
    				   var variantField=form.findField('variantId');
    				   variantField.enable();
						  var store=this.getStore('coursetransaction.sectionmanagement.CoruseVariantSectionStore');
						  store.getProxy().extraParams={
							  courseId:data
						  };
						  store.load();
    			   }
    		   },*/
    		   /**
    		    * Load courses filters. Load course by program
    		    */
    		   'evaluationresultstudentfilter customcombobox[itemId=programItemId]':{
    			   select:function(obj,record){
    				   var $this=this;
    				   //var data=rec[0].data.programId;
    				   var form=obj.up('form').getForm();
    				   
    				   var batchField=$this.getEvaluationresultstudentfilter().down('#batchItemId');
    				   var periodField=$this.getEvaluationresultstudentfilter().down('#periodItemId');
    				   var sectionField=$this.getEvaluationresultstudentfilter().down('#sectionItemId');
					   var studentId=$this.getEvaluationresultstudentfilter().down("#studentItemId")
					   studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal(),
					    studentprogramId = studentPortalInfo.programBatchDetails.programId,
					    studentbatchId = studentPortalInfo.programBatchDetails.batchId,
					    studentperiodId = studentPortalInfo.programBatchDetails.periodId;
    				   batchField.reset();
    				   batchField.enable();
    				   periodField.reset();
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   periodField.setVisible(false);
    				   }
    				   var programId = record[0].get("programId");
    				   if(programId > 0){
    					   var store = this.getStore('common.CurrentBatchStore');

    					   store.getProxy().extraParams = {
    						   programId: programId,
    						   studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
    						   onlyCurrentRecord:false
    					   };
    					   store.load({
    						   callback: function(records, operation, success) {
    							   if (success) {
    								   if((batchField.getStore().find('id',studentbatchId)) >= 0){
    									   batchField.setValue(studentbatchId);
    									   periodField.getStore().getProxy().extraParams = {
    										   id:studentbatchId,
    		    					             studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
    		    					             onlyCurrentRecords:false
    		    				                };
    									   periodField.getStore().load({
		    				                	callback:function(records){
		    				                		
		    											   if(records.length == 0){
		    												   if(wheatherSchool) {
		    													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		    													   sectionField.reset();
		    													   sectionField.enable();
		    													   sectionField.getStore().loadRawData([]);
		    												   }
		    											   } else if(records.length == 1){
		    												   periodField.enable();
		    												   periodField.setValue(records[0].data.id);
		    												   sectionField.reset();
		    												   sectionField.enable();
		    												   sectionField.getStore().getProxy().extraParams = {
		    													   periodId: records[0].data.id,
		    			    									   studentId:studentId.getValue(),
		    			    									   onlyCurrentRecords:false
		    												   };
		    												   sectionField.getStore().load({
																   callback : function(records, success){
																	   if(success){
																		   if(records.length==1){
																			   sectionField.setValue(records[0].get('sectionId'));
																		   }
																	   }
																   }
															   });
		    												   
		    												   if(wheatherSchool) {
		    													   periodField.setVisible(false);
		    												   }
		    												   $this.loadCoursesByProgramBatchAndPeriod();
		    											   } else {
		    												   periodField.enable();
		    												   periodField.setVisible(true);
		    												   sectionField.reset();
		    												   sectionField.disable();
		    												   $this.loadCoursesByProgramBatchAndPeriod();
		    											   }
		    										   
		    				                		}
		    				                	
		    				                });
    								   }else if(records.length==1){
    									   batchField.setValue(records[0].get('id'));
    										
    									   periodField.getStore().getProxy().extraParams = {
    										   id:records[0].get('id'),
    		    					             studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
    		    					             onlyCurrentRecords:false
    		    				                };

    									   periodField.getStore().load({
    		    				                	callback:function(records){
    		    				                		
    		    											   if(records.length == 0){
    		    												   if(wheatherSchool) {
    		    													   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    		    													   sectionField.reset();
    		    													   sectionField.enable();
    		    													   sectionField.getStore().loadRawData([]);
    		    												   }
    		    											   } else if(records.length == 1){ 
    		    												   periodField.enable();
    		    												   periodField.setValue(records[0].data.id);
    		    												   sectionField.reset();
    		    												   sectionField.enable();
    		    												   sectionField.getStore().getProxy().extraParams = {
    		    													   periodId: records[0].data.id,
    		    			    									   studentId:studentId.getValue(),
    		    			    									   onlyCurrentRecords:false
    		    												   };
    		    												   sectionField.getStore().load({
    																   callback : function(records, success){
    																	   if(success){
    																		   if(records.length==1){
    																			   sectionField.setValue(records[0].get('sectionId'));
    																		   }
    																	   }
    																   }
    															   });
    		    												   if(wheatherSchool) {
    		    													   periodField.setVisible(false);
    		    												   }
    		    												   $this.loadCoursesByProgramBatchAndPeriod();
    		    											   } else {
    		    												   periodField.enable();
    		    												   periodField.setVisible(true);
    		    												   sectionField.reset();
    		    												   sectionField.disable();
    		    												   $this.loadCoursesByProgramBatchAndPeriod();
    		    											   }
    		    										   
    		    				                		}
    		    				                	
    		    				                });
    									}
    								   $this.loadCoursesByProgramBatchAndPeriod();
    							   }
    							  
    						   }
    					   });
    				   }

    				   
    				  /* var batchField=form.findField('batchId');
    				   form.findField('evaluationLevel').enable();
    				   form.findField('variantId').enable();
    				   batchField.enable();
    				   batchField.getStore().getProxy().extraParams = {
    					   id:data
	   					   };
    				   batchField.getStore().load();*/
    				   /*
    	    		    * Load course by program batch and period
    	    		    */
    				   
    	    		   form.findField('batchId').reset();
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
    				   form.findField('courseId').reset();
    				   form.findField('variantId').reset();
//    				   form.findField('evaluationLevel').reset();//V2D-401826
    				   $this.getEvaluationresultstudentfilter().down('#searchBtn').disable();
    			   }
    		   },
    		   /**
    		    * Load courses filters. Load period by batch
    		    */
    		   'evaluationresultstudentfilter customcombobox[itemId=batchItemId]':{
    			   select:function(obj,record){
    				   var $this=this;
    				   //var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				  /* var periodField=form.findField('periodId');
    				   periodField.enable();
    				   periodField.getStore().getProxy().extraParams = {
    					   id:data
	   					   };
    				   periodField.getStore().load();*
    				   /*
    	    		    * Load course by program batch and period
    	    		    */
    				   
    				   var periodField=$this.getEvaluationresultstudentfilter().down('#periodItemId');
    				   var sectionField=$this.getEvaluationresultstudentfilter().down('#sectionItemId');
    				   var searchBtnField=$this.getEvaluationresultstudentfilter().down('#searchBtn');
    				   var courseField=$this.getEvaluationresultstudentfilter().down('#courseItemId');
					   var studentId=$this.getEvaluationresultstudentfilter().down("#studentItemId");
    				   var batchId = record[0].get("id");
    				   var alinfomodel = Academia.model.authentication.ALInfoModel;
    				   var wheatherSchool = alinfomodel.get('wheatherSchool');
    				   if(wheatherSchool) {
    					   periodField.setVisible(false);
    				   }
    				   if(batchId > 0){
    					   var store = periodField.getStore(); //this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
    					   store.getProxy().extraParams = {
    						   id : batchId,
    						   studentId:studentId.getValue(),
    						   onlyCurrentRecords:false
    					   };
    					   store.load({
    						   callback: function(records, operation, success) {
    							   if (success) {
    								   if(records.length == 0){
    									   if(wheatherSchool) {
    										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    										   sectionField.reset();
    										   sectionField.enable();
    										   sectionField.getStore().loadRawData([]);
    										   courseField.reset();
											   courseField.enable();
											   courseField.getStore().loadRawData([]);
    									   }
    								   } else if(records.length == 1){
    									   periodField.enable();
    									   periodField.allowBlank=true;
    									   periodField.setValue(records[0].data.id);
    									   sectionField.reset();
    									   sectionField.enable();
    									   sectionField.getStore().getProxy().extraParams = {
    										   periodId: records[0].data.id,
    										   studentId:studentId.getValue(),
    			    						   onlyCurrentRecords:false
    									   };
    									   sectionField.getStore().load();
    									   if(wheatherSchool) {
    										   periodField.setVisible(false);
    									   }
    									   $this.loadCoursesByProgramBatchAndPeriod();
    								   } else {
    									   periodField.setVisible(true);
    									   periodField.enable();
    									   $this.loadCoursesByProgramBatchAndPeriod();
    								   }
    							   }
    						   }
    					   });
    				   }
    	    		   
    				   form.findField('periodId').reset();
    				   form.findField('sectionId').reset();
					   form.findField('courseId').reset();
					   form.findField('variantId').reset();
					   form.findField('variantId').getStore().removeAll();
					   form.findField('evaluationLevel').reset(); // V2D-401826
					   $this.getEvaluationresultstudentfilter().down('#searchBtn').disable();
					   form.isValid();
				   }
			   },

			   'evaluationresultstudentfilter customcombobox[itemId=evaluationLevelItemId]': {
				   select: function(obj, record) {
					if (portalId != 1) {
					            return; 
					 }
					   var filterPanel = this.getEvaluationresultstudentfilter();

					   var periodField = filterPanel.down('#periodItemId');
					   var saveBtnField = filterPanel.down('#searchBtn'); 
					   var batchCmp = filterPanel.down('#batchItemId');
					   var batchId = batchCmp ? batchCmp.getValue() : null;
					   var alinfomodel = Academia.model.authentication.ALInfoModel;
					   var wheatherSchool = alinfomodel.get('wheatherSchool');

					   var programId = filterPanel.down('#programItemId')
						   ? filterPanel.down('#programItemId').getValue()
						   : null;

					   if (wheatherSchool) {
						   if (periodField) {
							   periodField.setVisible(false);
						   }
						   // School = programId + batchId needed
						   var enableSave = (programId && batchId);
						   saveBtnField.setVisible(true);
						   saveBtnField.setDisabled(!enableSave);
						   return;
					   }
					   if (portalId == 1) {
						   if (periodField) {
							   periodField.setVisible(true); 
						   }

						   var periodId = periodField ? periodField.getValue() : null;

						   // College = programId + batchId + periodId needed
						   var enableSave = (programId && batchId && periodId);
						   saveBtnField.setVisible(true);
						   saveBtnField.setDisabled(!enableSave);
					   }
				   }
			   },
			   /**
				* Load courses filters. Load sections by period
				*/
			   'evaluationresultstudentfilter customcombobox[itemId=periodItemId]': {
    			   select:function(obj,rec){
    				   var $this=this;
    				   var data=rec[0].data.id;
    				   var form=obj.up('form').getForm();
    				   var sectionField=form.findField('sectionId');
					   var studentId=$this.getEvaluationresultstudentfilter().down("#studentItemId");
    				   sectionField.reset();
    				   sectionField.enable();
    				   sectionField.getStore().getProxy().extraParams = {
    					   periodId:data,
    					   studentId:studentId.getValue(),
						   onlyCurrentRecords:false
	   					   };
    				   sectionField.getStore().load({
						   callback : function(records, success){
							   if(success){
								   if(records.length==1){
									   sectionField.setValue(records[0].get('sectionId'));
								   }
							   }
						   }
					   });
    				   /*
    	    		    * Load course by program batch and period
    	    		    */
    	    		   this.loadCoursesByProgramBatchAndPeriod();

    				   form.findField('sectionId').reset();
    				   form.findField('courseId').reset();
    				   form.findField('variantId').reset();
    				   form.findField('variantId').getStore().removeAll();
    				   form.findField('evaluationLevel').reset(); // V2D-401826
    			   }
    		   },
    		   'evaluationresultstudentfilter button[itemId=searchBtn]':{
    			   click:function(obj){
    				   $this=this;
    				   var filterForm =obj.up('form');
    				   var form=obj.up('form').getForm();
    				   var formValues=form.getValues();
					   var admissionId=form.findField('admissionId');
    				   filterForm.down('#searchBtn').setDisabled(true);
    				   var studentGrid=this.getEvaluationresultstudentgrid();
    				   obj.setDisabled(true);
    				   //Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    				      
					   var sectionIdsArray = [];

					   if (!isNullOrEmpty(formValues.sectionId)) {
					       Ext.Array.forEach([].concat(formValues.sectionId), function (val) {
					           if (Ext.isObject(val)) {
					               sectionIdsArray.push(val.data.sectionId);
					           } else {
					               sectionIdsArray.push(val);
					           }
					       });
					   } 
                       //studentGrid.columns[0].setVisible(false);
                       //studentGrid.columns[2].setVisible(false);
                       if(formValues.evaluationLevel==getExaminationTranslation("CNTRL_EVENT")){
                    	   studentGrid.columns[2].setVisible(true);
                       }else if(formValues.evaluationLevel==getExaminationTranslation("CNTRL_COURSE")){	
                    	   studentGrid.columns[0].setVisible(true);
                    	   studentGrid.columns[2].setVisible(false);
                       }
                       var tempCourseIdValue=parseInt(formValues.courseId);
                       var tempCourseVariantIdValue=parseInt(formValues.variantId);
                       var courseIdValue=null;
                       var courseVariantIdValue=null;
                       if(!Number.isNaN(tempCourseIdValue)){
                    	   var courseIdValue=tempCourseIdValue;
                       }
                       if(!Number.isNaN(tempCourseVariantIdValue)){
                    	   var courseVariantIdValue=tempCourseVariantIdValue;
                       }
                       
                       studentGrid.getStore().getProxy().extraParams = {
    					   periodId:formValues.periodId,
    					   courseId:courseIdValue,
						   courseVariantId:courseVariantIdValue,
						   programId:formValues.programId,
						   batchId:formValues.batchId,
						   sectionIds:sectionIdsArray.join(),
						   courseEventEnum:formValues.evaluationLevel,
						   admissionId:admissionId.getValue(),
						   studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
						   locationId:formValues.academyLocationComboExamination
	   					   };
                       $this.resetGridSetting(studentGrid);
                       studentGrid.getStore().load({
	    				callback:function(){
	    					Ext.getBody().unmask();
	    					filterForm.down('#searchBtn').setDisabled(false);
	    				}
	    			});
                       studentGrid.config.searchFilterForm = filterForm;
                   	var taskDelay = new Ext.util.DelayedTask(function(){
			      		//Ext.getBody().unmask();
                   		obj.setDisabled(false);
			      	  });
			      	taskDelay.delay(1000);
			      	
			      	$this.resetPageSetting(studentGrid.getStore(), studentGrid);
//			      	studentGrid.getStore().load();     
			      	studentGrid.getSelectionModel().deselectAll();
			      	studentGrid.getStore().pageSize=100;
    			   }
    		   },
    		   'evaluationresultstudentfilter button[itemId=resetBtn]':{
    			   click:function(obj){
    				   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
    					   var filterForm = obj.up('evaluationresultstudentfilter');
    					   var structure = filterForm.up('evaluationresultstructureforportal');
    					   filterForm.destroy();
    					   structure.insert(0,{xtype:'evaluationresultstudentfilter', cls:'customSearchPanel',plugins : "formlabelrequired"});

					  var evaluationLevel =  this.getEvaluationresultstudentfilter().getForm().findField('evaluationLevel');
    				  var evaluationLevelstore = evaluationLevel.getStore();
							evaluationLevelstore.load({
    					   callback:function(record){
    						   if(record.length >0){
    							   evaluationLevel.setValue(record[0].data.id);
    	                            
    						   }
    					   }
    				   })
    			  
    					   
    				   }else{
    					  // filterForm.findField('admissionId').setDisabled(true);
    					   this.resetByStudent();
    					   /*
    					   var studentIdField = filterForm.findField("studentId");
        				   studentIdField.getStore().getProxy().extraParams = {
        					   admissionId:null,
        					   studentId:null
        					};
        				   studentIdField.getStore().load();
        				   var admissionField = filterForm.findField('admissionId');
        				   admissionField.getStore().getProxy().extraParams = {
        					   studentId:null,
        					   admissionId:null
        					};
        				   admissionField.getStore().load();*/
    				   }
    			   }
    		   },
				'evaluationresultstructureforportal':{
    			   afterrender:function(structure){
					  var evaluationLevel =  structure.down('#evaluationLevelItemId');
    				  var store = evaluationLevel.getStore();
							store.load({
    					   callback:function(record){
    						   if(record.length >0){
    							   evaluationLevel.setValue(record[0].data.id);
    	                            
    						   }
    					   }
    				   })
    			   },
    			   beforerender: function(view){
    				   var grid = view.down('grid');
    				   if(grid && grid.getStore().getRange().length>0){
    					   grid.getStore().removeAll();
					   }
    			   }
    		   },
    		   'evaluationresultstudentfilter customcombobox[itemId=academyLocationComboExamination]':{
    			   select:function(cmp,record){
    				   var me = this,
    				   form = me.getEvaluationresultstudentfilter(),
    				    student = form.down("#studentItemId"),
					    admission = form.down("#admissionItemId"),
					    academyLocationComboExamination = form.down("#academyLocationComboExamination"),
					    programId = form.down("#programItemId"),
					    batchCombo = form.down("#batchItemId"),
					    periodField=form.getForm().findField('periodId'),
					    sectionField=form.getForm().findField('sectionId'),
					    courseField=form.getForm().findField('courseId'),
					     studentPortalInfo = me.getCurrentlyLoggedInUserInfoForPortal(),
 					    studentprogramId = studentPortalInfo.programBatchDetails.programId,
 					    studentbatchId = studentPortalInfo.programBatchDetails.batchId,
 					    studentperiodId = studentPortalInfo.programBatchDetails.periodId;
    				   programId.reset();
    				   batchCombo.reset();
    				   periodField.reset();
    				   sectionField.reset();
    				   courseField.reset();
    				   batchCombo.setDisabled(true);
    				   periodField.setDisabled(true);
    				   sectionField.setDisabled(true);
    				   courseField.setDisabled(true);
    				   var academyLocationIds = new Ext.util.HashMap();
    				   var programIds = new Ext.util.HashMap();

       				Ext.each(studentPortalInfo.pastProgramBatchDetails, function(currentRecord){
       					academyLocationIds.add(parseInt(currentRecord.academyLocationId),currentRecord.academyLocationId);
       					programIds.add(parseInt(currentRecord.programId),currentRecord.programId);
       				});

       				var academyLocationIdsArray = academyLocationIds.getKeys();
       				var programIdsArray = programIds.getKeys();
       				
					   programIdsArray = programIdsArray.filter(function(id) {
						   return id && id !== "NaN";
					   });
       				
    				   programId.getStore().getProxy().extraParams = {
    					   academyLocationIds:cmp.getValue(),
						   programIds:(programIdsArray.length > 0) ? programIdsArray.join() : ""
					   };
					   programId.getStore().load({
						   callback : function(records, success){
							   if(records && records.length){
							   if(success){
								if (portalId!=1){
									form.down("#programItemId").setValue(records[0].data.programId);
								}
								 form.getForm().findField('evaluationLevel').setDisabled(false);
								   form.getForm().findField('variantId').setDisabled(false);
								   form.down("#programItemId").setDisabled(false);
								   form.down("#batchItemId").setDisabled(false);
								   batchCombo.getStore().getProxy().extraParams = { 
									   programId:records[0].data.programId,
									   studentId:me.getCurrentlyLoggedInUserInfoForPortal().student.id,
									   onlyCurrentRecord:false
								   };
								   batchCombo.getStore().load({
									   callback : function(records, success){
										   if(records && records.length){
										   if(success){
											if (portalId!=1){
											   form.down("#batchItemId").setValue(records[0].data.id);
										   		}
											   periodField.setDisabled(false);
											   periodField.getStore().getProxy().extraParams = {
												   id:records[0].data.id,
												   studentId:me.getCurrentlyLoggedInUserInfoForPortal().student.id,
												   onlyCurrentRecords:false
											   };
											   periodField.getStore().load({
												   callback : function(records, success){
													   if(records && records.length){
													   if(success){
														   if(records.length>0){
															if (portalId!=1){
															   periodField.setValue(records[0].data.id);
															   }
															   sectionField.setDisabled(false);
															   sectionField.getStore().getProxy().extraParams = {
																   periodId:studentperiodId,
			    												   studentId:me.getCurrentlyLoggedInUserInfoForPortal().student.id,
			    												   onlyCurrentRecords:false
															   };
															   sectionField.getStore().load({
																   callback : function(records, success){
																	   if(success){
																		   if(records.length==1){
																			   sectionField.setValue(records[0].get('sectionId'));
																		   }
																	   }
																   }
															   });
														   }
														   else{
															   periodField.setValue(studentperiodId);
														   }
														   /*
														    * Load course by program batch and period
														    */
														   me.loadCoursesByProgramBatchAndPeriod();
													   }
													   }
												   }
											   });
										   }
									   }
									   }
								   });
							   
							   }
							   }
						   }
					   });
					   if (this.getCurrentLoggedPortalId() == 1){
					   this.loadFiltersForCoreErp(academyLocationComboExamination,programId,batchCombo,periodField);
					   }
    			   }
    		   }
    	   });
       },
       /**
	    * Load course by program batch and period
	    */
	   loadCoursesByProgramBatchAndPeriod:function(){
	    	  
	    	  var studentFilter=this.getEvaluationresultstudentfilter().getForm();
	    	  var courseField=studentFilter.findField('courseId');
	    	  var evaluationLevel=studentFilter.findField('evaluationLevel');
	    	  var searchBtnField=this.getEvaluationresultstudentfilter().down('#searchBtn');
	    	  
			   	  courseField.enable();
			   	//  evaluationLevel.enable();
			   	  //evaluationLevel.reset();
			   	  courseField.reset();
			   	  courseField.getStore().getProxy().extraParams = {
					programId:studentFilter.findField('programId').getValue(),
					batchId:studentFilter.findField('batchId').getValue(),
					periodId:studentFilter.findField('periodId').getValue(),
//					admissionId:this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id,
					studentId:this.getCurrentlyLoggedInUserInfoForPortal().student.id,
					academyLocationId:this.getCurrentAcademyLocation()
					   };
			   	 // courseField.getStore().load();
	    },
		
		loadFiltersForCoreErp:function(academyLocationComboExamination,programId,batchCombo,periodField){
			    	 
		var studentFilter=this.getEvaluationresultstudentfilter().getForm();
			         				   var studentField=studentFilter.findField('studentId');
			         		        	var admissionField=studentFilter.findField('admissionId');
										

											studentField.getStore().getProxy().extraParams = {
												academyLocationIds: academyLocationComboExamination.getValue() != null
													? academyLocationComboExamination.getValue().toString()
													: null,
												eventId: null
											};
										   studentField.getStore().load();
										   admissionField.getStore().getProxy().extraParams = {
											academyLocationId: academyLocationComboExamination.getValue(),
											isResultScreen:"Yes"
											};
										   admissionField.getStore().load();
										   
										   programId.reset();
										   batchCombo.reset();
										   periodField.reset();

		 },
	     /**
	      * Load courses of PBS by Program,batch,period and section
	      */
       loadCourseByProgramBatchPeriodSection:function(){
    	  var form=this.getEvaluationresultprogramfilter();
    	  var getForm=form.getForm();
    	  var programField=getForm.findField('programId');
    	  var batchField=getForm.findField('batchId');
    	  var periodField=getForm.findField('periodId');
    	  var sectionField=getForm.findField('sectionId');
    	  var courseField=getForm.findField('courseId');
    	  var sectionArray=[];
    	  if(!isNullOrEmpty(programField.getValue())&&!isNullOrEmpty(batchField.getValue())&&!isNullOrEmpty(periodField.getValue())){
    		 if(!isNullOrEmpty(sectionField.getValue())){
    			 for(var i=0;i<sectionField.getValue().length;i++){
       			  if(Ext.isObject(sectionField.getValue()[i])){
           			  sectionArray.push(sectionField.getValue()[i].get('sectionId'));
                     }else{
                   	  sectionArray.push(sectionField.getValue()[i]);
                     }
       		     }
    		 }
    		  courseField.enable();
    		  courseField.reset();
    		  courseField.getStore().getProxy().extraParams = {
    			  programId:programField.getValue(),
    			  batchId:batchField.getValue(),
    			  periodId:periodField.getValue(),
    			  sectionIds:sectionArray.join()
   				   };
    		  courseField.getStore().load({
    			  callback:function(rec,success){
    				  var arr = [];
    				  if(!isNullOrEmpty(rec)){
    					  for(var i=0;i<rec.length;i++){
							//var code=rec[i].data.code;
							 // code = code.replace(/ ?\./g,"");
							 // code = code.replace (/ /g, "");
							//  rec[i].data.code=code;
    						  arr.push(rec[i].data.code);  
    					  }
    					  courseField.setValue(arr)
    				  }
    				  getForm.isValid();
    			  }
    		  });
    	  }
      },
      /**
	    * Load program of student by admissionId and studentId 
	    */
      loadProgramByAdmissionStudent:function(){
    	  var $this=this;
    	  var studentFilter=$this.getEvaluationresultstudentfilter();
    	  var studentFilterForm=studentFilter.getForm();
    	  var programField=studentFilterForm.findField('programId');
    	  var studentField=studentFilterForm.findField('studentId');
    	  var admissionField=studentFilterForm.findField('admissionId');
		  var locationCombo = studentFilterForm.findField('academyLocationComboExamination');
		  var locationValue = locationCombo.getValue();
    	  
    	  if(!isNullOrEmpty(studentField.getValue())||!isNullOrEmpty(admissionField.getValue())){
    		  programField.enable();
    		  var programStore = programField.getStore();
    		  programStore.getProxy().extraParams = {
    			  admissionId:admissionField.getValue(),
    			  studentId:studentField.getValue(),
    			  onlyCurrentRecords:false,
				  academyLocationIds: locationValue ? String(locationValue) : null
    		  },
    		  programStore.load();
    	  }
      },
      
      resetByProgBatchSection:function(obj){
    	  var filterForm=this.getEvaluationresultprogramfilter();
    	  var filterForm=filterForm.getForm();
    	  filterForm.findField('batchId').setDisabled(true);
    	  filterForm.findField('periodId').setDisabled(true);
    	  filterForm.findField('sectionId').setDisabled(true);
    	  filterForm.findField('courseId').setDisabled(true);
    	  filterForm.reset();
      },
      
      resetByCourse:function(obj){
    	  var filterForm=this.getEvaluationresultcoursefilter();
    	    var filterForms=this.getEvaluationresultstructure();
    	   var pbsRadio = filterForms.down('[name=evaluationResult]');
    	  var filterForm=filterForm.getForm();
          filterForm.findField('variantId').setDisabled(true);
          filterForm.findField('programId').setDisabled(true);
          filterForm.findField('batchId').setDisabled(true);
          filterForm.findField('periodId').setDisabled(true);
          filterForm.findField('sectionId').setDisabled(true);
          filterForm.reset();
          pbsRadio.setValue(true)
      },
      
      resetByStudent:function(obj){
    	  var filterForm=this.getEvaluationresultstudentfilter();
    	  var filterForm=filterForm.getForm();
    	   var filterForms=this.getEvaluationresultstructure();
    	   var courseRadio = filterForms.down('[name=evaluationResult]');
    	   filterForm.findField('programId').setDisabled(true);
		   filterForm.findField('batchId').setDisabled(true);
		   filterForm.findField('periodId').setDisabled(true);
		   filterForm.findField('sectionId').setDisabled(true);
		   filterForm.findField('variantId').setDisabled(true);
		   filterForm.findField('variantId').getStore().removeAll();
		   filterForm.findField('courseId').setDisabled(true);
		   filterForm.findField('evaluationLevel').setDisabled(true);
		   filterForm.reset();
		    courseRadio.setValue(true);
      }
      
});
