/**
 * @author Raghavendra.Soni
 * 
 */
var currentEditRecord = null;
Ext.define('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController', {
	extend : 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	models : ['genericmodels.dropdowns.EnumCombo','examinationcenters.StudentAssessmentReportGridModel'],
	requires:['Ext.ux.LinkedTagField' ],
	stores : [ 
	    'feeandpayment.finance.FinanceALProgramList',
		'committee.committee.CommitteeALMappingComboStore',
		'feeandpayment.ALProgramList',
		'common.CurrentBatchStore',
		'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'examinationcenters.studentResultReport.StudentResultReportGridStore',
		'common.CurrentBatchStoreByStudentID','common.CurrentPeriodStoreByStudentID',
		'examinationcenters.evaluation.coverageDetails.StudentMarkObtainedDataStore',
		'examinationcenters.reports.StudentAssessmentReportGridStore',
		'examinationcenters.reports.StudentAsseessmentReportStudentListStore','examinationcenters.reports.ExaminationReportProgramStore',
		'examinationcenters.reports.ExaminationReportBatchStore','examinationcenters.reports.ExaminationReportPeriodStore',
		'examinationcenters.reports.BatchSectionStore','examinationcenters.marksheet.StudentAssessmentEvaluationLevelType',
		'examinationcenters.assessmentEvent.StudentAssessmentLevelListStore','examinationcenters.reports.ExaminationReportCourseStore',
		'facilitiesresources.resourcebooking.CourseVariantsListStore',
		'messaging.StaticDocumentAttachmentGridStore','messaging.MessagingTemplatesStore',
		'committee.committee.MessageTypeNotificationStore',
		'examinationcenters.reports.ExaminationReportCourseUpdatedStore',   
		'examinationcenters.reports.StudentAsseessmentReportStudentListStore','setup.templatemapping.TemplateNameListFacultyByCode',
		'feeandpayment.finance.FinanceALProgramList'
		
	],
	views : [
		'student.studentResultReport.StudentResultReportStructure',
		'student.studentResultReport.StudentResultReportFilter',
		'student.studentResultReport.StudentResultReportGrid',
		'student.studentResultReport.MarksObtainedDetailWin',
		'examinationcenters.reports.StudentAssessmentReportStructure',
		'examinationcenters.reports.StudentAssessmentReportFilter',
		'examinationcenters.reports.StudentAssessmentReportGrid',
		'examinationcenters.reports.StudentAssessmentReportWin',
		'examinationcenters.reports.StudentAssessmentSendMessagesForm',
		'examinationcenters.reports.StudentAssessmentERPCommentWin',
		'examinationcenters.reports.StudentAssementReportTypeWin',
		'examinationcenters.reports.StudentAssessmentStaticDocumentAttachmentGrid'
	],
	config:{
		STUDENT_PORTAL_EXAM_STUDENT_RESULT_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAM_STUDENT_RESULT_REPORT_PRIVILEGES'),
		PARENT_PORTAL_EXAM_STUDENT_RESULT_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAM_STUDENT_RESULT_REPORT_PRIVILEGES'),
		FACULTY_STUDENT_ASSESSMENT_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_STUDENT_ASSESSMENT_REPORT_PRIVILEGES'),
  	    EXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES')
	},           
	refs : [
		{
    	   ref: 'contentPanel',
    	   selector: 'contentpanel'
       },{
    	   ref:'studentresultreportstructure',
    	   selector:'studentresultreportstructure'
       },{
    	   ref: 'studentresultreportfilter',
    	   selector: 'studentresultreportfilter'
       },{
    	   ref: 'studentresultreportgrid',
    	   selector: 'studentresultreportgrid'
       },{
    	   ref: 'marksobtaineddetailwin',
    	   selector: 'marksobtaineddetailwin'
       },{
    	   ref:'studentassessmentreportfilter',
    	   selector: 'studentassessmentreportfilter'
       },{
    	   ref:'studentassessmentreportgrid',
    	   selector: 'studentassessmentreportgrid'
       },{
    	   ref:'studentassessmentreportwin',
    	   selector: 'studentassessmentreportwin'
       },{
    	   ref:'studentassessmentsendmessagesform',
    	   selector: 'studentassessmentsendmessagesform'
       },{
    	   ref:'studentassessmentstaticdocumentattachmentgrid',
    	   selector: 'studentassessmentstaticdocumentattachmentgrid'
       },{
    	   ref:'studentassessmenterpcommentwin',
    	   selector: 'studentassessmenterpcommentwin'
       },
       {
    	   ref:'studentassementreporttypewin',
    	   selector: 'studentassementreporttypewin'
       }
       
    ],
    init : function() {
    	this.control({
    		'studentresultreportfilter':{
    			render : function(form){
					var $this = this;
					var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					var studentprogramId = studentPortalInfo.programBatchDetails.programId;
					var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
					var studentPeriodId = studentPortalInfo.programBatchDetails.periodId;
					var admissionId=studentPortalInfo.admissionDetails[0].id;
					var academyLocationCombo = form.down('#academyLocationCombo');
					var programId = form.down("#programId");
					var batchCombo = form.down("#batchId");
					var academyLocationIds = new Ext.util.HashMap();
					var programIds = new Ext.util.HashMap();
					var periodIds = new Ext.util.HashMap();
					var currentProgram=new Ext.util.HashMap();
					var currentAL=new Ext.util.HashMap();
	 				var studentId=studentPortalInfo.student.id;
					Ext.each(studentPortalInfo.pastProgramBatchDetails, function(currentRecord){
						academyLocationIds.add(parseInt(currentRecord.academyLocationId),currentRecord.academyLocationId);
						programIds.add(parseInt(currentRecord.programId),currentRecord.programId);
						if(currentRecord.isCurrentPeriod && currentRecord.isCurrentSection 
								&& isNullOrEmpty(currentRecord.exitDate)){
							currentProgram.add(parseInt(currentRecord.programId),currentRecord.programId);
							currentAL.add(parseInt(currentRecord.academyLocationId),currentRecord.academyLocationId);
						}
           	    	});
					
					
					var studentresultreportgrid = $this.getStudentresultreportgrid();
	    			studentresultreportgrid.getStore().getProxy().extraParams={
	    				admissionId:admissionId
	    			};
	    			
					
     				var academyLocationIdsArray = academyLocationIds.getKeys();
     				var programIdsArray = programIds.getKeys();
     				var periodIdsArray = periodIds.getKeys();
     				var currentProgramArray = currentProgram.getKeys();
     				var currentAL = currentAL.getKeys();
     				
					if(academyLocationIdsArray.length==1){
						academyLocationCombo.hide();
					}
					else{
						academyLocationCombo.show();
					}
					
					academyLocationCombo.getStore().getProxy().extraParams = {
						academyLocationIds:academyLocationIdsArray.join()
					};
					academyLocationCombo.getStore().load({
						callback : function(records, success){
							academyLocationCombo.setValue(parseInt(currentAL.join()));
						}
					});

					programId.setDisabled(false);
					programId.getStore().removeAll();
					programId.getStore().clearData();
					programId.getStore().getProxy().extraParams = {
						academyLocationIds: currentAL.join(),
						programIds:programIdsArray.join()
					};
					/*programId.getStore().load({
						callback : function(records, success){
							if(success && !isNullOrEmpty(records)){
								form.down("#programId").setValue(parseInt(currentProgramArray.join()));
								if(records.length==1){
									form.down("#programId").setReadOnly(true);
								}
								else{
									form.down("#programId").setReadOnly(false);
								}
								batchCombo.getStore().getProxy().extraParams = { 
									programId:currentProgramArray.join(),
									studentId:studentId
								};
								form.down("#batchId").setDisabled(false);
								batchCombo.getStore().load({
									callback : function(records, success){
										if(success && !isNullOrEmpty(records)){
											form.down("#batchId").setValue(studentbatchId);
											if(records.length==1){
												form.down("#batchId").setReadOnly(true);
											}
											else{
												form.down("#batchId").setReadOnly(false);
											}
											
											var alinfomodel = Academia.model.authentication.ALInfoModel;
											var whetherSchool = alinfomodel.get('wheatherSchool');

											var periodField=form.getForm().findField('period');
											periodField.setDisabled(false);
											periodField.getStore().getProxy().extraParams = {
												batchId:studentbatchId,
												studentId:studentId
											};
											periodField.getStore().load({
												callback : function(records, success){
													if(success && !isNullOrEmpty(records)){
														form.down("#periodId").setValue(studentPeriodId);
														if(records.length==1){
															form.down("#periodId").setReadOnly(true);
														}
														else{
															form.down("#periodId").setReadOnly(false);
														}
														if(whetherSchool) {
															form.down("#periodId").setVisible(false);
														} else {
															form.down("#periodId").setVisible(true);
														}
													}
												}
											});
										}
									}
								});
							}
						}
					});*/
    			}
    		},
    		'studentresultreportfilter button[itemId=resetBtn]':{
    			click: function(button){
    				button.up('studentresultreportfilter').getForm().reset();
    				
    				var studentresultreportfilter =button.up('studentresultreportfilter');
    				var studentresultreportstructure = button.up('studentresultreportstructure');
    				studentresultreportfilter.destroy();
    				studentresultreportstructure.insert(0,{xtype:'studentresultreportfilter'});
    			}
    		},
    		'studentresultreportfilter button[itemId=searchBtn]':{
    			click:function(obj){
    				obj.setDisabled(true);
    				var $this=this;
    				var form=this.getStudentresultreportfilter().getForm();
    				var formValues=form.getValues();
    				$this.getStudentresultreportfilter().down('#searchBtn').setDisabled(true);
    				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    				var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	    			var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	    			var admissionId=studentPortalInfo.admissionDetails[0].id;
	    			var studentId=studentPortalInfo.student.id;
	    			
	    			var programId=null;
	    			if (!isNullOrEmpty(formValues.program)) {
	    				programId=formValues.program;
	    			}else{
	    				programId=studentprogramId;
	    			}
	    			
	    			var batchId=null;
	    			if (!isNullOrEmpty(formValues.batch)) {
	    				batchId=formValues.batch;
	    			}else{
	    				batchId=studentbatchId;
	    			}
	    			
	    			var periodId = null;
	    			if (!isNullOrEmpty(formValues.period)) {
	    				periodId=formValues.period;
	    			}

	    			var studentresultreportgrid = $this.getStudentresultreportgrid();
	    			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    			studentresultreportgrid.getStore().getProxy().extraParams={
	    				admissionId:admissionId,
	    				programId:programId,
	    				batchId: batchId,
	    				periodId:periodId,
	    				studentId:studentId
	    			};
	    			
	    			studentresultreportgrid.getStore().load({
	    				callback:function(){
	    					obj.setDisabled(false);
	    					Ext.getBody().unmask();
	    					$this.getStudentresultreportfilter().down('#searchBtn').setDisabled(false);
	    				}
	    			});
    			}
    		},
    		'studentresultreportfilter combo[itemId=academyLocationCombo]':{
    			change:function(combo,records) {
    				var reportForm = this.getStudentresultreportfilter();
    				var alCombo = reportForm.down("#academyLocationCombo");	
    				var programCombo = reportForm.down("#programId");
    				var batchCombo = reportForm.down("#batchId");	
    				var periodCombo = reportForm.down("#periodId");

    				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    				var studentprogramId = studentPortalInfo.programBatchDetails.programId;
    				var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
    				var admissionId=studentPortalInfo.admissionDetails[0].id;
    				var studentId=studentPortalInfo.student.id;

    				var academyLocationIds = new Ext.util.HashMap();
    				var programIds = new Ext.util.HashMap();

    				Ext.each(studentPortalInfo.pastProgramBatchDetails, function(currentRecord){
    					academyLocationIds.add(parseInt(currentRecord.academyLocationId),currentRecord.academyLocationId);
    					programIds.add(parseInt(currentRecord.programId),currentRecord.programId);
    				});

    				var academyLocationIdsArray = academyLocationIds.getKeys();
    				var programIdsArray = programIds.getKeys();

    				programCombo.reset();
    				batchCombo.reset();
    				periodCombo.reset();

    				programCombo.setDisabled(false);
    				programCombo.getStore().getProxy().extraParams = {
    					academyLocationIds: alCombo.getValue(),
    					programIds:programIdsArray.join()
    				};
    				var programStore =programCombo.getStore();
    				if(records) {
    					programCombo.getStore().load({
    						callback : function(records, success){
    							if(success){
    								if((programStore.find('programId',studentprogramId))>=0){
    									programCombo.setValue(studentprogramId);
    									programCombo.fireEvent('select', programCombo);
    								}
    								else if(records.length>=1){
    									programCombo.setValue(records[0].get('programId'));
    									batchCombo.getStore().getProxy().extraParams = { 
    										programId:records[0].get('programId'),
    										studentId:studentId
    									};
    									batchCombo.setDisabled(false);
    									var batchStore =batchCombo.getStore() ;
    									batchCombo.getStore().load({
    										callback : function(records, success){
    											if(success){
    												if((batchStore.find('id',studentbatchId))>=0){
    													batchCombo.setValue(studentbatchId);
    													batchCombo.fireEvent('select', batchCombo);
    												}
    												else if(records.length==1){
    													batchCombo.setValue(records[0].get('id'));
    													batchCombo.fireEvent('select', batchCombo);  
    												}

    												if(records.length==1){
    													batchCombo.setReadOnly(true);
    												}
    												else{
    													batchCombo.setReadOnly(false);
    												}
    											}
    										}
    									});
    								}

    								if(records.length==1){
    									programCombo.setReadOnly(true);
    								}
    								else{
    									programCombo.setReadOnly(false);
    								}
    							}
    						}
    					});
    				}
    			}
    		},
    		'studentresultreportfilter combo[itemId=programId]':{
    			select:function(combo,records) {
    				var reportForm = this.getStudentresultreportfilter();
    				var batchCombo = reportForm.down("#batchId");	
    				var periodName = reportForm.down("#periodId");
    				
    				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	    			var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	    			var studentId=studentPortalInfo.student.id;
    				batchCombo.reset();
    				periodName.reset();

    				batchCombo.getStore().getProxy().extraParams = { 
						programId:combo.getValue(),
						studentId:studentId
					};
    				batchCombo.setDisabled(false);
    				var batchStore =batchCombo.getStore() ;
    				batchCombo.getStore().load({
						callback : function(records, success){
							if(success){
								if((batchStore.find('id',studentbatchId))>=0){
									batchCombo.setValue(studentbatchId);
									periodName.getStore().getProxy().extraParams = {
	    					             batchId:records[0].get('id'),
	    					             studentId:studentId
	    				                };

	    				                /*periodName.getStore().load({
	    				                	callback:function(rec){
	    				                		if(rec.length ==1){
	    				                			periodName.setValue(rec[0].data.id);
	    				                		}else{*/
													batchCombo.fireEvent('select', batchCombo);//V2D-434102  
												/*}
	    				                	}
	    				                });*/
								}
								else if(records.length==1){
									batchCombo.setValue(records[0].get('id'));
									batchCombo.setReadOnly(true);
									periodName.getStore().getProxy().extraParams = {
	    					             batchId:records[0].get('id'),
	    					             studentId:studentId
	    				                };

	    				                periodName.getStore().load({
	    				                	callback:function(rec){
	    				                		if(rec.length ==1){
	    				                			periodName.setValue(rec[0].data.id);
	    				                		}
	    				                	}
	    				                });
								}
								
								else{
									batchCombo.setReadOnly(false);
								}
							}
						}
    				});
    			}
    		},
    		'studentresultreportfilter combo[itemId=batchId]':{
    			select:function(combo,records) {
    				var reportForm = this.getStudentresultreportfilter();
    				var batchName = reportForm.down("#batchId");	
    				var periodField = reportForm.down("#periodId");
    				
    				periodField.reset();

    				var alinfomodel = Academia.model.authentication.ALInfoModel;
    				var whetherSchool = alinfomodel.get('wheatherSchool');
    				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    				var studentPeriodId = studentPortalInfo.programBatchDetails.periodId;
    				var studentId=studentPortalInfo.student.id;
    				
    				
    				periodField.setDisabled(false);
    				periodField.getStore().getProxy().extraParams = {
    					batchId:batchName.getValue(),
    					studentId:studentId
    				};
    				periodField.getStore().removeAll();
    				var periodStore= periodField.getStore();
    				if(!isNullOrEmpty(batchName.getValue())){
    					periodField.getStore().load({
        					callback : function(records, success){
        						if(success){
        							
        							if((periodStore.find('id',studentPeriodId))>=0){
        								periodField.setValue(studentPeriodId);
    								}
    								else if(records.length==1){
    									periodField.setValue(records[0].data.id);
    								}
        							
        							
        							if(records.length==1){
        								periodField.setReadOnly(true);
    								}
    								else{
    									periodField.setReadOnly(false);
    								}
        							
        							/*if(records.length==1){
        								periodField.setReadOnly(true);
        							}
        							else{
        								Ext.each(records, function(currentPeriodRecord){
        									if(currentPeriodRecord.data.isCurrentPeriodOfProgram==true){
        										periodField.setValue(currentPeriodRecord.data.id);
        									}
        								});
        								try{
            								periodField.setReadOnly(false);
        								}
        								catch(e){
        									
        								}
        							}*/
        							if(whetherSchool) {
        								periodField.setVisible(false);
        							} else {
        								periodField.setVisible(true);
        							}
        						}
        					}
        				});
    				}
    			}
    		},
    		'studentresultreportgrid':{
    			beforedestroy: function(tree, eOpts){
    				tree.getStore().getRootNode().removeAll();
    			},
 				beforerender: function(grid) {
 	 				//var grid =	this.getSpstudentassessmentreportgrid();
 	 					Ext.Ajax.request({
 	 						type: 'rest',
 	 						url: SERVERURL.PATH_STUDENT_RESULT_REPORT_FIND_VISIBLITY,
// 	 						params: {
// 	 							academyLocatonId: academyLocationId
// 	 						},
 	 						method: 'GET',
 	 						success: function(response, action) {
 	 							var data = Ext.decode(response.responseText);
 	 							if (!isEmpty(data)) {
 	 								var gridStore = grid.getStore();
 	 								var gridCols = [{
 	 							        xtype: 'treecolumn',
 	 							        text: getCommonTranslation('COURSE_CODE_NAME'),
 	 							        flex: .33,
 	 							        dataIndex: 'treeNode'
 	 							    }];
 	 								for (var i = 0; i < data.length; i++) {
 	 									switch (data[i].programShortName) {
 	 									case "Max Marks/Grade":
 	 										if(data[i].requireacademicStanding == true){
 	 											gridCols.push({
 	 	 											header:  getExaminationTranslation('MAX_MARKS_GRADE'),
 	 	 											dataIndex: 'maxMarksOrGrade',
 	 	 											flex:.1
 	 	 										});
 	 										}
 	 									
 	 										break;
 	 									case "Obtained Marks/ Grades":
 	 										if(data[i].requireacademicStanding == true){
 	 										gridCols.push({
 	 											header:  getCommonTranslation('OBTAINED_MARKS_GRADES'),
 	 											dataIndex: 'obtainedMarksGrade',
 	 											flex:.1
 	 										 });
 	 										}
 	 										break;
 	 									case "Weightage":
 	 										if(data[i].requireacademicStanding == true){
 	 										gridCols.push({
 	 											header:  getCommonTranslation('WEIGHTAGE'),
 	 											dataIndex: 'weightage',
 	 											flex:.1
 	 										 });
 	 										}
 	 										break;
 	 									case "Effective Marks/ Grades":
 	 										if(data[i].requireacademicStanding == true){
 	 										gridCols.push({
 	 											header:  getCommonTranslation('EFFECTIVE_MARKS_GRADES'),
 	 											dataIndex: 'effetiveMarksGrade',
 	 											flex:.1
 	 										 });
 	 										}
 	 										break;
 	 									case "Moderation Marks":
 	 										if(data[i].requireacademicStanding == true){
 	 										gridCols.push({
 	 											header: getCommonTranslation('MODERATION_MARKS_GRADES'),
 	 											dataIndex: 'moderationMarksGrade',
 	 											flex:.1
 	 										 });
 	 										}
 	 										break;
									   case "Remark":
 	 										if(data[i].requireacademicStanding == true){
 	 										gridCols.push({
 	 											header: getCommonTranslation('REMARK'), 
												tooltip: getCommonTranslation('REMARK'),
 	 											dataIndex: 'typeRemark',  
 	 											flex:.1,
												renderer: function(value) {
									            if (value.length > 20) {   
									                return Ext.String.format('<div data-qtip="{0}">{1}</div>', value, value.substring(0, 20) + '...' );
									            } else {
									                return value;    
									            }
									        }
												
 	 										 });
 	 										}
 	 										break;
 	 									}
 	 								}
 	 								grid.reconfigure(gridStore, gridCols);
 	 							}
 	 						}
 	 					});
 	            	},
    			
    			cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
  				  var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
  				  /*if(columnName == "TOTAL_COURSES") {
                  		 console.log(columnName);
                  	 }*/
  				  if ((columnName == 'obtainedMarksGrade' || columnName == 'effetiveMarksGrade') && record.raw.leaf
  						 && record.raw.whetherQPPublish) {
  					  this.markObtainedDetailsWindow(columnName, record);
  				  }
  			  },
    		},
    		
    		'marksobtaineddetailwin button#cancelBtn':{
   			   click : function(btn){
   				   btn.up('window').close();
   			   },
   		},
   		
   		'studentassessmentreportfilter' : {
			   render:function(obj){
				   var $this=this;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				  // var program = form.findField("programId");
				   var studentId = form.findField("studentId").getStore();
				   var portalId = $this.getCurrentLoggedPortalId();
				   var programId=form.findField("programId");
				   var facultyId = $this.getCurrentlyLoggedInUser();
				   var evaluationLevelItemId=form.findField("evaluationLevel")
				   var evaluationLevel = form.findField("evalLevelName");
				   evaluationLevel.reset();
				   if(portalId==2){
					var program = programId.getStore();
					//var submitURL=SERVERURL.FIND_ALL_ACTIVE_PROGRAM_BY_ASSIGNED_FACULTYID;
					//program.getProxy().api.read=submitURL;
					  
					   program.getProxy().extraParams={
						   academyLocationIds:$this.getCurrentAcademyLocation(),
						   whetherMarksheet:true,
						   //whetherSchool:true,
						   facultyId: facultyId.id,
					   };
					   program.load();
					   studentId.getProxy().extraParams = {
						   academyLocationIds:$this.getCurrentAcademyLocation(),
						   whetherMarksheet:true,
						   facultyId: facultyId.id,
					   }
					   studentId.load();
				   }else{
					   var program = programId.getStore();
					   program.getProxy().extraParams={
						   academyLocationIds:$this.getCurrentAcademyLocation(),
						   whetherMarksheet:true
					   };
					   program.load();
					   studentId.getProxy().extraParams = {
						   academyLocationIds:$this.getCurrentAcademyLocation(),
						   whetherMarksheet:true
					   }
					   studentId.load();
				   }
				   
				   /*evaluationLevelItemId.setDisabled(false);
				   evaluationLevelItemId.getStore().getProxy().extraParams={
				   };
				   evaluationLevelItemId.getStore().load({
					   callback:function(){
						   evaluationLevelItemId.setValue("EVALUATION_TYPE");
					   }
				   });*/
				   
				  // evaluationLevel.setDisabled(false);
				   /*evaluationLevel.getStore().getProxy().extraParams={
					   evaluationLevel:"EVALUATION_TYPE"
				   };
				   evaluationLevel.getStore().load();*/
				   
				   var alinfomodel = Academia.model.authentication.ALInfoModel;
				   var whetherSchool = alinfomodel.get('wheatherSchool');
				   if(whetherSchool) {
					   form.findField("periodId").setVisible(false);
				   } else {
					   form.findField("periodId").setVisible(true);
				   }
				   
			   }
		   },
		   
		   
		   'studentassessmentreportfilter customcombobox[itemId=studentItemId]' : {
			   select:function(obj, rec){
				   var $this=this;
				   var admId=rec[0].data.id;
				   var studentId=rec[0].data.code;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				   var programId = form.findField("programId");
				   var courseId=form.findField("courseId");
				   var sectionId = form.findField("sectionId");
				   var periodId= form.findField("periodId");
				   var portalId = $this.getCurrentLoggedPortalId();
				   var evaluationLevelType = form.findField("evaluationLevel").getValue();
				   var evaluationLevel = form.findField("evalLevelName");
				   var evaluationLevelTypee = form.findField("evaluationLevel");
				   var facultyId=null;
				   var  academyLocationIds=null;
				   var program=null;
				   whetherSchool=null;
				   if(portalId==2){
					   var program = programId.getStore();
						//var submitURL=SERVERURL.FIND_ALL_ACTIVE_PROGRAM_BY_ASSIGNED_FACULTYID;
						//program.getProxy().api.read=submitURL;
					   academyLocationIds=$this.getCurrentAcademyLocation();
				   	   facultyId=$this.getCurrentlyLoggedInUser().id;
					   whetherSchool=true;
				   }else{
					   academyLocationIds = $this.getCurrentAcademyLocation();
					   var program = programId.getStore();
				   }
				   
				   form.findField("courseVariant").reset();
				   form.findField("programId").reset();
				   program.getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   admissionId:admId,
					   whetherMarksheet:true,
					   whetherSchool:whetherSchool,
					   facultyId:facultyId,
					   //studentId:studentId
				   };
				   program.load({
					   callback: function(records, operation, success) {
						   if (success) {
							   form.findField("programId").setValue(records[0].data.id);
							   //evaluationLevel.reset();
         				   evaluationLevel.setDisabled(false);
         				   evaluationLevel.reset();
         				   evaluationLevel.getStore().getProxy().extraParams={
         					   programId:records[0].data.id,
         					   evaluationLevel:evaluationLevelType
         				   };
         				   /*evaluationLevel.getStore().load();
         				   evaluationLevel.setDisabled(false);*/
							   
         				   
							   form.findField("batchId").reset();
							   var batchId = form.findField("batchId").getStore();
							   batchId.getProxy().extraParams={
								   academyLocationIds:academyLocationIds,
								   admissionId:admId,
								   programId:form.findField("programId").getValue(),
								   whetherMarksheet:true,
								   //facultyId:facultyId
							   };
							   batchId.load({
								   callback: function(record, operation, success) {
									   if (success) {
										   form.findField("batchId").setValue(record[0].data.id);
										   
										   evaluationLevel.getStore().getProxy().extraParams={
		                					   programId:form.findField("programId").getValue(),
		                					   batchId:form.findField("batchId").getValue(),
		                					   evaluationLevel:evaluationLevelType
		                				   };
		                				   evaluationLevel.getStore().load();
		                				   evaluationLevel.setDisabled(false);
										   var period = form.findField("periodId");
										   var periodId = form.findField("periodId").getStore();
										   periodId.getProxy().extraParams={

											   academyLocationIds:academyLocationIds,
											   admissionId:admId,
											   programId:records[0].data.id,
											   id:record[0].data.id,
											   whetherMarksheet:true,
											   //facultyId:facultyId
										   };
										   periodId.load({
											   callback: function(record, operation, success) {
												   if (success) {
													   form.findField("periodId").setDisabled(false);
													   if(record.length == 1){
														   //form.findField("periodId").setVisible(false);
														   form.findField("periodId").setValue(record[0].data.id);
														   sectionId.reset();
						                				   sectionId.setDisabled(false);
						                				   
						                				   sectionId.getStore().getProxy().extraParams={
						                					   academyLocationIds:academyLocationIds,
						                					   admissionId:admId,
						                					   programId:form.findField("programId").getValue(),
						                					   batchId:form.findField("batchId").getValue(),
						                					   periodId:record[0].data.id,
						                					   whetherMarksheet:true,
						                					   facultyId:facultyId
						                				   };
						                				   sectionId.getStore().load();
						                				   
						                				   
						                				   evaluationLevelTypee.setDisabled(false);
						                				   evaluationLevelTypee.getStore().getProxy().extraParams={
						                				   };
						                				   evaluationLevelTypee.getStore().load({
							            					   callback:function(){
							            						   evaluationLevelTypee.setValue("EVALUATION_TYPE");
							            					   }
							            				   });
						                				   evaluationLevelTypee.getStore().load();
						                				   evaluationLevel.reset();
						                				   
                                                 var valueCheck='';						                				                                            
                                                
                                                    var url = SERVERURL.PATH_GET_AUTO_SELECT_ALL_LEVEL_VALUE;
                                                        Ext.Ajax.request({
                                                        type : 'rest',
                                                        url : url,                                                      
                                                        method : 'GET',
                                                        success : function(response) {
                                                               var jsonResponse = Ext.JSON.decode(response.responseText); 
                                                               valueCheck = jsonResponse[0] ? jsonResponse[0].value : "";
                                                            evaluationLevel.getStore().getProxy().extraParams={
						                					   programId:form.findField("programId").getValue(),
						                					   batchId:form.findField("batchId").getValue(),
						                					   periodId:record[0].data.id,
						                					   evaluationLevel:"EVALUATION_TYPE",
						                					   isGroupBy:true,
						                					   isOtherEval:false
						                				   };
						                				   
						                				   evaluationLevel.getStore().load({
                                                                        callback:function(records){
                                                                            var levelIds=[];
                                                                            var localVar = "Yes";
                                                                            for (var i = 0; i < records.length; i++) {
                                                                                   if(valueCheck.toLowerCase() === localVar.toLowerCase()){
                                                                                        levelIds.push(records[i].data.id);
                                                                                    }
                                                                                
                                                                            }
                                                                            
                                                                            evaluationLevel.setValue(levelIds);                                                                           
                                                                         }
                                                                     });
						                				   
						                				   
						                				  // evaluationLevel.getStore().load();
						                				   evaluationLevel.setDisabled(false);
                                                        }
                                                    });  
						                				   
						                				  
						                				   /*evaluationLevel.getStore().getProxy().extraParams={
						                					   programId:form.findField("programId").getValue(),
						                					   batchId:form.findField("batchId").getValue(),
						                					   periodId:record[0].data.id,
						                					   evaluationLevel:evaluationLevelType,
						                					   isGroupBy:true,
						                					   isOtherEval:false
						                				   };
						                				   evaluationLevel.getStore().load();
						                				   evaluationLevel.setDisabled(false);*/
						                				   
													   }else{
														   period.reset();
														   period.setVisible(true);
														   var curPeriod = periodId.findRecord('isCurrentPeriodOfProgram', true);
														   if(curPeriod) {
															   period.setValue(curPeriod.get('id'));
														   }
														   sectionId.reset();
						                				   sectionId.setDisabled(false);
						                				   
						                				   evaluationLevelTypee.setDisabled(false);
						                				   evaluationLevelTypee.getStore().getProxy().extraParams={
						                				   };
						                				   evaluationLevelTypee.getStore().load({
							            					   callback:function(){
							            						   evaluationLevelTypee.setValue("EVALUATION_TYPE");
							            					   }
							            				   });
						                				   evaluationLevelTypee.getStore().load();
						                				   evaluationLevel.reset();
						                				   evaluationLevel.getStore().getProxy().extraParams={
						                					   programId:programId.getValue(),
						                					   batchId:form.findField("batchId").getValue(),
						                					   periodId:period.getValue(),
						                					   evaluationLevel:"EVALUATION_TYPE",
						                					   isGroupBy:true,
						                					   isOtherEval:false
						                				   };
						                				   evaluationLevel.getStore().load();
						                				   evaluationLevel.setDisabled(false);
													   }
													   courseId.setDisabled(false);
													   courseId.reset();
													   courseId.getStore().getProxy().extraParams={
					                					   academyLocationIds:academyLocationIds,
					                					   admissionId:admId,
					                					   whetherMarksheet:true,
					                					   programId:form.findField("programId").getValue(),
					                					   batchId:form.findField("batchId").getValue(),
					                					   periodId:form.findField("periodId").getValue(),
					                					   facultyId:facultyId
					                				   };
					                				   courseId.getStore().load();
												   }
											   }
         							   });
									   }
								   }
							   });
						   }
					   }	   
				   });
				   form.findField("batchId").setDisabled(false);
				   form.findField("periodId").reset();
				   form.findField("periodId").setDisabled(false);
				   form.findField("courseVariant").setDisabled(true);
				   form.findField("courseVariant").reset();
			   }
		   },
		   
		   'studentassessmentreportfilter customcombobox[itemId=programItemId]' : {
			   select:function(obj, rec){
				   var $this=this;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				   var studentId=form.findField("studentId");
				   var programId=rec[0].data.id;
				   var batchId = form.findField("batchId");
				   var periodId=form.findField("periodId");
				   var sectionId = form.findField("sectionId");
				   var evaluationLevelType = form.findField("evaluationLevel");
				   var evaluationLevel = form.findField("evalLevelName");
				   evaluationLevel.reset();
				   var courseId=form.findField("courseId");
				   
				   batchId.reset();
				   periodId.reset();
				   periodId.disable();
				   sectionId.reset();
				   
				   
				   batchId.setDisabled(false);
				   sectionId.setDisabled(true);
				   evaluationLevel.setDisabled(true);
				   
				   var portalId = $this.getCurrentLoggedPortalId();
				   var facultyId=null;
				   var academyLocationIds=null;
				   if(portalId==2){
					   academyLocationIds=$this.getCurrentAcademyLocation();
				   	   facultyId=$this.getCurrentlyLoggedInUser().id;
				   }else{
					   academyLocationIds = $this.getCurrentAcademyLocation();
				   }
				   
				   batchId.getStore().getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   admissionId:studentId.getValue(),
					   programId:programId,
					   //facultyId:facultyId
					   whetherMarksheet:true
				   };
				   
				   batchId.getStore().load({
					   callback: function(record, operation, success) {
						   if (success) {
							   if(record.length==1) {
								   batchId.setValue(record[0].data.id);
								   periodId.enable();
                				   evaluationLevel.setDisabled(false);
                				   form.isValid();
								   periodId.getStore().getProxy().extraParams={
									   academyLocationIds:academyLocationIds,
									   admissionId:studentId.getValue(),
									   programId:programId,
									   batchId:batchId.getValue(),
									   whetherMarksheet:true,
									   //facultyId:facultyId
								   };
								   periodId.getStore().load({
									   callback: function(record, operation, success) {
										   if (success) {
											   if(record.length == 1){
												   periodId.setDisabled(false);
												   periodId.setValue(record[0].data.id);
				                				   sectionId.setDisabled(false);
				                				   sectionId.getStore().getProxy().extraParams={
				                					   academyLocationIds:academyLocationIds,
				                					   admissionId:studentId.getValue(),
				                					   programId:programId,
				                					   batchId:batchId.getValue(),
				                					   periodId:record[0].data.id,
				                					   whetherMarksheet:true,
				                					   facultyId:facultyId
				                				   };
				                				   sectionId.getStore().load();
				                				   
				                				   evaluationLevelType.setDisabled(false);
				                				   evaluationLevelType.getStore().load({
													   callback: function() {

														   var valueCheck="";

														   var url = SERVERURL.PATH_GET_AUTO_SELECT_ALL_LEVEL_VALUE;
														   Ext.Ajax.request({
															   type: 'rest',
															   url: url,
															   method: 'GET',
															   success: function(response) {
																   var jsonResponse = Ext.JSON.decode(response.responseText);
																if (Array.isArray(jsonResponse) && jsonResponse.length > 0 && jsonResponse[0].hasOwnProperty('value')) {
																       valueCheck = jsonResponse[0].value;   
																   }
                                                               evaluationLevel.getStore().getProxy().extraParams={
						                					   programId:programId,
						                					   batchId:batchId.getValue(),
						                					   periodId:periodId.getValue(),
						                					   evaluationLevel:"EVALUATION_TYPE",
						                					   isGroupBy:true,
						                					   isOtherEval:false
						                				   };
						                				   evaluationLevel.getStore().load({															   
                                                                        callback:function(records){
                                                                            var levelIds=[];
                                                                            var localVar = "Yes";
                                                                            for (var i = 0; i < records.length; i++) {
                                                                                   if(valueCheck.toLowerCase() === localVar.toLowerCase()){
                                                                                        levelIds.push(records[i].data.id);
                                                                                    }                                                                              
                                                                            }
                                                                            
                                                                            evaluationLevel.setValue(levelIds);                                                                           
                                                                         }                                                                     
														   });
															   }
														   }); 
														   
					            						   evaluationLevelType.setValue("EVALUATION_TYPE");
					            						   
						                				   /* validation removed for V2D-154950 bug*/
						                				   form.isValid();
					            					   }
					            				   });
				                				   courseId.setDisabled(false);
												   courseId.reset();
												   courseId.getStore().getProxy().extraParams={
				                					   academyLocationIds:academyLocationIds,
				                					   admissionId:studentId.getValue(),
				                					   whetherMarksheet:true,
				                					   programId:programId,
				                					   batchId:batchId.getValue(),
				                					   periodId:periodId.getValue(),
				                					   facultyId:facultyId,
													   isRecalculateScreen:false
				                				   };
				                				   courseId.getStore().load();
				                				   
											   }else{
												   evaluationLevelType.setDisabled(false);
				                				   evaluationLevelType.getStore().getProxy().extraParams={
				                				   };
				                				   evaluationLevelType.getStore().load({
					            					   callback:function(){
					            						   evaluationLevelType.setValue("EVALUATION_TYPE");
					            						    evaluationLevel.getStore().getProxy().extraParams = {
													   programId: form.findField("programId").getValue(),
													   batchId: form.findField("batchId").getValue(),
													   //periodId: form.findField("periodId").getValue(),
													   evaluationLevel: evaluationLevelType.getValue(),
													   isGroupBy: true,
													   isOtherEval: false

												   };
												      evaluationLevel.getStore().load();
					            					   }
					            				   });
					            				   
				                				   
												   sectionId.reset();
				                				   sectionId.setDisabled(false);
				                			/*	   evaluationLevel.getStore().getProxy().extraParams={
				                					   programId:programId,
				                					  // batchId:form.findField("batchId").getValue(),
				                					   //periodId:record[0].data.id,
				                					   evaluationLevel:evaluationLevelType.getValue(),
				                					   isGroupBy:true,
				                					   isOtherEval:false
				                				   };*/
				                				   
												  
				                				   
				                				   
				                				   
				                				
				                				   evaluationLevel.setDisabled(false);
				                				   /* validation added for V2D-115037 bug*/
				                				   form.isValid();
				                				   
				                				   courseId.setDisabled(false);
												   courseId.reset();
												   courseId.getStore().getProxy().extraParams={
				                					   academyLocationIds:academyLocationIds,
				                					   admissionId:studentId.getValue(),
				                					   whetherMarksheet:true,
				                					   programId:programId,
				                					  // batchId:batchId.getValue(),
				                					  // periodId:periodId.getValue(),
				                					   facultyId:facultyId,
													   isRecalculateScreen:false
				                				   };
				                				   courseId.getStore().load();
											   }
											   
										   }
									   }
 							   });
							   }else{
								   periodId.getProxy().extraParams={
									   academyLocationIds:academyLocationIds,
									   admissionId:studentId.getValue(),
									   programId:programId,
									   whetherMarksheet:true,
									   //facultyId:facultyId
								   };
             				   
								   evaluationLevelType.setDisabled(false);
             				  
             				   evaluationLevelType.getStore().load({
	            					   callback:function(){
	            						   evaluationLevelType.setValue("EVALUATION_TYPE");
	            					   }
	            				   });
             				  // evaluationLevelType.getStore().load();
								   
             				   evaluationLevel.reset();
             				   evaluationLevel.setDisabled(true);
             				   
								   evaluationLevel.getStore().getProxy().extraParams={
             					   programId:programId,
             					  // batchId:form.findField("batchId").getValue(),
             					   //periodId:record[0].data.id,
             					   evaluationLevel:evaluationLevelType.getValue(),
             					   isGroupBy:true,
             					   isOtherEval:false
             				   };
             				   //evaluationLevel.getStore().load();
             				   //evaluationLevel.setDisabled(false);
             				   
             				   courseId.setDisabled(false);
								   courseId.reset();
								   courseId.getStore().getProxy().extraParams={
             					   academyLocationIds:academyLocationIds,
             					   admissionId:studentId.getValue(),
             					   whetherMarksheet:true,
             					   programId:programId,
             					   batchId:batchId!=null?batchId.getValue():null,
             					   periodId:periodId!=null?periodId.getValue():null,
             					   facultyId:facultyId,
								   isRecalculateScreen:false
             				   };
             				   courseId.getStore().load();
							   }
							  
						   }
					   }
				   });
				 
				   //form.findField("sectionId").reset();
				  // form.findField("sectionId").setDisabled(true);
				   form.findField("courseVariant").reset();
				   form.findField("courseVariant").setDisabled(true);
			   }
		   },
		   
		   'studentassessmentreportfilter customcombobox[itemId=batchItemId]' : {
			   select:function(obj, rec){
				   var $this=this;
				   var batchId=rec[0].data.id;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				   var periodId = form.findField("periodId").getStore();
				   var sectionId = form.findField("sectionId");
				   var studentId = form.findField("studentId");
				   var evaluationLevelType = form.findField("evaluationLevel")
				   var evaluationLevel = form.findField("evalLevelName");
				   var courseId=form.findField("courseId"); 
				   form.findField("periodId").reset();
				   form.findField("periodId").setDisabled(false);
				   
				   var portalId = $this.getCurrentLoggedPortalId();
				   var facultyId=null;
				   var  academyLocationIds=null;
				   if(portalId==2){
					   academyLocationIds=$this.getCurrentAcademyLocation();
				   	   facultyId=$this.getCurrentlyLoggedInUser().id;
				   }else{
					   academyLocationIds = $this.getCurrentAcademyLocation();
				   }
				   
				   periodId.getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   admissionId:studentId.getValue(),
					   programId:form.findField("programId").getValue(),
					   batchId:batchId,
					   whetherMarksheet:true,
					   facultyId:facultyId
				   };
				   form.findField("sectionId").reset();
				   periodId.load({
					   callback: function(record, operation, success) {
						   if (success) {
							   form.findField("periodId").setDisabled(false);
							   if(record.length == 1){
								   form.findField("periodId").setValue(record[0].data.id);
								   sectionId.reset();
             				   sectionId.setDisabled(false);
             				   sectionId.getStore().getProxy().extraParams={
             					   academyLocationIds:academyLocationIds,
             					   admissionId:studentId.getValue(),
             					   programId:form.findField("programId").getValue(),
             					   batchId:form.findField("batchId").getValue(),
             					   periodId:record[0].data.id,
             					   whetherMarksheet:true,
             					   facultyId:facultyId
             				   };
             				   sectionId.getStore().load(); 
							   
							   courseId.getStore().getProxy().extraParams = {
							   					   academyLocationIds: academyLocationIds,
							   					   admissionId: studentId.getValue(),
							   					   whetherMarksheet: true,
							   					   programId: form.findField("programId").getValue(),
							   					   batchId: form.findField("batchId").getValue(),  
							   					   periodId:form.findField("periodId").getValue(),    
							   					   facultyId: facultyId,
												   isRecalculateScreen:false
							   				   };
							   				   courseId.getStore().load();
							   }else{
								
								courseId.getStore().getProxy().extraParams = {
															   					   academyLocationIds: academyLocationIds,
															   					   admissionId: studentId.getValue(),
															   					   whetherMarksheet: true,
															   					   programId: form.findField("programId").getValue(),
															   					   batchId: form.findField("batchId").getValue(),  
															   					   periodId:form.findField("periodId").getValue(),    
															   					   facultyId: facultyId,
																				   isRecalculateScreen:false
															   				   };
															   				   courseId.getStore().load();
								    sectionId.setDisabled(true);
							   }
							   evaluationLevelType.setDisabled(false);
         				   evaluationLevelType.getStore().getProxy().extraParams={
         				   };
         				   evaluationLevelType.getStore().load({
         					   callback:function(){
         						   evaluationLevelType.setValue("EVALUATION_TYPE");
         					   }
         				   });
         				  // evaluationLevelType.getStore().load();
         				   
							   evaluationLevel.getStore().getProxy().extraParams = {
								   programId: form.findField("programId").getValue(),
								   batchId: form.findField("batchId").getValue(),
								   periodId: record[0].data.id,
								   evaluationLevel: "EVALUATION_TYPE",
								   isGroupBy: true,
								   isOtherEval: false
							   };
							   //evaluationLevelType.setDisabled(false);
							   evaluationLevel.getStore().load();
							   evaluationLevel.setDisabled(false);
						   }
					   }

				   });
				   form.findField("courseVariant").setDisabled(true);
				   form.findField("courseVariant").reset(); 


			   }
		   },
		   
		   'studentassessmentreportfilter customcombobox[itemId=periodItemId]' : {
			   select:function(obj, rec){
				   var $this=this;
				   var periodId=rec[0].data.id;
				   var form=obj.up('form').getForm();
				   var sectionId = form.findField("sectionId").getStore();
				   form.findField("sectionId").reset();
				   form.findField("sectionId").setDisabled(false);
				   var studentId = form.findField("studentId");
				   var courseId=form.findField("courseId");  
				   var portalId = $this.getCurrentLoggedPortalId();
				   var facultyId=null;
				   var  academyLocationIds=null;
				   if(portalId==2){
					   academyLocationIds=$this.getCurrentAcademyLocation();
				   	   facultyId=$this.getCurrentlyLoggedInUser().id;
				   }else{
					   academyLocationIds = $this.getCurrentAcademyLocation();
				   }
				   sectionId.getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   admissionId:studentId.getValue(),
					   programId:form.findField("programId").getValue(),
					   batchId:form.findField("batchId").getValue(),
					   periodId:periodId,
					   whetherMarksheet:true,
					   facultyId:facultyId
				   };
				   sectionId.load();
				   var evaluationLevel = form.findField("evalLevelName");
				    var evalLevel = form.findField("evaluationLevel");
				    evalLevel.enable();
				   evaluationLevel.reset();
				   var evaluationLevelType = form.findField("evaluationLevel");
				   evaluationLevel.getStore().getProxy().extraParams={
					   programId:form.findField("programId").getValue(),
					   batchId:form.findField("batchId").getValue(),
					   periodId:form.findField("periodId").getValue(),
					   evaluationLevel:evaluationLevelType.getValue(),  
					   isGroupBy:true,
					   isOtherEval:false
					   
				   };
				   evaluationLevel.getStore().load();  
				   form.findField("courseVariant").setDisabled(true);
				   form.findField("courseVariant").reset();
				   
				   courseId.reset();
				   				   courseId.getStore().getProxy().extraParams = {
				   					   academyLocationIds: academyLocationIds,
				   					   admissionId: studentId.getValue(),
				   					   whetherMarksheet: true,
				   					   programId: form.findField("programId").getValue(),
				   					   batchId: form.findField("batchId").getValue(),  
				   					   periodId:periodId!=null?periodId:null,  
				   					   facultyId: facultyId,
									   isRecalculateScreen:false
				   				   };
				   				   courseId.getStore().load();
			   }
		   },
		   
		   'studentassessmentreportfilter customcombobox[itemId=evaluationLevelItemId]' : {
			   select:function(obj, rec){
				   var $this=this;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				   var evaluationLevel = form.findField("evalLevelName");
				   evaluationLevel.reset();
				   evaluationLevelType=rec[0].data.id;
				   evaluationLevel.getStore().getProxy().extraParams={
					   programId:form.findField("programId").getValue(),
					   batchId:form.findField("batchId").getValue(),
					   periodId:form.findField("periodId").getValue(),
					   evaluationLevel:evaluationLevelType,
					   isGroupBy:true,
					   isOtherEval:false
					   
				   };
				   evaluationLevel.getStore().load();
				   evaluationLevel.setDisabled(false);
				   if(form.isValid()){
					   
				   }

			   }
		   },
		   
		   'studentassessmentreportfilter customcombobox[itemId=courseItemId]' : {
			   select:function(obj, rec){
				   var $this=this;
				   var courseId=rec[0].data.id;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				   var courseVariant = form.findField("courseVariant").getStore();
				   var studentId = form.findField("studentId");
				   form.findField("courseVariant").setDisabled(false);
				   form.findField("courseVariant").reset();
				   
				   var portalId = $this.getCurrentLoggedPortalId();
				   var facultyId=null;
				   var  academyLocationIds=null;
				   if(portalId==2){
					   academyLocationIds=$this.getCurrentAcademyLocation();
				   	   facultyId=$this.getCurrentlyLoggedInUser().id;
				   }else{
					   academyLocationIds =$this.getCurrentAcademyLocation();
				   }
				   
				   var values = form.getValues();
				   courseVariant.getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   admissionId:studentId.getValue(),
					   courseId:courseId,
					   whetherMarksheet:true,
					   facultyId:facultyId
				   };
				   courseVariant.load();
			   }
		   },
		   
		   'studentassessmentreportfilter button[itemId=searchBtn]' : {
			   click:function(obj){
				   obj.setDisabled(true);				   
				   var $this = this;
				   var form=$this.getStudentassessmentreportfilter().getForm();
				   var formValues=form.getValues();
				   var programId=formValues.programId;
				   var batchId=formValues.batchId;
				   var admissionId=formValues.studentId;
				   var periodId=formValues.periodId;
				   var sectionId=formValues.sectionId;
				   var courseId=formValues.courseId;
				   var courseVariant=formValues.courseVariant;
				   var studentassessmentreportgrid = $this.getStudentassessmentreportgrid();
				   var evaluationLevelName=formValues.evaluationLevel;
				   
				   studentassessmentreportgrid.sectionId = sectionId;
				   studentassessmentreportgrid.levelName = formValues.evalLevelName;
				   
				   var portalId = $this.getCurrentLoggedPortalId();
				   var facultyId=null;
				   var  academyLocationIds=null;
				   if(portalId==2){
					   academyLocationIds=$this.getCurrentAcademyLocation();
				   	   facultyId=$this.getCurrentlyLoggedInUser().id;
				   }else{
					   academyLocationIds = $this.getCurrentAcademyLocation(); 
				   }
				   
				   var evalLevelIdArray = [];
				   var evalLevelNameArray = [];
			       var records;
//			       var evaluationLevelValue = null;
			       if (!isNullOrEmpty(formValues.evalLevelName)) {
			            for (var i = 0; i < formValues.evalLevelName.length; i++) {
			                var evalLevelNameValue = formValues.evalLevelName[i];
			                if (Ext.isObject(evalLevelNameValue)) {
			                	evalLevelIdArray.push(evalLevelNameValue.data.id);
			                	evalLevelNameArray.push(evalLevelNameValue.data.value);
			                } else {
			                	if(isNaN(evalLevelNameValue)) {
			                		evalLevelIdArray.push(evalLevelNameValue);
			                		evalLevelNameArray.push(evalLevelNameValue);
			                	}
			                	else {
			                		evalLevelIdArray.push(evalLevelNameValue);
			                		evalLevelNameArray.push(form.findField('evalLevelName').getValueModels()[i].get('value'));
			                	}
			                }
//			                evaluationLevelValue = formValues.evalLevelName[i].data.value;
			            }
			        }
			        var levelOneIds=null;
			        var levelTwoIds=null;
			        var methodIds=null;
			        var planIds=null;
			        var eventIds=null;
			        var levelIds=null;
			        if (evaluationLevelName=="EVALUATION_PLAN"){
			        	planIds= evalLevelIdArray.join();
			        } else if(evaluationLevelName=="EVALUATION_TYPE"){
			        	levelOneIds= evalLevelIdArray.join();
			        }  else if (evaluationLevelName=="EVALUATION_SUB_TYPE"){
			        	levelTwoIds= evalLevelIdArray.join();
			        } else if (evaluationLevelName=="EVALUATION_METHOD"){
			        	methodIds=evalLevelIdArray.join();
			        } else if (evaluationLevelName=="EVALUATION_EVENT"){
			        	eventIds=evalLevelIdArray.join();
			        }
			        var sectionIds=[];
			       sectionIds.push(formValues.sectionId);
				   studentassessmentreportgrid.getStore().getProxy().extraParams={
					   admissionId:admissionId,
					   programId:programId,
					   batchId:batchId,
					   academyLocationIds: academyLocationIds,
					   evaluationPlanLevelOneIds:levelOneIds,
					   evaluationPlanLevelTwoIds:levelTwoIds,
					   evalSeqIds:methodIds,
					   eventIds:eventIds,
					   evaluationPlanIds:planIds,
					   //facultyId:facultyId,
					   courseId:courseId,
					   courseVariantId:courseVariant,
					   sectionIds:sectionIds,
					   assessmentType : evaluationLevelName,
					   evaluationLevelName:evalLevelNameArray.join(),
					   portalId:$this.getCurrentLoggedPortalId(),
					   periodIds: periodId
				   };
				   
				   $this.uncheckGridHeader(studentassessmentreportgrid);
				   Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
				   studentassessmentreportgrid.getStore().load({
					   callback:function(){
						   Ext.getBody().unmask();
						   obj.setDisabled(false);
						   studentassessmentreportgrid.getSelectionModel().deselectAll();
						   $this.uncheckGridHeader(studentassessmentreportgrid);
						   if(periodId){
							   var progressionStatus = studentassessmentreportgrid.down('#publishProgressionStatus');
							   progressionStatus.setDisabled(false)
						   }
					   }
				   });
				   obj.up('form').collapse();
			   }
		   },
		   
		   'studentassessmentreportfilter button[itemId=resetBtn]' : {
			   click:function(obj){
			   var $this=this;
			   var form=this.getStudentassessmentreportfilter().getForm();
			   form.reset();
			   var programId = form.findField("programId");
			   var studentId = form.findField("studentId").getStore();
			   var studentassessmentreportgrid = $this.getStudentassessmentreportgrid();
			   var publishButton = studentassessmentreportgrid.down('#publishProgressionStatus');
			   var portalId = $this.getCurrentLoggedPortalId();
			   var facultyId=null;
			   var  academyLocationIds=null;
			   var program=null;
			   
			   publishButton.setDisabled(true);
			   if(portalId==2){
				   program = programId.getStore();
					//var submitURL=SERVERURL.FIND_ALL_ACTIVE_PROGRAM_BY_ASSIGNED_FACULTYID;
				   //program.getProxy().api.read=submitURL;

				   academyLocationIds=$this.getCurrentAcademyLocation();
				   facultyId=$this.getCurrentlyLoggedInUser().id;

				   program.getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   whetherMarksheet:true,
					   facultyId:facultyId,
					   whetherSchool:true
				   };
				   program.load();
				   studentId.getProxy().extraParams = {
					   academyLocationIds:academyLocationIds,
					   whetherMarksheet:true,
					   facultyId:facultyId
				   }
				   studentId.reload();
			   }else{
				   program = programId.getStore();
				   academyLocationIds = $this.getCurrentAcademyLocation();
				   program.getProxy().extraParams={
					   academyLocationIds:academyLocationIds,
					   whetherMarksheet:true,
					   facultyId:facultyId
				   };
				   program.load();
				   studentId.getProxy().extraParams = {
					   academyLocationIds:academyLocationIds,
					   whetherMarksheet:true,
					   facultyId:facultyId
				   }
				   studentId.reload();
			   }
			   
			   var batch = form.findField("batchId");
			   var periodId = form.findField("periodId");
			   var sectionId = form.findField("sectionId");
			   var evaluationLevel = form.findField("evaluationLevel");
			  // var evalLevelName = form.findField("evalLevelName");
			   var courseId = form.findField("courseId");
			   var courseVariant = form.findField("courseVariant");
			   var evaluationLevelItemId = form.findField("evaluationLevel");
			   var evaluationLevel = form.findField("evalLevelName");
			   batch.setDisabled(true);
			   periodId.setDisabled(true);
			   sectionId.setDisabled(true);
			   evaluationLevel.setDisabled(true);
			   evaluationLevelItemId.setDisabled(true);
			   courseId.setDisabled(true);
			   courseVariant.setDisabled(true);
			   
			   /*evaluationLevelItemId.setDisabled(false);
			   evaluationLevelItemId.getStore().getProxy().extraParams={
			   };
			   evaluationLevelItemId.getStore().load({
				   callback:function(){
					   evaluationLevelItemId.setValue("EVALUATION_TYPE");
				   }
			   });*/
			   
			  /* evaluationLevel.setDisabled(false);
			   evaluationLevel.getStore().getProxy().extraParams={
				   evaluationLevel:"EVALUATION_TYPE"
			   };
			   evaluationLevel.getStore().load();*/
			   
			   var alinfomodel = Academia.model.authentication.ALInfoModel;
			   var whetherSchool = alinfomodel.get('wheatherSchool');
			   if(whetherSchool) {
				   form.findField("periodId").setVisible(false);
			   } else {
				   form.findField("periodId").setVisible(true);
			   }
			   
			   }
		   },
		   'studentassessmentreportgrid button[itemId=sendMessageStudentAssessmentReportItemId]': {
     	   click: this.openStudentAssessmentSendMessage
        },
        'studentassessmentreportgrid button[itemId=publishProgressionStatus]': {
      	   click: this.publishProgressionStatus
         },
        'studentassessmentreportgrid button[itemId=publishStudentAssessmentReportItemId]': {
     	   click: this.publishStudentAssessmentReportEvent
        },
       'studentassessmentreportgrid button[itemId=unpublishTheGradeBook]': {
      	   click: this.unpublishGradeBookForStudentAssessmentReport
         },
        'studentassessmentreportgrid button[itemId=studentCommentbtnDeleteId]': {
      	   click: this.deleteStudentAssessmentReportEvent
         },
        'studentassessmentsendmessagesform radiogroup[itemId=messageType]':{
     	   change : function(val,nV,oV){
     		   this.selectStudentAssessmentMessageType(val,nV,oV);
     	   }
        },
        'studentassessmentsendmessagesform customcombobox[itemId=msgTempletId]':{
     	   select : function(obj,rec){
     		   this.selectStudentAssessmentMessageTemp(obj,rec);
     	   }
        },
        'studentassessmentreportgrid button[itemId=unpublishStudentAssessmentReportItemId]': {
      	   click: this.unPublishStudentAssessmentReportEvent
         },
         
         'studentassessmentsendmessagesform button[itemId=adhocMsgSubmitBtn]':{
     	   click: function(obj) {
     		   var grid = this.getStudentassessmentreportgrid();
     		   var studentsendmessage = this.getStudentassessmentsendmessagesform();
				   var wsMsgEventRecipientConfigsUpdated = [];
				/*var wsMsgEventRecipientConfigsUpdated = [{ 
							                           	 	msgRecipientTypeId: 500,
							                           	 	msgTemplateConfigId: 0,	//formData.id, 
							                           	 	selectiveRecipientIds: [] 
							                            },{ 
							                           	 	msgRecipientTypeId: 600,
							                           	 	msgTemplateConfigId: 0,	//formData.id, 
							                           	 	selectiveRecipientIds: [] 
							                            }];*/
				
				var formData = obj.up('form').getValues();
				
				var sendMessageToOptions = formData.recieverType;
				var isStudentChecked = false;
				var isParentChecked = false;
				var isFeePayerChecked = false;
				var isMySelfChecked = false;
				var isLoggedInUserId=this.getCurrentlyLoggedInUser().id;
				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
					if(sendMessageToOptions.constructor === Array){
						if(sendMessageToOptions.length > 0){
							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
     						if(current_value == 1 || current_value == '1'){
     							isStudentChecked = true;
     						}
								if(current_value == 2 || current_value == '2'){
									isParentChecked = true;
								}
								if(current_value == 3 || current_value == '3'){
									isFeePayerChecked = true;
								}if(current_value == 4 || current_value == '4'){
									isMySelfChecked = true;
								}
     					});
						}
					}else{
						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
							isStudentChecked = true;
						}
						if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
							isParentChecked = true;
						}
						if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
							isFeePayerChecked = true;
						}if(sendMessageToOptions == 4 || sendMessageToOptions == '4'){
							isMySelfChecked = true;
						}
					}
				}
				if(!isStudentChecked && !isParentChecked){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_INCLUDE_MYSELF_WITH_OTHER_ONE')); 
	    		   return false;
				}
				
				//var abc = xyz.c;
				
				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
					//wsMsgEventRecipientConfigsUpdated = [];
					studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
				}else{
					var recipientIds;
					if(grid.itemId == 'studentassessmentreportgridItemId'){
						recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
						recipientIds = Ext.encode(recipientIds);
						//typeId = 2;
						//recipientId = 2;
					}
					
					var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];
					
					if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
						// Ajax Call to get Parent Ids by Admission Ids
						
						Ext.Ajax.request({
 						type: 'rest',
 						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
 						jsonData: RecipientTypeCodes,
 						method: 'POST',
 						success: function(response) {
 							var RecipientTypeCodesData = Ext.decode(response.responseText);
 							
 							Ext.Ajax.request({
         						type: 'rest',
         						url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
         						jsonData: recipientIds,
         						method: 'POST',
         						success: function(response) {
         							// update wsMsgEventRecipientConfigsUpdated with parent ids
         							var wsMsgEventRecipientConfigsParents = {
								            									msgRecipientTypeId: 66,
												                           	 	msgTemplateConfigId: 0,	//formData.id, 
												                           	 	selectiveRecipientIds: []
									            							};
         							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
         								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
         							}
         							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
         							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
         							
         							// Ajax Call to get Fee Payer Ids by Admission Ids
         							Ext.Ajax.request({
 	            						type: 'rest',
 	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
 	            						jsonData: recipientIds,
 	            						method: 'POST',
 	            						success: function(response) {
 	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
 	            							var wsMsgEventRecipientConfigsFeePayer = {
		            									msgRecipientTypeId: 67,
						                           	 	msgTemplateConfigId: 0,	//formData.id, 
						                           	 	selectiveRecipientIds: []
			            							};
 	            							
 	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
 	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
 	            							}
 	            							
 	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
 	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
 	            						}
 	            					});
         						}
         					});
 						}
						});
					}else{ // Only one checkbox is selected
						var urlNew = '';
						if(isParentChecked) { // If Parent checkbox is selected
							// url for getting parent ids
							urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
						}
						if(isFeePayerChecked) { // If Fee Payer checkbox is selected
							// url for getting fee payer ids
							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
						}
						
						Ext.Ajax.request({
 						type: 'rest',
 						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
 						jsonData: RecipientTypeCodes,
 						method: 'POST',
 						success: function(response) {
 							var RecipientTypeCodesData = Ext.decode(response.responseText);
 							
 							Ext.Ajax.request({
         						type: 'rest',
         						url: urlNew,
         						jsonData: recipientIds,
         						method: 'POST',
         						success: function(response) {
         							if(isParentChecked) { // If Parent checkbox is selected
         								// update wsMsgEventRecipientConfigsUpdated with parent ids
         								var wsMsgEventRecipientConfigsParents = {
	            									msgRecipientTypeId: 66,
					                           	 	msgTemplateConfigId: 0,	//formData.id, 
					                           	 	selectiveRecipientIds: []
		            							};
         								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	            							}
											wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
											wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
             						}
         							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
             							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
         								var wsMsgEventRecipientConfigsFeePayer = {
	            									msgRecipientTypeId: 67,
					                           	 	msgTemplateConfigId: 0,	//formData.id, 
					                           	 	selectiveRecipientIds: []
		            							};
         								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
         									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	            							}
	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
											wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
             						}
         							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked);
         						}
         					});
 						}
						});
						
					}
					
					//studentsendmessage.sendMessage(obj,grid);
				}
				if(isMySelfChecked){
					var wsMsgEventRecipientConfigsMySelf = {
								msgRecipientTypeId: 166,
								msgTemplateConfigId: 0,	//formData.id, 
								selectiveRecipientIds: [isLoggedInUserId]
									};
						wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsMySelf);

									}
			}
        },
        'studentassessmentsendmessagesform filefield[itemId=staticUploadFileField]': {
     	   change: function(fileField, value, eOpts){
     		   var this$ = this;
     		   this$.uploadStudentAssessmentStaticDocumentFileMessage(fileField, value, eOpts);
     	   }
        },
        'studentassessmentstaticdocumentattachmentgrid actioncolumn': {
     	   click : function(view, rowIndex, colIndex, item, e, record, row){
     		   this.deleteStudentAssessmentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
     	   }
        },
        'studentassessmentsendmessagesform': {
     	   render: function(grid){
     		   var this$ = this;
     		   var docGrid = grid.down('#studentassessmentstaticdocumentattachmentgridMessage');
     		   docGrid.getStore().removeAll();
     		   docGrid.getStore().sync();
     		   var portalId = this.getCurrentLoggedPortalId();
     		   var searchForm=this.getStudentassessmentsendmessagesform();
     		   var permissionsMap = new Ext.util.HashMap();
     		   if(portalId==2){
     			   permissionsMap=this.getFACULTY_STUDENT_ASSESSMENT_REPORT_PRIVILEGES();
     			   this.disableSendMessageRadioSelectionsPivileges(searchForm,permissionsMap);
     		   }else if(portalId==1){
     			   permissionsMap=this.getEXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES();
     			   this.disableSendMessageRadioSelectionsPivileges(searchForm,permissionsMap);
     		   }
     	   }            
        },
        
          'studentassessmentsendmessagesform radiogroup#sendingPriority': {
     	   change: function( radio, newValue, oldValue, eOpts) {
     		   this.loadStudentAssessmentScheduleField(radio, newValue, oldValue);
     	   }
        },
        
         'studentassessmentsendmessagesform textarea[itemId=smsDiscription]':{
     	   change : function(val,nV,oV){
     		   var remarkSendMessages = this.getStudentassessmentsendmessagesform();
     		   var academyLocId = this.getCurrentAcademyLocation();
     		   var smsTextField = remarkSendMessages.down('#smsDiscription');
     		   var smsTextFieldDiscription = remarkSendMessages.down('#smsDiscriptionNotice');
     		   var maxLength = localStorage.getItem('maxLength');
     		   var newValue = maxLength - smsTextField.getValue().length;
     		   smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');
     	   }
        },
        'studentassessmentsendmessagesform textarea[itemId=pushNotificationDiscription]':{
     	   change : function(val,nV,oV){
     		   var remarkSendMessages = this.getStudentassessmentsendmessagesform();
     		   var academyLocId = this.getCurrentAcademyLocation();
     		   var smsTextField = remarkSendMessages.down('#pushNotificationDiscription');
     		   var smsTextFieldDiscription = remarkSendMessages.down('#pushNotificationDiscriptionNotice');
     		   var maxLength = 1000;
     		   var newValue = maxLength - smsTextField.getValue().length;
     		   smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');
     	   }
        },

        'studentassessmentreportgrid button[itemId=exportStudentAssessmentReportItemId]' : {
        	click:function(obj){
        		var $this = this;
        		var formWindow = $this.getStudentassementreporttypewin();
        	//	  var form=this.getStudentassementreporttypewin().down('form');
        		//var templateValue= form.down('#chooseTemplateId').getValue();
        		if (!formWindow) {
        			Ext.widget('studentassementreporttypewin');
        			formWindow = $this.getStudentassementreporttypewin();
        			var windowFrom=formWindow.items.items[0].getForm();
        		}
//        		formWindow.setHeight(160);
//        		formWindow.setWidth(400);

        		var tempalte = formWindow.down('#chooseTemplateId').getStore();
        		tempalte.getProxy().extraParams={
        			 reportType:'Student Event Assessment Report' //API depended
        		};
        		tempalte.load({
        			callback:function(record) {
        				if( record.length==0) {
        					var grid = $this.getStudentassessmentreportgrid();
        					var checkedChildren = $this.getGridCheckedChildren(grid);
        					var examResultIds = checkedChildren.examResultIds;

        					if(isNullOrEmpty(examResultIds) || examResultIds.length==0){
        						var allGridRecord = $this.getGridAllChildren(grid);
        						var examResultIds = allGridRecord.examResultIds;
        					}else{
        						var checkedChildren = $this.getGridCheckedChildren(grid);
        						var examResultIds = checkedChildren.examResultIds; 
        					}
        					var reportParams =new Object();
        					var reportTitle="";

        					var code = "SIS_STUDENT_ASSESSMENT_REPORT";
        					reportParams.examResultIds=examResultIds.join();
        					var URL = SERVERURL.EXPORT_STUDENT_ASSESSMENT_REPORT;
        					$this.exportJRXMLReport(code, reportParams, code,'.vnd.ms-excel', URL);

        				} else {
        					formWindow.show();
        					var tempalteF = formWindow.down('#chooseTemplateId');
        					var tempalte = formWindow.down('#chooseTemplateId').getStore();
        					tempalte.getProxy().extraParams={
        						 reportType:'Student Event Assessment Report'
        					};
        					tempalte.load({
        	        			callback:function(record) {
        	        				if(record.length==1) {
        	        					tempalteF.setValue(record[0].data.id);
        	        				}
        	        			}
        					});
        					//windowFrom.isValid();
        					
        				}
        			}
        		});

        	}
        },
		   
		   'studentassessmentreportwin' : {
			   afterrender:function(){
				   var $this = this;
				   var grid = $this.getStudentassessmentreportgrid();
				   var gridRecord=$this.getGridCheckedChildren(grid);
				   var studentassessmentreportwin=$this.getStudentassessmentreportwin();
				   var docPublishDateField=studentassessmentreportwin.down('#publishDateItemId');
				   var batchStartDate=[];
				   var batchEndDate=[];
				   batchStartDate=$this.removeDuplicatesFromArrays(gridRecord.batchStartDate);
				   batchEndDate=$this.removeDuplicatesFromArrays(gridRecord.batchEndDate);
				   docPublishDateField.setMinValue(Ext.Date.format(new Date(batchStartDate[0]), 'Y-m-d'));
				   docPublishDateField.setMaxValue(Ext.Date.format(new Date(batchEndDate[0]), 'Y-m-d'));
 				   var generateAndPublishBtn = studentassessmentreportwin.down('#generateAndPublishBtn');
					generateAndPublishBtn.setVisible(false);
				   var submitBtn = studentassessmentreportwin.down('#submitBtn');
					submitBtn.setVisible(false);
					 var portalId = this.getCurrentLoggedPortalId();
	     		  	 var permissionsMap = new Ext.util.HashMap();
     		 		  if(portalId==2){
     			 		  	permissionsMap=this.getFACULTY_STUDENT_ASSESSMENT_REPORT_PRIVILEGES();
							var academyLocationId = this.getCurrentAcademyLocation();
				    		var associatedAcadLocationIds = new Array();
				    		associatedAcadLocationIds.push(academyLocationId);
				    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 				  		 Ext.each(permissionList, function(privilege) {
			       		   if (privilege === 'GENERATE_AND_PUBLISH_BUTTON') {
			       			   if(!isNullOrEmpty(generateAndPublishBtn)){
			       				   generateAndPublishBtn.setVisible(true);	
			       			   }
			       		   }
			       		   if (privilege === 'GENERATE_BUTTON') {
			       			   if(!isNullOrEmpty(submitBtn)){
			       				   submitBtn.setVisible(true);	
			       			   }
			       		   }
			       	   });
     		 		  }else if(portalId==1){
     			 			 permissionsMap=this.getEXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES();
							var academyLocationId = this.getCurrentAcademyLocation();
				    		var associatedAcadLocationIds = new Array();
				    		associatedAcadLocationIds.push(academyLocationId);
				    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 				  		 Ext.each(permissionList, function(privilege) {
			       		   if (privilege === 'GENERATE_AND_PUBLISH_BUTTON') {
			       			   if(!isNullOrEmpty(generateAndPublishBtn)){
			       				   generateAndPublishBtn.setVisible(true);	
			       			   }
			       		   }
			       		   if (privilege === 'GENERATE_BUTTON') {
			       			   if(!isNullOrEmpty(submitBtn)){
			       				   submitBtn.setVisible(true);	
			       			   }
			       		   }
			       	   });
     		  		 }
     	   }
		   },
		   'studentassessmentreportwin customcombobox[itemId=chooseHallticketTemplate]' : {
			   select:function(){
				   var studentassessmentreportwin=this.getStudentassessmentreportwin();
				   var docPublishDateField=studentassessmentreportwin.down('#publishDateItemId');
				   docPublishDateField.setDisabled(false);
				   var reportType=studentassessmentreportwin.down('#chooseHallticketTemplate').rawValue;
				   var grid = this.getStudentassessmentreportgrid();
				   var gridRecord=this.getGridCheckedChildren(grid);
				   var form=this.getStudentassessmentreportfilter().getForm();
				   var formValues=form.getValues();
				   var admissionIds=this.removeDuplicatesFromArrays(gridRecord.admissionIds);
				   formWindow = this.getStudentassessmentreportwin();
				   var levelName =(formValues.evalLevelName[0] && formValues.evalLevelName[0].data && formValues.evalLevelName[0].data.value != null)
    ? formValues.evalLevelName[0].data.value
    : formValues.evalLevelName[0];
				   
				   var url = SERVERURL.PATH_DOCUMENT_PUBLSIH_DATE_FOR_STUDENT_ASSESSMENT_REPORT;
     		   Ext.Ajax.request({
     			   type: 'rest',
     			   url: url+'?levelName='+levelName+'&periodId='+formValues.periodId+'&admissionId='+admissionIds.join()+'&reportType='+reportType,
     			   method: 'GET',
     			   success : function(records, operation){
     				   var data =records.responseText;
     				   if(data=='DuplicateDate'){
     					   docPublishDateField.setDisabled(false);
     					   docPublishDateField.reset();
     				   }else if(data=='NotPublished'){
     					   docPublishDateField.setDisabled(false);
     					   docPublishDateField.reset();
     					   docPublishDateField.setValue(Ext.Date.format(new Date(), 'Y-m-d'));
     				   }else{
     					   docPublishDateField.setDisabled(false);
     					   docPublishDateField.reset();
     					   var date=Ext.Date.format(new Date(data), 'Y-m-d');
     					   docPublishDateField.setValue(date);
     				   }
     			   }

     		   });
			   }
		   },
		   'studentassessmentreportgrid button[itemId=exportStudentAssessmentGradeBookReportItemId]' : {
			   click:function(obj){
				   var $this = this;
				   var grid = $this.getStudentassessmentreportgrid();
        		   var gridRecord=$this.getGridCheckedChildren(grid);
        		   if(gridRecord.admissionIds.length>0) {
					   var formWindow = $this.getStudentassessmentreportwin();
					   if (!formWindow) {
						   Ext.widget('studentassessmentreportwin',{
							   itemId:'coreERPnFacultyWin'
						   });
						   formWindow = $this.getStudentassessmentreportwin();
					   }
					   formWindow.setHeight(185);      //V2D-423186   
					   formWindow.setWidth(500); 
					   formWindow.show();
					   var tempalte = formWindow.down('#chooseHallticketTemplate').getStore();
					   tempalte.getProxy().extraParams={
						   reportType:'Student Assessment Reports'
					   };
					   tempalte.load();
					   /*var grid = $this.getStudentrolllistgrid();
					   Ext.apply(grid,{
						   code:null,
						   setCode : function(code){
							   grid.code = code;
						   },
						   getCode:function(){
							   return grid.code;
						   }
					   });
					   grid.setCode(true);*/
			       } else {
	        		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
       	       }
			   }
		   },
		   
		   'studentassessmentreportwin[itemId=coreERPnFacultyWin] button[itemId=submitBtn]':{
			   click:function(obj){
				   var $this = this;
				   var grid = $this.getStudentassessmentreportgrid();
				   var form=$this.getStudentassessmentreportfilter().getForm();
        		   var gridRecord=grid.getChecked();
        		   var checkedChildren = $this.getGridCheckedChildren(grid);
				   // code to identify jasper
        		   var examResultIds = checkedChildren.examResultIds;
        		   var studentassessmentreportwin = $this.getStudentassessmentreportwin();
				   var reportType = studentassessmentreportwin.down('#chooseHallticketTemplate');
				   var templateId = reportType.getValue();//"CourseWiseMarksheetReport"; //Enum value put here
				   var reportParams =new Object();
				  
				   var reportTitle="";
				   
				   var zipFileName = reportType.getRawValue();
				   var code = reportType.getRawValue();

				  var formValues=form.getValues();
				   
				   var evaluationPlanLevelName=[];
				   var evaluationLevelNameString = null;
				   
				   if(!isNullOrEmpty(formValues.evalLevelName) && formValues.evalLevelName!=""){
					   for (var i = 0; i < formValues.evalLevelName.length; i++) {
						   var item = formValues.evalLevelName[i];
						   var value = (item && item.data && item.data.value != null) ? item.data.value : item;
						   evaluationPlanLevelName.push(value);
						   evaluationLevelNameString = value
					   }
				   }
         	   reportParams.examResultIds=examResultIds.join();
         	   reportParams.zipFileName=zipFileName;
         	   reportParams.reportTemplateId=templateId;
         	   reportParams.evaluationLevelName=evaluationPlanLevelName.join();
         	   
         	   
         	   if(code=='SIS Assessment Report P3-P6 PDF'||code=='SIS Assessment Report S1-S4 PDF'||code=='SIS Assessment Report S1-S4 PDF New'||code=='SIS Assessment Report P3-P6 PDF New'
         	   ||code=='Sommet Interim Grade Report'){
         		   studentassessmentreportwin.close();
 				   $this.exportJRXMLReport(code, reportParams, code,'.pdf', SERVERURL.PATH_DOWNLOAD_ALL_PDF_ZIP);
         	   }else{
         		   studentassessmentreportwin.close();
 				   $this.exportJRXMLReport(code, reportParams, code,'.vnd.ms-excel', SERVERURL.PATH_DOWNLOAD_ALL_EXCEL_ZIP);
         	   }
			   },
			   enable: function(btn){
				   var $this = this;
				   var grid = $this.getStudentassessmentreportgrid();
				   var win = btn.up('window');
				   win.down('#generateAndPublishBtn').setDisabled(false);
				   /*  var sectionId = grid.sectionId;
        		   
        		   // Done for V2D-114810
        		  if(isNullOrEmpty(sectionId)){
        			   win.down('#generateAndPublishBtn').setDisabled(false);
        		   }
        		   else{
        			   win.down('#generateAndPublishBtn').setDisabled(true);
        		   }*/
			   },
			   disable: function(btn){
				   var $this = this;
				   var win = btn.up('window');
				   win.down('#generateAndPublishBtn').setDisabled(true);
			   }
		   },
		   
		   'studentassessmentreportwin[itemId=coreERPnFacultyWin] button[itemId=generateAndPublishBtn]':{
			   click:function(obj){
				   var $this = this;
				   var grid = $this.getStudentassessmentreportgrid();
				   var dataForCounter = $this.getGridCheckedChildren(grid, true);
				   var counts = dataForCounter.counter.filter(onlyUnique);
				   if(counts.length) {
					   var msg = counts.length + ' ' + getExaminationTranslation('STUDENTS_ON_HOLD_FOR_RESULT_PUBLISH');
					   showConfirmMessage(getExaminationTranslation('GRADE_BOOK'), msg, function(btn, text) {
						   if (btn == 'yes') {
							   $this.publishGradeBook();
						   }
						   else {
							   $this.getStudentassessmentreportwin().close();
						   }
					   });
				   }
				   else {
					   $this.publishGradeBook();
				   }
			   }
		   },
		   
		   'studentassessmentreportgrid':{
			   /*headerclick: function( ct, column, e, t, eOpts ){
				   var me = this;
				   
				   var headerClick = true;
				   if(e.target.type=="checkbox"){
					   var nodes = [];
					   try{
						   var nodes = ct.grid.getRootNode().childNodes;
						   Ext.each(nodes, function(currentNode){
							   if(currentNode.hasChildNodes()){
								   currentNode.set('checked', t.checked);
								   currentNode.cascadeBy(function(node) {
									   node.set('checked', t.checked);
								   });
							   }
							   me.selectParentNodesTreePanel(currentNode, t.checked, headerClick);
						   })
					   }
					   catch(e){
						   console.log('');
					   }
				   }
			   },*/
			   headerclick: function(ct, column, e, t, eOpts) {
				    var me = this;
				    var headerClick = true;
				    var grid = me.getStudentassessmentreportgrid();
				    var buttonRefs = {
				        unpublishBtn: grid.down('#unpublishItemId'),
				        publishStudentAssessmentReportBtn: grid.down('#publishStudentAssessmentReportItemId'),
				        unpublishGradeBookBtn: grid.down('#unpublishTheGradeBook'),
				        sendMsgStudentAssessmentReportBtn: grid.down('#sendMessageStudentAssessmentReportItemId'),
				        exportStudentAssessmentGradeBookReportBtn: grid.down('#exportStudentAssessmentGradeBookReportItemId'),
				        studentCommentbtnDelete: grid.down('#studentCommentbtnDeleteId')
				    };

				    if (e.target.type === "checkbox") {
				    	try {
				    		var nodes = ct.grid.getRootNode().childNodes;

				    		Ext.each(nodes, function(currentNode) {
				    			if (currentNode.hasChildNodes()) {
				    				currentNode.set('checked', t.checked);
				    				currentNode.cascadeBy(function(node) {
				    					node.set('checked', t.checked);
				    				});
				    			}
				    			me.selectParentNodesTreePanel(currentNode, t.checked, headerClick, buttonRefs, grid);
				    		});
				    	}
				    	catch(e) {
				    		console.log('');
				    	}
				    }
				},
			   checkchange: function(node, checked, eOpts) {
				   var me = this;
				   var headerClick = false;
				   var grid = me.getStudentassessmentreportgrid();
				   var buttonRefs = {
				        unpublishBtn: grid.down('#unpublishItemId'),
				        publishStudentAssessmentReportBtn: grid.down('#publishStudentAssessmentReportItemId'),
				        unpublishGradeBookBtn: grid.down('#unpublishTheGradeBook'),
				        sendMsgStudentAssessmentReportBtn: grid.down('#sendMessageStudentAssessmentReportItemId'),
				        exportStudentAssessmentGradeBookReportBtn: grid.down('#exportStudentAssessmentGradeBookReportItemId'),
				        studentCommentbtnDelete: grid.down('#studentCommentbtnDeleteId')
				   };
				   if(node.hasChildNodes()){
					   node.set('checked', checked);
					   node.cascadeBy(function(node) {
						   node.set('checked', checked);
					   });
				   }
				   me.selectParentNodesTreePanel(node, checked, headerClick, buttonRefs, grid);
			   },
			   afterrender: function(tree, eOpts) {
				   if(portalId==2){ //for faculty portal
				   tree.down('#studentCommentbtnDeleteId').hide();
 				   this.visibleExamStudentAssessmentReportPivileges(tree,this.getFACULTY_STUDENT_ASSESSMENT_REPORT_PRIVILEGES());
				   }
				   else if(portalId==1){ //for core erp portal
             	   this.visibleExamStudentAssessmentReportPivileges(tree,this.getEXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES());
             	 //  this.doAccessControlValidation(tree,this.getEXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES());
				   }
			   },
			   beforedestroy: function(tree, eOpts){
				   tree.getStore().getRootNode().removeAll();
			   },
			   cellclick: function(tree, td, cellIndex, record, tr, rowIndex, e, eOpts){
				   if (e.target.tagName == 'A') {
					   this.openERPStudentCommentWindow(record,rowIndex);
				   }
			   }
		   },
		   
		   'studentassessmenterpcommentwin button[itemId=submitBtn]':{
			   click:function(btn){
				   var $this=this;
				   var win = btn.up('window');
				   btn.setDisabled(true);
				   var stCommentRowIndex = win.down('#stCommentRowIndex').getValue();
				   var stCommentExamResultId = win.down('#stCommentExamResultId').getValue();
				   var studentEventRemark = win.down('#studentComment').getValue();

				   var modifiedRecords = new Ext.util.HashMap();

				   modifiedRecords.add(parseInt(stCommentExamResultId),studentEventRemark);
				   var formValues = Ext.encode(modifiedRecords.map);


				   Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');

				   Ext.Ajax.request({
					   type: 'rest',
					   jsonData:formValues,
					   url: SERVERURL.PATH_SUBMIT_STUDENT_ASSESSMENT_REPORT,
					   method: 'PUT',
					   success: function(obj, action) {
						   var grid = $this.getStudentassessmentreportgrid();
						   grid.store.load();
						   $this.uncheckGridHeader(grid);
						   btn.setDisabled(false);
						   win.close();
						   Ext.getBody().unmask();
						   showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getCommonTranslation('SUCCESS'));
					   }
				   });
			   }
   		},
   		
   		 'studentassementreporttypewin button[itemId=downloadReportId]' : {
   	     	click:function(obj){
   	     		  var form=this.getStudentassementreporttypewin().down('form');
   	     		// var downloadReportId=form.getForm().findField('downloadReport');
   	     		var win = obj.up('window');
   	     		  var templateValue= form.down('#chooseTemplateId').getValue();
   	     		var $this=this;
   	     		var grid = $this.getStudentassessmentreportgrid();
   				var checkedChildren = $this.getGridCheckedChildren(grid);
   				var examResultIds = checkedChildren.examResultIds;

   				if(isNullOrEmpty(examResultIds) || examResultIds.length==0){
   					var allGridRecord = $this.getGridAllChildren(grid);
   					var examResultIds = allGridRecord.examResultIds;
   				}else{
   					var checkedChildren = $this.getGridCheckedChildren(grid);
   					var examResultIds = checkedChildren.examResultIds; 
   				}
   				var reportParams =new Object();
   				var reportTitle="";
   				code=form.down('#chooseTemplateId').valueModels[0].raw.value;
   				var value=form.down('#chooseTemplateId').valueModels[0].raw.code
   				reportParams.code=code;
   				reportParams.value=value;
   				reportParams.examResultIds=examResultIds.join();
   				var URL = SERVERURL.EXPORT_STUDENT_ASSESSMENT_REPORT;
   				$this.exportJRXMLReport(code, reportParams, value,'.vnd.ms-excel', URL);
                win.close();
   			   

   	     	}
   		},
   		'studentassementreporttypewin customcombobox[itemId=chooseTemplateId]':{
   		    select: function() {
   		     var form=this.getStudentassementreporttypewin().down('form');
   		    var downoladBtn =form.down("#downloadReportId");
   		   
   		    form.isValid();
   		    downoladBtn.setDisabled(false);
   		        }
   		    },
   		 'studentassessmentreportgrid button[itemId=unpublishItemId]': {
        	   click: this.unpublishResultForStudentAssessmentReport
           }
    	});
    },
    
    
    markObtainedDetailsWindow:function(title, record){
    	var $this = this;


    	var formWindow = this.getMarksobtaineddetailwin();
    	if (!formWindow) {
    		Ext.widget('marksobtaineddetailwin');
    		formWindow = this.getMarksobtaineddetailwin();
    	}
    	formWindow.setTitle(getExaminationTranslation('MARKS_OBTAINED'));
    	var gridStore=formWindow.down('#marksObtainedDetailGridId');
    	gridStore.getStore().getProxy().extraParams = {
    		courseId:record.raw.courseId,
    		eventId:record.raw.eventId,
    		admissionId:record.raw.admissionId,
    		limit:5,
    		sort:null
    	}
    	//gridStore.getStore().load();
    	gridStore.getStore().loadPage(1);
    	$this.toggleGridSummaryRow(gridStore,true);
    	formWindow.show();
    },
    
    loadStudentAssessmentScheduleField : function(radio,newValue, oldValue){
	    	var adhocMessageForm = radio.up('form');
	    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	    	var radioValue = radio.getValue().sendingPriority;

	    	if(radioValue=='IMMEDIATE'){
	    		scheduleDateField.setVisible(false);
	    		scheduleDateField.setDisabled(true);
	    		scheduleTimeField.setVisible(false);
	    		scheduleTimeField.setDisabled(true);    		
	    	}
	    	else if(radioValue=='SCHEDULE'){
	    		scheduleDateField.setVisible(true);
	    		scheduleDateField.setDisabled(false);
	    		scheduleTimeField.setVisible(true);
	    		scheduleTimeField.setDisabled(false);
	    	}
	    },
    
	    disableSendMessageRadioSelectionsPivileges: function(searchForm, permissionsMap) {
    		var academyLocationId = this.getCurrentAcademyLocation();
    		var associatedAcadLocationIds = new Array();
    		associatedAcadLocationIds.push(academyLocationId);
    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    		var messageTypeRadio=searchForm.getForm().findField('messageTypeGroup');
    		var adhocMessage, messageTemplate;
    		messageTypeRadio.setVisible(false);
    		if((Ext.Array.contains(permissionList, 'ADHOC_MESSAGE'))){
    			messageTypeRadio.items.items[0].setValue(true);
    			messageTypeRadio.items.items[1].setValue(false);
    			adhocMessage=true;
    		}
    		if((Ext.Array.contains(permissionList, 'MESSAGE_TEMPLATE'))){
    			messageTypeRadio.items.items[0].setValue(false);
    			messageTypeRadio.items.items[1].setValue(true);
    			messageTemplate=true;
    		}
    		if(adhocMessage && messageTemplate){
    			messageTypeRadio.setVisible(true);
    			messageTypeRadio.items.items[0].setValue(true);
    			messageTypeRadio.items.items[1].setValue(false);
    		}

    	},  
    	
    	deleteStudentAssessmentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
   	    	var grid = view.up('#studentassessmentstaticdocumentattachmentgridMessage');
   	    	var panel = this.getContentPanel().getActiveTab();
   	    	var tabTitle = panel.title;
   	    	var store = grid.getStore();
   	    	var templateConfigDocId = record.get('templateConfigDocId');
   	    	var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
   	    	if(!(tabTitle == viewTitle)){
   	    		if(!isNullOrEmpty(templateConfigDocId)){
   	    			showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
   	    				if (btn == 'yes') {
   	    					Ext.Ajax.request({
   	    						type: 'rest',
   	    						url: SERVERURL.STATIC_DOC_DELETE,
   	    						method: 'DELETE',
   	    						params: {
   	    							templateConfigDocId : templateConfigDocId
   	    						},
   	    						headers: {
   	    							'Content-Type': 'application/json'
   	    						},
   	    						success: function(form, action) {
   	    							store.remove(record);
   	    							showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
   	    						}
   	    					});
   	    				}
   	    			});

   	    		}else{
   	    			store.remove(record);
   	    			showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
   	    		}
   	    	}else{
   	    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
   	    	}

   	    },
   	    
   	 uploadStudentAssessmentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
   		 var this$ = this;
   		 var setupForm = fileField.up('studentassessmentsendmessagesform');
   		 var grid = setupForm.down('#studentassessmentstaticdocumentattachmentgridMessage');
   		 fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
   		 var file = fileField.fileInputEl.dom.files[0];
   		 var fileSizeLimit = '5';
   		 var url = SERVERURL.FILE_PRIORITY;
   		 Ext.Ajax.request({
   			 type: 'rest',
   			 url: url+'?type=emailFileSize',
   			 method: 'GET',
   			 success : function(response, action){
   				 var responseData = Ext.JSON.decode(response.responseText);
   				 if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
   				 {
   					 fileSizeLimit=responseData[0].value;
   				 }
   				 if((file.size / 1048576) <=  fileSizeLimit ){
   					 if(!isNullOrEmpty(fileUploadPath)){
   						 var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
   						 if (extension == "gif" || extension == "png" || extension == "bmp"
   							 || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
   								 || extension == "doc" || extension == "docx" || extension == "txt"
   									 || extension == "xls" || extension == "csv" || extension == "xml" 
   										 || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
   							 var entityId = 'faculty';
	    				     var module = 'messaging';
	    				     var entityType = 'template';
	    				     var documentType = 'DOCUMENT';
	    				     var isTransient = true;
   							 Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
   							 this$.saveStaticDocumentFormMessage2(entityId, module, entityType, documentType, function(success, action, isTransient){
   								 if(success){
   									 Ext.getBody().unmask();
   									  var path = Ext.JSON.decode(action.response.responseText).path;
   									  var user = this$.getCurrentlyLoggedInUser();
   									  var store = grid.getStore();
   									  var documentStatus = "SUBMITTED";
   									  var documentType = null;
   									  if(!isNullOrEmpty(path)){
   										  store.add({
   											  id: '',
   											  name: fileUploadPath,
   											  path: path ,
   											  createdBy : {
   												  id :user.id,
   												  value : user.value,
   												  code : user.code
   											  },
   											  status : documentStatus,
   											  documentType : documentType,
   											  templateConfigDocId: '',
   											  submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

   										  });
   										  this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
   										  showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
   									  }
   									  fileField.reset();
   								 }

   							 }, isTransient);
   						 }else{
   							 fileField.reset();
   							 showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
   						 }
   					 }
   				 }else{
   					 fileField.reset();
   					 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
   				 }
   			 }
   		 });

	    },
	    
	    selectStudentAssessmentMessageTemp: function(obj,rec){
   	    	var $this =  this;
   	    	var formWin = $this.getStudentassessmentsendmessagesform();
   	    	var subject = formWin.down('#subject');
   	    	var smsDiscription = formWin.down('#smsDiscription');
   	    	var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
   	    	var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
   	    	var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
   	    	if(rec[0].data.value == "SMS")
   	    	{
   	    		formWin.down("#subject").allowBlank=true;
   	    		formWin.down("#subject").hide();
   	    		formWin.down("#staticUploadFileField").hide();
   	    		formWin.down("#facultyDocumentMessageAttachmentGrid").hide();
   	    		formWin.down('#discriptionId').reset();
   	    		formWin.down('#discriptionId').hide();	       		 
   	    		formWin.down('#subject').reset();
   	    		formWin.down('#smsDiscription').show();
   	    		formWin.down('#smsDiscriptionNotice').show();
   	    		pushNotificationDiscription.hide();
   	    		pushNotificationDiscriptionNotice.hide();
   	    		pushNotificationDiscription.reset();
   	    		formWin.getForm().checkValidity();
   	    	}
   	    	//V2D-72177
   	    	/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	             subject.show();
             formWin.down("#staticUploadFileField").hide();
             this.setAllowBlank (subject,false);
             formWin.down("#facultyDocumentMessageAttachmentGrid").hide();
             formWin.down('#discriptionId').reset();
             formWin.down('#discriptionId').hide();
             subject.reset();
             smsDiscription.reset();
             smsDiscription.hide();
             smsDiscriptionNotice.hide();
             pushNotificationDiscription.reset();
             pushNotificationDiscription.show();
             pushNotificationDiscriptionNotice.show();
             pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
             formWin.getForm().checkValidity();
             //formWin.down('#smsDiscription')
         }*/
   	    else{
   	    		formWin.down('#discriptionId').reset();
   	    		formWin.down('#smsDiscription').reset();
   	    		formWin.down('#smsDiscription').hide();
   	    		formWin.down('#smsDiscriptionNotice').hide();
   	    		formWin.down("#staticUploadFileField").show();
   	    		// formWin.down("#staticDocumentMessageAttachmentGrid").show();
   	    		formWin.down("#facultyDocumentMessageAttachmentGrid").show()
   	    		formWin.down("#subject").show();
   	    		formWin.down("#subject").allowBlank=false;
   	    		formWin.down('#discriptionId').show();    	
   	    		pushNotificationDiscription.hide();
   	    		pushNotificationDiscriptionNotice.hide();
   	    		pushNotificationDiscription.reset();
   	    		formWin.getForm().checkValidity();
   	    	}
   	    },
   	
   	 publishStudentAssessmentReportEvent:function(obj){
	    	var $this=this;
	    	var grid = $this.getStudentassessmentreportgrid();
	    	var gridRecord=grid.getChecked();
	    	var checkedChildren = $this.getGridCheckedSPChildren(grid);
	    	var formValues = Ext.encode(checkedChildren.map);
	    	//var examResultIdsArray = checkedRecords.examResultIds;
	    	//var studentEventRemarksArray = checkedRecords.studentEventRemark;
	    	var isSubmitted = false;
	    	
	    	var noOfStudent=0;
	    	var dataForCounter = $this.getGridCheckedChildren(grid, true);
			var noOfStudent = dataForCounter.counter.filter(onlyUnique);
			if(noOfStudent.length){
				var msg = noOfStudent.length + ' ' + getExaminationTranslation('STUDENTS_ON_HOLD_FOR_RESULT_PUBLISH');
				   showConfirmMessage(getExaminationTranslation('GRADE_BOOK'), msg, function(btn, text) {
					   if (btn == 'yes') {
						$this.doPublishStudentAssessmentReport(formValues);
					}
				});	
			}
			else {
				$this.doPublishStudentAssessmentReport(formValues);
			}
	    },
	    
	    doPublishStudentAssessmentReport: function(formValues) {
	    	$this=this;
	    	Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');

	    	Ext.Ajax.request({
	    		type: 'rest',
	    		jsonData:formValues,
	    		url: SERVERURL.PATH_PUBLISH_STUDENT_ASSESSMENT_REPORT,
	    		method: 'PUT',
	    		success: function(obj, action) {
	    			Ext.getBody().unmask();
	    			var grid = $this.getStudentassessmentreportgrid();
	    			grid.store.load();
	    			$this.uncheckGridHeader(grid);
	    			showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getCommonTranslation('SUCCESS'));
	    		}
	    	});
	    },
	    
	    deleteStudentAssessmentReportEvent:function(obj){
	    	var $this=this;
	    	var grid = $this.getStudentassessmentreportgrid();
	    	var gridRecord=grid.getChecked();
	    	var checkedChildren = $this.getGridCheckedSPChildren(grid);
	    	if(checkedChildren.length>0){
	    		var formValues = Ext.encode(checkedChildren.map);
		    	//var examResultIdsArray = checkedRecords.examResultIds;
		    	//var studentEventRemarksArray = checkedRecords.studentEventRemark;
		    	var isSubmitted = false;
		    	showConfirmMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getExaminationTranslation('ARE_YOU_SURE_YOU_WANT_TO_DELETE_THESE_RECORDS_?'),function(btn, text) {
		    		if (btn == 'yes') {
		    		Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
		    	    Ext.Ajax.request({
		    		type: 'rest',
		    		jsonData:formValues,
		    		url: SERVERURL.PATH_DELETE_STUDENT_ASSESSMENT_REPORT_COMMENT,
		    		method: 'PUT',
		    		success: function(obj, action) {
		    			Ext.getBody().unmask();
		    			var grid = $this.getStudentassessmentreportgrid();
		    			grid.store.load({
		    				callback:function(record) {
    	        				if(record.length>=1) {
    	        					//grid.down('#exportStudentAssessmentReportItemId').setDisabled(false);
    	        				}
    	        			}
		    			});
		    			$this.uncheckGridHeader(grid);
		    			showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
		    		}
		    	});
		        }
		    	});
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    	
	    },
	    unpublishGradeBookForStudentAssessmentReport :function(){
	    	var $this=this;
	    	var form=$this.getStudentassessmentreportfilter().getForm();
	    	var evalLevelNameFile=$this.getStudentassessmentreportfilter().down('#evalLevelName');
	    	var formValues=form.getValues();
	    	  var evaluationPlanLevelName=[];
			   var evaluationLevelNameString = null;
	    	 if(!isNullOrEmpty(formValues.evalLevelName) && formValues.evalLevelName!=""){
				   for(var i=0;i<formValues.evalLevelName.length;i++){
					   var value=formValues.evalLevelName[i].data.value;
					   evaluationPlanLevelName.push(value);
				       evaluationLevelNameString = value
				   }
			   }
	    	var grid = $this.getStudentassessmentreportgrid();
	    	var gridRecord=grid.getChecked();
	    	
	    	var whetherPublishRec = true;
	    	for(var i = 0;i<gridRecord.length ;i++){
	    		if(gridRecord[i].get('status') == false && gridRecord[i].get('leaf') == true){
	    			whetherPublishRec = false;
	    			break;
	    		}
	    	}	    	
	    	var checkedChildren = $this.getGridCheckedSPChildren(grid);
	    	if(checkedChildren.length>0){	    		
	    		if(whetherPublishRec) {
	    			var formValues = Ext.encode(checkedChildren.map);
			    	var isSubmitted = false;

			    	Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');

			    	Ext.Ajax.request({
			    		type: 'rest',
			    		jsonData:formValues,
			    		url: SERVERURL.PATH_UNPUBLISH_STUDENT_ASSESSMENT_RECORDS,
			    		method: 'PUT',
			    		success: function(obj, action) {
			    			Ext.getBody().unmask();
			    			var grid = $this.getStudentassessmentreportgrid();
			    			grid.store.load();
			    			$this.uncheckGridHeader(grid);
			    			showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getCommonTranslation('SUCCESS'));
			    		}
			    	});
		    	 }else{
		    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD_WITH_SIMILAR_STATUS'));
		    	 }
	    		
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    	
	    },
	    getStudentReceipientIdsForSendingMessages : function(grid){
       		try{
       			var me = this;
       			if(portalId==2){
       				var sendMessageForm=me.getStudentassessmentsendmessagesform();
       				var formData = sendMessageForm.getValues();
       				var admissionId = formData.recipientFieldSASMName;
       				return admissionId;
       			}
       			else {
       			//	var examReportCommonController = Academia.app.getController('Academia.controller.examinationcenters.reports.ExamReportCommonController');
	        		var checkedChildren = me.getGridCheckedChildren(grid);
	        		if (grid.getChecked().length > 0) {
	        			var records = checkedChildren;
	        			var ids=[];
	        			if(grid.itemId == 'studentassessmentreportgridItemId'){
	        				Ext.each(records.admissionIds, function(admissionId){
	        					var isNotDuplicate = true;
	        					Ext.each(ids, function(id){
	        						if(admissionId == id) {
	        							isNotDuplicate = false;
	        						}
	        					});
	        					if (isNotDuplicate) {
	        						ids.push(admissionId);
	        					}
	        				})
	        			}
	        		}
	        		return ids;
       			}
       		}
       		catch(e){
       			console.log('');
       		}
    	},
    	
    	uncheckGridHeader: function(grid){
        	/*if(grid.getStore().getRootNode().childNodes.length>0){
        		//grid.down('#exportStudentAssessmentReportItemId').setDisabled(false);
        	}
        	else {
        		// grid.down('#exportStudentAssessmentReportItemId').setDisabled(true);
        	}*/
        	grid.columns[0].textEl.dom.children[0].checked = false; 
        	grid.getView().refresh();
        },
        
        /*selectParentNodesTreePanel: function(node, checked, headerClick){
     	   var me = this;
			   var parentNode = node.parentNode;
			   if(parentNode){
				   if(checked == false){
					   var childChecked = false;
					   if(parentNode.hasChildNodes()){
						   parentNode.cascadeBy(function(childNode) {
							   if(parentNode.data.treeNode !=childNode.data.treeNode){
								   if(childChecked == false){
									   childChecked = childNode.get('checked'); 
								   }
							   }
						   });
					   }
					   if(!childChecked){
						   if(parentNode.data.leaf != true){
							   parentNode.set('checked', false);
							   me.selectParentNodesTreePanel(parentNode, false, headerClick);
						   }
					   }
				   }else{
					   if(parentNode.data.leaf != true){
						   parentNode.set('checked', true);
						   me.selectParentNodesTreePanel(parentNode, true, headerClick);
					   }
				   }

			   }
			   
			   var grid = me.getStudentassessmentreportgrid();
			   var publishedCnt = 0;
			   var unPublishedCnt = 0;
			   var grid = me.getStudentassessmentreportgrid();
			   var unpublishBtn = grid.down('#unpublishItemId');
			   var checkedCount = grid.getChecked().length;
			   if(checkedCount){
				   grid.down('#publishStudentAssessmentReportItemId').setDisabled(false);
				   grid.down('#unpublishTheGradeBook').setDisabled(false);
				   grid.down('#sendMessageStudentAssessmentReportItemId').setDisabled(false);
				   //grid.down('#unpublishStudentAssessmentReportItemId').setDisabled(false);
				   grid.down('#exportStudentAssessmentGradeBookReportItemId').setDisabled(false);
				   grid.down('#studentCommentbtnDeleteId').setDisabled(false);
				   
				 //  grid.down('#exportStudentAssessmentReportItemId').setDisabled(false);
				   if(headerClick==false){
					   grid.columns[0].textEl.dom.children[0].checked = true;
				   }
				   if(node.hasChildNodes()){
					   node.cascadeBy(function(node) {
						   if(node.get('leaf') && node.get('whetherPublish')) {
							   publishedCnt = publishedCnt + 1;
						   }
						   else if(node.get('leaf') && !node.get('whetherPublish')) {
							   unPublishedCnt = unPublishedCnt + 1;
						   }
					   });
				   }
				   if(!unPublishedCnt && publishedCnt) {
					   unpublishBtn.enable();
				   }
				   else {
					   unpublishBtn.disable();
				   }
				   for(var i = 0; i < grid.getChecked().length; i++) {
                       if(grid.getChecked()[i].get('leaf') && !isNullOrEmpty(grid.getChecked()[i].get("whetherPublish")) && grid.getChecked()[i].get("whetherPublish")) {
                    	   publishedCnt = publishedCnt + 1;
                       }
                       else if(grid.getChecked()[i].get('leaf') && !grid.getChecked()[i].get('whetherPublish')) {
                    	   unPublishedCnt = unPublishedCnt + 1;
					   }
                   }
                   if(!unPublishedCnt && publishedCnt) {
                       unpublishBtn.enable();
                   }
                   else {
                       unpublishBtn.disable();
                   }
			   }
			   else {
				   grid.down('#publishStudentAssessmentReportItemId').setDisabled(true);
				   grid.down('#unpublishTheGradeBook').setDisabled(true);				
				   grid.down('#sendMessageStudentAssessmentReportItemId').setDisabled(true);
				   grid.down('#exportStudentAssessmentGradeBookReportItemId').setDisabled(true);
				   grid.down('#studentCommentbtnDeleteId').setDisabled(true);
				//   grid.down('#exportStudentAssessmentReportItemId').setDisabled(true);
				   grid.down('#unpublishItemId').setDisabled(true);
				   if(headerClick==false){
					   me.uncheckGridHeader(grid);
				   }
			   }
		   },*/
        selectParentNodesTreePanel: function(node, checked, headerClick, btnRefs, grid) {
            var me = this;

            function updateButtonState(checkedRec) {
                var publishedCnt = 0;
                var unPublishedCnt = 0;

                Ext.each(checkedRec, function(rec) {
                    var isLeaf = rec.get('leaf');
                    var whetherPublish = rec.get("whetherPublish");
                    if (isLeaf && whetherPublish) {
                        publishedCnt++;
                    } else if (isLeaf && !whetherPublish) {
                        unPublishedCnt++;
                    }
                });

                var hasChecked = checkedRec.length > 0;

                btnRefs.publishStudentAssessmentReportBtn.setDisabled(!hasChecked);
                btnRefs.unpublishGradeBookBtn.setDisabled(!hasChecked);
                btnRefs.sendMsgStudentAssessmentReportBtn.setDisabled(!hasChecked);
                btnRefs.exportStudentAssessmentGradeBookReportBtn.setDisabled(!hasChecked);
                btnRefs.studentCommentbtnDelete.setDisabled(!hasChecked);
                btnRefs.unpublishBtn.setDisabled(unPublishedCnt !== 0 || publishedCnt === 0);

                if (!headerClick) {
                    grid.columns[0].textEl.dom.children[0].checked = hasChecked;
                }
            }

            function handleNode(node, checked) {
                var parentNode = node.parentNode;
                if (parentNode) {
                    var childChecked = parentNode.childNodes.some(function(childNode) {
                        return childNode.get('checked');
                    });

                    if (!checked && !childChecked && parentNode.data.leaf !== true) {
                        parentNode.set('checked', false);
                        handleNode(parentNode, false);
                    } else if (checked && parentNode.data.leaf !== true) {
                        parentNode.set('checked', true);
                        handleNode(parentNode, true);
                    }
                }
            }

            handleNode(node, checked);
            updateButtonState(grid.getChecked());
        },
		   
		   openStudentAssessmentSendMessage:function(obj){
			    var $this=this;
      	    	var grid = this.getStudentassessmentreportgrid();
      	    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
      	    	if(grid.getChecked().length>0) {

      	    		var $this=this;
      	    		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
      	    	    var structure = Ext.widget('studentassessmentsendmessagesform',{
      	    			itemId:'studentAssessmentSendMessagesForm'
      	    		});
      	    		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
      	    		/**
      	    		 * This is to remove tab from content panel and open same tab again
      	    		 */
      	    		var getcontroller=this.getController('menu.CoreERPNavigationController');
      	    		var getTab=getcontroller.getTab(tabName);
      	    		if(getTab!=null){
      	    			contentPanel.remove(getTab, true);
      	    		}
      	    		var formWindowTab = $this.getStudentassessmentsendmessagesform();
      	    		formWindowTab.down("#selectTemplate").allowBlank=true;
      	    		formWindowTab.down("#selectTemplate").setVisible(false);
      	    		formWindowTab.down("#messageName").allowBlank=true;   
      	    		formWindowTab.down("#messageName").setVisible(false);
      	    		
      	    		try{
          	    		if(portalId==2){
          	    			var linkedField = formWindowTab.down('#recipientFieldSASMItemId');
          	    			
          	    			//var newStore = Ext.create('Academia.store.examinationcenters.reports.StudentAsseessmentReportStudentListStore');
          	    			//linkedField.bindStore('examinationcenters.reports.StudentAsseessmentReportStudentListStore');
          	    				linkedField.setVisible(false);
          	    				$this.setAllowBlank(linkedField, true);
          	    					//linkedField.bindStore(newStore);
		           	    			var admissionIds =$this.getGridCheckedChildren(grid).admissionIds;
		           	    			if(admissionIds.length){
		           	    				var uniqueAdmIds = admissionIds.filter(function(item, pos) {
		           	    				    return admissionIds.indexOf(item) == pos;
		           	    				});
		           	    				linkedField.setValue(uniqueAdmIds);
		           	    			}
		           	    			
		           	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
			           	    		templateStore.getProxy().extraParams={
			           	    			msgRecipientTypeId:8
			           	    		};
			           	    		templateStore.load();

			           	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			           	    		Ext.Ajax.request({
			           	    			method : "GET",
			           	    			type : 'rest',
			           	    			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=FacultyTemplatebe539740-692d-4ae1-bc17-338c4002874d',
			           	    			headers : {
			           	    				'Content-Type' : 'application/json'
			           	    			},
			           	    			success : function(form,action) {
			           	    				var data = Ext.JSON.decode(form.responseText);
			           	    				formWindowTab.down("#id").setValue(data.id);
			           	    				formWindowTab.down("#code").setValue(data.code);
			           	    				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
			           	    				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
			           	    				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
			           	    				Ext.getBody().unmask();

			           	    				//grid.getStore().reload();
			           	    				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
			           	    			}

			           	    		});
			           	    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
          	    			
          	    		}
          	    		else {
          	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
	           	    		templateStore.getProxy().extraParams={
	           	    			msgRecipientTypeId:8
	           	    		};
	           	    		templateStore.load();

	           	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	           	    		Ext.Ajax.request({
	           	    			method : "GET",
	           	    			type : 'rest',
	           	    			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=FacultyTemplatebe539740-692d-4ae1-bc17-338c4002874d',
	           	    			headers : {
	           	    				'Content-Type' : 'application/json'
	           	    			},
	           	    			success : function(form,action) {
	           	    				var data = Ext.JSON.decode(form.responseText);
	           	    				formWindowTab.down("#id").setValue(data.id);
	           	    				formWindowTab.down("#code").setValue(data.code);
	           	    				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
	           	    				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
	           	    				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
	           	    				Ext.getBody().unmask();

	           	    				//grid.getStore().reload();
	           	    				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
	           	    			}

	           	    		});
	           	    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
          	    		}
      	    		}
      	    		catch(e){
      	    			console.log('');
      	    		}
      	    		
      	    	} else {
      	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      	    	}
      	    },
      	    
      	  publishProgressionStatus:function(obj){
			    var $this=this;
			    var form=$this.getStudentassessmentreportfilter();
			    var periodId = form.down('#periodItemId').getValue();
    	    	var grid = this.getStudentassessmentreportgrid();
    	    	var checkedStudentId = $this.getGridCheckedChildren(grid);
    	    	var uniqueArray = Ext.Array.unique(checkedStudentId.studentIds);
               
    	    	if(uniqueArray.length == 0){
    	    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	    	}else{
    	    		
    	    		var studentIds = uniqueArray.toString();
        	    	        var submitValue={
        	    			    periodId:periodId,
        	    			    studentIds:studentIds,
        	    	            };
        	    	        
    	    		
    	    		 Ext.Ajax.request({
    	     	    	            type: 'rest',
    	     	    	            url: SERVERURL.PATH_PROGRESSION_STATUS,
    	     	    	            jsonData:submitValue,
    	     	    	            method : 'POST',
    	     	    	            success: function(f, action) {
    	     	    	                var data = f.responseText;
    	     	    	                if(data == "SUCCESS"){
    	     	    		showSuccessMessage(getCommonTranslation('CHANGE_PROGRESSION_STATUS'),getCommonTranslation('SUCCESS'));
    	     	    		grid.getStore().reload();
    	     	    		  grid.getSelectionModel().deselectAll();

    	     	    	        }else{
    	     	    	        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NOT_AVAILABLE'));
    	     	    	}
    	     	    	                
    	     	    	                           
    	     	    	            },
    	     	    	            failure: function(result, request) {
    	     	    	                showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); //Error occured while performing transaction
    	     	    	                return false;
    	     	    	            }
    	     	    	        });
    	    		
    	    	}
    	    	
    	    	       
    	    	
      	  },
     	    
     	   saveStaticDocumentFormMessage2 : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
      	    	var submitUrl = '';
      	    	var templateTab = this.getContentPanel();
      	        var formWin =  this.getStudentassessmentsendmessagesform();
      	    	var form = formWin.down('#msgDetailsForm');
      	    	var id = form.down('#document_hidden_field');
      	    	if (isNullOrEmpty(id.getSubmitValue())) {
      	    		submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
      	    	}
      	    	var data = new Object();
      	    	if(!isNullOrEmpty(entityId)){
      	    		data.entityId = entityId;
      	    	}else{
      	    		data.entityId = null;
      	    	}
      	    	if(!isNullOrEmpty(module)){
      	    		data.module = module;
      	    	}else{
      	    		data.module = null;
      	    	}
      	    	if(!isNullOrEmpty(entityType)){
      	    		data.entityType = entityType;
      	    	}else{
      	    		data.entityType = null;
      	    	}
      	    	form.getForm().setValues(data);
      	    	form.getForm().submit({
      	    		method : 'POST',
      	    		url : submitUrl,
      	    		success : function(form, action){
      	    			callBackFunction(true, action, isTransient);

      	    		}
      	    	});
      	    },
      	    
      	  visibleExamStudentAssessmentReportPivileges: function(grid, permissionsMap) {
       	   var associatedAcadLocationIds = new Array();
       	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
       	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       	   
       	   var publishStudentAssessmentReport = grid.down('#publishStudentAssessmentReportItemId');
       	   var sendMessageStudentAssessmentReport = grid.down('#sendMessageStudentAssessmentReportItemId');
       	   var exportStudentAssessmentGradeReport = grid.down('#exportStudentAssessmentGradeBookReportItemId');
       	   var exportStudentAssessmentReportItemId= grid.down('#exportStudentAssessmentReportItemId');
       	   var studentCommentbtnDeleteId= grid.down('#studentCommentbtnDeleteId');
       	   var unpublishTheGradeBook= grid.down('#unpublishTheGradeBook');
       	   var publishProgressionStatusBtn= grid.down('#publishProgressionStatus');
        	 var unpublishResult= grid.down('#unpublishItemId');
       	   publishStudentAssessmentReport.setVisible(false);
       	   sendMessageStudentAssessmentReport.setVisible(false);
       	   exportStudentAssessmentGradeReport.setVisible(false);
       	   exportStudentAssessmentReportItemId.setVisible(false);
       	   studentCommentbtnDeleteId.setVisible(false);
       	   unpublishTheGradeBook.setVisible(false);
           publishProgressionStatusBtn.setVisible(false);
           unpublishResult.setVisible(false);
       	   Ext.each(permissionList, function(privilege) {
       		   if (privilege === 'PUBLISH') {
       			   if(!isNullOrEmpty(publishStudentAssessmentReport)){
       				   publishStudentAssessmentReport.setVisible(true);	
       			   }
       		   }
       		   if (privilege === 'SENDMESSAGE') {
       			   if(!isNullOrEmpty(sendMessageStudentAssessmentReport)){
       				   sendMessageStudentAssessmentReport.setVisible(true);	
       			   }
       		   }
       		   if (privilege === 'EXPORT_GRADE_BOOK') {
       			   if(!isNullOrEmpty(exportStudentAssessmentGradeReport)){
       				   exportStudentAssessmentGradeReport.setVisible(true);	
       			   }
       		   }
       		   if (privilege === 'EXPORT_REPORTS') {
       			   if(!isNullOrEmpty(exportStudentAssessmentReportItemId)){
						/* for V2D-400783
       				   exportStudentAssessmentReportItemId.setVisible(true);	
						*/
       			   }
       		   }
       		   if (privilege === 'DELETE') {
    			   if(!isNullOrEmpty(exportStudentAssessmentReportItemId)){
    				   studentCommentbtnDeleteId.setVisible(true);	
    			   }
    		   } if (privilege === 'UNPUBLISH_GRADE_BOOK') {
    			   if(!isNullOrEmpty(unpublishTheGradeBook)){
    				   unpublishTheGradeBook.setVisible(true);	
    			   }
    		   }
    		   if (privilege === 'PUBLISH_PROGRESSION_STATUS') {
    			   if(!isNullOrEmpty(publishProgressionStatusBtn)){
    				   publishProgressionStatusBtn.setVisible(true);	
    			   }
    		   }
    		   if (privilege === 'UNPUBLISH_RESULT') {
    			   if(!isNullOrEmpty(unpublishResult)){
    				   unpublishResult.setVisible(true);	
    			   }
    		   }
				if ((portalId==2) && (privilege === 'UNPUBLISH')) {  
    			   if(!isNullOrEmpty(unpublishResult)){
    				   unpublishResult.setVisible(true);	
    			   }
    		   }
       	   });
          },
          
          getGridCheckedChildren: function(grid, counterNeeded){
     	    	var allChecked = grid.getChecked();
     	    	var returnArray = [];
     	    	var examResultIds = [];
     	    	var studentEventRemark = [];
     	    	var isStudentRemarkSubmitted = false;
     	    	var isCommentNull = false;
     	    	var studentIds = [];
     	    	var admissionIds = [];
     	    	var programGroupName = [];
     	    	var batchStartDate=[];
     	    	var batchEndDate=[];
     	    	var counter = [];
     	    	var studentCodes = [];
     	    	Ext.each(allChecked, function(currentRecord){
     	    		if(Ext.isDefined(currentRecord.get('leaf')) && currentRecord.get('leaf')==true){
     	    			examResultIds.push(currentRecord.get('examResultId'));
     	    			studentEventRemark.push(currentRecord.get('studentEventRemark'));
     	    			studentIds.push(parseInt(currentRecord.get('studentId')));
     	    			admissionIds.push(parseInt(currentRecord.get('admissionId')));
     	    			if(currentRecord.get('studentRemarkSubmitted')){
     	    				isStudentRemarkSubmitted = true;
     	    			}
     	    			if(isNullOrEmpty(currentRecord.get('studentEventRemark'))){
     	    				isCommentNull = true;
     	    			}
     	    			programGroupName.push(currentRecord.get('programGroupName'));
     	    			batchStartDate.push(currentRecord.raw.batchStartDate);
     	    			batchEndDate.push(currentRecord.raw.batchEndDate);
     	    			if(counterNeeded) {
     	    				//counter.push(currentRecord.get('counter'));
     	    				if(currentRecord.get('status') == 'Hold For Student' && studentCodes.indexOf(currentRecord.get('studentCode')) == -1) {
     	    					studentCodes.push(currentRecord.get('studentCode'));
     	    					counter.push(currentRecord.get('studentCode'));
     	    				}
     	    			}
     	    		}
     	    	});
     	    	returnArray = {
     	    			'examResultIds':examResultIds,
     	    			'studentEventRemark':studentEventRemark,
     	    			'isStudentRemarkSubmitted':isStudentRemarkSubmitted,
     	    			'isCommentNull':isCommentNull,
     	    			'studentIds':studentIds,
     	    			'admissionIds':admissionIds,
     	    			'programGroupName':programGroupName,
     	    			'batchStartDate':batchStartDate,
     	    			'batchEndDate':batchEndDate
     	    	};
     	    	if(counterNeeded) {
     	    		returnArray['counter'] = counter;
     	    	}
     	    	return returnArray;
     	    },
     	    
     	    getGridAllChildren: function(grid){
     	    	var returnArray = [];
     	    	var examResultIds = [];
     	    	var admissionIds = [];
     	    	grid.getRootNode().cascadeBy(function(currentRecord) {
     	    		if(currentRecord.isLeaf()){
     	    			examResultIds.push(currentRecord.get('examResultId'));
     	    			admissionIds.push(currentRecord.get('admissionId'));
     	    			
     	    		}
     	    	});
     	    	return returnArray = {
     	    		'examResultIds':examResultIds,
     	    		'admissionIds':admissionIds
     	    	};
     	    },
     	    
     	    getGridCheckedSPChildren: function(grid){
     	    	var allChecked = grid.getChecked();
     	    	var returnArray = [];
     	    	var examResultIds = [];
     	    	var studentEventRemark = [];
     	    	var modifiedRecords = new Ext.util.HashMap();
     	    	Ext.each(allChecked, function(currentRecord){
     	    		if(Ext.isDefined(currentRecord.get('leaf')) && currentRecord.get('leaf')==true){
     	    			modifiedRecords.add(parseInt(currentRecord.get('examResultId')),currentRecord.get('studentEventRemark'));
     	    		}
     	    	});
     	    /*	var currentRecord = new Ext.util.HashMap();
     	    	Ext.each(allChecked, function(currentRecord){
     	    		if(Ext.isDefined(currentRecord.get('leaf')) && currentRecord.get('leaf')==true){
     	    			DocumentPublishDate.add(currentRecord.get('admissionId')+"_"+currentRecord.get("periodId")+"_"+currentRecord.get('ReportType')
     	    					+"_"+currentRecord.get("levelName"),currentRecord.get("documentPublishDate"));
     	    		}	
     	    	});*/
     	    	return modifiedRecords;
     	    },
     	    
     	   removeDuplicatesFromArrays:function (documentPublishDate) {
        	   if (!Array.isArray(documentPublishDate)) {
        		   return undefined;
        	   }
        	   var uniqueArray = documentPublishDate.filter(function(elem, pos) {
        		   return documentPublishDate.indexOf(elem) === pos;
        	   });
        	   return uniqueArray;
           },
           
           openERPStudentCommentWindow: function(record,rowIndex){
           	var me = this;
           	var win = me.getStudentassessmenterpcommentwin();
       		if(!win){
       			win = Ext.widget('studentassessmenterpcommentwin');
       		}
       		win.show();
       		currentEditRecord = record;
           	win.down('#stCommentRowIndex').setValue(rowIndex);
           	win.down('#stCommentExamResultId').setValue(record.get('examResultId'));
           	win.down('#studentComment').setValue(record.get('studentEventRemark'));
           	
           	/*examResultId
           	studentComment*/
           },
           unPublishStudentAssessmentReportEvent:function(obj){
   	    	var $this=this;
   	    	var grid = $this.getStudentassessmentreportgrid();
   	    	var gridRecord=grid.getChecked();
   	    	var checkedChildren = $this.getGridCheckedSPChildren(grid);
   	    	var formValues = Ext.encode(checkedChildren.map);
   	    	//var examResultIdsArray = checkedRecords.examResultIds;
   	    	//var studentEventRemarksArray = checkedRecords.studentEventRemark;
   	    	var isSubmitted = false;

   	    	Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');

   	    	Ext.Ajax.request({
   	    		type: 'rest',
   	    		jsonData:formValues,
   	    		url: SERVERURL.PATH_UNPUBLISH_STUDENT_ASSESSMENT_REPORT,
   	    		method: 'PUT',
   	    		success: function(obj, action) {
   	    			Ext.getBody().unmask();
   	    			var grid = $this.getStudentassessmentreportgrid();
   	    			grid.store.load();
   	    			$this.uncheckGridHeader(grid);
   	    			showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getCommonTranslation('SUCCESS'));
   	    		}
   	    	});
   	    },
   	 loadGridWithFileNameMessage:function(grid,value,store){
  	   grid.bindStore(store);
  	   grid.getView().refresh();
     },
     
     unpublishResultForStudentAssessmentReport: function(btn) {
    	 var $this=this;
    	 var form=$this.getStudentassessmentreportfilter().getForm();
    	 var evalLevelNameFile=$this.getStudentassessmentreportfilter().down('#evalLevelName');
    	 var formValues=form.getValues();
    	 var evaluationPlanLevelName=[];
    	 var evaluationLevelNameString = null;
    	 if(!isNullOrEmpty(formValues.evalLevelName) && formValues.evalLevelName!=""){
    		 for(var i=0;i<formValues.evalLevelName.length;i++){
    			 var value=formValues.evalLevelName[i].data.value;
    			 evaluationPlanLevelName.push(value);
    			 evaluationLevelNameString = value
    		 }
    	 }
    	 var grid = $this.getStudentassessmentreportgrid();
    	 var gridRecord=grid.getChecked();
    	 
        var whetherPublishRec = true;
    	 var checkedChildren = $this.getGridCheckedSPChildren(grid);
    	 if(checkedChildren.length>0){	    		
    		 if(whetherPublishRec) {
    			 var formValues = Ext.encode(checkedChildren.map);
    			 var isSubmitted = false;
    			 Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
    			 Ext.Ajax.request({
    				 type: 'rest',
    				 jsonData:formValues,
    				 url: SERVERURL.PATH_UNPUBLISH_STUDENT_ASSESSMENT_RECORDS_LIST,
    				 method: 'PUT',
    				 success: function(obj, action) {
    					 Ext.getBody().unmask();
    					 var grid = $this.getStudentassessmentreportgrid();
    					 grid.store.load();
    					 $this.uncheckGridHeader(grid);
    					 showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getExaminationTranslation('RESULT_UNPUBLISHED_SUCCESS'));
    				 }
    			 });
    		 }else{
    			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD_WITH_SIMILAR_STATUS'));
    		 }

    	 } else {
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	 }
     },
     selectStudentAssessmentMessageType: function(val,nV,oV){
    	 var $this =  this;
    	 var formWin = $this.getStudentassessmentsendmessagesform();

    	 //var value = nV.1;
    	 if(nV.messageType==2){
    		 formWin.down("#messageId").hide();
    		 formWin.down("#selectTemplate").allowBlank=true;
    		 formWin.down("#selectTemplate").setVisible(false);     		 
    		 formWin.down("#messageName").allowBlank=true;   
    		 formWin.down("#messageName").setVisible(false);
    		 formWin.down("#msgTempletId").setVisible(true);
    		 formWin.down("#msgTempletId").allowBlank=false;
    		 formWin.down("#msgTempletId").reset();
    		 formWin.down("#subject").setVisible(true);
    		 formWin.down("#subject").allowBlank=false;
    		 formWin.down("#subject").reset();
    		 formWin.down("#discriptionId").setVisible(true);
    		 formWin.down("#discriptionId").reset();
    		 formWin.down('#smsDiscription').reset();
    		 formWin.down('#smsDiscription').hide();
    		 formWin.down('#smsDiscriptionNotice').hide();
    		 formWin.down('#pushNotificationDiscription').hide();
    		 formWin.down('#pushNotificationDiscriptionNotice').hide();
    	 }else{
    		 formWin.down("#msgTempletId").allowBlank=true;
    		 formWin.down("#msgTempletId").setVisible(false);     		
    		 formWin.down("#messageId").setVisible(true);
    		 formWin.down("#selectTemplate").setVisible(true);     		
    		 formWin.down("#messageName").setVisible(true);
    		 formWin.down("#messageName").reset();
    		 formWin.down("#subject").allowBlank=true;
    		 formWin.down("#subject").setVisible(false);
    		 formWin.down("#discriptionId").setVisible(false);
    		 formWin.down("#messageName").allowBlank=false;  
    		 formWin.down("#selectTemplate").allowBlank=false;
    		 formWin.down("#selectTemplate").reset();
    		 formWin.down("#facultyDocumentMessageAttachmentGrid").setVisible(false);
    		 formWin.down("#staticUploadFileField").setVisible(false);
    		 formWin.down('#smsDiscription').reset();
    		 formWin.down('#smsDiscription').hide();
    		 formWin.down('#smsDiscriptionNotice').hide();
    		 var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
    		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
    		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
    		 formWin.down('#pushNotificationDiscription').hide();
    		 formWin.down('#pushNotificationDiscriptionNotice').hide();
    	 }
    	 formWin.getForm().checkValidity();
     },
     publishGradeBook: function() {
    	 var $this = this;
		 var grid = $this.getStudentassessmentreportgrid();
    	 var form=$this.getStudentassessmentreportfilter().getForm();
    	 var gridRecord=grid.getChecked();
    	 var checkedChildren = $this.getGridCheckedChildren(grid);
    	 // code to identify jasper
    	 var examResultIds = checkedChildren.examResultIds;
    	 var studentassessmentreportwin = $this.getStudentassessmentreportwin();
    	 var publishDatee = studentassessmentreportwin.down('#publishDateItemId').getValue();
    	 var reportType = studentassessmentreportwin.down('#chooseHallticketTemplate');
    	 var templateId = reportType.getValue();//"CourseWiseMarksheetReport"; //Enum value put here
    	 var reportParams =new Object();
    	 var publishDate = null;
    	 if(publishDatee != null){
    		 publishDate = Ext.Date.format(new Date(publishDatee), 'Y-m-d');
    	 }
    	 var formValues=form.getValues();

    	 var evaluationPlanLevelName=[];
    	 var evaluationLevelNameString = null;

    	 /*if(!isNullOrEmpty(formValues.evalLevelName) && formValues.evalLevelName!=""){
 for(var i=0;i<formValues.evalLevelName.length;i++){
	   var value=formValues.evalLevelName[i].data.value;
	   evaluationPlanLevelName.push(value);
  evaluationLevelNameString = value
 }
}*/
    	 var sectionId = grid.sectionId;
    	 var levelValue = grid.levelName;

    	 var reportTitle="";

    	 var zipFileName = reportType.getRawValue();
    	 var code = reportType.getRawValue();

    	 var formValues=form.getValues();

    	 var evaluationPlanLevelName=[];
    	 var evaluationLevelNameString = null;

    	 if(!isNullOrEmpty(formValues.evalLevelName) && formValues.evalLevelName!=""){
    		 for(var i=0;i<formValues.evalLevelName.length;i++){
    			 var item = formValues.evalLevelName[i];
    			 var value = (item && item.data && item.data.value != null) ? item.data.value : item;
    			 evaluationPlanLevelName.push(value);
    			 evaluationLevelNameString = value
    		 }
    	 }
    	 reportParams.examResultIds=examResultIds.join();
    	 reportParams.zipFileName=zipFileName;
    	 reportParams.reportTemplateId=templateId;
    	 reportParams.evaluationLevelName=evaluationPlanLevelName.join();
    	 reportParams.whetherPublish=true;
    	 reportParams.publishDate=publishDate;

    	 if(code=='SIS Assessment Report P3-P6 PDF'||code=='SIS Assessment Report S1-S4 PDF'){
    		 studentassessmentreportwin.close();
    		 $this.exportJRXMLReport(code, reportParams, code,'.pdf', SERVERURL.PATH_DOWNLOAD_ALL_PDF_ZIP);
    	 }else{
    		 studentassessmentreportwin.close();
    		 $this.exportJRXMLReport(code, reportParams, code,'.vnd.ms-excel', SERVERURL.PATH_DOWNLOAD_ALL_EXCEL_ZIP);
    	 }
     }
});