Ext.define('Academia.controller.facultyportal.attendance.FacultyStudentAttendanceReportController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['attendance.UpdateAttendanceModel'],
	stores : ['common.AcademicTermStore',
		'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
		'attendance.facultyportal.AttendanceProgramStore',
		'attendance.FacultyAttendanceReportTreeStore',
		'attendance.StudentAttendanceStatusStore',
		'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore',
		'attendance.facultyportal.AttendanceCourseVariantStore',
		'attendance.facultyportal.CompleteDayAttendanceReportStore',
		'attendance.facultyportal.CourseLevelAttendanceReportStore'
		],
		views : ['facultyPortal.attendance.StudentAttendanceReportStructureForFaculty',
			'facultyPortal.attendance.CompleteDayStudentAttendanceSearch',
			'facultyPortal.attendance.SessionWiseStudentAttendanceSearch',
			'facultyPortal.attendance.CourseLevelStudentAttendanceSearch',
			'facultyPortal.attendance.StudentAttendanceReportGridForFaculty',
			'facultyPortal.attendance.OpenUpdateAttendanceStatusWindow',
			'facultyPortal.attendance.StudentCourseAttendanceReportGridForFaculty'
			],
			config: {
				FACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PRIVILEGES'),
			},
			refs : [{
				ref : 'studentattendancereportstructureforfaculty',
				selector : 'studentattendancereportstructureforfaculty'
			},{
				ref : 'completedaystudentattendancesearch',
				selector : 'completedaystudentattendancesearch'
			},{
				ref : 'sessionwisestudentattendancesearch',
				selector : 'sessionwisestudentattendancesearch'
			},{
				ref : 'courselevelstudentattendancesearch',
				selector : 'courselevelstudentattendancesearch'
			},{
				ref : 'studentattendancereportgridforfaculty',
				selector : 'studentattendancereportgridforfaculty'
			},{
				ref : 'openupdateattendancestatuswindow',
				selector : 'openupdateattendancestatuswindow'
			},{
				ref : 'studentcourseattendancereportgridforfaculty',
				selector : 'studentcourseattendancereportgridforfaculty'
			}],

			init : function() {
				this.control({
					'studentattendancereportstructureforfaculty': {
						render: function(obj){
							var me = this;
							var grid = obj.down('studentattendancereportgridforfaculty');
							var $this=this;
							if(!isNullOrEmpty($this.getStudentattendancereportgridforfaculty())){
								$this.getStudentattendancereportgridforfaculty().getStore().removeAll(); 
								try{
									$this.getStudentattendancereportgridforfaculty().down('custompagingtoolbar').hide()
								}catch(e){
								}
							}
							var form =this.getStudentattendancereportstructureforfaculty();
							var attendanceTypeRadio=form.down('#attendanceTypeRadioFieldId');
							var permissionsMap = new Ext.util.HashMap();
							permissionsMap=this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION();
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
							var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

							var studentAttendanceType = [];
							var attendanceType=[];
							var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
							if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY) && attendanceTypess.data.COMPLETE_DAY.academyLocationId == academyLocationId) {
								attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
							} else {
								var authenticationController = Academia.app.getController('Academia.controller.authentication.AuthenticationController');
								authenticationController.loadMultipleLangFilePerAL(this.getCurrentAcademyLocation());
								attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
								if(!isNullOrEmpty(attendanceTypess.data.COMPLETE_DAY)) {
									attendanceType.push(attendanceTypess.data.COMPLETE_DAY.studentAttendanceType);
								}
							}
							if(!isNullOrEmpty(attendanceTypess.data.MULTIPLE_SESSION)) {
								attendanceType.push(attendanceTypess.data.MULTIPLE_SESSION.studentAttendanceType);
							}
							if(!isNullOrEmpty(attendanceTypess.data.COURSE_LEVEL)) {
								attendanceType.push(attendanceTypess.data.COURSE_LEVEL.studentAttendanceType);
							}

							if(attendanceType.length > 0){
								studentAttendanceType=attendanceType.join();
							} else {
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
							}


							//--setting initial values to false
							var tab2=false, tab3=false,tab4=false;

							//--initially setting all radio fields to true
							var completeDayRadio = form.down('[inputValue=COMPLETE_DAY]');
							var courseLevelRadio = form.down('[inputValue=COURSE_LEVEL]');
							var multipleSessionRadio = form.down('[inputValue=MULTIPLE_SESSION]');
							attendanceTypeRadio.items.items[0].setVisible(true);
							attendanceTypeRadio.items.items[1].setVisible(true);
							attendanceTypeRadio.items.items[2].setVisible(true);

							//--checking for the visible tabs
							if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
								tab2=true;
							}
							if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
								tab3=true;
							}
							if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
								tab4=true;
							}

							if(!tab2 && !tab3 && !tab4){
								tab2=true;
							}

							if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
								attendanceTypeRadio.setVisible(false);
							}
							else {
								attendanceTypeRadio.setVisible(true);
							}

							//-- setting values to true/false on the basis of visible tabs
							if(!tab2){
								attendanceTypeRadio.items.items[0].setVisible(false);
							}
							if(!tab3){
								attendanceTypeRadio.items.items[1].setVisible(false);
							}
							if(!tab4){
								attendanceTypeRadio.items.items[2].setVisible(false);
							}

							//-- setting radioGroup value on the basis of visible tabs
							setTimeout(function(){
								if(tab2){
									completeDayRadio.setValue(true);
								}
								else if(tab3){
									courseLevelRadio.setValue(true);
								}
								else if(tab4){
									multipleSessionRadio.setValue(true);
								}
							},300);
							Ext.defer(function() {
								var attendanceType=me.getStudentattendancereportstructureforfaculty().down('#attendanceTypeRadioFieldId').getValue().attendanceTypeWise;
							},1000);
						}
					},
					'studentattendancereportstructureforfaculty radiogroup[itemId=attendanceTypeRadioFieldId]':{
						change : function(obj,record){
							this.onChangeAttedanceType(obj,record); 
						}
					},
					'completedaystudentattendancesearch customcombobox[itemId=completeDayAcademicTermId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var academicTermId = obj.value;
							if(academicTermId > 0) {
								this.academicTermChange(form,academicTermId);
							}
						}
					},
					'completedaystudentattendancesearch customcombobox[itemId=completeDayStudentName_Id]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var studentId = obj.value;
							if(studentId > 0) {
								this.studentIdChange(form,studentId);
							}
						}
					},
					'completedaystudentattendancesearch customcombobox[itemId=completeDayProgramGroupItemId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var programGroupId = obj.value;
							if(programGroupId > 0) {
								this.programGroupChange(form,programGroupId);
							}
						}
					},
					'completedaystudentattendancesearch button[itemId=completeDaySearchBtn]' :{
						click : function(obj, record){
							var me = this;
							var attendancesearchstrucure =  me.getStudentattendancereportstructureforfaculty();
							var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
							this.loadStudentAttendanceReportForCompleteDay(attendanceType);
						}
					},
					'completedaystudentattendancesearch button[itemId=completeDayResetBtn]':{
						click : function(obj,record){
							var me = this;
							var form = obj.up('form');
							this.resetCompleteDaySearchForm(form);

						}
					},
					'studentattendancereportgridforfaculty':{
						afterrender : function(){
							var grid = this.getStudentattendancereportgridforfaculty();
							this.doAccessControlValidation(grid, this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
							this.disableMoreActionAttendancePivileges(grid, this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
						}
					},
					'studentattendancereportgridforfaculty button[itemId=btnDeleteStudentAttendance]':{
						click: this.deleteStudentAttendanceRecord
					},
					'studentattendancereportgridforfaculty button[itemId=btnUpdateAttendance]':{
						click: this.openEditStudentAttendanceWindow
					},
					'studentcourseattendancereportgridforfaculty':{
						afterrender : function(){
							var grid = this.getStudentcourseattendancereportgridforfaculty();
							this.doAccessControlValidation(grid, this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
							this.disableMoreActionAttendancePivileges(grid, this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
						}
					},
					'studentcourseattendancereportgridforfaculty button[itemId=btnDeleteStudentAttendance]':{
						click: this.deleteStudentAttendanceRecord
					},
					'studentcourseattendancereportgridforfaculty button[itemId=btnUpdateAttendance]':{
						click: this.openEditStudentAttendanceWindow
					},
					'openupdateattendancestatuswindow button[itemId=submitBtn]':{
						click: this.bulkUpdateStudentAttendanceStatus
					},
					'openupdateattendancestatuswindow button[itemId=cancelBtn]':{
						click : function(){
							this.getOpenupdateattendancestatuswindow().close();
						}
					},
					'courselevelstudentattendancesearch customcombobox[itemId=courseLevelAcademicTermId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var academicTermId = obj.value;
							if(academicTermId > 0) {
								this.academicTermChangeForCourseLevel(form,academicTermId);
							}
						}
					},
					'courselevelstudentattendancesearch customcombobox[itemId=courseLevelStudentId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var studentId = obj.value;
							if(studentId > 0) {
								this.studentIdChangeForCourseLevel(form,studentId);
							}
						}
					},
					'courselevelstudentattendancesearch customcombobox[itemId=courseLevelCourseVariantId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var courseVariantId = obj.getValue();
							if(courseVariantId > 0) {
								//this.courseVariantIdChangeForCourseLevel(form,courseVariantId);
							}
						}
					},
					'courselevelstudentattendancesearch button[itemId=courseLevelSearchBtn]' :{
						click : function(obj, record){
							var me = this;
							var attendancesearchstrucure =  me.getStudentattendancereportstructureforfaculty();
							var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
							this.loadStudentAttendanceReportForCourseLevel(attendanceType);
						}
					},
					'courselevelstudentattendancesearch button[itemId=courseLevelResetBtn]':{
						click : function(obj,record){
							var me = this;
							var form = obj.up('form');
							this.resetCourseLevelSearchForm(form);

						}
					},
					'sessionwisestudentattendancesearch customcombobox[itemId=sessionWiseAcademicTermId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var academicTermId = obj.getValue();
							if(academicTermId > 0) {
								this.academicTermChangeForSessionWise(form,academicTermId);
							}
						}
					},
					'sessionwisestudentattendancesearch customcombobox[itemId=sessionWiseStudentId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var studentId = obj.getValue();
							if(studentId > 0) {
								this.studentIdChangeForSessionWise(form,studentId);
							}
						}
					},
					'sessionwisestudentattendancesearch customcombobox[itemId=sessionWiseProgramGroupId]' :{
						change : function(obj, record){
							var me = this;
							var form = obj.up('form');
							var programGroupId = obj.getValue();
							if(programGroupId > 0) {
								this.programGroupChangeForSessionWise(form,programGroupId);
							}
						}
					},
					'sessionwisestudentattendancesearch button[itemId=sessionWiseSearchBtn]' :{
						click : function(obj, record){
							var me = this;
							var attendancesearchstrucure =  me.getStudentattendancereportstructureforfaculty();
							var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
							this.loadStudentAttendanceReportForSessionWise(attendanceType);
						}
					},
					'sessionwisestudentattendancesearch button[itemId=sessionWiseResetBtn]':{
						click : function(obj,record){
							var me = this;
							var form = obj.up('form');
							this.resetSessionWiseSearchForm(form);
						}
					} 
				});
			},
			onChangeAttedanceType:function(obj,record){
				var $this = this;
				var academyLocationId = this.getCurrentAcademyLocation();
				var attendanceType = record.studentAttendanceTypeWise;
				var programWiseSearch = this.getCompletedaystudentattendancesearch();
				var courseWiseSearch = this.getCourselevelstudentattendancesearch();
				var sessionWiseSearch = this.getSessionwisestudentattendancesearch();
				var programGrid = this.getStudentattendancereportgridforfaculty();
				var courseGrid = this.getStudentcourseattendancereportgridforfaculty()
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				if(attendanceType == 'Complete Day' || attendanceType == 'COMPLETE_DAY'){
					programGrid.setVisible(true);
					courseGrid.setVisible(false);
					programGrid.getStore().removeAll();
					try{
						programGrid.down('custompagingtoolbar').hide();
					}catch(e){
					}
					if(wheatherSchool){
						programGrid.columns[9].setVisible(false);
					 } else {
						 programGrid.columns[9].setVisible(true);
					 }
					programGrid.columns[12].setVisible(false);
					programWiseSearch.setVisible(true);
					sessionWiseSearch.setVisible(false);
					courseWiseSearch.setVisible(false);
					var data=attendanceTypess.data.COMPLETE_DAY;
					programWiseSearch.down('#completeStudentStatusId').setValue(true);
					if(wheatherSchool) {
						programWiseSearch.down("#completeDayAttendanceProgramId").setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
					} else {
						programWiseSearch.down("#completeDayAttendanceProgramId").setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
					}
					var academicTerm = programWiseSearch.down('#completeDayAcademicTermId');
					var studentField = programWiseSearch.down('#completeDayStudentName_Id');
					var programGroupField = programWiseSearch.down('#completeDayProgramGroupItemId');
					var programBatchPeriodFeild = programWiseSearch.down('#completeDayAttendanceProgramId');

					academicTerm.reset();
					studentField.reset();
					programGroupField.reset();
					programBatchPeriodFeild.reset();

					var academicTermStore = academicTerm.getStore();
					var academicTermIdNew = null;
					academicTermStore.load({
						callback: function(records, operation, success) {
							for(var i in records) {
								if(records[i].get('sequence') == 1) {
									academicTermIdNew = records[i].get('id');
									academicTerm.setValue(academicTermIdNew);
									
								}
							}
						}
					});

					var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
					var studentStore = studentField.getStore();
					studentStore.getProxy().api.read=submitURL;
					studentStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						facultyId : facultyId,
						academicTermId:academicTermIdNew
					};
					studentStore.load();

					var programGroupStore = programGroupField.getStore();
					programGroupStore.getProxy().extraParams = {
						academyLocationId:academyLocationId,
						facultyId:facultyId,
						academicTermId:academicTermIdNew
					};

					programGroupStore.load();

					var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
					programByAcademyLocationStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:false,
						wheatherSchool:wheatherSchool,
						academicTermId:academicTermIdNew
					};
					programByAcademyLocationStore.load();
				} else if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL') {
					programGrid.setVisible(false);
					courseGrid.setVisible(true);
					courseGrid.getStore().removeAll();
					try{
						courseGrid.down('custompagingtoolbar').hide();
					}catch(e){
					}
					programWiseSearch.setVisible(false);
					sessionWiseSearch.setVisible(false);
					courseWiseSearch.setVisible(true);
					courseWiseSearch.down('#courseLevelStudentStatusId').setValue(true);
					var data=attendanceTypess.data.COURSE_LEVEL;
					var timeTablePlanningFlag = data.timeTablePlanningFlag;
					var date = new Date();
					var academicTerm = courseWiseSearch.down('#courseLevelAcademicTermId');
					var studentField = courseWiseSearch.down('#courseLevelStudentId');
					var courseVariantFeild = courseWiseSearch.down('#courseLevelCourseVariantId');

					academicTerm.reset();
					studentField.reset();
					courseVariantFeild.reset();

					var academicTermStore = academicTerm.getStore();
					academicTermStore.load({
						callback: function(records, operation, success) {
							for(var i in records) {
								if(records[i].get('sequence') == 1) {
									academicTermIdNew = records[i].get('id');
									academicTerm.setValue(academicTermIdNew);
									
								}
							}
						}
					});

					var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
					var studentStore = studentField.getStore();
					studentStore.getProxy().api.read=submitURL;
					studentStore.getProxy().extraParams = {
						academyLocationIds: academyLocationId,
						facultyId: facultyId
					};
					studentStore.load();

					var courseVariantStore = courseVariantFeild.getStore();
					courseVariantStore.getProxy().extraParams = {
						academyLocationIds: academyLocationId,
						facultyId: facultyId,
						isCurrentPeriod:false
					};
					courseVariantStore.load();

				} else if(attendanceType == 'Multiple Session' || attendanceType == 'MULTIPLE_SESSION') {
					programGrid.setVisible(true);
					courseGrid.setVisible(false);
					programGrid.getStore().removeAll();
					try{
						programGrid.down('custompagingtoolbar').hide();
					}catch(e){
					}
					if(wheatherSchool){
						programGrid.columns[9].setVisible(false);
					 } else {
						 programGrid.columns[9].setVisible(true);
					 }
					programGrid.columns[12].setVisible(true);
					programWiseSearch.setVisible(false);
					sessionWiseSearch.setVisible(true);
					courseWiseSearch.setVisible(false);
					sessionWiseSearch.down('#sessionwiseStudentStatusId').setValue(true);
					if(wheatherSchool) {
						sessionWiseSearch.down("#sessionWiseAttendanceProgramId").setFieldLabel(getCourseTxCommonTranslation('ATTENDANCE_PROGRAM_BATCH_SECTION'))
					} else {
						sessionWiseSearch.down("#sessionWiseAttendanceProgramId").setFieldLabel(getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'))
					}
					var academicTerm = sessionWiseSearch.down('#sessionWiseAcademicTermId');
					var studentField = sessionWiseSearch.down('#sessionWiseStudentId');
					var programGroupField = sessionWiseSearch.down('#sessionWiseProgramGroupId');
					var programBatchPeriodFeild = sessionWiseSearch.down('#sessionWiseAttendanceProgramId');

					academicTerm.reset();
					studentField.reset();
					programGroupField.reset();
					programBatchPeriodFeild.reset();

					var academicTermStore = academicTerm.getStore();
					academicTermStore.load({
						callback: function(records, operation, success) {
							for(var i in records) {
								if(records[i].get('sequence') == 1) {
									academicTermIdNew = records[i].get('id');
									academicTerm.setValue(academicTermIdNew);
									
								}
							}
						}
					});

					var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
					var studentStore = studentField.getStore();
					studentStore.getProxy().api.read=submitURL;
					studentStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						facultyId : facultyId
					};
					studentStore.load();

					var programGroupStore = programGroupField.getStore();
					programGroupStore.getProxy().extraParams = {
						academyLocationId:academyLocationId,
						facultyId : facultyId
					};
					programGroupStore.load();

					var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
					programByAcademyLocationStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						facultyId:facultyId,
						onlyCurrentRecords:false,
						wheatherSchool:wheatherSchool
					};
					programByAcademyLocationStore.load();
					
					var sessionItemId=sessionWiseSearch.down('#sessionWiseSessionItemId');
					sessionItemId.reset();
					var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
					var sessionNumber=attendanceTypess.data.MULTIPLE_SESSION.sessionNo;
					var storeArray = [];
					var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
					multipleSessionStore.getProxy().extraParams = {
						type:"multipleSession"
					};
					multipleSessionStore.load({
						callback: function(records, operation, success) {
							if (success) {
								for (s=1;s<=sessionNumber;s++) {
									if(multipleSessionStore.find("code",s)>=0){
										storeArray.push({
											'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
											'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
										});
									} else {
										storeArray.push({'val':s,
											'code': s});
									}
								}
							}
							var store1 = Ext.create('Ext.data.Store', {
								fields: ['val','code'],
								data : storeArray
							});
							var l = Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]').length-1;
							Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].bindStore(store1);
							if(storeArray.length>0)
							{
								Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].setValue(1);
							}
						}
					});
				
				}
			},
			resetCompleteDaySearchForm:function(form){
				var this$ = this;
				var attendancesearchstrucure =  this$.getStudentattendancereportstructureforfaculty();
				var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
				var academicTerm = form.down('#completeDayAcademicTermId');
				var studentField = form.down('#completeDayStudentName_Id');
				var programGroupField = form.down('#completeDayProgramGroupItemId');
				var programBatchPeriodFeild = form.down('#completeDayAttendanceProgramId');
				var startDateField = form.down('#startDate');
				var endDateField = form.down('#endDate');
				var attendanceStatusField = form.down('#completeDayAttendanceStatus');
				var absentLastField = form.down('#completeDayAbsentForLast');
				form.down('#completeStudentStatusId').setValue(true);
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				var grid = this.getStudentattendancereportgridforfaculty();
				var store = grid.getStore();
				academicTerm.reset();
				studentField.reset();
				programGroupField.reset();
				programBatchPeriodFeild.reset();
				startDateField.reset();
				endDateField.reset();
				attendanceStatusField.reset();
				absentLastField.reset();
				startDateField.setMinValue(false);
				startDateField.setMaxValue(new Date());
				endDateField.setMinValue(false);
				endDateField.setMaxValue(new Date());

				var academicTermStore = academicTerm.getStore();
				var academicTermIdNew = null;
				academicTermStore.load({
					callback: function(records, operation, success) {
						for(var i in records) {
							if(records[i].get('sequence') == 1) {
								academicTermIdNew = records[i].get('id');
								academicTerm.setValue(academicTermIdNew);
								
							}
						}
					}
				});

				var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				var studentStore = studentField.getStore();
				studentStore.getProxy().api.read=submitURL;
				studentStore.getProxy().extraParams = {
					academyLocationIds : academyLocationId,
					facultyId : facultyId,
					academicTermId:academicTermIdNew
				};
				studentStore.load();

				var programGroupStore = programGroupField.getStore();
				programGroupStore.getProxy().extraParams = {
					academyLocationId:academyLocationId,
					academicTermId:academicTermIdNew
				};

				programGroupStore.load();

				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					wheatherSchool:wheatherSchool,
					academicTermId:academicTermIdNew
				};
				programByAcademyLocationStore.load();
				store.removeAll();
				var grid = this.getStudentattendancereportgridforfaculty();
				grid.getStore().removeAll();
				try{
					grid.down('custompagingtoolbar').hide();
				}catch(e){
				}

			},
			academicTermChange: function(form,academicTermId){
				var studentField = form.down('#completeDayStudentName_Id');
				var programGroupField = form.down('#completeDayProgramGroupItemId');
				var programBatchPeriodFeild = form.down('#completeDayAttendanceProgramId');
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				studentField.reset();
				programGroupField.reset();
				programBatchPeriodFeild.reset();

				var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				var studentStore = studentField.getStore();
				studentStore.getProxy().api.read=submitURL;
				studentStore.getProxy().extraParams = {
					academyLocationIds : academyLocationId,
					facultyId : facultyId,
					academicTermId:academicTermId,
				};
				studentStore.load();

				var programGroupStore = programGroupField.getStore();
				programGroupStore.getProxy().extraParams = {
					academyLocationId:academyLocationId,
					academicTermId:academicTermId,
					facultyId : facultyId
				};

				programGroupStore.load();

				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					academicTermId:academicTermId,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load();

			},
			studentIdChange: function(form,studentId){
				var academicTermField = form.down('#completeDayAcademicTermId');
				var programGroupField = form.down('#completeDayProgramGroupItemId');
				var programBatchPeriodFeild = form.down('#completeDayAttendanceProgramId');
				var record = form.down('#completeDayStudentName_Id').getStore().findRecord('id', studentId).data;
				form.down('#completeStudentStatusId').setValue(record.activeStatus);
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				var academicTermId = academicTermField.getValue();
				programGroupField.reset();
				programBatchPeriodFeild.reset();

				var programGroupStore = programGroupField.getStore();
				programGroupStore.getProxy().extraParams = {
					academyLocationId:academyLocationId,
					academicTermId:academicTermId
				};
				programGroupStore.load();

				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					academicTermId:academicTermId,
					studentId:studentId,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0){
								programBatchPeriodFeild.setValue(records[0].data.sectionId);
								programGroupField.setValue(records[0].data.programGroupId);
							}
						}
					}
				});
			},
			programGroupChange: function(form,programGroupId){
				var academicTermField = form.down('#completeDayAcademicTermId');
				var studentField = form.down('#completeDayStudentName_Id');
				var programBatchPeriodFeild = form.down('#completeDayAttendanceProgramId');
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				var academicTermId = academicTermField.getValue();
				var studentId = studentField.getValue();

				programBatchPeriodFeild.reset();
				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					academicTermId:academicTermId,
					studentId:studentId,
					programGroupId:programGroupId,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0 && records.length == 1){
								programBatchPeriodFeild.setValue(records[0].data.sectionId);
							}
						}
					}
				});

			},
			loadStudentAttendanceReportForCompleteDay: function(attendanceType){
				var this$=this;
				var grid = this.getStudentattendancereportgridforfaculty();
				grid.setVisible(true);
				var store = grid.getStore();

				var form = this$.getCompletedaystudentattendancesearch();
				var academicTermField = form.down('#completeDayAcademicTermId');
				var studentField = form.down('#completeDayStudentName_Id');
				var programGroupField = form.down('#completeDayProgramGroupItemId');
				var programBatchPeriodFeild = form.down('#completeDayAttendanceProgramId');
				var startDateField = form.down('#startDate');
				var endDateField = form.down('#endDate');
				var attendanceStatusField = form.down('#completeDayAttendanceStatus');
				var absentLastField = form.down('#completeDayAbsentForLast');
				var completeStudentStatus = form.down('#completeStudentStatusId');

				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				var academicTermId = academicTermField.getValue();
				var studentId = studentField.getValue();
				var programGroupId = programGroupField.getValue();
				var programBatchPeriodSectionId =  programBatchPeriodFeild.getValue();
				var startDate =Ext.Date.format(startDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
				var endDate = Ext.Date.format(endDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
				var attendanceStatus = attendanceStatusField.getValue();
				var absentLast = absentLastField.getValue();
				var activeStatus = completeStudentStatus.getValue();

				store.getProxy().extraParams = {
					sectionId:programBatchPeriodSectionId,
					facultyId:facultyId,
					startDate:startDate,
					endDate:endDate,
					attendanceType:attendanceType,
					programGroupId :programGroupId,
					academicTermId:academicTermId,
					attendanceStatus:attendanceStatus,
					studentId:studentId,
					absentForLast:null,
					isCurrentPeriod:false,
					activeStatus:activeStatus
				};
				Ext.getBody().unmask();
				this.resetPageSetting(store, grid);
				store.load();

			},

			disableMoreActionAttendancePivileges: function(gridReference,permissionsMap) {
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				var deleteAttendanceBtn = gridReference.down('#btnDeleteStudentAttendance');
				var editAttendanceBtn = gridReference.down('#btnUpdateAttendance');
				editAttendanceBtn.setVisible(false);
				deleteAttendanceBtn.setVisible(false);
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'UPDATE') {
						if(!isNullOrEmpty(editAttendanceBtn)){
							editAttendanceBtn.setVisible(true);
						}        		
					}
					if (privilege === 'DELETE') {
						if(!isNullOrEmpty(deleteAttendanceBtn)){
							deleteAttendanceBtn.setVisible(true);
						}        	
					}
				});
			},
			deleteStudentAttendanceRecord : function() {
				var this$ = this;
				var attendancesearchstrucure =  this$.getStudentattendancereportstructureforfaculty();
				var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
				var frmWin = this$.getOpenupdateattendancestatuswindow();
				var grid = this$.getStudentattendancereportgridforfaculty();
				var submitUrl = SERVERURL.DELETE_STUDENT_ATTENDANCE_DETAILS;
				if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level') {
					grid = this$.getStudentcourseattendancereportgridforfaculty();
					submitUrl = SERVERURL.DELETE_STUDENT_COURSE_ATTENDANCE_DETAILS;
				}
				if(grid.getSelectionModel().getCount()>0) {
					showConfirmMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							var gridRecord = grid.getSelectionModel().getSelection();
							var ids=[];
							Ext.Array.each(gridRecord, function(record, index) {
								ids.push(record.data.id);
							});
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								timeout:300000,
								url : submitUrl+ '?ids='+ ids,
								headers : {
									'Content-Type' : 'application/json'
								},
								success : function(res,form,action) {
									Ext.getBody().unmask();
									if(res.responseText="success"){
										showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
										grid.getStore().reload();
									}
								}
							});
						}
					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
				}
			},

			openEditStudentAttendanceWindow : function(windowName){
				var this$ = this;
				var attendancesearchstrucure =  this$.getStudentattendancereportstructureforfaculty();
				var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
				var attendanceGrid =  this$.getStudentattendancereportgridforfaculty();
				if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level') {
					attendanceGrid = this$.getStudentcourseattendancereportgridforfaculty();
				}
				if(attendanceGrid.getSelectionModel().getCount()>0){
					var studentCount = attendanceGrid.getSelectionModel().getCount();
					var frmWin = this.getOpenupdateattendancestatuswindow();
					if (!frmWin) {
						Ext.widget('openupdateattendancestatuswindow');
						frmWin = this.getOpenupdateattendancestatuswindow();
					}
					frmWin.show();
					frmWin.down('form').getForm().findField('StudentCount').setValue(studentCount);
					var permissionMap = this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION();
					var associatedAcadLocationIds = new Array();
         		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
         		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
         		   var attendanceStatus = frmWin.down('#attendanceStatus');
         		   var attendanceStatusStore = attendanceStatus.getStore().load({
         			   callback : function(records, operation, success) {
         				   if (success) {
         					   if(records.length > 0){
         						  attendanceStatus.setValue(records[0].data.id);
         						   var presentPermission = true;
         						   var absentPermission = true;
         						   var leavePermission = true;
         						   Ext.each(permissionList, function(privilege) {
         							   if (privilege === 'PRESENT') {
         								   presentPermission = false;		
         							   }
         							   if(privilege === 'ABSENT') {
         								   absentPermission = false;
         							   }
         							   if(privilege === 'LEAVE') {
         								   leavePermission = false;
         							   }
         						   });
         						   if(presentPermission) {
         							   attendanceStatusStore.removeAt(attendanceStatusStore.find('id', '1'));
         						   }
         						   if(absentPermission) {
         							   attendanceStatusStore.removeAt(attendanceStatusStore.find('id', '2'));
         						   }
         						   if(leavePermission) {
         							   attendanceStatusStore.removeAt(attendanceStatusStore.find('id', '3'));
         						   }
         						   attendanceStatus.bindStore(attendanceStatusStore);
         					   }
         				   }
         			   }
         		   });
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
				}
			},

			bulkUpdateStudentAttendanceStatus : function(){
         	   var this$ = this;
         	   var noOfBackDays ='';
         	   var form = '';
         	   var startDate = '';
         	   var endDate = '';
        	   var attendancesearchstrucure =  this$.getStudentattendancereportstructureforfaculty();
        	   var attendanceType = attendancesearchstrucure.down('#attendanceTypeRadioFieldId').getValue().studentAttendanceTypeWise;
        	   var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
        	   var frmWin = this$.getOpenupdateattendancestatuswindow();
        	   var grid = this$.getStudentattendancereportgridforfaculty();
        	   if(attendanceType == 'COMPLETE_DAY') {
        		   form = this.getCompletedaystudentattendancesearch();
        		   startDate = attendanceTypess.data.COMPLETE_DAY.startDate;
            	   endDate = attendanceTypess.data.COMPLETE_DAY.endDate;
            	   noOfBackDays =  attendanceTypess.data.COMPLETE_DAY.backDateAllowedForFaculty;
        	   } else if(attendanceType == 'MULTIPLE_SESSION') {
        		   form = this.getSessionwisestudentattendancesearch();
        		   startDate = attendanceTypess.data.MULTIPLE_SESSION.startDate;
            	   endDate = attendanceTypess.data.MULTIPLE_SESSION.endDate;
            	   noOfBackDays =  attendanceTypess.data.MULTIPLE_SESSION.backDateAllowedForFaculty;
        	   } else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level') {
        		   form = this.getSessionwisestudentattendancesearch();
        		   startDate = attendanceTypess.data.COURSE_LEVEL.startDate;
            	   endDate = attendanceTypess.data.COURSE_LEVEL.endDate;
            	   noOfBackDays =  attendanceTypess.data.COURSE_LEVEL.backDateAllowedForFaculty;
            	   grid = this$.getStudentcourseattendancereportgridforfaculty();
        	   }
        	   var gridRecord = grid.getSelectionModel().getSelection();
        	   var values =  frmWin.down('form').getValues();
        	   var status = frmWin.down('form').down('#attendanceStatus').getRawValue();
        	   var ids=[];
        	   var notValid = true;
        	   var studentAttendance =new Academia.model.attendance.UpdateAttendanceModel();
        	   studentAttendance.set("attendanceMarkingTypeId",values.attendanceStatus);
        	   studentAttendance.set("attendanceType",attendanceType);
        	   Ext.Array.each(gridRecord, function(record, index) {
        		   if(record.data.dateOfAttendance>=startDate && record.data.dateOfAttendance <= endDate) { 
        			   ids.push(record.data.id);
        		   } else {
        			   notValid = false;
        		   }
        	   });
        	   studentAttendance.set("attendanceids",ids);
        	   studentAttendance.set("comment",values.commentArea);
        	   studentAttendance.set("portalId",this$.getCurrentLoggedPortalId());
        	   delete studentAttendance.data.attendanceStatus;
        	   var formData = Ext.encode(studentAttendance.data);
        	   if(!notValid) {
        		   showConfirmMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation('BACK_DATE_ALLOWED_MSG')+noOfBackDays+getProgramandcourseTranslation('DAYS'), function(btn, text) {
          			 if (btn == 'yes') {
          				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
          				Ext.Ajax.request({
	                		   type: 'rest',
	                		   url: SERVERURL.UPDATE_ATTENDANCE_STATUS,
	                		   jsonData : formData,
	                		   method : 'POST',
	                		   timeout:300000,
	                		   success: function(f, action) {
	                			   Ext.getBody().unmask();
	                			   var data = f.responseText;
	                			   if(data == "SUCCESS")
	                				   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	                			   grid.getStore().reload();
	                			   grid.getSelectionModel().deselectAll();
	                			   frmWin.close();
	                		   },
	                		   failure: function(result, request) {
	                			   showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
	                			   return false;
	                		   }
	                	   });
          			 }
          			 });
        	   } else {
        		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        		   Ext.Ajax.request({
            		   type: 'rest',
            		   url: SERVERURL.UPDATE_ATTENDANCE_STATUS,
            		   jsonData : formData,
            		   method : 'POST',
            		   timeout:300000,
            		   success: function(f, action) {
            			   Ext.getBody().unmask();
            			   var data = f.responseText;
            			   if(data == "SUCCESS")
            				   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
            			   grid.getStore().reload();
            			   grid.getSelectionModel().deselectAll();
            			   frmWin.close();
            		   },
            		   failure: function(result, request) {
            			   showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
            			   return false;
            		   }
            	   });
        	   }
           },
			academicTermChangeForCourseLevel : function(form,academicTermId){
				var this$ = this;
				var studentField = form.down('#courseLevelStudentId');
				var courseVariantField = form.down('#courseLevelCourseVariantId');
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;

				studentField.reset();
				courseVariantField.reset();

				var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
				var studentStore = studentField.getStore();
				studentStore.getProxy().api.read=submitURL;
				studentStore.getProxy().extraParams = {
					academyLocationIds: academyLocationId,
					facultyId: facultyId,
					academicTermId:academicTermId
				};
				studentStore.load();

				var courseVariantStore = courseVariantField.getStore();
				courseVariantStore.getProxy().extraParams = {
					academyLocationIds: academyLocationId,
					facultyId: facultyId,
					academicTermId:academicTermId,
					isCurrentPeriod:false
				};
				courseVariantStore.load();
			},
			studentIdChangeForCourseLevel : function(form,studentId){
				var this$ = this;
				var courseVariantField = form.down('#courseLevelCourseVariantId');
				var academicTermId = form.down('#courseLevelAcademicTermId').getValue();
				var record = form.down('#courseLevelStudentId').getStore().findRecord('id', studentId).data;
				form.down('#courseLevelStudentStatusId').setValue(record.activeStatus);
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				courseVariantField.reset();
				var courseVariantStore = courseVariantField.getStore();
				courseVariantStore.getProxy().extraParams = {
					academyLocationIds: academyLocationId,
					facultyId: facultyId,
					academicTermId:academicTermId,
					isCurrentPeriod:false,
					studentId:studentId
				};
				courseVariantStore.load();
			},
			resetCourseLevelSearchForm : function(form){
				var this$ = this;
				var academicTermField = form.down('#courseLevelAcademicTermId');
				var studentField = form.down('#courseLevelStudentId');
				var courseVariantField = form.down('#courseLevelCourseVariantId');
				var startTimeField = form.down('#courseLevelFromTime');
				var endTimeField = form.down('#courseLevelToTime');
				var startDateField = form.down('#startDate');
				var endDateField = form.down('#endDate');
				var attendanceStatusField = form.down('#courseLevelAttendanceStatus');
				var absentForLastField = form.down('#courseLevelAbsentForLast');
				form.down('#courseLevelStudentStatusId').setValue(true);
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;

				academicTermField.reset();
				studentField.reset();
				courseVariantField.reset();
				startTimeField.reset();
				endTimeField.reset();
				startDateField.reset();
				endDateField.reset();
				attendanceStatusField.reset();
				absentForLastField.reset();
				startDateField.setMinValue(false);
				startDateField.setMaxValue(new Date());
				endDateField.setMinValue(false);
				endDateField.setMaxValue(new Date());
				startTimeField.setMinValue(false);
				startTimeField.setMaxValue(false);
				endTimeField.setMinValue(false);
				endTimeField.setMaxValue(false);

				var academicTermStore = academicTermField.getStore();
				academicTermStore.load({
					callback: function(records, operation, success) {
						for(var i in records) {
							if(records[i].get('sequence') == 1) {
								academicTermIdNew = records[i].get('id');
								academicTermField.setValue(academicTermIdNew);
								
							}
						}
					}
				});

				var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
				var studentStore = studentField.getStore();
				studentStore.getProxy().api.read=submitURL;
				studentStore.getProxy().extraParams = {
					academyLocationIds: academyLocationId,
					facultyId: facultyId
				};
				studentStore.load();

				var courseVariantStore = courseVariantField.getStore();
				courseVariantStore.getProxy().extraParams = {
					academyLocationIds: academyLocationId,
					facultyId: facultyId,
					isCurrentPeriod:false
				};
				courseVariantStore.load();

			},
			academicTermChangeForSessionWise : function(form,academicTermId){
				var studentField = form.down('#sessionWiseStudentId');
				var programGroupField = form.down('#sessionWiseProgramGroupId');
				var programBatchPeriodFeild = form.down('#sessionWiseAttendanceProgramId');
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				studentField.reset();
				programGroupField.reset();
				programBatchPeriodFeild.reset();

				var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				var studentStore = studentField.getStore();
				studentStore.getProxy().api.read=submitURL;
				studentStore.getProxy().extraParams = {
					academyLocationIds : academyLocationId,
					facultyId : facultyId,
					academicTermId:academicTermId,
				};
				studentStore.load();

				var programGroupStore = programGroupField.getStore();
				programGroupStore.getProxy().extraParams = {
					academyLocationId:academyLocationId,
					academicTermId:academicTermId,
					facultyId : facultyId
				};
				programGroupStore.load();

				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					academicTermId:academicTermId,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load();

			},
			studentIdChangeForSessionWise : function(form,studentId){
				var academicTermField = form.down('#sessionWiseAcademicTermId');
				var programGroupField = form.down('#sessionWiseProgramGroupId');
				var programBatchPeriodFeild = form.down('#sessionWiseAttendanceProgramId');
				var record = form.down('#sessionWiseStudentId').getStore().findRecord('id', studentId).data;
				form.down('#sessionwiseStudentStatusId').setValue(record.activeStatus);
				
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');
				var academicTermId = academicTermField.getValue();
				programGroupField.reset();
				programBatchPeriodFeild.reset();

				var programGroupStore = programGroupField.getStore();
				programGroupStore.getProxy().extraParams = {
					academyLocationId:academyLocationId,
					academicTermId:academicTermId
				};
				programGroupStore.load();

				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					academicTermId:academicTermId,
					studentId:studentId,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0){
								programBatchPeriodFeild.setValue(records[0].data.sectionId);
								programGroupField.setValue(records[0].data.programGroupId);
							}
						}
					}
				});
			},
			programGroupChangeForSessionWise : function(form,programGroupId){
				var academicTermField = form.down('#sessionWiseAcademicTermId');
				var studentField = form.down('#sessionWiseStudentId');
				var programBatchPeriodFeild = form.down('#sessionWiseAttendanceProgramId');
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				var academicTermId = academicTermField.getValue();
				var studentId = studentField.getValue();

				programBatchPeriodFeild.reset();
				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					academicTermId:academicTermId,
					studentId:studentId,
					programGroupId:programGroupId,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0 && records.length == 1){
								programBatchPeriodFeild.setValue(records[0].data.sectionId);
							}
						}
					}
				});
			},
			loadStudentAttendanceReportForSessionWise: function(attendanceType){
				var this$=this;
				var grid = this.getStudentattendancereportgridforfaculty();
				grid.setVisible(true);
				var store = grid.getStore();

				var form = this$.getSessionwisestudentattendancesearch();
				var academicTermField = form.down('#sessionWiseAcademicTermId');
				var studentField = form.down('#sessionWiseStudentId');
				var programGroupField = form.down('#sessionWiseProgramGroupId');
				var programBatchPeriodFeild = form.down('#sessionWiseAttendanceProgramId');
				var startDateField = form.down('#startDate');
				var endDateField = form.down('#endDate');
				var attendanceStatusField = form.down('#sessionWiseAttendanceStatus');
				var absentLastField = form.down('#sessionWiseAbsentForLast');
				var sessionFeild = form.down('#sessionWiseSessionItemId');
				var sessionWiseStudentStatus = form.down('#sessionwiseStudentStatusId');

				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				var academicTermId = academicTermField.getValue();
				var studentId = studentField.getValue();
				var programGroupId = programGroupField.getValue();
				var programBatchPeriodSectionId =  programBatchPeriodFeild.getValue();
				var startDate =Ext.Date.format(startDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
				var endDate = Ext.Date.format(endDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
				var attendanceStatus = attendanceStatusField.getValue();
				var absentLast = absentLastField.getValue();
				var sessionVal = sessionFeild.getValue();
				var activeStatus = sessionWiseStudentStatus.getValue();

				store.getProxy().extraParams = {
					sectionId:programBatchPeriodSectionId,
					facultyId:facultyId,
					startDate:startDate,
					endDate:endDate,
					attendanceType:attendanceType,
					programGroupId :programGroupId,
					academicTermId:academicTermId,
					attendanceStatus:attendanceStatus,
					studentId:studentId,
					absentForLast:null,
					sessionNo:sessionVal,
					isCurrentPeriod:false,
					activeStatus:activeStatus
				};
				Ext.getBody().unmask();
				this.resetPageSetting(store, grid);
				store.load();

			},
			resetSessionWiseSearchForm : function(form){
				var academicTermField = form.down('#sessionWiseAcademicTermId');
				var studentField = form.down('#sessionWiseStudentId');
				var programGroupField = form.down('#sessionWiseProgramGroupId');
				var programBatchPeriodFeild = form.down('#sessionWiseAttendanceProgramId');
				var startDateField = form.down('#startDate');
				var endDateField = form.down('#endDate');
				var attendanceStatusField = form.down('#sessionWiseAttendanceStatus');
				var absentLastField = form.down('#sessionWiseAbsentForLast');
				var sessionFeild = form.down('#sessionWiseSessionItemId');
				var sessionItemId=form.down('#sessionWiseSessionItemId');
				form.down('#sessionwiseStudentStatusId').setValue(true);
				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var grid = this.getStudentattendancereportgridforfaculty();
				var store = grid.getStore();

				academicTermField.reset();
				studentField.reset();
				programGroupField.reset();
				programBatchPeriodFeild.reset();
				startDateField.reset();
				endDateField.reset();
				attendanceStatusField.reset();
				absentLastField.reset();
				sessionFeild.reset();
				sessionItemId.reset();
				startDateField.setMinValue(false);
				startDateField.setMaxValue(new Date());
				endDateField.setMinValue(false);
				endDateField.setMaxValue(new Date());

				var academicTermStore = academicTermField.getStore();
				academicTermStore.load({
					callback: function(records, operation, success) {
						for(var i in records) {
							if(records[i].get('sequence') == 1) {
								academicTermIdNew = records[i].get('id');
								academicTermField.setValue(academicTermIdNew);
								
							}
						}
					}
				});

				var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
				var studentStore = studentField.getStore();
				studentStore.getProxy().api.read=submitURL;
				studentStore.getProxy().extraParams = {
					academyLocationIds : academyLocationId,
					facultyId : facultyId
				};
				studentStore.load();

				var programGroupStore = programGroupField.getStore();
				programGroupStore.getProxy().extraParams = {
					academyLocationId:academyLocationId
				};

				programGroupStore.load();

				var programByAcademyLocationStore = programBatchPeriodFeild.getStore();
				programByAcademyLocationStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					facultyId:facultyId,
					onlyCurrentRecords:false,
					wheatherSchool:wheatherSchool
				};
				programByAcademyLocationStore.load();
				
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var sessionNumber=attendanceTypess.data.MULTIPLE_SESSION.sessionNo;
				var storeArray = [];
				var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
				multipleSessionStore.getProxy().extraParams = {
					type:"multipleSession"
				};
				multipleSessionStore.load({
					callback: function(records, operation, success) {
						if (success) {
							for (s=1;s<=sessionNumber;s++) {
								if(multipleSessionStore.find("code",s)>=0){
									storeArray.push({
										'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
										'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
									});
								} else {
									storeArray.push({'val':s,
										'code': s});
								}
							}
						}
						var store1 = Ext.create('Ext.data.Store', {
							fields: ['val','code'],
							data : storeArray
						});
						var l = Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]').length-1;
						Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].bindStore(store1);
						if(storeArray.length>0)
						{
							Ext.ComponentQuery.query('[itemId=sessionWiseSessionItemId]')[l].setValue(1);
						}
					}
				});
				store.removeAll();
				var grid = this.getStudentattendancereportgridforfaculty();
				grid.getStore().removeAll();
				try{
					grid.down('custompagingtoolbar').hide();
				}catch(e){
				}
			},
			loadStudentAttendanceReportForCourseLevel : function(attendanceType){
				var this$=this;
				var grid = this.getStudentcourseattendancereportgridforfaculty();
				var store = grid.getStore();

				var form = this$.getCourselevelstudentattendancesearch();
				var academicTermField = form.down('#courseLevelAcademicTermId');
				var studentField = form.down('#courseLevelStudentId');
				var courseVariantField = form.down('#courseLevelCourseVariantId');
				var startTimeField = form.down('#courseLevelFromTime');
				var endTimeField = form.down('#courseLevelToTime');
				var startDateField = form.down('#startDate');
				var endDateField = form.down('#endDate');
				var attendanceStatusField = form.down('#courseLevelAttendanceStatus');
				var absentForLastField = form.down('#courseLevelAbsentForLast');
				var courseLevelStudentStatus = form.down('#courseLevelStudentStatusId');

				var academyLocationId = this.getCurrentAcademyLocation();
				var facultyId = this.getCurrentlyLoggedInUser().id;
				var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				var wheatherSchool = alinfomodel.get('wheatherSchool');

				var academicTermId = academicTermField.getValue();
				var studentId = studentField.getValue();
				var courseVariantId = courseVariantField.getValue();
				var startTime =  startTimeField.getValue();
				var endTime = endTimeField.getValue();
				var startDate =Ext.Date.format(startDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
				var endDate = Ext.Date.format(endDateField.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
				var attendanceStatus = attendanceStatusField.getValue();
				var activeStatus = courseLevelStudentStatus.getValue();
				//var absendForLast = absentForLastField.getValue();
				
				store.getProxy().extraParams = {
					courseVariantId:courseVariantId,
					facultyId:facultyId,
					startDate:startDate,
					endDate:endDate,
					attendanceType:attendanceType,
					academicTermId:academicTermId,
					attendanceStatus:attendanceStatus,
					studentId:studentId,
					isCurrentPeriod:false,
					activeStatus:activeStatus
				};
				Ext.getBody().unmask();
				this.resetPageSetting(store, grid);
				store.load();

			}
});
