/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.controlAccount.ControlAccountController',{
	extend: 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.controlAccount.ControlAccountList','feeandpayment.controlAccount.AccountConfigName',
	          'feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise'],
	views : ['feeandpayment.controlAccount.ControlAccountStructure','feeandpayment.controlAccount.ControlAccountList',
	         'feeandpayment.controlAccount.ControlAccountWin'],
 	config: {
			CONTROL_ACCOUNT_GRID_CONFIGURATION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CONTROL_ACCOUNT_GRID_CONFIGURATION')
	                            	 
	       },
    refs : [{
    	      ref:'contentPanel',
	          selector:'contentpanel'
           },{
    	      ref:'controlAccountStructure',
    	      selector:'controlaccountstructure'
           },{
       	      ref:'controlAccountList',
       	      selector:'controlaccountlist'
           },{
    	      ref:'controlAccountWin',
    	      selector:'controlaccountwin' 
           },{
     	      ref:'controlAccountWinForm',
     	      selector:'controlaccountwin form' 
           }],
     init : function() {
    	 this.control({
    		 'controlaccountlist':{
    			 render : this.getRenderControlAccountList,
			afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getCONTROL_ACCOUNT_GRID_CONFIGURATION());
					},1500);
    			 },

     		 },

    		 'controlaccountlist button[itemId=btnAdd]':{
                click : this.openControlAccountWin
    		 },
    		 'controlaccountlist button[itemId=btnEdit]':{
                 click : this.getEditControlAccount
     		 },
     		 'controlaccountlist button[itemId=btnView]':{
                click : this.getViewControlAccount
    		 },
    		 'controlaccountlist button[itemId=btnDelete]':{
                 click : this.getDeleteControlAccount
     		 },
     		 'controlaccountwin button[itemId=SubmitBtn]':{
     			 click:this.getSaveControlAccount
     		 },
     		 'controlaccountwin button[itemId=CancelBtn]':{
    			 click:this.getCloseWin
    		 }
    	 });
     },
     /**
      * get List data of control Account grid
      */
     getRenderControlAccountList : function(){
    	 var grid = this.getControlAccountList();
    	 var store = grid.getStore();
    	 //Start : V2D-16341
    	 store.loadPage(1);
    	 //End : V2D-16341
     },
     /**
      * Open control Account Win
      */
     openControlAccountWin : function(){
    	 var $this = this;
    	 var gridWindow = $this.getControlAccountWin();
		  if (!gridWindow) {
			  Ext.widget('controlaccountwin');
			   gridWindow = $this.getControlAccountWin();
		  }
		  gridWindow.show();
     },
     /**
      * Close Control Account Win
      */
     getCloseWin : function(){
    	 this.getControlAccountWin().close();
     },
     /**
      * save control Account information
      */
     getSaveControlAccount : function(){
    	
    	 var this$ = this;
    	var grid = this$.getControlAccountList();
    	var grdStore = grid.getStore();
    	var formWin = this$.getControlAccountWinForm();
    	var form = formWin.getForm();
    	var value = form.getValues();
    	
    	var controlAccountModel = new Academia.model.feeandpayment.controlAccount.ControlAccountList();
    	controlAccountModel.set("accountConfig",this$.getIdValueJson(value.accountConfig));
    	controlAccountModel.set("organizationUnit",this$.getIdValueJson(value.organizationUnit));
    	controlAccountModel.set("controlAccountKey",value.controlAccountKey);
    	controlAccountModel.set("whetherDefaultControlAccount",value.whetherDefaultControlAccount);
        
    	var MESSAGE;
    	if (value.id == null ||value.id == "") {
			submitUrl = SERVERURL.CONTROL_ACCOUNT_CREATE;
			MESSAGE = getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT_CREATED_SUCCESSFULLY');
		} else {
			controlAccountModel.set("id",value.id);
			submitUrl = SERVERURL.CONTROL_ACCOUNT_UPDATE;
			MESSAGE = getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT_UPDATED_SUCCESSFULLY');
		}
    	delete controlAccountModel.data.whetherControlAccount;
    	
    	var submitData = Ext.encode(controlAccountModel.data);
    	this$.applyWindowMask(); 
    
    	Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				this$.hideWindowMask();
				grdStore.reload();
				this$.getCloseWin();
				showSuccessMessage(getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),MESSAGE);
			}
		});
     },
     /**
      * get edit Control Account Win
      */
     getEditControlAccount: function() {
        
    	 var this$ = this;
    	 var grid = this$.getControlAccountList();
 		if (grid.getSelectionModel().getCount() > 0) {
 			this.openControlAccountWin();
 			var form = this$.getControlAccountWinForm();
 			var record = grid.getSelectionModel().getSelection()[0];
 			var id = record.get("id");
 			var editUrl = SERVERURL.CONTROL_ACCOUNT_FIND_BY_ID;
 			//this$.applyWindowMask();
             Ext.Ajax.request({
                 method: "GET",
                 type: 'rest',
                 url: editUrl,
                 params: {
                     id: id
                 },
                 success: function(f, action) {
                	// this$.hideWindowMask();
                     var controlAccountData = Ext.JSON.decode(f.responseText);
                     var controlAccountModel = new Academia.model.feeandpayment.controlAccount.ControlAccountList(controlAccountData);
 				     form.loadRecord(controlAccountModel);
 				    var accountConfigId = controlAccountData.accountConfig.id;
 				    var organizationUnitId = controlAccountData.organizationUnit.id;
					var whetherDefaultControlAccount = controlAccountData.whetherDefaultControlAccount;
					if(record.get("whetherControlAccount")==true){
						form.down("#whetherDefaultControlAccountId").setReadOnly(true);	
					}
					
 				    var accountConfig = form.down("#accountConfig");
 				    accountConfig.store.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 accountConfig.setValue(accountConfigId);
							 }
						 }
					 });
 				    
 				   var organizationUnit = form.down("#organizationUnit");
 				   organizationUnit.store.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 organizationUnit.setValue(organizationUnitId);
							 }
						 }
					 });
                 }
             });
 		} else {
 			showWarningMessage(getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
 		}
 	},
 	
 	/**
     * get view (read only) control Acount win
     */
 	getViewControlAccount : function(){
 		var this$ = this;
 		this$.getEditControlAccount();
 		var form = this$.getControlAccountWinForm();
 		if (form) {
 			form.down("#SubmitBtn").setVisible(false);
 			form = form.getForm();
 			toggleReadOnlyFormItems(form, true);
 		}
 	},
 	getDeleteControlAccount : function(){
 		 var this$ = this;
    	 var grid = this$.getControlAccountList();
    	 var grdStore = grid.getStore();
		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records=grid.getSelectionModel().getSelection();						        
					var id=records[0].get("id");
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.CONTROL_ACCOUNT_DELETE+'?id='+id,
						headers: {
							'Content-Type': 'application/json'
						},
						success:function(form, action){
							grdStore.reload();
							showSuccessMessage(getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT_DELETED_SUCCESSFULLY'));
						}
					});
				}
			});
		}else{
			showWarningMessage(getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
		}
 	},
 	
     /**
      * it will create id vale format
      */
      getIdValueJson: function(id) {
 		if (id) return {
 			id: id
 		};
 	}
});