/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.receipts.FeeLedgerMasterController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.receipts.FeeLedgerName','feeandpayment.receipts.FeeLedgerMaster',
	          'common.AcademyStore','common.AcademyLocationByAcademyId','feeandpayment.receipts.FeeLedgerName',
	          'feeandpayment.receipts.FeeLedgerMaster','user.UserAcademyLocationStore'],
   
	views : ['feeandpayment.receipts.FeeLedgerMasterSearchForm','feeandpayment.receipts.FeeLedgerMasterStructure',
           'feeandpayment.receipts.FeeLedgerMasterList','feeandpayment.receipts.FeeLedgerMasterWin'],

           refs : [{
        	   ref:'feeledgermastersearchform',
        	   selector:'feeledgermastersearchform'
           },{
        	   ref:'feeledgermasterlist',
        	   selector:'feeledgermasterlist'
           },{
        	   ref:'feeledgermasterwin',
        	   selector:'feeledgermasterwin'
           },{
        	   ref:'feeledgermasterWin',
        	   selector:'feeledgermasterwin form'
           }],
           config: {
        	   FEES_LEDGER_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FEES_LEDGER_MASTER_PRIVILEGES')
           },
           init : function() {
        	   this.control({
        		   'feeledgermastersearchform':{
        			   render:function(){
        				   var $this = this;
        				   var academyLocationId=null;
        				   var ledgerName=null;

        				   var store = this.getStore('feeandpayment.receipts.FeeLedgerName');
        				   store.getProxy().extraParams = {
        					   academyLocationId:academyLocationId,
        					   ledgerName:ledgerName
        				   },
        				   store.load();
        				   var store = this.getStore('user.UserAcademyLocationStore');
        				   store.getProxy().extraParams = {
        					   id : $this.getCurrentlyLoggedInUser().id
        				   },
        				   store.load();
        			   }  
        		   },
        		   'feeledgermastersearchform customcombobox#academyLocationCombo': {
        			   select: function(obj, record) {
        				   //obj.nextSibling().clearValue();
        				   var academyId = record[0].get("id");
        				   if(academyId > 0){
        					   var store = this.getStore('common.AcademyLocationByAcademyId');
        					   store.getProxy().extraParams = {
        						   id: academyId
        					   },
        					   store.load();
        					   var form = this.getFeeledgermastersearchform();
        					   var ledgerNameFld = form.down('#ledgerName');
        					   ledgerNameFld.reset();
        					   ledgerNameFld.lastQuery=null;
        					   ledgerNameFld.getStore().getProxy().extraParams = {
            					   academyLocationId:academyId
            				   }
        				   }
        			   }
        		   },
        		   'feeledgermastersearchform button[itemId=searchBtn]':{
        			   click : this.getFeeLedgerMasterSearch
        		   },
        		   'feeledgermastersearchform button[itemId=resetBtn]':{
        			   click : function(){
        				   var form = this.getFeeledgermastersearchform();
        				   form.getForm().reset();
    					   var ledgerNameFld = form.down('#ledgerName');
    					   ledgerNameFld.clearValue();
    					   ledgerNameFld.lastQuery=null;
    					   ledgerNameFld.getStore().getProxy().extraParams = {
        					   academyLocationId:null
        				   }
        			   }
        		   },
        		   'feeledgermasterlist':{
        			   render: function(grid){
        				   this.doAccessControlValidation(grid, this.getFEES_LEDGER_MASTER_PERMISSIONS());
        			   }
        		   },
        		   'feeledgermasterlist button[itemId=btnAdd]':{
        			   click : this.showFeeLedgerWin
        		   },
        		   'feeledgermasterlist button[itemId=btnEdit]':{
        			   click : this.editFeeLedgerWin
        		   },
        		   'feeledgermasterlist button[itemId=btnView]':{
        			   click : this.viewFeeLedgerWin
        		   },
        		   'feeledgermasterlist button[itemId=btnDelete]':{
        			   click : this.deleteFeeLedgerWin
        		   },
        		   'feeledgermasterwin customcombobox#academyId': {
        			   select: function(obj, record) {
        				   var academyId = record[0].get("id");
        				   if(academyId > 0){
        					   var store = this.getStore('common.AcademyLocationByAcademyId');
        					   store.getProxy().extraParams = {
        						   id: academyId
        					   },
        					   store.load();
        				   }
        			   }
        		   },
        		   'feeledgermasterwin button[itemId=SubmitBtn]' : {
        			   click:this.saveFeeLedgerWin
        		   },
        		   'feeledgermasterwin button[itemId=CancelBtn]' : {
        			   click:this.closeFeeLedgerMasterWin
        		   }
        	   });
           },
           //***************get Edit receipt header for student**********


           //**************** ledger master search***************
           getFeeLedgerMasterSearch : function(){
        	   var $this=this;
        	   var form = this.getFeeledgermastersearchform();
        	   var value = form.getForm().getValues();
        	   var academyLocationId = value.ACAD_LOC_ID;
        	   var ledgerName = value.ledgerName;

        	   var store = this.getStore('feeandpayment.receipts.FeeLedgerMaster');
        	   store.getProxy().extraParams = {
        		   /*academyId:academyId,
        		   locationId:locationId,*/
        		   academyLocationId : academyLocationId,
        		   ledgerName:ledgerName
        	   };
        	   $this.resetPageSetting(store);
        	   store.load();
           },
           //*********close ledger window
           closeFeeLedgerMasterWin : function(){
        	   this.getFeeledgermasterwin().close();
           },

           //*************save records of fee ledger******************
           saveFeeLedgerWin : function(){
        	   var $this = this;

        	   var grid = $this.getFeeledgermasterlist();
        	   var grdStore = grid.getStore();

        	   var form = $this.getFeeledgermasterWin().getForm();
        	   var value = form.getValues();

        	   var location = form.findField("locationId");
        	   var acadmylocationId = location.valueModels[0].get("id");

        	   var receiptModel = new Academia.model.feeandpayment.receipts.FeeLedgerMaster(); 

        	   receiptModel.set("ledgerName",value.ledgerName);
        	   receiptModel.set("academyLocation",$this.getIdValueJson(acadmylocationId));
        	   receiptModel.set("academy",null);
        	   receiptModel.set("location",null);
        	   receiptModel.set("id",value.id);
        	   receiptModel.set("status",true);

        	   var submitUrl;
        	   if (value.id == null ||value.id == "") {
        		   submitUrl = SERVERURL.FEE_LEDGER_MASTER_CREATE;
        	   } else {
        		   submitUrl = SERVERURL.FEE_LEDGER_MASTER_UPDATE;
        	   }

        	   var submitData = Ext.encode(receiptModel.data);

        	   Ext.Ajax.request({
        		   url: submitUrl,
        		   jsonData: submitData,
        		   method: 'POST',
        		   success: function(response) {
        			   $this.closeFeeLedgerMasterWin();
        			   grdStore.reload();
        			   if (value.id == null ||value.id == "") {
        				   showSuccessMessage(getFeeAndPaymentCommonTranslation('FEE_LEDGER'),getFeeAndPaymentCommonTranslation('LEDGER_CREATED_SUCCESSFULLY'));    				  
        			   } else {
        				   showSuccessMessage(getFeeAndPaymentCommonTranslation('FEE_LEDGER'),getFeeAndPaymentCommonTranslation('LEDGER_UPDATED_SUCCESSFULLY'));
        			   }
        		   }
        	   });
           },
           // *********** show add ledger form window***********

           showFeeLedgerWin : function(){

        	   var frmWin = this.getFeeledgermasterwin();
        	   if(!frmWin){ 
        		   Ext.widget('feeledgermasterwin');
        		   frmWin = this.getFeeledgermasterwin();
        	   } 
        	   frmWin.show();
           },
           //*********get fee ledger record*******************
           editFeeLedgerWin : function(){

        	   var $this = this;

        	   var grid = $this.getFeeledgermasterlist();

        	   if (grid.getSelectionModel().getCount() > 0) {
        		   this.showFeeLedgerWin();
        		   var form = $this.getFeeledgermasterWin();
        		   var record = grid.getSelectionModel().getSelection()[0];
        		   var id = record.get("id");
        		   var editUrl = SERVERURL.FEE_LEDGER_MASTER_FINDBYID;
        		   Ext.Ajax.request({
        			   method: "GET",
        			   type: 'rest',
        			   url: editUrl,
        			   params: {
        				   id: id
        			   },
        			   success: function(f, action) {
        				   var ledgerData = Ext.JSON.decode(f.responseText);
        				   var ledgerModel =  new Academia.model.feeandpayment.receipts.FeeLedgerMaster(ledgerData);
        				   form.loadRecord(ledgerModel);

        				   var academyId = ledgerModel.data.academy;
        				   if(academyId){
        					   var academy = form.down('#academyId');
        					   academy.store.load({
        						   callback: function(record, operation, success) {
        							   if (success) {
        								   academy.setValue(academyId.id);
        							   }
        						   }
        					   });
        				   }
        				   var locationId = ledgerModel.data.academyLocation;
        				   if(locationId){
        					   var location = form.down('#locationId');
        					   location.store.load({params:{id: academyId.id},
        						   callback: function(record, operation, success) {
        							   if (success) {
        								   location.setValue(locationId.id);
        							   }
        						   }
        					   });
        				   }
        			   }
        		   }); 
        	   }else{
        		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_LEDGER'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        	   } 

           },
           //*********** delete ledger reecords*************
           deleteFeeLedgerWin:function(){
        	   var $this = this;
        	   var grid = $this.getFeeledgermasterlist();
        	   var grdStore = grid.getStore();

        	   if (grid.getSelectionModel().getCount() > 0) {
        		   showConfirmMessage(getFeeAndPaymentCommonTranslation('FEE_LEDGER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
        			   if (btn == 'yes') {
        				   var records = grid.getSelectionModel().getSelection();
        				   var id = records[0].get("id");
        				   Ext.Ajax.request({
        					   method: "DELETE",
        					   type: 'rest',
        					   url: SERVERURL.FEE_LEDGER_MASTER_DELETE+'?id='+id,
        					   headers: {
        						   'Content-Type': 'application/json'
        					   },
        					   success: function(form, action) {
        						   grdStore.reload();
        						   showSuccessMessage(getFeeAndPaymentCommonTranslation('FEE_LEDGER'), getFeeAndPaymentCommonTranslation('LEDGER_DELETED_SUCCESSFULLY'));
        					   }
        				   });
        			   }
        		   });
        	   } else {
        		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_LEDGER'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        	   } 
           },
           //**********view the selected ledger record***********
           viewFeeLedgerWin : function(){

        	   this.editFeeLedgerWin();
        	   var form =this.getFeeledgermasterWin();
        	   if (form) {
        		   form.down('#SubmitBtn').setVisible(false);
        		   form = form.getForm();
        		   toggleReadOnlyFormItems(form, true);
        	   }
           },
         //*********create json formate**********
           getIdValueJson: function(id, value) {
       		if (id) return {
       			id: id,
       			value: value
       		};
           }

});