/**
 * @author Ravi Choudhary 
 * @author Amit Gupta
 */
Ext.define('Academia.controller.filemanagement.ManageFileController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['filemanagement.ManageFileGridStore','filemanagement.ManageFileAssignedGridStore',
	         'filemanagement.FileTypeStore','common.AcademyLocationNameSeparated','filemanagement.FilePriorityStore',
	         'criteriabuilder.userquicksearch.QuickSearchName','filemanagement.FileAcknowledeStore','leavemanagement.EligibilityALGridStore',
	         'attendance.UserGroup','filemanagement.FileStatusStore','filemanagement.CurrentFileLocationStore','filemanagement.FileNumberStore',
	         'filemanagement.MultiFileTempStore','filemanagement.FileDocumentByFileInfoStore',
	         'hostel.roomallocation.UserSmartSearchByUserType'],
	         views: ['filemanagement.ManageFileStructure','filemanagement.ManageFileSearchStructure','filemanagement.ManageFilesGrid','filemanagement.ManageFilesFilter',
	                 'filemanagement.AddFileInfoStructure','filemanagement.AddFileInfoForm','filemanagement.FileAssignToForm',
	                 'baselayout.contentarea.ContentPanel','filemanagement.CurrentFileLocationWindow',
	                 'filemanagement.FileUpdateStatusWin','filemanagement.FileUploadStructure',
	                 'filemanagement.FileUploadMultipleDragAndDrop','filemanagement.FileAcademyLocationsWindow',
	                 'filemanagement.ManageAssignedFileStructure','filemanagement.ManageAssignedFilesFilter',
	                 'filemanagement.ManageAssignedFilesGrid','filemanagement.FileInformationStructure',
	                 'filemanagement.FileInformationForm','filemanagement.FileInfoManageForm',
	                 'filemanagement.FileForwardWin','filemanagement.FileAttachmentsForm',
	                 'filemanagement.FileInfoDetailPanel','filemanagement.FileAssignedUploadMultipleDragAndDrop',
	                 'filemanagement.FileAssignedUploadStructure','filemanagement.FileAssignedAttachmentsForm'],

	                 //alias: "widget.placementMasterController",

	                 refs: [{
	                	 ref: 'standardMaster',
	                	 selector: 'standardMaster'
	                 },{
	                	 ref: 'managefilesfilter',
	                	 selector: 'managefilesfilter'
	                 },{
	                	 ref: 'manageassignedfilesfilter',
	                	 selector: 'manageassignedfilesfilter'
	                 },{
	                	 ref: 'fileassigntoform',
	                	 selector: 'fileassigntoform'
	                 },{
	                	 ref: 'contentpanel',
	                	 selector: 'contentpanel'
	                 },{
	                	 ref: 'managefilesgrid',
	                	 selector: 'managefilesgrid'
	                 },{
	                	 ref: 'manageassignedfilesgrid',
	                	 selector: 'manageassignedfilesgrid'
	                 },{
	                	 ref: 'managefilestructure',
	                	 selector: 'managefilestructure'
	                 },{
	                	 ref: 'fileassigneduploadstructure',
	                	 selector: 'fileassigneduploadstructure'
	                 },{
	                	 ref: 'manageassignedfilestructure',
	                	 selector: 'manageassignedfilestructure'
	                 },{
	                	 ref: 'fileacademylocationswindow',
	                	 selector: 'fileacademylocationswindow'
	                 },{
	                	 ref: 'fileuploadstructure',
	                	 selector: 'fileuploadstructure'
	                 },{
	                	 ref: 'addfileinfoform',
	                	 selector: 'addfileinfoform'
	                 },{
	                	 ref: 'fileupdatestatuswin',
	                	 selector: 'fileupdatestatuswin'
	                 },{
	                	 ref: 'currentfilelocationwindow',
	                	 selector: 'currentfilelocationwindow'
	                 },{
	                	 ref : 'fileUploadMultipleDragAndDrop',
	                	 selector : 'fileuploadmultipledraganddrop'
	                 },{
	                	 ref : 'fileAssignedUploadMultipleDragAndDrop',
	                	 selector : 'fileassigneduploadmultipledraganddrop'
	                 },{
	                	 ref: 'fileforwardwin',
	                	 selector: 'fileforwardwin'
	                 },{
	                	 ref: 'fileinformationstructure',
	                	 selector: 'fileinformationstructure'
	                 },{
	                	 ref: 'fileinformationform',
	                	 selector: 'fileinformationform'
	                 },{
	                	 ref: 'fileinfodetailpanel',
	                	 selector: 'fileinfodetailpanel'
	                 },{
	                	 ref: 'fileattachmentsform',
	                	 selector: 'fileattachmentsform'
	                 },{
	                	 ref: 'fileassignedattachmentsform',
	                	 selector: 'fileassignedattachmentsform'
	                 }],
	                 config: {
	                	 STANDARD_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STANDARD_MASTER_PRIVILEGES'),
	                	 FILE_MANAGEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FILE_MANAGEMENT_PRIVILEGES')
	                 },
	                 init: function(application) {
	                	 this.control({
	                		 'managefilesfilter':{
	                			 render:function(obj){
	                				 var $this=this;
	                				 var form=$this.getManagefilesfilter();
	                			 }
	                		 },
	                		 'managefilesfilter combo[itemId=fileTypeId]':{

	                			 select:function(obj,rec){
	                				 var data=rec[0].data.id;  
	                				 var filterForm=obj.up('form');
	                				 var fileNoField=filterForm.down('#fileNoId');
	                				 fileNoField.setDisabled(false);
	                				 fileNoField.reset();
	                				 fileNoField.getStore().getProxy().extraParams={
	                					 fileTypeId:data
	                				 };
	                				 fileNoField.getStore().load();
	                			 }
	                		 },
	                		 'manageassignedfilesfilter combo[itemId=fileTypeId]':{
	                			 select:function(obj,rec){
	                				 var data=rec[0].data.id;  
	                				 var filterForm=obj.up('form');
	                				 var fileNoField=filterForm.down('#fileNoId');
	                				 fileNoField.setDisabled(false);
	                				 fileNoField.reset();
	                				 fileNoField.getStore().getProxy().extraParams={
	                					 fileTypeId:data
	                				 };
	                				 fileNoField.getStore().load();
	                			 }
	                		 },
	                		 'fileinformationform checkboxfield[itemId=returnClarification]':{
	                			 change:function(obj){
	                				 var value = obj.getValue();
	                				 var infoForm=obj.up('fileinformationform');
	                				 var returnReasonField=infoForm.down('#returnReason');
	                				 var returningDateField=infoForm.down('#returningDate');
	                				 var resubmissionDueDateField=infoForm.down('#resubmissionDueDate');
	                				 //console.log(value.returnClarification);
	                				 if(value){
	                					 resubmissionDueDateField.setVisible(true);
	                					 returnReasonField.setVisible(true);
	                					 returningDateField.setVisible(true);
	                					 returningDateField.setValue(new Date());
	                					 returningDateField.setMinValue(new Date());
	                				 } else {
	                					 returnReasonField.reset();
	                					 returningDateField.reset();
	                					 resubmissionDueDateField.reset();
	                					 resubmissionDueDateField.setVisible(false);
	                					 returnReasonField.setVisible(false);
	                					 returningDateField.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'managefilesfilter combo[itemId=priorityId]':{
	                			 render: function(obj) {
	                				 var $this=this;
	                				 var form=$this.getManagefilesfilter();
	                				 var store=form.down('#priorityId').getStore();
	                				 store.getProxy().extraParams={
	                					 type:'FilePriority'
	                				 }
	                			 }
	                		 },
	                		 'manageassignedfilesfilter combo[itemId=priorityId]':{
	                			 render: function(obj) {
	                				 var $this=this;
	                				 var form=$this.getManageassignedfilesfilter();
	                				 var store=form.down('#priorityId').getStore();
	                				 store.getProxy().extraParams={
	                					 type:'FilePriority'
	                				 }
	                			 }
	                		 },
	                		 'fileinfodetailpanel displayfield[itemId=attachments]':{
	                			 render: function(component) {
	                				 var $this =this;
	                				 var grid = $this.getManageassignedfilesgrid();
	                				 var record = grid.getSelectionModel().getSelection()[0];
	                				 component.getEl().on('click', function(e) {
	                					 //console.log('e.........',e.target.tagName);
	                					 if(e.target.tagName=='A'){
	                						 $this.openFileAssignedAttachmentWindow(grid,record);
	                					 }
	                				 });    
	                			 }
	                		 },

	                		 /*click:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts){
	                				 if(e.target.tagName=='A'){
                						 this.openFileAssignedAttachmentWindow(grid,record);
	                				 } 
	                			 }*/
	                		 'managefilesfilter button[itemId=searchBtn]':{
	                			 click:this.loadManageFilesGrid
	                		 },
	                		 'manageassignedfilesfilter button[itemId=searchBtn]':{
	                			 click:this.loadManageAssignedFilesGrid
	                		 },
	                		 'fileassigntoform button[itemId=addFilterBtn]':{
	                			 click: function(obj){
	                				 this.addMultipleUserFilter(obj);
	                			 }
	                		 },
	                		 'fileassigntoform button[itemId=SubmitBtn]':{
	                			 //click:this.saveAssignToRecord
	                			 click: function(btn, e, eOpts ){
	                				 this.saveAssignToRecord(btn, e, eOpts);
	                				 /*if(Ext.isDefined(btn.firstTimeFired) && btn.firstTimeFired==true){
	                             		btn.firstTimeFired = false;
	                             	}
	                             	else{
	                             		btn.firstTimeFired = true;
	                             		this.saveAssignToRecord(btn, e, eOpts);
	                             	}*/
	                				 
	                			 }
	                		 },
	                		 'fileassigntoform combo[itemId=userType]':{
	                			 select:function(combo,record){
	                				 var userTypeId = record[0].get("id");
	                				 var form = combo.up('form');
	                				 var assignedUser = form.down('#assignedUser');
	                				 var ids=[];
	                				 var grid = this.getManagefilesgrid();
	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 var records = grid.getSelectionModel().getSelection();
	                					 Ext.Array.each(records[0].data.academyLocations,function(value){
	                						 ids.push(value.id);
	                					 });
	                				 }
	                				 var store = assignedUser.getStore();
	                				 store.getProxy().extraParams = {
	                					 userType: userTypeId,
	                					 academyLocationIds: ids.join()
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'fileassigntoform':{
	                			 render: function(form){
	                				 var store=this.getStore('attendance.UserGroup');
	                				 store.on('load', function(){
	                					 for(var i=0; i< store.data.items.length;i++){
	                						 var userTypeId=store.data.items[i].data.userGroupName;
	                						 if(userTypeId =='Admin' || userTypeId == 'Faculty' || userTypeId == 'Student' || userTypeId == 'Other Employee'){
	                						 } else {
	                							 store.removeAt(i);
	                						 }
	                					 }
	                				 });
	                			 }
	                		 }, 
	                		 
	                		 'fileforwardwin':{
	                			 render: function(form){
	                				 var store=this.getStore('attendance.UserGroup');
	                				 store.on('load', function(){
	                					 for(var i=0; i< store.data.items.length;i++){
	                						 var userTypeId=store.data.items[i].data.userGroupName;
	                						 if(userTypeId =='Admin' || userTypeId == 'Faculty' || userTypeId == 'Student' || userTypeId == 'Other Employee'){
	                						 } else {
	                							 store.removeAt(i);
	                						 }
	                					 }
	                				 });
	                			 }
	                		 },
	                		 
	                		 'fileforwardwin button[itemId=SubmitBtn]':{
	                			 click:this.saveFileForwardRecord
	                		 },

	                		 'fileforwardwin combo[itemId=userType]':{
	                			 select:function(obj){
//	                				 var userTypeId = record[0].get("id");
	                				 var form = this.getFileforwardwin();
	                				 var userType = form.down('#userType');
	                				 var assignedUser = form.down('#assignedUser');
	                				 var ids=[];
	                				 var grid = this.getManagefilesgrid();
	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 var records = grid.getSelectionModel().getSelection();
	                					 Ext.Array.each(records[0].data.academyLocations,function(value){
	                						 ids.push(value.id);
	                					 });
	                				 }
	                				 var store = assignedUser.getStore();
	                				 store.getProxy().extraParams = {
	                					 userType: userType.value,
	                					 academyLocationIds: ids.join()
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'managefilesfilter button[itemId=resetBtn]':{
	                			 click:function(obj, rec){
	                				 var $this = this;
	                				 var form = $this.getManagefilesfilter().getForm().reset();
	                			 }
	                		 },
	                		 'addfileinfoform button[itemId=resetBtn]':{
	                			 click:function(obj, rec){
	                				 var $this = this;
	                				 var form = $this.getAddfileinfoform().getForm().reset();
	                			 }
	                		 },
	                		 'manageassignedfilesfilter button[itemId=resetBtn]':{
	                			 click:function(obj, rec){
	                				 var $this = this;
	                				 var form = $this.getManageassignedfilesfilter().getForm().reset();
//	                				 form.findField('fileNo').setDisabled(true);
	                			 }
	                		 },
	                		 'addfileinfoform datefield[itemId=dueDate]':{
	                			 change: function(obj) {
	                				 var $this = this;
	                				 var date = new Date();
	                				 var form = $this.getAddfileinfoform().getForm();
	                				 var dueDateField = form.findField('dueDate');
	                				 dueDateField.setMinValue(Ext.Date.add(date, Ext.Date.DAY,
	                					     1));
	                			 }
	                		 },
	                		 'addfileinfoform nestedJsonCombo[itemId=priority]':{
	                			 render: function(obj) {
	                				 var $this = this;
	                				 var form = $this.getAddfileinfoform().getForm();
	                				 var store = form.findField('priority').getStore();
	                				 store.getProxy().extraParams={
	                					 type:'FilePriority'
	                				 }
	                				 var userId = $this.getCurrentlyLoggedInUser();
	                				 var fileOwner =  form.findField("fileOwner");
	                				 fileOwner.getStore().load({
	                					 callback: function(records, operation, success) {
	                						 fileOwner.setValue(userId);
	                					 }
	                				 });
	                			 }
	                		 },


	                		 'addfileinfoform textfield#fileNumber' : {
	                			 blur : function(obj, record) {
	                				 var data = obj.getValue();
	                				 if (data) {
	                					 this.checkUniqRecords(data);
	                				 }
	                			 }
	                		 },

	                		 'addfileinfoform button[itemId=submitBtn]':{
	                			 click: this.saveFileInfoRecord
	                		 },
	                		 'managefilesgrid menuitem[itemId=btnAssignTo]':{
	                			 click : function(){
	                				 var $this = this;
	                				 var grid = $this.getManagefilesgrid();
	                				 var filterGrid = $this.getManagefilesgrid();
	                				 var record = filterGrid.getSelectionModel().getSelection()[0];

	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 if(grid.getSelectionModel().getCount() == 1) {
	                						 this.ShowFileAssignToTab();
	                					 } else {
	                						 showWarningMessage(getFileManagementTranslation('ASSIGN_TO'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	                					 }
	                				 } else {
	                					 showWarningMessage(getFileManagementTranslation('ASSIGN_TO'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                				 }
	                			 }
	                		 },
	                		 'managefilesgrid menuitem[itemId=btnUpdateStatus]':{
	                			 click : function(){
	                				 var $this = this;
	                				 var grid = $this.getManagefilesgrid();
	                				 var filterGrid = $this.getManagefilesgrid();
	                				 var record = filterGrid.getSelectionModel().getSelection()[0];

	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 this.ShowFileUpdateStatusWin();
	                				 }else
	                				 {
	                					 showWarningMessage(getFileManagementTranslation('UPDATE_STATUS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                				 }
	                			 }
	                		 },
	                		 'manageassignedfilesgrid button[itemId=forwardFile]':{
	                			 click : function(){
	                				 var $this = this;
									var contentPanelActiveTab = this.getContentpanel().getActiveTab();
	                				 var grid = contentPanelActiveTab.down('manageassignedfilesgrid');
	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 this.ShowFileForwardWin();
	                				 }else
	                				 {
	                					 showWarningMessage(getFileManagementTranslation('FORWARD_TO'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                				 }
	                			 }
	                		 },
	                		 'managefilesgrid menuitem[itemId=btnUploadDocument]':{
	                			 click : function(){
	                				 var $this = this;
	                				 var grid = $this.getManagefilesgrid();
	                				 var filterGrid = $this.getManagefilesgrid();
	                				 var record = filterGrid.getSelectionModel().getSelection()[0];
	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 if(grid.getSelectionModel().getCount() == 1) {
	                						 var contentPanel = this.getContentpanel();
	                						 Ext.apply(contentPanel,{
	                							 fileInfoId: null,
	                							 setFileInfoId: function(fileInfoId) {
	                								 contentPanel.fileInfoId = fileInfoId;
	                							 },
	                							 getFileInfoId: function() {
	                								 return contentPanel.fileInfoId;
	                							 }
	                						 });
	                						 contentPanel.setFileInfoId(record.get('id'));
	                						 this.openUploadDocFormWindow();
	                					 } else {
	                						 showWarningMessage(getFileManagementTranslation('UPLOAD_DOCUMENT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	                					 }
	                				 }else
	                				 {
	                					 showWarningMessage(getFileManagementTranslation('UPLOAD_DOCUMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                				 }
	                			 }
	                		 },
	                		 'manageassignedfilesgrid button[itemId=uploadDocument]':{
	                			 click : function(){
	                				 var $this = this;
	                				var contentPanelActiveTab = this.getContentpanel().getActiveTab();
	                				 var grid = contentPanelActiveTab.down('manageassignedfilesgrid');
                                     var record = grid.getSelectionModel().getSelection()[0];
	                				 if (grid.getSelectionModel().getCount() > 0) {
	                					 if(grid.getSelectionModel().getCount() == 1) {
	                						 var contentPanel = this.getContentpanel();
	                						 Ext.apply(contentPanel,{
	                							 fileInfoAssignId: null,
	                							 setFileInfoAssignId: function(fileInfoAssignId) {
	                								 contentPanel.fileInfoAssignId = fileInfoAssignId;
	                							 },
	                							 getFileInfoAssignId: function() {
	                								 return contentPanel.fileInfoAssignId;
	                							 }
	                						 });
	                						 contentPanel.setFileInfoAssignId(record.get('fileInfoId'));
	                						 this.openAssignedUploadDocFormWindow();
	                					 } else {
	                						 showWarningMessage(getFileManagementTranslation('UPLOAD_DOCUMENT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	                					 }
	                				 }else
	                				 {
	                					 showWarningMessage(getFileManagementTranslation('UPLOAD_DOCUMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                				 }
	                			 }
	                		 },
	                		 'fileupdatestatuswin button[itemId=CancelBtn]':{
	                			 click: this.cancelFileUpdateStatusWin
	                		 },
	                		 'fileforwardwin button[itemId=CancelBtn]':{
	                			 click: this.cancelFileForwardWin
	                		 },
	                		 'fileupdatestatuswin button[itemId=SubmitBtn]':{
	                			 click: this.submitFileUpdateStatusRecord
	                		 },
	                		 'fileinformationform button[itemId=SubmitBtn]':{
	                			 click: this.submitFileInformationRecord
	                		 },
	                		 'fileinformationform button[itemId=resetBtn1]':{
	                			 click: this.resetFileInformationRecord
	                		 },
	                		 'managefilesgrid button[itemId=btnAdd]': {
	                			 click: function(){
	                				 this.openAddFileInfoForm();
		                		     this.getManagefilesgrid().getSelectionModel().deselectAll();
                                     this.removePlaceHolder();
              
	                			 }
	                		 },
	                		 'managefilesgrid button[itemId=btnEdit]': {
	                			 click: this.editFileInfoForm
	                		 },
	                		 'managefilesgrid button[itemId=btnView]': {
	                			 click: this.viewFileInfoForm
	                		 },
	                		 'managefilesgrid button[itemId=btnDelete]':{
	                			 click: this.deleteFileInfoRecord
	                		 },
	                		 'fileattachmentsform button[itemId=btnDelete]':{
	                			 click: this.deleteFileDocumentRecord
	                		 },
	                		 'fileattachmentsform grid[itemId=periodGridWin]':{
	                			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	                				 if(columnName == "documentName"){
	                					 if(e.target.tagName=='A'){
	                						 this.getDownloadFile(record.raw.encryptedDocId);
	                					 }
	                				 }
	                			 }
	                		 },
	                		 'fileattachmentsform button[itemId=downloadAllDocuments]':{
	                			 click:function(obj){
	                				 this.downloadAllDocumentZip();
	                			 }
	                		 },
	                		 'fileassignedattachmentsform button[itemId=btnDelete]':{
	                			 click: this.deleteFileAssignedDocumentRecord
	                		 },
	                		 'fileassignedattachmentsform grid[itemId=periodGridWin]':{
	                			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	                				 if(columnName == "documentName"){
	                					 if(e.target.tagName=='A'){
	                						 this.getDownloadFile(record.raw.encryptedDocId);
	                					 }
	                				 }
	                			 }
	                		 },
	                		 'fileassignedattachmentsform button[itemId=downloadAllDocuments]':{
	                			 click:function(obj){
	                				 this.downloadAllAssignedDocumentZip();
	                			 }
	                		 },
	                		 'managefilesfilter fieldset[itemId=fileMoreFilterId]':{
	                			 expand:function(){
	                                 var filter = this.getManagefilesfilter();
	                                 var checkBox =filter.down('#accessAllFilesItemId');
	                                 checkBox.setVisible(false);
	                                 var associatedAcadLocationIds = new Array();
	        	                	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	        	                	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFILE_MANAGEMENT_PERMISSIONS());
	        	                	 Ext.each(permissionList, function(privilege) {
	        	                		 if (privilege === 'ACCESSALLFILES') {
	        	                			 if(!isNullOrEmpty(checkBox)){
	        	                				 checkBox.setVisible(true);
	        	                			 }        		
	        	                		 }
	        	                	 });

	        	                 
	                			 }
	                		 },
	                		 'managefilesgrid':{
	                			 render:function(grid){
	                				 this.doAccessControlValidation(grid, this.getFILE_MANAGEMENT_PERMISSIONS());
	                				 this.disableMoreActionPivileges(grid,this.getFILE_MANAGEMENT_PERMISSIONS());
	                			 },
	                			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

	                				 if(columnName == "filePath"){
	                					 if(e.target.tagName=='A'){
	                						 this.getFileLocationWindow(grid,record);
	                					 }
	                				 }/*else  if(columnName == "fileNumber"){
	                					 if(e.target.tagName=='A'){
	                						 this.getFileInformationWindow(grid,record);
	                					 }
	                				 }*/else  if(columnName == "academyLocationCount"){
	                					 if(e.target.tagName=='A'){
	                						 this.openAcademyLocationsWindow(columnName, record, cellIndex);
	                					 }
	                				 }else  if(columnName == "attachments"){
	                					 if(e.target.tagName=='A'){
	                						 this.openFileAttachmentWindow(grid,record);
	                					 }
	                				 }
	                			 },
	                			 select:function(obj, record,rowIndex, e){
	                				 this.enableDisableEditBtn();
	                				 this.enableDisableViewBtn();

	                			 },
	                			 deselect:function(obj, record, rowIndex, e){
	                				 this.enableDisableEditBtn();
	                				 this.enableDisableViewBtn();

	                			 }
	                		 }, 
	                		 'manageassignedfilesgrid':{
	                			 render:function(grid){
//	                				 this.doAccessControlValidation(grid, this.getPLACEMENT_JOB_APPLICATION_PERMISSION());
//	                				 this.jobApplicationgridButtonPivileges(grid,this.getPLACEMENT_JOB_APPLICATION_PERMISSION());
	                			 },
	                			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

	                				 if(columnName == "fileNumber"){
	                					 if(e.target.tagName=='A'){
	                						 this.getAssignedFileInformationWindow(grid,record);
	                					 }
	                				 }else if(columnName == "attachments"){
	                					 if(e.target.tagName=='A'){
	                						 this.openFileAssignedAttachmentWindow(grid,record);
	                					 }
	                				 }
	                				 else if(columnName == "academyLocations"){
	                					 if(e.target.tagName=='A'){
	                						 this.openAcademyLocationsWindow(columnName, record, cellIndex);
	                					 }
	                				 }
	                			 }
	                		 },
	                		 'fileuploadmultipledraganddrop':{
	                			 render : function(grid){
	                				 grid.getStore().removeAll();
	                			 }
	                		 },
	                		 'fileuploadmultipledraganddrop filefield[itemId=filefieldDragAndDrop]': {
	                			 change: this.getMultipleFileUpload 
	                		 },
	                		 'fileuploadmultipledraganddrop button[itemId=filefieldUploadto]': {
	                			 click: this.getUploadToFileManagement 
	                		 },
	                		 'fileuploadmultipledraganddrop button[itemId=deletefilefieldUpload]': {
	                			 click: this.getDeleteUpload
	                		 },
	                		 'fileassigneduploadmultipledraganddrop':{
	                			 render : function(grid){
	                				 grid.getStore().removeAll();
	                			 }
	                		 },
	                		 'fileassigneduploadmultipledraganddrop filefield[itemId=filefieldDragAndDrop]': {
	                			 change: this.getAssignedMultipleFileUpload 
	                		 },
	                		 'fileassigneduploadmultipledraganddrop button[itemId=filefieldUploadto]': {
	                			 click: this.getAssignedUploadToFileManagement 
	                		 },
	                		 'fileassigneduploadmultipledraganddrop button[itemId=deletefilefieldUpload]': {
	                			 click: this.getAssignedDeleteUpload
	                		 },
	                		 'fileassigntoform button[itemId=resetBtn]':{
	                			 click: function(obj){
	                				 var $this = this;
	                				 var form = $this.getFileassigntoform();
	                				 form.getForm().reset();
	                				 var store = form.down('#assignedUser').getStore();
	                				 store.getProxy().extraParams = {
	                					 userType: null,
	                					 academyLocationIds: null
	                				 };          
	                				 store.load();
	                				 var assignedUserCombos = Ext.ComponentQuery.query('#assignedUser1');
	                				 if(assignedUserCombos.length>0){
	                					 assignedUserCombos.forEach(function(obj){
	                						 obj.setDisabled(true);
	                					 });
	                				 }
	                			 }
	                		 },
	                		 
	                		 'manageassignedfilestructure':{
	                			 render:function(){
	                				 var $this=this;
	                				 var grid=$this.getManageassignedfilesgrid();
	        	                	 var gridStore=grid.getStore();
	        	                	 gridStore.getProxy().extraParams={
	        	                	 }
	        	                	 $this.resetPageSetting(gridStore);
	        	                	 gridStore.load();
	                			 }
	                		 },
	                	 });
	                 },

	                 checkUniqRecords: function(data) {
	                	 var submitUrl = SERVERURL.CHECK_DUPLICATE_FILE_NUMBER_API+ '?fileNo=' + data;
	                	 var form = this.getAddfileinfoform();
	                	 var grid = this.getManagefilesgrid();
	                     var idField = form.down("#id");

	                     if (!isNullOrEmpty(idField.getValue())) {
	                    	 submitUrl = submitUrl +  '&id=' + idField.getValue();
	                     }	
	                	 
	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: submitUrl,
	                		 method: 'GET',
	                		 success: function(response, action) {
	                			 var responseData = Ext.decode(response.responseText);
	                			 if (responseData.code == 'EXIST') {
	                				 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST')); //no exist
            						 form.down("#fileNumber").reset();
	                			 }
	                			 /*var list=Ext.decode(response.responseText);
	                			 for(var i in list){
	                				 if(list[i].value==data) {
	                					 if (grid.getSelectionModel().getCount() > 0) {
	                						 if(grid.getSelectionModel().getSelection()[0].data.fileNumber==data){

	                						 }else{
	                							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST')); //no exist
	                							 form.down("#fileNumber").setValue(grid.getSelectionModel().getSelection()[0].data.fileNumber);
	                						 }
	                					 }else{
	                						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_IS_ALREADY_EXIST')); //no exist
	                						 form.down("#fileNumber").reset();
	                					 }
	                				 }else{
//	                					 form.down("#fileNumber").reset();
	                				 }
	                			 }*/
	                		 }
	                	 });
	                 },

	                 openUploadDocFormWindow:function(obj){
	                	 var $this=this;
	                	 var grid = $this.getManagefilesgrid();
	                	 var record = grid.getSelectionModel().getSelection();
	                	 var cDate = new Date();
	                	 var rDate =  record[0].data.dueDate;
	                	 if(rDate >= cDate || isNullOrEmpty(rDate)){
	                		 var contentPanel = this.getContentpanel();
	                		 var structure = Ext.widget('fileuploadstructure');
	                		 var tabName = getFileManagementTranslation('UPLOAD_DOCUMENT');

	                		 /**
	                		  * This is to remove tab from content panel and open same tab again
	                		  */
	                		 var getcontroller=this.getController('menu.CoreERPNavigationController');
	                		 var getTab=getcontroller.getTab(tabName);
	                		 var $this=this;
	                		 if(getTab!=null){
	                			 contentPanel.remove(getTab, true);
	                		 }
	                		 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
	                	 } else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getFileManagementTranslation('DUE_DATE_OF_FILE_HAS_ALREADY_PASSED')); 
	                	 }
	                 },
	                 openAssignedUploadDocFormWindow:function(obj){
	                	 var contentPanel = this.getContentpanel();
	                	 var structure = Ext.widget('fileassigneduploadstructure');
	                	 var tabName = getFileManagementTranslation('UPLOAD_DOCUMENT');

	                	 /**
	                	  * This is to remove tab from content panel and open same tab again
	                	  */
	                	 var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	 var getTab=getcontroller.getTab(tabName);
	                	 var $this=this;
	                	 if(getTab!=null){
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
	                 },
	                 enableDisableEditBtn : function() {
	                	 var manageFilesGrid=this.getManagefilesgrid();
	                	 var editBtn = manageFilesGrid.down('#btnEdit');
	                	 if (manageFilesGrid.getSelectionModel().getCount() > 1) {
	                		 editBtn.disable();
	                	 } else {
	                		 editBtn.enable();
	                	 }
	                 },
	                 enableDisableViewBtn : function() {
	                	 var manageFilesGrid=this.getManagefilesgrid();
	                	 var editBtn = manageFilesGrid.down('#btnView');
	                	 if (manageFilesGrid.getSelectionModel().getCount() > 1) {
	                		 editBtn.disable();
	                	 } else {
	                		 editBtn.enable();
	                	 }
	                 },
	                 viewFileInfoForm:function(){
	                	 var $this = this;
	                	 $this.editFileInfoForm();
	                	 var form =  $this.getAddfileinfoform();
	                	 var addFileInfoForm = form.getForm();
	                	 $this.toggleReadOnlyFormItems(addFileInfoForm,true);
	                	 form.down('#submitBtn').setVisible(false);
	                	 form.down('#resetBtn').setVisible(false);
	                 },
	                 openAcademyLocationsWindow:function(title, record, ColIdx){
	                	 var $this = this;
	                	 var formWindow = this.getFileacademylocationswindow();
	                	 if (!formWindow) {
	                		 Ext.widget('fileacademylocationswindow');
	                		 formWindow = this.getFileacademylocationswindow();
	                	 }
	                	 formWindow.show();
	                	 var gridAl = formWindow.down('#alGridItemId');
	                	 var gridAttr = formWindow.down('#attributeGrid');
	                	 gridAttr.hide();
	                	 formWindow.setTitle(getCommonTranslation('ACADEMY_LOCATION'));
	                	 /*var gridStore =  gridAl.getStore();
	                	 gridStore.removeAll();
	                	 var details;
	                	 if(record.data.academyLocations.length != 0){
	                		 for(var i in record.data.academyLocations){
	                			 details={
	                					 'value':record.data.academyLocations[i].value
	                			 };
	                			 gridStore.loadRawData(details, true);
	                		 }
	                	 }*/
	                	 var storeArray = [];
	                	 if(record.data.academyLocations.length != 0){
	                		 for(var i in record.data.academyLocations){
	                			 storeArray.push({'value':record.data.academyLocations[i].value});
	                		 }
	                	 }
					     
					     var store1 = Ext.create('Ext.data.Store', {
					         fields: ['value'],
					         data : storeArray
					     });
					     gridAl.bindStore(store1);
	                 },
	                 deleteFileInfoRecord:function(){
	                	 var $this=this;
	                	 var grid = $this.getManagefilesgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var records = grid.getSelectionModel().getSelection();
	                		 var ids=[];
	                		 Ext.Array.each(records,function(value){
	                			 ids.push(value.data.id);
	                		 });
	                		 showConfirmMessage(getFileManagementTranslation('MANAGE_FILE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                			 if (btn == 'yes'){
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url : SERVERURL.FILE_DELETE_API+'?ids='+ids.join(),
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {
	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getFileManagementTranslation('MANAGE_FILE'),getFileManagementTranslation('FILE_SUCCESS_DELETE_MSG'));	 
	                						 grid.store.reload();
	                					 }
	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	                	 }
	                 },
	                 saveAssignToRecord: function(btn, e, eOpts){

	                	 var $this = this;
	                	 var fileassigntoform = $this.getFileassigntoform();
	                	 var form = fileassigntoform.getForm();
	                	 var values = form.getValues();

	                	 var grid = $this.getManagefilesgrid();
	                	 var record = grid.getSelectionModel().getSelection();
	                	 var fileAssignToJsonData = this.getFileAssignToJson(form,record);
	                	 // fileAssignToJsonData.id=values.id;

	                	 var submitUrl; 
	                	 var message;
	                	 
	                	 var contentpanel = $this.getContentpanel();
            			 var getcontroller = $this.getController('menu.CoreERPNavigationController');
            			 var getTab = getcontroller.getTab(contentpanel.getActiveTab().title);

	                	 if(!isNullOrEmpty(values.id)){
	                		 submitUrl = SERVERURL.FILE_ASSIGN_EDIT; 
	                		 message = getFileManagementTranslation('FILE_ASSIGN_CREATED_SUCCESSFULLY');
	                	 }
	                	 else{
	                		 submitUrl = SERVERURL.FILE_ASSIGN_CREATE; 
	                		 message = getFileManagementTranslation('FILE_ASSIGN_CREATED_SUCCESSFULLY');
	                	 }

	                	 var submitJsonData = Ext.encode(fileAssignToJsonData);

	                	 console.log('submitJsonData',submitJsonData);
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : submitJsonData,
	                		 method : 'POST',
	                		 success : function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 grid.getStore().reload(); 
	                			 if(isNullOrEmpty(values.id)){
	                				 form.reset();
	                			 }
	                			 
	                			 /**
		                		  * This is to remove tab from content panel
		                		  */
	                			 if (getTab != null) {
	                				 contentpanel.remove(getTab, true);
	                			 }
	                			 showSuccessMessage(getFileManagementTranslation('ASSIGN_TO'), message);
	                		 },
	     	                failure: function(form, action) {
	    	                	Ext.getBody().unmask();
	    	                	//showSuccessMessage(getFileManagementTranslation('ASSIGN_TO'), message);
	    	                	//btn.firstTimeFired = false;
	    	                }
	                	 });
	                	 e.preventDefault();
	                 },
	                 submitFileUpdateStatusRecord: function(){
	                	 var $this = this;
	                	 var fileupdatestatuswin = $this.getFileupdatestatuswin();
	                	 var grid = $this.getManagefilesgrid();
	                	 var getForm = fileupdatestatuswin.down('form').getForm();
	                	 var value = getForm.getValues();
	                	 var rec = grid.getSelectionModel().getSelection();
	                	 var arr=[];
	                	 for(var i in rec) {
	                		 var jsonObj={
	                				 "id": rec[i].data.id,
	                				 "currentStatus":value.fileStatus,
	                				 "updateReason":value.reasonUpdate,
	                				 "statusChangeDate":value.startDate
	                		 }
	                		 arr.push(jsonObj);
	                	 }
	                	 var submitUrl; 
	                	 var message;
	                	 submitUrl = SERVERURL.FILE_UPDATE_STATUS; 
	                	 message = getFileManagementTranslation('FILE_INFO_STATUS_UPDATED_SUCCESSFULLY');
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : arr,
	                		 method : 'POST',
	                		 success : function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 grid.getStore().reload(); 
	                			 if(isNullOrEmpty(value.id)){
	                				 getForm.reset();
	                			 }
	                			 $this.getFileupdatestatuswin().close();  
	                			 showSuccessMessage(getFileManagementTranslation('UPDATE_STATUS'), message);

	                		 }
	                	 });
	                 },
	                 submitFileInformationRecord: function(){
	                	 var $this = this;
	                	 var fileinformationform = $this.getFileinformationform();
	                	 var grid = $this.getManageassignedfilesgrid();
	                	 var getForm = fileinformationform.getForm();
	                	 var value = getForm.getValues();
	                	 var rec = grid.getSelectionModel().getSelection();
	                	 var jsonObj1={
	                			 "fileHandoverBy": $this.getIdValueJson(value.fileHandoverById),
	                			 // "assignedUserId": $this.getIdValueJson(rec[i].data.assignedUserId),
	                			 // "assignmentDate": rec[i].data.assignmentDate, 
	                			 "receivedDate": value.receivedDate, 
	                			 "returnDate": value.returningDate, 
	                			 "resubmissionDueDate": value.resubmissionDueDate, 
	                			 "returnReason": value.returnReason,
	                			 "id": rec[0].data.id 
	                	 }
	                	 var submitUrl; 
	                	 var message;
	                	 submitUrl = SERVERURL.UPDATE_FILE_ASSIGNMENT; 
	                	 message = getFileManagementTranslation('FILE_INFO_UPDATED_SUCCESSFULLY');
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : jsonObj1,
	                		 method : 'POST',
	                		 success : function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 grid.getStore().reload(); 
	                			 grid.getSelectionModel().deselectAll(true);

	                			 if(isNullOrEmpty(value.id)){
	                				 getForm.reset();
	                			 }
	                			 showSuccessMessage(getFileManagementTranslation('FILE_INFORMATION'), message);
	                			 var tabName = getFileManagementTranslation('FILE_INFORMATION');
	                			 var contentPanel = $this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	                			 var contentXtype ='fileinfomanageform';
	                			 var newTab = $this.getTabReferenceByTabTitle(tabName);
	                			 var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                			 var getTab=getcontroller.getTab(tabName);
	                			 if(getTab!=null){
	                				 contentPanel.remove(getTab, true);
	                			 }			
	                		 }
	                	 });
	                 },
	                 saveFileForwardRecord: function(){
	                	 var $this = this;
	                	 var fileforwardwin = $this.getFileforwardwin();
	                	 var form = fileforwardwin.down('form');
	                	 var values = form.getValues();

	                	 var grid = $this.getManageassignedfilesgrid();
	                	 var record = grid.getSelectionModel().getSelection();
	                	 var fileAssignToJsonData = this.getFowradFileJson(form,record);
	                	 // fileAssignToJsonData.id=values.id;
	                	 var submitUrl = SERVERURL.FORWARD_FILE_API; 
	                	 var message = getFileManagementTranslation('FILE_FORWARDED_SUCCESSFULLY');
	                	 var submitJsonData = Ext.encode(fileAssignToJsonData);

	                	 console.log('submitJsonData',submitJsonData);
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : submitJsonData,
	                		 method : 'POST',
	                		 success : function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 grid.getStore().reload(); 
	                			 if(isNullOrEmpty(values.id)){
	                				 //form.reset();
	                			 }
	                			 fileforwardwin.close();
	                			 showSuccessMessage(getFileManagementTranslation('FORWARD_FILE'), message);

	                		 }
	                	 });
	                 },
	                 saveFileInfoRecord: function(){

	                	 var $this = this;
	                	 var addFileInfoForm = $this.getAddfileinfoform();
	                	 var grid = $this.getManagefilesgrid();
	                	 var form = addFileInfoForm.getForm();
	                	 var value = form.getValues();

	                	 var fileRecord = value.fileAcademyLocations;
	                	 var myArray=[];
	                	 for(var i in fileRecord){
	                		 if(Ext.isObject(fileRecord[0])){
	                			 myArray.push({"id": fileRecord[i].get('id')});
	                		 }else{
	                			 myArray.push({"id": fileRecord[i]})
	                		 }
	                	 }

	                	 value.fileAcademyLocations = myArray;
//	                	 value.currentStatus={"id":1}

	                	 var submitUrl; 
	                	 var formData = value;
	                	 var message;
	                	 if(!isNullOrEmpty(value.id)){
	                		 submitUrl = SERVERURL.FILE_INFO_UPDATE; 
	                		 //formData.id = grid.getSelectionModel().getSelection()[0].data.id;
	                		 formData.id = value.id;
	                		 message = getFileManagementTranslation('FILE_INFO_UPDATED_SUCCESSFULLY')
	                	 }
	                	 else{
	                		 submitUrl = SERVERURL.FILE_INFO_SAVE; 
	                		 message = getFileManagementTranslation('FILE_INFO_CREATED_SUCCESSFULLY');
	                	 }
	                	 //Ext.encode(filemanagementmodel.data);
	                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                	 Ext.Ajax.request({
	                		 type : 'rest',
	                		 url : submitUrl,
	                		 jsonData : formData,
	                		 method : 'POST',
	                		 success : function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 if(!isNullOrEmpty(grid)){
	                				 grid.getStore().reload(); 
		                			 grid.getSelectionModel().deselectAll(true);
	                			 }
	                			 form.reset();
	                			 /**
		                		  * This is to remove tab from content panel
		                		  */
	                			 var contentpanel = $this.getContentpanel();
	                			 var getcontroller = $this.getController('menu.CoreERPNavigationController');
	                			 var getTab = getcontroller.getTab($this.getContentpanel().getActiveTab().title);
	                			 
	                			 var manageFileTabName = getMegaMenuTranslation('TS_MANAGEMENT_FILE');
	                			 var getManageFileTabName = getcontroller.getTab(manageFileTabName);
	                			 if (getTab != null) {
	                				 contentPanel.remove(getTab, true);
	                			 }
	                			 if (getManageFileTabName != null) {
	                				 contentPanel.setActiveTab(getManageFileTabName);
	                			 }
	                			 
	                			 showSuccessMessage(getFileManagementTranslation('FILE_INFORMATION'), message);
	                		 }
	                	 });

	                 },         //************* edit File Info details records********************
	                 editFileInfoForm:function(){
	                	 var $this = this;
	                	 var grid = $this.getManagefilesgrid();

	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 $this.openAddFileInfoForm();
	                		 var addfileinfoform = $this.getAddfileinfoform();
	                		 addfileinfoform.down('#resetBtn').setVisible(false);
	                		 var record = grid.getSelectionModel().getSelection()[0];
	                		 var efileid = record.get("id");
	                		 var form = addfileinfoform.getForm();

	                		 //var fileDetails = new Academia.model.filemanagement.ManageFileModel(records);
	                		 addfileinfoform.down('#fileNumber').setValue(record.data.fileNumber);
	                		 addfileinfoform.down('#fileSubject').setValue(record.data.fileSubject);
	                		 addfileinfoform.down('#dueDate').setValue(dateRender(record.data.dueDate));
	                		 addfileinfoform.down('#otherDetail').setValue(record.data.otherDetail);
	                		 addfileinfoform.down('#creationDate').setValue(dateRender(record.data.creationDate));
	                		 addfileinfoform.down('#remarks').setValue(record.data.remarks);
	                		 addfileinfoform.down('#id').setValue(record.get("id"));
	                		 //addfileinfoform.loadRecord(fileDetails);

	                		 var fileType =  form.findField("fileType");
	                		 fileType.getStore().load({
	                			 callback: function(records, operation, success) {
	                				 for(var i in records){
	                					 if(records[i].data.value==record.data.fileType){
	                						 fileType.setValue(records[i].data.id);
	                					 }
	                				 }

	                			 }
	                		 });

	                		 var fileOwner =  form.findField("fileOwner");
	                		 fileOwner.getStore().load({
	                			 callback: function(records, operation, success) {
	                				 for(var i in records){
	                					 if(records[i].data.id==record.data.fileOwnerId){
	                						 fileOwner.setValue(records[i].data.id);
	                					 }
	                				 }

	                			 }
	                		 });

	                		 var priority =  form.findField("priority");
	                		 priority.getStore().load({
	                			 callback: function(records, operation, success) {
	                				 for(var i in records){
	                					 if(records[i].data.value==record.data.priority){
	                						 priority.setValue(records[i].data.id);
	                					 }
	                				 }

	                			 }
	                		 });
	                		 var academyLocations =  form.findField("fileAcademyLocations");
	                		 academyLocations.getStore().load({
	                			 callback: function(records, operation, success) {
	                				 var arr=[];
	                				 for(var i in records){
	                					 for(var j in record.data.academyLocations){
	                						 if(record.data.academyLocations[j].value==records[i].data.value){
	                							 arr.push(records[i].data.id)
	                						 }
	                					 }
	                					 academyLocations.setValue(arr);
	                				 }
	                			 }
	                		 });
	                		 Ext.Ajax.request({
	                        	 type: 'rest',
	                        	 url: SERVERURL.FIND_WHETHER_CONFIGORNOT_DATA_SETTING_FOR_COMMON+'?tableName=file_info',
	                        	 method: 'GET',
	                        	 headers : {
	                        		 'Content-Type' : 'application/json'
	                        	 },
	                        	 success: function(response, action) {
	                              var data = response.responseText;
	                              if(data == "true"){
	                            	  form.findField('fileNumber').setReadOnly(false);
	                      	    	 // form.findField('fileNumber').allowBlank = false;  
	                              }else{
	                            	  form.findField('fileNumber').setReadOnly(true);
	                      	    	 // form.findField('fileNumber').allowBlank = true; 
	                              }                        
	                        	 }
	                         });
	                	 }else{
	                		 showWarningMessage(getFileManagementTranslation('EDIT_FILE_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                	 }
	                 },
	                 ShowFileAssignToTab:function(){
	                	 var $this=this;
	                	 var grid = $this.getManagefilesgrid();
	                	 var record = grid.getSelectionModel().getSelection();
	                	 var cDate = new Date();
	                	 var  rDate =  record[0].data.dueDate;
	                	 if(rDate >= cDate || isNullOrEmpty(rDate)){
	                		 var tabName = getFileManagementTranslation('ASSIGN_TO');
	                		 var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	                		 var structure = Ext.widget('fileassigntoform');
	                		 /**
	                		  * This is to remove tab from content panel and open same tab again
	                		  */
	                		 var getcontroller=this.getController('menu.CoreERPNavigationController');
	                		 var getTab=getcontroller.getTab(tabName);
	                		 if(getTab!=null){
	                			 contentPanel.remove(getTab, true);
	                		 }

	                		 structure.down('#dueDate').setMaxValue(dateRender(record[0].data.dueDate));
	                		 structure.down('#dueDate').setMinValue(dateRender(record[0].data.creationDate));
	                		 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
	                	 }else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getFileManagementTranslation('DUE_DATE_OF_FILE_HAS_ALREADY_PASSED')); 
	                	 }
	                 },
	                 ShowFileUpdateStatusWin:function(record){
	                	 var $this=this;
	                	 var frmWin = $this.getFileupdatestatuswin();
	                	 var grid = $this.getManagefilesgrid();
	                	 var record = grid.getSelectionModel().getSelection();
	                	 var cDate = new Date();
	                	 var rDate =  record[0].data.dueDate;
	                	 if(rDate >= cDate || isNullOrEmpty(rDate)){
	                		 if(!frmWin){
	                			 structure =  Ext.widget('fileupdatestatuswin');
	                			 frmWin = $this.getFileupdatestatuswin();
	                			 var fileUpload = structure.down('#startDate').setMinValue(new Date(record[0].data.creationDate));
	                		 }
	                		 frmWin.show();
	                	 }else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getFileManagementTranslation('DUE_DATE_OF_FILE_HAS_ALREADY_PASSED')); 
	                	 }
	                 },
	                 ShowFileForwardWin:function(record){
	                	 var frmWin = this.getFileforwardwin();
						var contentPanelActiveTab = this.getContentpanel().getActiveTab();
	                				 var manageAssignedFilesGrid = contentPanelActiveTab.down('manageassignedfilesgrid');
	                	 var record = manageAssignedFilesGrid.getSelectionModel().getSelection()[0];
	                	 if(!frmWin){
	                		structure =  Ext.widget('fileforwardwin');
	                		structure.down('#assignmentDate').setMinValue(new Date(record.data.assignmentDate));
	                		 frmWin = this.getFileforwardwin();
	                	 }
	                	 frmWin.show();
	                 },
	                 cancelFileUpdateStatusWin:function(){
	                	 this.getFileupdatestatuswin().close();  
	                 },
	                 cancelFileForwardWin:function(){
	                	 this.getFileforwardwin().close();  
	                 },
	                 getFileLocationWindow:function(record){
	                	 var frmWin = this.getCurrentfilelocationwindow();
	                	 if(!frmWin){
	                		 Ext.widget('currentfilelocationwindow');
	                		 frmWin = this.getCurrentfilelocationwindow();
	                	 }
	                	 var manageFilesGrid=this.getManagefilesgrid();
	                	 var record = manageFilesGrid.getSelectionModel().getSelection()[0];
	                	 var dueDateField = record.data.dueDate;
	                	 frmWin.down('#fileNumber').setValue(record.data.fileNumber);
	                	 frmWin.down('#assignmentDate').setValue(dateRender(record.data.creationDate));
	                	 frmWin.down('#dueDate').setValue(dateRender(dueDateField));
	                	 var gridStore=frmWin.down('grid').getStore();
	                	 gridStore.getProxy().extraParams={
	                		 fileInfoId:record.data.id
	                	 }
	                	 gridStore.load();
	                	 //formWindow = this.getCurrentfilelocationwindow();
	                	 frmWin.show();
	                 },
	                 openFileAttachmentWindow:function(record){
	                	 var frmWin = this.getFileattachmentsform();
	                	 if(!frmWin){
	                		 Ext.widget('fileattachmentsform');
	                		 frmWin = this.getFileattachmentsform();
	                	 }
	                	 var manageFilesGrid=this.getManagefilesgrid();
	                	 var record = manageFilesGrid.getSelectionModel().getSelection()[0];

	                	 frmWin.down('#fileNumber').setValue(record.data.fileNumber);
	                	 frmWin.down('#fileOwner').setValue(record.data.fileOwner);
	                	 var gridStore=frmWin.down('grid').getStore();
	                	 gridStore.getProxy().extraParams={
	                		 fileId:record.data.id
	                	 }
	                	 gridStore.load();
	                	 //formWindow = this.getCurrentfilelocationwindow();
	                	 frmWin.show();
	                 },
	                 openFileAssignedAttachmentWindow:function(grid,record){
	                	 var frmWin = this.getFileassignedattachmentsform();
	                	 if(!frmWin){
	                		 Ext.widget('fileassignedattachmentsform');
	                		 frmWin = this.getFileassignedattachmentsform();
	                	 }
	                	 var manageAssignedFilesGrid=this.getManageassignedfilesgrid();
	                	 var record = grid.getSelectionModel().getSelection()[0];

	                	 frmWin.down('#fileNumber').setValue(record.data.fileNumber);
	                	 frmWin.down('#fileOwner').setValue(record.data.fileOwner);
	                	 var gridStore=frmWin.down('grid').getStore();
	                	 gridStore.getProxy().extraParams={
	                		 fileId:record.data.fileInfoId
	                	 }
	                	 gridStore.load();
	                	 //formWindow = this.getCurrentfilelocationwindow();
	                	 frmWin.show();
	                 },
	                 getFileInformationWindow:function(record){
	                	 var $this=this;
	                	 var tabName = getFileManagementTranslation('FILE_INFORMATION');
	                	 var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	                	 // var structure = Ext.widget('fileinformationstructure');

	                	 var contentXtype ='fileinfomanageform';
	                	 var newTab = $this.getTabReferenceByTabTitle(tabName);
	                	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                	 var getTab=getcontroller.getTab(tabName);
	                	 if(getTab!=null){
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 if(!newTab){
	                		 newTab = contentPanel.add({
	                			 xtype: contentXtype,
	                			 closable: true,
	                			 title: tabName,
	                			 menuColorCls: CONSTANTS.MENU_COLOR_NINE
	                		 });
	                	 }
	                	 contentPanel.setActiveTab(newTab);
	                	 var manageFilesGrid=this.getManagefilesgrid();
	                	 var record = manageFilesGrid.getSelectionModel().getSelection()[0];
	                	 var infoForm = $this.getFileinformationform();
	                	 Ext.defer(function() {
	                		 infoForm.down('#assignedUserName').setValue(record.data.fileOwner);
	                		 infoForm.down('#assignmentDate').setValue(dateRender(record.data.assignmentDate));
	                		 infoForm.down('#dueDate').setValue(dateRender(record.data.dueDate));
	                		 infoForm.down('#receivedDate').setValue(dateRender(record.data.receivedDate));
	                		 if(!isNullOrEmpty(record.data.returningDate)){
	                			 infoForm.down('#returnClarification').setValue(true);
	                			 infoForm.down('#resubmissionDueDate').setValue(dateRender(record.data.reSubmissionDate));
	                			 infoForm.down('#returningDate').setValue(dateRender(record.data.returningDate));
	                			 infoForm.down('#returnReason').setValue(record.data.returnReason);
	                		 }
	                		 var infoFormPanel = $this.getFileinfodetailpanel();
	                		 infoFormPanel.down('#fileType').setValue(record.data.fileType);
	                		 infoFormPanel.down('#fileNumber').setValue(record.data.fileNumber);
	                		 infoFormPanel.down('#fileSubject').setValue(record.data.fileSubject);
	                		 infoFormPanel.down('#intDate').setValue(dateRender(record.data.creationDate));
	                		 infoFormPanel.down('#dueDate').setValue(dateRender(record.data.dueDate));
	                		 infoFormPanel.down('#priority').setValue(record.data.priority);



	                		 if(!isNullOrEmpty(record.data.attachments.length)) {
	                			 if(record.data.attachments.length>1) {
	                				 infoFormPanel.down('#attachments').setValue("<a href='#'>"+record.data.attachments.length+'</a>');
	                			 } else if(record.data.attachments.length==1) {
	                				 infoFormPanel.down('#attachments').setValue("<a href='#'>"+record.data.attachments[0].value+'</a>');
	                			 } else{
	                				 infoFormPanel.down('#attachments').setValue('0');
	                			 }

	                		 }

	                		 var fileHandoverById =  infoForm.down("#fileHandoverById");
	                		 fileHandoverById.getStore().load({
	                			 callback: function(records, operation, success) {
	                				 for(var i in records){
	                					 if(records[i].data.id==record.data.fileHandoverById){
	                						 fileHandoverById.setValue(records[i].data.id);
	                					 }
	                				 }
	                			 }
	                		 });

	                	 }, 80, this);
	                 },
	                 getAssignedFileInformationWindow:function(record){
	                	 var $this=this;
	                	 var tabName = getFileManagementTranslation('FILE_INFORMATION');
	                	 var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
	                	 // var structure = Ext.widget('fileinformationstructure');

	                	 var contentXtype ='fileinfomanageform';
	                	 var newTab = $this.getTabReferenceByTabTitle(tabName);
	                	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                	 var getTab=getcontroller.getTab(tabName);
	                	 if(getTab!=null){
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 if(!newTab){
	                		 newTab = contentPanel.add({
	                			 xtype: contentXtype,
	                			 closable: true,
	                			 title: tabName,
	                			 menuColorCls: CONSTANTS.MENU_COLOR_NINE
	                		 });
	                	 }
	                	 contentPanel.setActiveTab(newTab);
	                	 var manageAssignedFilesGrid=this.getManageassignedfilesgrid();
	                	 var record = manageAssignedFilesGrid.getSelectionModel().getSelection()[0];
	                	 var infoForm = $this.getFileinformationform();
	                	 Ext.defer(function() {
	                		 infoForm.down('#assignedUserName').setValue(record.data.fileOwner);
	                		 infoForm.down('#assignmentDate').setValue(dateRender(record.data.assignmentDate));
	                		 infoForm.down('#dueDate').setValue(dateRender(record.data.dueDate));
	                		 if(!isNullOrEmpty(record.data.assignmentDate)) {
	                			 infoForm.down('#receivedDate').setMinValue(dateRender(record.data.assignmentDate));
	                		 }
	                		 if(!isNullOrEmpty(record.data.receivedDate)) {
	                			 infoForm.down('#receivedDate').setValue(dateRender(record.data.receivedDate));
	                		 }
	                		 if(!isNullOrEmpty(record.data.returningDate)){
	                			 infoForm.down('#returnClarification').setValue(true);
	                			 infoForm.down('#resubmissionDueDate').setValue(dateRender(record.data.reSubmissionDate));
	                			 infoForm.down('#returningDate').setValue(dateRender(record.data.returningDate));
	                			 infoForm.down('#returnReason').setValue(record.data.returnReason);
	                		 }
	                		 var infoFormPanel = $this.getFileinfodetailpanel();
	                		 infoFormPanel.down('#fileType').setValue(record.data.fileType);
	                		 infoFormPanel.down('#fileNumber').setValue(record.data.fileNumber);
	                		 infoFormPanel.down('#fileSubject').setValue(record.data.fileSubject);
	                		 infoFormPanel.down('#intDate').setValue(dateRender(record.data.creationDate));
	                		 infoFormPanel.down('#dueDate').setValue(dateRender((record.data.dueDate)));
	                		 infoFormPanel.down('#priority').setValue(record.data.priority);

	                		 if(!isNullOrEmpty(record.data.attachments.length)) {
	                			 if(record.data.attachments.length>1) {
	                				 infoFormPanel.down('#attachments').setValue("<a href='#'>"+record.data.attachments.length+'</a>');
	                			 } else if(record.data.attachments.length==1) {
	                				 infoFormPanel.down('#attachments').setValue("<a href='#'>"+record.data.attachments[0].value+'</a>');
	                			 } else{
	                				 infoFormPanel.down('#attachments').setValue('0');
	                			 }

	                		 }

	                		 var fileHandoverById =  infoForm.down("#fileHandoverById");
	                		 fileHandoverById.getStore().load({
	                			 callback: function(records, operation, success) {
	                				 for(var i in records){
	                					 if(records[i].data.id==record.data.fileHandoverById){
	                						 fileHandoverById.setValue(records[i].data.id);
	                					 }
	                				 }
	                			 }
	                		 });
	                		 if(record.data.acknowledgement=='RETURNED_FOR_CLARIFICATION') {
	                			 var form =  $this.getFileinformationform();
	                			 form.down('#SubmitBtn').setVisible(false);
	                			 form.down('#resetBtn1').setVisible(false);
	                		 }
	                	 }, 50, this);
	                 },
	                 /**
	                  * Add multiple Job Location Detail filter in panel
	                  */
	                 addMultipleUserFilter:function(obj){
	                	 var $this = this;
	                	 var stopContiner = $this.getFileassigntoform().down('#fileAssignContainerId');
	                	 // var timeFieldsCount = stopContiner.items.length;
	                	 var panelItem = new Array();
	                	 var fieldContainer=obj.up('fieldcontainer');
	                	 var newcont=stopContiner.items.items.length;
	                	 var insertPosition=newcont+1;
	                	 panelItem.push({
	                		 xtype : 'fieldcontainer',
	                		 width: '100%',
	                		 layout : 'hbox',
	                		 defaults: {
	                			 width:226,
	                			 labelAlign: 'top'
	                		 },
	                		 items : [{
	                			 xtype: 'customcombobox',
	                			 name: 'userType',
	                			 itemId: 'userType1',
	                			 editable: true,
	                			 valueField: 'id',
	                			 displayField: 'userGroupName',
	                			 //allowBlank:false,
	                			 store: 'attendance.UserGroup',
	                			 listeners:{
	                				 select: function(obj,records, eOpts){
	                					 $this.selectUserTypeInCtl(obj,records, eOpts, $this);
		                			 }
	                			 }
	                		 },{
	                			 xtype: 'customcombobox',
	                			 name:'assignedUser',
	                			 itemId:'assignedUser1',
//	                			 store: 'hostel.roomallocation.UserSmartSearchByUserType',
	                			 msgTarget: 'qtip',
	                			 valueField: 'id',
	                			 displayField: 'valueCode',
	                			 queryParam:'codeOrName',
	                			 minChars:3,
	                			 //allowBlank: false,
	                			 disabled:true,
	                			 typeAhead:false,
	                			 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	                			 enableKeyEvents  : 'true',
	                			 hideTrigger:false,
	                			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                			 triggerAction: '',
	                			 forceSelection:true,
	                			 listeners:{
	                				 render : function(combo){
	                					 var store=Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
	                					 combo.bindStore(store)
	                				 }
	                			 },
	                			 listConfig: {
	                				 listeners: {
	                					 beforeshow: function(picker) {
	                						 picker.minWidth = picker.up('combobox').getSize().width;
	                					 }
	                				 },
	                				 loadingText: getCommonTranslation('SEARCHING'),
	                				 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                				 getInnerTpl: function() {
	                					 return '<div class="search-item">' +
	                					 '{value}' +
	                					 '</div>';
	                				 }
	                			 }
	                		 },{
	                			 xtype:'fieldcontainer',
	                			 items:[{
	                				 xtype: 'button',
	                				 itemId: 'delFilterBtn',
	                				 cls: 'CustomBodyBtnReject',
	                				 glyph: ICONGLYPH.DELETEGLYPH,
	                				 tooltip: getCommonTranslation('DELETE'),
	                				 listeners:{
	                					 click:function(obj){
	                						 var container = obj.up('fieldcontainer').up('fieldcontainer');
	                						 var panelContiner = $this.getFileassigntoform().down('#fileAssignContainerId');
	                						 panelContiner.remove(container);
	                						 /*var userType = container.up('form').down('#userType');
	                						 userType.allowBlank(true);
	                						 var userType = container.up('form').down('#assignedUser');
	                						 userType.allowBlank(true);
	                						 container.up('form').isValid();*/
	                					 }}
	                			 },{
	                				 xtype: 'button',
	                				 itemId: 'addFilterBtn',
	                				 cls: 'CustomBodyBtnSettings',
	                				 text: getCommonTranslation('ADDBUTTONTEXT'),
	                				 tooltip: getCommonTranslation('ADD')
	                			 }]
	                		 }]
	                	 });
	                	 stopContiner.insert(insertPosition,panelItem);
	                	 stopContiner.doLayout();
	                 },
	                 loadManageFilesGrid : function(obj,records){
	                	 var $this=this;
	                	 var manageFilesForm=$this.getManagefilesfilter();
	                	 var formValues = manageFilesForm.getValues();
	                	 var grid=$this.getManagefilesgrid();
	                	 var gridStore=grid.getStore();
	                	 var fileNumber=manageFilesForm.down("#fileNoId");
	                	 gridStore.getProxy().extraParams={
	                		 fileTypeId:formValues.fileType,
	                		 fileNo:fileNumber.getRawValue(),
	                		 fileOwnerId:formValues.fileOwner,
	                		 currentStatus:formValues.fileStatus,
	                		 priorityId:formValues.priority,
	                		 acknowledgement:formValues.acknowledgment,
	                		 creationFromDate:formValues.creation_fromDate,
	                		 creationToDate:formValues.creation_toDate,
	                		 dueFromDate:formValues.due_fromDate,
	                		 dueToDate:formValues.due_toDate,
	                		accessallfiles : formValues.accessAllFiles
	                	 }
	                	 $this.resetPageSetting(gridStore);
	                	 gridStore.load();
	                	 /*pdf & excel report header filter*/
	          	         grid.config.searchFilterForm = manageFilesForm;
	                 },
	                 loadManageAssignedFilesGrid : function(obj,records){
	                	 var $this=this;
	                	 var manageFilesForm=$this.getManageassignedfilesfilter();
	                	 var formValues = manageFilesForm.getValues();
	                	 var grid=$this.getManageassignedfilesgrid();
	                	 var gridStore=grid.getStore();
	                	 var fileNumber=manageFilesForm.down("#fileNoId");
	                	 gridStore.getProxy().extraParams={
	                		 fileTypeId:formValues.fileType,
	                		 fileNo:fileNumber.getRawValue(),
	                		 fileOwnerId:formValues.fileOwner,
	                		 currentStatus:formValues.fileStatus,
	                		 priorityId:formValues.priority,
	                		 acknowledgement:formValues.acknowledgment,
	                		 creationFromDate:formValues.creationFromDate,
	                		 creationToDate:formValues.creationToDate,
	                		 dueFromDate:formValues.due_fromDate,
	                		 dueToDate:formValues.due_toDate
	                	 }
	                	 $this.resetPageSetting(gridStore);
	                	 gridStore.load();
	                	 grid.config.searchFilterForm = manageFilesForm;
	                 },
	                 openAddFileInfoForm :function(){
	                	 var $this=this;
	                	 var tabName = getFileManagementTranslation('FILE_INFORMATION');
	                	 var contentPanel = $this.getContentpanel();
	                	 var addFileInfo = Ext.widget('addfileinfostructure');
	                	 //var manageFilePenal=this.getManagefilestructure();
	                	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                	 var getTab=getcontroller.getTab(tabName);
	                	 if(getTab!=null){
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 openTab(contentPanel, tabName, addFileInfo,CONSTANTS.MENU_COLOR_NINE);
	                 },
	                 getFileAssignToJson:function(form,record){
	                	 var $this = this;
	                	 var value = form.getValues();

	                	 var fileHandoverByArray=[];
	                	 var assignedUserArray=[];
	                	 var finalJsonArray = [];
	                	 var obj = new Object();

	                	 var isArr = isArray(value["assignedUser"]);
	                	 if (isArr == true) {
	                		 for (var i = 0; i < value["assignedUser"].length; i++) {
	                			 if(!isNullOrEmpty(value["assignedUser"][i])){
	                				 //fileHandoverByArray.push($this.getIdValueJson(value["fileHandoverBy"][i]));
	                				 assignedUserArray.push($this.getIdValueJson(value["assignedUser"][i]));
	                			 }
	                		 }
	                	 }else{
	                		 // fileHandoverByArray.push($this.getIdValueJson(value.fileHandoverBy));
	                		 assignedUserArray.push($this.getIdValueJson(value.assignedUser));
	                	 }

	                	 for(var j in record){
	                		 finalJsonArray.push({
	                			 //"fileHandoverByList":fileHandoverByArray,
	                			 "assignedUserList":assignedUserArray,
	                			 "assignmentDate":value.assignmentDate,
	                			 "dueDate":value.dueDate,
	                			 "remarks":value.remarks,
	                			 "fileInfo": $this.getIdValueJson(record[j].get('id'))
	                		 });
	                	 }

	                	 return finalJsonArray;	
	                 },

	                 getFowradFileJson:function(form,record){
	                	 var $this = this;
	                	 var value = form.getValues();
	                	 var finalJsonArray=[];
	                	 for(var j in record){
	                		 finalJsonArray.push({
	                			 "fileHandoverBy":$this.getIdValueJson(value.fileHandoverBy),
	                			 "assignedUser":$this.getIdValueJson(value.assignedUser),
	                			 "assignmentDate":value.assignmentDate,
	                			 "dueDate":value.dueDate,
	                			 "remarks":value.remarks,
	                			 "id": record[j].get('id')
	                		 });
	                	 }

	                	 return finalJsonArray;	
	                 },
	                 /**
	                  * create id value json object
	                  */
	                 getIdValueJson: function(id, value) {
	                	 if (id) return {
	                		 id: id,
	                		 value: value
	                	 };
	                 },
	                 getMultipleFileUpload : function(fileField, value, eOpts){
	                	 var grid = this.getFileUploadMultipleDragAndDrop();
	                	 var store = grid.getStore();

	                	 value = value.replace('C:\\fakepath\\', '');
	                	 var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                	 var file = fileField.fileInputEl.dom.files[0];
	                	 var size = fileField.fileInputEl.dom.files[0].size;
	                	 store.add({
	                		 file:file,
	                		 name: file.name,
	                		 size: file.size,
	                		 status: 'Ready'
	                	 });
	                	 fileField.reset();
	                	 
	                 },
	                 getUploadToFileManagement : function(){
	                	 var $this = this;
	                	 var contentPanel = this.getContentpanel();
	                	 var fileInfoId =  contentPanel.getFileInfoId();
	                	 var grid = this.getFileUploadMultipleDragAndDrop();
	                	 var store = grid.getStore();
	                	 for (var i = 0; i < store.data.items.length; i++) {
	                		 $this.postDocumentToServer(grid,store, i,fileInfoId);
	                	 }
	                 },
	                 deleteFileDocumentRecord:function(){
	                	 var $this=this;
	                	 var form = $this.getFileattachmentsform();
	                	 var manageFileGrid = this.getManagefilesgrid();
	                	 var documentGrid=form.down('#periodGridWin');
	                	 if (documentGrid.getSelectionModel().getCount() > 0) {
	                		 var records = documentGrid.getSelectionModel().getSelection();
	                		 var ids=[];
	                		 Ext.Array.each(records,function(value){
	                			 ids.push(value.data.id);
	                		 });
	                		 showConfirmMessage(getFileManagementTranslation('MANAGE_FILE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                			 if (btn == 'yes'){
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url : SERVERURL.FILE_DOCUMENT_DELETE_API+'?fileDocumentIds='+ids.join(),
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {

	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getFileManagementTranslation('MANAGE_FILE'),getFileManagementTranslation('FILE_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	                						 documentGrid.store.reload();
	                						 manageFileGrid.store.reload();
	                						 manageFileGrid.getSelectionModel().deselectAll(true);
	                					 }
	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	                	 }
	                 },
	                 deleteFileAssignedDocumentRecord:function(){
	                	 var $this=this;
	                	 var form = $this.getFileassignedattachmentsform();
	                	 var manageAssignedFileGrid = this.getManageassignedfilesgrid();
	                	 var documentGrid=form.down('#periodGridWin');
	                	 if (documentGrid.getSelectionModel().getCount() > 0) {
	                		 var records = documentGrid.getSelectionModel().getSelection();
	                		 var ids=[];
	                		 Ext.Array.each(records,function(value){
	                			 ids.push(value.data.id);
	                		 });
	                		 showConfirmMessage(getFileManagementTranslation('MANAGE_FILE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                			 if (btn == 'yes'){
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url : SERVERURL.FILE_DOCUMENT_DELETE_API+'?fileDocumentIds='+ids.join(),
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {

	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getFileManagementTranslation('MANAGE_FILE'),getFileManagementTranslation('FILE_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	                						 documentGrid.store.reload();
	                						 manageAssignedFileGrid.store.reload();
	                						 manageAssignedFileGrid.getSelectionModel().deselectAll(true);
	                					 }
	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	                	 }
	                 },
	                 getDownloadFile : function(documentId){
	                	 if(!isNullOrEmpty(documentId)){
	                		 var $this = this;
	                		 $this.getDocumentController()
	                		 .downloadDocumentFile(
	                				 documentId);
	                	 }
	                 },
	                 downloadAllDocumentZip:function(){
	                	 var $this=this;
	                	 var form=$this.getFileattachmentsform();
	                	 var documentGrid=form.down('#periodGridWin');
	                	 if (documentGrid.getSelectionModel().getCount() > 0) {
	                		 var records = documentGrid.getSelectionModel().getSelection();
	                		 var saveModel=[];  

	                		 var documentZipName = records[0].get('documentName')+'_'+records[0].get('printName');
	                		 for(var i in records){
	                			 if(!isNullOrEmpty(records[i].get('path'))) {
	                				 saveModel.push(records[i].get('path'));
	                			 }
	                		 }
	                		 showConfirmMessage(getFileManagementTranslation('DOCUMENT'),getFileManagementTranslation('DOWNLOAD_ALL_DOCUMENT_MSG'),function(btn, text) {
	                			 if (btn == 'yes') {
	                				 var directoryType = CONSTANTS.DIRECTORY_TYPE_FILEDOCUMENT;
	                				 $this.getDocumentController().downloadMultipleDocumentFile(saveModel, documentZipName, directoryType);
	                			 }});
	                	 }else {
	                		 $this.hideWindowMask();
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 },
	                 downloadAllAssignedDocumentZip:function(){
	                	 var $this=this;
	                	 var form=$this.getFileassignedattachmentsform();
	                	 var documentGrid=form.down('#periodGridWin');
	                	 if (documentGrid.getSelectionModel().getCount() > 0) {
	                		 var records = documentGrid.getSelectionModel().getSelection();
	                		 var saveModel=[];  

	                		 var documentZipName = records[0].get('documentName')+'_'+records[0].get('printName');
	                		 for(var i in records){
	                			 if(!isNullOrEmpty(records[i].get('path'))) {
	                				 saveModel.push(records[i].get('path'));
	                			 }
	                		 }
	                		 showConfirmMessage(getFileManagementTranslation('DOCUMENT'),getFileManagementTranslation('DOWNLOAD_ALL_DOCUMENT_MSG'),function(btn, text) {
	                			 if (btn == 'yes') {
	                				 var directoryType = CONSTANTS.DIRECTORY_TYPE_FILEDOCUMENT;
	                				 $this.getDocumentController().downloadMultipleDocumentFile(saveModel, documentZipName, directoryType);
	                			 }});
	                	 }else {
	                		 $this.hideWindowMask();
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 },
	                 getDocumentController : function() {
	                	 var this$ = this;
	                	 return this$
	                	 .getController('Academia.controller.document.DocumentController');
	                 },
	                 postDocumentToServer : function(grid,store, i,fileInfoId) {

	                	 if (!(store.data.getAt(i).data.status === "Uploaded")) {
	                		 store.data.getAt(i).data.status = "Uploading";
	                		 store.data.getAt(i).commit();
	                		 var manageFileGrid = this.getManagefilesgrid();
	                		 var url = SERVERURL.MULTIPLE_FILE_DOCUMENT_UPLOAD+'?fileInfoId='+fileInfoId+'&loggedInUserId='+this.getCurrentlyLoggedInUser().id;
	                		 var xhr = new XMLHttpRequest();
	                		 var fd = new FormData();
	                		 var boundary = "---------------------------7da24f2e50046";
	                		 xhr.open("POST", url, true);
	                		 fd.append('upload', store.data.getAt(i).data.file);

	                		 xhr.onreadystatechange = function() {
	                			 if (xhr.readyState == 4 && xhr.status == 200) {
	                				 store.data.getAt(i).data.status = "Uploaded";
	                				 manageFileGrid.getStore().reload();
	                				 manageFileGrid.getSelectionModel().deselectAll(true);
	                				 var response='';
	                			
	                				 if(!isNullOrEmpty(xhr.response)){
	                					 response=Ext.decode(xhr.response);
	                					 store.data.getAt(i).data.code = response.code;
	                				 }
	                				 store.data.getAt(i).commit();
	                				 
	                			 } else if (xhr.readyState == 4 && xhr.status == 404) {
	                				 store.data.getAt(i).data.status = "Error";
	                				 store.data.getAt(i).commit();
	                			 }
	                		 };
	                		 xhr.send(fd);
	                	 }
	                 },
	                 getDeleteUpload : function(){
	                	 var $this = this;
	                	 var grid = this.getFileUploadMultipleDragAndDrop();
	                	 var store = grid.getStore();
	                	 var manageFileGrid = this.getManagefilesgrid();
	              	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var records = grid.getSelectionModel().getSelection()[0];
	                		 if (!(records.data.status === "Uploaded")){
	                			 showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) { 
		                			 //Are you sure you want to delete the selected record?
		                			 if (btn == 'yes') {
		                				 store.remove(records,true);
		                			 }
		                		 });
	                		 }
	                		 else{
	                			 var records = grid.getSelectionModel().getSelection();
	                			 var ids=[];
	                			 Ext.Array.each(records,function(value){
	                				 ids.push(value.data.code);
	                			 });
	                			 showConfirmMessage(getFileManagementTranslation('MANAGE_FILE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                				 if (btn == 'yes'){
	                					 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                					 Ext.Ajax.request({
	                						 method: "DELETE",
	                						 type: 'rest',
	                						 url : SERVERURL.FILE_DOCUMENT_DELETE_API+'?fileDocumentIds='+ids.join(),
	                						 headers: {
	                							 'Content-Type': 'application/json'
	                						 },
	                						 success: function(form, action) {

	                							 Ext.getBody().unmask();
	                							 showSuccessMessage(getFileManagementTranslation('MANAGE_FILE'),getFileManagementTranslation('FILE_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	                							 store.remove(records,true);
	                							 manageFileGrid.getStore().reload();
	                							 manageFileGrid.getSelectionModel().deselectAll(true);
	                						 }
	                					 });
	                				 }
	                			 });
	                		 }
	                		 
	                	 } else {
	                		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	                	 }
	                	 
	                	 
	                 },
	                 getAssignedMultipleFileUpload : function(fileField, value, eOpts){
	                	 var grid = this.getFileAssignedUploadMultipleDragAndDrop();
	                	 var store = grid.getStore();

	                	 value = value.replace('C:\\fakepath\\', '');
	                	 var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                	 var file = fileField.fileInputEl.dom.files[0];
	                	 var size = fileField.fileInputEl.dom.files[0].size;
	                	 store.add({
	                		 file:file,
	                		 name: file.name,
	                		 size: file.size,
	                		 status: 'Ready'
	                	 });
	                 },
	                 getAssignedUploadToFileManagement : function(){
	                	 var $this = this;
	                	 var contentPanel = this.getContentpanel();
	                	 var fileInfoId =  contentPanel.getFileInfoAssignId();
	                	 var grid = this.getFileAssignedUploadMultipleDragAndDrop();
	                	 var store = grid.getStore();
	                	 for (var i = 0; i < store.data.items.length; i++) {
	                		 $this.postAssignedDocumentToServer(store, i,fileInfoId);
	                	 }
	                 },
	                 postAssignedDocumentToServer : function(store, i,fileInfoId) {

	                	 if (!(store.data.getAt(i).data.status === "Uploaded")) {
	                		 store.data.getAt(i).data.status = "Uploading";
	                		 store.data.getAt(i).commit();
	                		 var manageAssignedFileGrid = this.getManageassignedfilesgrid();
	                		 var url = SERVERURL.MULTIPLE_FILE_DOCUMENT_UPLOAD+'?fileInfoId='+fileInfoId+'&loggedInUserId='+this.getCurrentlyLoggedInUser().id;
	                		 var xhr = new XMLHttpRequest();
	                		 var fd = new FormData();
	                		 var boundary = "---------------------------7da24f2e50046";
	                		 xhr.open("POST", url, true);
	                		 fd.append('upload', store.data.getAt(i).data.file);

	                		 xhr.onreadystatechange = function() {
	                			 if (xhr.readyState == 4 && xhr.status == 200) {
	                				 store.data.getAt(i).data.status = "Uploaded";
	                				 store.data.getAt(i).commit();
	                				 manageAssignedFileGrid.getStore().reload(); 
	                				 manageAssignedFileGrid.getSelectionModel().deselectAll(true);

	                			 } else if (xhr.readyState == 4 && xhr.status == 404) {
	                				 store.data.getAt(i).data.status = "Error";
	                				 store.data.getAt(i).commit();
	                			 }
	                		 };
	                		 xhr.send(fd);
	                	 }
	                 },
	                 getAssignedDeleteUpload : function(){
	                	 var $this = this;
	                	 var grid = this.getFileAssignedUploadMultipleDragAndDrop();
	                	 var store = grid.getStore();

	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var records = grid.getSelectionModel().getSelection()[0];
	                		 showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) { //Are you sure you want to delete the selected record?
	                			 if (btn == 'yes') {
	                				 store.remove(records);
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	                	 }
	                 },
	                 selectUserTypeInCtl:function(combo,record, eOpts, $this){
	                	 var userTypeId = record[0].get("id");
	                	 var form = combo.up('form');
	                	 var assignedUser = combo.nextSibling();//form.down('#assignedUser');
	                	 assignedUser.setDisabled(false);
	                	 var ids=[];
	                	 //var grid = Ext.widget('managefilesgrid');
	                	 //var grid = Academia.app.getController('filemanagement.ManageFileController').getManagefilesgrid();
	                	 var grid = $this.getManagefilesgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var records = grid.getSelectionModel().getSelection();
	                		 Ext.Array.each(records[0].data.academyLocations,function(value){
	                			 ids.push(value.id);
	                		 });
	                	 }
	                	 var store = assignedUser.getStore();
	                	 store.getProxy().extraParams = {
	                		 userType: userTypeId,
	                		 academyLocationIds: ids.join()
	                	 };
	                	 store.load();
	                 },
	                 resetFileInformationRecord:function()
	                 {
	                	 $this = this;
	                	 var form =$this.getFileinformationform();
	                	 form.down('#returnClarification').reset();
	                	 form.down('#returningDate').reset();
	                	 form.down('#returnReason').reset();
	                	 form.down('#resubmissionDueDate').reset();
	                	 form.down('#fileHandoverById').reset();
	                 },
	               //Disable More Action Privileges button 
	                 disableMoreActionPivileges: function(gridReference,permissionsMap) {
                         var associatedAcadLocationIds = new Array();
	                	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	                	 buttonsToolBar = gridReference.query('toolbar')[0];

	                	 var splitbuttons = buttonsToolBar.query('splitbutton')[0];
	                	 splitbuttons.setVisible(false);

	                	 Ext.each(splitbuttons.menu.items.items, function(menuItems) {
	                		 menuItems.setVisible(false);
	                	 });

	                	 Ext.each(permissionList, function(privilege) {
	                		 if (privilege === 'MOREACTIONS') {
	                			 var button = buttonsToolBar.query('#spBtnMoreActions')[0];
	                			 if(!isNullOrEmpty(button)){
	                				 button.setVisible(true);
	                			 }        		
	                		 }
	                		 if (privilege === 'ASSIGNTO') {
	                			 var button = buttonsToolBar.query('#btnAssignTo')[0];
	                			 if(!isNullOrEmpty(button)){
	                				 button.setVisible(true);
	                			 }        		
	                		 }
	                		 if (privilege === 'UPDATE_STATUS') {
	                			 var button = buttonsToolBar.query('#btnUpdateStatus')[0];
	                			 if(!isNullOrEmpty(button)){
	                				 button.setVisible(true);
	                			 }        		
	                		 }
	                		 if (privilege === 'UPLOAD_DOCUMENT') {
	                			 var button = buttonsToolBar.query('#btnUploadDocument')[0];
	                			 if(!isNullOrEmpty(button)){
	                				 button.setVisible(true);
	                			 }        		
	                		 }
	                	 });

	                 },
                removePlaceHolder:function(){
	            var addfileinfoform=this.getAddfileinfoform();
                      Ext.Ajax.request({
                         type: 'rest',
                         url: SERVERURL.FIND_BY_ENTITY_ID,                             
                         method: 'GET',
                         params: {
                             entityId: 30
                         },
                         success: function(response,form, action) {
                             if(!isNullOrEmpty(response.responseText)){
                                 var responseObject =  Ext.JSON.decode(response.responseText);                                  
                                 if(!isEmpty(responseObject)){
                                     var fileNumber = addfileinfoform.down("#fileNumber");
                                     if(responseObject.whetherManualId){
                                         fileNumber.setReadOnly(false);
										 fileNumber.emptyText=' ';
									     fileNumber.allowBlank=false;
										 fileNumber.labelSeparator +='<span class="required" style="color:red"> *</span>';
										 fileNumber.setFieldLabel(fileNumber.fieldLabel);
										 fileNumber.applyEmptyText();
                                     }else{
										 fileNumber.setReadOnly(true);
									     fileNumber.allowBlank=true;
										 fileNumber.emptyText= getCommonTranslation('ID_AUTOGENERATE');
										 fileNumber.applyEmptyText();
	
                                    }
                                 }
                             }                                                     
                         }                
                     });
    
}

});
