/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.hostelattendance.HostelAttendanceController', {
	extend : 'Academia.controller.base.BaseController',

	models : ['hostel.report.HostelDetailReportModel'],
	
	stores : ['hostel.managehostel.floor.FloorCodeName','hostel.managehostel.building.BuildingCodeName',
	          'hostel.roomallocation.UserSmartSearchByUserType','hostel.managehostel.hostel.HostelCodeName',
	          'hostel.hostelattendance.HostelMarkAttendanceGridStr','hostel.hostelattendance.HostelAttendanceStatus',
	          'hostel.hostelattendance.HostelAttendanceGridStr','hostel.hostelattendance.HostelMarkAttendanceStatus',
	          'hostel.hostelattendance.HostelAttendanceStatusStore','attendance.UserGroup','hostel.roomallocation.UserSmartSearchByUserType',
	          'common.AcademicTermStore','hostel.managehostel.hostel.ManageHostelCodeName','hostel.managehostel.building.ManageBuildingCodeName',
	          'hrm.timesheet.HRMTEmployeeSmartSearchStore','hostel.managehostel.floor.RoomCodeName',
	          'user.UserAcademyLocationStore','hostel.managehostel.floor.ManageFloorCodeName','sponsorship.SponsorsNameCodeStore',
	          'hostel.hostelapplication.HostelApplicationStore','hostel.reports.HostelDetailReportStore'
	          ],
	          
	views : ['hostel.hostelattendance.HostelAttendanceStructure','hostel.hostelattendance.HostelAttendanceSearch',
	         'hostel.hostelattendance.HostelAttendanceGrid','hostel.hostelattendance.HostelMarkAttendanceStructure',
	         'hostel.hostelattendance.HostelMarkAttendanceSearch','hostel.hostelattendance.HostelMarkAttendanceGrid',
	         'hostel.hostelattendance.UpdateAttendanceFormWindow','hostel.reports.hosteldetailreport.HostelDetailReportStructure',
	         'hostel.reports.hosteldetailreport.HostelDetailsReportSearch','hostel.reports.hosteldetailreport.HostelDetailsReportGrid',
	         
	         ],
	         
	         refs :[{
	        	 ref : 'contentPanel',
	        	 selector : 'contentPanel'
	         },{
	        	 ref : 'hostelattendancestructure',
	        	 selector : 'hostelattendancestructure'
	         },{
	        	 ref : 'hostelmarkattendancestructure',
	        	 selector : 'hostelmarkattendancestructure'
	         },{
	        	 ref : 'hostelattendancesearch',
	        	 selector : 'hostelattendancesearch'
	         },{
	        	 ref : 'hostelattendancegrid',
	        	 selector : 'hostelattendancegrid'
	         },{
	        	 ref : 'hostelmarkattendancesearch',
	        	 selector : 'hostelmarkattendancesearch'
	         },{
	        	 ref : 'hostelmarkattendancegrid',
	        	 selector : 'hostelmarkattendancegrid'
	         },{
	        	 ref : 'updateattendanceformwindow',
	        	 selector : 'updateattendanceformwindow'
	         },{
	        	 ref : 'hosteldetailreportstructure',
	        	 selector : 'hosteldetailreportstructure'
	         },{
	        	 ref : 'hosteldetailsreportsearch',
	        	 selector : 'hosteldetailsreportsearch'
	         },{
	        	 ref : 'hosteldetailsreportgrid',
	        	 selector : 'hosteldetailsreportgrid'
	         }],
	         config: {
	        	 HOSTEL_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_ATTENDANCE_PRIVILEGES'),
	        	 HOSTEL_DETAIL_REPORT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_DETAIL_REPORT_PRIVILEGES')
	        },         

	init : function() {
		this.control({
			'hostelattendancesearch':{
				render:function(obj){
					var form = this.getHostelattendancesearch();
					this.onRenderStoreLoad(form);
				}
			},
			'hostelmarkattendancesearch':{
				render:function(obj){
					var form = this.getHostelmarkattendancesearch();
					this.onRenderStoreLoad(form);
				}
			},
			'hostelattendancesearch':{
				afterrender:function(form){

                    var form = this.getHostelattendancesearch();
                    var checkoutOccupant =form.down('#checkoutOccupant');
                    checkoutOccupant.setVisible(false);
                    var associatedAcadLocationIds = new Array();
               	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
               	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getHOSTEL_ATTENDANCE_PERMISSIONS());
               	 Ext.each(permissionList, function(privilege) {
               		 if (privilege === 'CHECKOUT_OCCUPANT') {
               			 if(!isNullOrEmpty(checkoutOccupant)){
               				checkoutOccupant.setVisible(true);
               			 }        		
               		 }
               	 });
				 },
			},
			'hostelattendancesearch customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					buildingCodeName.clearValue();
					var buildingCodeStore =  buildingCodeName.getStore();
					var values = form.getForm().getValues();
					
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:hostelCode,
							status:values.status
						};
						buildingCodeStore.load();
				}
			},
			
			'hostelattendancesearch checkboxfield[itemId=checkoutOccupant]': {
			    change: function($this, data) {
			        var form = this.getHostelattendancesearch();
			        var grid = this.getHostelattendancegrid();
					var updateAttendanceItemId = grid.down("#updateAttendanceItemId");
					 var exportReportItemId = grid.down("#exportReportItemId");
			        var attendanceDateForm = form.down("#fromDate");
			        var attendanceDateTill = form.down("#toDate");
			        var checkoutOccupant = $this.getValue();
			        var today = new Date();
			        var maxDate = new Date(today);
			        maxDate.setDate(maxDate.getDate() + 30);

			        
			        Ext.defer(function () {
			            if (checkoutOccupant) {
			            	 updateAttendanceItemId.setDisabled(true);
					            exportReportItemId.setDisabled(true);
			                attendanceDateTill.setMinValue(today);
			                attendanceDateTill.setMaxValue(maxDate);

			                attendanceDateForm.setValue(today);
			                attendanceDateTill.setValue(maxDate);
			                attendanceDateForm.setMaxValue(today);
			              //  attendanceDateForm.setMaxValue(maxDate);
			            } else {
			            	updateAttendanceItemId.setDisabled(false);
					            exportReportItemId.setDisabled(false);
			                attendanceDateForm.setMinValue(null);
			                attendanceDateForm.setMaxValue(null);

			                attendanceDateTill.setMinValue(null);
			                attendanceDateTill.setMaxValue(null);

			                attendanceDateForm.reset();
			                attendanceDateTill.reset();
			     			       }
			        }, 10); // Slight delay to ensure rendering
			    }
			},										
			
			'hostelattendancesearch datefield[itemId=fromDate]':{
				select : function($this,data){
					var form =this.getHostelattendancesearch();	
					 var attendanceDateForm = form.down("#fromDate");
				      var attendanceDateTill = form.down('#toDate');
				      attendanceDateTill.reset();
					var grid = this.getHostelattendancegrid();
					if (data) {
			            var maxTillDate = new Date(data);
			            maxTillDate.setDate(maxTillDate.getDate() + 30); 
			            attendanceDateTill.setMinValue(data); // Till Date must be after the From Date
			            attendanceDateTill.setMaxValue(maxTillDate); // Till Date must not exceed 30 days after From Date
			        }
				}
			},
			
			'hostelattendancesearch customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					floorCodeName.clearValue();
					var floorCodeStore =  floorCodeName.getStore();

					var values = form.getForm().getValues();
					
						floorCodeStore.getProxy().extraParams = {
							buildingCode:buildingCode,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeStore.load();
				}
			},
			
			'hostelattendancesearch button[itemId=resetButtonId]':{
				click:function(obj){
					obj.up('form').getForm().reset();
					this.onResetstoreReload();
				}
			},
            'hostelattendancegrid button[itemId=exportReportItemId]': {
           	 click: function(btn) {
           		 this.exportXlsHostelAttendanceReport(btn);
           	 }
            },
			'hostelattendancesearch button[itemId=searchButtonId]':{
				click:function(obj){
					this.loadAttendanceGrid(obj);
				}
			},
			'hosteldetailsreportsearch button[itemId=searchButtonId]':{
				click:function(obj){
					this.loadAttendanceGrid2(obj);
				}
			},
			'hostelattendancegrid button[itemId=btnAdd]': {
				click:function(obj){
					this.showMarkHostelAttendance();
				}
			},
			'hostelattendancegrid button[itemId=updateAttendanceItemId]': {
				click:function(obj){
					this.showUpdateAttendanceWindow();
				}
			},
			
			'hostelattendancegrid': {
				render: function(grid) {
 					this.doAccessControlValidation(grid, this.getHOSTEL_ATTENDANCE_PERMISSIONS());
				}
			},
			
			
			'updateattendanceformwindow button[itemId=winResetButtonId]':{
				click:function(obj){
					this.onResetUpdateAttendanceWindow();
				}
			},
			
			'updateattendanceformwindow button[itemId=winBtnSaveUpdateAttendanceForm]':{
				click:function(obj){
					this.onSaveUpdateAttendanceWindow();
				}
			},
			
			/**
			 *  Hostel mark attendance search 
			 */
			
			'hostelmarkattendancesearch customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					buildingCodeName.clearValue();
					var buildingCodeStore =  buildingCodeName.getStore();

					var values = form.getForm().getValues();
					
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:hostelCode,
							status:values.status
						};
						buildingCodeStore.load();
				}
			},
			'hostelmarkattendancesearch customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					floorCodeName.clearValue();
					var floorCodeStore =  floorCodeName.getStore();
					var values = form.getForm().getValues();
					
						floorCodeStore.getProxy().extraParams = {
							buildingCode:buildingCode,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeStore.load();
				}
			},
			
			'hostelmarkattendancesearch button[itemId=resetButtonId]':{
				click:function(obj){
					this.resetHostelMarkAttendance();
				}
			},
			'hostelmarkattendancesearch button[itemId=searchButtonId]':{
				click:function(obj){
					this.loadMarkAttendanceGrid(obj);
				}
			},
			'hostelmarkattendancegrid radiogroup[itemId=markAttendanceId]': {
				change:function(obj,record){
					this.onChangeRadioButton(obj,record);
				}
			},
			
			'hostelmarkattendancestructure button[itemId=submitBtn]':{
				click:function(){
					this.saveMakrAttendance();
				}
			},
			'hostelmarkattendancegrid checkcolumn':{
				checkchange:function(obj, rowIndex, checked, eOpts ){
					var this$ = this;
					var grid = this$.getHostelmarkattendancegrid();
					var store = grid.getStore();
					var models = grid.getStore().getRange();
					if(checked){
						if(obj.text=='Absent'){
							for(var i =0; i<store.data.length;i++){
								if(rowIndex==i){
									models[rowIndex].set('present', false);
									Ext.defer(function() {
										models[rowIndex].set('attendanceStatus', null);
									}, 50, this);
									break;
								}
							}
						}
						if(obj.text=='Present'){
							for(var i =0; i<store.data.length;i++){
								if(rowIndex==i){
									models[rowIndex].set('absent', false);
									Ext.defer(function() {
										models[rowIndex].set('attendanceStatus', null);
									}, 50, this);
									break;
								}
							}
						}
					}else{
						if(obj.text=='Absent'){
							for(var i =0; i<store.data.length;i++){
								if(rowIndex==i){
									models[rowIndex].set('present', true);
									Ext.defer(function() {
										models[rowIndex].set('attendanceStatus', null);
									}, 50, this);
									break;
								}
							}
						}
						if(obj.text=='Present'){
							for(var i =0; i<store.data.length;i++){
								if(rowIndex==i){
									models[rowIndex].set('absent', true);
									Ext.defer(function() {
										models[rowIndex].set('attendanceStatus', null);
									}, 50, this);
									break;
								}
							}
						}
					}
				}
			},
			
			'hostelattendancegrid customcombobox[itemId=hostelAttendanceStatusId]':{
				
				select: function(obj,record){
					var grid = obj.up('grid');
					var $this=this;
					 showConfirmMessage(getHostelTranslation('HOSTEL_ATTENDANCE'),getHostelTranslation('EDIT_SELECTED_ATTENDENCE_RECORD'),
			   				 function(btn, text) {
			   					 if (btn == 'yes') {
			   						var records = grid.getSelectionModel().getSelection()[0];
			   						records.data.attendanceStatus = record[0].data.value
			   						$this.editHostelAttendance(records);
			   					 }
			   					 else{
			   						$this.loadAttendanceGrid();
			   					 }
					 });
					
				}
			},
			 'hostelmarkattendancestructure' :  {
				 afterrender : function(structure){
					 var $this = this;
					 structure.body.on('scroll', function(e, target) {
		   				  var pcstructure = structure.down("hostelmarkattendancegrid");
		   				  var academyLocationId = $this.getCurrentAcademyLocation();
		   				  var grid = null;
		   				  
		   				  if(!pcstructure.isHidden()){
		   					  grid = pcstructure;
		   				  }
		   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
						 });
				 }
			},
			'hosteldetailsreportsearch combo[itemId=userType]':{
				select:function(combo,record){
					var userTypeId = record[0].get("id");
					var form = combo.up('form');
					var studentName = form.down('#studentName');
					studentName.setDisabled(false);
					var store = studentName.getStore();
					
					store.getProxy().extraParams = {
						userType: userTypeId
					};
					store.load();

				}
			},
			'hosteldetailsreportsearch combo[itemId=academyLocation]':{
				render:function(combo){
					var store = combo.getStore();
					store.getProxy().extraParams = {
						id: this.getCurrentlyLoggedInUser().id
					};
					store.load({
						callback:function(records, operation, success){
							if (success) {
								if(records.length == 1){
									combo.setValue(records[0].get("id"));									
								}
							}
						}
					});
				},
				select:function(combo,record){
					var alId = record[0].get("id");
					var form = combo.up('form');
					var hostelCodeName = form.down('#hostelCodeName');
					hostelCodeName.clearValue();
					var store = hostelCodeName.getStore();
					store.getProxy().extraParams = {
						academyLocationId: alId
					};
					store.load();
				}
			},
			'hosteldetailsreportsearch':{
				render:function(){
					var form = this.getHosteldetailsreportsearch();
					var buildingCodeName  = form.down('#buildingCodeName');
					var floorCodeNoField  = form.down('#floorCodeNo');
					var roomNoField  = form.down('#roomNo'),
			 		userTypeField  = form.down('#userType');

					var buildingCodeStore =  buildingCodeName.getStore();
					var floorCodeNo = floorCodeNoField.getStore();
					var roomNo = roomNoField.getStore(),
					userTypeFldStore = userTypeField.getStore();

					var values = form.getForm().getValues();

					buildingCodeStore.getProxy().extraParams = {
						hostelCode:values.hostelCodeName,
						status:values.status,
						resourceGroup:'Building'
					};
					buildingCodeStore.load();

					floorCodeNo.getProxy().extraParams = {
						buildingCode:values.floorCodeNo,
						status:values.status,
						resourceGroup:'Floor'
					};
					floorCodeNo.load();

					roomNo.getProxy().extraParams = {
						floorCode:values.roomNo,
						status:values.status,
						resourceGroup:'Room'
					};
					roomNo.load();
					
					userTypeFldStore.load({
						callback:function(records, operation, success){
							if(records.length > 0){
								var rec = userTypeFldStore.findRecord('userGroupName',getCommonTranslation('STUDENT'));
								if(rec){
									userTypeField.setValue(rec.data.id);	
									var studentName = form.down('#studentName');
									var store = studentName.getStore();
									store.getProxy().extraParams = {
										userType: rec.data.id
									};
									store.load();
								}
							}
						}
					});
				}
			},
			'hosteldetailsreportsearch customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					buildingCodeName.clearValue();
					var buildingCodeStore =  buildingCodeName.getStore();

					var values = form.getForm().getValues();
					
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:hostelCode,
							status:values.status
						};
						buildingCodeStore.load();
				}
			},
			'hosteldetailsreportsearch customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					floorCodeName.clearValue();
					var floorCodeStore =  floorCodeName.getStore();

					var values = form.getForm().getValues();
					
//					if(values.hostelType == 'FLOOR' || values.hostelType == 'ROOM'){
						floorCodeStore.getProxy().extraParams = {
							buildingCode:buildingCode,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeStore.load();
//					}
				}
			},
			'hosteldetailsreportsearch customcombobox[itemId=floorCodeNo]':{
				select: function(obj,record){
					var form = obj.up('form');
					var floorCode = record[0].get("id");
					var roomNoField  = form.down('#roomNo');
					roomNoField.clearValue();
					var roomStore =  roomNoField.getStore();

					var values = form.getForm().getValues();
					
//					if(values.hostelType == 'ROOM'){
						roomStore.getProxy().extraParams = {
							floorCode:floorCode,
							status:values.status,
							resourceGroup:'Room'
						};
						roomStore.load();
					}
//				}
			},
			'hosteldetailsreportsearch button[itemId=resetButtonId]':{
				click:function(obj){
					this.resetUserWise(obj);
				}
			},
			'hosteldetailsreportgrid':
				{
				afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getHOSTEL_DETAIL_REPORT_PERMISSIONS());}
				
				}
			
		});
	},
	showMarkHostelAttendance:function(obj){
	   	 var me = this;
	   	 var contentpanel = me.getContentPanel();
	   	 var distributionliststructure = Ext.widget('hostelmarkattendancestructure');
	   	 var tabName = getHostelTranslation('MARK_HOSTEL_ATTENDANCE');
	   	 
	   	 var getcontroller=me.getController('menu.CoreERPNavigationController');
		 var getTab=getcontroller.getTab(tabName);
		 if(getTab!=null){
			 contentpanel.remove(getTab, true);
		 }
		 
	   	 openTab(contentpanel, tabName, distributionliststructure,CONSTANTS.MENU_COLOR_TWELVE);
	},
	onRenderStoreLoad:function(form){
		var grid = this.getHostelattendancegrid();
		var hostelCodeName  = form.down('#hostelCodeName');
		var buildingCodeName  = form.down('#buildingCodeName');
		var floorCodeNoField  = form.down('#floorCodeNo');
		var roomNoField  = form.down('#roomNo');

		var hostelCodeNameStore =  hostelCodeName.getStore();
		var buildingCodeStore =  buildingCodeName.getStore();
		var floorCodeNo = floorCodeNoField.getStore();

		var values = form.getForm().getValues();

		hostelCodeNameStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Hostel'
		};
		hostelCodeNameStore.load();
		
		buildingCodeStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Building'
		};
		buildingCodeStore.load();

		floorCodeNo.getProxy().extraParams = {
			buildingCode:values.floorCodeNo,
			status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();
		if(!isNullOrEmpty(grid)){
			grid.down('#exportReportItemId').setDisabled(true);	
		}
	},
	/**
	 * Load mark attendance grid 
	 */
	loadMarkAttendanceGrid:function(){
		var form  = this.getHostelmarkattendancesearch().getForm();
		var grid = this.getHostelmarkattendancegrid();
		grid.down('#markAttendanceId').reset();
		
		var structure = this.getHostelmarkattendancestructure();
		var values = form.getValues();
		var store = grid.getStore();
		
		store.getProxy().extraParams = {
			hostelId:values.hostelCodeName,
			buildingId:values.buildingCodeName,
			floorId:values.floorCodeNo,
			attendanceDate:values.date,
			fromTime:values.fromTime
//			toTime:values.
		};
		store.load();
		structure.down('#submitBtn').setDisabled(false);
	},
	
	
	/**
	 * Load hostel attendance grid 
	 * 
	 */
	loadAttendanceGrid:function(){
		var $this = this;
		var form  = $this.getHostelattendancesearch().getForm();
		var grid = $this.getHostelattendancegrid();
		var values = form.getValues();
		var store = grid.getStore();
		$this.resetGridSetting(grid);
		store.getProxy().extraParams = {
			hostelId: values.hostelCodeName,
			buildingId:values.buildingCodeName,
			floorId:values.floorCodeNo,
			fromDate:values.fromDate,
			userId:values.studentName,
			toDate:values.toDate,
			attendanceStatus: values.attendanceStatus,
			checkoutOccupant :values.checkoutOccupant
		};
		store.load();
		//grid.down('#exportReportItemId').setDisabled(false);
	},
	loadAttendanceGrid2:function(){
		var $this = this;
		var form  = $this.getHosteldetailsreportsearch().getForm();
		var grid = $this.getHosteldetailsreportgrid();
		var values = form.getValues();
		var store = grid.getStore();
		$this.resetGridSetting(grid);
		store.getProxy().extraParams = {
			userType: values.userType,
			userId:values.studentName,
			academicYearId: values.academicTerm,
			academyLocationId: values.academyLocation,
			hostelResourceId: values.hostelCodeName,
			buildingResourceId:values.buildingCodeName,
			floorResourceId:values.floorCodeNo,
			roomResourceId:values.roomNo,
			employerId: values.SPONSOR_ID,
			fromDate:values.fromDate,
			toDate:values.toDate,
			status: values.status
		};
		store.load();
	},
	onChangeRadioButton:function(obj,record){
 	   var attendanceStatus = record.markAttendance;
	   var grid = this.getHostelmarkattendancegrid();
	   var store = grid.getStore();
	   var models = grid.getStore().getRange();
	   var abs=0,pre=0,oth=0;
	   store.suspendEvents();
	   if(attendanceStatus == 'PRESENT' || attendanceStatus == 'Present'){
		   store.each(function (rec) {
			   rec.set('present', true);
			   rec.set('absent', false);
			   rec.set('attendanceStatus', null);
		   });
	   }else if(attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent'){
		   store.each(function (rec) {
			   rec.set('present', false);
			   rec.set('absent', true);
			   rec.set('attendanceStatus', null);
		   });
	   }else if(attendanceStatus == 'LEAVE' || attendanceStatus == 'Leave'){
		   store.each(function (rec) {
			   rec.set('present', false);
			   rec.set('absent', false);
			   rec.set('attendanceStatus', "Leave");
		   });
		   
	   }else if(attendanceStatus == 'LATE_ARRIVAL' || attendanceStatus == 'Late Arrival'){
		   store.each(function (rec) {
			   rec.set('present', false);
			   rec.set('absent', false);
			   rec.set('attendanceStatus', "Late Arrival");
		   });
	   }
	   store.resumeEvents();
	   grid.getView().refresh();
	   /*for(var i =0; i<store.data.length;i++){
		   if(attendanceStatus == 'PRESENT' || attendanceStatus == 'Present'){
			   models[i].set('present', true);
			   models[i].set('absent', false);
			   models[i].set('attendanceStatus', null);
		   }else if(attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent'){
			   models[i].set('attendanceStatus', null);
			   models[i].set('present', false);
			   models[i].set('absent', true);
		   }else if(attendanceStatus == 'LEAVE' || attendanceStatus == 'Leave'){
			   models[i].set('attendanceStatus', "Leave");
			   models[i].set('present', false);
			   models[i].set('absent', false);
		   }else if(attendanceStatus == 'LATE_ARRIVAL' || attendanceStatus == 'Late Arrival'){
			   models[i].set('attendanceStatus', "Late Arrival");
			   models[i].set('present', false);
			   models[i].set('absent', false);
		   }
	   }*/
   },
   
   saveMakrAttendance:function() {
	   var $this = this;
	   var structure = $this.getHostelmarkattendancestructure();
	   var form = $this.getHostelmarkattendancesearch().getForm();
	   var values = form.getValues();
	   var hostelAttendance = [];
	   var grid = $this.getHostelmarkattendancegrid();
	   var store = grid.getStore();

	   if(store.data.length > 0) {
		   var date = Ext.Date.format(new Date(values.date), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
		   var models = store.getRange();
		   for(var i=0; i<store.data.length; i++){
			   var attendanceStatus = null;
			   if(models[i].data.present == true || models[i].data.present == 'true'){
				   attendanceStatus = 'PRESENT';
			   }else if(models[i].data.absent == true || models[i].data.absent == 'true'){
				   attendanceStatus = 'ABSENT';
			   }else if (!isNullOrEmpty(models[i].data.attendanceStatus)){
				   var temp = models[i].data.attendanceStatus;
				   if(temp == 'Leave' || temp == 'LEAVE'){
					   attendanceStatus = 'LEAVE';
				   }else if(temp == 'Late Arrival' || temp == 'LATE_ARRIVAL'){
					   attendanceStatus= 'LATE_ARRIVAL';
				   }
			   }else{
				   continue;
			   }
			   hostelAttendance.push({
				   "id": models[i].data.attendanceId,
				   "hostelId": models[i].data.hostelId,
				   "buildingId": models[i].data.buildingId,
				   "floorId": models[i].data.floorId,
				   "dateOfAttendance": date,
				   "fromTime": values.fromTime,
				   "toTime": null,
				   "userId": models[i].data.userId,
				   "attendanceStatus": attendanceStatus
			   });
		   }
		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		   submitUrl = SERVERURL.HOSTEL_ATTENDANCE_UPDATE;
		   Ext.Ajax.request({
			   type : 'rest',
			   url : submitUrl,
			   jsonData : hostelAttendance,
			   method : 'POST',
			   success : function(form1, action) {
				   Ext.getBody().unmask();
				   showSuccessMessage(getHostelTranslation('MARK_HOSTEL_ATTENDANCE'), getHostelTranslation('SAVE_ATTENDENCE_SUCCCESS'));
				   $this.resetHostelMarkAttendance()
			   },
		   failure: function(form1, action) {var data = Ext.decode(form1.responseText);
       	if(data[0].key == 'THE_ATTENDANCE_IS_ALREADY_CAPTURED_FOR_THIS_TIME_SLOT'){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('THE_ATTENDANCE_IS_ALREADY_CAPTURED_FOR_THIS_TIME_SLOT')); 
    	}}
		   });
	   }
	   else {
		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));			
	   }
   },
   editHostelAttendance:function(records) {
	   var $this = this;
	   var structure = $this.getHostelattendancestructure();
	   var form = $this.getHostelattendancesearch().getForm();
	   var values = form.getValues();
	   var hostelAttendance = [];
	   var grid = $this.getHostelattendancegrid();
	   var store = grid.getStore();

	  // if(store.data.length > 0) {
		   var date = Ext.Date.format(new Date(records.data.attendanceDate), 'd-m-Y'); // TODO remove Y-m-d
		  // var models = store.getRange();
		   //for(var i=0; i<store.data.length; i++){
			   var attendanceStatus = null;
			   if(records.data.attendanceStatus== 'Present'){
				   attendanceStatus = 'PRESENT';
			   }else if(records.data.attendanceStatus == 'Absent'){
				   attendanceStatus = 'ABSENT';
			   }else if (records.data.attendanceStatus=='Leave'){
					   attendanceStatus = 'LEAVE';
			   }else if(records.data.attendanceStatus== 'Late Arrival'){
					   attendanceStatus= 'LATE_ARRIVAL';
			   }
			  /* else{
				   continue;
			   }*/
			   hostelAttendance.push({
				   "id": records.data.attendanceId,
				   /*"hostelId": values.hostelCodeName,
				   "buildingId": records.data.buildingId,
				   "floorId": records.data.floorId,
				   "dateOfAttendance": date,
				   "fromTime": records.data.attendanceTime,
				   "toTime": null,
				   "userId": records.data.userId,*/
				   "attendanceStatus": attendanceStatus
			   });
		   //}
		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		   submitUrl = SERVERURL.HOSTEL_ATTENDANCE_UPDATE;
		   Ext.Ajax.request({
			   type : 'rest',
			   url : submitUrl,
			   jsonData : hostelAttendance,
			   method : 'POST',
			   success : function(form1, action) {
				   Ext.getBody().unmask();
				   showSuccessMessage(getHostelTranslation('HOSTEL_ATTENDANCE'), getHostelTranslation('EDIT_ATTENDENCE_SUCCCESS'));
				   $this.loadAttendanceGrid();
			   }
		   });
	 //  }
	   /*else {
		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));			
	   }*/
   },
   resetHostelMarkAttendance:function(){
	   var $this = this;
	   var structure = $this.getHostelmarkattendancestructure();
	   var form = $this.getHostelmarkattendancesearch().getForm();
	   var grid = $this.getHostelmarkattendancegrid();
	   form.reset();
	   grid.getStore().removeAll();
	   grid.down('#markAttendanceId').reset();
	   structure.down('#submitBtn').setDisabled(true);
   },
   onResetstoreReload:function(){
	   	var form = this.getHostelattendancesearch();
	    var grid = this.getHostelattendancegrid();
		var hostelCodeName  = form.down('#hostelCodeName');
		var buildingCodeName  = form.down('#buildingCodeName');
		var floorCodeNoField  = form.down('#floorCodeNo');

		var hostelCodeNameStore =  hostelCodeName.getStore();
		var buildingCodeStore =  buildingCodeName.getStore();
		var floorCodeNo = floorCodeNoField.getStore();

		var values = form.getForm().getValues();

		hostelCodeNameStore.getProxy().extraParams = {
			//hostelCode:values.hostelCodeName,
			//status:values.status,
			resourceGroup:'Hostel'
		};
		hostelCodeNameStore.load();
		
		buildingCodeStore.getProxy().extraParams = {
			//hostelCode:values.hostelCodeName,
			//status:values.status,
			resourceGroup:'Building'
		};
		buildingCodeStore.load();

		floorCodeNo.getProxy().extraParams = {
			//buildingCode:values.floorCodeNo,
			//status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();
		var fromDate = form.down("#fromDate");
        var toDate = form.down("#toDate");
        fromDate.setMinValue(null);
        fromDate.setMaxValue(null);
        toDate.setMinValue(null);
        toDate.setMaxValue(null);
	},
	showUpdateAttendanceWindow: function(){
        var me = this;
        var grid = me.getHostelattendancegrid(),
        attendanceSearchFilter = me.getHostelattendancesearch();
        var fromDate = attendanceSearchFilter.down("#fromDate").getValue();
        var toDate = attendanceSearchFilter.down("#toDate").getValue();
        if(fromDate== null || toDate == null){
        	showWarningMessage(getCommonTranslation('UPDATE_ATTENDANCE'), getCommonTranslation('PLEASE_SELECT_FROM_DATE_AND_TO_DATE')); 
        }else{
        gridSelCount = grid.getSelectionModel().getCount();
        if (gridSelCount > 0) {
        	var records = grid.getSelectionModel().getSelection(),
        	 winUpdateAttendance = Ext.widget('updateattendanceformwindow'),
        	 winAttendanceStatusCombo = winUpdateAttendance.down('#winAttendanceStatusItemId');
        	 winAttendanceStatusCombo.getStore().load(function(st){
        		winAttendanceStatusCombo.select(winAttendanceStatusCombo.getStore().getAt(0));
            });
        	if (records != "" && records != null && records != undefined) {
        		 var updateAttendanceForm = winUpdateAttendance.down('form');
        		 updateAttendanceForm.getForm().setValues(attendanceSearchFilter.getForm().getValues());
        		 
        		 var hostelCodeNameText = attendanceSearchFilter.down('#hostelCodeName').getRawValue();
        		 winUpdateAttendance.down('#winHostelNameItemId').setValue(hostelCodeNameText);
        		 winUpdateAttendance.down('#winRecSelectedItemId').setValue(gridSelCount);
        	}
        	
        	winUpdateAttendance.show();
        }
        else {
        	showWarningMessage(getCommonTranslation('UPDATE_ATTENDANCE'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
        }
        }
	},
	onResetUpdateAttendanceWindow: function(){
		var me = this;
		var updateattendanceformwindow = me.getUpdateattendanceformwindow(),
		winAttendanceStatusCombo = updateattendanceformwindow.down('#winAttendanceStatusItemId');
		updateattendanceformwindow.down('#winRemarksItemId').reset();
		winAttendanceStatusCombo.select(winAttendanceStatusCombo.getStore().getAt(0));
	},
	onSaveUpdateAttendanceWindow: function(){
		var me = this;
		updateattendanceformwindow = me.getUpdateattendanceformwindow(),
		grid = me.getHostelattendancegrid(),
		gridSelCount = grid.getSelectionModel().getCount();
		if (gridSelCount > 0) {
			var arr = [];
			var gridModel = grid.getSelectionModel().getSelection();
			gridModel.forEach(function(obj){
				arr.push(obj.get('userId'));
			});
			var arryIds = arr.join(),
			formValues = updateattendanceformwindow.down('form').getValues();

			/*var attendanceFormData = new Object();
			attendanceFormData.buildingId = formValues.buildingCodeName;
			attendanceFormData.floorId = formValues.floorCodeNo;
			attendanceFormData.fromDate = formValues.fromDate;
			attendanceFormData.hostelId = formValues.hostelCodeName;
			attendanceFormData.toDate = formValues.toDate;
			attendanceFormData.attendanceStatus = formValues.winAttendanceStatus;
			attendanceFormData.remarks = formValues.winRemarks;
			attendanceFormData.userIds = arryIds;
			
			var jsonFormatFormData = Ext.encode(attendanceFormData);*/
			
			var Url = SERVERURL.HOSTEL_ATTENDANCE_FORCE_UPDATE +'?hostelId='+ formValues.hostelCodeName +'&buildingId='+ formValues.buildingCodeName 
			+'&floorId='+ formValues.floorCodeNo +'&userIds='+ arryIds +'&fromDate='+ formValues.fromDate +'&toDate='+ formValues.toDate
			+'&attendanceStatus='+ formValues.winAttendanceStatus+'&remarks='+ formValues.winRemarks;
			
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
				type: 'rest',
				url: Url,
				//jsonData: jsonFormatFormData,
				method: 'POST',
				success: function(form, action) {
					Ext.getBody().unmask();  
					updateattendanceformwindow.close();
					grid.getStore().reload();
					grid.getSelectionModel().deselectAll();
					showSuccessMessage(getHostelTranslation('HOSTEL_ATTENDANCE'), getHostelTranslation('EDIT_ATTENDENCE_SUCCCESS'));
				}
			});
		}
	},
   
   exportXlsHostelAttendanceReport : function(btn) {
		var $this = this;
   	var form = $this.getHostelattendancesearch();
		var values = form.getValues();
		var dt = new Date();
   	var dateString = Ext.Date.format(dt, 'YmdHis'); 
		var reportTitle = "Hostel Attendance Report"+"_"+dateString;
		var code = 'HOSTEL_ATTENDANCE_EXCEL_EXPORT_REPORT';
		var reportHeader = "Hostel Attendance Report";
		var sortingDirection,sortingProperty,grid = btn.up('grid');
		if(grid.store.getSorters() && grid.store.getSorters()[0]){
			sortingDirection= grid.store.getSorters()[0].direction;
			sortingProperty= grid.store.getSorters()[0].property;
		}
		var hostelId = form.down("#hostelCodeName");
		if(hostelId!=null){
			hostelId =hostelId.getValue();
			}
		
		var academyLocationIds =$this.getCurrentAcademyLocation();
		var buildingId = form.down("#buildingCodeName");
		if(buildingId!=null){
			buildingId = buildingId.getValue();
		}
		var floorId = form.down("#floorCodeNo");
		if(floorId!=null){
			floorId=floorId.getValue() ;
		}
		var userId = form.down("#studentName");
		if(userId!=null){
			userId = userId.getValue();
		}
		var attendanceStatus = form.down("#attendanceStatus");
		if(attendanceStatus!=null){
			attendanceStatus=attendanceStatus.getValue() ;
		}
		var fromDate = form.down("#fromDate");
		if(fromDate!=null){
			fromDate=fromDate.getValue() ;
		}
		var toDate = form.down("#toDate");
		if(toDate!=null){
			toDate=toDate.getValue() ;
		}
		
		var reportParams = new Object();
		reportParams.hostelId = hostelId;
		reportParams.buildingId = buildingId;
		reportParams.floorId = floorId;
		reportParams.userId = userId;
		reportParams.attendanceStatus = attendanceStatus;
		reportParams.fromDate = fromDate;
		reportParams.toDate = toDate;
		reportParams.direction = sortingDirection;
		reportParams.property = sortingProperty;
		
		reportParams.headerName = reportHeader;
		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.HOSTEL_ATTENDANCE_EXPORT_REPORT);
	},
	
	resetUserWise:function(obj){
		var form = obj.up('form');
		form.getForm().reset();
		this.onRenderStoreLoadofHDReport();
	},
	onRenderStoreLoadofHDReport:function(){
		var form = this.getHosteldetailsreportsearch();
		var buildingCodeName  = form.down('#buildingCodeName');
		var floorCodeNoField  = form.down('#floorCodeNo');
		var roomNoField  = form.down('#roomNo'),
 		userTypeField  = form.down('#userType');

		var buildingCodeStore =  buildingCodeName.getStore();
		var floorCodeNo = floorCodeNoField.getStore();
		var roomNo = roomNoField.getStore(),
		userTypeFldStore = userTypeField.getStore();

		var values = form.getForm().getValues();

		buildingCodeStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Building'
		};
		buildingCodeStore.load();

		floorCodeNo.getProxy().extraParams = {
			buildingCode:values.floorCodeNo,
			status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();

		roomNo.getProxy().extraParams = {
			floorCode:values.roomNo,
			status:values.status,
			resourceGroup:'Room'
		};
		roomNo.load();
		
		userTypeFldStore.load({
			callback:function(records, operation, success){
				if(records.length > 0){
					var rec = userTypeFldStore.findRecord('userGroupName',getCommonTranslation('STUDENT'));
					if(rec){
						userTypeField.setValue(rec.data.id);	
						var studentName = form.down('#studentName');
						var store = studentName.getStore();
						store.getProxy().extraParams = {
							userType: rec.data.id
						};
						store.load();
					}
				}
			}
		});
	},
});
