/**
 * @author Santosh Sahu
 * 
 */
Ext.define('Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',
	alias: "widget.sgstudentlibraryissuedbooktransactioncontroller",
	// un-comment the model code if required.
	models : ['kohalibrarytransaction.KohaMapAcademyLocationWithCategoryModel'],
	stores: ['kohalibrarytransation.SGStudentLibraryIssuedBookDetailStore','kohalibrarytransation.LibraryBookTitleStore',
		'kohalibrarytransation.LibraryBookAuthorStore','kohalibrarytransation.SGStudentLibraryReservedBookDetailStore',
		'kohalibrarytransation.LibraryCirculationHistoryStore','kohalibrarytransation.LibraryFeeDetailStore',
		'kohalibrarytransation.LibraryBranchAndCategoryStore','kohalibrarytransation.LibraryBranchStore',
		'kohalibrarytransation.LibraryCategoryStore','user.UserAcademyLocationStore','kohalibrarytransation.LibraryCardMappingStore',
		'kohalibrarytransation.KohaMapAcademyLocationWithLibraryStore','kohalibrarytransation.KohaMapAcademyLocationWithCategoryStore',
		'kohalibrarytransation.LibraryCardNoEnumStore','kohalibrarytransation.AcademyLocationCategoryStore',
		'kohalibrarytransation.AcademyLocationBranchStore','kohalibrarytransation.AcademyLocationCategoryStore',
		'kohalibrarytransation.LocationCategoryStore','kohalibrarytransation.LocationLibraryStore'],

		views: ['kohalibrarytransaction.SGStudentLibraryIssuedBookDetailGrid','kohalibrarytransaction.SGStudentLibraryReservedBookDetailGrid',
			'kohalibrarytransaction.LibraryCirculationHistoryFilter','kohalibrarytransaction.LibraryCirculationHistoryGrid',
			'kohalibrarytransaction.StudentLibraryBookCirculationStructure','kohalibrarytransaction.LibraryFeeDetailsGrid',
			'kohalibrarytransaction.LibrarbyBranchAndCategoryStructure','kohalibrarytransaction.LibraryBranchAndCategoryFilter',
			'kohalibrarytransaction.LibraryBranchAndCategoryGrid',
			'kohalibrarytransaction.KohaMapAcademyLocationWithCategoryGrid','kohalibrarytransaction.LibraryBranchAndCategoryGrid',
			'kohalibrarytransaction.LibraryCardMappingGrid','kohalibrarytransaction.LibraryCardNoMappingWin',
			'kohalibrarytransaction.KohaStudentLibraryMappingWin','kohalibrarytransaction.KohaStudentCategoryMappingWin',
			'kohalibrarytransaction.ViewAndDeleteLibrary','kohalibrarytransaction.ViewAndDeleteCategory',
			'kohalibrarytransaction.deleteLibraryForm','kohalibrarytransaction.deleteCategoryForm',
			'kohalibrarytransaction.AcademyLocationLibraryMappingStructure','kohalibrarytransaction.KohaMapAcademyLocationWithLibraryGrid'
			,'kohalibrarytransaction.LibraryMappingPanel','kohalibrarytransaction.LibraryCardAndCategoryPanel',
			'kohalibrarytransaction.LibraryCardNoMappingPanel'],
			refs: [{
				ref: 'searchResultGrid',
				selector: 'searchResultGrid'
			},{
				ref: 'sgstudentlibraryissuedbookdetailgrid',
				selector: 'sgstudentlibraryissuedbookdetailgrid'
			},{
				ref: 'sgstudentlibraryreservedbookdetailgrid',
				selector: 'sgstudentlibraryreservedbookdetailgrid'
			},{
				ref: 'librarycirculationhistoryfilter',
				selector: 'librarycirculationhistoryfilter'
			},{
				ref: 'librarycirculationhistorygrid',
				selector: 'librarycirculationhistorygrid'
			},{
				ref: 'studentlibrarybookcirculationstructure',
				selector: 'studentlibrarybookcirculationstructure'
			},{
				ref: 'libraryfeedetailsgrid',
				selector: 'libraryfeedetailsgrid'
			},{
				ref: 'librarybranchandcategoryfilter',
				selector: 'librarybranchandcategoryfilter'
			},{
				ref: 'librarybranchandcategorygrid',
				selector: 'librarybranchandcategorygrid'
			},{
				ref: 'librarbybranchandcategorystructure',
				selector: 'librarbybranchandcategorystructure'
			},{
				ref: 'kohamapacademylocationwithlibrarygrid',
				selector: 'kohamapacademylocationwithlibrarygrid'
			},{
				ref: 'kohamapacademylocationwithcategorygrid',
				selector: 'kohamapacademylocationwithcategorygrid'
			},{
				ref: 'librarycardmappinggrid',
				selector: 'librarycardmappinggrid'
			},{
				ref: 'librarycardnomappingwin',
				selector: 'librarycardnomappingwin'
			},{
				ref: 'viewanddeletelibrary',
				selector: 'viewanddeletelibrary'
			},{
				ref: 'viewanddeletecategory',
				selector: 'viewanddeletecategory'
			},{
				ref: 'deletelibraryform',
				selector: 'deletelibraryform'
			},{
				ref: 'deletecategoryform',
				selector: 'deletecategoryform'
			},{
				ref: 'academylocationlibrarymappingstructure',
				selector: 'academylocationlibrarymappingstructure'
			},{
				ref: 'librarymappingpanel',
				selector: 'librarymappingpanel'
			}
			],
			config : {
				STUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT'),
				STUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT'),
				STUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT'),
				STUDENT_LIBRARY_DUE_FEES_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LIBRARY_DUE_FEES_TO_STUDENT'),

				PARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT'),
				PARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT'),
				PARENT_BOOK_RESERVED_HISTORY_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_BOOK_RESERVED_HISTORY_TO_STUDENT'),
				PARENT_LIBRARY_DUE_FEES_TO_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_LIBRARY_DUE_FEES_TO_STUDENT'),

				EMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE'),
				EMPLOYEE_BOOK_CIRCULATION_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_BOOK_CIRCULATION_HISTORY'),
				EMPLOYEE_BOOK_RESERVED_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_BOOK_RESERVED_HISTORY'),
				EMPLOYEE_LIBRARY_DUE_FEES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_LIBRARY_DUE_FEES'),

				CORE_ERP_BOOK_ISSUED_STUDENT_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_BOOK_ISSUED_STUDENT_HISTORY'),
				CORE_ERP_BOOK_CIRCULATION_STUDENT_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_BOOK_CIRCULATION_STUDENT_HISTORY'),
				CORE_ERP_BOOK_RESERVED_STUDENT_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_BOOK_RESERVED_STUDENT_HISTORY'),
				CORE_ERP_LIBRARY_DUE_STUDENT_FEES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LIBRARY_DUE_STUDENT_FEES'),
				
				
				CORE_ERP_BOOK_ISSUED_EMPLOYEE_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_BOOK_ISSUED_EMPLOYEE_HISTORY'),
				CORE_ERP_BOOK_CIRCULATION_EMPLOYEE_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_BOOK_CIRCULATION_EMPLOYEE_HISTORY'),
				CORE_ERP_BOOK_RESERVED_EMPLOYEE_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_BOOK_RESERVED_EMPLOYEE_HISTORY'),
				CORE_ERP_LIBRARY_DUE_EMPLOYEE_FEES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LIBRARY_DUE_EMPLOYEE_FEES'),
				
				
				FPTOSP_ERP_BOOK_ISSUED_STUDENT_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FPTOSP_ERP_BOOK_ISSUED_STUDENT_HISTORY'),
				FPTOSP_ERP_BOOK_CIRCULATION_STUDENT_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FPTOSP_ERP_BOOK_CIRCULATION_STUDENT_HISTORY'),
				FPTOSP_ERP_BOOK_RESERVED_STUDENT_HISTORY: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FPTOSP_ERP_BOOK_RESERVED_STUDENT_HISTORY'),
				FPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES'),
				
				
				LIBRARY_BRANCH_AND_CATEGORY_MAPPING:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LIBRARY_BRANCH_AND_CATEGORY_MAPPING'),
				
				CORE_ERP_STUDENT_THESIS_TITLE:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_THESIS_TITLE'),
				CORE_ERP_STUDENT_POST_DOC_INFO:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_POST_DOC_INFO'),
				CORE_ERP_STUDENT_JOINT_DEGREE:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_JOINT_DEGREE'),
				CORE_ERP_STUDENT_OWN_PROGRESS_REPORT:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_OWN_PROGRESS_REPORT'),
				CORE_ERP_FUNCTIONARY_PROGRESS_REPORT:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_FUNCTIONARY_PROGRESS_REPORT'),
				CORE_ERP_STUDENT_MOU:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_MOU'),
				CORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER')

			},
			init: function() {
				this.control({
					 'viewanddeletelibrary': {
						 render: function(grid) {
							 this.doAccessControlValidation(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
								this.disableMoreActionExportReportPivileges(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
	                	   }
	                   },
	                   'viewanddeletecategory': {
							 render: function(grid) {
								 this.doAccessControlValidation(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
									this.disableMoreActionExportReportPivileges(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
		                	   }
		                   },
					'librarymappingpanel' : {
						tabchange : function(tabPanel, newCard, oldCard, eOpts ){
							var tab = tabPanel.activeTab.itemId ;
							switch(tab){
							case 'librarycardandcategorypanel' :{

								var librarycardandcategoryForm = tabPanel.down('#librarycardandcategorypanel');
								var grid = librarycardandcategoryForm.down('#librarybranchandcategorygrid');
								grid.getStore().load();
								break;
							}
							case 'librarycardnomappingpanel' :{

								var librarycardnomappingForm = tabPanel.down('#librarycardnomappingpanel');
								var grid = librarycardnomappingForm.down('#librarycardmappinggrid');
								this.doAccessControlValidation(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
								this.disableMoreActionExportReportPivileges(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
								grid.getStore().load();

								break;
							}
							}
						}
		        	},
					
					'librarybranchandcategoryfilter customcombobox[itemId=academyLocationCombo]': {
						render: function(combo) {
							var me = this;
							var store = combo.getStore();
							store.getProxy().extraParams = {
								id: this.getCurrentlyLoggedInUser().id
							};
							store.load();
						}
					}, 'kohastudentlibrarymappingwin button#saveBtn': {
	                	   click: function(obj) {
	                		   this.savelibraryDetails(obj);
	                	   }
	                   },
	                    'kohastudentcategorymappingwin button#saveBtn': {
	                	   click: function(obj) {
	                		   this.saveCategoryDetails(obj);
	                	   }
	                   },
					'librarycardmappinggrid button[itemId=btnEdit]': {
						click: function() {
							this.editLibraryCardMapping();
						}
					},
					'librarycardnomappingwin button[itemId=cardMappingCancelBtn]':{
						click:this.closeLibraryCardMappingFormWindow 
					},
					 'librarycardnomappingwin button[itemId=addLibraryCardSettingSubmitBtn]':{
            			 click:this.saveLibraryCardSettingFormWindow 
            		 },
					'kohamapacademylocationwithlibrarygrid': {
						afterrender: function() {
							var me = this;
							var grid =me.getKohamapacademylocationwithlibrarygrid();
							var store=grid.getStore();

							store.getProxy().extraParams = {
								id: this.getCurrentlyLoggedInUser().id
							};
							store.load();
						}
					},'librarycardmappinggrid': {
						render: function(combo) {
							var me = this;
							var store = combo.getStore();
							store.getProxy().extraParams = {
								id: this.getCurrentlyLoggedInUser().id
							};
							store.load();
						}
					},'kohamapacademylocationwithcategorygrid': {
						render: function(combo) {
							var me = this;
							var grid =me.getKohamapacademylocationwithcategorygrid();
							var store=grid.getStore();
							store.getProxy().extraParams = {
								id: this.getCurrentlyLoggedInUser().id
							};
							store.load();
						}
					},'librarybranchandcategoryfilter button[itemId=libraryConfigurationResetBtn]':{
						click :function(obj){ 
							var form =this.getLibrarybranchandcategoryfilter();
							form.getForm().reset();
						}
					},'librarybranchandcategoryfilter button[itemId=libraryConfigurationSearchBtn]':{
						click :function(obj){ 

							var form = obj.up('form');
							var academyLocationFilter = form.down('#academyLocationCombo');
							var libraryFilter = form.down('#library');
							var categoryFilter = form.down('#category');

							var grid =this.getLibrarybranchandcategorygrid();
							var store=grid.getStore();

							store.getProxy().extraParams={
								academyLocationId:academyLocationFilter.value,
								categoryId:categoryFilter.value,
								branchId:libraryFilter.value,
								id: this.getCurrentlyLoggedInUser().id
							},
							store.load();

						}
					},'librarybranchandcategoryfilter customcombobox#academyLocationCombo':{
						change : function(obj){
							var form = obj.up('form');
							var academyLocationFilter = form.down('#academyLocationCombo');
							var libraryFilter = form.down('#library');
							var categoryFilter = form.down('#category');

							libraryFilter.reset();
							categoryFilter.reset();

							var libraryStore=libraryFilter.getStore();
							var categoryStore=categoryFilter.getStore();

							libraryStore.getProxy().extraParams = {
								academyLocationId:academyLocationFilter.value
							};
							libraryStore.load();

							categoryStore.getProxy().extraParams = {
								academyLocationId:academyLocationFilter.value
							};
							categoryStore.load();
						}
					},
					'sgstudentlibraryissuedbookdetailgrid': {
						render: function(grid) {
							if(this.getCurrentLoggedPortalId()==3){

								this.doAccessControlValidation(grid,this.getSTUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());

							}else if(this.getCurrentLoggedPortalId()==7){

								this.doAccessControlValidation(grid,this.getPARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());

							}else if(this.getCurrentLoggedPortalId()==2){
								this.doAccessControlValidation(grid,this.getEMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE());
								
								this.doAccessControlValidation(grid,this.getFPTOSP_ERP_BOOK_ISSUED_STUDENT_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getFPTOSP_ERP_BOOK_ISSUED_STUDENT_HISTORY());
								
							}else{

								this.doAccessControlValidation(grid,this.getSTUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getPARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getEMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE());

								this.doAccessControlValidation(grid,this.getCORE_ERP_BOOK_ISSUED_STUDENT_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_BOOK_ISSUED_STUDENT_HISTORY());
								
								this.doAccessControlValidation(grid,this.getCORE_ERP_BOOK_ISSUED_EMPLOYEE_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_BOOK_ISSUED_EMPLOYEE_HISTORY());
							}
							grid.getStore().getProxy().extraParams = {
								id: this.getUserInfo()
							};
							grid.getStore().load();
						}
					},'sgstudentlibraryreservedbookdetailgrid': {
						render: function(grid) {
							if(this.getCurrentLoggedPortalId()==3){

								this.doAccessControlValidation(grid,this.getSTUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT());

							}else if(this.getCurrentLoggedPortalId()==7){

								this.doAccessControlValidation(grid,this.getPARENT_BOOK_RESERVED_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_BOOK_RESERVED_HISTORY_TO_STUDENT());

							}else if (this.getCurrentLoggedPortalId()==2){

								this.doAccessControlValidation(grid,this.getEMPLOYEE_BOOK_RESERVED_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_BOOK_RESERVED_HISTORY());
								
								this.doAccessControlValidation(grid,this.getFPTOSP_ERP_BOOK_RESERVED_STUDENT_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getFPTOSP_ERP_BOOK_RESERVED_STUDENT_HISTORY());

							}else{

								this.doAccessControlValidation(grid,this.getSTUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getPARENT_BOOK_RESERVED_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_BOOK_RESERVED_HISTORY_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getEMPLOYEE_BOOK_RESERVED_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_BOOK_RESERVED_HISTORY());

								this.doAccessControlValidation(grid,this.getCORE_ERP_BOOK_RESERVED_STUDENT_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_BOOK_RESERVED_STUDENT_HISTORY());
								
								this.doAccessControlValidation(grid,this.getCORE_ERP_BOOK_RESERVED_EMPLOYEE_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_BOOK_RESERVED_EMPLOYEE_HISTORY());
							}
							grid.getStore().getProxy().extraParams = {
								id: this.getUserInfo()
							};
							grid.getStore().load();
						}
					},'librarycirculationhistorygrid': {
						render: function(grid) {
							if(this.getCurrentLoggedPortalId()==3){

								this.doAccessControlValidation(grid,this.getSTUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());

							}else if(this.getCurrentLoggedPortalId()==7){

								this.doAccessControlValidation(grid,this.getPARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());

							}else if(this.getCurrentLoggedPortalId()==2){

								this.doAccessControlValidation(grid,this.getEMPLOYEE_BOOK_CIRCULATION_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_BOOK_CIRCULATION_HISTORY());
								
								this.doAccessControlValidation(grid,this.getFPTOSP_ERP_BOOK_CIRCULATION_STUDENT_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getFPTOSP_ERP_BOOK_CIRCULATION_STUDENT_HISTORY());

							}else{
								this.doAccessControlValidation(grid,this.getSTUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getPARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getEMPLOYEE_BOOK_CIRCULATION_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_BOOK_CIRCULATION_HISTORY());

								this.doAccessControlValidation(grid,this.getCORE_ERP_BOOK_CIRCULATION_STUDENT_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_BOOK_CIRCULATION_STUDENT_HISTORY());
								
								this.doAccessControlValidation(grid,this.getCORE_ERP_BOOK_CIRCULATION_EMPLOYEE_HISTORY());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_BOOK_CIRCULATION_EMPLOYEE_HISTORY());
							}
							grid.getStore().getProxy().extraParams = {
								id: this.getUserInfo()
							};
							grid.getStore().load();
						}
					},'libraryfeedetailsgrid': {
						render: function(grid) {
							var $this = this;
							if(this.getCurrentLoggedPortalId()==3){

								this.doAccessControlValidation(grid,this.getSTUDENT_LIBRARY_DUE_FEES_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_LIBRARY_DUE_FEES_TO_STUDENT());

							}else if(this.getCurrentLoggedPortalId()==7){

								this.doAccessControlValidation(grid,this.getPARENT_LIBRARY_DUE_FEES_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_LIBRARY_DUE_FEES_TO_STUDENT());

							}else if (this.getCurrentLoggedPortalId()==2){

								this.doAccessControlValidation(grid,this.getEMPLOYEE_LIBRARY_DUE_FEES());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_LIBRARY_DUE_FEES());
								

								this.doAccessControlValidation(grid,this.getFPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES());
								this.disableMoreActionExportReportPivileges(grid,this.getFPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES());
								

							}else{

								this.doAccessControlValidation(grid,this.getSTUDENT_LIBRARY_DUE_FEES_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getSTUDENT_LIBRARY_DUE_FEES_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getPARENT_LIBRARY_DUE_FEES_TO_STUDENT());
								this.disableMoreActionExportReportPivileges(grid,this.getPARENT_LIBRARY_DUE_FEES_TO_STUDENT());

								this.doAccessControlValidation(grid,this.getEMPLOYEE_LIBRARY_DUE_FEES());
								this.disableMoreActionExportReportPivileges(grid,this.getEMPLOYEE_LIBRARY_DUE_FEES());

								this.doAccessControlValidation(grid,this.getCORE_ERP_LIBRARY_DUE_STUDENT_FEES());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_LIBRARY_DUE_STUDENT_FEES());
								
								this.doAccessControlValidation(grid,this.getCORE_ERP_LIBRARY_DUE_EMPLOYEE_FEES());
								this.disableMoreActionExportReportPivileges(grid,this.getCORE_ERP_LIBRARY_DUE_EMPLOYEE_FEES());
							}
							grid.getStore().getProxy().extraParams = {
								id: this.getUserInfo()
							};
							grid.getStore().load({ 
								callback: function(record, operation, success) {
									if (record.length > 0) {
										$this.toggleGridSummaryRow(grid,true);
									}else{
										$this.toggleGridSummaryRow(grid,false);
									}
								}
							});
						}
					},'studentlibrarybookcirculationstructure': {
						render: function(grid) {

						}
					},'librarycirculationhistoryfilter customcombobox[itemId=author]':{
						render: function(cmb){
							var store = cmb.getStore();
							store.getProxy().extraParams = {
								id: this.getUserInfo()
							};
							store.load();
						}
					},'librarycirculationhistoryfilter button[itemId=circulationBookResetBtn]':{
						click :function(obj){ 
							var form =this.getLibrarycirculationhistoryfilter();
							form.getForm().reset();
						}
					},'librarycirculationhistoryfilter customcombobox#title':{
						change : function(obj){
							var form = obj.up('form');
							var bookTitle = form.down('#title');
							var authorFilter = form.down('#author');

							authorFilter.reset();

							var authorFilter=authorFilter.getStore();

							authorFilter.getProxy().extraParams = {
								id: this.getUserInfo(),
								title:bookTitle.value
							};
							authorFilter.load();
						}
					},'librarycirculationhistoryfilter customcombobox[itemId=title]':{
						render: function(cmb){
							var store = cmb.getStore();
							store.getProxy().extraParams = {
								id: this.getUserInfo()
							};
							store.load();
						}
					},'librarbybranchandcategorystructure': {
						render: function(grid) {

						}
					},'librarymappingpanel': {
						render: function(grid) {
							this.doAccessControlValidation(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
							this.disableMoreActionExportReportPivileges(grid,this.getLIBRARY_BRANCH_AND_CATEGORY_MAPPING());
						}
					},'librarybranchandcategorygrid': {
						render: function(grid){
							grid.getStore().getProxy().extraParams = {
								id: this.getCurrentlyLoggedInUser().id
							};
							grid.getStore().load();
						},
						cellclick : function(grid,td,cellIndex,record,tr,rowIndex, e, eOpts ) {
            				var $this=this;
            				var parameterassigngrid = $this.getLibrarybranchandcategorygrid();
            				var columnName=parameterassigngrid.columnManager.columns[cellIndex].dataIndex;
            				if(columnName=='branchCount') {
            					if (e.target.tagName == 'A') {
            						$this.viewAssignedLibrary(grid, rowIndex, record);
            					}
            				}
            				if(columnName=='categoryCount') {
            					if (e.target.tagName == 'A') {
            						$this.viewAssignedCategory(grid, rowIndex, record);
            					}
            				}
            				
            			}
					}, 'librarybranchandcategorygrid button[itemId=mapLibraryBtn]':{
						click: function(button){
							var me = this;
							var mapLibrarygrid = button.up('grid');
							var gridRecord=mapLibrarygrid.getSelectionModel().getSelection()[0];
							if(mapLibrarygrid.getSelectionModel().getCount() > 0){
								var academyLocationId = gridRecord.data.academyLocationId;
								var contentpanel = me.getContentPanel();
								var applyToTab = Ext.widget('kohamapacademylocationwithlibrarygrid',{
									academyLocationId:academyLocationId
								});
								var tabName = getCommonTranslation('MAP_LIBRARY');
								var getcontroller=this.getController('menu.CoreERPNavigationController');
								var getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentpanel.remove(getTab, true);
								}
								openTab(contentpanel, tabName, applyToTab, CONSTANTS.MENU_COLOR_THIRTEEN);
							}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},'librarybranchandcategoryfilter': {
						render: function(grid) {
							var grid = this.getLibrarybranchandcategoryfilter();
						}
					},'librarybranchandcategorygrid button[itemId=patronCategoryMapBtn]': {
					click: function(button){
						var me = this;
						var mapLibrarygrid = button.up('grid');
						var gridRecord=mapLibrarygrid.getSelectionModel().getSelection()[0];
						if(mapLibrarygrid.getSelectionModel().getCount() > 0){
							var academyLocationId = gridRecord.data.academyLocationId;
							var contentpanel = me.getContentPanel();
							var applyToTab = Ext.widget('kohamapacademylocationwithcategorygrid',{
								academyLocationId:academyLocationId
							});
							var tabName = getCommonTranslation('LIST_OF_PATRON_CATEGORY');
							var getcontroller=this.getController('menu.CoreERPNavigationController');
							var getTab=getcontroller.getTab(tabName);
							if(getTab!=null){
								contentpanel.remove(getTab, true);
							}
							openTab(contentpanel, tabName, applyToTab, CONSTANTS.MENU_COLOR_THIRTEEN);
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
				},
				 'kohamapacademylocationwithlibrarygrid textfield[itemId=librarySearch]' : {
        			 change : function(obj) {
        				 var $this = this;
        				 var libraryValue =  obj.getValue();
        				 var libraryName = libraryValue.trim(); 
        				 if(libraryName.length >= 3){
        				 var store = this.getStore('kohalibrarytransation.LocationLibraryStore');
        					 store.getProxy().extraParams = {
        						 qry:libraryName,
        					 };
        					 $this.resetPageSetting(store);
        					 store.loadPage(1);
        				 }else if(libraryName.length == 0){
        					 var store = this.getStore('kohalibrarytransation.LocationLibraryStore');
        					 store.getProxy().extraParams = {
        						 qry:libraryName,
        					 };
        					 $this.resetPageSetting(store);
        					 store.loadPage(1); 
        				 }
        				 }
        		 },
				 'kohamapacademylocationwithcategorygrid textfield[itemId=categorySearch]' : {
        			 change : function(obj) {
        				 var $this = this;
        				 var categoryValue =  obj.getValue();
        				 var categoryName = categoryValue.trim(); 
        				 if(categoryName.length >= 3){
        				 var store = this.getStore('kohalibrarytransation.LocationCategoryStore');
        					 store.getProxy().extraParams = {
        						 qry:categoryName,
        					 };
        					 $this.resetPageSetting(store);
        					 store.loadPage(1);
        				 }else if(categoryName.length == 0){
        					 var store = this.getStore('kohalibrarytransation.LocationCategoryStore');
        					 store.getProxy().extraParams = {
        						 qry:categoryName,
        					 };
        					 $this.resetPageSetting(store);
        					 store.loadPage(1); 
        				 }
        				 }
        		 },
					'kohamapacademylocationwithlibrarygrid button[itemId=submitBtnId]': {
						click: function(button) {
							var $this = this;
							var grid = $this.getKohamapacademylocationwithlibrarygrid();
							var form =this.getKohamapacademylocationwithlibrarygrid();
							
							if (grid.getSelectionModel().getCount() > 0) {
								$this.mapLibraryInAcademyLocation(grid,form.academyLocationId); 
							}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},
					'kohamapacademylocationwithcategorygrid button[itemId=submitBtnId]': {
						click: function(button) {
							var $this = this;
							var grid = $this.getKohamapacademylocationwithcategorygrid();
							var form =this.getKohamapacademylocationwithcategorygrid();
							if (grid.getSelectionModel().getCount() > 0) {
								$this.mapCategoryInAcademyLocation(grid,form.academyLocationId); 
							}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},'kohamapacademylocationwithlibrarygrid button[itemId=btnReset]':{
						click :function(obj){ 
							var grid =this.getKohamapacademylocationwithlibrarygrid();
							grid.down('#librarySearch').reset();
						}
					},'kohamapacademylocationwithcategorygrid button[itemId=btnReset]':{
						click :function(obj){ 
							var grid =this.getKohamapacademylocationwithcategorygrid();
							grid.down('#categorySearch').reset();
						}
					},
					'librarycirculationhistoryfilter button[itemId=circulationBookSearchBtn]': {
						click: function(obj){ 
							var $this=this;
							var form = this.getLibrarycirculationhistoryfilter();
							var values = form.getValues();

							var startDate = values.startDate;
							var endDate = values.endDate;

							var fromDate;
							if(!isNullOrEmpty(startDate)){
								fromDate = startDate;
							}else{
								fromDate = '';
							}

							var toDate;
							if(!isNullOrEmpty(endDate)){
								toDate = endDate;
							}else{
								toDate = '';
							}

							var bookTitle = form.down("#title");
							var bookAuthor = form.down("#author");

							var grid =this.getLibrarycirculationhistorygrid();
							var store=grid.getStore();

							store.getProxy().extraParams={
								title:bookTitle.value,
								author:bookAuthor.value,
								toDate:toDate,
								fromDate:fromDate,
								id: this.getUserInfo()
							},
							store.load();
						}
					},'deletelibraryform button[itemId=librarybtnDeleteItemId]':{
            			click:function(){
            				var $this = this;
            				var grid=$this.getViewanddeletelibrary();
            				if (grid.getSelectionModel().getCount() > 0) {	
            					var records=grid.getSelectionModel().getSelection()[0];
            					showConfirmMessage(getCommonTranslation('LIBRARY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            						if (btn == 'yes') {
            							Ext.Ajax.request({
            								type: 'rest',
            								url: SERVERURL.DELETE_LIBRARY_URL+'id='+records.data.academicTermId,
            								method: 'DELETE',
            								success: function(f, action) {
            									if(f.responseText=="DEPENDENCY_EXISTS"){
            										showWarningMessage(getCommonTranslation('ALERT'),
            												getCommonTranslation('DEPENDENT_RECORD_EXISTS_CATEGORY_LIBRARY'));
            									}else{
            									showSuccessMessage(getCommonTranslation('LIBRARY'), getCommonTranslation('LIBRARY_SUCCESSFULLY_DELETED'));
            									var grid=$this.getViewanddeletelibrary();
            									grid.getStore().load();
            									var form =$this.getLibrarybranchandcategoryfilter();
            									var academyLocationFilter = form.down('#academyLocationCombo');
            									var libraryFilter = form.down('#library');
            									var categoryFilter = form.down('#category');

            									var grid =$this.getLibrarybranchandcategorygrid();
            									var store=grid.getStore();

            									store.getProxy().extraParams={
            										academyLocationId:academyLocationFilter.value,
            										categoryId:categoryFilter.value,
            										branchId:libraryFilter.value,
            										id: $this.getCurrentlyLoggedInUser().id
            									},
            									store.load();
            									}
            								}
            							});
            						}
            					});

            				}else{
            					showWarningMessage(getCommonTranslation('LIBRARY'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            				}
            			}
            		},'deletecategoryform button[itemId=categorybtnDeleteItemId]':{
            			click:function(){
            				var $this = this;
            				var grid=$this.getViewanddeletecategory();
            				if (grid.getSelectionModel().getCount() > 0) {	
            					var records=grid.getSelectionModel().getSelection()[0];
            					showConfirmMessage(getCommonTranslation('PATRON_CATEGORY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
            						if (btn == 'yes') {
            							Ext.Ajax.request({
            								type: 'rest',
            								url: SERVERURL.DELETE_CATEGORY_URL+'id='+records.data.academicTermId,
            								method: 'DELETE',
            								success: function(f, action) {
            									if(f.responseText=="DEPENDENCY_EXISTS"){
            										showWarningMessage(getCommonTranslation('ALERT'),
            												getCommonTranslation('DEPENDENT_RECORD_EXISTS_CATEGORY_LIBRARY'));
            									}else{
            										showSuccessMessage(getCommonTranslation('PATRON_CATEGORY'), getCommonTranslation('CATEGORY_SUCCESSFULLY_DELETED'));
            										var grid=$this.getViewanddeletecategory();
            										grid.getStore().load();

            										var form =$this.getLibrarybranchandcategoryfilter();
            										var academyLocationFilter = form.down('#academyLocationCombo');
            										var libraryFilter = form.down('#library');
            										var categoryFilter = form.down('#category');

            										var grid =$this.getLibrarybranchandcategorygrid();
            										var store=grid.getStore();

            										store.getProxy().extraParams={
            											academyLocationId:academyLocationFilter.value,
            											categoryId:categoryFilter.value,
            											branchId:libraryFilter.value,
            											id: $this.getCurrentlyLoggedInUser().id
            										},
            										store.load();
            									}
            									
            								}
            							});
            						}
            					});

            				}else{
            					showWarningMessage(getCommonTranslation('PATRON_CATEGORY'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            				}
            			}
            		},
				}); 	
			},disableMoreActionExportReportPivileges: function(from,permissionsMap) {
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				var form = this.getSgstudentlibraryissuedbookdetailgrid();
				var form = this.getSgstudentlibraryreservedbookdetailgrid();
				var form = this.getLibrarycirculationhistorygrid();
				var form = this.getLibraryfeedetailsgrid();
				var form = this.getLibrarybranchandcategorygrid();
				var form = this.getLibrarybranchandcategorygrid();
				var form = this.getViewanddeletelibrary();
				var form = this.getViewanddeletecategory();
				var form = this.getLibrarycardmappinggrid();
				var updateLibraryCardSetting=from.down('#btnEdit');
				
		
				var mapLibrary=from.down('#mapLibraryBtn');
				var mapCategory=from.down('#patronCategoryMapBtn');
				
				var deleteCategory=from.down('#categorybtnDeleteItemId');
				var deleteLibrary=from.down('#librarybtnDeleteItemId');
				
				var exportPDFReports=from.down('#btnExportToPDF');
				var exportExcelReports=from.down('#btnExportToExcel');

				if(mapLibrary!=null){
				mapLibrary.setVisible(false);
				}if(mapCategory!=null){
				mapCategory.setVisible(false);
				}
				if(exportPDFReports!=null){
				exportPDFReports.setVisible(false);
				}if(exportExcelReports!=null){
				exportExcelReports.setVisible(false);
				}
				if(updateLibraryCardSetting!=null){
				updateLibraryCardSetting.setVisible(false);
				}
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'Edit') {
						if(!isNullOrEmpty(updateLibraryCardSetting)){
							updateLibraryCardSetting.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'Delete') {
						if(!isNullOrEmpty(deleteCategory)){
							deleteCategory.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'Delete') {
						if(!isNullOrEmpty(deleteLibrary)){
							deleteLibrary.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'MAP_LIBRARY') {
						if(!isNullOrEmpty(mapLibrary)){
							mapLibrary.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'MAP_CATEGORY') {
						if(!isNullOrEmpty(mapCategory)){
							mapCategory.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'DELETE') {
						if(!isNullOrEmpty(mapCategory)){
							mapCategory.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'EXPORT') {
						if(!isNullOrEmpty(exportPDFReports)){
							exportPDFReports.setVisible(true);	
						}
					} 
				});
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'EXPORT') {
						if(!isNullOrEmpty(exportExcelReports)){
							exportExcelReports.setVisible(true);	
						}
					} 
				});
			}, closeLibraryCardMappingFormWindow : function(){
				var frmWin = this.getLibrarycardnomappingwin();
				frmWin.close();
			}, 
			
			saveLibraryCardSettingFormWindow:function(){
			    	 var $this = this;
			    	 var form = $this.getLibrarycardnomappingwin();
			    	 var cardNoTypeFilter = form.down("#cardNoType");
			    	 var grid = $this.getLibrarycardmappinggrid();
			    	 var searchTab = grid.up('tabpanel').getActiveTab();
					 var records = grid.getSelectionModel().getSelection();
			    	 
					 searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			    	 var url = SERVERURL.PATH_SAVE_LIBRARY_CARD_SETTING;
			 		Ext.Ajax.request({
			 			method: "GET",
			 			type: 'rest',
			 			url: url,
			 			params: {
			 				userType:records[0].data.userType,
			 				id:records[0].data.id,
			 				libraryCardNumberType: cardNoTypeFilter.value,
			 				userId:this.getCurrentlyLoggedInUser().id
			 			},
			 			success: function(f, action) {
			 				searchTab.body.unmask();
			 				showSuccessMessage(getCommonTranslation('LIBRARY_CARD_SETTING'), getCommonTranslation('SUCCESS'));
			 				$this.getLibrarycardnomappingwin().close();
			 				grid.getStore().load();
			 			}
			 		});
			     },
			     editLibraryCardMapping: function() {
			    	 var me = this;
			    	 var grid = me.getLibrarycardmappinggrid();
			    	 if (grid.getSelectionModel().getCount() > 0) {
			    		 var records = grid.getSelectionModel().getSelection();
			    		 var formWindow = me.getLibrarycardnomappingwin();

			    		 if (records != "" && records != null && records != undefined) {
			    			 if (!formWindow) {
			    				 Ext.widget('librarycardnomappingwin');
			    				 formWindow = me.getLibrarycardnomappingwin();
			    			 }
			    			 formWindow.show();

			    			 var userType=records[0].data.userType;
			    			 var cardNoType=records[0].data.libraryCardNumberType;
			    			 if(cardNoType=='Student ID'){
			    				 cardNoType='STUDENT_ID';
			    			 }else if(cardNoType=='Admission ID'){
			    				 cardNoType='ADMISSION_ID';
			    			 }else if(cardNoType=='Employee ID'){
			    				 cardNoType='EMPLOYEE_ID';
			    			 }else if(cardNoType=='Employee Code'){
			    				 cardNoType='EMPLOYEE_CODE';
			    			 }
			    			 var cardNoTypeFilter = formWindow.down('#cardNoType');

			    			 cardNoTypeFilter.reset();

			    			 var userTypeFilterStore=cardNoTypeFilter.getStore();

			    			 userTypeFilterStore.getProxy().extraParams = {
			    				 userType: userType
			    			 };
			    			 userTypeFilterStore.load();
			    			 
			    			 var formWindow = me.getLibrarycardnomappingwin();

			    			 var formPnl = formWindow.down('form');
			    			 
			    			 var rec = new Academia.model.kohalibrarytransaction.LibraryCardNumberMappingModel(
			    					 records[0].data);
			    			 formPnl.loadRecord(rec);
			    			 formPnl.down('#cardNoType').setValue(cardNoType);
			    			 /*grid.getStore().load({
			    				 callback: function(){
			    					 
	           						}
			    			 });*/
			    		 }
			    		 
			    	 } else {
			    		 showWarningMessage(getCommonTranslation('CARD_SETTING'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
			    	 }
			     }, savelibraryDetails:function(obj){
			     	var $this = this;
			    	var grid = $this.getSearchResultGrid();
			    	var searchTab = grid.up('tabpanel').getActiveTab();
			    	var form = $this.getKohastudentlibrarymappingwin().getForm();
			    	var surveyId = form.findField('library').getValue();
			    	var surveyUrl = form.findField('library').getRawValue();

			    	var jsonData = [];
			    	var selected = grid.selModel.getSelection();
			    	if( selected.length > 0){
			    		
			    		for( var i = 0; i < selected.length; i++) {
			    			jsonData.push({
			    				"id":selected[i].data.ID,
			    				"surveyMaster" : $this.getIdValueJson(surveyId),
//			  					"userId":selected[i].data.ID,
			    				"surveyUrl" : surveyUrl, //+ '&userId=' + selected[i].data.ID,
			    				"applicant": null,
			    				"student": $this.getIdValueJson(selected[i].data.ID),
			    				"enquiry": null,
			    				"user" : null,
			    				"userType":"STUDENT"

			    			});
			    		}
			    	}
			    	searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			    	submitUrl = SERVERURL.MAP_LIBRARY_WITH_STUDENT_AND_EMPLOYEE;
			 		Ext.Ajax.request({
			 			type : 'rest',
			 			url : submitUrl,
			 			jsonData : jsonData,
			 			method : 'POST',
			 			success : function(form, action) {
			 				searchTab.body.unmask();
			 				showSuccessMessage(getCommonTranslation('SAVE_LIBRARY'),getCommonTranslation('SUCCESS'));
			 				grid.getStore().reload();
//			 				$this.getStudentsendsurvey().close();
			 				obj.up('window').close();
			 			}
			 		});
			    },
			    saveCategoryDetails:function(obj){
			     	var $this = this;
			    	var grid = $this.getSearchResultGrid();
			    	var searchTab = grid.up('tabpanel').getActiveTab();
			    	var form = $this.getKohastudentcategorymappingwin().getForm();
			    	var surveyId = form.findField('category').getValue();
			    	var surveyUrl = form.findField('category').getRawValue();

			    	var jsonData = [];
			    	var selected = grid.selModel.getSelection();
			    	if( selected.length > 0){
			    		
			    		for( var i = 0; i < selected.length; i++) {
			    			jsonData.push({
			    				"id":selected[i].data.ID,
			    				"surveyMaster" : $this.getIdValueJson(surveyId),
//			  				"userId":selected[i].data.ID,
			    				"surveyUrl" : surveyUrl, //+ '&userId=' + selected[i].data.ID,
			    				"applicant": null,
			    				"student": $this.getIdValueJson(selected[i].data.ID),
			    				"enquiry": null,
			    				"user" : null,
			    				"userType":"STUDENT"

			    			});
			    		}
			    	}
			    	searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			    	submitUrl = SERVERURL.MAP_CATEGORY_WITH_STUDENT_AND_EMPLOYEE;
			 		Ext.Ajax.request({
			 			type : 'rest',
			 			url : submitUrl,
			 			jsonData : jsonData,
			 			method : 'POST',
			 			success : function(form, action) {
			 				searchTab.body.unmask();
			 				showSuccessMessage(getCommonTranslation('SAVE_CATEGORY'),getCommonTranslation('SUCCESS'));
			 				grid.getStore().reload();
//			 				$this.getStudentsendsurvey().close();
			 				obj.up('window').close();
			 			}
			 		});
			    }, viewAssignedLibrary:function(grid, rowIndex, record){
 	        	   var $this = this;
	        	   var formWindow = $this.getDeletelibraryform();
	        	   if (!formWindow) {
	        		   Ext.widget('deletelibraryform');
	        		   formWindow = $this.getDeletelibraryform();
	        	   }
	        	   formWindow.show();
	        	   var libraryStore=$this.getDeletelibraryform().down('grid').getStore();
	        	   
	        	   libraryStore.getProxy().extraParams ={
	        		   academyLocationId :record.data.academyLocationId,
	        	   },
	        	   libraryStore.load();
	        	   
	        	   
	           }, viewAssignedCategory:function(grid, rowIndex, record){
 	        	   var $this = this;
	        	   var formWindow = $this.getDeletecategoryform();
	        	   if (!formWindow) {
	        		   Ext.widget('deletecategoryform');
	        		   formWindow = $this.getDeletecategoryform();
	        	   }
	        	   formWindow.show();
	        	   var libraryStore=$this.getDeletecategoryform().down('grid').getStore();
	        	   libraryStore.getProxy().extraParams ={
	        		   academyLocationId :record.data.academyLocationId,
	        	   },
	        	   libraryStore.load();
	           }, 
	           mapLibraryInAcademyLocation:function(grid,academyLocationId){
	           	var $this = this;
	           	var searchTab = grid.up('tabpanel').getActiveTab();
	           	var libraryGrid = $this.getLibrarybranchandcategorygrid();
	           	var selected = libraryGrid.selModel.getSelection();
	           	var libraryName;
	           	if (grid.getSelectionModel().getCount() > 0) {
	           		var records = grid.getSelectionModel().getSelection();

	           		var alreadyMappedBranchArray=[];
	           		var notMappedLibraryArray=[];
	           		for(var j=0;j<records.length;j++){
	           			/*if(records[j].data.academicTermId!=null){
	           				alreadyMappedBranchArray.push(
	           				records[j].data.code
	           				);
	           			}else{*/
	           				notMappedLibraryArray.push(
		        					   records[j].data.code
		        				   );
//	        			   }
	        			   }

	           		if(alreadyMappedBranchArray.length>0){
	           			messageText=getCommonTranslation('LIBRARY_ALREADY_MAPPING_ALERT');
	           			messageText = messageText + "<p style=\"height: auto;max-height:100px;display:block;float:left;width:100%;overflow-y:auto;\">";
	           			for(var m=0;m<alreadyMappedBranchArray.length;m++){
	           				messageText = messageText + alreadyMappedBranchArray[m]+"<br />";
	           			}
	           			if(notMappedLibraryArray.length>0){
	           			messageText = messageText +"<br />";
	           			messageText = messageText + "Do you want to Map the following Libraries?"+"<br />";
	           			messageText = messageText +"<br />";
	           			}
	           			for(var n=0;n<notMappedLibraryArray.length;n++){
	           				messageText = messageText + notMappedLibraryArray[n]+"<br />";
	           			}
	           				if(alreadyMappedBranchArray.length>0 && notMappedLibraryArray.length==0){
	           						showWarningMessage(getCommonTranslation('MAP_LIBRARY'),messageText);
	           				}else{
	           					showConfirmMessage(getCommonTranslation('MAP_LIBRARY'), messageText, function(btn, text) {
	           						if (btn == 'yes') {
	           							var branchArrary = [];
	           							for(var i=0; i<records.length;i++){
	           								if(records[i].data.academicTermId==null){
	           									branchArrary.push({
	           										"libraryId": records[i].data.id,
	           										"academyLocationId": academyLocationId,
	           										"userId":$this.getCurrentlyLoggedInUser().id
	           									}); 
	           								}
	           							}
	           							searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	           							submitUrl = SERVERURL.MAP_ACADEMY_LIBRARY;
	           							Ext.Ajax.request({
	           								type : 'rest',
	           								url : submitUrl,
	           								jsonData : branchArrary,
	           								method : 'POST',
	           								timeout: CONSTANTS.AJAX_TIMEOUT,
	           								success : function(form, action) {
	           									searchTab.body.unmask();
	           									//Ext.JSON.decode(form.responseText);
	           									showSuccessMessage(getCommonTranslation('MAP_LIBRARY'),getCommonTranslation('MAP_LIBRARY_SUCCESS'));
	           									grid.getStore().load({
	           										callback: function(){
	           											searchTab.body.unmask();
	           										}
	           									});
	           									var libraryGrid = $this.getLibrarybranchandcategorygrid();
	           									var filter= $this.getLibrarybranchandcategoryfilter();

	           									academyLocationFilter=filter.down('#academyLocationCombo');
	           									libraryFilter=filter.down('#library');
	           									categoryFilter=filter.down('#category');

	           									store=libraryGrid.getStore();
	           									store.getProxy().extraParams={
	           										academyLocationId:academyLocationFilter.value,
	           										categoryId:categoryFilter.value,
	           										branchId:libraryFilter.value,
	           										id:$this.getCurrentlyLoggedInUser().id
	           									},
	           									store.load();
	           									var libraryGrid=$this.getKohamapacademylocationwithlibrarygrid();
	           									libraryStore=libraryGrid.getStore();
	           									libraryStore.getProxy().extraParams={
	        		           						academyLocationId:academyLocationFilter.value
	        									}
	           		           					libraryStore.load();
	           								},
	           							});	
	           						}
	           					});
	           				}
	           		}else {
	           			var branchArrary = [];
	           			for(var i=0; i<records.length;i++){
	           				if(records[i].data.academicTermId!=null){
	           					branchArrary.push({
	           						"libraryId": records[i].data.id,
	           						"academyLocationId": academyLocationId,
	           						"userId":$this.getCurrentlyLoggedInUser().id
	           					}); 
	           				}
	           			}
	           			searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	           			submitUrl = SERVERURL.MAP_ACADEMY_LIBRARY;
	           			Ext.Ajax.request({
	           				type : 'rest',
	           				url : submitUrl,
	           				jsonData : branchArrary,
	           				method : 'POST',
	           				timeout: CONSTANTS.AJAX_TIMEOUT,
	           				success : function(form, action) {
	           					searchTab.body.unmask();
	           					//Ext.JSON.decode(form.responseText);
	           					showSuccessMessage(getCommonTranslation('MAP_LIBRARY'),getCommonTranslation('MAP_LIBRARY_SUCCESS'));
	           					grid.getStore().load({
	           						callback: function(){
	           							searchTab.body.unmask();
	           						}
	           					});
	           					var libraryGrid = $this.getLibrarybranchandcategorygrid();
	           					var filter= $this.getLibrarybranchandcategoryfilter();
	           					
	           					academyLocationFilter=filter.down('#academyLocationCombo');
	           					libraryFilter=filter.down('#library');
	           					categoryFilter=filter.down('#category');
	           					
	           					store=libraryGrid.getStore();
	           					store.getProxy().extraParams={
	           						academyLocationId:academyLocationFilter.value,
	           						categoryId:categoryFilter.value,
	           						branchId:libraryFilter.value,
	           						id:$this.getCurrentlyLoggedInUser().id
	           					},
	           					store.load();
	           						var libraryGrid=$this.getKohamapacademylocationwithlibrarygrid();
									libraryStore=libraryGrid.getStore();
									libraryStore.getProxy().extraParams={
		           						academyLocationId:academyLocationFilter.value
									}
		           					libraryStore.load();
	           				},
	           			});
	           		}
	           	}
	           },  mapCategoryInAcademyLocation:function(grid,academyLocationId){
	        	   var $this = this;
	        	   var libraryGrid = $this.getLibrarybranchandcategorygrid();
	        	   var selected = libraryGrid.selModel.getSelection();
	        	   var searchTab = grid.up('tabpanel').getActiveTab();

	        	   if (grid.getSelectionModel().getCount() > 0) {
	        		   var records = grid.getSelectionModel().getSelection();
	        		   var alreadyMappedCategoryArray=[];
	        		   var notMappedCategoryArray=[];
	        		   for(var j=0;j<records.length;j++){
	        			 /*  if(records[j].data.academicTermId!=null){
	        				   alreadyMappedCategoryArray.push(
	        					   records[j].data.code
	        				   );
	        			   }else{*/
	        				   		notMappedCategoryArray.push(
		        					   records[j].data.code
		        				   );
//	        			   }
	        			   }

	        		   if(alreadyMappedCategoryArray.length>0){
	        			   messageText=getCommonTranslation('CATEGORY_ALREADY_MAPPING_ALERT');
		           			messageText = messageText + "<p style=\"height: auto;max-height:100px;display:block;float:left;width:100%;overflow-y:auto;\">";
		           			for(var m=0;m<alreadyMappedCategoryArray.length;m++){
		           				messageText = messageText + alreadyMappedCategoryArray[m]+"<br />";
		           			}
		           			if(notMappedCategoryArray.length>0){
		           			messageText = messageText +"<br />";
		           			messageText = messageText + "Do you want to Map the following Patron categories?"+"<br />";
		           			messageText = messageText +"<br />";
		           			}
		           			for(var n=0;n<notMappedCategoryArray.length;n++){
		           				messageText = messageText + notMappedCategoryArray[n]+"<br />";
		           			}
		           			if(alreadyMappedCategoryArray.length>0 && notMappedCategoryArray.length==0){
	        			   showWarningMessage(getCommonTranslation('MAP_PATRON_CATEGORY'),messageText);
		           			}else {

		           				showConfirmMessage(getCommonTranslation('MAP_PATRON_CATEGORY'), messageText, function(btn, text) {
		           					if (btn == 'yes') {

		           						var branchArrary = [];
		           						for(var i=0; i<records.length;i++){
		           							branchArrary.push({
		           								"categoryId": records[i].data.id,
		           								"academyLocationId": academyLocationId,
		           								"userId":$this.getCurrentlyLoggedInUser().id
		           							}); 
		           						}
		           						searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		           						submitUrl = SERVERURL.MAP_ACADEMY_CATEGORY;
		           						Ext.Ajax.request({
		           							type : 'rest',
		           							url : submitUrl,
		           							jsonData : branchArrary,
		           							method : 'POST',
		           							timeout: CONSTANTS.AJAX_TIMEOUT,
		           							success : function(form, action) {
		           								searchTab.body.unmask();
		           								//Ext.JSON.decode(form.responseText);
		           								showSuccessMessage(getCommonTranslation('MAP_PATRON_CATEGORY'),getCommonTranslation('MAP_CATEGORY_SUCCESS'));

		           								grid.getStore().load({
		           									callback: function(){
		           										searchTab.body.unmask();
		           									}
		           								});
		           								var libraryGrid = $this.getLibrarybranchandcategorygrid();
		           								var filter= $this.getLibrarybranchandcategoryfilter();

		           								academyLocationFilter=filter.down('#academyLocationCombo');
		           								libraryFilter=filter.down('#library');
		           								categoryFilter=filter.down('#category');

		           								store=libraryGrid.getStore();
		           								store.getProxy().extraParams={
		           									academyLocationId:academyLocationFilter.value,
		           									categoryId:categoryFilter.value,
		           									branchId:libraryFilter.value,
		           									id:$this.getCurrentlyLoggedInUser().id
		           								},
		           								store.load();
		           								
		           								var categoryGrid=$this.getKohamapacademylocationwithcategorygrid();
	           									categoryStore=categoryGrid.getStore();
	           									categoryStore.getProxy.extraParams={
	           											academyLocationId:academyLocationFilter.value
	           									}
	           									categoryStore.load();
		           								
		           							},
		           						});
		           					}
		           				});

		           			}
	        		   }else{
	        			   var branchArrary = [];
	        			   for(var i=0; i<records.length;i++){
	        				   branchArrary.push({
	        					   "categoryId": records[i].data.id,
	        					   "academyLocationId": academyLocationId,
	        					   "userId":$this.getCurrentlyLoggedInUser().id
	        				   }); 
	        			   }
	        			   searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        			   submitUrl = SERVERURL.MAP_ACADEMY_CATEGORY;
	        			   Ext.Ajax.request({
	        				   type : 'rest',
	        				   url : submitUrl,
	        				   jsonData : branchArrary,
	        				   method : 'POST',
	        				   timeout: CONSTANTS.AJAX_TIMEOUT,
	        				   success : function(form, action) {
	        					   searchTab.body.unmask();
	        					   //Ext.JSON.decode(form.responseText);
	        					   showSuccessMessage(getCommonTranslation('MAP_PATRON_CATEGORY'),getCommonTranslation('MAP_CATEGORY_SUCCESS'));

	        					   grid.getStore().load({
	        						   callback: function(){
	        							   searchTab.body.unmask();
	        						   }
	        					   });
	        					   var libraryGrid = $this.getLibrarybranchandcategorygrid();
	        					   var filter= $this.getLibrarybranchandcategoryfilter();
	        					   
	        					   academyLocationFilter=filter.down('#academyLocationCombo');
	        					   libraryFilter=filter.down('#library');
	        					   categoryFilter=filter.down('#category');
	        					   
	        					   store=libraryGrid.getStore();
	        					   store.getProxy().extraParams={
	        						   academyLocationId:academyLocationFilter.value,
	        						   categoryId:categoryFilter.value,
	        						   branchId:libraryFilter.value,
	        						   id:$this.getCurrentlyLoggedInUser().id
	        					   },
	        					   store.load();
	        					   var categoryGrid=$this.getKohamapacademylocationwithcategorygrid();
  									categoryStore=categoryGrid.getStore();
	        					   	categoryStore.getProxy.extraParams={
   											academyLocationId:academyLocationFilter.value
   									}
      								categoryStore.load();
	        				   },
	        			   });
	        		   }
	        	   }
	           },
});