/**
 * This controller is used for faculty dashboard controller
 * @author Bhanu PS
 */
Ext.define('Academia.controller.leavemanagement.LeaveTypeController', {
	extend: 'Academia.controller.base.BaseController',

    stores: ['leavemanagement.LeaveTypeStore','common.StatusComboStore',
             'examinationcenters.manageEvaluation.ManageResultMasterStore','leavemanagement.LeaveTypeGridStore','leavemanagement.EligibilityEnumStore','leavemanagement.DocsRequiredStore'],
             
    views: ['leavemanagement.LeaveTypeStructure','leavemanagement.LeaveTypeFilter','leavemanagement.LeaveTypeForm', 'leavemanagement.LeaveTypesGrid',
            'leavemanagement.AddLeaveTypeForm'],
            
    
    refs: [{
    	ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref: 'leavetypeform',
        selector: 'leavetypeform'
    },{
    	ref: 'leavetypesgrid',
        selector: 'leavetypesgrid'
    },{
    	ref: 'addleavetypeform',
        selector: 'addleavetypeform'
    }],
    config: {
    	FACULTY_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNASSIGNEDREQUEST_PRIVILEGES'),
    	FACULTY_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	FACULTYDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTYDASHBOARD_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	 'leavetypesgrid button#btnAdd':{
  			   click: function(obj, record) {
  				   this.openAddLeaveTypeTab();
  			   }
  		   },
  		   
  		 'leavetypesgrid button#btnEdit':{
			   click: function(obj, record) {
				   this.openAndLoadLeaveTypeTab(record);
			   }
		   },
		   
  		   'addleavetypeform':{
  			   render: function(obj) {
  				  var $this=this;
  				   var form = $this.getAddleavetypeform().getForm();
  				   var status = form.findField('status');
  				   var documentId = form.findField('documentId');
  				   documentId.allowBlank=true;
//  				 status.setValue('Active');
  				   status.getStore().load({
  					   callback:function(record){
  						   status.setValue(record[0].data.id);
  					   }
  				   });
  			   }
  		   },

  		   'leavetypeform button[itemId=quickSearchId]':{
  			   click : function(obj){
  				   this.searchResult();
  			   }
  		   },
  		   'leavetypeform button[itemId=resetBtn]':{
  			   click : function(obj){
  				   this.getLeavetypeform().getForm().reset();
  			   }
  		   },

  		   'addleavetypeform radiogroup[itemId=allowInNoticeGrpId]':{
  			   change : function(value,newValue,oldValue){
  				   this.showHideExtendNotice(value,newValue,oldValue);
  			   }
  		   },

  		   'addleavetypeform radiogroup[itemId=deductionGrpId]':{
  			   change : function(value,newValue,oldValue){
  				   this.showHidePayratePercent(value,newValue,oldValue);
  			   }
  		   },
  		   
  		 'addleavetypeform radiogroup[itemId=reqDocsGrpId]':{
			   change : function(value,newValue,oldValue){
				   this.showHideDocumentRequired(value,newValue,oldValue);
			   }
		   },
		   
		   'addleavetypeform customcombobox[itemId=EligibilityEnumItemId]':{
			   select : function(obj, rec){
				   var $this = this;
				   var addLeaveTypeForm = $this.getAddleavetypeform();
				   var form = addLeaveTypeForm.getForm();
				   var data = rec[0].data.id;
				   var deductionGrpId = form.findField('deductionGrp');
				   deductionGrpId.reset()
				   var deductionPercent = form.findField('deductionPercent');
				   if(data=="LOP"){
					   deductionGrpId.setDisabled(false);
					   addLeaveTypeForm.down('#validWithinDaysItemId').reset();
					   addLeaveTypeForm.down('#validWithinDaysItemId').allowBlank = true;
					   addLeaveTypeForm.down('#validWithinDaysItemId').setVisible(false);
				   } else {
					   if(data == 'COMPENSATORY') {
						   addLeaveTypeForm.down('#validWithinDaysItemId').setValue(1);
						   addLeaveTypeForm.down('#validWithinDaysItemId').allowBlank = false;
						   addLeaveTypeForm.down('#validWithinDaysItemId').setVisible(true);
					   } else {
						   addLeaveTypeForm.down('#validWithinDaysItemId').reset();
						   addLeaveTypeForm.down('#validWithinDaysItemId').allowBlank = true;
						   addLeaveTypeForm.down('#validWithinDaysItemId').setVisible(false);
					   }
					   deductionGrpId.setDisabled(true);
					   deductionPercent.setDisabled(true);
					   deductionPercent.reset();
				   }
			   }
		   },
		   
		   'addleavetypeform button[itemId=submitBtn]':{
			   click : function(obj){
				   this.saveLevaTypeDetails();
			   }
		   },
		   
		   'addleavetypeform button[itemId=resetBtn]':{
			   click : function(obj){
				   var $this=this;
				   var addleavetypeform = $this.getAddleavetypeform();
				   var form = addleavetypeform.getForm();
				   form.reset();
				   addleavetypeform.down('#validWithinDaysItemId').allowBlank = true;
				   addleavetypeform.down('#validWithinDaysItemId').setVisible(false);
			   }
		   },
		   

  			/*'addleavetypeform customcombobox[itemId=programItemId]':{
			   select: function(obj) {
				   var $this=this;
				   var form = $this.getAddleavetypeform().getForm();
				   var status = form.findField('status');
				   status.getStore().load({
					   callback:function(record){
						   status.setValue(record[0].data.id);
					   }
				   });
			   }
		   },*/
  		   
        });
    },
    openAddLeaveTypeTab:function(){
           var grid = this.getLeavetypesgrid();
           grid.getSelectionModel().deselectAll();
    	   var contentpanel = this.getContentPanel();
		   var studentRoomStructure = Ext.widget('addleavetypeform');
		   var tabName = getCommonTranslation('CREATE_LEAVEL_TYPE');
		   /**
		    * This is to remove tab from content panel and open same tab again 
		    */
		   var getcontroller=this.getController('menu.CoreERPNavigationController');
		   var getTab=getcontroller.getTab(tabName);
		   if(getTab!=null){
			   contentpanel.remove(getTab, true);
		   }
		   openTab(contentpanel, tabName, studentRoomStructure,CONSTANTS.MENU_COLOR_EIGHT);
    },
    
    showHideExtendNotice: function(value,newValue,oldValue){
    	var $this = this;
    	var form = $this.getAddleavetypeform().getForm();
    	if(newValue.whetherAllowInNotice==true){
    		form.findField('extendsNoticeGrp').setDisabled(false);
    	} else {
    		form.findField('extendsNoticeGrp').setDisabled(true);
    		form.findField('extendsNoticeGrp').reset();
    	}
    },
    
    showHidePayratePercent: function(value,newValue,oldValue){
    	var $this = this;
    	var form = $this.getAddleavetypeform().getForm();
    	if(newValue.whetherDeductionGrp==true){
    		form.findField('deductionPercent').setDisabled(false);
    	} else {
    		form.findField('deductionPercent').setDisabled(true);
    		form.findField('deductionPercent').reset();
    	}
    },
    
    showHideDocumentRequired: function(value,newValue,oldValue){
    	var $this = this;
    	var form = $this.getAddleavetypeform().getForm();
    	var documentId = form.findField('documentId');
    	if(newValue.whetherReqDocsGrp==true){
    		documentId.setDisabled(false);
    		documentId.allowBlank=false;
    		documentId.reset();
    	} else {
    		documentId.setDisabled(true);
    		documentId.reset();
    		documentId.allowBlank=true;
    	}
    	//form.isValid();
    	form.checkValidity();
    },
    
    saveLevaTypeDetails: function(){
    	var $this = this;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var form = $this.getAddleavetypeform().getForm();
    	var values = form.getValues();
    	var grid = $this.getLeavetypesgrid();
    	var contentpanel = $this.getContentPanel();
    	var active;
    	var formLeaveTypeFilter = $this.getLeavetypeform();
    	var isView = '';
    	if(form.findField('status').getRawValue()=='Active'){
    		active='ACTIVE';
    	} else {
    		active='INACTIVE'
    	}

    	var submitUrl, document=[];
    	/*if($this.getAddleavetypeform().down("#submitBtn").getText()=="Save"){
    		if(!isNullOrEmpty(grid.getSelectionModel().getSelection()[0])){
    			id=grid.getSelectionModel().getSelection()[0].data.id;
    		}

    	}*/
    	var id=values.id;
    	if(!isNullOrEmpty(id)){
    		submitUrl=SERVERURL.PATH_SAVE_LEAVE_TYPE_UPDATE;
    		isView = 'EDIT';
    	}
    	else {
    		submitUrl=SERVERURL.PATH_SAVE_LEAVE_TYPE_CREATE;
    		isView = 'ADD';
    	}
    	var docs = $this.getAddleavetypeform().down("#documentItemId");
    	if(!isNullOrEmpty(docs.valueModels)){
    		for (var i in docs.valueModels){
    			document.push(docs.valueModels[i].data.id);
    		}
    	}
    	var submitValue={
    			"id":id,
    			"leaveCode":values.levelCodeName,
    			"leaveType":values.levelTypeName,
    			"description":values.description,
    			"eligibilityCriteria":values.EligibilityEnum,
    			"isAllowedInNoticePeriod": values.whetherAllowInNotice,
    			"isExtendsNoticePeriod": values.whetherExtendsNotice,
    			"isPayrateDeduction":values.whetherDeductionGrp,
    			"percentOfPayDeduction":values.deductionPercent,
    			"leaveStatus":active,
    			"isDocumentRequired":values.whetherReqDocsGrp,
    			"validFrom":values.validFrom,
    			"vaildTill":values.validTill,
    			"validWithinDays":values.validWithinDays,
    			"hrDcoumentMasterId":document
    	};
    	
    	Ext.Ajax.request({
    		method : "GET",
    		type : 'rest',
    		url : SERVERURL.PATH_LEAVE_CODE_EXISTS,
    		params:{
    			id:id,
    			leaveCode:values.levelCodeName
    		},
    		success : function(response, action) {
    			var resp = Ext.decode(response.responseText);
    			if(resp){
    				Ext.getBody().unmask();
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LEAVE_CODE_EXISTS_MSG'));
    			}
    			else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : submitValue,
    					method : 'POST',
    					success : function(form, action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('LEAVE_TYPE'),getCommonTranslation('SUCCESS'));
    						
    						if(!isNullOrEmpty(grid)){
    							grid.getStore().reload();
        						grid.getSelectionModel().deselectAll();
        						formLeaveTypeFilter.down('#HRLeaveTypeItemId').getStore().reload();
    						}
    						
    						var tabName = '';
    						if (isView == 'ADD') {
    							tabName = getCommonTranslation('CREATE_LEAVEL_TYPE');
    						}
    						else if (isView== 'EDIT') {
    							tabName = getCommonTranslation('EDIT_LEAVEL_TYPE');
    						}
    						var getcontroller=$this.getController('menu.CoreERPNavigationController');
    						var getTab=getcontroller.getTab(tabName);
    						if(getTab!=null){
    							contentpanel.remove(getTab, true);
    						}
    					}
    				});
    			}
    		}
    	});
    },
    searchResult: function(){
    	var $this = this;
    	var form = $this.getLeavetypeform().getForm();
    	var values = form.getValues();
    	var grid = $this.getLeavetypesgrid();
    	var active;
    	if(!isNullOrEmpty(form.findField('status').valueModels[0])){
    		if(form.findField('status').valueModels[0].data.value){
        		active='ACTIVE';
        	} else {
        		active='INACTIVE'
        	}
    	}
    	
    	grid.getStore().getProxy().extraParams={
    		leaveTypeId:values.HRLeaveType,
    		eligibilityCriteria:values.HREligibility,
    		status:active
    	};
    	grid.getStore().load();
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = $this.getLeavetypeform();
    },
    openAndLoadLeaveTypeTab: function(record){
    	var $this = this;
    	var grid = $this.getLeavetypesgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var contentpanel = this.getContentPanel();
    		var addLeaveTye = Ext.widget('addleavetypeform');
    		var tabName = getCommonTranslation('EDIT_LEAVEL_TYPE');
    		/**
    		 * This is to remove tab from content panel and open same tab again 
    		 */
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentpanel.remove(getTab, true);
    		}
    		
    		addLeaveTye.setTitle(getCommonTranslation('EDIT_LEAVEL_TYPE'))
    		
    		openTab(contentpanel, tabName, addLeaveTye,CONSTANTS.MENU_COLOR_EIGHT);

    		var record = grid.getSelectionModel().getSelection()[0];
    		var form=addLeaveTye.getForm();
    		if(record.data.leaveStatus=="INACTIVE"){
    			form.findField("status").setValue(false); 
    		} else {
    			form.findField("status").setValue(true); 
    		}
    		
    		form.findField("levelTypeName").setValue(record.data.leaveType); 
    		form.findField("levelCodeName").setValue(record.data.leaveCode);
    		form.findField("id").setValue(record.data.id);
    		
    		var deductionGrpId = addLeaveTye.down("#deductionGrpId");
    		if(record.data.eligibilityCriteria=="LOP"){
    			form.findField("validWithinDays").allowBlank = true;
    			deductionGrpId.setDisabled(false);
    			deductionGrpId.items.items[0].setValue(true);
    			deductionGrpId.items.items[1].setValue(false);
    		} else if(record.data.eligibilityCriteria=="COMPENSATORY"){
    			form.findField("validWithinDays").setVisible(true);
    			form.findField("validWithinDays").setValue(record.raw.validWithinDays);
    		} else {
    			form.findField("validWithinDays").allowBlank = true;
    			deductionGrpId.setDisabled(true);
    			deductionGrpId.items.items[0].setValue(false);
    			deductionGrpId.items.items[1].setValue(true);
    		}
    		var EligibilityEnum=form.findField("EligibilityEnum");
    		EligibilityEnum.getStore().load({
    			callback:function(records){
    				for(var i in records){
    					if(records[i].data.id==record.data.eligibilityCriteria){
    						EligibilityEnum.setValue(records[i].data.id); 
    					}
    				}
    			}
    		});
    		form.findField("description").setValue(record.data.description); 
    		if(record.data.isAllowedInNoticePeriod){
    			form.findField("extendsNoticeGrp").setDisabled(false); 
    			var whetherAllowInNotice = addLeaveTye.down("#allowInNoticeGrpId");
    			whetherAllowInNotice.items.items[0].setValue(true);
    			whetherAllowInNotice.items.items[1].setValue(false);
    		}
    		if(record.data.isPayrateDeduction){
    			form.findField("deductionPercent").setDisabled(false); 
    			form.findField("deductionPercent").setValue(record.data.percentOfPayDeduction);
    			var deductionGrpId = addLeaveTye.down("#deductionGrpId");
    			deductionGrpId.items.items[0].setValue(true);
    			deductionGrpId.items.items[1].setValue(false);
    		}

    		form.findField("validFrom").setValue(dateRender(record.data.validFrom)); 
    		form.findField("validTill").setValue(dateRender(record.data.vaildTill));
    		
    		if(record.data.isDocumentRequired){
    			form.findField("documentId").setDisabled(false); 
    			form.findField("documentId").setDisabled(false); 
    			var docs = addLeaveTye.down("#documentItemId");
    			docs.getStore().load({
    				callback:function(records){
    					var arr=[];
    					for(var j in records){
    						for(var i in record.data.hrDcoumentMasterId){
    							if(records[j].data.id==record.data.hrDcoumentMasterId[i]){
    								arr.push(records[j].data.id);
    							}
    						}
    					}
    					docs.setValue(arr);
    				}
    			});
    			var reqDocsGrpId = addLeaveTye.down("#reqDocsGrpId");
    			reqDocsGrpId.items.items[0].setValue(true);
    			reqDocsGrpId.items.items[1].setValue(false);
    		}
    		if(record.data.isExtendsNoticePeriod){
    			var extendsNoticeGrpId = addLeaveTye.down("#extendsNoticeGrpId");
    			extendsNoticeGrpId.items.items[0].setValue(true);
    			extendsNoticeGrpId.items.items[1].setValue(false);
    		}
    		var submitBtn = addLeaveTye.down("#submitBtn");
    		submitBtn.setText(getExaminationTranslation('Save'));
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    }
    	
});
