/**
 * @author Deepak Mathur
 */
Ext.define('Academia.controller.leavemanagement.approvalsetup.LMApprovalSetupController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
		'userGroup.UserGroupStore',
		'department.ParentDepartmentByAccesibleStore',
		'common.DesignationTypeStore',
		'enquiry.studentDetail.GenderStore',
		'user.UserAcademyLocationStore',
		'leavemanagement.leaveapprovalsetup.LMConfigurationStatusStore',
		'leavemanagement.leaveapprovalsetup.LMConfigurationGridStore',   
		'leavemanagement.leaveapprovalsetup.LMConfigurationSetupGridStore',
		'leavemanagement.LeaveTypeStore',
		'leavemanagement.leaveapprovalsetup.LMPastLeaveRequestStore',
		'leavemanagement.leaveapprovalsetup.LMLeaveRequestDetailStore',
		'leavemanagement.leaveapprovalsetup.LMPendingLeaveRequestStore',
		'leavemanagement.leaveapprovalsetup.LMLeaveRequestStatusStore',
		'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
		'leavemanagement.leaveapprovalsetup.LMLeaveBalanceAndApprovalGridStore', 
		'leavemanagement.leaveapprovalsetup.LMLeaveTypeStore',
		'leavemanagement.leaveapprovalsetup.LMApprovalTypeFlowStore',
		'importutility.ModuleName','leavemanagement.leaveapprovalsetup.LMEmployeeSmartSearchExceptRequesterUserStore',
		'importutility.ImportApprovalFlowUpdateStore', 'importutility.ImportEmployeeLeaveBalanceUpdateStore',
		'criteriabuilder.userquicksearch.QuickSearchName',
		'department.DepartmentAcademyLocationWiseStore',
		'common.GenderTypeStore','leavemanagement.leaveapprovalsetup.LMPendingLeaveActionHistoryStore'
		],
		views: ['leavemanagement.approvalsetup.LMApprovalSetupStructure',
			'leavemanagement.approvalsetup.LMApprovalSetupTabStructure',
			'leavemanagement.approvalsetup.LMApprovalSetupFilter',
			'leavemanagement.approvalsetup.LMApprovalSetupGrid',
			'leavemanagement.approvalsetup.LMApprovalConfigreSetupGrid',
			'leavemanagement.approvalsetup.LMApprovalConfigreSetupForm',
			'leavemanagement.approvalsetup.LMApprovalSetupConfigureTabStructure',
			'leavemanagement.approvalsetup.LMLeaveBalanceAndApprovalFlowStructure',
			'leavemanagement.approvalsetup.LMLeaveRequestStructure',
			'leavemanagement.approvalsetup.LMLeaveRequestTabStructure',
			'leavemanagement.approvalsetup.LMLeaveBalanceAndApprovalFlowGrid',
			'leavemanagement.approvalsetup.LMPastLeaveRequestStructure',
			'leavemanagement.approvalsetup.LMPastLeaveRequestForm',
			'leavemanagement.approvalsetup.LMPastLeaveRequestGrid',
			'leavemanagement.approvalsetup.LMApplyForLeaveStructure',
			'leavemanagement.approvalsetup.LMApplyForLeaveForm',
			'leavemanagement.approvalsetup.LMEmployeeLeaveRequestStructure',
			'leavemanagement.approvalsetup.LMRequestsPendingActionTabStructure',
			'leavemanagement.approvalsetup.LMRequestsPendingActionFilter',
			'leavemanagement.approvalsetup.LMRequestsPendingActionGrid',
			'leavemanagement.approvalsetup.LMMyApprovalFlowPanel',
			'leavemanagement.approvalsetup.LMEmployeeLeaveRequestDetailWin',
			'leavemanagement.approvalsetup.LMLeaveRequestWithdrawConfirmationWin',
			'leavemanagement.approvalsetup.LMLeaveRequestPendingActionDetailWin',
			'leavemanagement.approvalsetup.downloadupload.ApprovalSetupBulkImportStructure',
			'leavemanagement.approvalsetup.downloadupload.ApprovalSetupDownloadForm',
			'leavemanagement.approvalsetup.downloadupload.ApprovalSetupUploadForm',
			'importutility.ImportByModule.ImportListApprovalFlowUpdateGrid',
			'leavemanagement.approvalsetup.downloadupload.EmployeeLeaveBalanceUpdateBulkImportStructure',
			'leavemanagement.approvalsetup.downloadupload.EmployeeLeaveBalanceUpdateDownloadForm',
			'leavemanagement.approvalsetup.downloadupload.EmployeeLeaveBalanceUpdateUploadForm',
			'importutility.ImportByModule.ImportListEmployeeLeaveBalanceUpdateGrid',
			'UploadOptionRadioGroup', 'leavemanagement.approvalsetup.LMEmployeePastLeaveRequestDetailWin',
			'leavemanagement.approvalsetup.LMEmployeePastLeaveRequestDetailForm',
			'leavemanagement.approvalsetup.LMEmployeeLeaveCancellationRequestDetailWin',
			'leavemanagement.approvalsetup.LMEmployeeLeaveCancellationRequestDetailForm','leavemanagement.approvalsetup.LMLeaveRequestActionHistoryTabStructure',
			'leavemanagement.approvalsetup.LMRequestActionHistoryFilter','leavemanagement.approvalsetup.LMRequestActionHistoryGrid'
			],
			models :['leavemanagement.leaveapprovalsetup.LMApprovalConfigurationSetupModel'],
			refs: [{
				ref: 'contentpanel',
				selector: 'contentpanel'
			}, {
				ref: 'lmapprovalsetupfilter',
				selector: 'lmapprovalsetupfilter'
			}, {
				ref: 'lmapprovalsetupgrid',
				selector: 'lmapprovalsetupgrid'
			}, {
				ref: 'lmapprovalconfigresetupgrid',
				selector: 'lmapprovalconfigresetupgrid'
			}, {
				ref: 'lmapprovalconfigresetupform',
				selector: 'lmapprovalconfigresetupform'
			},{
				ref: 'lmrequestspendingactiongrid',
				selector: 'lmrequestspendingactiongrid'
			},{
				ref: 'lmrequestspendingactionfilter',
				selector: 'lmrequestspendingactionfilter'
			},{
				ref: 'lmleaverequesttabstructure',
				selector: 'lmleaverequesttabstructure'
			},{
				ref: 'lmmyapprovalflowpanel',
				selector: 'lmmyapprovalflowpanel'
			},{
				ref: 'lmapplyforleaveform',
				selector: 'lmapplyforleaveform'
			},{
				ref: 'lmpastleaverequeststructure',
				selector: 'lmpastleaverequeststructure'
			},{
				ref: 'lmpastleaverequestgrid',
				selector: 'lmpastleaverequestgrid'
			},{
				ref: 'lmemployeeleaverequestdetailwin',
				selector: 'lmemployeeleaverequestdetailwin'
			},{
				ref: 'lmpastleaverequestform',
				selector: 'lmpastleaverequestform'
			},{
				ref: 'lmleaverequestwithdrawconfirmationwin',
				selector: 'lmleaverequestwithdrawconfirmationwin'
			},{
				ref: 'lmleaverequestpendingactiondetailwin',
				selector: 'lmleaverequestpendingactiondetailwin'
			},{
				ref: 'lmleavebalanceandapprovalflowgrid',
				selector: 'lmleavebalanceandapprovalflowgrid'
			},{
				ref: 'approvalsetupdownloadform',
				selector: 'approvalsetupdownloadform'
			},{
				ref: 'approvalsetupbulkimportstructure',
				selector: 'approvalsetupbulkimportstructure'
			},{
				ref: 'approvalsetupuploadform',
				selector: 'approvalsetupuploadform'
			},{
				ref: 'importlistapprovalflowupdategrid',
				selector: 'importlistapprovalflowupdategrid'
			},{
				ref: 'uploadoptionradiogroup',
				selector: 'uploadoptionradiogroup[itemId=approvalSetupUploadOptionRadioGroupItemId]'
			},{
				ref: 'employeeleavebalanceupdatedownloadform',
				selector: 'employeeleavebalanceupdatedownloadform'
			},{
				ref: 'employeeleavebalanceupdatebulkimportstructure',
				selector: 'employeeleavebalanceupdatebulkimportstructure'
			},{
				ref: 'employeeleavebalanceupdateuploadform',
				selector: 'employeeleavebalanceupdateuploadform'
			},{
				ref: 'importlistemployeeleavebalanceupdategrid',
				selector: 'importlistemployeeleavebalanceupdategrid'
			},{
				ref: 'employeeleaveuploadoptionradiogroup',
				selector: 'uploadoptionradiogroup[itemId=employeeLeaveBalanceUpdateUploadOptionRadioGroupItemId]'
			},{
				ref: 'lmemployeepastleaverequestdetailwin',
				selector: 'lmemployeepastleaverequestdetailwin'
			},{
				ref: 'lmemployeepastleaverequestdetailform',
				selector: 'lmemployeepastleaverequestdetailform'
			},{
				ref: 'lmemployeeleavecancellationrequestdetailwin',
				selector: 'lmemployeeleavecancellationrequestdetailwin'
			},{
				ref: 'lmemployeeleavecancellationrequestdetailform',
				selector: 'lmemployeeleavecancellationrequestdetailform'
			},{
				ref: 'lmleaverequestactionhistorytabstructure',
				selector: 'lmleaverequestactionhistorytabstructure'
			},{
				ref: 'lmrequestactionhistoryfilter',
				selector: 'lmrequestactionhistoryfilter'
			},{
				ref: 'lmrequestactionhistorygrid',
				selector: 'lmrequestactionhistorygrid'
			},],
			config: {
				LEAVE_APPROVAL_SETUP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEAVE_APPROVAL_SETUP_PRIVILEGES'),
				LM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES'),
				LM_EMPLOYEE_LEAVE_REQUEST_TAB_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LM_EMPLOYEE_LEAVE_REQUEST_TAB_PRIVILEGES'),
				LM_FP_REQUEST_PENDING_ACTION_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LM_FP_REQUEST_PENDING_ACTION_PRIVILEGES'),
				LM_FP_LEAVE_REQUEST_TAB_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LM_FP_LEAVE_REQUEST_TAB_PRIVILEGES'),
				CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
				FP_REQUEST_ACTION_HISTORY_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_LEAVE_REQUEST_PRIVILEGES'),
			},
			init: function(application) {
				this.control({
					'lmapprovalsetupfilter customcombobox[itemId=lmAcademyLocationCombo]': {
						render: function(combo) {
							var me = this;
							this.loadAcadLocCombo(combo);
						},
						select: function(combo, record) {
							var appForm = combo.up('form');
							var lmasFilter = appForm.down('#lmAcademyLocationCombo');
							var acadLocId = record[0].get('id');
							var store = combo.getStore();
							store.getProxy().extraParams = {
								academyLocationId: acadLocId
							};
						}
					},
					'approvalsetupdownloadform': {
						render:function(form) {
							var combo = form.down('#lmAcademyLocationComboAS');
							this.loadAcadLocCombo(combo);
						}
					},
					'approvalsetupdownloadform': {
						render:function(form) {
							var combo = form.down('#lmAcademyLocationComboAS');
							this.loadAcadLocCombo(combo);
						}
					},
					'lmapprovalsetupgrid': {
						beforerender: function() {
							this.getStore('leavemanagement.leaveapprovalsetup.LMConfigurationGridStore').removeAll();
						},
						render: function(grid) {
							this.doAccessControlValidation(grid, this.getLEAVE_APPROVAL_SETUP_PERMISSIONS());
							this.disableMoreActionPivileges(grid, this.getLEAVE_APPROVAL_SETUP_PERMISSIONS());
							var buttonsToolBar = grid.query('toolbar')[0];
							var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
							var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
							pdftoolbar.setDisabled(true);
							exceltoolbar.setDisabled(true);
						},
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var lmApprovalSetupGrid = $this.getLmapprovalsetupgrid();
							var columnName = lmApprovalSetupGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == 'employeeCode') {
								if (e.target.tagName == 'A') {
									$this.openConfiguretabstructure(null,lmApprovalSetupGrid,record);
								}
							}
						}
					},
					'lmapprovalsetupfilter button[itemId=searchBtnApprovalSetupfilterItemId]': {
						click: function() {
							var form = this.getLmapprovalsetupfilter();
							var facultyCode = form.down("#lmFacultyCodeItemId").getValue();
							if(!isNullOrEmpty(facultyCode)) {
								this.checkWhetherLeaveApplicableOrNot();
							} else {
								this.loadApprovalSetupGrid();
							}
						}
					},
					'lmapprovalsetupfilter button[itemId=resetBtnApprovalSetupfilterItemId]': {
						click: function() {
							this.resetApprovalSetupfilter();
						}
					},
					'lmapprovalsetupgrid button[itemId=viewConfigureBtnId]': {
						click: function(button){
							var me = this;
							var configurationDetailgrid = me.getLmapprovalsetupgrid();
							var selectedRecord = configurationDetailgrid.getSelectionModel().getSelection();
							me.openConfiguretabstructure(button,null,selectedRecord);
						}
					},
					'lmapprovalsetupgrid button[itemId=btnDelete]': {
						click: function(button){
							var this$ = this;
							var configurationDetailgrid = this$.getLmapprovalsetupgrid();
							var selectedRecord = configurationDetailgrid.getSelectionModel().getSelection();
							this$.deleteLeaveApprovalSetupConfiguration(selectedRecord);
						}
					},
					'lmapprovalconfigresetupgrid': {
						/*render: function(grid) {
            		this.loadDataInGrid(grid);
            	},*/
						deselect : function( grid, record, index, eOpts ) {
							var $this = this;
							var selRecords = grid.getSelection();
							if(selRecords.length == 1) {
								$this.setValueOnApprovalConfigreSetupForm(grid,selRecords[0],selRecords);
							} else {
								$this.resetApprovalConfigreSetupForm();
							}
						},
						select : function(grid, record, index, eOpts ) {
							var $this = this;
							//var selRecords = grid.getSelectionModel().getSelection();
							var selRecords = grid.getSelection();
							if(selRecords.length == 1) {
								$this.setValueOnApprovalConfigreSetupForm(grid,record,selRecords);
							} else {
								$this.resetApprovalConfigreSetupForm();
							}
						}
					},
					'lmapprovalconfigresetupform button[itemId=submitBtn]': {
						click: function(button){
							this.saveApprovalConfiguration(button);
						}
					},
					'lmapprovalconfigresetupform radiogroup[itemId=approvalType]': {
						change:function(o,r){
							this.approvalTypeChange(o,r);
						}
					},
					'lmapprovalconfigresetupform':{
						render : function(form) {
							form.down('#userApprovalLevel2').setDisabled(true);
							form.down('#userApprovalLevel3').setDisabled(true);
							form.down('#userApprovalLevel4').setDisabled(true);
							form.down('#slaDayId').setValue(1);
						}            	
					},
					'lmapprovalconfigresetupform combo[itemId=userApprovalLevel1]': {
						select:function(obj,record){
							var me = this;
							var form = me.getLmapprovalconfigresetupform();
							form.down('#userApprovalLevel2').setDisabled(false);
						}           	
					},
					'lmapprovalconfigresetupform combo[itemId=userApprovalLevel2]': {
						select:function(obj,record){
							var me = this;
							var form = me.getLmapprovalconfigresetupform();
							form.down('#userApprovalLevel3').setDisabled(false);
						}           	
					},
					'lmapprovalconfigresetupform combo[itemId=userApprovalLevel3]': {
						select:function(obj,record){
							var me = this;
							var form = me.getLmapprovalconfigresetupform();
							form.down('#userApprovalLevel4').setDisabled(false);
						}           	
					},
					'lmapprovalconfigresetupform button[itemId=resetBtn]': {
						click: function(form){
							var resetFrm = this.getLmapprovalconfigresetupform();
							resetFrm.getForm().reset();
						}
					},
					'lmrequestspendingactiongrid ': {
						render: function(grid){
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId == 1) {
								this.doAccessControlValidation(grid, this.getLM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES());
							} else if(portalId == 2) {
								this.doAccessControlValidation(grid, this.getLM_FP_REQUEST_PENDING_ACTION_PRIVILEGES());
							}
						},
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(e.target.tagName == 'A'){
								if(columnName == "document") {
									var documentId = record.raw.document.encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								} else if(columnName == "hrLeaveReqId"){
									var record = grid.getSelectionModel().getSelection()[0];
									var rpaDetailWin = $this.getLmleaverequestpendingactiondetailwin();
									if(isNullOrEmpty(rpaDetailWin)){
										Ext.widget('lmleaverequestpendingactiondetailwin');
										rpaDetailWin = $this.getLmleaverequestpendingactiondetailwin();
									}
									var empReqDetailGrid = rpaDetailWin.down('#lmLeaveRequestPendingActionDetailGrid');
									this.openEmpLeaveReqDetailWin(record,rpaDetailWin,empReqDetailGrid);
								}
							} else{
								var $this = this;
								Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
								var formWindow = $this.getLmemployeepastleaverequestdetailwin();
								if (!formWindow) {
									formWindow = Ext.widget('lmemployeepastleaverequestdetailwin');
								}
								
								var lmLeaveTypeCombo = formWindow.down('#lmLeaveTypeId')
								var eligibilityCriteriaVal = record.raw.eligibilityCriteria;
								Ext.getBody().unmask();
								if(!isNullOrEmpty(eligibilityCriteriaVal) && eligibilityCriteriaVal == 'COMPENSATORY'){
									formWindow.show();
									$this.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
									formWindow.down('#lmFromDateId').setVisible(false);
									formWindow.down('#lmToDateId').setVisible(false);
									//formWindow.down('#isHalfDayStart').setVisible(false);
									//formWindow.down('#isHalfDayEnd').setVisible(false);
									lmLeaveTypeCombo.setValue(record.data.hrLeaveTypeIDCode.value);
									formWindow.down('#lmClaimDateItemId').setVisible(true);
									formWindow.down('#lmClaimDateItemId').setValue(dateRender(record.raw.claimDate));
									formWindow.down('#lmLeaveRequireOnDateItemId').setVisible(true);
									formWindow.down('#lmLeaveRequireOnDateItemId').setValue(dateRender(record.raw.leaveRequireOnDate));

								} else {
									formWindow.show();
									$this.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
									lmLeaveTypeCombo.setValue(record.data.hrLeaveTypeIDCode.value);
									formWindow.down('#lmFromDateId').setVisible(true);
									formWindow.down('#lmToDateId').setVisible(true);
									//formWindow.down('#isHalfDayStart').setVisible(true);
								//	formWindow.down('#isHalfDayEnd').setVisible(true);
									formWindow.down('#lmFromDateId').setValue(dateRender(record.raw.fromDate));
									formWindow.down('#lmToDateId').setValue(dateRender(record.raw.toDate));
									//formWindow.down('#isHalfDayStart').setValue(record.raw.isHalfDayStart);
									formWindow.down('#isHalfDayEnd').setValue(record.raw.isHalfDayEnd);
									formWindow.down('#lmClaimDateItemId').setVisible(false);
									formWindow.down('#lmLeaveRequireOnDateItemId').setVisible(false);
								}
								if(! isNullOrEmpty(record.raw.document) && ! isNullOrEmpty(record.raw.document)) {
									formWindow.down('#lmDocumentNameItemId').setValue(record.raw.document.name);
								}
								formWindow.down('#leaveReasonId').setValue(record.raw.reason);
								formWindow.down('#employeeNames').getStore().load({
									callback:function(){
										/*if(!isNullOrEmpty(record.raw.alternateEmpNames)) {
        		        				var alternateEmployees = record.raw.alternateEmpNames.split(',');
            		        			formWindow.down('#employeeNames').setValue(alternateEmployees);
            		        			formWindow.down('#employeeNames').inputEl.dom.style.height="110px";
        		        			}*/
										if(!isNullOrEmpty(record.raw.alternateEmployeeIds)) {
											formWindow.down('#employeeNames').setValue(record.raw.alternateEmployeeIds);
											formWindow.down('#employeeNames').inputEl.dom.style.height="110px";
										}
										if (formWindow.down('#employeeNames') != null) {
											formWindow.down('#employeeNames').setHeight('auto');
										}
										formWindow.down('#employeeNames').el.dom.style.height = 'auto';
										$this.hideWindowMask();
									}
								});
								toggleReadOnlyFormItems(formWindow.down('#lmemployeepastleaverequestdetailformItemId').getForm(), true);

							}
						}
					},
					'lmrequestspendingactionfilter ': {
						render: function(filter){
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
							var portalId = this.getCurrentLoggedPortalId();
							var permissionList;
							if(portalId == 1) {
								permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES());
							} else if(portalId == 2) {
								permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLM_FP_REQUEST_PENDING_ACTION_PRIVILEGES());
							}
							//filter.down('#requestPendingForItemId').setVisible(false)
							filter.down('#selfOrOtherItemId').setVisible(false);
							filter.down('#employeeNameOrIdItemId').setVisible(false);
							if(!isNullOrEmpty(permissionList)) {
								Ext.each(permissionList, function(privilege) {
									if (privilege === 'FOR_OTHER_EMPLOYEE') {
										//filter.down('#requestPendingForItemId').setVisible(true)
										filter.down('#selfOrOtherItemId').setVisible(true); 
										filter.down('#employeeNameOrIdItemId').setVisible(true);
										filter.down('#employeeNameOrIdItemId').setDisabled(true);
									}
								});
							}
						}
					},
					'lmleaverequesttabstructure': {
						activate: function(structure) {
							structure.down('#selfOrOtherItemId').reset();
							structure.down('#empNameTxtId').reset();
							structure.down('#empDesignationId').reset();
							structure.down('#empDepartmentId').reset();
							structure.down('#empSubDepartmentId').reset();
							structure.down('#empEmailId').reset();
							structure.down('#empMobileId').reset();
							this.loadDataForRequester(true);
						},
						render: function(structure) {
							var portalId = this.getCurrentLoggedPortalId();
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
							var permissionList;
							if(portalId==1) {
								permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLM_EMPLOYEE_LEAVE_REQUEST_TAB_PRIVILEGES());
							} else if(portalId == 2) {
								permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLM_FP_LEAVE_REQUEST_TAB_PRIVILEGES());
							}
							//structure.down('#requestForItemId').setVisible(false)
							structure.down('#selfOrOtherItemId').setVisible(false);
							structure.down('#employeeNameOrIdItemId').setVisible(false);
							if(!isNullOrEmpty(permissionList)) {
								Ext.each(permissionList, function(privilege) {
									if (privilege === 'FOR_OTHER_EMPLOYEE') {
										//structure.down('#requestForItemId').setVisible(true);
										structure.down('#selfOrOtherItemId').setVisible(true);
										structure.down('#employeeNameOrIdItemId').setVisible(true);
										structure.down('#employeeNameOrIdItemId').setDisabled(true);
									}
								});
							}
							this.loadDataForRequester(true);
						}
					},
					'lmapplyforleaveform':{
						render: function(form) {
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId==2) {
								form.down('#lmRequestDateId').setReadOnly(true);
							}
							this.loadLeaveTypeCombo();
						}
					},
					'lmapplyforleaveform customcombobox[itemId=lmLeaveTypeId]':{
						change: function(obj, newValue, oldValue, eOpts ) {
							var $this = this;
							if(!isNullOrEmpty(obj.lastSelection[0])) {
								var eligibilityCriteria = obj.lastSelection[0].raw.eligibilityCriteria;
							}
							var leaveForm = $this.getLmapplyforleaveform();
							leaveForm.down('#lmFromDateId').setMaxValue();
							leaveForm.down('#lmToDateId').setMinValue();
							if(!isNullOrEmpty(obj.lastSelection[0]) && eligibilityCriteria == 'COMPENSATORY') {
								leaveForm.down('#lmFromDateId').allowBlank = true;
								leaveForm.down('#lmToDateId').allowBlank = true;
								leaveForm.down('#lmClaimDateItemId').allowBlank = false;
								leaveForm.down('#lmLeaveRequireOnDateItemId').allowBlank = false;
								leaveForm.down('#lmLeaveRequireOnDateItemId').setDisabled(true);
								leaveForm.down('#lmFromDateId').reset();
								leaveForm.down('#lmToDateId').reset();
								leaveForm.down('#leaveCategory').setVisible(false);
								leaveForm.down('#leaveCategory2').setVisible(false);
								leaveForm.down('#leaveCategory3').setVisible(false);
								leaveForm.down('#leaveCounterFieldContainerItemId').setVisible(false);
								
								leaveForm.down('#lmFromDateId').allowBlank = true;
								leaveForm.down('#lmToDateId').allowBlank = true;
								leaveForm.down('#leaveCounter2').allowBlank = true;
								leaveForm.down('#leaveCounter').allowBlank = true;
								leaveForm.down('#leaveCounter5').allowBlank = true;
								
								leaveForm.down('#leaveCounter').reset();
								leaveForm.down('#leaveCounter').setVisible(false);
								leaveForm.down('#leaveCounter1').reset();
								leaveForm.down('#leaveCounter2').reset();
								leaveForm.down('#lmClaimDateItemId').reset();
								leaveForm.down('#lmLeaveRequireOnDateItemId').reset();
							//	leaveForm.down('#isHalfDayStart').reset();
							//	leaveForm.down('#isHalfDayEnd').reset();
								leaveForm.down('#lmFromDateId').setVisible(false);
								leaveForm.down('#lmToDateId').setVisible(false);
							//	leaveForm.down('#isHalfDayStart').setVisible(false);
							//	leaveForm.down('#isHalfDayEnd').setVisible(false);
								leaveForm.down('#lmClaimDateItemId').setVisible(true);
								leaveForm.down('#lmLeaveRequireOnDateItemId').setVisible(true);
							} else {
								leaveForm.down('#lmFromDateId').allowBlank = false;
								leaveForm.down('#lmToDateId').allowBlank = false;
								leaveForm.down('#lmClaimDateItemId').allowBlank = true;
								leaveForm.down('#lmLeaveRequireOnDateItemId').allowBlank = true;
								leaveForm.down('#lmFromDateId').reset();
								leaveForm.down('#lmToDateId').reset();
								leaveForm.down('#lmClaimDateItemId').reset();
								leaveForm.down('#lmLeaveRequireOnDateItemId').reset();
								leaveForm.down('#lmFromDateId').setVisible(true);
								leaveForm.down('#lmToDateId').setVisible(true);
								leaveForm.down('#leaveCounterFieldContainerItemId').setVisible(true);
								leaveForm.down('#leaveCategory').setVisible(false);
								leaveForm.down('#leaveCategory2').setVisible(false);
								leaveForm.down('#leaveCategory3').setVisible(false);
								leaveForm.down('#leaveCounter').reset();
								leaveForm.down('#leaveCounter').setVisible(true);
								leaveForm.down('#leaveCounter1').reset();
								leaveForm.down('#leaveCounter2').reset();
								//leaveForm.down('#isHalfDayStart').setVisible(true);
							//	leaveForm.down('#isHalfDayEnd').setVisible(true);
								leaveForm.down('#lmClaimDateItemId').setVisible(false);
								leaveForm.down('#lmLeaveRequireOnDateItemId').setVisible(false);
							}
							leaveForm.getForm().checkValidity();
						},
					    select:function(combo,records){
					    	/* if (records && records.length > 0 ) {
					    	var leaveForm = $this.getLmapplyforleaveform();
					    	leavefromDate=leaveForm.down('#lmFromDateId');
					    	leavefromDate.setMinValue(records[0].data.periodStartDate);
					    	 }*/
					    	if (records && records.length > 0) {
					            var leaveForm = this.getLmapplyforleaveform();
					            var leavefromDate = leaveForm.down('#lmFromDateId');

					            // Check the eligibility before setting the minValue
					            if (records[0].data.eligibilityCriteria !== "COMPENSATORY") {
					                leavefromDate.setMinValue(records[0].data.periodStartDate);
					            }
					        }
					    }
					},

					'lmapplyforleaveform datefield[itemId=lmClaimDateItemId]':{
						select : function(field, value, eOpts ){
							var $this = this;
							var leaveForm = $this.getLmapplyforleaveform();
							var lmLeaveType = leaveForm.down('#lmLeaveTypeId');
							//var leaveCounter = form.down('#leaveCounter');
							//form.down('#leaveCounter').reset();
							var validWithinDays = lmLeaveType.lastSelection[0].raw.validWithinDays;
							var lmLeaveRequireOnDate = leaveForm.down('#lmLeaveRequireOnDateItemId');
							lmLeaveRequireOnDate.reset();
							lmLeaveRequireOnDate.setMinValue(value);
							var maxRequireOnDate = new Date(value);
							maxRequireOnDate.setDate(maxRequireOnDate.getDate() + validWithinDays);
							lmLeaveRequireOnDate.setMaxValue(maxRequireOnDate);
							lmLeaveRequireOnDate.setDisabled(false);
							var leaveRequestTab=$this.getLmleaverequesttabstructure();
						var employeeId=	leaveRequestTab.down("#employeeNameOrIdItemId").getValue();
				    	var selfbutton=	leaveRequestTab.down("#selfOrOtherItemId").getValue();
				    	if(selfbutton.isSelf==true){
				    		var logedinUser=$this.getCurrentlyLoggedInUser();
				    		employeeId=logedinUser.id;
				    		
				    		
				    	}
				    	var attendanceDate=value;
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								url: SERVERURL.HRM_FIND_EMPLOYEE_DAILY_ATTENDANCE_PRESENT_OR_NOT,
								params :{
									employeeId : employeeId,
									attendanceDate : attendanceDate
									},
								method: 'GET',
								success: function(frm, action) {
									var data = frm.responseText;
									
									if(data=='ABSENT'){
										showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('EMPLOYEE_WAS_ABSENT_AT_SELECTED_DATE'));
										leaveForm.getForm().findField('lmClaimDateId').reset();
									}else if(data=='ALL_READY_LEAVE_CONSUMED'){
										showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('COMPENSATION_LEAVE_ALREADY_CONSUMED'));
										leaveForm.getForm().findField('lmClaimDateId').reset();
									}else if(data=='INVALID_CLAIM_DATE_IT_IS_NOT_DECLARED_HOLIDAY'){
										showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('INVALID_CLAIM_DATE_IT_IS_NOT_DECLARED_HOLIDAY'));
										leaveForm.getForm().findField('lmClaimDateId').reset();
									}
									
									Ext.getBody().unmask();
								}
							});
							

						}
					},
					'lmapplyforleaveform datefield[itemId=lmLeaveRequireOnDateItemId]':{
						select : function(field, value, eOpts ){
							var $this = this;
							var leaveForm = $this.getLmapplyforleaveform();
							var lmLeaveRequireOnDate = leaveForm.down('#lmLeaveRequireOnDateItemId');
					    	var leaveRequestTab=$this.getLmleaverequesttabstructure();
					    	var employeeId=	leaveRequestTab.down("#employeeNameOrIdItemId").getValue();
				        	var attendanceDate=value;
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								url: SERVERURL.HRM_CHECK_WORKING_DAYS,
								params :{
									employeeId : employeeId,
									attendanceDate : attendanceDate
									},
								method: 'GET',
								success: function(frm, action) {
									var data = frm.responseText;
									if(data=='HOLIDAYS'){
										showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('ONLY_WORKING_DAY_SELECTION_IS_ALLOWED'));
										leaveForm.getForm().findField('lmLeaveRequireOnDateId').reset();
									}
									
									Ext.getBody().unmask();
								}
							});
							

						}
					},
					'lmpastleaverequestform': {
						render:function(form) {
							var status = form.down('#lmConfigStatus');
							var store = status.getStore();
							store.load();
						}
					},
					'lmpastleaverequestform button[itemId=pastLeaveFindBtn]': {
						click:function(){
							var structure = this.getLmleaverequesttabstructure();
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							var empId;
							if(isSelf == true){
								empId = this.getCurrentlyLoggedInUser().id;
							} else {
								empCombo = structure.down('#employeeNameOrIdItemId');
								if(!isNullOrEmpty(empCombo.getValue())) {
									empId = empCombo.valueModels[0].data.id;
								} else {
									showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_SELECT_EMPLOYEE'));
								}
							}
							if(isSelf == true || !isNullOrEmpty(empCombo.getValue())) {
								var form=this.getLmpastleaverequestform();
								var  from = form.down('#fromDateId').getValue();
								var  to = form.down('#toDateId').getValue();
								var  status = form.down('#lmConfigStatus').getRawValue();
								
								if(from != null){
									from= new Date(from);
									from = Ext.Date.format(from, 'Y-m-d');
					                  }
					            
					            if(to != null){
					            	to= new Date(to);
					            	to = Ext.Date.format(to, 'Y-m-d');
					                  } 
//					          
//								if(!isNullOrEmpty(fromDate)){
//									fromDate = fromDate.getTime(); 
//								}
//								if(!isNullOrEmpty(toDate)){
//									toDate = toDate.getTime(); 
//								}
								this.loadPastLeaveRequest(empId, from, to, status,form)
							}
						}
					},
					'lmpastleaverequestform button[itemId=resetBtn]':{
						click : function() {
							var form=this.getLmpastleaverequestform();
							form.down('#fromDateId').setMaxValue(false);
							form.down('#fromDateId').reset();
							form.down('#toDateId').setMinValue(false);
							form.down('#toDateId').reset();
							var  status = form.down('#lmConfigStatus').reset();
						}
					},
					'lmleaverequesttabstructure radiogroup[itemId=selfOrOtherItemId]': {
						change: function(radioField, newValue, oldValue, eOpts) {
							$this = this;
							var structure=this.getLmleaverequesttabstructure();
							var empCombo = structure.down('#employeeNameOrIdItemId');
							if(newValue.isSelf==false) {
								empCombo.setDisabled(false);
								structure.down('#empNameTxtId').reset();
								structure.down('#empDesignationId').reset();
								structure.down('#empDepartmentId').reset();
								structure.down('#empSubDepartmentId').reset();
								structure.down('#empEmailId').reset();
								structure.down('#empMobileId').reset();
								var store = empCombo.getStore();
								empCombo.clearValue();
								empCombo.rawValue = '';
								empCombo.lastValue = '';
								empCombo.lastQuery = '';
								store.removeAll();
								store.load();

							} else {
								empCombo.setDisabled(true);
								empCombo.reset();
								this.loadDataForRequester(true)
								var leaveForm = $this.getLmapplyforleaveform();
								if(leaveForm != undefined){
									var workHandedOverToStore = leaveForm.down('#employeeNames').getStore();
									workHandedOverToStore.getProxy().extraParams = {
										requesterId : this.getCurrentlyLoggedInUser().id
									};
									//workHandedOverToStore.load();
								}
							}
							if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmpastleaverequeststructure') {
								var grid = this.getLmpastleaverequestgrid();
								var store = grid.getStore();
								store.removeAll();
								this.resetPageSetting(store);
								var dockedItemsItemId = grid.down('#lmDockedItemId');
								dockedItemsItemId.setVisible(false);
								if(newValue.isSelf == true) {
									store.getProxy().extraParams = {
										id: this.getCurrentlyLoggedInUser().id
									};
									store.load();
								}
							} else if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmapplyforleavestructure') {
								this.checkApprovalConfigurationSetup();
							} else if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmleavebalanceandapprovalflowstructure') {
								var structure = this.getLmleaverequesttabstructure();
								var grid = this.getLmleavebalanceandapprovalflowgrid();
								var academyLocationId = this.getCurrentAcademyLocation();
								var gridStore = grid.getStore();
								gridStore.removeAll();
								this.resetPageSetting(gridStore);
								var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
								var form = this.getLmapplyforleaveform();
								var userId = null;
								if(isSelf == true) {
									userId = this.getCurrentlyLoggedInUser().id;
									gridStore.getProxy().extraParams = {	
										id: userId,
										acadmeyLocId:academyLocationId
									};
									gridStore.load(); 
								}else{
									empCombo = structure.down('#employeeNameOrIdItemId');
									var empId = empCombo.getValue();
									if(!isNullOrEmpty(empCombo.getValue())) {
										userId = empId
										gridStore.getProxy().extraParams = {	
											id: userId,
											acadmeyLocId:academyLocationId
										};
										gridStore.load(); 
									}
								}
							}
						}
					},
					'lmleaverequesttabstructure customcombobox[itemId=employeeNameOrIdItemId]': {
						select:function(combo) {
							var empId = combo.value;
							var leaveReqForm = this.getLmapplyforleaveform();
							/*leaveReqForm.getForm().reset();
							leaveReqForm.down('#lmRequestDateId').setValue(new Date());*/
							this.loadDataForRequester(false, empId);
							var structure=this.getLmleaverequesttabstructure();
							if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmpastleaverequeststructure') {
								this.loadPastLeaveRequest(empId, undefined, undefined, undefined, undefined);
							} else if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmapplyforleavestructure') {
								//this.loadLeaveTypeCombo();
								var leaveForm = this.getLmapplyforleaveform();
								if(leaveForm != undefined){
									var workHandedOverToStore = leaveForm.down('#employeeNames').getStore();
									workHandedOverToStore.getProxy().extraParams = {
										requesterId : empId
									};
									this.checkApprovalConfigurationSetup();
									//workHandedOverToStore.load();
								}
							}
							else if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmleavebalanceandapprovalflowstructure') {
								var structure = this.getLmleaverequesttabstructure();
								var grid = this.getLmleavebalanceandapprovalflowgrid();
								var academyLocationId = this.getCurrentAcademyLocation();
								var gridStore = grid.getStore();
								gridStore.removeAll();
								this.resetPageSetting(gridStore);
								var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
								var form = this.getLmapplyforleaveform();
								var userId = null;
								if(isSelf == true) {
									userId = this.getCurrentlyLoggedInUser().id;
									gridStore.getProxy().extraParams = {	
										id: userId,
										acadmeyLocId:academyLocationId
									};
									gridStore.load(); 
								}else{
									empCombo = structure.down('#employeeNameOrIdItemId');
									var empId = empCombo.getValue();
									if(!isNullOrEmpty(empCombo.getValue())) {
										userId = empId
										gridStore.getProxy().extraParams = {	
											id: userId,
											acadmeyLocId:academyLocationId
										};
										gridStore.load(); 
									}
								}
							}
							this.resetLeaveApplyForm();	
						}
					},
					'lmapplyforleaveform button[itemId=applyLeaveResetBtn]': {
						click:function() {
							var form = this.getLmapplyforleaveform();
							this.resetLeaveApplyForm();
						}
					},
					'lmapplyforleaveform multiselectcombofield[itemId=employeeNames]': {
						focus:function() {
							var leaveForm = this.getLmapplyforleaveform();
							var structure=this.getLmleaverequesttabstructure();
							var empCombo = structure.down('#employeeNameOrIdItemId');
							var radioBtn = structure.down('#selfOrOtherItemId');
							var workHandedOverToStore = leaveForm.down('#employeeNames').getStore();

							if(radioBtn.items.items[0].getValue()){
								workHandedOverToStore.getProxy().extraParams = {
									requesterId : this.getCurrentlyLoggedInUser().id
								};
							}else{
								var empId = empCombo.getValue();
								if(!isNullOrEmpty(empId)){
									workHandedOverToStore.getProxy().extraParams = {
										requesterId : empId
									};
								}else{
									if(!isNullOrEmpty(workHandedOverToStore.proxy.extraParams.requesterId))
									{
										delete workHandedOverToStore.proxy.extraParams.requesterId;
									}
								}
							}

							//workHandedOverToStore.load();
						}
					},
					'lmapplyforleaveform filefield[itemId=uploadFileField]': {
						change :function(fileField, value, eOpts){
							if (!isNullOrEmpty(value)) {
								var $this = this;
								value = value.replace('C:\\fakepath\\', '');
								var newValue = value.replace(/ +/g, " ").split(' ').join('_');
								fileField.setRawValue(newValue);
							}
						}
					},
					'lmapplyforleaveform datefield[itemId=lmToDateId]': {                        
						change:function() {var form = this.getLmapplyforleaveform();
						var fromDate=form.getValues().lmFromDateId;
						var toDate=form.getValues().lmToDateId;
						var leaveCounter = form.down('#leaveCounter');
						var leaveCounter1 = form.down('#leaveCounter1');
						var leaveCounter2 = form.down('#leaveCounter2');

						var structure = this.getLmleaverequesttabstructure();
						var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
						var leaveReqUserId;
						var leaveReqUserCode;
						var leaveTypeId=form.down('#lmLeaveTypeId').value;
						var date1 = new Date(fromDate);
						var date2 = new Date(toDate);
						if(toDate>fromDate){
							leaveCounter2.setValue("<b>To</b>");
						}

						if(isSelf == true){
							leaveReqUserId = this.getCurrentlyLoggedInUser().id;
							leaveReqUserCode = this.getCurrentlyLoggedInUser().code;

						} else {
							empCombo = structure.down('#employeeNameOrIdItemId');
							if(!isNullOrEmpty(empCombo.getValue())) {
								leaveReqUserId = empCombo.valueModels[0].data.id;
								leaveReqUserCode = empCombo.valueModels[0].data.code;
							}
						}

						var halfDayStart =false;
						var halfDayEnd =false;
						console.log(Ext.ComponentQuery.query('#leaveCategory')[0].hidden);
						if(!Ext.ComponentQuery.query('#leaveCategory')[0].hidden){
							var temp;
							Ext.ComponentQuery.query('[name=isSelf]').forEach(function(element){
								if(element.checked==true){
									// console.log(element.inputValue);
									temp = element.inputValue;
									return;
								}});
							if(temp=='sh'){
								halfDayEnd=true;
							}
							if(temp=='fh'){
								halfDayStart =true;
							}

						}else if(!Ext.ComponentQuery.query('#leaveCategory2')[0].hidden&&!Ext.ComponentQuery.query('#leaveCategory3')[0].hidden){
							var test1,  test2;
							Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
								if(element.checked==true){
									// console.log(element.inputValue);
									test1 = element.inputValue;
									return;
								}});
							Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
								if(element.checked==true){
									// console.log(element.inputValue);
									test2 = element.inputValue;
									return;
								}});

							halfDayStart =test1;
							halfDayEnd= test2;
						} 
                        if(!isNullOrEmpty(leaveReqUserId) && !isNullOrEmpty(leaveReqUserCode) && !isNullOrEmpty(leaveTypeId) && !isNullOrEmpty(fromDate) && !isNullOrEmpty(toDate)){
                        	Ext.Ajax.request({
    							method: "GET",
    							type: 'rest',
    							url: SERVERURL.PATH_FIND_HOLIDAY_COUNT,
    							params: {
    								leaveReqUserId: leaveReqUserId,
    								leaveReqUserCode: leaveReqUserCode,
    								hrLeaveTypeIDCodeId: leaveTypeId,
    								fromDate: fromDate,
    								toDate: toDate, 
    								isHalfDayStart: halfDayStart,
    								isHalfDayEnd: halfDayEnd
    							},
    							headers: {
    								'Content-Type': 'application/json'
    							},
    							success: function (response) {
    								var data = Ext.decode(response.responseText);
    								if(day > 1){
    									leaveCounter.setValue(day+' days');
    								}else{
    									leaveCounter.setValue(day+' day');
    								}
    								if(data>1){
    									leaveCounter1.setValue('Leave request is for  '+data+'  days');
    								}else{
    									leaveCounter1.setValue('Leave request is for  '+data+'  day');
    								}
    							}

    						});
                        }
						var Difference_In_Time = date2.getTime() - date1.getTime();
						var day = (Difference_In_Time / (1000 * 3600 * 24))+1;
						leaveCounter.setValue(day+" days");
						leaveCounter1.setValue("Leave request is for "+day+"   days");

						form.down('#leaveCategory').reset();
						form.down('#leaveCategory2').reset();
						form.down('#leaveCategory3').reset();

						if(day==1){
							form.down('#leaveCategory').setVisible(true);
							form.down('#leaveCategory2').setVisible(false);
							form.down('#leaveCategory3').setVisible(false);
						}else{
							form.down('#leaveCategory').setVisible(false);
							form.down('#leaveCategory2').setVisible(true);
							form.down('#leaveCategory3').setVisible(true);
						}

						if(day>1){
							leaveCounter.setValue(day+" days");
							leaveCounter1.setValue("Leave request is for "+day+"   days");
						}
						
						
						

						if(day==1){
							form.down('#leaveCounter2').reset();
							leaveCounter.setValue(day+" day");
							leaveCounter1.setValue("Leave request is for "+day+"   days");
						} 
						}
					},
					 
					'lmapplyforleaveform radiogroup[itemId=leaveCategory2]': {
						change:function(value) {
							var form = this.getLmapplyforleaveform();
							var structure = this.getLmleaverequesttabstructure();
							var leaveCounter = form.down('#leaveCounter');	
							var leaveCounter1 = form.down('#leaveCounter1');
							var leaveCounter2 = form.down('#leaveCounter2');
							var leaveTypeId=form.down('#lmLeaveTypeId').value;
							var fromDate=form.down('#lmFromDateId').value;
							var toDate=form.down('#lmToDateId').value;
							var fromdate=form.down('#lmFromDateId').getValue();
							var tilldate=form.down('#lmToDateId').getValue();
							var date1 = new Date(fromdate);
							var date2 = new Date(tilldate);
							var Difference_In_Time = date2.getTime() - date1.getTime();
							var day = (Difference_In_Time / (1000 * 3600 * 24))+1;
							var test2 ;
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;

							Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
								if(element.checked==true){
									//	console.log(element.inputValue);
									test2 = element.inputValue;
									return;
								}
							});
							var  test1 = value.lastValue.firstRadioGroup;
							if(!test1&&test2) {
								day = day-0.5;
								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is  for "+day+"  days");
							}     

							if(test1&&test2){
								day = day-1;
								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is for "+day+"    days");
							}
							if(!test1&&!test2){

								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is for "+day+"   days");
							}
							if(test1&&!test2) {
								day = day-0.5;
								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is  for "+day+"  days");
							}     
							
							if(isSelf == true){
								leaveReqUserId = this.getCurrentlyLoggedInUser().id;
								leaveReqUserCode = this.getCurrentlyLoggedInUser().code;

							} else {
								empCombo = structure.down('#employeeNameOrIdItemId');
								if(!isNullOrEmpty(empCombo.getValue())) {
									leaveReqUserId = empCombo.valueModels[0].data.id;
									leaveReqUserCode = empCombo.valueModels[0].data.code;
								}
							}

							var halfDayStart =false;
							var halfDayEnd =false;
							if(!Ext.ComponentQuery.query('#leaveCategory')[0].hidden){
								var temp;
								Ext.ComponentQuery.query('[name=isSelf]').forEach(function(element){
									if(element.checked==true){
										// console.log(element.inputValue);
										temp = element.inputValue;
										return;
									}});
								if(temp=='sh'){
									halfDayEnd=true;
								}
								if(temp=='fh'){
									halfDayStart =true;
								}

							}else if(!Ext.ComponentQuery.query('#leaveCategory2')[0].hidden&&!Ext.ComponentQuery.query('#leaveCategory3')[0].hidden){
								var test1,  test2;
								Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
									if(element.checked==true){
										// console.log(element.inputValue);
										test1 = element.inputValue;
										return;
									}});
								Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
									if(element.checked==true){
										// console.log(element.inputValue);
										test2 = element.inputValue;
										return;
									}});

								halfDayStart =test1;
								halfDayEnd= test2;
							} 
							 if(!isNullOrEmpty(leaveReqUserId) && !isNullOrEmpty(leaveReqUserCode) && !isNullOrEmpty(leaveTypeId) && !isNullOrEmpty(fromDate) && !isNullOrEmpty(toDate)){
									Ext.Ajax.request({
										method: "GET",
										type: 'rest',
										url: SERVERURL.PATH_FIND_HOLIDAY_COUNT,
										params: {
											leaveReqUserId: leaveReqUserId,
											leaveReqUserCode: leaveReqUserCode,
											hrLeaveTypeIDCodeId: leaveTypeId,
											fromDate: fromdate,
											toDate: tilldate, 
											isHalfDayStart: halfDayStart,
											isHalfDayEnd: halfDayEnd
										},
										headers: {
											'Content-Type': 'application/json'
										},
										success: function (response) {
											var data = Ext.decode(response.responseText);
											if(day > 1){
												leaveCounter.setValue(day+' days');
											}else{
												leaveCounter.setValue(day+' day');
											}
											if(data>1){
												leaveCounter1.setValue('Leave request is for  '+data+'  days');
											}else{
												leaveCounter1.setValue('Leave request is for  '+data+'  day');
											}
										}
								});
							 }
					}
					},
					
					'lmapplyforleaveform radiogroup[itemId=leaveCategory3]': {
						change:function(value) {
							var form = this.getLmapplyforleaveform();
							var structure = this.getLmleaverequesttabstructure();
							var leaveCounter = form.down('#leaveCounter');
							var leaveCounter1 = form.down('#leaveCounter1');
							var leaveCounter2 = form.down('#leaveCounter2');	
							var leaveTypeId=form.down('#lmLeaveTypeId').value;
							var fromDate=form.down('#lmFromDateId').value;
							var toDate=form.down('#lmToDateId').value;
							var fromdate=form.down('#lmFromDateId').getValue();
							var tilldate=form.down('#lmToDateId').getValue();
							var date1 = new Date(fromdate);
							var date2 = new Date(tilldate);                            
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							var Difference_In_Time = date2.getTime() - date1.getTime();
							var day = (Difference_In_Time / (1000 * 3600 * 24))+1;
							var test1 ;
							Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
								if(element.checked==true){
									test1 = element.inputValue;
									return;
								}

							});
							var  test2 = value.lastValue.secondRadioGroup;
							if(!test1&&test2) {
								day = day-0.5;
								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is  for "+day+"  days");
							}     
							if(test1&&test2){
								day = day-1;
								leaveCounter.setValue(day+" day");
								leaveCounter1.setValue("Leave request  is for "+day+"   day");
							}
							if(!test1&&!test2){

								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is for "+day+"   days");
							}
							if(test1&&!test2) {
								day = day-0.5;
								leaveCounter.setValue(day+" days");
								leaveCounter1.setValue("Leave request is  for "+day+"  days");
							}         
							
							if(isSelf == true){
								leaveReqUserId = this.getCurrentlyLoggedInUser().id;
								leaveReqUserCode = this.getCurrentlyLoggedInUser().code;

							} else {
								empCombo = structure.down('#employeeNameOrIdItemId');
								if(!isNullOrEmpty(empCombo.getValue())) {
									leaveReqUserId = empCombo.valueModels[0].data.id;
									leaveReqUserCode = empCombo.valueModels[0].data.code;
								}
							}

							var halfDayStart =false;
							var halfDayEnd =false;
							if(!Ext.ComponentQuery.query('#leaveCategory')[0].hidden){
								var temp;
								Ext.ComponentQuery.query('[name=isSelf]').forEach(function(element){
									if(element.checked==true){
										// console.log(element.inputValue);
										temp = element.inputValue;
										return;
									}});
								if(temp=='sh'){
									halfDayEnd=true;
								}
								if(temp=='fh'){
									halfDayStart =true;
								}

							}else if(!Ext.ComponentQuery.query('#leaveCategory2')[0].hidden&&!Ext.ComponentQuery.query('#leaveCategory3')[0].hidden){
								var test1,  test2;
								Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
									if(element.checked==true){
										// console.log(element.inputValue);
										test1 = element.inputValue;
										return;
									}});
								Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
									if(element.checked==true){
										// console.log(element.inputValue);
										test2 = element.inputValue;
										return;
									}});

								halfDayStart =test1;
								halfDayEnd= test2;
							} 
							if(!isNullOrEmpty(leaveReqUserId) && !isNullOrEmpty(leaveReqUserCode) && !isNullOrEmpty(leaveTypeId) && !isNullOrEmpty(fromDate) && !isNullOrEmpty(toDate)){
								Ext.Ajax.request({
									method: "GET",
									type: 'rest',
									url: SERVERURL.PATH_FIND_HOLIDAY_COUNT,
									params: {
										leaveReqUserId: leaveReqUserId,
										leaveReqUserCode: leaveReqUserCode,
										hrLeaveTypeIDCodeId: leaveTypeId,
										fromDate: fromdate,
										toDate: tilldate, 
										isHalfDayStart: halfDayStart,
										isHalfDayEnd: halfDayEnd
									},
									headers: {
										'Content-Type': 'application/json'
									},
									success: function (response) {
										var data = Ext.decode(response.responseText);
										if(day > 1){
											leaveCounter.setValue(day+' days');
										}else{
											leaveCounter.setValue(day+' day');
										}
										if(data>1){
											leaveCounter1.setValue('Leave request is for  '+data+'  days');
										}else{
											leaveCounter1.setValue('Leave request is for  '+data+'  day');
										}
									}
							});
							}
						}
					},
					'lmapplyforleaveform datefield[itemId=lmFromDateId]': {
						change:function() {var form = this.getLmapplyforleaveform();
						//	this.resetLeaveApplyForm();
						var fromDate=form.getValues().lmFromDateId;
						var toDate=form.getValues().lmToDateId;

						var toDate=form.down('#lmToDateId').setValue(fromDate);
						var leaveCounter = form.down('#leaveCounter');
						var leaveCounter1 = form.down('#leaveCounter1');
						var leaveCounter2 = form.down('#leaveCounter2');

						var structure = this.getLmleaverequesttabstructure();
						var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
						var leaveReqUserId;
						var leaveReqUserCode;
						var leaveTypeId=form.down('#lmLeaveTypeId').value;
						
						//    var halfDayStart = form.down('#halfDayStart').value;
						//var halfDayEnd = form.down('#halfDayEnd').value;
						if(isSelf == true){
							leaveReqUserId = this.getCurrentlyLoggedInUser().id;
							leaveReqUserCode = this.getCurrentlyLoggedInUser().code;

						} else {
							empCombo = structure.down('#employeeNameOrIdItemId');
							if(!isNullOrEmpty(empCombo.getValue())) {
								leaveReqUserId = empCombo.valueModels[0].data.id;
								leaveReqUserCode = empCombo.valueModels[0].data.code;
							} 
						}
						form.down('#leaveCategory').setVisible(true);
						form.down('#leaveCategory2').setVisible(false);
						form.down('#leaveCategory3').setVisible(false);

						var fromdate=form.down('#lmFromDateId').getValue();
						var tilldate=form.down('#lmToDateId').getValue();
						var date1 = new Date(fromdate);
						var date2 = new Date(tilldate);

						var Difference_In_Time = date2.getTime() - date1.getTime();
						var day = (Difference_In_Time / (1000 * 3600 * 24))+1;

						leaveCounter.setValue(day+" day");
						leaveCounter1.setValue('<b>Leave request is for 1 day<b>');

						if(day==1){
							form.down('#leaveCounter2').reset();
						}

						var halfDayStart =false;
						var    halfDayEnd =false;
						console.log(Ext.ComponentQuery.query('#leaveCategory')[0].hidden);
						if(!Ext.ComponentQuery.query('#leaveCategory')[0].hidden){

							var temp;
							Ext.ComponentQuery.query('[name=isSelf]').forEach(function(element){
								if(element.checked==true){
									//    console.log(element.inputValue);
									temp = element.inputValue;
									return;
								}});
							if(temp=='sh'){
								halfDayEnd=true;
							}
							if(temp=='fh'){
								halfDayStart =true;
							}

						}else if(!Ext.ComponentQuery.query('#leaveCategory2')[0].hidden&&!Ext.ComponentQuery.query('#leaveCategory3')[0].hidden){
							var test1,  test2;
							Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
								if(element.checked==true){
									//    console.log(element.inputValue);
									test1 = element.inputValue;
									return;
								}});
							Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
								if(element.checked==true){
									//    console.log(element.inputValue);
									test2 = element.inputValue;
									return;
								}});

							halfDayStart =test1;
							halfDayEnd= test2;
						}
						if(!isNullOrEmpty(leaveReqUserId) && !isNullOrEmpty(leaveReqUserCode) && !isNullOrEmpty(leaveTypeId) && !isNullOrEmpty(fromDate) && !isNullOrEmpty(toDate)){
							Ext.Ajax.request({
								method : "GET",
								type : 'rest',
								url: SERVERURL.PATH_FIND_HOLIDAY_COUNT,
								params: {
									leaveReqUserId:leaveReqUserId,
									leaveReqUserCode:leaveReqUserCode,
									hrLeaveTypeIDCodeId:leaveTypeId,
									fromDate:fromdate,
									toDate: tilldate,
									isHalfDayStart:halfDayStart,
									isHalfDayEnd:halfDayEnd
								},
								headers : {
									'Content-Type' : 'application/json'
								},
								success: function(response) {
									var data = Ext.decode(response.responseText);
									if(day > 1){
										leaveCounter.setValue(day+' days');
									}else{
										leaveCounter.setValue(day+' day');
									}
									if(data>1){
										leaveCounter1.setValue('Leave request is for  '+data+'  days');
									}else{
										leaveCounter1.setValue('Leave request is for  '+data+'  day');
									}
								}
							});
						}
					}
					},
					'lmapplyforleaveform radiogroup[itemId=leaveCategory]': {
						change:function(value) {
							var form = this.getLmapplyforleaveform();
							var leaveCounter = form.down('#leaveCounter');
							var leaveCounter1 = form.down('#leaveCounter1');
							var structure = this.getLmleaverequesttabstructure();
							var fromdate=form.down('#lmFromDateId').getValue();
							var tilldate=form.down('#lmToDateId').getValue();
							var date1 = new Date(fromdate);
							var date2 = new Date(tilldate);
							var fromDate=form.down('#lmFromDateId').value;
							var toDate=form.down('#lmToDateId').value;
							
							var Difference_In_Time = date2.getTime() - date1.getTime();
							var day = (Difference_In_Time / (1000 * 3600 * 24))+1;
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							var leaveTypeId=form.down('#lmLeaveTypeId').value;
							var leaveReqUserId;
							//var fromDate;
							//var toDate;
							leaveCounter.setValue(day+" day");
							if(value.lastValue.isSelf=="fd"){
								leaveCounter.setValue(day+" day");
								//leaveCounter1.setValue('Leave request is for  '+data+'  day');
								//leaveCounter1.setValue('<b>Leave request is for 1 day</b>');
							}else{
								day = day-0.5;
								leaveCounter.setValue(day+" day");
								//leaveCounter1.setValue('<b>Leave request is  for 0.5 day</b>');
								//leaveCounter1.setValue('Leave request is for  '+data+'  day');
								
							}
							if(isSelf == true){
								leaveReqUserId = this.getCurrentlyLoggedInUser().id;
								leaveReqUserCode = this.getCurrentlyLoggedInUser().code;

							} else {
								empCombo = structure.down('#employeeNameOrIdItemId');
								if(!isNullOrEmpty(empCombo.getValue())) {
									leaveReqUserId = empCombo.valueModels[0].data.id;
									leaveReqUserCode = empCombo.valueModels[0].data.code;
								}
							}

							
							
							var halfDayStart =false;
							var    halfDayEnd =false;
							console.log(Ext.ComponentQuery.query('#leaveCategory')[0].hidden);
							if(!Ext.ComponentQuery.query('#leaveCategory')[0].hidden){

								var temp;
								Ext.ComponentQuery.query('[name=isSelf]').forEach(function(element){
									if(element.checked==true){
										//    console.log(element.inputValue);
										temp = element.inputValue;
										return;
									}});
								if(temp=='sh'){
									halfDayEnd=true;
								}
								if(temp=='fh'){
									halfDayStart =true;
								}
							
							
							}else if(!Ext.ComponentQuery.query('#leaveCategory2')[0].hidden&&!Ext.ComponentQuery.query('#leaveCategory3')[0].hidden){
								var test1,  test2;
								Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
									if(element.checked==true){
										//    console.log(element.inputValue);
										test1 = element.inputValue;
										return;
									}});
								Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
									if(element.checked==true){
										//    console.log(element.inputValue);
										test2 = element.inputValue;
										return;
									}});

								halfDayStart =test1;
								halfDayEnd= test2;
							}
							
							
							
					
							if(!isNullOrEmpty(leaveReqUserId) && !isNullOrEmpty(leaveReqUserCode) && !isNullOrEmpty(leaveTypeId) && !isNullOrEmpty(fromDate) && !isNullOrEmpty(toDate)){		
							Ext.Ajax.request({
								method : "GET",
								type : 'rest',
								url: SERVERURL.PATH_FIND_HOLIDAY_COUNT,
								params: {
									leaveReqUserId:leaveReqUserId,
									leaveReqUserCode:leaveReqUserCode,
									hrLeaveTypeIDCodeId:leaveTypeId,
									fromDate:fromdate,
									toDate: tilldate,
									isHalfDayStart:halfDayStart,
									isHalfDayEnd:halfDayEnd
								},
								headers : {
									'Content-Type' : 'application/json'
								},
								success: function(response) {
									var data = Ext.decode(response.responseText);
									if(day > 1){
										leaveCounter.setValue(day+' days');
									}else{
										leaveCounter.setValue(day+' day');
									}
									if(data>1){
										leaveCounter1.setValue('Leave request is for  '+data+'  days');
									}else{
										leaveCounter1.setValue('Leave request is for  '+data+'  day');
									}
								}
							});
							
							
							}
								
							
						}
					},
					'lmapplyforleaveform button[itemId=applyLeaveBtn]': {
						click: function(){
							var this$ = this;
							var form = this.getLmapplyforleaveform(); 
							var structure = this.getLmleaverequesttabstructure();
							var empCombo;
							var leaveReqUserId;
							var leaveReqUserCode;
							var leaveEnterById = this.getCurrentlyLoggedInUser().id;
							var leaveEnterByCode = this.getCurrentlyLoggedInUser().code;
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							if(isSelf == true){
								leaveReqUserId = this.getCurrentlyLoggedInUser().id;
								leaveReqUserCode = this.getCurrentlyLoggedInUser().code;
							} else {
								empCombo = structure.down('#employeeNameOrIdItemId');
								if(!isNullOrEmpty(empCombo.getValue())) {
									leaveReqUserId = empCombo.valueModels[0].data.id;
									leaveReqUserCode = empCombo.valueModels[0].data.code;
								} else {
									showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_SELECT_EMPLOYEE'));
								}
							}
							if(isSelf == true || (!isNullOrEmpty(empCombo.getValue()))) {
								var leaveTypeId=form.down('#lmLeaveTypeId').value;
								var requestDate=form.down('#lmRequestDateId').value;
								var fromDate=form.down('#lmFromDateId').value;
								var toDate=form.down('#lmToDateId').value;
								var lmClaimDate = form.down('#lmClaimDateItemId').value;
								var lmLeaveRequireOnDate = form.down('#lmLeaveRequireOnDateItemId').value;
								var reason=form.down('#leaveReasonId').value;
								var workHandedOverTo = form.down('#employeeNames').value;
								var halfDayStart =false;
							    var	halfDayEnd =false;
			                   console.log(Ext.ComponentQuery.query('#leaveCategory')[0].hidden);
			                 if(!Ext.ComponentQuery.query('#leaveCategory')[0].hidden){
				                 
				                
                       var temp;
                          Ext.ComponentQuery.query('[name=isSelf]').forEach(function(element){
						if(element.checked==true){
						//	console.log(element.inputValue);
							temp = element.inputValue;
							return;
						}});
						if(temp=='sh'){
							halfDayEnd=true;
						}
						if(temp=='fh'){
							halfDayStart =true;
						}
						
                  }else if(!Ext.ComponentQuery.query('#leaveCategory2')[0].hidden&&!Ext.ComponentQuery.query('#leaveCategory3')[0].hidden){
	                var test1,  test2;
                         Ext.ComponentQuery.query('[name=firstRadioGroup]').forEach(function(element){
						if(element.checked==true){
						//	console.log(element.inputValue);
							test1 = element.inputValue;
							return;
						}});
						 Ext.ComponentQuery.query('[name=secondRadioGroup]').forEach(function(element){
						if(element.checked==true){
						//	console.log(element.inputValue);
							test2 = element.inputValue;
							return;
						}});
	               
	
	                    halfDayStart =test1;
                        halfDayEnd= test2;
                   
	
	
                      }


							//	var halfDayStart = form.down('#isHalfDayStart').value;
							//	var halfDayEnd = form.down('#isHalfDayEnd').value;
								var alternateEmployees = [];
								var hrEmpLeaveRequestHandoverUsers = [];
								var alternateEmpNames;
								if(!isNullOrEmpty(workHandedOverTo)) { 
									for(var i=0; i<workHandedOverTo.length; i++) {
										//alternateEmployees.push(workHandedOverTo[i].data.id) 
										if(!isNullOrEmpty(workHandedOverTo[i])){
											var alternateEmployee = new Object();
											var user = new Object();
											user.id = workHandedOverTo[i].data.id;
											alternateEmployee.user = user;
											hrEmpLeaveRequestHandoverUsers.push(alternateEmployee);
										}
									}
									//alternateEmpNames = alternateEmployees.join();
								}
						//var empleavetype=form.getForm().findField('isSelf').inputValue;
						//var empleavetype1=form.getForm().findField('firstRadioGroup').inputValue;
						//var empleavetype2=form.getForm().findField('secondRadioGroup').inputValue;
								var empLeaveRequest = new Object();
								var leaveEnterBy = new Object();
								leaveEnterBy.id = leaveEnterById;
								leaveEnterBy.code = leaveEnterByCode;
								var leaveReqUser = new Object();
								leaveReqUser.id = leaveReqUserId;
								leaveReqUser.code = leaveReqUserCode;
								var hrLeaveTypeIDCode = new Object();
								hrLeaveTypeIDCode.id=leaveTypeId;
								empLeaveRequest.leaveEnterBy=leaveEnterBy;
								empLeaveRequest.leaveReqUser=leaveReqUser;
								empLeaveRequest.hrLeaveTypeIDCode=hrLeaveTypeIDCode;
								empLeaveRequest.requestDate=requestDate.getTime();
								empLeaveRequest.portalId=this.getCurrentLoggedPortalId();
								if(!isNullOrEmpty(fromDate)) {
									empLeaveRequest.fromDate=fromDate.getTime();
								}
								if(!isNullOrEmpty(toDate)) {
									empLeaveRequest.toDate=toDate.getTime();
								}
								if(!isNullOrEmpty(lmClaimDate)) {
									empLeaveRequest.claimDate=lmClaimDate.getTime();
								}
								if(!isNullOrEmpty(lmLeaveRequireOnDate)) {
									empLeaveRequest.leaveRequireOnDate=lmLeaveRequireOnDate.getTime();
								}
								empLeaveRequest.reason=reason;
								empLeaveRequest.alternateEmpNames=alternateEmpNames;
								empLeaveRequest.hrEmpLeaveRequestHandoverUser = hrEmpLeaveRequestHandoverUsers;
								empLeaveRequest.isHalfDayStart = halfDayStart;
								empLeaveRequest.isHalfDayEnd = halfDayEnd;
								//empLeaveRequest = Ext.encode(empLeaveRequest);
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								var document = form.down('#uploadFileField');
								var docPath = document.getValue();
								if(!isNullOrEmpty(document.getValue())) {
									var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
									form.getForm().submit({
										method: 'POST',
										url: uplaodUrl,
										success: function(form1, action) {
											var responseData = Ext.decode(action.response.responseText);
											var path = responseData.path;
											form.getForm().findField('file').setValue(path);
											this$.saveLeaveRequest(form, empLeaveRequest, path);
										},
									});
								}else {
									this$.saveLeaveRequest(form, empLeaveRequest);
								}
							}
						}
					},
					'lmpastleaverequeststructure':{
						activate:function(){
							var structure = this.getLmleaverequesttabstructure();
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							var grid = this.getLmpastleaverequestgrid();
							var userId;
							var store = grid.getStore();
							store.removeAll();
							this.resetPageSetting(store);
							var dockedItemsItemId = grid.down('#lmDockedItemId');
							dockedItemsItemId.setVisible(false);
							if(isSelf == true) {
								userId = this.getCurrentlyLoggedInUser().id;
								this.loadPastLeaveRequest(userId, undefined, undefined, undefined, undefined);
							}else{
								var empCombo = structure.down('#employeeNameOrIdItemId');
								userId = empCombo.getValue();
								if(!isNullOrEmpty(empCombo.getValue())) {
									this.loadPastLeaveRequest(userId, undefined, undefined, undefined, undefined);
								}
							}
						}
					},
					'lmpastleaverequestgrid': {
						cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							if(e.target.tagName == 'A'){
								var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
								var $this = this;
								var record = grid.getSelectionModel().getSelection()[0];
								if (columnName == 'withDraw') {
									/* var confirmationWin = $this.getLmleaverequestwithdrawconfirmationwin();
        				   if(isNullOrEmpty(confirmationWin)){
        					   Ext.widget('lmleaverequestwithdrawconfirmationwin');
        					   confirmationWin = $this.getLmleaverequestwithdrawconfirmationwin();
        				   }
        				   confirmationWin.show();*/

									if(record.get('status') == "Approved"){
										var formWindow = $this.getLmemployeeleavecancellationrequestdetailwin();
										if (!formWindow) {
											Ext.widget('lmemployeeleavecancellationrequestdetailwin');
											formWindow = $this.getLmemployeeleavecancellationrequestdetailwin();
										}
										formWindow.show();

										formWindow.down('#lmFromDateId').setValue(dateRender(record.get('fromDate')));
										formWindow.down('#lmToDateId').setValue(dateRender(record.get('toDate')));
										formWindow.down('#leaveRequestItemId').setValue(record.get('id'));

										var fromDate =  new Date(record.get('fromDate'));
										var toDate =  new Date(record.get('toDate'));
										var currentDate = new Date().setHours(0,0,0,0);
										currentDate = new Date(currentDate);

										if(currentDate<fromDate){
											formWindow.down('#lmCancelFromDateId').setValue(dateRender(record.get('fromDate')));
											formWindow.down('#lmCancelToDateId').setValue(dateRender(record.get('toDate')));
											formWindow.down('#lmCancelFromDateId').setMinValue(dateRender(record.get('fromDate')));
											formWindow.down('#lmCancelFromDateId').setMaxValue(dateRender(record.get('toDate')));
											formWindow.down('#lmCancelToDateId').setMinValue(dateRender(record.get('fromDate')));
											formWindow.down('#lmCancelToDateId').setMaxValue(dateRender(record.get('toDate')));
										}
										else if(toDate>=currentDate){
											formWindow.down('#lmCancelFromDateId').setValue(new Date());
											formWindow.down('#lmCancelToDateId').setValue(dateRender(record.get('toDate')));
											formWindow.down('#lmCancelFromDateId').setMinValue(new Date());
											formWindow.down('#lmCancelFromDateId').setMaxValue(dateRender(record.get('toDate')));
											formWindow.down('#lmCancelToDateId').setMinValue(new Date());
											formWindow.down('#lmCancelToDateId').setMaxValue(dateRender(record.get('toDate')));
										}

									}
									else{
										var pastGrid = $this.getLmpastleaverequestgrid();
										showConfirmMessage(getCommonTranslation('WITHDRAW_LEAVE_REQUEST'), getCommonTranslation('CONFIRM_WITHDRAW_LEAVE_REQUEST'), function(btn, text) {
											if (btn == 'yes') {
												Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
												var record = pastGrid.getSelectionModel().getSelection()[0];
												var selectedLeaveRequest = record.raw;
												selectedLeaveRequest.status = 'WITHDRAWN';;
												Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
												Ext.Ajax.request({
													type: 'rest',
													url: SERVERURL.HR_EMP_LEAVE_REQUEST_UPDATE,
													jsonData: selectedLeaveRequest,
													method: 'POST',
													success: function(frm, action) {
														var data = frm.responseText;
														showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_LEAVE_WITHDRAWN'));
														var store = pastGrid.getStore();
														store.removeAll();
														store.load();
														Ext.getBody().unmask();
													}
												});
											}
										});
									}
								} else if(columnName == "document") {
									var documentId = record.raw.document.encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
								else if(columnName == "id") {
									var $this = this;
									var formWindow = $this.getLmemployeeleaverequestdetailwin();
									if (!formWindow) {
										Ext.widget('lmemployeeleaverequestdetailwin');
										formWindow = $this.getLmemployeeleaverequestdetailwin();
									}
									var empReqDetailGrid = formWindow.down('#lmEmployeeLeaveRequestDetailGrid');
									this.openEmpLeaveReqDetailWin(record,formWindow,empReqDetailGrid);
								}
							}
							else{
								var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
								if((record.get('status') == "Cancelled" || record.get('status') == "Partially Cancelled") && columnName != "id"){
									var $this = this;
									Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
									var formWindow = $this.getLmemployeepastleaverequestdetailwin();
									if (!formWindow) {
										Ext.widget('lmemployeepastleaverequestdetailwin');
										formWindow = $this.getLmemployeepastleaverequestdetailwin();
									}
									toggleReadOnlyFormItems(formWindow.down('#lmemployeepastleaverequestdetailformItemId').getForm(), true);
									var lmLeaveTypeCombo = formWindow.down('#lmLeaveTypeId')
									var eligibilityCriteriaVal = record.raw.eligibilityCriteria;
									Ext.getBody().unmask();
									if(!isNullOrEmpty(eligibilityCriteriaVal) && eligibilityCriteriaVal == 'COMPENSATORY'){
										formWindow.show();
										$this.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
										formWindow.down('#lmFromDateId').setVisible(false);
										formWindow.down('#lmToDateId').setVisible(false);
										//formWindow.down('#isHalfDayStart').setVisible(false);
									//	formWindow.down('#isHalfDayEnd').setVisible(false);
										lmLeaveTypeCombo.setValue(record.data.hrLeaveTypeIDCode.value);
										formWindow.down('#lmClaimDateItemId').setVisible(true);
										formWindow.down('#lmClaimDateItemId').setValue(dateRender(record.raw.claimDate));
										formWindow.down('#lmLeaveRequireOnDateItemId').setVisible(true);
										formWindow.down('#lmLeaveRequireOnDateItemId').setValue(dateRender(record.raw.leaveRequireOnDate));

									} else {
										formWindow.show();
										$this.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
										lmLeaveTypeCombo.setValue(record.data.hrLeaveTypeIDCode.value);
										formWindow.down('#lmFromDateId').setVisible(true);
										formWindow.down('#lmToDateId').setVisible(true);
									//	formWindow.down('#isHalfDayStart').setVisible(true);
									//	formWindow.down('#isHalfDayEnd').setVisible(true);
										formWindow.down('#lmFromDateId').setValue(dateRender(record.raw.fromDate));
										formWindow.down('#lmToDateId').setValue(dateRender(record.raw.toDate));
									//	formWindow.down('#isHalfDayStart').setValue(record.raw.isHalfDayStart);
										formWindow.down('#isHalfDayEnd').setValue(record.raw.isHalfDayEnd);
										formWindow.down('#lmClaimDateItemId').setVisible(false);
										formWindow.down('#lmLeaveRequireOnDateItemId').setVisible(false);
									}
									if(! isNullOrEmpty(record.raw.document) && ! isNullOrEmpty(record.raw.document)) {
										formWindow.down('#lmDocumentNameItemId').setValue(record.raw.document.name);
									}
									formWindow.down('#lmCancelFromDateId').setVisible(true);
									formWindow.down('#lmCancelToDateId').setVisible(true);
									formWindow.down('#lmCancelFromDateId').setValue(dateRender(record.raw.cancelFrom));
									formWindow.down('#lmCancelToDateId').setValue(dateRender(record.raw.cancelTo));

									if(record.raw.cancelFrom<record.raw.fromDate){
										formWindow.down('#lmFromDateId').setValue(dateRender(record.raw.cancelFrom));
									}
									else{
										formWindow.down('#lmFromDateId').setValue(dateRender(record.raw.fromDate));
									}

									if(record.raw.cancelTo>record.raw.toDate){
										formWindow.down('#lmToDateId').setValue(dateRender(record.raw.cancelTo));
									}
									else{
										formWindow.down('#lmToDateId').setValue(dateRender(record.raw.toDate));
									}

									formWindow.down('#leaveReasonId').setValue(record.raw.cancelReason);
									formWindow.down('#leaveReasonId').setFieldLabel(getPersonModuleTranslation('LMAS_LEAVE_CANCELLATION_REASON'));
									formWindow.down('#employeeNames').getStore().load({
										callback:function(){
											/*if(!isNullOrEmpty(record.raw.alternateEmpNames)) {
           		        				var alternateEmployees = record.raw.alternateEmpNames.split(',');
               		        			formWindow.down('#employeeNames').setValue(alternateEmployees);
               		        			formWindow.down('#employeeNames').inputEl.dom.style.height="110px";
           		        			}*/
											if(!isNullOrEmpty(record.raw.alternateEmployeeIds)) {
												formWindow.down('#employeeNames').setValue(record.raw.alternateEmployeeIds);
												formWindow.down('#employeeNames').inputEl.dom.style.height="110px";
											}
											if (formWindow.down('#employeeNames') != null) {
												formWindow.down('#employeeNames').setHeight('auto');
											}
											formWindow.down('#employeeNames').el.dom.style.height = 'auto';
											$this.hideWindowMask();
										}
									});
								}
							}
						}
					},

					'lmrequestspendingactionfilter button[itemId=searchRPAFilterItemId] ': {
						click: function(){
							$this = this;
							var grid = $this.getLmrequestspendingactiongrid();
							var frm = $this.getLmrequestspendingactionfilter();
							var gridStore = grid.getStore();
							//var staffId = $this.getCurrentlyLoggedInUser().id;

							var sDate = frm.down('#fromDateItemId').getValue();
							var eDate = frm.down('#toDateItemId').getValue();
							var requesterId = frm.down('#requesterNameOrIdItemId').getValue();

							var radioSelf = frm.down('#selfOrOtherItemId').items.items[0].value;
							var radioOther = frm.down('#selfOrOtherItemId').items.items[1].value;
							var EmpId = null;
							
							if(sDate != null){
                                sDate= new Date(sDate);
                                sDate = Ext.Date.format(sDate, 'Y-m-d');
                            }
                            
                            if(eDate != null){
                                eDate= new Date(eDate);
                                eDate = Ext.Date.format(eDate, 'Y-m-d');
                            }
                            
							if(radioSelf){
								EmpId =  $this.getCurrentlyLoggedInUser().id;
							}else{
								EmpId = frm.down('#employeeNameOrIdItemId').getValue();
							}
							gridStore.getProxy().extraParams = {	
								id: EmpId,
								fromDate:sDate,
								toDate:eDate,
								requesterId:requesterId
							};
							gridStore.load();
							grid.config.searchFilterForm = frm;
						}
					},

					'lmrequestspendingactionfilter radiogroup[itemId=selfOrOtherItemId]':{
						change:function(obj, newValue, oldValue, eOpts ){
							var $this = this;
							var frm = $this.getLmrequestspendingactionfilter();
							var emp = frm.down('#employeeNameOrIdItemId'); 
							var radioSelf = frm.down('#selfOrOtherItemId').items.items[0].value;
							//var radioOther = frm.down('#selfOrOtherItemId').items.items[1].value;
							if(radioSelf){
								emp.setDisabled(true);
							}else{
								emp.setDisabled(false);

							}

						}
					},
					'lmleaverequestpendingactiondetailwin form[itemId=lmLeaveRPAFormItemId] button[itemId=lmApproveButtonId]':{
						click: function() {
							this.reqPendingActionDetailBtnClick('APPROVED')
						}
					},
					'lmleaverequestpendingactiondetailwin form[itemId=lmLeaveRPAFormItemId] button[itemId=lmRejectButtonId]':{
						click: function() {
							this.reqPendingActionDetailBtnClick('REJECTED')
						}
					},
					'lmleaverequestpendingactiondetailwin form[itemId=lmLeaveRPAFormItemId] button[itemId=lmCancelButtonId]':{
						click: function() {
							var grid = this.getLmrequestspendingactiongrid();
							var win = this.getLmleaverequestpendingactiondetailwin();
							var record = grid.getSelectionModel().getSelection()[0];
							var form = win.down('#lmLeaveRPAFormItemId');
							var comment = form.down('#rpaCommentItemId').getValue();
							var leaveRequestId = record.data.hrLeaveReqId;
							
							var empLeaveRequest = new Object();
							empLeaveRequest.cancelFrom = new Date(record.get('fromDate'));
							empLeaveRequest.cancelTo = new Date(record.get('toDate'));
							empLeaveRequest.cancelReason = comment;
							empLeaveRequest.id = leaveRequestId;
							empLeaveRequest.isEventTrigger = false;
							empLeaveRequest = Ext.encode(empLeaveRequest);
							

							showConfirmMessage(getServiceRequestTranslation('CANCEL'),getPersonModuleTranslation('LMAS_LEAVE_CANCEL_CONFIRM_MESSAGE'),function(btn,text) {
								if (btn == 'yes') {
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_CANCEL_LEAVE,
										jsonData: empLeaveRequest,
										method: 'POST',
										success: function(frm, action) {
											$this.getLmrequestspendingactiongrid().getStore().load();
											win.close();
											Ext.getBody().unmask();
											showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), 'Your leaves have been cancelled successfully');
										}
									});
								}
							});
						
							
						}
					},
					'lmleaverequestpendingactiondetailwin grid[itemId=lmLeaveRequestPendingActionDetailGrid]':{
						cellclick:function(){
							var $this = this;
							var win = this.getLmleaverequestpendingactiondetailwin();
							var grid = win.down('#lmLeaveRequestPendingActionDetailGrid');
							var record = grid.getSelectionModel().getSelection()[0];
							var form = win.down('#lmLeaveRPAFormItemId');
							var approveBtn = form.down('#lmApproveButtonId');
							var rejectBtn = form.down('#lmRejectButtonId');
							var record = grid.getSelectionModel().getSelection()[0];
							var approverLevelId = record.data.approverLevelId;
							var approvalFlow = record.raw.approverType;
							var prevRecord;
							if(approvalFlow == 'SEQUENTIAL' && approverLevelId != 1) {
								var allRecord = record.store.data.items;
								for(var i=0; i<allRecord.length; i++) {
									if(allRecord[i].data.approverLevelId == approverLevelId-1) {
										prevRecord = allRecord[i].data;
										break;
									}
								}
								if(prevRecord.status == 'Approved' || prevRecord.status == 'Escalated') {
									this.reqPendingActionDetailBtnEnableDisable(approveBtn,rejectBtn,record);
								} else {
									approveBtn.setDisabled(true);
									rejectBtn.setDisabled(true);
								}
							}else  {
								this.reqPendingActionDetailBtnEnableDisable(approveBtn,rejectBtn,record);
							}
						}
					},
					'lmrequestspendingactionfilter button[itemId=resetRPAFilterItemId]':{
						click:function(){
							var $this = this;
							var frm = $this.getLmrequestspendingactionfilter();
							var emp = frm.down('#employeeNameOrIdItemId'); 
							var radioSelf = frm.down('#selfOrOtherItemId').items.items[0].value;
							//var radioOther = frm.down('#selfOrOtherItemId').items.items[1].value;
							frm.getForm().reset();

						}
					},
					'lmleavebalanceandapprovalflowgrid':{
						render: function(grid){
							var gridStore = grid.getStore();
							var structure = this.getLmleaverequesttabstructure();
							var academyLocationId = this.getCurrentAcademyLocation();
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							var empId;
							if(isSelf == true){
								empId = this.getCurrentlyLoggedInUser().id;
							} else {
								empCombo = structure.down('#employeeNameOrIdItemId');
								if(!isNullOrEmpty(empCombo.getValue())) {
									empId = empCombo.valueModels[0].data.id;
								} else {
									showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_SELECT_EMPLOYEE'));
								}
							}
							gridStore.getProxy().extraParams = {	
								id: empId,
								acadmeyLocId:academyLocationId
							};
							gridStore.load();
						}        	   
					},
					'lmapplyforleavestructure':{
						activate: function(structure) {
							this.checkApprovalConfigurationSetup();
							// this.loadLeaveTypeCombo();
						}
					},
					'lmleavebalanceandapprovalflowstructure':{
						activate: function(structure) {
							var structure = this.getLmleaverequesttabstructure();
							var grid = this.getLmleavebalanceandapprovalflowgrid();
							var academyLocationId = this.getCurrentAcademyLocation();
							var gridStore = grid.getStore();
							gridStore.removeAll();
							this.resetPageSetting(gridStore);
							var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
							var form = this.getLmapplyforleaveform();
							var userId = null;
							if(isSelf == true) {
								userId = this.getCurrentlyLoggedInUser().id;
								gridStore.getProxy().extraParams = {	
									id: userId,
									acadmeyLocId:academyLocationId
								};
								gridStore.load(); 
							}else{
								empCombo = structure.down('#employeeNameOrIdItemId');
								var empId = empCombo.getValue();
								if(!isNullOrEmpty(empCombo.getValue())) {
									userId = empId
									gridStore.getProxy().extraParams = {	
										id: userId,
										acadmeyLocId:academyLocationId
									};
									gridStore.load(); 
								}
							}
						}
					},
					'approvalsetupdownloadform customcombobox[itemId=lmAcademyLocationComboAS]':{
						select:function(combo) {
							var formPnl = combo.up('form');
							formPnl.down('#lmConfigStatusAS').setDisabled(false);
							formPnl.down('#lmUserGroupTypeAS').setDisabled(false);
							formPnl.down('#lmDesignationComboAS').setDisabled(false);
							formPnl.down('#lmDepartmentAS').setDisabled(false);
							if(formPnl.isValid()){
								Ext.defer(function() {
									formPnl.down('#downoladBtnIdAS').setDisabled(false);
								}, 100, this);
							};
						}
					},
					'approvalsetupdownloadform button[itemId=resetBtnAS]':{
						click:function(){
							var $this = this;
							var formPnl = $this.getApprovalsetupdownloadform();
							formPnl.down('#lmConfigStatusAS').setDisabled(true);
							formPnl.down('#lmUserGroupTypeAS').setDisabled(true);
							formPnl.down('#lmDesignationComboAS').setDisabled(true);
							formPnl.down('#lmDepartmentAS').setDisabled(true);
							formPnl.getForm().reset();
						}
					},
					'approvalsetupbulkimportstructure radiogroup[itemId=importBulkGroupIdAS]':{
						change: this.approvalSetupDownloadUploadRadioChange
					},
					'approvalsetupuploadform button[itemId=resetBtnASUpload]':{
						click:function(obj){
							var $this=this;
							var form = $this.getApprovalsetupuploadform().getForm();
							form.findField('file').reset();
							var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
							uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
								isUploadAll: false
							});
							form.isValid();
						},
						render: function(obj) {
							var $this = this;
							var form = obj.up('approvalsetupuploadform').getForm();
							var combo = form.findField('importUtilityMasterId');
							combo.getStore().load({
								callback: function(records, operation, success) {
									for (var i in records) {
										if (records[i].data.value == 'Bulk Approval Flow Update') {
											combo.setValue(records[i].data.id);
											combo.setReadOnly(true);
										}
									}
								}
							});
						}
					},
					'approvalsetupdownloadform[itemId=approvalsetupdownloadformItemId] button[itemId=downoladBtnIdAS]':{
						click:function(obj){
							var $this = this;
							var form =$this.getApprovalsetupdownloadform();
							var academyLocationId = form.down('#lmAcademyLocationComboAS').getValue();
							var configurationStatus = form.down('#lmConfigStatusAS').getValue();
							var userGroupType = form.down('#lmUserGroupTypeAS').getValue();
							var designation = form.down('#lmDesignationComboAS').getValue();
							var department = form.down('#lmDepartmentAS').getValue();
							var values = this.getApprovalSetupJson();

							var csvForm = Ext.create('Ext.form.Panel');
							csvForm.getForm().submit({
								target: '_blank',
								method:'POST',
								params :{
									access_token : Ext.Ajax.defaultHeaders.access_token,

									academyLocationId : academyLocationId,
									configurationStatus : configurationStatus,
									userGroupType : userGroupType,
									designation : designation,
									department : department
								},
								headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_BULK_APPROVAL_FLOW_UPDATE,
								standardSubmit :true,
								success : function(form, action){
									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
								},
								failure: function(form, action) {
									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
								}
							});
						}  
					},
					'approvalsetupuploadform uploadoptionradiogroup[itemId=approvalSetupUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
						change: function( radioGroup, newValue, oldValue, eOpts){
							var $this = this;
							var grid = $this.getImportlistapprovalflowupdategrid();
							var isUploadAll = newValue.isUploadAll;
							this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Approval Flow Update');
						}
					},
					'approvalsetupuploadform[itemId=approvalsetupuploadformItemId] button[itemId=approvalSetupUpload]' : {
						click : function(obj) {
							var $this = this;
							// var importWin = obj.up('assignremarkuploadform');
							var grdStore;
							var form = obj.up('approvalsetupuploadform');
							submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
							$this.getHashOfFile(form);
							setTimeout(function() {
								form.getForm().submit({
									method: 'POST',
									url: submitUrl,
									success: function(form, action) {
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
									},
									failure: function(form, action) {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
									}
								});
							},1000);

							Ext.defer(function() {
								var grid = $this.getImportlistapprovalflowupdategrid();
								var form  = $this.getUploadoptionradiogroup();
								var isUploadAll = form.items.items[0].getValue().isUploadAll;
								$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Approval Flow Update');
								/*grid.getStore().getProxy().extraParams = {
				                moduleName: 'Bulk Approval Flow Update'
				            };
				            grid.getStore().load();*/
							}, 2000, this);
						}
					},
					'importlistapprovalflowupdategrid' : {
						render : function() {
							var $this = this;
							var grid = $this.getImportlistapprovalflowupdategrid();
							var form  = $this.getUploadoptionradiogroup();
							var isUploadAll = form.items.items[0].getValue().isUploadAll;
							this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Approval Flow Update');
							/* grid.getStore().getProxy().extraParams = {
            			  moduleName: 'Bulk Approval Flow Update'
            		  };
            		  grid.getStore().load();*/
						},
						cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							if (e.target.tagName == 'A') {
								var fileType = null;
								if (cellIndex == 1) {
									fileType = 'successFile';
								} else if (cellIndex == 6) {
									fileType = 'errorFile';
								} else if (cellIndex == 7) {
									fileType = 'logFile';
								}
								var documentId = record.get("id");
								if (!isNullOrEmpty(documentId)) {
									this.getApprovalFlowUpdateDownloadFile(documentId, fileType);
								}
							}
						}
					},
					'importlistapprovalflowupdategrid button[itemId=btnForce]': {
						click: function(obj) {
							var grid = this.getImportlistapprovalflowupdategrid();
							if (grid.getSelectionModel().getCount() > 0) {
								if (grid.getSelectionModel().getCount() > 1) {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
								} else {
									var this$ = this;
									var id = grid.getSelectionModel().selectionStart.data.id;
									console.log(id);
									var urlAppend = "?jobName=" + id;
									var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
									Ext.Ajax.request({
										url: submitURL,
										method: 'GET',
										success: function(response) {
											if (response.responseText === "JOB_STATUS_NOT_PENDING") {
												showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
											} else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
												showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
											} else if (response.responseText === "SUCCESS") {
												showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
												grid.getStore().reload();
											}
										}
									});
								}
							} else {
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},
					'employeeleavebalanceupdatebulkimportstructure radiogroup[itemId=importBulkGroupIdAS]':{
						change: this.leaveBalanceUpdateDownloadUploadRadioChange
					},
					'employeeleavebalanceupdatedownloadform[itemId=employeeleavebalanceupdatedownloadformItemId] button[itemId=downoladBtnIdAS]':{
						click:function(obj){
							var $this = this;
							var form =$this.getEmployeeleavebalanceupdatedownloadform();
							var values = form.getValues();
							var dateOfJoiningFrom;
							var dateOfJoiningTO;
							if(!isNullOrEmpty(values.dateOfJoiningFrom)){
								dateOfJoiningFrom = Date.parse(values.dateOfJoiningFrom);
							}
							if(!isNullOrEmpty(values.dateOfJoiningTO)){
								var toDate = (values.dateOfJoiningTO).replace('00:00:00','23:59:59');
								dateOfJoiningTO = Date.parse(toDate);

							}
							var employeeStatus = null;
							if(!isNullOrEmpty(values.employeeStatus)){
								 employeeStatus = values.employeeStatus;
							}


							var csvForm = Ext.create('Ext.form.Panel');
							csvForm.getForm().submit({
								target: '_blank',
								method:'POST',
								params :{
									access_token : Ext.Ajax.defaultHeaders.access_token,
									academyLocationId : values.lmAcademyLocationComboAS,
									staffId : values.empId,
									userGroupId : values.userGroupId,
									designationId : values.designationId,
									departmentId : values.lmDepartment,
									gender : values.gender,
									dateOfJoiningFrom : dateOfJoiningFrom,
									dateOfJoiningTO : dateOfJoiningTO,
									status:employeeStatus
								},
								headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_BULK_EMPLOYEE_LEAVE_BALANCE_UPDATE,
								standardSubmit :true,
								success : function(form, action){
									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
								},
								failure: function(form, action) {
									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
								}
							});
						}  
					},
					'employeeleavebalanceupdatedownloadform button[itemId=resetBtnAS]':{
						click:function(){
							var form = this.getEmployeeleavebalanceupdatedownloadform();
							form.getForm().reset();
							var lmFromDateId = form.down('#fromDateItemId');
							lmFromDateId.setMaxValue(null);
							var lmToDateId = form.down('#toDateItemId');
							lmToDateId.setMinValue(null);
							var academyLocationId = this.getCurrentAcademyLocation(),
							lmEmpCombo = form.down('#empItemId'),
							lmDepartmentAS = form.down('#lmDepartmentAS'),
							lmDepartmentStore = lmDepartmentAS.getStore();
							var combo = form.down('#lmAcademyLocationComboAS'),
							store = combo.getStore();
							store.load({
								callback:function(){
									combo.setValue(academyLocationId);
									lmEmpCombo.getStore().getProxy().extraParams = {
										academyLocationIds: academyLocationId
									};
									lmDepartmentStore.getProxy().extraParams = {
										academyLocationsIds: academyLocationId
									};
									lmEmpCombo.getStore().load();
									lmDepartmentStore.load();
								}
							});
						}
					},
					'employeeleavebalanceupdateuploadform button[itemId=resetBtn]':{
						click:function(obj){
							var $this=this;
							var form = $this.getEmployeeleavebalanceupdateuploadform().getForm();
							form.findField('file').reset();
							var uploadoptionradiogroupform  = $this.getEmployeeleaveuploadoptionradiogroup();
							uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
								isUploadAll: false
							});
							form.isValid();
						},
						render: function(obj) {
							var $this = this;
							var form = obj.up('employeeleavebalanceupdateuploadform').getForm();
							var combo = form.findField('importUtilityMasterId');
							combo.getStore().load({
								callback: function(records, operation, success) {
									for (var i in records) {
										if (records[i].data.value == 'Bulk Employee Leave Balance') {
											combo.setValue(records[i].data.id);
											combo.setReadOnly(true);
										}
									}
								}
							});
						}
					},
					'employeeleavebalanceupdateuploadform uploadoptionradiogroup[itemId=employeeLeaveBalanceUpdateUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
						change: function( radioGroup, newValue, oldValue, eOpts){
							var $this = this;
							var grid = $this.getImportlistemployeeleavebalanceupdategrid();
							var isUploadAll = newValue.isUploadAll;
							this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Employee Leave Balance');
						}
					},
					'employeeleavebalanceupdateuploadform[itemId=employeeleavebalanceupdateuploadformItemId] button[itemId=employeeLeaveBalanceUpdateUpload]' : {
						click : function(obj) {
							var $this = this;
							// var importWin = obj.up('assignremarkuploadform');
							var grdStore;
							var form = obj.up('employeeleavebalanceupdateuploadform');
							submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
							$this.getHashOfFile(form);
							setTimeout(function() {
								form.getForm().submit({
									method: 'POST',
									url: submitUrl,
									success: function(form, action) {
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
									},
									failure: function(form, action) {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
									}
								});
							},1000);

							Ext.defer(function() {
								var grid = $this.getImportlistemployeeleavebalanceupdategrid();
								var form  = $this.getEmployeeleaveuploadoptionradiogroup();
								var isUploadAll = form.items.items[0].getValue().isUploadAll;
								$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Employee Leave Balance');
								/*grid.getStore().getProxy().extraParams = {
					                moduleName: 'Bulk Leave Balance'
					            };
					            grid.getStore().load();*/
							}, 2000, this);
						}
					},
					'importlistemployeeleavebalanceupdategrid' : {
						render : function() {
							var $this = this;
							var grid = $this.getImportlistemployeeleavebalanceupdategrid();
							var form  = $this.getEmployeeleaveuploadoptionradiogroup();
							var isUploadAll = form.items.items[0].getValue().isUploadAll;
							this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Employee Leave Balance');
							/* grid.getStore().getProxy().extraParams = {
	            			  moduleName: 'Bulk Leave Balance'
	            		  };
	            		  grid.getStore().load();*/
						},
						cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							if (e.target.tagName == 'A') {
								var fileType = null;
								if (cellIndex == 1) {
									fileType = 'successFile';
								} else if (cellIndex == 6) {
									fileType = 'errorFile';
								} else if (cellIndex == 7) {
									fileType = 'logFile';
								}
								var documentId = record.get("id");
								if (!isNullOrEmpty(documentId)) {
									this.getLeaveBalanceUpdateDownloadFile(documentId, fileType);
								}
							}
						}
					},
					'importlistemployeeleavebalanceupdategrid button[itemId=btnForce]': {
						click: function(obj) {
							var grid = this.getImportlistemployeeleavebalanceupdategrid();
							if (grid.getSelectionModel().getCount() > 0) {
								if (grid.getSelectionModel().getCount() > 1) {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
								} else {
									var this$ = this;
									var id = grid.getSelectionModel().selectionStart.data.id;
									console.log(id);
									var urlAppend = "?jobName=" + id;
									var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
									Ext.Ajax.request({
										url: submitURL,
										method: 'GET',
										success: function(response) {
											if (response.responseText === "JOB_STATUS_NOT_PENDING") {
												showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
											} else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
												showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
											} else if (response.responseText === "SUCCESS") {
												showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
												grid.getStore().reload();
											}
										}
									});
								}
							} else {
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},
					'employeeleavebalanceupdatedownloadform customcombobox[itemId=lmAcademyLocationComboAS]':{
						render:function(combo){
							var form =this.getEmployeeleavebalanceupdatedownloadform();
							var academyLocationId = this.getCurrentAcademyLocation(),
							lmEmpCombo = form.down('#empItemId'),
							lmDepartmentAS = form.down('#lmDepartmentAS'),
							store = combo.getStore(),
							lmDepartmentStore = lmDepartmentAS.getStore();
							store.getProxy().extraParams = {
								id: this.getCurrentlyLoggedInUser().id
							};
							store.load({
								callback:function(){
									combo.setValue(academyLocationId);
									lmEmpCombo.getStore().getProxy().extraParams = {
										academyLocationIds: academyLocationId
									};
									lmDepartmentStore.getProxy().extraParams = {
										academyLocationsIds: academyLocationId
									};
									lmEmpCombo.getStore().load();
									lmDepartmentStore.load();
								}
							});
						},
						select: function(combo, record) {
							var form =this.getEmployeeleavebalanceupdatedownloadform();
							lmEmpCombo = form.down('#empItemId'),
							lmDepartmentAS = form.down('#lmDepartmentAS'),
							store = lmEmpCombo.getStore(),
							lmDepartmentStore = lmDepartmentAS.getStore();
							lmEmpCombo.reset();
							lmDepartmentAS.reset();
							store.getProxy().extraParams = {
								academyLocationIds: combo.getValue()
							};
							lmDepartmentStore.getProxy().extraParams = {
								academyLocationsIds: combo.getValue()
							};
							store.load();
							lmDepartmentStore.load();
						}
					},
					'lmemployeeleavecancellationrequestdetailform button[itemId=btnSaveEmployeeLeaveCancellationForm]':{
						click:function(obj){
							this.leaveCancellationSaveBtnClick(obj);
						}
					},
					'lmemployeeleavecancellationrequestdetailform button[itemId=btnResetEmployeeLeaveCancellationForm]':{
						click:function(obj){
							var $this=this;
							var win = this.getLmemployeeleavecancellationrequestdetailwin();
							var form = win.down('#lmemployeeleavecancellationrequestdetailformItemId');
							form.down('#lmCancelFromDateId').reset();
							form.down('#lmCancelToDateId').reset();
							form.down('#leaveCancellationId').reset();
						}
					},
					'lmleaverequestpendingactiondetailwin':{
						render:function(win){
							var portalId = this.getCurrentLoggedPortalId();
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
							var permissionList;
							if(portalId == 1) {
								permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES());
							} else if(portalId == 2) {
								permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getLM_FP_REQUEST_PENDING_ACTION_PRIVILEGES());
							}
							var cancelBtn = win.down('#lmCancelButtonId');
							cancelBtn.setVisible(false);
							if(!isNullOrEmpty(permissionList)) {
								Ext.each(permissionList, function(privilege) {
									if (privilege === 'CANCEL') {
										if (!isNullOrEmpty(cancelBtn)) {
											cancelBtn.setVisible(true);
										}
									}
								});
							}
						}
					},
					'lmrequestactionhistoryfilter':{
						/*render:function(filter){
							var searchBtn=filter.down('#searchRPAFilterActionHistoryItemId');
							searchBtn.setDisabled(false);
						}*/
					},
					'lmrequestactionhistoryfilter button[itemId=searchRPAFilterActionHistoryItemId]': {
						click: function() {
							$this = this;
							var grid = $this.getLmrequestactionhistorygrid();
							var frm = $this.getLmrequestactionhistoryfilter();
							var gridStore = grid.getStore();
							//var staffId = $this.getCurrentlyLoggedInUser().id;

							var sDate = frm.down('#fromDateActionHistoryItemId').getValue();
							var eDate = frm.down('#toDateActionHistoryItemId').getValue();
							var requesterId = frm.down('#requesterNameOrIdActionHistoryItemId').getValue();
							var status = frm.down('#lmConfigStatusActionHistory').getValue();

							var EmpId = $this.getCurrentlyLoggedInUser().id;
							if(isNullOrEmpty(status)){
								status=null;
							}
							gridStore.getProxy().extraParams = {	
								id: EmpId,
								fromDate:sDate,
								toDate:eDate,
								requesterId:requesterId,
								status:status
							};
							gridStore.load();
							grid.config.searchFilterForm = frm;
						
							
						}
					},
					'lmrequestactionhistoryfilter button[itemId=resetRPAFilterActionHistoryItemId]': {
						click: function() {
							var $this = this;
							var frm = $this.getLmrequestactionhistoryfilter();
							frm.getForm().reset();
							var fromDate=frm.down('#fromDateActionHistoryItemId');
							var toDate=frm.down('#toDateActionHistoryItemId');
							fromDate.setMaxValue(false);
							toDate.setMinValue(false);
						}
					},
					'lmrequestactionhistorygrid ': {
						render: function(grid){
							/*var portalId = this.getCurrentLoggedPortalId();
							if(portalId == 1) {
								this.doAccessControlValidation(grid, this.getLM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES());
							} else if(portalId == 2) {
								this.doAccessControlValidation(grid, this.getLM_FP_REQUEST_PENDING_ACTION_PRIVILEGES());
							}*/
							var $this = this;
							var EmpId = $this.getCurrentlyLoggedInUser().id;
							var gridStore=grid.getStore();
							gridStore.getProxy().extraParams = {	
								id: EmpId,
								status:null
							};
							gridStore.reload();
						},
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(e.target.tagName == 'A'){
								if(columnName == "document") {
									var documentId = record.raw.document.encryptedDocId;
									if(!isNullOrEmpty(documentId)){
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								} else if(columnName == "hrLeaveReqId"){
									var record = grid.getSelectionModel().getSelection()[0];
									var rpaDetailWin = $this.getLmleaverequestpendingactiondetailwin();
									if(isNullOrEmpty(rpaDetailWin)){
										Ext.widget('lmleaverequestpendingactiondetailwin');
										rpaDetailWin = $this.getLmleaverequestpendingactiondetailwin();
									}
									var empReqDetailGrid = rpaDetailWin.down('#lmLeaveRequestPendingActionDetailGrid');
									this.openEmpLeaveReqDetailWin(record,rpaDetailWin,empReqDetailGrid);
									var approveBtn=rpaDetailWin.down('#lmApproveButtonId');
									var rejectBtn=rpaDetailWin.down('#lmRejectButtonId');
									var cancelBtn=rpaDetailWin.down('#lmCancelButtonId');
									var approverComment=rpaDetailWin.down('#rpaCommentItemId');
									approveBtn.setVisible(false);
									rejectBtn.setVisible(false);
									cancelBtn.setVisible(false);
									approverComment.setVisible(false);
								}
							}/* else{
								var $this = this;
								Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
								var formWindow = $this.getLmemployeepastleaverequestdetailwin();
								if (!formWindow) {
									Ext.widget('lmemployeepastleaverequestdetailwin');
									formWindow = $this.getLmemployeepastleaverequestdetailwin();
								}
								toggleReadOnlyFormItems(formWindow.down('#lmemployeepastleaverequestdetailformItemId').getForm(), true);
								var lmLeaveTypeCombo = formWindow.down('#lmLeaveTypeId')
								var eligibilityCriteriaVal = record.raw.eligibilityCriteria;
								Ext.getBody().unmask();
								if(!isNullOrEmpty(eligibilityCriteriaVal) && eligibilityCriteriaVal == 'COMPENSATORY'){
									formWindow.show();
									$this.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
									formWindow.down('#lmFromDateId').setVisible(false);
									formWindow.down('#lmToDateId').setVisible(false);
									//formWindow.down('#isHalfDayStart').setVisible(false);
									//formWindow.down('#isHalfDayEnd').setVisible(false);
									lmLeaveTypeCombo.setValue(record.data.hrLeaveTypeIDCode.value);
									formWindow.down('#lmClaimDateItemId').setVisible(true);
									formWindow.down('#lmClaimDateItemId').setValue(dateRender(record.raw.claimDate));
									formWindow.down('#lmLeaveRequireOnDateItemId').setVisible(true);
									formWindow.down('#lmLeaveRequireOnDateItemId').setValue(dateRender(record.raw.leaveRequireOnDate));

								} else {
									formWindow.show();
									$this.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
									lmLeaveTypeCombo.setValue(record.data.hrLeaveTypeIDCode.value);
									formWindow.down('#lmFromDateId').setVisible(true);
									formWindow.down('#lmToDateId').setVisible(true);
									//formWindow.down('#isHalfDayStart').setVisible(true);
								//	formWindow.down('#isHalfDayEnd').setVisible(true);
									formWindow.down('#lmFromDateId').setValue(dateRender(record.raw.fromDate));
									formWindow.down('#lmToDateId').setValue(dateRender(record.raw.toDate));
									//formWindow.down('#isHalfDayStart').setValue(record.raw.isHalfDayStart);
									formWindow.down('#isHalfDayEnd').setValue(record.raw.isHalfDayEnd);
									formWindow.down('#lmClaimDateItemId').setVisible(false);
									formWindow.down('#lmLeaveRequireOnDateItemId').setVisible(false);
								}
								if(! isNullOrEmpty(record.raw.document) && ! isNullOrEmpty(record.raw.document)) {
									formWindow.down('#lmDocumentNameItemId').setValue(record.raw.document.name);
								}
								formWindow.down('#leaveReasonId').setValue(record.raw.reason);
								formWindow.down('#employeeNames').getStore().load({
									callback:function(){
										if(!isNullOrEmpty(record.raw.alternateEmpNames)) {
        		        				var alternateEmployees = record.raw.alternateEmpNames.split(',');
            		        			formWindow.down('#employeeNames').setValue(alternateEmployees);
            		        			formWindow.down('#employeeNames').inputEl.dom.style.height="110px";
        		        			}
										if(!isNullOrEmpty(record.raw.alternateEmployeeIds)) {
											formWindow.down('#employeeNames').setValue(record.raw.alternateEmployeeIds);
											formWindow.down('#employeeNames').inputEl.dom.style.height="110px";
										}
										if (formWindow.down('#employeeNames') != null) {
											formWindow.down('#employeeNames').setHeight('auto');
										}
										formWindow.down('#employeeNames').el.dom.style.height = 'auto';
										$this.hideWindowMask();
									}
								});

							}*/
						}
					},
					'lmemployeeleaverequeststructure':{
						render:function(structure){
							this.disableActionHistoryTab(structure, this.getFP_REQUEST_ACTION_HISTORY_PRIVILEGES());
						}
					}
				});
			},
			loadAcadLocCombo: function(combo) {
				var store = combo.getStore();
				store.getProxy().extraParams = {
					id: this.getCurrentlyLoggedInUser().id
				};

			},
			/** Disable View/Configure Privileges button */
			disableMoreActionPivileges: function(gridReference, permissionsMap) {

				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

				var btnViewConfigure = gridReference.down('#viewConfigureBtnId');
				btnViewConfigure.setVisible(false);
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'VIEWCONFIGURE') {
						if (!isNullOrEmpty(btnViewConfigure)) {
							btnViewConfigure.setVisible(true);
						}
					}
				});
			},
			checkWhetherLeaveApplicableOrNot : function() {
				var $this = this;
				var form = $this.getLmapprovalsetupfilter();
				var facultyCode = form.down("#lmFacultyCodeItemId").getValue();
				if(!isNullOrEmpty(facultyCode)) {
					Ext.Ajax.request({
						type : 'rest',
						url :SERVERURL.VALIDATE_EMPLOYEE_ID,
						params : {
							userCode : facultyCode,
						},
						method : 'GET',
						success : function(records, action) {
							var user = Ext.decode(records.responseText)
							if(user.whetherLeaveApplicable == false) {
								showWarningMessage(getPersonModuleTranslation('LMAS_LEAVE_APPROVAL_SETUP'), getPersonModuleTranslation('LMAS_LEAVE_APPLICABLE_MSG'));
							} else {
								$this.loadApprovalSetupGrid();
							}
						}
					}); 
				}
			},
			/*Search btn fuctionality*/
			loadApprovalSetupGrid: function() {
				var $this = this;
				var form = $this.getLmapprovalsetupfilter();

				var facultyCode = form.down("#lmFacultyCodeItemId").getValue();
				var facultyId = null;
				if(!isNullOrEmpty(facultyCode)) {
					facultyId = form.down("#lmFacultyCodeItemId").valueModels[0].data.id;
				}
				var groupType = form.down("#lmUserGroupType").getValue();
				var academyLoc = form.down("#lmAcademyLocationCombo").getValue();
				var configStatus = form.down("#lmConfigStatus").getValue();
				var department = form.down("#lmDepartment").getValue();
				var designation = form.down("#lmDesignationCombo").getValue();        
				var gender = form.down("#lmGender").getValue();
				var joiningFromDate = form.down("#joiningDateFrom").getValue();
				var joiningToDate = form.down("#joiningDateTo").getValue();
				var approvalFlowTyp = form.down("#lmApprovalFlow").getValue();

				var grid = $this.getLmapprovalsetupgrid();
				var buttonsToolBar = grid.query('toolbar')[0];
				var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
				var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];

				var store = grid.getStore();
				grid.getSelectionModel().deselectAll();
				store.getProxy().extraParams = {
					codeOrName : facultyCode,
					userIds : facultyId,
					userGroupType : groupType,
					academyLocationId : academyLoc,
					configurationStatus : configStatus,
					department : department,
					designation: designation,
					gender : gender,
					joiningFromDate : joiningFromDate,
					joiningToDate : joiningToDate,
					approvalType : approvalFlowTyp
				};
				store.loadPage(1);     
				grid.getStore().load({
					callback: function(records, operation, success) {
						if(records.length>0){
							pdftoolbar.setDisabled(false);
							exceltoolbar.setDisabled(false);
						}
					}
				});
				/*pdf & excel report header filter*/
				grid.config.searchFilterForm = form;

			},

			/*Reset btn fuctionality*/
			resetApprovalSetupfilter: function(){
				var form = this.getLmapprovalsetupfilter();
				form.getForm().reset();
			},

			/*open configuration structure tab for add leave*/
			openConfiguretabstructure: function(button,lmApprovalSetupGrid, record){
				var me = this;
				var grid = null;
				if(lmApprovalSetupGrid){
					grid = lmApprovalSetupGrid;
				}else{
					var grid = button.up('grid');
				}

				var getcontroller = this.getController('menu.CoreERPNavigationController');
				var getTab = getcontroller.getTab(getPersonModuleTranslation('LMAS_APPROVAL_FLOW_CONFIGURATION'));
				contentPanel.remove(getTab, true);
				if(grid.getSelectionModel().getCount()>0) {
					var contentpanel = this.getContentpanel();
					var configStructureTab = Ext.widget('lmapprovalsetupconfiguretabstructure');
					var tabName = getPersonModuleTranslation('LMAS_APPROVAL_FLOW_CONFIGURATION');
					openTab(contentpanel, tabName, configStructureTab, CONSTANTS.MENU_COLOR_EIGHT);
					setTimeout(function(){
						me.loadDataInGrid(record);
					},300);
				}else if(record.data.id){
					var contentpanel = this.getContentpanel();
					var configStructureTab = Ext.widget('lmapprovalsetupconfiguretabstructure');
					var tabName = getPersonModuleTranslation('LMAS_APPROVAL_FLOW_CONFIGURATION');
					openTab(contentpanel, tabName, configStructureTab, CONSTANTS.MENU_COLOR_EIGHT);
					setTimeout(function(){
						me.loadDataInGrid(record);
					},300);    		
				}else {
					showWarningMessage(getAdmissionTranslation('CONFIGURE_COMBINATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
				//var tabReference = this.addTab(getPersonModuleTranslation('LM_APPROVAL_FLOW_CONFIGURATION'), 'lmapprovalsetupconfiguretabstructure');
			},


			loadDataInGrid: function(selectedRecord){
				var $this = this;
				var grid = $this.getLmapprovalconfigresetupgrid();
				//var configurationDetailgrid = $this.getLmapprovalsetupgrid();
				var staffids = [];
				//var selectedRecord = configurationDetailgrid.getSelectionModel().getSelection();
				if(selectedRecord.length > 0){
					for(i in selectedRecord){
						staffids.push(selectedRecord[i].data.id);    		    		
					}
				}else{
					staffids.push(selectedRecord.data.id);
				}

				//var configurationSetupGird = $this.getLmapprovalconfigresetupgrid();
				var gridStore = grid.getStore();

				gridStore.getProxy().extraParams = {
					userIds : staffids.join(),
				};
				gridStore.load(); 
				/*setTimeout(function(){ 
    		grid.getSelectionModel().selectAll(); 
    	}, 500);*/
			}, 

			/*save Approval leave configuration*/
			saveApprovalConfiguration: function(button){
				var me = this;
				var grid = me.getLmapprovalconfigresetupgrid();
				var form = me.getLmapprovalconfigresetupform();
				var configDetailGrid = me.getLmapprovalsetupgrid();

				var userIds = [];
				if(grid.getSelectionModel().getCount()>0) {
					//var models = grid.getStore().getRange();
					var models = grid.getSelectionModel().getSelection();

					Ext.each(models, function(model) {
						userIds.push (model.data.id);
					});
				}else {
					showWarningMessage(getAdmissionTranslation('CONFIGURE_COMBINATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}	

				var levelCombo1 = form.down('#userApprovalLevel1');
				var levelCombo2 = form.down('#userApprovalLevel2');
				var levelCombo3 = form.down('#userApprovalLevel3');
				var levelCombo4 = form.down('#userApprovalLevel4');
				var slaDayField = form.down('#slaDayId');
				var approvalTyp = form.down('#approvalType');

				var approverIdMap = new Ext.util.HashMap();
				if(!isNullOrEmpty(levelCombo1.getValue())){
					approverIdMap.add(1, levelCombo1.getValue());  				
				}
				if(!isNullOrEmpty(levelCombo2.getValue())){
					approverIdMap.add(2, levelCombo2.getValue());  				
				}
				if(!isNullOrEmpty(levelCombo3.getValue())){
					approverIdMap.add(3, levelCombo3.getValue());  				
				}
				if(!isNullOrEmpty(levelCombo4.getValue())){
					approverIdMap.add(4, levelCombo4.getValue());  				
				}
				/*if (approverIdMap.getCount() > 0) {

    	} else {
    		// TODO Error msg
    	}*/

				var myJsonArray = [];
				var approvalConfigModel = null;
				if(approvalTyp.getValue().approvalTypeName == 'AUTO_APPROVE'){

					Ext.each(userIds, function(userId) {
						approvalConfigModel = new Academia.model.leavemanagement.leaveapprovalsetup.LMApprovalConfigurationSetupModel();
						var user = {
								id: userId
						}
						approvalConfigModel.set('user', user);
						approvalConfigModel.set('approver', null);
						approvalConfigModel.set('approverType', approvalTyp.getValue().approvalTypeName);

						myJsonArray.push(approvalConfigModel.data);
					});

					//console.log('myJsonArray : ' + myJsonArray);
					if(myJsonArray.length > 0){
						var formData = Ext.encode(myJsonArray);
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.LMAS_LEAVE_APPROVAL_CONFIGURATION_UPDATE,
							jsonData: formData,
							method: 'POST',
							success: function(frm, action) {
								var data = frm.responseText;
								Ext.getBody().unmask();
								//$this.loadAttendanceWiseGrid();
								showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('LMAS_APPROVAL_CONFIGURATION_SUCCESSFULLY'));
								var getcontroller = me.getController('menu.CoreERPNavigationController');
								var getTab = getcontroller.getTab(getPersonModuleTranslation('LMAS_APPROVAL_FLOW_CONFIGURATION'));
								contentPanel.remove(getTab, true);
								configDetailGrid.getSelectionModel().deselectAll();
								configDetailGrid.getStore().load();
							}
						});
					}  

				}else{
					Ext.each(userIds, function(userId) {
						approverIdMap.each(function(key, value, length){
							approvalConfigModel = new Academia.model.leavemanagement.leaveapprovalsetup.LMApprovalConfigurationSetupModel();

							var user = {
									id: userId
							}    			
							var approver = {
									id: value
							}
							var sladay = slaDayField.getValue();
							approvalConfigModel.set('user', user);
							approvalConfigModel.set('levelId', key);
							approvalConfigModel.set('approver', approver);
							approvalConfigModel.set('approverType', approvalTyp.getValue().approvalTypeName);
							if(!isNullOrEmpty(sladay)){
								approvalConfigModel.set('slaDays',sladay);
							}

							myJsonArray.push(approvalConfigModel.data);
						});
					});
					//approvalConfigModel.userIdForDelete = userIds; // user id for delete previous data
					console.log('myJsonArray : ' + myJsonArray);
					if(myJsonArray.length > 0){
						var formData = Ext.encode(myJsonArray);
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.LMAS_LEAVE_APPROVAL_CONFIGURATION_UPDATE,
							jsonData: formData,
							method: 'POST',
							success: function(frm, action) {
								var data = frm.responseText;
								Ext.getBody().unmask();
								//$this.loadAttendanceWiseGrid();
								showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('LMAS_APPROVAL_CONFIGURATION_SUCCESSFULLY'));
								var getcontroller = me.getController('menu.CoreERPNavigationController');
								var getTab = getcontroller.getTab(getPersonModuleTranslation('LMAS_APPROVAL_FLOW_CONFIGURATION'));
								contentPanel.remove(getTab, true);
								configDetailGrid.getSelectionModel().deselectAll();
								configDetailGrid.getStore().load();
							}
						});
					}    		
				}

			},
			approvalTypeChange: function(o,n){
				var me = this;
				var form = me.getLmapprovalconfigresetupform();
				var levelCombo1 = form.down('#userApprovalLevel1');
				var levelCombo2 = form.down('#userApprovalLevel2');
				var levelCombo3 = form.down('#userApprovalLevel3');
				var levelCombo4 = form.down('#userApprovalLevel4');
				var slaDayField = form.down('#slaDayId');
				var levelField = form.down('#ApprovalLevelsId');
				if(n.approvalTypeName == 'SEQUENTIAL'){
					levelCombo1.reset();
					levelCombo2.reset();
					levelCombo3.reset();
					levelCombo4.reset();

					levelCombo2.setDisabled(true);
					levelCombo3.setDisabled(true);
					levelCombo4.setDisabled(true);

					levelCombo1.allowBlank = false;
					levelCombo2.allowBlank = true;
					levelCombo3.allowBlank = true;
					levelCombo4.allowBlank = true;
					slaDayField.allowBlank = true;

					levelCombo1.setVisible(true);
					levelCombo2.setVisible(true);
					levelCombo3.setVisible(true);
					levelCombo4.setVisible(true);
					levelField.setVisible(true);
					slaDayField.setVisible(true);

				}else if(n.approvalTypeName == 'PARALLEL'){
					levelCombo1.reset();
					levelCombo2.reset();
					levelCombo3.reset();
					levelCombo4.reset();

					levelCombo1.allowBlank = false;
					levelCombo2.allowBlank = true;
					levelCombo3.allowBlank = true;
					levelCombo4.allowBlank = true;
					slaDayField.allowBlank = true;

					levelCombo1.setVisible(true);
					levelCombo2.setVisible(true);
					levelCombo3.setVisible(true);
					levelCombo4.setVisible(true);
					levelField.setVisible(true);

					levelCombo2.setDisabled(true);
					levelCombo3.setDisabled(true);
					levelCombo4.setDisabled(true);
					slaDayField.setVisible(true);

				}else if(n.approvalTypeName == 'AUTO_APPROVE'){
					levelCombo1.reset();
					levelCombo2.reset();
					levelCombo3.reset();
					levelCombo4.reset();

					levelCombo1.allowBlank = true;
					levelCombo2.allowBlank = true;
					levelCombo3.allowBlank = true;
					levelCombo4.allowBlank = true;
					slaDayField.allowBlank = true;

					levelCombo1.setVisible(false);
					levelCombo2.setVisible(false);
					levelCombo3.setVisible(false);
					levelCombo4.setVisible(false);
					levelField.setVisible(false);
					slaDayField.setVisible(false);

				}    	
				form.isValid();    	
			},
			setValueOnApprovalConfigreSetupForm: function(grid,record,selRecords){
				var me = this;
				var form = me.getLmapprovalconfigresetupform();
				var approvalTypeRadio = form.down('#approvalType');
				var levelField = form.down('#ApprovalLevelsId');
				var levelCombo1 = form.down('#userApprovalLevel1');
				var levelCombo2 = form.down('#userApprovalLevel2');
				var levelCombo3 = form.down('#userApprovalLevel3');
				var levelCombo4 = form.down('#userApprovalLevel4');
				var slaDayField = form.down('#slaDayId');

				//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type : 'rest',
					url :SERVERURL.PATH_LMAS_APPROVAL_TYPE_BY_USER_ID,
					params : {
						userId : record.data.id,
						configureStatus : record.data.configurationstatus
					},
					method : 'GET',
					success : function(form, action) {
						var data = form.responseText;
						var approvalData = Ext.decode(data);
						//Ext.getBody().unmask();
						slaDayField.reset();
						levelCombo1.reset();
						levelCombo2.reset();
						levelCombo3.reset();
						levelCombo4.reset();
						approvalTypeRadio.reset();
						levelCombo2.setDisabled(true);
						levelCombo3.setDisabled(true);
						levelCombo4.setDisabled(true);				
						if(approvalData.length>0){
							if(!isNullOrEmpty(approvalData[0].slaDays)){
								slaDayField.setValue(approvalData[0].slaDays);    					
							}    				
						}    			
						/*set approval type radio btn*/
						if(Ext.isDefined(approvalData[0])){
							if(approvalData[0].approverType == 'SEQUENTIAL'){
								approvalTypeRadio.items.items[0].setValue(true);
							}else if(approvalData[0].approverType == 'PARALLEL'){
								approvalTypeRadio.items.items[1].setValue(true);  
							}else if(approvalData[0].approverType == 'AUTO_APPROVE'){
								approvalTypeRadio.items.items[2].setValue(true);    			
							}    				
						}    			

						var allLevelComboStore = levelCombo1.getStore();
						allLevelComboStore.load({
							callback : function(records,operation,success) {    					
								for(j in approvalData){
									if(approvalData[j].levelId == 1){
										levelCombo1.setValue(approvalData[j].approver.id);
										levelCombo2.setDisabled(false);
									}
									else if(approvalData[j].levelId == 2){
										levelCombo2.setValue(approvalData[j].approver.id);
										levelCombo3.setDisabled(false);
									}
									else if(approvalData[j].levelId == 3){
										levelCombo3.setValue(approvalData[j].approver.id);
										levelCombo4.setDisabled(false);
									}
									else if(approvalData[j].levelId == 4){
										levelCombo4.setValue(approvalData[j].approver.id);
									}
								}
							}
						});
					}
				});   	
			},
			loadDataForRequester: function(isSelf,empId) {
				var this$=this;
				var submitURL; 
				if(isSelf) {
					var userId = this.getCurrentlyLoggedInUser().id;
					submitURL = SERVERURL.SG_PATH_FIND_STAFF_INFO_BY_USERID+"?userId="+userId;
				} else {
					submitURL = SERVERURL.SG_PATH_FIND_STAFF_INFO_BY_USERID+"?userId="+empId;
				}
				Ext.Ajax.request({
					type: 'rest',
					url: submitURL,
					method: 'GET',
					success: function(record) {
						var data =data= Ext.decode(record.responseText);
						var structure = this$.getLmleaverequesttabstructure();
						structure.down('#empNameTxtId').setValue(data.nameToBePrinted);
						structure.down('#empDesignationId').setValue(data.designation);
						structure.down('#empDepartmentId').setValue(data.department);
						structure.down('#empSubDepartmentId').setValue(data.subDepartment);
						structure.down('#empEmailId').setValue(data.emailId);
						structure.down('#empMobileId').setValue(data.mobileNumber);
						this$.loadLeaveBalanceAndApprovalLevel(data);
					}
				});
			},
			loadPastLeaveRequest:function(userId, from, to, status,form) {
				var structure = this.getLmleaverequesttabstructure();
				if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmpastleaverequeststructure') {
					var grid = this.getLmpastleaverequestgrid();
					var store = grid.getStore();
					store.removeAll();
					this.resetPageSetting(store);
					//Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					store.getProxy().extraParams = {
						id: userId,
						from:from,
						to: to,
						status: status
					};
					store.load({
						callback : function(records,operation,success) { 
							//var dockedItemsItemId = grid.down('#lmDockedItemId');
							//dockedItemsItemId.setVisible(true);
							Ext.getBody().unmask();
						}});
					grid.config.searchFilterForm = form;
				}else if(structure.down('#enquirytabpanel').getActiveTab().getXType() == 'lmleavebalanceandapprovalflowstructure'){
					var grid = this.getLmleavebalanceandapprovalflowgrid();
					var academyLocationId = this.getCurrentAcademyLocation();
					var gridStore = grid.getStore();
					gridStore.getProxy().extraParams = {	
						id: userId,
						acadmeyLocId:academyLocationId
					};
					gridStore.load();
				}
			},
			openEmpLeaveReqDetailWin: function(record,formWindow,empReqDetailGrid) {
				var $this =this;
				var reqId; 
				var fromDate =  new Date(record.get('fromDate'));
				var currentDate = new Date().setHours(0,0,0,0);
				currentDate = new Date(currentDate);
				if(formWindow.xtype == 'lmleaverequestpendingactiondetailwin') {
					if(this.getCurrentLoggedPortalId() == 1) {
						formWindow.down('#lmCancelButtonId').setVisible(true)
						if(currentDate<=fromDate) {
							formWindow.down('#lmCancelButtonId').setDisabled(false)
						} else {
							formWindow.down('#lmCancelButtonId').setDisabled(true)
						}
					} else {
						formWindow.down('#lmCancelButtonId').setVisible(false)
					}
				}
				if(!isNullOrEmpty(record.data.id))
				{
					reqId = record.data.id;
				} else {
					reqId = record.data.hrLeaveReqId;
				}
				var store = empReqDetailGrid.getStore();

				store.getProxy().extraParams = {
					requestId: reqId
				};
				store.load({
					callback : function(records,operation,success) { 
						var approverFlow;
						if(!isNullOrEmpty($this.getLmleaverequestpendingactiondetailwin())) {
							approverFlow = $this.getLmleaverequestpendingactiondetailwin().down('#approvalFlowItemId');
						} else {
							approverFlow = $this.getLmemployeeleaverequestdetailwin().down('#approvalFlowItemId');
						}
						if(records.length > 0) {
							if(records[0].raw.approverType == 'SEQUENTIAL') {
								approverFlow.setValue('Sequential');
							}else if(records[0].raw.approverType == 'PARALLEL'){
								approverFlow.setValue('Parallel');
							}
						} else {
							approverFlow.setValue('Auto Approve');
						}
					}});
				formWindow.show();
			},
			resetLeaveApplyForm : function() {
				var form = this.getLmapplyforleaveform();
				form.down('#lmClaimDateItemId').reset();
				form.down('#lmLeaveRequireOnDateItemId').reset();
				form.down('#lmClaimDateItemId').setVisible(false);
				form.down('#lmLeaveRequireOnDateItemId').setVisible(false);
				form.down('#lmLeaveTypeId').reset();  
				form.down('#lmFromDateId').setMaxValue(false);
				form.down('#lmFromDateId').reset();
				form.down('#lmToDateId').setMinValue(false);
				form.down('#lmToDateId').reset();
				form.down('#leaveReasonId').reset();
				form.down('#uploadFileField').reset();
				form.down('#leaveCategory').reset();
				form.down('#leaveCategory2').reset();
				form.down('#leaveCategory3').reset();
				form.down('#leaveCounter').reset();
				form.down('#leaveCategory').setVisible(false); 
				form.down('#leaveCategory2').setVisible(false); 
				form.down('#leaveCategory3').setVisible(false); 
				form.down('#leaveCounter2').setValue('');
				form.down('#leaveCounter1').setValue('');
				form.down('#lmRequestDateId').setValue(dateRender(new Date()));
				var empCombo = form.down('#employeeNames');
				empCombo.reset();
				var contentPanel = Ext.ComponentQuery.query('contentPanel');
				if (contentPanel.length == 1) {
					var x = contentPanel[0].getActiveTab();
					if (x.getXType() == 'lmemployeeleaverequeststructure' && empCombo.el) {
						var a = empCombo.el.down('[name=employeeNames]');
						if (a != null) {
							a.setHeight('auto');
						}
						empCombo.el.dom.style.height = 'auto';
						empCombo.up('form').doLayout();
					}
				}
			},
			reqPendingActionDetailBtnEnableDisable : function(approveBtn,rejectBtn,record) {
				var reqpendingfilter = this.getLmrequestspendingactionfilter();
				var isSelf = reqpendingfilter.down('#selfOrOtherItemId').getValue().isSelf;
				var approverId;
				if(isSelf == true) {
					approverId = this.getCurrentlyLoggedInUser().id;
				} else {
					approverId = reqpendingfilter.down('#employeeNameOrIdItemId').getValue();
				}
				if(record.data.reqApprover.id == approverId) {
					if(record.data.status == 'Pending') {
						approveBtn.setDisabled(false);
						rejectBtn.setDisabled(false);
					}
				} else {
					approveBtn.setDisabled(true);
					rejectBtn.setDisabled(true);
				}
			},
			reqPendingActionDetailBtnClick : function(approveOrReject) {
				var $this=this;
				var win = this.getLmleaverequestpendingactiondetailwin();
				var grid = win.down('#lmLeaveRequestPendingActionDetailGrid');
				var form = win.down('#lmLeaveRPAFormItemId');
				var record = grid.getSelectionModel().getSelection()[0];
				var approverLevelId = record.data.approverLevelId;
				var allRecord = record.store.data.items;
				var comment = form.down('#rpaCommentItemId').getValue();
				var empLeaveRequest = record.raw;
				if(!isNullOrEmpty(comment)) {
					empLeaveRequest.comment = comment;
				}
				empLeaveRequest.status = approveOrReject;
				if(approveOrReject == 'APPROVED') {
					var flag = true;
					for(var i=0; i<allRecord.length; i++) {
						if(allRecord[i].data.approverLevelId != approverLevelId && allRecord[i].data.status == 'Pending') {
							flag = false;
							break;
						}
					}
					if(flag == true) {
						empLeaveRequest.parentStatus = 'APPROVED';
					}
				}else {
					empLeaveRequest.parentStatus = 'REJECTED';
				}
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.HR_EMP_LEAVE_REQUEST_DETAILS_UPDATE,
					jsonData: empLeaveRequest,
					method: 'POST',
					success: function(frm, action) {
						var data = frm.responseText;
						if(action.jsonData.status == 'APPROVED'){
							showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_LEAVE_APPROVED'));
						}else if(action.jsonData.status == 'REJECTED') {
							showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_LEAVE_REJECTED'));
						} else {
							showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('SUCCESS'));
						}

						$this.getLmrequestspendingactiongrid().getStore().load();
						win.close();
						Ext.getBody().unmask();
					}
				});
			},
			loadLeaveTypeCombo : function() {
				var structure = this.getLmleaverequesttabstructure();
				var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
				var form = this.getLmapplyforleaveform(); 
				 var leavefromDate=form.down("#lmFromDateId");
				if(isSelf == true) {
					var userId = this.getCurrentlyLoggedInUser().id;
					var leaveTypeStore = form.down('#lmLeaveTypeId').getStore();
					leaveTypeStore.getProxy().extraParams={
						eligibilityCriteria:'GENERIC',
						userId:userId
					};
					
				} else {
					empCombo = structure.down('#employeeNameOrIdItemId');
					var userId = empCombo.getValue();
					if(!isNullOrEmpty(empCombo.getValue())) {
						var leaveTypeStore = form.down('#lmLeaveTypeId').getStore();
						leaveTypeStore.getProxy().extraParams={
							eligibilityCriteria:'GENERIC',
							userId:userId
						};
						
					}
				}
			},

			loadLeaveBalanceAndApprovalLevel : function(data){
				//var structure=Ext.ComponentQuery.query('lmleavebalanceandapprovalflowstructure')[0]
				//var levelPanel = structure.down('lmmyapprovalflowpanel');
				var structure=this.getLmleaverequesttabstructure(),
				levelPanel = structure.down('#lmmyapprovalflowpnl');

				var level1 = '',
				level2 = '';
				level3 = '',
				level4 = '';

				if(isNullOrEmpty(data.level1)){
					level1 = "NA";
				}else{
					level1 = data.level1;
				}if(isNullOrEmpty(data.level2)){
					level2 = "NA";
				}else{
					level2 = data.level2;
				}if(isNullOrEmpty(data.level3)){
					level3 = "NA";
				}else{
					level3 = data.level3;
				}if(isNullOrEmpty(data.level4)){
					level4 = "NA";
				}else{
					level4 = data.level4;
				}

				var fcLevelGridHtml = levelPanel.down('#fcLevelGridHtml');

				fcLevelGridHtml.getEl().setHTML('<table style="border:1px solid black; width: 100%;"><tr><th style="width:100px;color: #fff;border:1px solid black;background-color: #626567">'+getPersonModuleTranslation('LEVEL1')+'</th><th style="width:100px;color: #fff;border:1px solid black;background-color: #626567">'+getPersonModuleTranslation('LEVEL2')+'</th><th style="width:100px;color: #fff;border:1px solid black;background-color: #626567">'+getPersonModuleTranslation('LEVEL3')+'</th><th style="width:100px;color: #fff;border:1px solid black;background-color: #626567">'+getPersonModuleTranslation('LEVEL4')+'</th></tr><tr><td style="width:100px;text-align:center;border: 1px solid #000;">'+ level1 +'</td><td style="width:100px;text-align:center;border: 1px solid #000;">'+ level2 +'</td><td style="width:100px;text-align:center;border: 1px solid #000;">'+ level3 +'</td><td style="width:100px;text-align:center;border: 1px solid #000;">'+ level4 +'</td></tr></table>');
				var approverType = levelPanel.down('#lmLeaveRequestApprovalTypeId');
				if(data.approverType == 'Auto_approve'){
					approverType.setValue('Auto Approval');
				}else{
					approverType.setValue(data.approverType);
				}
				var downloadUrl = SERVERURL.PERSON_IMAGE_DOWNLOAD;

				if(!isNullOrEmpty(data.personId)){
					var imgPerson = structure.down('#lmEmpImage');

					Ext.Ajax.request({
						type: 'rest',
						binary: true,
						url: downloadUrl,
						params: {
							'personId': data.personId 	
						},
						method: 'GET',
						success : function(response){
							if(response.responseBytes.length>0){
								var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
								var url = window.URL.createObjectURL(blob);
								if(!isNullOrEmpty(url)) {
									imgPerson.setSrc(url);
								} 
							} else {
								imgPerson.setSrc('resources/images/profile_faculty.png');
							}
						}
					});
				}	
			},
			resetApprovalConfigreSetupForm: function()
			{
				var form = this.getLmapprovalconfigresetupform();
				var approvalTypeRadio = form.down('#approvalType');
				var levelField = form.down('#ApprovalLevelsId');
				var levelCombo1 = form.down('#userApprovalLevel1').reset();
				var levelCombo2 = form.down('#userApprovalLevel2').reset();
				var levelCombo3 = form.down('#userApprovalLevel3').reset();
				var levelCombo4 = form.down('#userApprovalLevel4').reset();
				var slaDayField = form.down('#slaDayId').reset();
			},
			saveLeaveRequest:function(form, empLeaveRequest, path) {
				var this$ = this;
				if(!isNullOrEmpty(path)) {
					empLeaveRequest = this$.getLeaveRequestDocumentJson(empLeaveRequest, path)
				}else {
					empLeaveRequest =Ext.encode(empLeaveRequest);
				}
				if(form.isValid()){
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.HR_EMP_LEAVE_REQUEST_SAVE,
						jsonData: empLeaveRequest,
						method: 'POST',
						success: function(frm, action) {
							var data = frm.responseText;
							var msgString = '';
							var byPassTimesheetAlertForCerp=false;
							var portalId = this$.getCurrentLoggedPortalId();
							if(!isNullOrEmpty(data)){
								var response = Ext.decode(data);
								if(response.errorMessageList.length>0){
									response.errorMessageList.forEach(function(msg){
										if(msg == 'NOT_ENOUGH_BALANCE'){
											msgString = msgString + getCommonTranslation('NOT_ENOUGH_BALANCE');
										}
										else if(msg == 'ALREADY_APPLIED'){
											if(msgString == ''){
												msgString = msgString + getCommonTranslation('LM_OVERLAP_DATE');
											}
											else{
												msgString = msgString  + '<br/>' + getCommonTranslation('LM_OVERLAP_DATE');
											}
										}else if(msg == 'ALREADY_APPROVED TIMESHEET'){
											byPassTimesheetAlertForCerp=true;
											msgString = msgString + getCommonTranslation('TIMESHEET_ALREADY_APPROVED_FOR_THE_EMPLOYEE');
										}else{
											if(msgString == ''){
												msgString = msgString + msg;
											}
											else{
												msgString = msgString  + '<br/>' + msg;
											}
										}
									});
									if(byPassTimesheetAlertForCerp && portalId==1){
										this$.resetLeaveApplyForm();
										showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_LEAVE_SUCCESS'));
									}else if(portalId==2 && msgString==getCommonTranslation('TIMESHEET_ALREADY_APPROVED_FOR_THE_EMPLOYEE')){  //V2D-353578
										showWarningMessage(getCommonTranslation('ALERT'), msgString);
									}else{
										showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), msgString);
									}
								}
								else if(response.isSuccess){
									this$.resetLeaveApplyForm();
									showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_LEAVE_SUCCESS'));
								}

								/*if(data == 'SUCCESS'){
							this$.resetLeaveApplyForm();
							showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_LEAVE_SUCCESS'));
						} else if(data == 'NOT_ENOUGH_BALANCE'){
							showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('NOT_ENOUGH_BALANCE'));	
						}else {
							showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('LM_OVERLAP_DATE'));	
						}*/
							}

							Ext.getBody().unmask();
						}
					});
				}else{
					showWarningMessage(getCommonTranslation('LM_LEAVE_REQUEST'), getCommonTranslation('PLEASE_FILL_VALID_FORM_DETAILS'));
					Ext.getBody().unmask();
				} 
			},
			getDocumentController : function(){
				var this$ = this;
				return this$.getController('Academia.controller.document.DocumentController');
			},
			getLeaveRequestDocumentJson: function(empLeaveRequest, path) {
				var this$ = this;
				var userId = this.getCurrentlyLoggedInUser().id;
				user = {
						id: userId
				};
				var fileName = path.substring(path.lastIndexOf('/') + 1, path.length);
				var doc = {
						path: path,
						name: fileName,
						type: 'DOCUMENT',
						createdBy: user
				};
				empLeaveRequest.document = doc;
				empLeaveRequest = Ext.encode(empLeaveRequest);
				return empLeaveRequest;
			},
			approvalSetupDownloadUploadRadioChange : function(cb, nv, ov){
				var $this = this;
				var structure = cb.up('approvalsetupbulkimportstructure');
				var downloadTemplateForm = structure.down('approvalsetupdownloadform');
				var uploadTemplateForm = structure.down('approvalsetupuploadform');
				var grid = $this.getImportlistapprovalflowupdategrid();
				if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
					uploadTemplateForm.hide();
					downloadTemplateForm.show();
					downloadTemplateForm.down('#lmConfigStatusAS').setDisabled(true);
					downloadTemplateForm.down('#lmUserGroupTypeAS').setDisabled(true);
					downloadTemplateForm.down('#lmDesignationComboAS').setDisabled(true);
					downloadTemplateForm.down('#lmDepartmentAS').setDisabled(true);
					downloadTemplateForm.getForm().reset();
					grid.setVisible(false);
				}else{
					$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
					var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						isUploadAll: false
					});
					downloadTemplateForm.hide();
					uploadTemplateForm.show();
					grid.setVisible(true);
					uploadTemplateForm.down("#uploadFileField").reset();
				}
			},
			getApprovalFlowUpdateDownloadFile: function(documentId, fileType) {
				if (!isNullOrEmpty(documentId)) {
					var csvForm = Ext.create('Ext.form.Panel');
					csvForm.getForm().submit({
						target: '_blank',
						method: 'POST',
						params: {
							access_token: Ext.Ajax.defaultHeaders.access_token
						},
						headers: {
							'Authorization': Ext.Ajax.defaultHeaders.Authorization
						},
						url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
						standardSubmit: true
					});
				}
			},

			/**
			 * Save Approval Setup filter bulk data
			 */

			getApprovalSetupJson:function(){

				var this$ = this;
				var formPnl=this$.getApprovalsetupdownloadform();
				var asArray=new Array();
				var endJson=null;

				asArray.push({
					"academyLocationId" : formPnl.down('#lmAcademyLocationComboAS').getValue(),
					"configurationStatus" : formPnl.down('#lmConfigStatusAS').getValue(),
					"userGroupType":formPnl.down('#lmUserGroupTypeAS').getValue(),
					"designation":formPnl.down('#lmDesignationComboAS').getValue(),
					"department": formPnl.down('#lmDepartmentAS').getValue()
				});

				var obj = new Object();
				obj = asArray[0];
				return Ext.encode(obj);	
			},

			deleteLeaveApprovalSetupConfiguration : function(records) {
				var this$ = this;
				if(records.length >0 ){			
					showConfirmMessage(getPersonModuleTranslation('LMAS_CONFIGURATION_DETAIL'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							var myJsonArray = [];
							for(index in records ) {
								myJsonArray.push(records[index].data.id);
							}
							if(myJsonArray.length > 0){
								var myJsonArray = Ext.encode(myJsonArray);
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.LMAS_LEAVE_APPROVAL_SETUP_CONFIGURATION_DELETE,
									jsonData: myJsonArray,
									method: 'POST',
									success: function(frm, action) {
										Ext.getBody().unmask();
										showSuccessMessage(getPersonModuleTranslation('LMAS_CONFIGURATION_RECORD'), getPersonModuleTranslation('LMAS_CONFIGURATION_RECORD_DELETE'));
										var configurationDetailgrid = this$.getLmapprovalsetupgrid();
										configurationDetailgrid.getSelectionModel().deselectAll();
										configurationDetailgrid.getStore().load();
									}
								});
							}  
						}
					});
				} else {
					showWarningMessage(getPersonModuleTranslation('LMAS_CONFIGURATION_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			checkApprovalConfigurationSetup : function(){
				var this$ = this;
				var structure = this.getLmleaverequesttabstructure();
				var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
				var form = this.getLmapplyforleaveform(); 
				form.setDisabled(true);
				var userId;
				if(isSelf == true) {
					userId = this.getCurrentlyLoggedInUser().id;
				} else {
					empCombo = structure.down('#employeeNameOrIdItemId');
					userId = empCombo.getValue();
				}
				if(!isNullOrEmpty(userId)) {
					Ext.Ajax.request({
						type : 'rest',
						url :SERVERURL.PATH_LMAS_APPROVAL_TYPE_BY_USER_ID,
						params : {
							userId : userId,
						},
						method : 'GET',
						success : function(form, action) {
							var records = Ext.decode(form.responseText);
							if(records.length > 0){
								var form = this$.getLmapplyforleaveform(); 
								form.setDisabled(false);
								this$.loadLeaveTypeCombo();
							} else{
								showWarningMessage(getCommonTranslation('ERROR'), getPersonModuleTranslation('LMAS_LEAVE_APPLY_ERROR_MSG'));
							}
						}    			
					}); 
				}else {

				}
			},
			leaveBalanceUpdateDownloadUploadRadioChange : function(cb, nv, ov){
				var $this = this;
				var structure = cb.up('employeeleavebalanceupdatebulkimportstructure');
				var downloadTemplateForm = structure.down('employeeleavebalanceupdatedownloadform');
				var uploadTemplateForm = structure.down('employeeleavebalanceupdateuploadform');
				var grid = $this.getImportlistemployeeleavebalanceupdategrid();
				if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
					uploadTemplateForm.hide();
					downloadTemplateForm.show();
					downloadTemplateForm.getForm().reset();

					var lmFromDateId = downloadTemplateForm.down('#fromDateItemId');
					lmFromDateId.setMaxValue(null);
					var lmToDateId = downloadTemplateForm.down('#toDateItemId');
					lmToDateId.setMinValue(null);
					var academyLocationId = this.getCurrentAcademyLocation(),
					lmEmpCombo = downloadTemplateForm.down('#empItemId'),
					lmDepartmentAS = downloadTemplateForm.down('#lmDepartmentAS'),
					lmDepartmentStore = lmDepartmentAS.getStore();
					var combo = downloadTemplateForm.down('#lmAcademyLocationComboAS'),
					store = combo.getStore();
					store.load({
						callback:function(){
							combo.setValue(academyLocationId);
							lmEmpCombo.getStore().getProxy().extraParams = {
								academyLocationIds: academyLocationId
							};
							lmDepartmentStore.getProxy().extraParams = {
								academyLocationsIds: academyLocationId
							};
							lmEmpCombo.getStore().load();
							lmDepartmentStore.load();
						}
					});
					grid.setVisible(false);
				}else{
					$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
					var uploadoptionradiogroupform  = $this.getEmployeeleaveuploadoptionradiogroup();
					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						isUploadAll: false
					});
					downloadTemplateForm.hide();
					uploadTemplateForm.show();
					grid.setVisible(true);
					uploadTemplateForm.down("#uploadFileField").reset();
				}
			},
			getLeaveBalanceUpdateDownloadFile: function(documentId, fileType) {
				if (!isNullOrEmpty(documentId)) {
					var csvForm = Ext.create('Ext.form.Panel');
					csvForm.getForm().submit({
						target: '_blank',
						method: 'POST',
						params: {
							access_token: Ext.Ajax.defaultHeaders.access_token
						},
						headers: {
							'Authorization': Ext.Ajax.defaultHeaders.Authorization
						},
						url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL + '?id=' + documentId + '&fileType=' + fileType,
						standardSubmit: true
					});
				}
			},
			disableActionHistoryTab:function(structure,permissionsMap){
			   	 var associatedAcadLocationIds = new Array();
			   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			   	 var leaveActionHistoryTab=false;
			   	 
			   	 for (var i = 0; i < permissionList.length; i++) {
			   		 if (permissionList[i] === "LEAVE_REQUEST_ACTION_HISTORY_TAB") {
			   			leaveActionHistoryTab=true;
			   		 }
			   	 }
			   	 this.showLeaveActionHistoryTab(leaveActionHistoryTab, structure);
			},
			showLeaveActionHistoryTab:function(leaveActionHistoryTab, structure){
	 		   	 var panelItem = new Array();
	 		   	 var $this = this;
	 		   	 var newcont=structure.items.items.length;
	 		   	 var insertPosition=newcont+1;
	 			 var portalId = this.getCurrentLoggedPortalId();
	 		   	 if(portalId==2){
	 		     	 if(leaveActionHistoryTab==true) {
		 		   		 panelItem.push({
		 		   			xtype:'tabpanel',
				   			 plain: true,
				   			 style:{overflow:'hidden !important',margin:'0!important'},
				   			 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
				   			 frame: false,
				   			 border:false,
				   			 items : [{
//				   				 xtype: 'lmrequestspendingactiontabstructure',
				   				 title: getCommonTranslation('REQUESTS_PENDING_ACTION'),
				   				xtype:'panel',
				   				items: [{
				   			        xtype: 'lmrequestspendingactionfilter',
				   			        itemId: 'lmRequestsPendingActionFilterId'
				   			    }, {
			   						xtype: 'lmrequestspendingactiongrid',
			   				        itemId: 'lmRequestsPendingActionGridId'
				   			    }]
				   			 }, {
				   				 xtype: 'lmleaverequesttabstructure',
				   				 title: getCommonTranslation('LM_LEAVE_REQUEST'),
				   			 },{
				   				 //xtype: 'lmleaverequestactionhistorytabstructure',
				   				 title: getCommonTranslation('LMAS_EMPLOYEE_LEAVE_REQUEST_ACTION_HISTORY'),
				   				 xtype:'panel',
				   				 /*defaults: {
				   					 width:'100%'
				   				 },*/
				   				 items : [{
				   					 xtype:'lmrequestactionhistoryfilter'
				   				 },{
				   					 xtype:'lmrequestactionhistorygrid'
				   				 }]

				   			 }]
		 		   		 });
		 		   	 }else{
		 		   		 panelItem.push({
		 		   			 xtype:'tabpanel',
		 		   			 plain: true,
		 		   			 style:{overflow:'hidden !important',margin:'0!important'},
		 		   			 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
		 		   			 frame: false,
		 		   			 border:false,
		 		   			 items:[{
				   				 xtype: 'lmrequestspendingactiontabstructure',
				   				 autoScroll: true,
				   				 title: getCommonTranslation('REQUESTS_PENDING_ACTION')
				   			 }, {
				   				 xtype: 'lmleaverequesttabstructure',
				   				 autoScroll: true,
				   				 title: getCommonTranslation('LM_LEAVE_REQUEST'),
				   			 }]
		 		   		 });
		 		   	 }
	 		   	 }else{
	 		   		 panelItem.push({
	 		   			 xtype:'tabpanel',
	 		   			 plain: true,
	 		   			 style:{overflow:'hidden !important',margin:'0!important'},
	 		   			 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	 		   			 frame: false,
	 		   			 border:false,
	 		   			 items:[{
			   				 xtype: 'lmrequestspendingactiontabstructure',
			   				 autoScroll: true,
			   				 title: getCommonTranslation('REQUESTS_PENDING_ACTION')
			   			 }, {
			   				 xtype: 'lmleaverequesttabstructure',
			   				 autoScroll: true,
			   				 title: getCommonTranslation('LM_LEAVE_REQUEST'),
			   			 }]
	 		   		 });
	 		   	 
	 		   	 }
	 		   	 structure.insert(insertPosition,panelItem);
	 		  
			},
			leaveCancellationSaveBtnClick : function(btn) {
				var $this=this;
				var win = this.getLmemployeeleavecancellationrequestdetailwin();
				var form = win.down('#lmemployeeleavecancellationrequestdetailformItemId');
				var formValues = form.getValues();
				var empLeaveRequest = new Object();
				var lmFromDateId = form.down('#lmFromDateId').value;
				var lmToDateId = form.down('#lmToDateId').value;
				var lmCancelFromDateId = form.down('#lmCancelFromDateId').value;
				var lmCancelToDateId = form.down('#lmCancelToDateId').value;
				empLeaveRequest.cancelFrom = lmCancelFromDateId.getTime();
				empLeaveRequest.cancelTo = lmCancelToDateId.getTime();
				empLeaveRequest.cancelReason = formValues.leaveCancellationId;
				empLeaveRequest.id = formValues.leaveRequestId;
				empLeaveRequest = Ext.encode(empLeaveRequest);

				var structure = $this.getLmleaverequesttabstructure();
				var isSelf = structure.down('#selfOrOtherItemId').getValue().isSelf;
				var grid = $this.getLmpastleaverequestgrid();
				var userId;

				var isValidLeave = false;
				if(lmFromDateId.getTime() == lmCancelFromDateId.getTime()){
					isValidLeave = true;
				}
				else if(lmToDateId.getTime() == lmCancelToDateId.getTime()){
					isValidLeave = true;
				}

				if(!isValidLeave){
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('Intermediate dates can not be selected for cancellation.'));	
				}
				else{
					showConfirmMessage(getServiceRequestTranslation('CANCEL'),getPersonModuleTranslation('LMAS_LEAVE_CANCEL_CONFIRM_MESSAGE'),function(btn,text) {
						if (btn == 'yes') {
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_CANCEL_LEAVE,
								jsonData: empLeaveRequest,
								method: 'POST',
								success: function(frm, action) {
									var data = frm.responseText;
									win.close();
									Ext.getBody().unmask();
									if(isSelf == true) {
										userId = $this.getCurrentlyLoggedInUser().id;
									}else{
										var empCombo = structure.down('#employeeNameOrIdItemId');
										userId = empCombo.getValue();
									}
									var store = grid.getStore();
									store.removeAll();
									$this.resetPageSetting(store);
									store.getProxy().extraParams = {
										id: userId
									};
									store.load();
									var successMsg = 'Your leaves have been cancelled successfully <br/> from ' + lmCancelFromDateId.toLocaleDateString() + ' to ' + lmCancelToDateId.toLocaleDateString();
									showSuccessMessage(getCommonTranslation('LM_LEAVE_REQUEST'), successMsg);
								}
							});
						}
					});
				}
			}
});