/**
 * This controller is used for the Manage Target Add/Edit/Delete/View
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.managetarget.ManageTargetController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['organization.academylocations.ActiveAcademyLocationStore','managetarget.ManageTargetByStafAdmissionsOfferStore',
        'program.ProgramGroupStore',
        'common.IntakeYearStore',
        'common.AssignedProgramStore',
        'common.BatchesByProgramId',
        'managetarget.ManageTargetStore',
        'user.UserAcademyLocationStore','program.ProgramByGroupIdStore','managetarget.AdmissionOfferApplicantCountGridStore',
        'managetarget.ManageTargetByStaffPresentationGridStore','managetarget.StaffDetailsManageTargetGridStore','managetarget.ManageTargetByStaffAppointmentsGridStore',
        'managetarget.StaffDetailsManageAppointmentsTargetGridStore','managetarget.ManageTargetPresentationLeadDetailsStore',
        'managetarget.ManageTargetByQualificationGridStore','managetarget.ProgramDetailsManageTargetGridStore','campaignnew.CampaignTypeStore',
        'managetarget.ActualPresentationLeadTargetPadmsGridStore','managetarget.ActualEnquiryTargetDetailPadmsGridStore',
        'managetarget.ActualApplicationTargetDetailPadmsGridStore','managetarget.ActualAdmissionTargetDetailPadmsGridStore','managetarget.ActualAppointmentsTargetDetailPadmsGridStore'
  ,'common.ModeOfDeliveryStore','campaignnew.RegistrationTypeStore','managetarget.ManageTargetByStaffApplicationForecastGridStore','program.ProgramGroupStoreManageTargetScreen'],
    views: ['managetarget.ManageTargetStructure',
        'managetarget.ManageTargetTabStructure',
        'managetarget.ManageTargetFilter',
        'managetarget.ManageTargetGrid',
        'managetarget.ManageTargetExportWindow','managetarget.ManageTargetAcademyWiseGrid',
        'managetarget.ManageTargetAcademyLocationWiseGrid','managetarget.ManageTargetProgramGroupWiseGrid',
        'managetarget.ManageTargetByStaffStructure',
        'managetarget.ManageTargetByStaffTabStructure','managetarget.ManageTargetByStaffFilter',
        'managetarget.ManageTargetByStaffPresentationGrid','managetarget.StaffDetailsManageTargetGrid',
        'managetarget.StaffDetailsManageTargetTabStructure','managetarget.StaffDetailsManageTargetStructure',
        'managetarget.StaffDetailsManageTargetEnquiryStructure',
        'managetarget.StaffDetailsManageTargetTabStructureEnquiry',
        'managetarget.StaffDetailsManageTargetEnquiryGrid',
        'managetarget.EnquiryLeadDetailsManageTargetTabEnquiryStructure','managetarget.EnquiryLeadDetailsManageTargetGrid',
        'managetarget.ManageTargetByStaffEnquiryGrid','managetarget.StaffDetailsManageTargetEnquiryGrid',
        'managetarget.PresentationLeadDetailsManageTargetTabStructure','managetarget.PresentationLeadDetailsManageTargetGrid','managetarget.ManageTargetByStaffApplicationGrid',
        'managetarget.ManageTargetByStaffAdmissionGrid','managetarget.ManageTargetByStaffAppointmentsGrid','managetarget.StaffDetailsManageAppointmentsTargetStructure',
        'managetarget.StaffDetailsManageAppointmentsTargetTabStructure','managetarget.StaffDetailsManageAppointmentsTargetGrid',
        'managetarget.StaffDetailsManageTargetApplicationStructure',
        'managetarget.StaffDetailsManageTargetTabStructureApplication',
        'managetarget.StaffDetailsManageTargetApplicationGrid',
        'managetarget.StaffDetailsManageTargetAdmissionStructure',
        'managetarget.StaffDetailsManageTargetTabStructureAdmission',
        'managetarget.StaffDetailsManageTargetAdmissionGrid',
        'managetarget.PresentationLeadDetailsManageTargetStructure',
        'managetarget.ManageTargetByQualificationsGrid',
        'managetarget.ProgramDetailsManageTargetStructure',
        'managetarget.ProgramDetailsManageTargetTabStructure',
        'managetarget.ProgramDetailsManageTargetGrid','managetarget.PresentationLeadDetailsPadmsForm','managetarget.ActualPresentationsTargetPadmsGrid',
        'managetarget.ActualPresentationsTargetPadmsStructure','campaignnew.CampaignNewFormLayout',
        'managetarget.ActualEnquiryTargetPadmsStructure','managetarget.ActualEnquiryTargetPadmsGrid','managetarget.ActualApplicationTargetPadmsStructure',
        'managetarget.ActualApplicationTargetPadmsGrid','managetarget.ActualAdmissionTargetPadmsStructure','managetarget.ActualAdmissionTargetPadmsGrid',
        'managetarget.ActualAppointmentsTargetPadmsStructure','managetarget.ActualAppointmentsTargetPadmsGrid','managetarget.ManageTargetByAdmissionsOfferGrid',
        'managetarget.StaffDetailsManageTargetAdmissionsOfferStructure','managetarget.StaffDetailsManageTargetTabStructureAdmissionsOffer',
        'managetarget.StaffDetailsManageTargetAdmissionOfferGrid','managetarget.ActualAdmissionsOfferApplicantCountStructure','managetarget.ActualAdmissionsOfferApplicantCountGrid'
        ,'managetarget.ManageTargetByStaffApplicationForecastGrid'],
    config:{
        MANAGE_TARGET_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_TARGET_PRIVILEGES')
    },
    models: ['Academia.model.managetarget.StaffDetailsManageTargetGridModel','Academia.model.admission.applicationFormSale.ApplicantGridModelForTargetByStaffRedirection'],
    refs: [{
        ref: 'managetargetbystaffstructure',
        selector: 'managetargetbystaffstructure'
    },{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
    	ref: 'managetargetfilter',
    	selector: 'managetargetfilter'
    }, {
    	ref: 'managetargetgrid',
    	selector: 'managetargetgrid'
    }, {
    	ref: 'managetargetexportwindow',
    	selector: 'managetargetexportwindow'
    }, {
    	ref: 'managetargettabstructure',
    	selector: 'managetargettabstructure'
    }, {
    	ref: 'managetargetacademywisegrid',
    	selector: 'managetargetacademywisegrid'
    }, {
    	ref: 'managetargetacademylocationwisegrid',
    	selector: 'managetargetacademylocationwisegrid'
    }, {
    	ref: 'managetargetprogramgroupwisegrid',
    	selector: 'managetargetprogramgroupwisegrid'
    }, {
    	ref: 'managetargetbystafffilter',
    	selector: 'managetargetbystafffilter'
    }, {
    	ref: 'managetargetbystafftabstructure',
    	selector: 'managetargetbystafftabstructure'
    },{
    	ref: 'managetargetbystaffpresentationgrid',
    	selector: 'managetargetbystaffpresentationgrid'
    },{
    	ref: 'staffdetailsmanagetargetgrid',
    	selector: 'staffdetailsmanagetargetgrid'
    },{
    	ref: 'managetargetbystaffenquirygrid',
    	selector: 'managetargetbystaffenquirygrid'
    },{
    	ref: 'staffdetailsmanagetargettabstructure',
    	selector: 'staffdetailsmanagetargettabstructure'
    },{
    	ref: 'managetargetbystaffapplicationgrid',
    	selector: 'managetargetbystaffapplicationgrid'
    },{
    	ref: 'managetargetbystaffadmissiongrid',
    	selector: 'managetargetbystaffadmissiongrid'
    },{
    	ref: 'managetargetbystaffappointmentsgrid',
    	selector: 'managetargetbystaffappointmentsgrid' 
    },{
    	ref: 'staffdetailsmanageappointmentstargetgrid',
    	selector: 'staffdetailsmanageappointmentstargetgrid' 
    },{
    	ref: 'staffdetailsmanageappointmentstargetstructure',
    	selector: 'staffdetailsmanageappointmentstargetstructure' 
    },{
    	ref: 'staffdetailsmanageappointmentstargettabstructure',
    	selector: 'staffdetailsmanageappointmentstargettabstructure' 
    },{
    	ref: 'staffdetailsmanagetargetenquirygrid',
    	selector: 'staffdetailsmanagetargetenquirygrid' 
    },{
    	ref: 'staffdetailsmanagetargettabstructureenquiry',
    	selector: 'staffdetailsmanagetargettabstructureenquiry'
    },{
    	ref: 'staffdetailsmanagetargetapplicationgrid',
    	selector: 'staffdetailsmanagetargetapplicationgrid' 
    },{
    	ref: 'staffdetailsmanagetargettabstructureapplication',
    	selector: 'staffdetailsmanagetargettabstructureapplication'
    },{
    	ref: 'staffdetailsmanagetargetadmissiongrid',
    	selector: 'staffdetailsmanagetargetadmissiongrid' 
    },{
    	ref: 'staffdetailsmanagetargettabstructureadmission',
    	selector: 'staffdetailsmanagetargettabstructureadmission'
    },{
    	ref: 'presentationleaddetailsmanagetargetstructure',
    	selector: 'presentationleaddetailsmanagetargetstructure'
    },{
    	ref: 'presentationleaddetailsmanagetargettabstructure',
    	selector: 'presentationleaddetailsmanagetargettabstructure'
    },{
    	ref: 'presentationleaddetailsmanagetargetgrid',
    	selector: 'presentationleaddetailsmanagetargetgrid'
    },{
    	ref: 'managetargetbyqualificationsgrid',
    	selector: 'managetargetbyqualificationsgrid'
    },{
    	ref: 'programdetailsmanagetargettabstructure',
    	selector: 'programdetailsmanagetargettabstructure'
    },{
    	ref: 'programdetailsmanagetargetgrid',
    	selector: 'programdetailsmanagetargetgrid'
    },{
    	ref: 'presentationleaddetailspadmsform',
    	selector: 'presentationleaddetailspadmsform'
    },{
    	ref: 'actualpresentationstargetpadmsstructure',
    	selector: 'actualpresentationstargetpadmsstructure'
    },{
    	ref: 'actualpresentationstargetpadmsgrid',
    	selector: 'actualpresentationstargetpadmsgrid'
    },{
    	ref: 'campaignnewformlayout',
    	selector: 'campaignnewformlayout'
    },{
    	ref: 'actualenquirytargetpadmsstructure',
    	selector: 'actualenquirytargetpadmsstructure'
    },{
    	ref: 'actualenquirytargetpadmsgrid',
    	selector: 'actualenquirytargetpadmsgrid'
    },{
    	ref: 'actualapplicationtargetpadmsstructure',
    	selector: 'actualapplicationtargetpadmsstructure'
    },{
    	ref: 'actualapplicationtargetpadmsgrid',
    	selector: 'actualapplicationtargetpadmsgrid'
    },{
    	ref: 'actualadmissiontargetpadmsstructure',
    	selector: 'actualadmissiontargetpadmsstructure'
    },{
    	ref: 'actualadmissiontargetpadmsgrid',
    	selector: 'actualadmissiontargetpadmsgrid'
    },{
    	ref: 'actualappointmentstargetpadmsstructure',
    	selector: 'actualappointmentstargetpadmsstructure'
    },{
    	ref: 'actualappointmentstargetpadmsgrid',
    	selector: 'actualappointmentstargetpadmsgrid'
    },{
    	ref: 'managetargetbyadmissionsoffergrid',
    	selector: 'managetargetbyadmissionsoffergrid'
    },{
    	ref: 'staffdetailsmanagetargettabstructureadmissionsoffer',
    	selector: 'staffdetailsmanagetargettabstructureadmissionsoffer'
    },{
    	ref: 'staffdetailsmanagetargetadmissionoffergrid',
    	selector: 'staffdetailsmanagetargetadmissionoffergrid'
    },{
    	ref: 'actualadmissionsofferapplicantcountgrid',
    	selector: 'actualadmissionsofferapplicantcountgrid'
    },{
    	ref: 'actualadmissionsofferapplicantcountstructure',
    	selector: 'actualadmissionsofferapplicantcountstructure'
    },{
    	ref: 'managetargetstructure',
    	selector: 'managetargetstructure'
    },{
    	ref: 'staffdetailsmanagetargetstructure',
    	selector: 'staffdetailsmanagetargetstructure'
    },{
    	ref: 'staffdetailsmanagetargetadmissionstructure',
    	selector: 'staffdetailsmanagetargetadmissionstructure'
    },{
    	ref: 'staffdetailsmanagetargetadmissionsofferstructure',
    	selector: 'staffdetailsmanagetargetadmissionsofferstructure'
    },{
    	ref: 'staffdetailsmanagetargetapplicationstructure',
    	selector: 'staffdetailsmanagetargetapplicationstructure'
    },{
    	ref: 'staffdetailsmanageappointmentstargetstructure',
    	selector: 'staffdetailsmanageappointmentstargetstructure'
    },{
    	ref: 'staffdetailsmanagetargetenquirystructure',
    	selector: 'staffdetailsmanagetargetenquirystructure'
    },{
    	ref: 'programdetailsmanagetargetstructure',
    	selector: 'programdetailsmanagetargetstructure'
    },{
    	ref: 'managetargetbystaffapplicationforecastgrid',
    	selector: 'managetargetbystaffapplicationforecastgrid'
    }],
    
    init: function() {
        this.control({
        	'managetargetbystafftabstructure' :{
        		afterrender: function(structure) {
            		var $this = this;
            		structure.body.on('click', function() {
    					var filter = structure.down('managetargetbystafffilter');
    					$this.hideInvalidIconFromField(filter);
    	             	});
        		}
        	},
        	
        	'managetargetbystafffilter' :{
        		render: function(form) {
            		var $this = this;
            		 setTimeout(function(){
            			 var programGroup=form.down('#ProgramGroupId');
     	             	programGroup.setVisible(false);  
             			                	},100);
           		
            		}
        	},
        	
            'managetargettabstructure': {
            	afterrender: function(structure) {
            		var $this = this;
            		structure.body.on('click', function() {
    					var filter = structure.down('managetargetfilter');
    					$this.hideInvalidIconFromField(filter);
    			       });
            		var manageTargetGrid =   $this.getManagetargetgrid();
            		var manageTargetALGrid =  $this.getManagetargetacademylocationwisegrid();
            		var manageTargetAWGrid =  $this.getManagetargetacademywisegrid();
            		var manageTargetPGWGrid =  $this.getManagetargetprogramgroupwisegrid();
            		
            		var manageTargetGridStore = manageTargetGrid.getStore();
            		if (manageTargetGridStore) {
            			manageTargetGridStore.removeAll()
            		}
            		$this.disableExportButtonsByPivileges(manageTargetGrid, $this.getMANAGE_TARGET_PERMISSIONS());
            		$this.disableExportButtonsByPivilegesForALWiseGrid(manageTargetALGrid, $this.getMANAGE_TARGET_PERMISSIONS());
            		$this.disableExportButtonsByPivileges(manageTargetAWGrid, $this.getMANAGE_TARGET_PERMISSIONS());
            		$this.disableExportButtonsByPivileges(manageTargetPGWGrid, $this.getMANAGE_TARGET_PERMISSIONS());
            	}
            },
            'managetargetfilter multiselectcombofield#multiselectAcademyId': {
            	/*render: function(obj) {
            		var userId = this.getCurrentlyLoggedInUser().id;
            		var store = obj.getStore();
            		store.getProxy().extraParams = {
            			id: userId
            		};
            		store.load();
            	},*/
            	select: function(obj, record) {
            		var filter = this.getManagetargetfilter();

                    //var academyLocationItemId = filter.down('#academyLocationItemId');
                    var academyLocationItemId = filter.down('#multiselectAcademyId');
                    var programGroupItemId = filter.down('#programGroupItemId');
                    var intakeYearItemId = filter.down('#intakeYearItemId');
                    var programItemId = filter.down('#programItemId');
                    var batchItemId = filter.down('#batchItemId');
                    
                    programGroupItemId.reset();
                    programItemId.reset();
                    batchItemId.reset();
                    programItemId.setDisabled(true);
                    batchItemId.setDisabled(true);
            		this.loadProgramCombo();
            	}
            },
            'managetargetfilter combo#academyLocationItemId': {
            	render: function(obj) {
            		var userId = this.getCurrentlyLoggedInUser().id;
            		var store = obj.getStore();
            		store.getProxy().extraParams = {
            			id: userId
            		};
            		store.load();
            	},
            	select: function(obj, record) {
            		this.loadProgramCombo();
            	}
            },
            'managetargetfilter multiselectcombofield[itemId=multiselectAcademyId]':{
    			render:function(obj, record){
					var $this = this;
					obj.getStore().load({
						callback: function(record){
							obj.select(obj.getStore().collect(obj.valueField));
						}
					});
				},
            	change: function(obj,record){
            		$this = this;
            		setTimeout(function(){
            			$this.loadDataChangedByAcademyLocation(obj);
            		},300);

            	}
    		},
            'managetargetfilter multiselectcombofield[itemId=multiselectAcademyWiseId]':{
    			render:function(obj, record){
					var $this = this;
					obj.getStore().load({
						callback: function(record){
							obj.select(obj.getStore().collect(obj.valueField));
						}
					});
				}
    		},
            'managetargetfilter combo#programGroupItemId': {
                select: function(obj, record) {
                    this.loadProgramCombo();
                }
            },
            'managetargetfilter combo#intakeYearItemId': {
                select: function(obj, record) {
                    this.loadProgramCombo();
                }
            },
            'managetargetfilter button[itemId=resetBtnManageTargetFilterItemId]': {
                click: function(obj) {
                    var $this = this;
                    var form = obj.up('managetargetfilter').getForm();
                    form.reset();

                    var filter = $this.getManagetargetfilter();
                    // filter.reset();

                    var programItemId = filter.down("#programItemId");
                    programItemId.setDisabled(true);
                    programItemId.reset();

                    var batchItemId = filter.down("#batchItemId");
                    batchItemId.setDisabled(true);
                    batchItemId.reset();

                    var grid = $this.getManagetargetgrid();
                    var saveBtnManageTargetGridItemId = grid.down("#saveBtnManageTargetGridItemId");
                    saveBtnManageTargetGridItemId.setDisabled(true);

                    var store = grid.getStore();
                    if (store) {
                        store.removeAll()
                    }
                    
                    var manageTargetStructure = $this.getManagetargettabstructure();
                	var form = this.getManagetargetfilter();
                	var viewTargetBy = form.down('#viewTargetBy');
                	viewTargetBy.getStore().load({
  					   callback: function(records, operation, success) {
  						   for(var i in records){
  							   if(records[i].data.id=='PROGRAM_WISE'){
  								 viewTargetBy.setValue(records[i].data.id);
  							   }
  						   }
  					   }	   
  				   });
                	var programGroupItemId = form.down('#programGroupItemId');
                	var programGroupWiseId = form.down('#programGroupWiseId');
                	var programItemId = form.down('#programItemId');
                	var batchItemId = form.down('#batchItemId');
                	var multiselectAcademyId = form.down('#multiselectAcademyId');
                	var multiselectAcademyWiseId = form.down('#multiselectAcademyWiseId');
                	
                	manageTargetStructure.down("#managetargetgridItemId").setVisible(false);
                	manageTargetStructure.down("#managetargetacademylocationwisegrid").setVisible(false);
                	manageTargetStructure.down("#managetargetacademywisegrid").setVisible(false);
                	manageTargetStructure.down("#managetargetprogramgroupwisegrid").setVisible(false);
                    
                    manageTargetStructure.down("#managetargetgridItemId").setVisible(true);
                    $this.toggleGridSummaryRow(manageTargetStructure.down("#managetargetgridItemId"),false);
                    buttonsToolBar = manageTargetStructure.down("#managetargetgridItemId").query('toolbar')[0];
                    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
                	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
                	pdftoolbar.setDisabled(true);
                	exceltoolbar.setDisabled(true);
                	
            		multiselectAcademyId.setVisible(true);
            		this.setAllowBlank (multiselectAcademyId,false);
            		multiselectAcademyWiseId.setVisible(false);
            		this.setAllowBlank (multiselectAcademyWiseId,true);
            		programGroupItemId.setVisible(true);
            		programItemId.setVisible(true);
            		batchItemId.setVisible(true);
            		programGroupWiseId.setVisible(false);
            		this.setAllowBlank (programGroupWiseId,true);
                }
            },
            /*'managetargetfilter combo#intakeYearItemId': {
                select: function(obj, record) {
                    this.loadProgramCombo();
                }
            },*/
            'managetargetfilter combo[itemId=programItemId]': {
                select: function(obj, record) {
                    var programId = record[0].get("id");
                    if (programId > 0) {
                        var filter = $this.getManagetargetfilter();

                        var batchItemId = filter.down("#batchItemId");
                        batchItemId.setDisabled(false);
                        batchItemId.reset();

                        var batchStore = batchItemId.getStore();
                        batchStore.proxy.extraParams = {
                            id: programId
                        };
                        batchStore.load();
                    }
                }
            },
            'managetargetfilter button[itemId=searchBtnManageTargetFilterItemId]': {
                click: function(obj) {
                	$this=this;
                	var form = obj.up('managetargetfilter');
                	this.showInvalidIconOnField(form);
                	var viewTargetBy = form.down('#viewTargetBy').getValue();
                	if(viewTargetBy=="ACADEMY_WISE"){
                		var grid = $this.getManagetargetacademywisegrid();
                	}
                	if(viewTargetBy=="ACADEMY_LOCATION_WISE"){
                		var grid = $this.getManagetargetacademylocationwisegrid();
                	}
                	if(viewTargetBy=="PROGRAM_GROUP_WISE"){
                		var grid = $this.getManagetargetprogramgroupwisegrid();
                	}
                	if(viewTargetBy=="PROGRAM_WISE"){
                		var grid = $this.getManagetargetgrid();
                	}
                	this.loadManageTargetGrid(grid);
                }
            },
            'managetargetgrid button[itemId=saveBtnManageTargetGridItemId]': {
                click: function() {
                    var $this = this;
                    var grid = $this.getManagetargetgrid();
                    var models = grid.getStore().getRange();
                    var myJson = new Array();
                    for (var i = 0; i < models.length; i++) {
                    	
                    	if( !isNullOrEmpty(models[i].data.managingDirectorId) ){
                    		models[i].data.managingDirector = { id:models[i].data.managingDirectorId };
                    	} else {
                    		delete models[i].data.managingDirector;
                    	}
                    	
                    	delete models[i].data.intakeYearName;
                    	delete models[i].data.managingDirectorId;
                    	delete models[i].data.serialNo;
                    	myJson.push(models[i].data);
                    }
                    var formData = Ext.encode(myJson);
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.MT_MANAGE_TARGET_UPDATE,
                        jsonData: formData,
                        method: 'POST',
                        success: function(frm, action) {
                            var data = frm.responseText;
                            Ext.getBody().unmask();
                            $this.loadManageTargetGrid(grid);
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getEnquiryTranslation('MT_TARGETS_SAVED_SUCCESSFULLY'));
                        }
                    });
                }
            },
            
            'managetargetbystaffapplicationforecastgrid button[itemId=SaveBtn]': {
                click: function() {
                    var $this = this;
                    var grid = $this.getManagetargetbystaffapplicationforecastgrid();
                    var models = grid.getStore().getRange();
                    var myJson = new Array();
                    for (var i = 0; i < models.length; i++) {
                    	delete models[i].data.targetVariance;
                    	delete models[i].data.staffPresentationCount;
                    	delete models[i].data.staffCount;
                    	delete models[i].data.registrationTypeValue;
                    	delete models[i].data.registrationType;
                    	delete models[i].data.programGroupName;
                    	delete models[i].data.presentationLeadDetails;
                    	delete models[i].data.percentageTargetAchieved;
                    	delete models[i].data.modeOfDeliveryValue;
                    	delete models[i].data.modeOfDelivery;
                    	delete models[i].data.manageTargetType;
                    	delete models[i].data.locationName;
                    	delete models[i].data.intakeYearName;
                    	delete models[i].data.actualTargetAchived;
                    	delete models[i].data.actualTarget;
                    	delete models[i].data.academyName;
                    	delete models[i].data.currentStatus;

                    	myJson.push(models[i].data);
                    }
                    var formData = Ext.encode(myJson);
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.APPLICATION_FORECAST_UPDATE,
                        jsonData: formData,
                        method: 'POST',
                        success: function(frm, action) {
                            var data = frm.responseText;
                            Ext.getBody().unmask();
                            grid.getStore().load();
                            showSuccessMessage(getCommonTranslation('APPLICATION_FORECAST_TARGET'), getCommonTranslation('APPLICATION_FORECAST_TARGETS_UPDATE'));
                        }
                    });
                }
            },
            'managetargetacademylocationwisegrid button[itemId=saveBtnManageTargetGridALWiseItemId]': {
                click: function() {
                    var $this = this;
                    var grid = $this.getManagetargetacademylocationwisegrid();
                    var models = grid.getStore().getRange();
                    var myJson = new Array();
                    for (var i = 0; i < models.length; i++) {
                        /*if( !isNullOrEmpty(models[i].data.managingDirector) && models[i].data.managingDirector != "" ){
                        	//delete models[i].data.managingDirectorId;
                        } else {
                        	if( !isNullOrEmpty(models[i].data.managingDirectorId) ){
                        		models[i].data.managingDirector = { id:models[i].data.managingDirectorId };
                        	} else {
                        		models[i].data.managingDirector = { id:-1 };
                        	}
                        	
                        }*/
                    	if( !isNullOrEmpty(models[i].data.managingDirectorId) ){
                    		models[i].data.managingDirector = { id:models[i].data.managingDirectorId };
                    	}
                    	if( models[i].data.managingDirector == "" ){
                    		models[i].data.managingDirector = { id:-1 };
                    	}
                    	delete models[i].data.intakeYearName;
                    	delete models[i].data.serialNo;
                        myJson.push(models[i].data);
                    }
                    var formData = Ext.encode(myJson);
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.MT_MANAGE_TARGET_AL_WISE_UPDATE,
                        jsonData: formData,
                        method: 'POST',
                        success: function(frm, action) {
                            var data = frm.responseText;
                            Ext.getBody().unmask();
                            $this.loadManageTargetGrid(grid);
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getEnquiryTranslation('MT_TARGETS_SAVED_SUCCESSFULLY'));
                        }
                    });
                }
            },
            'managetargetgrid button[itemId=exportReportItemId]':{
            	click: function(obj) {
            		this.manageTargetExportWin();
	         	}
            },
            'managetargetexportwindow [itemId=academyId]': {
                select: function(obj, record) {
                    var academyId = record[0].get("id");
                    if (academyId > 0) {
                        var filter = obj.up('form');
                        var academyLocationCombo = filter.down("#academyLocationId");
                        academyLocationCombo.setVisible(true);
                        var academyLocStore = academyLocationCombo.getStore();
                        academyLocStore.proxy.extraParams = {
                        	id: this.getCurrentlyLoggedInUser().id,
                            academyId: academyId
                        };
                        academyLocStore.load();
                    }
                }
            },
            'managetargetexportwindow [itemId=academyLocationId]': {
            	render:function(obj, record){
					var $this = this;
					obj.getStore().proxy.extraParams = {
                        id: this.getCurrentlyLoggedInUser().id
                    };
					obj.getStore().load();
				},
				select: function(obj, record) {
                    var academyLocationId = record[0].get("id");
                    if (academyLocationId > 0) {
                        var filter = obj.up('form');
                        var programGroupCombo = filter.down("#programGroupId");
                        programGroupCombo.setVisible(true);
                        var programGroupStore = programGroupCombo.getStore();
                        programGroupStore.proxy.extraParams = {
                        	academyLocationId: academyLocationId,
                        };
                        programGroupStore.load();
                    }
                }
            },
            'managetargetexportwindow button[itemId=submitBtn]': {
         	   click: function(btn) {         		   
         		   this.exportXLFunction();
         	   }
            },
            'managetargetfilter [itemId=viewTargetBy]': {
                render:function(combo){
    				   combo.getStore().load({
    					   callback: function(records, operation, success) {
    						   for(var i in records){
    							   if(records[i].data.id=='PROGRAM_WISE'){
    								   combo.setValue(records[i].data.id);
    							   }
    						   }
    					   }	   
    				   });
                },
                select: function(obj, record) {
                	this.getShowAndHideManageTargetList(obj,record); 
                }
            },
            'managetargetfilter': {
                render:function(form){
                	this.setAllowBlank (form.down('#multiselectAcademyWiseId'),true);
            		this.setAllowBlank (form.down('#programGroupWiseId'),true);
                }
         },
         'managetargetbystafffilter [itemId=viewTargetByStaff]': {
             render:function(combo){
 				   combo.getStore().load({
 					   callback: function(records, operation, success) {
 						   for(var i in records){
 							   if(records[i].data.id=='PRESENTATIONS'){
 								   combo.setValue(records[i].data.id);
 							   }
 						   }
 					   }	   
 				   });
 				  var associatedAcadLocationIds = new Array();
 			    	associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
 			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getMANAGE_TARGET_PERMISSIONS());
 			    	var flag=0;
 			    	Ext.each(permissionList, function(privilege) { 			    			
 			    			if(privilege === 'APPLICATION_FORECAST'){
 			    				flag=1;
 			    				}
 			    	});
 			    	if(flag==0){
 			    		combo.getStore().on('load', function(){
 			    			if(combo.getStore()!=null){
 			  			 for(var i=0; i< combo.getStore().data.items.length;i++){
 			  				 if(combo.getStore().data.items[i].data.id == 'APPLICATION_FORECAST'){
 			  					combo.getStore().removeAt(i);
 			  				 } 
 			  			 }
 			    		}
 			  		 });
 			    	}
 			    	
             },
             select: function(obj, record) {
             	this.getShowAndHideManageTargetByStaffList(obj,record);
             	var me  = this;
             	var structure = obj.up('managetargetbystafftabstructure');
             	if(!isNullOrEmpty(structure)){
             		var oldHeight = structure.body.getStyles('height').height;    				
    				structure.body.setStyle('height','100px');
					structure.scrollBy(0,1);
					structure.scrollBy(0,-1);
					structure.body.setStyle('height',oldHeight);
    			}
             	var TargetBy=obj.getValue();
            	var form = this.getManagetargetbystafffilter();
            	var academyLocationId = this.getCurrentAcademyLocation();
             	var programGroup=form.down('#ProgramGroupId');
             	if(TargetBy=='APPLICATION_FORECAST'){
             		Ext.Ajax.request({
                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
                		method: 'GET',
                		async: false,
                		params: {
                			screenName: 'managetargetbystafffilter',
                			academyLocationId:academyLocationId,
                			languageCode:'en'
                		},
                		success: function(response) {
                			var json = JSON.parse(response.responseText);
                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
                			fieldInfo.set("formFieldsInfo", json);
                			if( !isNullOrEmpty(json) ){
                				if( !isNullOrEmpty(json.managetargetbystafffilter) ){
                					var managetargetbystaff = json.managetargetbystafffilter;
                					for( i in managetargetbystaff){
                						var fieldConfig = managetargetbystaff[i];
                						if(fieldConfig.isVisible ){
            								programGroup.setVisible(true);
            								var currentFieldLabel = fieldConfig.formFieldLabel;
            								programGroup.setFieldLabel(currentFieldLabel);
                							if(fieldConfig.isMandatory ){
                								programGroup=form.down('#'+fieldConfig.formFieldId)
                								me.setAllowBlank(programGroup, false);
                								}else{
                    								programGroup=form.down('#'+fieldConfig.formFieldId)
                    								me.setAllowBlank(programGroup, true);
                								}
            								}else{
            									programGroup.setVisible(false);
            								}
                       					}
                				}else{
                             		programGroup.setVisible(true);
                	             	me.setAllowBlank(programGroup,false);
                	             	form.isValid();
                        		}
                			}
                		}
                	});
            	}else{
             		programGroup.setVisible(false);
	             	me.setAllowBlank(programGroup,true);
	             	var grid=me.getManagetargetbystaffapplicationforecastgrid();
	            	var saveBtn=grid.down('#SaveBtn');
	             	saveBtn.setDisabled(true);
	             	form.isValid();
             	}
             }
         },
         'managetargetbystafffilter multiselectcombofield#multiselectTargetByStaffAcademyId': {
         	render: function(obj) {
         		var userId = this.getCurrentlyLoggedInUser().id;
         		var store = obj.getStore();
         		store.getProxy().extraParams = {
         			id: userId
         		};
         		//store.load();
         		store.load({
					callback: function(record){
						obj.select(obj.getStore().collect(obj.valueField));
					}
				});
         	}
         },
         'managetargetbystafffilter [itemId=modeDeliveryId]': {
             render:function(combo){
            	 combo.getStore().load();
             }
         },
         'managetargetbystafffilter [itemId=registrationTypeId]': {
             render:function(combo){
            	 combo.getStore().load();
             }
         },
         'managetargetbystafffilter button[itemId=resetBtnTargetByStaffItemId]': {
        	 click: function(obj) {
        		 var $this = this;
        		 var form = obj.up('managetargetbystafffilter').getForm();
        		 form.reset();
        		 var form = this.getManagetargetbystafffilter();
        		 var viewTargetBy = form.down('#viewTargetByStaff');
              	var programGroup=form.down('#ProgramGroupId');
              	programGroup.setVisible(false);
              	this.setAllowBlank(programGroup,true);
        		 viewTargetBy.getStore().load({
        			 callback: function(records, operation, success) {
        				 for(var i in records){
        					 if(records[i].data.id=='PRESENTATIONS'){
        						 viewTargetBy.setValue(records[i].data.id);
        					 }
        				 }
        			 }	   
        		 });
             	var manageTargetByStaffStructure = $this.getManagetargetbystafftabstructure();
             	manageTargetByStaffStructure.down("#managetargetbystaffenquirygridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbystaffenquirygridItemId").getStore().removeAll();
                             
             	manageTargetByStaffStructure.down("#managetargetbystaffpresentationgridItemId").setVisible(true);
             	manageTargetByStaffStructure.down("#managetargetbystaffpresentationgridItemId").getStore().removeAll();
             	
             	manageTargetByStaffStructure.down("#managetargetbystaffappointmentsgridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbystaffappointmentsgridItemId").getStore().removeAll();
             	
             	manageTargetByStaffStructure.down("#managetargetbystaffapplicationgridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbystaffapplicationgridItemId").getStore().removeAll();
             	
             	manageTargetByStaffStructure.down("#managetargetbyqualificationsgridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbyqualificationsgridItemId").getStore().removeAll();
             	
            	manageTargetByStaffStructure.down("#managetargetbystaffadmissiongridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbystaffadmissiongridItemId").getStore().removeAll();
             	
             	manageTargetByStaffStructure.down("#managetargetbyadmissionsoffergridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbyadmissionsoffergridItemId").getStore().removeAll();
             	
             	manageTargetByStaffStructure.down("#managetargetbystaffapplicationforecastgridItemId").setVisible(false);
             	manageTargetByStaffStructure.down("#managetargetbystaffapplicationforecastgridItemId").getStore().removeAll();
             	
                buttonsToolBar = manageTargetByStaffStructure.down("#managetargetbystaffpresentationgridItemId").query('toolbar')[0];
                var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
            	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
            	var grid=$this.getManagetargetbystaffapplicationforecastgrid();
            	var saveBtn=grid.down('#SaveBtn');
	            saveBtn.setDisabled(true);
            	pdftoolbar.setDisabled(true);
            	exceltoolbar.setDisabled(true);
            	form.isValid();
             }
         },
         'managetargetbystafffilter button[itemId=searchBtnTargetByStaffItemId]': {
             click: function(obj) {
             	$this=this;
             	var form = obj.up('managetargetbystafffilter');
             	this.showInvalidIconOnField(form);
             	var viewTargetBy = form.down('#viewTargetByStaff').getValue();
             	var grid = null;
             	if(viewTargetBy=="PRESENTATIONS"){
             		var grid = $this.getManagetargetbystaffpresentationgrid();
             	}else if(viewTargetBy=="APPLICATIONS"){
             		var grid = $this.getManagetargetbystaffapplicationgrid();
             	}else if(viewTargetBy=="ADMISSIONS"){
             		var grid = $this.getManagetargetbystaffadmissiongrid();
             	}else if(viewTargetBy=="APPOINTMENTS"){
             		var grid = $this.getManagetargetbystaffappointmentsgrid();
             	}else if(viewTargetBy=="ENQUIRY"){
             		var grid = $this.getManagetargetbystaffenquirygrid();
             	}else if(viewTargetBy=="PROGRAMS"){
             		var grid = $this.getManagetargetbyqualificationsgrid();
             	}else if(viewTargetBy=="ADMISSIONS_OFFER"){
             		var grid = $this.getManagetargetbyadmissionsoffergrid();
             	}else if(viewTargetBy=="APPLICATION_FORECAST"){
             		var grid = $this.getManagetargetbystaffapplicationforecastgrid();
             	}
             	if(!isNullOrEmpty(grid)){
             		$this.loadManageTargetByStaffGrid(grid,viewTargetBy);
             	}

             }
         },// ManageTargetByStaffEnquiryGrid
         
         'managetargetbystaffenquirygrid': {
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
              var $this =this;
              if(columnName == "staffCount"){
     			   if(e.target.tagName=='A'){
     				  $this.getOpenManageTargetByStaffDetails(grid,record,'ENQUIRY');
     			   }
     		   }
              if(columnName == "actualTargetAchived"){
      			   if(e.target.tagName=='A'){
      				  $this.getOpenActualEnquiryTargetDetailsGrid(grid,record);
      			   }
                 }
			 }
         },
         'managetargetbyqualificationsgrid': {
        	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        		 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
        		 var $this =this;
        		 if(columnName == "programCount"){
        			 if(e.target.tagName=='A'){
        				 $this.getOpenManageTargetByStaffDetails(grid,record,'PROGRAMS');
        			 }
        		 }
        	 }
         },
         'managetargetbystaffapplicationgrid': {
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
              var $this =this;
              if(columnName == "staffCount"){
     			   if(e.target.tagName=='A'){
     				  $this.getOpenManageTargetByStaffDetails(grid,record,'APPLICATIONS');
     			   }
     		   }
              if(columnName == "actualTargetAchived"){
      			   if(e.target.tagName=='A'){
      				  $this.getOpenActualApplicationTargetDetailsGrid(grid,record);
      			   }
                 }
			 }
         },
         
         'managetargetbystaffadmissiongrid': {
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
              var $this =this;
              if(columnName == "staffCount"){
     			   if(e.target.tagName=='A'){
     				  $this.getOpenManageTargetByStaffDetails(grid,record,'ADMISSIONS');
     			   }
     		   }
              if(columnName == "actualTargetAchived"){
     			   if(e.target.tagName=='A'){
     				  $this.getOpenActualAdmissionTargetDetailsGrid(grid,record);
     			   }
                }
			 }
         },
         
         
         'managetargetbystaffpresentationgrid': {
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
              var $this =this;
              if(columnName == "staffCount"){
     			   if(e.target.tagName=='A'){
     				  $this.getOpenManageTargetByStaffDetails(grid,record,'PRESENTATIONS');
     			   }
     		   }
              if(columnName == "presentationLeadDetails"){
    			   if(e.target.tagName=='A'){
    				  $this.getOpenPresentationLeadDetailsGrid(grid,record);
    			   }
    		   }
              if(columnName == "actualTargetAchived"){
   			   if(e.target.tagName=='A'){
   				  $this.getOpenActualLeadTargetDetailsGrid(grid,record);
   			   }
              }
			 },
			  render: function(grid){
  				 var buttonsToolBar = grid.query('toolbar')[0];
  				  var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
  				  var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
  				  pdftoolbar.setDisabled(true);
  				  exceltoolbar.setDisabled(true);
  			  }
         },
         'managetargetbystaffappointmentsgrid': {
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
              var $this =this;
              if(columnName == "staffCount"){
     			   if(e.target.tagName=='A'){
     				  $this.getOpenManageTargetByStaffDetails(grid,record,'APPOINTMENTS');
     			   }
     		   }
              if(columnName == "actualTargetAchived"){
      			   if(e.target.tagName=='A'){
      				  $this.getOpenActualAppointmentsTargetDetailsGrid(grid,record);
      			   }
                 }
			 }
         },
 		'staffdetailsmanagetargetgrid button[itemId=btnAdd]':{
			click: function(button) {
				var grid = this.getStaffdetailsmanagetargetgrid();
		        var getStaffStructure = grid.up('staffdetailsmanagetargettabstructure');
				this.addNewRowInStaffDetailsGrid(1, grid, getStaffStructure);
			}
		},
		'staffdetailsmanagetargetapplicationgrid button[itemId=btnAdd]':{
			click: function(button) {
				var grid = this.getStaffdetailsmanagetargetapplicationgrid();
		        var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureapplication');
				this.addNewRowInStaffDetailsGrid(1, grid, getStaffStructure);
			}
		},
		'staffdetailsmanagetargetadmissiongrid button[itemId=btnAdd]':{
			click: function(button) {
				var grid = this.getStaffdetailsmanagetargetadmissiongrid();
		        var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureadmission');
				this.addNewRowInStaffDetailsGrid(1, grid, getStaffStructure);
			}
		},
		'programdetailsmanagetargetgrid button[itemId=btnAdd]':{
			click: function(button) {
				var grid = this.getProgramdetailsmanagetargetgrid();
		        var getStaffStructure = grid.up('programdetailsmanagetargettabstructure');
				this.addNewRowInProgramDetailsGrid(1, grid, getStaffStructure);
			}
		},
		'staffdetailsmanageappointmentstargetgrid button[itemId=btnAdd]':{
			click: function(button) {
				this.addNewRowInStaffAppointmentsDetailsGrid(1);
			}
		},
		'staffdetailsmanagetargetapplicationgrid': {
	        cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	            var $this = this;
	            var grid = $this.getStaffdetailsmanagetargetapplicationgrid();
	            var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureapplication');
	            var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	            if (e.target.tagName == 'DIV') {
	            	if (columnName == "addButton") {
	            		if (e.target.className == "addButtonClsForGridActionCls") {
	            			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	            				var serialNo;
	            				if (grid.getStore() != null)
	            					serialNo = grid.getStore().getCount();
	            				this.addNewRowInStaffDetailsGrid(serialNo + 1, grid, getStaffStructure);
	            			}
	            		}
	            	} else if (columnName == "deleteButton") {
	            		if (e.target.className == "deleteButtonClsForGridActionCls") {
	            			var getStaffStructure = $this.getStaffdetailsmanagetargettabstructureapplication();
	            			var titleMessage = getAdmissionTranslation('STAFF_WISE_APPLICATIONS_TARGETS');
	            			var MTBSGrid = $this.getManagetargetbystaffapplicationgrid();
	            			$this.deleteManageTargetStaffDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);
	            			
	            		}
	            	}
	            }
	        }
	    },
	    'staffdetailsmanagetargetadmissiongrid': {
	        cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	            var $this = this;
	            var grid = $this.getStaffdetailsmanagetargetadmissiongrid();
	            var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureadmission');
	            var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	            if (e.target.tagName == 'DIV') {
	            	if (columnName == "addButton") {
	            		if (e.target.className == "addButtonClsForGridActionCls") {
	            			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	            				var serialNo;
	            				if (grid.getStore() != null)
	            					serialNo = grid.getStore().getCount();
	            				this.addNewRowInStaffDetailsGrid(serialNo + 1, grid, getStaffStructure);
	            			}
	            		}
	            	} else if (columnName == "deleteButton") {
	            		if (e.target.className == "deleteButtonClsForGridActionCls") {
	            			var getStaffStructure = $this.getStaffdetailsmanagetargettabstructureadmission();
	            			var titleMessage = getAdmissionTranslation('STAFF_WISE_REGISTRATIONS_TARGETS');
	            			var MTBSGrid = $this.getManagetargetbystaffadmissiongrid();
	            			$this.deleteManageTargetStaffDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);
	            			
	            		}
	            	}
	            }
	        }
	    },
	    'programdetailsmanagetargetgrid': {
	        cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	            var $this = this;
	            var grid = $this.getProgramdetailsmanagetargetgrid();
	            var getStaffStructure = grid.up('programdetailsmanagetargettabstructure');
	            var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	            if (e.target.tagName == 'DIV') {
	            	if (columnName == "addButton") {
	            		if (e.target.className == "addButtonClsForGridActionCls") {
	            			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	            				var serialNo;
	            				if (grid.getStore() != null)
	            					serialNo = grid.getStore().getCount();
	            				this.addNewRowInProgramDetailsGrid(serialNo + 1, grid, getStaffStructure);
	            			}
	            		}
	            	} else if (columnName == "deleteButton") {
	            		if (e.target.className == "deleteButtonClsForGridActionCls") {
	            			var getStaffStructure = $this.getProgramdetailsmanagetargettabstructure();
	            			var titleMessage = getAdmissionTranslation('PROGRAM_TARGETS_DETAILS');
	            			var MTBSGrid = $this.getManagetargetbyqualificationsgrid();
	            			$this.deleteManageTargetProgramDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);
	            			
	            		}
	            	}
	            }
	        }
	    },
	    
	    'staffdetailsmanagetargetgrid': {
	        cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	            var $this = this;
	            var grid = $this.getStaffdetailsmanagetargetgrid();
	            var getStaffStructure = grid.up('staffdetailsmanagetargettabstructure');
	            var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	            if (e.target.tagName == 'DIV') {
	            	if (columnName == "addButton") {
	            		if (e.target.className == "addButtonClsForGridActionCls") {
	            			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	            				var serialNo;
	            				if (grid.getStore() != null)
	            					serialNo = grid.getStore().getCount();
	            				this.addNewRowInStaffDetailsGrid(serialNo + 1, grid, getStaffStructure);
	            			}
	            		}
	            	} else if (columnName == "deleteButton") {
	            		if (e.target.className == "deleteButtonClsForGridActionCls") {
	            			var getStaffStructure = $this.getStaffdetailsmanagetargettabstructure();
	            			var titleMessage = getAdmissionTranslation('STAFF_WISE_PRESENTATION_TARGETS');
	            			var MTBSGrid = $this.getManagetargetbystaffpresentationgrid();
	            			$this.deleteManageTargetStaffDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);
	            			
	            		}
	            	}
	            }
	        }
	    },
	    'staffdetailsmanageappointmentstargetgrid': {
	        cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	            var $this = this;
	            var grid = $this.getStaffdetailsmanageappointmentstargetgrid();
	            var getStaffStructure = grid.up('staffdetailsmanageappointmentstargettabstructure');
	            var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	            if (e.target.tagName == 'DIV') {
	            	if (columnName == "addButton") {
	            		if (e.target.className == "addButtonClsForGridActionCls") {
	            			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	            				var serialNo;
	            				if (grid.getStore() != null)
	            					serialNo = grid.getStore().getCount();
	            				this.addNewRowInStaffAppointmentsDetailsGrid(serialNo + 1);
	            			}
	            		}
	            	} else if (columnName == "deleteButton") {
	            		if (e.target.className == "deleteButtonClsForGridActionCls") {
	            			var getStaffStructure = $this.getStaffdetailsmanageappointmentstargettabstructure();
	            			var titleMessage = getAdmissionTranslation('STAFF_WISE_APPOINTMENTS_TARGET');
	            			var MTBSGrid = $this.getManagetargetbystaffappointmentsgrid();
	            			$this.deleteManageTargetStaffDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);
	            			
	            		}
	            	}
	            }
	        }
	    },
 		'staffdetailsmanagetargetstructure button[itemId=SaveBtn]':{
 			click: this.saveStaffDetailsManageTarget
		},
 		'staffdetailsmanageappointmentstargetstructure button[itemId=SaveBtn]':{
 			click: this.saveStaffAppointmentDetailsManageTarget
		},
		'staffdetailsmanagetargetapplicationstructure button[itemId=SaveBtn]':{
 			click: this.saveStaffDetailsManageTargetApplication
		},
		'staffdetailsmanagetargetadmissionstructure button[itemId=SaveBtn]':{
 			click: this.saveStaffDetailsManageTargetAdmission
		},
		'programdetailsmanagetargetstructure button[itemId=SaveBtn]':{
 			click: this.saveQualificationDetailsManageTargetAdmission
		},
		
		'staffdetailsmanagetargetenquirygrid button[itemId=btnAdd]':{
			click: function(button) {
				var grid = this.getStaffdetailsmanagetargetenquirygrid();
		        var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureenquiry');
				this.addNewRowInStaffDetailsGrid(1, grid, getStaffStructure);
			}
		},
	    'staffdetailsmanagetargetenquirygrid': {
	        cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	            var $this = this;
	            var grid = $this.getStaffdetailsmanagetargetenquirygrid();
	            var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureenquiry');
	            var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	            if (e.target.tagName == 'DIV') {
	            	if (columnName == "addButton") {
	            		if (e.target.className == "addButtonClsForGridActionCls") {
	            			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	            				var serialNo;
	            				if (grid.getStore() != null)
	            					serialNo = grid.getStore().getCount();
	            				this.addNewRowInStaffDetailsGrid(serialNo + 1, grid, getStaffStructure);
	            			}
	            		}
	            	} else if (columnName == "deleteButton") {
	            		if (e.target.className == "deleteButtonClsForGridActionCls") {
	                       	var getStaffStructure = $this.getStaffdetailsmanagetargettabstructureenquiry();
	                       	var titleMessage = getAdmissionTranslation('STAFF_WISE_ENQUIRY_TARGETS');
	                       	var MTBSGrid = $this.getManagetargetbystaffenquirygrid();
	                       	$this.deleteManageTargetStaffDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);
	                       	
	                       	}
	            		}
	            }
	        }
	    },
 		'staffdetailsmanagetargetenquirystructure button[itemId=SaveBtn]':{
 			click: this.saveStaffDetailsEnquiryManageTarget
		},
		'presentationleaddetailsmanagetargettabstructure button[itemId=SaveBtn]':{
			click: this.savePresentationLeadStaffDetails
		},
		'presentationleaddetailspadmsform button[itemId=searchBtnLeadDetailPadmsItemId]':{
			click: this.searchPresentationLeadPadmsRecord
		},
		'presentationleaddetailspadmsform button[itemId=resetBtnLeadDetailPadmsItemId]':{
			click: this.ResetPresentationLeadPadmsForm
		},
		'actualpresentationstargetpadmsgrid': {
			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				var $this =this;
				if(columnName == "campaignNewName"){
					if(e.target.tagName=='A'){
						var getController = Academia.app.getController('Academia.controller.campaignnew.CampaignNewController');
						$this.openCampaignViewStructure(record.data.campaignNewId,'VIEW',getController);
					}
				}
			}
		},
		'actualenquirytargetpadmsgrid': {
			cellclick : this.showEnquiryFromActualEnquiryTarget
		},
		'actualadmissiontargetpadmsgrid': {
			cellclick : this.showApplicationProfileActualApplicationTarget
		},
		'actualapplicationtargetpadmsgrid': {
			cellclick : this.showApplicationProfileActualApplicationTarget
		},
		'actualappointmentstargetpadmsgrid': {
			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				var $this =this;
				if(columnName == "enquiryCode"){
					if(e.target.tagName=='A'){
						$this.showEnquiryFromActualAppointmentEnquiryTarget(grid,td, cellIndex, record, tr, rowIndex, e, eOpts );
					}
				}
				if(columnName == "applicationCode"){
					if(e.target.tagName=='A'){
						$this.showApplicationProfileActualApplicationTarget(grid,td, cellIndex, record, tr, rowIndex, e, eOpts );
					}
				}
			}
		},
		'managetargetbyadmissionsoffergrid': {
			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				var $this =this;
				if(columnName == "staffCount"){
					if(e.target.tagName=='A'){
						$this.getOpenManageTargetByStaffDetails(grid,record,'ADMISSIONS_OFFER');
					}
				}
				if(columnName == "actualTargetAchived"){
					if(e.target.tagName=='A'){
						$this.getAdmissionsOfferOfferLetterAccepted(grid,record);
					}
				}
			}
		},
		'staffdetailsmanagetargetadmissionoffergrid button[itemId=btnAdd]':{
			click: function(button) {
				var grid = this.getStaffdetailsmanagetargetadmissionoffergrid();
				var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureadmissionsoffer');
				this.addNewRowInStaffDetailsGrid(1, grid, getStaffStructure);
			}
		},
		'staffdetailsmanagetargetadmissionoffergrid': {
			cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
				var grid = this.getStaffdetailsmanagetargetadmissionoffergrid();
				var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureadmissionsoffer');
				var columnName = grid.columnManager.columns[cellIndex].dataIndex;

				if (e.target.tagName == 'DIV') {
					if (columnName == "addButton") {
						if (e.target.className == "addButtonClsForGridActionCls") {
							if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
								var serialNo;
								if (grid.getStore() != null)
									serialNo = grid.getStore().getCount();
								this.addNewRowInStaffDetailsGrid(1+serialNo, grid, getStaffStructure);
							}
						}
					} else if (columnName == "deleteButton") {
						if (e.target.className == "deleteButtonClsForGridActionCls") {
							var getStaffStructure = this.getStaffdetailsmanagetargettabstructureadmissionsoffer();
							var titleMessage = getAdmissionTranslation('Staff detail');
							var MTBSGrid = this.getManagetargetbyadmissionsoffergrid();
							this.deleteManageTargetStaffDetails(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid);

						}
					}
				}
			}
		},
		'staffdetailsmanagetargetadmissionsofferstructure button[itemId=SaveBtn]':{
 			click: this.saveStaffDetailsManageTargetAdmissioinsOffer
		},	
		'actualadmissionsofferapplicantcountgrid': {
			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				var $this =this;
				if(columnName == "applicationCode"){
					if(e.target.tagName=='A'){
						$this.showApplicationProfileActualAdmissionOffer(grid,td, cellIndex, record, tr, rowIndex, e, eOpts );
					}
				}
			}
		},
		'managetargetstructure':{
			afterrender: function(structure) {
        		var $this = this;
        		 structure.body.on('scroll', function(e, target) {
        		var manageTargetGrid =   $this.getManagetargetgrid();
        		var manageTargetALGrid =  $this.getManagetargetacademylocationwisegrid();
        		var manageTargetAWGrid =  $this.getManagetargetacademywisegrid();
        		var manageTargetPGWGrid =  $this.getManagetargetprogramgroupwisegrid();

        		var grid = null;
        		if(!manageTargetGrid.isHidden()){
        			grid = $this.getManagetargetgrid();
        		}
        		if(!manageTargetALGrid.isHidden()){
        			grid = $this.getManagetargetacademylocationwisegrid();
        		}
        		if(!manageTargetAWGrid.isHidden()){
        			grid = $this.getManagetargetacademywisegrid();
        		}
        		if(!manageTargetPGWGrid.isHidden()){
        			grid = $this.getManagetargetprogramgroupwisegrid();
        		} 
        		 if(grid!=null){
					 $this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
				 }
			 });
			}	
		}
        });
    },
    loadProgramCombo: function() {
        $this = this;
        var filter = $this.getManagetargetfilter();

        var academyLocationItemId = filter.down('#multiselectAcademyId');        
        var multiselectAcademyIdField = filter.down('#multiselectAcademyId');
        var academyIdsArray = multiselectAcademyIdField.getValue();
    	
        if(!isNullOrEmpty(academyIdsArray) && !isNullOrEmpty(academyIdsArray[0])) {
    	if(typeof academyIdsArray[0]!="object"){
    		var academyIds = academyIdsArray.join(',');
    	}
    	else {
    		var academyIdsTempArray = [];
    		Ext.each(academyIdsArray,function(currentAcademyId){
    			academyIdsTempArray.push(currentAcademyId.data.id);
    		});
    		var academyIds = academyIdsTempArray.join(',');
    	}
        }
        
        
        var programGroupItemId = filter.down('#programGroupItemId');
        var intakeYearItemId = filter.down('#intakeYearItemId');
        var programItemId = filter.down('#programItemId');
        programItemId.reset();
        var programStore = programItemId.getStore();
        programStore.getProxy().extraParams = {
            academyLocationIds: academyIds,
            programGroupId: programGroupItemId.getValue(),
            intakeYearId: intakeYearItemId.getValue()
        };
        programStore.load();

        if (!isNullOrEmpty(academyIdsArray)) {
            programItemId.setDisabled(false);
        }
        if (!isNullOrEmpty(academyLocationItemId.getValue())) {
            programItemId.setDisabled(false);
        }
        programItemId.reset();
        if (!isNullOrEmpty(academyIdsArray) && !isNullOrEmpty(academyIdsArray[0]) && !isNullOrEmpty(intakeYearItemId.getValue())) {
            programItemId.setDisabled(false);
        } else {
        	programItemId.setDisabled(true);
        }
       
        var batchItemId = filter.down("#batchItemId");
        batchItemId.setDisabled(true);
        batchItemId.reset();
    },
    loadManageTargetGrid: function(grid) {
    	var $this = this;
    	var filter = $this.getManagetargetfilter();
    	var viewTargetBy = filter.down('#viewTargetBy').getValue();
    	var programGroupId = filter.down('#programGroupItemId');
    	var programGroupWiseId = filter.down('#programGroupWiseId');
    	var intakeYearId = filter.down('#intakeYearItemId');
    	var programId = filter.down('#programItemId');
    	var batchId = filter.down("#batchItemId");
    	var saveBtnManageTargetGridItemId = grid.down("#saveBtnManageTargetGridItemId");
    	buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	pdftoolbar.setDisabled(false);
    	exceltoolbar.setDisabled(false);
    	filter.down('#searchBtnManageTargetFilterItemId').setDisabled(true);
    	var store = grid.getStore();
    	if(viewTargetBy == "ACADEMY_WISE"){
    		var multiselectAcademyWiseIdField = filter.down('#multiselectAcademyWiseId');
    		var academyWiseIdsArray = multiselectAcademyWiseIdField.getValue();
    		if(typeof academyWiseIdsArray[0]!="object"){
    			var academyWiseIds = academyWiseIdsArray.join(',');
    		}else {
    			var academyWiseIdsTempArray = [];
    			Ext.each(academyWiseIdsArray,function(currentAcademyWiseId){
    				academyWiseIdsTempArray.push(currentAcademyWiseId.data.id);
    			});
    			var academyWiseIds = academyWiseIdsTempArray.join(',');
    		}

    		store.getProxy().extraParams = {
    			academyIds: academyWiseIds,
    			intakeYearId: intakeYearId.getValue(),
    			viewBy:viewTargetBy
    		};
    		store.load({
				   callback: function(record, operation, success) {
				   filter.down('#searchBtnManageTargetFilterItemId').setDisabled(false);
					   if (record.length > 0) {
						   $this.toggleGridSummaryRow(grid,true);
					   }else{
						   $this.toggleGridSummaryRow(grid,false);
					   }
				   }
    		});
    	}else if(viewTargetBy == "ACADEMY_LOCATION_WISE"){
    		var multiselectAcademyIdField = filter.down('#multiselectAcademyId');
    		var academyIdsArray = multiselectAcademyIdField.getValue();
    		if(typeof academyIdsArray[0]!="object"){
    			var academyIds = academyIdsArray.join(',');
    		}else {
    			var academyIdsTempArray = [];
    			Ext.each(academyIdsArray,function(currentAcademyId){
    				academyIdsTempArray.push(currentAcademyId.data.id);
    			});
    			var academyIds = academyIdsTempArray.join(',');
    		}

    		store.getProxy().extraParams = {
    			academyLocationIds: academyIds,
    			intakeYearId: intakeYearId.getValue(),
    			viewBy:viewTargetBy
    		};
    		store.load({
				   callback: function(record, operation, success) {
					   filter.down('#searchBtnManageTargetFilterItemId').setDisabled(false);
					   if (record.length > 0) {
						   $this.toggleGridSummaryRow(grid,true);
					   }else{
						   $this.toggleGridSummaryRow(grid,false);
					   }
				   }
    		});
    	}else if(viewTargetBy == "PROGRAM_GROUP_WISE"){
    		var multiselectAcademyIdField = filter.down('#multiselectAcademyId');
    		var academyIdsArray = multiselectAcademyIdField.getValue();
    		if(typeof academyIdsArray[0]!="object"){
    			var academyIds = academyIdsArray.join(',');
    		}else {
    			var academyIdsTempArray = [];
    			Ext.each(academyIdsArray,function(currentAcademyId){
    				academyIdsTempArray.push(currentAcademyId.data.id);
    			});
    			var academyIds = academyIdsTempArray.join(',');
    		}
    		
    		var multiselectProgramGroupIdField = filter.down('#programGroupWiseId');
    		var programGroupIdsArray = multiselectProgramGroupIdField.getValue();
    		if(typeof programGroupIdsArray[0]!="object"){
    			var programGroupIds = programGroupIdsArray.join(',');
    		}else {
    			var programGroupIdsTempArray = [];
    			Ext.each(programGroupIdsArray,function(currentProgramGroupId){
    				programGroupIdsTempArray.push(currentProgramGroupId.data.id);
    			});
    			var programGroupIds = programGroupIdsTempArray.join(',');
    		}
    		
    		store.getProxy().extraParams = {
    			academyLocationIds: academyIds,
    			intakeYearId: intakeYearId.getValue(),
    			viewBy:viewTargetBy,
    			programGroupIds:programGroupIds
    		};
    		store.load({
				   callback: function(record, operation, success) {
					   filter.down('#searchBtnManageTargetFilterItemId').setDisabled(false);
					   if (record.length > 0) {
						   $this.toggleGridSummaryRow(grid,true);
					   }else{
						   $this.toggleGridSummaryRow(grid,false);
					   }
				   }
    		});
    	}else if(viewTargetBy == "PROGRAM_WISE"){
    		var multiselectAcademyIdField = filter.down('#multiselectAcademyId');
    		var academyIdsArray = multiselectAcademyIdField.getValue();
    		if(typeof academyIdsArray[0]!="object"){
    			var academyIds = academyIdsArray.join(',');
    		}else {
    			var academyIdsTempArray = [];
    			Ext.each(academyIdsArray,function(currentAcademyId){
    				academyIdsTempArray.push(currentAcademyId.data.id);
    			});
    			var academyIds = academyIdsTempArray.join(',');
    		}
    		store.getProxy().extraParams = {
    			academyLocationIds: academyIds,
    			programGroupId: programGroupId.getValue(),
    			intakeYearId: intakeYearId.getValue(),
    			programId: programId.getValue(),
    			batchId: batchId.getValue(),
    			viewBy:viewTargetBy
    		};
    		store.load({
    			callback: function(records, operation, success) {
    				 filter.down('#searchBtnManageTargetFilterItemId').setDisabled(false);
    				if (records.length == 0) {
    					saveBtnManageTargetGridItemId.setDisabled(true);
    				} else {
    					saveBtnManageTargetGridItemId.setDisabled(false);
    				}
    				if (records.length > 0) {
						   $this.toggleGridSummaryRow(grid,true);
					   }else{
						   $this.toggleGridSummaryRow(grid,false);
					   }
    			}
    		});
    	}
/***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	
    	grid.config.searchFilterForm = $this.getManagetargetfilter();
    	
/***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    loadDataChangedByAcademyLocation:function(obj){
    	var getForm = this.getManagetargetfilter();
    	var form = getForm.getForm();
    	getForm.down('#programGroupItemId').reset();
    	getForm.down('#programGroupWiseId').reset();
    	getForm.down('#programGroupWiseId').clearValue();
    	getForm.down('#programItemId').reset();
    	form.findField('batchId').reset();
    	form.findField('batchId').setDisabled(true);
    	var multiselectAcademyIdField = getForm.down('#multiselectAcademyId');
    	var intakeYearItemIdField = getForm.down('#intakeYearItemId');
    	var academyIdsArray = multiselectAcademyIdField.getValue();
    	if(Ext.isDefined(academyIdsArray)){
    		if(typeof academyIdsArray[0]!="object"){
        		var academyIds = academyIdsArray.join(',');
        	}
        	else {
        		var academyIdsTempArray = [];
        		Ext.each(academyIdsArray,function(currentAcademyId){
        			academyIdsTempArray.push(currentAcademyId.data.id);
        		});
        		var academyIds = academyIdsTempArray.join(',');
        	}
    	}
    	
    	if (!isNullOrEmpty(academyIds) && !isNullOrEmpty(intakeYearItemIdField.getValue())) {
    		getForm.down('#programItemId').setDisabled(false);
        } else {
        	getForm.down('#programItemId').setDisabled(true);
        }
    	
    	var programStore = getForm.down('#programGroupItemId').getStore();

    	programStore.getProxy().extraParams ={
    		academyLocationIds : academyIds,
    		intakeYearId:intakeYearItemIdField.getValue()
    	}
    	programStore.load();
    	
    	if(!isNullOrEmpty(academyIds)){
    		var programWiseGroup = getForm.down('#programGroupWiseId');
        	var programGroupStore = programWiseGroup.getStore();

        	programGroupStore.getProxy().extraParams ={
        		academyLocationIds : academyIds,
        		intakeYearId:intakeYearItemIdField.getValue()
        	}
        	programGroupStore.load({
    			callback: function(record){
    				programWiseGroup.select(programWiseGroup.getStore().collect(programWiseGroup.valueField));
    			}
        	});	
    	}
    },
    manageTargetExportWin: function() {
    	var win = this.getManagetargetexportwindow();
		if(!win){
			win = Ext.widget('managetargetexportwindow');
		}
		win.show();
    },
    exportXLFunction:function(model, records){
	   var reportTypeValue = 'EXPORT_MANAGE_TARGET_REPORT_BY_ACADEMY';
	   var win = this.getManagetargetexportwindow();
	   
	   var academyId;
	   var academyLocationId;
	   var programGroupId;
	   
	   $this = this;
       var filter = $this.getManagetargetfilter();
       var intakeYearItemCombo = filter.down('#intakeYearItemId');
	   
	   if( !isNullOrEmpty(win) ){
		  var formObj = win.down('form');
		  if( !isNullOrEmpty(formObj) ){
			  var form = formObj.getForm();
			  if( !isNullOrEmpty(form) ){
				  var academyCombo = form.findField('academyId');
				  if( !isNullOrEmpty(academyCombo) ){
					  academyId = academyCombo.getValue();
				  }
	  
				  var academyLocationCombo = form.findField('academyLocationId');
				  if( !isNullOrEmpty(academyLocationCombo) ){
					  academyLocationId = academyLocationCombo.getValue();
				  }
	  
				  var programGroupCombo = form.findField('programGroupId');
				  if( !isNullOrEmpty(programGroupCombo) ){
					  programGroupId = programGroupCombo.getValue();
				  }
			  }
		  }
	    }
 	   
		var $this = this;
		var code = reportTypeValue;
		var reportParams = new Object();
		reportParams.code = code;
		reportParams.reportTitle = 'Manage Target Report';
		
		reportParams.academyId = academyId;
		reportParams.academyLocationId = academyLocationId;
		reportParams.programGroupId = programGroupId;
		reportParams.intakeYearId = intakeYearItemCombo.getValue();
		
		reportParams.headerName = 'Manage Target Report';
		var reportTitle="";
		$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.EXPORT_MANAGE_TARGET_REPORT);
		
		$this.getManagetargetexportwindow().close();
    },
    disableExportButtonsByPivileges: function(grid, permissionsMap) {

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

    	var privilegeList = permissionList;
    	var gridReference = grid;

    	buttonsToolBar = gridReference.query('toolbar')[0];
    	/*
    	 * querying the buttons and unhiding them if any.
    	 */
    	var buttons = buttonsToolBar.query('button');
    	Ext.each(buttons, function(button) {
    		//if(button.itemId != 'saveBtnManageTargetGridItemId'){
    		button.setVisible(false);
    		//}
    	});
    	Ext.each(privilegeList, function(privilege) {
    		if (privilege === 'EXPORT') {
    			var buttonsArray = new Array();
    			buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
    			buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
    			buttonsArray.push(buttonsToolBar.query('#btnExportToCSV')[0]);
    			Ext.each(buttonsArray, function(button) {
    				if(!isNullOrEmpty(button)){
    					button.setVisible(true);
    				}  
    			});
    		}else if (privilege === 'EXPORTREPORTS') {
    			var button = buttonsToolBar.query('#exportReportItemId')[0];
    			if(!isNullOrEmpty(button)){
    				button.setVisible(true);
    			}  
    		}else if (privilege === 'CREATE') {
    			var button = buttonsToolBar.query('#saveBtnManageTargetGridItemId')[0];
    			if(!isNullOrEmpty(button)){
    				button.setVisible(true);
    			}  
    		}
    	});
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	pdftoolbar.setDisabled(true);
    	exceltoolbar.setDisabled(true);

    	var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
    	var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
    	pdfAllBtn.setVisible(false);
    	excelAllBtn.setVisible(false);
    },
    disableExportButtonsByPivilegesForALWiseGrid: function(grid, permissionsMap) {

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

    	var privilegeList = permissionList;
    	var gridReference = grid;

    	buttonsToolBar = gridReference.query('toolbar')[0];
    	/*
    	 * querying the buttons and unhiding them if any.
    	 */
    	var buttons = buttonsToolBar.query('button');
    	Ext.each(buttons, function(button) {
    		if(button.itemId != 'saveBtnManageTargetGridALWiseItemId'){
    		  button.setVisible(false);
    		}
    	});
    	Ext.each(privilegeList, function(privilege) {
    		if (privilege === 'EXPORT') {
    			var buttonsArray = new Array();
    			buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
    			buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
    			buttonsArray.push(buttonsToolBar.query('#btnExportToCSV')[0]);
    			Ext.each(buttonsArray, function(button) {
    				if(!isNullOrEmpty(button)){
    					button.setVisible(true);
    				}  
    			});
    		}else if (privilege === 'EXPORTREPORTS') {
    			var button = buttonsToolBar.query('#exportReportItemId')[0];
    			if(!isNullOrEmpty(button)){
    				button.setVisible(true);
    			}  
    		}else if (privilege === 'CREATE') {
    			var button = buttonsToolBar.query('#saveBtnManageTargetGridItemId')[0];
    			if(!isNullOrEmpty(button)){
    				button.setVisible(true);
    			}  
    		}
    	});
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	pdftoolbar.setDisabled(true);
    	exceltoolbar.setDisabled(true);

    	var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
    	var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
    	pdfAllBtn.setVisible(false);
    	excelAllBtn.setVisible(false);
    },
    //*********************** Manage Target Grids******************************
    getShowAndHideManageTargetList : function(obj,record,indexSponsor,fromLink){

    	if( isNullOrEmpty(indexSponsor) ){
    		indexSponsor = 0;
    	}
    	var manageTargetStructure = this.getManagetargettabstructure();
    	var form = this.getManagetargetfilter();
    	var viewTargetBy = form.down('#viewTargetBy').getValue();
    	var programGroupItemId = form.down('#programGroupItemId');
    	var programGroupWiseId = form.down('#programGroupWiseId');
    	var programItemId = form.down('#programItemId');
    	var batchItemId = form.down('#batchItemId');
    	var multiselectAcademyId = form.down('#multiselectAcademyId');
    	var multiselectAcademyWiseId = form.down('#multiselectAcademyWiseId');
    	
    	manageTargetStructure.down("#managetargetgridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetgridItemId").getStore().removeAll();
    	$this.toggleGridSummaryRow(manageTargetStructure.down("#managetargetgridItemId"),false);
    	manageTargetStructure.down("#managetargetacademylocationwisegrid").setVisible(false);
    	manageTargetStructure.down("#managetargetacademylocationwisegrid").getStore().removeAll();
    	$this.toggleGridSummaryRow(manageTargetStructure.down("#managetargetacademylocationwisegrid"),false);
    	manageTargetStructure.down("#managetargetacademywisegrid").setVisible(false);
    	manageTargetStructure.down("#managetargetacademywisegrid").getStore().removeAll();
    	$this.toggleGridSummaryRow(manageTargetStructure.down("#managetargetacademywisegrid"),false);
    	manageTargetStructure.down("#managetargetprogramgroupwisegrid").setVisible(false);
    	manageTargetStructure.down("#managetargetprogramgroupwisegrid").getStore().removeAll();
    	$this.toggleGridSummaryRow(manageTargetStructure.down("#managetargetprogramgroupwisegrid"),false);

    	if(viewTargetBy=="ACADEMY_WISE"){
    		multiselectAcademyWiseId.getStore().load();
    		manageTargetStructure.down("#managetargetacademywisegrid").setVisible(true);
    		multiselectAcademyId.setVisible(false);
    		multiselectAcademyWiseId.setVisible(true);
    		this.setAllowBlank (multiselectAcademyId,true);
    		this.setAllowBlank (multiselectAcademyWiseId,false);
    		programGroupItemId.setVisible(false);
    		programItemId.setVisible(false);
    		batchItemId.setVisible(false);
    		programGroupWiseId.setVisible(false);
    		this.setAllowBlank (programGroupWiseId,true);
    	}
    	if(viewTargetBy=="ACADEMY_LOCATION_WISE"){
    		manageTargetStructure.down("#managetargetacademylocationwisegrid").setVisible(true);
    		multiselectAcademyId.setVisible(true);
    		this.setAllowBlank (multiselectAcademyId,false);
    		multiselectAcademyWiseId.setVisible(false);
    		programGroupItemId.setVisible(false);
    		programItemId.setVisible(false);
    		batchItemId.setVisible(false);
    		programGroupWiseId.setVisible(false);
    		this.setAllowBlank (programGroupWiseId,true);
    		this.setAllowBlank (multiselectAcademyWiseId,true);
    		
    	}
    	if(viewTargetBy=="PROGRAM_GROUP_WISE"){
    		manageTargetStructure.down("#managetargetprogramgroupwisegrid").setVisible(true);
    		multiselectAcademyId.setVisible(true);
    		this.setAllowBlank (multiselectAcademyId,false);
    		multiselectAcademyWiseId.setVisible(false);
    		this.setAllowBlank (multiselectAcademyWiseId,true);
    		programGroupItemId.setVisible(false);
    		programItemId.setVisible(false);
    		batchItemId.setVisible(false);
    		programGroupWiseId.setVisible(true);
    		this.setAllowBlank (programGroupWiseId,false);
    		
    	}
    	if(viewTargetBy=="PROGRAM_WISE"){
    		manageTargetStructure.down("#managetargetgridItemId").setVisible(true);
    		multiselectAcademyId.setVisible(true);
    		this.setAllowBlank (multiselectAcademyId,false);
    		multiselectAcademyWiseId.setVisible(false);
    		this.setAllowBlank (multiselectAcademyWiseId,true);
    		programGroupItemId.setVisible(true);
    		programItemId.setVisible(true);
    		batchItemId.setVisible(true);
    		programGroupWiseId.setVisible(false);
    		this.setAllowBlank (programGroupWiseId,true);
    	}
    	form.isValid();

    },
    loadManageTargetByStaffGrid: function(grid,viewTargetBy) {
    	var $this = this;
    	var filter = $this.getManagetargetbystafffilter();
    	var intakeYearId = filter.down('#intakeYearStaffItemId');
    	var modeOfDeliveryIds = filter.down('#modeDeliveryId');
        var registrationType = filter.down('#registrationTypeId');
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	var saveBtn=buttonsToolBar.query('#SaveBtn')[0];
    	var store = grid.getStore();
    	var multiselectAcademyWiseIdField = filter.down('#multiselectTargetByStaffAcademyId');
    	var academyWiseIdsArray = multiselectAcademyWiseIdField.getValue();
    	if(typeof academyWiseIdsArray[0]!="object"){
    		var academyWiseIds = academyWiseIdsArray.join(',');
    	}else {
    		var academyWiseIdsTempArray = [];
    		Ext.each(academyWiseIdsArray,function(currentAcademyWiseId){
    			academyWiseIdsTempArray.push(currentAcademyWiseId.data.id);
    		});
    		var academyWiseIds = academyWiseIdsTempArray.join(',');
    	}
    	   var multiSelectModeOfDeliveryField = filter.down('#modeDeliveryId');
    		var registrationTypeValue ;
    	  if(!isNullOrEmpty(registrationType.getValue()) ){
			  if(registrationType.getValue()=='PART_TIME'){
				  registrationTypeValue = true;  
			  }else if(registrationType.getValue()=='FULL_TIME'){
				  registrationTypeValue = false;
			  }
		  }
    	  var multiselectProgramGrpIdField = filter.down('#ProgramGroupId');
      	var programGrpIdsArray = multiselectProgramGrpIdField.getValue();
      		var programGrpIdsTempArray = [];
      		Ext.each(programGrpIdsArray,function(programGrpIds){
      			if(!isNullOrEmpty(programGrpIds)){
      			programGrpIdsTempArray.push(programGrpIds.data.id);
      			}
      		});
      		var programGrpIds = programGrpIdsTempArray.join(',');
      	     		
    	store.getProxy().extraParams = {
    		academyLocationIds: academyWiseIds,
    		intakeYearId: intakeYearId.getValue(),
    		manageTargetType:viewTargetBy,
    		modeOfDeliveryId:modeOfDeliveryIds.getValue(),
    		registrationType:registrationTypeValue,
    		programGroupIds:programGrpIds
    	};
    	 if(isNullOrEmpty(registrationType.getValue()))
		  {
    		 delete store.getProxy().extraParams.registrationType;
		  }
    	 if(isNullOrEmpty(programGrpIds))
		  {
   		 delete store.getProxy().extraParams.programGroupIds;
		  }
    	store.load({
	    	  callback: function(records, operation, success) {
					if(records.length>0){
						saveBtn && saveBtn.setDisabled(false);
				    	pdftoolbar.setDisabled(false);
				    	exceltoolbar.setDisabled(false);
					}
				  }
		       
			  });
    	
    	/***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	
    	grid.config.searchFilterForm = $this.getManagetargetbystafffilter();
    	
    	/***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    // ********Open New Tab for Staff Details **********
    getOpenManageTargetByStaffDetails : function(grid,record,targetType){
    	var $this = this;
    	var contentPanel = $this.getManagetargetbystaffstructure();
    	var tabName = getAdmissionTranslation('STAFF_DETAILS');
    	var contentXtype ='staffdetailsmanagetargetstructure';
    	if( targetType == 'PRESENTATIONS' ){
    		contentXtype ='staffdetailsmanagetargetstructure';
    	}
    	if( targetType == 'ENQUIRY' ){
    		contentXtype ='staffdetailsmanagetargetenquirystructure';
    	}
    	if( targetType == 'APPLICATIONS' ){
    		contentXtype ='staffdetailsmanagetargetapplicationstructure';
    	}
    	if( targetType == 'APPOINTMENTS' ){
    		contentXtype ='staffdetailsmanageappointmentstargetstructure';
    	}
    	if( targetType == 'ADMISSIONS' ){
    		contentXtype ='staffdetailsmanagetargetadmissionstructure';
    	}
    	if( targetType == 'PROGRAMS' ){
    		contentXtype ='programdetailsmanagetargetstructure';
    		record.data.manageTargetType = 'PROGRAMS';
    		tabName = getAdmissionTranslation('PROGRAM_TARGETS_DETAILS');
    	}
    	if( targetType == 'ADMISSIONS_OFFER' ){
    		contentXtype ='staffdetailsmanagetargetadmissionsofferstructure';
    	}
    	var getTab = null;
		for(var i =0 ;i<contentPanel.items.length;i++){
			if(contentPanel.items.items[i].title == tabName){
				getTab= contentPanel.items.items[i];
			}
		}
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
		var newTab = $this.getTabReferenceByTabTitle(tabName);
		if(!newTab){
    		newTab = contentPanel.add({
    			xtype: contentXtype,
    			closable: true,
    			title: tabName,
    			menuColorCls: CONSTANTS.MENU_COLOR_ONE
    		});
    	}
    	contentPanel.setActiveTab(newTab);
    	var getStaffStructure = $this.getStaffdetailsmanagetargettabstructure();
    	if( targetType == 'PRESENTATIONS' ){
    		getStaffStructure = $this.getStaffdetailsmanagetargettabstructure();
   	    }
   	    if( targetType == 'ENQUIRY' ){
   	    	getStaffStructure = $this.getStaffdetailsmanagetargettabstructureenquiry();
   	    }
   	    if( targetType == 'APPLICATIONS' ){
   	    	getStaffStructure = $this.getStaffdetailsmanagetargettabstructureapplication();
   	    }
   	    if( targetType == 'APPOINTMENTS' ){
   	    	getStaffStructure =$this.getStaffdetailsmanageappointmentstargettabstructure();
   	    }
   	    if( targetType == 'ADMISSIONS' ){
   	    	getStaffStructure = $this.getStaffdetailsmanagetargettabstructureadmission();
   	    }
   	    if( targetType == 'PROGRAMS' ){
   	    	getStaffStructure = $this.getProgramdetailsmanagetargettabstructure();
   	    	getStaffStructure.down('#academyName').setValue(record.data.academyName);
   	    	getStaffStructure.down('#locationName').setValue(record.data.locationName);
   	    	getStaffStructure.down('#intakeYearName').setValue(record.data.intakeYearName);
   	    }
   	    if( targetType == 'ADMISSIONS_OFFER' ){
   	    	getStaffStructure = $this.getStaffdetailsmanagetargettabstructureadmissionsoffer();
   	    }
   	    
    	getStaffStructure.down('#academyLocationId').setValue(record.data.academyLocationId);
    	getStaffStructure.down('#intakeYearId').setValue(record.data.intakeYearId);
    	getStaffStructure.down('#manageTargetType').setValue(record.data.manageTargetType);
    	getStaffStructure.down('#modeOfDeliveryId').setValue(record.data.modeOfDeliveryId);
    	getStaffStructure.down('#registrationType').setValue(record.data.registrationType);
    	getStaffStructure.up().down('#SaveBtn').setDisabled(true);
    	var getStaffGrid = $this.getStaffdetailsmanagetargetgrid();
    	if( targetType == 'PRESENTATIONS' ){
    		getStaffGrid = $this.getStaffdetailsmanagetargetgrid();
   	    }
   	    if( targetType == 'ENQUIRY' ){
   	    	getStaffGrid = $this.getStaffdetailsmanagetargetenquirygrid();
   	    }
   	    if( targetType == 'APPLICATIONS' ){
   	    	getStaffGrid = $this.getStaffdetailsmanagetargetapplicationgrid();
   	    }
   	    if( targetType == 'APPOINTMENTS' ){
	    	getStaffGrid = $this.getStaffdetailsmanageappointmentstargetgrid();
	    }
   	    if( targetType == 'ADMISSIONS' ){
   	    	getStaffGrid = $this.getStaffdetailsmanagetargetadmissiongrid();
   	    }
   	    if( targetType == 'ADMISSIONS_OFFER' ){
   	    	getStaffGrid = $this.getStaffdetailsmanagetargetadmissionoffergrid();
   	    }
   	    if( targetType == 'PROGRAMS' ){
   	    	getStaffGrid = $this.getProgramdetailsmanagetargetgrid();
   	     buttonsToolBar = getStaffGrid.query('toolbar')[0];
		 var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
		 var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];

		 var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
		 var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
		 pdfAllBtn.setVisible(false);
		 excelAllBtn.setVisible(false);
   	    	getStaffGrid.getStore().removeAll();
   	    	if(!isNullOrEmpty(record.data.programCount)){
   	    		Ext.Ajax.request({
   					type: 'rest',
   					url: SERVERURL.PATH_MANAGE_TARGET_QUALIFICATION_GRID_DATA,
   					method: "GET",
   					params:{
   						academyLocationIds:record.data.academyLocationId,
   						intakeYearId:record.data.intakeYearId,
   						manageTargetType:targetType,
   						registrationType:record.data.registrationType,
						modeOfDeliveryId:record.data.modeOfDeliveryId
   					},
   					success: function(frm, action) {
   						Ext.getBody().unmask();
   						//var data = frm.responseText;
   						var data = Ext.JSON.decode(frm.responseText);
   						getStaffGrid.getStore().loadData(data);
   					}
   				});
   	    		getStaffGrid.down('#btnAdd').hide();
   	        	getStaffStructure.up().down('#SaveBtn').setDisabled(false);
   	    	}else{
   	    		
   	    	}
   	    	
   	    	var programIdCombo = getStaffGrid.columns[5].getEditor();
   	    	programIdCombo.getStore().getProxy().extraParams = {
   	    		academyLocationIds: record.data.academyLocationId,
   	    		intakeYearId: record.data.intakeYearId,
   	    		registrationType:record.data.registrationType,
				modeOfDeliveryId:record.data.modeOfDeliveryId
   	    	};
   	    	programIdCombo.getStore().load();
   	    	
	    } else {
	    	 buttonsToolBar = getStaffGrid.query('toolbar')[0];
			 var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
			 var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];

			 var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
			 var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
			 pdfAllBtn.setVisible(false);
			 excelAllBtn.setVisible(false);
			 
	    	getStaffGrid.getStore().removeAll();
	    	if(!isNullOrEmpty(record.data.staffCount)){
	    		Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH__MANAGE_TARGET_STAFF_GRID_DATA,
					method: "GET",
					params:{
						academyLocationIds:record.data.academyLocationId,
						intakeYearId:record.data.intakeYearId,
						manageTargetType:targetType,
						registrationType:record.data.registrationType,
						modeOfDeliveryId:record.data.modeOfDeliveryId
					},
					success: function(frm, action) {
						Ext.getBody().unmask();
						//var data = frm.responseText;
						var data = Ext.JSON.decode(frm.responseText);
						getStaffGrid.getStore().loadData(data);
					}
				});
	    		getStaffGrid.down('#btnAdd').hide();
	        	getStaffStructure.up().down('#SaveBtn').setDisabled(false);
	    	}
	    	
	    	var StaffIdCombo = getStaffGrid.columns[0].getEditor();
	    	StaffIdCombo.getStore().getProxy().extraParams = {
	    		academyLocationIds: record.data.academyLocationId
	    	};
	    	StaffIdCombo.getStore().load();
	    }
    	
    },
    addNewRowInStaffDetailsGrid: function(serialNo, grid, getStaffStructure) {
        var $this = this;
        //var grid = $this.getStaffdetailsmanagetargetgrid();
        //var getStaffStructure = grid.up('staffdetailsmanagetargettabstructure');
        var ObjModel = [];
        var staffDetailsManageTargetGridModel = new Academia.model.managetarget.StaffDetailsManageTargetGridModel();
        staffDetailsManageTargetGridModel.set("serialNo", serialNo);
        staffDetailsManageTargetGridModel.set("staffId", '');
        staffDetailsManageTargetGridModel.set("actualTarget", '');
        staffDetailsManageTargetGridModel.set("actualTargetAchived", '');
        staffDetailsManageTargetGridModel.set("percentageTargetAchieved", '');
        staffDetailsManageTargetGridModel.set("targetVariance", '');
        staffDetailsManageTargetGridModel.set("isEditable", 'ADD');
        staffDetailsManageTargetGridModel.set("isAddDeleteRow", true);
        var modeOfDeliveryId;
        var modeOfDeliveryFieldValue = getStaffStructure.down('#modeOfDeliveryId').getValue();
        if(!isNullOrEmpty(modeOfDeliveryFieldValue)) {
        	if(isNaN(modeOfDeliveryFieldValue)==false) {
        		modeOfDeliveryId = parseInt(modeOfDeliveryFieldValue);
        	}
        }
        staffDetailsManageTargetGridModel.set("modeOfDelivery", modeOfDeliveryId);
        var registrationTypeValue;
        if(!isNullOrEmpty(getStaffStructure.down('#registrationType').getValue())) {
	        if(getStaffStructure.down('#registrationType').getValue()==true || getStaffStructure.down('#registrationType').getValue()=='true') {
	        	registrationTypeValue='PART_TIME';
	        } else {
	        	registrationTypeValue='FULL_TIME';
	        }
        }
        staffDetailsManageTargetGridModel.set("registrationType", registrationTypeValue);
        ObjModel.push(staffDetailsManageTargetGridModel);
        grid.getStore().loadRawData(ObjModel, true);
        
    	grid.getStore().totalCount = grid.getStore().count();
    	grid.getView().refresh();
        
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        	getStaffStructure.up().down('#SaveBtn').setDisabled(false);
        }
    },
    addNewRowInProgramDetailsGrid: function(serialNo, grid, getStaffStructure) {
        var $this = this;
        //var grid = $this.getStaffdetailsmanagetargetgrid();
        //var getStaffStructure = grid.up('staffdetailsmanagetargettabstructure');
        var ObjModel = [];
        var staffDetailsManageTargetGridModel = new Academia.model.managetarget.ManageTargetByQualificationModel();
        
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var academyName = getStaffStructure.down('#academyName').getValue();
    	var locationName = getStaffStructure.down('#locationName').getValue();
    	var intakeYearName = getStaffStructure.down('#intakeYearName').getValue();
        
        staffDetailsManageTargetGridModel.set("serialNo", serialNo);
        
        staffDetailsManageTargetGridModel.set("academyLocationId", academyLocationId);
        staffDetailsManageTargetGridModel.set("academyName", academyName);
        staffDetailsManageTargetGridModel.set("locationName", locationName);
        staffDetailsManageTargetGridModel.set("intakeYearName", intakeYearName);
        staffDetailsManageTargetGridModel.set("intakeYearId", '');
        
        staffDetailsManageTargetGridModel.set("programId", '');
        staffDetailsManageTargetGridModel.set("actualRegistrationTarget", '');
        staffDetailsManageTargetGridModel.set("actualRegistrationTargetAchived", '');
        staffDetailsManageTargetGridModel.set("percentageRegistrationTarget", '');
        staffDetailsManageTargetGridModel.set("registrationTargetVariance", '');
        
        staffDetailsManageTargetGridModel.set("actualApplicationTarget", '');
        staffDetailsManageTargetGridModel.set("actualApplicationTargetAchived", '');
        staffDetailsManageTargetGridModel.set("percentageApplicationTarget", '');
        staffDetailsManageTargetGridModel.set("applicationTargetVariance", '');
        
        staffDetailsManageTargetGridModel.set("actualEnquiryTarget", '');
        staffDetailsManageTargetGridModel.set("actualEnquiryTargetAchived", '');
        staffDetailsManageTargetGridModel.set("percentageEnquiryTarget", '');
        staffDetailsManageTargetGridModel.set("enquiryTargetVariance", '');
        
        staffDetailsManageTargetGridModel.set("isEditable", 'ADD');
        staffDetailsManageTargetGridModel.set("isAddDeleteRow", true);
        var modeOfDeliveryId;
        var modeOfDeliveryFieldValue = getStaffStructure.down('#modeOfDeliveryId').getValue();
        if(!isNullOrEmpty(modeOfDeliveryFieldValue)) {
        	if(isNaN(modeOfDeliveryFieldValue)==false) {
        		modeOfDeliveryId = parseInt(modeOfDeliveryFieldValue);
        	}
        }
        staffDetailsManageTargetGridModel.set("modeOfDelivery", modeOfDeliveryId);
        var registrationTypeValue;
        if(!isNullOrEmpty(getStaffStructure.down('#registrationType').getValue())) {
	        if(getStaffStructure.down('#registrationType').getValue()==true || getStaffStructure.down('#registrationType').getValue()=='true') {
	        	registrationTypeValue='PART_TIME';
	        } else {
	        	registrationTypeValue='FULL_TIME';
	        }
        }
        staffDetailsManageTargetGridModel.set("registrationType", registrationTypeValue);
        ObjModel.push(staffDetailsManageTargetGridModel);
        grid.getStore().loadRawData(ObjModel, true);
        
        grid.getStore().totalCount = grid.getStore().count();
    	grid.getView().refresh();
    	
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        	getStaffStructure.up().down('#SaveBtn').setDisabled(false);
        }
    },
    addNewRowInStaffAppointmentsDetailsGrid: function(serialNo) {
        var $this = this;
        var grid = $this.getStaffdetailsmanageappointmentstargetgrid();
        var getStaffStructure = grid.up('staffdetailsmanageappointmentstargettabstructure');
        var ObjModel = [];
        var staffDetailsManageTargetGridModel = new Academia.model.managetarget.StaffDetailsManageTargetGridModel();
        staffDetailsManageTargetGridModel.set("serialNo", serialNo);
        staffDetailsManageTargetGridModel.set("salesStaff", '');
        staffDetailsManageTargetGridModel.set("salesStaffPresentiontarget", '');
        staffDetailsManageTargetGridModel.set("salesStaffActualPresentations", '');
        staffDetailsManageTargetGridModel.set("salesStaffPresentationsToTarget", '');
        staffDetailsManageTargetGridModel.set("salesStaffVariance", '');
        staffDetailsManageTargetGridModel.set("isEditable", 'ADD');
        staffDetailsManageTargetGridModel.set("isAddDeleteRow", true);
        var modeOfDeliveryId;
        var modeOfDeliveryFieldValue = getStaffStructure.down('#modeOfDeliveryId').getValue();
        if(!isNullOrEmpty(modeOfDeliveryFieldValue)) {
        	if(isNaN(modeOfDeliveryFieldValue)==false) {
        		modeOfDeliveryId = parseInt(modeOfDeliveryFieldValue);
        	}
        }
        staffDetailsManageTargetGridModel.set("modeOfDelivery", modeOfDeliveryId);
        var registrationTypeValue;
        if(!isNullOrEmpty(getStaffStructure.down('#registrationType').getValue())) {
	        if(getStaffStructure.down('#registrationType').getValue()==true || getStaffStructure.down('#registrationType').getValue()=='true') {
	        	registrationTypeValue='PART_TIME';
	        } else {
	        	registrationTypeValue='FULL_TIME';
	        }
        }
        staffDetailsManageTargetGridModel.set("registrationType", registrationTypeValue);
        ObjModel.push(staffDetailsManageTargetGridModel);
        grid.getStore().loadRawData(ObjModel, true);
        
        grid.getStore().totalCount = grid.getStore().count();
    	grid.getView().refresh();
    	
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        	getStaffStructure.up().down('#SaveBtn').setDisabled(false);
        }
    },
    //*********************** Manage Target By Staff Grids******************************
    getShowAndHideManageTargetByStaffList : function(obj,record,indexSponsor,fromLink){

    	if( isNullOrEmpty(indexSponsor) ){
    		indexSponsor = 0;
    	}
    	var manageTargetStructure = this.getManagetargetbystafftabstructure();
    	var form = this.getManagetargetbystafffilter();
    	var viewTargetBy = form.down('#viewTargetByStaff').getValue();
    	var multiselectAcademyId = form.down('#multiselectAcademyId');

    	manageTargetStructure.down("#managetargetbystaffpresentationgridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbystaffpresentationgridItemId").getStore().removeAll();
    	manageTargetStructure.down("#managetargetbystaffenquirygridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbystaffenquirygridItemId").getStore().removeAll();
    	manageTargetStructure.down("#managetargetbystaffapplicationgridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbystaffapplicationgridItemId").getStore().removeAll();
    	manageTargetStructure.down("#managetargetbystaffadmissiongridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbystaffadmissiongridItemId").getStore().removeAll();
    	manageTargetStructure.down("#managetargetbystaffappointmentsgridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbystaffappointmentsgridItemId").getStore().removeAll();
    	manageTargetStructure.down("#managetargetbyqualificationsgridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbyadmissionsoffergridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbyadmissionsoffergridItemId").getStore().removeAll();
    	manageTargetStructure.down("#managetargetbystaffapplicationforecastgridItemId").setVisible(false);
    	manageTargetStructure.down("#managetargetbystaffapplicationforecastgridItemId").getStore().removeAll();
    	//manageTargetStructure.down("#managetargetbyqualificationsgridItemId").getStore().removeAll();
    	var buttonsToolBar = null;
    	if(viewTargetBy=="PRESENTATIONS"){
    		manageTargetStructure.down("#managetargetbystaffpresentationgridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbystaffpresentationgridItemId").query('toolbar')[0];
    	}
    	if(viewTargetBy=="ENQUIRY"){
    		manageTargetStructure.down("#managetargetbystaffenquirygridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbystaffenquirygridItemId").query('toolbar')[0];
    	}
    	if(viewTargetBy=="APPOINTMENTS"){
    		manageTargetStructure.down("#managetargetbystaffappointmentsgridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbystaffappointmentsgridItemId").query('toolbar')[0];

    	}
    	if(viewTargetBy=="APPLICATIONS"){
    		manageTargetStructure.down("#managetargetbystaffapplicationgridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbystaffapplicationgridItemId").query('toolbar')[0];
    	}
    	if(viewTargetBy=="ADMISSIONS"){
    		manageTargetStructure.down("#managetargetbystaffadmissiongridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbystaffadmissiongridItemId").query('toolbar')[0];
    	}
    	if(viewTargetBy=="PROGRAMS"){
    		manageTargetStructure.down("#managetargetbyqualificationsgridItemId").setVisible(true);
    	    buttonsToolBar = manageTargetStructure.down("#managetargetbyqualificationsgridItemId").query('toolbar')[0];
    	}
    	if(viewTargetBy=="ADMISSIONS_OFFER"){
    		manageTargetStructure.down("#managetargetbyadmissionsoffergridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbyadmissionsoffergridItemId").query('toolbar')[0];
    	}
    	if(viewTargetBy=="APPLICATION_FORECAST"){
    		manageTargetStructure.down("#managetargetbystaffapplicationforecastgridItemId").setVisible(true);
    		buttonsToolBar = manageTargetStructure.down("#managetargetbystaffapplicationforecastgridItemId").query('toolbar')[0];
    	}
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	pdftoolbar.setDisabled(true);
    	exceltoolbar.setDisabled(true);

    },
    //********Open New Tab for Lead Details **********
    getOpenPresentationLeadDetailsGrid : function(grid,record){
 	  var $this = this;
 	  // var contentPanel = $this.getContentpanel(); 
 	   var contentPanel = $this.getManagetargetbystaffstructure();
 	   var tabName = getAdmissionTranslation('PRESENTATION_LEAD_DETAILS');
 	   var getTab = null;
		for(var i =0 ;i<contentPanel.items.length;i++){
			if(contentPanel.items.items[i].title == tabName){
				getTab= contentPanel.items.items[i];
			}
		}
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
 	   var contentXtype ='presentationleaddetailsmanagetargetstructure';
 	   var newTab = $this.getTabReferenceByTabTitle(tabName);
 	  if(!newTab){
  		newTab = contentPanel.add({
  			xtype: contentXtype,
  			closable: true,
  			title: tabName,
  			menuColorCls: CONSTANTS.MENU_COLOR_ONE
  		});
  	}
  	contentPanel.setActiveTab(newTab);
 	   var presentationStructure = $this.getPresentationleaddetailsmanagetargettabstructure();
 	   presentationStructure.down('#academyLocationId').setValue(record.data.academyLocationId);
 	   presentationStructure.down('#intakeYearId').setValue(record.data.intakeYearId);
 	   presentationStructure.down('#manageTargetType').setValue(record.data.manageTargetType);
 	   var presentationGrid =  presentationStructure.down('presentationleaddetailsmanagetargetgrid');
 	   presentationGrid.getStore().getProxy().extraParams = {
 		   academyLocationIds: record.data.academyLocationId,
 		   intakeYearId: record.data.intakeYearId,
 		   manageTargetType:'PRESENTATIONS'

 	   };
 	   presentationGrid.getStore().load({
 		   callback: function(records, operation, success) {
 			   if(records.length==0){
 				   presentationStructure.down('#SaveBtn').setDisabled(true);
 			   }
 		   }
 	   });
    },
    saveStaffDetailsManageTarget: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var staffDetailGrid = $this.getStaffdetailsmanagetargetgrid();
    	var MTBSGrid = $this.getManagetargetbystaffpresentationgrid();
    	var jsonStaffDetail = [];

    	var staffDetailGridStore = staffDetailGrid.getStore();
    	var getStaffStructure = staffDetailGrid.up('staffdetailsmanagetargettabstructure');
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
    	var flagIsSave = true;
    	if(staffDetailGridStore.getCount()>0){
    		staffDetailGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.staffId) || obj.data.staffId.length == 0) {
    				showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_SALES_STAFF'));
    				flagIsSave = false;
    				return false;
    			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.registrationType)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0) {
    				showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_SALES_STAFF_PRESENTATION_TARGET'));
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var value='';
    				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
    					value=true;
    				}else{
    					value=false;
    				}
    				var modeOfDelivery=null;
    				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
    					if(Ext.isObject(obj.data.modeOfDelivery)){
    						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
    					}else{
    						modeOfDelivery={"id":obj.data.modeOfDelivery};
    					}
    				}
    				var jsonObj = {
        					"id":obj.data.id,
        					"staffId":obj.data.staffId,
        					"actualTarget":obj.data.actualTarget,
        					"academyLocationId":academyLocationId,
        					"intakeYearId":intakeYearId,
        					"modeOfDelivery":modeOfDelivery,
        					"registrationType":value,
        					"manageTargetType": "PRESENTATIONS"
        					
        			}
    				jsonStaffDetail.push(jsonObj);
    				return true;
    			}
    		});
    		}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
    			jsonData: jsonStaffDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('STAFF_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				if(Ext.isDefined(MTBSGrid)){
    					MTBSGrid.getStore().load();	
    				}
    				showSuccessMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('STAFF_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    saveStaffDetailsManageTargetApplication: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var staffDetailGrid = $this.getStaffdetailsmanagetargetapplicationgrid();
    	var MTBSGrid = $this.getManagetargetbystaffapplicationgrid();
    	var jsonStaffDetail = [];

    	var staffDetailGridStore = staffDetailGrid.getStore();
    	var getStaffStructure = staffDetailGrid.up('staffdetailsmanagetargettabstructureapplication');
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
    	var toBeDeletedArray = getStaffStructure.down('#toBeDeletedArray').getValue();
    	var flagIsSave = true;
    	if(staffDetailGridStore.getCount()>0){
    		staffDetailGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.staffId) || obj.data.staffId.length == 0) {
    				showWarningMessage(getAdmissionTranslation('APPLICATIONS_STAFF_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_APPLICATIONS_STAFF'));
    				flagIsSave = false;
    				return false;
    			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.registrationType)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0) {
    				showWarningMessage(getAdmissionTranslation('APPLICATIONS_STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_APPLICATIONS_STAFF_TARGET'));
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var value='';
    				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
    					value=true;
    				}else{
    					value=false;
    				}
    				var modeOfDelivery=null;
    				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
    					if(Ext.isObject(obj.data.modeOfDelivery)){
    						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
    					}else{
    						modeOfDelivery={"id":obj.data.modeOfDelivery};
    					}
    				}
    				var jsonObj = {
        					"id":obj.data.id,
        					"staffId":obj.data.staffId,
        					"actualTarget":obj.data.actualTarget,
        					"academyLocationId":academyLocationId,
        					"intakeYearId":intakeYearId,
        					"modeOfDelivery":modeOfDelivery,
        					"registrationType":value,
        					"manageTargetType": "APPLICATIONS"
        					
        			}
    				jsonStaffDetail.push(jsonObj);
    				return true;
    			}
    		});
    		if( !isNullOrEmpty(toBeDeletedArray) ){
    			var nameArr = toBeDeletedArray.split(',');
    			for(index in nameArr){
    				var id = nameArr[index];
    				if( !isNullOrEmpty(id) ){
    					var jsonObjToBeDeleted = {
            					"id":parseInt(id),
            					"toBeDeleted":true,
            					"manageTargetType": "APPLICATIONS"
            			}
        				jsonStaffDetail.push(jsonObjToBeDeleted);
    				}
    			}
    		}
    		}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
    			jsonData: jsonStaffDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('STAFF_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				if(Ext.isDefined(MTBSGrid)){
    					MTBSGrid.getStore().load();	
    				}
    				showSuccessMessage(getAdmissionTranslation('APPLICATIONS_STAFF_DETAILS'), getAdmissionTranslation('STAFF_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    saveQualificationDetailsManageTargetAdmission: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var staffDetailGrid = $this.getProgramdetailsmanagetargetgrid();
    	var MTBSGrid = $this.getManagetargetbyqualificationsgrid();
    	var jsonStaffDetail = [];

    	var staffDetailGridStore = staffDetailGrid.getStore();
    	var getStaffStructure = staffDetailGrid.up('programdetailsmanagetargettabstructure');
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
    	//var toBeDeletedArray = getStaffStructure.down('#toBeDeletedArray').getValue();
    	var flagIsSave = true;
    	if(staffDetailGridStore.getCount()>0){
    		staffDetailGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.programId) || obj.data.programId.length == 0) {
    				showWarningMessage(getAdmissionTranslation('PROGRAM_TARGETS_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_QUALIFICATION_PROGRAM'));
    				flagIsSave = false;
    				return false;
    			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.registrationType)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
     				flagIsSave = false;
     				return false;
     			}else if ( (isNullOrEmpty(obj.data.actualRegistrationTarget) || obj.data.actualRegistrationTarget.length == 0)
    					|| (isNullOrEmpty(obj.data.actualApplicationTarget) || obj.data.actualApplicationTarget.length == 0)
    					|| (isNullOrEmpty(obj.data.actualEnquiryTarget) || obj.data.actualEnquiryTarget.length == 0)) {
    				showWarningMessage(getAdmissionTranslation('PROGRAM_TARGETS_DETAILS'), getAdmissionTranslation('PLEASE_FILL_QUALIFICATION_TARGET'));
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var value='';
    				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
    					value=true;
    				}else{
    					value=false;
    				}
    				var modeOfDelivery=null;
    				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
    					if(Ext.isObject(obj.data.modeOfDelivery)){
    						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
    					}else{
    						modeOfDelivery={"id":obj.data.modeOfDelivery};
    					}
    				}
    				var jsonObj = {
        					"id":obj.data.id,
        					"programId":obj.data.programId,
        					"academyLocationId":academyLocationId,
        					"intakeYearId":intakeYearId,
        					"modeOfDelivery":modeOfDelivery,
        					"registrationType":value,
        					"manageTargetType": "PROGRAMS",
        					"wsManageTargetTertiaryQualificationModel": {
        						"id":obj.data.manageTargetTertiaryQualificationDetailId,
        						"actualRegistrationTarget": obj.data.actualRegistrationTarget,
            					"actualApplicationTarget": obj.data.actualApplicationTarget,
            					"actualEnquiryTarget": obj.data.actualEnquiryTarget,
        					}
        			}
    				jsonStaffDetail.push(jsonObj);
    				return true;
    			}
    		});
    		}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
    			jsonData: jsonStaffDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('PROGRAM_TARGETS_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				if(Ext.isDefined(MTBSGrid)){
    					MTBSGrid.getStore().load();	
    				}
    				showSuccessMessage(getAdmissionTranslation('PROGRAM_TARGETS_DETAILS'), getAdmissionTranslation('QUALIFICATION_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    saveStaffDetailsManageTargetAdmission: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var staffDetailGrid = $this.getStaffdetailsmanagetargetadmissiongrid();
    	var MTBSGrid = $this.getManagetargetbystaffadmissiongrid();
    	var jsonStaffDetail = [];

    	var staffDetailGridStore = staffDetailGrid.getStore();
    	var getStaffStructure = staffDetailGrid.up('staffdetailsmanagetargettabstructureadmission');
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
    	var toBeDeletedArray = getStaffStructure.down('#toBeDeletedArray').getValue();
    	var flagIsSave = true;
    	if(staffDetailGridStore.getCount()>0){
    		staffDetailGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.staffId) || obj.data.staffId.length == 0) {
    				showWarningMessage(getAdmissionTranslation('REGISTRATION_STAFF_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_REGISTRATIONS_STAFF'));
    				flagIsSave = false;
    				return false;
    			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.registrationType)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0) {
    				showWarningMessage(getAdmissionTranslation('REGISTRATION_STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATIONS_STAFF_TARGET'));
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var value='';
    				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
    					value=true;
    				}else{
    					value=false;
    				}
    				var modeOfDelivery=null;
    				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
    					if(Ext.isObject(obj.data.modeOfDelivery)){
    						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
    					}else{
    						modeOfDelivery={"id":obj.data.modeOfDelivery};
    					}
    				}
    				var jsonObj = {
        					"id":obj.data.id,
        					"staffId":obj.data.staffId,
        					"actualTarget":obj.data.actualTarget,
        					"academyLocationId":academyLocationId,
        					"intakeYearId":intakeYearId,
        					"modeOfDelivery":modeOfDelivery,
        					"registrationType":value,
        					"manageTargetType": "ADMISSIONS"
        					
        			}
    				jsonStaffDetail.push(jsonObj);
    				return true;
    			}
    		});
    		if( !isNullOrEmpty(toBeDeletedArray) ){
    			var nameArr = toBeDeletedArray.split(',');
    			for(index in nameArr){
    				var id = nameArr[index];
    				if( !isNullOrEmpty(id) ){
    					var jsonObjToBeDeleted = {
            					"id":parseInt(id),
            					"toBeDeleted":true,
            					"manageTargetType": "ADMISSIONS"
            			}
        				jsonStaffDetail.push(jsonObjToBeDeleted);
    				}
    			}
    		}
    		}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
    			jsonData: jsonStaffDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('STAFF_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				if(Ext.isDefined(MTBSGrid)){
    					MTBSGrid.getStore().load();	
    				}
    				showSuccessMessage(getAdmissionTranslation('REGISTRATION_STAFF_DETAILS'), getAdmissionTranslation('STAFF_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    
    saveStaffAppointmentDetailsManageTarget: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var staffDetailGrid = $this.getStaffdetailsmanageappointmentstargetgrid();
    	var MTBSGrid = $this.getManagetargetbystaffappointmentsgrid();
    	var jsonStaffDetail = [];

    	var staffDetailGridStore = staffDetailGrid.getStore();
    	var getStaffStructure = staffDetailGrid.up('staffdetailsmanageappointmentstargettabstructure');
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
    	var toBeDeletedArray = getStaffStructure.down('#toBeDeletedArray').getValue();
    	var flagIsSave = true;
    	if(staffDetailGridStore.getCount()>0){
    		staffDetailGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.staffId) || obj.data.staffId.length == 0) {
    				showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_SALES_STAFF'));
    				flagIsSave = false;
    				return false;
    			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.registrationType)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0) {
                      if(manageTargetType=="APPOINTMENTS"){
                    	  showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_SALES_STAFF_APPOINTMENTS_TARGET'));
    				   }else{
    					   showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_SALES_STAFF_PRESENTATION_TARGET'));
    				   }
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var value='';
    				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
    					value=true;
    				}else{
    					value=false;
    				}
    				var modeOfDelivery=null;
    				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
    					if(Ext.isObject(obj.data.modeOfDelivery)){
    						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
    					}else{
    						modeOfDelivery={"id":obj.data.modeOfDelivery};
    					}
    				}
    				var jsonObj = {
        					"id":obj.data.id,
        					"staffId":obj.data.staffId,
        					"actualTarget":obj.data.actualTarget,
        					"academyLocationId":academyLocationId,
        					"intakeYearId":intakeYearId,
        					"modeOfDelivery":modeOfDelivery,
        					"registrationType":value,
        					"manageTargetType": "APPOINTMENTS"
        					
        			}
    				jsonStaffDetail.push(jsonObj);
    				return true;
    			}
    		});
    		if( !isNullOrEmpty(toBeDeletedArray) ){
    			var nameArr = toBeDeletedArray.split(',');
    			for(index in nameArr){
    				var id = nameArr[index];
    				if( !isNullOrEmpty(id) ){
    					var jsonObjToBeDeleted = {
            					"id":parseInt(id),
            					"toBeDeleted":true,
            					"manageTargetType": "APPOINTMENTS"
            			}
        				jsonStaffDetail.push(jsonObjToBeDeleted);
    				}
    			}
    		}
    		}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
    			jsonData: jsonStaffDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('STAFF_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				if( !isNullOrEmpty(MTBSGrid) ){
    				MTBSGrid.getStore().load();
    				}
    				showSuccessMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('STAFF_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    saveStaffDetailsEnquiryManageTarget: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var staffDetailGrid = $this.getStaffdetailsmanagetargetenquirygrid();
    	var MTBSGrid = $this.getManagetargetbystaffpresentationgrid();
    	var jsonStaffDetail = [];

    	var staffDetailGridStore = staffDetailGrid.getStore();
    	var getStaffStructure = staffDetailGrid.up('staffdetailsmanagetargettabstructureenquiry');
    	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
    	var toBeDeletedArray = getStaffStructure.down('#toBeDeletedArray').getValue();
    	var flagIsSave = true;
    	if(staffDetailGridStore.getCount()>0){
    		staffDetailGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.staffId) || obj.data.staffId.length == 0) {
    				showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_SALES_STAFF'));
    				flagIsSave = false;
    				return false;
    			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.registrationType)) {
  					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
     				flagIsSave = false;
     				return false;
     			}else if (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0) {
    				
    			   if(manageTargetType=="ENQUIRY"){
 					   showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_SALES_STAFF_ENQUIRY_TARGET'));
 				   }else{
 					  showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_SALES_STAFF_PRESENTATION_TARGET'));
 				   }
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var value='';
    				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
    					value=true;
    				}else{
    					value=false;
    				}
    				var modeOfDelivery=null;
    				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
    					if(Ext.isObject(obj.data.modeOfDelivery)){
    						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
    					}else{
    						modeOfDelivery={"id":obj.data.modeOfDelivery};
    					}
    				}
    				var jsonObj = {
        					"id":obj.data.id,
        					"staffId":obj.data.staffId,
        					"actualTarget":obj.data.actualTarget,
        					"academyLocationId":academyLocationId,
        					"intakeYearId":intakeYearId,
        					"modeOfDelivery":modeOfDelivery,
        					"registrationType":value,
        					"manageTargetType": "ENQUIRY"
        			}
    				jsonStaffDetail.push(jsonObj);
    				return true;
    			}
    		});
    		if( !isNullOrEmpty(toBeDeletedArray) ){
    			var nameArr = toBeDeletedArray.split(',');
    			for(index in nameArr){
    				var id = nameArr[index];
    				if( !isNullOrEmpty(id) ){
    					var jsonObjToBeDeleted = {
            					"id":parseInt(id),
            					"toBeDeleted":true,
            					"manageTargetType": "ENQUIRY"
            			}
        				jsonStaffDetail.push(jsonObjToBeDeleted);
    				}
    			}
    		}
    		}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
    			jsonData: jsonStaffDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('STAFF_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				if( !isNullOrEmpty(MTBSGrid) ){
    					MTBSGrid.getStore().load();
    				}
    				showSuccessMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('STAFF_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    deleteManageTargetStaffDetails: function(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid){
		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
			if (grid.getStore().getRange().length > 0) {
				var id = record.get('id');
				if(!isNullOrEmpty(id)){
					showConfirmMessage(titleMessage, getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_DELETE_STAFF_DETAIL_SETTING + '?id=' + id,
								method: 'DELETE',
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {
									grid.getStore().removeAt(rowIndex);
									var models = grid.getStore().getRange();
									grid.getStore().loadRawData(models, true);
									if(Ext.isDefined(MTBSGrid)){
				    					MTBSGrid.getStore().load();	
				    				}
									if(models.length == 0){
										grid.down('#btnAdd').show();
										getStaffStructure.up().down('#SaveBtn').setDisabled(true);
									}
									showSuccessMessage(titleMessage, getAdmissionTranslation('STAFF_DELETE_MANAGE_TARGET_MSG'));
								}
							});
						}
					});
					}
				else{
					grid.getStore().removeAt(rowIndex);
					var models = grid.getStore().getRange();
					for (var i = 0; i < models.length; i++) {
						models[i].data.serialNo = i + 1;
					}
					grid.getStore().loadRawData(models, true);
					if(models.length == 0){
						grid.down('#btnAdd').show();
						getStaffStructure.up().down('#SaveBtn').setDisabled(true);
					}
				}
			}
		}
    },
    deleteManageTargetProgramDetails: function(grid,record,getStaffStructure,titleMessage,rowIndex,MTBSGrid){
		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
			if (grid.getStore().getRange().length > 0) {
				var id = record.get('id');
				if(!isNullOrEmpty(id)){
					showConfirmMessage(titleMessage, getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_DELETE_STAFF_DETAIL_SETTING + '?id=' + id,
								method: 'DELETE',
								headers: {
									'Content-Type': 'application/json'
								},
								success: function(form, action) {
									grid.getStore().removeAt(rowIndex);
									var models = grid.getStore().getRange();
									grid.getStore().loadRawData(models, true);
									if(Ext.isDefined(MTBSGrid)){
				    					MTBSGrid.getStore().load();	
				    				}
									if(models.length == 0){
										grid.down('#btnAdd').show();
										getStaffStructure.up().down('#SaveBtn').setDisabled(true);
									}
									showSuccessMessage(titleMessage, getAdmissionTranslation('STAFF_DELETE_MANAGE_TARGET_MSG'));
								}
							});
						}
					});
					}
				else{
					grid.getStore().removeAt(rowIndex);
					var models = grid.getStore().getRange();
					for (var i = 0; i < models.length; i++) {
						models[i].data.serialNo = i + 1;
					}
					grid.getStore().loadRawData(models, true);
					if(models.length == 0){
						grid.down('#btnAdd').show();
						getStaffStructure.up().down('#SaveBtn').setDisabled(true);
					}
				}
			}
		}
    },
    savePresentationLeadStaffDetails: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();
    	var presentationStaffDetailGrid = $this.getPresentationleaddetailsmanagetargetgrid();
    	var jsonLeadDetail = [];
    	var presentationStaffDetailGridStore = presentationStaffDetailGrid.getStore();
    	var getPresentationTabStructure = presentationStaffDetailGrid.up('presentationleaddetailsmanagetargettabstructure');
    	var academyLocationId = getPresentationTabStructure.down('#academyLocationId').getValue();
    	var intakeYearId = getPresentationTabStructure.down('#intakeYearId').getValue();
    	var manageTargetType = getPresentationTabStructure.down('#manageTargetType').getValue();
    	var flagIsSave = true;
    	if(presentationStaffDetailGridStore.getCount()>0){
    		presentationStaffDetailGridStore.data.items.every(function(obj){
    			if (obj.data.isActualTargetReadOnly == false && (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0)) {
    				showWarningMessage(getAdmissionTranslation('PRESENTATION_LEAD_DETAILS'), getAdmissionTranslation('PLEASE_SELECT_PRESENTATION_LEAD_TARGET'));
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				if( obj.data.isActualTargetReadOnly == true ){
    					//dont send current row for updation / creation
    				} else {
    					var jsonObj = {
        						"id":obj.data.id,
        						"campaignNewId":obj.data.campaignNewId,
        						"actualTarget":obj.data.actualTarget,
        						"academyLocationId":academyLocationId,
        						"intakeYearId":intakeYearId,
        						"manageTargetType": "PRESENTATIONS"

        				}
        				jsonLeadDetail.push(jsonObj);
    				}
    				return true;
    			}
    		});
    	}
    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_MANAGE_TARGET_PRESENTATIONLEAD_UPDATE,
    			jsonData: jsonLeadDetail,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getAdmissionTranslation('PRESENTATION_LEAD_DETAILS');
    				var contentPanel = $this.getManagetargetbystaffstructure();
    				var getTab = null;
    				for(var i =0 ;i<contentPanel.items.length;i++){
    					if(contentPanel.items.items[i].title == tabName){
    						getTab= contentPanel.items.items[i];
    					}
    				}
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				showSuccessMessage(getAdmissionTranslation('PRESENTATION_LEAD_DETAILS'), getAdmissionTranslation('PRESENTATION_LEAD_DETAILS_SAVED_MSG'));
    			}
    		});
    	}
    },
    searchPresentationLeadPadmsRecord:function(){
    	var $this = this;
    	var presentationStructure = $this.getPresentationleaddetailsmanagetargettabstructure();
    	var aLId = presentationStructure.down('#academyLocationId').getValue();
    	var IntakeId = presentationStructure.down('#intakeYearId').getValue();
    	var getForm =  $this.getPresentationleaddetailspadmsform();
    	var campaignTypeIdFieldValue = getForm.down('#campaignTypeId').getValue();
    	var grid = $this.getPresentationleaddetailsmanagetargetgrid();
    	buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	var store =  grid.getStore();
    	store.getProxy().extraParams = {
    		academyLocationIds: aLId,
    		intakeYearId: IntakeId,
    		manageTargetType:'PRESENTATIONS',
    		campaignType: campaignTypeIdFieldValue
    	};
    	$this.resetPageSetting(store);
    	store.load({
    		callback: function(records, operation, success) {
    			if(records.length>0){
    				pdftoolbar.setDisabled(false);
    				exceltoolbar.setDisabled(false);
    				presentationStructure.down('#SaveBtn').setVisible(true);   
    			}else{
    				pdftoolbar.setDisabled(true);
    				exceltoolbar.setDisabled(true);
    				presentationStructure.down('#SaveBtn').setVisible(false);     
    			}
    		}	   
    	});
    },
    ResetPresentationLeadPadmsForm:function(){
    	var $this = this;
    	var presentationStructure = $this.getPresentationleaddetailsmanagetargettabstructure();
    	var aLId = presentationStructure.down('#academyLocationId').getValue();
    	var IntakeId = presentationStructure.down('#intakeYearId').getValue();
    	var getForm =  $this.getPresentationleaddetailspadmsform();
    	getForm.getForm().reset();
    	var grid = $this.getPresentationleaddetailsmanagetargetgrid();
    	buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	var store =  grid.getStore();
    	store.getProxy().extraParams = {
    		academyLocationIds: aLId,
    		intakeYearId: IntakeId,
    		manageTargetType:'PRESENTATIONS',
    		campaignType: null
    	};
    	$this.resetPageSetting(store);
    	store.load({
    		callback: function(records, operation, success) {
    			if(records.length>0){
    				pdftoolbar.setDisabled(false);
    				exceltoolbar.setDisabled(false);
    				presentationStructure.down('#SaveBtn').setVisible(true);   
    			}else{
    				pdftoolbar.setDisabled(true);
    				exceltoolbar.setDisabled(true);
    				presentationStructure.down('#SaveBtn').setVisible(false);     
    			}
    		}	   
    	});
    },
    //********Open New Tab for Lead Details **********
    getOpenActualLeadTargetDetailsGrid : function(grid,record){
 	  var $this = this;
 	  // var contentPanel = $this.getContentpanel(); 
 	   var contentPanel = $this.getManagetargetbystaffstructure();
 	   var tabName = getAdmissionTranslation('TOTAL_ACTUAL_PRESENTATIONS');
 	   var getTab = null;
		for(var i =0 ;i<contentPanel.items.length;i++){
			if(contentPanel.items.items[i].title == tabName){
				getTab= contentPanel.items.items[i];
			}
		}
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
 	   var contentXtype ='actualpresentationstargetpadmsstructure';
 	   var newTab = $this.getTabReferenceByTabTitle(tabName);
 	  if(!newTab){
  		newTab = contentPanel.add({
  			xtype: contentXtype,
  			closable: true,
  			title: tabName,
  			menuColorCls: CONSTANTS.MENU_COLOR_ONE
  		});
  	}
  	contentPanel.setActiveTab(newTab);
 	   var actualTargetStructure = $this.getActualpresentationstargetpadmsstructure();
 	   var actualTargetGrid =  actualTargetStructure.down('actualpresentationstargetpadmsgrid');
 	  actualTargetGrid.getStore().getProxy().extraParams = {
 		  	academyLocationIds: record.data.academyLocationId,
		   intakeYearId: record.data.intakeYearId,
		   registrationType:record.data.registrationType,
		   modeOfDeliveryId:record.data.modeOfDeliveryId
 	   };
 	 $this.resetPageSetting(actualTargetGrid.getStore());
 	 actualTargetGrid.getStore().load();
    },
    openCampaignViewStructure:function(id,isType,getController){
    	var contentPanel = $this.getContentpanel(); 
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
        var getAddTab = getcontroller.getTab(getCommonTranslation('ADD_CAMPAIGN_DETAIL'));
        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_CAMPAIGN_DETAIL'));
        var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_CAMPAIGN_DETAIL'));

        if(isType == "VIEW"){
        	if (getAddTab != null) {
        		contentPanel.remove(getAddTab, true);
	        }
	        if (getEditTab != null) {
	        	contentPanel.remove(getEditTab, true);
	        }
        }
        else{
        	if (getAddTab != null) {
        		contentPanel.remove(getAddTab, true);
	        }
	        if (getViewTab != null) {
	        	contentPanel.remove(getViewTab, true);
	        }
        }
		var campaignNewFormLayout = $this.getCampaignnewformlayout();
		if (!campaignNewFormLayout) {
			var campaignNewFormLayout = Ext.widget('campaignnewformlayout',{
				title:getCampaignTranslation('DETAILS_TAB')
			});
		}
		var tabName = getCommonTranslation('EDIT_CAMPAIGN_DETAIL');
		if(isType == "VIEW"){
			tabName = getCommonTranslation('VIEW_CAMPAIGN_DETAIL');
		}
		campaignNewFormLayout.config.isType = isType;
		openTab(contentPanel, tabName, campaignNewFormLayout, CONSTANTS.MENU_COLOR_NINE);  
		$this.setCampaignRecord(id, campaignNewFormLayout, isType,getController);
    },
    setCampaignRecord: function(id, campaignNewFormLayout, isEditable,getController){
    	var $this = this;
		var submitUrl = SERVERURL.PATH_CAMPPAIGN_NEW_FIND_BY_ID;
		var formPnl = campaignNewFormLayout;
		var campaignResetButtonId = formPnl.down('#campaignResetButtonId');
		campaignResetButtonId.setVisible(false);
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl+"?id="+id,
			method : 'GET',
			success : function(resp, action) {
				var data = Ext.decode(resp.responseText);
				 if(!isNullOrEmpty(data.createdOn)){
					 data.createdOn = new Date(data.createdOn);
				 }
				 formPnl.down('#createdOnId').setReadOnly(true);
					 
                 if(!isNullOrEmpty(data.startDate)){
                	 data.startDate = new Date(data.startDate);
                 }
                 formPnl.down('#startDateId').setReadOnly(true);
                	 
                 if(!isNullOrEmpty(data.endDate)){
                	 data.endDate = new Date(data.endDate);
                 }
                 formPnl.down('#endDateId').setReadOnly(true);
                	 
                 if(!isNullOrEmpty(data.intakeYear)){
                	 data.intakeYear = data.intakeYear.id;
                 }
                 if(data.presentationType == "PPC" || data.presentationType == "PFMG" || data.presentationType == "PMG" || data.presentationType == "GR11"){
                	 getController.loadDataForSchoolForm(formPnl,data);
                 }
                 else if(data.presentationType == "THIRD_PARTY" || data.presentationType == "CAREER_FAIR" ||data.presentationType == "USSD"){
                	 getController.loadDataForSchoolFormCareerThirdPary(formPnl,data);
                 }
                 else if(data.campaignType == "NON_SCHOOL_PRESENTATION"){
                	 getController.loadDataForNonSchoolForm(formPnl,data,isEditable);
                 }
                 var documentGrid = formPnl.down('#documentsGridCampaignNew');
                 documentGrid.getStore().getProxy().api.read = SERVERURL.PATH_FIND_DOCUMENT_BY_CAMPAIGN_ID;
                 documentGrid.getStore().getProxy().extraParams={
                	 id:data.id
                 };
                 documentGrid.getStore().load();
                 if(isEditable == "VIEW"){
                	 var btnSaveCampaign= formPnl.down('#btnSaveCampaignNewForm');
                	 var btnDocUpload= formPnl.down('#meetingDocsCampaignId');
                	 $this.toggleReadOnlyFormItems(formPnl.getForm(), true);
                	 btnSaveCampaign.setVisible(false);
                	 btnDocUpload.setVisible(false);
                	 documentGrid.down('#btnDelete').setVisible(false);
                 }
			}
		});
    },
    //********Open New Tab for Lead Details **********
    getOpenActualEnquiryTargetDetailsGrid : function(grid,record){
    	var $this = this;
    	var contentPanel = $this.getManagetargetbystaffstructure();
    	var tabName = getAdmissionTranslation('TOTAL_ACTUAL_ENQUIRY');
    	var getTab = null;
    	for(var i =0 ;i<contentPanel.items.length;i++){
    		if(contentPanel.items.items[i].title == tabName){
    			getTab= contentPanel.items.items[i];
    		}
    	}
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	var contentXtype ='actualenquirytargetpadmsstructure';
    	var newTab = $this.getTabReferenceByTabTitle(tabName);
    	if(!newTab){
    		newTab = contentPanel.add({
    			xtype: contentXtype,
    			closable: true,
    			title: tabName,
    			menuColorCls: CONSTANTS.MENU_COLOR_ONE
    		});
    	}
    	contentPanel.setActiveTab(newTab);
    	var actualTargetStructure = $this.getActualenquirytargetpadmsstructure();
    	var actualTargetGrid =  actualTargetStructure.down('actualenquirytargetpadmsgrid');
    	actualTargetGrid.getStore().getProxy().extraParams = {
    		academyLocationIds: record.data.academyLocationId,
    		intakeYearId: record.data.intakeYearId,
    		modeOfDeliveryId:record.data.modeOfDeliveryId,
    		registrationType:record.data.registrationType
    	};
    	$this.resetPageSetting(actualTargetGrid.getStore());
    	actualTargetGrid.getStore().load();
    },
    showEnquiryFromActualEnquiryTarget: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    var getController = Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
  	Academia.app.getController('Academia.controller.enquiry.EnquiryRevampController');
	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController');
	Academia.app.getController('Academia.controller.enquiry.student.StudentDetailRevampController');
      
  	  var grid = grid.ownerCt;
  	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
  	  if(e.target.tagName=="A"){
  		  if(columnName=='enquiryCode' ){
  			var MyJson ={"configCode":"TRACK_ENQUIRY_ADMISSION",
					  "searchCriterias":[{
						  "paramCode":"ENQUIRY_NO",
						  "paramValues":[record.data.id]},
						  {"paramCode":"WHETHER_DELETED","paramValues":[false]}
					  ]}
  			  Ext.Ajax.request({
                  type: 'rest',
                  url: SERVERURL.EXECUTEBASICSEARCH+"?page=1&start=0&limit=25",
                  jsonData: MyJson,
                  method: 'POST',
                  success: function(frm, action) {
                      var data = Ext.JSON.decode(frm.responseText);
                      getController.linkClicked(0,0,grid,'View',true,data);
                  }
              });
  			
  		  }
  	  }
    },
    //********Open New Tab for Application Target Details **********
    getOpenActualApplicationTargetDetailsGrid : function(grid,record){
 	  var $this = this;
 	  // var contentPanel = $this.getContentpanel(); 
 	   var contentPanel = $this.getManagetargetbystaffstructure();
 	   var tabName = getAdmissionTranslation('TOTAL_ACTUAL_APPLICATION');
 	   var getTab = null;
		for(var i =0 ;i<contentPanel.items.length;i++){
			if(contentPanel.items.items[i].title == tabName){
				getTab= contentPanel.items.items[i];
			}
		}
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
 	   var contentXtype ='actualapplicationtargetpadmsstructure';
 	   var newTab = $this.getTabReferenceByTabTitle(tabName);
 	  if(!newTab){
  		newTab = contentPanel.add({
  			xtype: contentXtype,
  			closable: true,
  			title: tabName,
  			menuColorCls: CONSTANTS.MENU_COLOR_ONE
  		});
  	}
  	contentPanel.setActiveTab(newTab);
 	   var actualTargetStructure = $this.getActualapplicationtargetpadmsstructure();
 	   var actualTargetGrid =  actualTargetStructure.down('actualapplicationtargetpadmsgrid');
 	  actualTargetGrid.getStore().getProxy().extraParams = {
 		  	academyLocationIds: record.data.academyLocationId,
		   intakeYearId: record.data.intakeYearId,
   		modeOfDeliveryId:record.data.modeOfDeliveryId,
		registrationType:record.data.registrationType
 	   };
 	 $this.resetPageSetting(actualTargetGrid.getStore());
 	 actualTargetGrid.getStore().load();
    },
    //********Open New Tab for Admission Target Details **********
    getOpenActualAdmissionTargetDetailsGrid : function(grid,record){
 	  var $this = this;
 	  // var contentPanel = $this.getContentpanel(); 
 	   var contentPanel = $this.getManagetargetbystaffstructure();
 	   var tabName = getAdmissionTranslation('TOTAL_ACTUAL_ADMISSION_TARGETS');
 	   var getTab = null;
		for(var i =0 ;i<contentPanel.items.length;i++){
			if(contentPanel.items.items[i].title == tabName){
				getTab= contentPanel.items.items[i];
			}
		}
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
 	   var contentXtype ='actualadmissiontargetpadmsstructure';
 	   var newTab = $this.getTabReferenceByTabTitle(tabName);
 	  if(!newTab){
  		newTab = contentPanel.add({
  			xtype: contentXtype,
  			closable: true,
  			title: tabName,
  			menuColorCls: CONSTANTS.MENU_COLOR_ONE
  		});
  	}
  	contentPanel.setActiveTab(newTab);
 	   var actualTargetStructure = $this.getActualadmissiontargetpadmsstructure();
 	   var actualTargetGrid =  actualTargetStructure.down('actualadmissiontargetpadmsgrid');
 	  actualTargetGrid.getStore().getProxy().extraParams = {
 		  	academyLocationIds: record.data.academyLocationId,
		   intakeYearId: record.data.intakeYearId,
		   modeOfDeliveryId:record.data.modeOfDeliveryId,
		   registrationType:record.data.registrationType
 	   };
 	 $this.resetPageSetting(actualTargetGrid.getStore());
 	 actualTargetGrid.getStore().load();
    },
    showApplicationProfileActualApplicationTarget: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    	  var getController = Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
      	  var grid = grid.ownerCt;
      	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
      	  if(e.target.tagName=="A"){
      		  if(columnName=='applicationCode' ){
      			var MyJson ={"configCode":"APPLICATION_LIST",
    					  "searchCriterias":[{
    						  "paramCode":"APPLICATION_ID",
    						  "paramValues":[record.data.applicationCode]}
    					  ]}
      			  Ext.Ajax.request({
                      type: 'rest',
                      url: SERVERURL.EXECUTEBASICSEARCH+"?page=1&start=0&limit=25",
                      jsonData: MyJson,
                      method: 'POST',
                      success: function(frm, action) {
                          var data = Ext.JSON.decode(frm.responseText);
                          var dataSet = Ext.Object.getKeys(data.rows[0]);
                          //create model
                          Ext.define('Academia.model.admission.applicationFormSale.ApplicantGridModelForTargetByStaffRedirection', {
                              extend: 'Ext.data.Model',
                              fields: dataSet
                          });
                          var applicationDataModelFromStaffTarget = new Academia.model.admission.applicationFormSale.ApplicantGridModelForTargetByStaffRedirection(data.rows[0]);
                          var applicationId = applicationDataModelFromStaffTarget.get('APPLICATION_PRIMERY_ID'); 
                          getController.openApplicantProfile(applicationId,true,grid,null,applicationDataModelFromStaffTarget);
                      }
                  });
      			
      		  }
      	  }
        },
        //********Open New Tab for Appointments Target Details **********
        getOpenActualAppointmentsTargetDetailsGrid : function(grid,record){
     	  var $this = this;
     	  // var contentPanel = $this.getContentpanel(); 
     	   var contentPanel = $this.getManagetargetbystaffstructure();
     	   var tabName = getAdmissionTranslation('TOTAL_ACTUAL_APPOINTEMENTS');
     	   var getTab = null;
    		for(var i =0 ;i<contentPanel.items.length;i++){
    			if(contentPanel.items.items[i].title == tabName){
    				getTab= contentPanel.items.items[i];
    			}
    		}
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
     	   var contentXtype ='actualappointmentstargetpadmsstructure';
     	   var newTab = $this.getTabReferenceByTabTitle(tabName);
     	  if(!newTab){
      		newTab = contentPanel.add({
      			xtype: contentXtype,
      			closable: true,
      			title: tabName,
      			menuColorCls: CONSTANTS.MENU_COLOR_ONE
      		});
      	}
      	contentPanel.setActiveTab(newTab);
     	   var actualTargetStructure = $this.getActualappointmentstargetpadmsstructure();
     	   var actualTargetGrid =  actualTargetStructure.down('actualappointmentstargetpadmsgrid');
     	  actualTargetGrid.getStore().getProxy().extraParams = {
     		  	academyLocationIds: record.data.academyLocationId,
    		   intakeYearId: record.data.intakeYearId,
    		   registrationType:record.data.registrationType,
    		   modeOfDeliveryId:record.data.modeOfDeliveryId
     	   };
     	 $this.resetPageSetting(actualTargetGrid.getStore());
     	 actualTargetGrid.getStore().load();
        },
        showEnquiryFromActualAppointmentEnquiryTarget: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            var getController = Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
          	Academia.app.getController('Academia.controller.enquiry.EnquiryRevampController');
        	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController');
        	Academia.app.getController('Academia.controller.enquiry.student.StudentDetailRevampController');
              
          	  var grid = grid.ownerCt;
          	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
          	  if(e.target.tagName=="A"){
          		  if(columnName=='enquiryCode' ){
          			var MyJson ={"configCode":"TRACK_ENQUIRY_ADMISSION",
        					  "searchCriterias":[{
        						  "paramCode":"ENQUIRY_NO",
        						  "paramValues":[record.data.enquiryId]},
        						  {"paramCode":"WHETHER_DELETED","paramValues":[false]}
        					  ]}
          			  Ext.Ajax.request({
                          type: 'rest',
                          url: SERVERURL.EXECUTEBASICSEARCH+"?page=1&start=0&limit=25",
                          jsonData: MyJson,
                          method: 'POST',
                          success: function(frm, action) {
                              var data = Ext.JSON.decode(frm.responseText);
                              getController.linkClicked(0,0,grid,'View',true,data);
                          }
                      });
          			
          		  }
          	  }
        },
        saveStaffDetailsManageTargetAdmissioinsOffer: function(){
        	var $this=this;
        	var staffDetailGrid = $this.getStaffdetailsmanagetargetadmissionoffergrid();
        	var MTBSGrid = $this.getManagetargetbyadmissionsoffergrid();
        	var jsonStaffDetail = [];

        	var staffDetailGridStore = staffDetailGrid.getStore();
        	var getStaffStructure = staffDetailGrid.up('staffdetailsmanagetargettabstructureadmissionsoffer');
        	var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
        	var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
        	var toBeDeletedArray = getStaffStructure.down('#toBeDeletedArray').getValue();
        	var flagIsSave = true;
        	if(staffDetailGridStore.getCount()>0){
        		staffDetailGridStore.data.items.every(function(obj){
        			if (isNullOrEmpty(obj.data.staffId) || obj.data.staffId.length == 0) {
        				showWarningMessage(getAdmissionTranslation('ADMISSIONS_OFFER_DETAIL'), getAdmissionTranslation('PLEASE_FILL_ADMISSIONS_OFFER_STAFF'));
        				flagIsSave = false;
        				return false;
        			}else if (isNullOrEmpty(obj.data.modeOfDelivery)) {
      					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_MODE_OF_DELIVERY'));
         				flagIsSave = false;
         				return false;
         			}else if (isNullOrEmpty(obj.data.registrationType)) {
      					showWarningMessage(getAdmissionTranslation('STAFF_DETAILS'), getAdmissionTranslation('PLEASE_FILL_REGISTRATION_TYPE'));
         				flagIsSave = false;
         				return false;
         			}else if (isNullOrEmpty(obj.data.actualTarget) || obj.data.actualTarget.length == 0) {
        				showWarningMessage(getAdmissionTranslation('ADMISSIONS_OFFER_DETAIL'), getAdmissionTranslation('PLEASE_FILL_TOTAL_ADMISSIONS_OFFER_TARGET'));
        				flagIsSave = false;
        				return false;
        			}
        			else{
        				var value='';
        				if(obj.data.registrationType=="PART_TIME" || obj.data.registrationType == true){
        					value=true;
        				}else{
        					value=false;
        				}
        				var modeOfDelivery=null;
        				if(!isNullOrEmpty(obj.data.modeOfDelivery)){
        					if(Ext.isObject(obj.data.modeOfDelivery)){
        						modeOfDelivery={"id":obj.data.modeOfDelivery.id};	
        					}else{
        						modeOfDelivery={"id":obj.data.modeOfDelivery};
        					}
        				}
        				var jsonObj = {
        						"id":obj.data.id,
        						"staffId":obj.data.staffId,
        						"actualTarget":obj.data.actualTarget,
        						"academyLocationId":academyLocationId,
        						"intakeYearId":intakeYearId,
        						"modeOfDelivery":modeOfDelivery,
            					"registrationType":value,
        						"manageTargetType": "ADMISSIONS_OFFER"

        				}
        				jsonStaffDetail.push(jsonObj);
        				return true;
        			}
        		});
        		if( !isNullOrEmpty(toBeDeletedArray) ){
        			var nameArr = toBeDeletedArray.split(',');
        			for(index in nameArr){
        				var id = nameArr[index];
        				if( !isNullOrEmpty(id) ){
        					var jsonObjToBeDeleted = {
        							"id":parseInt(id),
        							"toBeDeleted":true,
        							"manageTargetType": "ADMISSIONS_OFFER"
        					}
        					jsonStaffDetail.push(jsonObjToBeDeleted);
        				}
        			}
        		}
        	}
        	if(flagIsSave){
        		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        		Ext.Ajax.request({
        			type: 'rest',
        			url: SERVERURL.PATH_MANAGE_TARGET_STAFFUPDATE,
        			jsonData: jsonStaffDetail,
        			method: 'POST',
        			success: function(frm, action) {
        				Ext.getBody().unmask();
        				var tabName = getAdmissionTranslation('STAFF_DETAILS');
        				var contentPanel = $this.getManagetargetbystaffstructure();
        				var getTab = null;
        				for(var i =0 ;i<contentPanel.items.length;i++){
        					if(contentPanel.items.items[i].title == tabName){
        						getTab= contentPanel.items.items[i];
        					}
        				}
        				if(getTab!=null){
        					contentPanel.remove(getTab, true);
        				}
        				if(Ext.isDefined(MTBSGrid)){
        					MTBSGrid.getStore().load();	
        				}
        				showSuccessMessage(getAdmissionTranslation('APPLICATIONS_STAFF_DETAILS'), getAdmissionTranslation('STAFF_DETAILS_SAVED_MSG'));
        			}
        		});
        	}
        }, 
        getAdmissionsOfferOfferLetterAccepted : function(grid,record){
       	  var $this = this;
     	   var contentPanel = $this.getManagetargetbystaffstructure();
     	   var tabName = getAdmissionTranslation('TOTAL_ACTUAL_ADMISSION_OFFER');
     	   var getTab = null;
    		for(var i =0 ;i<contentPanel.items.length;i++){
    			if(contentPanel.items.items[i].title == tabName){
    				getTab= contentPanel.items.items[i];
    			}
    		}
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
     	   var contentXtype ='actualadmissionsofferapplicantcountstructure';
     	   var newTab = $this.getTabReferenceByTabTitle(tabName);
     	  if(!newTab){
      		newTab = contentPanel.add({
      			xtype: contentXtype,
      			closable: true,
      			title: tabName,
      			menuColorCls: CONSTANTS.MENU_COLOR_ONE
      		});
      	}
      	contentPanel.setActiveTab(newTab);
     	   var actualTargetStructure = $this.getActualadmissionsofferapplicantcountstructure();
     	   var actualTargetGrid =  actualTargetStructure.down('actualadmissionsofferapplicantcountgrid');
     	  actualTargetGrid.getStore().getProxy().extraParams = {
     		  	academyLocationIds: record.data.academyLocationId,
    		   intakeYearId: record.data.intakeYearId,
    		   status:'OFFER_LETTER_ACCEPTED',
    		   registrationType:record.data.registrationType,
    		   modeOfDeliveryId:record.data.modeOfDeliveryId
     	   };
     	 $this.resetPageSetting(actualTargetGrid.getStore());
     	 actualTargetGrid.getStore().load();
        },
        showApplicationProfileActualAdmissionOffer: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
      	  var getController = Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
        	  var grid = grid.ownerCt;
        	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
        	  if(e.target.tagName=="A"){
        		  if(columnName=='applicationCode' ){
        			var MyJson ={"configCode":"APPLICATION_LIST",
      					  "searchCriterias":[{
      						  "paramCode":"APPLICATION_ID",
      						  "paramValues":[record.data.applicationCode]}
      					  ]}
        			  Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.EXECUTEBASICSEARCH+"?page=1&start=0&limit=25",
                        jsonData: MyJson,
                        method: 'POST',
                        success: function(frm, action) {
                            var data = Ext.JSON.decode(frm.responseText);
                            var dataSet = Ext.Object.getKeys(data.rows[0]);
                            Ext.define('Academia.model.admission.applicationFormSale.ApplicantGridModelForTargetByStaffRedirection', {
                                extend: 'Ext.data.Model',
                                fields: dataSet
                            });
                            var applicationDataModelFromStaffTarget = new Academia.model.admission.applicationFormSale.ApplicantGridModelForTargetByStaffRedirection(data.rows[0]);
                            var applicationId = applicationDataModelFromStaffTarget.get('APPLICATION_PRIMERY_ID'); 
                            getController.openApplicantProfile(applicationId,true,grid,null,applicationDataModelFromStaffTarget);
                        }
                    });
        			
        		  }
        	  }
          }
});