Ext.define('Academia.controller.menu.CoreERPNavigationController', { 
    extend: 'Ext.app.Controller',

    views: ['baselayout.megamenu.VerticalNavigationMenu', 
            'baselayout.megamenu.VerticalNavigationMenuButton', 
            'baselayout.megamenu.VerticalNavigationMenuPanel',
            'baselayout.megamenu.VerticalNavigationMenuPanelItem',
            'baselayout.megamenu.VerticalMenuCollapseIcon',
            'Academia.view.baselayout.contentarea.ContentPanel'
            ],
    stores: ['MainSearchStore','common.PopiaStatusDropdownValue','common.EnquiryPopiaStatusDropdownValue'],
    refs: [{
        ref: 'verticalNavigationMenu',
        selector: 'verticalNavigationMenu'
    }, {
        ref: 'verticalNavigationMenuPanel',
        selector: 'verticalNavigationMenuPanel'
    }, {
        ref: 'verticalNavigationMenuPanelItem',
        selector: 'verticalNavigationMenuPanelItem'
    }, {
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'verticalnavigationmenubutton',
        selector: 'verticalnavigationmenubutton'
    }],


    init: function() {
        this.control({
        	'verticalNavigationMenu':{
        		beforecollapse:function(obj, direction, animate, eOpts){
        			try{
            			if(event.target.classList.contains('x-form-text')){
            				return false;
            			}
        			}
        			catch(e){
        				if(Ext.ComponentQuery.query('#searchComboBox')[0].hasFocus && Ext.ComponentQuery.query('#searchComboBox')[0].allowCollapse==false){
        					return false;
        				}
        			}
        			var userInfo = Academia.model.authentication.UserInfoModel;
        			if(userInfo.get("portalId")==6){
        				//return false;
        			}
        			/*obj.placeholder.getEl().on('mouseover', function(event){
        				console.log('mouseover');
        				obj.setAutoScroll(true);
        			});
        			obj.placeholder.getEl().on('mouseout', function(event){
        				console.log('mouseout',obj);
        				obj.placeholder.setAutoScroll(false);
        			});*/
        		},
        		collapse:function(){
        			var placeholderLbar = Ext.getCmp('placeholderLbar');
        			var scrollablePlaceholderLbar = placeholderLbar.body.el.isScrollable();
        			if(scrollablePlaceholderLbar){
        				var heightMenuHolder = placeholderLbar.body.getHeight();
        				placeholderLbar.body.setHeight(heightMenuHolder-22);
        			}
        			
        			this.changeActiveMenuColor(this.getContentPanel(),'collapsed');
        		},
        		/*code added for search field height issue*/
        		expand:function(obj){
        			var menuHolder = Ext.getCmp('menuHolder');
        			var scrollableMenuHolder = menuHolder.body.el.isScrollable();
    				if(scrollableMenuHolder){
                		var heightMenuHolder = menuHolder.body.getHeight();
                    	menuHolder.body.setHeight(heightMenuHolder-3.5);
                	}
    				this.changeActiveMenuColor(this.getContentPanel(),'expanded');
        		},
        		afterrender: function(obj){
        			var me = this;
        			setTimeout(function(){
            			Ext.getCmp('menuHolder').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        			},100);
        			setTimeout(function(){
        				try{
                    		if($('.megaMenuPanel').length==0){
                    			var searchFieldStore = obj.down('#searchComboBox').getStore();
                    			var verticalMenuBtns = Ext.ComponentQuery.query('verticalnavigationmenubutton');
                    			if(portalId!=6){
                    				for(var i=verticalMenuBtns.length;i>0;i--){
                    					var currentMenu = verticalMenuBtns[i-1];
                    					currentMenu.showMenu(); //Ext.query('#'+currentMenu.id)[0].click();
                    					
                    					var currentVerticalMenuEl = currentMenu.menu.el.dom;//Ext.query('.x-vertical-box-overflow-body:visible')[0];
                    					if(isNullOrEmpty(currentVerticalMenuEl.isAdded)){
                    						currentVerticalMenuEl.isAdded = true;
                    						Ext.each(currentVerticalMenuEl.getElementsByClassName('x-btn-inner-left'),function(currentMenuItem){
                    							if(searchFieldStore.find('title',currentMenuItem.textContent)<0){
                    								searchFieldStore.add({
                    									iconCls: currentMenu.iconCls,
                    									displayPath: getMegaMenuTranslation(currentMenu.displayCode),
                    									title: currentMenuItem.textContent,
                    									menuId: currentMenuItem.id,
                    									searchText: currentMenuItem.textContent+" "+currentMenuItem.textContent.match(/\b(\w)/g).join("")
                    								});
                    							}
                    						});
                    					}
                    					
                        				/*Ext.each(Ext.ComponentQuery.query('verticalNavigationMenuPanel'), function(currentVerticalMenu){
                        					if(currentVerticalMenu.isVisible() && isNullOrEmpty(currentVerticalMenu.isAdded)){
                        						currentVerticalMenu.isAdded = true;
                        						Ext.each(currentVerticalMenu.el.dom.getElementsByClassName('x-btn-inner-left'),function(currentMenuItem){
                        							if(searchFieldStore.find('title',currentMenuItem.textContent)<0){
                        								var storeItem = {
                        										iconCls: currentMenu.iconCls,
                        										displayPath: getMegaMenuTranslation(currentMenu.displayCode),
                        										title: currentMenuItem.textContent,
                        										menuId: currentMenuItem.id
                        								};
                        								searchFieldStore.add(storeItem);
                        							}
                        						});
                        					}
                        				});*/
                    				}
                    				currentMenu.hideMenu();
                    				Ext.getCmp('menuHolder').body.unmask();
                    			}
                    			else{
                    				Ext.each(verticalMenuBtns, function(currentMenu){
                    					var storeItem = {
        										iconCls: currentMenu.iconCls,
        										displayPath: '>',
        										title: getMegaMenuTranslation(currentMenu.displayCode),
        										menuId: currentMenu.id,
            									searchText: getMegaMenuTranslation(currentMenu.displayCode)+" "+getMegaMenuTranslation(currentMenu.displayCode).match(/\b(\w)/g).join("")
        								};
        								searchFieldStore.add(storeItem);
                        			});
                    				Ext.getCmp('menuHolder').body.unmask();
                    			}
                    			Ext.getCmp('menuHolder').body.scrollBy(0,'-'+Ext.getCmp('menuHolder').body.getScrollTop());
                    		}
                    	}
                    	catch(e){
                    		Ext.getCmp('menuHolder').body.unmask();
                    		Ext.getCmp('menuHolder').body.scrollBy(0,'-'+Ext.getCmp('menuHolder').body.getScrollTop());
                    	}
                    	/*code added for search field height issue*/
                    	var menuHolder = Ext.getCmp('menuHolder');
                    	menuHolder.body.unmask();
                    	var scrollableMenuHolder = menuHolder.body.el.isScrollable();
        				if(scrollableMenuHolder){
                    		var heightMenuHolder = menuHolder.body.getHeight();
                        	menuHolder.body.setHeight(heightMenuHolder-7);
                    	}
        				if(portalId == '6'){
        					menuHolder.addCls('removeArrowApplicantPortal');
        				}else{
        					menuHolder.removeCls('removeArrowApplicantPortal')
        				}
        				if(portalId == '3'){
        					me.hideGraduationCermonymenu(searchFieldStore);
        				}
        				if(portalId == '1'){
        					me.hideHostelApplicationSetupMenu(searchFieldStore);
        					me.hideUtilityControlPanelmenu(searchFieldStore);
        					me.hideStudentProfileMenu(searchFieldStore);
                            me.hideUserProfileMenu(searchFieldStore);
        				}
                    },1000);
        		}
        	},
        		/*render : function(obj){
        			obj.el.on('mouseover', function(event){
        				obj.setAutoScroll(true);
        			});
        			obj.el.on('mouseout', function(event){
        				obj.setAutoScroll(false);
        			});
        		},*/
        	/*	beforecollapse:function(obj){
        			var userInfo = Academia.model.authentication.UserInfoModel;
        			if(userInfo.get("portalId")==3){
        				Ext.suspendLayouts();
        				obj.header.setTitle(false); 
        				Ext.resumeLayouts();
        			}
        		},
        		expand:function(obj){
        			var userInfo = Academia.model.authentication.UserInfoModel;
        			if(userInfo.get("portalId")==3){
        				Ext.suspendLayouts();
        				obj.setVisible(true); 
        				//obj.header.setTitle('<center>Welcome</center>');
        				Ext.resumeLayouts();
        			}
        		} */
//        	},
        	
        	'verticalnavigationmenubutton': {
                click:function(selModel, record, index, options) {
                	var userInfo = Academia.model.authentication.UserInfoModel;
                	if(userInfo.get("portalId")==6){
                		if(selModel.menu.items.items.length>0){
                			selModel.menu.items.items[0].setVisible(false);
                		}
                		if(typeof record == "undefined" || record.type == 'click') {
                			if(selModel.displayCode != undefined){
                				if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                					// multiple tab functionality will work in this case
                				}
                				else if(!isNullOrEmpty(this.getContentPanel().items.items[1])) {
                					//-----------V2D-71586-Commented :Existing Tabs should not get auto close for AU
                					/*var getcontroller=this.getController('menu.CoreERPNavigationController');
                					var getTab=getcontroller.getTab(this.getContentPanel().items.items[1].title);
                					if(getTab!=null){
                						this.getContentPanel().remove(getTab, true);
                					}
                				*/}
                				this.onNavSelectionChange(selModel, record, index, options);
                			}
                    	}
                	}
                }
            },
            'verticalMenuCollapseIcon': {
                click:function(selModel, record, index, options) {
                	var userInfo = Academia.model.authentication.UserInfoModel;
                	if(userInfo.get("portalId")==6){
                		if(selModel.menu.items.items.length>0){
                			selModel.menu.items.items[0].setVisible(false);
                		}
                		if(record.type == 'click') {
                			if(selModel.displayCode != undefined){
                				if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                					// multiple tab functionality will work in this case
                				}
                				else if(!isNullOrEmpty(this.getContentPanel().items.items[1])) {
                					//-----------V2D-71586-Commented :Existing Tabs should not get auto close for AU
                					/*var getcontroller=this.getController('menu.CoreERPNavigationController');
                					var getTab=getcontroller.getTab(this.getContentPanel().items.items[1].title);
                					if(getTab!=null){
                						this.getContentPanel().remove(getTab, true);
                					}
                				*/}
                				this.onNavSelectionChange(selModel, record, index, options);
                			}
                    	}
                	}
                }
            },
            'verticalNavigationMenuPanelItem button': {
                click:function(selModel, record, index, options) {
                	// prevent api calling multiple times
                	if(record.type == 'click') {
                		this.onNavSelectionChange(selModel, record, index, options);
                	}
                }
            },
            'verticalNavigationMenuPanelItem': {
                click:function(selModel, record, index, options) {
                	// prevent api calling multiple times
                	if(record.type == 'click') {
                		this.onNavSelectionChange(selModel, record, index, options);
                	}
                }
            },
            'verticalMenuCollapseIcon#menuTogglerItem': {
                click: function() {
                    var verticalNavigationMenu = this.getVerticalNavigationMenu();
                    verticalNavigationMenu.toggleCollapse();
                } 
            },
 		   'contentPanel': {
			   tabchange: function( tabPanel, newCard, oldCard, eOpts ) {
				   var me = this;
				   this.changeTabCls(tabPanel, newCard, oldCard, eOpts);
				   
				   setTimeout(function(){
                       var placeholderLbar = Ext.getCmp('placeholderLbar');
                       
                       if(placeholderLbar && placeholderLbar.isVisible()){
                           var menuType = 'collapsed';
                       }
                       else{
                           var menuType = 'expanded';
                       }
                       
                       me.changeActiveMenuColor(tabPanel, menuType);
                       setTimeout(function(){
                       
	                       /*if(newCard.xtype == "userprofilestructure"){
	                    	   var profileTitle = newCard.down('recentvisitedprofile').title.split("(")[0];
	                    	   var storeDataLength = newCard.down('dataview').getStore().data.length;
	                    	   
	                    	   newCard.down('recentvisitedprofile').setTitle(profileTitle + " (" + storeDataLength + ")");
	                       }*/
                       },500);
                   });
			   },
			   render:function(tb){
				   var $this=this;
				   var tbMap = new Ext.util.KeyMap(tb.getEl(), {           
					    key:[Ext.EventObject.LEFT, Ext.EventObject.RIGHT],
					    scope: this,
					    ctrl:true,
					    fn: function(e) {
					    	/**
					         * Tab switch functionality on main tabs by using arrow keys.
					         */
					         $this.switchTabs(e);
					    }
					});
			   }
 		   }
        });
    },
    changeTabCls: function(tabPanel, newCard, oldCard, eOpts) {
    	var contentPanel = this.getContentPanel(); 
 	   contentPanel.tabBar.removeCls('menuColorOne');
 	   contentPanel.tabBar.removeCls('menuColorTwo');
 	   contentPanel.tabBar.removeCls('menuColorThree');
 	   contentPanel.tabBar.removeCls('menuColorFour');
 	   contentPanel.tabBar.removeCls('menuColorFive');
 	   contentPanel.tabBar.removeCls('menuColorSix');
	   contentPanel.tabBar.removeCls('menuColorSeven');
	   contentPanel.tabBar.removeCls('menuColorEight');
	   contentPanel.tabBar.removeCls('menuColorNine');
	   contentPanel.tabBar.removeCls('menuColorTen');
	   contentPanel.tabBar.removeCls('menuColorEleven');
	   contentPanel.tabBar.removeCls('menuColorTwelve');
	   contentPanel.tabBar.removeCls('menuColorThirteen');
	   contentPanel.tabBar.removeCls('menuColorFourteen');
	   contentPanel.tabBar.removeCls('menuColorFifteen');
	   contentPanel.tabBar.removeCls('menuColorSixteen');
 	   contentPanel.tabBar.addCls(newCard.menuColorCls);
 	   contentPanel.body.removeCls('menuColorOne-body');
 	   contentPanel.body.removeCls('menuColorTwo-body');
 	   contentPanel.body.removeCls('menuColorThree-body');
 	   contentPanel.body.removeCls('menuColorFour-body');
 	   contentPanel.body.removeCls('menuColorFive-body');
 	   contentPanel.body.removeCls('menuColorSix-body');
 	   contentPanel.body.removeCls('menuColorSeven-body');
 	   contentPanel.body.removeCls('menuColorEight-body');
 	   contentPanel.body.removeCls('menuColorNine-body');
 	   contentPanel.body.removeCls('menuColorTen-body');
 	   contentPanel.body.removeCls('menuColorEleven-body');
 	   contentPanel.body.removeCls('menuColorTwelve-body');
 	   contentPanel.body.removeCls('menuColorThirteen-body');
 	   contentPanel.body.removeCls('menuColorFourteen-body');
 	   contentPanel.body.removeCls('menuColorFifteen-body');
 	   contentPanel.body.removeCls('menuColorSixteen-body');
 	   contentPanel.body.addCls(newCard.menuColorCls+'-body');
 	   contentPanel.body.addCls('contentpanelTabBody');
    },
    	
    onNavSelectionChange: function(selModel, record, index, options) {    	
    	var requestParams;
    	if(portalId == '1'){
    		requestParams = {
    	    		    "displayCode": selModel.dataObj.displayCode,
    	    		};
    	}
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	$('#innerSpinner').show();
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.FILE_PRIORITY,
    		params: {
    			type:'analyticsTraking'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if(response.length != 0){
    				if(!isNullOrEmpty(response[0].value)){
    		    		var idx = Ext.getStore('MainSearchStore').findExact('menuId',selModel.id+'-btnInnerEl');
    		    		if(idx>=0){
    		    			var menuName = Ext.getStore('MainSearchStore').getAt(idx).data.displayPath;
    		    			initGoogleAnalytics();
    		    			gtag ('event', 'Navigation', {
    		        			'event_category': menuName,
    		        			'event_label': selModel.text
    		        		});
    		        		gtag('config', response[0].value, {
    		        			page_path: selModel.text
    		        		});
    		    		}	
    		    	}
    			}
    			if(portalId == '1') {
    				Ext.Ajax.request({
    					type: 'rest',
    					url: SERVERURL.PATH_GET_USER_CLICKED_LINKS_ACTIVITY,
    					headers: {
    	                    'Content-Type': 'application/json'
    	                },
    	                jsonData: requestParams,
    					method: 'POST',
    					success: function(secondRes, action) {
    						$('#innerSpinner').hide();
    		                Ext.getBody().unmask();
                        },					
    				});
    			}
    		}
    	});
    	
    	var popiaStatusStore=Ext.getStore('common.PopiaStatusDropdownValue');
    	popiaStatusStore.getProxy().extraParams = {
  			type:'Restriction for POPIA-OPT OUT-Application'
        }; 
    	popiaStatusStore.load();
    	var enquiryPopiaStatusStore=Ext.getStore('common.EnquiryPopiaStatusDropdownValue');
    	enquiryPopiaStatusStore.getProxy().extraParams = {
  			type:'Restriction for POPIA-OPT OUT-Enquiry'
        }; 
    	enquiryPopiaStatusStore.load();
    	
    	var userInfo = Academia.model.authentication.UserInfoModel;
    	if(selModel.up('button') == undefined){
    		var MegaMenuModel = Academia.model.menu.MegaMenuDataModel;
    		for(var j in MegaMenuModel.menuData){
    			if(MegaMenuModel.menuData[j].displayCode==selModel.displayCode){
    				selModel.dataObj=MegaMenuModel.menuData[j];
    				moduleName=MegaMenuModel.menuData[j].displayCode;
    			}
    		}
    	}else {
    		moduleName=selModel.up('button').displayCode;
    		selModel.up('button').menu.hide();
    	}
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	spinnerDiv = document.getElementById('innerSpinner');
    	var navPosition = this.getVerticalNavigationMenu().collapsed;
    	var mainView = this.getContentPanel();
    	var height = mainView.getHeight()/2;
    	spinnerDiv.style.width = mainView.getWidth() + 'px';
    	if(navPosition == "left")
    	{
    		spinnerDiv.style.margin = height+"px auto "+ height+"px 60px";
    	}
    	else{
    		spinnerDiv.style.margin = height+"px auto "+ height+"px 220px";
    	}
    	$('#innerSpinner').show();
    	var that = this;
    	setTimeout(function(){
    		var record = selModel.dataObj;
    		var featurePrivilegeId = record.featurePrivilegeId;
    		/*
    		 * Call to save the system Usage
    		 * @author Akshay.Kalbhor
    		 */
    		that.saveSystemUsage(featurePrivilegeId);

    		/**
    		 * Portal id base 3 for student 
    		 */
    		if(userInfo.get("portalId")==3){
    			contentPanel = that.getContentPanel(); 
    	    	var newTab = contentPanel.items.findBy(function(tab) {
    	    		return tab.title === that.getMegaMenuTranslation(record.displayCode);
    	    	});
    	    	if (!newTab) {
    	    		mainView.add({
            			xtype: 'panel',
            			title: 'Portal',
            			hidden: true,
            			closable:true
            		});
    	    	}
        		if(record.launchView == 'stcpncstudentregistration')
    				that.addTab(getMegaMenuTranslation('SP_PNC_REGISTRATION'), record.launchView, record.menuColorCls,null,record.configCode,record.viewCode,moduleName, true);
    			else{
    			that.addStudentportalTab(that.getMegaMenuTranslation(record.displayCode), record.launchView, record.menuColorCls,moduleName);
    			}
    		}else if(userInfo.get("portalId")==7){
    			contentPanel = that.getContentPanel(); 
    	    	var newTab = contentPanel.items.findBy(function(tab) {
    	    		return tab.title === that.getMegaMenuTranslation(record.displayCode);
    	    	});
    	    	if (!newTab) {
    	    		mainView.add({
    	    			xtype: 'panel',
    	    			title: 'Portal',
    	    			hidden: true,
    	    			closable:true
    	    		});
    	    	}
    			if(record.launchView == 'stcpncstudentregistration'){
    				that.addTab(getMegaMenuTranslation('SP_PNC_REGISTRATION'), record.launchView, record.menuColorCls,null,record.configCode,record.viewCode,moduleName, true);
    			}
    			else if(record.launchView == 'submenu3_report5'){
    				that.addTab(that.getMegaMenuTranslation(record.displayCode), record.launchView, record.menuColorCls,null,record.configCode,record.viewCode,moduleName, true);
    			}
    			else{
    			that.addStudentportalTab(that.getMegaMenuTranslation(record.displayCode), record.launchView, record.menuColorCls,moduleName);
    			}
    		}else if (userInfo.get("portalId")==2){
    			contentPanel = that.getContentPanel(); 
    	    	var newTab = contentPanel.items.findBy(function(tab) {
    	    		return tab.title === that.getMegaMenuTranslation(record.displayCode);
    	    	});
    	    	if (!newTab) {
    	    		mainView.add({
    	    			xtype: 'panel',
    	    			title: 'Portal',
    	    			hidden: true,
    	    			closable:true
    	    		});
    	    	}
    			if(record.launchView == 'submenu5_report2')
    				that.addTab(that.getMegaMenuTranslation(record.displayCode), record.launchView, record.menuColorCls,null,record.configCode,record.viewCode,moduleName, true);
    			else{
    				that.addFacultyPortalTab(that.getMegaMenuTranslation(record.displayCode), record.launchView, record.menuColorCls,moduleName);
    			}
    		} else if (userInfo.get("portalId")==6){
    			that.addTabApplicantPortal(that.getMegaMenuTranslation(record.displayCode), record.launchView, record.menuColorCls,null,null,null,moduleName);
    		} else if(record.launchView=='gdabrowserview'){
        		window.open("http://gdaschools.in:8888/rtmd/parent-mobile-app/home.html");
        		$('#innerSpinner').hide();
            	Ext.getBody().unmask();
    		} else{
    			
    			var tabName =  getCommonTranslation('EXAM_CANCELLATION_REQUESTS');
    			var tabStructure= that.getTab(tabName);
    			var contantPanel = that.getContentPanel();
    			if(tabStructure!= null ){
    				contantPanel.remove(tabStructure);
    			}
    			that.addTab(getMenuDisplayName(record.displayCode), record.launchView, record.menuColorCls,null,record.configCode,record.viewCode,moduleName, true);
    		}
    		
    		//var selModelBtn = Ext.getCmp(selModel.up('button').id);
    		var verticalNavigationMenu = that.getVerticalNavigationMenu();
    		//verticalNavigationMenu.collapse();
    	
    		
    		if(record.stopEvent){
    			record.stopEvent();
    			record.stopPropagation();
    			return false;
    		} 
    	}, 20);
    },

    collapseMenu:function(){    		
    	var verticalNavigationMenu = this.getVerticalNavigationMenu();
    	verticalNavigationMenu.collapse();
	},

	loadContollers:function(contentXtype){
		if(environment=="Development"){ 
	    	var tempArr = [];
	    	tempArr = myControllers(contentXtype);
	    	if(tempArr == false){
	    		tempArr =[];
	    	}
	    	for (var i = 0; i < tempArr.length; i++) {
	    		if (this.getApplication().ctrls.indexOf(tempArr[i]) === -1) {
	    			Academia.getApplication().runAction(tempArr[i]);
	    			this.getApplication().ctrls.push(tempArr[i]);
	    		}
			}
		}
	},

    addTab: function(tabTitle, contentXtype, menuColorcls,contentPanel,configCode,viewCode,moduleName, isNavigationMenuClicked) {
    	this.loadContollers(contentXtype);
    	
    	try{
        	isNavigationMenuClicked = !isNullOrEmpty(isNavigationMenuClicked) ? isNavigationMenuClicked : false;
    	}
    	catch(e){
    		isNavigationMenuClicked = false;
    	}
    	
    	//if(!contentPanel)
    	if(!contentPanel)
    		contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var newTab = contentPanel.items.findBy(function(tab) {
    		if(!isNavigationMenuClicked){
        		return tab.title === tabTitle && contentPanel.getActiveTab() != tab;
    		}
    		else{
    			return tab.title === tabTitle;
    		}
    	});
    	
    	if(newTab && newTab.xtype == "servicerequestpanel"){
    		newTab.close();
    		newTab = false;
    	}
    	
    	if (!newTab) {
    		newTab = contentPanel.add({
    			xtype: contentXtype,
    			closable: true,
    			menuColorCls: menuColorcls,
    			title: tabTitle,
    			searchConfigCode : configCode,
    			searchResultViewCode: viewCode,
    			gridTitle: tabTitle,
    			moduleName:moduleName
    			
    		});
    	}
    	contentPanel.setActiveTab(newTab);
    	//spinnerDiv.style.display = "none";
    	$('#innerSpinner').hide();
    	Ext.getBody().unmask();
    	return newTab;
    },
    /**
     *  Added Applicant Portal 
     *  @author Deepak.Nigam
     */
    addTabApplicantPortal: function(tabTitle, contentXtype, menuColorcls,contentPanel,configCode,viewCode,moduleName) {
    	this.loadContollers("applicantmedicalstructure");
    	//if(!contentPanel)
    	if(!contentPanel)
    		contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var newTab = contentPanel.items.findBy(function(tab) {
    		return tab.title === tabTitle;
    	});
    	var itemId = this.getApplicantFormPortalObject(contentXtype);
    	if (!newTab) {
    		
    		
        		newTab = contentPanel.add({
        			xtype: contentXtype,
        			closable: true,
        			menuColorCls: menuColorcls,
        			title: tabTitle,
        			searchConfigCode : configCode,
        			searchResultViewCode: viewCode,
        			gridTitle: tabTitle,
        			moduleName:moduleName,
        			itemId:itemId
        		});
    	}
    	contentPanel.setActiveTab(newTab);
    	//spinnerDiv.style.display = "none";
    	$('#innerSpinner').hide();
    	Ext.getBody().unmask();
    	return newTab;
    },
    /**
     *  Added Student Portal 
     *  @author Rajkumar.Patidar
     */
    addStudentportalTab: function(tabTitle, contentXtype, menuColorcls,moduleName) {
    var	contentPanel = this.getContentPanel(); 
    this.loadContollers(contentXtype);
    	contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var newTab = contentPanel.items.findBy(function(tab) {
    		return tab.title === tabTitle;
    	});
    	var tabInfo = this.getPortalObject(contentXtype,tabTitle);
    	if (!newTab) {
    		if((portalId==3 || portalId==7) && contentXtype=="parentguardiangrid"){
    			
    			newTab = contentPanel.add({
    				xtype: 'personinfostudentportal',	
    				closable: true,
    				menuColorCls: menuColorcls,
    				title: tabTitle,
    				contentXtype: contentXtype,
    				contentXtypeItemId: tabInfo.itemId,
    				moduleName:moduleName,
    				items:[]
    			});
    			newTab.add({
					xtype: 'parentguardiancardlayoutview'
				});
    		}else if((portalId==7) && contentXtype=="feepayerdetailgrid"){
    			newTab = contentPanel.add({
    				xtype: 'personinfostudentportal',	
    				closable: true,
    				menuColorCls: menuColorcls,
    				title: tabTitle,
    				contentXtype: contentXtype,
    				contentXtypeItemId: tabInfo.itemId,
    				moduleName:moduleName,
    				items:[]
    			});
    			newTab.add({
					xtype: 'feepayerdetailcardlayoutview',
					moduleName:moduleName,
				});
    		}else{
    			
    			if((portalId==3 || portalId==7) && contentXtype == "viewgallerystructure"){
    				var tabCount = contentPanel.items.items.length;
    				if(tabCount>0){
    					contentPanel.items.items[tabCount-1].close(); //V2D-444343
    				}
    				newTab = contentPanel.add({
            			xtype: 'viewgallerystructure',	
                		closable: true,
            			menuColorCls: menuColorcls,
            			moduleName:moduleName,
            			title: tabTitle
            		});
    			}
    			else if (portalId==3 && (contentXtype == "studentforacademictoicsstructure")){
    				newTab = contentPanel.add({
        				xtype: 'personinfostudentportal',	
        				closable: true,
        				menuColorCls: menuColorcls,
        				title: tabTitle,
        				contentXtype: contentXtype,
        				moduleName:moduleName,
        				contentXtypeItemId: tabInfo.itemId,
        				autoScroll: false,
        				layout: 'fit',
        				items:[]
        			});
    			}else if((portalId==3 || portalId==7) && contentXtype == "examtimetable"){
    				newTab = contentPanel.add({
    					xtype: 'personinfostudentportal',	
        				closable: true,
        				menuColorCls: menuColorcls,
        				title: tabTitle,
        				contentXtype: contentXtype,
        				moduleName:moduleName,
        				contentXtypeItemId: tabInfo.itemId,
        				items:[],
        				cls: 'examtimetablestructure'
            		});
    			}
    			else if(portalId==7 && contentXtype == "revaluationstudentstructure"){
    				newTab = contentPanel.add({
        				xtype: 'personinfostudentportal',	
        				closable: true,
        				menuColorCls: menuColorcls,
        				title: tabTitle,
        				contentXtype: contentXtype,
        				moduleName:moduleName,
        				contentXtypeItemId: tabInfo.itemId,
        				layout: 'fit',
        				items:[]
        			});
    			}
    			else{
    				newTab = contentPanel.add({
        				xtype: 'personinfostudentportal',	
        				closable: true,
        				menuColorCls: menuColorcls,
        				title: tabTitle,
        				contentXtype: contentXtype,
        				moduleName:moduleName,
        				contentXtypeItemId: tabInfo.itemId,
        				items:[]
        			});
    			}
    		}
    	}else if(contentXtype == "sgappointmentfollowupstructureforsp"){
    		var allOpenTab = contentPanel.items.items; 
    		Ext.each(allOpenTab,function(tab){
    			if(tab.title == getMegaMenuTranslation('SP_APPOINTMENT_FOLLOW_UP')){
    				contentPanel.remove(tab);
    				return false;
    			}
    		});
    		newTab = contentPanel.add({
				xtype: 'personinfostudentportal',	
				closable: true,
				menuColorCls: menuColorcls,
				title: tabTitle,
				contentXtype: contentXtype,
				moduleName:moduleName,
				contentXtypeItemId: tabInfo.itemId,
				items:[]
			});
    	}
    	contentPanel.setActiveTab(newTab);
    	$('#innerSpinner').hide();
    	Ext.getBody().unmask();
    	return newTab;
    },
    
    /**
     *  Added Faculty Portal 
     *  @author Dharmendra.Prajapati
     */
    addFacultyPortalTab: function(tabTitle, contentXtype, menuColorcls,moduleName) {
    	this.loadContollers(contentXtype);
    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var newTab = contentPanel.items.findBy(function(tab) {
    		return tab.title === tabTitle;
    	});
    	var tabInfo = this.getFacultyPortalObject(contentXtype,tabTitle);
    	if(contentXtype == 'manageevalresultmasterstructure') {
			var getTab=this.getTab(getMegaMenuTranslation('MARK_ENTRY'));
    	   if(getTab!=null){
    		   contentPanel.remove(getTab, true);
    		   newTab = null;
    	   }
		}
    	if (!newTab) {
    		if(portalId==2 && contentXtype=="facultyfamilydetailgrid"){
    			newTab = contentPanel.add({
        			xtype: 'personinfofacultyportal',	
            		closable: true,
        			menuColorCls: menuColorcls,
        			title: tabTitle,
        			contentXtype: contentXtype,
        			moduleName:moduleName,
        			contentXtypeItemId: tabInfo.itemId,
        			items:[]
        		});
    			newTab.add({
					xtype: 'facultyfamilydetailcardlayoutview'
				});
    		}
    		/*else if(portalId==2 && contentXtype=="studentdisciplinaryactionsreporttabstructure"){
				newTab = contentPanel.add({
            			xtype: 'personinfofacultyportal',	
                		closable: true,
            			menuColorCls: menuColorcls,
            			title: tabTitle,
            			contentXtype: contentXtype,
            			moduleName:moduleName,
            			contentXtypeItemId: tabInfo.itemId,
            			items:[]
            		});
			}*/ else{
    			if(contentXtype == "viewgallerystructure"){
    				var tabCount = contentPanel.items.items.length;
    				if(tabCount>0){
    					contentPanel.items.items[tabCount-1].close(); //V2D-450209
    				}
    				newTab = contentPanel.add({
            			xtype: 'viewgallerystructure',	
                		closable: true,
            			menuColorCls: menuColorcls,
            			moduleName:moduleName,
            			title: tabTitle
            		});
    			}
				else if(contentXtype == "studentdisciplinaryactionsreporttabstructure" || contentXtype == "marksummaryreportview" || contentXtype == "facultymarksheetreportstructure" || contentXtype == "detailedschedulefacultystructure"){
                     newTab = contentPanel.add({
                        xtype: 'personinfofacultyportal',    
                        closable: true,
                        menuColorCls: menuColorcls,
                        title: tabTitle,
                        contentXtype: contentXtype,
                        moduleName:moduleName,
                        contentXtypeItemId: tabInfo.itemId,
                        items:[],
                        layout: 'fit'
                    });
                }
	             else{
    				if(contentXtype=="marksummaryreportview" || contentXtype=="facultymarksheetreportstructure" || contentXtype=="facultyappointmentstructuretab" || contentXtype=="facultypendingmarkentrystructure" || contentXtype=="evalrlmasterstructure"){
    					newTab=contentPanel.add({
    						xtype: 'personinfofacultyportal',	
	                		closable: true,
	            			menuColorCls: menuColorcls,
	            			title: tabTitle,
	            			contentXtype: contentXtype,
	            			moduleName:moduleName,
	            			contentXtypeItemId: tabInfo.itemId,
	            			items:[],
							layout:"fit"
						})
					}
					else if(contentXtype.indexOf('faculty_submenu') !== -1){

						newTab = contentPanel.add({
            			xtype: 'personinfofacultyportal',	
                		closable: true,
            			menuColorCls: menuColorcls,
            			title: tabTitle,
            			contentXtype: contentXtype,
            			moduleName:moduleName,
            			contentXtypeItemId: tabInfo.itemId,
            			items:[],
            			layout: 'fit',
            			  autoScroll: false,
            			    cls:'horizontal-scrolling-fix contentPanel'
            		});
				  
					}else{
						newTab = contentPanel.add({
            			xtype: 'personinfofacultyportal',	
                		closable: true,
            			menuColorCls: menuColorcls,
            			title: tabTitle,
            			contentXtype: contentXtype,
            			moduleName:moduleName,
            			contentXtypeItemId: tabInfo.itemId,
            			items:[],
            			layout: 'vbox'
            		});
				  }
    	     }
		  
    	}
    	}
    	contentPanel.setActiveTab(newTab);
    	$('#innerSpinner').hide();
    	Ext.getBody().unmask(); 
    	return newTab;
    },

    getTab: function(tabTitle) {
        contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
        if (isNullOrEmpty(tabTitle)) {
        	return contentPanel.getActiveTab();
        }else{
        	var tab = contentPanel.items.findBy(function(tab) {
                return tab.title === tabTitle;
            });
        	 return tab;
        }
    },
    
    getTabByXtype: function(tabXtype) {
    	contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
        if (isNullOrEmpty(tabXtype)) {
        	return contentPanel.getActiveTab();
        }else{
        	var tab = contentPanel.items.findBy(function(tab) {
                return tab.xtype === tabXtype;
            });
        	 return tab;
        }
    },
    
    
    getInnerTab: function(contentPanel,tabTitle) {
    	if(!isNullOrEmpty(contentPanel)){
            if (isNullOrEmpty(tabTitle)) {
            	return contentPanel.getActiveTab();
            }else{
            	var tab = contentPanel.items.findBy(function(tab) {
            		return tab.title === tabTitle;
            	});
            	return tab;
            }
    	}
    	else{
    		return null;
    	}
    },
    
    /**
     * method to get the content panels active tab reference.
     * @author akshay.kalbhor
     */
    getActiveTabfromContentPanel: function() {
        contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
       	return contentPanel.getActiveTab();
    },

    getMegaMenuTranslation: function(key) {
        return getMegaMenuTranslation(key);
    },
    /**
     * get form itemId for Student portal.
     *  @author Rajkumar.Patidar
     */
    getPortalObject : function(contentXtype,tabTitle){
    	var tabInfo = new Object();
    	var itemId=null;
    	
    	if(contentXtype=='kysdetailsgrid' && tabTitle==getMegaMenuTranslation('SP_PENDING')){
    		itemId='studentKYSHistoryDetailsGrid';
    	}
    	if(contentXtype=='kysdetailsgrid' && tabTitle==getMegaMenuTranslation('SP_KYS')){
    		itemId='studentKYSPendingDetailsGrid';
    	}
    	if(contentXtype=='serviceoptgrid' && tabTitle=='Past Services'){
    		itemId='studentServiceHistoryGrid';
    	}
    	if(contentXtype=='serviceoptgrid' && tabTitle=='Current Services'){
    		itemId='studentServiceOptGrid';
    	}
    	/*if(contentXtype=='communityoptgrid' && tabTitle=='Past Community'){
    		itemId='studentCommunityHistoryGrid';
    	}*/
    	if((contentXtype=='communityoptgrid' && tabTitle==getMegaMenuTranslation('SP_COMMUNITIES_HISTORY')) || (contentXtype=='communityoptgrid' && tabTitle==getMegaMenuTranslation('PP_COMMUNITIES_HISTORY'))){
    		itemId='studentCommunityHistoryGrid';
    	}
    	/*if(contentXtype=='communityoptgrid' && tabTitle=='Current Community'){
    		itemId='studentCommunityOptGrid';
    	}*/
    	if((contentXtype=='communityoptgrid' && tabTitle==getMegaMenuTranslation('SP_COMMUNITIES_OPT_IN_OUT')) || (contentXtype=='communityoptgrid' && tabTitle==getMegaMenuTranslation('PP_COMMUNITIES_OPT_IN_OUT'))){
    		itemId='studentCommunityOptGrid';
    	}
    	if(contentXtype=='communityoptgrid' && tabTitle=='Past Groups'){
    		itemId='studentCommunityHistoryGrid';
    	}
    	if(contentXtype=='communityoptgrid' && tabTitle=='Current Groups'){
    		itemId='studentCommunityOptGrid';
    	}
    	if(portalId == 7){
    		if(contentXtype=='feepayerdetailgrid' && tabTitle==getMegaMenuTranslation('PP_FEE_PAYER_DETAILS')){
        		itemId='parentFeePayerDetailGridItemId';
        	}
    	}else{
    		if(contentXtype=='feepayerdetailgrid' && tabTitle==getMegaMenuTranslation('SP_FEE_PAYER_DETAILS')){
        		itemId='studentFeePayerDetailGridItemId';
        	}
    		
    	}
    	switch(contentXtype){
    	/**
    	 * (1)(MY ACADEMICS) course execution tab
    	 */
    	case 'scheduledetails' :{
    		itemId='studentScheduleDetails';
    		break;
    	}
    	
    	case 'facultyteachinghourdetails' :{
    		itemId='facultyTeachingHourdetails';
    		break;
    	}
    	case 'attendancedetails' :{
    		itemId='studentAttendanceDetails';
    		break;
    	}
    	case 'mycoursedetails' :{
    		itemId='studentMyCourseDetails';
    		break;
    	}
    	/**
    	 * (2)(MY FEES) Refunds and Payment tab
    	 */
    	case 'onlinepaymentstructureforportal' :{
    		itemId='onlinepaymentgridforstudentportal';
    		break;
    	}
    	case 'onlinepaymentgrid' :{
    		itemId='onlinePaymentGrid';
    		break;
    	}
    	case 'feeplangrid' :{
    		itemId='studentFeePlanGrid';
    		break;
    	}
    	case 'pendingbillsgrid' :{
    		itemId='studentPendingBillsGrid';
    		break;
    	}
    	case 'headwisebillsgrid' :{
    		itemId='studentHeadWiseBillDetails';
    		break;
    	}
    	case 'paymentreceivedhistorygrid' :{
    		itemId='studentPaymentReceivedHistoryGrid';
    		break;
    	}
    	case 'refundhistorygrid' :{
    		itemId='studentRefundHistoryGrid';
    		break;
    	}
    	case 'refundablepaymentgrid' :{
    		itemId='studentRefundablePaymentGrid';
    		break;
    	}
    	case 'postdatedchequegrid' :{
    		itemId='studentPostDatedChequeGrid';
    		break;
    	}
    	
    	/**
    	 * (3)(MY REQUEST) Request tab
    	 */
    	case 'requestraisedhistorygrid' :{
    		itemId='studentRequestRaisedHistoryGrid';
    		break;
    	}
    	case 'requestpendingdecisiongrid' :{
    		itemId='studentRequestPendingDecisionGrid';
    		break;
    	}
    	case 'hostelpersondetailsgrid' :{
    		itemId='studentHostelPersonDetailsGrid';
    		break;
    	}
    	case 'transportpersondetailsgrid' :{
    		itemId='studentTransportPersonDetailsGrid';
    		break;
    	}
    	/**
    	 * (4)(MY SERVICES & GROUPS) Services & Communities tab
    	 */
    	
    	
    	/**
    	 * (5)(MY DISCIPLINE) Discipline tab
    	 */
    	case 'disciplinaryactiongrid' :{
    		itemId='studentDisciplinaryActionGrid';
    		break;
    	}
    	case 'disciplinaryactionsugrid' :{
    		itemId='studentDisciplinaryActionSUGrid';
    		break;
    	}
    	case 'positiveincidentgrid' :{
    		itemId='studentPositiveIncidentGrid';
    		break;
    	}
    	case 'negativeincidentgrid' :{
    		itemId='studentNegativeIncidentGrid';
    		break;
    	}
    	/**
    	 * (6)KYS and Document tab
    	 */
    	/*case 'documentgrid' :{
    		itemId='studentDocumentGrid';
    		break;
    	}*/
    	case 'studentonlinedocumentgrid' :{
    		itemId='studentOnlineDocumentGridItemId';
    		break;
    	}
    	/**
    	 * (7)(MY PROFILE) Personal Information tab
    	 */
    	case 'personalinformationform' :{
    		itemId='studentPersonalInformationForm';
    		break;
    	}
    	case 'addressdetails' :{
    		itemId='studentAddressDetails';
    		break;
    	}
    	case 'parentguardiangrid' :{
    		itemId='studentParentGuardianGrid';
    		break;
    	}
    	case 'siblingdetailsgrid' :{
    		itemId='studentSiblingDetailsGrid';
    		break;
    	}
    	case 'educationhistorygrid' :{
    		itemId='studentEducationHistoryGrid';
    		break;
    	}
    	case 'workexperiencegrid' :{
    		itemId='studentWorkExperienceGrid';
    		break;
    	}
    	case 'medicalgrid' :{
    		itemId='studentMedicalGrid';
    		break;
    	}
    	case 'vaccinationgrid' :{
    		itemId='studentVaccinationGrid';
    		break;
    	}
    	case 'extracurriculargrid' :{
    		itemId='studentExtraCurricularGrid';
    		break;
    	}
    	case 'physicalcharacteristicsgrid' :{
    		itemId='studentPhysicalCharacteristicsGrid';
    		break;
    	}
    	case 'researchtypegrid' :{
    		itemId='studentResearchTypeGrid';
    		break;
    	}
    	case 'seminardetailsgrid' :{
    		itemId='studentSeminarDetailsGrid';
    		break;
    	}
    	case 'trainingpersondetailsgrid' :{
    		itemId='studentTrainingPersonDetailsGrid';
    		break;
    	}
    	case 'patentdetailsgrid' :{
    		itemId='studentPatentDetailsGrid';
    		break;
    	}
    	case 'masterscheduledetails' :{
    		itemId='studentMasterScheduleDetails';
    		break;
    	}
    	case 'competitiveexamgrid' :{
    		itemId='studentCompetitiveExamGrid';
    		break;
    	}
    	case 'identitydetailsgrid' :{
    		itemId='studentIdentityDetailsGrid';
    		break;
    	}
    	case 'otherinformationdetailsform' :{
    		itemId='studentOtherinformationDetailsForm';
    		break;
    	}
    	case 'ssodetailsgrid' :{
    		itemId='studentssodetailsgridItemId';
    		break;
    	}
    	case 'manageholdsstructure' :{
    		itemId='manageholdsstructureItemId';
    		break;
    	}
    	case 'nonacademicachievementsgrid' :{
    		itemId='studentnonacademicachievementsgridItemId';
    		break;
    	}
    	/*case 'feepayerdetailgrid' :{
    		itemId='studentFeePayerDetailGridItemId';
    		break;
    	}*/
    	case 'medicaldetailsform' :{
    		itemId='studentMedicalDetailsFormItemId';
    		break;
    	}
    	case 'sgstudentappointmentdetailgrid' :{
    		itemId='SGStudentAppointmentDetailGridItemId';
    		break;
    	}
    	case 'studentconditionsforadmission' :{
    		itemId='studentconditionsforadmissionItemId';
    		break;
    	}
    	case 'studentconditionsdocumentlist' :{
    		itemId='studentconditionsdocumentlistItemId';
    		break;
    	}
    	case 'manageentriesforstudentprofile' :{
    		itemId='studentInfirmaryManageEntriesGrid';
    		break;
    	}
    	case 'infirmarydetaildocumentgrid' :{
    		itemId='studentInfirmaryDetailDocumentGrid';
    		break;
    	}
    	case 'studentpersonhostelrequirementform' :{
    		itemId='studentPersonHostelRequirementForm';
    		break;
    	}
    	case 'socioeconomicinformationform' :{
    		itemId='admStudentSocioEconomicFormItemId';
    		break;
    	}
    	case 'studentprogramwiseconditionsforadmission' :{
    		itemId='studentprogramwiseconditionsforadmissionItemId';
    		break;
    	}
    	case 'livingarrangementgrid' :{
    		itemId='studentLivingArrangementGridItemId';
    		break;
    	}
    	case 'studentethicsclearancelettergrid' :{
    		itemId='studentethicsclearancelettergridId';
    		break;
    	}
    	case 'studentownprogressreportgrid' :{
    		itemId='studentownprogressreportgridId';
    		break;
    	}
    	case 'studentmougrid' :{
    		itemId='studentmougridId';
    		break;
    	}
    	case 'passportgrid' :{
    		itemId='studentPassportGrid';
    		break;
    	}
    	case 'visadetailgrid' :{
    		itemId='studentVisaGrid';
    		break;
    	}case 'studenteducationhistorydetailgrid' :{
    		itemId='studentEducationHistoryDetailGrid';
    		break;
    	}
    	case 'studentinsurancedetailsgrid' :{
    		itemId='studentInsuranceDetailsGrid';
    		break;
    	}
    	
    	case 'permitgrid' :{
    		itemId='studentPermitGrid';
    		break;
    	}
    	case 'studentlanguageinformationgrid' :{
    		            itemId='studentLanguagesInformationGridItemId';
    		            break;
    		        }
    	case 'healthinformationdetailgrid' :{
    		            itemId='studentHealthInformationGridItemId';
    		            break;
    		        }
    	case 'learningallowancegrid' :{
    		            itemId='learningAllowanceItemId';
    		            break;
    		        }
    	}
    	tabInfo.itemId = itemId;
    	return tabInfo;
    },
    
    /**
     * get faculty portal object 
     */
    getFacultyPortalObject:function(contentXtype,tabTitle){

    	var tabInfo = new Object();
    	var itemId=null;
    	/**
    	 *  My Services & Groups
    	 */
    	if(contentXtype=='serviceoptgrid' && tabTitle=='Services History'){
    		itemId='facultyServiceHistoryGrid';
    	}
    	if(contentXtype=='serviceoptgrid' && tabTitle=='Service Opt In/Opt Out'){
    		itemId='facultyServiceOptGrid';
    	}
    	if(contentXtype=='communityoptgrid' && tabTitle=='Communities History'){
    		itemId='facultyCommunityHistoryGrid';
    	}
    	if(contentXtype=='communityoptgrid' && tabTitle=='Communities Opt In/Opt Out'){
    		itemId='facultyCommunityOptGrid';
    	}
    	
    	
    	
    	switch(contentXtype){
    	
    	case 'facultyportalexamduty' :{
    		itemId='facultyportalexamdutyItemId';
    		break;
    	}
    	case 'employeepersonalinformationform' :{
    		itemId='facultyPersonalInformationForm';
    		break;
    	}
    	case 'facultyaddressdetails' :{
    		itemId='facultyAddressDetails';
    		break;
    	}
    	case 'educationhistorygrid' :{
    		itemId='facultyEducationHistoryGrid';
    		break;
    	}
    	case 'workexperiencegrid' :{
    		itemId='facultyWorkExperienceGrid';
    		break;
    	}
    	case 'medicalgrid' :{
    		itemId='facultyMedicalGrid';
    		break;
    	}
    	case 'vaccinationgridforapplicantfaculty' :{
    		itemId='facultyVaccinationGrid';
    		break;
    	}
    	case 'extracurriculargrid' :{
    		itemId='facultyExtraCurricularGrid';
    		break;
    	}
    	case 'researchtypegrid' :{
    		itemId='facultyResearchTypeGrid';
    		break;
    	}
    	case 'seminardetailsgrid' :{
    		itemId='facultySeminarDetailsGrid';
    		break;
    	}
    	case 'insurancehistorygrid' :{
    		itemId='facultyInsuranceHistoryGrid';
    		break;
    	}
    	case 'physicalcharacteristicsgrid' :{
    		itemId='facultyPhysicalCharacteristicsGrid';
    		break;
    	}
    	case 'trainingpersondetailsgrid' :{
    		itemId='facultyTrainingPersonDetailsGrid';
    		break;
    	}
    	case 'patentdetailsgrid' :{
    		itemId='facultyPatentDetailsGrid';
    		break;
    	}
    	case 'competitiveexamgrid' :{
    		itemId='facultyCompetitiveExamGrid';
    		break;
    	}
    	case 'hostelpersondetailsgrid' :{
    		itemId='facultyHostelPersonDetailsGrid';
    		break;
    	}
    	case 'transportpersondetailsgrid' :{
    		itemId='facultyTransportPersonDetailsGrid';
    		break;
    	}
    	case 'facultyfamilydetailgrid' :{
    		itemId='facultyFamilyDetailGridItemId';
    		break;
    	}
    	/**
    	 *  Course Execution
    	 *   
    	 */
    	case 'scheduledetails' :{
    		itemId='facultyScheduleDetails';
    		break;
    	}
    	case 'facultyattendancedetails' :{
    		itemId='facultyAttendanceDetails';
    		break;
    	}
    	case 'programcoursesearchpanel' :{
    		itemId='facultyProgramCourseSearchPanel';
    		break;
    	}
    	case 'masterschedulefacultysearchfilter' :{
    		itemId='masterschedulefacultysearchfilter';
    		break;
    	}
    	case 'facultyteachinghourdetails' :{
    		itemId='facultyTeachingHourdetails';
    		break;
    	}
    	
    	/**
    	 * Service & Communities 
    	 */
    	//case 'serviceoptgrid' :{
    	//	itemId='facultyServiceHistoryGrid';
    	//	break;
    	//}
    	/*case 'serviceoptgrid' :{
    		itemId='facultyServiceOptGrid';
    		break;
    	}*/
    	
    	//case 'communityoptgrid' :{
    		//itemId='facultyCommunityHistoryGrid';
    		//break;
    	//}
    	
    	/*case 'communityoptgrid' :{
    		itemId='facultyCommunityOptGrid';
    		break;
    	}*/
    	
    	
    	/**
    	 *  Requests 
    	 */
    	case 'requestraisedhistorygrid' :{
    		itemId='facultyRequestRaisedHistoryGrid';
    		break;
    	}
    	
    	case 'requestexecutedhistorygrid' :{
    		itemId='facultyRequestExecutedHistoryGrid';
    		break;
    	}
    	
    	case 'requestpendingdecisiongrid' :{
    		itemId='facultyRequestPendingDecisionGrid';
    		break;
    	}
    	case 'requestpendingactiongrid' :{
    		itemId='facultyRequestPendingActionGrid';
    		break;
    	}
    	
    	/**
    	 *  Payment and Refunds
    	 * 
    	 */
    	
    	case 'pendingbillsgrid' :{
    		itemId='facultyPendingBillsGrid';
    		break;
    	}
    	case 'paymentreceivedhistorygrid' :{
    		itemId='facultyPaymentReceivedHistoryGrid';
    		break;
    	}
    	case 'paymentmadehistorygrid' :{
    		itemId='facultyPaymentMadeGrid';
    		break;
    	}
    	case 'postdatedchequegrid' :{
    		itemId='facultyPostDatedChequeGrid';
    		break;
    	}
    	
    	/**
    	 *  Disciplinary Action
    	 * 
    	 */    	
    	
    	case 'disciplinaryactiongrid' :{
    		itemId='facultyDisciplinaryActionGrid';
    		break;
    	}
    	case 'negativeincidentgrid' :{
    		itemId='facultyNegativeIncidentGrid';
    		break;
    	}
    	case 'positiveincidentgrid' :{
    		itemId='facultyPositiveIncidentGrid';
    		break;
    	}
    	case 'documentgrid' :{
    		itemId='facultyDocumentGrid';
    		break;
    	}
    	case 'otherinformationdetailsform' :{
    		itemId='facultyOtherinformationDetailsForm';
    		break;
    	}
    	case 'ssodetailsgrid' :{
    		itemId='facultyssodetailsgridItemId';
    		break;
    	}
    	case 'onlinedocumentgrid' :{
    		itemId='facultyOnlineDocumentGridItemId';
    		break;
    	}    
    	case 'physicaldocumentgrid' :{
    		itemId='facultyPhysicalDocumentGridItemId';
    		break;
    	}
    	case 'staffworkhoursgrid' :{
    		itemId='facultyWorkHoursGrid';
    		break;
    	}
    	case 'facultycourseinterestgrid' :{
    		itemId='facultycourseinterestgridId';
    		break;
    	}
    	case 'facultynonacademicachievementsgrid' :{
    		itemId='facultynonacademicachievementsgrid';
    		break;
    	}
    	case 'studentinsurancedetailsgrid' :{
    		itemId='studentInsuranceDetailsGrid';
    		break;
    	} 
    	}
    	
    	tabInfo.itemId = itemId;
    	return tabInfo;
    
    	
    },
    getApplicantFormPortalObject : function(contentXtype,tabTitle){
    	var tabInfo = new Object();
    	var itemId=null;
    	switch(contentXtype){
    	/**
    	 * (1)(MY ACADEMICS) course execution tab
    	 */
    	case 'addressdetails' :{
    		itemId='applicantAddressDetails';
    		break;
    	}
    	case 'medicalgrid' :{
    		itemId='applicantMedicalGrid';
    		break;
    	}
    	case 'workexperiencegrid' :{
    		itemId='applicantWorkExperienceGrid';
    		break;
    	}
    	case 'applicationdetails' :{
    		itemId='applicantApplicationDetails';
    		break;
    	}
    	case 'educationhistorygrid' :{
    		itemId='applicantEducationHistoryGrid';
    		break;
    	}
    	case 'otherinformationdetailsform' :{
    		itemId='applicantOtherinformationDetailsForm';
    		break;
    	}
    	case 'applicationconditionsforadmission' :{
    		itemId='applicationconditionsforadmissionFormId';
    		break;
    	}
    	case 'applicationconditionsdocumentlist' :{
    		itemId='applicationconditionsdocumentlistItemId';
    		break;
    	}
    	case 'applicationreviewdetails' :{
    		itemId='reviewdetails';
    		break;
    	}
    	case 'reviewdetailspanel' :{
    		itemId='ReviewDetailsPanel';
    		break;
    	}
    	case 'personhostelrequirementform' :{
    		itemId='applicantPersonHostelRequirementForm';
    		break;
    	}
    	case 'communicationhistorystructure' :{
    		itemId='applicantcommunicationhistorystructureItemId';
    		break;
    	}
    	case 'applicationconditionsreviewdetails' :{
    		itemId='conditionsreviewdetails';
    		break;
    	}
    	case 'applicationprogramwiseconditionsforadmission' :{
    		itemId='applicationProgramWiseConditionsforAdmissionFormId';
    		break;
    	}
    		case 'applicationdetailschecklist' :{
    		itemId='applicationdetailschecklistId';
    		break;
    	}
    		case 'applicationandadmissioncomments' :{
        		itemId='applicationandadmissioncommentsId';
        		break;
        	}
    	case 'studentpostinfogrid' :{
        		itemId='studentpostinfogridId';
        		break;
        	}
    	case 'studentjointdegreegrid' :{
    		itemId='studentjointdegreegridId';
    		break;
    		}
	    case 'studentthesistitlegrid' :{
			itemId='studentthesistitlegridId';
			break;
			}
	    case 'studentownprogressreportgrid' :{
			itemId='studentownprogressreportgridId';
			break;
			}
	    case 'studentmougrid' :{
    		itemId='studentmougridId';
    		break;
    	}
	    case 'functionaryprogressreportgrid' :{
    		itemId='functionaryprogressreportgridId';
    		break;
    	}
	    case 'studentethicsclearancelettergrid' :{
    		itemId='studentethicsclearancelettergridId';
    		break;
    	}
	    case 'functionarydetailsgrid' :{
    		itemId='functionarydetailsgridId';
    		break;
    	}
	    case 'nominateexaminersgrid' :{
    		itemId='nominateexaminersgridId';
    		break;
    	}
	    case 'independentnonexaminingchairpersonreportgrid' :{
    		itemId='independentnonexaminingchairpersonreportgridId';
    		break;
    	}
	    case 'proofofactivitygrid' :{
    		itemId='proofofactivitygridId';
    		break;
    	}
	    case 'applicantpassportgrid' :{
    		itemId='applicantpassportgridId';
    		break;
    	}
	    case 'applicantpermitgrid' :{
    		itemId='applicantpermitgridId';
    		break;
    	}
	    case 'applicantvisagrid' :{
    		itemId='applicantvisagridId';
    		break;
    	}
	    
	    case 'applicantinsurancedetailsgrid' :{
    		itemId='applicantInsuranceDetailsGrid';
    		break;
    	}
	    case 'salesforceadmissiondetailsgrid' :{
    		itemId='salesforceadmissiondetailsgridId';
    		break;
    	}
	    case 'applicationacademictopicStructure':{ 
    		itemId='applicationacademictopicStructureId';
    		break;
    	}
		}
    	tabInfo = itemId;
    	return tabInfo;
    },
    /**
     * Method to save the system module usage for a user.
     * Calls the API for saving the SYSTEM_MODULE_USAGE on the server.
     * @param {Number} featurePrivilegeId of the clicked menu.
     * @author Akshay.Kalbhor
     */ 
    saveSystemUsage: function(featurePrivilegeId) {
        var url = SERVERURL.SAVE_SYSTEM_MODULE_USAGE;
        url = url.concat('?featurePrivilegeId=' + featurePrivilegeId);
        Ext.getBody().mask(null, 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            async:true,
            params: {
            	featurePrivilegeId: featurePrivilegeId
            },
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            success: function() {
               // Ext.getBody().unmask();      code comment for firefox issue (mask stop before load page)     	  	
            }
        });
    
    },
    /**
     * Tab switch functionality on main tabs by using arrow keys.
     */
    switchTabs:function (e) {
		// note the items.items - no idea why
		 var tabs=this.getContentPanel();
		var items = tabs.items.items;

		// grab the active tab
		var active_tab = tabs.getActiveTab();

		// grab the total number of tabs
		var total_tabs = items.length;

		// loop the tabs
		for (i = 0; i < items.length; i++) {
			// find the active tab based on the id property.
			if (active_tab.id == items[i].id) {
				// do we want to move left?
				if (e == Ext.EventObject.LEFT) {
					// move left
					var next = (i - 1)
					if (next < 0) {
						// we're at -1, set to last tab
						next = (total_tabs - 1);
					}
				} else if(e == Ext.EventObject.RIGHT) {
					// move right
					var next = (i + 1);
					if (next >= total_tabs) {
						// we've gone 1 too many set to start
						// position.
						next = 0;
					}
				}
				// set the tab and return there's no need to
				// carry on
				tabs.setActiveTab(items[next].id);
				return;
			}
     }
   },
   
   changeActiveMenuColor: function(tabPanel, menuType){
       var me = this;
       var activeMenuCls = 'activeMenuItem';
       var currentMenuModuleNameKey = tabPanel.getActiveTab().moduleName;

       //-- START --- CODE FOR EXPANDED MENU ITEMS
       if(!menuType || menuType=="expanded"){
           // Getting All menu Buttons
           var allMenuBtns = $('.menu-button');

           // Remove active class from all menu items
           Ext.each(allMenuBtns, function(currentMenuBtn){
               currentMenuBtn.classList.remove(activeMenuCls);
           });

           // Adding active class on current menu item
           if(!isNullOrEmpty(currentMenuModuleNameKey)){
               var currentModule = getMegaMenuTranslation(currentMenuModuleNameKey);
               var currentModuleBtn = me.findElementByText(currentModule);

               if(currentModuleBtn.length){
            	   if(currentMenuModuleNameKey=='ADMISSIONS'){
                       if(currentModuleBtn.length==1){
                    	  currentModuleBtn[0].classList.add(activeMenuCls);
                       }else{
                    	   currentModuleBtn[1].classList.add(activeMenuCls);
                       }
            	   }else{
            	       currentModuleBtn[0].classList.add(activeMenuCls);
            	   }
               }
           }
       }

       //-- START --- CODE FOR COLLAPSED MENU ITEMS
       if(menuType=="collapsed"){
           // Getting All menu Buttons
           var allMenuBtnsCollapsed = Ext.ComponentQuery.query('verticalMenuCollapseIcon');
           
           // Remove active class from all menu items
           Ext.each(allMenuBtnsCollapsed, function(currentMenuBtnCollapsed){
               currentMenuBtnCollapsed.removeCls(activeMenuCls);
           });
           
           // Adding active class on current menu item
           if(!isNullOrEmpty(currentMenuModuleNameKey)){
               var currentModuleCollapsed = getMegaMenuTranslation(currentMenuModuleNameKey);
               var currentModuleBtnCollapsed = $("#placeholderLbar-body").find("[data-qtip='"+currentModuleCollapsed+"']"); 
               
               if(currentModuleBtnCollapsed.length == 1){
                   currentModuleBtnCollapsed[0].classList.add(activeMenuCls);
               }
           }
       }
   },
   
   findElementByText: function(text) {
       var jSpot = $("span:contains(" + text + ")")
       .filter(function() { return $(this).children().length === 0;})
       .parent();  // because you asked the parent of that element

       if(jSpot.length){
           return jSpot.parent().parent();
       }
       else{
           return jSpot;
       }
   },
   hideGraduationCermonymenu:function(searchStore){
	   var me = this,
	   formVertical= me.getVerticalNavigationMenu(),
	   searchStore = formVertical.down('#searchComboBox').getStore();
	   try{
	   Ext.Ajax.request({
    		type : 'rest',
    		async: false,
    		method : 'GET',
    		url : SERVERURL.PATH_IS_STUDENT_CEREMONY_APPLICABLE,
    		success: function(response, action) {
    			if (response.responseText == 'false') {
    				var rec = searchStore.findRecord('searchText',getMegaMenuTranslation('SP_GRADUATION_CEREMONY'));
    				if(rec){
    					searchStore.remove(rec);
    				}
	    			var btns = Ext.ComponentQuery.query('button'),
	    			textArray=Ext.Array.pluck(btns, 'text');
	    			btns[textArray.indexOf(getMegaMenuTranslation('SP_GRADUATION_CEREMONY'))].setVisible(false);
    			}
    		}
    	});
	   }catch(e){
		   console.log('error')
	   }
   },
   hideHostelApplicationSetupMenu:function(){
	   var me = this,
	   formVertical= me.getVerticalNavigationMenu(),
	   searchStore = formVertical.down('#searchComboBox').getStore();
	   var rec = searchStore.findRecord('searchText',getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'));
	   if (typeof searchStore.lastExecutionTime === 'undefined') {
	        searchStore.lastExecutionTime = 0;
	    }

	    var currentTime = new Date().getTime();

	    // Prevent function execution if called within the last 5+ seconds
	    if (currentTime - searchStore.lastExecutionTime < 5000) {
	        console.log('Function call skipped to prevent duplicate execution');
	        return false;
	    }

	    // Update last execution time
	    searchStore.lastExecutionTime = currentTime;
	   if(rec){
	   try{
	   Ext.Ajax.request({
    		type : 'rest',
    		async: false,
    		method : 'GET',
    		url : SERVERURL.HOSTEL_OPT_IN_DROP_DOWN,
    		success: function(response, action) {
    			var data =Ext.decode(response.responseText);
    			if (data && data[0].value != 'No') {
    				if(rec){
    					searchStore.remove(rec);
    				}
	    			var btns = Ext.ComponentQuery.query('button'),
	    			textArray=Ext.Array.pluck(btns, 'text');
	    			btns[textArray.indexOf(getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP'))].setVisible(false);
    		}
    		}
    	});
		   }catch(e){
			   console.log('error')
		   }
   }
   },
   hideUtilityControlPanelmenu: function(searchStore){
	   var me = this,
	   formVertical= me.getVerticalNavigationMenu(),
	   searchStore = formVertical.down('#searchComboBox').getStore();
	   var currentLoggedInUser = this.getController('Academia.controller.base.BaseController').getCurrentlyLoggedInUser().id;
	   var rec = searchStore.findRecord('searchText',getMegaMenuTranslation('CONTROL_PANEL'));
		if(rec){
			searchStore.remove(rec);
		}
		var btns = Ext.ComponentQuery.query('button'),
		textArray=Ext.Array.pluck(btns, 'text');
		
		var controlUtilityProfileIndex = textArray.indexOf(getMegaMenuTranslation('CONTROL_PANEL'));
        if(controlUtilityProfileIndex !== -1 && currentLoggedInUser != 1){
            btns[controlUtilityProfileIndex].setVisible(false);
        }
   },
	   hideStudentProfileMenu:  function(searchStore){
	       var me = this,
	       formVertical= me.getVerticalNavigationMenu(),
	       searchStore = formVertical.down('#searchComboBox').getStore();
	       var currentLoggedInUser = this.getController('Academia.controller.base.BaseController').getCurrentlyLoggedInUser().id;
	       var rec = searchStore.findRecord('searchText',getMegaMenuTranslation('STD_STUDENTS_STUDENT_PROFILE'));
	        if(rec){
	            searchStore.remove(rec);
	        }
	        var btns = Ext.ComponentQuery.query('button'),
	        textArray=Ext.Array.pluck(btns, 'text');
	        var studentProfileIndex = textArray.indexOf(getMegaMenuTranslation('STD_STUDENTS_STUDENT_PROFILE'));
	        if(studentProfileIndex !== -1 && currentLoggedInUser != 1){
	            btns[studentProfileIndex].setVisible(false);
	        }
	   },
	   hideUserProfileMenu:  function(searchStore){
	       var me = this,
	       formVertical= me.getVerticalNavigationMenu(),
	       searchStore = formVertical.down('#searchComboBox').getStore();
	       var currentLoggedInUser = this.getController('Academia.controller.base.BaseController').getCurrentlyLoggedInUser().id;
	       var rec = searchStore.findRecord('searchText',getMegaMenuTranslation('USER_PROFILE'));
	        if(rec){
	            searchStore.remove(rec);
	        }
	        var btns = Ext.ComponentQuery.query('button'),
	        textArray=Ext.Array.pluck(btns, 'text');
	        var userProfileIndex = textArray.indexOf(getMegaMenuTranslation('USER_PROFILE'));

	        if (userProfileIndex !== -1 && currentLoggedInUser != 1) {
	            btns[userProfileIndex].setVisible(false);
	        }
	        /*if(currentLoggedInUser!=1){
	            btns[textArray.indexOf(getMegaMenuTranslation('USER_PROFILE'))].setVisible(false);
	        }*/
	   },
});
