/**
 * @author trupti.paoneker
 * 
 * This controller is used for Deficit Credit Master related Actions.   
 */
Ext.define('Academia.controller.othermasters.deficitmaster.DeficitCreditMasterController', {
    extend: 'Academia.controller.base.BaseController',

    models: ['othermasters.deficitmaster.DeficitCreditMasterModel'],
    stores: ['othermasters.deficitmaster.DeficitCreditMasterStore', 'course.CourseComboStore', 'gradeMaster.GradeTypeNameValueStore'],

    views: ['othermasters.deficitmaster.DeficitCreditMaster', 'othermasters.deficitmaster.DeficitCreditMasterGrid', 'othermasters.deficitmaster.DeficitCreditMasterFormWindow'],

    alias: "widget.deficitCrediMastercontroller",

    refs: [{
        ref: 'deficitMasterGrid',
        selector: 'deficitmastergrid'
    }, {
        ref: 'deficitCreditMasterFormWindow',
        selector: 'deficitmasterformwindow'
    }, {
        ref: 'deficitMasterForm',
        selector: 'deficitmasterformwindow form[itemId=deficitMasterForm]'
    }],
    config: {
        DEFICIT_CREDIT_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DEFICIT_CREDIT_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'deficitmastergrid': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },
            'deficitmastergrid[itemId=deficitMasterGrid]': {
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getDEFICIT_CREDIT_MASTER_PERMISSIONS());
                }
            },
            'deficitmastergrid button[itemId=btnAdd]': {
                click: this.addDeficitMaster
            },
            'deficitmastergrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editDeficitMaster, this, [false])
            },
            'deficitmastergrid button[itemId=btnView]': {
                click: Ext.bind(this.editDeficitMaster, this, [true])
            },
            'deficitmastergrid button[itemId=btnDelete]': {
                click: this.deleteDeficitMaster
            },
            'deficitmasterformwindow button[itemId=btnSaveDeficitMasterForm]': {
                click: this.saveDeficitMasterForm
            },
            'deficitmasterformwindow button[itemId=btnCancelDeficitMasterForm]': {
                click: this.cancelDeficitMasterForm
            },
            'deficitmasterformwindow combo[itemId=courseCombo]': {
                render: this.loadCourseComboStore
            },
            'deficitmasterformwindow combo[itemId=gradesGroup]': {
                select: function(obj, record) {
                    var gradeTypeVal = record[0].get("value");
                    var evalGrade = this.getDeficitMasterForm().down('#evalGrade');
                    var store = evalGrade.getStore();

                    store.getProxy().extraParams = {
                        gradeType: gradeTypeVal,
                        isRelativeGrade:false
                    };
                    store.load();
                }
            }
        });
    },


    loadCourseComboStore: function(cmb) {

        var store = cmb.getStore();
        store.on('beforeload', function() {
            var academyLocationId = this.getCurrentAcademyLocation();
            store.getProxy().extraParams = {
                academyLocationId: academyLocationId
            };
        }, this);
    },

    /** This function is used for to show Deficit Master Details Dialog box after clicking on Add button*/

    addDeficitMaster: function() {
        var deficitCreditMasterFormWindow = Ext.widget('deficitmasterformwindow');
        deficitCreditMasterFormWindow.show();
    },


    /** This function is used for to show Deficit Master Details Dialog box with values of selected record after clicking on edit button*/

    editDeficitMaster: function(isView) {
        var me = this;
        var grid = me.getDeficitMasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.showDeficitMasterForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var deficitMasterForm = me.getDeficitMasterForm();
                var rec = new Academia.model.othermasters.deficitmaster.DeficitCreditMasterModel(records[0].data);
                deficitMasterForm.loadRecord(rec);
                grid.getStore().reload();
                if (isView) {
                    var deficitCreditMasterFormWindow = me.getDeficitCreditMasterFormWindow();
                    deficitCreditMasterFormWindow.down('#btnSaveDeficitMasterForm').setVisible(false);
                    toggleReadOnlyFormItems(deficitMasterForm.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /** This function is used for to save Deficit Master Details after clicking on save button*/

    saveDeficitMasterForm: function() {
        var this$ = this;
        var deficitCreditMasterFormWindow = this$.getDeficitCreditMasterFormWindow();


        var refDeficitCreditForm = this$.getDeficitMasterForm();
        var formData = refDeficitCreditForm.getValues();

        var grid = this$.getDeficitMasterGrid();
        var submitUrl, isUpdate = false;

        var deficitmaster = refDeficitCreditForm.down('#deficitMaster_hidden_field');
        if (deficitmaster.getSubmitValue() == null || deficitmaster.getSubmitValue() == "" || deficitmaster.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.DEFICIT_MASTER_CREATE, //URL-rest/deficitCredit/create
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.DEFICIT_MASTER_UPDATE, //URL-rest/deficitCredit/update
            isUpdate = true;
        }

        var jsonFormatFormData = Ext.encode(formData);

        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
                deficitCreditMasterFormWindow.close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();

                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('UPDATE_DEFICIT_MASTER_MSG'), getCommonTranslation('UPDATE_DEFICIT_MASTER_MSG'));
                } else {
                    showSuccessMessage(getCommonTranslation('ADD_DEFICIT_MASTER_MSG'), getCommonTranslation('ADD_DEFICIT_MASTER_MSG'));
                }
            }

        });
    },


    /** This function is used for to close deficit master Details Dialog box after clicking on cancel button   */

    cancelDeficitMasterForm: function() {
        this.getDeficitCreditMasterFormWindow().close();
    },

    showDeficitMasterForm: function() {
        var deficitmasterformwindow = this.getDeficitCreditMasterFormWindow();
        if (!deficitmasterformwindow) {
            deficitmasterformwindow = Ext.widget('deficitmasterformwindow');
        }
        deficitmasterformwindow.show();
    },
    deleteDeficitMaster: function() {
        var grid = this.getDeficitMasterGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
            Ext.MessageBox.show({
                title: getCommonTranslation('DELETE_DEFICIT_CREDIT'),
                msg: getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                buttons: Ext.MessageBox.OKCANCEL,
                icon: Ext.MessageBox.QUESTION,
                fn: function(btn, text) {
                    if (btn == 'ok') {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                method: 'DELETE',
                                url: SERVERURL.DEFICIT_MASTER_DELETE + '?id=' + id,
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grdStore.reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_DEFICIT_CREDIT_MSG'));
                                },
                                failure: function(form, action) {
                                    showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    }

});
