/**
 * @author Akshay Sharma
 * 
 * This controller is used for School Type Master related Actions.
 */
Ext.define('Academia.controller.othermasters.programgroupmaster.ProgramGroupMasterController', {
	extend : 'Academia.controller.base.BaseController',
	models: ['Academia.model.othermasters.programGroupMaster.ProgramGroupMasterAddressModel'],
	stores : [ 'program.ProgramGroupStore','common.AcademyLocationByName',
	           'othermasters.programGroupMaster.ProgramGroupMasterStore','organization.AddressTypeStore', 'common.CountryStore',
	           'organization.CityStore', 'organization.CountryRegionStore',
	           'organization.CountryRegionStore1', 'organization.CityByCountryRegion',
	           'common.ActiveUserStore'],
	views : ['othermasters.programGroupMaster.ProgramGroupMasterGrid','othermasters.programGroupMaster.ProgramGroupMasterStructure',
	          'othermasters.programGroupMaster.ProgramGroupMasterFilter','othermasters.programGroupMaster.ProgramGroupMasterFormWindow',
	          'personinfo.common.personalinfo.PhotoUploadForm','setup.templatemapping.PreviewTemplate','othermasters.programGroupMaster.PreviewProgramGroupLogo',
	          'othermasters.programGroupMaster.ProgramGroupAddressForm', 'organization.addresses.AddressFormWindow','common.AddressFieldsForm'],
	config : {
              	 PROGRAM_GROUP_MASTER_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ACADEMY_TYPE_MASTER_PRIVILEGES')
             },
	alias : "widget.programgroupmastercontroller",
	refs : [{
		ref : 'programgroupmastergrid',
		selector : 'programgroupmastergrid'
	},
	{
		ref : 'programgroupmasterstructure',
		selector : 'programgroupmasterstructure'
	},
	{
		ref : 'programgroupmasterfilter',
		selector : 'programgroupmasterfilter'
	},{
		ref : 'programgroupmasterformwindow',
		selector : 'programgroupmasterformwindow'
	},{
		ref : 'programGroupMasterForm',
		selector : 'programgroupmasterformwindow form[itemId=programGroupMasterForm]'

	}, {
		ref: 'previewprogramgrouplogo',
		selector: 'previewprogramgrouplogo'
	},{
		ref: 'contentpanel',
		selector: 'contentpanel'
	},{
		ref: 'programgroupaddressform',
		selector: 'programgroupaddressform'
	},{
		ref: 'addressFormWindow',
		selector: 'addressFormWindow[itemId=programgroupmasteraddressformwindow]'
	}, {
		ref: 'addressfieldsform',
		selector: 'addressFormWindow form[itemId=addressfieldsform]'
	}],
	init : function(application) {
		this.control({
			'programgroupmastergrid button[itemId=btnAdd]' : {
				click : this.addProgramGroupDetails
			},
			'programgroupmastergrid button[itemId=btnEdit]' : {
				click : Ext.bind(this.editProgramGroupDetails,
						this, [ false ])
			},
			'programgroupmastergrid button[itemId=btnDelete]' : {
				click : this.deleteProgramGRoupDetails
			},
			'programgroupmastergrid button[itemId=btnView]' : {
				click : Ext.bind(this.editProgramGroupDetails,
						this, [ true ])
			},
			'programgroupmasterformwindow button[itemId=btnSaveProgramGroupMasterForm]' : {
				click : this.saveProgramGroupDetails
			},
			'programgroupmasterformwindow button[itemId=btnCancelProgramGroupMasterForm]' : {
				click : this.cancelProgramGroupDetails
			},
			'programgroupmasterfilter button[itemId=programGroupMasterSearchBtn]' : {
				click : this.searchProgramGroupDetails
			},
			'programgroupmasterfilter button[itemId=programGroupMasterResetBtn]' : {
				click : function() {
					this.getProgramgroupmasterfilter().getForm().reset();
					var grid = this.getProgramgroupmastergrid();
					this.resetPageSetting(grid.getStore());
				}
			},
			'programgroupmasterformwindow photouploadform[itemId=programGrouplogoUploadField] filefield[itemId=photoFileImage]': {
				change:function(photoFileImage, value, eOpts){
					value = value.replace('C:\\fakepath\\', '');
					var newValue = value.replace(/ +/g, " ").split(' ').join('_');
					photoFileImage.setRawValue(newValue);
					
					var window = this.getProgramgroupmasterformwindow();
    				var programGroupImage = window.down('#programGroupImage');

    				var file = photoFileImage.fileInputEl.dom.files[0];
    				var reader = new FileReader();
    				reader.addEventListener('load', function(evt) {
    					programGroupImage.setSrc(evt.target.result);
    					programGroupImage.setVisible(true);
    				});
    				reader.readAsDataURL(file);
				}
			},
			'programgroupmastergrid button[itemId=addProgramGroupAddressItemId]': {
				click: function(button) {
					var grid = this.getProgramgroupmastergrid();
					if (grid.getSelectionModel().getCount() > 0 && button.itemId === "addProgramGroupAddressItemId") {
						this.openProgramGroupAddressFormTab(grid.getSelectionModel().getSelection()[0]);
					} else {
						showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			"programgroupaddressform button[itemId=modifyAddressPGAF1]": {
				click: function() {
					var customAddressDisplayField1 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF1');
					this.onModifyClick(customAddressDisplayField1, 10);
				}
			},
			"programgroupaddressform button[itemId=modifyAddressPGAF2]": {
				click: function() {
					var customAddressDisplayField2 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF2');
					this.onModifyClick(customAddressDisplayField2, 11);
				}
			},
			"programgroupaddressform button[itemId=modifyAddressPGAF3]": {
				click: function() {
					var customAddressDisplayField3 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF3');
					this.onModifyClick(customAddressDisplayField3, 12);
				}
			},
			"programgroupaddressform button[itemId=modifyAddressPGAF4]": {
				click: function() {
					var customAddressDisplayField4 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF4');
					this.onModifyClick(customAddressDisplayField4, 13);
				}
			},
			"addressFormWindow[itemId=programgroupmasteraddressformwindow] button[itemId=saveButtonId]": {
				click: this.saveProgramGroupAddress
			},
			'programgroupaddressform': {
				render: function() {
					this.getProgramGroupAddress();
				}
			},
			"programgroupaddressform button[itemId=printAddressPGAF1]": {
				click: function() {
					var addressDisplayField = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF1');
					this.onPrintClick(addressDisplayField);
				}
			},
			"programgroupaddressform button[itemId=printAddressPGAF2]": {
				click: function() {
					var addressDisplayField = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF2');
					this.onPrintClick(addressDisplayField);
				}
			},
			"programgroupaddressform button[itemId=printAddressPGAF3]": {
				click: function() {
					var addressDisplayField = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF3');
					this.onPrintClick(addressDisplayField);
				}
			},
			"programgroupaddressform button[itemId=printAddressPGAF4]": {
				click: function() {
					var addressDisplayField = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF4');
					this.onPrintClick(addressDisplayField);
				}
			},
			"programgroupaddressform button[itemId=printallAddressPGAF]": {
				click: function() {
					var addressDisplayField1 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF1');
					var addressDisplayField2 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF2');
					var addressDisplayField3 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF3');
					var addressDisplayField4 = this.getProgramgroupaddressform().down('displayfield#customAddressDisplayFieldPGAF4');

					var allAddressDisplayField = Ext.create('Academia.view.organization.addresses.CustomAddressDisplayField');
					var str = addressDisplayField1.value;
					str += " \n <hr/>";
					str += addressDisplayField2.value;
					str += " \n <hr/>";
					str += addressDisplayField3.value;
					str += " \n <hr/>";
					str += addressDisplayField4.value;

					allAddressDisplayField.setValue(str);
					this.onPrintClick(allAddressDisplayField);
				}
			},
			'programgroupmastergrid':{
           	 render: function(grid) {
                    this.doAccessControlValidation(grid, this.getPROGRAM_GROUP_MASTER_PERMISSIONS());
                    this.disableAddressBtnActionPivileges(grid, this.getPROGRAM_GROUP_MASTER_PERMISSIONS());
                },
             cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if (e.target.tagName == 'A') {
						this.viewLogoImage(columnName, record);
					}
				}
           },
           "programgroupmasterformwindow customcombobox[itemId=academyLocationId]": {
        	    select: function(obj, rec) {
        	        var window = this.getProgramgroupmasterformwindow();
        	        var principalId = window.down('#principalItemId');
        	        var store = principalId.getStore();
        	        var academyLocationId = window.down('#academyLocationId').getValue();
        	        store.getProxy().extraParams = {
        	            academyLocationIds: academyLocationId
        	        };
        	        store.load();
        	        principalId.setDisabled(false);
        	    }
        	}
		});
	},
	/** 
	 * This function is used for to Open School Type Detail Window
	 * 
	 */
	addProgramGroupDetails : function() {
		var formWindow = this.getProgramgroupmasterformwindow();
		if (!formWindow) {
			Ext.widget('programgroupmasterformwindow');
			formWindow = this.getProgramgroupmasterformwindow();
			formWindow.down('photouploadform').down('filefield').setFieldLabel('Upload Logo');
		}
		formWindow.show();
	},
	/** 
	 * This function is used for to Close School Type Detail Window
	 * 
	 */
	cancelProgramGroupDetails : function() {
		this.getProgramgroupmasterformwindow().close();
	},
	/** 
	 * This function is used for to Save or Update the School Type Details
	 * 
	 */
	saveProgramGroupDetails : function() {
		var this$ = this;
		var form = this$.getProgramGroupMasterForm();
		var formData = form.getValues();
		var submitUrl = "";
		var sucessMSG = '';
		if(!isNullOrEmpty(formData.id)){
			submitUrl = SERVERURL.PATH_UPDATE_PROGRAM_GROUP_DETAILS;
			sucessMSG = getProgramandcourseTranslation('PROGRAM_GROUP_UPDATED_SUCCESSFULLY');
		}else{
			submitUrl = SERVERURL.PATH_SAVE_PROGRAM_GROUP_DETAILS;
			sucessMSG = getProgramandcourseTranslation('PROGRAM_GROUP_CREATED_SUCCESSFULLY');
		}
		var createeditprogramgroupdetails = new Academia.model.othermasters.programGroupMaster.ProgramGroupMasterModel();
		if(!isNullOrEmpty(formData.id)){
			createeditprogramgroupdetails.set("id", formData.id);
		}else{
			delete createeditprogramgroupdetails.data.id;
		}
		createeditprogramgroupdetails.set("academyLocation",
				this.getIdValueJson(formData.academyLocation));
		createeditprogramgroupdetails.set("programGroup", this
				.getIdValueJson(formData.programGroup));

		if(!isNullOrEmpty(formData.emisNumber)){
			createeditprogramgroupdetails.set("eMISNumber", formData.emisNumber);
		}else{
			delete createeditprogramgroupdetails.data.eMISNumber;
		}
		if(!isNullOrEmpty(formData.eMISProvince)){
			createeditprogramgroupdetails.set("eMISProvince", this
					.getIdValueJson(formData.eMISProvince));
		}else{
			delete createeditprogramgroupdetails.data.eMISProvince;
		}
		if(!isNullOrEmpty(formData.boardingSchool)){
			createeditprogramgroupdetails.set("isBoardingSchool", formData.boardingSchool);
		}else{
			delete createeditprogramgroupdetails.data.isBoardingSchool;	
		}
		if (!isNullOrEmpty(formData.principalId)) {
			createeditprogramgroupdetails.set("principal", this.getIdValueJson(formData.principalId));
		} else {
			delete createeditprogramgroupdetails.data.principal;	
		}
		createeditprogramgroupdetails.set("schoolTypeCode", formData.schoolTypeCode);
		if(!isNullOrEmpty(form.down('#programGrouplogoUploadField').down('filefield#photoFileImage').getValue())){

			var programGroupfileUploadPath = form.down('#programGrouplogoUploadField').down('filefield#photoFileImage').getValue();
			if(!isNullOrEmpty(programGroupfileUploadPath)){
				var uplaodUrl = SERVERURL.PATH_UPLOAD_PROGRAM_GROUP_DETAILS_LOGO;
				var extension = programGroupfileUploadPath.substring(programGroupfileUploadPath.lastIndexOf('.') + 1).toLowerCase();
				if (extension == "gif" || extension == "png" || extension == "bmp"
					|| extension == "jpeg" || extension == "jpg") {
					form.getForm().submit({
						method : 'POST',
						url : uplaodUrl,
						success : function(formSub, action){
							var photoUrl=action.result.path;
							var version=action.result.version;
							form.config.photoUrl = photoUrl;
							createeditprogramgroupdetails.set("logoPath", action.result.path);
							var fData = Ext
							.encode(createeditprogramgroupdetails.data);
							Ext.getBody().mask(
									getCommonTranslation('SUBMITTING_FORM'),
							'x-mask-loading');
							Ext.Ajax
							.request({
								type : 'rest',
								url : submitUrl,
								jsonData : fData,
								method : 'POST',
								success : function(f, action) {
									Ext.getBody().unmask();
									if(f.responseText == '0'){
										showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
									} else if (f.responseText == '-1') {
										showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),getProgramandcourseTranslation('SCHOOL_TYPE_CODE_NOT_UNIQUE'));
									}else{
										showSuccessMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),sucessMSG);
										this$.getProgramgroupmasterformwindow().close();
										this$.getProgramgroupmastergrid().getStore().reload();
									}
								}
							});
						}
					});
				}else{
					form.down('#programGrouplogoUploadField').down('filefield#photoFileImage').reset();
					showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
				}
			}
		}else{
			if(!isNullOrEmpty(formData.version)){
				createeditprogramgroupdetails.set("logoPath", formData.version);
			}else{
				delete createeditprogramgroupdetails.data.logoPath;	
			}
			if(!isNullOrEmpty(form.config.photoUrl)){
				createeditprogramgroupdetails.set("logoPath", form.config.photoUrl);
			}
			var fData = Ext
			.encode(createeditprogramgroupdetails.data);
			Ext.getBody().mask(
					getCommonTranslation('SUBMITTING_FORM'),
					'x-mask-loading');
			Ext.Ajax
			.request({
				type : 'rest',
				url : submitUrl,
				jsonData : fData,
				method : 'POST',
				success : function(f, action) {
					Ext.getBody().unmask();
					if(f.responseText == '0'){
						showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),getCommonTranslation('RECORD_IS_ALREADY_EXIST'));
					} else if (f.responseText == '-1') {
						showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),getProgramandcourseTranslation('SCHOOL_TYPE_CODE_NOT_UNIQUE'));
					}else{
						showSuccessMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),sucessMSG);
						this$.getProgramgroupmasterformwindow().close();
						this$.resetPageSetting(this$.getProgramgroupmastergrid().getStore());
						this$.getProgramgroupmastergrid().getStore().reload();
					}
				}
			});
		}
	},
	/** 
	 * This function is used to get Id/value object
	 * 
	 */
	getIdValueJson: function(id, value,code) {
		if (id) return {
			id: id,
			value: value,
			code: code
		};
	},
	/** 
	 * This function is used to search records according filter data
	 * 
	 */
	searchProgramGroupDetails : function() {
		var filter =  this.getProgramgroupmasterfilter();
		var academyLocationId = filter.down('#academyLocationId').getValue();
		var programGroupId = filter.down('#Program_Group').getValue();

		var grid = this.getProgramgroupmastergrid();
		this.resetPageSetting(grid.getStore());
		var gridStore = grid.getStore();

		gridStore.getProxy().extraParams = {
			academyLocationId : academyLocationId,
			programGroupId : programGroupId
		};
		gridStore.load();
	},
	/** 
	 * This function is used to view the uploaded image of school type
	 * 
	 */
	viewLogoImage : function(columnName, record) {
		var $this = this;
		var formWindow = $this.getPreviewprogramgrouplogo();
		if (!formWindow) {
			Ext.widget('previewprogramgrouplogo');
			formWindow = $this.getPreviewprogramgrouplogo();
		}
		formWindow.show();
		var downloadUrl = SERVERURL.PATH_DOWNLOAD_PROGRAM_GROUP_DETAILS_LOGO;
		var previewForm = $this.getPreviewprogramgrouplogo();
		Ext.Ajax.request({
			type: 'rest',
			binary: true,
			url: downloadUrl,
			params: {
				programGroupDetailId: record.data.id
			},
			method: 'GET',
			success : function(response){
				if(response.responseBytes.length>0){
					var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
					if(!isNullOrEmpty(blob) && blob != undefined){
						var url = window.URL.createObjectURL(blob);
						var a=previewForm.down("#program_group_image");
						a.getEl().dom.src=url;
					}
				}
			}
		}); 
	},
	/** 
	 * This function is used for to open School Type Master Details Dialog box with values of selected record after clicking on edit button
	 * 
	 */
	editProgramGroupDetails: function(isView) {
		var me = this;
		var grid = me.getProgramgroupmastergrid();
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			me.addProgramGroupDetails();
			if (records != "" && records != null && records != undefined) {
				var form = me.getProgramGroupMasterForm();
				var rec = new Academia.model.othermasters.programGroupMaster.ProgramGroupMasterModel(
						records[0].data);
				form.getForm().findField('id').setValue(rec.data.id);
				form.getForm().findField('version').setValue(rec.data.logoPath);
				form.down('#academyLocationId').getStore().load({
					callback: function(records, operation, success) {
						if (success) {
							form.down('#academyLocationId').setValue(rec.data.academyLocation.id);
						}
					}
				});
				form.down('#Program_Group').getStore().load({
					callback: function(records, operation, success) {
						if (success) {
							form.down('#Program_Group').setValue(rec.data.programGroup.id);
						}

					}
				});
				form.down('#eMISProvince').getStore().load({
					callback: function(records, operation, success) {
						if (success) {
							if(!isNullOrEmpty(rec.data.eMISProvince) && !isNullOrEmpty(rec.data.eMISProvince.id)){
								form.down('#eMISProvince').setValue(rec.data.eMISProvince.id);
							}
						}
					}
				});
				form.down('#emisNumber').setValue(rec.data.eMISNumber);
				form.down('#schoolTypeCodeItemId').setValue(rec.data.schoolTypeCode);
				form.down('#boardingSchool').setValue(rec.data.isBoardingSchool);
				var principalItemId = form.down('#principalItemId');
				var principalStore = principalItemId.getStore();
				principalStore.getProxy().extraParams = {
				    academyLocationIds: rec.data.academyLocation.id
				};
				principalStore.load({
				    callback: function(records, operation, success) {
				        if (success) {
				        	if(!isNullOrEmpty(rec.data.principal)){
				        		principalItemId.setValue(rec.data.principal.id);
				        	}
				        }
				    }
				});
				grid.getStore().reload();
				grid.getSelectionModel().deselectAll(true);
				if(!isNullOrEmpty(rec.data.logoPath)){
					Ext.Ajax.request({
						type: 'rest',
						binary: true,
						url: SERVERURL.PATH_DOWNLOAD_PROGRAM_GROUP_DETAILS_LOGO,
						method: 'GET',
						params: {
							programGroupDetailId: rec.data.id
						},
						success: function(response, action) {
							var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
							if(!isNullOrEmpty(blob) && blob != undefined){
								var url = window.URL.createObjectURL(blob);
								var a=form.down("#programGroupImage");
								a.getEl().dom.src=url;
							}
						}
					});
				}else{
					form.down("#programGroupImage").setVisible(false);
				}
				if (isView) {
					var masterformwindow = me.getProgramgroupmasterformwindow();
					masterformwindow.down('#btnSaveProgramGroupMasterForm').setVisible(false);
					var photouploadform = masterformwindow.down('photouploadform');
					if(photouploadform) {
						photouploadform.down("#photoFileImage").setDisabled(true);
					}
					this.toggleReadOnlyFormItems(masterformwindow.down('form').getForm(), true);
				} else {
	        		   principalItemId.setDisabled(false);
				}
			}
		} else {
			showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	/** 
	 * This function is used for to delete School Type Master Detail
	 * 
	 */
	deleteProgramGRoupDetails : function(){
		var me = this;
		var grid = me.getProgramgroupmastergrid();
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			showConfirmMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
					function(btn, text) {
				if (btn == 'yes'){
					var submitUrl = SERVERURL.PATH_DELETE_PROGRAM_GROUP_DETAILS_LOGO
					Ext.getBody().mask(
							getCommonTranslation('SUBMITTING_FORM'),
					'x-mask-loading');
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: submitUrl+'?id='+records[0].data.id,
						headers: {
							'Content-Type': 'application/json'
						},
						success : function(f, action) {
							Ext.getBody().unmask();
							if (f.responseText == 0) {
								showWarningMessage(getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'), getCommonTranslation('DEPENDENCY_EXISTS'));
							}
							else{
								showSuccessMessage(
										getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),
										getProgramandcourseTranslation('PROGRAM_GROUP_DELETED_SUCCESSFULLY'));
								me.getProgramgroupmastergrid().getStore().reload();
							}
						}
					});
				}
			});
		} else {
			showWarningMessage(
					getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'),
					getCommonTranslation('PLEASE_SELECT_RECORD')); 
		}
	},
	/** 
	 * This function is used to add School Type Address
	 * 
	 */
	openProgramGroupAddressFormTab: function(record) {
		var $this = this;
		var contentpanel = this.getContentpanel();
		var addressTab  = Ext.widget('programgroupaddressform');
		var tabName = getCommonTranslation('ADDRESS');

		/** This is to remove tab from content panel and open same tab again */
		var getcontroller = this.getController('menu.CoreERPNavigationController');
		var getTab = getcontroller.getTab(tabName);
		if (getTab != null) {
			contentPanel.remove(getTab, true);
		}

		openTab(contentpanel, tabName, addressTab, CONSTANTS.MENU_COLOR_THREE);
	},
	onModifyClick: function(customAddressDisplayField, addressTypeALId) {
		var $this = this;
		/** Enable Form. */
		var academyTypeaddressFormWindow = Ext.widget('addressFormWindow', {
			itemId: 'programgroupmasteraddressformwindow'
		});
		academyTypeaddressFormWindow.show();

		var websiteURLItemId = academyTypeaddressFormWindow.down('#websiteURLItemId');
		websiteURLItemId.setVisible(true);

		var grid = $this.getProgramgroupmastergrid();
		Ext.apply(grid, {
			addressTypeALId: null,
			setAddressTypeALId: function(code) {
				grid.addressTypeALId = addressTypeALId;
			},
			getAddressTypeALId: function() {
				return grid.addressTypeALId;
			}
		});
		grid.setAddressTypeALId(addressTypeALId);

		var data = customAddressDisplayField.getModel();
		var addressfieldsform = $this.getAddressfieldsform();
		$this.setAddressFormData(data, addressfieldsform);
	},
	setIdFromNestedObject: function(object, field) {
		if (object && object[field] && object[field].hasOwnProperty('id')) {
			object[field] = object[field]["id"];
		}
	},
	setAddressFormData: function(data, addressfieldsform) {
		var form = addressfieldsform.getForm();
		form.reset();
		if (data) {
			this.setIdFromNestedObject(data, "addressType");
			this.setIdFromNestedObject(data, "country");
			this.setIdFromNestedObject(data, "parentCountryRegion");
			this.setIdFromNestedObject(data, "countryRegion");
			this.setIdFromNestedObject(data, "city");

			var countryId = data["country"];
			var countryRegionId = data["parentCountryRegion"];
			if (countryId) {
				this.setCountryDropDown(countryId, addressfieldsform);
				this.setCityropDown(countryRegionId, data["city"], addressfieldsform);
				this.setRegion1DropDown(countryId, data["parentCountryRegion"], addressfieldsform);
				//this.setRegion2DropDown(data["parentCountryRegion"], data["countryRegion"], addressfieldsform);
			}
			form.setValues(data);
		}
	},
	setCountryDropDown: function(countryId, addressfieldsform) {
		var countryComboBox = addressfieldsform.down('#countryId');
		if (!countryComboBox.store.items) {
			countryComboBox.store.load({
				callback: function(records, operation, success) {
					if (success) {
						if (countryComboBox && countryId)
							countryComboBox.setValue(countryId);
					}
				}
			});
		}
	},
	setCityropDown: function(countryId, cityId, addressfieldsform) {
		var store = this.getStore('organization.CityByCountryRegion');
		store.getProxy().extraParams = {
			id: countryId
		};
		store.load({
			callback: function(records, operation, success) {
				if (success) {
					var cityComboBox = addressfieldsform.down('#cityId');
					if (cityComboBox && cityId)
						cityComboBox.setValue(cityId);
				}
			}
		});
	},
	setRegion1DropDown: function(countryId, regionId, addressfieldsform) {
		var countryRegionStore = this.getStore('organization.CountryRegionStore');
		countryRegionStore.getProxy().extraParams = {
			cid: countryId
		};
		countryRegionStore.load({
			callback: function(records, operation, success) {
				if (success) {
					var genericField1ComboBox = addressfieldsform.down('#genericFieldId1');
					if (genericField1ComboBox && regionId)
						genericField1ComboBox.setValue(regionId);
				}
			}
		});
	},
	/*setRegion2DropDown: function(countryRegion1, regionId, addressfieldsform) {
		var countryRegionStore = this.getStore('organization.CountryRegionStore1');
		countryRegionStore.getProxy().extraParams = {
			pid: countryRegion1
		};
		countryRegionStore.load({
			callback: function(records, operation, success) {
				if (success) {
					var genericField1ComboBox = academylocationaddressform.down('#genericFieldId2');
			                                           if(genericField1ComboBox && regionId)
			                                           	genericField1ComboBox.setValue(regionId);
				}
			}
		});
	},*/
	validatePhone: function(data) {
		var isValid;
		if (!data.phoneNo && !data.cellNo) {
			showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), getCommonTranslation('ADD_PHONE_NO'));
			isValid = false;
		} else {
			isValid = true;
		}
		return isValid;
	},
	setIdFromNestedObject: function(object, field) {
		if (object && object[field] && object[field].hasOwnProperty('id')) {
			object[field] = object[field]["id"];
		}
	},
	saveProgramGroupAddress: function(model) {
		var $this = this;
		var form = this.getAddressfieldsform().getForm();
		if (form.isValid()) {
			var values = form.getValues();
//			if ($this.validatePhone(values)) {
				var address = new Academia.model.organization.Address();
				var submitUrl;
				var successMessage;
				var id = form.findField('id').getSubmitValue();
				form.updateRecord(address);
				address.set('country', this.getIdValueJson(values.country));
				address.set('parentCountryRegion', $this.getIdValueJson(values.parentCountryRegion));
				address.set('city', $this.getIdValueJson(values.city));
				address.set('pincode', values.pincode);
				delete address.data.countryRegion;          /*delete country region field*/
				var grid = $this.getProgramgroupmastergrid();
				var programGroupDetailId = grid.getProgramGroupDetailId();
				var addressTypeALId = grid.getAddressTypeALId();
				address.set('addressType', $this.getIdValueJson(addressTypeALId));
				if (id == null || id == "") {
					delete address.data.id;
					submitUrl = SERVERURL.PATH_SAVE_PROGRAM_GROUP_ADDRESS;
					successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
				} else {
					address.set("id", id);
					submitUrl = SERVERURL.PATH_UPDATE_PROGRAM_GROUP_ADDRESS;
					successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
				}
				var programGroupMasterAddressModel = new Academia.model.othermasters.programGroupMaster.ProgramGroupMasterAddressModel();
				programGroupMasterAddressModel.set("address", address.data);
				programGroupMasterAddressModel.set("programGroupDetail", $this.getIdValueJson(programGroupDetailId));

				var formData = Ext.encode(programGroupMasterAddressModel.data);
				Ext.Ajax.request({
					type: 'rest',
					url: submitUrl,
					jsonData: formData,
					method: 'POST',
					success: function(form, action) {
						showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
						$this.getProgramGroupAddress();
						$this.resetForm(model);
					}
				});
//			}
		}
	},
	getProgramGroupAddress: function() {
		var $this = this;
		var currentAddress = false,
		correspondanceAddress = false,
		permanentAddress = false,
		officeAddress = false;
		var programgroupaddressform = $this.getProgramgroupaddressform();
		var grid = $this.getProgramgroupmastergrid();
		var record = grid.getSelectionModel().getSelection()[0];
		var programGroupDetailId = record.data.id;
		Ext.apply(grid, {
			programGroupDetailId: null,
			setProgramGroupDetailId: function(code) {
				grid.programGroupDetailId = programGroupDetailId;
			},
			getProgramGroupDetailId : function() {
				return grid.programGroupDetailId;
			}
		});
		grid.setProgramGroupDetailId(programGroupDetailId);

		if (!isNullOrEmpty(programGroupDetailId)) {
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_FIND_ALL_PROGRAM_GROUP_ADDRESS,
				params: {
					programGroupDetailId: programGroupDetailId
				},
				method: 'GET',
				success: function(responser, action) {
					var data = Ext.decode(responser.responseText);
					var addressDisplayField1 = programgroupaddressform.down('displayfield#customAddressDisplayFieldPGAF1');
					var addressDisplayField2 = programgroupaddressform.down('displayfield#customAddressDisplayFieldPGAF2');
					var addressDisplayField3 = programgroupaddressform.down('displayfield#customAddressDisplayFieldPGAF3');
					var addressDisplayField4 = programgroupaddressform.down('displayfield#customAddressDisplayFieldPGAF4');

					var AddressTpl = Ext.create('Ext.XTemplate',
							'<p><B>{addressText}</B></p>',
							'<tpl if=\'city != null\'>',
							'{city.value} , </tpl> {code}<br>',
							'<tpl if=\'countryRegion != null\'>',
							'{countryRegion.value}<br></tpl> ',
							'<tpl if=\'parentCountryRegion != null\'>',
							'{parentCountryRegion.value},</tpl> {country.value}<br>',
							'<tpl if=\'phoneNo != null\'>',
							getCommonTranslation('ADDRESS_PHONE_NUMBER') + ' ' + '{phoneCountryCode}-',
							'<tpl if=\'phoneAreaCode != null\'>',
							'{phoneAreaCode}-</tpl>',
							'{phoneNo}</tpl><br>',
							'<tpl if=\'cellNo != null\'>',
							getCommonTranslation('ADDRESS_MOBILE_NO') + ' ' + '{cellCountryCode}-{cellNo}</tpl><br>',
					'{primaryeEmailId}');

					Ext.each(data, function(obj) {
						if (obj['addressType']['id'] == 10) {
							currentAddress = true;
							addressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
							addressDisplayField1.setModel(obj);
						} else if (obj['addressType']['id'] == 11) {
							correspondanceAddress = true;
							addressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
							addressDisplayField2.setModel(obj);
						} else if (obj['addressType']['id'] == 12) {
							permanentAddress = true;
							addressDisplayField3.setValue(AddressTpl.applyTemplate(obj));
							addressDisplayField3.setModel(obj);
						} else if (obj['addressType']['id'] == 13) {
							officeAddress = true;
							addressDisplayField4.setValue(AddressTpl.applyTemplate(obj));
							addressDisplayField4.setModel(obj);
						}
					});
					var modifyAddress1 = programgroupaddressform.down('button#modifyAddressPGAF1');
					var printAddress1 = programgroupaddressform.down('button#printAddressPGAF1');
					var modifyAddress2 = programgroupaddressform.down('button#modifyAddressPGAF2');
					var printAddress2 = programgroupaddressform.down('button#printAddressPGAF2');
					var modifyAddress3 = programgroupaddressform.down('button#modifyAddressPGAF3');
					var printAddress3 = programgroupaddressform.down('button#printAddressPGAF3');
					var modifyAddress4 = programgroupaddressform.down('button#modifyAddressPGAF4');
					var printAddress4 = programgroupaddressform.down('button#printAddressPGAF4');

					var printallAddress = programgroupaddressform.down("#printallAddressPGAF");

					if (currentAddress) {
						modifyAddress1.setText(getCommonTranslation('MODIFY'));
						printAddress1.setVisible(true);
					} else {
						modifyAddress1.setText(getCommonTranslation('ADD_ADDRESS'));
						printAddress1.setVisible(false);
						var object = new Object();
						object.addressType = 10;
						addressDisplayField1.setModel(object);
					}
					if (correspondanceAddress) {
						modifyAddress2.setText(getCommonTranslation('MODIFY'));
						printAddress2.setVisible(true);
					} else {
						modifyAddress2.setText(getCommonTranslation('ADD_ADDRESS'));
						printAddress2.setVisible(false);
						var object = new Object();
						object.addressType = 11;
						addressDisplayField2.setModel(object);
					}

					if (permanentAddress) {
						modifyAddress3.setText(getCommonTranslation('MODIFY'));
						printAddress3.setVisible(true);
					} else {
						modifyAddress3.setText(getCommonTranslation('ADD_ADDRESS'));
						printAddress3.setVisible(false);
						var object = new Object();
						object.addressType = 12;
						addressDisplayField3.setModel(object);
					}

					if (officeAddress) {
						modifyAddress4.setText(getCommonTranslation('MODIFY'));
						printAddress4.setVisible(true);
					} else {
						modifyAddress4.setText(getCommonTranslation('ADD_ADDRESS'));
						printAddress4.setVisible(false);
						var object = new Object();
						object.addressType = 13;
						addressDisplayField4.setModel(object);
					}

					if (currentAddress && correspondanceAddress && permanentAddress && officeAddress) {
						printallAddress.setVisible(true);
					} else {
						printallAddress.setVisible(false);
					}
				}
			});
		}
	},
	resetForm: function(button) {
		button.up('window').close();
	},
	onPrintClick: function(addressDisplayField) {
		Ext.ux.Printer.print(addressDisplayField);
	},
	 //******************Disable Manage Address button**********************************
	disableAddressBtnActionPivileges: function(gridReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		buttonsToolBar = gridReference.query('toolbar')[0];
		var manageAddressButton = gridReference.down('#addProgramGroupAddressItemId');
		manageAddressButton.setVisible(false);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'MANAGE_ADDRESSES') {
				if(!isNullOrEmpty(manageAddressButton)){
					manageAddressButton.setVisible(true);
				}        	
			}
		});
	}
});
