/**
 * @author Sachin.Bangar This controller is used for the applicant, student and
 *         faculty past history functionality.
 */

Ext.define('Academia.controller.personinfo.common.PersonPastHistoryController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',
    mixins : {
		AddressController : 'Academia.controller.organization.AddressController',
		ApplicantPortalSetupController : 'Academia.controller.admission.applicantPortalSetup.ApplicantPortalSetupController'
	},

    models: ['personinfo.common.pasthistory.ResearchDetailsMdl','genericmodels.dropdowns.EnumCombo',
             'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentModel','personinfo.common.pasthistory.PostSchoolStudiesDataModel',
            'personinfo.common.pasthistory.EmployeeInsuranceHistoryModel','personinfo.student.PostDocInfoDocumentModel',
            'personinfo.common.pasthistory.StudentPostDocInfoModel','student.postgraduatemanagement.StudentJointDegreeModel',
            'student.postgraduatemanagement.StudentThesisTitleModel','student.postgraduatemanagement.StudentJointDegreeDocumentModel',
            'student.postgraduatemanagement.StudentOwnProgressReportModel','student.postgraduatemanagement.StudentOwnProgressReportDocumentModel',
            'personinfo.common.pasthistory.StudentMOUModel','student.postgraduatemanagement.StudentMOUDocumentModel',
            'student.postgraduatemanagement.FunctionaryProgressReportModel','student.postgraduatemanagement.FunctionaryProgressReportDocumentModel',
            'common.FPRDataModel','student.postgraduatemanagement.StudentEthicsClearanceLetterModel','student.postgraduatemanagement.StudentEthicsClearanceLetterDocumentModel',
            'student.postgraduatemanagement.StudentExaminersReportModel','student.postgraduatemanagement.StudentExaminersReportDocumentModel',
            'personinfo.common.pasthistory.FunctionaryDetailsModel','student.postgraduatemanagement.NominateExaminersModel','common.NominateExaminersDataModel',
            'student.postgraduatemanagement.IndependentNonExaminingChairPersonDocModel','student.postgraduatemanagement.IndependentNonExaminingChairpersonReportModel','Academia.model.student.postgraduatemanagement.ProofOfActivityModel', 
            'personinfo.common.pasthistory.EducationHistoryDetailModel','personinfo.common.pasthistory.StudentEducationHistoryDocumentModel','personinfo.common.pasthistory.StudentEducationHistoryUrlModel',
            'personinfo.common.pasthistory.ApplicantEducationHistoryDocumentModel','personinfo.common.pasthistory.ApplicantEducationHistoryUrlModel',
            'personinfo.common.pasthistory.StudentLanguageDocumentGridModel','personinfo.common.pasthistory.StudentLanguageDocumentModel','personinfo.common.pasthistory.StudentLanguageUrlModel',
            'personinfo.common.pasthistory.StudentHealthInformationUrlModel','personinfo.common.pasthistory.StudentHealthInformationDocumentModel','personinfo.common.pasthistory.HealthInformationDetailModel','personinfo.common.pasthistory.ApplicantHealthInformationDocumentModel','personinfo.common.pasthistory.ApplicantHealthInformationUrlModel'],
            
    stores: ['common.ExamPassedStore','common.ExamBoardStore',
             'personinfo.common.pasthistory.EducationHistoryStore', 'common.SubjectTypeStore', 'common.ExperienceTypeStore', 
             'common.WorkTypeStore', 'personinfo.common.pasthistory.WorkExperienceStore', 'common.MedicalConditionTypeStore', 
             'personinfo.common.pasthistory.MedicalHistoryStore', 'personinfo.common.pasthistory.VaccinationStore',
             'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentListStore',
             'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentStore',
             'personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentListStore',
             'personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentStore',
             'personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentListStore',
             'personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentStore',
             'personinfo.common.pasthistory.ExtraCurricularStore', 'personinfo.common.services.CommunityNameStore', 
             'personinfo.common.pasthistory.ActivityTypeStore', 'personinfo.common.pasthistory.TrainingStore',
             'personinfo.common.pasthistory.ResearchTypeStr','personinfo.common.pasthistory.PublicationIndexStr',
             'personinfo.common.pasthistory.PublicationYearStr','personinfo.common.pasthistory.ConferenceJournalTypeStr',
             'personinfo.common.pasthistory.ProjectTypeStr','personinfo.common.pasthistory.SeminarTypeStr','personinfo.common.pasthistory.ConferenceTypeStr',
             'personinfo.common.pasthistory.ResearchTypeGridStr','personinfo.common.pasthistory.ResearchTypeDocumentGridStr',
             'personinfo.common.pasthistory.SeminarTypeGridStr','personinfo.common.pasthistory.SeminarTypeDocumentGridStr',
             'personinfo.common.pasthistory.PatentTypeGridStr','personinfo.common.pasthistory.PatentTypeStr',
             'personinfo.common.pasthistory.PatentTypeDocumentGridStr',
             'personinfo.common.pasthistory.PersonTrainingTypeGridStr','personinfo.common.pasthistory.TrainingTypeStr',
             'personinfo.common.pasthistory.TrainingStatusStr','personinfo.common.pasthistory.TrainingTypeDocumentGridStr',
             'examinationcenters.repetitioncompletion.CourseCompletionStatus',
             'personinfo.common.pasthistory.HosetlTrainingTypeGridStr','feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetails',
             'personinfo.common.pasthistory.CompetitiveExamGridStr','admission.applications.history.ExaminationName',
             'admission.applications.history.StudyModes','admission.applications.history.ResultStatus',
             'admission.applications.history.ExaminationYears','admission.applications.history.EducationGradAndMarks',
             'facilitiesresources.resourcebooking.EventNameListStore','common.ColorStore','personinfo.common.pasthistory.WorkExperienceDesignationStore',
             'department.DepartmentStore','feeandpayment.payment.BillHeaderAdjustmentDetails',
             'enquiry.studentDetail.BloodGroupStore', 'common.CountryStore','personinfo.common.pasthistory.TransportDetailsGridStore',
             'personinfo.common.pasthistory.ChurchInformationStore','common.MembershipStatusStore','feeandpayment.adjustment.BillReceivableApplicantHead','admission.applications.history.MediumOfInstructionsStore',
             'personinfo.common.pasthistory.PatentTypeStore','common.EducationHistorySubjectStore','personinfo.common.pasthistory.NonAcademicAchievementsGridStore','personinfo.common.personalinfo.SportEventStore',
             'personinfo.common.personalinfo.LevelEventStore','common.StoSocioEconomicHighestQualiStore','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch','common.AllUserBySmartSearch',
             'common.PatentDetailsSupervisorStore','personinfo.common.pasthistory.PatentSupervisorGridStr','common.SalutationStore','common.YesNoClientSideComboStore','personinfo.common.pasthistory.FacultyNonAcademicAchievementsGridStore','personinfo.common.personalinfo.LevelEventStore',
             'common.CSMIndustryStore','admission.applications.history.OfficerFormativeQualifiedStore','enquiry.EducationDepartmentStore','personinfo.common.personalinfo.QualificationTypeStore',
             'personinfo.common.pasthistory.PhysicalCharacteristicsStore','personinfo.common.pasthistory.EmployeeInsuranceHistoryStore',
             'personinfo.student.PostDocInfoDocumentStore','common.ProgramCesmClassificationStore','common.FinancialResourceStore',
             'personinfo.common.pasthistory.StudentPostDocInfoStore','student.postGraduateManagement.StudentJointDegreeStore','student.postGraduateManagement.StudentJointDegreeDocumentStore',
             'common.ThesisApprovalBodyStore','common.ThesisApprovalStatusStore','student.postGraduateManagement.StudentThesisTitleStore',
             'common.CollaborationAgreementTypeStore','student.postGraduateManagement.StudentPostDocInfoDocumentListStore','student.postGraduateManagement.StudentJointDegreeDocumentListStore', 
             'student.postGraduateManagement.StudentOwnProgressReportGridStore','student.postGraduateManagement.StudentOwnProgressReportDocumentGridStore',
             'personinfo.common.pasthistory.StudentMOUStore','student.postGraduateManagement.StudentMOUDocumentStore',
             'common.FunctionaryTypeStore','student.postGraduateManagement.FunctionaryProgressReportStore','student.postGraduateManagement.FunctionaryProgressReportDocumentStore',
             'common.AllUserBySmartSearchFPR','student.postGraduateManagement.StudentEthicsClearanceLetterStore','student.postGraduateManagement.StudentEthicsClearanceLetterDocumentStore',
             'student.postGraduateManagement.StudentExaminersReportStore','student.postGraduateManagement.StudentExaminersReportDocumentStore','student.postGraduateManagement.StudentExaminersReportDocumentListStore',
             'scholarships.ScholarshipOwnersStore','personinfo.common.pasthistory.FunctionaryDetailsStore','student.postGraduateManagement.StudentThesisUploadGridStore','student.postGraduateManagement.StudentThesisUploadDocumentStore','student.postGraduateManagement.StudentThesisUploadDocumentListStore',
             'student.postGraduateManagement.NominateExaminersStore','common.AllUserBySmartSearchNE','common.ExaminerTypeStore','common.ExamTypeStore',
             'common.ReportRatingStore','student.postGraduateManagement.IndependentNonExaminingChairPersonDocStore','student.postGraduateManagement.IndependentNonExaminingChairpersonReportStore',
             'common.ReportRatingStore','student.postGraduateManagement.IndependentNonExaminingChairpersonReportStore','student.postGraduateManagement.IndependentNonExaminingChairPersonDocStore',
             'common.ResearchActivityCSMStore','common.OUDepartmentStore','common.ResearchActivityCSMStore','student.postGraduateManagement.ProofOfActivityStore',
             'student.postGraduateManagement.ProofOfActivityDocumentStore','student.postGraduateManagement.ProofOfActivityDocumentGridStore','student.postGraduateManagement.StudentThesisActiveProgramStore', 
             'personinfo.common.pasthistory.EducationHistoryDetailStore','personinfo.common.pasthistory.StudentEducationHistoryDocumentStore','personinfo.common.pasthistory.StudentEducationHistoryUrlGridStore',
            'personinfo.common.personalinfo.ApplicantEducationDetailStore','personinfo.common.pasthistory.ApplicantEducationHistoryDocumentStore','personinfo.common.pasthistory.ApplicantEducationHistoryUrlGridStore',
             'personinfo.common.personalinfo.LanguageStore','personinfo.common.personalinfo.LanguageExamTypeStore','personinfo.common.pasthistory.StudentLanguageDocumentStore',
             'personinfo.common.pasthistory.StudentLanguageDocumentStore','personinfo.common.pasthistory.StudentLanguageUrlGridStore','personinfo.common.pasthistory.StudentLanguageListDocumentStore',
             'common.MedicalConditionCSMStore','common.MedicationCSMStore','common.AllergiesCSMStore','common.LearningDifficultiesCSMStore', 'personinfo.common.pasthistory.StudentHealthInformationUrlGridStore','personinfo.common.pasthistory.StudentHealthInformationDocumentGridStore',
             'personinfo.common.pasthistory.ApplicantLanguageListDocumentStore','personinfo.common.pasthistory.ApplicantLanguageUrlGridStore','personinfo.common.pasthistory.ApplicantLanguageDocumentDetailStore','personinfo.common.pasthistory.ApplicantLanguageUrlDetailStore','personinfo.common.pasthistory.ApplicantHealthInformationDocumentGridStore',
             'personinfo.common.pasthistory.ApplicantHealthInformationUrlGridStore','common.LearningAllowancesCSMStore','personinfo.common.pasthistory.LearningAllowanceStore','student.postGraduateManagement.UserExamPanelListStore','common.StudentGrantByStore','common.StudentAdmissionIdStore',
             'personinfo.common.pasthistory.IttEntryRouteStore','personinfo.common.pasthistory.FeeEligibilityStore','personinfo.common.pasthistory.QualifiedTeacherStatusStore',
             'personinfo.common.pasthistory.ResearchCouncilStudentStore','personinfo.common.pasthistory.NHSEmployerStore','personinfo.common.pasthistory.StudyIntentionStore',
             'personinfo.common.pasthistory.IncomingExchangeStore', 'common.unitOfAssessmentStore'], 
            
         views: ['personinfo.common.PersonCommonWindow', 
            'personinfo.common.pasthistory.EducationHistoryGrid', 'personinfo.common.pasthistory.EducationForm', 
            'personinfo.common.pasthistory.WorkExperienceGrid', 'personinfo.common.pasthistory.WorkExperienceForm',
            'personinfo.common.pasthistory.MedicalGrid', 'personinfo.common.pasthistory.MedicalHistoryForm',
            'personinfo.common.pasthistory.VaccinationGrid', 'personinfo.common.pasthistory.VaccinationForm',
            'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentGrid',
            'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentList',
            'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentListGrid',
            'personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentGrid',
            'personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentList',
            'personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentListGrid',
            'personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentGrid',
            'personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentList',
            'personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentListGrid',
            'personinfo.common.pasthistory.ExtraCurricularGrid', 'personinfo.common.pasthistory.ExtraCurricularForm',
            'personinfo.common.pasthistory.TrainingDetailsGrid', 'personinfo.common.pasthistory.TrainingFormWindow',
            'personinfo.common.pasthistory.PhysicalCharacteristicsGrid','personinfo.common.pasthistory.InsuranceHistoryGrid','common.NestedJsonCombo',
            'personinfo.common.pasthistory.ResearchTypeGrid','personinfo.common.pasthistory.ResearchTypeForm',
            'personinfo.common.pasthistory.SeminarDetailsGrid','personinfo.common.pasthistory.SeminarDetailsForm',
            'personinfo.common.pasthistory.PatentDetailsGrid','personinfo.common.pasthistory.ResearchTypeDocument',
            'personinfo.common.pasthistory.SeminarTypeDocument','personinfo.common.pasthistory.ResearchDocumentViewForm',
            'personinfo.common.pasthistory.SeminarDocumentViewForm','personinfo.common.pasthistory.PatentDetailsForm',
            'personinfo.common.pasthistory.PatentTypeDocument','personinfo.common.pasthistory.PatentDocumentViewForm',
            'personinfo.common.pasthistory.TrainingPersonDetailsGrid','personinfo.common.pasthistory.PersonTrainingDetailsForm',
            'personinfo.common.pasthistory.TrainingTypeDocument','personinfo.common.pasthistory.PersonTrainingDocumentViewForm',
            'personinfo.common.pasthistory.HostelPersonDetailsGrid',
            'personinfo.common.pasthistory.CompetitiveExamGrid','personinfo.common.pasthistory.CompetitiveExamForm',
            'personinfo.common.pasthistory.WorkExperienceGrid', 'personinfo.common.pasthistory.PhysicalCharacteristicsForm',
            'feeandpayment.payment.BillHeaderAdjustmentDetailsGridWindow',
            'feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetailsGridWindow',
            'personinfo.common.pasthistory.MedicalDetailsForm','personinfo.common.pasthistory.TransportPersonDetailsGrid',
            'personinfo.common.paymentandrefund.PaymentSummaryWin','personinfo.common.pasthistory.ChurchInformationGrid',
            'personinfo.common.pasthistory.ChurchInformationForm','personinfo.common.pasthistory.ChurchEmploymentHistoryWindow',
            'personinfo.common.pasthistory.ApplicantEducationDetailStructure',
            'personinfo.common.pasthistory.ApplicantDetailFormStructure','personinfo.common.pasthistory.ChurchInfoStructure',
            'personinfo.common.pasthistory.DeclarationAndPaymentStructure','personinfo.common.pasthistory.DeclarationAndPaymentForm',
            'personinfo.common.pasthistory.ApplicantMedicalStructure','personinfo.common.pasthistory.ApplicantWorkExpDetailStructure',
            'personinfo.common.pasthistory.ApplicantCompetitiveExamStructure','personinfo.common.pasthistory.ApplicantDetailsForm',
            'personinfo.common.pasthistory.ApplicantParentGuardiangridStructure','personinfo.common.pasthistory.ApplicantSiblingdetailsGridStructure',
            'personinfo.common.pasthistory.ApplicantIdentitydetailsGridStructure','personinfo.common.pasthistory.ApplicantVaccinationgridStructure',
            'personinfo.common.pasthistory.ApplicantExtraCurricularStructure','personinfo.common.pasthistory.ApplicantReferencesDetailsStructure',
            'personinfo.common.pasthistory.ApplicantAdmissionDetailsStructure','personinfo.common.pasthistory.ApplicantMidTermAdmissionDetailsStructure',
            'personinfo.common.pasthistory.ApplicantPaymentDetailsStructure','personinfo.common.pasthistory.ApplicantRefundsDetailsStructure',
            'personinfo.common.pasthistory.ApplicantFeePlanDetailsStructure','personinfo.common.pasthistory.ApplicantOnlinePaymentsStructure',
            'personinfo.common.pasthistory.ApplicantReceiptsDetailsStructure','personinfo.common.pasthistory.ApplicantServiceOptInStructure',
            'personinfo.common.pasthistory.ApplicantCommunitiesOptInStructure','personinfo.common.pasthistory.ApplicantCheckListItemsStructure',
            'personinfo.common.pasthistory.ApplicantFeePayerDetailsStructure','personinfo.common.pasthistory.ApplicantOtherInformationStructure',
            'personinfo.common.paymentandrefund.ReceiptGridForApplicant','personinfo.common.pasthistory.StudentChurchInfoStructure',
            'personinfo.common.pasthistory.FacultyChurchInfoStructure','personinfo.common.pasthistory.ApplicantMedicalDetails2Structure',
            'Academia.view.common.AddressFieldsForm','feeandpayment.payment.ReceiptSettlementHeadWindow','personinfo.common.pasthistory.NonAcademicAchievementsGrid',
            'personinfo.common.pasthistory.NonAcademicAchievementsForm','personinfo.common.pasthistory.ApplicantNonAcademicAchievementsStructure',
            'personinfo.common.pasthistory.StudentNonAcademicAchievementsStructure','personinfo.common.pasthistory.StcAdmApplicantSocioEconomicDetails',
            'personinfo.common.pasthistory.SocioEconomicInformationForm','servicerequest.infirmary.PatentDetailsSupervisorrWindow',
            'personinfo.common.pasthistory.PostSchoolStudiesGrid','personinfo.common.pasthistory.PostSchoolStudiesForm','personinfo.common.pasthistory.StudentPostSchoolStudiesStructure',
            'personinfo.common.pasthistory.EmployeeReferenceDetailsStructure',
            'personinfo.faculty.employeeReference.EmployeeReferenceGrid','personinfo.faculty.employeeReference.EmployeeReferenceFormWindow',
            'personinfo.faculty.employeeReference.EmployeeReferenceForm',
            'personinfo.common.pasthistory.FacultyNonAcademicAchievementsGrid',
            'personinfo.common.pasthistory.FacultyNonAcademicAchievementsForm',
            'personinfo.common.pasthistory.EmployeePhysicalCharacteristicsGrid','personinfo.common.pasthistory.EmployeeInsuranceHistoryForm',
            'personinfo.common.pasthistory.EmployeePhysicalCharacteristicsForm',
            'personinfo.common.pasthistory.VaccinationGridForApplicantFaculty','student.studentprofile.StudentPostDocInfoGrid',
            'personinfo.student.PostDocInfoForm','personinfo.student.PostDocInfoDocumentGrid','student.postGraduateManagement.StudentJointDegreeForm',
            'student.postGraduateManagement.StudentJointDegreeGrid','student.postGraduateManagement.StudentJointDegreeDocumentGrid',
            'personinfo.student.PostDocInfoForm','personinfo.student.PostDocInfoDocumentGrid','student.postGraduateManagement.StudentThesisTitleGrid',
            'personinfo.common.postgraduatemanagement.StudentThesisTitleForm','student.studentprofile.StudentPostDocInfoDocumentList',
            'student.studentprofile.StudentPostDocInfoDocumentListGrid','student.studentprofile.StudentJointDegreeDocumentList','student.studentprofile.StudentJointDegreeDocumentListGrid',
            'student.postGraduateManagement.StudentOwnProgressReportGrid','student.postGraduateManagement.StudentOwnProgressReportForm',
            'student.studentprofile.StudentMOUGrid','personinfo.student.StudentMOUForm',
            'student.postGraduateManagement.StudentMOUDocumentGrid','student.studentprofile.StudentMOUDocumentList','student.studentprofile.StudentMOUDocumentListGrid',
            'student.postGraduateManagement.StudentOwnProgressReportGrid','student.postGraduateManagement.StudentOwnProgressReportForm','student.postGraduateManagement.StudentOwnProgressReportDocumentGrid',
            'student.studentprofile.StudentOwnProgressReportDocumentList','student.studentprofile.StudentOwnProgressReportDocumentListGrid',
            'personinfo.student.FunctionaryProgressReportForm','student.studentprofile.FunctionaryProgressReportGrid','student.postGraduateManagement.FunctionaryProgressReportDocumentGrid',
            'student.studentprofile.FunctionaryProgressReportDocumentList','student.studentprofile.FunctionaryProgressReportDocumentListGrid',
            'student.studentprofile.StudentEthicsClearanceLetterGrid','personinfo.student.StudentEthicsClearanceLetterForm',
            'student.postGraduateManagement.StudentEthicsClearanceLetterDocumentGrid','student.studentprofile.StudentEthicsClearanceLetterDocumentList',
            'student.studentprofile.StudentEthicsClearanceLetterDocumentListGrid','student.postGraduateManagement.StudentExaminersReportGrid','student.postGraduateManagement.StudentExaminersReportForm',
            'student.postGraduateManagement.StudentExaminersReportDocumentGrid','student.postGraduateManagement.StudentExaminersReportDocumentList','student.postGraduateManagement.StudentExaminersReportDocumentListGrid',
            'student.studentprofile.FunctionaryDetailsGrid','personinfo.student.FunctionaryDetailsForm','student.postGraduateManagement.StudentThesisUploadGrid','student.postGraduateManagement.StudentThesisUploadDocumentList',
            'student.postGraduateManagement.StudentThesisUploadDocumentListGrid','student.postGraduateManagement.StudentThesisUploadForm','student.postGraduateManagement.StudentThesisUploadDocumentGrid',
            'student.studentprofile.NominateExaminersGrid','student.studentprofile.FlagListstudentGrid','personinfo.student.NominateExaminersForm','student.postGraduateManagement.IndependentNonExaminingChairpersonReportGrid',
            'student.postGraduateManagement.IndependentNonExaminingChairPersonForm','student.postGraduateManagement.IndependentNonExaminingChairPersonDocGrid','student.postGraduateManagement.IndependentNonExaminingChairPersonDocumentList','student.postGraduateManagement.IndependentNonExaminingChairPersonDocumentListGrid','student.postGraduateManagement.ProofOfActivityGrid','personinfo.student.ProofOfActivityForm','student.postGraduateManagement.ProofOfActivityDocumentGrid','student.studentprofile.ProofOfActivityDocumentList','student.studentprofile.ProofOfActivityDocumentListGrid',
            'personinfo.common.pasthistory.StudentEducationHistoryDetailGrid','personinfo.common.pasthistory.EducationHistoryDetailForm','personinfo.common.pasthistory.StudentEducationHistoryDocumentList','personinfo.common.pasthistory.StudentEducationHistoryDocumentListGrid', 'personinfo.common.pasthistory.StudentEducationHistoryDocUrlList','personinfo.common.pasthistory.StudentEducationHistoryDocUrlListGrid',
            'personinfo.common.pasthistory.StudentEducationHistoryDocumentGrid','personinfo.common.pasthistory.StudentEducationHistoryUrlGrid','personinfo.common.personalinfo.ApplicantEducationDetailsGrid','personinfo.common.pasthistory.ApplicantLanguageInformationGrid','personinfo.common.pasthistory.StudentLanguageInformationGrid','document.DocumentFormWindow','personinfo.common.pasthistory.HealthInformationDetailGrid',
            'personinfo.common.pasthistory.ApplicantEducationHistoryDocumentList','personinfo.common.pasthistory.ApplicantEducationHistoryDocumentListGrid','personinfo.common.pasthistory.ApplicantEducationHistoryDocUrlList','personinfo.common.pasthistory.ApplicantEducationHistoryDocUrlListGrid',
            'personinfo.common.pasthistory.ApplicantEducationHistoryDocumentGrid','personinfo.common.pasthistory.ApplicantEducationHistoryUrlGrid','personinfo.common.pasthistory.StudentLanguageDetailForm',
            'personinfo.common.pasthistory.StudentLanguageDocumentGrid','personinfo.common.pasthistory.StudentLanguageDocumentList',
            'personinfo.common.pasthistory.StudentLanguageDocumentListGrid','personinfo.common.pasthistory.StudentLanguageDocUrlList','personinfo.common.pasthistory.StudentLanguageDocUrlListGrid',
            'personinfo.common.pasthistory.StudentLanguageUrlGrid','personinfo.common.pasthistory.StudentHealthInformationForm','personinfo.common.pasthistory.StudentHealthInformationDocumentGrid','personinfo.common.pasthistory.StudentHealthInformationUrlGrid','document.DocumentFormWindow','personinfo.common.pasthistory.ApplicantLanguageDocumentList','personinfo.common.pasthistory.ApplicantLanguageDocumentListGrid',
            'personinfo.common.pasthistory.ApplicantLanguageDocUrlList','personinfo.common.pasthistory.ApplicantLanguageDocUrlListGrid','personinfo.common.pasthistory.ApplicantLanguageDocDetailGrid',
            'personinfo.common.pasthistory.ApplicantLangUrlGrid','personinfo.common.pasthistory.StudentHealthInformationDocumentList','personinfo.common.pasthistory.StudentHealthInformationDocumentListGrid','personinfo.common.pasthistory.StudentHealthInformationDocUrlList','personinfo.common.pasthistory.StudentHealthInformationDocUrlListGrid','personinfo.common.pasthistory.ApplicantHealthInformationGrid','document.DocumentFormWindow','personinfo.common.pasthistory.ApplicantHealthInformationDocumentGrid','personinfo.common.pasthistory.ApplicantHealthInformationUrlGrid','personinfo.common.pasthistory.ApplicantHealthInformationDocumentListGrid','personinfo.common.pasthistory.ApplicantHealthInformationDocumentList','personinfo.common.pasthistory.ApplicantHealthInformationDocUrlList','personinfo.common.pasthistory.ApplicantHealthInformationDocUrlListGrid',
            'personinfo.student.PostDocInfoForm','personinfo.common.pasthistory.LearningAllowanceGrid','personinfo.common.pasthistory.StudentLearningAllowanceAddForm',
            'personinfo.common.pasthistory.StudentEngagementForm'],           
            alias: "widget.personpasthistorycontroller",
            refs: [{
        ref: 'trainingDetailsGrid',
        selector: 'trainingdetailsgrid'

    }, {
        ref: 'trainingFormWindow',
        selector: 'trainingformwindow'

    }, {
        ref: 'medicalhistoryform',
        selector: 'medicalhistoryform'

    },
    {
        ref: 'postdocinfoform',
        selector: 'postdocinfoform'

    },{
        ref: 'patentdetailssupervisorrwindow',
        selector: 'patentdetailssupervisorrwindow'

    }, {
        ref: 'employeereferenceformwindow',
        selector: 'employeereferenceformwindow'
        	
    },{
        ref: 'employeephysicalcharacteristicsform',
        selector: 'employeephysicalcharacteristicsform'
    },
    {
		ref : 'vaccinationgridforapplicantfaculty',
		selector : 'vaccinationgridforapplicantfaculty'
	},
	{
        ref: 'employeeinsurancehistoryform',
        selector: 'employeeinsurancehistoryform'
    },
    {
		 ref: 'insuranceform',
		 selector: 'insuranceform[itemId=applicantinsuranceformId]'
	},
	{
		ref: 'studenthealthinformationform',
		selector: 'studenthealthinformationform'
	},
	{
		ref: 'studentengagementform',
		selector: 'studentengagementform'
	}],
    config: {
    	STUDENT_TRAINING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRAINING_PRIVILEGES'),
    	FACULTY_TRAINING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_TRAINING_PRIVILEGES')
    },
    init: function(application) {
    	var this$ = this;
    	this$.callParent(arguments); 
    	this.control({
    		'medicaldetailsform': {
    			render: function(obj) {
    				this.getStore('enquiry.studentDetail.BloodGroupStore').load();
    				this.getStore('common.CountryStore').load();
    			},
    		},
    		'medicalhistoryform  customcombobox[itemId=doctorTelephoneCountryCodeItemId]': {
    			select: function(rowModel,record){
    				var this$ = this;
    				var form =this$.getMedicalhistoryform();
    				var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
    		    	var mobileField = form.down("#doctorTelephoneNoItemId");
    		     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    		     	
    		    
    			}
    		},
    		'medicalhistoryform  numberfield[itemId=doctorTelephoneNoItemId]': {
    			change: function(record){
    				var this$ = this;
    				var form =this$.getMedicalhistoryform();
					var mobileField = form.down("#doctorTelephoneNoItemId");
    				mobileField.isValid();
    				form.getForm().checkValidity();
    			}
    			},
    			'studentengagementform button[itemId=saveBtn]': {
    				click: this.saveStudentEngagement
    			},
    			'studentengagementform': {
                    beforerender: this.loadStudentEngagementData
                }
    	})
    },
    
    /**
	 * Load store after grid renderer
	 * 
	 * @param gridItemId
	 * @param url
	 */

    loadGridStore: function(gridItemId, url,portalgrid) {
    	var this$ = this;
    	var grid;
    	var personId;
    	if(this.getCurrentLoggedPortalId() == 2 || this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
// var contentpanel = this.getContentPanel();
// grid = contentpanel.down('#'+gridItemId);
    		grid = portalgrid;
    		try{
    			personId = this.getPersonObj().id;
    			if(isNullOrEmpty(personId)){
    				personId = this.getCurrentlyLoggedInUserWithPersonId().personId;
    			}
    		}
    		catch(e){
    			personId = this.getCurrentlyLoggedInUserWithPersonId().personId;
    		}
    		
    		if(this.getCurrentLoggedPortalId() == 7){
    			var portalInfo = Academia.model.authentication.PortalInfoModel;
    			var student = portalInfo.get('student');
    			personId = student.person.id;
    		}
    	}else{
    		var personProfile = this$.getContentPanelActiveTab();
    		var personObj = this$.getPersonObj();
    		grid = personProfile.down(gridItemId);
    		personId = personObj["id"];
    	}

    	if (grid) {
    		if(grid.xtype == 'functionarydetailsgrid' && this.getCurrentLoggedPortalId() != 2){
    			var store = grid.getStore();
        		store.getProxy().api.read = url;
        		store.getProxy().extraParams = {
        			admissionId: personProfile.admissionId,
        		};
        		store.load();
    		}else{
    			var store = grid.getStore();
        		store.getProxy().api.read = url;
        		store.getProxy().extraParams = {
        		    personId:personId,
        		    limit:25
        		};
        		store.load();
    		}
    		
    	}},
    	
    	getDownloadFile : function(documentId){
    	   	 if(!isNullOrEmpty(documentId)){
    	   		 var $this = this;
    	   		 $this.getDocumentController()
    	   		 .downloadDocumentFile(
    	   				 documentId);
    	   	 }
    	    },
    	    deleteVaccinationDocument:function(person){
             	 var $this=this;
             	 var form ;
            	 var vaccinationinfo ;
            	 var vaccinationInfoDocGrid ;
             	 if(person == 'student'){
             		 form = $this.getVaccinationinfodocumentlist();
                	 vaccinationinfo = this.getVaccinationinfodocumentlistgrid();
                	 vaccinationInfoDocGrid=form.down('#vaccinationinfodocumentlistgridItemId');  
                	 var vaccinationinfogrid= $this.getVaccinationgrid();
 				 }
             	if(person == 'employee'){
            		 form = $this.getEmployeevaccinationinfodocumentlist();
            		 vaccinationinfo = this.getEmployeevaccinationinfodocumentlistgrid();
            		 vaccinationInfoDocGrid=form.down('#employeevaccinationinfodocumentlistgridItemId');    
                	 var vaccinationinfogrid = $this.getVaccinationgridforapplicantfaculty();

				 }
             	 if(person == 'applicant'){
             		form = $this.getApplicantvaccinationinfodocumentlist();
             		vaccinationinfo = this.getApplicantvaccinationinfodocumentlistgrid();
               	    vaccinationInfoDocGrid=form.down('#applicantvaccinationinfodocumentlistgridItemId');
               	 var vaccinationinfogrid = $this.getVaccinationgridforapplicantfaculty();

 				 }
             	 
             	 if (vaccinationInfoDocGrid.getSelectionModel().getCount() > 0) {
             		 var records = vaccinationInfoDocGrid.getSelectionModel().getSelection();
             		 var ids=[];
             		 Ext.Array.each(records,function(value){
             			 ids.push(value.data.id);
             		 });
             		 showConfirmMessage(getCommonTranslation('VACCINATION_INFO'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
             			 if (btn == 'yes'){
             				 if(person == 'student' || person == 'employee'){
             					actionURL = SERVERURL.VACCINATION_INFO_DOCUMENT_DELETE;
             				 }
             				 if(person == 'applicant'){
             					actionURL = SERVERURL.APPLICANT_VACCINATION_INFO_DOCUMENT_DELETE;
            				 }
             				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
             				 Ext.Ajax.request({
             					 method: "DELETE",
             					 type: 'rest',
             					 url : actionURL+'?fileDocumentIds='+ids.join(),
             					 headers: {
             						 'Content-Type': 'application/json'
             					 },
             					 success: function(form, action) {

             						 Ext.getBody().unmask();
             						 showSuccessMessage(getCommonTranslation('VACCINATION_INFO'),getCommonTranslation('VACCINATION_INFO_DOCUMENT_SUCCESS_DELETE_MSG'));	 
             						vaccinationInfoDocGrid.store.reload();
             						vaccinationinfogrid.store.reload();
             						vaccinationInfoDocGrid.getSelectionModel().deselectAll(true);
             					 }
             				 });
             			 }
             		 });
             	 } else {
             		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
             	 }
              },
    	documentReportDocumentZip : function(person) {
    			   var $this = this;
    			   var form;
    			   var vaccinationInfoGrid;
    			   if(person == 'student'){
    				   form = $this.getVaccinationinfodocumentlist();
        			   vaccinationInfoGrid=form.down('#vaccinationinfodocumentlistgridItemId');
    			   }
    			   if(person == 'employee'){
    				   form = $this.getEmployeevaccinationinfodocumentlist();
        			   vaccinationInfoGrid=form.down('#employeevaccinationinfodocumentlistgridItemId');
    			   }
    			   if(person == 'applicant'){
    				   form = $this.getApplicantvaccinationinfodocumentlist();
        			   vaccinationInfoGrid=form.down('#applicantvaccinationinfodocumentlistgridItemId');
    			   }
    	        	 if (vaccinationInfoGrid.getSelectionModel().getCount() > 0) {
    	        		 var records = vaccinationInfoGrid.getSelectionModel().getSelection();
    			   var dispatchZipName = "Vaccination info  Documnet";
    	      		 var saveModel=[];  
    	      		 for(var i in records){
    	      			 if(!isNullOrEmpty(records[i].get('path'))) {
    	      				 saveModel.push(records[i].get('path'));
    	      			 }
    			   showConfirmMessage(getCommonTranslation('VACCINATION_DETAILS_DOCUMENTS'),
    					   getCommonTranslation('VACCINATION_INFO_DOCUMENTS_ALERT'),
    					   function(btn, text) {
    						   if (btn == 'yes') {
    							   var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
    							   $this.getController('Academia.controller.document.DocumentController')
    							   .downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
    						   }
    					   });

    		                }
    			   }
    			   else {
    	      		 $this.hideWindowMask();
    	      		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	      	 }
    	    },
    
    processVaccinationInfoDetailsWindow : function(actionType) {
    	
    },
    /**
	 * show person common window
	 * 
	 * @param informationType
	 * @param formItemId
	 */
    showPersonCommonWindow : function(informationType, formItemId){
    	var this$ = this;
    	var title = null, xtypeForm = null;
    	var formWindow = this$.getPersonCommonWindow();
    	if(!formWindow){
    		switch(informationType){
        	
	    		case 'EDUCATION' : {// Education
		    		title = getPersonModuleTranslation('EDUCATION_HISTORY');
		    		xtypeForm = 'educationform';
		    		break;
		    	}
    			case 'WORK_EXPERIENCE' : {// Work Experience
		    		title = getPersonModuleTranslation('WORK_EXPERIENCE');
		    		xtypeForm = 'workexperienceform';
		    		break;
		    	}
		    	case 'MEDICAL' : {// Medical
		    		title = getPersonModuleTranslation('MEDICAL_HISTORY');
		    		xtypeForm = 'medicalhistoryform';
		    		break;
		    	}
		    	case 'MEDICAL_DETAILS': { // Medical Details
		            title = getPersonModuleTranslation('MD_MEDICAL_DETAILS');
		            xtypeForm = 'medicaldetailsform';
		            break;
		        }
		    	case 'VACCINATION' : {// Vaccination
		    		title = getPersonModuleTranslation('VACCINATION_DETAILS');
		    		xtypeForm = 'vaccinationform';
		    		var vaccinationinfodocumentStore = this.getStore('personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentStore');
		    		vaccinationinfodocumentStore.removeAll();
		    		var applicantvaccinationinfodocumentStore = this.getStore('personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentStore');
		    		applicantvaccinationinfodocumentStore.removeAll();
		    		var employeevaccinationinfodocumentStore = this.getStore('personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentStore');
		    		employeevaccinationinfodocumentStore.removeAll();
		    		break;
		    	}
		    	case 'EXTRA_CURRICULAR' : {// Extra-Curricular
		    		title = getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY');
		    		xtypeForm = 'extracurricularform';
		    		break;
		    	}
		    	case 'RESEARCH_VIEW_DOCUMENT' : {// On click of
													// hyperlink,show number of
													// document
		    		title = getPersonModuleTranslation('RESEARCH_VIEW_DOCUMENT');
		    		xtypeForm = 'researchdocumentviewform';
		    		break;
		    	}
		    	case 'SEMINAR_TYPE' : {// Seminar Type
		    		title = getPersonModuleTranslation('SEMINAR_TYPE');
		    		xtypeForm = 'seminardetailsform';
		    		break;
		    	}
		    	case 'SEMINAR_VIEW_DOCUMENT' : {// On click of hyperlink,show
												// number of document
		    		title = getPersonModuleTranslation('SEMINAR_VIEW_DOCUMENT');
		    		xtypeForm = 'seminardocumentviewform';
		    		break;
		    	}
		    	case 'PATENT_TYPE' : {// Patent Type
		    		title = getPersonModuleTranslation('PATENT_DETAILS');
		    		xtypeForm = 'patentdetailsform';
		    		break;
		    	}
		    	case 'PATENT_VIEW_DOCUMENT' : {// On click of hyperlink,show
												// number of document
		    		title = getPersonModuleTranslation('PATENT_VIEW_DOCUMENT');
		    		xtypeForm = 'patentdocumentviewform';
		    		break;
		    	}
		    	case 'TRAINING_DETAILS' : {// Training Type
		    		title = getPersonModuleTranslation('TRAINING_DETAILS');
		    		xtypeForm = 'persontrainingdetailsform';
		    		break;
		    	}
		    	case 'TRAINING_VIEW_DOCUMENTS' : {// On click of
													// hyperlink,show number of
													// document
		    		title = getPersonModuleTranslation('TRAINING_TYPE_DOCUMENTS');
		    		xtypeForm = 'persontrainingdocumentviewform';
		    		break;
		    	}
		    	case 'COMPETITIVE_EXAM' : {
		    		title = getPersonModuleTranslation('COMPETITIVE_EXAM');
		    		xtypeForm = 'competitiveexamform';
		    		break;
		    	}
		    	case 'PHYSICAL_CHARACTERISTICS' : {
		    		title = getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS');
		    		xtypeForm = 'physicalcharacteristicsform';
		    		break;
		    	}
		    	case 'FACULTY_PHYSICAL_CHARACTERISTICS': { 
			    		title = getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS');
			            xtypeForm = 'employeephysicalcharacteristicsform';
			            break;
			    }
		    	case 'FACULTY_INSURANCE_HISTORY': { 
		    		title = getPersonModuleTranslation('INSURANCE_HISTORY');
		            xtypeForm = 'employeeinsurancehistoryform';
		            break;
		    }
		    	case 'CHURCH_INFORMATION' : {
		    		title = getPersonModuleTranslation('CHURCH_INFORMATION');
		    		xtypeForm = 'churchinformationform';
		    		break;
		    	}
		    	case 'APPLICANT_DETAILS_FORM': { // applicant form for AU
													// portal only
		            title = getPersonModuleTranslation('APPLICANT_DETAILS_FORM');
		            xtypeForm = 'applicantdetailsform';
		            break;
		        }
		    	// Communication History
		    	case 'COMMUNICATION_HISTORY': { 
		    		title = getPersonModuleTranslation('COMMUNICATION_HISTORY');
		            xtypeForm = 'communicationhistorystructure';
		            break;
		        }
		        case 'FACULTY_NON_ACADEMIC_ACHIEVEMENTS': { 
		    		title = getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS');
		            xtypeForm = 'facultynonacademicachievementsform';
		            break;
		            
		        }
		    	case 'NON_ACADEMIC_ACHIEVEMENTS': { 
		    		title = getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS');
		            xtypeForm = 'nonacademicachievementsform';
		            break;
		        }
		    	case 'SOCIO_ECONOMIC_INFORMATION': { 
		    		title = getPersonModuleTranslation('SOCIO_ECONOMIC_INFORMATION');
		            xtypeForm = 'socioeconomicinformationform';
		            break;
		        }case 'POST_SCHOOL_STUDIES_INFO': { 
		    		title = getPersonModuleTranslation('POST_SCHOOL_STUDIES');
		            xtypeForm = 'postschoolstudiesform';
		            break;
		        }case 'STUDENT_POST_DOC_INFO': { 
		    		title = getPersonModuleTranslation('STUDENT_POST_DOC_INFO');
		            xtypeForm = 'postdocinfoform';
		            var postDocInfoDocumentStore=this.getStore('personinfo.student.PostDocInfoDocumentStore');
		            postDocInfoDocumentStore.removeAll();
		            break;
		        }case 'STUDENT_JOINT_DEGREE_INFO_FORM': { 
                    title = getPersonModuleTranslation('STUDENT_JOINT_DEGREE');
                    xtypeForm = 'studentjointdegreeform';
                    var studentJointDegreeDocumentStore=this.getStore('student.postGraduateManagement.StudentJointDegreeDocumentStore');
                    studentJointDegreeDocumentStore.removeAll();
                    break;
                }case 'STUDENT_THESIS_TITLE': { 
		    		title = getPersonModuleTranslation('STUDENT_THESIS_TITLE');
		            xtypeForm = 'studentthesistitleform';
		            break;
		        }case 'STUDENT_OWN_PROGRESS_REPORT': { 
                    title = getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT');
                    xtypeForm = 'studentownprogressreportform';
                    var studentOwnProgressReportDocumentGridStore=this.getStore('student.postGraduateManagement.StudentOwnProgressReportDocumentGridStore');
                    studentOwnProgressReportDocumentGridStore.removeAll();
                    break;
                }
		        case 'STUDENT_MOU': { 
                    title = getCommonTranslation('STUDENT_MOU');
                    xtypeForm = 'studentmouform';
                    var studentMOUDocumentStore=this.getStore('student.postGraduateManagement.StudentMOUDocumentStore');
                    studentMOUDocumentStore.removeAll();
                    break;
                }
		        case 'FUNCTIONARY_PROGRESS_REPORT': { 
                    title = getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT');
                    xtypeForm = 'functionaryprogressreportform';
                    var functionaryProgressReportDocumentStore=this.getStore('student.postGraduateManagement.FunctionaryProgressReportDocumentStore');
                    functionaryProgressReportDocumentStore.removeAll();
                    break;
                }
		        case 'STUDENT_ETHICS_CLEARANCE_LETTER': { 
                    title = getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER');
                    xtypeForm = 'studentethicsclearanceletterform';
                    var studentEthicsClearanceLetterDocumentStore=this.getStore('student.postGraduateManagement.StudentEthicsClearanceLetterDocumentStore');
                    studentEthicsClearanceLetterDocumentStore.removeAll();
                    break;
		        }case 'FUNCTIONARY_DETAILS': { 
		    		title = getPersonModuleTranslation('FUNCTIONARY_DETAILS');
		            xtypeForm = 'functionarydetailsform';
		            break;
                }
		        case 'STUDENT_EXAMINERS_REPORT_FORM': { 
                    title = getCommonTranslation('STUDENT_EXAMINERS_REPORT');
                    xtypeForm = 'studentexaminersreportform';
                    var studentExaminersReportDocumentStore=this.getStore('student.postGraduateManagement.StudentExaminersReportDocumentStore');
                    studentExaminersReportDocumentStore.removeAll();
                    break;
                }
		        case 'STUDENT_THESIS_UPLOAD_FORM': { 
                    title = getCommonTranslation('STUDENT_THESIS_UPLOAD');
                    xtypeForm = 'studentthesisuploadform';
                    var studentThesisUploadDocumentStore=this.getStore('student.postGraduateManagement.StudentThesisUploadDocumentStore');
                    studentThesisUploadDocumentStore.removeAll();
                    break;
                }case 'NOMINATE_EXAMINERS': { 
		    		title = getCommonTranslation('NOMINATE_EXAMINERS');
		            xtypeForm = 'nominateexaminersform';
		            break;
		        }
                case 'INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT': { // INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_FORM
                    title = getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT');
                    xtypeForm = 'independentnonexaminingchairpersonform';// 
                    var independentNonExaminingChairPersonDocStore = this.getStore('student.postGraduateManagement.IndependentNonExaminingChairPersonDocStore');
                    independentNonExaminingChairPersonDocStore.removeAll();
                    break;
                } 
                case 'PROOF_OF_ACTIVITY': { 
                    title = getCommonTranslation('PROOF_OF_ACTIVITY');
                    xtypeForm = 'proofofactivityform';
                    var proofOfActivityDocumentStore=this.getStore('student.postGraduateManagement.ProofOfActivityDocumentStore');
                    proofOfActivityDocumentStore.removeAll();
                    break;
                }
                case 'EDUCATION_DETAILS' : {
		    		title = getCommonTranslation('EDUCATION_DETAILS');
		    		xtypeForm = 'educationhistorydetailform';
		    		var studentEducationHistoryDocumentStore=this.getStore('personinfo.common.pasthistory.StudentEducationHistoryDocumentStore');
		    		studentEducationHistoryDocumentStore.removeAll();
                    var studentEducationHistoryUrlGridStore=this.getStore('personinfo.common.pasthistory.StudentEducationHistoryUrlGridStore');
                    studentEducationHistoryUrlGridStore.removeAll();
		    		break;
		    	}
		    	 case 'STUDENT_LANGUAGE' : {
		    		title = getCommonTranslation('ADD_LANGUAGE_INFORMATION');
		    		xtypeForm = 'studentlanguagedetailform';
		    		break;
		    	}
		    	case 'HEALTH_INFORMATION' : {
		    		title = getCommonTranslation('HEALTH_INFORMATION');
		    		xtypeForm = 'studenthealthinformationform';
		    		var studentHealthInformationDocumentGridStore=this.getStore('personinfo.common.pasthistory.StudentHealthInformationDocumentGridStore');
		    		studentHealthInformationDocumentGridStore.removeAll();
                    var studentHealthInformationUrlGridStore=this.getStore('personinfo.common.pasthistory.StudentHealthInformationUrlGridStore');
                    studentHealthInformationUrlGridStore.removeAll();
		    		break;
		    	}
		    	case 'LEARNING_ALLOWANCES' : {
		    		title = getPersonModuleTranslation('LEARNING_ALLOWANCES');
		    		xtypeForm = 'studentlearningallowanceaddform';
		    		break;
		    	}
		    	case 'APPLICANT_LANGUAGE' : {
		    		title = getCommonTranslation('APPLICANT_ADD_LANGUAGE_INFORMATION');
		    		xtypeForm = 'studentlanguagedetailform';
		    		break;
		    	}
		       
		    	default :{
		    		break;
		    	}
	    	
    		}
    		
    		formWindow = Ext.widget('personcommonwindow',{
        		title: title,
        		itemId : 'personCommonWindow',
        		items: [{
        			 xtype: xtypeForm,
        		     itemId: formItemId/*,
        		     listeners: {
        		     	afterrender : function(formInfo){
        		     		this$.mixins.ApplicantPortalSetupController.getDFRForApplicantProfileURL(formInfo);	
        		     	}
        		     }*/
        		}]
        	});    		
    	}
    	formWindow.show();
    	if(informationType=='EDUCATION'){
    		var window = this.getPersonEducationForm();
    		var educationForm = this.getPersonEducationForm().getForm();	
    		this.educationFormAddBtnClick(window,educationForm)
    	}
    	if(informationType=='COMPETITIVE_EXAM'){
    		var competitiveForm = this.getPersonCompetitiveExamForm();
    		var completionDate = competitiveForm.down('#completionDate');
    		var removeButton = competitiveForm.down('#removeButtonId');
    		completionDate.setVisible(false);
    		completionDate.reset();
    		completionDate.allowBlank=true;
    		removeButton.setVisible(false);
    		competitiveForm.getForm().checkValidity();
    	}
    	return formWindow;
    },
    /**
	 * view person common window
	 */
	viewPersonCommonWindow: function(form){
	    	
	    if (form) {
	    	setTimeout(function(){
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    	}, 500);
	    }
	},
	viewPersonCommonWindowNonAcademicAchievements: function(form){
	    if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
	},
	viewPersonCommonHealthInformationWindow: function(form){
	    if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
	},
	FacultyViewPersonCommonWindow: function(form){
    	
	    if (form) {
	        form.down('#submitButtonId2').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
	},
	   viewVaccinationInfoCommonFormWindow: function(form){
	    	if (form) {
		        form.down('#submitButtonId').setVisible(false);
		        form = form.getForm();
		        toggleReadOnlyFormItems(form, true);
		    }
	    },
    
    /**
	 * Close person common window
	 */
    closePersonCommonWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },
    
    /**
	 * Get Json for form submission
	 */
    getJsonSubmitData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
        	var personObj = this$.getPersonObj();
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'APPLICANT'){
        		delete personObj.personType;
        	}
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'STUDENT'){
        		delete personObj.personType;
        	}
            formData.person = personObj;
        }
        if (!isNullOrEmpty(formData.industry)) {
        	formData.industry = this$.getIdValueJson(formData.industry);
		}
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    getJsonThesisSubmitData: function(form,grid,isUpdate) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if(isUpdate){
			var record = grid.getSelectionModel().getSelection();
			formData.auditId = this$.getIdValueJson(record[0].data.auditId);
		} else {						
			formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
		}
        if (!isEmpty(formData)) {
        	var personObj = this$.getPersonObj();
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'APPLICANT'){
        		delete personObj.personType;
        	}
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'STUDENT'){
        		delete personObj.personType;
        	}
            formData.person = personObj;
            
            if (isNullOrEmpty(formData.approvalBody)) {
            	delete formData.approvalBody;
    		}else{
    			formData.approvalBody = this$.getIdValueJson(formData.approvalBody);
    		}
            if (isNullOrEmpty(formData.approvalStatus)) {
            	delete formData.approvalStatus;
    		}else {
    			formData.approvalStatus = this$.getIdValueJson(formData.approvalStatus);
    		}
            
            if (isNullOrEmpty(formData.programId)) {
            	delete formData.programId;
    		}else{
    			formData.programId = this$.getIdValueJson(formData.programId);
    		}
         var researchActivityJsonArry = [];
       	if(!isNullOrEmpty(formData.researchActivityMultiselect)){
    		if(typeof formData.researchActivityMultiselect == "object"){
        		Ext.each(formData.researchActivityMultiselect, function(currentResearchActivity){
                	var mainObj = '';
                    if(!isNullOrEmpty(currentResearchActivity)){
                    	if(Ext.isObject(currentResearchActivity)){
                    		mainObj = {
                        			"researchActivityMultiselect" : {
                        					"id" : currentResearchActivity.data.id
                        			}		
                        	}
                    	}else{
                    		mainObj = {
                        			"researchActivityMultiselect" : {
                        					"id" : currentResearchActivity
                        			}		
                        	}
                    	}
                	
                	researchActivityJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
            	var mainObj = '';
            	mainObj = {
            			"researchActivityMultiselect" : {
            					"id" : jsonFormatFormData.researchActivityMultiselect
            			}
            	}
            	researchActivityJsonArry.push(mainObj);
    		}
    	}
       	formData.researchActivityMultiselect = researchActivityJsonArry;
        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    getCompExamJsonSubmitData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
        	var personObj = this$.getPersonObj();
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'APPLICANT'){
        		delete personObj.personType;
        	}
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'STUDENT'){
        		delete personObj.personType;
        	}
            formData.person = personObj;
        }
        
        var getYearValue = null;
        var getMonthValue = null;
        
        if( !isNullOrEmpty(formData["yearOfExam"]) ){
        	getYearValue = Ext.Date.format(new Date(formData["yearOfExam"]), 'Y');
        	getMonthValue = parseInt(Ext.Date.format(new Date(formData["yearOfExam"]), 'm'));
        }
    	var fetchMonthValue = this.getMonthArray(getMonthValue);
        var monthofExam = form.down('#monthItemId');
        var yearofExam = form.down('#yearItemId');
        if(monthofExam.isVisible() != true){
        	formData.monthOfExamination = fetchMonthValue;
        }else{
        	formData.monthOfExamination = formData.monthOfExamination.toLocaleUpperCase();
        }
        if(isNullOrEmpty(formData.monthOfExamination)){
            formData.monthOfExamination = null;
        }
        if(yearofExam.isVisible() != true){
        	formData.yearOfExamination = getYearValue;
        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    
    /**
	 * View education history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */

    viewEducationHistoryFormWindow: function(informationType, formItemId, gridItemId, personType) {
    	var this$ = this;
        this$.editEducationHistoryFormWindow(informationType, formItemId, gridItemId, true, personType);
        var form = this$.getPersonEducationForm();
        var window = this$.getPersonCommonWindow();
        for(var i= 0; i <= window.subjectmarksCount; i++){
        	form.down('#btnAddSubjectMarks'+ i).setVisible(false);
        	if(form.down('#btnDeleteSubjectMarks'+ i)!=null){
        	form.down('#btnDeleteSubjectMarks'+ i).setVisible(false);
        }
        }
        form.down('#examBoard').setReadOnly(true);
        form.down('#educationDepartmentId').setReadOnly(true);
        form.down('#countryItemId').setReadOnly(true);
        form.down('#countryRegionItemId').setReadOnly(true);
        form.down('#cityItemId').setReadOnly(true);
        form.down('#mediumOfInstruction').setReadOnly(true);
        form.down('#yearOfExam').setReadOnly(true);
        form.down('#monthItemId').setReadOnly(true);
        form.down('#yearItemId').setReadOnly(true);
        form.down('#resultStatusId').setReadOnly(true);
        this$.viewPersonCommonWindow(form);
        // form.down('#educationDownloadURL').setDisabled(true);
    },
    /**
	 * Edit education history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editEducationHistoryFormWindow: function(informationType, formItemId, gridItemId, isViewMode, personType) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
        	var form = this$.getPersonEducationForm();
        	var records = grid.getSelectionModel().getSelection()[0];
        	var gradeMark=records.get('gradeMark');
        	var marksOrGradeObtained=records.get('marksOrGradeObtained');
        	var campaignSchoolId = form.down('#campaignSchoolId');
        	var educationDepartmentId = form.down('#educationDepartmentId');
        	var cityCombo = form.down('#cityItemId');
        	var educationDepartmentIsOther = false;
        	  if(records.data.isPassMatriculationExemption == true){
               	 form.down("#passMatriculationExemptionId").items.items[0].setValue(true);
               	 form.down("#passMatriculationExemptionId").items.items[1].setValue(false);
         	   }else
         	   {
         		  form.down("#passMatriculationExemptionId").items.items[0].setValue(false);
         		  form.down("#passMatriculationExemptionId").items.items[1].setValue(true);
         	   }
        	if (!isEmpty(records)) {
        		form.loadRecord(records);
        		setTimeout(function(){
        			var educationDepartment = records.get('educationDepartment');
        			var country = records.get('country');
        			var countryRegion = records.get('countryRegion');
        			var passType = records.get('passType');
        			var startYearCurrentOrLastSchoolAttended = records.get('startYearCurrentOrLastSchoolAttended');
        			var startYearAtSchoolHighestQaulificatioAttended = records.get('startYearAtSchoolHighestQaulificatioAttended');
        			var city = records.get('city');
        			var countryId = null;
        			var countryRegionId = null;
        			var cityId = null;
        			
        			if(!isNullOrEmpty(startYearCurrentOrLastSchoolAttended)) {
        				form.down('#yearCurrentLastSchoolAttendedId').setValue(startYearCurrentOrLastSchoolAttended);
        			}
        			
        			if(!isNullOrEmpty(startYearAtSchoolHighestQaulificatioAttended)) {
        				form.down('#startYearOFHighestQualificationId').setValue(startYearAtSchoolHighestQaulificatioAttended);
        			}
        			
        			if(!isNullOrEmpty(passType)){
        				var passTypeId = passType.id;
        				form.down('#passTypeItemId').getStore().load({
    						callback: function(recordss, operation, success) {
    							if (success) {
    								for(i in recordss){
    									if(recordss[i].data.id == passTypeId){
    										form.down('#passTypeItemId').setValue(recordss[i].data.id);
    									}
    								}
    							}
    						}
    					});
        			}
        			
        			if(!isNullOrEmpty(country)){
        				countryId = country.id;
        				form.down('#countryRegionItemId').setDisabled(false);
        				form.down('#countryItemId').getStore().load({
    						callback: function(recordss, operation, success) {
    							if (success) {
    								for(i in recordss){
    									if(recordss[i].data.id == countryId){
    										form.down('#countryItemId').setValue(recordss[i].data.id);
    									}
    								}
    							}
    						}
    					});
        			}
        			if(!isNullOrEmpty(countryRegion)){
        				countryRegionId = countryRegion.id;
        				form.down('#countryRegionItemId').getStore().load({
							params: {
								cid:countryId
							},
							callback: function(regionsRecords, operation, success) {
    							if (success) {
    								if(!isNullOrEmpty(countryRegionId)){
    			        				for(j in regionsRecords){
        									if(regionsRecords[j].data.id == countryRegionId){
        										form.down('#cityItemId').setDisabled(false);
        										form.down('#countryRegionItemId').setValue(regionsRecords[j].data.id);
        										
        									}
    			        				}
    								}
    							}
							}
						});
					}
        			if(!isNullOrEmpty(city)){
						cityId = city.id;
						form.down('#cityItemId').getStore().load({
							params: {
								id:countryRegionId
							},
							callback: function(cityRecords, operation, success) {
								if (success) {
									if(!isNullOrEmpty(cityId)){
									for(k in cityRecords){
										if(cityRecords[k].data.id == cityId){
											form.down('#cityItemId').setValue(cityRecords[k].data.id);
										}
									}
								}
								}
							}
						});
					}
        			
        			if(!isNullOrEmpty(educationDepartment)){
        				if(educationDepartment.value==='Other' || educationDepartment.value==='Others'){
        					educationDepartmentIsOther=true
        					campaignSchoolId.getStore().getProxy().extraParams = {
        						educationDepartmentId: educationDepartment.id,
        						educationDepartmentIsOther:educationDepartmentIsOther,
        						isOthersSchoolReq:true,
        						countryId:countryId,
        						countryRegionId:countryRegionId,
        						cityId:cityId
        					};
        					campaignSchoolId.getStore().reload();
        				}else{
        					educationDepartmentIsOther=false
        					campaignSchoolId.getStore().getProxy().extraParams = {
        						educationDepartmentId: educationDepartment.id,
        						educationDepartmentIsOther:educationDepartmentIsOther,
        						isOthersSchoolReq:true,
        						countryId:countryId,
        						countryRegionId:countryRegionId,
        						cityId:cityId
        					};
        					campaignSchoolId.getStore().reload();
        					form.down('#educationDepartmentId').getStore().load({
        						callback: function(recordss, operation, success) {
        							if (success) {
        								for(i in recordss){
        									if(recordss[i].data.id == educationDepartment.id)
        										form.down('#educationDepartmentId').setValue(recordss[i].data.id);  	
        								}
        							}
        						}
        					});
        				}
        			}
        			else{
        				campaignSchoolId.getStore().getProxy().extraParams = {
    						educationDepartmentId: null,
    						educationDepartmentIsOther:false,
    						isOthersSchoolReq:true,
    						countryId:countryId,
    						countryRegionId:countryRegionId,
    						cityId:cityId
    					};
        			}
        			if(educationDepartmentId.isVisible() && educationDepartment!=null){
        					campaignSchoolId.setDisabled(false);
        			}
        			else if(educationDepartmentId.isVisible()==false){
        				campaignSchoolId.setDisabled(false);
        			}
        			else{
        				campaignSchoolId.setDisabled(true);
        			}
        		},400)

        		setTimeout(function(){
        			setTimeout(function(){
        				form.down('#campaignSchoolId').reset();
        				if(records.data.campaignSchool.value == 'Other' || records.data.campaignSchool.value == 'Others'){
        					records.data.campaignSchool.value = 'Other';
        				}
        				if(records.data.campaignSchool!=null && records.data.campaignSchool.value!='Other'){
        					var schoolField = form.down('#campaignSchoolId');
        					var schoolData = records.data.campaignSchool.id

        					schoolField.getStore().load({
        						callback: function(recordss, operation, success) {
        							if (success) {
        								for(i in recordss){
        									if(recordss[i].data.id == schoolData)
        										if(!isNullOrEmpty(form.down('#campaignSchoolId'))){
        											form.down('#campaignSchoolId').setValue(schoolData);  	
        										}
        								}
        							}
        						}
        					});

        				}
        				if(records.data.campaignSchool!=null && (records.data.campaignSchool.value=='Other' || records.data.campaignSchool.value=='Others')){
        					form.down('#campaignSchoolId').setRawValue('Other');
        					form.down('#instituteNameId').setDisabled(false);
        					form.down('#instituteNameId').setVisible(true);
        				}else{
        					form.down('#instituteNameId').reset();
        					form.down('#instituteNameId').setVisible(false);
        					form.down('#instituteNameId').setDisabled(true);
        				}
        			},200)
        			form.down('#examPassed').setReadOnly(true);
        			form.down('#yearOfExam').setValue(dateRender(records.data.yearOfExam));
        			form.down('#examConductedById').setValue(records.data.examConductedBy);
        			if(!form.down('#examBoard').isVisible()){
        				if(records.raw.examBoard!=null && (records.raw.examBoard.value !='Other' || records.raw.examBoard.value !='Others')){
        					form.down('#examConductedById').reset();
						examBoardOtherValue = false;
        			}
        		}
				var examBoardOtherValue = false;
				var examBoardId = null;
				if(records.raw.examBoard!=null){
					examBoardId = records.raw.examBoard.id;
					if(records.raw.examBoard.value !='Other' || records.raw.examBoard.value !='Others'){
						examBoardOtherValue = false;
					} else {
						examBoardOtherValue = true;
        				}
        			}

        			if(gradeMark=='MARKS'){
        				form.down("#marksObtained").setValue(marksOrGradeObtained);
        			}else{
        				form.down("#gradeObtained").setValue(marksOrGradeObtained);
        			}  
        			var data = records.get("subjectMarkInfo");
        			setTimeout(function(){
        				if (!isEmpty(data)) {
						
						form.down('#subject').getStore().load();
        					for (var i = 0; i < data.length; i++) {
        						var subjectMarkPanel = form.down('#subjectMarkPanel');
        						var formContainer = subjectMarkPanel.getComponent(i);
        						formContainer.down('#subjectId').setValue(data[i].id);
        						formContainer.down('#subjectVersion').setValue(data[i].version);
        						formContainer.down('#subject').setValue(data[i].subject.id);
        						formContainer.down('#marks').setDisabled(false);
        						formContainer.down('#marks').setValue(data[i].marks);
        						formContainer.down('#subMaximumMarks').setDisabled(false);
        						formContainer.down('#subMaximumMarks').setValue(data[i].subMaximumMarks);
        						formContainer.down('#symbolLevelId').setValue(data[i].symbolLevel);
    							formContainer.down('#symbolLevelId').setDisabled(false);
        						formContainer.down('#percentageId').setValue(data[i].percentage);
    						    formContainer.down('#percentageId').setDisabled(false);
    						    
    						    if (!isNullOrEmpty(isViewMode) && isViewMode == true) {
    						    	if(formContainer.down('#symbolLevelId').isVisible()){
    									formContainer.down('#symbolLevelId').setReadOnly(true);
    								}
    								if(formContainer.down('#percentageId').isVisible()){
    									formContainer.down('#percentageId').setReadOnly(true);
    								}
    						    }
    						    
        						if (!isNullOrEmpty(personType) && (personType=='APPLICANT' || personType=='STUDENT') && data[i].subject.code=='Other') {
        							formContainer.down('#otherSubject').setVisible(true);
        							formContainer.down('#otherSubject').allowBlank = false;
        							formContainer.down('#otherSubject').setValue(data[i].otherSubject);
        						}
        						else {
        							formContainer.down('#otherSubject').setVisible(false);
        							formContainer.down('#otherSubject').allowBlank = true;
        						}
        						var assessmentLevelValue = null;
        						if (data[i].assessmentLevel != null && !isNullOrEmpty(personType) && (personType=='APPLICANT'|| personType=='STUDENT')) {
        							assessmentLevelValue = data[i].assessmentLevel;
        						}
        						else {
        							data[i].assessmentLevel = null;
        						}
        						if (i > 0) {
        							if(formContainer.down('#markGradItemId'+i).isVisible()) {
        								formContainer.down('#markGradItemId'+i).setDisabled(false);
        							}
        							if (data[i].conversionMaster != null) {
        								formContainer.down('#markGradItemId'+i).setVisible(true);
        								formContainer.down('#markGradItemId'+i).setDisabled(false);
        								formContainer.down('#markGradItemId'+i).setValue(data[i].conversionMaster.id);
        								var gradeStore = formContainer.down('#markGradItemId'+i).getStore();
        								gradeStore.getProxy().extraParams={
            								examBoardId:examBoardId,
            								assessmentLevel:assessmentLevelValue
            							};
        								gradeStore.load();
        							}
        							if (data[i].assessmentLevel != null) {
        								formContainer.down('#assessmentLevelItemId'+i).setVisible(true);
        								formContainer.down('#markGradItemId'+i).setDisabled(false);
        								formContainer.down('#assessmentLevelItemId'+i).setValue(data[i].assessmentLevel);
        							}
        							var assessmentLevelStore = formContainer.down('#assessmentLevelItemId'+i).getStore();
        							assessmentLevelStore.getProxy().extraParams={
        								examBoardId:examBoardId
        							};
        							assessmentLevelStore.load();
        							if (!isNullOrEmpty(isViewMode) && isViewMode == true) {
        								formContainer.down('#subject').setReadOnly(true);
        								if(formContainer.down('#otherSubject').isVisible()){
        									formContainer.down('#otherSubject').setReadOnly(true);
        								}
        								if(formContainer.down('#subMaximumMarks').isVisible()){
        									formContainer.down('#subMaximumMarks').setReadOnly(true);
        								}
        								if(formContainer.down('#assessmentLevelItemId'+i).isVisible()){
        									formContainer.down('#assessmentLevelItemId'+i).setReadOnly(true);
        								}
        								if(formContainer.down('#markGradItemId'+i).isVisible()){
        									formContainer.down('#markGradItemId'+i).setReadOnly(true);
        								}
        								formContainer.down('#marks').setReadOnly(true);
        							}
        						}else{
        							if(formContainer.down('#markGradItemId').isVisible()){
        								formContainer.down('#markGradItemId').setDisabled(false);
        							}
        							if (data[i].conversionMaster != null) {
        								formContainer.down('#markGradItemId').setVisible(true);
        								formContainer.down('#markGradItemId').setDisabled(false);
        								formContainer.down('#markGradItemId').setValue(data[i].conversionMaster.id);
        								var gradeStore = formContainer.down('#markGradItemId').getStore();
        								gradeStore.getProxy().extraParams={
            								examBoardId:examBoardId,
            								assessmentLevel:assessmentLevelValue
            							};
        								gradeStore.load();
        							}
        							if (data[i].assessmentLevel != null) {
        								formContainer.down('#assessmentLevelItemId').setVisible(true);
        								formContainer.down('#markGradItemId').setDisabled(false);
        								formContainer.down('#assessmentLevelItemId').setValue(data[i].assessmentLevel);
        							}
        							var assessmentLevelStore = formContainer.down('#assessmentLevelItemId').getStore();
        							assessmentLevelStore.getProxy().extraParams={
        								examBoardId:examBoardId
        							};
        							assessmentLevelStore.load();
        						}

        						if (i < (data.length - 1)) {
        							this$.addSubjectMarkContainer(true);
        						}
        						if (!isNullOrEmpty(isViewMode) && isViewMode == true) {
        							if(!isNullOrEmpty(formContainer.down('#btnAddSubjectMarks'+ i))){
        								formContainer.down('#btnAddSubjectMarks'+ i).setVisible(false);	
        							}
        							if (!isNullOrEmpty(formContainer.down('#btnDeleteSubjectMarks'+ i))) {
        								formContainer.down('#btnDeleteSubjectMarks'+ i).setVisible(false);
        							}
        						}
        					}
        					if(!isNullOrEmpty(isViewMode) && isViewMode == true) {
    							form.down('#passType').setReadOnly(true);
    					        form.down('#yearCurrentLastSchoolAttendedId').setReadOnly(true);
    					        form.down('#startYearOFHighestQualificationId').setReadOnly(true);
    						}
        					if(gradeMark=='MARKS'){
        						form.down("#marksObtained").setValue(marksOrGradeObtained);
        					}else{
        						form.down("#gradeObtained").setValue(marksOrGradeObtained);
        					}  
        				} 

        				if(!form.down('#examBoard').isVisible()){
        					this.reloadSubjectStoreAndEnableField();
        					this.restOrReloadFields();
        				}
        				if (!isNullOrEmpty(records.data.filePath)) {
        					var downloadUrl = form.down('#educationDownloadURL');
        					var educationRepeatedSubject = form.down('#educationRepeatedSubjectId');
        					var uploadFileItemId = form.down('#uploadFileItemId');
        					downloadUrl.setValue(records.data.filePath);
        					downloadUrl.setVisible(true);
        					if (educationRepeatedSubject.isVisible()) {
        						uploadFileItemId.setVisible(true);
        						educationRepeatedSubject.items.items[0].setValue(true);
        						uploadFileItemId.allowBlank=true;

        					}
        				}
        			}, 600);
        		},500)
        	}
        	form.getForm().checkValidity();
        } else {
            showWarningMessage(getPersonModuleTranslation('EDUCATION_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
	 * validate admission number for education history record
	 * 
	 * @param form
	 *            education history form
	 * 
	 */
    /*
	 * validateAdmissionCodeForEducationForm: function(form){ var this$ = this;
	 * if(form){ var personProfile = this$.getContentPanelActiveTab(); var
	 * userId = personProfile.getUserId(); var admissionId =
	 * form.down('#enrollmentNumber').getValue(); if (!isNullOrEmpty(userId)) {
	 * Ext.Ajax.request({ type: 'rest', url: SERVERURL.VALIDATE_ADMISSION_CODE,
	 * params: { admissionId: admissionId, studentId: userId }, method: 'GET',
	 * success: function(res, action) {
	 * showSuccessMessage(getCommonTranslation('SUCCESS'),
	 * getPersonModuleTranslation('VALID_ADMISSION_ID')); }, failure:
	 * function(res, action){ form.down('#enrollmentNumber').reset(); } }); } } },
	 */
    /**
	 * Delete education history record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deleteEducationHistoryRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('EDUCATION_HISTORY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,// SERVERURL.EDUCATION_HISTORY_DELETE,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('EDUCATION_HISTORY_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('EDUCATION_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    saveEducationHistory: function(gridItemId, saveUrl, updateUrl, entityType) {
		 var this$ = this;
		 var form = this$.getPersonEducationForm();
		 var uploadFileEducation = form.down('#uploadFileItemId');
		 var educationDocumentPath = uploadFileEducation.getValue();
		 var personObj = this$.getPersonObj();
		 var data = new Object();
		 data.entityId = personObj.id;
		 data.module = entityType;
		 data.entityType = 'educationHistory';
		 form.getForm().setValues(data);
		 var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
		 this$.applyWindowMask(); 
		 if (!isNullOrEmpty(educationDocumentPath)) {
			 form.getForm().submit({
				 method: 'POST',
				 url: uplaodUrl,
				 success: function(form1, action) {
					 var responseData = Ext.decode(action.response.responseText);
					 var path = responseData.path;
					 form.getForm().findField('filePath').setValue(path);
					 this$.saveEducationHistoryRecord(gridItemId, saveUrl, updateUrl);
				 },
				 failure: function() {
					 console.log('hello');
				 }
			 });
		 } else {
			 this$.saveEducationHistoryRecord(gridItemId, saveUrl, updateUrl);
		 }
	 },
    /**
	 * Save education history
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
	 saveEducationHistoryRecord: function(gridItemId, saveUrl, updateUrl, entityType) {

        var this$ = this;
        var form = this$.getPersonEducationForm();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var minimumSubject = form.down('#minimumSubject').getValue();
        var maximumSubject = form.down('#maximumSubject').getValue();
        var formData = form.getValues();
        var subjectCount=0;
        if (!isNullOrEmpty(formData["subject"])) {
        	var subjectArray = Ext.ComponentQuery.query('[name=subject]');
        	if(subjectArray.length>0) {
        		for(var i = 0; i < subjectArray.length; i++){
					if(!isNullOrEmpty(subjectArray[i]) && !isNullOrEmpty(subjectArray[i].getValue())){
						subjectCount+=1;
					}
				}
        	}
        }
        if(!isNullOrEmpty(minimumSubject) && minimumSubject!=0 && subjectCount<minimumSubject) {
        	this$.hideWindowMask();
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_MINIMUM_SUBJECT_COUNT_SHALL_BE')+" : "+minimumSubject);
        } else if(!isNullOrEmpty(maximumSubject) && maximumSubject!=0 && subjectCount>maximumSubject) {
        	this$.hideWindowMask();
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_MAXIMUM_SUBJECT_COUNT_SHALL_BE')+" : "+maximumSubject);
        } else {
        var submitUrl, isUpdate = false;
        var id = form.down('#education_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl;// SERVERURL.EDUCATION_HISTORY_ADD,
            isUpdate = false;
        } else {
            submitUrl = updateUrl;// SERVERURL.EDUCATION_HISTORY_UPDATE,
            isUpdate = true;
        }
        
        
        var jsonFormatFormData = this$.getJsonEducationHistoryData(form);
        var arrayData = [];
        try{
            var jsonFormatFormDataObj = Ext.decode(jsonFormatFormData);
            if(submitUrl==SERVERURL.EDUCATION_HISTORY_ADD || submitUrl==SERVERURL.EDUCATION_HISTORY_UPDATE){
                delete jsonFormatFormDataObj.person.personType;
                jsonFormatFormData = Ext.encode(jsonFormatFormDataObj);
        }
        }
        catch(e){
        	console.log('--');
        }
        
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success,form) {
        		if (isNullOrEmpty(id.getSubmitValue())) {
        		var data = Ext.decode(response.responseText);
        		if(isArray(data)){
        			if(data[0].key == 'EXAM_PASSED_ALREADY_EXISTS') {
        				// showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('EXAM_PASSED_ALREADY_EXISTS'));
        				return false;
        			}
        		}
        		}
        		if(!isNullOrEmpty(response.responseText)) {
        		var data = Ext.decode(response.responseText);
        		if(isArray(data)){
        			if(data[0].key.indexOf('FILL_MANDATORY_SUBJECTS') > -1) {
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILL_MANDATORY_SUBJECTS')+data[0].key.substring(24));
        				return false;
        			}
        		}
        		}
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('EDUCATION_HISTORY'), getPersonModuleTranslation('EDUCATION_HISTORY_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('EDUCATION_HISTORY'), getPersonModuleTranslation('EDUCATION_HISTORY_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
    		}
        });
        }
    },
    /**
	 * show hide student enrollment field
	 */

    showHideStudentEnrollmentField: function(existingStudent, checkValue) {

        var this$ = this;
        var form = this$.getPersonEducationForm();
        if (checkValue) {
            form.down('#enrollmentNumber').setDisabled(false);
            // form.down('#searchButtonId').setDisabled(false);
            
        } else {
            form.down('#enrollmentNumber').setValue('');
            form.down('#enrollmentNumber').setDisabled(true);
            // form.down('#searchButtonId').setDisabled(true);
        }
    },

    /**
	 * validate education form
	 */
    validateEducationForm: function() {

        var this$ = this;
        var form = this$.getPersonEducationForm();
        if (form.getForm().isValid()) {
            form.down('#submitButtonId').setDisabled(false);
        } else {
            form.down('#submitButtonId').setDisabled(true);
        }
    },
    
    /**
	 * after education form render
	 */

    afterEducationFormRender: function() {
        var this$ = this;
        var window = this$.getPersonCommonWindow();
        Ext.apply(window, {
            subjectmarksCount: 0
        });
        var form = this$.getPersonEducationForm();
        form.down('#btnAddSubjectMarks0').on('click', function() {
            this$.addSubjectMarkContainer(false);
        }, form);
        /*
		 * form.down('#btnDeleteSubjectMarks0').on('click',
		 * function(deleteButton) {
		 * this$.deleteSubjectMarkContainer(deleteButton); }, form);
		 */
        var marksObtained = form.down("#marksObtained");
        var maximumMarks = form.down("#maximumMarks");
        marksObtained.setVisible(false);
        maximumMarks.setVisible(false);
    },
    
    
    /*
	 * nonAcademicAchievementsFormRender:function(){ var this$ = this; var form =
	 * this$.getNonAcademicAchievementsForm(); var sportEventStore =
	 * form.down('#sportEvent').getStore();
	 * sportEventStore.getProxy().extraParams={ type:'SportEvent' };
	 * sportEventStore.load();
	 * 
	 * var levelEventStore = personalDetailsForm.down('#levelEvent').getStore();
	 * levelEventStore.getProxy().extraParams={ type:'LevelEvent' };
	 * levelEventStore.load(); },
	 */
    /**
	 * add subject mark container
	 */
    addSubjectMarkContainer: function(editMode) {
        var this$ = this;
        var portalId = this$.getCurrentLoggedPortalId();
        var isMarkGradeVisible = false;
        var window = this$.getPersonCommonWindow();
        var form = this$.getPersonEducationForm();
        var panelContiner = form.down('#subjectMarkPanel');

        var maximumSubject = form.down('#maximumSubject').getValue();
        var formData = form.getValues();
        var subjectCount=0;
        if (!isNullOrEmpty(formData["subject"])) {
        	var subjectArray = Ext.ComponentQuery.query('[name=subject]');
        	subjectCount = subjectArray.length;
        }
        if(!isNullOrEmpty(maximumSubject) && maximumSubject!=0 && subjectCount>=maximumSubject && !isNullOrEmpty(editMode) && editMode==false) {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_MAXIMUM_SUBJECT_COUNT_SHALL_BE')+" : "+maximumSubject);
        } else {
        if(!form.down('#examBoard').isVisible()){
        	this.reloadSubjectStoreAndEnableField();
        }
        var isAssessmentOptional = true;
        if(!isNullOrEmpty(form.down('#isAssessmentLevelVisible').getValue()) && form.down('#isAssessmentLevelVisible').getValue()){
        	isAssessmentOptional = false;
        }
        window.subjectmarksCount += 1;
        var subjectmarksCount = window.subjectmarksCount;
		var indx;
			indx = panelContiner.items.items.length;
       // window.subjectmarksCount += 1;
       // var subjectmarksCount = window.subjectmarksCount;
			var subMarkIsHidden = panelContiner.items.items[0].items.items[4].isHidden();
			var subMarkIsAllowBlank = panelContiner.items.items[0].items.items[4].allowBlank;
        var panelItem = new Array();
        panelItem.push({
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox',
                align: 'bottom'
            },
            items: [{
                xtype: 'hidden',
                itemId: 'subjectId',
                name: 'subjectId'
            }, {
                xtype: 'hidden',
                itemId: 'subjectVersion',
                name: 'subjectVersion'
            }, {
                xtype: 'customcombobox',
                itemId: 'subject',
                fieldLabel: getPersonModuleTranslation('SUBJECT'),
                labelAlign: 'top',
               // hideLabel: true,
                name:'subject',
                width: 226,
                store: 'common.EducationHistorySubjectStore',
                valueField: 'id',
                displayField: 'value',
                typeAhead: false,
                queryParam:'qry',
    			minChars:3,
                // editable: false,
                rowIndx:indx,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            },
    	     listeners:{
				select:function(obj,rec,value){
					var subject=rec[0].get('id');
					var subjectCode=rec[0].get('code');
					var flag = true;
					var subjectMarkPanel = obj.up("#subjectMarkPanel");
					var rowIndx = obj.rowIndx;
					if(!isNullOrEmpty(subjectMarkPanel)){
						subjectMarkPanel.items.each(function(item, index, items) {
							var subjectNameVal = item.down("[name=subject]").getValue();
							if((Ext.ComponentQuery.query('contentpanel')[0].getActiveTab().xtype == 'applicantprofile' || portalId==6 || portalId==3 || portalId==7
									|| Ext.ComponentQuery.query('contentpanel')[0].getActiveTab().xtype == 'studentprofile') && subjectCode=='Other'){
									flag = true;
							}
							else {
							if(subject == subjectNameVal && rowIndx != index){
								flag = false;
								return false;
							}
							}
						});

						if(flag){
 							var marks = obj.up('form').down('#marks');
 							var subMaximumMarks = obj.up('form').down('#subMaximumMarks');
             				if(!isNullOrEmpty(marks)){
             					marks.setDisabled(false);
             					subMaximumMarks.setDisabled(false);
             				}
             				if(!obj.nextSibling().nextSibling().isHidden()){
             					var subject = obj.nextSibling().nextSibling();
             					subject.setDisabled(false);
             					var assessment = subject.nextSibling();
             					assessment.setDisabled(true);
             					var marksField = assessment.nextSibling().nextSibling();
             				}else{
             					if(!obj.nextSibling().nextSibling().nextSibling().isHidden()){
	             					var assessment = obj.nextSibling().nextSibling().nextSibling();
	             					assessment.setDisabled(false);
	             					var subject = assessment.nextSibling();
	             					var marksField = subject.nextSibling();
	             					subject.setDisabled(true);
             					}
             					else {
             						var assessment = obj.nextSibling().nextSibling().nextSibling();
             						var subject = assessment.nextSibling();
	             					var marksField = subject.nextSibling();
	             					subject.setDisabled(false);
             					}
             				}
                        	if(marksField){
                        		marksField.setDisabled(false);
                        		subMaximumMarks.setDisabled(false);
                        	}
                        	var otherSubject = obj.nextSibling();
                        	if((Ext.ComponentQuery.query('contentpanel')[0].getActiveTab().xtype == 'applicantprofile' || portalId==6 || portalId==3 || portalId==7
									|| Ext.ComponentQuery.query('contentpanel')[0].getActiveTab().xtype == 'studentprofile') && subjectCode=='Other'){
                        		otherSubject.setVisible(true);
                        		otherSubject.allowBlank = false;
                        	} else {
                        		otherSubject.reset();
                        		otherSubject.setVisible(false);
                        		otherSubject.allowBlank = true;
                        	}
                        	obj.up('form').getForm().checkValidity();
 						}
 						else{
 							obj.reset();
 							var otherSubject = obj.nextSibling();
 							otherSubject.reset();
 							otherSubject.allowBlank = true;
 							otherSubject.setVisible(false);
 							if(!obj.nextSibling().nextSibling().isHidden()){
 							var nextSiblingField = obj.nextSibling().nextSibling();
 							var equiMarksGrade = nextSiblingField.nextSibling().nextSibling().nextSibling();
 							nextSiblingField.reset();
 							equiMarksGrade.reset();
 							nextSiblingField.setDisabled(true);
 							equiMarksGrade.setDisabled(true);
 							}else{
 								var nextSiblingField = obj.nextSibling().nextSibling().nextSibling();
 	 							nextSiblingField.reset();
 	 							nextSiblingField.setDisabled(true);
 							}
 							var subMaximumMarks = obj.up('form').down('#subMaximumMarks');
 							var subEquiMarksGrade = obj.up('form').down('#marks');
// subMaximumMarks.reset();
// subEquiMarksGrade.reset();
// subMaximumMarks.setDisabled(true);
// subEquiMarksGrade.setDisabled(true);
 							obj.up('form').getForm().checkValidity();
 							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SUBJECT_ALREADY_SELECTED_MSG'));
 							return false;
 						}
					}
				},
			/*
			 * change:function(obj,rec,value){ var nextSiblingField =
			 * obj.nextSibling(); nextSiblingField.reset();
			 * nextSiblingField.setDisabled(true); }
			 */
    	      }
            },{
            	xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('OTHER_SUBJECT'),
                name: 'otherSubject',
                itemId: 'otherSubject',
                maxLength:150,
                labelAlign: 'top',
                // hideLabel: true,
                hidden:true,
                width: 113
            },{
            	xtype: 'numberfield',
            	fieldLabel: getPersonModuleTranslation('MAXIMUM_MARKS'),
            	labelAlign: 'top',
            	itemId: 'subMaximumMarks',
            	name: 'subMaximumMarks',
            	 labelAlign: 'top',
            	// hideLabel: true,
            	disabled: true,
            	hidden:subMarkIsHidden,
            	allowBlank:subMarkIsAllowBlank,
            	width: 113,
            	maxLength:5,
            	keyNavEnabled: false,
            	mouseWheelEnabled: false,
            	hideTrigger: true,
            	minValue:0,
            	validator: function(value){
                	var res = true;
                	var maxMarkvalidText = null;
                	if(this.nextSibling().isHidden()){
                		if(!isNullOrEmpty(this.nextSibling().nextSibling().getValue())){
                			if(!isNullOrEmpty(this.getValue())){
                				if(this.getValue()<this.nextSibling().nextSibling().getValue()){
                				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
                				    res = false;
                				}	
                			}
            			}
                        if(res) {
                            return true;
                        } else {
                        	if(!isNullOrEmpty(maxMarkvalidText)){
                        		return maxMarkvalidText;	
                        	}
                        }
                	}else{
                		return true;
                	}
                }
            }, {
            	xtype: 'nestedJsonCombo',
                itemId: 'assessmentLevelItemId'+subjectmarksCount,
                fieldLabel: getPersonModuleTranslation('ASSESSMENT_LEVEL'),
                labelAlign: 'top',
                width: 113,
                valueField: 'value',
                displayField: 'value',
                name: 'assessmentLevel',
                hidden:true,
                // hideLabel: true,
                allowBlank: false,
                disabled: true,
                store: Ext.create('Academia.store.common.AssessmentLevelStore'),
                editable : false
            }, {
                xtype: 'nestedJsonCombo',
                itemId: 'markGradItemId'+subjectmarksCount,
                fieldLabel: getPersonModuleTranslation('MARKS_GRADE'),
                labelAlign: 'top',
                width: 113,
                valueField: 'id',
                displayField: 'value',
                name: 'conversionMaster',
                hidden:true,
                // hideLabel: true,
                store:Ext.create('Academia.store.common.EducationHistoryGradeStore'),
                editable : false
            } ,{
                xtype: 'textfield',
                itemId: 'marks',
                fieldLabel: getPersonModuleTranslation('EQUIVALENT_MARKS_GRADE'),
                labelAlign: 'top',
                // hideLabel: true,
                allowBlank: false,
                disabled: true,
                width: 113,
                name: 'marks',
                maxLength:7,
                decimalPrecision:2,
                validator: function(value){
                	var validText = getPersonModuleTranslation('MARKS_GRADE_VALID_TYPE');
                	var patt = new RegExp('(^[A-Z]{1}[+]{1}$)|(^[A-Z]{1}[+]{2}$)|(^[A-Z]{1}[-]{1}$)|(^[A-Z]{1}[-]{2}$)|(^[A-Z]{1}[0-9]{1}$)|(^[A-Z]{1}$)|(^[0-9]{1,3}$)|(^[0-9]{1,3}[\.]{1}[0-9]{1,5}$)');
                	var res = patt.test(value);
                	var maxMarkvalidText = null;
                	if(this.previousSibling().isHidden()){
                		if(!isNullOrEmpty(this.previousSibling().previousSibling().getValue())){
                			if(!isNullOrEmpty(this.getValue())){
                				if(this.getValue()>this.previousSibling().previousSibling().getValue()){
                				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
                				    res = false;
                				}	
                			}
            			}
                	}
                    if(res) {
                        return true;
                    } else {
                    	if(!isNullOrEmpty(maxMarkvalidText)){
                    		return maxMarkvalidText;	
                    	}else{
                    		return validText;
                    	}
                    }
                }
            },{
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('SYMBOL_LEVEL'),
                labelAlign: 'top',
                name: 'symbolLevel',
                itemId: 'symbolLevelId',
                disabled: true,
                width: 113,
                maxLength: 1
            },{
            	xtype: 'numberfield',
                fieldLabel: getCommonTranslation('PERCENTAGE'),
                labelAlign: 'top',
                name: 'percent',
                itemId: 'percentageId',
                disabled: true,
                width: 113,
                minLength:0,
                maxLength:5,
                hideTrigger: true,          
                keyNavEnabled: false,       
                mouseWheelEnabled: false,   
                allowExponential: false
            },{
        		xtype : 'button',
        		itemId: 'btnDeleteSubjectMarks' + subjectmarksCount,
        		/*
				 * ui: 'CustomBtnSubmit', tooltip :
				 * getCommonTranslation('DELETE'), glyph : ICONGLYPH.DELETEGLYPH
				 */
        		glyph: ICONGLYPH.DELETEGLYPH,
	   			cls: 'CustomBodyBtnReject',
	   			tooltip: getCommonTranslation('DELETETOOLTIP')
        	}/*
				 * , { xtype : 'button', //ui: 'CustomBtnSubmit', itemId:
				 * 'btnAddSubjectMarks' + subjectmarksCount, tooltip :
				 * getCommonTranslation('ADD'), glyph : ICONGLYPH.ADDGLYPH cls:
				 * 'CustomBodyBtnSettings', text:
				 * getCommonTranslation('ADDBUTTONTEXT'), tooltip:
				 * getCommonTranslation('ADD') }
				 */]
        });

        var subjectMarkPanel = form.down('#subjectMarkPanel');
        subjectMarkPanel.add(panelItem);

        // var examBoardId = form.down('#examBoard').getValue();
        // this$.findExamBoradType(examBoardId,'markGradItemId'+subjectmarksCount,
		// form);
        
        /*
		 * form.down('#btnAddSubjectMarks' + subjectmarksCount).on('click',
		 * function() { this$.addSubjectMarkContainer(); }, form);
		 */
        form.down('#btnDeleteSubjectMarks' + subjectmarksCount).on('click', function(deleteButton) {
            this$.deleteSubjectMarkContainer(deleteButton);
        }, form);
        this$.hideShowSubjectMarksElement(subjectMarkPanel);
// form.fireEvent('validitychange', form);
        window.doLayout();
        // var window = this.getPersonEducationForm();
        var markGradeDropDown = form.down('#isMarkGradVisible').getValue();
        if (markGradeDropDown != null && markGradeDropDown == 'true') {
        	form.down('#markGradItemId'+subjectmarksCount).setVisible(true);
        	var store = form.down('#markGradItemId'+subjectmarksCount).getStore();
        	if(!isNullOrEmpty(form.down('#examBoard').getValue())) {
        		var examBoardId = form.down('#examBoard').getValue();
        		store.getProxy().extraParams = {
    				examBoardId : examBoardId
    			};
    			store.load();
        	}
		}
		var assessmentLevelDropDown = form.down('#isAssessmentLevelVisible').getValue();
        if (assessmentLevelDropDown != null && assessmentLevelDropDown == 'true') {
        	form.down('#markGradItemId'+subjectmarksCount).setDisabled(true);
        	form.down('#assessmentLevelItemId'+subjectmarksCount).setDisabled(true);
        	form.down('#assessmentLevelItemId'+subjectmarksCount).setVisible(true);
        	var store = form.down('#assessmentLevelItemId'+subjectmarksCount).getStore();
        	if(!isNullOrEmpty(form.down('#examBoard').getValue())) {
        		var examBoardId = form.down('#examBoard').getValue();
        		store.getProxy().extraParams = {
    				examBoardId : examBoardId
    			};
    			store.load();
        	}
		}
        }
    },
    /**
	 * add subject mark container
	 */
    deleteSubjectMarkContainer: function(deleteButton) {
        var this$ = this;
        var window = this$.getPersonCommonWindow();
        var form = this$.getPersonEducationForm();
        var subjectMarkPanel = form.down('#subjectMarkPanel');
        var container = deleteButton.up('fieldcontainer');

        if (container != null && subjectMarkPanel != null) {
            if (subjectMarkPanel.items.length > 1) {
                subjectMarkPanel.remove(container);
                this$.hideShowSubjectMarksElement(subjectMarkPanel);
            }
        }
        window.doLayout();
    },
    /**
	 * add subject mark container
	 */
    hideShowSubjectMarksElement: function(subjectMarkPanel) {
        var this$ = this;
        var form = this$.getPersonEducationForm();
        subjectMarkPanel.items.each(function(item, index, items) {
            if (index == 0) {
                var allowblankFalse = ' :<span class="required" style="color:red"> *</span>';
                item.down('#subject').hideLabel = false;
                item.down('#marks').hideLabel = false;
                item.down('#subject').labelSeparator = '';
                item.down('#marks').labelSeparator = '';
                item.down('#subMaximumMarks').hideLabel = false;
                item.down('#subMaximumMarks').labelSeparator = '';
                // item.down('#subject').setFieldLabel(getPersonModuleTranslation('SUBJECT'));
                // item.down('#marks').setFieldLabel(getPersonModuleTranslation('MARKS_GRADE'));
            } else {
                item.down('#subject').hideLabel = true;
                item.down('#marks').hideLabel = true;
                item.down('#subMaximumMarks').hideLabel = true;
            }
            var addButton = item.getComponent(item.items.length - 1);
            if (index == (items - 1)) {
                if (addButton != null) {
                    addButton.show();
                }
            } else {
                if (addButton != null) {
// addButton.hide();
                }
            }

        });
        form.getForm().checkValidity();

    },

    
    getIdJson: function(id) {
    	if (id) return {
    		id: id
    	};
    },
    	
    /**
	 * Get Education History Json for form submission
	 */
getJsonEducationHistoryData: function(form) {
    	
    	var this$ = this;
    	var portalId = this$.getCurrentLoggedPortalId();
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
        	if(isNullOrEmpty(formData['mediumOfInstruction']) || (formData['mediumOfInstruction'].id !== undefined  && formData['mediumOfInstruction'].id == "")){
        		delete formData['mediumOfInstruction']
        	}

        	var personObj = this$.getPersonObj();
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'APPLICANT'){
        		delete personObj.personType;
        	}
        	if(!isNullOrEmpty(personObj.personType) && personObj.personType== 'STUDENT'){
        		delete personObj.personType;
        	}
        	if(Ext.ComponentQuery.query('contentpanel')[0].getActiveTab().xtype != 'applicantprofile' && portalId!=6) {
        		delete formData["resultCapturingMode"];
        	}
            formData.person = personObj;
            var subjectMarkInfo = new Array();
            if (!isNullOrEmpty(formData["subject"])) {
            	if(!isArray(formData["subject"]))
                {
                formData["subject"] = [formData["subject"]];
                }
                var isSubjectArray = isArray(formData["subject"]);
                var isMarksArray = [];
                var isSubMarksArray=[];
                var isSymbolLevelArray = [];
                var isPercentArray = [];
                if(formData["marks"] != undefined) {
                	 if(!isArray(formData["marks"]))
                     {
                     formData["marks"] = [formData["marks"]];
                     }
                	isMarksArray = isArray(formData["marks"]);
                }
                if(formData["subMaximumMarks"] != undefined) {
               	 if(!isArray(formData["subMaximumMarks"]))
                    {
                    formData["subMaximumMarks"] = [formData["subMaximumMarks"]];
                    }
               	isSubMarksArray = isArray(formData["subMaximumMarks"]);
               }
                if(formData["symbolLevel"] != undefined) {
                	if(!isArray(formData["symbolLevel"])) {
                		formData["symbolLevel"] = [formData["symbolLevel"]];
                	}
                	isSymbolLevelArray = isArray(formData["symbolLevel"]);
                }
                if(formData["percent"] != undefined) {
                	if(!isArray(formData["percent"])) {
                		formData["percent"] = [formData["percent"]];
                	}
                	isPercentArray = isArray(formData["percent"]);
                }
                if (isSubjectArray || isMarksArray || isSubMarksArray || isSymbolLevelArray || isPercentArray) {
                    for (var i = 0; i < formData["subject"].length; i++) {
                    	if(!isNullOrEmpty(formData["subject"][i])){
                    		var obj = new Object();
                    		if (isArray(formData["subjectId"]) && formData["subjectId"] != undefined && formData["subjectId"].length > 1) {
                    			 obj.id = formData["subjectId"][i];
                    			 obj.otherSubject = formData["otherSubject"][i];
							}else{
								obj.id = formData["subjectId"];
								obj.otherSubject = formData["otherSubject"];
							}
                            obj.version = formData["subjectVersion"][i];
                            obj.subject = this$.getIdJson(formData["subject"][i]);
                            if(formData["marks"] != undefined){
                            	obj.marks = formData["marks"][i];
                            }
                            if(formData["subMaximumMarks"] != undefined){
                            	obj.subMaximumMarks = formData["subMaximumMarks"][i];
                            }
                            if(formData["symbolLevel"] != undefined){
                            	obj.symbolLevel = formData["symbolLevel"][i];
                            }
                            if(formData["percent"] != undefined){
                            	obj.percentage = formData["percent"][i];
                            }
                            if (!isNullOrEmpty(formData["assessmentLevel"])) {
                            	if(isArray(formData["assessmentLevel"])){
                            		obj.assessmentLevel = formData["assessmentLevel"][i].id;
                            	}else{
                            		obj.assessmentLevel = formData["assessmentLevel"].id;
                            	}
                            }
                            if (!isNullOrEmpty(formData["conversionMaster"])) {
                            	var conversionMasterArray = Ext.ComponentQuery.query('[name=conversionMaster]');
                            	if(!isNullOrEmpty(conversionMasterArray[i]) && !isNullOrEmpty(conversionMasterArray[i].getValue())) {
                            		obj.conversionMaster = this$.getIdJson(conversionMasterArray[i].getValue());
                            	}
                            }
                            	
                            subjectMarkInfo.push(obj);
                    	}
                    }
                } else {
                    var obj = new Object();
                    if(!isNullOrEmpty(formData["subject"])){
                    	obj.id = formData["subjectId"];
                        obj.version = formData["subjectVersion"];
                        obj.subject = this$.getIdJson(formData["subject"][i]);
                        obj.marks = formData["marks"];
                        obj.subMaximumMarks = formData["subMaximumMarks"];
                        obj.otherSubject = formData["otherSubject"];
                        obj.symbolLevel = formData["symbolLevel"];
                        obj.percentage = formData["percent"];
                        if (!isNullOrEmpty(formData["assessmentLevel"]) && !isNullOrEmpty(formData["assessmentLevel"].id)) {
                        	obj.assessmentLevel = formData["assessmentLevel"].id;
                        }
                        if (!isNullOrEmpty(formData["conversionMaster"]) && !isNullOrEmpty(formData["conversionMaster"].id)) {
                        	obj.conversionMaster = formData["conversionMaster"];
                        }
                        subjectMarkInfo.push(obj);
                    }
                }
               
                formData.subjectMarkInfo = subjectMarkInfo;
            }
            if(!isNullOrEmpty(formData.studyMode)) {
            	if(isNullOrEmpty(formData.studyMode.id)) {
            		delete formData.studyMode;
            	}
            }
            if(!isNullOrEmpty(formData.resultStatus)) {
            	if(isNullOrEmpty(formData.resultStatus.id)) {
            		delete formData.resultStatus;
            	}
            }
            
            
            if(isNullOrEmpty(formData.passType)){
            	delete formData.passType;
            }
            if(isNullOrEmpty(formData.startYearCurrentOrLastSchoolAttended)){
            	delete formData.startYearCurrentOrLastSchoolAttended;
            }
            if(isNullOrEmpty(formData.startYearAtSchoolHighestQaulificatioAttended)){
            	delete formData.startYearAtSchoolHighestQaulificatioAttended;
            }
            
            delete formData["subjectId"];
            delete formData["subjectVersion"];
            delete formData["subject"];
            delete formData["marks"];
            delete formData["subMaximumMarks"];
            delete formData["conversionMaster"];
            delete formData["assessmentLevel"];
            delete formData["isAssessmentLevelVisible"];
            delete formData["otherSubject"];
            delete formData["symbolLevel"];
            delete formData["percent"];
        }
        var getYearValue = null;
        var getMonthValue = null;
        
        if( !isNullOrEmpty(formData["yearOfExam"]) ){
        	getYearValue = Ext.Date.format(new Date(formData["yearOfExam"]), 'Y');
        	getMonthValue = parseInt(Ext.Date.format(new Date(formData["yearOfExam"]), 'm'));
        }
    	var fetchMonthValue = this.getMonthArray(getMonthValue);
        var monthofExam = form.down('#monthItemId');
        var yearofExam = form.down('#yearItemId');
        if(monthofExam.isVisible() != true){
        	formData.monthOfExamination = fetchMonthValue;
        }else{
        	formData.monthOfExamination = formData.monthOfExamination.toLocaleUpperCase();
        }
        if(isNullOrEmpty(formData.monthOfExamination)){
            formData.monthOfExamination = null;
        }
        if(yearofExam.isVisible() != true){
        	formData.yearOfExamination = getYearValue;
        }
        if(formData.gradeMark=='MARKS'){
        	formData.marksOrGradeObtained = formData.marksObtained;
        }else{
        	formData.marksOrGradeObtained = formData.gradeObtained;
        }
        if(formData.campaignSchool != undefined && (formData.campaignSchool.id=='Other' ||  formData.campaignSchool.id=='Others')){
        	delete formData.campaignSchool;
        }
        delete formData.gradeObtained;
        delete formData.marksObtained;
        if(formData.isRepeatedSubject==false) {
        	delete formData.filePath;
        }
        delete formData.minimumSubject;
        delete formData.maximumSubject;
        

    	var examBoardVisable= form.down('#examBoard').isVisible();
    	var examBoardid = null;
    	if(!examBoardVisable){
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.EXAM_BOARD_COMBO_STORE,
    			method: 'GET',
    			success: function(res, action) {
    				var data = Ext.decode(res.responseText);
    				for(var i = 0; i < data.length; i++){
    					if(data[i].value == 'Other' || data[i].value == 'Others'){
    						examBoardid=data[i].id
    					}
    				}
    			}
    		});
    		formData.examBoard = this$.getIdValueJson(examBoardid);
    	}
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },

    /**
	 * View work experience history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */

    viewWorkExperienceFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
        this$.editWorkExperienceFormWindow(informationType, formItemId, gridItemId);
        var form = this$.getPersonWorkExperienceForm();
        form.down('#industryItemId').setReadOnly(true);
        form.down('#designation').setReadOnly(true);
        form.down('#workType').setReadOnly(true);
        form.down('#dateOfJoining').setReadOnly(true);
        form.down('#exitDate').setReadOnly(true);
        this$.viewPersonCommonWindow(form);
    },
    /**
	 * Edit work experience history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editWorkExperienceFormWindow: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonWorkExperienceForm();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	if(!isNullOrEmpty(records.data.joiningDate))
            		records.data.joiningDate = new Date(records.data.joiningDate);
            	form.loadRecord(records);
            	
            	var whetherCurrentOrg = records.data.whetherCurrentOrg;
                var currentOrg = form.down('#currentOrgGroupId');
                var exitDate = form.down('#exitDate');
                if(whetherCurrentOrg) {
                	currentOrg.items.items[0].setValue(true);
                	currentOrg.items.items[1].setValue(false);
                	exitDate.setDisabled(true);
                } else {
                	currentOrg.items.items[0].setValue(false);
                	currentOrg.items.items[1].setValue(true);
                	exitDate.setDisabled(false);
                	if(!isNullOrEmpty(records.data.exitDate))
                		exitDate.setValue(dateRender(records.data.exitDate));
                }
                if (!isNullOrEmpty(records.data.industry)) {
                    var industry = form.down('#industryItemId');
                    industry.getStore().load({
                    	callback: function(recordss, operation, success) {
                    		if (success) {
                    			for(i in recordss){
                    				if(recordss[i].data.id == records.data.industry.id)
                    					industry.setValue(recordss[i].data.id);  	
                    			}
                    		}
                    	}
                    });
                    // industry.setValue(records.data.industry.id);
    				}
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('WORK_EXPERIENCE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
	 * Delete work experience history record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deleteWorkExperienceRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('WORK_EXPERIENCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl, // SERVERURL.WORK_EXPERIENCE_DELETE,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('WORK_EXPERIENCE_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('WORK_EXPERIENCE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
	 * Save work experience history
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    saveWorkExperience: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var form = this$.getPersonWorkExperienceForm();
        form.down('#submitButtonId').setDisabled(true);
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        
        var submitUrl, isUpdate = false;
        var id = form.down('#workexp_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl; // SERVERURL.WORK_EXPERIENCE_ADD,
            isUpdate = false;
        } else {
            submitUrl = updateUrl; // SERVERURL.WORK_EXPERIENCE_UPDATE,
            isUpdate = true;
        }
        
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        this$.applyWindowMask(); 
        try{
            var jsonFormatFormDataObj = Ext.decode(jsonFormatFormData);
            if(submitUrl==SERVERURL.WORK_EXPERIENCE_ADD || submitUrl==SERVERURL.WORK_EXPERIENCE_UPDATE){
                delete jsonFormatFormDataObj.person.personType;
                jsonFormatFormData = Ext.encode(jsonFormatFormDataObj);
            }
        }
        catch(e){
        	console.log('--');
        }
        var object=Ext.JSON.decode(jsonFormatFormData);
        if(isNullOrEmpty(object.workType)) {
        	delete object.workType;
        }
        if(isNullOrEmpty(object.industry)){
        	object.industry=null;
        }
        this.sendSaveAjaxRequest(submitUrl, 'POST', JSON.stringify(object), function(option, success, response) {
        	this$.hideWindowMask();
        	
        	if(success){
        	
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('WORK_EXPERIENCE'), getPersonModuleTranslation('WORK_EXPERIENCE_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('WORK_EXPERIENCE'), getPersonModuleTranslation('WORK_EXPERIENCE_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
                form.down('#submitButtonId').setDisabled(false);
    		}
        });
    },
    
    calculateExperience: function(dateField){
        var this$ = this;
        var month;
    	var form = dateField.up('form');
    	
    	var joiningDate = form.down('#dateOfJoining').getValue();
        var exitDate = form.down('#exitDate').getValue();
        
        if(exitDate !=null || exitDate != undefined){
        	month = this.calculateDiffInMonths(joiningDate,exitDate);
        }else if(joiningDate != null){
        	month = this.calculateDiffInMonths(joiningDate,new Date());
        }
        form.down("#durationInMonths").setValue(month);
    },
    
    monthDiff:function(d1, d2) {
    	var months;
    	months = (d2.getFullYear() - d1.getFullYear()) * 12;
    	months += d2.getMonth() - d1.getMonth();
    	return months;
    },
    
    calculateDiffInMonths: function(date1, date2) {
    	if(isNullOrEmpty(date1)) {
    		return 0;
    	}
    	var months = (date2.getFullYear() - date1.getFullYear()) * 12;
    	months -= date1.getMonth();
        months += date2.getMonth();
		if(date1.getDate() > date2.getDate()) {
			months = months -1;
		}
        return months <= 0 ? 0 : months;
    },
     /**
		 * Medical History Details
		 */


    /**
	 * View medical history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    viewMedicalHistoryFormWindow: function(informationType, formItemId, gridItemId) {
        var this$ = this;
        this$.editMedicalHistoryFormWindow(informationType, formItemId, gridItemId);
        var form = this$.getPersonMedicalHistoryForm();
        form.down('#doctorTelephoneCountryCodeItemId').setReadOnly(true);
        form.down('#conditionType').setReadOnly(true);
        form.down('#dateSince').setReadOnly(true);
        this$.viewPersonCommonWindow(form);
    },
    /**
	 * Edit medical history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editMedicalHistoryFormWindow: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonMedicalHistoryForm();
            form.down('#doctorTelephoneCountryCodeItemId').getStore().load();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	if(!isNullOrEmpty(records.data.dateSince))
            		records.data.dateSince = new Date(records.data.dateSince);
                form.loadRecord(records);
            }
            return form;
        } else {
            showWarningMessage(getPersonModuleTranslation('MEDICAL_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            return null;
        }
    },
    /**
	 * Delete medical history record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deleteMedicalHistoryRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('MEDICAL_HISTORY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('MEDICAL_HISTORY_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('MEDICAL_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
	 * Save medical history
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    saveMedicalHistory: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var submitUrl, isUpdate = false;
        
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var form = this$.getPersonMedicalHistoryForm();
        var id = form.down('#medical_hidden_field');
        
        var submitButtonId = form.down('#submitButtonId');
        submitButtonId.setDisabled(true);
        
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl = updateUrl,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        if (!isNullOrEmpty(jsonFormatFormData)) {
        	var json = Ext.decode(jsonFormatFormData);
        	if (!isNullOrEmpty(json.conditionType) && isNullOrEmpty(json.conditionType.id)) {
        		json.conditionType=null;
        		jsonFormatFormData = Ext.encode(json);
        	}
        }
        if(this$.getCurrentLoggedPortalId() == 6) {
        	var json = Ext.decode(jsonFormatFormData);
            this$.applyWindowMask(); 
            delete json.person.personType;
            jsonFormatFormData = Ext.encode(json);
        }
        
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success){
        		 
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('MEDICAL_HISTORY'), getPersonModuleTranslation('MEDICAL_HISTORY_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('MEDICAL_HISTORY'), getPersonModuleTranslation('MEDICAL_HISTORY_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
    		}
        });

    },
    
    /**
	 * Vaccination Details
	 */

    /**
	 * View vaccination history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    viewVaccinationInfoFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
        this$.editVaccinationInfoFormWindow(informationType, formItemId, gridItemId);
        var form = this$.getPersonVaccinationForm();
        this$.viewVaccinationInfoCommonFormWindow(form);
    },
    /**
	 * Edit vaccination history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editVaccinationInfoFormWindow: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonVaccinationForm();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	if(!isNullOrEmpty(records.data.vaccinationDate))
            		records.data.vaccinationDate = new Date(records.data.vaccinationDate);
                form.loadRecord(records);
                if(!isNullOrEmpty(records.data.studentStatus) && !isNullOrEmpty(records.data.studentStatus.id)) {
	                studentStatus = form.down('#studentStatusItemId');
	                if(!isNullOrEmpty(studentStatus)) {
	                	studentStatus.getStore().load({
							  callback:function(){
								  studentStatus.setValue(records.data.studentStatus.id);
							  }
						});
	                }
                }
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('VACCINATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
	 * Delete vaccination history record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deleteVaccinationInfoRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('VACCINATION_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('VACCINATION_DETAILS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('VACCINATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
	 * Save vaccination history
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    saveVaccinationInfo: function(gridItemId, saveUrl, updateUrl, personType) {

        var this$ = this;
        var form = this$.getPersonVaccinationForm();
        form.down('#submitButtonId').setDisabled(true);
        var personProfile = this$.getContentPanelActiveTab();
		var grid="";
		try {
		if(this$.getCurrentLoggedPortalId()==6){
         grid = personProfile.down(gridItemId);
		}else{
        var activeSubTab = personProfile.down('tabpanel').getActiveTab();
         grid = activeSubTab.down('grid');
		}
		}
		catch(e) {
			grid = personProfile.down('grid');
		}
        var submitUrl, isUpdate = false;
        var id = form.down('#vaccination_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl =updateUrl,
            isUpdate = true;
        }
        // var jsonFormatFormData = this$.getJsonSubmitData(form);
        var jsonFormatFormData = this$.getJsonVaccinationInfoData(form, personType);        
        this$.applyWindowMask(); 
       
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	 this$.hideWindowMask();
        	if(success){
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('VACCINATION_DETAILS'), getPersonModuleTranslation('VACCINATION_DETAILS_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('VACCINATION_DETAILS'), getPersonModuleTranslation('VACCINATION_DETAILS_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
                form.down('#submitButtonId').setDisabled(false);
    		}
        });
    },
    
    /**
	 * Get Vaccination Info Json for form submission
	 */
    getJsonVaccinationInfoData: function(form, personType) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var personObj = this$.getPersonObj();
        var formData = form.getValues();
        var vaccinationinfo = new Academia.model.personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentModel();
        if (!isEmpty(formData)) {
        	var person = new Object();
        	person.id = personObj["id"];
            formData.person = person;
            
            // var reportedByUserObj = new Object();
            // reportedByUserObj.id = formData.reportedByUser;
            // formData.reportedByUser = reportedByUserObj;
            var docStore;
            if(form.itemId == 'studentVaccinationForm'){
            	docStore = this$.getStore('personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentStore');
            }
            if(form.itemId == 'facultyVaccinationForm'){
            	docStore = this$.getStore('personinfo.common.vaccinationinfoactivity.EmployeeVaccinationInfoDocumentStore');
            }
            if(form.itemId == 'applicantVaccinationForm'){
            	docStore = this$.getStore('personinfo.common.vaccinationinfoactivity.ApplicantVaccinationInfoDocumentStore');
            }
        	var docArray = [];
        	if (docStore.data.items != null
        			&& docStore.data.items.length > 0) {
        		Ext.each(docStore.data.items, function(val) {
        			var x = val;
        			var newData = {
        					"name" : val.data.documentName,
        					"path" : val.data.path,
        					/* "type" : val.data.type, */
        					"type" : 'DOCUMENT',
        					"id" : val.data.documentId,
        					"createdBy" : this$.getIdValueJson(
        							val.data.createdBy.id,
        							val.data.createdBy.value)
        			};
        			docArray.push(newData);
        		});
        	}
        }
        formData.documents = docArray;
        if(isNullOrEmpty(formData.studentStatus)){
            delete formData.studentStatus;
        }
        
        if(!isNullOrEmpty(personType) && (personType=="APPLICANT" || personType=="FACULTY")) {
            delete formData.studentStatus;
        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    /**
	 * Save PhysicalCharacterirst Info
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    savePhysicalCharInfo: function(gridItemId, saveUrl, updateUrl) {
    	
        var this$ = this;
        var form = this$.getPhysicalcharacteristicsform();
        form.down('#submitButtonId').setDisabled(true);
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#phyChar_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl =updateUrl,
            isUpdate = true;
        }
       
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        var jdata = Ext.decode(jsonFormatFormData);
        delete jdata.person;
        if(isNullOrEmpty(jdata.eyeColor) || jdata.eyeColor==""){
        	delete jdata.eyeColor;
        }
        if(isNullOrEmpty(jdata.hairColor) || jdata.hairColor==""){
        	delete jdata.hairColor;
        }
        jdata.personId=personProfile.personId;
        jsonFormatFormData = Ext.encode(jdata);
        this$.applyWindowMask(); 
       
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	 this$.hideWindowMask();
        	 
        	if(success){
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
                form.down('#submitButtonId').setDisabled(false);
    		}
        });
    },
    /*Student health Information Details  */
    saveStudentHealthInformationDetail: function(gridItemId, saveUrl, updateUrl) {
      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getStudenthealthinformationform();
      form.down('#submitButtonId').setDisabled(true);
          var id = form.down('#health_information_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentHealthInformationHistoryDetailData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DETAILS_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DETAILS_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
  },
  
  



  getJsonStudentHealthInformationHistoryDetailData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      if (!isEmpty(formData)) {
    	  
    	  var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          

          var learningDifficultiesArr = [];
          if(!isNullOrEmpty(formData.learningDifficulties)){
      		if(typeof formData.learningDifficulties == "object"){
          		Ext.each(formData.learningDifficulties, function(learningDifficulties){
                      if(!isNullOrEmpty(learningDifficulties)){
                    	  learningDifficultiesArr.push({'id':learningDifficulties.data.id, value:learningDifficulties.data.value});
                      }
                  });
      		} else{
      			learningDifficultiesArr.push({'id':learningDifficulties.data.id, value:learningDifficulties.data.value});
      		}
      	}
          var allergiesArr = [];
          if(!isNullOrEmpty(formData.allergies)){
        		if(typeof formData.allergies == "object"){
            		Ext.each(formData.allergies, function(allergies){
                        if(!isNullOrEmpty(allergies)){
                        	allergiesArr.push({'id':allergies.data.id, value:allergies.data.value});
                        }
                    });
        		} else{
        			allergiesArr.push({'id':allergies.data.id, value:allergies.data.value});
        		}
        	}
          var medicalConditionsArr = [];
          if(!isNullOrEmpty(formData.medicalConditions)){
        		if(typeof formData.medicalConditions == "object"){
            		Ext.each(formData.medicalConditions, function(medicalConditions){
                        if(!isNullOrEmpty(medicalConditions)){
                        	medicalConditionsArr.push({'id':medicalConditions.data.id, value:medicalConditions.data.value});
                        }
                    });
        		} else{
        			medicalConditionsArr.push({'id':medicalConditions.data.id, value:medicalConditions.data.value});
        		}
        	}
          var medicationArr = [];
          if(!isNullOrEmpty(formData.medication)){
        		if(typeof formData.medication == "object"){
            		Ext.each(formData.medication, function(medication){
                        if(!isNullOrEmpty(medication)){
                        	medicationArr.push({'id':medication.data.id, value:medication.data.value});
                        }
                    });
        		} else{
        			medicationArr.push({'id':medication.data.id, value:medication.data.value});
        		}
        	}
        

          formData.medicalConditionOther = formData.medicalConditionName;
          delete formData.medicalConditionName;
          
          formData.medicationOther = formData.medicationName;
          delete formData.medicationName;
          
          formData.allergiesOther = formData.allergiesName;
          delete formData.allergiesName;
          
          formData.learningDifficultiesOther = formData.learningDifficultiesName;
          delete formData.learningDifficultiesName;
          
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.pasthistory.StudentHealthInformationDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id"   :val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.pasthistory.StudentHealthInformationUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id"   :val.data.id,
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.studentHealthDocument = docArray;
      formData.studentHealthDocumentUrl = urlArray;
      
      
      formData.allergies = allergiesArr;
      formData.learningDifficulties = learningDifficultiesArr;
      formData.medicalConditions = medicalConditionsArr;
      formData.medication = medicationArr;
      
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  saveLearningAllowanceAddDeatails: function(gridItemId, saveUrl, updateUrl){
      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getStudentlearningallowanceaddform();
      form.down('#submitButtonId').setDisabled(true);
          var id = form.down('#learning_allowance_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonLearningAllowanceDetailsData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getPersonModuleTranslation('LEARNING_ALLOWANCES'), getCommonTranslation('LEARNING_ALLOWANCE_UPDATE_SUCCESSFULLY'));
                  } else {
                      showSuccessMessage(getPersonModuleTranslation('LEARNING_ALLOWANCES'), getCommonTranslation('LEARNING_ALLOWANCE_SAVE_SUCCESSFULLY'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
  },
  
  getJsonLearningAllowanceDetailsData: function(form,grid,isUpdate){
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      var form = this$.getStudentlearningallowanceaddform();
      var user=this.getCurrentlyLoggedInUser()
      var record = grid.getSelectionModel().getSelection()[0];
     
     var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
         if(isUpdate==false){
          var learningAllowanceArr = [];
          if(!isNullOrEmpty(formData.learningAllowanceCSMMapping)){
      if(typeof formData.learningAllowanceCSMMapping == "object"){
          Ext.each(formData.learningAllowanceCSMMapping, function(learningAllowance){
                      if(!isNullOrEmpty(learningAllowance)){
                     learningAllowanceArr.push({"learningAllowancesCSM": {'id':learningAllowance.data.id},"learningAllowance": null});
                      }
                  });
      } else{
      learningAllowanceArr.push({"learningAllowancesCSM": {'id':learningAllowance.data.id},"learningAllowance": null});
      }
      }
         
          var appliesToArr = [];
          if(!isNullOrEmpty(formData.appliesTo)){
        if(typeof formData.appliesTo == "object"){
            Ext.each(formData.appliesTo, function(appliesTo){
                        if(!isNullOrEmpty(appliesTo)){
                        appliesToArr.push({"lAAcademyLocation": {'id':appliesTo.data.id},"learningAllowance": null});
                        }
                    });
        } else{
        appliesToArr.push({"lAAcademyLocation": {'id':appliesTo.data.id},"learningAllowance": null});
        }
        }
         }
         else{
             var learningAllowanceArr = [];
             if(!isNullOrEmpty(formData.learningAllowanceCSMMapping)){
          if(typeof formData.learningAllowanceCSMMapping == "object"){
         
              Ext.each(formData.learningAllowanceCSMMapping, function(learningAllowance){
              var flag=false;
                         if(!isNullOrEmpty(learningAllowance)){
                        Ext.each(record.data.learningAllowanceCSMMapping, function(learningAllowanceCSMMapping){
                            if(learningAllowance==learningAllowanceCSMMapping.learningAllowancesCSM.id){
                           
                            learningAllowanceArr.push({
                                  "id":learningAllowanceCSMMapping.id,
                                  "learningAllowancesCSM" : {
                                      "id":learningAllowance
                                      },"learningAllowance" : {
                                      "id":learningAllowanceCSMMapping.learningAllowance.id
                                      }
                                  });
                        flag=true;
                            }
                        });
                        }
             if(flag==false){

learningAllowanceArr.push({"learningAllowancesCSM": {'id':learningAllowance.data.id},"learningAllowance": null});

            }                
});
          }
          }
             
             var appliesToArr = [];
             if(!isNullOrEmpty(formData.appliesTo) && formData.appliesTo!='' ){
          if(typeof formData.appliesTo == "object"){
         
              Ext.each(formData.appliesTo, function(learningAllowance){
              var flag=false;
                          if(!isNullOrEmpty(learningAllowance)){
                          Ext.each(record.data.appliesTo, function(appliesTo){
                              if(learningAllowance==appliesTo.lAAcademyLocation.id){
                              appliesToArr.push({
                                  "id":appliesTo.id,
                                  "lAAcademyLocation" : {
                                      "id":learningAllowance
                                      },"learningAllowance" : {
                                      "id":appliesTo.learningAllowance.id
                                      }
                                  })
                                 
                      flag=true;
                              }
                          });
                         }
                     if(flag==false){
 
                appliesToArr.push({"lAAcademyLocation": {'id':learningAllowance.data.id},"learningAllowance": null});
 
                     }                
                  });
          }
          }
            }
     
          delete formData.pageSize;
          delete formData.customData;
     
     
      formData.learningAllowanceCSMMapping = learningAllowanceArr;
	  if(!isNullOrEmpty(formData.grantedby) && formData.grantedby!='' ){
      formData.grantedby = {"id": formData.grantedby};
	  }else{
		delete formData.grantedby;
	  }
	  if(appliesToArr.length!=0){
      formData.appliesTo = appliesToArr;
	  }
      formData.accountType = {"id": formData.ALID};
      delete formData.ALID;
     
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },

  deleteStudentHealthInformationDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                          var ids = [];
                          Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl +'?ids='+ids.join(),
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              success: function(form, action) {
                            	  flag=true;
                                }
                          });
                      if(flag) {
                      grid.getSelectionModel().deselectAll();
                      grid.getStore().reload();
                      showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DELETE_SUCCESS')); 
                    	  }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  deleteStudentLearningAllowance:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getPersonModuleTranslation('LEARNING_ALLOWANCES'), getCommonTranslation('LEARNING_ALLOWANCES_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                          var ids = [];
                          Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl +'?ids='+ids.join(),
                              async:false,
                              method: 'DELETE',
	                        	headers: {
	                        		'Content-Type': 'application/json'
	                        	},
	                        	params: {
	                        		ids: ids.join()
	                        	},
                              success: function(form, action) {
                            	  flag=true;
                                }
                          });
                      if(flag) {
                      grid.getSelectionModel().deselectAll();
                      grid.getStore().reload();
                      showSuccessMessage(getPersonModuleTranslation('LEARNING_ALLOWANCES'), getCommonTranslation('LEARNING_ALLOWANCES_DELETE_SUCCESS')); 
                    	  }
                  }
              }
          });
      } else {
          showWarningMessage(getPersonModuleTranslation('LEARNING_ALLOWANCES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  viewStudentHealthInformation:function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editHealthInformationDetailWindow(informationType, formItemId, gridItemId, true);
	      var form = this$.getStudenthealthinformationform();
	      form.down('#healthDocument').setVisible(false);
	      form.down('#healthDocumentUrl').setVisible(false);
	      var studentHealthInformationDocGrid = form.down('#studenthealthinformationdocumentgrid');
	      var studentHealthInformationUrlGrid = form.down('#studenthealthinformationurlgrid');
	      studentHealthInformationDocGrid.down('#btnDelete').setDisabled(true);
	      studentHealthInformationUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonHealthInformationWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_HEALTH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  editStudentLearningAllowanceFormWindow: function(informationType, formItemId, gridItemId, isViewMode){
  	var this$ = this;
	var personProfile = this$.getContentPanelActiveTab();
	var grid = personProfile.down(gridItemId);

	if (grid.getSelectionModel().getCount() > 0) {
		this.showPersonCommonWindow(informationType, formItemId);
		var form = this$.getStudentlearningallowanceaddform();
		var records = grid.getSelectionModel().getSelection()[0];
		if (!isEmpty(records)) {
			//form.loadRecord(records);
        	form.down('#learning_allowance_Details_hidden_field').setValue(records.data.id);
			var learningAllowances=form.down('#learningAllowancesItemId');
			var learningAllowancesArray=new Array();
			for(var i in records.data.learningAllowanceCSMMapping){
				var id=records.data.learningAllowanceCSMMapping[i].learningAllowancesCSM.id;
				learningAllowancesArray.push(id);
			}
			learningAllowances.getStore().load({
				callback:function(){
					learningAllowances.setValue(learningAllowancesArray);
				}
			});

			
			var appliesTo=form.down('#appliesToItemId');
			var appliesToArray=new Array();
			for(var i in records.data.appliesTo){
				var id=records.data.appliesTo[i].lAAcademyLocation.id;
				appliesToArray.push(id);
			}
			appliesTo.getStore().load({
				callback:function(){
					appliesTo.setValue(appliesToArray);
				}
			});

			var descriptionOther = form.down('#descriptionOtherItemId');
    		if(!isNullOrEmpty(records.data.description)){
    			descriptionOther.setValue(records.data.description); 
    		}
    		
    		var validForm = form.down('#validForm');
    		if(!isNullOrEmpty(records.data.validForm)){
    			var timestamp = records.data.validForm;
    			var date = Ext.Date.format(new Date(timestamp),'Y-m-d');
    			validForm.setValue(date); 
    		}
    		
    		var grantedBy = form.down('#grantedByItemId');
    		if(!isNullOrEmpty(records.data.grantedby.value)){
    			
                var loggedInUserId = this.getCurrentlyLoggedInUser().id;
                grantedBy.getStore().getProxy().extraParams = {
                    id: this.getCurrentAcademyLocation()
              };
                grantedBy.getStore().load({
                     callback: function(record, operation, success) {
                         if (success) {
                             for(var i in record){
                                    if(record[i].data.id==records.data.grantedby.id){
                                    	grantedBy.setValue(records.data.grantedby.id);
                                    }
                                } }
                          }});
    		}

		} 
	}else {
		showWarningMessage(getPersonModuleTranslation('LEARNING_ALLOWANCES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
},
  
  editHealthInformationDetailWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(informationType, formItemId);
      	var formWindow = this$.getPersonCommonWindow();
      	if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		formWindow.setTitle(getCommonTranslation('VIEW_HEALTH_INFORMATION'));
      	}else{
      		formWindow.setTitle(getCommonTranslation('EDIT_HEALTH_INFORMATION'));
      	}
      	  var form = this$.getStudenthealthinformationform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#health_information_Details_hidden_field').setValue(records.data.id);
        		
    		var medicalConditions = form.down('#medicalConditionsItemId');
    		if(!isNullOrEmpty(records.data.medicalConditions)) {
    			var medicalConditionsArray = []
    			medicalConditions.getStore().load({
                	callback: function(recordss, operation, success) {
                		if (success) {
                			if(recordss.length > 0){
                				records.data.medicalConditions.forEach(function(item){
    								var result = recordss.filter(function (obj) {
    									  return obj.data.id === item.id;
    									})[0];
    								medicalConditionsArray.push(result);
    							});
    							medicalConditions.setValue(medicalConditionsArray);
    						}
                		}
                	}
                });      		
    		}
    		
    		var medicalConditionName = form.down("#medicalConditionName");
    		if(!isNullOrEmpty(records.data.medicalConditionOther)){
    			medicalConditionName.setValue(records.data.medicalConditionOther); 
//    			records.data.medicalConditionName = records.data.medicalConditionOther
    		}
    		
    		var medication = form.down('#medicationItemId');
    		if(!isNullOrEmpty(records.data.medication)) {
    			var medicationArray = [];
    			medication.getStore().load({
                	callback: function(recordss, operation, success) {
                		if (success) {
                			if(recordss.length > 0){
                				records.data.medication.forEach(function(item){
    								var result = recordss.filter(function (obj) {
    									  return obj.data.id === item.id;
    									})[0];
    								medicationArray.push(result);
    							});
                				medication.setValue(medicationArray);
    						}
                		}
                	}
                });      		
    		}
    		
    		var medicationName = form.down("#medicationName");
    		if(!isNullOrEmpty(records.data.medicationOther)) {
    			medicationName.setValue(records.data.medicationOther);   
//    			records.data.medicationName = records.data.medicationOther
    		}
    		
    		var allergies = form.down('#allergiesItemId');
    		if(!isNullOrEmpty(records.data.allergies)) {
    			var allergiesArray = [];
    			allergies.getStore().load({
                	callback: function(recordss, operation, success) {
                		if (success) {
                			if(recordss.length > 0){
                				records.data.allergies.forEach(function(item){
    								var result = recordss.filter(function (obj) {
    									  return obj.data.id === item.id;
    									})[0];
    								allergiesArray.push(result);
    							});
                				allergies.setValue(allergiesArray);
    						}
                		}
                	}
                });      		
    		}
    		
    		var allergiesName = form.down("#allergiesName");
    		if(!isNullOrEmpty(records.data.allergiesOther)) {
    			allergiesName.setValue(records.data.allergiesOther);    			
    		}
    		
    		var learningDifficulties = form.down('#learningDifficultiesItemId');
    		if(!isNullOrEmpty(records.data.learningDifficulties)) {
    			var learningDifficultiesArray = [];
    			learningDifficulties.getStore().load({
                	callback: function(recordss, operation, success) {
                		if (success) {
                			if(recordss.length > 0){
                				records.data.learningDifficulties.forEach(function(item){
    								var result = recordss.filter(function (obj) {
    									  return obj.data.id === item.id;
    									})[0];
    								learningDifficultiesArray.push(result);
    							});
                				learningDifficulties.setValue(learningDifficultiesArray);
    						}
                		}
                	}
                });    
    		}
    		
    		var learningDifficultiesName = form.down("#learningDifficultiesName");
    		if(!isNullOrEmpty(records.data.learningDifficultiesOther)) {
    			learningDifficultiesName.setValue(records.data.learningDifficultiesOther);   			
    		}
    		
    		
    		form.loadRecord(records);
          }
      } else {
          showWarningMessage(getPersonModuleTranslation('VIEW_HEALTH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  viewStudentLearningAllowance:function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var records = grid.getSelectionModel().getSelection()[0];
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editStudentLearningAllowanceFormWindow(informationType, formItemId, gridItemId, true);
	      var form = this$.getStudentlearningallowanceaddform();
	      form.down("#learningAllowancesItemId").setReadOnly(true);
	      form.down("#validForm").setReadOnly(true);
	      form.down("#accountTypeItemId").setReadOnly(true);
	      form.down("#grantedByItemId").setReadOnly(true);
	      form.down("#appliesToItemId").setReadOnly(true);
	    var dateModified=  form.down("#dateModified");
		if(!isNullOrEmpty(records.data.validForm)){
			var timestamp = records.data.dateModified;
			var date = Ext.Date.format(new Date(timestamp),'Y-m-d');
			dateModified.setValue(date); 
		}
	      this$.viewPersonCommonWindow(form);
	      form.isValid();
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_LEARNING_ALLOWANCES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  /*Applicant health Information Details  */
  saveApplicantHealthInformationDetail: function(gridItemId, saveUrl, updateUrl) { 
    var this$ = this;
    var isValid = true;
    var submitUrl, isUpdate = false;
    var personProfile = this$.getContentPanelActiveTab();
    var grid = personProfile.down(gridItemId);
    var form = this$.getStudenthealthinformationform();
    form.down('#submitButtonId').setDisabled(true);
        var id = form.down('#health_information_Details_hidden_field');
        if (!isNullOrEmpty(id.getSubmitValue())) {
        	submitUrl = updateUrl,
            isUpdate = true;
        } else {
        	submitUrl = saveUrl,
            isUpdate = false;       
        }
        var jsonFormatFormData = this$.getJsonApplicantHealthInformationHistoryDetailData(form,grid,isUpdate);
        this$.applyWindowMask(); 
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
            this$.hideWindowMask();
            if(success){
                this$.closePersonCommonWindow();
                if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                	try{
                		personId = this$.getPersonObj().id;
                		if(isNullOrEmpty(personId)){
                			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                		}
                	}
                	catch(e){
                		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                	}
                	grid.getStore().getProxy().extraParams = {
                		personId : personId
                	};
                }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DETAILS_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DETAILS_ADD_SUCCESS'));
                }
            }else{
                this$.hideWindowMask();
                this$.closePersonCommonWindow();
                grid.getStore().reload();
                form.down('#submitButtonId').setDisabled(false);
            }
        });
},

  getJsonApplicantHealthInformationHistoryDetailData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      var user=this.getCurrentlyLoggedInUser()
      if(isUpdate) {
	     var record = grid.getSelectionModel().getSelection();
	     formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
       } else {                        
	        formData.auditId = this$.getIdValueJson(user.id);
       }
      if (!isEmpty(formData)) {
    	  
    	  var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          

          var learningDifficultiesArr = [];
          if(!isNullOrEmpty(formData.learningDifficulties)){
      		if(typeof formData.learningDifficulties == "object"){
          		Ext.each(formData.learningDifficulties, function(learningDifficulties){
                      if(!isNullOrEmpty(learningDifficulties)){
                    	  learningDifficultiesArr.push({'id':learningDifficulties.data.id, value:learningDifficulties.data.value});
                      }
                  });
      		} else{
      			learningDifficultiesArr.push({'id':learningDifficulties.data.id, value:learningDifficulties.data.value});
      		}
//      		if(!isNullOrEmpty(intakeYearArray) && intakeYearArray.length>0 && !isNullOrEmpty(intakeYearArray[0])) {
//      			obj.intakeYearIds = intakeYearArray;
//      		}
      	}
          var allergiesArr = [];
          if(!isNullOrEmpty(formData.allergies)){
        		if(typeof formData.allergies == "object"){
            		Ext.each(formData.allergies, function(allergies){
                        if(!isNullOrEmpty(allergies)){
                        	allergiesArr.push({'id':allergies.data.id, value:allergies.data.value});
                        }
                    });
        		} else{
        			allergiesArr.push({'id':allergies.data.id, value:allergies.data.value});
        		}
//        		if(!isNullOrEmpty(intakeYearArray) && intakeYearArray.length>0 && !isNullOrEmpty(intakeYearArray[0])) {
//        			obj.intakeYearIds = intakeYearArray;
//        		}
        	}
          var medicalConditionsArr = [];
          if(!isNullOrEmpty(formData.medicalConditions)){
        		if(typeof formData.medicalConditions == "object"){
            		Ext.each(formData.medicalConditions, function(medicalConditions){
                        if(!isNullOrEmpty(medicalConditions)){
                        	medicalConditionsArr.push({'id':medicalConditions.data.id, value:medicalConditions.data.value});
                        }
                    });
        		} else{
        			medicalConditionsArr.push({'id':medicalConditions.data.id, value:medicalConditions.data.value});
        		}
//        		if(!isNullOrEmpty(intakeYearArray) && intakeYearArray.length>0 && !isNullOrEmpty(intakeYearArray[0])) {
//        			obj.intakeYearIds = intakeYearArray;
//        		}
        	}
          var medicationArr = [];
          if(!isNullOrEmpty(formData.medication)){
        		if(typeof formData.medication == "object"){
            		Ext.each(formData.medication, function(medication){
                        if(!isNullOrEmpty(medication)){
                        	medicationArr.push({'id':medication.data.id, value:medication.data.value});
                        }
                    });
        		} else{
        			medicationArr.push({'id':medication.data.id, value:medication.data.value});
        		}
//        		if(!isNullOrEmpty(intakeYearArray) && intakeYearArray.length>0 && !isNullOrEmpty(intakeYearArray[0])) {
//        			obj.intakeYearIds = intakeYearArray;
//        		}
        	}
        
          if(!isNullOrEmpty(formData.medicalConditionName)){
        	  formData.medicalConditionOther = formData.medicalConditionName;
        	  delete formData.medicalConditionName;
          }else{
        	  formData.medicalConditionOther = form.down('#medicalConditionName').getValue();
          }
          
          if(!isNullOrEmpty(formData.medicationName)){
        	  formData.medicationOther = formData.medicationName;
              delete formData.medicationName;
          }else{
        	  formData.medicationOther = form.down('#medicationName').getValue();
          }
          
          if(!isNullOrEmpty(formData.allergiesName)){
        	  formData.allergiesOther = formData.allergiesName;
              delete formData.allergiesName;
          }else{
        	  formData.allergiesOther = form.down('#allergiesName').getValue();
          }
          
          if(!isNullOrEmpty(formData.learningDifficultiesName)){
        	  formData.learningDifficultiesOther = formData.learningDifficultiesName;
              delete formData.learningDifficultiesName;
          }else{
        	  formData.learningDifficultiesOther = form.down('#learningDifficultiesName').getValue();
          }
          
         
          
          delete formData.pageSize;
          delete formData.customData;
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.pasthistory.ApplicantHealthInformationDocumentGridStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id"   :val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.pasthistory.ApplicantHealthInformationUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id"   :val.data.id,
                  };
                  urlArray.push(newData);
              });
          }
      }
      formData.applicantHealthDocument = docArray;
      formData.applicantHealthDocumentUrl = urlArray;
      
      
      formData.allergies = allergiesArr;
      formData.learningDifficulties = learningDifficultiesArr;
      formData.medicalConditions = medicalConditionsArr;
      formData.medication = medicationArr;
      
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  editApplicantHealthInformationDetailFormWindow: function(informationType, formItemId, gridItemId, isViewMode) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);

      if (grid.getSelectionModel().getCount() > 0) {
      	this$.showPersonCommonWindow(informationType, formItemId);
      	var formWindow = this$.getPersonCommonWindow();
      	if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
      		formWindow.setTitle(getCommonTranslation('VIEW_HEALTH_INFORMATION'));
      	}else{
      		formWindow.setTitle(getCommonTranslation('EDIT_HEALTH_INFORMATION'));
      	}
      	
//      	setTimeout(function(){
      		var form = this$.getStudenthealthinformationform();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
	          	form.down('#health_information_Details_hidden_field').setValue(records.data.id);
	          		
	      		var medicalConditions = form.down('#medicalConditionsItemId');
	      		if(!isNullOrEmpty(records.data.medicalConditions)) {
	      			var medicalConditionsArray = []
	      			medicalConditions.getStore().load({
	                  	callback: function(recordss, operation, success) {
	                  		if (success) {
	                  			if(recordss.length > 0){
	                  				records.data.medicalConditions.forEach(function(item){
	      								var result = recordss.filter(function (obj) {
	      									  return obj.data.id === item.id;
	      									})[0];
	      								medicalConditionsArray.push(result);
	      							});
	      							medicalConditions.setValue(medicalConditionsArray);
	      						}
	                  		}
	                  	}
	      			});      		
	      		}
	      		
	      		var medicalConditionName = form.down("#medicalConditionName");
	      		if(!isNullOrEmpty(records.data.medicalConditionOther)){
	      			medicalConditionName.setValue(records.data.medicalConditionOther);    			
	//      			records.data.medicalConditionName = records.data.medicalConditionOther
	      		}
	      		
	      		var medication = form.down('#medicationItemId');
	      		if(!isNullOrEmpty(records.data.medication)) {
	      			var medicationArray = [];
	      			medication.getStore().load({
	                  	callback: function(recordss, operation, success) {
	                  		if (success) {
	                  			if(recordss.length > 0){
	                  				records.data.medication.forEach(function(item){
	      								var result = recordss.filter(function (obj) {
	      									  return obj.data.id === item.id;
	      									})[0];
	      								medicationArray.push(result);
	      							});
	                  				medication.setValue(medicationArray);
	      						}
	                  		}
	                  	}
	                  });      		
	      		}
	      		
	      		var medicationName = form.down("#medicationName");
	      		if(!isNullOrEmpty(records.data.medicationOther)) {
	      			medicationName.setValue(records.data.medicationOther);   
	//      			records.data.medicationName = records.data.medicationOther
	      		}
	      		
	      		var allergies = form.down('#allergiesItemId');
	      		if(!isNullOrEmpty(records.data.allergies)) {
	      			var allergiesArray = [];
	      			allergies.getStore().load({
	                  	callback: function(recordss, operation, success) {
	                  		if (success) {
	                  			if(recordss.length > 0){
	                  				records.data.allergies.forEach(function(item){
	      								var result = recordss.filter(function (obj) {
	      									  return obj.data.id === item.id;
	      									})[0];
	      								allergiesArray.push(result);
	      							});
	                  				allergies.setValue(allergiesArray);
	      						}
	                  		}
	                  	}
	                  });      		
	      		}
	      		
	      		var allergiesName = form.down("#allergiesName");
	      		if(!isNullOrEmpty(records.data.allergiesOther)) {
	      			allergiesName.setValue(records.data.allergiesOther);    			
	      		}
	      		
	      		var learningDifficulties = form.down('#learningDifficultiesItemId');
	      		if(!isNullOrEmpty(records.data.learningDifficulties)) {
	      			var learningDifficultiesArray = [];
	      			learningDifficulties.getStore().load({
	                  	callback: function(recordss, operation, success) {
	                  		if (success) {
	                  			if(recordss.length > 0){
	                  				records.data.learningDifficulties.forEach(function(item){
	      								var result = recordss.filter(function (obj) {
	      									  return obj.data.id === item.id;
	      									})[0];
	      								learningDifficultiesArray.push(result);
	      							});
	                  				learningDifficulties.setValue(learningDifficultiesArray);
	      						}
	                  		}
	                  	}
	                  });    
	      		}
	      		
	      		var learningDifficultiesName = form.down("#learningDifficultiesName");
	      		if(!isNullOrEmpty(records.data.learningDifficultiesOther)) {
	      			learningDifficultiesName.setValue(records.data.learningDifficultiesOther);   			
	      		}
	      		
	      		
	      		form.loadRecord(records);
            }
//      	},1000);
      } else {
          showWarningMessage(getPersonModuleTranslation('VIEW_HEALTH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
    
  
  viewApplicantHealthInformationDetailFormWindow: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editApplicantHealthInformationDetailFormWindow(informationType, formItemId, gridItemId,true);
//	      setTimeout(function(){
	      var form = this$.getStudenthealthinformationform();
	      form.down('#healthDocument').setVisible(false);
	      form.down('#healthDocumentUrl').setVisible(false);
	      var applicanthealthinformationdocumentgrid = form.down('#applicanthealthinformationdocumentgrid');
	      var applicanthealthinformationurlgrid = form.down('#applicanthealthinformationurlgrid');
	      applicanthealthinformationdocumentgrid.down('#btnDelete').setDisabled(true);
	      applicanthealthinformationurlgrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonHealthInformationWindow(form);
//	      },1000);
      } else {
    	  showWarningMessage(getCommonTranslation('VIEW_HEALTH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  deleteApplicantHealthInformationDetail:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                          var ids = [];
                          Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl +'?ids='+ids.join(),
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              success: function(form, action) {
                            	  flag=true;
                                }
                          });
                      if(flag) {
                      grid.getSelectionModel().deselectAll();
                      grid.getStore().reload();
                      showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('HEALTH_INFORMATION_DELETE_SUCCESS')); 
                    	  }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('HEALTH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  



    /*Student Education History Details  */

    saveStudentEducationHistoryDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getEducationhistorydetailform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#education_history_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonStudentEducationHistoryDetailData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('STUDENT_EDUCATION_DETAILS_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('STUDENT_EDUCATION_DETAILS_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
  },
  getJsonStudentEducationHistoryDetailData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      if (!isEmpty(formData)) {
          var person = new Object();
          person.id = personObj["id"];
          formData.person = person;
          delete formData.pageSize;
          delete formData.customData;
          
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.pasthistory.StudentEducationHistoryDocumentStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id"   : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.pasthistory.StudentEducationHistoryUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id"   : val.data.id,
                  };
                  urlArray.push(newData);
              });
          }

      }
      formData.graduationDocument = docArray;
      formData.graduationDocumentUrl = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  
  editStudentEducationHistoryDetailFormWindow: function(informationType, formItemId, gridItemId) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
     
      if (grid.getSelectionModel().getCount() > 0) {
      	  this$.showPersonCommonWindow(informationType, formItemId);
      	  var form = this$.getEducationhistorydetailform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#education_history_Details_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.graduationDate))
          		records.data.graduationDate = new Date(records.data.graduationDate);
          	
          	var nameOfInstitutionsAttended = form.down("#nameOfInstitutionsAttended");
            if(!isNullOrEmpty(records.data.nameOfInstitutionsAttended))
            	nameOfInstitutionsAttended.setValue(records.data.nameOfInstitutionsAttended);
          	 
          	var highestQualification = form.down("#highestQualification");
            if(!isNullOrEmpty(records.data.highestQualification))
            	highestQualification.setValue(records.data.highestQualification);
            
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  viewStudentEducationHistoryDetailFormWindow: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editStudentEducationHistoryDetailFormWindow(informationType, formItemId, gridItemId);
	      var form = this$.getEducationhistorydetailform();
	      form.down("#graduationDate").setReadOnly(true);
	      form.down('#graduationDocument').setVisible(false);
	      form.down('#graduationDocumentUrl').setVisible(false);
	      var studentEducationHistoryDocumentGrid = form.down('#studenteducationhistorydocumentgrid');
	      var studentEducationHistoryUrlGrid = form.down('#studenteducationhistoryurlgrid');
	      studentEducationHistoryDocumentGrid.down('#btnDelete').setDisabled(true);
	      studentEducationHistoryUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  deleteStudentEducationHistoryDetailRecord:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_EDUCATION_DETAILS'), getCommonTranslation('EDUCATION_DETAILS_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                          var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl,
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              params: {
                              	id: id
                              },
                              success: function(form, action) {
                            	  flag=true;
                              }
                          });
                      }
                      if(flag) {
                          grid.getStore().reload();
                          showSuccessMessage(getCommonTranslation('DELETE_EDUCATION_DETAILS'), getCommonTranslation('EDUCATION_DETAILS_DELETE_SUCCESS'));
                      }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_EDUCATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  /*Applicant Education History Details  */
  saveApplicantEducationHistoryDetail: function(gridItemId, saveUrl, updateUrl) {

      var this$ = this;
      var isValid = true;
      var submitUrl, isUpdate = false;

      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      var form = this$.getEducationhistorydetailform();
      form.down('#submitButtonId').setDisabled(true);

          var id = form.down('#education_history_Details_hidden_field');
          if (!isNullOrEmpty(id.getSubmitValue())) {
          	submitUrl = updateUrl,
              isUpdate = true;
          } else {
          	submitUrl = saveUrl,
              isUpdate = false;       
          }
          var jsonFormatFormData = this$.getJsonApplicantEducationHistoryDetailData(form,grid,isUpdate);
          this$.applyWindowMask(); 
          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
              this$.hideWindowMask();
              if(success){
                  this$.closePersonCommonWindow();
                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                  	try{
                  		personId = this$.getPersonObj().id;
                  		if(isNullOrEmpty(personId)){
                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  		}
                  	}
                  	catch(e){
                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                  	}
                  	grid.getStore().getProxy().extraParams = {
                  		personId : personId
                  	};
                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                  grid.getStore().reload();
                  grid.getSelectionModel().deselectAll();
                  if (isUpdate) {
                      showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('STUDENT_EDUCATION_DETAILS_UPDATE_SUCCESS'));
                  } else {
                      showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('STUDENT_EDUCATION_DETAILS_ADD_SUCCESS'));
                  }
              }else{
                  this$.hideWindowMask();
                  this$.closePersonCommonWindow();
                  grid.getStore().reload();
                  form.down('#submitButtonId').setDisabled(false);
              }
          });
  },
  getJsonApplicantEducationHistoryDetailData: function(form,grid,isUpdate) { 
      var this$ = this;
      var jsonFormFieldData = new Object();
      var personObj = this$.getPersonObj();
      var formData = form.getValues();
      if (!isEmpty(formData)) {
    	  var applicantPerson = new Object();
          applicantPerson.id = personObj["id"];
          formData.applicantPerson = applicantPerson;
          delete formData.pageSize;
          delete formData.customData;
          
          var docArray = [];
          var docStore = this$.getStore('personinfo.common.pasthistory.ApplicantEducationHistoryDocumentStore');
          if (docStore.data.items != null
                  && docStore.data.items.length > 0) {
              Ext.each(docStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName,
                          "path" : val.data.path,
                          "type" : val.data.type,
                          "id" 	 : val.data.id,
                          "createdBy" : this$.getIdValueJson(
                                  val.data.createdBy.id,
                                  val.data.createdBy.value)
                  };
                  docArray.push(newData);
              });
          }
          var urlArray = [];
          var urlStore = this$.getStore('personinfo.common.pasthistory.ApplicantEducationHistoryUrlGridStore');
          if (urlStore.data.items != null
                  && urlStore.data.items.length > 0) {
              Ext.each(urlStore.data.items, function(val) {
                  var newData = {
                          "name" : val.data.documentName==null?val.data.name:val.data.documentName,
                          "path" : val.data.path,
                          "id"   : val.data.id,
                  };
                  urlArray.push(newData);
              });
          }

      }
      formData.graduationDocument = docArray;
      formData.graduationDocumentUrl = urlArray;
      jsonFormFieldData = Ext.encode(formData);
      return jsonFormFieldData;
  },
  editApplicantEducationHistoryDetailFormWindow: function(informationType, formItemId, gridItemId) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
     
      if (grid.getSelectionModel().getCount() > 0) {
      	  var formWindow = this$.showPersonCommonWindow(informationType, formItemId);
      	  if (formWindow) {
             formWindow.setHeight(320);
          }
      	  var form = this$.getEducationhistorydetailform();
          var records = grid.getSelectionModel().getSelection()[0];
          if (!isEmpty(records)) {
        	form.down('#education_history_Details_hidden_field').setValue(records.data.id);
        	  
          	if(!isNullOrEmpty(records.data.graduationDate))
          		records.data.graduationDate = new Date(records.data.graduationDate);
          	
          	var nameOfInstitutionsAttended = form.down("#nameOfInstitutionsAttended");
            if(!isNullOrEmpty(records.data.nameOfInstitutionsAttended))
            	nameOfInstitutionsAttended.setValue(records.data.nameOfInstitutionsAttended);
          	 
          	var highestQualification = form.down("#highestQualification");
            if(!isNullOrEmpty(records.data.highestQualification))
            	highestQualification.setValue(records.data.highestQualification);
            
            form.loadRecord(records);
          }
      } else {
          showWarningMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  viewApplicantEducationHistoryDetailFormWindow: function(informationType, formItemId, gridItemId) {
	  var this$ = this;
	  var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
	      this$.editApplicantEducationHistoryDetailFormWindow(informationType, formItemId, gridItemId);
	      var form = this$.getEducationhistorydetailform();
	      form.down("#graduationDate").setReadOnly(true);
	      form.down('#graduationDocument').setVisible(false);
	      form.down('#graduationDocumentUrl').setVisible(false);
	      var applicantEducationHistoryDocumentGrid = form.down('#applicanteducationhistorydocumentgrid');
	      var applicantEducationHistoryUrlGrid = form.down('#applicanteducationhistoryurlgrid');
	      applicantEducationHistoryDocumentGrid.down('#btnDelete').setDisabled(true);
	      applicantEducationHistoryUrlGrid.down('#btnDelete').setDisabled(true);
	      this$.viewPersonCommonWindow(form);
      } else {
    	  showWarningMessage(getCommonTranslation('EDUCATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
  deleteApplicantEducationHistoryDetailRecord:function(gridItemId, deleteUrl) {
      var this$ = this;
      var personProfile = this$.getContentPanelActiveTab();
      var grid = personProfile.down(gridItemId);
      if (grid.getSelectionModel().getCount() > 0) {
          showConfirmMessage(getCommonTranslation('DELETE_EDUCATION_DETAILS'), getCommonTranslation('EDUCATION_DETAILS_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
              if (btn == 'yes') {
                  if (grid.getSelectionModel().getCount() > 0) {
                      var records = grid.getSelectionModel().getSelection();
                      var flag=false;
                      for (var count = 0; count < records.length; count++) {
                          var id = "";
                          if (!isNullOrEmpty(records[count].get("id"))) {
                              id = records[count].get("id");
                          }
                          Ext.Ajax.request({
                              type: 'rest',
                              url: deleteUrl,
                              async:false,
                              method: 'DELETE',
                              headers: {
                                  'Content-Type': 'application/json'
                              },
                              params: {
                              	id: id
                              },
                              success: function(form, action) {
                            	  flag=true;
                              }
                          });
                      }
                      if(flag) {
                          grid.getStore().reload();
                          showSuccessMessage(getCommonTranslation('DELETE_EDUCATION_DETAILS'), getCommonTranslation('EDUCATION_DETAILS_DELETE_SUCCESS'));
                      }
                  }
              }
          });
      } else {
          showWarningMessage(getCommonTranslation('DELETE_EDUCATION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
      }
  },
  
    saveStudentJointDegreeInfo: function(gridItemId, saveUrl, updateUrl) {
        var this$ = this;
        var isValid = true;
        var submitUrl, isUpdate = false;

        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var form = this$.getStudentJointDegreeForm();
        form.down('#submitButtonId').setDisabled(true);

        if(isValid){
            var id = form.down('#student_joint_degree_hidden_field');
            if (!isNullOrEmpty(id.getSubmitValue())) {
            	submitUrl = updateUrl,
                isUpdate = true;
            } else {
            	submitUrl = saveUrl,
                isUpdate = false;       
            }
            var jsonFormatFormData = this$.getJsonStudentJointDegreeData(form,grid,isUpdate);
            this$.applyWindowMask(); 

            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
                this$.hideWindowMask();
                if(success){
                    this$.closePersonCommonWindow();
                    if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll();
                    if (isUpdate) {
                        showSuccessMessage(getCommonTranslation('STUDENT_JOINT_DEGREE_ACTION'), getCommonTranslation('STUDENT_JOINT_DEGREE_UPDATE_SUCCESS'));
                    } else {
                        showSuccessMessage(getCommonTranslation('STUDENT_JOINT_DEGREE_ACTION'), getCommonTranslation('STUDENT_JOINT_DEGREE_ADD_SUCCESS'));
                    }
                }else{
                    this$.hideWindowMask();
                    this$.closePersonCommonWindow();
                    grid.getStore().reload();
                    form.down('#submitButtonId').setDisabled(false);
                }
            });
        }

    },
    
    editStudentJointdegreeInfo: function(informationType, formItemId,gridItemId,isView) {

        var this$ = this;
        var isValid = true;
        var submitUrl, isUpdate = false;
        var personProfile = this$.getContentPanelActiveTab();
        var form = this$.getStudentJointDegreeForm();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
        					    	this.showPersonCommonWindow(informationType, formItemId);
        				            var records = grid.getSelectionModel().getSelection()[0];
        				            var form = this$.getStudentJointDegreeForm();
        				            
        				            form.down('#student_joint_degree_hidden_field').setValue(records.data.id);     
        				            if (!isNullOrEmpty(records.data.collaborationAgreementType)) {		            	
        			                    var collaborationAgreementType = form.down('#collaborationAgreementType')
        			                    collaborationAgreementType.getStore().load({ 
        			                    	callback: function(recordss, operation, success) {
        			                    		if (success) {
        			                    			for(i in recordss){
        			                    				if(recordss[i].data.value == records.data.collaborationAgreementType)
        			                    					collaborationAgreementType.setValue(recordss[i].data.value);  	
        			                    			}
        			                    		}
        			                    	}
        			                    });
        			                   
        			    				}
        				            if (!isNullOrEmpty(records.data.partnerInstitution1)) {		            	
        			                    var partnerInstitution1 = form.down('#partnerInstitution1')
        			                    partnerInstitution1.getStore().load({ 
        			                    	callback: function(recordss, operation, success) {
        			                    		if (success) {
        			                    			for(i in recordss){
        			                    				if(recordss[i].data.id == records.data.partnerInstitution1.id)
        			                    					partnerInstitution1.setValue(recordss[i].data.id);  	
        			                    			}
        			                    		}
        			                    	}
        			                    });
        			                   
        			    				}
        				            if (!isNullOrEmpty(records.data.partnerInstitutionCountry1)) {		            	
        			                    var partnerInstitutionCountry1 = form.down('#partnerInstitutionCountry1')
        			                    partnerInstitutionCountry1.getStore().load({ 
        			                    	callback: function(recordss, operation, success) {
        			                    		if (success) {
        			                    			for(i in recordss){
        			                    				if(recordss[i].data.id == records.data.partnerInstitutionCountry1.id)
        			                    					partnerInstitutionCountry1.setValue(recordss[i].data.id);  	
        			                    			}
        			                    		}
        			                    	}
        			                    });
        			                   
        			    				}
        				            if (!isNullOrEmpty(records.data.partnerInstitution2)) {		            	
        			                    var partnerInstitution2 = form.down('#partnerInstitution2')
        			                    partnerInstitution2.getStore().load({ 
        			                    	callback: function(recordss, operation, success) {
        			                    		if (success) {
        			                    			for(i in recordss){
        			                    				if(recordss[i].data.id == records.data.partnerInstitution2.id)
        			                    					partnerInstitution2.setValue(recordss[i].data.id);  	
        			                    			}
        			                    		}
        			                    	}
        			                    });
        			                   
        			    				}
        				            if (!isNullOrEmpty(records.data.partnerInstitutionCountry2)) {		            	
        			                    var partnerInstitutionCountry2 = form.down('#partnerInstitutionCountry2')
        			                    partnerInstitutionCountry2.getStore().load({ 
        			                    	callback: function(recordss, operation, success) {
        			                    		if (success) {
        			                    			for(i in recordss){
        			                    				if(recordss[i].data.id == records.data.partnerInstitutionCountry2.id)
        			                    					partnerInstitutionCountry2.setValue(recordss[i].data.id);  	
        			                    			}
        			                    		}
        			                    	}
        			                    });
        			                   
        			    				}
        				            
        			                var certificate = form.down("#certificate");
        				            if(!isNullOrEmpty(records.data.certificate))
        				            	certificate.setValue(records.data.certificate);
        				           
        			                var feesExemptedPerYear = form.down("#feesExemptedPerYear");
        				            if(!isNullOrEmpty(records.data.feesExemptedPerYear))
        				            	feesExemptedPerYear.setValue(records.data.feesExemptedPerYear);
        				            
        				            
        				            var ifrReduced = form.down("#ifrReduced");
        				            if(!isNullOrEmpty(records.data.ifrReduced))
        				            	{
        				            	 if(records.data.ifrReduced) {
        				            		 ifrReduced.items.items[0].setValue(true);
        				            		 ifrReduced.items.items[1].setValue(false);
        				                  } else {
        				                	  ifrReduced.items.items[0].setValue(false);
        				                	  ifrReduced.items.items[1].setValue(true);
        				                 	 }
        				                
        				            	}
        				             
        				            var feesExemptedPerYearReason = form.down("#feesExemptedPerYearReason");
        				            if(!isNullOrEmpty(records.data.feesExemptedPerYearReason))
        				            	feesExemptedPerYearReason.setValue(records.data.feesExemptedPerYearReason);
        				            
        				            var ifrReducedReason = form.down("#ifrReducedReason");
        				            if(!isNullOrEmpty(records.data.ifrReducedReason))
        				            	ifrReducedReason.setValue(records.data.ifrReducedReason);
        				         
        				            var auditDate = form.down("#auditDate");
        				            if(!isNullOrEmpty(records.data.auditDate))
        				            	auditDate.setValue(dateRender(records.data.auditDate));
        				            auditDate.setReadOnly(true);
        				           
        				            
        				            var auditId = form.down("#auditId");
        				            if(!isNullOrEmpty(records.data.auditId))
        				            	{
        				            	if(records.data.auditId.code == "SYSADMIN")
        				            		{
        				            		records.data.auditId.code ='sysadmin';
        				            		}
        				            	auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
        				            	}
        				            form.down('#partnerNumhusId').setValue(records.get('partnerNumhus'));
        				            form.down('#partnerUkprnId').setValue(records.get('partnerUkprn'));
        				            form.down('#partnerSidId').setValue(records.get('partnerSid'));
        				            return form;
        					        } else {
        				            showWarningMessage(getPersonModuleTranslation('STUDENT_JOINT_DEGREE_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        					            return null;
        					        }
        					    },
        					    editStudentMou: function(informationType, formItemId, gridItemId,isView) {

        					        var this$ = this;
        					        var isValid = true;
        					        var submitUrl, isUpdate = false;
        					        var personProfile = this$.getContentPanelActiveTab();
        					        var form = this$.getStudentMOUForm();
        					        var grid = personProfile.down(gridItemId);
        					        if (grid.getSelectionModel().getCount() > 0) {
        					        					    	this.showPersonCommonWindow(informationType, formItemId);
        					        				            var records = grid.getSelectionModel().getSelection()[0];
        					        				            var form = this$.getStudentMOUForm();
        					        				            
        					        				            form.down('#student_mou_hidden_field').setValue(records.data.id);     
        					        				            var effectiveStartDate = form.down("#effectiveStartDate");
        					        				            if(!isNullOrEmpty(records.data.effectiveStartDate))
        					        				            	effectiveStartDate.setValue(dateRender(records.data.effectiveStartDate));
        					        				         
        					        				            var auditDate = form.down("#auditDate");
        					        				            if(!isNullOrEmpty(records.data.auditDate))
        					        				            	auditDate.setValue(dateRender(records.data.auditDate));
        					        				            auditDate.setReadOnly(true);
        					        				           
        					        				            
        					        				            var auditId = form.down("#auditId");
        					        				            if(!isNullOrEmpty(records.data.auditId))
        					        				            	{
        					        				            	if(records.data.auditId.code == "SYSADMIN")
        					        				            		{
        					        				            		records.data.auditId.code ='sysadmin';
        					        				            		}
        					        				            	auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
        					        				            	}
        					        				            
        					        				            return form;
        					        					        } else {
        					        				            showWarningMessage(getCommonTranslation('STUDENT_MOU'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        					        					            return null;
        					        					        }
        					        					    },
        	    

    /**
	 * Get Student Joint Degree Action Json for form submission
	 */
    getJsonStudentJointDegreeData: function(form,grid,isUpdate) { 

        var this$ = this;
        var jsonFormFieldData = new Object();
        var personObj = this$.getPersonObj();
        var formData = form.getValues();
        if(!formData.partnerInstitutionCountry2 || isNullOrEmpty(formData.partnerInstitutionCountry2.id)) {
        	formData.partnerInstitutionCountry2 = null;
        }
        var studentJointDegree = new Academia.model.student.postgraduatemanagement.StudentJointDegreeModel();
        if (!isEmpty(formData)) {
            var person = new Object();
            person.id = personObj["id"];
            formData.person = person;
            if(isUpdate) {
            	     var record = grid.getSelectionModel().getSelection();
            	     formData.auditId = this$.getIdValueJson(record[0].data.auditUserId);
            	       } else {                        
            	        formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
            	        }
            var loggedInUser = this$.getCurrentlyLoggedInUser().id;
            formData.auditId=loggedInUser;
            var docStore = this$.getStore('student.postGraduateManagement.StudentJointDegreeDocumentStore');
            var docArray = [];
            if (docStore.data.items != null
                    && docStore.data.items.length > 0) {
                Ext.each(docStore.data.items, function(val) {
                    var newData = {
                            "name" : val.data.documentName,
                            "path" : val.data.path,
                            "type" : val.data.type,
                            "id" : val.data.id,
                            "createdBy" : this$.getIdValueJson(
                                    val.data.createdBy.id,
                                    val.data.createdBy.value)
                    };
                    docArray.push(newData);
                });
            }
        }
        formData.studentJointDegreeDocuments = docArray;
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    deleteStudentJointDegreeInfoRecord:function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('STUDENT_JOINT_DEGREE_ACTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                	id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('STUDENT_JOINT_DEGREE_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('STUDENT_JOINT_DEGREE_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    
    },
    saveStudentOwnProgressReport: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var isValid = true;
        var submitUrl, isUpdate = false;

        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var form = this$.getStudentOwnProgressReportForm();
        form.down('#submitButtonId').setDisabled(true);

        if(isValid){
            var id = form.down('#student_own_progress_report_hidden_field');
            if (!isNullOrEmpty(id.getSubmitValue())) {
            	submitUrl = updateUrl,
                isUpdate = true;
            } else {
            	submitUrl = saveUrl,
                isUpdate = false;       
            }
            var jsonFormatFormData = this$.getJsonStudentOwnProgressReportData(form,grid,isUpdate);
            var studentownprogressreportdocumentgridStore =  form.down('#studentownprogressreportdocumentgrid').getStore();
	        if(studentownprogressreportdocumentgridStore.data.length>0){
            this$.applyWindowMask(); 

            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
                this$.hideWindowMask();
                if(success){
                    this$.closePersonCommonWindow();
                    if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                    	try{
                    		personId = this$.getPersonObj().id;
                    		if(isNullOrEmpty(personId)){
                    			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                    		}
                    	}
                    	catch(e){
                    		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                    	}
                    	grid.getStore().getProxy().extraParams = {
                    		personId : personId
                    	};
                    }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll();
                    if (isUpdate) {
                        showSuccessMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'), getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_UPDATE_SUCCESS'));
                    } else {
                        showSuccessMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'), getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_ADD_SUCCESS'));
                    }
                }else{
                    this$.hideWindowMask();
                    this$.closePersonCommonWindow();
                    grid.getStore().reload();
                    form.down('#submitButtonId').setDisabled(false);
                }
            });
	        }else{
	        	   showWarningMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
	        	   form.down('#submitButtonId').setDisabled(false);
	           }
        }

    },
    getJsonStudentOwnProgressReportData: function(form,grid,isUpdate) { 
        var this$ = this;
        var jsonFormFieldData = new Object();
        var personObj = this$.getPersonObj();
        var formData = form.getValues();
        var studentOwnProgressReport = new Academia.model.student.postgraduatemanagement.StudentOwnProgressReportModel();
        if (!isEmpty(formData)) {
            var person = new Object();
            person.id = personObj["id"];
            formData.person = person;
            if(isUpdate) {
            	var record = grid.getSelectionModel().getSelection();
            		formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
            } else {                        
            	formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
            }
            if(isNullOrEmpty(formData.reportRating)) {
				delete formData.reportRating;
			} else {
				formData.reportRating = this$.getIdValueJson(formData.reportRating);
			}
            var docStore = this$.getStore('student.postGraduateManagement.StudentOwnProgressReportDocumentGridStore');
            var docArray = [];
            if (docStore.data.items != null
                    && docStore.data.items.length > 0) {
                Ext.each(docStore.data.items, function(val) {
                    var newData = {
                            "name" : val.data.documentName,
                            "path" : val.data.path,
                            "type" : val.data.type,
                            "createdBy" : this$.getIdValueJson(
                                    val.data.createdBy.id,
                                    val.data.createdBy.value)
                    };
                    docArray.push(newData);
                });
            }
        }
        formData.studentOwnProgressReportDocuments = docArray;
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    deleteStudentOwnProgressRerportRecord:function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                	id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('STUDENT_OWN_PROGRESS_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    
    },
    editStudentOwnProgressReport: function(informationType, formItemId,gridItemId,isView) {

        var this$ = this;
        var isValid = true;
        var submitUrl, isUpdate = false;
        var personProfile = this$.getContentPanelActiveTab();
        var form = this$.getStudentOwnProgressReportForm();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
        					    	this.showPersonCommonWindow(informationType, formItemId);
        				            var records = grid.getSelectionModel().getSelection()[0];
        				            var form = this$.getStudentOwnProgressReportForm();
        				
        				            form.down('#student_own_progress_report_hidden_field').setValue(records.data.id);     
        				          
        				            var progressReportStartDate = form.down("#progressReportStartDate");
        				            if(!isNullOrEmpty(records.data.progressReportStartDate))
        				            	progressReportStartDate.setValue(dateRender(records.data.progressReportStartDate));
        				          
        				            var progressReportEndDate = form.down("#progressReportEndDate");
        				            if(!isNullOrEmpty(records.data.progressReportEndDate))
        				            	progressReportEndDate.setValue(dateRender(records.data.progressReportEndDate));
        				            
        				            if (!isNullOrEmpty(records.data.reportRating)) {		            	
        			                    var reportRating = form.down('#reportRating')
        			                    reportRating.getStore().load({ 
        			                    	callback: function(recordss, operation, success) {
        			                    		if (success) {
        			                    			for(i in recordss){
        			                    				if(recordss[i].data.id == records.data.reportRating.id)
        			                    					reportRating.setValue(recordss[i].data.id);  	
        			                    			}
        			                    		}
        			                    	}
        			                    });
        			                   
        			    				} 
        				            
        				            var auditDate = form.down("#auditDate");
        				            if(!isNullOrEmpty(records.data.auditDate))
        				            	auditDate.setValue(dateRender(records.data.auditDate));
        				            auditDate.setReadOnly(true);
        				           
        				            
        				            var auditId = form.down("#auditId");
        				            if(!isNullOrEmpty(records.data.auditId))
        				            	{
        				            	if(records.data.auditId.code == "SYSADMIN")
        				            		{
        				            		records.data.auditId.code ='sysadmin';
        				            		}
        				            	auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
        				            	}
        				            
        				            return form;
        					        } else {
        				            showWarningMessage(getPersonModuleTranslation('STUDENT_OWN_PROGRESS_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        					            return null;
        					        }
    },
    saveEmployeePhysicalCharInfo: function(gridItemId, saveUrl, updateUrl) {
    	
        var this$ = this;
        var form = this$.getEmployeephysicalcharacteristicsform();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#phyChar_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl =updateUrl,
            isUpdate = true;
        }
       
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        var jdata = Ext.decode(jsonFormatFormData);
        delete jdata.person;
        delete jdata.customData;        
        if(isNullOrEmpty(jdata.eyeColor) || jdata.eyeColor==""){
        	delete jdata.eyeColor;
        }
        if(isNullOrEmpty(jdata.hairColor) || jdata.hairColor==""){
        	delete jdata.hairColor;
        }
        jdata.personId=personProfile.personId;
        jsonFormatFormData = Ext.encode(jdata);
        this$.applyWindowMask(); 
       
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	 this$.hideWindowMask();
        	if(success){
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
    		}
        });
    },
    /**
	 * View PhysicalCharacterirst form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    viewPhysicalCharFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
        this$.editPhysicalCharFormWindow(informationType, formItemId, gridItemId);
        var form = this$.getPhysicalcharacteristicsform();
        this$.viewPersonCommonWindow(form);
    },
    
    /**
	 * Edit PhysicalCharacterirst form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editPhysicalCharFormWindow: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
            var form;
            if(formItemId=="facultyPhysicalCharacteristicsGrid"){
            	form = this$.getEmployeephysicalcharacteristicsform();
            }else{
            	form = this$.getPhysicalcharacteristicsform();
            }
            var records = grid.getSelectionModel().getSelection()[0];
            if(!isNullOrEmpty(records.get('updatedDate'))){
            	records.data.updatedDate=new Date(records.get('updatedDate'));
            }
            
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
	 * Delete PhysicalCharacterirst record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deletePhysicalCharRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
	 * View extra curricular history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    viewExtraCurricularFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
        this$.editExtraCurricularFormWindow(informationType, formItemId, gridItemId);
        var form = this$.getPersonExtraCurricularForm();
        form.down('#activityType').setReadOnly(true);
        form.down('#community').setReadOnly(true);
        form.down('#awardDate').setReadOnly(true);
        this$.viewPersonCommonWindow(form);
    },
    /**
	 * Edit extra curricular history form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editExtraCurricularFormWindow: function(informationType, formItemId, gridItemId) {

    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this$.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonExtraCurricularForm();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
                if (records.get('isCurrentOrganization') == true) {
                    form.down('#previousOrgRadioBtn').setValue(false);
                    form.down('#currentOrgRadioBtn').setValue(true);
                } else {
                    form.down('#previousOrgRadioBtn').setValue(true);
                    form.down('#currentOrgRadioBtn').setValue(false);
                }
                form.down('#awardDate').setValue(dateRender(records.data.awardDate));
                var EventByNameUrl = SERVERURL.FIND_ALL_EVENT_NAME_BY_NAME;
                var otherEvent = form.getForm().findField('otherEvent');
                var eventId = form.getForm().findField('eventId'); 
                Ext.Ajax.request({
    	   		 type : 'rest',
    	   		 url : EventByNameUrl,
    	   		 params : {
    	   			eventName:'OTHEREVENT'
    	   		 },
    	   		 method : 'GET',
    	   		 success : function(response, action) {
    	   			 var text = Ext.decode(response.responseText);
    	   			 if(text[0].id != records.get('eventId').id) {
    	   				eventId.setVisible(true);
    	   				otherEvent.setVisible(false);
    	   				otherEvent.setDisabled(true);
    	   			 }
    	   				eventId.getStore().load({
    						  callback:function(){
    							  eventId.setValue(records.get('eventId').id);
    						  }
    					});
    	   			 
    	   		 }
    	   	 });
                	
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
	 * Delete extra curricular history record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deleteExtraCurricularRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id, // SERVERURL.EXTRA_CURRICULAR_DELETE
														// + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('EXTRA_CURRICULAR_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
	 * Save extra curricular history
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    saveExtraCurricular: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var form = this$.getPersonExtraCurricularForm();
        form.down('#submitButtonId').setDisabled(true);
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#curricular_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl;// SERVERURL.EXTRA_CURRICULAR_ADD,
            isUpdate = false;
        } else {
            submitUrl = updateUrl;// SERVERURL.EXTRA_CURRICULAR_UPDATE,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        
        var mainObj = Ext.decode(jsonFormatFormData);
        
        var eventNamebj = new Object();
        eventNamebj.id = parseInt(mainObj.eventId);
        mainObj.eventId = eventNamebj;
        if (isNullOrEmpty(id.getSubmitValue())) {
        	var arrJson = [];
            arrJson.push(mainObj);
        }else{
        	var arrJson = Ext.encode(mainObj);
        }
        this$.applyWindowMask(); 
        this$.sendSaveAjaxRequest(submitUrl, 'POST', arrJson, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success){
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY'), getPersonModuleTranslation('EXTRA_CURRICULAR_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY'), getPersonModuleTranslation('EXTRA_CURRICULAR_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
                form.down('#submitButtonId').setDisabled(false);
    		}
        });
    },
    
    
    /**
	 * View Competitive exam form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    viewCompetitiveExamFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
        this$.editCompetitiveExamFormWindow(informationType, formItemId, gridItemId);
        var form = this$.getPersonCompetitiveExamForm();
        this$.viewPersonCommonWindowNonAcademicAchievements(form);
        var removeButton = form.down('#removeButtonId');
		removeButton.setVisible(false);

    },
    /**
	 * Edit Competitive exam form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    editCompetitiveExamFormWindow: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this$.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonCompetitiveExamForm();
	        var removeButton = form.down('#removeButtonId');
	    	removeButton.setVisible(true);
	    	removeButton.setDisabled(true);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
                form.down('#examinationName').setReadOnly(true);
                form.down('#yearOfExam').setValue(dateRender(records.data.yearOfExam));
                form.down('#filePath').setValue(records.data.filePath);
                if (!isNullOrEmpty(records.data.filePath)) {
                    var uploadFileField = form.down('#uploadFileItemId');
    				var downloadUrl = form.down('#competitiveDownloadURL');
    				downloadUrl.setValue(records.data.filePath);
    				downloadUrl.setVisible(true);
    				removeButton.setDisabled(false);
    				if(!uploadFileField.isHidden()){
                		downloadUrl.setVisible(true);
                		uploadFileField.allowBlank = true;
                	}
				}
				var completionDate = form.down('#completionDate');
                if(!isNullOrEmpty(records.data.officerFormativeQualified)) {
                	if(records.data.officerFormativeQualified.value=="Yes" || records.data.officerFormativeQualified.value=="In Progress") {
                		completionDate.setValue(dateRender(records.data.completionDate));
                		var status = this$.checkCompletionDateDfrSetting(form);
                		if(status==false){
                			completionDate.setVisible(true);
                		}
                	}
                	else {
                		completionDate.setVisible(false);
                		completionDate.reset();
                		completionDate.allowBlank=true;
                		form.getForm().checkValidity();
                	}
                } else {
                		completionDate.setVisible(false);
                		completionDate.reset();
                		completionDate.allowBlank=true;
                		form.getForm().checkValidity();
                	}
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('COMPETITIVE_EXAM_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
	 * Delete Competitive exam record
	 * 
	 * @param gridItemId
	 * @param deleteUrl
	 */
    deleteCompetitiveExamRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('COMPETITIVE_EXAM_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('COMPETITIVE_EXAM_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('COMPETITIVE_EXAM_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    saveCompetitiveExam: function(gridItemId, saveUrl, updateUrl, entityType) {
		 var this$ = this;
		 var form = this$.getPersonCompetitiveExamForm();
		 var uploadFileCompetitive = form.down('#uploadFileItemId');
		 var CompetitiveDocumentPath = uploadFileCompetitive.getValue();
		 var personObj = this$.getPersonObj();
		 var data = new Object();
		 data.entityId = personObj.id;
		 data.module = entityType;
		 data.entityType = 'competitive';
		 form.getForm().setValues(data);
		 var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
		 this$.applyWindowMask(); 
		 if (!isNullOrEmpty(CompetitiveDocumentPath)) {
			 form.getForm().submit({
				 method: 'POST',
				 url: uplaodUrl,
				 success: function(form1, action) {
					 // callback(true);
					 var responseData = Ext.decode(action.response.responseText);
					 var path = responseData.path;
					 form.getForm().findField('filePath').setValue(path);
					 this$.saveCompetitiveExamRecord(gridItemId, saveUrl, updateUrl);
				 },
				 failure: function() {
					 console.log('hello');
				 }
			 });
		 } else {
			 this$.saveCompetitiveExamRecord(gridItemId, saveUrl, updateUrl);
		 }
	 },
    /**
	 * Save Competitive exam
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    saveCompetitiveExamRecord: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var form = this$.getPersonCompetitiveExamForm();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#competitive_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl;
            isUpdate = false;
        } else {
            submitUrl = updateUrl;
            isUpdate = true;
        }
        if(!isNullOrEmpty(form.down('#examinationName').getValue())){
        	var jsonFormatFormData = this$.getCompExamJsonSubmitData(form);
        	try{
                var jsonFormatFormDataObj = Ext.decode(jsonFormatFormData);
                if(submitUrl==SERVERURL.COMPETITIVE_CREATE || submitUrl==SERVERURL.COMPETITIVE_UPDATE){
                    delete jsonFormatFormDataObj.person.personType;
                    jsonFormatFormData = Ext.encode(jsonFormatFormDataObj);
                }
            }
            catch(e){
            	console.log('--');
            }
        	this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        		this$.hideWindowMask();
        		var data = Ext.decode(response.responseText);
        		if(success){
        			this$.closePersonCommonWindow();
        			grid.getStore().reload();
        			grid.getSelectionModel().deselectAll();
        			if (isUpdate) {
        				showSuccessMessage(getPersonModuleTranslation('COMPETITIVE_EXAM_DETAILS'), getPersonModuleTranslation('COMPETITIVE_EXAM_UPDATE_SUCCESS'));
        			} else {
        				showSuccessMessage(getPersonModuleTranslation('COMPETITIVE_EXAM_DETAILS'), getPersonModuleTranslation('COMPETITIVE_EXAM_ADD_SUCCESS'));
        			}
        		}else{
        			this$.closePersonCommonWindow();
        			if(isArray(data)){
        				if(data[0].key == 'EXAM_NAME_ALREADY_EXISTS') {
        					showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('EXAM_NAME_ALREADY_EXISTS'));
        					return false;
        				}
        			}
        		}
        	});
        }else{
        	showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('PLEASE_SELECT_EXAM_DETAILS'));
        }
    },
    
    
    /**
	 * View Non Academic Achievements form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    /*
	 * viewNonAcademicAchievementsFormWindow: function(informationType,
	 * formItemId, gridItemId) { var this$ = this;
	 * this$.editNonAcademicAchievementsFormWindow(informationType, formItemId,
	 * gridItemId); var form = this$.getPersonCompetitiveExamForm();
	 */
  
    /**
	 * Edit Non Academic Achievements form window
	 * 
	 * @param informationType
	 * @param formItemId
	 * @param gridItemId
	 */
    /*
	 * editCompetitiveExamFormWindow: function(informationType, formItemId,
	 * gridItemId) {
	 * 
	 * var this$ = this; var personProfile = this$.getContentPanelActiveTab();
	 * var grid = personProfile.down(gridItemId);
	 * 
	 * if (grid.getSelectionModel().getCount() > 0) {
	 * this$.showPersonCommonWindow(informationType, formItemId); var form =
	 * this$.getPersonCompetitiveExamForm(); var records =
	 * grid.getSelectionModel().getSelection()[0]; if (!isEmpty(records)) {
	 * form.loadRecord(records); form.down('#sportEvent').setReadOnly(true);
	 * form.down('#levelEvent').setValue(dateRender(records.data.levelevent)); } }
	 * else {
	 * showWarningMessage(getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS'),
	 * getCommonTranslation('PLEASE_SELECT_RECORD')); } },
	 */
    // Training Details

    addTrainingDetails: function() {
        var trainingFormWindow = Ext.widget('trainingformwindow');
        trainingFormWindow.show();
    },
    editTrainingDetailsModified: function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid, menuColorCls){
    	var $this = this;
    	/*
		 * var personProfile = $this.getContentPanelActiveTab(); var grid =
		 * personProfile.down(gridItemId);
		 */
    	var form;
    	if (grid.getSelectionModel().getCount() > 0) {
    		/*
			 * if(this.getCurrentLoggedPortalId() == 2){ var contentpanel =
			 * $this.getContentPanel(); var researchtypeformtab =
			 * Ext.widget('persontrainingdetailsform',{
			 * //itemId:'trainingtypeformfacultyportal' }); var tabName =
			 * getPersonModuleTranslation('TRAINING_DETAILS');
			 * openTab(contentpanel, tabName,
			 * researchtypeformtab,CONSTANTS.MENU_COLOR_THREE); //form =
			 * $this.getPersonResearchTypeFormFacultyPortal(); form =
			 * $this.getPersonTrainingDetailsForm(); }else
			 * if(this.getCurrentLoggedPortalId() == 3 ||
			 * this.getCurrentLoggedPortalId() == 7){ var contentpanel =
			 * $this.getContentPanel(); var researchtypeformtab =
			 * Ext.widget('persontrainingdetailsform',{
			 * //itemId:'trainingdetailsformstudentportal' }); var tabName =
			 * getPersonModuleTranslation('TRAINING_DETAILS');
			 * openTab(contentpanel, tabName,
			 * researchtypeformtab,CONSTANTS.MENU_COLOR_SEVEN); //form =
			 * $this.getPersonTrainingDetailsFormStudentPortal(); form =
			 * $this.getPersonTrainingDetailsForm(); }else{
			 * $this.showTrainingDetails(personType, tabPanelItemId,
			 * tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
			 * form = $this.getPersonTrainingDetailsForm(); }
			 */
    		$this.showTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel, menuColorCls);
			form = $this.getPersonTrainingDetailsForm();
			var formScroll = form.up('form');
			if(!isNullOrEmpty(formScroll.getEl()))
			{
				var getElValue=formScroll.getEl();
				var getFirstChild = getElValue.first();
				getFirstChild.dom.style.overflowY="scroll";
			}
    		var records = grid.getSelectionModel().getSelection()[0];
    		if (!isEmpty(records)) {
    			if(!isNullOrEmpty(records.data.fromDate))
    	           	records.data.fromDate = new Date(records.data.fromDate);
    			if(!isNullOrEmpty(records.data.toDate))
    	           	records.data.toDate = new Date(records.data.toDate);
    			if(!isNullOrEmpty(records.data.trainingStatus)){
    				records.data.trainingStatus = getCommonTranslation(records.data.trainingStatus);
    			}
    			form.loadRecord(records);
    			
    			if(!isNullOrEmpty(records.data.address)){
    				values = records.data.address; 
    				filterForm = form.getForm();
    				var dataModel = new Academia.model.organization.Address;
    				dataModel.set('id', values.id);
    				dataModel.set('addressId', values.addressId);
    				dataModel.set('version', values.version);
    				dataModel.set('addressText', values.addressText);
    				dataModel.set('country', $this
    						.getIdValueJson(values.country.id,values.country.value));
    				dataModel.set('parentCountryRegion', $this
    						.getIdValueJson(values.parentCountryRegion.id,values.parentCountryRegion.value));
    				dataModel
    						.set('city', $this.getIdValueJson(values.city.id,values.city.value));
    				dataModel.set('pincode', values.pincode);
    				dataModel
    						.set('cellCountryCode', values.cellCountryCode);
    				dataModel.set('cellNo', values.cellNo);
    				dataModel.set('phoneCountryCode',
    						values.phoneCountryCode);
    				dataModel.set('phoneAreaCode', values.phoneAreaCode);
    				dataModel.set('phoneNo', values.phoneNo);
    				dataModel
    						.set('primaryeEmailId', values.primaryeEmailId);
    				dataModel.set('alternateEmailId',
    						values.alternateEmailId);
    				// dataModel.set('addressType', null);
    				dataModel.set('countryRegion', $this
    						.getIdValueJson(values.countryRegion));
    				// dataModel.set('salutation', values.salutation);
    				Ext.apply(filterForm, {
    					code : null,
    					setCode : function(code) {
    						filterForm.code = code;
    					},
    					getCode : function() {
    						return filterForm.code;
    					}
    				});
    				filterForm.setCode(dataModel);
    			}

    			var store = $this.getStore('personinfo.common.pasthistory.TrainingTypeDocumentGridStr');
    			store.getProxy().extraParams = {
    				personDocumentId : records.data.id
    			};
    			store.load();
    		}
    	} else {
             showWarningMessage(getPersonModuleTranslation('RESEARCH_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
    	form.down('#cancelButtonId').setVisible(false);
    },
    editTrainingDetails: function(isView) {
        var me = this;
        var grid = me.getTrainingDetailsGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var trainingFormWindow = Ext.widget('trainingformwindow');
            trainingFormWindow.show();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var trainingForm = trainingFormWindow.down('#trainingForm');
                trainingForm.loadRecord(records[0]);
                if (isView) {
                    trainingFormWindow.down('#saveTrainingButtonId').setVisible(false);
                    toggleReadOnlyFormItems(trainingForm.getForm(), true);
                }
            }
        } else {
            Ext.Msg.alert(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
																										// select
																										// a
																										// record.
        }

    },
    saveTrainingDetails: function() {

    },
    closeTrainingDetailsForm: function() {
        this.getTrainingFormWindow().close();
    },
    
    
    /**
	 * Research Details
	 */
    showResearchDetails:function(personType,tabPanelItemId,tabPanelTitle,tabPanelItemXtype,xtypeItemId,defaultPanel){
    	this.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    },
    showTrainingDetails:function(personType,tabPanelItemId,tabPanelTitle,tabPanelItemXtype,xtypeItemId,defaultPanel, menuColorCls){
    	this.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel, '', menuColorCls);
    },
    onChangeIsucsubmmited:function(obj,rec){
    	var form = obj.up('form');
    	var ucSubmmitionDate = form.down('#dateOfUCSubmission');
    	if(rec.whetherUCSubmitted){
    		ucSubmmitionDate.setVisible(true);
    	}else{
    		ucSubmmitionDate.setVisible(false);
    		ucSubmmitionDate.reset();
    	}
    	
    },
    /**
	 * Save research type details
	 * 
	 * @param gridItemId
	 * @param saveUrl
	 * @param updateUrl
	 */
    saveResearchTypeDetails: function(grid, form,saveUrl, updateUrl) {

        var this$ = this;
        form.down('#submitButtonId').setDisabled(true);
// var form = this$.getPersonResearchTypeForm();
        var values = form.getForm().getValues();
        /*
		 * var personProfile = this$.getContentPanelActiveTab(); var grid =
		 * personProfile.down(gridItemId);
		 */

        var submitUrl, isUpdate = false;
        var id = form.down('#research_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl;// SERVERURL.CREATE_PERSON_RESEARCH,
            isUpdate = false;
        } else {
            submitUrl = updateUrl;// SERVERURL.UPDATE_PERSON_RESEARCH,
            isUpdate = true;
        }
        var records = grid.getSelectionModel().getSelection()[0];
        var version =0;
        if(records !=undefined){
        	version = records.data.version;
        }
    	
		var publicationData;
		var publicationDataArrayData=[];
		var publicationIds = values.publicationIds;
		if(publicationIds !="" && publicationIds !=null){
			for(var i in publicationIds){
				if(Ext.isObject(publicationIds[0])){
					publicationData = publicationIds[i].get("id");
					publicationDataArrayData.push(publicationData);
				}else{
					publicationData = publicationIds[i];
					publicationDataArrayData.push(publicationData);
				}
			}
		}	
        
        var researchDetailsMdl = new Academia.model.personinfo.common.pasthistory.ResearchDetailsMdl();
        var personOb;
        if(this.getCurrentLoggedPortalId() ==7){
        	personId = this.getCurrentlyLoggedInUserInfoForPortal().student.person.id;
        	if(!isNullOrEmpty(personId))
        	{
        		personOb= {
        				id:personId
        		};
        	}
        }else{
        	if(this.getCurrentLoggedPortalId() == 2 ||  this.getCurrentLoggedPortalId() ==3){
        		var personId = this.getCurrentlyLoggedInUserWithPersonId().personId;
        		personOb= {
        				id:personId
        		};

        	}else{
        		personOb = this$.getPersonObj();	
        	}

        }
        researchDetailsMdl.set("id", values.id);
        researchDetailsMdl.set("person", personOb);
        researchDetailsMdl.set("researchType", values.researchType);
        researchDetailsMdl.set("researchTitle", values.researchTitle);
        researchDetailsMdl.set("researchDate", values.researchDate);
        researchDetailsMdl.set("isbnNumber", values.isbnNumber);
        researchDetailsMdl.set("authorName", values.authorName);
        researchDetailsMdl.set("otherAuthorName", values.otherAuthorName);
        researchDetailsMdl.set("pageNumber", values.pageNumber);
        researchDetailsMdl.set("issueNo", values.issueNo);
        researchDetailsMdl.set("impactFactor", values.impactFactor);
        researchDetailsMdl.set("publicationYear", values.publicationYear);
        researchDetailsMdl.set("conferenceJournalType", values.conferenceJournalType);
        researchDetailsMdl.set("journalName", values.journalName);
        researchDetailsMdl.set("publisherName", values.publisherName);
        researchDetailsMdl.set("researchGroup", values.researchGroup);
        researchDetailsMdl.set("url", values.url);
        researchDetailsMdl.set("projectType", values.projectType);// this$.getIdValueJson(values.projectType));
        researchDetailsMdl.set("amountGranted", values.amountGranted);
        researchDetailsMdl.set("fundingAgencyName", values.fundingAgencyName);
        researchDetailsMdl.set("fundType", values.fundType);
        researchDetailsMdl.set("tenure", values.tenure);
        researchDetailsMdl.set("whetherInstituteAffiliation", values.whetherInstituteAffiliation);
        researchDetailsMdl.set("whetherUCSubmitted", values.whetherUCSubmitted);
        researchDetailsMdl.set("dateOfUCSubmission", values.dateOfUCSubmission);
        researchDetailsMdl.set("researchDetails", values.researchDetails);
        researchDetailsMdl.set("volumeNo", values.volumeNo);
        researchDetailsMdl.set("yearOfPublication", values.yearOfPublication);
        
        researchDetailsMdl.set("publicationIds", publicationDataArrayData);
        researchDetailsMdl.set("version", version);
// researchDetailsMdl.set("customData", null);
        
   	 var docStore = this$.getStore('personinfo.common.pasthistory.ResearchTypeDocumentGridStr');
	 var docArray = [];
	 if (docStore.data.items != null
			 && docStore.data.items.length > 0) {
		 Ext.each(docStore.data.items, function(val) {
			 var newData = {
					 "name" : val.data.documentName,
					 "path" : val.data.path,
					 "type" : val.data.type,
					 "createdBy" : this$.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
			 };
			  if(val.data.documentId==""){
    			  docArray.push(newData);  
    		  }
// docArray.push(newData);
		 });
	 }
	 researchDetailsMdl.set("documents", docArray);
        var jsonFormatFormData = Ext.encode(researchDetailsMdl.data);
        
       this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success){
              	if(this$.getCurrentLoggedPortalId() == 2){
              		var activeTab = this$.getPersonResearchTypeFormFacultyPortal().up('panel');
       			 	this$.closeTab(activeTab);	
              	}else if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
              		var activeTab = this$.getPersonResearchTypeFormStudentPortal().up('panel');
       			 	this$.closeTab(activeTab);
              	}else{
              		var activeTab = this$.getPersonResearchTypeForm().up('panel');
       			 	this$.closeTab(activeTab);	
              	}
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('RESEARCH_TYPE'), getPersonModuleTranslation('RESEARCH_TYPE_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('RESEARCH_TYPE'), getPersonModuleTranslation('RESEARCH_TYPE_ADD_SUCCESS'));
                }
    		}else{
                grid.getStore().reload();
                form.down('#submitButtonId').setDisabled(false);
    		}
        });
    },
    editTrainingDetails: function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid){

    	var $this = this;
    	/*
		 * var personProfile = $this.getContentPanelActiveTab(); var grid =
		 * personProfile.down(gridItemId);
		 */
    	var form;
    	if (grid.getSelectionModel().getCount() > 0) {
    		if(this.getCurrentLoggedPortalId() == 2){
    			/*
				 * var contentpanel = $this.getContentPanel(); var
				 * researchtypeformtab = Ext.widget('researchtypeform',{
				 * itemId:'researchtypeformfacultyportal' }); var tabName =
				 * getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
				 * openTab(contentpanel, tabName,
				 * researchtypeformtab,CONSTANTS.MENU_COLOR_THREE); form =
				 * $this.getPersonResearchTypeFormFacultyPortal();
				 */
    			$this.showResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    			form = $this.getPersonTrainingDetailsForm();
    		}else if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 2 ){
    			/*
				 * var contentpanel = $this.getContentPanel(); var
				 * researchtypeformtab = Ext.widget('researchtypeform',{
				 * itemId:'researchtypeformstudentportal' }); var tabName =
				 * getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
				 * openTab(contentpanel, tabName,
				 * researchtypeformtab,CONSTANTS.MENU_COLOR_SEVEN); form =
				 * $this.getPersonResearchTypeFormStudentPortal();
				 */
    			$this.showResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    			form = $this.getPersonTrainingDetailsForm();
    		}else{
    			$this.showResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    			form = $this.getPersonTrainingDetailsForm();
    		}

    		
    		var records = grid.getSelectionModel().getSelection()[0];
    		if (!isEmpty(records)) {
    			if(!isNullOrEmpty(records.data.fromDate))
    	           	records.data.fromDate = new Date(records.data.fromDate);
    			if(!isNullOrEmpty(records.data.toDate))
    	           	records.data.toDate = new Date(records.data.toDate);
    			form.loadRecord(records);

    			/*
				 * if (records.get('whetherInstituteAffiliation') == true) {
				 * form.down('#whetherInstituteAffiliationTrue').setValue(true);
				 * form.down('#whetherInstituteAffiliationFalse').setValue(false); }
				 * else {
				 * form.down('#whetherInstituteAffiliationTrue').setValue(false);
				 * form.down('#whetherInstituteAffiliationFalse').setValue(true); }
				 * 
				 * if (records.get('whetherUCSubmitted') == true) {
				 * form.down('#whetherUCSubmittedTrue').setValue(true);
				 * form.down('#whetherUCSubmittedFalse').setValue(false);
				 * form.down('#dateOfUCSubmission').setVisible(true); } else {
				 * form.down('#whetherUCSubmittedTrue').setValue(false);
				 * form.down('#whetherUCSubmittedFalse').setValue(true);
				 * form.down('#dateOfUCSubmission').setVisible(false); }
				 */

    			var store = $this.getStore('personinfo.common.pasthistory.TrainingTypeDocumentGridStr');
    			store.getProxy().extraParams = {
    				personDocumentId : records.data.id
    			};
    			store.load();
    		}
    	} else {
             showWarningMessage(getPersonModuleTranslation('RESEARCH_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
    },
    viewTrainingDetails: function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid,menuColorCls) {
    	var $this = this;
        $this.editTrainingDetailsModified(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid,menuColorCls);
        var form;
        if(this.getCurrentLoggedPortalId() == 2){
        	// form = this$.getPersonResearchTypeFormFacultyPortal();
        	// form = $this.getPersonTrainingDetailsFormStudentPortal();
        	form = $this.getPersonTrainingDetailsForm();
        }else if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 2){
        	// form = this$.getPersonResearchTypeFormStudentPortal();
        	// form = $this.getPersonTrainingDetailsFormStudentPortal();
        	form = $this.getPersonTrainingDetailsForm();

        	/*
			 * var contentpanel = $this.getContentPanel(); var
			 * researchtypeformtab = Ext.widget('persontrainingdetailsform',{
			 * itemId:'trainingdetailsformstudentportal' }); var tabName =
			 * getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
			 * openTab(contentpanel, tabName,
			 * researchtypeformtab,CONSTANTS.MENU_COLOR_SEVEN); form =
			 * $this.getPersonTrainingDetailsFormStudentPortal();
			 */
        	
        	
        }else{
        	// form = this$.getPersonResearchTypeForm();
        	form = $this.getPersonTrainingDetailsForm();
        	// form = $this.getPersonTrainingDetailsFormStudentPortal();
        }
        toggleReadOnlyFormItems(form.getForm(), true);
        form.down('#submitButtonId').setVisible(false);
        form.down('#cancelButtonId').setVisible(false);
        form.down('#uploadDocItemId').setVisible(false);
        form.down('#trainingTypeDocument').down('#btnDelete').setDisabled(true);
        if(!isNullOrEmpty(form.down('#personAddressDisplayField4'))){
        	 form.down('#personAddressDisplayField4').setDisabled(true);
        }
    },
    editResearchDetails:function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid){
    	var $this = this;
    	/*
		 * var personProfile = $this.getContentPanelActiveTab(); var grid =
		 * personProfile.down(gridItemId);
		 */
    	var form;
    	if (grid.getSelectionModel().getCount() > 0) {
    		if(this.getCurrentLoggedPortalId() == 2){
    			var contentpanel = $this.getContentPanel();
    			var researchtypeformtab = Ext.widget('researchtypeform',{
    				itemId:'researchtypeformfacultyportal'
    			});
    			var tabName = getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
    			openTab(contentpanel, tabName, researchtypeformtab,CONSTANTS.MENU_COLOR_THREE);
    			form = $this.getPersonResearchTypeFormFacultyPortal();
    		}else if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
    			var contentpanel = $this.getContentPanel();
    			var researchtypeformtab = Ext.widget('researchtypeform',{
    				itemId:'researchtypeformstudentportal'
    			});
    			var tabName = getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
    			openTab(contentpanel, tabName, researchtypeformtab,CONSTANTS.MENU_COLOR_SEVEN);
    			form = $this.getPersonResearchTypeFormStudentPortal();
    		}else{
    			$this.showResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    			form = $this.getPersonResearchTypeForm();
    		}

    		
    		var records = grid.getSelectionModel().getSelection()[0];
    		if (!isEmpty(records)) {
    			if(!isNullOrEmpty(records.data.dateOfUCSubmission))
    	           	records.data.dateOfUCSubmission = new Date(records.data.dateOfUCSubmission);
    			if(!isNullOrEmpty(records.data.researchDate))
    	           	records.data.researchDate = new Date(records.data.researchDate);
    			if(!isNullOrEmpty(records.data.yearOfPublication))
    	           	records.data.yearOfPublication = new Date(records.data.yearOfPublication);
    			form.loadRecord(records);

    			if (records.get('whetherInstituteAffiliation') == true) {
    				form.down('#whetherInstituteAffiliationTrue').setValue(true);
    				form.down('#whetherInstituteAffiliationFalse').setValue(false);
    			} else {
    				form.down('#whetherInstituteAffiliationTrue').setValue(false);
    				form.down('#whetherInstituteAffiliationFalse').setValue(true);
    			}

    			if (records.get('whetherUCSubmitted') == true) {
    				form.down('#whetherUCSubmittedTrue').setValue(true);
    				form.down('#whetherUCSubmittedFalse').setValue(false);
    				form.down('#dateOfUCSubmission').setVisible(true);
    			} else {
    				form.down('#whetherUCSubmittedTrue').setValue(false);
    				form.down('#whetherUCSubmittedFalse').setValue(true);
    				form.down('#dateOfUCSubmission').setVisible(false);
    			}

    			var store = $this.getStore('personinfo.common.pasthistory.ResearchTypeDocumentGridStr');
    			store.getProxy().extraParams = {
    				personDocumentId : records.data.id
    			};
    			store.load();
    		}
    	} else {
             showWarningMessage(getPersonModuleTranslation('RESEARCH_TYPE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
    },

    viewResearchDetails: function(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid) {
    	var this$ = this;
        this$.editResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
        var form;
        if(this.getCurrentLoggedPortalId() == 2){
        	form = this$.getPersonResearchTypeFormFacultyPortal();	
        }else if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
        	form = this$.getPersonResearchTypeFormStudentPortal();	
        }else{
        	form = this$.getPersonResearchTypeForm();	
        }
        toggleReadOnlyFormItems(form.getForm(), true);
        form.down('#submitButtonId').setVisible(false);
        form.down('#cancelResetId').setVisible(false);
        form.down('#uploadDocItemId').setVisible(false);
        var researchtypedocument = form.down('#researchTypeDocument');
        if (researchtypedocument) {
        	var btnDelete = researchtypedocument.down('#btnDelete').setVisible(false);
        }
    },
    deleteResearchDetails: function(gridItemId, deleteUrl) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('RESEARCH_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,// SERVERURL.DELETE_PERSON_RESEARCH,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('RESEARCH_DETAILS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('RESEARCH_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
	 * Person Past Historoy Document save for Research Details Seminar Details
	 * 
	 */
    pastHistroyTypeDoceSave:function(docGrid,module,entityType){
    	var $this = this;
    	var isTransient = true;
    	var entityId;
    	$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',function(success,response,isCallBackTransient) {
    		var docData = {
    				'documentName':	response.name,
    				'path':response.path,
    				'type':response.type,
    				'createdBy':$this.getIdValueJson(response.createdBy.id,response.createdBy.value)
    		};
    		var store = docGrid.getStore();
    		store.add(docData);
    		if (docGrid.isHidden()&& store.data.items.length > 0) {
    			docGrid.setVisible(true);
    		}
    		$this.getDocumentController().closeDocumentFormWindow();
    	}, isTransient);
    },
    /**
	 * 
	 * Delete Doc
	 * 
	 */
    deleteDocument:function(obj,deleteUrl,gridItemId){
    	var $this =this;
    	var grid = obj.up('grid');
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('DOCUMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes') {
    				var store = grid.getStore();
    				var record = grid.getSelectionModel().getSelection()[0];
    				var id = record.get("id");
    				if (!isNullOrEmpty(id)) {
    					Ext.Ajax.request({
    						method : "DELETE",
    						type : 'rest',
    						url : deleteUrl + '?id='+ id,
    						headers : {
    							'Content-Type' : 'application/json'
    						},
    						success : function(form,action) {
    							grid.getStore().reload();
    							if(gridItemId != undefined){
    								var personProfile = $this.getContentPanelActiveTab();
    								var personGrid = personProfile.down(gridItemId);
    								personGrid.getStore().reload();
    							}
    							showSuccessMessage(getCommonTranslation('DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
    						}
    					});
    				} else {
    					if (record) {
    						store.remove(record);
    					}
    				}  	
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('DOCUMENT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    	}
    },
    /**
	 * On click of grid hyperlink in research and seminar, load document grid
	 * 
	 */
    
    loadDocumnetGrid:function(record,grid){
    	var deleteButton = grid.down('#btnDelete');
    	deleteButton.setVisible(false);
    	deleteButton.setDisabled(true);
    	var store = grid.getStore();
    	store.getProxy().extraParams = {
    		personDocumentId : record.data.id
    	};
    	store.load();
    },
    	loadSupervisorGrid:function(record,grid){
    		var formWindow = this.getPatentdetailssupervisorrwindow();
            if (formWindow==undefined) {
				formWindow=	Ext.widget('patentdetailssupervisorrwindow');
			}
			var innergrid=formWindow.down('#patentDetailsSupervisorSsGrid');
			formWindow.show();
            var store = innergrid.getStore();
        	store.getProxy().extraParams = {
             patentdetailsId : record.data.id
		        	};
		    store.load();
		    
    },
    
			  /**
				 * Save Seminar Type
				 * 
				 * @param gridItemId
				 * @param saveUrl
				 * @param updateUrl
				 */
			saveSeminarType: function(gridItemId, saveUrl, updateUrl,docGrid) {

		        var this$ = this;
		        var form = this$.getPersonSeminarDetailsForm();
		        form.down('#submitButtonId').setDisabled(true);
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        var submitUrl, isUpdate = false;
		        var id = form.down('#seminar_hidden_field');
		        if (isNullOrEmpty(id.getSubmitValue())) {
		            submitUrl = saveUrl;// SERVERURL.SEMINAR_CREATE,
		            isUpdate = false;
		        } else {
		            submitUrl = updateUrl;// SERVERURL.SEMINAR_UPDATE,
		            isUpdate = true;
		        }
		        var jsonFormatFormData = this$.getJsonPastHistorySubmitData(form,docGrid);
		        this$.applyWindowMask(); 
		        
		        this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
		        	this$.hideWindowMask();
		        	if(success){
		        		this$.closePersonCommonWindow();
		                grid.getStore().reload();
		                grid.getSelectionModel().deselectAll();
		                if (isUpdate) {
		                    showSuccessMessage(getPersonModuleTranslation('SEMINAR_DETAILS'), getPersonModuleTranslation('SEMINAR_TYPE_UPDATE_SUCCESS'));
		                } else {
		                    showSuccessMessage(getPersonModuleTranslation('SEMINAR_DETAILS'), getPersonModuleTranslation('SEMINAR_TYPE_ADD_SUCCESS'));
		                }
		    		}else{
		    			this$.closePersonCommonWindow();
		                grid.getStore().reload();
		                form.down('#submitButtonId').setDisabled(false);
		    		}
		        });
		    },
		    /**
			 * Edit Seminar Type
			 * 
			 * @param informationType
			 * @param formItemId
			 * @param gridItemId
			 */
		    editSeminarType: function(informationType, formItemId, gridItemId) {

		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        if (grid.getSelectionModel().getCount() > 0) {
		        	this.showPersonCommonWindow(informationType, formItemId);
		        	var form = this$.getPersonSeminarDetailsForm();
		            var records = grid.getSelectionModel().getSelection()[0];
		            if (!isEmpty(records)) {
		    			if(!isNullOrEmpty(records.data.fromDate))
		    	           	records.data.fromDate = new Date(records.data.fromDate);
		    			if(!isNullOrEmpty(records.data.toDate))
		    	           	records.data.toDate = new Date(records.data.toDate);
		                form.loadRecord(records);
		                
		                var store = this$.getStore('personinfo.common.pasthistory.SeminarTypeDocumentGridStr');
						  store.getProxy().extraParams = {
							  personDocumentId : records.data.id
						 };
						  store.load();
		            }
		        } else {
		            showWarningMessage(getPersonModuleTranslation('SEMINAR_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    },
		    /**
			 * View Seminar Type
			 * 
			 * @param informationType
			 * @param formItemId
			 * @param gridItemId
			 */
		    viewSeminarType: function(informationType, formItemId, gridItemId) {
		    	var this$ = this;
		        this$.editSeminarType(informationType, formItemId, gridItemId);
		        var form = this$.getPersonSeminarDetailsForm();
		        this$.viewPersonCommonWindow(form);
		        form.down('#uploadDocItemId').setVisible(false);
		        var seminarTypeDocument = form.down('#seminarTypeDocument');
		        if (seminarTypeDocument) {
		        	var btnDelete = seminarTypeDocument.down('#btnDelete').setVisible(false);
		        }
		    },
		    /**
			 * Delete Seminat Type
			 * 
			 * @param gridItemId
			 * @param deleteUrl
			 */
		    deleteSeminarType: function(gridItemId, deleteUrl) {

		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        if (grid.getSelectionModel().getCount() > 0) {
		            showConfirmMessage(getPersonModuleTranslation('SEMINAR_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		                if (btn == 'yes') {
		                    if (grid.getSelectionModel().getCount() > 0) {
		                        var records = grid.getSelectionModel().getSelection();
		                        for (var count = 0; count < records.length; count++) {
		                            var id = "";
		                            if (!isNullOrEmpty(records[count].get("id"))) {
		                                id = records[count].get("id");
		                            }
		                            Ext.Ajax.request({
		                                type: 'rest',
		                                url: deleteUrl,  // SERVERURL.SEMINAR_DELETE
															// + id,
		                                method: 'DELETE',
		                                headers: {
		                                    'Content-Type': 'application/json'
		                                },
		                                params: {
		                                    id: id
		                                },
		                                success: function(form, action) {
		                                    grid.getStore().reload();
		                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('SEMINAR_TYPE_DELETE_SUCCESS'));
		                                }
		                            });
		                        }
		                    }
		                }
		            });
		        } else {
		            showWarningMessage(getPersonModuleTranslation('SEMINAR_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    },
		    getTrainingJsonPastHistorySubmitData: function(form,docGrid) {
		    	var this$ = this;
		    	var jsonFormFieldData = new Object();
		    	var formData = form.getValues();
		    	if (!isEmpty(formData)) {
		    		// var personObj = this$.getPersonObj();
		    		var personObj;
		            
		    		if(this.getCurrentLoggedPortalId() ==7){
		            	var personId = this.getCurrentlyLoggedInUserInfoForPortal().student.person.id;
		            	if(!isNullOrEmpty(personId))
		            	{
		            		personObj= {
		            				id:personId
		            		};
		            	}
		            }else{
		            	if(this.getCurrentLoggedPortalId() == 2 ||  this.getCurrentLoggedPortalId() ==3 ){
			            	var personId = this.getCurrentlyLoggedInUserWithPersonId().personId;
			            	personObj= {
			            			id:personId
			            	};

			           }else{
			        	   personObj = this$.getPersonObj();	
			          	}
		            }
		    		
		    		formData.person = personObj;
		    		if(!isNullOrEmpty(formData.person.personType)){
		    			delete formData.person.personType;
		    		}
		    		if(isNullOrEmpty(formData.conferenceType)){
		    			delete formData.conferenceType;
		    		}
		    	}
		    	
// if(!docGrid && docGrid != null){
		    		var docStore = docGrid.getStore();
		    		var docArray = [];
		    		if (docStore.data.items != null && docStore.data.items.length > 0) {
		    			Ext.each(docStore.data.items, function(val) {
		    				var newData = {
		    						"name" : val.data.documentName,
		    						"path" : val.data.path,
		    						"type" : val.data.type,
		    						"createdBy" : this$.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
		    				};
		    				if(val.data.documentId==""){
		    					docArray.push(newData);  
		    				}
		    			});
		    		}
		    		formData.documents = docArray;		
// }
		    		var isAddressPresent = false;
		    		try{
		    			if(form.getForm().getCode() != null && form.getForm().getCode() != undefined){
		    				isAddressPresent = true;
		    			}
		    		}catch(err){
		    			isAddressPresent = false;
		    		}
		    		
		    		// if (typeof form.getForm().getCode() !== "undefined") {
		    			if(isAddressPresent){
				        	// console.log(form.getForm().getCode());
				        	formData.address = form.getForm().getCode().data;
				        	delete formData.address.addressType;
				        	delete formData.address.isLegalAddress;
				        	delete formData.address.cf1;
				        	delete formData.address.cf2;
				        	delete formData.address.cf3;
				        	delete formData.address.cf4;
				        	delete formData.address.cf5;
				        	delete formData.address.cf6;
				        	delete formData.address.cf7;
				        	delete formData.address.cf8;
				        	delete formData.address.cf9;
				        	delete formData.address.cf10;
				        	delete formData.address.cf11;
				        	delete formData.address.cf12;
				        	delete formData.address.cf13;
				        	delete formData.address.cf14;
				        	delete formData.address.cf15;
				        	delete formData.address.cf16;
				        	delete formData.address.cf17;
				        	delete formData.address.cf18;
				        	delete formData.address.cf19;
				        	if(isNullOrEmpty(formData.address.pincodeNew)){
				        		delete formData.address.pincodeNew;
				        	}
				        	if(isNullOrEmpty(formData.address.customData)){
				        		delete formData.address.customData;
				        	}

				        }
		    		// }
		    		
	    			if (!isNullOrEmpty(formData.trainingStatus)) {
	    				var trainingStatusEnumCode = formData.trainingStatus.replace(" ", "_").toUpperCase();
	    				formData.trainingStatus = trainingStatusEnumCode;
	    			}
		    				
		    	jsonFormFieldData = Ext.encode(formData);
		    	return jsonFormFieldData;
		    
		    },
		    /**
			 * Get Json for form seminar Type
			 */
		    getJsonPastHistorySubmitData: function(form,docGrid) {
		    	var this$ = this;
		    	var jsonFormFieldData = new Object();
		    	var formData = form.getValues();
		    	if (!isEmpty(formData)) {
		    		var personObj = this$.getPersonObj();
		    		formData.person = personObj;
		    		if(!isNullOrEmpty(formData.person.personType)){
		    			delete formData.person.personType;
		    		}
		    		if(isNullOrEmpty(formData.conferenceType)){
		    			delete formData.conferenceType;
		    		}
		    	}
		    	// V2D-156069
		    	if(form.xtype != 'seminardetailsform') {
		    	var supervisor = formData.supervisor;
		    	 var supervisorIds = [];
		            for(var i in supervisor){
						  if(Ext.isObject(supervisor[0])){
							  supervisorIds.push({
		  					       "supervisorIds" : {
									  "id":supervisor[i].get("id")
							  }
		  				  });
					  }else{
						  supervisorIds.push({
							  "supervisorIds" :{
								  "id":supervisor[i]
							  }
						  });
						  formData.supervisorId = supervisorIds;
						  }
					  }
		            formData.supervisorId = supervisorIds;
		    	}
		    	
// if(!docGrid && docGrid != null){
		    		var docStore = docGrid.getStore();
		    		var docArray = [];
		    		if (docStore.data.items != null && docStore.data.items.length > 0) {
		    			Ext.each(docStore.data.items, function(val) {
		    				var newData = {
		    						"name" : val.data.documentName,
		    						"path" : val.data.path,
		    						"type" : val.data.type,
		    						"createdBy" : this$.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
		    				};
		    				if(val.data.documentId==""){
		    					docArray.push(newData);  
		    				}
		    			});
		    		}
		    		formData.documents = docArray;		
// }

			    var patentTypeSM = {
			    	id:formData.patentType
			    }
			    var supervisorIdData = formData.supervisor;
			    var superVisorList = [];
			    for(var i in supervisorIdData){
			    	if(!isNullOrEmpty(formData.supervisor[i].data)){
			    	var supervisor = {
			    			"supervisorIds":this$.getIdValueJson(formData.supervisor[i].data.id,formData.supervisor[i].data.value),
			    	}
			    }else{
			    		var supervisor = {
				    			"supervisorIds":this$.getIdValueJson(supervisorIdData[i]),
				    	}
			    	}
			    }
			    if(supervisorIdData!=undefined){
			    	superVisorList.push(supervisor);
			    }
			    delete formData.patentType;   // V2D-69824
			    delete formData.supervisor;
			    formData.patentTypeSM = patentTypeSM;
		    	jsonFormFieldData = Ext.encode(formData);
		    	return jsonFormFieldData;
		    },
		    /**
			 * Save Patent Type
			 * 
			 * @param gridItemId
			 * @param saveUrl
			 * @param updateUrl
			 */
		    savePatentType: function(gridItemId, saveUrl, updateUrl,docGrid) {

		        var this$ = this;
		        var form = this$.getPersonPatentDetailsForm();
		        form.down('#submitButtonId').setDisabled(true);
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        var submitUrl, isUpdate = false;
		        var id = form.down('#patent_hidden_field');
		        if (isNullOrEmpty(id.getSubmitValue())) {
		            submitUrl = saveUrl;// SERVERURL.SAVE_PATENT_TYPE,
		            isUpdate = false;
		        } else {
		            submitUrl = updateUrl;// SERVERURL.UPDATE_PATENT_TYPE,
		            isUpdate = true;
		        }
		        var jsonFormatFormData = this$.getJsonPastHistorySubmitData(form,docGrid);
		        this$.applyWindowMask(); 
		        
		        this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
		        	this$.hideWindowMask();
		        	
		        	if(success){
		        		this$.closePersonCommonWindow();
		                grid.getStore().reload();
		                grid.getSelectionModel().deselectAll();
		                if (isUpdate) {
		                    showSuccessMessage(getPersonModuleTranslation('PATENT_DETAILS'), getPersonModuleTranslation('PATENT_TYPE_UPDATE_SUCCESS'));
		                } else {
		                    showSuccessMessage(getPersonModuleTranslation('PATENT_DETAILS'), getPersonModuleTranslation('PATENT_TYPE_ADD_SUCCESS'));
		                }
		    		}else{
		    			this$.closePersonCommonWindow();
		                grid.getStore().reload();
		                form.down('#submitButtonId').setDisabled(false);
		    		}
		        });
		    },
		  
		 
		    /**
			 * Edit Patent Type
			 * 
			 * @param informationType
			 * @param formItemId
			 * @param gridItemId
			 */
		    editPatentType: function(informationType, formItemId, gridItemId) {

		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        if (grid.getSelectionModel().getCount() > 0) {
		        	this.showPersonCommonWindow(informationType, formItemId);
		        	var form = this$.getPersonPatentDetailsForm();
		        	var patentType = form.down("#patentTypeSMId");
		        	var supervisor = form.down("#supervisor");
		        	var supervisorComboStore = supervisor.getStore();
		            var records = grid.getSelectionModel().getSelection()[0];
		            if (!isEmpty(records)) {
		            	if(!isNullOrEmpty(records.data.patentTypeSM)){
		            		form.config.patentTypeId = records.data.patentTypeSM.id;
		            		var personId= this$.getPersonObj().id;
		            		patentType.getStore().getProxy().extraParams = {
               					patentTypeId: records.data.patentTypeSM.id,
               					personId:personId
                            };
		            		patentType.getStore().load({
		                        callback: function(record, operation, success) {
		                        	patentType.setValue(records.data.patentTypeSM.id);
		                        }
		            		});
		            	}
		            	if(!isNullOrEmpty(records.data.supervisorId)){
		            		if(records.data.supervisorId.length>0){
		            		var personparentIds=[];
		            		supervisorComboStore.load({
	    						scope:this,
	    						callback: function(){
	    							supervisorComboStore.getProxy().extraParams = {
	    								supervisor:records.data.supervisorId[0].supervisorIds.id
	    	    					};
	    							if(!isNullOrEmpty(records.data.supervisorId)){
	                                    for(var i in records.data.supervisorId){
	  								  personparentIds.push(records.data.supervisorId[i].supervisorIds.id);
	  						       }
	                                    supervisor.setValue(personparentIds);
	    							
	    							}
	    						}
	    					});
		            		
		            	}
		            	}
		    			if(!isNullOrEmpty(records.data.dateOfPatentAwarded))
		    	           	records.data.dateOfPatentAwarded = new Date(records.data.dateOfPatentAwarded);
		    			if(!isNullOrEmpty(records.data.dateOfPatentFiled))
		    	           	records.data.dateOfPatentFiled = new Date(records.data.dateOfPatentFiled);
		    			if(!isNullOrEmpty(records.data.defenceDate)) {
		    	           	records.data.defenceDate = new Date(records.data.defenceDate);
		    			}
		                form.loadRecord(records);
		                
		                var store = this$.getStore('personinfo.common.pasthistory.PatentTypeDocumentGridStr');
						  store.getProxy().extraParams = {
							  personDocumentId : records.data.id
						 };
						  store.load();
		            }
		        } else {
		            showWarningMessage(getPersonModuleTranslation('PATENT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    },
		    /**
			 * View Patent Type
			 * 
			 * @param informationType
			 * @param formItemId
			 * @param gridItemId
			 */
		    viewPatentType: function(informationType, formItemId, gridItemId) {
		    	var this$ = this;
		        this$.editPatentType(informationType, formItemId, gridItemId);
		        var form = this$.getPersonPatentDetailsForm();
		        this$.viewPersonCommonWindow(form);
		        form.down('#uploadDocItemId').setVisible(false);
		        form.down('patenttypedocument').down('#btnDelete').setDisabled(true);
		    },
		    /**
			 * Delete Patent Type
			 * 
			 * @param gridItemId
			 * @param deleteUrl
			 */
		    deletePatentType: function(gridItemId, deleteUrl) {

		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        if (grid.getSelectionModel().getCount() > 0) {
		            showConfirmMessage(getPersonModuleTranslation('PATENT_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		                if (btn == 'yes') {
		                    if (grid.getSelectionModel().getCount() > 0) {
		                        var records = grid.getSelectionModel().getSelection();
		                        for (var count = 0; count < records.length; count++) {
		                            var id = "";
		                            if (!isNullOrEmpty(records[count].get("id"))) {
		                                id = records[count].get("id");
		                            }
		                            Ext.Ajax.request({
		                                type: 'rest',
		                                url: deleteUrl,  // SERVERURL.DELETE_PATENT_TYPE
															// + id,
		                                method: 'DELETE',
		                                headers: {
		                                    'Content-Type': 'application/json'
		                                },
		                                params: {
		                                    id: id
		                                },
		                                success: function(form, action) {
		                                    grid.getStore().reload();
		                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PATENT_TYPE_DELETE_SUCCESS'));
		                                }
		                            });
		                        }
		                    }
		                }
		            });
		        } else {
		            showWarningMessage(getPersonModuleTranslation('PATENT_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    }, /**
				 * Save Training Type
				 * 
				 * @param gridItemId
				 * @param saveUrl
				 * @param updateUrl
				 */
		    saveTrainingType: function(grid,gridItemId,form, saveUrl, updateUrl,docGrid) {

		        var this$ = this;
		        // var form = this.getPersonTrainingDetailsForm();
		        // var personProfile = this$.getContentPanelActiveTab();
		        // var grid = personProfile.down(gridItemId);
		        form.down('#submitButtonId').setDisabled(true);
		        var submitUrl, isUpdate = false;
		        var id = form.down('#training_hidden_field');
		        if (isNullOrEmpty(id.getSubmitValue())) {
		            submitUrl = saveUrl;// SERVERURL.CREATE_TRAINING_DETAILS,
		            isUpdate = false;
		        } else {
		            submitUrl = updateUrl;// SERVERURL.UPDATE_TRAINING_DETAILS,
		            isUpdate = true;
		        }
		        // var jsonFormatFormData =
				// this$.getJsonPastHistorySubmitData(form,docGrid);
		        var jsonFormatFormData = this$.getTrainingJsonPastHistorySubmitData(form,docGrid);
		        
		        // this$.applyWindowMask();
		        // var y = xyz.i;
		        this$.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
		        	// this$.hideWindowMask();
		        	if(success){
		        		// this$.closePersonCommonWindow();
		        		if(this$.getCurrentLoggedPortalId() == 2){
		              		var activeTab = this$.getPersonTrainingDetailsForm().up('panel');
		       			 	this$.closeTab(activeTab);	
		              	}else if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
		              		var activeTab = this$.getPersonTrainingDetailsForm().up('panel');
		       			 	this$.closeTab(activeTab);
		              	}else{
		              		var activeTab = this$.getPersonTrainingDetailsForm().up('panel');
		       			 	this$.closeTab(activeTab);	
		              	}
		                grid.getStore().reload();
		                grid.getSelectionModel().deselectAll();
		                if (isUpdate) {
		                    showSuccessMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getPersonModuleTranslation('TRAINING_TYPE_UPDATE_SUCCESS'));
		                } else {
		                    showSuccessMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getPersonModuleTranslation('TRAINING_TYPE_ADD_SUCCESS'));
		                }
		    		}else{
		    			// this$.closePersonCommonWindow();
		                grid.getStore().reload();
		                form.down('#submitButtonId').setDisabled(false);
		    		}
		        });
		    },
		    /**
			 * Edit Training Type
			 * 
			 * @param informationType
			 * @param gridItemId
			 */
		    editTrainingType: function(informationType, formItemId, gridItemId) {

		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        if (grid.getSelectionModel().getCount() > 0) {
		        	this.showPersonCommonWindow(informationType, formItemId);
		        	var form = this.getPersonTrainingDetailsForm();
		            var records = grid.getSelectionModel().getSelection()[0];
		            if (!isEmpty(records)) {
		    			if(!isNullOrEmpty(records.data.fromDate))
		    	           	records.data.fromDate = new Date(records.data.fromDate);
		    			if(!isNullOrEmpty(records.data.toDate))
		    	           	records.data.toDate = new Date(records.data.toDate);
		                form.loadRecord(records);
		                
		                var store = this$.getStore('personinfo.common.pasthistory.TrainingTypeDocumentGridStr');
						  store.getProxy().extraParams = {
							  personDocumentId : records.data.id
						 };
						  store.load();
		            }
		        } else {
		            showWarningMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    },
		    /**
			 * View Training Type
			 * 
			 * @param informationType
			 * @param formItemId
			 * @param gridItemId
			 */
		    viewTrainingType: function(informationType, formItemId, gridItemId) {
		    	var this$ = this;
		        this$.editTrainingType(informationType, formItemId, gridItemId);
		        var form = this.getPersonTrainingDetailsForm();
		        this$.viewPersonCommonWindow(form);
		        form.down('#uploadDocItemId').setVisible(false);
		    },
		    /**
			 * Delete Training Type
			 * 
			 * @param gridItemId
			 * @param deleteUrl
			 */
		    deleteTrainingType: function(gridItemId, deleteUrl) {

		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var grid = personProfile.down(gridItemId);

		        if (grid.getSelectionModel().getCount() > 0) {
		            showConfirmMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		                if (btn == 'yes') {
		                    if (grid.getSelectionModel().getCount() > 0) {
		                        var records = grid.getSelectionModel().getSelection();
		                        for (var count = 0; count < records.length; count++) {
		                            var id = "";
		                            if (!isNullOrEmpty(records[count].get("id"))) {
		                                id = records[count].get("id");
		                            }
		                            Ext.Ajax.request({
		                                type: 'rest',
		                                url: deleteUrl,  // SERVERURL.DELETE_TRAINING_DETAILS
															// + id,
		                                method: 'DELETE',
		                                headers: {
		                                    'Content-Type': 'application/json'
		                                },
		                                params: {
		                                    id: id
		                                },
		                                success: function(form, action) {
		                                    grid.getStore().reload();
		                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('TRAINING_TYPE_DELETE_SUCCESS'));
		                                }
		                            });
		                        }
		                    }
		                }
		            });
		        } else {
		            showWarningMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		        }
		    },
    getDocumentController : function() {
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    getIdValueJson: function(id, value,code) {
    	if (id) return {
    		id: id,
    		value: value,
    		code: code
    	};
    },
    getIdOnlyJson: function(id) {
    	if (id) return {
    		id: id,
    	};
    },
    closeTab : function(tabReference) {
   	 tabReference.close();
    },
    showHideGradeMarkFileds : function(combo, records, eOpts){
    	 var this$ = this;
         var form = this$.getPersonEducationForm();
         var value = combo.getValue();
         
         var gradeObtained = form.down("#gradeObtained");
         var marksObtained = form.down("#marksObtained");
         var maximumMarks = form.down("#maximumMarks");
         
         gradeObtained.setVisible(false);
         marksObtained.setVisible(false);
         maximumMarks.setVisible(false);
         
         gradeObtained.reset();
         marksObtained.reset();
         maximumMarks.reset();
         
         if(value=='MARKS'){
        	 marksObtained.setVisible(true);
        	 maximumMarks.setVisible(true);
         }else{
        	 gradeObtained.setVisible(true);
         }
    },
    shoHideMarksDeatilFields : function(combo, records, eOpts){
    	 var form = this.getPersonEducationForm();
         var value = combo.getValue();
         
         var marksgradecontainer = form.down("#marksgradecontainerId");
         marksgradecontainer.setVisible(true);
         var marksObtained = form.down("#marksObtained");
         var maximumMarks = form.down("#maximumMarks");
         
         if(value==3){
        	 form.down("#gradeMark").reset();
        	 form.down("#gradeObtained").reset();
        	 form.down("#maximumMarks").reset();
        	 form.down("#marksObtained").reset();
        	 form.down("#percentage").reset();
        	 marksgradecontainer.setVisible(false);
         }
    },
    
    extraCurricularActivityFormRender: function() {
		 var form = this.getPersonExtraCurricularForm();
		 
		 var EventByNameUrl = SERVERURL.FIND_ALL_EVENT_NAME_BY_NAME;
	   	 Ext.Ajax.request({
	   		 type : 'rest',
	   		 url : EventByNameUrl,
	   		 params : {
	   			eventName:'OTHEREVENT'
	   		 },
	   		 method : 'GET',
	   		 success : function(response, action) {
	   			 var text = Ext.decode(response.responseText);
	   			 var eventId = form.getForm().findField('eventId').setValue(text[0].id);
	   			 eventId.getStore().load();
	   		 }
	   	 });
	 },
	 onRenderMedicalDetailsForm: function(geturl) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 try {
			 personProfile.getPersonId();
		 } catch(e){
			 personProfile = this$.getContentPanel().items.items[0];
		 }
		 var personId = personProfile.getPersonId();
		 if (!isNullOrEmpty(personId)) {
			 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			 var url = geturl + personId;
			 this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
				 Ext.getBody().unmask();
				 if (success) {
					 if (!isNullOrEmpty(response.responseText)) {
						 var data = Ext.decode(response.responseText);
						 if (!isEmpty(data)) {
							 if (!isNullOrEmpty(data.validTill))
								 data.validTill = new Date(data.validTill);
							 this$.setValueToMedicalDetailsForm(data);
						 }
					 }
					 var personProfile = this$.getContentPanelActiveTab();
					 var personalInformationForm = personProfile.down('medicaldetailsform');
					 if (personalInformationForm) {
						 var countryCodeFieldItemIDArray = ["#familyPractionerCountryCodeItemId"];
		         		 this$.setDefaultCountryCode(personalInformationForm, countryCodeFieldItemIDArray);
		         		 var countryCodeField = personalInformationForm.down("#familyPractionerCountryCodeItemId");
						 var mobileField = personalInformationForm.down("#familyPractionerContactNumberItemId");
						 this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
					 }
				 }
			 });
		 }
	 },
	 setValueToMedicalDetailsForm: function(data) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 var personalInformationForm = personProfile.down('medicaldetailsform');// this.getPersonMedicalDetailsForm();
		 if (personalInformationForm) {
			 personalInformationForm.getForm().setValues(data);
			 var availableDocumentLabelItemId = personalInformationForm.down('#availableDocumentLabelItemId');
			 if(!isNullOrEmpty(data) && !isNullOrEmpty(data.medicalAidDocument)) {
				 if(!isNullOrEmpty(data.medicalAidDocument.id)) {
					 var documentIdItemId = personalInformationForm.down('#documentIdItemId');
					 documentIdItemId.setValue(data.medicalAidDocument.id);
				 }
				 availableDocumentLabelItemId.setVisible(true); 
			 } else {
				 availableDocumentLabelItemId.setVisible(false); 
			 }
		 }
	 },
	 saveMedicalDetails: function(saveUrl, getUrl) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 var form = personProfile.down('medicaldetailsform');// this$.getPersonMedicalDetailsForm();
		 var medicalAidDocumentItemId = form.down('#medicalAidDocumentItemId');
		 var medicalAidDocumentPath = medicalAidDocumentItemId.getValue();

		 var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
		 if (!isNullOrEmpty(medicalAidDocumentPath)) {
			 form.getForm().submit({
				 method: 'POST',
				 url: uplaodUrl,
				 success: function(form1, action) {
					 // callback(true);
					 var responseData = Ext.decode(action.response.responseText);
					 var path = responseData.path;
					 form.getForm().findField('medicalAidDocumentUploadPath').setValue(path);
					 this$.saveMedicalDetailsRecord(saveUrl, getUrl, form);
				 },
				 failure: function() {
					 console.log('hello');
				 }
			 });
		 } else {
			 this$.saveMedicalDetailsRecord(saveUrl, getUrl, form);
		 }
	 },
	 saveMedicalDetailsRecord: function(saveUrl, getUrl, form) {
		 var this$ = this;
		 var values = form.getForm().getValues();

		 var path = form.getForm().findField('medicalAidDocumentUploadPath').getValue();
		 var jsonFormatFormData = this$.getJsonMedicalDetailsSubmitData(form, path);

		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 this$.sendSaveAjaxRequest(saveUrl, 'PUT', jsonFormatFormData, function(option, success, response) {
			 Ext.getBody().unmask();
			 if (success, form) {
				 this$.onRenderMedicalDetailsForm(getUrl);
				 showSuccessMessage(getPersonModuleTranslation('MD_MEDICAL_DETAILS'), getPersonModuleTranslation('MD_MEDICAL_DETAILS_ADD_SUCCESS'));
			 }
		 });
	 },
	 
	 customloadGridStore: function(gridItemId, url,portalgrid) {
		 var this$ = this;
		 var grid;
		 var userId;
		 if(this.getCurrentLoggedPortalId() == 2 || this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
			 grid = portalgrid;
			 userId = this$.getCurrentlyLoggedInUser().id;
			 if(this.getCurrentLoggedPortalId() == 7){
				 var portalInfo = Academia.model.authentication.PortalInfoModel;
				 var student = portalInfo.get('student');
				 userId = student.id
			 }
		 }else{
			 var personProfile = this$.getContentPanelActiveTab();
			 userId = this$.getContentPanelActiveTab().getUserId();
			 grid = personProfile.down(gridItemId);
		 }

		 if (grid) {
			 var store = grid.getStore();
			 store.getProxy().api.read = url;
			 store.getProxy().extraParams = {
				 userId: userId
			 };
			 store.load();
		 }},
	 getJsonMedicalDetailsSubmitData: function(form, path) {
		 var this$ = this;
		 var jsonFormFieldData = new Object();
		 var formData = form.getValues();
		 if (!isEmpty(formData)) {
			 var personObj = this$.getPersonObj();
			 formData.person = personObj;
			 
			 var userId = this.getCurrentlyLoggedInUser().id;
			 user = {
					 id: userId
			 };
			 if (!isNullOrEmpty(path)) {
				 var fileName = path.substring(path.lastIndexOf('/') + 1, path.length);
				 var doc = {
						 path: path,
						 name: fileName,
						 type: 'DOCUMENT',
						 createdBy: user
				 };
				 formData.medicalAidDocument = doc;
			 } else {
				 formData.medicalAidDocument = null;
			 }
		 }
		 delete formData.medicalAidDocumentUploadPath;
		 delete formData.module;
		 delete formData.documentId;
		 delete formData.person.personType;
		 jsonFormFieldData = Ext.encode(formData);
		 return jsonFormFieldData;
	 },
	 addChurchEmploymentHistory: function(obj){
		 var this$ = this;
		 var form = this$.getPersonChurchInformationForm();
		 var stopContiner = form.down('#employmentHistoryContainerId');
		 var from = this$.getPersonChurchInformationForm().getForm();
		 var panelItem = new Array();
		 var fieldContainer=obj.up('fieldcontainer');
		 var newcont=stopContiner.items.items.length;
		 var insertPosition=newcont+1;
		 panelItem.push({
			 xtype : 'fieldcontainer',
			 width: '100%',
			 layout : 'hbox',
			 defaults: {
				 labelAlign: 'top',
			 },
			 items : [{
				 xtype: 'hidden',
				 itemId: 'churchEmploymenthistory_hidden_field',
				 name: 'historyId'
			 },{
				 xtype: 'textfield',
				 name: 'position',
				 itemId:'position' + insertPosition,
				 width: 150,
				 maxLength:50,
// fieldLabel: getPersonModuleTranslation('POSITION'),
				 allowBlank: true
			 },  
			 {
				 xtype: 'customcombobox',
// fieldLabel: getPersonModuleTranslation('COUNTRY'),
				 store: 'common.CountryStore',
				 itemId: 'countryCombo' + insertPosition,
				 width: 150,
				 valueField: 'id',
				 displayField: 'countryName',
				 name: 'country',
// queryMode: 'remote',
				 editable: false,
			 },{
				 xtype: 'datefield',
				 name: 'fromDate',
				 itemId: 'requestFromDateId' + insertPosition,
				 width: 150,
// fieldLabel: getCommonTranslation('FROM_DATE'),
				 editable: true,
				 maxValue: new Date(),
				 vtype: 'daterange',
				 endDateField: 'requestToDateId' + insertPosition,
				 // --submitFormat: CONSTANTS.DATE_FORMAT,
    			 // format: CONSTANTS.DATE_FORMAT,
				 listeners: {
					 render: function(field) {
						 return dateFormatRender(field);
					 }
				 }
			 },{
				 xtype: 'datefield',
				 name: 'toDate',
				 itemId: 'requestToDateId' + insertPosition,
				 width: 150,
// fieldLabel: getCommonTranslation('TO_DATE'),
				 editable: true,
				 maxValue: new Date(),
				 vtype: 'daterange',
				 startDateField: 'requestFromDateId' + insertPosition,
				 // --submitFormat: CONSTANTS.DATE_FORMAT,
				 // format: CONSTANTS.DATE_FORMAT,
				 listeners: {
					 render: function(field) {
						 return dateFormatRender(field);
					 }
				 }
			 },{
				 xtype: 'button',
				 itemId: 'delFilterBtn',
				 cls: 'CustomBodyBtnReject',
				 glyph: ICONGLYPH.DELETEGLYPH,
				 tooltip: getCommonTranslation('DELETE'),
				 /*
					 * style:{ marginTop:'30px' },
					 */
				 listeners:{
					 click:function(obj){
						 var container = obj.up('fieldcontainer');
						 var panelContiner = this$.getPersonChurchInformationForm().down('#employmentHistoryContainerId');
						 panelContiner.remove(container);
					 }}
			 },{
				 xtype: 'button',
				 itemId: 'btnAddEmploymentHistory',
				 cls: 'CustomBodyBtnSettings',
				 text: getCommonTranslation('ADDBUTTONTEXT'),
				 tooltip: getCommonTranslation('ADD'),
				 /*
					 * style:{ marginTop:'30px' }
					 */
			 }]
		 });
		 stopContiner.insert(insertPosition,panelItem);
		 stopContiner.doLayout();
	 },
	 
	 /**
		 * Save church information
		 * 
		 * @param gridItemId
		 * @param saveUrl
		 * @param updateUrl
		 */
	 saveChurchInfo: function(gridItemId, saveUrl, updateUrl) {
		 var this$ = this;
	        var form = this$.getPersonChurchInformationForm();
	        var personProfile = this$.getContentPanelActiveTab();
	        var grid = personProfile.down(gridItemId);
	        
	        var submitUrl, isUpdate = false;
	        var id = form.down('#churchInfo_hidden_field');
	        var jsonFormatFormData;
	        if (isNullOrEmpty(id.getSubmitValue())) {
	            submitUrl = saveUrl; 
	            isUpdate = false;
	            jsonFormatFormData = this$.getJsonChurchInfoData(form);
	        } else {
	            submitUrl = updateUrl; 
	            isUpdate = true;
	            jsonFormatFormData = this$.getJsonChurchInfoDataForUpdate(grid,form);
	        }
	        
	        this$.applyWindowMask(); 
	        form.down('#submitButtonId').setDisabled(true);
	        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
	        	this$.hideWindowMask();
	        	if(success){
	        		this$.closePersonCommonWindow();
	                grid.getStore().reload();
	                grid.getSelectionModel().deselectAll();
	                if (isUpdate) {
	                    showSuccessMessage(getPersonModuleTranslation('CHURCH_INFORMATION'), getPersonModuleTranslation('CHURCH_INFORMATION_UPDATE_SUCCESS'));
	                } else {
	                    showSuccessMessage(getPersonModuleTranslation('CHURCH_INFORMATION'), getPersonModuleTranslation('CHURCH_INFORMATION_ADD_SUCCESS'));
	                }
	    		}else{
	    			this$.closePersonCommonWindow();
	                grid.getStore().reload();
	    		}
	        	this$.resetPageSetting(grid.getStore());
	        });
	    },
	    /**
		 * View NonAcademicAchievements
		 * 
		 * @param gridItemId
		 * @param saveUrl
		 * @param updateUrl
		 */
	    viewNonAcademicAchievementsInfoForm:function(informationType, formItemId, gridItemId){
	    	var this$ = this;
	    	this$.editNonAcademicAchievementsInfoForm(informationType, formItemId, gridItemId,true);
	    	var form = this$.getNonacademicachievementsform();
	    	this$.viewPersonCommonWindowNonAcademicAchievements(form);
	    },
	    viewFacultyNonAcademicAchievementsInfoForm:function(informationType, formItemId, gridItemId){
	    	var this$ = this;
	    	this$.editFacultyNonAcademicAchievementsInfoForm(informationType, formItemId, gridItemId,true);
	    	var form = this$.getFacultynonacademicachievementsform();
	    	this$.FacultyViewPersonCommonWindow(form);
	    	
	    },
	    
	    /**
		 * DELETE NonAcademicAchievements
		 * 
		 * @param gridItemId
		 * @param saveUrl
		 * @param updateUrl
		 */
	    deleteNonAcademicAchievementsInfoRecord:function(gridItemId,deleteUrl){
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var grid = personProfile.down(gridItemId);

	    	if (grid.getSelectionModel().getCount() > 0) {
	    		showConfirmMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    			if (btn == 'yes') {
	    				if (grid.getSelectionModel().getCount() > 0) {
	    					var records = grid.getSelectionModel().getSelection();
	    					for (var count = 0; count < records.length; count++) {
	    						var id = "";
	    						if (!isNullOrEmpty(records[count].get("id"))) {
	    							var personId=null;
	    							var applicantPersonId=null;
	    							id=records[count].get("id");
	    							var personObj = this$.getPersonObj();
	    							delete personObj["personType"];
	    							if(gridItemId=="#applicantnonacademicachievementsgridItemId"){// applicant
	    								applicantPersonId=personObj;
	    							}else{// student
	    								personId=personObj;
	    							}
	    						}
	    						Ext.Ajax.request({
	    							type: 'rest',
	    							url: deleteUrl, 
	    							method: 'DELETE',
	    							headers: {
	    								'Content-Type': 'application/json'
	    							},
	    							params: {
	    								id:id,
	    								personId: personId,
	    								applicantPersonId:applicantPersonId
	    							},
	    							success: function(form, action) {
	    								grid.getStore().reload();
	    								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS_DELETE_SUCCESSFULLY'));
	    							}
	    						});
	    					}
	    				}
	    			}
	    		});
	    	} else {
	    		showWarningMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}

	    },
	    
	    /**
		 * edit NonAcademicAchievements
		 * 
		 * @param gridItemId
		 * @param saveUrl
		 * @param updateUrl
		 */
	    editNonAcademicAchievementsInfoForm:function(informationType, formItemId, gridItemId){
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var grid = personProfile.down(gridItemId);

	    	if (grid.getSelectionModel().getCount() > 0) {
	    		this.showPersonCommonWindow(informationType, formItemId);
	    		var form = this$.getNonacademicachievementsform();
	    		var records = grid.getSelectionModel().getSelection()[0];
	    		if (!isEmpty(records)) {
	    			form.loadRecord(records);
	    			var sportEvent=form.down('#sportEvent');
	    			var levelEvent=form.down('#levelEvent');
	    			
	    			/*
					 * var membershipArray=new Array(); for(var i in
					 * records.data.churchMembershipStatusMappings){ var
					 * id=records.data.churchMembershipStatusMappings[i].membershipStatus.id;
					 * membershipArray.push(id); }
					 */
	    			/*
					 * sportEvent.getStore().load({ callback:function(){
					 * sportEvent.setValue(sportEvent); } });
					 * 
					 * 
					 * levelEvent.getStore().load({ callback:function(){
					 * levelEvent.setValue(levelEvent); } });
					 */


	    			/*
					 * var addFilterBtn = form.down('#btnAddEmploymentHistory');
					 * var employmentHistoryContainer =
					 * form.down('#employmentHistoryContainerId'); var
					 * employeeHistoryData=records.data.churchEmployments; if
					 * (employeeHistoryData != null &&
					 * employeeHistoryData.length > 0) { for (var j = 0; j <
					 * employeeHistoryData.length - 1; j++) {
					 * this$.addChurchEmploymentHistory(addFilterBtn); }
					 * 
					 * for (var j = 0; j < employeeHistoryData.length; j++) {
					 * var employmentHistoryPanelContainer =
					 * employmentHistoryContainer.items.items[j];
					 * employmentHistoryPanelContainer.items.items[0].setValue(employeeHistoryData[j].id);
					 * employmentHistoryPanelContainer.items.items[1].setValue(employeeHistoryData[j].position);
					 * if(!isNullOrEmpty(employeeHistoryData[j].country) &&
					 * !isNullOrEmpty(employeeHistoryData[j].country.id)){
					 * employmentHistoryPanelContainer.items.items[2].setValue(employeeHistoryData[j].country.id); }
					 * employmentHistoryPanelContainer.items.items[3].setValue(dateRender(employeeHistoryData[j].fromDate));
					 * employmentHistoryPanelContainer.items.items[4].setValue(dateRender(employeeHistoryData[j].toDate));
					 * if(isView){
					 * employmentHistoryPanelContainer.items.items[5].setDisabled(true);
					 * if(!isNullOrEmpty(employmentHistoryPanelContainer.items.items[6])){
					 * employmentHistoryPanelContainer.items.items[6].setDisabled(true); } } }
					 * }else{ addFilterBtn.setDisabled(true); }
					 */

	    		} 
	    	}else {
	    		showWarningMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    	    editFacultyNonAcademicAchievementsInfoForm:function(informationType, formItemId, gridItemId){
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var grid = personProfile.down(gridItemId);

	    	if (grid.getSelectionModel().getCount() > 0) {
	    		this.showPersonCommonWindow(informationType, formItemId);
	    		var form = this$.getFacultynonacademicachievementsform();
	    		var records = grid.getSelectionModel().getSelection()[0];
	    		if (!isEmpty(records)) {
	    			
	    			form.loadRecord(records);
	    			var sportEvent=form.down('#sportEvent');
	    			var levelEvent=form.down('#levelEvent');
	    		} 
	    	}else {
	    		showWarningMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    
	     /**
			 * Save NonAcademicAchievements Type
			 * 
			 * @param gridItemId
			 * @param saveUrl
			 * @param updateUrl
			 */
	    saveNonAcademicAchievementsForm:function(gridItemId, saveUrl, updateUrl,docGrid) {
             var this$ = this;
	        var form = this$.getNonacademicachievementsform();
	        var personProfile = this$.getContentPanelActiveTab();
	        var grid = personProfile.down(gridItemId);
            var methodtype = 'POST';
	        var submitUrl, isUpdate = false;
	        var id = form.down('#nonacademicachievement_hidden_field');
	        var jsonFormatFormData;
	        if (isNullOrEmpty(id.getSubmitValue())) {
	            submitUrl = saveUrl; 
	            isUpdate = false;
	            jsonFormatFormData = this$.getJsonNonAcademicAchievementData(form);
	        } else {
	            submitUrl = updateUrl; 
	            isUpdate = true;
	            methodtype = 'PUT';
	            jsonFormatFormData = this$.getJsonNonAcademicAchievementsInfoDataForUpdate(grid,form);
	        }
	        
	        this$.applyWindowMask(); 
	        this$.sendSaveAjaxRequest(submitUrl,methodtype, jsonFormatFormData, function(option, success, response) {
	        	this$.hideWindowMask();
	        	if(success){
	        		this$.closePersonCommonWindow();
	                grid.getStore().reload();
	                grid.getSelectionModel().deselectAll();
	                if (isUpdate) {
	                    showSuccessMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS_UPDATE_SUCCESSFULLY'));
	                } else {
	                    showSuccessMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS_ADD_SUCCESSFULLY'));
	                }
	                this$.resetPageSetting(grid.getStore());
	    		}
	        });
	    },
	   saveFacultyNonAcademicAchievementsForm:function(gridItemId, saveUrl, updateUrl,docGrid) {

	         var this$ = this;
	        var form = this$.getFacultynonacademicachievementsform();
	        var personProfile = this$.getContentPanelActiveTab();
	        var grid = personProfile.down(gridItemId);
            var methodtype = 'POST';
	        var submitUrl, isUpdate = false;
	        var id = form.down('#facultynonacademicachievement_hidden_field');
	        var jsonFormatFormData;
	        if (isNullOrEmpty(id.getSubmitValue())) {
	            submitUrl = saveUrl; 
	            isUpdate = false;
	            jsonFormatFormData = this$.getJsonNonAcademicAchievementData(form);
	        } else {
	            submitUrl = updateUrl; 
	            isUpdate = true;
	            methodtype = 'PUT';
	            jsonFormatFormData = this$.getJsonNonAcademicAchievementsInfoDataForUpdate(grid,form);
	        }
	        
	        this$.applyWindowMask(); 
	        this$.sendSaveAjaxRequest(submitUrl,methodtype, jsonFormatFormData, function(option, success, response) {
	        	this$.hideWindowMask();
	        	if(success,form){
	        		if (isNullOrEmpty(id.getSubmitValue())){
	            		var data = Ext.decode(response.responseText);
	            		if(isArray(data)){
	            			if(data[0].key == 'SPORT_EVENT_AND_LEVEL_EVENT_ALREADY_EXIST') {
	            				showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('SPORT_EVENT_AND_LEVEL_EVENT_ALREADY_EXIST'));
	            				return false;
	            			}
	            		}
	            	}if(isUpdate) {
	            			if(response.responseText == 'SPORT_EVENT_AND_LEVEL_EVENT_ALREADY_EXIST') {
	            				showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('SPORT_EVENT_AND_LEVEL_EVENT_ALREADY_EXIST'));
	            				return false;
	            			}else{
	    	                    showSuccessMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS_UPDATE_SUCCESSFULLY'));
	            		     }
	            	}
	        		this$.closePersonCommonWindow();
	                grid.getStore().reload();
	                grid.getSelectionModel().deselectAll();
	                if (isUpdate) {
	                    showSuccessMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS_UPDATE_SUCCESSFULLY'));
	                } else {
	                    showSuccessMessage(getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'), getCommonTranslation('NON_ACADEMIC_ACHIEVEMENTS_ADD_SUCCESSFULLY'));
	                }
	    		}else{
	    			this$.closePersonCommonWindow();
	                grid.getStore().reload();
	    		}
	        	this$.resetPageSetting(grid.getStore());
	        });
	    },
	    
	    
	    getJsonChurchInfoData: function(form) {
	    	var this$ = this;
	        var jsonFormFieldData = new Object();
	        var formData = form.getValues();
	        if (!isEmpty(formData)) {
	        	var personObj = this$.getPersonObj();
	        	delete personObj["personType"];
	        	if(form.itemId=="applicantChurchInfoForm"){// applicant
	        		formData.applicantPerson = personObj;	
	        	}else{// student
	        		formData.person = personObj;
	        	}
	        	var churchMembershipStatusMappings = new Array();
	        	if(!isNullOrEmpty(formData.membershipStatus)){
	        		for(var i in formData.membershipStatus){
	        			var obj=new Object();
	        			obj.membershipStatus={
	        					id:formData.membershipStatus[i].data.id
	        			};
	        			churchMembershipStatusMappings.push(obj);
	        		}	
	        	}
	        	var churchEmployments = new Array();
	        	var employeData=form.down('#employmentHistoryContainerId').items.items;
	        	if(employeData.length == 1){
	        		var temp1=new Object();
	        		if(!isNullOrEmpty(formData["position"])){
	        			temp1.position=formData["position"];
	        		}
	        		if(!isNullOrEmpty(formData["fromDate"])){
	        			temp1.fromDate=formData["fromDate"];
	        		}
	        		if(!isNullOrEmpty(formData["toDate"])){
	        			temp1.toDate=formData["toDate"];
	        		}
	        		
	        		if(!isNullOrEmpty(formData["country"])){ 
	        			temp1.country ={
	        					id:formData["country"]
	        			};
	        		}
	        		if(!Ext.Object.isEmpty(temp1)){
	        			churchEmployments.push(temp1);	
	        		}
	        	}else{
	        		for(var i in employeData){
		        		var temp1=new Object();
		        		if(!isNullOrEmpty(formData["position"][i])){
		        			temp1.position=formData["position"][i];
		        		}
		        		if(!isNullOrEmpty(formData["fromDate"][i])){
		        			temp1.fromDate=formData["fromDate"][i];
		        		}
		        		if(!isNullOrEmpty(formData["toDate"][i])){
		        			temp1.toDate=formData["toDate"][i];
		        		}
		        		
		        		if(!isNullOrEmpty(formData["country"][i])){ 
		        			temp1.country ={
		        					id:formData["country"][i]
		        			};
		        		}
		        		if(!Ext.Object.isEmpty(temp1)){
		        			churchEmployments.push(temp1);	
		        		}
		        	}
	        	}
	        	
	        	formData.churchMembershipStatusMappings=churchMembershipStatusMappings;
	        	
	        	
	        	formData.churchEmployments=churchEmployments;
	        	delete formData["country"];
	        	delete formData["fromDate"];
	        	delete formData["position"];
	        	delete formData["toDate"];
	        	delete formData["membershipStatus"];
	        	delete formData["historyId"];
	        }
	       
	        jsonFormFieldData = Ext.encode(formData);
	        return jsonFormFieldData;
	    },
	    getJsonNonAcademicAchievementData: function(form) {
	    	var this$ = this;
	        var jsonFormFieldData = new Object();
	        var formData = form.getValues();
	        if (!isEmpty(formData)) {
	        	var personObj = this$.getPersonObj();
	        	delete personObj["personType"];
	        	if(form.itemId=="applicantnonacademicachievementsform"){// applicant
	        		formData.applicantPerson = personObj;	
	        	}else{// student
	        		formData.person = personObj;
	        	}
	        	var sportEvent = formData.sportEvent;
	        	var levelEvent = formData.levelEvent;
	        }
	       
	        jsonFormFieldData = Ext.encode(formData);
	        return jsonFormFieldData;
	    },
	  
	    deleteChurchInfoRecord:function(gridItemId,deleteUrl){
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var grid = personProfile.down(gridItemId);

	    	if (grid.getSelectionModel().getCount() > 0) {
	    		showConfirmMessage(getPersonModuleTranslation('CHURCH_INFORMATION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    			if (btn == 'yes') {
	    				if (grid.getSelectionModel().getCount() > 0) {
	    					var records = grid.getSelectionModel().getSelection();
	    					for (var count = 0; count < records.length; count++) {
	    						var id = "";
	    						if (!isNullOrEmpty(records[count].get("id"))) {
	    							var personId=null;
	    							var applicantPersonId=null;
	    							id=records[count].get("id");
	    							var personObj = this$.getPersonObj();
	    							delete personObj["personType"];
	    							if(gridItemId=="#applicantChurchInformationGrid"){// applicant
	    								applicantPersonId=personObj;
	    							}else{// student
	    								personId=personObj;
	    							}
	    						}
	    						Ext.Ajax.request({
	    							type: 'rest',
	    							url: deleteUrl, 
	    							method: 'DELETE',
	    							headers: {
	    								'Content-Type': 'application/json'
	    							},
	    							params: {
	    								id:id,
	    								personId: personId,
	    								applicantPersonId:applicantPersonId
	    							},
	    							success: function(form, action) {
	    								grid.getStore().reload();
	    								showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('CHURCH_INFORMATION_DELETE_SUCCESS'));
	    							}
	    						});
	    					}
	    				}
	    			}
	    		});
	    	} else {
	    		showWarningMessage(getPersonModuleTranslation('CHURCH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}

	    },
	    editChurchInfoFormWindow:function(informationType, formItemId, gridItemId,isView){
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var grid = personProfile.down(gridItemId);

	    	if (grid.getSelectionModel().getCount() > 0) {
	    		this.showPersonCommonWindow(informationType, formItemId);
	    		var form = this$.getPersonChurchInformationForm();
	    		var records = grid.getSelectionModel().getSelection()[0];
	    		if (!isEmpty(records)) {
	    			form.loadRecord(records);
	    			var membershipStatus=form.down('#membershipStatus');
	    			var membershipArray=new Array();
	    			for(var i in records.data.churchMembershipStatusMappings){
	    				var id=records.data.churchMembershipStatusMappings[i].membershipStatus.id;
	    				membershipArray.push(id);
	    			}
	    			membershipStatus.getStore().load({
	    				callback:function(){
	    					membershipStatus.setValue(membershipArray);
	    				}
	    			});


	    			var addFilterBtn = form.down('#btnAddEmploymentHistory');
	    			var employmentHistoryContainer = form.down('#employmentHistoryContainerId');
	    			var employeeHistoryData=records.data.churchEmployments;
	    			if (employeeHistoryData != null && employeeHistoryData.length > 0) {
	    				for (var j = 0; j < employeeHistoryData.length - 1; j++) {
	    					this$.addChurchEmploymentHistory(addFilterBtn);
	    				}

	    				for (var j = 0; j < employeeHistoryData.length; j++) {
	    					var employmentHistoryPanelContainer = employmentHistoryContainer.items.items[j];
	    					employmentHistoryPanelContainer.items.items[0].setValue(employeeHistoryData[j].id);
	    					employmentHistoryPanelContainer.items.items[1].setValue(employeeHistoryData[j].position);
	    					if(!isNullOrEmpty(employeeHistoryData[j].country) && !isNullOrEmpty(employeeHistoryData[j].country.id)){
	    						employmentHistoryPanelContainer.items.items[2].setValue(employeeHistoryData[j].country.id);
	    					}
	    					employmentHistoryPanelContainer.items.items[3].setValue(dateRender(employeeHistoryData[j].fromDate));
	    					employmentHistoryPanelContainer.items.items[4].setValue(dateRender(employeeHistoryData[j].toDate));
	    					if(isView){
	    						employmentHistoryPanelContainer.items.items[5].setDisabled(true);
	    						if(!isNullOrEmpty(employmentHistoryPanelContainer.items.items[6])){
	    							employmentHistoryPanelContainer.items.items[6].setDisabled(true);	
	    						}
	    					}
	    				}
	    			}else{
	    				addFilterBtn.setDisabled(true);
	    			}

	    		} 
	    	}else {
	    		showWarningMessage(getPersonModuleTranslation('CHURCH_INFORMATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    viewChurchInfoFormWindow:function(informationType, formItemId, gridItemId){
	    	var this$ = this;
	    	this$.editChurchInfoFormWindow(informationType, formItemId, gridItemId,true);
	    	var form = this$.getPersonChurchInformationForm();
	    	this$.viewPersonCommonWindow(form);
	    },
	    viewEmploymentHistory:function(grid,record){
	    	   var this$ = this;
         	   var frmWin = this$.getChurchemploymenthistorywindow();
         	   if(!frmWin){
         		   Ext.widget('churchemploymenthistorywindow');
         		   frmWin = this$.getChurchemploymenthistorywindow();
         	   }
         	   frmWin.show();
         	 var records = grid.getSelectionModel().getSelection()[0];
         	 var churchInfo=records.data;
         	 frmWin.down("#churchAffiliationItemIdWin").setValue(churchInfo.churchAffiliation);
         	 frmWin.down("#localChurchNameItemIdWin").setValue(churchInfo.localChurchName);
         	 var employementHistoryData=records.data.churchEmployments;
         	 var winGrid=frmWin.down('#employeHistoryGridItemId');
         	 winGrid.getStore().loadRawData([]);
         	 winGrid.getStore().loadRawData(employementHistoryData,true);
	    },
	    getJsonChurchInfoDataForUpdate:function(grid,form){
	    	var this$ = this;
	    	var records = grid.getSelectionModel().getSelection()[0];
	        var jsonFormFieldData = new Object();
	        var formData = form.getValues();
	        if (!isEmpty(formData)) {
	        	var personObj = this$.getPersonObj();
	        	delete personObj["personType"];
	        	if(form.itemId=="applicantChurchInfoForm"){// applicant
	        		formData.applicantPerson = personObj;	
	        	}else{// student
	        		formData.person = personObj;
	        	}
	            var churchMembershipStatusMappings = new Array();
	            if(!isNullOrEmpty(formData.membershipStatus)){
	            	for(var i in formData.membershipStatus){
	        			var obj=new Object();
	        			if(formData.membershipStatus[i].data == undefined){
	        				obj.membershipStatus={
		        					id:formData.membershipStatus[i]
		        			};
	        			}else{
	        				obj.membershipStatus={
		        					id:formData.membershipStatus[i].data.id
		        			};
	        			}
	            		churchMembershipStatusMappings.push(obj)
	            	}	
	            }
	            var churchEmployments = new Array();
	            var employeData=form.down('#employmentHistoryContainerId').items.items;
	            if(employeData.length == 1){
	        		var temp1=new Object();
	        		
	        		if(!isNullOrEmpty(formData["position"])){
	        			temp1.position=formData["position"];
	        		}
	        		if(!isNullOrEmpty(formData["fromDate"])){
	        			temp1.fromDate=formData["fromDate"];
	        		}
	        		if(!isNullOrEmpty(formData["toDate"])){
	        			temp1.toDate=formData["toDate"];
	        		}
	        		
	        		if(!isNullOrEmpty(formData["country"])){ 
	        			temp1.country ={
	        					id:formData["country"]
	        			};
	        		}
	        		if(!isNullOrEmpty(formData["historyId"])){
	        			temp1.id=formData["historyId"];
	        		}
	        		
	        		if(!Ext.Object.isEmpty(temp1)){
	        			churchEmployments.push(temp1);	
	        		}
	        		
	        	}else{
	        		for(var i in employeData){
		        		var temp1=new Object();
		        		
		        		if(!isNullOrEmpty(formData["position"][i])){
		        			temp1.position=formData["position"][i];
		        		}
		        		if(!isNullOrEmpty(formData["fromDate"][i])){
		        			temp1.fromDate=formData["fromDate"][i];
		        		}
		        		if(!isNullOrEmpty(formData["toDate"][i])){
		        			temp1.toDate=formData["toDate"][i];
		        		}
		        		if(!isNullOrEmpty(formData["historyId"][i])){
		        			temp1.id=formData["historyId"][i];
		        		}
		        		
		        		if(!isNullOrEmpty(formData["country"][i])){ 
		        			temp1.country ={
		        					id:formData["country"][i]
		        			};
		        		}
		        		if(!Ext.Object.isEmpty(temp1)){
		        			churchEmployments.push(temp1);	
		        		}
		        	}
	        	}
	            
	            formData.churchMembershipStatusMappings=churchMembershipStatusMappings;
	            formData.churchEmployments=churchEmployments;
	            delete formData["country"];
	            delete formData["fromDate"];
	            delete formData["position"];
	            delete formData["toDate"];
	            delete formData["membershipStatus"];
	            delete formData["historyId"];
	        }
	       
	        jsonFormFieldData = Ext.encode(formData);
	        return jsonFormFieldData;
	    },
	    getJsonNonAcademicAchievementsInfoDataForUpdate:function(grid,form){
	    	var this$ = this;
	    	var records = grid.getSelectionModel().getSelection()[0];
	        var jsonFormFieldData = new Object();
	        var formData = form.getValues();
	        if (!isEmpty(formData)) {
	        	var personObj = this$.getPersonObj();
	        	delete personObj["personType"];
	        	if(form.itemId=="applicantnonacademicachievementsform"){// applicant
	        		formData.applicantPerson = personObj;	
	        	}else{// student
	        		formData.person = personObj;
	        	}
	        	
	        	var sportEvent = formData.sportEvent;
	        	var levelEvent = formData.levelEvent;
	           
	        }
	       
	        jsonFormFieldData = Ext.encode(formData);
	        return jsonFormFieldData;
	    },
	    onRenderApplicantDetailsForm: function(form) {
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
			var personId;
			try{
				personId =  personProfile.getPersonId();
			}catch(e){
				 personId = this$.getContentPanel().items.items[0].getPersonInfo().id; 
			 }
         		
			 if (!isNullOrEmpty(personId)) {
				 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				 var url = SERVERURL.PATH_APPLICANT_DETAIL_FORM_DATA + '?applicantPersonId=' + personId;
				 this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
					 Ext.getBody().unmask();
					 if (success) {
						 if (!isNullOrEmpty(response.responseText)) {
							 var data = Ext.decode(response.responseText);
							 if (!isEmpty(data)) {
								this$.setApplicantDetailsFormValue(form,data);
							 }
						 }
					 }
				 });
			 }
		 },
		 setApplicantDetailsFormValue:function(form,data){
			 if(form){
				 form.getForm().setValues(data[0]);
				 form.down('#personCodeField').setValue(data[0].applicantCode);
				 var birthDateField=form.down('#birthDateId');
				 birthDateField.setValue(dateRender(data[0].birthDate));
				 var genderCSM = form.down('#genderCSM');
				 if (!isNullOrEmpty(data[0].genderCSM) && !isNullOrEmpty(data[0].genderCSM.id)) {
					 genderCSM.setValue(data[0].genderCSM.id);
                 }
				 if(data[0].version > 0){
					 var applicantTypeField=form.down('#applicantTypeId');
					 applicantTypeField.setDisabled(true);
					 var enquiryIdBtn=form.down('#enquiryIdItemId');
					 var emailIdBtn=form.down('#emailId');
					 enquiryIdBtn.setReadOnly(true);
					 emailIdBtn.setReadOnly(true);
					 var enquiryFetchBtn=form.down('#FetchEnquiryDetailId');
					 enquiryFetchBtn.setDisabled(true);
				 }
				 var nationalIdField=form.down('#nationalIDItemId');
				 var nationalityCombo=form.down('#nationalityCombo');
				 if(form.down('#nationalityCombo').valueModels.length > 0){
					 if(form.down('#nationalityCombo').valueModels[0].data.code=='Zimbabwean'){
						 nationalIdField.setFieldLabel(getPersonModuleTranslation('NATIONAL_ID')+ '<span class="required" style="color:red"> *</span>');
					 }else{
						 nationalIdField.setFieldLabel(getPersonModuleTranslation('PASSPORT_NO')+ '<span class="required" style="color:red"> *</span>');
					 } 
				 }else{
					 var nationalityField=form.down('#nationalityCombo');
					 nationalityField.getStore().load({
						 callback: function(records, operation, success) {
							 if (success) {
								 for(i in records){
									 if(records[i].data.whetherDefault || records[i].data.whetherDefault=="true"){
										 nationalityField.setValue(records[i].data.id);
										 if(records[i].data.code=="Zimbabwean"){
											 nationalIdField.setFieldLabel(getPersonModuleTranslation('NATIONAL_ID')+ '<span class="required" style="color:red"> *</span>');
										 }else{
											 nationalIdField.setFieldLabel(getPersonModuleTranslation('PASSPORT_NO')+ '<span class="required" style="color:red"> *</span>');
										 }
									 }
								 }
							 }
						 }
					 });
				 }
				 
				 // Set image filed input value if image is already there
				 if( !isNullOrEmpty(form.down("#applicantPhotoUploadForm")) && !isNullOrEmpty(form.down("#applicantPhotoUploadForm").down("#photoFileImage")) ){
					 var imageField = form.down("#applicantPhotoUploadForm").down("#photoFileImage");
					 if( !isNullOrEmpty(data[0].photoUrl) ){
						imageField.setRawValue("File has been uploaded");
					 }
				 }
				 
			 }
		 },
		 changeApplicantType:function(obj,newValue,oldValue){
			 var this$=this;
			 var form=this$.getPersonApplicantDetailsForm();
			 var enquiryIdField=form.down("#enquiryIdItemId");
			 var emailField=form.down("#emailId");
			 var fetchBtn=form.down("#FetchEnquiryDetailId");
			 if(newValue.saleRefType == 'NEW_APPLICANT'){
				 enquiryIdField.allowBlank=true;
				 emailField.allowBlank=true;
				 enquiryIdField.setVisible(false);
				 emailField.setVisible(false)
				 fetchBtn.setVisible(false);
				 enquiryIdField.reset();
				 emailField.reset();
				 
			 }else{// enquired earlier
				 enquiryIdField.allowBlank=false;
				 emailField.allowBlank=false;
				 enquiryIdField.setVisible(true);
				 emailField.setVisible(true);
				 fetchBtn.setVisible(true);
			 }
// form.down('#firstName').reset();
// form.down('#middleName').reset();
// form.down('#lastName').reset();
// form.down('#nationalityCombo').reset();
// form.down('#birthDateId').reset();
// form.down('#genderId').reset();
			 form.down('#enquiryStudentDetailItemId').reset();
			 
			 var nationalIdField=form.down('#nationalIDItemId');
			 var nationalityField=form.down('#nationalityCombo');
			 nationalityField.getStore().load({
				 callback: function(records, operation, success) {
					 if (success) {
						 for(i in records){
							 if(records[i].data.whetherDefault || records[i].data.whetherDefault=="true"){
								 nationalityField.setValue(records[i].data.id);  	
								 if(records[i].data.code=="Zimbabwean"){
									 nationalIdField.setFieldLabel(getPersonModuleTranslation('NATIONAL_ID')+ '<span class="required" style="color:red"> *</span>');
								 }else{
									 nationalIdField.setFieldLabel(getPersonModuleTranslation('PASSPORT_NO')+ '<span class="required" style="color:red"> *</span>');
								 }
							 }
						 }
					 }
				 }
			 });
			 form.down('#submitButtonId').setDisabled(false);
		 },
		 isUniversityStudent:function(obj,newValue,oldValue){
			 var this$=this;
			 var form=this$.getPersonApplicantDetailsForm();
			 var studentIdField=form.down("#studentIdItemId");
			 if(newValue.isRegisteredUniversity){
				 studentIdField.setVisible(true);
				 studentIdField.allowBlank=false;
			 }else{
				 studentIdField.setVisible(false);
				 studentIdField.allowBlank=true;
			 }
			 studentIdField.reset();
			 form.isValid();
		 },
		 saveApplicantInfo:function(obj){
			 var this$=this;
			 var form=this$.getPersonApplicantDetailsForm();
			 if(form.isValid()){
				 var formValues=form.getValues();
				 if(formValues.version > 0 || this$.isValidInfo(formValues)){
					 var obj=new Object();
					 obj.id=formValues.id;
					 delete formValues["id"];
					 obj.enquiryStudentDetailId=formValues.enquiryStudentDetailId;
					 delete formValues["enquiryStudentDetailId"];
					 obj.isRegisteredUniversity=formValues.isRegisteredUniversity;
					 delete formValues["isRegisteredUniversity"];
					 obj.registeredStudentId=formValues.registeredStudentId;
					 delete formValues["registeredStudentId"];
					 obj.saleRefType=formValues.saleRefType;
					 delete formValues["saleRefType"];
					 delete formValues["enquiryId"];
					 formValues.id=formValues.applicantPersonId;// move id into
																// applicantPersonId
					 delete formValues["applicantPersonId"];
					 delete formValues["applicantId"]

					 if(isNullOrEmpty(formValues.maritalStatus)){
						 formValues.maritalStatus=null;
					 }
					 if(isNullOrEmpty(formValues.gender)){
						 formValues.gender=null;
					 }

					 obj.person=formValues;
					 obj.person.genderCSM = {id:obj.person.genderCSM};
					 var applicantPhotoUploadForm = form.down('#applicantPhotoUploadForm');
					 var photoFileImage = applicantPhotoUploadForm.down('#photoFileImage');
					 var fileUploadPath = photoFileImage.getValue();
					 var jsonFormatFormData;
					 if(!isNullOrEmpty(fileUploadPath) && !isNullOrEmpty(photoFileImage.fileInputEl.dom) && photoFileImage.fileInputEl.dom.files["length"] != 0 ){
						 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonInfoController');
						 var applicantPersonController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
						 personController.saveApplicantPhotoUploadForm(applicantPhotoUploadForm, obj.person.id, SERVERURL.APPLICANT_IMAGE_UPLOAD, SERVERURL.APPLICANT_IMAGE_DOWNLOAD, function(success,photoUrl,version){
							 if(success){
								 if(!isNullOrEmpty(photoUrl)){
									 obj.person.photoUrl=photoUrl;
									 jsonFormatFormData=Ext.encode(obj);
									 this$.saveApplicantDetails(form,jsonFormatFormData);
									 applicantPersonController.setApplicantUploadedPhoto(SERVERURL.APPLICANT_IMAGE_DOWNLOAD);
								 }

							 }
						 });
					 }else{
						 jsonFormatFormData=Ext.encode(obj);
						 this$.saveApplicantDetails(form,jsonFormatFormData);
					 }
				 }else{
					 showWarningMessage(getPersonModuleTranslation('APPLICANT_DETAILS_FORM'), getPersonModuleTranslation('PLEASE_FETCH_ENQUIRED_DETAILS'));
				 }
			 }else{
				 showWarningMessage(getPersonModuleTranslation('APPLICANT_DETAILS_FORM'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
			 }
		 },
		 isValidInfo:function(formValues){
			 if(formValues.saleRefType=="NEW_APPLICANT"){
				 return true;
			 }else{
				 if(formValues.saleRefType=="ENQUIRED_EARLIER" && !isNullOrEmpty(formValues.enquiryStudentDetailId)){
					 return true;
				 }else{
					 return false;
				 }
			 }
		 },
		 saveApplicantDetails:function(form,jsonFormatFormData){
			 var submitUrl =SERVERURL.PATH_APPLICANT_DETAIL_FORM_UPDATE;
			 var this$=this;
			 var  personProfile = this$.getContentPanel().items.items[0];
			 this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
				 Ext.getBody().unmask();
				 if(success){
					 this$.onRenderApplicantDetailsForm(form);
					 this$.getApplicantProfileInformation(personProfile);
					 showSuccessMessage(getPersonModuleTranslation('APPLICANT_DETAILS_FORM'), getPersonModuleTranslation('APPLICANT_DETAILS_FORM_UPDATE_SUCCESS'));
				 }
			 });
		 },
		 showHidePassportNationalIdField:function(obj,record){
			 var this$=this;
			 var form=this$.getPersonApplicantDetailsForm();
			 var nationalIdField=form.down('#nationalIDItemId');
			 if(record[0].data.value=='Zimbabwean'){
				 nationalIdField.setFieldLabel(getPersonModuleTranslation('NATIONAL_ID')+ '<span class="required" style="color:red"> *</span>');
			 }else{
				 nationalIdField.setFieldLabel(getPersonModuleTranslation('PASSPORT_NO')+ '<span class="required" style="color:red"> *</span>');
			 }
			 nationalIdField.reset();
		 },
		 fetchEnquiryDetails:function(obj){
			var this$=this;
			 var form=this$.getPersonApplicantDetailsForm();
			 var enquiryCode=form.down('#enquiryIdItemId').getValue();
			 var emailId=form.down('#emailId').getValue();
			 if(!isNullOrEmpty(enquiryCode) && !isNullOrEmpty(emailId)){
				 var url = SERVERURL.PATH_ENQUIRY_EARLIER + '?enqCode=' + enquiryCode+'&emailID='+emailId;
				 this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
					 Ext.getBody().unmask();
					 if (success) {
						 if (!isNullOrEmpty(response.responseText)) {
							 var data = Ext.decode(response.responseText);
							 if (!isEmpty(data)) {
								 this$.setEnquiryInfo(data[0]);
							 }else{
								 showWarningMessage(getPersonModuleTranslation('APPLICANT_DETAILS_FORM'), getCommonTranslation('RECORD_NOT_FOUND'));
							 }
						 }
					 }
				 });

			 }else{
				 showWarningMessage(getPersonModuleTranslation('APPLICANT_DETAILS_FORM'), getCommonTranslation('PLEASE_ENTER_EMAIL_AND_ENQUIRY_ID'));
			 }
		 },
		 setEnquiryInfo:function(data){
			 var this$=this;
			 var form=this$.getPersonApplicantDetailsForm();
			 form.down('#firstName').setValue(data.studentFirstName);
			 form.down('#middleName').setValue(data.studentMiddleName);
			 form.down('#lastName').setValue(data.studentLastName);
			 form.down('#nationalityCombo').setValue(!isNullOrEmpty(data.nationality)?data.nationality.id:null);
			 form.down('#birthDateId').setValue(dateRender(data.studentDateOfBirth));
			 form.down('#genderId').setValue(data.gender);
			 form.down('#enquiryStudentDetailItemId').setValue(data.id);
			 
		 },
		 submitApplicationFromPortal:function(obj){
			 var this$=this;
			 var form=this$.getPersonApplicantDeclarationAndPaymentForm();
			 var personProfile = this$.getContentPanelActiveTab();

			 try {
				 personProfile.getApplicationId();
			 } catch(e){
				 personProfile = this$.getContentPanel().items.items[0];
			 }
			 var payType=form.down('#payTypeId').getValue();
			 var entityId = personProfile.applicationId;// applicationId
			 var payTypeValue=payType.payType;
			 // Start : check submit pending docs
			 var url=SERVERURL.PATH_APPLICANT_PENDING_DOCUMENT+ '?applicationId=' + entityId;
			 var isSubmitDocument=false;
			 Ext.Ajax.request({
				 type: 'rest',
				 url: url,
				 method: 'GET',
				 async: false,
				 headers: {
					 'Content-Type': 'application/json'
				 },
				 success: function(response) {
					 isSubmitDocument=response.responseText;
					 if(!isSubmitDocument || isSubmitDocument=="false"){
						 showWarningMessage(getPersonModuleTranslation('DECLARATION_PAYMENT'), getPersonModuleTranslation('SUBMIT_PENDING_DOCUMENT'));
						 isSubmitDocument=false;
						 form.getForm().reset();
					 }else{
						 isSubmitDocument=true;
					 }
				 }
			 });
			 
         		var submitUrl = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_TAB_GRID_DATA+"?applicationID=" + entityId;
         		var academyLocationId = null;
         		if (!isNullOrEmpty(submitUrl)) {
         			  Ext.Ajax.request({
         				  type: 'rest',
         				  url: submitUrl,
         				  async:false,
         				  method: 'GET',
         					  success: function(success) {
         						var data = Ext.decode(success.responseText);
         						academyLocationId = data[0].academyLocationId;
         					  }
         				  });
         		}  
			 
			// End
			 if(isSubmitDocument){

				 if(!isNullOrEmpty(payTypeValue) && payTypeValue=='ONLINE'){// online
																			// mode
					 form.getForm().reset();
					 var jsonFormatFormData=this$.makeJsonSubmitApplication(null,payTypeValue,entityId,form);
					 // call to payU
					 var XMLHttpRequestObject = false;  
					 if (window.XMLHttpRequest) {  
						 XMLHttpRequestObject = new XMLHttpRequest();  
						 XMLHttpRequestObject.overrideMimeType("text/xml");  
					 }  
					 else if (window.ActiveXObject) {  
						 XMLHttpRequestObject = new  
						 ActiveXObject("Microsoft.XMLHTTP");  
					 } 
					 var tabName = getExaminationTranslation('EXAMINATION_APPLY_FOR_REVALUATION');
					 var getcontroller=this$.getController('menu.CoreERPNavigationController');
					 var getTab=getcontroller.getTab(tabName);
					 var contentpanel = this.getContentPanel();
					 if(XMLHttpRequestObject) {  
						 XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
						 XMLHttpRequestObject.onreadystatechange = function() {       
							 if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
								 var xmlDocument = XMLHttpRequestObject.responseXML;  
								 buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
								 gatewayPostUrl = buildInfo.getElementsByTagName("applicantPaymentUrl") [0].childNodes[0].nodeValue;
								 var w ='900',h ='500';
								 // Fixes dual-screen position Most browsers
									// Firefox
								 var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
								 var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

								 var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
								 var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

								 var left = ((width / 2) - (w / 2)) + dualScreenLeft;
								 var top = ((height / 2) - (h / 2)) + dualScreenTop;
								 if(!isNullOrEmpty(jsonFormatFormData)){
									 jsonData = Ext.JSON.decode(jsonFormatFormData);
									 if(!isNullOrEmpty(jsonData.id) && !isNullOrEmpty(academyLocationId)){
										 var url = gatewayPostUrl+"?applicationId="+jsonData.id+"&academyLocationIds="+academyLocationId; 
										 var newWindow = window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);
									 }
									 if(contentpanel.getActiveTab())
									 {
										 contentpanel.getActiveTab().close();
									 }
									 // Puts focus on the newWindow
									 if (window.focus) {
										 newWindow.focus();
									 }
								 }
							 }  
						 }  
						 XMLHttpRequestObject.send(null);  
					 }

				 }else{// offline mode
					 var module = 'applicant';
					 var entityType = 'applicant';
					 var data = new Object();
					 data.entityId = entityId;
					 data.module = module;
					 data.entityType = entityType;
					 form.getForm().setValues(data);
					 var submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
					 form.getForm().submit({
						 method : 'POST',
						 url : submitUrl,
						 success : function(form, action){
							 var path = Ext.JSON.decode(action.response.responseText).path;
							 this$.finalSubmitApplication(path,payTypeValue,entityId,form);
						 }
					 });
				 }
			 }
		 },
		 finalSubmitApplication:function(path,payTypeValue,applicationId,form){
			 var this$=this;
			 var personProfile = this$.getContentPanel().items.items[0];
			 var submitUrl =SERVERURL.PATH_SUBMIT_APPLICATION_PORTAL;
			 var form=this$.getPersonApplicantDeclarationAndPaymentForm();
			 var jsonFormatFormData=this$.makeJsonSubmitApplication(path,payTypeValue,applicationId,form);
			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			 this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
				 Ext.getBody().unmask();
				 if(success){
					 if(!isNullOrEmpty(form)){
						 form.getForm().reset();
						 form.items.each(function(itm){
							 itm.setDisabled(true);
						 });	 
					 }
					 this$.mixins.ApplicationBaseController.getApplicantProfileInformation(personProfile);
					 showSuccessMessage(getPersonModuleTranslation('DECLARATION_PAYMENT'), getPersonModuleTranslation('APPLICATION_SUBMIT_SUCCESS'));
				 }else{
					 form.getForm().reset();
				 }
			 });
		 },
		 makeJsonSubmitApplication:function(path,payTypeValue,applicationId,form){
			 var this$=this;
			 var personObj = this$.getPersonObj();
			 var doc={
					 path : path,
					 type : "EXT_DOCUMENT"
			 };
			 var obj={
					 applicantPersonId:personObj.id,
					 document:doc,
					 payType:payTypeValue,
					 id:applicationId
			 };
			 return Ext.encode(obj);
		 },
		 changePaymentMode:function( obj,newValue,oldValue){
			 var this$=this;
			 var form=this$.getPersonApplicantDeclarationAndPaymentForm();
			 var uploadField=form.down("#uploadFileField");
			 var submitBtn=form.down('#submitApplicationButtonId');
			 var uploadTransactionLabel=form.down('#uploadTransactionLabelItemId');
			 if(newValue.payType == 'ONLINE'){
				 uploadField.setVisible(false);
				 uploadField.allowBlank=true;
				 uploadTransactionLabel.setVisible(false);
			 }else{
				 uploadField.setVisible(true);
				 uploadField.allowBlank=false;
				 uploadTransactionLabel.setVisible(true);
			 }
			 submitBtn.setDisabled(true);
			 form.down('#checkBoxAgree').reset();
			 uploadField.reset();
			 form.getForm().isValid()
		 },
		 enableDisableSubmitBtn:function(obj,newValue,oldValue){
			 var this$=this;
			 var form=this$.getPersonApplicantDeclarationAndPaymentForm();
			 var submitBtn=form.down('#submitApplicationButtonId');
			 var payTypeFieldValue=form.down('#payTypeId').getValue();
			 var payTypeValue=payTypeFieldValue.payType;
			 var uploadFieldValue=form.down("#uploadFileField").getValue();
			 if(!isNullOrEmpty(payTypeValue) && payTypeValue=='ONLINE'){
				 if(newValue || newValue=="true"){
					 submitBtn.setDisabled(false);
				 }else{
					 submitBtn.setDisabled(true);
				 } 
			 }else{
				 if(!isNullOrEmpty(payTypeValue) && !isNullOrEmpty(uploadFieldValue)){
					 if(newValue || newValue=="true"){
						 submitBtn.setDisabled(false);
					 }else{
						 submitBtn.setDisabled(true);
					 } 
				 }
			 }
			form.getForm().isValid();
		 },
		 validatedUploadedFile:function(obj, value, eOpts){
			 var this$=this;
			 var form=this$.getPersonApplicantDeclarationAndPaymentForm();
			 var newValue=value;
			 obj.setValue(newValue);
			 var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
             var specialCharsExist=false;
                  for(i = 0; i < specialChars.length;i++){
                    if(newValue.indexOf(specialChars[i]) > -1){
                        specialCharsExist= true;
                     }
                  }
                 if(specialCharsExist){
                	 obj.reset();
                     showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                 }
			 var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
			 if (this$.isValidFileExtension(extension)) {
				 var file = obj.fileInputEl.dom.files[0];
				 if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
					 obj.reset();
					 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
				 } 
			 }else{
				 obj.reset();
				 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
			 }
		 },
		 disableDeclareAndPaymentFormField:function(form){
			 var this$=this;
			 var personProfile = this$.getContentPanelActiveTab();
			 try {
				 personProfile.getApplicationId();
			 } catch(e){
				 personProfile = this$.getContentPanel().items.items[0];
			 }
			 var applicationId = personProfile.applicationId;
			 var url=SERVERURL.PATH_APPLICATION_STATUS_INFO+ '?applicationId=' + applicationId;
			 this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
				 if (success) {
					 if (!isNullOrEmpty(response.responseText)) {
						 var data = Ext.decode(response.responseText);
						 if(!isNullOrEmpty(data)){
							 var status=data.value;
							 if(status=="SUBMITTED" || status=="APPROVED" || status=="ADMISSION_GRANTED" || status == "REJECTED" || status=="WITHDRAWN" 
								 || status=="DIRECT_ADMISSION" || status=="MID_TERM_ADMISSION"){
								 Ext.app.DisabledDeclarationAndPaymentScreen=true;
								 if(!isNullOrEmpty(form)){
								// form.items.each(function(itm){itm.setDisabled(true)});
										 form.down('#printBtn').setDisabled(true);	
									 
								 }
							 }
						 }
					 }
				 }
			 });	 

		 },
		 loadChurchInfoGridStore:function(gridItemId, url){
		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var personObj = this$.getPersonObj();
		        var grid = personProfile.down(gridItemId);
		        if (grid) {
		            var personId=null;
		            var applicantPersonId=null;
		            if(gridItemId=="#applicantChurchInformationGrid"){// applicant
		            	applicantPersonId = personObj["id"];
		            }else{// student
		            	personId = personObj["id"];
		            }
		            var store = grid.getStore();
		            this$.resetPageSetting(store);
		            store.getProxy().api.read = url;
		            store.getProxy().extraParams = {
		            	applicantPersonId: applicantPersonId,
		            	personId:personId,
		            	
		            };
		            store.load();
		        }
		 },
		 loadNonAcademicAchievementsGridStore:function(gridItemId, url){
		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var personObj = this$.getPersonObj();
		        var grid = personProfile.down(gridItemId);
		        if (grid) {
		            var personId=null;
		            var applicantPersonId=null;
		            if(gridItemId=="#applicantnonacademicachievementsgridItemId"){// applicant
		            	applicantPersonId = personObj["id"];
		            }else{// student
		            	personId = personObj["id"];
		            }
		            var store = grid.getStore();
		            this$.resetPageSetting(store);
		            store.getProxy().api.read = url;
		            store.getProxy().extraParams = {
		            	applicantPersonId: applicantPersonId,
		            	personId:personId,
		            };
		            store.load();
		        }
		 },
		 loadPostSchoolStudiesGridStore:function(gridItemId, url){
		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var personObj = this$.getPersonObj();
		        var grid = personProfile.down(gridItemId);
		        if (grid) {
		        	var buttonsToolBar = grid.query('toolbar')[0];
      		        buttonsToolBar.query('#btnExportToPDF')[0].setDisabled(true);
      		        buttonsToolBar.query('#btnExportToExcel')[0].setDisabled(true);
		            var personId=null;
		            var applicantPersonId=null;
		            if(gridItemId=="#applicantPostSchoolStudiesGrid"){// applicant
		            	applicantPersonId = personObj["id"];
		            }else{// student
		            	personId = personObj["id"];
		            }
		            var store = grid.getStore();
		            this$.resetPageSetting(store);
		            store.getProxy().api.read = url;
		            store.getProxy().extraParams = {
		            	applicantPersonId: applicantPersonId,
		            	personId:personId,
		            	
		            };
		            store.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 if (records.length > 0) {
									 buttonsToolBar.query('#btnExportToPDF')[0].setDisabled(false);
					      		     buttonsToolBar.query('#btnExportToExcel')[0].setDisabled(false);
								  }
							 }
						 }
		            });
		        }
		 },
		 getMonthArray: function(getMonthValue){
			 var month=new Array(12);
	         month[01]="JANUARY";
	         month[02]="FEBRUARY";
	         month[03]="MARCH";
	         month[04]="APRIL";
	         month[05]="MAY";
	         month[06]="JUNE";
	         month[07]="JULY";
	         month[08]="AUGUST";
	         month[09]="SEPTEMBER";
	         month[10]="OCTOBER";
	         month[11]="NOVEMBER";
	         month[12]="DECEMBER";
	         return month[getMonthValue];
		 },
		 onRenderSocioEconomicForm: function(geturl,person) {
			 var this$ = this;
			 var personProfile = this$.getContentPanelActiveTab();
			 try {
				 personProfile.getPersonId();
			 } catch(e){
				 personProfile = this$.getContentPanel().items.items[0];
			 }
			 this$.hideFormFieldsCheckForProgramGroup(person);
			 var personId = personProfile.getPersonId();
			 if (!isNullOrEmpty(personId)) {
				 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				 var url = geturl + personId;
				 this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
					 Ext.getBody().unmask();
					 if (success) {
						 if (!isNullOrEmpty(response.responseText)) {
							 var data = Ext.decode(response.responseText);
							 if (!isEmpty(data)) {
								 this$.setValueToSocioEconomicForm(data,person);
							 }
						 }
					 }
				 });
			 }
		 },
		 setValueToSocioEconomicForm: function(data,person) {
			 var this$ = this;
			 var personProfile = this$.getContentPanelActiveTab();
			 var personalInformationForm = personProfile.down('socioeconomicinformationform');
			 personalInformationForm.down('#socioEconomic_hidden_field').setValue(data.id);
			 if (personalInformationForm) {
				 personalInformationForm.getForm().setValues(data);
				 personalInformationForm.down('#parentQualification1').getStore().load({
					 callback: function(records, operation, success) {
						 if (success) {
							 for(i in records){
								 if(records[i].data.id==data.parentQualification1.id){
									 personalInformationForm.down('#parentQualification1').setValue(records[i].data.id);
								 }
							 }
						 }
					 }
				 });
				 personalInformationForm.down('#parentQualification2').getStore().load({
					 callback: function(records, operation, success) {
						 if (success) {
							 for(i in records){
								 if(records[i].data.id==data.parentQualification2.id){
									 personalInformationForm.down('#parentQualification2').setValue(records[i].data.id);
								 }
							 }
						 }
					 }
				 });
				 personalInformationForm.down('#payStudy').getStore().load({
					 callback: function(records, operation, success) {
						 if (success) {
							 for(i in records){
								 if(records[i].data.id==data.payStudy.id){
									 personalInformationForm.down('#payStudy').setValue(records[i].data.id);
								 }
							 }
						 }
					 }
				 });
				 personalInformationForm.down('#parentAnnualIncome').getStore().load({
					 callback: function(records, operation, success) {
						 if (success) {
							 for(i in records){
								 if(records[i].data.id==data.parentAnnualIncome.id){
									 personalInformationForm.down('#parentAnnualIncome').setValue(records[i].data.id);
								 }
							 }
						 }
					 }
				 });
				 personalInformationForm.down('#schoolFeePerYear').getStore().load({
					 callback: function(records, operation, success) {
						 if (success) {
							 for(i in records){
								 if(records[i].data.id==data.schoolFeePerYear.id){
									 personalInformationForm.down('#schoolFeePerYear').setValue(records[i].data.id);
								 }
							 }
						 }
					 }
				 });
				 personalInformationForm.down('#isScholarship').getStore().load({
					 callback: function(records, operation, success) {
						 if (success) {
							 for(i in records){
								 if(records[i].data.id==data.isScholarship.id){
									 personalInformationForm.down('#isScholarship').setValue(records[i].data.id);
								 }
							 }
						 }
					 }
				 });
			 }
		 },
		 saveSocioEconomicDetails:function(gridItemId, saveUrl, updateUrl,person) {
		        var this$ = this;
		        var personProfile = this$.getContentPanelActiveTab();
		        var form = personProfile.down("socioeconomicinformationform");
	            var methodtype = 'POST';
		        var submitUrl, isUpdate = false;
		        var id = form.down('#socioEconomic_hidden_field');
		        var jsonFormatFormData;
		        if (isNullOrEmpty(id.getSubmitValue())) {
		            submitUrl = saveUrl; 
		            isUpdate = false;
		            jsonFormatFormData = this$.getJsonSocioEconomicData(form,personProfile.getPersonId(),person);
		        } else {
		            submitUrl = updateUrl; 
		            isUpdate = true;
		            jsonFormatFormData = this$.getJsonSocioEconomicData(form,personProfile.getPersonId(),person);
		        }
		        
		        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		        this$.sendSaveAjaxRequest(submitUrl,methodtype, jsonFormatFormData, function(option, success, response) {
		        	 Ext.getBody().unmask();
		        	if(success){
		                if (isUpdate) {
		                    showSuccessMessage(getPersonModuleTranslation('SOCIO_ECONOMIC_INFORMATION'), getCommonTranslation('SOCIO_ECONOMIC_INFORMATION_UPDATE_SUCCESSFULLY'));
		                } else {
		                    showSuccessMessage(getPersonModuleTranslation('SOCIO_ECONOMIC_INFORMATION'), getCommonTranslation('SOCIO_ECONOMIC_INFORMATION_ADD_SUCCESSFULLY'));
		                }
		                var url = SERVERURL.PATH_ECONOMIC_INFORMATION_FIND_BY_PERSON + '?applicantPersonId=';
		                this$.onRenderSocioEconomicForm(url,'applicant');
		    		}
		        });
		    },
		    getJsonSocioEconomicData: function(form,personId,person) {
		    	var this$ = this;
		    	var jsonFormFieldData = new Object();
		    	var formData = form.getValues();
		    	formData.isScholarship = this$.getIdValueJson(formData.isScholarship);
		    	formData.parentAnnualIncome = this$.getIdValueJson(formData.parentAnnualIncome);
		    	formData.parentQualification1 = this$.getIdValueJson(formData.parentQualification1);
		    	formData.parentQualification2 = this$.getIdValueJson(formData.parentQualification2);
		    	formData.payStudy = this$.getIdValueJson(formData.payStudy);
		    	formData.schoolFeePerYear = this$.getIdValueJson(formData.schoolFeePerYear);
		    	if(person == 'applicant'){
		    		formData.applicantPerson = this$.getIdValueJson(personId);
		    	}else{
		    		formData.person = this$.getIdValueJson(personId);
		    	}
		    	/*
				 * if (!isEmpty(formData)) { delete formData["customData"]; }
				 */
		    	jsonFormFieldData = Ext.encode(formData);
		    	return jsonFormFieldData;
		    },
		    hideFormFieldsCheckForProgramGroup:function(person){
		    	var this$ = this;
		    	var personProfile = this$.getContentPanelActiveTab();
		    	var personalInformationForm = personProfile.down('socioeconomicinformationform');
		    	var selectionGrid = personProfile.down('selectionsnapshotgrid');
		    	var programGroup=null;
		    	if(this$.getCurrentLoggedPortalId() == 3){
		    		var portalInfo = Academia.model.authentication.PortalInfoModel;
		    		programGroup = portalInfo.data.programBatchDetails.programGroupName; 
		    		personalInformationForm.setTitle(getPersonModuleTranslation('SOCIO_ECONOMIC_INFORMATION'));
		    	}else{
		    		if(person == 'applicant'){
		    			if(selectionGrid.getStore().data.length>0){
		    				programGroup = selectionGrid.getStore().data.items[0].data.programGroupName;
		    			}else{
		    				programGroup =  personProfile.applicationDataObject.programGroup.groupName;
		    			}
		    		}else{
		    			programGroup = this$.getStudentDetailForErpPortal().programBatchDetails.programGroupName; 
		    		}
		    	}
		    	Ext.Ajax.request({
		    		type: 'rest',
		    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		    		params: {
		    			screenName: 'socioeconomicinformationform',
		    			academyLocationId: this.getCurrentAcademyLocation(),
		    			languageCode:'en'
		    		},
		    		method: 'GET',
		    		success: function(res, action) {
		    			var response = Ext.decode(res.responseText);
		    			if( Object.keys(response).length > 0 ){
		    				var records=response.socioeconomicinformationform;
		    				for(i in records){    
		    					if(programGroup == 'Post Graduate' || programGroup == 'Post Doctoral' || programGroup == 'Doctoral'){
		    						if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='parentQualification1' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentQualification1').setVisible(false);
		    							personalInformationForm.down('#parentQualification1').reset();
		    							personalInformationForm.down('#parentQualification1').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='parentQualification2' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentQualification2').setVisible(false);
		    							personalInformationForm.down('#parentQualification2').reset();
		    							personalInformationForm.down('#parentQualification2').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='receivedChildBenefit' && records[i].isVisible==true){
		    							personalInformationForm.down('#receivedChildBenefit').setVisible(false);
		    							personalInformationForm.down('#receivedChildBenefit').reset();
		    							personalInformationForm.down('#receivedChildBenefit').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='socialPension' && records[i].isVisible==true){
		    							personalInformationForm.down('#socialPension').setVisible(false);	
		    							personalInformationForm.down('#socialPension').reset();
		    							personalInformationForm.down('#socialPension').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='parentOccupation' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentOccupation').setVisible(false);
		    							personalInformationForm.down('#parentOccupation').reset();
		    							personalInformationForm.down('#parentOccupation').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employer' && records[i].isVisible==true){
		    							personalInformationForm.down('#employer').setVisible(false);
		    							personalInformationForm.down('#employer').reset();
		    							personalInformationForm.down('#employer').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='nSFASHolder' && records[i].isVisible==true){
		    							personalInformationForm.down('#nSFASHolder').setVisible(false);
		    							personalInformationForm.down('#nSFASHolder').reset();
		    							personalInformationForm.down('#nSFASHolder').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='schoolFeePerYear' && records[i].isVisible==true){
		    							personalInformationForm.down('#schoolFeePerYear').setVisible(false);
		    							personalInformationForm.down('#schoolFeePerYear').reset();
		    							personalInformationForm.down('#schoolFeePerYear').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='isScholarship' && records[i].isVisible==true){
		    							personalInformationForm.down('#isScholarship').setVisible(false);
		    							personalInformationForm.down('#isScholarship').reset();
		    							personalInformationForm.down('#isScholarship').allowBlank=true;
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='payStudy' && records[i].isVisible==true){
		    							personalInformationForm.down('#payStudy').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='parentAnnualIncome' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentAnnualIncome').setVisible(true);
		    						}
		    						personalInformationForm.getForm().isValid();	
		    					}else{
		    						if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='parentQualification1' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentQualification1').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='parentQualification2' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentQualification2').setVisible(true)
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='receivedChildBenefit' && records[i].isVisible==true){
		    							personalInformationForm.down('#receivedChildBenefit').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='socialPension' && records[i].isVisible==true){
		    							personalInformationForm.down('#socialPension').setVisible(true);	
		    						}
		    						else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='parentOccupation' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentOccupation').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employer' && records[i].isVisible==true){
		    							personalInformationForm.down('#employer').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='nSFASHolder' && records[i].isVisible==true){
		    							personalInformationForm.down('#nSFASHolder').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='schoolFeePerYear' && records[i].isVisible==true){
		    							personalInformationForm.down('#schoolFeePerYear').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='isScholarship' && records[i].isVisible==true){
		    							personalInformationForm.down('#isScholarship').setVisible(true);
		    						}
		    						else 	if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='payStudy' && records[i].isVisible==true){
		    							personalInformationForm.down('#payStudy').setVisible(true);
		    						}
		    						else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='parentAnnualIncome' && records[i].isVisible==true){
		    							personalInformationForm.down('#parentAnnualIncome').setVisible(true);
		    						}
		    					}
		    					
		    				}
		    				
		    			}else{
		    				if(programGroup == 'Post Graduate' || programGroup == 'Post Doctoral' || programGroup == 'Doctoral'){
				    		personalInformationForm.down('#parentQualification1').setVisible(false);
				    		personalInformationForm.down('#parentQualification1').reset();
				    		personalInformationForm.down('#parentQualification1').allowBlank=true;
				    		personalInformationForm.down('#parentQualification2').setVisible(false);	
				    		personalInformationForm.down('#parentQualification2').reset();
				    		personalInformationForm.down('#parentQualification2').allowBlank=true;
				    		personalInformationForm.down('#receivedChildBenefit').setVisible(false);
				    		personalInformationForm.down('#receivedChildBenefit').reset();
				    		personalInformationForm.down('#receivedChildBenefit').allowBlank=true;
				    		personalInformationForm.down('#socialPension').setVisible(false);	
				    		personalInformationForm.down('#socialPension').reset();
				    		personalInformationForm.down('#socialPension').allowBlank=true;
				    		personalInformationForm.down('#parentOccupation').setVisible(false);
				    		personalInformationForm.down('#parentOccupation').reset();
				    		personalInformationForm.down('#parentOccupation').allowBlank=true;
				    		personalInformationForm.down('#employer').setVisible(false);
				    		personalInformationForm.down('#employer').reset();
				    		personalInformationForm.down('#employer').allowBlank=true;
				    		personalInformationForm.down('#nSFASHolder').setVisible(false);
				    		personalInformationForm.down('#nSFASHolder').reset();
				    		personalInformationForm.down('#nSFASHolder').allowBlank=true;
				    		personalInformationForm.down('#schoolFeePerYear').setVisible(false);
				    		personalInformationForm.down('#schoolFeePerYear').reset();
				    		personalInformationForm.down('#schoolFeePerYear').allowBlank=true;
				    		personalInformationForm.down('#isScholarship').setVisible(false);
				    		personalInformationForm.down('#isScholarship').reset();
				    		personalInformationForm.down('#isScholarship').allowBlank=true;
				    		personalInformationForm.getForm().isValid();	
				    	}else{
				    		personalInformationForm.down('#parentQualification1').setVisible(true);
				    		personalInformationForm.down('#parentQualification2').setVisible(true);	
				    		personalInformationForm.down('#receivedChildBenefit').setVisible(true);	
				    		personalInformationForm.down('#socialPension').setVisible(true);	
				    		personalInformationForm.down('#parentOccupation').setVisible(true);	
				    		personalInformationForm.down('#employer').setVisible(true);
				    		personalInformationForm.down('#nSFASHolder').setVisible(true);
				    		personalInformationForm.down('#schoolFeePerYear').setVisible(true);
				    		personalInformationForm.down('#isScholarship').setVisible(true);
				    	}
		    			}
		    		}
		    		
		    	});	
		    },
		    educationFormAddBtnClick: function(window,educationForm) {
// it was not availabe in this function that's why it was creating issue
		    	var repeatedSchoolGroup = null;

		    	var form =window.getForm();
		    	var repeatedSchoolRadioGrp = educationForm.findField('educationRepeatedSubject');
		    	var filePath = window.down('#educationDownloadURL');
		    	filePath.setVisible(false);
               // repeatedSchoolRadioGrp.setVisible(false);
		    	var schoolStore = educationForm.findField('campaignSchool').getStore();
		    	// educationForm.findField('examConductedBy').setVisible(false);
		    	// educationForm.findField('instituteName').setVisible(false);
		    	schoolStore.getProxy().extraParams = {
              	  educationDepartmentId: null,
  			      educationDepartmentIsOther:false,
  			      isOthersSchoolReq:true,
  			      countryId:null,
		  		  countryRegionId:null,
		  		  cityId:null
  				};
		    	schoolStore.load();
		    	var fieldInfoPersonal = Academia.model.authentication.FormPersonalInfoFieldInfoModel;
            	var formfieldInfoPersonal = fieldInfoPersonal.data.formPersonalInfoFieldsInfo;
            	if(!isNullOrEmpty(formfieldInfoPersonal)){
            		localStorage.setItem('isVisibleSubMaximumMarks',false);
            	}else{
            		localStorage.setItem('isVisibleSubMaximumMarks',true);
            	}
		    	
		    	var $this = this;
		    	Ext.Ajax.request({
		    		type: 'rest',
		    		async: false,
		    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		    		params: {
		    			screenName: 'educationform',
		    			academyLocationId: this.getCurrentAcademyLocation(),
		    			languageCode:'en'
		    		},
		    		method: 'GET',
		    		success: function(res, action) {
		    			var response = Ext.decode(res.responseText);
		    			if( Object.keys(response).length > 0 ){
		    				var records=response.educationform;
		    				form.findField('country').reset();
		    				form.findField('countryRegion').reset();
		    				form.findField('city').reset();
		    				for(i in records){
		    					if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='campaignSchoolId'){
		    						if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='campaignSchoolId' && 
		    								records[i].isVisible==true){
		    							form.findField('instituteName').setDisabled(true);
		    							form.findField('instituteName').setVisible(false);
		    						}
		    						if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='campaignSchoolId' && 
		    								records[i].isVisible==false){
		    							form.findField('instituteName').setDisabled(false);
		    							form.findField('instituteName').setVisible(true);
		    						}
		    						if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='campaignSchoolId' && 
		    								 records[i].isVisible==true && (records[i].defaultValue=='Other' || records[i].defaultValue=='Others')){
		    							setTimeout(function() {
		    								form.findField('campaignSchool').setRawValue('Others');	
		    								form.findField('instituteName').setDisabled(false);
		    								form.findField('instituteName').setVisible(true);
		    							}, 300);
		    						}
		    					}
		    					if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subMaximumMarks'){
		    						if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subMaximumMarks' && 
		    								records[i].isVisible==true){
		    							form.findField('subMaximumMarks').setDisabled(false);
		    							localStorage.setItem('isVisibleSubMaximumMarks',true);
		    						}
		    						if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='subMaximumMarks' && 
		    								records[i].isVisible==false){
		    							form.findField('subMaximumMarks').setDisabled(true);
		    							localStorage.setItem('isVisibleSubMaximumMarks',false);
		    						}
		    					}
		    					if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='educationRepeatedSubjectId' && records[i].isVisible==true){
		    						repeatedSchoolRadioGrp.setVisible(true);
		    						filePath.setVisible(true);
		    					}
		    					if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='examBoard' && 
		    							records[i].isVisible==false){
		    						var id = null;
		    						var examBoardOther = null;
		    						Ext.Ajax.request({
		    							type: 'rest',
		    							async: true,
		    							url: SERVERURL.EXAM_BOARD_COMBO_STORE,
		    							method: 'GET',
		    							success: function(res, action) {
		    								var data = Ext.decode(res.responseText);
		    								for(var i = 0; i < data.length; i++){
		    									if(data[i].value == 'Other' || data[i].value == 'Others'){
		    										id = data[i].id
		    									}
		    								}
		    								var subjectField =  form.findField("subject");
		    								var store = subjectField.getStore();
		    								store.getProxy().extraParams = {
		    									id:id,
		    									examBoardOther:true
		    								};
		    								store.load();
		    							}
		    						});
		    						form.findField('examConductedBy').setDisabled(false);
		    						form.findField('examConductedBy').setVisible(true);
		    					}

		    					if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='educationDepartmentId' && records[i].isVisible==false){
		    						if(records[i].defaultValue=='Others' || records[i].defaultValue=='Other' || records[i].defaultValue=='' || records[i].defaultValue==null){
		    							
		    							$this.campaignSchoolDetailsDefault(form,window);
		    						}
		    					}
		    				}
		    			}else{
		    				if(repeatedSchoolGroup!=null){
		    					repeatedSchoolRadioGrp.setVisible(true);
		    					filePath.setVisible(true);
							}
							localStorage.setItem('isVisibleSubMaximumMarks',true);
		    			}
		    		}
		    	});
		    },
		    campaignSchoolDetailsDefault: function(form,window) {
		    	var educationDepartmentInnerId = null;
		    	setTimeout(function() {
		    		var campaignSchool = form.findField('campaignSchool');
          			campaignSchool.setDisabled(false);
		    		var educationDepartment = form.findField('educationDepartment');

		    		educationDepartment.getStore().load({
		    			callback: function(records, operation, success) {
		    				if (success) {
		    					for(var j in records) {
		    						if(records[j].data.value == 'Others' || records[j].data.value == 'Other') {
		    							educationDepartmentInnerId = records[j].data.id;
		    							educationDepartment.setValue(records[j].data.id);

		    							var campaignSchoolId = form.findField('campaignSchool');
		    							campaignSchoolId.getStore().getProxy().extraParams = {
		    								educationDepartmentId: educationDepartmentInnerId,
		    								educationDepartmentIsOther:true,
		    								isOthersSchoolReq:true
		    							};
		    							campaignSchoolId.getStore().reload();
		    						}
		    					}
		    				}
		    			}
		    		});
		    		window.getForm().checkValidity();

		    	}, 300);
		    },
		    reloadSubjectStoreAndEnableField: function() {
		    	var window = this.getPersonEducationForm();
		    	var form =window.getForm();
		    	var this$ = this;
		    	var examBoardVisable= form.findField('examBoard').isVisible();
		    	if(!examBoardVisable){
		    		var id = null;
		    		var examBoardOther = null;
		    		Ext.Ajax.request({
		    			type: 'rest',
		    			async: true,
		    			url: SERVERURL.EXAM_BOARD_COMBO_STORE,
		    			method: 'GET',
		    			success: function(res, action) {
		    				var data = Ext.decode(res.responseText);
		    				for(var i = 0; i < data.length; i++){
		    					if(data[i].value == 'Other' || data[i].value == 'Others'){
		    						id = data[i].id
		    					}
		    				}
		    				var subjectField =  form.findField("subject");
		    				var store = subjectField.getStore();
		    				store.getProxy().extraParams = {
		    					id:id,
		    					examBoardOther:true
		    				};
		    				store.load();
		    		}
		    	});
		    		form.findField('examConductedBy').setDisabled(false);
		    		form.findField('examConductedBy').setVisible(true);
		    	}
		    },
		    restOrReloadFields: function() {
		    	var window = this.getPersonEducationForm();
		    	var form =window.getForm();
		    	var this$ = this;
		    	var examBoardVisable= form.findField('examBoard').getRawValue();
		    	if(examBoardVisable != 'Other' || examBoardVisable != 'Others'){
		    		var subjectMarkPanel = window.down('#subjectMarkPanel');
            		for(var i=subjectMarkPanel.items.length-1; i>0;i--){
            			subjectMarkPanel.remove(subjectMarkPanel.items.items[i]);
            		}
            		window.doLayout();
            		var subjectField =  form.findField("subject");
            		var store = subjectField.getStore();
            		if (window.items.items != null && window.items.items.length > 0) {
            			Ext.each(window.items.items, function(val) {
            				if(val.itemId =='subjectMarkPanel'){
            					Ext.each(val.items.items, function(valueSubject){
            						valueSubject.items.get('subject').reset();
            						valueSubject.items.get('marks').reset();
            						valueSubject.items.get('marks').isValid();
            					});
            				}
            			});
            		}
		    		
		    	}
		    },
		    savePostSchoolStudiesDetails: function(gridItemId, saveUrl, updateUrl,person) {
				 var this$ = this;
				 var form = this$.getPostSchoolStudiesForm();
				 if (form.getForm().isValid()) {
					 var transcriptDocField = form.down('#transcriptItemId');
					 var certificatetDocField = form.down('#certificateItemId');
					 var transcriptDocFieldValue = transcriptDocField.getValue();
					 var certificatetDocFieldValue = certificatetDocField.getValue();
					 var personObj = this$.getPersonObj();
					 var data = new Object();
					 data.entityId = personObj.id;
					 data.module = 'applicant';
					 data.entityType = 'postSchoolStudy';
					 form.getForm().setValues(data);
					 var uplaodUrl = SERVERURL.PATH_UPLOAD_POST_SCHOOL_STUDY_DOC;
					 this$.applyWindowMask(); 
					 if (!isNullOrEmpty(transcriptDocFieldValue) || !isNullOrEmpty(certificatetDocFieldValue)) {
						 form.getForm().submit({
							 method: 'POST',
							 url: uplaodUrl,
							 success: function(form1, action) {
								 // callback(true);
								 var responseData = Ext.decode(action.response.responseText);
								 var path = responseData.path;
								 var pathForSecondFile = responseData.pathForSecondFile;
								 if (!isNullOrEmpty(path)) {
									 form.getForm().findField('transcriptDocPath').setValue(path);
								 }
								 if (!isNullOrEmpty(pathForSecondFile)) {
									 form.getForm().findField('certificateDocPath').setValue(pathForSecondFile);
								 }
								 this$.savePostSchoolStudiesRecordDetails(form ,gridItemId, saveUrl, updateUrl,person);
							 }
						 });
					 } else {
						 this$.savePostSchoolStudiesRecordDetails(form ,gridItemId, saveUrl, updateUrl,person);
					 }
				}else{
		        	showWarningMessage(getPersonModuleTranslation('POST_SCHOOL_STUDIES'), getPersonModuleTranslation('MANDATORY_FIELDS_NOT_FILLED'));	
				}
			 },
		    
		     savePostSchoolStudiesRecordDetails:function(form ,gridItemId, saveUrl, updateUrl,person) {
			        var this$ = this;
			        	var personProfile = this$.getContentPanelActiveTab();
				        var grid = personProfile.down(gridItemId);
				        var submitUrl, isUpdate = false;
				        var id = form.down('#postSchool_hidden_field');
				        var jsonFormatFormData;
				        if (isNullOrEmpty(id.getSubmitValue())) {
				            submitUrl = saveUrl; 
				            isUpdate = false;
				            var methodtype = 'POST';
				            jsonFormatFormData = this$.getJsonPostSchoolStudiesData(form,personProfile.getPersonId(),person);
				        } else {
				            submitUrl = updateUrl; 
				            isUpdate = true;
				            var methodtype = 'PUT';
				            jsonFormatFormData = this$.getJsonPostSchoolStudiesData(form,personProfile.getPersonId(),person);
				        }
				        
				        // Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'),
						// 'x-mask-loading');
				        this$.sendSaveAjaxRequest(submitUrl,methodtype, jsonFormatFormData, function(option, success, response) {
				        	this$.hideWindowMask();
				        	if(success){
				        		this$.closePersonCommonWindow();
				        		grid.getStore().reload();
				        		grid.getSelectionModel().deselectAll();
				        		if(grid.itemId == 'applicantPostSchoolStudiesGrid'){
				        			if(Ext.isDefined(Ext.ComponentQuery.query('#applicationsListGrid')[0])){
					        			var apGrid = Ext.ComponentQuery.query('#applicationsListGrid')[0]
					        			apGrid.getStore().reload();
					        		}
				        		}
				        		if (isUpdate) {
				        			showSuccessMessage(getPersonModuleTranslation('POST_SCHOOL_STUDIES'), getCommonTranslation('POST_SCHOOL_STUDIES_UPDATE_SUCCESSFULLY'));
				        		} else {
				        			showSuccessMessage(getPersonModuleTranslation('POST_SCHOOL_STUDIES'), getCommonTranslation('POST_SCHOOL_STUDIES_ADD_SUCCESSFULLY'));
				        		}
				        		if(person == 'applicant'){
				        			this$.mixins.ApplicationBaseController.getApplicantProfileInformation(personProfile);
				        		}
				        	}else{
				        		this$.closePersonCommonWindow();
				        		grid.getStore().reload();
				        	}
				        	this$.resetPageSetting(grid.getStore());
				        });	
			    },
			    employeeReferenceGrid:function(gridItemId, url){
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var personObj = this$.getPersonObj();
			        var grid = personProfile.down(gridItemId);
			        if (grid) {
			            var personId=null;
			            var applicantPersonId=null;
			            if(gridItemId=="#employeeReferenceGrid"){// Employee
			            	applicantPersonId = personObj["id"];
			            }else{// student
			            	personId = personObj["id"];
			            }
			            var store = grid.getStore();
			            this$.resetPageSetting(store);
			            store.getProxy().api.read = url;
			            store.getProxy().extraParams = {
			            	employeeId:applicantPersonId,
			            	
			            };
			            store.load();
			        }
			 }, 
			    addReferences: function() {
					 var window = Ext.widget('employeereferenceformwindow');
				      window.show();
				      
				    },
			     editReferences: function(grid, isView) {
			        var me = this;
			        if (grid.getSelectionModel().getCount() > 0) {
			            me.addReferences(); // show References Details Dialog
											// box
			            var record = grid.getSelectionModel().getSelection()[0];
			            var window = me.getEmployeereferenceformwindow();
			            if (window) {
			            	
			                var referenceForm = window.down('#employeereferenceform');
			                if (!isEmpty(record) && !isEmpty(referenceForm)) {
			                    var rec = new Academia.model.admission.applications.applicationDetailsAndReferences.ReferenceModel(record.data);
			                    referenceForm.loadRecord(rec);
			                    if(record.data.salutation.id!=null && record.data.salutation.id!=undefined) {
				                    var salutationId = record.data.salutation.id;
				                    var salutation = referenceForm.down('#salutation');
				                    var store = salutation.getStore();
				                    store.load({
				                    	callback: function(records, operation, success) {
				                    		if (success) {
				                    			for(var i in records) {
				                    				if(records[i].data.id == salutationId) {
				                    					salutation.setValue(records[i].data.id);
				                    				}
				                    			}
				                    		}
				                    	}
				                    });
			                    }
							    if (isView) {
			                        window.down('#btnSaveReferencesForm').setVisible(false);
			                        toggleReadOnlyFormItems(referenceForm.getForm(), true);
			                    }
			                }
			            }
			        } else {
			        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
																															// select
																															// a
																															// record.
			        }
			    },
			    deleteReferences: function(grid) {
			    	
			        var grdStore = grid.getStore();
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getAdmissionTranslation('DELETE_REFERENCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var referenceId = "",
			                                url = '';
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                referenceId = records[count].get("id");
			                                url = SERVERURL.EMPLOYEE_REFERENCES_DELETE;                                     
			                                if (!isNullOrEmpty(referenceId) && !isNullOrEmpty(url)) {
			                                    url = url.concat("/" + referenceId);
			                                    Ext.Ajax.request({
			                                        type: 'rest',
			                                        method: 'DELETE',
			                                        url: url,
			                                        success: function(form, action) {
			                                            showSuccessMessage(getAdmissionTranslation('DELETE_REFERENCE'), getAdmissionTranslation('DELETE_REFERENCE_MSG')); // References
																																											// deleted
																																											// successfully.
			                                            grdStore.reload();
			                                        }
			                                    });
			                                }
			                            }
			                        }
			                    }
			                }
			            });
			        } else {
			        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
																															// select
																															// a
																															// record.
			        }
			    },
			    getJsonPostSchoolStudiesData: function(form,personId,person) {
			    	var this$ = this;
			        var jsonFormFieldData = new Object();
			        var formData = form.getValues();
			        var postSchoolStudiesDataModel = new Academia.model.personinfo.common.pasthistory.PostSchoolStudiesDataModel();
			        postSchoolStudiesDataModel.set("id",formData.id);
			        postSchoolStudiesDataModel.set("institutionName",this$.getIdOnlyJson(formData.institutionName));
			        postSchoolStudiesDataModel.set("institutionStatus",this$.getIdOnlyJson(formData.institutionStatus));
			        postSchoolStudiesDataModel.set("country",this$.getIdOnlyJson(formData.country));
			        postSchoolStudiesDataModel.set("qualificationStatus",this$.getIdOnlyJson(formData.qualificationStatusPostSchool));
			        postSchoolStudiesDataModel.set("rsaNqfComparableLevel",this$.getIdOnlyJson(formData.rsaNqfComparableLevel));
			        postSchoolStudiesDataModel.set("academicTranscriptVerification",this$.getIdOnlyJson(formData.academicTranscriptVerification));
			        postSchoolStudiesDataModel.set("degreeCertificateVerification", this$.getIdOnlyJson(formData.degreeCertificateVerification));
			        postSchoolStudiesDataModel.set("qualificationName",formData.qualificationName);
			        postSchoolStudiesDataModel.set("qualificationType",formData.qualificationType);
			        postSchoolStudiesDataModel.set("noOfSemestersCompleted",formData.noOfSemestersCompleted);
			        postSchoolStudiesDataModel.set("remarks",formData.remarks);
			        postSchoolStudiesDataModel.set("overallAverageAchieved",formData.overallAverageAchieved);
			        postSchoolStudiesDataModel.set("researchModuleGrade",formData.researchModuleGrade);
			        postSchoolStudiesDataModel.set("commentaryByAssessor",formData.commentaryByAssessor);
			        postSchoolStudiesDataModel.set("studentNumber",formData.studentNumber); 
			        postSchoolStudiesDataModel.set("institutionNameTextField",formData.institutionNameTextField); 
			        postSchoolStudiesDataModel.set("transcriptDocPath",formData.transcriptDocPath); 
			        postSchoolStudiesDataModel.set("certificateDocPath",formData.certificateDocPath); 
			        postSchoolStudiesDataModel.set("transcriptDocStatus",formData.admDocumentStatusCSMTranscript);
			        postSchoolStudiesDataModel.set("certificateDocStatus",formData.admDocumentStatusCSMCertificate);
			        postSchoolStudiesDataModel.set("doctoralThesis",formData.doctoralThesis);
			        postSchoolStudiesDataModel.set("studiesCompleted",this$.getIdOnlyJson(formData.completedCombo));
				       
			    	var recommendationArr = new Array();
		        	var recData=form.down('#recommendationContainer').items.items;
		        
		        	if(recData.length == 1){
		        		var temp1=new Object();
		        		if(!isNullOrEmpty(formData["eligibilityRecommendation"])){
		        			temp1.eligibilityRecommendation ={
		        					id:formData["eligibilityRecommendation"]
		        			};
		        			temp1.programBatchSeatConfigurations ={
		        					id:parseInt(formData["programBatchSeatConfigurations"])
		        			};
		        		}
		        		if(!isNullOrEmpty(formData["recommendedFor"])){
		        			temp1.recommendedFor ={
		        					id:formData["recommendedFor"]
		        			};
		        		}
		        		if(!Ext.Object.isEmpty(temp1)){
		        			recommendationArr.push(temp1);	
		        		}
		        	}else{
		        		for(var i in recData){
		        			var temp1=new Object();
			        		if(!isNullOrEmpty(formData["eligibilityRecommendation"][i])){ 
			        			temp1.eligibilityRecommendation ={
			        					id:formData["eligibilityRecommendation"][i]
			        			};
			        			temp1.programBatchSeatConfigurations ={
			        					id:parseInt(formData["programBatchSeatConfigurations"][i])
			        			};
			        		}
			        		if(!isNullOrEmpty(formData["recommendedFor"][i])){ 
			        			temp1.recommendedFor ={
			        					id:formData["recommendedFor"][i]
			        			};
			        		}
			        		if(!Ext.Object.isEmpty(temp1)){
			        			recommendationArr.push(temp1);	
			        		}
			        	}
		        	}
		        	 postSchoolStudiesDataModel.set("postSchoolStudiesRecommendation",recommendationArr);
			        if(person == 'applicant'){
			        	postSchoolStudiesDataModel.set("applicantPerson",this$.getIdOnlyJson(personId));
			        	delete postSchoolStudiesDataModel.data.persons;
			        }else{
			        	postSchoolStudiesDataModel.set("persons",this$.getIdOnlyJson(personId));
			        	delete postSchoolStudiesDataModel.data.applicantPerson;
			        }
			        delete postSchoolStudiesDataModel.data.postSchoolStudiesSection;
			        delete postSchoolStudiesDataModel.data.recommendedFor;
			        delete postSchoolStudiesDataModel.data.eligibilityRecommendation;
			        delete postSchoolStudiesDataModel.data.programBatchSeatConfigurations;
			        if(!isNullOrEmpty(formData.periodFrom)){
			        	postSchoolStudiesDataModel.set("periodFrom",formData.periodFrom);
			        }else{
			        	delete postSchoolStudiesDataModel.data.periodFrom;
			        }
			        
			        if(!isNullOrEmpty(formData.periodTo)){
			        	postSchoolStudiesDataModel.set("periodTo",formData.periodTo);
			        }else{
			        	delete postSchoolStudiesDataModel.data.periodTo;
			        }
			        
			        jsonFormFieldData = Ext.encode(postSchoolStudiesDataModel.data);
			        return jsonFormFieldData;
			    },
			    deletePostSchoolStudiesInfoRecord:function(gridItemId,deleteUrl){
			    	var this$ = this;
			    	var personProfile = this$.getContentPanelActiveTab();
			    	var grid = personProfile.down(gridItemId);

			    	if (grid.getSelectionModel().getCount() > 0) {
			    		showConfirmMessage(getPersonModuleTranslation('POST_SCHOOL_STUDIES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			    			if (btn == 'yes') {
			    				if (grid.getSelectionModel().getCount() > 0) {
			    					var records = grid.getSelectionModel().getSelection();
			    					for (var count = 0; count < records.length; count++) {
			    						var id = "";
			    						if (!isNullOrEmpty(records[count].get("id"))) {
			    							id=records[count].get("id");
			    						}
			    						Ext.Ajax.request({
			    							type: 'rest',
			    							url: deleteUrl, 
			    							method: 'DELETE',
			    							headers: {
			    								'Content-Type': 'application/json'
			    							},
			    							params: {
			    								id:id
			    							},
			    							success: function(form, action) {
			    								grid.getStore().reload();
			    								if(grid.itemId == 'applicantPostSchoolStudiesGrid'){
			    									this$.mixins.ApplicationBaseController.getApplicantProfileInformation(personProfile);
			    				        			if(Ext.isDefined(Ext.ComponentQuery.query('#applicationsListGrid')[0])){
			    					        			var apGrid = Ext.ComponentQuery.query('#applicationsListGrid')[0]
			    					        			apGrid.getStore().reload();
			    					        		}
			    				        		}
			    								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('POST_SCHOOL_STUDIES_DELETE_SUCCESS'));
			    							}
			    						});
			    					}
			    				}
			    			}
			    		});
			    	} else {
			    		showWarningMessage(getPersonModuleTranslation('POST_SCHOOL_STUDIES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			    	}

			    },
			    editPostSchoolStudiesFormWindow:function(informationType, formItemId, gridItemId,isView){
			    	var this$ = this;
			    	var personProfile = this$.getContentPanelActiveTab();
			    	var grid = personProfile.down(gridItemId);
			    	if (grid.getSelectionModel().getCount() > 0) {
			    		this.showPersonCommonWindow(informationType, formItemId);
			    		var form = Ext.ComponentQuery.query('postschoolstudiesform')[0];
             		   var record = grid.getSelectionModel().getSelection()[0];
             		   var id = record.get("id");
             		   var editUrl = SERVERURL.PATH_FIND_BY_ID_POST_SCHOOLS_STUDIES_SECTION;
             		  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
             		   Ext.Ajax.request({
             			   method: "GET",
             			   type: 'rest',
             			   url: editUrl,
             			   params: {
             				   id: id
             			   },
             			   success: function(response, action) {
             				   var responseData = Ext.JSON.decode(response.responseText);
             				   form.down("#postSchool_hidden_field").setValue(id);
             				   form.down("#periodFrom").setValue(responseData.periodFrom);
             				   form.down("#qualificationNameItemId").setValue(responseData.qualificationName);
             				  // form.down("#qualificationType").setValue(responseData.qualificationType);
             				   var completedComboItemId = form.down("#completedComboItemId");
             				   var institutionNameItemId = form.down("#institutionNameItemId");
             				   form.down("#studentNumberItemId").setValue(responseData.studentNumber);
             				   form.down("#institutionNameTextFieldItemId").setValue(responseData.institutionNameTextField);
             				   form.down("#remarksItemId").setValue(responseData.remarks);
             				   var institutionStatusItemId = form.down("#institutionStatusItemId");
             				   var countryItemId = form.down("#countryItemId");
             				   var qualificationStatusItemId = form.down("#qualificationStatusPostSchoolItemId");
             				   var qualificationTypeItemId =form.down("#qualificationType");
             				   var rsaNqfComparableLevelItemId = form.down("#rsaNqfComparableLevelItemId");
             				   form.down("#overallAverageAchievedItemId").setValue(responseData.overallAverageAchieved);
             				   form.down("#reserchModuleGradeItemId").setValue(responseData.researchModuleGrade);
             				   form.down("#commentaryAssessorItemId").setValue(responseData.commentaryByAssessor);
             				   form.down("#certificateDocPath").setValue(responseData.certificateDocPath);
             				   form.down("#transcriptDocPath").setValue(responseData.transcriptDocPath);
             				   form.down("#certificateDownloadURL").setValue(responseData.certificateDocPath);
            				   form.down("#transriptDownloadURL").setValue(responseData.transcriptDocPath);
            				   form.down("#doctoralThesisId").setValue(responseData.doctoralThesis);
            				   
            				   if(!isNullOrEmpty(responseData.transcriptDocPath)){
            					   form.down("#admDocumentStatusTranscript").setValue(responseData.transcriptDocStatus);
            					   form.down("#admDocumentStatusTranscript").setDisabled(false);
            				   }else{
            					   form.down("#admDocumentStatusTranscript").setValue();
            					   form.down("#admDocumentStatusTranscript").setDisabled(true);
            				   }
            				   if(!isNullOrEmpty(responseData.certificateDocPath)){
            					   form.down("#admDocumentStatusCertificate").setValue(responseData.certificateDocStatus);
            					   form.down("#admDocumentStatusCertificate").setDisabled(false);
            				   }else{
            					   form.down("#admDocumentStatusCertificate").setValue();
            					   form.down("#admDocumentStatusCertificate").setDisabled(true);
            				   }
             				   var academicTranscriptItemId = form.down("#academicTranscriptItemId");
             				   var degreeeCertificationItemId = form.down("#degreeeCertificationItemId");
             				   var periodTo=  form.down("#periodTo")
             				   Ext.getBody().unmask();
             				   if(!isNullOrEmpty(responseData.studiesCompleted)){
             					   var completedComboItemIdStore = completedComboItemId.getStore();
             					   completedComboItemIdStore.getProxy().extraParams={
                 						type:'Studies Completed'
       	            			   };
             					   completedComboItemIdStore.load({
             						   callback: function(record, operation, success) {
             							   if (success) {
             								   for(i in record){
             									   if(responseData.studiesCompleted.value == "Yes"){
             										   completedComboItemId.setValue(responseData.studiesCompleted.id);
             										   periodTo.setDisabled(false);
             										   form.down("#periodTo").setValue(responseData.periodTo);
             										   form.down("#transcriptItemId").setDisabled(false);
             										   form.down("#certificateItemId").setDisabled(false);
             										  if (responseData.certificateDocPath != null) {
                                                          form.down("#certificateItemId").allowBlank = true
                                                      } else {
                                                          form.down("#certificateItemId").allowBlank = false
                                                      }
             									   }else if(responseData.studiesCompleted.value == "No"){
             										   completedComboItemId.setValue(responseData.studiesCompleted.id);
             										   periodTo.setDisabled(true);
             										   form.down("#periodTo").setValue(responseData.periodTo);
             										   form.down("#noOfSemesterCompletedItemId").setValue(responseData.noOfSemestersCompleted);
             										   form.down("#transcriptItemId").setDisabled(false);
             									   }else{
             										   completedComboItemId.setValue(responseData.studiesCompleted.id);
             										   periodTo.setDisabled(true);
             										   form.down("#periodTo").setValue(responseData.periodTo);
             										   form.down("#noOfSemesterCompletedItemId").setValue(responseData.noOfSemestersCompleted);
             										   form.down("#transcriptItemId").setDisabled(false);
             									   }
             								   } 
             							   }
             						   }
             					   });
             				   }
             				  if(responseData.institutionName){
             					var institutionNameItemIdStore = institutionNameItemId.getStore();
             					 institutionNameItemIdStore.load({
            						   callback: function(record, operation, success) {
            							   if (success) {
            								   institutionNameItemId.setValue(responseData.institutionName.id);
            							   }
            						   }
            					   });
            				   }
             				  if(responseData.institutionName != null){
             					 if(responseData.institutionName.code.length>4){
                					  var institutionNameCombo = responseData.institutionName.code.substring(0,4);
                					  institutionNameCombo = institutionNameCombo.toUpperCase();
                					  if(institutionNameCombo === 'OTHE'){
                						  form.down('#institutionNameTextFieldItemId').setVisible(true);
                						  form.down("#institutionNameTextFieldItemId").setValue(responseData.institutionNameTextField);
                					  }else{
                						  form.down('#institutionNameTextFieldItemId').setVisible(false);
                						  form.down('#institutionNameTextFieldItemId').allowBlank=true
                					  }
                				  }else{
                 					  form.down('#institutionNameTextFieldItemId').setVisible(false);
                 					  form.down('#institutionNameTextFieldItemId').allowBlank=true
                 				  }
             				  }
             				  
             				 if(responseData.qualificationStatus){
              					var qualificationStatusItemIdStore = qualificationStatusItemId.getStore();
              					qualificationStatusItemIdStore.getProxy().extraParams={
              						type:'Qualification Status'
    	            			};
              					qualificationStatusItemIdStore.load({
              						callback: function(record, operation, success) {
              							if (success) {
              								qualificationStatusItemId.setValue(responseData.qualificationStatus.id);
              							}
              						}
              					});
             				   }
             				 if(responseData.qualificationType){
               					var qualificationTypeItemIdStore = qualificationTypeItemId.getStore();
               					qualificationTypeItemIdStore.getProxy().extraParams={
               						type:'Qualification Type'
     	            			};
               					qualificationTypeItemIdStore.load({
               						callback: function(record, operation, success) {
               							if (success) {
               								qualificationTypeItemId.setValue(responseData.qualificationType.id);
               							}
               						}
               					});
              				   }
             				if(responseData.country){
             					var countryItemIdStore = countryItemId.getStore();
             					 countryItemIdStore.load({
            						   callback: function(record, operation, success) {
            							   if (success) {
            								   countryItemId.setValue(responseData.country.id);
            							   }
            						   }
            					   });
            				   }
             				if(responseData.institutionStatus){
             					var institutionStatusItemIdStore = institutionStatusItemId.getStore();
             					institutionStatusItemIdStore.getProxy().extraParams={
    	            				type:'Institution Status'
    	            			};
             					institutionStatusItemIdStore.load({
             						callback: function(record, operation, success) {
             							if (success) {
             								institutionStatusItemId.setValue(responseData.institutionStatus.id);
             							}
             						}
             					});
            				   }
             				if(responseData.rsaNqfComparableLevel){
             					var rsaNqfComparableLevelItemIdStore = rsaNqfComparableLevelItemId.getStore();
             					rsaNqfComparableLevelItemIdStore.getProxy().extraParams={
             						type:'RSA NQF Comparable Level'
    	            			};
             					rsaNqfComparableLevelItemIdStore.load({
             						callback: function(record, operation, success) {
             							if (success) {
             								rsaNqfComparableLevelItemId.setValue(responseData.rsaNqfComparableLevel.id);
             							}
             						}
             					});
		    
             				}
             				if(responseData.academicTranscriptVerification){
             					var academicTranscriptItemIdStore = academicTranscriptItemId.getStore();
             					academicTranscriptItemIdStore.getProxy().extraParams={
             						type:'Verification of Academic Script'
    	            			};
             					academicTranscriptItemIdStore.load({
             						callback: function(record, operation, success) {
             							if (success) {
             								academicTranscriptItemId.setValue(responseData.academicTranscriptVerification.id);
             							}
             						}
             					});
            				   }
             				if(responseData.degreeCertificateVerification){
             					var degreeeCertificationItemIdStore = degreeeCertificationItemId.getStore();
             					degreeeCertificationItemIdStore.getProxy().extraParams={
             						type:'Verification of Degree Certificate'
    	            			};
             					degreeeCertificationItemIdStore.load({
             						callback: function(record, operation, success) {
             							if (success) {
             								degreeeCertificationItemId.setValue(responseData.degreeCertificateVerification.id);
             							}
             						}
             					});
            				   }
             				    var recommendationLength= responseData.postSchoolStudiesRecommendation.length;
             				   var fieldPanel=form.down('#recommendationContainer');
             				    if(recommendationLength>0){
             				    	for (var j = 0; j < recommendationLength; j++) {
             				    		this$.addPostSchoolStudiesFields();
             				    		var eligibilityRecommendation = fieldPanel.items.items[j];
             				    		if(j == 0){
             				    			fieldPanel.items.items[0].items.items[3].hideLabel = false;
             				    			fieldPanel.items.items[0].items.items[3].labelSeparator = '';
             				    			fieldPanel.items.items[0].items.items[2].hideLabel = false;
             				    			fieldPanel.items.items[0].items.items[2].labelSeparator = '';
	            						}else{
	            							eligibilityRecommendation.items.items[1].setFieldLabel();
	            							eligibilityRecommendation.items.items[2].setFieldLabel();
	            							eligibilityRecommendation.items.items[3].setFieldLabel();
	            						}
             				    		if(isView == true){
             				    			eligibilityRecommendation.items.items[2].setReadOnly(true);
             				    			eligibilityRecommendation.items.items[3].setReadOnly(true);
             				    		}
             				    		if(!isNullOrEmpty(responseData.postSchoolStudiesRecommendation[j].programBatchSeatConfigurations)){
             				    			eligibilityRecommendation.items.items[0].setValue(responseData.postSchoolStudiesRecommendation[j].programBatchSeatConfigurations.id);
             				    		}
             				    		if(!isNullOrEmpty(responseData.postSchoolStudiesRecommendation[j].progamBatchSeatTypeSting)){
             				    			eligibilityRecommendation.items.items[1].setValue(responseData.postSchoolStudiesRecommendation[j].progamBatchSeatTypeSting);
             				    		}
             				    		var eligibilityRecommendationStore = eligibilityRecommendation.items.items[2].getStore();
             				    		eligibilityRecommendationStore.getProxy().extraParams={
                     						type:'Eligibility Recommendation'
            	            			};
             				    		eligibilityRecommendationStore.load();
             				    		if(!isNullOrEmpty(responseData.postSchoolStudiesRecommendation[j].eligibilityRecommendation)){
             				    			
             				    			eligibilityRecommendation.items.items[2].setValue(responseData.postSchoolStudiesRecommendation[j].eligibilityRecommendation.id);
             				    		}
             				    		if(!isNullOrEmpty(responseData.postSchoolStudiesRecommendation[j].recommendedFor)){
             				    			eligibilityRecommendation.items.items[4].getStore().load();
             				    			eligibilityRecommendation.items.items[4].setValue(responseData.postSchoolStudiesRecommendation[j].recommendedFor.id);
             				    		}
             				    		if(!isNullOrEmpty(responseData.postSchoolStudiesRecommendation[j].academyLocation)){
             				    			eligibilityRecommendation.items.items[3].getStore().load();
             				    			eligibilityRecommendation.items.items[3].setValue(responseData.postSchoolStudiesRecommendation[j].academyLocation.id);
             				    		}
            	    				}
             				    }else{
             				    	var applicantProfile = this$.getContentPanelActiveTab();
             				    	Ext.Ajax.request({
        	            				type: 'rest',
        	            				url: SERVERURL.PATH_FINDPAROGRAM_BATCH_SEAT_APPID +'?applicationID='+applicantProfile.getApplicationId(),
        	            				method: 'GET',
        	            				success: function(res, action) {
        	            					var data = Ext.decode(res.responseText);
        	            					if(!isEmpty(data)){
        	            						for(var i = 0; i<data.length;i++) {
        	            							fieldPanel.add({
        	            			    			   xtype : 'fieldcontainer',
        	            			    			   layout:'hbox',
        	            			    			   defaults: {
        	            			    				   labelAlign: 'top',
        	            			    				   width: 226
        	            			    			   },
        	            			    			   items : [{
        	            							        xtype: 'hidden',
        	            							        itemId: 'postSchoolProgram_hidden_field'+[i],
        	            							        name: 'programBatchSeatConfigurations',
        	            							        value:data[i].id
        	            							    },{
        	            			    					xtype: 'displayfield',
        	            			    					name: 'progamName',
        	            			    					value:data[i].value,
        	            			    					itemId :'progamNameItemId'+[i]
        	            			    				},{
        	            			    				   xtype: 'customcombobox',
        	            			    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
        	            			    				   itemId: 'eligibilityRecommendationItemId'+[i],
        	            			    				   valueField: 'id',
        	            			    				   displayField: 'value',
        	            			    				   allowBlank: false,
        	            			    				   name: 'eligibilityRecommendation',
        	            			    				   editable: false,
        	            			    				   listeners:{
        	            			    						 change:function(obj,rec,value){
        	            			    							 var nxtSib = obj.nextSibling();
        	            			    							 var form = obj.up('postschoolstudiesform');
        	            			    							 if(obj.getRawValue() == 'Eligible in Others'){
        	            			    								 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
        	            			    								 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
        		            		    								 nxtSib.setVisible(true);
        		            			    							 obj.nextSibling().getStore().load(); 
        		            			    							 
        		            			    							 nxtSib.nextSibling().setVisible(true);
        		            			    							 nxtSib.nextSibling().allowBlank=false;
        		            			    							 nxtSib.nextSibling().validate();
        		            			    							 nxtSib.nextSibling().getStore().load(); 
        	            			    							 }else{
        		            			    							 nxtSib.setVisible(false);
        		            			    							 nxtSib.allowBlank=true;
        		            			    							 nxtSib.clearValue();
        		            			    							 
        		            			    							 nxtSib.nextSibling().setVisible(false);
        		            			    							 nxtSib.nextSibling().allowBlank=true;
        		            			    							 nxtSib.nextSibling().clearValue();
        		            			    							 nxtSib.nextSibling().validate();
        		            			    							 var fieldPanel=form.down('#recommendationContainer');
        	            			    								 for (var j = 0; j < fieldPanel.items.items.length; j++) {
        	            			    									 var eligibilityRecommendation = fieldPanel.items.items[j];
        	            			    									if(!eligibilityRecommendation.items.items[3].isHidden()){
        	            			    										 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
        	            			    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
        	            			    										 return false;
        	            			    									}else{
        	            			    										 form.down('#recommendedFieldLabelItemId').setFieldLabel();
        	            			    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel();
        	            			    									}
        	            			    								 }
        	            			    							 }
        	            			    						 }
        	            			    		  			   }
        	            			    				},{
        	            			    					xtype : 'multiselectcombofield',
        	            			    					name : 'academyLocation',
        	            			    					itemId:'academyLocationId'+[i],
        	            			    					autoloadStore: false,
        	            			    					store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
        	            			    					valueField : 'id',
        	            			    					displayField : 'value',
        	            			    					hidden:true,
        	            			    					allowBlank : false,
        	            			    					queryParam:'qry',
        	            			    					minChars:3,
        	            			    					typeAhead:true,
        	            			    					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	            			    					enableKeyEvents  : 'true',
        	            			    					hideTrigger:false,
        	            			    					forceSelection:true,
        	            			    					cls:'receiptHeaderMultiselect',
        	            			    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	            			    					listConfig: {
        	            			    						listeners: {
        	            			    							beforeshow: function(picker) {
        	            			    								picker.minWidth = picker.up('combobox').getSize().width;
        	            			    							},
        	            			    							afterRender: function(combo){
        	            			    								combo.getStore().on("load", function(store, items){
        	            			    									if(items.length==0)
        	            			    										Ext.select('.x-boundlist-item').elements[0].hidden = true;
        	            			    									else
        	            			    										Ext.select('.x-boundlist-item').elements[0].hidden = false;
        	            			    						        });
        	            			    							}
        	            			    						},
        	            			    						loadingText: getCommonTranslation('SEARCHING'),
        	            			    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	            			    						getInnerTpl: function() {
        	            			    							return '<div class="search-item">' +
        	            			    							'{code}' +
        	            			    							'</div>';
        	            			    						}
        	            			    					}
        	            			    				},{
        	            			    					xtype: 'customcombobox',
        	            			    					store: Ext.create('Academia.store.scholarships.AssociateProgramStore'),
        	            			    					itemId: 'recommendedForItemId'+[i],
        	            			    					valueField: 'id',
        	            			    					hidden:true,
        	            			    					displayField: 'value',
        	            			    					name: 'recommendedFor',
        	            			    					queryParam:'programName',
        	            			    					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	            			    					enableKeyEvents  : 'true',
        	            			    					minChars:3,
        	            			    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	            			    					typeAhead:false,
        	            			    					hideTrigger:false,
        	            			    					forceSelection:true
        	            			    				}]
        	            			    		   });
        	            						if(i == 0){
        	            							form.down('#recommendedForItemId'+[i]).hideLabel = false;
        	            							form.down('#recommendedForItemId'+[i]).labelSeparator = '';
        	            							form.down('#eligibilityRecommendationItemId'+[i]).hideLabel = false;
        	            							form.down('#eligibilityRecommendationItemId'+[i]).labelSeparator = '';
        	            						}
        	            						var eligibilityRecommendationStore = form.down('#eligibilityRecommendationItemId'+[i]).getStore();
        		    	            			eligibilityRecommendationStore.getProxy().extraParams={
        		    	            				type:'Eligibility Recommendation'
        		    	            			};
        	            						}	
        	            					}
        	            				}
        	            			});
        	            			form.doLayout();
             				    }
             			   }
             		   });
             	   }else {
			    		showWarningMessage(getPersonModuleTranslation('POST_SCHOOL_STUDIES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			    	}
			    },
			    viewPostSchoolStudiesFormWindow:function(informationType, formItemId, gridItemId){
			    	var this$ = this;
			    	this$.editPostSchoolStudiesFormWindow(informationType, formItemId, gridItemId,true);
			    	var form = this$.getPostSchoolStudiesForm();
			    	this$.viewPersonCommonWindow(form);
			    },
			    addPostSchoolStudiesFields: function(obj){
					 var this$ = this;
					 var form = this$.getPostSchoolStudiesForm();
					 var stopContiner = form.down('#recommendationContainer');
					 var panelItem = new Array();
					 var newcont=stopContiner.items.items.length;
					 var insertPosition=newcont+1;
					 panelItem.push({
		    			   xtype : 'fieldcontainer',
		    			   layout:'hbox',
		    			   defaults: {
		    				   labelAlign: 'top',
		    				   width: 226
		    			   },
		    			   items : [{
						        xtype: 'hidden',
						        itemId: 'postSchoolProgram_hidden_field'+[i],
						        name: 'programBatchSeatConfigurations'
						    },{
		    					xtype: 'displayfield',
		    					name: 'progamName',
		    					itemId :'progamNameItemId'+[i]
		    				},{
		    				   xtype: 'customcombobox',
		    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
		    				   itemId: 'eligibilityRecommendationItemId'+[i],
		    				   valueField: 'id',
		    				   displayField: 'value',
		    				   allowBlank: false,
		    				   name: 'eligibilityRecommendation',
		    				   editable: false,
		    				   listeners:{
		    						 change:function(obj,rec,value){
		    							 var nxtSib = obj.nextSibling();
		    							 var form = obj.up('postschoolstudiesform');
		    							 if(obj.getRawValue() == 'Eligible in Others'){
		    								 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
		    								 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
		    								 nxtSib.setVisible(true);
			    							 obj.nextSibling().getStore().load(); 
			    							 
			    							 nxtSib.nextSibling().setVisible(true);
			    							 nxtSib.nextSibling().allowBlank=false;
			    							 nxtSib.nextSibling().validate();
			    							 nxtSib.nextSibling().getStore().load(); 
			    							 
		    							 }else{
		    								 nxtSib.setVisible(false);
			    							 nxtSib.clearValue();
			    							 
			    							 nxtSib.nextSibling().setVisible(false);
			    							 nxtSib.nextSibling().allowBlank=true;
			    							 nxtSib.nextSibling().clearValue();
			    							 nxtSib.nextSibling().validate();
			    							 
			    							 var fieldPanel=form.down('#recommendationContainer');
		    								 for (var j = 0; j < fieldPanel.items.items.length; j++) {
		    									 var eligibilityRecommendation = fieldPanel.items.items[j];
		    									if(!eligibilityRecommendation.items.items[3].isHidden()){
		    										 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
		    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
		    										 return false;
		    									}else{
		    										 form.down('#recommendedFieldLabelItemId').setFieldLabel();
		    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel();
		    									}
		    								 }
		    							 }
		    						 }
		    		  			   }
		    				},{
		    					xtype : 'multiselectcombofield',
		    					name : 'academyLocation',
		    					itemId:'academyLocationId'+[i],
		    					autoloadStore: false,
		    					store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
		    					valueField : 'id',
		    					displayField : 'value',
		    					hidden:true,
		    					queryParam:'qry',
		    					minChars:3,
		    					typeAhead:true,
		    					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    					enableKeyEvents  : 'true',
		    					hideTrigger:false,
		    					forceSelection:true,
		    					cls:'receiptHeaderMultiselect',
		    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    					listeners: {
		    						select:function(obj,rec,value){
		    							var academyLocationId=new Array();
		    							var academyLocationId = obj.getValue();
		    							var alIds = [];
		    							var academyLocationIds = null;
		    							for (var i in rec) {
		    								var alId = null;
		    								alId = rec[i].data.id;
		    								alIds.push(alId);
		    							}
		    							academyLocationIds = alIds.join();
		    							var aLRecord = academyLocationIds;// rec.toString();
		    							obj.nextSibling().reset();
		    							obj.nextSibling().getStore().getProxy().extraParams = {
		    								academyLocationIds: aLRecord
		    							};
		    						}
	    						},
		    					listConfig: {
		    						listeners: {
		    							beforeshow: function(picker) {
		    								picker.minWidth = picker.up('combobox').getSize().width;
		    							},
		    							afterRender: function(combo){
		    								combo.getStore().on("load", function(store, items){
		    									if(items.length==0)
		    										Ext.select('.x-boundlist-item').elements[0].hidden = true;
		    									else
		    										Ext.select('.x-boundlist-item').elements[0].hidden = false;
		    						        });
		    							}
		    						},
		    						loadingText: getCommonTranslation('SEARCHING'),
		    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    						getInnerTpl: function() {
		    							return '<div class="search-item">' +
		    							'{code}' +
		    							'</div>';
		    						}
		    					}
		    				},{
		    					xtype: 'customcombobox',
		    					store: Ext.create('Academia.store.scholarships.AssociateProgramStore'),
		    					itemId: 'recommendedForItemId'+[i],
		    					valueField: 'id',
		    					hidden:true,
		    					displayField: 'value',
		    					name: 'recommendedFor',
		    					queryParam:'programName',
		    					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		    					enableKeyEvents  : 'true',
		    					minChars:3,
		    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    					typeAhead:false,
		    					hideTrigger:false,
		    					forceSelection:true
		    				}]
		    		   });
					 stopContiner.insert(insertPosition,panelItem);
					 stopContiner.doLayout();
				 },
				 findExamBoradType : function(examBoardId, form, personType) {
					 var isMarkGradeVisible = false;
				    	Ext.Ajax.request({
				    		type: 'rest',
				    		url: SERVERURL.PATH_FIND_EXAM_BOARD_BY_ID+"?id="+examBoardId,
				    		method: 'GET',
				    		success: function(res, action) {
				    			var data = Ext.decode(res.responseText);
				    			if(!isEmpty(data.equivalentExamBoardId) && !isEmpty(data.markingType) ){
				    				form.down('#otherSubject').allowBlank = true;
				    				form.down('#otherSubject').setVisible(false);
				    				form.down('#minimumSubject').setValue(data.minimumSubject);
				    				form.down('#maximumSubject').setValue(data.maximumSubject);
				    				if (data.markingType == 'GRADE') {
				    					isMarkGradeVisible = true;
				    					if(form != null && !isEmpty(form)) {
				    						if(data.assessmentLevelRequired && !isNullOrEmpty(personType) && (personType=='APPLICANT' || personType=='STUDENT')) {
				    							form.down('#assessmentLevelItemId').setVisible(true);
				    							form.down('#isAssessmentLevelVisible').setValue(true);
				    							form.down('#assessmentLevelItemId').allowBlank=false;
				    							form.down('#assessmentLevelItemId').setDisabled(true);
				    						} else {
				    							form.down('#assessmentLevelItemId').setVisible(false);
				    							form.down('#isAssessmentLevelVisible').setValue(false);
				    							form.down('#assessmentLevelItemId').allowBlank=true;
				    							form.down('#assessmentLevelItemId').setDisabled(true);
				    						}
				    						form.down('#markGradItemId').setVisible(true);
					    					form.down('#isMarkGradVisible').setValue(true);
					    					form.down('#subMaximumMarks').setVisible(false);
					    					form.down('#subMaximumMarks').reset();
					    					form.down('#subMaximumMarks').allowBlank=true;
				    					}
				    					
				    				}else{
				    					if(form != null && !isEmpty(form)) {
				    						form.down('#subMaximumMarks').reset();
				    						form.down('#assessmentLevelItemId').setVisible(false);
				    						form.down('#isAssessmentLevelVisible').setValue(false);
				    						form.down('#assessmentLevelItemId').allowBlank=true;
				    						form.down('#assessmentLevelItemId').setDisabled(true);
				    						form.down('#markGradItemId').setVisible(true);
				    						form.down('#markGradItemId').setVisible(false);
					    					form.down('#isMarkGradVisible').setValue(false);
					    					if(localStorage.getItem('isVisibleSubMaximumMarks') == true){
					    						form.down('#subMaximumMarks').setVisible(true);
					    					}else{
					    						form.down('#subMaximumMarks').setVisible(false);
					    						form.down('#subMaximumMarks').allowBlank=true;
					    					}
				    					}
				    					isMarkGradeVisible= false;
				    				}
				    			}else{
				    				if(form != null && !isEmpty(form)) {
				    					form.down('#subMaximumMarks').reset();
				    					form.down('#assessmentLevelItemId').setVisible(false);
				    					form.down('#isAssessmentLevelVisible').setValue(false);
				    					form.down('#markGradItemId').setVisible(false);
					    				form.down('#isMarkGradVisible').setValue(false);
					    				if(localStorage.getItem('isVisibleSubMaximumMarks') == true){
				    						form.down('#subMaximumMarks').setVisible(true);
				    					}else{
				    						form.down('#subMaximumMarks').setVisible(false);
				    						form.down('#subMaximumMarks').allowBlank=true;
				    					}
					    				form.down('#minimumSubject').setValue(data.minimumSubject);
					    				form.down('#maximumSubject').setValue(data.maximumSubject);
				    				}
				    				isMarkGradeVisible= false;
				    			}
				    		}
				    	});
				    	return isMarkGradeVisible;
					},
					
					findConfiguredMarksByGradeId : function(id, field) {
						Ext.Ajax.request({
				    		type: 'rest',
				    		url: SERVERURL.PATH_FIND_GRADEMARK_BY_ID+"?gradeId="+id,
				    		method: 'GET',
				    		success: function(res, action) {
				    			var data = Ext.decode(res.responseText);
				    			if(!isEmpty(data)){
								field.setValue(data.equivalentMarks);
				    			}
				    		}
				    	});
				 },
				  saveReferences: function(grid, window) {
			    	var me=this;
			    	var applicantProfile = me.getContentPanelActiveTab();
			        if (applicantProfile) {
			        	try{
			        		applicantProfile.getUserId();
			        	} catch(e){
			        		applicantProfile = me.getContentPanel().items.items[0];
			        	}
			        	
			        }
			    	
			    	var referenceForm = window.down('#employeereferenceform');
			        var submitUrl = '',
			            methodName = '',
			            isUpdate = false;
			        if (referenceForm  && applicantProfile) {  
			        	var employee = applicantProfile.getUserId();
			            var referenceFormData = referenceForm.getValues();
			            referenceFormData.employeeId = employee;
			            referenceFormData.salutation=me.getIdValueJson(referenceFormData.salutation);
			                        if(referenceFormData.waived=="") {
			            	delete(referenceFormData.waived);
			            }
			            var referenceHiddenField = referenceForm.down('#referenceHiddenField');
			            if (isNullOrEmpty(referenceHiddenField.getSubmitValue())) {
			                submitUrl = SERVERURL.EMPLOYEE_REFERENCES_CREATE, // rest/employeeReference/create
			                methodName = 'POST';
			                isUpdate = false;
			            } else {
			                submitUrl = SERVERURL.EMPLOYEE_REFERENCES_UPDATE, // rest/employeeReference/update
			                methodName = 'PUT';
			                isUpdate = true;
			            }
			            var jsonFormatFormData = Ext.encode(referenceFormData);
			            if (!isNullOrEmpty(submitUrl) && !isNullOrEmpty(methodName) && !isNullOrEmpty(jsonFormatFormData)) {
			                Ext.Ajax.request({
			                    type: 'rest',
			                    url: submitUrl,
			                    method: methodName,
			                    jsonData: jsonFormatFormData,
			                    success: function(form, action) {
			                        window.close();
			                        grid.getStore().reload();
			                        grid.getSelectionModel().deselectAll();
			                        if (isUpdate) {
			                            showSuccessMessage(getAdmissionTranslation('REFERENCES'), getAdmissionTranslation('UPDATE_REFERENCE_MSG')); // References
																																					// updated
																																					// successfully
			                        } else {
			                            showSuccessMessage(getAdmissionTranslation('REFERENCES'), getAdmissionTranslation('ADD_REFERENCE_MSG')); // References
																																					// added
																																					// successfully
			                        }
			                    }
			                });

			            }
			        }
			    },
			    downloadCompetitiveGridFile : function(filePath) {
			    	  var csvForm = Ext.create('Ext.form.Panel'); 
					   csvForm.getForm().submit({
						   target: '_blank',
						   method:'POST',
						   params :{
							   access_token : Ext.Ajax.defaultHeaders.access_token,
							   path: filePath
						   },
						   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
						   standardSubmit :true
					   });
				},
				
				/***************************************************************
				 * EMPLOYEE INSURANCE HISTORY
				 */
				
				saveEmployeeInsuranceHistory: function(gridItemId, saveUrl, updateUrl) {
					var this$ = this;
					var form = this$.getEmployeeinsurancehistoryform();
					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);

					var submitUrl, isUpdate = false;
					var id = form.down('#employee_insurance_history_hidden_field');
					if (isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = saveUrl,
						isUpdate = false;
					} else {
						submitUrl =updateUrl,
						isUpdate = true;
					}

					var jsonFormatFormData = this$.getJsonSubmitData(form);
					var jdata = Ext.decode(jsonFormatFormData);
					delete jdata.person;
					delete jdata.customData;        
					jdata.personId=personProfile.personId;
					jsonFormatFormData = Ext.encode(jdata);
					this$.applyWindowMask();

					this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success){
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if (isUpdate) {
								showSuccessMessage(getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_DETAILS'), getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_UPDATE_SUCCESS'));
							} else {
								showSuccessMessage(getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_DETAILS'), getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_ADD_SUCCESS'));
							}
						}else{
							this$.closePersonCommonWindow();
							grid.getStore().reload();
						}
					});
				},
				
				editEmployeeInsuranceHistoryFormWindow: function(informationType, formItemId, gridItemId) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			        	this.showPersonCommonWindow(informationType, formItemId);
			            var form = this$.getEmployeeinsurancehistoryform();
			            if(formItemId=="facultyInsuranceHistoryGrid"){
			            	form = this$.getEmployeeinsurancehistoryform();
			            }
			            var records = grid.getSelectionModel().getSelection()[0];
			            if (!isEmpty(records)) {
			                form.loadRecord(records);
			                var insuranceDate=form.down('#insuranceDate');
			                var insuranceExpiryDate=form.down('#insuranceExpiryDate');
			                insuranceDate.setValue(dateRender(records.data.insuranceDate));
			                insuranceExpiryDate.setValue(dateRender(records.data.insuranceExpiryDate));
			            }
			        } else {
			            showWarningMessage(getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
				
			    viewEmployeeInsuranceHistoryFormWindow: function(informationType, formItemId, gridItemId) {
			    	var this$ = this;
			        this$.editEmployeeInsuranceHistoryFormWindow(informationType, formItemId, gridItemId);
			        this.showPersonCommonWindow(informationType, formItemId);
			        var form = this$.getEmployeeinsurancehistoryform();
			        this$.viewPersonCommonWindow(form);
			    },
			    
			    deleteEmployeeInsuranceHistoryRecord: function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl + id,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getPersonModuleTranslation('EMPLOYEE_INSURANCE_HISTORY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }

			    },
				
				
				/***************************************************************
				 * END EMPLOYEE INSURANCE HISTORY
				 */
				
				checkCompletionDateDfrSetting: function(form){
		    	  	var $this = this;
		    	  	var status = false;
		    	  	var completionDate = form.down("#completionDate");
		    		Ext.Ajax.request({
		    			type: 'rest',
		    			async: false,
		    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
		    			params: {
		    				screenName: 'competitiveexamform',
		    				academyLocationId: this.getCurrentAcademyLocation(),
		    				languageCode:'en'
		    			},
		    			method: 'GET',
		    			success: function(res, action) {
		    				var response = Ext.decode(res.responseText);
		    				if( Object.keys(response).length > 0 ){
		    					var records=response.competitiveexamform;
		    					for(i in records){
		    						if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='completionDate' && records[i].isVisible==true && records[i].isMandatory==true){
		    							completionDate.setVisible(true);
		    							completionDate.allowBlank=false;
		    							form.getForm().checkValidity();
		    							status = true;
		    						}
		    						else if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='completionDate' && records[i].isVisible==true){
		    							completionDate.setVisible(true);
		    							status = true;
		    						}
		    						else if(records[i].formFieldInputType=='datefield' && records[i].formFieldId=='completionDate' && records[i].isVisible==false){
		    							completionDate.setVisible(false);
		    							status = true;
		    						}
		    					}
		    				}
		    			}
		    		});
		    		return status;
		    	},
		    	isValidFileExtensionForPostSchoolStudy: function(extension) {
		 			if (!isNullOrEmpty(extension)) {
		 				extension = extension.toLowerCase();
		 				if ( extension == "png" || extension == "jpeg" || extension == "jpg"
		 					|| extension == "pdf" || extension == "doc" || extension == "docx"
		 	   				|| extension == "xls" || extension == "xlsx") {
		 					return true;
		 				}
		 			}
		 			return false;
		 		},
		    	removeCompetitiveExamDocument:function() {
		    		var $this=this;
            		var form = $this.getPersonCompetitiveExamForm();
            		var filePath = form.down('#filePath');
            		var uploadFileCompetitive = form.down('#uploadFileItemId');
        	    	var downloadUrl = form.down('#competitiveDownloadURL');
        	    	var removeButton = form.down('#removeButtonId');
        	    	filePath.reset();
        	    	uploadFileCompetitive.reset();
        	    	downloadUrl.reset();
        	    	removeButton.setDisabled(true);
        	    	downloadUrl.setVisible(false);
        	    	showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('FILE_REMOVED_CLICK_SAVE_TO_COMPLETE'));
        	    	form.getForm().checkValidity();
		    	},
		    	saveStudentPostDocInfo: function(gridItemId, saveUrl, updateUrl) {

					var this$ = this;
					var submitUrl, isUpdate = false;

					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);
					var form = this$.getPostDocInfoForm();
					form.down('#submitButtonId').setDisabled(true);
					var id = form.down('#student_post_doc_hidden_field');
					if (!isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = updateUrl,
						isUpdate = true;
					} else {
						submitUrl = saveUrl;
						isUpdate = false;
					}
					var jsonFormatFormData = this$.getJsonPostDocInfoData(form,grid,isUpdate);
					this$.applyWindowMask(); 
						this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success,form){
							if(response.responseText!="")
								{
							var data = Ext.decode(response.responseText);
							if(isArray(data)){
								form.down('#submitButtonId').setDisabled(false);
								if(data[0].key == 'Record Already Exists'){
									return false;
								}
							}
								}
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if(form.itemId == 'studentPostDocInfoForm') {
								form.up().close();
							} else {
								this$.closePersonCommonWindow();
							}
							if (isUpdate) {
								showSuccessMessage(getPersonModuleTranslation('STUDENT_POST_DOC_INFO'), getPersonModuleTranslation('STUDENT_POST_DOC_INFO_UPDATE_SUCCESS'));
							} else {
								showSuccessMessage(getPersonModuleTranslation('STUDENT_POST_DOC_INFO'), getPersonModuleTranslation('STUDENT_POST_DOC_INFO_ADD_SUCCESS'));
							}
						}else{
							this$.hideWindowMask();
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
						}
					});
				},
				editStudentPostInfoFormWindow:function(informationType, formItemId, gridItemId) {

				    var this$ = this;
				    var personProfile = this$.getContentPanelActiveTab();
				    var grid = personProfile.down(gridItemId);
				    if (grid.getSelectionModel().getCount() > 0) {
				    	this.showPersonCommonWindow(informationType, formItemId);
			           /*
						 * var form; if(formItemId=="postdocinfoform"){ form =
						 * this$.getPostDocInfoForm(); }
						 */
			            var records = grid.getSelectionModel().getSelection()[0];
			            var form = this$.getPostDocInfoForm();
// form.loadRecord(records);
			            form.down("#student_post_doc_hidden_field").setValue(records.data.id);
			            var doctorateObtainedDate = form.down("#doctorateObtainedDateItemId");
			            if(!isNullOrEmpty(records.data.doctorateObtainedDate))
			            	doctorateObtainedDate.setValue(dateRender(records.data.doctorateObtainedDate));
			            var auditId = form.down("#auditIdItemId");
			            if(!isNullOrEmpty(records.data.auditId))
			                {
				            	if(records.data.auditId.code== "SYSADMIN")
				            		{
				            		records.data.auditId.code='sysadmin';
				            		}
				                  auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
				            	}
			            var qualificationName = form.down("#qualificationNameItemId");
			            if(!isNullOrEmpty(records.data.qualificationName))
			            	qualificationName.setValue(records.data.qualificationName);
			            
			            var contractStartDate = form.down("#contractStartDateItemId");
			            if(!isNullOrEmpty(records.data.contractStartDate))
			            	contractStartDate.setValue(dateRender(records.data.contractStartDate));
			            
			            var qualificationInstitution = form.down("#qualificationInstitutionItemId");
			            if(!isNullOrEmpty(records.data.qualificationInstitution))
			            	qualificationInstitution.setValue(records.data.qualificationInstitution);
			            var contractEndDate = form.down("#contractEndDateItemId");
			            if(!isNullOrEmpty(records.data.contractEndDate))
			            	contractEndDate.setValue(dateRender(records.data.contractEndDate));
			            
			            var dateOfTermination = form.down("#dateOfTermination");
			            if(!isNullOrEmpty(records.data.dateOfTermination))
			            	dateOfTermination.setValue(dateRender(records.data.dateOfTermination));
			                
			            var auditDate = form.down("#auditDateItemId");
			            if(!isNullOrEmpty(records.data.auditDate))
			            	auditDate.setValue(dateRender(records.data.auditDate));
			                auditDate.setReadOnly(true);
			            
			            if (!isNullOrEmpty(records.data.obtainedDoctorateFieldOfStudy)) {		            	
		                    var obtainedDoctorateFieldOfStudy = form.down('#obtainedDoctorateFieldOfStudyItemId')
		                    obtainedDoctorateFieldOfStudy.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.obtainedDoctorateFieldOfStudy.id)
		                    					obtainedDoctorateFieldOfStudy.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.department)) {		            	
		                    var department = form.down('#departmentItemId')
		                    department.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.department.id)
		                    					department.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceOne)) {		            	
		                    var financialResourceOne = form.down('#financialResourceOneItemId');
		                    financialResourceOne.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceOne.id)
		                    					financialResourceOne.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceTwo)) {		            	
		                    var financialResourceTwo = form.down('#financialResourceTwoItemId')
		                    financialResourceTwo.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceTwo.id)
		                    					financialResourceTwo.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceThree)) {		            	
		                    var financialResourceThree = form.down('#financialResourceThreeItemId')
		                    financialResourceThree.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceThree.id)
		                    					financialResourceThree.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceFour)) {		            	
		                    var financialResourceFour = form.down('#financialResourceFourItemId')
		                    financialResourceFour.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceFour.id)
		                    					financialResourceFour.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			           
			            if (!isNullOrEmpty(records.data.financialResourceChildOne)) {		            	
		                    var financialResourceChildOne = form.down('#financialResourceChildOneItemId');
		                    financialResourceChildOne.setDisabled(false);
		                  var store=  financialResourceChildOne.getStore();
		                  store.getProxy().extraParams={
		                	  id:records.data.financialResourceOne.id
		                  }
		                    store.load({
           					 callback:function(record){
           						for(i in record){
                    				if(record[i].data.id == records.data.financialResourceChildOne.id)
                    					financialResourceChildOne.setValue(record[i].data.id);  	
                    			}}
           				 });
		                    
		                    financialResourceChildOne.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceChildOne.id)
		                    					financialResourceChildOne.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceChildTwo)) {		            	
		                    var financialResourceChildTwo = form.down('#financialResourceChildTwoItemId')
		                     financialResourceChildTwo.setDisabled(false);
		                  var store=  financialResourceChildTwo.getStore();
		                  store.getProxy().extraParams={
		                	  id:records.data.financialResourceTwo.id
		                  }
		                    store.load({
           					 callback:function(record){
           						for(i in record){
                    				if(record[i].data.id == records.data.financialResourceChildTwo.id)
                    					financialResourceChildTwo.setValue(record[i].data.id);  	
                    			}}
           				 });
		                    financialResourceChildTwo.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceChildTwo.id)
		                    					financialResourceChildTwo.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceChildThree)) {		            	
		                    var financialResourceChildThree = form.down('#financialResourceChildThreeItemId')
		                    financialResourceChildThree.setDisabled(false);
		                  var store=  financialResourceChildThree.getStore();
		                  store.getProxy().extraParams={
		                	  id:records.data.financialResourceThree.id
		                  }
		                    store.load({
           					 callback:function(record){
           						for(i in record){
                    				if(record[i].data.id == records.data.financialResourceChildThree.id)
                    					financialResourceChildThree.setValue(record[i].data.id);  	
                    			}}
           				 });
		                    financialResourceChildThree.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceChildThree.id)
		                    					financialResourceChildThree.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            if (!isNullOrEmpty(records.data.financialResourceChildFour)) {	
			            	   var financialResourceChildFour = form.down('#financialResourceChildFourItemId')
			                    financialResourceChildFour.setDisabled(false);
			                  var store=  financialResourceChildFour.getStore();
			                  store.getProxy().extraParams={
			                	  id:records.data.financialResourceFour.id
			                  }
			                    store.load({
	           					 callback:function(record){
	           						for(i in record){
	                    				if(record[i].data.id == records.data.financialResourceChildFour.id)
	                    					financialResourceChildFour.setValue(record[i].data.id);  	
	                    			}}
	           				 });
		                    var financialResourceChildFour = form.down('#financialResourceChildFourItemId')
		                    financialResourceChildFour.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.financialResourceChildFour.id)
		                    					financialResourceChildFour.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			          	            	
		                    var financialResourceOneAmount = form.down('#financialResourceOneAmountId')
		                      if (!isNullOrEmpty(records.data.financialResourceOneAmount)) {
		                    	  financialResourceOneAmount.setValue(records.data.financialResourceOneAmount);
		                    	  }
		                    var financialResourceTwoAmount = form.down('#financialResourceTwoAmountId')
		                      if (!isNullOrEmpty(records.data.financialResourceTwoAmount)) {
		                    	  financialResourceTwoAmount.setValue(records.data.financialResourceTwoAmount);
		                    	  }
		                    var financialResourceThreeAmount = form.down('#financialResourceThreeAmountId')
		                      if (!isNullOrEmpty(records.data.financialResourceThreeAmount)) {
		                    	  financialResourceThreeAmount.setValue(records.data.financialResourceThreeAmount);
		                    	  }
		                    var financialResourceFourAmount = form.down('#financialResourceFourAmountId')
		                      if (!isNullOrEmpty(records.data.financialResourceFourAmount)) {
		                    	  financialResourceFourAmount.setValue(records.data.financialResourceFourAmount);
		                    	  }
		                  			      		            		         
			            if (!isNullOrEmpty(records.data.postDocFieldOfStudy)) {		            	
		                    var postDocFieldOfStudy = form.down('#postDocFieldOfStudyItemId')
		                    postDocFieldOfStudy.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.postDocFieldOfStudy.id)
		                    					postDocFieldOfStudy.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                   
		    				}
			            return form;
				        } else {
				            showWarningMessage(getPersonModuleTranslation('STUDENT_POST_DOC_INFO'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				            return null;
				        }
				    },
				    deleteStudentPostInfoRecord: function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getPersonModuleTranslation('STUDENT_POST_DOC_INFO'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,// SERVERURL.STUDENT_POST_DOC_INFO_DELETE,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                    id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('STUDENT_POST_DOC_INFO_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			         
			            } else {
			            showWarningMessage(getPersonModuleTranslation('STUDENT_POST_DOC_INFO'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			            
			            }

			    },
				getJsonPostDocInfoData: function(form,grid,isUpdate) {

					var this$ = this;
					var jsonFormFieldData = new Object();
					var formData = form.getValues();
					if (!isEmpty(formData)) {
						var personObj = this$.getPersonObj();
						var person = new Object();
						person.id = personObj["id"];
						formData.person = person;
						if(isUpdate) {
							var record = grid.getSelectionModel().getSelection();
							formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
						} else {						
							formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
						}

						formData.obtainedDoctorateFieldOfStudy = this$.getIdValueJson(formData.obtainedDoctorateFieldOfStudy);
						formData.postDocFieldOfStudy = this$.getIdValueJson(formData.postDocFieldOfStudy);
						formData.department = this$.getIdValueJson(formData.department);
						formData.financialResourceOne = this$.getIdValueJson(formData.financialResourceOne);
						if(isNullOrEmpty(formData.financialResourceTwo)) {
							delete formData.financialResourceTwo;
						} else {
							formData.financialResourceTwo = this$.getIdValueJson(formData.financialResourceTwo);
						}
						if(isNullOrEmpty(formData.financialResourceThree)) {
							delete formData.financialResourceThree;
						} else {
							formData.financialResourceThree = this$.getIdValueJson(formData.financialResourceThree);
						}
						if(isNullOrEmpty(formData.financialResourceFour)) {
							delete formData.financialResourceFour;
						} else {
							formData.financialResourceFour = this$.getIdValueJson(formData.financialResourceFour);
						}
						if(isNullOrEmpty(formData.financialResourceChildOne)) {
							delete formData.financialResourceChildOne;
						} else {
							formData.financialResourceChildOne = this$.getIdValueJson(formData.financialResourceChildOne);
						}
						if(isNullOrEmpty(formData.financialResourceChildTwo)) {
							delete formData.financialResourceChildTwo;
						} else {
							formData.financialResourceChildTwo = this$.getIdValueJson(formData.financialResourceChildTwo);
						}
						if(isNullOrEmpty(formData.financialResourceChildThree)) {
							delete formData.financialResourceChildThree;
						} else {
							formData.financialResourceChildThree = this$.getIdValueJson(formData.financialResourceChildThree);
						}
						if(isNullOrEmpty(formData.financialResourceChildFour)) {
							delete formData.financialResourceChildFour;
						} else {
							formData.financialResourceChildFour = this$.getIdValueJson(formData.financialResourceChildFour);
						}			
						delete formData.customData;
						var docStore = this$.getStore('personinfo.student.PostDocInfoDocumentStore');
						var docArray = [];
						if (docStore.data.items != null
								&& docStore.data.items.length > 0) {
							Ext.each(docStore.data.items, function(val) {
								var newData = {
										"name" : val.data.documentName,
										"path" : val.data.path,
										"type" : val.data.type,
										"createdBy" : this$.getIdValueJson(
												val.data.createdBy.id,
												val.data.createdBy.value)
								};
								docArray.push(newData);
							});
							formData.studentPostDocInfoDocuments = docArray;
						}
					}
					jsonFormFieldData = Ext.encode(formData);
					return jsonFormFieldData;

				},
				editStudentThesisTitleFormWindow:function(informationType, formItemId, gridItemId) {

				    var this$ = this;
				    var personProfile = this$.getContentPanelActiveTab();
				    var grid = personProfile.down(gridItemId);
				    if (grid.getSelectionModel().getCount() > 0) {
				    	this.showPersonCommonWindow(informationType, formItemId);
			         
			            var records = grid.getSelectionModel().getSelection()[0];
			            var form = this$.getStudentThesisTitleForm();
                       // form.loadRecord(records);
			            form.down("#student_thesis_title_hidden_field").setValue(records.data.id);
			            
			            var classified = form.down("#classifiedId");
                        if(!isNullOrEmpty(records.data.classified))
                            {
                             if(records.data.classified) {
                            	 classified.items.items[0].setValue(true);
                            	 classified.items.items[1].setValue(false);
                              } else {
                            	  classified.items.items[0].setValue(false);
                            	  classified.items.items[1].setValue(true);
                                  }
                            
                            }
	
			            var title = form.down("#titleId");
			            if(!isNullOrEmpty(records.data.title))
			            	title.setValue(records.data.title);
			            
			            var shortSummaryForGraduation = form.down("#shortSummaryForGraduation");
			            if(!isNullOrEmpty(records.data.shortSummaryForGraduation))
			            	shortSummaryForGraduation.setValue(records.data.shortSummaryForGraduation);
			            
			            var programId = form.down("#programId");
			            if(!isNullOrEmpty(records.data.programId)){
			            	programId.setValue((records.data.programId));
			            }
			            
			            var programId = form.down("#programId");
			            if(!isNullOrEmpty(records.data.programId)){
			            	programId.setValue((records.data.programId));
			            }
			            var supervisorSummaryForReading = form.down("#supervisorSummaryForReading");
			            if(!isNullOrEmpty(records.data.supervisorSummaryForReading))
			            	supervisorSummaryForReading.setValue(records.data.supervisorSummaryForReading);
			            
			            var approvalDate = form.down("#approvalDate");
			            if(!isNullOrEmpty(records.data.approvalDate))
			            	approvalDate.setValue(dateRender(records.data.approvalDate));
			            
			            var unitOfAssessment = form.down("#unitOfAssessmentId");
			            if(!isNullOrEmpty(records.data.unitOfAssessmentId))
			            	unitOfAssessment.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.unitOfAssessmentId)
		                    					unitOfAssessment.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            	//unitOfAssessment.setValue(dateRender(records.data.unitOfAssessmentId));
			            
			            var supervisorIdentifier = form.down("#supervisorIdentifierId");
			            if(!isNullOrEmpty(records.data.supervisorIdentifier))
			            	supervisorIdentifier.setValue(records.data.supervisorIdentifier);
			            
			            var supervisorProportion = form.down("#supervisorProportionId");
			            if(!isNullOrEmpty(records.data.supervisorProportion))
			            	supervisorProportion.setValue(records.data.supervisorProportion);
			            
			            var auditDate = form.down("#auditDateItemId");
			            if(!isNullOrEmpty(records.data.auditDate))
			            	auditDate.setValue(dateRender(records.data.auditDate));
			                auditDate.setReadOnly(true);
			            
			            var auditId = form.down("#auditIdItemId");
			            if(!isNullOrEmpty(records.data.auditId))
			            	{
				            	if(records.data.auditId == "SYSADMIN")
				            		{
				            		records.data.auditId ='sysadmin';
				            		}
				           auditId.setValue(records.data.auditId+"/"+records.data.auditName);
			            	}
			            if (!isNullOrEmpty(records.data.approvalBody)) {		            	
		                    var approvalBody = form.down('#approvalBody')
		                    approvalBody.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.approvalBodyId)
		                    					approvalBody.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                    }
			            if (!isNullOrEmpty(records.data.approvalStatusId)) {		            	
		                    var approvalStatus = form.down('#approvalStatus')
		                    approvalStatus.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.approvalStatusId)
		                    					approvalStatus.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
		                    }
//			            var unitOfAssmnt = form.down("#unitOfAssessmentId");
//			            var supervisorIdentifier = form.down("#supervisorIdentifierId");
//			            var supervisorProportion = form.down("#supervisorProportionId");
			            var researchActivityMultiselectIds= [];
			            
			            return form;
				        }
				    else {
				            showWarningMessage(getCommonTranslation('STUDENT_THESIS_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				            return null;
				        }
				    },
				deletestudentThesisTitleFormRecord: function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('STUDENT_THESIS_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl, // SERVERURL.WORK_EXPERIENCE_DELETE,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                    id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('STUDENT_THESIS_TITLE_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getPersonModuleTranslation('STUDENT_THESIS_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }

			    },
	
				saveStudentThesisTitle: function(gridItemId, saveUrl, updateUrl) {

			        var this$ = this;
			        var submitUrl, isUpdate = false;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentThesisTitleForm();
			        form.down('#submitButtonId').setDisabled(true);
			        var id = form.down('#student_thesis_title_hidden_field');
			        if (!isNullOrEmpty(id.getSubmitValue())) {			            
			            submitUrl = updateUrl;
			            isUpdate = true;
			        } else {
			            submitUrl = saveUrl;
			            isUpdate = false;
			        }
			        var jsonFormatFormData = this$.getJsonThesisSubmitData(form,grid,isUpdate);
			        if (!isNullOrEmpty(jsonFormatFormData)) {
			        	var json = Ext.decode(jsonFormatFormData);
			        	/*delete after save api update*/
			        	delete json.customData;
				        /*delete after save api update*/
			        	json.unitOfAssessment = json.unitOfAssessment == "" ? null : json.unitOfAssessment;
			        	if (!isNullOrEmpty(json.auditId)) {
			        		json.auditId=this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			        	}
			        	jsonFormatFormData = Ext.encode(json);
			        }
			        this$.applyWindowMask(); 
			        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			        	this$.hideWindowMask();
			        	
			        	if(success){
			        		this$.closePersonCommonWindow();
			        		if(!isNullOrEmpty(personProfile.getPersonInfo())){
			        			grid.getStore().getProxy().extraParams = {
			        				personId : personProfile.getPersonInfo().id
			        			};
			        		}
			                grid.getStore().reload();
			                grid.getSelectionModel().deselectAll();
			                if (isUpdate) {
			                    showSuccessMessage(getCommonTranslation('STUDENT_THESIS_TITLE'), getCommonTranslation('STUDENT_THESIS_TITLE_UPDATE_SUCCESS'));
			                } else {
			                    showSuccessMessage(getCommonTranslation('STUDENT_THESIS_TITLE'), getCommonTranslation('STUDENT_THESIS_TITLE_ADD_SUCCESS'));
			                }
			    		}else{
			    			this$.hideWindowMask();
							this$.closePersonCommonWindow();
							if(!isNullOrEmpty(personProfile.getPersonInfo())){
			        			grid.getStore().getProxy().extraParams = {
			        				personId : personProfile.getPersonInfo().id
			        			};
			        		}
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
			    		}
			        });
				},
				saveStudentMOU: function(gridItemId, saveUrl, updateUrl) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentMOUForm();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#student_mou_hidden_field');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonStudentMOUData(form,grid,isUpdate);
			            var studentmoudocumentgridStore =  form.down('#studentmoudocumentgridItemId').getStore();
				        if(studentmoudocumentgridStore.data.length>0){
			            this$.applyWindowMask(); 
			            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			                this$.hideWindowMask();
			                if(success){
			                    this$.closePersonCommonWindow();
			                    if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
			                    	try{
			                    		personId = this$.getPersonObj().id;
			                    		if(isNullOrEmpty(personId)){
			                    			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                    		}
			                    	}
			                    	catch(e){
			                    		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                    	}
			                    	grid.getStore().getProxy().extraParams = {
			                    		personId : personId
			                    	};
			                    }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
				        			grid.getStore().getProxy().extraParams = {
				        				personId : personProfile.getPersonInfo().id
				        			};
				        		}
			                    grid.getStore().reload();
			                    grid.getSelectionModel().deselectAll();
			                    if (isUpdate) {
			                        showSuccessMessage(getCommonTranslation('STUDENT_MOU'), getCommonTranslation('STUDENT_MOU_UPDATE_SUCCESS'));
			                    } else {
			                        showSuccessMessage(getCommonTranslation('STUDENT_MOU'), getCommonTranslation('STUDENT_MOU_ADD_SUCCESS'));
			                    }
			                }else{
			                    this$.hideWindowMask();
			                    this$.closePersonCommonWindow();
			                    grid.getStore().reload();
			                    form.down('#submitButtonId').setDisabled(false);
			                }
			            });
				        }else{
				        	   showWarningMessage(getCommonTranslation('STUDENT_MOU'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
				        	   form.down('#submitButtonId').setDisabled(false);
				           }
			        }

			    },
			    getJsonStudentMOUData: function(form,grid,isUpdate) { 

			        var this$ = this;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        var studentMOU = new Academia.model.personinfo.common.pasthistory.StudentMOUModel();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            delete formData.pageSize;
			            if(isUpdate) {
			            	var record = grid.getSelectionModel().getSelection();
			            		formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
			            } else {                        
			            	formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            }
			            var docStore = this$.getStore('student.postGraduateManagement.StudentMOUDocumentStore');
			            var docArray = [];
			            if (docStore.data.items != null
			                    && docStore.data.items.length > 0) {
			                Ext.each(docStore.data.items, function(val) {
			                    var newData = {
			                            "name" : val.data.documentName,
			                            "path" : val.data.path,
			                            "type" : val.data.type,
			                            "createdBy" : this$.getIdValueJson(
			                                    val.data.createdBy.id,
			                                    val.data.createdBy.value)
			                    };
			                    docArray.push(newData);
			                });
			            }
			        }
			        formData.studentMOUDocuments = docArray;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    deleteStudentMOURecord:function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('STUDENT_MOU'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('STUDENT_MOU_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('STUDENT_MOU'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    
			    },
			    /*
			     * start proof of activity
			     */
			    editProofOfActivity: function(informationType, formItemId, gridItemId,isView) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;
			        var personProfile = this$.getContentPanelActiveTab();
			        var form = this$.getProofofactivityform();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			        					    	this.showPersonCommonWindow(informationType, formItemId);
			        				            var records = grid.getSelectionModel().getSelection()[0];
			        				            var form = this$.getProofofactivityform();
			        				            
			        				            form.down('#proof_of_activity_hidden_field').setValue(records.data.id);   
			        				            if (!isNullOrEmpty(records.data.researchActivity)) {		            	
			        				        		var researchActivity = form.down('#researchActivity')
			        				        		researchActivity.getStore().load({ 
			        				        			callback: function(recordss, operation, success) {
			        				        				if (success) {
			        				        					for(i in recordss){
			        				        						if(recordss[i].data.id == records.data.researchActivity.id)
			        				        							researchActivity.setValue(recordss[i].data.id);  	
			        				        					}
			        				        				}
			        				        			}
			        				        		});

			        				        	}
			        				           	var researchActivityName = form.down('#researchActivityName')
			        				        		  if(!isNullOrEmpty(records.data.researchActivityName))
			        				        	 researchActivityName.setValue(records.data.researchActivityName);
			        				         
			        				            var researchActivityDate = form.down("#researchActivityDate");
			        				            if(!isNullOrEmpty(records.data.researchActivityDate))
			        				            	researchActivityDate.setValue(dateRender(records.data.researchActivityDate));
			        				         
			        				            var auditDate = form.down("#auditDate");
			        				            if(!isNullOrEmpty(records.data.auditDate))
			        				            	auditDate.setValue(dateRender(records.data.auditDate));
			        				            auditDate.setReadOnly(true);
			        				           
			        				            
			        				            var auditId = form.down("#auditId");
			        				            if(!isNullOrEmpty(records.data.auditId))
			        				            	{
			        				            	if(records.data.auditId.code == "SYSADMIN")
			        				            		{
			        				            		records.data.auditId.code ='sysadmin';
			        				            		}
			        				            	auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
			        				            	}
			        				            
			        				            return form;
			        					        } else {
			        				            showWarningMessage(getCommonTranslation('PROOF_OF_ACTIVITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        					            return null;
			        					        }
			        					    },


			      saveProofOfActivity: function(gridItemId, saveUrl, updateUrl) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getProofofactivityform();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#proof_of_activity_hidden_field');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonProofOfActivityData(form,grid,isUpdate);
			            var proofofactivitydocumentgridStore =  form.down('#proofofactivitydocumentgrid').getStore();
			            this$.applyWindowMask(); 
			            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			                this$.hideWindowMask();
			                if(success){
			                    this$.closePersonCommonWindow();
			                    if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
			                    	try{
			                    		personId = this$.getPersonObj().id;
			                    		if(isNullOrEmpty(personId)){
			                    			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                    		}
			                    	}
			                    	catch(e){
			                    		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                    	}
			                    	grid.getStore().getProxy().extraParams = {
			                    		personId : personId
			                    	};
			                    }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
				        			grid.getStore().getProxy().extraParams = {
				        				personId : personProfile.getPersonInfo().id
				        			};
				        		}
			                    grid.getStore().reload();
			                    grid.getSelectionModel().deselectAll();
			                    if (isUpdate) {
			                        showSuccessMessage(getCommonTranslation('PROOF_OF_ACTIVITY'), getCommonTranslation('PROOF_OF_ACTIVITY_UPDATE_SUCCESS'));
			                    } else {
			                        showSuccessMessage(getCommonTranslation('PROOF_OF_ACTIVITY'), getCommonTranslation('PROOF_OF_ACTIVITY_ADD_SUCCESS'));
			                    }
			                }else{
			                    this$.hideWindowMask();
			                    this$.closePersonCommonWindow();
			                    grid.getStore().reload();
			                    form.down('#submitButtonId').setDisabled(false);
			                }
			            });
			        }

			    },
			    getJsonProofOfActivityData: function(form,grid,isUpdate) { 

			        var this$ = this;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            delete formData.pageSize;
			            if(isUpdate) {
			            	var record = grid.getSelectionModel().getSelection();
			            		formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
			            } else {                        
			            	formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            }
			            var docStore = this$.getStore('student.postGraduateManagement.ProofOfActivityDocumentGridStore');
			            var docArray = [];
			            if (docStore.data.items != null
			                    && docStore.data.items.length > 0) {
			                Ext.each(docStore.data.items, function(val) {
			                    var newData = {
			                            "name" : val.data.documentName,
			                            "path" : val.data.path,
			                            "type" : val.data.type,
			                            "id" : val.data.id,
			                            "createdBy" : this$.getIdValueJson(
			                                    val.data.createdBy.id,
			                                    val.data.createdBy.value)
			                    };
			                    docArray.push(newData);
			                });
			            }
			        }
			        formData.proofOfActivityDocuments = docArray;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    
			    deleteProofOfActivityRecord:function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('PROOF_OF_ACTIVITY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('PROOF_OF_ACTIVITY_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('PROOF_OF_ACTIVITY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    
			    },
			    /*
			     * end proof of activity
			     */
			    saveFunctionaryProgressReport: function(gridItemId, saveUrl, updateUrl) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getFunctionaryProgressReportForm();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#functionary_progress_report_hidden_field');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonFunctionaryProgressReportData(form,grid,isUpdate);
			            var functionaryprogressreportdocumentgridStore =  form.down('#functionaryprogressreportdocumentgridId').getStore();
				        if(functionaryprogressreportdocumentgridStore.data.length>0){
			            this$.applyWindowMask(); 
			            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			                this$.hideWindowMask();
			                if(success){
			                    this$.closePersonCommonWindow();
			                    if(!isNullOrEmpty(personProfile.getPersonInfo())){
				        			grid.getStore().getProxy().extraParams = {
				        				personId : personProfile.getPersonInfo().id
				        			};
				        		}
			                    grid.getStore().reload();
			                    grid.getSelectionModel().deselectAll();
			                    if (isUpdate) {
			                        showSuccessMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'), getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_UPDATE_SUCCESS'));
			                    } else {
			                        showSuccessMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'), getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_ADD_SUCCESS'));
			                    }
			                }else{
			                    this$.hideWindowMask();
			                    this$.closePersonCommonWindow();
			                    grid.getStore().reload();
			                    form.down('#submitButtonId').setDisabled(false);
			                }
			            });
				        }else{
				        	   showWarningMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
				        	   form.down('#submitButtonId').setDisabled(false);
				           }
			        }

			    },
			    getJsonFunctionaryProgressReportData: function(form,grid,isUpdate) { 
			        var this$ = this;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        var functionaryProgressReport = new Academia.model.student.postgraduatemanagement.FunctionaryProgressReportModel();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            if(isUpdate) {
			            	     var record = grid.getSelectionModel().getSelection();
			            	     formData.auditId = this$.getIdValueJson(record[0].data.auditUserId);
			            	       } else {                        
			            	        formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            	        }
			            var loggedInUser = this$.getCurrentlyLoggedInUser().id;
			            formData.auditId=loggedInUser;
			            if(isNullOrEmpty(formData.reportRating)) {
							delete formData.reportRating;
						} else {
							formData.reportRating = this$.getIdValueJson(formData.reportRating);
						}
			            var docStore = this$.getStore('student.postGraduateManagement.FunctionaryProgressReportDocumentStore');
			            var docArray = [];
			            if (docStore.data.items != null
			                    && docStore.data.items.length > 0) {
			                Ext.each(docStore.data.items, function(val) {
			                    var newData = {
			                            "name" : val.data.documentName,
			                            "path" : val.data.path,
			                            "type" : val.data.type,
			                            "createdBy" : this$.getIdValueJson(
			                                    val.data.createdBy.id,
			                                    val.data.createdBy.value)
			                    };
			                    docArray.push(newData);
			                });
			            }
			        }
			        formData.functionaryProgressReportDocuments = docArray;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    deleteFunctionaryProgressReportRecord:function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    editFunctionaryProgressReport: function(informationType, formItemId,gridItemId,isView) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;
			        var personProfile = this$.getContentPanelActiveTab();
			        var form = this$.getFunctionaryProgressReportForm();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			        					    	this.showPersonCommonWindow(informationType, formItemId);
			        				            var records = grid.getSelectionModel().getSelection()[0];
			        				            var form = this$.getFunctionaryProgressReportForm();
			        				
			        				            form.down('#functionary_progress_report_hidden_field').setValue(records.data.id);     
			        				          
			        				            var progressReportPeriodStartDate = form.down("#progressReportPeriodStartDate");
			        				            if(!isNullOrEmpty(records.data.progressReportPeriodStartDate))
			        				            	progressReportPeriodStartDate.setValue(dateRender(records.data.progressReportPeriodStartDate));
			        				          
			        				            var progressReportPeriodEndDate = form.down("#progressReportPeriodEndDate");
			        				            if(!isNullOrEmpty(records.data.progressReportPeriodEndDate))
			        				            	progressReportPeriodEndDate.setValue(dateRender(records.data.progressReportPeriodEndDate));
			        				         
			        				            if (!isNullOrEmpty(records.data.responsibleFunctionaryEmployeeID)) {		            	
			        			                    var responsibleFunctionaryEmployeeID = form.down('#responsibleFunctionaryEmployeeID')
			        			                    responsibleFunctionaryEmployeeID.getStore().load({ 
			        			                    	callback: function(recordss, operation, success) {
			        			                    		if (success) {
			        			                    			for(i in recordss){
			        			                    				if(recordss[i].data.id == records.data.responsibleFunctionaryEmployeeID.id)
			        			                    					responsibleFunctionaryEmployeeID.setValue(recordss[i].data.id);  	
			        			                    			}
			        			                    		}
			        			                    	}
			        			                    });
			        				            } 
			        							
			        				            var name = form.down("#name");
			        				            if(!isNullOrEmpty(records.data.name))
			        				            name.setValue(records.data.name);
			        				            
			        				            var lastName = form.down("#lastName");
			        				            if(!isNullOrEmpty(records.data.lastName))
			        				            lastName.setValue(records.data.lastName);
			        				            
			        				            if (!isNullOrEmpty(records.data.functionaryType)) {		            	
			        			                    var functionaryType = form.down('#functionaryType')
			        			                    functionaryType.getStore().load({ 
			        			                    	callback: function(recordss, operation, success) {
			        			                    		if (success) {
			        			                    			for(i in recordss){
			        			                    				if(recordss[i].data.id == records.data.functionaryType.id)
			        			                    					functionaryType.setValue(recordss[i].data.id);  	
			        			                    			}
			        			                    		}
			        			                    	}
			        			                    });
			        			                   
			        			    				}
			        				            
			        				            if (!isNullOrEmpty(records.data.reportRating)) {		            	
			        			                    var reportRating = form.down('#reportRating')
			        			                    reportRating.getStore().load({ 
			        			                    	callback: function(recordss, operation, success) {
			        			                    		if (success) {
			        			                    			for(i in recordss){
			        			                    				if(recordss[i].data.id == records.data.reportRating.id)
			        			                    					reportRating.setValue(recordss[i].data.id);  	
			        			                    			}
			        			                    		}
			        			                    	}
			        			                    });
			        			                   
			        			    				}
			        				            
			        				            var auditDate = form.down("#auditDate");
			        				            if(!isNullOrEmpty(records.data.auditDate))
			        				            auditDate.setValue(dateRender(records.data.auditDate));
			        				            auditDate.setReadOnly(true);
			        				           
			        				            var auditId = form.down("#auditId");
			        				            if(!isNullOrEmpty(records.data.auditId))
			        				            	{
			        				            	if(records.data.auditId.code == "SYSADMIN")
			        				            		{
			        				            		records.data.auditId.code ='sysadmin';
			        				            		}
			        				            	auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
			        				            	}
			        				            
			        				            return form;
			        					        } else {
			        				            showWarningMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        					            return null;
			        					        }
			    },
			    
			    saveStudentEthicsClearanceLetter: function(gridItemId, saveUrl, updateUrl) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentEthicsClearanceLetterForm();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#student_ethics_clearance_letter_hidden_field');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonStudentEthicsClearanceLetterData(form,grid,isUpdate);
			            var studentethicsclearanceletterdocumentgridStore =  form.down('#studentethicsclearanceletterdocumentgridId').getStore();
				        if(studentethicsclearanceletterdocumentgridStore.data.length>0){
			            this$.applyWindowMask(); 
			            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			                this$.hideWindowMask();
			                if(success){
			                    this$.closePersonCommonWindow();
			                    if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
			                      	try{
			                     		personId = this$.getPersonObj().id;
			                         	if(isNullOrEmpty(personId)){
			                      		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                       		}
			                       	}
			                       	catch(e){
			                       		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
			                       	}
			                       	grid.getStore().getProxy().extraParams = {
			                    		personId : personId
			                    	};
			                    }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
				        			grid.getStore().getProxy().extraParams = {
				        				personId : personProfile.getPersonInfo().id
				        			};
				        		}
			                    grid.getStore().reload();
			                    grid.getSelectionModel().deselectAll();
			                    if (isUpdate) {
			                        showSuccessMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'), getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_UPDATE_SUCCESS'));
			                    } else {
			                        showSuccessMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'), getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_ADD_SUCCESS'));
			                    }
			                }else{
			                    this$.hideWindowMask();
			                    this$.closePersonCommonWindow();
			                    grid.getStore().reload();
			                    form.down('#submitButtonId').setDisabled(false);
			                }
			            });
			        }else{
			        	   showWarningMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
			        	   form.down('#submitButtonId').setDisabled(false);
			           }
			        }
			    },
			    getJsonStudentEthicsClearanceLetterData: function(form,grid,isUpdate) { 
			        var this$ = this;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        var studentEthicsClearanceLetter = new Academia.model.student.postgraduatemanagement.StudentEthicsClearanceLetterModel();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            if(isUpdate) {
			            	var record = grid.getSelectionModel().getSelection();
			            		formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
			            } else {                        
			            	formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            }
			            if(isNullOrEmpty(formData.coInvestigatorName)) {
							delete formData.coInvestigatorName;
						} else {
							formData.coInvestigatorName = this$.getIdValueJson(formData.coInvestigatorName);
						}
			            var docStore = this$.getStore('student.postGraduateManagement.StudentEthicsClearanceLetterDocumentStore');
			            var docArray = [];
			            if (docStore.data.items != null
			                    && docStore.data.items.length > 0) {
			                Ext.each(docStore.data.items, function(val) {
			                    var newData = {
			                            "name" : val.data.documentName,
			                            "path" : val.data.path,
			                            "type" : val.data.type,
			                            "createdBy" : this$.getIdValueJson(
			                                    val.data.createdBy.id,
			                                    val.data.createdBy.value)
			                    };
			                    docArray.push(newData);
			                });
			            }
			        }
			        formData.studentEthicsClearanceLetterDocuments = docArray;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    deleteStudentEthicsClearanceLetterRecord:function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    editStudentEthicsClearanceLetter: function(informationType, formItemId,gridItemId,isView) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;
			        var personProfile = this$.getContentPanelActiveTab();
			        var form = this$.getStudentEthicsClearanceLetterForm();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			        	this.showPersonCommonWindow(informationType, formItemId);
			        	var records = grid.getSelectionModel().getSelection()[0];
			        	var form = this$.getStudentEthicsClearanceLetterForm();

			        	form.down('#student_ethics_clearance_letter_hidden_field').setValue(records.data.id);     

			        	var approvalDate = form.down("#approvalDate");
			        	if(!isNullOrEmpty(records.data.approvalDate))
			        		approvalDate.setValue(dateRender(records.data.approvalDate));

			        	var approvalPeriodStartDate = form.down("#approvalPeriodStartDate");
			        	if(!isNullOrEmpty(records.data.approvalPeriodStartDate))
			        		approvalPeriodStartDate.setValue(dateRender(records.data.approvalPeriodStartDate));

			        	var approvalPeriodEndDate = form.down("#approvalPeriodEndDate");
			        	if(!isNullOrEmpty(records.data.approvalPeriodEndDate))
			        		approvalPeriodEndDate.setValue(dateRender(records.data.approvalPeriodEndDate));

			        	if (!isNullOrEmpty(records.data.coInvestigatorName)) {		            	
			        		var coInvestigatorName = form.down('#coInvestigatorName')
			        		coInvestigatorName.getStore().load({ 
			        			callback: function(recordss, operation, success) {
			        				if (success) {
			        					for(i in recordss){
			        						if(recordss[i].data.id == records.data.coInvestigatorName.id)
			        							coInvestigatorName.setValue(recordss[i].data.id);  	
			        					}
			        				}
			        			}
			        		});
			        	} 

			        	var projectNumberID = form.down("#projectNumberID");
			        	if(!isNullOrEmpty(records.data.projectNumberID))
			        		projectNumberID.setValue(records.data.projectNumberID);

			        	var auditDate = form.down("#auditDate");
			        	if(!isNullOrEmpty(records.data.auditDate))
			        		auditDate.setValue(dateRender(records.data.auditDate));
			        	auditDate.setReadOnly(true);

			        	var auditId = form.down("#auditId");
			        	if(!isNullOrEmpty(records.data.auditId))
			        	{
			        		if(records.data.auditId.code == "SYSADMIN")
			        		{
			        			records.data.auditId.code ='sysadmin';
			        		}
			        		auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
			        	}

			        	return form;
			        } else {
			        				            showWarningMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        					            return null;
			        					        }
			    },
			   saveStudentExaminersReportInfo: function(gridItemId, saveUrl, updateUrl) {

			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentExaminersReportFormItemId();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#studentExaminersReporthidden');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonStudentExaminersReportData(form,grid,isUpdate);
			           var studentexaminersreportdocumentgridStore =  form.down('#studentexaminersreportdocumentgrid').getStore();
			           if(studentexaminersreportdocumentgridStore.data.length>0){
			        	   this$.applyWindowMask(); 
			        	   this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
				                this$.hideWindowMask();
				                if(success){
				                    this$.closePersonCommonWindow();
				                    if(!isNullOrEmpty(personProfile.getPersonInfo())){
					        			grid.getStore().getProxy().extraParams = {
					        				personId : personProfile.getPersonInfo().id
					        			};
					        		}
				                    grid.getStore().reload();
				                    grid.getSelectionModel().deselectAll();
				                    if (isUpdate) {
				                        showSuccessMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('STUDENT_EXAMINERS_REPORT_UPDATE_SUCCESS'));
				                    } else {
				                        showSuccessMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('STUDENT_EXAMINERS_REPORT_ADD_SUCCESS'));
				                    }
				                }else{
				                    this$.hideWindowMask();
				                    this$.closePersonCommonWindow();
				                    grid.getStore().reload();
				                    form.down('#submitButtonId').setDisabled(false);
				                }
				            }); 
			           }else{
			        	   showWarningMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
			        	   form.down('#submitButtonId').setDisabled(false);
			           }
			            
			        }

			    
			    },
			    getJsonStudentExaminersReportData: function(form,grid,isUpdate) { 
			        var this$ = this;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            if(isUpdate) {
			            	     var record = grid.getSelectionModel().getSelection();
			            	     formData.auditId = this$.getIdValueJson(record[0].data.auditUserId);
			            	       } else {                        
			            	        formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            	        }
			            var loggedInUser = this$.getCurrentlyLoggedInUser().id;
			            formData.auditId=loggedInUser;
			            var docStore = this$.getStore('student.postGraduateManagement.StudentExaminersReportDocumentStore');
			            var docArray = [];
			            if (docStore.data.items != null && docStore.data.items.length > 0) {
			            	Ext.each(docStore.data.items, function(val) {
			            		var newData = {
			            				"name" : val.data.documentName,
			            				"path" : val.data.path,
			            				"type" : val.data.type,
			            				"createdBy" : this$.getIdValueJson(
			            						val.data.createdBy.id,
			            						val.data.createdBy.value)
			            		};
			            		docArray.push(newData);
			            	});
			            }
			        }
			        formData.examinersReportDocuments = docArray;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    
			    editStudentExaminersReportInfo: function(informationType, formItemId,gridItemId,isView) {
			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;
			        
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentExaminersReportFormItemId();
			        if (grid.getSelectionModel().getCount() > 0) {
			        	this.showPersonCommonWindow(informationType, formItemId);
			        	var records = grid.getSelectionModel().getSelection()[0];
			        	var form = this$.getStudentExaminersReportFormItemId();
			        	form.down('#studentExaminersReporthidden').setValue(records.data.id);     
			        	form.loadRecord(records);
			        	 if (!isNullOrEmpty(records.data.functionaryID)) {		            	
			                    var functionaryID = form.down('#functionaryItemId')
			                    functionaryID.getStore().load({ 
			                    	callback: function(recordss, operation, success) {
			                    		if (success) {
			                    			for(i in recordss){
			                    				if(recordss[i].data.id == records.data.functionaryID.id)
			                    					functionaryID.setValue(recordss[i].data.id);  	
			                    			}
			                    		}
			                    	}
			                    });
				            } 
			        	if (!isNullOrEmpty(records.data.functionaryType)) {		            	
			        		var functionaryType = form.down('#functionaryTypeItemId')
			        		functionaryType.getStore().load({ 
			        			callback: function(recordss, operation, success) {
			        				if (success) {
			        					for(i in recordss){
			        						if(recordss[i].data.id == records.data.functionaryType.id)
			        							functionaryType.setValue(recordss[i].data.id);  	
			        					}
			        				}
			        			}
			        		});

			        	}
			        	var auditDate = form.down("#auditDate");
			        	if(!isNullOrEmpty(records.data.auditDate))
			        		auditDate.setValue(dateRender(records.data.auditDate));
			        	auditDate.setReadOnly(true);

			        	var auditId = form.down("#auditId");
			        	if(!isNullOrEmpty(records.data.auditId))
			        	{
			        		if(records.data.auditId.code == "SYSADMIN")
			        		{
			        			records.data.auditId.code ='sysadmin';
			        		}
			        		auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
			        	}
			        	var firstName =  form.down('#nameItemId');
			        	if(!isNullOrEmpty(records.data.firstName)){
			        		firstName.setValue(records.data.firstName);
				        	firstName.setReadOnly(true);
			        	}
	                	var lastName =  form.down('#lastNameItemId');
	                	if(!isNullOrEmpty(records.data.lastName)){
	                		lastName.setValue(records.data.lastName);
	                		lastName.setReadOnly(true);
			        	}
			        	
			        	return form;
			        } else {
			        	showWarningMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        	return null;
			        }
			    
			    },
			    deleteStudentExaminersReportRecord:function(gridItemId, deleteUrl) {
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('STUDENT_EXAMINERS_REPORT_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    saveStudentFunctionaryDetails: function(gridItemId, saveUrl, updateUrl) {

					var this$ = this;
					var submitUrl, isUpdate = false;

					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);
					var form = this$.getFunctionaryDetailsForm();
					form.down('#submitButtonId').setDisabled(true);
					var id = form.down('#functionary_details_hidden_field');
					if (!isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = updateUrl,
						isUpdate = true;
					} else {
						submitUrl = saveUrl;
						isUpdate = false;
					}
					var jsonFormatFormData = this$.getFunctionaryDetailsJsonData(form,grid,isUpdate);
					
					this$.applyWindowMask(); 
						this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success){
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if (isUpdate) {
								if(response.responseText == "-1"){
									showWarningMessage(getCommonTranslation('ALERT'), "Functionary Type and Person "+ getCommonTranslation('ALREADY_MAPPED'));
								}															
								else if(response.responseText == "-2"){
									showWarningMessage(getCommonTranslation('ALERT'), "Functionary Type " + getCommonTranslation('ALREADY_MAPPED') + " with other Person");
								}else if(response.responseText == "-3"){
									showWarningMessage(getCommonTranslation('ALERT'), "Person " + getCommonTranslation('ALREADY_MAPPED') + " with other Functionary Type");
								}else{
								showSuccessMessage(getPersonModuleTranslation('FUNCTIONARY_DETAILS'), getPersonModuleTranslation('FUNCTIONARY_DETAILS_UPDATE_SUCCESS'));
								}
								} else {
									if(response.responseText == "-1"){	
										showWarningMessage(getCommonTranslation('ALERT'), "Functionary Type and Person " + getCommonTranslation('ALREADY_MAPPED'));
									}														
									else if(response.responseText == "-2"){	
										showWarningMessage(getCommonTranslation('ALERT'),"Functionary Type " + getCommonTranslation('ALREADY_MAPPED') + " with other Person");
									}else if(response.responseText == "-3"){
										showWarningMessage(getCommonTranslation('ALERT'),"Person " + getCommonTranslation('ALREADY_MAPPED') + " with other Functionary Type");										
									}else{
								showSuccessMessage(getPersonModuleTranslation('FUNCTIONARY_DETAILS'), getPersonModuleTranslation('FUNCTIONARY_DETAILS_ADD_SUCCESS'));
									}
									}
						}else{
							this$.hideWindowMask();
							form.down('#submitButtonId').setDisabled(false);
						}
					});
				},
				getFunctionaryDetailsJsonData: function(form,grid,isUpdate) {
					var this$ = this;
					var jsonFormFieldData = new Object();
					var formData = form.getValues();
					if (!isEmpty(formData)) {
						var personObj = this$.getPersonObj();
						var userId = this$.getUserInfo();	
						var person = new Object();
						var userId = this$.getUserInfo();
						person.id = personObj["id"];
						formData.person = person;
						if(isUpdate) {
							var record = grid.getSelectionModel().getSelection();
							formData.auditId = this$.getIdValueJson(record[0].data.auditId);
						} else {						
							formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
						}
						formData.functionaryType = this$.getIdValueJson(formData.functionaryType);
						formData.functionaryUserId = this$.getIdValueJson(formData.functionaryUserId);
						formData.oUDepartment = this$.getIdValueJson(formData.oUDepartment);

		        	
						/*var admissionParts = formData.admissionId.split('/');
						var adm1 = admissionParts[2];
						var adm2 = admissionParts[3];
						if(!isNullOrEmpty(adm2)){
							var admissionCodePart = admissionParts[2]+ '/' + admissionParts[3];
						}else{
							var admissionCodePart = admissionParts[2];
						}
						
						*/
						var admCode=form.down('#admission_hidden_field');

						formData.admissionId=admCode.getValue();
						delete formData.admId;
					
					}
					jsonFormFieldData = Ext.encode(formData);
					return jsonFormFieldData;

				},
				editStudentFunctionaryDetailsFormWindow:function(informationType, formItemId, gridItemId) {

				    var this$ = this;
				    var personProfile = this$.getContentPanelActiveTab();
				    var grid = personProfile.down(gridItemId);
				    if (grid.getSelectionModel().getCount() > 0) {
				    	this$.showPersonCommonWindow(informationType, formItemId);
			            var records = grid.getSelectionModel().getSelection()[0];
			            var form = this$.getFunctionaryDetailsForm();
			            form.loadRecord(records);
			            var userId = this$.getUserInfo();
			            var admCode=form.down('#admission_hidden_field');
						var admCode=form.down('#admission_hidden_field');

			            if(!isNullOrEmpty(records.data.functionaryType)) {
			            	var functionaryType = form.down('#functionaryTypeItemId');
			            	
		                	if(records.data.functionaryTypeValue == 'PostDoc Host'){
		                		form.down('#functionaryInvolvementInPercentageItemId').setReadOnly(true);
		                		form.down('#functionaryInvolvementInPercentageItemId').reset();
            					 this.setAllowBlank(form.down('#functionaryInvolvementInPercentageItemId'), true);
		                	}else{
		                		form.down('#functionaryInvolvementInPercentageItemId').setReadOnly(false);
		                		this.setAllowBlank(form.down('#functionaryInvolvementInPercentageItemId'), false);
		                	}
			            	
		                    functionaryType.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.functionaryType)
		                    					functionaryType.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            }
			            if(!isNullOrEmpty(records.data.oUDepartment)) {
			            	var oUDepartment = form.down('#oUDepartmentItemId');
			            	oUDepartment.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.oUDepartment)
		                    					oUDepartment.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            }
			            if(!isNullOrEmpty(records.data.functionaryUserId)) {
			            	var functionaryUserId = form.down('#functionaryUserIdItemId');
			            	store.getProxy().extraParams = {
			        			qry: records.data.functionaryUserIdCode
			        		};
			            	functionaryUserId.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.functionaryUserId)
		                    					functionaryUserId.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            }
			            if(!isNullOrEmpty(records.data.startDate)) {
			            	form.down('#startDateItemId').setValue(dateRender(records.data.startDate));
			            }
			            if(!isNullOrEmpty(records.data.endDate)) {
			            	form.down('#endDateItemId').setValue(dateRender(records.data.endDate));
			            }
			            var auditDate = form.down('#auditDateItemId');
			            if(!isNullOrEmpty(records.data.auditDate)) {
			            	auditDate.setValue(dateRender(records.data.auditDate));
			            }
			            if(!isNullOrEmpty(records.data.auditDate)) {
			            	auditDate.setValue(dateRender(records.data.auditDate));
			            }
			            auditDate.setReadOnly(true);
			            var userId = this.getUserInfo();	
			            var admissionIds = form.down('#admissionIdItemId');
			            admissionIds.getStore().getProxy().extraParams = {
							studentId : userId 
	            		};
			            if(!isNullOrEmpty(grid.store.data.items[0].data.admissionCode)) {
			            	admissionIds.getStore().load({
								callback : function(rec){
									for(var i in rec){
										   if(rec[i].data.admissionID==records.data.admissionId){
												admissionIds.setValue(rec[i].data.admissionID);
												admCode.setValue(rec[i].data.admissionValue);
										   }
									   }
							}
    		    			});
			            }
			           // admissionId.setReadOnly(true);
			            if(!isNullOrEmpty(records.data.auditIdCode)) {
			            	if(!isNullOrEmpty(records.data.auditIdName)) {
			            		form.down('#auditIdItemId').setValue(records.data.auditIdCode+"/"+records.data.auditIdName);
			            	} else {
			            		form.down('#auditIdItemId').setValue(records.data.auditIdCode);
			            	}
			            }
			            return form;
				    } else {
				    	showWarningMessage(getPersonModuleTranslation('FUNCTIONARY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				    	return null;
				    }
				},
				deleteStudentFunctionaryDetails: function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getPersonModuleTranslation('FUNCTIONARY_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                    id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getPersonModuleTranslation('FUNCTIONARY_DETAILS'), getPersonModuleTranslation('FUNCTIONARY_DETAILS_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			         
			            } else {
			            showWarningMessage(getPersonModuleTranslation('FUNCTIONARY_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			            
			            }

			    },
			    saveStudentThesisUploadInfo: function(gridItemId, saveUrl, updateUrl) {
			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentThesisUploadForm();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#studentThesisUploadhidden');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonStudentThesisUploadData(form,grid,isUpdate);
			           var studentThesisUploadDocumentGridStore =  form.down('#studentThesisUploadDocumentGridItemId').getStore();
			           if(studentThesisUploadDocumentGridStore.data.length>0){
			        	   this$.applyWindowMask(); 
			        	   this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
				                this$.hideWindowMask();
				                if(success && response.responseText != "0"){
				                    this$.closePersonCommonWindow();
				                    if(!isNullOrEmpty(personProfile.getPersonInfo())){
					        			grid.getStore().getProxy().extraParams = {
					        				personId : personProfile.getPersonInfo().id
					        			};
					        		}
				                    grid.getStore().reload();
				                    grid.getSelectionModel().deselectAll();
				                    if (isUpdate) {
				                        showSuccessMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('STUDENT_THESIS_UPLOAD_UPDATE_SUCCESS'));
				                    } else {
				                        showSuccessMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('STUDENT_THESIS_UPLOAD_ADD_SUCCESS'));
				                    }
				                }else{
				                    this$.hideWindowMask();
				                    this$.closePersonCommonWindow();
				                    grid.getStore().reload();
				                    form.down('#submitButtonId').setDisabled(false);
				                    showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getExaminationTranslation('SIZE_LIMIT_EXCEEDED'))
				                }
				            }); 
			           }else{
			        	   showWarningMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
			        	   form.down('#submitButtonId').setDisabled(false);
			           }
			            
			        }

			    
			    },
			    getJsonStudentThesisUploadData: function(form,grid,isUpdate) { 
			        var this$ = this;
			        var totalDocumentsize = 0;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            if(isUpdate) {
			            	var record = grid.getSelectionModel().getSelection();
			            	formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
			            } else {                        
			            	formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            }
			            var docStore = this$.getStore('student.postGraduateManagement.StudentThesisUploadDocumentStore');
			            var docArray = [];
			            if (docStore.data.items != null && docStore.data.items.length > 0) {
			            	Ext.each(docStore.data.items, function(val) {
			            		var newData = {
			            				"name" : val.data.documentName,
			            				"path" : val.data.path,
			            				"type" : val.data.type,
			            				"documentSize":val.data.documentSize,
			            				"createdBy" : this$.getIdValueJson(
			            						val.data.createdBy.id,
			            						val.data.createdBy.value)
			            		};
			            		docArray.push(newData);
			            		totalDocumentsize = totalDocumentsize + newData.documentSize;
			            	});
			            }
			        }
			        formData.studentThesisUploadDocuments = docArray;
			        formData.documentSize = totalDocumentsize;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    
			    editStudentThesisUploadInfo: function(informationType, formItemId,gridItemId,isView) {
			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;
			        
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getStudentExaminersReportFormItemId();
			        if (grid.getSelectionModel().getCount() > 0) {
			        	this.showPersonCommonWindow(informationType, formItemId);
			        	var records = grid.getSelectionModel().getSelection()[0];
			        	var form = this$.getStudentThesisUploadForm();
			        	form.down('#studentThesisUploadhidden').setValue(records.data.id);     
			        	form.loadRecord(records);
			        	var auditDate = form.down("#auditDate");
			        	if(!isNullOrEmpty(records.data.auditDate))
			        	auditDate.setValue(dateRender(records.data.auditDate));
			        	auditDate.setReadOnly(true);
			        	var auditId = form.down("#auditId");
			        	if(!isNullOrEmpty(records.data.auditId))
			        	{
			        		if(records.data.auditId.code == "SYSADMIN")
			        		{
			        			records.data.auditId.code ='sysadmin';
			        		}
			        		auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
			        	}
			        	return form;
			        } else {
			        	showWarningMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        	return null;
			        }
			    
			    },
			    deleteStudentThesisUploadRecord:function(gridItemId, deleteUrl) {
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('STUDENT_THESIS_UPLOAD_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    saveNominateExaminers: function(gridItemId, saveUrl, updateUrl) {

					var this$ = this;
					var submitUrl, isUpdate = false;

					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down(gridItemId);
					var form = this$.getNominateExaminersForm();
					form.down('#submitButtonId').setDisabled(true);
					var id = form.down('#nominate_examiners_hidden_field');
					if (!isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = updateUrl,
						isUpdate = true;
					} else {
						submitUrl = saveUrl;
						isUpdate = false;
					}
					var jsonFormatFormData = this$.getNominateExaminersJsonData(form,grid,isUpdate);
					this$.applyWindowMask(); 
						this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
						this$.hideWindowMask();
						if(success){
							this$.closePersonCommonWindow();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
							if (isUpdate) {
								showSuccessMessage(getPersonModuleTranslation('NOMINATE_EXAMINERS'), getCommonTranslation('NOMINATE_EXAMINERS_UPDATE_SUCCESS'));
							} else {
								showSuccessMessage(getPersonModuleTranslation('NOMINATE_EXAMINERS'), getCommonTranslation('NOMINATE_EXAMINERS_ADD_SUCCESS'));
							}
						}else{
							this$.hideWindowMask();
							form.down('#submitButtonId').setDisabled(false);
						}
					});
				},
				getNominateExaminersJsonData: function(form,grid,isUpdate) {
					var this$ = this;
					var jsonFormFieldData = new Object();
					var formData = form.getValues();
					if (!isEmpty(formData)) {
						var personObj = this$.getPersonObj();
						var person = new Object();
						person.id = personObj["id"];
						formData.person = person;
						if(isUpdate) {
							var record = grid.getSelectionModel().getSelection();
							formData.auditId = this$.getIdValueJson(record[0].data.auditId);
						} else {						
							formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
						}
						formData.examinerType = this$.getIdValueJson(formData.examinerType);
						formData.examType = this$.getIdValueJson(formData.examType);
						formData.examinerName = this$.getIdValueJson(formData.examinerName);
					}
					delete formData.customData;
					jsonFormFieldData = Ext.encode(formData);
					return jsonFormFieldData;

				},
				editNominateExaminers:function(informationType, formItemId, gridItemId) {

				    var this$ = this;
				    var personProfile = this$.getContentPanelActiveTab();
				    var grid = personProfile.down(gridItemId);
				    if (grid.getSelectionModel().getCount() > 0) {
				    	this$.showPersonCommonWindow(informationType, formItemId);
			            var records = grid.getSelectionModel().getSelection()[0];
			            var form = this$.getNominateExaminersForm();
			            form.loadRecord(records);
			            
			            if(!isNullOrEmpty(records.data.examinerType)) {
			            	var examinerType = form.down('#examinerType');
		                    examinerType.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.examinerType)
		                    					examinerType.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            }
 					if(!isNullOrEmpty(records.data.examType)) {
			            	var examType = form.down('#examType');
		                    examType.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.examType)
		                    					examType.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            }
			            if(!isNullOrEmpty(records.data.examinerName)) {
			            	var examinerName = form.down('#examinerName');
			            	store.getProxy().extraParams = {
			        			qry: records.data.examinerNameCode
			        		};
			            	examinerName.getStore().load({ 
		                    	callback: function(recordss, operation, success) {
		                    		if (success) {
		                    			for(i in recordss){
		                    				if(recordss[i].data.id == records.data.examinerName)
		                    					examinerName.setValue(recordss[i].data.id);  	
		                    			}
		                    		}
		                    	}
		                    });
			            }
			            var emailId =  form.down('#emailId');
			        	if(!isNullOrEmpty(records.data.emailId)){
			        		emailId.setValue(records.data.emailId);
			        	}
	                	var mobileCountryCode =  form.down('#mobileCountryCode');
	                	if(!isNullOrEmpty(records.data.mobileCountryCode)){
	                		mobileCountryCode.setRawValue(records.data.mobileCountryCode);
			        	}
	                	var mobileNumber =  form.down('#mobileNumber');
	                	if(!isNullOrEmpty(records.data.mobileNumber)){
	                		mobileNumber.setValue(records.data.mobileNumber);
			        	}
			            var auditDate = form.down('#auditDate');
			            if(!isNullOrEmpty(records.data.auditDate)) {
			            	auditDate.setValue(dateRender(records.data.auditDate));
			            }
			            auditDate.setReadOnly(true);
			            if(!isNullOrEmpty(records.data.auditIdCode)) {
			            	if(!isNullOrEmpty(records.data.auditIdName)) {
			            		form.down('#auditId').setValue(records.data.auditIdCode+"/"+records.data.auditIdName);
			            	} else {
			            		form.down('#auditId').setValue(records.data.auditIdCode);
			            	}
			            }
			            return form;
				    } else {
				    	showWarningMessage(getPersonModuleTranslation('NOMINATE_EXAMINERS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				    	return null;
				    }
				},
				deleteNominateExaminers: function(gridItemId, deleteUrl) {

			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);

			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getPersonModuleTranslation('NOMINATE_EXAMINERS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                    id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getPersonModuleTranslation('NOMINATE_EXAMINERS'), getCommonTranslation('NOMINATE_EXAMINERS_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			         
			            } else {
			            showWarningMessage(getPersonModuleTranslation('NOMINATE_EXAMINERS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			            
			            }

			    },
			    saveIndependentNonExaminingChairPersonInfo: function(gridItemId, saveUrl, updateUrl) {
			        var this$ = this;
			        var isValid = true;
			        var submitUrl, isUpdate = false;

			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        var form = this$.getIndependentNonExaminingChairPersonForm();
			        form.down('#submitButtonId').setDisabled(true);

			        if(isValid){
			            var id = form.down('#independentNonExaminingChairPersonHiddenId');
			            if (!isNullOrEmpty(id.getSubmitValue())) {
			            	submitUrl = updateUrl,
			                isUpdate = true;
			            } else {
			            	submitUrl = saveUrl,
			                isUpdate = false;       
			            }
			            var jsonFormatFormData = this$.getJsonIndependentNonExaminingChairPersonData(form,grid,isUpdate);
			           var independentNonExaminingChairPersonDocGridStore =  form.down('#independentNonExaminingChairPersonDocGridItemId').getStore();
			           if(independentNonExaminingChairPersonDocGridStore.data.length>0){
			        	   this$.applyWindowMask(); 
			        	   this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
				                this$.hideWindowMask();
				                if(success){
				                    this$.closePersonCommonWindow();
				                    if(!isNullOrEmpty(personProfile.getPersonInfo())){
					        			grid.getStore().getProxy().extraParams = {
					        				personId : personProfile.getPersonInfo().id
					        			};
					        		}
				                    grid.getStore().reload();
				                    grid.getSelectionModel().deselectAll();
				                    if (isUpdate) {
				                        showSuccessMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_UPDATE_SUCCESS'));
				                    } else {
				                        showSuccessMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_ADD_SUCCESS'));
				                    }
				                }else{
				                    this$.hideWindowMask();
				                    this$.closePersonCommonWindow();
				                    grid.getStore().reload();
				                    form.down('#submitButtonId').setDisabled(false);
				                }
				            }); 
			           }else{
			        	   showWarningMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('PLEASE_UPLOAD_DOCUMENT'));
			        	   form.down('#submitButtonId').setDisabled(false);
			           }
			        }
			    },
			    getJsonIndependentNonExaminingChairPersonData: function(form,grid,isUpdate) { 
			        var this$ = this;
			        var jsonFormFieldData = new Object();
			        var personObj = this$.getPersonObj();
			        var formData = form.getValues();
			        if (!isEmpty(formData)) {
			            var person = new Object();
			            person.id = personObj["id"];
			            formData.person = person;
			            if(isUpdate) {
			            	var record = grid.getSelectionModel().getSelection();
			            	formData.auditId = this$.getIdValueJson(record[0].data.auditId.id);
			            } else {                        
			            	formData.auditId = this$.getIdValueJson(this$.getCurrentlyLoggedInUser().id);
			            }
			            var docStore = this$.getStore('student.postGraduateManagement.IndependentNonExaminingChairPersonDocStore');
			            var docArray = [];
			            if (docStore.data.items != null && docStore.data.items.length > 0) {
			            	Ext.each(docStore.data.items, function(val) {
			            		var newData = {
			            				"name" : val.data.documentName,
			            				"path" : val.data.path,
			            				"type" : val.data.type,
			            				"createdBy" : this$.getIdValueJson(
			            						val.data.createdBy.id,
			            						val.data.createdBy.value)
			            		};
			            		docArray.push(newData);
			            	});
			            }
			        }
			        formData.independentNonExaminingChairPersonDocs = docArray;
			        jsonFormFieldData = Ext.encode(formData);
			        return jsonFormFieldData;
			    },
			    deleteIndependentNonExaminingChairPersonInfo:function(gridItemId, deleteUrl) {
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down(gridItemId);
			        if (grid.getSelectionModel().getCount() > 0) {
			            showConfirmMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn == 'yes') {
			                    if (grid.getSelectionModel().getCount() > 0) {
			                        var records = grid.getSelectionModel().getSelection();
			                        for (var count = 0; count < records.length; count++) {
			                            var id = "";
			                            if (!isNullOrEmpty(records[count].get("id"))) {
			                                id = records[count].get("id");
			                            }
			                            Ext.Ajax.request({
			                                type: 'rest',
			                                url: deleteUrl,
			                                method: 'DELETE',
			                                headers: {
			                                    'Content-Type': 'application/json'
			                                },
			                                params: {
			                                	id: id
			                                },
			                                success: function(form, action) {
			                                    grid.getStore().reload();
			                                    showSuccessMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_DELETE_SUCCESS'));
			                                }
			                            });
			                        }
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    },
			    editIndependentNonExaminingChairpersonReport:function(informationType, formItemId, gridItemId) {
			    		var this$ = this;
			    		var isValid = true;
			    		var submitUrl, isUpdate = false;
			    		var personProfile = this$.getContentPanelActiveTab();
			    		var grid = personProfile.down(gridItemId);
			    		if (grid.getSelectionModel().getCount() > 0) {

			    			this$.showPersonCommonWindow(informationType, formItemId);
			    			var records = grid.getSelectionModel().getSelection()[0];
			    			var form = this$.getIndependentNonExaminingChairPersonForm();                          
			    			form.down('#independentNonExaminingChairPersonHiddenId').setValue(records.data.id);
			    			var auditId = form.down("#auditId");
			    			if(!isNullOrEmpty(records.data.auditId))
			    			{
			    				if(records.data.auditId.code == "SYSADMIN")
			    				{
			    					records.data.auditId.code ='sysadmin';
			    				}
			    				auditId.setValue(records.data.auditId.code+"/"+records.data.auditId.value);
			    			}

			    			var auditDate = form.down("#auditDate");
			    			if(!isNullOrEmpty(records.data.auditDate))
			    				auditDate.setValue(dateRender(records.data.auditDate));
			    			auditDate.setReadOnly(true);

			    			return form;
			    		} else {
			    			showWarningMessage(getPersonModuleTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			    			return null;
			    		}
                    
				},
				saveStudentLanguageDetail: function(gridItemId, saveUrl, updateUrl) {

				      var this$ = this;
				      var isValid = true;
				      var submitUrl, isUpdate = false;

				      var personProfile = this$.getContentPanelActiveTab();
				      var grid = personProfile.down(gridItemId);
				      var form = this$.getStudentlanguagedetailform();
				      form.down('#submitButtonId').setDisabled(true);

				          var id = form.down('#language_detail_hidden_field');
				          if (!isNullOrEmpty(id.getSubmitValue())) {
				          	submitUrl = updateUrl,
				              isUpdate = true;
				          } else {
				          	submitUrl = saveUrl,
				              isUpdate = false;       
				          }
				          var jsonFormatFormData = this$.getJsonStudentLanguageData(form,grid,isUpdate);
				          this$.applyWindowMask(); 
				          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
				              this$.hideWindowMask();
				              if(success){
				                  this$.closePersonCommonWindow();
				                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
				                  	try{
				                  		personId = this$.getPersonObj().id;
				                  		if(isNullOrEmpty(personId)){
				                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
				                  		}
				                  	}
				                  	catch(e){
				                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
				                  	}
				                  	grid.getStore().getProxy().extraParams = {
				                  		personId : personId
				                  	};
				                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
					        			grid.getStore().getProxy().extraParams = {
					        				personId : personProfile.getPersonInfo().id
					        			};
					        		}
				                  grid.getStore().reload();
				                  grid.getSelectionModel().deselectAll();
				                  if (isUpdate) {
				                      showSuccessMessage(getCommonTranslation('STUDENT_LANGUAGE'), getCommonTranslation('STUDENT_LANGUAGE_UPDATE_SUCCESSFULLY'));
				                  } else {
				                      showSuccessMessage(getCommonTranslation('STUDENT_LANGUAGE'), getCommonTranslation('STUDENT_LANGUAGE_ADD_SUCCESSFULLY'));
				                  }
				              }else{
				                  this$.hideWindowMask();
				                  this$.closePersonCommonWindow();
				                  grid.getStore().reload();
				                  form.down('#submitButtonId').setDisabled(false);
				              }
				          });
					      

				  },
				  getJsonStudentLanguageData: function(form,grid,isUpdate) { 
					  var this$ = this;
				      var jsonFormFieldData = new Object();
				      var personObj = this$.getPersonObj();
				      
				      var formData = form.getValues();
				      var user=this.getCurrentlyLoggedInUser()
				      if (!isEmpty(formData)) {
				          var person = new Object();
				          person.id = personObj["id"];
				          formData.person = person;
				    	  formData.isPrimaryLanguage = formData.isPrimaryLanguage;
				    	  if(!formData.hasOwnProperty('language') || formData.visaStatus == "" || formData.language.id == "") {
				              formData.language = null;
				          }
				    	  
				          delete formData.pageSize;
				          delete formData.customData;
				          var docArray = [];
				          var docStore = this$.getStore('personinfo.common.pasthistory.StudentLanguageDocumentStore');
				          if (docStore.data.items != null
				                  && docStore.data.items.length > 0) {
				              Ext.each(docStore.data.items, function(val) {
				                  var newData = {
				                          "name" : val.data.documentName,
				                          "path" : val.data.path,
				                          "type" : val.data.type,
				                          "id"   :val.data.id,
				                          "createdBy" : this$.getIdValueJson(
				                                  val.data.createdBy.id,
				                                  val.data.createdBy.value)
				                  };
				                  docArray.push(newData);
				              });
				          }
				          var urlArray = [];
				          var urlStore = this$.getStore('personinfo.common.pasthistory.StudentLanguageUrlGridStore');
				          if (urlStore.data.items != null
				                  && urlStore.data.items.length > 0) {
				              Ext.each(urlStore.data.items, function(val) {
				                  var newData = {
				                          "name" : val.data.documentName,
				                          "path" : val.data.path,
				                          "type" : val.data.type,
				                          "id"   :val.data.id,
				                          "createdBy" : this$.getIdValueJson(
				                                  val.data.createdBy.id,
				                                  val.data.createdBy.value)
				                  };
				                  urlArray.push(newData);
				              });
				          }
				      }
				      formData.languageDocument = docArray;
				      formData.languageDocumentUrl = urlArray;
				      jsonFormFieldData = Ext.encode(formData);
				      return jsonFormFieldData;
				  },
				  editStudentLanguageWindow: function(informationType, formItemId, gridItemId, isViewMode) {
				      var this$ = this;
				      var personProfile = this$.getContentPanelActiveTab();
				      var grid = personProfile.down(gridItemId);

				      if (grid.getSelectionModel().getCount() > 0) {
				    	  this$.showPersonCommonWindow(informationType, formItemId);
				    	  
				    		  var form = this$.getStudentlanguagedetailform();
					    	  var formWindow = this$.getPersonCommonWindow();
					    	  if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
					    		  formWindow.setTitle(getCommonTranslation('VIEW_STUDENT_LANGUAGE'));
					    	  }else{
					    		  formWindow.setTitle(getCommonTranslation('EDIT_STUDENT_LANGUAGE'));
					    	  }
					    	  var records = grid.getSelectionModel().getSelection()[0];
					    	  if (!isEmpty(records)) {
					    		  form.down('#language_detail_hidden_field').setValue(records.data.id);

					    		  var languageType = form.down('#language');
					    		  if (!isNullOrEmpty(records.data.language)) {		            	
					    			  languageType.getStore().load({ 
					    				  callback: function(recordss, operation, success) {
					    					  if (success) {
					    						  for(i in recordss){
					    							  if(recordss[i].data.id == records.data.language.id)
					    								  languageType.setValue(recordss[i].data.id);  	
					    						  }
					    					  }
					    				  }
					    			  });
					    		  }

					    		  var languageExamType = form.down('#languageExamType')
					    		  if (!isNullOrEmpty(records.data.languageExamType)) {		            	
					    			  languageExamType.getStore().load({ 
					    				  callback: function(recordss, operation, success) {
					    					  if (success) {
					    						  for(i in recordss){
					    							  if(recordss[i].data.id == records.data.languageExamType.id)
					    								  languageExamType.setValue(recordss[i].data.id);  	
					    						  }
					    					  }
					    				  }
					    			  });
					    		  }

					    		  var languageExamDate = form.down("#languageExamDate");
                                  if(!isNullOrEmpty(records.data.studentLanguageExamDate))
                                      records.data.languageExamDate = records.data.studentLanguageExamDate;
                                     languageExamDate.setValue(records.data.studentLanguageExamDate);
  
					    		  setTimeout(function(){
					    		  var otherLanguageExamType = form.down("#otherLanguageExamType");
					    		  if(!isNullOrEmpty(records.data.otherLanguageExamType))
					    			  otherLanguageExamType.setValue(records.data.otherLanguageExamType);
					    		  }, 500);
					    		  var yearOfEducation = form.down("#yearOfEducation");
					    		  if(!isNullOrEmpty(records.data.yearOfEducation))
					    			  yearOfEducation.setValue(records.data.yearOfEducation);
					    		  
					    		  var overAllScore = form.down("#overAllScore");
					    		  if(!isNullOrEmpty(records.data.overAllScore))
					    			  overAllScore.setValue(records.data.overAllScore);
					    		  var isPrimaryLanguage = form.down("#isPrimaryLanguage");
					    		  if(!isNullOrEmpty(records.data.isPrimaryLanguage))
					    			  records.data.isPrimaryLanguage = records.data.isPrimaryLanguage
					    			  isPrimaryLanguage.setValue(records.data.isPrimaryLanguage);
					    	  }
				  	    	
				      } else {
				          showWarningMessage(getCommonTranslation('STUDENT_LANGUAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				      }
				  },
				  viewStudentLanguageDetailFormWindow: function(informationType, formItemId, gridItemId) {
					  var this$ = this;
					  var personProfile = this$.getContentPanelActiveTab();
				      var grid = personProfile.down(gridItemId);
				      if (grid.getSelectionModel().getCount() > 0) {
					      this$.editStudentLanguageWindow(informationType, formItemId, gridItemId, true);
					      var form = this$.getStudentlanguagedetailform();
					      form.down('#language').setReadOnly(true);
					      form.down('#yearOfEducation').setReadOnly(true);
					      form.down('#languageExamType').setReadOnly(true);
					      form.down('#languageExamDate').setReadOnly(true);
					      form.down('#languageUploadFileItemId').setVisible(false);
					      form.down('#languageURLItemId').setVisible(false);
					      var studentlanguagedocumentlistgrid = form.down('#studentlanguagedocumentgrid');
					      var studentlanguagedocurllistgrid = form.down('#studentlanguageurlgrid');
					      studentlanguagedocumentlistgrid.down('#btnDelete').setDisabled(true);
					      studentlanguagedocurllistgrid.down('#btnDelete').setDisabled(true);
					      this$.viewPersonCommonWindow(form);
				      } else {
				    	  showWarningMessage(getCommonTranslation('STUDENT_LANGUAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				      }
				  },
				  deleteStudentLanguageDetailRecord:function(gridItemId, deleteUrl) {
				      var this$ = this;
				      var personProfile = this$.getContentPanelActiveTab();
				      var grid = personProfile.down(gridItemId);
				      if (grid.getSelectionModel().getCount() > 0) {
				          showConfirmMessage(getCommonTranslation('DELETE_STUDENT_LANGUAGE'), getCommonTranslation('STUDENT_LANGUAGE_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				              if (btn == 'yes') {
				                  if (grid.getSelectionModel().getCount() > 0) {
				                      var records = grid.getSelectionModel().getSelection();
				                      var flag=false;
				                      for (var count = 0; count < records.length; count++) {
				                          var id = "";
				                          if (!isNullOrEmpty(records[count].get("id"))) {
				                              id = records[count].get("id");
				                          }
				                          Ext.Ajax.request({
				                              type: 'rest',
				                              url: deleteUrl,
				                              async:false,
				                              method: 'DELETE',
				                              headers: {
				                                  'Content-Type': 'student/json'
				                              },
				                              params: {
				                              	id: id
				                              },
				                              success: function(form, action) {
				                            	  flag=true;
				                              }
				                          });
				                      }
				                      if(flag) {
				                          grid.getStore().reload();
				                          showSuccessMessage(getCommonTranslation('DELETE_STUDENT_LANGUAGE'), getCommonTranslation('STUDENT_LANGUAGE_DELETE_SUCCESS'));
				                      }
				                  }
				              }
				          });
				      } else {
				          showWarningMessage(getCommonTranslation('DELETE_STUDENT_LANGUAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				      }
				  },
		    
					saveApplicantLanguageDetail: function(gridItemId, saveUrl, updateUrl) {

					      var this$ = this;
					      var isValid = true;
					      var submitUrl, isUpdate = false;

					      var personProfile = this$.getContentPanelActiveTab();
					      var grid = personProfile.down(gridItemId);
					      var form = this$.getStudentlanguagedetailform();
					      form.down('#submitButtonId').setDisabled(true);

					          var id = form.down('#language_detail_hidden_field');
					          if (!isNullOrEmpty(id.getSubmitValue())) {
					          	submitUrl = updateUrl,
					              isUpdate = true;
					          } else {
					          	submitUrl = saveUrl,
					              isUpdate = false;       
					          }
					          var jsonFormatFormData = this$.getJsonApplicantLanguageData(form,grid,isUpdate);
					          this$.applyWindowMask(); 
					          this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
					              this$.hideWindowMask();
					              if(success){
					                  this$.closePersonCommonWindow();
					                  if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
					                  	try{
					                  		personId = this$.getPersonObj().id;
					                  		if(isNullOrEmpty(personId)){
					                  			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
					                  		}
					                  	}
					                  	catch(e){
					                  		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
					                  	}
					                  	grid.getStore().getProxy().extraParams = {
					                  		personId : personId
					                  	};
					                  }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
						        			grid.getStore().getProxy().extraParams = {
						        				personId : personProfile.getPersonInfo().id
						        			};
						        		}
					                  grid.getStore().reload();
					                  grid.getSelectionModel().deselectAll();
					                  if (isUpdate) {
					                      showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE'), getCommonTranslation('APPLICANT_LANGUAGE_UPDATE_SUCCESSFULLY'));
					                  } else {
					                      showSuccessMessage(getCommonTranslation('APPLICANT_LANGUAGE'), getCommonTranslation('APPLICANT_LANGUAGE_ADD_SUCCESSFULLY'));
					                  }
					              }else{
					                  this$.hideWindowMask();
					                  this$.closePersonCommonWindow();
					                  grid.getStore().reload();
					                  form.down('#submitButtonId').setDisabled(false);
					              }
					          });
						      

					  },
					  getJsonApplicantLanguageData: function(form,grid,isUpdate) { 
						  var this$ = this;
					      var jsonFormFieldData = new Object();
					      var personObj = this$.getPersonObj();
					      
					      var formData = form.getValues();
					      var user=this.getCurrentlyLoggedInUser()
					      if (!isEmpty(formData)) {
					          var person = new Object();
					          person.id = personObj["id"];
					          formData.person = person;
					    	  formData.isPrimaryLanguage = formData.isPrimaryLanguage;
					    	  if(!formData.hasOwnProperty('language') || formData.visaStatus == "" || formData.language.id == "") {
					              formData.language = null;
					          }
					    	  
					          delete formData.pageSize;
					          delete formData.customData;
					          var docArray = [];
					          var docStore = this$.getStore('personinfo.common.pasthistory.ApplicantLanguageDocumentDetailStore');
					          if (docStore.data.items != null
					                  && docStore.data.items.length > 0) {
					              Ext.each(docStore.data.items, function(val) {
					                  var newData = {
					                          "name" : val.data.documentName,
					                          "path" : val.data.path,
					                          "type" : val.data.type,
					                          "id"	 : val.data.id,
					                          "createdBy" : this$.getIdValueJson(
					                                  val.data.createdBy.id,
					                                  val.data.createdBy.value)
					                  };
					                  docArray.push(newData);
					              });
					          }
					          var urlArray = [];
					          var urlStore = this$.getStore('personinfo.common.pasthistory.ApplicantLanguageUrlDetailStore');
					          if (urlStore.data.items != null
					                  && urlStore.data.items.length > 0) {
					              Ext.each(urlStore.data.items, function(val) {
					                  var newData = {
					                          "name" : val.data.documentName,
					                          "path" : val.data.path,
					                          "type" : val.data.type,
					                          "id"	 : val.data.id,
					                          "createdBy" : this$.getIdValueJson(
					                                  val.data.createdBy.id,
					                                  val.data.createdBy.value)
					                  };
					                  urlArray.push(newData);
					              });
					          }
					      }
					      formData.languageDocument = docArray;
					      formData.languageDocumentUrl = urlArray;
					      jsonFormFieldData = Ext.encode(formData);
					      return jsonFormFieldData;
					  },
					  editApplicantLanguageWindow: function(informationType, formItemId, gridItemId, isViewMode) {
					      var this$ = this;
					      var personProfile = this$.getContentPanelActiveTab();
					      var grid = personProfile.down(gridItemId);

					      if (grid.getSelectionModel().getCount() > 0) {
					      	this$.showPersonCommonWindow(informationType, formItemId);
					      	  var form = this$.getStudentlanguagedetailform();
					      	  var formWindow = this$.getPersonCommonWindow();
					      	  if(isViewMode!=null && (isViewMode==true || isViewMode=='true')) {
					      		  formWindow.setTitle(getCommonTranslation('VIEW_APPLICANT_LANGUAGE'));
					      	  }else{
					      		  formWindow.setTitle(getCommonTranslation('EDIT_APPLICANT_LANGUAGE'));
					      	  }
					          var records = grid.getSelectionModel().getSelection()[0];
					          if (!isEmpty(records)) {
					        	form.down('#language_detail_hidden_field').setValue(records.data.id);
					        	  
					          		var languageType = form.down('#language')
					             	 if (!isNullOrEmpty(records.data.language)) {		            	
					             		languageType.getStore().load({ 
					                    	callback: function(recordss, operation, success) {
					                    		if (success) {
					                    			for(i in recordss){
					                    				if(recordss[i].data.id == records.data.language.id)
					                    					languageType.setValue(recordss[i].data.id);  	
					                    			}
					                    		}
					                    	}
					                    });
					                    }
					          		
					          		var languageExamType = form.down('#languageExamType')
					            	 if (!isNullOrEmpty(records.data.languageExamType)) {		            	
					            		 languageExamType.getStore().load({ 
					                   	callback: function(recordss, operation, success) {
					                   		if (success) {
					                   			for(i in recordss){
					                   				if(recordss[i].data.id == records.data.languageExamType.id)
					                   					languageExamType.setValue(recordss[i].data.id);  	
					                   			}
					                   		}
					                   	}
					                   });
					                  }
					              	
					          		var languageExamDate = form.down("#languageExamDate");
					          	    if(!isNullOrEmpty(records.data.languageExamDate))
					          	    records.data.languageExamDate = new Date(records.data.languageExamDate);
					          	    languageExamDate.setValue(records.data.languageExamDate);
					              	
					          	 setTimeout(function(){
						    		  var otherLanguageExamType = form.down("#otherLanguageExamType");
						    		  if(!isNullOrEmpty(records.data.otherLanguageExamType))
						    			  otherLanguageExamType.setValue(records.data.otherLanguageExamType);
					          	}, 500);
						    		  
						    	   
					          	var overAllScore = form.down("#overAllScore");
					            if(!isNullOrEmpty(records.data.overAllScore))
					            	overAllScore.setValue(records.data.overAllScore);
					            
					            var yearOfEducation = form.down("#yearOfEducation");
					    		  if(!isNullOrEmpty(records.data.yearOfEducation))
					    			  yearOfEducation.setValue(records.data.yearOfEducation);
					            
					            var isPrimaryLanguage = form.down("#isPrimaryLanguage");
					            if(!isNullOrEmpty(records.data.isPrimaryLanguage))
					            	records.data.isPrimaryLanguage = records.data.isPrimaryLanguage
					            	isPrimaryLanguage.setValue(records.data.isPrimaryLanguage);
					          }
					      } else {
					          showWarningMessage(getCommonTranslation('APPLICANT_LANGUAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					      }
					  },
					  viewApplicantLanguageDetailFormWindow: function(informationType, formItemId, gridItemId) {
						  var this$ = this;
						  var personProfile = this$.getContentPanelActiveTab();
					      var grid = personProfile.down(gridItemId);
					      if (grid.getSelectionModel().getCount() > 0) {
						      this$.editApplicantLanguageWindow(informationType, formItemId, gridItemId, true);
						      var form = this$.getStudentlanguagedetailform();
						      form.down('#language').setReadOnly(true);
						      form.down('#yearOfEducation').setReadOnly(true);
						      form.down('#languageExamType').setReadOnly(true);
						      form.down('#languageExamDate').setReadOnly(true);
						      form.down('#languageUploadFileItemId').setVisible(false);
						      form.down('#languageURLItemId').setVisible(false);
						      var applicantlanguagedocumentlistgrid = form.down('#applicantlanguagedocdetailgrid');
						      var applicantlanguagedocurllistgrid = form.down('#applicantlangurlgrid');
						      applicantlanguagedocumentlistgrid.down('#btnDelete').setDisabled(true);
						      applicantlanguagedocurllistgrid.down('#btnDelete').setDisabled(true);
						      this$.viewPersonCommonWindow(form);
					      } else {
					    	  showWarningMessage(getCommonTranslation('APPLICANT_LANGUAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					      }
					  },
					  
					  deleteApplicantLanguageDetailRecord:function(gridItemId, deleteUrl) {
					      var this$ = this;
					      var personProfile = this$.getContentPanelActiveTab();
					      var grid = personProfile.down(gridItemId);
					      if (grid.getSelectionModel().getCount() > 0) {
					          showConfirmMessage(getCommonTranslation('DELETE_APPLICANT_LANGUAGE'), getCommonTranslation('APPLICANT_LANGUAGE_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
					              if (btn == 'yes') {
					                  if (grid.getSelectionModel().getCount() > 0) {
					                      var records = grid.getSelectionModel().getSelection();
					                      var flag=false;
					                      for (var count = 0; count < records.length; count++) {
					                          var id = "";
					                          if (!isNullOrEmpty(records[count].get("id"))) {
					                              id = records[count].get("id");
					                          }
					                          Ext.Ajax.request({
					                              type: 'rest',
					                              url: deleteUrl,
					                              async:false,
					                              method: 'DELETE',
					                              headers: {
					                                  'Content-Type': 'application/json'
					                              },
					                              params: {
					                              	id: id
					                              },
					                              success: function(form, action) {
					                            	  flag=true;
					                              }
					                          });
					                      }
					                      if(flag) {
					                          grid.getStore().reload();
					                          showSuccessMessage(getCommonTranslation('DELETE_APPLICANT_LANGUAGE'), getCommonTranslation('APPLICANT_LANGUAGE_DELETE_SUCCESS'));
					                      }
					                  }
					              }
					          });
					      } else {
					          showWarningMessage(getCommonTranslation('DELETE_APPLICANT_LANGUAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					      }
					  },
			    
					  saveStudentEngagement: function(btn) {
						  var form = btn.up('form');
						  var activeTab = form.up('tabpanel').getActiveTab();
						  var vals = form.getValues();
						  var studentUserId = this.getContentPanelActiveTab().userId;
						  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						  Ext.Ajax.request({
							  type: 'rest',
							  url: SERVERURL.PATH_STUDENT_ENGAGEMENT_DETAIL,
							  async: false,
							  method: 'POST',
							  headers: {
								  'Content-Type': 'application/json'
							  },
							  jsonData: {
								  id: vals.id,
								  student: {
									  id: studentUserId
								  },
								  researchCouncilStudentIdentifier: vals.councilStudentIdentyName,
								  ukriStudentshipReferenceNumber: vals.ukriRefNoName,
								  studyIntention: isNullOrEmpty(vals.studyIntentionName) ? null : {
									  id: vals.studyIntentionName
								  },
								  feeEligibility: isNullOrEmpty(vals.feeEligibilityName) ? null : {
									  id: vals.feeEligibilityName
								  },
								  incomingExchange: isNullOrEmpty(vals.incomingExchangeName) ? null : {
									  id: vals.incomingExchangeName
								  },
								  nhsEmployer: isNullOrEmpty(vals.nhsEmployerName) ? null : {
									  id: vals.nhsEmployerName
								  },
								  qualifiedTeacherStatus: isNullOrEmpty(vals.qualifiedTeacherStatusName) ? null : {
									  id: vals.qualifiedTeacherStatusName
								  },
								  ittEntryRoute: isNullOrEmpty(vals.entryRouteName) ? null : {
									  id: vals.entryRouteName
								  },
								  researchCouncilStudent: isNullOrEmpty(vals.researchcouncilStudentName) ? null : {
									  id: vals.researchcouncilStudentName
								  }
							  },
							  success: function(form, action) {
								  if (form.status == 200) {
									  Ext.getBody().unmask();
									  showSuccessMessage(getCommonTranslation('ALERT'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
									  activeTab.close();
								  }
							  }
						  });
					  },

					  loadStudentEngagementData: function(form) {
						  var studentUserId = this.getContentPanelActiveTab().userId;
						  Ext.Ajax.request({
							  type: 'rest',
							  url: SERVERURL.PATH_FIND_BY_STUDENT_ID,
							  async: false,
							  method: 'GET',
							  headers: {
								  'Content-Type': 'application/json'
							  },
							  params: {
								  studentId: studentUserId
							  },
							  success: function(response, action) {
								  try {
									  var data = Ext.decode(response.responseText);
									  form.getForm().setValues({
										  councilStudentIdentyName: data.researchCouncilStudentIdentifier,
										  ukriRefNoName: data.ukriStudentshipReferenceNumber,
										  id: data.id
									  });
									  var entryRouteName = form.down('#entryRouteNameId');
									  entryRouteName.getStore().load({
										  callback: function() {
											  entryRouteName.setValue(data.ittEntryRouteId);
										  }
									  });
									  var feeEligibility = form.down('#feeEligibilityId');
									  feeEligibility.getStore().load({
										  callback: function() {
											  feeEligibility.setValue(data.feeEligibilityId);
										  }
									  });
									  var qualifiedTeacherStatus = form.down('#qualifiedTeacherStatusId');
									  qualifiedTeacherStatus.getStore().load({
										  callback: function() {
											  qualifiedTeacherStatus.setValue(data.qualifiedTeacherStatusId);
										  }
									  });
									  var researchcouncilStudent = form.down('#researchcouncilStudentId');
									  researchcouncilStudent.getStore().load({
										  callback: function() {
											  researchcouncilStudent.setValue(data.researchCouncilStudentId);
										  }
									  });
									  var nhsEmployer = form.down('#nhsEmployerId');
									  nhsEmployer.getStore().load({
										  callback: function() {
											  nhsEmployer.setValue(data.nhsEmployerId);
										  }
									  });
									  var studyIntention = form.down('#studyIntentionId');
									  studyIntention.getStore().load({
										  callback: function() {
											  studyIntention.setValue(data.studyIntentionId);
										  }
									  });
									  var incomingExchange = form.down('#incomingExchangeId');
									  incomingExchange.getStore().load({
										  callback: function() {
											  incomingExchange.setValue(data.incomingExchangeId);
										  }
									  });
								  }
								  catch(e) {
									  console.log(e);
								  }
							  }
						  });
					  },
	
}

);


