/**
 * This controller is used for student and faculty request actions   
 */
Ext.define('Academia.controller.personinfo.common.PersonRequestActionController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',
	mixins: { 
		StudentCourseExecutionController:'Academia.controller.personinfo.student.StudentCourseExecutionController',
    },	

    stores: ['personinfo.common.request.RequestRaisedHistoryStore', 'personinfo.common.request.RequestPendingDecisionStore',
             'personinfo.common.request.RequestExecutedHistoryStore', 'personinfo.common.request.RequestPendingActionStore',
             'reports.servicerequest.ServiceRequestSubCategoryStore',
             'servicerequest.servicerequestsettings.CertificateCategories','reports.servicerequest.CertificateSubCategoryStore',
             'reports.servicerequest.FreeFormCategoryStore','reports.servicerequest.FreeFormSubCategoryStore',
             'common.picklist.StudentSelectNameComboStore','servicerequest.common.RequesterTypes','servicerequest.common.ServiceRequestStatus',
             'personinfo.common.request.ServiceRequestDocumentDocumentListStore','servicerequest.common.RequesterBy','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
             'personinfo.common.request.RequestPendingDocumentListGridStore','personinfo.common.request.RequestPendingMandatoryDocumentListGridStore','program.ProgramByGroupIdStore',
             'student.StudentTransferCreditRequest.STDTrasferAdmissionStudentNameStore','student.StudentTransferCreditRequest.STDTrasferProgramStore',
             'student.StudentTransferCreditRequest.StudentTransferCreditMainGridStore'],

    views: ['personinfo.common.request.RequestPendingDecisionGrid', 'personinfo.common.request.RequestPendingDecisionForm', 
            'personinfo.common.request.RequestRaisedHistoryGrid', 'personinfo.common.request.RequestRaisedHistoryForm',
            'personinfo.common.request.RequestExecutedHistoryGrid', 'personinfo.common.request.RequestPendingActionGrid',
            'servicerequest.FacultyPortalTrackRequestPanel','servicerequest.FindFacultyPortalRequestForm','servicerequest.FacultyPortalPendingActionPanel',
            'servicerequest.FacultyPortalRequestRaisedHistoryPanel','servicerequest.FacultyPortalRequestExecutedHistoryPanel',
            'servicerequest.FacultyRequestHistorySearchForm',
            'personinfo.common.request.OpenRequestDocumentList',
            'personinfo.common.request.OpenRequestDocumentListGrid',
            'personinfo.common.request.RequestRaisedHistoryDocumentListGrid',
            'personinfo.common.request.RequestRaisedHistoryDocumentList','reports.student.RequestSubRequestTypeFieldContainer','personinfo.common.request.RequestPendingDocumentWindow',
            'personinfo.common.request.RequestPendingDocumentListGrid','personinfo.common.request.RequestPendingMandatoryDocumentListGrid','personinfo.common.request.RequestPendingMandatoryDocumentWindow',
            'studentTransferCreditRequest.STDMainTransferCreditRequestStructure','studentTransferCreditRequest.StudentTransferCreditFilter','studentTransferCreditRequest.StudentTransferCreditGrid',
            'student.studentprofile.StudentTransferCreditRequestStructure'], 

    refs:[{
		ref: 'studenttransfercreditrequeststructure',
		selector: 'studenttransfercreditrequeststructure'
	},{
    	ref: 'requestPendingDecisionGrid',
        selector: 'requestpendingdecisiongrid'
    },{
    	ref: 'requestPendingActionGrid',
        selector: 'requestpendingactiongrid'
    	
    },{
    	ref: 'requestRaisedHistoryGrid',
        selector: 'requestraisedhistorygrid'
    },{
    	ref: 'requestExecutedHistoryGrid',
        selector: 'requestexecutedhistorygrid'
    },{
    	ref: 'openrequestdocumentlist',
        selector: 'openrequestdocumentlist'
    },{
    	ref: 'requestpendingdocumentwindow',
        selector: 'requestpendingdocumentwindow'
    },{
    	ref: 'requestpendingdocumentlistgrid',
        selector: 'requestpendingdocumentlistgrid'
    },{
    	ref: 'requestpendingmandatorydocumentlistgrid',
        selector: 'requestpendingmandatorydocumentlistgrid'
    },{
    	ref: 'requestpendingmandatorydocumentwindow',
        selector: 'requestpendingmandatorydocumentwindow'
    },{
    	ref: 'stdmaintransfercreditrequeststructure',
        selector: 'stdmaintransfercreditrequeststructure'
    },{
    	ref: 'studenttransfercreditfilter',
        selector: 'studenttransfercreditfilter'
    },{
    	ref: 'studenttransfercreditgrid',
        selector: 'studenttransfercreditgrid'
    }],
     
    init: function() {
    	this.activeTransferCreditType = null, 
    	this.control({
    		'studenttransfercreditrequeststructure':{
    			afterrender: function(structure){
    				var me = this
    				Ext.defer(function(){        				
        				var grid = me.getStudenttransfercreditgrid();
        				if(grid && grid.getSelectionModel() && grid.getSelectionModel().getSelection() && grid.getSelectionModel().getSelection().length == 1){
        					var selectedRecord = grid.getSelectionModel().getSelection()[0];
        					var examTransferCreditType = selectedRecord.get('examTransferCreditType');
        					var TransferCreditTabPanel = structure.down('tabpanel');
        					if (!TransferCreditTabPanel) return;    					
        					 var associatedAcadLocationIds = new Array();
        			     	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
        			 		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getSTUDENT_TRANSFER_CREDIT_DETAILS_PERMISSIONS());
        					
        					var externalTransferCreditRequestTab = TransferCreditTabPanel.down('#externalTransferCreditTabItemId')
        					var internalTransferCreditRequestTab = TransferCreditTabPanel.down('#internalTransferCreditTabItemId')
        					var targetTab;
        					if(examTransferCreditType === 'EXTERNAL_TRANSFER_CREDIT'){
        						targetTab = externalTransferCreditRequestTab
        					}
        					else{
        						Ext.each(permissionList, function(privilege) {
    		   			     		if (privilege === 'INTERNAL_TRANSFER_CREDIT_TAB') {
    		   			     		targetTab = internalTransferCreditRequestTab
    		   			     		}
    		   			     		else{
    		   			     		targetTab = externalTransferCreditRequestTab
    		   			     	}
        					});
        					}
        					if (targetTab && TransferCreditTabPanel) {
        						TransferCreditTabPanel.setActiveTab(targetTab);
        			        }
        					 targetTab = null;      					
        				}
        			
    				},300)
    			}
    		},
    		'requestpendingdecisiongrid': {
    			cellclick: function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
    				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
    				if(columnName == "documents"){
    					if(e.target.tagName=='A'){
    						var $this = this;
    						var docWindow = $this.getOpenrequestdocumentlist();
    						var ID = record.data.id;
    						if (!docWindow) {
    							docWindow = Ext.widget('openrequestdocumentlist');
    						}
    						docWindow.show();   
    						docWindow.down('form').down('#noOfDocItemId').setValue(record.raw.noOfDoc);
    						var grid = docWindow.down('#OpenRequestDocumentListGridItemId');
    						//grid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
    						var store = grid.getStore();
    						store.getProxy().extraParams = {
    							serviceRequestId: record.data.id
    						};
    						store.load();
    					}//);
    				}
    				else{
    					var searchResultGrid = this.getRequestPendingDecisionGrid();
    					this.cellclickTrackRequestGrid(searchResultGrid,ColIdx,record);  
    				}
    			}
    		},
    		'openrequestdocumentlistgrid':{
    			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if(columnName == "name"){
    					if(e.target.tagName=='A'){
    						var documentId = record.raw.encryptedDocId;
    						if (!isNullOrEmpty(documentId)) {
    							this.getDocumentController().downloadDocumentFile(documentId);
    						}
    					}
    				}
    			}
    		},
    		'requestpendingactiongrid': {
    			cellclick: function(grid, td, cellIndex, record,RowEl, RowIdx, e,eopts){
    				var me = this;
    				var searchResultGrid = this.getRequestPendingActionGrid();
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);       
    				if(columnName == "VAL_DOCUMENT_ID"){
						if(e.target.tagName=='A'){
							var docWindow = this.getRequestpendingdocumentwindow();
									if (!docWindow) {
										docWindow = Ext.widget('requestpendingdocumentwindow',{
											itemId:'requestpendingdocumentwindowItemId'
										});
									}
									docWindow.show();
									var requestpendingdocumentlistgrid = docWindow.down('#requestpendingdocumentlistgridItemId');
									requestpendingdocumentlistgrid.setTitle(getServiceRequestTranslation('VOLUNTARY_DOCUMENTS'));
									var store = requestpendingdocumentlistgrid.getStore();
									store.getProxy().extraParams = {
										serviceReqId: record.data.id
									};
									store.load();
						}
					}
    				if(columnName == "MAN_DOCUMENT_ID"){
						if(e.target.tagName=='A'){
							        var manDocWindow = this.getRequestpendingmandatorydocumentwindow();
									if (!manDocWindow) {
										manDocWindow = Ext.widget('requestpendingmandatorydocumentwindow',{
											itemId:'requestpendingmandatorydocumentwindowItemId'
										});
									}
									manDocWindow.show();
									var requestpendingMandatorydocumentgrid = manDocWindow.down('#requestpendingmandatorydocumentlistgridItemId');
									requestpendingMandatorydocumentgrid.setTitle(getServiceRequestTranslation('MANDATORY_DOCUMENTS'));
									var gridStore = requestpendingMandatorydocumentgrid.getStore();
									gridStore.getProxy().extraParams = {
										serviceReqId: record.data.id
									};
									gridStore.load();
						}
					}
    				if(columnName == "APPROVAL_LETTER"){
    					if(e.target.tagName=='A'){
    						if(!isNullOrEmpty(record.data.approvalLetterId)){
    							me.getDocumentController().downloadDocumentFile(record.data.approvalLetterId);
    						}
    					}
					}
           	 	}
    		},
    		'requestraisedhistorygrid':{
        			cellclick: function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
        				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
        				if(columnName == "documents"){
        					if(e.target.tagName=='A'){
        						var $this = this;
        						var docWindow = $this.getOpenrequestdocumentlist();
        						var ID = record.data.id;
        						if (!docWindow) {
        							docWindow = Ext.widget('requestraisedhistorydocumentlist');
        						}
        						docWindow.show();  
        						docWindow.down('form').down('#noOfDocItemId').setValue(record.raw.noOfDoc);
        						var grid = docWindow.down('#requestraisedhistorydocumentlistgridItemId');
        						var store = grid.getStore();
        						store.getProxy().extraParams = {
        							serviceRequestId: record.data.id
        						};
        						store.load();
        					}//);
        				}
        				else{
        					var searchResultGrid = this.getRequestRaisedHistoryGrid();
            				this.cellclickTrackRequestGrid(searchResultGrid,ColIdx,record);  
        				}
        			}
    		},'requestexecutedhistorygrid':{
    			cellclick: function(grid, td, cellIndex, record){
    				var searchResultGrid = this.getRequestExecutedHistoryGrid();
    				this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);  
    			}
    		},
    		'requestraisedhistorydocumentlistgrid':{
    			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if(columnName == "name"){
    					if(e.target.tagName=='A'){
    						var documentId = record.raw.encryptedDocId;
    						if (!isNullOrEmpty(documentId)) {
    							this.getDocumentController().downloadDocumentFile(documentId);
    						}
    					}
    				}
    			}
    		},
    		'requestpendingdocumentlistgrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							this.getDownloadReqPendingFile(record.raw.displayOtherLanguage);
						}
					}
				}
			},
			'requestpendingdocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					this.requestPendingDocumentReportDocumentZip('VOLUNTARY_DOC');
				}
			},
			'requestpendingmandatorydocumentlistgrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							this.getDownloadReqPendingFile(record.raw.displayOtherLanguage);
						}
					}
				}
			},
			'requestpendingmandatorydocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					this.requestPendingDocumentReportDocumentZip('MANDATORY_DOC');
				}
			},
			'studenttransfercreditfilter button[itemId=resetBtn]': {
	   			 click: this.resetTransferCreditRequestFilter
	   		 	},
			'studenttransfercreditfilter button[itemId=quickSearchId]': {
   			 click: this.loadTransferCreditRequestGrid
   		 	},
   		 	'studenttransfercreditfilter customcombobox[itemId=admissionId]':{
   		 	afterrender: function(cmb){
					var store = cmb.getStore();
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation()
					};
					store.load();
				},
				select: function(obj, record) {
               		var form = this.getStudenttransfercreditfilter(); 
               		form.down("#programId").reset();
        			form.down("#programId").setDisabled(false);
    				var admissionId = record[0].get("id");
    				if (admissionId > 0) {
    					var store=form.down("#programId").getStore();
    					store.getProxy().extraParams = {
    						academyLocationId: this.getCurrentAcademyLocation(),
    						admissionId: admissionId
    					};
    					store.load();
    				}
    			} 
			},
			'studenttransfercreditfilter customcombobox[itemId=programId]': {
				afterrender: function(cmb){
					var store = cmb.getStore();
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation()
					};
					store.load();
				},
               	select: function(obj, record) {
               		var form = this.getStudenttransfercreditfilter(); 
               		form.down("#batchId").reset();
        			form.down("#batchId").setDisabled(false);
    				var programId = record[0].get("id");
    				var admissionId = form.down('#admissionId').getValue();
    				if (programId > 0) {
    					var store=form.down("#batchId").getStore();
    					store.getProxy().extraParams = {
    						admissionId:admissionId,
    						programId: programId
    					};
    					store.load();
    				}
    			},
    		},
    		'studenttransfercreditgrid': { 
    			 cellclick: this.cellClickStudentTransferCreditGrid,
    		}
		});
    },
    cellClickStudentTransferCreditGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) { 
    	var this$ = this;
    	var academyLocationId = this$.getCurrentAcademyLocation();
    	var columnName = view.getGridColumns()[cellIndex].dataIndex;
    	if (columnName == "studentCode") {
            var tabTitle = record.get('studentCode');
            var personId = record.get('id');
            var userId = record.get('studentId');
            var admissionId = record.get('admissionId');
            var programBatchSeatTypeConfigId = record.get('progBatchSeatConfigId');
            var examTransferCreditType = record.get('examTransferCreditType');
            if(!isNullOrEmpty(userId)){
            	this$.addContentPanelTabWithSubTab("studenttransfercreditrequeststructure", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
            }
        }
    },
    cellclickTrackRequestGrid: function(grid, cellIndex, record) {
	     var columnName = grid.columnManager.columns[cellIndex].dataIndex;
	     if (columnName === "REQUEST_ID") {
	    	 	var requestId = record.data.id;
	         	var requestType = record.data.REQUEST_TYPE;
	         	var serviceRequestController= Academia.app.getController('Academia.controller.servicerequest.ServiceRequestController');
	         	serviceRequestController.setRequestData(requestId,record,requestType);
	     }
	 }, 
	 loadRequestPanel: function(form){
		 if(form.up().xtype == 'facultyportalpendingactionpanel'){
			var grid = form.up().down("#facultyPoratalPendingActionGrid"); 
 		    this.loadGridStore('#facultyPoratalPendingActionGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_ACTION);
		 	this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_REQUEST_PENDING_ACTION());
		 } else {
			var grid = form.up().down("#facultyPoratalTrackRequestGrid");
		    this.loadGridStore('#facultyPoratalTrackRequestGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_DECISION);
        	this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS());
		 }
	 },
	 findRequestsByCriteria: function(button){
		var panel = button.up("#facultyTrackRequest").up();
		var form = button.up().up();
		var requesterType=form.down('#selectedNameField');
		if(panel.xtype == 'facultyportalpendingactionpanel'){
			var grid = panel.down("#facultyPoratalPendingActionGrid");
			if(requesterType.getValue()=='EMPLOYEE'){
			for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
                var column = grid.columnManager.columns[i];
                if (column.dataIndex == 'PROGRAM' || column.dataIndex == 'SECTION' || column.dataIndex== 'FATHER_NAME') {
                    column.hide();
                }
            }
		}else{
			grid.down("[dataIndex=PROGRAM]").show();
			grid.down("[dataIndex=SECTION]").show();
			
		}
			this.loadTrackRequestGrid('#facultyPoratalPendingActionGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_ACTION,form);
//			this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_REQUEST_PENDING_ACTION());
		} else {
			var grid = panel.down("#facultyPoratalTrackRequestGrid");
			this.loadTrackRequestGrid('#facultyPoratalTrackRequestGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_DECISION,form);
//			this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS());
		}
	 },
	 
	 findRequestHistoryByCriteria: function(button){
		 var form = button.up().up();
			var panel = form.up();
			if(panel.xtype == 'facultyportalrequestraisedhistorypanel'){
				var grid = panel.down("#facultyRequestRaisedHistoryGrid");
				this.loadTrackRequestGrid('#facultyRequestRaisedHistoryGrid', SERVERURL.PERSON_SERVICE_REQUEST_RAISED,form);
				this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS());
			} else {
				var grid = panel.down("#facultyRequestExecutedHistoryGrid");
				this.loadTrackRequestGrid('#facultyRequestExecutedHistoryGrid', SERVERURL.PERSON_SERVICE_REQUEST_EXECUTED,form);
				this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS());
			}
		 },
    /**
	 *  Load store after grid renderer
	 *  @param gridItemId
	 *  @param url
	 */
	loadGridStore: function(gridItemId, url) {
	    var this$ = this;
	    var personProfile = this$.getContentPanelActiveTab();
//	    var personObj = this$.getPersonObj();
	    var grid = personProfile.down(gridItemId);
	    if (grid) {
//	        var personId = personObj["id"];
	    	var personId = personProfile.userId;
	        var store = grid.getStore();
	        store.getProxy().api.read = url;
	        store.getProxy().extraParams = {
                personId: personId
            };
            store.load();
	    }
	},
	
	loadTrackRequestGrid: function(gridItemId, url,form) {
	    var this$ = this;
		
	    var personProfile = this$.getContentPanelActiveTab();
	    var grid = personProfile.down(gridItemId);
	    if (grid) {
	    	var formValues = form.getValues();
	    	var personId = personProfile.userId;
			var	requestId = formValues.REQUEST_ID;
			var	status = formValues.STATUS;
			var	requestTypeId = formValues.REQUEST_TYPE_ID;
			var	subRequestType = formValues.SUBREQUEST_TYPE;
			var freeFormRequestCat = formValues.FREE_FORM_REQUEST_CATEGORY;
			var freeFormRequestId = formValues.FREE_FORM_REQUEST_ID;
			var certificateCat = formValues.CERTIFICATE_CATEGORY;
			var certificateId = formValues.CERTIFICATE_ID;
			var SLA = formValues.SLA;
			var fromDate = formValues.FROM_DATE;
			var requesterType=formValues.selectedNameField;
			var studentId=formValues.STUDENT_ID;
			var requestBy= formValues.REQUESTER_TYPE;
			var employeeId=formValues.FACULTY_CODE;
			var toDate;
			var autoFollowupCheck = formValues.autoFollowupCheck;
			if(!isNullOrEmpty(formValues.TILL_DATE)){
			//var endDate =  Ext.Date.add(new Date(formValues.TILL_DATE),Ext.Date.DAY,1);
			//endDate =Ext.Date.format(endDate, CONSTANTS.SUBMIT_DATE_FORMAT);
			toDate = formValues.TILL_DATE;
			}
			var serviceRequestGroup = formValues.SERVICE_REQUEST_GROUP;
	        var store = grid.getStore();
	        store.getProxy().api.read = url;	        
	        store.getProxy().extraParams = {
                personId: personId               
            };
	        if(!isNullOrEmpty(subRequestType)) {
	        	store.getProxy().extraParams.subRequestType=subRequestType;
	        }
	        if(!isNullOrEmpty(SLA)) {
	        	store.getProxy().extraParams.SLA=SLA;
	        }
	        if(!isNullOrEmpty(fromDate)) {
	        	store.getProxy().extraParams.fromDate=fromDate;
	        }
	        if(!isNullOrEmpty(toDate)) {
	        	store.getProxy().extraParams.toDate=toDate;
	        }
	        if(!isNullOrEmpty(status)) {
	        	store.getProxy().extraParams.status=status;
	        }
	        if(!isNullOrEmpty(requestTypeId)) {
	        	store.getProxy().extraParams.requestTypeId=requestTypeId;
	        }
	        if(!isNullOrEmpty(requestId)) {
	        	store.getProxy().extraParams.requestId=requestId;
	        }
	        if(!isNullOrEmpty(freeFormRequestCat)) {
	        	store.getProxy().extraParams.freeFormRequestCat=freeFormRequestCat;
	        }
	        if(!isNullOrEmpty(serviceRequestGroup)) {
	        	store.getProxy().extraParams.serviceRequestGroup=serviceRequestGroup;
	        }
			 if(!isNullOrEmpty(freeFormRequestId)) {
	        	store.getProxy().extraParams.freeFormRequestId=freeFormRequestId;
	        }
			 if(!isNullOrEmpty(certificateCat)) {
	        	store.getProxy().extraParams.certificateCat=certificateCat;
	        } 
	        if(!isNullOrEmpty(certificateId)) {
	        	store.getProxy().extraParams.certificateId=certificateId;
	        }
	        if(!isNullOrEmpty(requesterType)){
	        	store.getProxy().extraParams.requesterType=requesterType;
	        }
	        if(!isNullOrEmpty(studentId)){
	        	store.getProxy().extraParams.studentId=studentId;
	        }
	        if(!isNullOrEmpty(requestBy)){
	        	store.getProxy().extraParams.requestBy=requestBy;
	        }
	        if(!isNullOrEmpty(employeeId)){
	        	store.getProxy().extraParams.employeeId=employeeId;
	        }
	        if(Ext.isDefined(autoFollowupCheck)){
	        	store.getProxy().extraParams.autoFollowupCheck=autoFollowupCheck;
	        }
            store.load();
            
            try{
            	if(grid && grid.itemId== "facultyPoratalPendingActionGrid" && formValues && formValues.SERVICE_REQUEST_GROUP == "EXAM_RELATED" && form && form.down('#requestSubCategoryField') && form.down('#requestSubCategoryField').getDisplayValue() == "Exam Concession Request"){
            		grid.down('[dataIndex=APPROVAL_LETTER]').setVisible(true);
            	}
            	else if(grid && grid.itemId== "facultyPoratalPendingActionGrid"){
            		grid.down('[dataIndex=APPROVAL_LETTER]').setVisible(false);
            	}
            }
            catch(e){
            	//--
            }
	    }	    
      
	},
	
	resetCustomForm:function(obj){
 		var form = obj.up('form');
 		form.getForm().reset();
 		 var requestTypeField = form.down('requestsubrequesttypefieldcontainer');
         var requestType = requestTypeField.down('#requestSubCategoryField');
         var certificateCategory = requestTypeField.down('#certificateCategoryField');
         var certificateType = requestTypeField.down('#certificateSubCategoryField');
         var generalCategory = requestTypeField.down('#freeFormCategoryField');
         var generalType = requestTypeField.down('#freeFormSubCategoryField');
         form.down('#facultyCodeItemId').setVisible(false);
         form.down('#student_id').setVisible(true);
         requestType.setVisible(false);
         certificateCategory.setVisible(false);
         certificateType.setVisible(false);
         generalCategory.setVisible(false);
         generalType.setVisible(false);
         
 		this.toggleFormFieldsItems(form);
 		form.isValid(true);
 		var fromDate = form.down('#from_date');
        var tillDate = form.down('#till_date');
        if(!isNullOrEmpty(fromDate)){
        	fromDate.setMinValue(false);
        	fromDate.setMaxValue(false);
        }
        if(!isNullOrEmpty(tillDate)){
        	tillDate.setMinValue(false);
        	tillDate.setMaxValue(false);
        }
 	},
 	
	/**
	 * show person common window
	 * @param informationType
	 * @param formItemId
	 */
	showPersonCommonWindow: function(informationType, formItemId) {
	    var this$ = this;
	    var title = null,
	        xtypeForm = null;
	    var formWindow = this$.getPersonCommonWindow();
	    if (!formWindow) {
	        switch (informationType) {
	
	        case 'REQUEST_RAISED_HISTORY':
	            { //Request Raised History
	                title = getPersonModuleTranslation('REQUEST_RAISED_HISTORY');
	                xtypeForm = 'requestraisedhistoryform';
	                break;
	            }
	        case 'REQUEST_EXECUTED_HISTORY':
	            { //Request Executed History
	                title = getPersonModuleTranslation('REQUEST_EXECUTED_HISTORY');
	                xtypeForm = 'requestpendingdecisionform';
	                break;
	            }
	        case 'REQUEST_PENDING_DECISION':
	            { //Request Pending Decision
	                title = getPersonModuleTranslation('REQUEST_PENDING_DECISION');
	                xtypeForm = 'requestpendingdecisionform';
	                break;
	            }
	        case 'REQUEST_PENDING_ACTION':
	            { //Request Pending Action
	                title = getPersonModuleTranslation('REQUEST_PENDING_ACTION');
	                xtypeForm = 'requestpendingdecisionform';
	                break;
	            }
	        default:
	            {
	                break;
	            }
	        }
	
	        formWindow = Ext.widget('personcommonwindow', {
	            title: title,
	            itemId: 'personCommonWindow',
	            items: [{
	                xtype: xtypeForm,
	                itemId: formItemId
	            }]
	        });
	    }
	
	    formWindow.show();
	},
	/**
	 * view person common window
	 */
	viewPersonCommonWindow: function(form) {
	
	    if (form) {
	        form.down('#submitButtonId').setVisible(false);
	        form = form.getForm();
	        toggleReadOnlyFormItems(form, true);
	    }
	},
	
	/**
	 * Close person common window
	 */
	closePersonCommonWindow: function() {
	    var this$ = this;
	    this$.getPersonCommonWindow().close();
	},
	/**
     * View request raised history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewRequestRaisedHistory: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonRequestRaisedHistoryForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                //form.loadRecord(records);
            	var form1 = form.getForm();
            	form1.findField('REQUEST_ID').setValue(records.data.REQUEST_ID);
            	if(records.data.SERVICE_REQUEST_GROUP=="TRANSFER"){
            		form1.findField('REQUEST_TYPE').setValue(getServiceRequestTranslation('TRANSFER_REQ_CAT'));
            	}
            	else{
            		form1.findField('REQUEST_TYPE').setValue(getServiceRequestTranslation(records.data.SERVICE_REQUEST_GROUP));
            	}
            	form1.findField('SUBREQUEST_TYPE').setValue(getServiceRequestTranslation(records.data.REQUEST_TYPE));

            	if(records.data.SERVICE_REQUEST_GROUP=="FREE_FORM"){
                    form1.findField('SUBREQUEST_TYPE').setValue(records.data.SR_REQUEST_TYPE);
            	}
            	//form1.findField('REQUEST_TYPE').setValue(records.data.REQUEST_TYPE);
            	if(records.data.SERVICE_REQUEST_GROUP=="FREE_FORM"){
                    form1.findField('REQUEST_SUB_TYPE').setValue(records.data.SUBREQUEST_TYPE);
            	}
            	form1.findField('REQUEST_DATE').setValue(records.data.REQUEST_DATE);
            	form1.findField('STATUS').setValue(records.data.STATUS);
            	form1.findField('REMARKS').setValue(records.data.REMARKS);
            	form1.findField('APPROVER').setValue(records.data.APPROVER);
            	form1.findField('EXECUTION_DATE').setValue(records.data.EXECUTION_DATE);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('REQUEST_RAISED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * View request executed history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewRequestExecutedHistory: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonRequestExecutedHistoryForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                //form.loadRecord(records);
                var form1 = form.getForm();
            	form1.findField('requestId').setValue(records.data.REQUEST_ID);
            	if(records.data.SERVICE_REQUEST_GROUP=="TRANSFER"){
            		form1.findField('requestType').setValue(getServiceRequestTranslation('TRANSFER_REQ_CAT'));
            	}
            	else{
            		form1.findField('requestType').setValue(getServiceRequestTranslation(records.data.SERVICE_REQUEST_GROUP));
            		if(records.data.SERVICE_REQUEST_TYPE=="FREE_FORM"){
                        form1.findField('requestType').setValue(getServiceRequestTranslation(records.data.SERVICE_REQUEST_TYPE));
                	}
            	}
            	if(records.data.SERVICE_REQUEST_TYPE=="FREE_FORM"){
                    form1.findField('REQUEST_SUB_TYPE').setValue(records.data.SUBREQUEST_TYPE);
            	}
            	//form1.findField('requestType').setValue(records.data.REQUEST_TYPE);
            	form1.findField('subRequestType').setValue(getServiceRequestTranslation(records.data.REQUEST_TYPE));
            	if(records.data.SERVICE_REQUEST_TYPE=="FREE_FORM"){
                    form1.findField('subRequestType').setValue(records.data.SR_REQUEST_TYPE);
            	}
            	form1.findField('requestDate').setValue(records.data.REQUEST_DATE);
            	form1.findField('requestStatus').setValue(records.data.STATUS);
            	form1.findField('remarks').setValue(records.data.REMARKS);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('REQUEST_EXECUTED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * View request pending decision
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewRequestPendingDecision: function(informationType, formItemId, gridItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonRequestPendingDecisionForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	var form1 = form.getForm();
            	form1.findField('requestId').setValue(records.data.REQUEST_ID);
            	if(records.data.SERVICE_REQUEST_GROUP=="TRANSFER"){
            	form1.findField('requestType').setValue(getServiceRequestTranslation('TRANSFER_REQ_CAT'));
            	}
            	else{
            		form1.findField('requestType').setValue(getServiceRequestTranslation(records.data.SERVICE_REQUEST_GROUP));
            	}
            	if(records.data.SERVICE_REQUEST_GROUP=="FREE_FORM"){
                    form1.findField('REQUEST_SUB_TYPE').setValue(records.data.SUBREQUEST_TYPE);
            	}
            	//form1.findField('REQUEST_TYPE').setValue(records.data.REQUEST_TYPE);
            	
            	form1.findField('subRequestType').setValue(getServiceRequestTranslation(records.data.REQUEST_TYPE));
            	if(records.data.SERVICE_REQUEST_GROUP=="FREE_FORM"){
                    form1.findField('subRequestType').setValue(records.data.SR_REQUEST_TYPE);
            	}
            	form1.findField('requestDate').setValue(records.data.REQUEST_DATE);
            	form1.findField('requestStatus').setValue(records.data.SERVICE_REQUEST_STATUS);
            	form1.findField('remarks').setValue(records.data.REMARKS);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('REQUEST_PENDING_DECISION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * View request pending action
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewRequestPendingAction: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonRequestPendingActionForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                //form.loadRecord(records);
            	var form1 = form.getForm();
            	form1.findField('requestId').setValue(records.data.REQUEST_ID);
            	
            	if(records.data.SERVICE_REQUEST_GROUP=="TRANSFER"){
            		form1.findField('requestType').setValue(getServiceRequestTranslation('TRANSFER_REQ_CAT'));
            	}
            	else{
            		form1.findField('requestType').setValue(getServiceRequestTranslation(records.data.SERVICE_REQUEST_GROUP));
            	}
            	
            	if(!isNullOrEmpty(records.data.SUBREQUEST_TYPE)){
            		form1.findField('subRequestType').setValue(getServiceRequestTranslation(records.data.SUBREQUEST_TYPE));
            	}
            	else{
            		form1.findField('subRequestType').setValue(getServiceRequestTranslation(records.data.SERVICE_REQUEST_TYPE));	
            	}
            	if(records.data.SERVICE_REQUEST_GROUP=="FREE_FORM"){
            		form1.findField('subRequestType').setValue(records.data.SRS_REQUEST_TYPE)
            		form1.findField('REQUEST_SUB_TYPE').setValue(records.data.SUB_REQUEST_TYPE)
            	}
            	
            	
            	form1.findField('requestDate').setValue(records.data.REQUEST_DATE);
            	form1.findField('requestStatus').setValue(records.data.SERVICE_REQUEST_STATUS);
            	form1.findField('remarks').setValue(records.data.REMARKS);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('REQUEST_PENDING_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
   	getDocumentController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    getDownloadReqPendingFile : function(documentId){
		if(!isNullOrEmpty(documentId)){
			var $this = this;
			$this.getDocumentController()
			.downloadDocumentFile(
					documentId);
		}
	},
	deleteRequestPendingDocument:function(){
		var $this=this;
		var form = $this.getRequestpendingdocumentwindow();
		var requestPendingActionGrid= $this.getRequestPendingActionGrid();
		var requestPendingDocumentListGrid=form.down('#requestpendingdocumentlistgridItemId');
		if (requestPendingDocumentListGrid.getSelectionModel().getCount() > 0) {
			var records = requestPendingDocumentListGrid.getSelectionModel().getSelection();
			var ids=[];
			Ext.Array.each(records,function(value){
				ids.push(value.data.id);
			});
			showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
				if (btn == 'yes'){
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url : SERVERURL.DISCIPLINARY_ACTION_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(form, action) {

							Ext.getBody().unmask();
							showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTIVITY'),getPersonModuleTranslation('DISCIPLINARY_DOCUMENT_SUCCESS_DELETE_MSG'));	 
							requestPendingDocumentListGrid.store.reload();
							requestPendingActionGrid.store.reload();
							requestPendingDocumentListGrid.getSelectionModel().deselectAll(true);
						}
					});
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		}
	},
	requestPendingDocumentReportDocumentZip: function(docType) {
		var $this = this;
		var form;
		var grid;
		var dispatchZipName;
		if(docType=='VOLUNTARY_DOC'){
			 form = $this.getRequestpendingdocumentwindow();
			 grid = form.down('#requestpendingdocumentlistgridItemId');
			 dispatchZipName = "Request Pending Voluntary Documentt";
		}
		if(docType=='MANDATORY_DOC'){
			 form = $this.getRequestpendingmandatorydocumentwindow();
			 grid = form.down('#requestpendingmandatorydocumentlistgridItemId');
			 dispatchZipName = "Request Pending Mandatory Documentt";
		}
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			var saveModel=[];  
			for(var i in records){
				if(!isNullOrEmpty(records[i].get('code'))) {
					saveModel.push(records[i].get('code'));
				}
				showConfirmMessage(getServiceRequestTranslation('SERVICE_REQUEST_DOCUMENTS'),
						getServiceRequestTranslation('DOCUMENTS_ALERT'),
						function(btn, text) {
					if (btn == 'yes') {
						var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
						$this.getController('Academia.controller.document.DocumentController')
						.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
					}
				});

			}
		}
		else {
			$this.hideWindowMask();
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	loadTransferCreditRequestGrid:function(){
		var $this=this;
		var grid = $this.getStudenttransfercreditgrid();
		var form = $this.getStudenttransfercreditfilter().getForm();
		var formValues = form.getValues();
		var ALId = $this.getCurrentAcademyLocation();
		grid.getStore().getProxy().extraParams = {
			admissionId:formValues.admissionId,
			programId:formValues.PROGRAM,
			batchId:formValues.BATCH,
			academyLocationId:ALId
		};
		grid.getStore().load();
		/*pdf & excel report header filter*/
		grid.config.searchFilterForm = $this.getStudenttransfercreditfilter();
	},resetTransferCreditRequestFilter:function(){
		var $this=this;
		var filterForm = $this.getStudenttransfercreditfilter();
		var filter = filterForm.getForm();
		filter.reset();
		filterForm.down('#batchId').setDisabled(true);
		var programField = filterForm.down('#programId');
		var programStore = programField.getStore();
		programStore.getProxy().extraParams = {
			academyLocationId: $this.getCurrentAcademyLocation()
		};
		programStore.load();
	}
});