Ext.define('Academia.controller.personinfo.dashlet.PersonInfoDashboardController', {
	extend : 'Academia.controller.base.BaseController',

	views : [ 'baselayout.contentarea.ContentPanel', 'personinfo.dashlet.PersonInfoDashboardHomePage', 'personinfo.dashlet.PersonInfoDashboardDashlet',
	          /*'personinfo.dashlet.StudentProfileFeeDashlet',*/'personinfo.dashlet.StudentProfileProgressWeightDashlet',
	          'personinfo.dashlet.StudentProfileProgressHeightDashlet','personinfo.dashlet.StudentDisciplinaryActivityDashlet','personinfo.dashlet.StudentD365Dashlet',
	          'personinfo.dashlet.AdmissionIDDetailDashlet'],
			
	stores: ['dashboard.FeeAndPaymentDashletStore','dashboard.StudentD365DashletStore','dashboard.AdmissionIDDetailDashletStore'],		
			
	requires:['Academia.view.dashboard.PortalDropHandler','Academia.view.common.ExtendedDateFilter'],
	
	refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'studentd365dashlet',
        selector: 'studentd365dashlet'
    }, {
        ref: 'admissioniddetaildashlet',
        selector: 'admissioniddetaildashlet'
    }],
			
	init : function() {
		this.control({
			'personinfodashboardhomepage':{
				   afterrender: this.loadPersonInfoDashboard
			},
			'personinfodashboardhomepage #apply' : {
				   click:  function(button){
					   this.applyFilter(button);
				   }
			},
			'studentd365dashlet grid':{
				afterrender: function(grid){
					var me = this;
					var contentpanel = me.getContentpanel();
                	var personProfile = contentpanel.getActiveTab();
			    	
					grid.getStore().on('beforeload', function(store){
				    	try{
				        	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
				        		personProfile = contentpanel.items.items[1];
				        	}
				    	}
				    	catch(e){
				    		//
				    	}
				    	
				    	var userId = personProfile.getUserId();
						
						store.getProxy().extraParams = {
							studentId:userId
						};
					});
					
					grid.getStore().load();
				}
			},
			'studentd365dashlet #requestStatementBtn':{
				click: function(btn){
					var me = this;
					var form = btn.up('form');
					var grid = btn.up('studentd365dashlet').down('grid');
					var selectedRecord = grid.getSelectionModel().getSelection();
					
					if(selectedRecord.length){
						var fromDateFieldValue = form.down('#startDate').getValue();
						var toDateFieldValue = form.down('#tillDate').getValue();
						
						var lastYearFirstDate = new Date();
						lastYearFirstDate.setFullYear(lastYearFirstDate.getFullYear()-1);
						lastYearFirstDate.setMonth(0);
						lastYearFirstDate.setDate(1);
						
						var fromDate = (!isNullOrEmpty(fromDateFieldValue) ? fromDateFieldValue : lastYearFirstDate);
						var toDate = (!isNullOrEmpty(toDateFieldValue) ? toDateFieldValue : new Date());
						
						var convertedFromDate = getd365Date(fromDate);
						var convertedToDate = getd365Date(toDate);
						
						btn.up('studentd365dashlet').body.mask("Downloading...");
						
						Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
						Ext.Ajax.request({
							method: "POST",
							type: 'rest',
							url: SERVERURL.PATH_D365_DASHLET_STATEMENT,
							jsonData:{
								"_requestContract":
								{
									"studentNumber": selectedRecord[0].data.studentCode,// "ST10020700",
									"brandCode": selectedRecord[0].data.academyCode,//"VG",
									"campusCode": selectedRecord[0].data.locationCode,//"VGWCCT",
									"fromDate": convertedFromDate,//"2019-01-01T07:22Z",
									"toDate": convertedToDate,//"2023-01-01T07:22Z"
								}
							},
							success: function(response) {
								if(!isNullOrEmpty(response.responseText)){
									var responseText = Ext.decode(response.responseText);
									if(!isNullOrEmpty(responseText.base64Report)){
										downloadBase64File("application/pdf",responseText.base64Report,"statement_d365.pdf");
									}
									else{
										showWarningMessage(getCommonTranslation('SPD_STUDENT_D365_STATEMENT_TITLE'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
								btn.up('studentd365dashlet').body.unmask();
							},
							failure: function(){
								btn.up('studentd365dashlet').body.unmask();
							}
						});
					}
					else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			}
		});
	},
	
	loadPersonInfoDashboard : function(panel) {
		var this$= this; 
		var itemsArray = []; 
		var dashboardList=this.getDashboardForStudent();
		var getSysAdminCode = this$.getCurrentlyLoggedInUser();
		Ext.each(dashboardList, function(obj) {
			if(getSysAdminCode.code == 'sysadmin')
			{
					itemsArray.push(this$.getDashlets(obj.dashlets));
			}else{
				itemsArray.push(this$.getDashlets(obj.dashlets));
			}
				
		});
		panel.removeAll();
		panel.add(itemsArray);
	},

	getDashboardForStudent : function() {
		/*var dashboardList = [{ 
			'title':"FEE_SUMMARY",	
			'xtype':"studentprofilefeedashlet",
			'whetherCollapsed':false,
			'height':320,
			'width':450,
			'padding-left':'10px'
		},{ 
			'title':"Student Weight Progress",
			'xtype':"studentprofileprogressweightdashlet",
			'whetherCollapsed':false,
			'height':320,
			'width':450
		},{ 
			'title':"Student Height Growth",
			'xtype':"studentprofileprogressheightdashlet",
			'whetherCollapsed':false,
			'height':320,
			'width':450
		}]
		return dashboardList;*/
		
	 	var userInfo = Academia.model.authentication.UserInfoModel;
		var userId = userInfo.get('userId');
		var portalId = userInfo.get("portalId");
		
		var dashboardList =[], url=SERVERURL.USER_ACCESSIBLE_DASHLETS;
    	url = url.concat('?userId='+userId);
    	url = url.concat('&portalId='+portalId); 
    	url = url.concat('&dashboardType=STUDENT_PROFILE'); 

    	Ext.Ajax.request({
    		type : 'rest',
    		async: false,
    		method : 'GET',
    		url : url,
    		success: function(response, action) {
    			dashboardList = Ext.decode(response.responseText); 
    		}
    	});
    	return dashboardList;
	},

	getDashlets : function(object) {
		var title;
		if (object.displayCode == 'SPD_FINANCIAL_SUMMARY') {
			title = getCommonTranslation('SPD_FINANCIAL_SUMMARY_TITLE');
		} else if (object.displayCode == 'SPD_STUDENT_WEIGHT_PROGRESS') {
			title = getCommonTranslation('SPD_STUDENT_WEIGHT_PROGRESS_TITLE');
		} else if (object.displayCode == 'SPD_STUDENT_HEIGHT_GROWTH') {
			title = getCommonTranslation('SPD_STUDENT_HEIGHT_GROWTH_TITLE');
		} else if (object.displayCode == 'SPD_STUDENT_DISCIPLINARY_ACTIVITY_PROFILE') {
			title = "<span style='text-transform:none;'>"+getCommonTranslation('SPD_STUDENT_DISCIPLINARY_ACTIVITY_TITLE')+"</span>";
		} else if (object.displayCode == 'SPD_STUDENT_D365_STATEMENT') {
			title = "<span style='text-transform:none;'>"+getCommonTranslation('SPD_STUDENT_D365_STATEMENT_TITLE')+"</span>";
		}else if (object.displayCode == 'SPD_ADMISSIONID_DETAILS_DASHLET') {
			title = "<span style='text-transform:none;'>"+getCommonTranslation('SPD_ADMISSIONID_DETAILS_DASHLET_TITLE')+"</span>";
		}
		
		var dashlet= {
				'title' : title,
				'xtype':  object.xtype,
				'collapsed' :  false,
				'height' : 320,
				'width' : '48.5%',
				
		};
		if(object.activeItem){
			dashlet.activeItem =  object.activeItem
		}
		return dashlet;
	},
	
   getToolbarValues: function(tbar) {
        var values = [];
        tbar.items.each(function(obj) {
        	if((typeof obj.getValues != "undefined") && obj.submitValue!=false)
        		values.push(obj.getValues());
        });
        return values;
    },
    
	applyFilter: function(button){
		var dashletPanel = button.up('personinfodashboardhomepage');
		dashletPanel.items.each(function(c) {
			c.loadPersonInfoDashboard(button);
	    });
	}

});
