
/**
 * This controller is used for the faculty Personal information functionality.
 * Add/Edit/delete/view
 * 
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyPersonalController', {
    extend: 'Academia.controller.personinfo.common.PersonInfoController',

    alias: "widget.facultypersonalcontroller",
    mixins: { 		
    	AddressController:'Academia.controller.organization.AddressController',
    	FacultyListController : 'Academia.controller.personinfo.faculty.FacultyListController'
    },
    views: ['personinfo.faculty.FacultyProfile', 'personinfo.faculty.CreateFacultyProfile',
            'personinfo.common.PersonDetailsLinkPanel','personinfo.common.PersonInfoPanel','personinfo.common.personalinfo.EmpAdditionalDetailsForm',
            'baselayout.header.UserInfo', 'personinfo.common.PersonCommonWindow','personinfo.faculty.familydetail.FacultyFamilyDetailGrid',
            'personinfo.faculty.familydetail.FacultyFamilyDetailCardLayoutView','personinfo.faculty.familydetail.FacultyFamilyDetailCardTpl',
            'personinfo.faculty.familydetail.FacultyFamilyDetailAddMoreCardTpl','personinfo.common.personalinfo.EmpAdditionalDetailsForm',
            'Academia.view.personinfo.student.StudentUploadPhotoWindow','personinfo.common.pasthistory.QualificationDetailsWin'],
    refs: [{
        ref: 'personalInformationForm',
        selector: 'employeepersonalinformationform[itemId=facultyPersonalInformationForm]'
    }, {
        ref: 'personAddressDetails',
        selector: 'facultyaddressdetails[itemId=facultyAddressDetails]'
    }, {
        ref: 'personAddressFormWindow',
        selector: 'addressformwindow[itemId=facultyAddressWindow]'
    }, {
        ref: 'personAddressFieldsForm',
        selector: 'addressformwindow addressfieldsform[itemId=personAddressFieldsForm]'
    }, {
    	ref: 'userinfo',
        selector: 'userinfo'
    },{
        ref: 'personOtherinformationdetailsform',
        selector: 'otherinformationdetailsform[itemId=facultyOtherinformationDetailsForm]'
    },{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow[itemId=facultyPersonCommonWindow]'
    },{
        ref: 'personIdentityDetailsForm',
        selector: 'identitydetailsform[itemId=facultyIdentityDetailsForm]'
    },{
 	   ref : 'facultyIdVerificationDetailWin',
 	   selector : 'idverificationdetailwin [itemId=facultyIdVerificationDetailWinItemId]'
    }, {
        ref: 'facultyfamilydetailgrid',
        selector: 'facultyfamilydetailgrid[itemId=facultyFamilyDetailGridItemId]'
    },{
    	ref: 'facultyfamilydetailcardlayoutview',
    	selector : 'facultyfamilydetailcardlayoutview'
    }, {
    	ref: 'facultyfamilydetailcardtpl',
    	selector : 'facultyfamilydetailcardtpl'
    },{
        ref: 'facultyfamilydetailform',
        selector: 'facultyfamilydetailform[itemId=facultyFamilyDetailForm]'
    }, {
        ref: 'facultyssodetailsgrid',
        selector: 'ssodetailsgrid[itemId=facultyssodetailsgridItemId]'
    },{
    	ref:'empadditionaldetailsform',
    	selector:'empadditionaldetailsform'
    },{
    	ref:'facultyfamilydetailaddmorecardtpl',
    	selector:'facultyfamilydetailaddmorecardtpl'
    },{
		ref:'qualificationdetailsform',
		selector:'qualificationdetailsform'
    },{
		ref:'studentuploadphotowindow',
		selector:'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId]'
	},{
		ref:'qualificationdetailsgrid',
		selector:'qualificationdetailsgrid'
	},{
		ref:'qualificationdetailswin',
		selector:'qualificationdetailswin'
	}],
 config:{
	 FACULTY_PORTAL_PERSONAL_INFORMATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_PERSONAL_INFORMATION_PRIVILEGES'),
	 FACULTY_OTHER_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_OTHER_INFORMATION_PRIVILEGES'),
	 FACULTY_SSO_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_SSO_DETAILS_PRIVILEGES'),
     FACULTY_EMP_ADDITIONAL_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EMP_ADDITIONAL_DETAILS_PRIVILEGES'),
	 FACULTY_PORTAL_SSO_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_SSO_DETAILS_PRIVILEGES'),
	 EMPLOYEE_PROFILE_PERSONAL_INFORMATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_PROFILE_PERSONAL_INFORMATION_PRIVILEGES'),
	 FACULTY_PORTAL_ADDRESS_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_PERSONAL_ADDRESS_PRIVILEGES'),
	 FACULTY_IDENTITY_CARD_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_IDENTITY_CARD_PRIVILEGES'),
	 EMPLOYEE_PROFILE_ADDRESS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_PROFILE_ADDRESS_PRIVILEGES'),
	 FACULTY_PORTAL_OTHER_INFORMATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_OTHER_INFORMATION_PRIVILEGES'),
	 EMPLOYEE_PROFILE_FAMILY_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_PROFILE_FAMILY_DETAILS_PRIVILEGES'),
	 FACULTY_PORTAL_FAMILY_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_FAMILY_DETAILS_PRIVILEGES'),
	 
	 FACULTY_PORTAL_PERSONAL_DETAILS_SECTION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_PERSONAL_DETAILS_SECTION_PRIVILEGES'),
	 FACULTY_PORTAL_CONTACT_INFO_SECTION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_CONTACT_INFO_SECTION_PRIVILEGES'),
	 FACULTY_PORTAL_BANK_DETAILS_SECTION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_BANK_DETAILS_SECTION_PRIVILEGES'),
	 FACULTY_PORTAL_OTHER_DETAILS_SECTION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_OTHER_DETAILS_SECTION_PRIVILEGES'),
	 FACULTY_LIST_PROFILE_DETAIL_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_LIST_PRIVILEGES'),
	 FACULTY_LIST_QUALIFICATION_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_QUALIFICATION_DETAILS_PRIVILEGES'),
	 FACULTY_PORTAL_QUALIFICATION_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_QUALIFICATION_PRIVILEGES'),
	 
	/* 
	 FACULTY_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EDUCATION_PRIVILEGES'),
	 FACULTY_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_WORK_EXPERIENCE_PRIVILEGES'),
	 FACULTY_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MEDICAL_PRIVILEGES'),
	 FACULTY_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_VACCINATION_PRIVILEGES'),
	 FACULTY_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
	 FACULTY_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_RESEARCH_DETAILS_PRIVILEGES'),
	 FACULTY_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_SEMINAR_DETAILS_PRIVILEGES'),
	 FACULTY_PATENT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PATENT_DETAILS_PRIVILEGES'),
	 FACULTY_TRAINING_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_TRAINING_PRIVILEGES'),
	 FACULTY_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_COMPETITIVE_EXAM_PRIVILEGES')
   */
 },
    init: function(application) {
    	this.empLanguageDFR=[];
    	this.isRemovedBtnClick = false;
    	this.isUploadBtnClick = false;
    	this.suspendCityEvent=false;
        this.control({
        	/**
        	 * Faculty Profile Information
        	 * 
        	 */
        	'facultyprofile': {
                afterrender: function(){
                	this.getFacultyProfileInformation('#facultyProfileView');
                	this.getActiveMyDashboard();
//                	Profile edit button Permission
			        var associatedAcadLocationIds = new Array(); 
			        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFACULTY_LIST_PROFILE_DETAIL_PERMISSION());
			        var form = this.getContentPanelActiveTab()
			        var empIcon =form.down('#profile_image_icon');
			        empIcon.setVisible(false)
			        permissionList.forEach(function(btnName){
			            if(btnName == 'UPLOAD_IMAGE_EDIT_ICON'){
			            	empIcon.setVisible(true);
			            }
			        });
                }
            },
            'createfacultyprofile': {
                afterrender: function(){
                	this.getFacultyProfileInformation('#createFacultyProfileView');
                }
            },
            'facultyprofile panel[itemId=facultyProfileEastPanel]': {
            	afterrender: function(sidePanel){
            		var me = this,
            		storeRecords = [],
            		sidePanelSearchCombo = sidePanel.down('#facultyDetailLinkSearchComboBox'),
            		sidePanelSearchStore = sidePanelSearchCombo.getStore(),
            		sidePanelItems,
            		upperTabTitle,
            		currentDataView,
            		currentItemIndex;

            		sidePanel.up('facultyprofile').on('activate', function(){
            			setTimeout(function(){
            				sidePanelItems = sidePanel.down('persondetailslinkpanel').items.items,
            				Ext.each(sidePanelItems, function(sidePanelItem){
            					upperTabTitle = sidePanelItem.title;
            					currentDataView = sidePanelItem.down('dataview');
            					currentItemIndex = 0;

            					Ext.each(currentDataView.store.data.items, function(currentElement){
            						storeRecords.push({
            							displayPath: upperTabTitle,
            							title: getPersonModuleTranslation(currentElement.get('tabPanelTitle')),
            							parentPanelSelector: currentDataView.el.id,
            							currentElementSelector: currentDataView.itemSelector,
            							currentItemIndex: currentItemIndex,
            							searchText: getPersonModuleTranslation(currentElement.get('tabPanelTitle'))
            						});
            						currentItemIndex = currentItemIndex + 1;
            					});
            				});

            				sidePanelSearchStore.removeAll();
            				sidePanelSearchStore.add(storeRecords);
            				sidePanel.up('facultyprofile').un('activate');
            			},100);
            		},this);
            	},
            	beforecollapse:function(obj, direction, animate, eOpts){
            		try{
            			if(event.target.classList.contains('x-form-text')){
            				return false;
            			}
            		}
            		catch(e){
            			if(Ext.ComponentQuery.query('#facultyDetailLinkSearchComboBox')[0].hasFocus && Ext.ComponentQuery.query('#facultyDetailLinkSearchComboBox')[0].allowCollapse==false){
            				return false;
            			}
            		}
            	}
            },
            'persondetailslinkpanel[itemId=facultyPersonDetailsLinkPanel] dataview': {
                itemclick: function(view, record) {
                	this.addPerosnTabToFacultyProfile(view, record);
                }
            },
            
            /*'personalinformationform[itemId=facultyPersonalInformationForm] textfield[name=firstName]': {
            	change: function(firstNameField){
            		this.shortNameOnchangeOfFirstName(firstNameField,'#facultyPersonalInformationForm');
            	}
            },*/
            /**
        	 * Faculty Personal Information
        	 * 
        	 */
            'personalinformationform': {
            	afterrender:function(frm){
    				var me = this;
    				var phoneNoFldItemId = this.getActiveTabfromContentPanel().down('#phoneNoFldItemId');
    				var mobileNoFldItemId = this.getActiveTabfromContentPanel().down('#mobileNoFldItemId');
    				var lblOneContactDetail = this.getActiveTabfromContentPanel().down('#lblOneContactDetail');
    				var emailId = this.getActiveTabfromContentPanel().down('#emailId');
    				var alternateEmailId = this.getActiveTabfromContentPanel().down('#alternateEmailId');
    				var contactFieldSet = this.getActiveTabfromContentPanel().down('#contactFieldSet');
    				if(this.getActiveTabfromContentPanel().personType =='FACULTY'){
    					var employCode = frm.down('#personCodeField');
    					employCode.setFieldLabel(getPersonModuleTranslation('EMPLOYEE_ID'))
    				}
    				if(!isNullOrEmpty(phoneNoFldItemId)){
    					if(phoneNoFldItemId.isVisible() && mobileNoFldItemId.isVisible()){
    						lblOneContactDetail.setVisible(true);
    					}else{
    						lblOneContactDetail.setVisible(false);
    					}
    					if(!mobileNoFldItemId.isVisible() && !phoneNoFldItemId.isVisible() && !emailId.isVisible() && !alternateEmailId.isVisible()){
    						contactFieldSet.setVisible(false);
    					}
    					else{
    						contactFieldSet.setVisible(true);
    					}
    				}
    			}
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm]': {
                afterrender: function(){
                	this.onRenderFacultyPersonalInformationForm();
                }
            },
            
            'facultyprofile employeepersonalinformationform[itemId=employeeLanguage]': {
            	render: function(){
                	//this.onRenderFacultyPersonalInformationForm();
                	var personProfile = this.getContentPanelActiveTab();
                	var createcourseform = personProfile.down('#facultyPersonalInformationForm');
                	 var employeeLanguageField = createcourseform.down("#employeeLanguage");
                     var writeField = createcourseform.down("#writeItemId");
                     var readField = createcourseform.down("#readItemId");
                     var speakField = createcourseform.down("#speakItemId");
                     var addBtn = createcourseform.down("#stopBtn");
                    this.loadDFRForLanuageCompentcy(employeeLanguageField,writeField,readField,speakField,addBtn);

                }
            },
                       'createfacultyprofile personalinformationform[itemId=facultyPersonalInformationForm] photouploadform[itemId=facultyPhotoUploadForm] filefield[itemId=photoFileImage]': {
            	change:function(photoFileImage, value, eOpts){
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	photoFileImage.setRawValue(newValue);
                }
            },
            'createfacultyprofile personalinformationform[itemId=facultyPersonalInformationForm]': {
            	render: function(){
            		this.onRenderFacultyPersonalInformationForm();
            	}
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] combo': {
                render: function(combo) {
                    combo.getStore().load();
                }
            },
/*            'facultyprofile personalinformationform[itemId=facultyPersonalInformationForm] photouploadform[itemId=facultyPhotoUploadForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
                    this.saveFacultyPersonPhotoUpload(photoFileImage);
                }
            },
*/           /* 'createfacultyprofile personalinformationform[itemId=facultyPersonalInformationForm] photouploadform[itemId=facultyPhotoUploadForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
                    this.saveFacultyPersonPhotoUpload(photoFileImage);
                }
            },*/
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
                click: function(){
                	this.createFacultyPersonalInformation('#facultyProfileView');
                }
            },
            'createfacultyprofile personalinformationform[itemId=facultyPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
                click: function() {
                    this.createFacultyPersonalInformation('#createFacultyProfileView');
                }
            },
            'createfacultyprofile button[itemId=facultyActivateButtonId]': {
                click: function() {
                    this.activateFaculty();
                }
            },
            
            /**
        	 * Faculty Personal Information for faculty portal
        	 * 
        	 */
            'personinfofacultyportal employeepersonalinformationform[itemId=facultyPersonalInformationForm]': {
                afterrender: function(){
                	this.onRenderFacultyPersonalInformationForm();
                }
            },
            'personinfofacultyportal employeepersonalinformationform[itemId=facultyPersonalInformationForm]': {
            	afterrender: function(obj){
                	//this.doAccessControlValidation(obj, this.getFACULTY_PORTAL_PERSONAL_INFORMATION_PERMISSION());
   				 	this.disableMoreActionPivileges(obj,this.getFACULTY_PORTAL_PERSONAL_INFORMATION_PERMISSION());
            		this.onRenderFacultyPersonalInformationForm();
            		
            		this.disablePersonalInfoSectionPivileges(obj,this.getFACULTY_PORTAL_PERSONAL_DETAILS_SECTION_PERMISSION());
                	this.disableContactInfoSectionPivileges(obj,this.getFACULTY_PORTAL_CONTACT_INFO_SECTION_PERMISSION());
                	this.disableBankDetailSectionPivileges(obj,this.getFACULTY_PORTAL_BANK_DETAILS_SECTION_PERMISSION());
                	this.disableOtherDetailSectionPivileges(obj,this.getFACULTY_PORTAL_OTHER_DETAILS_SECTION_PERMISSION());
            	},
                	
            },
            'personinfofacultyportal employeepersonalinformationform[itemId=facultyPersonalInformationForm] photouploadform[itemId=facultyPhotoUploadForm] filefield[itemId=photoFileImage]': {
            	change:function(photoFileImage, value, eOpts){
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	photoFileImage.setRawValue(newValue);
                }
            },
            'personinfofacultyportal employeepersonalinformationform[itemId=facultyPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
                click: function(){
                	this.createFacultyPersonalInformation('#facultyProfileView');
                }
            },
            'personinfofacultyportal employeepersonalinformationform[itemId=facultyPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
                click: function() {
                    this.createFacultyPersonalInformation('#createFacultyProfileView');
                }
            },
            'personinfofacultyportal button[itemId=facultyActivateButtonId]': {
                click: function() {
                    this.activateFaculty();
                }
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[itemId=nationalIDItemId]': {
            	 blur : function(obj){
            		 this$ = this;
            		 var personProfile = this$.getContentPanelActiveTab();
            		 var personalInformationForm = personProfile.down('#facultyPersonalInformationForm');
            		 var newValue = Ext.ComponentQuery.query('textfield[itemId=nationalIDItemId]')[0];
            		 if(!isNullOrEmpty(newValue.value))
            		 {
            			 personalInformationForm.down("#employeeVerifyDetail").setDisabled(false);
            		 }else{
            			 personalInformationForm.down("#employeeVerifyDetail").setDisabled(true);
            		 }
            		 
            	 }
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[itemId=personCodeField]': {
                blur : function(obj){
                	var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var personalInformationForm = personProfile.down('#facultyPersonalInformationForm');
                	var oldValue = personalInformationForm.getCode();
                	var newValue = Ext.ComponentQuery.query('textfield[itemId=personCodeField]')[0];
                	if(!isNullOrEmpty(newValue)){
                		if(!isNullOrEmpty(newValue.getValue())){
	                		if(newValue.getValue()!=oldValue){
	                			var editUrl = SERVERURL.STAFF_UNIQUE_CHECK;
		                    	Ext.Ajax.request({
		                    		method: "GET",
		                    		type: 'rest',
		                    		url: editUrl,
		                    		params: {
		                    			code: newValue.getValue()
		                    		},
		                    		success: function(response, action) {
		                    			var resp = Ext.JSON.decode(response.responseText);
		                    			if(resp==false){
		                    				Ext.ComponentQuery.query('textfield[itemId=personCodeField]')[0].setValue(oldValue);
		                    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STAFF_ID_UNIQUE_ERROR_MSG'));
		                    			}
		                    		}
		                    	})
	                		}
                		}
                		else{
                			Ext.ComponentQuery.query('textfield[itemId=personCodeField]')[0].setValue(oldValue);
                			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STAFF_ID_UNIQUE_ERROR_MSG'));
                		}
                	}
                }
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] combo[itemId=departmentCombo]': {
                select : this.onSetDepartmentComboValue
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] photouploadform[itemId=facultyPhotoUploadForm] filefield[itemId=photoFileImage]': {
            	change: function(photoFileImage, value, eOpts){
            		var $this=this;
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		photoFileImage.setRawValue(newValue);
            		var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
             	    if ($this.isValidImageExtension(extension)) {
             	        var file = photoFileImage.fileInputEl.dom.files[0];
             	      
             	        if (file.size/1048576>=1) {
             	        	photoFileImage.reset();
             	            showWarningMessage(getPersonModuleTranslation('PERSONAL_DETAILS'), getCommonTranslation('FILE_SIZE_ONE_MB_ERROR_MSG'));
             	        }
             	    } else {
             	    	photoFileImage.reset();
             	        showWarningMessage(getPersonModuleTranslation('PERSONAL_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
             	    }
            	}
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[name=firstName]': {
            	change: function(firstNameField){
            		var personProfile = this.getContentPanelActiveTab();
            		var applicationStatus = personProfile.getApplicationInfo()['applicationStatus'];
            		this.shortNameOnchangeOfFirstName(firstNameField,'#facultyPersonalInformationForm',applicationStatus);
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[name=middleName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[name=lastName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[name=firstNameOtherLanguage]': {
            	change: function(firstNameField){
            		var personProfile = this.getContentPanelActiveTab();
            		var applicationStatus = personProfile.getApplicationInfo()['applicationStatus'];
            		this.shortNameOtherLnguageOnchangeOfFirstName(firstNameField,'#facultyPersonalInformationForm',applicationStatus);
            		this.setPrintNameOtherLnguageValue(firstNameField);
            	}
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[name=middleNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            'facultyprofile employeepersonalinformationform[itemId=facultyPersonalInformationForm] textfield[name=lastNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] combo[name=leaveCategory]': {
            	change: function(combo){
            		this.setLeaveCategoryValue(combo);
            	}
            },
            /**
             * Address Details
             */ 
            'facultyaddressdetails': {
                render: function(addressDetails){ 
                	var this$ = this;
                	if(this$.getCurrentLoggedPortalId() == 1 || this$.getCurrentLoggedPortalId() == 2) {
                		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                		var printPersonalAddress1 = addressDetails.down('button#printPersonalAddress1');
                		var modifyPersonalAddress1 = addressDetails.down('button#modifyPersonalAddress1');
                		var printPersonalAddress2 = addressDetails.down('button#printPersonalAddress2');
                		var modifyPersonalAddress2 = addressDetails.down('button#modifyPersonalAddress2');
                		var printPersonalAddress3 = addressDetails.down('button#printPersonalAddress3');
                		var modifyPersonalAddress3 = addressDetails.down('button#modifyPersonalAddress3');
                		var printPersonalAddress4 = addressDetails.down('button#printPersonalAddress4');
                		var modifyPersonalAddress4 = addressDetails.down('button#modifyPersonalAddress4');

                		modifyPersonalAddress1.setVisible(false);
                		modifyPersonalAddress2.setVisible(false);
                		modifyPersonalAddress3.setVisible(false);
                		modifyPersonalAddress4.setVisible(false);
                	}
                	this.getFacultyAddressDetailTemplateData();
                }
            },
            
            'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#genericFieldId1': {
                select: function(combo, record) {
                    this.onSelectionGenericField(combo, record, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#countryId': {
            	select: function(combo, record) {
            		var form = this.getPersonAddressFieldsForm();
                	var newValue=record[0].data.id;
                	this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');
                	regionComboBox.setDisabled(false);
                	this.suspendCityEvent=true;
                    this.onSelectionCountry(combo, record, this.getPersonAddressFieldsForm());
                    this.suspendCityEvent=false;
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	var phoneCountryCode = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	var pincodeId = form.down("#pincodeId");
                	pincodeId.reset();
                	pincodeId.setDisabled(true);
                	var pincodeNewId = form.down("#pincodeNewId");
                	pincodeNewId.clearValue();
                	pincodeNewId.setDisabled(true);
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);

                },
                change: function(combo, newValue) {
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');
                	if(!isNullOrEmpty(newValue)){
                		regionComboBox.setDisabled(false);	
                	}else{
                		regionComboBox.setDisabled(true);	
                	}
//                  this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                }//,
				//V2D-96112
//                change: function(combo, newValue) {
//                    this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
//                }
            },
            'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#parentCountryRegionId': {
               /* select: function(obj1, record) {
                    var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                    cityComboBox.reset();
                    cityComboBox.setDisabled(false);

                    var countryRegion1 = record[0].get("id");
//                    var store = this.getStore('organization.CountryRegionStore1');
                    var store = this.getStore('organization.CityByCountryRegion');
//                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                }*/
            },
            'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                    cityComboBox.setDisabled(false);
                    this.suspendCityEvent=true;
                    cityComboBox.reset();
                    this.suspendCityEvent=false;
                    var form = this.getPersonAddressFieldsForm();
                    var phoneCountryCode = form.down("#phoneCountryCode");
                    var phoneNoField = form.down("#phoneNoField");
                    var pincodeId = form.down("#pincodeId");
                    pincodeId.reset();
                    pincodeId.setDisabled(true);
                    var pincodeNewId = form.down("#pincodeNewId");
                    pincodeNewId.clearValue();
                    pincodeNewId.setDisabled(true);
                    this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                    var countryRegion1 = record[0].get("id");
                   	var store = cityComboBox.getStore();
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                },
                change: function(obj1, newValue) {
                	 var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                	 if(!isNullOrEmpty(newValue)){                	
                		 cityComboBox.setDisabled(false);
                	 }else{
                		 cityComboBox.setDisabled(true); 
                	 }
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#printPersonalAddress1": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField1');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#printPersonalAddress2": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField2');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#printPersonalAddress3": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField3');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#printPersonalAddress4": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField4');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress1": {
                click: function() {
                	this.onModifyClick("displayfield#personAddressDisplayField1", "#facultyAddressDetails", "facultyAddressWindow");
                	var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
               
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress2": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField2", "#facultyAddressDetails", "facultyAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
               
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress3": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField3", "#facultyAddressDetails", "facultyAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
               
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress4": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField4", "#facultyAddressDetails", "facultyAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
               
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress1": {
                click: function() {
                	this.onModifyClick("displayfield#personAddressDisplayField1", "#facultyAddressDetails", "facultyAddressWindow");
                	var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress2": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField2", "#facultyAddressDetails", "facultyAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress3": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField3", "#facultyAddressDetails", "facultyAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "facultyaddressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress4": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField4", "#facultyAddressDetails", "facultyAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            'addressformwindow[itemId=facultyAddressWindow]': {
                render: function(obj){
                	obj.down('#otherAddressTypeItemId').show();
                	this.disableAddressPivileges(obj,this.getFACULTY_PORTAL_ADDRESS_DETAILS_PERMISSION());
                }
            },
            'addressformwindow[itemId=facultyAddressWindow] button[itemId=submitButtonId]': {
                click: this.saveFacultyAddressDetails
            },
            'addressformwindow[itemId=facultyAddressWindow] button[itemId=cancelButtonId]': {
                click: function() {
                	this.getPersonAddressFormWindow().close();
                }
            },
            
            /**
             *  Identity Details
             */
            'identitydetailsgrid[itemId=facultyIdentityDetailsGrid]': {
            	render: function(grid) {
            		this.doAccessControlValidation(grid, this.getFACULTY_IDENTITY_CARD_PERMISSION());
            		//console.log(this.getFACULTY_IDENTITY_CARD_PERMISSION());
            		this.loadGridStore('#facultyIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_GRID);
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            		var searchResultGrid =  grid.ownerCt;
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
            		if(columnName=='documents'){
            			if (e.target.tagName == 'A') {
            				var documentId = record.data.documents[0].id;
            				if (!isNullOrEmpty(documentId)) {
            					this.getDocumentController().downloadDocumentFile(documentId);
            				}
            			}
            		}
            	}
            },
            'identitydetailsgrid[itemId=facultyIdentityDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		this.showPersonCommonWindow(formWindow, 'IDENTITY_DETAILS', 'facultyIdentityDetailsForm', true);
            	}
            },
            'identitydetailsgrid[itemId=facultyIdentityDetailsGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editIdentityDetailFormWindow('IDENTITY_DETAILS', 'facultyIdentityDetailsForm', '#facultyIdentityDetailsGrid');
            	}
            },
            'identitydetailsgrid[itemId=facultyIdentityDetailsGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewIdentityDetailFormWindow('IDENTITY_DETAILS', 'facultyIdentityDetailsForm', '#facultyIdentityDetailsGrid');
            		
                    var identitydetailsform = this.getPersonIdentityDetailsForm();                    
                    if(identitydetailsform != null && identitydetailsform != undefined){
                    	var identityDetailsDocId = identitydetailsform.down("#identityDetailsDocId");
                    	if(identityDetailsDocId != null && identityDetailsDocId != undefined){
                    		identityDetailsDocId.setVisible(false);
                    	}
                    }
            	}
            },
            'identitydetailsgrid[itemId=facultyIdentityDetailsGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteIdentityDetailRecord('#facultyIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=facultyIdentityDetailsForm] button[itemId=submitButtonId]': {
            	click: function(obj){
            		this.savePersonIdentity('#facultyIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_CREATE, SERVERURL.IDENTITY_DETAIL_UPDATE);
            	}
            },	
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=facultyIdentityDetailsForm] button[itemId=cancelButtonId]': {
            	click: function(obj){
            		var $this = this;
            		var form = obj.up();
            		form.up().up().close();
            	}
            },

            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=facultyIdentityDetailsForm] filefield[itemId=identityDetailsDocId]': {
            	change: function(photoFileImage, value, eOpts){
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		photoFileImage.setRawValue(newValue);
            	}
            }, 
           /* 'educationhistorygrid[itemId=facultyEducationHistoryGrid]': {
                render: function(grid) {
                	this.loadGridStore('#facultyEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA, grid);
                	this.doAccessControlValidation(grid, this.getFACULTY_EDUCATION_PERMISSIONS());
                }
            },
            'workexperiencegrid[itemId=facultyWorkExperienceGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_GRIDDATA, grid);
                    this.doAccessControlValidation(grid, this.getFACULTY_WORK_EXPERIENCE_PERMISSIONS());
                }
            },
            'researchtypegrid[itemId=facultyResearchTypeGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyResearchTypeGrid', SERVERURL.FIND_ALL_PERSON_RESEARCH,grid);
                    this.doAccessControlValidation(grid, this.getFACULTY_RESEARCH_DETAILS_PERMISSIONS());
                }
            },
            'seminardetailsgrid[itemId=facultySeminarDetailsGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultySeminarDetailsGrid', SERVERURL.FIND_ALL_PERSON_SEMINAR, grid);
                    this.doAccessControlValidation(grid, this.getFACULTY_SEMINAR_DETAILS_PERMISSIONS());
                }
            },
            'patentdetailsgrid[itemId=facultyPatentDetailsGrid] ': {
            	render: function(grid) {
            		this.loadGridStore('#facultyPatentDetailsGrid', SERVERURL.PERSON_PATENT_GRID, grid);
            		this.doAccessControlValidation(grid, this.getFACULTY_PATENT_DETAILS_PERMISSIONS());
            	}
            },
            'trainingpersondetailsgrid[itemId=facultyTrainingPersonDetailsGrid] ': {
            	render: function(grid) {
            		this.loadGridStore('#facultyTrainingPersonDetailsGrid', SERVERURL.PERSON_TRINING_GRID, grid);
            		this.doAccessControlValidation(grid, this.getFACULTY_TRAINING_DETAILS_PERMISSIONS());
            	}
            }, */
          
            /******************************** Other Information***********************************/
            'otherinformationdetailsform[itemId=facultyOtherinformationDetailsForm]': {
                render: function(form){
                	var url = SERVERURL.FIND_BY_ID_STAFF_OTHER_INFORMATION+'userId=';
                	this.onRenderOtherInformationForm(url);
                	var portalId = this.getCurrentLoggedPortalId();
                	if(portalId == 2) {
                		this.disableOtherInformaionFormPivileges(form,this.getFACULTY_PORTAL_OTHER_INFORMATION_PERMISSION());
                	}
                	else if(portalId == 1){
                		this.disableOtherInformaionFormPivileges(form,this.getFACULTY_OTHER_DETAILS_PERMISSION());
                	}
                }
            },
            'otherinformationdetailsform[itemId=facultyOtherinformationDetailsForm] button[itemId=submitButtonId]': {
                click: function(){
                	var getUrl = SERVERURL.FIND_BY_ID_STAFF_OTHER_INFORMATION+'userId=';
                	this.saveOtherInformation(SERVERURL.SAVE_STAFF_OTHER_INFORMATION,getUrl);
                }
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm]': {
                render: function(obj){
                	var portalId = this.getCurrentLoggedPortalId();
                	if(portalId == 2) {
                		this.disableMoreActionPivileges(obj,this.getFACULTY_PORTAL_PERSONAL_INFORMATION_PERMISSION());	
                	} else if(portalId == 1){
                		this.disableMoreActionPivileges(obj,this.getEMPLOYEE_PROFILE_PERSONAL_INFORMATION_PERMISSION());
                	}
                	var haveDisabilities = obj.down('#haveDisabilities');
                	var homeLanguage = obj.down('#homeLanguage');
                	var secondLanguage = obj.down('#secondLanguage');
            		var haveDisabilitiesStore = haveDisabilities.getStore();
        			haveDisabilitiesStore.getProxy().extraParams={
        				type:'HaveDisabilities'
        			};
        			var homeLanguageStore = homeLanguage.getStore();
        			homeLanguageStore.getProxy().extraParams={
        				type:'HomeLanguage'
        			};
        			var secondLanguageStore = secondLanguage.getStore();
        			secondLanguageStore.getProxy().extraParams={
        				type:'SecondLanguage'
        			};
                }
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] button[itemId=employeeVerifyDetail]': {
            	click: function(obj) {
            		//personType = obj.up().up().up().personType;
            		var $this = this;
            		var personalInformationForm = this.getPersonalInformationForm();
            		if(personalInformationForm){
            			var data = personalInformationForm.getValues()
            		}
            		var nationalId = data.nationalID;
            		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            		var Url = SERVERURL.VERIFY_NATIONAL_ID;
            		if(!isNullOrEmpty(nationalId)){
            			Ext.Ajax.request({
            				type: 'rest',
            				url: Url+'?identityNumber='+nationalId,
            				method: 'GET',
            				success : function(response, action){
            					Ext.getBody().unmask();
            					var responseData = Ext.JSON.decode(response.responseText);
								if(responseData.message!='Not Found' && responseData.citizenship!=null)
								{
            					//var getIDWindow='';
                        		//getIDWindow = $this.getFacultyIdVerificationDetailWin();
                        		//if (!getIDWindow) {
									var getIDWindow =Ext.widget('idverificationdetailwin',{
										   itemId:'facultyIdVerificationDetailWinItemId'
									   });
                        		//}
                        		getIDWindow.show();
                        		//getFormWindow = formWindow.getForm();
                    			getIDWindow.down('#userFirstName').setValue(data.firstName);
                    			getIDWindow.down('#userLastName').setValue(data.lastName);
                    			getIDWindow.down('#userGender').setValue(data.gender);
                    			getIDWindow.down('#userDOB').setValue(dateRender(data.birthDate));
            					var nationalityCombo =  personalInformationForm.down("#nationalityCombo");
            					var matched = '<span style="color:green">Matched</span>';
            					var notMatched = '<span style="color:red">Not Matched</span>';
            					            					
            					if(!isNullOrEmpty(nationalityCombo.getRawValue())){
									getIDWindow.down('#userCitizenship').setValue(nationalityCombo.getRawValue());
								}
								if(responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
								{
									getIDWindow.down('#citizenshipStatus').setValue(matched);
								}else
								{
									getIDWindow.down('#citizenshipStatus').setValue(notMatched);
								}
								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase() && responseData.surname.toUpperCase() == data.lastName.toUpperCase() &&
										responseData.gender.toUpperCase() == data.gender.toUpperCase() &&
										dateRender(responseData.dateOfBirth) == data.birthDate && responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
								{
									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('VERIFIED_NOTE'));

								}else
								{
									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('NOT_VERIFIED_NOTE'));
								}

            					getIDWindow.down('#dbFirstName').setValue(responseData.firstNames);
            					getIDWindow.down('#dbLastName').setValue(responseData.surname);
            					getIDWindow.down('#dbGender').setValue(responseData.gender);
            					getIDWindow.down('#dbDOB').setValue(dateRender(responseData.dateOfBirth));
            					getIDWindow.down('#dbCitizenship').setValue(responseData.citizenship);
            					if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase())
            					{
            						getIDWindow.down('#firstNameStatus').setValue(matched);
            					}else
            					{
            						getIDWindow.down('#firstNameStatus').setValue(notMatched);
            					}
            					if(responseData.surname.toUpperCase() == data.lastName.toUpperCase())
            					{
            						getIDWindow.down('#lastNameStatus').setValue(matched);
            					}else
            					{
            						getIDWindow.down('#lastNameStatus').setValue(notMatched);
            					}
            					if(responseData.gender.toUpperCase() == data.gender.toUpperCase())
            					{
            						getIDWindow.down('#genderStatus').setValue(matched);
            					}else
            					{
            						getIDWindow.down('#genderStatus').setValue(notMatched);
            					}
            					if(dateRender(responseData.dateOfBirth) == data.birthDate)
            					{
            						getIDWindow.down('#dobStatus').setValue(matched);
            					}else
            					{
            						getIDWindow.down('#dobStatus').setValue(notMatched);
            					}
								}else{
    								showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('GET_RECORD_NOT_FOUND'));
    							}
            				}
            			});
            		}
            	}		
            },
            'idverificationdetailwin[itemId=facultyIdVerificationDetailWinItemId] button[itemId=okBtn]':{
            	click: function(obj) {
            		var facultyIdVerifiedForm = obj.up().up();
            		facultyIdVerifiedForm.close();
            	}
            },
            'facultyfamilydetailgrid[itemId=facultyFamilyDetailGridItemId]': {
            	render: function(grid) {
            		var me = this;
                    this.loadGridStore('#facultyFamilyDetailGridItemId', SERVERURL.PATH_FIND_FAMILY_DETAIL_BY_ID);
                    
                    var itemIdPrivilegeNameArray = [{"#btnExportToPDFJasper" : "EXPORT" },{"#btnExportToExcelJasper" : "EXPORT" }];
                    if(portalId==1){
        				me.disableRadioGroupAndOtherPivileges(grid, me.getEMPLOYEE_PROFILE_FAMILY_DETAILS_PERMISSION(), itemIdPrivilegeNameArray);
        			} else if(portalId==2){
        				me.disableRadioGroupAndOtherPivileges(grid, me.getFACULTY_PORTAL_FAMILY_DETAILS_PERMISSION(), itemIdPrivilegeNameArray);
        			}
                    

                    //-- New Card Layout for Parent Guardian Screen
                    var gridStore = grid.getStore();
                    var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
            		myMask.show();
                    
                	var relationShipStore = Ext.getStore('common.FacultyFamilyRelationshipStore');
                	relationShipStore.clearFilter(true);
                	
            		gridStore.on('load', function(){
        				var facultyfamilydetailcardlayoutview = me.getContentPanel().getActiveTab().down('facultyfamilydetailcardlayoutview');
        				
        				var relationshipCheck=true;
            			/*if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
            				var relationshipCheck=true;
            				//Remove Local Guardian for Velocity V2D-41695
            				relationShipStore.load({
            					callback: function(records, operation, success) {
            	    			   for(var i=0; i< relationShipStore.data.items.length;i++){
            	    				   if(relationShipStore.data.items[i].data.name == 'LOCAL_GUARDIAN'){
            	    					   relationShipStore.removeAt(i);
            	    				   } 
            	    			   }
            					}
            	    		   });
            			}
            			else{
            				var relationshipCheck=false;
            			}*/
            			var relationShipData = relationShipStore.data.items;
            			var relationShipName = '';
            			
            			if(Ext.isDefined(facultyfamilydetailcardlayoutview)){
            				facultyfamilydetailcardlayoutview.removeAll();
            				
                			Ext.each(relationShipData, function(currentRelationShipData){
                				gridStore.clearFilter();
                				var currentRelation = '';
                				var cardDataIndex = gridStore.find('relationship',currentRelationShipData.get('name'));
                				if(cardDataIndex>=0){
                					var isEmergencyContact = gridStore.getAt(cardDataIndex).data.isEmergencyContact;
                				}
                				if(cardDataIndex<0){
                					var panelItemsHidden = true;
                				}
                				else{
                					var panelItemsHidden = false;
                				}

                				if(relationshipCheck){
                					if(currentRelationShipData.get('name')=='FATHER'){
                						var currentRelation = getPersonModuleTranslation('FATHER');
                					}else if(currentRelationShipData.get('name') == 'MOTHER'){
                						var currentRelation = getPersonModuleTranslation('MOTHER');
                					}else if(currentRelationShipData.get('name') == 'SPOUSE'){
                						var currentRelation = getPersonModuleTranslation('SPOUSE');
                					}
                					else if(currentRelationShipData.get('name') == 'CHILD'){
                						var currentRelation = getPersonModuleTranslation('CHILD');
                					}
                					relationShipName = currentRelationShipData.get('name');
                				}else{
                					var currentRelation = getPersonModuleTranslation(currentRelationShipData.get('value'));
                					relationShipName = currentRelationShipData.get('name');
                				}
                				var emergencyContact =''

                					if(isEmergencyContact == true){
                						emergencyContact = '<div align="right" class="emergencyContactIcon"></div>';	
                					}else{
                						emergencyContact ='';
                					}
                				
                				if(currentRelationShipData.get('name')=='FATHER' || currentRelationShipData.get('name')=='MOTHER' || currentRelationShipData.get('name')=='SPOUSE'){
                					facultyfamilydetailcardlayoutview.add({
                    					xtype: 'facultyfamilydetailcardtpl',
                    					title: '<div style="display:inline-block;float: left;height:22px">'+currentRelation + ' Details</div>'+emergencyContact,
                    					isPanelBlank: panelItemsHidden,
                    					storeDataIndex: cardDataIndex,
                    					relationshipName:relationShipName
                    				});
                				}
                				else if(currentRelationShipData.get('name') == 'CHILD'){
                					gridStore.filter('relationship',currentRelationShipData.get('name'));
                					var storeLength = gridStore.data.length;
                					if(storeLength>0){
                						var arr = [];
                						var index = 0;
                						gridStore.each(function(rec) {
                							var isEmergencyContact = rec.data.isEmergencyContact;
                							var emergencyContact =''
                							if(isEmergencyContact == true){
                        						emergencyContact = '<div align="right" class="emergencyContactIcon"></div>';	
                        					}else{
                        						emergencyContact ='';
                        					}
                							index = index + 1;
                							facultyfamilydetailcardlayoutview.add({
                            					xtype: 'facultyfamilydetailcardtpl',
                            					title: '<div style="display:inline-block;float: left;height:22px"> ' + getPersonModuleTranslation('CHILD')+ ' ' + index + '</div>'+emergencyContact,
                            					isPanelBlank: panelItemsHidden,
                            					storeDataIndex: rec.index,
                            					relationshipName:relationShipName
                            				});
                		    			});
                					}
                					else if(storeLength == 0){
                						var index = 1;
                						facultyfamilydetailcardlayoutview.add({
                        					xtype: 'facultyfamilydetailcardtpl',
                        					title: '<div style="display:inline-block;float: left;height:22px"> ' + getPersonModuleTranslation('CHILD')+ ' ' + index + '</div>'+emergencyContact,
                        					isPanelBlank: panelItemsHidden,
                        					storeDataIndex: index,
                        					relationshipName:relationShipName
                        				});
                					}
                				}
                			});
                			facultyfamilydetailcardlayoutview.add({
       						   xtype: 'facultyfamilydetailaddmorecardtpl',
       						   title: '<div style="display:inline-block;float: left;height:22px">'+getPersonModuleTranslation('ADD_CHILD_DETAILS')+'</div>',
       						   //isPanelBlank: panelItemsHidden,
       					   });
            			}
            			if(gridStore.data.length >= 5){
            				me.getFacultyfamilydetailaddmorecardtpl() && me.getFacultyfamilydetailaddmorecardtpl().hide();
            			}
            			myMask.hide();
                    });
                }
            },
            'facultyfamilydetailgrid[itemId=facultyFamilyDetailGridItemId] splitbutton[itemId=btnExportToPDFJasper] #exportPDFCurrentPage':{
            	click : function(grid) {
            		this.exportPDFFacultyFamilyDetailReport();
            	}
            },
            'facultyfamilydetailgrid[itemId=facultyFamilyDetailGridItemId] splitbutton[itemId=btnExportToExcelJasper] #exportExcelCurrentPage':{
            	click : function() {
            		this.exportXLFacultyFamilyDetailReport();
            	}
            },
            'facultyfamilydetailcardtpl':{
            	afterrender: function(currentTpl){
            		var me = this;
            		
                	var editBtn = currentTpl.down('[itemId=edit_PG_ItemId]');
            		var deleteBtn = currentTpl.down('[itemId=delete_PG_ItemId]');
            		
            		if(currentTpl.isPanelBlank){ //-- showing only add button in card tpl if record for relation is not available
            			currentTpl.down('[cls=pgCardLayoutUprPnl]').removeAll();
            			currentTpl.down('[cls=pgCardLayoutUprPnl]').el.dom.innerHTML = 'Details not added';
            			currentTpl.down('[cls=pgCardLayoutUprPnl]').el.dom.style.height = '30px !important';
            			currentTpl.down('[cls=pgCardLayoutBtnPnl]').el.dom.style.top = '30px !important';
            			
            			currentTpl.down('[itemId=edit_PG_ItemId]').hide();
            			currentTpl.down('[itemId=view_PG_ItemId]').hide();
            			currentTpl.down('[itemId=delete_PG_ItemId]').hide();
            			var itemIdPrivilegeNameArray = [{"#addDetails_PG_ItemId" : "CREATE" }];
            			if(portalId==1){
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getEMPLOYEE_PROFILE_FAMILY_DETAILS_PERMISSION(), itemIdPrivilegeNameArray);
            			} else if(portalId==2){
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getFACULTY_PORTAL_FAMILY_DETAILS_PERMISSION(), itemIdPrivilegeNameArray);
            			}
            		}
            		else {
            			try{
                        	var gridStore = me.getContentPanel().getActiveTab().down('facultyfamilydetailgrid').getStore();
                    	}
                    	catch(e){
                        	var gridStore = me.getFacultyfamilydetailgrid().getStore();                    		
                    	}
                    	gridStore.clearFilter();
            			var currentData = gridStore.getAt(currentTpl.storeDataIndex);
            			if(currentData){
            			
            			var firstName = "";
            			var lastName = "";
            			var salutation = "";
            			var middleName = "";
            			
            			if(!isNullOrEmpty(currentData.get('firstName'))){
            				firstName =  currentData.get('firstName');
            			}
            			if(!isNullOrEmpty(currentData.get('lastName'))){
            				lastName =  currentData.get('lastName');
            			}
            			if(!isNullOrEmpty(currentData.get('salutation'))){
            				salutation =  currentData.get('salutation').value;
            			}
            			if(!isNullOrEmpty(currentData.get('middleName'))){
            				middleName =  currentData.get('middleName');
            			}
            			
            			var currentPGName = salutation + " "+firstName + " "+lastName ;
            			if(!isNullOrEmpty(middleName)){
            				currentPGName = salutation + " " + firstName + " " + middleName + " " + lastName ;
            			}
            			
            			//var currentPGUserCode = currentData.get('parentUserCode');
            			
            			if(!isNullOrEmpty(currentData.get('middleName'))){
            				middleName =  currentData.get('middleName');
            			}
            			
            			var currentPGEmailId = currentData.get('emailId');
            			var currentPGMobileNo = currentData.get('mobileNumber');
            			var mobileCountryCode = currentData.get('mobileCountryCode');
            			var mobileNumberWithCode = currentData.get('mobileNumber');
            			if(!isNullOrEmpty(mobileCountryCode) && !isNullOrEmpty(currentPGMobileNo)){
            				mobileNumberWithCode = mobileCountryCode + '-'+currentPGMobileNo;
            			}
            			else if(!isNullOrEmpty(mobileCountryCode)){
            				mobileNumberWithCode = mobileCountryCode;
            			}
            			else if(!isNullOrEmpty(currentPGMobileNo)){
            				mobileNumberWithCode = currentPGMobileNo;
            			}
            			
            			currentTpl.down('[name=pgNameField]').setValue(currentPGName);
            			currentTpl.down('[name=pgEmailField]').setValue(currentPGEmailId);
            			currentTpl.down('[name=pgMobileNoField]').setValue(mobileNumberWithCode);
            			
            			if(portalId==1){
            				var itemIdPrivilegeNameArray = [{"#delete_PG_ItemId" : "DELETE" },{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#addDetails_PG_ItemId" : "CREATE" }];
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getEMPLOYEE_PROFILE_FAMILY_DETAILS_PERMISSION(), itemIdPrivilegeNameArray);
            			} else if(portalId==2){
            				var itemIdPrivilegeNameArray = [{"#delete_PG_ItemId" : "DELETE" },{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#addDetails_PG_ItemId" : "CREATE" }];
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getFACULTY_PORTAL_FAMILY_DETAILS_PERMISSION(), itemIdPrivilegeNameArray);
            			}
            			
            			
            			//--setting userphoto on card tpl
            			if(!isNullOrEmpty(currentData.get('photoUrl')) && currentData.get('photoUrl') !=0){
            				var extensionArr = currentData.get('photoUrl').split(".");
                    		var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
                    		currentTpl.down('image').setSrc(imageUrl);
            			}
            			
            			currentTpl.down('[itemId=addDetails_PG_ItemId]').hide();
            		}
            		}
            		currentTpl.doLayout();
            	}
            },
            'facultyfamilydetailcardtpl button[itemId=addDetails_PG_ItemId]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		localStorage.setItem('parentDataURL','');
            		var formWindow = this.showPersonCommonWindow(formWindow, 'FACULTY_FAMILY_DETAIL', 'facultyFamilyDetailForm',true);
            		if( formWindow != null ){
            			var form = formWindow.down('#facultyFamilyDetailForm');
            			
                		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#mobileCountryCode");
                        var mobileField = form.down("#cellNo");
                        this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                        countryCodeField = form.down("#alternateMobileCountryCode");
                        mobileField = form.down("#alternateMobileNo");
                        this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                        countryCodeField = form.down("#phoneCountryCode");
                        var phoneNoField = form.down("#phoneNoField");
                        this$.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
                   
            		    
            		    // By Default Set bellow checkboxes as checked
            		    var isMobileAvalaibleForCommunicationField = form.down('#isMobUseForCommunicationField');
            		    var isPhoneAvalaibleForCommunicationField = form.down('#isPhoneUseForCommunicationField');
            		    var isAlternateMobileAvalaibleForCommunicationField = form.down('#isAlternateMobUseForCommunicationField');
            		    
            		    if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
            		    	isMobileAvalaibleForCommunicationField.setValue(true);
            		    }
            		    if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
            		    	isPhoneAvalaibleForCommunicationField.setValue(true);
            		    }
            		    if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
            		    	isAlternateMobileAvalaibleForCommunicationField.setValue(true);
            		    }
            		}
                }
            },
            'facultyfamilydetailcardtpl button[itemId=edit_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
            		var formItemId = 'facultyFamilyDetailForm';
            		var relatedPersonUrl = SERVERURL.PATH_FIND_EMPLOYEE_FAMILY_DETAIL_BY_ID;
                    var personProfile = this$.getContentPanelActiveTab();
                    
            		localStorage.setItem('parentDataURL','');
            		
            		var formWindow = this$.getPersonCommonWindow();
                	this.showPersonCommonWindow(formWindow, 'FACULTY_FAMILY_DETAIL', formItemId);
                	var form = this$.getFacultyfamilydetailform();
                	
                	try{
                		var grid = this$.getContentPanel().getActiveTab().down('facultyfamilydetailgrid');
                	}
                	catch(e){
                		var grid = this$.getFacultyfamilydetailgrid();
                	}
                	var gridStore = grid.getStore();
                	gridStore.clearFilter();
        			var records = gridStore.getAt(btn.up('facultyfamilydetailcardtpl').storeDataIndex);
        			
                    if (!isEmpty(records)) {
                        var id = records.get("id");
                        var params = {
                            id: id
                        };
                        this$.sendGetAjaxRequest(relatedPersonUrl, 'GET', params, function(option, success, response) {
                        	if(success){
                        		var data = Ext.decode(response.responseText);
                                if (!isEmpty(data)) {
                                	data.isEmployeeOfOrganization = data.whetherUserOfOrganization;
                                	data.externalEmployeeId = data.familyDetailCode;
                                	if(data.isEmployeeOfOrganization){
                                		form.config.personId = data.person.id;
                                	}
                                	if(!isNullOrEmpty(data.birthDate)){
                                		data.birthDate = new Date(data.birthDate);
                                	}
                                	form.getForm().setValues(data);
                                	
                                	if(!isNullOrEmpty(data.genderCSMWS)){
                                		var genderCombo = form.down('#genderCombo');
                                		genderCombo.getStore().load({
                                			callback:function(){
                                				genderCombo.setValue(data.genderCSMWS.id);
                                			}
                                		});
                                	}
                                	var mobileCountryCode = form.down('#mobileCountryCode');
                                	mobileCountryCode.getStore().load({
                                		callback:function(){
                                			mobileCountryCode.setValue(data.mobileCountryCode);
                                		}
                                	});
                                	
                                	var phoneCountryCode = form.down('#phoneCountryCode');
                                	phoneCountryCode.getStore().load({
                                		callback:function(){
                                			phoneCountryCode.setValue(data.phoneCountryCode);
                                		}
                                	});
                                	
                                	var alternateMobileCountryCode = form.down('#alternateMobileCountryCode');
                                	alternateMobileCountryCode.getStore().load({
                                		callback:function(){
                                			alternateMobileCountryCode.setValue(data.alternateMobileCountryCode);
                                		}
                                	});
                                	
                            		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
                            		this$.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                            		var countryCodeField = form.down("#mobileCountryCode");
                                    var mobileField = form.down("#cellNo");
                                    this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                                    countryCodeField = form.down("#alternateMobileCountryCode");
                                    mobileField = form.down("#alternateMobileNo");
                                    this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                                    countryCodeField = form.down("#phoneCountryCode");
                                    var phoneNoField = form.down("#phoneNoField");
                                    this$.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
                               
                                }
                        	}
                        });
                    } 
                	return formWindow;
            	}
            },
            'facultyfamilydetailcardtpl button[itemId=view_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
                	localStorage.setItem('parentDataURL','');
                	
                	var gridItemId = '#facultyFamilyDetailGridItemId';
                	var formItemId = 'facultyFamilyDetailForm';
                	var relatedPersonUrl = SERVERURL.PATH_FIND_EMPLOYEE_FAMILY_DETAIL_BY_ID;
                	
                    var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down(gridItemId);
                    var formWindow = this$.getPersonCommonWindow();
                    this.showPersonCommonWindow(formWindow, 'FACULTY_FAMILY_DETAIL', formItemId);
                    var form = this$.getFacultyfamilydetailform();
                    
                    var gridStore = grid.getStore();
                    gridStore.clearFilter();
        			var records = gridStore.getAt(btn.up('facultyfamilydetailcardtpl').storeDataIndex);
        			
                    if (!isEmpty(records)) {
                        var id = records.get("id");
                        var params = {
                            id: id
                        };
                        this$.sendGetAjaxRequest(relatedPersonUrl, 'GET', params, function(option, success, response) {
                        	if(success){
                        		var data = Ext.decode(response.responseText);
                                if (!isEmpty(data)) {
                                	
                                	if(!isNullOrEmpty(data.birthDate)){
                                		data.birthDate = new Date(data.birthDate);
                                	}
                                	
                                	data.isEmployeeOfOrganization = data.whetherUserOfOrganization;
                                	data.externalEmployeeId = data.familyDetailCode;
                                	if(data.isEmployeeOfOrganization){
                                		form.config.personId = data.person.id;
                                	}
                                	
                                	form.getForm().setValues(data);
                                	
                                	if(!isNullOrEmpty(data.genderCSMWS)){
                                		var genderCombo = form.down('#genderCombo');
                                		genderCombo.getStore().load({
                                			callback:function(){
                                				genderCombo.setValue(data.genderCSMWS.id);
                                			}
                                		});
                                	}
                                	
                                	var mobileCountryCode = form.down('#mobileCountryCode');
                                	mobileCountryCode.getStore().load({
                                		callback:function(){
                                			mobileCountryCode.setValue(data.mobileCountryCode);
                                		}
                                	});
                                	
                                	var phoneCountryCode = form.down('#phoneCountryCode');
                                	phoneCountryCode.getStore().load({
                                		callback:function(){
                                			phoneCountryCode.setValue(data.phoneCountryCode);
                                		}
                                	});
                                	
                                	var alternateMobileCountryCode = form.down('#alternateMobileCountryCode');
                                	alternateMobileCountryCode.getStore().load({
                                		callback:function(){
                                			alternateMobileCountryCode.setValue(data.alternateMobileCountryCode);
                                		}
                                	});
                                    
                            		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
                            		this$.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                            		var countryCodeField = form.down("#mobileCountryCode");
                                    var mobileField = form.down("#cellNo");
                                    this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                                    countryCodeField = form.down("#alternateMobileCountryCode");
                                    mobileField = form.down("#alternateMobileNo");
                                    this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                                    countryCodeField = form.down("#phoneCountryCode");
                                    var phoneNoField = form.down("#phoneNoField");
                                    this$.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
                               
                                }
                        	}
                        });
                    }    
                    
                    if (this$.getFacultyfamilydetailform()) {
                    	this$.getFacultyfamilydetailform().down('#submitButtonId').setVisible(false);
            	        toggleReadOnlyFormItems(this$.getFacultyfamilydetailform().getForm(), true);
            	    }
                    
                    setTimeout(function(){
                		var facultyFamilyDetailForm = this$.getFacultyfamilydetailform();
                		facultyFamilyDetailForm.down('#photoFileImageParent').setDisabled(true);
                		facultyFamilyDetailForm.down('#searchButtonId').setDisabled(true);
                		facultyFamilyDetailForm.down('button[itemId=snapshotCaptureBtnItemId]').setDisabled(true);
                	},300);
            	}
            },
            'facultyfamilydetailcardtpl button[itemId=delete_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
            		var gridItemId = '#facultyFamilyDetailGridItemId';
            		var deleteUrl = SERVERURL.PATH_EMPLOYEE_FAMILY_DETAIL_DELETE;
            		
            		var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down(gridItemId);
                    var gridStore = grid.getStore();
                    gridStore.clearFilter();
                    showConfirmMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(mbtn, text) {
                        if (mbtn == 'yes') {
                        	var records = gridStore.getAt(btn.up('facultyfamilydetailcardtpl').storeDataIndex);
                        	var id = records.get("id");
                        	deleteUrl = SERVERURL.PATH_EMPLOYEE_FAMILY_DETAIL_DELETE+'?id='+ id,
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().load({
    									callback: function(recorrds){
    										if(recorrds.length >= 5){
    											this$.getFacultyfamilydetailaddmorecardtpl() && this$.getFacultyfamilydetailaddmorecardtpl().hide();
    										}else{
    											this$.getFacultyfamilydetailaddmorecardtpl() &&  this$.getFacultyfamilydetailaddmorecardtpl().show();
    										}
    									}
    								});
                                    showSuccessMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('FAMILY_DETAILS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    });
            	}
            },
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform[itemId=facultyFamilyDetailForm] customcombobox[itemId=yearItemId]':{
            	render : function(cmb){
            		var records= new Array ();
            		var currentYear = Ext.Date.format(new Date(), 'Y');
            		for(var num = currentYear ;num >=1950; num--){
            			records.push({
            				value: num,
            				id : num.toString()
            			});
            		}
            		var store = cmb.getStore();
            		store.loadData(records);
            	}
        	},
        	
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform[itemId=facultyFamilyDetailForm] checkboxfield[itemId=isEmployeeOrganisation]': {
                change: function(employeeOrg, checkValue, oldValue, eOpts) {
                	var facultyFamilyDetailForm = this.getFacultyfamilydetailform();
                    this.onChangeEmployeeOrgField(facultyFamilyDetailForm, checkValue);
                }
            },
            'facultyfamilydetailform[itemId=facultyFamilyDetailForm] button[itemId=submitButtonId]': {
            	click: function(){
            		var formWindow = this.getFacultyfamilydetailform().up('window');
                	this.saveFacultyFamilyDetails(formWindow,'FACULTY', '#facultyFamilyDetailGridItemId', SERVERURL.PATH_EMPLOYEE_FAMILY_DETAIL_CREATE, SERVERURL.PATH_EMPLOYEE_FAMILY_DETAIL_UPDATE); 
                }
            },
            'facultyfamilydetailform[itemId=facultyFamilyDetailForm] button[itemId=cancelButtonId]': {
            	//click: this.closePersonCommonWindow
            	click:function(){
            		var win = this.getFacultyfamilydetailform().up('window');
            	    win.close();
            	}
            },
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform[itemId=facultyFamilyDetailForm] button[itemId=searchButtonId]': {
            	click: function(){
                	var facultyFamilyDetailForm = this.getFacultyfamilydetailform();
                	this.validateEmployeeOrgIdFamilyDetail(facultyFamilyDetailForm);
                }
            },
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform[itemId=facultyFamilyDetailForm] combo[itemId=relationShipField]': {
            	select : function(combo, record) {
            		var facultyFamilyDetailForm = this.getFacultyfamilydetailform();
            		this.onSelectEmployeeFamilyRelationshipComboValue(combo, '#facultyFamilyDetailGridItemId', facultyFamilyDetailForm);
            	}
            },
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform[itemId=facultyFamilyDetailForm] numberfield[itemId=yearOfExperience]': {
            	keyup : function(field, e, eOpts ) {
            		var val = field.getValue();
            		if(!isNullOrEmpty(val)){
            			val = val.toString();
            			var txtLength = val.length;
                		if(txtLength>2){
                			if(val.lastIndexOf('.') == -1){
                				if(txtLength == 4){
                					var newVal = val.substr(0, txtLength - 2);
                    				field.setValue(newVal);
                    				return;
                				}
                				else{
                					var newVal = val.substr(0, txtLength - 1);
                    				field.setValue(newVal);
                    				return;	
                				}
                			}
                			else if(val.lastIndexOf('.') == 3){
                				var newVal = val.substr(0, txtLength - 2);
                				field.setValue(newVal);
                				return;
                			}
                		}
            		}
            	}
            },
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform[itemId=facultyFamilyDetailForm] filefield[itemId=photoFileImageParent]': {
            	change: function(fileField, value, eOpts){
            		var $this = this;
            		value = value.replace('C:\\fakepath\\', '');
            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            		fileField.setRawValue(newValue);
            		if (!isNullOrEmpty(newValue)) {
            			localStorage.setItem('parentDataURL','');
            			var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
            			if ($this.isValidImageExtension(extension)) {
            				var file = fileField.fileInputEl.dom.files[0];
            				if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
            					fileField.reset();
            					showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
            				}
            			} else {
            				fileField.reset();
            				showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
            			}
            		}
            	}
            },
            'personcommonwindow[itemId=facultyPersonCommonWindow] facultyfamilydetailform combo[itemId=phoneCountryCode]': {
            	select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,record);
                }
            },
            'facultyfamilydetailaddmorecardtpl button[itemId=addDetails_FP_ItemId]': {
                click: function() {
                	var $this = this;
                	var gridItemId = '#facultyFamilyDetailGridItemId';
                	var personProfile = $this.getContentPanelActiveTab();
                	var grid = personProfile.down(gridItemId);
                	var gridStore = grid.getStore();
                    gridStore.clearFilter();
                    var record = gridStore.findRecord('relationship', 'CHILD');
                    if(!isEmpty(record)){
                    	var arr = [];
                    	gridStore.each(function(rec) {
                    		if(rec.data.relationship == "CHILD") {
                    			arr.push(rec);
                    		}
                    	});
                    	if(arr.length>4){
                    		showWarningMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('RELATIONSHIP_ALREADY_EXIST'));
                    		return;
                    	}
                    	else{
                    		var formWindow = this.getPersonCommonWindow();
                    		var formWindowSpecific = this.showPersonCommonWindow(formWindow, 'FACULTY_FAMILY_DETAIL', 'facultyFamilyDetailForm', true);
                    		//this.setDefaultCountryCodeStudent();
                    		if( formWindowSpecific != null ){
                    			var form = formWindowSpecific.down('#facultyFamilyDetailForm');
                    			var relationShipField = form.down('#relationShipField');
                    			relationShipField.setValue('CHILD');
                    			relationShipField.setReadOnly(true);
                    			
                    			// By Default Set bellow checkboxes as checked
                    		    var isMobileAvalaibleForCommunicationField = form.down('#isMobUseForCommunicationField');
                    		    var isPhoneAvalaibleForCommunicationField = form.down('#isPhoneUseForCommunicationField');
                    		    var isAlternateMobileAvalaibleForCommunicationField = form.down('#isAlternateMobUseForCommunicationField');
                    		    
                    		    if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
                    		    	isMobileAvalaibleForCommunicationField.setValue(true);
                    		    }
                    		    if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
                    		    	isPhoneAvalaibleForCommunicationField.setValue(true);
                    		    }
                    		    if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
                    		    	isAlternateMobileAvalaibleForCommunicationField.setValue(true);
                    		    }
                    		    
                    			var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
                    			this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                    		     var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                             	var mobileField = form.down("#homeTelephoneItemId");
                             	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                             	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                             	mobileField = form.down("#workTelephoneItemId");
                             	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                             	countryCodeField = form.down("#countryCodeItemId");
                             	mobileField = form.down("#mobileNumberItemId");
                             	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                             	countryCodeField = form.down("#phoneCountryCode");
                                var phoneNoField = form.down("#phoneNoField");
                                this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
                     		
                    			
                    		}
                    	}
                    }
                    else{
                    	var formWindow = this.getPersonCommonWindow();
                    	var formWindowSpecific = this.showPersonCommonWindow(formWindow, 'FACULTY_FAMILY_DETAIL', 'facultyFamilyDetailForm', true);
                    	//this.setDefaultCountryCodeStudent();
                    	if( formWindowSpecific != null ){
                    		var form = formWindowSpecific.down('#facultyFamilyDetailForm');
                    		var relationShipField = form.down('#relationShipField');
                			relationShipField.setValue('CHILD');
                			relationShipField.setReadOnly(true);
                			
                			// By Default Set bellow checkboxes as checked
                		    var isMobileAvalaibleForCommunicationField = form.down('#isMobUseForCommunicationField');
                		    var isPhoneAvalaibleForCommunicationField = form.down('#isPhoneUseForCommunicationField');
                		    var isAlternateMobileAvalaibleForCommunicationField = form.down('#isAlternateMobUseForCommunicationField');
                		    
                		    if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
                		    	isMobileAvalaibleForCommunicationField.setValue(true);
                		    }
                		    if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
                		    	isPhoneAvalaibleForCommunicationField.setValue(true);
                		    }
                		    if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
                		    	isAlternateMobileAvalaibleForCommunicationField.setValue(true);
                		    }
                    		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
                    		this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                    		 var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                          	var mobileField = form.down("#homeTelephoneItemId");
                          	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                          	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                          	mobileField = form.down("#workTelephoneItemId");
                          	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                          	countryCodeField = form.down("#countryCodeItemId");
                          	mobileField = form.down("#mobileNumberItemId");
                          	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                          	countryCodeField = form.down("#phoneCountryCode");
                            var phoneNoField = form.down("#phoneNoField");
                            this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
                  		
                    	}
                    }
                    
                }
            }, 
           
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#countryId': {
                select: function(combo, record) {
                	var newValue = record[0].data.id;
                	this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                    this.onSelectionCountry(combo, record, this.getPersonAddressFieldsForm());
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	var countryCodeField = form.down("#phoneCountryCode");
                    var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
                } },
                'employeepersonalinformationform[itemId=facultyPersonalInformationForm] button[itemId=stopBtn]': {
                	click: function(obj){
        				this.addMultipleLanguageForFacultyProfile(obj);
        			}          
                },
                
                'employeepersonalinformationform[itemId=facultyPersonalInformationForm] [itemId=employeeLanguage]': {
                	select: function(combo, record) {
                    	var newValue = record[0].data.id;
                    	var personProfile = this.getContentPanelActiveTab();
                		if(personProfile) {
    	            		var form = personProfile.down('employeepersonalinformationform');
                        	this.onSelectionLanguage(combo, record,form);
                		}
                	}               
                },
                'employeepersonalinformationform[itemId=facultyPersonalInformationForm] customcombobox[itemId=cellCountryCode]': {
    			select: function(rowModel, record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var form = personProfile.down('#facultyPersonalInformationForm');
                	var countryCodeField = form.down("#cellCountryCode");
                 	var mobileField = form.down("#mobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    			
                 	var countryCodeField = form.down("#alternateCellCountryCode");
                 	var mobileField = form.down("#alternateMobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    			}
    		},
    		'employeepersonalinformationform[itemId=facultyPersonalInformationForm] customcombobox[itemId=phoneCountryCode]': {
    			select: function(rowModel, record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var form = personProfile.down('#facultyPersonalInformationForm');
                	var countryCodeField = form.down("#phoneCountryCode");
                    var phoneNoField = form.down("#phoneNoField");
                    this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
    			}
    		},
    		'employeepersonalinformationform[itemId=facultyPersonalInformationForm] numberfield[itemId=mobileNumber]': {
    			change: function(record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var form = personProfile.down('#facultyPersonalInformationForm');
                    var mobileField = form.down("#mobileNumber");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
    		},
        
        'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#cellCountryCode': {
            select: function(rowModel, record) {
            	var form = this.getPersonAddressFieldsForm();
            	var countryCodeField = form.down("#cellCountryCode");
            	var mobileField = form.down("#cellNo");
            	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
            }
        },
        'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#cityId':{
        	select: function(obj1, record) {
        		var me = this;
        		var city = record[0].get("id");
        		var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
        		Ext.Ajax.request({
        			type: 'rest',
        			url: getPinCodeUrl1,
        			method: 'GET',
        			headers: {
        				'Content-Type': 'application/json'
        			},
        			params: {
        				id: city
        			},
        			success: function(res, action) {
        				var data = res.responseText;
        				var response = obj1.up('form').addressDfrResponse;
        				if(!isNullOrEmpty(data) && data !="[]"){
        					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
        					obj1.up('form').down('textfield#pincodeId').setVisible(false);
        					obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
        					setTimeout(function(){
                    			obj1.up('form').down('customcombobox#pincodeNewId').reset();
                        		obj1.up('form').down('customcombobox#pincodeNewId').clearValue();
                        	},100);
        					var form = me.getPersonAddressFieldsForm();
        					var phoneCountryCode = form.down("#phoneCountryCode");
        					var phoneNoField = form.down("#phoneNoField");
        					me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
        					var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
        					store.getProxy().extraParams = {
        						id: city
        					};
        					store.reload();
        					me.getDfrDataForPinCodes(form,'dropdownPincode');
        				}else{
        					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
        					obj1.up('form').down('textfield#pincodeId').setVisible(true);
        					obj1.up('form').down('textfield#pincodeId').setDisabled(false);
        					obj1.up('form').down('textfield#pincodeId').reset();
        					var form = me.getPersonAddressFieldsForm();
        					var phoneCountryCode = form.down("#phoneCountryCode");
        					var phoneNoField = form.down("#phoneNoField");
        					me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
        					me.getDfrDataForPinCodes(form,'pincode');
        				}
        			}
        		});
        		/*var pincodeNewComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
        		pincodeNewComboBox.setDisabled(false);
        		pincodeNewComboBox.reset();
        		var form = this.getPersonAddressFieldsForm();
        		var phoneCountryCode = form.down("#phoneCountryCode");
        		var phoneNoField = form.down("#phoneNoField");
        		this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
        		var city = record[0].get("id");
        		var store = pincodeNewComboBox.getStore();
        		store.getProxy().extraParams = {
        			id: city
        		};
        		store.reload();*/
        	},
            change: function(obj1, newValue) {
            	var me = this;
            	if(!this.suspendCityEvent){
            		var cityPinCodeTextBox = obj1.up('form').down('textfield#pincodeId');
            		var cityPinCodeComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
            		if(!isNullOrEmpty(newValue)){                	
            			cityPinCodeComboBox.setDisabled(false);
            			cityPinCodeTextBox.setDisabled(false);
            		}else{
            			cityPinCodeTextBox.setDisabled(true);
            			cityPinCodeTextBox.reset();
            			cityPinCodeComboBox.setDisabled(true);
            			cityPinCodeComboBox.clearValue();
            		}
            		if(!isNullOrEmpty(newValue) && isNumberValidate(newValue)){
            			var city = newValue;
            		}else{
            			var city = '';
            		}

            		var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: getPinCodeUrl1,
            			method: 'GET',
            			headers: {
            				'Content-Type': 'application/json'
            			},
            			params: {
            				id: city
            			},
            			success: function(res, action) {
            				var data = res.responseText;
            				var response = obj1.up('form').addressDfrResponse;
            				if(!isNullOrEmpty(data) && data !="[]"){
            					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
            					obj1.up('form').down('textfield#pincodeId').setVisible(false);
            					obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
            					var form = me.getPersonAddressFieldsForm();
            					var phoneCountryCode = form.down("#phoneCountryCode");
            					var phoneNoField = form.down("#phoneNoField");
            					me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
            					var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
            					store.getProxy().extraParams = {
            						id: city
            					};
            					store.reload();
            					me.getDfrDataForPinCodes(obj1.up('form'),'dropdownPincode');
            				}else{
            					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
            					obj1.up('form').down('textfield#pincodeId').setVisible(true);
            					obj1.up('form').down('textfield#pincodeId').setDisabled(false);
            					var form = me.getPersonAddressFieldsForm();
            					var phoneCountryCode = form.down("#phoneCountryCode");
            					var phoneNoField = form.down("#phoneNoField");
            					me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
            					me.getDfrDataForPinCodes(obj1.up('form'),'pincode');
            				}
            			}
            		});
            	}
            }
        },
        'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#phoneCountryCode': {
            select: function(rowModel, record) {
            	var form = this.getPersonAddressFieldsForm();
            	var countryCodeField = form.down("#phoneCountryCode");
            	var phoneNoField = form.down("#phoneNoField");
            	this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, record);
            }
        },
        'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  numberfield#cellNo': {
            change: function(record) {
            	var form = this.getPersonAddressFieldsForm();
            	var mobileField = form.down("#cellNo");
            	mobileField.isValid();
    			form.getForm().checkValidity();
            }
        },
    	'facultyfamilydetailform[itemId=facultyFamilyDetailForm] combo[itemId=mobileCountryCode]': {
		select: function(rowModel,record){
			var this$ = this;
        	var form = this$.getFacultyfamilydetailform();
        	var countryCodeField = form.down("#mobileCountryCode");
        	var mobileField = form.down("#cellNo");
         	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
         	
        
		}
	},
	'facultyfamilydetailform[itemId=facultyFamilyDetailForm] combo[itemId=phoneCountryCode]': {
		select: function(rowModel,record){
			var this$ = this;
        	var form = this$.getFacultyfamilydetailform();
        	var countryCodeField = form.down("#phoneCountryCode");
        	var phoneNoField = form.down("#phoneNoField");
        	this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, record);
		}
	},
	'facultyfamilydetailform[itemId=facultyFamilyDetailForm]  numberfield[itemId=cellNo]': {
	change: function(record){
		var this$ = this;
    	var form =this$.getFacultyfamilydetailform();
    	var mobileField = form.down("#cellNo");
    	mobileField.isValid();
		form.getForm().checkValidity();
	}
},
'facultyfamilydetailform[itemId=facultyFamilyDetailForm]  numberfield[itemId=phoneCountryCode]': {
	change: function(record){
		var this$ = this;
    	var form =this$.getFacultyfamilydetailform();
    	var mobileField = form.down("#phoneNoField");
    	mobileField.isValid();
		form.getForm().checkValidity();
	}
},
'facultyfamilydetailform[itemId=facultyFamilyDetailForm] combo[itemId=alternateMobileCountryCode]': {
	select: function(rowModel,record){
		var this$ = this;
    	var form = this$.getFacultyfamilydetailform();
    	var countryCodeField = form.down("#alternateMobileCountryCode");
    	var mobileField = form.down("#alternateMobileNo");
     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
     	
    
	}
},
'facultyfamilydetailform[itemId=facultyFamilyDetailForm]  numberfield[itemId=alternateMobileNo]': {
change: function(record){
	var this$ = this;
	var form =this$.getFacultyfamilydetailform();
	var mobileField = form.down("#alternateMobileNo");
	mobileField.isValid();
	form.getForm().checkValidity();
}
},
"addressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress1": {
    click: function() {
        this.onModifyClick("displayfield#personAddressDisplayField1", "#facultyAddressDetails", "facultyAddressWindow");
        var form = this.getPersonAddressFieldsForm();
    	var countryCodeField = form.down("#cellCountryCode");
    	var mobileField = form.down("#cellNo");
    	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
    }
},
"addressdetails[itemId=facultyAddressDetails] button#modifyPersonalAddress1": {
    click: function() {
        this.onModifyClick("displayfield#personAddressDisplayField1", "#facultyAddressDetails", "facultyAddressWindow");
        var form = this.getPersonAddressFieldsForm();
        var countryCodeField = form.down("#phoneCountryCode");
        var phoneNoField = form.down("#phoneNoField");
        this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, null);
    }
},
			'ssodetailsgrid[itemId=facultyssodetailsgridItemId]': {
            	render: function(grid) {
            		var $this = this;
            		var portalId = this.getCurrentLoggedPortalId();
                	if (portalId == 2) {
                		$this.loadSSOGridData('#facultyssodetailsgridItemId', null, $this.getFACULTY_PORTAL_SSO_DETAILS_PERMISSION());
                    } else if (portalId == 1) {
                		$this.loadSSOGridData('#facultyssodetailsgridItemId', null, $this.getFACULTY_SSO_DETAILS_PERMISSION());
                	}
            	},
            	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
            		var $this = this;
            		var grid = this.getFacultyssodetailsgrid();
            		var columnName = grid.columnManager.columns[cellIndex].dataIndex;
            		var portalId = this.getCurrentLoggedPortalId();
            		if (e.target.tagName == 'DIV') {
            			if (columnName == "addButton") {
            				if (e.target.className == "addButtonClsForGridActionCls") {
            					this.addNewRowInSSOGrid('#facultyssodetailsgridItemId');
            				}
            			} else if (columnName == "deleteButton") {//
            				if (e.target.className == "deleteButtonClsForGridActionCls") {
            					if (portalId == 2) {
            						this.deleteRowInSSOGrid('#facultyssodetailsgridItemId',record,rowIndex,null,$this.getFACULTY_PORTAL_SSO_DETAILS_PERMISSION());
            					} else if (portalId == 1) {
            						this.deleteRowInSSOGrid('#facultyssodetailsgridItemId',record,rowIndex,null,$this.getFACULTY_SSO_DETAILS_PERMISSION());
            					}
            				}
            			}
            			else{
            				grid.down('#btnSaveItemId').setDisabled(false);
            			}
            		}
            	}
            },
            'ssodetailsgrid[itemId=facultyssodetailsgridItemId] button[itemId=btnSaveItemId]': {
            	click: function() {
            		this.saveSSOGridData('#facultyssodetailsgridItemId');
            	} 
            },
            'ssodetailsgrid[itemId=facultyssodetailsgridItemId] button[itemId=btnAddSSO]': {
            	click: function() {
            		this.addNewRowInSSOGrid('#facultyssodetailsgridItemId');
            	}
            },
            'employeepersonalinformationform[itemId=facultyPersonalInformationForm] button[itemId=languageDeleteButton1]':{
    			click : function(deleteButton) {
   				 this.deleteLanguageCompentecny(deleteButton)
   			 }
   		},
   		'empadditionaldetailsform':{
        	afterrender: function(obj) {
				var $this=this;
				var facultyProfile = $this.getContentPanelActiveTab();
		        var employeeId=facultyProfile.getUserId();
				Ext.Ajax.request({
		    		type: 'rest',
		    		url: SERVERURL.PATH_FIND_EMPLOYEE_ADDITIONAL_INFORMATION,
		    		params: {
		    			userId: employeeId
		    		},
		    		method: 'GET',
		    		success: function(res, action) {
		    			if(!isNullOrEmpty(res.responseText)){
		    				var response = Ext.decode(res.responseText);
		    				if(response!=null){
		    					employeeAdditionalInfoID=response.id;
		    					response.approvalDate=dateRender(response.approvalDate);
		    					obj.getForm().setValues(response);
		    					obj.down('#approvalBody').getStore().reload();
		    					var approvalBodyField=obj.down('#approvalBody');
		        				var approvalBodyNameField=obj.down('#approvalBodyName');
		        				if(approvalBodyField.getDisplayValue()=='other'){
		        					approvalBodyNameField.setVisible(true);
		        				}else{
		        					approvalBodyNameField.setVisible(false);
		        				}
		    				}
		    			}else{
		    				employeeAdditionalInfoID=null;
		    			}
		    		}
		    	});
			}
		},
		'empadditionaldetailsform customcombobox[itemId=approvalBody]':{
			select : function(obj,rec){
				var form=this.getEmpadditionaldetailsform();
				var approvalBodyField=form.down('#approvalBody');
				var approvalBodyNameField=form.down('#approvalBodyName');
				if(approvalBodyField.getDisplayValue()=='other'){
					approvalBodyNameField.setVisible(true);
				}else{
					approvalBodyNameField.setVisible(false);
				}
			}
		},
		'empadditionaldetailsform button[itemId=empAdditionDetailFormSave]':{
			click:function(){
				this.saveEmpAdditionalDetailsForm();
    		}
		},
		'empadditionaldetailsform button[itemId=empAdditionDetailFormReset]':{
			click:function(){
				var form=this.getEmpadditionaldetailsform();
				var approverBodyName = form.down('#approvalBodyName');
				approverBodyName.setVisible(false);
				form.getForm().reset();
    		}
		},
		'qualificationdetailsform':{
        	afterrender: function(obj) {
				this.setDataOnQualificationForm();
			}
		},
		 "qualificationdetailsform button[itemId=qualificationDetailFormSave]":{
      	   click:function(){
      		   this.saveQualificationDetailForm();
      	   }
         },
         "qualificationdetailsform button[itemId=qualificationDetailFormReset]":{
        	 click:function(){
        		 var facultyProfile = this.getContentPanelActiveTab();
        		 var form = facultyProfile.down('qualificationdetailsform');
        		 form.getForm().reset();
        	 }
         },
         'facultyprofile container[itemId=profile_image_icon]': {
			  afterrender: function(container) {
				  var me = this;
			        container.getEl().on('click', this.openPhotoUploadPopupToEmp, this);
			    }
		   },
		   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[name=btnCancel]': {
			   click: function(button) {
				   var window = this.getStudentuploadphotowindow();
				   window.close();
			   }
		   },
		   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[name=btnEdit]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');

				        btnEdit.setVisible(false);
				        btnRemove.setVisible(false);
				        btnCancel.setVisible(false);
				        
				        // Show Upload Photo and Take a Photo buttons
				        btnUploadPhoto.setVisible(true);
				        btnTakePhoto.setVisible(true);
				        btnBack.setVisible(true);
				   }
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[name=btnBack]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
					   	window.down('#profile_image_containerBox').destroy();
					   	window.down('#profileRoatateImageIconId').hide();
					   	window.down('#profileImageFormItemId').insert(0,{
					   		// Profile Image Container
					   		xtype: 'container',
					   		width: 320,
					   		height: 280,
					   		layout: {
					   			type: 'vbox',
					   			align: 'center',
					   			style: {
					   				position: 'relative',
					   			}
					   		},
					   		itemId: 'profile_image_containerBox',
					   		items: [{
					   			xtype: 'image',
					   			itemId: 'profile_image',
					   			border: 1,
					   			style: {
					   				borderColor: '#e0e0e0',
					   				borderStyle: 'solid',
					   				borderRadius: '50%',
					   				marginTop:'67px !important'
					   			},
					   			width: 210,
					   			height: 210,
					   			src: 'resources/images/default-profile.png',
//					   			margin: '0 0 3 0', // Adds spacing around the image
					   		},{
					   			xtype: 'hidden',
					   			name: 'isImageRemoved',
					   			itemId: 'isImageRemovedItemId'
					   		}]
					   	},
					   	{
					   		id:'capture_panel',
					   		itemId:'capturePanelId',
					   		hidden:true,
					   		listeners:{
					   			show:function(obj){
					   				Webcam.set({
					   					width: 320,
					   					height: 240,
					   					crop_width: 320,
					   					crop_height: 240,
					   					flip_horiz: true,
					   					image_format: 'jpeg', // image format (may be jpeg or png)
					   					jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
					   				});
					   				Webcam.attach('#capture_panel-innerCt');
					   			},
					   			hide: function () {
					   				Webcam.reset();
					   			}
					   		}
					   	},{
					   		xtype:'panel',
					   		itemId:'previewPanelId',
					   		hidden:true
					   	},{
					   		xtype:'panel',
					   		hidden:true,
					   		html: "<canvas  id='canvas' width='310' height='272'></canvas>"
					   	},
					   	// Button Container for Profile Actions
					   	{
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			align: 'middle',
					   			//pack: 'center',
					   		},
					   		margin: '20 0 0 0', // Adds spacing above the buttons
					   		/*defaults: {
					labelAlign: 'top',
					margin: '0 5', // Adds spacing between buttons
				},*/
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('EDIT'),
					   			name: 'btnEdit',
					   			itemId: 'btnEditItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			style: {
					   				width: "60px !important",
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('REMOVE'),
					   			name: 'btnRemove',
					   			itemId: 'btnRemoveItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		},{
					   			xtype: 'filefield',
					   			buttonText: getCommonTranslation('UPLOAD_PHOTO'),
					   			name: 'file',
					   			itemId: 'btnUploadPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			buttonOnly: true
					   		}, {
					   			xtype: 'hidden',
					   			name: 'name',
					   			itemId: 'fileName'
					   		}, {
					   			xtype: 'hidden',
					   			name: 'personId',
					   			itemId: 'personId'
					   		}, {
					   			xtype: 'button',
					   			text: getCommonTranslation('TAKE_A_PHOTO'),
					   			name: 'btnTakePhoto',
					   			itemId: 'btnTakePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('CAPTURE'),
					   			name: 'capturePhoto',
					   			itemId: 'capturePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('RESET'),
					   			name: 'resetPhoto',
					   			itemId: 'resetPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		}]
					   	},
					   	{
					   		xtype: 'button',
					   		cls: 'profileRoatateImageIcon',	
					   		itemId: 'profileRoatateImageIconId',
					   		hidden: true,
					   		rotate: 0.1
					   	},{
					   		// Footer Button Container
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			pack: 'space-between',
					   			//align: 'middle'
					   		},
					   		margin: '60 0 0 0', // Adds spacing above the footer buttons
					   		width: '100%',
					   		defaults: {
					   			//flex: 1,
					   			//margin: '0 100',
					   		},
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('CANCEL'),
					   			name: 'btnCancel',
					   			itemId: 'btnCancelItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,	
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('BACK'),
					   			name: 'btnBack',
					   			itemId: 'btnBackItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   		},{
					   			xtype: 'component', 
					   			flex: 2
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('SAVE'),
					   			name: 'btnSave',
					   			itemId: 'btnSaveItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		}]
					   	});
					    var personProfile = this.getContentPanelActiveTab();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
				        var btnSave = window.down('button[name=btnSave]');
				        var capturePhoto = window.down('#capturePhotoItemId');
 					   	var resetPhoto = window.down('#resetPhotoItemId');
 					   	var profileImage = window.down('#profile_image');
 					   	var capturePanel = window.down('#capturePanelId');
 					   	var previewPanelId = window.down('#previewPanelId');
				        
				        btnEdit.setVisible(true);
				        btnRemove.setVisible(true);
				        btnCancel.setVisible(true);
				        btnSave.setDisabled(true);
				        profileImage.setVisible(true);
				        
				        if (window.lastSavedImageUrl) {
                            profileImage.setSrc(window.lastSavedImageUrl);
                        } else {
                        	var fallbackImg = generateInitialsImage(
                    				personProfile.getPersonInfo().firstName,
                    				personProfile.getPersonInfo().middleName,
                    				personProfile.getPersonInfo().lastName
							 );
                            profileImage.setSrc(fallbackImg);
                        }
				        
				        if (window.previousProfileImage) {
	                           profileImage.setSrc(window.previousProfileImage);
	                           profileImage.setVisible(true);
	                       }
				        
				        btnUploadPhoto.setVisible(false);
				        btnTakePhoto.setVisible(false);
				        btnBack.setVisible(false);
				        capturePhoto.setVisible(false);
 					   	resetPhoto.setVisible(false);
 					   	capturePanel.setVisible(false);
 					    previewPanelId.setVisible(false);
 					    
 					   capturePhoto.setDisabled(false);
                       resetPhoto.setDisabled(true);
                       window.down('#btnUploadPhotoItemId').reset();
				   }
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] filefield[itemId=btnUploadPhotoItemId]': {
				   change: function(button, event){
					   isUploadBtnClick = true;
				        isRemovedBtnClick = false;
					   this.employeeToUploadProfilePhoto(button, event)	
					   
				   }
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=btnRemoveItemId]': {
				   //click: this.employeeToUploadProfilePhoto
				   click:function(button, event){
				       isUploadBtnClick = false;
					   isRemovedBtnClick = true;
					   this.employeeToUploadProfilePhoto(button, event)					   
				   }
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=btnSaveItemId]': {
				   click: this.employeeToUploadCapturedImage
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=capturePhotoItemId]': {
				   click: function(button) {
					   this.employeeToCaptureUserPhoto(button);
				   }
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=btnTakePhotoItemId]': {
				   click: function(button) {
					   this.employeeToOpenCapturePhoto();
				   }
			   },
			   'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=resetPhotoItemId]': {
                   click: function(button) {
                       var window = this.getStudentuploadphotowindow();
                       window.down('#capturePanelId').setVisible(true);
                       window.down('#previewPanelId').setVisible(false);
                       window.down('#previewPanelId').update('');
                       window.down('#capturePhotoItemId').setDisabled(false);
                       window.down('#resetPhotoItemId').setDisabled(true);
                       window.down('#btnSaveItemId').setDisabled(true);
                       window.cropData = null;
                       window.component = null;
                   }
               },
               'qualificationdetailsgrid':{
            	   afterrender:function(){
            		   var me = this,
            		   facultyProfile = this.getContentPanelActiveTab(),
            		   grid=facultyProfile.down('qualificationdetailsgrid');
            		   grid.store.getProxy().extraParams = {
            			   userId:facultyProfile.getUserId()
						};
            		   grid.store.load();
            		   if(me.getCurrentLoggedPortalId() == 2){
        				   me.doAccessControlValidation(grid, me.getFACULTY_PORTAL_QUALIFICATION_DETAILS_PERMISSIONS())
        			   }else {            				   
        				   me.doAccessControlValidation(grid, me.getFACULTY_LIST_QUALIFICATION_DETAILS_PERMISSIONS());
        			   }
            		   setTimeout(function(){
            			   if(me.getCurrentLoggedPortalId() == 2){
            				   me.addDataGridConfigButton(grid, me.getFACULTY_PORTAL_QUALIFICATION_DETAILS_PERMISSIONS())
            			   }else {            				   
            				   me.addDataGridConfigButton(grid, me.getFACULTY_LIST_QUALIFICATION_DETAILS_PERMISSIONS());
            			   }
            		   },1500);
            	   }  
               },
               'qualificationdetailsgrid button[itemId=btnAdd]':{
            	   click: function() {
            		   var qualificationdetailswin = this.getQualificationdetailswin();
            		   if (!qualificationdetailswin) {
            			   Ext.widget('qualificationdetailswin');
            			   qualificationdetailswin = this.getQualificationdetailswin();
            		   }
            		   qualificationdetailswin.show();
            	   }
               },
               'qualificationdetailsgrid button[itemId=btnEdit]':{
            	   click: function(button) {
            		   this.openQualificationDetailsWin();
            		   this.setDataOnQualificationForm('edit');
            	   }
               },
               'qualificationdetailsgrid button[itemId=btnView]':{
            	   click: function(button) {
            		   this.openQualificationDetailsWin();
            		   this.setDataOnQualificationForm('view');
            	   }
               },
               'qualificationdetailsgrid button[itemId=btnDelete]':{
            	   click: function(button) {
            		   var this$ = this;
            		   var facultyProfile = this.getContentPanelActiveTab(),
            		   grid = facultyProfile.down('qualificationdetailsgrid');
            		   if (grid.getSelectionModel().getCount() > 0) {
            			   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
            				   if (btn == 'yes') {
            					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            					   var records = grid.getSelectionModel().getSelection();
            					   var id = records[0].get("id");
            					   Ext.Ajax.request({
            						   method : "DELETE",
            						   type : 'rest',
            						   url : SERVERURL.PATH_DELETE_EMPLOYEE_QUALIFICATION +'?id='+ id,
            						   headers : {
            							   'Content-Type' : 'application/json'
            						   },
            						   success : function(form,action) {
            							   Ext.getBody().unmask();
            							   grid.getStore().reload();
            							   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
            						   }
            					   });
            				   }
            			   });
            		   }else{
            			   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            		   }
            	   }
               },
               'qualificationdetailswin button[itemId=qualificationDetailFormSave]':{
            	   click: function(btn) {
            		   this.saveQualificationDetailForm(btn);
            	   }
               },
               'qualificationdetailswin button[itemId=qualificationDetailFormCancel]':{
            	   click: function() {
            		   var qualificationdetailswin = this.getQualificationdetailswin();
            		   qualificationdetailswin.close();
            	   }
               },
               'addressformwindow[itemId=facultyAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]': {             
            	   afterrender: function(form){
            		   var me = this;
            		   var win = form.up('window');
            		   form.down('#parentCountryRegionId').setDisabled(true);
            		   form.down('#cityId').setDisabled(true);
            		   form.down('#pincodeNewId').setDisabled(true);
            		   var getPinCodeUrl = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            		   Ext.Ajax.request({
            			   type: 'rest',
            			   url: getPinCodeUrl,
            			   method: 'GET',
            			   headers: {
            				   'Content-Type': 'application/json'
            			   },
            			   success: function(res, action) {
            				   var data = res.responseText;
            				   if(!isNullOrEmpty(data)){
            					   form.down('#pincodeNewId').setVisible(true);
            					   form.down('#pincodeId').setVisible(false);
            					   if(form.down('#pincodeNewId').defaultVal){
            						   form.down('#pincodeNewId').setValue(form.down('#pincodeNewId').defaultVal);
            					   }
            				   }else{
            					   form.down('#pincodeNewId').setVisible(false);
            					   form.down('#pincodeId').setVisible(true);
            					   if(form.down('#pincodeId').defaultVal){
            						   form.down('#pincodeId').setValue(form.down('#pincodeId').defaultVal);
            					   }
            				   }
            				   me.getDfrDataForPinCodes(form,'dropdownPincode');
            				   if (win && win.center) {
            					   win.center();
            				   }
            			   }
            		   });
            	   }
               },
               'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=profileRoatateImageIconId]': {
				   click: function(button) {
					   var formPanel = this.getStudentuploadphotowindow();
					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
					   imageInnerContainerBox.crop.rotate(button.rotate + .40);
					   button.rotate = parseFloat(button.rotate) + .50;
				   }
			   },
              /* 'studentuploadphotowindow[itemId=employeeToUploadPhotowindowItemId] button[itemId=profileRoatateImageIconId]': {
				   click: function(button) {
					   var formPanel = this.getStudentuploadphotowindow();
					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
					   imageInnerContainerBox.crop.rotate(button.rotate + .05);
					   button.rotate = parseFloat(button.rotate) + .05;
				   }
			   }*/
         });
    },
//    disabledEditButtonToProfile: function(btn, permissionsMap){
//    	var associatedAcadLocationIds = new Array();
//        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
//        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getEMPLOYEE_PROFILE_PERSONAL_INFORMATION_PERMISSION());
//        var editHostelCapacityBtn =form.down('#editHostelCapacityBtn');
//      editHostelCapacityBtn.setVisible(false)
//        permissionList.forEach(function(btnName){
//            if(btnName == 'MANAGE_CAPACITY'){
//                 editHostelCapacityBtn.setVisible(true);
//            }
//        });
//    },
    employeeToOpenCapturePhoto:function(){
   		var window = this.getStudentuploadphotowindow(),
   		profileImage = window.down('#profile_image'),
   		capturePanelId = window.down('#capturePanelId'),
   		btnUploadPhoto = window.down('#btnUploadPhotoItemId'),
   		btnTakePhoto = window.down('#btnTakePhotoItemId'),
   		capturePhoto = window.down('#capturePhotoItemId'),
   		resetPhoto = window.down('#resetPhotoItemId'),
   		btnBack = window.down('#btnBackItemId'),
   		btnSave = window.down('#btnSaveItemId');
   		
   		window.down('#profile_image_containerBox').hide();
   		window.down('#profileRoatateImageIconId').hide();
   		window.previousProfileImage = profileImage.el.dom.src;
   		
   		btnUploadPhoto.reset();
   		btnUploadPhoto.setVisible(false);
   		btnTakePhoto.setVisible(false);
   		profileImage.setSrc('');
   		profileImage.setVisible(false);
   		capturePanelId.setVisible(true);
   		capturePhoto.setVisible(true);
   		resetPhoto.setVisible(true);
   		resetPhoto.setDisabled(true);
   		btnBack.setVisible(true);
   		btnSave.setVisible(true);
   		
   	},
    openPhotoUploadPopupToEmp: function() {
    	var profileUploadWindow = this.getStudentuploadphotowindow();
    	
        if (!profileUploadWindow) {
        	profileUploadWindow = Ext.widget('studentuploadphotowindow',{
        		itemId: 'employeeToUploadPhotowindowItemId'
        	}); 
        }
        
        if (!profileUploadWindow.hasAfterRenderHandler) {
        	profileUploadWindow.on('afterrender', function () {
                var profile = this.getContentPanelActiveTab();
                var personId = profile.getPersonId();
                if (!isNullOrEmpty(personId)) {
                    Ext.Ajax.request({
                        url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId,
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                var profileImage = profileUploadWindow.down("#profile_image");
                                profileImage.getEl().dom.src = url;
                                profileImage.setVisible(true);
                                if (profile.getPersonInfo().photoUrl) {
                                	profileImage.getEl().dom.src = url;
                                	profileUploadWindow.lastSavedImageUrl = url;
                                    profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
                                } else {
                                	var fallbackImg = generateInitialsImage(
                                			profile.getPersonInfo().firstName,
                                			profile.getPersonInfo().middleName,
                                			profile.getPersonInfo().lastName
    								 );
                                	profileImage.getEl().dom.src = fallbackImg;
                                	profileUploadWindow.lastSavedImageUrl = fallbackImg;
                                    profileUploadWindow.down('#btnRemoveItemId').setDisabled(true);
                                }
                            }
                        },
                    });
                }
            }, this);
            
            // Mark handler as attached to avoid duplicate bindings
        	profileUploadWindow.hasAfterRenderHandler = true;
        }
        
        profileUploadWindow.show();
     },
     employeeToUploadCapturedImage: function() {
     	var me = this;
     	var profile = me.getContentPanelActiveTab();
     	var personId = Number(profile.getPersonId());
         var formPanel = me.getStudentuploadphotowindow();
         var form = formPanel.down('form');

         if(form.down('#profile_image_containerBox').isVisible()) {
        	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
        	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        	 var finalImageBase64;
        	 var imageBlob;
        	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
        		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
        		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
        	 }
         }
         
         var formValues = form.getValues();
         
         // Check if there's an image to upload
         var imageField = formPanel.down('#profileImageFormItemId');
         var imageVal = formPanel.down('#btnUploadPhotoItemId');
         var profile_image = formPanel.down('#profile_image');
         var isImageRemoved = formPanel.down('#isImageRemovedItemId');
         
         /*if(profile_image.src == "resources/images/default-profile.png"){
             me.employeeToSaveUploadCapturedImage('');
             return;
         }*/
         if(isImageRemoved.value == "true"){
             me.employeeToSaveUploadCapturedImage('');
             return;
         }
         
         me.applyWindowMask();
         if (profile_image.isVisible()) {
        	 
        	 var formData = new FormData();
        	 for (var key in formValues) {
        	     if (formValues.hasOwnProperty(key)) {
        	         formData.append(key, formValues[key]);
        	     }
        	 }
        	 formData.append('file', imageBlob, 'profile.png');
        	 
        	 var userInfo = Academia.model.authentication.UserInfoModel;
        	 var access_token = userInfo.get("accessToken");
        	 
        	 var url = SERVERURL.PERSON_IMAGE_UPLOAD+'?access_token='+access_token;
        	 
        	 var xhr = new XMLHttpRequest();
        	 xhr.open('POST', url);

        	 xhr.onload = function () {
        	     if (xhr.status >= 200 && xhr.status < 300) {
        	         var response = JSON.parse(xhr.responseText);
        	         var path = response.path;
        	         var updatedPath = path.replace(/^\/+/, "");
        	         me.employeeToSaveUploadCapturedImage(path);
        	     }
        	 };
        	 xhr.send(formData);
         }else{
         	var userInfo = Academia.model.authentication.UserInfoModel;
 			var access_token = userInfo.get("accessToken");
         	var canvas = document.getElementById('canvas');
 			var ctx = canvas.getContext("2d");
 			var region = formPanel.cropData; 
 			var component = formPanel.component;
 			var sw = region.width - region.x;
 			var sh = region.height - region.y;
 			var imgWidth = component.width;
 			var imgHeight = component.height;
 			var img = new Image();
 			img.src = component.src;
 			ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
 			var dataUrl = canvas.toDataURL("image/png");
 			
 			var url = 'rest/personImage/uploadeB64Image?access_token='+access_token;
 			var form = new FormData();
 			form.append('file', dataUrl);
 			form.append('fileName', '1.png');
 			form.append('personId', personId);
 			var xhr = new XMLHttpRequest();
 			xhr.open('POST', url, true);
 			xhr.onreadystatechange = function () {
 				if (xhr.readyState == 4 && xhr.status == 200) {
 					if (xhr.responseText != "") {
 						var data = Ext.decode(xhr.responseText);
 						var personinfo = profile.getPersonInfo();
 						personinfo.photoUrl = data.path;
 						var updatedPath = data.path.replace(/^\/+/, "");
 						//me.employeeToSaveUploadCapturedImage(updatedPath);
 						me.getUploadCaptureToPersonProfile();
 					}
 				}
 				formPanel.close();	
 				//me.hideWindowMask();
 			};
 			xhr.send(form);
         } 
     },
     employeeToSaveUploadCapturedImage: function(imageUrl){
     	var me = this;
     	var win = me.getStudentuploadphotowindow();
     	var personProfile = me.getContentPanelActiveTab();
     	var personId = Number(personProfile.getPersonId());
     	personProfile.getPersonInfo().photoUrl=imageUrl;
     	var payload = {
     			personId: personId,
     			path: imageUrl
     	};
     	
     	var submitUrl = SERVERURL.PATH_UPLOAD_PERSON_PROFILE_PHOTOS;
     	
     	var data = Ext.encode(payload);
     	
     	Ext.Ajax.request({
     		url: submitUrl,
     		method: 'POST',
     		jsonData:data,
             success: function(response){
             	var responseData = response.responseText;
             	if (responseData=='fail') {
             		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
             	}else{
             		if(imageUrl == ""){  
             			var profileImage=personProfile.down("#profile_image");
             			var fallBackImg = generateInitialsImage(
	       						 personProfile.personInfo.firstName, 
	       						 personProfile.personInfo.middleName, 
	       						 personProfile.personInfo.lastName
       						);

             			profileImage.setVisible(true);
             			profileImage.setSrc(fallBackImg);
             			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PERSON_PROFILE_PHOTO_REMOVE_SUCCESS'));
             		}
             		else{
             			me.getUploadCaptureToPersonProfile();
             			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
             		}
             	}
             	win.close();
             	me.hideWindowMask();
             },
             failure: function(response){
             	me.hideWindowMask();
             }
     	})
     },
     employeeToUploadProfilePhoto: function(cmp, value) {
    	    var window = this.getStudentuploadphotowindow();
    	    var personProfile = this.getContentPanelActiveTab();
    	    var form = window.down('form');
    	    var image = form.down('#profile_image');
    	    var imageContainerBoxId = form.down('#profile_image_containerBox').id;
    	    var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
    	    var btnSave = window.down('button[name=btnSave]');
    	    var btnRemoveItemId = window.down("#btnRemoveItemId")
    	     var isImageRemoved = window.down('#isImageRemovedItemId');

    	    if (isRemovedBtnClick) {
    	        isRemovedBtnClick = false; 
    	        var isImageRemoved = window.down('#isImageRemovedItemId');
		        var fallbackImg = generateInitialsImage(
		 				personProfile.getPersonInfo().firstName,
		 				personProfile.getPersonInfo().middleName,
		 				personProfile.getPersonInfo().lastName
				);
		        image.setSrc(fallbackImg);
		        isImageRemoved.setValue(true);
    	        btnSave.setDisabled(false); 
    	        btnRemoveItemId.setDisabled(true);
    	        return;
    	    }

    	    
    	    if (isUploadBtnClick) {
    	        isUploadBtnClick = false; 

    	        var file = cmp.el.down('input[type=file]').dom.files[0];
    	        if (!file) {
    	            showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('NO_FILE_SELECTED'));
    	            return;
    	        }

    	        // File extension validation
    	        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
    	        if (!['png', 'jpeg', 'jpg'].includes(extension)) {
    	            cmp.reset();
    	            showWarningMessage(
    	                getPersonModuleTranslation('PHOTO_UPLOAD'),
    	                getPersonModuleTranslation('UPLOAD_VALID_FILE')
    	            );
    	            return;
    	        }

    	     // File size validation (Minimum: 100 KB, Maximum: 2 MB)
    	        if(file){
              		 if (file.size < 100 * 1024 || file.size > 2 * 1024 * 1024){      // file size should be less than 100 kb & greater than 2MB                       
              			 cmp.reset();
                           showWarningMessage(
                               getPersonModuleTranslation('PHOTO_UPLOAD'),
                               getCommonTranslation('FILE_SIZE_BETWEEN_RANGE')
                           );
                           return;
                       }else {
                           isImageRemoved.setValue(false);
                       }
               	}  	        

    	        // Process the valid file
    	        form.down('#fileName').setValue(file.name);
    	        var personProfile = this.getContentPanelActiveTab();
    	        var personId = Number(personProfile.getPersonId());
    	        form.down('#personId').setValue(personId);

    	        var reader = new FileReader();
    	        reader.onload = function(e) {
    	        	var crop;
    	        	var imageSrc;
    	        	var canvasDiv ;
    	            image.setSrc(e.target.result); // Set the image source
    	            Ext.defer(function(){
    	            	imageSrc = imageInnerContainerBox.children[0].src;
    			        image.setVisible(false);
    			        window.down('#profileRoatateImageIconId').show();
    	            	 crop = cropper(imageInnerContainerBox, {
        				    area: [ 210, 210 ],
        				    crop: [ 115, 115 ],
        				    value: imageSrc,
        				    allowResize: true,
        		            allowZoom: true,
        		            allowRotation: true,         		            
        				})
        				var jcropArea = imageInnerContainerBox.querySelector('.jcrop-area');
    	            	 if (jcropArea) {
    	            		    var innerJcropDiv1 = document.createElement('div');
    	            		    innerJcropDiv1.className = 'border-left';

    	            		    var innerJcropDiv2 = document.createElement('div');
    	            		    innerJcropDiv2.className = 'border-right';

    	            		    jcropArea.appendChild(innerJcropDiv1);
    	            		    jcropArea.appendChild(innerJcropDiv2);
    	            		}
        				canvasDiv = jcropArea.nextSibling;

        				if(!isNullOrEmpty(canvasDiv)){
        					var mouseEventOccurred = false;

        				if (canvasDiv) {
        				    // Listen for mouse events and set the flag to true when one occurs
        					canvasDiv.addEventListener('mousemove', function () {
        						mouseEventOccurred = true;
    				            if (mouseEventOccurred) {    				                
    				                var croppedImage = crop.getCroppedImage().src;
        				            image.setSrc(croppedImage);
        				            image.setVisible(true);
    				            }    				            
    				        })
    				        if(mouseEventOccurred == false) {
        				    image.setSrc(imageSrc);
        				    image.setVisible(true);
        				}
        				} 
        			} 
    				else {
    				    image.setSrc(imageSrc);
    				    image.setVisible(true);
    				}
    	            },500)
    	            btnSave.setDisabled(false); // Enable the save button
    	        };
    	        reader.readAsDataURL(file);
    	    }
    	},
    	employeeToCaptureUserPhoto : function(btn){
			var $this = btn.up('window');
			var form = btn.up('window').down('form');
			var imageUrl;
			Webcam.snap( function(data_uri) {
				imageUrl = data_uri;
			});
	        Ext.defer(function() {
	        	var imgLoad = new Image();
	    		imgLoad.onload = (function(){
	    			var crop = new Academia.utilities.ImageCrop({
	    				id:'testing',
	    				width: 310,
	    				height: 272,
	    				src:imageUrl
	    			});
	    			crop.on('changeCrop', function(component,region) {
	    				$this.cropData = region;
	    				$this.component = component;
	    			});
	    			var PREVIEW_TEST = form.down('#previewPanelId');
	    			PREVIEW_TEST.add(crop);
	    			$this.down('#capturePanelId').setVisible(false);
	    			$this.down('#previewPanelId').setVisible(true);
	    			btn.setDisabled(true);
	    			$this.down('#resetPhotoItemId').setDisabled(false);
	    			$this.down('#btnSaveItemId').setDisabled(false);
	    			
	    			var canvas = document.getElementById('canvas');
					var ctx = canvas.getContext("2d");
					var region = $this.cropData; 
					var component = $this.component;
					var sw = region.width - region.x;
					var sh = region.height - region.y;

					var imgWidth = component.width;
					var imgHeight = component.height;

					var img = new Image();
					img.src = component.src;

					ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
	    			$this.captureImageaUrl = canvas.toDataURL("image/png");
	    		}).bind($this);
	    		imgLoad.src = imageUrl;
	    		$this.imagesUrl = imageUrl;
	  	  }, 500, $this);  	
    	},
 	getUploadCaptureToPersonProfile : function(){
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var personId = personProfile.getPersonId();
        if(!isNullOrEmpty(personId)){
            Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId+'&isDefaultImageRequired=false',
                method: 'GET',
                success : function(response){
                    if(response.responseBytes.length>0){
                        var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
                        var url = window.URL.createObjectURL(blob);
                        var a=personProfile.down("#profile_image");
                        a.getEl().dom.src=url;
                        a.setVisible(true);
                    }
                }
            });
        }
    },
     // Profile update window: End
	addPerosnTabToFacultyProfile : function(view, record){
    	
    	var this$ = this;
    	var facultyProfile = this$.getContentPanelActiveTab();
        var personId = facultyProfile.getPersonId();
        var tabPanelTitle= record.get('tabPanelTitle');
    	var tabPanelItemId= record.get('tabPanelItemId');
    	var tabPanelItemXtype= record.get('tabPanelItemXtype');
    	var xtypeItemId= record.get('xtypeItemId');
    	var defaultPanel= record.get('defaultPanel');
    	var renderPanel= record.get('render');
    	
        if (!isNullOrEmpty(renderPanel) && renderPanel) {
        	
        	this$.addPersonTabPanel('FACULTY', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
        }
    },
    /* 
     * Get Faculty Profile Information
     * */
    getFacultyProfileInformation: function(facultyProfileItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();

//        facultyProfileView.refresh();
        var userId = personProfile.getUserId();
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        this$.sendGetAjaxRequest(SERVERURL.FACULTY_PERSONAL_INFORMATION_BY_ID + userId, 'GET', null, function(option, success, response) {
    		if(success){
    			Ext.getBody().unmask();
    			var data = Ext.decode(response.responseText);
                if(!isEmpty(data)){
	                empAdditionInfoEmployeeId=data.id; //Used In personalInfoController
                	 var facultyStatus = data.status ;
                     if(facultyStatus === true){
                    	 facultyStatus = getCommonTranslation('ACTIVE');
                     }else{
                    	 facultyStatus = getCommonTranslation('INACTIVE');
                     }
                     data.person.status = facultyStatus;
                     data.person.personId = data.code;
                	personProfile.setPersonInfo(data.person);
                    var templateDataArray=new Array();
					templateDataArray.push(data.person);
					
					if(this$.getCurrentLoggedPortalId() != 2){
						var facultyProfileView = personProfile.down(facultyProfileItemId);
						var store = facultyProfileView.getStore();
						store.loadData(templateDataArray);
					}
                }
    		}else{
    			Ext.getBody().unmask();
    		}
    		
    	});
        var portalId = this$.getCurrentLoggedPortalId();
        this$.setUploadedPhotoToPersonProfile(SERVERURL.PERSON_IMAGE_DOWNLOAD,"FACULTY");
    },
    
  /*  saveFacultyPersonPhotoUpload : function(photoFileImage){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var facultyPhotoUploadForm = personProfile.down('#facultyPhotoUploadForm');
    	//facultyPhotoUploadForm.getForm().setValues({'personId':personProfile.getPersonId()});
    	this$.savePersonPhotoUpload(facultyPhotoUploadForm, personProfile.getPersonId(), SERVERURL.PERSON_IMAGE_UPLOAD, SERVERURL.PERSON_IMAGE_DOWNLOAD, function(success,photoUrl){
    		if(success){
    			this$.onRenderFacultyPersonalInformationForm(photoUrl);
    		}
    		
    	});
    	
    },*/
    
    /**
     * On render faculty personal information form
     * call to personal information
     */
    onRenderFacultyPersonalInformationForm : function(photoUrl){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var userId = personProfile.getUserId();
    	if(!isNullOrEmpty(photoUrl)){
    		personProfile.personInfo.photoUrl=photoUrl;
    		}
    	
        if (!isNullOrEmpty(userId)) {
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	var url = SERVERURL.FACULTY_PERSONAL_INFORMATION_BY_ID + userId;
        	this$.sendGetAjaxRequest(url, 'GET', null, function(option, success, response) {
        		Ext.getBody().unmask();
        		if(success){
        			var data = Ext.decode(response.responseText);
                    if(!isEmpty(data)){
                    	this$.setValueToPersonalInformationForm(data);
                    }
        		}
        		
        	});
        }
        
    },
    
    /**
     * Set value to personal info
     */
    setValueToPersonalInformationForm : function(data){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personalInformationForm = personProfile.down('#facultyPersonalInformationForm');
    	var portalId = this.getCurrentLoggedPortalId();
    	
    	var printNameElm = personalInformationForm.down('#printNameId');
    	var genderId = personalInformationForm.down('#genderId');
    	var haveDisabilities = personalInformationForm.down('#haveDisabilities');
    	 var externalSysRefOneval = personalInformationForm.down('#externalSysRefOne');
    		var externalSysRefTwoval = personalInformationForm.down('#externalSysRefTwo');
    		var externalSysRefThreeval = personalInformationForm.down('#externalSysRefThree');
    		var placeOfBirth = personalInformationForm.down('#placeOfBirthItemId');
    		var placeOfBirthOtherLang = personalInformationForm.down('#placeOfBirthOtherLangId');
    		if(externalSysRefOneval!=null && externalSysRefTwoval && externalSysRefThreeval){
    			
    			
    		}
    	//var genderIDS
    	if(personalInformationForm){
    		if(!isNullOrEmpty(data.joiningDate))
    			data.joiningDate = new Date(data.joiningDate);
    		if(!isNullOrEmpty(data.person.birthDate))
    			data.person.birthDate = new Date(data.person.birthDate);
    		if(!isNullOrEmpty(data.exitDate))
    			data.exitDate = new Date(data.exitDate);	
    		if(!isNullOrEmpty(data.accountingKey))
    			data.person.accountingKey = data.accountingKey;
    		
    		if(externalSysRefOneval!=null && externalSysRefTwoval && externalSysRefThreeval){
    			if( data.person.externalSysRefOne==null){
    				data.person.externalSysRefOne=externalSysRefOneval.getValue();
    			}
    			if( data.person.externalSysRefTwo==null){
    				data.person.externalSysRefTwo=externalSysRefTwoval.getValue();
    			}
    			if( data.person.externalSysRefThree==null){
    				data.person.externalSysRefThree=externalSysRefThreeval.getValue();
    			}
    		}
    		if(!isNullOrEmpty(data.person)){
    			data.person.placeOfBirth=data.person.birthPlace;
        		data.person.placeOfBirthOtherLang=data.person.birthPlaceOtherLanguage;
        		if(!isNullOrEmpty(data.person.idtype)){
        			data.person.idtype={"id":data.person.idtype.id}
        		}else{
					data.person.idtype = null;
				}
    		}
    		var emplang=this$.getEmployeeLanguageValue(data.person);
        	var personData = this$.getFacultyPersonalInfoFormValue(data.person);
        	data = this$.setPersonDataToFinalObject(data, personData);
        	this$.setSubDepartmentValue(personalInformationForm, data);
        	Ext.apply(personalInformationForm,{
        		code:null,
     		  setCode : function(code){
     			 personalInformationForm.code = code;
     		  },
     		  getCode:function(){
     			  return personalInformationForm.code;
     		  }
     	  });
        	if(!isNullOrEmpty(data.person.nationalID))
        	{
        		personalInformationForm.down("#employeeVerifyDetail").setDisabled(false);
        	}else
        	{
        		personalInformationForm.down("#employeeVerifyDetail").setDisabled(true);

        	}	
        	personalInformationForm.setCode(data.code)
        	
            personalInformationForm.getForm().setValues(data);
    		personalInformationForm.down('#identityExpiryDateItemId').setValue(dateRender(data.person.identityExpiryDate));
    		personalInformationForm.down('#idTypeCombo').getStore().load({
				callback: function(rec, success) {
					if(data.person.idtype && data.person.idtype.id){
						personalInformationForm.down('#idTypeCombo').setValue(data.person.idtype.id);
					}else{
						personalInformationForm.down('#idTypeCombo').reset();
					}
					
				}
			})
        	
        	//========================To Set Default Country Code==========================//
        	
      	    var countryCodeFieldItemIDArray = ["#phoneCountryCode","#cellCountryCode"];
            this.setDefaultCountryCode(personalInformationForm, countryCodeFieldItemIDArray);
            var countryCodeField = personalInformationForm.down("#cellCountryCode");
	        var mobileField = personalInformationForm.down("#mobileNumber");
	         this.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
	         var countryCodeField = personalInformationForm.down("#phoneCountryCode");
	         var phoneNoField = personalInformationForm.down("#phoneNoField");
	         this.setMaximumMinimumDigitsForPhoneNoValidation(personalInformationForm, countryCodeField, phoneNoField, null);
	         
		 
                 
      	   //========================To Set Default Country Code==========================//
        	
        	var task = new Ext.util.DelayedTask(function(){
        		printNameElm.setValue(data.printName);
        	});
        	task.delay(100);
        	
        	if(portalId == 2) {
        		
        		var personCode = personalInformationForm.down('#personCodeField');
        		personCode.setReadOnly(true);
        		
        		var personPhotoUpload = personalInformationForm.down('#facultyPhotoUploadForm');
        		var photoUploadBtn = personPhotoUpload.down('#photoFileImage');
        		///photoUploadBtn.setDisabled(true);
        		
        		var salutationId = personalInformationForm.down('#salutationId');
        		salutationId.setReadOnly(true);
        		
        		var firstNameId = personalInformationForm.down('#firstNameId');
        		firstNameId.setReadOnly(true);
        		
        		var middleNameId = personalInformationForm.down('#middleNameId');
        		middleNameId.setReadOnly(true);
        		
        		var lastNameId = personalInformationForm.down('#lastNameId');
        		lastNameId.setReadOnly(true);
        		
        		var birthDateId = personalInformationForm.down('#birthDateId');
        		birthDateId.setReadOnly(true);
        		
        		var designation = personalInformationForm.down('#designationCombo');
        		designation.setReadOnly(true);
        		
        		var department = personalInformationForm.down('#departmentCombo');
        		department.setReadOnly(true);
        		
        		var startDate = personalInformationForm.down('#startDate');
        		startDate.setReadOnly(true);
        		
        		/*var yearsOfExperience = personalInformationForm.down('#yearsOfExperience');
        		yearsOfExperience.setReadOnly(true);*/
        		
        		var leaveCategory = personalInformationForm.down('#leaveCategory');
        		leaveCategory.setReadOnly(true);
        	}
        	var genderCSM=genderId.getStore();
        	genderCSM.load({
					callback: function(rec, success) {
						if (success) {
							for(var i in rec){
								if(rec[i].get('id')==data.person.genderCSM.id){
									genderId.setValue(rec[i].get('id'));
								}
							}
						}
					}
				});
        	 var haveDisabilitiesStore=haveDisabilities.getStore();
     			haveDisabilitiesStore.load({
     				callback: function(records, operation, success) {
     					if (success) {
     						var haveDisabilitiesArray= [];
     						if(records.length > 0){
     							data.person.personDisability.forEach(function(persondisabilityObj){
     								var result = records.filter(function (obj) {
     									  return obj.data.id === persondisabilityObj.haveDisabilities.id;
     									})[0];
     								haveDisabilitiesArray.push(result);
     							});
     							haveDisabilities.setValue(haveDisabilitiesArray);
     						}
     					}
     				}
     	        });
        }
    },
    
    /*
     *  Need to set value in form
     */
    getFacultyPersonalInfoFormValue: function(personData) {
        var this$ = this;
        if(!isEmpty(personData)){
        	personData.personId = personData.id;
        	personData.personVersion = personData.version;
        	this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'id', 'bankDetailsId');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'version', 'bankDetailsVersion');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'bankName', 'bankName');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'accountNumber', 'accountNumber');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'branchName', 'branchName');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'ifsCode', 'ifsCode');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'beneficiaryName', 'beneficiaryName');
            this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'accountTypeId', 'accountTypeId');
            
            
            this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'id', 'phyId');
            this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'version', 'phyVersion');
            this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'height', 'height');
            this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'weight', 'weight');
            this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'hairColor', 'hairColor');
            this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'eyeColor', 'eyeColor');       
            
            delete personData.id;
            delete personData.version;
              return personData;
    }
    },
    getEmployeeLanguageValue: function(personData) {
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var createcourseform = personProfile.down('#facultyPersonalInformationForm');
    	var employeeLanguageField = createcourseform.down("#employeeLanguage");
    	var writeField = createcourseform.down("#writeItemId");
    	var readField = createcourseform.down("#readItemId");
    	var speakField = createcourseform.down("#speakItemId");
    	var addBtn = createcourseform.down("#stopBtn");
    	this.loadDFRForLanuageCompentcy(employeeLanguageField,writeField,readField,speakField,addBtn);
    	var panelContiner = createcourseform.down('#serviceStopPanelId');
		var indx = 0;
		if(personData.languageCompetency.length>0){
			panelContiner.removeAll();
			var record=personData.languageCompetency;
			personData.languageCompetency.forEach(function(obj){
				var panelItem = new Array();
				var departmentId =obj.multiLanguage.employeeLanguage;
				var multiLanguage =obj.multiLanguage.id;
				var read =	obj.read.id;
				var speak =obj.speak.id;
				var write =	obj.write.id;
				var langId=obj.id
				//var subDepartmentId = isNullOrEmpty(obj.subDepartment)? null : obj.subDepartment.id;
				var weightage = obj.weightage;
				if(panelContiner.items.length == 0){
					panelItem.push({
						plugins: "formlabelrequired",
						xtype : 'fieldcontainer',
						layout : 'hbox',
						width: '100%',
						scope: this$,
						defaults : {
							labelAlign : 'top',
							//width: '100%'
						},
						/*layout : {
							type : 'hbox'
						},*/
						items:[{
							xtype: 'hidden',
							itemId:'langItemId',
							name: 'langId',
							value: langId
					},{
							xtype: 'customcombobox',
							width: 217,
							name: 'employeeLanguage',
							itemId : 'employeeLanguage',
							fieldLabel:getCommonTranslation('LANGUAGE'),
							store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
							valueField: 'id',
							displayField: 'value',
							editable: false,
							typeAhead: false,
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							//queryParam:'qry',
							rowIndx:indx,
							forceSelection:true,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								}
								
							},
							listeners:{
								render: function(combo){
									var cDepartmentStore= combo.getStore();
									cDepartmentStore.getProxy().extraParams = {
										limit:-1
									};
									cDepartmentStore.load({
										callback:function(record, operation, success){
											combo.setValue(multiLanguage);
										}
									});
								},
								select:function(obj,rec,value){
									var departmentId=rec[0].get('id');
									var flag = true;
									var pnlMain = obj.up("#serviceStopPanelId");
									var rowIndx = obj.rowIndx;
									if(!isNullOrEmpty(pnlMain)){
										pnlMain.items.each(function(item, index, items) {
											var deptNameVal = item.down("[name=employeeLanguage]").getValue();
											if(departmentId == deptNameVal && rowIndx != index){
												flag = false;
					        					return false;
											}
										});
										
										if(flag){
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											if (departmentId > 0) {
												var writeStore=write.getStore();
												var speakStore=speak.getStore();
												
												var store=nextSiblingField.getStore();
												store.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												store.load();
												writeStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												writeStore.load();
												speakStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												speakStore.load();
											}
										}
										else{
											obj.reset();
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
											return false;
										}
									}
								}
								
							}
						},
						{
							xtype: 'customcombobox',
							name: 'read',
							itemId : 'readItemId',
							editable: false,
							valueField: 'id',
							displayField: 'value',
							fieldLabel:getCommonTranslation('READ'),
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							width: 217,
							listeners: {
								render: function(combo) {
									var subDepartmentStore= combo.getStore();
									subDepartmentStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									subDepartmentStore.load({
										callback:function(record, operation, success){
											combo.setValue(read);
											
											
										}
									});
								}
							}
						},{    
							xtype: 'customcombobox',
							name: 'write',
							itemId : 'writeItemId',
							fieldLabel: getCommonTranslation('WRITE'),
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							valueField: 'id',
							displayField: 'value',
							width: 217,
					         listeners: {
								render: function(combo) {
									var writeStore= combo.getStore();
									writeStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									writeStore.load({
										callback:function(record, operation, success){
											combo.setValue(write);
											
											
										}
									});
								}
							}
							
						},{    
							xtype: 'customcombobox',
							name: 'speak',
						    itemId : 'speakItemId',
							valueField: 'id',
							displayField: 'value',
							fieldLabel: getCommonTranslation('SPEAK'),
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							width: 217,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(speak);
											
											
										}
									});
								}
							}
							
						},{
							xtype: 'button',
							itemId: 'stopBtn',
							cls: 'CustomBodyBtnSettings',
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'28px'
							}
						}]
					
					});
				}else{
					panelItem.push({
						xtype : 'fieldcontainer',
						layout : 'hbox',
						width: '100%',
						scope: this$,
						defaults : {
							labelAlign : 'top',
							//width:'100%'
						},
						layout : {
							type : 'hbox'
						},
						/*margin: '10 0 0 0',
						padding: '0 0 0 0',*/
						items:[{
							xtype: 'hidden',
							itemId:'langItemId',
							name: 'langId',
							value: langId
					},{
							xtype: 'customcombobox',
							width: 217,
							name: 'employeeLanguage',
							//itemId:'employeeLanguage',
							store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
							valueField: 'id',
							displayField: 'value',
							editable: false,
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							typeAhead: false,
							//queryParam:'qry',
							//minChars:3,
							rowIndx:indx,
							forceSelection:true,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								}
								
							},
							listeners:{
								render: function(combo){
									var cDepartmentStore= combo.getStore();
									cDepartmentStore.getProxy().extraParams = {
										limit:-1
									};
									cDepartmentStore.load({
										callback:function(record, operation, success){
											combo.setValue(multiLanguage);
											
										}
									});
								},
								select:function(obj,rec,value){
									var departmentId=rec[0].get('id');
									var flag = true;
									var pnlMain = obj.up("#serviceStopPanelId");
									var rowIndx = obj.rowIndx;
									if(!isNullOrEmpty(pnlMain)){
										pnlMain.items.each(function(item, index, items) {
											var deptNameVal = item.down("[name=employeeLanguage]").getValue();
											if(departmentId == deptNameVal && rowIndx != index){
												flag = false;
					        					return false;
											}
										});
										
										if(flag){
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											if (departmentId > 0) {
												var writeStore=write.getStore();
												var speakStore=speak.getStore();
												
												var store=nextSiblingField.getStore();
												store.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												store.load();
												writeStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												writeStore.load();
												speakStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												speakStore.load();
											}
										}
										else{
											obj.reset();
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											//nextSiblingField.reset();
											//nextSiblingField.setDisabled(true);
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
											return false;
										}
									}
								}
								
							}
						},{    
							xtype: 'customcombobox',
							name: 'read',
							//itemId:'readItemId',
							width: 217,
							valueField: 'id',
							displayField: 'value',
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							//value:read,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(read);
											
											
										}
									});
								}
							}
							
						},
						{    
							xtype: 'customcombobox',
							name: 'write',
							//itemId:'writeItemId',
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							width: 217,
							valueField: 'id',
							displayField: 'value',
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							//value:write,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(write);
											
											
										}
									});
								}
							}
							
						},{    
							xtype: 'customcombobox',
							name: 'speak',
						//	itemId:'speakItemId',
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							width: 217,
							valueField: 'id',
							displayField: 'value',
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							allowBlank:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isMandatory)?false:true):true,
							editable: false,
							//value:speak,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(speak);
											
											
										}
									});
								}
							}
						},{
							xtype: 'button',
							glyph: ICONGLYPH.DELETEGLYPH,
							itemId: 'languageDeleteButton1',
							width: 'auto',
							cls: 'CustomBodyBtnReject',
							tooltip: getCommonTranslation('DELETETOOLTIP'),
							hidden:this$.empLanguageDFR.length>0?((this$.empLanguageDFR[0].isVisible)?false:true):false,
							width:40,
							style:{
								marginTop:'0px'
							},
							listeners:{ listeners:{
								click:function(obj){
									var container = obj.up('fieldcontainer');
									//panelContiner.remove(container);
									//$this.getCreatecourseform().getForm().isValid();
									//$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
								}
							}}
						}]

					});
				}

				panelContiner.add(panelItem);
				//$this.departmentHideShowDetailsOfBasic(panelContiner);
				indx = indx + 1; 
				panelContiner.doLayout();
			});
		
		}
		
	
    
    //var personProfile = this$.getContentPanelActiveTab();
   // var createcourseform = personProfile.down('#facultyPersonalInformationForm');
    var employeeLanguageField = createcourseform.down("#employeeLanguage");
    var writeField = createcourseform.down("#writeItemId");
    var readField = createcourseform.down("#readItemId");
    var speakField = createcourseform.down("#speakItemId");
    var addBtn = createcourseform.down("#stopBtn");
    this.loadDFRForLanuageCompentcy(employeeLanguageField,writeField,readField,speakField,addBtn);
    return personData;
    },
    
    /**
     *  Put all person data in final Object
     */
    setPersonDataToFinalObject :function(data,personData){
    	for (var key in personData) {
            if(isNullOrEmpty(personData[key])){            	
            	data[key]="";            	               
            }else{
            	data[key] = personData[key];   
            }    		
        }
    	return data;
    },
    
    onSetDepartmentComboValue : function(combo){
    	var this$ = this;
    	var deparementId = combo.getValue();
    	var personProfile = this$.getContentPanelActiveTab();
        var personalInformationForm = personProfile.down('#facultyPersonalInformationForm');
        var subDepartmentCombo = personalInformationForm.down('#subDepartmentCombo');
        subDepartmentCombo.setValue('');
        var store = subDepartmentCombo.getStore();
        store.load({
        	params : {
        		parentId : deparementId
        	}
        });
        
    },
    deleteLanguageCompentecny: function(deleteButton) {
   	 var this$ = this;
   	var personProfile = this$.getContentPanelActiveTab();
    var form = personProfile.down('#facultyPersonalInformationForm');
    var departmentPanel = form.down('#serviceStopPanelId');
   	var container = deleteButton.up('fieldcontainer');
 	var langId= container.down('#langItemId').getValue();
   if (container != null && departmentPanel != null) {
   		 if (departmentPanel.items.length > 1) {
   			 departmentPanel.remove(container);
   			// this$.departmentHideShowDetailsOfBasic(departmentPanel);
   		 }
   	 }
   if(langId!=null){
	   deleteUrl = SERVERURL.PATH_DELETE_LANAGUAGE_COMPETENCY+'?id='+ langId,
       Ext.Ajax.request({
           type: 'rest',
           url: deleteUrl,
           method: 'DELETE',
           headers: {
               'Content-Type': 'application/json'
           },
           success: function(form, action) {
              // grid.getStore().load();
              // showSuccessMessage(getPersonModuleTranslation('FAMILY_DETAILS'), getPersonModuleTranslation('FAMILY_DETAILS_DELETE_SUCCESS'));
           }
       });
   	}
   	 form.getForm().checkValidity();
   	 //departmentPanel.doLayout();
    },
    setSubDepartmentValue : function(personalInformationForm, data){
    	var department = data["department"];
    	var subDepartment = data["subDepartment"];
    	if(!isNullOrEmpty(department)){
    		var subDepartmentCombo = personalInformationForm.down('#subDepartmentCombo');
            var store = Ext.create('Academia.store.department.SubDepartmentComboStore');
            var departmentId = department["id"];
            store.getProxy().extraParams = {
            	parentId : departmentId
            };
            subDepartmentCombo.bindStore(store);
            store.load({
            	callback: function(records, operation, success) {       
            		if(!isNullOrEmpty(subDepartment)){
            				subDepartmentCombo.setValue(subDepartment);
            		}
            	}
            	
            });
    	}
    },
    activateFaculty : function(){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var person = this$.getPersonObj();
    	var userId = personProfile.getUserId();
    	if(!isNullOrEmpty(person["id"])){
    		Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.FACULTY_MANDATORY_TAB_INFO,
                params : {
                	facultyId : person["id"]
                },
                method: 'GET',
                success: function(res, action) {
                    var data = Ext.decode(res.responseText);
                    
                    var unFilledTabs = getPersonModuleTranslation('UNFILLED_INFORMATION_TAB');
                    for(var i = 0; i < data.length; i++){
                    	unFilledTabs += getPersonModuleTranslation(data[i]);
                    	
                    	if(i != (data.length-1)){
                    		unFilledTabs += ", ";
                    	}else{
                    		unFilledTabs += ".";
                    	}
                    }
                    
                    var facultyActivateConfirmMessage = '';
                    if(data.length != 0){
                    	facultyActivateConfirmMessage +=  '<ul><li>' + unFilledTabs +'</li>';
                	}
                    
                    facultyActivateConfirmMessage += '<li>' + getPersonModuleTranslation('AFTER_ACTIVATE_NOT_EDITED_MESSAGE') +'</li></ul>';
                    
                    facultyActivateConfirmMessage += getPersonModuleTranslation('FACULTY_ACTIVATE_CONFIRM_MESSAGE');
                    if(!isNullOrEmpty(userId)){
                    	showConfirmMessage(getPersonModuleTranslation('FACULTY_ACTIVATE'), facultyActivateConfirmMessage, function(btn, text) {
                        	if (btn == 'yes') {
                        		Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.ACTIVATE_FACULTY_URL,
                                    params : {
                                    	facultyId : userId
                                    },
                                    method: 'GET',
                                    success: function(res, action) {
                                    	showSuccessMessage(getPersonModuleTranslation('FACULTY_ACTIVATE'), getPersonModuleTranslation('FACULTY_ACTIVITY_SUCCESS'));
                                    	//this$.mixins.FacultyListController.loadFacultyListGridStore();
                                    	personProfile.close();
                                    }
                        		});     
                        	}
                        });	
                    }
                    
                }
            });
    	}else{
    		showErrorMessage(getPersonModuleTranslation('FACULTY_ACTIVATE'), getPersonModuleTranslation('MANDATORY_FIELDS_NOT_FILLED'));
    	}
    	
    },
    
    getConformMessageForActivation : function(unFilledTabs, key){
    	unFilledTabs += getPersonModuleTranslation('FACULTY_ACTIVATE');
    },
    
    
    /* 
     * Create faculty Personal Information
     * */
    createFacultyPersonalInformation: function(facultyProfileItemId) {
        var this$ = this;
        var isUpdate = false;
        var personProfile = this$.getContentPanelActiveTab();
        var personInfo = personProfile.getPersonInfo();
        var personalInformationForm = personProfile.down('#facultyPersonalInformationForm');
//        var photoUrl = personalInformationForm.down('#photoFileImage').getValue();
        var photoUrl = personInfo.photoUrl;
        var jsonFormatFormData = personalInformationForm.getValues();
        if(isNullOrEmpty(jsonFormatFormData.idtype))
        {
		  jsonFormatFormData.idtype=null;	
		}
        delete jsonFormatFormData.experienceInMonth;
        delete jsonFormatFormData.experienceInYear;
        
        if(this.validatePhone(jsonFormatFormData)){
        	if(isNullOrEmpty(jsonFormatFormData.country) || isNullOrEmpty(jsonFormatFormData.country.id)){
        		jsonFormatFormData.country=null;
        	}
        	if(isNullOrEmpty(jsonFormatFormData.nationality) || isNullOrEmpty(jsonFormatFormData.nationality.id)){
        		jsonFormatFormData.nationality=null;
        	}
        	if(isNullOrEmpty(jsonFormatFormData.subDepartment) || isNullOrEmpty(jsonFormatFormData.subDepartment.id)){
        		jsonFormatFormData.subDepartment=null;
        	}
        	
        	var facultyPhotoUploadForm = personProfile.down('#facultyPhotoUploadForm');
        	var photoFileImage = facultyPhotoUploadForm.down('#photoFileImage');
        	var fileUploadPath = photoFileImage.getValue();
        	if(!isNullOrEmpty(fileUploadPath)){
        		this$.savePhotoUploadForm(facultyPhotoUploadForm, personProfile.getPersonId(), SERVERURL.PERSON_IMAGE_UPLOAD, SERVERURL.PERSON_IMAGE_DOWNLOAD, function(success,photoUrl,version){
            		if(success){
            			if(!isNullOrEmpty(photoUrl)){
            				jsonFormatFormData.personVersion=version;
            	    		personProfile.personInfo.photoUrl=photoUrl;
            	    	}
            			this$.saveFacPersonInformationForm(jsonFormatFormData, photoUrl, isUpdate, SERVERURL.PERSON_IMAGE_DOWNLOAD,facultyProfileItemId,personInfo);
            		}
            		
            	});
        	}else{
        		var photoUrl = personInfo.photoUrl;
        		this$.saveFacPersonInformationForm(jsonFormatFormData, photoUrl, isUpdate, SERVERURL.PERSON_IMAGE_DOWNLOAD,facultyProfileItemId,personInfo);
        	}
        	
	    }
    },
    
    saveFacPersonInformationForm: function(jsonFormatFormData, photoUrl, isUpdate,downloadUrl,facultyProfileItemId,personInfo){

    	var this$ = this;
        jsonFormatFormData.photoUrl = photoUrl;
        jsonFormatFormData = this$.setFacultyJsonfromatData(jsonFormatFormData, personInfo, isUpdate);
        jsonFormatFormData = Ext.encode(jsonFormatFormData);
        
        this.sendSaveAjaxRequest(SERVERURL.FACULTY_PERSONAL_INFORMATION_UPDATE, 'POST', jsonFormatFormData, function(option, success, response) {
	        	if(success){
	        		showSuccessMessage(getPersonModuleTranslation('PERSONAL_INFORMATION'), getPersonModuleTranslation('FACULTY_PERSONAL_SUBMIT_SUCCESS'));
	        		this$.setUploadedPhotoToPersonProfile(downloadUrl);
	        		this$.onRenderFacultyPersonalInformationForm();
	                this$.getFacultyProfileInformation(facultyProfileItemId);
	                //this$.mixins.FacultyListController.loadFacultyListGridStore();
	    		}
	        });
    },
    
    setFacultyJsonfromatData: function(jsonObj, personInfo) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var data = new Object();
        data.id = jsonObj.id;
        data.version = jsonObj.version;
        data.firstName = jsonObj.firstName;
        data.code = jsonObj.code
        data.lastName = jsonObj.lastName;
        data.shortName = jsonObj.shortName;
        data.department = jsonObj.department;
        data.subDepartment = jsonObj.subDepartment;
        data.designation = jsonObj.designation;
        data.facultyType = jsonObj.facultyType;
        data.joiningDate = jsonObj.joiningDate;
        data.exitDate = jsonObj.exitDate;
        data.dateOfExit=jsonObj.exitDate;
        data.yearsOfExperience = jsonObj.yearsOfExperience;
        data.calender = personInfo.calender;
        data.accountingKey = jsonObj.accountingKey;
        data.leaveCategory = jsonObj.leaveCategory;
        
        var middleName = jsonObj.middleName;
        if (!isNullOrEmpty(middleName)) {
        	data.middleName = middleName;
        }
        
        var category = jsonObj.category;
        if (isNullOrEmpty(category)) {
        	jsonObj.category = null;
        }
        var maritalStatus = jsonObj.maritalStatus;
        if (isNullOrEmpty(maritalStatus)) {
            jsonObj.maritalStatus = null;
        }
        var bloodGroup = jsonObj.bloodGroup;
        if (isNullOrEmpty(bloodGroup)) {
            jsonObj.bloodGroup = null;
        }
        var religion = jsonObj.religion;
        if (isEmpty(religion) || isNullOrEmpty(religion.id)) {
            jsonObj.religion = null;
        }
        var domicile = jsonObj.domicile;
        if (isEmpty(domicile) || isNullOrEmpty(domicile.id)) {
            jsonObj.domicile = null;
        }
        var castCategory = jsonObj.castCategory;
        if (isEmpty(castCategory) || isNullOrEmpty(castCategory.id)) {
            jsonObj.castCategory = null;
        }
        var bankDetail = new Object();
        this$.setJsonfield(jsonObj, bankDetail, "id", "bankDetailsId");
        this$.setJsonfield(jsonObj, bankDetail, "version", "bankDetailsVersion");
        this$.setJsonfield(jsonObj, bankDetail, "bankName", "bankName");
        this$.setJsonfield(jsonObj, bankDetail, "accountNumber", "accountNumber");
        this$.setJsonfield(jsonObj, bankDetail, "branchName", "branchName");
        this$.setJsonfield(jsonObj, bankDetail, "ifsCode", "ifsCode");
        this$.setJsonfield(jsonObj, bankDetail, "beneficiaryName", "beneficiaryName");
        this$.setJsonfield(jsonObj, bankDetail, "accountTypeId", "accountTypeId");
       /* bankDetail.person = {
                id: jsonObj.personId
    	};*/
        
        
        
       
        jsonObj["bankDetail"] = bankDetail;
        
        var wsApplPhyChars = new Object();
        this$.setJsonfield(jsonObj, wsApplPhyChars, "id", "phyId");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "version", "phyVersion");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "height", "height");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "weight", "weight");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "hairColor", "hairColor");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "eyeColor", "eyeColor");                
        if(isNullOrEmpty(wsApplPhyChars.id) && isNullOrEmpty(wsApplPhyChars.version) && isNullOrEmpty(wsApplPhyChars.height) 
        		&& isNullOrEmpty(wsApplPhyChars.weight) && isNullOrEmpty(wsApplPhyChars.hairColor) && isNullOrEmpty(wsApplPhyChars.eyeColor)){
        	jsonObj["physicalCharacteristics"] = null;
        }else{
        	jsonObj["physicalCharacteristics"] = wsApplPhyChars;
        }
        
        jsonObj.id = jsonObj.personId;
        jsonObj.version = jsonObj.personVersion;
        
        /*********employee Language******/
        var $this=this;
        var departmentArray = [];
        var totalWeightage=0;
        var duplicateIdMap = new Ext.util.HashMap();
        var duplicateIdFlag=false;
        var courseDepartmentCombo=null;
       var courseSubDepartmentCombo=null
        if (!isNullOrEmpty($this.getPersonalInformationForm().down('#serviceStopPanelId').items.items)
    			&& $this.getPersonalInformationForm().down('#serviceStopPanelId').items.items.length > 1) {
        	courseDepartmentCombo = this.getIdValueJson(jsonObj.employeeLanguage[0], jsonObj.employeeLanguage[0]);
        	

        	for (var i = 0; i < $this.getPersonalInformationForm().down('#serviceStopPanelId').items.items.length; i++) {
        		var newData = {
    					"multiLanguage" : $this.getIdValueJson(jsonObj.employeeLanguage[i],jsonObj.employeeLanguage[i]),
    					"read" :  $this.getIdValueJson(jsonObj.read[i],jsonObj.read[i]),
    					"speak" : $this.getIdValueJson(jsonObj.speak[i],jsonObj.speak[i]),
    					"write" :$this.getIdValueJson(jsonObj.write[i],jsonObj.write[i]),
    					"person":$this.getIdValueJson(jsonObj.id,jsonObj.id),
    				//	"id":$this.getIdValueJson(jsonObj.langId[i],jsonObj[i]),
    					"id":jsonObj.langId[i]
    			};
        		if(!isNullOrEmpty(newData.multiLanguage)){
        			delete newData.multiLanguage.value
        		}
        		if(duplicateIdMap.containsKey(jsonObj.employeeLanguage[i])){
        			duplicateIdFlag=true;
        			break;
        		}
        		duplicateIdMap.add(jsonObj.employeeLanguage[i], i);
        		//totalWeightage=totalWeightage+parseInt(value.weightage[i]);
        		departmentArray.push(newData);
        		}
    		
        }else if(!isNullOrEmpty($this.getPersonalInformationForm().down('#serviceStopPanelId').items.items)
    			&& $this.getPersonalInformationForm().down('#serviceStopPanelId').items.items.length == 1){
        	courseDepartmentCombo = this.getIdValueJson(jsonObj.employeeLanguage, jsonObj.employeeLanguage);
        	//courseSubDepartmentCombo = this.getIdValueJson(value.subDepartmentName,value.subDepartmentName);

        	var newData = {
        			"multiLanguage" : $this.getIdValueJson(jsonObj.employeeLanguage,jsonObj.employeeLanguage),
					"read" :  $this.getIdValueJson(jsonObj.read,jsonObj.read),
					"speak" : $this.getIdValueJson(jsonObj.speak,jsonObj.speak),
					"write" :$this.getIdValueJson(jsonObj.write,jsonObj.write),
					"person":$this.getIdValueJson(jsonObj.id,jsonObj.id),
					"id":jsonObj.langId,
					
			};
        	if(!isNullOrEmpty(newData.multiLanguage)){
        		delete newData.multiLanguage.value
        	}
        	departmentArray.push(newData);
        	//totalWeightage=totalWeightage+parseInt(value.weightage);
        }
       /**********************************************************************************/
       /****disabilities json start***/
       var disabilityJsonArry = [];
      	if(!isNullOrEmpty(jsonObj.haveDisabilities) && !isNullOrEmpty(jsonObj.haveDisabilities[0])){
     		Ext.each(jsonObj.haveDisabilities, function(currentDisability){
             	var haveDisabilities = '';
             	var studentPerson = '';
             	var mainObj = '';
             	var disabilityId = '';
             	try{
             		disabilityId = currentDisability.data.id;
             	}
             	catch(e){
             		disabilityId = currentDisability.id;
             	}
             	if(!isNullOrEmpty(disabilityId)){
            		mainObj = {
            				"haveDisabilities" : {
            					"id" : disabilityId
          				},
         				"studentPerson" : {
          					"id": personProfile.getPersonInfo().id
          				}		
            		}
             		disabilityJsonArry.push(mainObj);
             	}
             });	
     	}
       /***disabilities json start ******/
       
       // var stopContiner = form.down('#serviceStopPanelId');
       // var langContiner = form.down('#serviceStopPanelId');
    	//var stopFieldsCount = stopContiner.items.length;
    	//var langFieldsCount = stopContiner.items.length;
       jsonObj["languageCompetency"] = departmentArray;
       jsonObj["personDisability"]=disabilityJsonArry;
       jsonObj["birthPlace"]=jsonObj.placeOfBirth;
       jsonObj["birthPlaceOtherLanguage"]=jsonObj.placeOfBirthOtherLang;
       //jsonObj["birthPlaceOtherLanguage"]=jsonObj.placeOfBirthOtherLang;
       delete jsonObj.placeOfBirth;
       delete jsonObj.placeOfBirthOtherLang;
        delete jsonObj.code;
        delete jsonObj.langId;
        delete jsonObj.personId;
        delete jsonObj.leaveCategory;
        delete jsonObj.personVersion;
        delete jsonObj.department;
        delete jsonObj.subDepartment;
        delete jsonObj.designation;
        delete jsonObj.facultyType;
        delete jsonObj.joiningDate;
        delete jsonObj.employeeLanguage;
        delete jsonObj.read;
        delete jsonObj.speak;
        delete jsonObj.write;
        delete jsonObj.exitDate;
        delete jsonObj.yearsOfExperience;
        delete jsonObj.accountingKey;
        delete jsonObj.checkboxDropdown;
        delete jsonObj.haveDisabilities;
        
      //TODO: Remove this custom data part deletion once customdata is applied
		//delete jsonObj.customData;
		
        data.person = jsonObj;
        return data;
    },
    
    
    

    getFacultyAddressDetailTemplateData: function() {
        var this$ = this;
        var facultyProfile = this$.getContentPanelActiveTab();
        //console.log('facultyProfile',facultyProfile);
        var addressDetails = facultyProfile.down('#facultyAddressDetails');
        //console.log('addressDetails',addressDetails);
        var personInfo = facultyProfile.getPersonInfo();
        var personId = personInfo["id"];
        if (!isNullOrEmpty(personId)) {
        	addressDetails.setAddressPersonId(personId);
        	//Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	this$.sendGetAjaxRequest(SERVERURL.PERSON_ADDRESS_DETAILS + personId, 'GET', null, function(option, success, response) {
            	if(success){
            		var data = Ext.decode(response.responseText);
                    this$.setAddressTemplateDisplayField('#facultyAddressDetails', data, 'SELF_ADDRESS');
                    addressDetails.setAddressTemplateData(data);
                    if(this$.getCurrentLoggedPortalId() == 1) {
                    	this$.disableEmployeeProfileAddressPrivileges(addressDetails, this$.getEMPLOYEE_PROFILE_ADDRESS_PERMISSION());
                    } if(portalId == 2) {
                    	this$.disableEmployeeProfileAddressPrivileges(addressDetails,this$.getFACULTY_PORTAL_ADDRESS_DETAILS_PERMISSION());	
                	}
                    Ext.getBody().unmask();
            	}
            });
        }
    },

    /*
     *  save the address details
     */
    saveFacultyAddressDetails: function() {
        var this$ = this;
        var facultyProfile = this$.getContentPanelActiveTab();
        var personInfo = facultyProfile.getPersonInfo();
        var personObj = this$.getPersonObj();
        var formAddressData = this.getPersonAddressFormWindow().getFormAddressData();
        var form = this.getPersonAddressFieldsForm().getForm();
        if (form.isValid()) {

            var values = form.getValues();

                var address = new Academia.model.organization.Address();
                var submitUrl;
                var successMessage;
                var id = form.findField('id').getSubmitValue();
                form.updateRecord(address);
                var jsonObj = new Object();
                address.set('country', this$.mixins.AddressController.getIdValueJson(values.country));
                address.set('parentCountryRegion', this$.mixins.AddressController.getIdValueJson(values.parentCountryRegion));
                address.set('countryRegion', this$.mixins.AddressController.getIdValueJson(values.countryRegion));
                address.set('city', this$.mixins.AddressController.getIdValueJson(values.city));
                address.set('addressType', this$.mixins.AddressController.getIdValueJson(values.addressType));

                if(form.findField('pincodeNew').isHidden()){
                	delete address.data.pincodeNew;
                }else if(form.findField('pincode').isHidden()){
                	address.data.pincode = '';
                }
                jsonObj.address = address.data;

                jsonObj.id = formAddressData["id"];
                jsonObj.version = formAddressData["version"];
                jsonObj.person = personObj;
                jsonObj.isDeleted = personInfo["isDeleted"];
                jsonObj.addressType = this$.mixins.AddressController.getIdValueJson(values.addressType);
                jsonObj.isPrimary = values.isPrimary;
                jsonObj.type = 'SELF_ADDRESS';
                jsonObj.address.customData = values.customData;

                var formData = Ext.encode(jsonObj);
                
                
                if (isNullOrEmpty(id)) {
                    submitUrl = SERVERURL.PERSON_ADDRESS_ADD;
                    successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
                } else {
                    submitUrl = SERVERURL.PERSON_ADDRESS_UPDATE;
                    successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
                }
                
                var otherAddressTypeIds=[];
                var otherAddressVals = form.findField('otherAddressTypeId').getValue();
				if(otherAddressVals != undefined && otherAddressVals.length > 0){
					if(!isNaN(otherAddressVals[0])){
						if(otherAddressVals[0] !=""){
							otherAddressTypeIds.push(otherAddressVals[0].data.id);	
						}
					}
					else{
						for(var i in otherAddressVals){
							otherAddressTypeIds.push(otherAddressVals[i].data.id);
						}
					}
				}
				
                submitUrl = submitUrl+'?otherAddressTypes='+otherAddressTypeIds.join();
                this$.applyWindowMask();
                
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.PERSON_IS_ADDRESS_EXIST + '?personId=' +personObj.id +'&otherAddressTypes='+ otherAddressTypeIds.join() ,
                    method: 'GET',
                    success: function(form, action) {
                    	var response = Ext.decode(form.responseText);
                    	if(response.length>0){
                    		this$.hideWindowMask();
                    		var message = 'Are you sure, you want to continue?';
                    		showConfirmMessage(getCommonTranslation('WARNING'),message, function(btn, text) {
    	                        if (btn == 'yes') {
    	                        	this$.applyWindowMask();
    	                        	Ext.Ajax.request({
    	                                type: 'rest',
    	                                url: submitUrl,
    	                                jsonData: formData,
    	                                method: 'POST',
    	                                success: function(form, action) {
    	                                	this$.hideWindowMask();
    	                                	this$.getPersonAddressFormWindow().close();
    	                                    showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
    	                                    this$.getFacultyAddressDetailTemplateData();
    	                                    
    	                                }
    	                            });
    	                        }
                    		});
                    	}
                    	else{
                    		Ext.Ajax.request({
                                type: 'rest',
                                url: submitUrl,
                                jsonData: formData,
                                method: 'POST',
                                success: function(form, action) {
                                	this$.hideWindowMask();
                                	this$.getPersonAddressFormWindow().close();
                                    showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
                                    this$.getFacultyAddressDetailTemplateData();
                                    
                                }
                            });
                    	}
                    }
                });
        }
    },setPrintNameValue:function(textfield){
    	var form = textfield.up('form');
    	var getForm=form.getForm();
    	var firstName = getForm.findField('firstName').getValue();
    	var middleName = getForm.findField('middleName').getValue();
    	var lastName = getForm.findField('lastName').getValue();
    	
    	var printName=null;
    	if(isNullOrEmpty(middleName)){
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+lastName;
    		}else{
    			printName =firstName;
    		}
    	}else{
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+middleName+" "+lastName ;
    		}else{
    			printName =firstName+" "+middleName ;
    		}
    	}
    	printName=printName.trim();
    	var task = new Ext.util.DelayedTask(function(){
    		getForm.findField('printName').setValue(printName.replace(/ +/g, " "));
    	});
    	task.delay(50);
    },
    
    setPrintNameOtherLnguageValue:function(textfield){
    	var form = textfield.up('form');
    	var getForm=form.getForm();
    	var firstName = getForm.findField('firstNameOtherLanguage').getValue();
    	var middleName = getForm.findField('middleNameOtherLanguage').getValue();
    	var lastName = getForm.findField('lastNameOtherLanguage').getValue();
    	
    	var printName=null;
    	if(isNullOrEmpty(middleName)){
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+lastName;
    		}else{
    			printName =firstName;
    		}
    	}else{
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+middleName+" "+lastName ;
    		}else{
    			printName =firstName+" "+middleName ;
    		}
    	}
    	printName=printName.trim();
    	var task = new Ext.util.DelayedTask(function(){
    		getForm.findField('printNameOtherLanguage').setValue(printName.replace(/ +/g, " "));
    	});
    	task.delay(50);
    },
    
    setLeaveCategoryValue:function(combo){
    	var form = combo.up('form');
    	var getForm=form.getForm();
    	var leaveCategory = getForm.findField('leaveCategory').getValue();
    	
    	
    	var task = new Ext.util.DelayedTask(function(){
    		getForm.findField('leaveCategory').setValue(leaveCategory);
    	});
    	task.delay(50);
    },
    disableOtherDetailSectionPivileges: function(form,permissionsMap){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var otherDetailsFacultyFieldSet=form.down('#otherDetailsFacultyFieldSet');
    	otherDetailsFacultyFieldSet.setVisible(false);
     	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			if(!isNullOrEmpty(otherDetailsFacultyFieldSet)){
    				otherDetailsFacultyFieldSet.setVisible(true);
    			}        		
    		}
    	});
    }, 
    disableBankDetailSectionPivileges: function(form,permissionsMap){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var bankDetailsFieldSet=form.down('#bankDetailsFieldSet');
    	bankDetailsFieldSet.setVisible(false);
     	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			if(!isNullOrEmpty(bankDetailsFieldSet)){
    				bankDetailsFieldSet.setVisible(true);
    			}        		
    		}
    	});
    },
    disableContactInfoSectionPivileges: function(form,permissionsMap){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var contactFieldSet=form.down('#contactFieldSet');
    	contactFieldSet.setVisible(false);
     	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			if(!isNullOrEmpty(contactFieldSet)){
    				contactFieldSet.setVisible(true);
    			}        		
    		}
    	});
    },
    disablePersonalInfoSectionPivileges: function(form,permissionsMap){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var personalFormField=form.down('#personalFormField');
    	personalFormField.setVisible(false);
    	var facultyDeptDetails=form.down('#facultyDeptDetails');
    	facultyDeptDetails.setVisible(false);
     	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			if(!isNullOrEmpty(personalFormField) && !isNullOrEmpty(facultyDeptDetails)){
    				personalFormField.setVisible(true);
    				facultyDeptDetails.setVisible(true);
    			}        		
    		}
    	});
    },
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	//buttonsToolBar = gridReference.query('toolbar')[0];
    	//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
    	var splitbuttons = gridReference.down('#personalInfoSaveButtonId');
    	splitbuttons.setVisible(false);
    	/*Ext.each(splitbuttons.menu.items.items, function(menuItems) {
    		menuItems.setVisible(false);
    	});*/
    	var employeeVerifyDetailsBtn = gridReference.down('#employeeVerifyDetail');
    	var facultyPhotoUploadForm = gridReference.down('#facultyPhotoUploadForm');
    	
    	employeeVerifyDetailsBtn.setVisible(false);
    	facultyPhotoUploadForm.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVEBUTTON') {
    			//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
    			if(!isNullOrEmpty(splitbuttons)){
    				splitbuttons.setVisible(true);
    			}        		
    		}
    		if (privilege === 'VERIFY_DETAILS_BUTTON') {
    			if(!isNullOrEmpty(employeeVerifyDetailsBtn)){
    				employeeVerifyDetailsBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'UPLOAD_IMAGE') {
    			if(!isNullOrEmpty(employeeVerifyDetailsBtn)){
    				facultyPhotoUploadForm.setVisible(true);
    			}        		
    		}
    	});
    },
    
    disableOtherInformaionFormPivileges: function(formReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	//associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var saveBtn = formReference.down('#submitButtonId');
    	saveBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVE') {
    			if(!isNullOrEmpty(saveBtn)){
    				saveBtn.setVisible(true);
    			}        		
    		}
    		
    	});
    },
    
    disableAddressPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	//buttonsToolBar = gridReference.query('toolbar')[0];
    	//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
    	var splitbuttons = gridReference.down('#submitButtonId');
    	splitbuttons.setVisible(false);
    	/*Ext.each(splitbuttons.menu.items.items, function(menuItems) {
    		menuItems.setVisible(false);
    	});*/
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVEBUTTON') {
    			//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
    			if(!isNullOrEmpty(splitbuttons)){
    				splitbuttons.setVisible(true);
    			}        		
    		}
    		
    	});
    },
    
    /**
     * Active my dashboard tab for student 
     * @author Rajkumar.patidar 
     */
    getActiveMyDashboard : function(){
    	var this$ = this;
    	var studentProfile = this$.getContentPanelActiveTab();
    	var personInfoPanel = studentProfile.down('personinfopanel');
    	var tabName = getCommonTranslation('MY_DASHBOARD');
    	var contentXtype ='facultyinfodashboardhomepage';

    	var	newTab = personInfoPanel.add({
    		xtype: contentXtype,
    		closable: false,
    		title: tabName
    	});
    	personInfoPanel.setActiveTab(newTab);
    },
    
    getAllPermissions: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	$$this = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPastHistoryController');
    	$$$this = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyCourseExecutionController');
    	documentController = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyDocumentController');
    	serviceController = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyServiceController');
    	disciplinaryController = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyDisciplinaryController');
    	paymentAndRefundController = Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPaymentRefundController');
    	var returnJson = new Ext.util.HashMap();
    	
    	var viewAddressDetails = this.getFACULTY_PORTAL_ADDRESS_DETAILS_PERMISSION();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewAddressDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isAddress", true);
    		}
    	});
    	
    	var viewPersonalDetails = this.getFACULTY_PORTAL_PERSONAL_INFORMATION_PERMISSION();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPersonalDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isPersonalDetails", true);
    		}
    	});
    	var viewPatentDetails = $$this.getFACULTY_PATENT_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPatentDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isPatent", true);
    		}
    	});
    	var viewEducationDetails = $$this.getFACULTY_EDUCATION_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewEducationDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isEducation", true);
    		}
    	});
    	var viewWorkExperienceDetails = $$this.getFACULTY_WORK_EXPERIENCE_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewWorkExperienceDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isWorkExp", true);
    		}
    	});
    	var viewTrainingDetails = $$this.getFACULTY_TRAINING_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewTrainingDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isTraining", true);
    		}
    	});
    	var viewResearchDetails = $$this.getFACULTY_RESEARCH_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewResearchDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isResearch", true);
    		}
    	});
    	var viewSeminarDetails = $$this.getFACULTY_SEMINAR_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewSeminarDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isSeminar", true);
    		}
    	});
    	var viewPNCs = $$$this.getFACULTY_PROGRAM_COURSE_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPNCs);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isPNC", true);
    		}
    	});
    	var viewReceipt = paymentAndRefundController.getFACULTY_PAYMENT_RECIEVED_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewReceipt);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isReceipt", true);
    		}
    	});
    	var viewBilling = paymentAndRefundController.getFACULTY_PENDING_BILLS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewBilling);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isBilling", true);
    		}
    	});
    	var viewRefund = paymentAndRefundController.getFACULTY_REFUNDS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewRefund);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isRefund", true);
    		}
    	});
    	var viewPositiveIncident = disciplinaryController.getFACULTY_POSITIVE_INCIDENTS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPositiveIncident);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isPositiveIncident", true);
    		}
    	});
    	var viewDisciplinaryAction = disciplinaryController.getFACULTY_DISCIPLINARY_ACTIONS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewDisciplinaryAction);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isDisciplinaryAction", true);
    		}
    	});
    	var viewDocument = documentController.getFACULTY_DOCUMENTS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewDocument);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isDocument", true);
    		}
    	});
    	var viewServiceOptInOptOut = serviceController.getFACULTY_SERVICE_OPT_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewServiceOptInOptOut);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isService", true);
    		}
    	});
    	var viewCompetitive = $$this.getFACULTY_COMPETITIVE_EXAM_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewCompetitive);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isCompetitive", true);
    		}
    	});
    	var viewExtracurricularActivity = $$this.getFACULTY_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewExtracurricularActivity);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isExtracurricularActivity", true);
    		}
    	});
    	var viewVaccination = $$this.getFACULTY_VACCINATION_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewVaccination);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isVaccination", true);
    		}
    	});
    	var viewMedical = $$this.getFACULTY_MEDICAL_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewMedical);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isMedical", true);
    		}
    	});
	return returnJson;
    },
    
    disableEmployeeProfileAddressPrivileges: function(gridreference, permissionList) {
    	this.getProfileAddressPrivileges(gridreference, permissionList);
    },
    
    exportPDFFacultyFamilyDetailReport : function(){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personId;
    	var applicationId;
    	var portalId = this$.getCurrentLoggedPortalId();
    	try{
    		personId = personProfile.getPersonId();
    		applicationId = personProfile.applicationId;
    	}catch(e){
    		personId = this$.getContentPanel().items.items[0].getPersonId();
    		applicationId = this$.getContentPanel().items.items[0].applicationId;
    	}
    	var code = 'EMPLOYEE_FAMILY_DETAIL__REPORT_PDF';
    	var reportParams =new Object();
    	reportParams.personId = personId;
    	reportParams.headerName = 'Family Details Report';
    	var reportTitle="Family Details Report";
    	this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PATH_FIND_FAMILY_DETAIL_PDF_REPORT);
    },
    exportXLFacultyFamilyDetailReport : function(){
		var this$ = this;
		var personProfile = this$.getContentPanelActiveTab();
		var personId;
		var applicationId;
		var portalId = this$.getCurrentLoggedPortalId();
		try{
			personId = personProfile.getPersonId();
			applicationId = personProfile.applicationId;
		}catch(e){
			personId = this$.getContentPanel().items.items[0].getPersonId();
			applicationId = this$.getContentPanel().items.items[0].applicationId;
		}
		var code = 'FAMILY_DETAILS_REPORT_EXCEL';
		var reportParams =new Object();
		reportParams.personId = personId;
		reportParams.headerName = 'Family Details  Report';
		var reportTitle="Family Details  Report";
		this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PATH_FIND_FAMILY_DETAIL_EXCEL_REPORT);
	},
	loadDFRForLanuageCompentcy: function(employeeLanguageField,writeField,readField,speakField,addBtn){
		var $this = this;
		var personProfile = $this.getContentPanelActiveTab();
		var form = personProfile.down('employeepersonalinformationform');
		$this.empLanguageDFR=[];
		var allowblankFalse = '<span class="required" style="color:red"> *</span>';
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		params: {
    			screenName: 'employeepersonalinformationform',
    			academyLocationId: this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.employeepersonalinformationform;
    				for(i in records){
    					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='employeeLanguage'){
    						employeeLanguageField.setFieldLabel(records[i].formFieldLabel);
    						$this.empLanguageDFR.push(records[i]);
    						if(records[i].isMandatory == true){
    							employeeLanguageField.setFieldLabel(records[i].formFieldLabel+allowblankFalse);
        						readField.setFieldLabel(getCommonTranslation('READ')+allowblankFalse);
    							writeField.setFieldLabel(getCommonTranslation('WRITE')+allowblankFalse);
    							speakField.setFieldLabel(getCommonTranslation('SPEAK')+allowblankFalse);
    							$this.setAllowBlank(employeeLanguageField, false);
    							$this.setAllowBlank(readField, false);
    							$this.setAllowBlank(writeField, false);
    							$this.setAllowBlank(speakField, false);
    						}
    						if(records[i].isVisible == false){
    							employeeLanguageField.setVisible(false);
    							readField.setVisible(false);
    							writeField.setVisible(false);
    							speakField.setVisible(false);
    							addBtn.setVisible(false);
    							$this.setAllowBlank(employeeLanguageField, true);
    							$this.setAllowBlank(readField, true);
    							$this.setAllowBlank(writeField, true);
    							$this.setAllowBlank(speakField, true);
    						}
    					}
    				}
    			}
    		}
    		
    	});
    	
    },
    saveQualificationDetailForm:function(btn){
    	if (typeof btn.lastExecutionTime === 'undefined') {
    		btn.lastExecutionTime = 0;
    	}
    	var currentTime = new Date().getTime();
    	// Prevent function execution if called within the last 5+ seconds
    	if (currentTime - btn.lastExecutionTime < 5000) {
    		console.log('Function call skipped to prevent duplicate execution');
    		return false;
    	}
    	// Update last execution time
    	btn.lastExecutionTime = currentTime;
    	var json,submitUrl,$this = this,
    	facultyProfile = this.getContentPanelActiveTab(),
    	form = this.getQualificationdetailswin(),
    	grid = facultyProfile.down('qualificationdetailsgrid'),
    	formValues = form.down('form').getValues();
    	var employeeId = facultyProfile.getUserId();
    	if(formValues.recordId){
    		submitUrl=SERVERURL.PATH_UPDATE_EMPLOYEE_QUALIFICATION ;
    		json= {
    				user:$this.getIdValueJson(employeeId),
    				id:formValues.recordId,
    				qualificationType:$this.getIdValueJson(formValues.qualificationType),
    				qualificationCategory:$this.getIdValueJson(formValues.qualificationCategory),
    				qualificationName:$this.getIdValueJson(formValues.qualificationName),
    				qualificationMajor1:$this.getIdValueJson(formValues.major1),
    				qualificationMajor2:$this.getIdValueJson(formValues.major2),
    				qualificationMajor3:$this.getIdValueJson(formValues.major3),
    				qualificationHEQFLevel:$this.getIdValueJson(formValues.HEQFLevel),
    				qualificationInstitution:$this.getIdValueJson(formValues.institution),
    				qualificationStartDate:formValues.qualificationStartDate,
    				qualificationEndDate:formValues.qualificationEndDate,
    				isCompleted:(formValues.completed)?true:false,
    				qualificationApprovalLevel:$this.getIdValueJson(formValues.qualificationApprovalLevel),
    				qualificationUsedInApproval:$this.getIdValueJson(formValues.qualificationUsedInApproval)
    		};
    	}else{
    		submitUrl=SERVERURL.PATH_SAVE_EMPLOYEE_QUALIFICATION;
    		json= {
    				user:$this.getIdValueJson(employeeId),
    				qualificationType:$this.getIdValueJson(formValues.qualificationType),
    				qualificationCategory:$this.getIdValueJson(formValues.qualificationCategory),
    				qualificationName:$this.getIdValueJson(formValues.qualificationName),
    				qualificationMajor1:$this.getIdValueJson(formValues.major1),
    				qualificationMajor2:$this.getIdValueJson(formValues.major2),
    				qualificationMajor3:$this.getIdValueJson(formValues.major3),
    				qualificationHEQFLevel:$this.getIdValueJson(formValues.HEQFLevel),
    				qualificationInstitution:$this.getIdValueJson(formValues.institution),
    				qualificationStartDate:formValues.qualificationStartDate,
    				qualificationEndDate:formValues.qualificationEndDate,
    				isCompleted:(formValues.completed)?true:false,
    				qualificationApprovalLevel:$this.getIdValueJson(formValues.qualificationApprovalLevel),
    				qualificationUsedInApproval:$this.getIdValueJson(formValues.qualificationUsedInApproval)
    		};
    	}
    	var formData = Ext.encode(json);
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');   	
		Ext.Ajax.request({
			type: 'rest',
			url:submitUrl,
			jsonData: formData,
			method: 'POST',
			success: function(response) {
				if(formValues.recordId){
					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
				}else{
					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
				}
				grid.getStore().load();
				grid.getSelectionModel().deselectAll();
				$this.getQualificationdetailswin().close();	 
				Ext.getBody().unmask();
			}
		});
    },
    getIdValueJson: function(id, value) {
        if (id) return {
            id: id
        };
    },
    openQualificationDetailsWin:function(){
    	var facultyProfile = this.getContentPanelActiveTab(),
    	grid = facultyProfile.down('qualificationdetailsgrid');
    	if (grid.getSelectionModel().getCount() > 0) {
    		var win = this.getQualificationdetailswin();
    		if (!win) {
    			Ext.widget('qualificationdetailswin');
    			win = this.getQualificationdetailswin();
    		}
    		win.show();
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    setDataOnQualificationForm:function(mode){
    	//this.setDFRForQualificationsForm();
    	var data,facultyProfile = this.getContentPanelActiveTab(),
    	grid = facultyProfile.down('qualificationdetailsgrid'),
    	userId=facultyProfile.getUserId();
    	grid = facultyProfile.down('qualificationdetailsgrid');
    	if (grid.getSelectionModel().getCount() > 0) {
    		var form = this.getQualificationdetailswin(),
    		recordId = form.down('#recordId'),
    		qualificationType=form.down('#qualificationType'),
    		qualificationCategory=form.down('#qualificationCategory'),
    		qualificationName=form.down('#qualificationName'),
    		major1=form.down('#major1'),
    		major2=form.down('#major2'),
    		major3=form.down('#major3'),
    		heqlLevel=form.down('#HEQFLevel'),
    		institution=form.down('#institution'),
    		qualificationStartDate=form.down('#qualificationStartDate'),
    		qualificationEndDate=form.down('#qualificationEndDate'),
    		completed=form.down('#completed'),
    		qualificationApprovalLevel=form.down('#qualificationApprovalLevel'),
    		qualificationUsedInApproval=form.down('#qualificationUsedInApproval'),
    		selectedRecord = grid.getSelectionModel().getSelection()[0];

    		if(selectedRecord){
    			var data = selectedRecord.data;
    			recordId.setValue(data.id);
    			completed.setValue(data.isCompleted);
    			qualificationStartDate.setValue(dateRender(data.qualificationStartDate));
    			qualificationEndDate.setValue(dateRender(data.qualificationEndDate));
    			qualificationType.getStore().load({
    				callback: function(records, operation, success) {
    					qualificationType.setValue(data.qualificationTypeId);
    				}
    			});
    			qualificationCategory.getStore().load({
    				callback: function(records, operation, success) {
    					qualificationCategory.setValue(data.qualificationCategoryId);
    				}
    			});
    			qualificationName.getStore().load({
    				callback: function(records, operation, success) {
    					qualificationName.setValue(data.qualificationNameId);
    				}
    			});
    			major1.getStore().load({
    				callback: function(records, operation, success) {
    					major1.setValue(data.qualificationMajor1Id);
    				}
    			});
    			major2.getStore().load({
    				callback: function(records, operation, success) {
    					major2.setValue(data.qualificationMajor2Id);
    				}
    			});
    			major3.getStore().load({
    				callback: function(records, operation, success) {
    					major3.setValue(data.qualificationMajor3Id);
    				}
    			});
    			heqlLevel.getStore().load({
    				callback: function(records, operation, success) {
    					heqlLevel.setValue(data.qualificationHEQFLevelId);
    				}
    			});
    			institution.getStore().load({
    				callback: function(records, operation, success) {
    					institution.setValue(data.qualificationInstitutionId);
    				}
    			});
    			qualificationApprovalLevel.getStore().load({
    				callback: function(records, operation, success) {
    					qualificationApprovalLevel.setValue(data.qualificationApprovalLevelId);
    				}
    			});
    			qualificationUsedInApproval.getStore().load({
    				callback: function(records, operation, success) {
    					qualificationUsedInApproval.setValue(data.qualificationUsedInApprovalId);
    				}
    			});
    		}
    		if(mode=='view'){
    			form.down('#qualificationDetailFormSave').setVisible(false);
    			toggleReadOnlyFormItems(form.down('form').getForm(),true);
    		}
    	}
    },
    addMultipleLanguageForFacultyProfile:function(){
	   	   var $this = this;
	   	   var personProfile = this.getContentPanelActiveTab();
	       var personalInformationForm = personProfile.down('employeepersonalinformationform');
	   	  var stopContiner = personalInformationForm.down('#serviceStopPanelId');
	   	   var indx = stopContiner.items.length;
	   	   var panelItem = new Array();
		   var insertPosition=indx;
		    panelItem.push({
		   		   xtype:'fieldcontainer',
		   		   width: '100%',
		   		   layout : 'hbox',
		   		   defaults : {
		   			   width: 226,
		   			   labelAlign : 'top'
		   		   },
		   		   items : [{
						xtype: 'hidden',
						itemId:'langItemId',
						name: 'langId'
				},{
						xtype : 'customcombobox',
						name : 'employeeLanguage',	
						itemId:'employeeLanguage',
						store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
						valueField: 'id',
						displayField: 'value',
						editable: false,
			            disableKeyFilter: false,
						forceSelection:true,
						width: 180,
						rowIndx:indx,
						hidden:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isVisible)?false:true):false,
						allowBlank:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isMandatory)?false:true):true,
						listeners:{
							select:function(obj,rec,value){
								var departmentId=rec[0].get('id');
								var employeeLanguage =  rec[0].data.employeeLanguage;
								var flag = true;
								var pnlMain = obj.up("#serviceStopPanelId");
								var rowIndx = obj.rowIndx;
								if(!isNullOrEmpty(pnlMain)){
									pnlMain.items.each(function(item, index, items) {
										var deptNameVal = item.down("[name=employeeLanguage]").getValue();
										if(departmentId == deptNameVal && rowIndx != index){
											flag = false;
											return false;
										}
									});

									if(flag){
										var nextSiblingField = obj.nextSibling();
										var write = obj.nextSibling().nextSibling();
										var speak = obj.nextSibling().nextSibling().nextSibling();
										nextSiblingField.reset();
										write.reset();
										speak.reset();
										if (departmentId > 0) {
											var writeStore=write.getStore();
											var speakStore=speak.getStore();
											
											var store=nextSiblingField.getStore();
											store.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											store.load();
											writeStore.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											writeStore.load();
											speakStore.getProxy().extraParams = {
												limit:-1,
												employeeLanguage : employeeLanguage
											};
											speakStore.load();
										}
									}
									else{
										obj.reset();
										var nextSiblingField = obj.nextSibling();
										var write = obj.nextSibling().nextSibling();
										var speak = obj.nextSibling().nextSibling().nextSibling();
										nextSiblingField.reset();
										write.reset();
										speak.reset();
										//nextSiblingField.setDisabled(true);
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
										return false;
									}
								}
								
							},
							change:function(obj,rec,value){
								var nextSiblingField = obj.nextSibling();
								nextSiblingField.reset();
								//nextSiblingField.setDisabled(true);

							}
						}
					},{
						xtype : 'customcombobox',
						name : 'read',	
						itemId:'readItemId1',
					    width: 105,
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						allowBlank:false,
						editable: false,
						valueField: 'id',
						displayField: 'value',
						hidden:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isVisible)?false:true):false,
						allowBlank:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isMandatory)?false:true):true,
						autoloadStore: false
					},{
						xtype : 'customcombobox',
						name : 'write',	
					    store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						itemId : 'writeItemId1',
						allowBlank:false,
						valueField: 'id',
						displayField: 'value',
						editable:false,
						hidden:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isVisible)?false:true):false,
						allowBlank:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isMandatory)?false:true):true,
						width: 105,
						autoloadStore: false,
					},{
						xtype : 'customcombobox',
						name : 'speak',
						itemId : 'speakItemId1',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						editable:false,
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						width: 105,
						hidden:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isVisible)?false:true):false,
						allowBlank:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isMandatory)?false:true):true,
						autoloadStore: false
			   	   },{
		   			   xtype: 'button',
		   			   glyph: ICONGLYPH.DELETEGLYPH,
		   			   cls: 'CustomBodyBtnReject',
		   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
		   			   width:30,
		   			   hidden:$this.empLanguageDFR.length>0?(($this.empLanguageDFR[0].isVisible)?false:true):false,
		   			   style:{
		   				   marginTop:'0px'
		   			   },
		   			   listeners:{
		   				   click:function(obj){
		   					   var container = obj.up('fieldcontainer');
		   					   var form;
		   					   var personProfile = $this.getContentPanelActiveTab();
		   					   if(personProfile){
		   						   form = personProfile.down('employeepersonalinformationform');
		   						   form.down('#serviceStopPanelId').remove(container);
		   						   form.getForm().checkValidity();
		   						   form.getForm().isValid();
		   						   form.getForm().clearInvalid();
		   					   } 
		   				   }
		   			   }
		   		   }]
		   	   });
	     	stopContiner.insert(insertPosition,panelItem);
	     	stopContiner.doLayout();
	      },
    setDFRForQualificationsForm:function(){
    	var facultyProfile = this.getContentPanelActiveTab();
    	var form = facultyProfile.down('qualificationdetailsform');
    	var $this = this;
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    		params: {
    			screenName: 'qualificationdetailsform',
    			academyLocationId: $this.getCurrentAcademyLocation(),
    			languageCode:'en'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if( Object.keys(response).length > 0 ){
    				var records=response.qualificationdetailsform;
    				for(i in records){  
    					var currentField = form.down("#"+records[i].formFieldId);
    					if(records[i].isVisible==false && records[i].isMandatory == true){
    						currentField.allowBlank=true;
						}
    				}
    			}
    		}
    	});
    },
    getDfrDataForPinCodes:function(form,pincode){
    	var fieldCmp,addressForm = form.getForm(),me = this,$form=form;
    	if(pincode=='dropdownPincode'){
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'addressformwindow',
    				academyLocationId: me.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				$form.addressDfrResponse=response;
    				if(response && Object.keys(response).length > 0 ){
    					response.addressformwindow.forEach(function(rec){
    							fieldCmp = form.down('#'+rec.formFieldId);
    							if(!fieldCmp){
    								fieldCmp = addressForm.findField(rec.formFieldName);
    							}
    							if(fieldCmp){
    								if(rec.formFieldId=='pincodeNewId'){
    									if(rec.isVisible){
    										me.setAllowBlank(fieldCmp, !rec.isMandatory);
    									}else{
    										fieldCmp.setVisible(false);
    										me.setAllowBlank(fieldCmp, true);
    									}
    								}else if(rec.formFieldId=='pincodeId'){
    									me.setAllowBlank(fieldCmp, true);
    								}
    								me.removeAddressFieldsDoubleColon(fieldCmp,rec.formFieldLabel);
    							}
    					});
    					Ext.defer(function() {
    						if(addressForm.isValid()){
    							$form.up('addressformwindow').down('#submitButtonId').setDisabled(false);
    						}else{
    							$form.up('addressformwindow').down('#submitButtonId').setDisabled(true);
    						}
				    	}, 500, this);
    				}
    			}
    		});
    	}else if(pincode=='pincode'){
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'addressformwindow',
    				academyLocationId: me.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				form.addressDfrResponse=response;
    				if(response && Object.keys(response).length > 0 ){
    					response.addressformwindow.forEach(function(rec){
    						fieldCmp = form.down('#'+rec.formFieldId);
    						if(!fieldCmp){
    							fieldCmp = addressForm.findField(rec.formFieldName);
    						}
    						if(fieldCmp){
    							if(rec.formFieldId=='pincodeId'){
    								if(rec.isVisible){
    									me.setAllowBlank(fieldCmp, !rec.isMandatory);
    								}else{
    									fieldCmp.setVisible(false);
    									me.setAllowBlank(fieldCmp, true);
    								}
    							}else if(rec.formFieldId=='pincodeNewId'){
    								me.setAllowBlank(fieldCmp, true);
    							}
    							me.removeAddressFieldsDoubleColon(fieldCmp,rec.formFieldLabel);
    						}
    					});
    					Ext.defer(function() {
    						if(addressForm.isValid()){
    							$form.up('addressformwindow').down('#submitButtonId').setDisabled(false);
    						}else{
    							$form.up('addressformwindow').down('#submitButtonId').setDisabled(true);
    						}
				    	}, 500, this);
    				}
    			}
    		});
    	}
    },
    removeAddressFieldsDoubleColon:function(field,dfrLable){
    	if(field && field.labelEl){
    		var asteriskOccurance = (field.labelEl.dom.textContent.match(/:/g) || []).length;
    		if(asteriskOccurance>1){
    			if(field.labelEl.dom.textContent.includes('*')){
    				field.labelEl.dom.innerHTML=dfrLable+':<span class="required" style="color:red"> *</span>';
    			}
    		}
    	}
    },
    saveEmpAdditionalDetailsForm:function(){
    	var facultyProfile = this.getContentPanelActiveTab();
    	var form = facultyProfile.down('empadditionaldetailsform');
		var values=form.getValues();
		var json=new Object();
        var employeeId = facultyProfile.getUserId();
		json.abbreviatedCurriculumVitaeInformation=values.abbreviatedCurriculumVitaeInformation;
		json.amendmentOfExaminer=values.amendmentOfExaminer;
		json.approvalBody=values.approvalBody;
		json.approvalBodyName=values.approvalBodyName;
		json.approvalDate=values.approvalDate;
		json.deviationFromNormalRequirements=values.deviationFromNormalRequirements;
		json.nominationOfExternalExaminer=values.nominationOfExternalExaminer;
		json.nominationOfInternalExaminer=values.nominationOfInternalExaminer;
		json.nominationOfInternationalExaminer=values.nominationOfInternationalExaminer;
		json.numberOfArticlesInPeerReviewedOrRefereedJournals=values.numberOfArticlesInPeerReviewedOrRefereedJournals;
		json.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst=values.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst;
		json.numberOfConferencesAndSymposia=values.numberOfConferencesAndSymposia;
		json.numberOfConferencesAndSymposiaAsFirst=values.numberOfConferencesAndSymposiaAsFirst;
		json.numberOfCurrentMasterStudents=values.numberOfCurrentMasterStudents;
		json.numberOfCurrentPhDStudents=values.numberOfCurrentPhDStudents;
		json.numberOfMasterDegreeCompleted=values.numberOfMasterDegreeCompleted;
		json.numberOfMasterDegreeSupervisedOverFiveYears=values.numberOfMasterDegreeSupervisedOverFiveYears;
		json.numberOfPHDsCompleted=values.numberOfPHDsCompleted;
		json.numberOfPhDsSupervisedOverLastFiveYears=values.numberOfPhDsSupervisedOverLastFiveYears;
		json.numberOfPublishedConferencePapers=values.numberOfPublishedConferencePapers;
		json.numberOfPublishedConferencePapersAsFirst=values.numberOfPublishedConferencePapersAsFirst;
		json.scopusGoogleProfileOfExternalExaminer=values.scopusGoogleProfileOfExternalExaminer;
		json.numberOfPhDsExamined=values.numberOfPhDsExamined;
		json.numberOfMastersExamined=values.numberOfMastersExamined;
		if(employeeAdditionalInfoID!=null){
			json.id=employeeAdditionalInfoID;
		}

		if(employeeId!=null){
			var userTemp = new Object();
			userTemp.id=employeeId;
		}
		json.user=userTemp;
		
		//Save
		var formData = Ext.encode(json);
		Ext.Ajax.request({
			type: 'rest',
			url:SERVERURL.PATH_EMPLOYEE_ADDITIONAL_INFORMATION_SAVE,
			jsonData: formData,
			method: 'POST',
			success: function(response) {
				var responseId = Ext.decode(response.responseText);
				if(responseId!=null){
					showSuccessMessage(getCommonTranslation('EMPLOYEES_ADDITIONAL_DETAILS'), getCommonTranslation('EMPLOYEES_ADDITIONAL_DETAILS_SUBMITTED_SUCCESSFULLY'));
				}

			}
		});
    }
    
});
