
/*
 * This controller is used for student course execution information actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentCourseExecutionController', {
	extend: 'Academia.controller.personinfo.common.PersonCourseExecutionController',

	alias: "widget.studentcourseexecutioncontroller",
	models:['student.studentprofile.StudentExternalTransferCreditRequestGridModel',
		    'student.studentprofile.StudentInternalTransferCreditRequestGridModel'],
	mixins: {
		FeeAndPaymentController: 'Academia.controller.feeandpayment.FeeAndPaymentController'
	},
	stores: ['setup.templatemapping.TemplateNameListStudentByCode', 'student.studentprofile.AcademicTopicDocumentsStore', 'student.studentprofile.AcademicTopicUrlsStore',
		'student.studentprofile.StudentSalesforceAdmissionDetailsStore','student.studentprofile.StudentProgramCompletionDetailsStore', 'student.studentprofile.StudentProgramCompletionDetailsStore','examinationcenters.manageEvaluation.evaluationgroup.AcademicTermByBatchStore',
		'student.studentprofile.StudentTransferCreditProgramStore',
		'student.studentprofile.StudentTransferCreditBatchStore',
		'student.studentprofile.StudentExternalTransferCreditRequestGridStore',
		'student.studentprofile.StudentInternalTransferCreditRequestGridStore'],
	views : ['personinfo.common.course.MyCourseDetails','personinfo.common.course.MyCourseDetailsAll',
		'personinfo.common.course.MyCourseDetailsPass','personinfo.common.course.MyCourseDetailsFail',
		'personinfo.common.course.MyCourseDetailsStructure','personinfo.common.course.VWMyCourseDetailsLearningTargets',
		'personinfo.student.ConsolidatedLearningPlanTemplateWindow',
		'personinfo.common.course.RequestExamCancellationWindow','student.studentprofile.AcademicsTopicsStructureForStudentProfile',
		'student.studentprofile.StudentAcademicsHistoryStructure','student.studentprofile.AcademicsHistoryGridForMarkTypeCourse','student.studentprofile.AcademicTopicDocumentGrid',
		'student.studentprofile.AcademicTopicDocumentURLGrid', 'student.studentprofile.AcademicTopicDocumentsPopup', 'student.studentprofile.AcademicTopicDocumentsGrid',
		'student.studentprofile.AcademicTopicUrlPopup', 'student.studentprofile.AcademicTopicUrlGrid','student.studentprofile.StudentSalesforceAdmissionDetailsGrid',
		'student.studentprofile.StudentSalesforceAdmissionDetailsForm','student.studentprofile.StudentSalesforceAdmissionDetailsWindow','document.SimpleDocumentForm',
		'student.studentprofile.StudentProgramCompletionDetailsGrid','student.studentprofile.ProgramCompletionDetails',
		'student.studentprofile.StudentTransferCreditRequestStructure',
		'student.studentprofile.StudentTransferCreditRequestFilter',
		'student.studentprofile.StudentTransferCreditRequestTab',
		'student.studentprofile.StudentExternalTransferCreditRequestGridStructure',
		'student.studentprofile.StudentExternalTransferCreditRequestGrid',
		'student.studentprofile.StudentInternalTransferCreditRequestGridStructure',
		'student.studentprofile.StudentInternalTransferCreditRequestGrid'],
	refs: [{
		ref: 'studenttransfercreditrequeststructure',
		selector: 'studenttransfercreditrequeststructure'
	},	{
		ref: 'studentTransferCreditRequestFilter',
		selector: 'studentTransferCreditRequestFilter'
	},{
		ref: 'studentTransferCreditRequestTab',
		selector: 'studentTransferCreditRequestTab'
	},{
		ref: 'studentExternalTransferCreditRequestGrid',
		selector: 'studentExternalTransferCreditRequestGrid'
	},{
		ref: 'studentInternalTransferCreditRequestGrid',
		selector: 'studentInternalTransferCreditRequestGrid'
	},{
		ref: 'studentExternalTransferCreditRequestGridStructure',
		selector: 'studentExternalTransferCreditRequestGridStructure'
	},{
		ref: 'studentInternalTransferCreditRequestGridStructure',
		selector: 'studentInternalTransferCreditRequestGridStructure'
	},{
		ref: 'personCommonWindow',
		selector: 'personcommonwindow'
	}, {
		ref: 'mycoursedetails',
		selector: 'mycoursedetails'
	}, {
		ref: 'mycoursedetailsstructure',
		selector: 'mycoursedetailsstructure'
	},{
		ref: 'personFeePlanForm',
		selector: 'feeplanform[itemId=studentFeePlanForm]'
	}, {
		ref: 'noOfFeeConfigHeadsWin',
		selector: 'nooffeeconfigheadswin'
	}, {
		ref: 'noOfConfigureFeeHeadsId',
		selector: 'searchresultgrid[itemId=noofconfigurefeeheadsId]'
	}, {
		ref: 'studentwisedetaildata',
		selector: 'studentwisedetaildata'
	}, {
		ref: 'studentwiseDetaildata',
		selector: 'studentwisedetaildata form'
	}, {
		ref: 'studentwiseDetaildata',
		selector: 'studentwisedetaildata form'
	}, {
		ref: 'studentMyCourseSearchResultGrid',
		selector: 'searchresultgrid[itemId=studentMyCourseSearchResultGrid]'
	}, {
		ref: 'myCourseQuickSearchForm',
		selector: 'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm]'
	}, {
		ref: 'exameligibiltystportalandprofile',
		selector: 'exameligibiltystportalandprofile'
	}, {
		ref: 'viewexaminationstportalgrid',
		selector: 'viewexaminationstportalgrid'
	},{
		ref: 'attendanceQuickSearchGrid',
		selector: 'attendanceQuickSearchGrid'
	}, {
		ref: 'academicstopicquicksearchform',
		selector: 'academicstopicquicksearchform'
	}, {
		ref: 'academicstopicquicksearchgrid',
		selector: 'academicstopicquicksearchgrid'
	},{
		ref: 'academictopicdetails',
		selector: 'academictopicdetails'
	},{
		ref: 'studentcoursereportgrid',
		selector: 'studentcoursereportgrid'
	},{
		ref: 'studentcoursereportbyperiodgrid',
		selector: 'studentcoursereportbyperiodgrid'
	},{
		ref: 'studentacademicshistorygrid',
		selector: 'studentacademicshistorygrid'
	},{
        ref: 'studentacademichistorywin',
        selector: 'studentacademichistorywin'
    },{
    	ref: 'degreeauditreportprofileview',
        selector: 'degreeauditreportprofileview'
    },{
    	ref: 'degreeauditreportgrid',
        selector: 'degreeauditreportgrid[itemId=profileDegreeAuditReportGrid]'
    },{
    	ref: 'vwmycoursedetailslearningtargets',
        selector: 'vwmycoursedetailslearningtargets'
    },{
  	  ref:'stuLearningTargetGradeGridItemId',
	  selector:'vwmycoursedetailslearningtargets grid[itemId=stuLearningTargetGradeGridItemId]'
    },{
	  ref:'stuLearningTargetMarkGridItemId',
	  selector:'vwmycoursedetailslearningtargets grid[itemId=stuLearningTargetMarkGridItemId]'
    },{
		ref: 'studentacademichistoryprinttranscriptwin',
		selector: 'studentacademichistoryprinttranscriptwin'
	},{
		ref: 'consolidatedlearningplantemplatewindow',
		selector: 'consolidatedlearningplantemplatewindow'
	},{
		ref: 'requestexamcancellationwindow',
		selector: 'requestexamcancellationwindow'
	},
	{
		ref: 'academicstopicsstructureforstudentprofile',
		selector: 'academicstopicsstructureforstudentprofile'
	},{
		ref:'studentacademicshistorystructure',
		selector:'studentacademicshistorystructure'
	},{
		ref:'academicshistorygridformarktypecourse',
		selector:'academicshistorygridformarktypecourse'
	},{
		ref:'academictopicdocumentgrid',
		selector:'academictopicdocumentgrid'
	}, {
        ref: 'documentformwindow',
        selector: 'documentformwindow'
    }, {
    	ref: 'academictopicdocumenturlgrid',
    	selector: 'academictopicdocumenturlgrid'
    }, {
    	ref: 'academictopicdocumentspopup',
    	selector: 'academictopicdocumentspopup'
    }, {
    	ref: 'academictopicdocumentsgrid',
    	selector: 'academictopicdocumentsgrid'
    }, {
    	ref: 'academictopicurlpopup',
    	selector: 'academictopicurlpopup'
    }, {
    	ref: 'academictopicurlgrid',
    	selector: 'academictopicurlgrid'
    }, {
    	ref: 'studentsalesforceadmissiondetailsgrid',
    	selector: 'studentsalesforceadmissiondetailsgrid'
    }, {
    	ref: 'studentsalesforceadmissiondetailsform',
    	selector: 'studentsalesforceadmissiondetailsform'
    }, {
    	ref: 'studentsalesforceadmissiondetailswindow',
    	selector: 'studentsalesforceadmissiondetailswindow'
    }, {
    	ref: 'simpledocumentform',
    	selector: 'simpledocumentform'
    }, {
    	ref: 'studentprogramcompletiondetailsgrid',
    	selector: 'studentprogramcompletiondetailsgrid[itemId=studentprogramcompletiondetailsgridId]'
    },{
    	ref: 'programcompletiondetails',
    	selector: 'programcompletiondetails'
    }],
	config: {
		STUDENT_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ATTENDANCE_DETAILS_PRIVILEGES'),
		STUDENT_FEE_PLANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEE_PLANS_PRIVILEGES'),
		COURSE_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MYCOURSE_PRIVILEGES'),
		STUDENT_SCHEDULE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SCHEDULE_DETAILS_PRIVILEGES'),
		EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES'),
		STUDENT_VIEW_EXAMINATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_VIEW_EXAMINATION_PRIVILEGES'),
		STUDENT_ACADEMICS_TOPIC_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ACADEMICS_TOPIC_PRIVILEGES'),
		STUDENT_JOURNEY_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_JOURNEY_PRIVILEGES'),
		STUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_VIEW_ACADEMIC_HISTORY'),
		STUDENT_CONDITIONS_FOR_ADMISSION_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_CONDITIONS_FOR_ADMISSION_PRIVILEGES'),
		EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES'),
		PARENT_COURSE_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_MYCOURSE_PRIVILEGES'),
		STUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES'),
		PARENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES'),
	    FACULTY_PORTAL_STUDENT_SCHEDULE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_SCHEDULE_DETAILS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES'),
		STUDENT_PORTAL_COURSE_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_MYCOURSE_PRIVILEGES'),
		FACULTY_PORTAL_COURSE_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_MYCOURSE_PRIVILEGES'),
		STUDENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES'),
		FACULTY_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_VIEW_EXAMINATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_VIEW_EXAMINATION_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_ACADEMICS_TOPIC_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_ACADEMICS_TOPIC_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY'),
		PARENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES'),
		FACULTY_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES'),
		PARENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES'),
		STUDENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES'),
		STUDENT_MYCOURSE_LEARNING_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MYCOURSE_LEARNING_PRIVILEGES'),
		MYCOURSE_PASSFAIL_TAB_PRIVILEGES_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MYCOURSE_LEARNING_TAB_PRIVILEGES'),
		STUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES'),
		FACULTY_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MYCOURSE_LEARNING_PRIVILEGES'),
		STUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES'),
		PARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES'),
		STUDENT_PROGRAM_WISE_CONDITIONS_FOR_ADMISSION_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROGRAM_WISE_CONDITIONS_FOR_ADMISSION_PRIVILEGES'),
		STUDENT_VIEW_ACADEMIC_HISTORY_FOR_MARK_TYPE_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_VIEW_ACADEMIC_HISTORY_FOR_MARK_TYPE_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_MARK_TYPE_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_MARK_TYPE_PRIVILEGES'),
		STUDENT_ACADEMIC_TOPIC_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ACADEMIC_TOPIC_DETAILS_PRIVILEGE'),
	    STUDENT_SALESFORCE_ADMISSION_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SALESFORCE_ADMISSION_DETAILS_PRIVILEGES'),
        ACADEMIC_TOPIC_LIST_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ACADEMIC_TOPIC_PRIVILEGES'),
        STUDENT_PROGRAM_COMPLETION_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROGRAM_COMPLETION_DETAILS_PRIVILEGES'),
        STUDENT_TRANSFER_CREDIT_DETAILS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSFER_CREDIT'),
        STUDENT_TRANSFER_CREDIT_EXTERNAL_TAB_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSFER_CREDIT_EXTERNAL_TAB'),
        STUDENT_TRANSFER_CREDIT_INTERNAL_TAB_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSFER_CREDIT_INTERNAL_TAB'),
        FP_ACADEMIC_TOPIC_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_ACADEMIC_TOPIC_PRIVILEGES')
	},
	init: function(application) {
		this.addEditBtn = false;
		this.viewMode = false,
		this.control({
			//**************************Export***********************************************
			'searchresultgrid[itemId=studentMyCourseSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
				click: function() {
					this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
				}
			},
			'searchresultgrid[itemId=studentMyCourseSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
				click: function() {
					this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
				}
			},
			'searchresultgrid[itemId=studentMyCourseSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
				click: function() {
					this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
				}
			},
			'searchresultgrid[itemId=studentMyCourseSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
				click: function() {
					this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
				}
			},
			'studentcoursereportgrid button[itemId=requestExamCancellationButtonId]' : {
				click : function() {
					this.showRequestExamCancellation();
				}
			},
			'studentcoursereportgrid button[itemId=btnSaveItemId]' : {
	            click :function(obj){
	            this.midtermGradeMarksSave(obj);
	            } 
	        }
			,'requestexamcancellationwindow filefield[itemId=uploadFileField]':{
				change: function(photoFileImage, value, eOpts) {
    				var $this = this;
    				value = value.replace('C:\\fakepath\\', '');
    				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    				photoFileImage.setRawValue(newValue);

    				if (!isNullOrEmpty(newValue)) {
    					var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    					if (extension == "gif" || extension == "png" || extension == "bmp"
		    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
		    					   || extension == "doc" || extension == "docx" || extension == "txt"
		    						   || extension == "xls" || extension == "csv" || extension == "xml" 
		    							   || extension == "xlsx" || extension == "ppt" || extension == "pptx" || extension == "zip" ) {
    						var file = photoFileImage.fileInputEl.dom.files[0];
    						if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
    							photoFileImage.reset();
    							showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
    							return false;
    						}
    					} else {
    						photoFileImage.reset();
    						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('REFERENCE_DOCUMENT_VALID_FILE'));
    						return false;
    					}
    				}
    			}
			},'requestexamcancellationwindow  button[itemId=requestExamCancellationSubmit]':{
				click : function() {
					var $this = this;
					var portalId = this.getCurrentLoggedPortalId();
					var grid = $this.getStudentcoursereportgrid();
					var records = grid.getSelectionModel().getSelection();
					var winForm=$this.getRequestexamcancellationwindow();
					var admissionId=null;
					var status=null;
					if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7 ){
						admissionId=this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
						status='APPLIED';
					}else if (this.getCurrentLoggedPortalId()==1){
						admissionId=records[0].data.admissionId;
						status='APPLIED';
					}else
						{
						admissionId=records[0].data.admissionId;
						status='APPROVED';
						}
					var getSelectionFilePath=winForm.down('#uploadFileField').getValue();

					var data = new Object();
					data.entityId = null;
					data.module = 'REQUESTEXAM_CANCELLATION';
					data.entityType = 'DOCUMENT';
					var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
					winForm.down('form').getForm().submit({
						method: 'POST',
						async:false,
						url: uplaodUrl,
						success: function(form1, action) {
							var responseData = Ext.decode(action.response.responseText);
							var path = responseData.path;
							winForm.down('#browseFilePath').setValue(path);
							winForm.down('#uploadFileField').setValue(path);

							var documentId=null;
							var formData = new Object();
							formData.type ='DOCUMENT';
							formData.name = 'REQUESTEXAM_CANCELLATION_DOCUMENT';
							var entityId;
							$this.getDocumentController().saveDocumentFormValue(false, 'DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
								if(success){
									var jsonStaffDetail = [];
									documentId = Ext.JSON.decode(response.responseText);
									if(isNullOrEmpty(getSelectionFilePath)){
										documentId=null;
									}
									var jsonObj = {
											"courseId": records[0].data.courseId,
											"admissionId": admissionId,
											"courseVariantId": records[0].data.courseVariantId,
											"batchId": records[0].data.batchId,
											"periodId": records[0].data.periodId,
											"examCancellationRequestDate": winForm.down('#requestExamCancellationDate').getValue(),
											"remark": winForm.down('#remarkId').getValue(),
											"documentId":documentId,
											"status":status
									}
									jsonStaffDetail.push(jsonObj);

									Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_SAVE_REQUEST_EXAM_CANCELLATION,
										jsonData: jsonObj,
										method: 'POST',
										success: function(frm, action) {
											if(frm.responseText.split(",")[0]=="ALREADY_EXISTS"){
												$this.getRequestexamcancellationwindow().close();
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('YOU_HAVE_ALREADY_APPLIED_FOR_EXAM_CANCELLATION'));
												Ext.getBody().unmask();
											}else if(frm.responseText.split(",")[0]=="MAXIMUM_COURSE"){
												$this.getRequestexamcancellationwindow().close();
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('YOU_CANNOT_APPLY_FOR_EXAM_CANCELLATION_ALERT1')+frm.responseText.split(",")[1]+getCommonTranslation('YOU_CANNOT_APPLY_FOR_EXAM_CANCELLATION_ALERT2'));
												Ext.getBody().unmask();
											}else if(frm.responseText.split(",")[0]=="MARKENTRY_IS_DONE"){
												$this.getRequestexamcancellationwindow().close();
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_APPLY_FOR_EXAM_CANCELLATION_MARK_ENTRY_HAS_BEEN_DONE'));
												Ext.getBody().unmask();
											}else{
												$this.getRequestexamcancellationwindow().close();
												Ext.getBody().unmask();
												showSuccessMessage(getCommonTranslation('EXAM_CANCELLATION_REQUEST'), getCommonTranslation('SUCCESSFULLY_APPLIED_FOR_EXAM_CANCELLATION'));
											}
										}
									});

								}
							});
						},
					});
				}
			},
			'requestexamcancellationwindow  button[itemId=cancelBtn]':{
				click : function() {
					this.getRequestexamcancellationwindow().close(); 
				}
			},
			//	**************************************************************************************
			/**
			 * Student schedule calender
			 */'scheduledetails[itemId=studentScheduleDetails] calendarpanel[itemId=personViewCalendar]': {
				 render: function(calender) {
					 this.sendCalendarEventsRequest('STUDENT', '#personViewCalendar', SERVERURL.STUDENT_SCHEDULE_DETAILS);
				 },
				 afterrender: function(calendar){
					 var portalId = this.getCurrentLoggedPortalId();
					 var $this = this;
					 var buttonContainer = calendar.getDockedItems('toolbar')[0];
					 var exportToPngBtn=buttonContainer.down("#exportToPngBtn");
					 exportToPngBtn.setVisible(false);
					 if(portalId==1){
						 var permissionsMap=this.getSTUDENT_SCHEDULE_DETAILS_PERMISSIONS();
						 var associatedAcadLocationIds = new Array();
						 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
						 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
						 var exportToPngIsVisible = false;
						 if(Ext.Array.contains(permissionList, 'EXPORT_TO_PNG')){
							 exportToPngBtn.setVisible(true);
							 exportToPngIsVisible = true;
						 }
						 if(Ext.Array.contains(permissionList, 'PRINT')){
							 var btnObj = {
									 xtype: 'button',
									 text: getCommonTranslation('Print'),
									 cls:'dashbordTbarBtn',
									 itemId:'btnPrint',
									 name:'btnPrint',
									 handler: function(btn){
										 // code to identify jasper
										 var code ="DETAIL_TIME_TABLE_CODE";
										 var personProfile = $this.getContentPanelActiveTab();
										 var userId = personProfile.getUserId();
										 var reportParams =new Object();
										 reportParams.studentId=userId;
										 var calendarPnl = btn.up('calendarpanel');
										 var toolbarHeader = calendarPnl.down('#app-center');
										 reportParams.start=Ext.Date.format(toolbarHeader.config.start,'m-d-Y');
										 reportParams.end=Ext.Date.format(toolbarHeader.config.end,'m-d-Y');
										 var reportTitle='Detailed Time Table Report';
										 var exportUrl = SERVERURL.CALENDER_PDF_FOR_DETAILED_TIME_TABLE;//rest/ReportDocumentResource/calenderPdf
										 var fileType = 'pdf';
										 var store=$this.getStore('examinationcenters.IsTemplateMappedStore');//this logic for check report template mapping configuration
										 store.getProxy().extraParams={
											 code:code
										 };
										 store.load({
											 callback:function(rec,obj,success){
												 if(obj.response.responseText=="true"){
													 $this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
												 }else{
													 showWarningMessage(getCommonTranslation('ALERT'),getTranslation('DTT_TEMPLATE_MAPPING_ERROR'));
												 }
											 }
										 });
										 
									 },
							 };
							 if(!exportToPngIsVisible){
								 buttonContainer.add(btnObj);
							 }
							 else {
								 buttonContainer.insert((buttonContainer.items.length-1),btnObj);
							 }
						 }
						 
						 calendar.down('dayview').on('show',function(view){
							 try{
								 view.up('calendarpanel').down('#btnPrint').hide();
							 }
							 catch(e){
								 
							 }
						 });
						 calendar.down('weekview').on('show',function(view){
							 try{
								 var permissionsMap=$this.getSTUDENT_SCHEDULE_DETAILS_PERMISSIONS();
								 var associatedAcadLocationIds = new Array();
								 associatedAcadLocationIds.push($this.getCurrentAcademyLocation()); 
								 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
								 view.up('calendarpanel').down('#btnPrint').hide();
								 if(portalId==1){
									 if(Ext.Array.contains(permissionList, 'PRINT')){
										 view.up('calendarpanel').down('#btnPrint').show();
									 }
								 }
							 }
							 catch(e){
								 
							 }
						 });
						 
						 calendar.down('weekview').on('hide',function(view){
							 try{
								 setTimeout(function(){
									 if(view.up('calendarpanel').getActiveView().xtype=="monthview"){
										 view.up('calendarpanel').down('#btnPrint').hide();
									 }
								 },100);
							 }
							 catch(e){
								 
							 }
						 });
						 
						 calendar.down('dayview').on('hide',function(view){
							 try{
								 setTimeout(function(){
									 if(view.up('calendarpanel').getActiveView().xtype=="monthview"){
										 view.up('calendarpanel').down('#btnPrint').hide();
									 }
								 },100);
							 }
							 catch(e){
								 
							 }
						 });
					 }
					 setTimeout(function(calender){
						 var personProfile = $this.getContentPanelActiveTab();
				    	 var structure = personProfile.down('scheduledetails');
	                     var structureBody = structure.body;
	                     var currentTimeHour = 8;//new Date().getHours();
	                     structureBody.setScrollTop();
	                     structureBody.scrollBy(0,151);
	                   	 structureBody.scrollBy(0,((75*currentTimeHour)));
	                	},500);
					 }
				 },
				 'degreeauditreportgrid[itemId=profileDegreeAuditReportGrid]':{
						beforedestroy: function(tree, eOpts){
						   tree.getStore().getRootNode().removeAll();
					   }
				},
			 'scheduledetails[itemId=studentScheduleDetails] radiogroup[itemId=viewCalendarId]': {
				 change: function(obj,rec) {
					 var portalId = this.getCurrentLoggedPortalId();
					 var calendar=obj.up('#studentScheduleDetails').down('#personViewCalendar');
					 var buttonContainer = calendar.getDockedItems('toolbar')[0];
					 var exportToPngBtn=buttonContainer.down("#exportToPngBtn");
					 var printBtn=buttonContainer.down("#btnPrint");
					 if(rec.isViewCalendar){
						 if(portalId==1){
							 if(!isNullOrEmpty(printBtn)){
								 printBtn.setVisible(true);
							 }
							 var permissionsMap=this.getSTUDENT_SCHEDULE_DETAILS_PERMISSIONS();
							 var associatedAcadLocationIds = new Array();
		                	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		                	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		                	 var exportToPngBtn=buttonContainer.down("#exportToPngBtn");
		                	 exportToPngBtn.setVisible(false);
		                	 var exportToPngIsVisible = false;
		                	 if(Ext.Array.contains(permissionList, 'EXPORT_TO_PNG')){
		                		 exportToPngBtn.setVisible(true);
		                		 exportToPngIsVisible = true;
		                	 } 
						 }
						 this.sendCalendarEventsRequest('STUDENT', '#personViewCalendar', SERVERURL.STUDENT_SCHEDULE_DETAILS);	
					 }else{
						 if(!isNullOrEmpty(printBtn)){
							 printBtn.setVisible(false);
						 }
						 exportToPngBtn.setVisible(false);
						 this.sendCalendarEventsRequest('STUDENT', '#personViewCalendar', SERVERURL.STUDENT_EVENT_DETAILS);
					 }
				 }
			 },
			 'studentcoursereportgrid':{
				 render: function(grid){
					 grid.columns[1].setVisible(false);
					 var alinfomodel = Academia.model.authentication.ALInfoModel;
                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
					 if(wheatherSchool) {
                		grid.columns[8].hidden = true;
                		 grid.columns[8].setVisible(false);
                	 }
					 if(portalId==7){
						 this.doAccessControlValidation(grid, this.getPARENT_COURSE_MASTER_PERMISSIONS());
					 }else if(portalId == 2){
						 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
					 }else if(portalId == 3){
						 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
					 }else{
						 this.doAccessControlValidation(grid, this.getCOURSE_MASTER_PERMISSIONS());
						 this.addDataGridConfigButton(grid,this.getCOURSE_MASTER_PERMISSIONS());						 
					 }
				 },
				afterrender: function(grid) {
    				setTimeout(function() {
        				var midtermGradeMarksColumns = grid.columns[7];
						midtermGradeMarksColumns.hide();
    			}, 100);
				},
				 selectionchange: function(column, selected,eOpts ){
					 var $this = this;
					 var grid = column.view.up('grid');
					 var buttonsToolBar = grid.query('toolbar')[0];
					 var records = grid.getSelectionModel().getSelection();
					 var requestExamCancellationBtn= grid.down('#requestExamCancellationButtonId');
					 if(selected.length == 1){
						 var today = new Date();
						 var nCurDate = Ext.util.Format.date(today, 'm/d/Y');
						 var nNewTillDate = Ext.util.Format.date(new Date(records[0].data.examCancellationApplicableTillDate), 'm/d/Y');
						 if(records[0].data.examCancellationApplicableFromDate!=null && records[0].data.examCancellationApplicableTillDate!=null && (nNewTillDate >= nCurDate)){
							 requestExamCancellationBtn.setDisabled(false);
						 }else{
							 requestExamCancellationBtn.setDisabled(true);
						 }
					 }else{
						 requestExamCancellationBtn.setDisabled(true);
					 }
				 },
				 cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
   				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
   				   if(columnName == "lessonPlanmodel"){
            			   if(e.target.tagName=='A'){
            				   var studentcoursereportgrid = grid.up('#studentcoursereportgrid');
            				   this.generateLessonPlanReport(record);
            			   }
   				   		}
   			   		}
			 },
			 'requestexamcancellationwindow':{
				 render: function(){
					 var $this = this;
					 var grid = $this.getStudentcoursereportgrid();
					 var records = grid.getSelectionModel().getSelection();
					 var periodForm = $this.getRequestexamcancellationwindow();
					 periodForm.down('#requestExamCancellationDate').setMinValue(dateFormatRender(new Date(records[0].data.examCancellationApplicableFromDate)));
					 periodForm.down('#requestExamCancellationDate').setMaxValue(dateFormatRender(new Date(records[0].data.examCancellationApplicableTillDate)));
					 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
						 periodForm.down('#requestExamCancellationDate').setMinValue(dateFormatRender(new Date()));
						 periodForm.down('#requestExamCancellationDate').setMaxValue(dateFormatRender(new Date()));
					 }
				 }
			 },
			 'studentcoursereportbyperiodgrid button[itemId=downloadAllButtonItemId]':{
				 click: function(grid){
					 this.downloadAllMarksheetZip();
				 }
			 },
			 'studentcoursereportbyperiodgrid button[itemId=downloadUnofficialTranscriptItemId]':{
				 click: function(grid){
					 this.downloadUnofficialTranscript();
				 }
			 },

			 'studentcoursereportbyperiodgrid':{
				 render: function(grid){
					 if(portalId==7){
						 this.addDataGridConfigButton(grid,this.getPARENT_COURSE_MASTER_PERMISSIONS());
						 this.doAccessControlValidation(grid, this.getPARENT_COURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid, this.getPARENT_COURSE_MASTER_PERMISSIONS());
					 }else if(portalId == 2){
						 this.addDataGridConfigButton(grid,this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
						 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
					 }else if(portalId == 3){
						 this.addDataGridConfigButton(grid,this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
						 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
					 }else{
						 this.addDataGridConfigButton(grid,this.getCOURSE_MASTER_PERMISSIONS());
						 this.doAccessControlValidation(grid, this.getCOURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid, this.getCOURSE_MASTER_PERMISSIONS());
					 }
				 }, 
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

					 var searchResultGrid = this.getStudentcoursereportbyperiodgrid();
					 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

					 if (e.target.tagName == 'A') {
						 var csvForm = Ext.create('Ext.form.Panel'); 
						 var submitUrl= SERVERURL.MARKSHEET_DOWNLOAD_URL;
//						 var filePath = window.btoa(unescape(encodeURIComponent(record.data.marksheetPath)));
						 var fields = record.data.marksheetPath.split('.pdf');
                         var docAtcualPath = fields[0];
                         docAtcualPath = docAtcualPath+'_ForStudentPortal' + '.pdf';
                     	 documentPath = window.btoa(unescape(encodeURIComponent(docAtcualPath)))
						 csvForm.getForm().submit({
							 url : submitUrl+"?filePath="+documentPath,
							 method : 'POST',
							 target: '_blank',
							 params :{
								 access_token : Ext.Ajax.defaultHeaders.access_token
							 },
							 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
//							 standardSubmit :true  // @ankush comment this code for marksheet generate two times in single click on url.
						 });	
					 }
				 }
			 },
			 'searchresultgrid[itemId=studentMyCourseSearchResultGrid]':{
				 render : function(grid){
					 var activetabInfo = this.getContentPanelActiveTab();
					 var myCourseStructure = activetabInfo.down('mycoursedetails');
					 permissionsMap = this.getCOURSE_MASTER_PERMISSIONS();
					 var grid = myCourseStructure.down('#studentMyCourseSearchResultGrid');
					 grid.addButtonToolbar();
					 this.gridRenderFunctionForStudentPeriod(grid);
					 if(portalId==7){
						 this.genericCBGridAccessControlValidation(grid, this.getPARENT_COURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid,this.getPARENT_COURSE_MASTER_PERMISSIONS());
					 }else if(portalId == 2){
						 this.genericCBGridAccessControlValidation(grid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
					 }else if(portalId == 3){
						 this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
					 }else{
						 this.genericCBGridAccessControlValidation(grid, this.getCOURSE_MASTER_PERMISSIONS());
						 this.disableDownloadMarsheetPivileges(grid,this.getCOURSE_MASTER_PERMISSIONS());
					 }
					 //this.enableDisableDownloadBtn(false);

					 Ext.defer(function() {
						 var portalId = this.getCurrentLoggedPortalId();
						 if(portalId == 3 || portalId == 7) {
							 if(!isNullOrEmpty(grid.columnManager) && !isNullOrEmpty(grid.columnManager.columns)) {
								 for(var i=grid.columnManager.columns.length-1;i>=0;i--) {
									 var column = grid.columnManager.columns[i];
									 if(column.dataIndex == 'COURSE_CODE'){
										 column.hide();
									 }
								 }
							 }
						 }
					 }, 1000, this);
				 },
				 beforerender:function(grid){
					 var activetabInfo = this.getContentPanelActiveTab();
					 var myCourseStructure = activetabInfo.down('mycoursedetails');
					 var form = myCourseStructure.down('#studentMyCourseQuickSearchForm');
					 var obj = form.down('#attendanceSearchButtonId');
					 var studentCoursePeriodGrid = myCourseStructure.down('#periodReport');
					 Ext.suspendLayouts();
					 Ext.defer(function() {
						 studentCoursePeriodGrid.setVisible(false);
					 }, 50, this);

					 Ext.resumeLayouts();
				 },            	
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					 var activetabInfo = this.getContentPanelActiveTab();
					 var myCourseStructure = activetabInfo.down('mycoursedetails');
					 var searchResultGrid = myCourseStructure.down('#studentMyCourseSearchResultGrid');
					 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

					 if(columnName=='MARKSHEET_PATH'){
						 if (e.target.tagName == 'A') {
							 var csvForm = Ext.create('Ext.form.Panel'); 
							 var submitUrl= SERVERURL.MARKSHEET_DOWNLOAD_URL;
							 var filePath = window.btoa(unescape(encodeURIComponent(record.data.MARKSHEET_PATH)));
							 csvForm.getForm().submit({
								 url : submitUrl+"?filePath="+filePath,
								 method : 'POST',
								 target: '_blank',
								 params :{
									 access_token : Ext.Ajax.defaultHeaders.access_token
								 },
								 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								 standardSubmit :true
							 });	
						 }
					 }
				 }
			 },
			 'scheduledetails[itemId=studentScheduleDetails] #viewDatePicker':{
				 'select': {
					 fn: function(dp, dt){
						 var this$ = this;
						 var personProfile = this$.getContentPanelActiveTab();
						 var viewCalendarForm = personProfile.down('#studentScheduleDetails');
						 viewCalendarForm.down('#personViewCalendar').setStartDate(dt);
						 viewCalendarForm.down('#viewCalendarButton').toggle(false,false);
						 viewCalendarForm.down('#viewCalendarButton').hideMenu();
					 },scope: this
				 }
			 },
			 'scheduledetails[itemId=studentScheduleDetails] #viewCalendarButton':{
				 click: function(cmp, e, eOpts){
					 var this$ = this;
					 var personProfile = this$.getContentPanelActiveTab();
					 var viewCalendarForm = personProfile.down('#studentScheduleDetails');
					 cmp.showMenu();
					 viewCalendarForm.down('#viewDatePicker').setVisible(true);
				 }
			 },
			 'scheduledetails[itemId=studentScheduleDetails] ':{
				 afterrender:function(cmp){	
					 var width = cmp.getWidth();
					 var height = cmp.getHeight();
					 cmp.down('#personViewCalendar').setWidth(width);
					 cmp.down('#personViewCalendar').setHeight(height-40);
				 }
			 },
			 /**
			  * Student Fee Plan 
			  */'feeplangrid[itemId=studentFeePlanGrid]': {
				  render: function(grid) {
					  grid.dockedItems.items[2].setVisible(false);

					  var this$ = this;
					  var personProfile = this$.getContentPanelActiveTab();
					  var personId = personProfile.getUserId();
					  var programBatchSeatTypeConfigId = personProfile.getProgramBatchSeatTypeConfigId();
					  var params = {
							  id: personId,
							  billedUserType: 'STUDENT',
							  programBatchSeatConfigId: programBatchSeatTypeConfigId
					  };
					  this.loadGridStore('#studentFeePlanGrid', SERVERURL.STUDENT_FEE_PLAN_DETAILS, params);
				  },
				  cellclick: function(view, cell, cellIndex, record, row, rowIndex, e) {
					  var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
					  if (cellDataIndex == "noOfFeeHeads") {
						  this.viewFeePlan('#studentFeePlanGrid');
					  }
				  }
			  },


			  /**
			   * Student Attendance Details
			   */'attendanceQuickSearchGrid[itemId=studentAttendanceSearchResultGrid]': {
				   render: function(grid) {
					   portalId = this.getCurrentLoggedPortalId();
	            		if(portalId == 2){
	            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_ATTENDANCE_PERMISSIONS());
	            		}else if(portalId == 3){
	            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_ATTENDANCE_PERMISSIONS());
	            		}else{
	            			this.doAccessControlValidation(grid, this.getSTUDENT_ATTENDANCE_PERMISSIONS());
	            		}
				   }
			   },
			   'attendanceQuickSearchGrid[itemId=studentAttendanceSearchResultGrid] button[itemId=btnView]': {
				   click: function() {
					   this.viewDetails('#studentAttendanceSearchResultGrid', '#studentAttendanceQuickSearchForm');
				   }
			   },
			   'attendancequicksearchform[itemId=studentAttendanceQuickSearchForm] button[itemId=attendanceSearchButtonId]': {
				   click: function() {
					   this.loadStudentSearchGrid('#studentAttendanceQuickSearchForm', '#studentAttendanceSearchResultGrid');
				   }
			   },
			   'attendancequicksearchform[itemId=studentAttendanceQuickSearchForm] combo[itemId=attendanceProgram]': {
				   afterrender: function(program, records, eOpts) {
					   var this$ = this;
					   var personProfile = this$.getContentPanelActiveTab();
					   var userId = personProfile.getUserId();
					   this.loadDependentCombo(program, userId, 'studentId');
				   },
				   select: function(combo, records, eOpts) {
					   var batch = combo.up('form').down('#batchCombo');
					   var comboValue = combo.getValue();
					   this.loadDependentCombo(batch, comboValue, 'id');
				   }
			   },
			   'attendancequicksearchform[itemId=studentAttendanceQuickSearchForm] combo[itemId=batchCombo]': {
				   select: function(combo, records, eOpts) {
					   var period = combo.up('form').down('#period');
					   var comboValue = combo.getValue();
					   this.loadDependentCombo(period, comboValue, 'id');
				   }
			   },
			   'attendancequicksearchform[itemId=studentAttendanceQuickSearchForm] combo[itemId=period]': {
				   select: function(combo, records, eOpts) {
					   var course = combo.up('form').down('#course');
					   var comboValue = combo.getValue();
					   this.loadDependentCombo(course, comboValue, 'periodId');
				   }
			   },
			   'attendancequicksearchform[itemId=studentAttendanceQuickSearchForm] combo[itemId=course]': {
				   select: function(combo, records, eOpts) {
					   var courseComponent = combo.up('form').down('#courseComponent');
					   var comboValue = combo.getValue();
					   this.loadDependentCombo(courseComponent, comboValue, 'id');
				   }
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] button[itemId=attendanceSearchButtonId]': {
				   click:function(obj){
					   this.loadMyCourseGridData(obj);
				   },
				   render: function(grid){

				   }

			   },'mycoursedetailsstructure':{
				   tabchange:function(tabPanel, newCard, oldCard, eOpts){
					   var newTabName=newCard;
					   if(newTabName.title==getCommonTranslation('All')){
						   this.loadMyCourseGridData(oldCard);
					   }else  if(newTabName.title==getCommonTranslation('Pass')){
						   this.loadMyCourseGridData(oldCard);

					   }else  if(newTabName.title==getCommonTranslation('Fail')){
						   this.loadMyCourseGridData(oldCard);
					   }else  if(newTabName.title==getExaminationTranslation('LEARNING_TARGETS')){
						   this.loadMyCourseGridData(oldCard);
					   }
				   },
				   render: function(grid) {
					   if(portalId == 7){
						   this.doAccessPassFailTabControlValidation(grid, this.getPARENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PERMISSIONS());
					   }else if(portalId == 3){
						   this.doAccessPassFailTabControlValidation(grid, this.getSTUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES_PERMISSIONS()); 
					   }else if(portalId == 2){
						   this.doAccessLearningTabControlValidation(grid, this.getFACULTY_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS()); 
					   }else{
						   this.doAccessLearningTabControlValidation(grid, this.getMYCOURSE_PASSFAIL_TAB_PRIVILEGES_PERMISSIONS()); 
					   }
				   },
			  },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] button[itemId=clearSearch]': {
				   click:function(obj){
					   this.resetStudentForm(obj);
				   }
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] radiogroup[itemId=coruseTypeId]': {
				   change:function(obj){
					   this.changeCourseTypeReport(obj);
				   }
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] combo[itemId=studentAcademyLocation]': {
				   select: function(combo, records, eOpts) {
					   var this$ = this;
					   var activetabInfo = this$.getContentPanelActiveTab();
					   var structure = activetabInfo.down('mycoursedetails');
					   var form = structure.down('#studentMyCourseQuickSearchForm');

					   var studentALField = form.down("#studentAcademyLocation");
					   var studentProgramField = form.down("#attendanceProgram");
					   studentProgramField.clearValue();
					   form.down('#batchCombo').clearValue();
					   form.down('#period').clearValue();
					   form.down('#sectionId').clearValue();
					   var academyLocationId=studentALField.getValue();
					   var studentALId = studentALField.getValue();
					   if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
						   studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
					   } else {
						   studentPortalInfo = this$.getStudentDetailForErpPortal();
					   }
					   var studentId = studentPortalInfo.student.id;
					   if(this$.getCurrentLoggedPortalId()==2){
						   var personProfile = this$.getContentPanelActiveTab();
						   studentId = personProfile.userId;
					   }
					   
					   studentProgramField.store.getProxy().extraParams={
						   studentId: studentId,
						   onlyCurrentRecord:false,
						   academyLocationId: studentALField.getValue()
					   };
	  					
					   studentProgramField.store.load({
	  			    		callback : function(records, operation, success) {
	  			    			if (success) {
	  			    				if(records.length==1){
	  			    					studentProgramField.setValue(records[0].data.id);
		  			    				
		  			    				var comboValue = form.down('#attendanceProgram').getValue();
		  			    				this$.onProgramSelection(studentId, comboValue);
	  			    				}
	  			    			}
	  			    		}
	  					});
				   }
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] combo[itemId=attendanceProgram]': {
				   select: function(combo, records, eOpts) {
					   var this$ = this;
					   var activetabInfo = this$.getContentPanelActiveTab();
						var structure = activetabInfo.down('mycoursedetails');
						var form = structure.down('#studentMyCourseQuickSearchForm');
					   var comboValue = form.down('#attendanceProgram').getValue();
					   if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
						   studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
					   } else {
						   studentPortalInfo = this$.getStudentDetailForErpPortal();
					   }
					   var studentId = studentPortalInfo.student.id;
					   if(this$.getCurrentLoggedPortalId()==2){
							var personProfile = this$.getContentPanelActiveTab();
							studentId = personProfile.userId;
						}
					   this$.onProgramSelection(studentId, comboValue);
				   },afterrender: function(combo, records, eOpts) {
						var this$ = this;
					   if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
						   studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
					   } else {
						   studentPortalInfo = this$.getStudentDetailForErpPortal();
					   }
						if(!studentPortalInfo.student.status){
							setTimeout(function(){ 
									var comboresult= combo.getStore().load();
									if(comboresult.data.items.length>0){
									    combo.setValue(comboresult.data.items[0].raw.id);
									    combo.fireEvent('select', combo,comboresult.data.items[0].raw);
									}
							},2000);
						}
					}
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] combo[itemId=batchCombo]': {
				   afterrender: function(combo, records, eOpts) {
					   var this$ = this;
					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
						   studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					   } else {
						   studentPortalInfo = this.getStudentDetailForErpPortal();
					   }
					   var academyLocationId = this.getCurrentAcademyLocation();
					   var studentId = studentPortalInfo.student.id;
					   var programId = studentPortalInfo.programBatchDetails.programId;
					   var batchId = studentPortalInfo.programBatchDetails.batchId;
					   var periodId = studentPortalInfo.programBatchDetails.periodId;
					   var sectionId = studentPortalInfo.programBatchDetails.sectionId;
					   if(this.getCurrentLoggedPortalId()==2){
							var personProfile = this.getContentPanelActiveTab();
							studentId = personProfile.userId;
						}
					   this.setPreFilledValues(academyLocationId, studentId, programId, batchId, periodId, sectionId);
				   },
				   select: function(combo, records, eOpts) {
					   var this$ = this;
					   var comboValue = combo.getValue();
					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
						   studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					   } else {
						   studentPortalInfo = this.getStudentDetailForErpPortal();
					   }
					   var studentId = studentPortalInfo.student.id;
					   if(this.getCurrentLoggedPortalId()==2){
							var personProfile = this.getContentPanelActiveTab();
							studentId = personProfile.userId;
						}
					   this.onBatchSelection(studentId, comboValue);
				   }
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm] combo[itemId=period]': {
				   select: function(combo, records, eOpts) {
					   var this$=this;
					   var comboValue = combo.getValue();
					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
						   studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					   } else {
						   studentPortalInfo = this.getStudentDetailForErpPortal();
					   }
					   var studentId = studentPortalInfo.student.id;
					   if(this.getCurrentLoggedPortalId()==2){
							var personProfile = this.getContentPanelActiveTab();
							studentId = personProfile.userId;
						}
					   this.onPeriodSelection(studentId, comboValue);
				   }
			   },

			   'searchresultgrid[itemId=studentMyCourseSearchResultGrid] button[itemId=downloadAllButtonItemId]':{
				   click:function(obj){
					   this.downloadAllMarksheetZip();
				   }
			   },

			   'exameligibiltystportalandprofile':{
				   beforerender:function(grid){
					   var this$ = this;
					   var personProfile = this$.getContentPanelActiveTab();
					   var examEligibility;
					   var examGrid;
					   var admissionId;
					   /**
					    * for student portal login , portalId=3
					    */
					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
						   admissionId=this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
						   examGrid=grid;
					   }else{
						   admissionId=personProfile.admissionId;
						   examEligibility = personProfile.down('#examEligibility');
						   examGrid =examEligibility.down('#exameligibiltystportalandprofile');
					   }
					   if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7) {
						   var store =examGrid.getStore();
						   store.getProxy().extraParams = {
							   admissionId:admissionId,
							   limit:100
						   },
						   this.resetPageSetting(store);
						   store.load();
					   } else {
						 /*  var bindingStore=Ext.create('Academia.store.examinationcenters.reports.ExamEligibilitySTPortalAndProfileStore');
						   examGrid.bindStore(bindingStore);*/
						 var store =examGrid.getStore();
						   store.getProxy().extraParams = {
							   admissionId:admissionId,
							   limit:100
						   },
						   this.resetPageSetting(store);
						   store.load();
						   
					   }

				   },
				   render: function(grid) {
					   
						var structurePanel = grid.up('personinfostudentportal'); 
						if(structurePanel){
							structurePanel.body.on('scroll', function(e, target) {
								if(grid.headerCt.menu){
									grid.headerCt.menu.hide();
								}
								
							});
						}
					   if(portalId == 2){
						   this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS());
					   }else if(portalId == 3){
						   this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS());
					   }else if(portalId == 7){
						   this.doAccessControlValidation(grid, this.getPARENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS());
					   }else{
						   this.doAccessControlValidation(grid, this.getEXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS());
					   }
				   }
			   },

			   'viewexaminationstportalgrid':{
				   render: function(grid){
					   var this$ = this;
					   if(portalId == 2){
						   this$.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_VIEW_EXAMINATION_PERMISSION());
					   }else{
						   this$.doAccessControlValidation(grid, this.getSTUDENT_VIEW_EXAMINATION_PERMISSION());
					   }
					   
					   var personProfile = this$.getContentPanelActiveTab();
					   var viewExamination = personProfile.down('#viewExamination');
					   var examGrid =viewExamination.down('#viewexaminationstportalgrid');
					   var store =examGrid.getStore();
					   var personProfile = this$.getContentPanelActiveTab();
					   var admissionId=personProfile.admissionId;
					   var studentId = personProfile.userId;
					   store.getProxy().extraParams = {
						   studentId : studentId
					   },
					   store.load();
				   },
				   cellclick:function(view, td, colIndex, record, event,target,pop){
					   if(pop.target.tagName=='A'){
						   var submitUrl= SERVERURL.MARKSHEET_DOWNLOAD_URL;
						   var csvForm = Ext.create('Ext.form.Panel'); 
						   var filePath = window.btoa(unescape(encodeURIComponent(record.data.hallTicketPath)));
						   csvForm.getForm().submit({
							   url : submitUrl+"?filePath="+filePath,
							   method : 'POST',
							   target: '_blank',
							   params :{
								   access_token : Ext.Ajax.defaultHeaders.access_token
							   },
							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							   standardSubmit :true
						   });
					   }
				   }
			   },
			   'studentacademicshistorygrid':{
				   afterrender: function(grid){
					   var this$ = this;
					   var academyLocationId = this$.getCurrentAcademyLocation();
					   setTimeout(function(){
						   if(portalId==1){
						   this$.addDataGridConfigButton(grid,this$.getSTUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION());
						   } else if(portalId==2){
						   this$.addDataGridConfigButton(grid,this$.getFACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION());
						   }
	        		},1500);
					   
					   if(portalId==1){
							  this$.disableAcadmicHistoryPivileges(grid, this$.getSTUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION());
						 }
					   else if(portalId==2){
							  this$.disableAcadmicHistoryPivileges(grid, this$.getFACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION());
					   }
					   
					   var personProfile = this$.getContentPanelActiveTab();
					   var studentAcademicsStructure = personProfile.down('studentacademicshistorystructure');
					   var studentAcademicsHistorygrid =studentAcademicsStructure.down('#studentacademicshistorygrid');
					   var store =studentAcademicsHistorygrid.getStore();
					   var personProfile = this$.getContentPanelActiveTab();	
					   var studentId = personProfile.getUserId();
					   var admissionId=personProfile.admissionId;
					   store.getProxy().extraParams = {
						   studentId:studentId
					   },
					   store.load({
						   callback : function(record, operation, success) {
							   if (success) {
								   var printTranscript=studentAcademicsHistorygrid.down('#btnPrintTranscriptItemId');
					               var printTranscriptInExcel=studentAcademicsHistorygrid.down('#btnPrintTranscriptInExcelItemId');
					               
								   if(record.length <= 0) {
									   printTranscript.setDisabled(true);
						               printTranscriptInExcel.setDisabled(true);
						              
								   }else{
									   printTranscript.setDisabled(false);
						               printTranscriptInExcel.setDisabled(false);
								   } 
							   }
						   }
					   });
				  },
				   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					   if(columnName == "view"){
						   if(e.target.tagName=='A'){
							   this.getStudentAcademicHistoryWindow(grid,record);
						   }
					   }
				   }
			   },
			   
			   'studentacademicshistorygrid button[itemId=btnPrintTranscriptItemId]': {
    			   click : function(grid){
    				   var $this = this;
					   var formWindow = $this.getStudentacademichistoryprinttranscriptwin();
		                                     
					   if (!formWindow) {
						   Ext.widget('studentacademichistoryprinttranscriptwin');
						   formWindow = $this.getStudentacademichistoryprinttranscriptwin();
					   }
		               var codeField =formWindow.down("#selectTranscriptInExcelPrint");
                       codeField.setValue("SIS_TRANSCRIPT");
					   formWindow.setHeight(200);
					   formWindow.setWidth(500);
					   formWindow.show();
    			   }
    		   },
                'studentacademicshistorygrid button[itemId=btnPrintTranscriptInExcelItemId]': {
    			   click : function(grid){
    				   var $this = this;
					   var formWindow_new = this.getStudentacademichistoryprinttranscriptwin();
		               var Code='SIS_TRANSCRIPT_EXCEL';
					   if (!formWindow_new) {
						   Ext.widget('studentacademichistoryprinttranscriptwin');
						   formWindow_new = $this.getStudentacademichistoryprinttranscriptwin();
					   }
		               var codeField =formWindow_new.down("#selectTranscriptInExcelPrint");
                       codeField.setValue("SIS_TRANSCRIPT_EXCEL");
					   formWindow_new.setHeight(200);
					   formWindow_new.setWidth(500);
					   formWindow_new.show();
    			   }
    		   },
    		   'studentacademichistoryprinttranscriptwin': {
    			   render:function(obj){
    				   var $this=this;
					   var program = obj.down('#selectTheProgramToPrintItemId');
					   var personProfile = $this.getContentPanelActiveTab();
					   var userId = personProfile.userId;
					   program.getStore().getProxy().extraParams={
						   studentId: userId
					   };
					   program.store.load();
				   }
    		   },
                 'studentacademichistoryprinttranscriptwin button[itemId=printBtnItemId]': {
    			   click : function(obj){
    				   var $this = this;
    				   var printTranscript = $this.getStudentacademichistoryprinttranscriptwin();
    				   var programIds = printTranscript.
    				   		down('#selectTheProgramToPrintItemId').getValue();
					   var personProfile = $this.getContentPanelActiveTab();
					   var userId = personProfile.userId;
    				  // var code='SIS_TRANSCRIPT';
                      // var excelCode='GENERATE_SCHOOL_TRANSCRIPT_EXCEL';
                       var code = printTranscript.down("#selectTranscriptInExcelPrint").getValue();
                           
                       if (code) { 			   
                         var programArray = [];
    				   if(!isNullOrEmpty(programIds)){
    					   for(var i=0;i<programIds.length;i++){
    						   var programId = programIds[i];
    						   if(Ext.isObject(programId)){
    							   programArray.push(programId.data.id);
    						   }
    					   }
    				   }
                          if(code =='SIS_TRANSCRIPT'){
    				   var reportParams =new Object();
					   reportParams.code =code;
					   reportParams.reportTitle = 'SIS_TRANSCRIPT';
					   reportParams.PROGRAM_IDS = programArray.join();
					   reportParams.STUDENT_ID = userId;
					   reportParams.STUDENT_NAME=personProfile.getPersonInfo().printName;
					   printTranscript.close();
		               
					   $this.exportJRXMLReport(code,reportParams,reportParams.reportTitle,'.pdf',"rest/markSheet/generateSchoolTranscript");
    			  }
                          else{
    				   var reportParams =new Object();
					   reportParams.code =code;
					   reportParams.reportTitle = 'SIS_TRANSCRIPT_EXCEL';
					   reportParams.PROGRAM_IDS = programArray.join();
					   reportParams.STUDENT_ID = userId;
					   reportParams.STUDENT_NAME=personProfile.getPersonInfo().printName;
		                var URL = SERVERURL.GENERATE_SCHOOL_TRANSCRIPT_EXCEL;
					   printTranscript.close();
			           $this.exportJRXMLReport(code,reportParams,reportParams.reportTitle,'.xls',URL);
    			  }}
                    
         
 }
    		   }, 
                  
               'studentacademichistoryprinttranscriptwin multiselectcombofield[itemId=selectTheProgramToPrintItemId]': {
    			   select:function(obj){
    				   var $this=this;
    				   var programId = $this.getStudentacademichistoryprinttranscriptwin().
				   		down('#selectTheProgramToPrintItemId').getValue();
    				   var program = obj.down('#selectTheProgramToPrintItemId');
					   var personProfile = $this.getContentPanelActiveTab();
					   var userId = personProfile.userId;
					   program.getStore().getProxy().extraParams={
						   studentId: userId
					   };
					   program.store.load();
				   }
    		   },
			   'attendancequicksearchform[itemId=studentAttendanceQuickSearchForm]':{
				   render:function(){
					   var grid = this.getAttendanceQuickSearchGrid();
					   grid.hide();
				   }
			   },
			   'academicstopicquicksearchform': {
				   afterrender: function(obj) {
					   var this$=this;
					   var personProfile = this$.getContentPanelActiveTab();
					   var userId = personProfile.userId;
					   var academyLocationId = this$.getCurrentAcademyLocation();
					   var stdForm = obj.getForm();

					   var academicTopic=stdForm.findField('academicTopicId');
					   var academicSubTopic=stdForm.findField('academicSubTopicId');
					   var program=stdForm.findField('programId');
					   var batch=stdForm.findField('batch');
					   var batchCombo = obj.down('#batchCombo');
					   var grid = obj.up('academicstopicsstructureforstudentprofile').down('academicstopicquicksearchgrid');
					   var addbtn=grid.down('#btnAdd');
					   var editbtn=grid.down('#btnEdit');
					   var deletebtn=grid.down('#btnDelete');
					   
					   var iscurruntPeriodId = obj.down('#iscurruntPeriodId');
					   var iscurruntSectionId= obj.down('#iscurruntSectionId');
					   var exitDateId= obj.down('#exitDateId');
					  

					   var academicTopicValue;
					   var academicSubTopicValue;
					   var programValue;
					   var batchValue;
					   var periodValue;
						

					   academicTopic.store.load({
						   callback : function(record, operation, success) {
							   if (success) {
								   if(record.length>0 && record.length==1) {  // Nonce_implmentation_changes
									   academicTopic.setValue(record[0].data.id);
									   academicTopicValue=record[0].data.id;
									   academicSubTopic.getStore().getProxy().extraParams={
										   academicTopicId: record[0].data.id
									   },
									   academicSubTopic.store.load({
										   callback : function(records, operation, success) {
											   if (success) {
												   if(records.length>0){
													academicSubTopic.setDisabled(false);
												   }
													if(records.length==1 && record.length==1) {													   
													   academicSubTopic.setValue(records[0].data.id);
													   academicSubTopicValue=records[0].data.id;
												   }
											   }
										   }
									   });

								   }
							   }
						   }
					   });

					   program.getStore().getProxy().extraParams={
						   studentId: userId,
						   academyLocationId: academyLocationId	
					   },
					   program.getStore().load({
						   callback : function(record, operation, success) {

							   if (success) {
								   for(var i=0;i<record.length;i++)
								   { 
//									   if(record[i].data.isCurrentPeriod &&  record[i].data.isCurrentSection && isNullOrEmpty(record[i].data.exitDate) )
//									   {
//										   iscurruntPeriodId.setValue(record[i].data.isCurrentPeriod);
//										   iscurruntSectionId.setValue(record[i].data.isCurrentSection);
//										   exitDateId.setValue(record[i].data.exitDate);
//										   program.setValue(record[i].data.programId);
//
//										   programValue=record[i].data.programId;
//										   addbtn.enable();
//										   editbtn.enable();
//										   deletebtn.enable();
//										   batchCombo.setValue(record[i].data.batchId);
//										   batchCombo.store.getProxy().extraParams={
//											   studentId: userId,
//						   					   academyLocationId: academyLocationId
//										   },
//										   batchCombo.store.load({
//											   callback : function(records, operation, success) {
//												   if (success) {
//													   batchCombo.setValue(records[i].data.batchId);
//													   batchValue=records[i].data.batchId;
//													   var periodField = obj.down('#periodId');
//													   var periodField=periodField.getStore();
//													   delete periodField.proxy.extraParams.id;
//													   periodField.getProxy().extraParams = {
//														   id: records[i].data.batchId
//													   };
//													   periodField.load({
//														   callback : function(records, operation, success) {
//															   if (success) {
//																   if(records.length==1){
//																	   obj.down('#periodId').setValue(records[0].get('id'));
//																	   periodValue=records[0].get('id');
//																   }
//													                else
//													               {
//														              for(var i=0;i<records.length;i++) {
//														               if(records[i].data.isCurrentPeriodOfProgram)
//													                  {
//														               obj.down('#periodId').setValue(records[i].data.id);
//														               periodValue = obj.down('#periodId').getValue();
//													                  }
//														            }
//													                }
//																   var grid = obj.up('academicstopicsstructureforstudentprofile').down('academicstopicquicksearchgrid');
//																   var form = obj.getForm();
//																   var studentId = userId;
//																   var admissionId = personProfile.getAdmissionId();
//																   if(!isNullOrEmpty(studentId) && isNullOrEmpty(admissionId)){
//																	   var studentProfileUrl = SERVERURL.PATH_FIND_ADMISSION_ID_BY_STUDENTID;
//																	   Ext.Ajax.request({
//																		   type: 'rest',
//																		   url : studentProfileUrl+"?studentId="+studentId,
//																		   method: 'GET',
//																		   async: false,
//																		   success: function(res, action) {
//																			   admissionId = Ext.decode(res.responseText);
//																		   },
//																		   failure: function(res, action) {
//																			   Ext.getBody().unmask();
//																		   }
//																	   });
//																   }
//																   grid.getStore().getProxy().extraParams ={
//																	   acadmicTypeId:academicTopicValue,
//																	   academicSubTypeId:academicSubTopicValue,
//																	   programId:programValue,
//																	   batchId:batchValue,
//																	   periodId:periodValue,
//																	   studentId:userId
//																   };
//																   grid.getStore().load();
//															   }
//														   }
//													   });
//												   }
//											   }
//										   });
//										   break;
//									   }else{
//										   addbtn.disable();
//										   editbtn.disable();
//										   deletebtn.disable();
//									   }
								   }



							   }

						   }

					   });
				   }
			   },
			   'academicstopicquicksearchform customcombobox[itemId=academicTopicItemId]': {
				   afterrender: function(academicTopic, records, eOpts) {
					   var this$ = this;
					   var user = this.getCurrentlyLoggedInUser();
					   var   academicTopicStore = academicTopic.getStore();
					   academicTopicStore.proxy.extraParams = {
							   userId:user.id
                       };
					   academicTopicStore.load();
//					   this.loadAcademicTopicDependentCombo(academicTopic, '', 'topicName');
				   },
				   select: function(academicTopic, records, eOpts) {
					   var academicSubTopic = academicTopic.up('form').down('#academicSubTopicItemId');
					   academicSubTopic.setDisabled(false);
					   var academicSubTopicValue = academicTopic.getValue();
					 this.loadAcademicTopicDependentCombo(academicSubTopic,academicSubTopicValue, 'academicTopicId');     
				   }
			   },
			   
			   
			   'academicstopicquicksearchform customcombobox[itemId=programItemId]': {
				   render: function(obj){
					   var $this=this;
						var form=obj.up('form').getForm();
						var academyLocationId = $this.getCurrentAcademyLocation();
						var personProfile = $this.getContentPanelActiveTab();
						var studentId = personProfile.getUserId();
        			    var programId =form.findField('programId');
        			    var   ProgramIdStore = programId.getStore();
        			    ProgramIdStore.proxy.extraParams = {
        			    		studentId :  studentId
                               ,academyLocationId:academyLocationId
                        };
        			    ProgramIdStore.load();
             },
				   select: function(cmp, records) {
					   var batchCombo = cmp.up('form').down('#batchCombo');
					   batchCombo.reset();
					   batchCombo.enable();
					   var periodCombo = cmp.up('form').down('#periodId');
					   periodCombo.reset();
					   periodCombo.disable();
					   cmp.up('form').isValid();
					   var personProfile = this.getContentPanelActiveTab();
					   var studentId = personProfile.getUserId();
					   batchCombo.getStore().getProxy().extraParams = {
						   studentId: studentId,
						   programId: records[0].get('id')
					   };
					   batchCombo.getStore().load();
				   }
			   },
			   
			   'academicstopicquicksearchform customcombobox[itemId=batchCombo]': {
				   select: function(cmp, records) {
					   var periodCombo = cmp.up('form').down('#periodId');
					   periodCombo.reset();
					   periodCombo.enable();
					   var personProfile = this.getContentPanelActiveTab();
					   var studentId = personProfile.getUserId();
					   periodCombo.getStore().getProxy().extraParams = {
						   id: records[0].get('id')
					   };
					   periodCombo.getStore().load();
				   }
			   },
			   
			   
//			   'academicstopicquicksearchform customcombobox[itemId=programItemId]': {
//				   afterrender: function(program, records, eOpts) {
//					   var this$ = this;
//					   var personProfile = this$.getContentPanelActiveTab();
//					   var userId = personProfile.getUserId();
//				   },
//				   select: function(combo, records, eOpts) {
//					   var batch = combo.up('form').down('#batchCombo');
//					   var period=combo.up('form').down('#periodId');
//					   var iscurruntPeriodId = combo.up('form').down('#iscurruntPeriodId');
//					   var iscurruntSectionId=combo.up('form').down('#iscurruntSectionId');
//					   var exitDateId=combo.up('form').down('#exitDateId');
//					   batch.setDisabled(false);
//					   var comboValue = combo.getValue();
//					   iscurruntPeriodId.setValue(records[0].data.isCurrentPeriod);
//					   iscurruntSectionId.setValue(records[0].data.isCurrentSection);
//					   exitDateId.setValue(records[0].data.exitDate);
//					   this.loadAcademicTopicDependentCombo(batch, comboValue, 'programId');
//					   period.reset();
//				   }
//			   },
//			   'academicstopicquicksearchform combo[itemId=batchCombo]': {
//				   select: function(combo, records, eOpts) {
//					   var period = combo.up('form').down('#periodId');
//					   period.setDisabled(false);
//					   var comboValue = combo.getValue();
//					   this.loadAcademicTopicDependentCombo(period, comboValue, 'id');
//				   }
//			   },
			   'academicstopicquicksearchform button[itemId=academicTopicSearchButtonId]': {
				   click:this.loadAcademicTopicData
			   },
			   'academicstopicquicksearchform button[itemId=clearSearch]': {
				   click:function(obj, rec){
					   this.resetAcademicTopicFormDropdowns();
				   }
			   },
			   'academicstopicquicksearchgrid button[itemId=btnAdd]': {
				   click: function() {
					   var $this =this;
					   this.viewMode=false;
					   $this.addEditBtn = true;
					   var grid = this.getAcademicstopicquicksearchgrid();
					   grid.buttonName='ADD_VIEW';
					   //Ext.widget('academictopicdocumentgrid');
					   $this.showPersonCommonWindow('ACADEMICS_TOPIC', 'academictopicdetails');
					   var formWindow = $this.getPersonCommonWindow();
					   if( formWindow != null ){
//		        			  var form = formWindow.down();
						    
		        			  var createdDate = formWindow.down('#createdDate');
		        			  createdDate.setValue(dateRender(new Date()));
		        			  createdDate.setReadOnly(true);
		        			  var user = this$.getCurrentlyLoggedInUser();
		        			  var createdById = formWindow.down('#createdById');
		        			  createdById.setValue(user.code+'/'+user.value); 
		        			  
		        			  var updatedDate = formWindow.down('#updatedDate');
		        			  updatedDate.setValue(dateRender(new Date()));
		        			  updatedDate.setReadOnly(true);
		        			  var user = this$.getCurrentlyLoggedInUser();
		        			  var updatedById = formWindow.down('#updatedById');
		        			  updatedById.setValue(user.code+'/'+user.value);
		        			  setTimeout(function(){
		        				formWindow.down('#dateId').setValue(dateRender(new Date()));
		        			  },500);
		        			  
		        			  
		        		}
					   var documentGrid = $this.getAcademictopicdocumentgrid();
       				var documentGrids = documentGrid.down('#btnEdit');
//       				documentGrids.setDisabled(false);
       				documentGrids.setVisible(false);
				   }
			   },
			   'academicstopicquicksearchgrid button[itemId=btnEdit]': {
				   click: function(){
					   this.viewMode=false;
					   this.addEditBtn = false;
					   var grid = this.getAcademicstopicquicksearchgrid();
					   grid.buttonName='EDIT_VIEW';
					   this.editAcadmicTopicFormWindow('ACADEMICS_TOPIC','academictopicdetails', 'academicstopicquicksearchgrid');
				   }
			   },
			   'academicstopicquicksearchgrid button[itemId=btnView]': {
				   click: function(){
					   this.viewMode=true;
					/*   var form=this.getAcademicstopicquicksearchform();
					 var clickMode = form.down('#clickModeId');
					 clickMode.setValue('VIEW');*/
					   this.viewAcademicTopicDetailFormWindow('ACADEMICS_TOPIC', 'academicstopicquicksearchform', '#academicstopicquicksearchgrid');
					   
				   }
			   },
			   'academicstopicsstructureforstudentprofile academicstopicquicksearchgrid[itemId=academicstopicquicksearchgrid]': {
				   afterrender:function(grid){
					   var me = this;
					   setTimeout(function(){
						   me.addDataGridConfigButton(grid,me.getSTUDENT_ACADEMICS_TOPIC_PERMISSION());
					   },1500);

				   },
				   cellclick: function(gridview, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					   var $this = this;
					   var grid = gridview.up('grid');
					   var columnName = grid.columnManager.columns[cellIndex].dataIndex;
					   if(e.target.tagName == 'A' && columnName == 'academicTopicDocuments') {
						   if(record.data.documents.length == 1){
							   var whetherFile = false;
							   var documentId= record.data.documents["0"].encryptedDocId;
							   if(!isNullOrEmpty(documentId)){
								   Ext.Ajax.request({
									   type: 'rest',
									   url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									   method: 'GET',
									   callback : function(opt, success, response){
										   if(response.responseText == 'true') {
											   var csvForm = Ext.create('Ext.form.Panel'); 
											   csvForm.getForm().submit({
												   target: '_blank',
												   method:'GET',
												   params :{
													   access_token : Ext.Ajax.defaultHeaders.access_token
												   },
												   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												   standardSubmit :true
											   });
										   }
										   else {
											   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										   }
									   }
								   });
							   }
						   }
						   else if(record.data.documents.length > 1){
							   var docWindow = this.getAcademictopicdocumentspopup();
							   if (!docWindow) {
								   docWindow = Ext.widget('academictopicdocumentspopup',{
									   itemId:'academictopicdocumentspopup'
								   });
							   }
							   docWindow.show();
							   docWindow.center();
							   var academictopicdocumentsgrid = docWindow.down('#academictopicdocumentsgridItemId');
							   var store = academictopicdocumentsgrid.getStore();
							   store.getProxy().extraParams = {
								   academicTopicId: record.data.id
							   };
							   store.load({
								   callback: function() {
									   docWindow.center();
								   }
							   });
						   }
					   }
					   else if(e.target.tagName == 'A' && columnName == 'academicTopicUrls') {
						   if(record.data.academicTopicUrls.length == 1){
							   var whetherFile = false;
							   var documentId= record.data.urlName["0"].id;
							   if(!isNullOrEmpty(documentId)){
								   Ext.Ajax.request({
									   type: 'rest',
									   url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									   method: 'GET',
									   callback : function(opt, success, response){
										   if(response.responseText == 'true') {
											   var csvForm = Ext.create('Ext.form.Panel'); 
											   csvForm.getForm().submit({
												   target: '_blank',
												   method:'GET',
												   params :{
													   access_token : Ext.Ajax.defaultHeaders.access_token
												   },
												   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												   standardSubmit :true
											   });
										   }
										   else {
											   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										   }
									   }
								   });
							   }
						   }
						   else if(record.data.academicTopicUrls.length > 1){
							   var docWindow = this.getAcademictopicurlpopup();
							   if (!docWindow) {
								   docWindow = Ext.widget('academictopicurlpopup',{
									   itemId:'academictopicurlpopup'
								   });
							   }
							   docWindow.show();
							   docWindow.center();
							   var academictopicdocumentsgrid = docWindow.down('#academictopicurlsgridItemId');
							   var store = academictopicdocumentsgrid.getStore();
							   store.getProxy().extraParams = {
								   academicTopicId: record.data.id
							   };
							   store.load({
								   callback: function() {
									   docWindow.center();
								   }
							   });
						   }
					   }
				   }
			   },
			   
			   'academicstopicquicksearchgrid button[itemId=btnDelete]': {
				   click: function(){
					   this.deleteAcademicTopicRecord('#academicstopicquicksearchgrid', SERVERURL.DELETE_ACADEMIC_TOPIC_DATA);
				   }
			   },
			   'personcommonwindow[itemId=personCommonWindow] academicstopicquicksearchform[itemId=academicstopicquicksearchform]': {
				   render: function() {
					   var parentGuardianForm = this.getPersonParentGuardianForm();
					   this.onRenderHideInnerParentGuardianFormField(parentGuardianForm);
					   this.getPersonCommonWindow().doLayout();
				   }
			   },
			   'academictopicdetails': {
				   afterrender: function(form) {
					   var this$ = this;
					   var personProfile = this$.getContentPanelActiveTab();
					   var userId = personProfile.getUserId();
                       var form1=this$.getAcademictopicdetails().getForm();

                       var programIdField=form1.findField('programId');
                       var batchIdField=form1.findField('batch');
                      

					   var stdForm = this$.getAcademictopicdetails().getForm();
					   var program=stdForm.findField('programId');
					   var batch=stdForm.findField('batch');
					   var batchCombo = form.down('#batchCombo');
					   var periodField = form.down('#periodId');
					   
					   var associatedAcadLocationIds = new Array();
					    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					  
					   var uploadDocCheckBox =form.down('#uploadDocumentItemId');
					   
					   var permissionsMap=this.getSTUDENT_ACADEMIC_TOPIC_DETAILS_PERMISSIONS();
						  
					   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					   uploadDocCheckBox.setVisible(false);
					   Ext.each(permissionList, function(privilege) {
				    		if (privilege == "UPLOAD_DOCUMENT") {
				    			 uploadDocCheckBox.setVisible(true);
							}
					   }); 
					   
					  /* var form=this.getAcademicstopicquicksearchform();
						var clickMode = form.down('#clickModeId');
						var clickmodeValue=clickMode.getValue();*/

					   //var grid = obj.up('academicstopicsstructureforstudentprofile').down('academicstopicquicksearchgrid');
					   var grid = this$.getAcademicstopicquicksearchgrid();
                      if( grid.buttonName=='ADD_VIEW'){
					   program.store.getProxy().extraParams={
						   studentId: userId,
						   academyLocationId:this$.getCurrentAcademyLocation()
					   };
					   var tempArray=[];
					   program.store.load({
						   callback : function(record, operation, success) {
							   if (success) {
								     	for(var i=0;i<record.length;i++) {
								     	/*if(record[i].data.isCurrentPeriod &&  record[i].data.isCurrentSection && isNullOrEmpty(record[i].data.exitDate) )
								     	{
								     		//code revert for V2D-422971
								       	}*/
								       	tempArray.push(record[i]);
							       		 }
								     	 program.store.removeAll();
								     	 program.store.loadRecords(tempArray);
								     	 if(tempArray.length == 1){
								     	   program.setValue(tempArray[0].data.id);
										   batchCombo.store.getProxy().extraParams={
											   studentId: userId,
											   programId:tempArray[0].data.id,
										    }
										   		batchCombo.store.load({
														callback: function (records, operation, success) {
															if (success) {
																batchCombo.setDisabled(false);
																if (records.length == 1) {
																	periodField.setDisabled(false);
																	batchCombo.setValue(records[0].get('id'));
																	var programId =form1.findField('programId');
																	periodField.store.getProxy().extraParams = {
																		batchId: records[0].data.id,
																		isCurrentPeriod: true,
																		studentId: userId,
																		 programId: programId.getValue()
																	};
																	periodField.store.load({
																		callback: function (rec, operation, success) {
																			if (success) {
																				if (rec.length == 1) {
																					periodField.setValue(rec[0].get('id'));
																				} else {
																					periodField.setReadOnly(false);
																				}
																			}
																		}
																	});
																	var academicTermStore = form.down('#academicTermId').getStore();
																	academicTermStore.getProxy().extraParams = {
																		batchId: records[0].get('id')
																	};
																	academicTermStore.load();
																}
															}
														}
													});
								     	 }else{
								     		batchCombo.setDisabled(true);
								     		periodField.setDisabled(true);
								     	 }
							   }
						   }
					 
					   });
                      }
                      
				   }
			   },
			   'academictopicdetails customcombobox[itemId=academicTopicItemId]': {
				   afterrender: function(academicTopic, records, eOpts) {
					   var this$ = this;
					   var user = this.getCurrentlyLoggedInUser();
                       var   academicTopicStore = academicTopic.getStore();
                       academicTopicStore.proxy.extraParams = {
                               userId:user.id
                       };
                       academicTopicStore.load();
					 //  this.loadAcademicTopicDependentCombo(academicTopic, '', 'topicName');
				   },
				   select: function(academicTopic, records, eOpts) {
					   var academicSubTopic = academicTopic.up('form').down('#academicSubTopicItemId');
					   academicSubTopic.setDisabled(false);
					   var academicSubTopicValue = academicTopic.getValue();
					     var   academicTopicStore = academicTopic.getStore();
					     
                      academicTopicStore.load();
					    var code = records[0].raw.code;
					     var periodField = academicTopic.up('form').down('#periodId'); 
					       periodField.setVisible(true);
					       this.setAllowBlank(periodField,false);
					   if(code=='PRE_ENROLLED_PERIOD_DOCUMENTS'){						 
						   periodField.setVisible(false);
						     this.setAllowBlank(periodField,true);
					   }
					   this.loadAcademicTopicDependentCombo(academicSubTopic, academicSubTopicValue, 'academicTopicId');
				   }
			   },
//			   'academictopicdetails customcombobox[itemId=programItemId]': {
//				   afterrender: function(program, records, eOpts) {
//					   var this$ = this;
//					   var personProfile = this$.getContentPanelActiveTab();
//					   var userId = personProfile.getUserId();
//					   this.loadAcademicTopicDependentCombo(program, userId, 'studentId');
//				   },
//				   select: function(combo, records, eOpts) {
//					   var batch = combo.up('form').down('#batchCombo');
//					   batch.setDisabled(false);
//					   var comboValue = combo.getValue();
//					   this.loadAcademicTopicDependentCombo(batch, comboValue, 'id');
//				   }
//			   },
//			   'academictopicdetails combo[itemId=batchCombo]': {
//				   select: function(combo, records, eOpts) {
//					   var period = combo.up('form').down('#periodId');
//					   period.setDisabled(false);
//					   var comboValue = combo.getValue();
//					   this.loadAcademicTopicDependentCombo(period, comboValue, 'id');
//				   }
//			   },
			   'academictopicdetails customcombobox[itemId=programItemId]': {
				   render: function(obj){
					   var $this=this;
						var form=obj.up('form').getForm();
						var academyLocationId = $this.getCurrentAcademyLocation();
						var personProfile = $this.getContentPanelActiveTab();
						var studentId = personProfile.getUserId();
        			    var programId =form.findField('programId');
        			    var   ProgramIdStore = programId.getStore();
        			    ProgramIdStore.proxy.extraParams = {
        			    		studentId :  studentId
                               ,academyLocationId:academyLocationId
                        };
        			    ProgramIdStore.load({
        			    	callback: function(record) {
        			    		if(record && record.length == 1) {
        			    			programId.setValue(record[0].data.id);
        			    			programId.setReadOnly(true);
        			    			var batchCombo = form.findField('batch');
        			    			batchCombo.enable();
        			    			var personProfile = $this.getContentPanelActiveTab();
        			    			var studentId = personProfile.getUserId();
        			    			batchCombo.getStore().getProxy().extraParams = {
        			    				studentId: studentId,
        			    				programId: record[0].get('id')
        			    			};
        			    			batchCombo.store.load({
        			    				callback : function(records, operation, success) {
        			    					if (success) {
        			    						if(records && records.length == 1) {
        			    							batchCombo.setValue(records[0].data.id);
													batchCombo.setDisabled(false);
        			    							batchCombo.setReadOnly(true);  
        			    							var periodCombo = form.findField('period');
        			    							periodCombo.enable();
        			    							var personProfile = $this.getContentPanelActiveTab();
        			    							var studentId = personProfile.getUserId();
                                                    var programId = form.findField('programId');
        			    							periodCombo.getStore().getProxy().extraParams = {
        			    								studentId: studentId,
                                                        programId: programId.getValue(),
        			    								batchId: records[0].get('id')
        			    							};
        			    							periodCombo.store.load({
        			    								callback : function(records, operation, success) {
        			    									if (success) {
        			    										if(records && records.length == 1){
        			    											periodCombo.setValue(records[0].get('id'));
        			    											periodCombo.setReadOnly(true);
        			    										}else{
        			    											var grid = $this.getAcademicstopicquicksearchgrid();
        			    											if(grid.buttonName == 'ADD_VIEW') {
        			    												periodCombo.setReadOnly(false);
        			    											}
        			    										}
        			    									}
        			    								}
        			    							});
        			    						}
        			    					}
        			    				}
        			    			});
        			    		}
        			    	}
        			    });
             },afterrender: function(program, records, eOpts) {
					   var this$ = this;
					   var personProfile = this$.getContentPanelActiveTab();
					   var userId = personProfile.getUserId();
					   this.loadAcademicTopicDependentCombo(program);
				   },
				   select: function(combo, records, eOpts) {
					   var batch = combo.up('form').down('#batchCombo');
					   var period = combo.up('form').down('#periodId');
					   period.clearValue();
					   period.store.removeAll();
					   period.reset();
					   batch.setDisabled(false);
					   var comboValue = combo.getValue();
					   var activeTab = this.getContentPanelActiveTab();
	                    var studentId = activeTab.getUserId();

						batch.getStore().getProxy().extraParams = {
                           programId:comboValue,
                           studentId: studentId
                       };   
                        batch.getStore().load();   
					  // this.loadAcademicTopicDependentCombo(batch, comboValue, 'programId', 'studentId', studentId);
				   }
			   },
			   'academictopicdetails combo[itemId=batchCombo]': {
				   select: function(cmp, records) {
					   var periodCombo = cmp.up('form').down('#periodId');
		               var academicTermCombo = cmp.up('form').down('#academicTermId');
					   periodCombo.reset();
					   periodCombo.enable();
		               academicTermCombo.reset();
					   academicTermCombo.enable();
					   var personProfile = this.getContentPanelActiveTab();
					   var studentId = personProfile.getUserId();
					   periodCombo.getStore().getProxy().extraParams = {
						   batchId: records[0].get('id'),
						   studentId: studentId
					   };
		               academicTermCombo.getStore().getProxy().extraParams={
			               batchId: records[0].get('id'),
		               }
					   periodCombo.getStore().load();
		               academicTermCombo.getStore().load();
				   }
				   
			   },  'academictopicdetails combo[itemId=academicTermId]': {
				   select: function(cmp, records) {
					   var batchCombo = cmp.up('form').down('#batchCombo');
					  
				   }
				   
			   },

			   'academictopicdetails button[itemId=submitButtonId]': {
				   click: function(){
					   this.saveStudentAcademicTopics('#academicstopicquicksearchgrid', SERVERURL.SAVE_ACADEMIC_TOPIC_DATA);
				   }
			   },
			   'academictopicdetails button[itemId=cancelButtonId]': {
				   click: function() {
					   this.getPersonCommonWindow().close();
				   }
			   },
			   'academictopicdetails checkboxfield[itemId=uploadDocumentItemId]': {
				   /*change: function(obj, newValue, oldValue) {
					  var form= obj.up('academictopicdetails');
					  var grid= form.down('academictopicdocumentgrid');
					  grid.getStore().removeAll();
					  if(newValue){
						  grid.setVisible(true); 
						
					  }else{
						  grid.setVisible(false); 
					  }
				   }*/
			   },
			   'mycoursequicksearchform[itemId=studentMyCourseQuickSearchForm]':{
				   afterrender: function(form) {
					   var this$ = this;
					   var studentALField = form.down("#studentAcademyLocation");
					   var courseType =form.down('#coruseTypeId');
					   var courseWise =form.down('#courseWise');
					   var periodWise=form.down('#periodWise');
					   var courseGrid = this$.getStudentcoursereportgrid();
					   var periodGrid = this$.getStudentcoursereportbyperiodgrid();
					   var permissionsMap = new Ext.util.HashMap();
					   var associatedAcadLocationIds = new Array();
					   var isCourseWise = false;
					   var isPeriodWise = false;
					   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					  
					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
							studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
							this$.setAllowBlank(studentALField, false);
							studentALField.show();
					   }else{
							studentPortalInfo = this.getStudentDetailForErpPortal();
							this$.setAllowBlank(studentALField, false);
							studentALField.hide();
					   } 
					   
					   if(this.getCurrentLoggedPortalId()==2){
						   permissionsMap=this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS();
					   }
					   if(this.getCurrentLoggedPortalId()==1){
					    	permissionsMap=this.getCOURSE_MASTER_PERMISSIONS();
					    	this.addDataGridConfigButton(courseGrid,this.getCOURSE_MASTER_PERMISSIONS());
					   }
					   if(this.getCurrentLoggedPortalId()==3)
						   {
						  permissionsMap=this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS();
						   }
					   if(this.getCurrentLoggedPortalId()==7)
					   {
						   permissionsMap=this.getPARENT_COURSE_MASTER_PERMISSIONS();
					   }
					   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					   
					   Ext.each(permissionList, function(privilege) {
				    		if (privilege == "COURSEWISERADIOBUTTON") {
				    			isCourseWise = true;
							}
							if (privilege == "PERIODWISERADIOBUTTON") {
								isPeriodWise=true;
				    		}
					    });
					    
					    if(isCourseWise && isPeriodWise){
					    	if(!isNullOrEmpty(courseType)){
								courseType.setVisible(true);
							}
					    }else if(!isCourseWise && !isPeriodWise){
					    	if(!isNullOrEmpty(courseType)){
								courseType.setVisible(false);
							}
					    }else if(isPeriodWise){
					    	periodWise.setValue(true);
					    	courseWise.setValue(false);
					    	setTimeout(function(){
					    		this$.changeCourseTypeReport(periodWise);
						    	courseType.setVisible(false);
					    	},300);
					    }else{
					    	courseType.setVisible(false);
					    }
					    
					    
					   var studentId = studentPortalInfo.student.id;
					   var programId = studentPortalInfo.programBatchDetails.programId;
					   var batchId = studentPortalInfo.programBatchDetails.batchId;
					   var periodId = studentPortalInfo.programBatchDetails.periodId;
					   var sectionId = studentPortalInfo.programBatchDetails.sectionId;
					   form.down('#studentHiddenId').setValue(studentId);
					   form.down('#programHiddenId').setValue(programId);
					   form.down('#batchHiddenId').setValue(batchId);
					   form.down('#periodHiddenId').setValue(periodId);
					   form.down('#sectionHiddenId').setValue(sectionId);
					   
					   if(form.down('#attendanceProgram').isVisible()){
						   form.down('#attendanceProgram').store.on('load', function(){
							   if(form.down('#attendanceProgram').store.getCount()){
								   form.down('#attendanceProgram').setValue(form.down('#attendanceProgram').store.data.items[0].data.id);
							   }
						   });
					   }
				   }   
			   },
			   'degreeauditreportprofileview':{
					render: function(view){
						this.auditReportProfileFormChartGridLoad(view);
					}
				},
				'degreeauditreportprofileview form[itemId=degreeAuditReportSearchForm] button[itemId=degreeAuditReportFindButtonId]':{
					click: function() {
						this.auditReportProfileChartAndGridLoad();
					}
				},
		        'degreeauditreportprofileview form[itemId=degreeAuditReportSearchForm] customcombobox[itemId=programId]': {
		               select: function(obj) {
		            	   var $this = this;
		            	   var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
		           		   var academyLocationId = $this.getCurrentAcademyLocation();
		           		   var view = $this.getDegreeauditreportprofileview();
		           		   var form = view.down('#degreeAuditReportSearchForm').getForm();
		            	   var programField = form.findField('programId');
		           		   var batchField = form.findField('batchId');
		           		   var findButton = view.down('#degreeAuditReportSearchForm').down('#degreeAuditReportFindButtonId');
		           		   if($this.getCurrentLoggedPortalId()==1|| $this.getCurrentLoggedPortalId()==2){
			        			studentPortalInfo = $this.getStudentDetailForErpPortal();
		           		   } 
		           		   batchField.reset();
		            	   batchField.store.getProxy().extraParams={
								studentId : studentPortalInfo.student.id,
								programId : programField.getValue(),
								onlyCurrentRecord:false
							},
							batchField.store.load({
								callback : function(records, operation, success) {
									if (success) {
										if(records.length==1){
											batchField.setValue(records[0].data.id);
											findButton.setDisabled(false);
										}
									}
								}
							});	
		            	   
		               }
			        },
				'degreeauditreportprofileview form[itemId=degreeAuditReportSearchForm] button[itemId=degreeAuditReportClearSearch]': {
			         click: function() {
			        	 var view = this.getDegreeauditreportprofileview();
			        	 this.auditReportProfileFormChartGridLoad(view);
			         }
				},
				'degreeauditreportgrid[itemId=profileDegreeAuditReportGrid] button[itemId=exportDegreeAuditReportGrid]':{
					click: function() {
						var $this = this;
			     	    if(this.getCurrentLoggedPortalId()==1|| this.getCurrentLoggedPortalId()==2){
							studentPortalInfo = this.getStudentDetailForErpPortal();
			     	    }
			     	    var view = $this.getDegreeauditreportprofileview();
			     	    var form = view.down('#degreeAuditReportSearchForm').getForm();
	            	    var programField = form.findField('programId');
	           		    var batchField = form.findField('batchId');
					    var reportParams =new Object();
     				    reportParams.PROGRAM_ID = programField.getValue();
     				    reportParams.BATCH_ID = batchField.getValue();
     				    reportParams.STUDENT_ID = studentPortalInfo.student.id;
     				    reportParams.reportTitle ="Degree Audit Report";

     				    var code = "AU_DEGREE_AUDIT_REPORT";
     				    var URL = SERVERURL.PATH_FIND_DEGREE_AUDIT_EXPORT_REPORT;
     				    $this.exportJRXMLReport(code, reportParams, reportParams.reportTitle,'.pdf', URL);
					}
				},
				'vwmycoursedetailslearningtargets button[itemId=learningTargetSubmit]': {
				   click: function(obj) {
					   this.stdMyCourseLearningTargetsSubmit(obj);
				   }
				},
				'vwmycoursedetailslearningtargets button[itemId=btnPrintLearningPlan]': {
				   click: function(obj) {
				    	var $this = this;
				    	var form=this.getMyCourseQuickSearchForm();
						var formValues=form.getValues();
				    	var grid = obj.up('grid').getStore();
				    	if(isNullOrEmpty(grid.data.items)) {
				    		return;
				    	}
				    	var personProfile = $this.getContentPanelActiveTab();
				    	var admissionId = grid.data.items[0].data.admissionId;
				    	var academyLocationId = $this.getCurrentAcademyLocation();
				    	var templateCode = "";
				    	var templateWindow = false;
				    	var templateURL = SERVERURL.TEMPLATE_NAME_BY_CODE;
						Ext.Ajax.request({
							type: 'rest',
							url : templateURL+"?academyLocationId="+academyLocationId+"&reportType=Learning Plan",
							method: 'GET',
							async: false,
							success: function(res, action) {
								var responseTemp = Ext.decode(res.responseText);
								if(responseTemp.length == 2){
									templateWindow = true;
								} else if(responseTemp.length == 1){
									templateCode = responseTemp[0].value;
								} else{
									showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REPORT_TEMPLATE_IS_NOT_CONFIGURED'));
								}
							},
							failure: function(res, action) {
								Ext.getBody().unmask();
	        					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
							}
						});
						if(!isNullOrEmpty(templateCode)){
						    var reportParams =new Object();
							    reportParams.PROGRAM_ID = formValues.programId;
							    reportParams.BATCH_ID = formValues.batch;
							    reportParams.ADMISSION_ID = admissionId;
							    reportParams.STUDENT_NAME=personProfile.getPersonInfo().printName;
							    if(templateCode == 'LEARNING_TARGET_PLAN_REPORT'){
							    	reportParams.PERIOD_ID = formValues.period;
							    }
							this.generateLearningTemplateReport(reportParams, templateCode);
						} else if(templateWindow == true){
							var formWindow1 = this.getConsolidatedlearningplantemplatewindow();
							if (!formWindow1) {
								Ext.widget('consolidatedlearningplantemplatewindow');
								formWindow1 = this.getConsolidatedlearningplantemplatewindow();
							}
			    			var admissionIdField = formWindow1.down('#admissionId');
			    			var programId = formWindow1.down('#programId');
			    			var batchId = formWindow1.down('#batchId');
			    			var periodId = formWindow1.down('#periodId');
			    			var studentName = formWindow1.down('#studentName');
							var templateType = formWindow1.down('#templateType');
							admissionIdField.setValue(admissionId);
							programId.setValue(formValues.programId);
							batchId.setValue(formValues.batch);
							periodId.setValue(formValues.period);
							studentName.setValue(personProfile.getPersonInfo().printName);
			    			  var store = templateType.getStore();
			    			  store.getProxy().extraParams = {
			    				  academyLocationId: academyLocationId,
			    				  reportType: 'Learning Plan'
         					 };
         					 store.load();
							formWindow1.show();
						}
				   }
				},
				
				'consolidatedlearningplantemplatewindow button[itemId=submitBtn]': {
					   click: function(obj) {
						   var $this = this;
						   var form = $this.getConsolidatedlearningplantemplatewindow();
						   var templateCode = form.down('#templateType').getValue();
						   var admissionId = form.down('#admissionId').getValue();
			    			var programId = form.down('#programId').getValue();
			    			var batchId = form.down('#batchId').getValue();
			    			var periodId = form.down('#periodId').getValue();
			    			var studentName = form.down('#studentName').getValue();
			    			var reportParams =new Object();
						    reportParams.PROGRAM_ID = programId;
						    reportParams.BATCH_ID = batchId;
						    reportParams.ADMISSION_ID = admissionId;
						    reportParams.STUDENT_NAME=studentName;
						    if(templateCode == 'LEARNING_TARGET_PLAN_REPORT'){
						    	reportParams.PERIOD_ID = periodId;
						    }
						   this.generateLearningTemplateReport(reportParams, templateCode);
						   $this.getConsolidatedlearningplantemplatewindow().close();
					   }
				 },
				
				 'vwmycoursedetailslearningtargets button[itemId=resetBtn]': {
					   click: function(obj) {
						   this.stdMyCourseLearningTargetsReset(obj);
					   }
				 },
				 'vwmycoursedetailslearningtargets':{
					 render: function(structure) {
						 var learningTargetMarksGrid=structure.down('#stuLearningTargetMarkGridItemId');
						 var learningTargetGradeGrid=structure.down('#stuLearningTargetGradeGridItemId');
						 if(portalId == 7){
							 structure.down('#resetBtn').hide();
							 this.doAccessControlValidation(learningTargetMarksGrid, this.getPARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessControlValidation(learningTargetGradeGrid, this.getPARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetMarksGrid, this.getPARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetGradeGrid, this.getPARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS()); 
						 }else if(portalId == 3){
							 structure.down('#resetBtn').hide();
							 this.doAccessControlValidation(learningTargetMarksGrid, this.getSTUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessControlValidation(learningTargetGradeGrid, this.getSTUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetMarksGrid, this.getSTUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetGradeGrid, this.getSTUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS()); 
						 }else if(portalId == 2){
							 this.doAccessControlValidation(learningTargetMarksGrid, this.getFACULTY_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessControlValidation(learningTargetGradeGrid, this.getFACULTY_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetMarksGrid, this.getFACULTY_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetGradeGrid, this.getFACULTY_MYCOURSE_LEARNING_PRIVILEGES_PERMISSIONS()); 
						 } else{
							 this.doAccessControlValidation(learningTargetMarksGrid, this.getSTUDENT_MYCOURSE_LEARNING_PERMISSIONS());
							 this.doAccessControlValidation(learningTargetGradeGrid, this.getSTUDENT_MYCOURSE_LEARNING_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetMarksGrid, this.getSTUDENT_MYCOURSE_LEARNING_PERMISSIONS());
							 this.doAccessLearningGridButtonControlValidation(learningTargetGradeGrid, this.getSTUDENT_MYCOURSE_LEARNING_PERMISSIONS()); 
						 }
					 }
				 },
				 'studentacademicshistorystructure radiogroup[itemId=viewAcademicHistoryRadio]':{
					 change:function(radioObj,newVal,oldVal){

						 var structure = radioObj.up('studentacademicshistorystructure');
						 var markTypeGrid =structure.down('academicshistorygridformarktypecourse');
						 var gradeTypeGrid =structure.down('studentacademicshistorygrid');


						 if(newVal.academicHistoryFor == "GRADE_TYPE"){
							 gradeTypeGrid.setVisible(true);
							 markTypeGrid.setVisible(false);
						 }else if(newVal.academicHistoryFor == "MARK_TYPE"){
							 gradeTypeGrid.setVisible(false);
							 markTypeGrid.setVisible(true);
						 }
					 }
				 },
				 'academicshistorygridformarktypecourse':{
					 afterrender:function(grid){
						 var this$ =this;
						 
						 setTimeout(function(){
							   if(portalId==1){
							   this$.addDataGridConfigButton(grid,this$.getSTUDENT_VIEW_ACADEMIC_HISTORY_FOR_MARK_TYPE_PERMISSIONS());
							   } else if(portalId==2){
							   this$.addDataGridConfigButton(grid,this$.getFACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_MARK_TYPE_PERMISSIONS());
							   }
		        		},1500);
						 var personProfile = this$.getContentPanelActiveTab();
						 var studentAcademicsStructure = personProfile.down('studentacademicshistorystructure');
						 var studentAcademicsHistorygrid =studentAcademicsStructure.down('#academicshistorygridformarktypecourseId');
						 var store =studentAcademicsHistorygrid.getStore();
						 var personProfile = this$.getContentPanelActiveTab();	
						 var studentId = personProfile.getUserId();
						 var admissionId=personProfile.admissionId;
						 store.getProxy().extraParams = {
							 studentId:studentId
						 },
						 store.load({
							 callback : function(record, operation, success) {
								 if (success) {
									 var printTranscript=studentAcademicsHistorygrid.down('#btnPrintTranscriptItemIdForMarkType');
									 if(record.length <= 0) {
										 printTranscript.setDisabled(true);
									 }else{
										 printTranscript.setDisabled(false);
									 } 
								 }
							 }
						 }); 
					 }

				 },

				 'academicshistorygridformarktypecourse button[itemId=btnPrintTranscriptItemIdForMarkType]': {
					 click : function(grid){
						 var $this = this;
						 var formWindow = $this.getStudentacademichistoryprinttranscriptwin();
						 if (!formWindow) {
							 Ext.widget('studentacademichistoryprinttranscriptwin');
							 formWindow = $this.getStudentacademichistoryprinttranscriptwin();
						 }
						 var codeField = formWindow.down("#selectTranscriptInExcelPrint");
	                     codeField.setValue("SIS_TRANSCRIPT");
						 formWindow.setHeight(200);
						 formWindow.setWidth(500);
						 formWindow.show();
					 }
				 },
				 'academictopicdocumentgrid':{
					 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
         				var $this = this;
//         				$this.viewMode == false
         				var documentGrid = $this.getAcademictopicdocumentgrid();
         				 if($this.viewMode == true) {
							 var documentGrids = documentGrid.down('#btnEdit');
         					documentGrids.setDisabled(true);
						 }else{
							 
		         				var documentGrids = documentGrid.down('#btnEdit');
//		         				documentGrids.setDisabled(true);
		         				documentGrids.setDisabled(false); 
						 }
	
         				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

         				if (columnName == "documentName") {
         					if (e.target.tagName == 'A') {
         						var documentId = record.get("encryptedDocId");
         					if (!isNullOrEmpty(documentId)) {
         							$this.getDocumentController().downloadDocumentFile(documentId);
         						}
         					}
         				}
         			} 
				 },
				 'academictopicdocumenturlgrid':{
					 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
         				var $this = this;
         				var documentGrid = $this.getAcademictopicdocumenturlgrid();
//         				$this.viewMode == false
         				if($this.viewMode == true) {
							 var documentGrids = documentGrid.down('#btnEdit');
        					documentGrids.setDisabled(true);
						 }else{	var documentGrids = documentGrid.down('#btnEdit');
	         				documentGrids.setDisabled(false);
	         				}
         			
         				
//         				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
//
//         				if (columnName == "documentName") {
//         					if (e.target.tagName == 'A') {
//         						var documentId = record.get("encryptedDocId");
//         						if (!isNullOrEmpty(documentId)) {
//         							$this.getDocumentController().downloadDocumentFile(documentId);
//         						}
//         					}
//         				}
         			} 
				 },
				 'academictopicdocumentgrid button#btnAdd' : {
					 click : function() {
						 var grid = this.getAcademictopicdocumentgrid();
						 var recordCount = grid.getStore().getCount();
						 if(recordCount > 4){
							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_FILE_UPLOAD_LIMIT_EXIT'));

						 }else{
							 this.getDocumentController().showDocumentFormWindow('academicTopicDocumentFormItemId','DOCUMENT');
							 
							 const myInterval = setInterval(myTimer, 500);
							 function myTimer() {
								 var win = Ext.ComponentQuery.query('#academicTopicDocumentFormItemId')[0];
								 if(win) {
									 /*var fileVal = win.down('#uploadFileField').getValue();
									 if(isNullOrEmpty(fileVal)) {
										 win.down('#uploadFileField').reset();
									 }*/
									 win.down('form').isValid();
									 win.down('form').getForm().clearInvalid();
								 }
								 else {
									 clearInterval(myInterval);
								 }
							 }
						 }
						
						 
					 }
				 },
				 'documentformwindow[itemId=academicTopicDocumentFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
					 click : function(btn) {
						 var $this = this;
			                var window = this.getAcademictopicdetails();
			                var grid= $this.getAcademictopicdetails().down('academictopicdocumentgrid');
						 //var id = window.down('#acadmicTopicHiddenId').value;
						 var docAddEditWin = btn.up('documentformwindow');
						 var id = '';
						 if(docAddEditWin.down('hiddenfield[name=documentId]')) {
							 id = docAddEditWin.down('hiddenfield[name=documentId]').getValue();
						 }
					/*	 if(id == ""){
							 var docGrid = this.getAcademictopicdocumentgrid();
						    	//var addBtn = docGrid.down('#btnAdd');
						    	var btnEdit = docGrid.down('#btnEdit');
						    	btnEdit.hide();
						 } */
						 var isTransient = true;
						 var module = 'examination';
						 var entityId;
						 var entityType = 'academicTopic';
						 
//			             var windows = this.getSimpledocumentform();
						 var windows = Ext.ComponentQuery.query('#academicTopicDocumentFormItemId')[0];
						 var uploadFileField = windows.down('#uploadFileField');
						var  uploadFile= uploadFileField.getValue();
						 var documentNameField = windows.down('#documentNameField')
						 documentNameField.getValue();
						 
						 if (uploadFile ==''){
							 var documentGrid = $this.getAcademictopicdocumentgrid();
							 var store = documentGrid.getStore();
							 var selRec = documentGrid.getSelectionModel().getSelection()[0];
							 selRec.set("id",id);
							 selRec.set("documentName",documentNameField.getValue());
							 selRec.set("isNewRecord",false);
							 selRec.set("isEdit", !isNullOrEmpty(id));
							 window.down('#editFlag').setValue('true');
							 $this.getDocumentController().closeDocumentFormWindow();
//							 var grid= $this.getAcademictopicdetails().down('academictopicdocumentgrid');
							 grid.setVisible(true);
//							 documentGrid.reload();
							 showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));
							 
						 }else{
							 $this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
									 function(success,response,isCallBackTransient) {
								 var documentModel = new Academia.model.course.QuestionPaperDocument();
								
								 documentModel.set("documentName",response.name);
								 documentModel.set("path",response.path);
								 documentModel.set("type",response.type);
								 documentModel.set("isEdit",false);
								 documentModel.set("isNewRecord",true);
								 documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
								 var documentGrid = $this.getAcademictopicdocumentgrid();
								 var store = documentGrid.getStore();
								 if(!windows.down('#uploadFileField').allowBlank) {
								 //if(isNullOrEmpty(id)) {
									 store.add(documentModel);
								 }else {
									 var selRec = documentGrid.getSelectionModel().getSelection()[0];
									 selRec.set("id",id);
									 selRec.set('name', response.name);
									 selRec.set("isNewRecord",false);
									 selRec.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
									 selRec.set("path",response.path);
									  selRec.set("isEdit", !isNullOrEmpty(id));
									 selRec.set("type",response.type);
									 window.down('#editFlag').setValue('true');
								 }

								 $this.getDocumentController().closeDocumentFormWindow();
								 var grid= $this.getAcademictopicdetails().down('academictopicdocumentgrid');
								 grid.setVisible(true);
								 
								 showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));
//								 selRec.getSelectionModel().deselectAll(true);
							 }, isTransient);
							 
				       	 }
						 if($this.addEditBtn == true) {
//							 grid.down('#btnDelete').setVisible(false)
							 grid.down('#btnEdit').setVisible(false)
						 }
						 
					 }
				 },
				 'documentformwindow[itemId=academicTopicDocumentFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
					 click : function() {
						 this.getDocumentController().closeDocumentFormWindow();
					 }
				 },
				 'documentformwindow[itemId=academicTopicDocumentFormItemId] simpledocumentform[itemId=simpleDocumentForm] filefield#uploadFileField' : {
					 change : function(fileField, value, eOpts) {
						 var this$ = this;
						 var fileUploadPath=value;
						 fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
						 fileField.setRawValue(fileUploadPath);
						 var file = fileField.fileInputEl.dom.files[0];
						 fileField.setRawValue(fileUploadPath);
						 var fileSizeLimit = '25';
						 if((file.size / 1048576) <=  fileSizeLimit ){
							 if(!isNullOrEmpty(fileUploadPath)){
								 var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
								 /*if (extension == "gif" || extension == "png" || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
									 || extension == "doc" || extension == "docx" || extension == "txt" || extension == "xls"  || extension == "xlsx" || extension == "ppt" || extension == "pptx") {*/
								 if (extension == "png" || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
									 || extension == "doc" || extension == "docx" || extension == "xls"  || extension == "xlsx") {
								 }else{
									 fileField.reset();
									 showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
									 return false;
								 }
							 }
						 }else{
							 fileField.reset();
							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_SIZE_CAN_NOT_MORETHAN_25'));
							 return false;
						 }
							
						
					 }
				 },
				 'academictopicdocumentgrid button#btnDelete' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getAcademictopicdocumentgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 showConfirmMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									 function(btn,	text) {
								 if (btn == 'yes') {
									 var records = grid.getSelectionModel().getSelection();
									 var id = records[0].get("id");
									 if(!isNullOrEmpty(id)){
										 /*Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
											
										 Ext.Ajax.request({
											 method : "DELETE",
											 type : 'rest',
											 url : SERVERURL.ACADEMIC_TOPIC_DOCUMENT_DELETE+ '?id='+ id,
											 headers : {
												 'Content-Type' : 'application/json'
											 },
											 success : function(form,action) {
												 Ext.getBody().unmask();*/
												 grid.getStore().remove(records[0]);
												 showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
												 if(grid.getStore().getCount() == 0) {
													 grid.hide();
												 }
											 /*}
										 });*/
									 }else{
										 grid.getStore().remove(records[0]);
										 showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
										 if(grid.getStore().getCount() == 0) {
											 grid.hide();
										 }
									 }
									 grid.down('#btnEdit').setDisabled(true);
								 }
							 });
						 } else {
							 showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 }
					 }
				 },
				 'academictopicdocumentgrid button#btnEdit' : {
					 click : function() {
						 var grid = this.getAcademictopicdocumentgrid();
						 formWindow = Ext.widget('simpledocumentform');
//						 var wniss = this.getsimpledocumentform();
						 var filterForm =this.getAcademictopicdetails();
//						 var ids = filterForm.down('#acadmicTopicHiddenId').value;
//						 var filterForm =this.getAcademictopicdetails();
						 var documentGrid =filterForm.down('academictopicdocumentgrid');
						 if (grid.getSelectionModel().getCount() > 0) {
							 var records = grid.getSelectionModel().getSelection();
							
						 var recordCount = grid.getStore().getCount();
//						 if(recordCount == 5){
//							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_FILE_UPLOAD_LIMIT_EXIT'));
//
//						 }
//						 else{
							 this.getDocumentController().showDocumentFormWindow('academicTopicDocumentFormItemId','DOCUMENT');
							 var window = Ext.ComponentQuery.query('#academicTopicDocumentFormItemId')[0];
//							 var docSelect = window.down('#uploadFileField');
							 
							 var docSelect = window.down('#uploadFileField');
//							 this.setAllowBlank = formWindow.down(docSelect,false);
							 this.setAllowBlank(docSelect,true);
							 window.down('#existingFile').show();
							 var documentNameFields = window.down('#documentNameField');
							 documentNameFields.setValue(records[0].data.documentName=='' ?records[0].data.name:records[0].data.documentName); 

//							 var documentNameFields = window.down('#documentNameField');
//							 documentNameFields.setValue(documentName[0].data.name);
				        		
				        	 var existingFiles = window.down('#existingFile');
				        	 
				        	 
				        	 var existingFilesPath =records[0].data.path
				        	 var parts = existingFilesPath.split(/[\\/]/);
				        	 var filename = parts[parts.length - 1];
				        	 existingFiles.setValue(filename);
				        		
				        	 //var acadmicTopicHiddenIdes = filterForm.down('#acadmicTopicHiddenId');
				        	 //acadmicTopicHiddenIdes.setValue(records[0].data.id);
				        	 window.add({
				        		 xtype: 'hiddenfield',
				        		 name: 'documentId',
				        		 value: records[0].data.id
				        	 });
//						 }
						 } else {
							 showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 } 
					 }
				 },
				 
				 'academictopicdocumenturlgrid button#btnEdit' : {
					 click : function() {
						 var $this = this;
						 var filterForm =this.getAcademictopicdetails();
						 var grid = $this.getAcademictopicdocumenturlgrid(); 
						 if (grid.getSelectionModel().getCount() > 0) {
							 var records = grid.getSelectionModel().getSelection();
							 this.getDocumentController().showDocumentFormWindow('academicTopicDocUrlItemId','DOCUMENT_URL');
							 var window = Ext.ComponentQuery.query('#academicTopicDocUrlItemId')[0];
							 var formWindow = this.getDocumentformwindow();
							 if (!formWindow) {
//								 Ext.widget('documentformwindow');
								 formWindow = this.getDocumentformwindow();
							 }
							 formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
							 this.setAllowBlank(formWindow.down('#documentNameField'),false);
							 var documentNameFields = window.down('#documentNameField');
							 documentNameFields.setValue(records[0].data.name);
							 var documentUrlFields = window.down('#documentUrlField');
							 documentUrlFields.setValue(records[0].data.path);
//							 var acadmicTopicHiddenIds = filterForm.down('#acadmicTopicHiddenId');
//							 acadmicTopicHiddenIds.setValue(records[0].data.id);
							 
							 window.add({
				        		 xtype: 'hiddenfield',
				        		 name: 'documentId',
				        		 value: records[0].data.id
				        	 });
//							 formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
//							 this.setAllowBlank(formWindow.down('#documentNameField'),false);
						 } 
						 }
					 },
	
			'academictopicdocumenturlgrid button#btnDelete' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getAcademictopicdocumenturlgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 showConfirmMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									 function(btn,	text) {
								 if (btn == 'yes') {
									 var records = grid.getSelectionModel().getSelection();
									 var id = records[0].get("id");
									 if(!isNullOrEmpty(id)){
												 grid.getStore().remove(records[0]);
												 showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('URL_SUCCESS_MSG'));
												 if(grid.getStore().getCount() == 0) {
													 grid.hide();
												 }
									 }else{
										 grid.getStore().remove(records[0]);
										 showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('URL_SUCCESS_MSG'));
										 if(grid.getStore().getCount() == 0) {
											 grid.hide();
										 }
									 }
									 grid.down('#btnEdit').setDisabled(true);

								 }
							 });
						 } else {
							 showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 }
					 }
				 },
				 'academictopicdetails button#academicTopicDocument': {
					 click : function() {
						 var grid = this.getAcademictopicdocumentgrid();
						 
						 var recordCount = grid.getStore().getCount();
						 if(recordCount == 5){
							 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_FILE_UPLOAD_LIMIT_EXIT'));

						 }else{
							 this.getDocumentController().showDocumentFormWindow('academicTopicDocumentFormItemId','DOCUMENT');
							 const ATDInterval = setInterval(ATDTimer, 500);

							 function ATDTimer() {
								 var win = Ext.ComponentQuery.query('#academicTopicDocumentFormItemId')[0];
								 if(win) {
									 win.down('form').isValid();
									 win.down('form').getForm().clearInvalid();
								 }
								 else {
									 clearInterval(ATDInterval);
								 }
							 }
						 }
						 
						 
					 }
				 },
				 'academictopicdetails button#academicTopicDocumentUrl': {
					 click : function() {
						 this.getDocumentController().showDocumentFormWindow('academicTopicDocUrlItemId','DOCUMENT_URL');
						 var formWindow = this.getDocumentformwindow();
						 if (!formWindow) {
							 Ext.widget('documentformwindow');
							 formWindow = this.getDocumentformwindow();
						 }
						 formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
						 this.setAllowBlank(formWindow.down('#documentNameField'),false);
						 var docGrid = this.getAcademictopicdocumenturlgrid();
						 docGrid.getSelectionModel().deselectAll(true);
					 }
				 },
				 'documentformwindow[itemId=academicTopicDocUrlItemId] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
			 	    	click: this.saveDocumentUrl
			 	},
			 	/*'academictopicdocumentsgrid': {
			 		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "name"){
							if(e.target.tagName=='A'){
								var documentId=record.get('encryptedDocId');
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										//params: {documentId:documentId},
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
												showSuccessMessage(getCommonTranslation('DOCUMENT'),getCommonTranslation('DOCUMENT_DOWNLOAD_SUCCESSFULLY'));
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}
							}
						}
					}
			 	},*/
			 	
			 'academictopicdocumentsgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getAcademictopicdocumentspopup();
					var academicDetailActionGrid=form.down('#academictopicdocumentsgridItemId');
					if (academicDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = academicDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Academic Topic Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('ACADEMIC_TOPIC_DOCUMENTS'),
									getCommonTranslation('ACADEMIC_TOPIC_DOCUMENTS_DOWNLOAD_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('ACADEMIC_TOPIC_DOCUMENT_DOWNLOAD_SUCCESSFULLY'));
								}
								
							});

							
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
      	 },
      	 		 'academictopicdocumentsgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getAcademictopicdocumentspopup();  
	 					var detaillistgrid=form.down('#academictopicdocumentsgridItemId');
	 					if (detaillistgrid.getSelectionModel().getCount() > 0) {
	 						var records = detaillistgrid.getSelectionModel().getSelection();
	 							var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.offlinePaymentDocumentId);
	 						});
	 							showConfirmMessage(getCommonTranslation('ACADEMIC_TOPIC_DOCUMENTS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_ACADEMIC_TOPIC_DOCUMENT_DELETE+'?documentIds='+ids.join()+'&academicTopicId='+records[0].data.documentIdCount,
	 									/*params: {
											academicTopicId: records[0].get('documentIdCount')
										},*/
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('ACADEMIC_TOPIC_DOCUMENTS'),getCommonTranslation('STUDENT_ACADEMIC_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	 										detaillistgrid.store.reload();
	 										$this.getAcademicstopicquicksearchgrid().store.reload();
	 										detaillistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	       	 'academictopicurlgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getAcademictopicurlpopup();  
						var urlGrid = Ext.ComponentQuery.query('#academictopicurlsgridItemId')[0];
	 					if (urlGrid.getSelectionModel().getCount() > 0) {
	 						var records = urlGrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('ACADEMIC_TOPIC_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_ACADEMIC_TOPIC_URL_DELETE+'?topicUrlIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('ACADEMIC_TOPIC_URL'),getCommonTranslation('ACADEMIC_TOPIC_URL_SUCCESS_DELETE_MSG'));	 
	 										urlGrid.store.reload();
	 										$this.getAcademicstopicquicksearchgrid().store.reload();
	 										urlGrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	       	 'studentsalesforceadmissiondetailsgrid':{
	       		afterrender: function(grid) {
					   var this$ = this;
					   this$.doAccessControlValidation(grid, this$.getSTUDENT_SALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
					   this$.addDataGridConfigButton(grid,this$.getSTUDENT_SALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
					   var personProfile = this$.getContentPanelActiveTab();
					   var personId=personProfile.getPersonId();
					   grid.getStore().getProxy().extraParams = {
						   personId : personId
					   },
					   grid.getStore().load();
				   }
			   },
             'academicstopicquicksearchgrid': {	                 
				   afterrender: function(grid) {
					var associatedAcadLocationIds = new Array();
					    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					   var permissionsMap=this.getACADEMIC_TOPIC_LIST_PRIVILEGES();
					   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					   
					   if(portalId == '2') {
						   permissionsMap = this.getFP_ACADEMIC_TOPIC_PERMISSION();
						   permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					   }
					   var btnAdd = grid.down('#btnAdd');
					   var btnEdit = grid.down('#btnEdit');
					   var btnView = grid.down('#btnView');
					   var btnDelete = grid.down('#btnDelete');
					   var btnExportToPDF = grid.down('#btnExportToPDF');
					   var btnExportToExcel = grid.down('#btnExportToExcel');
    	               btnAdd.setVisible(false);
    	               btnEdit.setVisible(false);
    	               btnView.setVisible(false);
    	               btnDelete.setVisible(false);
    	               btnExportToPDF.setVisible(false);
    	               btnExportToExcel.setVisible(false);
					   Ext.each(permissionList, function(privilege) {
				    		if (privilege == "CREATE") {
				    			 btnAdd.setVisible(true);
							}
							if (privilege == "UPDATE") {
				    			 btnEdit.setVisible(true);
							}
							if (privilege == "VIEW") {
				    			 btnView.setVisible(true);
							}
							if (privilege == "DELETE") {
				    			 btnDelete.setVisible(true);
							}
							if (privilege == "EXPORT") {
				    			 btnExportToPDF.setVisible(true);
				    			 btnExportToExcel.setVisible(true);
							}
							
							
					   });
					
				}},
				'studentsalesforceadmissiondetailsgrid button[itemId=btnView]': {
	                click: function(){
	                	this.viewStudentSalesForceAdmissionDetailFormWindow();
	                }
	            },
	            'studentsalesforceadmissiondetailsform button[itemId=cancelButtonId]': {
	                click: function(grid) {
	                    var window = this.getStudentsalesforceadmissiondetailswindow();
	                    this.closeFormWindow(window);
	                }
	            },
	            'studentprogramcompletiondetailsgrid[itemId=studentprogramcompletiondetailsgridId]':{
	            	render: function(grid) {
	            		var $this = this;
	            		$this.loadGridStore('#studentprogramcompletiondetailsgridId', SERVERURL.PATH_PROGRAM_COMPLETION_DETAILS_GRID_DATA);
	            		$this.doAccessControlValidation(grid, $this.getSTUDENT_PROGRAM_COMPLETION_DETAILS_PERMISSIONS());
	            		var studentProfilePanel = grid.up('studentprofile');
	                	var structure = studentProfilePanel.down('[region=center]');
	                	if(structure.body.isScrollable() == false){
	             			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
	             		}
	                	//$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
	            	},
	            	afterrender:function(grid){
	    				var me = this;
	    				me.addDataGridConfigButton(grid,me.getSTUDENT_PROGRAM_COMPLETION_DETAILS_PERMISSIONS());
	    			},
	    			selectionchange: function(column, selected,eOpts ){
	            		var grid = column.view.up('grid');
	                	if(selected.length > 1){
	                		grid.down('#btnAdd').setDisabled(true);
	                		grid.down('#btnEdit').setDisabled(true);
	                		grid.down('#btnView').setDisabled(true);
	                	}else if(selected.length==1){
	                		grid.down('#btnAdd').setDisabled(true);
	                		grid.down('#btnEdit').setDisabled(false);
	                		grid.down('#btnView').setDisabled(false);
	                	}else{
	                		grid.down('#btnAdd').setDisabled(false);
	                		grid.down('#btnEdit').setDisabled(false);
	                		grid.down('#btnView').setDisabled(false);
	                	}
	    			}
				  },
	            
	            'studentprogramcompletiondetailsgrid button[itemId=btnAdd]': {
					   click: function() {
						   var $this =this;
						   var personProfile = $this.getContentPanelActiveTab();
						   var grid = this.getStudentprogramcompletiondetailsgrid();
						   $this.showPersonCommonWindow('PROGRAM_COMPLETION_DETAILS', 'programcompletiondetails');
						   var formWindow = $this.getPersonCommonWindow();
						   if( formWindow != null ){
							   var studentId= personProfile.getPersonInfo().personId;
							   var printName=personProfile.getPersonInfo().printName;
		 						var academyLocationId = $this.getCurrentAcademyLocation();
							     formWindow.down('#studentItemId').setValue(studentId);
							     formWindow.down('#studentNameItemId').setValue(printName);
							     var awardTrackingNumber = formWindow.down('#awardTrackingNumberItemId');
		                      	 var awardNominatedPerson = formWindow.down('#awardNominatedPersonItemId');
							     var admissionIdProgramBatch=formWindow.down('#admissionIdProgramBatch');
							     formWindow.down('#admissionItemId').hide();
							     formWindow.down('#programItemId').hide();
							     formWindow.down('#batchCombo').hide();
							     formWindow.down('#admissionItemId').allowBlank=true;
							     formWindow.down('#programItemId').allowBlank=true;
							     formWindow.down('#batchCombo').allowBlank=true;
							     var admissionStore = admissionIdProgramBatch.getStore();
							     admissionStore.proxy.extraParams = {
			                               studentCode:studentId,
			                               academyLocationId:academyLocationId
			                       };
							     admissionStore.load();	 
							     setTimeout(function(){
			                     		awardTrackingNumber.setVisible(false);
			                     		awardNominatedPerson.setVisible(false);
			             		},300);
			        		}
					      }
				   },
				   
				   'studentprogramcompletiondetailsgrid button[itemId=btnEdit]': {
					   click: function() {
						   var $this =this;
						   this.editProgramCompletionDetails('PROGRAM_COMPLETION_DETAILS','programcompletiondetails', '#studentprogramcompletiondetailsgridId');
					      }
				   },
				   
				   'studentprogramcompletiondetailsgrid button[itemId=btnView]': {
		                click: function(){
		                	this.viewProgramCompletionDetailsFormWindow('PROGRAM_COMPLETION_DETAILS','programcompletiondetails', '#studentprogramcompletiondetailsgridId');
		                }
		            },
		            
		            'studentprogramcompletiondetailsgrid button[itemId=btnDelete]': {
						   click: function() {
							   var $this =this;
							   this.deleteProgramCompletionDetails('#studentprogramcompletiondetailsgridId',SERVERURL.DELETE_PROGRAM_COMPLETION_DETAILS);
						      }
					   },
					   
				   'programcompletiondetails button[itemId=cancelButtonId]': {
		                click: function(grid) {
							   this.getPersonCommonWindow().close();
		                }
		            },
		            
		            'programcompletiondetails button[itemId=submitButtonId]': {
						   click: function(){
							   this.saveProgramCompletionDetails('#studentprogramcompletiondetailsgridId', SERVERURL.SAVE_PROGRAM_COMPLETION_DETAILS,SERVERURL.UPDATE_PROGRAM_COMPLETION_DETAILS);
						   }
					   },
				   'programcompletiondetails combo[itemId=awardDeliveryMethodItemId]': {
		               	 select:function(obj1,records) {
	                      	 var awardDeliveryMethod = obj1.up('form').down('#awardDeliveryMethodItemId').getDisplayValue();
	                      	 var awardTrackingNumber = obj1.up('form').down('#awardTrackingNumberItemId');
	                      	 var awardNominatedPerson = obj1.up('form').down('#awardNominatedPersonItemId');

	                      	    if(awardDeliveryMethod=='Nominated Person'){
	                      	    	awardNominatedPerson.setVisible(true);
	                      	    	awardTrackingNumber.setVisible(false);
	                      	    	awardTrackingNumber.reset();
	                      	    }else if(awardDeliveryMethod=='Registered Mail'){
	                      	    	awardTrackingNumber.setVisible(true);
	                      	    	awardNominatedPerson.setVisible(false);
	                      	    	awardNominatedPerson.reset();
	                      	    }else{
	                      	    	awardTrackingNumber.setVisible(false);
	                      	    	awardNominatedPerson.setVisible(false);
	                      	    	awardTrackingNumber.reset();
	                      	    	awardNominatedPerson.reset();
	                      	    }
		               		 }
		               	 },
		               	'programcompletiondetails combo[itemId=admissionIdProgramBatch]': {
		               	    select: function (combo, records) {
		               	        var form = combo.up('form');
		               	        var selectedData = records[0].data;
		                        var admissionId = selectedData.admissionId;
		               	        form.down('#admissionItemId').setValue(admissionId);

		               	        var programIdField = form.down('#programItemId');
		               	        var batchField = form.down('#batchCombo');
		               	        var periodField = form.down('#periodId');
		               	        var classificationField = form.down('#classificationItemId');
		               	        var specializationField = form.down('#specializationItemId');
		               	        var awardTypeField = form.down('#awardTypeItemId');

		               	        classificationField.reset();
		               	        specializationField.reset();
		               	        awardTypeField.reset();
		               	        programIdField.reset();
		               	        batchField.reset();
		               	        programIdField.setDisabled(false);
		               	        batchField.setDisabled(false);
		               	        periodField.setDisabled(false);

		               	        var programStore = programIdField.getStore();
		               	        var batchStore = batchField.getStore();
		               	        var periodStore = periodField.getStore();
							   
		               	        // Step 1: Load Program Store
		               	        programStore.proxy.extraParams = { admissionId: admissionId };
		               	        programStore.load({
		               	            callback: function (programRecords) {
		               	                if (programRecords && programRecords.length === 1) {
		               	                    programIdField.setValue(programRecords[0].data.programId);
									    }

		               	                // Step 2: Load Batch Store (after Program store)
		               	                batchStore.proxy.extraParams = { admissionId: admissionId };
		               	                batchStore.load({
		               	                    callback: function (batchRecords) {
		               	                        if (batchRecords && batchRecords.length === 1) {
		               	                        	var selectedBatch = batchRecords[0];
		               	                            batchField.setValue(selectedBatch.data.batchId);

		               	                            var programId = programIdField.getValue(); // Get latest after setting value
		               	                            var batchId = selectedBatch.data.batchId;

		               	                            // Step 3: Load Period Store
										            periodStore.proxy.extraParams = {
											            admissionId: admissionId,
		               	                                programId: programId,
		               	                                batchId: batchId
										            };
										            periodStore.load({
		               	                                callback: function (periodRecords) {
		               	                                    if (periodRecords && periodRecords.length === 1) {
		               	                                        periodField.setValue(periodRecords[0].data.id);
												            } else {
		               	                                        periodRecords.forEach(function (itemObj) {
		               	                                            if (itemObj.data.check === true) {
		               	                                                periodField.setValue(itemObj.data.id);
														            }
													            });
												            }
											            }
										          });
									          }
								          }
							        });
			               		 }
		               	        });
		               	     var classifications = selectedData.batchStudentClassifications;
		                     if (classifications && classifications.length > 0) {
		                         var classificationStore = Ext.create('Ext.data.Store', {
		                             fields: ['id', 'value'],
		                             data: classifications.map(function (item) {
		                                 return {
		                                     id: item.studentClassification.id,
		                                     value: item.studentClassification.value
		                                 };
		                             })
		                         });
		                         classificationField.bindStore(classificationStore);
		                     } else {
		                    	 var defaultClassificationStore = Ext.create('Academia.store.student.studentprofile.ClassificationCsmStore');
		                         classificationField.bindStore(defaultClassificationStore);
		                         defaultClassificationStore.load(); 
		                     }

		                     // ---- STEP 3: SPECIALIZATION ----
		                     var specializations = selectedData.batchSpecializations;
		                     if (specializations && specializations.length > 0) {
		                         var specializationStore = Ext.create('Ext.data.Store', {
		                             fields: ['id', 'value'],
		                             data: specializations.map(function (item) {
		                                 return {
		                                     id: item.studentSpecialization.id,
		                                     value: item.studentSpecialization.value
		                                 };
		                             })
		                         });
		                         specializationField.bindStore(specializationStore);
		                     } else {
		                    	 var defaultSpecStore = Ext.create('Academia.store.student.studentprofile.SpecilizationCsmStore');
		                         specializationField.bindStore(defaultSpecStore);
		                         defaultSpecStore.load();
		                     }

		                     // ---- STEP 4: AWARD TYPE ----
		                     var awardTypes = selectedData.batchAwardTypes;
		                     if (awardTypes && awardTypes.length > 0) {
		                         var awardTypeStore = Ext.create('Ext.data.Store', {
		                             fields: ['id', 'value'],
		                             data: awardTypes.map(function (item) {
		                                 return {
		                                     id: item.programCompletionAwardType.id,
		                                     value: item.programCompletionAwardType.value
		                                 };
		                             })
		                         });
		                         awardTypeField.bindStore(awardTypeStore);
		                     } else {
		                    	 var defaultAwardTypeStore = Ext.create('Academia.store.common.ProgramCompletionAwardTypeStore');
		                         awardTypeField.bindStore(defaultAwardTypeStore);
		                         defaultAwardTypeStore.load(); 
		                     }
		               	    },
		               	   change : function(combo, record) {
		             		     var $this = this;
		             		     var form = combo.up('form');
		             		     form.down('#classificationItemId').reset();
		               	         form.down('#specializationItemId').reset();
		               	         form.down('#awardTypeItemId').reset();
		               	  }
			            },
			            'programcompletiondetails combo[itemId=classificationItemId]': {
			                expand: function (combo) {
			                	    var this$ = this;
			                        var form = combo.up('form');
			                        var existingStore = combo.getStore();
			                        var admissionId = form.down('#admissionItemId').getValue();
			                        var programId = form.down('#programItemId').getValue();
			                        var batchId = form.down('#batchCombo').getValue();
			                        var admissionIdProgramBatch = form.down('#admissionIdProgramBatch').getValue();
			                        var personProfile = this$.getContentPanelActiveTab();
				                    var studentId = personProfile.getPersonInfo().personId;
				                    var academyLocationId = this$.getCurrentAcademyLocation();

				                    if (!Ext.isEmpty(admissionIdProgramBatch)) {
				                        Ext.Ajax.request({
			                                type: 'rest',
			                                method: 'GET',
				                            url: SERVERURL.PATH_PROGRAM_BATCH_ADMISSION_ID,
				                            params: {
				                                studentCode: studentId,
				                                academyLocationId: academyLocationId
				                            },
				                            success: function (response) {
				                                var json = Ext.decode(response.responseText);

				                                Ext.Array.each(json, function (item) {
				                                    if (item.programId === programId && item.batchId === batchId) {
				                                        var classifications = item.batchStudentClassifications;
				                                        if (classifications && classifications.length > 0) {
				                                            var data = Ext.Array.map(classifications, function (cls) {
				                                                return {
				                                                    id: cls.studentClassification.id,
				                                                    value: cls.studentClassification.value
				                                                };
				                                            });
				                                            existingStore.loadData(data);
				                                            return false;
				                                        }
				                                    }
				                                });
				                            }
				                        });
				                    }else {
			                            existingStore.load();
			                            combo.expand();
			                        }
				                }
				            },

		               	'programcompletiondetails combo[itemId=specializationItemId]': {
		               	 expand: function (combo) {
			                    var this$ = this;
			                    var form = combo.up('form');
			                    var existingStore = combo.getStore();
			                    var admissionId = form.down('#admissionItemId').getValue();
			                    var programId = form.down('#programItemId').getValue();
			                    var batchId = form.down('#batchCombo').getValue();
			                    var admissionIdProgramBatch = form.down('#admissionIdProgramBatch').getValue();
			                    var personProfile = this$.getContentPanelActiveTab();
			                    var studentId = personProfile.getPersonInfo().personId;
			                    var academyLocationId = this$.getCurrentAcademyLocation();

			                    if (!Ext.isEmpty(admissionIdProgramBatch)) {
			                        Ext.Ajax.request({
			                            type: 'rest',
			                            method: 'GET',
			                            url: SERVERURL.PATH_PROGRAM_BATCH_ADMISSION_ID,
			                            params: {
			                                studentCode: studentId,
			                                academyLocationId: academyLocationId
			                            },
			                            success: function (response) {
			                                var json = Ext.decode(response.responseText);

			                                Ext.Array.each(json, function (item) {
			                                    if (item.programId === programId && item.batchId === batchId) {
			                                        var specializations = item.batchSpecializations;
			                                        if (specializations && specializations.length > 0) {
			                                            var data = Ext.Array.map(specializations, function (cls) {
			                                                return {
			                                                    id: cls.studentSpecialization.id,
			                                                    value: cls.studentSpecialization.value
			                                                };
			                                            });
			                                            existingStore.loadData(data);
			                                            return false;
			                                        }
			                                    }
			                                });
			                            }
			                        });
			                    }else {
		                            existingStore.load();
		                            combo.expand();
		                        }
			                }
		               	 },
		               	'programcompletiondetails combo[itemId=awardTypeItemId]': {
		               		expand: function (combo) {
			                    var this$ = this;
			                    var form = combo.up('form');
			                    var existingStore = combo.getStore();
			                    var admissionId = form.down('#admissionItemId').getValue();
			                    var programId = form.down('#programItemId').getValue();
			                    var batchId = form.down('#batchCombo').getValue();
			                    var admissionIdProgramBatch = form.down('#admissionIdProgramBatch').getValue();
			                    var personProfile = this$.getContentPanelActiveTab();
			                    var studentId = personProfile.getPersonInfo().personId;
			                    var academyLocationId = this$.getCurrentAcademyLocation();

			                    if (!Ext.isEmpty(admissionIdProgramBatch)) {
			                        Ext.Ajax.request({
			                            type: 'rest',
			                            method: 'GET',
			                            url: SERVERURL.PATH_PROGRAM_BATCH_ADMISSION_ID,
			                            params: {
			                                studentCode: studentId,
			                                academyLocationId: academyLocationId
			                            },
			                            success: function (response) {
			                                var json = Ext.decode(response.responseText);

			                                Ext.Array.each(json, function (item) {
			                                    if (item.programId === programId && item.batchId === batchId) {
			                                        var awardType = item.batchAwardTypes;
			                                        if (awardType && awardType.length > 0) {
			                                            var data = Ext.Array.map(awardType, function (cls) {
			                                                return {
			                                                    id: cls.programCompletionAwardType.id,
			                                                    value: cls.programCompletionAwardType.value
			                                                };
			                                            });
			                                            existingStore.loadData(data);
			                                            return false;
			                                        }
			                                    }
			                                });
			                            }
			                        });
			                    }else {
		                            existingStore.load();
		                            combo.expand();
		                        }
			                }
		               	 },
		               	'programcompletiondetails combo[itemId=programItemId]': {
								  select: function(combo, records, eOpts) {
									  var admissionId = combo.up('form').down('#admissionItemId').getValue();
									  var programId = combo.up('form').down('#programItemId').getValue();
									  var batch = combo.up('form').down('#batchCombo');
									  var period = combo.up('form').down('#periodId');
									  period.setDisabled(false);
									  //  batch.setDisabled(false);
									  //  batch.reset();
									  var batchStore = batch.getStore();
									  batchStore.proxy.extraParams = {
										  admissionId: admissionId
									  };
									  batchStore.load();
									  var batchId = combo.up('form').down('#batchCombo').getValue();


									  var periodStore = period.getStore();
									  periodStore.proxy.extraParams = {
										  admissionId: admissionId,
										  programId: programId,
										  batchId: batchId
									  };
									  periodStore.load({
										  callback: function(record) {
											  if (record && record.length == 1) {
												  period.setValue(record[0].data.id);
											  } else {
												  record.forEach(function(itemObj) {
													  if (itemObj.data.check == true) {
														  period.setValue(itemObj.data.id);
													  }
												  });
											  }
										  }
									  });
		 					   }
		 			   },
		 			   /*Deadpool Transfer Creadit Development:Start*/
			 			  'studentTransferCreditRequestTab':{ 				
			 					render:function(tab){
			 						var me = this;
			 						me.disableStudentTransferCreditInternalTab(tab, me.getSTUDENT_TRANSFER_CREDIT_DETAILS_PERMISSIONS())
			 					}
			 				},
			 				/*'studenttransfercreditrequeststructure' :{
			 					afterrender:function(structure){ 
			 						var me = this
			 						var crpTransferCreditTabPanel = structure.down('tabpanel');
		        					if (!crpTransferCreditTabPanel) return; 
		        					var crpExternalTransferCreditRequestTab = crpTransferCreditTabPanel.down('#externalTransferCreditTabItemId')
		        					crpTransferCreditTabPanel.setActiveTab(crpExternalTransferCreditRequestTab);
			 					}
			 				},*/
			 				'studentExternalTransferCreditRequestGrid':{
			 					afterrender:function(grid){
			 						var me = this;
			 						me.doAccessControlValidation(grid,me.getSTUDENT_TRANSFER_CREDIT_EXTERNAL_TAB_PERMISSIONS());
			 						me.addDataGridConfigButton(grid,me.getSTUDENT_TRANSFER_CREDIT_EXTERNAL_TAB_PERMISSIONS());
			 						//me.doAccessControlValidation(grid,me.getSTUDENT_TRANSFER_CREDIT_EXTERNAL_TAB_PERMISSIONS());
			 					},
			 					viewready: this.onGridViewReady,
			 					selectionchange: function(column, selected,eOpts){
			 						var me  = this;
			 					    var grid = me.getStudentExternalTransferCreditRequestGrid();
			 						var gridStructure = me.getStudentExternalTransferCreditRequestGridStructure();			 						
			 						var disableFlag = false;			 						
			 					    var btnApprove = grid.down('#btnApprove');
			 					    var btnReject = grid.down('#btnReject');
			 					    var btnResubmit = grid.down('#btnResubmit');
			 					    var btnSubmit = gridStructure.down('#btnSubmitItemId');
			 					    var btnReset = gridStructure.down('#btnResetItemId');

			 					   /* if (selected.length === 0) {
			 					        btnApprove.setDisabled(true);
			 					        btnReject.setDisabled(true);
			 					        btnResubmit.setDisabled(true);
			 					        btnSubmit.setDisabled(true);
			 					        return;
			 					    }*/
			 					   
			 					    
			 					   if (selected.length > 0) {
								        btnSubmit.setDisabled(false);
								        btnReset.setDisabled(false);
								        
								        selected.forEach(function(record) {
								        	var status = record.get('applicantTransferCreditStatus');
										    if (status == 'APPROVE' || status == 'REJECT') {
										        	disableFlag = true;
											    }
											});
					 					   if(disableFlag) {
					 						  btnSubmit.disable();
					 						}
					 						else {
					 							btnSubmit.enable();
					 						}
					 					   
								    } else {
								        btnSubmit.setDisabled(true);
								        btnReset.setDisabled(true);
								        btnApprove.setDisabled(true);
								        btnReject.setDisabled(true);
								        btnResubmit.setDisabled(true);
								        return;
								    }

			 					    var statuses = [];
			 					    Ext.Array.each(selected, function (rec) {
			 					        statuses.push(rec.get('applicantTransferCreditStatus'));
			 					    });

			 					    var hasPending = Ext.Array.contains(statuses, 'PENDING');

			 					    if (hasPending) {
			 					        btnApprove.setDisabled(true);
			 					        btnReject.setDisabled(true);
			 					        btnResubmit.setDisabled(true);
			 					        return;
			 					    }

			 					   
			 					    var canApprove = Ext.Array.every(statuses, function (status) {
			 					        return status === 'SUBMIT' || status === 'REJECT' || status === 'NEED_TO_RESUBMIT';
			 					    });

			 					    var canReject = Ext.Array.every(statuses, function (status) {
			 					        return status === 'SUBMIT' || status === 'APPROVE' || status === 'NEED_TO_RESUBMIT';
			 					    });

			 					    var canResubmit = Ext.Array.every(statuses, function (status) {
			 					        return status === 'SUBMIT' || status === 'APPROVE' || status === 'REJECT';
			 					    });
			 					    
			 					    
			 					  /* var hasApproveOrReject = Ext.Array.every(statuses, function (status) {
			 					        return status === 'APPROVE' || status === 'REJECT APPROVE';
			 					    });*/
			 					 
			 					    btnApprove.setDisabled(!canApprove);
			 					    btnReject.setDisabled(!canReject);
			 					    btnResubmit.setDisabled(!canResubmit);
			 					    //btnSubmit.setDisabled(hasApproveOrReject);
			 					   }
			 				},
			 				'studentExternalTransferCreditRequestGrid button[itemId=btnApprove]': { 
			 					click:function(btn){
		 							this.transferCreditApprove(btn)
		 						}            
		 		            },
			 				'studentExternalTransferCreditRequestGrid button[itemId=btnReject]': { 
			 					click:function(btn){
		 							this.transferCreditReject(btn) 
		 						}            
		 		            },
			 				'studentExternalTransferCreditRequestGrid button[itemId=btnResubmit]': { 
			 					click:function(btn){
		 							this.transferCreditResubmit(btn)
		 						}            
		 		            },
		 		            'studentInternalTransferCreditRequestGrid button[itemId=btnApprove]': { 
			 					click:function(btn){
		 							this.transferCreditApprove(btn)
		 						}            
		 		            },
			 				'studentInternalTransferCreditRequestGrid button[itemId=btnReject]': { 
			 					click:function(btn){
		 							this.transferCreditReject(btn) 
		 						}            
		 		            },
			 				'studentInternalTransferCreditRequestGrid button[itemId=btnResubmit]': { 
			 					click:function(btn){
		 							this.transferCreditResubmit(btn)
		 						}            
		 		            },
			 				'studentInternalTransferCreditRequestGrid':{
			 					afterrender:function(grid){
			 						var me = this;
			 						me.doAccessControlValidation(grid,me.getSTUDENT_TRANSFER_CREDIT_INTERNAL_TAB_PERMISSIONS());
			 						me.addDataGridConfigButton(grid,me.getSTUDENT_TRANSFER_CREDIT_INTERNAL_TAB_PERMISSIONS());
			 						//me.doAccessControlValidation(grid,me.getSTUDENT_TRANSFER_CREDIT_INTERNAL_TAB_PERMISSIONS());
			 					},
			 					viewready: this.onGridViewReadyToInternal,
			 					selectionchange: function(column, selected,eOpts){
			 						var me  = this
			 					    var grid = me.getStudentInternalTransferCreditRequestGrid();
			 						var gridStructure = me.getStudentInternalTransferCreditRequestGridStructure();
			 						var disableFlag = false;			 						
			 					    var btnApprove = grid.down('#btnApprove');
			 					    var btnReject = grid.down('#btnReject');
			 					    var btnResubmit = grid.down('#btnResubmit');
			 					    var btnSubmit = gridStructure.down('#btnSubmitItemId');
			 					    var btnReset = gridStructure.down('#btnResetItemId');

			 					  
			 					   if (selected.length > 0) {
								        btnSubmit.setDisabled(false);
								        btnReset.setDisabled(false);
								        
								        selected.forEach(function(record) {
								        	var status = record.get('applicantTransferCreditStatus');
										    if (status == 'APPROVE' || status == 'REJECT') {
										        	disableFlag = true;
											    }
											});
					 					   if(disableFlag) {
					 						  btnSubmit.disable();
					 						}
					 						else {
					 							btnSubmit.enable();
					 						}
					 					   
								    } else {
								        btnSubmit.setDisabled(true);
								        btnReset.setDisabled(true);
								        btnApprove.setDisabled(true);
								        btnReject.setDisabled(true);
								        btnResubmit.setDisabled(true);
								        return;
								    }

			 					    var statuses = [];
			 					    Ext.Array.each(selected, function (rec) {
			 					        statuses.push(rec.get('applicantTransferCreditStatus'));
			 					    });

			 					    var hasPending = Ext.Array.contains(statuses, 'PENDING');

			 					    if (hasPending) {
			 					        btnApprove.setDisabled(true);
			 					        btnReject.setDisabled(true);
			 					        btnResubmit.setDisabled(true);
			 					        return;
			 					    }

			 					   
			 					    var canApprove = Ext.Array.every(statuses, function (status) {
			 					        return status === 'SUBMIT' || status === 'REJECT' || status === 'NEED_TO_RESUBMIT';
			 					    });

			 					    var canReject = Ext.Array.every(statuses, function (status) {
			 					        return status === 'SUBMIT' || status === 'APPROVE' || status === 'NEED_TO_RESUBMIT';
			 					    });

			 					    var canResubmit = Ext.Array.every(statuses, function (status) {
			 					        return status === 'SUBMIT' || status === 'APPROVE' || status === 'REJECT';
			 					    });
			 					    		 					 
			 					    btnApprove.setDisabled(!canApprove);
			 					    btnReject.setDisabled(!canReject);
			 					    btnResubmit.setDisabled(!canResubmit);
			 					   }
			 				},
			 				'studentTransferCreditRequestFilter': {
			 				    afterrender: function(form) {
			 				        var me = this;
			 				        var studentId = me.getContentPanelActiveTab().getUserId();

			 				        var programField = form.down('#stcrdProgramItemId');
			 				        var batchField = form.down('#stcrdBatchItemId');

			 				        if (!programField || !batchField) {
			 				            return;
			 				        }

			 				        var programStore = programField.getStore();
			 				        programStore.getProxy().extraParams = {
			 				            studentId: studentId
			 				        };

			 				        programStore.load({
			 				            callback: function(records, success) {
			 				                if (!success || records.length === 0) return;

			 				                var selectedProgram = records.length === 1 ? records[0] : Ext.Array.findBy(records, function(rec) {
			 				                    return !!rec.get('value');
			 				                });

			 				                if (selectedProgram) {
			 				                    var programId = selectedProgram.get('id');
			 				                    programField.setValue(programId);

			 				                    var batchStore = batchField.getStore();

			 				                    if (!batchStore) return;

			 				                    batchStore.getProxy().extraParams = {
			 				                        programId: programId,
			 				                        studentId: studentId
			 				                    };

			 				                    batchStore.load({
			 				                        callback: function(batchRecords, batchSuccess) {
			 				                            if (batchSuccess && batchRecords.length > 0) {
			 				                                batchField.setValue(batchRecords[0].get('id'));
			 				                            }
			 				                        }
			 				                    });
			 				                }
			 				            }
			 				        });
			 				    }
			 				},'studentTransferCreditRequestFilter customcombobox[itemId=stcrdProgramItemId]': {
			 	            	select: function(cmp){ 
			 						var me = this
			 						var studentId = me.getContentPanelActiveTab().getUserId();
			 						form = me.getStudentTransferCreditRequestFilter()
			 						var program = form.down('#stcrdProgramItemId')	
			 						var batch = form.down('#stcrdBatchItemId')
			 						batch.getStore().getProxy().extraParams = {
							            programId: program.getValue(),
							            studentId: studentId
							        };
			 						batch.getStore().load({
			 		   					 callback:function(records, success){
			 		   						 if(success){
			 		   							batch.getStore().getProxy().extraParams = {
					 		   						programId: program.getValue(),
					 		   						studentId: studentId
				 		   						};
			 		   						    batch.setValue(records[0].get('id'));
			 		   						 }
			 		   					 }
			 		   				 })
			 					}
			 	            
			 	            },
			 	           'studentTransferCreditRequestFilter button[itemId=submitBtn]': {
			 	                click: function(cmp){
			 	                	var me = this;
			 	                	var mainTab = me.getContentPanelActiveTab();
			 	                	var nestedTabPanel = mainTab.down('tabpanel').getActiveTab();
			 	                	var innerActiveTab = nestedTabPanel.down('tabpanel');
			 	                	var externalInterActiveTab = innerActiveTab.getActiveTab()
	
			 	                	if(!isNullOrEmpty(externalInterActiveTab)){
				 	                	var studentId = me.getContentPanelActiveTab().getUserId();
				 	                	var form = me.getStudentTransferCreditRequestFilter();
			 	                		if (externalInterActiveTab.down('#studentExternalTransferCreditRequestGridId')) {
			 	                			var grid = me.getStudentExternalTransferCreditRequestGrid(),
					 	                	 program = form.down('#stcrdProgramItemId')	
					 						 batch = form.down('#stcrdBatchItemId')
					 	                	grid.getStore().getProxy().extraParams = {
					 	                		batchId:batch.getValue(),
					 	                		programId: program.getValue(),
				 		   						studentId: studentId,
					 						}
					 	                	grid.getStore().load();
											grid.getSelectionModel().deselectAll();
			 	                		}
			 	                		if (externalInterActiveTab.down('#studentInternalTransferCreditRequestGridId')) { 
			 	                			var grid = me.getStudentInternalTransferCreditRequestGrid(),
					 	                	//formVal = form.getValues();   
					 	                	 program = form.down('#stcrdProgramItemId')	
					 						 batch = form.down('#stcrdBatchItemId')
					 	                	grid.getStore().getProxy().extraParams = {
					 	                		batchId:batch.getValue(),
					 	                		programId: program.getValue(),
				 		   						studentId: studentId,
					 						}
					 	                	grid.getStore().load();
											grid.getSelectionModel().deselectAll();  
			 	                		}
			 	                	}
			 	                }
			 	            },
			 				 'studentTransferCreditRequestFilter button[itemId=resetBtn]': {
			 	            	click: function(cmp){
			 	            		var me = this
			 	            		var activePannel = me.getContentPanelActiveTab();
			 	            		var studentId = activePannel.getUserId();
			 	            		//form = me.getStudentTransferCreditRequestFilter()
			 	            		var form = cmp.up('studentTransferCreditRequestFilter')
			 	            		var programField = form.down('#stcrdProgramItemId');
			 				        var batchField = form.down('#stcrdBatchItemId');
				 				       programField.reset();
				 				       batchField.reset();
			 				       var programStore = programField.getStore();
			 				        programStore.getProxy().extraParams = {
			 				            studentId: studentId
			 				        };
			 				       programStore.load({
			 				            callback: function(records, success) {
			 				                if (!success || records.length === 0) return;

			 				                var selectedProgram = records.length === 1 ? records[0] : Ext.Array.findBy(records, function(rec) {
			 				                    return !!rec.get('value');
			 				                });

			 				                if (selectedProgram) {
			 				                    var programId = selectedProgram.get('id');
			 				                    programField.setValue(programId);

			 				                    var batchStore = batchField.getStore();

			 				                    if (!batchStore) return;

			 				                    batchStore.getProxy().extraParams = {
			 				                        programId: programId,
			 				                        studentId: studentId
			 				                    };

			 				                    batchStore.load({
			 				                        callback: function(batchRecords, batchSuccess) {
			 				                            if (batchSuccess && batchRecords.length > 0) {
			 				                                batchField.setValue(batchRecords[0].get('id'));
			 				                            }
			 				                        }
			 				                    });
			 				                }
			 				            }
			 				        });
			 	            	}
			 	            },
	 	            		'studentExternalTransferCreditRequestGridStructure button[itemId=btnResetItemId]':{
	 	            			click: function(btn){
	 	            				var me = this;
	 	            				var grid = me.getStudentExternalTransferCreditRequestGrid();
	 	            				if (grid && grid.getSelectionModel) {
	 	            					 var selectedRecords = grid.getSelectionModel().getSelection();
	 	                                Ext.each(selectedRecords, function(record) {
	 	                                    record.reject();
	 	                                });
	 	            		            grid.getSelectionModel().deselectAll();	 	            		            
	 	            		        }
	 	            			}
	 	            		},
	 	            		'studentInternalTransferCreditRequestGridStructure button[itemId=btnResetItemId]':{
	 	            			click: function(btn){
	 	            				var me = this;
	 	            				var grid = me.getStudentInternalTransferCreditRequestGrid();
	 	            				if (grid && grid.getSelectionModel) {	 	            					
	 	            					var selectedRecords = grid.getSelectionModel().getSelection();
	 	                                Ext.each(selectedRecords, function(record) {
	 	                                    record.reject();
	 	                                });	 	                                
	 	            		            grid.getSelectionModel().deselectAll();
	 	            		        }
	 	            			}
	 	            		},
	 	            		'studentInternalTransferCreditRequestGridStructure button[itemId=btnSubmitItemId]': {
	 	            		    click: function (obj) {
	 	            		    	var me = this
	 	            		        var grid = me.getStudentInternalTransferCreditRequestGrid();
	 	            		        var studentId = me.getContentPanelActiveTab().getUserId();
	 	            		        var admissionId = me.getContentPanelActiveTab().getAdmissionId();
	 	            		        var personId = me.getContentPanelActiveTab().getPersonId();
	 	            		        if (grid.getSelectionModel().getCount() > 0) {
	 	            		            var selectedRecords = grid.getSelectionModel().getSelection();
	 	            		            var finalData = [];
	 	                               var form = me.getStudentTransferCreditRequestFilter()
	                                    var batch = form.down('#stcrdBatchItemId');
	                                    var batchId = batch.getValue();
										var periodId=batch.getStore().data.items[0].data.personId;
	 	            		           var hasEmptyRequiredField = false;

	 	            		          Ext.Array.each(selectedRecords, function (rec) {

	 	            		              if (isNullOrEmpty(rec.get('equivalentCourseName')) && isNullOrEmpty(rec.get('equivalentCourseCode'))) {
	 	            		                  hasEmptyRequiredField = true;
	 	            		                  return false;
	 	            		              }
	 	            		          });

	 	            		          if (hasEmptyRequiredField) {
	 	            		        	 showWarningMessage(getExaminationTranslation('REQUIRED_FIELDS'), getExaminationTranslation('EQUIVALENT_COURSE_NAME_AND_COURSE_CODE_ARE_REQUIRED_TO_SELECTED_RECORDS'));
	 	            					 return;
	 	            		          }
	 	            		          
	 	            		            Ext.Array.forEach(selectedRecords, function (rec) {
	 	            		                var data = rec.data;
	 	            		                var mappedData = {
	 	            		                    id: isNullOrEmpty(data.id) ? null : data.id,
	 	            		                    admissionId: isNullOrEmpty(admissionId) ? null : admissionId,
	 	            		                		   
	 	            		                		    courseId: isNullOrEmpty(data.courseId) ? null : data.courseId,
	 	            		                		    programId: isNullOrEmpty(data.programId) ? null : data.programId,
	 	            		                		    //batchId: isNullOrEmpty(data.batchId) ? null : data.batchId,
	 	            		                		    batchId: isNullOrEmpty(batchId) ? null : batchId,
	 	            		                		   // periodId: isNullOrEmpty(data.periodId) ? null : data.periodId,
														periodId: isNullOrEmpty(periodId) ? null : periodId,
	 	            		                		    courseVariantId: isNullOrEmpty(data.courseVariantId) ? null : data.courseVariantId,

	 	            		                		    courseCode: isNullOrEmpty(data.courseCode) ? null : data.courseCode,
	 	            		                		    courseName: isNullOrEmpty(data.courseName) ? null : data.courseName,
	 	            		                		    marksGrade: isNullOrEmpty(data.marksGrade) ? null : data.marksGrade,
	 	            		                		    programName: isNullOrEmpty(data.programName) ? null : data.programName,
	 	            		                		    batchName: isNullOrEmpty(data.batchName) ? null : data.batchName,
	 	            		                		    programPeriodName: isNullOrEmpty(data.programPeriodName) ? null : data.programPeriodName,
	 	            		                		    //currentGrade: isNullOrEmpty(data.currentGrade) ? null : data.currentGrade,
	 	            		                		    equivalentCourseCode: isNullOrEmpty(data.equivalentCourseCode) ? null : data.equivalentCourseCode,
	 	            		                		    equivalentCourseName: isNullOrEmpty(data.equivalentCourseName) ? null : data.equivalentCourseName,
	 	            		                		    institueName: isNullOrEmpty(data.institueName) ? null : data.institueName,
	 	            		                		    equivalentCourseCredit: isNullOrEmpty(data.equivalentCourseCredit) ? null : data.equivalentCourseCredit,
	 	            		                		    obtainedMarksGrade: isNullOrEmpty(data.obtainedMarksGrade) ? null : data.obtainedMarksGrade,
	 	            		                		    //gradeType: isNullOrEmpty(data.gradeType) ? null : data.gradeType,
	 	            		                		    remark: isNullOrEmpty(data.remark) ? null : data.remark,
	 	            		                		    transferResultStatus: isNullOrEmpty(data.transferResultStatus) ? null : data.transferResultStatus,

	 	            		                		    isEquivalenceCheck: data.isEquivalenceCheck || false,
	 	            		                		    isTransferCreditFromStudentPortal: data.isTransferCreditFromStudentPortal || false,

	 	            		                		    courseCredit: isNullOrEmpty(data.courseCredit) ? null : data.courseCredit,
	 	            		                		    //currentMarks: isNullOrEmpty(data.currentMarks) ? null : data.currentMarks,
	 	            		                		    applicantTransferCreditStatus: isNullOrEmpty(data.applicantTransferCreditStatus) ? 'PENDING' : data.applicantTransferCreditStatus,
	 	            		                		    examTransferCreditType: isNullOrEmpty(data.examTransferCreditType) ? null : data.examTransferCreditType,
	 	            		                		    gradeTypeList: isNullOrEmpty(data.gradeTypeList) ? null : data.gradeTypeList,
	 	            		                		    documentId: isNullOrEmpty(data.documentId) ? null : data.documentId,
	 	            		                		  //  gradePoint: isNullOrEmpty(data.gradePoint) ? null : data.gradePoint,
													    gradePoint: isNullOrEmpty(data.doubleValue) ? data.gradePoint : data.doubleValue,
	 	       	 	            		                courseGradeType: isNullOrEmpty(data.courseGradeType) ? null : data.courseGradeType,
	 	            		                		    transferType: "INTERNAL_TRANSFER_CREDIT",
	 	            		                };

	 	            		                finalData.push(mappedData);
	 	            		            });
	 	            		           Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 	            		            Ext.Ajax.request({
	 	            		                url: SERVERURL.PATH_STUDENT_TRANSFER_SAVE_DATA,
	 	            		                method: 'POST',
	 	            		                jsonData: finalData,
	 	            		                success: function () {
	 	            		                	Ext.getBody().unmask();
												showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
												grid.getStore().load();
												grid.getSelectionModel().deselectAll();
	 	            		                },
	 	            		                failure: function () {
	 	            		                	Ext.getBody().unmask();
	 	            		                }
	 	            		            });

	 	            		        } else {
	 	            		        	Ext.getBody().unmask();
	 	            		        }
	 	            		    }
	 	            		},
	 	            		'studentExternalTransferCreditRequestGridStructure button[itemId=btnSubmitItemId]': {
	 	            		    click: function (obj) {var me = this;
	 	            		   var grid = me.getStudentExternalTransferCreditRequestGrid();
	 	            		  var studentId = me.getContentPanelActiveTab().getUserId();
	 	            		  var admissionId = me.getContentPanelActiveTab().getAdmissionId();
	 	            		  var personId = me.getContentPanelActiveTab().getPersonId();

	 	            		  if (grid.getSelectionModel().getCount() > 0) {
	 	            		      var selectedRecords = grid.getSelectionModel().getSelection();
	 	            		      var finalData = [];

	 	            		     var hasEmptyRequiredField = false;

	            		          Ext.Array.each(selectedRecords, function (rec) {

	            		              if (isNullOrEmpty(rec.get('equivalentCourseName')) || isNullOrEmpty(rec.get('equivalentCourseCode'))) {
	            		                  hasEmptyRequiredField = true;
	            		                  return false;
	            		              }
	            		          });

	            		          if (hasEmptyRequiredField) {
	            		        	 showWarningMessage(getExaminationTranslation('REQUIRED_FIELDS'), getExaminationTranslation('EQUIVALENT_COURSE_NAME_AND_COURSE_CODE_ARE_REQUIRED_TO_SELECTED_RECORDS'));
	            		        	 return;
	            		          }
	 	            		   
	 	            		      Ext.Array.forEach(selectedRecords, function (rec) {
	 	            		          var data = rec.data;
	 	            		          var mappedData = {
	 	            		              id: isNullOrEmpty(data.id) ? null : data.id,
	 	            		              admissionId: isNullOrEmpty(admissionId) ? null : admissionId,
	 	            		              courseId: isNullOrEmpty(data.courseId) ? null : data.courseId,
	 	            		              programId: isNullOrEmpty(data.programId) ? null : data.programId,
	 	            		              batchId: isNullOrEmpty(data.batchId) ? null : data.batchId,
	 	            		              periodId: isNullOrEmpty(data.periodId) ? null : data.periodId,
	 	            		              courseVariantId: isNullOrEmpty(data.courseVariantId) ? null : data.courseVariantId,
	 	            		              courseCode: isNullOrEmpty(data.courseCode) ? null : data.courseCode,
	 	            		              courseName: isNullOrEmpty(data.courseName) ? null : data.courseName,
	 	            		              marksGrade: isNullOrEmpty(data.marksGrade) ? null : data.marksGrade,
	 	            		              programName: isNullOrEmpty(data.programName) ? null : data.programName,
	 	            		              batchName: isNullOrEmpty(data.batchName) ? null : data.batchName,
	 	            		              programPeriodName: isNullOrEmpty(data.programPeriodName) ? null : data.programPeriodName,
	 	            		              equivalentCourseCode: isNullOrEmpty(data.equivalentCourseCode) ? null : data.equivalentCourseCode,
	 	            		              equivalentCourseName: isNullOrEmpty(data.equivalentCourseName) ? null : data.equivalentCourseName,
	 	            		              institueName: isNullOrEmpty(data.institueName) ? null : data.institueName,
	 	            		              equivalentCourseCredit: isNullOrEmpty(data.equivalentCourseCredit) ? null : data.equivalentCourseCredit,
	 	            		              obtainedMarksGrade: isNullOrEmpty(data.obtainedMarksGrade) ? null : data.obtainedMarksGrade,
	 	            		              studentRemark: isNullOrEmpty(data.studentRemark) ? null : data.studentRemark,
										  facultyRemark: isNullOrEmpty(data.facultyRemark) ? null : data.facultyRemark,
										  completionDate: isNullOrEmpty(data.completionDate) ? null : data.completionDate,
	 	            		              transferResultStatus: isNullOrEmpty(data.transferResultStatus) ? null : data.transferResultStatus,
	 	            		              isEquivalenceCheck: data.isEquivalenceCheck || false,
	 	            		              isTransferCreditFromStudentPortal: data.isTransferCreditFromStudentPortal || false,
	 	            		              courseCredit: isNullOrEmpty(data.courseCredit) ? null : data.courseCredit,
	 	            		              applicantTransferCreditStatus: isNullOrEmpty(data.applicantTransferCreditStatus) ? 'PENDING' : data.applicantTransferCreditStatus,
	 	            		              //examTransferCreditType: isNullOrEmpty(data.examTransferCreditType) ? null : data.examTransferCreditType,
	 	            		              examTransferCreditType: "EXTERNAL_TRANSFER_CREDIT",
	 	            		              gradeTypeList: isNullOrEmpty(data.gradeTypeList) ? null : data.gradeTypeList,
	 	            		              documentId: isNullOrEmpty(data.documentId) ? null : data.documentId,
	 	            		              gradePoint: isNullOrEmpty(data.doubleValue) ? data.gradePoint : data.doubleValue,
	 	            		              courseGradeType: isNullOrEmpty(data.courseGradeType) ? null : data.courseGradeType,
	 	            		              transferType: "EXTERNAL_TRANSFER_CREDIT"
	 	            		          };
	 	            		          finalData.push(mappedData);
	 	            		      });

	 	            		      Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 	            		      Ext.Ajax.request({
	 	            		          url: SERVERURL.PATH_STUDENT_TRANSFER_SAVE_DATA,
	 	            		          method: 'POST',
	 	            		          jsonData: finalData,
	 	            		          success: function () {
	 	            		              Ext.getBody().unmask();
	 	            		              showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
	 	            		              grid.getStore().load();
	 	            		              grid.getSelectionModel().deselectAll();
	 	            		          },
	 	            		          failure: function () {
	 	            		              Ext.getBody().unmask();
	 	            		          }
	 	            		      });
	 	            		  } else {
	 	            		      Ext.getBody().unmask();
	 	            		  }
}
	 	            		},
	 	            		/*'studentInternalTransferCreditRequestGridStructure button[itemId=btnSubmitItemId]': {
	 	            		    click: function (obj) {
	 	            		    	var me = this
	 	            		        var grid = me.getStudentInternalTransferCreditRequestGrid();
	 	            		        var studentId = me.getContentPanelActiveTab().getUserId();
	 	            		        var admissionId = me.getContentPanelActiveTab().getAdmissionId();
	 	            		        var personId = me.getContentPanelActiveTab().getPersonId();
	 	            		        if (grid.getSelectionModel().getCount() > 0) {
	 	            		            var selectedRecords = grid.getSelectionModel().getSelection();
	 	            		            var finalData = []
	 	            		            
	 	            		           var hasEmptyRequiredField = false;

	 	 	            		      Ext.Array.each(selectedRecords, function (rec) {
	 	 	            		    	  
	 	 	            		          if (isNullOrEmpty(rec.get('equivalentCourseName')) && isNullOrEmpty(rec.get('equivalentCourseCode'))) {
	 	 	            		              hasEmptyRequiredField = true;
	 	 	            		              return false;
	 	 	            		          }
	 	 	            		      });

	 	 	            		      if (hasEmptyRequiredField) {
		 	            		        	 showWarningMessage(getExaminationTranslation('REQUIRED_FIELDS'), getExaminationTranslation('EQUIVALENT_COURSE_NAME_AND_COURSE_CODE_ARE_REQUIRED_TO_SELECTED_RECORDS'));
	 	 	            		          return; 
	 	 	            		      }
	 	            		            Ext.Array.forEach(selectedRecords, function (rec) {
	 	            		                var data = rec.data;

	 	            		                var mappedData = {
	 	            		                    id: isNullOrEmpty(data.id) ? null : data.id,
	 	            		                    admissionId: isNullOrEmpty(admissionId) ? null : admissionId,
	 	            		                		   
	 	            		                		    courseId: isNullOrEmpty(data.courseId) ? null : data.courseId,
	 	            		                		    programId: isNullOrEmpty(data.programId) ? null : data.programId,
	 	            		                		    batchId: isNullOrEmpty(data.batchId) ? null : data.batchId,
	 	            		                		    periodId: isNullOrEmpty(data.periodId) ? null : data.periodId,
	 	            		                		    courseVariantId: isNullOrEmpty(data.courseVariantId) ? null : data.courseVariantId,

	 	            		                		    courseCode: isNullOrEmpty(data.courseCode) ? null : data.courseCode,
	 	            		                		    courseName: isNullOrEmpty(data.courseName) ? null : data.courseName,
	 	            		                		    marksGrade: isNullOrEmpty(data.marksGrade) ? null : data.marksGrade,
	 	            		                		    programName: isNullOrEmpty(data.programName) ? null : data.programName,
	 	            		                		    batchName: isNullOrEmpty(data.batchName) ? null : data.batchName,
	 	            		                		    programPeriodName: isNullOrEmpty(data.programPeriodName) ? null : data.programPeriodName,
	 	            		                		    //currentGrade: isNullOrEmpty(data.currentGrade) ? null : data.currentGrade,
	 	            		                		    equivalentCourseCode: isNullOrEmpty(data.equivalentCourseCode) ? null : data.equivalentCourseCode,
	 	            		                		    equivalentCourseName: isNullOrEmpty(data.equivalentCourseName) ? null : data.equivalentCourseName,
	 	            		                		    institueName: isNullOrEmpty(data.institueName) ? null : data.institueName,
	 	            		                		    equivalentCourseCredit: isNullOrEmpty(data.equivalentCourseCredit) ? null : data.equivalentCourseCredit,
	 	            		                		    obtainedMarksGrade: isNullOrEmpty(data.obtainedMarksGrade) ? null : data.obtainedMarksGrade,
	 	            		                		    //gradeType: isNullOrEmpty(data.gradeType) ? null : data.gradeType,
													    studentRemark: isNullOrEmpty(data.studentRemark) ? null : data.studentRemark,
													    facultyRemark: isNullOrEmpty(data.facultyRemark) ? null : data.facultyRemark,
													    completionDate: isNullOrEmpty(data.completionDate) ? null : data.completionDate,
	 	            		                		    transferResultStatus: isNullOrEmpty(data.transferResultStatus) ? null : data.transferResultStatus,

	 	            		                		    isEquivalenceCheck: data.isEquivalenceCheck || false,
	 	            		                		    isTransferCreditFromStudentPortal: data.isTransferCreditFromStudentPortal || false,

	 	            		                		    courseCredit: isNullOrEmpty(data.courseCredit) ? null : data.courseCredit,
	 	            		                		    //currentMarks: isNullOrEmpty(data.currentMarks) ? null : data.currentMarks,
	 	            		                		    applicantTransferCreditStatus: isNullOrEmpty(data.applicantTransferCreditStatus) ? 'PENDING' : data.applicantTransferCreditStatus,
	 	            		                		    //examTransferCreditType: isNullOrEmpty(data.examTransferCreditType) ? null : data.examTransferCreditType,
	 	            		                		    examTransferCreditType: "INTERNAL_TRANSFER_CREDIT",
	 	            		                		    gradeTypeList: isNullOrEmpty(data.gradeTypeList) ? null : data.gradeTypeList,
	 	            		                		    documentId: isNullOrEmpty(data.documentId) ? null : data.documentId,
	 	            		                		    gradePoint: isNullOrEmpty(data.gradePoint) ? null : data.gradePoint,
	 	       	 	            		                courseGradeType: isNullOrEmpty(data.courseGradeType) ? null : data.courseGradeType,
	 	            		                		    transferType: "INTERNAL_TRANSFER_CREDIT",
	 	            		                };

	 	            		                finalData.push(mappedData);
	 	            		            });
	 	            		           Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 	            		            Ext.Ajax.request({
	 	            		                url: SERVERURL.PATH_STUDENT_TRANSFER_SAVE_DATA,
	 	            		                method: 'POST',
	 	            		                jsonData: finalData,
	 	            		                success: function () {
	 	            		                	Ext.getBody().unmask();
												showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
												grid.getStore().load();
												grid.getSelectionModel().deselectAll();
	 	            		                },
	 	            		                failure: function () {
	 	            		                	Ext.getBody().unmask();
	 	            		                }
	 	            		            });

	 	            		        } else {
	 	            		        	Ext.getBody().unmask();
	 	            		        }
	 	            		    }
	 	            		}*/

		 			   /*Deadpool Transfer Creadit Development:End*/
   
		});
	},
	onGridViewReadyToInternal: function (view) {

	    view.el.on('change', function (e, t) {
	    	var me = this;
	    	var grid  = me.getStudentInternalTransferCreditRequestGrid()
	        var input = t;
	        var file = input.files[0];

	        if (!file) return;
			
			var allowedTypes = ['application/pdf', 'image/png', 'image/jpeg'];
										    var maxSizeMB = 5;
										    var maxSizeBytes = maxSizeMB * 1024 * 1024;

										    if (!allowedTypes.includes(file.type)) {
												showWarningMessage(getCommonTranslation('ALERT'),'Invalid file type. Only PDF, PNG, and JPEG are allowed');										    
										      return false;
										    }

										    if (file.size > maxSizeBytes) {
												showWarningMessage(getCommonTranslation('ALERT'),'File size exceeds 5MB limit');    
										      return false; 
										    } 

	        var formData = new FormData();
	        
	        formData.append('file', file);
	        
	        var userInfo = Academia.model.authentication.UserInfoModel;
	       	 var access_token = userInfo.get("accessToken");
	        
	       	var url = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPLOAD_DOC+'?access_token='+access_token;
	       	 
	       	 var xhr = new XMLHttpRequest();
	       	 xhr.open('POST', url);
	       	 xhr.onload = function () {
	       	     if (xhr.status >= 200 && xhr.status < 300) {
	       	         var response = JSON.parse(xhr.responseText);
	       	      var response = JSON.parse(xhr.responseText);
                  var documentId = response;

                  var rowEl = Ext.get(input).up('tr.x-grid-row');
                  if (!rowEl) return;

                  var allRows = view.el.query('tr.x-grid-row');
                  var rowIndex = -1;
                  for (var i = 0; i < allRows.length; i++) {
                      if (allRows[i] === rowEl.dom) {
                          rowIndex = i;
                          break;
                      }
                  }

                  if (rowIndex !== -1) {
                      var record = grid.getStore().getAt(rowIndex);
                      if (record) {
                          var cleanedValue = input.value.replace('C:\\fakepath\\', '').replace(/ +/g, " ").split(' ').join('_');
                          record.set('documentId', documentId);
                          record.set('document', cleanedValue);
                          record.commit();
                          showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_UPLOADED'));
                      }
                  }
                  else {
                      showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SAVE'));
                  }
	       	     }
	       	 };
	       	 xhr.send(formData);

	    }, this, {
	        delegate: 'input.grid-upload-input',
	        capture: true
	    });
	    
	    view.el.on('click', function (e, t) {
	        //var target = Ext.get(t).down('.download-icon-v2');
	        var target = Ext.get(t)

	        if (target && target.hasCls('download-icon-v2') && !target.hasCls('disabled')) {
	            var docPath = target.getAttribute('data-doc-path');
	            if (!docPath) {
	                return;
	            }

	            var userInfo = Academia.model.authentication.UserInfoModel;
	            var access_token = userInfo.get("accessToken");

	            
	            var form = document.createElement('form');
	            form.method = 'POST';
	            form.action = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_DOWNLOAD_DOC;
	            form.target = '_blank'; 

	            var tokenInput = document.createElement('input');
	            tokenInput.type = 'hidden';
	            tokenInput.name = 'access_token';
	            tokenInput.value = access_token;
	            form.appendChild(tokenInput);

	            var docIdInput = document.createElement('input');
	            docIdInput.type = 'hidden';
	            docIdInput.name = 'docId';
	            docIdInput.value = docPath;
	            form.appendChild(docIdInput);
	            
	            document.body.appendChild(form);
	            form.submit();
	            document.body.removeChild(form);
	            showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_DOWNLOADED'));
	        }
	    }, this, { delegate: '.download-icon-v2' });
   
	},
	onGridViewReady: function (view) {

	    view.el.on('change', function (e, t) {
	    	var me = this;
	    	var grid  = me.getStudentExternalTransferCreditRequestGrid()
	        var input = t;
	        var file = input.files[0];
	        if (!file) return;
			
			var allowedTypes = ['application/pdf', 'image/png', 'image/jpeg'];
							    var maxSizeMB = 5;
							    var maxSizeBytes = maxSizeMB * 1024 * 1024;

							    if (!allowedTypes.includes(file.type)) {
									showWarningMessage(getCommonTranslation('ALERT'),'Invalid file type. Only PDF, PNG, and JPEG are allowed');
							     // fileInput.value = ''; // Reset input  
							      return false;
							    }

							    if (file.size > maxSizeBytes) {
									showWarningMessage(getCommonTranslation('ALERT'),'File size exceeds 5MB limit'); 
							     // fileInput.value = ''; // Reset input 
							      return false; 
							    } 

	        var formData = new FormData();
	        
	        formData.append('file', file);
	        
	        var userInfo = Academia.model.authentication.UserInfoModel;
	       	 var access_token = userInfo.get("accessToken");
	        
	       	var url = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPLOAD_DOC+'?access_token='+access_token;
	       	 
	       	 var xhr = new XMLHttpRequest();
	       	 xhr.open('POST', url);
	       	 xhr.onload = function () {
	       	     if (xhr.status >= 200 && xhr.status < 300) {
	       	         var response = JSON.parse(xhr.responseText);
	       	      var response = JSON.parse(xhr.responseText);
                  var documentId = response;

                  var rowEl = Ext.get(input).up('tr.x-grid-row');
                  if (!rowEl) return;

                  var allRows = view.el.query('tr.x-grid-row');
                  var rowIndex = -1;
                  for (var i = 0; i < allRows.length; i++) {
                      if (allRows[i] === rowEl.dom) {
                          rowIndex = i;
                          break;
                      }
                  }

                  if (rowIndex !== -1) {
                      var record = grid.getStore().getAt(rowIndex);
                      if (record) {
                          var cleanedValue = input.value.replace('C:\\fakepath\\', '').replace(/ +/g, " ").split(' ').join('_');
                          record.set('documentId', documentId);
                          record.set('document', cleanedValue);
                          record.commit();
                          showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_UPLOADED'));
                      }
                  }
                  else {
                      showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SAVE'));
                  }
	       	     }
	       	 };
	       	 xhr.send(formData);

	    }, this, {
	        delegate: 'input.grid-upload-input',
	        capture: true
	    });
	    
	    view.el.on('click', function (e, t) {
	        //var target = Ext.get(t).down('.download-icon-v2');
	        var target = Ext.get(t)

	        if (target && target.hasCls('download-icon-v2') && !target.hasCls('disabled')) {
	            var docPath = target.getAttribute('data-doc-path');
	            if (!docPath) {
	                return;
	            }

	            var userInfo = Academia.model.authentication.UserInfoModel;
	            var access_token = userInfo.get("accessToken");

	            
	            var form = document.createElement('form');
	            form.method = 'POST';
	            form.action = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_DOWNLOAD_DOC;
	            form.target = '_blank'; 

	            var tokenInput = document.createElement('input');
	            tokenInput.type = 'hidden';
	            tokenInput.name = 'access_token';
	            tokenInput.value = access_token;
	            form.appendChild(tokenInput);

	            var docIdInput = document.createElement('input');
	            docIdInput.type = 'hidden';
	            docIdInput.name = 'docId';
	            docIdInput.value = docPath;
	            form.appendChild(docIdInput);
	            
	            document.body.appendChild(form);
	            form.submit();
	            document.body.removeChild(form);
	            showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_DOWNLOADED'));
	        }
	    }, this, { delegate: '.download-icon-v2' });
   
	},
		
	transferCreditApprove: function(btn){
		var this$ = this;		
		var mainTab = this$.getContentPanelActiveTab();
     	var nestedTabPanel = mainTab.down('tabpanel').getActiveTab();
     	var innerActiveTab = nestedTabPanel.down('tabpanel');
     	var externalInterActiveTab = innerActiveTab.getActiveTab()
     	var grid;
     	
     	if(!isNullOrEmpty(externalInterActiveTab)){
    		if (externalInterActiveTab.down('#studentExternalTransferCreditRequestGridId')) {
    			 grid = this$.getStudentExternalTransferCreditRequestGrid();			 	                		
    		}
    		if (externalInterActiveTab.down('#studentInternalTransferCreditRequestGridId')) {
    			 grid = this$.getStudentInternalTransferCreditRequestGrid();			 	                		
    		}
    	}
	showConfirmMessage(
			getExaminationTranslation('TRANSFER_CREDIT_LIST'),
			getExaminationTranslation('DO_YOU_WANT_TO_APPROVE?'),
	    function (btn) {
	        if (btn === 'yes') {
	            var selectionModel = grid.getSelectionModel().getSelection();

	            if (selectionModel.length > 0) {
	                var recordsData = [];

	                Ext.each(selectionModel, function (rec) {
						delete rec.data.document;
	                    recordsData.push(rec.data);
	                });

	                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

	                Ext.Ajax.request({
	                    url: SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPDATE_STATUS,
	                    method: 'POST',
	                    headers: {
	                        'Content-Type': 'application/json'
	                    },
	                    params: {
	                        status: 'approve'
	                    },
	                    jsonData: recordsData,
	                    success: function (response) {
	                        Ext.getBody().unmask();
							if(response.responseText!=""){
								var mssg = response.responseText;
								
								if (mssg == 'Approve' ||mssg=='Submit' || mssg=='reject' || mssg=='approve') {
									showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('TRANSFER_CREDIT_APPROVED_SUCCESSFULLY'));
									grid.getStore().load();
									grid.getSelectionModel().deselectAll();
								} else if (mssg == 'EXEMPTION CREDIT LIMIT REACHED') {
									showWarningMessage(getCommonTranslation('ALERT'),
										getCommonTranslation('EXEMPTION_CREDIT_LIMIT_REACHED'));
										grid.getStore().load();
										grid.getSelectionModel().deselectAll(); 
								} else {
									showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SUBMIT'));
									grid.getStore().load();
									grid.getSelectionModel().deselectAll(); 
								}


	                       /* showSuccessMessage(
	                            getCommonTranslation('SUCCESS'),
	                            getExaminationTranslation('TRANSFER_CREDIT_APPROVED_SUCCESSFULLY')
	                        );*/
	                       
							}
	                    },
	                   /* failure: function () {
	                        Ext.getBody().unmask();
	                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SUBMIT'));
	                    }*/
	                });
	            }
	        }
	    }
	);
},
transferCreditResubmit: function(btn){
	var this$ = this;		
	var mainTab = this$.getContentPanelActiveTab();
 	var nestedTabPanel = mainTab.down('tabpanel').getActiveTab();
 	var innerActiveTab = nestedTabPanel.down('tabpanel');
 	var externalInterActiveTab = innerActiveTab.getActiveTab()
 	var grid;
 	
 	if(!isNullOrEmpty(externalInterActiveTab)){
		if (externalInterActiveTab.down('#studentExternalTransferCreditRequestGridId')) {
			 grid = this$.getStudentExternalTransferCreditRequestGrid();			 	                		
		}
		if (externalInterActiveTab.down('#studentInternalTransferCreditRequestGridId')) {
			 grid = this$.getStudentInternalTransferCreditRequestGrid();			 	                		
		}
	}

showConfirmMessage(
		getExaminationTranslation('TRANSFER_CREDIT_LIST'),
		getExaminationTranslation('DO_YOU_WANT_TO_RESUBMIT?'),
    function (btn) {
        if (btn === 'yes') {
            var selectionModel = grid.getSelectionModel().getSelection();

            if (selectionModel.length > 0) {
                var recordsData = [];

                Ext.each(selectionModel, function (rec) {
					delete rec.data.document;
                    recordsData.push(rec.data);
                });

                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

                Ext.Ajax.request({
                    url: SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPDATE_STATUS,
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    params: {
                        status: 'need_to_resubmit'
                    },
                    jsonData: recordsData,
                    success: function (response) {
                        Ext.getBody().unmask();
                        showSuccessMessage(
                            getCommonTranslation('SUCCESS'),
                            getExaminationTranslation('TRANSFER_CREDIT_RESUBMIT_SUCCESSFULLY')
                        );
                        grid.getStore().load();
                        grid.getSelectionModel().deselectAll();
                    },
                    failure: function () {
                        Ext.getBody().unmask();
                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SUBMIT'));
                    }
                });
            }
        }
    }
);
},
transferCreditReject: function(btn){
	var this$ = this;		
	var mainTab = this$.getContentPanelActiveTab();
 	var nestedTabPanel = mainTab.down('tabpanel').getActiveTab();
 	var innerActiveTab = nestedTabPanel.down('tabpanel');
 	var externalInterActiveTab = innerActiveTab.getActiveTab()
 	var grid;
 	
 	if(!isNullOrEmpty(externalInterActiveTab)){
		if (externalInterActiveTab.down('#studentExternalTransferCreditRequestGridId')) {
			 grid = this$.getStudentExternalTransferCreditRequestGrid();			 	                		
		}
		if (externalInterActiveTab.down('#studentInternalTransferCreditRequestGridId')) {
			 grid = this$.getStudentInternalTransferCreditRequestGrid();			 	                		
		}
	}

showConfirmMessage(
		getExaminationTranslation('TRANSFER_CREDIT_LIST'),
		getExaminationTranslation('DO_YOU_WANT_TO_REJECT?'),
    function (btn) {
        if (btn === 'yes') {
            var selectionModel = grid.getSelectionModel().getSelection();

            if (selectionModel.length > 0) {
                var recordsData = [];

                Ext.each(selectionModel, function (rec) {
					delete rec.data.document;
                    recordsData.push(rec.data);
                });

                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

                Ext.Ajax.request({
                    url: SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPDATE_STATUS,
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    params: {
                        status: 'reject'
                    },
                    jsonData: recordsData,
                    success: function (response) {
                        Ext.getBody().unmask();
                        showSuccessMessage(
                            getCommonTranslation('SUCCESS'),
                            getExaminationTranslation('TRANSFER_CREDIT_REJECT_SUCCESSFULLY')
                        );
                        grid.getStore().load();
                        grid.getSelectionModel().deselectAll();
                    },
                    failure: function () {
                        Ext.getBody().unmask();
                        showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SUBMIT'));
                    }
                });
            }
        }
    }
);
},
	saveUploadDocumentPath: function(docUrl){
    	var me = this;
    	 var grid = me.getStudentExternalTransferCreditRequestGrid();
	        if (grid.getSelectionModel().getCount() == 1 ) {
	            var selectedRecords = grid.getSelectionModel().getSelection();
	            var finalData = [];

	          var id= selectedRecords[0].data.id
	          
    	var payload = {
	        		  transferCreditId: isNullOrEmpty(id) ? null : id,
    				   documentPath : docUrl
    	};
    	
    	var submitUrl = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPLOAD_DOC_UPDATE;
    	
    	var data = Ext.encode(payload);
    	
    	Ext.Ajax.request({
    		url: submitUrl,
    		method: 'POST',
    		jsonData:data,
            success: function(response){
            	var responseData = response.responseText;
            	if (responseData=='fail') {
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
            	}else{
            		showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
            	}
            	me.hideWindowMask();
            },
            failure: function(response){
            	me.hideWindowMask();
            }
    	})
	           
	        }
    },
	disableStudentTransferCreditInternalTab: function(structure,permissionsMap){
		var associatedAcadLocationIds = new Array();
	   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   	 var TransferCreditInternalTab=false;
	   	 
	   	for (var i = 0; i < permissionList.length; i++) {
	   		 if (permissionList[i] === "INTERNAL_TRANSFER_CREDIT_TAB") {
	   			TransferCreditInternalTab=true;
	   		 }
	   	 }
	   	 this.showTransferCreditInternalTab(TransferCreditInternalTab, structure);	   	  	 
	},
	showTransferCreditInternalTab: function(TransferCreditInternalTab,structure){
	   	 var panelItem = new Array();
	   	 var $this = this;
	   	 var newcont=structure.items.items.length;
	   	 var insertPosition=newcont+1;
	   	 if(TransferCreditInternalTab==true) {
	   		 panelItem.push({
	 			xtype:'tabpanel',
				 plain: true,
				 style:{overflow:'hidden !important',margin:'0!important'},
				 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
				 frame: false,
				 border:false,
					items : [{
						title: getCommonTranslation('EXTERNAL_TRANSFER_CREDIT'),
						layout:'vbox',
						defaults: {
							width:'100%'
						},
						itemId: 'externalTransferCreditTabItemId',
						items:[{
						    xtype:'studentExternalTransferCreditRequestGridStructure'
						}]			
					},{
						title :getCommonTranslation('INTERNAL_TRANSFER_CREDIT'),
						layout:'vbox',
						defaults: {
							width:'100%'
						},
						itemId: 'internalTransferCreditTabItemId',
		   				 items:[{
		   					 xtype: 'studentInternalTransferCreditRequestGridStructure',
		   				 }]
		   			 }]
			 
		});
	   	 }else{
	   		 panelItem.push({
	 			xtype:'tabpanel',
				 plain: true,
				 style:{overflow:'hidden !important',margin:'0!important'},
				 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
				 frame: false,
				 border:false,
					items : [{
						title: getCommonTranslation('EXTERNAL_TRANSFER_CREDIT'),
						layout:'vbox',
						defaults: {
							width:'100%'
						},
						itemId: 'externalTransferCreditTabItemId',
						items:[{
							xtype:'studentExternalTransferCreditRequestGrid'
						}]			
					}]			 
		});
	   	 }
	   	 structure.insert(insertPosition,panelItem);
	  },
	 addExportToPngForDegreeReportStatistics:function(panel,chart){
	  		var $this = this;
	      	var exportToPNG={
	      			 text: 'Export To PNG',
	  		         itemId :'exportToPng',
	  		         handler: function(btn, target, header, tool){
	  		        	 var customWidth = 30;
	  		        	 var title = 'Statistics By '+getCommonTranslation(chart.up().title);
	  		        	 var surface = chart.surface;
	  		        	 var svg = Ext.draw.engine.SvgExporter.generate(surface);
	  		        	 var canvas = document.createElement('canvas');
	  		        	 var context = canvas.getContext("2d");
	  		        	 canvas.height = surface.height + 100;
	        				 canvas.width = surface.width+200;
	        				 var x = canvas.width / 10;
	        				 
	  		        	 context.font = "18px Georgia";
	  		        	 context.textAlign = 'bottom';
	  		             context.fillText(title, x, 20);
	                       context.fillStyle = "#FFFFFF";
	                       context.fillRect(0,30,surface.width+100,surface.height + 100);
	  		             context.drawSvg(svg,customWidth,30);
	  		        	 var dataURL = canvas.toDataURL('image/png',1.0);
	  		        	 downloadImage(dataURL,'chart.png');
	  		         }
	  	     };
	      	if(!Ext.isDefined(panel.items.items[0])){
	      	    panel.add(exportToPNG);
	      	    }
	  	},

	loadAcademicTopicData: function(obj){
		var $this = this;
		var grid = obj.up('academicstopicsstructureforstudentprofile').down('academicstopicquicksearchgrid');
		var addbtn=grid.down('#btnAdd');
		var editbtn=grid.down('#btnEdit');
		var deletebtn=grid.down('#btnDelete');
		
		var form = obj.up('form').getForm();
		var personProfile = $this.getContentPanelActiveTab();
		var studentId = personProfile.getUserId();
		var admissionId = personProfile.getAdmissionId();
		
		
		
		if(!isNullOrEmpty(studentId) && isNullOrEmpty(admissionId)){
			var studentProfileUrl = SERVERURL.PATH_FIND_ADMISSION_ID_BY_STUDENTID;
			Ext.Ajax.request({
				type: 'rest',
				url : studentProfileUrl+"?studentId="+studentId,
				method: 'GET',
				async: false,
				success: function(res, action) {
					admissionId = Ext.decode(res.responseText);
				},
				failure: function(res, action) {
					Ext.getBody().unmask();
				}
			});
		}
		var values = form.getValues();
//						if (values.iscurruntPeriod == 'true' && values.iscurruntSection == 'true'
//								&& isNullOrEmpty(values.exitDate)) {
//							addbtn.enable();
//							editbtn.enable();
//							deletebtn.enable();
//						} else {
//							addbtn.disable();
//							editbtn.disable();
//							deletebtn.disable();
//						}
		
		grid.getStore().getProxy().extraParams ={
			acadmicTypeId:values.academicTopicId,
			academicSubTypeId:values.academicSubTopicId,
			programId:values.programId,
			batchId:values.batch,
			periodId:values.period,
			studentId:studentId,
			userId: $this.getCurrentlyLoggedInUser().id
		};
		$this.resetPageSetting(grid.getStore(), grid);
		grid.getStore().load();
		grid.getSelectionModel().deselectAll();
		grid.getStore().pageSize = 100;
	},
	
	updateViewCalendarTitle: function(p, vw, dateInfo){
		var this$ = this;
		var personProfile = this$.getContentPanelActiveTab();
		var viewCalendarForm = personProfile.down('#studentScheduleDetails');
		var startDt= new Date(),endDt= new Date();      
		if(dateInfo){
			startDt = dateInfo.viewStart;
			endDt =dateInfo.viewEnd;
		}
		var p = viewCalendarForm.down('#app-center'),//Ext.getCmp('app-center'),
		fmt = Ext.Date.format;

		if(Ext.Date.clearTime(startDt).getTime() == Ext.Date.clearTime(endDt).getTime()){
			p.setTitle(fmt(startDt, 'F j, Y'));
		}
		else if(startDt.getFullYear() == endDt.getFullYear()){
			if(startDt.getMonth() == endDt.getMonth()){
				p.setTitle(fmt(startDt, 'F j') + ' - ' + fmt(endDt, 'j, Y'));
			}
			else{
				p.setTitle(fmt(startDt, 'F j') + ' - ' + fmt(endDt, 'F j, Y'));
			}
		}
		else{
			p.setTitle(fmt(startDt, 'F j, Y') + ' - ' + fmt(endDt, 'F j, Y'));
		}
	},
	showHidePerformanceTrackerDetails: function(combo, records) {
		var selectedItem = combo.getValue();
		if (selectedItem === 'ACADEMIC') {
			this.getPerformanceTrackerForm().down('#studentProgramCombo').show();
			this.getPerformanceTrackerForm().down('#studentPerformanceSnapshot').show();
			this.getPerformanceTrackerForm().down('#studentEvaluationResults').show();
			this.getPerformanceTrackerForm().down('#studentEvaluationSummary').show();
		} else {
			this.getPerformanceTrackerForm().down('#studentProgramCombo').hide();
			this.getPerformanceTrackerForm().down('#studentPerformanceSnapshot').hide();
			this.getPerformanceTrackerForm().down('#studentEvaluationResults').hide();
			this.getPerformanceTrackerForm().down('#studentEvaluationSummary').hide();
		}

	},

	/**
	 * This is used to remove Section combo 
	 */
	/* hideSection : function(formRef){

    	var cmb = formRef.down('#section');
    	cmb.setVisible(false);
    	cmb.setDisabled(true);
    },*/
	/**
	 * Method to load the next combo based on the selection of
	 * the previous combo value.
	 * 
	 * @param {Object}
	 *            dependentCombo is the reference of the next
	 *            dropdown which should be populated with
	 *            values.
	 * @param {Object}
	 *            selectedRecord is the record of the previous
	 *            dropdown which is selected.
	 * @param {Object}
	 *            parameter is the value that should be attached
	 *            in the url.
	 * @param {Object}
	 *            extraParameter (optional) If there is any
	 *            extra parameter to be sent for loading the
	 *            dependent dropdown.
	 * @param {Object}
	 *            extraParamValue (optional) The value of the
	 *            extraParam that is sent for loading the store.
	 */
	loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
		var this$ = this;
		this$.resetOtherFormDropdowns(dependentCombo);
		dependentCombo.clearValue();
		dependentCombo.store.removeAll();
		var store = dependentCombo.getStore();
		var id = comboValue;
		if (!isNullOrEmpty(id)) {
			var url = store.getProxy().proxyConfig.api.read;
			if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
				url = url.concat('?' + parameter + '=' + id);
			} else {
				url = url.concat('?' + parameter + '=' + id);
				url = url.concat('&' + extraParameter + '=' + extraParamValue);
			}
			store.getProxy().api.read = url;
			store.reload();
		}
	},

	loadAcademicTopicDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
		var this$ = this;
		dependentCombo.clearValue();
		dependentCombo.store.removeAll();
		dependentCombo.reset();
		var store = dependentCombo.getStore();
		var id = comboValue;
		if (id!=null) {
			var url = store.getProxy().proxyConfig.api.read;
			if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
				url = url.concat('?' + parameter + '=' + id);
			} else {
				url = url.concat('?' + parameter + '=' + id);
				url = url.concat('&' + extraParameter + '=' + extraParamValue);
			}
			store.getProxy().api.read = url;
			store.load();
		}
	},

	getAcademicTopicIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
	},
	/**
	 * code to reset other dropdowns based on the selection of
	 * any dropdown which is previous in the hierarchy. eg: if
	 * all the dropdowns are loaded and the Academy is changed
	 * then subsequent dropdowns should be changed accordingly,
	 * so their value is cleared and reset and reloaded.
	 * 
	 * @param: {Object} combo The reference of the dropdown
	 *         which is the dependent/next combo.
	 */
	resetOtherFormDropdowns: function(combo) {
		var container = combo.up('attendancequicksearchform');
		switch (combo.name) {
		case 'programId':
			this.clearComboField(combo);
			periodCombo = container.down('combo[name=period]');
			this.clearComboField(periodCombo);
			break;
		case 'period':
			this.clearComboField(combo);
			courseCombo = container.down('combo[name=course]');
			this.clearComboField(courseCombo);
			break;
		case 'course':
			this.clearComboField(combo);
			courseComponentCombo = container.down('combo[name=courseComponent]');
			this.clearComboField(courseComponentCombo);
			break;
		case 'courseComponent':
			this.clearComboField(combo);
			break;
		}
	},

	resetAcademicTopicFormDropdowns: function() {
		var form=this.getAcademicstopicquicksearchform().getForm();
		var programIdField=form.findField('programId');
		programIdField.reset();
		var academicTopicIdField=form.findField('academicTopicId');
		academicTopicIdField.reset();
		var batchIdField=form.findField('batch');
		batchIdField.reset();
		batchIdField.setDisabled(true);
		var periodIdField=form.findField('period');
		periodIdField.reset();
		periodIdField.setDisabled(true);
		var academicSubTopicIdField=form.findField('academicSubTopicId');
		academicSubTopicIdField.reset();
		academicSubTopicIdField.setDisabled(true);
	},

	/**
	 * function to clear the combo store, clear its existing
	 * value and remove all the records from the store.
	 * 
	 * @param {Object}
	 *            the reference of the combo whose store should
	 *            be cleared.
	 */
	clearComboField: function(combo) {
		combo.clearValue();
		combo.store.removeAll();
	},
	/**
	 * View attendance details
	 * @param gridItemId
	 * @param formItemId
	 */
	viewDetails: function(gridItemId, formItemId) {

		var this$ = this;
		var personProfile = this$.getContentPanelActiveTab();
		var grid = personProfile.down(gridItemId);
		var form = personProfile.down(formItemId);

		if (grid.getSelectionModel().getCount() > 0) {

			var records = grid.getSelectionModel().getSelection();
			var courseName = records[0].data.courseName;

			var formWindow = this$.getStudentwisedetaildata();
			if (!formWindow) {
				Ext.widget('studentwisedetaildata');
				formWindow = this$.getStudentwisedetaildata();
			}
			formWindow.show();

			var values = form.getValues();
			var store = form.down('#attendanceProgram').getStore();
			var record = store.findRecord('programId', values.programId);
			var admissionId = record.get('admissionId');
			var periodId = values.period;
			var courseId = values.course;
			var componentId = values.courseComponent;
			var startDate = values.fromDate;
			var endDate = values.toDate;


			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.STUDENT_ATTENDANCE_DETAIL_DATA,
				params: {
					admissionId: admissionId,
					periodId: periodId,
					courseId: courseId,
					componentId: componentId,
					startDate: startDate,
					endDate: endDate
				},
				method: 'GET',
				success: function(form, action) {
					var data = Ext.JSON.decode(form.responseText);

					var stdForm = this$.getStudentwiseDetaildata().getForm();

					stdForm.findField('courseName').setValue(courseName);
					stdForm.findField('planned').setValue(data.planned);
					stdForm.findField('conducted').setValue(data.conducted);
					stdForm.findField('attended').setValue(data.attended);
					stdForm.findField('notAttended').setValue(data.notAttended);

					var studentDetailStore = this$.getStore('personinfo.common.course.StudentWiseDetails');
					studentDetailStore.getProxy().extraParams = {
						admissionId: admissionId,
						periodId: periodId,
						courseId: courseId,
						componentId: componentId,
						startDate: startDate,
						endDate: endDate
					},
					studentDetailStore.load();

				}
			});


		} else {
			showWarningMessage(getPersonModuleTranslation('ATTENDANCE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},

	/**
	 * Add dynamic download all buttons in student period listing.
	 */
	gridRenderFunctionForStudentPeriod:function(grid){
		var butonstoolbar=grid.down('#functionButtonsToolbar');
		butonstoolbar.items.items[2].setVisible(false);
		butonstoolbar.items.items[2].hidden = true;
		butonstoolbar.insert(5,{
			xtype: 'button',
			itemId: 'downloadAllButtonItemId',
			disabled:true,
			hidden: true,
			text:getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET'),
			tooltip :getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET')
		}); 
		butonstoolbar.insert(6,{
			xtype: 'button',
			itemId: 'downloadUnofficialTranscriptItemId',
			disabled:true,
			hidden: true, 
			text:getExaminationTranslation('DOWNLOAD_UNOFFICIAL_TRANSCRIPT'),
			tooltip :getExaminationTranslation('DOWNLOAD_UNOFFICIAL_TRANSCRIPT')
		});
	},


	/**
	 * Load My course data
	 */
	loadMyCourseGridData : function(obj) {
		var $this = this;
		var form = obj.up('form');
		var jsonFormatFormData = this.createJsonFormat(form);
		var grid= this.getStudentcoursereportgrid();//obj.down('studentcoursereportgrid');
		var alinfomodel = Academia.model.authentication.ALInfoModel;
    	var wheatherSchool = alinfomodel.get('wheatherSchool');
		var searchResultGrid = grid;
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		
		var activetabInfo = this.getContentPanelActiveTab();
		var myCourseStructure = activetabInfo.down('mycoursedetails');
		var grid = myCourseStructure.down('#studentMyCourseSearchResultGrid');
		var myCourseDetailStructure = myCourseStructure.down('#mycoursedetailsstructureId');
		var nonCbCourseGrid = myCourseDetailStructure.getActiveTab().down('studentcoursereportgrid');
		var nonCbPeriodGrid = myCourseStructure.down('studentcoursereportbyperiodgrid');
		 var studentALField = form.down("#studentAcademyLocation");
		   var studentProgramField = form.down("#attendanceProgram");
		   var academyLocationId=studentALField.getValue();
		if(nonCbCourseGrid && nonCbCourseGrid.getStore().data.length === 0){
			nonCbCourseGrid.down('#requestExamCancellationButtonId').setVisible(false);
		}

		$this.getStuLearningTargetGradeGridItemId().hide();
		$this.getStuLearningTargetMarkGridItemId().hide();
		var courseType = form.down('#coruseTypeId').getValue();
		var formValues=form.getForm().getValues();
		var personProfile = $this.getContentPanelActiveTab();
		var admissionId= null;
		var userId = personProfile.getUserId();
		admissionId = personProfile.admissionId;
		if(portalId == 3 || portalId == 7) {
			var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
			var studentprogramId = studentPortalInfo.admissionDetails[0].program.id;
			var studentbatchId = studentPortalInfo.admissionDetails[0].batch.id;

			admissionId = studentPortalInfo.admissionDetails[0].id;
		}
		if(portalId==2){
			var personProfile = this.getContentPanelActiveTab();
			userId = personProfile.userId;
		}
		var courseStructure = this.getMycoursedetailsstructure();
		var activeTab = courseStructure.getActiveTab();
		var showCourseIncludingWithdrawn=form.down("#showCourseIncludingWithdrawn").getValue();
		if(courseType.courseWise && activeTab.itemId=='mycoursedetailspassId'){
			nonCbCourseGrid.getStore().getProxy().extraParams={
				studentId:userId,
				programId:formValues.programId,
				batchId:formValues.batch,
				periodId:formValues.period,
				whetherPassed:true,
				wheatherSchool:wheatherSchool,
				portalId:portalId,
				academyLocationId:academyLocationId
			};
			nonCbCourseGrid.getStore().load();
			var midtermGradeMarksColumns = nonCbCourseGrid.columns[7];
			midtermGradeMarksColumns.editor=null;
		} else if(courseType.courseWise && activeTab.itemId=='mycoursedetailsfailId'){
			nonCbCourseGrid.getStore().getProxy().extraParams={
				studentId:userId,
				programId:formValues.programId,
				batchId:formValues.batch,
				periodId:formValues.period,
				whetherPassed:false,
				wheatherSchool:wheatherSchool,
				portalId:portalId,
				academyLocationId:academyLocationId
			};
			nonCbCourseGrid.getStore().load();
			var midtermGradeMarksColumns = nonCbCourseGrid.columns[7];
			midtermGradeMarksColumns.editor=null;
		}else if(courseType.courseWise && activeTab.itemId=='mycoursedetailsallId'){
			nonCbCourseGrid.getStore().getProxy().extraParams={
				studentId:userId,
				programId:formValues.programId,
				batchId:formValues.batch,
				periodId:formValues.period,
				wheatherSchool:wheatherSchool,
				portalId:portalId,
				academyLocationId:academyLocationId,
				showCourseIncludingWithdrawn:showCourseIncludingWithdrawn
				
			};
			nonCbCourseGrid.getStore().load({
				callback: function(records, operation, success) {
					var today = Ext.Date.format(new Date(), 'Y-m-d');
					if(records.length){
						var examCancelEndDate = records[0].data.examCancellationApplicableTillDate != null ? 
								Ext.Date.format(new Date(records[0].data.examCancellationApplicableTillDate), 'Y-m-d') : null;
						var isProgramBatchMapped = records[0].data.isProgramBatchMapped;
					}
					else{
						var examCancelEndDate = null;
						var isProgramBatchMapped = null;
					}
					var showExamCancellationMessage = nonCbCourseGrid.down('#showExamCancellationMessageId');
					if(portalId != 2 && isProgramBatchMapped && !isNullOrEmpty(examCancelEndDate) && examCancelEndDate >= today){
						nonCbCourseGrid.down('#requestExamCancellationButtonId').setVisible(true);
						showExamCancellationMessage.setVisible(false);
					} else if(portalId != 2 && isProgramBatchMapped && examCancelEndDate != null && today > examCancelEndDate){
						showExamCancellationMessage.setValue(getCommonTranslation('EXAM_CANCELLATION_REQUEST_PROCESS_HAS_BEEN_EXPIRED_ON')+" "
								+ dateRender(records[0].data.examCancellationApplicableTillDate));
						showExamCancellationMessage.setVisible(true);
						nonCbCourseGrid.down('#requestExamCancellationButtonId').setVisible(false);
					} else{
						nonCbCourseGrid.down('#requestExamCancellationButtonId').setVisible(false);
						showExamCancellationMessage.setVisible(false);
						if(portalId == 3 || portalId == 7) {
							nonCbCourseGrid.down('#btnSaveItemId').setVisible(false);
							var midtermGradeMarksColumns = nonCbCourseGrid.columns[7];
			                midtermGradeMarksColumns.editor=null;
						}
					}
				}
			});;
		}else if(courseType.courseWise && activeTab.itemId=='vwmycoursedetailslearningtargetsItemId'){
			$this.getVwmycoursedetailslearningtargets().down('#stuStudentCommentsItemId').reset();
			$this.getVwmycoursedetailslearningtargets().down('#stuFacultyCommentsItemId').reset();
			$this.getVwmycoursedetailslearningtargets().down('#stuLearningNextReviewDateItemId').reset();
			$this.getVwmycoursedetailslearningtargets().down('#stuLearningReviewDateItemId').reset();
			if(admissionId==undefined){
				var personProfileValue=this.getStudentDetailForErpPortal();
	    		var admissionId =personProfileValue.admissionDetails[0].id
			}
			$this.getStuLearningTargetGradeGridItemId().getStore().getProxy().extraParams={
				admissionId:admissionId,
				studentId:userId,
				programId:formValues.programId,
				batchId:formValues.batch,
				periodId:formValues.period,
				sort:null,
				academyLocationId:academyLocationId
				//wheatherSchool:wheatherSchool,
				//portalId:portalId
			};
			$this.getStuLearningTargetGradeGridItemId().getStore().load({
				callback : function(records, operation, success) {
					if (success) {
					if(records.length>0){
						var detailTab=$this.getVwmycoursedetailslearningtargets();
						if(!isNullOrEmpty(records[0].data.reviewDate)){
							detailTab.down('#stuLearningReviewDateItemId').setValue(dateRender(records[0].data.reviewDate));
						} else {
							detailTab.down('#stuLearningReviewDateItemId').setValue(dateRender(new Date()));
						}
						if(records[0].data.nextReviewDate!=null){
							detailTab.down('#stuLearningNextReviewDateItemId').setValue(dateRender(records[0].data.nextReviewDate));
						}
						if(records[0].data.facultyComment!=null){
							detailTab.down('#stuFacultyCommentsItemId').setValue(records[0].data.facultyComment);	
						}
						if(records[0].data.studentComment!=null){
							detailTab.down('#stuStudentCommentsItemId').setValue(records[0].data.studentComment);
						}
						
						var gradeMarkTargetCombo = $this.getStuLearningTargetGradeGridItemId().columns[3].getEditor();
						gradeMarkTargetCombo.getStore().getProxy().extraParams={
							gradeType:records[0].data.courseGradeType,
							courseCutOff:records[0].data.courseCutOff,
							courseMaxMark:records[0].data.courseMaxMark,
						};
						gradeMarkTargetCombo.getStore().load();
						if(!isNullOrEmpty(records[0].data.courseType) && records[0].data.courseType=="G"){
							$this.getStuLearningTargetGradeGridItemId().show();
							$this.getStuLearningTargetMarkGridItemId().hide();
						} else {
							$this.getStuLearningTargetGradeGridItemId().hide();
							$this.getStuLearningTargetMarkGridItemId().show();
						}
						if(portalId == 3 || portalId == 7) {
							detailTab.down('#stuLearningReviewDateItemId').setReadOnly(true);
							detailTab.down('#stuLearningNextReviewDateItemId').setReadOnly(true);
							detailTab.down('#stuFacultyCommentsItemId').setReadOnly(true);
							
							$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[1].getEditor().setReadOnly(true);
							$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[1].getEditor().setReadOnly(true);
							$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[2].getEditor().setReadOnly(true);
							$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[2].getEditor().setReadOnly(true);
							
							$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[3].getEditor().setReadOnly(true);
							$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[3].getEditor().setReadOnly(true);
							$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[5].getEditor().setReadOnly(true);
							$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[5].getEditor().setReadOnly(true);
						} 
					}
					}
				}
			});
		} else {
			nonCbPeriodGrid.getStore().getProxy().extraParams={
				studentId:userId,
				/* comment for V2D-98496 bug */
/*				admissionId:admissionId,*/
				programId:formValues.programId,
				batchId:formValues.batch,
				periodId:formValues.period,
				resultStatus:formValues.courseCompletionStatus,
				wheatherSchool:wheatherSchool,
				portalId:portalId,
				academyLocationId:academyLocationId
			};
			nonCbPeriodGrid.getStore().load({
				callback : function(records, operation, success) {
					if (success) {
						if(!isNullOrEmpty(records) && records.length > 0) {
							var length=records.length;
							for(var i=0;i<length;i++)
							{
								if(!isNullOrEmpty(records[i].data.marksheetPath)) {
									nonCbPeriodGrid.down('#downloadUnofficialTranscriptItemId').setDisabled(false);
								}
							}
						}
						else{
							nonCbPeriodGrid.down('#downloadUnofficialTranscriptItemId').setDisabled(true);
						}
					}
				}
			});
			
		}

		var courseType = form.down('#coruseTypeId').getValue();
		var downloadButton;
		if(grid.isVisible()) {
			var btnToolBar = grid.down('#functionButtonsToolbar');
			downloadButton = btnToolBar.query('#downloadAllButtonItemId')[0];
		} else {
			downloadButton = grid.nextSibling().nextSibling().down('#downloadAllButtonItemId');
		}

		if(courseType.courseWise){
			downloadButton.setVisible(false);

		}else{
			if(nonCbPeriodGrid!=undefined)
			{
				if(portalId==7){
					this.disableDownloadMarsheetPivileges(nonCbPeriodGrid,this.getPARENT_COURSE_MASTER_PERMISSIONS());
				}else if(portalId == 2){
					this.disableDownloadMarsheetPivileges(nonCbPeriodGrid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
				}else if(portalId == 3){
					this.disableDownloadMarsheetPivileges(nonCbPeriodGrid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
				}else{
					this.disableDownloadMarsheetPivileges(nonCbPeriodGrid,this.getCOURSE_MASTER_PERMISSIONS());	
				}
			}else
			{
				if(portalId==7){
					this.disableDownloadMarsheetPivileges(grid,this.getPARENT_COURSE_MASTER_PERMISSIONS());
				}else if(portalId == 2){
					this.disableDownloadMarsheetPivileges(grid, this.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
				}else if(portalId == 3){
					this.disableDownloadMarsheetPivileges(grid, this.getSTUDENT_PORTAL_COURSE_MASTER_PERMISSIONS());
				}else{
					this.disableDownloadMarsheetPivileges(grid,this.getCOURSE_MASTER_PERMISSIONS());	
				}
				
			}	
		}
	},

	/**
	 * Download all Marksheet generation
	 */
	downloadAllMarksheetZip:function() {
		var $this=this;
		var searchResultGrid=$this.getStudentMyCourseSearchResultGrid();	
		if(searchResultGrid.isVisible()) {
			searchResultGrid=searchResultGrid
		} else {
			searchResultGrid = $this.getStudentcoursereportbyperiodgrid();
		}
		var saveModel=[];  
		var jsonData;
		var marksheetZipName = 'Student_Marksheet';
		var directoryType = CONSTANTS.DIRECTORY_TYPE_MARKSHEET;

		var store = searchResultGrid.getStore();
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		store.load({
			callback : function(records, operation, success) {
				if (success) {
					Ext.getBody().unmask();
					for(var i in records){
						if(!isNullOrEmpty(records[i].data.MARKSHEET_PATH)) {
							   var filePath = window.btoa(unescape(encodeURIComponent(records[i].data.MARKSHEET_PATH)));
							   saveModel.push(filePath);
						}
						if(!isNullOrEmpty(records[i].data.marksheetPath)) {
							   var filePath = window.btoa(unescape(encodeURIComponent(records[i].data.marksheetPath)));
							   saveModel.push(filePath);
						}
					}
					$this.getDocumentController().downloadMultipleDocumentFile(saveModel, marksheetZipName, directoryType);
				}
			}
		});
	},
	downloadUnofficialTranscript:function() {
		var $this=this;
    	var activetabInfo = $this.getContentPanelActiveTab();
    	var structure = activetabInfo.down('mycoursedetails');
    	var form = structure.down('#studentMyCourseQuickSearchForm');
    	var grid=$this.getStudentcoursereportbyperiodgrid();
    	var store=grid.getStore();
    	if(store.data.items != isNullOrEmpty && store.data.items.length>0)
    		{
    		 var BATCH_NAME = store.data.items[0].data.batchName;
    		 var PROGRAM_NAME=store.data.items[0].data.programName;
    		}
		var searchResultGrid=$this.getStudentMyCourseSearchResultGrid();	
		var personProfile = $this.getContentPanelActiveTab();
		var admissionId= null;
		var userId = personProfile.getUserId();
		admissionId = personProfile.admissionId;
		userId = personProfile.userId;
		var STUDENT_NAME = personProfile.personInfo.printName;
		var values = form.getValues();
		var saveModel=[];  
		var jsonData;
		var code='AU_UNOFFICIAL_TRANSCRIPT';
		var reportParams =new Object();
		   reportParams.code =code;
		   reportParams.reportTitle = 'AU_UNOFFICIAL_TRANSCRIPT';
		   reportParams.programIds = values.programId;
		   reportParams.BATCH_ID = values.batch;	
		   reportParams.ADMISSION_ID = admissionId;
		   reportParams.STUDENT_ID = userId;
		   reportParams.PERIOD_IDS = values.period;
		   reportParams.academyLocationId = $this.getCurrentAcademyLocation();
		   reportParams.BATCH_NAME=BATCH_NAME;
		   reportParams.PROGRAM_NAME=PROGRAM_NAME;
		   reportParams.STUDENT_NAME=STUDENT_NAME;
		   //reportParams.sectionIds=sections.join(),
		   $this.exportJRXMLReport(code,reportParams,reportParams.reportTitle,'.pdf',"rest/markSheet/generateTranscipt");

	/*	var store = searchResultGrid.getStore();
		store.load({
			callback : function(records, operation, success) {
				
			}
		});*/
	},
	
	
	enableDisableDownloadBtn : function(courseType) {

		var btnToolBar = grid.down('#functionButtonsToolbar');
		var downloadButton = btnToolBar.query('#downloadAllButtonItemId')[0];

		if(!courseType){

			var searchResultGrid = this.getStudentMyCourseSearchResultGrid();
			var storedata = searchResultGrid.getStore().getRange();
		}
	},

	createJsonFormat:function(quickSearchForm){			
		var formValues=quickSearchForm.getForm().getValues();
		var programId = quickSearchForm.down('#attendanceProgram');
		var batchId = quickSearchForm.down('#batchCombo');
		var periodId = quickSearchForm.down('#period');
		var sectionId = quickSearchForm.down('#sectionId');
		var courseCompletionStatus = quickSearchForm.down('#courseCompletionStatusItemId');

		var personProfile = this.getContentPanelActiveTab();
		var userId = personProfile.getUserId();

		var portalId = this.getCurrentLoggedPortalId();
		var admissionId = null;
		if(portalId == 3 || portalId == 7) {

			var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
			var studentprogramId = studentPortalInfo.programBatchDetails.programId;
			var studentbatchId = studentPortalInfo.programBatchDetails.batchId;

			admissionId = studentPortalInfo.admissionDetails[0].id;
		} else {
			/*var store = programId.getStore();
        	 store.getProxy().extraParams={
             	studentId: userId
             },
             store.load({
					   callback : function(records, operation, success) {
						   if (success) {
							   var record = store.findRecord('programId', programId.getValue());
					        	admissionId = record.get('admissionId');
						   }
					   }
				   });*/
			admissionId = personProfile.admissionId;

		}

		var values = new Object();

		var courseType = quickSearchForm.down('#coruseTypeId').getValue();
		if(courseType.courseWise){
			values.configCode = CONSTANTS.CB.MY_COURSES_LISTING_CONFIGCODE;
		}else{
			values.configCode = CONSTANTS.CB.STUDENT_PERIOD_REPORT_CONFIGCODE;	
		}


		var searchcriteria = new Array();
		if(!isNullOrEmpty(programId.getValue())){
			searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
		}
		if(!isNullOrEmpty(batchId.getValue())){
			searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId.getValue()]});
		}
		if(!isNullOrEmpty(periodId.getValue())){
			searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
		}
		if(courseType.courseWise && (!isNullOrEmpty(userId))){
			searchcriteria.push({paramCode:"STUDENT_ID", paramValues:[userId]});
		}else if(!isNullOrEmpty(admissionId)){
			searchcriteria.push({paramCode:"ADMISSION_ID", paramValues:[admissionId]});
		}
		/**
		 *
		 */

		if(!isNullOrEmpty(sectionId.getValue())){
			searchcriteria.push({paramCode:"SECTION_ID", paramValues:[sectionId.getValue()]});
		}
		if(!isNullOrEmpty(courseCompletionStatus.getValue())){
			searchcriteria.push({paramCode:"RESULT_STATUS", paramValues:[courseCompletionStatus.getValue()]});
		}
		values.searchCriterias=searchcriteria;
		return values;
	},
//	*********************Export Function******************************
	exportUserList : function(exportUrl,filetype,whetherAll) {
		var quickSearchForm=this.getMycoursedetails(); 
		var searchResultGrid = this.getStudentMyCourseSearchResultGrid();
		var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
		var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
		var visibleColumns=this.getVisibleColumns(searchResultGrid);
		var reportTitle=getCommonTranslation('COURSE_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		}
		searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

	},

	createSearchCriteriaString: function(searchForm) {
		var me=this;
		var formValues = new Array();
		formValues = searchForm.getValues();        
		var searchCriteriaString="";
		for (var key in formValues) {
			var value = formValues[key];            
			if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
				//  var keyValueJsonObject = me.getJsonObject( key , value);
				//searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
			}
		}
		searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
		return searchCriteriaString;
	},
	changeCourseTypeReport:function(obj){
		//var $this = this;
		var me = this;
		var form = obj.up('form');
		var courseType = form.down('#coruseTypeId').getValue();
		if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
			studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		} else {
			studentPortalInfo = this.getStudentDetailForErpPortal();
		}
		
		var periodField = form.down('#period');
		var type = obj.getValue();
		if(type.courseWise == true){
			periodField.courseWise = true;
			var periodFieldStore = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		}
		else{
			periodField.courseWise = false;
			var periodFieldStore = Ext.create('Academia.store.student.studentprofile.StudentProgramStore');
		}
		periodField.bindStore(periodFieldStore);
		
		var sectionField = form.down('#sectionId');
		var courseCompletionStatusField = form.down('#courseCompletionStatusItemId');
		//var structure = obj.up().up().up();
		var activetabInfo = this.getContentPanelActiveTab();
		//var structure = this.getMycoursedetails();
		var structure = activetabInfo.down('mycoursedetails');
		//var courseGrid = structure.down('#courseReport');
		var periodGrid = structure.down('#periodReport');
		
		//var courseStructure = this.getMycoursedetailsstructure();
		 var courseStructure =structure.down('mycoursedetailsstructure');
		 var showCourseIncludingWithdrawn = form.down('#showCourseIncludingWithdrawn');
		Ext.suspendLayouts();
		if(courseType.courseWise){ 
			sectionField.setVisible(false);
			courseCompletionStatusField.setVisible(false);
			//courseGrid.setVisible(true);
			periodGrid.setVisible(false);
			courseStructure.setVisible(true);
			showCourseIncludingWithdrawn.setVisible(true);
		}else{
			sectionField.setVisible(true);
			courseCompletionStatusField.setVisible(true);
			//courseGrid.setVisible(false);
			courseStructure.setVisible(false);
			periodGrid.setVisible(true);
			showCourseIncludingWithdrawn.setVisible(false);
			
		}
		Ext.resumeLayouts();
		var academyLocationId = this.getCurrentAcademyLocation();
		if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
		var studentId = studentPortalInfo.student.id;
		var programId = studentPortalInfo.programBatchDetails.programId;
		var batchId = studentPortalInfo.programBatchDetails.batchId;
		var periodId = studentPortalInfo.programBatchDetails.periodId;
		var sectionId = studentPortalInfo.programBatchDetails.sectionId;
		}else{
		var studentId = form.down('#studentHiddenId').getValue();
		var programId = form.down('#programHiddenId').getValue();
		var batchId = form.down('#batchHiddenId').getValue();
		var periodId = form.down('#periodHiddenId').getValue();
		var sectionId = form.down('#sectionHiddenId').getValue();
		}
		if(this.getCurrentLoggedPortalId()==2){
			var personProfile = this.getContentPanelActiveTab();
			studentId = personProfile.userId;
		}
		this.setPreFilledValues(academyLocationId, studentId, programId, batchId, periodId, sectionId);
		/*setTimeout(function(){
			me.loadMyCourseGridData(obj);
		},1000);*/
	},
	resetStudentForm:function(obj){
		var form = obj.up('form');
		
		var courseType = form.down('#coruseTypeId').getValue();
		if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
			studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		} else {
			studentPortalInfo = this.getStudentDetailForErpPortal();
		}
		if(courseType.courseWise){ 
			var form = obj.up('form').getForm();
			form.findField('programId').reset();
			form.findField('batch').reset();
			form.findField('period').reset();
			form.findField('section').reset();
			form.findField('courseCompletionStatus').reset();
			var academyLocationId = this.getCurrentAcademyLocation();
			var studentId = studentPortalInfo.student.id;
			var programId = studentPortalInfo.programBatchDetails.programId;
			var batchId = studentPortalInfo.programBatchDetails.batchId;
			var periodId = studentPortalInfo.programBatchDetails.periodId;
			var sectionId = studentPortalInfo.programBatchDetails.sectionId;
			if(this.getCurrentLoggedPortalId()==2){
				var personProfile = this.getContentPanelActiveTab();
				studentId = personProfile.userId;
			}
			this.setPreFilledValues(academyLocationId, studentId, programId, batchId, periodId, sectionId);
			
		
		}else{
			var grid = obj.up('mycoursedetails').down('studentcoursereportbyperiodgrid');
			var form = obj.up('form').getForm();
			form.findField('programId').reset();
			form.findField('batch').reset();
			form.findField('period').reset();
			form.findField('section').reset();
			form.findField('section').setDisabled(false);
			form.findField('courseCompletionStatus').reset();
			grid.getStore().removeAll();
			var academyLocationId = this.getCurrentAcademyLocation();
			var studentId = studentPortalInfo.student.id;
			var programId = studentPortalInfo.programBatchDetails.programId;
			var batchId = studentPortalInfo.programBatchDetails.batchId;
			var periodId = studentPortalInfo.programBatchDetails.periodId;
			/*var sectionId = studentPortalInfo.programBatchDetails.sectionId;*/
			if(this.getCurrentLoggedPortalId()==2){
				var personProfile = this.getContentPanelActiveTab();
				studentId = personProfile.userId;
			}
			this.onResetPreFilledValue(academyLocationId, studentId, programId, batchId, periodId);
			
		}
		
	}, 

	disableDownloadMarsheetPivileges: function(gridReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		//buttonsToolBar = gridReference.query('toolbar')[0];
		//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
		var dowloadMarksheetbutton = gridReference.down('#downloadAllButtonItemId');
		var downloadUnofficialTranscriptbutton =gridReference.down('#downloadUnofficialTranscriptItemId');
		dowloadMarksheetbutton.setVisible(false);
		downloadUnofficialTranscriptbutton.setVisible(false);
		/*Ext.each(splitbuttons.menu.items.items, function(menuItems) {
	    		menuItems.setVisible(false);
	    	});*/
		var portalId = this.getCurrentLoggedPortalId();
		var form = this.getMyCourseQuickSearchForm();
		var coruseTypeId = form.down('#coruseTypeId');
		/*if(portalId == 3 || portalId == 7) {
			coruseTypeId.setVisible(false);
		}*/
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'DOWNLOADMARKSHEETS') {
				//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
				if(!isNullOrEmpty(dowloadMarksheetbutton)){
					//dowloadMarksheetbutton.setVisible(true);
				}        		
			}
			if (privilege === 'DOWNLOADUNOFFICIALTRANSCRIPT') {
				//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
				if(!isNullOrEmpty(downloadUnofficialTranscriptbutton)){
					downloadUnofficialTranscriptbutton.setVisible(true);
				}   
				
			}
			/*if(privilege === 'COURSE_PERIOD_SELECTION'){
				if(portalId == 3 || portalId == 7 || portalId == 2) {
					coruseTypeId.setVisible(true);
				}
			}*/
		});
	},
	
	disableAcadmicHistoryPivileges: function(gridReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		buttonsToolBar = gridReference.query('toolbar')[0];
		var splitbuttons = buttonsToolBar.query('splitbutton')[0];
		var printTranscriptButton = gridReference.down('#btnPrintTranscriptItemId');
		//var downloadUnofficialTranscriptbutton =gridReference.down('#downloadUnofficialTranscriptItemId');
		printTranscriptButton.setVisible(false);
		 var printTranscriptButtonExcel = gridReference.down('#btnPrintTranscriptInExcelItemId');
	     printTranscriptButtonExcel.setVisible(false);
		//downloadUnofficialTranscriptbutton.setVisible(false);
		/*Ext.each(splitbuttons.menu.items.items, function(menuItems) {
	    		menuItems.setVisible(false);
	    	});*/
	
		var portalId = this.getCurrentLoggedPortalId();
		//var form = this.getMyCourseQuickSearchForm();
		//var coruseTypeId = form.down('#coruseTypeId');
		/*if(portalId == 3 || portalId == 7) {
			coruseTypeId.setVisible(false);
		}*/
		Ext.each(permissionList, function(privilege) {
			
			if (privilege === 'PRINT_TRANSCRIPT') {
				//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
				if(!isNullOrEmpty(printTranscriptButton)){
					printTranscriptButton.setVisible(true);
				}   
				
			}
			if (privilege ==='PRINT_EXCEL_TRANSCRIPT'){
				if(!isNullOrEmpty( printTranscriptButtonExcel)){
					 printTranscriptButtonExcel.setVisible(true);
				} 
				
				
			}
			/*if(privilege === 'COURSE_PERIOD_SELECTION'){
				if(portalId == 3 || portalId == 7 || portalId == 2) {
					coruseTypeId.setVisible(true);
				}
			}*/
		});
	},
	getStudentAcademicHistoryWindow : function(grid,record){
		var $this=this;
		var studentAcademicsHistorygrid=$this.getContentPanelActiveTab().down('studentacademicshistorygrid');
		var records = studentAcademicsHistorygrid.getSelectionModel().getSelection();
		var frmWin = this.getStudentacademichistorywin();
		if(!frmWin){
			Ext.widget('studentacademichistorywin');
			frmWin = this.getStudentacademichistorywin();
		}
		frmWin.show();
		studentgradeObtainedGrid=frmWin.down('#studentAcademicHistoryDetailId');
		var store = studentgradeObtainedGrid.getStore();
		store.getProxy().extraParams = {
			admissionId: records[0].data.admissionId,
			programId: records[0].data.programId,
			batchId:records[0].data.batchId,
			periodId:records[0].data.periodId,
		};
		store.load({
			scope:$this,
			callback: function(rec,r){
				$this.loadStudentAcademicHistorydetails(rec);
			}
		});
	},
    
    loadStudentAcademicHistorydetails:function(rec,operation, success){
    	var $this=this;
    	var studentHistoryWin = this.getStudentacademichistorywin();
    	var formDetails=studentHistoryWin.down('#studentAcademicHistoryDetailFormId');
    	var detailsForm=formDetails.getForm();
    	detailsForm.findField('programName').setValue(rec[0].get('programName'));
    	detailsForm.findField('batchName').setValue(rec[0].get('batchName'));
    	detailsForm.findField('periodName').setValue(rec[0].get('periodName'));
    },
    doAccessPassFailTabControlValidation: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var passTab = gridReference.down('#mycoursedetailspassId');
    	passTabView = passTab.tab;
    	passTabView.hidden = true;
    	var failTab = gridReference.down('#mycoursedetailsfailId');
    	failTabView = failTab.tab;
    	failTabView.hidden = true;
    	
    	var learningTargetsTab = gridReference.down('#vwmycoursedetailslearningtargetsItemId');
    	learningTargetsTabView = learningTargetsTab.tab;
    	learningTargetsTabView.hidden = true;
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'PASS') {
    			if(!isNullOrEmpty(passTab)){
    				passTabView.hidden = false;
    			}        		
    		}
    		if (privilege === 'FAIL') {
    			if(!isNullOrEmpty(failTab)){
    				failTabView.hidden = false;
    			}        		
    		}
    		if (privilege === 'LEARNING_TARGETS') {
    			if(!isNullOrEmpty(learningTargetsTab)){
    				learningTargetsTabView.hidden = false;
    			}        		
    		}
    	});
    },
    setPreFilledValues:function(academyLocationId, studentId, programId, batchId, periodId, sectionId){
    	var $this=this;
    	var activetabInfo = $this.getContentPanelActiveTab();
    	var structure = activetabInfo.down('mycoursedetails');
    	var form = structure.down('#studentMyCourseQuickSearchForm');

    	var studentALField = form.down("#studentAcademyLocation");
    	var studentALStore = studentALField.getStore();

    	var portalId = this$.getCurrentLoggedPortalId();
    	var currentALId = this$.getCurrentAcademyLocation();
    	if(portalId==1|| portalId==2){
    		var studentPortalInfo = this.getStudentDetailForErpPortal();
    		var admissionDetails=studentPortalInfo.admissionDetails;
    	}else if(portalId==7){
    		var portalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    		var admissionDetails=portalInfo.admissionDetails;
    	} else {
    		var portalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    		var admissionDetails=portalInfo.admissionDetails;
    	}

    	var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();
    	studentALStore.getProxy().extraParams = {
    		admissionIds:admissionIds
    	};
    	
    	//var form =  this.getMyCourseQuickSearchForm();
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
    	var wheatherSchool = alinfomodel.get('wheatherSchool');
    	if(wheatherSchool) {
    		form.down('#period').setVisible(false);
    	} else {
    		form.down('#period').setVisible(true);
    	}
    	var programField = form.down('#attendanceProgram');
    	form.down('#attendanceProgram').clearValue();
    	form.down('#batchCombo').clearValue();
    	form.down('#period').clearValue();
    	form.down('#sectionId').clearValue();
    	
    	studentALStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(records.length > 0){
    					studentALField.setValue(currentALId);
    					if(portalId==7){
    						var portalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    						var user = portalInfo.student;
    					} else {
    						var user=this$.getCurrentlyLoggedInUser();
    					}

	  					programField.store.getProxy().extraParams={
	    		    		studentId: studentId,
	    		    		academyLocationId : currentALId,
	    		    		onlyCurrentRecord:false
	    		    	};
	  					
	  					programField.store.load({
	  			    		callback : function(records, operation, success) {
	  			    			if (success) {
	  			    				for(var i in records) {
	  			    					if(records[i].data.id == programId) {
	  			    						programField.setValue(records[i].data.id);
	  			    						var batchField = form.down('#batchCombo');
	  			    						batchField.store.getProxy().extraParams={
	  			    							studentId: studentId,
	  			    							programId : records[i].data.id,
	  			    							onlyCurrentRecord:false,
	  			    							//academyLocationId: currentALId
	  			    						},
	  			    						batchField.store.load({
	  			    							callback : function(records, operation, success) {
	  			    								if (success) {
	  			    									for(var i in records) {
	  			    										if(records[i].data.id == batchId) {
	  			    											batchField.setValue(records[i].data.id);
	  			    											var periodField = form.down('#period');
	  			    											var periodFieldStore=periodField.getStore();
	  			    											
	  			    											if(periodField.courseWise){
		  			    											periodFieldStore.getProxy().extraParams = {
		  			    												id: records[i].data.id
		  			    											};
	  			    											}
	  			    											else{
		  			    											periodFieldStore.getProxy().extraParams = {
		  			    												batchId: records[i].data.id,
		  			    												studentId: studentId,
		  			    												onlyCurrentRecord:false,
		  			    												//academyLocationId: currentALId
		  			    											};
	  			    											}
	  			    											
	  			    											periodFieldStore.load({
	  			    												callback : function(records, operation, success) {
	  			    													if (success) {
	  			    														for(var i in records) {
	  			    															if(records[i].data.id == periodId) {
	  			    																form.down('#period').setValue(records[i].get('id'));
	  			    																var sectionField = form.down('#sectionId');
	  			    																var sectionStore=sectionField.getStore();
	  			    																sectionStore.getProxy().extraParams = {
	  			    																	periodId: records[i].data.id,
	  			    																	studentId: studentId,
	  			    																	onlyCurrentRecord:false,
	  			    																	//academyLocationId: currentALId
	  			    																};
	  			    																sectionStore.load({
	  			    																	callback : function(records, operation, success) {
	  			    																		if (success) {
	  			    																			for(var i in records) {
	  			    																				if(records[i].data.id == sectionId) {
	  			    																					form.down('#sectionId').setValue(records[i].data.id);
	  			    																				}
	  			    																			}
	  			    																		}
	  			    																	}
	  			    																});   
	  			    																var obj = form.down('#attendanceSearchButtonId');
	  			    																$this.loadMyCourseGridData(obj);
	  			    															}
	  			    														}
	  			    													}
	  			    												}
	  			    											});
	  			    										} 
	  			    									}
	  			    								}
	  			    							}
	  			    						});
	  			    					}
	  			    				}
	  			    			}
	  			    		}
	  			    	});
    				}
    			}
    		}
    	});
    },
    onResetPreFilledValue :function(academyLocationId, studentId, programId, batchId, periodId){
    	var $this=this;
    	var form =  this.getMyCourseQuickSearchForm();
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
    	var wheatherSchool = alinfomodel.get('wheatherSchool');
    	var studentALField = form.down("#studentAcademyLocation");
    	var studentALStore = studentALField.getStore();
    	
    	if(wheatherSchool) {
    		form.down('#period').setVisible(false);
    	} else {
    		form.down('#period').setVisible(true);
    	}
    	var programField = form.down('#attendanceProgram');
    	form.down('#attendanceProgram').clearValue();
    	form.down('#batchCombo').clearValue();
    	form.down('#period').clearValue();
    	form.down('#sectionId').clearValue();
    	studentALField.clearValue();
    	

    	var portalId = this$.getCurrentLoggedPortalId();
    	var currentALId = this$.getCurrentAcademyLocation();
    	
    	if(portalId==1|| portalId==2){
    		var studentPortalInfo = this.getStudentDetailForErpPortal();
    		var admissionDetails=studentPortalInfo.admissionDetails;
    	}else if(portalId==7){
    		var portalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    		var admissionDetails=portalInfo.admissionDetails;
    	} else {
    		var portalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    		var admissionDetails=portalInfo.admissionDetails;
    	}

    	var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

    	studentALStore.getProxy().extraParams = {
    		admissionIds:admissionIds
    	};
    	
    	studentALStore.load({
    		callback: function(records, operation, success) {
    			if (success) {
    				if(records.length > 0){
    					studentALField.setValue(currentALId);
    					if(portalId==7){
    						var portalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    						var user = portalInfo.student;
    					} else {
    						var user=this$.getCurrentlyLoggedInUser();
    					}
    				    	
				    	programField.store.getProxy().extraParams={
				    		studentId: studentId,
				    		academyLocationId : academyLocationId,
				    		onlyCurrentRecord:false
				    	};
				    	
				    	programField.store.load({
				    		callback : function(records, operation, success) {
				    			if (success) {
				    				for(var i in records) {
				    					if(records[i].data.id == programId) {
				    						programField.setValue(records[i].data.id);
				    						var batchField = form.down('#batchCombo');
				    						batchField.store.getProxy().extraParams={
				    							studentId: studentId,
				    							programId : records[i].data.id,
				    							onlyCurrentRecord:false,
				    							//academyLocationId: currentALId
				    						},
				    						batchField.store.load({
				    							callback : function(records, operation, success) {
				    								if (success) {
				    									for(var i in records) {
				    										if(records[i].data.id == batchId) {
				    											batchField.setValue(records[i].data.id);
				    											var periodField = form.down('#period');
				    											var periodField=periodField.getStore();
				    											periodField.getProxy().extraParams = {
				    												batchId: records[i].data.id,
				    												studentId: studentId,
				    												onlyCurrentRecord:false,
				    												//academyLocationId: currentALId
				    											};
				    											periodField.load({
				    												callback : function(records, operation, success) {
				    													if (success) {
				    														for(var i in records) {
				    															if(records[i].data.id == periodId) {
				    																if(wheatherSchool) {
				    																	form.down('#period').setValue(records[i].get('id'));
				    																	form.down('#sectionId').setDisabled(false);
				    																}
				    																var sectionField = form.down('#sectionId');
				    																var sectionStore=sectionField.getStore();
				    																sectionStore.getProxy().extraParams = {
				    																	periodId: records[i].data.id,
				    																	studentId: studentId,
				    																	onlyCurrentRecord:false,
				    																	//academyLocationId: currentALId
				    																};
				    																sectionStore.load({
				    																	callback : function(records, operation, success) {
				    																		if (success) {
				    																			for(var i in records) {
				    																				if(records[i].data.id == sectionId) {
				    																					form.down('#sectionId').setValue(records[i].data.id);
				    																				}
				    																			}
				    																		}
				    																	}
				    																});   
				    																var obj = form.down('#attendanceSearchButtonId');
				    																$this.loadMyCourseGridData(obj);
				    															}
				    														}
				    													}
				    												}
				    											});
				    										} 
				    									}
				    								}
				    							}
				    						});
				    					}
				    				}
				    			}
				    		}
				    	});
    				}
    			}
    		}
    	});
    },
    onProgramSelection:function(studentId, programId){
    	var $this=this;
    	var activetabInfo = $this.getContentPanelActiveTab();
    	var structure = activetabInfo.down('mycoursedetails');
    	var form = structure.down('#studentMyCourseQuickSearchForm');
    	
    	var studentALField = form.down("#studentAcademyLocation");
    	var selectedALId = studentALField.getValue();
    	var currentALId = this$.getCurrentAcademyLocation();
    	
    	//var form =  this.getMyCourseQuickSearchForm();
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
    	var wheatherSchool = alinfomodel.get('wheatherSchool');
    	if(wheatherSchool) {
    		form.down('#period').setVisible(false);
    	} else {
    		form.down('#period').setVisible(true);
    	}
    	form.down('#batchCombo').clearValue();
    	form.down('#period').clearValue();
    	form.down('#sectionId').clearValue();
    	var batchField = form.down('#batchCombo');
    	batchField.store.getProxy().extraParams={
    		studentId: studentId,
    		programId : programId,
    		onlyCurrentRecord:false,
    		//academyLocationId: isNullOrEmpty(selectedALId) ? currentALId : selectedALId
    	},
    	batchField.store.load({
    		callback : function(records, operation, success) {
    			if (success) {
    				if(records.length == 1) {
    					batchField.setValue(records[0].data.id);
    					var periodField = form.down('#period');
    			        var periodFieldStore=periodField.getStore();

    			        if(periodField.courseWise){
    			            periodFieldStore.getProxy().extraParams = {
    			                id: records[0].data.id
    			            };
    			        }
    			        else{
    			            periodFieldStore.getProxy().extraParams = {
    			                batchId: records[0].data.id,
    			                studentId: studentId,
    			                onlyCurrentRecord:false,
    			            };
    			        }
    			        periodFieldStore.load({
    						callback : function(records, operation, success) {
    							if (success) {
    								if(records.length == 1) {
    									form.down('#period').setValue(records[0].get('id'));
    									var sectionField = form.down('#sectionId');
    									var sectionStore=sectionField.getStore();
    									sectionStore.getProxy().extraParams = {
    										periodId: records[0].data.id,
    										studentId: studentId,
    										onlyCurrentRecord:false,
    										//academyLocationId: isNullOrEmpty(selectedALId) ? currentALId : selectedALId
    									};
    									sectionStore.load({
    										callback : function(records, operation, success) {
    											if (success) {
    												if(records.length == 1) {
    													form.down('#sectionId').setValue(records[0].data.id);
    												}
    											}
    										}
    									});   
    									var obj = form.down('#attendanceSearchButtonId');
    									$this.loadMyCourseGridData(obj);
    								} else {
    									form.down('#period').setVisible(true);
    								}
    							}
    						}
    					});
    				} 
    			}
    		}
    	});
    },
    onBatchSelection:function(studentId, batchId){
    	var $this=this;
    	var activetabInfo = $this.getContentPanelActiveTab();
    	var structure = activetabInfo.down('mycoursedetails');
    	var form = structure.down('#studentMyCourseQuickSearchForm');
    	//var form =  this.getMyCourseQuickSearchForm();
    	var alinfomodel = Academia.model.authentication.ALInfoModel;
    	var wheatherSchool = alinfomodel.get('wheatherSchool');
    	if(wheatherSchool) {
    		form.down('#period').setVisible(false);
    	} else {
    		form.down('#period').setVisible(true);
    	}
    	form.down('#period').clearValue();
    	form.down('#sectionId').clearValue();
    	var periodField = form.down('#period');
        var periodFieldStore=periodField.getStore();

        if(periodField.courseWise){
            periodFieldStore.getProxy().extraParams = {
                id: batchId
            };
        }
        else{
            periodFieldStore.getProxy().extraParams = {
                batchId: batchId,
                studentId: studentId,
                onlyCurrentRecord:false,
            };
        }
        periodFieldStore.load({
    		callback : function(records, operation, success) {
    			if (success) {
    				if(records.length == 1) {
    					form.down('#period').setValue(records[0].get('id'));
    					var sectionField = form.down('#sectionId');
    					var sectionStore=sectionField.getStore();
    					sectionStore.getProxy().extraParams = {
    						periodId: records[0].data.id,
    						studentId: studentId,
    						onlyCurrentRecord:false
    					};
    					sectionStore.load({
    						callback : function(records, operation, success) {
    							if (success) {
    								if(records.length == 1) {
    									form.down('#sectionId').setValue(records[0].data.id);
    								}
    							}
    						}
    					});   
    					var obj = form.down('#attendanceSearchButtonId');
    					$this.loadMyCourseGridData(obj);
    				} else {
    					form.down('#period').setVisible(true);
    				}
    			}
    		}
    	});
    },
    onPeriodSelection:function(studentId, periodId){
    	var $this=this;
    	var activetabInfo = $this.getContentPanelActiveTab();
    	var structure = activetabInfo.down('mycoursedetails');
    	var form = structure.down('#studentMyCourseQuickSearchForm');
    	//var form =  this.getMyCourseQuickSearchForm();
    	form.down('#sectionId').clearValue();
    	var sectionField = form.down('#sectionId');
    	var sectionStore=sectionField.getStore();
    	sectionStore.getProxy().extraParams = {
    		periodId: periodId,
    		studentId: studentId,
    		onlyCurrentRecord:false
    	};
    	sectionStore.load({
    		callback : function(records, operation, success) {
    			if (success) {
    				form.down('#sectionId').setDisabled(false);
    				if(records.length == 1) {
    					form.down('#sectionId').setValue(records[0].data.id);
    				}
    			}
    		}
    	});   
    	var obj = form.down('#attendanceSearchButtonId');
    	$this.loadMyCourseGridData(obj);
    },
    auditReportProfileChartAndGridLoad: function() {
		var $this = this;
 	    var view = $this.getDegreeauditreportprofileview();
 	    if(this.getCurrentLoggedPortalId()==1|| this.getCurrentLoggedPortalId()==2){
			studentPortalInfo = this.getStudentDetailForErpPortal();
 	    } 
		var studentId = studentPortalInfo.student.id;
		var form = view.down('#degreeAuditReportSearchForm').getForm();
		var programField = form.findField('programId');
		var batchField = form.findField('batchId');
		var programId = programField.getValue();
		var batchId = batchField.getValue();
    	
		var degreeAuditReportGrid =view.down('#profileDegreeAuditReportGrid');
		var courseStatusBarChart = view.down('#degreeAuditReportCourseStatusForBarChart');
		var creditsStatusBarChart = view.down('#degreeAuditReportCreditsStatusForBarChart');
		var cgpaStatusBarChart = view.down('#degreeAuditReportCGPAStatusForBarChart');
		
		var courseStatusExportButton = view.down('#CourseStatusExtraBtns');
		var creditsStatusExportButton = view.down('#creditsStatusExtraBtns');
		var cgpaStatusExportButton = view.down('#cgpaStatusExtraBtns');
		
		
		courseStatusExportButton.setVisible(true);
		creditsStatusExportButton.setVisible(true);
		cgpaStatusExportButton.setVisible(true);
		
		$this.addExportToPngForDegreeReportStatistics(courseStatusExportButton.menu,courseStatusBarChart);
		$this.addExportToPngForDegreeReportStatistics(creditsStatusExportButton.menu,creditsStatusBarChart);
		$this.addExportToPngForDegreeReportStatistics(cgpaStatusExportButton.menu,cgpaStatusBarChart);

		courseStatusBarChart.store.getProxy().extraParams={
			studentId: studentId,
			programId : programField.getValue(),
			batchId: batchField.getValue()
    	}
		courseStatusBarChart.store.load();
		
		creditsStatusBarChart.store.getProxy().extraParams={
			studentId: studentId,
			programId : programField.getValue(),
			batchId: batchField.getValue()
    	}
		creditsStatusBarChart.store.load();
		
		cgpaStatusBarChart.store.getProxy().extraParams={
			studentId: studentId,
			programId : programField.getValue(),
			batchId: batchField.getValue()
    	}
		cgpaStatusBarChart.store.load();
		
		degreeAuditReportGrid.store.getProxy().extraParams={
			studentId: studentId,
			programId : programField.getValue(),
			batchId: batchField.getValue()
    	}
		degreeAuditReportGrid.store.load({
			callback : function(records, operation, success) {
				if (success) {
					var exportBtn=view.down('#exportDegreeAuditReportGrid');
					if(records.length <= 0) {
						exportBtn.setDisabled(true);
					}else{
                        exportBtn.setDisabled(false);
					} 
				}
			}
		});
    },
    auditReportProfileFormChartGridLoad: function(view) {
		var $this = this;
		var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
		var academyLocationId = this.getCurrentAcademyLocation();
		var form = view.down('#degreeAuditReportSearchForm').getForm();
		var degreeAuditReportGrid =view.down('#profileDegreeAuditReportGrid');
		var programField = form.findField('programId');
		var batchField = form.findField('batchId');
		var exportBtn=view.down('#exportDegreeAuditReportGrid');
		var activeTab =this.getContentPanel().getActiveTab();
		if(this.getCurrentLoggedPortalId()==1|| this.getCurrentLoggedPortalId()==2){
			studentPortalInfo = this.getStudentDetailForErpPortal();
			if (activeTab.getUserId()) {
				var studentId = parseInt(activeTab.getUserId());
			}else{
				var studentId = studentPortalInfo.student.id
			}
		} 
		
		if(this.getCurrentLoggedPortalId()==2){
			permissionsMap=this.getFACULTY_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS();
		}
	    if(this.getCurrentLoggedPortalId()==1){
		   permissionsMap=this.getEXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS();
	   	}

	    var associatedAcadLocationIds = new Array();
	    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    Ext.each(permissionList, function(privilege) {
		   if (privilege === 'EXPORT') {
			   exportBtn.setVisible(true);
		   }
	    });
	    
	    
		var programId = studentPortalInfo.programBatchDetails.programId;
		var batchId = studentPortalInfo.programBatchDetails.batchId;
			
		
    	programField.bindStore(Ext.create('Academia.store.student.studentprofile.StudentProgramStore'));
    	programField.getStore().getProxy().extraParams={
    		studentId: studentId,
    		academyLocationId : academyLocationId,
    		onlyCurrentRecord:false
    	},
    	programField.getStore().load({
    		callback : function(records, operation, success) {
    			if (success) {
    				for(var i in records) {
    					if(records[i].data.id == programId) {
    						programField.setValue(records[i].data.id);
    						batchField.bindStore(Ext.create('Academia.store.student.studentprofile.StudentProgramStore'));
    						batchField.getStore().getProxy().extraParams={
    							studentId: studentId,
    							programId : records[i].data.id,
    							onlyCurrentRecord:false
    						},
    						batchField.getStore().load({
    							callback : function(records, operation, success) {
    								if (success) {
    									for(var i in records) {
    										if(records[i].data.id == batchId) {
    											batchField.setValue(records[i].data.id);
    											$this.auditReportProfileChartAndGridLoad();
    										} 
    									}
    								}
    							}
    						});
    					}
    				}
    			}
    		}
    	});
		
	},
    doAccessLearningTabControlValidation: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var learningTargetsTab = gridReference.down('#vwmycoursedetailslearningtargetsItemId');
    	learningTargetsTabView = learningTargetsTab.tab;
    	learningTargetsTabView.hidden = true;
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'LEARNING_TARGETS') {
    			if(!isNullOrEmpty(learningTargetsTab)){
    				learningTargetsTabView.hidden = false;
    			}        		
    		}
    	});
    },
    stdMyCourseLearningTargetsSubmit: function(obj){
    	var $this = this;
    	var targetForm = obj.up('form');
    	var searchForm=obj.up('form').up().up('form').getForm().getValues();
    	var reviewDateValue = targetForm.down('#stuLearningReviewDateItemId').getValue();
    	var reviewNextDateValue = targetForm.down('#stuLearningNextReviewDateItemId').getValue();
    	var stuFacultyCommentsValue = targetForm.down('#stuFacultyCommentsItemId').getValue();
    	var stuStudentCommentsValue = targetForm.down('#stuStudentCommentsItemId').getValue();
    	var learningTargetGrid = targetForm.down('#stuLearningTargetGradeGridItemId');
    	var learningTargetGridStore = learningTargetGrid.getStore();
    	var flagIsSave = true;
    	var learningTargetDetailId=null;
    	var learningTargetId=null;
    	
    	 if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
			   studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		   } else {
			   studentPortalInfo = this.getStudentDetailForErpPortal();
		   }
    	
    	if(learningTargetGridStore.getCount()==0){
    		showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('PLEASE_SELECT_LEARNING_TARGETS'));
    		flagIsSave = false;
    		return false;
    	}
    	if(flagIsSave){
    		var putItems = [];
    		var count = 1;
    		
    		learningTargetGridStore.data.items.forEach(function(itemObj){
    			
    			if(itemObj.data.courseType=="M"){
    				var maxMarks=parseInt(itemObj.data.courseMaxMark);
    				var minMarks=parseInt(itemObj.data.courseCutOff);
    				var targetMarks=parseInt(itemObj.data.targetGradeMarks);
    				if(maxMarks>=targetMarks && minMarks<=targetMarks){
    					putItems.push({
            				'courseId':itemObj.data.courseId,
            				'targetDate':itemObj.data.targetDate,
            				'submissionDate':itemObj.data.submissionDate,
            				'targetGradeMarks':itemObj.data.targetGradeMarks,
            				'targetAttendance':itemObj.data.targetAttendance,
            				'learningTargetDetailId':itemObj.data.learningTargetDetailId,
            				'learningTargetId':itemObj.data.learningTargetId
            			});
            			learningTargetDetailId=itemObj.data.learningTargetDetailId;
            			learningTargetId=itemObj.data.learningTargetId;
            			count = count+1;
    				} else if(!isNullOrEmpty(targetMarks)) {
    					putItems.push({
            				'courseId':itemObj.data.courseId,
            				'targetDate':itemObj.data.targetDate,
            				'submissionDate':itemObj.data.submissionDate,
            				'targetGradeMarks':minMarks,
            				'targetAttendance':itemObj.data.targetAttendance,
            				'learningTargetDetailId':itemObj.data.learningTargetDetailId,
            				'learningTargetId':itemObj.data.learningTargetId
            			});
            			learningTargetDetailId=itemObj.data.learningTargetDetailId;
            			learningTargetId=itemObj.data.learningTargetId;
            			count = count+1;
    				}
    				
    			}
    			else {
    				putItems.push({
        				'courseId':itemObj.data.courseId,
        				'targetDate':itemObj.data.targetDate,
        				'submissionDate':itemObj.data.submissionDate,
        				'targetGradeMarks':itemObj.data.targetGradeMarks,
        				'targetAttendance':itemObj.data.targetAttendance,
        				'learningTargetDetailId':itemObj.data.learningTargetDetailId,
        				'learningTargetId':itemObj.data.learningTargetId
        			});
        			learningTargetDetailId=itemObj.data.learningTargetDetailId;
        			learningTargetId=itemObj.data.learningTargetId;
        			count = count+1;
    			}
    		});
    		var mainObj = {
    				"reviewDate": reviewDateValue,
    				"nextReviewDate": reviewNextDateValue,
    				"facultyComment": stuFacultyCommentsValue,
    				"studentComment": stuStudentCommentsValue,
    				"learningTargetDetails":putItems,
    				"learningTargetDetailId":learningTargetDetailId,
    				"id":learningTargetId,
    				"admissionId":studentPortalInfo.admissionDetails[0].id,
    				"periodId":searchForm.period
    				
    		}
    		var submitData = Ext.encode(mainObj);
    		var submitUrl = SERVERURL.PATH_LEARNING_TARGET_SAVE;

    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : submitData,
    			method : 'POST',
    			success : function(response, action) {
    				Ext.getBody().unmask();
    				showSuccessMessage(getExaminationTranslation('LEARNING_TARGETS'), getExaminationTranslation('LEARNING_TARGETS_DETAILS_SUCCESSFULLY_MSG'));
    			},
    			failure: function(form, action) {
    				Ext.getBody().unmask();
    				
    			}
    		});
    	}

    },
    doAccessLearningGridButtonControlValidation: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var btnPrintLearningPlan = gridReference.down('#btnPrintLearningPlan');
    	var getSubmitButton=this.getVwmycoursedetailslearningtargets().down('#learningTargetSubmit');
    	btnPrintLearningPlan.setVisible(false);
    	getSubmitButton.setVisible(false);
       	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'PRINT_LEARNING_PLAN') {
    			if(!isNullOrEmpty(btnPrintLearningPlan)){
    				btnPrintLearningPlan.setVisible(true);
    			}        		
    		}
    		if (privilege === 'SAVE') {
    			if(!isNullOrEmpty(getSubmitButton)){
    				getSubmitButton.setVisible(true);
    			}        		
    		}
    	});
    },
    
    stdMyCourseLearningTargetsReset: function(obj){
    	var $this = this;
    	var portalId = $this.getCurrentLoggedPortalId();
    	if(portalId==2 || portalId==1){
    		var personProfile=this.getStudentDetailForErpPortal();
    		var admissionId =personProfile.admissionDetails[0].id
    	} else {
    		var studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
    		var admissionId =studentPortalInfo.admissionDetails[0].id;
    	}
    	
		var targetForm = obj.up('form');
		var filterFormDetails=targetForm.up('form');
		var formValues=filterFormDetails.getForm().getValues();
		$this.getStuLearningTargetGradeGridItemId().getStore().getProxy().extraParams={
			admissionId:admissionId,
			programId:formValues.programId,
			batchId:formValues.batch,
			periodId:formValues.period,
			sort:null
		};
		$this.getStuLearningTargetGradeGridItemId().getStore().load({
			callback : function(records, operation, success) {
				if (success) {
				if(records.length>0){
					var detailTab=$this.getVwmycoursedetailslearningtargets();
					if(records[0].data.reviewDate!=null){
						detailTab.down('#stuLearningReviewDateItemId').setValue(dateRender(records[0].data.reviewDate));
					} else {
						detailTab.down('#stuLearningReviewDateItemId').setValue(new Date());
					}
					if(records[0].data.nextReviewDate!=null){
						detailTab.down('#stuLearningNextReviewDateItemId').setValue(dateRender(records[0].data.nextReviewDate));
					} else {
						detailTab.down('#stuLearningNextReviewDateItemId').reset();
					}
					if(records[0].data.facultyComment!=null){
						detailTab.down('#stuFacultyCommentsItemId').setValue(records[0].data.facultyComment);	
					} else {
						detailTab.down('#stuFacultyCommentsItemId').reset();
					}
					if(records[0].data.studentComment!=null){
						detailTab.down('#stuStudentCommentsItemId').setValue(records[0].data.studentComment);
					} else {
						detailTab.down('#stuStudentCommentsItemId').reset();
					}
					
					var gradeMarkTargetCombo = $this.getStuLearningTargetGradeGridItemId().columns[3].getEditor();
					gradeMarkTargetCombo.getStore().getProxy().extraParams={
						gradeType:records[0].data.courseGradeType,
						courseCutOff:records[0].data.courseCutOff,
						courseMaxMark:records[0].data.courseMaxMark,
					};
					gradeMarkTargetCombo.getStore().load();
					if(!isNullOrEmpty(records[0].data.courseType) && records[0].data.courseType=="G"){
						$this.getStuLearningTargetGradeGridItemId().show();
						$this.getStuLearningTargetMarkGridItemId().hide();
					} else {
						$this.getStuLearningTargetGradeGridItemId().hide();
						$this.getStuLearningTargetMarkGridItemId().show();
					}
					if(portalId == 3 || portalId == 7) {
						detailTab.down('#stuLearningReviewDateItemId').setReadOnly(true);
						detailTab.down('#stuLearningNextReviewDateItemId').setReadOnly(true);
						detailTab.down('#stuFacultyCommentsItemId').setReadOnly(true);
						$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[1].getEditor().setReadOnly(true);
						$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[1].getEditor().setReadOnly(true);
						$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[2].getEditor().setReadOnly(true);
						$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[2].getEditor().setReadOnly(true);
						
						$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[3].getEditor().setReadOnly(true);
						$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[3].getEditor().setReadOnly(true);
						$this.getStuLearningTargetGradeGridItemId().getView().getGridColumns()[5].getEditor().setReadOnly(true);
						$this.getStuLearningTargetMarkGridItemId().getView().getGridColumns()[5].getEditor().setReadOnly(true);
					} else {
						obj.up('vwmycoursedetailslearningtargets').down('#learningTargetSubmit').enable();
					}
					
				}
				}
			}
		});
	

    },showRequestExamCancellation:function(){
    	var $this = this;
    	var grid = $this.getStudentcoursereportgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		var data = records[0].data;
    		this.getDocumentController().showRequestExamCancellationWindow('groupItemId', 'DOCUMENT');
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    generateLearningTemplateReport:function(reportParams, templateCode) {
		    var code = templateCode;
		    var URL = "";
		    if(templateCode == 'CONSOLIDATED_LEARNING_PLAN'){
		    	reportParams.reportTitle ="Consolidated Learning Plan";
		    	URL = SERVERURL.PATH_CONSOLIDATED_LEARNING_PLAN_REPORT;
		    } else {
		    	reportParams.reportTitle ="Learning Target Plan";
		    	URL = SERVERURL.PATH_LEARNING_TARGET_PLAN_REPORT;
		    }
		    this.exportJRXMLReport(code, reportParams, reportParams.reportTitle,'.pdf', URL);
    },
    generateLessonPlanReport: function(record) {
    	var $this = this;
	    var academyLocationId = this.getCurrentAcademyLocation();
	    var code = "";
	    var lessonPlanId = record.data.lessonPlanmodel[0].secondId;
	    var portalId = this.getCurrentLoggedPortalId();
	    var reportParams = {
	        LESSON_PLAN_ID: lessonPlanId,
	        LESSON_PLAN_Label: getCommonTranslation('LESSON_PLAN'),
	        ACADEMY_LOCATION_ID: academyLocationId,
	        PORTAL_ID: portalId,
	        headerName: getProgramandcourseTranslation('LESSON_PLAN_REPORT')
	    };
	
	    Ext.Ajax.request({
	        type: 'rest',
	        url: SERVERURL.TEMPLATE_NAME_BY_CODE,
	        method: 'GET',
	        params: {
	            academyLocationId: academyLocationId,
	            reportType: 'Lesson Plan'
	        },
	        success: function(response) {
	            var responseData = Ext.decode(response.responseText);
	            var matchedCode = "LESSON_PLAN_REPORT_MODEL_PDF"; // default
	           var exportUrl = SERVERURL.PATH_LESSON_PLAN_REPORT_PDF_DOWNLOAD;
	
	            Ext.Array.each(responseData, function(item) {
	                if (item.value === "SOMMET_COURSE_DESCRIPTOR_PDF") {
	                	matchedCode=item.value;
	                } else if (item.value === "LRCM_COURSE_DESCRIPTOR_PDF") {
	                	matchedCode=item.value;
	                } else if (item.value === "LRM_COURSE_DESCRIPTOR_PDF") {
	                	matchedCode=item.value;
	                }
	               exportUrl = SERVERURL.PATH_GENERATE_COURSE_DESCRIPTOR_REPORT_PDF;
	            });
	
	            $this.exportJRXMLReport(matchedCode, reportParams, 'Lesson Plan Report', '.pdf', exportUrl);
	        },
	        failure: function() {
	            Ext.Msg.alert('Error', 'Failed to load report options.');
	        }
    });
},
	midtermGradeMarksSave: function(obj) {
    var $this = this;
    var grid = $this.getStudentcoursereportgrid();
    var studentCourseList = "";
    var selection = grid.getSelectionModel().getSelection();
    if (selection.length != 0) {
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        var selected = [];
        for (var i = 0; i < selection.length; i++) {
            var WScourseEnrollmentObject = {};
            WScourseEnrollmentObject['id'] = selection[i].data.studentCourseEnrollmentId;
            WScourseEnrollmentObject['midtermGradeMarks'] = selection[i].data.midtermGradeMarks;
            WScourseEnrollmentObject['enrollCourseStatus'] =selection[i].data.enrollCourseStatus;
            selected.push(WScourseEnrollmentObject);
        }
        var submitUrl = SERVERURL.UPDATE_STUDENT_COURSE_ENROLLMENT_MIDTERM_GRADEMARKST_URL;
        Ext.Ajax.request({
            method: "POST",
            type: 'rest',
            jsonData: selected,
            url: submitUrl,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(response) {
                Ext.getBody().unmask();
                showSuccessMessage(getCourseTxCommonTranslation('STUDENT_ENROLLMENT'),getCommonTranslation('MIDTERM_GRADE_MARKS_UPDATED_SUCCESSFULLY'));
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll(true);
            }
        });
    } else {
        showErrorMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    }
},

saveDocumentUrl: function(btn) {
	var $this = this;
	 var window = this.getAcademictopicdetails();
		
//	 var id = window.down('#acadmicTopicHiddenId').value;
	 
	/* if(id == ""){
		 var docGrid = this.getAcademictopicdocumenturlgrid();
	    	//var addBtn = docGrid.down('#btnAdd');
	    	var btnEdit = docGrid.down('#btnEdit');
	    	btnEdit.hide();
	 }*/
	 var docAddEditWin = btn.up('documentformwindow');
	 var id = '';
	 if(docAddEditWin.down('hiddenfield[name=documentId]')) {
		 id = docAddEditWin.down('hiddenfield[name=documentId]').getValue();
	 }
	var form = Ext.ComponentQuery.query('simpleurlform')[0];
//	form.down('#urlFlag').setValue('true');]\
	form.down('#documentFormSubmitButtonId').setDisabled(true);
	var formUrl = Ext.ComponentQuery.query('studentpassportdetailsform')[0];
	fields : ['id','documentId','documentName','path']
	var documentModelUrl = new Academia.model.personinfo.common.personalinfo.StudentPassportUrlModel();
	var documentName=form.down('#documentNameField').getValue();
	var UrlName=form.down('#documentUrlField').getValue();
//	documentModelUrl.set("id",id);
	documentModelUrl.set("name",documentName);
	documentModelUrl.set("path",UrlName);
	var urlGrid = Ext.ComponentQuery.query('academictopicdocumenturlgrid')[0];
	var store2 = urlGrid.getStore();
	var windows = Ext.ComponentQuery.query('#academicTopicDocUrlItemId')[0];
	 if(urlGrid.getSelectionModel().getSelection() == 0) {
		 store2.add(documentModelUrl);
	 }else {
		 var documentModelUrl = urlGrid.getSelectionModel().getSelection()[0];
		 documentModelUrl.set("id",id);
		 documentModelUrl.set("name",documentName);
		 documentModelUrl.set("path",UrlName);
		 window.down('#editFlag').setValue('true');
//		 documentModelUrl.set("id",id);
		 
	 }
	if (urlGrid.isHidden() && store2.data.items.length > 0) {
		urlGrid.setVisible(true);
	}
	/*if($this.passportMode=='ADD'){
								 fileModifiedDate.setValue(dateRender(new Date()));
 						}else{
							    fileModifiedDate.setValue(dateRender(new Date()));
 						}*/
	$this.getDocumentController().closeDocumentFormWindow();
	showSuccessMessage(getCommonTranslation('URL'),getCommonTranslation('URL_ADD_SUCCESSFULLY'));
	if($this.addEditBtn == true) {
//		urlGrid.down('#btnDelete').setVisible(false)
		 urlGrid.down('#btnEdit').setVisible(false)
	 }
	urlGrid.getSelectionModel().deselectAll(true);
	urlGrid.down('#btnEdit').setDisabled(true);
},
viewStudentSalesForceAdmissionDetailFormWindow: function() {
  	var $this = this;
	var salesFourceStudentGrid = null;
	var activetabInfo = $this.getContentPanelActiveTab();
	var salesFourceStudentGrid = activetabInfo.down('#studentsalesforceadmissiondetailsgridId');
	if (salesFourceStudentGrid.getSelectionModel().getCount() > 0) {
		var window = $this.getStudentsalesforceadmissiondetailswindow();
		if (!window) {
			window = Ext.widget('studentsalesforceadmissiondetailswindow', {
				itemId: 'studentsalesforceadmissiondetailswindow'
			});
		}
		window.show();
		var selectedRecord = salesFourceStudentGrid.getSelectionModel().selected.items[0].data;
		var form = window.down('#studentsalesforceadmissiondetailsformId');
		form.getForm().setValues(selectedRecord);
		$this.toggleReadOnlyFormItems(form.getForm(),true);
					

	}else{
		showWarningMessage(getCommonTranslation('SALESFORCE_ADMISSION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	}
},

});
