/**
 * This controller is used for the student disciplinary functionality.
 * Add/Edit/delete/view
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.student.StudentDisciplinaryController', {
	extend: 'Academia.controller.personinfo.common.PersonDisciplinaryController',

	alias: "widget.studentdisciplinarycontroller",

	refs : [
		{
			ref : 'personCommonWindow',
			selector : 'personcommonwindow'
		},
		{
			ref : 'personDisciplinaryActionForm',
			selector : 'disciplinaryactionform[itemId=studentDisciplinaryActionForm]'

		},
		{
			ref : 'personPositiveIncidentForm',
			selector : 'positiveincidentform[itemId=studentPositiveIncidentForm]'

		},
		{
			ref : 'personNegativeIncidentForm',
			selector : 'negativeincidentform[itemId=studentNegativeIncidentForm]'

		},
		{
			ref : 'simpledocumentform',
			selector : 'simpledocumentform'

		},{
			ref : 'documenteditwithfileform',
			selector : 'documenteditwithfileform'

		},
		{
			ref : 'disciplinaryactionform',
			selector : 'disciplinaryactionform'

		},
		{
			ref : 'disciplinaryactiongrid',
			selector : 'disciplinaryactiongrid[itemId= studentDisciplinaryActionGrid]'
		},
		{
			ref : 'disciplinaryactiondocumentgrid',
			selector : 'disciplinaryactiondocumentgrid'
		},
		{
			ref : 'disciplinaryactiondocumentlist',
			selector : 'disciplinaryactiondocumentlist'
		}, {
			ref : 'disciplinaryactiondocumentlistgrid',
			selector : 'disciplinaryactiondocumentlistgrid'
		}, {
			ref : 'positiveincidentform',
			selector : 'positiveincidentform'
		}, {
			ref : 'positiveincidentgrid',
			selector : 'positiveincidentgrid[itemId=studentPositiveIncidentGrid]'
		},{
			ref : 'negativeincidentgrid',
			selector : 'negativeincidentgrid[itemId=studentNegativeIncidentGrid]'
		}, /*{
								ref : 'studentpositiveincidentgrid',
								selector : 'studentpositiveincidentgrid[itemId= studentPositiveIncidentGrid]'
							},*/
		{
			ref : 'positiveincidentdocumentlist',
			selector : 'positiveincidentdocumentlist[itemId=studentPositiveIncidentReportDocument]'
		},


		{
			ref : 'positiveincidentdocumentgrid',
			selector : 'positiveincidentdocumentgrid'

		},
		{
			ref : 'positiveincidentdocumentlistgrid',
			selector : 'positiveincidentdocumentlistgrid[itemId=studentpositiveincidentdocumentlistgrid]'

		},
		{
			ref : 'disciplinaryactionsugrid',
			selector : 'disciplinaryactionsugrid[itemId= studentDisciplinaryActionSUGrid]'
		},
		{
			ref : 'personDisciplinaryActionFormSU',
			selector : 'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU]'

		},
		{
			ref : 'personWindowSu',
			selector : 'personwindowsu'
		},
		{
			ref : 'sanctiondetailsgrid',
			selector : 'sanctiondetailsgrid'
		},
		{
			ref : 'disciplinaryactiondocumentsulist',
			selector : 'disciplinaryactiondocumentsulist'
		},
		{
			ref : 'disciplinaryactionsusanctiondetailwindow',
			selector : 'disciplinaryactionsusanctiondetailwindow'
		},
		{
			ref :'disciplinaryactiondocumentlistgridsu',
			selector :'disciplinaryactiondocumentlistgridsu'
		},
		{
			ref :'negativeincidentform',
			selector :'negativeincidentform'
		},{
			ref :'studentDisciplinaryCountWindowSu',
			selector :'studentDisciplinaryCountWindowSu'
		}

		],
		config: {
			STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES'),
			STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES'),
			STUDENT_POSITIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_POSITIVE_INCIDENTS_PRIVILEGES'),
			STUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES'),
			PARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES'),
			FACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES'),
			STUDENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES'),
			PARENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES'),
			FACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES'),
			STUDENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PRIVILEGES'),
			PARENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PRIVILEGES'),
			FACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PRIVILEGES'),
			STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES'),
			STUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES'),
			PARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES'),
			FACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES'),
			INVOLVED_STUDENT_DELETEBTN_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INVOLVED_STUDENT_DELETEBTN_PRIVILEGES')

		},
		init: function(application) {
			this.control({
				/**
				 *  Disciplinary Action
				 */

				'disciplinaryactiondocumentlist[itemId=studentDisciplinaryReportDocument] disciplinaryactiondocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						this.documentReportDocumentZip();
					}
				},

				'disciplinaryactiondocumentlist grid[itemId=periodGridWin]':{
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								this.getDownloadFile(record.get('documentId'));
							}
						}
					}
				},
			   'disciplinaryactiondocumentlistgrid grid[itemId=periodGridWin]':{
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								this.getDownloadFile(record.get('documentId'));
							}
						}
					}
				},
				'disciplinaryactiondocumentlistgrid button[itemId=btnDelete]':{
					click:function(obj){
						this.deleteDisciplinaryDocument();
					}
				},

				'disciplinaryactiongrid[itemId= studentDisciplinaryActionGrid]':{
					cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
						var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//						var documentId = record.data.document.id;
						if(columnName == "documents"){
							if(e.target.tagName=='A'){
								if(record.data.documents.length == 1){
									var whetherFile = false;
									var documentId= record.data.documents["0"].id;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}} else if(record.data.documents.length > 1){
										var docWindow = this.getDisciplinaryactiondocumentlist();
										var ID = record.data.id;
										if (!docWindow) {
											// Ext.widget('disciplinaryactiondocumentlist');
											docWindow = Ext.widget('disciplinaryactiondocumentlist',{
												itemId:'studentDisciplinaryReportDocument'
											});
											//  docWindow = this.getDisciplinaryactiondocumentlist();
										}
										docWindow.show();
										docWindow.down('form').down('#incidentDate').setValue(dateRender(record.data.incidentDate));
										docWindow.down('form').down('#details').setValue(record.data.details);
										docWindow.down('form').down('#actionTaken').setValue(record.data.actionTaken);
										var disciplinaryactiondocumentlistgrid = docWindow.down('#disciplinaryactiondocumentlistgridItemId');
										disciplinaryactiondocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
										var portalId = this.getCurrentLoggedPortalId();
										if(portalId==3)
										{
											docWindow.down("#btnDelete").setVisible(false);
										}
										var store = disciplinaryactiondocumentlistgrid.getStore();
										store.getProxy().extraParams = {
											ID: record.data.id
										};
										store.load();
										if(portalId == 2){
											this.doAccessFacultyDAGridDeleteButton(disciplinaryactiondocumentlistgrid, this.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
										}else if(portalId == 1)
										{
											this.doAccessFacultyDAGridDeleteButton(disciplinaryactiondocumentlistgrid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
										}
									}
							}
						}
						else if(columnName == "disciplinaryActionDetails"){
							if(e.target.tagName=='A'){
								this.showStudentDisciplinaryCountWindow(record);
							}
						}
					}
				},

				'disciplinaryactiondocumentlistgrid':{
					render: function(grid) {
						//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					},
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								this.getDownloadFile(record.get('documentId'));
							}
						}
					}
				},
				'disciplinaryactionform[itemId=studentDisciplinaryActionForm] button#uploadDisciplinaryItemId' : {
					click : function() {
						this.getDocumentController().showDocumentFormWindow('student_disciplinary_hidden_field','DOCUMENT');
					}
				},
				'disciplinaryactionform[itemId=studentDisciplinaryActionForm] disciplinaryactiondocumentgrid button#btnDelete' : {
					click : function() {
						var $this = this;
						var grid = $this.getDisciplinaryactiondocumentgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							Ext.MessageBox.confirm(getCommonTranslation('DISCIPLINARY_ACTION'),
									getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									function(btn,text) {
								if (btn == 'yes') {
									var store = grid.getStore();
									var record = grid.getSelectionModel().getSelection()[0];
									var id = record.get("id");
									if (!isNullOrEmpty(id)) { Ext.Ajax.request({
										method : "DELETE",
										type : 'rest',
										url : SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL
										+ '?id='
										+ id,
										headers : {
											'Content-Type' : 'application/json'
										},
										success : function(form,action) {store.reload();
										showSuccessMessage(getCommonTranslation('DISCIPLINARY_ACTION'),
												getCommonTranslation('DOCUMENT_SUCCESS_MSG'));}
									});
									}else{
										if (record) {store.remove(record);
										showSuccessMessage(getCommonTranslation('DISCIPLINARY_ACTION'),
												getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
										}
									}
								}
							});
						} else {
							showWarningMessage(getCommonTranslation('DISCIPLINARY_ACTION'),
									getCommonTranslation('PLEASE_SELECT_RECORD')); 
						}
					}
				},

				'disciplinaryactionform[itemId=studentDisciplinaryActionForm] disciplinaryactiondocumentgrid' : {
					cellclick : function(grid, td,
							cellIndex, record, tr,
							rowIndex, e, eOpts) {
						var $this = this;
						var documentGrid = $this
						.getDisciplinaryactiondocumentgrid();
						var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

						if (columnName == "documentName") {
							if (e.target.tagName == 'A') {
								var documentId = record
								.get("documentId");
								if (!isNullOrEmpty(documentId)) {
									$this
									.getDocumentController()
									.downloadDocumentFile(
											documentId);
								}
							}
						}
					}
				},
				'documentformwindow[itemId=student_disciplinary_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
					click : function() {
						var $this = this;
						var isTransient = true;
						var module = 'disciplinaryAction';
						var entityId;
						var entityType = 'disciplinaryActionDocument';

						$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
								function(success,response,isCallBackTransient) {
							var documentModel = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentModel();
							documentModel.set("documentName",response.name);
							documentModel.set("path",response.path);
							documentModel.set("type",response.type);
							documentModel.set("documentName",response.name);
							documentModel.set("createdBy",$this.getIdValueJson(
									response.createdBy.id,response.createdBy.value));
							var disciplinaryactionDocGrid = $this.getDisciplinaryactiondocumentgrid();
							var store = disciplinaryactionDocGrid.getStore();
							store.add(documentModel);
							disciplinaryactionDocGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
							if (disciplinaryactionDocGrid.isHidden() && store.data.items.length > 0) {
								disciplinaryactionDocGrid.setVisible(true);
							}
							$this.getDocumentController().closeDocumentFormWindow();

						}, isTransient);
						showSuccessMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'),getPersonModuleTranslation('DISCIPLINARY_ACTION_DOCUMENT_ADD_SUCCESSFULLY'));
					}
				},
				'documentformwindow[itemId=student_disciplinary_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
					click : function() {
						this.getDocumentController()
						.closeDocumentFormWindow();
					}
				},
				'disciplinaryactiongrid[itemId=studentDisciplinaryActionGrid]': {
					render: function(grid) {
						this.loadGridStore('#studentDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_GRIDDATA);
						var portalId = this.getCurrentLoggedPortalId();
						if(portalId == 7){
							this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
						}else if(portalId == 2){
							this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
							this.doAccessControlValidationOfAddStudent(grid, this.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS(),'DISCIPLINARY_ACTIONS');
						}else if(portalId == 3){
							this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
						}else{
							this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
							this.doAccessControlValidationOfAddStudent(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS(),'DISCIPLINARY_ACTIONS');
						}
				},
				afterrender:function(grid){
					var me = this;
					if(portalId == 7) {
						me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
				    }else if(portalId == 2) {
						me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					}else if(portalId == 3) {
						me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					}else {
						me.addDataGridConfigButton(grid,me.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					}

				}
			},	
				'disciplinaryactionsugrid[itemId= studentDisciplinaryActionSUGrid]':{
					render: function(grid) {
						this.loadGridStore('#studentDisciplinaryActionSUGrid', SERVERURL.PATH_DISCIPLINARY_ACTION_SU_GRID);
						var portalId = this.getCurrentLoggedPortalId();
						if(portalId == 1){
							this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS());
							this.doAccessControlValidationOfAddStudent(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS(),'DISCIPLINARY_ACTIONS_SU');

						}else if(portalId == 3){
							this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS());
							this.doAccessControlValidationOfAddStudent(grid, this.getSTUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS(),'DISCIPLINARY_ACTIONS_SU');
						}else if(portalId == 7){
							this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS());
							this.doAccessControlValidationOfAddStudent(grid, this.getPARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS(),'DISCIPLINARY_ACTIONS_SU');
						}
					},
					afterrender:function(grid){
						var me = this;
						setTimeout(function(){
							me.addDataGridConfigButton(grid,me.getSTUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS());
						},1500);

					},
					cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
						var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
						if(columnName == "disciplinaryActionDetails"){
							 if(e.target.tagName=='A'){
								 this.showStudentDisciplinaryCountWindowSu(record);
								var grid=Ext.ComponentQuery.query('#studentDisciplinaryCountWindowGridSu')[0];
								this.doAccessControlValidationOfStudentInvolvedDeleteButton(grid, this.getINVOLVED_STUDENT_DELETEBTN_PERMISSIONS());
							 }
						 }else 	if(columnName == "documents"){
								if(e.target.tagName=='A'){
									if(record.data.documents.length == 1){
										var whetherFile = false;
										var documentId= record.data.documents["0"].encryptedDocId;
										if(!isNullOrEmpty(documentId)){
											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
												method: 'GET',
												callback : function(opt, success, response){
													if(response.responseText == 'true') {
														var csvForm = Ext.create('Ext.form.Panel'); 
														csvForm.getForm().submit({
															target: '_blank',
															method:'GET',
															params :{
																access_token : Ext.Ajax.defaultHeaders.access_token
															},
															headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
															url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
															standardSubmit :true
														});
													} else {
														showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
													}
												}
											});
										}} else if(record.data.documents.length > 1){
											var docWindow = this.getDisciplinaryactiondocumentsulist();
											if (!docWindow) {
												// Ext.widget('disciplinaryactiondocumentlist');
												docWindow = Ext.widget('disciplinaryactiondocumentsulist',{
													itemId:'studentDisciplinaryReportDocumentProfileSu'
												});
												//  docWindow = this.getDisciplinaryactiondocumentlist();
											}
											docWindow.show();
											var disciplinaryactiondocumentlistgrid = this.getDisciplinaryactiondocumentlistgridsu();
											disciplinaryactiondocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
											var portalId = this.getCurrentLoggedPortalId();
											if(portalId==3)
											{
												docWindow.down("#btnDeleteSU").setVisible(false);
											}
											var store = disciplinaryactiondocumentlistgrid.getStore();
											store.getProxy().extraParams = {
												id: record.data.id
											};
											store.load();
											/*if(portalId == 2){
												this.doAccessFacultyDAGridDeleteButton(disciplinaryactiondocumentlistgrid, this.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
											}else if(portalId == 1)
											{
												this.doAccessFacultyDAGridDeleteButton(disciplinaryactiondocumentlistgrid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
											}*/
										}
								}
							}else if(columnName == "sanctionDetails"){
								 if(e.target.tagName=='A'){
									 this.showSanctionDetailsOnPopUpWindow(record);
								 }
							 }
					 }
				},					
				'disciplinaryactiongrid[itemId=studentDisciplinaryActionGrid] button[itemId=btnAdd]': {
					click: function() {
						var me=this;
						me.showPersonCommonWindow('DISCIPLINARY_ACTION', 'studentDisciplinaryActionForm');
						me.setReporterForPosstiveDisciplinaryAction(false);
					}
				}, 
				'disciplinaryactionsugrid[itemId=studentDisciplinaryActionSUGrid] button[itemId=btnAdd]': {
					click: function() {
						var me=this;
						var grid = me.getDisciplinaryactionsugrid();
						grid.getSelectionModel().deselectAll();
						me.showPersonCommonWindow('DISCIPLINARY_ACTION_SU','studentDisciplinaryActionFormSU');
						//me.setReporterForPosstiveDisciplinaryActionSU(false);
					}
				},
				'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] radiogroup#temporarysSuspension': {
					change: function( radio, newValue, oldValue, eOpts) {
						this.loadTemporarySuspensionDateAndRestrictionField(radio, newValue, oldValue);
					}
				},
				'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] radiogroup#temporarysSuspensionLapse': {
					change: function( radio, newValue, oldValue, eOpts) {
						this.loadTemporarySuspensionLapseDateField(radio, newValue, oldValue);
					}
				},
				'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] nestedJsonCombo[itemId=disciplinaryCommittee]': {

					/*select : function(obj,rec){
						this.setDisciplinaryDeterminationField(obj,rec);
					}*/
				},
				'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] radiogroup#appeal': {
					change: function( radio, newValue, oldValue, eOpts) {
						this.loadAppealDateAndAppealOutcome(radio, newValue, oldValue);
					}
				},
				'personwindowsu[itemId=personwindowsu] disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] button[itemId=submitButtonId]': {
					click: function(){
						this.saveDisciplinaryActionSU('#studentDisciplinaryActionSUGrid', SERVERURL.PATH_DISCIPLINARY_ACTION_SU_SAVE , SERVERURL.PATH_DISCIPLINARY_ACTION_SU_UPDATE);
					}
				},
				'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] button#uploadDisciplinarySUItemId' : {
					click : function() {
						this
						.getDocumentController()
						.showDocumentFormWindow(
								'student_disciplinary_hidden_field',
						'DOCUMENT');
					}
				},
				'documentformwindow[itemId=student_disciplinary_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
					click : function() {
						this.getDocumentController()
						.closeDocumentFormWindow();
					}
				},
				'personwindowsu[itemId=personwindowsu] disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] button[itemId=cancelButtonSUId]': {
					click: this.closePersonWindowSU
				},
				'disciplinaryactiongrid[itemId=studentDisciplinaryActionGrid] button[itemId=btnEdit]': {
					click: function(){
						var me =this;
						me.editDisciplinaryActionFormWindow('DISCIPLINARY_ACTION', 'studentDisciplinaryActionForm', '#studentDisciplinaryActionGrid');
						me.setReporterForPosstiveDisciplinaryAction(true);
					}
				},
				'disciplinaryactiongrid[itemId=studentDisciplinaryActionGrid] button[itemId=btnView]': {
					click: function(){
						this.viewDisciplinaryActionFormWindow('DISCIPLINARY_ACTION', 'studentDisciplinaryActionForm', '#studentDisciplinaryActionGrid');
					}
				},
				'disciplinaryactiongrid[itemId=studentDisciplinaryActionGrid] button[itemId=btnDelete]': {
					click: function(){
						this.deleteDisciplinaryActionRecord('#studentDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_DELETE);
					}
				},
				'disciplinaryactiongrid[itemId=studentDisciplinaryActionGrid] button[itemId=btnAddStudents]': {
					click: function(me, e, eOpts){
						var type = 'DISCIPLINARY_ACTIONS';
						this.showAddStudentsWindow(me, e, eOpts, type);
					}
				},
				'button[itemId=addNewFieldContainerBtn]':{
					click: function(btn){
						this.addMoreFieldsOfProgramStudent(btn,'DISCIPLINARY_ACTIONS');
					}
				},
				'button[itemId=addNewFieldContainerBtn1]':{
					click: function(btn){
						this.addMoreFieldsOfProgramStudent(btn,'DISCIPLINARY_ACTIONS');
					}
				},
				'button[itemId=addNewFieldContainerBtnPositive]':{
					click: function(btn){
						this.addMoreFieldsOfProgramStudent(btn,'POSITIVE_INCIDENTS');
					}
				},
				'button[itemId=addNewFieldContainerBtn1Positive]':{
					click: function(btn){
						this.addMoreFieldsOfProgramStudent(btn,'POSITIVE_INCIDENTS');
					}
				},
				'button[itemId=addNewFieldContainerBtnNegative]':{
					click: function(btn){
						this.addMoreFieldsOfProgramStudent(btn,'NEGATIVE_INCIDENTS');
					}
				},
				'button[itemId=addNewFieldContainerBtn1Negative]':{
					click: function(btn){
						this.addMoreFieldsOfProgramStudent(btn,'NEGATIVE_INCIDENTS');
					}
				},
				'button[itemId=detailedDeleteButton1]':{
					click: function(btn){
						this.deleteMoreFieldsOfProgramStudent(btn,'DISCIPLINARY_ACTIONS');
					}
				},
				'button[itemId=detailedDeleteButton1Positive]':{
					click: function(btn){
						this.deleteMoreFieldsOfProgramStudent(btn,'POSITIVE_INCIDENTS');
					}
				},
				'button[itemId=detailedDeleteButton1Negative]':{
					click: function(btn){
						this.deleteMoreFieldsOfProgramStudent(btn,'NEGATIVE_INCIDENTS');
					}
				},
				'button[itemId=addStudentsWindowFormCancelButtonId]':{
					click : this.hideAddStudentsWindow
				},
				'button[itemId=addStudentsWindowFormSubmitButtonId]':{
					click: function(){
						this.saveStudentWindowForm('DISCIPLINARY_ACTIONS');
					}
				},
				'button[itemId=addStudentsWindowFormCancelButtonIdPositive]':{
					click : this.hideAddStudentsWindow
				},
				'button[itemId=addStudentsWindowFormSubmitButtonIdPositive]':{
					click: function(){
						this.saveStudentWindowForm('POSITIVE_INCIDENTS');
					}
				},
				'button[itemId=addStudentsWindowFormCancelButtonIdNegative]':{
					click : this.hideAddStudentsWindow
				},
				'button[itemId=addStudentsWindowFormSubmitButtonIdNegative]':{
					click: function(){
						this.saveStudentWindowForm('NEGATIVE_INCIDENTS');
					}
				},
				'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=studentDisciplinaryActionForm] button[itemId=submitButtonId]': {
					click: function(){
						this.saveDisciplinaryAction('#studentDisciplinaryActionGrid', SERVERURL.DISCIPLINARY_ACTION_ADD, SERVERURL.DISCIPLINARY_ACTION_UPDATE);
					}
				},
				'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=studentDisciplinaryActionForm] button[itemId=cancelButtonId]': {
					click: this.closePersonCommonWindow
				},

				'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=studentDisciplinaryActionForm] customcombobox[itemId=reportedByUserIdField]': {
					select : function(combo, records, eOpts){
						this.validateDisciplinaryReportedIdField(combo, records, eOpts);
					}
				},
				'personcommonwindow[itemId=personCommonWindow] disciplinaryactionform[itemId=studentDisciplinaryActionForm] combo[itemId=reportedByField]': {
					select: function(combo) {
						this.showHideDisciplinaryActionReportedField(combo);
					}
				},

				/**
				 *  Positive Action
				 */
				 'positiveincidentdocumentlistgrid':{
					 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						 if(columnName == "documentName"){
							 if(e.target.tagName=='A'){
								 this.getDownloadFile(record.get('documentId'));
							 }
						 }
					 }
				 },

				 'positiveincidentdocumentlist grid[itemId=periodGridWin]':{
					 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						 if(columnName == "documentName"){
							 if(e.target.tagName=='A'){
								 this.getDownloadFile(record.get('documentId'));
							 }
						 }
					 }
				 },
				 'positiveincidentdocumentlist button[itemId=btnDelete]':{
					 click:function(field){
						 var activeTab;
						 var tabpanel = Ext.ComponentQuery.query('personinfopanel')[0];
						 if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
							 if(!isNullOrEmpty(tabpanel.activeTab) && tabpanel.activeTab != undefined){
								 if(tabpanel.activeTab.itemId == 'studentNegativeIncidentDetails'){
									 this.deleteNegativeIncidentDocument();
								 }else{
									 this.deleteIncidentDocument();
								 }
							 }else{
								 activeTab = tabpanel.getActiveTab();
								 if(!isNullOrEmpty(activeTab) && activeTab != undefined){
									 if(activeTab.itemId == 'studentNegativeIncidentDetails'){
										 this.deleteNegativeIncidentDocument();
									 }else{
										 this.deleteIncidentDocument();
									 }
								 }
							 }
						 }
					 }
				 },

				 'positiveincidentdocumentlist[itemId=studentPositiveIncidentReportDocument] positiveincidentdocumentlistgrid button[itemId=downloadDocumentItemId]':{
					 click:function(obj){
						 //this.incidentDocumentReportDocumentZip();
						 if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
							 if(this.getContentPanel().getActiveTab().contentXtype == 'positiveincidentgrid' ){
								 this.incidentDocumentReportDocumentZip('positive');
							 }else{
								 this.incidentDocumentReportDocumentZip('negative');
							 }
						 }else{
							 var activeTab;
							 var tabpanel = Ext.ComponentQuery.query('personinfopanel')[0];
							 if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
								 activeTab = tabpanel.getActiveTab();
								 if(!isNullOrEmpty(activeTab) && activeTab != undefined){
									 if(activeTab.itemId == 'studentNegativeIncidentDetails'){
										 this.incidentDocumentReportDocumentZip('negative');
									 }else{
										 this.incidentDocumentReportDocumentZip('positive');
									 }
								 }
							 }	
						 }
					 }
				 },

				 'positiveincidentdocumentlistgrid button[itemId=btnDelete]':{
					 click:function(obj){
						 this.deleteDocument();
					 }
				 },

				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid], negativeincidentgrid[itemId=studentNegativeIncidentGrid]':{
					 //'studentpositiveincidentgrid[itemId=studentPositiveIncidentGrid],studentnegativeincidentgrid[itemId=studentNegativeIncidentGrid]':{ 
					 cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
						 var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//						 var documentId = record.data.document.id;
						 if(columnName == "documents"){
							 if(e.target.tagName=='A'){
								 if(record.data.documents.length == 1){
									 var whetherFile = false;
									 var documentId= record.data.documents["0"].id;
									 if(!isNullOrEmpty(documentId)){
										 Ext.Ajax.request({
											 type: 'rest',
											 url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											 method: 'GET',
											 callback : function(opt, success, response){
												 if(response.responseText == 'true') {
													 var csvForm = Ext.create('Ext.form.Panel'); 
													 csvForm.getForm().submit({
														 target: '_blank',
														 method:'GET',
														 params :{
															 access_token : Ext.Ajax.defaultHeaders.access_token
														 },
														 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														 url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														 standardSubmit :true
													 });
												 } else {
													 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												 }
											 }
										 });
									 }} else if(record.data.documents.length > 1){
										 var docWindow = this.getPositiveincidentdocumentlist();
										 var ID = record.data.id;
										 if (!docWindow) {
											 Ext.widget('positiveincidentdocumentlist');
											 docWindow = Ext.widget('positiveincidentdocumentlist',{
												 itemId:'studentPositiveIncidentReportDocument'
											 });
											 docWindow = this.getPositiveincidentdocumentlist();
										 }

										 //Code to check if positive documents popup or negative documents popup
										 if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7)
										 {
											 if(this.getContentPanel().getActiveTab().contentXtype == 'positiveincidentgrid')
											 {
												 docWindow.title = getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENTS');
											 }else{
												 docWindow.title = getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENTS');
											 }
										 }else{
											 var activeTab;
											 var tabpanel = Ext.ComponentQuery.query('personinfopanel')[0];
											 if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
												 activeTab = tabpanel.getActiveTab();
												 if(!isNullOrEmpty(activeTab) && activeTab != undefined){
													 if(activeTab.itemId == 'studentNegativeIncidentDetails'){
														 docWindow.title = getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENTS');
													 }else{
														 docWindow.title = getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENTS');
													 }
												 }
											 }
										 }

										 docWindow.show();
										 docWindow.down('form').down('#incidentDate').setValue(dateRender(record.data.incidentDate));
										 docWindow.down('form').down('#type').setValue(record.data.type.value);
										 docWindow.down('form').down('#actionTaken').setValue(record.data.actionTaken);
										 var positiveincidentdocumentlistgrid = docWindow.down('#positiveincidentdocumentlistgridItemId');
										 positiveincidentdocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
										 var portalId = this.getCurrentLoggedPortalId();
										 if(portalId==3)
										 {
											 docWindow.down("#btnDelete").setVisible(false);
										 }
										 var store = positiveincidentdocumentlistgrid.getStore();
										 store.getProxy().extraParams = {
											 ID: record.data.id
										 };
										 store.load();
										 // var a = Ext.ComponentQuery.query('positiveincidentgrid')[0];
										 var portalId = this.getCurrentLoggedPortalId();
										 if(portalId == 2){
											 this.doAccessFacultyPositiveIncidentGridDeleteButton(positiveincidentdocumentlistgrid,this.getFACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
										 }else if(portalId == 1)
										 {
											 this.doAccessFacultyPositiveIncidentGridDeleteButton(positiveincidentdocumentlistgrid,this.getSTUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
										 }

									 }
							 }
						 }else if(columnName == "studentsInvolved"){
							 if(e.target.tagName=='A'){
								 this.showStudentIncidentCountWindow(record);
							 }
						 }

					 }
				 },
				 'documentformwindow[itemId=student_positive_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
					 click : function() {
						 var $this = this;
						 var isTransient = true;
						 if($this.getPersonCommonWindow().title=="Negative Incidents")
						 {
							 var module = 'negativeIncident';
							 var entityType = 'negativeIncidentDocument';
						 }else
						 {
							 var module = 'positiveIncident';
							 var entityType = 'positiveIncidentDocument';
						 }

						 var entityId;

						 $this
						 .getDocumentController()
						 .saveDocumentForm(
								 entityId,
								 module,
								 entityType,
								 'DOCUMENT',
								 function(success,
										 response,
										 isCallBackTransient) {
									 var documentModel = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentModel();
									 documentModel
									 .set(
											 "documentName",
											 response.name);
									 documentModel
									 .set(
											 "path",
											 response.path);
									 documentModel
									 .set(
											 "type",
											 response.type);
									 documentModel
									 .set(
											 "documentName",
											 response.name);
									 documentModel
									 .set(
											 "createdBy",
											 $this
											 .getIdValueJson(
													 response.createdBy.id,
													 response.createdBy.value));
									 var positiveincidentDocGrid = $this
									 .getPositiveincidentdocumentgrid();
									 if(!positiveincidentDocGrid) {
										 positiveincidentDocGrid = Ext.widget('positiveincidentdocumentgrid');
									 }
									 var store = positiveincidentDocGrid
									 .getStore();
									 store
									 .add(documentModel);
									 if (positiveincidentDocGrid
											 .isHidden()
											 && store.data.items.length > 0) {
										 positiveincidentDocGrid
										 .setVisible(true);
									 }
									 $this
									 .getDocumentController()
									 .closeDocumentFormWindow();

									 var activeTab;
									 var tabpanel = Ext.ComponentQuery.query('personinfopanel')[0];
									 if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
										 activeTab = tabpanel.getActiveTab();
										 if(!isNullOrEmpty(activeTab) && activeTab != undefined){
											 if(activeTab.itemId == 'studentNegativeIncidentDetails'){
												 showSuccessMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'),getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
											 }else{
												 showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'),getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
											 }
										 }
									 }
								 }, isTransient);
					 }
				 },
				 'documentformwindow[itemId=student_positive_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
					 click : function() {
						 this.getDocumentController()
						 .closeDocumentFormWindow();
					 }
				 },
				 'negativeincidentform[itemId=studentNegativeIncidentForm] button#uploadPositiveIncidentItemId' : {
					 click : function() {
						 this
						 .getDocumentController()
						 .showDocumentFormWindow(
								 'student_positive_hidden_field',
						 'DOCUMENT');
					 }
				 },
				 'positiveincidentform[itemId=studentPositiveIncidentForm] button#uploadPositiveIncidentItemId' : {
					 click : function() {
						 this
						 .getDocumentController()
						 .showDocumentFormWindow(
								 'student_positive_hidden_field',
						 'DOCUMENT');
					 }
				 },
				 'positiveincidentdocumentgrid button#btnDelete' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getPositiveincidentdocumentgrid();
						 var negativeincidentgrid= $this.getNegativeincidentgrid();
						 var positiveincidentgrid= $this.getPositiveincidentgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 Ext.MessageBox.confirm(
									 getCommonTranslation('INCIDENT'),
									 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									 function(btn, text) {
										 if (btn == 'yes') {
											 var store = grid.getStore();
											 var record = grid.getSelectionModel().getSelection()[0];
											 var id = record.get("id");
											 if (!isNullOrEmpty(id)) {
												 Ext.Ajax.request({
													 method : "DELETE",
													 type : 'rest',
													 url : SERVERURL.INCIDENT_ACTION_DOCUMENT_DELETE+'?fileDocumentIds='+id,
													 headers : {
														 'Content-Type' : 'application/json'
													 },
													 success : function( form,action) {store.reload();
													 if(!isNullOrEmpty(negativeincidentgrid)){
														 negativeincidentgrid.getStore().reload(); 
														 negativeincidentgrid.getSelectionModel().deselectAll(true);
													 }
													 if(!isNullOrEmpty(positiveincidentgrid)){
														 positiveincidentgrid.getStore().reload(); 
														 negativeincidentgrid.getSelectionModel().deselectAll(true);
													 }
														 showSuccessMessage(getCommonTranslation('INCIDENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
													 }
												 });
											 }else{
												 if (record) {
													 store.remove(record);
													 showSuccessMessage(getCommonTranslation('INCIDENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
												 }
											 }

										 }
									 });
						 } else {
							 showWarningMessage( getCommonTranslation('INCIDENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
						 }
					 }
				 },
				 'positiveincidentdocumentgrid' : {
					 cellclick : function(grid, td,
							 cellIndex, record, tr,
							 rowIndex, e, eOpts) {
						 var $this = this;
						 var documentGrid = $this
						 .getPositiveincidentdocumentgrid();
						 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

						 if (columnName == "documentName") {
							 if (e.target.tagName == 'A') {
								 var documentId = record
								 .get("documentId");
								 if (!isNullOrEmpty(documentId)) {
									 $this
									 .getDocumentController()
									 .downloadDocumentFile(
											 documentId);
								 }
							 }
						 }
					 }
				 },
				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid]': {
					 //'studentpositiveincidentgrid[itemId= studentPositiveIncidentGrid]': {
					 render: function(grid) {
						 this.loadGridStore('#studentPositiveIncidentGrid', SERVERURL.POSITIVE_INCIDENT_GRIDDATA);
						 var portalId = this.getCurrentLoggedPortalId();
						 if(portalId == 7){
							 this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
						 }else if(portalId == 2){
							 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
							 this.doAccessControlValidationOfAddStudent(grid, this.getFACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS(),'POSITIVE_INCIDENT');
						 }else if(portalId == 3){
							 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
						 }else{
							 this.doAccessControlValidation(grid, this.getSTUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
							 this.doAccessControlValidationOfAddStudent(grid, this.getSTUDENT_POSITIVE_INCIDENTS_PERMISSIONS(),'POSITIVE_INCIDENT');
						 }
				 },
				 afterrender:function(grid){
						var me = this;
						if(portalId == 7) {
							me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
					    }else if(portalId == 2) {
							me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
						}else if(portalId == 3) {
							me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
						}else {
							me.addDataGridConfigButton(grid,me.getSTUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
						}

					}
				 },
				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnAdd]': {
					 //'studentpositiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnAdd]': {
					 click: function() {
						 var me=this;
						 me.showPersonCommonWindow('POSITIVE_INCIDENT', 'studentPositiveIncidentForm');
						 me.setReporterForPosstiveDisciplinaryActions(false);
						 var form=this.getPositiveincidentform();
		        		 var isParent=form.down('#parentId');
		        		 var isTeacher=form.down('#teacherId');
		        		 isTeacher.setValue(true);
		        		 isParent.setValue(true);
					 }
				 },
				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnEdit]': {
					 //'studentpositiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnEdit]': {
					 click: function(){
						 var me= this;
						 me.editPositiveActionFormWindow('POSITIVE_INCIDENT', 'studentPositiveIncidentForm', '#studentPositiveIncidentGrid');
						 me.setReporterForPosstiveDisciplinaryActions(true);
						 /*me.studentDocPositiveIncidentsContainerWindow();*/
					 }
				 },
				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnView]': {
					 //'studentpositiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnView]': {	
					 click: function(){
						 this.viewPositiveActionFormWindow('POSITIVE_INCIDENT', 'studentPositiveIncidentForm', '#studentPositiveIncidentGrid');
					 }
				 },
				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnDelete]': {
					 //'studentpositiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnDelete]': {
					 click: function(){
						 //this.deletePositiveActionRecord('#studentPositiveIncidentGrid', SERVERURL.INCIDENT_ACTION_DELETE);
						 this.deletePositiveActionRecord('#studentPositiveIncidentGrid', SERVERURL.POSITIVE_INCIDENT_ACTION_DELETE);
					 }
				 },
				 'positiveincidentgrid[itemId=studentPositiveIncidentGrid] button[itemId=btnAddStudentsPositive]': {
					 click: function(me, e, eOpts){
						 var type = 'POSITIVE_INCIDENTS';
						 this.showAddStudentsWindow(me, e, eOpts, type);
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=studentPositiveIncidentForm] combo[itemId=reportedByField]': {
					 select: function(combo) {
						 this.showHidePositiveReportedField(combo);
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=studentPositiveIncidentForm] nestedJsonCombo[itemId=typeOfIncidentCombo]': {
					 beforerender : function(combo){
						 combo.store.proxy.extraParams = {
								 category: 'POSITIVE'
						 };
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=studentPositiveIncidentForm] customcombobox[itemId=reportedByUserIdField]': {
					 select : function(combo, records, eOpts){
						 this.validatePositiveReportedIdField(combo, records, eOpts);
					 }
				 },
				 /*'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] customcombobox[itemId=reportedByUserIdField]': {
                select : function(combo, records, eOpts){
                	this.validatePositiveReportedIdField(combo, records, eOpts);
                }
            },*/
				 'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=studentPositiveIncidentForm] button[itemId=submitButtonId]': {
					 click: function(){
						 this.savePositiveAction('#studentPositiveIncidentGrid', SERVERURL.INCIDENT_ACTION_ADD, SERVERURL.INCIDENT_ACTION_UPDATE);
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] positiveincidentform[itemId=studentPositiveIncidentForm] button[itemId=cancelButtonId]': {
					 click: this.closePersonCommonWindow
				 },
				 /**
				  * Negative Action
				  */
				 'negativeincidentgrid[itemId=studentNegativeIncidentGrid]': {
					 //'studentnegativeincidentgrid[itemId=studentNegativeIncidentGrid]': {
					 render: function(grid) {
						 var $this = this;
						 $this.loadGridStore('#studentNegativeIncidentGrid', SERVERURL.NEGATIVE_INCIDENT_GRIDDATA);
						 var portalId = $this.getCurrentLoggedPortalId();
						 if(portalId == 7){
							 $this.doAccessControlValidation(grid, $this.getPARENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
						 }else if(portalId == 2){
							 $this.doAccessControlValidation(grid, $this.getFACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
							 $this.doAccessControlValidationOfAddStudent(grid, $this.getFACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS(),'NEGATIVE_INCIDENT');
						 }else if(portalId == 3){
							 $this.doAccessControlValidation(grid, $this.getSTUDENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
						 }else{
							 $this.doAccessControlValidation(grid, $this.getSTUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
							 $this.doAccessControlValidationOfAddStudent(grid, $this.getSTUDENT_NEGATIVE_INCIDENTS_PERMISSIONS(),'NEGATIVE_INCIDENT');
						 }

				 },
				 afterrender:function(grid){
						var me = this;
						if(portalId == 7) {
							me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
					    }else if(portalId == 2) {
							me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
						}else if(portalId == 3) {
							me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
						}else {
							me.addDataGridConfigButton(grid,me.getSTUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
						}

					}
				 },
				 'negativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnAdd]': {
					 //'studentnegativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnAdd]': {
					 click: function() {
						 var me=this;
						 me.showPersonCommonWindow('NEGATIVE_INCIDENTS', 'studentNegativeIncidentForm');
						 me.setReporterForNagativeDisciplinaryActions(false);
						 var form=this.getNegativeincidentform();
		        		 var isParent=form.down('#parentId');
		        		 var isTeacher=form.down('#teacherId');
		        		 isTeacher.setValue(true);
		        		 isParent.setValue(true);
		        		 var assessmentEventComboBox = form.down('nestedJsonCombo#assessmentEventId');
		        		 this.loadDFRForAssessmentEventVisibility(assessmentEventComboBox);
					 }
				 },
				 'negativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnEdit]': {
					 //'studentnegativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnEdit]': {
					 click: function(){
						 var me=this;
						 var form=this.getNegativeincidentform();
						 me.editNegativeActionFormWindow('NEGATIVE_INCIDENTS', 'studentNegativeIncidentForm', '#studentNegativeIncidentGrid');
						 me.setReporterForNagativeDisciplinaryActions(true);
						 me.studentDocNegativeIncidentsContainerWindow();
						 if(!form){
							 form = this.getPersonNegativeIncidentForm();
						 }
						 var assessmentEventComboBox = form.down('nestedJsonCombo#assessmentEventId');
		        		 this.loadDFRForAssessmentEventVisibility(assessmentEventComboBox);
					 }
				 },
				 'negativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnView]': {
					 //'studentnegativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnView]': {
					 click: function(){
						 this.viewNegativeActionFormWindow('NEGATIVE_INCIDENTS', 'studentNegativeIncidentForm', '#studentNegativeIncidentGrid');
					 }
				 },
				 'negativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnDelete]': {
					 //'studentnegativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnDelete]': {
					 click: function(){
						 //this.deleteNegativeActionRecord('#studentNegativeIncidentGrid', SERVERURL.INCIDENT_ACTION_DELETE);
						 this.deleteNegativeActionRecord('#studentNegativeIncidentGrid', SERVERURL.NEGATIVE_INCIDENT_ACTION_DELETE);
					 }
				 },
				 'negativeincidentgrid[itemId=studentNegativeIncidentGrid] button[itemId=btnAddStudentsNegative]': {
					 click: function(me, e, eOpts){
						 var type = 'NEGATIVE_INCIDENTS';
						 this.showAddStudentsWindow(me, e, eOpts, type);
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] combo[itemId=reportedByField]': {
					 select: function(combo) {
						 this.showHideNegativeReportedField(combo);
					 }
				 },
				 //'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] livesearchcombo[itemId=reportedByUserIdField]': {
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] customcombobox[itemId=reportedByUserIdField]': {
					 select : function(combo, records, eOpts){
						 this.validateNegativeReportedIdField(combo, records, eOpts);
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] nestedJsonCombo[itemId=typeOfIncidentCombo]': {
					 beforerender : function(combo){
						 combo.store.proxy.extraParams = {
								 category: 'NEGATIVE'
						 };
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] nestedJsonCombo[itemId=courseVarientId]': {
				   render : function(combo){
					 var personProfile = this.getContentPanelActiveTab();
					 combo.getStore().proxy.extraParams = {
							 studentId:personProfile.getUserId()
					 };
					 combo.getStore().load();
				  },
		                select: function(obj1, record) {
		                    var assessmentEventComboBox = obj1.up('form').down('nestedJsonCombo#assessmentEventId');
		                    assessmentEventComboBox.setDisabled(false);
		                    assessmentEventComboBox.clearValue();
		                    var form = this.getNegativeincidentform();
		                    var personProfile = this.getContentPanelActiveTab();
		                    var courseVarientId = record[0].get("courseVariantId");
		                    var store = assessmentEventComboBox.getStore();
		                   // this.loadDFRForAssessmentEventVisibility(assessmentEventComboBox);
		                    store.getProxy().extraParams = {
		                    	courseVariantId : courseVarientId,
		                    	studentId : personProfile.getUserId()
		                    };
		                    store.reload();
		                },
		                change: function(obj1, newValue) {
		                    var assessmentEventComboBox = obj1.up('form').down('nestedJsonCombo#assessmentEventId');
		                    var store = assessmentEventComboBox.getStore();
		                    var personProfile = this.getContentPanelActiveTab();
		                    store.getProxy().extraParams = {
		                    	courseVariantId : newValue,
		                    	studentId : personProfile.getUserId()
		                    };
		                    store.load();
		                    if(!isNullOrEmpty(newValue)){                   
		                    	assessmentEventComboBox.setDisabled(false);
		                       }else{
		                    	assessmentEventComboBox.setDisabled(true); 
		                    	assessmentEventComboBox.allowBlank = true;
		                    	assessmentEventComboBox.clearValue();
		                    	
		                    }
		               }
				 },
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] nestedJsonCombo[itemId=assessmentEventId]': {
			             select: function(obj1, record) {
			            	var form = obj1.up('form');
			                if(form.isValid()){
			                	form.down('#submitButtonId').setDisabled(false);
			                }else{
			                	form.down('#submitButtonId').setDisabled(true);
			                }
			              }
					 },
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] button[itemId=submitButtonId]': {
					 click: function(){
						 this.saveNegativeAction('#studentNegativeIncidentGrid', SERVERURL.INCIDENT_ACTION_ADD, SERVERURL.INCIDENT_ACTION_UPDATE);
					 }
				 },
				 'personcommonwindow[itemId=personCommonWindow] negativeincidentform[itemId=studentNegativeIncidentForm] button[itemId=cancelButtonId]': {
					 click: this.closePersonCommonWindow
				 },
				 'sanctiondetailsgrid button[itemId=btnAdd]':{
					 click: function(button) {
						 var grid = this.getSanctiondetailsgrid();
						 //var getStaffStructure = grid.up('staffdetailsmanagetargettabstructure');
						 this.addNewRowSanctionDetailsSUGrid(1, grid);
					 }
				 },
				 'sanctiondetailsgrid': {
					 afterrender:function(grid){
		   	           	Ext.defer(function(){
			   	           	var gridDom = grid.el ? grid.el.dom : null;
		   	           	    gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
		   	           	},2000)	
		   	           },
					 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
						 var $this = this;
						 var grid = $this.getSanctiondetailsgrid();
						 // var getStaffStructure = grid.up('staffdetailsmanagetargettabstructureapplication');
						 var columnName = grid.columnManager.columns[cellIndex].dataIndex;

						 if (e.target.tagName == 'DIV') {
							 if (columnName == "addButton") {
								 if (e.target.className == "addButtonClsForGridActionCls") {
									 if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
										 var serialNo;
										 if (grid.getStore() != null)
											 serialNo = grid.getStore().getCount();
										 this.addNewRowSanctionDetailsSUGrid(serialNo + 1, grid);
									 }
								 }
							 } else if (columnName == "deleteButton") {
								 if (e.target.className == "deleteButtonClsForGridActionCls") {
									 //var getStaffStructure = $this.getStaffdetailsmanagetargettabstructureapplication();
									 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)) {
										 if (grid.getStore().getRange().length > 0) {
											 grid.getStore().removeAt(rowIndex);
											 if(grid.getStore().getRange().length == 0){
												 grid.down('#btnAdd').show();
											 }
											grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount());
										 }
									 }
								 }
							 }
						 }
						 var gridDom = grid.el ? grid.el.dom : null;
		   	           	    gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
					 }/*,
    	        render:function(grid){
    	          var DisciplinaryActionGrid = this.getDisciplinaryactionsugrid();
    	          var records = DisciplinaryActionGrid.getSelectionModel().getSelection()[0];
    	          var store = grid.getStore();
    	          if(!isNullOrEmpty(records)){
   				  store.getProxy().extraParams = {
   					  id: records.data.id
   				  };
    	          }
   				  store.load();
    	        }*/
				 },
				 'disciplinaryactionsugrid[itemId=studentDisciplinaryActionSUGrid] button[itemId=btnEdit]': {
					 click: function(){
						 var me =this;
						 me.editDisciplinaryActionFormSUWindow('DISCIPLINARY_ACTION_SU', 'studentDisciplinaryActionFormSU', '#studentDisciplinaryActionSUGrid');
						 //me.setReporterForPosstiveDisciplinaryAction(true);
					 }
				 },
				 'disciplinaryactionsugrid[itemId=studentDisciplinaryActionSUGrid] button[itemId=btnDelete]': {
					 click: function(){
						 this.deleteDisciplinaryActionSURecord('#studentDisciplinaryActionSUGrid', SERVERURL.PATH_DISCIPLINARY_ACTION_SU_DELETE);
					 }
				 },
				 'disciplinaryactionsugrid[itemId=studentDisciplinaryActionSUGrid] button[itemId=btnView]': {
					 click: function(){
						 this.viewDisciplinaryActionFormSUWindow('DISCIPLINARY_ACTION_SU', 'studentDisciplinaryActionFormSU', '#studentDisciplinaryActionSUGrid');
					 }
				 },
				 'disciplinaryactionformsu[itemId=studentDisciplinaryActionFormSU] disciplinaryactiondocumentgrid button#btnDelete' : {
					 click : function() {
						 var $this = this;
						 var grid = $this.getDisciplinaryactiondocumentgrid();
						 if (grid.getSelectionModel().getCount() > 0) {
							 var isSuccess = false;
							 showConfirmMessage(getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU'),
									 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
									 function(btn,text) {
								 if (btn == 'yes') {
									 var store = grid.getStore();
									 var record = grid.getSelectionModel().getSelection()[0];
									 var id = record.get("id");
									 if (!isNullOrEmpty(id)) { Ext.Ajax.request({
										 method : "DELETE",
										 type : 'rest',
										 url : SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL
										 + '?id='
										 + id,
										 headers : {
											 'Content-Type' : 'application/json'
										 },
										 success : function(form,action) {store.reload();
										 showSuccessMessage(getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU'),
												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));}
									 });
									 }else{
										 if (record) {store.remove(record);
										 showSuccessMessage(getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU'),
												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
										 }
									 }
								 }
							 });


						 } else {
							 showWarningMessage(getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU'),
									 getCommonTranslation('PLEASE_SELECT_RECORD')); 
						 }
					 }
				 }, 
				 'disciplinaryactionsugrid[itemId=studentDisciplinaryActionSUGrid] button[itemId=btnAddStudentsSU]': {
					 click: function(me, e, eOpts){
						 var type = 'DISCIPLINARY_ACTION_SU';
						 this.showAddStudentsWindowForDisciplinaryActionSu(me, e, eOpts, type);
						 this.hideNotifyStudentButton();
					 }
				 },
				 'button[itemId=addNewFieldContainerBtnSu]':{
					 click: function(btn){
						 this.addMoreFieldsOfProgramStudentSu(btn,'DISCIPLINARY_ACTION_SU');
					 }
				 },
				 'button[itemId=addNewFieldContainerBtnSu1]':{
					 click: function(btn){
						 this.addMoreFieldsOfProgramStudentSu(btn,'DISCIPLINARY_ACTION_SU');
					 }
				 },
				 'button[itemId=detailedDeleteButtonSu1]':{
					 click: function(btn){
						 this.deleteMoreFieldsOfProgramStudentSu(btn,'DISCIPLINARY_ACTION_SU');
					 }
				 },
				 'button[itemId=submitButtonItemIdSu]':{
					 click: function(btn){
						 this.saveStudentWindowFormSu('DISCIPLINARY_ACTION_SU');
					 }
				 },
				 'button[itemId=cancelButtonItemIdSu]':{
						click : this.hideAddStudentsWindowSu
					},
					/*'disciplinaryactiondocumentsulist  grid[itemId=periodGridWin1]':{
						  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(columnName == "documentName"){
								if(e.target.tagName=='A'){
									this.getDownloadFile(record.get('documentId'));
								}
							}
						}
					},*/
					'disciplinaryactiondocumentlistgridsu':{
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(columnName == "documentName"){
								if(e.target.tagName=='A'){
									this.getDownloadFile(record.get('documentId'));
								}
							}
						}
					},
					'disciplinaryactiondocumentsulist[itemId=studentDisciplinaryReportDocumentProfileSu] disciplinaryactiondocumentlistgridsu button[itemId=downloadDocumentSUItemId]':{
						click:function(obj){
							this.documentSUReportDocumentZip();
						}
					},
					'disciplinaryactiondocumentsulist[itemId=studentDisciplinaryReportDocumentProfileSu] disciplinaryactiondocumentlistgridsu button[itemId=btnDeleteSU]':{
						click:function(obj){
							this.deleteDisciplinarySUDocument();
						}
					},
					'positiveincidentdocumentgrid button#btnEdit' : {
						 click : function() {
							 var $this = this;
							 var grid = $this.getPositiveincidentdocumentgrid();
							 if (grid.getSelectionModel().getCount() > 0) {
								 var gridData = grid.getSelectionModel().getSelection();
								 var docId = gridData[0].data.id;
								 var documentName = gridData[0].data.documentName;
								 var pathValue = gridData[0].data.path;
								 $this.getDocumentController().showDocumentFormWindow('student_Document_positive_hidden_field','EDIT_DOCUMENT');
								 var getWindow = $this.getDocumenteditwithfileform();
								 getWindow.down('#document_hidden_field').setValue(docId);
								 getWindow.down('#documentNameField').setValue(documentName);
								 getWindow.down('#uploaded_document_file_hidden_field').setValue(pathValue);
							 }else {
								 showWarningMessage( getCommonTranslation('INCIDENT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
							 }
						 }
					 },
					 'documentformwindow[itemId=student_Document_positive_hidden_field] documenteditwithfileform[itemId=documenteditwithfileform] button#documentFormSubmitButtonId' : {
						 click : function() {
							 var $this = this;
							 var isTransient = true;
							 if($this.getPersonCommonWindow().title=="Negative Incidents")
							 {
								 var module = 'negativeIncident';
								 var entityType = 'negativeIncidentDocument';
							 }else{
								 var module = 'positiveIncident';
								 var entityType = 'positiveIncidentDocument';
							 }
							 var getWindow = $this.getDocumenteditwithfileform();
							 var documentID = getWindow.down('#document_hidden_field').getValue();
							 var uploadedDoc ='';
							 var uploadedDocRepeat ='';
							 uploadedDocRepeat = getWindow.down('#uploadFileField').getValue();
							 uploadedDoc = getWindow.down('#uploaded_document_file_hidden_field').getValue();
							 
							 var entityId;
							 if(uploadedDocRepeat==''){
								 
								var positiveincidentDocGrid = $this.getPositiveincidentdocumentgrid();
								var gridDataRecord = positiveincidentDocGrid.getSelectionModel().getSelection()[0];
								 var documentName = getWindow.down('#documentNameField').getValue();
								gridDataRecord.set("documentName", documentName);
								gridDataRecord.set("isEdit",true);
								  $this.getDocumentController().closeDocumentFormWindow();
								 var activeTab;
								 var tabpanel = Ext.ComponentQuery.query('personinfopanel')[0];
								 if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
								 activeTab = tabpanel.getActiveTab();
								 if(!isNullOrEmpty(activeTab) && activeTab != undefined){
									 if(activeTab.itemId == 'studentNegativeIncidentDetails'){
											 showSuccessMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'),getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
									 }else{
					  					 showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'),getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
				 						 }
				    				 }
										 }
							 }else{
								 getWindow.down('#document_hidden_field').setValue(null);
										 $this.getDocumentController().saveDocumentForm(entityId,module,entityType, 'EDIT_DOCUMENT', function(success,response,isCallBackTransient) {
											var positiveincidentDocGrid = $this.getPositiveincidentdocumentgrid();
											var gridDataRecord = positiveincidentDocGrid.getSelectionModel().getSelection()[0];
											gridDataRecord.set("documentName", response.name);
											gridDataRecord.set("isEdit",true);
											gridDataRecord.set("id", documentID);
											gridDataRecord.set("path", response.path);
											gridDataRecord.set("type", response.type);
											gridDataRecord.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
											 $this.getDocumentController().closeDocumentFormWindow();
											 var activeTab;
											 var tabpanel = Ext.ComponentQuery.query('personinfopanel')[0];
											 if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
											 activeTab = tabpanel.getActiveTab();
											 if(!isNullOrEmpty(activeTab) && activeTab != undefined){
												 if(activeTab.itemId == 'studentNegativeIncidentDetails'){
														 showSuccessMessage(getPersonModuleTranslation('NEGATIVE_INCIDENT'),getPersonModuleTranslation('NEGATIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
												 }else{
								  					 showSuccessMessage(getPersonModuleTranslation('POSITIVE_INCIDENT'),getPersonModuleTranslation('POSITIVE_INCIDENT_DOCUMENT_ADD_SUCCESSFULLY'));
							 						 }
							    				 }
													 }
												 }, isTransient); 
							 }
						 }
					 }
			});
		},



		getDocumentController : function() {
			var this$ = this;
			return this$
			.getController('Academia.controller.document.DocumentController');
		},
		getIdValueJson : function(id, value) {
			if (id)
				return {
				id : id,
				value : value
			};
		},
		getIdNameJson : function(id, name) {
			if (id)
				return {
				id : id,
				nameToBePrinted : name
			};
		},
		doAccessFacultyDAGridDeleteButton: function(grid, privilegesMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

			var btnDelete = grid.down('#btnDelete');
			btnDelete.setVisible(false);
			var isForStudent=false;
			var loggedInUserId = this.getCurrentlyLoggedInUser().id;
			var portalId = this.getCurrentLoggedPortalId();
			Ext.each(permissionList, function(privilege) {
				if(portalId == 1){
					if(privilege == 'PS_DOCUMENT_DELETE') {
						btnDelete.setVisible(true);
						isForStudent=true;
					}
				}else if(portalId == 2){
					if (privilege == 'FPS_DOCUMENT_DELETE') {
						btnDelete.setVisible(true);
						isForStudent=true;
					} 
				}
			});
			return isForStudent;
		},
		doAccessFacultyPositiveIncidentGridDeleteButton: function(grid, privilegesMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

			var btnDelete = grid.down('#btnDelete');
			btnDelete.setVisible(false);
			var isForStudent=false;
			var portalId = this.getCurrentLoggedPortalId();
			Ext.each(permissionList, function(privilege) {
				if(portalId == 1){
					if(privilege == 'PS_PI_DOC_DELETE'){
						btnDelete.setVisible(true);
					}
				} else if(portalId == 2){
					if(privilege == 'FPS_PI_DOC_DELETE'){
						btnDelete.setVisible(true);
					}
				}

			});
		},
		doAccessControlValidationOfStudentInvolvedDeleteButton: function(grid, privilegesMap, type) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
			var portalId = this.getCurrentLoggedPortalId();
			var gridColumns=grid.columns;
			var length = gridColumns.length;
			      if(length!=null && length!=""){
			        for(var i=0; i<length; i++){
			           if(gridColumns[i].dataIndex=='deleteButton'){
			           gridColumns[i].setVisible(false)
			         }
	             }
			   }
			Ext.each(permissionList, function(privilege) {
					if(portalId == 1)
					{
					   if(privilege == 'DELETE'){
                        var gridColumns=grid.columns;
					    var length = gridColumns.length;
					    if(length!=null && length!=""){
					    for(var i=0; i<length; i++){
					    if(gridColumns[i].dataIndex=='deleteButton'){
					     gridColumns[i].setVisible(true);
					      }
					       }
					        }
					         }
					
				}

			});
		},
		doAccessControlValidationOfAddStudent: function(grid, privilegesMap, type) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

			if( type == 'DISCIPLINARY_ACTIONS' ){
				var btnAddStudents =  grid.down('#btnAddStudents').setVisible(false);
			}
			if( type == 'POSITIVE_INCIDENT' ){
				var btnAddStudents =  grid.down('#btnAddStudentsPositive').setVisible(false);
			}
			if( type == 'NEGATIVE_INCIDENT' ){
				var btnAddStudents =  grid.down('#btnAddStudentsNegative').setVisible(false);
			}
			if( type == 'DISCIPLINARY_ACTIONS_SU' ){
				var btnAddStudents =  grid.down('#btnAddStudentsSU').setVisible(false);
			}


			btnAddStudents.setVisible(false);
			var portalId = this.getCurrentLoggedPortalId();
			Ext.each(permissionList, function(privilege) {
				if(portalId == 1){
					if(privilege == 'PS_ADD_STUDENTS'){
						btnAddStudents.setVisible(true);
					}
				} else if(portalId == 2){
					/*if(privilege == 'FPS_DOCUMENT_DELETE'){
    				btnAddStudents.setVisible(true);
    			}*/
					if(privilege == 'FPS_ADD_STUDENTS'){
						btnAddStudents.setVisible(true);
					}
				}

			});
		},
		hideAddStudentsWindow: function(){
			if(Ext.isDefined(Ext.ComponentQuery.query('#addStudentsWindow')[0])){
				Ext.ComponentQuery.query('#addStudentsWindow')[0].destroy();
			}
		},
		showAddStudentsWindow: function(me, e, eOpts, type){
			if(Ext.isDefined(Ext.ComponentQuery.query('#addStudentsWindow')[0])){
				Ext.ComponentQuery.query('#addStudentsWindow')[0].destroy();
			}
			var selectedRecord = me.up('grid').getSelectionModel().selected.items[0].data;
			selectedRecord.dateOfAction1 = dateRender(selectedRecord.dateOfAction);
			selectedRecord.incidentDate1 = dateRender(selectedRecord.incidentDate);
			if(Ext.isDefined(localStorage.getItem('PROGRAM_ID')) && !isNullOrEmpty(localStorage.getItem('PROGRAM_ID'))){
				selectedRecord.defaultProgramId = parseInt(localStorage.getItem('PROGRAM_ID'));
			}
			else {
				selectedRecord.defaultProgramId = 0;
			}
			selectedRecord.programItem = selectedRecord.defaultProgramId;

			var formData = {};
			formData.reportedByUserName = selectedRecord.reportedByUserName;
			formData.dateOfAction1 = dateRender(selectedRecord.dateOfAction);
			formData.incidentDate1 = dateRender(selectedRecord.incidentDate);

			if( type == 'DISCIPLINARY_ACTIONS' ){
				formData.type = selectedRecord.incidentType.value;
			}
			if( type == 'POSITIVE_INCIDENTS' || type == 'NEGATIVE_INCIDENTS' ){
				formData.type = selectedRecord.type.value;
			}

			formData.id = selectedRecord.id;

			var submitButtonItemId;
			var cancelButtonItemId;
			var addNewFieldContainerBtn;

			if( type == 'DISCIPLINARY_ACTIONS' ){
				submitButtonItemId = 'addStudentsWindowFormSubmitButtonId';
				cancelButtonItemId = 'addStudentsWindowFormCancelButtonId';
				addNewFieldContainerBtn = 'addNewFieldContainerBtn';
			}
			if( type == 'POSITIVE_INCIDENTS' ){
				submitButtonItemId = 'addStudentsWindowFormSubmitButtonIdPositive';
				cancelButtonItemId = 'addStudentsWindowFormCancelButtonIdPositive';
				addNewFieldContainerBtn = 'addNewFieldContainerBtnPositive';
			}
			if( type == 'NEGATIVE_INCIDENTS' ){
				submitButtonItemId = 'addStudentsWindowFormSubmitButtonIdNegative';
				cancelButtonItemId = 'addStudentsWindowFormCancelButtonIdNegative';
				addNewFieldContainerBtn = 'addNewFieldContainerBtnNegative';
			}

			var addStudentsWindow = Ext.create('Ext.window.Window', {
				alias: 'widget.addStudentsWindow',
				itemId: 'addStudentsWindow',
				modal: true,
				resizable: false,
				autoScroll: true,
				frame: true,
				width: 630,
				minHeight: 290,
				height: 290,
				maxHeight : 370,
				title: getCommonTranslation('ADD_STUDENTS'),
				items: [{
					xtype: 'form',
					layout: 'vbox',
					frame: false,
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						height: 60,
						defaults: {
							labelAlign: 'top',
							width: 200
						},
						items:[{
							xtype: 'hidden',
							name: 'id',
							itemId: 'id'
						},
						/*{
    	            	xtype: 'hidden',
    	            	name: 'positiveIncidentId',
    	                itemId: 'positiveIncidentId'
    	            },
    	            {
    	            	xtype: 'hidden',
    	            	name: 'negativeIncidentId',
    	                itemId: 'negativeIncidentId'
    	            },*/
						{
							xtype: 'hidden',
							name: 'defaultProgramId',
							itemId: 'defaultProgramId'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('TYPE_OF_INCIDENT'),
							name: 'type',
							itemId: 'type'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('INCIDENT_DATE'),
							name: 'incidentDate1',
							itemId: 'incidentDate1'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('REPORTER_NAME'),
							name: 'reportedByUserName',
							itemId: 'reportedByUserName'
						}]
					},{
						xtype:'panel',
						itemId:'classStudentPanel',
						layout : 'vbox',
						width: '100%',
						marginTop:'30px',
						height: 'auto',
						padding: 0,
						autoScroll: false,
						style:{
							marginLeft:'0px'
						},
						items:[{
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '0 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'programItem',
								itemId:'programItemId',
								store: 'common.ProgramStore',
								fieldLabel: getCommonTranslation('PROGRAM'),
								valueField: 'id',
								displayField: 'valueCode',
								queryParam: 'qry',
								//minChars: 3,
								editable: false,
								allowBlank: false,
								typeAhead: false,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection: true,
								listConfig: {
									listeners: {
										beforeshow: function(
												picker) {
											picker.minWidth = picker
											.up('combobox')
											.getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{code} / {value}' +
										'</div>';
									}
								},
								listeners: {
									change: function(me, newValue, oldValue, eOpts){
										me.up('fieldcontainer').down('#studentId').reset();
										me.up('fieldcontainer').down('#studentId').clearValue();

										var form = Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form');
										var formValues = form.getForm().getFieldValues();        


										if( type == 'DISCIPLINARY_ACTIONS' ){
											me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
												programIds: newValue,
												//academyLocationIds: localStorage.getItem('academylocationid'),
												isDisciplinaryAddStudentsScreen: true,
												disciplinaryActionId: formValues.id
											};
										}
										if( type == 'POSITIVE_INCIDENTS' || type == 'NEGATIVE_INCIDENTS' ){
											me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
												programIds: newValue,
												//academyLocationIds: localStorage.getItem('academylocationid'),
												isDisciplinaryAddStudentsScreen: true,
												incidentUniqueIdentifier: selectedRecord.uniqueIdentifier
											};
										}

										me.up('fieldcontainer').down('#studentId').getStore().load();
									},
									afterrender: function(combo){
										combo.getStore().load({
											callback: function(){
												setTimeout(function(){
													combo.setValue(combo.findRecordByValue(parseInt(selectedRecord.defaultProgramId)));
												},300);
											}
										});
									}
								}
							},
							{
								xtype: 'customcombobox',
								name: 'STUDENT_ID',
								itemId: 'studentId',
								fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
								store: Ext.create('Academia.store.programCourseDashboard.Student'),
								valueField: 'id',
								width: 226,
								displayField: 'valueCode',
								queryParam:'studentNameOrCode',
								triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
								enableKeyEvents  : 'true',
								minChars:3,
								forceSelection:true,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								triggerAction: '',
								hideTrigger:false,
								allowBlank: false,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{studentCode} / {studentName}' +
										'</div>';
									}
								}
							},
							{
								xtype: 'button',
								//itemId: 'addNewFieldContainerBtn',
								itemId: addNewFieldContainerBtn,
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								width: 'auto',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]
						}]
					},
					{
						xtype : 'fieldcontainer',
						width : '100%',
						cls : 'windowBtnPos',
						items : [ {
							xtype : 'button',
							action : 'Submit',
							text : getCommonTranslation('SAVE'),
							//itemId : 'addStudentsWindowFormSubmitButtonId',
							itemId : submitButtonItemId,
							ui : 'CustomBtnSubmit',
							scale : CONSTANTS.BUTTONSIZE,
							formBind : true
						}, {
							xtype : 'button',
							//itemId : 'addStudentsWindowFormCancelButtonId',
							itemId : cancelButtonItemId,
							text : getCommonTranslation('CANCEL'),
							ui : 'CustomBtnCancel',
							scale : CONSTANTS.BUTTONSIZE
						} ]
					}]
				}]
			});
			var addStudentsWindowForm=Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form'); 
			var programField=addStudentsWindowForm.down('#programItemId'); 
			var studentField=addStudentsWindowForm.down('#studentId'); 
			this.setAllowBlank(programField,false); 
			this.setAllowBlank(studentField,false); 
			addStudentsWindow.show(); 
			addStudentsWindow.down('form').getForm().setValues(formData);
		},
		addMoreFieldsOfProgramStudent: function(btn,type){

			var addNewFieldContainerBtn1;
			var detailedDeleteButton1;

			if( type == 'DISCIPLINARY_ACTIONS' ){
				addNewFieldContainerBtn1 = 'addNewFieldContainerBtn1';
				detailedDeleteButton1 = 'detailedDeleteButton1';
			}
			if( type == 'POSITIVE_INCIDENTS' ){
				addNewFieldContainerBtn1 = 'addNewFieldContainerBtn1Positive';
				detailedDeleteButton1 = 'detailedDeleteButton1Positive';
			}
			if( type == 'NEGATIVE_INCIDENTS' ){
				addNewFieldContainerBtn1 = 'addNewFieldContainerBtn1Negative';
				detailedDeleteButton1 = 'detailedDeleteButton1Negative';
			}

			var $this = this;

			var addStudentsWindowForm=Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form');
			var panelContiner = addStudentsWindowForm.down('#classStudentPanel');
			var defaultProgramId = addStudentsWindowForm.getValues().defaultProgramId;
			var panelItem = new Array();
			panelItem.push({
				xtype : 'fieldcontainer',
				layout : 'hbox',
				width: '100%',
				scope: $this,
				defaults : {
					labelAlign : 'top',
					width:'226'
				},
				layout : {
					type : 'hbox'
				},
				margin: '10 0 0 0',
				padding: '0 0 0 0',
				items:[{
					xtype: 'customcombobox',
					width: 226,
					name: 'programItem',
					itemId:'programItemId',
					store: 'common.ProgramStore',
					fieldLabel: '',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam: 'qry',
					minChars: 3,
					editable: false,
					typeAhead: false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection: true,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(
									picker) {
								picker.minWidth = picker
								.up('combobox')
								.getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					},
					listeners: {
						change: function(me, newValue, oldValue, eOpts){
							me.up('fieldcontainer').down('#studentId').reset();
							me.up('fieldcontainer').down('#studentId').clearValue();

							var form = Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form');
							var formValues = form.getForm().getFieldValues();        
							var disciplinaryActionId = formValues.id;

							if( type == 'DISCIPLINARY_ACTIONS' ){
								me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
									programIds: newValue,
									//academyLocationIds: localStorage.getItem('academylocationid'),
									isDisciplinaryAddStudentsScreen: true,
									disciplinaryActionId: formValues.id
								};
							}

							if( type == 'POSITIVE_INCIDENTS' || type == 'NEGATIVE_INCIDENTS' ){

								var gridItemId;
								if( type == 'POSITIVE_INCIDENTS' ){
									gridItemId = '#studentPositiveIncidentGrid';
								}
								if( type == 'NEGATIVE_INCIDENTS' ){
									gridItemId = '#studentNegativeIncidentGrid';
								}

								var currentGrid = $this.getActiveTabfromContentPanel().down(gridItemId);
								var selectedRecord = currentGrid.getSelectionModel().selected.items[0].data;

								me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
									programIds: newValue,
									//academyLocationIds: localStorage.getItem('academylocationid'),
									isDisciplinaryAddStudentsScreen: true,
									incidentUniqueIdentifier: selectedRecord.uniqueIdentifier
								};
							}

							/*me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
	            			programIds: newValue,
	            			academyLocationIds: localStorage.getItem('academylocationid'),
	            			disciplinaryActionId: disciplinaryActionId
	            		};*/
							me.up('fieldcontainer').down('#studentId').getStore().load();
						},
						afterrender: function(combo){
							combo.getStore().load({
								callback: function(){
									setTimeout(function(){

										var gridItemId;

										if( type == 'DISCIPLINARY_ACTIONS' ){
											gridItemId = '#studentDisciplinaryActionGrid';
											//var currentGrid = $this.getActiveTabfromContentPanel().down(gridItemId);
											//var selectedRecord = currentGrid.getSelectionModel().selected.items[0].data;
										}

										//var gridItemId;
										if( type == 'POSITIVE_INCIDENTS' ){
											gridItemId = '#studentPositiveIncidentGrid';
										}
										if( type == 'NEGATIVE_INCIDENTS' ){
											gridItemId = '#studentNegativeIncidentGrid';
										}

										var currentGrid = $this.getActiveTabfromContentPanel().down(gridItemId);
										var selectedRecord = currentGrid.getSelectionModel().selected.items[0].data;

										if(Ext.isDefined(localStorage.getItem('PROGRAM_ID')) && !isNullOrEmpty(localStorage.getItem('PROGRAM_ID'))){
											selectedRecord.defaultProgramId = parseInt(localStorage.getItem('PROGRAM_ID'));
										}
										else {
											selectedRecord.defaultProgramId = 0;
										}
										//selectedRecord.programItem = selectedRecord.defaultProgramId;

										combo.setValue(combo.findRecordByValue(parseInt(selectedRecord.defaultProgramId)));
									},300);
								}
							});
						}
					}
				},
				{
					xtype: 'customcombobox',
					name: 'STUDENT_ID',
					itemId: 'studentId',
					fieldLabel: '',
					store: Ext.create('Academia.store.programCourseDashboard.Student'),
					valueField: 'id',
					width: 226,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
				},
				{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					//itemId: 'detailedDeleteButton1',
					itemId: detailedDeleteButton1,
					width: 'auto',
					cls: 'CustomBodyBtnReject',
					tooltip: getCommonTranslation('DELETETOOLTIP'),
					style:{
						marginTop:'4px'
					}
				},
				{
					xtype: 'button',
					//itemId: 'addNewFieldContainerBtn1',
					itemId: addNewFieldContainerBtn1,
					width: 'auto',
					cls: 'CustomBodyBtnSettings',
					width: 'auto',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'4px'
					}
				}]

			});
			panelContiner.add(panelItem);
			this.hideShowDetails(panelContiner, type);
			panelContiner.doLayout();
		},
		deleteMoreFieldsOfProgramStudent: function(deleteButton, type) {
			var this$ = this;
			var form=Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form');
			var panelContiner = form.down('#classStudentPanel');
			var container = deleteButton.up('fieldcontainer');
			if (container != null && panelContiner != null) {
				if (panelContiner.items.length > 1) {
					panelContiner.remove(container);
					this$.hideShowDetails(panelContiner, type);
				}
			}
		},
		hideShowDetails: function(detailedPanel, type) {
			var this$ = this;
			var form = Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form');
			detailedPanel.items.each(function(item, index, items) {
				var addButton = item.getComponent(item.items.length - 1);
				if (index == (items - 1)) {
					if (addButton != null) {
						addButton.show();
					}
				} else {
					if (addButton != null) {
						addButton.hide();
					}
				}
			});

			var addStudentsWindowFormSubmitButtonId;
			if( type == 'DISCIPLINARY_ACTIONS' ){
				addStudentsWindowFormSubmitButtonId = 'addStudentsWindowFormSubmitButtonId';
			}
			if( type == 'POSITIVE_INCIDENTS' ){
				addStudentsWindowFormSubmitButtonId = 'addStudentsWindowFormSubmitButtonIdPositive';
			}
			if( type == 'NEGATIVE_INCIDENTS' ){
				addStudentsWindowFormSubmitButtonId = 'addStudentsWindowFormSubmitButtonIdNegative';
			}

			if(!form.getForm().hasInvalidField()){
				form.down('#'+addStudentsWindowFormSubmitButtonId).setDisabled(false);
			}
			else {
				form.down('#'+addStudentsWindowFormSubmitButtonId).setDisabled(true);
			}
		},
		saveStudentWindowForm: function(type){
			var this$ = this;
			var form = Ext.ComponentQuery.query('#addStudentsWindow')[0].down('form');
			var formValues = form.getForm().getFieldValues();        
			var disciplinaryAction = formValues.id;
			var incidentId = formValues.id;

			var selected = [];
			var WSDisciplinaryActionDetail = {};
			Ext.each(form.getForm().getFields().items, function(currentField){
				if(currentField.name=="STUDENT_ID"){
					if(!isNullOrEmpty(currentField.getValue())){
						var currentFieldRecord = currentField.findRecordByValue(currentField.getValue());
						if( type == 'DISCIPLINARY_ACTIONS' ){
							var newRecord = {
									personId:currentFieldRecord.data.personId,
									disciplinaryActionId: disciplinaryAction
							};
						}

						if( type == 'NEGATIVE_INCIDENTS' || type == 'POSITIVE_INCIDENTS' ){
							var newRecord = {
									personId:currentFieldRecord.data.personId,
									incidentId: incidentId
							};
						}

						selected.push(newRecord);
					}
				}
			});

			if( type == 'NEGATIVE_INCIDENTS' || type == 'POSITIVE_INCIDENTS' ){

				var submitUrlIncident;
				if( type == 'NEGATIVE_INCIDENTS' ){
					submitUrlIncident = SERVERURL.CREATE_INCIDENT_ADD_STUDENTS_POSITIVE_INCIDENT;
				}
				if( type == 'POSITIVE_INCIDENTS' ){
					submitUrlIncident = SERVERURL.CREATE_INCIDENT_ADD_STUDENTS_NEGATIVE_INCIDENT;
				}

				Ext.Ajax.request({
					type: 'rest',
					url: submitUrlIncident,
					method: 'POST',
					jsonData: selected,
					callback : function(opt, success, response){
						showSuccessMessage(getCommonTranslation('ADD_STUDENTS'),
								getCommonTranslation('RECORD_ADD_SUCCESS'));
						Ext.ComponentQuery.query('#addStudentsWindow')[0].destroy();

						var gridItemId;
						if( type == 'POSITIVE_INCIDENTS' ){
							gridItemId = '#studentPositiveIncidentGrid';
						}
						if( type == 'NEGATIVE_INCIDENTS' ){
							gridItemId = '#studentNegativeIncidentGrid';
						}
						this$.getActiveTabfromContentPanel().down(gridItemId).getStore().load();
					}
				});
			}

			if( type == 'DISCIPLINARY_ACTIONS' ){
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.CREATE_DISCIPLINARY_ACTION_DETAILS,
					method: 'POST',
					jsonData: selected,
					callback : function(opt, success, response){
						showSuccessMessage(getCommonTranslation('ADD_STUDENTS'),
								getCommonTranslation('RECORD_ADD_SUCCESS'));
						Ext.ComponentQuery.query('#addStudentsWindow')[0].destroy();
						//this$.getActiveTabfromContentPanel().down('grid').getStore().load();
						this$.getActiveTabfromContentPanel().down('#studentDisciplinaryActionGrid').getStore().load();

					}
				});
			}
		},
		showStudentIncidentCountWindow: function(record){

			if(Ext.isDefined(Ext.ComponentQuery.query('#studentIncidentCountWindow')[0])){
				Ext.ComponentQuery.query('#studentIncidentCountWindow')[0].destroy();
			}

			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.GET_INCIDENT_STUDENTS_INVOLVED+'?uniqueIdentifier='+record.data.uniqueIdentifier,
				method: 'GET',
				callback : function(opt, success, response){
					var data = Ext.decode(response.responseText);
					var selectedRecord = data;

					var storeData = selectedRecord;
					var newStore = Ext.create('Ext.data.Store', {
						fields: [{ name: "code" },{ name: "id" },{ name: "name" },{ name: "programName" }],
						data: storeData
					});

					var formData = {};
					formData.reportedByUserName = record.data.reportedByUserName;
					formData.dateOfAction1 = dateRender(record.data.dateOfAction);
					formData.incidentDate1 = dateRender(record.data.incidentDate);
					formData.type = record.data.type.value;

					var studentIncidentCountWindow = Ext.create('Ext.window.Window', {
						alias: 'widget.studentIncidentCountWindow',
						itemId: 'studentIncidentCountWindow',
						modal: true,
						resizable: true,
						autoScroll: true,
						frame: true,
						border: true,
						width: 800,
						height: 350,
						title: getCommonTranslation('STUDENT_DETAILS'),
						items: [{
							xtype: 'form',
							layout: 'vbox',
							height: 60,
							style: {
								height: '60px !important',
								maxHeight: '60px !important',
								margin: '0px !important'
							},
							margin: 0,
							frame: false,
							items: [{
								xtype: 'fieldcontainer',
								layout: 'hbox',
								height: 50,
								defaults: {
									labelAlign: 'top',
									width: 200
								},
								items:[{
									xtype: 'displayfield',
									fieldLabel: getCommonTranslation('TYPE_OF_INCIDENT'),
									name: 'type',
									itemId: 'type'
								},
								{
									xtype: 'displayfield',
									fieldLabel: getCommonTranslation('INCIDENT_DATE'),
									name: 'incidentDate1',
									itemId: 'incidentDate1'
								},
								{
									xtype: 'displayfield',
									fieldLabel: getCommonTranslation('REPORTER_NAME'),
									name: 'reportedByUserName',
									itemId: 'reportedByUserName'
								}]
							}]
						},{
							xtype: 'grid',
							itemId: 'studentDisciplinaryCountWindowGrid',
							//height: 250,
							store: newStore,
							style: {
								left: '0px !important',
								margin: '10px 0px !important'
							},
							margin:'10 0',
							border: true,
							autoScroll: true,
							viewConfig: {
								stripeRows: true
							},
							columns: [{
								header: getCommonTranslation('STUDENT_ID'),
								dataIndex: 'code',
								sortable: false,
								flex: .2
							},{
								header: getCommonTranslation('STUDENT_NAME'),
								dataIndex: 'name',
								sortable: false,
								flex: .2
							},{
								header: getCommonTranslation('PROGRAM'),
								dataIndex: 'programName',
								sortable: false,
								flex: .2
							}]
						}]
					});
					studentIncidentCountWindow.show();
					studentIncidentCountWindow.down('form').getForm().setValues(formData);

				}
			});

		},
		showStudentDisciplinaryCountWindow: function(record){
			if(Ext.isDefined(Ext.ComponentQuery.query('#studentDisciplinaryCountWindow')[0])){
				Ext.ComponentQuery.query('#studentDisciplinaryCountWindow')[0].destroy();
			}

			var selectedRecord = record.data;
			selectedRecord.dateOfAction1 = dateRender(selectedRecord.dateOfAction);
			selectedRecord.incidentDate1 = dateRender(selectedRecord.incidentDate);

			//selectedRecord.reportedByUserName = selectedRecord.reportedByUserName;
			selectedRecord.type = selectedRecord.incidentType.value;

			var storeData = selectedRecord.disciplinaryActionDetails;
			var newStore = Ext.create('Ext.data.Store', {
				fields: [{ name: "code" },{ name: "id" },{ name: "value" },{ name: "programName" }],
				data: storeData
			});

			var studentDisciplinaryCountWindow = Ext.create('Ext.window.Window', {
				alias: 'widget.studentDisciplinaryCountWindow',
				itemId: 'studentDisciplinaryCountWindow',
				modal: true,
				resizable: true,
				autoScroll: true,
				frame: true,
				border: true,
				width: 630,
				height: 300,
				title: getCommonTranslation('STUDENT_DETAILS'),
				items: [{
					xtype: 'form',
					layout: 'vbox',
					height: 60,
					style: {
						height: '60px !important',
						maxHeight: '60px !important',
						margin: '0px !important'
					},
					margin: 0,
					frame: false,
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						height: 50,
						defaults: {
							labelAlign: 'top',
							width: 200
						},
						items:[{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('TYPE_OF_INCIDENT'),
							name: 'type',
							itemId: 'type'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('INCIDENT_DATE'),
							name: 'incidentDate1',
							itemId: 'incidentDate1'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('REPORTER_NAME'),
							name: 'reportedByUserName',
							itemId: 'reportedByUserName'
						}]
					}]
				},{
					xtype: 'grid',
					itemId: 'studentDisciplinaryCountWindowGrid',
					//height: 250,
					store: newStore,
					style: {
						left: '0px !important',
						margin: '10px 0px !important'
					},
					margin:'10 0',
					border: true,
					autoScroll: true,
					viewConfig: {
						stripeRows: true
					},
					columns: [{
						header: getCommonTranslation('STUDENT_ID'),
						dataIndex: 'code',
						sortable: true,
						flex: .2
					},{
						header: getCommonTranslation('STUDENT_NAME'),
						dataIndex: 'value',
						sortable: true,
						flex: .2
					},{
						header: getCommonTranslation('PROGRAM'),
						dataIndex: 'programName',
						sortable: true,
						flex: .2
					}]
				}]
			});
			studentDisciplinaryCountWindow.show();
			studentDisciplinaryCountWindow.down('form').getForm().setValues(selectedRecord);
		},
		setReporterForPosstiveDisciplinaryAction : function(isEdit) {
			var me = this;
			var userId = me.getCurrentlyLoggedInUser().id;
			var Name = me.getCurrentlyLoggedInUser().value;
			var form = me.getPersonDisciplinaryActionForm();
			var RepoertId = form.down('#reportedByUserIdField');
			var RepoertName = form.down('#reportedByUserNameField');
			var Repoerter = RepoertId.getStore();
			var grid = me.getDisciplinaryactiongrid();
			var gridData = grid.getSelectionModel().getSelection();

			if(gridData!=undefined && isEdit &&grid.getSelectionModel().getCount()>0){
				var reporterUserId = gridData[0].data.reportedByUser.id;
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						rec.forEach(function(obj){
							if(obj.data.id == reporterUserId){
								RepoertId.setValue(reporterUserId);
								RepoertName.setValue(obj.data.value);
							}
						});
					}
				});

			}else{
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						RepoertId.setValue(userId);
						RepoertName.setValue(Name);
					}
				});
			}
		},
		setReporterForPosstiveDisciplinaryActions : function(isEdit) {
			var me = this;
			var userId = me.getCurrentlyLoggedInUser().id;
			var Name = me.getCurrentlyLoggedInUser().value;
			var form = me.getPersonPositiveIncidentForm();
			var RepoertId = form.down('#reportedByUserIdField');
			var RepoertName = form.down('#reportedByUserNameField');
			var Repoerter = RepoertId.getStore();
			var grid = me.getPositiveincidentgrid();
			var gridData = grid.getSelectionModel().getSelection();

			if(gridData!=undefined && isEdit &&grid.getSelectionModel().getCount()>0){
				var reporterUserId = gridData[0].data.reportedByUser.id;
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						rec.forEach(function(obj){
							if(obj.data.id == reporterUserId){
								RepoertId.setValue(reporterUserId);
								RepoertName.setValue(obj.data.value);
							}
						});
					}
				});

			}else{
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						RepoertId.setValue(userId);
						RepoertName.setValue(Name);
					}
				});
			}
		},
		setReporterForNagativeDisciplinaryActions : function(isEdit) {
			var me = this;
			var userId = me.getCurrentlyLoggedInUser().id;
			var Name = me.getCurrentlyLoggedInUser().value;
			var form = me.getPersonNegativeIncidentForm();
			var RepoertId = form.down('#reportedByUserIdField');
			var RepoertName = form.down('#reportedByUserNameField');
			var Repoerter = RepoertId.getStore();
			var grid = me.getNegativeincidentgrid();
			var gridData = grid.getSelectionModel().getSelection();
			if(isEdit == false){
				var positiveGrid = form.down('#positiveincidentdocumentgrid');
				var buttonsToolBar = positiveGrid.query('toolbar')[0];
				buttonsToolBar.items.items[0].setVisible(false);
			}
			if(gridData!=undefined && isEdit &&grid.getSelectionModel().getCount()>0){
				var reporterUserId = gridData[0].data.reportedByUserId;
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						rec.forEach(function(obj){
							if(obj.data.id == reporterUserId){
								RepoertId.setValue(reporterUserId);
								RepoertName.setValue(obj.data.value);
							}
						});
					}
				});

			}else{
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						RepoertId.setValue(userId);
						RepoertName.setValue(Name);
					}
				});
			}
		},
		setReporterForPosstiveDisciplinaryActionSU : function(isEdit) {
			var me = this;
			var userId = me.getCurrentlyLoggedInUser().id;
			var Name = me.getCurrentlyLoggedInUser().value;
			var form = me.getPersonDisciplinaryActionFormSU();
			var RepoertId = form.down('#reportedByUserIdField');
			var RepoertName = form.down('#reportedByUserNameField');
			var Repoerter = RepoertId.getStore();
			var grid = me.getDisciplinaryactiongrid();
			var gridData = grid.getSelectionModel().getSelection();

			if(gridData!=undefined && isEdit &&grid.getSelectionModel().getCount()>0){
				var reporterUserId = gridData[0].data.reportedByUser.id;
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						rec.forEach(function(obj){
							if(obj.data.id == reporterUserId){
								RepoertId.setValue(reporterUserId);
								RepoertName.setValue(obj.data.value);
							}
						});
					}
				});

			}else{
				Repoerter.load({
					callback: function(rec, callback,response) {
						var index = RepoertId.getStore();
						RepoertId.setValue(userId);
						RepoertName.setValue(Name);
					}
				});
			}
		},
		loadTemporarySuspensionDateAndRestrictionField:function(radio,newValue, oldValue){

			var DisciplinaryActionForm = radio.up('form');
			saveBtn = DisciplinaryActionForm.down('#submitButtonId');
			var temporarySuspensionDate = DisciplinaryActionForm.down('#temporarySuspensionDate');
			var temporarySuspensionAccessRestriction = DisciplinaryActionForm.down('#temporarySuspensionAccessRestriction');
			var temporarysSuspensionLapse = DisciplinaryActionForm.down('#temporarysSuspensionLapse');
			var radioValue = radio.getValue().temporarysSuspension;

			if(radioValue== true){
				temporarySuspensionDate.setDisabled(false);
				temporarySuspensionAccessRestriction.setDisabled(false);   
				temporarysSuspensionLapse.setDisabled(false);  
				//temporarySuspensionDate.allowBlank = true;
				if(DisciplinaryActionForm.isValid()){
					saveBtn.setDisabled(false);
				}
			}
			else{
				temporarySuspensionDate.setDisabled(true);
				temporarySuspensionAccessRestriction.setDisabled(true);
				temporarysSuspensionLapse.setDisabled(true);

				temporarySuspensionDate.reset();
				temporarySuspensionAccessRestriction.reset();
				temporarysSuspensionLapse.reset();
				if(DisciplinaryActionForm.isValid()){
					saveBtn.setDisabled(false);
				}

			}

		},
		loadTemporarySuspensionLapseDateField:function(radio,newValue, oldValue){

			var DisciplinaryActionForm = radio.up('form');
			saveBtn = DisciplinaryActionForm.down('#submitButtonId');
			var temporarySuspensionLapseDate = DisciplinaryActionForm.down('#temporarySuspensionLapseDate');
			var radioValue = radio.getValue().temporarysSuspensionLapse;

			if(radioValue==true){
				temporarySuspensionLapseDate.setDisabled(false);	
				//temporarySuspensionLapseDate.allowBlank = true;
				if(DisciplinaryActionForm.isValid()){
					saveBtn.setDisabled(false);
				}
			}
			else{
				temporarySuspensionLapseDate.setDisabled(true);
				temporarySuspensionLapseDate.reset();
				if(DisciplinaryActionForm.isValid()){
					saveBtn.setDisabled(false);
				}
			}
		},
		loadAppealDateAndAppealOutcome:function(radio,newValue, oldValue){

			var DisciplinaryActionForm = radio.up('form');
			saveBtn = DisciplinaryActionForm.down('#submitButtonId');
			var appealDate = DisciplinaryActionForm.down('#appealDate');
			var appealOutcome = DisciplinaryActionForm.down('#appealOutcome');
			var radioValue = radio.getValue().appeal;
			var saveBtn;
			if(radioValue==true){
				appealDate.setDisabled(false);	
				appealOutcome.setDisabled(false);	
				//appealOutcome.allowBlank = false;
				if(DisciplinaryActionForm.isValid()){
					saveBtn.setDisabled(false);
				}
			}
			else{
				appealDate.setDisabled(true);
				appealOutcome.setDisabled(true);
				appealOutcome.reset();
				appealDate.reset();
				//appealOutcome.allowBlank = true;
				if(DisciplinaryActionForm.isValid()){
					saveBtn.setDisabled(false);
				}
			}
		},
		setDisciplinaryDeterminationField: function(obj,rec){
			var form = this.getPersonDisciplinaryActionFormSU();
			var disciplinaryDetermination = form.down('#disciplinaryDetermination');
			disciplinaryDetermination.setValue(rec[0].data.value);
		},
		addNewRowSanctionDetailsSUGrid: function(serialNo, grid) {
			var $this = this;
			var ObjModel = [];
			var disciplinaryActionSanctionDetailModel = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionSanctionDetailModel();
			disciplinaryActionSanctionDetailModel.set("serialNo", serialNo);
			disciplinaryActionSanctionDetailModel.set("sanctionType", '');
			disciplinaryActionSanctionDetailModel.set("sanctioncompletionDate", '');
			disciplinaryActionSanctionDetailModel.set("sancationRecallDate", '');
			disciplinaryActionSanctionDetailModel.set("sanctionComplete", '');
			disciplinaryActionSanctionDetailModel.set("sanctionHours", '');
			disciplinaryActionSanctionDetailModel.set("isEditable", 'ADD');
			disciplinaryActionSanctionDetailModel.set("isAddDeleteRow", true);
			disciplinaryActionSanctionDetailModel.set("sanctionTypeId", '');

			ObjModel.push(disciplinaryActionSanctionDetailModel);
			grid.getStore().loadRawData(ObjModel, true);
			grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount());
			if(serialNo == 1){
				grid.down('#btnAdd').hide();
			}
		},
		showAddStudentsWindowForDisciplinaryActionSu: function(me, e, eOpts, type){
			if(Ext.isDefined(Ext.ComponentQuery.query('#addStudentsWindowSu')[0])){
				Ext.ComponentQuery.query('#addStudentsWindowSu')[0].destroy();
			}
			var selectedRecord = me.up('grid').getSelectionModel().selected.items[0].data;
			//selectedRecord.misconductType1 = dateRender(selectedRecord.misconductType.value);
			selectedRecord.dateOfMisconduct1 = dateRender(selectedRecord.dateOfMisconduct);
			if(Ext.isDefined(localStorage.getItem('PROGRAM_ID')) && !isNullOrEmpty(localStorage.getItem('PROGRAM_ID'))){
				selectedRecord.defaultProgramId = parseInt(localStorage.getItem('PROGRAM_ID'));
			}
			else {
				selectedRecord.defaultProgramId = 0;
			}
			selectedRecord.programItem = selectedRecord.defaultProgramId;

			var formData = {};
			formData.reportedByUserName = selectedRecord.reportedByUserName;
			//formData.misconductType1 = dateRender(selectedRecord.misconductType.value);
			formData.addStdDateOfMisconduct = dateRender(selectedRecord.dateOfMisconduct);
			formData.reportedByUserNameSu= this.getCurrentlyLoggedInUser().value;
			formData.addStdTypeMisconduct = selectedRecord.misconductType.value;
			formData.id = selectedRecord.id;

			var submitButtonItemIdSu;
			var cancelButtonItemIdSu;
			var addNewFieldContainerBtnSu;

			submitButtonItemIdSu = 'submitButtonItemIdSu';
			cancelButtonItemIdSu = 'cancelButtonItemIdSu';
			addNewFieldContainerBtnSu = 'addNewFieldContainerBtnSu';


			var addStudentsWindow = Ext.create('Ext.window.Window', {
				alias: 'widget.addStudentsWindowSu',
				itemId: 'addStudentsWindowSu',
				modal: true,
				resizable: false,
				autoScroll: true,
				frame: true,
				width: 630,
				minHeight: 290,
				height: 290,
				maxHeight : 370,
				title: getCommonTranslation('ADD_STUDENTS'),
				items: [{
					xtype: 'form',
					layout: 'vbox',
					frame: false,
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						height: 60,
						defaults: {
							labelAlign: 'top',
							width: 200
						},
						items:[{
							xtype: 'hidden',
							name: 'id',
							itemId: 'id'
						},
						/*{
    	            	xtype: 'hidden',
    	            	name: 'positiveIncidentId',
    	                itemId: 'positiveIncidentId'
    	            },
    	            {
    	            	xtype: 'hidden',
    	            	name: 'negativeIncidentId',
    	                itemId: 'negativeIncidentId'
    	            },*/
						{
							xtype: 'hidden',
							name: 'defaultProgramIdSu',
							itemId: 'defaultProgramIdSu'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getPersonModuleTranslation('TYPE_OF_MISCONDUCT'),
							name: 'addStdTypeMisconduct',
							itemId: 'addStdTypeMisconduct'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getPersonModuleTranslation('DATE_OF_MISCONDUCT'),
							name: 'addStdDateOfMisconduct',
							itemId: 'addStdDateOfMisconduct'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('REPORTER_NAME'),
							name: 'reportedByUserNameSu',
							itemId: 'reportedByUserNameSu'
						}]
					},{
						xtype:'panel',
						itemId:'classStudentPanelSu',
						layout : 'vbox',
						width: '100%',
						marginTop:'30px',
						height: 'auto',
						padding: 0,
						autoScroll: false,
						style:{
							marginLeft:'0px'
						},
						items:[{
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '0 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'programItemSu',
								itemId:'programItemIdSu',
								store: 'common.ProgramStore',
								fieldLabel: getCommonTranslation('PROGRAM'),
								valueField: 'id',
								displayField: 'valueCode',
								queryParam: 'qry',
								//minChars: 3,
								editable: false,
								allowBlank: false,
								typeAhead: false,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection: true,
								listConfig: {
									listeners: {
										beforeshow: function(
												picker) {
											picker.minWidth = picker
											.up('combobox')
											.getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{code} / {value}' +
										'</div>';
									}
								},
								listeners: {
									change: function(me, newValue, oldValue, eOpts){
										me.up('fieldcontainer').down('#studentIdSu').reset();
										me.up('fieldcontainer').down('#studentIdSu').clearValue();

										var form = Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
										var formValues = form.getForm().getFieldValues();        


										if( type == 'DISCIPLINARY_ACTION_SU' ){
											me.up('fieldcontainer').down('#studentIdSu').getStore().proxy.extraParams = {
												programIds: newValue,
												//academyLocationIds: localStorage.getItem('academylocationid'),
												isDisciplinaryAddStudentsScreen: true,
												disciplinaryActionIdSu: formValues.id
											};
										}
										me.up('fieldcontainer').down('#studentIdSu').getStore().load();
									},
									afterrender: function(combo){
										combo.getStore().load({
											callback: function(){
												setTimeout(function(){
													combo.setValue(combo.findRecordByValue(parseInt(selectedRecord.defaultProgramId)));
												},300);
											}
										});
									}
								}
							},
							{
								xtype: 'customcombobox',
								name: 'STUDENT_ID',
								itemId: 'studentIdSu',
								fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
								store: Ext.create('Academia.store.programCourseDashboard.Student'),
								valueField: 'id',
								width: 226,
								displayField: 'valueCode',
								queryParam:'studentNameOrCode',
								triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
								enableKeyEvents  : 'true',
								minChars:3,
								forceSelection:true,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								triggerAction: '',
								hideTrigger:false,
								allowBlank: false,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{studentCode} / {studentName}' +
										'</div>';
									}
								}
							},
							{
								xtype: 'button',
								//itemId: 'addNewFieldContainerBtn',
								itemId: addNewFieldContainerBtnSu,
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								width: 'auto',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]
						}]
						}, {
							xtype: 'fieldcontainer',
							layout: 'hbox',
							height: 60,
							defaults: {
								labelAlign: 'top',
								width: 200
							},
							items: [{
								xtype: 'checkboxfield',
								itemId: 'notifyStudent',
								labelAlign: 'right',
								region: 'south',
								boxLabel: getPersonModuleTranslation('NOTIFY_STUDENT'),
								name: 'notifyStudent',
								checked: false,
								inputValue: true,
								uncheckedValue: false,
								hidden:true,
								style: {
									marginTop: '10px'
								}
							}],
						},
					{
						xtype : 'fieldcontainer',
						width : '100%',
						cls : 'windowBtnPos',
						items : [ {
							xtype : 'button',
							action : 'Submit',
							text : getCommonTranslation('SAVE'),
							//itemId : 'addStudentsWindowFormSubmitButtonId',
							itemId : submitButtonItemIdSu,
							ui : 'CustomBtnSubmit',
							scale : CONSTANTS.BUTTONSIZE,
							formBind : true
						}, {
							xtype : 'button',
							//itemId : 'addStudentsWindowFormCancelButtonId',
							itemId : cancelButtonItemIdSu,
							text : getCommonTranslation('CANCEL'),
							ui : 'CustomBtnCancel',
							scale : CONSTANTS.BUTTONSIZE
						} ]
					}]
				}]
			});
			var addStudentsWindowForm=Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form'); 
			var programField=addStudentsWindowForm.down('#programItemIdSu'); 
			var studentField=addStudentsWindowForm.down('#studentIdSu'); 
			this.setAllowBlank(programField,false); 
			this.setAllowBlank(studentField,false); 
			addStudentsWindow.show(); 
			addStudentsWindow.down('form').getForm().setValues(formData);
		},
		addMoreFieldsOfProgramStudentSu: function(btn,type){

			var addNewFieldContainerBtnSu1;
			var detailedDeleteButtonSu1;

			addNewFieldContainerBtnSu1 = 'addNewFieldContainerBtnSu1';
			detailedDeleteButtonSu1 = 'detailedDeleteButtonSu1';

			var $this = this;

			var addStudentsWindowForm=Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
			var panelContiner = addStudentsWindowForm.down('#classStudentPanelSu');
			var defaultProgramId = addStudentsWindowForm.getValues().defaultProgramId;
			var panelItem = new Array();
			panelItem.push({
				xtype : 'fieldcontainer',
				layout : 'hbox',
				width: '100%',
				scope: $this,
				defaults : {
					labelAlign : 'top',
					width:'226'
				},
				layout : {
					type : 'hbox'
				},
				margin: '10 0 0 0',
				padding: '0 0 0 0',
				items:[{
					xtype: 'customcombobox',
					width: 226,
					name: 'programItem',
					itemId:'programItemIdSu1',
					store: 'common.ProgramStore',
					fieldLabel: '',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam: 'qry',
					minChars: 3,
					editable: false,
					typeAhead: false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection: true,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(
									picker) {
								picker.minWidth = picker
								.up('combobox')
								.getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					},
					listeners: {
						change: function(me, newValue, oldValue, eOpts){
							me.up('fieldcontainer').down('#studentIdSu1').reset();
							me.up('fieldcontainer').down('#studentIdSu1').clearValue();

							var form = Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
							var formValues = form.getForm().getFieldValues();        
							var disciplinaryActionId = formValues.id;

							me.up('fieldcontainer').down('#studentIdSu1').getStore().proxy.extraParams = {
								programIds: newValue,
								//academyLocationIds: localStorage.getItem('academylocationid'),
								isDisciplinaryAddStudentsScreen: true,
								disciplinaryActionId: formValues.id
							};

							me.up('fieldcontainer').down('#studentIdSu1').getStore().load();
						},
						afterrender: function(combo){
							combo.getStore().load({
								callback: function(){
									setTimeout(function(){

										var gridItemId;
										gridItemId = '#studentDisciplinaryActionSUGrid';
										//var currentGrid = $this.getActiveTabfromContentPanel().down(gridItemId);
										//var selectedRecord = currentGrid.getSelectionModel().selected.items[0].data;
										var currentGrid = $this.getActiveTabfromContentPanel().down(gridItemId);
										var selectedRecord = currentGrid.getSelectionModel().selected.items[0].data;

										if(Ext.isDefined(localStorage.getItem('PROGRAM_ID')) && !isNullOrEmpty(localStorage.getItem('PROGRAM_ID'))){
											selectedRecord.defaultProgramId = parseInt(localStorage.getItem('PROGRAM_ID'));
										}
										else {
											selectedRecord.defaultProgramId = 0;
										}
										//selectedRecord.programItem = selectedRecord.defaultProgramId;

										combo.setValue(combo.findRecordByValue(parseInt(selectedRecord.defaultProgramId)));
									},300);
								}
							});
						}
					}
				},
				{
					xtype: 'customcombobox',
					name: 'STUDENT_ID',
					itemId: 'studentIdSu1',
					fieldLabel: '',
					store: Ext.create('Academia.store.programCourseDashboard.Student'),
					valueField: 'id',
					width: 226,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
				},
				{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					//itemId: 'detailedDeleteButton1',
					itemId: detailedDeleteButtonSu1,
					width: 'auto',
					cls: 'CustomBodyBtnReject',
					tooltip: getCommonTranslation('DELETETOOLTIP'),
					style:{
						marginTop:'4px'
					}
				},
				{
					xtype: 'button',
					//itemId: 'addNewFieldContainerBtn1',
					itemId: addNewFieldContainerBtnSu1,
					width: 'auto',
					cls: 'CustomBodyBtnSettings',
					width: 'auto',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'4px'
					}
				}]

			});
			panelContiner.add(panelItem);
			this.hideShowDetailsSu(panelContiner, type);
			panelContiner.doLayout();
		},
		hideShowDetailsSu: function(detailedPanel, type) {
			var this$ = this;
			var form = Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
			detailedPanel.items.each(function(item, index, items) {
				var addButton = item.getComponent(item.items.length - 1);
				if (index == (items - 1)) {
					if (addButton != null) {
						addButton.show();
					}
				} else {
					if (addButton != null) {
						addButton.hide();
					}
				}
			});

			var addStudentsWindowFormSubmitButtonId;
			addStudentsWindowFormSubmitButtonId = 'submitButtonItemIdSu';

			if(!form.getForm().hasInvalidField()){
				form.down('#'+addStudentsWindowFormSubmitButtonId).setDisabled(false);
			}
			else {
				form.down('#'+addStudentsWindowFormSubmitButtonId).setDisabled(true);
			}
		},
		deleteMoreFieldsOfProgramStudentSu: function(deleteButton, type) {
			var this$ = this;
			var form=Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
			var panelContiner = form.down('#classStudentPanelSu');
			var container = deleteButton.up('fieldcontainer');
			if (container != null && panelContiner != null) {
				if (panelContiner.items.length > 1) {
					panelContiner.remove(container);
					this$.hideShowDetailsSu(panelContiner, type);
				}
			}
		},
		saveStudentWindowFormSu: function(type){
			var this$ = this;
			var form = Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
			var formValues = form.getForm().getFieldValues();        
			var disciplinaryAction = formValues.id;
			var incidentId = formValues.id;
			var notifyStudentData=formValues.notifyStudent;


			var selected = [];
			var WSDisciplinaryActionDetail = {};
			Ext.each(form.getForm().getFields().items, function(currentField){
				if(currentField.name=="STUDENT_ID"){
					if(!isNullOrEmpty(currentField.getValue())){
						var currentFieldRecord = currentField.findRecordByValue(currentField.getValue());
						var newRecord = {
								personId:currentFieldRecord.data.personId,
								disciplinaryActionId: disciplinaryAction,
								notifyStudent:notifyStudentData

						};
						selected.push(newRecord);
					}
				}
			});

			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_SAVE_FOR_DISCIPLINARY_ACTION_DETAIL_SU,
				method: 'POST',
				jsonData: selected,
				callback : function(opt, success, response){
					showSuccessMessage(getCommonTranslation('ADD_STUDENTS'),
							getCommonTranslation('RECORD_ADD_SUCCESS'));
					Ext.ComponentQuery.query('#addStudentsWindowSu')[0].destroy();
					//this$.getActiveTabfromContentPanel().down('grid').getStore().load();
					this$.getActiveTabfromContentPanel().down('#studentDisciplinaryActionSUGrid').getStore().load();

				}
			});
		},
		showStudentDisciplinaryCountWindowSu: function(record){
			if(Ext.isDefined(Ext.ComponentQuery.query('#studentDisciplinaryCountWindowSu')[0])){
				Ext.ComponentQuery.query('#studentDisciplinaryCountWindowSu')[0].destroy();
			}

			var selectedRecord = record.data;
			selectedRecord.dateOfAction1 = dateRender(selectedRecord.dateOfAction);
			selectedRecord.incidentDate1 = dateRender(selectedRecord.incidentDate);
			
			//var formData = {};
			//selectedRecord.reportedByUserName = selectedRecord.reportedByUserName;
			//formData.misconductType1 = dateRender(selectedRecord.misconductType.value);
			selectedRecord.addStdDateOfMisconduct = dateRender(selectedRecord.dateOfMisconduct);
			selectedRecord.reportedByUserNameSu= this.getCurrentlyLoggedInUser().value;
			selectedRecord.addStdTypeMisconduct = selectedRecord.misconductType.value;
			//formData.id = selectedRecord.id;

			//selectedRecord.reportedByUserName = selectedRecord.reportedByUserName;
			//selectedRecord.type = selectedRecord.incidentType.value;

			var storeData = selectedRecord.disciplinaryActionDetails;
			var newStore = Ext.create('Ext.data.Store', {
				fields: [{ name: "code" },{ name: "id" },{ name: "value" },{ name: "programName" },{ name: "wheatherChecked" },{ name: "isAddDeleteRow" }],
				data: storeData
			});
			var deletedStudentIds = new Array();
			var studentDisciplinaryCountWindowSu = Ext.create('Ext.window.Window', {
				alias: 'widget.studentDisciplinaryCountWindowSu',
				itemId: 'studentDisciplinaryCountWindowSu',
				modal: true,
				resizable: true,
				autoScroll: true,
				frame: true,
				border: true,
				width: 630,
				height: 300,
				title: getCommonTranslation('STUDENT_DETAILS'),
				items: [{
					xtype: 'form',
					layout: 'vbox',
					height: 60,
					style: {
						height: '60px !important',
						maxHeight: '60px !important',
						margin: '0px !important'
					},
					margin: 0,
					frame: false,
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						height: 50,
						defaults: {
							labelAlign: 'top',
							width: 200
						},
						items:[{
							xtype: 'displayfield',
							fieldLabel: getPersonModuleTranslation('TYPE_OF_MISCONDUCT'),
							name: 'addStdTypeMisconduct',
							itemId: 'addStdTypeMisconduct'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getPersonModuleTranslation('DATE_OF_MISCONDUCT'),
							name: 'addStdDateOfMisconduct',
							itemId: 'addStdDateOfMisconduct'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('REPORTER_NAME'),
							name: 'reportedByUserNameSu',
							itemId: 'reportedByUserNameSu'
						}]
					}]
				},{
					xtype: 'grid',
					itemId: 'studentDisciplinaryCountWindowGridSu',
					//height: 250,
					store: newStore,
					style: {
						left: '0px !important',
						margin: '10px 0px !important'
					},
					margin:'10 0',
					border: true,
					autoScroll: true,
					viewConfig: {
						stripeRows: true
					},
					columns: [{
						header: getCommonTranslation('STUDENT_ID'),
						dataIndex: 'code',
						sortable: true,
						flex: .2
					},{
						header: getCommonTranslation('STUDENT_NAME'),
						dataIndex: 'value',
						sortable: true,
						flex: .2
					},{
						header: getCommonTranslation('PROGRAM'),
						dataIndex: 'programName',
						sortable: true,
						flex: .2
					},{
						header : getCommonTranslation('WHETHER_TO_DISPLAY_ON_STUDENT_PORTAL'),
						dataIndex:'wheatherChecked', 
						stopSelection: false, 
						flex:  .2,
				        renderer: function(value, meta, record)
				        {
				        	var indx = record.index;
				        	var recVal = record.data.wheatherChecked;
				        	var dataIndx = meta.column.dataIndex;
				        	var val =false;
				        	if(recVal == true){
				        		val = true;
				        	}
				        	return '<center><input type="checkbox" style="width:15px;height:15px;" '+(val ? 'checked="true"' : '')+' ></center>';
				        
				        }
					
					},{
						header: getCommonTranslation('DELETE'),
				        dataIndex: 'deleteButton',
				        flex: .2,
				        cls: 'CustomBodyBtnSettings',
				        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				        	var indx = record.index;
                             if(record.index==0){
                            	 return "";
                             }else{
		            		return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";	
                             }
				        },
				    }],
					listeners: {
						cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
							var $this = this;
		 					 var columnName = this.columnManager.columns[cellIndex].dataIndex;
		 					if (columnName == "wheatherChecked") {
	 								 var models = this.getStore().getRange();
	 								models[rowIndex].data.wheatherChecked=e.target.checked;	 							 
	 						 }
							if (columnName == "deleteButton") {
	 							 if (e.target.className == "deleteButtonClsForGridActionCls") { 
	 								$this.getStore().removeAt(rowIndex);
	 									 deletedStudentIds.push(record.data.id);
	 									 var models = $this.getStore().getRange();
	 									 for (var i = 0; i < models.length; i++) {
	 										 models[i].data.serialNo = i + 1;
	 									 }
	 									$this.getStore().loadRawData(models, true);							
	 							 }
	 						 }							
						}
					}
						
				},{
					xtype: 'form',
					layout: 'vbox',
					height: 60,
					style: {
						height: '60px !important',
						maxHeight: '60px !important',
						margin: '0px !important'
					},
					margin: 0,
					frame: false,
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						height: 50,
						defaults: {
							labelAlign: 'top',
							width: 200
						},
						items:[{
							xtype: 'button',
							text: getCommonTranslation('SUBMIT'),
							itemId: 'submitButtonId',
							buttonAlign: 'right',
							ui: 'CustomBtnSubmit',
							scale: CONSTANTS.BUTTONSIZE,
							listeners:{
								click:function(obj){
					
									var grid = Ext.ComponentQuery.query('#studentDisciplinaryCountWindowGridSu')[0];
									var store=grid.getStore();
									var length=deletedStudentIds.length;
									var selected = {};
									selected.checkboxSelected = [];
									selected.deletedStudentIds = [];
									selected.checkboxSelectedTrue=[];
									 for (var i = 0; i < store.data.length; i++) {
										 if(store.data.items[i].data.wheatherChecked==false) {
											 selected.checkboxSelected.push(store.data.items[i].data.id);
										 }else
											 {
											  selected.checkboxSelectedTrue.push(store.data.items[i].data.id);
											 }
									 }
									 selected.deletedStudentIds = deletedStudentIds;
									if(length>0){
										showConfirmMessage(getPersonModuleTranslation('DISCIPLINARY_ACTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
											if (btn == 'yes') {
														Ext.Ajax.request({
															type: 'rest',
															url: SERVERURL.PATH_UPDATE_FOR_DISCIPLINARY_ACTION_DETAIL_SU,
															method: 'POST',
															jsonData: selected,
															headers: {
																'Content-Type': 'application/json'
															},
															success: function(form, action) {
																showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SU_DISCIPLINARY_ACTION_DELETE_SUCCESS'));
																studentDisciplinaryCountWindowSu.close();
															var grid=Ext.ComponentQuery.query('#studentDisciplinaryActionSUGrid')[0];
																grid.getStore().load();

														}
												});	
											}if(btn =='no')
												{
												studentDisciplinaryCountWindowSu.close();
												}
										});
										}else
											{
											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.PATH_UPDATE_FOR_DISCIPLINARY_ACTION_DETAIL_SU,
												method: 'POST',
												jsonData: selected,
												headers: {
													'Content-Type': 'application/json'
												},
												success: function(form, action) {
													showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('DISCIPLINARY_ACTION_UPDATE_SUCCESS'));
													studentDisciplinaryCountWindowSu.close();
													var grid=Ext.ComponentQuery.query('#studentDisciplinaryActionSUGrid')[0];
													grid.getStore().load();
												}
										});
									}
								}
							}
						}]
					}]
				}]
			});
			studentDisciplinaryCountWindowSu.show();
			studentDisciplinaryCountWindowSu.down('form').getForm().setValues(selectedRecord);
		},
		
		hideAddStudentsWindowSu: function(){
			if(Ext.isDefined(Ext.ComponentQuery.query('#addStudentsWindowSu')[0])){
				Ext.ComponentQuery.query('#addStudentsWindowSu')[0].destroy();
			}
		},
		showSanctionDetailsOnPopUpWindow: function(records){
			
			var docWindow = this.getDisciplinaryactionsusanctiondetailwindow();
			if (!docWindow) {
				docWindow = Ext.widget('disciplinaryactionsusanctiondetailwindow',{
					itemId:'disciplinaryactionsusanctiondetailwindowItemId'
				});
			}
			docWindow.show();
			var sanctionGrid = docWindow.down('#sanctiondetailsgridonwindow');
			sanctionGrid.setTitle(getPersonModuleTranslation('SANCTION_DETAILS'));
			sanctionGrid.getStore().removeAll();
			
			sanctionGrid.getStore().getProxy().extraParams = {
				     id:records.data.id
				};
			/*setTimeout(function(){
				if(!isNullOrEmpty(records.data.id) &&  records.data.sanctionDetails.length>0){
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_FIND_SANCTION_DETAIL_SU,
						method: "GET",
						params:{
							id:records.data.id
						},
						success: function(frm, action) {
							Ext.getBody().unmask();
							var data = Ext.JSON.decode(frm.responseText);
							sanctionGrid.getStore().loadData(data);
						}
					});
				}
			},300);*/
			
			sanctionGrid.getStore().load();
			sanctionGrid.on('beforeedit', function(editor, e) {
		        return false;
		        });
			
			var sanctionTypeCombo = sanctionGrid.columns[0].getEditor();
			sanctionTypeCombo.getStore().load();

			var appealOutcomeCombo = sanctionGrid.columns[4].getEditor();
			appealOutcomeCombo.getStore().load();
			
		},
		studentDocNegativeIncidentsContainerWindow: function(){
	    	var StudentIncidentGrid = Ext.ComponentQuery.query('positiveincidentdocumentgrid');
	        
	        var $this = this;
	        var store = StudentIncidentGrid[0].store;
	        
	        var portalId = this.getCurrentLoggedPortalId();  	
	        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){/*
	        	var personInfoPanel  = this.getPassportgrid();
	    		var selectedRec = personInfoPanel.getSelectionModel();
	            	store.getProxy().extraParams = {
	    			  ID: selectedRec.getSelection()[0].data.id
	    			};
	            	var studentDocPassportGrid = this.getStudentpassportdocumentgrid();
	    			store.load({
	    				callback:function() {
	    					if(store.getCount()) {
	    						if (studentDocPassportGrid.isHidden()) {
	    							studentDocPassportGrid.setVisible(true);
	    						}
	    					}					
	    				}
	    			});
	        	
	        */}else{
	        	var contentPanelTab = this.getContentPanelActiveTab();
	        	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	    		var negativeincidentgrid  = personInfoPanel.down('negativeincidentgrid');
	    		var selectedRec = negativeincidentgrid.getSelectionModel();
	            	store.getProxy().extraParams = {
	    			  ID: selectedRec.getSelection()[0].data.id
	    			};
	            	var studentNIDocGrid = this.getPositiveincidentdocumentgrid();
	    			store.load({
	    				callback:function() {
	    					if(store.getCount()) {
	    						if (studentNIDocGrid.isHidden()) {
	    							studentNIDocGrid.setVisible(true);
	    						}
	    					}					
	    				}
	    			});
	        }
	        
			
	       },
	       loadDFRForAssessmentEventVisibility: function(assessmentEvent){
	    		var $this = this;
	    		setTimeout(function(){
	    			Ext.Ajax.request({
		    			type: 'rest',
		    			async: false,
		    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
		    			params: {
		    				screenName: 'negativeincidentform',
		    				academyLocationId: $this.getCurrentAcademyLocation(),
		    				languageCode:'en'
		    			},
		    			method: 'GET',
		    			success: function(res, action) {
		    	   			var response = Ext.decode(res.responseText);
		    	   			if( Object.keys(response).length > 0 ){
		    	   				var records=response.negativeincidentform;
		    	   				var form = $this.getNegativeincidentform();
		    	   				for(i in records){
		    	   					if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='courseVarientId' && records[i].isVisible==false){
		    	   						assessmentEvent.setVisible(false);
		    	   						assessmentEvent.allowBlank= true;
		    	   					}else if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='courseVarientId' && records[i].isVisible==true  && records[i].isMandatory==false){
		    	   						if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='assessmentEventId' && records[i].isVisible==true  && records[i].isMandatory==true){
		    	   							assessmentEvent.isMandatory(false);
		    	   							assessmentEvent.allowBlank= true;
		    	   							form.down("#assessmentEventId").labelSeparator = '';
		    	   							form.down("#assessmentEventId").setFieldLabel(getPersonModuleTranslation('ASSESSMENT_EVENT'))+ ':';
		    	   						}
		    	   					}else if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='courseVarientId' && records[i].isVisible==true  && records[i].isMandatory==true){
		    	   						if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='assessmentEventId' && records[i].isVisible==true  && records[i].isMandatory==true){
		    	   							assessmentEvent.allowBlank= false;
		    	   						}
		    	   					}
		    	   				}
		    	   			}
		    	   		}
		    			
		    		});
				},200);
	    	},
			hideNotifyStudentButton: function(){
				var form = Ext.ComponentQuery.query('#addStudentsWindowSu')[0].down('form');
				var notifyStudent=form.down('#notifyStudent');
				Ext.Ajax.request({
				    	   		type: 'rest',
				    	   		async: false,
				    	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
				    	   		params: {
				    	   			screenName: 'addStudentsWindowSu',
				    	   			academyLocationId: this.getCurrentAcademyLocation(),
				    	   			languageCode:'en'
				    	   		},
				    	   		method: 'GET',
				    	   		success: function(res, action) {
				    	   			var response = Ext.decode(res.responseText);
				    	   			if( Object.keys(response).length > 0 ){
				    	   				var records=response.addStudentsWindowSu;
				    	   				for(i in records){
				    	   					if(records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='notifyStudent' && records[i].isVisible==true){
				    	   						form.down("#notifyStudent").setVisible(true);
				    	   					}
				    	   				}
				    	   			}else{
				    	   				form.down("#notifyStudent").setVisible(false);
				    	   			}
				    	   		}
				    	   		
				    	   	});
       },
});
