/**
 * This controller is used for the student feedback and survey Controller.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.student.StudentFeedbackController', {
    extend: 'Academia.controller.personinfo.common.PersonFeedbackSurveyController',

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personFeedbackGivenForm',
        selector: 'feedbackgivenform[itemId=studentFeedbackGivenForm]'
    }, {
        ref: 'personFeedbackReceiveForm',
        selector: 'feedbackreceiveform[itemId=studentFeedbackReceiveForm]'
    }],
    config: {
    	STUDENT_FEEDBACK_GIVEN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEEDBACK_GIVEN_PRIVILEGES'),
    	STUDENT_FEEDBACK_RECEIVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEEDBACK_RECEIVED_PRIVILEGES')
    },
    init: function(application) {
        this.control({
    		/**
    		 * Feedback Given
    		 */
    		 'feedbackgivengrid[itemId=studentFeedbackGivenGrid]': {
                 render: function(grid) {
                 	//this.loadGridStore('#studentFeedbackGivenGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA);
                	 this.doAccessControlValidation(grid, this.getSTUDENT_FEEDBACK_GIVEN_PERMISSIONS());
                 }
             },
             'feedbackgivengrid[itemId=studentFeedbackGivenGrid] button[itemId=btnView]': {
             	click: function(){
             		this.viewFeedbackGiven('FEEDBACK_GIVEN', 'studentFeedbackGivenForm', '#studentFeedbackGivenGrid');
             	}
             },
             'personcommonwindow[itemId=personCommonWindow] feedbackgivenform[itemId=studentFeedbackGivenForm] button[itemId=cancelButtonId]': {
                 click: this.closePersonCommonWindow
             },
             
             /**
     		 * Feedback Received
     		 */
             
             'feedbackreceivedgrid[itemId=studentFeedbackReceivedGrid]': {
                 render: function(grid) {
                 	//this.loadGridStore('#studentFeedbackReceivedGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA);
                	 this.doAccessControlValidation(grid, this.getSTUDENT_FEEDBACK_RECEIVED_PERMISSIONS());
                 }
             },
             'feedbackreceivedgrid[itemId=studentFeedbackReceivedGrid] button[itemId=btnView]': {
             	click: function(){
             		this.viewFeedbackReceived('FEEDBACK_RECEIVE', 'studentFeedbackReceiveForm', '#studentFeedbackReceivedGrid');
             	}
             },
             'personcommonwindow[itemId=personCommonWindow] feedbackreceiveform[itemId=studentFeedbackReceiveForm] button[itemId=cancelButtonId]': {
                 click: this.closePersonCommonWindow
             }
    	});
    }
});
