/**
 * @author Prashant Choudhary

 */
Ext.define('Academia.controller.personinfo.student.StudentJourneyController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['coursetransaction.studentenrollment.AcademyDisplayNameByAdmissionStore','attendance.AttendanceProgramSectionStore','enquiry.AcademicBatchStore', 

		'coursetransaction.sectionmanagement.SectionGroup','coursetransaction.coursereading.CourseByPeriod','course.coursevariants.CourseVariantStore',
		'common.ActiveUserStore','common.AccessibleProgByCourseAndALsIdStore','enquiry.AcademicBatchStore',
		'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','coursetransaction.sectionmanagement.SectionsStore',
		'examinationcenters.remark.CourseEvaluationRemark','programCourseDashboard.DailyLogOrSessionReportGridStore',
		'common.ProgramsByAcademyLocationsIds','programCourseDashboard.PendingSessionReportGridStore',
		'course.AssignedPeriodCoursesFacultyStore', 'coursesessiondiary.CourseSessionDiaryDocument',
		'programCourseDashboard.ScheduleGridStore','attendance.attendancereport.CourseByStudentId',
		'common.AcademicTermByPeriodIdsStore','attendance.AssignedSectionByCourseNComponent',
		'coursetransaction.sectionmanagement.CoruseVariantSectionStore','student.studentprofile.StudentProgramStore',
		'common.AssignedProgramStore','attendance.SectionAndFacultyByPeriodID','common.ParameterizedProgramBatchPeriodStore',
		'common.MappedFacultyStore','coursesessiondiary.CourseSessionDescriptionStore','personinfo.common.personalinfo.StudentJourneyStore',

		'personinfo.common.personalinfo.StudentJourneyPeriodStatusStore',
		'common.AcademyLocationNameSeparated',
		'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
		'facilitiesresources.resourcebooking.SeatTypeByBatchStore'
		],

		views : ['student.studentprofile.StudentJourneyStructureForStudentProfile','student.studentprofile.StudentJourneySearchForm',
			'baselayout.contentarea.ContentPanel','programCourseDashboard.DailyLogOrSessionReportStructure',
			'programCourseDashboard.DailyLogOrSessionPBSReportFilter','programCourseDashboard.PendingSessionReportStructure',
			'programCourseDashboard.DailyLogOrSessionReportGrid','programCourseDashboard.DailyLogOrSessionCBSReportFilter',
			'programCourseDashboard.PendingSessionReportGrid', 'coursesessiondiary.CourseSessionDiaryDocumentList',
			'coursesessiondiary.CourseSessionDiaryDocumentGrid','programCourseDashboard.NewSessionReportFilter',
			'programCourseDashboard.StudentNewSessionReportFilter','coursesessiondiary.CourseSessionDocumentLinkWin','personinfo.common.personalinfo.StudentJourneyGrid'
			],	           
			config: {
				MASTER_TIME_TABLE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MASTER_TIME_TABLE_PRIVILEGES'),
				SESSION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SESSION_REPORT_PRIVILEGES'),
				STUDENT_SESSION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SESSION_REPORT_PRIVILEGES'),
				PARENT_SESSION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_SESSION_REPORT_PRIVILEGES'),
				STUDENT_JOURNEY_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_JOURNEY_PRIVILEGES'),
			},
			refs : [{
				ref: 'studentjourneystructureforstudentprofile',
				selector: 'studentjourneystructureforstudentprofile'
			},
			{
				ref: 'studentjourneysearchform',
				selector: 'studentjourneysearchform'
			},{
				ref: 'studentjourneygrid',
				selector: 'studentjourneygrid'
			}],
			init : function() {
				this.control({


					'studentjourneygrid':{
						afterrender:function(grid){
							var me = this;
							setTimeout(function(){
								me.addDataGridConfigButton(grid,me.getSTUDENT_JOURNEY_PERMISSION());
							},1500);
							var gridStore = grid.getStore();
							var grid = this.getStudentjourneygrid();
							var academyLocationId = this.getCurrentAcademyLocation();
							var user=me.getCurrentlyLoggedInUser();
							gridStore.getProxy().extraParams = {
								studentId : user.id,
							};
							gridStore.load({
								callback: function(){
									setTimeout(function(){
										grid.up().doLayout();
										 grid.getView().refresh();
						                    var view = grid.getView();
						                    var store = grid.getStore();
						                    store.each(function(record, index){
						                        if(record.get('resultStatus') === 'Exempted'){
						                            var row = view.getRecord(index);
						                            if(row){
														var exemptedRow = grid.view.getNode(row);
														exemptedRow.classList.add('fadeOutRowCls');
						                            }
						                        }
						                    });
									},300);
								}
							});
						}
					},
				
					/*'studentjourneysearchform[itemId=studentjourneysearchformItemId]':{
	                			   afterrender: function(form){
	                				   var me = this;
	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var programBatchField = form.down("#programBatch_programId");
	                				   var programBatchFieldStore = programBatchField.getStore();


	                				   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                					   this$.setAllowBlank(studentALField, false);
	                					   studentALField.show();

	                					   programBatchFieldStore.on('beforeload', function(store, operation) {
	                						   var selectedALId = studentALField.getValue();
	                						   var currentALId = me.getCurrentAcademyLocation();
	                						   store.proxy.extraParams.academyLocationIds = isNullOrEmpty(selectedALId) ? currentALId : selectedALId;
	                					   });

	                					   var studentALStore = studentALField.getStore();
	                					   var portalId = me.getCurrentLoggedPortalId();
	                					   var currentALId = me.getCurrentAcademyLocation();

	                					   if(portalId==7){
	                						   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                						   var admissionDetails=portalInfo.admissionDetails;
	                					   } else {
	                						   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                						   var admissionDetails=portalInfo.admissionDetails;
	                					   }

	                					   var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

	                					   studentALStore.getProxy().extraParams = {
	                						   admissionIds:admissionIds
	                					   };

	                					   studentALStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length > 0){
	                									   studentALField.setValue(currentALId);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var grid = this.getStudentjourneygrid();
		                	       			  var store = grid.getStore();
		                	       			 var student=me.getCurrentlyLoggedInUser();
		                	       			  store.getProxy().extraParams = {
		                	       				studentId : student.id,
		                      				  };
		                	       			  store.load();
	                				   }else{
	                					   this$.setAllowBlank(studentALField, false);
	                					   studentALField.hide();
	                				   } 
	                			   }
	                		   },
	                		   'studentjourneysearchform[itemId=studentjourneysearchformItemId] combo[itemId=studentAcademyLocation]': {
	                			   change: function(combo, records, eOpts) {
	                				   var this$ = this;
	                				   var form = combo.up('studentjourneysearchform');

	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var studentProgramField = form.down("#programBatch_programId");

	                				   studentProgramField.clearValue();
	                				   form.down('#programBatch_batchId').clearValue();
	                			//	   form.down('#periodIdItemId').clearValue();

	                				   form.down('#programBatch_batchId').setDisabled(true);
	                			//	   form.down('#periodIdItemId').setDisabled(true);

	                				   var academyLocationId=studentALField.getValue();

	                				   if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
	                					   studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
	                				   } else {
	                					   studentPortalInfo = this$.getStudentDetailForErpPortal();
	                				   }

	                				   var studentId = studentPortalInfo.student.id;

	                				   studentProgramField.store.getProxy().extraParams={
	                					   studentId: studentId,
	                				   };

	                				   studentProgramField.store.load({
	                					   callback : function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length==1){
	                								   studentProgramField.setValue(records[0].data.id);
	                							   }
	                						   }
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'studentjourneysearchform[itemId=studentjourneysearchformItemId] combo#programBatch_programId': {
	                			   change: function(obj, record) {
	                				   var $this=this;
	                				   var records = obj.value;
	                				   var programId = 0;
	                				   if(!isNullOrEmpty(records)) {
	                					   if(typeof records=="number"){
	                						   programId = records;
	                					   }else if(!isNullOrEmpty(records.data)){
	                						   programId = records.data.id;
	                					   }
	                				   }
	                				   var form = obj.up('form');
	                				   var batchCombo=form.down("#programBatch_batchId");

	                				   batchCombo.reset();

	                				   batchCombo.setDisabled(true);

	                				   if(programId > 0) {
	                					   var studentInfo = null;
	                					   var studentId 
	                					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                						   studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                						   studentId = studentInfo.student.id;
	                					   } else {
	                						   var personProfile = this.getContentPanelActiveTab();
	                						   studentId = personProfile.getUserId();
	                						   studentInfo = this.getStudentDetailForErpPortal()
	                					   }
	                					   var batchId=studentInfo.programBatchDetails.batchId;
	                					   batchCombo.setDisabled(false);
	                					   var batchComboStore = batchCombo.getStore();
	                					   batchComboStore.getProxy().extraParams = {
	                						   programId: programId,
	                						   studentId:studentId,
	                						   onlyCurrentRecords:true
	                					   };
	                					   batchComboStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1) {
	                									   batchCombo.setValue(records[0].data.id);
	                								   }else if(records.length>0){
	                									   batchCombo.setValue(batchId);
	                								   } 
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   },
	                		   'studentjourneysearchform[itemId=studentjourneysearchformItemId] button[itemId=resetBtn]':{
	                			   click: function(obj){

	                				   var me = this;
		                			   var form  = me.getStudentjourneysearchform();

		                			   form.getForm().reset();
	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var programBatchField = form.down("#programBatch_programId");
	                				   var programBatchFieldStore = programBatchField.getStore();


	                				   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                					   this$.setAllowBlank(studentALField, false);
	                					   studentALField.show();

	                					   programBatchFieldStore.on('beforeload', function(store, operation) {
	                						   var selectedALId = studentALField.getValue();
	                						   var currentALId = me.getCurrentAcademyLocation();
	                						   store.proxy.extraParams.academyLocationIds = isNullOrEmpty(selectedALId) ? currentALId : selectedALId;
	                					   });

	                					   var studentALStore = studentALField.getStore();
	                					   var portalId = me.getCurrentLoggedPortalId();
	                					   var currentALId = me.getCurrentAcademyLocation();

	                					   if(portalId==7){
	                						   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                						   var admissionDetails=portalInfo.admissionDetails;
	                					   } else {
	                						   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                						   var admissionDetails=portalInfo.admissionDetails;
	                					   }

	                					   var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

	                					   studentALStore.getProxy().extraParams = {
	                						   admissionIds:admissionIds
	                					   };

	                					   studentALStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length > 0){
	                									   studentALField.setValue(currentALId);
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                				 }
	                		   },

	                		   'studentjourneysearchform button[itemId=searchBtn]':{
	                	       		  click: function(btn) {
	                	       			var me = this;
	                	       			  var form = btn.up('studentjourneysearchform');
	                	       			  var grid = this.getStudentjourneygrid();
	                	       			  var academyLocationId = this.getCurrentAcademyLocation();
		                				  var studentALField = form.down("#studentAcademyLocation").getValue();
	                	       			  var store = grid.getStore();
	                	       			 var user=me.getCurrentlyLoggedInUser();
	                	       			  store.getProxy().extraParams = {
	                	       				studentId : user.id,
	                      				  };
	                	       			  store.load();
	                	       		  }
	                	       	  }*/
				});
			}

});