/*
 * This controller is used for student profile related actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentListController', {    
	extend: 'Academia.controller.personinfo.common.PersonCommonController',

    stores: ['sunsuccess.FlagUserNameStore','sunsuccess.SunSuccessFlagColorStore', 'common.SelectNameComboStore', 'personinfo.common.services.KYSStatusStore', 
             'servicerequest.ServiceRequestCategory', 'servicerequest.ServiceRequests',
             'common.ProgramByAcAndLoIdStore','common.StatusComboStore',
             'program.programbatchdetail.BatchStore','admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
             'coursetransaction.sectionmanagement.CourseSectionCombo','coursetransaction.sectionmanagement.SectionsStore',
             'coursetransaction.coursereading.CourseByPeriod', 'coursetransaction.sectionmanagement.CourseSectionCombo',
             'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','attendance.StudentSearch','feeandpayment.managebill.Student',
             'setup.templatemapping.TemplateName','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
             'personinfo.faculty.FacultySurveyStr','importutility.ModuleName','attendance.SectionAndFacultyByPeriodID','importutility.ImportStudentList','importutility.ImportRelationshipList',
             'program.ProgramGroupStore','common.SeatTypesByBatchId','coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo',
             'program.ProgramByGroupIdStore','setup.templatemapping.TemplateNameList','setup.templatemapping.TemplateNameListStudentByCode',
             'student.studentprofile.AcademicTopicStore', 'student.studentprofile.AcademicSubTopicStore','reports.servicerequest.CertificateSubCategoryStore',
             'importutility.ImportStudentAcademicTopicListStore','committee.committee.CommitteeStore','attendance.UserGroup','hostel.roomallocation.UserSmartSearchByUserType',
             'enquiry.studentDetail.GenderStore','committee.committee.MessageTypeNotificationStore','messaging.MessagingTemplatesStore','messaging.StaticDocumentAttachmentGridStore',
             'personinfo.student.ChedExportTypeStore','personinfo.student.ChedExportTypeStore','importutility.ImportEducationHistoryList',
             'importutility.ImportPastHistoryTypeStore','common.IntakeYearStore','common.AcademicTermStore','program.ProgramCategoryStore',
             'criteriabuilder.userquicksearch.QuickSearchName','admission.applications.applicationBase.BulkDocumentGroupStore',
             'common.ReligionStore', 'common.CastCategoryStore','hostel.hostelapplication.HostelChoicesStore',
             'messaging.CommunicationHistoryReportList',
             'messaging.SendMessageReportRecipientStore',
             'messaging.SendMessageReportContactStore',
             'messaging.CommunicationHistoryEmailStore','election.election.ElectionCodeNameStore',
             'messaging.CommunicationHistoryMobileStore','election.election.ElectionVoterPoolCodeNameStore',
             'criteriabuilder.userquicksearch.QuickSearchPrintNameStore',
             'messaging.SendMessageReportEventNameStore','student.studentprofile.StudentTemplateTypeStore','personinfo.common.services.ServiceNameStore',
             'personinfo.common.services.CommunityNameStore',
             'Academia.store.common.GenderTypeStore','kohalibrarytransation.AcademyLocationCategoryStore',
             'kohalibrarytransation.AcademyLocationBranchStore','program.ProgramSortedSequenceWiseStore','servicerequest.servicerequestsettings.HostelLeaveCategories',
             'servicerequest.ServiceRequestConfiguredCategoryStore','messaging.SendMessageAttachedDocumentStore','common.ExamPassedStore','common.ExamBoardStore',
             'student.studentprofile.StudentStatusCSMStore','setup.templatemapping.DocumentRequesDGMListFaculty','common.AcademicTermByMappedPeriodStore',
             'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore','attendance.AttendanceProgramSectionStore','common.AllUserBySmartSearch','course.coursevariants.ChildCourseVariantStore',
             'Academia.store.attendance.facultyportal.AttendanceCourses','common.NationalIdStore','common.ExternalSysRefOneStore',
             'user.UserAcademyLocationStore',
             'Academia.store.program.programbatchdetail.SectionByPeriodId',
             'program.ProgramByGroupIdStore','student.managehold.StudentHoldCategoryNameStore','importutility.ImportAggregationsListStore',
             'student.managehold.StudentSubHoldCategoryNameStore','coursetransaction.sectionmanagement.FacultyIdValueSmartSearch','sunsuccess.FlagColorMappingStore','admission.applications.applicantProfileBase.ApplicantSmartSearchStudentListStore',
             'student.studentquicksearch.EnrollmentStautsComboStore','admission.applications.pandadoc.PandaDocTemplateStore','admission.applications.pandadoc.PandaDiscountAppliedStore',
             'admission.applications.pandadoc.PandaDocGridStore','user.UserPrimaryLocation','student.studentprofile.InactiveStatusCSMStore','program.programDetails.programBatches.programSeatType.SeatTypeByBatchIdStore','coursetransaction.studentenrollment.studentenrollmentdetail.AdmissionCodeSmartSearchStore',
             'importutility.StudentStatusLoaderGridStore','importutility.StudentPostGraduationLoaderStore',
			 'reports.servicerequest.PeriodCertificateMappingStore'],
    views: ['personinfo.student.StudentListView', 'personinfo.student.FindStudentForm', 'personinfo.student.StudentQuickSearchView', 
            'personinfo.student.StudentQuickSearchForm', 'personinfo.student.StudentProfile','personinfo.student.StudentbulkPrintWidow' ,
            'personinfo.common.PersonDetailsLinkPanel', 'personinfo.common.PersonInfoPanel', 
            'servicerequest.StudentRequestComboPanel','common.StatusCombo','login.AdminResetPasswordWindow','personinfo.student.StudentRaiseServiceRequestWindow',
            'personinfo.student.StudentSendSurvey','personinfo.student.StudentUploaddownloadStructure','personinfo.student.StudentUploadForm','personinfo.student.StudentRelationshipUploadForm'
            ,'importutility.ImportByModule.ImportRelationshipList','personinfo.student.StudentDownloadForm','importutility.ImportByModule.ImportStudentList','personinfo.student.StudentRelationshipStructure','personinfo.student.StudentRelationshipDownloadForm',
            'personinfo.dashlet.PersonInfoDashboardHomePage', 'personinfo.student.StudentAcademicTopicStructure','personinfo.student.StudentAcademicTopicUploadForm'
            , 'personinfo.student.StudentAcademicTopicDownloadForm', 'importutility.ImportByModule.ImportStudentAcademicTopicList','committee.committee.CommitteeALWindow',
            'personinfo.student.StudentSendMessages','messaging.StudentStaticDocumentAttachmentGrid','common.CertificateSelectionWindow',
            'personinfo.student.ChedExportWindow','personinfo.student.EducationHistoryUploadDownloadStructure','personinfo.student.EducationHistoryUploadForm',
            'personinfo.student.EducationHistoryDownloadForm','importutility.ImportByModule.ImportEducationHistoryList',
            'admission.applications.applicationBase.BulkDownloadDocumentWin',
            'messaging.report.CommunicationHistoryStructure',
			'messaging.report.CommunicationHistoryList',
			'personinfo.student.AggregationsTabStructure',
			'personinfo.student.ImportAggregationUploadForm','importutility.ImportByModule.ImportAggregationList','personinfo.student.ImportAggregationDownloadform',
			'personinfo.student.StudentProfile','personinfo.student.VoterPoolWindow',
			'personinfo.student.StudentTransferCardWindow',
			'UploadOptionRadioGroup','personinfo.student.StudentbulkPrintLabelsWidow','personinfo.student.StudentPrintTaxCertificate','admission.applications.applicationBase.OfferLetterDetailsWindow'
			,'kohalibrarytransaction.KohaStudentLibraryMappingWin','kohalibrarytransaction.KohaStudentCategoryMappingWin',
			 'messaging.report.SendMessageAttachedDocumentWin','personinfo.student.StudentStatusCSMWindow','personinfo.faculty.FacultyRequestDocumentWidow'
			 ,'personinfo.student.StudentPrintProfileWindow',
			 'examinationcenters.thesisManagement.EditThesisManagementFormWin',
			 'personinfo.student.StudentListStudentProgramTransferWindow','personinfo.common.services.ApplyForHostelForm','personinfo.student.StudentListApplyHolds','login.StudentBulkResetPasswordWindow','personinfo.student.FlagRequestStudentWindow','servicerequest.FlagRequestStudentPanel',
			 'personinfo.student.StudentListStudentProgramTransferForm','admission.applications.applicationBase.PandaDocPopup','personinfo.student.ChangePrimaryLocation', 'personinfo.student.ChangeSeatType',
			 'common.AttestationStatementOfStudentJourneyWindow','personinfo.student.StudentStatusLoaderStructure','personinfo.student.StudentStatusUploadForm','personinfo.student.StudentStatusDownloadForm',
			 'importutility.ImportByModule.ImportStudentList','importutility.ImportByModule.StudentStatusLoaderGrid',
			 'personinfo.student.StudentUploadPhotoWindow','personinfo.student.StudentImportPostGraduationStructure','personinfo.student.StudentPostGraduationUploadform','personinfo.student.StudentPostGraduationDownloadForm','importutility.ImportByModule.StudentPostGraduationLoaderGrid',
			 'personinfo.common.services.ApplyForWaitingListForm','feeandpayment.ChangeStartAttendanceDateWin'
			 ],
	model: ['authentication.StudentERPInfoModel'],

    alias: "widget.studentlistcontroller",
    studentDetails:'null',
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=StudentSearchResultGrid]'
    }, {
        ref: 'studentQuickSearchView',
        selector: 'studentquicksearchview'
    },{
        ref: 'raiseServiceRequestWindow',
        selector: 'studentraiseservicerequestwindow'
    }, {
        ref: 'studentQuickSearchForm',
        selector: 'studentquicksearchform'
    }, {
        ref: 'studentRequestComboPanel', 
        selector: 'studentrequestcombopanel'  
    },
    {
        ref: 'changeseattype', 
        selector: 'changeseattype'  
    },{
        ref: 'studentAdvanceSearchGrid',
        selector: 'studentlistview advancedsearchquerybuilder'
    },{
    	ref:'studentListView',
    	selector:'studentlistview'
    },{
    	ref:'adminresetpasswordwindow',
    	selector:'adminresetpasswordwindow[itemId=studentlistadminresetpasswordwindow]'
    },/*{
    	ref :'sendMessageWindow',
    	selector : 'sendmessagewindow[itemId=studentListSendMessageWindows]'
    },*/{
    	ref :'studentsendmessages',
    	selector : 'studentsendmessages[itemId=studentListSendMessageWindows]'
    },{
    	ref :'studentDocumentMessageAttachmentGrid',
    	selector : 'studentstaticdocumentattachmentgrid [itemId=studentStaticDocumentAttachmentGridMessage]'
    },{
    	ref :'studentbulkprintwidow',
    	selector : 'studentbulkprintwidow'
    },{
    	ref :'studentbulkPrintwidow',
    	selector : 'studentbulkprintwidow form'
    },{
    	ref :'studenttransfercardwindow',
    	selector : 'studenttransfercardwindow'
    },{
    	ref :'studenttransfercardwindow',
    	selector : 'studenttransfercardwindow form'
    },{
    	ref :'studentsendsurvey',
    	selector : 'studentsendsurvey'
    },{
    	ref :'studentSendsurvey',
    	selector : 'studentsendsurvey form'
    },{
    	ref :'studentuploadform',
    	selector : 'studentuploadform'
    },{
    	ref :'studentdownloadform',
    	selector : 'studentdownloadform'
    },{
    	ref :'importstudentlist',
    	selector : 'importstudentlist'
    },{
    	ref :'studentrelationshipstructure',
    	selector : 'studentrelationshipstructure'
    },{
    	ref :'studentrelationshipuploadform',
    	selector : 'studentrelationshipuploadform'
    },{
    	ref :'studentrelationshipdownloadform',
    	selector : 'studentrelationshipdownloadform'
    },{
    	ref :'importrelationshiplist',
    	selector : 'importrelationshiplist'
    },{
    	ref :'personinfodashboardhomepage',
    	selector : 'personinfodashboardhomepage'
    },{
    	ref :'studentacademictopicdownloadform',
    	selector : 'studentacademictopicdownloadform'
    },{
    	ref :'importstudentacademictopiclist',
    	selector : 'importstudentacademictopiclist'
    },{
    	ref :'studentcommitteealwindow',
    	selector : 'committeealwindow [itemId=studentMapCommitteeWindow]'
    },{
    	ref :'certificateselectionwindow',
    	selector : 'certificateselectionwindow[itemId=studentListCertificateSelectionWindow]'
    },{
		ref: 'chedexportwindow',
		selector: 'chedexportwindow'
	},{
		ref: 'educationhistoryuploaddownloadstructure',
		selector: 'educationhistoryuploaddownloadstructure'
	},{
		ref: 'educationhistoryuploadform',
		selector: 'educationhistoryuploadform'
	},{
		ref: 'educationhistorydownloadform',
		selector: 'educationhistorydownloadform'
	},{
		ref: 'importeducationhistorylist',
		selector: 'importeducationhistorylist'
	},{
        ref: 'bulkdownloaddocumentwin',
        selector: 'bulkdownloaddocumentwin[itemId=studentbulkdownloaddocumentwin]'
    },{
		ref : 'communicationhistorystructure',
		selector : 'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId]'
	},{
    	ref : 'communicationhistorylist',
    	selector : 'communicationhistorylist'
	},{
		ref : 'studentprofile',
		selector : 'studentprofile'
	},{
		ref : 'studentPastHistoryuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=studentPastHistoryUploadOptionRadioGroupItemId]'
	},{
		ref : 'studentAcademicTopicuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=studentAcademicTopicUploadOptionRadioGroupItemId]'
	},{
		ref : 'importAggregationsuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=importAggregationsUploadOptionRadioGroupItemId]'
	},{
		ref : 'studentRelationshipuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=studentRelationshipUploadOptionRadioGroupItemId]'
	},{
		ref : 'studentuploadformuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=studentUpdateUploadOptionRadioGroupItemId]'
	},{
    	ref :'studentbulkprintlabelswidow',
    	selector : 'studentbulkprintlabelswidow'
    },{
    	ref :'studentbulkPrintlabelswidow',
    	selector : 'studentbulkprintlabelswidow form'
    },{
    	ref :'studentprinttaxcertificate',
    	selector : 'studentprinttaxcertificate'
    },{
    	ref :'studentprinttaxcertificate',
    	selector : 'studentprinttaxcertificate form'
    },{
        ref: 'offerletterdetailswindow',
        selector: 'offerletterdetailswindow[itemId=studentofferletterdetailswindow]'
    },{
		ref: 'kohastudentlibrarymappingwin',
		selector: 'kohastudentlibrarymappingwin'
	},{
		ref: 'kohastudentcategorymappingwin',
		selector: 'kohastudentcategorymappingwin'
	},{
		ref: 'studentstatuscsmwindow',
		selector: 'studentstatuscsmwindow'
	},{
    	ref : 'sendmessageattacheddocumentwin',
    	selector : 'sendmessageattacheddocumentwin[itemId=studentsendmessageItemId]'
    },{
    	ref :'facultyrequestdocumentwidow',
    	selector : 'facultyrequestdocumentwidow[itemId=studentrequestdocumentId]'
    },{
		ref: 'voterpoolwindow',
		selector: 'voterpoolwindow[itemId=studentvoterpoolwindow]'
	},{
		ref : 'editthesismanagementformwin',
		selector : 'editthesismanagementformwin'
	},{
    	ref :'studentprintprofilewindow',
    	selector : 'studentprintprofilewindow'
    },{
    	ref :'studentPrintProfileWindow',
    	selector : 'studentprintprofilewindow form'
    },{
    	ref: 'studentliststudentprogramtransferwindow',
    	selector: 'studentliststudentprogramtransferwindow'
    },{
		ref: 'studentlistapplyholds',
		selector: 'studentlistapplyholds'
    },{
		ref: 'applyforhostelform',
		selector: 'applyforhostelform'
    },{
		ref:'studentbulkresetpasswordwindow',
	    selector:'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow]'
	},{
		ref:'flagrequeststudentwindow',
	    selector:'flagrequeststudentwindow'
	},{
		ref:'flagrequeststudentpanel',
	    selector:'flagrequeststudentpanel '
	},{
		ref:'aggregationstabstructure',
	    selector:'aggregationstabstructure'
	},{
		ref:'importaggregationdownloadform',
	    selector:'importaggregationdownloadform'
	},{
		ref:'importaggregationuploadform',
	    selector:'importaggregationuploadform'
	},{
		ref:'importaggregationlist',
	    selector:'importaggregationlist'
	},{
		ref:'studentliststudentprogramtransferform',
	    selector:'studentliststudentprogramtransferform'
	},{
 		ref: 'pandadocpopup',
 		selector: 'pandadocpopup' 
    },{
    	ref :'changeprimarylocation',
    	selector : 'changeprimarylocation[itemId=changeprimarylocationId]'
    },{
    	ref :'studentacademictopicstructure',
    	selector : 'studentacademictopicstructure'
    }, {
		ref: 'attestationstatementofstudentjourneywindow',
		selector: 'attestationstatementofstudentjourneywindow'
	},{
		ref:'studentstatusloaderstructure',
		selector:'studentstatusloaderstructure'
	},{
		ref:'studentstatusuploadform',
		selector:'studentstatusuploadform'
	},{
		ref:'studentstatusdownloadform',
		selector:'studentstatusdownloadform'
	},{
		ref:'studentstatusloadergrid',
		selector:'studentstatusloadergrid'
	},{
		ref: 'studentuploadphotowindow',
		selector: 'studentuploadphotowindow[itemId=studentuploadphotowindow]'
	},{
		ref:'studentImportPostGraduationStructure',
		selector:'studentImportPostGraduationStructure'
	},{
		ref:'studentPostGraduationUploadform',
		selector:'studentPostGraduationUploadform'
	},{
		ref:'studentPostGraduationDownloadForm',
		selector:'studentPostGraduationDownloadForm'
	},{
		ref:'studentPostGraduationLoaderGrid',
		selector:'studentPostGraduationLoaderGrid'
	},{
		ref:'applyforwaitinglistform',
		selector:'applyforwaitinglistform[itemId=applyforwaitinglistformStudentList]'  
	},{
		ref:'changestartattendancedatewin',
		selector:'changestartattendancedatewin'
	}],
    config: {
    	STUDENT_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LIST_PRIVILEGES'),
    	STUDENT_MY_DASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MY_DASHBOARD_PRIVILEGES'),
   		CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
   		STUDENT_CERTIFICATE_PRINTAS_WORDFILE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_CERTIFICATE_PRINT_AS_WORD_FILE_PRIVILEGES'),
   		STUDENT_PROFILE_COMMUNICATION_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COMMUNICATION_HISTORY_PRIVILEGES'),
    	requestType: 'STUDENT_REQUEST'   
 },
    init: function(application) {
        this.control({
        	
        	'kohastudentlibrarymappingwin customcombobox[itemId=library]':{
				render: function(cmb){
					var store = cmb.getStore();
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation()
					};
					store.load();
				}
			},
			'kohastudentcategorymappingwin customcombobox[itemId=category]':{
				render: function(cmb){
					var store = cmb.getStore();
					store.getProxy().extraParams = {
						academyLocationId: this.getCurrentAcademyLocation()
					};
					store.load();
				}
			},
        
        	'studentrelationshipstructure radiogroup[itemId=importDownloadgroupId]':{
	   			   change: this.downloadUploadRelationshipChange
        	 }, 
        	 
        	 'studentrelationshipdownloadform[itemId=studentrelationshipdownloadformId] button[itemId=programBatchDownolad]':{
        		 click:function(obj){
        			 var $this = this;
        			 var form =$this.getStudentrelationshipdownloadform();
        			 var values = $this.getJsonForRelationship();

        			 var csvForm = Ext.create('Ext.form.Panel',{
        				 items:[{
        					 xtype : 'textfield',
        					 maxLength : 20480,
        					 itemId : 'exportListDTO',
        					 name : 'exportListDTO',
        					 vtype : 'spaceAsInput'
        				 }]
        			 });

        			 csvForm.down('#exportListDTO').setValue(values);
        			 csvForm.getForm().submit({
        				 target: '_blank',
        				 method:'POST',
        				 params :{access_token : Ext.Ajax.defaultHeaders.access_token},
        				 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        				 url: SERVERURL.PATH_STUDENT_RELATIONSHIP_DOWNLOAD,
        				 standardSubmit :true,
        				 success : function(form, action){
        					 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
        				 },
        				 failure: function(form, action) {
        					 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
        				 }
        			 });
        		 }  
        	 },
        	 
        	 'studentrelationshipdownloadform[itemId=studentrelationshipdownloadformId] button[itemId=resetBtn]':{
        		 click: function(obj){
        			 var form = this.getStudentrelationshipdownloadform();
        			 var pbpsContiner = form.down('#programBatchContainerId');
        			 var newcont=pbpsContiner.items.items.length;
        			 for(var i=newcont-1;i>0;i--){
        				 pbpsContiner.remove(pbpsContiner.items.items[i]);
        			 }
        			 form.doLayout();
        			 form.getForm().reset();
        			 form.down('#batch').setDisabled(true);
        			 form.down('#period').setDisabled(true);
        			 form.down('#sectionId').setDisabled(true);
        		 }
        	 },
        	 
        	 /***
        	  * Added multiple program and batch wise template will download.
        	  */
        	 'studentrelationshipdownloadform button[itemId=addFilterBtn]':{
        		 click: function(obj){
        			 this.addStudentRelationshipMultipleProgramBatchfilter(obj);
        		 }
        	 },
        	 
        	 'studentrelationshipdownloadform[itemId=studentrelationshipdownloadformId] combo[itemId=program]': {
                	render : function(combo){
                		var academyLocationId = this.getCurrentAcademyLocation();
                       	var store = combo.getStore();
                       	store.proxy.extraParams = {
      							 academyLocationId : academyLocationId
      					};
                       	store.load();
                    }
                },
  	 		   'studentrelationshipuploadform uploadoptionradiogroup[itemId=studentRelationshipUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
 	 			   change: function( radioGroup, newValue, oldValue, eOpts){
 	 				   var grid =this.getImportrelationshiplist();
 	 				   var form =this.getStudentRelationshipuploadoptionradiogroup();
 	 				   var isUploadAll = newValue.isUploadAll;
 	 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_STUDENT_RELATIONSHIP_UPLOAD');
 	 			   }   
 	 		   },
        	 
             'studentrelationshipuploadform button[itemId=programBatchUpload]':{
	        		click:function(obj){
	        			var $this=this;
 	    	        	var importWin=$this.getStudentrelationshipuploadform()
 	    	        	var grid = $this.getImportrelationshiplist();
 	    	        	var grdStore;
 	    	        	var form=$this.getStudentrelationshipuploadform();
 	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
 	    	        	$this.getHashOfFile(form);
 	    	        	setTimeout(function() {
	 	    	        	form.getForm().submit({
	 	    	        		method : 'POST',
	 	    	        		url : submitUrl,
	 	    	        		success : function(form, action){
	 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	    	        },
	 	    	        		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	 	    	    	        }
	 	    	        	});
 	    	        	},1000);
	 	    	        	
 	    	        	 Ext.defer(function() {
 	    	        		var form = $this.getStudentRelationshipuploadoptionradiogroup();
     	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
     	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_RELATIONSHIP_UPLOAD');
	         	        }, 2000, this);
 	        		}  
     		 },   
             
        	 'studentrelationshipuploadform button[itemId=resetBtn]':{
	        		click:function(obj){
	        			var $this=this;
	        			var form = $this.getStudentrelationshipuploadform().getForm();
	        			form.findField('file').reset();
	        			var uploadoptionradiogroupform  = $this.getStudentRelationshipuploadoptionradiogroup();
	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	        				isUploadAll: false
	        			});
	        		}
     		 },

     		 'educationhistoryuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
     			 change: this.downloadUploadEducationHistoryChange
     		 }, 

     		 'educationhistorydownloadform[itemId=educationhistorydownloadformId] button[itemId=programBatchDownolad]':{
     			 click:function(obj){
     				 var $this = this;
     				 var form =$this.getEducationhistorydownloadform();
     				 var values = $this.getJsonForEducationHistory();
     				 var templateType=form.getValues().templateType;
     				 var csvForm = Ext.create('Ext.form.Panel',{
     					 items:[{
     						 xtype : 'textfield',
     						 maxLength : 20480,
     						 itemId : 'exportListDTO',
     						 name : 'exportListDTO',
     						 vtype : 'spaceAsInput'
     					 }]
     				 });

     				 csvForm.down('#exportListDTO').setValue(values);
     				 csvForm.getForm().submit({
     					 target: '_blank',
     					 method:'POST',
     					 params :{access_token : Ext.Ajax.defaultHeaders.access_token},
     					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
     					 url: SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_DOWNLOAD,
     					 standardSubmit :true,
     					 success : function(form, action){
     						 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
     					 },
     					 failure: function(form, action) {
     						 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
     					 }
     				 });
     			 }  
     		 },

     		 'educationhistorydownloadform[itemId=educationhistorydownloadformId] button[itemId=resetBtn]':{
     			 click: function(obj){
     				 var form = this.getEducationhistorydownloadform();
     				 var pbpsContiner = form.down('#programBatchContainerId');
     				 var templateTypeItemId = form.down('#templateTypeItemId');
     				 var newcont=pbpsContiner.items.items.length;
     				 for(var i=newcont-1;i>0;i--){
     					 pbpsContiner.remove(pbpsContiner.items.items[i]);
     				 }
     				 form.doLayout();
     				 form.getForm().reset();
     				 templateTypeItemId.setValue('');
     			 }
     		 },

     		 /***
     		  * Added multiple program and batch wise template will download.
     		  */
     		 'educationhistorydownloadform button[itemId=addFilterBtn]':{
     			 click: function(obj){
     				 this.addEducationHistoryMultipleProgramBatchfilter(obj);
     			 }
     		 },

     		 'educationhistorydownloadform[itemId=educationhistorydownloadformId] combo[itemId=program]': {
     			 render : function(combo){
     				 var academyLocationId = this.getCurrentAcademyLocation();
     				 var store = combo.getStore();
     				 store.proxy.extraParams = {
     						 academyLocationId : academyLocationId
     				 };
     				 store.load();
     			 }
     		 },
     		 'educationhistorydownloadform[itemId=educationhistorydownloadformId] combo[itemId=templateTypeItemId]': {
     			change : function(val,nV,oV){
     				 var form = this.getEducationhistorydownloadform();
     				 var examPassedField = form.down('#examPassed');
     				 var examBoardField = form.down('#examBoard');
    				 if(nV == 'CompetitiveExam'){
    					 examPassedField.setVisible(false);
    					 examBoardField.setVisible(false);
    				 }
    				 else{
    					 examPassedField.setVisible(true);
    					 examBoardField.setVisible(true);
    				 }
    			}
     		 },
     		 
     		 'educationhistoryuploadform': {
     			afterrender: function(form){
     				/*var importUtilityMasterId = form.getForm().findField('importUtilityMasterId');
     				importUtilityMasterId.setValue('');*/
     			} 
     		 },
	        'educationhistoryuploadform uploadoptionradiogroup[itemId=studentPastHistoryUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	        	change: function( radioGroup, newValue, oldValue, eOpts){
	        		var grid =this.getImporteducationhistorylist();
	        		 var educationhistoryuploadform=this.getEducationhistoryuploadform();
     				 var templateName = educationhistoryuploadform.getValues().uploadType;
     				 var moduleName = null;
     				 submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
     				 switch (templateName){
     				 case 'CompetitiveExam':
     					 moduleName = 'Bulk Competitive Exam';
     					 break;
     				 case 'EducationHistory':
     					 moduleName = 'Bulk Education History';
     					 break;
     				 default : null;
     				 }
	        		var form =this.getStudentPastHistoryuploadoptionradiogroup();
	        		var isUploadAll = newValue.isUploadAll;
	        		this.onChangeUploadOptionRadioGroup(isUploadAll,grid, moduleName);
	        	}   
	 		   },
 	 
     		 'educationhistoryuploadform button[itemId=programBatchUpload]':{
     			 click:function(obj){
     				 var $this=this;
     				 var form=$this.getEducationhistoryuploadform();
     				 var templateName = form.getValues().uploadType;
     				 var moduleName = null;
     				 submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
     				 switch (templateName){
     				 case 'CompetitiveExam':
     					 moduleName = 'Bulk Competitive Exam';
     					 break;
     				 case 'EducationHistory':
     					 moduleName = 'Bulk Education History';
     					 break;
     				 default : null;
     				 }
     				 $this.getHashOfFile(form);
     				 setTimeout(function() {
	     				 form.getForm().submit({
	     					 method : 'POST',
	     					 url : submitUrl,
	     					 success : function(form, action){
	     						 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	     					 },
	     					 failure: function(form, action) {
	     						 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	     					 }
	     				 });
     				 },1000);
     				 Ext.defer(function() {
     					 var grid = $this.getImporteducationhistorylist();
     					 var form = $this.getStudentPastHistoryuploadoptionradiogroup();
     					 var isUploadAll = form.items.items[0].getValue().isUploadAll;
     					 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
     				 }, 2000, this);
     			 }
     		 },   
         
     		 'educationhistoryuploadform customcombobox[itemId=uploadTypeItemId]': {
     			 select: function(obj, record) {
     				 var $this = this;
     				 var form = this.getEducationhistoryuploadform().getForm();
     				 var templateName = form.getValues().uploadType;
     				 var moduleName = null;
     				 switch (templateName){
     				 case 'CompetitiveExam':
     					 moduleName = 'Bulk Competitive Exam';
     					 break;
     				 case 'EducationHistory':
     					 moduleName = 'Bulk Education History';
     					 break;
     				 default : null;
     				 }
     				 var combo = form.findField('importUtilityMasterId');
     				 combo.getStore().load({
     					 callback: function(records, operation, success) {
     						 for(var i in records){
     							 if(records[i].data.value==moduleName){
     								 combo.setValue(records[i].data.id);
     								 combo.setReadOnly(true);
     							 }
     						 }
     					 }	   
     				 });
     				 var grid = $this.getImporteducationhistorylist();
     				 var form = $this.getStudentPastHistoryuploadoptionradiogroup();
     				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
     				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
     			 }
     		 },
      
		 'educationhistoryuploadform button[itemId=resetBtn]':{
			 click:function(obj){
				 var $this=this;
				 var form = $this.getEducationhistoryuploadform().getForm();
				 form.reset();
				 form.findField('file').reset();
				 var uploadoptionradiogroupform  = $this.getStudentPastHistoryuploadoptionradiogroup();
				 uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
					 isUploadAll: false
				 });
				 form.isValid();
			 }
		 },
    	 
        	'studentquicksearchform' : {
        		render : function(){
        			this.customzingViewForStudentPortal();
        			 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                 var whetherSchool = alinfomodel.get('wheatherSchool');
	                 var this$ = this;
		             var basicStudentSearchForm=this.getStudentQuickSearchForm();
		         	 var period = basicStudentSearchForm.down('#period');
		        	 var seatType = basicStudentSearchForm.down('#seatType');
	                   if(whetherSchool){
	                	 period.setVisible(false);
	                	 seatType.setVisible(false);
	                   }
        		}
        	},
        	'studentlistview':{
        		activate: function(structure) {
        			var $this=this;
        			if($this.getCurrentLoggedPortalId() == 3 || $this.getCurrentLoggedPortalId() == 7){
        				$this.customzingViewForStudentPortal();
        			}else{
        				//structure.down('grid').getSelectionModel().deselectAll(true);
        				//$this.loadGridAndSearchUsers(); 
        			}
        		},
        		beforerender:function(structure){
        			this.disablestndetImportTabs(structure, this.getSTUDENT_LIST_PERMISSIONS());
        		},
        		afterrender : function(structure){
	        			var $this=this; 
	        			var grid;
	        			
	        			structure.body.on('scroll',function(e,target) {
	              		if(structure.items.items[0].activeTab.title=="Bulk Document Download Status")
	              			{
	              				grid=structure.down('studentbulkdownloadstatusgrid');
		              			$this.getMultipleCBGridHeaderFreeze(grid,structure,true);
	              			}else
	              				{
	              				//grid = structure.down('searchresultgrid');
	              				//$this.getCBGridHeaderFreeze(grid,structure,false);
	              				}
	        			});	
	        			
        		}
        	},
            'studentquicksearchview studentquicksearchform[itemId=studentQuickSearch] combo[itemId=selectedNameField]': {
                change: this.changeNameFieldConfig
            },
            'studentquicksearchform[itemId=studentQuickSearch] button[itemId=searchButtonId]': {
            	click: function(){
            		       var form=this.getStudentQuickSearchForm();
            		       if(form.isValid())
            		         this.loadGridAndSearchUsersWithButtonPermission();
       			}
                
            },
            /*'studentquicksearchform[itemId=studentQuickSearch] customcombobox[itemId=admissionStatus]': {
            	change: function(obj){
            			var form = obj.up('form');
            			var admissionStatus = form.down('#admissionStatus');
            			var inactiveReasonStatusId = form.down('#inactiveReasonStatusItemId');
            			if(!isNullOrEmpty(admissionStatus) && admissionStatus==false) {
            				    inactiveReasonStatusId.setDisabled(false);                    
            			}else{
            				inactiveReasonStatusId.reset();
            				inactiveReasonStatusId.setDisabled(true);
            				}                  				
       			}
                
            },*/
            'studentquicksearchform[itemId=studentQuickSearch] button[itemId=resetButtonId]': {
                click: function(){
                	this.resetStudentQuickSearchForm();
                }
            },
            'studentquicksearchform[itemId=studentQuickSearch] customcombobox[itemId=nationalID]': {
                afterrender: function(field){
                   var SearchForm = this.getStudentQuickSearchForm();
                   var searchResultForm = SearchForm.getForm();
                   var nationalId =searchResultForm.findField('NATIONAL_ID');
                   this.loadDFRForNationalId(nationalId);
                }
            },
            'studentquicksearchform[itemId=studentQuickSearch] customcombobox[itemId=studentId]': {
            	afterrender: function(field){
            		var SearchForm = this.getStudentQuickSearchForm();
     	            var searchResultForm = SearchForm.getForm();
     	            var statusVal =searchResultForm.findField('STATUS').getValue();
     	            var admissionStatusVal =searchResultForm.findField('ADMISSION_STATUS').getValue();
     	            
     	           var studentStore=field.getStore();
				   studentStore.getProxy().extraParams = {
					   allStudents:false,
					   status:statusVal,
					   admissionStatus:admissionStatusVal
				   };
                }
            },
            'studentquicksearchform[itemId=studentQuickSearch] customcombobox[itemId=admissionId]': {
            	afterrender: function(field){
            		var SearchForm = this.getStudentQuickSearchForm();
     	            var searchResultForm = SearchForm.getForm();
     	            var statusVal =searchResultForm.findField('STATUS').getValue();
     	            var admissionStatusVal =searchResultForm.findField('ADMISSION_STATUS').getValue();
     	            var academyLocationVal =this.getCurrentAcademyLocation();
     	            
     	           var studentAdStore=field.getStore();
     	          studentAdStore.getProxy().extraParams = {
					   status:statusVal,
					   admissionStatus:admissionStatusVal,
					   academyLocationId:academyLocationVal
					   
				   };
                }
            },
            
            'studentquicksearchform[itemId=studentQuickSearch] customcombobox[itemId=applicantName]': {
            	select: function(field){
            		var SearchForm = this.getStudentQuickSearchForm();
     	            var searchResultForm = SearchForm.getForm();
     	            var statusVal =searchResultForm.findField('APPICANT_PRINT_NAME').getRawValue();
     	            var statusValCompare =searchResultForm.findField('APPICANT_PRINT_NAME').getValue();
            		this.resetStudentQuickSearchForm();
            		  // SearchForm.down('#moreFiltersPnl').collapse();
                       SearchForm.down('#intakeYear').setDisabled(true);
                       SearchForm.down('#academicTerm').setDisabled(true);
                       SearchForm.getForm().findField("PROGRAM_CATEGORY").setDisabled(true);
                       SearchForm.down('#programGroupId').setDisabled(true);
                       SearchForm.down('#program').setDisabled(true);
                       SearchForm.down('#batch').setDisabled(true);
                       SearchForm.down('#period').setDisabled(true);
                       SearchForm.down('#seatType').setDisabled(true);
                       SearchForm.down('#section').setDisabled(true);
                       SearchForm.down('#course').setDisabled(true);
                       SearchForm.down('#courseVarientId').setDisabled(true);
                       SearchForm.down('#externalSysRefOne').setDisabled(true);
                       SearchForm.down('#statusComboItemId').setDisabled(true);
                       SearchForm.down('#admissionStatus').setDisabled(true);
                       SearchForm.down('#studentStatusItemId').setDisabled(true);
                       SearchForm.down('#phone_No').setDisabled(true);
                       SearchForm.down('#emailId').setDisabled(true);
                       SearchForm.down('#gender').setDisabled(true);
                       SearchForm.down('#religionCombo').setDisabled(true);
                       SearchForm.down('#castCategoryCombo').setDisabled(true);
                       SearchForm.down('#advisorNameItemId').setDisabled(true);
                       SearchForm.down('#nationalID').setDisabled(true);
                       SearchForm.down('#admissionFromDateId').setDisabled(true);
                       SearchForm.down('#admissionToDateId').setDisabled(true);
                       SearchForm.down('#debaredStudents').setDisabled(true);
                       SearchForm.down('#MODE_OF_DELIVERY').setDisabled(true);
                       SearchForm.down('#PROGRAM_STATUS').setDisabled(true);
                       SearchForm.down('#applicantName').setValue(statusValCompare);
                 }
            },
            
            'studentquicksearchform[itemId=studentQuickSearch]  combo[itemId=applicantName]': {
            	change : function(selectionProcessCombo) {
            		var basicSearchForm = selectionProcessCombo.up('studentquicksearchform');
	            	var academyLocationId = this.getCurrentAcademyLocation();
            		var SearchForm = this.getStudentQuickSearchForm().down('#applicantName').getStore();; 		
            		SearchForm.getProxy().extraParams = {
            			academyLocationId: academyLocationId
            		};
            	}
            }, 
                       'studentquicksearchform[itemId=studentQuickSearch] statusCombo[itemId=statusComboItemId]': {
            	change: function(obj, record) {
            		var form = obj.up('form');
            		var searchResultForm = form.getForm();
            		var statusVal = searchResultForm.findField('STATUS').getValue();
            		var admissionStatusVal =searchResultForm.findField('ADMISSION_STATUS').getValue();
            		var allStudentsVal = true;
            		if(statusVal && admissionStatusVal){
            			allStudentsVal = false;
            		}
            		var student = form.down('#studentId');

            		student.clearValue();
            		student.store.removeAll();
            		var store = student.getStore();
            		store.getProxy().extraParams = {
            			allStudents:allStudentsVal,
            			status:statusVal,
            			admissionStatus:admissionStatusVal
            		};
            		store.reload();
            		
            		var admissionId = form.down('#admissionId');

            		admissionId.clearValue();
            		admissionId.store.removeAll();
            		var Adstore = admissionId.getStore();
            		var academyLocationIdVal = this.getCurrentAcademyLocation();
            		Adstore.getProxy().extraParams = {
            			status:statusVal,
            			admissionStatus:admissionStatusVal,
            			academyLocationId:academyLocationIdVal
            		};
            		Adstore.reload();
            		/*var debaredStudentsField = form.down('#debaredStudents');
            		if(!statusVal && !admissionStatusVal) {
            			debaredStudentsField.setDisabled(false);
            		} else {
            			debaredStudentsField.setDisabled(true);
            			debaredStudentsField.reset();
            		}*/
            		
            		var admissionStatus = form.down('#admissionStatus');
            		var status = form.down('#statusComboItemId');
        			var inactiveReasonStatusId = form.down('#inactiveReasonStatusItemId');
        			if(!isNullOrEmpty(admissionStatus.getValue()) && admissionStatus.getValue()==false
        					&& !isNullOrEmpty(status.getValue()) && status.getValue()==true ) {
        				    inactiveReasonStatusId.setDisabled(false);                    
        			}
        			else if(!isNullOrEmpty(admissionStatus.getValue()) && admissionStatus.getValue()==false
        					&& !isNullOrEmpty(status.getValue()) && status.getValue()==false ) {
        				    inactiveReasonStatusId.setDisabled(false);                    
        			}

            	}
            },
            'studentquicksearchform[itemId=studentQuickSearch] customcombobox[itemId=admissionStatus]': {
            	change: function(obj, record) {
            		var form = obj.up('form');
            		var searchResultForm = form.getForm();
            		var statusVal = searchResultForm.findField('STATUS').getValue();
            		var admissionStatusVal =searchResultForm.findField('ADMISSION_STATUS').getValue();
            		if(admissionStatusVal){
            			form.down('#inactiveReasonStatusItemId').reset();
            		}
            		var allStudentsVal = true;
            		if(statusVal && admissionStatusVal){
            			allStudentsVal = false;
            		}
            		var student = form.down('#studentId');

            		student.clearValue();
            		student.store.removeAll();
            		var store = student.getStore();
            		store.getProxy().extraParams = {
            			allStudents:allStudentsVal,
            			status:statusVal,
            			admissionStatus:admissionStatusVal
            		};
            		store.reload();
            		var admissionId = form.down('#admissionId');

            		admissionId.clearValue();
            		admissionId.store.removeAll();
            		var academyLocationIdVal = this.getCurrentAcademyLocation();
            		var Adstore = admissionId.getStore();
            		Adstore.getProxy().extraParams = {
            			status:statusVal,
            			admissionStatus:admissionStatusVal,
            			academyLocationId:academyLocationIdVal
            		};
            		Adstore.reload();
            		
            		/*var debaredStudentsField = form.down('#debaredStudents');
            		if(!statusVal && !admissionStatusVal) {
            			debaredStudentsField.setDisabled(false);
            		} else {
            			debaredStudentsField.setDisabled(true);
            			debaredStudentsField.reset();
            		}*/
            		var admissionStatus = form.down('#admissionStatus');
            		var status = form.down('#statusComboItemId');
        			var inactiveReasonStatusId = form.down('#inactiveReasonStatusItemId');
        			inactiveReasonCSMObj = {};
        			Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.FIND_ADMISSION_INACTIVE_REASON_BY_CODE,
							method : 'GET',
							async: false,
							success : function(response, action) {
								if(response.responseText != ""){
									var responseArray = Ext.decode(response.responseText);
									for (var i = 0; i < responseArray.length; i++) {
									  var item = responseArray[i];
									  inactiveReasonCSMObj[item.code] = item.value;
									}
								}
								inactiveReasonStatusId.getStore().load();
							}
					});
        			if(!isNullOrEmpty(admissionStatus.getValue()) && admissionStatus.getValue()==false
        					&& !isNullOrEmpty(status.getValue()) && status.getValue()==true ) {
        				    inactiveReasonStatusId.setDisabled(false);                    
        			}
        			else if(!isNullOrEmpty(admissionStatus.getValue()) && admissionStatus.getValue()==false
        					&& !isNullOrEmpty(status.getValue()) && status.getValue()==false ) {
        				    inactiveReasonStatusId.setDisabled(false);                    
        			}else{
        				inactiveReasonStatusId.reset();
        				inactiveReasonStatusId.setDisabled(true);
        				}  
            	}
            },
            'studentquicksearchview searchresultgrid[itemId=StudentSearchResultGrid]': {
                cellclick: this.cellClickStudentSearchResultGrid,
                render: function(grid) {
	    			this.gridRenderFunctionForStudent(grid);
	    			this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_LIST_PERMISSIONS());
	    			this.disableMoreActionPivileges(grid, this.getSTUDENT_LIST_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false); 			
	    		},
	    		afterrender : function(grid){
	    			var this$ = this;
	    			this$.addDataGridConfigButton(grid,this$.getSTUDENT_LIST_PERMISSIONS());	    			
                },
	         	selectionchange: function(column, selected,eOpts ){
                	this.disableExtraButton(column,selected);  
            		var grid = column.view.up('grid');
            		var studentListProgramTransfer = grid.down('#studentListProgramTransfer');
                	if(selected.length==1){
                		if (grid.getSelectionModel().getSelection()[0].data.STATUS=='Inactive') {
            				grid.down('#studentListProgramTransfer').setDisabled(true);
            				grid.down('#inactiveStudentMoreActionBtn').setDisabled(true);
            			}else{
            				studentListProgramTransfer.setDisabled(false);
            			}
                	}
                	else{
                		studentListProgramTransfer.setDisabled(true);
                	}
                	
                }
            },
            'advancedsearchquerybuilder[itemId=studentListAdvanceSearch] searchresultgrid[itemId=userAdvSearchResultGrid]': {
                cellclick: this.cellClickStudentSearchResultGrid,
                /*render: function(grid) {
	    			this.gridRenderFunction(grid);
	    			//this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_LIST_PERMISSIONS());
 					//var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		//viewButton.setVisible(false);
	    		}*/
            },
            
          /*  'studentlistview advancedsearchquerybuilder': {
                render: function(panel) {
                    var comboPanel = Ext.widget('studentrequestcombopanel');
                    panel.add(comboPanel);
                }
            },*/
            
            'studentraiseservicerequestwindow studentrequestcombopanel button[itemId=raiseButtonId]': {
 	            click: function(btn) {
			
 	            	$this=this;
 	            	var serviceRequestCategoryCombo = btn.up('form').down('#serviceRequestCategoryCombo').getValue();
 	            	var serviceRequestCombo = btn.up('form').down('#serviceRequestCombo').valueModels[0];
 	            	var grid = this.getSearchResultGrid();
 	            	var requestCategoryCombo = btn.up('form').down('#RequestCategoryCombo').valueModels[0];
 	            	 var advisorName=grid.getSelectionModel().selected.items[0].raw.ADVISOR_NAME;
 	            	 var serviceRequestComboVal =btn.up('form').down('#serviceRequestCombo');
 	            	 if(serviceRequestComboVal.rawValue == 'Section Transfer' && !grid.getSelectionModel().selected.items[0].data.SECTION_CODE){
						  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_CHECK_STUDENT_IS_ENROLLED_IN_PBS_OR_NOT'));
						  return;
					  }
 	            	
 	            	if(serviceRequestCombo!=undefined && serviceRequestCombo.data.code=='HLR'){
 	            		var academyLocationId = this.getCurrentAcademyLocation();
 	                var studentId=grid.getSelectionModel().selected.items[0].raw.STUDENT_M_KEY[0].ID;
						Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.FIND_WHETHER_CHECKEDIN,
							method : 'GET',
							params : {
			 					studentId : studentId
							},
							async: false,
							success : function(response, action) {
								var requestTypeId=serviceRequestCombo.data.id;
								
								var resp = Ext.JSON.decode(response.responseText);
								if(resp==true){
									 Ext.Ajax.request({
	                    				 method : "GET",
	                    				 type : 'rest',
	                    				 url: SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
	                    				 params: {
	                    					 requestTypeId : requestTypeId,
	         								academyLocationId:academyLocationId,
	         								serviceRequestCategory:"STUDENT_REQUEST"
	                    				 },
	                    				 headers : {
	                    					 'Content-Type' : 'application/json'
	                    				 },
	                    				 success: function(f, action) {
	                    					 var advisorVal = Ext.decode(f.responseText);
	                    					 if(advisorVal==true){
	        									 if(advisorName!=null){
	        											$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
	        											btn.up('form').up('window').close();
	        											 }else{
	        								 					showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));

	        												}
	        										}else{$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
	        										btn.up('form').up('window').close();
	        										}
	                    				 }
	                    			 });
									
								}else{
				 					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_NOT_CHECKED_IN'));

								}
							
							}});
 	            	}else if(serviceRequestCombo!=undefined && serviceRequestCombo.data.code=='LR'){
						var requestTypeId=serviceRequestCombo.data.id;
						var academyLocationId = this.getCurrentAcademyLocation();
				        Ext.Ajax.request({
							type : 'rest',
							url :SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
							method : 'GET',
							params : {
								requestTypeId : requestTypeId,
								academyLocationId:academyLocationId,
								serviceRequestCategory:"STUDENT_REQUEST"
							},
							 headers : {
            					 'Content-Type' : 'application/json'
            				 },
							async: false,
							success : function(response, action) {
								var resp = Ext.JSON.decode(response.responseText);
								if(resp==true){
									 if(advisorName!=null){
									$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
									btn.up('form').up('window').close();
									 }else{
						 					showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));

										}
								}else{
									$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
									btn.up('form').up('window').close();

								}
							}});
				}else if(requestCategoryCombo && requestCategoryCombo.get('value')=='Readmission'){
						var academyLocationId = this.getCurrentAcademyLocation();
					$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,requestCategoryCombo);  
					btn.up('form').up('window').close();

			       /* Ext.Ajax.request({
						type : 'rest',
						url :SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
						method : 'GET',
						params : {
							requestTypeId : requestTypeId,
							academyLocationId:academyLocationId,
							serviceRequestCategory:"STUDENT_REQUEST"
						},
						 headers : {
        					 'Content-Type' : 'application/json'
        				 },
						async: false,
						success : function(response, action) {
							var resp = Ext.JSON.decode(response.responseText);
							if(resp==true){
								 if(advisorName!=null){
								$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
								btn.up('form').up('window').close();
								 }else{
					 					showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));

									}
							}else{
								$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
								btn.up('form').up('window').close();

							}
						}});*/
			}else{
					var studentTransferTab = $this.getTabReferenceByTabTitle(getServiceRequestTranslation("SECTION_TRANSFER"));
					if(studentTransferTab){
						studentTransferTab.close();
					}
				
					$this.openServiceRequestTab($this.getRequestType(),serviceRequestCategoryCombo,serviceRequestCombo);  
					btn.up('form').up('window').close();

				}
 	            
 	        }
 	        },
 	        	
 	       'studentraiseservicerequestwindow studentrequestcombopanel[itemId=studentRequestComboPanelId]': {
	            render: function(form) {
	            	var serviceRequestCategoryCombo = form.down('#serviceRequestCategoryCombo');
	            	var academyLocationId = this.getCurrentAcademyLocation();
                   	var store = serviceRequestCategoryCombo.getStore();
                   	store.proxy.extraParams = {
                   			serviceRequestCategory : 'STUDENT_REQUEST',
                   			academyLocationId:academyLocationId
  					};
                   	store.load();
	            }
	        },
	        'studentraiseservicerequestwindow studentrequestcombopanel[itemId=studentRequestComboPanelId]': {
	            render: function(form) {
	            	var serviceRequestCategoryCombo = form.down('#serviceRequestCategoryCombo');
	            	var academyLocationId = this.getCurrentAcademyLocation();
	            	var SearchForm = this.getStudentQuickSearchForm();
	                var searchResultForm = SearchForm.getForm();
	                var userStatus =searchResultForm.findField('STATUS').getValue();
	                var admissionStatus =searchResultForm.findField('ADMISSION_STATUS').getValue();
	                var serviceRequestRequiredForInActiveStudent = false;
	                if(userStatus && !admissionStatus){
	                	serviceRequestRequiredForInActiveStudent = this.getInActiveStudentServiceRequestRequired()
	                } 
                   	var store = serviceRequestCategoryCombo.getStore();
                   	store.proxy.extraParams = {
                   			serviceRequestCategory : 'STUDENT_REQUEST',
                   			academyLocationId:academyLocationId,
                   			serviceRequestRequiredForInActiveStudent : serviceRequestRequiredForInActiveStudent
  					};
                   	store.load();
	            }
	        },
            //@manas 
              'flagrequeststudentpanel button[itemId=flagraiseButtonId]': {
 	            click: function(btn) {
			
 	            	$this=this; 
 	            	var win = btn.up('window');
 	            	var flagIdNameCombo = btn.up('form').down('#flagnamevalueCombo').getValue();
 	            	var flagColorCodeCombo = btn.up('form').down('#flagcolorvalueCombo').getValue();
 	            	var grid = this.getSearchResultGrid();
					var StudentId=grid.getSelectionModel().getSelection()[0].data.USER_ID;
					var fData = {
						flagId:flagIdNameCombo,
						flagColorId:flagColorCodeCombo,
						studentId:StudentId
					};
					 var dataObj = Ext.encode(fData);  
				      Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading'); 
 	            	 	Ext.Ajax.request({
            					method: 'POST',
            					jsonData : dataObj,
            					type : 'rest',
            					url : SERVERURL.PATH_SAVE_FLAG_USERS,
            					headers : {
            						'Content-Type' : 'application/json'
            					},
								success : function(form,action) {  
									
            						//var data = Ext.JSON.decode(form.responseText);
            						if(form.responseText=='Success'){  
            							showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('Record Saved Successfully'));
            						} else {
            							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Operation Failed'));
            						}
            						Ext.getBody().unmask();
            						win.close();
            					},
            					failure: function(form, action) {
            						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Operation Failed'));
            					}

            	         });
 	              }
	       },   	
	       'flagrequeststudentpanel customcombobox[itemId=flagnamevalueCombo]': {
	    	   change:function(cmp,record){
	    		   	 var form = this.getFlagrequeststudentpanel();
	    			 var flagcolorvalueCombo = form.down('#flagcolorvalueCombo');
	    			 flagcolorvalueCombo.reset();
                   	 var store2=flagcolorvalueCombo.getStore();
                   	store2.proxy.extraParams = {
						 flagId : record
                   	}
          	    store2.load();
	    		   
	            }
	       },
	         'flagrequeststudentwindow flagrequeststudentpanel button[itemId=cancelButtonId]': {
	            click: function(btn) {
	            	 btn.up('form').up('window').close();
	            }
	        },
	        'studentraiseservicerequestwindow studentrequestcombopanel button[itemId=cancelButtonId]': {
	            click: function(btn) {
	            	 btn.up('form').up('window').close();
	            }
	        },

            'studentraiseservicerequestwindow combo[itemId=serviceRequestCategoryCombo]':{
            	select:function(combo,records) {
            		var value = records[0].get('value');
            		this.loadOnComboChange(combo,value);
                }
            },
            
            'studentraiseservicerequestwindow combo[itemId=RequestCategoryCombo]':{
            	select:function(combo,records) {
            		var value = records[0].get('value');
            		this.loadOnCategoryComboChange(combo,value);
                }
            },
            'studentquicksearchview studentrequestcombopanel combo[itemId=serviceRequestCategoryCombo]':{
            	select:function(combo,records) {
            		var value = records[0];
            		var requestGroup = combo.up('panel').down('#serviceRequestCategoryCombo').getValue();
            		this.loadOnComboChange(combo,value);
                }
            },
            'studentquicksearchview studentrequestcombopanel combo[itemId=serviceRequestCombo]':{
            	select:function(combo,records) {
            		var value = records[0];
        			var requestGroup = combo.up('panel').down('#serviceRequestCategoryCombo').getValue();
        			this.openServiceRequestTab(this.getRequestType(),requestGroup,value);
                }
            },
            
            'studentraiseservicerequestwindow combo#serviceRequestCombo':{
            	select:function(combo,records) {
            			combo.up('panel').down("#raiseButtonId").setDisabled(false);
            	}
            },
            'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=programGroupId]': {
            	select: function(programGroupCombo, records, eOpts) {
	           		var this$ = this;
	               	var basicStudentSearchForm=this.getStudentQuickSearchForm();
	               	var programCombo = basicStudentSearchForm.down('#program');
	               	this$.loadDependentCombo(programCombo, programGroupCombo.getValue(), 'programGroupId');
	               	
	               	var batchCombo = basicStudentSearchForm.down('#batch');
	               	this$.clearCombo(batchCombo, true)
	               	
       				var periodCombo = basicStudentSearchForm.down('#period');
	               	this$.clearCombo(periodCombo, true)
	               	
	               	var seatTypeComboField = basicStudentSearchForm.down('#seatType');
	               	this$.clearCombo(seatTypeComboField, false)
	           	 }
                
            },
            'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=program]': {
            	afterrender : function(combo){
            		var academyLocationId = this.getCurrentAcademyLocation();
                   	var store = combo.getStore();
                   	/*store.proxy.extraParams = {
  							 academyLocationId : academyLocationId
  					};*/
                   	//store.load();
                },
	           	 select: function(programCombo, records, eOpts) {
	           		var this$ = this;
	               	var basicStudentSearchForm=this.getStudentQuickSearchForm();
	               	var batchCombo = basicStudentSearchForm.down('#batch');
	               	var courseVarientCombo = basicStudentSearchForm.down('#courseVarientId');
	               	var seatTypeComboField = basicStudentSearchForm.down('#seatType');
	               	this$.clearCombo(seatTypeComboField, false)
	               	this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
//	               	this$.loadDependentCombo(seatTypeComboField, programCombo.getValue(), 'id');
	               //	this$.loadDependentCombo(courseVarientCombo, programCombo.getValue(), 'id');
	           	 }                
            },
            'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=course]': {
            	select : function(courseCombo, record) {
					$this = this;
            		 var form=this.getStudentQuickSearchForm();
            		 var courseVarientCombo = form.down('#courseVarientId');
            		// this$.loadDependentCombo(courseVarientCombo, courseCombo.getValue(), 'courseId');
            		 
				//	var form = obj.up('form');
					var courseId = record[0].get("courseId");

					var courseVarientField = form.down('#courseVarientId');

					courseVarientField.reset();
					courseVarientField.clearValue();
					courseVarientField.setDisabled(false);
					// var courseVarientStore = this.getStore('Academia.store.course.coursevariants.ChildCourseVariantStore');
					var courseVarientStore = courseVarientField.getStore();

					courseVarientStore.getProxy().extraParams.courseId = courseId;
				
					
					courseVarientStore.load({
						callback : function(records,operation,success) {
							if (success) {
								courseVarientField.reset();
								if(records.length == 1){
									courseVarientField.setValue(records[0].data.id);
								}
							}

						}
					});
			
				}
            	
            },
            
            'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=batch]': {
              	 select: function(batchCombo, records) {
              		 var this$ = this;
              		 var basicStudentSearchForm=this.getStudentQuickSearchForm();
              		 var periodCombo = basicStudentSearchForm.down('#period');
              		 var alinfomodel = Academia.model.authentication.ALInfoModel;
              		 var whetherSchool = alinfomodel.get('wheatherSchool');
              		 var seatTypeComboField = basicStudentSearchForm.down('#seatType');
              		 var sectionField = basicStudentSearchForm.down('#section');
	                	   periodCombo.reset();
	                	   var batchId = records[0].get("id");
          					 var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
          					 store.getProxy().extraParams = {
          						 id : batchId
          					 };
          					 store.load({
          						 callback: function(records, operation, success) {
          							 if (success) {
          								 if(whetherSchool) {
          									 if(records.length == 0){
          										 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
          									 } else if(records.length == 1){
          											 periodCombo.setValue(records[0].data.id);
          											 sectionField.setDisabled(false);
          											 var courseCombo = basicStudentSearchForm.down('#course');
          											 this$.loadDependentCombo(courseCombo, periodCombo.getValue(), 'periodId');

          											 var sectionCombo = basicStudentSearchForm.down('#section');
          											 this$.loadDependentCombo(sectionCombo, periodCombo.getValue(), 'periodId');
          									 } else {
          										 periodCombo.setVisible(true);
          									 }
          								 }else{
          									this$.loadDependentCombo(periodCombo, batchCombo.getValue(), 'id');
          								 }
          							 }
          						 }
          					 });
              		 
	                 this.loadDependentCombo(seatTypeComboField, batchCombo.getValue(), 'batchId');
              	 }
             },  
             
             'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=studentId]': {
             	select: function(programGroupCombo, records, eOpts) {
 	           		var this$ = this;
 	               	var basicStudentSearchForm=this.getStudentQuickSearchForm();
 	               	var studentId = basicStudentSearchForm.down('#studentId').getValue();
 	                 var externalRefOneFiled= basicStudentSearchForm.down('#externalSysRefOne');

         		   	var submitURL = SERVERURL.FIND_PATH_FIND_EXTERNAL_REF_NO_ONE;
 	    	        	Ext.Ajax.request({
 	    	        		url: submitURL,
 	    	        		params:{
 	    	        			studentId: studentId
 	    	        		},
 	    	        		method: 'GET',
 	    	        		success: function(response) {
        						var externalRefOneData =response.responseText;
        						if(!isNullOrEmpty(externalRefOneData)){
        							var store=externalRefOneFiled.getStore();
        							store.getProxy().extraParams= {
                                        externalSysRefOne :externalRefOneData
                                    }; 
        							store.load({
        	     						 callback: function(records, operation, success) {
        	     							 for(var i in records){
        	     								 if(records[i].data.value == externalRefOneData ){
        	     									externalRefOneFiled.setValue(records[i].data.value);
        	     								 }
        	     							 }	 
        	     		      		     }	   
        	     				    });	
 	    	        			}else
 	    	        				{
 									externalRefOneFiled.setValue("");
 	    	        			}		
 	    	        	}
 	    	        });
 	           	 }           
               },
             
               'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=period]': {
                 	 select: function(periodCombo) {
                 		var this$ = this;
                 		var basicStudentSearchForm=this.getStudentQuickSearchForm();
                   		var courseCombo = basicStudentSearchForm.down('#course');
                   		this$.loadDependentCombo(courseCombo, periodCombo.getValue(), 'periodId');
                   		
                   		var sectionCombo = basicStudentSearchForm.down('#section');
                   		this$.loadDependentCombo(sectionCombo, periodCombo.getValue(), 'periodId');
                      }
                  }/*,
                  'studentquicksearchform[itemId=studentQuickSearch] combo[itemId=course]': {
                    	 select: function(courseCombo) {
                    		 var this$ = this;
                    		 var basicStudentSearchForm=this.getStudentQuickSearchForm();
                    		 var courseVarientCombo = basicStudentSearchForm.down('#courseVarientId');
                    		 this$.loadDependentCombo(courseVarientCombo, courseCombo.getValue(), 'courseId');
                         }
                     }*/,
                     'searchresultgrid[itemId=StudentSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
         	            click: function() {
         	                this.exportStudentList(SERVERURL.PDFEXPORT,'pdf',false);
         	            }
         	        },
         	        'searchresultgrid[itemId=StudentSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
         	            click: function() {
         	                this.exportStudentList(SERVERURL.PDFEXPORT,'pdf',true);
         	            }
         	        },
         	        'searchresultgrid[itemId=StudentSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
         	            click: function() {
         	                this.exportStudentList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
         	            }
         	        },
         	        'searchresultgrid[itemId=StudentSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
         	            click: function() {
         	                this.exportStudentList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
         	            }
         	        },
         	        'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=resetButtonItemId]': {
         	            click: function(obj) {
         	            	var grid = this.getSearchResultGrid();
        		        	if (grid.getSelectionModel().getCount() > 0) {
        		        			this.openResetPasswordWindow();
        	        		} else {
        						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        					}  
         	            }
         	        },
         	        
         	       'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=bulkResetPasswordToAllBtn]': {
        	            click: function(obj) {
        	
       		        			this.openResetPasswordWindowForAll();
       	        		
        	            }
        	        },
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=raiseScholarshipRequestId]': {
        	        	click: function(obj) {
        	        		//this.openScholarshipRaiseRequestTab();
        	        		var $this =this;
        	        		var grid = this.getSearchResultGrid();
        	        		var records = grid.getSelectionModel().getSelection();
        	        		var pbscId = records[0].data.PROGRAM_BATCH_SEAT_CONFIG_ID;
        	        		Ext.getBody().mask(getCommonTranslation('Loading...'), 'x-mask-loading');
        	        		Ext.Ajax.request({
        	        			  method : "GET",
        	        			  type : 'rest',
        	        			  url : SERVERURL.PATH_FIND_SCHOLARSHIPRAISE_PBSCID+"?pbscId="+pbscId,
        	        			  headers : {
        	        			  'Content-Type' : 'application/json'
        	        			  },
        	        				/*params: {
        	        				 pbscId: pbscId
        	        			    },*/
        	        			  success : function(form,action) {
        	        				    Ext.getBody().unmask(); 
        	        					var data = form.responseText;
        	        					if(data =="true"){
        	        						$this.openScholarshipRaiseRequestTab();
        	        					}else{
        	        						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_SCHOLARSHIP_IS_LINKED_WITH_THE_PROGRAM_ASSOCIATED_WITH_THE_SELECTED_STUDENT'));
        	        				    }
        	        			 },
        	        			 failure:function(){
        	        				 Ext.getBody().unmask(); 
        	        			 }
        	        		});     	 	
   
        	        	}
        	        },
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=inactiveStudentMoreActionBtn]': {
        	            click: function(obj) {
        	
       		        			this.inactiveStudentRecords();
       	        		
        	            }
        	        },
         	       'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=raiseRequestButtonItemId]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		if(grid.getSelectionModel().getCount() > 1){
        		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        		        		}else{
        		        			var this$ = this;
            	                	var window = this$.getRaiseServiceRequestWindow();
            	                	if(!window){
            	                		window = Ext.widget('studentraiseservicerequestwindow');
            	                	}
            	                	var records = grid.getSelectionModel().getSelection();
            	                	window.config.programId = records[0].data.PROGRAM_ID;
            	                	window.show();
        		        		}
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }
        	        },
                     'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=flagRequestButtonItemId]': { // @manas:-03/01/22
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		if(grid.getSelectionModel().getCount() > 1){
        		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        		        		}else{
        		        			var this$ = this;
            	                	var window = this$.getFlagrequeststudentwindow();   
            	                	if(!window){
            	                		window = Ext.widget('flagrequeststudentwindow');
            	                	}
            	                	var records = grid.getSelectionModel().getSelection();
            	                	window.config.programId = records[0].data.PROGRAM_ID;
            	                	window.show();
        		        		}
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }
        	        },
        	        
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=assignStudentCommitteeBtn]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.openAssignStudentCommitteeWindow(grid);
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }
        	        },
        	        
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printStudentCertificate]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.openCertificateSelectWin();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }
        	        },
        	         'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printAttestationStatementOfStudentJourney]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.openAttestationCertificateSelectWin();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }
        	        },
        	        
        	        'committeealwindow[itemId=studentMapCommitteeWindow] button#submitBtn':{
        	            click: function(button) {
        	            	var grid = this.getSearchResultGrid();
        	        		button.up('window').persistCommitteeMaping(button,grid);
        	            }
        	        },'studentsendmessages[itemId=studentListSendMessageWindows] radiogroup[itemId=messageType]':{
            			change : function(val,nV,oV){
            				this.selectSectionMessageType(val,nV,oV);
            			}
            		},
            		'studentsendmessages[itemId=studentListSendMessageWindows] customcombobox[itemId=msgTempletId]':{
            			select : function(obj,rec){
            				this.selectMessageTemp(obj,rec);
            			}
            		},
                    'studentsendmessages[itemId=studentListSendMessageWindows] textarea[itemId=pushNotificationDiscription]':{
          	        	change : function(val,nV,oV){
          	        		var studentSendMessages = this.getStudentsendmessages();
          	        		var pushTextField = studentSendMessages.down('#pushNotificationDiscription');
          	        		var pushTextFieldDiscription = studentSendMessages.down('#pushNotificationDiscriptionNotice');
          	        		var maxLength = 1000;
          	        		var newValue = maxLength - pushTextField.getValue().length;
          	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
          	        	}
          	        },
            		'studentsendmessages[itemId=studentListSendMessageWindows] button[itemId=adhocMsgSubmitBtn]':{
            			click: function(obj) {
            				var isForAll = false;
            				var SearchForm = this.getStudentQuickSearchForm();
            		        var jsonFormatFormData = this.createJsonFormat(SearchForm);
            				var grid = this.getSearchResultGrid();
            				var studentsendmessage = this.getStudentsendmessages();
            				//studentsendmessage.down('#adhocMsgSubmitBtn').setDisabled(true);
            				
        	    	       	var sendMessageLable = studentsendmessage.down("#sendMsgCountItemId");
        	    	       	if (sendMessageLable.isVisible()) {
        	    	       		isForAll = true;
							}
            				var formPnl = obj.up('form');
            				var isMySelfChecked = false;
            				var fldValues = formPnl.getForm().getFieldValues();
            				isMySelfChecked = fldValues.recieverType;
            				if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
          	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
          	        	    	return;
          	        	    }
            				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
            				var wsMsgEventRecipientConfigsUpdated = [];
            				/*var wsMsgEventRecipientConfigsUpdated = [{ 
										                           	 	msgRecipientTypeId: 500,
										                           	 	msgTemplateConfigId: 0,	//formData.id, 
										                           	 	selectiveRecipientIds: [] 
										                            },{ 
										                           	 	msgRecipientTypeId: 600,
										                           	 	msgTemplateConfigId: 0,	//formData.id, 
										                           	 	selectiveRecipientIds: [] 
										                            }];*/
            				
            				var formData = obj.up('form').getValues();
            				
            				var sendMessageToOptions = formData.recieverType;
            				var isStudentChecked = false;
            				var isParentChecked = false;
            				var isFeePayerChecked = false;
            				
            				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
            					if(sendMessageToOptions.constructor === Array){
            						if(sendMessageToOptions.length > 0){
            							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
                    						if(current_value == 1 || current_value == '1'){
                    							isStudentChecked = true;
                    						}
        									if(current_value == 2 || current_value == '2'){
        										isParentChecked = true;
        									}
        									if(current_value == 3 || current_value == '3'){
        										isFeePayerChecked = true;
        									}
                    					});
            						}
            					}else{
            						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
            							isStudentChecked = true;
            						}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
            					}
            				}
            				
            				//var abc = xyz.c;
            				
            				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
            					//wsMsgEventRecipientConfigsUpdated = [];
            					studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
            				}else{
            					var recipientIds;
            					if(grid.itemId == 'StudentSearchResultGrid'){
            						recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
            						recipientIds = Ext.encode(recipientIds);
            						//typeId = 2;
            						//recipientId = 2;
            					}
            					
            					var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];
            					
            					if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
            						// Ajax Call to get Parent Ids by Admission Ids
            						
            						Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            						Ext.Ajax.request({
	            						type: 'rest',
	            						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	            						jsonData: RecipientTypeCodes,
	            						method: 'POST',
	            						success: function(response) {
	            							var RecipientTypeCodesData = Ext.decode(response.responseText);
	            							
	            							Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	            							Ext.Ajax.request({
	    	            						type: 'rest',
	    	            						url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
	    	            						jsonData: recipientIds,
	    	            						method: 'POST',
	    	            						success: function(response) {
	    	            							Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    	            							// update wsMsgEventRecipientConfigsUpdated with parent ids
	    	            							var wsMsgEventRecipientConfigsParents = {
	    									            									msgRecipientTypeId: 66,
	    													                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    													                           	 	selectiveRecipientIds: []
	    										            							};
	    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	    	            							}
	    	            							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	    	            							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	    	            							
	    	            							// Ajax Call to get Fee Payer Ids by Admission Ids
	    	            							Ext.Ajax.request({
	    	    	            						type: 'rest',
	    	    	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
	    	    	            						jsonData: recipientIds,
	    	    	            						method: 'POST',
	    	    	            						success: function(response) {
	    	    	            							Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    	    	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	    	    	            							var wsMsgEventRecipientConfigsFeePayer = {
	    			            									msgRecipientTypeId: 67,
	    							                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    							                           	 	selectiveRecipientIds: []
	    				            							};
	    	    	            							
	    	    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	    	    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	    	    	            							}
	    	    	            							
	    	    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	    													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	    	    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
	    	    	            						}
	    	    	            					});
	    	            						}
	    	            					});
	            						}
            						});
            					}else{ // Only one checkbox is selected
            						var urlNew = '';
            						if(isParentChecked) { // If Parent checkbox is selected
            							// url for getting parent ids
            							urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
            						}
            						if(isFeePayerChecked) { // If Fee Payer checkbox is selected
            							// url for getting fee payer ids
            							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
            						}
            						
            						Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            						Ext.Ajax.request({
	            						type: 'rest',
	            						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	            						jsonData: RecipientTypeCodes,
	            						method: 'POST',
	            						success: function(response) {
	            							Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	            							var RecipientTypeCodesData = Ext.decode(response.responseText);
	            							
	            							Ext.Ajax.request({
	    	            						type: 'rest',
	    	            						url: urlNew,
	    	            						jsonData: recipientIds,
	    	            						method: 'POST',
	    	            						success: function(response) {
	    	            							Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    	            							if(isParentChecked) { // If Parent checkbox is selected
	    	            								// update wsMsgEventRecipientConfigsUpdated with parent ids
	    	            								var wsMsgEventRecipientConfigsParents = {
	    		            									msgRecipientTypeId: 66,
	    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    						                           	 	selectiveRecipientIds: []
	    			            							};
	    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
		    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
		    	            							}
	    												wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	    	                						}
	    	            							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	    	                							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	    	            								var wsMsgEventRecipientConfigsFeePayer = {
	    		            									msgRecipientTypeId: 67,
	    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    						                           	 	selectiveRecipientIds: []
	    			            							};
	    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	    	            									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
		    	            							}
	        	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	    	                						}
	    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
	    	            						}
	    	            					});
	            						}
            						});
            						
            					}
            					//studentsendmessage.sendMessage(obj,grid);
            				}
            				
            			}
            		},
            		/*V2D-13247*/
            		'studentsendmessages[itemId=studentListSendMessageWindows] textarea[itemId=smsDiscription]':{
            			change : function(val,nV,oV){
            				var studentsendmessage = this.getStudentsendmessages();
            				var smsTextField = studentsendmessage.down('#smsDiscription');
            				var smsTextFieldDiscription = studentsendmessage.down('#smsDiscriptionNotice');
            				var maxLength = localStorage.getItem('maxLength');
            				var newValue = maxLength - smsTextField.getValue().length;
            				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
            			}
            		},
            		'certificateselectionwindow[itemId=studentListCertificateSelectionWindow] button[itemId=submitPrintCertificate]':{
            			click: function(obj) {
            				var grid = this.getSearchResultGrid();
            				var records = grid.getSelectionModel().getSelection();
            				var $this= this;	
            				var window = $this.getCertificateselectionwindow();
            				var certificate = window.down('#certificate');
            				var comments = window.down('#certificateComment');
            				var printAsWordFile = window.down('#printAsWordFile');
							var certificateDateFormat = window.down('#certificateDateFormatId');
							var admissionIds = [];

							for (var i in records) {
								admissionIds.push(records[i].data.ADMISSION_ID);
							}
							var periodId = window.down('#periodName');
							if(periodId!=null && periodId.getValue()>0){ 
							submitUrl = SERVERURL.SAVE_PERIODS_FOR_PRINT_CERTIFICATE;  
							var json={ 
													"periodId":periodId.getValue(),
													"admissionIds" :admissionIds.join(),
													"certificateId":certificate.getValue(),
													"isPrintWordFile": false	
													
											};
							
											var submitJson = Ext.encode(json);
								Ext.Ajax.request({
															type : 'rest',
															url : submitUrl,
															jsonData : submitJson,
															method : 'POST',
															success : function(resp, action) {
																if(resp!=null){
																//	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
																}
																
															}
														}); 
							
							}
							var url = SERVERURL.PRINT_MULTIPLE_CERTIFICATE; 
            				var reportParams = new Object;
            				var encodeCom;
            				if (!isNullOrEmpty(comments.getValue)) {
            					encodeCom = Ext.encode(comments.getValue());
            					encodeCom = encodeCom.replaceAll('\\\\n','<br></br>');
            					encodeCom = Ext.decode(encodeCom);
            				}
            				
            				reportParams= {
                						'admissionIds' :admissionIds.join(),
                						'certificateId':certificate.getValue(),
                						'comment': encodeCom,
                						'printAsWordFile':printAsWordFile.getValue(),
                						'certificateDateFormat':certificateDateFormat.getValue()
                				};
                				reportParams={
                						'reportParams':reportParams	
                				};
                				var csvForm = Ext.create('Ext.form.Panel',{
                		    		items:[{
                		    			xtype : 'textfield',
                		    			maxLength : 20480,
                		    			itemId : 'dynamicDocumentRequestContent',
                		    			name : 'dynamicDocumentRequestContent'
                		    		}]
                		    	});
                				$this.applyWindowMask(); 
                		    	csvForm.down('#dynamicDocumentRequestContent').setValue(Ext.encode(reportParams));
                		    	csvForm.getForm().submit({
                					target: 'download_frame',
                				    method:'POST',
                				    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
                				    headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                		  
                				    url : url,
                				    standardSubmit :true
                		    	});   
                		    	window.close();
                		    	$this.hideWindowMask();
            			}
            		},
            		'certificateselectionwindow[itemId=studentListCertificateSelectionWindow] button[itemId=sendMultipleCertificateToStudentProfile]':{
            			click: function(obj) {
            				var grid = this.getSearchResultGrid();
            				var records = grid.getSelectionModel().getSelection();
            				var $this= this;	
            				var window = $this.getCertificateselectionwindow();
							var certificate = window.down('#certificate');
							var comments = window.down('#certificateComment');
							var printAsWordFile = window.down('#printAsWordFile');
							var admissionIds = [];
							var periodId = window.down('#periodName');
							
							for(var i in records) {
							            					admissionIds.push(records[i].data.ADMISSION_ID);
							            				}

							if (periodId != null && periodId.getValue() > 0) {
								submitUrl = SERVERURL.SAVE_PERIODS_FOR_PRINT_CERTIFICATE;
								var json = {
									"periodId": periodId.getValue(),
									"admissionIds": admissionIds.join(),
									"certificateId": certificate.getValue(),
									"isPrintWordFile": true

								};

								var submitJson = Ext.encode(json);
								Ext.Ajax.request({
									type: 'rest',
									url: submitUrl,
									jsonData: submitJson,
									method: 'POST',
									success: function(resp, action) {
										if (resp != null) {
											//	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
										}

									}
								});

							}


							var url = SERVERURL.PRINT_MULTIPLE_CERTIFICATE;
            				var reportParams = new Object;
            				var encodeCom;
            				if (!isNullOrEmpty(comments.getValue)) {
            					encodeCom = Ext.encode(comments.getValue());
            					encodeCom = encodeCom.replaceAll('\\\\n','<br></br>');
            					encodeCom = Ext.decode(encodeCom);
            				}
            				
            				for(var i in records) {
            					admissionIds.push(records[i].data.ADMISSION_ID);
            				}
							admissionIds=admissionIds.filter(function(value, index, self) {
							  return self.indexOf(value) === index;
							});
            				reportParams= {
            						'admissionIds' :admissionIds.join(),
            						'certificateId':certificate.getValue(),
            						'comment': encodeCom,
            						'printAsWordFile':printAsWordFile.getValue()
            				};
            				reportParams={
            						'reportParams':reportParams	
            				};

            				var csvForm = Ext.create('Ext.form.Panel',{
            					items:[{
            						xtype : 'textfield',
            						maxLength : 20480,
            						itemId : 'dynamicDocumentRequestContent',
            						name : 'dynamicDocumentRequestContent'
            					}]
            				});
            				$this.applyWindowMask(); 
            				csvForm.down('#dynamicDocumentRequestContent').setValue(Ext.encode(reportParams));

            				var dataObj = {};
            				dataObj.dynamicDocumentRequestContent = Ext.encode(reportParams);
            				Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
            				Ext.Ajax.request({
            					method: 'POST',
            					jsonData : dataObj,
            					type : 'rest',
            					url : SERVERURL.SEND_MULTIPLE_CERTIFICATE_TO_STUDENT_PROFILE,
            					headers : {
            						'Content-Type' : 'application/json'
            					},
            					success : function(form,action) {
            						var data = Ext.JSON.decode(form.responseText);
            						if( data.code == 'SUCCESS' ){
            							showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('DOCUMENT_SENT_SUCCESSFULLY'));
            						} else {
            							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('OPERATION_FAILED'));
            						}
            						window.close();
                    				$this.hideWindowMask();
            					},
            					failure: function(form, action) {
            						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('OPERATION_FAILED'));
            					}

            				});
            			}
            		},
            		
			'attestationstatementofstudentjourneywindow[itemId=studentListAttestationStatementOfStudentJourneyWindow] button[itemId=submitPrintAttestation]': {
				click: function() {
					var code = "ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY";
					var $this = this;
					var formWindow = this.getAttestationstatementofstudentjourneywindow();
					var grid = this.getSearchResultGrid();
					var url = SERVERURL.PRINT_MULTIPLE_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY;
					var printAsWordFile = formWindow.down('#attestationPrintAsWordFile');
					if (grid.getSelectionModel().getCount() > 0) {
						var records = grid.getSelectionModel().getSelection();
						var admissionIds = [];
						var academyLocationId = this.getCurrentAcademyLocation();
						for (var i in records) {
							admissionIds.push(records[i].data.ADMISSION_ID);
						}
						var reportParams = new Object();
						reportParams = {
							'admissionIds': admissionIds.join(),
							'printAsWordFile': printAsWordFile.value
						};
						reportParams = {
							'reportParams': reportParams
						};
						reportParams.academyLocationId = academyLocationId;
						reportParams.headerName = getCommonTranslation('ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY');
						$this.exportJRXMLReport(code, reportParams, 'Attestation Statement Of Student Journey', '.pdf', url);
					}
				},
			},
			'attestationstatementofstudentjourneywindow[itemId=studentListAttestationStatementOfStudentJourneyWindow] button[itemId=sendMultipleAttestationToStudentProfile]': {
				click: function() {
					var $this = this;
					var formWindow = this.getAttestationstatementofstudentjourneywindow();
					var grid = this.getSearchResultGrid();
					var printAsWordFile = formWindow.down('#attestationPrintAsWordFile');
					if (grid.getSelectionModel().getCount() > 0) {
						var academyLocationId = this.getCurrentAcademyLocation();
						var records = grid.getSelectionModel().getSelection();
						var admissionIds = [];
						for (var i in records) {
							admissionIds.push(records[i].data.ADMISSION_ID);
						}
						var reportParams = new Object();
						reportParams = {
							'admissionIds': admissionIds.join(),
							'printAsWordFile': printAsWordFile.value
						};
						reportParams = {
							'reportParams': reportParams
						};
						$this.applyWindowMask();
						reportParams.academyLocationId = academyLocationId;
						reportParams.code="ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY";
						reportParams.reportTitle = "Attestation Statement Of Student Journey";
							var dataObj = {};
            				dataObj.dynamicDocumentRequestContent = Ext.encode(reportParams);
            				Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
							Ext.Ajax.request({
            					method: 'POST',
            					jsonData : dataObj,
            					type : 'rest',
            					url : SERVERURL.PATH_SEND_MULITPLE_ATTESTATION_STATEMENT_ON_STUDENT_PROFILE,
            					headers : {
            						'Content-Type' : 'application/json'
            					},
            					success : function(form,action) {
            						if(form.responseText == 'SUCCESS' ){
            							showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('DOCUMENT_SENT_SUCCESSFULLY'));
            						} else {
            							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('OPERATION_FAILED'));
            						}
            						formWindow.close();
                    				$this.hideWindowMask();
            					},
            					failure: function(form, action) {
									$this.hideWindowMask();
            						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('OPERATION_FAILED'));
            					}
            				});
					}
				},
			},
            		'certificateselectionwindow[itemId=studentListCertificateSelectionWindow] customcombobox[itemId=certificate]':{
            			select: function(obj,rec) {
            				var $this= this;	
            				var window = $this.getCertificateselectionwindow();
            				var formPnl = window.down('form');
            				var certificate = window.down('#certificate');
            				var comments = window.down('#certificateComment');
            				var certificateDateFormat = window.down('#certificateDateFormatId');
							var periodId=window.down('#periodName');   
            				certificateDateFormat.setVisible(false);
        					$this.setAllowBlank(certificateDateFormat,true);
        					if(rec[0].raw.isInactiveDataProviderAdded == true){
        						certificateDateFormat.setVisible(true);
        					}
							
							if(rec[0].raw.code.includes('Dean')){   
							    periodId.show();
								periodId.allowBlank=false ;  
							}else{
							    periodId.hide();
								periodId.allowBlank=true;  
							} 
            				
            				if(rec[0].raw.isCommentCertificate == true){
            					comments.setVisible(true);
            					$this.setAllowBlank(comments,false);
            					
            				}else{
            					comments.setVisible(false);
            					$this.setAllowBlank(comments,true);
            				}
            				formPnl.getForm().checkValidity();

            			}
            		},
            		'studentsendmessages[itemId=studentListSendMessageWindows]  filefield[itemId=staticUploadFileField]': {
        	            change: function(fileField, value, eOpts){
        	            	var this$ = this;
        	            	//value = value.replace('C:\\fakepath\\', '');
        	            	var form=this$.getStudentsendmessages();
        	            	var subject = form.down('#subject').getValue();
        	            	if(isNullOrEmpty(subject)){
        	            		form.down('#subject').setValue(' ');
        	            	}
        	            	this$.uploadStudentStaticDocumentFileMessage(fileField, value, eOpts);
        	            }
                    },
                    'studentstaticdocumentattachmentgrid[itemId=studentStaticDocumentAttachmentGridMessage] actioncolumn': {
                    	click : function(view, rowIndex, colIndex, item, e, record, row){
                    		this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
                    	}
                    },'studentsendmessages[itemId=studentListSendMessageWindows]': {
            			render: function(grid){
        	            	var this$ = this;
        	            	var docGrid = grid.down('#studentStaticDocumentAttachmentGridMessage');
        	            	docGrid.getStore().removeAll();
        	            	docGrid.getStore().sync();
        	            },
        	            afterrender: function(form) {
        	            	//this.getStudentIdsForMessaging();
        	            	var generateEmailBtn = form.down('#generateEmailBtn');
        	            	generateEmailBtn.hide();
        	            	var permissionMap = this.getSTUDENT_LIST_PERMISSIONS();
        	            	var associatedAcadLocationIds = new Array();
        	            	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
        	            	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
        	            	if(permissionList.indexOf("GENERATE_EMAIL") != -1) {
        	            		generateEmailBtn.show();
        	            	}
        	            }
                    }, 'studentsendmessages[itemId=studentListSendMessageWindows] radiogroup#sendingPriority': {
                		change: function( radio, newValue, oldValue, eOpts) {
                  	      this.loadStudentScheduleField(radio, newValue, oldValue);
                  		}
                  	},
                   'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=makeAlumniItemId]': {
        	            click: function(obj) {
        	            	var $this = this;
        	        		var contentPanel = $this.getContentPanel();
        	        		var grid = $this.getSearchResultGrid();
        	            	showConfirmMessage(getAlumni('MAKE_ALUMNI'),getAlumni('ARE_YOU_SURE_TO_MAKE_ALUMNI?'),function(btn,text){ 
        	        			if (btn == 'yes') {
        	        		var selectionModel = grid.getSelectionModel().getSelection();
        	        		var idsArr = [];
        	        		selectionModel.forEach(function(obj){
        	        			idsArr.push(obj.get('STUDENT_ID'));
        	        		});
        	        		var signupCode =  idsArr.join();        	        		
        	        		var submitUrl = SERVERURL.PATH_MAKE_ALUMNI;   	
        	       		 var tabName;
        	       		if(grid.getSelectionModel().getCount()>0){
        	       		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		
        	       		Ext.Ajax.request({
        	       			type : 'rest',
        	       			url : submitUrl+"?studentCodes="+signupCode,
        	       			method : 'POST',
        	       			success : function(frm, action) {
        	       				Ext.getBody().unmask();
        	       				if(frm.responseText == 'Success' ){
        							showSuccessMessage(getCommonTranslation('SUCCESS'),getAlumni('STUDENT_WILL_MAKE_SUCCESSFULLY'));
        						} else {
        							showWarningMessage(getCommonTranslation('ALERT'),getAlumni('ALUMNI_ALREADY_PRESENT'));
        						}
        	       				var getcontroller=$this.getController('menu.CoreERPNavigationController');
        	       			   grid.getSelectionModel().deselectAll();
        	       			   grid.getStore().load();
//        	       				var getTab=getcontroller.getTab(tabName);
//        	       				if(getTab!=null){
//        	       					contentPanel.remove(getTab, true);
//        	       				}
        	       			}
        	       		});	
        	       		}	
        	       		else{
        	    			showWarningMessage(getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
        	    		}
        	        }
        	            	})
        	            }},
        	        
        	        'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=sendMessageBtn]': {
        	            /*click: function(obj) {
    	                	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		var this$ = this;
        	                	var window = this$.getSendMessageWindow();
        	                	if(!window){
        	                		window = Ext.widget('sendmessagewindow',{
        	                			itemId:'studentListSendMessageWindows'
        	                		});
        	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.STUDENT);
        	                	}
        	                	window.show();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }*/
        	        	click: this.openStudentSendMessage
        	        },
        	        
        	        'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=printIdCardBtn]': {
        	            click: function(obj) {
        	            	var me = this;
    	                	var grid = this.getSearchResultGrid();
    	                	var record = grid.getSelectionModel().getSelection();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		var parameterListArray =[]; 
        	            		 for(var i = 0; i< record.length;i++){
        	            		var user=me.getCurrentlyLoggedInUser();       
        	            		//var progBatchSeatConfig=record[i].data.ACADEMY_LOCATION_LEVEL_ID;
        	            		var progBatchSeatConfig=me.getCurrentAcademyLocation();
        	            		console.log("progBatchSeatConfig",progBatchSeatConfig);
                        		//Adding require parameters in object and pass this parameter to server side 
                            	var parameterListObj =new Object();
                            	parameterListObj.documentTypeCode="MyIDCard";
                            	parameterListObj.ownerType="ACADEMY_LOCATION_LEVEL";
                            	parameterListObj.userId=user.id; // logged in user ID
                            	parameterListObj.userName=user.value; // logged in user Name
                            	                                    	                       	
                            	parameterListObj.ownerId=progBatchSeatConfig;                                 	                                    	
                            	parameterListObj.templateReportParams={'PRM_ADMISSION_ID':record[i].data.ADMISSION_ID}; //Admission ID                                    	                                    	
                            	 parameterListArray.push(parameterListObj)
        	            	 }
                            	me.sendPDFDynamicDocumentRequest(SERVERURL.GENERATE_BULK_PRINTING,parameterListArray);
        	            	  
        	            		
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            
        	            }
        	        },
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printIdCardMultipleBtn]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.showStudentBulkPrintWin();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}
        	            }
        	        },
        	        'studentbulkprintwidow button#btnPrint': {
        	        	click: function(button) {
        	        		var grid = this.getSearchResultGrid();
        	        		this.exportIdCardJRXML('pdf',grid);
            			}
        	        },
        	        
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=transferCard]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.showStudenttransfercardwindow(obj);
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}
        	            }
        	        },
        	        'studenttransfercardwindow button#btnPrint': {
        	        	click: function(button) {
        	        		var grid = this.getSearchResultGrid();
        	        		this.exportTransferCardJRXML('pdf',grid);
            			}
        	        },
        	      /*  'sendmessagewindow[itemId=studentListSendMessageWindows] button#adhocMsgSubmitBtn': {
        	        	click: function(button) {
        	        		var grid = this.getSearchResultGrid();
        	        		button.up('window').sendMessage(button,grid);
            			}
        	        },*/
        	       /* 'sendmessagewindow[itemId=studentListSendMessageWindows] combo#selectTemplate': {
        	        	render: function(combo) {
        	        		var store = combo.getStore();
        	        		var msgRecipientTypeId = combo.up('window').down('#msgRecipientTypeItemId').getValue();
        	        		 store.on('beforeload', function(store, operation) {
        	                     store.proxy.extraParams = {
        	                    		 msgRecipientTypeId :msgRecipientTypeId
        	                     };
        	                 });
            			},
            			select :function(combo,records){
            				var msgCategoryId = combo.up('window').down('#msgCategoryId');
            				var msgSubCategoryId = combo.up('window').down('#msgSubCategoryId');
            				msgCategoryId.setValue(records[0].data.msgCategoryId);
            				msgSubCategoryId.setValue(records[0].data.msgSubCategoryId);
            			}
        	        },*/
        	        
         	        'adminresetpasswordwindow[itemId=studentlistadminresetpasswordwindow] button[itemId=submitBtn]':{
         	        	click:function(obj){
         	        		this.changePasswordByAdmin(obj);
         	        	}
         	        },
         	        'adminresetpasswordwindow[itemId=studentlistadminresetpasswordwindow] button[itemId=cancelBtn]':{
         	        	click:function(obj){
         	        		obj.up('window').close();
         	        	}
         	        },
         	        
                    'adminresetpasswordwindow[itemId=studentlistadminresetpasswordwindow] ': {
                        beforerender: function(formWindow) {
                        	var form = formWindow.down('form');
                	    	this.getController('Academia.controller.authentication.AuthenticationController').getPasswordPolicy(form);
                        }
                    },
                   
        			'adminresetpasswordwindow[itemId=studentlistadminresetpasswordwindow] form #resetPassword' :{ 
        				blur:this.getController('Academia.controller.authentication.AuthenticationController').checkPasswordValidity
        			},
        			
        			'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] button[itemId=submitBtn]':{
         	        	click:function(obj){
         	        		this.changePasswordByAdmin(obj);
         	        	}
         	        },
         	        'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] button[itemId=cancelBtn]':{
         	        	click:function(obj){
         	        		obj.up('window').close();
         	        	}
         	        },
                    '	[itemId=studentlistbulkresetpasswordwindow] ': {
                        beforerender: function(formWindow) {
                        	var form = formWindow.down('form');
                	    	this.getController('Academia.controller.authentication.AuthenticationController').getPasswordPolicy(form);
                        }
                    },
        			'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] form #resetPassword' :{ 
        				blur:this.getController('Academia.controller.authentication.AuthenticationController').checkPasswordValidity
        			},
         	        
        			'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] combo[itemId=academyLocationCombo]': {
        	           	 select: function(programCombo, records, eOpts) {
        	           		var this$ = this;
        	               	var window = this$.getStudentbulkresetpasswordwindow();
        	               	var programCombo = window.down('#program');
        	               	var batchCombo = window.down('#batch');
        	               	var periodCombo = window.down('#period');
        	               	programCombo.reset();
        	               	batchCombo.reset();
        	               	periodCombo.reset();
        	               	var alId = records[0].get("id");
        	               	programCombo.getStore().proxy.extraParams = {
                           			academyLocationId : alId
          					};
        	               	programCombo.getStore().load();
        	               	programCombo.setDisabled(false);
        	               	batchCombo.setDisabled(true);
        	               	periodCombo.setDisabled(true);
        	               	var form = window.down('form');
                     		form.getForm().checkValidity();
        	           	 }                
                    },
        			'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] multiselectcombofield#program': {
                    	change: function(obj,record) {
							 var value = obj.getValue();
							 var form = this.getStudentbulkresetpasswordwindow();
							 form.down("#batch").reset();
							 form.down("#batch").clearAllDataFn();
							 form.down("#batch").setDisabled(true);
							 form.down("#period").reset();
							 form.down("#period").clearAllDataFn();
							 form.down("#period").setDisabled(true);
							var alidsValue = form.down("#academyLocationCombo").getValue();
							 if(value.length>0){
								 form.down("#batch").setDisabled(false);
								 if(!Ext.isObject(record[0])){
									 var programId = record.join();
									 var store = form.down("#batch").getStore();
									 store.getProxy().extraParams = {
										 programIds: programId,
										 academyLocationIds:alidsValue
									 }
									 store.load(); 
								 }
							 }
            			}                
                    },
                    'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] combo[itemId=batch]': {
                    	change: function(obj,record) {
                    		var value = obj.getValue();
                    		var form = this.getStudentbulkresetpasswordwindow();
                    		form.down("#period").reset();
                    		form.down("#period").clearAllDataFn();
                    		form.down("#period").setDisabled(true);
                    		var alidsValue = form.down("#academyLocationCombo").getValue();
                    		if(value.length>0){
                    			form.down("#period").setDisabled(false);
                    			if(!Ext.isObject(record[0])){
                    				var batchIds = record.join();
                    				var store = form.down("#period").getStore();
                    				store.getProxy().extraParams = {
                    					batchIds: batchIds,
                    					academyLocationIds:alidsValue
                    				}
                    				store.load(); 
                    			}
                    		}
                    	}  
                     },
                     'studentbulkresetpasswordwindow[itemId=studentlistbulkresetpasswordwindow] radiogroup[itemId=passwordTypeItemId]': {
                    	 change: function(radioGroup, newValue, oldValue, eOpts) {
                    		 var this$ = this;
                      		 var window = this$.getStudentbulkresetpasswordwindow();
                      		 var isCommonPassword = newValue.passwordType;
                      		 var resetPassword = window.down('#resetPassword');
                      		 var confirmedPassword = window.down('#confirmedPassword');
                      		 resetPassword.reset();
                      		 confirmedPassword.reset();
                      		 if(isCommonPassword) {
                      			resetPassword.allowBlank=false;
                      			confirmedPassword.allowBlank=false;
                      			resetPassword.setVisible(true);
                      			confirmedPassword.setVisible(true);
                      		 } else {
                      			resetPassword.setVisible(false);
                      			confirmedPassword.setVisible(false);
                      			resetPassword.allowBlank=true;
                      			confirmedPassword.allowBlank=true;
                      		 }
                      		 var form = window.down('form');
                      		 form.getForm().checkValidity();
                    	 }
                     },
                     
         	       'studentrequestcombopanel[itemId=studentRequestComboPanel] button[itemId=clearBtn]': {
                       click: function(btn) {
                           this.onClickClearRequestTypeCombo(btn);
                       }
                   },
                   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=sendSurveyBtn]': {
                	   click: function(obj) {
                		   var grid = this.getSearchResultGrid();
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getStudentsendsurvey();
                			   if(!window){
                				   window = Ext.widget('studentsendsurvey');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
                   },
                   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=changePrimaryLocationBtn]': {
                	   click: function(obj) {
            		   var grid = this.getSearchResultGrid();
            		   if (grid.getSelectionModel().getCount() > 0) {
            			   var this$ = this;
            			   var window = this$.getChangeprimarylocation();
            			   if(!window){
            				   window = Ext.widget('changeprimarylocation');
            			   }
            			   window.show();
            		   } else {
            			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		   }  
            	   }
               },
               'changeprimarylocation customcombobox[itemId=reassignTo]': {
                   render: function(combo) {
                	var grid = this.getSearchResultGrid();
                	var record = grid.getSelectionModel().getSelection();
                	var userId = record[0].data.ID;   
                	var academyLocationId = this.getCurrentAcademyLocation();
                    var store = combo.getStore();

            		store.getProxy().extraParams = {
            			id: userId
            		};
                   	store.load({
               			callback:function(records,response,success){
               				combo.setValue(academyLocationId);
               			}
               		});
                   },
                   change: function(combo, record) {
               		var changeAcademyLocationForm = combo.up('form');
               		var reassignTo = changeAcademyLocationForm.down('#reassignTo');
               		var grid = this.getSearchResultGrid();
                	var records = grid.getSelectionModel().getSelection();
                	var userId = records[0].data.ID;
               		var store = reassignTo.getStore();
               		store.getProxy().extraParams = {
               			id : userId
               		};
               		store.load();
                   }
               },
               'changeprimarylocation button[itemId=submitButtonId]' : {
            	   click : function(btn) {
						var form=btn.up('form');
 						this.assignAcademyLocation(form)
					}
				},
               'changeprimarylocation button[itemId=cancelButtonId]' : {
            	   click:function(obj){
   	        		obj.up('window').close();
   	        	}
				},
               'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=kohastudentlibrarymappingBtn]': {
                	   click: function(obj) {
                		   var grid = this.getSearchResultGrid();
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getKohastudentlibrarymappingwin();
                			   if(!window){
                				   window = Ext.widget('kohastudentlibrarymappingwin');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
                   },'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=kohastudentcategorymappingBtn]': {
                	   click: function(obj) {
                		   var grid = this.getSearchResultGrid();
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getKohastudentcategorymappingwin();
                			   if(!window){
                				   window = Ext.widget('kohastudentcategorymappingwin');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
                   },
                   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=elctionVoterPoolBtn]': {
                	   click: function(obj) {
                		   var grid = this.getSearchResultGrid();
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getVoterpoolwindow();
                			   if(!window){
                				   window =Ext.widget('voterpoolwindow',{
                  		    			itemId:'studentvoterpoolwindow'
                  		    		});
                			   }
                			   
                			   window.show();
                			   
                			   var form = window.down('form');
               				var  voterPoolField = form.down("#voterPoolItemId");
               				
               				var store = voterPoolField.getStore();
               				
               				
               				store.getProxy().extraParams={
               			    	votingPool: 'STUDENTS'
               				};
               			
               			store.load();
               	    
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
                   },
                   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=studentStatusCSMBtn]': {
                	   click: function(obj) {
                		   var grid = this.getSearchResultGrid();
                		   if (grid.getSelectionModel().getCount() > 0) {
                			   var this$ = this;
                			   var window = this$.getStudentstatuscsmwindow();
                			   if(!window){
                				   window = Ext.widget('studentstatuscsmwindow');
                			   }
                			   window.show();
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
                   },
                   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=studentListProgramTransfer]': {
                	   click: function(obj) {
                		   // TODO
                		   var grid = this.getSearchResultGrid();
                		   if (grid.getSelectionModel().getCount() == 1) {
                			   var this$ = this;
                			   var window = this$.getStudentliststudentprogramtransferwindow();
                			   var studentListGrid = this.getSearchResultGrid();
                    		   var records = studentListGrid.getSelectionModel().getSelection();
                    		   var admissionId = records[0].data.ADMISSION_ID;
                				var submitURL = SERVERURL.PATH_STUDENT_ALL_ACADEMIC_DETAILS_BY_ADMISSION_ID;
     	   	    	        	Ext.Ajax.request({
     	   	    	        		url: submitURL,
     	   	    	        		params:{
     	   	    	        			academyLocationId: this$.getCurrentAcademyLocation(),
     	   	    	        			admissionId: admissionId
     	   	    	        		},
     	   	    	        		method: 'GET',
     	   	    	        		success: function(response) {
     	   	    	        			if(!isNullOrEmpty(response.responseText)){
     	   	    	        				var resp = Ext.decode(response.responseText);
     	   	    	        				if(resp[0].isCurrentPeriod == true){
     	   	    	        				if(!window){
     	   	                				    window = Ext.widget('studentliststudentprogramtransferwindow');
     	   	                				    window.transferRecord = resp;
     	   	                				    window.down('#isCalculateSeparateCGPAndSGPAId').setValue(resp[0].isCalculateSeparateCGPAndSGPA);
     	   	                					window.down("#isCurrentAcademicTermId").setValue(resp[0].isCurrentPeriod);
     	   	                			   }
     	   	                			   window.show();
    	   	    	        			}else{
    	   	    	        				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('STUDENT_NOT_ELIGIBLE_FOR_TRANSFER'));
    	   	    	        				}
     	   	    	        			}
     	   	    	        		}
     	   	    	        	});
                		   } else {
                			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                		   }  
                	   }
                   },
                   'studentliststudentprogramtransferwindow':{
                	   afterrender: function(win){
                		   var me = this;
                		   var windowForm = this.getStudentliststudentprogramtransferwindow();
                		   this.disableProgramTransferPivileges(windowForm, this.getSTUDENT_LIST_PERMISSIONS());
                		   var winGrid = win.down('grid');
                		   var winGridStore = winGrid.getStore();
                		   var studentListGrid = this.getSearchResultGrid();
                		   var transferRecord = win.transferRecord;
                		   winGridStore.removeAll();
                		   var records = studentListGrid.getSelectionModel().getSelection();
                		   var admissionId = records[0].data.ADMISSION_ID;
                		   winGridStore.loadData(transferRecord);
                	   }
                   },
                   'studentliststudentprogramtransferwindow customcombobox[itemId=academyLocationCombo]':{
                	   change: function(obj, record) {
                		   var form = obj.up('form');
                		   var academyLocationField = form.down('#academyLocationCombo');
                		   var intakeYearField = form.down('#intakeYearItemId');
                		   var programGroupField = form.down('#Program_Group');
                		   var programField = form.down('#program');
                		   var batchField = form.down('#batch');
                		   var periodField = form.down('#periodId');
                		   var seatTypeField = form.down('#seatType');
                	 	   var retainStudentData = form.down('#retainStudentDataId');
                		   var retainAcademicData = form.down('#retainAcademicDataId');
                		   var retainFeeAndPaymentData = form.down('#retainFeeAndPaymentDataId');
                		   var retainServiceOpted = form.down('#retainServiceOptedId');
                		   var academyLocationValue = academyLocationField.getValue();
                		   
                		   intakeYearField.reset();
                		   programGroupField.reset();
                		   programField.reset();
                		   batchField.reset();
                		   periodField.reset();
                		   seatTypeField.reset();
                		   retainStudentData.reset();
                		   retainAcademicData.reset();
                		   retainFeeAndPaymentData.reset();
                		   retainServiceOpted.reset();
                		   retainStudentData.setDisabled(true);
                		   retainAcademicData.setDisabled(true);
                		   retainFeeAndPaymentData.setDisabled(true);
                		   retainStudentData.setDisabled(true);
                		   retainStudentData.reset();
                		   retainAcademicData.reset();
                		   retainFeeAndPaymentData.reset();
                		   retainServiceOpted.reset();
                		   retainStudentData.setDisabled(true);
                		   retainAcademicData.setDisabled(true);
                		   retainFeeAndPaymentData.setDisabled(true);
                		   retainStudentData.setDisabled(true);
                		   intakeYearField.setDisabled(isNullOrEmpty(academyLocationValue) ? true : false);
                		   programGroupField.setDisabled(true);
                		   programField.setDisabled(true);
                		   batchField.setDisabled(true);
                		   periodField.setDisabled(true);
                		   seatTypeField.setDisabled(true);
                		   var alIndex = academyLocationField.getStore().findExact('id',academyLocationValue);
                		   if(!isNullOrEmpty(academyLocationValue) && alIndex != -1){
                			   var intakeYearStore = intakeYearField.getStore();
                    		   intakeYearStore.proxy.extraParams = {
          							 academyLocationIds : academyLocationValue
                    		   };
                    		   intakeYearStore.load();
                		   }
                	   }
                   },
                   'studentliststudentprogramtransferwindow customcombobox[itemId=intakeYearItemId]':{
                	   change: function(obj, record) {
                		   var form = obj.up('form');
                		   var academyLocationField = form.down('#academyLocationCombo');
                		   var intakeYearField = form.down('#intakeYearItemId');
                		   var programGroupField = form.down('#Program_Group');
                		   var programField = form.down('#program');
                		   var batchField = form.down('#batch');
                		   var periodField = form.down('#periodId');
                		   var seatTypeField = form.down('#seatType');
                		   
                		   var academyLocationValue = academyLocationField.getValue();
                		   var intakeYearValue = intakeYearField.getValue();
                		   
                		   programGroupField.reset();
                		   programField.reset();
                		   batchField.reset();
                		   periodField.reset();
                		   seatTypeField.reset();
                		   
                		   programGroupField.setDisabled(isNullOrEmpty(intakeYearValue) ? true : false);
                		   programField.setDisabled(true);
                		   batchField.setDisabled(true);
                		   periodField.setDisabled(true);
                		   seatTypeField.setDisabled(true);
                		   if(!isNullOrEmpty(intakeYearValue)){
                			   var programGroupStore = programGroupField.getStore();
                    		   programGroupStore.proxy.extraParams = {
            							 academyLocationIds : academyLocationValue,
            							 intakeYear : intakeYearValue
                      		   };
                    		   programGroupStore.load();
                		   }
                	   }
                   },
                   'studentliststudentprogramtransferwindow customcombobox[itemId=Program_Group]':{
                	   change: function(obj, record) {
                		   var form = obj.up('form');
                		   var academyLocationField = form.down('#academyLocationCombo');
                		   var intakeYearField = form.down('#intakeYearItemId');
                		   var programGroupField = form.down('#Program_Group');
                		   var programField = form.down('#program');
                		   var batchField = form.down('#batch');
                		   var periodField = form.down('#periodId');
                		   var seatTypeField = form.down('#seatType');
                		   
                		   var academyLocationValue = academyLocationField.getValue();
                		   var intakeYearValue = intakeYearField.getValue();
                		   var programGroupValue = programGroupField.getValue();
                		   
                		   programField.reset();
                		   batchField.reset();
                		   periodField.reset();
                		   seatTypeField.reset();
                		   
                		   programField.setDisabled(isNullOrEmpty(programGroupValue) ? true : false);
                		   batchField.setDisabled(true);
                		   periodField.setDisabled(true);
                		   seatTypeField.setDisabled(true);
                		   if(!isNullOrEmpty(programGroupValue)){
                			   var programStore = programField.getStore();
                    		   programStore.proxy.extraParams = {
          							academyLocationId : academyLocationValue,
          							intakeYearId : intakeYearValue,
          							programGroupId : programGroupValue
                    		   };
                    		   programStore.load();
                		   }
                	   }
                   },
                   'studentliststudentprogramtransferwindow customcombobox[itemId=program]':{
                	   change: function(obj, record) {
                		   var form = obj.up('form');
                		   
                		   var academyLocationField = form.down('#academyLocationCombo');
                		   var intakeYearField = form.down('#intakeYearItemId');
                		   var programGroupField = form.down('#Program_Group');
                		   var programField = form.down('#program');
                		   var batchField = form.down('#batch');
                		   var periodField = form.down('#periodId');
                		   var seatTypeField = form.down('#seatType');
                		   
                		   var intakeYearValue = intakeYearField.getValue();
                		   var programValue = programField.getValue();
                		   
                		   batchField.reset();
                		   periodField.reset();
                		   seatTypeField.reset();
                		   
                		   batchField.setDisabled(isNullOrEmpty(programValue) ? true : false);
                		   periodField.setDisabled(true);
                		   seatTypeField.setDisabled(true);
                		   var programIndex = programField.getStore().findExact('id',programValue);
                		   if(!isNullOrEmpty(programValue) && programIndex != -1){
                			   var batchStore = batchField.getStore();
                    		   batchStore.proxy.extraParams = {
             							id : programValue,
             							intakeYearId : intakeYearValue,
             							batchendDate : new Date()
                       		   };
                    		   batchStore.load();
                		   }
                	   }
                   },
                   'studentliststudentprogramtransferwindow customcombobox[itemId=batch]':{
                	   select: function(obj, record) {
                		   var form = obj.up('form');
                		   var academyLocationField = form.down('#academyLocationCombo');
                		   var intakeYearField = form.down('#intakeYearItemId');
                		   var programGroupField = form.down('#Program_Group');
                		   var programField = form.down('#program');
                		   var batchField = form.down('#batch');
                		   var periodField = form.down('#periodId');
                		   var seatTypeField = form.down('#seatType');
                		   var saveBtn = form.down("#saveBtn");
                           var isCurrentAcademicTermId = form.down("#isCurrentAcademicTermId").getValue();
                		   
                		   var batchValue = batchField.getValue();
                		   
                		   periodField.reset();
                		   seatTypeField.reset();
                		   
                		   periodField.setDisabled(isNullOrEmpty(batchValue) ? true : false);
                		   seatTypeField.setDisabled(isNullOrEmpty(batchValue) ? true : false);
                		   
                		   if(isCurrentAcademicTermId == false){
                			   periodField.setDisabled(true);
                			   seatTypeField.setDisabled(true);
                               setTimeout(function() {
                            	   saveBtn.setDisabled(true)
                               }, 500)
                		   }else{
                		   periodField.getStore().getProxy().extraParams=
                			           {
                			           batchId: batchValue
                			           };
                		   periodField.getStore().load( {
                			           callback: function(records, operation, success) {
                			           if (success) {
                			          for(var i in records){
                			             if(records[i].data.check) {
                			            	 periodField.setValue(records[i]);
                			                 } 
                			               } 
                			              }
                			            }
                			         });
                		   
                		   if(!isNullOrEmpty(batchValue)){
                			   var seatTypeStore = seatTypeField.getStore();
                    		   seatTypeStore.proxy.extraParams = {
                              			batchId : batchValue
             					};
                    		   seatTypeStore.load();
                		   }
                		   this.toggleRetainExamDataCheckbox(form);
                	   }
							if(form.retainExamData) {
								form.down('#retainExamDataId').setValue(true);
							}
                	   }
                   },
                   
                   'studentliststudentprogramtransferwindow customcombobox[itemId=periodId]':{
                	   change: function(obj, record) {
                		   var form = obj.up('form');
                		   var academyLocationField = form.down('#academyLocationCombo');
                		   var intakeYearField = form.down('#intakeYearItemId');
                		   var programGroupField = form.down('#Program_Group');
                		   var programField = form.down('#program');
                		   var batchField = form.down('#batch');
                		   var periodField = form.down('#periodId');
                		   var seatTypeField = form.down('#seatType');
                		   var sectionField = form.down('#section');
                		   
                		   var periodValue = periodField.getValue();
                		   
                		   sectionField.reset();
                		   
                		   
                		   sectionField.setDisabled(isNullOrEmpty(periodValue) ? true : false);
                		   
                		   sectionField.getStore().getProxy().extraParams=
                			           {
                			   periodId: periodValue
                			           };
                		   sectionField.getStore().load( {
                			           callback: function(records, operation, success) {
                			           if (success) {
                			          for(var i in records){
                			             if(records[i].data.check) {
                			            	 sectionField.setValue(records[i]);
                			                 } 
                			               } 
                			              }
                			            }
                			         });
                		   
                	   }
                   },
                   
                   'studentliststudentprogramtransferwindow customcombobox[itemId=seatType]':{
                	   select: function(obj, record) {
                		   var form = obj.up('form');
                		   var currentAcademyLocationId = this.getCurrentAcademyLocation();
                		   var academyLocationId = form.down('#academyLocationCombo').getValue();
                		   if(currentAcademyLocationId == academyLocationId ){
                			 form.down('#retainStudentDataId').setDisabled(false); 
                		   }else{
                			  form.down('#retainStudentDataId').setDisabled(false);
                		   }
                		   form.down('#isCalculateSeparateCGPAndSGPAId').setDisabled(false);

							if(form.retainStudentData) {
								form.down('#retainStudentDataId').setValue(true);
							}
							if(form.retainAcademicData) {
								form.down('#retainAcademicDataId').setValue(true);
							}
							if(form.retainFeeAndPaymentData) {
								form.down('#retainFeeAndPaymentDataId').setValue(true);
							}
							if(form.retainServiceOpted) {
								form.down('#retainServiceOptedId').setValue(true);
							}
							if(form.isCalculateSeparateCGPAndSGPA) {
								form.down('#isCalculateSeparateCGPAndSGPAId').setValue(true);
							}
							if(form.retainExamData) {
								form.down('#retainExamDataId').setValue(true);
							}
                	   }
                   },
                   
                   'studentliststudentprogramtransferwindow button[itemId=saveBtn]': {
						click: function(btn) {
							var me = this;
							var windowForm = this.getStudentliststudentprogramtransferwindow();
							var form = this.getStudentliststudentprogramtransferform();
					
							var vals = form.getValues();
							var confirmMsgText = '';
					
							if(!vals.retainStudentData) {
								confirmMsgText += getCommonTranslation('STUDENT_DATA') + ', ';
							}
							if(!vals.retainAcademicData) {
								confirmMsgText += getCommonTranslation('ACADEMIC_DATA') + ', ';
							}
							if(!vals.retainFeeAndPaymentData) {
								confirmMsgText += getCommonTranslation('FEE_AND_PAYMENT_DATA') + ', ';
							}
							if(!vals.retainServiceOpted) {
								confirmMsgText += getCommonTranslation('SERVICE_OPTED_DATA') + ', ';
							}
							if(!vals.isCalculateSeparateCGPAndSGPA) {
								confirmMsgText += getCommonTranslation('CGPA_AND_SGPA_DATA') + ', ';
							}
							if(!vals.retainExamData) {
								confirmMsgText += getCommonTranslation('EXAMINATION_DATA') + ', ';
							}
				
							if(confirmMsgText !== '') {
								confirmMsgText = confirmMsgText.replace(/,\s*$/, ""); // remove last comma
								confirmMsgText += " " + getCommonTranslation('WILL_BE_PERMANENT_DELETE');
					
								showConfirmMessage(getCommonTranslation('TRANSFER_CLOSURE_CONFIRMATION'), confirmMsgText, function(btn, text){
									if (btn == 'yes') {
										me.proceedForStudentTransfer(windowForm);
									}
								});
							} 
						else {
								me.proceedForStudentTransfer(windowForm);
							}
						}
					},

                   'studentliststudentprogramtransferwindow checkbox[itemId=retainStudentDataId]':{
                	   change: function(value,newValue,oldValue){
                		   var me = this;
                		   var windowForm = this.getStudentliststudentprogramtransferwindow();
                		   var form =this.getStudentliststudentprogramtransferform();
                		   var retainData = windowForm.down('#retainStudentDataId').getValue();
                		   if(retainData == true){
                		   windowForm.down('#retainAcademicDataId').setDisabled(false);
                		   windowForm.down('#retainFeeAndPaymentDataId').setDisabled(false);
                		   windowForm.down('#retainServiceOptedId').setDisabled(false);     
                		   windowForm.down('#courseEnrollmentStatusId').setDisabled(false); 
                           windowForm.down('#courseEnrollmentStatusId').setValue('ENROLLED');
                		   var courseEnrollmentStatusField = windowForm.down('#courseEnrollmentStatusId')
                		   this.setAllowBlank(courseEnrollmentStatusField, false);
                		/*   var allowblankFalse = ':<span class="required" style="color:red"> *</span>'; 
                		   //courseEnrollmentStatus.allowBlank = false;
                		   courseEnrollmentStatusField.setFieldLabel(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');*/
                		   
                		   var submitBtn =windowForm.down('#saveBtn');
                		   if(form.isValid()){
                			   submitBtn.setDisabled(false);
                		   }
                		   else{
                			   submitBtn.setDisabled(true);
                		   }
                		   }
                		   if(retainData == false){
                    		   windowForm.down('#retainAcademicDataId').setDisabled(true);
                    		   windowForm.down('#retainAcademicDataId').setValue(false);
                    		   windowForm.down('#retainFeeAndPaymentDataId').setDisabled(true);
                    		   windowForm.down('#retainFeeAndPaymentDataId').setValue(false);
                    		   windowForm.down('#retainServiceOptedId').setDisabled(true);
                    		   windowForm.down('#retainServiceOptedId').setValue(false);
                    		   windowForm.down('#courseEnrollmentStatusId').setDisabled(true);
                    		   windowForm.down('#courseEnrollmentStatusId').reset();
                    		   
                    		   var submitBtn =windowForm.down('#saveBtn');
                    		   if(form.isValid()){
                    			   submitBtn.setDisabled(false);
                    		   }
                    		   else{
                    			   submitBtn.setDisabled(true);
                    		   }

                    	   }
                		   this.toggleRetainExamDataCheckbox(value.up('form'));
                	   }
                   },
                   'studentliststudentprogramtransferwindow checkbox[itemId=retainAcademicDataId]':{
                	   change: function(cmp, newValue, oldValue) {
                		   this.toggleRetainExamDataCheckbox(cmp.up('form'));
                	   }
                   },
                   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=offerLetterDetailsItemId]': {
	       	        	click: function(btn) {
	       	        		this.openStudentOfferLetterDetailsPopup(btn);
	       	        	}
	       	        },
                   'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=exporetStudentReport]': {
                	   click: function(obj) {
                		   this.openChedExportWin();
                	   }
                   },
                   'chedexportwindow button[itemId=submitBtn]': {
                	   click: function(btn) {
                		   this.exportXlsStudentList();
                	   }
                   },
                   
                   'studentsendsurvey button#saveBtn': {
                	   click: function(obj) {
                		   this.sendSurveyDetails(obj);
                	   }
                   },
                   'kohastudentlibrarymappingwin button#saveBtn': {
                	   click: function(obj) {
                		   this.saveLibraryDetails(obj);
                	   }
                   },'kohastudentcategorymappingwin button#saveBtn': {
                	   click: function(obj) {
                		   this.saveCategoryDetails(obj);
                	   }
                   },
                   'studentstatuscsmwindow button#saveBtn': {
                	   click: function(obj) {
                		   this.saveStudentStatusCSM(obj);
                	   }
                   },
                   'voterpoolwindow[itemId=studentvoterpoolwindow] button#saveBtn': {
                	   click: function(obj) {
                		   this.saveElectionVoterPool(obj);
                	   }
                   },
                   'studentdownloadform[itemId=studentdownloadformId] combo[itemId=program]': {
                   	render : function(combo){
                   		var academyLocationId = this.getCurrentAcademyLocation();
                          	var store = combo.getStore();
                          	store.proxy.extraParams = {
         							 academyLocationId : academyLocationId
         					};
                          	store.load();
                       }
                   },
                   'studentdownloadform[itemId=studentdownloadformId] button[itemId=programBatchDownolad]':{
   	        		click:function(obj){
   	        			var $this = this;
   	        			var form =$this.getStudentdownloadform();
   	        			var values = this.getProgramBatchPeriodJson();

   	        			var csvForm = Ext.create('Ext.form.Panel',{
   	        	    		items:[{
   	        	    			xtype : 'textfield',
   	        	    			maxLength : 20480,
   	        	    			itemId : 'exportListDTO',
   	        	    			name : 'exportListDTO',
   	        	    			vtype : 'spaceAsInput'
   	        	    		}]
   	        	    	});
   	        			
   	        			csvForm.down('#exportListDTO').setValue(values);
   	        			csvForm.getForm().submit({
   		  	        		  target: '_blank',
   		  	        		  method:'POST',
   		  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
   		  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
   		  	        		  url: SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_PROFILE_UPDATE,
   		  	        		  standardSubmit :true,
   		  	        		  success : function(form, action){
 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
 	    	    	          },
 	    	        		  failure: function(form, action) {
 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
 	    	    	          }
   		  	        	  });
   	        			}  
                   },
                   
                 'studentuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
     	   			   change: this.downloadUploadFormChange
     	   		   	},
     	   		   	
     	   		'studentdownloadform button[itemId=addFilterBtn]':{
        			click: function(obj){
        				this.addMultipleProgramBatchfilter(obj);
        			}
        		 },
        		 
        		 'studentuploadform button[itemId=programBatchUpload]':{
 	        		click:function(obj){
 	        			var $this=this;
 	    	        	var importWin=$this.getStudentuploadform()
 	    	        	var grid = $this.getImportstudentlist();
 	    	        	var grdStore;
 	    	        	var form=$this.getStudentuploadform();
 	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
 	    	        	$this.getHashOfFile(form);
 	    	        	setTimeout(function() {
	 	    	        	form.getForm().submit({
	 	    	        		method : 'POST',
	 	    	        		url : submitUrl,
	 	    	        		success : function(form, action){
	 	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	    	        },
	 	    	        		failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	 	    	    	        }
	 	    	        	});
			        	},1000);
 	    	        	Ext.defer(function() {
 	    	        		var form = $this.getStudentuploadformuploadoptionradiogroup();
 	 	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
 	 	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_UPLOAD');
	         	        }, 2000, this);
 	        		}  
        		 },
        		 'studentuploadform uploadoptionradiogroup[itemId=studentUpdateUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
   	 			   change: function( radioGroup, newValue, oldValue, eOpts){
   	 				   var grid =this.getImportstudentlist();
   	 				   var form =this.getStudentuploadformuploadoptionradiogroup();
   	 				   var isUploadAll = newValue.isUploadAll;
   	 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_STUDENT_UPLOAD');
   	 			   }   
   	 		   },
        		 'studentuploadform button[itemId=resetBtn]':{
  	        		click:function(obj){
  	        			var $this=this;
  	        			var studentUploadForm = $this.getStudentuploadform().getForm();
  	        			studentUploadForm.findField('file').reset();
  	        			var uploadoptionradiogroupform  = $this.getStudentuploadformuploadoptionradiogroup();
  	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  	        				isUploadAll: false
  	        			});
  	        		}
        		 },
        		 
        		 'studentdownloadform[itemId=studentdownloadformId] button[itemId=resetBtn]':{
         			click: function(obj){
         				
         				var form = this.getStudentdownloadform();
         				var pbpsContiner = form.down('#programBatchContainerId');
         				var newcont=pbpsContiner.items.items.length;
         				for(var i=newcont;i>0;i--){
         					pbpsContiner.remove(pbpsContiner.items.items[i]);
         				}
         				form.doLayout();
         				form.getForm().reset();
         			}
         		 },
         		/* 
         		'studentquicksearchview':{
					afterrender : function(structure){
						//var form = structure.down('evaluationplanfilter');
						var grid = structure.down('searchresultgrid');
						this.getCBGridHeaderFreeze(grid,structure);
					}
         		},*/
         		
         		'importrelationshiplist':{
         			render:function(obj){
    	   				var $this = this;
     		    		var grid = $this.getImportrelationshiplist();
     		    		var form = $this.getStudentRelationshipuploadoptionradiogroup();
 	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
 	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_RELATIONSHIP_UPLOAD');
     		    		var uploadForm = $this.getStudentrelationshipuploadform();
     		    		var combo = uploadForm.getForm().findField('importUtilityMasterId');
     					combo.getStore().load({
     						 callback: function(records, operation, success) {
     							 for(var i in records){
     								 if(records[i].data.value == 'Bulk Student RelationShip'){
     									 combo.setValue(records[i].data.id);
     									 combo.setReadOnly(true);
     								 }
     							 }
     							 
     		      		   }	   
     				    });
    	   			},
     		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        				if (e.target.tagName == 'A') {
        					var fileType=null;
        					if(cellIndex==1){
        						fileType='successFile';
        					}else if(cellIndex==6){
        						fileType='errorFile';
        					}else if(cellIndex==7){
        						fileType='logFile';
        					}
        					var documentId = record.get("id");
        					if (!isNullOrEmpty(documentId)) {
        						this.getDownloadFile(documentId,fileType);
        					}
        				}
        			}
         		},
         		
         		 'importrelationshiplist button[itemId=btnForce]':{
      	   			click: function(obj) {
      		            	var grid = this.getImportrelationshiplist();
      		            	if (grid.getSelectionModel().getCount() > 0) {
      		            		if(grid.getSelectionModel().getCount() > 1){
      			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
      			        		}else{
      			        			var this$ = this;
      	   	                	var id = grid.getSelectionModel().selectionStart.data.id;
      	   	                	console.log(id);
      	   	                	var urlAppend="?jobName="+id;
      	   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
      	   	    	        	Ext.Ajax.request({
      	   	    	        		url: submitURL,
      	   	    	        		method: 'GET',
      	   	    	        		success: function(response) {
      	   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
      	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
      	   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
      	   	    	        				//console.log("Manual trigger hit");
      	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
      	   	    	        			}else if(response.responseText==="SUCCESS"){
      	   	    	        				//console.log("Manual trigger hit");
      	       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
      	       	    	        			grid.getStore().reload();
      	   	    	        			}
      	   	    	        		}
      	   	    	        	});
      			        		}
      		            	} else {
      		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      		            	}  
      		            }
      	 		   },
         		'importstudentlist':{
         			render:function(obj){
    	   				var $this = this;
     		    		var grid = $this.getImportstudentlist();
     		    		var form = $this.getStudentuploadformuploadoptionradiogroup();
     		    		var isUploadAll = form.items.items[0].getValue().isUploadAll;
     		    		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_UPLOAD');
	     		   		var uploadTemplateForm = this.getStudentuploadform();
	     		   		var combo = uploadTemplateForm.getForm().findField('importUtilityMasterId');
	     		   		combo.getStore().load({
	     		   			 callback: function(records, operation, success) {
	     		   				 for(var i in records){
	     		   					 if(records[i].data.value == 'Bulk Update Students'){
	     		   						 combo.setValue(records[i].data.id);
	     		   						 combo.setReadOnly(true);
	     		   					 }
	     		   				 }
	     		   				 
	     		     		   }	   
	     		   		});
    	   			},
     		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        				if (e.target.tagName == 'A') {
        					var fileType=null;
        					if(cellIndex==1){
        						fileType='successFile';
        					}else if(cellIndex==6){
        						fileType='errorFile';
        					}else if(cellIndex==7){
        						fileType='logFile';
        					}
        					var documentId = record.get("id");
        					if (!isNullOrEmpty(documentId)) {
        						this.getDownloadFile(documentId,fileType);
        					}
        				}
        			}
         		},
         		 'importstudentlist button[itemId=btnForce]':{
     	   			click: function(obj) {
     		            	var grid = this.getImportstudentlist();
     		            	if (grid.getSelectionModel().getCount() > 0) {
     		            		if(grid.getSelectionModel().getCount() > 1){
     			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
     			        		}else{
     			        			var this$ = this;
     	   	                	var id = grid.getSelectionModel().selectionStart.data.id;
     	   	                	console.log(id);
     	   	                	var urlAppend="?jobName="+id;
     	   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
     	   	    	        	Ext.Ajax.request({
     	   	    	        		url: submitURL,
     	   	    	        		method: 'GET',
     	   	    	        		success: function(response) {
     	   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
     	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
     	   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
     	   	    	        				//console.log("Manual trigger hit");
     	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
     	   	    	        			}else if(response.responseText==="SUCCESS"){
     	   	    	        				//console.log("Manual trigger hit");
     	       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
     	       	    	        			grid.getStore().reload();
     	   	    	        			}
     	   	    	        		}
     	   	    	        	});
     			        		}
     		            	} else {
     		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     		            	}  
     		            }
     	 		   },
     	 		   
     	 		   
     	 		 'importeducationhistorylist':{
          			render:function(obj){
     	   				var $this = this;
     	   				var grid = $this.getImporteducationhistorylist();
     	   				var form  = $this.getStudentPastHistoryuploadoptionradiogroup();
     	   				var isUploadAll = form.items.items[0].getValue().isUploadAll;
     	   				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_EDUCATION_HISTORY');
     	   			},
      		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
         				if (e.target.tagName == 'A') {
         					var fileType=null;
         					if(cellIndex==1){
         						fileType='successFile';
         					}else if(cellIndex==6){
         						fileType='errorFile';
         					}else if(cellIndex==7){
         						fileType='logFile';
         					}
         					var documentId = record.get("id");
         					if (!isNullOrEmpty(documentId)) {
         						this.getDownloadFile(documentId,fileType);
         					}
         				}
         			}
          		},
          		
          		 'importeducationhistorylist button[itemId=btnForce]':{
       	   			click: function(obj) {
       		            	var grid = this.getImporteducationhistorylist();
       		            	if (grid.getSelectionModel().getCount() > 0) {
       		            		if(grid.getSelectionModel().getCount() > 1){
       			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
       			        		}else{
       			        			var this$ = this;
       	   	                	var id = grid.getSelectionModel().selectionStart.data.id;
       	   	                	console.log(id);
       	   	                	var urlAppend="?jobName="+id;
       	   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
       	   	    	        	Ext.Ajax.request({
       	   	    	        		url: submitURL,
       	   	    	        		method: 'GET',
       	   	    	        		success: function(response) {
       	   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
       	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
       	   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
       	   	    	        				//console.log("Manual trigger hit");
       	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
       	   	    	        			}else if(response.responseText==="SUCCESS"){
       	   	    	        				//console.log("Manual trigger hit");
       	       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
       	       	    	        			grid.getStore().reload();
       	   	    	        			}
       	   	    	        		}
       	   	    	        	});
       			        		}
       		            	} else {
       		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
       		            	}  
       		            }
       	 		   },
     			   'personinfodashboardhomepage #printBtn' : {
     				   click:  function(button){
     					   var $this = this;
     					   var formWindow = $this.getStudentprintprofilewindow();
     			           if (!formWindow) {
     			        		Ext.widget('studentprintprofilewindow');
     			        		formWindow = $this.getStudentprintprofilewindow();
     			            }
     			           var templateField = formWindow.down("#studentPrintProfil");
     			           var store = Ext.create('Academia.store.setup.templatemapping.TemplateNameListStudentByCode');
     			        	
     			        	store.getProxy().extraParams={
     			    	    	academyLocationId:academyLocationId,
     			    	    	reportType:'Basic Reports',
     			    	    	templateName:'RGI_STUDENT_CONFIRMATION_FORM'
     			    		};
     			        	
     			        	store.load({
     			    			callback: function(records, options, success) {
     				    	        if(records.length>0){
     				    	        	var  templateStore = templateField.getStore();
     				    	        	templateStore.removeAll();
     			                        templateStore.clearData();
     			                    	templateStore.add({
     				    	                 code:  'Print Profile',
     				    	                 value: 'PRINT_PROFILE'
     				    	             });
     				    	        	templateStore.add({
     				    	        		code: records[0].data.code,
     				    	        		value: records[0].data.value
     				    	            });
     				    	        	var isSingleStudent = formWindow.down("#isSingleStudent");
     				    	        	isSingleStudent.setValue('true');
     				    				formWindow.show();
     				    			}else{
     				    				$this.printButtonAction(button);
     				    			} 
     			    			}
     			    	    });
     					  
     				   }
     			   },
     			   
     			  'personinfodashboardhomepage' : {
    				   render:  function(panel){
    					   this.disableMyDashboardPivileges(panel,this.getSTUDENT_MY_DASHBOARD_PERMISSIONS());
    				   }
    			   },
    			   'studentacademictopicstructure radiogroup[itemId=importDownloadgroupId]':{
    	 			   change: this.studentAcademicTopicDownloadUploadFormChange
    			   },
    			   'studentacademictopicdownloadform button[itemId=resetBtn]':{
	       	 			click:function(obj){
	       	 				var $this = this;
	       	 				var form =obj.up('studentacademictopicdownloadform').getForm();
	       	 				form.reset();
	   	 				
	       	 				var downloadForm = $this.getStudentacademictopicdownloadform();
	       	 				var batchId = downloadForm.down("#batchItemId");
	       	 				batchId.setDisabled(true);
	       	 				batchId.reset();
	 					   
	       	 				var periodId = downloadForm.down("#periodItemId"); 					   
	       	 				periodId.setDisabled(true);
	       	 				periodId.reset();
	   	 				
	       	 				var sectionId = downloadForm.down("#sectionItemId"); 
	       	 			    sectionId.setVisible(true);
	       	 				sectionId.setDisabled(true);
	       	 				sectionId.reset();
	   	 				   
	       	 				var academicSubTopicItemId = downloadForm.down("#academicSubTopicItemId"); 	
	       	 			    academicSubTopicItemId.setVisible(false);
	       	 				academicSubTopicItemId.setDisabled(true);
	       	 				academicSubTopicItemId.reset();
	       	 				
	       	 				var academicTopicItemId = downloadForm.down("#academicTopicItemId"); 
	       	 			    academicTopicItemId.setVisible(false);
	       	 				academicTopicItemId.setDisabled(true);
	       	 				academicTopicItemId.reset();

	       	 				var serviceNameComboField = downloadForm.down("#serviceNameComboField"); 
	       	 			    serviceNameComboField.setVisible(false);
	       	 			    serviceNameComboField.setDisabled(true);
	       	 			    serviceNameComboField.reset();

	       	 				var communityNameComboField = downloadForm.down("#communityNameComboField"); 	
	       	 			    communityNameComboField.setVisible(false);
	       	 				communityNameComboField.setDisabled(true);
	       	 				communityNameComboField.reset();
	       	 				
	       	 			    var intakeYear = downloadForm.down("#intakeYear"); 
	       	 			    intakeYear.setVisible(false);
	       	 			}  
	       	 		},
		       	 	'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] combo[itemId=programItemId]': {
		       	 		render : function(combo){
	                   		var academyLocationId = this.getCurrentAcademyLocation();
                          	var store = combo.getStore();
                          	store.proxy.extraParams = {
                      			academyLocationId : academyLocationId
         					};
                          	store.load();
	                   	},
	                    select:function(obj,record){
	                    	var programId = record[0].get("id");
	                    	if(programId > 0){
                    			var downloadForm = this.getStudentacademictopicdownloadform();
	                    		var batchId = downloadForm.down("#batchItemId");
	                    		batchId.setDisabled(false);
	                    		batchId.reset();
	                     	
	                    		var periodId = downloadForm.down("#periodItemId"); 					   
	                    		periodId.setDisabled(true);
	                    		periodId.reset();
	                    		
	                    		var sectionId = downloadForm.down("#sectionItemId"); 					   
	                    		sectionId.setDisabled(true);
	                    		sectionId.reset();
	 	                    	
	 	                    	var store = batchId.getStore();
	 	                      	store.proxy.extraParams = {
	 	     							 id : programId
	 	     					};
	 	                      	store.load();
	                    	}
	                    }
		       	 	},
		       	 	'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] combo[itemId=multiProgramItemId]': {
		       	 		render : function(combo){
	                   		var academyLocationId = this.getCurrentAcademyLocation();
                          	var store = combo.getStore();
                          	store.proxy.extraParams = {
                      			academyLocationId : academyLocationId
         					};
                          	store.load();
	                   	},
	                   	change:function(obj,record){
	                   		var form = obj.up('form');
	                   		var values = form.getForm().getValues();
	                   		var programId = values.multiProgram;
	                   		var batch = form.down('#batch');
	                   		batch.setDisabled(false);
	                   		batch.reset();
	                   		var store = batch.getStore();
	                   		store.removeAll();
	                   		var programids=[];
	                   		var programs; 
	                   		if(programId !=undefined && programId.length > 0){
	                   			for(var i in programId){
	                   				if(Ext.isObject(programId[0])){
	                   					programids.push(programId[i].get("id"));
	                   				}else{
	                   					programids.push(programId[i]);
	                   				}
	                   			}
	                   			programs = programids.join();
	                   			store.proxy.extraParams = {
	                   					program : programs
	                   			};
	                   			store.load();
	                   		}
	                   	}
		       	 	},
		       	 	'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] combo[itemId=batch]': {
					    change : function(obj){
						   var form = obj.up('form');
						   var values = form.getForm().getValues();
						   var batchId = values.BATCH_NAME;
						   var seatType = form.down('#seatType');
						   seatType.setDisabled(false);
						   seatType.reset();
						   var store = seatType.getStore();
                           store.removeAll();
						   var batchids=[];
						   var batchs; 
						   if(batchId !=undefined && batchId.length > 0){
					    		for(var i in batchId){
					    			if(Ext.isObject(batchId[0])){
					    				batchids.push(batchId[i].get("id"));
					    			}else{
					    				batchids.push(batchId[i]);
					    			}
					    		}
					    		batchs = batchids.join();
						 	    var store = seatType.getStore();
						 	    store.getProxy().extraParams = {
						 	    	batch : batchs
								};
							   store.load();
						   }
					   }
				   },
		       	 	'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] combo[itemId=academicTopicItemId]': {
	                   	render : function(combo){
	                       	var store = combo.getStore();
	                       	store.load();
		                }
	       	 		},
	       	 		
	       	 		 'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] customcombobox#academyLocationCombo':{
		            	change:function(obj,record){
		            		if(Ext.isObject(record)){
                                var academyLocationId = record[0].get("id");
                            }else{
                                var academyLocationId = record
                            }
	                    	if(academyLocationId > 0){
                    			var downloadForm = this.getStudentacademictopicdownloadform();
	                    		var multiProgramItemId = downloadForm.down("#multiProgramItemId");
	                    		multiProgramItemId.setDisabled(false);
	                    		multiProgramItemId.reset();
	                     	
	                    		var batch = downloadForm.down("#batch"); 					   
	                    		batch.setDisabled(true);
	                    		batch.reset();
	                    		
	                    		var seatType = downloadForm.down("#seatType"); 					   
	                    		seatType.setDisabled(true);
	                    		seatType.reset();
	 	                    	
	 	                    	var store = multiProgramItemId.getStore();
	 	                      	store.proxy.extraParams = {
	 	                      			academyLocationId : academyLocationId
	 	     					};
	 	                      	store.load();
	                    	}
	                    }
		            	
		             },
	       	 		
	       	 		'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] combo[itemId=batchItemId]': {
	                    select:function(obj,record){
	                    	var id = record[0].get("id");
	                    	if(id > 0){
	                    		var downloadForm = this.getStudentacademictopicdownloadform();
	                     	
	                    		var periodId = downloadForm.down("#periodItemId"); 					   
	                    		periodId.setDisabled(false);
	                    		periodId.reset();
	                    		
	                    		var sectionId = downloadForm.down("#sectionItemId"); 					   
	                    		sectionId.setDisabled(true);
	                    		sectionId.reset();
	                    		
	                    		var seatType = downloadForm.down("#seatType"); 					   
	                    		seatType.setDisabled(false);
	                    		seatType.reset();
	 	                    	
	 	                    	var store = periodId.getStore();
	 	                      	store.proxy.extraParams = {
	 	     							 id : id
	 	     					};
	 	                      	store.load();
	 	                      	
	 	                      	var seatTypestore = seatType.getStore();
	 	                      	seatTypestore.proxy.extraParams = {
	 	                      			batch : id
	 	     					};
	 	                      	seatTypestore.load();
	                    	}
	                    	
	                    }
		       	 	},
		       	 	'studentacademictopicdownloadform button[itemId=downoladBtnId]':{
	     	 			click:function(obj){
	     	 				var $this = this;
	     	 				var form =obj.up('studentacademictopicdownloadform').getForm();
	     	 				var value = form.getValues();
	     	 				var csvForm = Ext.create('Ext.form.Panel'); 
	     	 		    	var values = form.getValues();
	     	 		    	
	     	 		    	var programId = values.programId;
	    	 				var batchId = values.batchId;
	    	 				var periodId = values.periodId;
	    	 				//var sectionId = values.sectionId;
	    	 				//var academicTopicId = values.academicTopicId;
	    	 				//var academicSubTopicId = values.academicSubTopicId;
	    	 				
	    	 				var multiProgramId = values.multiProgram;
	    	 				var multiBatchId = values.BATCH_NAME;
	    	 				var multiSeatTypeId = values.SEAT_TYPE;
	    	 				
	    	 				 var multiProgramArray = [];
		        	            if(!isNullOrEmpty(multiProgramId)){
		        	        		if(typeof multiProgramId == "object"){
		        	            		Ext.each(multiProgramId, function(multiProgramIds){
		        	                        if(!isNullOrEmpty(multiProgramIds)){
		        	                        	multiProgramArray.push(multiProgramIds.data.id);
		        	                        }
		        	                    });
		        	        		} else{
		        	        			multiProgramArray.push(multiProgramId);
		        	        		}
		        	        	}
		        	            
		        	            var multiBatchArray = [];
		        	            if(!isNullOrEmpty(multiBatchId)){
		        	        		if(typeof multiBatchId == "object"){
		        	            		Ext.each(multiBatchId, function(multiBatchIds){
		        	                        if(!isNullOrEmpty(multiBatchIds)){
		        	                        	multiBatchArray.push(multiBatchIds.data.id);
		        	                        }
		        	                    });
		        	        		} else{
		        	        			multiBatchArray.push(multiBatchId);
		        	        		}
		        	        	}
		        	            
		        	            var multiSeatTypeArray = [];
		        	            if(!isNullOrEmpty(multiSeatTypeId)){
		        	        		if(typeof multiSeatTypeId == "object"){
		        	            		Ext.each(multiSeatTypeId, function(multiSeatTypeIds){
		        	                        if(!isNullOrEmpty(multiSeatTypeIds)){
		        	                        	multiSeatTypeArray.push(multiSeatTypeIds.data.id);
		        	                        }
		        	                    });
		        	        		} else{
		        	        			multiSeatTypeArray.push(multiSeatTypeId);
		        	        		}
		        	        	}
	    	 				
	    	 				
	    	 				var url = '';
	     	 		    	var params = {
 	     	 						access_token : Ext.Ajax.defaultHeaders.access_token,
 	     	 						programId : programId,
 	     	 						batchId : batchId,
	     	 						periodId : periodId
	     	 					};
	    	 				
	     	 		    	if( values.templateType == 'AcademicTopics' ){
	     	 		    		url = SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_ACADEMIC_TOPIC;
	     	 		    		params.academicTopicId = values.academicTopicId;
	     	 		    		params.academicSubTopicId = values.academicSubTopicId;
	     	 		    		params.sectionId = values.sectionId;
	     	 		    	}
	     	 		    	if( values.templateType == 'Communities' ){
	     	 		    		url = SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_COMMUNITIES;
	     	 		    		if( !isNullOrEmpty(values.community) ){
	     	 		    			params.communityId = values.community.id;
	     	 		    		}
	     	 		    		params.intakeYearId = values.INTAKE_YEAR;
	     	 		    	}
	     	 		    	if( values.templateType == 'Services' ){
	     	 		    		url = SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_SERVICES;
	     	 		    		if( !isNullOrEmpty(values.service) ){
	     	 		    			params.serviceId = values.service.id;
	     	 		    		}
	     	 		    		params.intakeYearId = values.INTAKE_YEAR;
	     	 		    	}
	     	 		    	if( values.templateType == 'OtherInformation' ){
	     	 		    		url = SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_OTHER_INFORMATION;
	     	 		    		params.sectionId = values.sectionId;
	     	 		    	}
	     	 		    	if( values.templateType == 'ProgramCompletionDetails' ){
	     	 		    		url = SERVERURL.DOWNLOAD_TEMPLATE_PROGRAM_COMPLETION_DETAILS;
	     	 		    		params.programId = values.programId;
	     	 		    		params.batchId = values.batchId;

	     	 		    	}
	     	 		    	if( values.templateType == 'IdentityDocument' ){
	     	 		    	  url = SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_IMPORT_IDENTITY_DOCUMENT;
                              var academyLocationIds = values.ACAD_LOC_ID;
                              var programIds = multiProgramArray;
                              var batchIds = multiBatchArray;
                              var seatTypeIds = multiSeatTypeArray;

	     	 		    	}
	     	 		    	if( values.templateType == 'IdentityDocument' ){
	     	 		    		csvForm.getForm().submit({
		     	 					target: '_blank',
		     	 					method:'POST',
		     	 					 params :{
					        			  access_token : Ext.Ajax.defaultHeaders.access_token, 
					        			  'academyLocationIds': academyLocationIds,
					        			  'programIds' : programIds.join(),
					        			  'batchIds' : batchIds.join(),
					        			  'seatTypeIds' : seatTypeIds.join(),
					        			  },
		     	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		     	 					url: url,
		     	 					standardSubmit :true
		     	 				});
	     	 		    	}else{
	     	 		    		csvForm.getForm().submit({
		     	 					target: '_blank',
		     	 					method:'POST',
		     	 					params :params,
		     	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		     	 					url: url,
		     	 					standardSubmit :true
		     	 				});
	     	 		    	}
	     	 				
	     	 			}  
	     	 		},
	     	 		'studentacademictopicuploadform button[itemId=uploadId]':{
	     	 			click:function(obj){
	     	 				var $this=this;
	     	 				var importWin=obj.up('studentacademictopicuploadform');
	     	 				var grdStore;
	     	 				var form=obj.up('studentacademictopicuploadform');
	     	 				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	     	 				$this.getHashOfFile(form);
	     	 				setTimeout(function() {
		     	 				form.getForm().submit({
		     	 					method : 'POST',
		     	 					url : submitUrl,
		     	 					success : function(form, action){
		     	 						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		     	 					},
		     	 					failure: function(form, action) {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		     	 					}
		     	 				});
	     	 				},1000);
	     	 				Ext.defer(function() {
	     	 					var grid = $this.getImportstudentacademictopiclist();
	     	 					var form = $this.getStudentAcademicTopicuploadoptionradiogroup();
	     	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	     	 					var templateTypeId=importWin.down('#templateTypeId').getValue();
	     	 					if(templateTypeId == 'AcademicTopics'){
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_STUDENT_ACADEMIC_TOPIC_UPLOAD');
	     	 					}else if(templateTypeId == 'Communities'){
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_COMMUNITY');
	     	 					}else if(templateTypeId == 'Services'){
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_SERVICE');
	     	 					}else if(templateTypeId == 'OtherInformation'){
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_OTHER_INFORMATION');
	     	 					}else if(templateTypeId == 'ProgramCompletionDetails'){
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_PROGRAM_COMPLETION_DETAILS');
	     	 					}
	     	 					else if(templateTypeId == 'IdentityDocument'){
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_IDENTITY_DOCUMENT');
	     	 					}
	     	 				}, 2000, this);
	     	 			}  
	     	 		},
	     	 		'studentacademictopicuploadform button[itemId=resetBtn]':{
     	 			   click:function(obj){
     	 				   var $this = this;
     	 				   var form =obj.up('studentacademictopicuploadform').getForm();
     	 				   form.findField('file').reset();
     	 				   form.findField('templateType').reset();
     	 				   form.findField('importUtilityMasterId').reset();
     	 				   var uploadoptionradiogroupform  = $this.getStudentAcademicTopicuploadoptionradiogroup();
     	 				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
     	 					   isUploadAll: false
     	 				   });
     	 				   form.isValid();
     	 			   },
     	 			   render :function(obj){/*
     	 				   var $this = this;
     	 				   var form =obj.up('studentacademictopicuploadform').getForm();
     	 				   var combo = form.findField('importUtilityMasterId');
     	 				   combo.getStore().load({
     	 					   callback: function(records, operation, success) {
     	 						   for(var i in records){
     	 							   if(records[i].data.value=='Bulk Student Academic Topic'){
     	 								   combo.setValue(records[i].data.id);
     	 								   combo.setReadOnly(true);
     	 							   }
     	 						   }
     	 					   }	   
     	 				   });
     	 			   */}  
     	 		   },
     	 		   'studentacademictopicuploadform uploadoptionradiogroup[itemId=studentAcademicTopicUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
     	 			   change: function( radioGroup, newValue, oldValue, eOpts){
     	 				   var uploadForm= radioGroup.up('studentacademictopicuploadform');
     	 				   var grid =this.getImportstudentacademictopiclist();
     	 				   var form =this.getStudentAcademicTopicuploadoptionradiogroup();
     	 				   var isUploadAll = newValue.isUploadAll;
     	 				   var templateTypeId=uploadForm.down('#templateTypeId').getValue();
     	 				   if(templateTypeId == 'AcademicTopics'){
     	 					 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_STUDENT_ACADEMIC_TOPIC_UPLOAD');
     	 				   }else if(templateTypeId == 'Communities'){
     	 					 this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_COMMUNITY');
     	 				   }else if(templateTypeId == 'Services'){
     	 					 this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_SERVICE');
     	 				   }else if(templateTypeId == 'OtherInformation'){
     	 					 this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_OTHER_INFORMATION');
     	 				   }else if(templateTypeId == 'ProgramCompletionDetails'){
    	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_PROGRAM_COMPLETION_DETAILS');
    	 					}else if(templateTypeId == 'IdentityDocument'){
     	 						this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_IDENTITY_DOCUMENT');
     	 					}
     	 				  
     	 			   }   
     	 		   },
     	 		  'importstudentacademictopiclist':{
     				   render:function(obj){
     					   var $this = this;
     					   var grid = $this.getImportstudentacademictopiclist();
     					   var form = $this.getStudentAcademicTopicuploadoptionradiogroup();
     					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
     					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_ACADEMIC_TOPIC_UPLOAD');
     					   //$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_COMMUNITY');
     				   },
     				   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     					   if (e.target.tagName == 'A') {
     						   var fileType=null;
     						   if(cellIndex==1){
     							   fileType='successFile';
     						   }else if(cellIndex==6){
     							   fileType='errorFile';
     						   }else if(cellIndex==7){
     							   fileType='logFile';
     						   }
     						   var documentId = record.get("id");
     						   if (!isNullOrEmpty(documentId)) {
     							   this.getStudentAcademicTopicDownloadFile(documentId,fileType);
     						   }
     					   }
     				   }
     			   },
     			   'importstudentacademictopiclist button[itemId=btnForce]':{
     				   click: function(obj) {
     					   var grid = this.getImportstudentacademictopiclist();
     					   if (grid.getSelectionModel().getCount() > 0) {
     						   if(grid.getSelectionModel().getCount() > 1){
     							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
     						   }else{
     							   var this$ = this;
     							   var id = grid.getSelectionModel().selectionStart.data.id;
     							   console.log(id);
     							   var urlAppend="?jobName="+id;
     							   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
     							   Ext.Ajax.request({
     								   url: submitURL,
     								   method: 'GET',
     								   success: function(response) {
     									   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
     										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
     									   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
     										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
     									   }else if(response.responseText==="SUCCESS"){
     										   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
     										   grid.getStore().reload();
     									   }
     								   }
     							   });
     						   }
     					   } else {
     						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     					   }  
     				   }
     			   },
     			   /* import aggregation*/

	     	 		'importaggregationdownloadform button[itemId=downoladBtnId]':{
		    			click : function(obj) {
		 					$this=this;
							var csvForm = Ext.create('Ext.form.Panel'); 
        	 					csvForm.getForm().submit({
        	 					target: '_blank',
        	 					method:'POST',
        	 					params :{
        	 						access_token : Ext.Ajax.defaultHeaders.access_token,
        	 					},
        	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        	 					url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_AGGREGATIONS,
        	 					standardSubmit :true
        	 				});
	 	   			 	}
		    		 },
		    	
     				'importaggregationuploadform button[itemId=uploadId]':{
	     	 			click:function(obj){
	     	 				var $this=this;
	     	 				var importWin=obj.up('importaggregationuploadform');
	     	 				var grdStore;
	     	 				var form=obj.up('importaggregationuploadform');
	     	 				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	     	 				$this.getHashOfFile(form);
	     	 				setTimeout(function() {
		     	 				form.getForm().submit({
		     	 					method : 'POST',
		     	 					url : submitUrl,
		     	 					success : function(form, action){
		     	 						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
		     	 					},
		     	 					failure: function(form, action) {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		     	 					}
		     	 				});
	     	 				},1000);
	     	 				Ext.defer(function() {
	     	 					var grid = $this.getImportaggregationlist();
	     	 					var form = $this.getImportAggregationsuploadoptionradiogroup();
	     	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	     	 						this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_AGGREGATIONS');
	     	 				}, 2000, this);
	     	 			}  
	     	 		},
	     	 		
		    			'importaggregationuploadform button[itemId=resetBtn]':{
	     	 			   click:function(obj){
	     	 				   var $this = this;
	     	 				   var form =obj.up('importaggregationuploadform').getForm();
	     	 				   form.findField('file').reset();
	     	 				   var uploadoptionradiogroupform  = $this.getImportAggregationsuploadoptionradiogroup();
	     	 				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	     	 					   isUploadAll: false
	     	 				   });
	     	 				   form.isValid();
	     	 			   }, 
	     	 		   },
	     	 		 
	     	 		  'importaggregationuploadform uploadoptionradiogroup[itemId=importAggregationsUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	     	 			   change: function( radioGroup, newValue, oldValue, eOpts){
	     	 				   var uploadForm= radioGroup.up('importaggregationuploadform');
	     	 				   var grid =this.getImportaggregationlist();
	     	 				   var form =this.getImportAggregationsuploadoptionradiogroup();
	     	 				   var isUploadAll = newValue.isUploadAll;
	     	 				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_AGGREGATIONS');
	     	 				   }   
	     	 		   },
	     	 		  
	     	 		  'importaggregationlist':{
	     				   render:function(obj){
	     					   var $this = this;
	     					   var grid = $this.getImportaggregationlist();
	     					   var form = $this.getImportAggregationsuploadoptionradiogroup();
	     					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
	     					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_AGGREGATIONS');
	     				   },
	     				   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	     					   if (e.target.tagName == 'A') {
	     						   var fileType=null;
	     						   if(cellIndex==1){
	     							   fileType='successFile';
	     						   }else if(cellIndex==6){
	     							   fileType='errorFile';
	     						   }else if(cellIndex==7){
	     							   fileType='logFile';
	     						   }
	     						   var documentId = record.get("id");
	     						   if (!isNullOrEmpty(documentId)) {
	     							   this.getImportAggregationsTopicDownloadFile(documentId,fileType);
	     						   }
	     					   }
	     				   }
	     			   },
	     			   'importaggregationlist button[itemId=btnForce]':{
	     				   click: function(obj) {
	     					   var grid = this.getImportaggregationlist();
	     					   if (grid.getSelectionModel().getCount() > 0) {
	     						   if(grid.getSelectionModel().getCount() > 1){
	     							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	     						   }else{
	     							   var this$ = this;
	     							   var id = grid.getSelectionModel().selectionStart.data.id;
	     							   console.log(id);
	     							   var urlAppend="?jobName="+id;
	     							   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	     							   Ext.Ajax.request({
	     								   url: submitURL,
	     								   method: 'GET',
	     								   success: function(response) {
	     									   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	     										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	     									   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	     										   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	     									   }else if(response.responseText==="SUCCESS"){
	     										   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	     										   grid.getStore().reload();
	     									   }
	     								   }
	     							   });
	     						   }
	     					   } else {
	     						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	     					   }  
	     				   }
	     			   },
	     			
	     			  'importaggregationuploadform':{
			        		render:function(obj){
			        			var $this=this;
			    	        	var importWin=$this.getImportaggregationuploadform()
			    	        	var moduleName = importWin.down('#moduleName');
			    	        	moduleName.getStore().load({
			    	        		callback: function(records, operation, success) {
			    	        			for(var i in records){
				    	        			if(records[i].data.value=="Import Aggregations"){
				    	        				moduleName.setValue(records[i].data.id);
				    	        				moduleName.setReadOnly(true)
				    	        			}
			    	        			}
		 	            		   }	
			    	        	});
			        		}  
		    		 },
	     	 		   /** ------  */
	     	 		 'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=bulkDownloadDocId]': {
   	 			     click: function() {
   	 				   var grid = this.getSearchResultGrid();
   	 				   if (grid.getSelectionModel().getCount() > 0) {
   	 					   var bulkDocDownloadItemId ="studentbulkdownloaddocumentwin";
   	 					   var bulkDocDownloadWin = Ext.widget('bulkdownloaddocumentwin', {
   	 						   itemId: bulkDocDownloadItemId
   	 					   });

   	 					   var formWindowTab = this.getBulkdownloaddocumentwin();
   	 					   
   	 					   var applicationDocumentsId = formWindowTab.down("#applicationDocumentsId");
   	 					   var applicationDocumentsIdStore = applicationDocumentsId.getStore();

   	 					   applicationDocumentsIdStore.getProxy().extraParams = {
   	 						   personType:'STUDENT',
	 						   isApplicableForStudent: true
   	 					   };
   	 					   
   	 					   var userName = formWindowTab.down("#user_name");
   	 					   var userNameStore = userName.getStore();
   	 					   var userId = this.getCurrentlyLoggedInUser().id;
   	 					   userNameStore.load({
   	 						   callback: function(records, operation, success) {
   	 							   if (success) {
   	 								  for(var i in records) {
   		 								   	if(records[i].data.id == userId){
   		 								   	userName.setValue(records[i].data.id);
   		 								   	}
   	 								   }
   	 							   }
   	 						   }	   
   	 					   });
   	 					  bulkDocDownloadWin.show();
   	 					  
   	 				   } else {
   	 					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
   	 				   } 
   	 			   }
   	 		   },
   	 		   
   	 		   'bulkdownloaddocumentwin[itemId=studentbulkdownloaddocumentwin] button[itemId=bulkDocCancel]': {	 			  
	 			   click:function(obj){
	 				   obj.up('window').close();
	 			   }
	 		   },
	 		   
	 		  /*Reset Bulk document win*/
	 		   'bulkdownloaddocumentwin[itemId=studentbulkdownloaddocumentwin] button[itemId=submitBtn]': {	 			  
	 			   click: function(obj) {
	 				  this.sendStudentBulkDocumentGenerateDetail(obj);
	 			   }	 			  
	 		   },
	 		  'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] customcombobox[itemId=recipientName]' : {
	 			 render : function(combo) {
	 				var contentPanel=this.getContentPanel();
	 				var personId=contentPanel.getActiveTab().personId;
	 				//var studentProfile = this.getStudentprofile();
	 				//var personId = studentProfile.personInfo.id;
	 				combo.getStore().getProxy().api.read = SERVERURL.PATH_FIND_RECIEPT_NAMES_FOR_STUDENT;
	 				combo.getStore().getProxy().extraParams = {
	 					  personId: personId
					};
	 				combo.getStore().sorters.clear();
	 				combo.getStore().load();
	 				
	 				var structure = combo.up('communicationhistorystructure');
 	 				//var contactId = structure.down('customcombobox#contactId');
 	 				
 	 				setTimeout(function(){
 	 					
 	 					var contactId = structure.down('customcombobox#contactId');
 	 					contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
 						contactId.getStore().getProxy().extraParams = {
	 						id: personId,
	 						isEmail:true,
 						};
 						contactId.getStore().load();
 						
 						var mobileId = structure.down('customcombobox#mobileId');
 						mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
 						mobileId.getStore().getProxy().extraParams = {
 							id: personId,
 							isEmail:false,
 						};
 						mobileId.getStore().load();
 						
 	 				},500);
					
	 			 },
	 			 select:function(recipientName,record){
	 				 
	 				var studentProfile = this.getStudentprofile();
					var emailId = studentProfile.personInfo.emailId;
					//var printName = studentProfile.personInfo.printName;
					var printName = studentProfile.personInfo.firstName;
					if(isNullOrEmpty(printName)){
						var printName = studentProfile.personInfo.firstName;
					}
					var mobileNumber = studentProfile.personInfo.mobileNumber;
					var selectedObj = recipientName.getValue();
					
					var structure = recipientName.up('communicationhistorystructure');
					//var personId = studentProfile.personInfo.id;
					
					/*recipientName.getStore().getProxy().api.read = SERVERURL.PATH_FIND_RECIEPT_NAMES_FOR_STUDENT;
					recipientName.getStore().getProxy().extraParams = {
 						personId: personId
				  	};*/
					
					var parentPersonId;
					var feePayerId;
					var personId;
					
					if( record[0].raw.code == "STUDENT" ){
						personId = record[0].raw.id;
					}
					if( record[0].raw.code == "PARENT" ){
						parentPersonId = record[0].raw.id;
					}
					if( record[0].raw.code == "FEE_PAYER" ){
						feePayerId = record[0].raw.id;
					}
					
					var contactId = structure.down('customcombobox#contactId');
					contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
					contactId.getStore().getProxy().extraParams = {
						id: personId,
						parentPersonId: parentPersonId,
						feePayerId: feePayerId,
						isEmail:true,
						receipentType: record[0].raw.code
					};
					
					contactId.reset();
					contactId.getStore().load({
						callback : function(records,operation,success) {
							
							var mobileId = structure.down('customcombobox#mobileId');
							mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
							mobileId.getStore().getProxy().extraParams = {
								id: personId,
								parentPersonId: parentPersonId,
								feePayerId: feePayerId,
								isEmail:false,
								receipentType: record[0].raw.code
							};
							mobileId.reset();
							mobileId.getStore().load();
						}
					});
	 			 }
	 		  },
	 		  
		 		  'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId]' : {
		 			  render : function(structure) {
		 				  var form = this.getCommunicationhistorystructure();            		
		 				  var searchBtn = form.down("#searchButtonId");
		 				  searchBtn.setDisabled(true);
		 			  }
					},
					 'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] button[itemId=resetButtonId]': {
			                click: function(){                	
			                	var form = this.getCommunicationhistorystructure(); 
			                	 var grid =  this.getCommunicationhistorylist();
			            		var sendMessage = form.down("#sendmessageId").reset();
			            		var recipient=form.down("#recipientName").reset();
			            		var contactId=form.down("#contactId").reset();
			            		var sentbyName=form.down("#sentby").reset();
			            		var eventNameCode=form.down("#eventName").reset();
			            		var eventDateForm=form.down("#eventDateForm").reset();
			            		var eventDateTill=form.down("#eventDateTill").reset();
			            		 grid.down("#exportMessageSentReportItemId").setDisabled(true);
			            		var studentProfile = this.getStudentprofile();
				 				var personId = studentProfile.personInfo.id;
			            		
			            		var contactId = form.down('customcombobox#contactId');
		 	 					contactId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
		 						contactId.getStore().getProxy().extraParams = {
		 							  	  id: personId,
		 								  isEmail:true,
		 						};
		 						contactId.getStore().load();
		 						
		 						var mobileId = form.down('customcombobox#mobileId');
		 						mobileId.getStore().getProxy().api.read = SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID;
		 						mobileId.getStore().getProxy().extraParams = {
		 							  	  id: personId,
		 								  isEmail:false,
		 							  };
		 						mobileId.getStore().load();
			            		
			                }
			            },
					'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] radiogroup[itemId=sendmessageId]': {
		            	change: function(obj,value){                	
		                	var form = this.getCommunicationhistorystructure(); 
		                	 var grid =  this.getCommunicationhistorylist();
		                	var contactField=form.down("#contactId");
		        			var mobileField=form.down("#mobileId");
		        			 grid.down("#exportMessageSentReportItemId").setDisabled(true);
		            		if(value.sendMessage===2){              			
		                		//var recipient=form.down("#recipientName").reset();
		                		var contactId=form.down("#contactId").reset();
		                		var sentbyName=form.down("#sentby").reset();
		                		var eventNameCode=form.down("#eventName").reset();
		                		var eventDateForm=form.down("#eventDateForm").reset();
		                		var eventDateTill=form.down("#eventDateTill").reset();
		                		var mobileNO=form.down("#mobileId").reset();
		            			contactField.setVisible(false);
		            			mobileField.setVisible(true);   
			            	
		            		}else{
		                	//	var recipient=form.down("#recipientName").reset();
		                		var contactId=form.down("#contactId").reset();
		                		var sentbyName=form.down("#sentby").reset();
		                		var eventNameCode=form.down("#eventName").reset();
		                		var eventDateForm=form.down("#eventDateForm").reset();
		                		var eventDateTill=form.down("#eventDateTill").reset();
		            			contactField.setVisible(true);
		            			mobileField.setVisible(false);            			
		            		}                	
		                }
		            },
		            'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] button[itemId=searchButtonId]':{
		            	click : function(obj){
		            		var contentPanel=this.getContentPanel();
			 				var getActiveTab=contentPanel.getActiveTab();
			 				var form = getActiveTab.down('communicationhistorystructure');
		            		//var form = this.getCommunicationhistorystructure();
		            		//var grid =  this.getCommunicationhistorylist();
		            		//var grid =  form.down('communicationhistorylist');
		            		
		            		var personProfile = this.getContentPanelActiveTab();
		            		var grid = personProfile.down('communicationhistorylist');
		            		
		            		var sendMessage = form.down("#sendmessageId").getValue();
		            		//console.log(sendMessage);
		            		var recipient=form.down("#recipientName").getValue();
		            				if(!isNullOrEmpty(personProfile.getPersonInfo().middleName)){
		            		var firstName = personProfile.getPersonInfo().firstName;
		            		var middleName = personProfile.getPersonInfo().middleName;
		            		var lastName = personProfile.getPersonInfo().lastName;
		            		
		            		var fullName = firstName +" "+ middleName +" "+ lastName;
		            		}
		            		if( !isNullOrEmpty(recipient) && recipient != undefined ){
		            			
		            			var n = recipient.search("/");
			            	    if( n != -1 ){
			            	        var res = recipient.split("/");
			            	        if( !isNullOrEmpty(res) && res.length > 0 ){
			            	        	recipient = res[res.length-1];
			            	        	/*if( recipient.search(" ") != -1 ){
			            	        		var res2 = recipient.split(" ");
			            	        		if( !isNullOrEmpty(res2) && res2.length > 0 ){
			            	        			recipient = res2[0];
			            	        		}
			            	        	}*/
			            	        }
			            	    } else {
			            	    	/*if( recipient.search(" ") != -1 ){
		            	        		var res3 = recipient.split(" ");
		            	        		if( !isNullOrEmpty(res3) && res3.length > 0 ){
		            	        			recipient = res3[0];
		            	        		}
		            	        	}*/
			            	    }
		            		} else {
		            			//recipient = "rohit test 1 lname,Fatherrrr lnameeee,Motherrrr lnameeee";
		            			var recipientComboStore=form.down("#recipientName").getStore();
	            				var recipientStoreValue = recipientComboStore.data.items;
	            				var recipientValue = recipientStoreValue[0].data.value;
	            				
	            				var n = recipientValue.search("/");
			            	    if( n != -1 ){
			            	        var res = recipientValue.split("/");
			            	        if( !isNullOrEmpty(res) && res.length > 0 ){
			            	        	recipientValue = res[res.length-1];
			            	        	/*if( recipient.search(" ") != -1 ){
			            	        		var res2 = recipient.split(" ");
			            	        		if( !isNullOrEmpty(res2) && res2.length > 0 ){
			            	        			recipient = res2[0];
			            	        		}
			            	        	}*/
			            	        }
			            	    } else {
			            	    	/*if( recipient.search(" ") != -1 ){
		            	        		var res3 = recipient.split(" ");
		            	        		if( !isNullOrEmpty(res3) && res3.length > 0 ){
		            	        			recipient = res3[0];
		            	        		}
		            	        	}*/
			            	    }
	            				
	                    		for(var recordInt = 1; recordInt < recipientStoreValue.length; recordInt++){
	                    			recipientValue=recipientValue+","+recipientStoreValue[recordInt].data.value;
	                    		}
	                    		recipient=recipientValue;
		            		}
		            		
		            		var contactId=null;
		            		var contactIdValue=null;
		            		var conatactIdAlternateValue=null;
		            		var sentbyName=form.down("#sentby").getValue();
		            		var eventNameCode=form.down("#eventName").getValue();
		            		var eventDateForm=form.down("#eventDateForm").getValue();
		            		var eventDateTill=form.down("#eventDateTill").getValue();
		            		var messageId=form.down("#sendmessageId").getValue();
		            		
		            		if(eventDateForm != null){
		            			eventDateForm= new Date(eventDateForm);
		            			eventDateForm = Ext.Date.format(eventDateForm, 'Y-m-d');
		                          }
		                    
		                    if(eventDateTill != null){
		                    	eventDateTill= new Date(eventDateTill);
		                    	eventDateTill = Ext.Date.format(eventDateTill, 'Y-m-d');
		                          }
		            		//var facultyProfile = this.getStudentprofile();
		            		if(messageId.sendMessage==1){
		            			contactId=form.down("#contactId").getValue();
		            			if(contactId==null){
		            				var contactIdComboStore=form.down("#contactId").getStore();
		            				var storeValue = contactIdComboStore.data.items;
		            				
		            				/*for(var recordInt=1;recordInt<storeValue.length;recordInt++){
		            					contactIdValue = storeValue[recordInt].data.emailId+","
		            					conatactIdAlternateValue=storeValue[recordInt].data.alternateEmailId; 
		            				}*/
		            				
		            				contactIdValue = storeValue[0].data.emailId;
		            				conatactIdAlternateValue=storeValue[0].data.alternateEmailId;
		                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
		                    			contactIdValue=contactIdValue+","+conatactIdAlternateValue+","+storeValue[recordInt].data.emailId;
		                    		}
		                    		contactId=contactIdValue+","+conatactIdAlternateValue;
		                    		}
		            		}else{
		            			contactId=form.down("#mobileId").getValue();
		            			if(contactId==null){
		            				var contactIdComboStore=form.down("#mobileId").getStore();
		            				var storeValue = contactIdComboStore.data.items;
		            				contactIdValue = storeValue[0].data.mobileNumber;
		                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
		                    			contactIdValue=contactIdValue+","+storeValue[recordInt].data.mobileNumber;
		                    		}
		                    		contactId=contactIdValue;
		                    		}
		            		}
		            		if(sentbyName=='%%%'){
		            			sentbyName=null;
		            		}
		            		var store = grid.getStore();
		            		store.getProxy().extraParams = {
		            			deliveryModeId: sendMessage.sendMessage,
		            			recipientName: recipient,
		            			contact:contactId,
		            			sentBy:sentbyName,
		            			eventName:eventNameCode,
		            			fromDate:eventDateForm,
		            			toDate:eventDateTill,
		            			studentFullName:fullName
		            		}
		            		store.load();
		            	}
	            	},
		            'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] communicationhistorylist':{
		            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		            		var messageTemplate = record.get('msgContent');
		            		var $this =this;
		            		if (e.target.tagName == 'A') {
		            			var win = new Ext.Window({
		            				title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
		            				frame: true,
		            				height : 500,
		            				minWidth:200,
		            				autoScroll:true,
		            				modal:true,
		            				html: messageTemplate,
		            			});
		            			var dataIndex = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
		            			if(dataIndex == "attachedDocument"){
		            				$this.openAttachedDocumenLinkstudent(record);
		            			}
		            			else{
		            				$this.openSendMessageReportLink(record);	
		            			}
		            			}
		            	
		            	},
		            	render: function(grid){
	        				var $this = this;
	        				var itemIdPrivilegeNameArray = [{"#exportMessageSentReportItemId" : "EXPORT_REPORTS"}];
	        				this.disableRadioGroupAndOtherPivileges(grid, this.getSTUDENT_PROFILE_COMMUNICATION_HISTORY_PERMISSIONS(),itemIdPrivilegeNameArray);
	        				var exportReport=grid.down("#exportMessageSentReportItemId");
	        				exportReport.setDisabled(true);
	        			}
		            },
		            'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printProfileBtn]': {
		            	click: function(obj) {
		            		$this=this;
		            		$this.printProfileBtnStudent(obj);
		            	}
		            },
		            'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printProfileAndContractDetailsBtn]': {
		            	click: function(obj) {
		            		$this=this;
		            		$this.printProfileAndContractDetailsBtnStudent(obj);
		            	}
		            },
		            'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=createStudentInAlfresco]': {
		            	click: function(){
		            		var grid = this.getSearchResultGrid();
		            		var userIdsArray = [];
		            		var gridRec=grid.getSelectionModel().getSelection();
		            		if (grid.getSelectionModel().getCount() > 0) {
		            			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		            			for( var i = 0; i < gridRec.length; i++) {
		            				userIdsArray.push(gridRec[i].data.USER_ID);
		            			}
		            			Ext.Ajax.request({
		            				type: 'rest',
		            				url: SERVERURL.PATH_CREATE_MULTIPLE_USERS,
		            				method: 'POST',
		            				jsonData : {
		            					userName: userIdsArray.join(),
		            				},
		            				headers : {
		            					'Content-Type' : 'application/json'
		            				},
		            				success: function(response, action) {
		            					Ext.getBody().unmask();
		            					showSuccessMessage(getCommonTranslation('ACTIVATE_BUTTON'), getCommonTranslation('SUCCESS'));
		            				}
		            			});

		            		} else {
		            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            		}  

		            	}},
		            	'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=studentDocumentRequestId]': {
	        	            click: function(obj) {
	        	            	//var grid = this.getSearchResultGrid();
	        	            	this.showStudentRequestDocumentWin();
	        	            	
	        	            }
	        	        },
	        	        'facultyrequestdocumentwidow[itemId=studentrequestdocumentId] button#btnrequest': {
	        	            click: function(obj) {
	        	            	var grid = this.getSearchResultGrid();
	        	            	this.documentRequestStudent();
	        	            	
	        	            }
	        	        },
	        	        'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] customcombobox[itemId=templateTypeId]': {
			            	select:function(obj,record){
			            		var templateTopicName = record[0].get("name");
			            		var form=obj.up('studentacademictopicdownloadform');
			            			}
			            },
				        'studentacademictopicstructure [itemId=templateTypeId]':{
				        	afterrender: function(combo){
				        		var $this = this;
				        		var user=$this.getCurrentlyLoggedInUser();
				        		if(user.code!="sysadmin"){
				        		setTimeout(function(){
				        			var associatedAcadLocationIds = new Array();
					        		associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
					        		var programCompletiondetailImportTab = false;
					        		var importIdentitydocumentLink = false;
					        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getSTUDENT_LIST_PERMISSIONS());
					        		
					        		combo.getStore().on('load', function(record){
                                        var firstArray = ['PROGRAM_COMPLETION_DETAILS', 'IMPORT_IDENTITY_DOCUMENT'];
                                        var secondArray = permissionList;
                                        var thirdArray= [];
                                        Ext.each(firstArray, function(currentItem){
                                            if(secondArray.indexOf(currentItem) == -1){
                                                thirdArray.push(currentItem);
                                            }
                                        });
                                       
                                        Ext.each(thirdArray, function(privilege) {
                                            if (privilege == 'PROGRAM_COMPLETION_DETAILS' || privilege == 'IMPORT_IDENTITY_DOCUMENT') {
                                                var index = record.findExact('permissionKey',privilege)
                                                record.removeAt(index);
                                            }
                                        });
                                    });
								}, 300);
                                }
				        	}
				           },
		            'studentacademictopicdownloadform[itemId=studentacademictopicdownloadformId] customcombobox[itemId=templateTypeId]': {
		            	select:function(obj,record){
		            		var templateTopicName = record[0].get("name");
		            		var form=obj.up('studentacademictopicdownloadform');
		            		var academicSubTopic=form.down('#academicSubTopicItemId');
		            		var programItemId=form.down('#programItemId');
		            		var batchItemId=form.down('#batchItemId');
		            		var periodItemId=form.down('#periodItemId');
		            		var sectionItemId=form.down('#sectionItemId');
		            		var intakeYear=form.down('#intakeYear');
		            		var acdemyLocation=this.getCurrentAcademyLocation();
		            		var serviceNameComboField=form.down('#serviceNameComboField');
		            		var communityNameComboField=form.down('#communityNameComboField');
		            		var academicTopicItemId=form.down('#academicTopicItemId');
		            		var academyLocationCombo=form.down('#academyLocationCombo');
		            		var seatType=form.down('#seatType');
		            		var program=form.down('#multiProgramItemId');
		            		var batch=form.down('#batch');
		            		if(templateTopicName =='AcademicTopics'){
		            			academicSubTopic.setVisible(true);
		            			sectionItemId.setVisible(true);
		            			sectionItemId.setDisabled(true);
		            			intakeYear.setVisible(false);
		            			programItemId.setVisible(true);
		            			batchItemId.setVisible(true);
		            			academyLocationCombo.setVisible(false);
		            			program.setVisible(false);
		            			batch.setVisible(false);
		            			seatType.setVisible(false);
		            			periodItemId.setVisible(true);
		            			academicTopicItemId.setVisible(true);
		            			serviceNameComboField.setVisible(false);
		            			communityNameComboField.setVisible(false);
		            			academicTopicItemId.setDisabled(false);
		            			academicSubTopic.setDisabled(true);
		            			form.getForm().reset();
		            			obj.setValue(templateTopicName);
		            			this.setAllowBlank(academyLocationCombo, true);
		            			this.setAllowBlank(programItemId, false);
		            			this.setAllowBlank(batchItemId, false);
		            			this.setAllowBlank(serviceNameComboField, true);
		            			this.setAllowBlank(academyLocationCombo, true);
		            		}else if(templateTopicName =='Communities'){
		            			academicSubTopic.setVisible(false);
		            			sectionItemId.setVisible(false);
		            			intakeYear.setVisible(true);
		            			programItemId.setVisible(true);
		            			batchItemId.setVisible(true);
		            			academyLocationCombo.setVisible(false);
		            			program.setVisible(false);
		            			batch.setVisible(false);
		            			seatType.setVisible(false);
		            			academicTopicItemId.setVisible(false);
		            			serviceNameComboField.setVisible(false);
		            			communityNameComboField.setVisible(true);
		            			communityNameComboField.setDisabled(false);
		            			periodItemId.setVisible(true);
		            			form.getForm().reset();
		            			obj.setValue(templateTopicName);
		            			batchItemId.setDisabled(true);
		            			periodItemId.setDisabled(true);
		            			this.setAllowBlank(academyLocationCombo, true);
		            			this.setAllowBlank(programItemId, true);
		            			this.setAllowBlank(batchItemId, true);
		            			this.setAllowBlank(serviceNameComboField, true);
		                    	var communityStore = form.getForm().findField('community').getStore();
		                    	communityStore.getProxy().extraParams = {
		                    		academyLocationId : acdemyLocation
								};
		            		}else if(templateTopicName =='Services'){
		            			academicSubTopic.setVisible(false);
		            			sectionItemId.setVisible(false);
		            			intakeYear.setVisible(true);
		            			programItemId.setVisible(true);
		            			batchItemId.setVisible(true);
		            			academyLocationCombo.setVisible(false);
		            			program.setVisible(false);
		            			batch.setVisible(false);
		            			seatType.setVisible(false);
		            			academicTopicItemId.setVisible(false);
		            			serviceNameComboField.setVisible(true);
		            			serviceNameComboField.setDisabled(false);
		            			communityNameComboField.setVisible(false);
		            			periodItemId.setVisible(true);
		            			form.getForm().reset();
		            			obj.setValue(templateTopicName);
		            			batchItemId.setDisabled(true);
		            			periodItemId.setDisabled(true);
		            			this.setAllowBlank(academyLocationCombo, true);
		            			this.setAllowBlank(programItemId, true);
		            			this.setAllowBlank(batchItemId, true);
		            			this.setAllowBlank(serviceNameComboField, false);
		            		}else if(templateTopicName =='OtherInformation'){
		            			academicSubTopic.setVisible(false);
		            			sectionItemId.setVisible(true);
		            			programItemId.setVisible(true);
		            			batchItemId.setVisible(true);
		            			intakeYear.setVisible(false);
		            			academicTopicItemId.setVisible(false);
		            			academyLocationCombo.setVisible(false);
		            			program.setVisible(false);
		            			batch.setVisible(false);
		            			seatType.setVisible(false);
		            			serviceNameComboField.setVisible(false);
		            			serviceNameComboField.setDisabled(false);
		            			communityNameComboField.setVisible(false);
		            			periodItemId.setVisible(true);
		            			form.getForm().reset();
		            			obj.setValue(templateTopicName);
		            			batchItemId.setDisabled(true);
		            			periodItemId.setDisabled(true);
		            			this.setAllowBlank(academyLocationCombo, true);
		            			this.setAllowBlank(intakeYear, true);
		            			this.setAllowBlank(programItemId, false);
		            			this.setAllowBlank(batchItemId, true);
		            			this.setAllowBlank(serviceNameComboField, true);
		            		}else if(templateTopicName =='ProgramCompletionDetails'){
		            			academicSubTopic.setVisible(false);
		            			sectionItemId.setVisible(false);
		            			programItemId.setVisible(true);
		            			batchItemId.setVisible(true);
		            			intakeYear.setVisible(false);
		            			academyLocationCombo.setVisible(false);
		            			program.setVisible(false);
		            			batch.setVisible(false);
		            			seatType.setVisible(false);
		            			academicTopicItemId.setVisible(false);
		            			serviceNameComboField.setVisible(false);
		            			serviceNameComboField.setDisabled(false);
		            			communityNameComboField.setVisible(false);
		            			periodItemId.setVisible(false);
		            			form.getForm().reset();
		            			obj.setValue(templateTopicName);
		            			batchItemId.setDisabled(true);
		            			periodItemId.setDisabled(true);
		            			this.setAllowBlank(academyLocationCombo, true);
		            			this.setAllowBlank(intakeYear, true);
		            			this.setAllowBlank(programItemId, false);
		            			this.setAllowBlank(batchItemId, false);
		            			this.setAllowBlank(serviceNameComboField, true);
		            		}else if(templateTopicName =='IdentityDocument'){
		            			academicSubTopic.setVisible(false);
		            			sectionItemId.setVisible(false);
		            			intakeYear.setVisible(false);
		            			programItemId.setVisible(false);
		            			batchItemId.setVisible(false);
		            			academyLocationCombo.setVisible(true);
		            			seatType.setVisible(true);
		            			program.setVisible(true);
		            			batch.setVisible(true);
		            			academicTopicItemId.setVisible(false);
		            			serviceNameComboField.setVisible(false);
		            			serviceNameComboField.setDisabled(false);
		            			communityNameComboField.setVisible(false);
		            			periodItemId.setVisible(false);
		            			form.getForm().reset();
		            			obj.setValue(templateTopicName);
		            			batchItemId.setDisabled(true);
		            			periodItemId.setDisabled(true);
		            			seatType.setDisabled(true);
		            			program.setDisabled(true);
		            			batch.setDisabled(true);
		            			this.setAllowBlank(academyLocationCombo, false);
		            			this.setAllowBlank(intakeYear, true);
		            			this.setAllowBlank(programItemId, true);
		            			this.setAllowBlank(program, true);
		            			this.setAllowBlank(batch, true);
		            			this.setAllowBlank(batchItemId, true);
		            			this.setAllowBlank(seatType, true);
		            			this.setAllowBlank(serviceNameComboField, true);
		            			var userId = this.getCurrentlyLoggedInUser().id;
                                var currentAcademyLocation=this.getCurrentAcademyLocation();
                                var store = academyLocationCombo.getStore();
                                store.getProxy().extraParams = {
                                    id: userId
                                };
                                store.load({
                                    callback: function(record){
                                        academyLocationCombo.setValue(currentAcademyLocation);
                                    }
                                });
		            		}
		            	}
		            },
		            
		            'studentacademictopicuploadform customcombobox[itemId=templateTypeId]': {
		            	select:function(obj,record){
		            		$this = this;
		            		var templateTopicName = record[0].get("name");
		            		var form =obj.up('studentacademictopicuploadform').getForm();
		            		var combo = form.findField('importUtilityMasterId');
		            		combo.getStore().load({
		            			callback: function(records, operation, success) {
		            				for(var i in records){
		            					if(templateTopicName =='AcademicTopics' && records[i].data.value=='Bulk Student Academic Topic'){
		            						combo.setValue(records[i].data.id);
		            					}
		            					if(templateTopicName =='Communities' && records[i].data.value=='Bulk Student Community'){
		            						combo.setValue(records[i].data.id);
		            					}
		            					if(templateTopicName =='Services' && records[i].data.value=='Bulk Student Service'){
		            						combo.setValue(records[i].data.id);
		            					}
		            					if(templateTopicName =='OtherInformation' && records[i].data.value=='Bulk Student Other Information'){
		            						combo.setValue(records[i].data.id);
		            					}
		            					if(templateTopicName =='ProgramCompletionDetails' && records[i].data.value=='Program Completion Details'){
		            						combo.setValue(records[i].data.id);
		            					}
		            					if(templateTopicName =='IdentityDocument' && records[i].data.value=='Bulk Student Identity Document'){
		            						combo.setValue(records[i].data.id);
		            					}
		            					combo.setReadOnly(true);
		            				}
		            			}	   
		            		});
		            		var grid = $this.getImportstudentacademictopiclist();
		            		var form = $this.getStudentAcademicTopicuploadoptionradiogroup();
		            		var isUploadAll = form.items.items[0].getValue().isUploadAll;
		            		if(templateTopicName == 'AcademicTopics'){
		            			this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_STUDENT_ACADEMIC_TOPIC_UPLOAD');
		            		}else if(templateTopicName == 'Communities'){
		            			this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_COMMUNITY');
		            		}else if(templateTopicName == 'Services'){
		            			this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_SERVICE');
		            		} else if(templateTopicName == 'OtherInformation'){
		            			this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_STUDENT_OTHER_INFORMATION');
		            		}else if(templateTopicName == 'ProgramCompletionDetails'){
		            			this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_PROGRAM_COMPLETION_DETAILS');
		            		}
		            		else if(templateTopicName == 'IdentityDocument'){
		            			this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_IDENTITY_DOCUMENT');
		            		}
		            	}
		            },
		            'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=deleteStudentListBtn]': {
		                click: function(){
		                	this.deleteSelectedStudents(true);
		                }
		            },
		            'searchresultgrid[itemId=StudentSearchResultGrid] button[itemId=makeActiveBtn]': {
		                click: function(){
		                	this.MakeActiveSelectedStudents(true);
		                }
		            },
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printLabelsBtn]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.showStudentBulkPrintLabelsWin();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}
        	            }
        	        },
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=printTaxCertificate]': {
        	            click: function(obj) {
        	            	var grid = this.getSearchResultGrid();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		this.showStudentTaxCertificateWindowWin();
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}
        	            }
        	        },
        	        
        	        'studentbulkprintlabelswidow button#btnPrint': {
        	        	click: function(button) {
        	        		var grid = this.getSearchResultGrid();
        	        		this.exportPrintLabelsJRXML('pdf',grid);
            			}
        	        },
        	        'studentprintprofilewindow button#btnPrint': {
        	        	click: function(button) {
        	        		this.exportProfilePrintReport(button);
            			}
        	        },
        	        'studentprinttaxcertificate button#btnPrint': {
        	        	click: function(button) {
        	        		var grid = this.getSearchResultGrid();
        	        		this.exportPrintCertificateJRXML('pdf',grid);
            			}
        	        },
        	        'studentprinttaxcertificate button#cancelButton': {
        	        	click: function(button) {
        	        		var $this=this;
        	        		var formWindow = $this.getStudentprinttaxcertificate();
        	            	if (!formWindow) {
        	            		Ext.widget('studentprinttaxcertificate');
        	            		formWindow = $this.getStudentprinttaxcertificate();
        	            		
        	            	}
        	            	formWindow.close();
            			}
        	        },
    	            'offerletterdetailswindow[itemId=studentofferletterdetailswindow] grid[itemId=offerLetterDetailsGrid]':{   
    	    			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
    	    				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
    	    				   if(columnName == "fileName"){
    	             			   if(e.target.tagName=='A'){
    	             				 // if(record.data.fileName.length == 1){
    	       						   var csvForm = Ext.create('Ext.form.Panel'); 
    								   csvForm.getForm().submit({
    									   target: '_blank',
    									   method:'GET',
    									   params :{
    										   access_token : Ext.Ajax.defaultHeaders.access_token
    									   },
    									   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    									   url: SERVERURL.PATH_DOWNLOAD_OFFER_LETTER_ISSUED +'/'+record.data.id,
    									   standardSubmit :true
    								   });
    	             				 // }
    	             			   }
    	    				   }
    	    			   }
    	    		   },
    	    		   'certificateselectionwindow[itemId=studentListCertificateSelectionWindow]':{
    	    			   render: function(form) {
    	   	    			this.disablePrintAsWordFilePivileges(form, this.getSTUDENT_CERTIFICATE_PRINTAS_WORDFILE_PERMISSIONS());
    	   	    		} 
    	    		   },
    	    		   
    	               'sendmessageattacheddocumentwin[itemId=studentsendmessageItemId] grid[itemId=sendMessageDocumentGridItemId]': {
    	               	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	                       var $this = this;
    	                       var grid = $this.getSendmessageattacheddocumentwin().down('#sendMessageDocumentGridItemId');
    	                       var columnName = grid.columnManager.columns[cellIndex].dataIndex;
    	                       if (columnName == "name") {
    	                           if (e.target.tagName == 'A') {
    	                               var documentId = record.get("id");
    	                               if (!isNullOrEmpty(documentId)) {
    	                               	var isWhetherSysMsgEvent = false;
    	                             	 var staticDocOfMSR  = record.get("staticDocOfMSR");
    	                               	var gridMessageList = $this.getCommunicationhistorylist();
    	                               	if(gridMessageList.getSelectionModel().getCount()>0){
    	                               		var recordList = gridMessageList.getSelectionModel().getSelection();
    	                               		var eventName = recordList[0].get('eventName');
    	                               		if(!isNullOrEmpty(eventName)){
    	                               			isWhetherSysMsgEvent = true;
    	                               		}
    	                               		if(isNullOrEmpty(staticDocOfMSR)){
    	                               			staticDocOfMSR =  false;
    	                               		}
    	                               		
    	                               	}
    	                                   $this.downloadAttachedDocumentFile(documentId,isWhetherSysMsgEvent,staticDocOfMSR);
    	                               }
    	                           }
    	                       }
    	                   }
    	               },
    	               'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] button[itemId=exportMessageSentReportItemId]':{
		            	click: function(){
		            		this.exportXlsMsgSentReport();
		            		
		            	}
		            },
		            'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] datefield[itemId=eventDateForm]':{
		            	select : function(field, value, eOpts){
		            		this.studentcheckSelectDate();

		            	}
		            },
		            'communicationhistorystructure[itemId=studentcommunicationhistorystructureItemId] datefield[itemId=eventDateTill]':{
		            	select : function(field, value, eOpts){
		            		this.studentcheckSelectDate();

		            	}
		            },		           
		            'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=studentSendMSGToAllBtn]': {
		            	click: function(){
		            		var grid = this.getSearchResultGrid();
		        	    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
		        	    		
		        	    			var $this=this;
		        	    			var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		        	    	       	   var structure = Ext.widget('studentsendmessages',{
		                       			itemId:'studentListSendMessageWindows'
		                       		});
		        	    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
		        	    	       	   /**
		        	    	       	    * This is to remove tab from content panel and open same tab again
		        	    	       	    */
		        	    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
		        	    	       	   var getTab=getcontroller.getTab(tabName);
		        	    	       	   if(getTab!=null){
		        	    	       		   contentPanel.remove(getTab, true);
		        	    	       	   }
		        	    	       	var formWindowTab = $this.getStudentsendmessages();
		        	    	       	var sendMessageLable = formWindowTab.down("#sendMsgCountItemId");
		        	    	       	sendMessageLable.setVisible(true);
		        	    	       	var totalRecord = grid.getStore().totalCount;
		        	    	       	if (totalRecord > 1) {
		        	    	       		sendMessageLable.setText(totalRecord+' '+getCommonTranslation('STUDNETS_SEND_MESSAGE_COUNT'));	
									}else{
										sendMessageLable.setText(totalRecord+' '+getCommonTranslation('STUDNET_SEND_MESSAGE_COUNT'));
									}
		        	    	       	
		        	    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
		        	    	       	formWindowTab.down("#selectTemplate").setVisible(false);
		        	    	       	formWindowTab.down("#messageName").allowBlank=true;   
		        	    	       	formWindowTab.down("#messageName").setVisible(false);
		        	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
		        	    			templateStore.getProxy().extraParams={
		        	    				msgRecipientTypeId:2
		        	    			};
		        	    			templateStore.load();
		        	    			
		        	    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		        	    			   Ext.Ajax.request({
		        	    				   method : "GET",
		        	    				   type : 'rest',
		        	    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
		        	    				   headers : {
		        	    					   'Content-Type' : 'application/json'
		        	    				   },
		        	    				   success : function(form,action) {
		        	    					   var data = Ext.JSON.decode(form.responseText);
		        	    					   formWindowTab.down("#id").setValue(data.id);
		        	    					   formWindowTab.down("#code").setValue(data.code);
		        	    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
		        	    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
		        	    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
		        	    					   Ext.getBody().unmask();
		        	    					   
		        	    					   //grid.getStore().reload();
		        	    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
		        	    				   }

		        	    			   });
		        	    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_SEVEN);
					      	//$this.openStudentSendMessage();
		            	},
		            	
        	        },
        	        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=thesisNominationBtn]': {
		            	click: function(){
		            		var $this=this;
		            		var thesisController = Academia.app.getController('Academia.controller.examinationcenters.thesisManagement.thesisManagementController');
		            		var academyLocationId =$this.getCurrentAcademyLocation();
		            		var grid = $this.getSearchResultGrid();
		            		if (grid.getSelectionModel().getCount() == 1 ) {	
		            			var formWindow = this.getEditthesismanagementformwin();
		            			var $this=this;
		            			if (!formWindow) {
		            				formWindow = Ext.widget('editthesismanagementformwin', {
		            					itemId: 'editthesismanagementForStudentModuleformwinItemId'
		            				});
		            			}
		            			formWindow.show();
		            			
		            			var records = grid.getSelectionModel().getSelection();
								var id = records[0].data.id;
								var studentName = records[0].data.FIRST_NAME+" "+records[0].data.LAST_NAME;
								var admissionId = records[0].data.ADMISSION_ID;
								var programId = records[0].data.PROGRAM_ID;
								//var programName = records[0].data.PROGRAM_NAME;
								var batchId = records[0].data.PROGRAM_BATCH_ID;
								//var batchName = records[0].data.BATCH_NAME;
								Ext.Ajax.request({
									type : 'rest',
									url : SERVERURL.PATH_FIND_PERIODID_AND_ACADEMICTERMID,
									params : {
										batchId : batchId,
										admissionId : admissionId
									},
									method : 'GET',
									success : function(response) {
										var data = Ext.decode(response.responseText);
										var academicTerm = formWindow.down('#academicTermId');
										if(data.academicTermId !=null){
			        						academicTerm.store.load({
			        							callback : function(records,operation,success) {
			        								if (success) {
			        									academicTerm.setValue(data.academicTermId);
			        								}
			        							}
			        						});
			        					} 
										
										var admission = formWindow.down('#admissionId');
										if(!isNullOrEmpty(data.studentId)){
			    							var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
			    							var studentStore = admission.getStore();
			    							studentStore.getProxy().api.read=submitURL;
			    							studentStore.getProxy().extraParams = {
			    								academyLocationIds :academyLocationId,
			    								academicTermId:data.academicTermId,
			    								whetherShowWithAdmissionCode:true
			    								
			    							};
			    							studentStore.load({
			        							callback : function(records,operation,success) {
			        								if (success) {
			        									admission.setValue(data.studentId);
			        								}
			        							}
			        						});
			    						}
										var program = formWindow.down('#programId');
										if(!isNullOrEmpty(programId)){
			        						var programComboStore = program.getStore();
			        						programComboStore.getProxy().extraParams = {
			        							academyLocationIds : academyLocationId,
			        							academicTermId : data.academicTermId
			        						};
			        						programComboStore.load({
			        							callback : function(records,operation,success) {
			        								if (success) {
			        									program.setValue(parseInt(programId));
			        								}
			        							}
			        						});
			        						
			        					}
										
										var batch = formWindow.down('#batchId');
										batch.setValue(batchId);
										if(!isNullOrEmpty(batchId)){
			        						var batchStore = batch.getStore();
			    							batchStore.getProxy().extraParams = {
			    								programId: programId,
			    								academicTermId:data.academicTermId,
			    								onlyCurrentRecords:false
			    							}
			    							batchStore.load({
			        							callback : function(records,operation,success) {
			        								if (success) {
			        									batch.setValue(parseInt(batchId));
			        								}
			        							}
			        						});
			        					}
										formWindow.down('#periodId').setValue(data.periodId);
										academicTerm.setReadOnly(true);
		        						admission.setReadOnly(true);
		        						program.setReadOnly(true);
		        						batch.setReadOnly(true);
		        						formWindow.down('#SubmitBtn').show();
									}
								});
		            	} else if (grid.getSelectionModel().getCount() > 1) {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); //Please select a record.
						} else{
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
						}
		            	}
		            	
        	        },
        	        'editthesismanagementformwin[itemId=editthesismanagementForStudentModuleformwinItemId] button[itemId=SubmitBtn]' : {
    					click : function(btn) {
    						var form=btn.up('form');
    						this.saveUpdateThesisMangement(form);
    						
    					}
    				},
    				 'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=applyHoldBtn]': {
                  	   click: function(obj) {
                  		   var grid = this.getSearchResultGrid();
                  		   if (grid.getSelectionModel().getCount() > 0) {
                  			   var this$ = this;
                  			   var window = this$.getStudentlistapplyholds();
                  			   if(window==undefined){
                  				   window =Ext.widget('studentlistapplyholds',{
                    		    			itemId:'studentlistapplyholdItemId'
                    		    		});
                  			   }
                  			
                  			 window.show();
                 	    
                  		   } else {
                  			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                  		   }  
                  	   }
                     }, 
                     
                     'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=applyForHostelBtn]': {
                    	   click: function(obj) {
                    		   var $this=this;
                    		   if($this.getCurrentLoggedPortalId() == 1){
                    			   var grid = $this.getSearchResultGrid();
                    			   var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                    			   if (grid.getSelectionModel().getCount() ==1) {
                    				   var studentPortalController  = this.getController('Academia.controller.personinfo.common.PersonServiceController');

                    				   Ext.Ajax.request({
                    					   method : "GET",
                    					   type : 'rest',
                    					   scope:$this,
                    					   url: SERVERURL.PATH_FIND_ACTIVE_SETUP_FOR_STUDENT_GENERAL_LIST_STUDENT_LIST,
                    					   params: {
                    						   studentId : studentId,
                    						   portalId : 1
                    					   },
                    					   headers : {
                    						   'Content-Type' : 'application/json'
                    					   },
                    					   success: function(response) {
                    						   var data = Ext.decode(response.responseText);
                    						   if(!isNullOrEmpty(data.hostelSetupId)){
                    							   studentPortalController.showPersonCommonWindow('APPLY_FOR_HOSTEL', 'applyforhostelform');
                    						   }else{
                    							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOSTEL_SETUP_NOT_MAPPED'));
                    						   }

                    					   }
                    				   });



                    			   } else {
                    				   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                    			   }  
                    		   }
                    	   }
                       }, 
                       'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=applyForHostelWaitingListBtn]': {
                    	   click: function(obj) {
                    		   var $this=this;
                    			   var grid = $this.getSearchResultGrid();
                    			   if (grid.getSelectionModel().getCount() ==1) {
                    				   var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                    				   var studentPortalController  = this.getController('Academia.controller.personinfo.common.PersonServiceController');
                    				   Ext.Ajax.request({
                    					   method : "GET",
                    					   type : 'rest',
                    					   url: SERVERURL.PATH_FIND_WAITING_LIST_SETUP_FOR_STUDENT,
                    					   params: {
                    						   studentId : studentId
                    					   },
                    					   headers : {
                    						   'Content-Type' : 'application/json'
                    					   },
                    					   success: function(response) {
                    						   var data = Ext.decode(response.responseText);
                    						   if(data){
                    							   studentPortalController.showPersonCommonWindow('APPLY_FOR_WAITING_LIST', 'applyforwaitinglistformStudentList');
                    						   }else{
                    							   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('HOSTEL_SETUP_NOT_MAPPED'));
                    						   }
                    					   }
                    				   });
                    			   } else {
                    				   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                    			   }  
                    	   }
                       },
                       'applyforhostelform[itemId=applyforwaitinglistformStudentList] button#applyforhostelCancelButtonId' : {
                    	   click: function(obj) {
                    		   var studentPortalController  = this.getController('Academia.controller.personinfo.common.PersonServiceController');
                    		   studentPortalController.closePersonCommonWindow();
                    	   }
                        },
                       'applyforwaitinglistform[itemId=applyforwaitinglistformStudentList] button#applyforhostelCancelButtonId' : {
                    	   click: function(obj) {
                    		   var studentPortalController  = this.getController('Academia.controller.personinfo.common.PersonServiceController');
                    		   studentPortalController.closePersonCommonWindow();
                    	   }
                        },
                       'applyforwaitinglistform[itemId=applyforwaitinglistformStudentList] button[itemId="submitButtonId"]':{
                    	   click:function(btn){
                    		   var this$ = this;
                    		   var form =  btn.up('applyforwaitinglistform');
                    		   var academyLocationId = this$.getCurrentAcademyLocation();
                    		   var grid = this$.getSearchResultGrid();
                			   var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                    		   var hostelId = form.down("#hostelChoicesIDItem");
                    		   var reallocationId = form.down("#reallocationHostelId");
                    		   var studentPortalController  = this$.getController('Academia.controller.personinfo.common.PersonServiceController');
                    		   var jsonData = {
                    			   "student":{
                    				   "id":studentId
                    			   },
                    			   "academyLocation":{
                    				   "id":academyLocationId
                    			   },
                    			   "isReallocateSameHostel":reallocationId.getValue(),
                    			   "resource":{
                    				   "id":hostelId.getValue()
                    			   },
                    			   "hostelApplicationType":'WAITING_LIST_SETUP'
                    		   }

                    		   Ext.Ajax.request({
                    			   method: "POST",
                    			   type: 'rest',
                    			   url: SERVERURL.PATH_SAVE_FOR_HOSTEL_APPLICATION,
                    			   jsonData: Ext.encode(jsonData),
                    			   success : function(response) {
                    				   var data = Ext.decode(response.responseText);
                    				   //applyForWaitingList = true
                    				   //this$.getPersonCommonWindow().close();
                            		   studentPortalController.closePersonCommonWindow();
                    				   //grid.getStore().load();
                    				   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('HOSTEL_APPLICATION_SUBMITTED_SUCCESSFULLY'));
                    			   },
                    			   failure: function(result, request) {
                    				   //applyForWaitingList = true
                            		   studentPortalController.closePersonCommonWindow();
                    				   //this$.getPersonCommonWindow().close();
                    			   }
                    		   });	
                    	   }
                       },
                       'applyforwaitinglistform[itemId=applyforwaitinglistformStudentList] customcombobox[itemId="hostelChoicesIDItem"]':{
                    	   afterrender:function(cmp){
                    		   var grid = this.getSearchResultGrid();
                			   var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                    		   var  hostelChoicesStore = cmp.getStore();
                    		   cmp.store.removeAll();
                    		   hostelChoicesStore.on('beforeload',function() {
                    			   hostelChoicesStore.proxy.extraParams = {
                        				   studentId:studentId
                        		   };
                    		   }, this);
                    	   }
                       },
                       'applyforhostelform displayfield[itemId="termsAndConditionsLinkItemId"]':{
                  		 render: function(component) {
                  			 var $this=this;
                  			 component.getEl().on('click', function(e) {
                  				 var portalId = $this.getCurrentLoggedPortalId();
                  				 if(portalId==1){
                  					 if(e.target.tagName=='A'){
                  						var grid = $this.getSearchResultGrid();
                         			   var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
//                  						 var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
//                  						 var studentId=studentPortalInfo.student.id;
                  						 Ext.Ajax.request({
                  							 method : "GET",
                  							 type : 'rest',
                  							 url: SERVERURL.FIND_DOCUMENT_PATH_GENERAL_SETUP,
                  							 params: {
                  								 studentId : studentId,
                  							 },
                  							 headers : {
                  								 'Content-Type' : 'application/json'
                  							 },
                  							 success: function(response) {
                  								 var data = response.responseText;
                  								 if(!isNullOrEmpty(data)){
                  					    				var path = data;
                  					    	       		var csvForm = Ext.create('Ext.form.Panel'); 
                  					    				if (!isNullOrEmpty(path)) {
                  					    					csvForm.getForm().submit({
                  												   target: '_blank',
                  												   method:'POST',
                  												   params :{
                  													   access_token : Ext.Ajax.defaultHeaders.access_token,
                  													   path: path
                  												   },
                  												   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                  												   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
                  												   standardSubmit :true
                  											   });
                  										}
                  								 }else{
                  									 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_MAPPED')); 
                  								 }
                  							 }
                  						 });
                  					 }
                  				 }
                  			 });
                  		 }
                        },
                       
                       
                       'applyforhostelform button#submitButtonId' : {
                    	   click:function(btn){
                    		   var $this=this;
                    		   if($this.getCurrentLoggedPortalId() == 1){
                    			   var grid = $this.getSearchResultGrid();
                    			   var studentPortalController  = $this.getController('Academia.controller.personinfo.common.PersonServiceController');
                    			   var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                    			   var portalId = $this.getCurrentLoggedPortalId();
                    			   var form =  btn.up('applyforhostelform');
                    			   var academyLocationId = $this.getCurrentAcademyLocation();
                    			   var jsonFormFieldData = form.getValues();

                    			   var jsonData = {
                    					   "student":{
                    						   "id":studentId
                    					   },
                    					   "academyLocation":{
                    						   "id":academyLocationId
                    					   },
                    					   "isReallocateSameHostel":jsonFormFieldData.reallocationHostelId,
                    					   "resource":{
                    						   "id":jsonFormFieldData.hostelChoices
                    					   },
                    					   "hostelApplicationType":'HOSTEL_GENERAL_SETUP',
                    					   "portalId":1

                    			   }

                    			   Ext.Ajax.request({
                    				   method: "POST",
                    				   type: 'rest',
                    				   url: SERVERURL.PATH_SAVE_FOR_HOSTEL_APPLICATION,
                    				   jsonData: Ext.encode(jsonData),
                    				   success : function(response) {
                    					   var data = Ext.decode(response.responseText);
                    					   studentPortalController.getPersonCommonWindow().close();
                    					   showSuccessMessage(getCommonTranslation('HOSTEL_GENERAL_APPLICATION'),getCommonTranslation('HOSTEL_GENERAL_APPLICATION_SUBMITTED_SUCCESSFULLY'));
                    				   },
                    				     failure: function(result, request) {
                    					                          studentPortalController.getPersonCommonWindow().close();
                    					                       }
                    			   });	


                    		   }
                       }
                   
                    },
                       
                       'applyforhostelform':{
                   		afterrender:function(obj,rec){
                   			var $this=this;
                   			if($this.getCurrentLoggedPortalId() == 1){
                   				var grid = $this.getSearchResultGrid();
                   				var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                   				var hostelChoices =obj.down('#hostelChoicesID');
                   				var reallocationHostelId=obj.down('#reallocationHostelId');
                   				var   hostelChoicesStore = hostelChoices.getStore();
                   				hostelChoicesStore.proxy.extraParams = {
                   						                studentId:studentId,
                   						portalId:1
                   						                        };
                   				hostelChoicesStore.load({
                   					callback: function(records, operation, success) {
                   						if(records.length==1 &&  records[0].data.displayOtherLanguage=="CHECKED_IN"){
                   							reallocationHostelId.setVisible(false);
                   						}
                   					} 
                   				});
                   			}

                   		},
                   		render:function(obj,rec){
                   			var $this=this;
                   			if($this.getCurrentLoggedPortalId() == 1){
                   				var grid = $this.getSearchResultGrid();
                   				var studentId=grid.getSelectionModel().getSelection()[0].data.ID;
                   				var reallocationHostelId=obj.down('#reallocationHostelId');
                   				Ext.Ajax.request({
                   					method : "GET",
                   					type : 'rest',
                   					scope:$this,
                   					url: SERVERURL.PATH_FIND_CHECKED_IN_STATUS_BY_STUDENT_ID,
                   					params: {
                   						studentId : studentId,
                   						portalId : 1
                   					},
                   					headers : {
                   						'Content-Type' : 'application/json'
                   					},
                   					success: function(response) {
                   						var data = Ext.decode(response.responseText);
                   						if(!isNullOrEmpty(data.id)){
                   							reallocationHostelId.setVisible(true);
                   						}else{
                   							reallocationHostelId.setVisible(false);
                   						}

                   					}
                   				});

                   			}
                       }

                   	},
                     
                     'studentlistapplyholds[itemId=studentlistapplyholdItemId]  combo[itemId=applyById]':{
           			   render: function(obj){
         				   var this$=this;
         				   var store = obj.getStore();
         				   store.getProxy().extraParams = {
         					   academyLocationIds:this.getCurrentAcademyLocation()
         				   };
         				   store.load();
         				  var formWindow = this$.getStudentlistapplyholds();
         				   var userId=this.getCurrentlyLoggedInUser();
         				   var applyById = formWindow.down("#applyById");
         				  applyById.store.load({
         					   callback : function(operation,success) {
         						   if (success) {
         							  applyById.setValue(userId.id);
        			    				}
        			    			} 
        			    		});
         			   }
         		   },
         		   'studentlistapplyholds[itemId=studentlistapplyholdItemId]  combo[itemId=holdCatStudent]': {
         	          	 select:function(obj1,records) {
         	             	 var subHoldCatStudent = obj1.up('form').down('customcombobox#subHoldCatStudent');
         	             	 var applyHoldAt = obj1.up('form').down('#applyHoldAtList');
         	             	     applyHoldAt.reset();
         	                     subHoldCatStudent.reset();
         	                    subHoldCatStudent.setDisabled(false);
         	                var armsOfServiceIdVal = records[0].get("id");
         	                var subHoldCatStudentStore = subHoldCatStudent.getStore();
         	                subHoldCatStudentStore.getProxy().extraParams = {
         	               	 holdCategoryId: armsOfServiceIdVal
         	                };
         	                subHoldCatStudentStore.reload();
         	             	 }
         	             }, 
         	            'studentlistapplyholds[itemId=studentlistapplyholdItemId] button[itemId=submitButtonId]' : {
        					click : function(btn) {
        						var form=btn.up('form');
          						this.saveStudentApplyHold(form)
        					}
        				},
        				  'studentlistapplyholds combo#subHoldCatStudent': {
        		                select: function(combo, record) {
        		                	var form = this.getStudentlistapplyholds();
        		            		this.setApplyHoldAtOnApplyHoldWindowOnStudentList(form);
        		                }
        		         },
        				 'studentlistapplyholds[itemId=studentlistapplyholdItemId] button[itemId=cancelButtonId]' : {
         					click : function(btn) {
         						var form=btn.up('form');
           						this.getStudentlistapplyholds().close();
         					}
         				},
         				 'aggregationstabstructure radiogroup[itemId=importDownloadgroupId]':{
          	 			   change: this.studentImportAgrregationDownloadUploadFormChange
          			   },
          			   'studentsendmessages[itemId=studentListSendMessageWindows] button[itemId=generateEmailBtn]': {
          				   click: this.generateAIEmail
          			   },
          			   'studentsendmessages[itemId=studentListSendMessageWindows] textfield[itemId=subject]': {
          				   change: this.validateSubject
          			   },
				        'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=pandaDocItemId]': {
				        	click: this.openPandaDocPopup
				        },
				        'changeseattype button#saveBtn': {
		                	   click: function(obj) {
		                		   var form=obj.up('form');
		   						   var grid = this.getSearchResultGrid();
		     						this.saveChangeSeatType(form,grid);		                	   }
		                   },
		               	'changeseattype customcombobox#changeSeatTypeItemID':{
		    				afterrender: function(cmb){
		    					var store = cmb.getStore();
		                		var grid = this.getSearchResultGrid();
			                   	var batchId=grid.getSelectionModel().getSelection()[0].data.PROGRAM_BATCH_ID;
			                   	var seatType=grid.getSelectionModel().getSelection()[0].data.SEAT_TYPE;
			                	store.proxy.extraParams = {
			                   			batchId:batchId
			  					};
			                   	store.on('load', function(){
                                    var storeItems = store.getRange();
                                    var record = store.findRecord('code',seatType);
                                    store.clearFilter();
    			                	store.filterBy(function(record, id){
    			                		if(record.get('code') == seatType){
    			                			return false;
    			                		}else{
    			                			return true;
    			                		}
    								});
                                 });
		    				}
		    			},
          			  'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=changeSeatTypeId]': {
                   	   click: function(obj) {
               		   var grid = this.getSearchResultGrid();
               		   if (grid.getSelectionModel().getCount() > 0) {
               			   var this$ = this;
               			   var window = this$.getChangeseattype();
               			   if(!window){
               				   window = Ext.widget('changeseattype');
               			   }
               		
               			var popupContent = window.down('#popupContentItemId');

	                    resultMsg1 = getCommonTranslation('IMPORTANT_NOTE');
	                    resultMsg2 = getCommonTranslation('INSTRUCTION_ONE');
	                    resultMsg3 = getCommonTranslation('INSTRUCTION_ONE_SECOND_PART');
	                    resultMsg4 = getCommonTranslation('INSTRUCTION_TWO');
	                    resultMsg5 = getCommonTranslation('INSTRUCTION_TWO_SECOND_PART');
	                    resultMsg6 = getCommonTranslation('INSTRUCTION_THREE');
	                    resultMsg7 = getCommonTranslation('INSTRUCTION_FOUR');

                        var value =  "<h3><b>" + resultMsg1 + "</b></h3>" + "<b>" + resultMsg2+ "</b><br/><b>" + resultMsg3+ "</b><br/><b>" + resultMsg4 + "</b><br/><b>" + resultMsg5 + "</b><br/><b>" + resultMsg6 + "</b><br/><b>" + resultMsg7 + "<b>";
                        value =value+ "<br/>";
                        popupContent.setValue(value);

               			   window.show();
               			   	                   	
                 		   } else {
               			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
               		   }  
               	   },
              
               	
          },
                  'changeseattype customcombobox[itemId=seatTypeId]': {
                      render: function(combo) {
                     	var grid = this.getSearchResultGrid();
                     	var record = grid.getSelectionModel().getSelection();
                     	var batchId = record[0].data.PROGRAM_BATCH_ID;   
                      var store = combo.getStore();
                      
                 		store.getProxy().extraParams = {
                 			batchId: batchId
                 		};
                 	 var arrayOfKeys =store.data.keys;
                   Ext.Array.remove(arrayOfKeys, store.data.items[0].raw.id);
                        }
                    },
                    'studentstatusdownloadform customcombobox[itemId=programItemId]':{
                    	render : function(combo){
                    		var academyLocationId = this.getCurrentAcademyLocation();
                    		var store = combo.getStore();
                    		store.proxy.extraParams = {
                    				academyLocationId : academyLocationId
                    		};
                    		store.load();
                    	},
                    	select:function(obj,record){
                    		var downloadForm = this.getStudentstatusdownloadform();
                    		var programId = record[0].get("id");
                    		var batchCombo = downloadForm.down('#batchItemId');
                    		var  periodCombo = downloadForm.down('#periodItemId');
                    		var  sectionCombo = downloadForm.down('#sectionItemId');

                    		batchCombo.setDisabled(false);
                    		batchCombo.reset();

                    		periodCombo.setDisabled(true);
                    		periodCombo.reset();

                    		sectionCombo.setDisabled(true);
                    		sectionCombo.reset();

                    		var store = batchCombo.getStore();

                    		store.proxy.extraParams = {
                    				id : programId
                    		};
                    		store.load();
                    	}
                    },
                    'studentstatusdownloadform customcombobox[itemId=batchItemId]':{
                    	select:function(obj,record){
                    		var downloadForm = this.getStudentstatusdownloadform();
                    		var batchId = record[0].get("id");
                    		var batchCombo = downloadForm.down('#batchItemId');
                    		var  periodCombo = downloadForm.down('#periodItemId');
                    		var  sectionCombo = downloadForm.down('#sectionItemId');

                    		periodCombo.setDisabled(false);
                    		periodCombo.reset();

                    		sectionCombo.setDisabled(true);
                    		sectionCombo.reset();

                    		var store = periodCombo.getStore();

                    		store.proxy.extraParams = {
                    				id : batchId
                    		};
                    		store.load();
                    	}
                    },
                    'studentstatusdownloadform customcombobox[itemId=periodItemId]':{
                    	select:function(obj,record){
                    		var downloadForm = this.getStudentstatusdownloadform();
                    		var periodId = record[0].get("id");
                    		var  periodCombo = downloadForm.down('#periodItemId');
                    		var  sectionCombo = downloadForm.down('#sectionItemId');

                    		sectionCombo.setDisabled(false);
                    		sectionCombo.reset();

                    		var store = sectionCombo.getStore();

                    		store.proxy.extraParams = {
                    				periodId : periodId
                    		};
                    		store.load();
                    	}
                    },
                    'studentstatusdownloadform button[itemId=addMoreRowBtn]':{
                    	click: function(obj){
                    		this.addMoreRowsForPBPS(obj);
                    	}
                    },
                    'studentstatusdownloadform button[itemId=resetBtn]':{
                    	click: function(obj){
             				var form = this.getStudentstatusdownloadform();
             				var pbpsContiner = form.down('#programBatchContainerId');
             				var newcont=pbpsContiner.items.items.length;
             				for(var i=newcont;i>0;i--){
             					pbpsContiner.remove(pbpsContiner.items.items[i]);
             				}
             				form.doLayout();
             				form.getForm().reset();
             				form.down('#batchItemId').setDisabled(true);
             				form.down('#periodItemId').setDisabled(true);
             				form.down('#sectionItemId').setDisabled(true);
                    	}
                    },
                    'studentstatusdownloadform button[itemId=StdStatusLoaderDownload]':{
                    	click: function(obj){
                    		var $this = this;
                    		var form = this.getStudentstatusdownloadform();
                    		var values = this.getProgramBatchPeriodJson(true);
                    		var csvForm = Ext.create('Ext.form.Panel',{
                    			items:[{
                    				xtype : 'textfield',
                    				maxLength : 20480,
                    				itemId : 'exportList',
                    				name : 'exportList',
                    				vtype : 'spaceAsInput'
                    			}]
                    		});
                    		csvForm.down('#exportList').setValue(values);
                    		csvForm.getForm().submit({
                    			target: '_blank',
                    			method:'POST',
                    			params :{access_token : Ext.Ajax.defaultHeaders.access_token},
                    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                    			url: SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_STATUS,
                    			standardSubmit :true,
                    			success : function(form, action){
                    				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
                    			},
                    			failure: function(form, action) {
                    				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
                    			}
                    		});
                    	}
                    },
                    'studentstatusloaderstructure radiogroup[itemId=importLoaderRadioGroupId]':{
                    	change: this.downloadUploadFormChangeStdStatus
                    },
                    'studentstatusuploadform uploadoptionradiogroup[itemId=stdStatusUploadRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
      	 			   change: function( radioGroup, newValue, oldValue, eOpts){
      	 				   var grid =this.getStudentstatusloadergrid();
      	 				   var isUploadAll = newValue.isUploadAll;
      	 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_STUDENT_STATUS');
      	 			   }   
                    },
                    'studentstatusuploadform':{
                        render: function(temForm){
                            var $this = this;
                            var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
                            var grid = $this.getStudentstatusloadergrid();
                            var form = $this.getStudentstatusuploadform().down('#stdStatusUploadRadioGroupItemId');
                			var isUploadAll = form.down('#uploadgroupItemId').getValue().isUploadAll;
                            $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_STUDENT_STATUS');
                            tempFormValue.getStore().load({
                                callback:function(record){
                                    for(var i in record){
                                        if(record[i].data.value == 'Bulk Student Status Update'){
                                            tempFormValue.setValue(record[i].data.id);
                                            tempFormValue.setReadOnly(true);
                                        }
                                    }
                                }
                            });
                        }
                    },
                    'studentstatusuploadform button[itemId=stdStatusUpload]':{
                    	click:function(obj){
                    		var $this=this;
                    		var importForm=$this.getStudentstatusuploadform()
                    		var grid =$this.getStudentstatusloadergrid();
                    		$this.getHashOfFile(importForm);
                    		setTimeout(function() {
                    			importForm.getForm().submit({
                    				method : 'POST',
                    				url : SERVERURL.IMPORT_UTILITY_MASTER_CREATE,
                    				success : function(form, action){
                    					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
                    				},
                    				failure: function(form, action) {
                    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
                    				}
                    			});
                    		},1000);

                    		Ext.defer(function() {
                    			var form = $this.getStudentstatusuploadform().down('#stdStatusUploadRadioGroupItemId');
                    			var isUploadAll = form.down('#uploadgroupItemId').getValue().isUploadAll;
                    			$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_STUDENT_STATUS');
                    		}, 2000, this);
                    	}  
                    },
                    'studentstatusuploadform button[itemId=resetBtn]':{
    	        		click:function(obj){
    	        			var $this=this;
    	        			var form = $this.getStudentstatusuploadform();
    	        			form.getForm().findField('file').reset();
    	        			var uploadoptionradiogroupform  = form.down('#stdStatusUploadRadioGroupItemId');
    	        			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    	        				isUploadAll: false
    	        			});
    	        		}
         		 },
         		   'studentstatusloadergrid button[itemId=btnForce]':{
         			   click: function(obj) {
         				   var grid = this.getStudentstatusloadergrid();
         				   if (grid.getSelectionModel().getCount() > 0) {
         					   if(grid.getSelectionModel().getCount() > 1){
         						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
         					   }else{
         						   var this$ = this;
         						   var id = grid.getSelectionModel().selectionStart.data.id;
         						   var urlAppend="?jobName="+id;
         						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
         						   Ext.Ajax.request({
         							   url: submitURL,
         							   method: 'GET',
         							   success: function(response) {
         								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
         									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
         								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
         									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
         								   }else if(response.responseText==="SUCCESS"){
         									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
         								   }
         							   }
         						   });
         					   }
         				   } else {
         					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         				   }  
         			   }
     			   },
     			   'studentstatusloadergrid':{
     				   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     					   if (e.target.tagName == 'A') {
     						   var fileType=null;
     						   if(cellIndex==1){
     							   fileType='successFile';
     						   }else if(cellIndex==6){
     							   fileType='errorFile';
     						   }else if(cellIndex==7){
     							   fileType='logFile';
     						   }
     						   var documentId = record.get("id");
     						   if (!isNullOrEmpty(documentId)) {
     							   this.getDownloadFile(documentId,fileType);
     						   }
     					   }
     				   }
     			   },
     			   'studentprofile dataview[itemId=studentProfileView]': {
     				   render: this.addHoldAlertClickHandler 
     			   },
     			  'studentprofile' : {
     				 afterrender: function(){
                         var associatedAcadLocationIds = new Array();
                         associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                         var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_LIST_PERMISSIONS());
                         var form = this.getContentPanelActiveTab();
                         var studentProfileImageIcon = form.down('#profile_image_icon');
                         studentProfileImageIcon.setVisible(false);
                         permissionList.forEach(function(btnName){
                             if(btnName == 'STUDENT_PROFILE_IMAGE_ICON'){
                            	 studentProfileImageIcon.setVisible(true);
                             }
                         });
                     }
     			  },
     			   'studentprofile container[itemId=profile_image_icon]': {
     				  afterrender: function(container) {
     				        container.getEl().on('click', this.openPhotoUploadPopup, this);
     				    }
     			   },
     			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[name=btnEdit]': {
     				   click: function(button) {
     					   	var window = this.getStudentuploadphotowindow();
     				        var btnEdit = window.down('button[name=btnEdit]');
     				        var btnRemove = window.down('button[name=btnRemove]');
     				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
     				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
     				        var btnCancel = window.down('button[name=btnCancel]');
     				        var btnBack = window.down('button[name=btnBack]');
//     				        var btnSave = window.down('button[name=btnSave]');
     				        
     				        // Hide Edit and Remove buttons
     				        btnEdit.setVisible(false);
     				        btnRemove.setVisible(false);
     				        btnCancel.setVisible(false);
//     				        btnSave.setVisible(false);
     				        
     				        // Show Upload Photo and Take a Photo buttons
     				        btnUploadPhoto.setVisible(true);
     				        btnTakePhoto.setVisible(true);
     				        btnBack.setVisible(true);
     				   }
     			   },
     			  'studentuploadphotowindow[itemId=studentuploadphotowindow] button[name=btnBack]': {
    				   click: function(button) {
    					   	var window = this.getStudentuploadphotowindow();
    					   	window.down('#profile_image_containerBox').destroy();
    					   	window.down('#profileRoatateImageIconId').hide();
    					   	window.down('#profileImageFormItemId').insert(0,{
    					   		// Profile Image Container
    					   		xtype: 'container',
    					   		width: 320,
    					   		height: 280,
    					   		layout: {
    					   			type: 'vbox',
    					   			align: 'center',
    					   			style: {
    					   				position: 'relative',
    					   			}
    					   		},
    					   		itemId: 'profile_image_containerBox',
    					   		items: [{
    					   			xtype: 'image',
    					   			itemId: 'profile_image',
    					   			border: 1,
    					   			style: {
    					   				borderColor: '#e0e0e0',
    					   				borderStyle: 'solid',
    					   				borderRadius: '50%',
    					   				marginTop:'67px !important'
    					   			},
    					   			width: 210,
    					   			height: 210,
    					   			src: 'resources/images/default-profile.png',
//    					   			margin: '0 0 3 0', // Adds spacing around the image
    					   		},{
    					   			xtype: 'hidden',
    					   			name: 'isImageRemoved',
    					   			itemId: 'isImageRemovedItemId'
    					   		}]
    					   	},
    					   	{
    					   		id:'capture_panel',
    					   		itemId:'capturePanelId',
    					   		hidden:true,
    					   		listeners:{
    					   			show:function(obj){
    					   				Webcam.set({
    					   					width: 320,
    					   					height: 240,
    					   					crop_width: 320,
    					   					crop_height: 240,
    					   					flip_horiz: true,
    					   					image_format: 'jpeg', // image format (may be jpeg or png)
    					   					jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
    					   				});
    					   				Webcam.attach('#capture_panel-innerCt');
    					   			},
    					   			hide: function () {
    					   				Webcam.reset();
    					   			}
    					   		}
    					   	},{
    					   		xtype:'panel',
    					   		itemId:'previewPanelId',
    					   		hidden:true
    					   	},{
    					   		xtype:'panel',
    					   		hidden:true,
    					   		html: "<canvas  id='canvas' width='310' height='272'></canvas>"
    					   	},
    					   	// Button Container for Profile Actions
    					   	{
    					   		xtype: 'container',
    					   		layout: {
    					   			type: 'hbox',
    					   			align: 'middle',
    					   			//pack: 'center',
    					   		},
    					   		margin: '20 0 0 0', // Adds spacing above the buttons
    					   		/*defaults: {
    					labelAlign: 'top',
    					margin: '0 5', // Adds spacing between buttons
    				},*/
    					   		items: [{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('EDIT'),
    					   			name: 'btnEdit',
    					   			itemId: 'btnEditItemId',
    					   			ui: 'CustomBtnSubmit',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			style: {
    					   				width: "60px !important",
    					   			}
    					   		},{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('REMOVE'),
    					   			name: 'btnRemove',
    					   			itemId: 'btnRemoveItemId',
    					   			ui: 'CustomBtnCancel',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			disabled: true
    					   		},{
    					   			xtype: 'filefield',
    					   			buttonText: getCommonTranslation('UPLOAD_PHOTO'),
    					   			name: 'file',
    					   			itemId: 'btnUploadPhotoItemId',
    					   			ui: 'CustomBtnSubmit',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			hidden: true,
    					   			buttonOnly: true
    					   		}, {
    					   			xtype: 'hidden',
    					   			name: 'name',
    					   			itemId: 'fileName'
    					   		}, {
    					   			xtype: 'hidden',
    					   			name: 'personId',
    					   			itemId: 'personId'
    					   		}, {
    					   			xtype: 'button',
    					   			text: getCommonTranslation('TAKE_A_PHOTO'),
    					   			name: 'btnTakePhoto',
    					   			itemId: 'btnTakePhotoItemId',
    					   			ui: 'CustomBtnSubmit',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			hidden: true
    					   		},{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('CAPTURE'),
    					   			name: 'capturePhoto',
    					   			itemId: 'capturePhotoItemId',
    					   			ui: 'CustomBtnSubmit',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			hidden: true,
    					   			style:{
    					   				marginTop:'6px !important'
    					   			}
    					   		},{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('RESET'),
    					   			name: 'resetPhoto',
    					   			itemId: 'resetPhotoItemId',
    					   			ui: 'CustomBtnSubmit',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			hidden: true,
    					   			style:{
    					   				marginTop:'6px !important'
    					   			}
    					   		}]
    					   	},
    					   	{
    					   		xtype: 'button',
    					   		cls: 'profileRoatateImageIcon',	
    					   		itemId: 'profileRoatateImageIconId',
    					   		hidden: true,
    					   		rotate: 0.1
    					   	},{
    					   		// Footer Button Container
    					   		xtype: 'container',
    					   		layout: {
    					   			type: 'hbox',
    					   			pack: 'space-between',
    					   			//align: 'middle'
    					   		},
    					   		margin: '60 0 0 0', // Adds spacing above the footer buttons
    					   		width: '100%',
    					   		defaults: {
    					   			//flex: 1,
    					   			//margin: '0 100',
    					   		},
    					   		items: [{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('CANCEL'),
    					   			name: 'btnCancel',
    					   			itemId: 'btnCancelItemId',
    					   			ui: 'CustomBtnCancel',
    					   			scale: CONSTANTS.BUTTONSIZE,	
    					   		},{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('BACK'),
    					   			name: 'btnBack',
    					   			itemId: 'btnBackItemId',
    					   			ui: 'CustomBtnCancel',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			hidden: true,
    					   		},{
    					   			xtype: 'component', 
    					   			flex: 2
    					   		},{
    					   			xtype: 'button',
    					   			text: getCommonTranslation('SAVE'),
    					   			name: 'btnSave',
    					   			itemId: 'btnSaveItemId',
    					   			ui: 'CustomBtnSubmit',
    					   			scale: CONSTANTS.BUTTONSIZE,
    					   			disabled: true
    					   		}]
    					   	});
    					   	var personProfile = this.getContentPanelActiveTab();
    				        var btnEdit = window.down('button[name=btnEdit]');
    				        var btnRemove = window.down('button[name=btnRemove]');
    				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
    				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
    				        var btnCancel = window.down('button[name=btnCancel]');
    				        var btnBack = window.down('button[name=btnBack]');
//    				        var btnSave = window.down('button[name=btnSave]');
    				        var capturePhoto = window.down('#capturePhotoItemId');
     					   	var resetPhoto = window.down('#resetPhotoItemId');
     					   	var profileImage = window.down('#profile_image');
     					   	var capturePanel = window.down('#capturePanelId');
     					   	var previewPanelId = window.down('#previewPanelId');
     					    var btnSave = window.down('button[name=btnSave]');
     					    
     					   if (window.lastSavedImageUrl) {
                               profileImage.setSrc(window.lastSavedImageUrl);
                           } else {
                        	   var fallbackImg = generateInitialsImage(
                       				personProfile.getPersonInfo().firstName,
                       				personProfile.getPersonInfo().middleName,
                       				personProfile.getPersonInfo().lastName
								 );
                               profileImage.setSrc(fallbackImg);
                           }
     					   
     					// Restore the previous image if available
    				        if (window.previousProfileImage) {
    				            profileImage.setSrc(window.previousProfileImage);
    				            profileImage.setVisible(true);
    				        }
    				        
    				        // Reset the file field so it detects the same image when uploaded again
    	                       btnUploadPhoto.reset();
     					   	
    				        btnEdit.setVisible(true);
    				        btnRemove.setVisible(true);
    				        btnCancel.setVisible(true);
//    				        btnSave.setVisible(true);
    				        profileImage.setVisible(true);
    				        
    				        btnUploadPhoto.setVisible(false);
    				        btnTakePhoto.setVisible(false);
    				        btnBack.setVisible(false);
    				        capturePhoto.setVisible(false);
     					   	resetPhoto.setVisible(false);
     					   	capturePanel.setVisible(false);
     					    previewPanelId.setVisible(false);
     					    btnSave.setDisabled(true);

     					    
     					   // Re-enable capture/reset buttons for future actions
    				        capturePhoto.setDisabled(false);
    				        resetPhoto.setDisabled(true);
    				        window.down('#btnUploadPhotoItemId').reset();
     					    
    				   }
    			   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[name=btnCancel]': {
    				   click: function(button) {
    					   var window = this.getStudentuploadphotowindow();
    					   window.close();
    				   }
    			   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[itemId=btnTakePhotoItemId]': {
    				   click: function(button) {
    					   this.openCapturePhoto();
    				   }
    			   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow]' : {
    					close : function(obj){
    						Webcam.userMedia=true;
    						Webcam.reset();
    					}
    				},
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[itemId=capturePhotoItemId]': {
    				   click: function(button) {
    					   this.captureUserPhoto(button);
    				   }
    			   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[itemId=resetPhotoItemId]': {
                       click: function(button) {
                           var window = this.getStudentuploadphotowindow();
                           window.down('#capturePanelId').setVisible(true);
                           window.down('#previewPanelId').setVisible(false);
                           window.down('#previewPanelId').update('');
                           window.down('#capturePhotoItemId').setDisabled(false);
                           window.down('#resetPhotoItemId').setDisabled(true);
                           window.down('#btnSaveItemId').setDisabled(true);
                           window.cropData = null;
                           window.component = null;
                       }
                   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] filefield[itemId=btnUploadPhotoItemId]': {
    				   change: this.uploadProfilePhoto
    			   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[itemId=btnSaveItemId]': {
    				   click: this.uploadCapturedImage
    			   },
    			   'studentuploadphotowindow[itemId=studentuploadphotowindow] button[itemId=btnRemoveItemId]': {
    				   click:function(){
    					   this.removeUploadCapturedImage();
    				   }
    			   },
                   'studentImportPostGraduationStructure radiogroup[itemId=importPostGraduationRadioGroupId]':{
                   	change: this.downloadUploadFormChangeStdPostGraduation
                   },
                   'studentPostGraduationDownloadForm':{
                	   afterrender:function(cmp){
                		   var me = this,
                		   programPostGraduation = cmp.down('#programPostGraduation');
                		   programPostGraduation.getStore().getProxy().extraParams = {
                			   academyLocationId:me.getCurrentAcademyLocation()
                     		}
                		   programPostGraduation.getStore().load();
                	   }
                   },
                   'studentPostGraduationDownloadForm customcombobox[itemId=programPostGraduation]':{
                      	select:function(cmp,newVal){
                      		var me = this,
                      		form = me.getStudentPostGraduationDownloadForm(),
                      		batchNamePost = form.down('#batchNamePostGraduation'),
                      		periodPostGraduation = form.down('#periodPostGraduation'),
                      		sectionNamePost = form.down('#sectionNamePost');
                      		batchNamePost.setDisabled(false);
                      		batchNamePost.reset();
                      		periodPostGraduation.setDisabled(true);
                      		periodPostGraduation.reset();
                      		sectionNamePost.setDisabled(true);
                      		sectionNamePost.reset();
                      		if(newVal){
	                      		batchNamePost.getStore().getProxy().extraParams = {
	                      			id:cmp.getValue()
	                      		}
	                      		batchNamePost.getStore().load();
                      		}
                      	}
                      },
                  'studentPostGraduationDownloadForm customcombobox[itemId=batchNamePostGraduation]':{
                	  change:function(cmp,newVal){
                		  var me = this,
                    		form = me.getStudentPostGraduationDownloadForm(),
                    		periodPostGraduation = form.down('#periodPostGraduation'),
                    		sectionNamePost = form.down('#sectionNamePost');
                		  periodPostGraduation.setDisabled(false);
                		  periodPostGraduation.reset();
                    		sectionNamePost.setDisabled(true);
                    		sectionNamePost.reset();
                		 
                		  if(newVal){
                			  periodPostGraduation.getStore().getProxy().extraParams = {
                      			id:newVal
                      		}
                			  periodPostGraduation.getStore().load();
                		  }
                		  
                    	}
                     },
                     'studentPostGraduationDownloadForm customcombobox[itemId=periodPostGraduation]':{
                    	 change:function(cmp,newVal){
                    		 var me = this,
                     		form = me.getStudentPostGraduationDownloadForm(),
                     		sectionNamePost = form.down('#sectionNamePost');
                    		 sectionNamePost.setDisabled(false);
                    		 if(newVal){
                    			 sectionNamePost.getStore().getProxy().extraParams = {
                          			periodId:newVal
                          		}
                         		 sectionNamePost.getStore().load();
                    		 }
                    		
                       	}
                     },
                     'studentPostGraduationDownloadForm button[itemId=resetBtn]':{
                    	 click:function(cmp){
                    		 var me = this,
                     		form = me.getStudentPostGraduationDownloadForm();

              				var pbpsContiner = form.down('#programBatchPostGraduationContainerId');
              				var newcont=pbpsContiner.items.items.length;
              				for(var i=newcont;i>0;i--){
              					pbpsContiner.remove(pbpsContiner.items.items[i]);
              				}
              				form.doLayout();
              				form.getForm().reset();
              				form.down('#batchNamePostGraduation').setDisabled(true);
              				form.down('#periodPostGraduation').setDisabled(true);
              				form.down('#sectionNamePost').setDisabled(true);
                    	 }
                     },
                     'studentPostGraduationDownloadForm button[itemId=addMoreRowBtnPost]':{
                    	 click: this.addMoreRowStudentPostGraduation
                     },
                     'studentPostGraduationDownloadForm button[itemId=StdPostLoaderDownload]':{
                    	 click: this.downloadTemplatePostGraduation
                     },
                     'studentPostGraduationLoaderGrid':{
                    	 afterrender:function(cmp){
                    		 var me = this,
                    		 form = me.getStudentPostGraduationUploadform(),
                    		 moduleNamePostGradutaion = form.down('#moduleNamePostGradutaion'),
                    		 isUploadAll = form.getForm().getValues().isUploadAll;
                    		 me.onChangeUploadOptionRadioGroup(isUploadAll, cmp,'IMPORT_FUNCTIONARY_DETAILS');
                    		 moduleNamePostGradutaion.getStore().load({
                    				callback: function(records, options, success) {
                    					 for(var i in records){
                 							 if(records[i].data.value=='Bulk Functionary Details'){
                 								moduleNamePostGradutaion.setValue(records[i].data.id);
                 								moduleNamePostGradutaion.setReadOnly(true);
                 							 }
                 						 }
                    					}
                    			    });
                    	 },
                    	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        					   if (e.target.tagName == 'A') {
        						   var fileType=null;
        						   if(cellIndex==1){
        							   fileType='successFile';
        						   }else if(cellIndex==6){
        							   fileType='errorFile';
        						   }else if(cellIndex==7){
        							   fileType='logFile';
        						   }
        						   var documentId = record.get("id");
        						   if (!isNullOrEmpty(documentId)) {
        							   this.getDownloadFile(documentId,fileType);
        						   }
        					   }
        				   }
                     },
                     'studentPostGraduationUploadform customcombobox[itemId=importPostGraduationId]':{
                    	 change:function(cmp,newVal){
                    		 var me = this,
                    		 grid = me.getStudentPostGraduationLoaderGrid(),
                    		 form = me.getStudentPostGraduationUploadform(),
                    		 moduleNamePostGradutaion = form.down('#moduleNamePostGradutaion'),
                    		 isUploadAll = form.getForm().getValues().isUploadAll;
                    		 if(newVal){
                    			 me.onChangeUploadOptionRadioGroup(isUploadAll, grid, newVal);
                    			 moduleNamePostGradutaion.getStore().data.items.forEach(function(rec){
                    				 if(newVal=='IMPORT_FUNCTIONARY_DETAILS'){
                    					 if(rec.data.value=='Bulk Functionary Details'){
                        					 moduleNamePostGradutaion.setValue(rec.data.id);
              								moduleNamePostGradutaion.setReadOnly(true);
                        				 }
                    				 }else if(newVal=='IMPORT_EXAMINER_DETAILS'){
                    					 if(rec.data.value=='Bulk Examiner Details'){
                        					 moduleNamePostGradutaion.setValue(rec.data.id);
              								moduleNamePostGradutaion.setReadOnly(true);
                        				 }
                    				 }
                    			 });
                    		 }
                    		 
                    	 }
                     },
                     'studentPostGraduationUploadform button[itemId=resetBtnPost]':{
                    	 click:function(btn){
                    		 var me = this,
                    		 form = me.getStudentPostGraduationUploadform(),
                    		 moduleNamePostGradutaion = form.down('#moduleNamePostGradutaion');
                    		 this.getStudentPostGraduationUploadform().getForm().reset();
                    		 moduleNamePostGradutaion.getStore().data.items.forEach(function(rec){
                						 if(rec.data.value=='Bulk Functionary Details'){
	                    					 moduleNamePostGradutaion.setValue(rec.data.id);
	          								moduleNamePostGradutaion.setReadOnly(true);
                						 }
                			 });
                    	 }
                     },
                     'studentPostGraduationUploadform button[itemId=stdPostGraduation]':{
                    	 click:this.uploadCsvFilePostGraduation
                     },
                     'studentPostGraduationLoaderGrid button[itemId=btnPostGraduationForce]':{
           			   click: function(obj) {
           				   var grid = this.getStudentPostGraduationLoaderGrid();
           				   if (grid.getSelectionModel().getCount() > 0) {
           					   if(grid.getSelectionModel().getCount() > 1){
           						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
           					   }else{
           						   var this$ = this;
           						   var id = grid.getSelectionModel().selectionStart.data.id;
           						   var urlAppend="?jobName="+id;
           						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
           						   Ext.Ajax.request({
           							   url: submitURL,
           							   method: 'GET',
           							   success: function(response) {
           								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
           									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
           								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
           									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
           								   }else if(response.responseText==="SUCCESS"){
           									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
           								   }
           							   }
           						   });
           					   }
           				   } else {
           					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
           				   }  
           			   }
       			   },
       			'studentPostGraduationUploadform radiogroup[itemId=uploadgroupItemId]':{
       				change:function(radioGroup, newValue, oldValue){
       					var grid = this.getStudentPostGraduationLoaderGrid(),
					      isUploadAll = newValue.isUploadAll,
					      form = this.getStudentPostGraduationUploadform(),
					      importPostGraduationId = form.down('#importPostGraduationId');
  	 				  this.onChangeUploadOptionRadioGroup(isUploadAll, grid,importPostGraduationId.getValue());
       				}
       			},
                'studentuploadphotowindow[itemId=studentuploadphotowindow] button[itemId=profileRoatateImageIconId]': {
 				   click: function(button) {
 					   var formPanel = this.getStudentuploadphotowindow();
 					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
 					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
 					   imageInnerContainerBox.crop.rotate(button.rotate + .40);
 					   button.rotate = parseFloat(button.rotate) + .50;
 				   }
 			   },
 			   'searchresultgrid[itemId=StudentSearchResultGrid] menuitem[itemId=changeStartAttendanceDateBtn]': {
 				   click: function(obj) {
 					   var $this=this;
 					   grid = $this.getSearchResultGrid();
 					   if (grid.getSelectionModel().getCount() ==1) {
 						   var record = grid.getSelectionModel().getSelection()[0];
 						   var studentId=record.data.USER_ID,
 						   programBatchSeatConfigId=record.data.PROGRAM_BATCH_SEAT_CONFIG_ID,
 						   admissionId=record.data.ADMISSION_ID;
 						   Ext.Ajax.request({
 							   method : "GET",
 							   type : 'rest',
 							   url: SERVERURL.PATH_FIND_BILLING_START_DATE_STATUS,
 							   params: {
 								   studentId : studentId,
 								   programBatchSeatConfigId : programBatchSeatConfigId,
 								   admissionId :admissionId
 							   },
 							   success: function(response) {
 								   var data = Ext.decode(response.responseText);
 								   if(data.status){
 									   var changestartattendancedatewin = $this.getChangestartattendancedatewin();
 									   if (!changestartattendancedatewin) {
 										   Ext.widget('changestartattendancedatewin');
 										   changestartattendancedatewin = $this.getChangestartattendancedatewin();
 									   }
 									   changestartattendancedatewin.show();

 									   Ext.defer(function() {
 										   changestartattendancedatewin.down('#attendanceDateId').setValue(dateRender(data.schoolAttendanceStartDate));
 									   }, 800);
 								   }else{
 									   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EITHER_BILL_OR_EXISTING_STUDENT'));
 								   }
 							   }
 						   });
 					   }else {
 						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 					   }  
 				   }
 			   },
 			  'changestartattendancedatewin button[itemId=cancelBtn]':{
 				 click: function(obj) {
 					 var win = this.getChangestartattendancedatewin();
 					 win.close();
 				 }
 			   },
 			   'changestartattendancedatewin button[itemId=submitBtn]':{
 				   click: function(obj) {
 					   var $this=this,
 					   win = $this.getChangestartattendancedatewin(),
 					   attendanceDate = win.down('#attendanceDateId').getValue(),
 					   grid = $this.getSearchResultGrid(),
 					  admissionId=grid.getSelectionModel().getSelection()[0].data.ADMISSION_ID;
 					   Ext.Ajax.request({
 						   method : "POST",
 						   type : 'rest',
 						   url: SERVERURL.PATH_UPDATE_ATTENDANCE_START_DATE,
 						   params: {
 							  admissionId : admissionId,
 							  schoolAttendanceStartDate : attendanceDate ? Ext.Date.format(new Date(attendanceDate), 'Y-m-d') : null
 						   },
 						   success: function(response) {
 							   var data = Ext.decode(response.responseText);
 							   win.close();
 							   grid.getSelectionModel().deselectAll();
 							   grid.getStore().load();
 							   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
 						   }
 					   });
 				   }
 			   },
				'studentliststudentprogramtransferform': {
					afterrender: this.onStudentProgramTransferFormRender
				}
        });
    },
    removeUploadCapturedImage: function(){
   	 	var win = this.getStudentuploadphotowindow();
        var saveBtn = win.down('#btnSaveItemId');
        var removeBtn = win.down('#btnRemoveItemId');
        var personProfile = this.getContentPanelActiveTab();
        var profileImage = win.down('#profile_image');
        var isImageRemoved = win.down('#isImageRemovedItemId');
        var fallbackImg = generateInitialsImage(
   				personProfile.getPersonInfo().firstName,
   				personProfile.getPersonInfo().middleName,
   				personProfile.getPersonInfo().lastName
			 );
        profileImage.setSrc(fallbackImg);
        isImageRemoved.setValue(true);
        saveBtn.setDisabled(false);
        removeBtn.setDisabled(true);
  },
   
    uploadCapturedImage: function() {
    	var me = this;
    	var personProfile = me.getContentPanelActiveTab();
    	var personId = Number(personProfile.getPersonId());
        var formPanel = me.getStudentuploadphotowindow();
        var form = formPanel.down('form');
//        var formValues = formPanel.getValues();
        
        if(form.down('#profile_image_containerBox').isVisible()) {
       	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
       	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
       	 var finalImageBase64;
       	 var imageBlob;
       	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
       		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
       		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
       	 }
        }
        
        var formValues = form.getValues();
        // Check if there's an image to upload
        var imageField = formPanel.down('#profileImageFormItemId');
        var imageVal = formPanel.down('#btnUploadPhotoItemId');
        var profile_image = formPanel.down('#profile_image');
        var isImageRemoved = formPanel.down('#isImageRemovedItemId');
        if(isImageRemoved.value == 'true'){
        	me.saveuploadCapturedImage('');
        	return;
        }
        me.applyWindowMask();
        if (profile_image.isVisible()) {
            // If there's an image, upload it first

       	 var formData = new FormData();
       	 for (var key in formValues) {
       	     if (formValues.hasOwnProperty(key)) {
       	         formData.append(key, formValues[key]);
       	     }
       	 }
       	 formData.append('file', imageBlob, 'profile.png');
       	 
       	 var userInfo = Academia.model.authentication.UserInfoModel;
       	 var access_token = userInfo.get("accessToken");
       	 
       	 var url = SERVERURL.PERSON_IMAGE_UPLOAD+'?access_token='+access_token;
       	 
       	 var xhr = new XMLHttpRequest();
       	 xhr.open('POST', url);

       	 xhr.onload = function () {
       	     if (xhr.status >= 200 && xhr.status < 300) {
       	         var response = JSON.parse(xhr.responseText);
       	         var path = response.path;
       	         var updatedPath = path.replace(/^\/+/, "");
       	         me.saveuploadCapturedImage(path);
       	     }
       	 };
       	 xhr.send(formData);
        }else{
        	var userInfo = Academia.model.authentication.UserInfoModel;
			var access_token = userInfo.get("accessToken");
        	var canvas = document.getElementById('canvas');
			var ctx = canvas.getContext("2d");
			var region = formPanel.cropData; 
			var component = formPanel.component;
			var sw = region.width - region.x;
			var sh = region.height - region.y;
			var imgWidth = component.width;
			var imgHeight = component.height;
			var img = new Image();
			img.src = component.src;
			ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
			var dataUrl = canvas.toDataURL("image/png");
			
			var url = 'rest/personImage/uploadeB64Image?access_token='+access_token;
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', '1.png');
			form.append('personId', personId);
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);

			xhr.onreadystatechange = function () {
				if (xhr.readyState == 4 && xhr.status == 200) {
					if (xhr.responseText != "") {
						var data = Ext.decode(xhr.responseText);
						var personinfo = personProfile.getPersonInfo();
						personinfo.photoUrl = data.path;
						var updatedPath = data.path.replace(/^\/+/, "");
						showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
						//me.saveuploadCapturedImage(updatedPath);
						me.getUploadCaptureToPersonProfile();
					}
				}
				formPanel.close();	
				//me.hideWindowMask();
			};
			xhr.send(form);
        } 
    },
    
    saveuploadCapturedImage: function(imageUrl){
    	var me = this;
    	var win = me.getStudentuploadphotowindow();
    	var form = this.getStudentprofile();
    	var personProfile = me.getContentPanelActiveTab();
    	var personId = Number(personProfile.getPersonId());
    	personProfile.getPersonInfo().photoUrl=imageUrl;
    	var payload = {
    			personId: personId,
    			path: imageUrl
    	};
    	
    	var firstName = personProfile.getPersonInfo().firstName;
    	var middleName = personProfile.getPersonInfo().middleName;
    	var lastName = personProfile.getPersonInfo().lastName;
    	
    	var submitUrl = SERVERURL.PATH_UPLOAD_PERSON_PROFILE_PHOTOS;
    	
    	var data = Ext.encode(payload);
    	
    	Ext.Ajax.request({
    		url: submitUrl,
    		method: 'POST',
    		jsonData:data,
            success: function(response){
            	var responseData = response.responseText;
            	if (responseData=='fail') {
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
            	}else{
            		if(imageUrl==''){
            			  var profileImage = personProfile.down('#profile_image');
            			  var newImgUrl = generateInitialsImage(firstName, middleName, lastName);
            			  profileImage.setVisible(true);
            			  profileImage.getEl().dom.src = newImgUrl;
             			  showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PERSON_PROFILE_PHOTO_REMOVE_SUCCESS'));
           		 	}
            		else{
            			me.getUploadCaptureToPersonProfile();
            			showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
            		}
            	}
            	win.close();
            	me.hideWindowMask();
            },
            failure: function(response){
            	me.hideWindowMask();
            }
    	})
    },
    
    uploadProfilePhoto: function(cmp, value) {
    	var window = this.getStudentuploadphotowindow();
        var form = window.down('form');
        var image = form.down('#profile_image');
        var imageContainerBoxId = form.down('#profile_image_containerBox').id;
	    var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        var btnSave = window.down('button[name=btnSave]');
        var file = cmp.el.down('input[type=file]').dom.files[0];
        var isImageRemoved = window.down('#isImageRemovedItemId');

        // File extension validation
        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
        if (!isNullOrEmpty(value)) {
            if (extension === "png" || extension === "jpeg" || extension === "jpg") {
            	if(file){
           		 if (file.size < 100 * 1024 || file.size > 2 * 1024 * 1024){      // file size should be less than 100 kb & greater than 2MB                       
           			 cmp.reset();
                        showWarningMessage(
                            getPersonModuleTranslation('PHOTO_UPLOAD'),
                            getCommonTranslation('FILE_SIZE_BETWEEN_RANGE')
                        );
                        return;
                    }else {
                        isImageRemoved.setValue(false);
                    }
            	}
            } else {
                cmp.reset();
                showWarningMessage(
                    getPersonModuleTranslation('PHOTO_UPLOAD'),
                    getPersonModuleTranslation('UPLOAD_VALID_FILE')
                );
                return;
            }
        } else {
            showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('NO_FILE_SELECTED'));
            return;
        }

        // Process the valid file
        if (file) {
            form.down('#fileName').setValue(file.name);
            var personProfile = this.getContentPanelActiveTab();
            var personId = Number(personProfile.getPersonId());
            form.down('#personId').setValue(personId);

            var reader = new FileReader();
            reader.onload = function(e) {
            	var crop;
	        	var imageSrc;
	        	var canvasDiv ;
                image.setSrc(e.target.result);
                Ext.defer(function(){
	            	imageSrc = imageInnerContainerBox.children[0].src;
			        image.setVisible(false);
			        window.down('#profileRoatateImageIconId').show();
	            	 crop = cropper(imageInnerContainerBox, {
    				    area: [ 210, 210 ],
    				    crop: [ 115, 115 ],
    				    value: imageSrc,
    				    allowResize: true,
    		            allowZoom: true,
    		            allowRotation: true,         		            
    				})
    				var jcropArea = imageInnerContainerBox.querySelector('.jcrop-area');
	            	 if (jcropArea) {
	            		    var innerJcropDiv1 = document.createElement('div');
	            		    innerJcropDiv1.className = 'border-left';

	            		    var innerJcropDiv2 = document.createElement('div');
	            		    innerJcropDiv2.className = 'border-right';

	            		    jcropArea.appendChild(innerJcropDiv1);
	            		    jcropArea.appendChild(innerJcropDiv2);
	            		}
    				canvasDiv = jcropArea.nextSibling;

    				if(!isNullOrEmpty(canvasDiv)){
    					var mouseEventOccurred = false;

    				if (canvasDiv) {
    				    // Listen for mouse events and set the flag to true when one occurs
    					canvasDiv.addEventListener('mousemove', function () {
    						mouseEventOccurred = true;
				            if (mouseEventOccurred) {    				                
				                var croppedImage = crop.getCroppedImage().src;
    				            image.setSrc(croppedImage);
    				            image.setVisible(true);
				            }    				            
				        })
				        if(mouseEventOccurred == false) {
    				    image.setSrc(imageSrc);
    				    image.setVisible(true);
    				}
    				} 
    			} 
				else {
				    image.setSrc(imageSrc);
				    image.setVisible(true);
				}
	            },500)
                btnSave.setDisabled(false);
            };
            reader.readAsDataURL(file);
        }
    },
    
    openPhotoUploadPopup: function() {
    	var profileUploadWindow = this.getStudentuploadphotowindow();
    	
        if (!profileUploadWindow) {
        	profileUploadWindow = Ext.widget('studentuploadphotowindow',{
        				 itemId : 'studentuploadphotowindow'
        			 }); 
        }
        
        if (!profileUploadWindow.hasAfterRenderHandler) {
        	profileUploadWindow.on('afterrender', function () {
                var personProfile = this.getContentPanelActiveTab();
                var personId = personProfile.getPersonId();
                if (!isNullOrEmpty(personId)) {
                    Ext.Ajax.request({
                        url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId,
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                var profileImage = profileUploadWindow.down("#profile_image");
                                profileImage.setVisible(true);
                                 if(personProfile.getPersonInfo().photoUrl){
                                	profileImage.getEl().dom.src = url;
                                    // **Store the last saved image URL**
                                    profileUploadWindow.lastSavedImageUrl = url;
                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
                                }else{
                                	profileImage.getEl().dom.src = '';
                                	var fallbackImg = generateInitialsImage(
                            				personProfile.getPersonInfo().firstName,
                            				personProfile.getPersonInfo().middleName,
                            				personProfile.getPersonInfo().lastName
    								 );
                                	profileImage.getEl().dom.src = fallbackImg;
                                    // **Store the last saved image URL**
                                    profileUploadWindow.lastSavedImageUrl = fallbackImg;
                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(true);
                                }
                            }
                        },
                    });
                }
            }, this);
            
            // Mark handler as attached to avoid duplicate bindings
        	profileUploadWindow.hasAfterRenderHandler = true;
        }
        
        profileUploadWindow.show();
     },
    
    addHoldAlertClickHandler: function(view) {
    	var el = view.getEl();
    	if(el) {
    		el.on('click', function(event, target){
    			if(Ext.fly(target).hasCls('hold-alert-link')) {
    				this.handleHoldClick();
    			}
    		}, this, {delegate: 'a.hold-alert-link'})
    	}
    },
    
    handleHoldClick: function() {
    	var studentProfilePanel = Ext.ComponentQuery.query('studentprofile')[0];
    	var mainp = studentProfilePanel.down('persondetailslinkpanel');
    	var dv = mainp.down('#DISCIPLINARY_ACTIVITY').down('dataview');
    	dv.up('panel').expand();
    	var result = dv.getStore().findRecord('tabPanelItemXtype', 'manageholdsstructure')
    	var nodeIndex = dv.getStore().find('tabPanelItemXtype', result.get('tabPanelItemXtype'));
    	if(nodeIndex != -1){
    	    var dataViewEl = dv.getEl();
    	    Ext.defer(function() {
    	        var childNodes = dataViewEl.dom.childNodes;
    	        var specificNode = childNodes[nodeIndex];
    	        specificNode.click();
    	    }, 700);
    	}
    },
    
    saveChangeSeatType : function(form,grid){
    	var $this=this;
    	var seatTypeId=form.down('#changeSeatTypeItemID').getValue();
       	var admissionId=grid.getSelectionModel().getSelection()[0].data.ADMISSION_ID;
       	var submitUrl=SERVERURL.PATH_SEAT_TYPE_CHANGE+"?seatTypeId="+seatTypeId +"&admissionId="+admissionId;
    	$this.applyWindowMask(); 
    	  Ext.Ajax.request({
   			type: 'rest',
   			url: submitUrl,
   			method: 'post',
   			success: function(res, action) {
				$this.hideWindowMask();
				$this.getChangeseattype().close();
				grid.getStore().reload();
   				}
    	  })
   		
    },
    studentImportAgrregationDownloadUploadFormChange : function(cb, nv, ov) {
		var $this = this;
		var structure = cb.up('aggregationstabstructure');
		var downloadTemplateForm = structure.down('importaggregationdownloadform');
		var uploadTemplateForm = structure.down('importaggregationuploadform');
		var grid = $this.getImportaggregationlist();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate') {
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		} else {
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			var uploadoptionradiogroupform  = $this.getStudentAcademicTopicuploadoptionradiogroup();
			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				isUploadAll: false
			});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	 getImportAggregationsTopicDownloadFile : function(documentId,fileType){
	  	   if(!isNullOrEmpty(documentId)){
	  		   var csvForm = Ext.create('Ext.form.Panel'); 
	  		   csvForm.getForm().submit({
	  			   target: '_blank',
	  			   method:'POST',
	  			   params :{
	  				   access_token : Ext.Ajax.defaultHeaders.access_token
	  			   },
	  			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	  			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	  			   standardSubmit :true
	  		   });
	  	   }
	     },
	    
	
    getStudentAcademicTopicDownloadFile : function(documentId,fileType){
  	   if(!isNullOrEmpty(documentId)){
  		   var csvForm = Ext.create('Ext.form.Panel'); 
  		   csvForm.getForm().submit({
  			   target: '_blank',
  			   method:'POST',
  			   params :{
  				   access_token : Ext.Ajax.defaultHeaders.access_token
  			   },
  			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
  			   standardSubmit :true
  		   });
  	   }
     },
    studentAcademicTopicDownloadUploadFormChange : function(cb, nv, ov) {
		var $this = this;
		var structure = cb.up('studentacademictopicstructure');
		var downloadTemplateForm = structure.down('studentacademictopicdownloadform');
		var uploadTemplateForm = structure.down('studentacademictopicuploadform');
		var grid = $this.getImportstudentacademictopiclist();
		if(nv.downloadUploadTemplate == 'forDownloadTemplate') {
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);
		} else {
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			var uploadoptionradiogroupform  = $this.getStudentAcademicTopicuploadoptionradiogroup();
			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				isUploadAll: false
			});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			grid.setVisible(true);
			uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	
    customzingViewForStudentPortal : function(){
    	//TODO
    	/**
    	 * Changes required only if the logged in portal is Student
    	 */
    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
    		var this$ = this;
    		var structure = this.getStudentQuickSearchView();
    		this$.getStudentQuickSearchView().setAutoScroll(false);
    		
    		var searchForm = this$.getStudentQuickSearchForm();
    		searchForm.hide();
            var ResultGrid = this$.getSearchResultGrid();
            ResultGrid.hide();
            
            var comboPanel = structure.down('studentrequestcombopanel');
            comboPanel.setVisible(true);
    		comboPanel.down('combo#serviceRequestCombo').setVisible(false);
    		comboPanel.down('button#raiseButtonId').setVisible(false);
    		comboPanel.down('button#cancelButtonId').setVisible(false);
    		
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_LIST_VIEWCODE);
            
            var values = new Object();
            var searchcriteria = new Array();

            values.configCode = CONSTANTS.CB.STUDENT_LIST_BASIC_CONFIGCODE;

            var studentId = this$.getCurrentlyLoggedInUser().id;
            var studentIdObj = this$.getJsonObject('USER_ID' , studentId);
            this$.pushJsonObjectInArray(studentIdObj, searchcriteria);

            values.searchCriterias = searchcriteria;
            var jsonFormatFormData = values;
            ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    	}
    },
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
    	var form = this.getStudentQuickSearchForm();
        switch (combo.name) {
        case 'PROGRAM_NAME':
            break;
        case 'BATCH_NAME':
            this.clearCombo(combo, false);

            periodCombo = form.down('combo[name=PERIOD_NAME]');
            this.clearCombo(periodCombo, true);
            courseCombo = form.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            courseVariantCombo = form.down('combo[name=COURSE_VARIENT_ID]');
            this.clearCombo(courseVariantCombo, true);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'PERIOD_NAME':
            this.clearCombo(combo, false);
            courseCombo = form.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo, true);
            courseVariantCombo = form.down('combo[name=COURSE_VARIENT_ID]');
            this.clearCombo(courseVariantCombo, true);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'COURSE_NAME':
            this.clearCombo(combo, false);
            courseVariantCombo = form.down('combo[name=COURSE_VARIENT_ID]');
            this.clearCombo(courseVariantCombo, true);
            sectionCombo = form.down('combo[name=SECTION]');
            this.clearCombo(sectionCombo, true);
            break;
        case 'SECTION':
            this.clearCombo(combo, false);
            break;
        case 'COURSE_VARIENT_ID':
            this.clearCombo(combo, false);
            break;
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo, isDisabled) {
        combo.clearValue();
        combo.store.removeAll();
        combo.setDisabled(isDisabled);
    },                         
    
    
    resetStudentQuickSearchForm: function(){
    	var this$ = this;
    	var form = this$.getStudentQuickSearchForm();
    	var admissionFromDate = form.down('#admissionFromDateId');
		var admissionToDate = form.down('#admissionToDateId');
    	form.getForm().reset();
    	admissionToDate.setMaxValue(false);
		admissionToDate.setMinValue(false);
		admissionToDate.setValue(dateFormatRender(new Date()));
    	var comboStore = form.down('#program').getStore();
    	comboStore.getProxy().extraParams = {};
    	comboStore.getProxy().api.read = comboStore.getProxy().api.read.split('?')[0];
    	comboStore.load();
    	  var course =form.down('#course').getStore();
    	    course.getProxy().extraParams = {};
    	    course.getProxy().api.read = course.getProxy().api.read.split('?')[0];
    	    course.load();
    	this$.clearCombo(form.down('#batch'), true);
    	this$.clearCombo(form.down('#period'), true);
    //	this$.clearCombo(form.down('#course'), true);
    	this$.clearCombo(form.down('#courseVarientId'), true);
    	this$.clearCombo(form.down('#section'), true);
    	
    	form.down('#intakeYear').setDisabled(false);
    	form.down('#academicTerm').setDisabled(false);
    	form.getForm().findField("PROGRAM_CATEGORY").setDisabled(false);
    	form.down('#programGroupId').setDisabled(false);
    	form.down('#program').setDisabled(false);
    	form.down('#batch').setDisabled(false);
    	form.down('#period').setDisabled(false);
    	form.down('#seatType').setDisabled(false);
    	form.down('#section').setDisabled(false);
    	form.down('#course').setDisabled(false);
    	form.down('#courseVarientId').setDisabled(false);
    	form.down('#externalSysRefOne').setDisabled(false);
    	form.down('#statusComboItemId').setDisabled(false);
    	form.down('#admissionStatus').setDisabled(false);
    	form.down('#studentStatusItemId').setDisabled(false);
    	form.down('#phone_No').setDisabled(false);
    	form.down('#emailId').setDisabled(false);
    	form.down('#gender').setDisabled(false);
    	form.down('#religionCombo').setDisabled(false);
    	form.down('#castCategoryCombo').setDisabled(false);
    	form.down('#advisorNameItemId').setDisabled(false);
    	form.down('#nationalID').setDisabled(false);
    	form.down('#admissionFromDateId').setDisabled(false);
    	form.down('#admissionToDateId').setDisabled(false);
    	form.down('#MODE_OF_DELIVERY').setDisabled(false);
    	form.down('#PROGRAM_STATUS').setDisabled(false);

    }, 
    
    
    loadGridAndSearchUsers: function(model, records) {
        var SearchForm = this.getStudentQuickSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var ResultGrid = this.getSearchResultGrid();
        var statusCombo = SearchForm.down('#statusComboItemId');
        if(statusCombo.getValue() != false){
        	var makeActiveBtn = ResultGrid.down('#makeActiveBtn');
            makeActiveBtn.hide();
        }
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_LIST_VIEWCODE);
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);

    },
    exportStudentList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getStudentQuickSearchForm();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('STUDENT_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
                if(!isNullOrEmpty(searchForm.getForm().findField(key))){
                	searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
                }
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    /**
	 * Add dynamic reset buttons in student listing.
	 */
    gridRenderFunctionForStudent:function(grid){
    	grid.addButtonToolbar();
    	var butonstoolbar=grid.down('#functionButtonsToolbar');
    	butonstoolbar.insert(4,{
    		xtype: 'button',
    		itemId: 'resetButtonItemId',
    		text:getCommonTranslation('RESET_PASSWORD'),
    		tooltip :getCommonTranslation('RESET_PASSWORD')
    	});
    	butonstoolbar.insert(5,{
			 xtype: 'button',
			 text:getCommonTranslation('MAKE_ACTIVE'),
	         itemId:'makeActiveBtn',
	         disabled:true,
			 tooltip :getCommonTranslation('MAKE_ACTIVE')
	    });
    	butonstoolbar.insert(6,{
    		xtype: 'button',
    		itemId: 'sendMessageBtn',
    		text:getCommonTranslation('SEND_MESSAGE'),
    		tooltip :getCommonTranslation('SEND_MESSAGE')
    	});
    	butonstoolbar.insert(7,{
    		xtype: 'button',
    		text:getCommonTranslation('PRINT_ID_CARD'),
    		itemId:'printIdCardBtn',
    		tooltip :getCommonTranslation('PRINT_ID_CARD')
    	});
    	butonstoolbar.insert(8,{
    		xtype: 'button',
    		itemId: 'deleteStudentListBtn',
    		text:getCommonTranslation('DELETE'),
    		tooltip:getCommonTranslation('DELETE'),
    	});
        butonstoolbar.insert(9,{
    		xtype: 'button',
    		itemId: 'makeAlumniItemId',
    		text:getAlumni('MAKE_ALUMNI'),
    		tooltip:getAlumni('MAKE_ALUMNI'),
    		disabled:true
    	});

    	butonstoolbar.insert(9,{
    		xtype : 'splitbutton',
    		itemId:'spBtnPrintDocuments',
    		text : getCommonTranslation('PRINT_DOCUMENTS'),
    		menu:[{
    			text:getCommonTranslation('PRINT_ID_CARD'),
    			itemId:'printIdCardMultipleBtn',
    			tooltip :getCommonTranslation('PRINT_ID_CARD')
    		},{
    			itemId:'printStudentCertificate',
    			text : getCommonTranslation('PRINT_CERTIFICATE'),
    			tooltip :getCommonTranslation('PRINT_CERTIFICATE')
    		},{
    			itemId:'printProfileBtn',
    			text : getCommonTranslation('PRINT_PROFILE'),
    			tooltip :getCommonTranslation('PRINT_PROFILE')
    		},{
    			itemId:'printProfileAndContractDetailsBtn',
    			text : getCommonTranslation('PRINT_PROFILE_AND_CONTRACT_DETAILS'),
    			tooltip :getCommonTranslation('PRINT_PROFILE_AND_CONTRACT_DETAILS')
    		},{
    			itemId:'printLabelsBtn',
    			text : getCommonTranslation('PRINT_LABELS'),
    			tooltip :getCommonTranslation('PRINT_LABELS')
    		},{
    			itemId:'printTaxCertificate',
    			text : getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE'),
    			tooltip :getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE')
    		},{
    			itemId:'transferCard',
    			text : getCommonTranslation('TRANSFER_CARD'),
    			tooltip :getCommonTranslation('TRANSFER_CARD')
    		},{
    			itemId:'printAttestationStatementOfStudentJourney',
    			text : getCommonTranslation('PRINT_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY'),
    			tooltip :getCommonTranslation('PRINT_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY')
    		},
              ],
    		listeners: {click: function() {this.showMenu();}}
    	});
    	
    	var moreActionBtnArray=[
	        {
    			itemId: 'flagRequestButtonItemId',
    			text:getCommonTranslation('RAISE_FLAG'),
    			tooltip :getCommonTranslation('RAISE_FLAG')
    		},{
    			itemId: 'raiseRequestButtonItemId',
    			text:getCommonTranslation('RAISE_REQUEST'),
    			tooltip :getCommonTranslation('RAISE_REQUEST')
    		},{
    			itemId:'assignStudentCommitteeBtn',
    			text : getCommonTranslation('MAP_COMMITTEE'),
    			tooltip :getCommonTranslation('MAP_COMMITTEE')
    		},{
    			itemId: 'bulkDownloadDocId',
    			text:getCommonTranslation('BULK_DOWNLOAD_DOC'),
    			tooltip:getCommonTranslation('BULK_DOWNLOAD_DOC'),
    		},{
    			itemId:'sendSurveyBtn',
        		text : getCommonTranslation('SEND_SURVEY'),
        		tooltip :getCommonTranslation('SEND_SURVEY')
    		},{
	    		text:getCommonTranslation('CHANGE_SEAT_TYPE'),
	    		itemId:'changeSeatTypeId',
	    		tooltip :getCommonTranslation('CHANGE_SEAT_TYPE'),
	    		disabled: true
	    	},{
	    		text:getCommonTranslation('CHANGE_PRIMARY_LOCATION'),
	    		itemId:'changePrimaryLocationBtn',
	    		tooltip :getCommonTranslation('CHANGE_PRIMARY_LOCATION'),
	    	},{
				text:getCommonTranslation('OFFER_LETTER_DETAILS'),
				itemId:'offerLetterDetailsItemId'
			},{
				text:getCommonTranslation('ADD_LIBRARY'),
				itemId:'kohastudentlibrarymappingBtn',
				tooltip :getCommonTranslation('ADD_LIBRARY')
			},{
				text:getCommonTranslation('ADD_PATRON_CATEGORY'),
				itemId:'kohastudentcategorymappingBtn',
				tooltip :getCommonTranslation('ADD_PATRON_CATEGORY')
			},{
				text:getCommonTranslation('INACTIVE_STUDENT'),
				itemId:'inactiveStudentMoreActionBtn',
				tooltip :getCommonTranslation('INACTIVE_STUDENT')
			},{
				text:getCommonTranslation('STUDENT_STATUS_CSM'),
				itemId:'studentStatusCSMBtn',
				tooltip :getCommonTranslation('STUDENT_STATUS_CSM')
			},{
				text:getCommonTranslation('SEND_MSG_TO_ALL'),
				itemId:'studentSendMSGToAllBtn',
				tooltip :getCommonTranslation('SEND_MSG_TO_ALL')
			},{
				text:getCommonTranslation('ADD_VOTER_POOL'),
				itemId:'elctionVoterPoolBtn',
				tooltip :getCommonTranslation('ADD_VOTER_POOL')
			},{
	    		text:getCommonTranslation('THESIS_NOMINATION'),
	    		itemId:'thesisNominationBtn',
	    		tooltip :getCommonTranslation('THESIS_NOMINATION')
	    	},{
	    		text:getCommonTranslation('PROGRAM_TRANSFER'),
	    		itemId:'studentListProgramTransfer',
	    		tooltip :getCommonTranslation('PROGRAM_TRANSFER'),
	    		disabled: true
	    	},{
				text:getAdmissionTranslation('PANDADOC'),
				itemId:'pandaDocItemId',
    	        disabled: true
			},
			{
				text:getCommonTranslation('APPLY_HOLD'),
				itemId:'applyHoldBtn',
				tooltip :getCommonTranslation('APPLY_HOLD')
			},{
	    		text:getCommonTranslation('REQUEST_DOCUMENTS'),
	    		itemId:'studentDocumentRequestId',
	    		tooltip :getCommonTranslation('REQUEST_DOCUMENTS'),
	    		disabled: true
	    	},{
	    		text:getCommonTranslation('BULK_RESET_PASSWORD'),
	    		itemId:'bulkResetPasswordToAllBtn',
	    		tooltip :getCommonTranslation('BULK_RESET_PASSWORD'),
	    	},
	    	{
	    		text:getCommonTranslation('RAISE_SCHOLARSHIP_REQUEST'),
	    		itemId:'raiseScholarshipRequestId',
	    		tooltip :getCommonTranslation('RAISE_SCHOLARSHIP_REQUEST'),
	    		disabled: true
	    	},{
	    		text:getCommonTranslation('APPLY_FOR_HOSTEL'),
	    		itemId:'applyForHostelBtn',
	    		tooltip :getCommonTranslation('APPLY_FOR_HOSTEL'),
	    		disabled: true
	    	},{
	    		text:getCommonTranslation('APPLY_FOR_HOSTEL_WAITING_LIST'),
	    		itemId:'applyForHostelWaitingListBtn',
	    		tooltip :getCommonTranslation('APPLY_FOR_HOSTEL_WAITING_LIST'),
	    		disabled: true
	    	},{
	    		text:getCommonTranslation('CHANGE_START_ATTENDANCE_DATE'),
	    		itemId:'changeStartAttendanceDateBtn',
	    		tooltip :getCommonTranslation('CHANGE_START_ATTENDANCE_DATE'),
	    		disabled: true
	    	}];
    	// Create the menu with a table layout
    	var moreActionsMenu = Ext.create('Ext.menu.Menu', {
    	    layout: {
    	        type: 'table',
    	        columns: 2 // Number of columns for the menu
    	    },
    	    cls:'moreActionNewMneuBtnCls',
    	    defaults: {
    	        xtype: 'menuitem',
    	        minWidth: 150, // Ensure consistent width for items
    	        cls:'moreActionNewMneuBtnCls',
    	        style:{
    	        	'margin':'0px 5px 2px 10px !important'
    	        }
    	    },
    	    
    	    items: moreActionBtnArray // Directly add the menu items
    	});
    	// Insert the splitbutton with the custom menu
    	butonstoolbar.insert(10, {
    	    xtype: 'splitbutton',
    	    itemId: 'spBtnMoreActions',
    	    cls:'moreActionNewMneuBtnCls',
    	    text: getCommonTranslation('MOREACTIONS'),
    	    menu: moreActionsMenu,
    	    listeners: {
    	        click: function() {
    	            this.showMenu();
    	        }
    	    }
    	});
    	/*butonstoolbar.insert(11,{
      		 xtype: 'button',
      		 itemId: 'studentDocumentRequestId',
      		 text:getCommonTranslation('REQUEST_DOCUMENTS'),
      		 tooltip :getCommonTranslation('REQUEST_DOCUMENTS'),
      		disabled: true
      	 });*/
    	/*butonstoolbar.insert(11,{
    		xtype : 'button',
    		itemId:'sendSurveyBtn',
    		text : getCommonTranslation('SEND_SURVEY'),
    		tooltip :getCommonTranslation('SEND_SURVEY')
    	});*/
    	
    	 butonstoolbar.insert(13,{
			 xtype: 'button',
			 text:getCommonTranslation('EXPORTREPORTS'),
	         itemId:'exporetStudentReport',
 			 tooltip :getCommonTranslation('EXPORTREPORTS'),
	    });/*
		 butonstoolbar.insert(12,{
			 xtype : 'button',
			 itemId:'assignStudentCommitteeBtn',
			 text : getCommonTranslation('MAP_COMMITTEE'),
			 tooltip :getCommonTranslation('MAP_COMMITTEE')
		 });
		 butonstoolbar.insert(12,{
			 xtype : 'button',
			 itemId:'printStudentCertificate',
			 text : getCommonTranslation('PRINT_CERTIFICATE'),
			 tooltip :getCommonTranslation('PRINT_CERTIFICATE')
		 });*/
    	/*butonstoolbar.insert(13,{
			 xtype : 'button',
			 itemId:'printProfileBtn',
			 text : getCommonTranslation('PRINT_PROFILE'),
			 tooltip :getCommonTranslation('PRINT_PROFILE')
		 });*/
		butonstoolbar.insert(14,{
    		 xtype: 'button',
    		 itemId: 'createStudentInAlfresco',
    		 text:getDMSTranslation('CREATE_USER_IN_ALFRESCO'),
    		 tooltip :getDMSTranslation('CREATE_USER_IN_ALFRESCO')
    	 });
    },
    loadStudentListGridStore : function(){
    	var this$ = this;
    	var form = this$.getStudentQuickSearchForm();
    	if(!isNullOrEmpty(form)){
    		var searchButton = form.down('#searchButtonId');
        	searchButton.fireEvent('click');
    	}
    	
    },
    
    createJsonFormat: function(searchForm) {
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.STUDENT_LIST_BASIC_CONFIGCODE;

        formValues = searchForm.getValues();        
        var studentField = searchForm.getForm().findField('STUDENT_ID');
        var admissionField = searchForm.getForm().findField('ADMISSION_NUMBER');      
        var applicationFiled = searchForm.getForm().findField('APPICANT_PRINT_NAME');
        if(!isNullOrEmpty(formValues.ADMISSION_TO_DATE)){formValues.ADMISSION_TO_DATE = formValues.ADMISSION_TO_DATE+' 23:59:59';}
	    
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' && 
            		key !== 'STUDENT_ID' && key !== 'ADMISSION_NUMBER' && key !== 'STUDENT_STATUS_CSM' ){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        if(formValues["ADMISSION_STATUS"]){
        	 var academyLocationIds =this$.getUserAccessibleAL();
        	 var ACCESSIBLE_AL_ID = this$.getJsonObject( 'ACCESSIBLE_AL_ID' , academyLocationIds);
 	        this$.pushJsonObjectInArray(ACCESSIBLE_AL_ID,searchcriteria);
        }
        var academyLocationId = this.getCurrentAcademyLocation();
        
        /**this condition code added for application id filter only when selected**/
        if(!isNullOrEmpty(formValues.APPICANT_PRINT_NAME)){
        	formValues.STATUS=true;
        	formValues.ADMISSION_STATUS=true;
        }
      
        if(!isNullOrEmpty(formValues.STUDENT_ID)){
        	var studentRec = studentField.getStore().getById(formValues.STUDENT_ID);
        	if(!isNullOrEmpty(studentRec)){
        		  var studetnRecObj = this$.getJsonObject( 'STUDENT_ID' , studentRec.data.studentCode);
        	        this$.pushJsonObjectInArray(studetnRecObj,searchcriteria);
        	}
        }
        if(!isNullOrEmpty(formValues.ADMISSION_NUMBER)){
        	var admissionRec = admissionField.getStore().findRecord('id',formValues.ADMISSION_NUMBER);
        	if(!isNullOrEmpty(admissionRec)){
        		 var admissionRecObj = this$.getJsonObject( 'ADMISSION_NUMBER' , admissionRec.data.code);
        	        this$.pushJsonObjectInArray(admissionRecObj,searchcriteria);
        	}
        }
        var academyLocationObj = this$.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
        this$.pushJsonObjectInArray(academyLocationObj,searchcriteria);
        
        if(!isNullOrEmpty(formValues.religion)){
        	 var religionId = this$.getJsonObject( 'RELIGION_ID' , formValues.religion.id);
             this$.pushJsonObjectInArray(religionId,searchcriteria);
        }
        
        if(!isNullOrEmpty(formValues.castCategory)){
        	 var casteCatergoryId = this$.getJsonObject( 'CASTE_CATERGORY_ID' , formValues.castCategory.id);
             this$.pushJsonObjectInArray(casteCatergoryId,searchcriteria);
        }
        
        var debaredStudentsCheckBoxChecked = false;
    	
    	if( !isNullOrEmpty(formValues.debaredStudents) && formValues.debaredStudents ){
    		debaredStudentsCheckBoxChecked = true;
    	}
        
        if(formValues.STATUS  && formValues.ADMISSION_STATUS){
        	var exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
            this$.pushJsonObjectInArray(exitDate,searchcriteria);
        }else{
        	if(!formValues.STATUS  && !formValues.ADMISSION_STATUS){
        		var exitDate = this$.getJsonObject( 'EXIT_DATE_NOT_NULL' , true);
        		if( debaredStudentsCheckBoxChecked ){
        			exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
        		}
        		if( formValues.APPICANT_PRINT_NAME ){
        			exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
        		}              
        		this$.pushJsonObjectInArray(exitDate,searchcriteria);
        	}
        }
        if((!isNullOrEmpty(formValues.COURSE_NAME) || !isNullOrEmpty(formValues.COURSE_VARIENT_ID)) && formValues.STATUS  && formValues.ADMISSION_STATUS){
        	var enrollementExitDate = this$.getJsonObject('ENROLLMENT_EXIT_DATE_NULL' , true);
        	this$.pushJsonObjectInArray(enrollementExitDate,searchcriteria);
        }
        
        if (formValues.STATUS && !formValues.ADMISSION_STATUS) {
            var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', true);
            this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
            var pbsInactiveStdMaxSql ='(SELECT max(id) from program_batch_students where admissionId=T3.id group by admissionId)';
            var pbsStdMaxId = this$.getJsonObject('PBS_MAX_ID', pbsInactiveStdMaxSql);
            this$.pushJsonObjectInArray(pbsStdMaxId, searchcriteria);
        } else if (!formValues.STATUS && formValues.ADMISSION_STATUS) {
            var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', false);
            this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
        } else if (formValues.STATUS && formValues.ADMISSION_STATUS) {
            var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', false);
            this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
        } else if (!formValues.STATUS && !formValues.ADMISSION_STATUS) {
            var isPeriodCompleted = this$.getJsonObject('IS_PERIOD_COMPLETED', true);
            this$.pushJsonObjectInArray(isPeriodCompleted, searchcriteria);
            var pbsInactiveStdMaxSql ='(SELECT max(id) from program_batch_students where admissionId=T3.id group by admissionId)';
            var pbsStdMaxId = this$.getJsonObject('PBS_MAX_ID', pbsInactiveStdMaxSql);
            this$.pushJsonObjectInArray(pbsStdMaxId, searchcriteria);
        }
        
        if(!isNullOrEmpty(formValues.STUDENT_STATUS_CSM)){
        	var studentStatusCSMComboArr = formValues.STUDENT_STATUS_CSM;
        	var studentStatusCSMArr = [];
        	for(i in studentStatusCSMComboArr){
        		if( !isNullOrEmpty(studentStatusCSMComboArr[i].data) ){
        			var studentStatusCSMId = studentStatusCSMComboArr[i].data.id;
            		studentStatusCSMArr.push(studentStatusCSMId);
        		}
        	}
        	if( studentStatusCSMArr.length != 0 ){
        		var studentStatusCSMObj = {
                        "paramCode": 'STUDENT_STATUS_CSM_ID_LIST',
                        "paramValues": studentStatusCSMArr
                    };
                this$.pushJsonObjectInArray(studentStatusCSMObj,searchcriteria);
        	}
       }
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    getJsonProgramBatchPeriodObject: function(key, value, additionalValue) {
    	if(!isNullOrEmpty(value)){
    		var valueArray=[];
	    	for(var i in value) {
	    		valueArray.push(value[i].data.id);
	    	}
	    	var paramValues = valueArray.join(',');
    		if(additionalValue == undefined){
    			 return {
    	                "paramCode": key,
    	                "paramValues": [paramValues]
    	            };
    		}else if(additionalValue != undefined){
    			 return {
    	                "paramCode": key,
    	                "paramValues": [paramValues, additionalValue]
    	            };
    		}
    	}
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    cellClickStudentSearchResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
    	var academyLocationId = this$.getCurrentAcademyLocation();
        //var searchResultGrid = this$.getSearchResultGrid();
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        studentDetails=record;
        var portalInfo = Academia.model.authentication.StudentERPInfoModel;
        var grid = this.getSearchResultGrid();
        var serviceRequestRequiredForInActiveStudent = this.getInActiveStudentServiceRequestRequired();
        var SearchForm = this.getStudentQuickSearchForm();
        var searchResultForm = SearchForm.getForm();
        var userStatus =searchResultForm.findField('STATUS').getValue();
        var admissionStatus =searchResultForm.findField('ADMISSION_STATUS').getValue();
    	if (grid.getSelectionModel().getCount() > 0) {
    		
    		localStorage.setItem('PROGRAM_ID',record.data.PROGRAM_ID);
    		
    		if(grid.getSelectionModel().getCount() > 1) {
    			//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    		} else {
    			if(!serviceRequestRequiredForInActiveStudent && !userStatus && !admissionStatus){
    				if (grid.getSelectionModel().getSelection()[0].data.STATUS=='Inactive') {
						grid.down('#raiseRequestButtonItemId').setDisabled(true);
						grid.down('#studentListProgramTransfer').setDisabled(true);
						grid.down('#inactiveStudentMoreActionBtn').setDisabled(true);
						grid.down('#raiseScholarshipRequestId').setDisabled(false);
					}
					else {
						grid.down('#raiseRequestButtonItemId').setDisabled(false);
						grid.down('#raiseScholarshipRequestId').setDisabled(false);
					  }
    			  }else if(!serviceRequestRequiredForInActiveStudent ){
    				  if (grid.getSelectionModel().getSelection()[0].data.STATUS=='Inactive') {
  						grid.down('#raiseRequestButtonItemId').setDisabled(true);
  						grid.down('#studentListProgramTransfer').setDisabled(true);
  						grid.down('#inactiveStudentMoreActionBtn').setDisabled(true);
  						grid.down('#raiseScholarshipRequestId').setDisabled(true);
  					}
  					else {
  						grid.down('#raiseRequestButtonItemId').setDisabled(false);
  						grid.down('#raiseScholarshipRequestId').setDisabled(false);
  					  }
    			  }
    	       }
    		}
    		
    		
        if (columnName == "STUDENT_ID") {
            var tabTitle = record.get('STUDENT_ID');
            var personId = record.get('PERSON_ID');
            var userId = record.get('ID');
            var admissionId = record.get('ADMISSION_ID');
            var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
            var submitUrl =SERVERURL.BATCH_ID_BY_STUDENT_ID;
            if(!isNullOrEmpty(userId)){
            	
            	
            	Ext.Ajax.request({
        			type: 'rest',
        			url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
        			method : 'GET',
        			params:{
        				academyLocationId:academyLocationId ,
        			},
        			success: function(f, action) {
        				var data = f.responseText;
        				if(data == "true"){	
        	            	this$.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
        				}else{
        					this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
        					this$.addContentPanelTab(tabTitle, 'pendingbillsgrid', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
        				}
        			},
        			failure: function(result, request) {
        				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
        				return false;
        			}
        		});
            	//this$.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
            	
            	 //this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
                 Ext.Ajax.request({
         			type: 'rest',
         			url: submitUrl,
         			params:
         				{
         				  studentId : userId
         				},
         			method: 'GET',
         			async: false,
         			success: function(res, action) {
         				var data = Ext.decode(res.responseText);
         				portalInfo.set('admissionDetails',data[0].admissionDetails);
         				portalInfo.set('student',data[0].student);
         				portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
         				portalInfo.set('programBatchDetails',data[0].programBatchDetails);
         				portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
         			}
         		});
                 
                 // for user activities
                 Ext.Ajax.request({
                	 url: SERVERURL.USER_ACTIVITY_RECENT_VISITED_STUDENT+"?visitedUserId="+encodeURIComponent(Number(userId))+"&userGroup=" + encodeURIComponent("Student"),
                	 method: 'POST',
                	 success: function(response) {
                		 if(!isNullOrEmpty(response.responseText)){
                			 var responseData = Ext.decode(response.responseText); 
                		 }
                	 },
                	 failure: function(response) {
                	     showErrorMessage('Error', 'No update');
                	 }
                 })
            }
        }
        
        /*var studentProfile = this.getTabReferenceByTabTitle(tabTitle);
     

        if(!isNullOrEmpty(studentProfile)){
        	 var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
             if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
				
             	var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
                 this.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
             }
        }*/
    },
    
    disableExtraButton:function(column,selected) {
    	var grid = this.getSearchResultGrid();
    	var resetButtonItemId = grid.down('#resetButtonItemId');
    	var raiseRequestButtonItemId = grid.down('#raiseRequestButtonItemId');
    	var offerLetterDetailsItemId = grid.down('#offerLetterDetailsItemId');
    	var studentDocumentRequestId = grid.down('#studentDocumentRequestId');
    	var makeActiveButton = grid.down("#makeActiveBtn");
    	var pandaDocBtn = grid.down('#pandaDocItemId');
    	var makeAlumniBtn = grid.down('#makeAlumniItemId');
    	var scholarshipRaiseReqIds= grid.down('#raiseScholarshipRequestId');
    	var changeSeatType= grid.down('#changeSeatTypeId');
    	var applyForHostelBtn = grid.down('#applyForHostelBtn');
    	var applyForHostelWaitingListBtn = grid.down('#applyForHostelWaitingListBtn');
    	var changeStartAttendanceDateBtn = grid.down('#changeStartAttendanceDateBtn');

    	var count=selected.length;
    	var studentDelete=grid.down('#deleteStudentListBtn'); 
    	if(count >= 1){
    		makeAlumniBtn.setDisabled(false)
    	}
    	else{
    		makeAlumniBtn.setDisabled(true)
    	}
    	if(count> 1){ // enable
    		resetButtonItemId.setDisabled(false);
    		raiseRequestButtonItemId.setDisabled(true);
    		studentDelete.setDisabled(true);
    		offerLetterDetailsItemId.setDisabled(true);
    		studentDocumentRequestId.setDisabled(false);
    		scholarshipRaiseReqIds.setDisabled(true);
    		pandaDocBtn.setDisabled(true);
    		changeSeatType.setDisabled(true);
    		applyForHostelBtn.setDisabled(true);    
    		applyForHostelWaitingListBtn.setDisabled(true);    
    		changeStartAttendanceDateBtn.setDisabled(true);    
    	}else{  // disable
    		resetButtonItemId.setDisabled(true);
    		raiseRequestButtonItemId.setDisabled(true);
    		studentDelete.setDisabled(false);
    		scholarshipRaiseReqIds.setDisabled(false);
    		applyForHostelBtn.setDisabled(false);
    		applyForHostelWaitingListBtn.setDisabled(false);  
    		changeStartAttendanceDateBtn.setDisabled(false);   
    		//offerLetterDetailsItemId.setDisabled(false);
    		//studentDocumentRequestId.setDisabled(true);
    	}
    	if(count== 0){
    		pandaDocBtn.setDisabled(true);
    		offerLetterDetailsItemId.setDisabled(true);
    		studentDocumentRequestId.setDisabled(true);
    		scholarshipRaiseReqIds.setDisabled(true);
    		changeSeatType.setDisabled(true);
    		applyForHostelBtn.setDisabled(true);
    		applyForHostelWaitingListBtn.setDisabled(true);   
    		changeStartAttendanceDateBtn.setDisabled(true);   
    	}
    	if(count== 1){ // enable
    		resetButtonItemId.setDisabled(false);
    		raiseRequestButtonItemId.setDisabled(false);
    		scholarshipRaiseReqIds.setDisabled(false);
    		pandaDocBtn.setDisabled(false);
    		applyForHostelBtn.setDisabled(false);
    		applyForHostelWaitingListBtn.setDisabled(false);    
    		changeStartAttendanceDateBtn.setDisabled(false);   
    		var applicationSource = selected[0].data.APPLICATION_CREATION_SOURCE;
    		if( applicationSource == "Direct Admission" || applicationSource == "" ){
    			offerLetterDetailsItemId.setDisabled(true);
    		} else {
    			offerLetterDetailsItemId.setDisabled(false);
    		}
    		studentDocumentRequestId.setDisabled(false);
    		changeSeatType.setDisabled(false);
    	}
    	var selectionModel = grid.getSelectionModel().getSelection();
        var flag=true;
        selectionModel.forEach(function(obj){
            if(obj.get('ADMISSION_INACTIVE_REASON')=='Academy Location Transfer' || obj.get('ADMISSION_INACTIVE_REASON')=='Program Transfer'){
                flag=false;
                }else{
                    flag=true;
                }
        });
        if(flag==true)
            {
            if(selectionModel.length<1){
            makeActiveButton.setDisabled(true);
            }else{
                makeActiveButton.setDisabled(false);    
            }
            }else{
                makeActiveButton.setDisabled(true);    
            }
    },

    /**
     * This method is use to open the service request tab for the student
     * @param requestType Type of the request
     * @param requestGroup 
     */
    openServiceRequestTab:function(requestorType,requestGroup,otherRequestType) {
    	
    	var portalId = this.getCurrentLoggedPortalId();
    	/**
    	 * for student portal login , portalId=3
    	 */
    	if(portalId==3){
    		var studentDetail = this.getCurrentlyLoggedInUserWithPersonId();
    		var record = this.getSearchResultGrid().getStore().getAt(0);
    		var personId = studentDetail.personId;
			var studentId = studentDetail.id;
			var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
			serviceRequestController.getRequestPanel(requestorType,requestGroup,studentId,personId,otherRequestType,record);
    		
    	}else{
    		var grid = this.getStudentListView().down('grid');
    		if(grid.getSelectionModel().getCount() == 1){	
    			var record = grid.getSelectionModel().getSelection()[0];
    			var personId = record.get('PERSON_ID');
    			var studentId = record.get('ID');
    			var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
    			serviceRequestController.getRequestPanel(requestorType,requestGroup,studentId,personId,otherRequestType,record);
    		} else {
    			showInfoMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    		}
    	}
    },
    
    loadOnComboChange:function(combo,value) {
    	var this$ = this;
    	var portalId = this$.getCurrentLoggedPortalId();
    	var window = this$.getRaiseServiceRequestWindow();
    	/**
    	 * for student portal login , portalId=3
    	 */
    	if(portalId==3){
    		var requestType = this.getRequestType();
    		var structure = this.getStudentQuickSearchView();
    		var comboPanel = structure.down('studentrequestcombopanel');
    		var catcombo = comboPanel.down('combo#RequestCategoryCombo');
    		var combo = comboPanel.down('combo#serviceRequestCombo');
    		
    		catcombo.setVisible(false)
   		 catcombo.setDisabled(true);
   		 combo.setDisabled(true);
   		 catcombo.clearValue();
    		if(value ==='TRANSFER' || value ==='EXAM_RELATED') {
    			combo.setVisible(true);
    			combo.setDisabled(false);
    			this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());
    		}else if (value ==='OTHER') {
    			catcombo.setVisible(true);
    			catcombo.setDisabled(false);
    		  this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());
    		} else {
    			combo.setVisible(false);
    			combo.setDisabled(true);
    			this.openServiceRequestTab(requestType,value);   		
    		}
    	}else{
    		var comboPanel = window.down('studentrequestcombopanel');    	
    		var catcombo = comboPanel.down('combo#RequestCategoryCombo');
    		var combo = comboPanel.down('combo#serviceRequestCombo');
    		var requestType = this.getRequestType();
    		 catcombo.setVisible(false)
    		 catcombo.setDisabled(true);
    		 combo.setDisabled(true);
    		 catcombo.clearValue();
    		combo.clearValue();
    		if(value ==='TRANSFER' || value ==='EXAM_RELATED') {
    			combo.setDisabled(false);
    			comboPanel.down("#raiseButtonId").setDisabled(true);
    			this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());
    		}else if (value ==='OTHER') {
    			catcombo.setVisible(true);
    			catcombo.setDisabled(false);
    		  this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());
    		} else {
    			combo.setDisabled(true);
    			comboPanel.down("#raiseButtonId").setDisabled(false);
    			this.loadComboStore(value,requestType,this.getCurrentAcademyLocation());	
    		} 
    		
    	}
    	
    },
    
    loadOnCategoryComboChange:function(combo,value) {
    	var this$ = this;
    	var window = this$.getRaiseServiceRequestWindow();
    	var requestType = this.getRequestType();
    	var window = this$.getRaiseServiceRequestWindow();
    	var programId = window.config.programId;
     	if(portalId==3){
     		
     		var structure = this.getStudentQuickSearchView();
     		var comboPanel = structure.down('studentrequestcombopanel');
     		var combo = comboPanel.down('combo#serviceRequestCombo');
     		if (value ==='LEAVE') {
    			 combo.setVisible(true);
         		combo.setDisabled(false);
         		combo.getStore().getProxy().extraParams={
            			serviceRequestGroup:'OTHER',
            			serviceRequestCategory:requestType,
            			academyLocationId:this.getCurrentAcademyLocation(),
            			programId:programId,
            			category:'LEAVE'
            		}	
            	
        		combo.getStore().load();
     		} else if(value ==='Readmission') {
    			combo.setDisabled(false);
    			combo.setVisible(false);
    			comboPanel.down("#raiseButtonId").setDisabled(false);
   		
    		}else {
     			combo.setVisible(false);
     			combo.setDisabled(true);
     			this.openServiceRequestTab(requestType,value);   		
     		}
     	}else{
    	var comboPanel = window.down('studentrequestcombopanel');
    		var combo = comboPanel.down('combo#serviceRequestCombo');
    		var requestType = this.getRequestType();
    	     combo.clearValue();
    		if (value ==='LEAVE') {
    		    combo.setVisible(true);
        		combo.setDisabled(false);
        		combo.getStore().getProxy().extraParams={
        			serviceRequestGroup:'OTHER',
        			serviceRequestCategory:requestType,
        			academyLocationId:this.getCurrentAcademyLocation(),
        			programId:programId,
        			category:'LEAVE'
        		}	
        		combo.getStore().load();
    			}else if(value ==='Readmission') {
        			combo.setDisabled(false);
        			combo.setVisible(false);
        			comboPanel.down("#raiseButtonId").setDisabled(false);
       		
        		}else {
    			combo.setDisabled(true);
    			comboPanel.down("#raiseButtonId").setDisabled(false);
   		
    		}
    	}
    },
    
    loadComboStore:function(serviceRequestGroup,serviceRequestCategory,academyLocationId) {  
    	var this$ = this;
    	var store=null;
    	var programId=null;
    	var portalId = this$.getCurrentLoggedPortalId();
    	var SearchForm = this.getStudentQuickSearchForm();
        var searchResultForm = SearchForm.getForm();
        var userStatus =searchResultForm.findField('STATUS').getValue();
        var admissionStatus =searchResultForm.findField('ADMISSION_STATUS').getValue();
        var serviceRequestRequiredForInActiveStudent = false;
        if(userStatus && !admissionStatus){
        	serviceRequestRequiredForInActiveStudent = this.getInActiveStudentServiceRequestRequired()
        } 
    	if(portalId==3){
    		store = this.getStudentRequestComboPanel().down('combo#serviceRequestCombo').getStore();
    	}else{
    		var window = this$.getRaiseServiceRequestWindow();
    		store = window.down('combo#serviceRequestCombo').getStore();
    		programId = window.config.programId;
    	}
    	store.getProxy().extraParams={
			serviceRequestGroup:serviceRequestGroup,
			serviceRequestCategory:serviceRequestCategory,
			academyLocationId:this.getCurrentAcademyLocation(),
			programId:programId,
			serviceRequestRequiredForInActiveStudent: serviceRequestRequiredForInActiveStudent
		}	
	
    	store.load();
    },
    /**
     * Open passwordRest window for admin 
     */
    openResetPasswordWindow:function(){
    	
    	/*var addressWindowItemId ="vehicleAddressFormWindow";
        var addressFormWindow = Ext.widget('addressformwindow', {
            itemId: addressWindowItemId
        });
        addressFormWindow.show();*/
    	
    	/*var $this=this;
        var formWindow = $this.getAdminresetpasswordwindow();	
 	      if (!formWindow) {
 	         Ext.widget('adminresetpasswordwindow');
 	         formWindow = $this.getAdminresetpasswordwindow();
 	      } formWindow.show();*/
 	    var resetPswrdWindowItemId ="studentlistadminresetpasswordwindow";
        var resetPswrdFormWindow = Ext.widget('adminresetpasswordwindow', {
             itemId: resetPswrdWindowItemId
         });
        resetPswrdFormWindow.show();
 	    
    },
    
    openResetPasswordWindowForAll:function(){
	
 	    var resetPswrdWindowItemId ="studentlistbulkresetpasswordwindow";
        var resetPswrdFormWindow = Ext.widget('studentbulkresetpasswordwindow', {
             itemId: resetPswrdWindowItemId
         });
        resetPswrdFormWindow.show();
        var form = resetPswrdFormWindow.down('form');
        var isForAll =  form.getForm().findField('isForAll');
        isForAll.setValue(true);
    },
    
    /**
     * Open Raise service request window
     */
    openRaiseRequestWindow:function(){
    	var this$ = this;
    	var window = this$.getRaiseServiceRequestWindow();
    	if(!window){
    		window = Ext.widget('studentraiseservicerequestwindow');
    	}
    	window.show();
    },
    
    /**
     *Check and Change password by admin. 
     */
    changePasswordByAdmin:function(button){
    	var $this = this;
    	var grid = this.getSearchResultGrid();
    	var gridRec=grid.getSelectionModel().getSelection();
    	var SearchForm = this.getStudentQuickSearchForm();
        var searchCriterias = null; 
    	var window=button.up('window');
    	var form=button.up('form').getForm();
		var formValues=form.getValues();
		var userIds = [];
		var userIdsWithComma = null;
		if (!isNullOrEmpty(formValues.isForAll) && formValues.isForAll == 'true') {
			searchCriterias = new Array();
			var academyLocationIds = $this.getUserAccessibleAL();
       	 	var ACCESSIBLE_AL_ID = $this.getJsonObject( 'ACCESSIBLE_AL_ID' , academyLocationIds);
       	 	$this.pushJsonObjectInArray(ACCESSIBLE_AL_ID,searchCriterias);
			var ACADEMY_LOCATION_ID = $this.getJsonObject('ACADEMY_LOCATION_ID', formValues.ACAD_LOC_ID);
			$this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchCriterias);
	        var PROGRAM_NAME = $this.getJsonProgramBatchPeriodObject('PROGRAM_NAME', formValues.PROGRAM);
	        $this.pushJsonObjectInArray(PROGRAM_NAME,searchCriterias);
	        var BATCH_NAME = $this.getJsonProgramBatchPeriodObject('BATCH_NAME', formValues.BATCH);
	        $this.pushJsonObjectInArray(BATCH_NAME,searchCriterias);
	        var PERIOD_NAME = $this.getJsonProgramBatchPeriodObject('PERIOD_NAME', formValues.PERIOD_NAME);
	        $this.pushJsonObjectInArray(PERIOD_NAME,searchCriterias);
	        var IS_COMMON_PASSWORD = $this.getJsonObject('IS_COMMON_PASSWORD', formValues.passwordType);
	        $this.pushJsonObjectInArray(IS_COMMON_PASSWORD,searchCriterias);
	        var STATUS = $this.getJsonObject('STATUS', true);
	        $this.pushJsonObjectInArray(STATUS,searchCriterias);
		}else{
			Ext.each(gridRec, function(currentRecord){
				userIds.push(currentRecord.get('USER_ID'));
				userIdsWithComma = userIds.join(',');
			});
		}
		
		if(!gridRec.length){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			return;
		}
		
		var data={
				  "userIds":userIdsWithComma,
				  "newPassword":$this.encryptPassword(formValues.confirmedPassword),
				  "isResetPassword":true,
				  "searchCriterias":searchCriterias
				};
		/***
		 * It's inital been commented further it get implemented. 
		 * Check whether user is locked or not
		 */
		/*var url = SERVERURL.CHECK_PASSWORD_VALIDITY;
		Ext.Ajax.request({
            method: "GET",
            type: 'rest',
            url:url+'?password='+formValues.newPassword,
            success: function(response) {
            	
            	var mssg = response.responseText;
				if (mssg == "false") {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
				}else if(mssg == "true"){*/
					/**
					 * Change password
					 */
		
		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
				function(btn, text) {
			if (btn == 'yes'){
				var pswrdurl = SERVERURL.CHANGE_PASSWORD_BY_ADMIN;
				$this.applyWindowMask(); 

				Ext.Ajax.request({
					method: "POST",
					type: 'rest',
					url:pswrdurl,
					jsonData:data,
					success: function(response) {
						$this.hideWindowMask();
						var mssg = response.responseText;
						if (mssg == "SUCCESS") {
							showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('ADMIN_PASSWORD_CHANGE_MSG'));
						}else if(mssg == "USER_LOCKED"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
						}else if(mssg.includes("PASSWORD_IN_USE")){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PASSWORD_IN_USE'));
						}else if(mssg.includes("PASSWORD_POLICY_NOT_CONFIGURED_PROPERLY")){
						}else{
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_NOT_FOUND_MSG'));
						}
						window.close();
					}
				});
			}
		});
					
					
				/*}
            }
		 });*/
    },
    //******************Disable reset password button**********************************
    disableMoreActionPivileges: function(grid,permissionsMap) {
    	var $this = this;
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = grid.query('toolbar')[0];
    	var resetButton = grid.down('#resetButtonItemId');
    	var raiseRequest = grid.down('#raiseRequestButtonItemId');
		var flagRequest= grid.down('#flagRequestButtonItemId'); //03/01/23 @manas
    	var sendMessageBtn = grid.down('#sendMessageBtn');
    	var printIdCardBtn = grid.down('#printIdCardBtn');
    	var printIdCardMultipleBtn = grid.down('#printIdCardMultipleBtn');
    	var sendSurveyBtn = grid.down('#sendSurveyBtn');
    	var exporetStudentReportBtn = grid.down('#exporetStudentReport');
    	var assignStudentCommitteeBtn = grid.down('#assignStudentCommitteeBtn');
    	var printStudentCertificate = grid.down('#printStudentCertificate');
    	var printAttestationStatementOfStudentJourney = grid.down('#printAttestationStatementOfStudentJourney');
    	var bulkDownloadDocBtn = grid.down('#bulkDownloadDocId');
    	var printProfileBtn = grid.down('#printProfileBtn');
    	var printProfileAndContractDetailsBtn = grid.down('#printProfileAndContractDetailsBtn');
    	var studentStatusCSMBtn = grid.down('#studentStatusCSMBtn');
    	var transferCard = grid.down('#transferCard');
    	var deleteStudentListBtn = grid.down('#deleteStudentListBtn');
    	var spBtnPrintDocumentsBtn = grid.down('#spBtnPrintDocuments');
    	var spBtnMoreActionsBtn = grid.down('#spBtnMoreActions');
    	var makeActiveBtn = grid.down('#makeActiveBtn');
    	var printLabelsBtn = grid.down('#printLabelsBtn');
    	var offerLetterDetailsBtn = grid.down('#offerLetterDetailsItemId');
    	var printTaxCertificateBtn = grid.down('#printTaxCertificate');
    	var studentlibrarymappingBtn = grid.down('#kohastudentlibrarymappingBtn');
    	var studentcategorymappingBtn = grid.down('#kohastudentcategorymappingBtn');
    	var createStudentInAlfrescoBtn = grid.down('#createStudentInAlfresco');
    	var studentDocumentRequestBtn = grid.down('#studentDocumentRequestId');
    	var thesisNominationBtn = grid.down('#thesisNominationBtn');
    	var elctionVoterPoolBtn = grid.down('#elctionVoterPoolBtn');
    	var programTransferBtn = grid.down('#studentListProgramTransfer');
    	var applyHoldBtn = grid.down('#applyHoldBtn');
    	var applyForHostelBtn = grid.down('#applyForHostelBtn');
    	var inactiveStudentMoreActionBtn = grid.down('#inactiveStudentMoreActionBtn');
    	var bulkResetPasswordBtn =grid.down("#bulkResetPasswordToAllBtn");
    	var studentSendMSGToAllBtn =grid.down("#studentSendMSGToAllBtn");
    	var scholarshipRaiseRequestBtn = grid.down("#raiseScholarshipRequestId");
    	var pandaDocBtn =grid.down("#pandaDocItemId");
    	var makeAlumniBtn = grid.down('#makeAlumniItemId');
    	var changePrimaryLocationBtn =grid.down("#changePrimaryLocationBtn");
    	var changeSeatTypeIdBtn = grid.down("#changeSeatTypeId");
    	var applyForHostelWaitingListBtn = grid.down('#applyForHostelWaitingListBtn');
    	var changeStartAttendanceDateBtn =  grid.down('#changeStartAttendanceDateBtn');
    	pandaDocBtn.setVisible(false);
     	makeActiveBtn.setVisible(false);
    	sendSurveyBtn.setVisible(false);
    	printIdCardBtn.setVisible(false);
    	sendMessageBtn.setVisible(false);
    	resetButton.setVisible(false);
    	raiseRequest.setVisible(false);
        flagRequest.setVisible(false);   //03/01/23 @manas
    	printIdCardMultipleBtn.setVisible(false);
    	exporetStudentReportBtn.setVisible(false);
    	assignStudentCommitteeBtn.setVisible(false);
    	printStudentCertificate.setVisible(false);
    	printAttestationStatementOfStudentJourney.setVisible(false);
    	bulkDownloadDocBtn.setVisible(false);
    	printProfileBtn.setVisible(false);
    	printProfileAndContractDetailsBtn.setVisible(false);
    	transferCard.setVisible(false);
    	deleteStudentListBtn.setVisible(false);
    	spBtnPrintDocumentsBtn.setVisible(false);
    	spBtnMoreActionsBtn.setVisible(false);
        makeActiveBtn.setVisible(false);
    	printLabelsBtn.setVisible(false);
    	offerLetterDetailsBtn.setVisible(false);
    	printTaxCertificateBtn.setVisible(false);
    	studentlibrarymappingBtn.setVisible(false);
    	studentcategorymappingBtn.setVisible(false);
    	createStudentInAlfrescoBtn.setVisible(false);
    	studentDocumentRequestBtn.setVisible(false);
    	thesisNominationBtn.setVisible(false);
    	studentStatusCSMBtn.setVisible(false);
    	elctionVoterPoolBtn.setVisible(false);
    	programTransferBtn.setVisible(false);
    	applyHoldBtn.setVisible(false);
    	applyForHostelBtn.setVisible(false);
    	inactiveStudentMoreActionBtn.setVisible(false);
    	bulkResetPasswordBtn.setVisible(false);
    	studentSendMSGToAllBtn.setVisible(false);
    	changePrimaryLocationBtn.setVisible(false);
    	scholarshipRaiseRequestBtn.setVisible(false);
    	changeSeatTypeIdBtn.setVisible(false);
    	applyForHostelWaitingListBtn.setVisible(false);
    	changeStartAttendanceDateBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'RESETPASSWORD') {
        		var button = buttonsToolBar.query('#resetButtonItemId')[0];
        		if(!isNullOrEmpty(button)){
        			resetButton.setVisible(true);
        		}        		
        	}
			if (privilege === 'RAISE_FLAG') { 
        		var button = buttonsToolBar.query('#flagRequestButtonItemId')[0];
        		if(!isNullOrEmpty(button)){
        			flagRequest.setVisible(true); //03/01/23 @manas
        		}        		
        	}
    		if (privilege === 'RAISEREQUEST') {
        		var button = buttonsToolBar.query('#raiseRequestButtonItemId')[0];
        		if(!isNullOrEmpty(button)){
        			raiseRequest.setVisible(true);
        		}        		
        	}
    		if (privilege === 'THESIS_NOMINATION') {
        		var button = buttonsToolBar.query('#thesisNominationBtn')[0];
        		if(!isNullOrEmpty(button)){
        			thesisNominationBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'SENDMESSAGE') {
        		var button = buttonsToolBar.query('#sendMessageBtn')[0];
        		if(!isNullOrEmpty(button)){
        			sendMessageBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT') {
        		var button = buttonsToolBar.query('#printIdCardBtn')[0];
        		if(!isNullOrEmpty(button)){
        			printIdCardBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINTMULTIPLEIDCARD') {
        		var button = buttonsToolBar.query('#printIdCardMultipleBtn')[0];
        		if(!isNullOrEmpty(button)){
        			printIdCardMultipleBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'SENDSURVEY') {
        		var button = buttonsToolBar.query('#sendSurveyBtn')[0];
        		if(!isNullOrEmpty(button)){
        			sendSurveyBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ENROLLMENT' || privilege === 'GRADUATION' || privilege === 'STUDENT_DETAILS_REPORT' || privilege === 'STUDENT_DETAILS_REPORT_FOR_SCHOOL' || privilege === 'ENROLLED_COURSES_FORM' || privilege === 'STUDENT_COURSE_ENROLLMENT_FORM'){
  				var button = buttonsToolBar.query('#exporetStudentReport')[0];
  				if(!isNullOrEmpty(button)){
  					exporetStudentReportBtn.setVisible(true);
  				}  
  			}
    		if (privilege === 'ADD_COMMITTEE') {
        		var button = buttonsToolBar.query('#assignStudentCommitteeBtn')[0];
        		if(!isNullOrEmpty(button)){
        			assignStudentCommitteeBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT_CERTIFICATE') {
        		var button = buttonsToolBar.query('#printStudentCertificate')[0];
        		if(!isNullOrEmpty(button)){
        			printStudentCertificate.setVisible(true);
        		}        		
        	}
	       	if (privilege === 'PRINT_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY') {
        		var button = buttonsToolBar.query('#printAttestationStatementOfStudentJourney')[0];
        		if(!isNullOrEmpty(button)){
        			printAttestationStatementOfStudentJourney.setVisible(true);
        		}       
        	} 
    		if (privilege === 'PRINT_PROFILE') {
        		var button = buttonsToolBar.query('#printProfileBtn')[0];
        		if(!isNullOrEmpty(button)){
        			printProfileBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT_PROFILE_AND_CONTRACT_DETAILS') {
        		var button = buttonsToolBar.query('#printProfileAndContractDetailsBtn')[0];
        		if(!isNullOrEmpty(button)){
        			printProfileAndContractDetailsBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT_TRANSFER_CARD') {
        		var button = buttonsToolBar.query('#transferCard')[0];
        		if(!isNullOrEmpty(button)){
        			transferCard.setVisible(true);
        		}        		
        	}
    		if (privilege === 'BULK_APPLICATION_DOCUMENT_DOWNLOAD') {
        		var button = buttonsToolBar.query('#bulkDownloadDocId')[0];
        		if(!isNullOrEmpty(button)){
        			bulkDownloadDocBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'DELETE_LIST') {
        		var button = buttonsToolBar.query('#deleteStudentListBtn')[0];
        		if(!isNullOrEmpty(button)){
        			deleteStudentListBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT_DOCUMENTS') {
        		var button = buttonsToolBar.query('#spBtnPrintDocuments')[0];
        		if(!isNullOrEmpty(button)){
        			spBtnPrintDocumentsBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'MOREACTION') {
        		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
        		if(!isNullOrEmpty(button)){
        			spBtnMoreActionsBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'MAKE_ACTIVE') {
        		var button = buttonsToolBar.query('#makeActiveBtn')[0];
        		if(!isNullOrEmpty(button)){
        			makeActiveBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PRINT_LABELS') {
        		var button = buttonsToolBar.query('#printLabelsBtn')[0];
        		if(!isNullOrEmpty(button)){
        			printLabelsBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'OFFER_LETTER_DETAILS') {
        		if(!isNullOrEmpty(offerLetterDetailsBtn)) {
        			offerLetterDetailsBtn.setVisible(true);
        		}
        	}
    		if (privilege === 'PRINT_TAX_CERTIFICATE') {
        		var button = buttonsToolBar.query('#printTaxCertificate')[0];
        		if(!isNullOrEmpty(button)){
        			printTaxCertificateBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ADD_LIBRARY') {
        		var button = buttonsToolBar.query('#kohastudentlibrarymappingBtn')[0];
        		if(!isNullOrEmpty(button)){
        			studentlibrarymappingBtn.setVisible(true);
        		}        		
        	}
    		if (privilege === 'ADD_PATRON_CATEGORY') {
        		var button = buttonsToolBar.query('#kohastudentcategorymappingBtn')[0];
        		if(!isNullOrEmpty(button)){
        			studentcategorymappingBtn.setVisible(true);
        		}        		
        	}
        	
        	if (privilege === 'CREATE_STUDENT_IN_ALFRESCO') {
    			var button = buttonsToolBar.query('#createStudentInAlfresco')[0];
    			if(!isNullOrEmpty(button)){
    				createStudentInAlfrescoBtn.setVisible(true);
    			}        
    		}
        	if (privilege === 'DOCUMENT_REQUEST') {
    			var button = buttonsToolBar.query('#studentDocumentRequestId')[0];
    			if(!isNullOrEmpty(button)){
    				studentDocumentRequestBtn.setVisible(true);
    			}        
    		}
        	if (privilege === 'STUDENT_STATUS_CSM') {
    			var button = buttonsToolBar.query('#studentStatusCSMBtn')[0];
    			if(!isNullOrEmpty(button)){
    				studentStatusCSMBtn.setVisible(true);
    			}        
    		}
        	if (privilege === 'ADD_TO_VOTER_POOL') {
    			var button = buttonsToolBar.query('#elctionVoterPoolBtn')[0];
    			if(!isNullOrEmpty(button)){
    				elctionVoterPoolBtn.setVisible(true);
    			}        
    		}
        	
        	if (privilege === 'PROGRAM_TRANSFER') {
    			var button = buttonsToolBar.query('#studentListProgramTransfer')[0];
    			if(!isNullOrEmpty(button)){
    				programTransferBtn.setVisible(true);
    			}        
    		}
    		if (privilege === 'APPLY_HOLD') {
    			var button = buttonsToolBar.query('#applyHoldBtn')[0];
    			if(!isNullOrEmpty(button)){
    				applyHoldBtn.setVisible(true);
    			}        
    		}
    		
    		if (privilege === 'APPLY_FOR_HOSTEL') {
    			var button = buttonsToolBar.query('#applyForHostelBtn')[0];
    			if(!isNullOrEmpty(button)){
    				applyForHostelBtn.setVisible(true);
    			}        
    		}
    		
    		if (privilege === 'APPLY_FOR_HOSTEL_WAITING_LIST') {
    			var button = buttonsToolBar.query('#applyForHostelWaitingListBtn')[0];
    			if(!isNullOrEmpty(button)){
    				applyForHostelWaitingListBtn.setVisible(true);
    			}        
    		}
    		
    		if (privilege === 'INACTIVE_STUDENT') {
    			var button = buttonsToolBar.query('#inactiveStudentMoreActionBtn')[0];
    			if(!isNullOrEmpty(button)){
    				inactiveStudentMoreActionBtn.setVisible(true);
    			}        
    		}
    		if (privilege === 'BULK_RESET_PASSWORD') {
    			var button = buttonsToolBar.query('#bulkResetPasswordToAllBtn')[0];
    			if(!isNullOrEmpty(button)){
    				bulkResetPasswordBtn.setVisible(true);
    			}        
    		}
    		if (privilege === 'SEND_MESSAGE_TO_ALL') {
    			var button = buttonsToolBar.query('#studentSendMSGToAllBtn')[0];
    			if(!isNullOrEmpty(button)){
    				studentSendMSGToAllBtn.setVisible(true);
    			}        
    		}
    		if (privilege === 'RAISE_SCHOLARSHIP_REQUEST') {
    			var button = buttonsToolBar.query('#raiseScholarshipRequestId')[0];
    			if(!isNullOrEmpty(button)){
    				scholarshipRaiseRequestBtn.setVisible(true);
    			}        
    		}
    		if (privilege === 'PANDADOC_BTN') {
        		if(!isNullOrEmpty(pandaDocBtn)){
        			pandaDocBtn.setVisible(true);
        		} 
}
	       if (privilege === 'MAKEALUMNI_BTN') {
        		if(!isNullOrEmpty(makeAlumniBtn)){
        			makeAlumniBtn.setVisible(true);
        		}        		
        	}
             if (privilege === 'CHANGE_SEAT_TYPE') {
    			var button = buttonsToolBar.query('#changeSeatTypeId')[0];
    			if(!isNullOrEmpty(button)){
    				changeSeatTypeIdBtn.setVisible(true);
    			}        
    		}
             if (privilege === 'CHANGE_ATTENDANCE_START_DATE') {
     			var button = buttonsToolBar.query('#changeStartAttendanceDateBtn')[0];
     			if(!isNullOrEmpty(button)){
     				changeStartAttendanceDateBtn.setVisible(true);
     			}        
     		}
    	});
    },
    
    disableProgramTransferPivileges: function(windowForm,permissionsMap) {
    	var $this = this;
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var retainStudentData = windowForm.down('#retainStudentDataId');
    	var retainAcademicData = windowForm.down('#retainAcademicDataId');
    	var retainFeeAndPaymentData = windowForm.down('#retainFeeAndPaymentDataId');
    	var retainServiceOpted = windowForm.down('#retainServiceOptedId');
    	var retainExamData = windowForm.down('#retainExamDataId');
    	retainStudentData.setVisible(false);
    	retainAcademicData.setVisible(false);
    	retainFeeAndPaymentData.setVisible(false);
    	retainServiceOpted.setVisible(false);
    	retainExamData.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'RETAIN_STUDENT_DATA') {
        		retainStudentData.setVisible(true);       		
        	}
    		if (privilege === 'RETAIN_ACADEMIC_DATA') {
    			retainAcademicData.setVisible(true);       
    		}
    		if (privilege === 'RETAIN_FEE_AND_PAYMENT_DATA') {
    			retainFeeAndPaymentData.setVisible(true);       
    		}
    		if (privilege === 'RETAIN_SERVICE_OPTED') {
    			retainServiceOpted.setVisible(true);       
    		}
    		if (privilege === 'RETAIN_EXAMINATION_DATA') {
    			retainExamData.setVisible(true);       
    		}
    	});
    },
    
    showStudentBulkPrintWin:function(){
    	var $this = this;
    	var formWindow = $this.getStudentbulkprintwidow();
    	if (!formWindow) {
    		Ext.widget('studentbulkprintwidow');
    		formWindow = $this.getStudentbulkprintwidow();
    	}
    	formWindow.show();
    	
    	var form = $this.getStudentbulkPrintwidow();
		var  templateNameField = form.down("#templateNameStudent");
		
		var store = templateNameField.getStore();
		
		//var store = $this.getStore('setup.templatemapping.TemplateName');
		/*store.getProxy().extraParams = {
			reportTypeId: 7
		};*/
		
		var academyLocationId=$this.getCurrentAcademyLocation();
		store.getProxy().extraParams={
	    	academyLocationId:academyLocationId,
	    	reportType:'Student ID Card'
		};
		
		/*store.on('load', function(){
			for(var i=store.data.items.length-1; i>= 0;i--){
				if(store.data.items[i].data.code == 'Employee Id Card'){
					var rec = store.getAt(i);
					store.remove(rec);
				}
			}
		});*/
		
		store.load();
//	}
    },
    exportIdCardJRXML: function(fileType,grid) {
    	var studentId=0;
    	var admissionId=0;
    	var programBatchSeatConfigId=0;
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
    		var studenttemp=[];
    		var admissiontemp=[];
    		var programBatchSeatConfig=[]

    		for(var i in record){
    			studenttemp.push(record[i].get("ID"));
    			admissiontemp.push(record[i].get("ADMISSION_ID"));
    			programBatchSeatConfig.push(record[i].get("PROGRAM_BATCH_SEAT_CONFIG_ID"));
    		}
    		studentId=studenttemp.join();
    		admissionId=admissiontemp.join();
    		programBatchSeatConfigId = programBatchSeatConfig.join();
    		user=this.getCurrentlyLoggedInUser();
    		// code to identify jasper
    		var form = this.getStudentbulkPrintwidow().getForm();
    		var templateName = form.findField('templateNameStudent').getValue();
//  		var code ="ID_CARD_BACK";
    		var reportParams =new Object();
    		reportParams.userId=user.code;
    		reportParams.ids=String(studentId); // convert int into string
    		reportParams.admissionIds=String(admissionId);
    		reportParams.programBatchSeatConfigId=String(programBatchSeatConfigId);
    		var reportTitle=getFeeAndPaymentCommonTranslation('ID_CARD');
    		var exportUrl = SERVERURL.ID_CARD_PDF;
    		if(templateName.indexOf("_PROCEDURE")>-1){
    			var exportUrl ="rest/ReportDocumentResource/exportReportMultiplePdf";
    		}else{
    			var exportUrl = SERVERURL.ID_CARD_PDF;
    		}
    		this.exportJRXMLReport(templateName,reportParams,reportTitle,fileType,exportUrl);
    		this.getStudentbulkprintwidow().close();
    	}
    },
    showStudenttransfercardwindow:function(obj){
    	var $this = this;
    	var formWindow = $this.getStudenttransfercardwindow();
    	if (!formWindow) {
    		Ext.widget('studenttransfercardwindow');
    		formWindow = $this.getStudenttransfercardwindow();
    	}
    	
    	var form = $this.getStudenttransfercardwindow();
		var templateNameField = form.down("#studentTransferCard");
		
		var store = templateNameField.getStore();
		
		var academyLocationId=$this.getCurrentAcademyLocation();
		store.getProxy().extraParams={
	    	academyLocationId:academyLocationId,
	    	reportType:'Transfer Cards'
		};
		
		store.load();
		
		store.load({
			callback: function(records, options, success) {
	        if(records.length>0){
				formWindow.show();
			}else{
				$this.printProfileStudent(obj);
			} 
			}
	    });
		
//	}
    },
    exportTransferCardJRXML: function(fileType,grid) {
    	var studentId=0;
    	var admissionId=0;
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
    		var studenttemp=[];
    		var admissiontemp=[];

    		for(var i in record){
    			studenttemp.push(record[i].get("ID"));
    		}
    		studentId=studenttemp.join();

    		user=this.getCurrentlyLoggedInUser();
    		// code to identify jasper
    		var form = this.getStudenttransfercardwindow();
    		var templateName = form.down('#studentTransferCard').getValue();
//  		var code ="ID_CARD_BACK";
    		var reportParams =new Object();
    		reportParams.userId=user.code;
    		reportParams.ids=String(studentId); // convert int into string
    		var reportTitle='TransferCard';
    		var exportUrl = "rest/student/TransferCardForStudentCommon";
    		this.exportJRXMLReport(templateName,reportParams,reportTitle,fileType,exportUrl);
    		form.close();
    	}
    },
    printProfileStudent:function(obj){
		var  $this = this;
		var grid = $this.getSearchResultGrid();
		var record = grid.getSelectionModel().getSelection();
		var academyLocationId=$this.getCurrentAcademyLocation();
		if (grid.getSelectionModel().getCount() > 0) {
			var record = grid.getSelectionModel().getSelection();
			var studenttemp=[];
			var admissionTemp=[];
			var isInctiveCheck=false;
			for(var i in record){
				studenttemp.push(record[i].get("ID"));
				admissionTemp.push(record[i].get("ADMISSION_ID"))
			}
			studentId=studenttemp.join();
			admissionIds=admissionTemp.join();
			if(record[i].get("STATUS")=='Inactive') {
				isInctiveCheck=true;
			}
			$this.printProfileStudentCommon(obj,studentId,isInctiveCheck,admissionIds);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}  

	
    },
    inactiveStudentRecords:function(obj){
		var  $this = this;
		var grid = $this.getSearchResultGrid();
		var record = grid.getSelectionModel().getSelection();
		if (grid.getSelectionModel().getCount() > 0) {
			var record = grid.getSelectionModel().getSelection();
			var studenttemp=[];
			var admissionTemp=[];
			var isInctiveCheck=false;
			for(var i in record){
				studenttemp.push(record[i].get("ID"));
				admissionTemp.push(record[i].get("ADMISSION_ID"))
			}
			        var jsonData = []; 	
					var studentIds=studenttemp.join();
					var admissionIds=admissionTemp.join();
			    	var requestJSON = {};
			    	requestJSON.admissionsIds = admissionIds;
			    	requestJSON.studentIds = studentIds;
			showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONFIRM_MSG_ACTION'),
					function(btn, text) {
				if (btn == 'yes'){
			submitUrl = SERVERURL.PATH_INACTIVE_STUDENT_RECORDS;
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	 		Ext.Ajax.request({
	 			type: 'rest',
	 			url : submitUrl,
	 			method : 'POST',
	 			headers: {
                    'Content-Type': 'application/json'
                },
				jsonData : requestJSON,
	 			success : function(form, action) {
	 				Ext.getBody().unmask();
	 				var resp = Ext.JSON.decode(form.responseText);
					if(resp==true){
	 				showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('INACTIVE_STUDENT_SUCCESS'));
	 				grid.getStore().reload();
					}
					else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CONTACT_ADMIN_MESSAGE'));
					}
	 			}
	 		});
				}
				});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}  

	
    },
    printProfileBtnStudent:function(obj){
		var $this = this;
		var grid = $this.getSearchResultGrid();
		var record = grid.getSelectionModel().getSelection();
		var academyLocationId=$this.getCurrentAcademyLocation();
		if (grid.getSelectionModel().getCount() > 0) {
			var record = grid.getSelectionModel().getSelection();
			var studenttemp=[];
			var admissionTemp=[];
			var programBatchStudentTemp=[];
			var isInctiveCheck=false;
			for(var i in record){
				studenttemp.push(record[i].get("ID"));
				admissionTemp.push(record[i].get("ADMISSION_ID"));
				programBatchStudentTemp.push(record[i].get("PROGRAM_BATCH_STUDENT_ID"));
			}
			studentId=studenttemp.join();
			admissionIds = admissionTemp.join();
			programBatchStudentIds = programBatchStudentTemp.join();
			if(record[i].get("STATUS")=='Inactive') {
				isInctiveCheck=true;
			}
			
			var formWindow = $this.getStudentprintprofilewindow();
        	if (!formWindow) {
        		Ext.widget('studentprintprofilewindow');
        		formWindow = $this.getStudentprintprofilewindow();
        	}
        	var templateField = formWindow.down("#studentPrintProfil");
        	var isSingleStudent = formWindow.down("#isSingleStudent");
        	isSingleStudent.setValue('false');
        	var store = Ext.create('Academia.store.setup.templatemapping.TemplateNameListStudentByCode');
        	
        	store.getProxy().extraParams={
    	    	academyLocationId:academyLocationId,
    	    	reportType:'Basic Reports',
    	    	templateName:'RGI_STUDENT_CONFIRMATION_FORM'
    		};
        	
        	store.load({
    			callback: function(records, options, success) {
	    	        if(records.length>0){
	    	        	var  templateStore = templateField.getStore();
	    	        	templateStore.removeAll();
                        templateStore.clearData();
                    	templateStore.add({
	    	                 code:  'Print Profile',
	    	                 value: 'PRINT_PROFILE'
	    	             });
	    	        	templateStore.add({
	    	        		code: records[0].data.code,
	    	        		value: records[0].data.value
	    	            });
	    				formWindow.show();
	    			}else{
	    				$this.printProfileStudentCommon(obj,studentId,isInctiveCheck,admissionIds);
	    			} 
    			}
    	    });
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}  

	
    },
    printProfileStudentCommon:function(obj,studentId,isInctiveCheck,admissionIds){
		var  $this = this;
		var bulkProfilePrint=false;
		if(obj.itemId=="transferCard")
		{
			var profilePrintURL = SERVERURL.PATH_FIND_TRANSFER_CARD_FOR_STUDENT;
		}else
		{
			var profilePrintURL ="rest/student/bulkStudentProfilePrintingoptimized";
			bulkProfilePrint=true;
		}
		var csvForm = Ext.create('Ext.form.Panel'); 
		if(!isNullOrEmpty(bulkProfilePrint) && bulkProfilePrint==true){
			csvForm.getForm().submit({
				target: '_blank',
				method:'POST',
				params :{
					access_token : Ext.Ajax.defaultHeaders.access_token,
					studentIdsCommaSeperated : studentId,
					isInctiveCheck : isInctiveCheck,
					admissionIdsCommaSeperated :admissionIds,
					programBatchStudentIdsCommaSeperated : programBatchStudentIds
				},
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				url: profilePrintURL,
				standardSubmit :true
			});	
		}else {
		csvForm.getForm().submit({
			target: '_blank',
			method:'POST',
			params :{
				access_token : Ext.Ajax.defaultHeaders.access_token,
				studentIdsCommaSeperated : studentId,
				admissionIdsCommaSeperated :admissionIds
			},
			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			url: profilePrintURL,
			standardSubmit :true
		});	
		}
    },
    exportProfilePrintReport:function(obj){
    	var  $this = this;
    	var templateCode = 'RGI_STUDENT_CONFIRMATION_FORM';
    	var formWindow = $this.getStudentprintprofilewindow();
		var isSingleStudent = formWindow.down("#isSingleStudent");
		var templateField = formWindow.down("#studentPrintProfil");
		
		if(templateField.getValue()==templateCode){
			var confirmationPath = SERVERURL.PATH_STUDENT_CONFIRMATION_FORM;
			var reportParams =new Object();
			reportParams.reportTitle=templateCode;
	     	reportParams.code = templateCode;
	     	if(isSingleStudent.getValue()=='true'){
				var contentPanel=$this.getContentPanel();
				var studentId=contentPanel.getActiveTab().userId;
	     	    reportParams.STUDENT_IDS=studentId;
	     	    var isInctiveCheck = false;
	     	    if(!isNullOrEmpty(contentPanel.getActiveTab().personInfo) && !isNullOrEmpty(contentPanel.getActiveTab().personInfo.status)) {
	     	    	if(contentPanel.getActiveTab().personInfo.status=='Inactive') {
	     	    		isInctiveCheck=true;
	     	    	}
	     	    }
	     	   reportParams.isInctiveCheck=isInctiveCheck;
			}else{
				var grid = $this.getSearchResultGrid();
				var record = grid.getSelectionModel().getSelection();
				var academyLocationId=$this.getCurrentAcademyLocation();
				var record = grid.getSelectionModel().getSelection();
				var studenttemp=[];
				var admissionTemp=[];
				for(var i in record){
					studenttemp.push(record[i].get("ID"));
					admissionTemp.push(record[i].get("ADMISSION_ID"));
				}
				var studentId=studenttemp.join();
				var admissionIds = admissionTemp.join();
	     	    reportParams.STUDENT_IDS=studentId;
	     	    var isInctiveCheck = false;
	     	    if(record[i].get("STATUS")=='Inactive') {
	     	    	isInctiveCheck=true;
				} 
	     	    reportParams.isInctiveCheck=isInctiveCheck;
			}
	     	this.exportJRXMLReport(templateCode,reportParams,reportParams.reportTitle,'.pdf',confirmationPath);
     	    formWindow.close();
		}else{
			if(isSingleStudent.getValue()=='true'){
				$this.printButtonAction(obj);
			}else{
				var grid = $this.getSearchResultGrid();
				var record = grid.getSelectionModel().getSelection();
				var academyLocationId=$this.getCurrentAcademyLocation();
				var record = grid.getSelectionModel().getSelection();
				var studenttemp=[];
				var admissionTemp=[];
				var isInctiveCheck=false;
				for(var i in record){
					studenttemp.push(record[i].get("ID"));
					admissionTemp.push(record[i].get("ADMISSION_ID"));
				}
				var studentId=studenttemp.join();
				var admissionIds = admissionTemp.join();
				if(record[i].get("STATUS")=='Inactive') {
					isInctiveCheck=true;
				} 
				$this.printProfileStudentCommon(obj,studentId,isInctiveCheck,admissionIds);
			}
			 formWindow.close();
		}
		
    },
    sendSurveyDetails:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();
   
    	var form = $this.getStudentSendsurvey().getForm();
    	var surveyId = form.findField('survey').getValue();
    	var surveyUrl = form.findField('survey').getRawValue();

    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		
    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"surveyMaster" : $this.getIdValueJson(surveyId),
//  				"userId":selected[i].data.ID,
    				"surveyUrl" : surveyUrl, //+ '&userId=' + selected[i].data.ID,
    				"applicant": null,
    				"student": $this.getIdValueJson(selected[i].data.ID),
    				"enquiry": null,
    				"user" : null,
    				"userType":"STUDENT"

    			});
    		}
    	}
    	submitUrl = SERVERURL.SEND_SURVEY;
 		Ext.Ajax.request({
 			type : 'rest',
 			url : submitUrl,
 			jsonData : jsonData,
 			method : 'POST',
 			success : function(form, action) {
 				showSuccessMessage(getCommonTranslation('SEND_SURVEY'),getCommonTranslation('SUCCESS'));
 				grid.getStore().reload();
// 				$this.getStudentsendsurvey().close();
 				obj.up('window').close();
 			}
 		});
    },saveLibraryDetails:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getKohastudentlibrarymappingwin();
    	var libraryId = form.down('#library');
        var arrayOfData = form.down('#library').getStore().data.items;
        var academyLocKohaBranchId = null;
    	for(var i = 0; i < arrayOfData.length ; i++)
		{
			if(arrayOfData[i].data.id === libraryId.value)
			{
				academyLocKohaBranchId = arrayOfData[i].data.academicTermId;
			}
		}
    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){

    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"student": $this.getIdValueJson(selected[i].data.ID),
    				"libraryId":libraryId.value,
    				"userType":"STUDENT",
    				"academyLocKohaBranchId":academyLocKohaBranchId
    			});
    		}
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	checkMappingUrl = SERVERURL.MAP_LIBRARY_WITH_STUDENT_AND_EMPLOYEE;		
    	submitUrl = SERVERURL.MAP_LIBRARIES;
    	//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : checkMappingUrl,
    		jsonData : jsonData,
    		method : 'POST',
    		success : function(form, action) {
    			if(form.responseText=="DEPENDENCY_EXISTS"){
    				showConfirmMessage(getCommonTranslation('MAP_LIBRARY'),getCommonTranslation('LIBRARY_STUDENT_ALREADY_MAPPED_MESSAGE'), function(btn, text) {
    					if (btn == 'yes') {
    						Ext.Ajax.request({
    							type : 'rest',
    							url : submitUrl,
    							jsonData : jsonData,
    							method : 'POST',
    							success : function(form, action) {
    								showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('LIBRARY_STUDENT_MAPPED_SUCCESS_MESSAGE'));

    							}
    						});
    					}
    				});
    			}else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : jsonData,
    					method : 'POST',
    					success : function(form, action) {
    						showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('LIBRARY_STUDENT_MAPPED_SUCCESS_MESSAGE'));

    					}
    				});
    			}
    			grid.getStore().reload();
//  			$this.getStudentsendsurvey().close();
    			obj.up('window').close();
    		}
    	});
    	Ext.getBody().unmask();
    },
    saveStudentStatusCSM:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getStudentstatuscsmwindow();
    	var studentStatusCSMCombo = form.down('#studentStatusItemId');
    	var studentStatusRecord = studentStatusCSMCombo.lastSelection[0];

    	var jsonData = [];
    	var selectedStudentAndAdmissionIds = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push(selected[i].data.ADMISSION_ID);
    			selectedStudentAndAdmissionIds.push({
    				studentId:selected[i].data.USER_ID,
    				admissionId:selected[i].data.ADMISSION_ID})
    				
    			}
    		}
    	
    	var requestJSON = {};
    	requestJSON.studentPersonIds = jsonData;
    	requestJSON.studentStatusId = studentStatusCSMCombo.value;
    	requestJSON.studentStatusValue = studentStatusRecord.data.code;
    	requestJSON.studentAndAdmissionIds=selectedStudentAndAdmissionIds;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	submitUrl = SERVERURL.SAVE_STUDENT_STATUS_CSM;	
		
    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : requestJSON,
    		method : 'POST',
    		success : function(form, action) {
    			var data = Ext.JSON.decode(form.responseText);
    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
    			grid.getStore().reload();
    			obj.up('window').close();
    			Ext.getBody().unmask();
    		}
    	});
    },
    saveElectionVoterPool:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getVoterpoolwindow();
    	var studentStatusCSMCombo = form.down('#voterPoolItemId');
    	var json= new Object;
    	var jsonData = [];
    	var admissionjsonData = [];
    	var admissionjsonData = [];
    	var programjsonData = [];
    	var batchjsonData = [];
    	var electionVoeterpool;
    	var programBatchSeatConfigurationData = [];
    	var selected = grid.selModel.getSelection();
    	var recommendationArr = new Array();
    	if( selected.length > 0){
    		for( var i = 0; i < selected.length; i++) {
    			json = {
	   					//"electionCode":formValue.electionCode,
	   					"admission":$this.getIdValueJson(selected[i].data.ADMISSION_ID),
	   					"program":$this.getIdValueJson(selected[i].data.PROGRAM_ID),
	   					"batch":$this.getIdValueJson(selected[i].data.PROGRAM_BATCH_ID),
	   					"programBatchSeatConfiguration":$this.getIdValueJson(selected[i].data.PROGRAM_BATCH_SEAT_CONFIG_ID),
	   					"person":$this.getIdValueJson(selected[i].data.PERSON_ID),
	   					"electionId":studentStatusCSMCombo.value
	   					
	   			};
    			jsonData.push(json);
    		/*	
    			electionVoeterpool.jsonData.push(selected[i].data.PERSON_ID);
    			electionVoeterpool.admissionjsonData.push(selected[i].data.ADMISSION_ID);
    			electionVoeterpool.programjsonData.push(selected[i].data.PROGRAM_ID);
    			electionVoeterpool.batchjsonData.push(selected[i].data.PROGRAM_BATCH_ID);
    			electionVoeterpool.programBatchSeatConfigurationData.push(selected[i].data.PROGRAM_BATCH_SEAT_CONFIG_ID);
    		*/}
    	}
    	var requestJSON = {};
    	requestJSON=jsonData;
    	/*requestJSON.personId = jsonData;
    	requestJSON.admissionId = admissionjsonData;
    	requestJSON.programId = programjsonData;
    	requestJSON.batchId = electionVoeterpool;
    	requestJSON.seatTypeId = programBatchSeatConfigurationData;
    	requestJSON.electionId = studentStatusCSMCombo.value;
    	*/
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	submitUrl = SERVERURL.PATH_ELECTION_VOTER_FIND_POOL_ADD;	
    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : requestJSON,
    		method : 'POST',
    		success : function(form, action) {
    		//	var data = Ext.JSON.decode(form.responseText);
    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
    			grid.getStore().reload();
    			obj.up('window').close();
    			Ext.getBody().unmask();
    		}
    	});
    },
    saveCategoryDetails:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getKohastudentcategorymappingwin();
    	var categoryId = form.down('#category');
        var arrayOfData = form.down('#category').getStore().data.items;
    	var academyLocKohaCategoriesId = null;
    	for(var i = 0; i < arrayOfData.length ; i++)
		{
			if(arrayOfData[i].data.id === categoryId.value)
			{
				academyLocKohaCategoriesId = arrayOfData[i].data.academicTermId;
			}
		}
    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){

    		for( var i = 0; i < selected.length; i++) {
    			jsonData.push({
    				"id":selected[i].data.ID,
    				"student": $this.getIdValueJson(selected[i].data.ID),
    				"categoryId":categoryId.value,
    				"userType":"STUDENT",
    				"academyLocKohaCategoriesId":academyLocKohaCategoriesId
    			});
    		}
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	checkMappingUrl = SERVERURL.MAP_CATEGORY_WITH_STUDENT_AND_EMPLOYEE;
    	submitUrl = SERVERURL.MAP_CATEGORIES;	
    	//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : checkMappingUrl,
    		jsonData : jsonData,
    		method : 'POST',
    		success : function(form, action) {
    			if(form.responseText=="DEPENDENCY_EXISTS"){
    				showConfirmMessage(getCommonTranslation('MAP_PATRON_CATEGORY'),getCommonTranslation('CATEGORY_STUDENT_ALREADY_MAPPED_MESSAGE'), function(btn, text) {
    					if (btn == 'yes') {
    						Ext.Ajax.request({
    							type : 'rest',
    							url : submitUrl,
    							jsonData : jsonData,
    							method : 'POST',
    							success : function(form, action) {
    								showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('CATEGORY_STUDENT_MAPPED_SUCCESS_MESSAGE'));

    							}
    						});
    					}
    				});
    			}else{
    				Ext.Ajax.request({
    					type : 'rest',
    					url : submitUrl,
    					jsonData : jsonData,
    					method : 'POST',
    					success : function(form, action) {
    						showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('LIBRARY_STUDENT_MAPPED_SUCCESS_MESSAGE'));

    					}
    				});
    			}
    			grid.getStore().reload();
//  			$this.getStudentsendsurvey().close();
    			obj.up('window').close();
    		}
    	});
    	Ext.getBody().unmask();
    },
    getIdValueJson: function(id, value,code) {
    	if (id) return {
    		id: id,
    		value: value,
    		code: code
    	};
    },
    
    /** Download upload relationship form change **/
    downloadUploadRelationshipChange:function(cb, nv, ov){
    	var $this = this;
    	var uploadForm = $this.getStudentrelationshipuploadform();
    	var downLoadForm = $this.getStudentrelationshipdownloadform();
    	var grid = $this.getImportrelationshiplist();
    	if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    		uploadForm.hide();
    		downLoadForm.show();
    		grid.setVisible(false);
		}else{
			$this.doAccessControlValidationForLoader(uploadForm,this.getCORE_ERP_LOADER_PERMISSIONS());
    		var uploadoptionradiogroupform  = $this.getStudentRelationshipuploadoptionradiogroup();
    		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    			isUploadAll: false
    		});
    		//$this.onChangeUploadOptionRadioGroup(false,grid, 'IMPORT_BULK_STUDENT_RELATIONSHIP_UPLOAD');
			downLoadForm.hide();
			uploadForm.show();
			grid.setVisible(true);
		}
    },
    
    
    /** Download upload form change **/

	downloadUploadFormChange : function(cb, nv, ov){
		var $this = this;
		//var mainStruct = this.getStudentattendanceuploaddownloadstructure();
		var downloadTemplateForm = this.getStudentdownloadform();
		var uploadTemplateForm = this.getStudentuploadform();
		var grid = $this.getImportstudentlist()
		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			//Ext.ComponentQuery.query('uploadattendanceform#uploadattendanceformId')[0].hide();
			//Ext.ComponentQuery.query('studentattendance#studentattendanceId')[0].show();

			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			grid.setVisible(false);

			/*downloadTemplateForm.down("#voucherMode").reset();
			downloadTemplateForm.down('#autoSettlementType').reset();
			downloadTemplateForm.down("#raiseBillType").reset();
			downloadTemplateForm.down("#receiptForm").reset();*/

		}else{
			//uploadTemplateForm.reset();
			//Ext.ComponentQuery.query('uploadattendanceform#uploadattendanceformId')[0].show();
			//Ext.ComponentQuery.query('studentattendance#studentattendanceId')[0].hide();
    		$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			var uploadoptionradiogroupform  = $this.getStudentuploadformuploadoptionradiogroup();
  			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  				isUploadAll: false
  			});
			downloadTemplateForm.hide();
			grid.setVisible(true);
			uploadTemplateForm.show();
			//uploadTemplateForm.down("#moduleName").reset();
			//uploadTemplateForm.down("#uploadFileField").reset();
		}
	},
	
	/** Download upload Education History form change **/
    downloadUploadEducationHistoryChange:function(cb, nv, ov){
    	var $this = this;
    	var uploadForm = $this.getEducationhistoryuploadform();
    	var downLoadForm = $this.getEducationhistorydownloadform();
    	var grid = $this.getImporteducationhistorylist();
    	if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    		uploadForm.hide();
    		downLoadForm.show();
    		grid.setVisible(false);
    	}else{
    		$this.doAccessControlValidationForLoader(uploadForm,this.getCORE_ERP_LOADER_PERMISSIONS());
    		var uploadoptionradiogroupform  = $this.getStudentPastHistoryuploadoptionradiogroup();
    		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    			isUploadAll: false
    		});
			downLoadForm.hide();
			uploadForm.show();
			grid.setVisible(true);
			uploadForm.down("#uploadFileField").reset();
		}
    },
	
	/**
	    * Add multiple prograbatchperiod filter in panel
	    */
   addMultipleProgramBatchfilter:function(obj){
	   	   var $this = this;
	   	   var stopContiner = $this.getStudentdownloadform().down('#programBatchContainerId');
	   	  // var timeFieldsCount = stopContiner.items.length;
	   	   var panelItem = new Array();
	   	   var fieldContainer=obj.up('fieldcontainer');
	   	   var newcont=stopContiner.items.items.length;
		   var insertPosition=newcont+1;
	   	   panelItem.push({
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign: 'top'
				},
				items : [{
					xtype: 'customcombobox',
	                name: 'PROGRAM_NAME',
	                itemId: 'program' + insertPosition,
	                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	                valueField: 'id',
	                displayField: 'valueCode',
	                width:410,
	                minChars:3,
	                queryParam:'programName',
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                listeners: {
	                    render: function(combo) {
	                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
	                        combo.bindStore(store);
	                        
	                        var academyLocationId = $this.getCurrentAcademyLocation();
                          	store.proxy.extraParams = {
         							 academyLocationId : academyLocationId
         					};
                          	store.load();	
	                    },
	                    select:function(obj,record){
	                    	                    	
	                    	var programId = record[0].get("id");
	                    	var  batch = obj.nextSibling();
	                    	var  period = batch.nextSibling();
	                    	var  section = period.nextSibling();
	                    	
	                    	batch.setDisabled(false);
	                    	batch.reset();
	                    	
	                    	period.setDisabled(true);
	                    	period.reset();
	                    	
	                    	section.setDisabled(true);
	                    	section.reset();
	                    	
	                    	var store = batch.getStore();
	                    	
                          	store.proxy.extraParams = {
         							 id : programId
         					};
                          	store.load();	                    	
	                    }
	                },
	                listConfig: {
    	 				listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	 				loadingText: getCommonTranslation('SEARCHING'),
    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	 				getInnerTpl: function() {
    	 					return '<div class="search-item">' +
    	 					'{value}' +
    	 					'</div>';
    	 				}
    	 			}
				},{
					xtype: 'customcombobox',
	                name: 'BATCH_NAME',
	                itemId: 'batch' + insertPosition,
	                fieldLabel: getPersonModuleTranslation('BATCH'),
	                disabled:true,
	                editable: false,
	                queryMode: 'local',
	                displayField: 'value',
	                valueField: 'id',
	                listeners: {
	                    render: function(combo) {
	                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
	                        combo.bindStore(store);
	                    },
	                    select:function(obj,record){
	                    	var batchId = record[0].get("id");
	                    	var  period = obj.nextSibling();
	                    	var  section = period.nextSibling();
	                    	
	                    	period.setDisabled(false);
	                    	period.reset();
	                    	
	                    	section.setDisabled(true);
	                    	section.reset();
	                    	
	                    	var store = period.getStore();
	                    	
                          	store.proxy.extraParams = {
         							 id : batchId
         					};
                          	store.load();
	                    	
	                    }
	                }
				},{
					xtype: 'customcombobox',
	                itemId:'period'+ insertPosition,
	                disabled:true,
	                editable: false,
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                fieldLabel: getPersonModuleTranslation('PERIOD'),
	                name: 'PERIOD_NAME',
	                listeners: {
	                    render: function(combo) {
	                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                        combo.bindStore(store);
	                    },
	                    select:function(obj,record){
	                    	var periodId = record[0].get("id");
	                    	var  section = obj.nextSibling();
	                    	
	                    	section.setDisabled(false);
	                    	section.reset();
	                    	
	                    	var store = section.getStore();
	                    	
                          	store.proxy.extraParams = {
                          			periodId : periodId
         					};
                          	store.load();
	                    	
	                    }
	                }
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					width: 226,
					labelAlign: 'top',
					name : 'sectionId',
					itemId : 'programCoursection_ID' + insertPosition,
					store:'attendance.SectionAndFacultyByPeriodID',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					disabled:true,
					forceSelection : true,
					listeners: {
						render: function(combo) {
		                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
		                    combo.bindStore(store);
						}}
				},{
					xtype: 'button',
					itemId: 'delFilterBtn',
					cls: 'CustomBodyBtnReject',
					glyph: ICONGLYPH.DELETEGLYPH,
					tooltip: getCommonTranslation('DELETE'),
					style:{
						marginTop:'30px'
					},
					listeners:{
						click:function(obj){
						   var container = obj.up('fieldcontainer');
	   					   var panelContiner = $this.getStudentdownloadform().down('#programBatchContainerId');
	   					   panelContiner.remove(container);
					}}
				},{
					xtype: 'button',
					itemId: 'addFilterBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				  }]
				});
	     	stopContiner.insert(insertPosition,panelItem);
	     	stopContiner.doLayout();
	      },
	      
	      
	      /***
	       * Multi select filter for student relationship loader.
	       */
	      addStudentRelationshipMultipleProgramBatchfilter:function(obj){
		   	   var $this = this;
		   	   var stopContiner = $this.getStudentrelationshipdownloadform().down('#programBatchContainerId');
		   	  // var timeFieldsCount = stopContiner.items.length;
		   	   var panelItem = new Array();
		   	   var fieldContainer=obj.up('fieldcontainer');
		   	   var newcont=stopContiner.items.items.length;
			   var insertPosition=newcont+1;
		   	   panelItem.push({
					xtype : 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype: 'customcombobox',
		                name: 'PROGRAM_NAME',
		                itemId: 'program' + insertPosition,
		                fieldLabel: getPersonModuleTranslation('PROGRAM'),
		                valueField: 'id',
		                displayField: 'valueCode',
		                width:410,
		                allowBlank:false,
		                minChars:3,
		                queryParam:'programName',
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
		                        combo.bindStore(store);
		                        
		                        var academyLocationId = $this.getCurrentAcademyLocation();
	                          	store.proxy.extraParams = {
	         							 academyLocationId : academyLocationId
	         					};
	                          	store.load();
	                          	$this.setAllowBlank(combo,false);
		                    },
		                    select:function(obj,record){
		                    	                    	
		                    	var programId = record[0].get("id");
		                    	var  batch = obj.nextSibling();
		                    	var  period = batch.nextSibling();
		                    	var  section = period.nextSibling();
		                    	
		                    	batch.setDisabled(false);
		                    	batch.reset();
		                    	
		                    	period.setDisabled(true);
		                    	period.reset();
		                    	
		                    	section.setDisabled(true);
		                    	section.reset();
		                    	
		                    	var store = batch.getStore();
		                    	
	                          	store.proxy.extraParams = {
	         							 id : programId
	         					};
	                          	store.load();	                    	
		                    }
		                },
		                listConfig: {
	    	 				listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	 				loadingText: getCommonTranslation('SEARCHING'),
	    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	 				getInnerTpl: function() {
	    	 					return '<div class="search-item">' +
	    	 					'{value}' +
	    	 					'</div>';
	    	 				}
	    	 			}
					},{
						xtype: 'customcombobox',
		                name: 'BATCH_NAME',
		                itemId: 'batch' + insertPosition,
		                fieldLabel: getPersonModuleTranslation('BATCH'),
		                disabled:true,
		                editable: false,
		                allowBlank:false,
		                width:226,
		                queryMode: 'local',
		                displayField: 'value',
		                valueField: 'id',
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                        combo.bindStore(store);
		                        $this.setAllowBlank(combo,false);
		                    },
		                    select:function(obj,record){
								var batchId = record[0].get("id");
								var  period = obj.nextSibling();
								var  section = period.nextSibling();

								period.setDisabled(false);
								period.reset();

								section.setDisabled(true);
								section.reset();

								var store = period.getStore();

								store.proxy.extraParams = {
										id : batchId
								};
								store.load();

							}
		                }
					},
					{
						xtype: 'customcombobox',
		                itemId:'period' + insertPosition,
		                disabled:true,
		                editable: false,
		                displayField: 'value',
		                valueField: 'id',
		                queryMode: 'local',
		                //hidden:true,
		                fieldLabel: getPersonModuleTranslation('PERIOD'),
		                name: 'PERIOD_NAME',
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		                        combo.bindStore(store);
		                    },
		                    select:function(obj,record){
								var periodId = record[0].get("id");
								var  section = obj.nextSibling();

								section.setDisabled(false);
								section.reset();

								var store = section.getStore();

								store.proxy.extraParams = {
										periodId : periodId
								};
								store.load();

							}
		                }
					},{
						xtype : 'customcombobox',
						fieldLabel : getCourseTxCommonTranslation('SECTION'),
						width: 226,
						labelAlign: 'top',
						name : 'section',
						//itemId : 'sectionId' + insertPosition,
						itemId : 'programCoursection_ID' + insertPosition,
						//hidden:true,
						//store:'attendance.SectionAndFacultyByPeriodID',
						displayField : 'sectionCode',
						valueField : 'sectionId',
						typeAhead : true,
						disabled:true,
						forceSelection : true,
						listeners: {
							render: function(combo) {
			                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
			                    combo.bindStore(store);
							}
						}
					}, {
						xtype: 'button',
						itemId: 'delFilterBtn',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip: getCommonTranslation('DELETE'),
						style:{
							marginTop:'30px'
						},
						listeners:{
							click:function(obj){
							   var container = obj.up('fieldcontainer');
		   					   var panelContiner = $this.getStudentrelationshipdownloadform().down('#programBatchContainerId');
		   					   panelContiner.remove(container);
						}}
					},{
						xtype: 'button',
						itemId: 'addFilterBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					  }]
					});
		     	stopContiner.insert(insertPosition,panelItem);
		     	stopContiner.doLayout();
		      },
		      
		      
		      /***
		       * Multi select filter for Education History loader.
		       */
		      addEducationHistoryMultipleProgramBatchfilter:function(obj){
			   	   var $this = this;
			   	   var stopContiner = $this.getEducationhistorydownloadform().down('#programBatchContainerId');
			   	  // var timeFieldsCount = stopContiner.items.length;
			   	   var panelItem = new Array();
			   	   var fieldContainer=obj.up('fieldcontainer');
			   	   var newcont=stopContiner.items.items.length;
				   var insertPosition=newcont+1;
			   	   panelItem.push({
						xtype : 'fieldcontainer',
						width: '100%',
						layout : 'hbox',
						defaults: {
							labelAlign: 'top'
						},
						items : [{
							xtype: 'customcombobox',
			                name: 'PROGRAM_NAME',
			                itemId: 'program' + insertPosition,
			                fieldLabel: getPersonModuleTranslation('PROGRAM'),
			                valueField: 'id',
			                displayField: 'valueCode',
			                width:410,
			                minChars:3,
			                queryParam:'programName',
			                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			                listeners: {
			                    render: function(combo) {
			                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
			                        combo.bindStore(store);
			                        
			                        var academyLocationId = $this.getCurrentAcademyLocation();
		                          	store.proxy.extraParams = {
		         							 academyLocationId : academyLocationId
		         					};
		                          	store.load();	
			                    },
			                    select:function(obj,record){
			                    	                    	
			                    	var programId = record[0].get("id");
			                    	var  batch = obj.nextSibling();
			                    	var  period = batch.nextSibling();
			                    	var  section = period.nextSibling();
			                    	
			                    	batch.setDisabled(false);
			                    	batch.reset();
			                    	
			                    	period.setDisabled(true);
			                    	period.reset();
			                    	
			                    	section.setDisabled(true);
			                    	section.reset();
			                    	
			                    	var store = batch.getStore();
			                    	
		                          	store.proxy.extraParams = {
		         							 id : programId
		         					};
		                          	store.load();	                    	
			                    }
			                },
			                listConfig: {
		    	 				listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	 				loadingText: getCommonTranslation('SEARCHING'),
		    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	 				getInnerTpl: function() {
		    	 					return '<div class="search-item">' +
		    	 					'{value}' +
		    	 					'</div>';
		    	 				}
		    	 			}
						},{
							xtype: 'customcombobox',
			                name: 'BATCH_NAME',
			                itemId: 'batch' + insertPosition,
			                fieldLabel: getPersonModuleTranslation('BATCH'),
			                disabled:true,
			                editable: false,
			                queryMode: 'local',
			                displayField: 'value',
			                valueField: 'id',
			                listeners: {
			                    render: function(combo) {
			                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
			                        combo.bindStore(store);
			                    },
			                    select:function(obj,record){
			                    	var batchId = record[0].get("id");
			                    	var  period = obj.nextSibling();
			                    	var  section = period.nextSibling();
			                    	
			                    	period.setDisabled(false);
			                    	period.reset();
			                    	
			                    	section.setDisabled(true);
			                    	section.reset();
			                    	
			                    	var store = period.getStore();
			                    	
		                          	store.proxy.extraParams = {
		         							 id : batchId
		         					};
		                          	store.load();
			                    	
			                    }
			                }
						},{
							xtype: 'customcombobox',
			                itemId:'period'+ insertPosition,
			                disabled:true,
			                editable: false,
			                displayField: 'value',
			                valueField: 'id',
			                queryMode: 'local',
			                fieldLabel: getPersonModuleTranslation('PERIOD'),
			                name: 'PERIOD_NAME',
			                listeners: {
			                    render: function(combo) {
			                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
			                        combo.bindStore(store);
			                    },
			                    select:function(obj,record){
			                    	var periodId = record[0].get("id");
			                    	var  section = obj.nextSibling();
			                    	
			                    	section.setDisabled(false);
			                    	section.reset();
			                    	
			                    	var store = section.getStore();
			                    	
		                          	store.proxy.extraParams = {
		                          			periodId : periodId
		         					};
		                          	store.load();
			                    	
			                    }
			                }
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('SECTION'),
							width: 226,
							labelAlign: 'top',
							name : 'sectionId',
							itemId : 'programCoursection_ID' + insertPosition,
							store:'attendance.SectionAndFacultyByPeriodID',
							displayField : 'sectionCode',
							valueField : 'sectionId',
							typeAhead : true,
							disabled:true,
							forceSelection : true,
							listeners: {
								render: function(combo) {
				                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
				                    combo.bindStore(store);
								}}
						},{
							xtype: 'button',
							itemId: 'delFilterBtn',
							cls: 'CustomBodyBtnReject',
							glyph: ICONGLYPH.DELETEGLYPH,
							tooltip: getCommonTranslation('DELETE'),
							style:{
								marginTop:'30px'
							},
							listeners:{
								click:function(obj){
								   var container = obj.up('fieldcontainer');
			   					   var panelContiner = $this.getEducationhistorydownloadform().down('#programBatchContainerId');
			   					   panelContiner.remove(container);
							}}
						},{
							xtype: 'button',
							itemId: 'addFilterBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'30px'
							}
						  }]
						});
			     	stopContiner.insert(insertPosition,panelItem);
			     	stopContiner.doLayout();
			      },
		      
		        
		      
	      
	      /**
		     * Save program batch filter data
		     */
		    getProgramBatchPeriodJson:function(isStdStatusLoader){
		    	/**
		    	 * Json for stop
		    	 */
		    	var this$ = this;
	            var basicStudentSearchForm;
	            if(isStdStatusLoader){
	            	basicStudentSearchForm=this$.getStudentstatusdownloadform();
	            }else{
	            	basicStudentSearchForm=this$.getStudentdownloadform();
	            }
		    	var pbpsContiner = basicStudentSearchForm.down('fieldcontainer');
		    	var pbpsFieldsCount = pbpsContiner.items.length;
		    	var pbpsArray=new Array();
		    	var endJson=null;
		    	var fieldSequence=1;
		    		for(var j=0; j<pbpsContiner.items.length; j++){
		    			var pbpsPanelContainer=pbpsContiner.items.items[j];
		    				pbpsArray.push({
		    					"programId" : pbpsPanelContainer.items.items[0].getValue(),
		    					"batchId":pbpsPanelContainer.items.items[1].getValue(),
		    					"periodId":pbpsPanelContainer.items.items[2].getValue(),
		    					"sectionId": pbpsPanelContainer.items.items[3].getValue(),
		    				});
		    	}
		    	var obj = new Object();
		    	obj.studentsToConsider = pbpsArray;
		    	return Ext.encode(obj);	
		    },
		    
		    /**
		     * Save program batch filter data for relationship
		     */
		    getJsonForRelationship:function(){
		    	/**
		    	 * Json for stop
		    	 */
		    	var this$ = this;
	            var basicStudentSearchForm=this$.getStudentrelationshipdownloadform();
		    	var pbpsContiner = basicStudentSearchForm.down('fieldcontainer');
		    	var pbpsFieldsCount = pbpsContiner.items.length;
		    	var pbpsArray=new Array();
		    	var endJson=null;
		    	var fieldSequence=1;
		    		for(var j=0; j<pbpsContiner.items.length; j++){
		    			var pbpsPanelContainer=pbpsContiner.items.items[j];
		    				pbpsArray.push({
		    					"programId" : pbpsPanelContainer.items.items[0].getValue(),
		    					"batchId":pbpsPanelContainer.items.items[1].getValue(),
		    					"periodId":pbpsPanelContainer.items.items[2].getValue(),
		    					"sectionId": pbpsPanelContainer.items.items[3].getValue(),
		    				});
		    	}
		    	var obj = new Object();
		    	obj.studentsToConsider = pbpsArray;
		    	return Ext.encode(obj);	
		    	/*var this$ = this;
	            var basicStudentSearchForm=this$.getStudentrelationshipdownloadform();
		    	var pbpsContiner = basicStudentSearchForm.down('fieldcontainer');
		    	var pbpsFieldsCount = pbpsContiner.items.length;
		    	var pbpsArray=new Array();
		    	var endJson=null;
		    	var fieldSequence=1;
		    		for(var j=0; j<pbpsContiner.items.length; j++){
		    			var pbpsPanelContainer=pbpsContiner.items.items[j];
		    				pbpsArray.push({
		    					"programId" : pbpsPanelContainer.items.items[0].getValue(),
		    					"batchId":pbpsPanelContainer.items.items[1].getValue(),
		    					"periodId":pbpsPanelContainer.items.items[2].getValue(),
		    					"sectionId": pbpsPanelContainer.items.items[3].getValue(),
		    				});
		    	}
		    	var obj = new Object();
		    	obj.studentsToConsider = pbpsArray;
		    	return Ext.encode(obj);	*/
		    },
		    
		    getJsonForEducationHistory:function(){
		    	/**
		    	 * Json for stop
		    	 */
		    	var this$ = this;
	            var basicStudentSearchForm=this$.getEducationhistorydownloadform();
		    	var pbpsContiner = basicStudentSearchForm.down('#programBatchContainerId');
		    	var templateType = basicStudentSearchForm.down('#templateTypeItemId');
		    	var examPassed = basicStudentSearchForm.down('#examPassed');
		    	var examBoard = basicStudentSearchForm.down('#examBoard');
		    	var pbpsFieldsCount = pbpsContiner.items.length;
		    	var pbpsArray=new Array();
		    	var endJson=null;
		    	var fieldSequence=1;
		    		for(var j=0; j<pbpsContiner.items.length; j++){
		    			var pbpsPanelContainer=pbpsContiner.items.items[j];
		    				pbpsArray.push({
		    					"programId" : pbpsPanelContainer.items.items[0].getValue(),
		    					"batchId":pbpsPanelContainer.items.items[1].getValue(),
		    					"periodId":pbpsPanelContainer.items.items[2].getValue(),
		    					"sectionId": pbpsPanelContainer.items.items[3].getValue(),
		    					"examPassedId":examPassed.getValue(),
		    					"examBoardId":examBoard.getValue()
		    				});
		    	}
		    	var obj = new Object();
		    	obj.studentsToConsider = pbpsArray;
		    	obj.templateType = templateType.getValue();
		    	return Ext.encode(obj);	
		    	var this$ = this;
	            var basicStudentSearchForm=this$.getEducationhistorydownloadform();
		    	var pbpsContiner = basicStudentSearchForm.down('fieldcontainer');
		    	var pbpsFieldsCount = pbpsContiner.items.length;
		    	var pbpsArray=new Array();
		    	var endJson=null;
		    	var fieldSequence=1;
		    		for(var j=0; j<pbpsContiner.items.length; j++){
		    			var pbpsPanelContainer=pbpsContiner.items.items[j];
		    				pbpsArray.push({
		    					"programId" : pbpsPanelContainer.items.items[0].getValue(),
		    					"batchId":pbpsPanelContainer.items.items[1].getValue(),
		    					"periodId":pbpsPanelContainer.items.items[2].getValue(),
		    					"sectionId": pbpsPanelContainer.items.items[3].getValue(),
		    					"examPassedId":examPassed.getValue(),
		    					"examBoardId":examBoard.getValue()
		    				});
		    	}
		    	var obj = new Object();
		    	obj.studentsToConsider = pbpsArray;
		    	return Ext.encode(obj);	
		    },
		    
		    
		    
		    getDownloadFile : function(documentId,fileType){

	        	if(!isNullOrEmpty(documentId)){
	        		var csvForm = Ext.create('Ext.form.Panel'); 
	        		csvForm.getForm().submit({
	        			target: '_blank',
	        			method:'POST',
	        			params :{
	        				access_token : Ext.Ajax.defaultHeaders.access_token
	        			},
	        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	        			standardSubmit :true
	        		});
	        	}
	        },
	        
	        
	        
	        
	        loadPanellinkForStudent: function(studentProfile, studentLinkPanelObject) {
	    		
				var this$ = this;
				var persondetailslinkpanel = studentProfile.down('persondetailslinkpanel');
				var portalId = this.getCurrentLoggedPortalId();
				if (portalId == 2) {
					persondetailslinkpanel.up().collapse();
				}
				// for Select Date Panel Hide on scroll
				var structure = studentProfile.down('panel');
	             structure.body.on('scroll', function(e, target) {
	     			var enquiryGrid = studentProfile.down('extendeddatefilter');
	     			if(enquiryGrid){
	     				enquiryGrid.hideMenu();
	     			}
	     		});
				
				var permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'PERSONAL_INFORMATION');
				var i=permissionMap.length-1;
				var p = studentLinkPanelObject.PERSONAL_INFORMATION;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#PERSONAL_INFORMATION');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'PAST_HISTORY');
				i=permissionMap.length-1;
				
				p = studentLinkPanelObject.PAST_HISTORY;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#PAST_HISTORY');
					if(links != undefined){
						this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					}
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'FLAG_LIST');
				i=permissionMap.length-1;
				
				p = studentLinkPanelObject.FLAG_LIST;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#FLAG_LIST');
					if(links != undefined){
						this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					}
					i--;
				}
				
				
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'COURSE_EXECUTION');
				i=permissionMap.length-1;
				
				p = studentLinkPanelObject.COURSE_EXECUTION;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#COURSE_EXECUTION');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
					
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'REQUESTS');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.REQUESTS;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#REQUESTS');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'PAYMENT_REFUND_HISTORY');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.PAYMENT_REFUND_HISTORY;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#PAYMENT_REFUND_HISTORY');
					if(detailsLink,permissionMap.get(links.tabPanelTitle) != undefined){
						this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					}
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'SERVICES_COMMUNITIES');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.SERVICES_COMMUNITIES;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#SERVICES_COMMUNITIES');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'DISCIPLINARY_ACTIVITY');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.DISCIPLINARY_ACTIVITY;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#DISCIPLINARY_ACTIVITY');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'KYS_DETAILS');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.KYS_DETAILS;
				while(i>=0) {
					if(Ext.isDefined(p)){
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#KYS_DETAILS');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					}
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'DOCUMENT_HISTORY');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.DOCUMENT_HISTORY;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#DOCUMENT_HISTORY');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'APPOINTMENT');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.APPOINTMENT;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#APPOINTMENT');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				if (portalId == 2) {
					setTimeout(function(){
						persondetailslinkpanel.up().expand();
					}, 1000);
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'LIBRARY_DETAILS');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.LIBRARY_DETAILS;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#LIBRARY_DETAILS');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
				
				permissionMap = this$.buildLinkDetailsMapObj(studentProfile, studentLinkPanelObject, 'POST_GRADUATE_MANAGEMENT');
				i=permissionMap.length-1;
				p = studentLinkPanelObject.POST_GRADUATE_MANAGEMENT;
				while(i>=0) {
					links = p[i];
					var detailsLink = persondetailslinkpanel.down('#POST_GRADUATE_MANAGEMENT');
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, studentLinkPanelObject);
					i--;
				}
		},
		
		hideLinksByprivileges: function(detailsLink, privilegesMap, i, studentLinkPanelObject) {
	    	
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
	    	
			//var APPLICATION_AND_ADMISSION = detailsLink;
	    	
			var store = detailsLink.items.items[0].getStore();
			var flag = true;
			Ext.each(permissionList, function(privilege) {
	    		if (privilege == 'VIEW') {
	    			 flag=false;
	        	}
	    	});
			
			if(flag){
				var rec = store.getAt(i);
				if (rec) {
					store.remove(rec);
				}
			}
			if(store.getCount() == 0){
				detailsLink.setVisible(false);
			}
			return flag;
	    },
	    
	    buildLinkDetailsMapObj: function(studentProfile, studentLinkPanelObject, linkPanelId) {
	    	var persondetailslinkpanel = studentProfile.down('persondetailslinkpanel');
			
	    	var studentPersonalController  = this.getController('Academia.controller.personinfo.student.StudentPersonalController');
	    	var studentPastHistoryController  = this.getController('Academia.controller.personinfo.student.StudentPastHistoryController');
	    	var studentCourseExcController  = this.getController('Academia.controller.personinfo.student.StudentCourseExecutionController');
	    	var studentRequestController  = this.getController('Academia.controller.personinfo.student.StudentRequestActionController');
	    	var studentPaymentController = this.getController('Academia.controller.personinfo.student.StudentPaymentRefundController');
	    	var studentServiceController = this.getController('Academia.controller.personinfo.student.StudentServiceController');
	    	var studentDisiplinaryController = this.getController('Academia.controller.personinfo.student.StudentDisciplinaryController');
	    	var studentDocumentController = this.getController('Academia.controller.personinfo.student.StudentDocumentController');
	    	var studentkysController = this.getController('Academia.controller.personinfo.student.StudentKYSController');
	    	var sgStudentAppointmentController = this.getController('Academia.controller.sgappointment.sgappointment.SGStudentAppointmentController');
	    	var studentInfirmaryManageController= this.getController('Academia.controller.servicerequest.infirmarymanage.InfirmaryManageController');
	    	var biometricmachineintegrationcontroller =  this.getController('Academia.controller.hrm.BiometricMachineIntegrationController');
	    	var sgstudentlibraryissuedbooktransactioncontroller =  this.getController('Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController');
	    	
	    	var permissionMap = new Ext.util.HashMap();
	    	var portalId = this.getCurrentLoggedPortalId();
	    	var arrayVar = new Array();
	    	if(linkPanelId=='PERSONAL_INFORMATION') {
	    		if (portalId==2) {
	    			permissionMap.add('STUDENT_PERSONAL_DETAILS',studentPersonalController.getFACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PERMISSIONS());
	    			permissionMap.add('ADDRESSES',studentPersonalController.getFACULTY_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS());
	    			permissionMap.add('PARENTS_GUARDIANS',studentPersonalController.getFACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS());
	    			permissionMap.add('SIBLING',studentPersonalController.getFACULTY_PORTAL_STUDENT_SIBLINGS_PERMISSIONS());
	    			permissionMap.add('IDENTITY_DETAILS',studentPersonalController.getFACULTY_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS());
	    			permissionMap.add('FEE_PAYERS',studentPersonalController.getFACULTY_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS());
	    			permissionMap.add('OTHER_INFORMATION',studentPersonalController.getFACULTY_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS());
	    			permissionMap.add('SSO_DETAILS',studentPersonalController.getFACULTY_PORTAL_STUDENT_PROFILE_SSO_DETAILS_PERMISSIONS());
	    			permissionMap.add('LIVING_ARRANGEMENT',studentPersonalController.getFACULTY_LIVING_ARRANGMENT_PERMISSION());
	    			permissionMap.add('PASSPORT',studentPersonalController.getFACULTY_PORTAL_PASSPORT_PERMISSION());
	    			permissionMap.add('PERMIT',studentPersonalController.getFACULTY_PORTAL_PERMIT_PERMISSION());
	    			permissionMap.add('VISA',studentPersonalController.getFACULTY_PORTAL_VISA_DETAIL_PERMISSION());
	    			permissionMap.add('BANK_DETAILS',studentPersonalController.getSTUDENT_BANK_DETAILS_PERMISSIONS());
	    			permissionMap.add('INSURANCE',studentPersonalController.getFACULTY_PORTAL_INSURANCE_DETAIL_PERMISSION());
	    		}else if (portalId==1) {
	    			permissionMap.add('STUDENT_PERSONAL_DETAILS',studentPersonalController.getSTUDENT_PERSONAL_DETAILS_PERMISSIONS());
	    			permissionMap.add('ADDRESSES',studentPersonalController.getSTUDENT_ADDRESS_DETAILS_PERMISSIONS());
	    			permissionMap.add('PARENTS_GUARDIANS',studentPersonalController.getSTUDENT_PARENTS_GUARDIANS_PERMISSIONS());
	    			permissionMap.add('SIBLING',studentPersonalController.getSTUDENT_SIBLINGS_PERMISSIONS());
	    			permissionMap.add('IDENTITY_DETAILS',studentPersonalController.getSTUDENT_IDENTITY_DETAILS_PERMISSIONS());
	    			permissionMap.add('FEE_PAYERS',studentPersonalController.getSTUDENT_FEE_PAYER_DETAILS_PERMISSIONS());
	    			permissionMap.add('OTHER_INFORMATION',studentPersonalController.getSTUDENT_OTHER_INFORMATION_DETAILS_PERMISSIONS());
	    			permissionMap.add('SSO_DETAILS',studentPersonalController.getSTUDENT_SSO_DETAILS_PERMISSIONS());
	    			permissionMap.add('BANK_DETAILS',studentPersonalController.getSTUDENT_BANK_DETAILS_PERMISSIONS());
	    			permissionMap.add('LIVING_ARRANGEMENT',studentPersonalController.getSTUDENT_LIVING_ARRANGMENT_PERMISSION());
	    			permissionMap.add('PASSPORT',studentPersonalController.getPASSPORT_DETAIL_PERMISSION());
	    			permissionMap.add('VISA',studentPersonalController.getVISA_DETAIL_PERMISSION());
	    			permissionMap.add('PASSPORT',studentPersonalController.getPASSPORT_DETAIL_PERMISSION());
	    			permissionMap.add('VISA',studentPersonalController.getVISA_DETAIL_PERMISSION());
	    			permissionMap.add('INSURANCE',studentPersonalController.getINSURANCE_DETAILS_PERMISSION());
	    			permissionMap.add('PERMIT',studentPersonalController.getPERMIT_DETAIL_PERMISSION());
	    			
	    		}
	    	} else if(linkPanelId=='PAST_HISTORY') {
	    		if (portalId==2) {
	    			permissionMap.add('EDUCATION',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_EDUCATION_PERMISSIONS());
	    			permissionMap.add('WORK_EXPERIENCE',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_WORK_EXPERIENCE_PERMISSIONS());
	    			permissionMap.add('COMMUNICATION_HISTORY',studentPastHistoryController.getFP_STUDENT_COMMUNICATION_HISTORY_VIEW_PERMISSIONS());
	    			permissionMap.add('MEDICAL_HISTORY',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_MEDICAL_PERMISSIONS());
	    			permissionMap.add('VACCINATION',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_VACCINATION_PERMISSIONS());
	    			permissionMap.add('EXTRA_CURRICULUM',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
	    			permissionMap.add('PHYSICAL_CHARACTERISTICS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
	    			permissionMap.add('RESEARCH_TYPE',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS());
	    			permissionMap.add('SEMINAR_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS());
	    			permissionMap.add('PATENT_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_PATENT_PERMISSIONS());
	    			permissionMap.add('TRAINING_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS());
	    			permissionMap.add('HOSTEL_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_HOSTEL_DETAILS_PERMISSIONS());
	    			permissionMap.add('COMPETITIVE_EXAM',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS());
	    			permissionMap.add('MD_MEDICAL_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS());
	    			permissionMap.add('TRANSPORT_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_TRANSPORT_DETAILS_PERMISSIONS());
	    			permissionMap.add('CHURCH_INFORMATION_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS());
	    			permissionMap.add('INFIRMARY_DETAILS',studentInfirmaryManageController.getFACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
	    			permissionMap.add('NON_ACADEMIC_ACHIEVEMENTS',studentPastHistoryController.getFACULTY_PORTAL_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
	    			permissionMap.add('SOCIO_ECONOMIC_INFORMATION',studentPastHistoryController.getFACULTY_PORTAL_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS());
	    			permissionMap.add('POST_SCHOOL_STUDIES',studentPastHistoryController.getFACULTY_PORTAL_POST_SCHOOL_STUDIES_PERMISSIONS());
	    			permissionMap.add('LANGUAGE_INFORMATION',studentPastHistoryController.getFACULTY_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
	    			permissionMap.add('HEALTH_INFORMATION',studentPastHistoryController.getFACULTY_PORTAL_HEALTH_INFORMATION_PERMISSION());	    			
	    			permissionMap.add('EDUCATION_DETAILS',studentPastHistoryController.getFACULTY_PORTAL_EDUCATION_HISTORY_PERMISSIONS());
	    		} else if (portalId==1) {
	    			permissionMap.add('EDUCATION',studentPastHistoryController.getSTUDENT_EDUCATION_PERMISSIONS());
	    			permissionMap.add('WORK_EXPERIENCE',studentPastHistoryController.getSTUDENT_WORK_EXPERIENCE_PERMISSIONS());
	    			permissionMap.add('COMMUNICATION_HISTORY',studentPastHistoryController.getSTUDENT_COMMUNICATION_HISTORY_PERMISSIONS());
	    			permissionMap.add('MEDICAL_HISTORY',studentPastHistoryController.getSTUDENT_MEDICAL_PERMISSIONS());
	    			permissionMap.add('VACCINATION',studentPastHistoryController.getSTUDENT_VACCINATION_PERMISSIONS());
	    			permissionMap.add('EXTRA_CURRICULUM',studentPastHistoryController.getSTUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
	    			permissionMap.add('PHYSICAL_CHARACTERISTICS',studentPastHistoryController.getSTUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
	    			permissionMap.add('RESEARCH_TYPE',studentPastHistoryController.getSTUDENT_RESEARCH_DETAILS_PERMISSIONS());
	    			permissionMap.add('SEMINAR_DETAILS',studentPastHistoryController.getSTUDENT_SEMINAR_DETAILS_PERMISSIONS());
	    			permissionMap.add('PATENT_DETAILS',studentPastHistoryController.getSTUDENT_PATENT_DETAILS_PERMISSIONS());
	    			permissionMap.add('TRAINING_DETAILS',studentPastHistoryController.getSTUDENT_TRAINING_DETAILS_PERMISSIONS());
	    			permissionMap.add('HOSTEL_DETAILS',studentPastHistoryController.getSTUDENT_HOSTEL_DETAILS_PERMISSIONS());
	    			permissionMap.add('COMPETITIVE_EXAM',studentPastHistoryController.getSTUDENT_COMPETITIVE_EXAM_PERMISSIONS());
	    			permissionMap.add('MD_MEDICAL_DETAILS',studentPastHistoryController.getSTUDENT_MEDICAL_DETAIL_PERMISSIONS());
	    			permissionMap.add('TRANSPORT_DETAILS',studentPastHistoryController.getSTUDENT_TRANSPORT_DETAILS_PERMISSIONS());
	    			permissionMap.add('CHURCH_INFORMATION_DETAILS',studentPastHistoryController.getSTUDENT_CHURCH_INFORMATION_PERMISSIONS());
	    			permissionMap.add('INFIRMARY_DETAILS',studentInfirmaryManageController.getSTUDENT_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
	    			permissionMap.add('NON_ACADEMIC_ACHIEVEMENTS',studentPastHistoryController.getSTUDENT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
	    			permissionMap.add('SOCIO_ECONOMIC_INFORMATION',studentPastHistoryController.getSTUDENT_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS());
	    			permissionMap.add('POST_SCHOOL_STUDIES',studentPastHistoryController.getSTUDENT_POST_SCHOOL_STUDIES_PERMISSIONS());
	    			permissionMap.add('EDUCATION_DETAILS',studentPastHistoryController.getEDUCATION_HISTORY_PERMISSION());
	    			permissionMap.add('LANGUAGE_INFORMATION',studentPastHistoryController.getSTUDENT_LANGUAGE_INFORMATION_PERMISSIONS());
	    			permissionMap.add('HEALTH_INFORMATION',studentPastHistoryController.getSTUDENT_HEALTH_INFORMATION_PERMISSIONS());
	    			permissionMap.add('STUDENT_ENGAGEMENT',studentPastHistoryController.getSTUDENT_ENGAGEMENT_PERMISSIONS());
	    			permissionMap.add('LEARNING_ALLOWANCE',studentPastHistoryController.getSTUDENT_LEARNING_ALLOWANCE_PERMISSIONS());
	    		}
	    	} else if(linkPanelId=='COURSE_EXECUTION') {
	    		if (portalId==2) {
	    			permissionMap.add('SCHEDULE',studentCourseExcController.getFACULTY_PORTAL_STUDENT_SCHEDULE_DETAILS_PERMISSIONS());
	    			permissionMap.add('ATTENDANCE',studentCourseExcController.getFACULTY_PORTAL_STUDENT_ATTENDANCE_PERMISSIONS());
	    			permissionMap.add('MY_COURSE',studentCourseExcController.getFACULTY_PORTAL_COURSE_MASTER_PERMISSIONS());
	    			permissionMap.add('EXAM_ELIGIBILITY',studentCourseExcController.getFACULTY_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS());
	    			permissionMap.add('VIEW_EXAMINATION',studentCourseExcController.getFACULTY_PORTAL_STUDENT_VIEW_EXAMINATION_PERMISSION());
	    			permissionMap.add('ACADEMICS_TOPIC',studentCourseExcController.getFACULTY_PORTAL_STUDENT_ACADEMICS_TOPIC_PERMISSION());
	    			permissionMap.add('VIEW_ACADEMIC_HISTORY',studentCourseExcController.getFACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION());
	    			permissionMap.add('BIOMETRIC_MACHINE_DETAILS',biometricmachineintegrationcontroller.getFACULTY_PORTAL_STUDENT_BM_DETAILS_PERMISSIONS());
	    			permissionMap.add('DEGREE_AUDIT_REPORT',studentCourseExcController.getFACULTY_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS());
	    			permissionMap.add('SALESFORCE_ADMISSION_DETAILS',studentCourseExcController.getSTUDENT_SALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
	    		}else if (portalId==1) {
	    			permissionMap.add('SCHEDULE',studentCourseExcController.getSTUDENT_SCHEDULE_DETAILS_PERMISSIONS());	
	    			permissionMap.add('ATTENDANCE',studentCourseExcController.getSTUDENT_ATTENDANCE_PERMISSIONS());
	    			permissionMap.add('MY_COURSE',studentCourseExcController.getCOURSE_MASTER_PERMISSIONS());
	    			permissionMap.add('EXAM_ELIGIBILITY',studentCourseExcController.getEXAMINATION_EXAM_ELIGIBILITY_PERMISSIONS());
	    			permissionMap.add('VIEW_EXAMINATION',studentCourseExcController.getSTUDENT_VIEW_EXAMINATION_PERMISSION());
	    			permissionMap.add('ACADEMICS_TOPIC',studentCourseExcController.getSTUDENT_ACADEMICS_TOPIC_PERMISSION());
	    			permissionMap.add('STUDENT_JOURNEY',studentCourseExcController.getSTUDENT_JOURNEY_PERMISSION());
	    			permissionMap.add('VIEW_ACADEMIC_HISTORY',studentCourseExcController.getSTUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION());
	    			permissionMap.add('BIOMETRIC_MACHINE_DETAILS',biometricmachineintegrationcontroller.getSTUDENT_BM_DETAILS_PERMISSIONS());
	    			permissionMap.add('DEGREE_AUDIT_REPORT',studentCourseExcController.getEXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS());
	    			permissionMap.add('SALESFORCE_ADMISSION_DETAILS',studentCourseExcController.getSTUDENT_SALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
	    			permissionMap.add('STUDENT_PROGRAM_COMPLETION_DETAILS',studentCourseExcController.getSTUDENT_PROGRAM_COMPLETION_DETAILS_PERMISSIONS());
	    			permissionMap.add('STUDENT_TRANSFER_CREDIT',studentCourseExcController.getSTUDENT_TRANSFER_CREDIT_DETAILS_PERMISSIONS());
	    		}
	    		permissionMap.add('CONDITIONS_FOR_ADMISSION',studentCourseExcController.getSTUDENT_CONDITIONS_FOR_ADMISSION_PERMISSIONS());
	    		permissionMap.add('PROGRAM_WISE_CONDITIONS_FOR_ADMISSION',studentCourseExcController.getSTUDENT_PROGRAM_WISE_CONDITIONS_FOR_ADMISSION_PERMISSIONS());
	    		
	    	} else if(linkPanelId=='REQUESTS') {
	    		if (portalId==2) {
	    			permissionMap.add('REQUEST_RAISED_HISTORY',studentRequestController.getFACULTY_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS());
	    			permissionMap.add('REQUEST_PENDING_DESCISION',studentRequestController.getFACULTY_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS());
	    		}else if (portalId==1) {
	    			permissionMap.add('REQUEST_RAISED_HISTORY',studentRequestController.getSTUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS());
	    			permissionMap.add('REQUEST_PENDING_DESCISION',studentRequestController.getSTUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS());
	    		}
	    	} else if(linkPanelId=='PAYMENT_REFUND_HISTORY') {
	    		if (portalId==2) {
	    			permissionMap.add('BILLS',studentPaymentController.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	    			permissionMap.add('HEAD_WISE_BILLS',studentPaymentController.getFACULTY_PORTAL_STUDENT_HEAD_WISE_BILLS_PERMISSIONS());
	    			permissionMap.add('RECEIPTS',studentPaymentController.getFACULTY_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS());
	    			permissionMap.add('REFUNDS',studentPaymentController.getFACULTY_PORTAL_STUDENT_REFUNDS_PERMISSIONS());
	    			permissionMap.add('REFUNDABLE_PAYMENTS',studentPaymentController.getFACULTY_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
	    			permissionMap.add('POST_DATED_CHEQUES',studentPaymentController.getFACULTY_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS());
	    			permissionMap.add('STUDENT_SCHOLERSHIP_LISTING',studentPaymentController.getFACULTY_PORTAL_STUDENT_SCHOLARSHIP_PERMISSIONS());
	    			permissionMap.add('NSFAS_BURSARY_DETAIL',studentPaymentController.getFACULTY_PORTAL_STUDENT_NSFAS_PERMISSIONS());
	    		}else if (portalId==1) {
	    			permissionMap.add('BILLS',studentPaymentController.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	    			permissionMap.add('HEAD_WISE_BILLS',studentPaymentController.getSTUDENT_HEAD_WISE_BILLS_PERMISSIONS());
	    			permissionMap.add('RECEIPTS',studentPaymentController.getSTUDENT_PAYMENT_RECIEVED_PERMISSIONS());
	    			permissionMap.add('REFUNDS',studentPaymentController.getSTUDENT_REFUNDS_PERMISSIONS());
	    			permissionMap.add('REFUNDABLE_PAYMENTS',studentPaymentController.getSTUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
	    			permissionMap.add('POST_DATED_CHEQUES',studentPaymentController.getSTUDENT_POST_DATED_CHEQUES_PERMISSIONS());
	    			permissionMap.add('STUDENT_SCHOLERSHIP_LISTING',studentPaymentController.getSTUDENT_SCHOLARSHIP_PERMISSIONS());
	    			permissionMap.add('NSFAS_BURSARY_DETAIL',studentPaymentController.getSTUDENT_NSFAS_PRIVILEGES());
	    			permissionMap.add('FUNDING_AND_MONITORING',studentPaymentController.getSTUDENT_FUNDING_AND_MONITORING_PRIVILEGES());
	    			permissionMap.add('FINANCIAL_SUPPORT',studentPaymentController.getSTUDENT_FINANCIAL_SUPPORT_PRIVILEGES());
	    		}
	    	} else if(linkPanelId=='SERVICES_COMMUNITIES') {
	    		if (portalId==2) {
	    			permissionMap.add('SERVICES_HISTORY',studentServiceController.getFACULTY_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS());
	    			permissionMap.add('SERVICE_OPT_IN_OUT',studentServiceController.getFACULTY_PORTAL_STUDENT_SERVICE_OPT_PERMISSIONS());
	    			permissionMap.add('COMMUNITIES_HISTORY',studentServiceController.getFACULTY_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS());
	    			permissionMap.add('COMMUNITIES_OPT_IN_OUT',studentServiceController.getFACULTY_PORTAL_STUDENT_COMMUNITIES_OPT_PERMISSIONS());
	    			permissionMap.add('HOSTEL_PERSONAL_REQUIREMENTS',studentPersonalController.getFACULTY_PORTAL_STUDENT_HOSTEL_PERSONAL_REQUIREMENTS_PERMISSIONS());
	    		}else if (portalId==1) {
	    			permissionMap.add('SERVICES_HISTORY',studentServiceController.getSTUDENT_SERVICES_HISTORY_PERMISSIONS());
	    			permissionMap.add('SERVICE_OPT_IN_OUT',studentServiceController.getSTUDENT_SERVICE_OPT_PERMISSIONS());
	    			permissionMap.add('COMMUNITIES_HISTORY',studentServiceController.getSTUDENT_COMMUNITIES_HISTORY_PERMISSIONS());
	    			permissionMap.add('COMMUNITIES_OPT_IN_OUT',studentServiceController.getSTUDENT_COMMUNITIES_OPT_PERMISSIONS());
	    			permissionMap.add('HOSTEL_PERSONAL_REQUIREMENTS',studentPersonalController.getSTUDENT_HOSTEL_PERSONAL_REQUIREMENTS_PERMISSIONS());
	    		}
    		
	    	} else if(linkPanelId=='DISCIPLINARY_ACTIVITY') {
	    		if (portalId==2) {
	    			permissionMap.add('DISCIPLINARY_ACTIONS',studentDisiplinaryController.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
	    			permissionMap.add('SP_DISCIPLINARY_ACTIONS_SU',studentDisiplinaryController.getFACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS());
	    			permissionMap.add('NEGATIVE_INCIDENTS',studentDisiplinaryController.getFACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
	    			permissionMap.add('POSITIVE_INCIDENTS',studentDisiplinaryController.getFACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
	    			permissionMap.add('HOLDS',studentPersonalController.getFACULTY_PORTAL_STUDENT_HOLDS_PERMISSIONS());
	    		}else if (portalId==1) {
	    			permissionMap.add('DISCIPLINARY_ACTIONS',studentDisiplinaryController.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
	    			permissionMap.add('SP_DISCIPLINARY_ACTIONS_SU',studentDisiplinaryController.getSTUDENT_DISCIPLINARY_ACTIONS_SU_PERMISSIONS());
	    			permissionMap.add('NEGATIVE_INCIDENTS',studentDisiplinaryController.getSTUDENT_NEGATIVE_INCIDENTS_PERMISSIONS());
	    			permissionMap.add('POSITIVE_INCIDENTS',studentDisiplinaryController.getSTUDENT_POSITIVE_INCIDENTS_PERMISSIONS());
	    			permissionMap.add('HOLDS',studentPersonalController.getSTUDENT_HOLDS_PERMISSIONS());
	    		}
	    	} else if(linkPanelId=='KYS_DETAILS') {
	    		permissionMap.add('KYS',studentkysController.getSTUDENT_KYS_PERMISSIONS());
	    		permissionMap.add('PENDING_KYS',studentkysController.getSTUDENT_PENDING_KYS_PERMISSIONS());
	    		
	    	} else if(linkPanelId=='DOCUMENT_HISTORY') {
	    		//permissionMap.add('DOCUMENTS',studentDocumentController.getSTUDENT_DOCUMENTS_PERMISSIONS());
	    		
	    		if (portalId==2) {
	    			permissionMap.add('DOC_ONLINE_DOCUMENTS', studentDocumentController.getFACULTY_PORTAL_STUDENT_PROFILE_ONLINE_DOCUMENTS_PERMISSIONS());
		    		permissionMap.add('DOC_PHYSICAL_DOCUMENTS', studentDocumentController.getFACULTY_PORTAL_STUDENT_PROFILE_PHYSICAL_DOCUMENTS_PERMISSIONS());
	    		} else if (portalId==1) {
	    			permissionMap.add('DOC_ONLINE_DOCUMENTS', studentDocumentController.getSTUDENT_ONLINE_DOCUMENTS_PERMISSIONS());
		    		permissionMap.add('DOC_PHYSICAL_DOCUMENTS', studentDocumentController.getSTUDENT_PHYSICAL_DOCUMENTS_PERMISSIONS());
	    		}
	    	} else if(linkPanelId == 'APPOINTMENT') {
	    		 var portalId = this.getCurrentLoggedPortalId();
				 if (portalId == 3) {
					 permissionMap.add('MANAGE_APPOINTMENT', sgStudentAppointmentController.getSTUDENT_PORTAL_APPOINTMENT_MANAGE_PERMISSIONS());
				 } else if (portalId == 2) {
					 permissionMap.add('MANAGE_APPOINTMENT',sgStudentAppointmentController.getFP_STUDENT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS());
					 permissionMap.add('APPOINTMENT_FOLLOW-UP',sgStudentAppointmentController.getFP_STUDENT_APPOINTMENT_FOLLOWUP_MANAGE_PERMISSIONS());
				 } else if (portalId == 1)  {
					 permissionMap.add('MANAGE_APPOINTMENT',sgStudentAppointmentController.getSTUDENT_APPOINTMENT_MANAGE_PERMISSIONS());
					 permissionMap.add('APPOINTMENT_FOLLOW-UP',sgStudentAppointmentController.getSTUDENT_APPOINTMENT_FOLLOWUP_MANAGE_PERMISSIONS());
				 }
	    	} else if(linkPanelId == 'LIBRARY_DETAILS'){
	    		 var portalId = this.getCurrentLoggedPortalId();
	    		 if (portalId == 3 || portalId == 1) {
	    			 permissionMap.add('CURRENTLY_ISSUED_STUDENT_BOOKS', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_BOOK_ISSUED_STUDENT_HISTORY());
					 permissionMap.add('LIBRARY_CIRCULATION_STUDENT_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_BOOK_CIRCULATION_STUDENT_HISTORY());
					 permissionMap.add('LIBRARY_RESERVED_STUDENT_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_BOOK_RESERVED_STUDENT_HISTORY());
					 permissionMap.add('LIBRARY_FEE_DETATILS_STUDENT_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getCORE_ERP_LIBRARY_DUE_STUDENT_FEES());
	    		 }else if (portalId==2) {
					 permissionMap.add('CURRENTLY_ISSUED_STUDENT_BOOKS', sgstudentlibraryissuedbooktransactioncontroller.getFPTOSP_ERP_BOOK_ISSUED_STUDENT_HISTORY());
					 permissionMap.add('LIBRARY_CIRCULATION_STUDENT_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getFPTOSP_ERP_BOOK_CIRCULATION_STUDENT_HISTORY());
					 permissionMap.add('LIBRARY_RESERVED_STUDENT_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getFPTOSP_ERP_BOOK_RESERVED_STUDENT_HISTORY());
					 permissionMap.add('LIBRARY_FEE_DETATILS_STUDENT_HISTORY', sgstudentlibraryissuedbooktransactioncontroller.getFPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES());
				 }
	    	}
	    	else if(linkPanelId == 'POST_GRADUATE_MANAGEMENT'){
	    		 var portalId = this.getCurrentLoggedPortalId();
	    		 if (portalId == 1) {
	    			 permissionMap.add('STUDENT_POST_DOC_INFO', studentPastHistoryController.getSTUDENT_POST_DOC_INFO_PERMISSIONS());
	    			 permissionMap.add('STUDENT_THESIS_TITLE', studentPastHistoryController.getCORE_ERP_STUDENT_THESIS_TITLE());
					 permissionMap.add('STUDENT_JOINT_DEGREE', studentPastHistoryController.getCORE_ERP_STUDENT_JOINT_DEGREE());
					 permissionMap.add('STUDENT_OWN_PROGRESS_REPORT', studentPastHistoryController.getCORE_ERP_STUDENT_OWN_PROGRESS_REPORT());
					 permissionMap.add('FUNCTIONARY_PROGRESS_REPORT', studentPastHistoryController.getCORE_ERP_FUNCTIONARY_PROGRESS_REPORT());
					 permissionMap.add('STUDENT_MOU', studentPastHistoryController.getCORE_ERP_STUDENT_MOU());
					 permissionMap.add('STUDENT_ETHICS_CLEARANCE_LETTER', studentPastHistoryController.getCORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER());
					 permissionMap.add('EXAMINERS_REPORT', studentPastHistoryController.getCORE_ERP_EXAMINERS_REPORT());
					 permissionMap.add('STUDENT_THESIS_UPLOAD', studentPastHistoryController.getCORE_ERP_STUDENT_THESIS_UPLOAD());
					 permissionMap.add('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT', studentPastHistoryController.getCORE_ERP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT());
					 permissionMap.add('FUNCTIONARY_DETAILS', studentPastHistoryController.getCORE_ERP_FUNCTIONARY_DETAILS());
					 permissionMap.add('NOMINATE_EXAMINERS', studentPastHistoryController.getCORE_ERP_NOMINATE_EXAMINERS());
					 permissionMap.add('PROOF_OF_ACTIVITY', studentPastHistoryController.getCORE_ERP_PROOF_OF_ACTIVITY());
	    		 }else if (portalId == 2) {
	    			 permissionMap.add('STUDENT_THESIS_TITLE', studentPastHistoryController.getFACULTY_STUDENT_THESIS_TITLE_PERMISSION());
	    			 permissionMap.add('STUDENT_POST_DOC_INFO', studentPastHistoryController.getFACULTY_STUDENT_POST_DOC_INFO_PERMISSION());
					 permissionMap.add('STUDENT_JOINT_DEGREE', studentPastHistoryController.getFACULTY_STUDENT_JOINT_DEGREE_PERMISSION());
					 permissionMap.add('STUDENT_OWN_PROGRESS_REPORT', studentPastHistoryController.getFACULTY_STUDENT_OWN_PROGRESS_REPORT_PERMISSION());
					 permissionMap.add('FUNCTIONARY_PROGRESS_REPORT', studentPastHistoryController.getFACULTY_FUNCTIONARY_PROGRESS_REPORT_PERMISSION());
					 permissionMap.add('STUDENT_MOU', studentPastHistoryController.getFACULTY_STUDENT_MOU_PERMISSION());
					 permissionMap.add('STUDENT_ETHICS_CLEARANCE_LETTER', studentPastHistoryController.getFACULTY_STUDENT_ETHICS_CLEARANCE_LETTER_PERMISSION());
					 permissionMap.add('EXAMINERS_REPORT', studentPastHistoryController.getFACULTY_EXAMINERS_REPORT_PERMISSION());
					 permissionMap.add('STUDENT_THESIS_UPLOAD', studentPastHistoryController.getFACULTY_STUDENT_THESIS_UPLOAD_PERMISSION());
					 permissionMap.add('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT', studentPastHistoryController.getFACULTY_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_PERMISSION());
					 permissionMap.add('FUNCTIONARY_DETAILS', studentPastHistoryController.getFACULTY_FUNCTIONARY_DETAILS_PERMISSION());
					 permissionMap.add('NOMINATE_EXAMINERS', studentPastHistoryController.getFACULTY_NOMINATE_EXAMINERS_PERMISSION());
					 permissionMap.add('PROOF_OF_ACTIVITY', studentPastHistoryController.getFACULTY_PROOF_OF_ACTIVITY_PERMISSION());
	    		 }
	    	}else if(linkPanelId == 'FLAG_LIST'){
	    		var portalId = this.getCurrentLoggedPortalId();
	    		if (portalId == 1) {
	    			permissionMap.add('RAISED_FLAG_LIST',Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FLAG_LIST_PRIVILEGES'));
	    		}
	    		else if (portalId == 2) {
	    			permissionMap.add('RAISED_FLAG_LIST', Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_STUDENT_FLAG_LIST_PRIVILEGES'));
	    		}
	    	}
	    	return permissionMap;
	    },
	    printButtonAction:function(){
			   var $this = this;
			   user=$this.getCurrentlyLoggedInUser();
			   var code ="StudentSummaryReport";
			   var contentPanel=$this.getContentPanel();
			   var studentId=contentPanel.getActiveTab().userId;
			   var studentPersonId=contentPanel.getActiveTab().personId;
			   var reportParams =new Object();
			   var title= contentPanel.getActiveTab().title+"-"+ new Date().getTime();
			   var admissionId = contentPanel.getActiveTab().admissionId;
			   var isInctiveCheck = false;
			   if(!isNullOrEmpty(contentPanel.getActiveTab().personInfo) && !isNullOrEmpty(contentPanel.getActiveTab().personInfo.status)) {
			       if(contentPanel.getActiveTab().personInfo.status=='Inactive') {
			       	    isInctiveCheck=true;
			       }
			   }
			   reportParams.reportTitle=title;
			   reportParams.userId=user.code;
			   reportParams.studentId= studentId;
			   reportParams.studentPersonId = studentPersonId;
			   reportParams.academyLocationId = $this.getCurrentAcademyLocation();
			   reportParams.code = code;
			   reportParams.admissionId = admissionId;
			   reportParams.isInctiveCheck = isInctiveCheck;
			   
			   var returnJson = new Object();
			   			   
			   $$this = Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
			   returnJson = $$this.getAllPermissions();

			   reportParams.isIdentity=returnJson.map.isIdentity;
			   reportParams.isParentAndGuardian=returnJson.map.isParentAndGuardian;
			   reportParams.isSiblings = returnJson.map.isSiblings;
			   reportParams.isPersonalDetails = returnJson.map.isPersonalDetails;
			   reportParams.isAddress = returnJson.map.isAddress;
			   reportParams.isEducation = returnJson.map.isEducation;
			   reportParams.isWorkExp = returnJson.map.isWorkExp;
			   reportParams.isMedical = returnJson.map.isMedical;
			   reportParams.isVaccination = returnJson.map.isVaccination;
			   reportParams.isExtraCurricular = returnJson.map.isExtraCurricular;
			   reportParams.isResearch = returnJson.map.isResearch;
			   reportParams.isSeminar = returnJson.map.isSeminar;
			   reportParams.isTraining = returnJson.map.isTraining;
			   reportParams.isPatent = returnJson.map.isPatent;
			   reportParams.isCompetitive = returnJson.map.isCompetitive;
			   reportParams.isPhysicalChar = returnJson.map.isPhysicalChar;
			   reportParams.isScholarShip = returnJson.map.isScholarShip;
			   reportParams.isBilling = returnJson.map.isBilling;
			   reportParams.isReceipt = returnJson.map.isReceipt;
			   reportParams.isPNC = returnJson.map.isPNC;
			   reportParams.isRefund = returnJson.map.isRefund;
			   reportParams.idDocument = returnJson.map.idDocument;
			   reportParams.isService = returnJson.map.isService;
			   reportParams.isDisciplinaryAction = returnJson.map.isDisciplinaryAction;
			   reportParams.isPositiveIncident = returnJson.map.isPositiveIncident;
			   reportParams.isHostal = returnJson.map.isHostal;
			   reportParams.isAcademicHistory = returnJson.map.isAcademicHistory;
			   reportParams.isFeePayerDetail = returnJson.map.isFeePayerDetail;
			   reportParams.isCommunityOptIn = returnJson.map.isCommunityOptIn;
			   reportParams.isNegativeIncident = returnJson.map.isNegativeIncident;
			   reportParams.isStudentOtherInformation = returnJson.map.isStudentOtherInformation;
			   reportParams.isStudentAcademicTopics = returnJson.map.isStudentAcademicTopics;
			   
			   var exportUrl = SERVERURL.PATH_PRINT_STUDENT;
			   $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);
	    },
	    
	    openChedExportWin: function() {
	    	var $this = this;
	    	var win = $this.getChedexportwindow();
			if(!win){
				win = Ext.widget('chedexportwindow');
			}
			win.show();
			var grid = $this.getSearchResultGrid();
			var selectRecordLength = grid.getSelectionModel().getSelection().length;
			var  exportTypeIdField = win.down("#exportTypeId");
			var store = exportTypeIdField.getStore();
			
			var academyLocationId=$this.getCurrentAcademyLocation();
			store.getProxy().extraParams={
		    	academyLocationId:academyLocationId,
		    	reportType:'Basic Reports'
			};

			store.on('load', function(records, operation, success){
				var allStoreData = [];
				
				 	var associatedAcadLocationIds = new Array();	            
		            associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
		    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getSTUDENT_LIST_PERMISSIONS());

		    		Ext.each(permissionList, function(privilege) {
		    			if (privilege === 'ENROLLMENT') {
		    				allStoreData.push({
		    					id : 'ENROLLMENT',
		    					value : getProgramandcourseTranslation('ENROLLMENT')
		    				});       		
		    			}
		    			if (privilege === 'GRADUATION') {
		    				allStoreData.push({
		    					id : 'GRADUATION',
		    					value : getProgramandcourseTranslation('GRADUATION')
		    				});       		
		    			}
		    			if (privilege === 'STUDENT_DETAILS_REPORT') {
		    				allStoreData.push({
		    					id : 'STUDENT_DETAIL_REPORT',
		    					value : getProgramandcourseTranslation('STUDENT_DETAILS_REPORT')
		    				});       		
		    			}
		    			if (privilege === 'STUDENT_DETAILS_REPORT_FOR_SCHOOL') {
		    				allStoreData.push({
		    					id : 'STUDENT_DETAIL_REPORT_FOR_SCHOOL',
		    					value : getProgramandcourseTranslation('STUDENT_DETAILS_REPORT_FOR_SCHOOL')
		    				});       		
		    			}
		    			if (privilege === 'STUDENT_ACADEMIC_TOPIC_DETAILS_REPORT') {
			    			allStoreData.push({
			    				id : 'STUDENT_ACADEMIC_TOPIC_DETAILS_REPORT',
								value : getProgramandcourseTranslation('STUDENT_ACADEMIC_TOPIC_DETAILS_REPORT')
							});       		
			        	}
			    		/*if (privilege === 'STUDENT_COURSE_ENROLLMENT_FORM') {
			    			allStoreData.push({
			    				id : 'STUDENT_DETAIL_REPORT_FOR_SCHOOL',
								value : 'Student Detail Report For School'
							});       		
			        	}*/


		    			Ext.each(records.data.items, function(currentRecord){
		    				if(currentRecord.data.displayValue==="STUDENT_COURSE_ENROLLMENT" && privilege === 'ENROLLED_COURSES_FORM'){
		    					allStoreData.push({
		    						id : 'STUDENT_COURSE_ENROLLMENT',
		    						value : getProgramandcourseTranslation('ENROLLED_COURSES_FORM')
		    					});
		    				}

		    				if(currentRecord.data.displayValue==="IIMT_STUDENT_COURSE_ENROLLMENT" && privilege === 'STUDENT_COURSE_ENROLLMENT_FORM'){
		    					allStoreData.push({
		    						id : 'IIMT_STUDENT_COURSE_ENROLLMENT',
		    						value : getProgramandcourseTranslation('STUDENT_COURSE_ENROLLMENT_FORM')
		    					});
		    				}
		    				if(currentRecord.data.displayValue==="SAMHS_ATTENDANCE_REPORT_EXCEL" && privilege === 'SAMHS_ATTENDANCE_REPORT'){
		    					allStoreData.push({
		    						id : 'SAMHS_ATTENDANCE_REPORT_EXCEL',
		    						value : getProgramandcourseTranslation('SAMHS_ATTENDANCE_REPORT_EXCEL')
		    					});
		    				}
		    				if(currentRecord.data.displayValue==="SAMHS_ATTENDANCE_REPORT_PDF" && privilege === 'SAMHS_ATTENDANCE_REPORT'){
		    					allStoreData.push({
		    						id : 'SAMHS_ATTENDANCE_REPORT_PDF',
		    						value : getProgramandcourseTranslation('SAMHS_ATTENDANCE_REPORT_PDF')
		    					});
		    				}
		    			});
		    		});
		    		
				store.removeAll();
				store.add(allStoreData);
			}, store, { single : true });
			
			//store.load();
	    },
	    exportXlsStudentList: function(){
	    	var $this = this;
	    	var exportType = $this.getChedexportwindow().down("#exportTypeId");
	    	var form = $this.getStudentQuickSearchForm().getForm();
	    	var values = form.getValues();
	    	var reportParams = new Object();
	    	var admParams = [];
	    	userId = form.findField('ADMISSION_NUMBER').getValue();
	    	userStore=form.findField('ADMISSION_NUMBER').getStore();
	    	if(!isNullOrEmpty(userStore.findRecord('id',userId))){
	    		admissionCode = userStore.findRecord('id',userId).data.code;
	    		reportParams.admissionCode = admissionCode;
	    	} else {
	    		reportParams.admissionCode = null;
	    	}
	    	reportParams.admissionId = values.ADMISSION_NUMBER;
	    	reportParams.studentId = values.STUDENT_ID;
	    	reportParams.programGroupId = values.PROGRAM_GROUP;
	    	reportParams.programId = values.PROGRAM_NAME;
	    	reportParams.batchId = values.BATCH_NAME;
	    	reportParams.periodId = values.PERIOD_NAME;
	    	reportParams.seatTypeId = values.SEAT_TYPE;
	    	reportParams.courseId = values.COURSE_NAME;
	    	reportParams.sectionId = values.SECTION;
	    	reportParams.admissionStatus = values.ADMISSION_STATUS;
	    	reportParams.status = values.STATUS;
	    	reportParams.phoneNo = values.PHONE_NO;
	    	reportParams.emailId = values.EMAIL_ID;
	    	reportParams.gender = values.GENDER;
	    	if(exportType.value == 'GRADUATION' || exportType.value == 'Graduation') {
	    		var reportHeader = "Student Graduation Report";
	    		var reportTitle = "Student Graduation Report";
	    		var code = 'STUDENT_GRADUATION_REPORT';
	    		reportParams.code = code;
	    		reportParams.reportTitle = code;
	    		reportParams.headerName = reportHeader;
	    		var grid = this.getSearchResultGrid();
	    		var gridData = grid.getStore().data.items;
    			if(gridData.length>0) {
	    		$this.exportJRXMLReport(code,reportParams,'Student Graduation Report','.vnd.ms-excel',SERVERURL.STUDENT_GENRATE_XLS_REPORT);
	    		//$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.STUDENT_DETAILS_XLS_REPORT);
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
				}
	    	}
	    	else if(exportType.value == 'STUDENT_COURSE_ENROLLMENT' || exportType.value == 'Student Course Enrollment Report'){var grid = this.getSearchResultGrid();
    		var records = grid.getSelectionModel().getSelection();
    		if(grid.getSelectionModel().getCount() > 0){
    			for(var i in records) {
    				var admissionParam = new Object();
    				admissionParam.id = parseInt(records[i].data.ADMISSION_ID);
    				admissionParam.value = records[i].data.STUDENT_NAME+"";
					admParams.push(admissionParam);
				}
    		}else{
    			var records = grid.getStore().data.items;
    			for(var i in records) {
    				var admissionParam = new Object();
    				admissionParam.id = parseInt(records[i].data.ADMISSION_ID);
    				admissionParam.value = records[i].data.STUDENT_NAME+"";
					admParams.push(admissionParam);
				}
    		}
    		var reportHeader = "Enrolled Courses Form";
    		var reportTitle = "Enrolled Courses Form";
	    	var code = 'STUDENT_COURSE_ENROLLMENT';
	    	reportParams.code = code;
	    	reportParams.reportTitle = reportTitle;
	    	reportParams.headerName = reportHeader;
	    	reportParams.admParams = admParams; 
	    	reportParams.orderFlag=false,
    		gridData = grid.getStore().data.items;
    		if(gridData.length>0) {
	    	$this.exportJRXMLReport(code,reportParams,code,'.pdf',SERVERURL.PATH_GET_STUDENT_COURSE_ENROLLMENT_PDF_REPORT);
			} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
			}}
	    	
	    	else if(exportType.value == 'IIMT_STUDENT_COURSE_ENROLLMENT' || exportType.value == 'IIMT Enrolled Courses Form'){
	    		var grid = this.getSearchResultGrid();
    		var records = grid.getSelectionModel().getSelection();
    		if(grid.getSelectionModel().getCount() > 0){
    			for(var i in records) {
    				var admissionParam = new Object();
    				admissionParam.id = parseInt(records[i].data.ADMISSION_ID);
    				admissionParam.value = records[i].data.STUDENT_NAME+"";
					admParams.push(admissionParam);
				}
    		}else{
    			var records = grid.getStore().data.items;
    			for(var i in records) {
    				var admissionParam = new Object();
    				admissionParam.id = parseInt(records[i].data.ADMISSION_ID);
    				admissionParam.value = records[i].data.STUDENT_NAME+"";
					admParams.push(admissionParam);
				}
    		}
    		var reportHeader = "Enrolled Courses Form";
    		var reportTitle = "Enrolled Courses Form";
	    	var code = 'IIMT_STUDENT_COURSE_ENROLLMENT';
	    	reportParams.code = code;
	    	reportParams.reportTitle = reportTitle;
	    	reportParams.headerName = reportHeader;
	    	reportParams.admParams = admParams; 
	    	reportParams.orderFlag=true,
    		records = grid.getStore().data.items;
    		if(records.length>0) {
	    	$this.exportJRXMLReport(code,reportParams,code,'.pdf',SERVERURL.PATH_GET_STUDENT_COURSE_ENROLLMENT_PDF_REPORT);
			} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
			}} 
			
	    	
	    	else if(exportType.value == 'ENROLLMENT' || exportType.value == 'Enrollment'){
	    		var reportHeader = "Student Enrollment Report";
	    		var reportTitle = "Student Enrollment Report";
	    		var code = 'STUDENT_DATA_REPORT';
	    		reportParams.code = code;
	    		reportParams.reportTitle = code;
	    		reportParams.headerName = reportHeader;
	    		var grid = this.getSearchResultGrid();
    			var records = grid.getStore().data.items;
    			if(records.length>0) {
	    		$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.STUDENT_GENRATE_XLS_REPORT);
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
				}
	    	}
	    	else if(exportType.value == 'STUDENT_DETAIL_REPORT'||exportType.value == 'Student Detail Report'){
	    		reportHeader = "Student Detail Report";
	    		reportTitle = "Student Detail Report";
	    		code = 'STUDENT_DETAIL_REPORT';
	    		reportParams.code = code;
	    		reportParams.status = values.STATUS;
	    		reportParams.headerName = reportHeader;
	    		
	    		var grid = this.getSearchResultGrid();
	    		var studentIdArray=[];
		    	var record = grid.getSelectionModel().getSelection();
		    	for(var i in record) {
		    		studentIdArray.push(record[i].data.ID);
		    	}
		    	var studentIds = studentIdArray.join(',');
		    	reportParams.studentIdsCommaSeperated = studentIds;
		    	var gridData = grid.getStore().data.items;
    			if(gridData.length>0) {
	    		$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.STUDENT_DETAILS_XLS_REPORT);
		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
				}
	    	}
	    	else if(exportType.value == 'STUDENT_DETAIL_REPORT_FOR_SCHOOL'||exportType.value == 'Student Detail Report For School'){
	    		reportHeader = "Student Detail Report For School";
	    		reportTitle = "Student Detail Report For School";
	    		code = 'STUDENT_DETAIL_REPORT_FOR_SCHOOL';
	    		reportParams.code = code;
	    		reportParams.status = values.STATUS;
	    		reportParams.headerName = reportHeader;
	    		
	    		var grid = this.getSearchResultGrid();
	    		var studentIdArray=[];
		    	var record = grid.getSelectionModel().getSelection();
		    	for(var i in record) {
		    		studentIdArray.push(record[i].data.ID);
		    	}
		    	var studentIds = studentIdArray.join(',');
		    	reportParams.studentIdsCommaSeperated = studentIds;
	    		var gridData = grid.getStore().data.items;
		    	if(gridData.length>0) {
		    		$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.STUDENT_DETAILS_XLS_REPORT);
		    	}
		    	else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
		    	}
	    	}else if(exportType.value == 'STUDENT_ACADEMIC_TOPIC_DETAILS_REPORT'){
	    		reportHeader = "Student Academic Topic Detail Report";
	    		reportTitle = "Student Academic Topic Detail Report";
	    		code = 'ACADEMIC_TOPIC_DETAIL_REPORT';
	    		reportParams.code = code;
	    		reportParams.status = values.STATUS;
	    		reportParams.headerName = reportHeader;
	    		
	    		var grid = this.getSearchResultGrid();
	    		var studentIdArray=[];
		    	var record = grid.getSelectionModel().getSelection();
		    	for(var i in record) {
		    		studentIdArray.push(record[i].data.ID);
		    	}
		    	var studentIds = studentIdArray.join(',');
		    	reportParams.studentIdsCommaSeperated = studentIds;
	    		
		    	var gridData = grid.getStore().data.items;
		    	if(gridData.length>0) {
	    		$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.STUDENT_ACADEMIC_TOPIC_DETAILS_XLS_REPORT);
		    	}
		    	else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_DATA_DISPLAY_MSG'));
		    	}
	    	} else if(exportType.value == 'SAMHS_ATTENDANCE_REPORT_EXCEL'){
	    		var grid = this.getSearchResultGrid();
	    		var records = grid.getSelectionModel().getSelection();
	    		var admissionIdArray=[];
	    		if(grid.getSelectionModel().getCount() > 0){
	    			for(var i in records) {
	    				admissionIdArray.push(records[i].data.ADMISSION_ID);
					}
	    		}
	    		var reportHeader = "SAMHS Attendance Report";
	    		var reportTitle = "SAMHS Attendance Report";
		    	var code = 'SAMHS_ATTENDANCE_REPORT_EXCEL';
		    	reportParams.code = code;
		    	reportParams.reportTitle = reportTitle;
		    	reportParams.headerName = reportHeader;
		    	var admissionIds = admissionIdArray.join(',');
		    	reportParams.admissionIds = admissionIds;
	    		if(admissionIdArray.length>0) {
		    	$this.exportJRXMLReport(code,reportParams,code,'.pdf',SERVERURL.PATH_GET_STUDENT_SAMHS_ATTENDANCE_REPORT_EXCEL);
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
	    	} else if(exportType.value == 'SAMHS_ATTENDANCE_REPORT_PDF'){
	    		var grid = this.getSearchResultGrid();
	    		var records = grid.getSelectionModel().getSelection();
	    		var admissionIdArray=[];
	    		if(grid.getSelectionModel().getCount() > 0){
	    			for(var i in records) {
	    				admissionIdArray.push(records[i].data.ADMISSION_ID);
					}
	    		}
	    		var reportHeader = "SAMHS Attendance Report";
	    		var reportTitle = "SAMHS Attendance Report";
		    	var code = 'SAMHS_ATTENDANCE_REPORT_PDF';
		    	reportParams.code = code;
		    	reportParams.reportTitle = reportTitle;
		    	reportParams.headerName = reportHeader;
		    	var admissionIds = admissionIdArray.join(',');
		    	reportParams.admissionIds = admissionIds;
	    		if(admissionIdArray.length>0) {
		    	$this.exportJRXMLReport(code,reportParams,code,'.pdf',SERVERURL.PATH_GET_STUDENT_SAMHS_ATTENDANCE_REPORT_PDF);
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
	    	}
	    	$this.getChedexportwindow().close();
	    },
	    
	    //******************Disable profile print  button**********************************
	    disableMyDashboardPivileges: function(panel,permissionsMap) {
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	var profilePrintButton = panel.down('#printBtn');
	    	
	    	profilePrintButton.setVisible(false);
	    	
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'PROFILE_PRINT') {
	        		if(!isNullOrEmpty(profilePrintButton)){
	        			profilePrintButton.setVisible(true);
	        		}        		
	        	}
	    	});
	    },
	    
	    openAssignStudentCommitteeWindow: function(grid) {
	    	var $this = this;
	    	var formWindow = $this.getStudentcommitteealwindow();
			if (!formWindow) {
				formWindow = Ext.widget('committeealwindow',{
        			itemId:'studentMapCommitteeWindow'
        		});
				//formWindow.setHeight(200);
				formWindow.setWidth(410);
				formWindow.setTitle(getCommonTranslation('COMMITTEE'));
			}
			formWindow.down('#mapCommitteeWindowId').show();
			
			var studentIdArray=[];
	    	var record = grid.getSelectionModel().getSelection();
	    	for(var i in record) {
	    		studentIdArray.push(record[i].data.ID);
	    	}
	    	var studentIds = studentIdArray.join(',');
			
			var committeeStore = formWindow.down('#committeeItemId').getStore();
			committeeStore.getProxy().extraParams = {
				academyLocationIds:$this.getCurrentAcademyLocation(),
				isStudentFaculty:true,
				isCallFromStudentListGrid: true,
				studentIds: studentIds
			};
			committeeStore.load();
			formWindow.show();
			formWindow.setOverflowXY('hide','hide');
	    },
	    
	    openCertificateSelectWin: function() {
	    	var $this = this;
	    	var user = $this.getCurrentlyLoggedInUser()
	    	var formWindow = $this.getCertificateselectionwindow();
			if (!formWindow) {
				formWindow = Ext.widget('certificateselectionwindow', {
  		            itemId: 'studentListCertificateSelectionWindow'
  		        });
				formWindow.setTitle(getCommonTranslation('PRINT_CERTIFICATE'));
			}
			formWindow.down('#printAsWordFile').setVisible(true);
			formWindow.down('#sendMultipleCertificateToStudentProfile').setVisible(false);
			var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getSTUDENT_LIST_PERMISSIONS());
    		Ext.each(permissionList, function(privilege) {
    			if (privilege === 'SEND_CERTIFICATE_TO_PROFILE_DMS') {
    				formWindow.down('#sendMultipleCertificateToStudentProfile').setVisible(true);
    			}
    		});	
			
			var certificateStore = formWindow.down('#certificate').getStore();
			certificateStore.getProxy().api.read=SERVERURL.PATH_FIND_DYNAMIC_AL_MAPPED_DOCS;
			certificateStore.getProxy().extraParams = {
				certificateCategory:'OTHER',
				academyLocationId:$this.getCurrentAcademyLocation(),
				userId : user.id
			};
			certificateStore.load({
				callback:function(record) {
					if(record) {
						formWindow.show();
						//this$.setAllowBlank(formWindow.down('#certificateComment'),false);
					}
				}
			});
			
			var grid = this.getSearchResultGrid();
			var selectedRecords = grid.getSelectionModel().getSelection(); // <-- yeh line change hai

			var programIdSet = {};
			var studentIdSet = {};

			for (var i = 0; i < selectedRecords.length; i++) {
			    var rec = selectedRecords[i];
			    var programId = rec.get('PROGRAM_ID');
			    var studentIds = rec.get('USER_ID');

			    if (programId) {
			        programIdSet[programId] = true;
			    }

			    if (studentIds) {
			        studentIdSet[studentIds] = true;
			    }
			}

			// Convert sets to comma-separated strings
			var programIdList = Object.keys(programIdSet).join(',');
			var studentIdList = Object.keys(studentIdSet).join(',');

			// Set to period store's extraParams
			var periodStore = formWindow.down('#periodName').getStore();
			periodStore.getProxy().extraParams = {
			    programIds: programIdList,
			    studentIds: studentIdList 
			};  
			periodStore.load();
						
			},
    	    openAttestationCertificateSelectWin: function() {
	    	var $this = this;
	    	var user = $this.getCurrentlyLoggedInUser();
	    	var formWindow = $this.getAttestationstatementofstudentjourneywindow();
			if (!formWindow) {
				formWindow = Ext.widget('attestationstatementofstudentjourneywindow', {
  		            itemId: 'studentListAttestationStatementOfStudentJourneyWindow'
  		        });
				formWindow.setTitle(getCommonTranslation('PRINT_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY'));
			}
			formWindow.show();
			formWindow.down('#attestationPrintAsWordFile').setVisible(true);
	    },
	    openStudentSendMessage:function(obj){

	    	var grid = this.getSearchResultGrid();
	    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
	    	if(grid.getSelectionModel().getCount()>0) {
	    		
	    			var $this=this;
	    			var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	    	       	   var structure = Ext.widget('studentsendmessages',{
               			itemId:'studentListSendMessageWindows'
               		});
	    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
	    	       	   /**
	    	       	    * This is to remove tab from content panel and open same tab again
	    	       	    */
	    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	    	       	   var getTab=getcontroller.getTab(tabName);
	    	       	   if(getTab!=null){
	    	       		   contentPanel.remove(getTab, true);
	    	       	   }
	    	       	var formWindowTab = $this.getStudentsendmessages();
	    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
	    	       	formWindowTab.down("#selectTemplate").setVisible(false);
	    	       	formWindowTab.down("#messageName").allowBlank=true;   
	    	       	formWindowTab.down("#messageName").setVisible(false);
	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
	    			templateStore.getProxy().extraParams={
	    				msgRecipientTypeId:2
	    			};
	    			templateStore.load();
	    			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	    			   Ext.Ajax.request({
	    				   method : "GET",
	    				   type : 'rest',
	    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
	    				   headers : {
	    					   'Content-Type' : 'application/json'
	    				   },
	    				   success : function(form,action) {
	    					   var data = Ext.JSON.decode(form.responseText);
	    					   formWindowTab.down("#id").setValue(data.id);
	    					   formWindowTab.down("#code").setValue(data.code);
	    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
	    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
	    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
	    					   Ext.getBody().unmask();
	    					   
	    					   //grid.getStore().reload();
	    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
	    				   }

	    			   });
	    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_TWO);
	    	       	setTimeout(function(){
	    	       		formWindowTab.down("#templateId").setVisible(false);
					  },100);
	    			/*if (!formWindow) {
	    				Ext.widget('studentsendmessages');
	    				formWindow = $this.getstudentsendmessages();
	    			}
	    			formWindow.show(;*/
	    		
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    selectSectionMessageType : function(val,nV,oV){

	      	 var $this =  this;
	      	 var formWin = $this.getStudentsendmessages();

	      	 //var value = nV.1;
	      	formWin.down('#recieverTypeIncludeMySelf').setValue(false);
	      	 if(nV.messageType==2){
	      		 formWin.down("#messageId").hide();
	      		 formWin.down("#selectTemplate").allowBlank=true;
	      		 formWin.down("#selectTemplate").setVisible(false);     		 
	      		 formWin.down("#messageName").allowBlank=true;   
	      		 formWin.down("#messageName").setVisible(false);
	      		 formWin.down("#msgTempletId").setVisible(true);
	      		 formWin.down("#msgTempletId").allowBlank=false;
	      		 formWin.down("#msgTempletId").reset();
	      		 formWin.down("#subject").setVisible(true);
	      		 //formWin.down("#subject").allowBlank=false;
	      		 formWin.down("#subject").reset();
	      		 formWin.down("#discriptionId").setVisible(true);
	      		 formWin.down("#discriptionId").reset();
	      		 formWin.down('#smsDiscription').reset();
	      		 formWin.down('#smsDiscription').hide();
	      		 formWin.down('#smsDiscriptionNotice').hide();
	     		 formWin.down('#pushNotificationDiscription').hide();
	     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
	     		 formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
	      		 this.setAllowBlank (formWin.down("#subject"),false);
	      	 }else{
	      		 formWin.down("#msgTempletId").allowBlank=true;
	      		 formWin.down("#msgTempletId").setVisible(false);     		
	      		 formWin.down("#messageId").setVisible(true);
	      		 formWin.down("#selectTemplate").setVisible(true);     		
	      		 formWin.down("#messageName").setVisible(true);
	      		 formWin.down("#messageName").reset();
	      		 //formWin.down("#subject").allowBlank=true;
	      		 this.setAllowBlank (formWin.down("#subject"),true);
	      		 formWin.down("#subject").setVisible(false);
	      		 formWin.down("#discriptionId").setVisible(false);
	      		 formWin.down("#messageName").allowBlank=false;  
	      		 formWin.down("#selectTemplate").allowBlank=false;
	      		 formWin.down("#selectTemplate").reset();
	      		 formWin.down("#studentDocumentMessageAttachmentGrid").setVisible(false);
	      		 formWin.down("#staticUploadFileField").setVisible(false);
	      		 formWin.down('#smsDiscription').reset();
	      		 formWin.down('#smsDiscription').hide();
	      		 formWin.down('#smsDiscriptionNotice').hide();
	     		 formWin.down('#pushNotificationDiscription').hide();
	     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
	     		 formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
	      		 this.setAllowBlank (formWin.down("#messageName"),false);
	      		 this.setAllowBlank (formWin.down("#selectTemplate"),false);
	      		// var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
	      		// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
	      		 //formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
	      	 }
	       },
	       selectMessageTemp: function(obj,rec){
	       	var $this =  this;
	       	 var formWin = $this.getStudentsendmessages();
	      	 var subject = formWin.down('#subject');
	      	 var smsDiscription = formWin.down('#smsDiscription');
	 		 var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
	 		 var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
	 		 var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
	       	 if(rec[0].data.value == "SMS")
	       	 {  formWin.down("#templateId").setVisible(false);
	       		formWin.down("#templateId").allowBlank=true;
	   	       	Ext.Ajax.request({
	    	   		type: 'rest',
	    	   		async: false,
	    	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	    	   		params: {
	    	   			screenName: 'studentsendmessages',
	    	   			academyLocationId: this.getCurrentAcademyLocation(),
	    	   			languageCode:'en'
	    	   		},
	    	   		method: 'GET',
	    	   		success: function(res, action) {
	    	   			var response = Ext.decode(res.responseText);
	    	   			if( Object.keys(response).length > 0 ){
	    	   				var records=response.studentsendmessages;
	    	   				for(i in records){
	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isVisible==true){
	    	   						formWin.down("#templateId").setVisible(true);
	    	   					}
	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true){
	    	   						formWin.down("#templateId").allowBlank=false;
	    	   					}
	    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true && records[i].isVisible==false){
	    	   						formWin.down("#templateId").allowBlank=true;
	    	   					}
	    	   					
	    	   				}
	    	   			}else{
	    	   				formWin.down("#templateId").setVisible(false);
	    	   				formWin.down("#templateId").allowBlank=true;
	    	   			}
	    	   		}
	    	   		
	    	   	});
	       		 this.setAllowBlank (formWin.down("#subject"),true);
	       		 //formWin.down("#subject").allowBlank=true;
	       		 formWin.down("#subject").hide();
	       		 formWin.down("#staticUploadFileField").hide();
	       		 formWin.down("#studentDocumentMessageAttachmentGrid").hide();
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#discriptionId').hide();	       		 
	       		 formWin.down('#subject').reset();
	       		 formWin.down('#smsDiscription').show();
	       		 formWin.down('#smsDiscriptionNotice').show();
	      		 pushNotificationDiscription.hide();
	      		 pushNotificationDiscriptionNotice.hide();
	      		 pushNotificationDiscription.reset();
	       	 }/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	      		 subject.show();
	      		 formWin.down("#staticUploadFileField").hide();
	      		 this.setAllowBlank(subject,false);
	      		 formWin.down("#studentDocumentMessageAttachmentGrid").hide();
	      		 formWin.down('#discriptionId').reset();
	      		 formWin.down('#discriptionId').hide();
	      		 subject.reset();
	      		 smsDiscription.reset();
	      		 smsDiscription.hide();
	      		 smsDiscriptionNotice.hide();
	      		 pushNotificationDiscription.reset();
	      		 pushNotificationDiscription.show();
	      		 pushNotificationDiscriptionNotice.show();
	      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
	      		 //formWin.down('#smsDiscription')
	      	 }*/else{
	      		formWin.down("#templateId").hide();
	       		formWin.down("#templateId").allowBlank=true;
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#smsDiscription').reset();
	       		 formWin.down('#smsDiscription').hide();
	       		 formWin.down('#smsDiscriptionNotice').hide();
	       		 formWin.down("#staticUploadFileField").show();
	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
	       		 formWin.down("#studentDocumentMessageAttachmentGrid").show();
	       		 formWin.down("#subject").reset();
	       		 formWin.down("#subject").show();
	       		 this.setAllowBlank (formWin.down("#subject"),false);
	       		 //formWin.down("#subject").allowBlank=false;
	       		 formWin.down('#discriptionId').show();
	      		 pushNotificationDiscription.hide();
	      		 pushNotificationDiscriptionNotice.hide();
	      		 pushNotificationDiscription.reset();
	       	 }
	       },
	       /**
	        * upload static document file for Student
	        */
	       uploadStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	    	   var this$ = this;
	    	   var setupForm = fileField.up('studentsendmessages');
	    	   var grid = setupForm.down('#studentStaticDocumentAttachmentGridMessage');
	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	    	   fileField.setRawValue(fileUploadPath);
	    	   var file = fileField.fileInputEl.dom.files[0];
	    	   fileField.setRawValue(fileUploadPath);
	    	   var fileSizeLimit = '5';
	    	   var url = SERVERURL.FILE_PRIORITY;
	    	   Ext.Ajax.request({
					type: 'rest',
					url: url+'?type=emailFileSize',
					method: 'GET',
					success : function(response, action){
						var responseData = Ext.JSON.decode(response.responseText);
						if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
						{
							fileSizeLimit=responseData[0].value;
						}
	    	   if((file.size / 1048576) <=  fileSizeLimit ){
	    		   if(!isNullOrEmpty(fileUploadPath)){
	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    			   if (extension == "gif" || extension == "png" || extension == "bmp"
	    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	    					   || extension == "doc" || extension == "docx" || extension == "txt"
	    						   || extension == "xls" || extension == "csv" || extension == "xml" 
	    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
	    				   var entityId = 'student';
	    				   var module = 'messaging';
	    				   var entityType = 'template';
	    				   var documentType = 'DOCUMENT';
	    				   var isTransient = true;
	    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
	    				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	    					   if(success){
	    						   Ext.getBody().unmask();
	    						   var path = Ext.JSON.decode(action.response.responseText).path;
	    						   var user = this$.getCurrentlyLoggedInUser();
	    						   var store = grid.getStore();
	    						   var documentStatus = "SUBMITTED";
	    						   var documentType = null;
	    						   if(!isNullOrEmpty(path)){
	    							   store.add({
	    								   id: '',
	    								   name: fileUploadPath,
	    								   path: path ,
	    								   createdBy : {
	    									   id :user.id,
	    									   value : user.value,
	    									   code : user.code
	    								   },
	    								   status : documentStatus,
	    								   documentType : documentType,
	    								   templateConfigDocId: '',
	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	    							   });
	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	    						   }
	    						   var form=this$.getStudentsendmessages();
	           	            	   var subject = form.down('#subject').getValue();
	           	            	   if(!isNullOrEmpty(subject)){
	           	            		   if(subject == ' '){
	           	            			form.down('#subject').reset();
	           	            		   }
	           	            	   }
	    						   fileField.reset();
	    					   }

	    				   }, isTransient);
	    			   }else{
	    				   fileField.reset();
	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    			   }
	    		   }
	    	   }else{
	    		   fileField.reset();
	    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
	    	   }
	       	   }
			   });
	       },

	       /**
	        * Add value to grid
	        */
	       loadGridWithFileNameMessage:function(grid,value,store){
	    	   grid.bindStore(store);
	       },
	       /**
	        * Remove entry from grid
	        */
	       deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	    	   var grid = view.up('#studentStaticDocumentAttachmentGridMessage');
	    	   var panel = this.getContentPanel().getActiveTab();
	    	   var tabTitle = panel.title;
	    	   var store = grid.getStore();
	    	   var templateConfigDocId = record.get('templateConfigDocId');
	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	    	   if(!(tabTitle == viewTitle)){
	    		   if(!isNullOrEmpty(templateConfigDocId)){
	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	    				   if (btn == 'yes') {
	    					   Ext.Ajax.request({
	    						   type: 'rest',
	    						   url: SERVERURL.STATIC_DOC_DELETE,
	    						   method: 'DELETE',
	    						   params: {
	    							   templateConfigDocId : templateConfigDocId
	    						   },
	    						   headers: {
	    							   'Content-Type': 'application/json'
	    						   },
	    						   success: function(form, action) {
	    							   store.remove(record);
	    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    						   }
	    					   });
	    				   }
	    			   });

	    		   }else{
	    			   store.remove(record);
	    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    		   }
	    	   }else{
	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	    	   }

	       },
	       /**
	        * save document file. It's external call method
	        * @param entityId : person id, It's mandatory. 
	        * @param module : module name, for student module 'student', It's mandatory.
	        * @param entityType : entity type, It's mandatory.
	        * @param documentType : document type, It's mandatory.
	        * @param isTransient : true or false (send json back to module controller or not)
	        * @param callBackFunction : callback function return in module controller. It's mandatory.
	        */
	       saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
	       	var submitUrl = '';
	       	var templateTab = this.getContentPanel();
	       	var formWin =  this.getStudentsendmessages();
	       	var form = formWin.down('#msgDetailsForm');
	       	var id = form.down('#document_hidden_field');
	           if (isNullOrEmpty(id.getSubmitValue())) {
	               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
	           }
	           var data = new Object();
	           if(!isNullOrEmpty(entityId)){
	           	data.entityId = entityId;
	           }else{
	           	data.entityId = null;
	           }
	           if(!isNullOrEmpty(module)){
	           	data.module = module;
	           }else{
	           	data.module = null;
	           }
	           if(!isNullOrEmpty(entityType)){
	           	data.entityType = entityType;
	           }else{
	           	data.entityType = null;
	           }
	           form.getForm().setValues(data);
	           form.getForm().submit({
	           	method : 'POST',
	           	url : submitUrl,
	           	success : function(form, action){
	           		callBackFunction(true, action, isTransient);
	           		
	           	}
	           });
	       }, 
	       /**
	        * This method is to enable schedule field
	        */
	       loadStudentScheduleField : function(radio,newValue, oldValue){
	       	var adhocMessageForm = radio.up('form');
	       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	       	var radioValue = radio.getValue().sendingPriority;
	       	
	       	if(radioValue=='IMMEDIATE'){
	       		scheduleDateField.setVisible(false);
	       		scheduleDateField.setDisabled(true);
	       		scheduleTimeField.setVisible(false);
	       		scheduleTimeField.setDisabled(true);    		
	       	}
	       	else if(radioValue=='SCHEDULE'){
	       		scheduleDateField.setVisible(true);
	       		scheduleDateField.setDisabled(false);
	       		scheduleTimeField.setVisible(true);
	       		scheduleTimeField.setDisabled(false);
	       	}
	       },
	       
	       //*******START:Applied Permission Management for Student Impot utilities***********//
	       disablestndetImportTabs: function(structure, permissionsMap) {
	    	    var associatedAcadLocationIds = new Array();
	    	    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    	    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	    var studentUpdateTab = false,
	    	        studentStatusLoaderTab=false,
	    	        studentRelationshipTab = false,
	    	        studentAcademicTopicTab = false,
	    	    	studentPastHistoryImportTab = false,
	    	    	studentBulkDocumentDownloadStatusTab = false,
	    	    	studentImportAggregationsTab =false,
	    	    	studentImportPostGraduation=false;
	    	    for (var i = 0; i < permissionList.length; i++) {
	    	        if (permissionList[i] === "IMPORT_BULK_STUDENT_UPDATE") {
	    	            studentUpdateTab = true;
	    	        }
	    	        if (permissionList[i] === "IMPORT_BULK_STUDENT_RELATIONSHIP") {
	    	            studentRelationshipTab = true;
	    	        }
	    	        if (permissionList[i] === "IMPORT_BULK_STUDENT_ACADEMIC_TOPIC") {
	    	            studentAcademicTopicTab = true;
	    	        }
	    	        if (permissionList[i] === "IMPORT_EDUCATION_HISTORY") {
	    	        	studentPastHistoryImportTab = true;
	    	        }
	    	        if (permissionList[i] === "BULK_DOCUMENT_DOWNLOAD_STATUS") {
	    	        	studentBulkDocumentDownloadStatusTab = true;
	    	        }
	    	        if (permissionList[i] === "IMPORT_AGGREGATIONS") {
	    	        	studentImportAggregationsTab = true;
	    	        }
	    	        if(permissionList[i] === "IMPORT_STUDENT_STATUS"){
	    	        	studentStatusLoaderTab=true;
	    	        }
	    	        if(permissionList[i] === "IMPORT_STUDENT_POST_GRADUATION"){
	    	        	studentImportPostGraduation=true;
	    	        }
	    	    }

	    	    this.showStudentImportTab(studentUpdateTab,studentStatusLoaderTab, studentRelationshipTab, studentAcademicTopicTab, studentPastHistoryImportTab,
	    	    		studentBulkDocumentDownloadStatusTab,studentImportAggregationsTab, structure,studentImportPostGraduation);
	    	},

	       showStudentImportTab: function(studentUpdateTab,studentStatusLoaderTab, studentRelationshipTab, studentAcademicTopicTab,studentPastHistoryImportTab, 
	    		   studentBulkDocumentDownloadStatusTab,studentImportAggregationsTab, structure,studentImportPostGraduation) {
	    	    var panelItem = new Array();
	    	    var $this = this;
	    	    var newcont = structure.items.items.length;
	    	    var insertPosition = newcont + 1;
	    	   /* if ((studentUpdateTab && studentRelationshipTab) && studentAcademicTopicTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentuploaddownloadstructure',
	    	                itemId: 'studentuploaddownloadstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_UPDATE')
	    	            }, {
	    	                xtype: 'studentrelationshipstructure',
	    	                itemId: 'studentrelationshipstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_RELATIONSHIP')
	    	            }, {
	    	                xtype: 'studentacademictopicstructure',
	    	                itemId: 'studentacademictopicstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_ACADEMIC_TOPIC')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else if (studentUpdateTab && studentRelationshipTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentuploaddownloadstructure',
	    	                itemId: 'studentuploaddownloadstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_UPDATE')
	    	            }, {
	    	                xtype: 'studentrelationshipstructure',
	    	                itemId: 'studentrelationshipstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_RELATIONSHIP')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else if (studentUpdateTab && studentAcademicTopicTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentuploaddownloadstructure',
	    	                itemId: 'studentuploaddownloadstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_UPDATE')
	    	            }, {
	    	                xtype: 'studentacademictopicstructure',
	    	                itemId: 'studentacademictopicstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_ACADEMIC_TOPIC')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else if (studentRelationshipTab && studentAcademicTopicTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentrelationshipstructure',
	    	                itemId: 'studentrelationshipstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_RELATIONSHIP')
	    	            }, {
	    	                xtype: 'studentacademictopicstructure',
	    	                itemId: 'studentacademictopicstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_ACADEMIC_TOPIC')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else if (studentUpdateTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentuploaddownloadstructure',
	    	                itemId: 'studentuploaddownloadstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_UPDATE')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else if (studentRelationshipTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentrelationshipstructure',
	    	                itemId: 'studentrelationshipstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_RELATIONSHIP')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else if (studentAcademicTopicTab) {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	                xtype: 'studentacademictopicstructure',
	    	                itemId: 'studentacademictopicstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_ACADEMIC_TOPIC')
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            }]
	    	        });

	    	    } else {
	    	        panelItem.push({
	    	            xtype: 'tabpanel',
	    	            itemId: 'allVisibleTP',
	    	            plain: true,
	    	            style: {
	    	                overflow: 'hidden !important',
	    	                margin: '0!important'
	    	            },
	    	            bodyStyle: {
	    	                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    	            },
	    	            tabbar: {
	    	                cls: 'SearchTabPanelWithRightTabs',
	    	                componentCls: 'searchTabComponent'
	    	            },
	    	            frame: false,
	    	            border: false,
	    	            defaults: {
	    	                labelAlign: 'top'
	    	            },
	    	            items: [{
	    	                xtype: 'studentquicksearchview',
	    	                title: getCommonTranslation('SEARCH'),
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'advancedsearchquerybuilder',
	    	                itemId: 'studentListAdvanceSearch',
	    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
	    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
	    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
	    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
	    	                moduleName: "STUDENTS",
	    	                tabCls: 'right-tab'
	    	            }, {
	    	                xtype: 'hidden',
	    	                itemId: 'serviceRequestType',
	    	                value: 'STUDENT_REQUEST'
	    	            }, {
	    	            	xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	    	            } ]
	    	        });

	    	    }*/
	    	    
	    	    
	    	    var panelItem = new Array();
	            var $this = this;
	            var newcont = structure.items.items.length;
	            var insertPosition = newcont;
	            panelItem.push({
	                xtype: 'tabpanel',
	                itemId: 'allVisibleTP',
	                plain: true,
	                style: {
	                    overflow: 'hidden !important',
	                    margin: '0!important'
	                },
	                bodyStyle: {
	                    margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	                },
	                frame: false,
	                border: false,
	                defaults: {
	                    labelAlign: 'top'
	                },
	                items: [{
    	                xtype: 'studentquicksearchview',
    	                title: getCommonTranslation('SEARCH'),
    	                tabCls: 'right-tab',
    	                listeners: {
    	                	activate: function(me, eOpts){
    	                		var  contentPanelMain = $this.getContentPanel().getActiveTab();
    	                		if(!isNullOrEmpty(contentPanelMain)){
    	                			contentPanelMain.scrollBy(0,1);
    	                			contentPanelMain.scrollBy(0,-1);
    	                		}
    	                	}
    	                }
    	            }, {
    	                xtype: 'advancedsearchquerybuilder',
    	                itemId: 'studentListAdvanceSearch',
    	                searchConfigCode: CONSTANTS.CB.STUDENT_LIST_CONFIGCODE,
    	                searchResultViewCode: CONSTANTS.CB.STUDENT_LIST_VIEWCODE,
    	                permissionMapKey: "STUDENT_LIST_PRIVILEGES",
    	                gridTitle: getCommonTranslation("STUDENT_LIST"),
    	                moduleName: "STUDENTS",
    	                tabCls: 'right-tab'
    	            }, {
    	                xtype: 'hidden',
    	                itemId: 'serviceRequestType',
    	                value: 'STUDENT_REQUEST'
    	            }]
	            });

	            var insertAt = panelItem["0"].items.length;
	            if (studentUpdateTab) {
	                panelItem["0"].items[insertAt] = {
	                    xtype: 'studentuploaddownloadstructure',
	                    itemId: 'studentuploaddownloadstructureId',
	                    title: getTranslation('IMPORT_STUDENT_UPDATE')

	                };
	                insertAt = insertAt + 1;
	            }
	            if (studentRelationshipTab) {
	                panelItem["0"].items[insertAt] = {
	                		xtype: 'studentrelationshipstructure',
	    	                itemId: 'studentrelationshipstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_RELATIONSHIP')

	                };
	                insertAt = insertAt + 1;
	            }
	            /*if (studentAcademicTopicTab) {
	                panelItem["0"].items[insertAt] = {
	                		xtype: 'studentacademictopicstructure',
	    	                itemId: 'studentacademictopicstructureId',
	    	                title: getTranslation('IMPORT_STUDENT_ACADEMIC_TOPIC')	
	                };
	                insertAt = insertAt + 1;
	            }*/
	            
	            if (studentPastHistoryImportTab) {
	                panelItem["0"].items[insertAt] = {
	                		xtype:'educationhistoryuploaddownloadstructure',
	    	            	itemId:'educationhistoryuploaddownloadstructure',
	    	            	title: getTranslation('IMPORT_EDUCATION_HISTORY')
	                };
	                insertAt = insertAt + 1;
	            }
	            if (studentBulkDocumentDownloadStatusTab) {
	            	
	            	panelItem["0"].items[insertAt] = {
	            			xtype: 'studentbulkdownloadstatusstructure',
	            			itemId: 'studentbulkdownloadstatusstructureId',
	            			title: getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_STATUS'),
	            			listeners: {
	            				activate: function(me, eOpts){
	            					var  contentPanelMain = $this.getContentPanel().getActiveTab();
	            					if(!isNullOrEmpty(contentPanelMain)){
	            						contentPanelMain.scrollBy(0,1);
	            						contentPanelMain.scrollBy(0,-1);
	            					}
	            				}
	            			}
	            	};
	                insertAt = insertAt + 1;
	            }
	            if (studentAcademicTopicTab) {
	                panelItem["0"].items[insertAt] = {
	                		xtype: 'studentacademictopicstructure',
	    	                itemId: 'studentacademictopicstructureId',
	    	                //title: getTranslation('IMPORT_STUDENT_ACADEMIC_TOPIC'),
	    	                title: getTranslation('IMPORT_OTHER_DETAILS')	
	                };
	                insertAt = insertAt + 1;
	            }
						if (studentImportAggregationsTab) {

							panelItem["0"].items[insertAt] = {
								xtype : 'aggregationstabstructure',
								itemId : 'aggregationstabstructureId',
								title : getTranslation('IMPORT_AGGREGATIONS'),
								listeners : {
									activate : function(me, eOpts) {
										var contentPanelMain = $this
												.getContentPanel()
												.getActiveTab();
										if (!isNullOrEmpty(contentPanelMain)) {
											contentPanelMain.scrollBy(0, 1);
											contentPanelMain.scrollBy(0, -1);
										}
									}
								}
							};
							insertAt = insertAt + 1;
						}
						if (studentStatusLoaderTab) {
			                panelItem["0"].items[insertAt] = {
			                    xtype: 'studentstatusloaderstructure',
			                    itemId: 'studentstatusloaderstructureId',
			                    title: getCommonTranslation('IMPORT_STUDENT_STATUS')
			                };
			                insertAt = insertAt + 1;
			            }
						if (studentImportPostGraduation) {
			                panelItem["0"].items[insertAt] = {
			                    xtype: 'studentImportPostGraduationStructure',
			                    itemId: 'studentImportPostGraduationStructureId',
			                    title: getCommonTranslation('IMPORT_STUDENT_POST_GRADUATION')
			                };
			                insertAt = insertAt + 1;
			            }
	            
	    	    structure.insert(insertPosition, panelItem);
	    	},
	    	// *******END:Applied Permission Management for Student Impot
			// utilities***********//
	    	
	    	/*Save Request Document Generate Student*/
   	        sendStudentBulkDocumentGenerateDetail:function(obj){
   	        	var $this = this;
   	        	var grid = $this.getSearchResultGrid();
   	        	var bulkWin = $this.getBulkdownloaddocumentwin();
   	        	var bulkWinForm = bulkWin.down('form');
   	        	
   	        	var userId = bulkWin.down('#user_name').getValue();
   	        	var fileNameFormat = bulkWin.down('#fileNameFormat').getValue().fileNameFormat;
   	        	var folderStructure = bulkWin.down('#folderStructure').getValue().folderStructure;
   	       
   	        	var selected = grid.selModel.getSelection();
   	        	var applicationIdArray = []; 
   	        	var applicationCodeArray = [];
   	        	var documentIdCodeArray = [];
   	        	if( selected.length > 0){
   	        		for( var i = 0; i < selected.length; i++) {
   	        			var applicant = new Object();
   	        			applicant.code = selected[i].data.STUDENT_ID;
   	        			applicant.value = selected[i].data.STUDENT_NAME;
   	        			applicant.id = selected[i].data.PERSON_ID;
	        			
   	        			applicationIdArray.push(applicant);
   	        		}
   	        	var documentIds = bulkWin.down('#applicationDocumentsId').getValue();

   	        	if(documentIds.length > 0) {
   	        		for( var i = 0; i < documentIds.length; i++) {
   	        			var document = new Object();
	        			document.code = documentIds[i].data.documentName;
	        			document.value = documentIds[i].data.documentType;
	        			document.id = documentIds[i].data.id;
	        			documentIdCodeArray.push(document);	
   	        		}	
   	        	}		
   	        		var formData = {
   	        			"applicationIds":applicationIdArray,
        			    "documentIds":documentIdCodeArray,
   	        			"fileNameFormate":fileNameFormat,
   	        			"folderStructureBy":folderStructure,
   	        			"userId":userId,
   	        			"requestFor":"STUDENT",
   	        		};  	        		
   	        		
   	        	}
   	        	submitUrl = SERVERURL.PATH_SAVE_BULK_DOCUMENT_DOWNLOAD;
   	     		Ext.Ajax.request({
   	     			type : 'rest',
   	     			url : submitUrl,
   	     			jsonData : formData,
   	     			method : 'POST',
   	     			success : function(form, action) {
   	     			showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'),getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST'));
   	     			}
   	     		});
   	     		obj.up('window').close();
   	        }
	    	,
	    	/**
	    	 * This method is used to getAdmission Ids for Student
	    	 */
	    	getStudentReceipientIdsForSendingMessages : function(grid){
	    		
	    		if (grid.getSelectionModel().getCount() > 0) {
	    			var records = grid.getSelectionModel().getSelection();
	    			var ids=[];
	    			if(grid.itemId == 'StudentSearchResultGrid'){
	    				for(var i in records) {
	    					ids.push(records[i].data.ADMISSION_ID);
	    				}
	    			}			
	    		}
	    		return ids;
	    	},
	        deleteSelectedStudents:function(){
	        	var $this=this;
	        	var grid=$this.getSearchResultGrid();
	        	var selectionModel = grid.getSelectionModel().getSelection();
	        	var IdsArr = [];
	        	selectionModel.forEach(function(obj){
	        		IdsArr.push(obj.get('ID'));
	        	});
	        	if (IdsArr.length > 0) {
	        		showConfirmMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	        			if (btn == 'yes') {
	        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        				Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
	        				Ext.Ajax.request({
	        					method : "DELETE",
	        					type : 'rest',
	        					url : SERVERURL.PATH_STUDENTS_DELETE+'?studentIds='+ IdsArr.join(),
	        					headers : {
	        						'Content-Type' : 'application/json'
	        					},
	        					success : function(response,action) {
	        						Ext.getBody().unmask();
	        						var record = Ext.decode(response.responseText);
	        						if(record==true){
	        							grid.getStore().reload();
	        							showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('PATH_STUDENT_DELETE_SUCCESS_MSG'));	
	        						}else{
	        							showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('PATH_STUDENT_NOT_DELETE_MESSAGE'));
	        						}
	        					}
	        				});
	        			}
	        		});
	        	}else {
	        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        },
	       MakeActiveSelectedStudents:function(){
	        	var $this=this;
	        	var grid=$this.getSearchResultGrid();
	        	var selectionModel = grid.getSelectionModel().getSelection();
	        	var IdsArr = [];
	        	var AdmissionArr = [];
	        	selectionModel.forEach(function(obj){
	        		IdsArr.push(obj.get('ID'));
	        		AdmissionArr.push(obj.get('ADMISSION_ID'));
	        	});
	        	if (IdsArr.length > 0) {
	        		showConfirmMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('ACTIVATE_STUDENTS_CONFIRM_MESSAGE'),function(btn,text){
	        			if (btn == 'yes') {
	        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        				Ext.Ajax.request({
	        					method : "POST",
	        					type : 'rest',
	        					url : SERVERURL.PATH_STUDENTS_REACTIVATE_BY_ADMISSION_ID+'?studentIds='+ IdsArr.join()+'&admissionIds='+
	        					AdmissionArr.join(),
	        					headers : {
	        						'Content-Type' : 'application/json'
	        					},
	        					success : function(response,action) {
	        						Ext.getBody().unmask();
	        						var record = Ext.decode(response.responseText);
	        						if(record==true){
	        							grid.getStore().reload();
	        							showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('STUDENT_ACTIVATED_SUCCESS_MSG'));	
	        						}else{
	        							showSuccessMessage(getCommonTranslation('STUDENTS_HEADER_MESSAGE'),getCommonTranslation('STUDENT_NOT_ACTIVATED_MESSAGE'));
	        						}
	        					}
	        				});
	        			}
	        		});
	        	}else {
	        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        },
	        loadGridAndSearchUsersWithButtonPermission: function(model, records) {
	            var SearchForm = this.getStudentQuickSearchForm();
	            var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
	            SearchForm.down('#searchButtonId').setDisabled(true);
//	            Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	            var ResultGrid = this.getSearchResultGrid();
	            var searchResultForm = SearchForm.getForm();
	            var statusField =searchResultForm.findField('STATUS').getValue();
	            var admStatusField =searchResultForm.findField('ADMISSION_STATUS').getValue();
	            var associatedAcadLocationIds = new Array();	            
	            associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_LIST_PERMISSIONS());
	        	buttonsToolBar = ResultGrid.query('toolbar')[0];
	        	var resetButton = ResultGrid.down('#resetButtonItemId');
	        	var sendMessageBtn = ResultGrid.down('#sendMessageBtn');
	        	var spBtnMoreActionsBtn = ResultGrid.down('#spBtnMoreActions');
	        	var makeActiveBtn = ResultGrid.down('#makeActiveBtn');
	        	var printIdCardMultipleBtn = ResultGrid.down('#printIdCardMultipleBtn');
	        	var raiseRequestButton = ResultGrid.down('#raiseRequestButtonItemId');   
	        	var assignStudentCommittee = ResultGrid.down('#assignStudentCommitteeBtn');
	        	var bulkDownloadDoc = ResultGrid.down('#bulkDownloadDocId');              
	        	var sendSurvey = ResultGrid.down('#sendSurveyBtn');            
	        	var offerLetterDetails = ResultGrid.down('#offerLetterDetailsItemId'); 
	        	var kohastudentlibrarymapping = ResultGrid.down('#kohastudentlibrarymappingBtn'); 
	        	var kohastudentcategorymapping = ResultGrid.down('#kohastudentcategorymappingBtn');
	        	var studentDocumentRequestId = ResultGrid.down('#studentDocumentRequestId');
	        	var changePrimaryLocationBtn = ResultGrid.down('#changePrimaryLocationBtn');
	        	var applyForHostelBtn = ResultGrid.down('#applyForHostelBtn'); 
	        	var applyForHostelWaitingListBtn = ResultGrid.down('#applyForHostelWaitingListBtn');
	        	studentDocumentRequestId.setDisabled(true);
	        	var offerLetterButtonStatus = false;
	        	var moreActionStatus = false;
	        	
	        	sendMessageBtn.setVisible(false);
	        	resetButton.setVisible(false);
	        	spBtnMoreActionsBtn.setVisible(false);
	        	makeActiveBtn.setVisible(false);
	        	printIdCardMultipleBtn.setVisible(false);
	        	raiseRequestButton.setVisible(false);
	        	assignStudentCommittee.setVisible(false);
	        	bulkDownloadDoc.setVisible(false);
	        	sendSurvey.setVisible(false);
	        	offerLetterDetails.setVisible(false);
	        	kohastudentlibrarymapping.setVisible(false);
	        	kohastudentcategorymapping.setVisible(false);
	        	changePrimaryLocationBtn.setVisible(false);
	        	applyForHostelBtn.setVisible(false);
	        	applyForHostelWaitingListBtn.setVisible(false);
	        	
	        	Ext.each(permissionList, function(privilege) {
	        		if (privilege === 'CHANGE_PRIMARY_LOCATION') {
	            		var button = buttonsToolBar.query('#changePrimaryLocationBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(admStatusField == true){
	            				changePrimaryLocationBtn.setVisible(true);	
	            			}else{
	            				changePrimaryLocationBtn.setVisible(false);	
	            			}
	            		}        		
	            	}
	        		if (privilege === 'APPLY_FOR_HOSTEL') {
	            		var button = buttonsToolBar.query('#applyForHostelBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(admStatusField == true || statusField == true){
	            				applyForHostelBtn.setVisible(true);	
	            			}else{
	            				applyForHostelBtn.setVisible(false);	
	            			}
	            		}        		
	            	}
	        		if (privilege === 'APPLY_FOR_HOSTEL_WAITING_LIST') {
	            		var button = buttonsToolBar.query('#applyForHostelWaitingListBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(admStatusField == true || statusField == true){
	            				applyForHostelWaitingListBtn.setVisible(true);	
	            			}else{
	            				applyForHostelWaitingListBtn.setVisible(false);	
	            			}
	            		}        		
	            	}
	        		if (privilege === 'RESETPASSWORD') {
	            		var button = buttonsToolBar.query('#resetButtonItemId')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true){
	            				resetButton.setVisible(true);	
	            			}else{
	            				resetButton.setVisible(false);	
	            			}
	            		}        		
	            	}
	        	
	        		if (privilege === 'SENDMESSAGE') {
	            		var button = buttonsToolBar.query('#sendMessageBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true){
	            				sendMessageBtn.setVisible(true);	
	            			}else{
	            				sendMessageBtn.setVisible(true);	
	            			}
	            		}        		
	            	}
	        		if (privilege === 'PRINTMULTIPLEIDCARD') {
	            		var button = buttonsToolBar.query('#printIdCardMultipleBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true){
	            				printIdCardMultipleBtn.setVisible(true);	
	            			}else{
	            				printIdCardMultipleBtn.setVisible(false);	
	            			}
	            		}        		
	            	}
	        	        		
	        		if (privilege === 'MOREACTION') {
	            		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
	            		if(!isNullOrEmpty(button)){
	            			moreActionStatus = true;
	            			if(statusField == true){
	            				spBtnMoreActionsBtn.setVisible(true);	
	            			}else{
	            				spBtnMoreActionsBtn.setVisible(false);	
	            			}
	            		}        		
	            	}
	        		if (privilege === 'MAKE_ACTIVE') {
	            		var button = buttonsToolBar.query('#makeActiveBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true){
	            				makeActiveBtn.setVisible(false);
	            			}else{
	            				makeActiveBtn.setVisible(true);
	            			}
	            			
	            		}        		
	            	}
	        		if (privilege === 'RAISEREQUEST') {
	            		var button = buttonsToolBar.query('#raiseRequestButtonItemId')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true) {
	            				raiseRequestButton.setVisible(true);
	            			}
	            			else{
	            				raiseRequestButton.setVisible(false);
	            			}
	            		}        		
	            	}
	        		if (privilege === 'SENDSURVEY') {
	            		var button = buttonsToolBar.query('#sendSurveyBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true) {
	            				sendSurvey.setVisible(true);
	            			}
	            			else{
	            				sendSurvey.setVisible(false);
	            			}
	            		}        		
	            	}
	        		if (privilege === 'ADD_COMMITTEE') {
	            		var button = buttonsToolBar.query('#assignStudentCommitteeBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true) {
	            				assignStudentCommittee.setVisible(true);
	            			}
	            			else{
	            				assignStudentCommittee.setVisible(false);
	            			}
	            		}        		
	            	}
	        		if (privilege === 'BULK_APPLICATION_DOCUMENT_DOWNLOAD') {
	            		var button = buttonsToolBar.query('#bulkDownloadDocId')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true) {
	            				bulkDownloadDoc.setVisible(true);
	            			}
	            			else{
	            				bulkDownloadDoc.setVisible(false);
	            			}
	            		}        		
	            	}
	        		if (privilege === 'OFFER_LETTER_DETAILS') {
	        			var button = buttonsToolBar.query('#offerLetterDetailsItemId')[0];
	            		if(!isNullOrEmpty(button)) {
	            			offerLetterDetails.setVisible(true);
	            			offerLetterButtonStatus = true;
	            		}
	            	}
	        		if (privilege === 'ADD_LIBRARY') {
	            		var button = buttonsToolBar.query('#kohastudentlibrarymappingBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true) {
	            				kohastudentlibrarymapping.setVisible(true);
	            			}
	            			else{
	            				kohastudentlibrarymapping.setVisible(false);
	            			}
	            		}        		
	            	}
	        		if (privilege === 'ADD_PATRON_CATEGORY') {
	            		var button = buttonsToolBar.query('#kohastudentcategorymappingBtn')[0];
	            		if(!isNullOrEmpty(button)){
	            			if(statusField == true) {
	            				kohastudentcategorymapping.setVisible(true);
	            			}
	            			else{
	            				kohastudentcategorymapping.setVisible(false);
	            			}
	            		}        		
	            	}

	        	});
	        	if(offerLetterButtonStatus == true && moreActionStatus == true) {
	        		if(statusField != true) {
	        			spBtnMoreActionsBtn.setVisible(true);
	        		}
	        	}
	        	
	        	var studentListProgramTransfer = ResultGrid.down('#studentListProgramTransfer');
	          	Ext.each(permissionList, function(privilege) {
	        	if(privilege === 'PROGRAM_TRANSFER')
	        		{
	        	if(statusField == true && !isNullOrEmpty(studentListProgramTransfer)){
	        		studentListProgramTransfer.setVisible(true);
    			}else{
    				studentListProgramTransfer.setVisible(false);
    			}
	        		}
	        	});
	        
	        	var inactiveStudentMoreActionBtn = ResultGrid.down('#inactiveStudentMoreActionBtn');
	        	if(statusField == false){
	        		inactiveStudentMoreActionBtn.setDisabled(true);
    			}else{
    				inactiveStudentMoreActionBtn.setDisabled(false);
    			}
	            
	         /*   if(statusField == true){
	            	ResultGrid.down('#resetButtonItemId').show();
	            	ResultGrid.down('#sendMessageBtn').show();
	            	ResultGrid.down('#spBtnMoreActions').show();
	            	ResultGrid.down('#makeActiveBtn').hide();
	            	
	            }else{
	            	ResultGrid.down('#resetButtonItemId').hide();
	            	ResultGrid.down('#sendMessageBtn').hide();
	            	ResultGrid.down('#spBtnMoreActions').hide();
	            	ResultGrid.down('#makeActiveBtn').show();
	            }
	            //this.disableMoreActionPivileges(ResultGrid, this.getSTUDENT_LIST_PERMISSIONS());
*/	             
	        	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_LIST_VIEWCODE);
	            ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,SearchForm.down('#searchButtonId'));
            },
	        showStudentBulkPrintLabelsWin:function(){
	        	var $this = this;
	        	var formWindow = $this.getStudentbulkprintlabelswidow();
	        	if (!formWindow) {
	        		Ext.widget('studentbulkprintlabelswidow');
	        		formWindow = $this.getStudentbulkprintlabelswidow();
	        	}
	        	formWindow.show();
	        	var form = $this.getStudentbulkprintlabelswidow();
	    		var  templateNameField = form.down("#templateNameStudent");
	    		var store = templateNameField.getStore();
	    		var academyLocationId=$this.getCurrentAcademyLocation();
	    		store.getProxy().extraParams={
	    	    	academyLocationId:academyLocationId,
	    	    	reportType:'Basic Reports',
	    	    	templateName:'STUDENT_PRINT_LABEL'
	    		};
	    		store.load();
	        },
	        showStudentTaxCertificateWindowWin:function(){
	        	var $this = this;
	        	var formWindow = $this.getStudentprinttaxcertificate();
	        	if (!formWindow) {
	        		Ext.widget('studentprinttaxcertificate');
	        		formWindow = $this.getStudentprinttaxcertificate();
	        	}
	        	formWindow.show();
	        	var form = $this.getStudentprinttaxcertificate();
	    		var  templateNameField = form.down("#mappedAccountingYear");
	    		var store = templateNameField.getStore();
	    		store.load();
	        },
	        exportPrintLabelsJRXML: function(fileType,grid) {
	        	var studentId=0;
	        	var admissionId=0;
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		var record = grid.getSelectionModel().getSelection();
	        		var studenttemp=[];
	        		var admissiontemp=[];

	        		for(var i in record){
	        			studenttemp.push(record[i].get("ID"));
	        			admissiontemp.push(record[i].get("ADMISSION_ID"));
	        		}
	        		studentId=studenttemp.join();
	        		admissionId=admissiontemp.join();

	        		user=this.getCurrentlyLoggedInUser();
	        		// code to identify jasper
	        		var form = this.getStudentbulkPrintlabelswidow().getForm();
	        		var templateName = form.findField('templateNameStudent').getValue();
	        		//var code ="ID_CARD_BACK";
	        		var reportParams =new Object();
	        		reportParams.userId=user.code;
	        		reportParams.ids=String(studentId); // convert int into string
	        		reportParams.admissionIds=String(admissionId);
	        		reportParams.code=templateName;
	        		var reportTitle="Print Label";
	        		var exportUrl = SERVERURL.STUDENT_PRINT_LABEL;
	        		this.exportJRXMLReport(templateName,reportParams,reportTitle,fileType,exportUrl);
	        		this.getStudentbulkprintlabelswidow().close();
	        	}
	        },
	        exportPrintCertificateJRXML: function(fileType,grid) {
	        	var studentId=0;
	        	var admissionId=0;
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		var record = grid.getSelectionModel().getSelection();
	        		var studenttemp=[];
	        		var admissiontemp=[];

	        		for(var i in record){
	        			studenttemp.push(record[i].get("ID"));
	        		}
	        		studentId=studenttemp.join();

	        		user=this.getCurrentlyLoggedInUser();
	        		// code to identify jasper
	        	   	var form = this.getStudentprinttaxcertificate();
	                var academyLocationId = this.getCurrentAcademyLocation();

	        		var accountYearType =form.down("#mappedAccountingYear").getValue()
	        		var templateName="STUDENT_PRINT_TAX_CERTIFICATE";
	        		//var code ="ID_CARD_BACK";
	        		var accountYearName=form.down("#mappedAccountingYear").getRawValue();
	        		var reportParams =new Object();
	        		reportParams.userId=user.code;
	        		reportParams.ids=String(studentId); // convert int into string
	        		reportParams.accountingType=accountYearType;
	        		reportParams.code=templateName;
	        		reportParams.academyLocationId=academyLocationId;
	        		reportParams.accountTypeName=accountYearName;
	        		var reportTitle="Student print tax certificate";
	        		var exportUrl = SERVERURL.STUDENT_PRINT_TAX_CERTIFICATEE;
	        		this.exportJRXMLReport(templateName,reportParams,reportTitle,fileType,exportUrl);
	        		this.getStudentprinttaxcertificate().close();
	        	}
	        },
	        openStudentOfferLetterDetailsPopup:function(btn){
	        	var grid = this.getSearchResultGrid();
	        	   if (grid.getSelectionModel().getCount() > 0) {
	        		   var resetPswrdWindowItemId ="studentofferletterdetailswindow";
	                   var resetPswrdFormWindow = Ext.widget('offerletterdetailswindow', {
	                        itemId: resetPswrdWindowItemId
	                    });
	                   resetPswrdFormWindow.show();
	                   
	                   var me=this;
		   	           	var searchResultGrid=me.getSearchResultGrid();
		   	           	var record = searchResultGrid.getSelectionModel().getSelection()[0];
		   	           	if (!isEmpty(record)) {
		   	           		var studentId=record.get('ID');
		   	           		var offerLetterDetailsGrid = resetPswrdFormWindow.down('#offerLetterDetailsGrid');
		   	           		offerLetterDetailsGrid.getStore().removeAll();
		   		           	offerLetterDetailsGrid.getStore().getProxy().extraParams = {
		   		           		studentId: studentId
		   	        		};
		   		           	offerLetterDetailsGrid.getStore().load();
		   	           	}
	                   
	        	   } else {
	        		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	   }
	        },
	        getUserAccessibleAL:function(){
	        	var academyLocationId = [];
	        	var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	        	for(var i=0; i<academyLocationList.length; i++){
	        		academyLocationId.push(academyLocationList[i].id);
	        	}
	        	return academyLocationId.join();
	        },
	        //******************Disable Print As Word File**********************************
	        disablePrintAsWordFilePivileges: function(form,permissionsMap) {
	        	var $this = this;
	        	var associatedAcadLocationIds = new Array();
	        	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
	    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        	var printAsWordFile = form.down('#printAsWordFile');
	        	printAsWordFile.setVisible(false);
	        	Ext.each(permissionList, function(privilege) {
	        		if (privilege === 'PRINT_AS_WORD_FILE') {
	            		if(!isNullOrEmpty(printAsWordFile)){
	            			printAsWordFile.setVisible(true);
	            		}        		
	            	}
	        	});
	        },
	    	openSendMessageReportLink: function(record){
	    		var id = record.get('msgRcpntLogId');
	    		if(!isNullOrEmpty(id)){
	    			Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.PATH_FIND_MSG_CONTENT_BY_MSG_RCPNTLOG_ID,													 
	    				method: 'GET',
	    				async: false,
	    				headers: {
	    					'Content-Type': 'application/json'
	    				},
	    				params: {
	    					id: id
	    				},
	    				success: function(response, form, action) {
	    					responseObject = eval("(" + response.responseText + ")"); //make object of response text
	    					var msgContent = responseObject.msgContent;

	    					var win = new Ext.Window({
	    						title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
	    						frame: true,
	    						height : 500,
	    						minWidth:200,
	    						autoScroll:true,
	    						modal:true,
	    						html: msgContent,
	    					});
	    					win.show();

	    				},
	    				failure: function(form, action) {
	    					//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
	    				}
	    			});
	    		}
	    	},
	        openAttachedDocumenLinkstudent: function(record){
	    		var $this = this;
	    		var id = record.get('msgRcpntLogId');
	    		if(!isNullOrEmpty(id)){
	    			var isWhetherSysMsgEvent = false;
	    			var eventName = record.get('eventName');
	    			if(!isNullOrEmpty(eventName)){
	    				isWhetherSysMsgEvent = true;
	    			}

	    			var formWindow = $this.getSendmessageattacheddocumentwin();
	    			if (formWindow==null ||formWindow==undefined) {
	    				//formWindow=	Ext.widget('sendmessageattacheddocumentwin');
	    				//formWindow = $this.getSendmessageattacheddocumentwin();
	    				formWindow = Ext.widget('sendmessageattacheddocumentwin',{
                			itemId:'studentsendmessageItemId'
                		});
	    			}
	    			formWindow.show();
	    			var documentGrid = formWindow.down('#sendMessageDocumentGridItemId');
	    			documentGrid.getStore().getProxy().extraParams = {
	    				id: id,
	    				whetherSysMsgEvent:isWhetherSysMsgEvent
	    			};
	    			documentGrid.getStore().load();
	    		}
	    	},
	    	downloadAttachedDocumentFile : function(documentId,isWhetherSysMsgEvent,staticDocOfMSR){
	        	if(!isNullOrEmpty(documentId)){
	        		var csvForm = Ext.create('Ext.form.Panel'); 
	    	    	csvForm.getForm().submit({
	    		    	target: '_blank',
	    		    	method:'GET',
	    		    	params :{
	    		    		access_token : Ext.Ajax.defaultHeaders.access_token,
	    		    		id: documentId,
	    					whetherSysMsgEvent:isWhetherSysMsgEvent,
	    					staticDocOfMSR :staticDocOfMSR
	    		    	},
	    		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    		    	url: SERVERURL.PATH_DOWNLOAD_MSG_DOCUMENTS,
	    		    	standardSubmit :true
	    	    	});
	        	}
	        },
		    studentcheckSelectDate:function(){
		    	 var personProfile = this.getContentPanelActiveTab();
		    	var form = personProfile.down('communicationhistorystructure');
		    	var grid = personProfile.down('communicationhistorylist');
				//var grid =  personProfile.getCommunicationhistorylist();
				var eventDateForm=form.down("#eventDateForm").getValue();
				var eventDateTill=form.down("#eventDateTill").getValue();
				var exportReport=grid.down("#exportMessageSentReportItemId");
				if(!isNullOrEmpty(eventDateForm) && !isNullOrEmpty(eventDateTill))
					exportReport.setDisabled(false);
				else
					exportReport.setDisabled(true);
		    },
	        exportXlsMsgSentReport : function() {
				var $this = this;
		    	var form = $this.getCommunicationhistorystructure();
		    	var grid =  this.getCommunicationhistorylist();
		    	form=form.down('form');
				var values = form.getValues();
				var dt = new Date();
		    	var dateString = Ext.Date.format(dt, 'YmdHis'); 
				var reportTitle = "Message Sent Report"+"_"+dateString;
				var code = 'MESSAGE_SENT_EXCEL_EXPORT_REPORT';
				var reportHeader = "Message Sent Report";
			
				
				
				var sendMessage = form.down("#sendmessageId").getValue();
				//console.log(sendMessage);
				var recipient=form.down("#recipientName").getValue();
				var contactId=null;
				var sentbyName=form.down("#sentby").getValue();
				var eventNameCode=form.down("#eventName").getValue();
				var eventDateForm=form.down("#eventDateForm").getValue();
				var eventDateTill=form.down("#eventDateTill").getValue();
				var messageId=form.down("#sendmessageId").getValue();
				//var status=form.down("#statusComboMsgSendReport").getValue();
				if(messageId.sendMessage==1){
					contactId=form.down("#contactId").getValue();
					if(contactId==null){
            				var contactIdComboStore=form.down("#contactId").getStore();
            				var storeValue = contactIdComboStore.data.items;
            				contactIdValue = storeValue[0].data.emailId;
                    		for(var recordInt=1;recordInt<storeValue.length;recordInt++){
                    			contactIdValue=contactIdValue+","+storeValue[recordInt].data.emailId;
                    		}
                    		contactId=contactIdValue;
                    		}
				}else{
					contactId=form.down("#mobileId").getValue();
				}
			
				var reportParams = new Object();
				reportParams.fromDate = eventDateForm;
				reportParams.toDate = eventDateTill;
				reportParams.contactList = contactId;
				reportParams.sentBy = sentbyName;
				reportParams.eventName=eventNameCode;
				reportParams.recipientName=recipient;
				reportParams.deliveryModeId=sendMessage.sendMessage;
				reportParams.headerName = reportHeader;
				reportParams.status = status;
				$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.MSG_SENT_EXCEL_REPORT);
			},
			showStudentRequestDocumentWin:function(){
		    	var $this = this;
		    	var formWindow = $this.getFacultyrequestdocumentwidow();
		    	if (!formWindow) {
		    		formWindow = Ext.widget('facultyrequestdocumentwidow',{
		    			itemId:'studentrequestdocumentId'
		    		});
		    		Ext.widget('facultyrequestdocumentwidow');
		    		formWindow = $this.getFacultyrequestdocumentwidow();
		    	}
		    	formWindow.show();
		    	
		    	var form = formWindow.down('form');
				var  templateNameField = form.down("#DocummentGroupFaculty");
				
				var store = templateNameField.getStore();
				
				var academyLocationId=$this.getCurrentAcademyLocation();
				store.getProxy().extraParams={
			    	academyLocationId:academyLocationId,
			    	applicableTo: 'STUDENT'
				};
			
			store.load();
	    },
	    documentRequestStudent: function(button) {
	    	var grid = this.getSearchResultGrid();
	    	var records=grid.getSelectionModel().getSelection();
	    	var studentId=0;
	    	var admissionId=0;
	    	var	formWindow = Ext.widget('facultyrequestdocumentwidow',{
	    		itemId:'studentrequestdocumentId'
	    	});
	    	var academyLocationId=this.getCurrentAcademyLocation();

	    	var studentListArrays = [];
	    	for(var i in records) {
	    		studentListArrays.push(records[i].data.PERSON_ID);
	    	}
	    	var personIds = studentListArrays.join(',');

	    	var documentGroupMasterId = this.getFacultyrequestdocumentwidow().down('#DocummentGroupFaculty').getValue();

	    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : SERVERURL.PATH_PRDGM_MAKE_REQUEST_FOR_DOCUMENT,
	    		method : 'POST',
	    		//async: false,
	    		params: {
	    			documentGroupMasterId: documentGroupMasterId,
	    			academyLocationId: academyLocationId,
	    			personIds:personIds
	    		},
	    		headers: {
	    			'Content-Type': 'application/json'
	    		},
	    		success : function(form, action) {
	    			Ext.getBody().unmask();
	    			showSuccessMessage(getCommonTranslation('REQUEST_DOCUMENTS'),getExaminationTranslation('SUCCESS'));

	    		}
	    	});
	    	this.getFacultyrequestdocumentwidow().close();
	    },
	    
	    getStudentIdsForMessaging : function() {
				var $this = this;
				
				var formWindowTab = $this.getStudentsendmessages();
    	       	var sendMessageLable = formWindowTab.down("#sendMsgCountItemId");
				if (sendMessageLable.isVisible()) {
					var form = $this.getStudentQuickSearchForm().getForm();
			    	var values = form.getValues();
					var urlParam = "?STATUS="+values.STATUS+"&ADMISSION_STATUS="+values.ADMISSION_STATUS;
					if (!isNullOrEmpty(values.ACADEMIC_TERM)) {
						urlParam = urlParam+"&ACADEMIC_TERM="+values.ACADEMIC_TERM;
					}
					if (!isNullOrEmpty(values.INTAKE_YEAR)) {
						urlParam = urlParam+"&INTAKE_YEAR="+values.INTAKE_YEAR;
					}
					if (!isNullOrEmpty(values.PROGRAM_CATEGORY)) {
						urlParam = urlParam+"&PROGRAM_CATEGORY="+values.PROGRAM_CATEGORY;
					}
					if (!isNullOrEmpty(values.PROGRAM_GROUP)) {
						urlParam = urlParam+"&PROGRAM_GROUP="+values.PROGRAM_GROUP;
					}
					if (!isNullOrEmpty(values.PROGRAM_NAME)) {
						urlParam = urlParam+"&PROGRAM_NAME="+values.PROGRAM_NAME;
					}
					if (!isNullOrEmpty(values.BATCH_NAME)) {
						urlParam = urlParam+"&BATCH_NAME="+values.BATCH_NAME;
					}
					if (!isNullOrEmpty(values.PERIOD_NAME)) {
						urlParam = urlParam+"&PERIOD_NAME="+values.PERIOD_NAME;
					}
					if (!isNullOrEmpty(values.SECTION)) {
						urlParam = urlParam+"&SECTION="+values.SECTION;
					}
					if (!isNullOrEmpty(values.SEAT_TYPE)) {
						urlParam = urlParam+"&SEAT_TYPE="+values.SEAT_TYPE;
					}
					if (!isNullOrEmpty(values.SEAT_TYPE)) {
						urlParam = urlParam+"&COURSE_NAME="+values.COURSE_NAME;
					}
					if (!isNullOrEmpty(values.PHONE_NO)) {
						urlParam = urlParam+"&PHONE_NO="+values.PHONE_NO;
					}	
					if (!isNullOrEmpty(values.EMAIL_ID)) {
						urlParam = urlParam+"&EMAIL_ID="+values.EMAIL_ID;
					}	
					if (!isNullOrEmpty(values.GENDER)) {
						urlParam = urlParam+"&GENDER="+values.GENDER;
					}	
					if (!isNullOrEmpty(values.ADVISOR_ID)) {
						urlParam = urlParam+"&ADVISOR_ID="+values.ADVISOR_ID;
					}
					if (!isNullOrEmpty(values.ADMISSION_FROM_DATE)) {
						urlParam = urlParam+"&ADMISSION_FROM_DATE="+values.ADMISSION_FROM_DATE;
					}
					if (!isNullOrEmpty(values.ADMISSION_TO_DATE)) {
						urlParam = urlParam+"&ADMISSION_TO_DATE="+values.ADMISSION_TO_DATE;
					}
					if (!isNullOrEmpty(values.ADMISSION_NUMBER)) {
						urlParam = urlParam+"&ADMISSION_NUMBER="+values.ADMISSION_NUMBER;
					}
					if (!isNullOrEmpty(values.RELIGION_ID)) {
						urlParam = urlParam+"&RELIGION_ID="+values.RELIGION_ID;
					}
					if (!isNullOrEmpty(values.CASTE_CATERGORY_ID)) {
						urlParam = urlParam+"&CASTE_CATERGORY_ID="+values.CASTE_CATERGORY_ID;
					}
					if (!isNullOrEmpty(values.EXIT_DATE_NULL)) {
						urlParam = urlParam+"&EXIT_DATE_NULL="+values.EXIT_DATE_NULL;
					}
					if (!isNullOrEmpty(values.STUDENT_STATUS)) {
						urlParam = urlParam+"&STUDENT_STATUS="+values.STUDENT_STATUS;
					}
					if (!isNullOrEmpty(values.STUDENT_ID)) {
						urlParam = urlParam+"&STUDENT_ID="+values.STUDENT_ID;
					}
					var academyLocationIds =$this.getUserAccessibleAL();
					urlParam = urlParam+"&ACCESSIBLE_AL_ID="+academyLocationIds;
					var academyLocationId = this.getCurrentAcademyLocation();
					urlParam = urlParam+"&ACADEMY_LOCATION_ID="+academyLocationId;
		    	Ext.Ajax.request({
    				type: 'rest',
    				url: SERVERURL.PATH_FIND_ALL_STUDENT_ID_FOR_MESSAGING+urlParam,													 
    				method: 'GET',
    				async: false,
    				headers: {
    					'Content-Type': 'application/json'
    				},
    				/*params: {
    					id: id
    				},*/
    				success: function(response, form, action) {
    					var record = Ext.decode(response.responseText);
    					var totalRecord = record.length;
    					if (totalRecord > 1) {
    	    	       		sendMessageLable.setText(totalRecord+' '+getCommonTranslation('STUDNETS_SEND_MESSAGE_COUNT'));	
						}else{
							sendMessageLable.setText(totalRecord+' '+getCommonTranslation('STUDNET_SEND_MESSAGE_COUNT'));
						}
    					var ids=[];
    					record.forEach(function(id){
    						ids.push(id);
    		        	});
    					//formWindowTab.down("#isSendMsgToAll").setValue(true);
    				},
    				failure: function(form, action) {
    					//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
    				}
    			});
				}
			},
	        saveUpdateThesisMangement:function(form){
				var $this = this;
				var submitUrl=null;
				var editThesisManagementForm =form.getForm();
				var values = editThesisManagementForm.getValues();
				var periodId=editThesisManagementForm.findField('period').getValue();
				var studentId=editThesisManagementForm.findField('admission').getValue();
				var admissionId=editThesisManagementForm.findField('admission').findRecord('id',studentId).data.code;
				var graduationCeremonyId=editThesisManagementForm.findField('graduationCeremony').getValue();
				var thesisManagementDroolId=editThesisManagementForm.findField('thesisManagementDrool').getValue();
				var periodCombo = this.getIdValueJson(periodId);
				var admissionCombo = this.getIdValueJson(admissionId);
				var graduationCeremonyCombo = this.getIdValueJson(graduationCeremonyId);
				var thesisManagementDroolCombo = this.getIdValueJson(thesisManagementDroolId);
				
				var remarks = editThesisManagementForm.findField('remarks').getValue();
				var id=null;
				var thesisManagementStatusId=null;
					submitUrl = SERVERURL.PATH_SAVE_THESIS_MANAGEMENT;
				var superVisiorArray = [];
				var duplicateIdMap = new Ext.util.HashMap();
				var duplicateIdFlag=false;
				if (!isNullOrEmpty(form.down('#panelIdH').items.items)
						&& form.down('#panelIdH').items.items.length > 1) {

					for (var i = 0; i < form.down('#panelIdH').items.items.length; i++) {
						var newData = {
								"supervisor" : $this.getIdValueJson(values.superVisor[i],values.superVisor[i]),
								"id":parseInt(values.thesisManagementSupervisorId[i])
						};
						if(duplicateIdMap.containsKey(values.superVisor[i])){
							duplicateIdFlag=true;
							break;
						}
						duplicateIdMap.add(values.superVisor[i], i);
						superVisiorArray.push(newData);
					}

				}else if(!isNullOrEmpty(form.down('#panelIdH').items.items)
						&& form.down('#panelIdH').items.items.length == 1){
					var newData = {
							"supervisor" : $this.getIdValueJson(values.superVisor,values.superVisor),
							"id":parseInt(values.thesisManagementSupervisorId)
					};
					superVisiorArray.push(newData);

				}
				if(duplicateIdFlag){
					showWarningMessage(getCommonTranslation('NOMINATE_STUDENT'),
							getCommonTranslation('DUPLICATE_SUPERVISOR_SELECTED')); 
					return false;
				}
				var wsThesisManagement = {
						programBatchPeriodConfiguration:periodCombo,
						admission:admissionCombo,
						graduationCeremony:graduationCeremonyCombo,
						thesisManagementDrool:thesisManagementDroolCombo,
						thesisStatusEnum:"NOMINATED",
						remarks:remarks,
						id:id,
						thesisManagementSupervisors:superVisiorArray,
						thesisManagementStatusId:thesisManagementStatusId
				};

				$this.applyWindowMask(); 
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : wsThesisManagement,
					method : 'POST',
					success : function(response, form, action) {
						$this.hideWindowMask();
						if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
							showSuccessMessage(getCommonTranslation('NOMINATE_STUDENT'),getCommonTranslation('STUDENT_HAS_BEEN_NOMINATED_SUCCESSFULLY'));
								$this.getEditthesismanagementformwin().close();
							
						} 
					}
				});
			},
			setApplyHoldAtOnApplyHoldWindowOnStudentList:function(form){
				   
				   var subHoldCatStudent = form.down('#subHoldCatStudent').getValue();
				   var applyHoldAt = form.down('#applyHoldAtList');
				   Ext.Ajax.request({
        			type: 'rest',
        			url: SERVERURL.PATH_APPLY_AT_FIND_BY_SUB_HOLD_ID,
        			params: {
        				subHoldCategoryId:subHoldCatStudent,
                    },
        			method: 'GET',
        			success: function(res, action) {
        				var response = Ext.decode(res.responseText);
        				applyHoldAt.setValue(response.value);
        			}
                });
			   
			},
			loadDFRForNationalId: function(nationalId){
	          	var $this = this;
	          	Ext.Ajax.request({
	          		type: 'rest',
	          		async: false,
	          		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	          		params: {
	          			screenName: 'studentquicksearchform',
	          			academyLocationId: this.getCurrentAcademyLocation(),
	          			languageCode:'en'
	          		},
	          		method: 'GET',
	          		success: function(res, action) {
	          			var response = Ext.decode(res.responseText);
	          			var records=response.studentquicksearchform;
          				for(i in records){
	          			if( Object.keys(response).length > 0 ){
	          					if(records[i].formFieldId=='nationalID' && records[i].isVisible==false) {
	          					    nationalId.setVisible(false);
	          					    nationalId.setFieldLabel(records[i].formFieldLabel);
	          					   }
	          					else {
	          					    nationalId.setFieldLabel(records[i].formFieldLabel);
	          					    nationalId.setVisible(true);
	          					   }
	          				  
	          					if(records[i].formFieldId=='nationalID' && records[i].isMandatory==true) {
          				        	var allowblankFalse = ':<span class="required" style="color:red"> *</span>'; 
          				        	nationalId.allowBlank = false;
          				        	nationalId.setFieldLabel(records[i].formFieldLabel+ ': <span class="required" style="color:red"> *</span>');
          				        }
	           			 }
	          		  }
	          		}		
	          		
	          	});
	          	
	          }  ,
	      	assignAcademyLocation:function(form){
	      			var $this = this;
	      			var grid = this.getSearchResultGrid();
                	var records = grid.getSelectionModel().getSelection();
                	var userId = records[0].data.ID;
                	var currentLoc = this.getCurrentAcademyLocation();
	    			var values = form.getValues();
	    			var formData ={
	    			    currentLoc : currentLoc,
	    			    userId : userId,
	    				reassignTo : values.reassignTo,
	    				reassignmentDate : values.reassignmentDate
	    			}
	    			
	    			$this.applyWindowMask();
	    			Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.PATH_UPDATE_PRIMARY_LOCATION,
	    				jsonData: formData,
	    				method: 'POST',
	    				success: function(form, action) {
	    					$this.hideWindowMask();
	    					showSuccessMessage( getCommonTranslation('CHANGE_ACADEMY_LOCATION'),getCommonTranslation('SUCCESS'));
	    					Ext.ComponentQuery.query('changeprimarylocation')[0].close();
	    					grid.getStore().reload();
	    				}
	    			});
	    	},
	          saveStudentApplyHold:function(form){
					var $this = this;
					var submitUrl=SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_FOR_LIST;;
					var studentHoldForm =form.getForm();
					var grid = $this.getSearchResultGrid();
					var values = studentHoldForm.getValues();
					var manageHoldCategory = this.getIdValueJson(values.holdCatStudent);
					var manageSubHoldCategory = this.getIdValueJson(values.subHoldCatStudent);
					var applyBy = this.getIdValueJson(values.applyBy);
					var selected = grid.selModel.getSelection();
				    var jsonFormatFormData= new Object;
					var jsonData = [];
                   if( selected.length > 0){
				    		for( var i = 0; i < selected.length; i++) {
				    			jsonFormatFormData = {
					   					
				    					"manageHoldCategory":manageHoldCategory,
				    					"manageSubHoldCategory":manageSubHoldCategory,
				    					"applyBy":applyBy,
				    					"applyReason":values.applyReason,
				    					"applyDate":values.applyDate,
					   					"programBatchSeatConfiguration":$this.getIdValueJson(selected[i].data.PROGRAM_BATCH_SEAT_CONFIG_ID),
					   					"student":$this.getIdValueJson(selected[i].data.USER_ID),
					   					
					   					
					   			};
				    			jsonData.push(jsonFormatFormData);
				    	
				    	}
				    		}
                   var requestJSON = {};
               	requestJSON=jsonData;
					$this.applyWindowMask(); 
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : requestJSON,
						method : 'POST',
						success : function(response, form, action) {
							$this.hideWindowMask();
							if(response.responseText=="HOLD_CANT_MAPPED"){
								showErrorMessage(getCommonTranslation('APPLY_HOLD'),getCommonTranslation('HOLD_CANT_MAPPED'));
									$this.getStudentlistapplyholds().close();
							}else if(response.responseText=="SOME_BATCH_NOT_MAPPED_FOR_THIS_HOLD"){

								showErrorMessage(getCommonTranslation('APPLY_HOLD'),getCommonTranslation('SOME_STUDENT_ARE_ALREADY_MAPPED'));
								$this.getStudentlistapplyholds().close();
							}else if(response.responseText=="ALL_STUDENT_ARE_ALREADY_MAPPED"){

								showErrorMessage(getCommonTranslation('APPLY_HOLD'),getCommonTranslation('ALL_STUDENT_ARE_ALREADY_MAPPED'));
								$this.getStudentlistapplyholds().close();
							}else if(response.responseText=="SUCCESSSOME_BATCH_NOT_MAPPED_FOR_THIS_HOLD"){

								showErrorMessage(getCommonTranslation('APPLY_HOLD'),getCommonTranslation('SOME_BATCH_NOT_MAPPED_FOR_THIS_HOLD'));
								$this.getStudentlistapplyholds().close();
							}else if(response.responseText=="ACCESS_DENIED"){
								showWarningMessage(getCommonTranslation('APPLY_HOLD'),getCommonTranslation('ACCESS_DENIED_TO_APPLIED_HOLD'));
							}
							else{
								 showSuccessMessage(getCommonTranslation('APPLY_HOLD'),getCommonTranslation('HOLD_APPLIED_SUCCESSFULLY'));
									$this.getStudentlistapplyholds().close();
							}
						}
					});
				},
				printProfileAndContractDetailsBtnStudent:function(obj){
					var $this = this;
					var grid = $this.getSearchResultGrid();
					var record = grid.getSelectionModel().getSelection();
					var academyLocationId=$this.getCurrentAcademyLocation();
					if (grid.getSelectionModel().getCount() > 0) {
						var record = grid.getSelectionModel().getSelection();
						var studenttemp=[];
						var admissionTemp=[];
						var programBatchStudentTemp=[];
						var isInctiveCheck=false;
						for(var i in record){
							studenttemp.push(record[i].get("ID"));
							admissionTemp.push(record[i].get("ADMISSION_ID"));
							programBatchStudentTemp.push(record[i].get("PROGRAM_BATCH_STUDENT_ID"));
						}
						studentId=studenttemp.join();
						admissionIds = admissionTemp.join();
						programBatchStudentIds = programBatchStudentTemp.join();
						if(record[i].get("STATUS")=='Inactive') {
							isInctiveCheck=true;
						}
						var profilePrintURL = SERVERURL.STUDENT_PROFILE_PRINTING_CONTRACT_DETAILS;
						var csvForm = Ext.create('Ext.form.Panel'); 
						csvForm.getForm().submit({
							target: '_blank',
							method:'POST',
							params :{
								access_token : Ext.Ajax.defaultHeaders.access_token,
								studentIdsCommaSeperated : studentId,
								admissionIdsCommaSeperated :admissionIds,
								programBatchStudentIdsCommaSeperated : programBatchStudentIds,
								isInctiveCheck :isInctiveCheck
							},
							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							url: profilePrintURL,
							standardSubmit :true
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
				},
				openScholarshipRaiseRequestTab:function(){
				    requestIsFor='Student';
					var grid = this.getSearchResultGrid();
		    		if(grid.getSelectionModel().getCount() == 1){	
		    			var record = grid.getSelectionModel().getSelection()[0];
		    			var scholarshipMasterController = Academia.app.getController('Academia.controller.scholarship.ScholarshipMasterController');
		    			scholarshipMasterController.getScholarshipRequestPanel(requestIsFor,record);
		    		} else {
		    			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		    		}
				},
				generateAIEmail: function(btn) {
					if(!CONST.AI_ENABLED){
						showWarningMessage(getExaminationTranslation('REMARK'),
						"AI Feature Is Not Enabled. Please contact administrator.");
						return;
					}
					var me = this;
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var vals = btn.up('form').getValues();
					Ext.Ajax.request({
						url: SERVERURL.PATH_GENRATE_EMAIL_AI,
						method: 'GET',
						params: {
							subject: vals.subjectDisplayCode
						},
						success: function(response) {
							Ext.getBody().unmask();
							if(response.responseText){
								me.getStudentsendmessages().down('[name=discriptionId]').setValue(response.responseText);
							}
						}
					});
				},
				
				validateSubject: function(cmp, nval) {
					var form = cmp.up('form');
					if(!isNullOrEmpty(nval) && form.down('#msgTempletId').getValue() == 'EMAIL_ONLY') {
						form.down('#generateEmailBtn').enable();
					}
					else {
						form.down('#generateEmailBtn').disable();
					}
				},
					       
	       openPandaDocPopup: function(btn) {
	    	   var window = this.getPandadocpopup();
	    	   if(!window){
	    		   window = Ext.widget('pandadocpopup');
	    	   }
	    	   window.show();
	       },
	       
	       toggleRetainExamDataCheckbox: function(form) {
	    	   try {
	    		   var vals = form.getValues();
		    	   var grid = form.up('window').down('grid');
		    	   var rec = grid.getStore().getAt(0);
		    	   var curProgramId = rec.get('programId');
        		   var curBatchId = rec.get('batchId');
        		   var currentAcademyLocationId = this.getCurrentAcademyLocation();
        		   var retainExamDataId = form.down('#retainExamDataId');
        		   if(!isNullOrEmpty(vals.PROGRAM) && !isNullOrEmpty(vals.BATCH) && currentAcademyLocationId == vals.academyLocationCombo && curProgramId != vals.PROGRAM && curBatchId != vals.BATCH) {
        			   retainExamDataId.setDisabled(false);
        		   }
        		   else if(currentAcademyLocationId != vals.academyLocationCombo && vals.retainStudentData && vals.retainAcademicData) {
        			   retainExamDataId.setDisabled(false);
        		   }
        		   else {
        			   retainExamDataId.setDisabled(true);
        			   retainExamDataId.setValue(false);
        		   }
	    	   }
	    	   catch(e) {}
	       },
	       addMoreRowsForPBPS:function(){
		   	   var $this = this;
		   	   var stopContiner = $this.getStudentstatusdownloadform().down('#programBatchContainerId');
		   	   var panelItem = new Array();
		   	   var fieldContainer=obj.up('fieldcontainer');
		   	   var newcont=stopContiner.items.items.length;
			   var insertPosition=newcont+1;
		   	   panelItem.push({
					xtype : 'fieldcontainer',
					plugins : "formlabelrequired",
					width: '100%',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype: 'customcombobox',
		                name: 'programName',
		                itemId: 'programItemId' + insertPosition,
		                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		                valueField: 'id',
		                displayField: 'valueCode',
		                width:410,
		                allowBlank:false,
		                minChars:3,
		                queryParam:'programName',
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
		                        combo.bindStore(store);
		                        
		                        var academyLocationId = $this.getCurrentAcademyLocation();
	                          	store.proxy.extraParams = {
	         							 academyLocationId : academyLocationId
	         					};
	                          	store.load();
		                    },
		                    select:function(obj,record){
		                    	var programId = record[0].get("id");
		                    	var  batch = obj.nextSibling();
		                    	var  period = batch.nextSibling();
		                    	var  section = period.nextSibling();

		                    	batch.setDisabled(false);
		                    	batch.reset();

		                    	period.setDisabled(true);
		                    	period.reset();

		                    	section.setDisabled(true);
		                    	section.reset();

		                    	var store = batch.getStore();

		                    	store.proxy.extraParams = {
		                    			id : programId
		                    	};
		                    	store.load();	                    	
		                    }
		                },
		                listConfig: {
		                	listeners: {
		                		beforeshow: function(picker) {
		                			var combo = picker.up('combobox');
									picker.setWidth(combo.getWidth());
		                		}
		                	},
		                	loadingText: getCommonTranslation('SEARCHING'),
		                	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                	getInnerTpl: function() {
		                		return '<div class="search-item">' +
		                		'{value}' +
		                		'</div>';
		                	}
		                }
					},{
						xtype: 'customcombobox',
		                name: 'batchName',
		                itemId: 'batchItemId' + insertPosition,
		                fieldLabel: getCommonTranslation('BATCH'),
		                disabled:true,
		                editable: false,
		                queryMode: 'local',
		                displayField: 'value',
		                valueField: 'id',
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                        combo.bindStore(store);
		                    },
		                    select:function(obj,record){
								var batchId = record[0].get("id");
								var  period = obj.nextSibling();
								var  section = period.nextSibling();

								period.setDisabled(false);
								period.reset();

								section.setDisabled(true);
								section.reset();

								var store = period.getStore();

								store.proxy.extraParams = {
										id : batchId
								};
								store.load();
							}
		                },
		                listConfig: {
			 				listeners: {
								beforeshow: function(picker) {
									var combo = picker.up('combobox');
									picker.setWidth(combo.getWidth());
								}
							}
			 			},
					},{
						xtype: 'customcombobox',
		                itemId:'periodItemId' + insertPosition,
		                disabled:true,
		                editable: false,
		                displayField: 'value',
		                valueField: 'id',
		                queryMode: 'local',
		                fieldLabel: getCommonTranslation('PERIOD'),
		                name: 'periodName',
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		                        combo.bindStore(store);
		                    },
		                    select:function(obj,record){
								var periodId = record[0].get("id");
								var  section = obj.nextSibling();

								section.setDisabled(false);
								section.reset();

								var store = section.getStore();

								store.proxy.extraParams = {
										periodId : periodId
								};
								store.load();

							}
		                },
		                listConfig: {
			 				listeners: {
								beforeshow: function(picker) {
									var combo = picker.up('combobox');
									picker.setWidth(combo.getWidth());
								}
							}
			 			},
					},{
						xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('SECTION'),
						width: 226,
						labelAlign: 'top',
						name : 'sectionName',
						itemId : 'programCoursection_ID' + insertPosition,
						displayField : 'sectionCode',
						valueField : 'sectionItemId',
						typeAhead : true,
						disabled:true,
						forceSelection : true,
						listeners: {
							render: function(combo) {
			                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
			                    combo.bindStore(store);
							}
						},
						 listConfig: {
				 				listeners: {
									beforeshow: function(picker) {
										var combo = picker.up('combobox');
										picker.setWidth(combo.getWidth());
									}
								}
				 			},
					}, {
						xtype: 'button',
						itemId: 'deleteRowBtn',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip: getCommonTranslation('DELETE'),
						style:{
							marginTop:'30px'
						},
						listeners:{
							click:function(obj){
							   var container = obj.up('fieldcontainer');
		   					   var panelContiner = $this.getStudentstatusdownloadform().down('#programBatchContainerId');
		   					   panelContiner.remove(container);
		   					   $this.getStudentstatusdownloadform().getForm().checkValidity();
		   					   
						}}
					},{
						xtype: 'button',
						itemId: 'addMoreRowBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					  }]
					});
		     	stopContiner.insert(insertPosition,panelItem);
		     	stopContiner.doLayout();
	       },
	       getInActiveStudentServiceRequestRequired: function(){
	   		var serviceRequestRequiredForInActiveStudent = false;
	   		Ext.Ajax.request({
	   			method : 'GET',
	   			url : SERVERURL.PATH_GET_INACTIVE_STUDENT_SERVICE_REQUEST,
	   			headers : {
	   				'Content-Type' : 'application/json'
	   			},
	   			async: false,
	   			success : function(opt, success, response) {
	   				if(opt.responseText == "false"){
	   					serviceRequestRequiredForInActiveStudent = false;
	   				}
	   				else{
	   					serviceRequestRequiredForInActiveStudent = true;
	   				}
	   			}
	   		});
	   		return serviceRequestRequiredForInActiveStudent;
	   	},
	   	captureUserPhoto: function(btn){
			var $this = btn.up('window');
			var form = btn.up('window').down('form');
			var imageUrl;
			Webcam.snap( function(data_uri) {
				imageUrl = data_uri;
			});
	        Ext.defer(function() {
	        	var imgLoad = new Image();
	    		imgLoad.onload = (function(){
	    			var crop = new Academia.utilities.ImageCrop({
	    				id:'testing',
	    				width: 310,
	    				height: 272,
	    				src:imageUrl
	    			});
	    			crop.on('changeCrop', function(component,region) {
	    				$this.cropData = region;
	    				$this.component = component;
	    			});
	    			var PREVIEW_TEST = form.down('#previewPanelId');
	    			PREVIEW_TEST.add(crop);
	    			$this.down('#capturePanelId').setVisible(false);
	    			$this.down('#previewPanelId').setVisible(true);
	    			btn.setDisabled(true);
	    			$this.down('#resetPhotoItemId').setDisabled(false);
	    			$this.down('#btnSaveItemId').setDisabled(false);
	    			
	    			var canvas = document.getElementById('canvas');
					var ctx = canvas.getContext("2d");
					var region = $this.cropData; 
					var component = $this.component;
					var sw = region.width - region.x;
					var sh = region.height - region.y;

					var imgWidth = component.width;
					var imgHeight = component.height;

					var img = new Image();
					img.src = component.src;

					ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
	    			$this.captureImageaUrl = canvas.toDataURL("image/png");
	    		}).bind($this);
	    		imgLoad.src = imageUrl;
	    		$this.imagesUrl = imageUrl;
	  	  }, 500, $this);
	   	},
	   	openCapturePhoto:function(){
	   		var window = this.getStudentuploadphotowindow(),
	   		profileImage = window.down('#profile_image'),
	   		capturePanelId = window.down('#capturePanelId'),
	   		btnUploadPhoto = window.down('#btnUploadPhotoItemId'),
	   		btnTakePhoto = window.down('#btnTakePhotoItemId'),
	   		capturePhoto = window.down('#capturePhotoItemId'),
	   		resetPhoto = window.down('#resetPhotoItemId'),
	   		btnBack = window.down('#btnBackItemId'),
	   		btnSave = window.down('#btnSaveItemId');
	   		window.down('#profile_image_containerBox').hide();
	   		window.down('#profileRoatateImageIconId').hide();
	   		
	   	// **Store the current profile image before hiding it**
    	    window.previousProfileImage = profileImage.el.dom.src;
	   		
	   		btnUploadPhoto.reset();
	   		btnUploadPhoto.setVisible(false);
	   		btnTakePhoto.setVisible(false);
	   		profileImage.setSrc('');
	   		profileImage.setVisible(false);
	   		capturePanelId.setVisible(true);
	   		capturePhoto.setVisible(true);
	   		resetPhoto.setVisible(true);
	   		resetPhoto.setDisabled(true);
	   		btnBack.setVisible(true);
	   		btnSave.setVisible(true);
	   		
	   	},
	   	getUploadCaptureToPersonProfile : function(){
            var this$ = this;
            var personProfile = this$.getContentPanelActiveTab();
            var personId = personProfile.getPersonId();
            if(!isNullOrEmpty(personId)){
                Ext.Ajax.request({
                    type: 'rest',
                    binary: true,
                    url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
                    method: 'GET',
                    success : function(response){
                        if(response.responseBytes.length>0){
                            var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
                            var url = window.URL.createObjectURL(blob);
                            var a=personProfile.down("#profile_image");
                            a.getEl().dom.src=url;
                            a.setVisible(true);
                        }
                    }
                });
            }
        },
	   	downloadUploadFormChangeStdStatus : function(cb, nv, ov){
	   		var structure = this.getStudentstatusloaderstructure();
	   		var downloadTemplateForm = this.getStudentstatusdownloadform();
	   		var uploadTemplateForm = this.getStudentstatusuploadform();
	   		var grid = structure.down('#studentStatusLoaderGridId');
	   		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
	   			uploadTemplateForm.hide();
	   			downloadTemplateForm.show();
	   			grid.setVisible(false);
	   		}else{
	   			this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
	   			var uploadoptionradiogroupform  = uploadTemplateForm.down('#stdStatusUploadRadioGroupItemId');
	   			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	   				isUploadAll: false
	   			});
	   			downloadTemplateForm.hide();
	   			grid.setVisible(true);
	   			uploadTemplateForm.show();
	   		}
	   	},
	   	downloadUploadFormChangeStdPostGraduation : function(cb, nv, ov){
	   		var structure = this.getStudentImportPostGraduationStructure();
	   		var downloadTemplateForm = this.getStudentPostGraduationDownloadForm();
	   		var uploadTemplateForm = this.getStudentPostGraduationUploadform();
	   		var grid = structure.down('#studentPostGraduationLoaderGrid');
	   		if(nv.downloadPostGraduationTemplate == 'forPostGraduationDownloadTemplate'){
	   			uploadTemplateForm.hide();
	   			downloadTemplateForm.show();
	   			grid.setVisible(false);
	   		}else{
	   			//this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
	   			var uploadoptionradiogroupform  = uploadTemplateForm.down('#stdPostGraduationUploadRadioGroupItemId');
	   			uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	   				isUploadAll: false
	   			});
	   			downloadTemplateForm.hide();
	   			grid.setVisible(true);
	   			uploadTemplateForm.show();
	   		}
	   	},
	   	addMoreRowStudentPostGraduation:function(){
		   	   var $this = this;
		   	   var stopContiner = $this.getStudentPostGraduationDownloadForm().down('#programBatchPostGraduationContainerId');
		   	   var panelItem = new Array();
		   	   var fieldContainer=obj.up('fieldcontainer');
		   	   var newcont=stopContiner.items.items.length;
			   var insertPosition=newcont+1;
		   	   panelItem.push({
					xtype : 'fieldcontainer',
					plugins : "formlabelrequired",
					width: '100%',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype: 'customcombobox',
		                name: 'programPostGraduation',
		                itemId: 'programPostGraduation' + insertPosition,
		                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		                valueField: 'id',
		                displayField: 'valueCode',
		                width:410,
		                allowBlank:false,
		                minChars:3,
		                typeAhead:false,
		                queryParam:'programName',
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
		                        combo.bindStore(store);
		                        
		                        var academyLocationId = $this.getCurrentAcademyLocation();
	                          	store.proxy.extraParams = {
	         							 academyLocationId : academyLocationId
	         					};
	                          	store.load();
		                    },
		                    select:function(obj,record){
		                    	var programId = record[0].get("id");
		                    	var  batch = obj.nextSibling();
		                    	var  period = batch.nextSibling();
		                    	var  section = period.nextSibling();

		                    	batch.setDisabled(false);
		                    	batch.reset();

		                    	period.setDisabled(true);
		                    	period.reset();

		                    	section.setDisabled(true);
		                    	section.reset();

		                    	var store = batch.getStore();

		                    	store.proxy.extraParams = {
		                    			id : programId
		                    	};
		                    	store.load();	                    	
		                    }
		                },
		                listConfig: {
		                	listeners: {
		                		beforeshow: function(picker) {
		                			var combo = picker.up('combobox');
									picker.setWidth(combo.getWidth());
		                		}
		                	},
		                	loadingText: getCommonTranslation('SEARCHING'),
		                	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                	getInnerTpl: function() {
		                		return '<div class="search-item">' +
								'{code} / {value}'+ 
								'</div>';
		                	}
		                }
					},{
						xtype: 'customcombobox',
		                name: 'batchNamePostGraduation',
		                itemId: 'batchNamePostGraduation' + insertPosition,
		                fieldLabel: getCommonTranslation('BATCH'),
		                disabled:true,
		                editable: false,
		                queryMode: 'local',
		                displayField: 'value',
		                valueField: 'id',
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                        combo.bindStore(store);
		                    },
		                    select:function(obj,record){
								var batchId = record[0].get("id");
								var  period = obj.nextSibling();
								var  section = period.nextSibling();

								period.setDisabled(false);
								period.reset();

								section.setDisabled(true);
								section.reset();

								var store = period.getStore();

								store.proxy.extraParams = {
										id : batchId
								};
								store.load();
							}
		                },
		                listConfig: {
			 				listeners: {
								beforeshow: function(picker) {
									var combo = picker.up('combobox');
									picker.setWidth(combo.getWidth());
								}
							}
			 			},
					},{
						xtype: 'customcombobox',
		                itemId:'periodPostGraduation' + insertPosition,
		                disabled:true,
		                editable: false,
		                displayField: 'value',
		                valueField: 'id',
		                queryMode: 'local',
		                fieldLabel: getCommonTranslation('PERIOD'),
		                name: 'periodPostGraduation',
		                listeners: {
		                    render: function(combo) {
		                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		                        combo.bindStore(store);
		                    },
		                    select:function(obj,record){
								var periodId = record[0].get("id");
								var  section = obj.nextSibling();

								section.setDisabled(false);
								section.reset();

								var store = section.getStore();

								store.proxy.extraParams = {
										periodId : periodId
								};
								store.load();

							}
		                },
		                listConfig: {
			 				listeners: {
								beforeshow: function(picker) {
									var combo = picker.up('combobox');
									picker.setWidth(combo.getWidth());
								}
							}
			 			},
					},{
						xtype : 'customcombobox',
						fieldLabel : getCommonTranslation('SECTION'),
						width: 226,
						labelAlign: 'top',
						name : 'sectionNamePost',
						itemId : 'sectionNamePost' + insertPosition,
						displayField : 'sectionCode',
						valueField : 'sectionId',
						typeAhead : true,
						disabled:true,
						forceSelection : true,
						listeners: {
							render: function(combo) {
			                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
			                    combo.bindStore(store);
							}
						},
						 listConfig: {
				 				listeners: {
									beforeshow: function(picker) {
										var combo = picker.up('combobox');
										picker.setWidth(combo.getWidth());
									}
								}
				 			},
					}, {
						xtype: 'button',
						itemId: 'deleteRowBtn',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip: getCommonTranslation('DELETE'),
						style:{
							marginTop:'30px'
						},
						listeners:{
							click:function(obj){
							   var container = obj.up('fieldcontainer');
		   					   var panelContiner = $this.getStudentPostGraduationDownloadForm().down('#programBatchPostGraduationContainerId');
		   					   panelContiner.remove(container);
		   					   $this.getStudentPostGraduationDownloadForm().getForm().checkValidity();
		   					   
						}}
					},{
						xtype: 'button',
						itemId: 'addMoreRowBtnPost',
						cls: 'CustomBodyBtnSettings mtAddRow',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					  }]
					});
		     	stopContiner.insert(insertPosition,panelItem);
		     	stopContiner.doLayout();
	   	},
	   	downloadTemplatePostGraduation:function(btn){
	   			var me = this,
	   		form = me.getStudentPostGraduationDownloadForm(),
	   		formContainer = form.down('#programBatchPostGraduationContainerId'),
	   		values = this.getProgramBatchPeriodJsonPostGraduation(),
    		csvForm = Ext.create('Ext.form.Panel',{
    			items:[{
    				xtype : 'textfield',
    				maxLength : 20480,
    				itemId : 'exportListDTO',
    				name : 'exportListDTO',
    				vtype : 'spaceAsInput'
    			}]
    		});
    		csvForm.down('#exportListDTO').setValue(values);
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'POST',
    			params :{access_token : Ext.Ajax.defaultHeaders.access_token},
    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    			url: SERVERURL.PATH_DOWNLOAD_FUNCTIONARY_DETAILS_TEMPLATE,
    			standardSubmit :true,
    			success : function(form, action){
    				showSuccessMessage(getCommonTranslation('IMPORT_STUDENT_POST_GRADUATION')	,getCommonTranslation('SUCCESS'));
    			},
    			failure: function(form, action) {
    				showSuccessMessage(getCommonTranslation('IMPORT_STUDENT_POST_GRADUATION')	,getCommonTranslation('SUCCESS'));
    				
    			}
    		});
	   		
	   	},
	   	getProgramBatchPeriodJsonPostGraduation:function(isStdStatusLoader){
	    	/**
	    	 * Json for stop
	    	 */
	    	var this$ = this,
            	basicStudentSearchForm=this$.getStudentPostGraduationDownloadForm(),
            	templateType=basicStudentSearchForm.down('#templateTypePostGraduationId');
           
	    	var pbpsContiner = basicStudentSearchForm.down('#programBatchPostGraduationContainerId');
	    	var pbpsFieldsCount = pbpsContiner.items.length;
	    	var pbpsArray=new Array();
	    	var endJson=null;
	    	var fieldSequence=1;
	    		for(var j=0; j<pbpsContiner.items.length; j++){
	    			var pbpsPanelContainer=pbpsContiner.items.items[j];
	    				pbpsArray.push({
	    					"programId" : pbpsPanelContainer.items.items[0].getValue(),
	    					"batchId":pbpsPanelContainer.items.items[1].getValue(),
	    					"periodId":pbpsPanelContainer.items.items[2].getValue(),
	    					"sectionId": pbpsPanelContainer.items.items[3].getValue(),
	    				});
	    	}
	    		var obj = new Object();
	    		if(templateType.getValue()== 'IMPORT_FUNCTIONARY_DETAILS'){
	    			obj.templateType='functionaryDetails';
	    		}else{
	    			obj.templateType='examinerDetails';
	    		}
	    	
	    	obj.studentsToConsider = pbpsArray;
	    	return Ext.encode(obj);	
	    },
	    uploadCsvFilePostGraduation:function(btn){
	    	//var me = this,
	    	btn.setDisabled(true);
	    	var $this=this;
    		var importForm=$this.getStudentPostGraduationUploadform();
    		var templateTypePostGraduationId=importForm.down('#importPostGraduationId');
    		var grid =$this.getStudentPostGraduationLoaderGrid();
    		$this.getHashOfFile(importForm);
    		setTimeout(function() {
    			importForm.getForm().submit({
    				method : 'POST',
    				url : SERVERURL.IMPORT_UTILITY_MASTER_CREATE,
    				success : function(form, action){
    					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    				},
    				failure: function(form, action) {
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
    				}
    			});
    		},1000);

    		Ext.defer(function() {
    			var form = $this.getStudentPostGraduationUploadform().down('#stdPostGraduationUploadRadioGroupItemId');
    			var isUploadAll = form.down('#uploadgroupItemId').getValue().isUploadAll;
    			$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,templateTypePostGraduationId.getValue());
    		}, 2000, this);
	    },

		onStudentProgramTransferFormRender: function(form) {
			var me = this;
			Ext.Ajax.request({
			    type: 'rest',
			    url: SERVERURL.COMMON_FORM_FIELD_INFO,
			    params: {
			        screenName: 'studentliststudentprogramtransferform',
			        academyLocationId: me.getCurrentAcademyLocation(),
			        languageCode: 'en'
			    },
			    method: 'GET',
			    success: function(res, action) {
			        var response = Ext.decode(res.responseText);
			        if (Object.keys(response).length > 0) {
			            var records = response.studentliststudentprogramtransferform;
			            records.forEach(function(record) {
			                if (record.isVisible) {
			                    switch (record.formFieldName) {
			                        case 'retainStudentData':
										if(record.defaultValue && record.defaultValue.toLowerCase() == 'yes') {
			                            	form.retainStudentData = 1;
										}
			                            break;
			                        case 'retainAcademicData':
			                           if(record.defaultValue && record.defaultValue.toLowerCase() == 'yes') {
			                            	form.retainAcademicData = 1;
										}
			                            break;
			                        case 'retainFeeAndPaymentData':
			                            if(record.defaultValue && record.defaultValue.toLowerCase() == 'yes') {
			                            	form.retainFeeAndPaymentData = 1;
										}
			                            break;
									case 'retainServiceOpted':
			                            if(record.defaultValue && record.defaultValue.toLowerCase() == 'yes') {
			                            	form.retainServiceOpted = 1;
										}
			                            break;
									case 'isCalculateSeparateCGPAndSGPA':
			                            if(record.defaultValue && record.defaultValue.toLowerCase() == 'yes') {
			                            	form.isCalculateSeparateCGPAndSGPA = 1;
										}
			                            break;
									case 'retainExamData':
			                            if(record.defaultValue && record.defaultValue.toLowerCase() == 'yes') {
			                            	form.retainExamData = 1;
										}
			                            break;
			                    }
			                }
			            });
			        }
			    }
			});
		},
		
		proceedForStudentTransfer: function(windowForm) {
			var me = this;
			var studentListGrid = this.getSearchResultGrid();
			var records = studentListGrid.getSelectionModel().getSelection();
			var admissionId = records[0].data.ADMISSION_ID;
			var academyLocationId = windowForm.down('#academyLocationCombo').getValue();
			var programId = windowForm.down('#program').getValue();
			var batchId = windowForm.down('#batch').getValue();
			var seatTypeId = windowForm.down('#seatType').getValue();
			var retainStudentDataId = windowForm.down('#retainStudentDataId').getValue();
			var retainAcademicDataId = windowForm.down('#retainAcademicDataId').getValue();
			var periodId = windowForm.down('#periodId').getValue();
			var sectionId = windowForm.down('#section').getValue();
			var refundRuleApplicable = windowForm.down('#refundRuleApplicable').getValue();
			var currentAcademyLocationId = this.getCurrentAcademyLocation();
			var courseEnrollemtStatus = windowForm.down('#courseEnrollmentStatusId').getValue();
			/*if(currentAcademyLocationId == academyLocationId ){
			   retainStudentDataId=true;
			   retainAcademicDataId=true;
			}*/
			var retainFeeAndPaymentDataId = windowForm.down('#retainFeeAndPaymentDataId').getValue();
			var retainServiceOptedId = windowForm.down('#retainServiceOptedId').getValue();
			/*
			                		   if(records[0].data.PROGRAM_BATCH_ID == batchId){
			                			   if(records[0].data.PROGRAM_PERIOD_NAME_NEW == windowForm.down('#periodId').getRawValue()){
			                				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('YOU_CANT_STUDENT_INTO_SAME_PERIOD'));
			                			   }else if(records[0].data.SEAT_TYPE == windowForm.down('#seatType').getRawValue()){
			                				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('YOU_CANT_STUDENT_INTO_SAME_SEAT_TYPE'));
			                			   }else if(records[0].data.SECTION_CODE == windowForm.down('#section').getRawValue()){
			                				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('YOU_CANT_STUDENT_INTO_SAME_SECTION'));
			                			   }
			                			  
			                		   }*/
			
			//SECTION_CODE,SEAT_TYPE,PROGRAM_PERIOD_NAME_NEW
			
			var currentAcademyLocationId = this.getCurrentAcademyLocation();
			if (currentAcademyLocationId == academyLocationId) {
			    /*retainStudentDataId=true;
			    retainAcademicDataId=true;
			    retainFeeAndPaymentDataId=true;
			    retainServiceOptedId=true;  */
			}
			var obj1 = new Object();
			obj1.academyLocationId = academyLocationId;
			obj1.programId = programId;
			obj1.batchId = batchId;
			obj1.refundRuleApplicable = refundRuleApplicable;
			obj1.progBatchSeatTypeId = seatTypeId;
			obj1.admissionId = admissionId;
			obj1.isRetainStudentData = retainStudentDataId;
			obj1.isRetainAcademiaData = retainAcademicDataId;
			obj1.periodId = periodId;
			obj1.courseEnrollmentStatus = courseEnrollemtStatus;
			obj1.isCalculateSeparateCGPAndSGPA = windowForm.down('#isCalculateSeparateCGPAndSGPAId').getValue();
			if (sectionId != 'undefined' && sectionId != null && sectionId != '') {
			    obj1.sectionId = sectionId;
			}
			try {
			    obj1.isRetainExaminationData = windowForm.down('form').getValues().retainExamData;
			} catch (e) {
			    console.log(e);
			}
			/*
			                		    obj1.retainFeeAndPaymentDataId= retainFeeAndPaymentDataId;
			                		    obj1.retainServiceOptedId= retainServiceOptedId;
			                		   */
			mainJsonObj = Ext.encode(obj1);
			
			if (retainStudentDataId == false) {
			 /* showConfirmMessage(getCommonTranslation('TRANSFER_CLOSURE_CONFIRMATION'), getCommonTranslation('ACADEMIC_AND_FEE_DATA_PERMANENTLY_DELETE'), function (btn, text) {
			        if (btn == 'yes') {*/
			            var submitUrl = SERVERURL.PATH_STUDENT_DIRECT_TRANSFER;
			            me.applyWindowMask();
			            Ext.Ajax.request({
			                type: 'rest',
			                url: submitUrl,
			                timeout: 900000, // 15 min
			                jsonData: mainJsonObj,
			                method: 'POST',
			                success: function (form, action) {
			                    me.hideWindowMask();
			                    if (form.responseText == 'BATCH_HAS_NO_MORE_CAPACITY') {
			                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BATCH_HAS_NO_MORE_CAPACITY'));
			                    } else {
			                        showSuccessMessage(getCommonTranslation('BATCH'), getCommonTranslation('SUCCESS'));
			                    }
			                    windowForm.close();
			                    studentListGrid.getSelectionModel().deselectAll(true);
			                    me.loadStudentListGridStore();
			                },
			                failure: function (form, action) {
			                    Ext.getBody().unmask();
			                    // showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
			                }
			            });
			       /* }
			
			    });*/
			} else {
			    var submitUrl = SERVERURL.PATH_STUDENT_DIRECT_TRANSFER;
			    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			    Ext.Ajax.request({
			        type: 'rest',
			        url: submitUrl,
			        timeout: 900000, // 15 min
			        jsonData: mainJsonObj,
			        method: 'POST',
			        success: function (form, action) {
			            Ext.getBody().unmask();
			            if (form.responseText == 'BATCH_HAS_NO_MORE_CAPACITY') {
			                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BATCH_HAS_NO_MORE_CAPACITY'));
			            } else {
			                showSuccessMessage(getCommonTranslation('BATCH'), getCommonTranslation('SUCCESS'));
			            }
			            windowForm.close();
			            studentListGrid.getSelectionModel().deselectAll(true);
			            me.loadStudentListGridStore();
			        },
			        failure: function (form, action) {
			            Ext.getBody().unmask();
			            // showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
			        }
			    });
			}
		}
});

