/**
 * @author Sachin.Bangar
 * This controller is used for student past history information actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentPastHistoryController', {
    extend: 'Academia.controller.personinfo.common.PersonPastHistoryController',
    mixins : {
		AddressController : 'Academia.controller.organization.AddressController'
	},

    alias: "widget.studentpasthistorycontroller",
    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'	
    }, {
        ref: 'personEducationForm',
        selector: 'educationform[itemId=studentEducationForm]'
    }, {
        ref: 'personWorkExperienceForm',
        selector: 'workexperienceform[itemId=studentWorkExperienceForm]'
    }, {
        ref: 'personMedicalHistoryForm',
        selector: 'medicalhistoryform[itemId=studentMedicalHistoryForm]'
    },{
        ref: 'personVaccinationForm',
        selector: 'vaccinationform[itemId=studentVaccinationForm]'
    },{
        ref: 'personExtraCurricularForm',
        selector: 'extracurricularform[itemId=studentExtraCurricularForm]'
    },{
        ref: 'personResearchTypeForm',
        selector: 'researchtypeform[itemId=studentResearchTypeForm]'
    },{
        ref: 'personResearchTypeFormStudentPortal',
        selector: 'researchtypeform[itemId=researchtypeformstudentportal]'
    },{
    	ref: 'personTrainingDetailsFormStudentPortal',
        selector: 'persontrainingdetailsform[itemId=trainingdetailsformstudentportal]'
    },{
        ref: 'personResearchDocumentViewForm',
        selector: 'researchdocumentviewform[itemId=studentResearchDocumentViewForm]'
    },{
        ref: 'personSeminarDetailsForm',
        selector: 'seminardetailsform[itemId=studentSeminarDetailsForm]'
    },{
        ref: 'personSeminarDocumentViewForm',
        selector: 'seminardocumentviewform[itemId=studentSeminarDocumentViewForm]'
    },{
        ref: 'personPatentDetailsForm',
        selector: 'patentdetailsform[itemId=studentPatentDetailsForm]'
    },{
        ref: 'personPatentDocumentViewForm',
        selector: 'patentdocumentviewform[itemId=studentPatentDocumentViewForm]'
    },{
        ref: 'personTrainingDetailsForm',
        selector: 'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm]'
    },{
        ref: 'personTrainingDocumentViewForm',
        selector: 'persontrainingdocumentviewform[itemId=studentTrainingDocumentViewForm]'
    },{
        ref: 'personCompetitiveExamForm',
        selector: 'competitiveexamform[itemId=studentCompetitiveExamForm]'
    },{
    	ref:'physicalcharacteristicsform',
    	selector:'physicalcharacteristicsform'
    }, {
        ref: 'personMedicalDetailsForm',
        selector: 'medicaldetailsform[itemId=studentMedicalDetailsFormItemId]'
    }, {
        ref: 'personChurchInformationForm',
        selector: 'churchinformationform[itemId=studentChurchInfoForm]'
    },{
    	ref:'churchemploymenthistorywindow',
    	selector:'churchemploymenthistorywindow'
    },{
		ref : 'simpledocumentform',
		selector : 'simpledocumentform'

	},{
		ref : 'vaccinationinfodocumentgrid',
		selector : 'vaccinationinfodocumentgrid'

	},{
		ref : 'vaccinationinfodocumentlist',
		selector : 'vaccinationinfodocumentlist'

	},{
		ref : 'vaccinationinfodocumentlistgrid',
		selector : 'vaccinationinfodocumentlistgrid'

	},{
		ref : 'vaccinationgrid',
		selector : 'vaccinationgrid[itemId=studentVaccinationGrid]'
	},
	{
		ref : 'addressformwindow',
		selector : 'addressFormWindow[itemId=studentTrainingAddressDetails]'
	}, 
	{
        ref: 'addressfieldsform',
        selector: 'addressFormWindow form[itemId=addressfieldsform]'
	},{
		ref: 'nonacademicachievementsform',
		selector: 'nonacademicachievementsform[itemId=nonacademicachievementsform]'
	}, {
		ref: 'personSocioEconomicInfoForm',
		selector: 'socioeconomicinformationform[itemId=admStudentSocioEconomicFormItemId]'
	},{
        ref: 'patentdetailssupervisorrwindow',
        selector: 'patentdetailssupervisorrwindow[itemId=studentpatentdetailssupervisorrwindow]'
	}, {
    	ref: 'postSchoolStudiesForm',
    	selector: 'postschoolstudiesform[itemId=studentPostSchoolStudiesform]'
	}, {
    	ref: 'postDocInfoForm',
    	selector: 'postdocinfoform[itemId=studentPostDocInfoForm]'
	}, {
    	ref: 'postdocinfodocumentgrid',
    	selector: 'postdocinfodocumentgrid'
	},{
		ref: 'studentpostinfogrid',
    	selector: 'studentpostinfogrid[itemId=studentpostinfogridId]'
    },{
		ref: 'studentjointdegreegrid',
    	selector: 'studentjointdegreegrid[itemId=studentjointdegreegridId]'
    },{
        ref: 'studentjointdegreedocumentgrid', 
        selector: 'studentjointdegreedocumentgrid'
    },{
           ref: 'studentJointDegreeForm',
           selector: 'studentjointdegreeform[itemId=studentjointdegreeformItemId]' 
    },{
        ref: 'studentthesistitlegrid',
        selector: 'studentthesistitlegrid[itemId=studentthesistitlegridId]'
    },{
        ref: 'studentThesisTitleForm',
        selector: 'studentthesistitleform[itemId=studentThesisTitleFormItemId]'
    },{
		ref : 'studentpostdocinfodocumentlist',
		selector : 'studentpostdocinfodocumentlist'
	}, {
		ref : 'studentpostdocinfodocumentlistgrid',
		selector : 'studentpostdocinfodocumentlistgrid'
	},{
		ref : 'studentjointdegreedocumentlist',
		selector : 'studentjointdegreedocumentlist'
	}, {
		ref : 'studentjointdegreedocumentlistgrid',
		selector : 'studentjointdegreedocumentlistgrid'
	},{
		ref: 'studentownprogressreportgrid',
    	selector: 'studentownprogressreportgrid[itemId=studentownprogressreportgridId]'
    },{
        ref: 'studentOwnProgressReportForm',
        selector: 'studentownprogressreportform[itemId=studentownprogressreportformItemId]' 
    },{
		ref: 'studentmougrid',
    	selector: 'studentmougrid[itemId=studentmougridId]'
    },{
        ref: 'studentMOUForm',
        selector: 'studentmouform[itemId=studentmouformId]' 
    },{
        ref: 'studentmoudocumentgrid',
        selector: 'studentmoudocumentgrid' 
    },{ 
    	ref: 'studentmoudocumentlist',
    	selector: 'studentmoudocumentlist' 
    },{
    	ref: 'studentmoudocumentlistgrid',
    	selector: 'studentmoudocumentlistgrid' 
    },{
        ref: 'studentownprogressreportdocumentlist',
        selector: 'studentownprogressreportdocumentlist'
    },{
        ref: 'studentownprogressreportdocumentgrid',
        selector: 'studentownprogressreportdocumentgrid'
    },{
		ref: 'functionaryprogressreportgrid',
    	selector: 'functionaryprogressreportgrid[itemId=functionaryprogressreportgridId]'
    },{
        ref: 'functionaryProgressReportForm',
        selector: 'functionaryprogressreportform[itemId=functionaryprogressreportformId]' 
    },{ 
    	ref: 'functionaryprogressreportdocumentgrid',
    	selector: 'functionaryprogressreportdocumentgrid' 
    },{ 
    	ref: 'functionaryprogressreportdocumentlist',
    	selector: 'functionaryprogressreportdocumentlist' 
    },{ 
    	ref: 'functionaryprogressreportdocumentlistgrid',
    	selector: 'functionaryprogressreportdocumentlistgrid' 
    },{
		ref: 'studentethicsclearancelettergrid',
    	selector: 'studentethicsclearancelettergrid[itemId=studentethicsclearancelettergridId]'
    },{
        ref: 'studentEthicsClearanceLetterForm',
        selector: 'studentethicsclearanceletterform[itemId=studentethicsclearanceletterformId]' 
    },{ 
    	ref: 'studentethicsclearanceletterdocumentgrid',
    	selector: 'studentethicsclearanceletterdocumentgrid' 
    },{ 
    	ref: 'studentethicsclearanceletterdocumentlist',
    	selector: 'studentethicsclearanceletterdocumentlist' 
    },{ 
    	ref: 'studentethicsclearanceletterdocumentlistgrid',
    	selector: 'studentethicsclearanceletterdocumentlistgrid' 
    },{
        ref: 'studentExaminersReportGrid',
        selector: 'studentexaminersreportgrid[itemId=studentExaminersReportGridId]' 
    },{
        ref: 'studentexaminersreportdocumentgrid',
        selector: 'studentexaminersreportdocumentgrid'
    },{
        ref: 'studentExaminersReportFormItemId',
        selector: 'studentexaminersreportform[itemId=studentExaminersReportFormItemId]' 
    },{
        ref: 'studentexaminersreportdocumentlist',
        selector: 'studentexaminersreportdocumentlist[itemId=studentexaminersreportdocument]' 
    },{
        ref: 'studentexaminersreportdocumentlistgrid',
        selector: 'studentexaminersreportdocumentlistgrid[itemId=studentexaminersreportdocumentlistgridItemId]' 
        },{
		ref: 'functionarydetailsgrid',
    	selector: 'functionarydetailsgrid[itemId=functionarydetailsgridId]'
    }, {
    	ref: 'functionaryDetailsForm', 
    	selector: 'functionarydetailsform[itemId=studentFunctionaryDetailsForm]'
    },{
    	ref: 'independentnonexaminingchairpersonreportgrid', 
    	selector: 'independentnonexaminingchairpersonreportgrid[itemId=independentnonexaminingchairpersonreportgridId]'
    },{
        ref: 'studentThesisUploadGrid',
        selector: 'studentthesisuploadgrid[itemId=studentThesisUploadGridId]' 
    },{
        ref: 'studentThesisUploadForm',
        selector: 'studentthesisuploadform[itemId=studentThesisUploadFormItemId]' 
    },{
        ref: 'studentThesisUploadDocumentGrid',
        selector: 'studentthesisuploaddocumentgrid[itemId=studentThesisUploadDocumentGridItemId]' 
    },{
        ref: 'studentthesisuploaddocumentlist',
        selector: 'studentthesisuploaddocumentlist[itemId=studentthesisuploaddocumentlist]' 
    },{
        ref: 'studentthesisuploaddocumentlistgrid',
        selector: 'studentthesisuploaddocumentlistgrid[itemId=studentthesisuploaddocumentlistgridItemId]' 
    },{
		ref: 'nominateexaminersgrid',
    	selector: 'nominateexaminersgrid[itemId=nominateexaminersgridId]'
    },{
    	ref: 'nominateExaminersForm', 
    	selector: 'nominateexaminersform[itemId=nominateexaminersformId]'
    },{
    	ref: 'independentNonExaminingChairPersonDocGrid', 
    	selector: 'independentnonexaminingchairpersondocgrid[itemId=independentNonExaminingChairPersonDocGridItemId]'
    },{
        ref: 'independentNonExaminingChairPersonForm',
        selector: 'independentnonexaminingchairpersonform[itemId=independentNonExaminingChairPersonFormItemId]'
    },{
        ref: 'independentnonexaminingchairpersondocumentlist',
        selector: 'independentnonexaminingchairpersondocumentlist'
    },{
        ref: 'independentnonexaminingchairpersondocumentlistgrid',
        selector: 'independentnonexaminingchairpersondocumentlistgrid'
    }/*,{
    	ref: 'flagliststudentgrid',
        selector: 'flagliststudentgrid'
    }*/,{
		ref: 'proofofactivitygrid',
    	selector: 'proofofactivitygrid[itemId=proofofactivitygridId]'
    },{
        ref: 'proofofactivityform',
        selector: 'proofofactivityform[itemId=proofofactivityformid]' 
    },{
        ref: 'studentlanguagedetailform',
        selector: 'studentlanguagedetailform[itemId=studentlanguageformId]'
    },{
        ref: 'proofofactivitydocumentgrid',
        selector: 'proofofactivitydocumentgrid' 
    },{ 
    	ref: 'proofofactivitydocumentlist',
    	selector: 'proofofactivitydocumentlist' 
    },{
    	ref: 'proofofactivitydocumentlistgrid',
    	selector: 'proofofactivitydocumentlistgrid' 
    }, {
		 ref: 'studenteducationhistorydetailgrid',
		 selector: 'studenteducationhistorydetailgrid[itemId=studentEducationHistoryDetailGrid]'
	 }, {
		 ref: 'educationhistorydetailform',
		 selector: 'educationhistorydetailform[itemId=studenteducationhistorydetailform]'
	 },{
		 ref: 'studenteducationhistorydocumentgrid',
		 selector: 'studenteducationhistorydocumentgrid'
	 },{
		 ref: 'studenteducationhistoryurlgrid',
		 selector: 'studenteducationhistoryurlgrid'
	 },{
		 ref: 'studenteducationhistorydocumentlist',
		 selector: 'studenteducationhistorydocumentlist'
	 }, {
		 ref: 'studenteducationhistorydocumentlistgrid',
		 selector: 'studenteducationhistorydocumentlistgrid'
	 }, {
		 ref: 'studenteducationhistorydocurllist',
		 selector: 'studenteducationhistorydocurllist'
	 }, {
		 ref: 'studenteducationhistorydocurllistgrid',
		 selector: 'studenteducationhistorydocurllistgrid'
	 },{
		 ref: 'studentlanguageinformationgrid',
		 selector: 'studentlanguageinformationgrid[itemId=studentLanguagesInformationGridItemId]'
	},{
        ref: 'documentformwindow',
        selector: 'documentformwindow'
    }, {
    	ref: 'healthinformationdetailgrid',
    	selector: 'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId]'
    }, {
    	ref: 'learningallowancegrid',
    	selector: 'learningallowancegrid[itemId=learningAllowanceItemId]'
    },{
		 ref: 'studentlanguagedocumentgrid',
		 selector: 'studentlanguagedocumentgrid'
	 },{
		 ref: 'studentlanguageurlgrid',
		 selector: 'studentlanguageurlgrid'
	},{
		 ref: 'studentlanguagedocumentlist',
		 selector: 'studentlanguagedocumentlist'
	},{
		 ref: 'studentlanguagedocurllist',
		 selector: 'studentlanguagedocurllist'
	},{
		 ref: 'studentlanguagedocumentlistgrid',
		 selector: 'studentlanguagedocumentlistgrid'
	},{
		 ref: 'studentlanguagedocurllistgrid',
		 selector: 'studentlanguagedocurllistgrid'
	},{
		 ref: 'studenthealthinformationdocumentgrid',
		 selector: 'studenthealthinformationdocumentgrid'
	},{
		 ref: 'studenthealthinformationurlgrid',
		 selector: 'studenthealthinformationurlgrid'
	},{
	     ref: 'studenthealthinformationform',
	     selector: 'studenthealthinformationform[itemId=StudentHealthInformationForm]'
    },{
	     ref: 'studentlearningallowanceaddform',
	     selector: 'studentlearningallowanceaddform[itemId=StudentLearningAllowanceAddForm]'
    },{
    	 ref: 'documentformwindow',
    	 selector: 'documentformwindow'
 	},{
 		 ref: 'Studenthealthinformationdocumentlist',
 		 selector: 'Studenthealthinformationdocumentlist[itemId=studenthealthinformationdocumentlistItemId]'
 	},{
         ref: 'studenthealthinformationdocumentlistgrid',
             selector: 'studenthealthinformationdocumentlistgrid'
    }, {
             ref: 'studenthealthinformationdocurllist',
             selector: 'studenthealthinformationdocurllist[itemId=studenthealthinformationdocurllistItemId]'
    }, {
             ref: 'studenthealthinformationdocurllistgrid',
             selector: 'studenthealthinformationdocurllistgrid'
    }],
    config: {
    	STUDENT_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EDUCATION_PRIVILEGES'),
    	STUDENT_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_WORK_EXPERIENCE_PRIVILEGES'),
    	STUDENT_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MEDICAL_PRIVILEGES'),
    	STUDENT_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_VACCINATION_PRIVILEGES'),
    	STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	STUDENT_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_RESEARCH_DETAILS_PRIVILEGES'),
    	STUDENT_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SEMINAR_DETAILS_PRIVILEGES'),
    	STUDENT_TRAINING_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRAINING_PRIVILEGES'),
    	STUDENT_PATENT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PATENT_PRIVILEGES'),
    	STUDENT_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COMPETITIVE_EXAM_PRIVILEGES'),
    	STUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES'),
    	STUDENT_HOSTEL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOSTEL_DETAILS_PRIVILEGES'),
    	STUDENT_MEDICAL_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MEDICAL_DETAIL_PRIVILEGES'),
    	STUDENT_TRANSPORT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSPORT_DETAILS_PRIVILEGES'),
    	STUDENT_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_CHURCH_INFORMATION_PRIVILEGES'),
    	STUDENT_COMMUNICATION_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COMMUNICATION_HISTORY_PRIVILEGES'),
    	STUDENT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES'),
    	FP_STUDENT_COMMUNICATION_HISTORY_VIEW_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_COMMUNICATION_HISTORY_VIEW_PRIVILEGES'),
    	PARENT_HOSTEL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_HOSTEL_DETAILS_PRIVILEGES'),
    	PARENT_TRANSPORT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_TRANSPORT_DETAILS_PRIVILEGES'),
    	PARENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES'),
    	PARENT_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_EDUCATION_PRIVILEGES'),
    	PARENT_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_WORK_EXPERIENCE_PRIVILEGES'),
    	PARENT_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_MEDICAL_PRIVILEGES'),
    	PARENT_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_VACCINATION_PRIVILEGES'),
    	PARENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	PARENT_INFIRMARY_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_INFIRMARY_DETAILS_PRIVILEGES'),
    	PARENT_MEDICAL_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_MEDICAL_DETAIL_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_EDUCATION_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_EDUCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_EDUCATION_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_WORK_EXPERIENCE_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_WORK_EXPERIENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_WORK_EXPERIENCE_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_MEDICAL_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_MEDICAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_MEDICAL_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_VACCINATION_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_VACCINATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_VACCINATION_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_RESEARCH_DETAILS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_RESEARCH_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_RESEARCH_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_SEMINAR_DETAILS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_SEMINAR_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_SEMINAR_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_PATENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PATENT_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_PATENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_PATENT_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PATENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PATENT_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_TRAINING_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_TRAINING_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_TRAINING_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_HOSTEL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_HOSTEL_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_HOSTEL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_HOSTEL_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_COMPETITIVE_EXAM_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_MEDICAL_DETAIL_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_MEDICAL_DETAIL_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_TRANSPORT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_TRANSPORT_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_TRANSPORT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_TRANSPORT_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_CHURCH_INFORMATION_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_CHURCH_INFORMATION_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_CHURCH_INFORMATION_PRIVILEGES'),
    	STUDENT_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES'),
    	STUDENT_PORTAL_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES'),
    	STUDENT_POST_SCHOOL_STUDIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_POST_SCHOOL_STUDIES_PRIVILEGES'),
    	STUDENT_PORTAL_POST_SCHOOL_STUDIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_POST_SCHOOL_STUDIES_PRIVILEGES'),
    	FACULTY_PORTAL_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES'),
    	FACULTY_PORTAL_POST_SCHOOL_STUDIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_POST_SCHOOL_STUDIES_PRIVILEGES'),
    	CORE_ERP_STUDENT_THESIS_TITLE:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_THESIS_TITLE'),
		CORE_ERP_STUDENT_JOINT_DEGREE:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_JOINT_DEGREE'),
		CORE_ERP_STUDENT_OWN_PROGRESS_REPORT:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_OWN_PROGRESS_REPORT'),
		CORE_ERP_FUNCTIONARY_PROGRESS_REPORT:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_FUNCTIONARY_PROGRESS_REPORT'),
		CORE_ERP_STUDENT_MOU:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_MOU'),
		CORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER'),
		STUDENT_POST_DOC_INFO_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_POST_DOC_INFO'),
		CORE_ERP_EXAMINERS_REPORT:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_EXAMINERS_REPORT'),
		CORE_ERP_STUDENT_THESIS_UPLOAD:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_STUDENT_THESIS_UPLOAD'),
		CORE_ERP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),
		CORE_ERP_FUNCTIONARY_DETAILS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_FUNCTIONARY_DETAILS'),
		CORE_ERP_NOMINATE_EXAMINERS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_NOMINATE_EXAMINERS'),
		STUDENT_PORTAL_STUDENT_MOU_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_MOU_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_ETHICS_CLEARANCE_LETTER_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_ETHICS_CLEARANCE_LETTER_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_OWN_PROGRESS_REPORT_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_OWN_PROGRESS_REPORT_PRIVILEGES'),
		STUDENT_FLAG_LIST_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FLAG_LIST_PRIVILEGES'),
		CORE_ERP_PROOF_OF_ACTIVITY:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_PROOF_OF_ACTIVITY'),
    	EDUCATION_HISTORY_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EDUCATION_HISTORY_PRIVILEGES'),
    	STUDENT_PORTAL_EDUCATION_HISTORY_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EDUCATION_HISTORY_PREVILEGES'),
		STUDENT_LANGUAGE_INFORMATION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LANGUAGE_INFORMATION_PRIVILEGES'),
		STUDENT_HEALTH_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HEALTH_INFORMATION_PRIVILEGES'),
		STUDENT_ENGAGEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ENGAGEMENT_PRIVILEGES'),
		STUDENT_LEARNING_ALLOWANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LEARNING_ALLOWANCE_PRIVILEGES'),
		STUDENT_PORTAL_LEARNING_ALLOWANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_LEARNING_ALLOWANCE_PREVILEGES'),
		PARENT_PORTAL_HEALTH_INFORMATION_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_HEALTH_INFORMATION_PRIVILEGES'),
		FACULTY_PORTAL_HEALTH_INFORMATION_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_HEALTH_INFORMATION_PRIVILEGES'),
		STUDENT_PORTAL_HEALTH_INFORMATION_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_HEALTH_INFORMATION_PRIVILEGES'),
		STUDENT_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_LANGUAGE_INFORMATION_PRIVILEGES'),
		PARENT_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_LANGUAGE_INFORMATION_PRIVILEGES'),
		FACULTY_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_LANGUAGE_INFORMATION_PRIVILEGES'),
		PARENT_PORTAL_EDUCATION_HISTORY_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EDUCATION_HISTORY_PRIVILEGES'),
		FACULTY_PORTAL_EDUCATION_HISTORY_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_EDUCATION_HISTORY_PRIVILEGES'),
		HEALTH_INFORMATON_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HEALTH_INFORMATON_DOCUMENT_PRIVILEGES'),
		HEALTH_INFORMATON_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HEALTH_INFORMATON_URL_PRIVILEGES'),
	    STUDENT_HEALTH_INFORMATON_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HEALTH_INFORMATON_DOCUMENT_PRIVILEGES'),
	    STUDENT_HEALTH_INFORMATON_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HEALTH_INFORMATON_URL_PRIVILEGES'),
	    FACULTY_HEALTH_INFORMATON_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HEALTH_INFORMATON_DOCUMENT_PRIVILEGES'),
	    FACULTY_HEALTH_INFORMATON_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HEALTH_INFORMATON_URL_PRIVILEGES'),
	    PARENT_HEALTH_INFORMATON_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_HEALTH_INFORMATON_DOCUMENT_PRIVILEGES'),
	    PARENT_HEALTH_INFORMATON_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_HEALTH_INFORMATON_URL_PRIVILEGES'),
	    LANGUAGE_INFORMATION_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LANGUAGE_INFORMATION_DOCUMENT_PRIVILEGES'),
	    LANGUAGE_INFORMATION_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LANGUAGE_INFORMATION_URL_PRIVILEGES'),
	    STUDENT_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LANGUAGE_INFORMATION_DOCUMENT_PRIVILEGES'),
	    STUDENT_LANGUAGE_INFORMATION_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LANGUAGE_INFORMATION_URL_PRIVILEGES'),
	    FACULTY_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_LANGUAGE_INFORMATION_DOCUMENT_PRIVILEGES'),
	    FACULTY_LANGUAGE_INFORMATION_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_LANGUAGE_INFORMATION_URL_PRIVILEGES'),
	    PARENT_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_LANGUAGE_INFORMATION_DOCUMENT_PRIVILEGES'),
	    PARENT_LANGUAGE_INFORMATION_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_LANGUAGE_INFORMATION_URL_PRIVILEGES'),
	    EDUCATION_HISTORY_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EDUCATION_HISTORY_DOCUMENT_PRIVILEGES'),
	    EDUCATION_HISTORY_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EDUCATION_HISTORY_URL_PRIVILEGES'),
	    STUDENT_EDUCATION_HISTORY_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EDUCATION_HISTORY_DOCUMENT_PRIVILEGES'),
	    STUDENT_EDUCATION_HISTORY_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EDUCATION_HISTORY_URL_PRIVILEGES'),
	    FACULTY_EDUCATION_HISTORY_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EDUCATION_HISTORY_DOCUMENT_PRIVILEGES'),
	    FACULTY_EDUCATION_HISTORY_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EDUCATION_HISTORY_URL_PRIVILEGES'),
	    PARENT_EDUCATION_HISTORY_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_EDUCATION_HISTORY_DOCUMENT_PRIVILEGES'),
	    PARENT_EDUCATION_HISTORY_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_EDUCATION_HISTORY_URL_PRIVILEGES'),
	    FACULTY_STUDENT_THESIS_TITLE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_THESIS_TITLE_PRIVILEGES'),
	    FACULTY_STUDENT_POST_DOC_INFO_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_POST_DOC_INFO_PRIVILEGES'),
	    FACULTY_STUDENT_JOINT_DEGREE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_JOINT_DEGREE_PRIVILEGES'),
	    FACULTY_STUDENT_OWN_PROGRESS_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_OWN_PROGRESS_REPORT_PRIVILEGES'),
	    FACULTY_FUNCTIONARY_PROGRESS_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_FUNCTIONARY_PROGRESS_REPORT_PRIVILEGES'),
	    FACULTY_STUDENT_MOU_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_MOU_PRIVILEGES'),
	    FACULTY_STUDENT_ETHICS_CLEARANCE_LETTER_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_ETHICS_CLEARANCE_LETTER_PRIVILEGES'),
	    FACULTY_EXAMINERS_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_EXAMINERS_REPORT_PRIVILEGES'),
	    FACULTY_STUDENT_THESIS_UPLOAD_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_THESIS_UPLOAD_PRIVILEGES'),
	    FACULTY_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_PRIVILEGES'),
	    FACULTY_FUNCTIONARY_DETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_FUNCTIONARY_DETAILS_PRIVILEGES'),
	    FACULTY_NOMINATE_EXAMINERS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_NOMINATE_EXAMINERS_PRIVILEGES'),
	    FACULTY_PROOF_OF_ACTIVITY_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_PROOF_OF_ACTIVITY_PRIVILEGES'),
    },
    init: function(application) {
    	this.healthMode;
    	this.isAdd=true;
    	this.formModelMode
        this.control({
        	'studenthealthinformationform':{
    			afterrender: function(form) {	
    				if(this.isAdd){
    					form.up().setTitle(getCommonTranslation('ADD_HEALTH_INFORMATION'));
    				}else{
    					form.up().setTitle(getCommonTranslation('EDIT_HEALTH_INFORMATION'));
    				}
    				var medicalConditions = form.down('#medicalConditionsItemId');
					var medicationItemId = form.down('#medicationItemId');
					var allergiesItemId = form.down('#allergiesItemId');
					var learningDifficultiesItemId = form.down('#learningDifficultiesItemId');
					
					if(medicalConditions.isHidden()){
						form.down('#medicalConditionName').setVisible(false);
					}
					if(medicationItemId.isHidden()){
						form.down('#medicationName').setVisible(false);
					}
					if(allergiesItemId.isHidden()){
						form.down('#allergiesName').setVisible(false);
					}
					if(learningDifficultiesItemId.isHidden()){
						form.down('#learningDifficultiesName').setVisible(false);
					}
    			}
    		},
    		
    		/*'studentlearningallowanceaddform':{
    			afterrender: function(form) {	
    				var medicalConditions = form.down('#learningAllowancesItemId');
					
					if(medicalConditions.isHidden()){
						form.down('#descriptionOther').setVisible(false);
					}
    			}
    		},*/
        	
    		/*'flagliststudentgrid':{
    			afterrender: function(grid) {					
					this.doAccessControlValidation(grid, this.getSTUDENT_FLAG_LIST_PRIVILEGES());
    			}
    		},*/
    		'proofofactivityform':{
    			afterrender: function(form) {	
    				if(this.isAdd){
    					form.up().setTitle(getCommonTranslation('ADD_PROOF_OF_ACTIVITY'));
    				}else{
    					form.up().setTitle(getCommonTranslation('EDIT_PROOF_OF_ACTIVITY'));
    				}
    			}
    		},
    		
        	'studentthesistitleform multiselectcombofield#researchActivityMultiselect' : {
    			change : function(obj, record) {
    				var $this = this;
    				var formLayout = $this.getStudentThesisTitleForm();
					
    			}
    		},
        	
        	'proofofactivityform customcombobox#researchActivity' : {
    			change : function(obj, record) {
    				var $this = this;
    				var formLayout = $this.getProofofactivityform();
					var researchActivity= $this.getProofofactivityform().down('#researchActivityName');
    				var activity = formLayout.down ('#researchActivity').getDisplayValue();
				     var currentVal = activity;
							if(currentVal=="Other"){
	    						researchActivity.setDisabled(false);
	    						return false;
	    					}else{
	    						researchActivity.setDisabled(true);
	    					}		
    		}
        },
        	/**
        	 * Vaccination Document Details
        	 */
            'vaccinationinfodocumentgrid': {
                render: function(grid) {},
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	   				 if(columnName == "documentName"){
	   					 if(e.target.tagName=='A'){
	   						 this.getDownloadFile(record.get('documentId'));
	   					 }
	   				 }
	   			}
            },
        	
        	/**
        	 * Education Details
        	 */

            'educationhistorygrid[itemId=studentEducationHistoryGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#studentEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_GRIDDATA,grid);
            		portalId = this.getCurrentLoggedPortalId();

            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_EDUCATION_PERMISSIONS());
            			grid.setVisible(false);
            			setTimeout(function(){
            				Ext.each(grid.columns, function(currentColumn){
            					if(currentColumn.dataIndex=="marksOrGradeObtained")
            					{
            						currentColumn.setVisible(false);
            					}if(currentColumn.dataIndex=="percentage")
            					{
            						currentColumn.setVisible(false);
            					}if(currentColumn.dataIndex=="resultStatus")
            					{
            						currentColumn.setVisible(false);
            					}if(currentColumn.dataIndex=="enrollmentNumber")
            					{
            						currentColumn.setVisible(false);
            					}
            				});
            				grid.setVisible(true);
            			}, 1);
            			grid.getView().refresh();
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_EDUCATION_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_EDUCATION_PERMISSIONS());
            			grid.setVisible(false);
            			setTimeout(function(){
            				Ext.each(grid.columns, function(currentColumn){
            					if(currentColumn.dataIndex=="marksOrGradeObtained")
            					{
            						currentColumn.setVisible(false);
            					}if(currentColumn.dataIndex=="percentage")
            					{
            						currentColumn.setVisible(false);
            					}if(currentColumn.dataIndex=="resultStatus")
            					{
            						currentColumn.setVisible(false);
            					}if(currentColumn.dataIndex=="enrollmentNumber")
            					{
            						currentColumn.setVisible(false);
            					}
            				});
            				grid.setVisible(true);
            			}, 1);
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_EDUCATION_PERMISSIONS());
            		}
            	}
            },
            'educationhistorygrid[itemId=studentEducationHistoryGrid] button[itemId=btnAdd]': {
            	click: function() {
                    this.showPersonCommonWindow('EDUCATION', 'studentEducationForm');
                }
            },
            'educationhistorygrid[itemId=studentEducationHistoryGrid] button[itemId=btnEdit]': {
                click: function(){
                	this.editEducationHistoryFormWindow('EDUCATION', 'studentEducationForm', '#studentEducationHistoryGrid', false, 'STUDENT');
                }
            },
            'educationhistorygrid[itemId=studentEducationHistoryGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewEducationHistoryFormWindow('EDUCATION', 'studentEducationForm', '#studentEducationHistoryGrid','STUDENT');
            	}
            },
            'educationhistorygrid[itemId=studentEducationHistoryGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteEducationHistoryRecord('#studentEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] form[itemId=studentEducationForm]': {
                afterrender: function() {
                    this.afterEducationFormRender();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=resultStatusId]': {
                change: function(combo, records, eOpts) {
                	this.shoHideMarksDeatilFields(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=gradeMark]': {
                change: function(combo, records, eOpts) {
                	this.showHideGradeMarkFileds(combo, records, eOpts);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=subject]': {
            	select : function(obj, record) {

    				var subject=record[0].get('id');
                    var subjectCode=record[0].get('code');
    				var flag = true;
					var subjectMarkPanel = obj.up("#subjectMarkPanel");
					var rowIndx = obj.rowIndx;
					if(!isNullOrEmpty(subjectMarkPanel)){
						subjectMarkPanel.items.each(function(item, index, items) {
							var subjectNameVal = item.down("[name=subject]").getValue();
							if(subjectCode!='Other') {
 							if(subject == subjectNameVal && rowIndx != index){
 								flag = false;
 	        					return false;
 							}
 							}
						});
						
						if(flag){
 							var marks = obj.up('form').down('#marks');
 							var subMaximumMarks = obj.up('form').down('#subMaximumMarks');
             				if(!isNullOrEmpty(marks)){
             					marks.setDisabled(false);
             					subMaximumMarks.setDisabled(false);
             				}
                            var subject = record[0].get("id");
             				if(!obj.nextSibling().nextSibling().isHidden()){
             					var subject = obj.nextSibling().nextSibling();
             					subject.setDisabled(false);
             					var assessment = subject.nextSibling();
             					assessment.setDisabled(true);
             					var marksField = assessment.nextSibling().nextSibling();
             				}else{
             					if(!obj.nextSibling().nextSibling().nextSibling().isHidden()){
	             					var assessment = obj.nextSibling().nextSibling().nextSibling();
	             					assessment.setDisabled(false);
	             					var subject = assessment.nextSibling();
	             					var marksField = subject.nextSibling();
	             					subject.setDisabled(true);
             					}
             					else {
             						var assessment = obj.nextSibling().nextSibling().nextSibling();
             						var subject = assessment.nextSibling();
	             					var marksField = subject.nextSibling();
	             					subject.setDisabled(false);
             					}
             				}
                        	if(marksField){
                        		marksField.setDisabled(false);
                        		subMaximumMarks.setDisabled(false);
                        	}
                        	var otherSubject = obj.nextSibling();
                        	if(subjectCode=='Other') {
                        		otherSubject.setVisible(true);
                        		otherSubject.allowBlank = false;
                        	} else {
                        		otherSubject.reset();
                        		otherSubject.setVisible(false);
                        		otherSubject.allowBlank = true;
                        	}
                        	 var fieldContainer = obj.up('fieldcontainer');
                        	var symbolLevel = fieldContainer.down('#symbolLevelId');
                        	var percentage = fieldContainer.down('#percentageId');

                        	if (!isNullOrEmpty(symbolLevel)) {
                        		symbolLevel.setDisabled(false);
                        	}
                        	if (!isNullOrEmpty(percentage)) {
                        		percentage.setDisabled(false);
                        	}

                        	obj.up('form').getForm().checkValidity();
                        	obj.up('form').getForm().isValid();
                        	
 						}
 						else{
 							obj.reset();
 							var otherSubject = obj.nextSibling();
 							otherSubject.reset();
 							otherSubject.allowBlank = true;
 							otherSubject.setVisible(false);
 							if(!obj.nextSibling().nextSibling().isHidden()){
 							var nextSiblingField = obj.nextSibling().nextSibling();
 							nextSiblingField.reset();
 							nextSiblingField.setDisabled(true);
 							}else{
 								var nextSiblingField = obj.nextSibling().nextSibling().nextSibling();
 	 							nextSiblingField.reset();
 	 							nextSiblingField.setDisabled(true);
 							}
 							var subMaximumMarks = obj.up('form').down('#subMaximumMarks');
 							subMaximumMarks.reset();
 							subMaximumMarks.setDisabled(true);
 							
 							var fieldContainer = obj.up('fieldcontainer');
                        	var symbolLevel = fieldContainer.down('#symbolLevelId');
                        	var percentage = fieldContainer.down('#percentageId');

                        	if (!isNullOrEmpty(symbolLevel)) {
                        		symbolLevel.reset();
                        		symbolLevel.setDisabled(true);
                        	}
                        	if (!isNullOrEmpty(percentage)) {
                        		percentage.reset();
                        		percentage.setDisabled(true);
                        	}
 							obj.up('form').getForm().checkValidity();
 							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SUBJECT_ALREADY_SELECTED_MSG'));
 							return false;
 						}
					}
                
            	},
            	afterrender: function(combo) {
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();
            		if(educationForm.findField("examBoard").getValue()==null){
            			var store = combo.getStore();
            			store.getProxy().extraParams = {
            				id: null,
            				examBoardOther:null
            			};
            		}
            	},
                    change: function(obj){
                    	var form = obj.up('form');
                    	var isVisible = null;
                    	if(!isNullOrEmpty(form.down('#isAssessmentLevelVisible'))) {
                    		isVisible = form.down('#isAssessmentLevelVisible').getValue();
                    	}
                    	var assessmentLevel =  obj.nextSibling().nextSibling().nextSibling();
                    	if(!isNullOrEmpty(isVisible) && isVisible=='true') {
                    		assessmentLevel.setDisabled(false);
                    	}
                    }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[name=conversionMaster]': {
                select: function(combo, records, eOpts) {
                	var comboId = combo.getValue();
                	var marks = combo.nextSibling();
                	this.findConfiguredMarksByGradeId(comboId, marks);
                	/*if(marks){
                		marks.setValue(false);
                	}*/
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[name=assessmentLevel]': {
                select: function(combo, records, eOpts) {
                	var comboId = combo.getValue();
                	var form = combo.up('educationform');
                	var examboard = form.down('#examBoard');
                	var examBoardId = examboard.getValue();
                	var conversationMaster = combo.nextSibling();
                	conversationMaster.setDisabled(false);
                	var marks = conversationMaster.nextSibling();
                	conversationMaster.reset();
                	if(marks) {
                		marks.reset();
                	}
                	var store = conversationMaster.getStore();
                	store.getProxy().extraParams = {
            			examBoardId:examBoardId,
            			assessmentLevel:comboId
            		};
            		store.load();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=isExistingStudent]': {
                change: function(combo, records, eOpts) {
                    this.showHideStudentEnrollmentField(combo, combo.getValue());
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveEducationHistory('#studentEducationHistoryGrid', SERVERURL.EDUCATION_HISTORY_ADD, SERVERURL.EDUCATION_HISTORY_UPDATE,'student');
            	}
            },
            
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] textfield[itemId=marks]': {
            	blur: function(textfield, eOpts) { 
       			 var num = textfield.getValue();
       			 if(!isNaN(num)&&!isEmpty(num)){	
	        			 var number=Math.round(num*100)/100;
	        			 textfield.setValue(number); 
       			 }
       		 }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=examBoard]': {
            	change: function(combo) {
            		var id = combo.getValue();
            		var examBoardOther = null;
            		var value = combo.getRawValue();
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();
            		var form =window.getForm();
            		var examBoardVisable= form.findField('examBoard').isVisible();
            		if(value == 'Others'){
            			examBoardOther = true ;
            		}else{
            			examBoardOther = false ; 
            		}
    		    	if(examBoardVisable){
    		    		var subjectMarkPanel = window.down('#subjectMarkPanel');
            			for(var i=subjectMarkPanel.items.length-1; i>0;i--){
            				subjectMarkPanel.remove(subjectMarkPanel.items.items[i]);
            			}
            			window.doLayout();
            			var subjectField =  form.findField("subject");
            			var store = subjectField.getStore();
            			if (window.items.items != null && window.items.items.length > 0) {
            				Ext.each(window.items.items, function(val) {
            					if(val.itemId =='subjectMarkPanel'){
            					var count = 0;
            						Ext.each(val.items.items, function(valueSubject){
            						if (count >0) {
            							valueSubject.removeAll();
									}else{
            							valueSubject.items.get('subject').reset();
            							valueSubject.items.get('marks').reset();
            							valueSubject.items.get('marks').isValid();
            							if (!isNullOrEmpty(valueSubject.items.get('maximumMarks'))) {
            							valueSubject.items.get('maximumMarks').reset();
            							}
            							if (!isNullOrEmpty(valueSubject.items.get('subMaximumMarks'))) {
                							valueSubject.items.get('subMaximumMarks').reset();
                						}
            							
            							if (!isNullOrEmpty(valueSubject.items.get('otherSubject'))) {
            								valueSubject.items.get('otherSubject').reset();
            								valueSubject.items.get('otherSubject').setVisible(false);
            							}
            							if (!isNullOrEmpty(valueSubject.items.get('assessmentLevel'))) {
            								valueSubject.items.get('assessmentLevel').reset();
            							}
            							if (!isNullOrEmpty(valueSubject.items.get('conversionMaster'))) {
	            							valueSubject.items.get('conversionMaster').reset();
	            							valueSubject.items.get('conversionMaster').clearValue();
										}
									}count++;
									});
            					}
            				});
            			}
            		store.getProxy().extraParams = {
            			id:id ,
            			examBoardOther:examBoardOther
            		};
            		store.load();
            		if(value == 'Others'){
            			var window = this.getPersonEducationForm();
            			var educationForm = this.getPersonEducationForm().getForm();	
            			var form =window.getForm();
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(false);
            			form.findField("examConductedBy").setVisible(true);
            		}
            		else{
            			var window = this.getPersonEducationForm();
            			var educationForm = this.getPersonEducationForm().getForm();	
            			var form =window.getForm();
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(true);
            			form.findField("examConductedBy").setVisible(false);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}
            	}
    		    	if (!isNullOrEmpty(id)) {
    		    		this.findExamBoradType(id, window, 'STUDENT');
					}
					var assessmentLevel =  form.findField("assessmentLevel");
    		    	assessmentLevel.reset();
            		var assessmentLevelStore = assessmentLevel.getStore();
            		assessmentLevelStore.getProxy().extraParams = {
            			examBoardId:id
            		};
            		assessmentLevelStore.load();
            		var conversionMaster =  form.findField("conversionMaster");
            		conversionMaster.reset();
            		var conversionMasterStore = conversionMaster.getStore();
            		conversionMasterStore.getProxy().extraParams = {
            			examBoardId:id
            		};
            		conversionMasterStore.load();
            	},
            	select: function(combo){
            		var value = combo.getRawValue();
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();	
            		var form =window.getForm();
            		if(value == 'Others'){
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(false);
            			form.findField("examConductedBy").setVisible(true);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}else{
            			var ExamConducted =  form.findField("examConductedBy").setDisabled(true);
            			form.findField("examConductedBy").setVisible(false);
            			var examConduct = form.findField("examConductedBy");
            			examConduct.reset();
            		}
            		var subjectMarkPanel = window.down('#subjectMarkPanel');
            		for(var i=subjectMarkPanel.items.length-1; i>0;i--){
            			subjectMarkPanel.remove(subjectMarkPanel.items.items[i]);
            		}
            		window.doLayout();
            		var subjectField =  form.findField("subject");
            		var store = subjectField.getStore();
            		if (window.items.items != null && window.items.items.length > 0) {
            			Ext.each(window.items.items, function(val) {
            				if(val.itemId =='subjectMarkPanel'){
            					Ext.each(val.items.items, function(valueSubject){
            						valueSubject.items.get('subject').reset();
            						valueSubject.items.get('marks').reset();
            						valueSubject.items.get('marks').isValid();
            						valueSubject.items.get('assessmentLevelItemId').reset();
            						valueSubject.items.get('markGradItemId').reset();
            					});
            				}
            			});
            		}
            	}
            },
        	/**
             *  Work Experience Details
             */
            'workexperiencegrid[itemId=studentWorkExperienceGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#studentWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_GRIDDATA,grid);
            		portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_WORK_EXPERIENCE_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_WORK_EXPERIENCE_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_WORK_EXPERIENCE_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_WORK_EXPERIENCE_PERMISSIONS());
            		}
            	}
            },
        	'workexperiencegrid[itemId=studentWorkExperienceGrid] button[itemId=btnAdd]': {
        		click: function() {
                    this.showPersonCommonWindow('WORK_EXPERIENCE', 'studentWorkExperienceForm');
                }
            },
            'workexperiencegrid[itemId=studentWorkExperienceGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editWorkExperienceFormWindow('WORK_EXPERIENCE', 'studentWorkExperienceForm', '#studentWorkExperienceGrid');
            	}
            },
            'workexperiencegrid[itemId=studentWorkExperienceGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewWorkExperienceFormWindow('WORK_EXPERIENCE', 'studentWorkExperienceForm', '#studentWorkExperienceGrid');
            	}
            },
            'workexperiencegrid[itemId=studentWorkExperienceGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteWorkExperienceRecord('#studentWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=studentWorkExperienceForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveWorkExperience('#studentWorkExperienceGrid', SERVERURL.WORK_EXPERIENCE_ADD, SERVERURL.WORK_EXPERIENCE_UPDATE);
            	}
            },
            
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=studentWorkExperienceForm] datefield[itemId=dateOfJoining]': {
            	 select: function(field, The, eOpts ){
                 	this.calculateExperience(field);
                 }
            },
            
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=studentWorkExperienceForm] datefield[itemId=exitDate]': {
           	 select: function(field, The, eOpts ){
                	this.calculateExperience(field);
                }
           },
            
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=studentWorkExperienceForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            
            'personcommonwindow[itemId=personCommonWindow] workexperienceform[itemId=studentWorkExperienceForm] radiogroup[itemId=currentOrgGroupId]': {
            	change: function(cb, nv, ov){

            		var form = this.getPersonWorkExperienceForm()
            		var datOfExit = form.down('#exitDate');
            		datOfExit.reset(); 
            		if(nv.whetherCurrentOrg){
            			datOfExit.setDisabled(true);
            		} else {
            			datOfExit.setDisabled(false);
            		}
            	}
           },
            
            /**
             *  Medical Details
             */

           'medicalgrid[itemId=studentMedicalGrid]': {
        	   render: function(grid) {
        		   this.loadGridStore('#studentMedicalGrid', SERVERURL.MEDICAL_HISTORY_GRIDDATA,grid);
        		   portalId = this.getCurrentLoggedPortalId();
        		   if(portalId == 7)
        		   {
        			   this.doAccessControlValidation(grid, this.getPARENT_MEDICAL_PERMISSIONS());
        		   }else if(portalId == 2){
        			   this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_MEDICAL_PERMISSIONS());
        		   }else if(portalId == 3){
        			   this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_MEDICAL_PERMISSIONS());
        		   }else{
        			   this.doAccessControlValidation(grid, this.getSTUDENT_MEDICAL_PERMISSIONS());
        		   }
        	   }
           },
            'medicalgrid[itemId=studentMedicalGrid] button[itemId=btnAdd]': {
                click: function() {
                    var formWindow = this.showPersonCommonWindow('MEDICAL', 'studentMedicalHistoryForm');
                    if( formWindow != null ){
            			var form = formWindow.down('#studentMedicalHistoryForm');
                		var countryCodeFieldItemIDArray = ["#doctorTelephoneCountryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#doctorTelephoneNoItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
                }
            },
            'medicalgrid[itemId=studentMedicalGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var form = this.editMedicalHistoryFormWindow('MEDICAL', 'studentMedicalHistoryForm', '#studentMedicalGrid');
            		if( form != null ){
                		var countryCodeFieldItemIDArray = ["#doctorTelephoneCountryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#doctorTelephoneNoItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
            	}
            },
            'medicalgrid[itemId=studentMedicalGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewMedicalHistoryFormWindow('MEDICAL', 'studentMedicalHistoryForm', '#studentMedicalGrid');
            	}
            },
            'medicalgrid[itemId=studentMedicalGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteMedicalHistoryRecord('#studentMedicalGrid', SERVERURL.MEDICAL_HISTORY_DELETE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=studentMedicalHistoryForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveMedicalHistory('#studentMedicalGrid', SERVERURL.MEDICAL_HISTORY_ADD, SERVERURL.MEDICAL_HISTORY_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=studentMedicalHistoryForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=studentMedicalHistoryForm] customcombobox[itemId=doctorTelephoneCountryCodeItemId]': {
                select: function(rowModel,record) {
                	var form = this.getPersonMedicalHistoryForm();
                	var countryCodeField = form.down("#doctorTelephoneCountryCodeItemId");
                	var mobileField = form.down("#doctorTelephoneNoItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] medicalhistoryform[itemId=studentMedicalHistoryForm] numberfield[itemId=doctorTelephoneNoItemId]': {
                change: function(record) {
                	var form = this.getPersonMedicalHistoryForm();
                	var mobileField = form.down("#doctorTelephoneNoItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            
            /**
             *  Vaccination Details
             */

            'vaccinationgrid[itemId= studentVaccinationGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#studentVaccinationGrid', SERVERURL.VACCINATION_INFO_GRIDDATA,grid);
            		portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_VACCINATION_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_VACCINATION_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_VACCINATION_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_VACCINATION_PERMISSIONS());
            		}
            	},
            	 afterrender : function(grid){
     				var me = this;
     				me.addDataGridConfigButton(grid,me.getSTUDENT_VACCINATION_PERMISSIONS());
     			}
            },
              
              'vaccinationgrid[itemId=studentVaccinationGrid] button[itemId=btnAdd]': {
              	click: function() {
                      this.showPersonCommonWindow('VACCINATION', 'studentVaccinationForm');
                      this.processVaccinationInfoDetailsWindow('btnAdd');
                  }
              },
              'vaccinationgrid[itemId=studentVaccinationGrid] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editVaccinationInfoFormWindow('VACCINATION', 'studentVaccinationForm', '#studentVaccinationGrid');
            		  this.processVaccinationInfoDetailsWindow('btnEdit');
            	  }
              },
              'vaccinationgrid[itemId=studentVaccinationGrid] button[itemId=btnView]': {
            	  click: function(){
            		  this.viewVaccinationInfoFormWindow('VACCINATION', 'studentVaccinationForm', '#studentVaccinationGrid');
            		  this.processVaccinationInfoDetailsWindow('btnView');
            		  var a = Ext.ComponentQuery.query("personcommonwindow");
            		  if( a != undefined & a.length > 0){
            			  a[0].down("#cancelButtonId").setVisible(false);
            			  a[0].down("#submitButtonId").setVisible(false);
            			  a[0].down("#uploadVaccinationItemId").setVisible(false);
            		  }
            		  var b = this.getVaccinationinfodocumentgrid();
            		  if(b != undefined){
            			b.down("#btnDelete").setVisible(false); 
            		  }
            	  }
              },
              'vaccinationgrid[itemId=studentVaccinationGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deleteVaccinationInfoRecord('#studentVaccinationGrid', SERVERURL.VACCINATION_INFO_DELETE);
            	  }
              },
              'vaccinationgrid[itemId=studentVaccinationGrid]':{   
    			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
    				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//    				   var documentId = record.data.document.id;
    				   if(columnName == "documents"){
             			   if(e.target.tagName=='A'){
             				  if(record.data.documents.length == 1){
       						   var csvForm = Ext.create('Ext.form.Panel'); 
       						   csvForm.getForm().submit({
       							   target: '_blank',
       							   method:'GET',
       							   params :{
       								   access_token : Ext.Ajax.defaultHeaders.access_token
       							   },
       							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
       							   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + record.data.documents["0"].id,
       							   standardSubmit :true
       						   });
             				  } else if(record.data.documents.length > 1){
             					  var docWindow = this.getVaccinationinfodocumentlist();
             					  var ID = record.data.id;
             					  if (!docWindow) {
             						  Ext.widget('vaccinationinfodocumentlist');
             						  docWindow = Ext.widget('vaccinationinfodocumentlist',{
             							  itemId:'disciplinaryReportDocument'
             						  });
             						  docWindow = this.getVaccinationinfodocumentlist();
             					  }
             					  docWindow.show();
            					  docWindow.down('form').down('#vaccinationNameItemId').setValue(record.data.name);
            					  docWindow.down('form').down('#vaccinationDateItemId').setValue(dateRender(record.data.vaccinationDate));
             					  var grid = docWindow.down('#vaccinationinfodocumentlistgridItemId');
             					  grid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
             					  var store = grid.getStore();
             					  store.getProxy().extraParams = {
             						  ID: record.data.id
             					  };
             					  store.load();
             				  }
             			   }
    				   }
    			   }
    		   },
    		   'vaccinationinfodocumentlistgrid':{
   	 			 
   				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
      				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
      				 if(columnName == "documentName"){
      					 if(e.target.tagName=='A'){
      						 this.getDownloadFile(record.get('documentId'));
      					 }
      				 }
      			 }
      		 },
    		'vaccinationinfodocumentgrid button#btnDelete' : {
    			click : function() {
    				var $this = this;
    				var grid = $this.getVaccinationinfodocumentgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					showConfirmMessage(getCommonTranslation('VACCINATION_INFO'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text) {
    								if (btn == 'yes') {
    									var store = grid.getStore();
    									var record = grid.getSelectionModel().getSelection()[0];
    									var id = record.get("id");
										if (record) {
	                 							store.remove(record);
	                 						showSuccessMessage(getCommonTranslation('VACCINATION_INFO'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	                 					}
    									
    								}
    							});
    				} else {
    					showWarningMessage(
    							getCommonTranslation('VACCINATION_INFO'),
    							getCommonTranslation('PLEASE_SELECT_RECORD')); 
    				}
    			}
    		},
      		'vaccinationinfodocumentlistgrid button[itemId=downloadDocumentItemId]':{
  				click:function(obj){
  					this.documentReportDocumentZip('student');
  				}
        	 },
        	 'vaccinationinfodocumentlistgrid button[itemId=btnDelete]':{
   				click:function(obj){
   					this.deleteVaccinationDocument('student');
   				}
         	 },
         	
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=studentVaccinationForm] button[itemId=submitButtonId]': {
            	  click: function(){
            		  this.saveVaccinationInfo('#studentVaccinationGrid', SERVERURL.VACCINATION_INFO_ADD, SERVERURL.VACCINATION_INFO_UPDATE,'STUDENT');
            	  }
              },
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=studentVaccinationForm] button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              },  
              'personcommonwindow[itemId=personCommonWindow] vaccinationform[itemId=studentVaccinationForm] button[itemId=uploadVaccinationItemId]' : {
      			click: function() {
      				this
      				.getDocumentController()
      				.showDocumentFormWindow(
      						'student_vaccination_hidden_field',
      						'DOCUMENT');
      			}
          	   },
          	 'studentlanguageinformationgrid[itemId=studentLanguagesInformationGridItemId] button[itemId=btnAdd]': {
             	click: function() {
             		//this.isAdd=true;
            		this.studentLanguageMode = 'ADD';
                     this.showPersonCommonWindow('STUDENT_LANGUAGE','studentlanguageformId');
                 }},
                 
                 'studentlanguageinformationgrid[itemId=studentLanguagesInformationGridItemId] button[itemId=btnView]': {
	                  click: function(){
	                	  this.studentLanguageMode = '';
	                	  this.viewStudentLanguageDetailFormWindow('STUDENT_LANGUAGE', 'studentlanguageformId', '#studentLanguagesInformationGridItemId');
	                	  this.studentLanguageDocWindow();
	                	  this.studentLanguageUrlContainerWindow();
	                  }
	              },
                 
                 'studentlanguageinformationgrid[itemId=studentLanguagesInformationGridItemId] button[itemId=btnDelete]': {
	                  click: function(){
	                	  this.deleteStudentLanguageDetailRecord('#studentLanguagesInformationGridItemId', SERVERURL.PATH_STUDENT_LANGUAGE_DELETE);
	                  }
	              },
   	 		
                 'studentlanguageinformationgrid[itemId=studentLanguagesInformationGridItemId] button[itemId=btnEdit]': {
                  	click: function() {
                  		this.isAdd=false;
                		this.studentLanguageMode='EDIT';
                		this.editStudentLanguageWindow('STUDENT_LANGUAGE', 'studentlanguageformId', '#studentLanguagesInformationGridItemId', false);
                		this.studentLanguageDocWindow();
                		this.studentLanguageUrlContainerWindow();
                      }},
                 'studentlanguagedetailform[itemId=studentlanguageformId] button#languageUploadFileItemId': {
                 	click : function() {
     	 				this.getDocumentController().showDocumentFormWindow('language_detail_hidden_field','DOCUMENT');
     	 				setTimeout(function(){
     			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
      			            form.down('#documentNameField').allowBlank=true;
      			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENT_DETAILS'));
                 		},100); 
     	 			}
                 },
                 
                 'studentlanguagedetailform[itemId=studentlanguageformId] button#languageURLItemId': {
                 	click : function() {
     	 				this.getDocumentController().showDocumentFormWindow('language_detail_hidden_field','DOCUMENT_URL');
     	 				var formWindow = this.getDocumentformwindow();
      					if (!formWindow) {
      						Ext.widget('documentformwindow');
      						formWindow = this.getDocumentformwindow();
      					}
      					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
     	 			}
                 },
                 'documentformwindow[itemId=language_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
     	 	    	click : function() {
     	 			var $this = this;
     	 			var isTransient = true;
     	 			var module = 'studentLanguage';
     	 			var entityId;
     	 			var entityType = 'studentLanguageDocument';
     	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
     	 					function(success,response,isCallBackTransient) {
     	 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
     	 						var documentModel = new Academia.model.personinfo.common.pasthistory.StudentLanguageDocumentModel();
     	 						documentModel.set("name",response.name);
     	 						documentModel.set("path",response.path);
     	 						documentModel.set("type",response.type);
     	 						documentModel.set("documentName",response.name);
     	 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
     	 						if(documentModel.data.path.length > 255){
     	                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
     	                          }else {
     			 						var StudentLanguageDocGrid = $this.getStudentlanguagedocumentgrid();
     			 						var store = StudentLanguageDocGrid.getStore();
     			 						store.add(documentModel);
     			 						if (StudentLanguageDocGrid.isHidden() && store.data.items.length > 0) {
     			 							StudentLanguageDocGrid.setVisible(true);
     			 						}
     			 						$this.getDocumentController().closeDocumentFormWindow();
     			 						showSuccessMessage(getCommonTranslation('STUDENT_LANGUAGE'),getCommonTranslation('LANGUAGE_DOCUMENT_ADD_SUCCESSFULLY'));
     	                          }
     	 					}, isTransient);
     		 		}
     		 	},
     		 	
     		 	'documentformwindow[itemId=language_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
     		 		click : function() {
     		 			this.getDocumentController()
     		 			.closeDocumentFormWindow();
     		 		}
     		 	},
     		 	'documentformwindow[itemId=language_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
    	 	    	click : function() {
    	 			var $this = this;
    	 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
    	            form.down('#documentFormSubmitButtonId').setDisabled(true);
    	 				fields : ['id','documentId','documentName','path','createdBy']
    	 						var documentModelUrl = new Academia.model.personinfo.common.pasthistory.StudentLanguageUrlModel();
    				            var form = Ext.ComponentQuery.query('simpleurlform')[0];

    	 			            var documentName=form.down('#documentNameField').getValue();
    	 			            var UrlName=form.down('#documentUrlField').getValue();
    	 			            documentModelUrl.set("documentName",documentName);
    	 			            documentModelUrl.set("path",UrlName);
    	 			            
    	 			           documentModelUrl.set("type",'DOCUMENT');
    	 			           var userId = this.getCurrentlyLoggedInUser()
    	 			           documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
    	 			           
                        	  var StudentLanguageUrlGrid = Ext.ComponentQuery.query('studentlanguageurlgrid')[0];
                        	  var store2= StudentLanguageUrlGrid.getStore();
                        	  store2.add(documentModelUrl);
                        	  if (StudentLanguageUrlGrid.isHidden() && store2.data.items.length > 0) {
                        		  StudentLanguageUrlGrid.setVisible(true);
                        	  }
                        	  $this.getDocumentController().closeDocumentFormWindow();
                        	  showSuccessMessage(getCommonTranslation('STUDENT_LANGUAGE'),getCommonTranslation('LANGUAGE_URL_ADD_SUCCESSFULLY'));
    	 						
    	 		}
    	 	},
                
    		 	'documentformwindow[itemId=language_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
    		 		click : function() {
    		 			this.getDocumentController()
    		 			.closeDocumentFormWindow();
    		 		}
    		 	},
    		 	
    		 	'studentlanguagedetailform[itemId=studentlanguageformId] button#submitButtonId' : {
    	 			click : function() {
    	               this.saveStudentLanguageDetail('#studentLanguagesInformationGridItemId', SERVERURL.PATH_STUDENT_LANGUAGE_SAVE, SERVERURL.PATH_STUDENT_LANGUAGE_UPDATE);

    	 			}
    	 		},
    	 		 
    	 		'studentlanguagedetailform[itemId=studentlanguageformId] button#cancelButtonId' : {
    	 			click: this.closePersonCommonWindow
     			},
         		'documentformwindow[itemId=student_vaccination_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
        			click : function() {
        				var $this = this;
        				var isTransient = true;
        				var module = 'vaccinationInfo';
        				var entityId;
        				var entityType = 'vaccinationInfoDocument';
        				$this
        				.getDocumentController()
        				.saveDocumentForm(
        						entityId,
        						module,
        						entityType,
        						'DOCUMENT',
        						function(success,
        								response,
        								isCallBackTransient) {
        							var documentModel = new Academia.model.personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentModel();        							        							
        							documentModel
        							.set(
        									"documentName",
        									response.name);
        							documentModel
        							.set(
        									"path",
        									response.path);
        							documentModel
        							.set(
        									"type",
        									response.type);
        							documentModel
        							.set(
        									"documentName",
        									response.name);
        							documentModel
        							.set(
        									"createdBy",
        									$this
        									.getIdValueJson(
        											response.createdBy.id,
        											response.createdBy.value));
        							var vaccinationInfoDocGrid = $this.getVaccinationinfodocumentgrid();
        							var store = vaccinationInfoDocGrid
        							.getStore();
        							store
        							.add(documentModel);
        							if (vaccinationInfoDocGrid
        									.isHidden()
        									&& store.data.items.length > 0) {
        								vaccinationInfoDocGrid
        								.setVisible(true);
        							}
        							$this
        							.getDocumentController()
        							.closeDocumentFormWindow();
      							   showSuccessMessage(getCommonTranslation('VACCINATION_INFO'),getCommonTranslation('VACCINATION_INFO_DOCUMENT_ADD_SUCCESSFULLY'));
          					
        						}, isTransient);
        			}
        		},
        		'studentlanguagedocumentgrid button#btnDelete' : {
   	 			 click : function() {
   	 				 var $this = this;
   					 var grid = Ext.ComponentQuery.query('studentlanguagedocumentgrid')[0];
   	 				 if (grid.getSelectionModel().getCount() > 0) {
   	 					 Ext.MessageBox
   	 					 .confirm(
   	 							getCommonTranslation('LANGUAGE_DOCUMENT'),
   	 							 getCommonTranslation('STUDENT_LANGUAGE_DELETE_CONFIRM_MESSAGE'),
   	 							function(btn, text) {
   	 								 if (btn == 'yes') {
   	 									 var store = grid.getStore();
   	 									 var record = grid.getSelectionModel().getSelection()[0];
   	 									 var id = record.id;
   	 									 if (isNullOrEmpty(id)) {
   	 									 }else{
   	 										 if (record) {
   	 											 store.remove(record);
   	 											 showSuccessMessage(
   	 											 getCommonTranslation('LANGUAGE_DOCUMENT'),
   												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
   	 											 if(store.data.items.length == 0) {
   	 												grid.setVisible(false);
   	 					 						}
   	 										 }
   	 									 }
   	 								 }
   	 							 });
   	 				 } else {
   	 					 showWarningMessage(
   	 							getCommonTranslation('LANGUAGE_DOCUMENT'),
   	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
   	 				 }
   	 			 }
   	 		 },
   			'studentlanguageurlgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
					 var grid = Ext.ComponentQuery.query('studentlanguageurlgrid')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							getCommonTranslation('LANGUAGE_URL'),
	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 											 getCommonTranslation('LANGUAGE_URL'),
												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 											 if(store.data.items.length == 0) {
	 												grid.setVisible(false);
	 					 						}
	 										 }
	 									 }
	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							getCommonTranslation('LANGUAGE_URL'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
        		'studentlanguagedocumentgrid' : {
   				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
   					 var $this = this;
   					 var documentGrid = $this.getStudentlanguagedocumentgrid();
   					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
   					 if (columnName == "documentName") {
   						 if (e.target.tagName == 'A') {
   							 var documentId = record.get("documentId");
   							 if (!isNullOrEmpty(documentId)) {
   								 $this.getDocumentController().downloadDocumentFile(documentId);
   							 }
   						 }

   					 }
   				 }
   			 },
        		'documentformwindow[itemId=student_vaccination_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
        			click : function() {
        				this.getDocumentController()
        				.closeDocumentFormWindow();
        			}
        		},
              
              /**
               *  Physical Characteristics Details
               */
              'physicalcharacteristicsgrid[itemId=studentPhysicalCharacteristicsGrid]': {
            	  render: function(grid) {
            		  this.loadGridStore('#studentPhysicalCharacteristicsGrid', SERVERURL.PHYSICAL_CHARACTERISTICS_GRID,grid);
            		  portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 7)
            		  {
            			  this.doAccessControlValidation(grid, this.getPARENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
            		  }else if(portalId == 2){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
            		  }else if(portalId == 3){
            			  this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
            		  }else{
            			  this.doAccessControlValidation(grid, this.getSTUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS());
            		  }
            	  }
              },
              'physicalcharacteristicsgrid[itemId=studentPhysicalCharacteristicsGrid] button[itemId=btnAdd]': {
            	  click: function() {
                      this.showPersonCommonWindow('PHYSICAL_CHARACTERISTICS', 'studentPhysicalCharacteristicsGrid');
                  }
              },
              'physicalcharacteristicsgrid[itemId=studentPhysicalCharacteristicsGrid] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editPhysicalCharFormWindow('PHYSICAL_CHARACTERISTICS', 'studentPhysicalCharacteristicsGrid', '#studentPhysicalCharacteristicsGrid');
            	  }
              },
              'physicalcharacteristicsgrid[itemId=studentPhysicalCharacteristicsGrid] button[itemId=btnView]': {
            	  click: function(){
            		  this.viewPhysicalCharFormWindow('PHYSICAL_CHARACTERISTICS', 'physicalcharacteristicsform', '#studentPhysicalCharacteristicsGrid');
            	  }
              },
              'physicalcharacteristicsgrid[itemId=studentPhysicalCharacteristicsGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deletePhysicalCharRecord('#studentPhysicalCharacteristicsGrid', SERVERURL.PHYSICAL_CHARACTERISTICS_INFO_DELETE);
            	  }
              },
              
              'physicalcharacteristicsform button[itemId=submitButtonId]': {
            	  click: function(){
            		  this.savePhysicalCharInfo('#studentPhysicalCharacteristicsGrid', SERVERURL.PHYSICAL_CHARACTERISTICS_INFO_ADD, SERVERURL.PHYSICAL_CHARACTERISTICS_INFO_UPDATE);
            	  }
              },
              ' physicalcharacteristicsform button[itemId=cancelButtonId]': {
                	click: this.closePersonCommonWindow
                },
              
              /**
               *  Extra Curricular Details
               */

                'extracurriculargrid[itemId=studentExtraCurricularGrid]': {
                	render: function(grid) {
                		this.loadGridStore('#studentExtraCurricularGrid', SERVERURL.EXTRA_CURRICULAR_GRIDDATA,grid);
                		portalId = this.getCurrentLoggedPortalId();
                		if(portalId == 7)
                		{
                			this.doAccessControlValidation(grid, this.getPARENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                		}else if(portalId == 2){
                			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                		}else if(portalId == 3){
                			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                			this.doAccessControlValidationOfExtraAddStudent(grid, this.getSTUDENT_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                		}else{
                			this.doAccessControlValidation(grid, this.getSTUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                			this.doAccessControlValidationOfExtraAddStudent(grid, this.getSTUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
                		}
                	},
                	select:function(rowModel, record, index, eOpts ){
                		var me=this;
                		var personProfile = me.getContentPanelActiveTab();
                		var grid=personProfile.down('#studentExtraCurricularGrid');
                		if(!isEmpty(record)){                		            	        
                			var otherEvent = record.get('otherEvent');
                			var editButton = grid.down('#btnEdit');
                			if(!isNullOrEmpty(otherEvent)){
                				editButton.setDisabled(false);
                			} else {
                				editButton.setDisabled(true);
                			}
                		}                	
                	}
                },
              'extracurriculargrid[itemId=studentExtraCurricularGrid] button[itemId=btnAdd]': {
            	  click: function() {
                      this.showPersonCommonWindow('EXTRA_CURRICULAR', 'studentExtraCurricularForm');
                      this.extraCurricularActivityFormRender();
                  }
              },
              'extracurriculargrid[itemId=studentExtraCurricularGrid] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editExtraCurricularFormWindow('EXTRA_CURRICULAR', 'studentExtraCurricularForm', '#studentExtraCurricularGrid');
            	  }
              },
              'extracurriculargrid[itemId=studentExtraCurricularGrid] button[itemId=btnView]': {
            	  click: function(){
            		  this.viewExtraCurricularFormWindow('EXTRA_CURRICULAR', 'studentExtraCurricularForm', '#studentExtraCurricularGrid');
            	  }
              },
              'extracurriculargrid[itemId=studentExtraCurricularGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deleteExtraCurricularRecord('#studentExtraCurricularGrid', SERVERURL.EXTRA_CURRICULAR_DELETE);
            	  }
              },
              'extracurriculargrid[itemId=studentExtraCurricularGrid] button[itemId=stdExtraCurrAddStudentsBtn]': {
					click: function(me, e, eOpts){
						this.showExtraCurrAddStudentsWindow(me, e, eOpts);
					}
			  },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=studentExtraCurricularForm] button[itemId=submitButtonId]': {
            	  click: function(){
            		  this.saveExtraCurricular('#studentExtraCurricularGrid', SERVERURL.EXTRA_CURRICULAR_ADD, SERVERURL.EXTRA_CURRICULAR_UPDATE);
            	  }              },
              'personcommonwindow[itemId=personCommonWindow] extracurricularform[itemId=studentExtraCurricularForm] button[itemId=cancelButtonId]': {
            	  click: this.closePersonCommonWindow
              },
              
              /**
               *  Research Details 
               * 
               */
              'researchtypegrid[itemId=studentResearchTypeGrid]': {
            	  render: function(grid) {
            		  this.loadGridStore('#studentResearchTypeGrid', SERVERURL.FIND_ALL_PERSON_RESEARCH,grid);
            		  portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 7)
            		  {
            			  this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS());
            		  }else if(portalId == 2){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS());
            		  }else if(portalId == 3){
            			  this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_RESEARCH_DETAILS_PERMISSIONS());
            		  }else{
            			  this.doAccessControlValidation(grid, this.getSTUDENT_RESEARCH_DETAILS_PERMISSIONS());
            		  }
            	  },
                  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

                	  var searchResultGrid =  grid.ownerCt;
                	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

                	  if(columnName=='noOfdocument'){
                		  if (e.target.tagName == 'A') {
                			  this.showPersonCommonWindow('RESEARCH_VIEW_DOCUMENT', 'studentResearchDocumentViewForm');
                			  var form = this.getPersonResearchDocumentViewForm();
                			  var grid = form.down('#researchdocumentviewId');
                			  this.loadDocumnetGrid(record,grid);
                		  }
                	  }
                  }
              },
              /**
               * On Change of whetherUCSubmitted radio button  
               */
              'researchtypeform[itemId=studentResearchTypeForm] radiogroup[itemId=whetherUCSubmittedId]':{
            	change:function(obj,rec){
            		this.onChangeIsucsubmmited(obj,rec);
            	}  
              },
                
              /**
               * Save of Research Type 
               */
              'researchtypeform[itemId=studentResearchTypeForm] button[itemId=submitButtonId]':{
            	  click:function(){
            		  var personProfile = this.getContentPanelActiveTab();
            		  var grid = personProfile.down('#studentResearchTypeGrid');
            		  var form = this.getPersonResearchTypeForm();
            		  this.saveResearchTypeDetails(grid,form,SERVERURL.CREATE_PERSON_RESEARCH,SERVERURL.UPDATE_PERSON_RESEARCH);
            	  }  
                },
                
                /**
                 * Reset of Research Type 
                 */
                'researchtypeform[itemId=studentResearchTypeForm] button[itemId=cancelResetId]':{
              	  click:function(){              		  
              		  var form = this.getPersonResearchTypeForm().getForm();
              		  form.reset();
              	  }  
                },                
                
                /**
                 * Document Upload of Research Type 
                 */
                'researchtypeform[itemId=studentResearchTypeForm] button[itemId=uploadDocItemId]':{
          			click : function() {
        				this.getDocumentController().showDocumentFormWindow('studentResearchTypeForm','DOCUMENT');
        			}
                  },
                  'documentformwindow[itemId=studentResearchTypeForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
                	  click : function() {
                		  var form = this.getPersonResearchTypeForm();
                		  var docGrid = form.down('#researchTypeDocument');
                		  var module = 'studentResearchType';
                		  var entityType = 'studentResearchType';
                		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
                	  }
          		},
          		/**
          		 * Document Download at update time
          		 */
          		 'researchtypeform[itemId=studentResearchTypeForm] researchtypedocument': {
        			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				 var $this = this;
        				 var documentGrid =  grid.ownerCt;
        				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				 if (columnName == "documentName") {
        					 if (e.target.tagName == 'A') {
        						 var documentId = record.get("documentId");
        						 if (!isNullOrEmpty(documentId)) {
        							 $this.getDocumentController().downloadDocumentFile(documentId);
        						 }
        					 }
        				 }
        			 }
        		 },
        		 /**
           		 * Document Download on click of document count on grid
           		 */
        		 'researchdocumentviewform[itemId=studentResearchDocumentViewForm] researchtypedocument': {
        			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				 var $this = this;
        				 var documentGrid =  grid.ownerCt;
        				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				 if (columnName == "documentName") {
        					 if (e.target.tagName == 'A') {
        						 var documentId = record.get("documentId");
        						 if (!isNullOrEmpty(documentId)) {
        							 $this.getDocumentController().downloadDocumentFile(documentId);
        						 }
        					 }
        				 }
        			 }
        		 },
          		 /**
                 * Document delete of Research Type 
                 */
          		'researchtypeform[itemId=studentResearchTypeForm] researchtypedocument button#btnDelete' : {
          			click:function(obj){
          				this.deleteDocument(obj,SERVERURL.RESEARCH_TYPE_DOC_DELETE,'#studentResearchTypeGrid');
          			}
          		},
        		/**
        		 *  Open Create Research Tab
        		 */
              'researchtypegrid[itemId=studentResearchTypeGrid] button[itemId=btnAdd]': {
            	  click: function() {
            		    personType='STUDENT';
            		    tabPanelTitle= 'RESEARCH_TYPE';
            	    	tabPanelItemId= 'studentResearchTypeFormDetails';
            	    	tabPanelItemXtype = 'researchtypeform';
            	    	xtypeItemId = 'studentResearchTypeForm';
            	    	//render = true,
            	    	defaultPanel= true;
            	    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
            	    		var contentpanel = this.getContentPanel();
            	    		var researchtypeformtab = Ext.widget('researchtypeform',{
            	    			itemId:'researchtypeformstudentportal'
            	    		});
            	    		var tabName = getPersonModuleTranslation('RESEARCH_TYPE_PORTAL');
            	    		openTab(contentpanel, tabName, researchtypeformtab,CONSTANTS.MENU_COLOR_THREE);            	    		
            	    	}else{
            	    		this.showResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
            	    	}
                  }
              },
              /**
      		 	*  Open Edit Research Tab
      		 	*/
              'researchtypegrid[itemId=studentResearchTypeGrid] button[itemId=btnEdit]': {
            	  click: function() {
            		    personType='STUDENT',
            		    tabPanelTitle= 'RESEARCH_TYPE';
            	    	tabPanelItemId= 'studentResearchTypeFormDetails';
            	    	tabPanelItemXtype = 'researchtypeform',
            	    	xtypeItemId = 'studentResearchTypeForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	gridItemId ='#studentResearchTypeGrid';
            	    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
          	    		  var contentpanel = this.getContentPanel();
        	    		  var grid = contentpanel.down('#studentResearchTypeGrid');
        	    		  this.editResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
        	    	}else{
        	    		var personProfile = this.getContentPanelActiveTab();
        	            var grid = personProfile.down(gridItemId);
        	    		this.editResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
        	    	}
            	  }
              },

              /**
               *  Open View Research Tab
               */
              'researchtypegrid[itemId=studentResearchTypeGrid] button[itemId=btnView]': {
            	  click: function() {
            		    personType='STUDENT',
            		    tabPanelTitle= 'RESEARCH_TYPE';
            	    	tabPanelItemId= 'studentResearchTypeFormDetails';
            	    	tabPanelItemXtype = 'researchtypeform',
            	    	xtypeItemId = 'studentResearchTypeForm',
            	    	//render = true,
            	    	defaultPanel= true;
            	    	gridItemId ='#studentResearchTypeGrid';
            	    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
            	    		  var contentpanel = this.getContentPanel();
            	    		  var grid = contentpanel.down('#studentResearchTypeGrid');
            	    		  this.viewResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
            	    	}else{
              	    		var personProfile = this.getContentPanelActiveTab();
              	            var grid = personProfile.down(gridItemId);
              	    		this.viewResearchDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid);
              	    	}
                  }
              },
              /**
               *  Delete Research Type
               */
              'researchtypegrid[itemId=studentResearchTypeGrid] button[itemId=btnDelete]': {
            	  click: function(){
            		  this.deleteResearchDetails('#studentResearchTypeGrid', SERVERURL.DELETE_PERSON_RESEARCH);
            	  }
              },
              
              
              /**
               * researchtypeformstudentportal
               * Save for student portalResearch Type 
               */
              'researchtypeform[itemId=researchtypeformstudentportal] button[itemId=submitButtonId]':{
            	  click:function(){
            		  var contentpanel = this.getContentPanel();
            		  var grid = contentpanel.down('#studentResearchTypeGrid');
            		  var form = this.getPersonResearchTypeFormStudentPortal();
            		  this.saveResearchTypeDetails(grid,form,SERVERURL.CREATE_PERSON_RESEARCH,SERVERURL.UPDATE_PERSON_RESEARCH);
            	  }  
                },
                'researchtypeform[itemId=researchtypeformstudentportal] radiogroup[itemId=whetherUCSubmittedId]':{
                	change:function(obj,rec){
                		this.onChangeIsucsubmmited(obj,rec);
                	}  
                },
              
                /**
                 * Document Upload of Research Type 
                 */
                'researchtypeform[itemId=researchtypeformstudentportal] button[itemId=uploadDocItemId]':{
          			click : function() {
        				this.getDocumentController().showDocumentFormWindow('researchtypeformstudentportal','DOCUMENT');
        			}
                  },
                  'documentformwindow[itemId=researchtypeformstudentportal] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
                	  click : function() {
//                		  var form = this.getPersonResearchTypeForm();
                		  var form = this.getPersonResearchTypeFormStudentPortal();
                		  var docGrid = form.down('#researchTypeDocument');
                		  var module = 'studentResearchType';
                		  var entityType = 'studentResearchType';
                		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
                	  }
          		},
          		 'researchtypeform[itemId=researchtypeformstudentportal] researchtypedocument': {
        			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
        				 var $this = this;
        				 var documentGrid =  grid.ownerCt;
        				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        				 if (columnName == "documentName") {
        					 if (e.target.tagName == 'A') {
        						 var documentId = record.get("documentId");
        						 if (!isNullOrEmpty(documentId)) {
        							 $this.getDocumentController().downloadDocumentFile(documentId);
        						 }
        					 }
        				 }
        			 }
        		 },
          		 /**
                 * Document delete of Research Type 
                 */
          		'researchtypeform[itemId=researchtypeformstudentportal] researchtypedocument button#btnDelete' : {
          			click:function(obj){
          				this.deleteDocument(obj,SERVERURL.RESEARCH_TYPE_DOC_DELETE,'#studentResearchTypeGrid');
          			}
          		},
              
              
              /**
               *  Seminar Type
               *  
               */
              'seminardetailsgrid[itemId=studentSeminarDetailsGrid]': {
                  render: function(grid) {
                      this.loadGridStore('#studentSeminarDetailsGrid', SERVERURL.FIND_ALL_PERSON_SEMINAR,grid);
                      portalId = this.getCurrentLoggedPortalId();
            		  if(portalId == 7)
            		  {
            			  this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS());
            		  }else if(portalId == 2){
            			  this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS());
            		  }else if(portalId == 3){
            			  this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_SEMINAR_DETAILS_PERMISSIONS());
            		  }else{
            			  this.doAccessControlValidation(grid, this.getSTUDENT_SEMINAR_DETAILS_PERMISSIONS());
            		  }                      
                  },
                  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

                	  var searchResultGrid =  grid.ownerCt;
                	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

                	  if(columnName=='noOfdocument'){
                		  if (e.target.tagName == 'A') {
                			  this.showPersonCommonWindow('SEMINAR_VIEW_DOCUMENT', 'studentSeminarDocumentViewForm');
                			  var form = this.getPersonSeminarDocumentViewForm();
                			  var grid = form.down('#seminardocumentviewId');
                			  this.loadDocumnetGrid(record,grid);
                		  }
                	  }
                  }
              },
               'seminardetailsgrid[itemId=studentSeminarDetailsGrid] button[itemId=btnAdd]': {
             	  click: function() {
                       this.showPersonCommonWindow('SEMINAR_TYPE', 'studentSeminarDetailsForm');
                   }
               },
               'seminardetailsgrid[itemId=studentSeminarDetailsGrid] button[itemId=btnEdit]': {
              	  click: function() {
                        this.editSeminarType('SEMINAR_TYPE', 'studentSeminarDetailsForm', '#studentSeminarDetailsGrid');
                    }
                },
                'seminardetailsgrid[itemId=studentSeminarDetailsGrid] button[itemId=btnView]': {
              	  click: function(){
              		  this.viewSeminarType('SEMINAR_TYPE', 'studentSeminarDetailsForm', '#studentSeminarDetailsGrid');
              	  }
                },
                'seminardetailsgrid[itemId=studentSeminarDetailsGrid] button[itemId=btnDelete]': {
              	  click: function(){
              		  this.deleteSeminarType('#studentSeminarDetailsGrid', SERVERURL.SEMINAR_DELETE);
              	  }
                },
               'personcommonwindow[itemId=personCommonWindow] seminardetailsform[itemId=studentSeminarDetailsForm] button[itemId=submitButtonId]': {
            	   click: function(){
            		   var form = this.getPersonSeminarDetailsForm();
            		   var docGrid = form.down('#seminarTypeDocument');
            		   this.saveSeminarType('#studentSeminarDetailsGrid', SERVERURL.SEMINAR_CREATE, SERVERURL.SEMINAR_UPDATE,docGrid);
            	   }
               },  
               'personcommonwindow[itemId=personCommonWindow] seminardetailsform[itemId=studentSeminarDetailsForm] button[itemId=cancelButtonId]': {
             	  click: this.closePersonCommonWindow
               },
               'seminardetailsform[itemId=studentSeminarDetailsForm] button[itemId=uploadDocItemId]':{
            	   click : function() {
            		   this.getDocumentController().showDocumentFormWindow('studentSeminarDetailsForm','DOCUMENT');
            	   }
               },
               'seminardetailsform[itemId=studentSeminarDetailsForm] datefield[itemId=fromDate]':{
            	   select : function() {
            		   this.DayCountbetweenDate();
            	   }
               },
               'seminardetailsform[itemId=studentSeminarDetailsForm] datefield[itemId=toDate]':{
            	   select : function() {
            		   this.DayCountbetweenDate();
            	   }
               },
               'documentformwindow[itemId=studentSeminarDetailsForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
             	  click : function() {
             		  var form = this.getPersonSeminarDetailsForm();
             		  var docGrid = form.down('#seminarTypeDocument');
             		  var module = 'studentSeminarType';
             		  var entityType = 'studentSeminarType';
             		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
             	  }
       		},
       		'seminardetailsform[itemId=studentSeminarDetailsForm] seminartypedocument button#btnDelete' : {
       			click:function(obj){
       				this.deleteDocument(obj,SERVERURL.SEMINAR_TYPE_DOC_DELETE,'#studentSeminarDetailsGrid');
       			}
       		},
       		'seminardetailsform[itemId=studentSeminarDetailsForm] seminartypedocument': {
       			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
       				var $this = this;
       				var documentGrid =  grid.ownerCt;
       				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

       				if (columnName == "documentName") {
       					if (e.target.tagName == 'A') {
       						var documentId = record.get("documentId");
       						if (!isNullOrEmpty(documentId)) {
       							$this.getDocumentController().downloadDocumentFile(documentId);
       						}
       					}
       				}
       			}
       		},
       		
       		/**
       		 * Document Download on click of document count on grid
       		 */
    		 'seminardocumentviewform[itemId=studentSeminarDocumentViewForm] seminartypedocument': {
    			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
    				 var $this = this;
    				 var documentGrid =  grid.ownerCt;
    				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

    				 if (columnName == "documentName") {
    					 if (e.target.tagName == 'A') {
    						 var documentId = record.get("documentId");
    						 if (!isNullOrEmpty(documentId)) {
    							 $this.getDocumentController().downloadDocumentFile(documentId);
    						 }
    					 }
    				 }
    			 }
    		 },
    		 
            /**
             *  Patent Details
             *  
             */
            'patentdetailsgrid[itemId=studentPatentDetailsGrid] ': {
            	render: function(grid) {
            		this.loadGridStore('#studentPatentDetailsGrid', SERVERURL.PERSON_PATENT_GRID,grid);
            		portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_PATENT_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PATENT_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PATENT_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_PATENT_DETAILS_PERMISSIONS());
            		} 
            	},
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

              	  var searchResultGrid =  grid.ownerCt;
              	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

              	  if(columnName=='noOfdocument'){
              		  if (e.target.tagName == 'A') {
              			  this.showPersonCommonWindow('PATENT_VIEW_DOCUMENT', 'studentPatentDocumentViewForm');
              			  var form = this.getPersonPatentDocumentViewForm();
              			  var grid = form.down('#patentdocumentviewId');
              			  this.loadDocumnetGrid(record,grid);
              		  }
              	  }

              	  if(columnName=='supervisorId'){
              		  if (e.target.tagName == 'A') {
              			this.loadSupervisorGrid(record,grid);
                	}
              	  }
                },
                afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getSTUDENT_PATENT_DETAILS_PERMISSIONS());
    			}
            }, 
            'patentdetailsgrid[itemId=studentPatentDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		this.showPersonCommonWindow('PATENT_TYPE', 'studentPatentDetailsForm');
            		var formWindow = this.getPersonCommonWindow();
            		var studentPatentDetailsForm = formWindow.down('patentdetailsform');
            		var patentTypeSMId = studentPatentDetailsForm.down('#patentTypeSMId');
            		var personId= this.getPersonObj().id;
            		patentTypeSMId.getStore().getProxy().extraParams = {
            			patentTypeId: 0,
            			personId:personId
            		};
            		patentTypeSMId.getStore().load();
            	
            	}
            },
            'patentdetailsgrid[itemId=studentPatentDetailsGrid] button[itemId=btnEdit]': {
            	click: function() {
            		this.editPatentType('PATENT_TYPE', 'studentPatentDetailsForm', '#studentPatentDetailsGrid');
            	}
            },
            'patentdetailsgrid[itemId=studentPatentDetailsGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewPatentType('PATENT_TYPE', 'studentPatentDetailsForm', '#studentPatentDetailsGrid');
            	}
            },
            'patentdetailsgrid[itemId=studentPatentDetailsGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deletePatentType('#studentPatentDetailsGrid', SERVERURL.DELETE_PATENT_TYPE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] patentdetailsform[itemId=studentPatentDetailsForm] button[itemId=submitButtonId]': {
            	click: function(){
            		var form = this.getPersonPatentDetailsForm();
          		    var docGrid = form.down('#patentTypeDocument');
            		this.savePatentType('#studentPatentDetailsGrid', SERVERURL.SAVE_PATENT_TYPE, SERVERURL.UPDATE_PATENT_TYPE,docGrid);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] patentdetailsform[itemId=studentPatentDetailsForm] button[itemId=cancelButtonId]': {
           	  click: this.closePersonCommonWindow
             },
            'patentdetailsform[itemId=studentPatentDetailsForm] button[itemId=uploadDocItemId]':{
            	click : function() {
            		this.getDocumentController().showDocumentFormWindow('studentPatentDetailsForm','DOCUMENT');
            	}
            },
            'documentformwindow[itemId=studentPatentDetailsForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
           	  click : function() {
           		  var form = this.getPersonPatentDetailsForm();
           		  var docGrid = form.down('#patentTypeDocument');
           		  var module = 'studentPatentType';
           		  var entityType = 'studentPatentType';
           		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
           	  }
     		},
            'patentdetailsform[itemId=studentPatentDetailsForm] patenttypedocument button#btnDelete' : {
       			click:function(obj){
       				this.deleteDocument(obj,SERVERURL.PATENT_TYPE_DOC_DELETE,'#studentPatentDetailsGrid');
       			}
       		},
       		'patentdetailsform[itemId=studentPatentDetailsForm] patenttypedocument': {
       			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
       				var $this = this;
       				var documentGrid =  grid.ownerCt;
       				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

       				if (columnName == "documentName") {
       					if (e.target.tagName == 'A') {
       						var documentId = record.get("documentId");
       						if (!isNullOrEmpty(documentId)) {
       							$this.getDocumentController().downloadDocumentFile(documentId);
       						}
       					}
       				}
       			}
       		},
       		
       		/**
       		 * Document Download on click of document count on grid
       		 */
    		 'patentdocumentviewform[itemId=studentPatentDocumentViewForm] patenttypedocument': {
    			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
    				 var $this = this;
    				 var documentGrid =  grid.ownerCt;
    				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

    				 if (columnName == "documentName") {
    					 if (e.target.tagName == 'A') {
    						 var documentId = record.get("documentId");
    						 if (!isNullOrEmpty(documentId)) {
    							 $this.getDocumentController().downloadDocumentFile(documentId);
    						 }
    					 }
    				 }
    			 }
    		 },
       	 
            /**
             *  Training Details
             *  
             */
            'trainingpersondetailsgrid[itemId=studentTrainingPersonDetailsGrid] ': {
            	render: function(grid) {
            		this.loadGridStore('#studentTrainingPersonDetailsGrid', SERVERURL.PERSON_TRINING_GRID,grid);
            		portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_TRAINING_DETAILS_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_TRAINING_DETAILS_PERMISSIONS());
            		} 
            	},
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

              	  var searchResultGrid =  grid.ownerCt;
              	  var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

              	  if(columnName=='noOfdocument'){
              		  if (e.target.tagName == 'A') {
              			  this.showPersonCommonWindow('TRAINING_VIEW_DOCUMENTS', 'studentTrainingDocumentViewForm');
              			  var form = this.getPersonTrainingDocumentViewForm();
              			  var grid = form.down('#trainingdocumentviewId');
              			  this.loadDocumnetGrid(record,grid);
              		  }
              	  }else{
              		if (e.target.tagName == 'A') {
						this.manageCompanyAddressType(
								grid, td, cellIndex,
								record, tr, rowIndex,
								e);
					}
              	  }
                }
            }, 
            'trainingpersondetailsgrid[itemId=studentTrainingPersonDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		//this.showPersonCommonWindow('TRAINING_DETAILS', 'studentPersonTrainingDetailsForm');
            	    personType='STUDENT';
        		    tabPanelTitle= 'TRAINING_DETAILS';
        	    	tabPanelItemId= 'studentTrainingFormDetails';
        	    	tabPanelItemXtype = 'persontrainingdetailsform';
        	    	xtypeItemId = 'studentPersonTrainingDetailsForm';
        	    	//render = true,
        	    	defaultPanel= true;
        	    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
        	    		var contentpanel = this.getContentPanel();
        	    		var trainingtypeformtab = Ext.widget('persontrainingdetailsform',{
        	    			//itemId:'trainingdetailsformstudentportal'
        	    			itemId:'studentPersonTrainingDetailsForm',
        	    		});
        	    		var tabName = getPersonModuleTranslation('TRAINING_TYPE_PORTAL');
        	    		openTab(contentpanel, tabName, trainingtypeformtab,CONSTANTS.MENU_COLOR_EIGHT);            	    		
        	    	}else{
        	    		this.showTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
        	    	}
        	    	try{
        	    		var form = this.getPersonTrainingDetailsForm().getForm();
        	    		form.reset();
        	    	}
        	    	catch(e){
        	    		console.log('');
        	    	}
            	}
            },
            'trainingpersondetailsgrid[itemId=studentTrainingPersonDetailsGrid] button[itemId=btnEdit]': {
            	click: function() {
            		//this.editTrainingType('TRAINING_DETAILS', 'studentPersonTrainingDetailsForm', '#studentTrainingPersonDetailsGrid');
            		personType='STUDENT';
        		    tabPanelTitle= 'TRAINING_DETAILS';
        	    	tabPanelItemId= 'studentTrainingFormDetails';
        	    	tabPanelItemXtype = 'persontrainingdetailsform';
        	    	xtypeItemId = 'studentPersonTrainingDetailsForm';
        	    	//render = true,
        	    	defaultPanel= true;
        	    	gridItemId ='#studentTrainingPersonDetailsGrid';
        	    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
        	    		var contentpanel = this.getContentPanel();
        	    		var grid = contentpanel.down('#studentTrainingPersonDetailsGrid');
        	    		//openTab(contentpanel, tabName, trainingtypeformtab,CONSTANTS.MENU_COLOR_SEVEN);
        	    		var tabPanelTitle = 'TRAINING_TYPE_PORTAL';
        	    		this.editTrainingDetailsModified(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid, CONSTANTS.MENU_COLOR_FIVE);
	    	    	}else{
	    	    		var personProfile = this.getContentPanelActiveTab();
	    	            var grid = personProfile.down(gridItemId);
	    	    		this.editTrainingDetailsModified(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid, CONSTANTS.MENU_COLOR_FIVE);
	    	    	}
            	}
            },
            'trainingpersondetailsgrid[itemId=studentTrainingPersonDetailsGrid] button[itemId=btnView]': {
            	click: function(){
            		//this.viewTrainingType('TRAINING_DETAILS', 'studentPersonTrainingDetailsForm', '#studentTrainingPersonDetailsGrid');

            		personType='STUDENT';
        		    tabPanelTitle= 'TRAINING_DETAILS';
        	    	tabPanelItemId= 'studentTrainingFormDetails';
        	    	tabPanelItemXtype = 'persontrainingdetailsform';
        	    	xtypeItemId = 'studentPersonTrainingDetailsForm';
        	    	//render = true,
        	    	defaultPanel= true;
        	    	gridItemId ='#studentTrainingPersonDetailsGrid';
        	    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
        	    		  var contentpanel = this.getContentPanel();
        	    		  var grid = contentpanel.down('#studentTrainingPersonDetailsGrid');
        	    		  var tabPanelTitle = 'TRAINING_TYPE_PORTAL';
        	    		  this.viewTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid,CONSTANTS.MENU_COLOR_FIVE);
        	    	}else{
          	    		var personProfile = this.getContentPanelActiveTab();
          	            var grid = personProfile.down(gridItemId);
          	    		this.viewTrainingDetails(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,grid,CONSTANTS.MENU_COLOR_FIVE);
          	    	}
            	}
            },
            'trainingpersondetailsgrid[itemId=studentTrainingPersonDetailsGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteTrainingType('#studentTrainingPersonDetailsGrid', SERVERURL.DELETE_TRAINING_DETAILS);
            	}
            },
            'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] button[itemId=submitButtonId]': {
            	click: function(){
            		var form = this.getPersonTrainingDetailsForm();
          		    var docGrid = form.down('#trainingTypeDocument');
          		    //var grid = contentpanel.down('#studentTrainingPersonDetailsGrid');
          		    
          		    var grid;
          		    /* ####### */
          		    if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
	      	    		var contentpanel = this.getContentPanel();
	      	    		grid = contentpanel.down('#studentTrainingPersonDetailsGrid');
	    	    	}else{
	    	    		gridItemId ='#studentTrainingPersonDetailsGrid';
	    	    		var personProfile = this.getContentPanelActiveTab();
	    	            grid = personProfile.down(gridItemId);
	    	    	}
          		    /* ####### */
          		    
          		    this.saveTrainingType(grid,'#studentTrainingPersonDetailsGrid',form, SERVERURL.CREATE_TRAINING_DETAILS, SERVERURL.UPDATE_TRAINING_DETAILS,docGrid);
            	}
            },
            'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] button[itemId=cancelButtonId]': {
            	click: function(obj){
            		try{
        	    		var form = this.getPersonTrainingDetailsForm().getForm();
        	    		form.reset();
        	    	}
        	    	catch(e){
        	    		console.log('');
        	    	}
            	}
            },
            'persontrainingdetailsform[itemId=trainingdetailsformstudentportal] button[itemId=submitButtonId]':{
          	  click:function(){
          		  var contentpanel = this.getContentPanel();
          		  var grid = contentpanel.down('#studentTrainingPersonDetailsGrid');
          		  var form = this.getPersonTrainingDetailsFormStudentPortal();
          		  //var form = this.getPersonTrainingDetailsForm
          		  var docGrid = form.down('#trainingTypeDocument');
          		  this.saveTrainingType(grid,'#studentTrainingPersonDetailsGrid',form,SERVERURL.CREATE_TRAINING_DETAILS,SERVERURL.UPDATE_TRAINING_DETAILS,docGrid);
          	  }  
             },
             'persontrainingdetailsform[itemId=trainingdetailsformstudentportal] button[itemId=personAddressDisplayField4]' : {
 				click : function(obj) {
 					var buttonId = obj.itemId;
 					var form = obj.up('form');
 					var academyLocationId = null;
 					this.getCommonAddressDetails(buttonId,academyLocationId);
 				}
 			},
            'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm]  button[itemId=personAddressDisplayField4]' : {
				click : function(obj) {
					var buttonId = obj.itemId;
					var form = obj.up('form');
					var academyLocationId = null;
					this.getCommonAddressDetails(buttonId,academyLocationId);
				}
			},
			'addressFormWindow#studentTrainingAddressDetails  button[itemId=saveButtonId]' : {
				click : this.addCompanyAddress
			},
			'addressFormWindow#studentTrainingAddressDetails  button[itemId=cancelButtonId]' : {
				click : function() {
					//this.getCloseAddressDetail();
					var formWindow = this.getAddressformwindow();
					formWindow.close();
				}
			},
			'addressFormWindow#studentTrainingAddressDetails button#cancelButtonId': {
                click: this.resetForm
            },
			/* from Address Controller */
			
			'addressFormWindow#studentTrainingAddressDetails form[itemId=addressfieldsform]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = this.getAddressfieldsform().down('customcombobox#cityId');
                    cityComboBox.reset();

                    var countryRegion1 = record[0].get("id");
//                    var store = this.getStore('organization.CountryRegionStore1');
                    var store = this.getStore('organization.CityByCountryRegion');
//                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                }
            },
            'addressFormWindow#studentTrainingAddressDetails form[itemId=addressfieldsform]  customcombobox#countryId': {
                select: function(obj, record) {
                	var newValue = record[0].data.id;
                	var phoneCountryCode = this.getAddressfieldsform().down('customcombobox#phoneCountryCode');
              	    var cellCountryCode = this.getAddressfieldsform().down('customcombobox#cellCountryCode');
              	    var countryStore = this.getAddressfieldsform().down('customcombobox#countryId').getStore();
              	    var val=  countryStore.getById(newValue);
              	    phoneCountryCode.setValue(val);
              	    cellCountryCode.setValue(val);
                    var cityComboBox = this.getAddressfieldsform().down('customcombobox#cityId');
                    cityComboBox.clearValue();

                    var genericField1ComboBox = this.getAddressfieldsform().down('customcombobox#parentCountryRegionId');
                    genericField1ComboBox.reset();

                   /* var genericField2ComboBox = this.getAddressfieldsform().down('customcombobox#genericFieldId2');
                    genericField2ComboBox.reset();*/

                    var countryId = record[0].get("id");
                    
                    
                    var cityStore = cityComboBox.getStore();
                    cityStore.getProxy().extraParams = {
                        id: countryId
                    };
                    cityStore.load();
                    
                    var countryRegionStore = genericField1ComboBox.getStore();
                    countryRegionStore.getProxy().extraParams = {
                        cid: countryId
                    };
                    countryRegionStore.load();
                    
                    /*var countryRegion2Store = genericField2ComboBox.getStore();
                    countryRegion2Store.removeAll();*/
                }//,
                //V2D-96112
//              change: function(obj, newValue) {
//             	   var phoneCountryCode = this.getAddressfieldsform().down('customcombobox#phoneCountryCode');
//             	   var cellCountryCode = this.getAddressfieldsform().down('customcombobox#cellCountryCode');
//             	   var countryStore = this.getAddressfieldsform().down('customcombobox#countryId').getStore();
//             	   var val=  countryStore.getById(newValue);
//             	   phoneCountryCode.setValue(val);
//             	   cellCountryCode.setValue(val);
//           }
            },
            /*'addressFormWindow#studentTrainingAddressDetails button#saveButtonId': {
                click: this.saveAddress
            },*/
			
			/* from Address Controller */
            
            'personcommonwindow[itemId=personCommonWindow] persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] button[itemId=cancelButtonId]': {
           	  click: function(){
           		this.closePersonCommonWindow();
           	  } 
             },
            'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] button[itemId=uploadDocItemId]':{
            	click : function() {
            		this.getDocumentController().showDocumentFormWindow('studentPersonTrainingDetailsForm','DOCUMENT');
            	}
            },
            'documentformwindow[itemId=studentPersonTrainingDetailsForm] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
           	  click : function() {
           		  var form = this.getPersonTrainingDetailsForm();
           		  var docGrid = form.down('#trainingTypeDocument');
           		  var module = 'trainingTypeDocument';
           		  var entityType = 'trainingTypeDocument';
           		  this.pastHistroyTypeDoceSave(docGrid,module,entityType);
           	  }
     		},
            'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] trainingtypedocument button#btnDelete' : {
       			click:function(obj){
       				this.deleteDocument(obj,SERVERURL.TRAINING_TYPE_DOC_DELETE,'studentTrainingPersonDetailsGrid');
       			}
       		},
       		'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] combo#trainingStatusId' : {
       			change:function(obj){
       				var form = this.getPersonTrainingDetailsForm();
       				var toDate = form.down('#toDate');
       				if(obj.value == 'COMPLETED') {
       					toDate.setMaxValue(new Date());
       					toDate.validate();
       				} else {
       					toDate.setMaxValue(false);
       				}
       			}
       		},
       		'persontrainingdetailsform[itemId=studentPersonTrainingDetailsForm] trainingtypedocument': {
       			cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
       				var $this = this;
       				var documentGrid =  grid.ownerCt;
       				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

       				if (columnName == "documentName") {
       					if (e.target.tagName == 'A') {
       						var documentId = record.get("documentId");
       						if (!isNullOrEmpty(documentId)) {
       							$this.getDocumentController().downloadDocumentFile(documentId);
       						}
       					}
       				}
       			}
       		},
       		
       		/**
       		 * Document Download on click of document count on grid
       		 */
    		 'persontrainingdocumentviewform[itemId=studentTrainingDocumentViewForm] trainingtypedocument': {
    			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
    				 var $this = this;
    				 var documentGrid =  grid.ownerCt;
    				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

    				 if (columnName == "documentName") {
    					 if (e.target.tagName == 'A') {
    						 var documentId = record.get("documentId");
    						 if (!isNullOrEmpty(documentId)) {
    							 $this.getDocumentController().downloadDocumentFile(documentId);
    						 }
    					 }
    				 }
    			 }
    		 },
             /**
              *  Hostel Details
              *  
              */
             'hostelpersondetailsgrid[itemId=studentHostelPersonDetailsGrid]': {
            	 render: function(grid) {
            		 this.loadGridStore('#studentHostelPersonDetailsGrid', SERVERURL.STUDENT_FIND_HOSTEL_HISTORY,grid);
            		 portalId = this.getCurrentLoggedPortalId();
            		 if(portalId == 7)
            		 {
            			 this.doAccessControlValidation(grid, this.getPARENT_HOSTEL_DETAILS_PERMISSIONS());	 
            		 }else if(portalId == 2){
            			 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_HOSTEL_DETAILS_PERMISSIONS());
            		 }else if(portalId == 3){
            			 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_HOSTEL_DETAILS_PERMISSIONS());
            		 }else{
            			 this.doAccessControlValidation(grid, this.getSTUDENT_HOSTEL_DETAILS_PERMISSIONS());	 
            		 } 
            	 }
             },
             /**
              *  Competitive Exam Details
              */

            'competitiveexamgrid[itemId=studentCompetitiveExamGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#studentCompetitiveExamGrid', SERVERURL.COMPETITIVE_EXAM_DETAIL_GRID,grid);
            		portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS());	 
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_COMPETITIVE_EXAM_PERMISSIONS()); 
            		} 
            	},
            	 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
 	 		        if (e.target.tagName == 'A') {
 	 		            var filePath = record.get("filePath");
 	 		            if (!isNullOrEmpty(filePath)) {
 	 		                this.downloadCompetitiveGridFile(filePath);
 	 		            }
 	 		        }
 	 		    }
            }, 
            'competitiveexamgrid[itemId=studentCompetitiveExamGrid] button[itemId=btnAdd]': {
          	  click: function() {
                    this.showPersonCommonWindow('COMPETITIVE_EXAM', 'studentCompetitiveExamForm');
                }
            },
            'competitiveexamgrid[itemId=studentCompetitiveExamGrid] button[itemId=btnEdit]': {
                click: function(){
              	  this.editCompetitiveExamFormWindow('COMPETITIVE_EXAM', 'studentCompetitiveExamForm', '#studentCompetitiveExamGrid');
                }
            },
            'competitiveexamgrid[itemId=studentCompetitiveExamGrid] button[itemId=btnView]': {
                click: function(){
              	  this.viewCompetitiveExamFormWindow('COMPETITIVE_EXAM', 'studentCompetitiveExamForm', '#studentCompetitiveExamGrid');
                }
            },
            'competitiveexamgrid[itemId=studentCompetitiveExamGrid] button[itemId=btnDelete]': {
                click: function(){
              	  this.deleteCompetitiveExamRecord('#studentCompetitiveExamGrid', SERVERURL.COMPETITIVE_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=studentCompetitiveExamForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveCompetitiveExam('#studentCompetitiveExamGrid', SERVERURL.COMPETITIVE_CREATE, SERVERURL.COMPETITIVE_UPDATE, 'student');
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=studentCompetitiveExamForm] button[itemId=cancelButtonId]': {
          	  click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=studentCompetitiveExamForm] button[itemId=removeButtonId]': {
            	click: this.removeCompetitiveExamDocument
            },
            /**
             *  Medical Details
             */
            'medicaldetailsform[itemId=studentMedicalDetailsFormItemId]': {
            	render: function(form) {
            		var $this = this;
            		var url = SERVERURL.MD_PERSON_MEDICAL_DETAIL_FIND_BY_PERSON_ID + '?personId=';
            		this.onRenderMedicalDetailsForm(url);
            		portalId = this.getCurrentLoggedPortalId();
            		            	
                	  var medicalDetailForm=$this.getPersonMedicalDetailsForm();
                	  setTimeout(function(){
                  	  medicalDetailForm.down("#familyPractionerContactNumberItemId").labelSeparator = '';
                  	 // medicalDetailForm.down("#familyPractionerContactNumberItemId").setFieldLabel('<span class="required" style="color:red"> *</span>');
                  	  medicalDetailForm.down('#medicalDetailNextButtonId').setDisabled(false);
                  	  //$this.removeStarFromDFR(medicalDetailForm);
                  	  $this.makeFieldAllowBlankAndMandatoryForMedicalDetails(form);
                	  },300);

            		
            		
            		if(portalId == 7)
            		{
            			this.disableMedicalDetailFormPivileges(form, this.getPARENT_MEDICAL_DETAIL_PERMISSIONS());
            		}else if(portalId == 2){
            			//this.doAccessControlValidation(form, this.getFACULTY_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS());
            			this.doAccessControlValidationForLoader(form, this.getFACULTY_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS());
            		}else if(portalId == 3){
            			//this.doAccessControlValidation(form, this.getSTUDENT_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS());
            			this.doAccessControlValidationForLoader(form, this.getSTUDENT_PORTAL_STUDENT_MEDICAL_DETAIL_PERMISSIONS());
            		}else{
            			this.disableMedicalDetailFormPivileges(form, this.getSTUDENT_MEDICAL_DETAIL_PERMISSIONS());
            		} 
            	}
            },
            'medicaldetailsform[itemId=studentMedicalDetailsFormItemId] button[itemId=submitButtonId]': {
                click: function() {
                    var getUrl = SERVERURL.MD_PERSON_MEDICAL_DETAIL_FIND_BY_PERSON_ID + '?personId=';
                    this.saveMedicalDetails(SERVERURL.MD_PERSON_MEDICAL_DETAIL_UPDATE, getUrl);
                }
            },
            'medicaldetailsform[itemId=studentMedicalDetailsFormItemId] filefield[itemId=medicalAidDocumentItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('MD_MEDICAL_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('MD_MEDICAL_DETAILS'), getPersonModuleTranslation('MD_MEDICAL_AID_DOCUMENT_UPLOAD_VALID_FILE'));
                        }
                    } 
                }
            },
            'medicaldetailsform[itemId=studentMedicalDetailsFormItemId] displayfield[itemId=availableDocumentLabelItemId]': {
          	  render: function(component) {
          		  var $this = this;
          		  component.getEl().on('click', function(e) {
          			  if (e.target.tagName == 'B') {
          				  var personalInformationForm = $this.getPersonMedicalDetailsForm();
          				  if (personalInformationForm) {
          					  var documentId = personalInformationForm.down('#documentIdItemId').getValue();
          					  if (!isNullOrEmpty(documentId)) {
          						  $this.getDocumentController().downloadDocumentFile(documentId);
          					  }
          				  }
          			  }
          		  });
          	  }
            },
            'medicaldetailsform[itemId=studentMedicalDetailsFormItemId] customcombobox[itemId=familyPractionerCountryCodeItemId]': {
          	  select:function(rowModel,record) {
	            	  var personProfile = this.getContentPanelActiveTab();
	                  var medicalDetailsForm = personProfile.down('medicaldetailsform');
	                  if (medicalDetailsForm) {
	                	  var countryCodeField = medicalDetailsForm.down("#familyPractionerCountryCodeItemId");
	                	  var mobileField = medicalDetailsForm.down("#familyPractionerContactNumberItemId");
						  this.setMaximumMinimumDigitsForMobileNoValidation(medicalDetailsForm,countryCodeField,mobileField,record);
	                  }
          	  }
            },
            'medicaldetailsform[itemId=studentMedicalDetailsFormItemId] numberfield[itemId=familyPractionerContactNumberItemId]': {
          	  change:function(record) {
	            	  var personProfile = this.getContentPanelActiveTab();
	                  var medicalDetailsForm = personProfile.down('medicaldetailsform');
	                  if (medicalDetailsForm) {
	                	  var mobileField = medicalDetailsForm.down("#familyPractionerContactNumberItemId");
	                	  mobileField.isValid();
	                	  medicalDetailsForm.getForm().checkValidity();
	                  }
          	  }
            },
            /**
             *  Transport Details
             *  
             */
            'transportpersondetailsgrid[itemId=studentTransportPersonDetailsGrid]': {
                render: function(grid) {
                    this.customloadGridStore('#studentTransportPersonDetailsGrid', SERVERURL.FIND_TRANSPORT_REPORTS_FOR_USER,grid);
                    portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.doAccessControlValidation(grid, this.getPARENT_TRANSPORT_DETAILS_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_TRANSPORT_DETAILS_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_TRANSPORT_DETAILS_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_TRANSPORT_DETAILS_PERMISSIONS());	
            		} 
                }
            },
            /**
             *  Non Academic Achievements
             */
        	'nonacademicachievementsgrid[itemId=studentnonacademicachievementsgridItemId]': {
        		render: function(grid) {
        			this.loadNonAcademicAchievementsGridStore('#studentnonacademicachievementsgridItemId', SERVERURL.APPLICANT_NON_ACADEMIC_ACHIEVEMENTS_GRID);
        			portalId = this.getCurrentLoggedPortalId();
        			if(portalId == 3){
        				this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
        			}else{
        				this.doAccessControlValidation(grid, this.getSTUDENT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS()); 	
        			} 
        			
        		}
            
           
              /* cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				   if (e.target.tagName == 'A') {
    					this.viewEmploymentHistory(grid,record);
    				   }
    			   }*/
            },
            'nonacademicachievementsgrid[itemId=studentnonacademicachievementsgridItemId] button[itemId=btnAdd]': {
        		click: function() {
                    this.showPersonCommonWindow('NON_ACADEMIC_ACHIEVEMENTS','nonacademicachievementsform');
                }
            },
            'nonacademicachievementsgrid[itemId=studentnonacademicachievementsgridItemId] button[itemId=btnEdit]': {
            	  click: function(){
            		  this.editNonAcademicAchievementsInfoForm('NON_ACADEMIC_ACHIEVEMENTS','nonacademicachievementsform', '#studentnonacademicachievementsgridItemId');
            	  }
              },
            'personcommonwindow[itemId=personCommonWindow] form[itemId=nonacademicachievementsform]':{
 	    	   render: function() {
 	            		var this$ = this;
 	            		var form = this$.getNonacademicachievementsform();
 	                	var sportEventStore = form.down('#sportEvent').getStore();
 	                	sportEventStore.getProxy().extraParams={
 	            			type:'SportEvent'
 	            		};
 	                	sportEventStore.load();

 	            		var levelEventStore = form.down('#levelEvent').getStore();
 	            		levelEventStore.getProxy().extraParams={
 	            			type:'LevelEvent'
 	            		};
 	            		levelEventStore.load();
 	            		
 	            	}
 	    	 },
 	    	 
 	    	'nonacademicachievementsgrid[itemId=studentnonacademicachievementsgridItemId] button[itemId=btnDelete]': {
                 click: function(){
                 	this.deleteNonAcademicAchievementsInfoRecord('#studentnonacademicachievementsgridItemId', SERVERURL.PATH_NON_ACADEMIC_ACHIEVEMENTS_DELETE);
                 }
             },
 	    	 'nonacademicachievementsgrid[itemId=studentnonacademicachievementsgridItemId] button[itemId=btnView]': {
 	          	  click: function(){
 	          		  this.viewNonAcademicAchievementsInfoForm('NON_ACADEMIC_ACHIEVEMENTS', 'nonacademicachievementsform', '#studentnonacademicachievementsgridItemId');
 	          	  }
 	            },
 	    	 'personcommonwindow[itemId=personCommonWindow] nonacademicachievementsform[itemId=nonacademicachievementsform] button[itemId=submitButtonId]': {
                 click: function(){
                 	this.saveNonAcademicAchievementsForm('#studentnonacademicachievementsgridItemId', SERVERURL.NON_ACADEMIC_ACHIEVEMENTS_SAVE, SERVERURL.NON_ACADEMIC_ACHIEVEMENTS_UPDATE);
                 }
             },
             'personcommonwindow[itemId=personCommonWindow] nonacademicachievementsform[itemId=nonacademicachievementsform] button[itemId=cancelButtonId]': {
             	click: this.closePersonCommonWindow
             },
            /**
             *  Church information Details
             */
        	'churchinformationgrid[itemId=studentChurchInformationGrid]': {
        		render: function(grid) {
        			this.loadChurchInfoGridStore('#studentChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_GRIDDATA);
        			portalId = this.getCurrentLoggedPortalId();
        			if(portalId == 3){
        				this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS());
        			}else if (portalId == 2){
        				this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS());
        			}else if(portalId == 7){
        				this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_CHURCH_INFORMATION_PERMISSIONS());
        			}else{
        				this.doAccessControlValidation(grid, this.getSTUDENT_CHURCH_INFORMATION_PERMISSIONS()); 	
        			} 

        			
        		},
                cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				   if (e.target.tagName == 'A') {
    					this.viewEmploymentHistory(grid,record);
    				   }
    			   }
            },
        	'churchinformationgrid[itemId=studentChurchInformationGrid] button[itemId=btnAdd]': {
        		click: function() {
                    this.showPersonCommonWindow('CHURCH_INFORMATION', 'studentChurchInfoForm');
                }
            },
            'churchinformationgrid[itemId=studentChurchInformationGrid] button[itemId=btnEdit]': {
          	  click: function(){
          		  this.editChurchInfoFormWindow('CHURCH_INFORMATION', 'studentChurchInfoForm', '#studentChurchInformationGrid');
          	  }
            },
            'churchinformationgrid[itemId=studentChurchInformationGrid] button[itemId=btnView]': {
          	  click: function(){
          		  this.viewChurchInfoFormWindow('CHURCH_INFORMATION', 'studentChurchInfoForm', '#studentChurchInformationGrid');
          	  }
            },
            'churchinformationgrid[itemId=studentChurchInformationGrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deleteChurchInfoRecord('#studentChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=studentChurchInfoForm] button[itemId=submitButtonId]': {
                click: function(){
                	this.saveChurchInfo('#studentChurchInformationGrid', SERVERURL.CHURCH_INFORMATION_ADD, SERVERURL.CHURCH_INFORMATION_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=studentChurchInfoForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] churchinformationform[itemId=studentChurchInfoForm] button[itemId=btnAddEmploymentHistory]': {
        		click: function(obj){
 				   this.addChurchEmploymentHistory(obj);
 			   }
        	},
        	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=yearItemId]':{
        		render : this.loadStudentEducationYearData
        	},
        	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] datefield[itemId=yearOfExam]':{
        		render: function(obj) {
       			 this.setYearOfEaxmDateMinvalue(obj);
       		 },
       		 select: function(obj,value){       
        		 this.setStudentEducationYearMonthData(obj,value);
        		}
        	},
        	'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] radiogroup#educationRepeatedSubjectId':{
        		change:function(obj,newValue,oldValue){
        			var  $this = this;
        			var form = obj.up('educationform');
        			var uploadDocField = form.down('#uploadFileItemId');
        			var educationDownloadURL = form.down('#educationDownloadURL');
        			var submitButton = form.down('#submitButtonId');
        			var path = educationDownloadURL.getValue();
        			var value = newValue.isRepeatedSubject;
        			var id = form.down('#education_hidden_field').getValue();
        			var DocumentDownloadURLField = form.down('#educationDownloadURL');
        			if (!isNullOrEmpty(id)) {
        				if (!isNullOrEmpty(path)) {
        					uploadDocField.allowBlank=true;
        				}else{
        					uploadDocField.allowBlank=false;
        				}

        			}else{
        				uploadDocField.allowBlank=false;
        			}

        			if (value!= null && value == true) {
        				uploadDocField.setVisible(true);
        				if (!form.isValid()) {
        					submitButton.setDisabled(true);
        				}
        				DocumentDownloadURLField.setVisible(true);
            			DocumentDownloadURLField.setDisabled(false);
        			}else{
        				uploadDocField.setVisible(false);
        				uploadDocField.allowBlank=true;
        				uploadDocField.reset();
        				if (form.isValid()) {
        					submitButton.setDisabled(false);
        				}
        				DocumentDownloadURLField.setVisible(false);
            			DocumentDownloadURLField.setDisabled(true);
        			}
        		} 
             		 
              },
              'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] filefield#uploadFileItemId':{
           	   change:function(obj,newValue,oldValue){
           		   var form = obj.up('educationform');
           		   var submitButton = form.down('#submitButtonId');
           		   if (!form.isValid()) {
							 submitButton.setDisabled(true);
						}else{
							submitButton.setDisabled(false);
						}
           	   }
              },
        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=studentCompetitiveExamForm] combo[itemId=yearItemId]':{
        		render : this.loadYearDataOfStudentComExam
        	},
        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=studentCompetitiveExamForm] datefield[itemId=yearOfExam]':{
        		render: function(obj) {
       			 this.setYearOfEaxmDateMinvalue(obj);
       		 },
       		 select: function(obj,value){       
        		 this.setYearMonthDataOfStudentComExam(obj,value);
        		}
        	},
        	'personcommonwindow[itemId=personCommonWindow] competitiveexamform[itemId=studentCompetitiveExamForm] nestedJsonCombo[itemId=officerFormativeQualified]':{
        		render: function(obj) {
        			var store = obj.getStore();
        			store.getProxy().extraParams={
        				type:'Officer Formative Qualified'
        			};
        			store.load();
        		},
        		select: function(obj, record) {
        			var $this = this;
        	    	var getComExamForm = $this.getPersonCompetitiveExamForm();
        	    	var newValue = record[0].data.value;
        	    	var completionDate = getComExamForm.down('#completionDate');
        	    	if(newValue=='Yes' || newValue=='In Progress') {
        	    		var status = $this.checkCompletionDateDfrSetting(getComExamForm);
        	    		if(status==false) {
        	    			completionDate.setVisible(true);
        	    		}
        	    	}
        	    	else {
        	    		completionDate.setVisible(false);
        	    		completionDate.allowBlank=true;
        	    		completionDate.reset();
        	    	}
        	    	getComExamForm.getForm().checkValidity();
        		}
        	},
        	/**
             *  Socio Economic Details
             */
            'socioeconomicinformationform[itemId=admStudentSocioEconomicFormItemId]': {
            	render: function(form) {
            		var $this = this;
            		setTimeout(function(){
            			var getForm = form.getForm();
            			var parentQualificationFirstStore = getForm.findField('parentQualification1').getStore();
            			parentQualificationFirstStore.getProxy().extraParams={
            				type:'HighestacademicqualificationGuardian1'
            			};
            			var parentQualificationSecondStore = getForm.findField('parentQualification2').getStore();
            			parentQualificationSecondStore.getProxy().extraParams={
            				type:'HighestacademicqualificationGuardian2'
            			};

            			var PrimaryWayofPaymentStore = getForm.findField('payStudy').getStore();
            			PrimaryWayofPaymentStore.getProxy().extraParams={
            				type:'PrimaryWayofPayment'
            			};

            			var parentQualificationSecondStore = getForm.findField('parentAnnualIncome').getStore();
            			parentQualificationSecondStore.getProxy().extraParams={
            				type:'ParentsAnnualIncomeCombined'
            			};
            			var schoolFeePerYearStore = getForm.findField('schoolFeePerYear').getStore();
            			schoolFeePerYearStore.getProxy().extraParams={
            				type:'PrescribedSchoolFeePerYear'
            			};
            			var isScholarshipStore = getForm.findField('isScholarship').getStore();
            			isScholarshipStore.getProxy().extraParams={
            				type:'ReceivedBursary'
            			};
            			var url = SERVERURL.PATH_ECONOMIC_INFORMATION_FIND_BY_PERSON + '?personId=';
            			$this.onRenderSocioEconomicForm(url,'student');
            			portalId = $this.getCurrentLoggedPortalId();
            			if(portalId == 3){
            				$this.disableSocioEconomicFormPivileges(form, $this.getSTUDENT_PORTAL_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS());
            			}else{
            				$this.disableSocioEconomicFormPivileges(form, $this.getSTUDENT_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS());
            			}
            		 },30);
            		}
            	},
            'socioeconomicinformationform[itemId=admStudentSocioEconomicFormItemId] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveSocioEconomicDetails('#admStudentSocioEconomicFormItemId', SERVERURL.PATH_ECONOMIC_INFORMATION_SAVE, SERVERURL.PATH_ECONOMIC_INFORMATION_UPDATE,'student');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=educationDepartmentId]': {
            	select: function(combo, records, eOpts) {
            		var window = this.getPersonEducationForm();
            		var educationForm = this.getPersonEducationForm().getForm();	
            		var form = window.getForm();
            		var value = combo.getValue();
            		var educationDepartmentIsOther = false;
            		var educationDepartmentId =null;
            		var campaignSchool = form.findField('campaignSchool');
            		var countryId = null;
      		  	    var countryRegionId = null;
      		  	    var cityId = null;

            		educationDepartmentId = combo.getValue();
            		form.findField('instituteName').reset();
            		form.findField('campaignSchool').reset();
          			form.findField('campaignSchool').setDisabled(false);

            		if(campaignSchool.getRawValue()==='Others' || campaignSchool.getRawValue()==='Other'){
            			form.findField('instituteName').reset();
            			form.findField('instituteName').setDisabled(false);
            			educationForm.findField('instituteName').setVisible(true);
            			form.isValid();
            		}else{
            			form.findField('instituteName').reset();
            			form.findField('instituteName').setDisabled(true);
            			educationForm.findField('instituteName').setVisible(false);
            			form.isValid();
            		}

            		if(combo.getRawValue()==='Others' || combo.getRawValue()==='Other'){
            			educationDepartmentIsOther = true;
            		}
            		if(form.findField('country').getValue()!=undefined && !isNullOrEmpty(form.findField('country').getValue())){
          			  countryId = form.findField('country').getValue();
          		    }
          		    if(form.findField('countryRegion').getValue()!=undefined && !isNullOrEmpty(form.findField('countryRegion').getValue())){
          			  countryRegionId = form.findField('countryRegion').getValue();
          		    }
          		    if(form.findField('city').getValue()!=undefined && !isNullOrEmpty(form.findField('city').getValue())){
          			  cityId = form.findField('city').getValue();
          	   	    }
            		campaignSchool.getStore().getProxy().extraParams = {
            			educationDepartmentId: educationDepartmentId,
            			educationDepartmentIsOther:educationDepartmentIsOther,
            			isOthersSchoolReq:true,
            			countryId:countryId,
      		  		    countryRegionId:countryRegionId,
      		  		    cityId:cityId
            		};
            		campaignSchool.getStore().load();
            		window.getForm().checkValidity();
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] nestedJsonCombo[itemId=countryItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryRegionComboBox = form.down('#countryRegionItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		  
    		        countryRegionComboBox.setDisabled(false);
    		        countryRegionComboBox.reset();
    		        cityComboBox.setDisabled(true);
    		        cityComboBox.reset();
    		        var countryId = record[0].get("id");
    		        
    		        var countryRegionStore = countryRegionComboBox.getStore();
    		        countryRegionStore.getProxy().extraParams = {
    		            cid: countryId
    		        };
    		        countryRegionStore.load();
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		  
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] nestedJsonCombo[itemId=countryRegionItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryComboBox = form.down('#countryItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		var countryId = null;
    		  		  
    		        cityComboBox.setDisabled(false);
    		        cityComboBox.reset();
    		        var countryRegionId = record[0].get("id");
    		        
    		        var cityStore = cityComboBox.getStore();
    		        cityStore.getProxy().extraParams = {
    		        	id: countryRegionId
    		        };
    		        cityStore.load();
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		 
    		        if(countryComboBox.getValue() != undefined && !isNullOrEmpty(countryComboBox.getValue())) {
    		        	countryId = countryComboBox.getValue();
    		        }
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId,
    		  			countryRegionId:countryRegionId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
    		'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] nestedJsonCombo[itemId=cityItemId]' : {
    			select:function(obj, record){
    				var this$ = this;
    				var form = this$.getPersonEducationForm();
    				var countryComboBox = form.down('#countryItemId');
    				var countryRegionComboBox = form.down('#countryRegionItemId');
    		    	var cityComboBox = form.down('#cityItemId');
    		    	var campaignSchool = form.down('#campaignSchoolId');
    		    	var educationDepartment = form.down('#educationDepartmentId');
    		    	var instituteName = form.down('#instituteNameId');
    		    	var educationDepartmentIsOther = false;
    		  		var educationDepartmentId =null;
    		  		var countryId = null;
    		  		var countryRegionId = null;
    		  		  
    		        cityComboBox.setDisabled(false);
    		        var cityId = record[0].get("id");
    		        
    		        instituteName.reset();
    		        instituteName.setDisabled(true);
    		        instituteName.setVisible(false);
    		        campaignSchool.reset();
    		  		  
    		        if(countryComboBox.getValue() != undefined && !isNullOrEmpty(countryComboBox.getValue())) {
    		        	countryId = countryComboBox.getValue();
    		        }
    		        if(countryRegionComboBox.getValue() != undefined && !isNullOrEmpty(countryRegionComboBox.getValue())) {
    		        	countryRegionId = countryRegionComboBox.getValue();
    		        }
    		        if(educationDepartment.getValue() != undefined && !isNullOrEmpty(educationDepartment.getValue())) {
    		        	educationDepartmentId = educationDepartment.getValue();
    		        }
    		  		if(educationDepartment.getRawValue()==='Others' || educationDepartment.getRawValue()==='Other'){
    		  			educationDepartmentIsOther = true;
    		  		}
    		  		campaignSchool.getStore().getProxy().extraParams = {
    		  			educationDepartmentId: educationDepartmentId,
    		  			educationDepartmentIsOther:educationDepartmentIsOther,
    		  			isOthersSchoolReq:true,
    		  			countryId:countryId,
    		  			countryRegionId:countryRegionId,
    		  			cityId:cityId
    		  		};
    		  		campaignSchool.getStore().load();
    		  		form.getForm().checkValidity();
    			}
    		},
            'personcommonwindow[itemId=personCommonWindow] educationform[itemId=studentEducationForm] combo[itemId=campaignSchoolId]': {
          	  select: function(combo, records, eOpts) {
        		  var window = this.getPersonEducationForm();
        		  var educationForm = this.getPersonEducationForm().getForm();	
        		  var form =window.getForm();
        		  if(combo.getRawValue()==='Others' || combo.getRawValue()==='Other'){
        			  form.findField('instituteName').reset();
        			  form.findField('instituteName').setDisabled(false);
        			  form.findField('instituteName').setVisible(true);
        			  form.isValid();
        		  }else{
        			  form.findField('instituteName').reset();
        			  form.findField('instituteName').setDisabled(true);
        			  form.findField('instituteName').setVisible(false);
        			  form.isValid();
        		  }
        	  }
          },
          'learningallowancegrid[itemId=learningAllowanceItemId]': {
          	 render: function(grid) {
          		 var me = this;
          		grid.getSelectionModel().deselectAll();
        	  	me.loadGridStore('#learningAllowanceItemId', SERVERURL.PATH_LEARNING_ALLOWANCES_GRID_DATA,grid);
        	  	var portalId = this.getCurrentLoggedPortalId();
        	  	if (portalId == 3){
           			this.doAccessControlValidation(grid, me.getSTUDENT_PORTAL_LEARNING_ALLOWANCE_PERMISSIONS());
           			var structure = grid.up('personinfostudentportal');
           			me.getGridHeaderFreezeStudentProfile(grid,structure,true);
           			}
          	  	me.doAccessControlValidation(grid, me.getSTUDENT_LEARNING_ALLOWANCE_PERMISSIONS());
           },	
           afterrender:function(grid){
  				var me = this;
   				var portalId = this.getCurrentLoggedPortalId();
   				if (portalId == 3) {
   					   me.doAccessControlValidation(grid, me.getSTUDENT_PORTAL_LEARNING_ALLOWANCE_PERMISSIONS());
   				}else{
   					me.doAccessControlValidation(grid, me.getSTUDENT_LEARNING_ALLOWANCE_PERMISSIONS());
   					}
   					
   			}, 
          },  
     	  
            /*  
             * start  INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_GRID  
             * */
          'independentnonexaminingchairpersonreportgrid[itemId=independentnonexaminingchairpersonreportgridId]': {
        	 render: function(grid) {
        		 var me = this;
        	  	grid.getSelectionModel().deselectAll();
        	  	me.loadGridStore('#independentnonexaminingchairpersonreportgridId', SERVERURL.PATH_INDEPENDENT_NONEXAMINING_CHAIRPERSON_GRID_DATA,grid);
            	if(portalId == 2){
            		me.doAccessControlValidation(grid,this.getFACULTY_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_PERMISSION());
            	}else{
        	  	me.doAccessControlValidation(grid, this.getCORE_ERP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT());
            	}
        	  } ,
          cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
				//var documentId = record.data.document.id;
				if(columnName == "independentNonExaminingChairPersonDocs"){
					if(e.target.tagName=='A'){
						if(record.data.independentNonExaminingChairPersonDocs.length == 1){
							var whetherFile = false;
							var documentId= record.data.independentNonExaminingChairPersonDocs["0"].id;
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}} else if(record.data.independentNonExaminingChairPersonDocs.length > 1){
								var docWindow = this.getIndependentnonexaminingchairpersondocumentlist();
								var ID = record.data.id;
								if (!docWindow) {
									docWindow = Ext.widget('independentnonexaminingchairpersondocumentlist',{
										itemId:'independentnonexaminingchairpersondocumentlist'
									});
								}
								docWindow.show();
								var independentnonexaminingchairpersondocumentlistgrid = docWindow.down('#independentnonexaminingchairpersondocumentlistgridItemId');
								 var store = independentnonexaminingchairpersondocumentlistgrid.getStore();
								  store.getProxy().extraParams = {
           						  ID: record.data.id
           					  };
           					  store.load();
							}
					}
				}
			} 
        	},
			  'independentnonexaminingchairpersonreportgrid[itemId=independentnonexaminingchairpersonreportgridId] button[itemId=btnEdit]': { /* independentnonexaminingchairpersondocgrid*/
		        	  click : function() {
		        		  this.editIndependentNonExaminingChairpersonReport('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT','independentNonExaminingChairPersonFormItemId','#independentnonexaminingchairpersonreportgridId');
		        		  this.independentNonExaminingChairpersonReportDocumentContainerWindow();
		        		                  }
		          },
			 'independentnonexaminingchairpersondocumentlistgrid':{
					render: function(grid) {
						//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					},
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								this.getDownloadFile(record.get('documentId'));
							}
						}
					}
				},
				'independentnonexaminingchairpersondocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						var $this = this;
						var form = $this.getIndependentnonexaminingchairpersondocumentlist();
						var independentnonexaminingchairpersonActionGrid=form.down('#independentnonexaminingchairpersondocumentlistgridItemId');
						if (independentnonexaminingchairpersonActionGrid.getSelectionModel().getCount() > 0) {
							var records = independentnonexaminingchairpersonActionGrid.getSelectionModel().getSelection();
							var dispatchZipName = "Independent Non Examining Chair Person Documents";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),
										getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIR_PERSON_REPORT_DOCUMENTS_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									}
								});

							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
						//this.documentReportDocumentZip('student');
					}
	      	 },
	      	 'independentnonexaminingchairpersondocumentlistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getIndependentnonexaminingchairpersondocumentlist();  
	 					var independentnonexaminingchairpersonlist= $this.getIndependentnonexaminingchairpersonreportgrid();
	 					var independentnonexaminingchairperson = $this.getIndependentnonexaminingchairpersondocumentlist();
	 					var independentnonexaminingchairpersonlistgrid=form.down('#independentnonexaminingchairpersondocumentlistgridItemId');
	 					if (independentnonexaminingchairpersonlistgrid.getSelectionModel().getCount() > 0) {
	 						var records = independentnonexaminingchairpersonlistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 						showConfirmMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",	
	 									type: 'rest',
	 									url : SERVERURL.PATH_INDEPENDENT_NONEXAMINING_CHAIRPERSON_DOC_DELETE+'?documentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	 										independentnonexaminingchairpersonlistgrid.store.reload();
	 										independentnonexaminingchairpersonlist.store.reload();
	 										independentnonexaminingchairpersonlistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },					
        	  					 
          'studentjointdegreegrid[itemId=studentjointdegreegridId] button[itemId=btnAdd]': {
        	  click : function() {
        		  var this$ = this;
        		  var formWindow = this$.showPersonCommonWindow('STUDENT_JOINT_DEGREE_INFO_FORM','studentjointdegreeformItemId');
        		  if( formWindow != null ){
        			  var form = formWindow.down('#studentjointdegreeformItemId');
        			  var auditDate = form.down('#auditDate');
        			  auditDate.setValue(dateRender(new Date()));
        			  auditDate.setReadOnly(true);
        			  var user = this$.getCurrentlyLoggedInUser();
        			  var auditId = form.down('#auditId');
        			    auditId.setValue(user.code+'/'+user.value);                        
        			                    }
        		                  }
          },
          'studentjointdegreegrid[itemId=studentjointdegreegridId] button[itemId=btnDelete]': {
            	click: function(){
          		this.deleteStudentJointDegreeInfoRecord('#studentjointdegreegridId', SERVERURL.STUDENT_JOINT_DEGREE_INFO_DELETE);
          	}
          },
          'studentjointdegreegrid[itemId=studentjointdegreegridId] button[itemId=btnEdit]': {
        	  click : function() {
        		  this.editStudentJointdegreeInfo('STUDENT_JOINT_DEGREE_INFO_FORM','studentjointdegreeformItemId','#studentjointdegreegridId');
        		  this.studentJointDegreeDocumentContainerWindow();
        		                  }
          },
          'studentjointdegreeform[itemId=studentjointdegreeformItemId]  button[itemId=submitButtonId]': {
        	  click: function(){
        		  this.saveStudentJointDegreeInfo('#studentjointdegreegridId', SERVERURL.STUDENT_JOINT_DEGREE_INFO_ADD, SERVERURL.STUDENT_JOINT_DEGREE_INFO_UPDATE);
        	  }
          },
          ' studentjointdegreeform button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
         
          'documentformwindow[itemId=student_joint_degree_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
  			click : function() {
  				var $this = this;
  				var isTransient = true;
  				var module = 'studentJointDegree';
  				var entityId;
  				var entityType = 'studentJointDegreeDocument';

  				$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
  						function(success,response,isCallBackTransient) {
  					fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentJointDegree','serialNo']
  							var documentModel = new Academia.model.student.postgraduatemanagement.StudentJointDegreeDocumentModel();
  							documentModel.set("documentName",response.name);
  							documentModel.set("path",response.path);
  							documentModel.set("type",response.type);
  							documentModel.set("documentName",response.name);
  							documentModel.set("createdBy",$this.getIdValueJson(
  											response.createdBy.id,response.createdBy.value));
  							var studentJointDegreeDocGrid = $this.getStudentjointdegreedocumentgrid();
  							var store = studentJointDegreeDocGrid.getStore();
  							store.add(documentModel);
  							if (studentJointDegreeDocGrid.isHidden() && store.data.items.length > 0) {
  								studentJointDegreeDocGrid.setVisible(true);
  							}
  							$this.getDocumentController().closeDocumentFormWindow();
							   showSuccessMessage(getCommonTranslation('STUDENT_JOINT_DEGREE_ACTION'),getCommonTranslation('STUDENT_JOINT_DEGREE_DOCUMENT_ADD_SUCCESSFULLY'));
  						}, isTransient);
  			}
  		},
  		'documentformwindow[itemId=student_joint_degree_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
  			click : function() {
  				this.getDocumentController()
  				.closeDocumentFormWindow();
  			}
  		},
          'studentjointdegreeform[itemId=studentjointdegreeformItemId] button#uploadStudentJointDegreeItemId' : {
				click : function() {
					this
					.getDocumentController()
					.showDocumentFormWindow(
							'student_joint_degree_hidden_field',
					'DOCUMENT');
				}
			},
			'studentjointdegreedocumentgrid button#btnDelete' : {
				 click : function() {
					 var $this = this;
					 var grid = $this.getStudentjointdegreedocumentgrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 Ext.MessageBox
						 .confirm(
								 getPersonModuleTranslation('STUDENT_JOINT_DEGREE'),
								 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								 function(btn,
										 text) {
									 if (btn == 'yes') {
										 var store = grid.getStore();
										 var record = grid.getSelectionModel().getSelection()[0];
										 var id = record.id;
										 if (isNullOrEmpty(id)) {
										 }else{
											 if (record) {
												 store.remove(record);
												 showSuccessMessage(
														 getPersonModuleTranslation('STUDENT_JOINT_DEGREE'),
														 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
											 }
										 }

									 }
								 });
					 } else {
						 showWarningMessage(
								 getPersonModuleTranslation('STUDENT_JOINT_DEGREE'),
								 getCommonTranslation('PLEASE_SELECT_RECORD')); 
					 }
				 }
			 },
			  /**
	             *  Student own progress report Section
	             */
			 'studentownprogressreportform[itemId=studentownprogressreportformItemId]  button[itemId=submitButtonId]': {
	        	  click: function(){
	        		  this.saveStudentOwnProgressReport('#studentownprogressreportgridId', SERVERURL.STUDENT_OWN_PROGRESS_REPORT_ADD, SERVERURL.STUDENT_OWN_PROGRESS_REPORT_UPDATE);
	        	  }
	          },
			 'studentownprogressreportgrid[itemId=studentownprogressreportgridId] button[itemId=btnAdd]': {
	        	  click : function() {
	        		  var this$ = this;
	        		  var formWindow = this$.showPersonCommonWindow('STUDENT_OWN_PROGRESS_REPORT','studentownprogressreportformItemId');
	        		  if( formWindow != null ){
	        			  var form = formWindow.down('#studentownprogressreportformItemId');
	        			  var auditDate = form.down('#auditDate');
	        			  auditDate.setValue(dateRender(new Date()));
	        			  auditDate.setReadOnly(true);
	        			  var user = this$.getCurrentlyLoggedInUser();
	        			  var auditId = form.down('#auditId');
	        			    auditId.setValue(user.code+'/'+user.value);                        
	        			                    }
	        		                  }
	          }, 
	          'studentownprogressreportgrid[itemId=studentownprogressreportgridId] button[itemId=btnEdit]': {
	        	  click : function() {
	        		  this.editStudentOwnProgressReport('STUDENT_OWN_PROGRESS_REPORT','studentownprogressreportformItemId','#studentownprogressreportgridId');
	        		  this.studentOwnProgressReportDocumentContainerWindow();
	        		  }
	          },
	        'studentownprogressreportgrid[itemId=studentownprogressreportgridId] button[itemId=btnDelete]': {
	            	click: function(){
	          		this.deleteStudentOwnProgressRerportRecord('#studentownprogressreportgridId', SERVERURL.STUDENT_OWN_PROGRESS_REPORT_DELETE);
	          	}
	        },  
	        'studentownprogressreportform button[itemId=cancelButtonId]': {
	            	click: this.closePersonCommonWindow
	            },
	        'documentformwindow[itemId=student_own_progress_report_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	      			click : function() {
	      				var $this = this;
	      				var isTransient = true;
	      				var module = 'studentOwnProgressReport';
	      				var entityId;
	      				var entityType = 'studentOwnProgressReportDocument';

	      				$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	      						function(success,response,isCallBackTransient) {
	      					fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentJointDegree','serialNo']
	      							var documentModel = new Academia.model.student.postgraduatemanagement.StudentOwnProgressReportDocumentModel();
	      							documentModel.set("documentName",response.name);
	      							documentModel.set("path",response.path);
	      							documentModel.set("type",response.type);
	      							documentModel.set("documentName",response.name);
	      							documentModel.set("createdBy",$this.getIdValueJson(
	      											response.createdBy.id,response.createdBy.value));
	      							var studentOwnProgressReportDocGrid = $this.getStudentownprogressreportdocumentgrid();
	      							var store = studentOwnProgressReportDocGrid.getStore();
	      							store.add(documentModel);
	      							if (studentOwnProgressReportDocGrid.isHidden() && store.data.items.length > 0) {
	      								studentOwnProgressReportDocGrid.setVisible(true);
	      							}
	      							$this.getDocumentController().closeDocumentFormWindow();
	    							   showSuccessMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'),getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_DOCUMENT_ADD_SUCCESSFULLY'));
	      						}, isTransient);
	      			}
	        	},
	      	'documentformwindow[itemId=student_own_progress_report_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
	      			click : function() {
	      				this.getDocumentController()
	      				.closeDocumentFormWindow();
	      			}
	      	},
	        'studentownprogressreportform[itemId=studentownprogressreportformItemId] button#uploadStudentOwnProgressReportItemId' : {
	    				click : function() {
	    					this
	    					.getDocumentController()
	    					.showDocumentFormWindow(
	    							'student_own_progress_report_hidden_field',
	    					'DOCUMENT');
	    				}
	        },
	    	'studentownprogressreportdocumentgrid button#btnDelete' : {
	    				 click : function() {
	    					 var $this = this;
	    					 var grid = $this.getStudentownprogressreportdocumentgrid();
	    					 if (grid.getSelectionModel().getCount() > 0) {
	    						 Ext.MessageBox
	    						 .confirm(
	    								 getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'),
	    								 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	    								 function(btn,
	    										 text) {
	    									 if (btn == 'yes') {
	    										 var store = grid.getStore();
	    										 var record = grid.getSelectionModel().getSelection()[0];
	    										 var id = record.id;
	    										 if (isNullOrEmpty(id)) {
	    										 }else{
	    											 if (record) {
	    												 store.remove(record);
	    												 showSuccessMessage(
	    														 getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'),
	    														 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	    											 }
	    										 }

	    									 }
	    								 });
	    					 } else {
	    						 showWarningMessage(
	    								 getPersonModuleTranslation('STUDENT_OWN_PROGRESS_REPORT'),
	    								 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	    					 }
	    				 }
	    	 },  
	    	 'studentownprogressreportdocumentgrid' : {
	    		 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	    			 var $this = this;
	    			 var documentGrid = $this
	    			 .getStudentownprogressreportdocumentgrid();
	    			 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
	    			 if (columnName == "documentName") {
	    				 if (e.target.tagName == 'A') {
	    					 var documentId = record
	    					 .get("documentId");
	    					 if (!isNullOrEmpty(documentId)) {
	    						 $this.getDocumentController().downloadDocumentFile(documentId);
	    					 }
	    				 }

	    			 }
	    		 }
	    	 },
            /**
             *  Post School Studies Section
             */
            'postschoolstudiesgrid[itemId=studentPostSchoolStudiesGrid]': {
            	render: function(grid) {
            		this.loadPostSchoolStudiesGridStore('#studentPostSchoolStudiesGrid', SERVERURL.PATH_POST_SCHOOLS_STUDIES_SECTION_GRID_DATA);
            		var buttonsToolBar = grid.query('toolbar')[0];
	 				var addButton = buttonsToolBar.query('#btnAdd')[0];
	 				var editButton = buttonsToolBar.query('#btnEdit')[0];
	 				var btnDelete = buttonsToolBar.query('#btnDelete')[0];
            		portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 3){
            			addButton.setVisible(false);
    	 				editButton.setVisible(false);
    	 				btnDelete.setVisible(false);
            			//this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_POST_SCHOOL_STUDIES_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_POST_SCHOOL_STUDIES_PERMISSIONS()); 	
            		} 
            	}
            },
        	  'postschoolstudiesgrid[itemId=studentPostSchoolStudiesGrid] button[itemId=btnAdd]': {
        		click: function() {
        			this.showPersonCommonWindow('POST_SCHOOL_STUDIES_INFO', 'studentPostSchoolStudiesform');
                }
            },
            'postschoolstudiesgrid[itemId=studentPostSchoolStudiesGrid] button[itemId=btnEdit]': {
          	  click: function(){
          		  this.editPostSchoolStudiesFormWindow('POST_SCHOOL_STUDIES_INFO', 'studentPostSchoolStudiesform', '#studentPostSchoolStudiesGrid');
          	  }
            },
            'postschoolstudiesgrid[itemId=studentPostSchoolStudiesGrid] button[itemId=btnView]': {
          	  click: function(){
          		  this.viewPostSchoolStudiesFormWindow('POST_SCHOOL_STUDIES_INFO', 'studentPostSchoolStudiesform', '#studentPostSchoolStudiesGrid');
          	  }
            },
            'postschoolstudiesgrid[itemId=studentPostSchoolStudiesGrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deletePostSchoolStudiesInfoRecord('#studentPostSchoolStudiesGrid', SERVERURL.PATH_DELETE_POST_SCHOOLS_STUDIES_SECTION);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=studentPostSchoolStudiesform]': {
          	  render: function(form) {
          		  var $this = this;
          			var getForm = form.getForm();
          			var institutionStatusStore = getForm.findField('institutionStatus').getStore();
          			institutionStatusStore.getProxy().extraParams={
          				type:'Institution Status'
          			};
          			var qualificationStatusStore = getForm.findField('qualificationStatusPostSchool').getStore();
          			qualificationStatusStore.getProxy().extraParams={
          				type:'Qualification Status'
          			};
          			
          			var comparableNameStore = getForm.findField('rsaNqfComparableLevel').getStore();
          			comparableNameStore.getProxy().extraParams={
          				type:'RSA NQF Comparable Level'
          			};
          			
          			var academicTranscriptStore = getForm.findField('academicTranscriptVerification').getStore();
          			academicTranscriptStore.getProxy().extraParams={
          				type:'Verification of Academic Script'
          			};
          			
          			var degreeeCertificationStore = getForm.findField('degreeCertificateVerification').getStore();
          			degreeeCertificationStore.getProxy().extraParams={
          				type:'Verification of Degree Certificate'
          			};
          			
          			
          			var degreeeCertificationStore = getForm.findField('qualificationType').getStore();
          			degreeeCertificationStore.getProxy().extraParams={
          				type:'Qualification Type'
          			};
          			
          			 var completedComboItemIdStore =  getForm.findField('completedCombo').getStore();
        			 completedComboItemIdStore.getProxy().extraParams={
    						type:'Studies Completed'
          			 };
          			
          			var InsComboField = form.down('#institutionNameItemId');
          			if(InsComboField.isHidden()){
          				InsComboField.allowBlank = true;	
          			}
          			
          			var InsTextField = form.down('#institutionNameTextFieldItemId');
          			if(InsTextField.isHidden()){
          				InsTextField.allowBlank = true;	
          			}
          			
          		    //var applicantProfile = $this.getContentPanelActiveTab();
          			//var fieldContainer=form.down('#recommendationContainer');
          	  }
            },            'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=studentPostSchoolStudiesform] button[itemId=submitButtonId]': {
                click: function() {
              	  this.savePostSchoolStudiesDetails('#studentPostSchoolStudiesGrid', SERVERURL.PATH_SAVE_POST_SCHOOLS_STUDIES_SECTION, SERVERURL.PATH_UPDATE_POST_SCHOOLS_STUDIES_SECTION,'student');
                }
            },
 
            'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=studentPostSchoolStudiesform] customcombobox[itemId=completedComboItemId]': {
            	change: function(obj, record) {
            		var noOfSemesterCompletedItemId = obj.up('form').down('#noOfSemesterCompletedItemId');
            		 var transcriptDocField = obj.up('form').down('#transcriptItemId');
   				  var certificateDocField = obj.up('form').down('#certificateItemId');
   				  var periodTo = obj.up('form').down('#periodTo');
   				  var recordId = obj.up('form').down('#postSchool_hidden_field').getValue();
   
   				  	transcriptDocLabel = transcriptDocField.getFieldLabel();
   				  	transcriptDocLabelArray = transcriptDocLabel.split(':');
   				  	certificateDocLabel = certificateDocField.getFieldLabel();
   				  	certificateDocLabelArray = certificateDocLabel.split(':');
   				  	
            		var programId=null;
            		if(isArray(record)){
            			programId = record[0].get("id");
            		}else{
            			programId = record; 
            		}
            		if(obj.getDisplayValue() != 'Yes'){
            			  noOfSemesterCompletedItemId.setVisible(true); 
						  noOfSemesterCompletedItemId.allowBlank=false;
						  noOfSemesterCompletedItemId.hideLabel = false;
						  noOfSemesterCompletedItemId.labelSeparator = '';
						  noOfSemesterCompletedItemId.validate();
						  noOfSemesterCompletedItemId.setFieldLabel(getCommonTranslation('NUMBER_OF_SEMESTER_COMPLETED')+ ': <span class="required" style="color:red"> *</span>');
						  periodTo.setDisabled(true);
						  periodTo.reset();
						  noOfSemesterCompletedItemId.reset();
            			
            		}else{
            			  periodTo.setDisabled(false);
						  periodTo.reset();
						  noOfSemesterCompletedItemId.setVisible(false);
						  noOfSemesterCompletedItemId.allowBlank=true;
						  noOfSemesterCompletedItemId.reset();
						  noOfSemesterCompletedItemId.validate();
            		}
            		
            		  if (obj.getDisplayValue() == 'Yes' && transcriptDocField.isVisible() && certificateDocField.isVisible()) {
    					  transcriptDocField.setDisabled(false);
    					  certificateDocField.setDisabled(false);
    					  transcriptDocField.allowBlank = false;
    					  certificateDocField.allowBlank = false;

    					  transcriptDocField.labelSeparator = '';
    					  certificateDocField.labelSeparator = '';
    					  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
    						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
    					  }
    					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
    						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
    					  }
    				  }else if(obj.getDisplayValue() == 'No' && transcriptDocField.isVisible()){
    					  transcriptDocField.setDisabled(false);
    					  certificateDocField.setDisabled(true);
    					  transcriptDocField.allowBlank = false;
    					  certificateDocField.allowBlank = true;
    					  noOfSemesterCompletedItemId.reset();
    					  transcriptDocField.labelSeparator = '';
    					  certificateDocField.labelSeparator = '';
    					  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
    						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
    					  }
    					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
    						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
    					  }
    				  }else if(obj.getDisplayValue() == 'Currently_Enrolled' && transcriptDocField.isVisible()){
    					  transcriptDocField.setDisabled(false);
    					  certificateDocField.setDisabled(true);
    					  transcriptDocField.allowBlank = false;
    					  certificateDocField.allowBlank = true;
    					  noOfSemesterCompletedItemId.reset();
    					  transcriptDocField.labelSeparator = '';
    					  certificateDocField.labelSeparator = '';
    					  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
    						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
    					  }
    					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
    						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
    					  }
    				  }else if(obj.getDisplayValue() == 'Yes' && (transcriptDocField.isVisible() || certificateDocField.isVisible())){
    					  if (transcriptDocField.isVisible()) {
    						  transcriptDocField.setDisabled(false);
    						  transcriptDocField.allowBlank = false;
    						  
    						  transcriptDocField.labelSeparator = '';
    						  if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
        						  transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
        					  }
    					  }
    					  if (certificateDocField.isVisible()) {
    						  certificateDocField.setDisabled(false);
    						  certificateDocField.allowBlank = false;
    						  
    						  certificateDocField.labelSeparator = '';
        					  if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
        						  certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
        					  }
    					  }
    				  }
    				  if (!isNullOrEmpty(recordId)) {
    					   transcriptDocField.allowBlank = true;
    					   transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ':');
    					   if(obj.getDisplayValue() == 'Yes'){
    						   if(!isNullOrEmpty(obj.up('form').down('#certificateDownloadURL').getValue())){
    							   certificateDocField.allowBlank = true;
    							   transcriptDocField.labelSeparator = '';
             					   certificateDocField.labelSeparator = '';
             					   if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
             						   transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ':');
             					   }
             					   if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
             						   certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
             					   }
    						   }else{
    							   certificateDocField.allowBlank = false;
    							   certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ': <span class="required" style="color:red"> *</span>');
    						   }
    					   }else{
    						   certificateDocField.allowBlank = true;
    						   transcriptDocField.labelSeparator = '';
         					   certificateDocField.labelSeparator = '';
         					   if(!isNullOrEmpty(transcriptDocLabelArray) && !isNullOrEmpty(transcriptDocLabelArray[0])) {
         						   transcriptDocField.setFieldLabel(transcriptDocLabelArray[0]+ ':');
         					   }
         					   if(!isNullOrEmpty(certificateDocLabelArray) && !isNullOrEmpty(certificateDocLabelArray[0])) {
         						   certificateDocField.setFieldLabel(certificateDocLabelArray[0]+ ':');
         					   }
    					   }
        				   
    				  }
            	}
  		  },
  		
  	  
  		'postschoolstudiesgrid[itemId=studentPostSchoolStudiesGrid] button[itemId=btnAdd]': {
      		click: function() {
      		     var this$ = this;
                  this.showPersonCommonWindow('POST_SCHOOL_STUDIES_INFO', 'studentPostSchoolStudiesform');
                  var form = this.getPostSchoolStudiesForm();
                 this.showDFRManagedFields(form);
                  var personProfile = this.getContentPanelActiveTab();
        			var fieldContainer=form.down('#recommendationContainer');
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PROGRAM_BATCH_SEAT_TYPE_FOR_STUDENT_FIND +'?studentId='+personProfile.getUserId()+'&isPostSchool='+true,
        				method: 'GET',
        				success: function(res, action) {
        					var data = Ext.decode(res.responseText);
        					if(!isEmpty(data)){
        						for(var i = 0; i<data.length;i++) {
        						fieldContainer.add({
        			    			   xtype : 'fieldcontainer',
        			    			   layout:'hbox',
        			    			   defaults: {
        			    				   labelAlign: 'top',
        			    				   width: 226
        			    			   },
        			    			   items : [{
        							        xtype: 'hidden',
        							        itemId: 'postSchoolProgram_hidden_field'+[i],
        							        name: 'programBatchSeatConfigurations',
        							        value:data[i].id
        							    },{
        			    					xtype: 'displayfield',
        			    					name: 'progamName',
        			    					value:data[i].value,
        			    					itemId :'progamNameItemId'+[i]
        			    				},{
        			    				   xtype: 'customcombobox',
        			    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
        			    				   itemId: 'eligibilityRecommendationItemId'+[i],
        			    				   valueField: 'id',
        			    				   displayField: 'value',
        			    				   allowBlank: false,
        			    				   name: 'eligibilityRecommendation',
        			    				   editable: false,
        			    				   listeners:{
        			    						 change:function(obj,rec,value){
        			    							 var nxtSib = obj.nextSibling();
        			    							 var form = obj.up('postschoolstudiesform');
        			    							 if(obj.getRawValue() == 'Eligible in Others'){
        			    								 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
        			    								 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
            		    								 nxtSib.setVisible(true);
            			    							 obj.nextSibling().getStore().load(); 
            			    							 
            			    							 nxtSib.nextSibling().setVisible(true);
            			    							 nxtSib.nextSibling().allowBlank=false;
            			    							 nxtSib.nextSibling().validate();
            			    							 nxtSib.nextSibling().getStore().load(); 
        			    							 }else{
        			    								 nxtSib.setVisible(false);
            			    							 nxtSib.clearValue();
            			    							 nxtSib.allowBlank=true;
            			    							 nxtSib.nextSibling().setVisible(false);
            			    							 nxtSib.nextSibling().allowBlank=true;
            			    							 nxtSib.nextSibling().clearValue();
            			    							 nxtSib.nextSibling().validate();
            			    							 var fieldPanel=form.down('#recommendationContainer');
        			    								 for (var j = 0; j < fieldPanel.items.items.length; j++) {
        			    									 var eligibilityRecommendation = fieldPanel.items.items[j];
        			    									if(!eligibilityRecommendation.items.items[3].isHidden()){
        			    										 form.down('#recommendedFieldLabelItemId').setFieldLabel(getCommonTranslation('RECOMMENDED_FOR')+ ': <span class="required" style="color:red"> *</span>');
        			    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel(getProgramandcourseTranslation('ACADEMY_LOCATION'));
        			    										 return false;
        			    									}else{
        			    										 form.down('#recommendedFieldLabelItemId').setFieldLabel();
        			    										 form.down('#academyLocationFieldLabelItemId').setFieldLabel();
        			    									}
        			    								 }
        			    								
        			    							 }
        			    						 }
        			    		  			   }
        			    				},{
        			    					xtype : 'multiselectcombofield',
        			    					name : 'academyLocation',
        			    					itemId:'academyLocationId'+[i],
        			    					autoloadStore: false,
        			    					store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
        			    					valueField : 'id',
        			    					displayField : 'value',
        			    					hidden:true,
        			    					allowBlank : false,
        			    					queryParam:'qry',
        			    					minChars:3,
        			    					typeAhead:true,
        			    					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			    					cls:'commonAutoHeightMultiselectField',
        			    					enableKeyEvents  : 'true',
        			    					hideTrigger:false,
        			    					forceSelection:true,
        			    					emptyText: 'Enter 3 char to search',
        			    					listeners: {
        		    							change:function(obj,rec,value){
        		    								var aLRecord = rec.toString();
        		    								obj.nextSibling().reset();
        		    								var recommendationStore = obj.nextSibling().getStore();
        		    								recommendationStore.getProxy().extraParams = {
        		    									academyLocationIds: aLRecord
        		    					    		};
        		    								recommendationStore.load();
        			    						 }
        		    						},
        			    					listConfig: {
        			    						listeners: {
        			    							beforeshow: function(picker) {
        			    								picker.minWidth = picker.up('combobox').getSize().width;
        			    							},
        			    							afterRender: function(combo){
        			    								combo.getStore().on("load", function(store, items){
        			    									if(items.length==0)
        			    										Ext.select('.x-boundlist-item').elements[0].hidden = true;
        			    									else
        			    										Ext.select('.x-boundlist-item').elements[0].hidden = false;
        			    						        });
        			    							}
        			    						},
        			    						loadingText: getCommonTranslation('SEARCHING'),
        			    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			    						getInnerTpl: function() {
        			    							return '<div class="search-item">' +
        			    							'{code}' +
        			    							'</div>';
        			    						}
        			    					}
        			    				},{
        			    					xtype: 'customcombobox',
        			    					store: Ext.create('Academia.store.scholarships.AssociateProgramStore'),
        			    					itemId: 'recommendedForItemId'+[i],
        			    					valueField: 'id',
        			    					hidden:true,
        			    					displayField: 'value',
        			    					name: 'recommendedFor',
        			    					queryParam:'programName',
        			    					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        			    					enableKeyEvents  : 'true',
        			    					minChars:3,
        			    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			    					typeAhead:false,
        			    					hideTrigger:false,
        			    					forceSelection:true
        			    				}]
        			    		   });
        						if(i == 0){
        							form.down('#recommendedForItemId'+[i]).hideLabel = false;
        							form.down('#recommendedForItemId'+[i]).labelSeparator = '';
        							form.down('#academyLocationId'+[i]).hideLabel = false;
        							form.down('#academyLocationId'+[i]).labelSeparator = '';
        							form.down('#eligibilityRecommendationItemId'+[i]).hideLabel = false;
        							form.down('#eligibilityRecommendationItemId'+[i]).labelSeparator = '';
        						}
        						var eligibilityRecommendationStore = form.down('#eligibilityRecommendationItemId'+[i]).getStore();
    	            			eligibilityRecommendationStore.getProxy().extraParams={
    	            				type:'Eligibility Recommendation'
    	            			};
        						}	
        					}
        				}
        			});
        			form.doLayout();
              }
          },
  	  
  		
  		  'personcommonwindow[itemId=personCommonWindow] postschoolstudiesform[itemId=studentPostSchoolStudiesform] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
			'button[itemId=addNewExtraCurrFieldContainerBtn]':{
				click: function(btn){
					this.addMoreFieldsOfExtraCurrProgramStudent(btn);
				}
			},
			'button[itemId=addNewExtraCurrFieldContainerBtn1]':{
				click: function(btn){
					this.addMoreFieldsOfExtraCurrProgramStudent(btn);
				}
			},
			'button[itemId=detailedExtraCurrDeleteButton1]':{
				click: function(btn){
					this.deleteMoreFieldsOfExtraCurrProgramStudent(btn);
				}
			},
			'button[itemId=addStudentsWindowFormExtraSubmitButtonId]':{
				click: function(){
					this.saveExtraCurrStudentWindowForm();
				}
			},
			'button[itemId=addStudentsWindowFormExtraCancelButtonId]':{
				click : this.hideAddStudentsWindowExtraCurr
			}, 
			
			 'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId] button[itemId=btnAdd]': {
	            	click: function() {
	            		this.isAdd=true;
	            		var formWindow = this.showPersonCommonWindow('HEALTH_INFORMATION', 'StudentHealthInformationForm');
	            		if( formWindow != null ){
		        			  var form = formWindow.down('studenthealthinformationform');
		        		}
	            	}
	            },
	            'learningallowancegrid[itemId=learningAllowanceItemId] button[itemId=btnAdd]': {
	            	click: function() {
	            		this.isAdd=true;
	            		var formWindow = this.showPersonCommonWindow('LEARNING_ALLOWANCES', 'StudentLearningAllowanceAddForm');
	            		if( formWindow != null ){
		        			  var form = formWindow.down('studentlearningallowanceaddform');
		        		}
	            	}
	            },  
	            'studenthealthinformationform[itemId=StudentHealthInformationForm] multiselectcombofield#medicalConditionsItemId' : {
	                change : function(obj, record) {
	                    var $this = this;
	                    var displayVal = obj.getDisplayValue();
						var form = $this.getStudenthealthinformationform();
						var otherField = obj.up().down('#medicalConditionName');
						if(!obj.isHidden()){
							if(displayVal.indexOf("Other") >= 0){
								otherField.setVisible(true);
								otherField.setDisabled(false);
								otherField.allowBlank = false;
								form.getForm().checkValidity();
								form.getForm().isValid();
							}
							else{
								otherField.setDisabled(true);
								otherField.setVisible(false);
								otherField.allowBlank = true;
								otherField.setValue('');
								form.getForm().checkValidity();
								form.getForm().isValid();
							}
						}
	                }
	            },
				 'studentlearningallowanceaddform[itemId=StudentLearningAllowanceAddForm] multiselectcombofield#learningAllowancesItemId' : {
		                change : function(obj, record) {
		                    var $this = this;
		                    var displayVal = obj.getDisplayValue();
							var form = $this.getStudentlearningallowanceaddform();
							var otherFieldItem = form.down('#descriptionOtherItemId');
								if(displayVal.indexOf("Other") >= 0){
									otherFieldItem.setVisible(true);
									otherFieldItem.allowBlank = false;
								}
								else{
									otherFieldItem.setVisible(false);
									otherFieldItem.allowBlank = true;
									otherFieldItem.reset();
								}
								form.isValid();
				 }
				 },
				 'studentlearningallowanceaddform': {
					 afterrender : function(structure){
						    var form= this.getStudentlearningallowanceaddform();
						    var otherFieldItem = form.down('#descriptionOtherItemId');
						    if(!otherFieldItem.allowBlank){
						    	otherFieldItem.setVisible(false);
						    }
						    else{
						    	otherFieldItem.setVisible(false);
						    }
			       			var alName=form.down('#accountTypeItemId');
			       			var alId=form.down('#ALID');
			       			var currentIds=this.getCurrentAcademyLocation();
			       			Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.ACADEMY_LOCATION_FIND_ALL,
								method: 'GET',
								success:function(response,data){
										var res = Ext.decode(response.responseText);
										for(var i in res){
											   if(res[i].id==currentIds){
												   alName.setValue(res[i].value);
												   alId.setValue(res[i].id);
											   }
										   }	
								}
							});
			       			var userId = form.down('#grantedByItemId');
                            var loggedInUserId = this.getCurrentlyLoggedInUser().id;
                            userId.getStore().getProxy().extraParams = {
                                id: this.getCurrentAcademyLocation()
                          };
	                         userId.getStore().load({
	                             callback: function(records, operation, success) {
	                                 if (success) {
	                                     for(var i in records){
	                                            if(records[i].data.id==loggedInUserId){
	                                                userId.setValue(records[i].data.id);
	                                            }
	                                        }
	                                   }
	                             }
	
	                         });
	                         
	                         var date=form.down('#validForm');
				       			date.setValue(new Date());
				       			
				       		 var modifiedDate=form.down('#dateModified');
				       			modifiedDate.setValue(new Date());
					 }
				 }, 
	            'studenthealthinformationform[itemId=StudentHealthInformationForm] multiselectcombofield#medicationItemId' : {
		            	                change : function(obj, record) {
		            		                    var $this = this;
		            		                    var displayVal = obj.getDisplayValue();
		            							var form = $this.getStudenthealthinformationform();
		            							var otherField = obj.up().down('#medicationName');
		            							if(!obj.isHidden()){
		            								if(displayVal.indexOf("Other") >= 0){
		            									otherField.setDisabled(false);
		            									otherField.setVisible(true);
		            									otherField.allowBlank = false;
		            									form.getForm().checkValidity();
		            									form.getForm().isValid();
		            								}
		            								else{
		            									otherField.setDisabled(true);
		            									otherField.setVisible(false);
		            									otherField.allowBlank = true;
		            									otherField.setValue('');
		            									form.getForm().checkValidity();
		            									form.getForm().isValid();
		            								}
		            							}
		            							
		            		                }
	            },
		         'studenthealthinformationform[itemId=StudentHealthInformationForm] multiselectcombofield#allergiesItemId' : {
			            	                change : function(obj, record) {
			            		                    var $this = this;
			            		                    var displayVal = obj.getDisplayValue();
			            							var otherField = obj.up().down('#allergiesName');
			            							var form = $this.getStudenthealthinformationform();
			            							if(!obj.isHidden()){
			            								   if(displayVal.indexOf("Other") >= 0){
			            									otherField.setDisabled(false);
			            									otherField.setVisible(true);
			            									otherField.allowBlank = false;
			            									form.getForm().checkValidity();
			            									form.getForm().isValid();
			            								}
			            								else{
			            									otherField.setDisabled(true);
			            									otherField.setVisible(false);
			            									otherField.allowBlank = true;
			            									otherField.setValue('');
			            									form.getForm().checkValidity();
			            									form.getForm().isValid();
			            								}
			            							}
			            		                }
		         },
			      'studenthealthinformationform[itemId=StudentHealthInformationForm] multiselectcombofield#learningDifficultiesItemId' : {
				            	                change : function(obj, record) {
				            		                    var $this = this;
				            		                    var displayVal = obj.getDisplayValue();
				            							var otherField = obj.up().down('#learningDifficultiesName');
				            							var form = $this.getStudenthealthinformationform();     
				            							if(!obj.isHidden()){
				            								  if(displayVal.indexOf("Other") >= 0){
				            									otherField.setDisabled(false);
				            									otherField.setVisible(true);
				            									otherField.allowBlank = false;
				            									form.getForm().checkValidity();
				            									form.getForm().isValid();
				            								}
				            								else{
				            									otherField.setDisabled(true);
				            									otherField.setVisible(false);
				            									otherField.allowBlank = true;
				            									otherField.setValue('');
				            									form.getForm().checkValidity();
				            									form.getForm().isValid();
				            								}
				            							}             
				            		                }
			      },
	            	
	            'studenthealthinformationform[itemId=StudentHealthInformationForm] button#submitButtonId' : {
		 			click : function() {
		               this.saveStudentHealthInformationDetail('#studentHealthInformationGridItemId', SERVERURL.PATH_STUDENT_HEALTH_INFORMATION_DETAIL_ADD, SERVERURL.PATH_STUDENT_HEALTH_INFORMATION_DETAIL_UPDATE);
		 			}
		 		},
		 		'studentlearningallowanceaddform[itemId=StudentLearningAllowanceAddForm] button#submitButtonId' : {
		 			click : function() {
		               this.saveLearningAllowanceAddDeatails('#learningAllowanceItemId', SERVERURL.PATH_LEARNING_ALLOWANCES_ADD, SERVERURL.PATH_STUDENT_LEARNING_ALLOWANCE_DETAIL_UPDATE);
		 			}
		 		},
		 		
		 		'studenthealthinformationform[itemId=StudentHealthInformationForm] button#cancelButtonId' : {
	            	click: this.closePersonCommonWindow
	 			},
	 			'studentlearningallowanceaddform[itemId=StudentLearningAllowanceAddForm] button#cancelButtonId' : {
	            	click: this.closePersonCommonWindow
	 			},
	            
	            'learningallowancegrid[itemId=learningAllowanceItemId] button[itemId=btnEdit]': {
                	click: function(){
                		this.isAdd=false;
                		this.formModelMode='EDIT';
                		this.editStudentLearningAllowanceFormWindow('LEARNING_ALLOWANCES', 'StudentLearningAllowanceAddForm', '#learningAllowanceItemId', false);
                	}
                },
	            
	            'learningallowancegrid[itemId=learningAllowanceItemId] button[itemId=btnView]': {
                	click: function(){
                		var $this = this;
                		this.isAdd=false;
                		this.formModelMode='VIEW';
                		this.viewStudentLearningAllowance('LEARNING_ALLOWANCES', 'StudentLearningAllowanceAddForm', '#learningAllowanceItemId',false);
                	}
                },
                'learningallowancegrid[itemId=learningAllowanceItemId] button[itemId=btnDelete]': {
                	click: function() {
                		this.deleteStudentLearningAllowance('#learningAllowanceItemId', SERVERURL.PATH_LEARNING_ALLOWANCES_DELETE);
                	}
                },
	 			'studenthealthinformationform[itemId=StudentHealthInformationForm] button#healthDocument' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('health_information_Details_hidden_field','DOCUMENT');
		 				setTimeout(function(){
				            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
	 			            form.down('#documentNameField').allowBlank=true;
	 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
	                    		},100);     
		 			}
		 		},
		 		
		 		'studenthealthinformationform[itemId=StudentHealthInformationForm] button#healthDocumentUrl' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('health_information_Details_hidden_field','DOCUMENT_URL');
	 					var formWindow = this.getDocumentformwindow();
	 					if (!formWindow) {
	 						Ext.widget('documentformwindow');
	 						formWindow = this.getDocumentformwindow();
	 					}
	 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
		 			}
		 		},
		 		
		 		'documentformwindow[itemId=health_information_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var isTransient = true;
		 			var module = 'studentHealthInformation';
		 			var entityId;
		 			var entityType = 'studentHealthInformationDocument';

		 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		 					function(success,response,isCallBackTransient) {
		 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentHealthInformation','serialNo']
		 						var documentModel = new Academia.model.personinfo.common.pasthistory.StudentHealthInformationDocumentModel();
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("path",response.path);
		 						documentModel.set("type",response.type);
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("createdBy",$this.getIdValueJson(
		 										response.createdBy.id,response.createdBy.value));
		 						if(documentModel.data.path.length > 255){
		 							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
		 						}else{
		 							var StudentHealthInformationDocGrid = $this.getStudenthealthinformationdocumentgrid();
			 						var store = StudentHealthInformationDocGrid.getStore();
			 						store.add(documentModel);
			 						if (StudentHealthInformationDocGrid.isHidden() && store.data.items.length > 0) {
			 							StudentHealthInformationDocGrid.setVisible(true);
			 						}
			 						var formHealthinformation= Ext.ComponentQuery.query('studenthealthinformationform')[0];
//			 						var fileModifiedDate = formPassport.down("#fileModifiedDate");
//			 						if($this.healthMode=='ADD'){
//			 								 fileModifiedDate.setValue(dateRender(new Date()));
//			 		 				}else{
//			 							    fileModifiedDate.setValue(dateRender(new Date()));
//			 		 				}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						   showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'),getCommonTranslation('HEALTH_INFORMATION_DOCUMENT_ADD_SUCCESSFULLY'));
		 						}
		 					}, isTransient);
		 		}
		 	},
		 	'documentformwindow[itemId=health_information_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},
		 	
		 	 'documentformwindow[itemId=health_information_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		            var form = Ext.ComponentQuery.query('simpleurlform')[0];
			            form.down('#documentFormSubmitButtonId').setDisabled(true);
			            var formPassport= Ext.ComponentQuery.query('studenthealthinformationform')[0];
//			            var fileModifiedDate = formPassport.down("#fileModifiedDate");

		 				fields : ['id','documentId','documentName','path']
		 						var documentModelUrl = new Academia.model.personinfo.common.pasthistory.StudentHealthInformationUrlModel();
		 			            var documentName=form.down('#documentNameField').getValue();
		 			            var UrlName=form.down('#documentUrlField').getValue();

		 			           documentModelUrl.set("documentName",documentName);
		 			           documentModelUrl.set("path",UrlName);
		 						var StudentHealthInformationUrlGrid = $this.getStudenthealthinformationurlgrid();
		 						var store2= StudentHealthInformationUrlGrid.getStore();
		 						store2.add(documentModelUrl);
		 						if (StudentHealthInformationUrlGrid.isHidden() && store2.data.items.length > 0) {
		 							StudentHealthInformationUrlGrid.setVisible(true);
 		            				}
//		 						if($this.healthMode=='ADD'){
//	 								 fileModifiedDate.setValue(dateRender(new Date()));
//		 						}else{
//	 							    fileModifiedDate.setValue(dateRender(new Date()));
//		 						}
		 						$this.getDocumentController().closeDocumentFormWindow();
		 						   showSuccessMessage(getCommonTranslation('HEALTH_INFORMATION'),getCommonTranslation('HEALTH_INFORMATION_URL_ADD_SUCCESSFULLY'));
		 					
		 		}
		 	},
		 	'documentformwindow[itemId=health_information_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},
		 	
		 	'studenthealthinformationdocumentgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
	 				 var grid=$this.getStudenthealthinformationdocumentgrid();
	 				var form = Ext.ComponentQuery.query('studenthealthinformationform')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							getCommonTranslation('HEALTH_INFORMATION_DOCUMENT'),
	 							 getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													getCommonTranslation('HEALTH_INFORMATION_DOCUMENT'),
	 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 										 }
	 									 }
	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							getCommonTranslation('HEALTH_INFORMATION_DOCUMENT'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	 		 
	 		'studenthealthinformationurlgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
	 				 var grid=$this.getStudenthealthinformationurlgrid();
	 				var form = Ext.ComponentQuery.query('studenthealthinformationform')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),
	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),
	 													 getCommonTranslation('URL_SUCCESS_MSG'));
	 										 }
	 									 }
	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	 		 
	 		'studenthealthinformationdocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this.getStudenthealthinformationdocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record
							 .get("ecrptydocumentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
			
			/**
	          *  Education History Details
	        */
	       	 
	       	'studenteducationhistorydetailgrid[itemId=studentEducationHistoryDetailGrid]': {
	           	render: function(grid) {
	           		var $this = this;
	           		$this.loadGridStore('#studentEducationHistoryDetailGrid', SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_DETAIL_GRID_DATA,grid);
	           		var portalId = this.getCurrentLoggedPortalId();
	           		if(portalId==7){
	           			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_EDUCATION_HISTORY_PERMISSIONS())
	           			var structure = grid.up('personinfostudentportal');
    					$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
	           			
	           		}else if (portalId == 2){
        				this.doAccessControlValidation(grid,this.getFACULTY_PORTAL_EDUCATION_HISTORY_PERMISSIONS());
        				var studentProfilePanel = grid.up('studentprofile');
            			var structure = studentProfilePanel.down('[region=center]');
            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
        			}else if (portalId == 3){
	           			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_EDUCATION_HISTORY_PERMISSION());
	           			var structure = grid.up('personinfostudentportal');
	           			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
	           			}else{
	           			this.doAccessControlValidation(grid, this.getEDUCATION_HISTORY_PERMISSION())
	           			var studentProfilePanel = grid.up('studentprofile');
		       			var structure = studentProfilePanel.down('[region=center]');
		       		    var store = grid.getStore();
                        store.load({
                          callback:function() {
                              if(store.getCount()>5) {
                                  $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
                              }            
                          }
                      });
	           		}
	           	},
	           	afterrender:function(grid){
	   				var me = this;
	   				var portalId = this.getCurrentLoggedPortalId();
	   				if (portalId == 3) {
	   					    me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_EDUCATION_HISTORY_PERMISSION());
	   				}else if (portalId == 2){
	            		me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_EDUCATION_HISTORY_PERMISSIONS());
	            	}else if (portalId == 7){
	            		me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_EDUCATION_HISTORY_PERMISSIONS());
	            	}else{
	   					me.addDataGridConfigButton(grid,me.getEDUCATION_HISTORY_PERMISSION());
	   					}
	   					
	   			},
	   			
	   			selectionchange: function(column, selected,eOpts ){
	                   var grid = column.view.up('grid');
		                if(selected.length > '1'){
	                       grid.down('#btnAdd').setDisabled(true);
	                       grid.down('#btnEdit').setDisabled(true);
	                       grid.down('#btnView').setDisabled(true);
	                       grid.down('#btnDelete').setDisabled(false);
	                   }else{
	                       grid.down('#btnAdd').setDisabled(false);
	                       grid.down('#btnEdit').setDisabled(false);
	                       grid.down('#btnView').setDisabled(false);
	                       grid.down('#btnDelete').setDisabled(false);
	                   }
	               },
	               
	               cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
						var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
						if(columnName == "graduationDocument"){
							if(e.target.tagName=='A'){
								if(record.data.graduationDocument.length == 1){
									var whetherFile = false;
									var documentId= record.data.graduationDocument["0"].id;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}} else if(record.data.graduationDocument.length > 1){
										var docWindow = this.getStudenteducationhistorydocumentlist();
										var ID = record.data.id;
										if (!docWindow) {
											docWindow = Ext.widget('studenteducationhistorydocumentlist',{
												itemId:'studenteducationhistorydocumentlist'
											});
										}
										docWindow.show();
										var studenteducationhistorydocumentlistgrid = docWindow.down('#studenteducationhistorydocumentlistgridItemId');
										 var store = studenteducationhistorydocumentlistgrid.getStore();
										  store.getProxy().extraParams = {
		             						  ID: record.data.id
		             					  };
		             					  store.load();
									}
							}
						}
						if(columnName == "graduationDocumentUrl"){
							if(e.target.tagName=='A'){
								if(record.data.graduationDocumentUrl.length == 1){
									
								} else if(record.data.graduationDocumentUrl.length > 1){    	
										var docWindow = this.getStudenteducationhistorydocurllist();
		             					  var ID = record.data.id;
		             					  if (!docWindow) {
		             						  docWindow = Ext.widget('studenteducationhistorydocurllist',{
		             							  itemId:'studenteducationhistorydocurllist'
		             						  });
		             					  }
		             					
										docWindow.show();
										var studenteducationhistorydocurllistgrid = docWindow.down('#studenteducationhistorydocurllistgridItemId');
										 var store = studenteducationhistorydocurllistgrid.getStore();
										  store.getProxy().extraParams = {
		             						  ID: record.data.id
		             					  };
		             					  store.load();
									}
							  }
							}
					}
	           },

	           'studenteducationhistorydetailgrid[itemId=studentEducationHistoryDetailGrid] button[itemId=btnAdd]': {
	            	click: function() {
	            		var this$ = this;
	            		var formWindow = this$.showPersonCommonWindow('EDUCATION_DETAILS','studenteducationhistorydetailform');
	            	}
	            },
	            'studenteducationhistorydetailgrid[itemId=studentEducationHistoryDetailGrid] button[itemId=btnEdit]': {
	            	click: function(){
	            		this.editStudentEducationHistoryDetailFormWindow('EDUCATION_DETAILS', 'studenteducationhistorydetailform', '#studentEducationHistoryDetailGrid');
	            		this.studentDocEducationHistoryContainerWindow();
	            		this.studentUrlEducationHistoryContainerWindow();
	            	}
	            },
	            'studenteducationhistorydetailgrid[itemId=studentEducationHistoryDetailGrid] button[itemId=btnView]': {
	            	click: function(){
	            		var $this = this;
	            		$this.viewStudentEducationHistoryDetailFormWindow('EDUCATION_DETAILS', 'studenteducationhistorydetailform', '#studentEducationHistoryDetailGrid');
	            		$this.studentDocEducationHistoryContainerWindow();
	            		$this.studentUrlEducationHistoryContainerWindow();
	            	}
	            },
	            'studenteducationhistorydetailgrid[itemId=studentEducationHistoryDetailGrid] button[itemId=btnDelete]': {
	            	click: function() {
	            		this.deleteStudentEducationHistoryDetailRecord('#studentEducationHistoryDetailGrid', SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_DETAIL_DELETE);
	            	}
	            },
	            'educationhistorydetailform[itemId=studenteducationhistorydetailform] button#submitButtonId' : {
		 			click : function() {
		               this.saveStudentEducationHistoryDetail('#studentEducationHistoryDetailGrid', SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_DETAIL_ADD, SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_DETAIL_UPDATE);
		 			}
		 		},
		 		
		 		'educationhistorydetailform[itemId=studenteducationhistorydetailform] button#cancelButtonId' : {
  	            	click: this.closePersonCommonWindow
	 			},
	 			
	 			'educationhistorydetailform[itemId=studenteducationhistorydetailform] button#graduationDocument' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('education_history_Details_hidden_field','DOCUMENT');
		 				setTimeout(function(){
				            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
	 			            form.down('#documentNameField').allowBlank=true;
	 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
	                    		},100);     
		 			}
		 		},
		 		
		 		'educationhistorydetailform[itemId=studenteducationhistorydetailform] button#graduationDocumentUrl' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('education_history_Details_hidden_field','DOCUMENT_URL');
	 					var formWindow = this.getDocumentformwindow();
	 					if (!formWindow) {
	 						Ext.widget('documentformwindow');
	 						formWindow = this.getDocumentformwindow();
	 					}
	 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
		 			}
		 		},
		 		
		 		'documentformwindow[itemId=education_history_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var isTransient = true;
		 			var module = 'studentEducationHistory';
		 			var entityId;
		 			var entityType = 'studentEducationHistoryDetailDocument';

		 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		 					function(success,response,isCallBackTransient) {
		 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentEducationHistory','serialNo']
		 						var documentModel = new Academia.model.personinfo.common.pasthistory.StudentEducationHistoryDocumentModel();
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("path",response.path);
		 						documentModel.set("type",response.type);
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("createdBy",$this.getIdValueJson(
		 										response.createdBy.id,response.createdBy.value));
		 						if(documentModel.data.path.length > 255){
		 							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
		 						}else{
		 							var StudentEducationHistoryDocumentGrid = $this.getStudenteducationhistorydocumentgrid();
			 						var store = StudentEducationHistoryDocumentGrid.getStore();
			 						store.add(documentModel);
			 						if (StudentEducationHistoryDocumentGrid.isHidden() && store.data.items.length > 0) {
			 							StudentEducationHistoryDocumentGrid.setVisible(true);
			 						}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						$this.getPersonCommonWindow().center();
			 						showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DOCUMENT_ADD_SUCCESSFULLY'));
		 						}
		 					}, isTransient);
		 	    	}
		 		},
		 		'documentformwindow[itemId=education_history_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 			click : function() {
		 				this.getDocumentController().closeDocumentFormWindow();
		 			}
		 		},

		 		'documentformwindow[itemId=education_history_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		            var form = Ext.ComponentQuery.query('simpleurlform')[0];
			            form.down('#documentFormSubmitButtonId').setDisabled(true);

		 				fields : ['id','documentId','documentName','path']
		 						var documentModelUrl = new Academia.model.personinfo.common.pasthistory.StudentEducationHistoryUrlModel();
		 			            var documentName=form.down('#documentNameField').getValue();
		 			            var UrlName=form.down('#documentUrlField').getValue();

		 			           documentModelUrl.set("documentName",documentName);
		 			           documentModelUrl.set("path",UrlName);
		 						var StudentEducationHistoryUrlGrid = Ext.ComponentQuery.query('studenteducationhistoryurlgrid')[0];
		 						var store2= StudentEducationHistoryUrlGrid.getStore();
		 						store2.add(documentModelUrl);
		 						if (StudentEducationHistoryUrlGrid.isHidden() && store2.data.items.length > 0) {
		 							StudentEducationHistoryUrlGrid.setVisible(true);
    		            				}
		 						$this.getDocumentController().closeDocumentFormWindow();
		 					showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_URL_ADD_SUCCESSFULLY'));
		 	    	}
		 		},
		 		'documentformwindow[itemId=education_history_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		 			click : function() {
		 				this.getDocumentController().closeDocumentFormWindow();
		 			}
		 		},
		 		
		 		'studenteducationhistorydocumentgrid button#btnDelete' : {
		 			 click : function() {
		 				 var $this = this;
		 				 var grid=$this.getStudenteducationhistorydocumentgrid();
		 				var form = Ext.ComponentQuery.query('educationhistorydetailform')[0];
		 				 if (grid.getSelectionModel().getCount() > 0) {
		 					 Ext.MessageBox
		 					 .confirm(
		 							getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
		 							 getCommonTranslation('EDUCATION_DETAILS_DELETE_CONFIRM_MESSAGE'),
		 							function(btn, text) {
		 								 if (btn == 'yes') {
		 									 var store = grid.getStore();
		 									 var record = grid.getSelectionModel().getSelection()[0];
		 									 var id = record.id;
		 									 if (isNullOrEmpty(id)) {
		 									 }else{
		 										 if (record) {
		 											 store.remove(record);
		 											 showSuccessMessage(
		 													getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
		 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
		 										 }
		 									 }

		 								 }
		 							 });
		 				 } else {
		 					 showWarningMessage(
		 							getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
		 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
		 				 }
		 			 }
		 		 },
		          
		 		 'studenteducationhistoryurlgrid button#btnDelete' : {
		 			 click : function() {
		 				 var $this = this;
						 var grid = Ext.ComponentQuery.query('studenteducationhistoryurlgrid')[0];
						 var form = Ext.ComponentQuery.query('educationhistorydetailform')[0];
		 				 if (grid.getSelectionModel().getCount() > 0) {
		 					 Ext.MessageBox
		 					 .confirm(
		 							getCommonTranslation('EDUCATION_DETAILS_URL'),
		 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
		 							function(btn, text) {
		 								 if (btn == 'yes') {
		 									 var store = grid.getStore();
		 									 var record = grid.getSelectionModel().getSelection()[0];
		 									 var id = record.id;
		 									 if (isNullOrEmpty(id)) {
		 									 }else{
		 										 if (record) {
		 											 store.remove(record);
		 											 showSuccessMessage(
		 													getCommonTranslation('EDUCATION_DETAILS_URL'),
		 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
		 										 }
		 									 }

		 								 }
		 							 });
		 				 } else {
		 					 showWarningMessage(
		 							getCommonTranslation('EDUCATION_DETAILS_URL'),
		 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
		 				 }
		 			 }
		 		 },
		 		
		 		'studenteducationhistorydocumentgrid' : {
					 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
						 var $this = this;
						 var documentGrid = $this.getStudenteducationhistorydocumentgrid();
						 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
						 if (columnName == "documentName") {
							 if (e.target.tagName == 'A') {
								 var documentId = record
								 .get("documentId");
								 if (!isNullOrEmpty(documentId)) {
									 $this.getDocumentController().downloadDocumentFile(documentId);
								 }
							 }

						 }
					 }
				 },
		 	
	           'studenteducationhistorydocumentlistgrid':{
					render: function(grid) {
						var this$ = this;
						var portalId = this$.getCurrentLoggedPortalId();
						if(portalId==3) {
							this$.doAccessControlValidation(grid, this$.getSTUDENT_EDUCATION_HISTORY_DOCUMENT_PERMISSION());
						} else if(portalId==7) {
							this$.doAccessControlValidation(grid, this$.getPARENT_EDUCATION_HISTORY_DOCUMENT_PERMISSION());
						} else if(portalId==2) {
							this$.doAccessControlValidation(grid, this$.getFACULTY_EDUCATION_HISTORY_DOCUMENT_PERMISSION());
						} else {
							this$.doAccessControlValidation(grid, this$.getEDUCATION_HISTORY_DOCUMENT_PERMISSION());
						}
		            	grid.down('#downloadDocumentItemId').setVisible(true);
					},
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								var documentId=record.get('documentId');
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
												showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('DOWNLOAD_EDUCATION_HISTORY_DOCUMENT_SUCCESSFULLY'));
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}
							}
						}
					}
				},
				
				'studenteducationhistorydocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						var $this = this;
						var form = $this.getStudenteducationhistorydocumentlistgrid();
//						var StudentEducationHistoryActionGrid=form.down('#studenteducationhistorydocumentlistgridItemId');
						var StudentEducationHistoryActionGrid=obj.up('grid');
						if (StudentEducationHistoryActionGrid.getSelectionModel().getCount() > 0) {
							var records = StudentEducationHistoryActionGrid.getSelectionModel().getSelection();
							var dispatchZipName = "Student Education Detail Document";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getCommonTranslation('EDUCATION_DETAILS_DOCUMENT'),
										getCommonTranslation('EDUCATION_HISTORY_DETAIL_DOCUMENTS_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
										showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('DOWNLOAD_EDUCATION_HISTORY_DOCUMENT_SUCCESSFULLY'));
									}
									
								});
							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
	      	 },
	      	 
	      	'studenteducationhistorydocgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = grid.up('grid');
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
	      	 
	      	'studenteducationhistorydocumentlistgrid button[itemId=btnDelete]':{
 				click:function(obj){
 					var $this=this;
 					var form = $this.getStudenteducationhistorydocumentlist();  
 					var studentEducationHistoryDetailGrid= $this.getStudenteducationhistorydetailgrid();
 					var studenteducationhistoryDetaillistgrid=form.down('#studenteducationhistorydocumentlistgridItemId');
 					if (studenteducationhistoryDetaillistgrid.getSelectionModel().getCount() > 0) {
 						var records = studenteducationhistoryDetaillistgrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 							showConfirmMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DELETE_CONFIRM_MESSAGE'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {

 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DOCUMENT_SUCCESS_DELETE_MSG'));	 
 										studenteducationhistoryDetaillistgrid.store.reload();
 										studentEducationHistoryDetailGrid.store.reload();
 										studenteducationhistoryDetaillistgrid.getSelectionModel().deselectAll(true);
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
 				}
	      	},
	      	'studenteducationhistorydocurllistgrid':{
				 render: function(grid) {
					 var this$ = this; 
					 var portalId = this$.getCurrentLoggedPortalId();
					 if(portalId==3) {
						 this$.doAccessControlValidation(grid, this$.getSTUDENT_EDUCATION_HISTORY_URL_PERMISSION());
					 } else if(portalId==7) {
						 this$.doAccessControlValidation(grid, this$.getPARENT_EDUCATION_HISTORY_URL_PERMISSION());
					 } else if(portalId==2) {
						 this$.doAccessControlValidation(grid, this$.getFACULTY_EDUCATION_HISTORY_URL_PERMISSION());
					 } else {
						 this$.doAccessControlValidation(grid, this$.getEDUCATION_HISTORY_URL_PERMISSION());
					 }
				 }
			 },
       	 
	      	'studenteducationhistorydocurllistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this=this;
					var form = $this.getStudenteducationhistorydocurllist();  
					var studentEducationHistoryDetailGrid= $this.getStudenteducationhistorydetailgrid();
					var studentEducationHistoryDetaillistgrid=form.down('#studenteducationhistorydocurllistgridItemId');
					if (studentEducationHistoryDetaillistgrid.getSelectionModel().getCount() > 0) {
						var records = studentEducationHistoryDetaillistgrid.getSelectionModel().getSelection();
						var ids=[];
						Ext.Array.each(records,function(value){
							ids.push(value.data.id);
						});
							showConfirmMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes'){
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method: "DELETE",
									type: 'rest',
									url : SERVERURL.PATH_STUDENT_EDUCATION_HISTORY_URL_DELETE+'?fileDocumentIds='+ids.join(),
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('EDUCATION_DETAILS'),getCommonTranslation('EDUCATION_DETAILS_DOCUMENT_SUCCESS_DELETE_MSG'));	 
										studentEducationHistoryDetaillistgrid.store.reload();
										studentEducationHistoryDetailGrid.store.reload();
										studentEducationHistoryDetaillistgrid.getSelectionModel().deselectAll(true);
									}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
       		},

			
			/**
			 *  Nominate Examiners Section
			 */
			'personcommonwindow[itemId=personCommonWindow] nominateexaminersform[itemId=nominateexaminersformId] combo[name=examinerName]': {
                select: function(combo, records, eOpts) {
                	var form = combo.up('nominateexaminersform');
                	var emailId =  form.down('#emailId');
                	var mobileNumber =  form.down('#mobileNumber');
                	var mobileCountryCode =  form.down('#mobileCountryCode');
                	emailId.setValue(records[0].data.emailId);
                	mobileNumber.setValue(records[0].data.mobileNumber);
                	mobileCountryCode.setRawValue(records[0].data.mobileCountryCode);
                	
                }
            },
			'nominateexaminersgrid[itemId=nominateexaminersgridId]': {
                render: function(grid) {
                	var me = this;
                	grid.getSelectionModel().deselectAll();
                	this.loadGridStore('#nominateexaminersgridId', SERVERURL.PATH_NOMINATE_EXAMINERS_GRID,grid);
                	if(portalId == 2){
                		me.doAccessControlValidation(grid,this.getFACULTY_NOMINATE_EXAMINERS_PERMISSION());
                		var studentProfilePanel = grid.up('studentprofile');
                 		var structure = studentProfilePanel.down('[region=center]');
                 		if(structure.body.isScrollable() == false){
	                	   me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                        }
                	}else{
                		me.doAccessControlValidation(grid, this.getCORE_ERP_NOMINATE_EXAMINERS());
                	    var studentProfilePanel = grid.up('studentprofile');
             		    var structure = studentProfilePanel.down('[region=center]');
                	    me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                }   
                }   
            },
            'nominateexaminersgrid[itemId=nominateexaminersgridId] button[itemId=btnAdd]': {
	        	  click : function() {
	        		  var this$ = this;
	        		  var formWindow = this$.showPersonCommonWindow('NOMINATE_EXAMINERS','nominateexaminersformId');
	        		  if( formWindow != null ){
	        			  var form = formWindow.down('#nominateexaminersformId');
	        			  var auditDate = form.down('#auditDate');
	        			  auditDate.setValue(dateRender(new Date()));
	        			  auditDate.setReadOnly(true);
	        			  var user = this$.getCurrentlyLoggedInUser();
	        			  var auditId = form.down('#auditId');
	        			  auditId.setValue(user.code+'/'+user.value); 
	        		}
	        	 }
	          },
	          'personcommonwindow[itemId=personCommonWindow] nominateexaminersform[itemId=nominateexaminersformId] button[itemId=submitButtonId]': {
					click: function(){
						this.saveNominateExaminers('#nominateexaminersgridId', SERVERURL.PATH_NOMINATE_EXAMINERS_SAVE, SERVERURL.PATH_NOMINATE_EXAMINERS_UPDATE);
					}
				},
	          'nominateexaminersform[itemId=nominateexaminersformId] button[itemId=cancelButtonId]': {
	            	click: this.closePersonCommonWindow
	          },
	      	'nominateexaminersgrid[itemId=nominateexaminersgridId] button#btnEdit' : {
				click : function() {
				this.editNominateExaminers('NOMINATE_EXAMINERS','nominateexaminersformId','#nominateexaminersgridId');
				}
			},
			'nominateexaminersgrid[itemId=nominateexaminersgridId] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteNominateExaminers('#nominateexaminersgridId', SERVERURL.PATH_NOMINATE_EXAMINERS_DELETE);
            	}
			},
            
			/**
			 * Student MOU Section
			 */
			'studentmougrid[itemId=studentmougridId]': {
                render: function(grid) {
                	var me = this;
                	grid.getSelectionModel().deselectAll();
                	me.loadGridStore('#studentmougridId', SERVERURL.PATH_STUDENT_MOU_GRID_DATA,grid);
                	if(portalId == 3){
                		me.doAccessControlValidation(grid, me.getSTUDENT_PORTAL_STUDENT_MOU_PERMISSIONS());
                	}else if(portalId == 2){
                		me.doAccessControlValidation(grid,this.getFACULTY_STUDENT_MOU_PERMISSION());
                	}else{
                		me.doAccessControlValidation(grid, me.getCORE_ERP_STUDENT_MOU());
                	}
                }   
            },
            'studentmougrid[itemId=studentmougridId] button[itemId=btnAdd]': {
	        	  click : function() {
	        		  var this$ = this;
	        		  var formWindow = this$.showPersonCommonWindow('STUDENT_MOU','studentmouformId');
	        		  if( formWindow != null ){
	        			  var form = formWindow.down('#studentmouformId');
	        			  var auditDate = form.down('#auditDate');
	        			  auditDate.setValue(dateRender(new Date()));
	        			  auditDate.setReadOnly(true);
	        			  var user = this$.getCurrentlyLoggedInUser();
	        			  var auditId = form.down('#auditId');
	        			  auditId.setValue(user.code+'/'+user.value); 
	        		}
	        	 }
	          },'studentmougrid[itemId=studentmougridId] button[itemId=btnEdit]': {
	        	  click : function() {
	        		  this.editStudentMou('STUDENT_MOU','studentmouformId','#studentmougridId');
              		  this.studentMouContainerWindow();
	        		                  }
	          },
	          'studentmouform[itemId=studentmouformId]  button[itemId=submitButtonId]': {
	        	  click: function(){
	        		  this.saveStudentMOU('#studentmougridId', SERVERURL.PATH_STUDENT_MOU_ADD, SERVERURL.PATH_STUDENT_MOU_UPDATE);
	        	  }
	          },
	          'studentmougrid[itemId=studentmougridId] button[itemId=btnDelete]': {
		          	click: function(){
		          		this.deleteStudentMOURecord('#studentmougridId', SERVERURL.PATH_STUDENT_MOU_DELETE);
		          	}
		          },
	          'studentmouform[itemId=studentmouformId] button[itemId=cancelButtonId]': {
	  	            	click: this.closePersonCommonWindow
	  	       },
	  	     'documentformwindow[itemId=student_mou_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	 			var isTransient = true;
	 			var module = 'studentMOU';
	 			var entityId;
	 			var entityType = 'studentMOUDocument';
	 			
	 			var docForm = $this.getSimpledocumentform();
	  			var newcont=docForm.items.items.length;
		 		var insertPosition=newcont+1;
	  			var fieldContainer = docForm.down('#containerIdForButtons');
	  			fieldContainer.setVisible(false);
	  			var panelItem = new Array();
	  			panelItem.push({
	 				xtype : 'fieldcontainer',
	 				width: '100%',
	 				layout : 'hbox',
	 				defaults: {
	 					labelAlign: 'top'
	 				},
	 				items : [{
	 					xtype : 'button',
	 					text : 'Processing...',
	 					buttonAlign : 'right',
	 					ui : 'CustomBtnSubmit',
	 					scale : CONSTANTS.BUTTONSIZE
	 				}]
	  			 });
	  			docForm.insert(insertPosition,panelItem);
	  			docForm.doLayout();

	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	 					function(success,response,isCallBackTransient) {
	 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentMOU','serialNo']
	 						var documentModel = new Academia.model.student.postgraduatemanagement.StudentMOUDocumentModel();
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("path",response.path);
	 						documentModel.set("type",response.type);
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("createdBy",$this.getIdValueJson(
	 										response.createdBy.id,response.createdBy.value));
	 						var studentMOUDocGrid = $this.getStudentmoudocumentgrid();
	 						var store = studentMOUDocGrid.getStore();
	 						store.add(documentModel);
	 						if (studentMOUDocGrid.isHidden() && store.data.items.length > 0) {
	 							studentMOUDocGrid.setVisible(true);
	 						}
	 						$this.getDocumentController().closeDocumentFormWindow();
	 						   showSuccessMessage(getCommonTranslation('STUDENT_MOU'),getCommonTranslation('STUDENT_MOU_DOCUMENT_ADD_SUCCESSFULLY'));
	 					}, isTransient);
	 		}
	 	},
	 	'documentformwindow[itemId=student_mou_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
	 		click : function() {
	 			this.getDocumentController()
	 			.closeDocumentFormWindow();
	 		}
	 	},
	     'studentmouform[itemId=studentmouformId] button#uploadStudentMOUItemId' : {
	 			click : function() {
	 				this.getDocumentController().showDocumentFormWindow('student_mou_hidden_field','DOCUMENT');
	 			}
	 		},
	 		'studentmoudocumentgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
	 				 var grid = $this.getStudentmoudocumentgrid();
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							 getPersonModuleTranslation('STUDENT_MOU'),
	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													 getPersonModuleTranslation('STUDENT_MOU'),
	 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 										 }
	 									 }

	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							 getPersonModuleTranslation('STUDENT_MOU'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	 		 'studentmougrid[itemId= studentmougridId]':{
	 				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	 					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//	 					var documentId = record.data.document.id;
	 					if(columnName == "studentMOUDocuments"){
	 						if(e.target.tagName=='A'){
	 							if(record.data.studentMOUDocuments.length == 1){
	 								var whetherFile = false;
	 								var documentId= record.data.studentMOUDocuments["0"].id;
	 								if(!isNullOrEmpty(documentId)){
	 									Ext.Ajax.request({
	 										type: 'rest',
	 										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
	 										method: 'GET',
	 										callback : function(opt, success, response){
	 											if(response.responseText == 'true') {
	 												var csvForm = Ext.create('Ext.form.Panel'); 
	 												csvForm.getForm().submit({
	 													target: '_blank',
	 													method:'GET',
	 													params :{
	 														access_token : Ext.Ajax.defaultHeaders.access_token
	 													},
	 													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
	 													standardSubmit :true
	 												});
	 											} else {
	 												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
	 											}
	 										}
	 									});
	 								}} else if(record.data.studentMOUDocuments.length > 1){
	 									var docWindow = this.getStudentmoudocumentlist();
	 									var ID = record.data.id;
	 									if (!docWindow) {
	 										// Ext.widget('disciplinaryactiondocumentlist');
	 										docWindow = Ext.widget('studentmoudocumentlist',{
	 											itemId:'studentmouReportDocument'
	 										});
	 										//  docWindow = this.getDisciplinaryactiondocumentlist();
	 									}
	 									docWindow.show();
	 									var studentmoudocumentlistgrid = docWindow.down('#studentmoudocumentlistgridItemId');
	 									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
	 									 var store = studentmoudocumentlistgrid.getStore();
	 									  store.getProxy().extraParams = {
	 	             						  ID: record.data.id
	 	             					  };
	 	             					  store.load();
	 								}
	 						}
	 					}
	 				}
	 			},
	 			'studentmoudocumentlistgrid':{
					render: function(grid) {
						//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					},
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								this.getDownloadFile(record.get('documentId'));
							}
						}
					}
				},
				'studentmoudocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						var $this = this;
						var form = $this.getStudentmoudocumentlist();
						var studentmouActionGrid=form.down('#studentmoudocumentlistgridItemId');
						if (studentmouActionGrid.getSelectionModel().getCount() > 0) {
							var records = studentmouActionGrid.getSelectionModel().getSelection();
							var dispatchZipName = "Student MOU Document";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getCommonTranslation('STUDENT_MOU_DOCUMENTS'),
										getCommonTranslation('STUDENT_MOU_DOCUMENTS_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									}
								});

							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
						//this.documentReportDocumentZip('student');
					}
	      	 },
	      	 'studentmoudocumentlistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getStudentmoudocumentlist();  
	 					var studentmoulist= $this.getStudentmougrid();
	 					var studentmou = this.getStudentmoudocumentgrid();
	 					var studentmoulistgrid=form.down('#studentmoudocumentlistgridItemId');
	 					if (studentmoulistgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentmoulistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 						showConfirmMessage(getCommonTranslation('STUDENT_MOU'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_MOU_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('STUDENT_MOU'),getCommonTranslation('STUDENT_MOU_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	 										studentmoulistgrid.store.reload();
	 										studentmoulist.store.reload();
	 										studentmoulistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	       
	        'studentmoudocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this
					 .getStudentmoudocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record
							 .get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
			 
			 /*
			  * Proof of activity code section start
			  */
			'proofofactivitygrid[itemId=proofofactivitygridId]': {
	                render: function(grid) {
	                	var me = this;
	                	grid.getSelectionModel().deselectAll();
	                	me.loadGridStore('#proofofactivitygridId', SERVERURL.PATH_PROOF_OF_ACTIVITY_GRID_DATA,grid);
	                	if(portalId == 3){
	                		me.doAccessControlValidation(grid, me.getSTUDENT_PORTAL_PROOF_OF_ACTIVITY_PERMISSIONS());
	                	}else if(portalId == 2){
	                		me.doAccessControlValidation(grid,this.getFACULTY_PROOF_OF_ACTIVITY_PERMISSION());
	                	}else{
	                		me.doAccessControlValidation(grid, me.getCORE_ERP_PROOF_OF_ACTIVITY());
	                	}
	                }   
	            },
	            'proofofactivitygrid[itemId=proofofactivitygridId] button[itemId=btnAdd]': {
		        	  click : function() {
		        		  var this$ = this;
		        		  this$.isAdd=true;
		        		  var formWindow = this$.showPersonCommonWindow('PROOF_OF_ACTIVITY','proofofactivityformid');
		        		  if( formWindow != null ){
		        			  var form = formWindow.down('#proofofactivityformid');
		        			  var auditDate = form.down('#auditDate');
		        			  auditDate.setValue(dateRender(new Date()));
		        			  auditDate.setReadOnly(true);
		        			  var user = this$.getCurrentlyLoggedInUser();
		        			  var auditId = form.down('#auditId');
		        			  auditId.setValue(user.code+'/'+user.value); 
		        		}
		        	 }
		          },
		          'proofofactivitygrid[itemId=proofofactivitygridId] button[itemId=btnEdit]': {
		        	  click : function() {
		        		  this.isAdd=false;
		        		  this.editProofOfActivity('PROOF_OF_ACTIVITY','proofofactivityformid','#proofofactivitygridId');
	              		  this.proofOfActivityContainerWindow();
		        		                  }
		          },
		          'proofofactivityform[itemId=proofofactivityformid]  button[itemId=submitButtonId]': {
		        	  click: function(){
		        		  this.saveProofOfActivity('#proofofactivitygridId', SERVERURL.PATH_PROOF_OF_ACTIVITY_ADD, SERVERURL.PATH_PROOF_OF_ACTIVITY_UPDATE);
		        	  }
		          },
		          'proofofactivitygrid[itemId=proofofactivitygridId] button[itemId=btnDelete]': {
			          	click: function(){
			          		this.deleteProofOfActivityRecord('#proofofactivitygridId', SERVERURL.PATH_PROOF_OF_ACTIVITY_DELETE);
			          	}
			          },
		          'proofofactivityform[itemId=proofofactivityformid] button[itemId=cancelButtonId]': {
		  	            	click: this.closePersonCommonWindow
		  	       },
		  	     'documentformwindow[itemId=proof_of_activity_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var isTransient = true;
		 			var module = 'proofOfActivity';
		 			var entityId;
		 			var entityType = 'proofOfActivityDocument';

		 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		 					function(success,response,isCallBackTransient) {
		 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','proofOfActivity','serialNo']
		 						var documentModel = new Academia.model.student.postgraduatemanagement.ProofOfActivityDocumentModel();
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("path",response.path);
		 						documentModel.set("type",response.type);
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("createdBy",$this.getIdValueJson(
		 										response.createdBy.id,response.createdBy.value));
		 						var proofOfActivityDocGrid = $this.getProofofactivitydocumentgrid();
		 						var store = proofOfActivityDocGrid.getStore();
		 						store.add(documentModel);
		 						if (proofOfActivityDocGrid.isHidden() && store.data.items.length > 0) {
		 							proofOfActivityDocGrid.setVisible(true);
		 						}
		 						$this.getDocumentController().closeDocumentFormWindow();
		 						   showSuccessMessage(getCommonTranslation('PROOF_OF_ACTIVITY'),getCommonTranslation('PROOF_OF_ACTIVITY_DOCUMENT_ADD_SUCCESSFULLY'));
		 					}, isTransient);
		 		}
		 	},
		 	'documentformwindow[itemId=proof_of_activity_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},
		     'proofofactivityform[itemId=proofofactivityformid] button#uploadProofOfActivityItemId' : {
		 			click : function() {
		 				this.getDocumentController().showDocumentFormWindow('proof_of_activity_hidden_field','DOCUMENT');
		 			}
		 		},
		 		'proofofactivitydocumentgrid button#btnDelete' : {
		 			 click : function() {
		 				 var $this = this;
		 				 var grid = $this.getProofofactivitydocumentgrid();
		 				 if (grid.getSelectionModel().getCount() > 0) {
		 					 Ext.MessageBox
		 					 .confirm(
		 							 getPersonModuleTranslation('PROOF_OF_ACTIVITY'),
		 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
		 							function(btn, text) {
		 								 if (btn == 'yes') {
		 									 var store = grid.getStore();
		 									 var record = grid.getSelectionModel().getSelection()[0];
		 									 var id = record.id;
		 									 if (isNullOrEmpty(id)) {
		 									 }else{
		 										 if (record) {
		 											 store.remove(record);
		 											 showSuccessMessage(
		 													 getPersonModuleTranslation('PROOF_OF_ACTIVITY'),
		 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
		 										 }
		 									 }

		 								 }
		 							 });
		 				 } else {
		 					 showWarningMessage(
		 							 getPersonModuleTranslation('PROOF_OF_ACTIVITY'),
		 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
		 				 }
		 			 }
		 		 },
		 		 'proofofactivitygrid[itemId= proofofactivitygridId]':{
		 				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
		 					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
		 					if(columnName == "proofOfActivityDocuments"){
		 						if(e.target.tagName=='A'){
		 							if(record.data.proofOfActivityDocuments.length == 1){
		 								var whetherFile = false;
		 								var documentId= record.data.proofOfActivityDocuments["0"].id;
		 								if(!isNullOrEmpty(documentId)){
		 									Ext.Ajax.request({
		 										type: 'rest',
		 										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
		 										method: 'GET',
		 										callback : function(opt, success, response){
		 											if(response.responseText == 'true') {
		 												var csvForm = Ext.create('Ext.form.Panel'); 
		 												csvForm.getForm().submit({
		 													target: '_blank',
		 													method:'GET',
		 													params :{
		 														access_token : Ext.Ajax.defaultHeaders.access_token
		 													},
		 													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		 													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
		 													standardSubmit :true
		 												});
		 											} else {
		 												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
		 											}
		 										}
		 									});
		 								}} else if(record.data.proofOfActivityDocuments.length > 1){
		 									var docWindow = this.getProofofactivitydocumentlist();
		 									var ID = record.data.id;
		 									if (!docWindow) {
		 										// Ext.widget('disciplinaryactiondocumentlist');
		 										docWindow = Ext.widget('proofofactivitydocumentlist',{
		 											itemId:'proofofActivityReportDocument'
		 										});
		 										//  docWindow = this.getDisciplinaryactiondocumentlist();
		 									}
		 									docWindow.show();
		 									var proofofactivitydocumentlistgrid = docWindow.down('#proofofactivitydocumentlistgridItemId');
		 									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
		 									 var store = proofofactivitydocumentlistgrid.getStore();
		 									  store.getProxy().extraParams = {
		 	             						  ID: record.data.id
		 	             					  };
		 	             					  store.load();
		 								}
		 						}
		 					}
		 				}
		 			},
		 			'proofofactivitydocumentlistgrid':{
						render: function(grid) {
							//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
						},
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
							if(columnName == "documentName"){
								if(e.target.tagName=='A'){
									this.getDownloadFile(record.get('documentId'));
								}
							}
						}
					},
					'proofofactivitydocumentlistgrid button[itemId=downloadDocumentItemId]':{
						click:function(obj){
							var $this = this;
							var form = $this.getProofofactivitydocumentlist();
							var proofOfActivityActionGrid=form.down('#proofofactivitydocumentlistgridItemId');
							if (proofOfActivityActionGrid.getSelectionModel().getCount() > 0) {
								var records = proofOfActivityActionGrid.getSelectionModel().getSelection();
								var dispatchZipName = "Proof Of Activity Document";
								var saveModel=[];  
								for(var i in records){
									if(!isNullOrEmpty(records[i].get('path'))) {
										saveModel.push(records[i].get('path'));
									}
									showConfirmMessage(getCommonTranslation('PROOF_OF_ACTIVITY_DOCUMENTS'),
											getCommonTranslation('PROOF_OF_ACTIVITY_DOCUMENTS_ALERT'),
											function(btn, text) {
										if (btn == 'yes') {
											var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
											$this.getController('Academia.controller.document.DocumentController')
											.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
										}
									});

								}
							}
							else {
								$this.hideWindowMask();
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
							//this.documentReportDocumentZip('student');
						}
		      	 },
		      	 'proofofactivitydocumentlistgrid button[itemId=btnDelete]':{
		 				click:function(obj){
		 					var $this=this;
		 					var form = $this.getProofofactivitydocumentlist();  
		 					var proofOfActivitylist= $this.getProofofactivitygrid();
		 					var proofOfActivity = this.getProofofactivitydocumentgrid();
		 					var proofOfActivitylistgrid=form.down('#proofofactivitydocumentlistgridItemId');
		 					if (proofOfActivitylistgrid.getSelectionModel().getCount() > 0) {
		 						var records = proofOfActivitylistgrid.getSelectionModel().getSelection();
		 						var ids=[];
		 						Ext.Array.each(records,function(value){
		 							ids.push(value.data.id);
		 						});
		 						showConfirmMessage(getCommonTranslation('PROOF_OF_ACTIVITY'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
		 							if (btn == 'yes'){
		 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 								Ext.Ajax.request({
		 									method: "DELETE",
		 									type: 'rest',
		 									url : SERVERURL.PATH_PROOF_OF_ACTIVITY_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
		 									headers: {
		 										'Content-Type': 'application/json'
		 									},
		 									success: function(form, action) {

		 										Ext.getBody().unmask();
		 										showSuccessMessage(getCommonTranslation('PROOF_OF_ACTIVITY'),getCommonTranslation('PROOF_OF_ACTIVITY_DOCUMENT_SUCCESS_DELETE_MSG'));	 
		 										proofOfActivitylistgrid.store.reload();
		 										proofOfActivitylist.store.reload();
		 										proofOfActivitylistgrid.getSelectionModel().deselectAll(true);
		 									}
		 								});
		 							}
		 						});
		 					} else {
		 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		 					}
		 				}
		       	 },
		       
		        'proofofactivitydocumentgrid' : {
					 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
						 var $this = this;
						 var documentGrid = $this
						 .getProofofactivitydocumentgrid();
						 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
						 if (columnName == "documentName") {
							 if (e.target.tagName == 'A') {
								 var documentId = record
								 .get("documentId");
								 if (!isNullOrEmpty(documentId)) {
									 $this.getDocumentController().downloadDocumentFile(documentId);
								 }
							 }

						 }
					 }
				 },
			 	 
			 /*
			  * Proof of activity code section end
			  */
			
			'studentpostinfogrid[itemId=studentpostinfogridId]': {
                render: function(grid) {
                	var me = this;
                	grid.getSelectionModel().deselectAll();
                	this.loadGridStore('#studentpostinfogridId', SERVERURL.PATH_POST_DOC_INFO_GRID_DATA,grid);
                	if(portalId == 2){
                		me.doAccessControlValidation(grid,this.getFACULTY_STUDENT_POST_DOC_INFO_PERMISSION());
                	}else{
                		me.doAccessControlValidation(grid, this.getSTUDENT_POST_DOC_INFO_PERMISSIONS());
                	}
                }   
            },
			'studentpostinfogrid[itemId=studentpostinfogridId] button#btnAdd' : {
				click : function() {
					var this$ = this;
					var formWindow = this$.showPersonCommonWindow('STUDENT_POST_DOC_INFO','studentPostDocInfoForm');
					if( formWindow != null ){
            			var form = formWindow.down('#studentPostDocInfoForm');
            			var auditDate = form.down('#auditDateItemId');
            			auditDate.setValue(dateRender(new Date()));
            			auditDate.setReadOnly(true);
            			var user = this$.getCurrentlyLoggedInUser();
            			var auditId = form.down('#auditIdItemId');
            			auditId.setValue(user.code+'/'+user.value);
            		}
				}
			},'studentpostinfogrid[itemId=studentpostinfogridId] button#btnEdit' : {
				click : function() {
				this.editStudentPostInfoFormWindow('STUDENT_POST_DOC_INFO','studentPostDocInfoForm','#studentpostinfogridId');
				}
			},
			'studentpostinfogrid[itemId=studentpostinfogridId] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteStudentPostInfoRecord('#studentpostinfogridId', SERVERURL.PATH_STUDENT_POST_DOC_INFO_DELETE);
            	}
			},
			'studentpostinfogrid[itemId=studentpostinfogridId] button#btnEdit' : {
				click : function() {
					var this$ = this;
					var formWindow = this$.editStudentPostInfoFormWindow('STUDENT_POST_DOC_INFO','studentPostDocInfoForm','#studentpostinfogridId');
					this$.studentPostDocInfoContainerWindow();
				}
			},
			'studentpostinfogrid[itemId=studentpostinfogridId] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteStudentPostInfoRecord('#studentpostinfogridId', SERVERURL.PATH_STUDENT_POST_DOC_INFO_DELETE);
            	}
            },
            'studentpostinfogrid[itemId= studentpostinfogridId]':{
				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//					var documentId = record.data.document.id;
					if(columnName == "studentPostDocInfoDocuments"){
						if(e.target.tagName=='A'){
							if(record.data.studentPostDocInfoDocuments.length == 1){
								var whetherFile = false;
								var documentId= record.data.studentPostDocInfoDocuments["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}} else if(record.data.studentPostDocInfoDocuments.length > 1){
									var docWindow = this.getStudentpostdocinfodocumentlist();
									var ID = record.data.id;
									if (!docWindow) {
										// Ext.widget('disciplinaryactiondocumentlist');
										docWindow = Ext.widget('studentpostdocinfodocumentlist',{
											itemId:'studentpostdocinfoReportDocument'
										});
										//  docWindow = this.getDisciplinaryactiondocumentlist();
									}
									docWindow.show();
									var studentpostdocinfodocumentlistgrid = docWindow.down('#studentpostdocinfodocumentlistItemId');
									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
									 var store = studentpostdocinfodocumentlistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						}
					}
				}
			},
			'studentpostdocinfodocumentlistgrid':{
				render: function(grid) {
					//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							this.getDownloadFile(record.get('documentId'));
						}
					}
				}
			},
			
			'studentpostdocinfodocumentlistgrid button[itemId=downloadDocumentItemId]':{
  				click:function(obj){
  					var $this = this;
  					var form = $this.getStudentpostdocinfodocumentlist();
  					var postdocinfoActionGrid=form.down('#studentpostdocinfodocumentlistItemId');
  					if (postdocinfoActionGrid.getSelectionModel().getCount() > 0) {
  						var records = postdocinfoActionGrid.getSelectionModel().getSelection();
  						var dispatchZipName = "Student Post Doc Info Document";
  						var saveModel=[];  
  						for(var i in records){
  							if(!isNullOrEmpty(records[i].get('path'))) {
  								saveModel.push(records[i].get('path'));
  							}
  							showConfirmMessage(getCommonTranslation('STUDENT_POST_DOC_INFO_DOCUMENTS'),
  									getCommonTranslation('STUDENT_POST_DOC_INFO_DOCUMENTS_ALERT'),
  									function(btn, text) {
  								if (btn == 'yes') {
  									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
  									$this.getController('Academia.controller.document.DocumentController')
  									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
  								}
  							});

  						}
  					}
  					else {
  						$this.hideWindowMask();
  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
  					}
  					//this.documentReportDocumentZip('student');
  				}
        	 },
        	 'studentpostdocinfodocumentlistgrid button[itemId=btnDelete]':{
   				click:function(obj){
   					var $this=this;
   					var form = $this.getStudentpostdocinfodocumentlist();  
   					var studentpostdoclist= $this.getStudentpostinfogrid();
   					var studentpostdoc = this.getStudentpostdocinfodocumentlistgrid();
   					var studentpostdoclistgrid=form.down('#studentpostdocinfodocumentlistItemId');
   					if (studentpostdoclistgrid.getSelectionModel().getCount() > 0) {
   						var records = studentpostdoclistgrid.getSelectionModel().getSelection();
   						var ids=[];
   						Ext.Array.each(records,function(value){
   							ids.push(value.data.id);
   						});
   						showConfirmMessage(getCommonTranslation('STUDENT_POST_DOC_INFO'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
   							if (btn == 'yes'){
   								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   								Ext.Ajax.request({
   									method: "DELETE",
   									type: 'rest',
   									url : SERVERURL.PATH_STUDENT_POST_INFO_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
   									headers: {
   										'Content-Type': 'application/json'
   									},
   									success: function(form, action) {

   										Ext.getBody().unmask();
   										showSuccessMessage(getCommonTranslation('STUDENT_POST_DOC_INFO'),getCommonTranslation('STUDENT_POST_DOC_INFO_DOCUMENT_SUCCESS_DELETE_MSG'));	 
   										studentpostdoclistgrid.store.reload();
   										studentpostdoclist.store.reload();
   										studentpostdoclistgrid.getSelectionModel().deselectAll(true);
   									}
   								});
   							}
   						});
   					} else {
   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
   					}
   				}
         	 },
            'studentjointdegreegrid[itemId=studentjointdegreegridId]': {
                render: function(grid) {
                	var me = this;
                	grid.getSelectionModel().deselectAll();
                	this.loadGridStore('#studentjointdegreegridId', SERVERURL.STUDENT_JOINT_DEGREE_GRID,grid);
                	if(portalId == 2){
                		me.doAccessControlValidation(grid, this.getFACULTY_STUDENT_JOINT_DEGREE_PERMISSION());
                	    var studentProfilePanel = grid.up('studentprofile');
             		    var structure = studentProfilePanel.down('[region=center]');
                    	if(structure.body.isScrollable() == false){
                	       me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                        }
                	}else{
                		me.doAccessControlValidation(grid, this.getCORE_ERP_STUDENT_JOINT_DEGREE());
                		var studentProfilePanel = grid.up('studentprofile');
                 		var structure = studentProfilePanel.down('[region=center]');
                	    if(structure.body.isScrollable() == false){
                		   me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                        }
                	}
                },
				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//					var documentId = record.data.document.id;
					if(columnName == "studentJointDegreeDocuments"){
						if(e.target.tagName=='A'){
							if(record.data.studentJointDegreeDocuments.length == 1){
								var whetherFile = false;
								var documentId= record.data.studentJointDegreeDocuments["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}} else if(record.data.studentJointDegreeDocuments.length > 1){
									var docWindow = this.getStudentjointdegreedocumentlist();
									var ID = record.data.id;
									if (!docWindow) {
										// Ext.widget('disciplinaryactiondocumentlist');
										docWindow = Ext.widget('studentjointdegreedocumentlist',{
											itemId:'studentjointdegreeReportDocument'
										});
										//  docWindow = this.getDisciplinaryactiondocumentlist();
									}
									docWindow.show();
									var studentjointdegreedocumentlistgrid = docWindow.down('#studentjointdegreedocumentlistgridItemId');
									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
									 var store = studentjointdegreedocumentlistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						}
					}
				}
            },/*
			 * Student Joint Degree
			 */
			'studentjointdegreedocumentlistgrid':{
				render: function(grid) {
					//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							this.getDownloadFile(record.get('documentId'));
						}
					}
				}
			},'studentjointdegreedocumentlistgrid button[itemId=downloadDocumentItemId]':{
  				click:function(obj){
  					var $this = this;
  					var form = $this.getStudentjointdegreedocumentlist();
  					var postdocinfoActionGrid=form.down('#studentjointdegreedocumentlistgridItemId');
  					if (postdocinfoActionGrid.getSelectionModel().getCount() > 0) {
  						var records = postdocinfoActionGrid.getSelectionModel().getSelection();
  						var dispatchZipName = "Student Joint Degree Document";
  						var saveModel=[];  
  						for(var i in records){
  							if(!isNullOrEmpty(records[i].get('path'))) {
  								saveModel.push(records[i].get('path'));
  							}
  							showConfirmMessage(getCommonTranslation('STUDENT_JOINT_DEGREE_DOCUMENTS'),
  									getCommonTranslation('STUDENT_JOINT_DEGREE_DOCUMENTS_ALERT'),
  									function(btn, text) {
  								if (btn == 'yes') {
  									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
  									$this.getController('Academia.controller.document.DocumentController')
  									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
  								}
  							});

  						}
  					}
  					else {
  						$this.hideWindowMask();
  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
  					}
  					//this.documentReportDocumentZip('student');
  				}
        	 },
			'studentjointdegreedocumentlistgrid button[itemId=btnDelete]':{
   				click:function(obj){
   					var $this=this;
   					var form = $this.getStudentjointdegreedocumentlist();  
   					var studentpostdoclist= $this.getStudentjointdegreegrid();
   					var studentpostdoc = this.getStudentjointdegreedocumentlistgrid();
   					var studentpostdoclistgrid=form.down('#studentjointdegreedocumentlistgridItemId');
   					if (studentpostdoclistgrid.getSelectionModel().getCount() > 0) {
   						var records = studentpostdoclistgrid.getSelectionModel().getSelection();
   						var ids=[];
   						Ext.Array.each(records,function(value){
   							ids.push(value.data.id);
   						});
   						showConfirmMessage(getCommonTranslation('STUDENT_JOINT_DEGREE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
   							if (btn == 'yes'){
   								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   								Ext.Ajax.request({
   									method: "DELETE",
   									type: 'rest',
   									url : SERVERURL.PATH_STUDENT_JOINT_DEGREE_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
   									headers: {
   										'Content-Type': 'application/json'
   									},
   									success: function(form, action) {

   										Ext.getBody().unmask();
   										showSuccessMessage(getCommonTranslation('STUDENT_JOINT_DEGREE'),getCommonTranslation('STUDENT_JOINT_DEGREE_DOCUMENT_SUCCESS_DELETE_MSG'));	 
   										studentpostdoclistgrid.store.reload();
   										studentpostdoclist.store.reload();
   										studentpostdoclistgrid.getSelectionModel().deselectAll(true);
   									}
   								});
   							}
   						});
   					} else {
   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
   					}
   				}
         	 },
         	 /** start student own progress report **/
         	 'studentownprogressreportgrid[itemId=studentownprogressreportgridId]': {
                 render: function(grid) {
                 	var me = this;
                 	grid.getSelectionModel().deselectAll();
                 	this.loadGridStore('#studentownprogressreportgridId', SERVERURL.STUDENT_OWN_PROGRESS_REPORT_GRID,grid);
                 	if(portalId == 3){
                		me.doAccessControlValidation(grid, me.getSTUDENT_PORTAL_STUDENT_OWN_PROGRESS_REPORT_PERMISSIONS());
                	}else if(portalId == 2){
                		me.doAccessControlValidation(grid,this.getFACULTY_STUDENT_OWN_PROGRESS_REPORT_PERMISSION());
                	}else{
                		me.doAccessControlValidation(grid, this.getCORE_ERP_STUDENT_OWN_PROGRESS_REPORT());
                	}
                 },
 				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
 					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
// 					var documentId = record.data.document.id;
 					if(columnName == "studentOwnProgressReportDocuments"){
 						if(e.target.tagName=='A'){
 							if(record.data.studentOwnProgressReportDocuments.length == 1){
 								var whetherFile = false;
 								var documentId= record.data.studentOwnProgressReportDocuments["0"].id;
 								if(!isNullOrEmpty(documentId)){
 									Ext.Ajax.request({
 										type: 'rest',
 										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
 										method: 'GET',
 										callback : function(opt, success, response){
 											if(response.responseText == 'true') {
 												var csvForm = Ext.create('Ext.form.Panel'); 
 												csvForm.getForm().submit({
 													target: '_blank',
 													method:'GET',
 													params :{
 														access_token : Ext.Ajax.defaultHeaders.access_token
 													},
 													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
 													standardSubmit :true
 												});
 											} else {
 												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
 											}
 										}
 									});
 								}} else if(record.data.studentOwnProgressReportDocuments.length > 1){
 									var docWindow = this.getStudentownprogressreportdocumentlist();
 									var ID = record.data.id;
 									if (!docWindow) {
 										// Ext.widget('disciplinaryactiondocumentlist');
 										docWindow = Ext.widget('studentownprogressreportdocumentlist',{
 											itemId:'studentownprogressReportDocument'
 										});
 									}
 									docWindow.show();
 									var studentownprogressreportdocumentlistgrid = docWindow.down('#studentownprogressreportdocumentlistgridItemId');
 									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
 									 var store = studentownprogressreportdocumentlistgrid.getStore();
 									  store.getProxy().extraParams = {
 	             						  ID: record.data.id
 	             					  };
 	             					  store.load();
 								}
 						}
 					}
 				}
             },
             'studentownprogressreportdocumentlistgrid':{
	  				render: function(grid) {
	  					//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
	  				},
	  				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	  					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	  					if(columnName == "documentName"){
	  						if(e.target.tagName=='A'){
	  							this.getDownloadFile(record.get('documentId'));
	  						}
	  					}
	  				}
	  		},
             'studentownprogressreportdocumentlistgrid button[itemId=downloadDocumentItemId]':{
   				click:function(obj){
   					var $this = this;
   					var form = $this.getStudentownprogressreportdocumentlist();
   					var soprActionGrid=form.down('#studentownprogressreportdocumentlistgridItemId');
   					if (soprActionGrid.getSelectionModel().getCount() > 0) {
   						var records = soprActionGrid.getSelectionModel().getSelection();
   						var dispatchZipName = "Student Own Progress Report Document";
   						var saveModel=[];  
   						for(var i in records){
   							if(!isNullOrEmpty(records[i].get('path'))) {
   								saveModel.push(records[i].get('path'));
   							}
   							showConfirmMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_DOCUMENT'),
   									getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_DOCUMENT_ALERT'),
   									function(btn, text) {
   								if (btn == 'yes') {
   									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
   									$this.getController('Academia.controller.document.DocumentController')
   									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
   								}
   							});

   						}
   					}
   					else {
   						$this.hideWindowMask();
   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
   					}
   					//this.documentReportDocumentZip('student');
   				}
         	 },
 			'studentownprogressreportdocumentlistgrid button[itemId=btnDelete]':{
    				click:function(obj){
    					var $this=this;
    					var form = $this.getStudentownprogressreportdocumentlist();  
    					var studentownprogreportdoclist= $this.getStudentownprogressreportgrid();
    					var studentownprogreportdoc = this.getStudentownprogressreportdocumentgrid();
    					var studentownprogreportdoclistgrid=form.down('#studentownprogressreportdocumentlistgridItemId');
    					if (studentownprogreportdoclistgrid.getSelectionModel().getCount() > 0) {
    						var records = studentownprogreportdoclistgrid.getSelectionModel().getSelection();
    						var ids=[];
    						Ext.Array.each(records,function(value){
    							ids.push(value.data.id);
    						});
    						showConfirmMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    							if (btn == 'yes'){
    								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    								Ext.Ajax.request({
    									method: "DELETE",
    									type: 'rest',
    									url : SERVERURL.PATH_STUDENT_OWN_PROGRESS_REPORT_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
    									headers: {
    										'Content-Type': 'application/json'
    									},
    									success: function(form, action) {

    										Ext.getBody().unmask();
    										showSuccessMessage(getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT'),getCommonTranslation('STUDENT_OWN_PROGRESS_REPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
    										studentownprogreportdoclistgrid.store.reload();
    										studentownprogreportdoclist.store.reload();
    										studentownprogreportdoclistgrid.getSelectionModel().deselectAll(true);
    									}
    								});
    							}
    						});
    					} else {
    						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    					}
    				}
          	 },
            'studentthesistitlegrid[itemId=studentthesistitlegridId]': {
                render: function(grid) {
                	var me = this;
                	grid.getSelectionModel().deselectAll();
                	this.loadGridStore('#studentthesistitlegridId', SERVERURL.PATH_STUDENT_THESIS_TITLE_GRID_DATA,grid);
                	if(portalId == 2){
                		me.doAccessControlValidation(grid,this.getFACULTY_STUDENT_THESIS_TITLE_PERMISSION());
                	    var studentProfilePanel = grid.up('studentprofile');
             		    var structure = studentProfilePanel.down('[region=center]');
                    	if(structure.body.isScrollable() == false){
                	       me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                        }
                	}else{
                		me.doAccessControlValidation(grid, this.getCORE_ERP_STUDENT_THESIS_TITLE());
                		var studentProfilePanel = grid.up('studentprofile');
                 		var structure = studentProfilePanel.down('[region=center]');
                	    if(structure.body.isScrollable() == false){
                		   me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                        }
                   }   
                }  
            },
            

          
            'personcommonwindow[itemId=personCommonWindow] studentthesistitleform[itemId=studentThesisTitleFormItemId] customcombobox[itemId=programId]': {
            	select: function(obj, record) {
            		var personProfile = this.getContentPanelActiveTab();
            		var form = this.getStudentThesisTitleForm();
            		var personId=null;
            		if(!isNullOrEmpty(personProfile.getPersonInfo())){  			
            			var store =  form.down('#programId').getStore();
            			store.load({
            				params: {
            					personId : personProfile.getPersonInfo().id
            				}
            			});
            		}
            	},
            afterrender:function(cmp){
        		var personProfile = this.getContentPanelActiveTab();
        		var form = this.getStudentThesisTitleForm();
        		var personId=null;
        		if(!isNullOrEmpty(personProfile.getPersonInfo())){  			
        			var store =  form.down('#programId').getStore();
        			store.load({
        				params: {
        					personId : personProfile.getPersonInfo().id
        				}
        			});
        		}
        	}
            },
         /*   'personcommonwindow[itemId=personCommonWindow] studentthesistitleform[itemId=studentThesisTitleFormItemId]':{
            	
            },
            */
            'studentthesistitlegrid[itemId=studentthesistitlegridId] button[itemId=btnAdd]': {
        		click: function() {
        			var this$ = this;
					var formWindow = this.showPersonCommonWindow('STUDENT_THESIS_TITLE', 'studentThesisTitleFormItemId');
                    if( formWindow != null ){
            			var form = formWindow.down('#studentThesisTitleFormItemId');
            			var auditDate = form.down('#auditDateItemId');
            			auditDate.setValue(dateRender(new Date()));
            			auditDate.setReadOnly(true);
            			var user = this$.getCurrentlyLoggedInUser();
            			var auditId = form.down('#auditIdItemId');
            			auditId.setValue(user.code+'/'+user.value);
            		}
                }
            },
            'studentthesistitlegrid[itemId=studentthesistitlegridId] button[itemId=btnEdit]': {
            	click: function(){
            		this.editStudentThesisTitleFormWindow('STUDENT_THESIS_TITLE', 'studentThesisTitleFormItemId', '#studentthesistitlegridId');
            	}
            },
            'studentthesistitlegrid[itemId=studentthesistitlegridId] button[itemId=btnDelete]': {
            	click: function(){
            		this.deletestudentThesisTitleFormRecord('#studentthesistitlegridId', SERVERURL.STUDENT_THESIS_TITLE_DELETE);
            	}
            },

            'personcommonwindow[itemId=personCommonWindow] studentthesistitleform[itemId=studentThesisTitleFormItemId] button[itemId=submitButtonId]': {
          	  click: function(){
          		  this.saveStudentThesisTitle('#studentthesistitlegridId', SERVERURL.STUDENT_THESIS_TITLE_ADD, SERVERURL.STUDENT_THESIS_TITLE_UPDATE);
          	  }
            },

            'personcommonwindow[itemId=personCommonWindow] studentthesistitleform[itemId=studentThesisTitleFormItemId] button[itemId=cancelButtonId]': {
              	click: this.closePersonCommonWindow
              },
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] customcombobox[itemId=departmentItemId]' : {
				render: function() {
					var this$ = this;
                    var departmentCombo = this$.getPostDocInfoForm().down('#departmentItemId');
                    var userId = this$.getUserInfo();
                    var store = departmentCombo.getStore();
                    store.getProxy().extraParams = {
                        userId: userId
                    };
                    store.load();
                }
			},
			
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] customcombobox[itemId=financialResourceOneItemId]': {
				select: function(combo){
					var this$ = this;
					var form = this$.getPostDocInfoForm();
					var financialResourceOne = form.down("#financialResourceOneItemId");
					var financialResourceChildOne = form.down("#financialResourceChildOneItemId");
					financialResourceChildOne.reset();
					financialResourceChildOne.clearValue();
					var financialResourceId=combo.getValue();
					var financialOneStore = financialResourceOne.getStore();
					var financialChildOneStore = financialResourceChildOne.getStore();
					financialChildOneStore.getProxy().extraParams={
						id:financialResourceId,
					}
					financialChildOneStore.load({
						callback: function(records, operation, success) {
							if (success) {
								financialResourceChildOne.setDisabled(false);
								if(records.length==1){
									financialResourceChildOne.setValue(records[0].data.id);
								}
							}

						}

					});
				}
			},
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] customcombobox[itemId=financialResourceTwoItemId]': {
				select: function(combo){
					var this$ = this;
					var form = this$.getPostDocInfoForm();
					var financialResourceOne = form.down("#financialResourceTwoItemId");
					var financialResourceChildOne = form.down("#financialResourceChildTwoItemId");
					financialResourceChildOne.reset();
					financialResourceChildOne.clearValue();
					var financialResourceId=combo.getValue();
					var financialOneStore = financialResourceOne.getStore();
					var financialChildOneStore = financialResourceChildOne.getStore();
					financialChildOneStore.getProxy().extraParams={
						id:financialResourceId,
					}
					financialChildOneStore.load({
						callback: function(records, operation, success) {
							if (success) {
								financialResourceChildOne.setDisabled(false);
								if(records.length==1){
									financialResourceChildOne.setValue(records[0].data.id);
								}
							}

						}

					});



				}
			},
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] customcombobox[itemId=financialResourceThreeItemId]': {
				select: function(combo){
					var this$ = this;
					var form = this$.getPostDocInfoForm();
					var financialResourceOne = form.down("#financialResourceThreeItemId");
					var financialResourceChildOne = form.down("#financialResourceChildThreeItemId");
					financialResourceChildOne.reset();
					financialResourceChildOne.clearValue();
					var financialResourceId=combo.getValue();
					var financialOneStore = financialResourceOne.getStore();
					var financialChildOneStore = financialResourceChildOne.getStore();
					financialChildOneStore.getProxy().extraParams={
						id:financialResourceId,
					}
					financialChildOneStore.load({
						callback: function(records, operation, success) {
							if (success) {
								financialResourceChildOne.setDisabled(false);
								if(records.length==1){
									financialResourceChildOne.setValue(records[0].data.id);
								}
							}

						}

					});



				}
			},
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] customcombobox[itemId=financialResourceFourItemId]': {
				select: function(combo){
					var this$ = this;
					var form = this$.getPostDocInfoForm();
					var financialResourceOne = form.down("#financialResourceFourItemId");
					var financialResourceChildOne = form.down("#financialResourceChildFourItemId");
					financialResourceChildOne.reset();
					financialResourceChildOne.clearValue();
					var financialResourceId=combo.getValue();
					var financialOneStore = financialResourceOne.getStore();
					var financialChildOneStore = financialResourceChildOne.getStore();
					financialChildOneStore.getProxy().extraParams={
						id:financialResourceId,
					}
					financialChildOneStore.load({
						callback: function(records, operation, success) {
							if (success) {
								financialResourceChildOne.setDisabled(false);
								if(records.length==1){
									financialResourceChildOne.setValue(records[0].data.id);
								}
							}

						}

					});



				}
			},

			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] button[itemId=uploadPostDocItemId]' : {
				click : function() {
					this.getDocumentController().showDocumentFormWindow('student_post_doc_hidden_field','DOCUMENT');
				}
			},
			'documentformwindow[itemId=student_post_doc_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
				click : function() {
					var $this = this;
					var isTransient = true;
					var module = 'postDocInfo';
					var entityId;
					var entityType = 'postDocInfoDocument';

					$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
							function(success,response,isCallBackTransient) {
						var documentModel = new Academia.model.personinfo.student.PostDocInfoDocumentModel();
						documentModel.set("documentName",response.name);
						documentModel.set("path",response.path);
						documentModel.set("type",response.type);
						documentModel.set("documentName",response.name);
						documentModel.set("createdBy",$this.getIdValueJson(
								response.createdBy.id,response.createdBy.value));
						var postDocInfoDocGrid = $this.getPostdocinfodocumentgrid();
						var store = postDocInfoDocGrid.getStore();
						store.add(documentModel);
						if (postDocInfoDocGrid.isHidden() && store.data.items.length > 0) {
							postDocInfoDocGrid.setVisible(true);
						}
						$this.getDocumentController().closeDocumentFormWindow();

					}, isTransient);
					showSuccessMessage(getPersonModuleTranslation('STUDENT_POST_DOC_INFO'),getPersonModuleTranslation('STUDENT_POST_DOC_INFO_DOCUMENT_ADD_SUCCESSFULLY'));
				}
			},
			'documentformwindow[itemId=student_post_doc_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
				click : function() {
					this.getDocumentController()
					.closeDocumentFormWindow();
				}
			},
			'personcommonwindow[itemId=personCommonWindow] postdocinfoform[itemId=studentPostDocInfoForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.saveStudentPostDocInfo('#studentpostinfogridId', SERVERURL.PATH_STUDENT_POST_DOC_INFO_SAVE, SERVERURL.PATH_STUDENT_POST_DOC_INFO_UPDATE);
            	}
            },
			'postdocinfodocumentgrid button#btnDelete' : {
				 click : function() {
					 var $this = this;
					 var grid = $this.getPostdocinfodocumentgrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 Ext.MessageBox
						 .confirm(
								 getPersonModuleTranslation('STUDENT_POST_DOC_INFO'),
								 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								 function(btn,
										 text) {
									 if (btn == 'yes') {
										 var store = grid.getStore();
										 var record = grid.getSelectionModel().getSelection()[0];
										 var id = record.get("id");
										 if (isNullOrEmpty(id)) {
										 }else{
											 if (record) {
												 store.remove(record);
												 showSuccessMessage(
														 getPersonModuleTranslation('STUDENT_POST_DOC_INFO'),
														 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
											 }
										 }

									 }
								 });
					 } else {
						 showWarningMessage(
								 getPersonModuleTranslation('STUDENT_POST_DOC_INFO'),
								 getCommonTranslation('PLEASE_SELECT_RECORD')); 
					 }
				 }
			 },
			 'postdocinfodocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this
					 .getPostdocinfodocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record
							 .get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }
				
					 }
				 }
			 },
			 'studentjointdegreedocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this
					 .getStudentjointdegreedocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record
							 .get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
			    /**
				 * Functionary Progress Report Section
				 */
			 'personcommonwindow[itemId=personCommonWindow] functionaryprogressreportform[itemId=functionaryprogressreportformId] combo[name=responsibleFunctionaryEmployeeID]': {
	                select: function(combo, records, eOpts) {
	                	var form = combo.up('functionaryprogressreportform');
	                	var firstName =  form.down('#name');
	                	var lastName =  form.down('#lastName');
	                	firstName.setValue(records[0].data.firstName);
	                	lastName.setValue(records[0].data.lastName);
	                }
	            },
			    'functionaryprogressreportgrid[itemId=functionaryprogressreportgridId]': {
		            render: function(grid) {
		            	var me = this;
		            	grid.getSelectionModel().deselectAll();
		            	this.loadGridStore('#functionaryprogressreportgridId', SERVERURL.FUNCTIONARY_PROGRESS_REPORT_GRID,grid);
	                	if(portalId == 2){
	                		me.doAccessControlValidation(grid,this.getFACULTY_FUNCTIONARY_PROGRESS_REPORT_PERMISSION());
	                	}else{
	                		me.doAccessControlValidation(grid, this.getCORE_ERP_FUNCTIONARY_PROGRESS_REPORT());
	                	}
		            } ,
			  				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
			  					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//			  					var documentId = record.data.document.id;
			  					if(columnName == "functionaryProgressReportDocuments"){
			  						if(e.target.tagName=='A'){
			  							if(record.data.functionaryProgressReportDocuments.length == 1){
			  								var whetherFile = false;
			  								var documentId= record.data.functionaryProgressReportDocuments["0"].id;
			  								if(!isNullOrEmpty(documentId)){
			  									Ext.Ajax.request({
			  										type: 'rest',
			  										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
			  										method: 'GET',
			  										callback : function(opt, success, response){
			  											if(response.responseText == 'true') {
			  												var csvForm = Ext.create('Ext.form.Panel'); 
			  												csvForm.getForm().submit({
			  													target: '_blank',
			  													method:'GET',
			  													params :{
			  														access_token : Ext.Ajax.defaultHeaders.access_token
			  													},
			  													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			  													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
			  													standardSubmit :true
			  												});
			  											} else {
			  												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
			  											}
			  										}
			  									});
			  								}} else if(record.data.functionaryProgressReportDocuments.length > 1){
			  									var docWindow = this.getFunctionaryprogressreportdocumentlist();
			  									var ID = record.data.id;
			  									if (!docWindow) {
			  										// Ext.widget('disciplinaryactiondocumentlist');
			  										docWindow = Ext.widget('functionaryprogressreportdocumentlist',{
			  											itemId:'functionaryProgressReportDocument'
			  										});
			  										//  docWindow = this.getDisciplinaryactiondocumentlist();
			  									}
			  									docWindow.show();
			  									var functionaryprogressreportdocumentlistgrid = docWindow.down('#functionaryprogressreportdocumentlistgridItemId');
			  									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
			  									 var store = functionaryprogressreportdocumentlistgrid.getStore();
			  									  store.getProxy().extraParams = {
			  	             						  ID: record.data.id
			  	             					  };
			  	             					  store.load();
			  								}
			  						}
			  					}
			  				}
		        },
		        'functionaryprogressreportgrid[itemId=functionaryprogressreportgridId] button[itemId=btnAdd]': {
		        	  click : function() {
		        		  var this$ = this;
		        		  var formWindow = this$.showPersonCommonWindow('FUNCTIONARY_PROGRESS_REPORT','functionaryprogressreportformId');
		        		  if( formWindow != null ){
		        			  var form = formWindow.down('#functionaryprogressreportformId');
		        			  var auditDate = form.down('#auditDate');
		        			  auditDate.setValue(dateRender(new Date()));
		        			  auditDate.setReadOnly(true);
		        			  var user = this$.getCurrentlyLoggedInUser();
		        			  var auditId = form.down('#auditId');
		        			  auditId.setValue(user.code+'/'+user.value); 
		        		}
		        	 }
		          },
		          'functionaryprogressreportform[itemId=functionaryprogressreportformId]  button[itemId=submitButtonId]': {
		        	  click: function(){
		        		  this.saveFunctionaryProgressReport('#functionaryprogressreportgridId', SERVERURL.FUNCTIONARY_PROGRESS_REPORT_ADD, SERVERURL.FUNCTIONARY_PROGRESS_REPORT_UPDATE);
		        	  }
		          },

		          'functionaryprogressreportgrid[itemId=functionaryprogressreportgridId] button[itemId=btnDelete]': {
		            	click: function(){
		          		this.deleteFunctionaryProgressReportRecord('#functionaryprogressreportgridId', SERVERURL.FUNCTIONARY_PROGRESS_REPORT_DELETE);
		          	}
		          },
		          'functionaryprogressreportgrid[itemId=functionaryprogressreportgridId] button[itemId=btnEdit]': {
		        	  click : function() {
		        		  this.editFunctionaryProgressReport('FUNCTIONARY_PROGRESS_REPORT','functionaryprogressreportformId','#functionaryprogressreportgridId');
		        		  this.functionaryProgressReportDocumentContainerWindow();
		        		  }
		          },
		          'functionaryprogressreportform[itemId=functionaryprogressreportformId] button[itemId=cancelButtonId]': {
		            	click: this.closePersonCommonWindow
		          },
		          'documentformwindow[itemId=functionary_progress_report_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		  	    	click : function() {
		  			var $this = this;
		  			var isTransient = true;
		  			var module = 'functionaryProgressReport';
		  			var entityId;
		  			var entityType = 'functionaryProgressReportDocument';
		  			
		  			var docForm = $this.getSimpledocumentform();
			  			var newcont=docForm.items.items.length;
				 		var insertPosition=newcont+1;
			  			var fieldContainer = docForm.down('#containerIdForButtons');
			  			fieldContainer.setVisible(false);
			  			var panelItem = new Array();
			  			panelItem.push({
			 				xtype : 'fieldcontainer',
			 				width: '100%',
			 				layout : 'hbox',
			 				defaults: {
			 					labelAlign: 'top'
			 				},
			 				items : [{
			 					xtype : 'button',
			 					text : 'Processing...',
			 					buttonAlign : 'right',
			 					ui : 'CustomBtnSubmit',
			 					scale : CONSTANTS.BUTTONSIZE
			 				}]
			  			 });
			  			docForm.insert(insertPosition,panelItem);
			  			docForm.doLayout();

		  			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		  					function(success,response,isCallBackTransient) {
		  				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','functionaryProgressReport','serialNo']
		  						var documentModel = new Academia.model.student.postgraduatemanagement.FunctionaryProgressReportDocumentModel();
		  						documentModel.set("documentName",response.name);
		  						documentModel.set("path",response.path);
		  						documentModel.set("type",response.type);
		  						documentModel.set("documentName",response.name);
		  						documentModel.set("createdBy",$this.getIdValueJson(
		  										response.createdBy.id,response.createdBy.value));
		  						var functionaryProgressReportDocumentGrid = $this.getFunctionaryprogressreportdocumentgrid();
		  						var store = functionaryProgressReportDocumentGrid.getStore();
		  						store.add(documentModel);
		  						if (functionaryProgressReportDocumentGrid.isHidden() && store.data.items.length > 0) {
		  							functionaryProgressReportDocumentGrid.setVisible(true);
		  						}
		  						$this.getDocumentController().closeDocumentFormWindow();
		  						   showSuccessMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_DOCUMENT_ADD_SUCCESSFULLY'));
		  					}, isTransient);
		  		}
		  	},
		  	'documentformwindow[itemId=functionary_progress_report_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		  		click : function() {
		  			this.getDocumentController()
		  			.closeDocumentFormWindow();
		  		}
		  	},
		     'functionaryprogressreportform[itemId=functionaryprogressreportformId] button#uploadFunctionaryProgressReportItemId' : {
		  			click : function() {
		  				this.getDocumentController().showDocumentFormWindow('functionary_progress_report_hidden_field','DOCUMENT');
		  			}
		  		},
		  		'functionaryprogressreportdocumentgrid button#btnDelete' : {
		  			 click : function() {
		  				 var $this = this;
		  				 var grid = $this.getFunctionaryprogressreportdocumentgrid();
		  				 if (grid.getSelectionModel().getCount() > 0) {
		  					 Ext.MessageBox
		  					 .confirm(
		  							 getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),
		  							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
		  							function(btn, text) {
		  								 if (btn == 'yes') {
		  									 var store = grid.getStore();
		  									 var record = grid.getSelectionModel().getSelection()[0];
		  									 var id = record.id;
		  									 if (isNullOrEmpty(id)) {
		  									 }else{
		  										 if (record) {
		  											 store.remove(record);
		  											 showSuccessMessage(
		  													 getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),
		  													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
		  										 }
		  									 }

		  								 }
		  							 });
		  				 } else {
		  					 showWarningMessage(
		  							 getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),
		  							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
		  				 }
		  			 }
		  		 },

		  			'functionaryprogressreportdocumentlistgrid':{
		  				render: function(grid) {
		  					//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
		  				},
		  				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		  					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
		  					if(columnName == "documentName"){
		  						if(e.target.tagName=='A'){
		  							this.getDownloadFile(record.get('documentId'));
		  						}
		  					}
		  				}
		  			},
		  			'functionaryprogressreportdocumentlistgrid button[itemId=downloadDocumentItemId]':{
		  				click:function(obj){
		  					var $this = this;
		  					var form = $this.getFunctionaryprogressreportdocumentlist();
		  					var functionaryprogressreportActionGrid=form.down('#functionaryprogressreportdocumentlistgridItemId');
		  					if (functionaryprogressreportActionGrid.getSelectionModel().getCount() > 0) {
		  						var records = functionaryprogressreportActionGrid.getSelectionModel().getSelection();
		  						var dispatchZipName = "Functionary Progress Report Document";
		  						var saveModel=[];  
		  						for(var i in records){
		  							if(!isNullOrEmpty(records[i].get('path'))) {
		  								saveModel.push(records[i].get('path'));
		  							}
		  							showConfirmMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_DOCUMENTS'),
		  									getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_DOCUMENTS_ALERT'),
		  									function(btn, text) {
		  								if (btn == 'yes') {
		  									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
		  									$this.getController('Academia.controller.document.DocumentController')
		  									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
		  								}
		  							});

		  						}
		  					}
		  					else {
		  						$this.hideWindowMask();
		  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		  					}
		  					//this.documentReportDocumentZip('student');
		  				}
		     	 },
		     	 'functionaryprogressreportdocumentlistgrid button[itemId=btnDelete]':{
		  				click:function(obj){
		  					var $this=this;
		  					var form = $this.getFunctionaryprogressreportdocumentlist();  
		  					var functionaryprogressreportlist= $this.getFunctionaryprogressreportgrid();
		  					var functionaryprogressreport = this.getFunctionaryprogressreportdocumentgrid();
		  					var functionaryprogressreportlistgrid=form.down('#functionaryprogressreportdocumentlistgridItemId');
		  					if (functionaryprogressreportlistgrid.getSelectionModel().getCount() > 0) {
		  						var records = functionaryprogressreportlistgrid.getSelectionModel().getSelection();
		  						var ids=[];
		  						Ext.Array.each(records,function(value){
		  							ids.push(value.data.id);
		  						});
		  						showConfirmMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
		  							if (btn == 'yes'){
		  								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		  								Ext.Ajax.request({
		  									method: "DELETE",
		  									type: 'rest',
		  									url : SERVERURL.PATH_FUNCTIONARY_PROGRESS_REPORT_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
		  									headers: {
		  										'Content-Type': 'application/json'
		  									},
		  									success: function(form, action) {

		  										Ext.getBody().unmask();
		  										showSuccessMessage(getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
		  										functionaryprogressreportlistgrid.store.reload();
		  										functionaryprogressreportlist.store.reload();
		  										functionaryprogressreportlistgrid.getSelectionModel().deselectAll(true);
		  									}
		  								});
		  							}
		  						});
		  					} else {
		  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		  					}
		  				}
		      	 },
		      
		       'functionaryprogressreportdocumentgrid' : {
		  			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
		  				 var $this = this;
		  				 var documentGrid = $this
		  				 .getFunctionaryprogressreportdocumentgrid();
		  				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
		  				 if (columnName == "documentName") {
		  					 if (e.target.tagName == 'A') {
		  						 var documentId = record
		  						 .get("documentId");
		  						 if (!isNullOrEmpty(documentId)) {
		  							 $this.getDocumentController().downloadDocumentFile(documentId);
		  						 }
		  					 }

		  				 }
		  			 }
			          },
				  		/**
						 * Student Ethics Clearance Letter Section
						 */
						'studentethicsclearancelettergrid[itemId=studentethicsclearancelettergridId]': {
			                render: function(grid) {
			                	var me = this;
			                	grid.getSelectionModel().deselectAll();
			                	this.loadGridStore('#studentethicsclearancelettergridId', SERVERURL.PATH_STUDENT_ETHICS_CLEARANCE_LETTER_GRID,grid);
			                	if(portalId == 3){
			                		me.doAccessControlValidation(grid, me.getSTUDENT_PORTAL_STUDENT_ETHICS_CLEARANCE_LETTER_PERMISSIONS());
			                	}else if(portalId == 2){
			                		me.doAccessControlValidation(grid,this.getFACULTY_STUDENT_ETHICS_CLEARANCE_LETTER_PERMISSION());
			                	}else{
			                		me.doAccessControlValidation(grid, this.getCORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER());
			                	}
			                },
			                cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
			  					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//			  					var documentId = record.data.document.id;
			  					if(columnName == "studentEthicsClearanceLetterDocuments"){
			  						if(e.target.tagName=='A'){
			  							if(record.data.studentEthicsClearanceLetterDocuments.length == 1){
			  								var whetherFile = false;
			  								var documentId= record.data.studentEthicsClearanceLetterDocuments["0"].id;
			  								if(!isNullOrEmpty(documentId)){
			  									Ext.Ajax.request({
			  										type: 'rest',
			  										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
			  										method: 'GET',
			  										callback : function(opt, success, response){
			  											if(response.responseText == 'true') {
			  												var csvForm = Ext.create('Ext.form.Panel'); 
			  												csvForm.getForm().submit({
			  													target: '_blank',
			  													method:'GET',
			  													params :{
			  														access_token : Ext.Ajax.defaultHeaders.access_token
			  													},
			  													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			  													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
			  													standardSubmit :true
			  												});
			  											} else {
			  												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
			  											}
			  										}
			  									});
			  								}} else if(record.data.studentEthicsClearanceLetterDocuments.length > 1){
			  									var docWindow = this.getStudentethicsclearanceletterdocumentlist();
			  									var ID = record.data.id;
			  									if (!docWindow) {
			  										// Ext.widget('disciplinaryactiondocumentlist');
			  										docWindow = Ext.widget('studentethicsclearanceletterdocumentlist',{
			  											itemId:'studentEthicsClearanceLetterDocument'
			  										});
			  										//  docWindow = this.getDisciplinaryactiondocumentlist();
			  									}
			  									docWindow.show();
			  									var studentethicsclearanceletterdocumentlistgrid = docWindow.down('#studentethicsclearanceletterdocumentlistgridItemId');
			  									//studentpostdocinfodocumentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
			  									 var store = studentethicsclearanceletterdocumentlistgrid.getStore();
			  									  store.getProxy().extraParams = {
			  	             						  ID: record.data.id
			  	             					  };
			  	             					  store.load();
			  								}
			  						}
			  					}
			  				}
			            },
			            'studentethicsclearancelettergrid[itemId=studentethicsclearancelettergridId] button[itemId=btnAdd]': {
				        	  click : function() {
				        		  var this$ = this;
				        		  var formWindow = this$.showPersonCommonWindow('STUDENT_ETHICS_CLEARANCE_LETTER','studentethicsclearanceletterformId');
				        		  if( formWindow != null ){
				        			  var form = formWindow.down('#studentethicsclearanceletterformId');
				        			  var auditDate = form.down('#auditDate');
				        			  auditDate.setValue(dateRender(new Date()));
				        			  auditDate.setReadOnly(true);
				        			  var user = this$.getCurrentlyLoggedInUser();
				        			  var auditId = form.down('#auditId');
				        			  auditId.setValue(user.code+'/'+user.value); 
				        		}
				        	 }
				          },
				          'studentethicsclearanceletterform[itemId=studentethicsclearanceletterformId] button[itemId=cancelButtonId]': {
				            	click: this.closePersonCommonWindow
				          },
				          'studentethicsclearanceletterform[itemId=studentethicsclearanceletterformId]  button[itemId=submitButtonId]': {
				        	  click: function(){
				        		  this.saveStudentEthicsClearanceLetter('#studentethicsclearancelettergridId', SERVERURL.PATH_STUDENT_ETHICS_CLEARANCE_LETTER_ADD, SERVERURL.PATH_STUDENT_ETHICS_CLEARANCE_LETTER_UPDATE);
				        	  }
				          },

				          'studentethicsclearancelettergrid[itemId=studentethicsclearancelettergridId] button[itemId=btnDelete]': {
				            	click: function(){
				          		this.deleteStudentEthicsClearanceLetterRecord('#studentethicsclearancelettergridId', SERVERURL.PATH_STUDENT_ETHICS_CLEARANCE_LETTER_DELETE);
				          	}
				          },
				          'studentethicsclearancelettergrid[itemId=studentethicsclearancelettergridId] button[itemId=btnEdit]': {
				        	  click : function() {
				        		  this.editStudentEthicsClearanceLetter('STUDENT_ETHICS_CLEARANCE_LETTER','studentethicsclearanceletterformId','#studentethicsclearancelettergridId');
				        		  this.studentEthicsClearanceLetterDocumentContainerWindow();
				        		  }
				          },
				          'documentformwindow[itemId=student_ethics_clearance_letter_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
					  	    	click : function() {
					  			var $this = this;
					  			var isTransient = true;
					  			var module = 'studentethicsclearanceletter';
					  			var entityId;
					  			var entityType = 'studentethicsclearanceletterDocument';

					  			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
					  					function(success,response,isCallBackTransient) {
					  				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentethicsclearanceletter','serialNo']
					  						var documentModel = new Academia.model.student.postgraduatemanagement.StudentEthicsClearanceLetterModel();
					  						documentModel.set("documentName",response.name);
					  						documentModel.set("path",response.path);
					  						documentModel.set("type",response.type);
					  						documentModel.set("documentName",response.name);
					  						documentModel.set("createdBy",$this.getIdValueJson(
					  										response.createdBy.id,response.createdBy.value));
					  						var studentEthicsClearanceLetterDocumentGrid = $this.getStudentethicsclearanceletterdocumentgrid();
					  						var store = studentEthicsClearanceLetterDocumentGrid.getStore();
					  						store.add(documentModel);
					  						if (studentEthicsClearanceLetterDocumentGrid.isHidden() && store.data.items.length > 0) {
					  							studentEthicsClearanceLetterDocumentGrid.setVisible(true);
					  						}
					  						$this.getDocumentController().closeDocumentFormWindow();
					  						   showSuccessMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_DOCUMENT_ADD_SUCCESSFULLY'));
					  					}, isTransient);
					  		}
					  	},
					  	'documentformwindow[itemId=student_ethics_clearance_letter_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
					  		click : function() {
					  			this.getDocumentController()
					  			.closeDocumentFormWindow();
					  		}
					  	},
					     'studentethicsclearanceletterform[itemId=studentethicsclearanceletterformId]  button#uploadStudentEthicsClearanceLetterItemId' : {
					  			click : function() {
					  				this.getDocumentController().showDocumentFormWindow('student_ethics_clearance_letter_hidden_field','DOCUMENT');
					  			}
					  		},
					  		'studentethicsclearanceletterdocumentgrid button#btnDelete' : {
					  			 click : function() {
					  				 var $this = this;
					  				 var grid = $this.getStudentethicsclearanceletterdocumentgrid();
					  				 if (grid.getSelectionModel().getCount() > 0) {
					  					 Ext.MessageBox
					  					 .confirm(
					  							 getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),
					  							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
					  							function(btn, text) {
					  								 if (btn == 'yes') {
					  									 var store = grid.getStore();
					  									 var record = grid.getSelectionModel().getSelection()[0];
					  									 var id = record.id;
					  									 if (isNullOrEmpty(id)) {
					  									 }else{
					  										 if (record) {
					  											 store.remove(record);
					  											 showSuccessMessage(
					  													 getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),
					  													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
					  										 }
					  									 }

					  								 }
					  							 });
					  				 } else {
					  					 showWarningMessage(
					  							 getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),
					  							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
					  				 }
					  			 }
					  		 },

					  			'studentethicsclearanceletterdocumentlistgrid':{
					  				render: function(grid) {
					  					//this.doAccessControlValidation(grid, this.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS());
					  				},
					  				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					  					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					  					if(columnName == "documentName"){
					  						if(e.target.tagName=='A'){
					  							this.getDownloadFile(record.get('documentId'));
					  						}
					  					}
					  				}
					  			},
					  			'studentethicsclearanceletterdocumentlistgrid button[itemId=downloadDocumentItemId]':{
					  				click:function(obj){
					  					var $this = this;
					  					var form = $this.getStudentethicsclearanceletterdocumentlist();
					  					var studentethicsclearanceletterActionGrid=form.down('#studentethicsclearanceletterdocumentlistgridItemId');
					  					if (studentethicsclearanceletterActionGrid.getSelectionModel().getCount() > 0) {
					  						var records = studentethicsclearanceletterActionGrid.getSelectionModel().getSelection();
					  						var dispatchZipName = "Student Ethics Clearance Letter Document";
					  						var saveModel=[];  
					  						for(var i in records){
					  							if(!isNullOrEmpty(records[i].get('path'))) {
					  								saveModel.push(records[i].get('path'));
					  							}
					  							showConfirmMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_DOCUMENTS'),
					  									getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_DOCUMENTS_ALERT'),
					  									function(btn, text) {
					  								if (btn == 'yes') {
					  									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
					  									$this.getController('Academia.controller.document.DocumentController')
					  									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
					  								}
					  							});

					  						}
					  					}
					  					else {
					  						$this.hideWindowMask();
					  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					  					}
					  					//this.documentReportDocumentZip('student');
					  				}
					     	 },
					     	 'studentethicsclearanceletterdocumentlistgrid button[itemId=btnDelete]':{
					  				click:function(obj){
					  					var $this=this;
					  					var form = $this.getStudentethicsclearanceletterdocumentlist();  
					  					var studentethicsclearanceletterlist= $this.getStudentethicsclearancelettergrid();
					  					var studentethicsclearanceletter = this.getStudentethicsclearanceletterdocumentgrid();
					  					var studentethicsclearanceletterlistgrid=form.down('#studentethicsclearanceletterdocumentlistgridItemId');
					  					if (studentethicsclearanceletterlistgrid.getSelectionModel().getCount() > 0) {
					  						var records = studentethicsclearanceletterlistgrid.getSelectionModel().getSelection();
					  						var ids=[];
					  						Ext.Array.each(records,function(value){
					  							ids.push(value.data.id);
					  						});
					  						showConfirmMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
					  							if (btn == 'yes'){
					  								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					  								Ext.Ajax.request({
					  									method: "DELETE",
					  									type: 'rest',
					  									url : SERVERURL.PATH_STUDENT_ETHICS_CLEARANCE_LETTER_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
					  									headers: {
					  										'Content-Type': 'application/json'
					  									},
					  									success: function(form, action) {

					  										Ext.getBody().unmask();
					  										showSuccessMessage(getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER'),getCommonTranslation('STUDENT_ETHICS_CLEARANCE_LETTER_DOCUMENT_SUCCESS_DELETE_MSG'));	 
					  										studentethicsclearanceletterlistgrid.store.reload();
					  										studentethicsclearanceletterlist.store.reload();
					  										studentethicsclearanceletterlistgrid.getSelectionModel().deselectAll(true);
					  									}
					  								});
					  							}
					  						});
					  					} else {
					  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					  					}
					  				}
					      	 },
					      
					       'studentethicsclearanceletterdocumentgrid' : {
					  			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					  				 var $this = this;
					  				 var documentGrid = $this
					  				 .getStudentethicsclearanceletterdocumentgrid();
					  				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					  				 if (columnName == "documentName") {
					  					 if (e.target.tagName == 'A') {
					  						 var documentId = record
					  						 .get("documentId");
					  						 if (!isNullOrEmpty(documentId)) {
					  							 $this.getDocumentController().downloadDocumentFile(documentId);
					  						 }
					  					 }

					  				 }
					  			 }
						          },
						 'personcommonwindow[itemId=personCommonWindow] studentexaminersreportform[itemId=studentExaminersReportFormItemId] combo[name=functionaryID]': {
						      select: function(combo, records, eOpts) {
						                	var form = combo.up('studentexaminersreportform');
						                	var firstName =  form.down('#nameItemId');
						                	var lastName =  form.down('#lastNameItemId');
						                	firstName.setValue(records[0].data.firstName);
						                	lastName.setValue(records[0].data.lastName);
						     }
						  },
				          'studentexaminersreportgrid[itemId=studentExaminersReportGridId]': {
				                render: function(grid) {
				                	var me = this;
				                	grid.getSelectionModel().deselectAll();
				                	me.loadGridStore('#studentExaminersReportGridId', SERVERURL.STUDENT_EXAMINERS_REPORT_GRID,grid);
				                	if(portalId == 2){
				                		me.doAccessControlValidation(grid,this.getFACULTY_EXAMINERS_REPORT_PERMISSION());
				                	    var studentProfilePanel = grid.up('studentprofile');
				                	    var structure = studentProfilePanel.down('[region=center]');
                    	                if(structure.body.isScrollable() == false){
				                	      me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                        }
				                	}else{
				                	    me.doAccessControlValidation(grid, me.getCORE_ERP_EXAMINERS_REPORT());
				                		var studentProfilePanel = grid.up('studentprofile');
				                 		var structure = studentProfilePanel.down('[region=center]');
				                 		me.getGridHeaderFreezeStudentProfile(grid,structure,true);
				                	}
				                },
								cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
									var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
									if(columnName == "uploadDocument"){
										if(e.target.tagName=='A'){
											if(record.data.examinersReportDocuments.length == 1){
												var whetherFile = false;
												var documentId= record.data.examinersReportDocuments["0"].id;
												if(!isNullOrEmpty(documentId)){
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
														method: 'GET',
														callback : function(opt, success, response){
															if(response.responseText == 'true') {
																var csvForm = Ext.create('Ext.form.Panel'); 
																csvForm.getForm().submit({
																	target: '_blank',
																	method:'GET',
																	params :{
																		access_token : Ext.Ajax.defaultHeaders.access_token
																	},
																	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																	standardSubmit :true
																});
															} else {
																showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
															}
														}
													});
												}} else if(record.data.examinersReportDocuments.length > 1){
													var docWindow = this.getStudentexaminersreportdocumentlist();
													var ID = record.data.id;
													if (!docWindow) {
														docWindow = Ext.widget('studentexaminersreportdocumentlist',{
															itemId:'studentexaminersreportdocument'
														});
													}
													docWindow.show();
													var studentexaminersreportdocumentlistgrid = docWindow.down('#studentexaminersreportdocumentlistgridItemId');
													 var store = studentexaminersreportdocumentlistgrid.getStore();
													  store.getProxy().extraParams = {
					             						  ID: record.data.id
					             					  };
					             					  store.load();
												}
										}
									}
								}   
				            },
				            'studentexaminersreportgrid[itemId=studentExaminersReportGridId] button[itemId=btnAdd]': {
				            	click : function() {
				            		var this$ = this;
				            		var formWindow = this$.showPersonCommonWindow('STUDENT_EXAMINERS_REPORT_FORM','studentExaminersReportFormItemId');
				            		if( formWindow != null ){
				            			var form = formWindow.down('#studentExaminersReportFormItemId');
				            			var auditDate = form.down('#auditDate');
				            			auditDate.setValue(dateRender(new Date()));
				            			auditDate.setReadOnly(true);
				            			var user = this$.getCurrentlyLoggedInUser();
				            			var auditId = form.down('#auditId');
				            			auditId.setValue(user.code+'/'+user.value);                        
				            			    }
				            		  }
				          },
				          'studentexaminersreportform[itemId=studentExaminersReportFormItemId]  button[itemId=submitButtonId]': {
				        	  click: function(){
				        		  this.saveStudentExaminersReportInfo('#studentExaminersReportGridId', SERVERURL.STUDENT_EXAMINERS_REPORT_ADD, SERVERURL.STUDENT_EXAMINERS_REPORT_UPDATE);
				        	  }
				          },
				          'studentexaminersreportgrid[itemId=studentExaminersReportGridId] button[itemId=btnEdit]': {
				        	  click : function() {
				        		  this.editStudentExaminersReportInfo('STUDENT_EXAMINERS_REPORT_FORM','studentExaminersReportFormItemId','#studentExaminersReportGridId');
				        		  this.studentExaminersReportDocumentContainerWindow();
				        		  
				        	}
				          },
				          'studentexaminersreportgrid[itemId=studentExaminersReportGridId] button[itemId=btnDelete]': {
				            	click: function(){
					          		this.deleteStudentExaminersReportRecord('#studentExaminersReportGridId', SERVERURL.STUDENT_EXAMINERS_REPORT_DELETE);
					          	}
					      },
					      'studentexaminersreportform[itemId=studentExaminersReportFormItemId] button[itemId=cancelButtonId]': {
				            	click: this.closePersonCommonWindow
				          },
				          'documentformwindow[itemId=studentExaminersReporthidden] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
				  	    	click : function() {
				  			var $this = this;
				  			var isTransient = true;
				  			var module = 'examinersReport';
				  			var entityId;
				  			var entityType = 'examinersReportDocument';

				  			var docForm = $this.getSimpledocumentform();
				  			var newcont=docForm.items.items.length;
					 		var insertPosition=newcont+1;
				  			var fieldContainer = docForm.down('#containerIdForButtons');
				  			fieldContainer.setVisible(false);
				  			var panelItem = new Array();
				  			panelItem.push({
				 				xtype : 'fieldcontainer',
				 				width: '100%',
				 				layout : 'hbox',
				 				defaults: {
				 					labelAlign: 'top'
				 				},
				 				items : [{
				 					xtype : 'button',
				 					text : 'Processing...',
				 					buttonAlign : 'right',
				 					ui : 'CustomBtnSubmit',
				 					scale : CONSTANTS.BUTTONSIZE
				 				}]
				  			 });
				  			docForm.insert(insertPosition,panelItem);
				  			docForm.doLayout();
				  			
				  			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
				  					function(success,response,isCallBackTransient) {
				  				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','examinersReport','serialNo']
				  						var documentModel = new Academia.model.student.postgraduatemanagement.StudentExaminersReportDocumentModel();
				  						documentModel.set("documentName",response.name);
				  						documentModel.set("path",response.path);
				  						documentModel.set("type",response.type);
				  						documentModel.set("documentName",response.name);
				  						documentModel.set("createdBy",$this.getIdValueJson(
				  										response.createdBy.id,response.createdBy.value));
				  						var studentExaminersReportDocumentGrid = $this.getStudentexaminersreportdocumentgrid();
				  						var store = studentExaminersReportDocumentGrid.getStore();
				  						store.add(documentModel);
				  						if (studentExaminersReportDocumentGrid.isHidden() && store.data.items.length > 0) {
				  							studentExaminersReportDocumentGrid.setVisible(true);
				  						}
				  						$this.getDocumentController().closeDocumentFormWindow();
				  						   showSuccessMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'),getCommonTranslation('EXAMINERS_REPORT_DOCUMENT_ADD_SUCCESSFULLY'));
				  					}, isTransient);
				  		}
				  	},
				  	'documentformwindow[itemId=studentExaminersReporthidden] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
				  		click : function() {
				  			this.getDocumentController()
				  			.closeDocumentFormWindow();
				  		}
				  	},
				     'studentexaminersreportform[itemId=studentExaminersReportFormItemId] button#uploadStudentExaminersReportItemId' : {
				  			click : function() {
				  				this.getDocumentController().showDocumentFormWindow('studentExaminersReporthidden','DOCUMENT');
				  			}
				  	},
				  	'studentexaminersreportdocumentgrid button#btnDelete' : {
						 click : function() {
							 var $this = this;
							 var grid = $this.getStudentexaminersreportdocumentgrid();
							 if (grid.getSelectionModel().getCount()>0) {
								 Ext.MessageBox
								 .confirm(
										 getCommonTranslation('STUDENT_EXAMINERS_REPORT'),
										 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
										 function(btn,
												 text) {
											 if (btn == 'yes') {
												 var store = grid.getStore();
												 var record = grid.getSelectionModel().getSelection()[0];
												 var id = record.id;
												 if (isNullOrEmpty(id)) {
												 }else{
													 if (record) {
														 store.remove(record);
														 showSuccessMessage(
																 getCommonTranslation('STUDENT_EXAMINERS_REPORT'),
																 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
													 }
												 }

											 }
										 });
							 } else {
								 showWarningMessage(
										 getCommonTranslation('STUDENT_EXAMINERS_REPORT'),
										 getCommonTranslation('PLEASE_SELECT_RECORD')); 
							 }
						 }
					 },
					 'studentexaminersreportdocumentlistgrid button[itemId=downloadDocumentItemId]':{
			  				click:function(obj){
			  					var $this = this;
			  					var form = $this.getStudentexaminersreportdocumentlist();
			  					var postdocinfoActionGrid=form.down('#studentexaminersreportdocumentlistgridItemId');
			  					if (postdocinfoActionGrid.getSelectionModel().getCount() > 0) {
			  						var records = postdocinfoActionGrid.getSelectionModel().getSelection();
			  						var dispatchZipName = "Student Examiners Report Document";
			  						var saveModel=[];  
			  						for(var i in records){
			  							if(!isNullOrEmpty(records[i].get('path'))) {
			  								saveModel.push(records[i].get('path'));
			  							}
			  							showConfirmMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'),
			  									getCommonTranslation('STUDENT_EXAMINERS_REPORT_DOCUMENTS_ALERT'),
			  									function(btn, text) {
			  								if (btn == 'yes') {
			  									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
			  									$this.getController('Academia.controller.document.DocumentController')
			  									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
			  								}
			  							});

			  						}
			  					}
			  					else {
			  						$this.hideWindowMask();
			  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			  					}
			  				}
			        	 },
						'studentexaminersreportdocumentlistgrid button[itemId=btnDelete]':{
			   				click:function(obj){
			   					var $this=this;
			   					var form = $this.getStudentexaminersreportdocumentlist();  
			   					var studentpostdoclist= $this.getStudentExaminersReportGrid();
			   					var studentpostdoc = this.getStudentexaminersreportdocumentlistgrid();
			   					var studentpostdoclistgrid=form.down('#studentexaminersreportdocumentlistgridItemId');
			   					if (studentpostdoclistgrid.getSelectionModel().getCount() > 0) {
			   						var records = studentpostdoclistgrid.getSelectionModel().getSelection();
			   						var ids=[];
			   						Ext.Array.each(records,function(value){
			   							ids.push(value.data.id);
			   						});
			   						showConfirmMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
			   							if (btn == 'yes'){
			   								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			   								Ext.Ajax.request({
			   									method: "DELETE",
			   									type: 'rest',
			   									url : SERVERURL.PATH_STUDENT_EXAMINERS_REPORT_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
			   									headers: {
			   										'Content-Type': 'application/json'
			   									},
			   									success: function(form, action) {

			   										Ext.getBody().unmask();
			   										showSuccessMessage(getCommonTranslation('STUDENT_EXAMINERS_REPORT'),getCommonTranslation('STUDENT_EXAMINERS_REPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
			   										studentpostdoclistgrid.store.reload();
			   										studentpostdoclist.store.reload();
			   										studentpostdoclistgrid.getSelectionModel().deselectAll(true);
			   									}
			   								});
			   							}
			   						});
			   					} else {
			   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			   					}
			   				}
			         	 },
			         	 'studentexaminersreportdocumentlistgrid[itemId=studentexaminersreportdocumentlistgridItemId]':{
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
								if(columnName == "documentName"){
									if(e.target.tagName=='A'){
										this.getDownloadFile(record.get('documentId'));
									}
								}
							}
						},
						 'personcommonwindow[itemId=personCommonWindow] functionarydetailsform[itemId=studentFunctionaryDetailsForm] combo[name=functionaryUserId]': {
						      select: function(combo, records, eOpts) {
						                	var form = combo.up('functionarydetailsform');
						                	var functionaryDepartment =  form.down('#functionaryDepartmentItemId');
						                	functionaryDepartment.setValue(records[0].data.code);
						     }
						  },
						  'personcommonwindow[itemId=personCommonWindow] functionarydetailsform[itemId=studentFunctionaryDetailsForm] statusCombo[name=activeStatus]': {
						      select: function(combo, records, eOpts) {
						                	var form = combo.up('functionarydetailsform');
						                	
						                	
						                	var activestatus =  form.down('#activeStatusItemId').getValue();
						                	if(this.functionary=='EDIT'){
						                		if(!isNullOrEmpty(activestatus) && activestatus==true ){
							                		 form.down('#functionaryInvolvementInPercentageItemId').reset();
						                	}
						                	
						           }
						     }
						  },
						  'personcommonwindow[itemId=personCommonWindow] functionarydetailsform[itemId=studentFunctionaryDetailsForm] customcombobox[name=functionaryType]': {
						      select: function(combo, records, eOpts) {
						    	            var $this=this;
						                	var form = combo.up('functionarydetailsform');
						                	var functionaryType =  form.down('#functionaryTypeItemId');
						                	var functionaryTypeValue=functionaryType.getValue();
						                	if(records[0].data.displayValue == 'PostDoc Host'){
						                		form.down('#functionaryInvolvementInPercentageItemId').setReadOnly(true);
						                		form.down('#functionaryInvolvementInPercentageItemId').reset();
				            					 this.setAllowBlank(form.down('#functionaryInvolvementInPercentageItemId'), true);
						                	}else{
						                		form.down('#functionaryInvolvementInPercentageItemId').setReadOnly(false);
						                		this.setAllowBlank(form.down('#functionaryInvolvementInPercentageItemId'), false);
						                	}
						               }
						  },	
						'functionarydetailsgrid[itemId=functionarydetailsgridId]': {
							render: function(grid) {
								var me = this;
		        	        	grid.getSelectionModel().deselectAll();
							  	me.loadGridStore('#functionarydetailsgridId', SERVERURL.PATH_STUDENT_FUNCTIONARY_DETAILS_GRID_DATA,grid);
			                	if(portalId == 2){
			                		me.doAccessControlValidation(grid,this.getFACULTY_FUNCTIONARY_DETAILS_PERMISSION());
							  	    var studentProfilePanel = grid.up('studentprofile');
			             		    var structure = studentProfilePanel.down('[region=center]');
			             		    if(structure.body.isScrollable() == false){
				                       me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                    }
			                	}else{
				    	    	    me.doAccessControlValidation(grid, this.getCORE_ERP_FUNCTIONARY_DETAILS());
			                		var studentProfilePanel = grid.up('studentprofile');
			                 		var structure = studentProfilePanel.down('[region=center]');
			                 		me.getGridHeaderFreezeStudentProfile(grid,structure,true);
			                	}
							}   
						},
						'functionarydetailsgrid[itemId=functionarydetailsgridId] button#btnAdd' : {
							click : function() {
								var this$ = this;
								this.functionary='ADD';
								var admissionId;
								if(this.getContentPanelActiveTab()!=null){
									 admissionId=this.getContentPanelActiveTab().admissionId;
								}
								var formWindow = this$.showPersonCommonWindow('FUNCTIONARY_DETAILS','studentFunctionaryDetailsForm');
								if( formWindow != null ){
									var form = formWindow.down('#studentFunctionaryDetailsForm');
									var admCode=form.down('#admission_hidden_field');
									var auditDate = form.down('#auditDateItemId');
									auditDate.setValue(dateRender(new Date()));
									auditDate.setReadOnly(true);
									var admissionIds = form.down('#admissionIdItemId');
									//admissionIds.setReadOnly(true);
									var user = this$.getCurrentlyLoggedInUser();
									var auditId = form.down('#auditIdItemId');
									auditId.setValue(user.code+'/'+user.value);
									var userId = this.getUserInfo();	
									var admissionId=this.getContentPanelActiveTab().admissionId;
					        		
									admissionIds.getStore().getProxy().extraParams = {
										studentId : userId 
				            		};
									admissionIds.getStore().load({
										callback : function(records){
											for(var i in records){
												   if(records[i].data.admissionID==admissionId){
														admissionIds.setValue(records[i].data.admissionID);
														admCode.setValue(records[i].data.admissionValue);
												   }
											   }
									}
		    		    			});
								}
							}
						},
						
						'functionarydetailsform[itemId=studentFunctionaryDetailsForm] customcombobox[itemId=admissionIdItemId]': {
				          	  select:function(rowModel, record, index, eOpts) {
						            var form = this.getFunctionaryDetailsForm();
									var admCode=form.down('#admission_hidden_field');
									var admissionIds = form.down('#admissionIdItemId');
									var userId = this.getUserInfo();						        		
									admissionIds.getStore().getProxy().extraParams = {
										studentId : userId 
				            		};
									admissionIds.getStore().load({
										callback : function(records){
											for(var i in records){
												   if(records[i].data.admissionID==admissionIds.getValue()){
														admCode.setValue(records[i].data.admissionValue);
												   }
											   }
									}
		    		    			});
								
				          	  }
				            },

						'functionarydetailsgrid[itemId=functionarydetailsgridId] button#btnEdit' : {
							click : function() {
							this.functionary='EDIT';
							this.editStudentFunctionaryDetailsFormWindow('FUNCTIONARY_DETAILS','studentFunctionaryDetailsForm','#functionarydetailsgridId');
							}
						},
						'functionarydetailsgrid[itemId=functionarydetailsgridId] button[itemId=btnDelete]': {
			            	click: function(){
			            		this.deleteStudentFunctionaryDetails('#functionarydetailsgridId', SERVERURL.PATH_STUDENT_FUNCTIONARY_DETAILS_DELETE);
			            	}
						},
						'personcommonwindow[itemId=personCommonWindow] functionarydetailsform[itemId=studentFunctionaryDetailsForm] button[itemId=cancelButtonId]': {
							click: this.closePersonCommonWindow
						},
						'personcommonwindow[itemId=personCommonWindow] functionarydetailsform[itemId=studentFunctionaryDetailsForm] button[itemId=submitButtonId]': {
							click: function(){
								this.saveStudentFunctionaryDetails('#functionarydetailsgridId', SERVERURL.PATH_STUDENT_FUNCTIONARY_DETAILS_SAVE, SERVERURL.PATH_STUDENT_FUNCTIONARY_DETAILS_UPDATE);
							}
						},
						 'studentexaminersreportdocumentgrid' : {
							 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
								 var $this = this;
								 var documentGrid = $this.getStudentexaminersreportdocumentgrid();
								 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
								 if (columnName == "documentName") {
									 if (e.target.tagName == 'A') {
										 var documentId = record
										 .get("documentId");
										 if (!isNullOrEmpty(documentId)) {
											 $this.getDocumentController().downloadDocumentFile(documentId);
										 }
									 }

								 }
							 }
						 },
						 'studentthesisuploadgrid[itemId=studentThesisUploadGridId]': {
				                render: function(grid) {
				                	var me = this;
				                	var personProfile = this.getContentPanelActiveTab()
				                	grid.getSelectionModel().deselectAll();
				                	me.loadGridStore('#studentThesisUploadGridId', SERVERURL.PATH_STUDENT_THESIS_UPLOAD_GRID_DATA,grid);
				                	if(portalId == 2){
				                		me.doAccessControlValidation(grid,this.getFACULTY_STUDENT_THESIS_UPLOAD_PERMISSION());
				                	    var studentProfilePanel = grid.up('studentprofile');
				                	    var structure = studentProfilePanel.down('[region=center]');
				                	    if(structure.body.isScrollable() == false){
				                	      me.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                        }
				                	}else{
				                	    me.doAccessControlValidation(grid, me.getCORE_ERP_STUDENT_THESIS_UPLOAD());
				                		var studentProfilePanel = grid.up('studentprofile');
				                 		var structure = studentProfilePanel.down('[region=center]');
				                 		me.getGridHeaderFreezeStudentProfile(grid,structure,true);
				                	}
				                	 var associatedAcadLocationIds = new Array();
				                      associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
				                     var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,  me.getCORE_ERP_STUDENT_THESIS_UPLOAD());
				                     grid.down('#userExamPanel').setVisible(false);
				                     if(permissionList.indexOf('USER_SEARCH') !== -1){
				                    	 grid.down('#userExamPanel').setVisible(true);
				                     }
				                     grid.down('#userExamPanel').getStore().getProxy().extraParams = {
				                    	 personId: personProfile.getPersonId()
	             					  };
				                },
								cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
									var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
									if(columnName == "studentThesisUploadDocuments"){
										if(e.target.tagName=='A'){
											if(record.data.studentThesisUploadDocuments.length == 1){
												var whetherFile = false;
												var documentId= record.data.studentThesisUploadDocuments["0"].id;
												if(!isNullOrEmpty(documentId)){
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
														method: 'GET',
														callback : function(opt, success, response){
															if(response.responseText == 'true') {
																var csvForm = Ext.create('Ext.form.Panel'); 
																csvForm.getForm().submit({
																	target: '_blank',
																	method:'GET',
																	params :{
																		access_token : Ext.Ajax.defaultHeaders.access_token
																	},
																	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																	standardSubmit :true
																});
															} else {
																showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
															}
														}
													});
												}} else if(record.data.studentThesisUploadDocuments.length > 1){
													var docWindow = this.getStudentthesisuploaddocumentlist();
													var ID = record.data.id;
													if (!docWindow) {
														docWindow = Ext.widget('studentthesisuploaddocumentlist',{
															itemId:'studentthesisuploaddocumentlist'
														});
													}
													docWindow.show();
													var studentthesisuploaddocumentlistgrid = docWindow.down('#studentthesisuploaddocumentlistgridItemId');
													 var store = studentthesisuploaddocumentlistgrid.getStore();
													  store.getProxy().extraParams = {
					             						  ID: record.data.id
					             					  };
					             					  store.load();
												}
										}
									}
								},
								selectionchange:function(cmp, selected){
									var grid = this.getStudentThesisUploadGrid(),
									editBtn = grid.down('#btnEdit'),
									deleteBtn = grid.down('#btnDelete');
									if(selected.length == 1){
										editBtn.setDisabled(false);
										deleteBtn.setDisabled(false);
									}else{
										editBtn.setDisabled(true);
										deleteBtn.setDisabled(true);
									}
								}
				            },
				            'studentthesisuploadgrid[itemId=studentThesisUploadGridId] button[itemId=btnAdd]': {
				            	click : function() {
				            		var this$ = this;
				            		var formWindow = this$.showPersonCommonWindow('STUDENT_THESIS_UPLOAD_FORM','studentThesisUploadFormItemId');
				            		if( formWindow != null ){
				            			var form = formWindow.down('#studentThesisUploadFormItemId');
				            			var auditDate = form.down('#auditDate');
				            			auditDate.setValue(dateRender(new Date()));
				            			auditDate.setReadOnly(true);
				            			var user = this$.getCurrentlyLoggedInUser();
				            			var auditId = form.down('#auditId');
				            			auditId.setValue(user.code+'/'+user.value);                        
				            			    }
				            		  }
				          },
				          'studentthesisuploadform[itemId=studentThesisUploadFormItemId]  button[itemId=submitButtonId]': {
				        	  click: function(){
				        		  this.saveStudentThesisUploadInfo('#studentThesisUploadGridId', SERVERURL.PATH_STUDENT_THESIS_UPLOAD_SAVE, SERVERURL.PATH_STUDENT_THESIS_UPLOAD_UPDATE);
				        	  }
				          },
				          'studentthesisuploadgrid[itemId=studentThesisUploadGridId] button[itemId=btnEdit]': {
				        	  click : function() {
				        		  this.editStudentThesisUploadInfo('STUDENT_THESIS_UPLOAD_FORM','studentThesisUploadFormItemId','#studentThesisUploadGridId');
				        		  this.studentThesisUploadDocumentContainerWindow();
				        		  
				        	}
				          },
				          'studentthesisuploadgrid[itemId=studentThesisUploadGridId] button[itemId=btnDelete]': {
				            	click: function(){
					          		this.deleteStudentThesisUploadRecord('#studentThesisUploadGridId', SERVERURL.PATH_STUDENT_THESIS_UPLOAD_DELETE);
					          	}
					      },
					      'studentthesisuploadform[itemId=studentThesisUploadFormItemId] button[itemId=cancelButtonId]': {
				            	click: this.closePersonCommonWindow
				          },
				          'studentthesisuploadform[itemId=studentThesisUploadFormItemId] button#uploadStudentThesisItemId' : {
					  			click : function() {
					  				this.getDocumentController().showDocumentFormWindow('studentThesisUploadDocumentFormItemId','DOCUMENT');
					  			}
					  	},
					  	'documentformwindow[itemId=studentThesisUploadDocumentFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
				  	    	click : function(btn) {
				  			var $this = this;
				  			var isTransient = true;
				  			var module = 'studentThesisUpload';
				  			var entityId;
				  			var entityType = 'studentThesisUploadDocument';
				  			var documentSize = btn.up('window').down('fileuploadfield').documentSize;
		     	 			
										$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',function(success,response,isCallBackTransient) {
							  				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','examinersReport','serialNo']
							  						var documentModel = new Academia.model.student.postgraduatemanagement.StudentThesisUploadDocumentModel();
							  						documentModel.set("documentName",response.name);
							  						documentModel.set("path",response.path);
							  						documentModel.set("type",response.type);
							  						documentModel.set("documentSize",documentSize);
							  						documentModel.set("documentName",response.name);
							  						documentModel.set("createdBy",$this.getIdValueJson(
							  										response.createdBy.id,response.createdBy.value));
							  						var studentThesisUploadDocumentGrid = $this.getStudentThesisUploadDocumentGrid();
							  						var store = studentThesisUploadDocumentGrid.getStore();
							  						store.add(documentModel);
							  						if (studentThesisUploadDocumentGrid.isHidden() && store.data.items.length > 0) {
							  							studentThesisUploadDocumentGrid.setVisible(true);
							  						}
							  						$this.getDocumentController().closeDocumentFormWindow();
							  						   showSuccessMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'),getCommonTranslation('STUDENT_THESIS_UPLOAD_DOCUMENT_ADD_SUCCESSFULLY'));
							  					}, isTransient);
									
				  			
				  		}
				  	},
				  	'studentthesisuploaddocumentgrid[itemId=studentThesisUploadDocumentGridItemId] button#btnDelete' : {
						 click : function() {
							 var $this = this;
							 var grid = $this.getStudentThesisUploadDocumentGrid();
							 if (grid.getSelectionModel().getCount()>0) {
								 Ext.MessageBox
								 .confirm(
										 getCommonTranslation('STUDENT_THESIS_UPLOAD'),
										 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
										 function(btn,
												 text) {
											 if (btn == 'yes') {
												 var store = grid.getStore();
												 var record = grid.getSelectionModel().getSelection()[0];
												 var id = record.id;
												 if (isNullOrEmpty(id)) {
												 }else{
													 if (record) {
														 store.remove(record);
														 showSuccessMessage(
																 getCommonTranslation('STUDENT_THESIS_UPLOAD'),
																 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
													 }
												 }

											 }
										 });
							 } else {
								 showWarningMessage(
										 getCommonTranslation('STUDENT_THESIS_UPLOAD'),
										 getCommonTranslation('PLEASE_SELECT_RECORD')); 
							 }
						 }
					 },
					 'studentthesisuploaddocumentgrid[itemId=studentThesisUploadDocumentGridItemId]' : {
						 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							 var $this = this;
							 var documentGrid = $this.getStudentThesisUploadDocumentGrid();
							 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
							 if (columnName == "documentName") {
								 if (e.target.tagName == 'A') {
									 var documentId = record
									 .get("documentId");
									 if (!isNullOrEmpty(documentId)) {
										 $this.getDocumentController().downloadDocumentFile(documentId);
									 }
								 }

							 }
						 }
					 },
					 'studentthesisuploaddocumentlistgrid[itemId=studentthesisuploaddocumentlistgridItemId] button[itemId=downloadDocumentItemId]':{
			  				click:function(obj){
			  					var $this = this;
			  					var form = $this.getStudentthesisuploaddocumentlist();
			  					var thesisUploadDocumentListGrid=form.down('#studentthesisuploaddocumentlistgridItemId');
			  					if (thesisUploadDocumentListGrid.getSelectionModel().getCount() > 0) {
			  						var records = thesisUploadDocumentListGrid.getSelectionModel().getSelection();
			  						var dispatchZipName = "Student Thesis Upload";
			  						var saveModel=[];  
			  						for(var i in records){
			  							if(!isNullOrEmpty(records[i].get('path'))) {
			  								saveModel.push(records[i].get('path'));
			  							}
			  							showConfirmMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'),
			  									getCommonTranslation('STUDENT_THESIS_UPLOAD_DOCUMENTS_ALERT'),
			  									function(btn, text) {
			  								if (btn == 'yes') {
			  									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
			  									$this.getController('Academia.controller.document.DocumentController')
			  									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
			  								}
			  							});

			  						}
			  					}
			  					else {
			  						$this.hideWindowMask();
			  						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			  					}
			  				}
			        	 },
						'studentthesisuploaddocumentlistgrid[itemId=studentthesisuploaddocumentlistgridItemId] button[itemId=btnDelete]':{
			   				click:function(obj){
			   					var $this=this;
			   					var form = $this.getStudentthesisuploaddocumentlist();  
			   					var studentThesisUploadDocList= $this.getStudentThesisUploadGrid();
			   					var studentThesisUploadDocListGrid=form.down('#studentthesisuploaddocumentlistgridItemId');
			   					if (studentThesisUploadDocListGrid.getSelectionModel().getCount() > 0) {
			   						var records = studentThesisUploadDocListGrid.getSelectionModel().getSelection();
			   						var ids=[];
			   						Ext.Array.each(records,function(value){
			   							ids.push(value.data.id);
			   						});
			   						showConfirmMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
			   							if (btn == 'yes'){
			   								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			   								Ext.Ajax.request({
			   									method: "DELETE",
			   									type: 'rest',
			   									url : SERVERURL.PATH_STUDENT_THESIS_UPLOAD_DOCUMENT_DELETE+'?documentIds='+ids.join(),
			   									headers: {
			   										'Content-Type': 'application/json'
			   									},
			   									success: function(form, action) {

			   										Ext.getBody().unmask();
			   										showSuccessMessage(getCommonTranslation('STUDENT_THESIS_UPLOAD'),getCommonTranslation('STUDENT_THESIS_UPLOAD_DOCUMENT_SUCCESS_DELETE_MSG'));	 
			   										studentThesisUploadDocListGrid.store.reload();
			   										studentThesisUploadDocList.store.reload();
			   										studentThesisUploadDocListGrid.getSelectionModel().deselectAll(true);
			   									}
			   								});
			   							}
			   						});
			   					} else {
			   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			   					}
			   				}
			         	 },
			         	 'studentthesisuploaddocumentlistgrid[itemId=studentthesisuploaddocumentlistgridItemId]':{
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
								if(columnName == "documentName"){
									if(e.target.tagName=='A'){
										this.getDownloadFile(record.get('documentId'));
									}
								}
							}
							
						},
						'independentnonexaminingchairpersonreportgrid[itemId=independentnonexaminingchairpersonreportgridId] button[itemId=btnAdd]': {
			            	click : function() {
			            		var this$ = this;
			            		var formWindow = this$.showPersonCommonWindow('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT','independentNonExaminingChairPersonFormItemId');
			            		if( formWindow != null ){
			            			var form = formWindow.down('#independentNonExaminingChairPersonFormItemId');
			            			var auditDate = form.down('#auditDate');
			            			auditDate.setValue(dateRender(new Date()));
			            			auditDate.setReadOnly(true);
			            			var user = this$.getCurrentlyLoggedInUser();
			            			var auditId = form.down('#auditId');
			            			auditId.setValue(user.code+'/'+user.value);                        
			            		}
			            	}
						},
						'independentnonexaminingchairpersonreportgrid[itemId=independentnonexaminingchairpersonreportgridId] button[itemId=btnDelete]': {
							click: function(){
				          		this.deleteIndependentNonExaminingChairPersonInfo('#independentnonexaminingchairpersonreportgridId', SERVERURL.PATH_INDEPENDENT_NONEXAMINING_CHAIRPERSON_DELETE);
				          	}
						},
						'independentnonexaminingchairpersonform[itemId=independentNonExaminingChairPersonFormItemId]  button[itemId=submitButtonId]': {
							click: function(){
								this.saveIndependentNonExaminingChairPersonInfo('#independentnonexaminingchairpersonreportgridId', SERVERURL.PATH_INDEPENDENT_NONEXAMINING_CHAIRPERSON_SAVE, SERVERURL.PATH_INDEPENDENT_NONEXAMINING_CHAIRPERSON_UPDATE);
							}
						},
				      	'independentnonexaminingchairpersonform[itemId=independentNonExaminingChairPersonFormItemId] button[itemId=cancelButtonId]': {
			            	click: this.closePersonCommonWindow
				      	},
			          	'independentnonexaminingchairpersonform[itemId=independentNonExaminingChairPersonFormItemId] button#uploadINECPItemId' : {
			          		click : function() {
				  				this.getDocumentController().showDocumentFormWindow('independentNonExaminingChairPersonUploadDocumentFormItemId','DOCUMENT');
				  			}
				  		},
				  		'documentformwindow[itemId=independentNonExaminingChairPersonUploadDocumentFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
				  	    	click : function() {
				  			var $this = this;
				  			var isTransient = true;
				  			var module = 'independentNonExaminingChairPerson';
				  			var entityId;
				  			var entityType = 'independentNonExaminingChairPersonDocument';
				  			
				  			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',function(success,response,isCallBackTransient) {
				  				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','independentNonExaminingChairPerson','serialNo']
				  						var documentModel = new Academia.model.student.postgraduatemanagement.IndependentNonExaminingChairPersonDocModel();
				  						documentModel.set("documentName",response.name);
				  						documentModel.set("path",response.path);
				  						documentModel.set("type",response.type);
				  						documentModel.set("documentName",response.name);
				  						documentModel.set("createdBy",$this.getIdValueJson(
				  										response.createdBy.id,response.createdBy.value));
				  						var independentNonExaminingChairPersonDocGrid = $this.getIndependentNonExaminingChairPersonDocGrid();
				  						var store = independentNonExaminingChairPersonDocGrid.getStore();
				  						store.add(documentModel);
				  						if (independentNonExaminingChairPersonDocGrid.isHidden() && store.data.items.length > 0) {
				  							independentNonExaminingChairPersonDocGrid.setVisible(true);
				  						}
				  						$this.getDocumentController().closeDocumentFormWindow();
				  						   showSuccessMessage(getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_DOCUMENT_ADD_SUCCESSFULLY'));
				  					}, isTransient);
				  	    	}
				  		},
						'independentnonexaminingchairpersondocgrid[itemId=independentNonExaminingChairPersonDocGridItemId] button#btnDelete' : {
							 click : function() {
								 var $this = this;
								 var grid = $this.getIndependentNonExaminingChairPersonDocGrid();
								 if (grid.getSelectionModel().getCount()>0) {
									 Ext.MessageBox
									 .confirm(
											 getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),
											 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
											 function(btn,
													 text) {
												 if (btn == 'yes') {
													 var store = grid.getStore();
													 var record = grid.getSelectionModel().getSelection()[0];
													 var id = record.id;
													 if (isNullOrEmpty(id)) {
													 }else{
														 if (record) {
															 store.remove(record);
															 showSuccessMessage(
																	 getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),
																	 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
														 }
													 }

												 }
											 });
								 } else {
									 showWarningMessage(
											 getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),
											 getCommonTranslation('PLEASE_SELECT_RECORD')); 
								 }
							 }
						 },
						 'independentnonexaminingchairpersondocgrid[itemId=independentNonExaminingChairPersonDocGridItemId]' : {
							 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
								 var $this = this;
								 var documentGrid = $this.getIndependentNonExaminingChairPersonDocGrid();
								 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
								 if (columnName == "documentName") {
									 if (e.target.tagName == 'A') {
										 var documentId = record
										 .get("documentId");
										 if (!isNullOrEmpty(documentId)) {
											 $this.getDocumentController().downloadDocumentFile(documentId);
										 }
									 }

								 }
							 }
						 },
						 // Student Language information grid rander
						 'studentlanguageinformationgrid[itemId=studentLanguagesInformationGridItemId]': {
				            	render: function(grid) {
				            		var $this = this;
				            		$this.loadGridStore('#studentLanguagesInformationGridItemId', SERVERURL.PATH_STUDENT_LANGUAGE_DETAIL_GRID_DATA,grid);
				            		var portalId = this.getCurrentLoggedPortalId();
				            		if (portalId == 7) {
				            			$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
				            			var structure = grid.up('personinfostudentportal');
				            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				            		}else if (portalId == 2){
				            			$this.doAccessControlValidation(grid,$this.getFACULTY_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
				            			var studentProfilePanel = grid.up('studentprofile');
				            			var structure = studentProfilePanel.down('[region=center]');
				            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				            		}else if (portalId == 3){
				            			$this.doAccessControlValidation(grid,$this.getSTUDENT_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
				    					var structure = grid.up('personinfostudentportal');
				                        $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				            		}else{
				            			$this.doAccessControlValidation(grid,$this.getSTUDENT_LANGUAGE_INFORMATION_PERMISSIONS());
				            			var studentProfilePanel = grid.up('studentprofile');
				            			var structure = studentProfilePanel.down('[region=center]');
				            			   var store = grid.getStore();
				                           store.load({
				                              callback:function() {
				                                  if(store.getCount()>5) {
				                                      $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				                                  }            
				                              }
				                          });
				            		}
				            	},
				            	afterrender:function(grid){
				    				var me = this;
				    				var portalId = this.getCurrentLoggedPortalId();
				            		if (portalId == 7) {
				            			me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
				            		}else if (portalId == 2){
				            			me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
				            		}else if (portalId == 3){
				            			me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_LANGUAGE_INFORMATION_PERMISSIONS());
				            		}else{
				            			me.addDataGridConfigButton(grid,me.getSTUDENT_LANGUAGE_INFORMATION_PERMISSIONS());
				            		}
				    			},
				    			selectionchange: function(column, selected,eOpts ){
				                    var grid = column.view.up('grid');
				                    if(selected.length > '1'){
				                            grid.down('#btnAdd').setDisabled(true);
				                            grid.down('#btnEdit').setDisabled(true);
				                            grid.down('#btnView').setDisabled(true);
				                            grid.down('#btnDelete').setDisabled(false);
				                        }else{
				                            grid.down('#btnAdd').setDisabled(false);
				                            grid.down('#btnEdit').setDisabled(false);
				                            grid.down('#btnView').setDisabled(false);
				                            grid.down('#btnDelete').setDisabled(false);
				                        }
				                    },
				                    
				    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
									var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
									if(columnName == "languageDocument"){
										if(e.target.tagName=='A'){
											if(record.data.languageDocument.length == 1){
												var whetherFile = false;
												var documentId= record.data.languageDocument["0"].id;
												if(!isNullOrEmpty(documentId)){
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
														method: 'GET',
														callback : function(opt, success, response){
															if(response.responseText == 'true') {
																var csvForm = Ext.create('Ext.form.Panel'); 
																csvForm.getForm().submit({
																	target: '_blank',
																	method:'GET',
																	params :{
																		access_token : Ext.Ajax.defaultHeaders.access_token
																	},
																	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																	standardSubmit :true
																});
															} else {
																showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
															}
														}
													});
												}} else if(record.data.languageDocument.length > 1){
													var docWindow = this.getStudentlanguagedocumentlist();
													var ID = record.data.id;
													if (!docWindow) {
														docWindow = Ext.widget('studentlanguagedocumentlist',{
															itemId:'studentlanguagedocumentlist'
														});
													}
													docWindow.show();
													var studentlanguagedetaildocumentlistgrid = docWindow.down('#studentlanguagedocumentlistgridItemId');
													 var store = studentlanguagedetaildocumentlistgrid.getStore();
													  store.getProxy().extraParams = {
					             						  ID: record.data.id
					             					  };
					             					  store.load();
												}
										}
									}
									if(columnName == "languageDocumentUrl"){
										if(e.target.tagName=='A'){
											if(record.data.languageDocumentUrl.length == 1){
												
											} else if(record.data.languageDocumentUrl.length > 1){    	
													var docWindow = this.getStudentlanguagedocurllist();
					             					  var ID = record.data.id;
					             					  	             					  
					             					 if (!docWindow) {
														docWindow = Ext.widget('studentlanguagedocurllist',{
															itemId:'studentlanguagedocurllist'
														});
					             					 }
													docWindow.show();
													
													var studentlanguagedetaildocumenturllistgrid = docWindow.down('#studentlanguagedocurllistgridItemId');
													 var store = studentlanguagedetaildocumenturllistgrid.getStore();
													  store.getProxy().extraParams = {
					             						  ID: record.data.id
					             					  };
					             					  store.load();
												}
										  }
										}
								}
				            
				            },
				            /**
				             *  Health Information Grid Details
				             */
				            'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId]': {
				            	render: function(grid) {
				            		var $this = this;
				            		$this.loadGridStore('#studentHealthInformationGridItemId', SERVERURL.PATH_STUDENT_HEALTH_INFORMATION_GRID_DATA,grid);
				            		var portalId = this.getCurrentLoggedPortalId();
				            		if (portalId == 7) {
				            			$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
				            			var structure = grid.up('personinfostudentportal');
				            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				            		}else if (portalId == 2){
				            			$this.doAccessControlValidation(grid,$this.getFACULTY_PORTAL_HEALTH_INFORMATION_PERMISSION());
				            			var studentProfilePanel = grid.up('studentprofile');
				            			var structure = studentProfilePanel.down('[region=center]');
				            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				            		}else if (portalId == 3){
				            			$this.doAccessControlValidation(grid,$this.getSTUDENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
				    					var structure = grid.up('personinfostudentportal');
				                        $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
				            		}else{
				            			$this.doAccessControlValidation(grid,$this.getSTUDENT_HEALTH_INFORMATION_PERMISSIONS());
				            			var studentProfilePanel = grid.up('studentprofile');
				            			var structure = studentProfilePanel.down('[region=center]');
				            			var  store = grid.getStore();
                                        store.load({
                                               callback:function() {
                                                   if(store.getCount()>5) {
                                                       $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                                   }            
                                               }
                                           });
				            			
				            		}
				            	},
				            	afterrender:function(grid){
				    				var me = this;
				    				var portalId = this.getCurrentLoggedPortalId();
				            		if (portalId == 7) {
				            			me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
				            		}else if (portalId == 2){
				            			me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_HEALTH_INFORMATION_PERMISSION());
				            		}else if (portalId == 3){
				            			me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_HEALTH_INFORMATION_PERMISSION());
				            		}else{
				            			me.addDataGridConfigButton(grid,me.getSTUDENT_HEALTH_INFORMATION_PERMISSIONS());
				            		}
				    			},
				    			selectionchange: function(column, selected,eOpts ){
				                    var grid = column.view.up('grid');
				                    if(selected.length > '1'){
				                            grid.down('#btnAdd').setDisabled(true);
				                            grid.down('#btnEdit').setDisabled(true);
				                            grid.down('#btnView').setDisabled(true);
				                            grid.down('#btnDelete').setDisabled(false);
				                        }else{
				                            grid.down('#btnAdd').setDisabled(false);
				                            grid.down('#btnEdit').setDisabled(false);
				                            grid.down('#btnView').setDisabled(false);
				                            grid.down('#btnDelete').setDisabled(false);
				                        }
				                    },
				                    
				    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
									var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
									if(columnName == "healthUploadDocument"){
										if(e.target.tagName=='A'){
											if(record.data.studentHealthDocument.length == 1){
												var whetherFile = false;
												var documentId= record.data.studentHealthDocument["0"].id;
												if(!isNullOrEmpty(documentId)){
													Ext.Ajax.request({
														type: 'rest',
														url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
														method: 'GET',
														callback : function(opt, success, response){
															if(response.responseText == 'true') {
																var csvForm = Ext.create('Ext.form.Panel'); 
																csvForm.getForm().submit({
																	target: '_blank',
																	method:'GET',
																	params :{
																		access_token : Ext.Ajax.defaultHeaders.access_token
																	},
																	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																	standardSubmit :true
																});
															} else {
																showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
															}
														}
													});
												}} else if(record.data.studentHealthDocument.length > 1){
													var docWindow = this.getStudenthealthinformationdocumentlist();
													var ID = record.data.id;
													if (!docWindow) {
														docWindow = Ext.widget('studenthealthinformationdocumentlist',{
															itemId:'studenthealthinformationdocumentlistItemId'
														});
													}
													docWindow.show();
													var studenthealthinformationdocumentlistgrid = docWindow.down('#studenthealthinformationdocumentlistgridItemId');
													 var store = studenthealthinformationdocumentlistgrid.getStore();
													  store.getProxy().extraParams = {
					             						  ID: record.data.id
					             					  };
					             					  store.load();
												}
										}
									}
									if(columnName == "healthUploadUrl"){
										if(e.target.tagName=='A'){
											if(record.data.studentHealthDocumentUrl.length == 1){
												
											} else if(record.data.studentHealthDocumentUrl.length > 1){    	
													var docWindow = this.getStudenthealthinformationdocumentlist();
					             					  var ID = record.data.id;
					             					  	             					  
					             					 if (!docWindow) {
														docWindow = Ext.widget('studenthealthinformationdocurllist',{
															itemId:'studenthealthinformationdocurllistItemId'
														});
					             					 }
													docWindow.show();
													
													var studenthealthinformationdocurllistgrid = docWindow.down('#studenthealthinformationdocurllistgridItemId');
													 var store = studenthealthinformationdocurllistgrid.getStore();
													  store.getProxy().extraParams = {
					             						  ID: record.data.id
					             					  };
					             					  store.load();
												}
										  }
										}
								}
				            
				            },
				            'studentlanguagedocumentlistgrid button[itemId=downloadDocumentItemId]':{
								click:function(obj){
									var $this = this;
									var form = $this.getStudentlanguagedocumentlist();
									var StudentLanguageDetailActionGrid=obj.up('grid');
									if (StudentLanguageDetailActionGrid.getSelectionModel().getCount() > 0) {
										var records = StudentLanguageDetailActionGrid.getSelectionModel().getSelection();
										var dispatchZipName = "Student Language Information Document";
										var saveModel=[];  
										for(var i in records){
											if(!isNullOrEmpty(records[i].get('path'))) {
												saveModel.push(records[i].get('path'));
											}
											showConfirmMessage(getCommonTranslation('STUDENT_LANGUAGE_DOCUMENTS'),
													getCommonTranslation('STUDENT_LANGUAGE_DETAIL_DOCUMENTS_ALERT'),
													function(btn, text) {
												if (btn == 'yes') {
													var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
													$this.getController('Academia.controller.document.DocumentController')
													.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
												}
											});
										}
									}
									else {
										$this.hideWindowMask();
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
									}
								}
				     	 },
				     	 'studentlanguagedocumentlistgrid button[itemId=btnDelete]':{
				 				click:function(obj){
				 					var $this=this;
				 					var form = this.getStudentlanguagedocumentlist();
									var studentLanguagelistgrid=obj.up('grid');
				 					var studentLanguageGrid= $this.getStudentlanguageinformationgrid();
				 					if (studentLanguagelistgrid.getSelectionModel().getCount() > 0) {
				 						var records = studentLanguagelistgrid.getSelectionModel().getSelection();
				 						var ids=[];
				 						Ext.Array.each(records,function(value){
				 							ids.push(value.data.id);
				 						});
				 							showConfirmMessage(getCommonTranslation('STUDENT_LANGUAGE'),getCommonTranslation('STUDENT_LANGUAGE_DELETE_CONFIRM_MESSAGE'),function(btn,text){
				 							if (btn == 'yes'){
				 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 								Ext.Ajax.request({
				 									method: "DELETE",
				 									type: 'rest',
				 									url : SERVERURL.PATH_STUDENT_LANGUAGE_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
				 									headers: {
				 										'Content-Type': 'application/json'
				 									},
				 									success: function(form, action) {

				 										Ext.getBody().unmask();
				 										showSuccessMessage(getCommonTranslation('STUDENT_LANGUAGE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
				 										studentLanguagelistgrid.store.reload();
				 										studentLanguageGrid.store.reload();
				 										studentLanguagelistgrid.getSelectionModel().deselectAll(true);
				 									}
				 								});
				 							}
				 						});
				 					} else {
				 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 					}
				 				}
				       	 },
				       	 'studentlanguagedocumentlistgrid' : {
				       		render: function(grid) {
								var this$ = this;
								var portalId = this$.getCurrentLoggedPortalId();
								if(portalId==3) {
									this$.doAccessControlValidation(grid, this$.getSTUDENT_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION());
								} else if(portalId==7) {
									this$.doAccessControlValidation(grid, this$.getPARENT_HEALTH_INFORMATON_DOCUMENT_PERMISSION());
								} else if(portalId==2) {
									this$.doAccessControlValidation(grid, this$.getFACULTY_LANGUAGE_INFORMATION_DOCUMENT_PERMISSION());
								} else {
									this$.doAccessControlValidation(grid, this$.getLANGUAGE_INFORMATION_DOCUMENT_PERMISSION());
								}
				            	grid.down('#downloadDocumentItemId').setVisible(true);
							},
							 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
								 var $this = this;
								 var documentGrid = grid.up('grid');
								 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
								 if (columnName == "documentName") {
									 if (e.target.tagName == 'A') {
										 var documentId = record.get("documentId");
										 if (!isNullOrEmpty(documentId)) {
											 $this.getDocumentController().downloadDocumentFile(documentId);
										 }
									 }
								 }
							 }
						 },
						 'studentlanguagedocurllistgrid':{
							 render: function(grid) {
								 var this$ = this; 
								 var portalId = this$.getCurrentLoggedPortalId();
								 if(portalId==3) {
									 this$.doAccessControlValidation(grid, this$.getSTUDENT_LANGUAGE_INFORMATION_URL_PERMISSION());
								 } else if(portalId==7) {
									 this$.doAccessControlValidation(grid, this$.getPARENT_LANGUAGE_INFORMATION_URL_PERMISSION());
								 } else if(portalId==2) {
									 this$.doAccessControlValidation(grid, this$.getFACULTY_LANGUAGE_INFORMATION_URL_PERMISSION());
								 } else {
									 this$.doAccessControlValidation(grid, this$.getLANGUAGE_INFORMATION_URL_PERMISSION());
								 }
							 }
						 },
						 'studentlanguagedocurllistgrid button[itemId=btnDelete]':{
				 				click:function(obj){
				 					var $this=this;
				 					var form = $this.getStudentlanguagedocurllist();  
				 					var studentlanguageGrid= $this.getStudentlanguageinformationgrid();
				 					var studentLanguageUrlListgrid=form.down('#studentlanguagedocurllistgridItemId');
				 					if (studentLanguageUrlListgrid.getSelectionModel().getCount() > 0) {
				 						var records = studentLanguageUrlListgrid.getSelectionModel().getSelection();
				 						var ids=[];
				 						Ext.Array.each(records,function(value){
				 							ids.push(value.data.id);
				 						});
				 							showConfirmMessage(getCommonTranslation('STUDENT_LANGUAGE_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
				 							if (btn == 'yes'){
				 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 								Ext.Ajax.request({
				 									method: "DELETE",
				 									type: 'rest',
				 									url : SERVERURL.PATH_STUDENT_LANGUAGE_URL_DELETE+'?fileDocumentIds='+ids.join(),
				 									headers: {
				 										'Content-Type': 'application/json'
				 									},
				 									success: function(form, action) {

				 										Ext.getBody().unmask();
				 										showSuccessMessage(getCommonTranslation('STUDENT_LANGUAGE_URL'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
				 										studentLanguageUrlListgrid.store.reload();
				 										studentlanguageGrid.store.reload();
				 										studentLanguageUrlListgrid.getSelectionModel().deselectAll(true);
				 									}
				 								});
				 							}
				 						});
				 					} else {
				 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 					}
				 				}
				       	 },
				       	 'studentlanguagedetailform[itemId=studentlanguageformId] nestedJsonCombo#languageExamType' : {
				    			change : function(obj, record) {
				    				var $this = this;
				    				var formLayout = $this.getStudentlanguagedetailform();
									var otherLanguageExamType= formLayout.down('#otherLanguageExamType');
									otherLanguageExamType.reset();
				    				var activity = formLayout.down ('#languageExamType').getDisplayValue();
								     var currentVal = activity;
											if(currentVal=="Other"){
												otherLanguageExamType.setVisible(true);
					    						return false;
					    					}else{
					    						otherLanguageExamType.setVisible(false);
					    					}		
				    		}
				        },
				        'studentlanguagedetailform[itemId=studentlanguageformId] checkboxfield#isPrimaryLanguage' :{
			                 change:function(val)
			                 {
			                     var form= this.getStudentlanguagedetailform();
			                     var id = form.down("#language_detail_hidden_field");
			                     var isPrimaryFiled=form.down('#isPrimaryLanguage');
			                     var gridStore;
			                     var portalId = this.getCurrentLoggedPortalId();  	
			                     if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
			                    	 var languageInformationGrid  = this.getStudentlanguageinformationgrid();
			                    	 gridStore = languageInformationGrid.getStore();
			                     } else {
			                    	 var contentPanelTab = this.getContentPanelActiveTab();
				         	       	 var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
				         	   		 gridStore  = personInfoPanel.down('studentlanguageinformationgrid').getStore();
			                     }
			    	 				//var gridStore  = this.getStudentlanguageinformationgrid().getStore();
			                        if(this.studentLanguageMode=='ADD'){
			                            if(gridStore.data.items.length!=null){
			                            gridStore.data.items.forEach(function(itemObj){
			                                  if(!isNullOrEmpty(itemObj.data.isPrimaryLanguage)&&(itemObj.data.isPrimaryLanguage==true)){
			                                        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
			                                        isPrimaryFiled.setValue(false);
			                                  }
			                             });
			                            }
			                        }else if(this.studentLanguageMode=='EDIT'){
			                            if(gridStore.data.items.length!=null){
			                                gridStore.data.items.forEach(function(itemObj){
			                                      if(!isNullOrEmpty(itemObj.data.isPrimaryLanguage)&&(itemObj.data.isPrimaryLanguage==true)&&(itemObj.data.id != Number(id.getValue()))){
			                                            showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
			                                            isPrimaryFiled.setValue(false);
			                                      }
			                                 });
			                                }
			                        }
			                        
			                 }
			             },
				            'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId] button[itemId=btnView]': {
			                	click: function(){
			                		var $this = this;
			                		$this.isAdd=false;
			                		$this.formModelMode='VIEW';
			                		$this.viewStudentHealthInformation('HEALTH_INFORMATION', 'StudentHealthInformationForm', '#studentHealthInformationGridItemId');
			                		$this.studentDocHealthInformationContainerWindow();
			                		$this.studentUrlHealthInformationContainerWindow();
			                	}
			                },
			                
			                
			                'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId] button[itemId=btnEdit]': {
			                	click: function(){
			                		this.isAdd=false;
			                		this.formModelMode='EDIT';
			                		this.editHealthInformationDetailWindow('HEALTH_INFORMATION', 'StudentHealthInformationForm', '#studentHealthInformationGridItemId', false);
			                		this.studentDocHealthInformationContainerWindow();
			                		this.studentUrlHealthInformationContainerWindow();
			                	}
			                },
			                
			                'healthinformationdetailgrid[itemId=studentHealthInformationGridItemId] button[itemId=btnDelete]': {
			                	click: function() {
			                		this.deleteStudentHealthInformationDetail('#studentHealthInformationGridItemId', SERVERURL.PATH_STUDENTD_HEALTH_INFORMATION_DELETE);
			                	}
			                },
			                'studenthealthinformationdocurllistgrid':{
			   				 render: function(grid) {
			   					 var this$ = this; 
			   					 var portalId = this$.getCurrentLoggedPortalId();
			   					 if(portalId==3) {
			   						 this$.doAccessControlValidation(grid, this$.getSTUDENT_HEALTH_INFORMATON_URL_PERMISSION());
			   					 } else if(portalId==7) {
			   						 this$.doAccessControlValidation(grid, this$.getPARENT_HEALTH_INFORMATON_URL_PERMISSION());
			   					 } else if(portalId==2) {
			   						 this$.doAccessControlValidation(grid, this$.getFACULTY_HEALTH_INFORMATON_URL_PERMISSION());
			   					 } else {
			   						 this$.doAccessControlValidation(grid, this$.getHEALTH_INFORMATON_URL_PERMISSION());
			   					 }
			   				 }
			   			 },
			                'studenthealthinformationdocurllistgrid button[itemId=btnDelete]':{
				 				click:function(obj){
				 					var $this=this;
				 					var studentHealthInformationGrid= $this.getHealthinformationdetailgrid();
				 					var studentHealthInformationUrlListgrid= $this.getStudenthealthinformationdocurllistgrid();
				 					if (studentHealthInformationUrlListgrid.getSelectionModel().getCount() > 0) {
				 						var records = studentHealthInformationUrlListgrid.getSelectionModel().getSelection();
				 						var ids=[];
				 						Ext.Array.each(records,function(value){
				 							ids.push(value.data.id);
				 						});
				 							showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
				 							if (btn == 'yes'){
				 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 								Ext.Ajax.request({
				 									method: "DELETE",
				 									type: 'rest',
				 									url : SERVERURL.PATH_STUDENTD_HEALTH_INFORMATION_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
				 									headers: {
				 										'Content-Type': 'application/json'
				 									},
				 									success: function(form, action) {

				 										Ext.getBody().unmask();
				 										showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),getCommonTranslation('URL_SUCCESS_MSG'));	 
				 										studentHealthInformationUrlListgrid.store.reload();
				 										studentHealthInformationGrid.store.reload();
				 										studentHealthInformationUrlListgrid.getSelectionModel().deselectAll(true);
				 									}
				 								});
				 							}
				 						});
				 					} else {
				 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 					}
				 				}
				       	 },
				      
						 'studenthealthinformationdocumentlistgrid button[itemId=btnDelete]':{
				 				click:function(obj){
				 					var $this=this;
				 					var form = this.getStudenthealthinformationdocumentlist();
									var studentHealthInformationlistgrid=obj.up('grid');
				 					var studentHealthInformationGrid= $this.getHealthinformationdetailgrid();
				 					if (studentHealthInformationlistgrid.getSelectionModel().getCount() > 0) {
				 						var records = studentHealthInformationlistgrid.getSelectionModel().getSelection();
				 						var ids=[];
				 						Ext.Array.each(records,function(value){
				 							ids.push(value.data.id);
				 						});
				 							showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'),function(btn,text){
				 							if (btn == 'yes'){
				 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 								Ext.Ajax.request({
				 									method: "DELETE",
				 									type: 'rest',
				 									url : SERVERURL.PATH_STUDENTD_HEALTH_INFORMATION_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
				 									headers: {
				 										'Content-Type': 'application/json'
				 									},
				 									success: function(form, action) {

				 										Ext.getBody().unmask();
				 										showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
				 										studentHealthInformationlistgrid.store.reload();
				 										studentHealthInformationGrid.store.reload();
				 										studentHealthInformationlistgrid.getSelectionModel().deselectAll(true);
				 									}
				 								});
				 							}
				 						});
				 					} else {
				 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 					}
				 				}
				       	 },			   
						'studenthealthinformationdocumentlistgrid button[itemId=downloadDocumentItemId]':{
								click:function(obj){
									var $this = this;
									var form = $this.getStudenthealthinformationdocumentlist();
//									var StudentVisaDetailActionGrid=form.down('#studentvisadocumentlistgridItemId');
									var StudentHealthDetailActionGrid=obj.up('grid');
									if (StudentHealthDetailActionGrid.getSelectionModel().getCount() > 0) {
										var records = StudentHealthDetailActionGrid.getSelectionModel().getSelection();
										var dispatchZipName = "Student Health Information Document";
										var saveModel=[];  
										for(var i in records){
											if(!isNullOrEmpty(records[i].get('path'))) {
												saveModel.push(records[i].get('path'));
											}
											showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),
													getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS_ALERT'),
													function(btn, text) {
												if (btn == 'yes') {
													var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
													$this.getController('Academia.controller.document.DocumentController')
													.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
												}
											});
										}
									}
									else {
										$this.hideWindowMask();
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
									}
								}
				     	 },
				     	 'studenthealthinformationdocumentlistgrid':{
								render: function(grid) {
									var this$ = this;
									var portalId = this$.getCurrentLoggedPortalId();
									if(portalId==3) {
										this$.doAccessControlValidation(grid, this$.getSTUDENT_HEALTH_INFORMATON_DOCUMENT_PERMISSION());
									} else if(portalId==7) {
										this$.doAccessControlValidation(grid, this$.getPARENT_HEALTH_INFORMATON_DOCUMENT_PERMISSION());
									} else if(portalId==2) {
										this$.doAccessControlValidation(grid, this$.getFACULTY_HEALTH_INFORMATON_DOCUMENT_PERMISSION());
									} else {
										this$.doAccessControlValidation(grid, this$.getHEALTH_INFORMATON_DOCUMENT_PERMISSION());
									}
					            	grid.down('#downloadDocumentItemId').setVisible(true);
								},
								cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
									var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
									if(columnName == "documentName"){
										if(e.target.tagName=='A'){
											var documentId=record.get('ecrptydocumentId');
											if(!isNullOrEmpty(documentId)){
												Ext.Ajax.request({
													type: 'rest',
													url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
													method: 'GET',
													callback : function(opt, success, response){
														if(response.responseText == 'true') {
															var csvForm = Ext.create('Ext.form.Panel'); 
															csvForm.getForm().submit({
																target: '_blank',
																method:'GET',
																params :{
																	access_token : Ext.Ajax.defaultHeaders.access_token
																},
																headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																standardSubmit :true
															});
															showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('DOWNLOAD_HEALTH_DOCUMENT_SUCCESSFULLY'));
														} else {
															showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
														}
													}
												});
											}
										}
									}
								}
							},
							'documentformwindow[itemId=studentThesisUploadDocumentFormItemId] simpledocumentform[itemId=simpleDocumentForm] filefield[itemId=uploadFileField]' : {
								change:function(fileField, value){
									if(!isNullOrEmpty(fileField.fileInputEl.dom.files[0])) {
				                		var $this = this;
							  			var personInfo = this.getActiveTabfromContentPanel();
				                    	value = value.replace('C:\\fakepath\\', '');
				                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
				                    	fileField.setRawValue(newValue);
				                    	if (!isNullOrEmpty(newValue)) {
				                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
				                    	        var file = fileField.fileInputEl.dom.files[0];
				                    	        var fileSize = (file.size / Math.pow(1024, 2)).toFixed(2) * 1;
				                    	       Ext.Ajax.request({
				    								type: 'rest',
				    								url: SERVERURL.PATH_FIND_STUDENT_THESIS_SIZE_BY_PERSONID ,
				    								method: 'GET',
				    								params:{
				    									personId:personInfo.personId
				    								},
				    								callback : function(opt, success, response){
				    									var uploadedFileSize = Ext.decode(response.responseText);
				    									if ((fileSize + uploadedFileSize) > 250) {
						                    	            fileField.reset();
						                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getExaminationTranslation('SIZE_LIMIT_EXCEEDED'));
						                    	            fileField.up('window').down('#submitButtonId').setDisabled(false);
				    									}else{
						                    	        	fileField.documentSize = fileSize;
						                    	        }
				    								}
				    							});
				                    	        
				                    	}
				            		}
								}
							},
				            'studentthesisuploadgrid[itemId=studentThesisUploadGridId] button[itemId=sendDocument]': {
				            	click : function(btn) {
				            	var me = this,
				            	grid = btn.up('grid'),
				            	selectedRec = grid.getSelectionModel().getSelection(),
				            	userExamPanel = grid.down('#userExamPanel');
				            	if(!selectedRec.length){
				            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				            		return;
				            		
				            	}
				            	if(!userExamPanel.getValue()){
				            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_USER'));
				            		return;
				            	}
				            	me.sendDocument(grid,userExamPanel);
				            }
				            		
				          }
				     	 
        		});     
    			},
    			
    			studentDocHealthInformationContainerWindow: function(){
    		    	var StudentDocGrid = Ext.ComponentQuery.query('studenthealthinformationdocumentgrid');
    		        
    		        var $this = this;
    		        var store = StudentDocGrid[0].store;
    		        
    		        var portalId = this.getCurrentLoggedPortalId();  	
    		        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
    		        	var personInfoPanel  = this.getHealthinformationdetailgrid();
    		    		var selectedRec = personInfoPanel.getSelectionModel();
    		            	store.getProxy().extraParams = {
    		    			  ID: selectedRec.getSelection()[0].data.id
    		    			};
    		            	var studentDocHealthInformaitonGrid = this.getStudenthealthinformationdocumentgrid();
    		    			store.load({
    		    				callback:function() {
    		    					if(store.getCount()) {
    		    						if (studentDocHealthInformaitonGrid.isHidden()) {
    		    							studentDocHealthInformaitonGrid.setVisible(true);
    		    						}
    		    					}					
    		    				}
    		    			});
    		        	
    		        }else{
    		        	var contentPanelTab = this.getContentPanelActiveTab();
    		        	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
    		    		var a  = personInfoPanel.down('healthinformationdetailgrid');
    		    		var selectedRec = a.getSelectionModel();
    		            	store.getProxy().extraParams = {
    		    			  ID: selectedRec.getSelection()[0].data.id
    		    			};
    		            	var studentDocHealthInformationGrid = this.getStudenthealthinformationdocumentgrid();
    		    			store.load({
    		    				callback:function() {
    		    					if(store.getCount()) {
    		    						if (studentDocHealthInformationGrid.isHidden()) {
    		    							studentDocHealthInformationGrid.setVisible(true);
    		    						}
    		    					}					
    		    				}
    		    			});
    		        }
    		        
    				
    		       },	
    		    
    		    studentUrlHealthInformationContainerWindow: function(){
    		    	var StudentUrlGrid = Ext.ComponentQuery.query('studenthealthinformationurlgrid');
    		        
    		        var $this = this;
    		        var store = StudentUrlGrid[0].store;
    		        var portalId = this.getCurrentLoggedPortalId();  	
    		        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
    		        	var personInfoPanel  = this.getHealthinformationdetailgrid();
    		            var selectedRec = personInfoPanel.getSelectionModel();
    		            	store.getProxy().extraParams = {
    		    			  ID: selectedRec.getSelection()[0].data.id
    		    			};
    		            	var studentUrlHealthInformationGrid = this.getStudenthealthinformationurlgrid();
    		    			store.load({
    		    				callback:function() {
    		    					if(store.getCount()) {
    		    						if (studentUrlHealthInformationGrid.isHidden()) {
    		    							studentUrlHealthInformationGrid.setVisible(true);
    		    						}	  											
    		    					}
    		    				}
    		    			});
    		        	
    		        }else{
    		        	var contentPanelTab = this.getContentPanelActiveTab();
    		    		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
    		    		var a  = personInfoPanel.down('healthinformationdetailgrid'); 	
    		            var selectedRec = a.getSelectionModel();
    		            	store.getProxy().extraParams = {
    		    			  ID: selectedRec.getSelection()[0].data.id
    		    			};
    		            	var studentUrlHealthInformationGrid = this.getStudenthealthinformationurlgrid();
    		    			store.load({
    		    				callback:function() {
    		    					if(store.getCount()) {
    		    						if (studentUrlHealthInformationGrid.isHidden()) {
    		    							studentUrlHealthInformationGrid.setVisible(true);
    		    						}	  											
    		    					}
    		    				}
    		    			});
    		        	
    		        }
    		    },
    			
    			independentNonExaminingChairpersonReportDocumentContainerWindow: function(){

    				var $this = this;
    				var IndependentnonexaminingchairpersondocGrid = Ext.ComponentQuery.query('independentnonexaminingchairpersondocgrid');
    				var store = IndependentnonexaminingchairpersondocGrid[0].getStore();
    				var IndependentnonexaminingchairpersonreportGrid = Ext.ComponentQuery.query('[itemId=independentnonexaminingchairpersonreportgridId]');
    				var currentId = 0;
    				var IndependentnonexaminingchairpersonreportGridSelected = IndependentnonexaminingchairpersonreportGrid[0].getSelectionModel().selected;
    				currentId = IndependentnonexaminingchairpersonreportGridSelected.items[0].data.id;
    				if( currentId != 0 ){
    					store.getProxy().extraParams = {
    						ID: currentId
    					};
    					store.load();
    					var IndependentnonexaminingchairpersonreportGridSelected = $this.getIndependentNonExaminingChairPersonDocGrid();
    					if (IndependentnonexaminingchairpersonreportGridSelected.isHidden() /*&& store.data.items.length > 0*/) {
    						IndependentnonexaminingchairpersonreportGridSelected.setVisible(true);
    					}	  					
    				}	
    			},
    			studentEthicsClearanceLetterDocumentContainerWindow: function(){
   				 var StudentEthicsClearanceLetterGrid = Ext.ComponentQuery.query('studentethicsclearanceletterdocumentgrid');

   				 var $this = this;
   				 var store = StudentEthicsClearanceLetterGrid[0].store;
   		
   				 var a = Ext.ComponentQuery.query('[itemId=studentethicsclearancelettergridId]');
   				 var currentId = 0;
   				 if(a.length > 0){
   					 l = a[0].getSelectionModel().selected;
   					 if(l != undefined){
   						 if( l.items != undefined && l.items.length > 0 ){
   							 if( l.items[0].data != undefined ){
   								 if( l.items[0].data.id != undefined ){
   									 currentId = l.items[0].data.id;
   								 }
   							 }
   						 }
   					 }
   				 }       	
   				 if( currentId != 0 ){
   					 store.getProxy().extraParams = {
   						 ID: currentId
   					 };
   					 store.load();
   					 var studentEthicsClearanceLetterGrid = this.getStudentethicsclearanceletterdocumentgrid();
   					 if (studentEthicsClearanceLetterGrid.isHidden()) {
   						 studentEthicsClearanceLetterGrid.setVisible(true);
   					 }	  					
   				 }
   			 },
   
		 functionaryProgressReportDocumentContainerWindow: function(){
			 var FunctionaryProgressReportGrid = Ext.ComponentQuery.query('functionaryprogressreportdocumentgrid');

			 var $this = this;
			 var store = FunctionaryProgressReportGrid[0].store;
	
			 var a = Ext.ComponentQuery.query('[itemId=functionaryprogressreportgridId]');
			 var currentId = 0;
			 if(a.length > 0){
				 l = a[0].getSelectionModel().selected;
				 if(l != undefined){
					 if( l.items != undefined && l.items.length > 0 ){
						 if( l.items[0].data != undefined ){
							 if( l.items[0].data.id != undefined ){
								 currentId = l.items[0].data.id;
							 }
						 }
					 }
				 }
			 }       	
			 if( currentId != 0 ){
				 store.getProxy().extraParams = {
					 ID: currentId
				 };
				 store.load();
				 var functionaryProgressReportGrid = this.getFunctionaryprogressreportdocumentgrid();
				 if (functionaryProgressReportGrid.isHidden()) {
					 functionaryProgressReportGrid.setVisible(true);
				 }	  					
			 }
		 },

    studentJointDegreeDocumentContainerWindow: function(){
    	var StudentJointDegreeGrid = Ext.ComponentQuery.query('studentjointdegreedocumentgrid');
        
        var $this = this;
        var store = StudentJointDegreeGrid[0].store;
         	
        var a = Ext.ComponentQuery.query('[itemId=studentjointdegreegridId]');
        var currentId = 0;
        if(a.length > 0){
        	l = a[0].getSelectionModel().selected;
        	if(l != undefined){
        		if( l.items != undefined && l.items.length > 0 ){
        			if( l.items[0].data != undefined ){
        				if( l.items[0].data.id != undefined ){
        					currentId = l.items[0].data.id;
        				}
        			}
        		}
        	}
        }       	
        if( currentId != 0 ){
        	store.getProxy().extraParams = {
			  ID: currentId
			};
			store.load();
			var studentJointDegreeGrid = this.getStudentjointdegreedocumentgrid();
			if (studentJointDegreeGrid.isHidden() /*&& store.data.items.length > 0*/) {
				studentJointDegreeGrid
				.setVisible(true);
			}	  					
        }	
    
    },	
    studentExaminersReportDocumentContainerWindow: function(){
    	var $this = this;
    	var StudentExaminerReportDocumentGrid = Ext.ComponentQuery.query('studentexaminersreportdocumentgrid');
        var store = StudentExaminerReportDocumentGrid[0].getStore();
        var studentExaminersReportGrid = Ext.ComponentQuery.query('[itemId=studentExaminersReportGridId]');
        var currentId = 0;
        var studentExaminersReportGridSelected = studentExaminersReportGrid[0].getSelectionModel().selected;
        currentId = studentExaminersReportGridSelected.items[0].data.id;
        if( currentId != 0 ){
        	store.getProxy().extraParams = {
        		ID: currentId
        	};
        	store.load();
        	var studentExaminerReportGrid = this.getStudentexaminersreportdocumentgrid();
        	if (studentExaminerReportGrid.isHidden() /*&& store.data.items.length > 0*/) {
        		studentExaminerReportGrid.setVisible(true);
        	}	  					
        }	
    },	
    studentMouContainerWindow: function(){
    	var StudentMOUGrid = Ext.ComponentQuery.query('studentmoudocumentgrid');
        
        var $this = this;
        var store = StudentMOUGrid[0].store;
         	
        var a = Ext.ComponentQuery.query('[itemId=studentmougridId]');
        var currentId = 0;
        if(a.length > 0){
        	l = a[0].getSelectionModel().selected;
        	if(l != undefined){
        		if( l.items != undefined && l.items.length > 0 ){
        			if( l.items[0].data != undefined ){
        				if( l.items[0].data.id != undefined ){
        					currentId = l.items[0].data.id;
        				}
        			}
        		}
        	}
        }       	
        if( currentId != 0 ){
        	store.getProxy().extraParams = {
			  ID: currentId
			};
			store.load();
			var studentMOUGrid = this.getStudentmoudocumentgrid();
			if (studentMOUGrid.isHidden()) {
				studentMOUGrid.setVisible(true);
			}	  					
        }	
    
    },	
    
    proofOfActivityContainerWindow: function(){
    	var ProofOfActivityGrid = Ext.ComponentQuery.query('proofofactivitydocumentgrid');
        
        var $this = this;
        var store = ProofOfActivityGrid[0].store;
         	
        var a = Ext.ComponentQuery.query('[itemId=proofofactivitygridId]');
        var currentId = 0;
        if(a.length > 0){
        	l = a[0].getSelectionModel().selected;
        	if(l != undefined){
        		if( l.items != undefined && l.items.length > 0 ){
        			if( l.items[0].data != undefined ){
        				if( l.items[0].data.id != undefined ){
        					currentId = l.items[0].data.id;
        				}
        			}
        		}
        	}
        }       	
        if( currentId != 0 ){
        	store.getProxy().extraParams = {
			  ID: currentId
			};
			store.load();
			var proofOfActivityGrid = this.getProofofactivitydocumentgrid();
			store.load({
				callback:function() {
					if(store.getCount()) {
						if (proofOfActivityGrid.isHidden()) {
							proofOfActivityGrid.setVisible(true);
						}
					}					
				}
			});
			/*if (!proofOfActivityGrid.isHidden()) {
				proofOfActivityGrid.setVisible(false);
			}*/	  					
        }	
    
    },	
    
  studentPostDocInfoContainerWindow: function(){
	    	var PostDocInfoGrid = Ext.ComponentQuery.query('postdocinfodocumentgrid');
	        
	        var $this = this;
	        var store = PostDocInfoGrid[0].store;
	         	
	        var a = Ext.ComponentQuery.query('[itemId=studentpostinfogridId]');
	        var currentId = 0;
	        if(a.length > 0){
	        	l = a[0].getSelectionModel().selected;
	        	if(l != undefined){
	        		if( l.items != undefined && l.items.length > 0 ){
	        			if( l.items[0].data != undefined ){
	        				if( l.items[0].data.id != undefined ){
	        					currentId = l.items[0].data.id;
	        				}
	        			}
	        		}
	        	}
	        }       	
	        if( currentId != 0 ){
	        	store.getProxy().extraParams = {
				  ID: currentId
				};
				store.load();
				var studentpostDocInfoGrid = this.getPostdocinfodocumentgrid();
				if (studentpostDocInfoGrid.isHidden() /*&& store.data.items.length > 0*/) {
					studentpostDocInfoGrid
					.setVisible(true);
				}	  					
	        }
    	  
   },
   studentOwnProgressReportDocumentContainerWindow: function(){
   	var StudentOwnProgressReportGrid = Ext.ComponentQuery.query('studentownprogressreportdocumentgrid');
       
       var $this = this;
       var store = StudentOwnProgressReportGrid[0].store;
        	
       var a = Ext.ComponentQuery.query('[itemId=studentownprogressreportgridId]');
       var currentId = 0;
       if(a.length > 0){
       	l = a[0].getSelectionModel().selected;
       	if(l != undefined){
       		if( l.items != undefined && l.items.length > 0 ){
       			if( l.items[0].data != undefined ){
       				if( l.items[0].data.id != undefined ){
       					currentId = l.items[0].data.id;
       				}
       			}
       		}
       	}
       }       	
       if( currentId != 0 ){
       	store.getProxy().extraParams = {
			  ID: currentId
			};
			store.load();
			var studentOwnProgRepGrid = this.getStudentownprogressreportdocumentgrid();
			if (studentOwnProgRepGrid.isHidden()) {
				studentOwnProgRepGrid
				.setVisible(true);
			}	  					
       }	
   
   },	
   
   studentDocEducationHistoryContainerWindow: function(){
	   	var studentDocGrid = Ext.ComponentQuery.query('studenteducationhistorydocumentgrid');
	       
	       var $this = this;
	       var store = studentDocGrid[0].store;
	       
	       var portalId = this.getCurrentLoggedPortalId();  	
	       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
	       	var personInfoPanel  = this.getStudenteducationhistorydetailgrid();
	   		var selectedRec = personInfoPanel.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var studentDocEducationHistoryGrid = this.getStudenteducationhistorydocumentgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (studentDocEducationHistoryGrid.isHidden()) {
	   							studentDocEducationHistoryGrid.setVisible(true);
	   						}
	   					}					
	   				}
	   			});
	       	
	       }else{
	       	var contentPanelTab = this.getContentPanelActiveTab();
	       	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	   		var a  = personInfoPanel.down('studenteducationhistorydetailgrid');
	   		var selectedRec = a.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	        	var studentDocEducationHistoryGrid = this.getStudenteducationhistorydocumentgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (studentDocEducationHistoryGrid.isHidden()) {
	   							studentDocEducationHistoryGrid.setVisible(true);
	   						}
	   					}					
	   				}
	   			});
	       }
	       
			
	      },	
	   
	    studentUrlEducationHistoryContainerWindow: function(){
	   	var studentUrlGrid = Ext.ComponentQuery.query('studenteducationhistoryurlgrid');
	       
	       var $this = this;
	       var store = studentUrlGrid[0].store;
	       var portalId = this.getCurrentLoggedPortalId();  	
	       if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
	       	var personInfoPanel  = this.getStudenteducationhistorydetailgrid();
	           var selectedRec = personInfoPanel.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var studentUrlEducationHistoryGrid = this.getStudenteducationhistoryurlgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (studentUrlEducationHistoryGrid.isHidden()) {
	   							studentUrlEducationHistoryGrid.setVisible(true);
	   						}	  											
	   					}
	   				}
	   			});
	       	
	       }else{
	       	var contentPanelTab = this.getContentPanelActiveTab();
	   		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
	   		var a  = personInfoPanel.down('studenteducationhistorydetailgrid'); 	
	           var selectedRec = a.getSelectionModel();
	           	store.getProxy().extraParams = {
	   			  ID: selectedRec.getSelection()[0].data.id
	   			};
	           	var studentUrlEducationHistoryGrid = this.getStudenteducationhistoryurlgrid();
	   			store.load({
	   				callback:function() {
	   					if(store.getCount()) {
	   						if (studentUrlEducationHistoryGrid.isHidden()) {
	   							studentUrlEducationHistoryGrid.setVisible(true);
	   						}	  											
	   					}
	   				}
	   			});
	       	
	       }
	   },
	   
    processVaccinationInfoDetailsWindow: function(buttonAction){
    	
    	if( buttonAction == 'btnView' || buttonAction == 'btnEdit' ){
	    	var vaccinationInfodocumentGrid = Ext.ComponentQuery.query('vaccinationinfodocumentgrid');
	        
	        var $this = this;
	        var store = vaccinationInfodocumentGrid[0].store;
	         	
	        var a = Ext.ComponentQuery.query('[itemId=studentVaccinationGrid]');
	        var currentId = 0;
	        if(a.length > 0){
	        	l = a[0].getSelectionModel().selected;
	        	if(l != undefined){
	        		if( l.items != undefined && l.items.length > 0 ){
	        			if( l.items[0].data != undefined ){
	        				if( l.items[0].data.id != undefined ){
	        					currentId = l.items[0].data.id;
	        				}
	        			}
	        		}
	        	}
	        }
	         	
	        if( currentId != 0 ){
	        	store.getProxy().extraParams = {
				  ID: currentId
				};
				store.load();
				var vaccinationInfoDocGrid = $this.getVaccinationinfodocumentgrid();
				if (vaccinationInfoDocGrid.isHidden() /*&& store.data.items.length > 0*/) {
					vaccinationInfoDocGrid
					.setVisible(true);
				}	  					
	        }
    	  }
    	
  		  if(buttonAction == 'btnView'){
	          var a = Ext.ComponentQuery.query("personcommonwindow");
	  		  if( a != undefined & a.length > 0){
	  			  a[0].down("#cancelButtonId").setVisible(false);
	  			  a[0].down("#submitButtonId").setVisible(false);
	  			  a[0].down("#uploadVaccinationItemId").setVisible(false);
	  		  }
	  		  var b = this.getVaccinationinfodocumentgrid();
	  		  if(b != undefined){
	  			b.down("#btnDelete").setVisible(false); 
	  		  }
  		  }
    },
    disableMedicalDetailFormPivileges: function(formReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        //associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        var saveBtn = formReference.down('#submitButtonId');
        saveBtn.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'SAVE') {
                if (!isNullOrEmpty(saveBtn)) {
                    saveBtn.setVisible(true);
                }
            }

        });
    },
    disableSocioEconomicFormPivileges: function(formReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        //associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

        var saveBtn = formReference.down('#submitButtonId');
        saveBtn.setVisible(false);

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'SAVE') {
                if (!isNullOrEmpty(saveBtn)) {
                    saveBtn.setVisible(true);
                }
            }

        });
    },
    DayCountbetweenDate : function() {
		 var ONE_DAY = 1000 * 60 * 60 * 24
	   
	   var form = this.getPersonSeminarDetailsForm();
	   var fromdate = form.down("#fromDate");
	   var todate = form.down("#toDate");
	   var numberOfDays = form.down("#numberOfDays");
	   // Convert both dates to milliseconds
	   var fromdate_ms = fromdate.getValue();
	   var todate_ms = todate.getValue();
	   
	   // Calculate the difference in milliseconds
	   var difference_ms = Math.abs(fromdate_ms - todate_ms)
	   if(todate_ms != null && fromdate_ms != null){
		   // Convert back to days and return
		   numberOfDays.setValue(Math.round(difference_ms/ONE_DAY+1));
	   }
	 },
	 getCommonAddressDetails : function(buttonId,
				academyLocationId) {
			var this$ = this;
			
			/* to check if current tab is for updation or addition */
			var form = this.getPersonTrainingDetailsForm();

	        var submitUrl, isUpdate = false;
	        var id = form.down('#training_hidden_field');
	        if (isNullOrEmpty(id.getSubmitValue())) {
	            isUpdate = false;
	        } else {
	            isUpdate = true;
	        }
	        /* to check if current tab is for updation or addition */
			
			if (isUpdate) {
				try{
					var showWinButton = Ext.ComponentQuery.query('#'+buttonId)[0].up('form').down('#submitButtonId').isVisible();
				}
				catch(e){
					var showWinButton = false;
				}
				var addressWindowItemId = "addressformwindow";
				var addressFormWindow = Ext.widget(
						'addressFormWindow', {
							itemId : 'studentTrainingAddressDetails'
							//itemId : 'addressfieldsform'
						});
				addressFormWindow.show();
				
				//---hide/show button
				addressFormWindow.down('#saveButtonId').setVisible(showWinButton);
				
				var addressDetailsform = addressFormWindow
						.down('form');
				var form = addressDetailsform.getForm();
				var url = SERVERURL.VEHICLE_ADDRESS_FIND_BY_ID;
				
				var contentpanel = this.getContentPanel();
	    		var grid = contentpanel.down('#studentTrainingPersonDetailsGrid');
				var records = grid.getSelectionModel().getSelection()[0];
				
				var addressId;
				
				if( records.get("address") != null && records.get("address") != undefined ){
					addressId = records.get("address").id;
				}
				
				if (isUpdate && addressId != undefined && addressId != null && addressId != "" ) {
					var params = {
						id : addressId
					};
					
					var data = records.get("address");
					//form.setValues(data);
					this.populateTrainingAddressDetails(form, data);
					// #############################################
					/*if (forms) {
						forms.down('#saveButtonId').hide();
						var formaddwindow=forms.down('form');
						var form = formaddwindow.getForm();
						var fields=	formaddwindow.getForm().getFields();
						Ext.each(fields.items, function(i) {
							i.setReadOnly(true);
						});
					}*/
				}
				var formTraining = this.getPersonTrainingDetailsForm();
				try{
					if(!isNullOrEmpty(formTraining.getForm().getCode())){
						this.populateTrainingAddressDetails(form, formTraining.getForm().getCode().data);
					}
				}catch(er){
					
				}
			} else {
				var addressWindowItemId = "addressformwindow";
				var addressFormWindow = Ext.widget(
						'addressFormWindow', {
							itemId : 'studentTrainingAddressDetails'
							//itemId : 'addressfieldsform'
						});
				addressFormWindow.show();
				var addressDetailsform = addressFormWindow
						.down('form');
				var form = addressDetailsform.getForm();
				var formTraining = this.getPersonTrainingDetailsForm();
				try{
					if(!isNullOrEmpty(formTraining.getForm().getCode())){
						this.populateTrainingAddressDetails(form, formTraining.getForm().getCode().data);
					}
				}catch(er){
					
				}
				
			}
			var $this = this;
			//addressDetailsform.down('#saveButtonId').setDisabled(false);
			//addressDetailsform.down('#saveButtonId').show();
		},
    	removeStarFromDFR: function(form){
    	  	var $this = this;
    	//  	var structure = $this.getStudentregistrationtabstructure();
        	var medicalDetailForm=$this.getPersonMedicalDetailsForm();
            var familyPractionerContactNumberItemId = medicalDetailForm.down("#familyPractionerContactNumberItemId");
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'medicaldetailsform',
    				academyLocationId: this.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				if( Object.keys(response).length > 0 ){
    					var records=response.medicaldetailsform;
    					for(i in records){
    						if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='familyPractionerContactNumberItemId'  && records[i].isVisible==true){
    							medicalDetailForm.down("#familyPractionerContactNumberItemId").setFieldLabel("");
    						}
    						
    					}
    				}
    			}
    		});
    	},
		populateTrainingAddressDetails: function(addressForm, addressData){
			form = addressForm;
			data = addressData;
			form.setValues(data);
			/*form.findField('addressText').setValue(data.addressText);
			form.findField('phoneAreaCode').setValue(data.phoneAreaCode);
			form.findField('pincode').setValue(addressDetails.pincode);
			form.findField('phoneNo').setValue(data.phoneNo);
			form.findField('cellNo').setValue(data.cellNo);
			form.findField('primaryeEmailId').setValue(data.primaryeEmailId);
			form.findField('alternateEmailId').setValue(data.alternateEmailId);*/
			var country = form.findField('country');
			var city = form.findField('city');
			var parentCountryRegion = form.findField('parentCountryRegion');
			var countryRegion = form.findField('countryRegion');
		
			if (data.country) {
		
				country.getStore().load({
									callback : function(rec,operation,success) {
										country.setValue(data.country.id);
									}
								});
				var cityStore = city.getStore();
				cityStore.getProxy().extraParams = {
									id : data.parentCountryRegion.id
								};
				cityStore.load({
							callback : function(rec,operation,success) {
								city.setValue(data.city.id);
							}
						});
				var pcrStore = parentCountryRegion.getStore();
				pcrStore.getProxy().extraParams = {
					cid : data.country.id
				};
				pcrStore.load({
							callback : function(rec,operation,success) {
								parentCountryRegion.setValue(data.parentCountryRegion.id);
							}
						});
		
				if (data.countryRegion) {
					var crStore = countryRegion.getStore();
					crStore.getProxy().extraParams = {
						pid : data.parentCountryRegion.id
					};
					crStore.load({
								callback : function(rec,operation,success) {
									countryRegion.setValue(data.countryRegion.id);
								}
							});
				}
			}
		},
		
		/*
		 * View Training Details Address in popup on cell click
		 */
		manageCompanyAddressType : function(grid, td, cellIndex,
				record, tr, rowIndex, e, eOpts) {
			var $this = this;
			/*var mngCompanyStructure = this
					.getCreatecompanystructure();*/
			var records = grid.getSelectionModel().getSelection()[0];
			var id = records.get("address").id;
			var addressDetails = records.get("address");
			//$this.openCompanyDetailAddress();
			
			var formWindow = Ext.widget(
					'addressFormWindow', {
						itemId : 'studentTrainingAddressDetails'
						//itemId : 'addressfieldsform'
					});
			//addressFormWindow.show();
			
			formWindow.show();
			
			var forms = $this
					.getAddressformwindow();
			var form = forms.down('form').getForm();
			this.populateTrainingAddressDetails(form,addressDetails);
			if (forms) {
				forms.down('#saveButtonId').hide();
				var formaddwindow=forms.down('form');
				var form = formaddwindow.getForm();
				var fields=	formaddwindow.getForm().getFields();
				Ext.each(fields.items, function(i) {
					i.setReadOnly(true);
				});
			}
		},
		
		/*
		 * Save address details
		 */
		addCompanyAddress : function(button) {
			
			var $this = this;
			// var formWin = $this.getAddressformwindow();
			var form = button.up().up();
			var filterForm = this.getPersonTrainingDetailsForm().getForm();
			var values = form.getValues();
			
//            if(this.validatePhone(values)){
    			// var studentId=Ext.getCmp('id').getValue();
    			var dataModel = new Academia.model.organization.Address;
    			dataModel.set('id', values.id);
    			dataModel.set('addressId', values.addressId);
    			dataModel.set('version', values.version);
    			dataModel.set('addressText', values.addressText);
    			dataModel.set('country', $this
    					.getIdValueJson(values.country));
    			dataModel.set('parentCountryRegion', $this
    					.getIdValueJson(values.parentCountryRegion));
    			dataModel
    					.set('city', $this.getIdValueJson(values.city));
    			dataModel.set('pincode', values.pincode);
    			dataModel
    					.set('cellCountryCode', values.cellCountryCode);
    			dataModel.set('cellNo', values.cellNo);
    			dataModel.set('phoneCountryCode',
    					values.phoneCountryCode);
    			dataModel.set('phoneAreaCode', values.phoneAreaCode);
    			dataModel.set('phoneNo', values.phoneNo);
    			dataModel
    					.set('primaryeEmailId', values.primaryeEmailId);
    			dataModel.set('alternateEmailId',
    					values.alternateEmailId);
    			//dataModel.set('addressType', null);
    			dataModel.set('countryRegion', $this
    					.getIdValueJson(values.countryRegion));
    			dataModel.set('faxNumber', values.faxNumber);
    			dataModel.set('cf1', values.cf1);
    			dataModel.set('cf11', values.cf11);
    			dataModel.set('cf12', values.cf12);
    			//dataModel.set('salutation', values.salutation);
    			Ext.apply(filterForm, {
    				code : null,
    				setCode : function(code) {
    					filterForm.code = code;
    				},
    				getCode : function() {
    					return filterForm.code;
    				}
    			});
    			filterForm.setCode(dataModel);
    			showSuccessMessage(getPersonModuleTranslation('TRAINING_DETAILS'), getPersonModuleTranslation('TRAINING_TYPE_ADDRESS_SUCCESS'));
    			button.up().up().up().close();
//        	}
		},
		
		/* For Training Details Address Management */
		
	    resetForm: function(button) {
	    	button.up('window').close();
	    },
	    

	    validatePhone:function(data){
	    	var isValid;
	    	if(!data.phoneNo && !data.cellNo){
	    		showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
	    		isValid= false;
	    	}
	    	else{
	    		isValid=true;
	    	}
	    	return isValid;
	    },
	    getIdValueJson: function(id, value) {
	        if (id) return {
	            id: id,
	            value: value
	        };
	    },
	    setIdFromNestedObject: function(object, field) {
	        if (object && object[field] && object[field].hasOwnProperty('id')) {
	            object[field] = object[field]["id"];
	        }
	    },
	    loadStudentEducationYearData : function(cmb){
	    	var records= new Array ();
	    	var currentYear = Ext.Date.format(new Date(), 'Y');
	    	for(var num = currentYear ;num >=1950; num--){
	    		records.push({
	                value: num,
	                id : num.toString()
	            });
	    	}
	    	var store = cmb.getStore();
	    	store.loadData(records);
	    },
	    setStudentEducationYearMonthData:function(obj,value){
	    	var getYearValue = Ext.Date.format(new Date(value), 'Y');
	    	var getMonthValue = Ext.Date.format(new Date(value), 'm');
	    	var $this = this;
	    	var getEducationForm = $this.getPersonEducationForm();
	    	var getMonthField = getEducationForm.down('#monthItemId');
	    	var getYearField = getEducationForm.down('#yearItemId');
	    	var getMonthOfExamination = getEducationForm.down('#monthOfExamination');
	    	var getYearOfExamination = getEducationForm.down('#yearOfExamination');
	    	
	    	getMonthField.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==getMonthValue){
							   getMonthField.setValue(records[i].data.value);
						   }
					   }
				   }	   
			   });
	    	
	    	getYearField.setValue(getYearValue);
	    },
	    
	    loadYearDataOfStudentComExam : function(cmb){
	    	var records= new Array ();
	    	var currentYear = Ext.Date.format(new Date(), 'Y');
	    	for(var num = currentYear ;num >=1950; num--){
	    		records.push({
	                value: num,
	                id : num.toString()
	            });
	    	}
	    	var store = cmb.getStore();
	    	store.loadData(records);
	    },
	    setYearMonthDataOfStudentComExam:function(obj,value){
	    	var getYearValue = Ext.Date.format(new Date(value), 'Y');
	    	var getMonthValue = Ext.Date.format(new Date(value), 'm');
	    	var $this = this;
	    	var getComExamForm = $this.getPersonCompetitiveExamForm();
	    	var getMonthField = getComExamForm.down('#monthItemId');
	    	var getYearField = getComExamForm.down('#yearItemId');
	    	
	    	getMonthField.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==getMonthValue){
							   getMonthField.setValue(records[i].data.value);
						   }
					   }
				   }	   
			   });
	    	
	    	getYearField.setValue(getYearValue);
	    },
	    setYearOfEaxmDateMinvalue:function(obj){
	    	var getYearValue = Ext.Date.format(new Date(), 'Y');
	    	var getCurrentLastYearValue = getYearValue+'/12/31/';
	    	obj.setMinValue(Ext.Date.format(new Date('1950/01/01'), 'Y-m-d'));
	    	obj.setMaxValue(Ext.Date.format(new Date(getCurrentLastYearValue), 'Y-m-d'));
	    	
	    },
	    showExtraCurrAddStudentsWindow: function(me, e, eOpts){
			if(Ext.isDefined(Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0])){
				Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].destroy();
			}
			var selectedRecord = me.up('grid').getSelectionModel().selected.items[0].data;
			selectedRecord.dateOfAction1 = dateRender(selectedRecord.dateOfAction);
			selectedRecord.incidentDate1 = dateRender(selectedRecord.awardDate);
			if(Ext.isDefined(localStorage.getItem('PROGRAM_ID')) && !isNullOrEmpty(localStorage.getItem('PROGRAM_ID'))){
				selectedRecord.defaultProgramId = parseInt(localStorage.getItem('PROGRAM_ID'));
			}
			else {
				selectedRecord.defaultProgramId = 0;
			}
			selectedRecord.programItem = selectedRecord.defaultProgramId;

			var formData = {};
			formData.reportedByUserName = this.getCurrentlyLoggedInUser().value;
			formData.activityDate1 = dateRender(selectedRecord.awardDate);

			formData.type = selectedRecord.activityType.value;
			
			formData.id = selectedRecord.id;

			var submitButtonItemId;
			var cancelButtonItemId;
			var addNewExtraCurrFieldContainerBtn;

			submitButtonItemId = 'addStudentsWindowFormExtraSubmitButtonId';
			cancelExtraCurrButtonItemId = 'addStudentsWindowFormExtraCancelButtonId';
			addNewExtraCurrFieldContainerBtn = 'addNewExtraCurrFieldContainerBtn';

			var addStudentsWindow = Ext.create('Ext.window.Window', {
				alias: 'widget.addStudentsExtraCurrWindow',
				itemId: 'addStudentsExtraCurrWindow',
				modal: true,
				resizable: false,
				autoScroll: true,
				frame: true,
				width: 700,
				minHeight: 290,
				height: 290,
				maxHeight : 370,
				title: getCommonTranslation('ADD_STUDENTS'),
				items: [{
					xtype: 'form',
					layout: 'vbox',
					frame: false,
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						height: 60,
						defaults: {
							labelAlign: 'top',
							width: 200
						},
						items:[{
							xtype: 'hidden',
							name: 'id',
							itemId: 'id'
						},
						{
							xtype: 'hidden',
							name: 'defaultProgramId',
							itemId: 'defaultProgramId'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('TYPE_OF_ACTIVITY'),
							name: 'type',
							itemId: 'type'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('DATE_OF_ACTIVITY'),
							name: 'activityDate1',
							itemId: 'activityDate1'
						},
						{
							xtype: 'displayfield',
							fieldLabel: getCommonTranslation('REPORTER_NAME'),
							name: 'reportedByUserName',
							itemId: 'reportedByUserName'
						}]
					},{
						xtype:'panel',
						itemId:'classStudentPanel',
						layout : 'vbox',
						width: '100%',
						marginTop:'30px',
						height: 'auto',
						padding: 0,
						autoScroll: false,
						style:{
							marginLeft:'0px'
						},
						items:[{
							xtype : 'fieldcontainer',
							layout : 'hbox',
							width: '100%',
							defaults : {
								labelAlign : 'top',
								width:'226'
							},
							layout : {
								type : 'hbox'
							},
							margin: '0 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype: 'customcombobox',
								width: 226,
								name: 'programItem',
								itemId:'programItemId',
								store: 'common.ProgramStore',
								fieldLabel: getCommonTranslation('PROGRAM'),
								valueField: 'id',
								displayField: 'valueCode',
								queryParam: 'qry',
								//minChars: 3,
								editable: false,
								allowBlank: false,
								typeAhead: false,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection: true,
								listConfig: {
									listeners: {
										beforeshow: function(
												picker) {
											picker.minWidth = picker
											.up('combobox')
											.getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{code} / {value}' +
										'</div>';
									}
								},
								listeners: {
									change: function(me, newValue, oldValue, eOpts){
										me.up('fieldcontainer').down('#studentId').reset();
										me.up('fieldcontainer').down('#studentId').clearValue();

										var form = Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form');
										var formValues = form.getForm().getFieldValues();
										var	extracurricularActivityId = selectedRecord.extracurricularActivityId;
										if(extracurricularActivityId == null) {
											extracurricularActivityId = formValues.id;
										}
										
										
										me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
												programIds: newValue,
												isExtracurricularAddStudentsScreen: true,
												extracurricularActivityId: extracurricularActivityId
											};
										me.up('fieldcontainer').down('#studentId').getStore().load();
									},
									afterrender: function(combo){
										combo.getStore().load({
											callback: function(){
												setTimeout(function(){
													combo.setValue(combo.findRecordByValue(parseInt(selectedRecord.defaultProgramId)));
												},300);
											}
										});
									}
								}
							},
							{
								xtype: 'customcombobox',
								name: 'STUDENT_ID',
								itemId: 'studentId',
								fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
								store: Ext.create('Academia.store.student.extracurricular.StudentStore'),
								valueField: 'id',
								width: 226,
								displayField: 'valueCode',
								queryParam:'studentNameOrCode',
								triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
								enableKeyEvents  : 'true',
								minChars:3,
								forceSelection:true,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								triggerAction: '',
								hideTrigger:false,
								allowBlank: false,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{studentCode} / {studentName}' +
										'</div>';
									}
								}
							},
							{
								xtype: 'button',
								itemId: addNewExtraCurrFieldContainerBtn,
								width: 'auto',
								cls: 'CustomBodyBtnSettings',
								width: 'auto',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]
						}]
					},
					{
						xtype : 'fieldcontainer',
						width : '100%',
						cls : 'windowBtnPos',
						items : [ {
							xtype : 'button',
							action : 'Submit',
							text : getCommonTranslation('SAVE'),
							itemId : submitButtonItemId,
							ui : 'CustomBtnSubmit',
							scale : CONSTANTS.BUTTONSIZE,
							formBind : true
						}, {
							xtype : 'button',
							itemId : cancelExtraCurrButtonItemId,
							text : getCommonTranslation('CANCEL'),
							ui : 'CustomBtnCancel',
							scale : CONSTANTS.BUTTONSIZE
						} ]
					}]
				}]
			});
			var addStudentsWindowForm=Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form'); 
			var programField=addStudentsWindowForm.down('#programItemId'); 
			var studentField=addStudentsWindowForm.down('#studentId'); 
			this.setAllowBlank(programField,false); 
			this.setAllowBlank(studentField,false); 
			addStudentsWindow.show(); 
			addStudentsWindow.down('form').getForm().setValues(formData);
		},
		doAccessControlValidationOfExtraAddStudent: function(grid, privilegesMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

            var btnAddStudents =  grid.down('#stdExtraCurrAddStudentsBtn').setVisible(false);
			
			var portalId = this.getCurrentLoggedPortalId();
			Ext.each(permissionList, function(privilege) {
					if(privilege == 'EXTRACURRICULAR_ADD_STUDENTS'){
						btnAddStudents.setVisible(true);
					}
			});
		},
		addMoreFieldsOfExtraCurrProgramStudent: function(btn){

			var addNewExtraCurrFieldContainerBtn1;
			var detailedExtraCurrDeleteButton1;

			addNewExtraCurrFieldContainerBtn1 = 'addNewExtraCurrFieldContainerBtn1';
			detailedExtraCurrDeleteButton1 = 'detailedExtraCurrDeleteButton1';
			
			var $this = this;
			var personProfile = $this.getContentPanelActiveTab();
    		var grid=personProfile.down('#studentExtraCurricularGrid');
    		var records = grid.getSelectionModel().getSelection()[0];

			var addStudentsWindowForm=Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form');
			var panelContiner = addStudentsWindowForm.down('#classStudentPanel');
			var defaultProgramId = addStudentsWindowForm.getValues().defaultProgramId;
			var panelItem = new Array();
			panelItem.push({
				xtype : 'fieldcontainer',
				layout : 'hbox',
				width: '100%',
				scope: $this,
				defaults : {
					labelAlign : 'top',
					width:'226'
				},
				layout : {
					type : 'hbox'
				},
				margin: '10 0 0 0',
				padding: '0 0 0 0',
				items:[{
					xtype: 'customcombobox',
					width: 226,
					name: 'programItem',
					itemId:'programItemId',
					store: 'common.ProgramStore',
					fieldLabel: '',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam: 'qry',
					minChars: 3,
					editable: false,
					typeAhead: false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection: true,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(
									picker) {
								picker.minWidth = picker
								.up('combobox')
								.getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					},
					listeners: {
						change: function(me, newValue, oldValue, eOpts){
							me.up('fieldcontainer').down('#studentId').reset();
							me.up('fieldcontainer').down('#studentId').clearValue();

							var form = Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form');
							var formValues = form.getForm().getFieldValues();
							var disciplinaryActionId = formValues.id;
							var	extracurricularActivityId = records.data.extracurricularActivityId;
							if(extracurricularActivityId == null) {
								extracurricularActivityId = formValues.id;
							}
							
								me.up('fieldcontainer').down('#studentId').getStore().proxy.extraParams = {
									programIds: newValue,
									isExtracurricularAddStudentsScreen: true,
									extracurricularActivityId: extracurricularActivityId
								};
							me.up('fieldcontainer').down('#studentId').getStore().load();
						},
						afterrender: function(combo){
							combo.getStore().load({
								callback: function(){
									setTimeout(function(){

										var gridItemId;
										gridItemId = '#studentExtraCurricularGrid';

										var currentGrid = $this.getActiveTabfromContentPanel().down(gridItemId);
										var selectedRecord = currentGrid.getSelectionModel().selected.items[0].data;

										if(Ext.isDefined(localStorage.getItem('PROGRAM_ID')) && !isNullOrEmpty(localStorage.getItem('PROGRAM_ID'))){
											selectedRecord.defaultProgramId = parseInt(localStorage.getItem('PROGRAM_ID'));
										}
										else {
											selectedRecord.defaultProgramId = 0;
										}
										combo.setValue(combo.findRecordByValue(parseInt(selectedRecord.defaultProgramId)));
									},300);
								}
							});
						}
					}
				},
				{
					xtype: 'customcombobox',
					name: 'STUDENT_ID',
					itemId: 'studentId',
					fieldLabel: '',
					store: Ext.create('Academia.store.student.extracurricular.StudentStore'),
					valueField: 'id',
					width: 226,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
				},
				{
					xtype: 'button',
					glyph: ICONGLYPH.DELETEGLYPH,
					itemId: detailedExtraCurrDeleteButton1,
					width: 'auto',
					cls: 'CustomBodyBtnReject',
					tooltip: getCommonTranslation('DELETETOOLTIP'),
					style:{
						marginTop:'4px'
					}
				},
				{
					xtype: 'button',
					itemId: addNewExtraCurrFieldContainerBtn1,
					width: 'auto',
					cls: 'CustomBodyBtnSettings',
					width: 'auto',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'4px'
					}
				}]

			});
			panelContiner.add(panelItem);
			this.hideExtraCurrShowDetails(panelContiner);
			panelContiner.doLayout();
		},
		deleteMoreFieldsOfExtraCurrProgramStudent: function(deleteButton, type) {
			var this$ = this;
			var form=Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form');
			var panelContiner = form.down('#classStudentPanel');
			var container = deleteButton.up('fieldcontainer');
			if (container != null && panelContiner != null) {
				if (panelContiner.items.length > 1) {
					panelContiner.remove(container);
					this$.hideExtraCurrShowDetails(panelContiner);
				}
			}
		},
		hideExtraCurrShowDetails: function(detailedPanel) {
			var this$ = this;
			var form = Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form');
			detailedPanel.items.each(function(item, index, items) {
				var addButton = item.getComponent(item.items.length - 1);
				if (index == (items - 1)) {
					if (addButton != null) {
						addButton.show();
					}
				} else {
					if (addButton != null) {
						addButton.hide();
					}
				}
			});
			var addStudentsWindowFormExtraSubmitButtonId;
				addStudentsWindowFormExtraSubmitButtonId = 'addStudentsWindowFormExtraSubmitButtonId';

			if(!form.getForm().hasInvalidField()){
				form.down('#'+addStudentsWindowFormExtraSubmitButtonId).setDisabled(false);
			}
			else {
				form.down('#'+addStudentsWindowFormExtraSubmitButtonId).setDisabled(true);
			}
		},
		saveExtraCurrStudentWindowForm: function(type){
			var this$ = this;
			var form = Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].down('form');
			var formValues = form.getForm().getFieldValues();        
			var personProfile = this$.getContentPanelActiveTab();
    		var grid=personProfile.down('#studentExtraCurricularGrid');
    		var records = grid.getSelectionModel().getSelection()[0];
			var selected = [];
			var WSDisciplinaryActionDetail = {};
			/*records.data.id = '';
			delete records.data.community;
			delete records.data.dateOfAction1;
			delete records.data.incidentDate1;
			delete records.data.defaultProgramId; 
			delete records.data.programItem; */
			if(!isNullOrEmpty(records.data.activityType)){
				records.data.activityType={
						id:records.data.activityType.id
					}	
			}
			if(!isNullOrEmpty(records.data.eventId)){
				records.data.eventId={
					id:records.data.eventId.id
				}
			}
			if(!isNullOrEmpty(records.data.community)){
				records.data.community={
					id:records.data.community.id
				}
			}
			var extracurricularActivityId = records.data.extracurricularActivityId;
			if(extracurricularActivityId == null) {
				extracurricularActivityId = records.data.id;
			}
			else {
				extracurricularActivityId = records.data.extracurricularActivityId;
			}
			Ext.each(form.getForm().getFields().items, function(currentField){
				if(currentField.name=="STUDENT_ID"){
					if(!isNullOrEmpty(currentField.getValue())){
						var currentFieldRecord = currentField.findRecordByValue(currentField.getValue());
						var newRecord = {
							id: "",
							version: records.data.version,
							eventId:records.data.eventId,
							otherEvent: records.data.otherEvent,
							activityName: records.data.activityName,
							activityType:records.data.activityType,
							organization: records.data.organization,
							community:records.data.community,
							performance: records.data.performance,
							awardDate: records.data.awardDate,
							isCurrentOrganization: records.data.isCurrentOrganization,
							remarks: records.data.remarks,
							extracurricularActivityId: extracurricularActivityId,
							person: {
								id: currentFieldRecord.data.personId
							}
						}
						selected.push(newRecord);
					}
				}
			});
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.EXTRA_CURRICULAR_ADD,
					method: 'POST',
					jsonData: selected,
					callback : function(opt, success, response){
						showSuccessMessage(getCommonTranslation('ADD_STUDENTS'),getCommonTranslation('RECORD_ADD_SUCCESS'));
						Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].destroy();
						this$.getActiveTabfromContentPanel().down('#studentExtraCurricularGrid').getStore().load();
						this$.getActiveTabfromContentPanel().down('#studentExtraCurricularGrid').getSelectionModel().deselectAll();
					}
				});
		},
		hideAddStudentsWindowExtraCurr: function(){
			if(Ext.isDefined(Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0])){
				Ext.ComponentQuery.query('#addStudentsExtraCurrWindow')[0].destroy();
			}
		},
		showDFRManagedFields : function(form) {
	    	var $this = this;
	    	var institutionNameCombo = form.down('#institutionNameItemId');
	    	var institutionName = form.down('#institutionNameTextFieldItemId')
	    	var result = false;
	    	var otherExist = false;
	    	Ext.Ajax.request({
	    		type: 'rest',
	    		async: false,
	    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	    		params: {
	    			screenName: 'postschoolstudiesform',
	    			academyLocationId: this.getCurrentAcademyLocation(),
	    			languageCode:'en'
	    		},
	    		method: 'GET',
	    		success: function(res, action) {
	    			var response = Ext.decode(res.responseText);
	    			if( Object.keys(response).length > 0 ){
	    				var records=response.postschoolstudiesform;
	    				for(i in records){
	    					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='institutionNameItemId'){
	    						if(!isNullOrEmpty(records[i].defaultValue) && records[i].defaultValue.length>4){
	    							var defaultValue = records[i].defaultValue.substring(0,4);
	    							defaultValue = defaultValue.toUpperCase();
	    							if(defaultValue==='OTHE'){
	    								result=true;
	    							}
	    						}else{
	    							if(records[i].isVisible==false && isNullOrEmpty(records[i].defaultValue)){
	    								result=true;
	    							}
	    						}
	    					}
	    				}
	    			}
	    		}
	    	});
	    	if(result){
	    		var institutionNameComboStore = institutionNameCombo.getStore();
	    		institutionNameComboStore.load({
	    			callback: function(records, operation, success) {
	    				for(var i in records){
	    					if(records[i].data.value.length>4){
	    						var comboDiffaltValue = records[i].data.value.substring(0,4);
	    						comboDiffaltValue = comboDiffaltValue.toUpperCase();
	    						if(comboDiffaltValue==='OTHE'){
	    							institutionNameCombo.setValue(records[i].data.id);
	    							institutionName.setVisible(true);
	    							otherExist=true;
	    						}
	    						if(!otherExist){
	    							institutionName.setVisible(false);
	    							institutionName.allowBlank=true
	    							institutionNameCombo.reset();
	    				    		institutionName.reset();
	    						}
	    					}
	    				}
	    			}	   
	    		});

	    	}else{
	    		institutionName.setVisible(false);
				institutionName.allowBlank=true
	    		institutionNameCombo.reset();
	    		institutionName.reset();
	    	}
	    },	
	    studentLanguageDocWindow: function(){
         	var $this = this;
         	var StudentDocGrid = Ext.ComponentQuery.query('studentlanguagedocumentgrid');
             var store = StudentDocGrid[0].store;
          	
             var portalId = $this.getCurrentLoggedPortalId(); 
             if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
             	var personInfoPanel  = $this.getStudentlanguageinformationgrid();
         		var selectedRec = personInfoPanel.getSelectionModel();
         		if (portalId == 2){
     	            store.getProxy().extraParams = {
     	            	ID: selectedRec.getSelection()[0].data.id
     	    		};
         		} else {
         			store.getProxy().extraParams = {
     	            	ID: selectedRec.getSelection()[0].data.id
     	    		};
         		}
                 var studentLanguageDocGrid = $this.getStudentlanguagedocumentgrid();
                 store.load({
                 	callback: function(){
                 		if(store.getCount()) {
                 			if (studentLanguageDocGrid.isHidden()) {
                 				studentLanguageDocGrid.setVisible(true);
                 			}	
                 		}
                 	}
                 });
             }else{
             	var contentPanelTab = $this.getContentPanelActiveTab();
             	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
             	var a = personInfoPanel.down('studentlanguageinformationgrid');
     			var selectedRec = a.getSelectionModel();
             	store.getProxy().extraParams = {
     			  ID: selectedRec.getSelection()[0].data.id
     			};
     	  					
     			var studentDocLanguageGrid = $this.getStudentlanguagedocumentgrid();
     			store.load({
         			callback: function(){
         				if(store.getCount()) {
         					if (studentDocLanguageGrid.isHidden()) {
         						studentDocLanguageGrid.setVisible(true);
         					}	
         				}
         			}
         		});
             }
         },
         studentLanguageUrlContainerWindow: function(){
          	var $this = this;
          	var StudentUrlGrid = Ext.ComponentQuery.query('studentlanguageurlgrid');
              var store = StudentUrlGrid[0].store;

              var portalId = $this.getCurrentLoggedPortalId(); 
              if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
              	var personInfoPanel  = $this.getStudentlanguageinformationgrid();
          		var selectedRec = personInfoPanel.getSelectionModel();
          		if (portalId == 2){
      	            store.getProxy().extraParams = {
      	            	ID: selectedRec.getSelection()[0].data.id
      	    		};
          		} else {
          			store.getProxy().extraParams = {
      	            	ID: selectedRec.getSelection()[0].data.id
      	    		};
          		}
          		var studentUrlLanguageGrid = $this.getStudentlanguageurlgrid();
      			store.load({
          			callback: function(){
          				if(store.getCount()) {
          					if (studentUrlLanguageGrid.isHidden()) {
          						studentUrlLanguageGrid.setVisible(true);
          					}
          				}
          			}
          		});
              }else{
      	        var contentPanelTab = $this.getContentPanelActiveTab();
      			var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
      			var a  = personInfoPanel.down('studentlanguageinformationgrid'); 	
      	        var selectedRec = a.getSelectionModel();
              	store.getProxy().extraParams = {
      			  ID: selectedRec.getSelection()[0].data.id
      			};
              	var stdUrlLanguageGrid = $this.getStudentlanguageurlgrid();
      			store.load({
          			callback: function(){
          				if(store.getCount()) {
          					if (stdUrlLanguageGrid.isHidden()) {
          						stdUrlLanguageGrid.setVisible(true);
          					}
          				}
          			}
          		});
              }
      				  					
          },
	    studentThesisUploadDocumentContainerWindow: function(){
	        var $this = this;
	        var StudentExaminerReportDocumentGrid = Ext.ComponentQuery.query('studentthesisuploaddocumentgrid');
	        var store = StudentExaminerReportDocumentGrid[0].getStore();
	        var studentThesisUploadGrid = Ext.ComponentQuery.query('[itemId=studentThesisUploadGridId]');
	        var currentId = 0;
	        var studentThesisUploadGridSelected = studentThesisUploadGrid[0].getSelectionModel().selected;
	        currentId = studentThesisUploadGridSelected.items[0].data.id;
	        if( currentId != 0 ){
	        	store.getProxy().extraParams = {
				  ID: currentId
				};
				store.load();
				var studentThesisUploadGrid = this.getStudentThesisUploadDocumentGrid();
				if (studentThesisUploadGrid.isHidden() /*&& store.data.items.length > 0*/) {
					studentThesisUploadGrid.setVisible(true);
				}	  					
	        }	
	    
	    },
	    makeFieldAllowBlankAndMandatoryForMedicalDetails:function(form){
    		var me = this, fieldCmp, parentField, fieldLable,formFields = form.getForm();
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'medicaldetailsform',
    				academyLocationId: this.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				if(Object.keys(response).length > 0 ){
    					response.medicaldetailsform.forEach(function(rec){
    						fieldCmp = form.down('#'+rec.formFieldId);
    						if(!fieldCmp){
    							fieldCmp = formFields.findField(rec.formFieldName);
    						}
    						if(fieldCmp){
    							if(rec.isVisible){
    								me.setAllowBlank(fieldCmp, !rec.isMandatory);
    							}else{
    								me.setAllowBlank(fieldCmp, true);
    							}
    							fieldCmp.setVisible(rec.isVisible);
    							me.removeDoubleColonFromField(fieldCmp,rec.formFieldLabel);
    							if(rec.formFieldId == 'familyPractionerContactNumberItemId'){
    								fieldCmp.setFieldLabel('');
    							}
    						}
    					});
    				}
    			}
    		});
	    },
	    removeDoubleColonFromField:function(field,dfrLable){
			   if(field && field.labelEl){
				   var asteriskOccurance = (field.labelEl.dom.textContent.match(/:/g) || []).length;
				   if(asteriskOccurance>1){
					   if(field.labelEl.dom.textContent.includes('*')){
						   field.labelEl.dom.innerHTML=dfrLable+':<span class="required" style="color:red"> *</span>';
					   }
				   }
			   }
		},
	    sendDocument:function(grid, userCmp){
	    	var me = this,count=0,studentDocThysisRec=[],userList=[],
        	selectedRec = grid.getSelectionModel().getSelection(),
        	userExamPanel = grid.down('#userExamPanel'),
        	personId = me.getContentPanelActiveTab().personId,
        	userVal= userExamPanel.getValue();
	    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	selectedRec.forEach(function(rec){
	    		count =0;
	    		    for(count=0;count<rec.data.studentThesisUploadDocuments.length;count++){
	    		    	studentDocThysisRec.push(rec.data.studentThesisUploadDocuments[count].id)
	    		    }
	    		});
	    	if(userVal && userVal.length == 1 && !Ext.isEmpty(userVal[0])){
   			 try{
   				userList=Ext.pluck(Ext.pluck(userVal, 'data'), 'id');
   			 }catch(e){
   				userList= userVal
   			 }
   			 
      		 }else if(userVal && userVal.length >1){
      			 try{
      				userList=Ext.pluck(Ext.pluck(userVal, 'data'), 'id');
   			 }catch(e){
   				userList=userVal
   			 }
      		}
	    	var requestPayload = {
	    			user : userList,
	    			personId : personId,
	    			documentId : studentDocThysisRec
	    	},
	    	requestPayload = Ext.encode(requestPayload);
	    	Ext.Ajax.request({
	    		type: 'rest',
	    		url: SERVERURL.PATH_SAVE_FOR_STUDENT_EXAMINER_THESIS_DOCUMENT,
	    		method: 'POST',
				jsonData: requestPayload,
	    		success: function(res, action) {
	    			Ext.getBody().unmask();	 
	    			showSuccessMessage(getExaminationTranslation('SEND_DOCUMENT'), getCommonTranslation('SUCCESS'));
	    			grid.getSelectionModel().deselectAll();
	    			
	    		}
	    	});
	    }
});