/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.controller.personinfo.studentportalangularsetup.StudentPortalAngularLoginSetupController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : [
		'setup.loginPageSetup.AngularConfigureMenuListStore',
		'setup.loginPageSetup.AngularConfigureSubMenuListStore'
	],
	views : [
		'studentportalangularloginsetup.StudentPortalAngularLoginSetupStructure',
		'studentportalangularloginsetup.StudentPortalAngularLoginConfigureScreen',
		'studentportalangularloginsetup.StudentPortalAngularLoginConfigureMenu'
	],	           
	config: {},
	refs : [{
		ref: 'studentportalangularloginsetupstructure',
		selector: 'studentportalangularloginsetupstructure'
	},{
		ref: 'studentportalangularloginconfigurescreen',
		selector: 'studentportalangularloginconfigurescreen'
	},{
		ref: 'studentportalangularloginconfiguremenu',
		selector: 'studentportalangularloginconfiguremenu'
	}],
	init : function() {
		this.control({
			'studentportalangularloginconfiguremenu grid[itemId=moduleMainGrid]':{
				afterrender:function(grid){
					var me = this;
					grid.getStore().load();
				},
				selectionchange: this.onModuleSelect,
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
			        var column = grid.getHeaderCt().getHeaderAtIndex(cellIndex);
			        if (column.dataIndex === 'isVisiable') {
			            grid.getSelectionModel().select(record);
			        }
			    }
			},
			'studentportalangularloginconfiguremenu button[itemId=saveMenuConfigurationBtn]':{
				click: function(btn){
					var me = this;
					var grid = btn.up('grid');

					var records = grid.getStore().getRange();
					var submitValue = [];
					for(var i in records){
						var data={
								id: records[i].data.id,
								moduleCode:records[i].data.moduleCode,
								moduleName:records[i].data.moduleName,
								isVisiable:records[i].data.isVisiable,
								sequence:records[i].data.sequence
						};
						submitValue.push(data);
					}
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var	submitUrl=SERVERURL.PATH_UPDATE_ANGULAR_MENU_CONFIGURATION;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : submitValue,
						method : 'POST',
						success : function(form, action) {
							Ext.getBody().unmask();
							showSuccessMessage(getCommonTranslation('STUDENT_PORTAL_SIDE_MENU_CONFIGURATION'),getCommonTranslation('SUCCESS'));
							grid.getStore().reload();
						}
					});
				}
			},
			'studentportalangularloginconfigurescreen': {
				afterrender: function(loginForm){
					var me = this;
					
					var idField = loginForm.down('[name=id]');
					var logoUrlHiddenField = loginForm.down('[name=logoUrlHidden]');
					var backgroundImgUrlHiddenField = loginForm.down('[name=backgroundImgUrlHidden]');
					var uploadIcon1UrlHiddenField = loginForm.down('[name=uploadIcon1UrlHidden]');
					var uploadIcon2UrlHiddenField = loginForm.down('[name=uploadIcon2UrlHidden]');
					var uploadIcon3UrlHiddenField = loginForm.down('[name=uploadIcon3UrlHidden]');
					var forgotPwdLogoUrlHiddenField = loginForm.down('[name=forgotPwdLogoUrlHidden]');
					var logoUrlField = loginForm.down('[name=logoUpload]');
					var backgroundImgUrlField = loginForm.down('[name=backgroundImageUpload]');
					var uploadIcon1UrlField = loginForm.down('[name=guidelineIcon1]');
					var uploadIcon2UrlField = loginForm.down('[name=guidelineIcon2]');
					var uploadIcon3UrlField = loginForm.down('[name=guidelineIcon3]');
					var forgotPwdLogoUrlField = loginForm.down('[name=forgotPasswordLogo]');
					var sameAsForgotPasswordPageField = loginForm.down('[name=sameAsForgotPasswordPage]');
					var welcomeMessageField = loginForm.down('[name=welcomeMessage]');
					var usernameLabelField = loginForm.down('[name=usernameLabel]');
					var passwordLabelField = loginForm.down('[name=passwordLabel]');
					var submitBtnLabelField = loginForm.down('[name=submitBtnLabel]');
					var otherLoginOptionsField = loginForm.down('[name=otherLoginOptions]');
					var customizeLabelField = loginForm.down('[name=customizeLabel]');
					var redirectionUrlsField = loginForm.down('[name=redirectionUrls]');
					var enableHowToUserGuideField = loginForm.down('[name=enableHowToUserGuide]');
					var howToGuideTitleTextField = loginForm.down('[name=howToGuideTitleText]');
					var guidelineLabel1Field = loginForm.down('[name=guidelineLabel1]');
					var guidelineUrl1Field = loginForm.down('[name=guidelineUrl1]');
					var guidelineLabel2Field = loginForm.down('[name=guidelineLabel2]');
					var guidelineUrl2Field = loginForm.down('[name=guidelineUrl2]');
					var guidelineLabel3Field = loginForm.down('[name=guidelineLabel3]');
					var guidelineUrl3Field = loginForm.down('[name=guidelineUrl3]');
					var forgotPasswordUsernameLabelField = loginForm.down('[name=forgotPasswordUsernameLabel]');
					var forgotPasswordLinkLabelField = loginForm.down('[name=forgotPasswordLinkLabel]');
					var capthaVerificationRequiredField = loginForm.down('[name=capthaVerificationRequired]');
					var captchaRedirectUrlField = loginForm.down('[name=captchaRedirectUrl]');
					var googleSSOField = loginForm.down('[name=googleSSO]');
					var termsAndConditionsCheckField = loginForm.down('[name=termsAndConditionsCheck]');
					var ssoProviderField = loginForm.down('[name=ssoProvider]');
					
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var	submitUrl=SERVERURL.PATH_GET_ANGULAR_LOGIN_PAGE_CONFIGURATION;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						method : 'GET',
						success : function(response, action) {
							Ext.getBody().unmask();
							if(response.responseText != ''){
								var data = Ext.decode(response.responseText);
								var formData = data[0];
								
								idField.setValue(formData.id);
								logoUrlHiddenField.setValue(formData.logoUrl);
								backgroundImgUrlHiddenField.setValue(formData.backgroundImgUrl);
								uploadIcon1UrlHiddenField.setValue(formData.instructionIconUrl1);
								uploadIcon2UrlHiddenField.setValue(formData.instructionIconUrl2);
								uploadIcon3UrlHiddenField.setValue(formData.instructionIconUrl3);
								forgotPwdLogoUrlHiddenField.setValue(formData.forgetPasswordLogoUrl);
								logoUrlField.setRawValue(formData.logoUrl);
								backgroundImgUrlField.setRawValue(formData.backgroundImgUrl);
								uploadIcon1UrlField.setRawValue(formData.instructionIconUrl1);
								uploadIcon2UrlField.setRawValue(formData.instructionIconUrl2);
								uploadIcon3UrlField.setRawValue(formData.instructionIconUrl3);
								forgotPwdLogoUrlField.setRawValue(formData.forgetPasswordLogoUrl);
								sameAsForgotPasswordPageField.setValue(formData.sameASforgetPassword);
								welcomeMessageField.setValue(formData.welcomeMsg);
								usernameLabelField.setValue(formData.userNameLable);
								passwordLabelField.setValue(formData.passwordLable);
								submitBtnLabelField.setValue(formData.submitButtonLabel);
								otherLoginOptionsField.setValue(formData.isSSOLogin);
								customizeLabelField.setValue(formData.ssolableName);
								redirectionUrlsField.setValue(formData.ssoRedirectUrl);
								enableHowToUserGuideField.setValue(formData.isEnableUserGuide);
								howToGuideTitleTextField.setValue(formData.userGuideTitleText);
								guidelineLabel1Field.setValue(formData.instructionLableName1);
								guidelineUrl1Field.setValue(formData.instructionRedirctionUrl1);
								guidelineLabel2Field.setValue(formData.instructionLableName2);
								guidelineUrl2Field.setValue(formData.instructionRedirctionUrl2);
								guidelineLabel3Field.setValue(formData.instructionLableName3);
								guidelineUrl3Field.setValue(formData.instructionRedirctionUrl3);
								forgotPasswordUsernameLabelField.setValue(formData.forgetPasswordUserNameLable);
								forgotPasswordLinkLabelField.setValue(formData.forgetPasswordLinkLabel);
								capthaVerificationRequiredField.setValue(formData.isCaptchaApplicable);
								captchaRedirectUrlField.setValue(formData.redirectUrl);
								termsAndConditionsCheckField.setValue(formData.termsAndConditionsCheck);
								googleSSOField.setValue(formData.googleSSO);
								ssoProviderField.getStore().load({
                					 callback: function(records, operation, success) {
                						 if (success && records && formData && formData.ssoProviderId) {
 											var record = ssoProviderField.getStore().findRecord('id', formData.ssoProviderId);
 											if (record) {
 												ssoProviderField.setValue(record.get('id'));
 											} 
 										}
                					 }	   
                				 });
							}
						}
					});
				}
			},
			'studentportalangularloginconfigurescreen filefield': {
    			change : function(fileField, value, eOpts) {
        	        this.onSelectUploadLoginFileField(fileField, value, eOpts);
        	    }
    		},
			'studentportalangularloginconfigurescreen button[itemId=saveSPLoginConfigBtn]': {
				click: function(btn){
					var me = this;
					var form = btn.up('studentportalangularloginconfigurescreen');
					me.saveLoginConfig(form)
				}
			},
			'studentportalangularloginconfigurescreen button[itemId=resetSPLoginConfigBtn]': {
				click: function(btn){
					var me = this;
					var loginForm = btn.up('studentportalangularloginconfigurescreen');
					
					loginForm.fireEvent('afterrender', loginForm);
				}
			},'studentportalangularloginconfigurescreen displayfield[itemId=logoUploadLink]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getStudentportalangularloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().logoUrlHidden
        					var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        				});
        				 
        		  });
				
				}
			},'studentportalangularloginconfigurescreen displayfield[itemId=backgroundImageUploadLink]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getStudentportalangularloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().backgroundImgUrlHidden
        					var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        				});
        				 
        		  });
				
				}
			},'studentportalangularloginconfigurescreen displayfield[itemId=guidelineIcon1Link]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getStudentportalangularloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().uploadIcon1UrlHidden
        					var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        				});
        				 
        		  });
				
				}
			},'studentportalangularloginconfigurescreen displayfield[itemId=guidelineIcon2Link]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getStudentportalangularloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().uploadIcon2UrlHidden
        					var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        				});
        				 
        		  });
				
				}
			},'studentportalangularloginconfigurescreen displayfield[itemId=guidelineIcon3Link]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getStudentportalangularloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().uploadIcon3UrlHidden
        					var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        				});
        				 
        		  });
				
				}
			},'studentportalangularloginconfigurescreen displayfield[itemId=forgotPasswordLogoLink]': {
				  render: function(component) {
					  var $this = this;
					  component.getEl().on('click', function(e) {
        					var loginForm = $this.getStudentportalangularloginconfigurescreen();
        					var logoUrlHiddens=loginForm.getValues().forgotPwdLogoUrlHidden
        					var csvForm = Ext.create('Ext.form.Panel'); 
        						csvForm.getForm().submit({
        							target: '_blank',
        							method:'GET',
        							params :{
        								access_token : Ext.Ajax.defaultHeaders.access_token,
        								imagesPath:logoUrlHiddens
        							},
        							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        							url: SERVERURL.PATH_LOGIN_PAGE_DOCUMENT_DOWNLOAD,
        							standardSubmit :true
        				});
        				 
        		  });
				
				}
			},
			'studentportalangularloginconfiguremenu button[itemId=saveSubMenuConfigurationBtn]': {
				click: this.saveSubMenuConfiguration
			}
		});
	},
	onSelectUploadLoginFileField: function (fileField, value, eOpts) {
	    if (!isNullOrEmpty(value)) {
	        var studentportalangularloginconfigurescreen = fileField.up('studentportalangularloginconfigurescreen');
	        if(fileField.fileInputEl.dom.files.length==0)
	        	{
	        	return;
	        	}
	        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
	        value = value.replace('C:\\fakepath\\', '');
            var newValue = value.replace(/ +/g, " ").split(' ').join('_');
            fileField.setRawValue(newValue);
	        // Validate file extension
	        if ((extension === "gif") || (extension === "png") || (extension === "bmp") || 
	            (extension === "jpeg") || (extension === "jpg")) {
	            var submitUrl = SERVERURL.PATH_UPLOAD_STUDENT_PORTAL_IMG;

	            // Create a runtime form dynamically
	            var tempForm = Ext.create('Ext.form.Panel', {
	                standardSubmit: false,
	                renderTo: Ext.getBody(), // Render form to the body
	                layout: 'fit',
	                hidden: true,
	                items: [
	                    {
	                        xtype: 'filefield',
	                        name: 'file',
	                        inputType: 'file',
	                        listeners: {
	                            afterrender: function (field) {
	                                field.fileInputEl.dom.files = fileField.fileInputEl.dom.files; // Sync the selected file
	                            }
	                        }
	                    },
	                    {
	                        xtype: 'hiddenfield',
	                        name: 'entityId',
	                        value: '110'
	                    },
	                    {
	                        xtype: 'hiddenfield',
	                        name: 'module',
	                        value: 'login_page_setup'
	                    },
	                    {
	                        xtype: 'hiddenfield',
	                        name: 'entityType',
	                        value: 'student_responsive_login_page'
	                    }
	                ]
	            });

	            // Submit the form
	            tempForm.getForm().submit({
	                url: submitUrl,
	                method: 'POST',
	                enctype: 'multipart/form-data', // Necessary for file upload
	                clientValidation: false,
	                success: function (form, action) {
	                    // Update corresponding hidden fields based on the fileField name
	                    if (fileField.name === "logoUpload") {
	                        studentportalangularloginconfigurescreen.down('[name=logoUrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "backgroundImageUpload") {
	                        studentportalangularloginconfigurescreen.down('[name=backgroundImgUrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "guidelineIcon1") {
	                        studentportalangularloginconfigurescreen.down('[name=uploadIcon1UrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "guidelineIcon2") {
	                        studentportalangularloginconfigurescreen.down('[name=uploadIcon2UrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "guidelineIcon3") {
	                        studentportalangularloginconfigurescreen.down('[name=uploadIcon3UrlHidden]').setValue(action.result.path);
	                    }
	                    if (fileField.name === "forgotPasswordLogo") {
	                        studentportalangularloginconfigurescreen.down('[name=forgotPwdLogoUrlHidden]').setValue(action.result.path);
	                    }
	                	// Destroy the temporary form after submission
	    	            tempForm.destroy();
	                },
	                failure: function (form, action) {
	    	            fileField.reset();
	    	            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getCommonTranslation('FILE_UPLOAD_FAILED'));
	    	            tempForm.destroy();
	                }
	            });

	            
	        } else {
	            fileField.reset();
	            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
	        }
	    }
	},
	saveLoginConfig: function(loginForm){
		var me = this;
		
		var idField = loginForm.down('[name=id]');
		var logoUrlHiddenField = loginForm.down('[name=logoUrlHidden]');
		var backgroundImgUrlHiddenField = loginForm.down('[name=backgroundImgUrlHidden]');
		var uploadIcon1UrlHiddenField = loginForm.down('[name=uploadIcon1UrlHidden]');
		var uploadIcon2UrlHiddenField = loginForm.down('[name=uploadIcon2UrlHidden]');
		var uploadIcon3UrlHiddenField = loginForm.down('[name=uploadIcon3UrlHidden]');
		var forgotPwdLogoUrlHiddenField = loginForm.down('[name=forgotPwdLogoUrlHidden]');
		var sameAsForgotPasswordPageField = loginForm.down('[name=sameAsForgotPasswordPage]');
		var welcomeMessageField = loginForm.down('[name=welcomeMessage]');
		var usernameLabelField = loginForm.down('[name=usernameLabel]');
		var passwordLabelField = loginForm.down('[name=passwordLabel]');
		var submitBtnLabelField = loginForm.down('[name=submitBtnLabel]');
		var otherLoginOptionsField = loginForm.down('[name=otherLoginOptions]');
		var customizeLabelField = loginForm.down('[name=customizeLabel]');
		var redirectionUrlsField = loginForm.down('[name=redirectionUrls]');
		var enableHowToUserGuideField = loginForm.down('[name=enableHowToUserGuide]');
		var howToGuideTitleTextField = loginForm.down('[name=howToGuideTitleText]');
		var guidelineLabel1Field = loginForm.down('[name=guidelineLabel1]');
		var guidelineUrl1Field = loginForm.down('[name=guidelineUrl1]');
		var guidelineLabel2Field = loginForm.down('[name=guidelineLabel2]');
		var guidelineUrl2Field = loginForm.down('[name=guidelineUrl2]');
		var guidelineLabel3Field = loginForm.down('[name=guidelineLabel3]');
		var guidelineUrl3Field = loginForm.down('[name=guidelineUrl3]');
		var forgotPasswordUsernameLabelField = loginForm.down('[name=forgotPasswordUsernameLabel]');
		var forgotPasswordLinkLabelField = loginForm.down('[name=forgotPasswordLinkLabel]');
		var capthaVerificationRequiredField = loginForm.down('[name=capthaVerificationRequired]');
		var captchaRedirectUrlField = loginForm.down('[name=captchaRedirectUrl]');
		var termsAndConditionsCheck = loginForm.down('[name=termsAndConditionsCheck]');
		var googleSSO = loginForm.down('[name=googleSSO]');
		var ssoProviderField = loginForm.down('[name=ssoProvider]');

		if(capthaVerificationRequiredField.getValue()){
			var captchaFieldVal = capthaVerificationRequiredField.getValue();
			var isCaptcha = captchaFieldVal.capthaVerificationRequired;
		}
		else{
			var isCaptcha = false;
		}

		var submitData = {
		    "id": idField.getValue(),
		    "logoUrl": logoUrlHiddenField.getValue(),
		    "backgroundImgUrl": backgroundImgUrlHiddenField.getValue(),
		    "sameASforgetPassword": sameAsForgotPasswordPageField.getValue(),
		    "welcomeMsg": welcomeMessageField.getValue(),
		    "userNameLable": usernameLabelField.getValue(),
		    "passwordLable": passwordLabelField.getValue(),
		    "submitButtonLabel": submitBtnLabelField.getValue(),
		    "isSSOLogin": otherLoginOptionsField.getValue(),
		    "ssolableName": customizeLabelField.getValue(),
		    "ssoRedirectUrl": redirectionUrlsField.getValue(),
		    "isEnableUserGuide": enableHowToUserGuideField.getValue(),
		    "userGuideTitleText": howToGuideTitleTextField.getValue(),
		    "instructionIconUrl1": uploadIcon1UrlHiddenField.getValue(),
		    "instructionLableName1": guidelineLabel1Field.getValue(),
		    "instructionRedirctionUrl1": guidelineUrl1Field.getValue(),
		    "instructionIconUrl2": uploadIcon2UrlHiddenField.getValue(),
		    "instructionLableName2": guidelineLabel2Field.getValue(),
		    "instructionRedirctionUrl2": guidelineUrl2Field.getValue(),
		    "instructionIconUrl3": uploadIcon3UrlHiddenField.getValue(),
		    "instructionLableName3": guidelineLabel3Field.getValue(),
		    "instructionRedirctionUrl3": guidelineUrl3Field.getValue(),
		    "forgetPasswordLogoUrl": forgotPwdLogoUrlHiddenField.getValue(),
		    "forgetPasswordUserNameLable": forgotPasswordUsernameLabelField.getValue(),
		    "forgetPasswordLinkLabel": forgotPasswordLinkLabelField.getValue(),
		    "isCaptchaApplicable": isCaptcha,
		    "redirectUrl": captchaRedirectUrlField.getValue(),
			"termsAndConditionsCheck":termsAndConditionsCheck.getValue(),
			"googleSSO":googleSSO.getValue(),
			"ssoProviderId":ssoProviderField.getValue()
		}

		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var	submitUrl=SERVERURL.PATH_UPDATE_ANGULAR_LOGIN_CONFIGURATION;
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : submitData,
			method : 'POST',
			success : function(form, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getCommonTranslation('CONFIGURE_SCREEN'),getCommonTranslation('SUCCESS'));
				loginForm.fireEvent('afterrender', loginForm);
			}
		});
	},
	
	onModuleSelect: function(sm, selected) {
		var structure = sm.view.up('studentportalangularloginconfiguremenu');
		var childGrid = structure.down('#subModuleChildGrid');
		childGrid.show();
		var store = childGrid.getStore();
		store.getProxy().extraParams = {
			studentPortalMenuConfigurationId: selected[0].get('id')
		};
		store.load();
	},
	
	saveSubMenuConfiguration: function (btn) {
	    var me = this;
	    var grid = btn.up('grid');
	    var records = grid.getStore().getRange();
	    var submitValue = [];
	    for (var i in records) {
	        var data = {
	            id: records[i].data.id,
	            moduleCode: records[i].data.moduleCode,
	            moduleName: records[i].data.moduleName,
	            isVisiable: records[i].data.isVisiable,
	            sequence: records[i].data.sequence,
	            studentPortalMenuConfiguration: records[i].data.studentPortalMenuConfiguration
	        };
	        submitValue.push(data);
	    }
	    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    Ext.Ajax.request({
	        type: 'rest',
	        url: SERVERURL.PATH_UPDATE_STUDENT_PORTAL_SUB_MENU_CONFIGURATION,
	        jsonData: submitValue,
	        method: 'POST',
	        success: function (form, action) {
	            Ext.getBody().unmask();
	            showSuccessMessage(getCommonTranslation('STUDENT_PORTAL_SIDE_MENU_CONFIGURATION'), getCommonTranslation('SUCCESS'));
	            grid.getStore().reload();
	        }
	    });
	}
});