/**
 * Raghavendra.Soni
 */
Ext.define('Academia.controller.prereqnotmetreport.PreReqNotmetReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [
		'common.PreReqNotMetReportStore'
	],
	views: [
		'prereqnotmetreport.PreReqNotMetReportStructure',
		'prereqnotmetreport.PreReqNotMetReportFilter',
		'prereqnotmetreport.PreReqNotMetReportGrid',
 		'coursetransaction.studentcourseenrollment.studentenrollmentdetail.AdditionalRequisiteWin',
 		'prereqnotmetreport.NotMetModuleGridWin'
	],
	config: {
		PREREQ_NOT_MET_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PREREQ_NOT_MET_REPORT_PRIVILEGES'),
	},
	refs: [{
		ref: 'prereqnotmetreportstructure',
		selector: 'prereqnotmetreportstructure'
	},{
		ref: 'prereqnotmetreportfilter',
		selector: 'prereqnotmetreportfilter'
	},{
		ref: 'prereqnotmetreportgrid',
		selector: 'prereqnotmetreportgrid'
	},{
		ref: 'additionalrequisitewin',
		selector: 'additionalrequisitewin'
	},{
		ref: 'notmetmodulegridwin',
		selector: 'notmetmodulegridwin'
	}],
	init: function(application) {
		this.control({
			'prereqnotmetreportstructure':{
				afterrender: function(structure) {

				}
			},
			'prereqnotmetreportfilter radiogroup[itemId=reportType]':{
    			change: function(radioField, newValue, oldValue, eOpts) {
    				var form = radioField.up('form');
    				
    				var alField = form.down('#academyLocationId');
					var academicTermField = form.down('#academicTerm');
					var programField = form.down('#programId');
					var batchField = form.down('#batchId');
					var periodField = form.down('#periodId');
					var courseField = form.down('#courseId');
					var studentField = form.down('#studentId');
					var suNumberField = form.down('#suNumber');
					
					alField.reset();
					academicTermField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();
					courseField.reset();
					studentField.reset();
					suNumberField.reset();
					
    				if(newValue.reportType == false){
    					alField.setDisabled(true);
    				}
    				else{
    					alField.setDisabled(false);
    				}

					academicTermField.setDisabled(true);
					programField.setDisabled(true);
					batchField.setDisabled(true);
					periodField.setDisabled(true);
					courseField.setDisabled(true);
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					form.isValid();
            	}
    		},
			'prereqnotmetreportgrid':{
				afterrender: function(grid){
					grid.getStore().removeAll();
				},
				cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
	   				 var $this=this;
	   				 var grid = view.ownerCt;
	   				 var columnId=view.ownerCt.columnManager.columns[cellIndex].columnId;
	   				 var columnName = view.ownerCt.columnManager.columns[cellIndex].dataIndex;

	   				if(e.target.tagName=='A'){
	   					if(columnName == "preRequisiteJson"){
	   						var preRequisiteCriteriaJson = record.raw.preRequisiteJson;

	   						var formWindow = $this.getAdditionalrequisitewin();
	   						if (!formWindow) {
	   							Ext.widget('additionalrequisitewin');
	   							formWindow = this.getAdditionalrequisitewin();
	   						}
	   						formWindow.show();

	   						var winHtml = '';

	   						if(!isNullOrEmpty(preRequisiteCriteriaJson)){
	   							winHtml = winHtml + '<strong>'+getCommonTranslation('PRE_REQUISITE_CRITERIA')+':</strong><br /><pre>'+preRequisiteCriteriaJson+'</pre><br />';
	   						}
	   						
	   						Ext.each(record.data.courseAndMarksMap, function(currentCourse){
	   							var corseName = Object.keys(currentCourse)[0];
	   							
	   							winHtml = winHtml.replace(corseName,"<span class='highlight-span-text'>"+corseName+"</span>");
	   						});

	   						formWindow.body.el.setHTML(winHtml);
	   					}
	   					else if(columnName == "courseAndMarksMapString"){
	   						var courseAndMarksMap = record.data.courseAndMarksMap;
	   						var storeData = [];
	   						Ext.each(courseAndMarksMap, function(currentCourseAndMarksMap){
	   		    				var i = 0;
	   		    				Ext.each(Object.keys(currentCourseAndMarksMap), function(currentRec){

	   		        				var moduleName = Object.keys(currentCourseAndMarksMap)[i];
	   		        				var moduleMarks = Object.values(currentCourseAndMarksMap)[i];
	   		        				storeData.push({
	   		        					moduleName: moduleName,
	   		        					moduleMarks: moduleMarks
	   		        				});
	   		        				
	   		        				i = i+1;
	   		    				});
	   		    			});
	   						
	   						
	   						var formWindow = $this.getNotmetmodulegridwin();
	   						if (!formWindow) {
	   							Ext.widget('notmetmodulegridwin',{
	   								gridData: storeData
	   							});
	   							formWindow = this.getNotmetmodulegridwin();
	   						}
	   						formWindow.show();
	   					}
	   				}
				}
			},
			'prereqnotmetreportfilter button[itemId=searchBtn]':{
				click: function(btn) {
					var form = btn.up('form');
					var formValues = form.getValues();
					
					var structure = btn.up('prereqnotmetreportstructure');
					var grid = structure.down('grid');
					
					var gridStore = grid.getStore();
					
					if(formValues.reportType == true){
						gridStore.getProxy().extraParams = {
							isInvalidOnly : false,
							alIds: formValues.academyLocation+"",
							academicTermId: formValues.academicTerm,
							programId : formValues.programId,
							periods : formValues.periodId,
							batches : formValues.batch,
							courseIds : (!isNullOrEmpty(formValues.courseId) && formValues.courseId.length && !isNullOrEmpty(formValues.courseId[0])) ? Ext.Array.pluck(Ext.Array.pluck(formValues.courseId,'data'),'courseId').join() : null, 
							studentIds : (!isNullOrEmpty(formValues.studentId) && formValues.studentId.length && !isNullOrEmpty(formValues.studentId[0])) ? Ext.Array.pluck(Ext.Array.pluck(formValues.studentId,'data'),'userId').join() : null,
							suNumber: (!isNullOrEmpty(formValues.suNumber) && formValues.suNumber.length && !isNullOrEmpty(formValues.suNumber[0])) ? Ext.Array.pluck(Ext.Array.pluck(formValues.suNumber,'data'),'suNumber').join() : null
						};
					}
					else{
						gridStore.getProxy().extraParams = {
							isInvalidOnly : true
						};
					}
					
					gridStore.load();

					/*var url = SERVERURL.PATH_GET_PRE_REQUISITE_REPORT_FOR_ENROLLED_STUDENT;
					Ext.Ajax.request({
						type : 'rest',
						url : url,
						params : {
							
						},
						method : 'GET',
						success : function(response) {
							var data = Ext.decode(response.responseText);
							
						}
					});*/
				}
			},
			'prereqnotmetreportfilter button[itemId=resetBtn]':{
				click: function(btn) {
					var form = btn.up('form');
					form.getForm().reset();
				}
			},
			'prereqnotmetreportfilter [itemId=academyLocationId]':{
				select: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					academicTermField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();
					courseField.reset();
					studentField.reset();
					suNumberField.reset();
					
					academicTermField.setDisabled(true);
					programField.setDisabled(true);
					batchField.setDisabled(true);
					periodField.setDisabled(true);
					courseField.setDisabled(true);
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					if(!isNullOrEmpty(alField.getValue())){
						academicTermField.setDisabled(false);
					}
				}
			},
			'prereqnotmetreportfilter [itemId=academicTerm]':{
				change: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					programField.reset();
					batchField.reset();
					periodField.reset();
					courseField.reset();
					studentField.reset();
					suNumberField.reset();
					
					programField.setDisabled(true);
					batchField.setDisabled(true);
					periodField.setDisabled(true);
					courseField.setDisabled(true);
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					var academyLocationId = [];
					academyLocationId.push(alField.getValue());
					if(!isNullOrEmpty(academicTermField.getValue())){
						programFieldStore.getProxy().extraParams = {
							academyLocationIds: academyLocationId.join(),
							academicTermId: academicTermField.getValue()
						};
						programFieldStore.load();
						programField.setDisabled(false);
					}
				}
			},
			'prereqnotmetreportfilter [itemId=programId]':{
				select: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					batchField.reset();
					periodField.reset();
					courseField.reset();
					studentField.reset();
					suNumberField.reset();
					
					batchField.setDisabled(true);
					periodField.setDisabled(true);
					courseField.setDisabled(true);
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					if(!isNullOrEmpty(programField.getValue())){
						batchFieldStore.getProxy().extraParams = {
							id: programField.getValue()
						};
						batchFieldStore.load();
						batchField.setDisabled(false);
					}
				}
			},
			'prereqnotmetreportfilter [itemId=batchId]':{
				select: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					periodField.reset();
					courseField.reset();
					studentField.reset();
					suNumberField.reset();
					
					periodField.setDisabled(true);
					courseField.setDisabled(true);
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					if(!isNullOrEmpty(batchField.getValue())){
						periodFieldStore.getProxy().extraParams = {
							batchId: batchField.getValue()
						};
						periodFieldStore.load();
						periodField.setDisabled(false);
					}
				}
			},
			'prereqnotmetreportfilter [itemId=periodId]':{
				select: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var periodId = [];
					periodId.push(periodField.getValue());
					
					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					courseField.reset();
					studentField.reset();
					suNumberField.reset();
					
					courseField.setDisabled(true);
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					if(!isNullOrEmpty(periodField.getValue())){
						courseFieldStore.getProxy().extraParams = {
							periods: periodId.join()
						};
						courseFieldStore.load();
						courseField.setDisabled(false);
						
						studentFieldStore.getProxy().extraParams = {
							periods: periodId.join(),
							forStudent: true
						};
						studentFieldStore.load();
						
						studentField.setDisabled(false);
					}
				}
			},
			'prereqnotmetreportfilter [itemId=courseId]':{
				change: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var periodId = [];
					periodId.push(periodField.getValue());
					
					var courseId = courseField.getValue();
					
					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					studentField.reset();
					suNumberField.reset();
					
					studentField.setDisabled(true);
					suNumberField.setDisabled(true);
					
					if(!isNullOrEmpty(courseField.getValue())){
						studentFieldStore.getProxy().extraParams = {
							periods: periodId.join(),
							courseIds: courseId.join(),
							forStudent: true
						};
						studentFieldStore.load();
						studentField.setDisabled(false);
					}
				}
			},
			'prereqnotmetreportfilter [itemId=studentId]':{
				change: function(field) {
					var alField = field.up('form').down('#academyLocationId');
					var academicTermField = field.up('form').down('#academicTerm');
					var programField = field.up('form').down('#programId');
					var batchField = field.up('form').down('#batchId');
					var periodField = field.up('form').down('#periodId');
					var courseField = field.up('form').down('#courseId');
					var studentField = field.up('form').down('#studentId');
					var suNumberField = field.up('form').down('#suNumber');
					
					var periodId = [];
					periodId.push(periodField.getValue());
					
					var courseId = courseField.getValue();
					var studentId = studentField.getValue();

					var alFieldStore = alField.getStore();
					var academicTermFieldStore = academicTermField.getStore();
					var programFieldStore = programField.getStore();
					var batchFieldStore = batchField.getStore();
					var periodFieldStore = periodField.getStore();
					var courseFieldStore = courseField.getStore();
					var studentFieldStore = studentField.getStore();
					var suNumberFieldStore = suNumberField.getStore();
					
					suNumberField.reset();
					suNumberField.setDisabled(true);
					
					if(!isNullOrEmpty(studentField.getValue()) && studentField.getValue().length){
						var suNumbers = [];
						Ext.each(studentField.getValue(), function(currentStudentId){
							var idx = studentFieldStore.findExact('studentId', currentStudentId);
							if(idx != -1){
								var rec = studentFieldStore.getAt(idx);
								var currentSuNumber = rec.get('suNumber');
								if(!isNullOrEmpty(currentSuNumber)){
									suNumbers.push({
										'suNumber':currentSuNumber
									});
								}
							}
						});
						suNumberField.setDisabled(false);
						suNumberFieldStore.removeAll();
						suNumberFieldStore.loadData(suNumbers);
					}
				}
			},
			'notmetmodulegridwin grid':{
				afterrender: function(grid){
					var me = this;
					var win = grid.up('window');
					var gridData = win.gridData;
					
					grid.getStore().removeAll();
					grid.getStore().loadData(gridData);
				}
			}
		});
	},
	approveButtonPermission:function(grid,permissionMap){}
});
