Ext.define('Academia.controller.program.ProgramRelatedCoursesController', {
	extend: 'Academia.controller.base.BaseController',
    stores: ['program.programDetails.programBatches.relatedCourses.ProgramRelatedCourses','program.programDetails.programBatches.relatedCourses.ProgramRelatedCoursesCombo','program.programDetails.programBatches.relatedCourses.ProgramRelatedCoursesSecondry','program.programDetails.programBatches.relatedCourses.ProgramRelatedTypeCombo'],
    models: ['program.programDetails.programBatches.relatedCourses.ProgramRelatedCourses','genericmodels.dropdowns.EnumCombo','common.IdValueCodeDataModel'],
    views: ['baselayout.contentarea.ContentPanel',
            'program.programDetails.programBatchDetails.relatedCourses.ProgramRelatedCoursesForm',
            'program.programDetails.programBatchDetails.relatedCourses.ProgramRelatedCoursesGrid',
            'program.programDetails.programBatchDetails.relatedCourses.ProgramRelatedCoursesStructure',
            'program.programDetails.programBatchDetails.relatedCourses.BatchCourseRequisites',
            'program.programDetails.BatchDetailsTabStructure'
        	],
    config:{
    	/*
   	   	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
   	   	 */
       	/**
            * @cfg {Array} RELATEDCOURSE_PERMISSIONS array (required)
            * The array of permissions to use for Access control wise enabling and disabling buttons.
            * @accessor
            */
	      RELATEDCOURSE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('RELATEDCOURSE_PRIVILEGES')
    },
    refs: [{
        ref: 'programrelatedcoursesgrid',
        selector: 'programrelatedcoursesgrid'
    },{
        ref: 'programrelatedcoursesformwindow',
        selector: 'programrelatedcoursesformwindow'
    },{
        ref: 'programrelatedCoursesformwindow',
        selector: 'programrelatedcoursesformwindow form'
    },{
	    ref: 'contentPanel',
	    selector: 'contentPanel'
	},{
	    ref: 'programbatchdetailstabstructure',
	    selector: 'programbatchdetailstabstructure'
	},{
		ref : 'batchcourserequisites',
		selector : 'batchcourserequisites'
	},{
	    ref: 'batchdetailstabstructure',
	    selector: 'batchdetailstabstructure'
	}],


    init: function(application) {
        this.control({
        	'programrelatedcoursesgrid':{
        		render:function(grid){
        			this.doAccessControlValidation(grid, this.getRELATEDCOURSE_PERMISSIONS());
        		}
        	},
        	'programbatchdetailstabstructure combo[itemId=batchId]':{
            	select: function(c,r) {
            		var batchId = "";
            		if(Ext.isObject(r) || Ext.isArray(r)){
            			batchId=r[0].data.id;
            		}else{
            			batchId=r;
            		}
            		var $this=this;
            		var store = $this.getProgramProgramDetailsProgramBatchesRelatedCoursesProgramRelatedCoursesStore();
            		if(batchId!=null){
            			store.getProxy().extraParams = {
            				batchId: batchId
            			};
            			store.load();
            		}	
            	}
            },
        	'batchcourserequisites button[itemId=btnEnableRequisites]':{
            	click: function() {
                	this.updateBatchCourseRequisites();
                }
            },
            'batchcourserequisites':{
            	render: function(){
            		var grid = this.getBatchcourserequisites();
            		grid.config.courseRequisiteController = Academia.app.getController('Academia.controller.course.requisite.CourseRequisiteController');
    				  var programStructure = this.getBatchdetailstabstructure();
      				  var batchId = programStructure.down("#batchId").getValue();
      				  var store = grid.getStore();
      				  store.getProxy().extraParams = {
      					  batchId : batchId
      				  };
      				  store.load();

            	},
            	select: function(rowModel, record, index, eOpts){                	
                	this.setEnableDisableButtonText(rowModel, record, index, eOpts);
                },
            	cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
            		if (e.target.tagName == 'A') {
            			var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            			var $this = this;
            			if(dataIndex == 'courseCodeName'){
            				var grid = this.getBatchcourserequisites();
            				var courseRequisiteController = grid.config.courseRequisiteController;
            				$this.openCourseRequisitesTab(dataIndex, record,courseRequisiteController);
            			}
            		}
            	}
            }
        });
    },
    updateBatchCourseRequisites:function(){
    	var grid=this.getBatchcourserequisites(); 
    	if (grid.getSelectionModel().getCount() > 0){
    		var gridRecord = grid.getSelectionModel().getSelection()[0];
        	var tabStructure=this.getProgrambatchdetailstabstructure();
        	var batchId=tabStructure.getForm().findField('batch').getValue();
        	var courseId = gridRecord.data.courseId;
        	var isEnable = isNullOrEmpty(gridRecord.data.isEnable)?false:!gridRecord.data.isEnable;
        	var requisiteModel= new Academia.model.program.programDetails.programBatches.relatedCourses.ProgramRelatedCourses();
        	requisiteModel.set("course", this.getIdValueJson(courseId));
        	requisiteModel.set('batchId', batchId);
        	requisiteModel.set('isEnable', isEnable);
        	delete requisiteModel.data.courseId;
        	delete requisiteModel.data.courseCodeName;
        	var fData = Ext.encode(requisiteModel.data);
        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	var submitUrl = SERVERURL.PATH_UPDATE_BATCH_COURSE_REQUISITES_STATUS
        	Ext.Ajax.request({
        		method: "POST",
        		type: 'rest',
        		jsonData: fData,
        		url: submitUrl,
        		params:{
        			batchId:batchId,
        			courseId:courseId,
        			isEnable:isEnable
        		},
        		headers: {
        			'Content-Type': 'application/json'
        		},
        		success: function(f, action) {
        			Ext.getBody().unmask();
        			var data = f.responseText;
        			if(data == "SUCCESS" && isEnable) {
        				showSuccessMessage(getMegaMenuTranslation('MANAGE_COURSE_REQUISITES'),getProgramandcourseTranslation('BATCH_COURSE_REQUISITES_ENABLE_SUCCESS'));
        			} else if(data == "SUCCESS" && !isEnable) {
        				showSuccessMessage(getMegaMenuTranslation('MANAGE_COURSE_REQUISITES'),getProgramandcourseTranslation('BATCH_COURSE_REQUISITES_DISABLE_SUCCESS'));
        			}
        			grid.getStore().reload();
        			grid.getSelectionModel().deselectAll();
        		},
        		failure: function(result, request) {
        			showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
        			return false;
        		}
        	});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
	    openCourseRequisitesTab: function(dataIndex, record,courseRequisiteController){
	    	var $this=this; 
	    	var tabStructure=$this.getProgrambatchdetailstabstructure();
    		var batchId=tabStructure.getForm().findField('batch').getValue();
    		
	    	var contentPanel = this.getContentPanel();
	    	var structure = Ext.widget('batchcourserequisitestructure');
	    	var tabName = getProgramandcourseTranslation('MANAGE_BATCH_COURSE_REQUISITES');
	    	var getcontroller= Academia.app.getController('menu.CoreERPNavigationController');
	    	
	    	var getTab=getcontroller.getTab(tabName);
	    	if(getTab!=null){
	    		contentPanel.remove(getTab, true);
	    	}
	    	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);

	    	var courserequisitefilter = courseRequisiteController.getBatchcourserequisitefilter();
	    	var programName = tabStructure.down('#displayfieldprogramCodeAndNameId').getValue().split("/")[1].trim();
	    	var batchName = tabStructure.down('#displayfieldBatchNameId').getValue();
	    	var courseId = courserequisitefilter.down('#courseId');
	    	var courseDepartmentId = courserequisitefilter.down('#courseDepartmentId');
	    	var programBatch = courserequisitefilter.down('#programBatchItemId');
	    	var courseCodeName = courserequisitefilter.down('#courseCodeNameItemId');
	    	programBatch.setVisible(true);
	    	programBatch.setValue(programName+" / "+batchName);
	    	courseCodeName.setVisible(true);
	    	courseCodeName.setValue(record.data.courseCodeName);
	    	courseId.setValue(record.data.courseId);
	    	courseId.setReadOnly(true);
	    	courseId.setVisible(false);
	    	courseDepartmentId.setReadOnly(true);
	    	courseDepartmentId.setVisible(false);
	    	var searchBtn = courserequisitefilter.down('#searchBtn');
	    	var resetBtn = courserequisitefilter.down('#resetBtn');
	    	searchBtn.setVisible(false);
	    	resetBtn.setVisible(false);
	    	
	    	courseRequisiteController.checkRequisiteFormData(record.data.courseId,batchId);
	    },
	    setEnableDisableButtonText: function(rowModel, record, index, eOpts) {
	    	var me=this;
	    	var grid=me.getBatchcourserequisites();   
	    	if(rowModel){
	    		var enableDisableBtn=grid.down('#btnEnableRequisites');
	    		if(!isEmpty(record.data)) {
	                if(isNullOrEmpty(record.get('isEnable')) || record.get('isEnable')){
	                	enableDisableBtn.setText(getMessagingModuleTranslation('DISABLE'));
	                	enableDisableBtn.setTooltip(getMessagingModuleTranslation('DISABLE'));
	                }else{
	                	enableDisableBtn.setText(getMessagingModuleTranslation('ENABLE'));
	                	enableDisableBtn.setTooltip(getMessagingModuleTranslation('ENABLE'));
	                }
	            }
	    	}        
	    },
	    getIdValueJson: function(id, value,code) {
       	 if (id) return {
       		 id: id,
       		 value: value,
       		 code: code
       	 };
        }
});