Ext.define('Academia.controller.program.programDetail.ProgramBatchDetailController',{
	extend : 'Academia.controller.base.BaseController',
	stores : [
	          'program.programDetails.programBatches.ProgramBatchesGridStore',
	          'program.programDetails.programBatches.PrimaryAcademicStore',
	          'program.programDetails.programBatches.ProgramCalenderStore','facilitiesresources.resourcemaster.MappedCalenderStore',
	          'program.programDetails.programBatches.ProgramPeriodTypeStore',
	          'program.programDetails.programBatches.ProgramBatchDocument',
	          'program.programDetails.programBatches.SucceedingBatches','common.IntakeYearStore',
	          'program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
	          'examinationcenters.evaluation.RoundingModeForLevelOne','program.programDetails.programBatches.RetainingBatches',
	          'program.programDetails.programBatches.ProgramPeriodNameStore',
	          'common.SGPACGPACalculationRuleStore',
	          'program.programDetails.programBatches.ProgramBatchCopyGridStore',
	          'program.programDetails.programBatches.CreditFeeMappingPeriodStore','common.ProgramCompletionAwardTypeStore',
	          'common.IntakeYearWithQueryParamStore','common.StudentClassificationStore','common.StudentSpecializationStore'
	          ],
	          
	          views : [
	                   'program.programDetails.programBatches.ProgramBatchesGrid',
	                   'program.programDetails.programBatches.ProgramBatchesForm',
	                   'program.ProgramMasterGrid',
	                   'program.programDetails.programBatches.ProgramBatchDocumentGrid',
	                   'program.programDetails.programBatches.BatchCopyWindow',
	                   'common.IdGeneratorForm',
	                   'program.programDetails.BatchDetailsTabStructure',
	                   'program.programDetails.programBatches.ProgramBatchCopyTabStructure',
	                   'program.programDetails.programBatches.ProgramBatchCopyFilter',
	                   'program.programDetails.programBatches.ProgramBatchCopyGrid'
	                   ],
	                   models : [
	                             'program.programDetails.programBatches.ProgramBatchesGridModel',
	                             'program.programDetails.programBatches.ProgramBatchDocument',
	                             'program.programDetails.programBatches.ProgramBatchModel',
	                             'program.programDetails.programBatches.ProgramBatchCopyGridModel'
	                             ],
	                             config : {
	                            	 /*
	                            	  * CODE FOR setting up the featurePrivileges from
	                            	  * FeaturePrivilegeManager which sets the privileges for
	                            	  * the passed parameter screen.
	                            	  */
	                            	 /**
	                            	  * @cfg {Array} BATCH_PERMISSIONS array (required) The
	                            	  *      array of permissions to use for Access control
	                            	  *      wise enabling and disabling buttons.
	                            	  * @accessor
	                            	  */
	                            	 whetherSingleCourseProg:false,
	                            	 BATCH_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('BATCH_PRIVILEGES')
	                             },
	                             refs : [ {
	                            	 ref : 'programbatchesform',
	                            	 selector : 'programbatchesform'
	                             }, {
	                            	 ref : 'programbatchesgrid',
	                            	 selector : 'programbatchesgrid'
	                             }, {
	                            	 ref : 'programmastergrid',
	                            	 selector : 'programmastergrid'
	                             }, {
	                            	 ref : 'contentPanel',
	                            	 selector : 'contentPanel'
	                             }, {
	                            	 ref : 'batchdetailstabstructure',
	                            	 selector : 'batchdetailstabstructure'
	                             }, {
	                            	 ref : 'programbatchdocumentform',
	                            	 selector : 'simpledocumentform'
	                             }, {
	                            	 ref : 'programbatchdocumentgrid',
	                            	 selector : 'programbatchdocumentgrid'
	                             },{
	                            	 ref : 'batchcopywindow',
	                            	 selector : 'batchcopywindow'
	                             },{
	                            	 ref : 'batchCopywindow',
	                            	 selector : 'batchcopywindow form'
	                             },{
	                            	 ref:'programbatchcopytabstructure',
	                            	 selector:'programbatchcopytabstructure'
	                             },{
	                            	 ref:'programbatchcopyfilter',
	                            	 selector:'programbatchcopyfilter'
	                             },{
	                            	 ref:'programbatchcopygrid',
	                            	 selector:'programbatchcopygrid'
	                             }],
                 init : function() {
                	 this.control({
                		 'programbatchesgrid' : {
                			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                				var grid =  this.getProgrambatchesgrid();
                				 var copyBtn =grid.down('#btnCopyBatch');
                				 copyBtn.enable(true);
                			 }
                		 },
                		 'programbatchesgrid button[itemId=btnAdd]' : {
                			 click : function() {
                				this.showProgramBatchFormWindow();
                				this.removeDocStore();
                				 //this.showBatchCopyWindow();
                			 }
                		 },
                		 'programbatchesform button[itemId=programBatchesFormCancel]' : {
                			 click : function() {
                				 this.cancelBatchFormWindow();
                			 }
                		 },
                        'programbatchesform combo#awardType': {
	                				 click: function(obj, record) {
	                					 var awardType = record;
	                					  var form=this.getProgrambatchesform();
	                					 var awardTypeField = form.findField("awardType");
	                					 awardTypeField.clearValue();
	                					 var store = awardTypeField.getStore();
	                					 store.getProxy().extraParams = { };
	                					 store.load({
                        					 /*callback:function(record){
                        						 cesmCode.setDisabled(false);
                        					 }*/
                        				 });
	                					 
	                				 }
	                			 },
                		 
                		 'programbatchesform customcombobox[itemId=sgpaCgpaCalculationRuleItemId]' : {
                			 select : function(field, val) {
                        		 var form =field.up('form');
                        		 var minimumCPAField = form.down('#minimumCPA');
                        		 if(!isNullOrEmpty(field.getValue()))
                        		 {
                        			 if(field.getValue() =='SPA_CPA_AND_GPA_CALCULATION'){
                        				 this.setAllowBlank(minimumCPAField,false);
                        				 minimumCPAField.setVisible(true);
                        			 }
                        			 else {
                        				 this.setAllowBlank(minimumCPAField,true);
                        				 minimumCPAField.setVisible(false);
                        			 }

                        		 }
                        	 }
                		 },
                		 
                		 'programbatchesgrid button[itemId=btnView]' : {
                			 click : function() {
                				 this.viewProgramBatchFormWindow();
                				 this.getProgrambatchesform().getForm().findField('name').setDisabled(true);
                			 }
                		 },
                		 'programbatchesgrid button[itemId=btnDelete]' : {
                			 click : function(o, r) {
                				 this.deleteRecord(o, r);
                			 }
                		 },
                		 'programbatchesgrid button[itemId=btnEdit]' : {
                			 click : function() {
                				 this.editProgramBatchFormWindow();
                				 // this.getProgrambatchesgrid().getSelectionModel().deselectAll(true);
                			 }
                		 },
                		  'programbatchesgrid button[itemId=btnCopyBatch]' : {
                			 click : function() {
                				 this.addProgramBatchCopyTab();
                				 // this.getProgrambatchesgrid().getSelectionModel().deselectAll(true);
                			 }
                		 },
                		 'programbatchesform button[itemId=programBatches_Add]' : {
                			 click : function() {
                				 this.checkIfSepcializationsMapped();
                			 }
                		 },
                		 'programbatchesform radiogroup[itemId=additionlReq_Id]' : {
                			 change : function(o, r) {
                				 this.additionalReq(o, r);
                			 }
                		 },
                		 'programbatchesform radiogroup[itemId=isRetentionApplicable_Id]' : {
                			 change : function(o, r) {
                				 var form=this.getProgrambatchesform();
                				 this.isRetentionApplicable(o, r,form);
                			 }
                		 },
                		 'programbatchesform radiogroup[itemId=isTransferCreditFromStudentPortalId]' : {
                			 change : function(o, r) {
                				 var form=this.getProgrambatchesform();
                				 this.isTransferCreditFromStudentPortal(o, r,form);
                			 }
                		 },
                		 'programbatchesform textfield[itemId=batch_Id]' : {
                			 blur : function(selectText, delay,callback, scope) {
                				// this.batchOnChange(selectText,delay, callback, scope);
                			 },
                			 change: function(obj, record) {
                				 this.changeStatement(true, null);
                			 }
                		 },
                		 'programbatchesform button#programBatchDocument' : {
                			 click : function() {
                				 this.getDocumentController().showDocumentFormWindow('programbatchformid','DOCUMENT');
                			 }
                		 },
                		 'documentformwindow[itemId=programbatchformid] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]' : {
                			 click : function() {
                				 var $this = this;
                				 var isTransient = true;
                				 var module = 'programBatch';
                				 var entityId;
                				 var entityType = 'programBatch';

                				 $this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
                						 function(success,response,isCallBackTransient) {
                					 var documentModel = new Academia.model.program.programDetails.programBatches.ProgramBatchDocument();
                					 documentModel.set("documentName",response.name);
                					 documentModel.set("path",response.path);
                					 documentModel.set("type",response.type);
//                					 documentModel.set("documentName",response.name);
                					 documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
//                					 var store = $this.getStore('feeandpayment.FeeAndPaymentDocument');
                					 var store = $this.getStore('program.programDetails.programBatches.ProgramBatchDocument');
                					 store.add(documentModel);
                					 $this.getDocumentController().closeDocumentFormWindow();
                				 }, isTransient);
                			 }
                		 },
                		 'simpledocumentform button#documentCancelButtonId' : {
                			 click : function() {
                				 this.getDocumentController()
                				 .closeDocumentFormWindow();
                			 }
                		 },
                		 'programbatchdocumentgrid button#btnDelete' : {
                			 click : this.deleteProgramBatchDocumentFile
                		 },
                		 'programbatchdocumentgrid' : {
                			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
      	        				  var $this = this;
      	        				  var documentGrid = $this.getProgrambatchdocumentgrid();
      	        				  var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

      	        				  if (columnName == "documentName") {
      	        					  if (e.target.tagName == 'A') {
      	        						  var documentId = record.get("documentId");
      	        						  if (!isNullOrEmpty(documentId)) {
      	        							  $this.getDocumentController().downloadDocumentFile(documentId);
      	        						  }
      	        					  }
      	        				  }
                			 }
                		 },
                		 'programbatchesform datefield[itemId=startDate]' : {
                			 change : function(field, value) {
                				 if(!isNullOrEmpty(value)){
                					 var form = this.getProgrambatchesform().getForm();
                    				 var date = Ext.Date.add(value,Ext.Date.DAY, +1);
                    				 form.findField('tillDate').setMinValue(date);
                				 }
                			 }
                		 },
                		 'programbatchesform datefield[itemId=tillDate]' : {
                			 change : function(field, value) {
                				 if(!isNullOrEmpty(value)){
                					 var form = this.getProgrambatchesform().getForm();
                    				 var $this = this;
                    				 var programStructure = $this.getBatchdetailstabstructure();
                    				 var programId = programStructure.getForm().findField('ids').getValue();
                    				 var date = Ext.Date.add(value,Ext.Date.DAY, -1);
                    				 var tillDate = Ext.Date.format(new Date(value), 'Y-m-d'); 
                    				 form.findField('startDate').setMaxValue(date);
                    				 form.findField('retainBatch').reset();
                    				 var store = this.getStore('program.programDetails.programBatches.RetainingBatches');
                    				 store.getProxy().extraParams = {
                    					 programId : programId,
                    					 tillDate:tillDate
                    				 };
                    				 store.load();
                				 }
                			 }
                		 },	
                		 'batchcopywindow' : {
                			 render : function() {
                				 var $this = this;
                				 var form = $this.getBatchCopywindow().getForm();
                				 form.reset();
                				 var programDetailform = $this.getBatchdetailstabstructure();
                				 var programId = programDetailform.getForm().findField('ids').getValue();
                				 var store = $this.getStore('program.programbatchdetail.BatchStore');
                				 if (programId != null) {
                					 store.getProxy().extraParams = {
                						 id : programId
                					 };
                					 store.load();
                				 }
                			 }
                		 },
                		 'batchcopywindow button[itemId=btnCancel]' : {
                			 click:function(){
                				 this.getBatchcopywindow().close();
                			 }
                		 },
                		 'batchcopywindow button[itemId=btnContinue]' : {
                			 click:function(){
                				 this.showProgramBatchFormWindow();
                				 this.getBatchcopywindow().close();
                				 this.removeDocStore();
                			 }
                		 },
                		 'batchcopywindow button[itemId=btnSubmit]' : {
                			 click : function() {
                				 this.batchCopySave();
                			 }
                		 },
                		 'batchcopywindow customcombobox[itemId=batchId]' : {
                			 select:function(field, value) {
                				 this.getSucceedingBatch();
                			 }
                		 },
                		 'batchcopywindow datefield[itemId=batchStartDate]' : {
                			 change:function(field, value) {
                				 var batchStartDateField = field.up('form').down('#batchStartDate');
                				 var batchTillDateField = field.up('form').down('#batchTillDate');
                				 var periodStartDateField = field.up('form').down('#periodStartDate');
                				 var periodTillDateField = field.up('form').down('#periodTillDate');
                				 
                				 batchTillDateField.reset();
                				 periodStartDateField.reset();
                				 periodTillDateField.reset();
                				 
                				 batchTillDateField.setMinValue(false);
                				 batchTillDateField.setMaxValue(false);
                				 periodStartDateField.setMinValue(false);
                				 periodStartDateField.setMaxValue(false);
                				 periodTillDateField.setMinValue(false);
                				 periodTillDateField.setMaxValue(false);
                				 
                				 batchTillDateField.setMinValue(batchStartDateField.getValue());
                				 periodStartDateField.setMinValue(batchStartDateField.getValue());
                				 periodTillDateField.setMinValue(batchStartDateField.getValue());
                			 }
                		 },
                		 'batchcopywindow datefield[itemId=batchTillDate]' : {
                			 change:function(field, value) {
                				 var batchStartDateField = field.up('form').down('#batchStartDate');
                				 var batchTillDateField = field.up('form').down('#batchTillDate');
                				 var periodStartDateField = field.up('form').down('#periodStartDate');
                				 var periodTillDateField = field.up('form').down('#periodTillDate');
                				 
                				 periodStartDateField.reset();
                				 periodTillDateField.reset();
                				 
                				 periodStartDateField.setMinValue(false);
                				 periodStartDateField.setMaxValue(false);
                				 periodTillDateField.setMinValue(false);
                				 periodTillDateField.setMaxValue(false);
                				 
                				 periodStartDateField.setMinValue(batchStartDateField.getValue());
                				 periodTillDateField.setMinValue(batchStartDateField.getValue());
                				 
                				 periodStartDateField.setMaxValue(batchTillDateField.getValue());
                				 periodTillDateField.setMaxValue(batchTillDateField.getValue());
                			 }
                		 },
                		 'batchcopywindow datefield[itemId=periodStartDate]' : {
                			 change:function(field, value) {
                				 var batchStartDateField = field.up('form').down('#batchStartDate');
                				 var batchTillDateField = field.up('form').down('#batchTillDate');
                				 var periodStartDateField = field.up('form').down('#periodStartDate');
                				 var periodTillDateField = field.up('form').down('#periodTillDate');
                				 
                				 periodTillDateField.reset();
                				 
                				 periodTillDateField.setMinValue(false);
                				 periodTillDateField.setMaxValue(false);
                				 
                				 periodTillDateField.setMinValue(periodStartDateField.getValue());
                				 
                				 periodTillDateField.setMaxValue(batchTillDateField.getValue());
                			 }
                		 },
                		 'programbatchesform':{
                			 render:function(){
                				 var form=this.getProgrambatchesform();
//                				 this.showHideMinMaxAdvanceConfig(value,newValue,oldValue);
                				 this.batchOfSucceedingProgram();
                				 this.getCalendarsOfAL();
                				 this.getBatchExitDrool();
                				 var intakeYear = form.down('#intakeYear');
                				 intakeYearStore = intakeYear.getStore();
                				 intakeYearStore.load();
                				 form.down('customcombobox#retainingBatch_Id').setVisible(false);
                				  form.down('customcombobox#retainingBatch_Id').setVisible(false);
                				  var holdSubCategory = form.down('#holdSubCategory')
                				  var holdSubCategoryStore= holdSubCategory.getStore();
                				  holdSubCategoryStore.load();
                				  },
                				  afterrender:function(){
                					  var form=this.getProgrambatchesform();
                					  var additionalRequirmentRadio = form.down('#additionlReq_Id');
                					  var additionalRequirmentRadioValue = additionalRequirmentRadio.getValue();
                					  var isVisible =  additionalRequirmentRadio.isVisible();
                					  if(additionalRequirmentRadioValue.hasAdditionalRequirement && isVisible){
                						  form.down('#additionalRequirement_Id').allowBlank=false;  
                					  }else{
                						  form.down('#additionalRequirement_Id').allowBlank=true;
                					  }
                					  
                					  var isTransferCreditFromStudentPortalIdRadio = form.down('#isTransferCreditFromStudentPortalId');
                					  var isTransferCreditFromStudentPortalIdRadioValue = isTransferCreditFromStudentPortalIdRadio.getValue();
                					  var isTCSPVisible =  isTransferCreditFromStudentPortalIdRadio.isVisible();
                					  if(isTransferCreditFromStudentPortalIdRadioValue.isTransferCreditFromStudentPortal && isVisible){
                						  form.down('#resultStatusRequiredId').allowBlank=false;  
                					  }else{
                						  form.down('#resultStatusRequiredId').allowBlank=true;
                					  }

                				  }
                		 },
                		 
                		 'programbatchesform radiogroup[itemId=isAdvanceConfigId]':{
              			   change : function(value,newValue,oldValue){
              				   this.showHideMinMaxAdvanceConfig(value,newValue,oldValue);
              			   }
              		   },
              		 
              		   'programbatchcopygrid': {
              			   afterrender:function(){
              				 var $this = this;
              				var  grid = this.getProgrambatchesgrid();
              				var filter = this.getProgrambatchcopyfilter();
              				var hiddenProgramId = filter.down('#programId');
              				var hiddenBatchId  =    filter.down('#batchId');
              				var copyBatchFrom = filter.down('#copyBatchFrom');
              				
              				 var intakeYearId = filter.down('#intakeYearItemId');
                				 if(!isNullOrEmpty(intakeYearId)){
									 var intakeFieldStore = intakeYearId.getStore();
									 intakeFieldStore.load();
							}
              				
              				 if(grid.getSelectionModel().getCount() > 0){
              					selectedRecord =grid.getSelectionModel().getSelection()[0]
              					var batchId = selectedRecord.get('id');
              					var copyBatch = selectedRecord.get('name');
              					var batchCopyGrid = this.getProgrambatchcopygrid();
              					batchCopyGrid.getStore().getProxy().extraParams = {
      							  id : batchId
      						   };
              					hiddenProgramId.setValue(selectedRecord.get('programId'));
              					hiddenBatchId.setValue(batchId);
              					copyBatchFrom.setValue(copyBatch);
              					batchCopyGrid.getStore().load();
              					batchCopyGrid.getStore().sort({
                     		        property : 'sequence',
                     		        direction: 'ASC'
                     		    });
              					
              					Ext.Ajax.request({
                           		 type: 'rest',
                           		 url: SERVERURL.FIND_BY_ENTITY_ID,                             
                           		 method: 'GET',
                           		 params: {
                           			 entityId: 20
                           		 },
                           		 success: function(response,form, action) {
                           			 if(!isNullOrEmpty(response.responseText)){
                           				 var responseObject =  Ext.JSON.decode(response.responseText);
                           				 $this.formData=responseObject;  
                           				 if(!isEmpty(responseObject)){
                           					 var BatchId = filter.down('#batchNameItemId');
                           					 if(responseObject.whetherManualId){
                           						    BatchId.setReadOnly(false);
                           						    BatchId.emptyText = ' ';
                           						    BatchId.allowBlank = false;
                           						    BatchId.labelSeparator += '<span class="required" style="color:red"> *</span>';
                           						    BatchId.setFieldLabel(BatchId.fieldLabel);
                           						    BatchId.applyEmptyText();
                           					 }else{
                           						    BatchId.setReadOnly(true);
                           						    BatchId.allowBlank = true;
                           						    BatchId.emptyText = getCommonTranslation('ID_AUTOGENERATE');
                           						    BatchId.applyEmptyText();
                           						
                           					 }
                           				 }
                           			 }                 	                            	
                           		 }	            
                           	 });
              				 }
              				else {
                       		     showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                       	      }
              			   },
              			  cellclick:function(grid1, td, cellIndex, record, tr, rowIndex, e, eOpts){
              				 var grid = this.getProgrambatchcopygrid();
              				  var columnName = grid.columnManager.columns[cellIndex].dataIndex;
              				 if (columnName == "deleteButton") {
	 							 if (e.target.className == "deleteButtonClsForGridActionCls") {
	 								
	 						showConfirmMessage(getCommonTranslation('PERIOD'), (getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_DELETE')+' '+record.data.value+'?'),
	 							 function(btn,text) {
     								if (btn == 'yes') {
	 									 grid.getStore().removeAt(rowIndex);
	 									 var models = grid.getStore().getRange();
	 									 for (var i = 0; i < models.length; i++) {
	 										 models[i].data.serialNo = i + 1;
	 									 }
	 									 grid.getStore().loadRawData(models, true);
	 								}
	 					            
	 					       });
	 						 }
              			   }
              			 }
              		 },
              		 
              		'programbatchcopyfilter datefield[itemId=startDate]' : {
           			 change:function(field, value) {
           				 var periodGrid = this.getProgrambatchcopygrid();
           				 var batchStartDateField = field.up('form').down('#startDate');
           				 var batchTillDateField = field.up('form').down('#tillDate');
           				 var periodStartDateField = periodGrid.columns[2].getEditor();
           				 var periodTillDateField = periodGrid.columns[3].getEditor();
           				
           				var record = periodGrid.getStore().getRange();
	           				record.forEach(function(obj){
	           					obj.set('batchStartDate','');
	           					obj.set('batchEndDate','');
	           					obj.set('enrollmentLastDate','');
	           				});
           				 
           				 batchTillDateField.setMinValue(false);
           				 batchTillDateField.setMaxValue(false);
           				 periodStartDateField.setMinValue(false);
           				 periodStartDateField.setMaxValue(false);
           				 periodTillDateField.setMinValue(false);
           				 periodTillDateField.setMaxValue(false);
           				 
           				 batchTillDateField.setMinValue(batchStartDateField.getValue());
           				 periodStartDateField.setMinValue(batchStartDateField.getValue());
           				 periodTillDateField.setMinValue(batchStartDateField.getValue());
           			 }
           		 },
           		 
           		'programbatchcopyfilter datefield[itemId=tillDate]' : {
          			 change:function(field, value) {
          				 var periodGrid = this.getProgrambatchcopygrid();
          				 var batchStartDateField = field.up('form').down('#startDate');
          				 var batchTillDateField = field.up('form').down('#tillDate');
          				 var periodStartDateField = periodGrid.columns[2].getEditor()
          				 var periodTillDateField = periodGrid.columns[3].getEditor()
          				 var record  = periodGrid.getStore().data.items;
	           				record.forEach(function(obj){
	           					obj.set('batchStartDate','');
	           					obj.set('batchEndDate','');
	           					obj.set('enrollmentLastDate','');
	           				});
	           				
        				 periodStartDateField.setMinValue(false);
        				 periodStartDateField.setMaxValue(false);
        				 periodTillDateField.setMinValue(false);
        				 periodTillDateField.setMaxValue(false);
        				 
        				 periodStartDateField.setMinValue(batchStartDateField.getValue());
        				 periodTillDateField.setMinValue(batchStartDateField.getValue());
        				 
        				 periodStartDateField.setMaxValue(batchTillDateField.getValue());
        				 periodTillDateField.setMaxValue(batchTillDateField.getValue());
          			 }
          		 },
              		 
          		 'programbatchcopygrid button[itemId=btnreset]':{
          			 click:function(btn){
          				 var copyForm = this.getProgrambatchcopyfilter();
          				 copyForm.down('#batchNameItemId').reset();
          				 copyForm.down('#intakeYearItemId').reset();
          				 copyForm.down('#startDate').reset();
          				 copyForm.down('#tillDate').reset();
          				 var grid = this.getProgrambatchcopygrid();
          				 grid.getStore().rejectChanges();
          				 var record  = grid.getStore().data.items;
          				 record.forEach(function(obj){
          					 obj.set('enrollmentLastDate','');
          				 });

          			 }
          		 },
              		 'programbatchcopygrid button[itemId=SaveBtn]':{
            			   click:function(btn){
            				 var $this = this;
            				 var copyForm = $this.getProgrambatchcopyfilter();
            				 
            				 var batchId  =    copyForm.down('#batchId').getValue();
            				 var batchName = copyForm.down('#batchNameItemId').getValue();

            				 var formIsValid = copyForm.getForm().isValid();
            				 var grid = this.getProgrambatchcopygrid();
            				 grid.getStore().sort({
                  		        property : 'sequence',
                 		        direction: 'ASC'
                 		    });
            				 var copyBatchDataArray = [];
            				 var mainJsonObj = new Object();
            			     var formValues = copyForm.getForm().getValues();

            				 var records =  grid.getStore().data.items;
            				
        				      var flag = true;
        				      var flag1 = true;
        				      Ext.Ajax.request({
        	                		 type: 'rest',
        	                		 url: SERVERURL.FIND_BY_ENTITY_ID,                             
        	                		 method: 'GET',
        	                		 async: false,
        	                		 params: {
        	                			 entityId: 20
        	                		 },
        	                		 success: function(response,form, action) {
        	                			 if(!isNullOrEmpty(response.responseText)){
        	                				 var responseObject =  Ext.JSON.decode(response.responseText);
        	                				 $this.formData=responseObject;  
        	                				 if(!isEmpty(responseObject)){
        	                					 var BatchId = copyForm.down("#batchNameItemId");
        	                					 if(responseObject.whetherManualId){
        	                						 if(isNullOrEmpty(formValues.name)){
        	                							 flag = false;
        	                						 }
        	                						
        	                					 }
        	                				 }
        	                			 }                 	                            	
        	                		 }	            
        	                	 });
            				 if(!isNullOrEmpty(formValues.intakeYear)&& !isNullOrEmpty(formValues.startDate)&& !isNullOrEmpty(formValues.tillDate))
            				 {
            					 var intakeId = {
            							 id:formValues.intakeYear
            					 };
            					  mainJsonObj = {
            							 batchId: batchId,
            							 newBatchName:formValues.name,
            							 intakeYear:intakeId, 
            							 batchStartDate: formValues.startDate,
            							 batchTillDate: formValues.tillDate
            					 }
            				 }
            				 else{
            					 flag = false;
            				 }
            				 var alinfomodel = Academia.model.authentication.ALInfoModel;
      						var wheatherSchool = alinfomodel.get('wheatherSchool');
      						if(wheatherSchool){	
         					records.forEach(function(obj){
         						var obj1 = new Object(); 
         						if(!isNullOrEmpty(obj.data.value) && !isNullOrEmpty(obj.data.academicTerm)&& !isNullOrEmpty(obj.data.batchStartDate)
         								&& !isNullOrEmpty(obj.data.batchEndDate) && !isNullOrEmpty(obj.data.enrollmentLastDate)) {
         							obj1.printName=obj.data.value;
             						obj1.academicTerm = {
             								id:obj.data.academicTerm
             						};
             						obj1.id = obj.data.id;
                     				obj1.programPeriodStart=obj.data.batchStartDate;
                     				obj1.programPeriodEnd =obj.data.batchEndDate;
                     				obj1.enrollmentLastDate =obj.data.enrollmentLastDate;
                     				obj1.registrationTermSetupDetailId =obj.data.registrationSetup;
                     				copyBatchDataArray.push(obj1);
         						}
         						else{
         							flag = false;
         						   }
         						
                 			   });
      						}else{
      							records.forEach(function(obj){
             						var obj1 = new Object(); 
             						if(!isNullOrEmpty(obj.data.value) && !isNullOrEmpty(obj.data.academicTerm)&& !isNullOrEmpty(obj.data.batchStartDate)
             								&& !isNullOrEmpty(obj.data.batchEndDate)) {
             							obj1.printName=obj.data.value;
                 						obj1.academicTerm = {
                 								id:obj.data.academicTerm
                 						};
                 						obj1.id = obj.data.id;
                         				obj1.programPeriodStart=obj.data.batchStartDate;
                         				obj1.programPeriodEnd =obj.data.batchEndDate;
                         				obj1.registrationTermSetupDetailId =obj.data.registrationSetup;
                         				copyBatchDataArray.push(obj1);
             						}
             						else{
             							flag = false;
             						   }
             						
                     			   });
      							}
         					     if(flag){
         					    	 if(flag1){
         					    		 mainJsonObj.periodCopyList = copyBatchDataArray;
         					    		 mainJsonObj = Ext.encode(mainJsonObj);
         					    		 var submitUrl = SERVERURL.CUSTOMIZED_BATCH_COPY;
         					    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         					    		 Ext.Ajax.request({
         					    			 type : 'rest',
         					    			 url : submitUrl,
         					    			 timeout: 900000,// 15 min
         					    			 jsonData : mainJsonObj,
         					    			 method : 'POST',
         					    			 success : function(form, action) {

         					    				 Ext.getBody().unmask();
         					    				 if(form.responseText == ""){
         					    					 showWarningMessage(getCommonTranslation('ALERT'), 
         					    							 getProgramandcourseTranslation('BATCH_NAME_EMPTY'));
         					    				 } else{
         					    					 showSuccessMessage(getCommonTranslation('BATCH'),getCommonTranslation('SUCCESS'));
         					    					 var batchGrid =  $this.getProgrambatchesgrid();
         					    					 var formFilter = $this.getProgrambatchcopyfilter();
         					    					 var programIdValue = copyForm.down('#programId').getValue();
         					    					 batchGrid.getStore().getProxy().extraParams = {
         					    						 programId : programIdValue
         					    					 };
         					    					 $this.resetGridSetting(batchGrid);
         					    					 batchGrid.getStore().load();
         					    					 $this.getContentPanel().getActiveTab().close();
         					    				 }
         					    			 },
         					    			 failure: function(form, action) {
         					    				 Ext.getBody().unmask();
         					    				var data =Ext.decode(form.responseText);
         					    				if(data[0].key!="batch_name_notunique"){
         					    				 showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
         					    				}
         					    			 }
         					    		 });
         					    	 }
         					    	 else{
         					    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_EITHER_REG_LASTDATE_MSG'));
         					    	 }
         					     }
         					     else{
         					    	showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
         					     }
         					     
            				    }
            			   },
            			   'programbatchcopyfilter textfield[itemId=batchNameItemId]':{
            				   
            				   blur : function(selectText, delay,callback, scope) {
//                  				 this.batchCopyOnChange(selectText,delay, callback, scope);
                  			 }
            			   } 
              		    
                	 });
                 },
                 loadBatchGridData:function(){
                	var batchGrid =  this.getProgrambatchesgrid();
                	var formFilter = this.getProgrambatchcopyfilter();
                	var programIdValue = formFilter.down('#programId').getValue();
                	batchGrid.getStore().getProxy().extraParams = {
						  programId : programIdValue
					   };
                	this.resetGridSetting(batchGrid);
                	batchGrid.getStore().load();
                 },
                 /**
				  * @author Ravi Choudhary
				  * show hide advance config functionality i.e. min max Required or not 
				  */
                 showHideMinMaxAdvanceConfig:function(value,newValue,oldValue){	
                	 var form=this.getProgrambatchesform();
                	 var isAdvanceConfig=form.down("#isAdvanceConfigId");
                	 var graduationSettingCont=form.down("#graduationSettingContId");
                	 var minBatchCredits=form.down("#minProgramCreditsBatchForm_ItemId");
                	 var maxBatchCredits=form.down("#maxProgramCreditsBatchForm_ItemId");
                	 var minBatchCourses=form.down("#minProgramCoursesBatchForm_ItemId");
                	 var maxBatchCourses=form.down("#maxProgramCoursesBatchForm_ItemId");
                	 var minBatchCoursesMand=form.down("#minCompulsoryCoursesBatchForm_ItemId");
                	 var maxBatchCoursesMand=form.down("#maxCompulsoryCoursesBatchForm_ItemId");
                	 var minBatchCoursesOptional=form.down("#minOptionalCoursesBatchForm_ItemId");
                	 var maxBatchCoursesOptional=form.down("#maxOptionalCoursesBatchForm_ItemId");
                	 var cgpaRequired=form.down("#cgpaRequired");
                	 var setMin=0;
                	 var setMax=1000;
                	 var setMinCGPA = 0.00;
                	 var roundingMode=form.down('#roundingModeId');
                	 roundingMode.getStore().load({
                		 callback:function(){
                			 roundingMode.setValue("HALF_UP");		
                		 }
                	 });
                	 var roundingCount=form.down('#roundingCountId');
                	 setTimeout(function(){
                		 roundingCount.setValue(2);
                	 },300);
                	 if(whetherSingleCourseProg && newValue.isAdvanceConfig==true){
                		 graduationSettingCont.setVisible(true);
                		 cgpaRequired.setVisible(true);
                		 minBatchCredits.reset();
                		 maxBatchCredits.reset();
                		 cgpaRequired.reset();
                		 cgpaRequired.setValue(setMinCGPA);
                	 }else if(!whetherSingleCourseProg && newValue.isAdvanceConfig==true){
                		 graduationSettingCont.setVisible(true);
                		 cgpaRequired.setVisible(true);
                		 minBatchCredits.reset();
                		 maxBatchCredits.reset();
                		 minBatchCourses.reset();
                		 maxBatchCourses.reset();
                		 minBatchCoursesMand.reset();
                		 maxBatchCoursesMand.reset();
                		 minBatchCoursesOptional.reset();
                		 maxBatchCoursesOptional.reset();
                		 cgpaRequired.reset();
                		 cgpaRequired.setValue(setMinCGPA);
                	 }else if(!whetherSingleCourseProg && newValue.isAdvanceConfig==false){
                		 graduationSettingCont.setVisible(false);
                		 cgpaRequired.setVisible(false);
                		 minBatchCredits.setValue(setMin);
                		 maxBatchCredits.setValue(setMax);
                		 minBatchCourses.setValue(setMin);
                		 maxBatchCourses.setValue(setMax);
                		 minBatchCoursesMand.setValue(setMin);
                		 maxBatchCoursesMand.setValue(setMax);
                		 minBatchCoursesOptional.setValue(setMin);
                		 maxBatchCoursesOptional.setValue(setMax);
                		 cgpaRequired.setValue(setMinCGPA);
                	 }else{
                		 cgpaRequired.setVisible(false);
                		 graduationSettingCont.setVisible(false);
                		 minBatchCredits.setValue(setMin);
                		 maxBatchCredits.setValue(setMax);
                		 cgpaRequired.setValue(setMinCGPA);
                	 }
//              	 form.getForm().isValid();
                 },
                 
                 changeStatement: function(wether, data) {
     	        	var $this = this;
     	        	 var getForm = $this.getProgrambatchesform();
     		    	 var programBatchName= getForm.down('#batch_Id').getValue();
     		    	 if(!isNullOrEmpty(programBatchName)){
     		    		 var task = new Ext.util.DelayedTask(function(){
     		    			 if(wether){
     		    				 getForm.down('#printNameItemId').setValue(programBatchName.replace(/ +/g, " "));
     		    			 } else {
     		    				 getForm.down('#printNameItemId').setValue(data);
     		    			 }
     		    			
     		     		});
     		    	 } else {
     		    		 getForm.down('#printNameItemId').setValue('');
     		    	 }
     		    	  task.delay(50);
     		     	      Ext.resumeLayouts();
     	        },
                 
                 showBatchCopyWindow: function() {
                	 var formWindow = this.getBatchcopywindow();
                	 if (!formWindow) {
                		 Ext.widget('batchcopywindow');
                		 formWindow = this.getBatchcopywindow();
                	 }
                	 formWindow.show();
                 },
                 showProgramBatchFormWindow : function(record) {
                	 var $this = this;
                	 var tillDate=record;
                	 var contentpanel = $this.getContentPanel();
                	 var programgrid = Ext.widget('programbatchesform');
                	 var form= programgrid.getForm();
                	 var programId = contentpanel.getActiveTab().programId;
                	 var tabName = getCommonTranslation('PROGRAM_BATCH');
                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
                	 var programPeriodSequence;
                	 var holdSubCategory = form.findField('holdSubCategory')
                	 holdSubCategory.setReadOnly(true);
					 holdSubCategory.setDisabled(true);
				     Ext.Ajax.request({
					 type : 'rest',
					 url : SERVERURL.PROGRAM_BATCH_SEQUENCE,// URL-rest/findById of batch/findByLocationId
					 method : 'GET',
					 params : {
						programId : programId
					 },
					 //method : 'GET',
					 success : function(response) {
						 programPeriodSequence = Ext.decode(response.responseText);
						 if(programPeriodSequence!=undefined){
						 var programBatchSequence = form.findField('programBatchSeq');
                	     programBatchSequence.setValue(programPeriodSequence);
                	     }
					 }
				    });
                	 Ext.Ajax.request({
                		 type: 'rest',
                		 url: SERVERURL.FIND_BY_ENTITY_ID,                             
                		 method: 'GET',
                		 params: {
                			 entityId: 20
                		 },
                		 success: function(response,form, action) {
                			 if(!isNullOrEmpty(response.responseText)){
                				 var responseObject =  Ext.JSON.decode(response.responseText);
                				 $this.formData=responseObject;  
                				 if(!isEmpty(responseObject)){
                					 var BatchId = programgrid.down("#batch_Id");
                					 if(responseObject.whetherManualId){
                						    BatchId.setReadOnly(false);
                						    BatchId.emptyText = ' ';
                						    BatchId.allowBlank = false;
                						    BatchId.labelSeparator += '<span class="required" style="color:red"> *</span>';
                						    BatchId.setFieldLabel(BatchId.fieldLabel);
                						    BatchId.applyEmptyText();
                					 }else{
                						    BatchId.setReadOnly(true);
                						    BatchId.allowBlank = true;
                						    BatchId.emptyText = getCommonTranslation('ID_AUTOGENERATE');
                						    BatchId.applyEmptyText();
                						
                					 }
                				 }
                			 }                 	                            	
                		 }	            
                	 });	
                	 if(wheatherSchool){
                		var form= programgrid.getForm();
                		var minperiod=form.findField('minPeriod');
                		var maxPeriod=form.findField('maxPeriod');
                		var programPeriodType=form.findField('programPeriodType');
                		var programBatchSequence = form.findField('programBatchSeq');
                		programPeriodType.getStore().load({
                						 callback : function(records, operation, success) {
                							 if (success) {
                								 for(i in records){
                									if(!isNullOrEmpty(records[i].data.value)){
                									 if(records[i].data.value==="Yearly" || records[i].data.value==="yearly"){
                										 programPeriodType.setValue(records[i].data.id);
                									 }
                									}
                								 }
                							 }
                						 }
                					 });
                		minperiod.setValue(1);
                		maxPeriod.setValue(1);
                		programBatchSequence.setValue(programPeriodSequence);
                		minperiod.validate();
                		maxPeriod.validate()
                		minperiod.hide();
                		maxPeriod.hide();
                		programgrid.down('#specializationPossible_itemId').hide();
                		programgrid.down('#placementProcessRequired').hide();
                	 }
                	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
                	 var getTab=getcontroller.getTab(tabName);
                	 if(getTab!=null){
                		 contentpanel.remove(getTab, true);
                	 }
                	 openTab(contentpanel, tabName, programgrid,CONSTANTS.MENU_COLOR_THREE);
                 },
                 
                 showEditProgramBatchFormWindow : function(record) {
                	 var $this = this;
                	 var tillDate=record;
                	 var contentpanel = $this.getContentPanel();
                	 var programgrid = Ext.widget('programbatchesform');
                	 var tabName = getCommonTranslation('PROGRAM_BATCH');
                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
                	 var BatchId = programgrid.down("#batch_Id");
                	 BatchId.setReadOnly(false);
					 BatchId.emptyText = ' ';
					 BatchId.allowBlank = false;
					 /*BatchId.labelSeparator += '<span class="required" style="color:red"> *</span>';
					 BatchId.setFieldLabel(BatchId.fieldLabel);*/
					 BatchId.applyEmptyText();
                	 if(wheatherSchool){
                		var form= programgrid.getForm();
                		var minperiod=form.findField('minPeriod');
                		var maxPeriod=form.findField('maxPeriod');
                		var programPeriodType=form.findField('programPeriodType');
                		programPeriodType.getStore().load({
                						 callback : function(records, operation, success) {
                							 if (success) {
                								 for(i in records){
                									if(!isNullOrEmpty(records[i].data.value)){
                									 if(records[i].data.value==="Yearly" || records[i].data.value==="yearly"){
                										 programPeriodType.setValue(records[i].data.id);
                									 }
                									}
                								 }
                							 }
                						 }
                					 });
                		minperiod.setValue(1);
                		maxPeriod.setValue(1);
                		minperiod.validate();
                		maxPeriod.validate()
                		minperiod.hide();
                		maxPeriod.hide();
                		programgrid.down('#specializationPossible_itemId').hide();
                		programgrid.down('#placementProcessRequired').hide();
                	 }
                	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
                	 var getTab=getcontroller.getTab(tabName);
                	 if(getTab!=null){
                		 contentpanel.remove(getTab, true);
                	 }
                	 openTab(contentpanel, tabName, programgrid,CONSTANTS.MENU_COLOR_THREE);
                 },
                 
                 
                 viewProgramBatchFormWindow : function() {
                	 this.editProgramBatchFormWindow(true);
                	 var form = this.getProgrambatchesform();
                	 if (form) {
                		 form.down('#programBatches_Add').hide();
                		 form.down('#programBatchDocument').hide();
                		 var nform = form.getForm();
                		 toggleReadOnlyFormItems(nform, true);
                		 //form.down('#programBatchSequenceItemId').setReadOnly(true);
                		 var grid = this.getProgrambatchdocumentgrid();
                		 buttonsToolBar = grid.query('toolbar')[0];
                		 var gridDeleteBtn= buttonsToolBar.query('#btnDelete')[0];
                		 gridDeleteBtn.setVisible(false);
                	 }
                	 
                 },

                 closeTab : function(tabReference) {
                	 tabReference.close();
                 },
                 cancelBatchFormWindow : function() {
                	 this.getProgrambatchesform().getForm().reset();
                 },
                 checkIfSepcializationsMapped : function(){
                	 var $this = this;
                	 var form = this.getProgrambatchesform().getForm();
                	 var dbSpecPossible = form.findField('specPossible').getValue();
                	 var formSpecPossible = form.findField('specializationPossible').getValue();
                	 if(dbSpecPossible == "true" && formSpecPossible != true){
                		  var specializationStore = this.getStore(
						  	'program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid');
						  specializationStore.getProxy().extraParams = {
							  batchId : form.findField('id').getSubmitValue()
						  };
						  specializationStore.load({
							  callback : function(records, success) {
		          			  if (success) {
		          				  if(records.length > 0){
		          					showWarningMessage(getCommonTranslation('ALERT'), 
	                						 getProgramandcourseTranslation('CANT_CHANGE_SPEC_POSS_TO_NO_AS_SOME_SPEC_ALREADY_MAPPED_TO_BATCH'));
		          					return;
		          				  }else{
		                     		 form.findField('specPossible').setValue("formSpecPossible");
		                    		 $this.addProgBatches();
		                    	 }
		          				  
		          			  }
		          		  }
						  }); 
                	 }
                	 else{
                		 form.findField('specPossible').setValue("formSpecPossible");
                		 this.addProgBatches();
                	 }
                 },
                 addProgBatches : function() {
                	 var $this = this;
                	 var programStructure = $this.getBatchdetailstabstructure();

                	 var progId = programStructure.getForm().findField('ids').getValue();
                	 var version = programStructure.getForm().findField('version').getValue();
                	 
                	 var form = this.getProgrambatchesform().getForm();
                	 var value = form.getValues();
                	 var programTypeId = form.findField('programPeriodType').getValue();
                	 var programTypeValue = form.findField('programPeriodType').getRawValue();
                	 var applyHoldValue = form.findField('holdSubCategory').getValue();
//                	 var completionTime = form.findField('completionTime').getValue()
                	 var assignCalenderId = form.findField('calendar').getValue();
                	 var minimumCPA = form.findField('minimumCPA').getValue();
                	 var assignCalenderValue = form.findField('calendar').getRawValue();
                	 var programTypeCombo = this.getIdValueJson(programTypeId, programTypeValue);
                	 var assignCalenderCombo = this.getIdValueJson(assignCalenderId, assignCalenderValue);

                	 var programBatches = new Academia.model.program.programDetails.programBatches.ProgramBatchModel();
                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
                	 programBatches.set("name", value.name);
                	 programBatches.set("printName", value.printName);
                	 programBatches.set("seatCapacity", value.seatCapacity);
                	 programBatches.set("startDate", value.startDate);
                	 programBatches.set("tillDate", value.tillDate);
                	 programBatches.set("hasAdditionalRequirement",value.hasAdditionalRequirement);
                	 programBatches.set("additionalRequirementDetails",value.additionalRequirementDetails);
                	 programBatches.set("minProgramCredits",value.minProgramCredits);
                	 programBatches.set("maxProgramCredits",value.maxProgramCredits);
                	 programBatches.set("minProgramCourses",value.minProgramCourses);
                	 programBatches.set("maxProgramCourses",value.maxProgramCourses);
                	 programBatches.set("batchPartTime", value.batchPartTime);
                	 programBatches.set("minCompulsoryCourses",value.minCompulsoryCourses);
                	 programBatches.set("maxCompulsoryCourses",value.maxCompulsoryCourses);
                	 programBatches.set("minOptionalCourses",value.minOptionalCourses);
                	 programBatches.set("maxOptionalCourses",value.maxOptionalCourses);
                	 programBatches.set("programMinAge", 0);
                	 programBatches.set("programMaxAge", 0);
                	 /*programBatches.set("programMinAge", value.programMinAge);
                	 programBatches.set("programMaxAge", value.programMaxAge);*/
                	 programBatches.set("ageVerificationDate",null);//value.ageVerificationDate
                	 programBatches.set("programEntryCriteria",this.getIdValueJson(value.entryDrools));
                	 programBatches.set("programExitCriteria",this.getIdValueJson(value.exitDrools));
                	 programBatches.set("academicYear", value.academicYear);
                	 programBatches.set("programId", progId);
                	 programBatches.set("programPeriodType",programTypeCombo);
                	 programBatches.set("calendar", assignCalenderCombo);
                	 programBatches.set("customData",value.customData);
                	 programBatches.set("version",value.version);
                	 programBatches.set("isAdvanceConfig",value.isAdvanceConfig);
                	 programBatches.set("isFeeApplicable",value.isFeeApplicable);
                	 programBatches.set("intakeYear", this.getIdValueJson(value.intakeYear));
                	 programBatches.set("enquiryEnable", value.enquiryEnable);
                	 programBatches.set("roundingMode", value.roundingMode);
                	 programBatches.set("roundingCount", value.roundingCount);
                	 programBatches.set("batchOfSucceedingProgram", value.batchOfSucceedingProgram);
                	 programBatches.set("retainBatch", value.retainBatch);
                	 programBatches.set("isIncludeRepeatedCoursesInCGPA", value.isIncludeRepeatedCoursesInCGPA);
                	 programBatches.set("otherRuleApplicable",this.getIdValueJson(value.otherRuleApplicable));
                	 programBatches.set("modeOfDelivery",this.getIdValueJson(value.modeOfDelivery));
                	 programBatches.set("eligibilityCriteria",value.eligibilityCriteria);
                	 programBatches.set("isRetentionApplicable",value.isRetentionApplicable);
                	 programBatches.set("cgpaRequired",value.cgpaRequired);
                	 programBatches.set("sgpaCgpaCalculationRule",value.sgpaCgpaCalculationRule);
                	 programBatches.set("estimatedFees",value.estimatedFees);
                	 programBatches.set("publishInCatalogue",value.publishInCatalogue);
                	 programBatches.set("allowMultipleLastPeriods",value.allowMultipleLastPeriods);
                	 programBatches.set("programBatchSeq",value.programBatchSeq);
                	 programBatches.set("programBatchPrefix",value.programBatchPrefix);
                	 programBatches.set("completionTime",value.completionTime);
                	 programBatches.set("isTransferCreditFromStudentPortalId",value.isTransferCreditFromStudentPortal);
                	 programBatches.set("creditType",this.getIdValueJson(value.creditType));
                	 programBatches.set("isEquivalenceCheck",value.isEquivalenceCheck);
                	 programBatches.set("usCredits",value.usCredits);
                	 programBatches.set("ectsCredits",value.ectsCredits);
                	 if(!isNullOrEmpty(value.minimumCPA))
                	 {
                		 programBatches.set("minimumCPA",value.minimumCPA);	 
                	 }
                	 

                	 var holdSubCategoryDisabled = form.findField('holdSubCategory')
                	 var allHoldSubCategoryArray = [];
    	        	 if(!isNullOrEmpty(applyHoldValue)){   	        			 
    	        			if(typeof value.holdSubCategory == "object"){
    	 	            		Ext.each(value.holdSubCategory, function(currentHoldSubCategory){
    	 	                    	var holdSubCategory = '';
//    	 	                    	var programPeriodConfig = '';
    	 	                    	var mainObj = '';
    	 	                        if(!isNullOrEmpty(currentHoldSubCategory)){
    	 	                        	if(typeof currentHoldSubCategory == "object"){
    	 	                        		var manageSubHoldCatId = currentHoldSubCategory.data.id
    	 	                        	}
    	 	                        	else{
    	 	                        		var manageSubHoldCatId = currentHoldSubCategory; 
    	 	                        	}
    	 	                    	mainObj = {
    	 	                    			"manageSubHoldCategory" : {
    	 	                    					"id" : manageSubHoldCatId
    	 	                    			},
    	 	                    			"batch" : {
    	 	                    					"id": form.findField('id').getValue()
    	 	                    			}		
    	 	                    	}
    	 	                    	allHoldSubCategoryArray.push(mainObj);
    	 	                        }
    	 	                    });
    	 	        		}
    	        			else if(holdSubCategoryDisabled.disabled){
    	        				var holdSubCategory = '';
    	        			}
    	        			else{
    	 	        			var holdSubCategory = '';
    	 	                	var mainObj = '';
    	 	                	mainObj = {
    	 	                			"manageSubHoldCategory" : {
    	 	                					"id" : value.currentHoldSubCategory.id
    	 	                			},
    	 	                			"batch" : {
    	 	                					"id": form.findField('id').getValue()
    	 	                			}		
    	 	                	}
    	 	                	allHoldSubCategoryArray.push(mainObj);
    	 	        		}        			
    	        			           			
    	        			
    	        			
    	        		 
    	        	 }   
    	        	 programBatches.set("batchSubHoldCategory",allHoldSubCategoryArray);
    	        	 
    	        	 var resultStatusArray = [];
    		            if(!isNullOrEmpty(value.resultStatus)){
    		        		if(typeof value.resultStatus == "object"){
    		            		Ext.each(value.resultStatus, function(currentResultStatus){
    		                    	var resultStatus = '';
    		                    	var batch = '';
    		                    	var mainObj = '';
    		                        if(!isNullOrEmpty(currentResultStatus)){
    		                        	if(typeof currentResultStatus == "object"){
    	 	                        		var currentResultStatusId = currentResultStatus.data.id
    	 	                        	}
    	 	                        	else{
    	 	                        		var currentResultStatusId = currentResultStatus; 
    	 	                        	}
    		                    	mainObj = {
    		                    			"resultStatus" : {
    		                    					"id" : currentResultStatusId
    		                    			},
    		                    			"batch" : {
    		                    					"id": form.findField('id').getValue()
    		                    			}		
    		                    	}
    		                    	resultStatusArray.push(mainObj);
    		                        }
    		                    });
    		        		}
    		        		else{
    		        			var resultStatus = '';
    		                	var batch = '';
    		                	var mainObj = '';
    		                	mainObj = {
    		                			"resultStatus" : {
	                    					"id" : value.resultStatus.id
	                    			},
	                    			"batch" : {
	                    					"id": form.findField('id').getValue()
	                    			}		
    		                	}
    		                	resultStatusArray.push(mainObj);
    		        		}
    		        	}
    		        	
    		        	
    		            programBatches.set("batchResultStatus",resultStatusArray);
    	        	 
                	 if(value.batchOfSucceedingProgram !=null && value.batchOfSucceedingProgram > 0){
                		 programBatches.set("batchOfSucceedingProgram",value.batchOfSucceedingProgram);
                	 }
                	 if(value.retainingBatch_Id !=null && value.retainingBatch_Id > 0){
                		 programBatches.set("retainingBatch_Id",value.retainingBatch_Id);
                	 }
                	 var docStore = $this.getStore('program.programDetails.programBatches.ProgramBatchDocument');
                	 var docArray = [];
                	 if (docStore.data.items != null
                			 && docStore.data.items.length > 0) {
                		 Ext.each(docStore.data.items, function(val) {
                			 var newData = {
                					 "name" : val.data.documentName,
                					 "path" : val.data.path,
                					 "type" : val.data.type,
                					 "createdBy" : $this.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
                			 };
                			  if(val.data.documentId==""){
        	        			  docArray.push(newData);  
        	        		  }
//                			 docArray.push(newData);
                		 });
                	 }
                	 programBatches.set("documents", docArray);

                     var batchID = value.id;

	 	             var batchClassifications = [];
	 	             if(value.classification && value.classification.length){
	 	             if(value.classification.length == 1 && typeof value.classification[0] == "string" && isNullOrEmpty(value.classification[0])){
	 	              	batchClassifications = [];
	 	             } else{
	 	                 Ext.each(value.classification, function(currentClassification){
	 	                 if(typeof currentClassification == "object"){
	 	                	 batchClassifications.push({
	 	                		 	batch:{
	 	                				 id: batchID
	 	                			 },
	 	                			 studentClassification:{
	 	                				 id:currentClassification.data.id
	 	                			 }
	 	                	 });
	 	                 } else{
	 	                	  batchClassifications.push({
	 	                	     batch:{
	 	                		       id: batchID
	 	                		 },
	 	                		 studentClassification:{
	 	                			 	id:currentClassification
	 	                		 }
	 	                	  });
	 	                    }
	 	                  });
	 	                }
	 	          	}
	 	            programBatches.set("batchStudentClassifications",batchClassifications);


	 	             var batchSpecializations = [];
	 	             if(value.specialization && value.specialization.length){
	 	             if(value.specialization.length == 1 && typeof value.specialization[0] == "string" && isNullOrEmpty(value.specialization[0])){
	 	              	batchSpecializations = [];
	 	             } else{
	 	                 Ext.each(value.specialization, function(currentSpecialization){
	 	                 if(typeof currentSpecialization == "object"){
	 	                	 batchSpecializations.push({
	 	                		 	batch:{
	 	                				 id: batchID
	 	                			 },
	 	                			 studentSpecialization:{
	 	                				 id:currentSpecialization.data.id
	 	                			 }
	 	                	 });
	 	                 } else{
	 	                	  batchSpecializations.push({
	 	                	     batch:{
	 	                		       id: batchID
	 	                		 },
	 	                		 studentSpecialization:{
	 	                			 	id:currentSpecialization
	 	                		 }
	 	                	  });
	 	                    }
	 	                  });
	 	                }
	 	          	}
	 	           programBatches.set("batchSpecializations",batchSpecializations);

	 	             var batchAwardTypes = [];
	 	             if(value.awardType && value.awardType.length){
	 	             if(value.awardType.length == 1 && typeof value.awardType[0] == "string" && isNullOrEmpty(value.awardType[0])){
	 	              	batchAwardTypes = [];
	 	             } else{
	 	                 Ext.each(value.awardType, function(currentAwardType){
	 	                 if(typeof currentAwardType == "object"){
	 	                	 batchAwardTypes.push({
	 	                		 	batch:{
	 	                				 id: batchID
	 	                			 },
	 	                			 programCompletionAwardType:{
	 	                				 id:currentAwardType.data.id
	 	                			 }
	 	                	 });
	 	                 } else{
	 	                	  batchAwardTypes.push({
	 	                	     batch:{
	 	                		       id: batchID
	 	                		 },
	 	                		 programCompletionAwardType:{
	 	                			 	id:currentAwardType
	 	                		 }
	 	                	  });
	 	                    }
	 	                  });
	 	                }
	 	          	}
	 	           programBatches.set("batchAwardTypes",batchAwardTypes);
	 	             
                	 var submitUrl;
                	 if (form.findField('id').getSubmitValue() == null
                			 || form.findField('id').getSubmitValue() == "") {
                		 if(wheatherSchool){
                    		 programBatches.set("maxPeriod", 1);
                        	 programBatches.set("minPeriod", 1);
                        	 programBatches.set("specializationPossible",false);
                        	 programBatches.set("placementProcessRequired",false);
                    	 }else{
                    		 programBatches.set("maxPeriod", value.maxPeriod);
                        	 programBatches.set("minPeriod", value.minPeriod);
                        	 programBatches.set("specializationPossible",value.specializationPossible);
                        	 programBatches.set("placementProcessRequired",value.placementProcessRequired);
                    	 }

                		 submitUrl = SERVERURL.BATCHE_CREATE;
                	 } else {
                		 programBatches.set("maxPeriod", value.maxPeriod);
                    	 programBatches.set("minPeriod", value.minPeriod);
                    	 if(wheatherSchool){
                    		 programBatches.set("specializationPossible",false);
                        	 programBatches.set("placementProcessRequired",false);
                    	 }else{
                    		 programBatches.set("specializationPossible",value.specializationPossible);
                        	 programBatches.set("placementProcessRequired",value.placementProcessRequired);
                    	 }
                    	 
                		 programBatches.set("id", value.id);
                		 submitUrl = SERVERURL.BATCHE_UPDATE;
                	 }

                	 var formData = Ext.encode(programBatches.data);
                	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                	 Ext.Ajax.request({
                		 type : 'rest',
                		 url : submitUrl,
                		 jsonData : formData,
                		 method : 'POST',
                		 success : function(form, action) {
                			 Ext.getBody().unmask();
                			 if(form.responseText == "BATCH_CAPACITY_CANT_BE_REDUCED_AS_SECTION_WITH_MORE_CAPACITY_CREATED"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_CAPACITY_CANT_BE_REDUCED_AS_SECTION_WITH_MORE_CAPACITY_CREATED'));
                			 }
                			 else if(form.responseText == "BATCH_SEQUENCE_CANT_BE_DUPLICATE"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_SEQUENCE_CANT_BE_DUPLICATE'));
                			 }
                			 else if(form.responseText == "BATCH_NAME_CANT_EMPTY"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_NAME_EMPTY'));
                			 }
                			 else if(form.responseText == "BATCH_CAPACITY_CANT_BE_REDUCED_AS_SEAT_TYPE_WITH_MORE_CAPACITY_CREATED"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_CAPACITY_CANT_BE_REDUCED_AS_SEAT_TYPE_WITH_MORE_CAPACITY_CREATED'));
                			 }else if(form.responseText == "PERIOD_SUM_VALIDATION"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_MAX_VALIDATION'));
                			 }else if(form.responseText == "COURSE_SUM_VALIDATION"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('COURSE_SUM_VALIDATION'));
                			 }else if(form.responseText == "CREDIT_SUM_VALIDATION"){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('CREDIT_SUM_VALIDATION'));
                			 }else if(form.responseText == ""){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_NAME_EMPTY'));
                			 }else if((value.isRetentionApplicable !=null && value.isRetentionApplicable == 1) && (value.retainBatch == "" || value.retainBatch == null )){
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('RETAIN_BATCH_NAME_EMPTY'));                        	 }
                			 else{
                			     showSuccessMessage(getCommonTranslation('BATCH'),getCommonTranslation('SUCCESS'));
                				 $this.getStore('program.programDetails.programBatches.ProgramBatchesGridStore').load();
                    			 $this.getProgrambatchesgrid().getSelectionModel().deselectAll(true);
                    			 var activeTab = $this.getProgrambatchesform().up('panel');
                    			 $this.closeTab(activeTab);
                			 }
                		 }
                	 });

                 },
                 getIdValueJson : function(id, value, code) {
                	 if (id)
                		 return {
                		 id : id,
                		 value : value,
                		 code : code
                	 };
                 },
                 additionalReq : function(o, r) {
                	 var areaField = Ext.ComponentQuery.query('textarea#additionalRequirement_Id')[0];
                	 
                	 if (r.hasAdditionalRequirement && o.isVisible()) {
                		 areaField.allowBlank=false;
                		 Ext.ComponentQuery.query('textarea#additionalRequirement_Id')[0].show();
                	} else if (!r.hasAdditionalRequirement) {
                		areaField.allowBlank=true;
                		 Ext.ComponentQuery.query('textarea#additionalRequirement_Id')[0].hide();
                	}
                	 areaField.validate();
                	 areaField.clearInvalid();
                 },  
                 isRetentionApplicable : function(o, r,form) {
                	 var form=this.getProgrambatchesform();
                	 var retainingBatch=form.down("#retainingBatch_Id");
                	
                	 var areaField = Ext.ComponentQuery.query('customcombobox#retainingBatch_Id')[0];
                	 if (r.isRetentionApplicable) {                		 
                		 this.setAllowBlank(areaField,false);
                		 areaField.setValue(null);
                		 areaField.reset();
                		  Ext.ComponentQuery.query('customcombobox#retainingBatch_Id')[0].show();
                		
                	 } else if (!r.isRetentionApplicable) {
                		 
                		 this.setAllowBlank(areaField,true);
                		 areaField.setValue(null);
                		 areaField.validate();
                		 Ext.ComponentQuery.query('customcombobox#retainingBatch_Id')[0].hide();
                		 
                	}
                	 
                	 form.getForm().checkValidity();
                 },
                 
                 isTransferCreditFromStudentPortal : function(o, r,form) {
                	 var form=this.getProgrambatchesform();
                	 var resultStatusRequired=form.down("#resultStatusRequiredId");
                	 var creditType=form.down("#creditTypeId");
                	 var EquivalenceCheck=form.down("#isEquivalenceCheckId");
                	
                	// var areaField = Ext.ComponentQuery.query('customcombobox#retainingBatch_Id')[0];
                	 if (r.isTransferCreditFromStudentPortal) {                		 
                		 this.setAllowBlank(resultStatusRequired,false);
                		 resultStatusRequired.setValue(null);
                		 resultStatusRequired.reset();
                		 resultStatusRequired.show();
                		 
                		 creditType.show();
                		 EquivalenceCheck.show();
                		
                	 } else if (!r.isTransferCreditFromStudentPortal) { 
                		 this.setAllowBlank(resultStatusRequired,true);
                		 resultStatusRequired.setValue(null);
                		 resultStatusRequired.validate();
                		 resultStatusRequired.hide();
                		 
                		 creditType.hide();
                		 EquivalenceCheck.hide();
                	} 
                	 form.getForm().checkValidity();
                 },
                 editProgramBatchFormWindow : function(isReadOnly) {
					 
					 var isRO = Ext.isDefined(isReadOnly) ? isReadOnly : false;
					 
                	 var $this = this;
                	 var grid = this.getProgrambatchesgrid();
                	 if (grid.getSelectionModel().getCount() > 0) {

                		 var records = grid.getSelectionModel().getSelection();
                		 this.showEditProgramBatchFormWindow();
                    	 var programStructure = $this.getBatchdetailstabstructure();
                    	
                    	 var programId = programStructure.getForm().findField('ids').getValue();
                    	 var tillDate= Ext.Date.format(new Date(records[0].data.tillDate), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
                    	 
                		 if (records != undefined && records != ""
                				 && records != null) {
                			 var id = records[0].data.id;
                			 Ext.Ajax
                			 .request({
                				 type : 'rest',
                				 url : SERVERURL.PROGRAM_BATCH_FIND_BY_ID,
                				 params : {
                					 id : id
                				 },
                				 method : 'GET',
                				 success : function(response) {
                					 var form = $this.getProgrambatchesform();
                					 var $form = form.getForm();
                					 var alinfomodel = Academia.model.authentication.ALInfoModel;
                					 var wheatherSchool = alinfomodel.get('wheatherSchool');
                					 form.getForm().findField('programBatchSeq').setReadOnly(isRO);
                					 
                					 if(wheatherSchool){
                						 form.down('#placementProcessRequired').hide();
                						 form.down('#specializationPossible_itemId').hide();
                						 form.getForm().findField('minPeriod').hide();
                						 form.getForm().findField('minPeriod').hide();
                					 }
                					 var data = Ext.decode(response.responseText);
                					 var resultStatusValues = [];
                					 var creditTypeId = null;
                					 if(data && data.batchResultStatus && data.batchResultStatus.length && data.batchResultStatus[0].resultStatus && data.batchResultStatus[0].resultStatus){
                						 var resultStatusValues = Ext.Array.pluck(Ext.Array.pluck(data.batchResultStatus,'resultStatus'),'id');
                					 }
                					 if(data && data.creditType && data.creditType.id){
                						 var creditTypeId = data.creditType.id;
                					 }
                					 var batch = new Academia.model.program.programDetails.programBatches.ProgramBatchModel(data);
                					 form.loadRecord(batch);
                				     if(data.programBatchPrefix!=null)
                					 form.getForm().findField('programBatchPrefix').setReadOnly(true);
                					 $form.findField('isRetentionApplicable').setValue(dateRender(data.isRetentionApplicable));
                					 $form.findField('startDate').setValue(data.batchStartDate);
                					 $form.findField('tillDate').setValue(data.batchTillDate);
                					 $form.findField('programBatchPrefix').setValue(data.programBatchPrefix);
                					 $form.findField('programBatchSeq').setValue(data.programBatchSeq);
                					 //var academyCombo = form.getForm().findField('academicYear');
                					 var periodTypeCombo = form.getForm().findField('programPeriodType');
                					 var modeOfDeliveryCombo = form.getForm().findField('modeOfDelivery');
                					 var calendarCombo = form.getForm().findField('calendar');
                					 var entryDroolCombo = form.getForm().findField('entryDrools');
                					 var exitDroolCombo = form.getForm().findField('exitDrools');
                					 var otherRuleApplicable = form.getForm().findField('otherRuleApplicable');
                					 var sgpaCgpaCalculationRuleField = form.getForm().findField('sgpaCgpaCalculationRule');
                					 var minimumCPA = form.getForm().findField('minimumCPA');
                					 sgpaCgpaCalculationRuleField.setValue(data.sgpaCgpaCalculationRule);
                					 
                					 if(sgpaCgpaCalculationRuleField.getValue() == 'SPA_CPA_AND_GPA_CALCULATION')
                					 {	
                						 minimumCPA.setValue(data.minimumCPA);
                						 $this.setAllowBlank(minimumCPA,false);
                						 minimumCPA.setVisible(true);
                					 }
                					 else{
                						 minimumCPA.setValue(null);
                						 $this.setAllowBlank(minimumCPA,true);
                						 minimumCPA.isVisible(false);
                					 }
                					 
                					 if(sgpaCgpaCalculationRuleField.isVisible()==false)
                						 {
                						 $this.setAllowBlank(minimumCPA,true);
                						 minimumCPA.setVisible(false);
                						 }
                					 var batchPartTimeRadio = form.down('#batchPartTime');//$form.findField('batchPartTime');
                					 var enquiryEnableRadio = form.down('#enquiryEnable_Id');
                					 var publishInCatalogue = form.down('#publishInCatalogueId');
									 publishInCatalogue.setValue(data.publishInCatalogue);	
									 
									 var allowMultipleLastPeriods = form.down('#allowMultipleLastPeriodsId');
									 allowMultipleLastPeriods.setValue(data.allowMultipleLastPeriods);	
								                					
                					 if (data.batchPartTime) {
                						 batchPartTimeRadio.items.items[0]
                						 .setValue(true);
                						 batchPartTimeRadio.items.items[1]
                						 .setValue(false);
                					 } else if (!data.batchPartTime) {
                						 batchPartTimeRadio.items.items[0]
                						 .setValue(false);
                						 batchPartTimeRadio.items.items[1]
                						 .setValue(true);
                					 }
                					 
                					 
                					 if (data.enquiryEnable) {
                						 enquiryEnableRadio.items.items[0]
                						 .setValue(true);
                						 enquiryEnableRadio.items.items[1]
                						 .setValue(false);
                					 } else if (!data.enquiryEnable) {
                						 enquiryEnableRadio.items.items[0]
                						 .setValue(false);
                						 enquiryEnableRadio.items.items[1]
                						 .setValue(true);
                					 }

                					 var placementProcessRequiredRadio = form.down('#placementProcessRequired');//$form.findField('placementProcessRequired');
                					 if (data.placementProcessRequired) {
                						 placementProcessRequiredRadio.items.items[0]
                						 .setValue(true);
                						 placementProcessRequiredRadio.items.items[1]
                						 .setValue(false);
                					 } else if (!data.placementProcessRequired) {
                						 placementProcessRequiredRadio.items.items[0]
                						 .setValue(false);
                						 placementProcessRequiredRadio.items.items[1]
                						 .setValue(true);
                					 }
                					 /**
                					  * @author Ravi Choudhary
                					  * for advance config functionality i.e. min max Required or not 
                					  */
                					 var isAdvanceConfigId = form.down('#isAdvanceConfigId');
                					 if (data.isAdvanceConfig) {
                						 isAdvanceConfigId.items.items[0].setValue(true);
                						 isAdvanceConfigId.items.items[1].setValue(false);
                					 } else if (!data.isAdvanceConfig) {
                						 isAdvanceConfigId.items.items[0].setValue(false);
                						 isAdvanceConfigId.items.items[1].setValue(true);
                					 }
                					 var isFeeApplicable = form.down('#isFeeApplicable');
                					 if (data.isFeeApplicable) {
                						 isFeeApplicable.items.items[0].setValue(true);
                						 isFeeApplicable.items.items[1].setValue(false);
                					 } else if (!data.isFeeApplicable) {
                						 isFeeApplicable.items.items[0].setValue(false);
                						 isFeeApplicable.items.items[1].setValue(true);
                					 }

									if(data.isFeeApplicable){
										Ext.Ajax.request({
										type : 'rest',
										url : SERVERURL.PATH_FIND_COURSE_FEE_DEFINATION_BY_BATCHID+"?batchId="+id,
										method : 'GET',
										success : function(resp, action) {
											var count = Ext.decode(resp.responseText);
											if(count>0){
												isFeeApplicable.setReadOnly(true);
											   }
											}
										});
									}
									if(data.lastPeriodSize>1){
										allowMultipleLastPeriods.setReadOnly(true);
									}
									
                					 var intakeYear = form.getForm().findField('intakeYear');
                					 intakeYear.store.load({
                						 callback : function(records, operation, success) {
                							 if (success && data.intakeYear) {
                								 intakeYear.setValue(data.intakeYear.id);
                							 }
                						 }
                					 });
                					 var specializationPossibleRadio = Ext.ComponentQuery
                					 .query('radiogroup#specializationPossible_itemId')[0];
                					 if (data.specializationPossible) {
                						 specializationPossibleRadio.items.items[0]
                						 .setValue(true);
                						 specializationPossibleRadio.items.items[1]
                						 .setValue(false);
                					 } else if (!data.specializationPossible) {
                						 specializationPossibleRadio.items.items[0]
                						 .setValue(false);
                						 specializationPossibleRadio.items.items[1]
                						 .setValue(true);
                					 }
                					 $form.findField("specPossible").setValue(data.specializationPossible);
                					
                					 var addReq = Ext.ComponentQuery
                					 .query('radiogroup#additionlReq_Id')[0];
                					 if (data.hasAdditionalRequirement) {
                						 addReq.items.items[0]
                						 .setValue(true);
                						 addReq.items.items[1]
                						 .setValue(false);
                					 } else {
                						 addReq.items.items[0]
                						 .setValue(false);
                						 addReq.items.items[1]
                						 .setValue(true);
                					 }
                					 
                					 var transferCreditRadio = Ext.ComponentQuery
                					 .query('radiogroup#isTransferCreditFromStudentPortalId')[0];
                					 if (data.isTransferCreditFromStudentPortalId) {
                						 transferCreditRadio.items.items[0]
                						 .setValue(true);
                						 transferCreditRadio.items.items[1]
                						 .setValue(false);
                						 $form.findField('resultStatus').setValue(resultStatusValues);
                						 $form.findField('creditType').setValue(creditTypeId);
                						 var isEquivalenceCheckRadio= $form.findField('isEquivalenceCheck');
                						 if (data.isEquivalenceCheck) {
                							 isEquivalenceCheckRadio.items.items[0]
                    						 .setValue(true);
                							 isEquivalenceCheckRadio.items.items[1]
                    						 .setValue(false);
                						 }
                					 } else {
                						 transferCreditRadio.items.items[0]
                						 .setValue(false);
                						 transferCreditRadio.items.items[1]
                						 .setValue(true);
                						 $form.findField('resultStatus').setValue([]);
                						 $form.findField('creditType').setValue(null);
                					 }
                					 
                					 if($form.findField('isTransferCreditFromStudentPortal').isVisible() && data.isTransferCreditFromStudentPortalId){
                						 $form.findField('resultStatus').setVisible(true);
                						 $form.findField('creditType').setVisible(true);
                						 $form.findField('isEquivalenceCheck').setVisible(true);
                					 }else{
                						 $form.findField('resultStatus').setVisible(false);
                						 $form.findField('creditType').setVisible(false);
                						 $form.findField('isEquivalenceCheck').setVisible(false);
                					 }
                                      $form.findField('awardType').setVisible(false);
									  $form.findField('classification').setVisible(false);
									  $form.findField('specialization').setVisible(false);
                					 
                					 var academyLocationId = $this.getCurrentAcademyLocation();
                    				 $this.saveDFRInfo(academyLocationId,'programbatchesform',form);
                					 
                					 /*var CreditTypeRadio = Ext.ComponentQuery
                					 .query('radiogroup#creditTypeId')[0];
                					 if (data.isTransferCreditFromStudentPortalId) {
                						 CreditTypeRadio.items.items[0]
                						 .setValue(true);
                						 CreditTypeRadio.items.items[1]
                						 .setValue(false);
                					 } else {
                						 CreditTypeRadio.items.items[0]
                						 .setValue(false);
                						 CreditTypeRadio.items.items[1]
                						 .setValue(true);
                					 }*/
                					 
                					 var isRetenApplicable = Ext.ComponentQuery
                					 .query('radiogroup#isRetentionApplicable_Id')[0];
                					 if (data.isRetentionApplicable) {
                						 isRetenApplicable.items.items[0]
                						 .setValue(true);
                						 isRetenApplicable.items.items[1]
                						 .setValue(false);
                					 } else {
                						 isRetenApplicable.items.items[0]
                						 .setValue(false);
                						 isRetenApplicable.items.items[1]
                						 .setValue(true);
                					 }


                					 if(!isNullOrEmpty(data.programEntryCriteria)){
                						 entryDroolCombo.store.load({
                							 callback : function(records,operation,success) {
                								 if (success) {
                									 entryDroolCombo.setValue(data.programEntryCriteria.id);
                								 }
                							 }
                						 });
                					 }

                					 if(!isNullOrEmpty(data.programExitCriteria)){
                						 exitDroolCombo.store.load({
                							 callback : function(records,operation,success) {
                								 if (success) {
                									 exitDroolCombo.setValue(data.programExitCriteria.id);
                								 }
                							 }
                						 });
                					 }
                					 if(!isNullOrEmpty(data.otherRuleApplicable)){
                						 otherRuleApplicable.store.load({
                							 callback : function(records,operation,success) {
                								 if (success) {
                									 otherRuleApplicable.setValue(data.otherRuleApplicable.id);
                								 }
                							 }
                						 });
                					 }

                					 calendarCombo.store
                					 .load({
                						 callback : function(
                								 records,
                								 operation,
                								 success) {
                							 if (success) {
                								 calendarCombo
                								 .setValue(data.calendar.id);

                							 }
                						 }
                					 });

                					 periodTypeCombo.store
                					 .load({
                						 callback : function(
                								 records,
                								 operation,
                								 success) {
                							 if (success) {
                								 periodTypeCombo
                								 .setValue(data.programPeriodType.id);

                							 }
                						 }
                					 });
                					 modeOfDeliveryCombo.store.load({
                						 callback : function(records,operation,success) {
                							 if (success) {
                								 if(data.modeOfDelivery!= null)
                  								 modeOfDeliveryCombo.setValue(data.modeOfDelivery.id);
                							 }
                						 }
                					 });
                					 var roundingMode=form.getForm().findField('roundingMode');
                					  	roundingMode.getStore().load({
                		   				callback:function(){
                		   					roundingMode.setValue(data.roundingMode);		
                		   				}
                					  	});
                					  	var roundingCount=form.getForm().findField('roundingCount');
                					  	setTimeout(function(){
                					  		roundingCount.setValue(data.roundingCount);
                					  	},200);
                					 var store = $this.getStore('program.programDetails.programBatches.ProgramBatchDocument');
                					  store.getProxy().extraParams = {
                						  batchId : data.id
                    				 };
                					  store.load();
                					  var store = $this.getStore('program.programDetails.programBatches.RetainingBatches');
     		        				 store.getProxy().extraParams = {
     		        					 programId : programId,
     		        					 batchId : data.retainBatch,
     		        					 tillDate:tillDate
     		        				 };
     		        				 store.load({
                						 callback : function(records,operation,success) {
                							 if (success) {
                								 if(records.length==1){
                									 form.down('#retainingBatch_Id').setValue(records[0].data.id);
                								 }
                							 }
                						 }
                					 });
                					  Ext.defer(function() {
                						  form.getForm().findField('printName').setValue(data.printName);
	                        	        }, 10, this);
                					  
                					  var completionTime=form.getForm().findField('completionTime');
                					  completionTime.setValue(data.completionTime)


	                			 if(data.batchAwardTypes && data.batchAwardTypes.length){
	                				 	var batchAwardTypesField = form.getForm().findField('awardType');
								  		var awardTypeStore = batchAwardTypesField.getStore();
										awardTypeStore.getProxy().setExtraParam('statusType', 'ALL');
		                			 	awardTypeStore.load({
		                				 callback: function(record, operation, success) {
		                					 var batchAwardTypesArray = data.batchAwardTypes;
		                					 var batchAwardTypesValue = Ext.Array.pluck(Ext.Array.pluck(batchAwardTypesArray, 'programCompletionAwardType'), 'id');
		                					 
		                					 batchAwardTypesField.setValue(batchAwardTypesValue);
		                				 }
		                			 });
                                 
	                			 } 
                                if(data.batchStudentClassifications && data.batchStudentClassifications.length){
	                				 var classificationField = form.getForm().findField('classification');
		                			 classificationField.getStore().load({
		                				 callback: function(record, operation, success) {
		                					 var classificationArray = data.batchStudentClassifications;
		                					 var classificationValue = Ext.Array.pluck(Ext.Array.pluck(classificationArray, 'studentClassification'), 'id');
		                					 
		                					 classificationField.setValue(classificationValue);
		                				 }
		                			 });
	                			 }  
                                 if(data.batchSpecializations && data.batchSpecializations.length){
	                				 var specializationField = form.getForm().findField('specialization');
		                			 specializationField.getStore().load({
		                				 callback: function(record, operation, success) {
		                					 var specializationArray = data.batchSpecializations;
		                					 var specializationValue = Ext.Array.pluck(Ext.Array.pluck(specializationArray, 'studentSpecialization'), 'id');
		                					 
		                					 specializationField.setValue(specializationValue);
		                				 }
		                			 });
	                			 }
                					    var batchAwardTypesField = form.getForm().findField('awardType');
								  		var awardTypeStore = batchAwardTypesField.getStore();
										awardTypeStore.getProxy().extraParams.statusType='';
										
                					  var holdSubCat=form.getForm().findField('holdSubCategory');
                					  var holdSubCatIds= [];
						                if(!isNullOrEmpty(data.batchSubHoldCategory)) {
						                    for(var i in data.batchSubHoldCategory){
						                    	holdSubCatIds.push(data.batchSubHoldCategory[i].manageSubHoldCategory.id);
						                    }
						                }

										holdSubCat.getStore().getProxy().extraParams = {
                						  batchId : data.id
                    				 	};
						                holdSubCat.getStore().load({
						                    callback:function(records){
						                    	holdSubCat.setValue(holdSubCatIds); 
						                        }
						                });
                				 }
                			 });
                		 }
                	 } else {
                		 showWarningMessage(getCommonTranslation('ALERT'),
                				 getCommonTranslation('PLEASE_SELECT_RECORD'));
                	 }
                 },
                 
                 deleteRecord : function(o, r) {
                	 // var this$ = this;
                	 var grid = this.getProgrambatchesgrid();
                	 var batchBtn = grid.down('#btnCopyBatch');
                	 if (grid.getSelectionModel().getCount() > 0) {
                		 showConfirmMessage(getCommonTranslation('BATCH'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                				 function(btn, text) {
                					 if (btn == 'yes') {
                						 var records = grid
                						 .getSelectionModel()
                						 .getSelection()[0];
                						 var id = records.data.id;
                						 Ext.Ajax.request({
                							 method : "DELETE",
                							 type : 'rest',
                							 url : SERVERURL.BATCHE_DELETE + '?id=' + id,
                							 headers : {
                								 'Content-Type' : 'application/json'
                							 },
                							 params : {
                								 id : id
                							 },
                							 success : function(form, action) {
                								 if(form.responseText == "DEPENDENT_RECORD_EXISTS"){
                									 showWarningMessage(getCommonTranslation('ALERT'),
                											 getProgramandcourseTranslation('DEPENDENT_RECORD_EXISTS'));
                								 }else{
                									 showSuccessMessage(getCommonTranslation('BATCH'), getCommonTranslation('SUCCESS'));
                									 grid.getStore().reload({
                										 callback:function(record){
                											 var store = grid.getStore();
                											 if(store.getRange().length ==0){
                												 grid.down('#btnCopyBatch').setDisabled(true);
                											 }
                											 else{
                												 grid.down('#btnCopyBatch').setDisabled(false);
                											 }
                										 }
                									 });
                									
                								 }
                							 }
                						 });
                					 }
                				 });
                	 } else {
                		 showWarningMessage(getCommonTranslation('ALERT'),
                				 getCommonTranslation('PLEASE_SELECT_RECORD'));
                	 }

                 },
                 batchCopySave : function() {
                	 var $this = this;
                	 var form = $this.getBatchCopywindow().getForm();

                	 var batchName = form.findField('name').getValue();

                	 var programStructure = $this.getBatchdetailstabstructure();
                	 var progId = programStructure.getForm().findField('ids').getValue();
                	 var submitUrl = SERVERURL.BATCH_UNIQUE + '?programId='+ progId + '&fieldToBeChecked=batchName'+ '&value=' + batchName;
                	 $this.applyWindowMask(); 
                	 Ext.Ajax.request({
                		 type : 'rest',
                		 url : submitUrl,
                		 params : {
                			 programId : progId,
                			 value : batchName
                		 },
                		 method : 'POST',
                		 success : function(form, action) {
                			 var res = Ext.JSON.decode(form.responseText);
                			 if(res){
                				 $this.batchCopyapi();
                			 }else{
                				 selectText.reset();	
                			 }
                		 }
                	 });
                 },
                 batchCopyapi:function(){
                	 var $this = this;
                	 var form = $this.getBatchCopywindow().getForm();
                	 var formValues = form.getValues();
                	 var batchFormData = new Object();
                	 batchFormData.batchId = formValues.batchId;
                	 batchFormData.newBatchName = formValues.name;
                	 batchFormData.batchStartDate = formValues.batchStartDate;
                	 batchFormData.batchTillDate = formValues.batchTillDate;
                	 batchFormData.firstPeriodName = formValues.firstPeriodName;
                	 batchFormData.periodStartDate = formValues.periodStartDate;
                	 batchFormData.periodTillDate = formValues.periodTillDate;
                	 batchFormData.succeedingBatchId = formValues.succeedingBatch;
                	 batchFormData.enrollmentLastDate = formValues.enrollmentLastDate;
                	
                	 var formData = Ext.encode(batchFormData);
                	 Ext.Ajax.request({
                		 type : 'rest',
                		 url : SERVERURL.BATCH_COPY,
                		 timeout: 900000,// 15 min
                		 method : 'POST',
                		 jsonData : formData,
                		 success : function(form, action) {
                			 if(form.responseText == 'SUCCESS'){
                				 $this.hideWindowMask();
                				 showSuccessMessage(getCommonTranslation('BATCH'),getCommonTranslation('BATCH_COPYIED_SUCCESS'));
                				 //$this.getProgrambatchdocumentgrid().getStore().reload();
                				 //V2D-80766
                				 $this.resetPageSetting($this.getStore('program.programDetails.programBatches.ProgramBatchesGridStore'));
                				 $this.getStore('program.programDetails.programBatches.ProgramBatchesGridStore').load();
                				 $this.getBatchcopywindow().close();
                			 }else if(form.responseText == "BatchNameError"){
                				 $this.hideWindowMask();
                				 showWarningMessage(getCommonTranslation('ALERT'), 
                						 getProgramandcourseTranslation('BATCH_NAME_EMPTY'));
                			 }else{
                				 $this.hideWindowMask();
                				 showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); 
                			 }
                		 }
                	 });

                 },

                 batchOnChange : function(selectText, delay, callback, scope) {
                	 var $this = this;
                	 var form1 = $this.getProgrambatchesform();
                	 var programStructure = $this.getBatchdetailstabstructure();
                	 var progId = programStructure.getForm().findField('ids').getValue();
                	 var grid = $this.getProgrambatchesgrid();
                	 name = selectText.value;
                	 var submitUrl = SERVERURL.BATCH_UNIQUE + '?programId='+ progId + '&fieldToBeChecked=batchName'+ '&value=' + name;
                	 Ext.Ajax.request({
                		 type : 'rest',
                		 url : submitUrl,
                		 params : {
                			 programId : progId,
                			 value : name,
                		 },
                		 method : 'POST',
                		 
                		 success : function(form, action) {
                		  Ext.JSON.decode(form.responseText);
                		  
                		 },
                		 failure:function(form,action){
                			 form1.down('#batch_Id').reset();
                		 }
                		 
                	 });
                 },
                 batchCopyOnChange : function(selectText, delay, callback, scope) {
                	 var $this = this;
                	 var form = $this.getProgrambatchcopyfilter();
                	 var btch=form.down('#batchNameItemId').getValue();
                	 var programStructure = $this.getBatchdetailstabstructure();
                	 var progId = programStructure.getForm().findField('ids').getValue();
                	 var grid = $this.getProgrambatchesgrid();
                	 var records = grid.getSelectionModel().getSelection()[0];
                	 name = selectText.value;
                	 var submitUrl = SERVERURL.BATCH_UNIQUE + '?programId='+ progId + '&fieldToBeChecked=batchName'+ '&value='+ name;
                	 Ext.Ajax.request({
                		 type : 'rest',
                		 url : submitUrl,
                		 params : {
                			 programId : progId,
                			 value : name,
                			 
                		 },
                		 method : 'POST',
                		 success : function(form, action) {
                		  Ext.JSON.decode(form.responseText);
                		 }
                		 ,
               		  failure : function(form, action) {
               		  Ext.JSON.decode(form.responseText);
               		$this.getProgrambatchcopyfilter().down('#batchNameItemId').reset();
               		 }
                	 });
                 },
                 periodBeakInheritRadio : function(o, r) {
                	 var $this = this;
                	 var form = $this.getProgrambatchesform().getForm();
                	 var programPeriodInherited = form.findField(
                			 'programPeriodInherited').getValue();
                	 var programPeriodBreakInherited = r.programPeriodBreakInherited;

                	 if (programPeriodBreakInherited
                			 && !programPeriodInherited) {
                		 form.findField('programByInheritProgramId')
                		 .enable();
                		 form.findField('batch').enable();
                	 } else if (!programPeriodBreakInherited
                			 && !programPeriodInherited) {
                		 form.findField('programByInheritProgramId')
                		 .disable();
                		 form.findField('batch').disable();
                	 }
                 },
                 periodInheritRadio : function(o, r) {
                	 var $this = this;
                	 var form = $this.getProgrambatchesform().getForm();
                	 var programPeriodInherited = r.programPeriodInherited;
                	 var programPeriodBreakInherited = form.findField(
                			 'programPeriodBreakInherited').getValue();

                	 if (programPeriodInherited
                			 && !programPeriodBreakInherited) {
                		 form.findField('programByInheritProgramId')
                		 .enable();
                		 form.findField('batch').enable();
                	 } else if (!programPeriodInherited
                			 && !programPeriodBreakInherited) {
                		 form.findField('programByInheritProgramId')
                		 .disable();
                		 form.findField('batch').disable();
                	 }
                 },
	                             // ***delete doc*********
                 deleteProgramBatchDocumentFile : function() {
                	 var $this = this;
                	 var grid = $this.getProgrambatchdocumentgrid();
                	 if (grid.getSelectionModel().getCount() > 0) {
                		 showConfirmMessage(getCommonTranslation('BATCH'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                				 function(btn, text) {
                					 if (btn == 'yes') {
                						 var records = grid.getSelectionModel().getSelection();
                						 var id = records[0].get("id");
                					if (!isNullOrEmpty(id)) {
                						Ext.Ajax.request({
                							 method : "DELETE",
                							 type : 'rest',
                							 url : SERVERURL.PROGRAM_BATCH_DOCUMENT_DELETE_URL+ '?id='+ id,
                							 headers : {
                								 'Content-Type' : 'application/json'
                							 },
                							 success : function(
                									 form,
                									 action) {
                								 grid.getStore().reload();
                								 showSuccessMessage(getCommonTranslation('BATCH'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                							 }
                						 });
                					}else{
                						var store = grid.getStore();
                						store.remove(records[0]);
                						showSuccessMessage(getCommonTranslation('BATCH'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                					}	
                					 }
                				 });
                	 } else {
                		 showWarningMessage(getCommonTranslation('BATCH'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
                	 }
                 },
	                             // ******* get Doc Controller**********
                 getDocumentController : function() {
                	 var this$ = this;
                	 return this$
                	 .getController('Academia.controller.document.DocumentController');
                 },
	           
                 batchOfSucceedingProgram:function(){
                	 var $this = this;
                	 var programStructure = $this.getBatchdetailstabstructure();
                	 var programId = programStructure.getForm().findField('ids').getValue();
                	 var batchForm = $this.getProgrambatchesform().getForm(); 
                	 var roundingMode=batchForm.findField('roundingMode');
                	 roundingMode.getStore().load({
                		 callback:function(){
                			 roundingMode.setValue("HALF_UP");		
                		 }
                	 });
                	 var roundingCount=batchForm.findField('roundingCount');
                	 setTimeout(function(){
                		 roundingCount.setValue(2);
                	 },300);
                	 Ext.Ajax.request({
                		 type : 'rest',
                		 url : SERVERURL.EDIT_PROGRAM_MASTER_GRID_URL,
                		 headers: {
                			 'Content-Type': 'application/json'
                		 },
                		 params : {
                			 id: programId
                		 },
                		 method : 'GET',
                		 success : function(f, action) {
                			 var data = f.responseText;
                			 var  jData=Ext.JSON.decode(data);
                			 if(jData.whetherSucceedingProgram){
                				 batchForm.findField('batchOfSucceedingProgram').setVisible(true);
                			     
                				 var store = $this.getStore('program.programDetails.programBatches.SucceedingBatches');
                				 store.getProxy().extraParams = {
                					 programId : programId
                				 };
                				 store.load({
            						 callback : function(records, operation, success) {
            							 if (success) {/* 
            								 var store = $this.getStore('program.programDetails.programBatches.RetainingBatches');
            		        				 store.getProxy().extraParams = {
            		        					 programId : programId
            		        				 };
            		        				 store.load();
            		                	 */}
            						 }
            					 });
                			 }else{
                				 batchForm.findField('batchOfSucceedingProgram').setVisible(false);
                				// batchForm.findField('retainingBatch_Id').setValue(jData.retainingBatch_Id);
                				// batchForm.findField('retainingBatch_Id').setVisible(true);
                			 }
                			 whetherSingleCourseProg=jData.isSingleCourseProgram;
                			 if(jData.isSingleCourseProgram){
                				 batchForm.findField('minProgramCourses').setReadOnly(true);
                				 batchForm.findField('minProgramCourses').setValue(1);
                				 batchForm.findField('maxProgramCourses').setReadOnly(true);
                				 batchForm.findField('maxProgramCourses').setValue(1);

                				 batchForm.findField('minCompulsoryCourses').setReadOnly(true);
                				 batchForm.findField('minCompulsoryCourses').setValue(1);
                				 batchForm.findField('maxCompulsoryCourses').setReadOnly(true);
                				 batchForm.findField('maxCompulsoryCourses').setValue(1);

                				 batchForm.findField('minOptionalCourses').setReadOnly(true);
                				 batchForm.findField('minOptionalCourses').setValue(1);
                				 batchForm.findField('maxOptionalCourses').setReadOnly(true);
                				 batchForm.findField('maxOptionalCourses').setValue(1);

                			 }

                			 if (!isNullOrEmpty(jData.programClosureDate)) {
                				 batchForm.findField('tillDate').setMaxValue(dateRender(jData.programClosureDate));
                			 }
                			 if(jData.programMarkGrade=='G') {
                				 batchForm.findField('sgpaCgpaCalculationRule').setDisabled(false);
                				 batchForm.findField('sgpaCgpaCalculationRule').allowblank = false;
                			 } else {
                				 batchForm.findField('sgpaCgpaCalculationRule').setDisabled(true);
                				 batchForm.findField('sgpaCgpaCalculationRule').allowblank = true;
                			 }


                		 }
                	 });
                 },
                  removeDocStore:function(){
 			    	var $this = this;
 			    	var grid=$this.getProgrambatchdocumentgrid();
 			    	var store = grid.getStore();
 			    	store.removeAll();
 			    },
 			    
 			    getSucceedingBatch:function() {
 			    	var $this = this;
 			    	var programDetailform = $this.getBatchdetailstabstructure();
 			    	var programId = programDetailform.getForm().findField('ids').getValue();
 			    	var copyBatchForm = $this.getBatchCopywindow().getForm();
 			    	Ext.Ajax.request({
 			    		type : 'rest',
 			    		url : SERVERURL.EDIT_PROGRAM_MASTER_GRID_URL,
 			    		headers: {
 			    			'Content-Type': 'application/json'
 			    		},
 			    		params : {
 			    			id: programId
 			    		},
 			    		method : 'GET',
 			    		success : function(f, action) {
 			    			var data = f.responseText;
 			    			var jData=Ext.JSON.decode(data);
 			    			if(jData.whetherSucceedingProgram){
 			    				var succeedingBatchField = copyBatchForm.findField('succeedingBatch');
 			    				var succeedingBatchStore= succeedingBatchField.getStore();
 			    				succeedingBatchStore.getProxy().extraParams = {
 			    					programId : programId
 			    				};
 			    				succeedingBatchStore.load();
 			    			}
 			    		}
 			    	});
 			    },
 			    
 			    getCalendarsOfAL:function() {
 			    	var $this = this;
 			    	var form = $this.getProgrambatchesform();
 			    	var calStore = form.down('#calendar').getStore();
 			    	var al = this.getCurrentAcademyLocation();
 			    	calStore.getProxy().extraParams = {              
 			    		academyLocationId: al
 			    	};
 			    	calStore.load();
 			    },
 			   getBatchExitDrool : function() {
 				  var $this = this;
			    	var form = $this.getProgrambatchesform();
			    	var droolStore = form.down('#exitDroolItemId').getStore();
			    	droolStore.getProxy().extraParams = {              
			    		moduleName:'PHASE_WISE_PROMOTION_RULE' 
 			    	};
			    	droolStore.load();
			    	var droolStore = form.down('#otherRuleApplicableId').getStore();
			    	droolStore.getProxy().extraParams = {              
			    		moduleName:'BATCH_DROOL' 
 			    	};
			    	droolStore.load();
 			    },
 			    
 			   addProgramBatchCopyTab :function(){
 				  var  grid = this.getProgrambatchesgrid();
 				  if(grid.getSelectionModel().getCount() > 0){
 			    	var contentpanel = this.getContentPanel();
 					var programBatchCopyStructure = Ext.widget('programbatchcopytabstructure');
 					var tabName = getCommonTranslation('COPY_BATCH');
 					// var grid = this.getRegistrationsetupgrid();
 					var getcontroller=this.getController('menu.CoreERPNavigationController');
 					var getTab=getcontroller.getTab(tabName);
 					if(getTab!=null){
 						contentpanel.remove(getTab, true);
 					}
 					
 					if(contentpanel!=undefined){
 						        	var getTab =Ext.create('Academia.view.course.CourseParentPanel',{
 							        		title: tabName,
 							        		closable:true,
 							        		autoScroll:true,
 							        		itemId:'addRegistrationDetailsPnl',
 							        		menuColorCls: CONSTANTS.MENU_COLOR_THREE,
 							        		items:[programBatchCopyStructure]
 						        	}); 
 						        	contentpanel.add(getTab);																	
 						        	contentpanel.setActiveTab(getTab);
 						        	contentpanel.doLayout();
 						var pbCopyGrid = contentpanel.getActiveTab().down('programbatchcopygrid');
 						var alinfomodel = Academia.model.authentication.ALInfoModel;
 						var wheatherSchool = alinfomodel.get('wheatherSchool');
 						if(wheatherSchool){
 							Ext.each(pbCopyGrid.columns, function(currentColumn){
 								if(currentColumn.dataIndex=="registrationSetup")
 								{
 									currentColumn.destroy();	
 								} 							  
 							});
 						}/*else{
 							Ext.each(pbCopyGrid.columns, function(currentColumn){
 								if(currentColumn.dataIndex=="enrollmentLastDate")
 								{
 									currentColumn.destroy();	
 								} 							  
 							});
 						}*/

 						        } 
 			    }  
 				 else {
         		     showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
         	      }
 			   },
 			  saveDFRInfo: function(academyLocationId,formAlias,form) {
       			var $this = this;
             	 Ext.Ajax.request({
              		url: SERVERURL.COMMON_FORM_FIELD_INFO,
              		method: 'GET',
              		async: false,
              		params: {
              			academyLocationId:academyLocationId,
              			languageCode:'en',
              			screenName:formAlias
              		},
              		success: function(response) {
              			var json = JSON.parse(response.responseText);
              			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
              			var	formFieldsInfo = fieldInfo.get("formFieldsInfo");	
              	 		var formfields = formFieldsInfo[formAlias];
              	 		if(formfields != undefined){
              	 			for(var i in formfields){
              	 				if(formfields[i].formAliasName == formAlias){
              	 					var formFieldId = formfields[i].formFieldId;
              	 					var formFieldVisiable = formfields[i].isVisible;
              	 					var formName = formfields[i].formAliasName;
              	 					if(formName==formAlias && formFieldId =="isTransferCreditFromStudentPortalId" && formFieldVisiable == false){
              	 						form.down('#resultStatusRequiredId').hide();
     			 						form.down('#creditTypeId').hide();
     			 						form.down('#isEquivalenceCheckId').hide();
              	 					}
									if(formName==formAlias && formFieldId =="awardType" && formFieldVisiable == true){
										 form.down('#awardType').setVisible(true);
									}
									if(formName==formAlias && formFieldId =="classification" && formFieldVisiable == true){
									  form.down('#classification').setVisible(true);
									}
									if(formName==formAlias && formFieldId =="specialization" && formFieldVisiable == true){
									  form.down('#specialization').setVisible(true);
									}

									/*else if(formName==formAlias && formFieldName =="thereIsSucceddingProgmId" && formFieldVisiable == true){
              	 						var succedingProgram = form.down('#ceb_spId');
              	 						succedingProgram.show();
              	 					}*/
              	 				}
              	 			}
              	 		}
              		}
              	});
              
              },
 			  
});