/**
 * @Author Bhanu P Singh
 */
Ext.define('Academia.controller.program.transfercredits.TransferCreditsController', {
	extend: 'Academia.controller.base.BaseController',

	stores: ['program.ProgramGroupStore','Academia.store.enquiry.exam.ProgramStore','program.ProgramCategoryStore','enquiry.AcademicBatchStore',
	         'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','program.transfercredit.AddTrensferCreditGridStore',
	         'program.SpecializationEnrollmentGridStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
	         'program.transfercredit.TransferCreditStatusStore','examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanTransferCredit',
	         'program.ProgramCategoryStore','program.ProgramGroupStore','common.ProgramForBillStore','program.transfercredit.TrensferCreditGridStore',
	         'examinationcenters.revaluation.RevaluationMappedProgramStore','coursetransaction.homework.CreditTypeDropDown','examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	         'common.AcademyLocationNameSeparated','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch','coursetransaction.studentenrollment.studentenrollmentdetail.SearchStudentByNameAndAcademyLocation'],

	         models: [],

	         views: ['program.StudentSpecialEnrollmentGrid','program.transfercredits.TransferCreditStructure','program.transfercredits.TCSearchStudent',
	                 'program.transfercredits.TransferCreditFilter','program.transfercredits.TransferCreditGrid',
	                 'program.transfercredits.AddTransferCreditStructure','program.transfercredits.AddTransferCreditGrid',
	                 'program.transfercredits.TCStudentFlyOut','baselayout.contentarea.ContentPanel','program.transfercredits.TransferCreditCoursesWin',
	                 'program.transfercredits.ExternalCourseInstituteWin'],
	                 config: {
	                	 ADD_TRANSFER_CREDIT_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSFER_CREDITS'),
	                	 STUDENT_TRANSFER_CREDIT_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSFER_CREDITS')
	                 },	                 

	                 refs: [{
	                	 ref: 'transfercreditfilter',
	                	 selector: 'transfercreditfilter'
	                 },{
	                	 ref: 'transfercreditgrid',
	                	 selector: 'transfercreditgrid'
	                 },{
	                	 ref: 'addtransfercreditstructure',
	                	 selector: 'addtransfercreditstructure'
	                 },{
	                	 ref: 'contentPanel',
	                	 selector: 'contentPanel'
	                 },{
	                	 ref: 'tcsearchstudent',
	                	 selector: 'tcsearchstudent'
	                 },{
	                	 ref: 'addtransfercreditgrid',
	                	 selector: 'addtransfercreditgrid'
	                 },{
	                	 ref: 'tcstudentflyout',
	                	 selector: 'tcstudentflyout'
	                 },{
	                	 ref: 'transfercreditcourseswin',
	                	 selector: 'transfercreditcourseswin'
	                 },{
	                	 ref: 'externalcourseinstitutewin',
	                	 selector: 'externalcourseinstitutewin'
	                 }],
	                 init: function(application) {
	                	 this.control({
	                		 'tcstudentflyout':{
	                			 expand: function(cmp){
	                				 setTimeout(function(){
	                					 cmp.body.el.dom.style.opacity = 1
	                				 },1000);
	                			 }
	                		 },
	                		 'addtransfercreditstructure' : {
		             				beforerender : function() {
		             					this.getAddtransfercreditgrid().getStore().removeAll();
		             					
		             				},
		             				afterrender : function(structure) {
		             					var panelId = structure.down('#addTransferCreditPanelItemId');
		             					var grid = structure.down('addtransfercreditgrid');
		             					this.getGridHeaderFreeze(grid, panelId, true);
		             					 grid.columns[5].setVisible(false);
		                				 grid.columns[11].setVisible(false);
		             				}
		             			},
		             			'transfercreditgrid button[itemId=btnAdd]':{
		             				click:this.openAddTransferCredits
		             			},
		             			'transfercreditgrid button[itemId=btnEdit]':{
		             				click:this.openEditTransferCredits
		             			},
	                		 'transfercreditgrid button[itemId=btnDelete]':{
	                			 click:this.deleteTransferCredits
	                		 },
	                		 'transfercreditgrid':{
	                			 cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	                				 var $this = this;
	                				 if (e.target.tagName == 'A') {
	                					 var formWindow = $this.getTransfercreditcourseswin();
	                					 if (!formWindow) {
	                						 Ext.widget('transfercreditcourseswin');
	                						 formWindow = $this.getTransfercreditcourseswin();
	                					 }
	                					 var winGrid = formWindow.down('grid').getStore();
	                					 winGrid.loadData([]);
	                					 var dirtyData=[];
	                					 for(var i in record.data.courseDetails) {
	                						 data={
	                								 'programName':record.data.courseDetails[i].programName,
	                								 'batchName':record.data.courseDetails[i].batchName,
	                								 'periodName':record.data.courseDetails[i].periodName,
	                								 'courseName':record.data.courseDetails[i].courseName
	                						 };
	                						 dirtyData.push(data);
	                					 }
	                					 winGrid.loadData(dirtyData);
	                					 formWindow.show();
	                				 }
	                			 },
	                			 render : function(grid) {
	                				 this.addDataGridConfigButton(grid, this.getSTUDENT_TRANSFER_CREDIT_PRIVILEGES_PERMISSIONS());
	                				 
	                				 var associatedAcadLocationIds = new Array();
	                				 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                				 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getADD_TRANSFER_CREDIT_PRIVILEGES_PERMISSIONS());

	                				 var btnEdit = grid.down('#btnEdit');
	                				 btnEdit.setVisible(false);
	                				 Ext.each(permissionList, function(privilege) {
	                					 if (privilege === 'EDIT') {
	                						 if(!isNullOrEmpty(btnEdit)){
	                							 btnEdit.setVisible(true);
	                						 }        		
	                					 }
	                				 });
	                			 }
	                		 },
	             			'addtransfercreditgrid' : {
	             				/*beforerender: function(grid){
	             					var oneGradesStore = Ext.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
	             					oneGradesStore.getProxy().extraParams={
	        							whetherSpecialGrade:true
	        						}
	             					oneGradesStore.load();
	             				},*/
	            				render : function(grid) {
	            					grid.getStore().removeAll();
	            					grid.getStore().loadData([]);
	            					this.doAccessControlValidation(grid, this.getADD_TRANSFER_CREDIT_PRIVILEGES_PERMISSIONS());
	            					grid.down('#saveBtn').setVisible(true);
	            					grid.down('#saveBtn').setDisabled(true);
	            				},
	            				selectionchange: function(column, selected) {
	            					var $this=this;
	            					var grid = this.getAddtransfercreditgrid();
	            					var records=grid.getSelectionModel().getSelection();
	            					var addExternalCourseInstituteBtn = grid.down('#addExternalCourseInstitute');
	            					var saveBtn = grid.down('#saveBtn');
	            					var btnDelete = grid.down('#btnDelete');
	            					btnDelete.setDisabled(true);
	            					if(selected.length>0){
	            						addExternalCourseInstituteBtn.setDisabled(false);
	            						saveBtn.setDisabled(false);
	            					}else{
	            						addExternalCourseInstituteBtn.setDisabled(true);
	            						saveBtn.setDisabled(true);
	            					}
	            					for (var i in records) 
	            					{
	            						if(records.length==1 && getCommonTranslation(records[i].data.beforeStatus).toUpperCase()==getCommonTranslation('ENROLLED').toUpperCase()){
	            							showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('THE_TRANSFER_CREDITS_CANNOT_BE_DONE_FOR_THE_ENROLLED_COURSES'));
	            							grid.getSelectionModel().deselectAll();
	            							return false;

	            						}
	            						else if(records.length==1 && getCommonTranslation(records[i].data.beforeStatus).toUpperCase()==getCommonTranslation('COMPLETED').toUpperCase()) {
	            							btnDelete.setDisabled(false);
	            						}

	            						else if(getCommonTranslation(records[i].data.beforeStatus).toUpperCase()==getCommonTranslation('ENROLLED').toUpperCase())
	            						{
	            							saveBtn.setDisabled(true);
	            							addExternalCourseInstituteBtn.setDisabled(true);
	            						}
	            						else
	            						{
	            							btnDelete.setDisabled(true);
	            						}
	            					}
	            				}
	            			},
	                		 'tcsearchstudent' :{
	                			 render : function(form){
	                				 var forms = form.getForm();
	                				 var studentNameStore = forms.findField("studentNameSearch").getStore();
	                				 studentNameStore.getProxy().extraParams = {
	                					 restrictToAL : true
	                				 };
	                				 
	                				 var structure = form.up('addtransfercreditstructure');
	                				 if(structure.selectedRecord && !isNullOrEmpty(structure.selectedRecord)){
	                					 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                					 var studentCode= structure.selectedRecord.studentCode;
	                					 var evaluationPlanId= structure.selectedRecord.evaluationPlanId;
	                					 if(!isNullOrEmpty(studentCode) && !isNullOrEmpty(evaluationPlanId)){
	                						 studentNameStore.getProxy().extraParams={
	                							 name: studentCode
	                						 };
	                						 studentNameStore.load({
	                							 callback: function(){
	                								 if(studentNameStore.data.items.length){
	                									 forms.findField("studentNameSearch").setValue(studentNameStore.data.items[0].data.id);
	                									 /*
	                									  * form.down('#evalautionPlanNoItemId').setDisabled(false);*/
	                									 studentNameStore.data.items[0].evaluationPlanId = evaluationPlanId;
	                									 forms.findField("studentNameSearch").fireEvent('select',forms.findField("studentNameSearch"),studentNameStore.data.items[0]);
	                								 }
	                							 }
	                						 });
	                					 }
	                				 }
	                				 setTimeout(function() {
		                					var enrollmentStatus = forms.findField('enrollmentStatus');
		                					enrollmentStatus.getStore().load({
	                     					 callback: function(records, operation, success) {
	                     						 for(var i in records){
	                     							 if(records[i].data.id=="2"){
	                     								enrollmentStatus.setValue(records[i].data.id);
	                     							 }
	                     						 }
	                     					 }	   
	                     				 });
	                				 },200);
	                				 //studentNameStore.load();
	                				 /*var evalPlan = forms.findField("evalautionPlanNo").getStore();
	                				 evalPlan.getProxy().extraParams = {
	                					 restrictToTransferCredit : true,
	                					 evaluationPlanType:'ACADEMICS',
	                					 restrictToAL : true
	                				 };
	                				 evalPlan.load({
	                					 callback:function(record) {
	        	                			 if(record.length==1){
	        	                				 forms.findField("evalautionPlanNo").setValue(record[0].data.id); 
	        	                			 }
	        	                		 }
	        	                	 
	                				 });*/
	                			 }
	                		 },
	                		 /*'addtransfercreditgrid' : {
	                			 render:function(obj){
	                				 obj.getStore().removeAll();
	                				 obj.getStore().loadData([]);
	                			 }
	                		 },*/

	                		 'addtransfercreditgrid button[itemId=saveBtn]' : {
	                			 click:function(obj){
	                				 var $this=this;
	                				 $this.performSaveFunctioality();
	                			 }
	                		 }, 
	                		 'addtransfercreditgrid button[itemId=btnDelete]' : {
	                			 click:function(obj){
	                				 var $this=this;
	                				 $this.performDeleteFunctioality();
	                			 }
	                		 },
	                		 'addtransfercreditgrid button[itemId=addExternalCourseInstitute]':{
	     		    			click:function(obj){
	                				 this.openExternalcourseinstitutewin();
	                			 }
	     		    		},
	     		    		'externalcourseinstitutewin button[itemId=btnCancel]':{
	    		    			click : function() {
	    							this.getExternalcourseinstitutewin().close();
	    						}
	    		    		},
	    		    		'externalcourseinstitutewin button[itemId=btnSubmit]':{
	    		    			click:function(){
	    		    				var $this = this;
	               				    var windowForm = $this.getExternalcourseinstitutewin();
	               				    var exInstituteName = windowForm.down('#externalCourseInstituteText').getValue();
	               				    var grid = $this.getAddtransfercreditgrid();
	               				    var gridStore = grid.getStore();
	               				    var records = grid.getSelectionModel().getSelection();
	               				    for(var i in records){
	               				    	records[i].set('externalCourseInstitute', exInstituteName);
	               				    }
	               				    windowForm.close();
	    		    			}
	    		    		},
	    		    		'transfercreditfilter multiselectcombofield#multiselectAcademyLocationId': {
	    						render: function(obj) {
	                                var form = this.getTransfercreditfilter().getForm();
	                                var userId = this.getCurrentlyLoggedInUser().id;
	                                var academyLocationfield = form.findField('multiselectAcademyLocation');
	                                var multiselectAcademyLocation=this.getCurrentAcademyLocation();
	                                var store = obj.getStore();

	                                store.getProxy().extraParams = {
	                                    id: userId
	                                };
	                                store.load({
	                                    callback: function(record){
	                                        academyLocationfield.setValue([multiselectAcademyLocation]);
	                                    }
	                                });
	                            },
	                            change: function(ob, rec) {
	                                var filter = this.getTransfercreditfilter();
	                                var form = filter.getForm();
	                                var academyLocationId = form.findField('multiselectAcademyLocation').getValue();
	                                var alIds = [];
	                                var academyLocationIds;
	                                if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
	                                    for (var i in academyLocationId) {
	                                        if (Ext.isObject(academyLocationId[0])) {
	                                            alIds.push(academyLocationId[i].get("id"));
	                                        } else {
	                                            alIds.push(academyLocationId[i]);
	                                        }
	                                    }
	                                    academyLocationIds = alIds.join();
	                                } else {
	                                    alIds.push(this.getCurrentAcademyLocation());
	                                    academyLocationIds = alIds.join();
	                                }
	                                   var studentNameSearch = form.findField('studentNameSearchTC');
	                                   studentNameSearch.reset();
	    		            		   var studentNameSearchStore = studentNameSearch.getStore();
	    		            		   studentNameSearchStore.getProxy().extraParams = {
	    		            		            academyLocationIds  : academyLocationIds
	                                     };
	    		            		   studentNameSearchStore.load();
	    		            		        
	                            },
	    		    		},
	                		 'tcsearchstudent customcombobox#studentNameSearch' : {
	                			 select:function(obj,record){
	                				 var $this = this;
	                				 var form = obj.up('form').getForm();
	                				 var evalautionPlanNo = form.findField('evalautionPlanNo');
	                				 var studentField = form.findField('studentNameSearch');
	                				 var hiddenBatchId = form.findField('batchId');
	                				 if(studentField.valueModels[0] != undefined){
	                					 var admissionCode = studentField.valueModels[0].data.code;
	                					 var idx = studentField.valueModels[0].data.value.lastIndexOf('/');
	                					 var studentName = studentField.valueModels[0].data.value.substring(idx+2);
	                					 Ext.Ajax.request({
		        	                		 type: 'rest',
		        	                		 url: SERVERURL.PATH_FIND_STUDENT_CURRENT_PROGRAM_MARK_GRADE,
		        	                		 method: 'GET',
		        	                		 params:{
		        	                			 admissionCode:admissionCode,
		        	                			 studentName:studentName
		        	                		 },
		        	                		 success: function(f, action) {

		        	                			 if (!isNullOrEmpty(f.responseText)) {
		        	                				 evalautionPlanNo.setDisabled(false);
		        	                				 form.isValid();
		        	                				 var data = f.responseText;
		        	                				 var jData=Ext.JSON.decode(data);
		        	                				 var markGradeType = jData.value == 'G' ?'GRADE' : 'MARK';
		        	                				 hiddenBatchId.setValue(jData.id);
		        	                				 var evalautionPlanStore = evalautionPlanNo.getStore();
		        	                				 evalautionPlanStore.getProxy().extraParams = {
		        	                					 restrictToTransferCredit : true,
		        	                					 evaluationPlanType:'ACADEMICS',
		        	                					 restrictToAL : true,
		        	                					 markGradeType : markGradeType
		        	                					 
		        	                				 };
		        	                				 evalautionPlanStore.load({
		        	                					 callback:function(records) {
		        	                						 if(record.evaluationPlanId && !isNullOrEmpty(record.evaluationPlanId)){
		        	                							 form.findField("evalautionPlanNo").setValue(record.evaluationPlanId); 
		        	                							 var searchBtn = obj.up('form').down('#studentEnrolmntDetailTabSearchBtn');
		        	                							 setTimeout(function(){
		        	                								 searchBtn.fireEvent('click', searchBtn);
		        	                								 Ext.getBody().unmask();
		        	                							 },300);
		        	                						 }
		        	                						 else if(records.length==1){
		        	        	                				 form.findField("evalautionPlanNo").setValue(records[0].data.id); 
		        	        	                			 }
		        	        	                		 }
		        	        	                	 
		        	                				 });
		        	                				 var periodComboBox = form.findField('programWisePeriod');
		        	                				 periodComboBox.setDisabled(false);
		        	                				 var periodStore = periodComboBox.getStore();
		        	                				 periodStore.getProxy().extraParams = {
		        	                					 id : jData.id
		        	                				 };
		        	                				 periodStore.load({
		        	                					 callback:function(record) {
		        	        	                			 if(record.length==1){
		        	        	                				 form.findField("programWisePeriod").setValue(record[0].data.id); 
		        	        	                			 }
		        	        	                		 }
		        	        	                	 
		        	                				 });
		        	                				 
		        	                			 }
		        	                		 },
		        	                		 failure: function(result, request) {
		        	                			 showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
		        	                			 return false;
		        	                		 }
		        	                	 });
	                				 }
	                				 
	                			 }
	                		 },
	                		 'tcsearchstudent button[itemId=studentEnrolmntDetailTabSearchBtn]' : {
	                			 click:function(obj){
	                				 this.getAddtransfercreditstructure().down('#saveBtn').setDisabled(false);
	                				 var $this=this;
	                				 var form = obj.up('form').getForm();
	                				 var treePanel=Ext.ComponentQuery.query('treepanel#transfercreditflyout')[0];
	                				 var studentField = form.findField('studentNameSearch');
	                				 var evaluationPlanId = form.findField('evalautionPlanNo').getValue();
	                				 var batchId = form.findField('batchId').getValue();
	                				 var enrollmentStatus=form.findField('enrollmentStatus').getRawValue().toUpperCase();
	                				 if(studentField.valueModels[0] != undefined){
	                					 var admissionCode = studentField.valueModels[0].data.code;
	                					 var idx = studentField.valueModels[0].data.value.lastIndexOf('/');
	                					 var studentName = studentField.valueModels[0].data.value.substring(idx+2);
	                					 var admissionId = studentField.valueModels[0].data.secondId;
	                					 var grid = $this.getAddtransfercreditgrid();
	                					 grid.transferCreditStore.load();
	                					 grid.down('#saveBtn').setDisabled(true);
	                					 grid.getStore().removeAll();
	                					 Ext.Ajax.request({
	                						 type: 'rest',
	                						 url: SERVERURL.PATH_FIND_WHETHER_EVALUATION_PLAN_SELECTED,
	                						 method: 'GET',
	                						 params:{
	                							 admissionId:admissionId,
	                							 evaluationPlanId:evaluationPlanId,
	                							 batchId:batchId
	                						 },
	                						 success: function(f, action) {
	                							 var resp=f.responseText;
	                							 var jData = Ext.JSON.decode(resp);
	                							 if(jData.activeStatus == true){
	                								 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),'The transfer credits for '+
	                										 studentName+ ' is already saved for ' +jData.value+'.');
	                								 return false;
	                							 } else{
	                								 Ext.Ajax.request({
	        	                						 type: 'rest',
	        	                						 url: SERVERURL.PLACEMENT_PROGRAM_STORE,
	        	                						 method: 'GET',
	        	                						 params:{
	        	                							 studentId:studentField.valueModels[0].data.id,
	        	                							 onlyCurrentRecords:true
	        	                						 },
	        	                						 success: function(f, action) {
	        	                							 var resp=f.responseText;
	        	                							 var jData = Ext.JSON.decode(resp)[0];
	        	                							 var gridPeriodId = jData.periodId;
	        	                							 var gridProgramId = jData.programId;
	        	                							 $this.validateTCStudent(grid,admissionCode,studentName,gridPeriodId,gridProgramId, jData,enrollmentStatus);
	        	                							 }
	        	                					 });
	                							 }
	                							 }
	                					 });
	                				 }
	                			 }
	                		 },
	                		 'transfercreditfilter' : {
	                			 render:function(obj){
	                				 var $this=this;
	                				 var form=$this.getTransfercreditfilter().getForm();
	                				 var program = form.findField("programId").getStore();
	                				 var programCategoryStore = form.findField("programCategory").getStore();
	                				 var arr = [];
	                				 arr.push($this.getCurrentAcademyLocation());
	                				 program.getProxy().extraParams={
	                					 programName:null,
	                					 academyLocationIds:arr.join(),
	                				 };
	                				 program.load();
	                				 if(!isNullOrEmpty(programCategoryStore)){
	                				 programCategoryStore.load();
	                				 }
	                			 }
	                		 },
	                		 'transfercreditfilter customcombobox#programGroupItemId':{
	                			 select:function(obj,record){
	                				 var $this = this;
	                				 var form = obj.up('form').getForm();
	                				 var program = form.findField('programId');
	                				 var programCategory = form.findField('programCategory');
	                				 programCategory.reset();
	                				 var arr = [];
	                				 arr.push($this.getCurrentAcademyLocation());
	                				 program.reset();
	                				 program.getStore().getProxy().extraParams={
	                					 programGroupId:record[0].data.id,
	                					 academyLocationIds:arr.join(),
	                				 };
	                				 program.getStore().load();
	                			 }
	                		 },

	                		 'transfercreditfilter customcombobox#programCategoryId':{
	                			 select:function(obj,record){
	                				 var $this = this;
	                				 var form = obj.up('form').getForm();
	                				 var program = form.findField('programId');
	                				 var arr = [];
	                				 arr.push($this.getCurrentAcademyLocation());
	                				 program.reset();
	                				 program.getStore().getProxy().extraParams={
	                					 programGroupId:form.findField('programGroup').getValue(),
	                					 programCategoryId:record[0].data.id,
	                					 academyLocationIds:arr.join(),
	                				 };
	                				 program.getStore().load();
	                			 }
	                		 },

	                		 'transfercreditfilter customcombobox#programId' : {
	                			 select:function(obj, rec){
	                				 var programId=rec[0].data.id;
	                				 var form=this.getTransfercreditfilter().getForm();
	                				 var batchId = form.findField("batchId").getStore();
	                				 var periodID = form.findField("periodId");
	                				 periodID.reset();
	                				 form.findField("batchId").reset();
	                				 form.findField("batchId").setDisabled(false);
	                				 //   var academyLocationIds = this.getAcademyLocationIds();
	                				 batchId.getProxy().extraParams={
	                					 //  academyLocationIds:academyLocationIds,
	                					 id:programId,
	                				 };
	                				 batchId.load();
	                			 }
	                		 },

	                		 'transfercreditfilter customcombobox#batchId' : {
	                			 select:function(obj, rec){
	                				 var batchId=rec[0].data.id;
	                				 var form=this.getTransfercreditfilter().getForm();
	                				 var periodID = form.findField("periodId").getStore();
	                				 form.findField("periodId").reset();
	                				 form.findField("periodId").setDisabled(false);
	                				 periodID.getProxy().extraParams={
	                					 id:batchId,
	                				 };
	                				 periodID.load();
	                			 }
	                		 },
	                		 'transfercreditfilter button[itemId=spclResetBtn]' : {
	                			 click : function() {
	                				 var form=this.getTransfercreditfilter().getForm();
	     							 var multiSelectAL = form.findField('multiselectAcademyLocation');
	     							 var userId = this.getCurrentlyLoggedInUser().id;
	                				 form.reset();
	                				 form.findField("batchId").setDisabled(true)
	                				 form.findField("periodId").setDisabled(true);
	                				 var program = form.findField("programId").getStore();
	                				 var arr = [];
	                				 arr.push(this.getCurrentAcademyLocation());
	                				 program.getProxy().extraParams={
	                					 programName:null,
	                					 academyLocationIds:arr.join(),
	                				 };
	                				 program.load();
	                				 var multiselectAcademyLocation=this.getCurrentAcademyLocation();
	 	                            var store = multiSelectAL.getStore();

	 	                            store.getProxy().extraParams = {
	 	                                id: userId
	 	                            };
	 	                            store.load({
	 	                                callback: function(record){
	 	                                	multiSelectAL.setValue([multiselectAcademyLocation]);
	 	                                }
	 	                            });
	                			 }
	                		 },
	                		 'transfercreditfilter button[itemId=spclSearchBtn]' : {
	                			 click : function() {
	                				 this.loadTransferCreditFilter();
	                			 }
	                		 },

	                		 'tcsearchstudent button[itemId=studentEnrolmntDetailTabResetBtn]' : {
	                			 click : function() {
	                				 var $this=this;
	                				 var form=$this.getTcsearchstudent().getForm();
	                				 var studentName = form.findField("studentNameSearch");
	                				 studentName.reset();
	                				 var evalPlan = form.findField("evalautionPlanNo");
	                				 evalPlan.reset();
	                				 evalPlan.setDisabled(true);
	                				 var periodCombo = form.findField('programWisePeriod');
	                				 periodCombo.reset();
	                				 periodCombo.setValue('');
	                				 periodCombo.setDisabled(true);
	                				 var enrollmentStatus = form.findField('enrollmentStatus');
	                				 enrollmentStatus.reset();
	                				 setTimeout(function() {
		                					enrollmentStatus.getStore().load({
	                     					 callback: function(records, operation, success) {
	                     						 for(var i in records){
	                     							 if(records[i].data.id=="2"){
	                     								enrollmentStatus.setValue(records[i].data.id);
	                     							 }
	                     						 }
	                     					 }	   
	                     				 });
	                				 },200);
	                				 var grid = $this.getAddtransfercreditgrid();
	                				 grid.getSelectionModel().deselectAll();
                    				 grid.getStore().removeAll();
	                			 }
	                		 },
	                	 });
	                 },

	                 openAddTransferCredits:function(){
	                	 var me = this;
	                	 var contentpanel = me.getContentPanel();
	                	 var tabName = getCommonTranslation('ADD_TRANSFER_CREDITS');
	                	 var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	 var contentXtype ='addtransfercreditstructure';
	                	 var newTab = this.getTabReferenceByTabTitle(tabName);
	                	 var getTab=getcontroller.getTab(tabName);
	                	 if(getTab!=null){
	                		 contentpanel.remove(getTab, true);
	                	 }
	                	 if(!newTab){
	                		 newTab = contentPanel.add({
	                			 xtype: contentXtype,
	                			 closable: true,
	                			 title: tabName,
	                			 menuColorCls: CONSTANTS.MENU_COLOR_THREE
	                		 });
	                	 }
	                	 contentPanel.setActiveTab(newTab);
	                 },
	                 
	                 openEditTransferCredits: function(btn){
	                	 var me = this;
	                	 var grid = btn.up('grid');
	                	 var selectedRecord = grid.getSelectionModel().getSelection();
	                	 if(selectedRecord.length){
	                		 
	                		 var selectedRecordALId = selectedRecord[0].data.academyLocationId;
	                		 var isActive = selectedRecord[0].data.isActive;
	                		 
	                		 if(!isActive){
	                			 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('CANNOT_EDIT_INACTIVE_ANOTHER_AL_RECORD_MSG'));
	                			 return false;
	                		 }
	                		 
	                		 if(me.getCurrentAcademyLocation() != selectedRecordALId){
	                			 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('CANNOT_EDIT_INACTIVE_ANOTHER_AL_RECORD_MSG'));
	                			 return false;
	                		 }
	                		 
	                		 var contentpanel = me.getContentPanel();
		                	 var tabName = getCommonTranslation('ADD_TRANSFER_CREDITS');
		                	 var getcontroller=this.getController('menu.CoreERPNavigationController');
		                	 var contentXtype ='addtransfercreditstructure';
		                	 var newTab = this.getTabReferenceByTabTitle(tabName);
		                	 var getTab=getcontroller.getTab(tabName);
		                	 if(getTab!=null){
		                		 contentpanel.remove(getTab, true);
		                	 }
		                	 if(!newTab){
		                		 newTab = contentPanel.add({
		                			 xtype: contentXtype,
		                			 closable: true,
		                			 title: tabName,
		                			 menuColorCls: CONSTANTS.MENU_COLOR_THREE,
		                			 selectedRecord:{
		                				 studentCode: selectedRecord[0].data.studentCode,
		                				 evaluationPlanId: selectedRecord[0].data.evaluationPlanId
		                			 }
		                		 });
		                	 }
		                	 contentPanel.setActiveTab(newTab);
	                	 }
	                	 else{
	                		 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 },
	                 deleteTransferCredits : function(){
	                	 var $this = this; 
	                	 var grid = this.getTransfercreditgrid();
	                	 var grdStore = grid.getStore();  
	                	 if(grid.getSelectionModel().getCount()>0){
	                		 showConfirmMessage(getCommonTranslation('TRANSFER_CREDITS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			 if (btn == 'yes') {
	                				 var records=grid.getSelectionModel().getSelection();						        
	                				 var id=records[0].get("admissionId");
	                				 var courseVariantId=records[0].get("courseVariantId");
	                				 var periodId=records[0].get("periodId");
	                				 var evaluationPlanId=records[0].get("evaluationPlanId");
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url: SERVERURL.DELETE_TRANSFER_CREDIT+'?id='+id+'&courseVariantId='+courseVariantId+'&periodId='+periodId,
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success:function(response){
	                						 var MSSG = response.responseText;
	                						 if(MSSG=="DEPENDENT_RECORD_EXISTS"){
	                							 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCourseTxCommonTranslation('DEPENDENCY_EXIST'));
	                						 }else{
	                							 grdStore.reload();
	                							 showSuccessMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('SUCCESS'));//Section deleted successfully

	                						 }}
	                				 });
	                			 }
	                		 });
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
	                	 }
	                 },

	                 validateTCStudent:function(grid,admissionCode,studentName,periodId,programId,jData,enrollmentStatus){
	                	 var $this = this;

	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: SERVERURL.STUDENT_EXIST_OR_NOT_URL,
	                		 method: 'GET',
	                		 params:{
	                			 studentId:admissionCode,
	                			 studentName:studentName,
	                			 periodId:periodId,
	                			 programId:programId
	                		 },
	                		 success: function(f, action) {
	                			 var resp=f.responseText;
	                			 if(resp!=null&&resp>0){

	                				 $this.searchTCStudent(grid,admissionCode,studentName,jData,enrollmentStatus);


	                			 }else{
	                				 showWarningMessage(getCourseTxCommonTranslation('SEARCH_RESULT'), getCourseTxCommonTranslation('STUDENT_EXIST_MSG'));
	                			 }
	                		 }
	                	 });
	                 },

	                 setTCStudentDetailsFlyOut:function(grid,records,admissionCode,jData, jsonData,enrollmentStatus){
	                	 var $this = this;
	                	 var form = $this.getTcsearchstudent().getForm();
	                	 var evalPlan = form.findField('evalautionPlanNo');
	                	 var admissionId = records.data.admissionId;
	                	 var batchId = records.data.batchId;
	                	 var periodId = jData.periodId;
	                	 var sectionId = jData.sectionId;
	                	 var periodComboVal = form.findField('programWisePeriod').getValue();
	                	 var periodIds = null;
	                	 var periodIdArr = [];
	                	 if(!isNullOrEmpty(periodComboVal)) {
								for(var i in periodComboVal){
									if(typeof periodComboVal[i]=="number"){
										periodIdArr.push(periodComboVal[i]);
									}else if(!isNullOrEmpty(periodComboVal[i].data)){
										periodIdArr.push(periodComboVal[i].data.id);
									}
								}
							}
	                	 periodIds = periodIdArr.join();
	                	 $this.resetGridSetting(grid);
	                	 grid.getStore().getProxy().extraParams={
	                		 batchId:batchId,
	                		 admissionId:admissionId,
	                		 periodIds:periodIds,
	                		 enrollmentStatus:enrollmentStatus
	                	 };
	                	 grid.getSelectionModel().deselectAll();
	                	 grid.getStore().load({
	                		 callback:function(record) {
	                			 if(evalPlan.valueModels[0].data.code == "MARK") {
	                				 grid.columns[6].setVisible(false);
	                				 grid.columns[5].setVisible(true);
	                				 grid.columns[10].setVisible(false);
	                				 grid.columns[11].setVisible(true);
	                			 } else {
	                				 grid.columns[6].setVisible(true);
	                				 grid.columns[5].setVisible(false);
	                				 grid.columns[10].setVisible(true);
	                				 grid.columns[11].setVisible(false);
	                			 }
	                		 }
	                	 });
	                	 var form = this.getTcstudentflyout();
	                	 if (form.collapsed) {
	                		 form.expand();
	                	 }
	                	 var detailsForm = form.getForm();

	                	 //Display Student Image on Fly Out
	                	 form.down("#profile_imageTCF").setVisible(true);
	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 binary: true,
	                		 url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+records.data.personId,
	                		 method: 'GET',
	                		 success : function(response){
	                			 if(response.responseBytes.length>0){
	                				 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
	                				 var url = window.URL.createObjectURL(blob);
	                				 var image = form.down("#profile_imageTCF");
	                				 image.getEl().dom.src=url;
	                			 }
	                		 }

	                	 });

	                	 detailsForm.findField('studentId').setValue(records.data.studentCode);
	                	 detailsForm.findField('studentName').setValue(records.data.studentName);


	                	 detailsForm.findField('programId').setValue(records.data.batchName);
	                	 detailsForm.findField('programName').setValue(records.data.programShortName);
	                	 detailsForm.findField('batchName').setValue(records.data.batchName);
	                	 detailsForm.findField('admissionCode').setValue(admissionCode);//records[0].data.admissionId);
	                	 detailsForm.findField('admissionId').setValue(records.data.admissionId);
	                	 detailsForm.findField('batchId').setValue(records.data.batchId);

	                	 detailsForm.findField('periodId').setValue(jData.periodId);
	                	 detailsForm.findField('periodName').setValue(jData.periodName);
	                	 detailsForm.findField('sectionId').setValue(jData.sectionId);
	                	 detailsForm.findField('sectionName').setValue(jData.sectionCode);
	                	 detailsForm.findField('periodDuration').setValue( /*'<b>'+getCourseTxCommonTranslation('PERIOD_DURATION +' : */'<b> '+ getCourseTxCommonTranslation('FROM')+' </b>'+dateRender(jData.periodStart)+'<b>  '+getCourseTxCommonTranslation('TO')+' </b> '+dateRender(jData.periodEnd));

	                	 detailsForm.findField('enrollmentLastDate').setValue(dateRender(jData.enrollmentLastDate));
	                	 detailsForm.findField('periodMinCourses').setValue(jData.periodMinCourses);
	                	 detailsForm.findField('periodMaxCourses').setValue(jData.periodMaxCourses);
	                	 detailsForm.findField('periodMinCredits').setValue(jData.periodMinCredits);
	                	 detailsForm.findField('periodMaxCredits').setValue(jData.periodMaxCredits);
	                	 detailsForm.findField('totalNoOfoptedCourses').setValue(jData.totalNoOfoptedCourses);
	                	 detailsForm.findField('creditsEarned').setValue(jData.creditsEarned);
	                	 detailsForm.findField('totalNoOfAuditCourses').setValue(jData.totalNoOfAuditCourses);
	                	 detailsForm.findField('periodMinCreditsTobeEarned').setValue(jData.periodMinCreditsTobeEarned);
	                	 detailsForm.findField('periodMaxCreditsThatCanbeEarned').setValue(jData.periodMaxCreditsThatCanbeEarned);
	                	 detailsForm.findField('periodNoOfCoursesThatCanbeOpted').setValue(jData.periodNoOfCoursesThatCanbeOpted);
	                	 detailsForm.findField('noOfPeriodsRemaining').setValue(jData.noOfPeriodsRemaining);
	                	 detailsForm.findField('minNoOfCoursesRemaining').setValue(jData.minNoOfCoursesRemaining);
	                	 detailsForm.findField('minCreditsToBeEarnedForProgram').setValue(jData.minCreditsToBeEarnedForProgram);
	                 },

	                 searchTCStudent:function(grid,admissionCode,studentName, jsonData,enrollmentStatus){
	                	 var $this=this;
	                	 if(!isNullOrEmpty(admissionCode)){
	                		 var store = this.getStore('coursetransaction.studentenrollment.studentenrollmentdetail.StudentSearchProgamCombo');
	                		 store.getProxy().extraParams = {
	                			 studentId:admissionCode,
	                			 studentName:studentName,
	                		 };
	                		 store.load({
	                			 callback: function(records, operation, success) {
	                				 if (records.length>0) {
	                					 $this.loadTCPeriodDetail(grid,records[0],admissionCode, jsonData,enrollmentStatus);
	                				 }
	                			 }
	                		 });     
	                	 }
	                 },

	                 loadTCPeriodDetail:function(grid,record,admissionCode, jsonData,enrollmentStatus){
	                	 var $this=this;
	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: SERVERURL.STUDENT_ENROLLMENT_DETAILTAB_PERIOD_DETAILS_URL,
	                		 method: 'GET',
	                		 params:{
	                			 admissionId:record.data.admissionId,
	                			 batchId:record.data.batchId
	                		 },
	                		 success: function(f, action) {

	                			 if (!isNullOrEmpty(f.responseText)) {
	                				 var data = f.responseText;
	                				 var jData=Ext.JSON.decode(data);

	                				 /**
	                				  * setStudentDetailsFlyOut function is using to set data in flyout;
	                				  */
	                				 $this.setTCStudentDetailsFlyOut(grid,record,admissionCode,jData, jsonData,enrollmentStatus);
	                			 }else{
	                				 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('STUDENT_NOT_AVAILABLE_FOR_ENROLLMENT'));
	                			 }
	                		 },
	                		 failure: function(result, request) {
	                			 showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
	                			 return false;
	                		 }
	                	 });
	                 },

	                 performSaveFunctioality:function(){
	                	 var $this = this;
	                	 var grid = $this.getAddtransfercreditgrid();
	                	 var batchId = grid.getStore().getProxy().extraParams.batchId;
	                	 var records = grid.getSelectionModel().getSelection();
	                	 var $this = this;
	                	 var form = $this.getTcsearchstudent().getForm();
	                	 var evalPlan = form.findField('evalautionPlanNo');
	                	 var jSon=[];
	                	 var completed=false;
	                	 var enrolled=false;
	                	 if(records.length>0){
	                		 if(isNullOrEmpty(evalPlan.valueModels[0].data.code)){
	                			 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS')
	                					 ,getCommonTranslation('Event not created in selected assessment scheme'));
		                		 return false;
	                		 }
	                		 for (var i in records) {
	                			 if((evalPlan.valueModels[0].data.code == "MARK" && records[i].data.courseMarksGrades=='G')){
            						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation("THE_SELECTED_ASSESSMENT_SCHEMES_EVENT_SHOULD_BE_OF_GRADE_TYPE_TO_SAVE_THE_TRANSFER_CREDITS"));
        							 return false;
            					 }else if((evalPlan.valueModels[0].data.code == "GRADE" && records[i].data.courseMarksGrades=='M')){
            						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation("THE_SELECTED_ASSESSMENT_SCHEMES_EVENT_SHOULD_BE_OF_MARKS_TYPE_TO_SAVE_THE_TRANSFER_CREDITS"));
        							 return false;
            					 }
	                		 }
	                		 for (var i in records) {
	                			 if(evalPlan.valueModels[0].data.code == "MARK" && !isNullOrEmpty(records[i].data.marksObtained)) {
            						 if(parseFloat(records[i].data.marksObtained)<=parseFloat(records[i].data.courseMaxMark)){
            							 jSon.push({
            								 "courseId": records[i].data.courseId,
            								 "periodId": records[i].data.periodId,
            								 "courseVariantId" :  records[i].data.courseVariantId,
            								 "admissionId":records[i].data.admissionId,
            								 "whetherOptional":records[i].data.whetherOptional,
            								 "marksObtained":(records[i].data.marksObtained).toString(),
            								 "sectionId": records[i].data.sectionId,
            								 "courseGradeType":records[i].data.sectionType,
            								 "status":records[i].data.status.toUpperCase(),
            								 "evaluationPlanId":evalPlan.getValue(),
            								 "id":records[i].data.id,
            								 "batchId":batchId,
            								 //"externalCoursePeriodId":records[i].data.externalCoursePeriodId,
            								 "externalCourseCode":records[i].data.externalCourseCode,
            								 "externalCourseName":records[i].data.externalCourseName,
            								 "externalCourseInstitute":records[i].data.externalCourseInstitute,
            								 "externalCourseMarks":records[i].data.externalCourseMarks,
            								 "creditTypeId":(grid.transferCreditStore.findExact('value',records[i].data.creditTypeId) != -1) ? grid.transferCreditStore.getAt(grid.transferCreditStore.findExact('value',records[i].data.creditTypeId)).data.id : records[i].data.creditTypeId,
            								 "completionDate":records[i].data.completionDate
            							 });
            						 } else {
            							 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('TRANSFER_MARK_ALERT_MSG'));
            							 return false;
            						 }
            					 }else if(evalPlan.valueModels[0].data.code == "GRADE" && !isNullOrEmpty(records[i].data.gradeObtained)){
            						 jSon.push({
            							 "courseId": records[i].data.courseId,
            							 "periodId": records[i].data.periodId,
            							 "courseVariantId" :  records[i].data.courseVariantId,
            							 "admissionId":records[i].data.admissionId,
            							 "whetherOptional":records[i].data.whetherOptional,
            							 "marksObtained":(records[i].data.gradeObtained).toString(),
            							 "sectionId": records[i].data.sectionId,
            							 "courseGradeType":records[i].data.sectionType,
            							 "status":records[i].data.status.toUpperCase(),
            							 "evaluationPlanId":evalPlan.getValue(),
            							 "id":records[i].data.id,
            							 "batchId":batchId,
            							 "gradePoints":records[i].data.gradePoints,
            							 //"externalCoursePeriodId":records[i].data.externalCoursePeriodId,
        								 "externalCourseCode":records[i].data.externalCourseCode,
        								 "externalCourseName":records[i].data.externalCourseName,
        								 "externalCourseInstitute":records[i].data.externalCourseInstitute,
        								 "externalCourseGrade":records[i].data.externalCourseGrade,
        								 "creditTypeId":(grid.transferCreditStore.findExact('value',records[i].data.creditTypeId) != -1) ? grid.transferCreditStore.getAt(grid.transferCreditStore.findExact('value',records[i].data.creditTypeId)).data.id : records[i].data.creditTypeId,
										 "creditMarks":(records[i].data.marksObtained),
										 "completionDate":records[i].data.completionDate
            						 });
            					 } else {
            						 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('TRANSFER_CREDITS_MARKS_GRADE_VALIDATION'));
            						 return false;
            					 }
	                		 }
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                		 return false;
	                	 }
	                	 /*if(enrolled || completed){
	                		 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('THE_TRANSFER_CREDITS_CANNOT_BE_DONE_FOR_THE_ENROLLED_AND_COMPLETED_STATUS_COURSES'));
	                		 return false;
	                	 }*/
	                	 if(!isNullOrEmpty(jSon) && jSon.length>0) {
	                		 showConfirmMessage(getCommonTranslation('TRANSFER_CREDITS'), getCommonTranslation('TRANSFER_CREDITS_SUCCESSFULL_MSG'), function(
	                					btn, text) {
	                				if (btn == 'yes') {
	                		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                		 var submitUrl=SERVERURL.PATH_SAVE_STUDENT_FOR_TRANSFER_CREDITS;
	                		 Ext.Ajax.request({
	                			 type : 'rest',
	                			 url : submitUrl,
	                			 jsonData : jSon,
	                			 method : 'POST',
	                			 timeout: 9000000,
	                			 success : function(form, action) {
	                				 Ext.getBody().unmask();
	                				 if(form.responseText.toLowerCase() == getCommonTranslation('ENQUIRY_SUCCESS').toLowerCase()){
	                					 showSuccessMessage(getCommonTranslation('ADD_TRANSFER_CREDITS'),getCommonTranslation('SUCCESS'));
	                				 } else {
	                					 showWarningMessage(getCommonTranslation('ALERT'),"Duplicate record for <br/>"+form.responseText+"Remaining selected records are successfully created.");
	                				 }
	                				 grid.getSelectionModel().deselectAll();
	                				 grid.getStore().load();
	                			 },
								failure: function(form, action) {
										showWarningMessage(getCommonTranslation('ALERT'),"Duplicate record for <br/>"+form.responseText+"Remaining selected records are successfully created.");
								}
	                		 });
	                	 }
	         		});
	                	 } /*else {
	                		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation ("TRANSFER_CREDITS_ALERT_MSG"));
	                	 }*/
	                 },
	                 performDeleteFunctioality:function(){ 
	                	 var $this = this; 
	                	 var grid = $this.getAddtransfercreditgrid();
	                	 var grdStore = grid.getStore();  
	                	 if(grid.getSelectionModel().getCount()>0){
	                		 showConfirmMessage(getCommonTranslation('TRANSFER_CREDITS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			 if (btn == 'yes') {
	                				 var records=grid.getSelectionModel().getSelection();						        
	                				 var id=records[0].get("admissionId");
	                				 var courseVariantId=records[0].get("courseVariantId");
	                				 var periodId=records[0].get("periodId");
	                				 var evaluationPlanId=records[0].get("evaluationPlanId");
	                				 var sectionId=records[0].get("sectionId");
	                				 var courseId=records[0].get("courseId");
	                				 var isSingleRecord = true;
	                				 
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url: SERVERURL.DELETE_TRANSFER_CREDIT+'?id='+id+'&courseVariantId='+courseVariantId+'&courseId='+courseId+'&sectionId='+sectionId+'&periodId='+periodId+'&isSingleRecord='+isSingleRecord,
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success:function(response){
	                						 var MSSG = response.responseText;
	                						 if(MSSG=="DEPENDENT_RECORD_EXISTS"){
	                							 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCourseTxCommonTranslation('DEPENDENCY_EXIST'));
	                						 }else{
	                							 grdStore.reload();
	                							 showSuccessMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('SUCCESS'));//Section deleted successfully

	                						 }}
	                				 });
	                			 }
	                		 });
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('TRANSFER_CREDITS'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
	                	 }

	                 },

	                 loadTransferCreditFilter:function(){
	                	 var $this=this;
	                	 var form = $this.getTransfercreditfilter();
	                	 form.down('#spclSearchBtn').setDisabled(true);
	                	 var programGroupValue = form.down("#programGroupItemId").getValue();
	                	 var programCategoryValue = form.down("#programCategoryId").getValue();
	                	 var programValue = form.down("#programId").getValue();
	                	 var batchValue = form.down("#batchId").getValue();
	                	 var periodValue = form.down("#periodId").getValue();
	                	 var alIds = form.down("#multiselectAcademyLocationId").getValue();
	                	 var studentId = form.down("#studentNameSearchTCId").getValue();
	 		   			var alIdArr=[];
	 	 				var alIdVal = alIds;
	 	 				var alIdVals = null;
	 	 				if (!isNullOrEmpty(alIdVal) && alIdVal.length > 0 && !isNullOrEmpty(alIdVal[0])) {
	 						for (var i in alIdVal) {
	 							if (Ext.isObject(alIdVal[0])) {
	 								alIdArr.push(alIdVal[i].get("id"));
	 							} else {
	 								alIdArr.push(alIdVal[i]);
	 							}
	 						}
	 						alIdVals = alIdArr.join();
	 	 				}

	                	 var grid = $this.getTransfercreditgrid();
	                	 var values = form.getForm().getValues();
	                	 grid.getStore().getProxy().extraParams = {
	                		 programGroupId: programGroupValue,
	                		 programCategoryId:programCategoryValue,
	                		 programId:programValue,
	                		 batchId:batchValue,
	                		 periodId:periodValue,
	                		 academyLocationId:alIdVals,
	                		 admissionId:studentId
	                		 
	                	 };
	                	 grid.getStore().load({
        					 callback:function(record) {
        						 form.down('#spclSearchBtn').setDisabled(false); 
	                		 }
        				 });
	                	 grid.config.searchFilterForm = form;
	                 },
	                 
	                 openExternalcourseinstitutewin:function(obj){
	              		var $this = this;
	              		var grid = $this.getAddtransfercreditgrid();
	     	    	  if (grid.getSelectionModel().getCount() > 0 ) {
	     	    		  var record = grid.getSelectionModel().getSelection();
	     	    		  var formWindow = $this.getExternalcourseinstitutewin();
	     	    		  if (!formWindow) {
	     	    			  Ext.widget('externalcourseinstitutewin');
	     	    			  formWindow = $this.getExternalcourseinstitutewin();
	     	    			  //formWindow.down('#id').setValue(record[0].data.registrationSetupId);
	     	    		  }
	     	    		  formWindow.show();
	     	    		  //this.getSessionDetails(record);
	     	    	  } else{
	     	    		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	     	    	  }

	     	      },

});