/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.controller.programCourseDashboard.DashboardController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	models : ['programCourseDashboard.MostAndLeastPopularCoursesPBS','programCourseDashboard.CourseAttendanceGridModel'],
	stores : ['common.AcademyStore','common.AcademyLocationByAcademyId','programCourseDashboard.StastisticsData',
	          'scholarships.LogedInUserAcademyLocationStore','common.ProgramsByAcademyLocationsIds',
	          'enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','department.ParentDepartmentStore','department.ChildDepartmentStore',
	          'department.DepartmentAcademyLocationWiseStore','department.ChildDepartmentStore',
	          'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore','attendance.CoursesByAcademyLocationIds',
	          'programCourseDashboard.MostAndLeastPopularCoursesPBS','programCourseDashboard.MostAndLeastPopularCoursesCBS',
	          'coursetransaction.sectionmanagement.SectionsStore','attendance.SectionByCourseNComponent','common.AccessibleProgByCourseAndALsIdStore',
	          'programCourseDashboard.ProgramVacantSeatsChartStore','coursetracker.CourseTrackerChart','common.AllAccessibleCVByperiodAndCourseId',
	          'programCourseDashboard.ProgramVacantSeatsBatchStore','coursetransaction.coursereading.CourseByPeriod',
	          'attendance.CourseLevelAttendanceCourses','programCourseDashboard.FacultyUtilizationGridStore',
	          'programCourseDashboard.ProgramDashboardTreeStore', 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
	          'programCourseDashboard.FacultyWorkloadCourseStr','programCourseDashboard.FacultyWorkloadSessionStr',
	          'common.ActiveUserStore','examinationcenters.dashboard.CourseByMultipleAcdemyLocation','coursetransaction.facultytopicassignment.AssignFacultyStore',
			  'program.programDetails.programBatches.courseParameter.ProgramCourseByCourseIdStore','common.BatchesByProgramId',
			  'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','programCourseDashboard.CourseRosterReportStore',
			  'programCourseDashboard.CourseAttendanceGridStore','common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			  'attendance.SectionAndFacultyByPeriodID','coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo',
			  'coursetransaction.promotion.PromotionStatus','common.ProgramByAcademyLocationStore','programCourseDashboard.ProgramPromotionStore','programCourseDashboard.CoursesByBatchStore',
			  'common.IntakeYearStore','common.AcademicTermStore','attendance.AssignedCoursesFacultyStore',
			  'common.AssignedProgramStore','setup.templatemapping.TemplateNameForFoils','program.ProgramGroupStore',
			  'program.ProgramByGroupIdStore','programCourseDashboard.StudentCourseEnrollmentReportStore',
			  'feeandpayment.reports.Student','common.AcademicTermStoreForIntakeYearId','coursetransaction.sectionmanagement.SectionGroup',
			  'programCourseDashboard.CoursesBySectionGroupIdStore','programCourseDashboard.CourseAttendanceBySectionGroupGridStore',
			  'programCourseDashboard.ProgramsBySectionGroupIdStore',
			  'feeandpayment.reports.Student','common.AcademicTermStoreForIntakeYearId','common.ClassTeacherProgramStore',
			  'enquiry.AcademicBatchForSectionGroupStore','common.CurrentBatchStore',
			  'common.BatchIntakeYearStore','coursetransaction.promotion.PromotionStatusWithoutPending','messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore',
			  'messaging.StaticDocumentAttachmentGridStore','course.CourseCategoryStore',
			  'programCourseDashboard.SectionRosterReportStore','common.AssignedProgramGroupStore','common.FacultyByProgramId','course.AssignedPeriodCoursesFacultyStore',
			  'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore','programCourseDashboard.ParameterisedCoursesStore','common.AcademicTermStoreForIntakeYearId',
			  'course.coursevariants.ParameterCourseVariantStore','attendance.facultyportal.AttendanceCourses','attendance.facultyportal.AttendanceCourseVariantStore',
			  'coursetransaction.studymaterialdistribution.CoursesByAcademyLocationId','course.CourseMarkGradeStore','course.SectionTypeStore','programCourseDashboard.CourseDetailReportStore',
			  'course.coursevariants.ChildCourseVariantByAcademicTermStore','course.CourseByAlAndAcademicTermStore','coursetransaction.sectionmanagement.CourseSectionReportGridStore',
			  'course.coursevariants.ChildCourseVariantByAcademicTermStore','course.CourseByAlAndAcademicTermStore','coursetransaction.sectionmanagement.CourseSectionReportGridStore','student.studentprofile.ManuallyStudentStatusStore',
			  'Academia.store.programCourseDashboard.StudentEnrollmentStatusStore'],
 
  views : ['programCourseDashboard.DashboardMainStructure','programCourseDashboard.SearchFilter',
           'programCourseDashboard.DashboardTabStructure','programCourseDashboard.GeneralSummarySearch',
           'programCourseDashboard.GeneralSummaryStructure','programCourseDashboard.TopBottonProgramAbsenteeismSearch',
           'programCourseDashboard.ProgramSummaryStructure','programCourseDashboard.GeneralSummaryStructure',
           'programCourseDashboard.StudentDemographicReportStructure','programCourseDashboard.CourseSummaryStructure',
           'programCourseDashboard.MostAndLeastPopularCourseSearch','programCourseDashboard.DelayedCourseSearch',
           'programCourseDashboard.TopBottomCourseAbsenteeismSearch','programCourseDashboard.MostLeastPopularCoursesPBS',
           'programCourseDashboard.MostLeastPopularCoursesCBS','programCourseDashboard.ProgramVacantBatchDetailWindow',
           'feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsByAcademiesChart',
           'programCourseDashboard.ProgramWithVacantSeatsGrid','programCourseDashboard.RichTipChartReport',
           'programCourseDashboard.FacultyUtilizationGrid','programCourseDashboard.DashboardDetailedTabStrucure','programCourseDashboard.DetailedTabSearchForm',
           'programCourseDashboard.ProgramDetailsReport','programCourseDashboard.ProgramDetailsReportSearch',
           'programCourseDashboard.ProgramBatchFeeDetailsReport','reports.programcourse.ProgramSavedAdvanceSearchCriteriaReport',
           'programCourseDashboard.FacultyWorkloadCourseWin','programCourseDashboard.FacultyWorkloadCourseGrid',
           'programCourseDashboard.FacultyWorkloadSessionWin','programCourseDashboard.FacultyWorkloadSessionGrid',
           'programCourseDashboard.CourseRosterReportSearchForm','programCourseDashboard.CourseRosterReportStructure', 'programCourseDashboard.CourseRosterReportGrid',

           'programCourseDashboard.CourseDetailReportSearchForm','programCourseDashboard.CourseDetailReportStructure', 'programCourseDashboard.CourseDetailReportGrid',

           'programCourseDashboard.StudentCourseEnrollmentReportStructure','programCourseDashboard.StudentCourseEnrollmentReportSearchForm','programCourseDashboard.StudentCourseEnrollmentReportGrid',
           'programCourseDashboard.ProgramPromotionStructure','programCourseDashboard.ProgramPromotionGrid',
           'programCourseDashboard.CourseAttendanceGrid','programCourseDashboard.CourseSearchAttendance','programCourseDashboard.CourseAttendanceStructure',
           'examinationcenters.generatehallticket.GenerateTabulationReportWin',
           'programCourseDashboard.CourseSearchAttendanceOfSectionGroup','programCourseDashboard.CourseAttendanceBySectionGroupGrid',
           'course.StudentSendMessageWindowCourseRoster', 'course.StudentCourseRosterStaticDocumentAttachmentGrid',
           'programCourseDashboard.SectionRosterReportStructure','programCourseDashboard.SectionRosterReportGrid',
           'programCourseDashboard.SectionRosterReportSearchForm','course.StudentSendMessageWindowSectionRoster',
           'course.StudentSectionRosterStaticDocumentAttachmentGrid',
           'programCourseDashboard.StudentCourseSectionReportStructure',
           'programCourseDashboard.StudentCourseSectionReportSearchForm',
           'programCourseDashboard.StudentCourseSectionReportGrid',
           'programCourseDashboard.StudentCourseSectionEnrolledStudentsWindow',
           'coursetransaction.sectionmanagement.StudentCourseSectionEnrollerStudentGrid'
           ],	           
           config: {
        	   MASTER_TIME_TABLE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MASTER_TIME_TABLE_PRIVILEGES'),
        	   PANDCDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PANDCDASHBOARD_PRIVILEGES'),
        	   PROGRAMCOURSEDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAMCOURSEDASHBOARD_PRIVILEGES'),
        	   PANDCDASHBOARD_PROGRAM_BATCH_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PANDCDASHBOARD_PROGRAM_BATCH_REPORT_PRIVILEGES'),
        	   PROGRAM_PROMOTION_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_PROMOTION_REPORT_PRIVILEGES'),
        	   COURSE_ATTENDANCE_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_ATTENDANCE_REPORT_PRIVILEGES'),
        	   FACULTY_WORKLOAD_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_WORKLOAD_REPORT_PRIVILEGES'),
        	   EMPLOYEE_COURSE_ROSTER_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_COURSE_ROSTER_REPORT_PRIVILEGES'),
        	   STUDENT_COURSE_ENROLLMENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COURSE_ENROLLMENT_REPORT_PRIVILEGES'),
        	   COURSE_WISE_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_WISE_ATTENDANCE_REPORT_PRIVILEGES'),
        	   PROGRAM_VACANT_SEAT_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_VACANT_SEAT_REPORT_ON_TREE_PRIVILEGES'),
        	//   PROGRAM_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_ABSENTEEISM_REPORT_ON_TREE_PRIVILEGES'),
        	   COURSE_POPULARITY_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_POPULARITY_REPORT_ON_TREE_PRIVILEGES'),
        	   COURSE_EXECUTION_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_EXECUTION_REPORT_ON_TREE_PRIVILEGES'),
        	//   COURSE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_ABSENTEEISM_REPORT_ON_TREE_PRIVILEGES'),
        	   COURSE_ROSTER_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_ROSTER_REPORT_ON_TREE_PRIVILEGES'),
        	//   COURSE_ATTENDANCE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_ATTENDANCE_ABSENTEEISM_REPORT_ON_TREE_PRIVILEGES'),
        	   SECTION_ROSTER_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SECTION_ROSTER_REPORT_ON_TREE_PRIVILEGES'),
        	   EMPLOYEE_SECTION_ROSTER_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_SECTION_ROSTER_REPORT_PRIVILEGES'),
        	   COURSE_DETAIL_REPORT_ON_TREE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_DETAIL_REPORT_ON_TREE_PRIVILEGES'),
        	   STUDENT_COURSE_SECTION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COURSE_SECTION_REPORT_PRIVILEGES'),
       		   FACULTY_PORTAL_COURSE_ROASTER_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_COURSE_ROASTER_REPORT'),

           },
   refs : [{
	   ref : 'contentpanel',
	   selector : 'contentpanel'
   },{
	   ref : 'dashboardmainstructure',
	   selector : 'dashboardmainstructure'
   },{
	   ref : 'dashboardmainStructure',
	   selector : 'dashboardmainstructure tabpanel'
   },{
	   ref : 'detailedtabsearchform',
	   selector : 'detailedtabsearchform'
   },{
	   ref:'searchfilter',
	   selector:'searchfilter'
   },{
	   ref:'richtipchartreport',
	   selector:'richtipchartreport'
   },{
	   ref:'generalsummarysearch',
	   selector:'generalsummarysearch'
   },{
	   ref:'mostandleastpopularcoursesearch',
	   selector:'mostandleastpopularcoursesearch'
   },{
	   ref: 'detailedsearchresultgrid',
	   selector: 'searchresultgrid[itemId=detailedsearchresultgrid]'
   },{
	   ref: 'topandbottomattendancegridforfaculty',
	   selector: 'searchresultgrid[itemId=topandbottomattendancegridforfaculty]'
   },{
	   ref :'topandbottomattendancegridforstudent',
	   selector: 'searchresultgrid[itemId=topandbottomattendancegridforstudent]'
   },{
	   ref :'topBottomCourseAbsenteeismSearchGridId',
	   selector: 'searchresultgrid[itemId=topBottomCourseAbsenteeismSearchGridId]'
   },{
	   ref :'topbottomcourseabsenteeismsearch',
	   selector:'topbottomcourseabsenteeismsearch'
   },{
	   ref :'topbottomprogramabsenteeismgrid',
	   selector: 'searchresultgrid[itemId=topbottomprogramabsenteeismgrid]'
   },{
	   ref :'topbottonprogramabsenteeismsearch',
	   selector:'topbottonprogramabsenteeismsearch'
   },{
	   ref : 'mostandleastpopularcoursesearch',
	   selector :'mostandleastpopularcoursesearch'
   },{
	   ref : 'mostleastpopularcoursespbsGridId',
	   selector :'searchresultgrid[itemId=mostleastpopularcoursespbsGridId]'
   },{
	   ref :'mostleastpopularcoursescbsGridId',
	   selector :'searchresultgrid[itemId=mostleastpopularcoursescbsGridId]'
   },{
	   ref :'programsummarystructure',
	   selector :'programsummarystructure'
   },{
	   ref :'programwithvacantsseatsgrid',
	   selector :'searchresultgrid[itemId=programwithvacantsseatsgrid]'
   },{
	   ref :'programvacantbatchdetailwindow',
	   selector:'programvacantbatchdetailwindow'
   },{
	   ref : 'programVacantBatchDtlGridId',
	   selector :'searchresultgrid[itemId=programVacantBatchDtlGridId]'
   },{
	   ref : 'programBathcReportGrid',
	   selector :'searchresultgrid[itemId=programBathcReportGrid]'
   },{
	   ref : 'programBatchFeeDetailsGrid',
	   selector :'searchresultgrid[itemId=programBatchFeeDetailsGrid]'
   },{
	   ref :'delayedcoursesearch',
	   selector :'delayedcoursesearch'
   },{
	   ref : 'delayedCourseSearchGrIdPBS',
	   selector:'searchresultgrid[itemId=delayedCourseSearchGrIdPBS]'
   },{
	   ref : 'delayedCourseSearchGrIdCBS',
	   selector:'searchresultgrid[itemId=delayedCourseSearchGrIdCBS]'
   },{
	   ref:'generalsummarystructure',
	   selector:'generalsummarystructure'
   },{
	   ref : 'topBottomFacultyUtilizationGrid',
	   selector:'facultyutilizationgrid[itemId=topBottomFacultyUtilizationGrid]'
   },{
       ref: 'programWithVacantsSeatsChart',
       selector: 'columnchartreport[itemId=programWithVacantsSeatsChart]'
   },{
       ref:'programWithVacantSeatsGrid',
       selector:'programwithvacantseatsgrid'
    },{
 	   ref: 'organizationunit',
 	   selector: 'organizationunit[itemId=programCourseOrganizationunitId]'
    },{
        ref: 'facultyutilizationgrid',
        selector: 'facultyutilizationgrid[itemId=facultyWorkLoadReportId]'
    },{
        ref: 'coursesummarystructure',
        selector: 'coursesummarystructure'
    },{
        ref: 'programdetailsreportsearch',
        selector: 'programdetailsreportsearch'
    },{
        ref: 'programbatchfeedetailsreport',
        selector: 'programbatchfeedetailsreport' 
    },{
        ref: 'programbatchFeedetailsreport',
        selector: 'programbatchfeedetailsreport form' 
    },{
        ref: 'facultyworkloadcoursewin',
        selector: 'facultyworkloadcoursewin' 
    },{
        ref: 'facultyWorkloadcoursewin',
        selector: 'facultyworkloadcoursewin form' 
    },{
        ref: 'facultyworkloadcoursegrid',
        selector: 'facultyworkloadcoursegrid' 
    },{
        ref: 'facultyworkloadsessionwin',
        selector: 'facultyworkloadsessionwin' 
    },{
        ref: 'facultyWorkloadsessionwin',
        selector: 'facultyworkloadsessionwin form' 
    },{
        ref: 'facultyworkloadsessiongrid',
        selector: 'facultyworkloadsessiongrid' 
    },{
        ref: 'courserosterreportsearchform',
        selector: 'courserosterreportsearchform' 
    },{
        ref: 'coursedetailreportgrid',
        selector: 'coursedetailreportgrid' 
    },{
    	ref: 'courserosterreportgrid',
        selector: 'courserosterreportgrid[itemId=courserosterreportGridId]'
    },{
        ref: 'studentcourseenrollmentreportsearchform',
        selector: 'studentcourseenrollmentreportsearchform' 
    },{
    	ref: 'studentcourseenrollmentreportgrid',
        selector: 'studentcourseenrollmentreportgrid[itemId=studentcourseenrollmentreportGridId]'
    },{
    	ref : 'programPromotionForm',
    	selector : 'programpromotionstructure form'
    },{
    	ref : 'programPromotionGrid',
    	selector : 'programpromotiongrid'
    },{
        ref: 'courseattendancestructure',
        selector: 'courseattendancestructure'
    },{
        ref: 'coursesearchattendance',
        selector: 'coursesearchattendance'
    },{
    	ref: 'courseattendancegrid',
    	selector: 'courseattendancegrid'
    },{
    	ref: 'courseattendancebysectiongroupgrid',
    	selector: 'courseattendancebysectiongroupgrid'
    },{
        ref : 'generatecourserosterreportwin',
        selector:'generatetabulationreportwin[itemId=generatecourserosterreportwin]'
    },{
        ref : 'coursesearchattendanceofsectiongroup',
        selector:'coursesearchattendanceofsectiongroup'
    },{
        ref : 'studentcourseenrollmentreportstructure',
        selector:'studentcourseenrollmentreportstructure'
    },{
        ref : 'programdetailsreport',
        selector:'programdetailsreport'
    },{
        ref : 'studentsendmessagewindowcourseroster',
        selector:'studentsendmessagewindowcourseroster'
    },{
        ref : 'studentcourserosterstaticdocumentattachmentgrid',
        selector:'studentcourserosterstaticdocumentattachmentgrid'
    },{
        ref: 'sectionrosterreportsearchform',
        selector: 'sectionrosterreportsearchform' 
    },{
    	ref: 'sectionrosterreportgrid',
        selector: 'sectionrosterreportgrid[itemId=sectionrosterreportGridId]'
    },{
        ref : 'generatesectionrosterreportwin',
        selector:'generatetabulationreportwin[itemId=generatesectionrosterreportwin]'
    },{
        ref : 'studentsendmessagewindowsectionroster',
        selector:'studentsendmessagewindowsectionroster'
    },{
        ref : 'studentsectionrosterstaticdocumentattachmentgrid',
        selector:'studentsectionrosterstaticdocumentattachmentgrid'
    },{
    	ref:'adminresetpasswordwindow',
    	selector:'adminresetpasswordwindow[itemId=StudentListCourseRosterReportResetPass]'
    },{
    	ref:'coursedetailreportstructure',
    	selector:'coursedetailreportstructure'
    },{
    	ref:'coursedetailreportsearchform',
    	selector:'coursedetailreportsearchform' 
    },{
    	ref:'studentcoursesectionreportstructure',
    	selector:'studentcoursesectionreportstructure' 
    },{
    	ref:'studentcoursesectionreportsearchform',
    	selector:'studentcoursesectionreportsearchform' 
    },{
    	ref:'studentcoursesectionreportgrid',
    	selector:'studentcoursesectionreportgrid' 
    },{
 	   ref : 'studentcoursesectionenrolledstudentswindow',
	   selector : 'studentcoursesectionenrolledstudentswindow'
   },{
 	   ref : 'studentcoursesectionenrollerstudentgrid',
	   selector : 'studentcoursesectionenrollerstudentgrid'
   }
    /*,{
        ref : 'courseexecutionreportstructure',
        selector:'courseexecutionreportstructure'
    }*/],
   init : function() {
	   this.control({
		   'courseattendancegrid' : {
	       		beforerender:function(){
		 				 this.getStore('programCourseDashboard.CourseAttendanceGridStore').removeAll();
		 		    },
		 		 render:function(grid){
		 			this.doAccessControlValidation(grid, this.getCOURSE_ATTENDANCE_REPORT_PERMISSIONS());
                	this.disableExportBtnActionPivileges(grid, this.getCOURSE_ATTENDANCE_REPORT_PERMISSIONS());
		 		 }   
	       	},
	        'facultyutilizationgrid' : {
		 		 render:function(grid){
		 			this.doAccessControlValidation(grid, this.getFACULTY_WORKLOAD_REPORT_PERMISSIONS());
                	this.disableExportBtnActionPivileges(grid, this.getFACULTY_WORKLOAD_REPORT_PERMISSIONS());
		 		 }   
	       	},
	    	'courseattendancegrid button[itemId=exportReportsId]':{
				click : this.exportReportWindow
			},
			'courseattendancebysectiongroupgrid button[itemId=exportReportsOfSectionGroupId]':{
				click : this.exportReportWindowOfSectionGroup
			},
			'courseattendancestructure':{
				render:this.academyCurrentLocation,
				afterrender : function() {
					var $this = this;
					var courseattendanceform=$this.getCourseattendancestructure();
					permissionsMap = $this.getCOURSE_WISE_ATTENDANCE_REPORT_PRIVILEGES();
					$this.disableRadioSelectionsPivilegesOfCourse(courseattendanceform, permissionsMap);
					courseattendanceform.down('#sectionGroupTypeId').setValue({
						whetherPBSorCBSGroup:true
					});
				}

			},
	        'courseattendancestructure radiogroup[itemId=sectionGroupTypeId]':{
	        	 change : function(value,newValue,oldValue){
    				 this.onChangeSectionGroupType(value,newValue,oldValue);
    			 }
	        },
	        'coursesearchattendance button[itemId=resetBtn]':{
	        	click: function(obj,record) {
	        		var form=this.getCoursesearchattendance();
	        		form.getForm().reset();
	        		form.down("#programBatch_programId").setDisabled(true);
	        		form.down("#programBatch_batchId").setDisabled(true);
	        		form.down("#programBatch_periodId").setDisabled(true);
	        		form.down("#programCoursection_ID").setDisabled(true);
	        		form.down("#course_Id").clearValue();
	        		form.down("#course_Id").setDisabled(true);
	        		form.down("#studentId").setDisabled(true);
	        		form.down("#startDate").setMinValue(false);
	        		form.down("#startDate").setMaxValue(new Date());
	        		form.down("#endDate").setMinValue(false);
	        		form.down("#endDate").setMaxValue(new Date());
	        		this.getCourseattendancegrid().down('#exportReportsId').setDisabled(true);
	        		var academicTerm = form.down('#academicTermId');
	        		academicTerm.reset();
	        		var academicTermStore = academicTerm.getStore();
	        		academicTermStore.load({
	        			callback: function(record, operation, success) {
	        				if (success) {
	        					if(record.length>0){
	        						Ext.each(record, function(value) {
	        							if(value.get('whetherCurrentAcademicTerm')){
	        								form.down("#academicTermId").setValue(value.get('id'));
	        							}
	        						});
	        					}
	        				}
	        			}
	        		});
	        	}
	    	},
	    	'coursesearchattendance button[itemId=searchBtn]':{
	    		 click: this.loadreport
	    	},
	    	'coursesearchattendance combo#academicTermId': {
	  			   change: function(obj, record) {
					   var academicTermId = obj.getValue();
					   var alIds=[];
					   var academyLocationIds = this.getAcademyLocationIds();
					   if(isNullOrEmpty(academyLocationIds)){
						   		alIds.push(this.getCurrentAcademyLocation());
						   		academyLocationIds = alIds.join();
					   }
					   if(academicTermId > 0){
						   var form = this.getCoursesearchattendance();
						   form.down("#programBatch_programId").reset();
						   form.down("#programBatch_programId").setDisabled(false);
						   form.down("#course_Id").reset();
						   form.down('#course_Id').setDisabled(false);
						   form.down("#studentId").reset();
						   form.down("#studentId").setDisabled(false);
						   this.getCourseattendancegrid().down('#exportReportsId').setDisabled(false);
						   
						   form.down("#programBatch_batchId").reset();
						   form.down("#programBatch_batchId").setDisabled(true);
						   
						   form.down("#programBatch_periodId").reset();
						   form.down("#programBatch_periodId").setDisabled(true);
						   
						   form.down("#programCoursection_ID").reset();
						   form.down("#programCoursection_ID").setDisabled(true);
						   
						   var store = form.down("#programBatch_programId").getStore();
						   store.getProxy().extraParams = {
							   academicTermId:academicTermId,
							   academyLocationIds:academyLocationIds
						   };
						   store.load();
						   var courseID = form.down('#course_Id');
						   var courseStore = form.down("#course_Id").getStore();
						   courseStore.getProxy().api.read=SERVERURL.FIND_ALL_PARAMETERISED_COURSES;
						   courseStore.getProxy().extraParams = {
							   academicTermId:academicTermId,
							   academyLocationIds:academyLocationIds
						   };
						   courseStore.load();
						   var studentStore=form.down("#studentId").getStore();
						   studentStore.getProxy().extraParams = {
							   academicTermId:academicTermId,
							   academyLocationIds:academyLocationIds
						   };
						   studentStore.load();
					   }
				   }
			   },
			   'coursesearchattendance customcombobox#studentId': {
				   select: function(obj, record) {
					   var studentId = record[0].get("id");
					   if(studentId>0){
						   var alIds=[];
						   var academyLocationIds = this.getAcademyLocationIds();
						   if(isNullOrEmpty(academyLocationIds)){
							   alIds.push(this.getCurrentAcademyLocation());
							   academyLocationIds = alIds.join();
						   }
						   var form=this.getCoursesearchattendance();
						   this.getCourseattendancegrid().down('#exportReportsId').setDisabled(false);

						   form.down("#programBatch_batchId").reset();
						   form.down("#programBatch_batchId").setDisabled(true);

						   form.down("#programBatch_periodId").reset();
						   form.down("#programBatch_periodId").setDisabled(true);

						   form.down("#programCoursection_ID").reset();
						   form.down("#programCoursection_ID").setDisabled(true);

						   var academicTermId = form.down("#academicTermId").getValue();

						   form.down("#programBatch_programId").reset();
						   form.down("#programBatch_programId").setDisabled(false);
						   form.down("#course_Id").reset();
						   form.down('#course_Id').setDisabled(false);

						   var store = form.down("#programBatch_programId").getStore();
						   store.getProxy().extraParams = {
							   academicTermId:academicTermId,
							   academyLocationIds:academyLocationIds,
							   studentId:studentId,
							   onlyCurrentRecord:false
						   };
						   store.load();
						   var courseID = form.down('#course_Id');
						   var courseStore = form.down("#course_Id").getStore();
						   courseStore.getProxy().api.read=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
						   courseStore.getProxy().extraParams = {
							   academicTermId:academicTermId,
							   academyLocationIds:academyLocationIds,
							   studentId:studentId
						   };
						   courseStore.load();

					   }
				   }
			   },
			'coursesearchattendance combo#programBatch_programId': {
	  			   select: function(obj, record) {
					   var programId = record[0].get("id");
					   if(programId > 0){
						   var form = this.getCoursesearchattendance();
						   var academicTermId=form.down('#academicTermId').getValue();
						   var studentId = form.down('#studentId').getValue();
						   form.down("#programBatch_batchId").setDisabled(false);
						   form.down("#programBatch_periodId").reset();
						   form.down("#programBatch_periodId").setDisabled(true);
						   form.down("#programCoursection_ID").reset();
						   form.down("#programCoursection_ID").setDisabled(true);
						   var store = form.down("#programBatch_batchId").getStore();
						   store.getProxy().extraParams = {
							   programId: programId,
							   academicTermId:academicTermId,
							   studentId:studentId,
						   };
						   store.load();
					   }
				   }
			   },
			   'coursesearchattendance combo#programBatch_batchId': {
				   select: function(obj, record) {
					   var batchId = record[0].get("id");
					   var alinfomodel = Academia.model.authentication.ALInfoModel;
					   var wheatherSchool = alinfomodel.get('wheatherSchool');
					   if(batchId > 0){
						   var form = this.getCoursesearchattendance();
						   var academicTermId=form.down('#academicTermId').getValue();
						   var studentId = form.down('#studentId').getValue();
						   form.down("#programBatch_periodId").setDisabled(false);
						   form.down("#programCoursection_ID").reset();
						   form.down("#programCoursection_ID").setDisabled(true);
						   var store = form.down("#programBatch_periodId").getStore();
						   store.getProxy().extraParams = {
							   batchId: batchId,
							   academicTermId:academicTermId,
							   studentId:studentId
						   };
						   if(wheatherSchool){
							   form.down("#programBatch_periodId").hide();
							   store.load({
								   callback: function(periodRecords, operation, success) {
									   if (success) {
										   if(periodRecords.length==1){
											   form.down("#programBatch_periodId").setValue(periodRecords[0].get('id'));
										   }else{
											   form.down("#programBatch_periodId").show();
										   }
									   }
								   }
							   });  
						   }else{
							   store.load(); 
						   }

					   }
				   }
			   }, 
			   'coursesearchattendance combo#programBatch_periodId': {
				   change: function(obj, record) {
					   var periodId = obj.getValue();;
					   if(periodId > 0){
						   var form = this.getCoursesearchattendance();
						   var academicTermId=form.down('#academicTermId').getValue();
						   var studentId = form.down('#studentId').getValue();
						   form.down("#programCoursection_ID").setDisabled(false);
						   var store = form.down("#programCoursection_ID").getStore();
						   store.getProxy().extraParams = {
							   periodId: periodId,
							   academicTermId:academicTermId,
							   studentId:studentId
						   };
						   
						   store.load();
					   }
				   }
			   }, 
		   'searchresultgrid[itemId=mostleastpopularcoursespbsGridId]':{
  			 render:function(grid){
  				 this.gridRenderFunction(grid);
  				 this.genericCBGridAccessControlValidation(grid,this.getCOURSE_POPULARITY_REPORT_ON_TREE_PERMISSIONS());
  			 }    
  		 },
  		'searchresultgrid[itemId=mostleastpopularcoursescbsGridId]':{
   			 render:function(grid){
   				 this.gridRenderFunction(grid);
   				this.genericCBGridAccessControlValidation(grid,this.getCOURSE_POPULARITY_REPORT_ON_TREE_PERMISSIONS());
   			 }    
   		 },
   		'searchresultgrid[itemId=delayedCourseSearchGrIdPBS]':{
  			 render:function(grid){
  				 this.gridRenderFunction(grid);
  				this.genericCBGridAccessControlValidation(grid,this.getCOURSE_EXECUTION_REPORT_ON_TREE_PERMISSIONS());
  				grid.down('#searchResultGridBtnView').hide();
  			 }    
  		 },
  		'searchresultgrid[itemId=delayedCourseSearchGrIdCBS]':{
 			 render:function(grid){
 				 this.gridRenderFunction(grid);
 				this.genericCBGridAccessControlValidation(grid,this.getCOURSE_EXECUTION_REPORT_ON_TREE_PERMISSIONS());
 				grid.down('#searchResultGridBtnView').hide();
 			 }    
 		 },
 		'searchresultgrid[itemId=topandbottomattendancegridforfaculty]':{
			 render:function(grid){
				 this.gridRenderFunction(grid);
				 //this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
				// this.genericCBGridAccessControlValidation(grid,this.getCOURSE_ATTENDANCE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS());
			 }    
		 },
		 'searchresultgrid[itemId=topandbottomattendancegridforstudent]':{
			 render:function(grid){
				 this.gridRenderFunction(grid);
				 //this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
				// this.genericCBGridAccessControlValidation(grid,this.getCOURSE_ATTENDANCE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS());
			 }    
		 },
		   //*****************Export For Course Summary**********************************************************************
			  'searchresultgrid[itemId=mostleastpopularcoursespbsGridId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'mostleastpopularcoursespbsGridId');
		            }
		        },
		        'searchresultgrid[itemId=mostleastpopularcoursespbsGridId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'mostleastpopularcoursespbsGridId');
		            }
		        },
		        'searchresultgrid[itemId=mostleastpopularcoursespbsGridId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'mostleastpopularcoursespbsGridId');
		            }
		        },
		        'searchresultgrid[itemId=mostleastpopularcoursespbsGridId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'mostleastpopularcoursespbsGridId');
		            }
		        },
		       //****************************************************************************************************** 
		        'searchresultgrid[itemId=mostleastpopularcoursescbsGridId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'mostleastpopularcoursescbsGridId');
		            }
		        },
		        'searchresultgrid[itemId=mostleastpopularcoursescbsGridId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'mostleastpopularcoursescbsGridId');
		            }
		        },
		        'searchresultgrid[itemId=mostleastpopularcoursescbsGridId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'mostleastpopularcoursescbsGridId');
		            }
		        },
		        'searchresultgrid[itemId=mostleastpopularcoursescbsGridId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'mostleastpopularcoursescbsGridId');
		            }
		        },  
		      //**************************************************************************************************************
		        'searchresultgrid[itemId=delayedCourseSearchGrIdPBS] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'delayedCourseSearchGrIdPBS');
		            }
		        },
		        'searchresultgrid[itemId=delayedCourseSearchGrIdPBS] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'delayedCourseSearchGrIdPBS');
		            }
		        },
		        'searchresultgrid[itemId=delayedCourseSearchGrIdPBS] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'delayedCourseSearchGrIdPBS');
		            }
		        },
		        'searchresultgrid[itemId=delayedCourseSearchGrIdPBS] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'delayedCourseSearchGrIdPBS');
		            }
		        },
		      //*************************************************************************************************************  
		        'searchresultgrid[itemId=delayedCourseSearchGrIdCBS] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'delayedCourseSearchGrIdCBS');
		            }
		        },
		        'searchresultgrid[itemId=delayedCourseSearchGrIdCBS] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'delayedCourseSearchGrIdCBS');
		            }
		        },
		        'searchresultgrid[itemId=delayedCourseSearchGrIdCBS] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'delayedCourseSearchGrIdCBS');
		            }
		        },
		        'searchresultgrid[itemId=delayedCourseSearchGrIdCBS] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'delayedCourseSearchGrIdCBS');
		            }
		        },
		      //*************************************************************************************************************  
		        'searchresultgrid[itemId=topBottomCourseAbsenteeismSearchGridId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'topBottomCourseAbsenteeismSearchGridId');
		            }
		        },
		        'searchresultgrid[itemId=topBottomCourseAbsenteeismSearchGridId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'topBottomCourseAbsenteeismSearchGridId');
		            }
		        },
		        'searchresultgrid[itemId=topBottomCourseAbsenteeismSearchGridId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'topBottomCourseAbsenteeismSearchGridId');
		            }
		        },
		        'searchresultgrid[itemId=topBottomCourseAbsenteeismSearchGridId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'topBottomCourseAbsenteeismSearchGridId');
		            }
		        },
		      //*********************************************************************************************************************
		        'searchresultgrid[itemId=topandbottomattendancegridforfaculty] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'topandbottomattendancegridforfaculty');
		            }
		        },
		        'searchresultgrid[itemId=topandbottomattendancegridforfaculty] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'topandbottomattendancegridforfaculty');
		            }
		        },
		        'searchresultgrid[itemId=topandbottomattendancegridforfaculty] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'topandbottomattendancegridforfaculty');
		            }
		        },
		        'searchresultgrid[itemId=topandbottomattendancegridforfaculty] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'topandbottomattendancegridforfaculty');
		            }
		        },
		     //*******************************************************************************************************************
		        'searchresultgrid[itemId=topandbottomattendancegridforstudent] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'topandbottomattendancegridforstudent');
		            }
		        },
		        'searchresultgrid[itemId=topandbottomattendancegridforstudent] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'topandbottomattendancegridforstudent');
		            }
		        },
		        'searchresultgrid[itemId=topandbottomattendancegridforstudent] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'topandbottomattendancegridforstudent');
		            }
		        },
		        'searchresultgrid[itemId=topandbottomattendancegridforstudent] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'topandbottomattendancegridforstudent');
		            }
		        },
		     //********************************************************************************************************************
		        'searchresultgrid[itemId=topbottomprogramabsenteeismgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'topbottomprogramabsenteeismgrid');
		            }
		        },
		        'searchresultgrid[itemId=topbottomprogramabsenteeismgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'topbottomprogramabsenteeismgrid');
		            }
		        },
		        'searchresultgrid[itemId=topbottomprogramabsenteeismgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'topbottomprogramabsenteeismgrid');
		            }
		        },
		        'searchresultgrid[itemId=topbottomprogramabsenteeismgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'topbottomprogramabsenteeismgrid');
		            }
		        },
		        
		        'searchresultgrid[itemId=programBathcReportGrid]': {
		        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		        		var $this=this;
		        		var searchResultGrid = this.getProgramBathcReportGrid();
		        		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
		        		if(columnName=='BATCH_NAME'){ 
		        			$this.showFeeDetailWindow(record);
		        		}  
		        	},
		        	render : function(){
		        		var grid = this.getProgramBathcReportGrid();
		        		 this.gridRenderFunction(grid);
		        		this.genericCBGridAccessControlValidation(grid, this.getPANDCDASHBOARD_PROGRAM_BATCH_REPORT_PRIVILEGES());
		        	}
		        },
		        'searchresultgrid[itemId=programBathcReportGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',false,'programBathcReportGrid');
		            }
		        },
		        'searchresultgrid[itemId=programBathcReportGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.PDFEXPORT,'pdf',true,'programBathcReportGrid');
		            }
		        },
		        'searchresultgrid[itemId=programBathcReportGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'programBathcReportGrid');
		            }
		        },
		        'searchresultgrid[itemId=programBathcReportGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
		            click: function() {
		                this.exportUserListforDashboard(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'programBathcReportGrid');
		            }
		        },
		        'adminresetpasswordwindow[itemId=StudentListCourseRosterReportResetPass] button[itemId=submitBtn]':{
     	        	click:function(obj){
     	        		this.changePasswordByAdminCR(obj);
     	        	}
     	        },
     	        'adminresetpasswordwindow[itemId=StudentListCourseRosterReportResetPass] button[itemId=cancelBtn]':{
     	        	click:function(obj){
     	        		obj.up('window').close();
     	        	}
     	        },
     	        
                'adminresetpasswordwindow[itemId=StudentListCourseRosterReportResetPass]': {
                    beforerender: function(formWindow) {
                    	var form = formWindow.down('form');
            	    	this.getController('Academia.controller.authentication.AuthenticationController').getPasswordPolicy(form);
                    }
                },
               
    			'adminresetpasswordwindow[itemId=StudentListCourseRosterReportResetPass] form #resetPassword' :{ 
    				blur:this.getController('Academia.controller.authentication.AuthenticationController').checkPasswordValidity
    			},
    			

		        
		     //**********************************End**********************************************************************   
		        
		        
		        /********************** Program Batch Details Report ****************************/
		        
		        'programdetailsreportsearch combo[itemId=programId]': {
					   render: function(obj) {
						   var form = obj.up('form');
						   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();						   
						   var programField = form.down('#programId');
						   var store = programField.getStore();
						   store.getProxy().extraParams = {
							   academyLocationIds:acadLocationIdsCommaSepeated
						   };
						   store.load();
					   
					   },
					   change : function(obj){
						   var form = obj.up('form');
//						   var programId = record[0].get("id");
						   var values = form.getForm().getValues();
						   var programId = values.programId;
						   var batch = form.down('#batchId');
						   batch.reset();
						   batch.setDisabled(false);
						   var programids=[];
						   var programs; 
						   if(programId !=undefined && programId.length > 0){
							   for(var i in programId){
								   if(Ext.isObject(programId[0])){
									   programids.push(programId[i].get("id"));
								   }else{
									   programids.push(programId[i]);
								   }
							   }
							   programs = programids.join();
						   }
							   var store = batch.getStore();
							   store.getProxy().extraParams = {
								   programIds:programs
//								   id: programs
							   };
							   store.load();
					   }
				   },
				   'programdetailsreportsearch button[itemId=btnReset]':{
					   click : function(btn){
						   var $this = this;
						   var programdetailsreportsearch =btn.up('programdetailsreportsearch');
						   var programdetailsreport = programdetailsreportsearch.up('programdetailsreport');
						   programdetailsreportsearch.destroy();
						   programdetailsreport.insert(0,{xtype:'programdetailsreportsearch'});
					   }	                			   
				   },
				   'programdetailsreportsearch button[itemId=btnSearch]':{
					   click : function(model,records){
						   var values = new Object();
						   values.configCode = CONSTANTS.CB.PROGRAM_BATCH_REPORT_VIEW_CODE;
						   var form = this.getProgramdetailsreportsearch();
						   var jsonFormatFormData = this.createJsonProgramBatchReport(form,records);
						   var searchResultGrid = this.getProgramBathcReportGrid();
						   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PROGRAM_BATCH_REPORT_VIEW_CODE);
						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
						   Ext.getBody().unmask();
					   }	                			   
				   },
		        
		   'organizationunit[itemId=programCourseOrganizationunitId] combo[itemId=academyLocationId]': {
			   show: function() {
				   this.loadAcademyLocation();
			   }, 
			   change: function() {
				   this.loadAcademyLocation();
			   }
		   },
		   'organizationunit[itemId=programCourseOrganizationunitId] combo[itemId=multiselectAcademyLocationId]': {
			   show: function() {
				   this.loadAcademyLocation();
			   }, 
			   change: function() {
				   this.loadAcademyLocation();
			   },
			   afterrender: function(obj) {
				   var me = this;
				   var academyLocationIds = me.getCurrentAcademyLocation();
				   obj.setValue(academyLocationIds);
			   }
		   },
		   'organizationunit[itemId=programCourseOrganizationunitId] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getPROGRAMCOURSEDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=programCourseOrganizationunitId] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				var me = this;
    				this.resetOrganizationunit(obj);
    				setTimeout(function(){
    					var academyLocationIds = me.getCurrentAcademyLocation();
        				obj.up('form').down('#multiselectAcademyLocationId').setValue(academyLocationIds);
    				},500);
    				
    			}
    		},
		   'searchfilter combo#academyId': {
			   select: function(obj, record) {
				   var academyId = record[0].get("id");
				   var store = this.getStore('common.AcademyLocationByAcademyId');
				   store.getProxy().extraParams = {
					   id: academyId
				   };
				   store.load();                    
			   }
		   },
		 
		  /* 'mostandleastpopularcoursesearch radiogroup#selectionTypeId':{
			   change : function(obj,val){
				   var form = this.getMostandleastpopularcoursesearch();
				   var value = form.down('#selectionTypeId').getValue();

				   var program = form.down('#programId');
				   var batch = form.down('#batchId');
				   var period = form.down('#periodId');
				   var coursePBS = form.down('#courseIdPBS');
				   var courseCBS = form.down('#courseIdCBS');
				   var mostleastpopularcoursescbsGridId = form.down('#mostleastpopularcoursescbsGridId');
				   var mostleastpopularcoursespbsGridId = form.down('#mostleastpopularcoursespbsGridId');

				   program.reset();
				   batch.reset();
				   period.reset();
				   coursePBS.reset();
				   courseCBS.reset();


				   if(value.selectionType =='Course Section'){
					   program.setVisible(false);
					   batch.setVisible(false);
					   period.setVisible(false);
					   coursePBS.setVisible(false);
					   courseCBS.setVisible(true);
					   mostleastpopularcoursescbsGridId.setVisible(true);
					   mostleastpopularcoursespbsGridId.setVisible(false);
				   }  else if(value.selectionType=='Program Batch Section'){
					   program.setVisible(true);
					   batch.setVisible(true);
					   period.setVisible(true);
					   coursePBS.setVisible(true);
					   courseCBS.setVisible(false);
					   mostleastpopularcoursescbsGridId.setVisible(false);
					   mostleastpopularcoursespbsGridId.setVisible(true);
				   }
			   }
		   },*/
		   	                		   	                		   
		   'searchfilter radiogroup#selectionTypeId':{
			   change : function(obj,newVal){
				   var form = this.getSearchfilter();
				   var value = form.down('#selectionTypeId').getValue();
				   var isu = form.down('#isuId');	                				   
				   var mau = form.down('#mauId');

				   isu.reset();
				   mau.reset();

				   isu.setVisible(false);
				   mau.setVisible(false);

				   if(value.selectionType=='ISU'){
					   isu.setVisible(true);	
				   } else if(value.selectionType=='MAU'){
					   mau.setVisible(true);	
				   } 
			   }
		   },

		   'generalsummarysearch combo#stastisticsId':{
			   change : function(obj,selectedValue){
				   var form = this.getGeneralsummarysearch();
				   var program = form.down('#programId');
				   var batch = form.down('#batchId');
				   var period = form.down('#periodId');
				   var section = form.down('#sectionId');
				   var department = form.down('#departmentId');
				   var subdepartment = form.down('#subDepartmentId');

				   program.reset();
				   batch.reset();
				   period.reset();
				   section.reset();
				   department.reset();
				   subdepartment.reset();

				   if(selectedValue!='' && selectedValue=='Student'){
					   program.setVisible(true);
					   batch.setVisible(true);
					   period.setVisible(true);
					   section.setVisible(true);
					   department.setVisible(false);
					   subdepartment.setVisible(false);
				   } else if(selectedValue!='' && selectedValue=='Faculty'){
					   program.setVisible(false);
					   batch.setVisible(false);
					   period.setVisible(false);
					   section.setVisible(false);
					   department.setVisible(true);
					   subdepartment.setVisible(true);
				   }
			   }
		   },

		   'generalsummarysearch combo#programId': {
			   select: function(obj, record) {
				   var programId = record[0].get("id");
				   var form = this.getGeneralsummarysearch();
				   var batch = form.down('#batchId');
				   batch.reset();
				   if(programId > 0){
					   var store = this.getStore('enquiry.AcademicBatchStore');
					   store.getProxy().extraParams = {
						   id: programId
					   };
					   store.load();
				   }
			   }
		   },

		   'mostandleastpopularcoursesearch combo#programId': {
			   select: function(obj, record) {
				   var programId = record[0].get("id");
				   //var form = this.getGeneralsummarysearch();
				   var form =obj.up('form');
				   var batch = form.down('#batchId');
				   batch.reset();
				   batch.setDisabled(false);
				   if(programId > 0){
					   //var store = this.getStore('enquiry.AcademicBatchStore');
					   var store = batch.getStore();
					   store.getProxy().extraParams = {
						   id: programId
					   };
					   store.load();
				   }
			   }
		   },
		   
		   'delayedcoursesearch combo#programId': {
			   select: function(obj, record) {
				   var programId = record[0].get("id");
				   var form = this.getDelayedcoursesearch();
				   var batch = form.down('#batchId');
				   var periodId = form.down('#periodId');
				   var courseIdPBS = form.down('#courseIdPBS');
				   
				   batch.reset();
				   periodId.reset();
				   courseIdPBS.reset();
				   if(programId > 0){
					   batch.getStore().getProxy().extraParams = {
						   id: programId,
					   };
					   
					   batch.getStore().load({
	        			   callback: function(batchRecords, operation, success) {
	        				   if (success) {
	        					   if(batchRecords.length==1){
	        						   form.down('#batchId').setValue(batchRecords[0].get('id'));
	        						   periodId.getStore().getProxy().extraParams = {
	        							   id: batchRecords[0].get('id'),
	        						   };
	        						   periodId.getStore().load({
	        		        			   callback: function(periodRecords, operation, success) {
	        		        				   if (success) {
	        		        					   if(periodRecords.length==1){
	        		        						   form.down('#periodId').setValue(periodRecords[0].get('id'));
	        		        						   
	        		        						   var store = this.getStore('coursetransaction.coursereading.CourseByPeriod');
	        		        							  // var store = course.getStore();
	        		        							   store.getProxy().extraParams = {
	        		        								   id:periodRecords[0].get('id')
        		        							   };
        		        							   store.load();
	        		        						   /*courseIdPBS.getStore().getProxy().extraParams = {
	        		        							   programId: programId,
	        		        							   batchId:batchRecords[0].get('id'),
	        		        							   periodId:periodRecords[0].get('id'),
	        		        							   sectionType:'ProgramBatchSection'
	        		        						   };
	        		        						   courseIdPBS.getStore().load();*/
	        		        					   }
        		        					   }
    		        					   }
    		        				   
        		        			   });
	        					   }
        					   }
        				   }
					   });
				   }
			   }
		   },
		   
		   'generalsummarysearch combo#batchId':{
			   select:function(obj, record){
				   var form = this.getGeneralsummarysearch();
				   var period = form.down('#periodId');
				   period.reset();
				   var batchId = record[0].get("id");
				   if(batchId !=''){	    	        					  
					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					   store.getProxy().extraParams = {
						   id: batchId
					   };
					   store.load();
				   }
			   }
		   },

		   'mostandleastpopularcoursesearch combo#periodId': {
			   select: function(obj, record) {
				   var periodId = record[0].get("id");
				   var form = this.getMostandleastpopularcoursesearch();
				   var course = form.down('#courseIdPBS');
				   course.reset();
				   course.setDisabled(false);
				   if(periodId > 0){
					   var store = this.getStore('coursetransaction.coursereading.CourseByPeriod');
					  // var store = course.getStore();
					   store.getProxy().extraParams = {
						   //V2D-81026
						   periodId:periodId
					   };
					   store.load();
				   }
			   }
		   },
		   'delayedcoursesearch combo#facultyCodeItemId': {
				   render: function(obj) {
					   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
					   var form = this.getDelayedcoursesearch();
					   var facultyCodeField =form.down('#facultyCodeItemId');
					   var store = facultyCodeField.getStore();
					   store.getProxy().extraParams = {
						   academyLocationIds: acadLocationIdsCommaSepeated
					   };
					   store.load();
				   }
			   },		   
		   // delayed course CBS get section course wise
		   'delayedcoursesearch combo#courseIdCBS': {
			   select: function(obj, record) {
				   var $this = this;
				   var form = this.getDelayedcoursesearch();
				   var academyLocationIds = this.getAcademyLocationIds();
				   var academicTermId = form.down('#academicTermId').getValue();
				   var courseId = form.down('#courseIdCBS').getValue();
				   form.down('#courseVariantId').setDisabled(false);
				   var courseVariantCombo = form.down('#courseVariantId');
				   courseVariantCombo.reset();
				   var courseVariantStore = courseVariantCombo.getStore();
				   courseVariantStore.getProxy().extraParams = {
					   	 courseId:courseId,
						 academyLocationIds : academyLocationIds,
						 academicTermId:academicTermId
					 };
				   courseVariantStore.load({
					   callback: function(rec, success) {
  						  if (success) {
  							  if(rec.length==1){
  								$this.getDelayedcoursesearch().down('#courseVariantId').setValue(rec[0].get('id'));
  							  }
  						  }
					   }
				   });
			   }
		   },
		   'delayedcoursesearch combo#academicTermId': {
			   select: function(obj, record) {
				   var form = this.getDelayedcoursesearch();
				   var academyLocationIds = this.getAcademyLocationIds();
				   var courseVariantCombo = form.down('#courseVariantId');
				   courseVariantCombo.reset();
				   courseVariantCombo.setDisabled(true);
				   var courseCBS = form.down('#courseIdCBS');
				   courseCBS.reset();
				   var courseStore = courseCBS.getStore();
				   var academicTermId = form.down('#academicTermId').getValue();	    	        				   
				   courseStore.getProxy().extraParams = {
						 sectionType : 'CourseSection',
						 academyLocationIds : academyLocationIds,
						 academicTermId:academicTermId
					 };
					 courseStore.load();
			   }
		   },  
		   
		   'delayedcoursesearch combo#periodId': {
			   select: function(obj, record) {
				   var periodId = record[0].get("id");
				   var form = this.getDelayedcoursesearch();
				   var sectionId = form.down('#courseIdPBS');
				   sectionId.reset();	    	        				   
				   if(periodId > 0){
					   var store = this.getStore('coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore');
					   store.getProxy().extraParams = {
						   periodId:periodId,
						   sectionType:'ProgramBatchSection'
					   };
					   store.load();
					   
					   // load section on the basis of period ID
					   var storeSection = this.getStore('coursetransaction.sectionmanagement.SectionsStore');
					   storeSection.getProxy().extraParams = {
						   periodId:periodId
					   };
					   storeSection.load();
				   }
			   }
		   },

		   'mostandleastpopularcoursesearch combo#batchId':{
			   select:function(obj, record){
				   //var form = this.getGeneralsummarysearch();
				   var form =  obj.up('form');
				   var period = form.down('#periodId');
				   period.reset();
				   period.setDisabled(false);
				   var batchId = record[0].get("id");
				   if(batchId !=''){	    	        					  
					   //var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					   var store = period.getStore();
					   store.getProxy().extraParams = {
						   id: batchId
					   };
					   store.load();
				   }
			   }
		   },
		   
		   'delayedcoursesearch combo#batchId':{
			   select:function(obj, record){
				   var form = this.getDelayedcoursesearch();
				   var period = form.down('#periodId');
				   period.reset();
				   var batchId = record[0].get("id");
				   if(batchId !=''){	    	        					  
					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					   store.getProxy().extraParams = {
						   id: batchId
					   };
					   store.load();
				   }
			   }
		   },

		   'generalsummarysearch combo#periodId': {
			   select: function(obj, record) {
				   var periodId = record[0].get("id");
				   var form = this.getGeneralsummarysearch();
				   var sectionId = form.down('#sectionId');
				   sectionId.reset();	    	        				   
				   if(periodId > 0){
					   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
					   store.getProxy().extraParams = {
						   periodId: periodId
					   };
					   store.load();
				   }
			   }
		   },
		   
		   'generalsummarysearch combo#departmentId':{
			   select : function(obj,record){
				   var departmentId = record[0].get("id");
				   var form = this.getGeneralsummarysearch();
				   var subDepartmentId = form.down('#subDepartmentId');
				   subDepartmentId.reset();
				   if(departmentId>0){
					   var store = this.getStore('department.ChildDepartmentStore');
					   store.getProxy().extraParams = {
						   parentId: departmentId
					   };
					   store.load();
				   }
			   }
		   },
		   'generalsummarysearch grid':{
  			 afterrender : function(grid) {
                   var structure=this.getDashboardmainstructure();
  			 }
           },
		   'mostandleastpopularcoursesearch button[itemId=submitBtn]':{
			   click : function(){
				   var form = this.getMostandleastpopularcoursesearch();
				   var value = form.down('#selectionTypeId').getValue();
				   if(value.selectionType=='Course Section'){
					   var store = this.getStore('programCourseDashboard.MostAndLeastPopularCoursesCBS');
					   store.load();
				   }
				   else if(value.selectionType=='Program Batch Section'){
					   var store = this.getStore('programCourseDashboard.MostAndLeastPopularCoursesPBS');
					   store.load();
				   }
				   /* store.getProxy().extraParams = {
					   parentId: 1
				   };*/

			   }
		   },

		   'generalsummarysearch button[itemId=btnSearch]':{
			   click : function(model,records){
				   var form = this.getGeneralsummarysearch();
				   var stastistics = form.down('#stastisticsId').getValue();

				   var facultyGrid = form.down('#topandbottomattendancegridforfaculty');
				   var studentGrid = form.down('#topandbottomattendancegridforstudent');
				   var  contentPanelMain = this.getContentpanel().getActiveTab();
                   contentPanelMain.scrollBy(0,1);
                   contentPanelMain.scrollBy(0,-1);
				   // Top and Bottom attendance for faculty
				   if(stastistics=='Faculty'){
					   studentGrid.setVisible(false);
					   facultyGrid.setVisible(true);
					   var values = new Object();
					   values.configCode = CONSTANTS.CB.FACULTY_ATTENDANCE_DASHBOARD_LIST_VIEWCODE;
					   var jsonFormatFormData = this.createJsonFormatForFaculty(form,records);
					   var searchResultGrid = this.getTopandbottomattendancegridforfaculty();
					   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_ATTENDANCE_DASHBOARD_LIST_VIEWCODE);
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
					   Ext.getBody().unmask();
				   } 
				   // Top and Bottom attendance for student
				   else if(stastistics=='Student'){
					   studentGrid.setVisible(true);
					   facultyGrid.setVisible(false);
					   var values = new Object();
					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_TOP_BOTTOM_ATTENDANCE_STUDENTWISE_LISTING_VIEWCODE;
					   var jsonFormatFormData = this.createJsonFormatForStudent(form,records);
					   var searchResultGrid = this.getTopandbottomattendancegridforstudent();
					   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_TOP_BOTTOM_ATTENDANCE_STUDENTWISE_LISTING_VIEWCODE);
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
					   Ext.getBody().unmask();
				   }
			   }
		   },

		   'generalsummarysearch button[itemId=btnReset]':{
			   click : function(){
				   var form = this.getGeneralsummarysearch().getForm();
				   form.reset();
			   }	                			   
		   },

		   // Top and Bottom course absenteeism search call
		   'topbottomcourseabsenteeismsearch button[itemId=btnSearch]':{
			   click : function(model, records){
				   var values = new Object();
				   values.configCode = CONSTANTS.CB.TOP_BOTTOM_COURSE_ABSENTEEISM_LISTING_VIEWCODE;
				   var form = this.getTopbottomcourseabsenteeismsearch();
				   var jsonFormatFormData = this.createJsonTopBottomCourseAbsenteeism(form,records);
				   var searchResultGrid = this.getTopBottomCourseAbsenteeismSearchGridId();
				   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
				   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TOP_BOTTOM_COURSE_ABSENTEEISM_LISTING_VIEWCODE);
				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
				   Ext.getBody().unmask();
			   }
		   }, 
		   'topbottomcourseabsenteeismsearch button[itemId=btnReset]':{
			   click : function(){
				  this.getTopbottomcourseabsenteeismsearch().getForm().reset();
			   }
		   },
		   'topbottomcourseabsenteeismsearch':{
			   render : function(){
				   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
				   var store = this.getStore('attendance.CourseLevelAttendanceCourses');
				   store.getProxy().extraParams = { 
					   academyLocationIds:acadLocationIdsCommaSepeated
				   };
				   store.load();
			   },
			    afterrender : function(structure){
			    var grid = structure.down('searchresultgrid');
			    var newstructure = structure.up('dashboardmainstructure');
			   }
		   },

		   // Top and Bottom Program absenteeism search call
		   'topbottonprogramabsenteeismsearch button[itemId=btnSearch]' :{
			   click : function(model,records){
				   var values = new Object();  
				   values.configCode = CONSTANTS.CB.PNC_TOP_BOTTOM_PROGRAM_ABSENTEEISM_LISTING_VIEWCODE;
				   var form = this.getTopbottonprogramabsenteeismsearch();
				   var jsonFormatFormData = this.createJsonTopBottomProgramAbsenteeism(form,records);
				   var searchResultGrid = this.getTopbottomprogramabsenteeismgrid();
				   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
				   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_TOP_BOTTOM_PROGRAM_ABSENTEEISM_LISTING_VIEWCODE);
				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
				   Ext.getBody().unmask();
			   }
		   },
		   
		   // Top and bottom program absenteeism reset button
		   'topbottonprogramabsenteeismsearch button[itemId=btnReset]' :{
			   click : function(){
				   var form = this.getTopbottonprogramabsenteeismsearch().getForm();
				   form.reset();
			   }
		   },
		   	                		  
		   // Most and least popular course search button
		   'mostandleastpopularcoursesearch button[itemId=btnSearch]':{
			   click : function(model,records){
				   var values = new Object();
				   var form = this.getMostandleastpopularcoursesearch();
				   
				   var searchResultGrid; 
				   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
				   
				   var mostleastpopularcoursescbsGridId = form.down('#mostleastpopularcoursescbsGridId');
				   var mostleastpopularcoursespbsGridId = form.down('#mostleastpopularcoursespbsGridId');
				   
				   var searchForm = form.getForm();
				   var mostAndLeastApplied = searchForm.findField('mostAndLeastApplied').getValue();
				   
				   var jsonFormatFormData;
				   var configCode;; 
				   if(mostAndLeastApplied){
					   mostleastpopularcoursescbsGridId.setVisible(false);
					   mostleastpopularcoursespbsGridId.setVisible(true);
					   searchResultGrid = this.getMostleastpopularcoursespbsGridId();
					   configCode = CONSTANTS.CB.PNC_DASHBOARD_MOST_POUPLAR_COURSE_LISTING_CONFIGCODE;
					   jsonFormatFormData = this.createJsonPopularCoursePBS(form,records,configCode);
//					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_MOST_POPULAR_COURSES_LISTING_CONFIGCODE;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_MOST_POUPLAR_COURSE_LISTING_VIEWCODE);   
				   }else{
					   mostleastpopularcoursescbsGridId.setVisible(true);
					   mostleastpopularcoursespbsGridId.setVisible(false);
					   searchResultGrid  = this.getMostleastpopularcoursescbsGridId();
					   configCode = CONSTANTS.CB.PNC_DASHBOARD_LEAST_POUPLAR_COURSE_LISTING_CONFIGCODE;
					   jsonFormatFormData = this.createJsonPopularCoursePBS(form,records,configCode);
//					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_LEAST_POUPLAR_COURSE_LISTING_CONFIGCODE;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_LEAST_POUPLAR_COURSE_LISTING_VIEWCODE);
				   
				   }
				   
				   
				   //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   
				   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
				   //Ext.getBody().unmask();
				   /*if(value.selectionType =='Course Section'){
					   var values = new Object();  
					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_MOST_AND_LEAST_POUPLAR_COURSECBS_LISTING_VIEWCODE;
					   var form = this.getMostandleastpopularcoursesearch();
					   var jsonFormatFormData = this.createJsonPopularCourseCBS(form,records);
					   var searchResultGrid = this.getMostleastpopularcoursescbsGridId();
					   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_MOST_AND_LEAST_POUPLAR_COURSECBS_LISTING_VIEWCODE);
					   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
				   }
				   else if(value.selectionType =='Program Batch Section'){
					   var values = new Object();  
					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_MOSTANDLEAST_COURSEPBS_LISTING_VIEWCODE;
					   var form = this.getMostandleastpopularcoursesearch();
					   var jsonFormatFormData = this.createJsonPopularCoursePBS(form,records);
					   var searchResultGrid = this.getMostleastpopularcoursespbsGridId();
					   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_MOSTANDLEAST_COURSEPBS_LISTING_VIEWCODE);
					   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
				   }*/
			   }
		   },
		   
		   // Most and least popular course reset button
		   'mostandleastpopularcoursesearch button[itemId=btnReset]' :{
			   click : function(){
				   var form = this.getMostandleastpopularcoursesearch();
				   form.getForm().reset();
				   //form.down('#programId').getStore().load();
				   form.down('#batchId').setDisabled(true);
				   form.down('#periodId').setDisabled(true);
				   form.down('#batchId').setDisabled(true);
				   form.down('#courseIdPBS').setDisabled(true);
			   }
		   },
		   'richtipchartreport': {
			   render: function(obj){
				   this.loadRichTipChartReport(obj);
			     }
			   },
			   'programsummarystructure button[itemId=searchBtn]':{
				   click: function(){
					   var str = this.getRichtipchartreport();
					   this.loadRichTipChartReport(str);
				   }	                			   
			   },
		   'searchresultgrid[itemId=programwithvacantsseatsgrid]': {
			   render: function(grid){
				   var $this = this;
				   var RESULT_GRID = this.getProgramwithvacantsseatsgrid(); 
				   this.loadDynamicGrid(CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATS_LISTING_VIEWCODE,
						   CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATS_LISTING_CONFIGCODE,RESULT_GRID);
			   },
			   // code for hyperlink
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var searchResultGrid = this.getProgramwithvacantsseatsgrid();
				   var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
				   if(columnName=='BATCH_NAME'){
					   this.linkBatchFromProgVacant(grid, rowIndex, record);
				   }
			   }
		   },

		   // General summary -> top and bottom faculty utilization
		   'searchresultgrid[itemId=topBottomFacultyUtilizationGrid]': {
			   render: function(grid){
				   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
				   var store = this.getStore('programCourseDashboard.FacultyUtilizationGridStore');
				   store.getProxy().extraParams = {
					   academyLocationIds: acadLocationIdsCommaSepeated
				   };
				   store.load();
				   /*var RESULT_GRID = this.getTopBottomFacultyUtilizationGrid();
				   this.loadDynamicGrid(CONSTANTS.CB.PNC_DASHBOARD_FACULTY_UTILICATION_LISTING_VIEWCODE,
						   CONSTANTS.CB.PNC_DASHBOARD_FACULTY_UTILICATION_LISTING_CONFIGCODE,RESULT_GRID);*/
			   }	                			   
		   },
		   
		   /******** START: Faculty Workload Report *********/
		   'facultyutilizationgrid[itemId=facultyWorkLoadReportId]': {
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				 var facultyutilizationgrid = this.getFacultyutilizationgrid();
    				 var columnName=facultyutilizationgrid.columnManager.columns[cellIndex].dataIndex;

    				 if(columnName=='noOfCourses'){
    					 if (e.target.tagName == 'A') {
    						 this.openCourseWin(grid, rowIndex, record);
    					 }
    				 }
    				 if(columnName=='noOfSessions'){
    					 if (e.target.tagName == 'A') {
    						 this.openSessionWin(grid, rowIndex, record);
    					 }
    				 }

				 }
		   },
		   'facultyutilizationgrid[itemId=facultyWorkLoadReportId] button[itemId=exportReportsId]': {
			   click: function(obj) {
				   this.facultyWorkloadXlsReportList();
			   }
		   },
			'generalsummarystructure combo#facultyCodeItemId': {
				   render: function(obj) {
					   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
					   var form = this.getGeneralsummarystructure();
					   var facultyCodeField =form.down('#facultyCodeItemId');
					   var store = facultyCodeField.getStore();
					   store.getProxy().extraParams = {
						   academyLocationIds: acadLocationIdsCommaSepeated
					   };
					   store.load();
				   }
			   },
		   'generalsummarystructure combo#programId': {
			   select: function(obj, record) {
				   var programId = record[0].get("id");
				   var form = this.getGeneralsummarystructure();
				   var batch = form.down('#batchId');
				   batch.reset();
				   if(programId > 0){
					   var store = this.getStore('enquiry.AcademicBatchStore');
					   store.getProxy().extraParams = {
						   id: programId
					   };
					   store.load();
				   }
			   }
		   },

		   'generalsummarystructure combo#batchId':{
			   select:function(obj, record){
				   var form = this.getGeneralsummarystructure();
				   var period = form.down('#periodId');
				   period.reset();
				   var batchId = record[0].get("id");
				   if(batchId !=''){                                          
					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					   store.getProxy().extraParams = {
						   id: batchId
					   };
					   store.load();
				   }
			   }
		   },

		   'generalsummarystructure combo#periodId': {
			   select: function(obj, record) {
				   var periodId = record[0].get("id");
				   var form = this.getGeneralsummarystructure();
				   var sectionId = form.down('#sectionId');
				   sectionId.reset();                                      
				   if(periodId > 0){
					   var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
					   store.getProxy().extraParams = {
						   periodId: periodId
					   };
					   store.load();
				   }
			   }
		   },

		   'generalsummarystructure button[itemId=btnReset]':{
			   click : function(){
				   var form = this.getGeneralsummarystructure().getForm();
				   form.reset();
			   }                       
		   },

		   'generalsummarystructure button[itemId=searchBtn]':{
			   click: function(grid){
				   var form = this.getGeneralsummarystructure().getForm();
				   var grid = this.getFacultyutilizationgrid();
				   var values = form.getValues();
				   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
				   var facultyId = values.facultyCodeItem;
				   var programId = values.programId;
				   var batchId = values.batchId;
				   var periodId = values.periodId;
				   var sectionId = values.sectionId;
				   var fromDate = values.fromDate;
				   var toDate = values.toDate;

				   var store = this.getStore('programCourseDashboard.FacultyUtilizationGridStore');
				   store.getProxy().extraParams = {
					   academyLocationIds: acadLocationIdsCommaSepeated,
					   facultyId: facultyId,
					   programId: programId,
					   batchId: batchId,
					   periodId: periodId,
					   sectionId: sectionId,
					   fromDate: fromDate,
					   toDate: toDate
				   };
				   store.load();
				   grid.config.searchFilterForm = this.getGeneralsummarystructure();
				   /*var RESULT_GRID = this.getTopBottomFacultyUtilizationGrid();
				   this.loadDynamicGrid(CONSTANTS.CB.PNC_DASHBOARD_FACULTY_UTILICATION_LISTING_VIEWCODE,
						   CONSTANTS.CB.PNC_DASHBOARD_FACULTY_UTILICATION_LISTING_CONFIGCODE,RESULT_GRID);*/
			   }	                			   
		   },
		   /******** END: Faculty Workload Report *********/
		   
		   'topbottonprogramabsenteeismsearch combo#programId': {
			   select: function(obj, record) {
				   var programId = record[0].get("id");
				   var form = this.getTopbottonprogramabsenteeismsearch();
				   var batch = form.down('#batchId');
				   batch.reset();
				   if(programId > 0){
					   var store = this.getStore('enquiry.AcademicBatchStore');
					   store.getProxy().extraParams = {
						   id: programId
					   };
					   store.load();
				   }
			   }
		   },

		   'topbottonprogramabsenteeismsearch combo#batchId':{
			   select:function(obj, record){
				   var form = this.getTopbottonprogramabsenteeismsearch();
				   var period = form.down('#periodId');
				   period.reset();
				   var batchId = record[0].get("id");
				   if(batchId !=''){	    	        					  
					   var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					   store.getProxy().extraParams = {
						   id: batchId
					   };
					   store.load();
				   }
			   }
		   },

		   'topbottonprogramabsenteeismsearch combo#periodId': {
			   select: function(obj, record) {
				   var periodId = record[0].get("id");
				   var form = this.getGeneralsummarysearch();
				   /*var sectionId = form.down('#sectionId');
				   sectionId.reset();*/	    	        				   
				   if(periodId > 0){
					   /*var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
					   store.getProxy().extraParams = {
						   periodId: periodId
					   };
					   store.load();*/
				   }
			   }
		   },
		   
		   // course summmary => Delayed Course
		   'delayedcoursesearch':{
			   render : function(obj,val){
				   var academyLocationIds = this.getAcademyLocationIds();
				   var form = this.getDelayedcoursesearch();
				   var value = form.down('#selectionTypeId').getValue();

				   if(value.selectionType=='PROGRAM_BATCH_SECTION'){
					   
					   var coursePBS = form.down('#courseIdPBS');
					   coursePBS.reset();
					   coursePBS.getStore().getProxy().extraParams = {
						   academyLocationIds:academyLocationIds,
						   sectionType:'ProgramBatchSection'
					   };
					   coursePBS.getStore().load();
					   
				   }else if(value.selectionType =='COURSE_SECTION'){
					   var courseCBS = form.down('#courseIdCBS');
					   courseCBS.reset();
					   var courseStore = courseCBS.getStore();
     				   var academicTermComboStore = courseAcademicTerm.getStore();
     				   academicTermComboStore.getProxy().extraParams = {
     					  academyLocationIds : academyLocationIds
     				   };
     				   academicTermComboStore.load({

     					  callback: function(rec, success) {
     						  if (success) {
     							  var j=0;
     							  for(var i in rec){
     								  if(rec[i].get('sequence')==1){
     									  j++
     									$this.getDelayedcoursesearch().down('#academicTermId').setValue(rec[i].get('id'));
     									var academicTermId =rec[i].get('id'); 
     									courseStore.getProxy().extraParams = {
											 sectionType : 'CourseSection',
											 academyLocationIds : academyLocationIds,
											 academicTermId:academicTermId
										 };
										 courseStore.load();
     								  }
     							  }
     							 if(j==0){
    								  courseStore.getProxy().extraParams = {
    										 sectionType : 'CourseSection',
    										 academyLocationIds : academyLocationIds
    									 };
    									 courseStore.load();
    							  }
     						  }
     					  }
     				   });
				   }
			   },
			   afterrender: function(){
				   this.setTabPbsCbsPermission("courseExecutionReport");
			   }
		   },
		   'delayedcoursesearch radiogroup#selectionTypeId':{
			   change : function(obj,val){
				   var $this = this;
				   var form = this.getDelayedcoursesearch();
				   var value = form.down('#selectionTypeId').getValue();
				   var program = form.down('#programId');
				   var batch = form.down('#batchId');
				   var period = form.down('#periodId');
				   var coursePBS = form.down('#courseIdPBS');
				   var courseCBS = form.down('#courseIdCBS');
				   var cbsCourseVariant = form.down('#courseVariantId');
				   var courseAcademicTerm = form.down('#academicTermId');
				   var programSectionId = form.down('#programSectionId');
				   var facultyCodeItemId = form.down('#facultyCodeItemId');
				  
				   var delayedCourseSearchGrIdPBS = form.down('#delayedCourseSearchGrIdPBS');
				   var delayedCourseSearchGrIdCBS = form.down('#delayedCourseSearchGrIdCBS');
				   
				   
				   
				   var academyLocationIds = this.getAcademyLocationIds();
				   
				   if(value.selectionType =='COURSE_SECTION'){
					   program.setVisible(false);
					   batch.setVisible(false);
					   period.setVisible(false);
					   coursePBS.setVisible(false);
					   courseCBS.setVisible(true);
					   programSectionId.setVisible(false);	
					   facultyCodeItemId.setVisible(false);
					   cbsCourseVariant.setVisible(true);
					   cbsCourseVariant.setDisabled(true);
					   cbsCourseVariant.clearValue();
					   courseAcademicTerm.setVisible(true);
					   delayedCourseSearchGrIdCBS.setVisible(true);
					   delayedCourseSearchGrIdPBS.setVisible(false);					   
					   courseCBS.reset();
					   var courseStore = courseCBS.getStore();
     				   var academicTermComboStore = courseAcademicTerm.getStore();
     				   academicTermComboStore.getProxy().extraParams = {
     					  academyLocationIds : academyLocationIds
     				   };
     				   academicTermComboStore.load({

     					  callback: function(rec, success) {
     						  if (success) {
     							  var j=0;
     							  for(var i in rec){
     								  if(rec[i].get('sequence')==1){
     									 j++
     									$this.getDelayedcoursesearch().down('#academicTermId').setValue(rec[i].get('id'));
     									var academicTermId =rec[i].get('id'); 
     									courseStore.getProxy().extraParams = {
											 sectionType : 'CourseSection',
											 academyLocationIds : academyLocationIds,
											 academicTermId:academicTermId
										 };
										 courseStore.load();
     								  }
     							  }
     							 if(j==0){
     								  courseStore.getProxy().extraParams = {
     										 sectionType : 'CourseSection',
     										 academyLocationIds : academyLocationIds
     									 };
     									 courseStore.load();
     							  }
     						  }
     					  }
     				   });
					   
				   }  else if(value.selectionType=='PROGRAM_BATCH_SECTION'){
					   program.setVisible(true);
					   batch.setVisible(true);
					   period.setVisible(true);
					   coursePBS.setVisible(true);
					   courseCBS.setVisible(false);
					   programSectionId.setVisible(true);
					   facultyCodeItemId.setVisible(true);
					   cbsCourseVariant.setVisible(false);
					   courseAcademicTerm.setVisible(false);
					   delayedCourseSearchGrIdCBS.setVisible(false);
					   delayedCourseSearchGrIdPBS.setVisible(true);
					   
					   coursePBS.reset();
					   coursePBS.getStore().getProxy().extraParams = {
						   academyLocationIds:academyLocationIds,
						   sectionType:'ProgramBatchSection'
					   };
					   coursePBS.getStore().load();
				   }
					var  contentPanelMain = this.getContentpanel().getActiveTab();
                    contentPanelMain.scrollBy(0,1);
                    contentPanelMain.scrollBy(0,-1);
				   
			   }
		   },
		   
		   'delayedcoursesearch button[itemId=btnSearch]':{
			   click : function(model,records){
				   var form = this.getDelayedcoursesearch();
				   var value = form.down('#selectionTypeId').getValue();
				   
				   if(value.selectionType =='PROGRAM_BATCH_SECTION'){
					   var values = new Object();  
					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_DELAYED_COURSEPBS_LISTING_VIEWCODE;
					   var jsonFormatFormData = this.createJsonDelayedCoursePBS(form,records);
					   var searchResultGrid = this.getDelayedCourseSearchGrIdPBS();
					   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_DELAYED_COURSEPBS_LISTING_VIEWCODE);
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
					   Ext.getBody().unmask();
				   } else if(value.selectionType =='COURSE_SECTION'){
					   var values = new Object();  
					   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_DELAYED_COURSECBS_LISTING_VIEWCODE;
					   var jsonFormatFormData = this.createJsonDelayedCourseCBS(form,records);
					   var searchResultGrid = this.getDelayedCourseSearchGrIdCBS();
					   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_DELAYED_COURSECBS_LISTING_VIEWCODE);
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
					   Ext.getBody().unmask();
				   }
			   }
		   },
		   
		   'delayedcoursesearch button[itemId=btnReset]':{
			  click : function(){
				  var $this = this;
				  var acadLocationIds = this.getAcademyLocationIds();
				  var formPbs = this.getDelayedcoursesearch().getForm();
				  var formCbs = this.getDelayedcoursesearch();
				  var value = formCbs.down('#selectionTypeId').getValue();
				  
				  if(value.selectionType =='COURSE_SECTION'){
					  formCbs.down('#courseIdCBS').clearValue();
					  formCbs.down('#academicTermId').clearValue();
					  formCbs.down('#courseVariantId').clearValue();
					  formCbs.down('#courseVariantId').setDisabled(true);
					  var courseAcademicTerm=formCbs.down('#academicTermId');
					  var academicTermComboStore = courseAcademicTerm.getStore();
    				   academicTermComboStore.getProxy().extraParams = {
    					  academyLocationIds : academyLocationId
    				   };
    				   academicTermComboStore.load({

    					  callback: function(rec, success) {
    						  if (success) {
    							  var j=0;
    							  for(var i in rec){
    								  if(rec[i].get('sequence')==1){
    									  j++
    									  $this.getDelayedcoursesearch().down('#academicTermId').setValue(rec[i].get('id'));
    									  var academicTermId = rec[i].get('id');
    									  var courseCBS = formCbs.down('#courseIdCBS');
    									   courseCBS.reset();
    									   courseCBS.getStore().getProxy().extraParams = {
    										   academyLocationIds:acadLocationIds,
    										   sectionType:'CourseSection',
    										   academicTermId:academicTermId
    									   };
    									   courseCBS.getStore().load();
    								  }
    							  }
    							  if(j==0){
    								  var courseStore = formCbs.down('#courseIdCBS').getStore();
    								  courseStore.getProxy().extraParams = {
    										 sectionType : 'CourseSection',
    										 academyLocationIds : acadLocationIds
    									 };
    									 courseStore.load();
    							  }

    						  }
    					  }
    				   });
					  
				  }else{
					  formPbs.reset(); 
					  
					  var batchId = formCbs.down('#batchId');
					  var periodId = formCbs.down('#periodId');
					  var course = formCbs.down('#courseIdPBS');
					  var programSectionId = formCbs.down('#programSectionId');
					  var facultyCodeItem = formCbs.down('#facultyCodeItemId');
					  
					  course.reset();
					  course.getStore().getProxy().extraParams = {
						   academyLocationIds:acadLocationIds,
						   sectionType:'ProgramBatchSection'
					  };
					  course.getStore().load();
					  
					  batchId.getStore().getProxy().extraParams = {
						  academyLocationId:acadLocationIds
					  };
					  batchId.getStore().load();
					 
					  periodId.getStore().getProxy().extraParams = {
						  academyLocationId:acadLocationIds
					  };
					  periodId.getStore().load();
					  
					  /*course.getStore().getProxy().extraParams = {
						  academyLocationId:acadLocationIds
					   };
					  course.getStore().load();*/
					  
					  programSectionId.getStore().getProxy().extraParams = {
						  academyLocationId:acadLocationIds
					   };
					  programSectionId.getStore().load();
					  
					  facultyCodeItem.getStore().getProxy().extraParams = {
						  academyLocationId:acadLocationIds
					   };
					  facultyCodeItem.getStore().load();
				  }
			  }   
		   },
		   'searchresultgrid[itemId=topbottomprogramabsenteeismgrid]': {
			   render:function(grid){
	  				 this.gridRenderFunction(grid);
	  				// this.genericCBGridAccessControlValidation(grid,this.getPROGRAM_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS());
	  			 },
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var searchResultGrid = this.getTopbottomprogramabsenteeismgrid();
				   var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
				   
				   var programAbsenteesmSearch = this.getTopbottonprogramabsenteeismsearch();
				   
				   if(columnName=='PROGRAM_NAME'){
					   this.detailedTab(searchResultGrid,programAbsenteesmSearch,columnName);
				   }
			   }
		   },
		   'searchresultgrid[itemId=topBottomCourseAbsenteeismSearchGridId]': {
			   render:function(grid){
					 this.gridRenderFunction(grid);
					// this.genericCBGridAccessControlValidation(grid,this.getCOURSE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS());
				 },    
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var searchResultGrid = this.getTopBottomCourseAbsenteeismSearchGridId();
				   var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

				   var courseAbsenteesmSearch = this.getTopbottomcourseabsenteeismsearch();
				   
				   if(columnName=='COURSE_NAME'){
					   this.detailedTab(searchResultGrid,courseAbsenteesmSearch,columnName);
				   }
			   }
		   },
		   'dashboardmainstructure treepanel[itemId=programDashboardReportTreePanelItemId]':{
			   itemclick : this.getOpenDashbordStructure,
			   render: function(structure) {
                   this.doAccessDashboardReportTreePnl(structure);
               }
		   },
  		 'studentcourseenrollmentreportstructure': {
          	afterrender : function(structure){
          		var grid = structure.down('studentcourseenrollmentreportgrid');
          		var newstructure = structure.up('dashboardmainstructure');
          	}
          },
          'programdetailsreport': {
            	afterrender : function(structure){
            		var grid = structure.down('searchresultgrid');
            		var newstructure = structure.up('dashboardmainstructure');
            	}
            },
            'topbottonprogramabsenteeismsearch': {
            	afterrender : function(structure){
            		var grid = structure.down('searchresultgrid');
            		var newstructure = structure.up('dashboardmainstructure');
            	}
            },
            'generalsummarystructure': {
            	afterrender : function(structure){
            		var grid = structure.down('facultyutilizationgrid');
            		var newstructure = structure.up('dashboardmainstructure');
            	}
            },      
            'delayedcoursesearch grid':{
     			 afterrender : function(grid) {
                      var structure=this.getDashboardmainstructure();
     			 }
              },
            'programpromotionstructure': {
            	afterrender : function(structure){
            		var grid = structure.down('programpromotiongrid');
            		var newstructure = structure.up('dashboardmainstructure');
            	}
            },
         /* 'courserosterreportstructure': {
            	afterrender : function(structure){
<<<<<<< HEAD
            		if(this.getCurrentLoggedPortalId()==2){
            			var grid = structure.down('courserosterreportgrid');
            			var newstructure = structure.up('personinfofacultyportal');
	            		this.getGridHeaderFreeze(grid,newstructure,false);
					}else{
						var grid = structure.down('courserosterreportgrid');
	            		var newstructure = structure.up('dashboardmainstructure');
	            		this.getGridHeaderFreeze(grid,newstructure,false);
					}
=======
            		var grid = structure.down('courserosterreportgrid');
            		var newstructure = structure.up('dashboardmainstructure');
            		//this.getGridHeaderFreeze(grid,newstructure,false);
            		if(this.getCurrentLoggedPortalId()==2){
            	    var $this = this;
   					var grid = $this.getCourserosterreportgrid();				
   					var alinfomodel = Academia.model.authentication.ALInfoModel;
   					var wheatherSchool = alinfomodel.get('wheatherSchool');
   					var facultyId=null;
   					var academyLocationIds;
   						academyLocationIds = this.getCurrentAcademyLocation();
   						facultyId=this.getCurrentlyLoggedInUser().id;
   					if(wheatherSchool) {
   						grid.columns[10].setVisible(false);
   					}
   					grid.getStore().getProxy().extraParams = {
   						facultyId : facultyId,
   						academyLocationIds : academyLocationIds,
   					};
   					$this.resetGridSetting(grid);
   					grid.getStore().load();
   					$this.deferForCourseRosterReportGrid(grid);
            	 }else{
            		 this.getGridHeaderFreeze(grid,newstructure,false);
            	 }
>>>>>>> refs/remotes/origin/V2D-29886-team2-congo-regression-branch
            	}
            },*/
          'courserosterreportstructure': {
            	afterrender : function(structure){
            		var $this = this;
            		setTimeout(function(){
            		var grid = structure.down('courserosterreportgrid');
            		var newstructure = structure.up('dashboardmainstructure');
            		//this.getGridHeaderFreeze(grid,newstructure,false);
            		if($this.getCurrentLoggedPortalId()==2){
   					 var grid = $this.getCourserosterreportgrid();				
   					 var alinfomodel = Academia.model.authentication.ALInfoModel;
   					 var wheatherSchool = alinfomodel.get('wheatherSchool');
   					 var facultyId=null;
   					 var academyLocationIds;
   					 academyLocationIds = $this.getCurrentAcademyLocation();
   					 facultyId=$this.getCurrentlyLoggedInUser().id;
   					 var courseRosterForm =  $this.getCourserosterreportsearchform();
   	            	 var academicTerm = courseRosterForm.down('#academicTerm');
   	            	 var academicTermId=academicTerm.getValue();
   					 if(wheatherSchool) {
   						grid.columns[10].setVisible(false);
   					 }
   					 grid.getStore().getProxy().extraParams = {
   						facultyId : facultyId,
   						academyLocationIds : academyLocationIds,
   						academicTermId:academicTermId
   					};
   					$this.resetGridSetting(grid);
   					grid.getStore().load();
   					$this.deferForCourseRosterReportGrid(grid);
            	 }
            	},1000);
            	}
            },
            'courserosterreportsearchform': {
            	afterrender: function(obj) {
            		var me = this;
            		var courseRosterForm =  this.getCourserosterreportsearchform();
            		var academicTerm = courseRosterForm.down('#academicTerm');
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		if(wheatherSchool){
            			courseRosterForm.down("#periodItemId").hide();
            		}else{
            			courseRosterForm.down("#periodItemId").setVisible(true);
            		}
            		var academicTermStore = academicTerm.getStore();
            		academicTermStore.load({
            			callback: function(record, operation, success) {
            				if (success) {
            					var academicTermId = 0;
            					if(record.length>0){
            						Ext.each(record, function(value) {
            							if(value.get('whetherCurrentAcademicTerm')){
            								academicTermId = value.get('id');
            								courseRosterForm.down("#academicTerm").setValue(value.get('id'));
            							}
            						});
            					}
            					if(academicTermId == 0) {
            						me.onChangeAcademicterm(courseRosterForm, null);
        						}
            				}
            			}
            		});
            	}
            },
            'studentcoursesectionreportsearchform': {
            	afterrender: function(obj) {
            		var me = this;
            		var studentcoursesectionreportsearchform =  this.getStudentcoursesectionreportsearchform();
            		var academicTerm = studentcoursesectionreportsearchform.down('#academicTerm');
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		var academicTermStore = academicTerm.getStore();
            		var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
            		academicTermStore.getProxy().extraParams = { 
            			academyLocationIds:acadLocationIdsCommaSepeated
            		};
            		academicTermStore.load({
            			callback: function(record, operation, success) {
            				if (success) {
            					var academicTermId = 0;
            					if(record.length>0){
            						Ext.each(record, function(value) {
            							if(value.get('whetherCurrentAcademicTerm')){
            								academicTermId = value.get('id');
            								studentcoursesectionreportsearchform.down("#academicTerm").setValue(value.get('id'));
            							}
            						});
            					}
            					if(academicTermId == 0) {
            						me.onChangeCourseSectionAcademicterm(studentcoursesectionreportsearchform, null);
            					}
            				}
            			}
            		});
            	}
            },
		   'courserosterreportsearchform customcombobox[itemId=academicTerm]' : {
			   change: function(obj, records){
				   var me = this;
					var form = obj.up('form');
					var academicTermId = obj.getValue();
					if(academicTermId > 0) {
						this.onChangeAcademicterm(form, academicTermId);
					}
			   }
		   },
		   'courserosterreportsearchform customcombobox[itemId=intakeYear]': {
			   select: function(obj, record) {
				   var intakeYearId =  record[0].get("id");
				   var form = this.getCourserosterreportsearchform();
				   var alinfomodel = Academia.model.authentication.ALInfoModel;
				   var wheatherSchool = alinfomodel.get('wheatherSchool');
				   var programField = form.down('#programItemId');
				   var courseField = form.down('#courseItemId');
				   var courseVariantField = form.down('#courseVariantId');
				   var academicTermField = form.down('#academicTerm');
				   var programField = form.down("#programItemId");
				   var batchField = form.down("#batchItemId");
				   var periodField = form.down("#periodItemId");
				   var sectionField = form.down("#sectionItemId");
				   var studentField= form.down("#studentId");

				   programField.reset();
				   batchField.reset();
				   periodField.reset();
				   sectionField.reset();

				   batchField.setDisabled(true);
				   periodField.setDisabled(true);
				   sectionField.setDisabled(true);
				   var academicTermId = academicTermField.getValue();
				   var studentId=studentField.getValue();
				   var courseVariantId=courseVariantField.getValue();

				   var academyLocationIds ;
				   var facultyId = null;
				   if(this.getCurrentLoggedPortalId()==2){
					   academyLocationIds = this.getCurrentAcademyLocation();
					   facultyId=this.getCurrentlyLoggedInUser().id;
				   }else{
					   academyLocationIds = this.getAcademyLocationIds();
				   }
				   if(courseField.getValue() > 0 && courseVariantField.getValue() > 0){

				   } else {
					   programField.store.getProxy().extraParams={
						   studentId: studentId,
						   academyLocationIds : academyLocationIds,
						   onlyCurrentRecord:false,
						   academicTermId: academicTermId,
						   intakeYearId:intakeYearId
					   },
					   programField.store.load({
						   callback : function(records, operation, success) {
							   if (success) {
								   if(records.length == 1) {
									   programField.setValue(records[0].data.id)
								   }else if(isNullOrEmpty(studentId)) {
									   var studentStore = studentField.getStore();
									   studentStore.getProxy().extraParams = {
										   academicTermId:academicTermId,
										   facultyId:facultyId,
										   academyLocationIds:academyLocationIds,
										   courseVariantId:courseVariantId,
										   intakeYearId:intakeYearId
									   }
									   studentStore.load();
								   }
							   }
						   }
					   });
				   }
			   }
			},
			
		   'studentcoursesectionreportsearchform customcombobox[itemId=academicTerm]' : {
			   change: function(obj, records){
				   var me = this;
					var form = obj.up('form');
					var academicTermId = obj.getValue();
					if(academicTermId > 0) {
						this.onChangeCourseSectionAcademicterm(form, academicTermId);
					}
			   }
		   },
		   'studentcoursesectionreportsearchform customcombobox[itemId=courseItemId]' : {
			   change: function(obj, records){
				   var me = this;
				   var form = obj.up('form');
				   var courseId = obj.getValue();
				   if(courseId > 0) {
					   this.onChangeCourseSectionCourseField(form, courseId);
				   }
			   }
		   },
		   'studentcoursesectionreportsearchform button[itemId=searchBtn]':{
			   click:this.loadStudentCourseSectionGridData 
		   },
		   'studentcoursesectionreportsearchform button[itemId=resetBtn]':{
			   click:function(obj, rec){
				   var me = this;
				   var form = this.getStudentcoursesectionreportsearchform();
				   var academicTermField = form.down("#academicTerm");
				   var courseField = form.down("#courseItemId");
				   var courseVarientField = form.down("#courseVariantId");

				   academicTermField.clearValue();
				   academicTermField.clearInvalid();
				   
				   courseField.clearValue();
				   courseVarientField.clearValue();

				   courseField.setDisabled(true);
				   courseVarientField.setDisabled(true);

				   var academicTermStore = academicTermField.getStore();
				   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
				   academicTermStore.getProxy().extraParams = { 
					   academyLocationIds:acadLocationIdsCommaSepeated
				   };
				   academicTermStore.load({
					   callback: function(record, operation, success) {
						   if (success) {
							   var academicTermId = 0;
							   if(record.length>0){
								   Ext.each(record, function(value) {
									   if(value.get('whetherCurrentAcademicTerm')){
										   academicTermId = value.get('id');
										   academicTermField.setValue(value.get('id'));
									   }
								   });
							   }
							   if(academicTermId == 0) {
								   me.onChangeCourseSectionAcademicterm(form, null);
							   }
						   }
					   }
				   });
			   }
		   },
		   'studentcoursesectionreportgrid':{
			   cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
				   if(e.target.tagName=='A'){
					   this.getCurrentlyEnrolledCSForStudents(record);
				   }
			   },
			   afterrender:function(grid){
   				var me = this;
   				if(!isNullOrEmpty(grid)){
					grid.getStore().removeAll(); 
					try {
						grid.down('custompagingtoolbar').hide();
					}
					catch(e){
					}
				}
   				setTimeout(function(){
   					me.addDataGridConfigButton(grid,me.getSTUDENT_COURSE_SECTION_REPORT_PERMISSIONS());
   				},1500);
   			 }
		   },
			'courserosterreportsearchform customcombobox[itemId=courseCategory]' : {
				change: function(obj, records){
					   var me = this;
						var form = obj.up('form');
						var courseCategoryId = obj.getValue();
						if(courseCategoryId > 0) {
							this.onChangeCourseCategory(form, courseCategoryId);
						}
				   }
			},
		   'courserosterreportsearchform customcombobox[itemId=courseItemId]' : {
			   change: function(obj, records){
				   var me = this;
				   var form = obj.up('form');
				   var courseId = obj.getValue();
				   if(courseId > 0) {
					   var assignSectionType = obj.getStore().findRecord('courseId', courseId).data.sectionType;
					   this.courseFieldSelection(form, courseId, assignSectionType);
				   }
			   }
		   },
			
			'courserosterreportsearchform customcombobox[itemId=courseVariantId]' : {
				change: function(obj, record){
					var me = this;
					var form = obj.up('form');
					var courseVariantId = obj.getValue();
					if(courseVariantId > 0) {
						var assignSectionType = form.getForm().findField('courseSectionType').getValue();
						this.courseVariantSelection(form, courseVariantId, assignSectionType);
					}
				}
			},
			'courserosterreportsearchform customcombobox[itemId=programItemId]' : {
				change:function(obj,records) {
					var me = this;
					var form = obj.up('form');
					var programId = obj.getValue();
					if(programId > 0) {
						this.courserosterreportProgramChange(form, programId);
					}
				}
			},
			'courserosterreportsearchform customcombobox[itemId=batchItemId]' : {
				change:function(obj, record) {
					var me = this;
					var form = obj.up('form');
					var batchId = obj.getValue();
					if(batchId > 0) {
						this.courserosterreportBatchChange(form, batchId);
					}
				}
			},
			'courserosterreportsearchform customcombobox[itemId=periodItemId]' : {
				change: function(obj, record){
					var me = this;
					var form = obj.up('form');
					var periodId = obj.getValue();
					if(periodId > 0) {
						this.periodSelection(form, periodId);
					}
				}
			},
			
			'courserosterreportsearchform customcombobox[itemId=sectionItemId]' : {
				select:function(combo,records) {
					var courseRosterForm = this.getCourserosterreportsearchform();
					var courseItemId = courseRosterForm.down("#courseItemId");
					var periodItemId = courseRosterForm.down("#periodItemId");
					var facultyName = courseRosterForm.down("#facultyItemId");
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						academyLocationIds = this.getAcademyLocationIds();
						facultyName.getStore().getProxy().extraParams={
							courseId:courseItemId.getValue(),
							periodId:periodItemId.getValue(),
							sectionId:records[0].data.sectionId,
							academyLocationIds:academyLocationIds
						};
						facultyName.getStore().load();
					}
				}
			},
			'courserosterreportsearchform customcombobox[itemId=facultyItemId]' : {
				select:function(combo,records) {
					var this$=this;
					var facultyId= records[0].data.id;
					var form = this$.getCourserosterreportsearchform();
   					var getForm=form.getForm();
   					var alternativeFacultyName=getForm.findField("alternativeFacultyName");
   					alternativeFacultyName.reset();
   					alternativeFacultyName.getStore().getProxy().extraParams={
					   facultyId:facultyId,
				  	};
   					alternativeFacultyName.getStore().load();
				}
			},
			'courserosterreportsearchform customcombobox[itemId=studentId]': {
				select: function(obj, record) {
					var studentId =  record[0].get("id");
					var form = this.getCourserosterreportsearchform();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var programField = form.down('#programItemId');
					var courseField = form.down('#courseItemId');
					var courseVariantField = form.down('#courseVariantId');
					var academicTermField = form.down('#academicTerm');
					var academicTermId = academicTermField.getValue();
					var intakeYearField =  form.down("#intakeYear");
					intakeYearField.reset();
					
					var academyLocationIds ;
					if(this.getCurrentLoggedPortalId()==2){
						academyLocationIds = this.getCurrentAcademyLocation();
					}else{
						academyLocationIds = this.getAcademyLocationIds();
					}
					if(courseField.getValue() > 0 && courseVariantField.getValue() > 0){

					} else {
						programField.store.getProxy().extraParams={
							studentId: studentId,
							academyLocationIds : academyLocationIds,
							onlyCurrentRecord:false,
							academicTermId: academicTermId
						},
						programField.store.load({
							callback : function(records, operation, success) {
								if (success) {
									if(records.length == 1) {
										programField.setValue(records[0].data.id)
									}
								}
							}
						});
					}
				}
			},
		    'generatetabulationreportwin[itemId=generatecourserosterreportwin] button[itemId=submitBtn]':{
  			   click:function(obj){
  				   var $this = this;
  				   $this.generateCourseRosterReport();
  			   }
  		   	},
  		   'generatetabulationreportwin[itemId=generatecourserosterreportwin] button[itemId=previewTemplateBtn]':{
  			   click:function(obj){
  				   var $this=this;
  				   var filterForm=$this.getGeneratecourserosterreportwin();
  				   var templateField=filterForm.down('#chooseTemplate');
  				   if(!isNullOrEmpty(templateField.getValue())){
  					   var formWindow = $this.getPreviewtemplate();
  					   if (!formWindow) {
  						   Ext.widget('previewtemplate');
  						   formWindow = $this.getPreviewtemplate();
  					   }
  					   formWindow.show();

  					   var previewForm = $this.getPreviewtemplate();

  					   var templateId = templateField.getValue();
  					   var id=null;
  					   var url = SERVERURL.TEMPLATE_FIND_BY_ID;
  					   Ext.Ajax.request({
  						   type : 'rest',
  						   url : url,
  						   params : {
  							   id : templateId
  						   },
  						   method : 'GET',
  						   success : function(response) {
  							   var data = Ext.decode(response.responseText);
  							   id = data.reportTemplate.id;

  							   if(!isNullOrEmpty(data.reportTemplate)){
  								   var url = SERVERURL.TEMPLATE_PREVIEW;
  								   Ext.Ajax.request({
  									   type: 'rest',
  									   binary: true,
  									   url: url+'?id='+data.reportTemplate.id,
  									   method: 'GET',
  									   success : function(response){
  										   if(response.responseBytes.length>0){
  											   var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
  											   if(!isNullOrEmpty(blob) && blob != undefined){
  												   var url = window.URL.createObjectURL(blob);
  												   var a=previewForm.down("#profile_image");
  												   a.getEl().dom.src=url;
  											   }
  										   }
  									   }
  								   });
  							   }
  						   }
  					   });
  				   }
  			   }
  		    },
			'courserosterreportgrid[itemId=courserosterreportGridId] button[itemId=exportCourseRosterReportsId]':{
  			   click:function(obj){
  				   var $this=this;
  				   var tempalte = $this.getStore('setup.templatemapping.TemplateNameListFacultyByCode');
      				    tempalte.getProxy().extraParams={
     					    reportType:'Course Roster Report'
  				   };
  				   tempalte.load({
   					   callback:function(record) {
   						   if(record.length==1) {
   							   $this.generateCourseRosterReport(record[0].data.value);
   						   } else {
   							   var formWindow = $this.getGeneratecourserosterreportwin();
  							   if (!formWindow) {
  								   formWindow = Ext.widget('generatetabulationreportwin',{
       				        			itemId:'generatecourserosterreportwin'
       				        	   });
  							   }
   							   formWindow.setHeight(160);
   							   formWindow.setWidth(500);
   							   formWindow.show();
   							   var tempalte = formWindow.down('#chooseTemplate').getStore();
   							   tempalte.getProxy().extraParams={
   								   reportType:'Course Roster Report'
   							   };
   							   tempalte.load();
   						   }
   					   }
   				  });
  			   }
  			},
			'courserosterreportgrid[itemId=courserosterreportGridId]': {
				render:function(grid){
					/*this.doAccessControlValidation(grid, this.getPANDCDASHBOARD_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getPANDCDASHBOARD_PERMISSIONS());*/
					this.doAccessControlValidation(grid, this.getCOURSE_ROSTER_REPORT_ON_TREE_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getCOURSE_ROSTER_REPORT_ON_TREE_PERMISSIONS());
					if(this.getCurrentLoggedPortalId()==2){
						this.doAccessControlValidation(grid,this.getEMPLOYEE_COURSE_ROSTER_REPORT_PERMISSIONS());
	                    this.disableMoreActionPivileges(grid, this.getEMPLOYEE_COURSE_ROSTER_REPORT_PERMISSIONS());
						for(var i=grid.columns.length-1;i>=0;i--) {
     					   var column = grid.columns[i];
     					   if(column.dataIndex == 'facultyName' || column.dataIndex == 'sectionName'){
     						   column.hide();
     						   column.hidden = true;
     					   }
     				   }
					}
				}, 
				  afterrender:function(grid){
      				 var me =this;
      				setTimeout(function(){ 
      					if(portalId==1){
      						me.addDataGridConfigButton(grid, me.getCOURSE_ROSTER_REPORT_ON_TREE_PERMISSIONS());
      					} else if(portalId==2){
      						me.addDataGridConfigButton(grid, me.getFACULTY_PORTAL_COURSE_ROASTER_REPORT_PERMISSION());
      					}
      				},1500)
      				},
      		
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					var dataIndex = View.up('grid').columnManager.getColumns()[ColIdx].dataIndex;
			        var portalInfo = Academia.model.authentication.StudentERPInfoModel;
					if(dataIndex == 'studentCode'){
						if (e.target.tagName == 'A') {
							var tabTitle = record.data.studentCode;
							var personId = record.data.personId;
							var programBatchSeatTypeConfigId = record.data.progBatchSeatConfigId;
							var userId = record.data.studentId; 
							var admissionId= record.data.admissionId; 
							Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
							var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
							var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
							personController.isProfilePicSaved = false;
							personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
							/*var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
							var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
							if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
								var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
								studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
							}*/
							Ext.Ajax.request({
				    			type: 'rest',
				    			url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+userId,
				    			method: 'GET',
				    			async: false,
				    			success: function(res, action) {
				    				var data = Ext.decode(res.responseText);
				    				
				    				portalInfo.set('admissionDetails',data[0].admissionDetails);
				    				portalInfo.set('student',data[0].student);
				    				portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
				    				portalInfo.set('programBatchDetails',data[0].programBatchDetails);
				    				portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
				    			}
				    		});
						}
					}
				},
	    		selectionchange: function(column, selected, eOpts ){
                	this.disableExtraButton(column,selected);                	
                }
			},
			'courserosterreportsearchform combo#studentId':{
				select : function(obj,record){
					var this$ = this;
					var form = this$.getCourserosterreportsearchform();
					var activeStatus = record[0].get("activeStatus");
					form.down("#studentId").setValue(record[0].get('id'));
					form.down('#statusComboItemId').setValue(activeStatus);
				}
			},
			'courserosterreportsearchform button[itemId=resetBtn]' : {
				click:function(obj, rec){
					var form = this.getCourserosterreportsearchform();
					var academicTermField = form.down("#academicTerm");
					var courseField = form.down("#courseItemId");
					var courseVarientField = form.down("#courseVariantId");
					var programField = form.down("#programItemId");
					var batchField = form.down("#batchItemId");
					var periodField = form.down("#periodItemId");
					var sectionField = form.down("#sectionItemId");
					var studentField= form.down("#studentId");
					var facultyField = form.down("#facultyItemId"); 
					var alternateFacultyField =  form.down("#alternativeFacultyItemId");
					var courseCategoryField =  form.down("#courseCategory");
					var intakeYearField =  form.down("#intakeYear");

					academicTermField.clearValue();
					courseField.clearValue();
					courseVarientField.clearValue();
					programField.clearValue();
					batchField.clearValue();
					periodField.clearValue();
					sectionField.clearValue();
					studentField.clearValue();
					facultyField.clearValue();
					alternateFacultyField.clearValue();
					courseCategoryField.clearValue();
					intakeYearField.clearValue();

					courseVarientField.setDisabled(true);
					programField.setDisabled(false);
					batchField.setDisabled(true);
					periodField.setDisabled(true);
					sectionField.setDisabled(true);
					form.down("#statusComboItemId").setValue(true);
					var academicTermStore = academicTermField.getStore();
            		academicTermStore.load({
            			callback: function(record, operation, success) {
            				if (success) {
            					if(record.length>0){
            						Ext.each(record, function(value) {
            							if(value.get('whetherCurrentAcademicTerm')){
            								form.down("#academicTerm").setValue(value.get('id'));
            							}
            						});
            					}
            				}
            			}
            		});
				}
			},
			'courserosterreportsearchform button[itemId=searchBtn]' : {
				click:function(obj, rec){
 				  var $this = this;
					var grid = $this.getCourserosterreportgrid();				
					var courseRosterForm = this.getCourserosterreportsearchform();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var courseItemId = courseRosterForm.down("#courseItemId");
					var studentField = courseRosterForm.down("#studentId");
					var formValues = courseRosterForm.getValues();
					var facultyId=null;
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						academyLocationIds = this.getCurrentAcademyLocation();
						facultyId=this.getCurrentlyLoggedInUser().id;
					}else{
						academyLocationIds = this.getAcademyLocationIds();
						facultyId=formValues.facultyName;
					}
					
					var studentId=null;
					if(!isNaN(formValues.STUDENT_ID)){
						studentId=formValues.STUDENT_ID
					}else{
						try{
							if(studentField.getStore().isLoading()){
								studentField.lastQuery = null;
								studentField.getStore().rejectChanges();
							}
							setTimeout(function(){
								studentField.reset();
							},100);
						}catch(e){

						}
					}
					var courseId=null;
					if(!isNaN(formValues.courseId)){
						courseId=formValues.courseId
					}else{
						try{
							if(courseItemId.getStore().isLoading()){
								courseItemId.lastQuery = null;
								courseItemId.getStore().rejectChanges();
							}
							setTimeout(function(){
								courseItemId.reset();
							},100);
						}catch(e){

						}
					}
					
					grid.getStore().getProxy().extraParams = {
						admissionId : formValues.studentName,
						courseId : courseId,
						programId : formValues.programId,
						batchId : formValues.batchId,
						periodId : formValues.periodId,
						sectionId : formValues.sectionId,
						facultyId : facultyId,
						academyLocationIds : academyLocationIds,
						intakeYearId : formValues.intakeYear,
						academicTermId : formValues.academicTerm,
						courseVariantId:formValues.COURSE_VARIENT_ID,
						studentId:studentId,
						courseCategoryId:formValues.courseCategory,
						alternativeFacultyId:formValues.alternativeFacultyName,
						activeStatus: formValues.STATUS
					};
					$this.resetGridSetting(grid);
					grid.getStore().load();
					$this.deferForCourseRosterReportGrid(grid);
					grid.getSelectionModel().deselectAll();
					grid.config.searchFilterForm = $this.getCourserosterreportsearchform();;
				}
			},
			
			//*****************************************
			
			
			'sectionrosterreportsearchform' :{
				render:function() {
					var me = this;
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var programgroupname= sectionRosterForm.down("#programGroupId");
					var facultyItemId = sectionRosterForm.down("#facultyItemId");
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					   var wheatherSchool = alinfomodel.get('wheatherSchool');
					   if(wheatherSchool){
						   sectionRosterForm.down("#periodItemId").hide();
						   sectionRosterForm.down("#periodItemId").allowBlank=true;
					   }else{
						   sectionRosterForm.down("#periodItemId").setVisible(true);
					   }
					/**
					 * for faculty portal portal id is 2
					 */
					var facultyId=null;
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						facultyId=this.getCurrentlyLoggedInUser().id;
						academyLocationIds = this.getCurrentAcademyLocation();
						facultyItemId.reset();
						facultyItemId.setVisible(false);
					}else{
						academyLocationIds = this.getAcademyLocationIds();
						facultyItemId.setVisible(true);
						facultyItemId.reset();
						facultyItemId.getStore().getProxy().extraParams={
							academyLocationIds:academyLocationIds
	     				};
						facultyItemId.getStore().load();
					}
					programgroupname.getStore().on('beforeload',function(){
						var sectionRosterForm = me.getSectionrosterreportsearchform();
						var programgroupname= sectionRosterForm.down("#programGroupId");
						if(me.getCurrentLoggedPortalId()==2){
							var academyLocationIds = me.getCurrentAcademyLocation();
							var facultyId=me.getCurrentlyLoggedInUser().id;
						}else{
							var academyLocationIds = me.getAcademyLocationIds();
						}
						programgroupname.getStore().getProxy().extraParams={
							academyLocationIds:academyLocationIds,
							facultyId:facultyId
						};
						
					});
					var programName = sectionRosterForm.down("#programItemId");
					var store=programName.getStore();
					store.getProxy().extraParams={
						facultyId:facultyId,
						forReport:true,
						whetherSchool:true,
						academyLocationIds:academyLocationIds
					};
					store.load();
					
				}
			},
			
			'sectionrosterreportsearchform multiselectcombofield[itemId=programGroupId]' : {
				/*select:function(combo,records) {
					var $this=this;
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var programGroupIds = [];
					var facultyId=null;
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						facultyId=this.getCurrentlyLoggedInUser().id;
						academyLocationIds = this.getCurrentAcademyLocation();						
					}else{
						academyLocationIds = this.getAcademyLocationIds();						
					}
					Ext.each(records, function(value) {
		    			if(value instanceof Object){
		    				programGroupIds.push(value.get('longValue'));
		    			}
					});
					var programName = sectionRosterForm.down("#programItemId");
					var store=programName.getStore();
					store.getProxy().extraParams={
						facultyId:facultyId,
						academyLocationIds:academyLocationIds,
						programGroupIds:programGroupIds.join()
					};
					store.load();
				},*/
				change: function(combo) {
					var me = this;
					setTimeout(function(){
						var records = combo.getValue();
						var sectionRosterForm = me.getSectionrosterreportsearchform();
						var programGroupIds = [];
						var facultyId=null;
						var academyLocationIds;
						if(me.getCurrentLoggedPortalId()==2){
							facultyId=me.getCurrentlyLoggedInUser().id;
							academyLocationIds = me.getCurrentAcademyLocation();						
						}else{
							academyLocationIds = me.getAcademyLocationIds();						
						}
						Ext.each(records, function(value) {
			    			if(value instanceof Object){
			    				programGroupIds.push(value.get('id'));
			    			}
						});
						var programName = sectionRosterForm.down("#programItemId");
						programName.reset();
						var store=programName.getStore();
						store.getProxy().extraParams={
							facultyId:facultyId,
							forReport:true,
							whetherSchool:true,
							academyLocationIds:academyLocationIds,
							programGroupIds:programGroupIds.join()
						};
						store.load();
					},500);
				}
			},
			
			
			'sectionrosterreportsearchform multiselectcombofield[itemId=programItemId]' : {
				change:function(combo) {
					var $this=this;
					setTimeout(function(){
						var records = combo.getValue();
						var sectionRosterForm = $this.getSectionrosterreportsearchform();
						var batchName = sectionRosterForm.down("#batchItemId");	
						var periodItemId = sectionRosterForm.down("#periodItemId");		
						var sectionItemId = sectionRosterForm.down("#sectionItemId");
						var courseItemId = sectionRosterForm.down("#courseItemId");
						var facultyItemId = sectionRosterForm.down("#facultyItemId");
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						var intakeYear=sectionRosterForm.down("#intakeYear").getValue();
						sectionItemId.reset();
						sectionItemId.setDisabled(true);
						periodItemId.setDisabled(true);
						periodItemId.reset();
						batchName.setDisabled(false);
						batchName.reset();					
						
						if(!Ext.isDefined(records) || (records.length==1 && isNullOrEmpty(records[0]))){
							batchName.setDisabled(true);
						}
						var programIds = [];
						Ext.each(records, function(value) {
							if(value instanceof Object){
								programIds.push(value.get('id'));
							}
						});
						if($this.getCurrentLoggedPortalId()==2){
							
						}else{
							var academyLocationIds = $this.getAcademyLocationIds();
							facultyItemId.reset();
							facultyItemId.getStore().getProxy().extraParams={
								academyLocationIds:academyLocationIds,
								programIds:programIds.join()
		     				};
							facultyItemId.getStore().load();
						}
						if(programIds.length>0){
						batchName.getStore().getProxy().extraParams={
							programIds:programIds.join(),
							intakeYearId:intakeYear
						};
						batchName.getStore().load({
							callback: function(records, operation, success) {
								if (success) {
									var batchId = 0;
									for(var i=0,j=0; i<records.length; i++){
										if (records.length == 1) {
											batchId = records[i].data.id;
										} 
									}
								}
								if(batchId > 0){
									batchName.setValue(batchId);
									periodItemId.enable();

									var periodName = periodItemId.getStore();
									periodName.getProxy().extraParams = {
										id:batchId
									};
									periodName.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length == 0){
													if(wheatherSchool) {
														showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
													}
												} else if(records.length == 1){
													var periodId = records[0].data.id;
													periodItemId.setValue(periodId);
													sectionItemId.reset();
													sectionItemId.setDisabled(false);
													var facultyId = null;
										 	    	if($this.getCurrentLoggedPortalId()==2){		 	    		   
										 	    		facultyId=$this.getCurrentlyLoggedInUser().id;
										 	    	}
													sectionItemId.getStore().getProxy().extraParams={
														facultyId: facultyId,
														periodId:periodId
													};
													sectionItemId.getStore().load();
													var academyLocationIds;
													if($this.getCurrentLoggedPortalId()==2){
														academyLocationIds = $this.getAcademyLocationIds();
														var facultyName = sectionRosterForm.down("#facultyItemId");
														facultyName.reset();
														facultyName.getStore().getProxy().extraParams={
															courseId:courseItemId.getValue(),
															periodId:periodId,
															academyLocationIds:academyLocationIds
														};
														facultyName.getStore().load();
													}

													if(wheatherSchool) {
														periodItemId.setVisible(false);
													}
												} else {
													periodItemId.setVisible(true);
												}
											}
										}
									});
								}
							}	   
						});}
						else if(programIds.length==0 && records.length!=0)
							{
							batchName.getStore().getProxy().extraParams={
								programIds:records,
								intakeYearId:intakeYear
							};
							batchName.getStore().load({
								callback: function(records, operation, success) {
									if (success) {
										var batchId = 0;
										for(var i=0,j=0; i<records.length; i++){
											if (records.length == 1) {
												batchId = records[i].data.id;
											} 
										}
									}
									if(batchId > 0){
										batchName.setValue(batchId);
										periodItemId.enable();

										var periodName = periodItemId.getStore();
										periodName.getProxy().extraParams = {
											id:batchId
										};
										periodName.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 0){
														if(wheatherSchool) {
															showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
														}
													} else if(records.length == 1){
														var periodId = records[0].data.id;
														periodItemId.setValue(periodId);
														sectionItemId.reset();
														sectionItemId.setDisabled(false);
														var facultyId = null;
											 	    	if($this.getCurrentLoggedPortalId()==2){		 	    		   
											 	    		facultyId=$this.getCurrentlyLoggedInUser().id;
											 	    	}
														sectionItemId.getStore().getProxy().extraParams={
															facultyId: facultyId,
															periodId:periodId
														};
														sectionItemId.getStore().load();
														var academyLocationIds;
														if($this.getCurrentLoggedPortalId()==2){
															academyLocationIds = $this.getAcademyLocationIds();
															var facultyName = sectionRosterForm.down("#facultyItemId");
															facultyName.reset();
															facultyName.getStore().getProxy().extraParams={
																courseId:courseItemId.getValue(),
																periodId:periodId,
																academyLocationIds:academyLocationIds
															};
															facultyName.getStore().load();
														}

														if(wheatherSchool) {
															periodItemId.setVisible(false);
														}
													} else {
														periodItemId.setVisible(true);
													}
												}
											}
										});
									}
								}	   
							});
							}
					},500);
				}
			},
			
			'sectionrosterreportsearchform customcombobox[itemId=batchItemId]' : {
				select:function(combo,records) {
					var $this = this;
					var batchId = records[0].data.id;
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var periodItemId = sectionRosterForm.down("#periodItemId");		
					var sectionItemId = sectionRosterForm.down("#sectionItemId");
					var courseItemId = sectionRosterForm.down("#courseItemId");
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					sectionItemId.reset(); 
					sectionItemId.setDisabled(true);
					
					periodItemId.setDisabled(false);
					periodItemId.reset();
					
					periodItemId.getStore().getProxy().extraParams={
						id:batchId
     				};
					periodItemId.getStore().load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 0){
									if(wheatherSchool) {
										showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
									}
								} else if(records.length == 1){
									var facultyId = null;
						 	    	if($this.getCurrentLoggedPortalId()==2){
						 	    		facultyId=$this.getCurrentlyLoggedInUser().id;
						 	    	}
									var periodId = records[0].data.id;
									periodItemId.setValue(periodId);
									sectionItemId.reset();
									sectionItemId.setDisabled(false);
									sectionItemId.getStore().getProxy().extraParams={
										facultyId: facultyId,
										periodId:periodId
									};
									sectionItemId.getStore().load();
									var academyLocationIds;
									if($this.getCurrentLoggedPortalId()==2){
										academyLocationIds = $this.getAcademyLocationIds();
										var facultyName = sectionRosterForm.down("#facultyItemId");
										facultyName.reset();
										facultyName.getStore().getProxy().extraParams={
											courseId:courseItemId.getValue(),
											periodId:records[0].data.id,
											academyLocationIds:academyLocationIds
										};
										facultyName.getStore().load();
									}
									if(wheatherSchool) {
										periodItemId.setVisible(false);
									}
								} else {
									periodItemId.setVisible(true);
								}
							}
						}
					});
				}
			},
		    'generatetabulationreportwin[itemId=generatesectionrosterreportwin] button[itemId=submitBtn]':{
  			   click:function(obj){
  				   var $this = this;
  				   $this.generateSectionRosterReport();
  			   }
  		   	},
  		   'generatetabulationreportwin[itemId=generatesectionrosterreportwin] button[itemId=previewTemplateBtn]':{
  			   click:function(obj){
  				   var $this=this;
  				   var filterForm=$this.getGeneratesectionrosterreportwin();
  				   var templateField=filterForm.down('#chooseTemplate');
  				   if(!isNullOrEmpty(templateField.getValue())){
  					   var formWindow = $this.getPreviewtemplate();
  					   if (!formWindow) {
  						   Ext.widget('previewtemplate');
  						   formWindow = $this.getPreviewtemplate();
  					   }
  					   formWindow.show();

  					   var previewForm = $this.getPreviewtemplate();

  					   var templateId = templateField.getValue();
  					   var id=null;
  					   var url = SERVERURL.TEMPLATE_FIND_BY_ID;
  					   Ext.Ajax.request({
  						   type : 'rest',
  						   url : url,
  						   params : {
  							   id : templateId
  						   },
  						   method : 'GET',
  						   success : function(response) {
  							   var data = Ext.decode(response.responseText);
  							   id = data.reportTemplate.id;

  							   if(!isNullOrEmpty(data.reportTemplate)){
  								   var url = SERVERURL.TEMPLATE_PREVIEW;
  								   Ext.Ajax.request({
  									   type: 'rest',
  									   binary: true,
  									   url: url+'?id='+data.reportTemplate.id,
  									   method: 'GET',
  									   success : function(response){
  										   if(response.responseBytes.length>0){
  											   var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
  											   if(!isNullOrEmpty(blob) && blob != undefined){
  												   var url = window.URL.createObjectURL(blob);
  												   var a=previewForm.down("#profile_image");
  												   a.getEl().dom.src=url;
  											   }
  										   }
  									   }
  								   });
  							   }
  						   }
  					   });
  				   }
  			   }
  		    },
			'sectionrosterreportgrid[itemId=sectionrosterreportGridId] button[itemId=exportSectionRosterReportsId]':{
  			   click:function(obj){
  				   var $this=this;
  				 var tempalte = $this.getStore('setup.templatemapping.TemplateNameListFacultyByCode');
				    tempalte.getProxy().extraParams={
					    reportType:'Section Roster Report'
				   };
				   tempalte.load({
					   callback:function(record) {
						   if(record.length==0) {
							   $this.generateSectionRosterReport('SECTION_ROSTER_REPORT');
						   } else
						   if(record.length==1) {
							   $this.generateSectionRosterReport(record[0].data.value);
						   } else {
							   var formWindow = $this.getGeneratesectionrosterreportwin();
							   if (!formWindow) {
								   formWindow = Ext.widget('generatetabulationreportwin',{
					        			itemId:'generatesectionrosterreportwin'
					        	   });
							   }
							   formWindow.setHeight(160);
							   formWindow.setWidth(500);
							   formWindow.show();
							   var tempalte = formWindow.down('#chooseTemplate').getStore();
							   tempalte.getProxy().extraParams={
								   reportType:'Section Roster Report'
							   };
							   tempalte.load();
						   }
					   }
				  });
  				  
  			   }
  			},
			'sectionrosterreportgrid[itemId=sectionrosterreportGridId]': {
				render:function(grid){
					/*this.doAccessControlValidation(grid, this.getPANDCDASHBOARD_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getPANDCDASHBOARD_PERMISSIONS());*/
					this.doAccessControlValidation(grid, this.getSECTION_ROSTER_REPORT_PERMISSIONS());
                    this.disableMoreActionPivilegesSRR(grid, this.getSECTION_ROSTER_REPORT_PERMISSIONS());
					if(this.getCurrentLoggedPortalId()==2){
						this.doAccessControlValidation(grid,this.getEMPLOYEE_SECTION_ROSTER_REPORT_PERMISSIONS());
	                    this.disableMoreActionPivilegesSRR(grid, this.getEMPLOYEE_SECTION_ROSTER_REPORT_PERMISSIONS());						
					}
				}, 
				 afterrender:function(grid){
     				 var me =this;
     				setTimeout(function(){ 
     					me.addDataGridConfigButton(grid, me.getSECTION_ROSTER_REPORT_PERMISSIONS());
     				},1500)
     				},
     			 
				cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					if (e.target.tagName == 'A') {
						var sectionRosterGrid = View.up('grid')
						var sectionRosterGridColumns = sectionRosterGrid.columnManager.columns;
						var currentColumn = sectionRosterGridColumns[ColIdx];
						if(!isNullOrEmpty(currentColumn)){
							if(currentColumn.dataIndex=="studentCode"){
								var tabTitle = record.data.studentCode;
								var personId = record.data.personId;
								var programBatchSeatTypeConfigId = record.data.progBatchSeatConfigId;
								var userId = record.data.studentId; 
								var admissionId= record.data.admissionId; 
								Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
								var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
								var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
								personController.isProfilePicSaved = false;
								personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
								/*var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
								var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
								if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
									var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
									studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
								}*/
							}
						}
					}
				}
			},
			
			'sectionrosterreportsearchform customcombobox[itemId=periodItemId]' : {
				select:function(combo,records) {
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var sectionItemId = sectionRosterForm.down("#sectionItemId");
					sectionItemId.reset();
					sectionItemId.setDisabled(false);
					var periodId = records[0].data.id;
					var facultyId = null;
		 	    	if(this.getCurrentLoggedPortalId()==2){		 	    		   
		 	    		facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	}
					sectionItemId.getStore().getProxy().extraParams={
						facultyId: facultyId,
						periodId:records[0].data.id
     				};
					sectionItemId.getStore().load();
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						academyLocationIds = this.getAcademyLocationIds();
						var facultyName = sectionRosterForm.down("#facultyItemId");
						var courseItemId = sectionRosterForm.down("#courseItemId");
						facultyName.reset();
						facultyName.getStore().getProxy().extraParams={
							courseId:courseItemId.getValue(),
							periodId:periodId,
							academyLocationIds:academyLocationIds
						};
						facultyName.getStore().load();
					}
				}
			},
			
			'sectionrosterreportsearchform customcombobox[itemId=sectionItemId]' : {
				select:function(combo,records) {
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var courseItemId = sectionRosterForm.down("#courseItemId");
					var periodItemId = sectionRosterForm.down("#periodItemId");
					var facultyName = sectionRosterForm.down("#facultyItemId");
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						academyLocationIds = this.getAcademyLocationIds();
						facultyName.getStore().getProxy().extraParams={
							courseId:courseItemId.getValue(),
							periodId:periodItemId.getValue(),
							sectionId:records[0].data.sectionId,
							academyLocationIds:academyLocationIds
						};
						facultyName.getStore().load();
					}
				}
			},
			 'sectionrosterreportsearchform  customcombobox[itemId=intakeYear]': {
				   select: function(obj, record) {
					   var intakeYearId =  record[0].get("id");
					   var form = this.getSectionrosterreportsearchform();
					   var alinfomodel = Academia.model.authentication.ALInfoModel;
					   var wheatherSchool = alinfomodel.get('wheatherSchool');
					   var programField = form.down('#programItemId');
					   var programField = form.down("#programItemId");
					   var batchField = form.down("#batchItemId");
					   var periodField = form.down("#periodItemId");
					   var sectionField = form.down("#sectionItemId");

					   programField.reset();
					   batchField.reset();
					   periodField.reset();
					   sectionField.reset();

					   batchField.setDisabled(true);
					   periodField.setDisabled(true);

					   var academyLocationIds ;
					   var facultyId = null;
					   if(this.getCurrentLoggedPortalId()==2){
						   academyLocationIds = this.getCurrentAcademyLocation();
						   facultyId=this.getCurrentlyLoggedInUser().id;
					   }else{
						   academyLocationIds = this.getAcademyLocationIds();
					   }
						   programField.store.getProxy().extraParams={
							   academyLocationIds : academyLocationIds,
							   intakeYearId:intakeYearId
						   },
						   programField.store.load({
							   callback : function(records, operation, success) {
								   if (success) {
									   if(records.length == 1) {
										   programField.setValue(records[0].data.id);
									   }
								   }
							   }
						   });
				   }			
				   
				},
			'sectionrosterreportsearchform button[itemId=resetBtn]' : {
				click:function(obj, rec){
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var batchName = sectionRosterForm.down("#batchItemId");
					batchName.setDisabled(true);
					var facultyName = sectionRosterForm.down("#facultyItemId");
					facultyName.reset();
					var programItemId = sectionRosterForm.down("#programItemId");
					programItemId.reset();
					var academyLocationIds;
					var facultyId;
					if(this.getCurrentLoggedPortalId()==2){
						facultyId=this.getCurrentlyLoggedInUser().id;
						academyLocationIds = this.getCurrentAcademyLocation();
						facultyName.setVisible(false);
					}else{
						facultyName.setVisible(true);
						academyLocationIds = this.getAcademyLocationIds();
						facultyName.getStore().getProxy().extraParams={
							academyLocationIds:academyLocationIds
	     				};
						facultyName.getStore().load();
					}
					
					
					var intakeYear = sectionRosterForm.down('#intakeYear');
					   intakeYear.reset();
					   intakeYear.getStore().load();
					   
					   var programGroupId = sectionRosterForm.down('#programGroupId');
					   var store = programGroupId.getStore();
					   store.getProxy().extraParams.academyLocationIds = academyLocationIds;
					   store.load();
					   setTimeout(function(){
						   programGroupId.reset();
						   programGroupId.clearValue();
					   },10);
					   
					   programItemId.getStore().getProxy().extraParams={
							academyLocationIds:academyLocationIds,
							facultyId:facultyId,
							forReport:true,
							whetherSchool:true
	     				};
					   programItemId.getStore().load();
//					programItemId.setDisabled(true);
					
					var periodName = sectionRosterForm.down("#periodItemId");
					periodName.setDisabled(true);
					
					var sectionName = sectionRosterForm.down("#sectionItemId");
					sectionName.setDisabled(true);
					sectionRosterForm.getForm().reset();
				},
			},
			'sectionrosterreportsearchform button[itemId=searchBtn]' : {
				click:function(obj, rec){
 				  var $this = this;
					var grid = $this.getSectionrosterreportgrid();				
					var sectionRosterForm = this.getSectionrosterreportsearchform();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var formValues = sectionRosterForm.getValues();
					var facultyId=null;
					var academyLocationIds;
					if(this.getCurrentLoggedPortalId()==2){
						academyLocationIds = this.getCurrentAcademyLocation();
						facultyId=this.getCurrentlyLoggedInUser().id;
					}else{
						academyLocationIds = this.getAcademyLocationIds();
						facultyId=formValues.facultyName;
					}
					if(wheatherSchool) {
						grid.columns[4].setVisible(false);
					}
					var programGroupIds = [];
					Ext.each(formValues.PROGRAM_GROUP, function(value) {
		    			if(value instanceof Object){
		    				programGroupIds.push(value.get('id'));
		    			}
					});
					var programIds = [];
					Ext.each(formValues.programId, function(value) {
		    			if(value instanceof Object){
		    				programIds.push(value.get('id'));
		    			}
					});
					grid.getStore().getProxy().extraParams = {
						programGroupIds : programGroupIds.join(),
						programIds : programIds.join(),
						batchId : formValues.batchId,
						periodId : formValues.periodId,
						sectionId : formValues.sectionId,
						facultyId : facultyId,
						academyLocationIds : academyLocationIds,
						intakeYearId : formValues.intakeYear
					};
					$this.resetGridSetting(grid);
					grid.getStore().load();
					grid.config.searchFilterForm = sectionRosterForm;
//					$this.deferForSectionRosterReportGrid(grid);
				}
			},
			
			
			
			
			
			
			
			//*******************************************
			
			'programpromotionstructure form combo#intakeYearId': {
				
				select: function(obj, record) {
					var $this =  this;
					var intakeYearId = record[0].get("id");
					var form = this.getProgramPromotionForm();
					var programCombo = form.down('#programId');
					var period = form.down('#periodId');
					var batchCombo = form.down('#batchId');
					programCombo.reset();
					programCombo.clearValue();
					batchCombo.reset();
					batchCombo.clearValue();
					batchCombo.setDisabled(true);
					period.setDisabled(true);
					period.clearValue();
					var section = form.down('#sectionId');
					section.setDisabled(true);
					section.clearValue();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var academyLocationIds = this.getAcademyLocationIds();
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool) {
						this.getProgramPromotionForm().down('#periodId').setVisible(false);
					}

					if(!isNullOrEmpty(intakeYearId)){
						var programStore = programCombo.getStore();
						programStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							intakeYearId : intakeYearId
						};
						programStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if (records.length == 1) {
									var programId = records[0].get("id");
									programCombo.setValue(records[0].get("id"));
									var store = batch.getStore();
									store.getProxy().extraParams = {
										id: programId
									};
									store.load({
										callback: function(records, operation, success) {
											if (success) {
												if (records.length == 1) {
													var batchId = records[0].get("id");
													batch.setValue(records[0].get("id"));
													var period = form.down('#periodId');
													period.setDisabled(false);
													period.clearValue();
													var store = period.getStore();
													store.getProxy().extraParams = {
														id: batchId
													};
													store.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length == 0){
																	if(wheatherSchool) {
																		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
																	}
																} else if(records.length == 1){
																	var periodId = records[0].data.id;
																	$this.getProgramPromotionForm().down('#periodId').setValue(records[0].data.id);
																	var section = $this.getProgramPromotionForm().down('#sectionId');
																	section.setDisabled(false);
																	section.clearValue();
																	var store = section.getStore();
																	store.getProxy().extraParams = {
																		periodId:periodId
																	};
																	store.load({
																		callback: function(records, operation, success) {
																			if (success) {
																				if(records.length == 1) {
																					section.setValue(records[0].data.sectionId)
																				}
																			}
																		}
																	});
																	if(wheatherSchool) {
																		$this.getProgramPromotionForm().down('#periodId').setVisible(false);
																	}
																} else {
																	$this.getProgramPromotionForm().down('#periodId').setVisible(true);
																}

															}
														}
													});
												}
											}
										}
									});
									}
								}
							}
						});

					}
				}
			},

			
			'programpromotionstructure form combo#programId': {
				render : function(programField){
					var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool) {
						this.getProgramPromotionForm().down('#periodId').setVisible(false);
					}
					var store = programField.getStore();
					store.getProxy().extraParams = {
						academyLocationIds:acadLocationIdsCommaSepeated
					};
					store.load();
				},
				select: function(obj, record) {
					var $this =  this;
					var programId = record[0].get("id");
					var form = this.getProgramPromotionForm();
					var period = form.down('#periodId');
					var intakeYearId = form.down('#intakeYearId').getValue();
					period.setDisabled(true);
					period.clearValue();
					var section = form.down('#sectionId');
					section.setDisabled(true);
					section.clearValue();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool) {
						this.getProgramPromotionForm().down('#periodId').setVisible(false);
					}
					var batch = form.down('#batchId');
					batch.setDisabled(false);
					batch.clearValue();
					if(!isNullOrEmpty(programId)){
						var store = batch.getStore();
						store.getProxy().extraParams = {
							id: programId,
							intakeYearId : intakeYearId
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									if (records.length == 1) {
										var batchId = records[0].get("id");
										batch.setValue(records[0].get("id"));
										var period = form.down('#periodId');
										period.setDisabled(false);
										period.clearValue();
										var store = period.getStore();
										store.getProxy().extraParams = {
											id: batchId
										};
										store.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 0){
														if(wheatherSchool) {
															showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
														}
													} else if(records.length == 1){
														var periodId = records[0].data.id;
														$this.getProgramPromotionForm().down('#periodId').setValue(records[0].data.id);
														var section = $this.getProgramPromotionForm().down('#sectionId');
														section.setDisabled(false);
														section.clearValue();
														var store = section.getStore();
														store.getProxy().extraParams = {
															periodId:periodId
														};
														store.load({
															callback: function(records, operation, success) {
																if (success) {
																	if(records.length == 1) {
																		section.setValue(records[0].data.sectionId)
																	}
																}
															}
														});
														if(wheatherSchool) {
															$this.getProgramPromotionForm().down('#periodId').setVisible(false);
														}
													} else {
														$this.getProgramPromotionForm().down('#periodId').setVisible(true);
													}

												}
											}
										});
									}
								}
							}
						});
					}
				}
			},
			
			'programpromotionstructure form combo#batchId':{
				select:function(obj, record){
					var $this = this;
					var batchId = record[0].get("id");
					var form = this.getProgramPromotionForm();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool) {
						this.getProgramPromotionForm().down('#periodId').setVisible(false);
					}
					var period = form.down('#periodId');
					period.setDisabled(false);
					period.clearValue();
					var section = form.down('#sectionId');
					section.setDisabled(true);
					section.clearValue();
					if(!isNullOrEmpty(batchId)){	    	        					  
						var store = period.getStore();
						store.getProxy().extraParams = {
							id: batchId
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 0){
										if(wheatherSchool) {
											showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
										}
									} else if(records.length == 1){
										var periodId = records[0].data.id;
										$this.getProgramPromotionForm().down('#periodId').setValue(records[0].data.id);
										var section = $this.getProgramPromotionForm().down('#sectionId');
										section.setDisabled(false);
										section.clearValue();
										var store = section.getStore();
										store.getProxy().extraParams = {
											periodId:periodId
										};
										store.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 1) {
														section.setValue(records[0].data.sectionId)
													}
												}
											}
										});
										if(wheatherSchool) {
											$this.getProgramPromotionForm().down('#periodId').setVisible(false);
										}
									} else {
										$this.getProgramPromotionForm().down('#periodId').setVisible(true);
									}

								}
							}
						});
					}
				}
			},
			'programpromotionstructure form combo#periodId': {
				select: function(obj, record) {
					var periodId = record[0].get("id");
					var form = this.getProgramPromotionForm();
					var section = form.down('#sectionId');
					section.setDisabled(false);
					section.clearValue();
					if(!isNullOrEmpty(periodId)){
						var store = section.getStore();
						store.getProxy().extraParams = {
							periodId:periodId
						};
						store.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 1) {
										section.setValue(records[0].data.sectionId)
									}
								}
							}
						});
					}
				}
			},
			'programpromotionstructure form button#searchBtn':{
				click : this.searchProgramPromotion
			},
			'programpromotionstructure form button#btnReset':{
				click : this.resetProgramPromotion
			},
			'programpromotiongrid':{
				render : function(grid){
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(wheatherSchool) {
						grid.columns[8].hidden = true;
						grid.columns[11].hidden = true;
					}
	        		this.doAccessControlValidation(grid, this.getPROGRAM_PROMOTION_REPORT_PRIVILEGES());
	        	},
	        	
	        	afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getPROGRAM_PROMOTION_REPORT_PRIVILEGES());
    				},1500);

    			},

			},
			'studentcourseenrollmentreportsearchform button[itemId=addDetailedBtn]':{
				 click: this.addMoreDetailedOfProgramBatchCourse
			},
			'studentcourseenrollmentreportsearchform button[itemId=addDetailedBtn1]':{
				 click: this.addMoreDetailedOfProgramBatchCourse
			},
			'studentcourseenrollmentreportsearchform button[itemId=detailedDeleteButton1]':{
				click : function(deleteButton) {
   				 this.deleteMoreDetailedOfProgramBatchCourse(deleteButton)
   			 }
			},
			'studentcourseenrollmentreportsearchform button[itemId=searchBtn]': {
			    click: function(obj, rec) {
			        var $this = this;
			        var grid = $this.getStudentcourseenrollmentreportgrid();
			        var studentcourseenrollmentreportsearchform = $this.getStudentcourseenrollmentreportsearchform();
			        var formValues = studentcourseenrollmentreportsearchform.getValues();
			        var facultyId = null;
			        var activeStatus = formValues.STATUS;
			        var enrollmentStatusId= formValues.enrollmentStatusId;
			        
			        if(activeStatus=='Active'){
			        	activeStatus=true;
			        }
			        if(activeStatus=='Inactive'){
			        	activeStatus=false;
			        }
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var programIds = "";
			        if (!isNullOrEmpty(formValues.programItem)) {
			            if (formValues.programItem.constructor === Array) {
			                programIds = formValues.programItem.join();
			            } else {
			                programIds = formValues.programItem;
			            }

			        }
			        var batchIds = "";
			        if (!isNullOrEmpty(formValues.BATCH_NAME)) {
			            if (formValues.BATCH_NAME.constructor === Array) {
			                batchIds = formValues.BATCH_NAME.join();
			            } else {
			                batchIds = formValues.BATCH_NAME;
			            }
			        }
			        var periodIds = "";
			        if (!isNullOrEmpty(formValues.PERIOD_NAME)) {
			            if (formValues.PERIOD_NAME.constructor === Array) {
			                periodIds = formValues.PERIOD_NAME.join();
			            } else {
			                periodIds = formValues.PERIOD_NAME;
			            }

			        }
			        grid.getStore().getProxy().extraParams = {
			            admissionId: formValues.STUDENT_ID,
			            programIds: programIds,
			            batchIds: batchIds,
			            periodIds: periodIds,
			            academyLocationIds: academyLocationIds,
			            programGroupId: formValues.PROGRAM_GROUP,
			            intakeYearId: formValues.intakeYear,
			            academicTermId: formValues.academicTerm,
			            activeStatus: activeStatus,
			            enrollmentStatus : formValues.enrollmentStatusId
			        };
			        $this.resetGridSetting(grid);
			        grid.getStore().load();
			        $this.deferForCourseRosterReportGrid(grid);
			        grid.config.searchFilterForm = studentcourseenrollmentreportsearchform;
			    }

			},
			'studentcourseenrollmentreportsearchform': {
			    render: function() {
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var facultyId = null;
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var programName = studentEnrollmentForm.down("#programItemId");
			        var studentId = studentEnrollmentForm.down("#studentId");
			        var store = programName.getStore();
			        store.getProxy().extraParams = {
			            academyLocationIds: academyLocationIds
			        };
			        store.load();
			        var studentStore = studentId.getStore();
			        studentStore.getProxy().extraParams = {
			            academyLocationIds: academyLocationIds,
			        };
			        //studentStore.load();
			    }
			},
			'studentcourseenrollmentreportsearchform customcombobox[itemId=programGroupId]': {
			    select: function(combo, records) {
			        var programGroupId = records[0].get("id");
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var studentEnrollmentgrid = this.getStudentcourseenrollmentreportgrid();
			        var exportStudentCourseEnrollmentReportsId = studentEnrollmentgrid.down('#exportStudentCourseEnrollmentReportsId');
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var panel = studentEnrollmentForm.down("#panelIdH");
			        //panel.reset();
			        var programName = studentEnrollmentForm.down("#programItemId");
			        var intakeYear = studentEnrollmentForm.down("#intakeYear");
			        var intakeYearId = null;
			        if (!isNullOrEmpty(intakeYear.getValue())) {
			            intakeYearId = intakeYear.getValue();
			        }
			        var store = programName.getStore();
			        store.getProxy().extraParams = {
			            academyLocationIds: academyLocationIds,
			            programGroupId: programGroupId,
			            intakeYearId: intakeYearId
			        };
			        store.load();
			        var studentStore = studentEnrollmentForm.down("#studentId").getStore();
			        studentStore.getProxy().extraParams = {
			        	academyLocationIds: academyLocationIds,
			        	programGroupId:programGroupId
			        };
			        studentStore.load();
			        var batch = studentEnrollmentForm.down("#batchId");
			        var period = studentEnrollmentForm.down("#periodId");
			        batch.reset();
			        batch.setDisabled(true);
			        period.reset();
			        period.setDisabled(true);
			        exportStudentCourseEnrollmentReportsId.setDisabled(false);

			    }
			},
			'studentcourseenrollmentreportsearchform customcombobox[itemId=intakeYear]': {
			    select: function(combo, records) {
			        var intakeYearId = records[0].get("id");
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var programName = studentEnrollmentForm.down("#programItemId");
			        var programGroup = studentEnrollmentForm.down("#programGroupId");
			        var academicTerm = studentEnrollmentForm.down("#academicTerm");
			        var programGroupId = null;
			        if (!isNullOrEmpty(programGroup.getValue())) {
			            programGroupId = programGroup.getValue();
			        }
			        var store = programName.getStore();
			        store.getProxy().extraParams = {
			            academyLocationIds: academyLocationIds,
			            programGroupId: programGroupId,
			            intakeYearId: intakeYearId
			        };
			        store.load();
			        var academicTermStore=academicTerm.getStore();
			        academicTermStore.getProxy().extraParams = {
			            academyLocationIds: academyLocationIds,
			            intakeYearId: intakeYearId
			        };
			        var studentStore = studentEnrollmentForm.down("#studentId").getStore();
			        studentStore.getProxy().extraParams = {
			        	academyLocationIds: academyLocationIds,
			        	programGroupId:programGroupId,
			        	 intakeYearId: intakeYearId
			        };
			        studentStore.load();
			        academicTermStore.load();
			        var batch = studentEnrollmentForm.down("#batchId");
			        var period = studentEnrollmentForm.down("#periodId");
			        batch.reset();
			        batch.setDisabled(true);
			        period.reset();
			        period.setDisabled(true);

			    }
			},
			'studentcourseenrollmentreportsearchform customcombobox[itemId=academicTerm]': {
			    select: function(combo, records) {
			        var academicTermId = records[0].get("id");
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var programGroup = studentEnrollmentForm.down("#programGroupId");
			        var programGroupId = null;
			        if (!isNullOrEmpty(programGroup.getValue())) {
			            programGroupId = programGroup.getValue();
			         }
			        var intakeYear = studentEnrollmentForm.down("#intakeYear");
			        var intakeYearId = null;
			        if (!isNullOrEmpty(intakeYear.getValue())) {
			            intakeYearId = intakeYear.getValue();
			        }
			        var studentStore = studentEnrollmentForm.down("#studentId").getStore();
			        studentStore.getProxy().extraParams = {
			        	academyLocationIds: academyLocationIds,
			        	programGroupId:programGroupId,
			        	intakeYearId: intakeYearId,
			        	academicTermId:academicTermId
			        };
			        studentStore.load();
			        }
			},
			'studentcourseenrollmentreportsearchform customcombobox[itemId=programItemId]': {
			    select: function(combo, records) {
			        var programItemId = records[0].get("id");
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var formValues = studentEnrollmentForm.getValues();
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var batch = studentEnrollmentForm.down("#batchId");
			        var intakeYearId = studentEnrollmentForm.down("#intakeYear").getValue();
			        batch.setDisabled(false);
			        batch.clearValue();
			        if (!isNullOrEmpty(programItemId)) {
			            var store = batch.getStore();
			            store.getProxy().extraParams = {
			                id: programItemId,
			                intakeYearId: intakeYearId
			            };
			            store.load();
			        }
			        var programIds = "";
			        if (!isNullOrEmpty(formValues.programItem)) {
			            if (formValues.programItem.constructor === Array) {
			                programIds = formValues.programItem.join();
			            } else {
			                programIds = formValues.programItem;
			            }

			        }
			        var studentStore = studentEnrollmentForm.down("#studentId").getStore();
			        studentStore.getProxy().extraParams = {
			        	academyLocationIds: academyLocationIds,
			        	programGroupId: formValues.PROGRAM_GROUP,
			            intakeYearId: formValues.intakeYear,
			            academicTermId: formValues.academicTerm,
			            programIds:programIds
			        };
			        studentStore.load();
			        var periodId = studentEnrollmentForm.down("#periodId");
			        periodId.clearValue();
			        periodId.setDisabled(true);
			    }
			},
			'studentcourseenrollmentreportsearchform customcombobox[itemId=batchId]': {
			    select: function(combo, records) {
			        var batchId = records[0].get("id");
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var period = studentEnrollmentForm.down("#periodId");
			        period.setDisabled(false);
			        period.clearValue();
			        if (!isNullOrEmpty(batchId)) {
			            var store = period.getStore();
			            store.getProxy().extraParams = {
			                id: batchId,
			                filter: null,
			            };
			            store.load();
			        }
			    }
			},
			/*'studentcourseenrollmentreportsearchform customcombobox[itemId=studentId]': {
				/*change: function(obj) {
				var studentValue =  obj.getValue();
				if(!isNullOrEmpty(studentValue)){
					 var studentName = studentValue.trim(); 
					 if(studentName.length >= 3){
						 var studentcourseenrollmentreportsearchform = this.getStudentcourseenrollmentreportsearchform();
					     var formValues = studentcourseenrollmentreportsearchform.getValues();
						 var store = obj.getStore();
					        var academyLocationIds;
					        if (this.getCurrentLoggedPortalId() == 2) {
					            academyLocationIds = this.getCurrentAcademyLocation();
					        } else {
					            academyLocationIds = this.getAcademyLocationIds();
					        }
					        var programIds = "";
					        if (!isNullOrEmpty(formValues.programItem)) {
					            if (formValues.programItem.constructor === Array) {
					                programIds = formValues.programItem.join();
					            } else {
					                programIds = formValues.programItem;
					            }
					        }
					        store.getProxy().extraParams = {
					            academyLocationIds: academyLocationIds,
					            programGroupId:formValues.PROGRAM_GROUP,
					            intakeYearId:formValues.intakeYear,
					            academicTermId:formValues.academicTerm,
					            programIds:programIds,
					            studentNameOrCode:studentName
					        };
					        store.load({
					        	'callback': function(rec){
					        	}
					        });
					 }
				   }
			    }
			},*/
			'studentcourseenrollmentreportsearchform button[itemId=resetBtn]': {
			    click: function(obj, rec) {
			        var $this = this;
			        var form = $this.getStudentcourseenrollmentreportsearchform();
			        form.getForm().reset();
			        var studentEnrollmentgrid = $this.getStudentcourseenrollmentreportgrid();
			        var exportStudentCourseEnrollmentReportsId = studentEnrollmentgrid.down('#exportStudentCourseEnrollmentReportsId');

			        var programItemId = form.down('#programItemId');
			        var batchId = form.down('#batchId');
			        var periodId = form.down('#periodId');
			        var academicTerm = form.down('#academicTerm');
			        form.down("#statusComboItemId").setValue(true);
			        batchId.setDisabled(true);
			        periodId.setDisabled(true);
			        exportStudentCourseEnrollmentReportsId.setDisabled(true);
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var store = programItemId.getStore();
			        store.getProxy().extraParams = {
			            academyLocationIds: academyLocationIds,
			        };
			        store.load();
			        var academicTermStore=academicTerm.getStore();
			        academicTermStore.getProxy().extraParams = {
			            academyLocationIds: null,
			            intakeYearId:null
			        };
			        academicTermStore.load();
			        var panelContiner = form.down('#panelIdH');
			        for (var i = panelContiner.items.length - 1; i >= 1; i--) {
			        	panelContiner.remove(i);
			        }
			        this.hideShowDetails(panelContiner);
			    }
			},
			'studentcourseenrollmentreportsearchform combo#studentId':{
				select : function(obj,record){
					var this$ = this;
					var form = this$.getStudentcourseenrollmentreportsearchform();
					var activeStatus = record[0].get("studentStatus");
					form.down("#studentId").setValue(record[0].get('id'));
					form.down('#statusComboItemId').setValue(activeStatus);
				}
			},
			
			// enrollment status
			'studentcourseenrollmentreportsearchform customcombobox[itemId=enrollmentStatusId]': {
			    select: function(combo, records) {
			        var studentEnrollmentForm = this.getStudentcourseenrollmentreportsearchform();
			        var enrollmentStatus = studentEnrollmentForm.down("#enrollmentStatusId");
			            var store = enrollmentStatus.getStore();
			            store.load();
			    }
			},
			
			'studentcourseenrollmentreportgrid[itemId=studentcourseenrollmentreportGridId]': {
				render:function(grid){
		 			this.doAccessControlValidation(grid, this.getSTUDENT_COURSE_ENROLLMENT_REPORT_PERMISSIONS());
                	this.disableExportBtnActionPivilegesOfCourseEnrollReport(grid, this.getSTUDENT_COURSE_ENROLLMENT_REPORT_PERMISSIONS());
		 		 } ,
			afterrender: function(grid) {
				var me = this;
				setTimeout(function(){
					me.addDataGridConfigButton(grid,me.getSTUDENT_COURSE_ENROLLMENT_REPORT_PERMISSIONS());
				},3000);
}
				},
			'studentcourseenrollmentreportgrid[itemId=studentcourseenrollmentreportGridId] button[itemId=exportStudentCourseEnrollmentReportsId]':{
				click:function(obj){
	  				   var $this = this;
	  				   $this.generateStudentCourseEnrollmentReport();
	  			   }
			},
			'coursesearchattendanceofsectiongroup button[itemId=searchBtn]':{
	    		 click: this.loadreportBySectionGroup
	    	},
			'coursesearchattendanceofsectiongroup combo#sectionGroupId': {
			    select: function(obj, record) {
			        var sectionGroupId = record[0].get("id");
			        var academyLocationIds;
			        if (this.getCurrentLoggedPortalId() == 2) {
			            academyLocationIds = this.getCurrentAcademyLocation();
			        } else {
			            academyLocationIds = this.getAcademyLocationIds();
			        }
			        var form = this.getCoursesearchattendanceofsectiongroup();
			        var grid = this.getCourseattendancebysectiongroupgrid();
			        var courseCombo = form.down('#course_Id');
			        var exportButton=grid.down('#exportReportsOfSectionGroupId');
			        exportButton.setDisabled(false);
			        courseCombo.setDisabled(false);
			        courseCombo.clearValue();
			        var courseComboStore = courseCombo.getStore();
			        courseComboStore.getProxy().api.read=SERVERURL.FIND_SECTION_GROUP_PARAMETERIZED_COURSES;
			        courseComboStore.getProxy().extraParams = {
			            sectionGroupId: sectionGroupId,
			            academyLocationIds: academyLocationIds
			        };
			        courseComboStore.load();

			        var programCombo = form.down('#programBatch_programId');
			        programCombo.setDisabled(false);
			        programCombo.clearValue();
			        var programComboStore = programCombo.getStore();
			        programComboStore.getProxy().extraParams = {
			            sectionGroupId: sectionGroupId,
			            academyLocationIds: academyLocationIds
			        };
			        programCombo.lastQuery = null;
			        programComboStore.load();
			        var studentCombo = form.down('#sectionGroupStudentId');
			        studentCombo.setDisabled(false);
			        studentCombo.clearValue();
			        var store = studentCombo.getStore();
			        var studentComboStore = studentCombo.getStore();
			        studentComboStore.getProxy().extraParams = {
			            sectionGroupId: sectionGroupId,
			            academyLocationIds: academyLocationIds
			        };
			        studentCombo.lastQuery = null;
			        studentComboStore.load();
			        
			        var batchCombo = form.down('#programBatch_batchId');
			        batchCombo.setDisabled(true);
			        batchCombo.clearValue();
			        var periodCombo = form.down('#programBatch_periodId');
			        periodCombo.setDisabled(true);
			        periodCombo.clearValue();
			    }
			}, 
			'coursesearchattendanceofsectiongroup combo#programBatch_programId': {
			    select: function(obj, record) {
			        var programId = record[0].get("id");
			        if (programId > 0) {
			            var form = this.getCoursesearchattendanceofsectiongroup();
			            var sectionGroupId = form.down("#sectionGroupId").getValue();
			            form.down("#programBatch_batchId").setDisabled(false);
			            var store = form.down("#programBatch_batchId").getStore();
			            store.getProxy().extraParams = {
			            	sectionGroupId : sectionGroupId,
			                programId : programId
			            };
			            store.load();
			            form.down("#programBatch_periodId").setDisabled(true);
			            form.down("#programBatch_periodId").clearValue();
			        }
			    }
			},
			'coursesearchattendanceofsectiongroup combo#programBatch_batchId': {
			    select: function(obj, record) {
			        var batchId = record[0].get("id");
			        if (batchId > 0) {
			        	var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
			            var form = this.getCoursesearchattendanceofsectiongroup();
			            var sectionGroupId = form.down("#sectionGroupId").getValue();
			            form.down("#programBatch_periodId").setDisabled(false);
			            form.down("#course_Id").setDisabled(false);
			            var store = form.down("#programBatch_periodId").getStore();
			            store.getProxy().extraParams = {
			                batchId: batchId,
			                sectionGroupId:sectionGroupId
			            };
			            if(wheatherSchool){
							   form.down("#programBatch_periodId").hide();
							   store.load({
								   callback: function(periodRecords, operation, success) {
									   if (success) {
										   if(periodRecords.length==1){
											   form.down("#programBatch_periodId").setValue(periodRecords[0].get('id'));
										   }else{
											   form.down("#programBatch_periodId").show();
										   }
									   }
								   }
							   });  
						   }else{
							   store.load(); 
						   }
			        }
			    }
			},
			'coursesearchattendanceofsectiongroup button[itemId=resetBtn]':{
				click: function(obj,record) {
	        		var form=this.getCoursesearchattendanceofsectiongroup();
	        		var grid=this.getCourseattendancebysectiongroupgrid();
	        		form.getForm().reset();
	        		var courseCombo=form.down('#course_Id');
	        		var studentCombo = form.down('#sectionGroupStudentId');
	        		var programCombo = form.down('#programBatch_programId');
	        		var batchCombo = form.down('#programBatch_batchId');
	        		var periodCombo = form.down('#programBatch_periodId');
	        		var exportReportsbutton = grid.down('#exportReportsOfSectionGroupId');
	        		var fromDate = form.down('#startDate');
	        		var toDate = form.down('#endDate');
	        		fromDate.setMinValue(false);
	        		fromDate.setMaxValue(new Date());
	        		toDate.setMinValue(false);
	        		toDate.setMaxValue(new Date());
	        		courseCombo.clearValue();
	        		programCombo.clearValue();
	        		batchCombo.clearValue();
	        		periodCombo.clearValue();
	        		studentCombo.clearValue();
	        		
	        		studentCombo.setDisabled(true);
	        		courseCombo.setDisabled(true);
	        		programCombo.setDisabled(true);
	        		batchCombo.setDisabled(true);
	        		periodCombo.setDisabled(true);
	        		exportReportsbutton.setDisabled(true);
	            }
			},
			'coursesearchattendanceofsectiongroup customcombobox[itemId=sectionGroupStudentId]':{
				select: function(obj,record) {
					var studentId =  record[0].get("id");
					var alIds=[];
					   var academyLocationIds = this.getAcademyLocationIds();
					   if(isNullOrEmpty(academyLocationIds)){
						   alIds.push(this.getCurrentAcademyLocation());
						   academyLocationIds = alIds.join();
					   }
					var form=this.getCoursesearchattendanceofsectiongroup();
					var grid=this.getCourseattendancebysectiongroupgrid();
					var sectionGroupId = form.down('#sectionGroupId').getValue();
					var courseCombo=form.down('#course_Id');
					var programCombo = form.down('#programBatch_programId');
					var batchCombo = form.down('#programBatch_batchId');
					var periodCombo = form.down('#programBatch_periodId');
					courseCombo.clearValue();
					programCombo.clearValue();
					batchCombo.clearValue();
					periodCombo.clearValue();

					batchCombo.setDisabled(true);
					periodCombo.setDisabled(true);
					var courseStore = courseCombo.getStore();
					courseStore.getProxy().api.read=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
					courseStore.getProxy().extraParams = {
						sectionGroupId:sectionGroupId,
						academyLocationIds:academyLocationIds,
						studentId:studentId
					};
					courseStore.load();
					var programStore = programCombo.getStore();
					programStore.getProxy().extraParams = {
						sectionGroupId:sectionGroupId,
						academyLocationIds:academyLocationIds,
						studentId:studentId
					};
					programCombo.lastQuery = null;
					programStore.load();
				}
			},
			'tabpanel[itemId=tabpanelIds] tab':{
            	activate: function(){
                   	var  contentPanelMain = this.getContentpanel().getActiveTab();
                    contentPanelMain.scrollBy(0,1);
                    contentPanelMain.scrollBy(0,-1);
                    }
			},
			'courserosterreportgrid[itemId=courserosterreportGridId] button[itemId=sendMessageBtn]':{
	  			   click:function(obj){
	  				   this.openCourseRosterSendMessageWindow();
	  			   }
	  			},
	  		'courserosterreportgrid[itemId=courserosterreportGridId] button[itemId=resetPasswordBtn]':{
	  				 click: function(obj) {
	  					 	$this=this;
	  					 	var grid = $this.getCourserosterreportgrid();
	    		        	if (grid.getSelectionModel().getCount() > 0) {
	    		        			this.openResetPasswordWindowCR();
	    	        		} else {
	    						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    					}  
     	            }
	  			},	

	  			
	  			 'studentsendmessagewindowcourseroster radiogroup#sendingPriority': {
	  	       		change: function( radio, newValue, oldValue, eOpts) {
	  	         	      this.loadCourseRosterStudentScheduleField(radio, newValue, oldValue);
	  	         		}
	  	         	},		   
	  			   'studentsendmessagewindowcourseroster radiogroup[itemId=messageType]':{
	  	 	        	change : function(val,nV,oV){
	  	 	        		this.selectCourseRosterMessageType(val,nV,oV);
	  	 	        	}
	  	 	        },
	  	 	        'studentsendmessagewindowcourseroster':{
	  	 	        	render:function(messageForm){
	  	 	        		var portalId = this.getCurrentLoggedPortalId();
	  	 	        		var searchForm=this.getStudentsendmessagewindowcourseroster();
	  	 	        		this.disableSendMessageRadioButtonSelectionsPivileges(searchForm,this.getCOURSE_ROSTER_REPORT_ON_TREE_PERMISSIONS());
	  	 	        		if(this.getCurrentLoggedPortalId()==2){
	  	 	        			this.disableSendMessageRadioButtonSelectionsPivileges(searchForm,this.getEMPLOYEE_COURSE_ROSTER_REPORT_PERMISSIONS());
	  	 	        		}
	  	 	        	},
	  	 	        	afterrender: function(){
	  	 	        		var me = this;
	  	 	        		me.setMaxFileSizeForSendMessageScreen();
	  	 	        	}
	  	 	        },
                 'sectionrosterreportgrid[itemId=sectionrosterreportGridId] button[itemId=sendMessageSectionRRBtn]':{
		  			   click:function(obj){
		  				   this.openSectionRosterSendMessageWindow();
		  			   }
		  			},
                 'studentsendmessagewindowsectionroster radiogroup#sendingPriority': {
 	  	       		change: function( radio, newValue, oldValue, eOpts) {
 	  	         	      this.loadSectionRosterStudentScheduleField(radio, newValue, oldValue);
 	  	         		}
 	  	         	},		   
 	  			   'studentsendmessagewindowsectionroster radiogroup[itemId=messageType]':{
 	  	 	        	change : function(val,nV,oV){
 	  	 	        		this.selectSectionRosterMessageType(val,nV,oV);
 	  	 	        	}
 	  	 	        },
 	  	 	        'studentsendmessagewindowsectionroster':{
 	  	 	        	render:function(messageForm){
 	  	 	        		var portalId = this.getCurrentLoggedPortalId();
 	  	 	        		var searchForm=this.getStudentsendmessagewindowsectionroster();
 	  	 	        		this.disableSendMessageRadioButtonSelectionsPivileges(searchForm,this.getSECTION_ROSTER_REPORT_PERMISSIONS());
 	  	 	        		if(this.getCurrentLoggedPortalId()==2){
 	  	 	        			this.disableSendMessageRadioButtonSelectionsPivileges(searchForm,this.getEMPLOYEE_SECTION_ROSTER_REPORT_PERMISSIONS());
 	  	 	        		}
 	  	 	        	},
 	  	 	        	afterrender: function(){
 	  	 	        		var me = this;
 	  	 	        		me.setMaxFileSizeForSendMessageScreen();
 	  	 	        	}
 	  	 	        },
                  'studentsendmessagewindowsectionroster customcombobox[itemId=msgTempletId]':{
	  	 	        	select : function(obj,rec){
	  	 	        		this.selectSectionRosterStudentMessageTemp(obj,rec);
	  	 	        	}
	  	 	        },
	  	 	       /*'studentsendmessagewindowcourseroster':{
	  	 	    	   render : function(grid){
	  	 	    		   var this$ = this;
	  	 	    		   var portalId = this.getCurrentLoggedPortalId();
	  	 	    		   if(portalId == 2) {
	  	 	    			   var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
	  	 	    			   this$.disableRadioGroupAndOtherPivileges(grid, this$.getEMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES(), itemIdPrivilegeNameArray);
	  	 	    		   }
	  	 	    	   }
	  		        },*/
	  	 	        'studentsendmessagewindowcourseroster customcombobox[itemId=msgTempletId]':{
	  	 	        	select : function(obj,rec){
	  	 	        		this.selectCourseRosterStudentMessageTemp(obj,rec);
	  	 	        	}
	  	 	        },
	  	 	        'studentsendmessagewindowcourseroster button[itemId=adhocMsgSubmitBtn]':{
	  	    			click: function(obj) {
	  	    				var grid = this.getCourserosterreportgrid();
	  	    				var docgrid = this.getStudentcourserosterstaticdocumentattachmentgrid();
	  	    				var studentsendmessagecoursereport = this.getStudentsendmessagewindowcourseroster();
	  	    				
	  	    				var wsMsgEventRecipientConfigsUpdated = [];
	  	    				/*var wsMsgEventRecipientConfigsUpdated = [{ 
	  									                           	 	msgRecipientTypeId: 500,
	  									                           	 	msgTemplateConfigId: 0,	//formData.id, 
	  									                           	 	selectiveRecipientIds: [] 
	  									                            },{ 
	  									                           	 	msgRecipientTypeId: 600,
	  									                           	 	msgTemplateConfigId: 0,	//formData.id, 
	  									                           	 	selectiveRecipientIds: [] 
	  									                            }];*/
	  	    				
	  	    				var formData = obj.up('form').getValues();
	  	    				
	  	    				var sendMessageToOptions = formData.recieverType;
	  	    				var isStudentChecked = false;
	  	    				var isParentChecked = false;
	  	    				var isFeePayerChecked = false;
	  	    				var isMySelfChecked = false;
	  	    				var isLoggedInUserId=this.getCurrentlyLoggedInUser().id;
	  	    				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
	  	    					if(sendMessageToOptions.constructor === Array){
	  	    						if(sendMessageToOptions.length > 0){
	  	    							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
	  	            						if(current_value == 1 || current_value == '1'){
	  	            							isStudentChecked = true;
	  	            						}
	  										if(current_value == 2 || current_value == '2'){
	  											isParentChecked = true;
	  										}
	  										if(current_value == 3 || current_value == '3'){
	  											isFeePayerChecked = true;
	  										}if(current_value == 4 || current_value == '4'){
	  											isMySelfChecked = true;
	  										}
	  	            					});
	  	    						}
	  	    					}else{
	  	    						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
	  	    							isStudentChecked = true;
	  	    						}
	  								if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
	  									isParentChecked = true;
	  								}
	  								if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
	  									isFeePayerChecked = true;
	  								}if(sendMessageToOptions == 4 || sendMessageToOptions == '4'){
	  									isMySelfChecked = true;
	  								}
	  	    					}
	  	    				}
	  	    				
	  	    				if(!isStudentChecked && !isParentChecked){
	  	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_INCLUDE_MYSELF_WITH_OTHER_ONE')); 
     			    		   return false;
	  	    				}
	  	    				//var abc = xyz.c;
	  	    				
	  	    				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
	  	    					//wsMsgEventRecipientConfigsUpdated = [];
	  	    					studentsendmessagecoursereport.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
	  	    					var  gridDocStore=docgrid.getStore();
      							gridDocStore.removeAll();
	  	    				}else{
	  	    					//var recipientIds = formData.recipientFieldARName;
	  	    					//recipientIds = Ext.encode(recipientIds);
	  	    					
	  	    					if(grid.itemId == 'courserosterreportGridId'){
	  	    						recipientIds = this.getStudentReceipientIdsForCourseRosterReport(grid);
	  	    						recipientIds = Ext.encode(recipientIds);
	  	    						//typeId = 2;
	  	    						//recipientId = 2;
	  	    					}
	  	    					
	  	    					var RecipientTypeCodes = ["Parent Adhoc"];
	  	    					
	  	    					if( isParentChecked){ // Both checkboxes are cheked 
	  	    						// Ajax Call to get Parent Ids by Admission Ids
	  	    						
	  	    						Ext.Ajax.request({
	  	        						type: 'rest',
	  	        						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	  	        						jsonData: RecipientTypeCodes,
	  	        						method: 'POST',
	  	        						async: false,
	  	        						success: function(response) {
	  	        							var RecipientTypeCodesData = Ext.decode(response.responseText);
	  	        							
	  	        							Ext.Ajax.request({
	  		            						type: 'rest',
	  		            						url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
	  		            						jsonData: recipientIds,
	  		            						method: 'POST',
	  		            						async: false,
	  		            						success: function(response) {
	  		            							// update wsMsgEventRecipientConfigsUpdated with parent ids
	  		            							var wsMsgEventRecipientConfigsParents = {
	  										            									msgRecipientTypeId: 66,
	  														                           	 	msgTemplateConfigId: 0,	//formData.id, 
	  														                           	 	selectiveRecipientIds: []
	  											            							};
	  		            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	  		            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	  		            							}
	  		            							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	  		            							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	  		            							
	  		            							// Ajax Call to get Fee Payer Ids by Admission Ids
	  		            							if(isFeePayerChecked){
	  		            							 Ext.Ajax.request({
	  		    	            						type: 'rest',
	  		    	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
	  		    	            						jsonData: recipientIds,
	  		    	            						method: 'POST',
	  		    	            						success: function(response) {
	  		    	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	  		    	            							var wsMsgEventRecipientConfigsFeePayer = {
	  				            									msgRecipientTypeId: 67,
	  								                           	 	msgTemplateConfigId: 0,	//formData.id, 
	  								                           	 	selectiveRecipientIds: []
	  					            							};
	  		    	            							
	  		    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	  		    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	  		    	            							}
	  		    	            							
	  		    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	  														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);	  														
	  		    	            						}
	  		    	            					});
	  		            						 }
	  		            						studentsendmessagecoursereport.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
												var  gridDocStore=docgrid.getStore();
						      					gridDocStore.removeAll();
	  		            						}
	  		            					});
	  	        						}
	  	    						});
	  	    					}else{ // Only one checkbox is selected
	  	    						var urlNew = '';
	  	    						if(isParentChecked) { // If Parent checkbox is selected
	  	    							// url for getting parent ids
	  	    							urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
	  	    						}
	  	    						/*if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	  	    							// url for getting fee payer ids
	  	    							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
	  	    						}
	  	    						*/
	  	    						Ext.Ajax.request({
	  	        						type: 'rest',
	  	        						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	  	        						jsonData: RecipientTypeCodes,
	  	        						method: 'POST',
	  	        						success: function(response) {
	  	        							var RecipientTypeCodesData = Ext.decode(response.responseText);
	  	        							
	  	        							Ext.Ajax.request({
	  		            						type: 'rest',
	  		            						url: urlNew,
	  		            						jsonData: recipientIds,
	  		            						method: 'POST',
	  		            						success: function(response) {
	  		            							if(isParentChecked) { // If Parent checkbox is selected
	  		            								// update wsMsgEventRecipientConfigsUpdated with parent ids
	  		            								var wsMsgEventRecipientConfigsParents = {
	  			            									msgRecipientTypeId: 66,
	  							                           	 	msgTemplateConfigId: 0,	//formData.id, 
	  							                           	 	selectiveRecipientIds: []
	  				            							};
	  		            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	  	    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	  	    	            							}
	  													wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	  													if(wsMsgEventRecipientConfigsParents.selectiveRecipientIds.length!=0)
	  													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	  		                						}
	  		            							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	  		                							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	  		            								var wsMsgEventRecipientConfigsFeePayer = {
	  			            									msgRecipientTypeId: 67,
	  							                           	 	msgTemplateConfigId: 0,	//formData.id, 
	  							                           	 	selectiveRecipientIds: []
	  				            							};
	  		            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	  		            									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	  	    	            							}
	  	    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	  													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	  		                						}
	  		            							studentsendmessagecoursereport.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked);
	  		            							var  gridDocStore=docgrid.getStore();
	  		            							gridDocStore.removeAll();
	  		            						}
	  		            					});
	  	        						}
	  	    						});
	  	    						
	  	    					}
	  	    					
	  	    					//studentsendmessage.sendMessage(obj,grid);
	  	    				}
	  	    				if(isMySelfChecked){
  	    						var wsMsgEventRecipientConfigsMySelf = {
  	    									msgRecipientTypeId: 166,
  	    									msgTemplateConfigId: 0,	//formData.id, 
  	    									selectiveRecipientIds: [isLoggedInUserId]
  	    										};
  	    							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsMySelf);

  	    										}
	  	    				
	  	    				//studentsendmessage.sendMessage(obj,grid);
						grid.down('#resetPasswordBtn').setDisabled(true);
	  	    			}
	  	    		},'studentsendmessagewindowcourseroster  filefield[itemId=staticUploadFileField]': {
	  	 	        	change: function(fileField, value, eOpts){
	  	 	        		var this$ = this;
	  	 	        		this$.uploadCourseRosterStudentStaticDocumentFileMessage(fileField, value, eOpts);
	  	 	        	}
	  	 	        },
	  	 	        /*V2D-13247*/
	  	  	        'studentsendmessagewindowcourseroster textarea[itemId=smsDiscription]':{
	  	  	        	change : function(val,nV,oV){
	  	  	        		var studentSendMessageWindowCourseRoster = this.getStudentsendmessagewindowcourseroster();
	  	  	        		var smsTextField = studentSendMessageWindowCourseRoster.down('#smsDiscription');
	  	  	        		var smsTextFieldDiscription = studentSendMessageWindowCourseRoster.down('#smsDiscriptionNotice');
	  	            		var maxLength = localStorage.getItem('maxLength');
	  	  	        		var newValue = maxLength - smsTextField.getValue().length;
	  	  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	  	  	        	}
	  	  	        },
	  	  	    'studentsendmessagewindowcourseroster textarea[itemId=pushNotificationDiscription]':{
  	  	        	change : function(val,nV,oV){
  	  	        		var studentSendMessageWindowCourseRoster = this.getStudentsendmessagewindowcourseroster();
  	  	        		var smsTextField = studentSendMessageWindowCourseRoster.down('#pushNotificationDiscription');
  	  	        		var smsTextFieldDiscription = studentSendMessageWindowCourseRoster.down('#pushNotificationDiscriptionNotice');
  	            		var maxLength = 1000;
  	  	        		var newValue = maxLength - smsTextField.getValue().length;
  	  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  	  	        	}
  	  	        },
	  	  	    'studentcourserosterstaticdocumentattachmentgrid actioncolumn': {
	            	click : function(view, rowIndex, colIndex, item, e, record, row){
	            		this.deleteStudentCourseRosterStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
	            	}
	            },
	            'studentsendmessagewindowsectionroster button[itemId=adhocMsgSubmitBtn]':{
  	    			click: function(obj) {
  	    				var grid = this.getSectionrosterreportgrid();
  	    				var docgrid = this.getStudentsectionrosterstaticdocumentattachmentgrid();
  	    				var studentsendmessagesectionreport = this.getStudentsendmessagewindowsectionroster();
  	    				
  	    				var wsMsgEventRecipientConfigsUpdated = [];
  	    				
  	    				var formData = obj.up('form').getValues();
  	    				
  	    				var sendMessageToOptions = formData.recieverType;
  	    				var isStudentChecked = false;
  	    				var isParentChecked = false;
  	    				var isFeePayerChecked = false;
  	    				var isMySelfChecked = false;
  	    				var isLoggedInUserId=this.getCurrentlyLoggedInUser().id;
  	    				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
  	    					if(sendMessageToOptions.constructor === Array){
  	    						if(sendMessageToOptions.length > 0){
  	    							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
  	            						if(current_value == 1 || current_value == '1'){
  	            							isStudentChecked = true;
  	            						}
  										if(current_value == 2 || current_value == '2'){
  											isParentChecked = true;
  										}
  										if(current_value == 3 || current_value == '3'){
  											isFeePayerChecked = true;
  										}if(current_value == 4 || current_value == '4'){
  											isMySelfChecked = true;
  										}
  	            					});
  	    						}
  	    					}else{
  	    						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
  	    							isStudentChecked = true;
  	    						}
  								if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
  									isParentChecked = true;
  								}
  								if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
  									isFeePayerChecked = true;
  								}if(sendMessageToOptions == 4 || sendMessageToOptions == '4'){
  									isMySelfChecked = true;
  								}
  	    					}
  	    				}
  	    				if(!isStudentChecked && !isParentChecked){
  	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_INCLUDE_MYSELF_WITH_OTHER_ONE')); 
 			    		   return false;
  	    				}
  	    				//var abc = xyz.c;
  	    				
  	    				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
  	    					//wsMsgEventRecipientConfigsUpdated = [];
  	    					studentsendmessagesectionreport.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
  	    					var  gridDocStore=docgrid.getStore();
  							gridDocStore.removeAll();
  	    				}else{
  	    					//var recipientIds = formData.recipientFieldARName;
  	    					//recipientIds = Ext.encode(recipientIds);
  	    					
  	    					if(grid.itemId == 'sectionrosterreportGridId'){
  	    						recipientIds = this.getStudentReceipientIdsForSectionRosterReport(grid);
  	    						recipientIds = Ext.encode(recipientIds);
  	    						//typeId = 2;
  	    						//recipientId = 2;
  	    					}
  	    					
  	    					var RecipientTypeCodes = ["Parent Adhoc"];
  	    					
  	    					if( isParentChecked && isFeePayerChecked ){ // Both checkboxes are cheked 
  	    						// Ajax Call to get Parent Ids by Admission Ids
  	    						
  	    						Ext.Ajax.request({
  	        						type: 'rest',
  	        						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
  	        						jsonData: RecipientTypeCodes,
  	        						method: 'POST',
  	        						async: false,
  	        						success: function(response) {
  	        							var RecipientTypeCodesData = Ext.decode(response.responseText);
  	        							
  	        							Ext.Ajax.request({
  		            						type: 'rest',
  		            						url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
  		            						jsonData: recipientIds,
  		            						method: 'POST',
  		            						async: false,
  		            						success: function(response) {
  		            							// update wsMsgEventRecipientConfigsUpdated with parent ids
  		            							var wsMsgEventRecipientConfigsParents = {
  										            									msgRecipientTypeId: 66,
  														                           	 	msgTemplateConfigId: 0,	//formData.id, 
  														                           	 	selectiveRecipientIds: []
  											            							};
  		            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
  		            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
  		            							}
  		            							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
  		            							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
  		            							
  		            							// Ajax Call to get Fee Payer Ids by Admission Ids
  		            							Ext.Ajax.request({
  		    	            						type: 'rest',
  		    	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
  		    	            						jsonData: recipientIds,
  		    	            						method: 'POST',
  		    	            						success: function(response) {
  		    	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
  		    	            							var wsMsgEventRecipientConfigsFeePayer = {
  				            									msgRecipientTypeId: 67,
  								                           	 	msgTemplateConfigId: 0,	//formData.id, 
  								                           	 	selectiveRecipientIds: []
  					            							};
  		    	            							
  		    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
  		    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
  		    	            							}
  		    	            							
  		    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
  														wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
  														studentsendmessagesectionreport.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
  														var  gridDocStore=docgrid.getStore();
  						      							gridDocStore.removeAll();
  		    	            						}
  		    	            					});
  		            						}
  		            					});
  	        						}
  	    						});
  	    					}else{ // Only one checkbox is selected
  	    						var urlNew = '';
  	    						if(isParentChecked) { // If Parent checkbox is selected
  	    							// url for getting parent ids
  	    							urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
  	    						}
  	    						/*if(isFeePayerChecked) { // If Fee Payer checkbox is selected
  	    							// url for getting fee payer ids
  	    							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
  	    						}
  	    						*/
  	    						Ext.Ajax.request({
  	        						type: 'rest',
  	        						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
  	        						jsonData: RecipientTypeCodes,
  	        						method: 'POST',
  	        						success: function(response) {
  	        							var RecipientTypeCodesData = Ext.decode(response.responseText);
  	        							
  	        							Ext.Ajax.request({
  		            						type: 'rest',
  		            						url: urlNew,
  		            						jsonData: recipientIds,
  		            						method: 'POST',
  		            						success: function(response) {
  		            							if(isParentChecked) { // If Parent checkbox is selected
  		            								// update wsMsgEventRecipientConfigsUpdated with parent ids
  		            								var wsMsgEventRecipientConfigsParents = {
  			            									msgRecipientTypeId: 66,
  							                           	 	msgTemplateConfigId: 0,	//formData.id, 
  							                           	 	selectiveRecipientIds: []
  				            							};
  		            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
  	    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
  	    	            							}
  													wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
  													if(wsMsgEventRecipientConfigsParents.selectiveRecipientIds.length!=0)
  													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
  		                						}
  		            							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
  		                							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
  		            								var wsMsgEventRecipientConfigsFeePayer = {
  			            									msgRecipientTypeId: 67,
  							                           	 	msgTemplateConfigId: 0,	//formData.id, 
  							                           	 	selectiveRecipientIds: []
  				            							};
  		            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
  		            									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
  	    	            							}
  	    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
  													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
  		                						}
  		            							studentsendmessagesectionreport.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked);
  		            							var  gridDocStore=docgrid.getStore();
  		            							gridDocStore.removeAll();
  		            						}
  		            					});
  	        						}
  	    						});
  	    						
  	    					}
  	    					//studentsendmessage.sendMessage(obj,grid);
  	    				}
  	    				if(isMySelfChecked){
	    						var wsMsgEventRecipientConfigsMySelf = {
	    									msgRecipientTypeId: 166,
	    									msgTemplateConfigId: 0,	//formData.id, 
	    									selectiveRecipientIds: [isLoggedInUserId]
	    										};
	    							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsMySelf);

	    										}
  	    				//studentsendmessage.sendMessage(obj,grid);
  	    			}
  	    		},'studentsendmessagewindowsectionroster  filefield[itemId=staticUploadFileField]': {
  	 	        	change: function(fileField, value, eOpts){
  	 	        		var this$ = this;
  	 	        		this$.uploadSectionRosterStudentStaticDocumentFileMessage(fileField, value, eOpts);
  	 	        	}
  	 	        },
  	 	        /*V2D-13247*/
  	  	        'studentsendmessagewindowsectionroster textarea[itemId=smsDiscription]':{
  	  	        	change : function(val,nV,oV){
  	  	        		var studentsendmessagewindowsectionroster = this.getstudentsendmessagewindowsectionroster();
  	  	        		var smsTextField = studentsendmessagewindowsectionroster.down('#smsDiscription');
  	  	        		var smsTextFieldDiscription = studentsendmessagewindowsectionroster.down('#smsDiscriptionNotice');
  	            		var maxLength = localStorage.getItem('maxLength');
  	  	        		var newValue = maxLength - smsTextField.getValue().length;
  	  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  	  	        	}
  	  	        },
  	  	    'studentsendmessagewindowsectionroster textarea[itemId=pushNotificationDiscription]':{
	  	        	change : function(val,nV,oV){
	  	        		var studentsendmessagewindowsectionroster = this.getstudentsendmessagewindowsectionroster();
	  	        		var smsTextField = studentsendmessagewindowsectionroster.down('#pushNotificationDiscription');
	  	        		var smsTextFieldDiscription = studentsendmessagewindowsectionroster.down('#pushNotificationDiscriptionNotice');
	            		var maxLength = 1000;
	  	        		var newValue = maxLength - smsTextField.getValue().length;
	  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	  	        	}
	  	        },
  	  	    'studentsectionrosterstaticdocumentattachmentgrid actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		this.deleteStudentSectionRosterStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },

			/******************************/
			'coursedetailreportsearchform': {
					   render: function(obj) {
						   var form = obj.up('form');
						   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();						   
						   var courseCodeField = form.down('#courseCode');
						   var courseDeptField = form.down('#courseDepartment');
						   var courseMarkGrdField = form.down('#courseMarksGrades_id');
						   var courseStore = courseCodeField.getStore();
						   courseStore.getProxy().extraParams = {
							   academyLocationIds:acadLocationIdsCommaSepeated
						   };
						   courseStore.load();
						   var courseDeptStore = courseDeptField.getStore();
						   courseDeptStore.getProxy().extraParams = {
							   academyLocationsIds:acadLocationIdsCommaSepeated
						   };
						   courseDeptStore.load();
						   /*var courseMarkGrdStore = courseMarkGrdField.getStore();
						   courseMarkGrdStore.load();*/
					   }
		},
			'coursedetailreportsearchform button[itemId=searchBtn]':{
				   click: function(grid){
					   var $this = this;
					   var form = this.getCoursedetailreportsearchform();
					   var grid = this.getCoursedetailreportgrid();
					   var values = form.getValues();
					   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
					   var courseId = values.courseName;
					   var departmentId = values.department;
					   var courseMarksGrades = values.courseMarkGrade;
					   var sectionType = values.sectionType;
					   var whetherDeleted = values.whetherIncludeDeeletedCourses;

					   var store = grid.getStore();
					   store.removeAll();
					   store.getProxy().api.read=SERVERURL.PATH_FIND_ALL_COURSES_DETAIL_REPORT;
					   store.getProxy().extraParams = {
						   academyLocationIds: acadLocationIdsCommaSepeated,
						   courseId: courseId,
						   departmentId: departmentId,
						   courseMarksGrdType: courseMarksGrades,
						   sectionType: sectionType,
						   whetherDeleted: whetherDeleted
					   };
					   this.resetPageSetting(store);
					   store.load();
					   grid.config.searchFilterForm = form;
				   }
		},
			
		'coursedetailreportsearchform button[itemId=resetBtn]':{
        	click: function(obj,record) {
				var $this = this;
        		var form=$this.getCoursedetailreportsearchform();
        		form.getForm().reset();
	   }
	},
		'coursedetailreportgrid' :{
			render:function(grid){
//				this.doAccessControlValidation(grid, this.getCOURSE_DETAIL_REPORT_ON_TREE_PERMISSIONS());
			}, 
			  afterrender:function(grid){
  				 var me =this;
  				setTimeout(function(){ 
  					me.addDataGridConfigButton(grid, me.getCOURSE_DETAIL_REPORT_ON_TREE_PERMISSIONS());
  				},1500)
  				},
		}

	   });
   },
   disableExportBtnActionPivilegesOfCourseEnrollReport: function(gridReference,permissionsMap) {
	   var associatedAcadLocationIds = new Array();
	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   buttonsToolBar = gridReference.query('toolbar')[0];
	   var exportReportButton = gridReference.down('#exportStudentCourseEnrollmentReportsId');
	   exportReportButton.setVisible(false);
	   Ext.each(permissionList, function(privilege) {
		   if (privilege === 'EXPORT_REPORTS') {
			   if(!isNullOrEmpty(exportReportButton)){
				   exportReportButton.setVisible(true);
			   }        	
		   }
	   });
   },
   getJsonObject: function(key, value, additionalValue) {
    	 if (value != '' && value != null && additionalValue == undefined) {
    		 return {
    			 "paramCode": key,
    			 "paramValues": [value]
    		 };
    	 } else if (value != '' && additionalValue != undefined) {
    		 return {
    			 "paramCode": key,
    			 "paramValues": [value, additionalValue]
    		 };
    	 }
     },
     pushJsonObjectInArray: function(object, array) {
    	 if (object) {
    		 array.push(object);
    	 }
     },
   getOpenDashbordStructure : function(treePanel, record, item,index, e, eOpts){
	   var $this = this;
	   var containpanel = $this.getDashboardmainstructure();
	   var treePanel = containpanel.down('#programDashboardReportTreePanelItemId');
	   var tabDetail = record.data;
	   var structure = Ext.widget(tabDetail.reportXtype);
	   var tabstructure = containpanel.down('#tabpanelIds');

	   if (!isNullOrEmpty(tabDetail.text)
			   && !isNullOrEmpty(tabDetail.reportXtype)
			   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
		   treePanel.toggleCollapse();
		   openTab(tabstructure, tabDetail.text,structure);
		   treePanel.getSelectionModel().deselectAll();
	   }
   },
   
   // load Richtipchartreport
   
   loadRichTipChartReport:function(obj){
	   var this$ = this;
	   var structure = this.getProgramsummarystructure();
	   var vacantSeatExtraBtns = structure.down('#vacantSeatExtraBtns');
	   var str = this.getRichtipchartreport();
    	var resultViewUrl = SERVERURL.USERQUICKSEARCH;
    	var configCode = CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATS_LISTING_VIEWCODE;
    	var jsonFormatFormData = this.createJsonFormatCommon1(configCode);
        Ext.Ajax.request({
            type: 'rest',
            url: resultViewUrl +'?page=1&limit=10',
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: jsonFormatFormData,
            success: function(response) {
            	data = Ext.decode(response.responseText);
            	obj.getStore().loadData(data.rows);
            	this$.addExportToPngForDashboard(vacantSeatExtraBtns.menu,obj);
            	if(data.rows.length > 0){
            		vacantSeatExtraBtns.setVisible(true);
            		this$.doAccessVacantSeatReportView(vacantSeatExtraBtns);
            	}else{
            		vacantSeatExtraBtns.setVisible(false);
            	}
            }
        });
        
    	var resultViewUrl1 = SERVERURL.USERQUICKSEARCH;
    	var configCode1 = CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATSBATCH_LISTING_VIEWCODE;
    	var jsonFormatFormData1 = this.createJsonFormatCommon(configCode1);
    	Ext.Ajax.request({
	            type: 'rest',
	            url: resultViewUrl1 +'?page=1&limit=-1',
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json'
	            },
	            jsonData: jsonFormatFormData1,
	            success: function(response) {
	            	data = Ext.decode(response.responseText);
	            	var store = Academia.store.programCourseDashboard.ProgramVacantSeatsBatchStore;
	            	store.data = data.rows;
	            }
	        });
   },
   // Program Vacant, when click on Batch Name it shows the batch listing
   linkBatchFromProgVacant: function(view, rowIndex, record) {

	   if(record.data.ID>0){
		   var batchId = record.data.ID;
		   var formWindow = this.getProgramvacantbatchdetailwindow();
		   if (!formWindow) {
			   Ext.widget('programvacantbatchdetailwindow');
			   formWindow = this.getProgramvacantbatchdetailwindow();		                            
		   }
		   formWindow.setTitle(record.data.PROGRAM_NAME+' - '+record.data.BATCH_NAME);
		   formWindow.show();
		   // code to add CB grid with windows
		   var values = new Object();  
		   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATSBATCH_LISTING_VIEWCODE;
		   var form = this.getProgramvacantbatchdetailwindow();
		   var jsonFormatFormData = this.createJsonProgramVacantBatch(form,batchId);
		   var searchResultGrid = this.getProgramVacantBatchDtlGridId();
		   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATSBATCH_LISTING_VIEWCODE);
		   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	   }
   },


   createJsonProgramVacantBatch:function(quickSearchForm,batchId){
	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_PROGRAM_VACANTS_SEATSBATCH_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();

	   if(batchId!='' && batchId>=0){
		   searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId]});
	   }

	   values.searchCriterias=searchcriteria;
	   return values;
   },


   loadDynamicGrid: function(respectiveLinkViewCode, respectiveLinkConfigCode,getResultGrid) {
	   var searchResultGrid = getResultGrid; // getDynamic Result Grid
	   var jsonFormatFormData = this.createJsonFormatCommon1(respectiveLinkConfigCode);
	   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	   resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode); 
	   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
   },

   // createJsonFormatForProgramVacant
   createJsonFormatCommon1:function(respectiveLinkConfigCode){			
	   var values = new Object();
	   values.configCode = respectiveLinkConfigCode;
	   var searchcriteria = new Array();
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   var acadLocationIdsCommaSepeatedString = "" + acadLocationIdsCommaSepeated + "";
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeatedString]});
	   }
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   createJsonFormatCommon:function(respectiveLinkConfigCode){			
	   var values = new Object();
	   values.configCode = respectiveLinkConfigCode;
	   var searchcriteria = new Array();
	   values.searchCriterias=searchcriteria;
	   return values;
   },

   // method method is used to load programs in General Summary -> Top and Bottom Attendance
   loadPrograms:function(academyLocationIds){
	   var academyLocationId=0;
	   if(academyLocationIds.length>0){
		   academyLocationId = academyLocationIds.join();
	   }
	   this.getGeneralsummarysearch().down('#programId').clearValue();

	   var store = this.getStore('common.ProgramsByAcademyLocationsIds');
	   store.getProxy().extraParams = {
		   academyLocationIds:academyLocationId
	   };
	   store.load();
   },

   loadDepartments : function(academyLocationIds){
	   var academyLocationId=0;
	   if(academyLocationIds.length>0){
		   academyLocationId = academyLocationIds.join();
	   }

	   this.getGeneralsummarysearch().down('#departmentId').clearValue();

	   var store = this.getStore('department.DepartmentAcademyLocationWiseStore');
	   store.getProxy().extraParams = {
		   academyLocationsIds:academyLocationId
	   };
	   store.load();
   },

   loadSectionWiseCourses : function(academyLocationIds){
	   
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();

	   var store = this.getStore('attendance.CoursesByAcademyLocationIds');
	   store.getProxy().extraParams = {
		   academyLocationIds:acadLocationIdsCommaSepeated
	   };
	   store.load();
   },

   createJsonFormatForFaculty:function(quickSearchForm, record){			

	   var departmentId = quickSearchForm.down('#departmentId');
	   var subDepartmentId = quickSearchForm.down('#subDepartmentId');
	   
	   var value = quickSearchForm.down('#topOrBottomAttendanceId').getValue();
	   var attendancePercentage = quickSearchForm.down('#attendancePercentage');
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.FACULTY_ATTENDANCE_DASHBOARD_LIST_CONFIGCODE;

	   var searchcriteria = new Array();
	   if(attendancePercentage.getValue() != "" && attendancePercentage.getValue() != null){
    		  if(value.topOrBottomAttendance=='TOP_ABSENTEEISM'){
    			   searchcriteria.push({paramCode:"PRESENT_PERCENTAGE_GREATER", paramValues:[attendancePercentage.getValue()]});
    		   }
    		   else if(value.topOrBottomAttendance=='BOTTOM_ABSENTEEISM'){
    			   searchcriteria.push({paramCode:"PRESENT_PERCENTAGE_LESS", paramValues:[attendancePercentage.getValue()]});   
    		   }
    	   }
	   if(departmentId.getValue() != "" && departmentId.getValue() != null){
		   searchcriteria.push({paramCode:"DEPARTMENT_ID", paramValues:[departmentId.getValue()]});
	   }
	   if(subDepartmentId.getValue() != "" && subDepartmentId.getValue() != null){
		   searchcriteria.push({paramCode:"SUBDEPARTMENT_ID", paramValues:[subDepartmentId.getValue()]});
	   }

	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }	
	   values.searchCriterias=searchcriteria;
	   return values;
   },

   // Top and Bottom Attendance student wise
   createJsonFormatForStudent:function(quickSearchForm, record){			

	   var programId = quickSearchForm.down('#programId');
	   var batchId = quickSearchForm.down('#batchId');
	   var periodId = quickSearchForm.down('#periodId');  
	   var sectionId = quickSearchForm.down('#sectionId');
	   var attendancePercentage = quickSearchForm.down('#attendancePercentage');
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_TOP_BOTTOM_ATTENDANCE_STUDENTWISE_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();
	   
	   var value = quickSearchForm.down('#topOrBottomAttendanceId').getValue();
	   
	   if(attendancePercentage.getValue() != "" && attendancePercentage.getValue() != null){
		   if(value.topOrBottomAttendance=='TOP_ABSENTEEISM'){
			   searchcriteria.push({paramCode:"PRESENT_PERCENTAGE_GREATER", paramValues:[attendancePercentage.getValue()]});
		   }
		   else if(value.topOrBottomAttendance=='BOTTOM_ABSENTEEISM'){
			   searchcriteria.push({paramCode:"PRESENT_PERCENTAGE_LESS", paramValues:[attendancePercentage.getValue()]});   
		   }
		}
	   
	   if(programId.getValue() != "" && programId.getValue() != null){
		   searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
	   }
	   if(batchId.getValue() != "" && batchId.getValue() != null){
		   searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId.getValue()]});
	   }
	   if(periodId.getValue() != "" && periodId.getValue() != null){
		   searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
	   }
	   if(sectionId.getValue() != "" && sectionId.getValue() != null){
		   searchcriteria.push({paramCode:"SECTION_ID", paramValues:[sectionId.getValue()]});
	   }
	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }
	   values.searchCriterias=searchcriteria;
	   return values;
   },


   createJsonPopularCoursePBS:function(quickSearchForm, record,configCode){			
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   var programId = quickSearchForm.down('#programId');
	   var batchId = quickSearchForm.down('#batchId');
	   var periodId = quickSearchForm.down('#periodId');  
	   var courseIdPBS = quickSearchForm.down('#courseIdPBS');

	   var values = new Object();
	   values.configCode = configCode;//CONSTANTS.CB.PNC_DASHBOARD_MOST_LEAST_POPULAR_COURSES_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();

	   if(programId.getValue() != "" && programId.getValue() != null){
		   searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
	   }
	   if(batchId.getValue() != "" && batchId.getValue() != null){
		   searchcriteria.push({paramCode:"PROGRAM_BATCH_ID", paramValues:[batchId.getValue()]});
	   }
	   if(periodId.getValue() != "" && periodId.getValue() != null){
		   searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
	   }
	   if(courseIdPBS.getValue() != "" && courseIdPBS.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseIdPBS.getValue()]});
	   }
	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMY_LOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }	
	   values.searchCriterias=searchcriteria;
	   return values;
   },

   // Most and least popular course => CBS
   createJsonPopularCourseCBS:function(quickSearchForm, record,configCode){			
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   var courseId = quickSearchForm.down('#courseIdCBS');

	   var values = new Object();
	   values.configCode = configCode; //CONSTANTS.CB.PNC_DASHBOARD_MOST_AND_LEAST_POUPLAR_COURSECBS_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();

	   if(courseId.getValue() != "" && courseId.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseId.getValue()]});
	   }
	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }	
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   /*************** Program batch report ***************/
   createJsonProgramBatchReport:function(quickSearchForm, record){			

//	   var programId = quickSearchForm.down('#programId');
//	   var batchId = quickSearchForm.down('#batchId');
	   var value = quickSearchForm.getForm().getValues();
	   var batchId =  value.batchId;
	   var startDate = quickSearchForm.down('#fromDate').getValue();
	   var endDate = quickSearchForm.down('#toDate').getValue();
	   var tillDate = quickSearchForm.down('#toDate').getValue();
	   
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   if(typeof acadLocationIdsCommaSepeated == "number"){
		   acadLocationIdsCommaSepeated = acadLocationIdsCommaSepeated.toString();
	   }
	   var alIds = acadLocationIdsCommaSepeated.split(",");

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PROGRAM_BATCH_REPORT_CONFIG_CODE;

	   var searchcriteria = new Array();

	   var programs;
	   var programids = [];
		if(value.programId !="" && value.programId !=null){
			for(var i in value.programId){
				if(Ext.isObject(value.programId[0])){
					programs = value.programId[i].get("id");
					programids.push(programs);
				}else{
					programs = value.programId[i];
					programids.push(programs);
				}
			}
		}	
	   
	   
	   
	   if(programids != "" && programids != null){
		   searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:programids});
	   }
	   if(!isNullOrEmpty(batchId)){
		   searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId]});
	   }
	   
	   //searchcriteria.push({paramCode:"ADMISSION_STATUS", paramValues:['ADMISSION_CONFIRMED']});
	   
	   
	   if(startDate != "" && startDate != null){
		   var fromDate = Ext.Date.format(new Date(startDate), 'Y-m-d');
		   
		   var tillDate;
		   if(!isNullOrEmpty(endDate)){
			   tillDate = Ext.Date.format(new Date(endDate), 'Y-m-d');
		   }else{
			   tillDate = Ext.Date.format(new Date(), 'Y-m-d');
		   }
			
		   searchcriteria.push({paramCode:"START_DATE", paramValues:[fromDate,tillDate]});
		   searchcriteria.push({paramCode:"TILL_DATE", paramValues:[tillDate]});
	   }	                	
	  
	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMY_LOCATION_IDS", paramValues:alIds});
	   }
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   createJsonProgramBatchFeeDetialsReport:function(batchId){
	   var values = new Object();
	   values.configCode = CONSTANTS.CB.BATCH_FEE_PLAN_DETAILS_CONFIG_CODE;
	   var searchcriteria = new Array();
	   if(batchId != "" && batchId != null){
		   searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId]});
	   }
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   // Course Summary => Top and bottom course absenteeism	
   createJsonTopBottomCourseAbsenteeism:function(quickSearchForm, record){			

	   var courseId = quickSearchForm.down('#courseId');
	   var attendancePercentage = quickSearchForm.down('#attendancePercentage');  
	   var value = quickSearchForm.down('#topOrBottomAttendanceId').getValue();
	   
	   var startDate = quickSearchForm.down('#startDate').getValue();
	   var tillDate = quickSearchForm.down('#tillDate').getValue();
	   
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.TOP_BOTTOM_COURSE_ABSENTEEISM_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();

	   if(courseId.getValue() != "" && courseId.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseId.getValue()]});
	   }
	   
	   if(startDate != "" && startDate != null){
		   searchcriteria.push({paramCode:"DATE_OF_ATTENDANCE_BEFORE", paramValues:[startDate]});
	   }	                	
	   
	   if(tillDate != "" && tillDate != null){
		   searchcriteria.push({paramCode:"DATE_OF_ATTENDANCE_AFTER", paramValues:[tillDate]});
	   }
	   
	   if(attendancePercentage.getValue() != "" && attendancePercentage.getValue() != null){
		   if(value.topOrBottomAttendance=='TOP_ABSENTEEISM'){
			   searchcriteria.push({paramCode:"ABSENT_PERCENT_GREATER", paramValues:[attendancePercentage.getValue()]});
		   }
		   else if(value.topOrBottomAttendance=='BOTTOM_ABSENTEEISM'){
			   searchcriteria.push({paramCode:"ABSENT_PERCENT_LESS", paramValues:[attendancePercentage.getValue()]});   
		   }
		}
	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   
   // Top and bottom program Absenteeism
   // TODO sorting is not working, but top and bottom attendance sort code is working
   createJsonTopBottomProgramAbsenteeism:function(quickSearchForm, record){			
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();	
	   var programId = quickSearchForm.down('#programId');
	   var batchId = quickSearchForm.down('#batchId');
	   var periodId = quickSearchForm.down('#periodId');
	   
	   var startDate = quickSearchForm.down('#startDate').getValue();
	   var tillDate = quickSearchForm.down('#tillDate').getValue();
	   
	   
	   var attendancePercentage = quickSearchForm.down('#attendancePercentage');
	   
	   var value = quickSearchForm.down('#topOrBottomAttendanceId').getValue();

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PNC_TOP_BOTTOM_PROGRAM_ABSENTEEISM_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();	                	   
	   
	   if(attendancePercentage.getValue() != "" && attendancePercentage.getValue() != null){
		   if(value.topOrBottomAttendance=='TOP_ABSENTEEISM'){
			   searchcriteria.push({paramCode:"ABSENT_PERCENT_GREATER", paramValues:[attendancePercentage.getValue()]});
		   }
		   else if(value.topOrBottomAttendance=='BOTTOM_ABSENTEEISM'){
			   searchcriteria.push({paramCode:"ABSENT_PERCENT_LESS", paramValues:[attendancePercentage.getValue()]});   
		   }
	   }
	   
	   if(programId.getValue() != "" && programId.getValue() != null){
		   searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
	   }
	   
	   if(batchId.getValue() != "" && batchId.getValue() != null){
		   searchcriteria.push({paramCode:"BATCH_ID", paramValues:[batchId.getValue()]});
	   }
	   
	   if(periodId.getValue() != "" && periodId.getValue() != null){
		   searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
	   }	                	   
	   
	   if(startDate != "" && startDate != null){
		   searchcriteria.push({paramCode:"DATE_OF_ATTENDANCE_BEFORE", paramValues:[startDate]});
	   }	                	
	   
	   if(tillDate != "" && tillDate != null){
		   searchcriteria.push({paramCode:"DATE_OF_ATTENDANCE_AFTER", paramValues:[tillDate]});
	   }	                	
	   
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
           searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
       }     
	   values.searchCriterias=searchcriteria;
	   return values;
   },
     
   // delayed course CBS search
   createJsonDelayedCourseCBS:function(quickSearchForm, record){			
	   
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   var courseIdCBS = quickSearchForm.down('#courseIdCBS');
	   var cbsAcademicTerm = quickSearchForm.down('#academicTermId');
	   var cbsCourseVariant = quickSearchForm.down('#courseVariantId');
	   
	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_DELAYED_COURSECBS_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();

	   if(courseIdCBS.getValue() != "" && courseIdCBS.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseIdCBS.getValue()]});
	   }
	   if(cbsAcademicTerm.getValue() != "" && cbsAcademicTerm.getValue() != null){
		   searchcriteria.push({paramCode:"ACADEMIC_TERM_ID", paramValues:[cbsAcademicTerm.getValue()]});
	   }
	   if(cbsCourseVariant.getValue() != "" && cbsCourseVariant.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_VARIANT_ID", paramValues:[cbsCourseVariant.getValue()]});
	   }
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }
	   
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   
   // Create JSON for Delayed Course PBS Search 
   createJsonDelayedCoursePBS:function(quickSearchForm, record){			

	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   
	   var programId = quickSearchForm.down('#programId');
	   var batchId = quickSearchForm.down('#batchId');
	   var periodId = quickSearchForm.down('#periodId');  
	   var courseIdPBS = quickSearchForm.down('#courseIdPBS');
	   var programSectionId = quickSearchForm.down('#programSectionId');
	   var facultyCodeItemId = quickSearchForm.down('#facultyCodeItemId');

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PNC_DASHBOARD_DELAYED_COURSEPBS_LISTING_CONFIGCODE;

	   var searchcriteria = new Array();

	   if(programId.getValue() != "" && programId.getValue() != null){
		   searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
	   }
	   if(batchId.getValue() != "" && batchId.getValue() != null){
		   searchcriteria.push({paramCode:"PROGRAM_BATCH_ID", paramValues:[batchId.getValue()]});
	   }
	   if(periodId.getValue() != "" && periodId.getValue() != null){
		   searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
	   }
	   if(courseIdPBS.getValue() != "" && courseIdPBS.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseIdPBS.getValue()]});
	   }
	   if(programSectionId.getValue() != "" && programSectionId.getValue() != null){
		   searchcriteria.push({paramCode:"SECTION_ID", paramValues:[programSectionId.getValue()]});
	   }
	   if(facultyCodeItemId.getValue() != "" && facultyCodeItemId.getValue() != null){
		   searchcriteria.push({paramCode:"FACULTY_ID", paramValues:[facultyCodeItemId.getValue()]});
	   }
	   // code for multiple academy location id comma seperated
	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
	   }	                	   
	   values.searchCriterias=searchcriteria;
	   return values;
   },
   
   detailedTab:function(searchResultGrid,quickSearchForm,columnName){
	 var $this = this;
	 var contentpanel = $this.getDashboardmainstructure().down('#tabpanelIds');
//	 var contentpanel = $this.getDashboardmainstructure().items.items[1];
	 var structure = Ext.widget('dashboarddetailedtabstrucure');
	 var tabName  = getProgramandcourseTranslation('DETAILED_TAB');
	 var tabDetail = contentpanel.items.items;
	 for(var i in tabDetail){
		 if(tabDetail[i].title==tabName){
			 tabDetail[i].close();
		 }
	 }
	 openTab(contentpanel, tabName, structure);
	 this.showDetailedTab(searchResultGrid,quickSearchForm,columnName);
   },
   
   showDetailedTab:function(searchResultGrid,quickSearchForm,columnName){
	   var $this = this;
	   
	   var detailedForm = $this.getDetailedtabsearchform();
	   var form = detailedForm.getForm();
	   var records = searchResultGrid.getSelectionModel().getSelection();
	   
	   var data = records[0].data;
//	   var date = data.DATE;
	   //form.findField('date').setValue(date);
	   
	   if(columnName == 'PROGRAM_NAME'){
		 detailedForm.down('#pbpId').setVisible(true);
		 detailedForm.down('#course').setVisible(false);
		 
	   var programName = data.PROGRAM_NAME;
	   var batchName = data.BATCH_NAME;
	   var periodName = data.PERIOD_NAME;
	   form.findField('program').setValue(programName);
	   form.findField('batch').setValue(batchName);
	   form.findField('period').setValue(periodName);
	   
	   }else{
		   detailedForm.down('#pbpId').setVisible(false);
		   detailedForm.down('#course').setVisible(true);
		   var courseName = data.COURSE_NAME;
		   form.findField('course').setValue(courseName);
	   }

	   var startDate = quickSearchForm.down('#startDate').getValue();
	   var tillDate = quickSearchForm.down('#tillDate').getValue();
	   
	   if(startDate !=null && startDate !=""){
		   var sdate = startDate;
		   form.findField('fromDate').setVisible(true);
		   form.findField('fromDate').setValue(dateRender(sdate));
	   }
	   
	   if(tillDate !=null && tillDate !=""){
		   var tdate = tillDate;
		   form.findField('toDate').setVisible(true);
		   form.findField('toDate').setValue(dateRender(tdate));
	   }
	   
	   var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
	   var detailedSearchResultGrid = $this.getDetailedsearchresultgrid();
	   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PNC_COURSE_BASED_SUMMARY_REPORT_LIST_VIEWCODE);
	   detailedSearchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
   },
   
   createJsonFormat:function(quickSearchForm,records){
	   var data = records[0].data;

	   var periodId = data.PERIOD_ID;
	   var courseId = data.COURSE_ID;
	   
	   var startDate = quickSearchForm.down('#startDate').getValue();
	   var tillDate = quickSearchForm.down('#tillDate').getValue();
	   

	   var values = new Object();
	   values.configCode = CONSTANTS.CB.PNC_COURSE_BASED_SUMMARY_REPORT_LIST_CONFIGCODE;
	   var searchcriteria = new Array();

	   if(periodId != null ){
		   searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId]});
	   }
	   
	   if(courseId != null){
		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseId]});
	   }

	   if(startDate != null && startDate != ""){
		   searchcriteria.push({paramCode:"DATE_OF_ATTENDANCE_BEFORE", paramValues:[startDate]});
	   }

	   if(tillDate != null && tillDate != ""){
		   searchcriteria.push({paramCode:"DATE_OF_ATTENDANCE_AFTER", paramValues:[tillDate]});
	   }

	   values.searchCriterias=searchcriteria;
	   return values;
   },
   
   loadAcademyLocation:function(){
	   var acadLocationIdsCommaSepeated = this.getAcademyLocationIds();
	   
	   var store = this.getStore('common.ProgramsByAcademyLocationsIds');
	   store.getProxy().extraParams = {
		   academyLocationIds: acadLocationIdsCommaSepeated
	   };
	   store.load();   

	   var store = this.getStore('common.ClassTeacherProgramStore');
	   store.getProxy().extraParams = {
		   academyLocationIds: acadLocationIdsCommaSepeated
	   };
	   store.load(); 
	   
	   var store = this.getStore('attendance.CoursesByAcademyLocationIds');
	   store.getProxy().extraParams = {
		   academyLocationIds:acadLocationIdsCommaSepeated
	   };
	   store.load();

	   var store = this.getStore('department.DepartmentAcademyLocationWiseStore');
	   store.getProxy().extraParams = {
		   academyLocationsIds:acadLocationIdsCommaSepeated
	   };
	   store.load();
	   
	   var store = this.getStore('common.ActiveUserStore');
	   store.getProxy().extraParams = {
		   academyLocationIds:acadLocationIdsCommaSepeated
	   };
	   store.load();
	
	   var store = this.getStore('coursetransaction.studymaterialdistribution.CoursesByAcademyLocationId');
	   store.getProxy().extraParams = {
		   academyLocationIds:acadLocationIdsCommaSepeated
	   };
	   store.load();	  

	   if(!isNullOrEmpty(this.getCourserosterreportsearchform())){
		   	var courseRosterForm =  this.getCourserosterreportsearchform();
			var academicTerm = courseRosterForm.down('#academicTerm');
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				courseRosterForm.down("#periodItemId").hide();
			}else{
				courseRosterForm.down("#periodItemId").setVisible(true);
			}
			academicTerm.clearValue();
			var academicTermStore = academicTerm.getStore();
			academicTermStore.load({
				callback: function(record, operation, success) {
					if (success) {
						if(record.length>0){
							Ext.each(record, function(value) {
								if(value.get('whetherCurrentAcademicTerm')){
									courseRosterForm.down("#academicTerm").setValue(value.get('id'));
								}
							});
						}
					}
				}
			});
	   }
	   if(!isNullOrEmpty(this.getStudentcoursesectionreportsearchform())){
		   var studentcoursesectionreportsearchform =  this.getStudentcoursesectionreportsearchform();
		   var academicTerm = studentcoursesectionreportsearchform.down('#academicTerm');
		   var alinfomodel = Academia.model.authentication.ALInfoModel;
		   var wheatherSchool = alinfomodel.get('wheatherSchool');
		   academicTerm.clearValue();
		   var academicTermStore = academicTerm.getStore();
		   academicTermStore.getProxy().extraParams = {
			   academyLocationIds:acadLocationIdsCommaSepeated
		   };
		   academicTermStore.load({
			   callback: function(record, operation, success) {
				   if (success) {
					   if(record.length>0){
						   Ext.each(record, function(value) {
							   if(value.get('whetherCurrentAcademicTerm')){
								   studentcoursesectionreportsearchform.down("#academicTerm").setValue(value.get('id'));
							   }
						   });
					   }
				   }
			   }
		   });
	   }
	   if(!isNullOrEmpty(this.getStudentcourseenrollmentreportsearchform())){
		   var $this = this;
		   var form = $this.getStudentcourseenrollmentreportsearchform();
		   form.getForm().reset();
		   var programGroupId=form.down('#programGroupId');
		   var batchId=form.down('#batchId');
		   var periodId=form.down('#periodId');
		   var studentId=form.down('#studentId');
		   batchId.setDisabled(true);
		   periodId.setDisabled(true);
		   var academyLocationIds;
			if(this.getCurrentLoggedPortalId()==2){
				academyLocationIds = this.getCurrentAcademyLocation();
			}else{
				academyLocationIds = this.getAcademyLocationIds();
			}
			var store=programGroupId.getStore();
			store.getProxy().extraParams={
				academyLocationIds:academyLocationIds,
			};
			store.load();
			 var studentStore = studentId.getStore();
		        studentStore.getProxy().extraParams = {
		            academyLocationIds: academyLocationIds,
		        };
		        studentStore.load();
	   }else if(!isNullOrEmpty(this.getCoursesearchattendance())){
		   var $this = this;
		   var form = $this.getCoursesearchattendance();
		   form.getForm().reset();
		   form.down("#studentId").setDisabled(true);
		   form.down("#programBatch_programId").reset();
		   form.down("#programBatch_programId").clearValue();
		   form.down("#programBatch_programId").setDisabled(true);
		   form.down("#programBatch_batchId").setDisabled(true);
		   form.down("#programBatch_periodId").setDisabled(true);
		   form.down("#programCoursection_ID").setDisabled(true);
		   form.down("#course_Id").setDisabled(true);
		   form.down("#startDate").setMinValue(false);
		   form.down("#startDate").setMaxValue(new Date());
		   form.down("#endDate").setMinValue(false);
		   form.down("#endDate").setMaxValue(new Date());
		   var academicTerm = form.down('#academicTermId');
		   academicTerm.reset();
		   var academicTermStore = academicTerm.getStore();
   			academicTermStore.load({
   			callback: function(record, operation, success) {
   				if (success) {
   					if(record.length>0){
   						Ext.each(record, function(value) {
   							if(value.get('whetherCurrentAcademicTerm')){
   								form.down("#academicTermId").setValue(value.get('id'));
   							}
   						});
   					}
   				}
   			}});
		   this.getCourseattendancegrid().down('#exportReportsId').setDisabled(true);
	   }else if(!isNullOrEmpty(this.getProgramPromotionForm())){
		   var $this = this;
		   var form = $this.getProgramPromotionForm();
		   setTimeout(function() {
			   form.down('#programId').reset();
			   form.down('#programId').clearValue();
			   
		   },10);
		   var store = form.down('#programId').getStore();
		   store.getProxy().extraParams = {
			   academyLocationIds: acadLocationIdsCommaSepeated
		   };
		   store.load();
		   form.down('#batchId').reset();
		   form.down('#batchId').setDisabled(true);
		   form.down('#periodId').reset();
		   form.down('#periodId').setDisabled(true);
		   form.down('#sectionId').reset();
		   form.down('#sectionId').setDisabled(true);
		   form.down('#promotionStatusId').reset();
		   form.getForm().reset();
	   }
	   else if(!isNullOrEmpty(this.getDelayedcoursesearch())){
		   var $this = this;
		   var form = $this.getDelayedcoursesearch();
		   var value = form.down('#selectionTypeId').getValue();
		   if(value.selectionType =='COURSE_SECTION'){
			   var courseCBS = form.down('#courseIdCBS');
			   form.down('#courseVariantId').clearValue();
			   form.down('#courseVariantId').setDisabled(true);
			   var courseAcademicTerm=form.down('#academicTermId');
			   courseCBS.reset();
			   courseAcademicTerm.reset();
			   var courseStore = courseCBS.getStore();
			   var academicTermComboStore = courseAcademicTerm.getStore();
			   academicTermComboStore.getProxy().extraParams = {
				  academyLocationIds : acadLocationIdsCommaSepeated
			   };
			   academicTermComboStore.load({
	
				  callback: function(rec, success) {
					  if (success) {
						  var j=0;
						  for(var i in rec){
							  if(rec[i].get('sequence')==1){
								j++;
								$this.getDelayedcoursesearch().down('#academicTermId').setValue(rec[i].get('id'));
								var academicTermId =rec[i].get('id'); 
								courseStore.getProxy().extraParams = {
									 sectionType : 'CourseSection',
									 academyLocationIds : acadLocationIdsCommaSepeated,
									 academicTermId:academicTermId
								 };
								 courseStore.load();
							  }
						  }
						  if(j==0){
							  courseStore.getProxy().extraParams = {
									 sectionType : 'CourseSection',
									 academyLocationIds : acadLocationIdsCommaSepeated
								 };
								 courseStore.load();
						  }
	
					  }
				  }
			   });				   
		   }
		   
	   }
	   
	   if(!isNullOrEmpty(this.getSectionrosterreportsearchform())){
		   var acadIds = this.getContentpanel().getActiveTab().down('#programCourseOrganizationunitId').down('#multiselectAcademyLocationId').getValue();
		   var form = this.getSectionrosterreportsearchform();
		   
		   var intakeYear = form.down('#intakeYear');
		   var programGroupId = form.down('#programGroupId');
		   var prggrpstore = programGroupId.getStore();
		   var programId = form.down('#programItemId');
		   var prgstore = programId.getStore();
		   var facultyItemId = form.down('#facultyItemId');
		   var facultystore = facultyItemId.getStore();
		   
		   if(acadIds.length>0 && !isNullOrEmpty(acadIds[0])){
			   intakeYear.reset();
			   intakeYear.clearValue();
			   intakeYear.getStore().load();
		   
		   
			   prggrpstore.getProxy().extraParams.academyLocationIds = acadLocationIdsCommaSepeated;
			   prggrpstore.load();
			   programGroupId.reset();
			   programGroupId.clearValue();
		   
		   
			   prgstore.getProxy().extraParams.academyLocationIds = acadLocationIdsCommaSepeated;
			   prgstore.load();
			   programId.reset();
			   programId.clearValue();
		   
		   
			   facultystore.getProxy().extraParams.academyLocationIds = acadLocationIdsCommaSepeated;
			   facultystore.load();
			   facultyItemId.reset();
			   facultyItemId.clearValue();
		   }
		   else{
			   intakeYear.getStore().removeAll();
			   prggrpstore.removeAll();
			   prgstore.removeAll();
			   facultystore.removeAll();
		   }
	   }
   },
   showFeeDetailWindow:function(record){
	   var formWindow = this.getProgrambatchfeedetailsreport();
	   if (!formWindow) {
		   Ext.widget('programbatchfeedetailsreport');
		   formWindow = this.getProgrambatchfeedetailsreport();
	   }
	   formWindow.show();
	   this.setDataForFeeDetails(record);
   },
   setDataForFeeDetails:function(record){
	   var form = this.getProgrambatchFeedetailsreport().getForm();
	   var programCode = record.data.PROGRAM_CODE;
	   var programName = record.data.PROGRAM_NAME;
	   var batchName = record.data.BATCH_NAME;
	   var batchId = record.data.BATCH_ID;
	   
	   form.findField('programCode').setValue(programCode);
	   form.findField('programName').setValue(programName);
	   form.findField('batchName').setValue(batchName);
	   
	   var values = new Object();
	   values.configCode = CONSTANTS.CB.BATCH_FEE_PLAN_DETAILS_VIEW_CODE;
	   var jsonFormatFormData = this.createJsonProgramBatchFeeDetialsReport(batchId);
	   var searchResultGrid = this.getProgramBatchFeeDetailsGrid();
	   searchResultGrid.setTitle(getCommonTranslation('FEE_DETAILS'));
	   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.BATCH_FEE_PLAN_DETAILS_VIEW_CODE);
	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
	   Ext.getBody().unmask();
	   
   },
   gridRenderFunction:function(grid){
  	 grid.addButtonToolbar();
   },
   //*******************************Export functionality********************************
   exportUserListforDashboard : function(exportUrl,filetype,whetherAll,grid) {
	   var quickSearchForm = null;
	   var searchResultGrid = null;
	   var pagingtoolbaroptions = null; 
	   var searchCriteriaString = null;
	   var jsonFormatFormData = null;
	   if(grid=='mostleastpopularcoursespbsGridId')
	   { 
		   quickSearchForm=this.getCoursesummarystructure(); 
		   var searchForm = quickSearchForm.getForm();
		   var mostAndLeastApplied = searchForm.findField('mostAndLeastApplied').getValue();
		   
		   var configCode=null; 
		   if(mostAndLeastApplied){
			   configCode = CONSTANTS.CB.PNC_DASHBOARD_MOST_POUPLAR_COURSE_LISTING_CONFIGCODE;
		   }else{
			   configCode = CONSTANTS.CB.PNC_DASHBOARD_LEAST_POUPLAR_COURSE_LISTING_CONFIGCODE;
		   
		   }
		   
	    // quickSearchForm=this.getCoursesummarystructure(); 
	     searchResultGrid = this.getMostleastpopularcoursespbsGridId();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonPopularCoursePBS(quickSearchForm,null,configCode);
	   } 
	   if(grid=='mostleastpopularcoursescbsGridId')
	   {	   
		  quickSearchForm=this.getCoursesummarystructure();  
	     configCode = CONSTANTS.CB.PNC_DASHBOARD_LEAST_POUPLAR_COURSE_LISTING_CONFIGCODE;
	     searchResultGrid = this.getMostleastpopularcoursescbsGridId();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonPopularCoursePBS(quickSearchForm,null,configCode);
	   }
	   if(grid=='delayedCourseSearchGrIdPBS')
	   {
	     quickSearchForm = this.getDelayedcoursesearch();
		 //quickSearchForm=this.getCourseexecutionreportstructure();	//V2D-14780
	     searchResultGrid = this.getDelayedCourseSearchGrIdPBS();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonDelayedCoursePBS(quickSearchForm);
	   }
	   if(grid=='delayedCourseSearchGrIdCBS')
	   {
	     quickSearchForm=this.getDelayedcoursesearch();
		// quickSearchForm=this.getCourseexecutionreportstructure();	//V2D-14780
	     searchResultGrid = this.getDelayedCourseSearchGrIdCBS();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonDelayedCourseCBS(quickSearchForm);
	   }
	   if(grid=='topBottomCourseAbsenteeismSearchGridId')
	   {	   
	     quickSearchForm=this.getTopbottomcourseabsenteeismsearch(); 
	     searchResultGrid = this.getTopBottomCourseAbsenteeismSearchGridId();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonTopBottomCourseAbsenteeism(quickSearchForm);
	   }
	   if(grid=='topandbottomattendancegridforfaculty')
	   {	   
	     quickSearchForm=this.getGeneralsummarysearch(); 
	     searchResultGrid = this.getTopandbottomattendancegridforfaculty();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonFormatForFaculty(quickSearchForm);
	   }
	   if(grid=='topandbottomattendancegridforstudent')
	   {	   
	     quickSearchForm=this.getGeneralsummarysearch(); 
	     searchResultGrid = this.getTopandbottomattendancegridforstudent();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonFormatForStudent(quickSearchForm);
	   }
	   if(grid=='topbottomprogramabsenteeismgrid')
	   {	   
	     quickSearchForm=this.getTopbottonprogramabsenteeismsearch(); 
	     searchResultGrid = this.getTopbottomprogramabsenteeismgrid();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonTopBottomProgramAbsenteeism(quickSearchForm);
	   }
	   if(grid=='programBathcReportGrid')
	   {	   
	     quickSearchForm=this.getProgramdetailsreportsearch(); 
	     searchResultGrid = this.getProgramBathcReportGrid();
	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	     jsonFormatFormData=this.createJsonProgramBatchReport(quickSearchForm);
	   }
	   
	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
      	var reportTitle=getCommonTranslation('DASHBOARD_LIST');
	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	   }
	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
   },
 //*****************************************************************************************************

   //***************************************************************************************************
   createSearchCriteriaString: function(searchForm) {
	   var me=this;
	   var formValues = new Array();
	   formValues = searchForm.getValues();        
	   var searchCriteriaString="";
	   for (var key in formValues) {
		   var value = formValues[key];            
		   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
			     var keyValueJsonObject = me.getJsonObject( key , value);
			   searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
		   }
	   }
	   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	   return searchCriteriaString;
   },
   //*********************************End************************************************
   onChangeSectionGroupType:function(value,newValue,oldValue){
	   var $this = this;
	   var pbsSearchForm=$this.getCoursesearchattendance();
	   var sectionGroupForm=$this.getCoursesearchattendanceofsectiongroup();
	   var courseattendancegrid=$this.getCourseattendancegrid();
	   var courseattendancebysectiongroupgrid=$this.getCourseattendancebysectiongroupgrid();
	   if(newValue.whetherPBSorCBSGroup==true){
		   var currentAcademicTerm = false;
		   pbsSearchForm.getForm().reset();
		   pbsSearchForm.setVisible(true);
		   sectionGroupForm.setVisible(false);
		   courseattendancegrid.setVisible(true);
		   courseattendancebysectiongroupgrid.setVisible(false);
		   var academicTerm = pbsSearchForm.down('#academicTermId');
		   academicTerm.reset();
		   var academicTermStore = academicTerm.getStore();
   			academicTermStore.load({
   			callback: function(record, operation, success) {
   				if (success) {
   					if(record.length>0){
   						Ext.each(record, function(value) {
   							if(value.get('whetherCurrentAcademicTerm')){
   								currentAcademicTerm = true
   								pbsSearchForm.down("#academicTermId").setValue(value.get('id'));
   								return;
   							}
   						});
   					}
   					if(!currentAcademicTerm) {
   						var courseCombo=pbsSearchForm.down('#course_Id').setDisabled(true);
						   var studentCombo = pbsSearchForm.down('#studentId').setDisabled(true);
						   var programCombo = pbsSearchForm.down('#programBatch_programId').setDisabled(true);
						   var batchCombo = pbsSearchForm.down('#programBatch_batchId').setDisabled(true);
						   var periodCombo = pbsSearchForm.down('#programBatch_periodId').setDisabled(true);
						   pbsSearchForm.down('#searchBtn').setDisabled(true);
   					} else {
   						var academicTerm=pbsSearchForm.down('#academicTermId');
   						var program =pbsSearchForm.down('#programBatch_programId');
   						if(program.getValue()!=null&&academicTerm.getValue()!=null){
   						pbsSearchForm.down('#searchBtn').setDisabled(false);
   						}else{
   							pbsSearchForm.down('#searchBtn').setDisabled(true);
   						}
   					}
   				}
   			}
   		});
	   }else{
		   sectionGroupForm.getForm().reset();
		   var courseCombo=sectionGroupForm.down('#course_Id').setDisabled(true);
		   var studentCombo = sectionGroupForm.down('#sectionGroupStudentId').setDisabled(true);
		   var programCombo = sectionGroupForm.down('#programBatch_programId').setDisabled(true);
		   var batchCombo = sectionGroupForm.down('#programBatch_batchId').setDisabled(true);
		   var periodCombo = sectionGroupForm.down('#programBatch_periodId').setDisabled(true);
		   pbsSearchForm.setVisible(false);
		   sectionGroupForm.setVisible(true);
		   courseattendancegrid.setVisible(false);
		   var alinfomodel = Academia.model.authentication.ALInfoModel;
		   var wheatherSchool = alinfomodel.get('wheatherSchool');
		   if(wheatherSchool){
			   sectionGroupForm.down('#programBatch_periodId').hide();
		   }
		   courseattendancebysectiongroupgrid.setVisible(true);
	   }
   },
   disableRadioSelectionsPivilegesOfCourse:function(form, permissionsMap){
	   var associatedAcadLocationIds = new Array();
	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
       var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       var programBatchSection=false, courseGroup = false;
       var radioButton = form.down('#sectionGroupTypeId');
       radioButton.setVisible(false);
       Ext.each(permissionList, function(privilege) {
           if (privilege === 'PROGRAM_BATCH_SECTION') {
        	   radioButton.setVisible(false);
               radioButton.items.items[0].setValue(true);
               radioButton.items.items[1].setValue(false);
               programBatchSection = true;

           }
           if (privilege === 'SECTION_GROUP') {
        	   radioButton.setVisible(false);
               radioButton.items.items[0].setValue(false);
               radioButton.items.items[1].setValue(true);
               courseGroup = true;
           }
          
       });
       if(programBatchSection && courseGroup){
    	   radioButton.setVisible(true);
    	   radioButton.items.items[0].setValue(true);
           radioButton.items.items[1].setValue(false);
       }
       if(!programBatchSection && !courseGroup){
    	   radioButton.setVisible(false);
    	   radioButton.items.items[0].setValue(true);
           radioButton.items.items[1].setValue(false);
       }
	   
   },
   openCourseWin:function(grid, rowIndex, record){
	   var $this = this;
	   var formWindow = $this.getFacultyworkloadcoursewin();
	   if (!formWindow) {
		   Ext.widget('facultyworkloadcoursewin');
		   formWindow = $this.getFacultyworkloadcoursewin();
	   }
	   formWindow.show();

	   var form = $this.getFacultyWorkloadcoursewin().getForm();
	   if(!isNullOrEmpty(record.data.academyLocation)){
		   var academyLocation =  record.data.academyLocation;
		   form.findField('academyLocation').setValue(academyLocation);
	   }
	   
	   if(!isNullOrEmpty(record.data.facultyName)){
		   var facultyName =  record.data.facultyName;
		   form.findField('facultyName').setValue(facultyName);
	   }

	   var generalSummaryForm = $this.getGeneralsummarystructure().getForm();
	   var values = generalSummaryForm.getValues();
	   
	   var acadLocationIdsCommaSepeated = $this.getAcademyLocationIds();
	   var store = $this.getFacultyworkloadcoursegrid().getStore();
	   store.getProxy().extraParams = {
		   academyLocationIds:acadLocationIdsCommaSepeated,
		   facultyId : record.data.facultyId,
		   programId: values.programId,
		   batchId : values.batchId,
		   periodId : values.periodId,
		   sectionId :values.sectionId,
		   fromDate :values.fromDate,
		   toDate :values.toDate
	   };
	   $this.resetPageSetting(store);
	   store.load();

   },
   openSessionWin:function(grid, rowIndex, record){
	   var $this = this;
	   var formWindow = $this.getFacultyworkloadsessionwin();
	   if (!formWindow) {
		   Ext.widget('facultyworkloadsessionwin');
		   formWindow = $this.getFacultyworkloadsessionwin();
	   }
	   formWindow.show();

	   var form = $this.getFacultyWorkloadsessionwin().getForm();
	   if(!isNullOrEmpty(record.data.academyLocation)){
		   var academyLocation =  record.data.academyLocation;
		   form.findField('academyLocation').setValue(academyLocation);
	   }
	   
	   if(!isNullOrEmpty(record.data.facultyName)){
		   var facultyName =  record.data.facultyName;
		   form.findField('facultyName').setValue(facultyName);
	   }
	   
	   var generalSummaryForm = $this.getGeneralsummarystructure().getForm();
	   var values = generalSummaryForm.getValues();
	   
	   var acadLocationIdsCommaSepeated = $this.getAcademyLocationIds();
	   var store = $this.getFacultyworkloadsessiongrid().getStore();
	   store.getProxy().extraParams = {
		   academyLocationIds:acadLocationIdsCommaSepeated,
		   facultyId : record.data.facultyId,
		   programId: values.programId,
		   batchId : values.batchId,
		   periodId : values.periodId,
		   sectionId :values.sectionId,
		   fromDate :values.fromDate,
		   toDate :values.toDate
	   };
	   $this.resetPageSetting(store);
	   store.load();
   },
   searchProgramPromotion : function(){
	   var $this = this;
	   var form = $this.getProgramPromotionForm();
	   
	   var programId = form.down('#programId').getValue();
	   var batchId = form.down('#batchId').getValue();
	   var periodId = form.down('#periodId').getValue();
	   var sectionId = form.down('#sectionId').getValue();
	   var status = form.down('#promotionStatusId').getValue();
	   var intakeYearId = form.down('#intakeYearId').getValue();
	   var grid = $this.getProgramPromotionGrid();
	   var academyLocationIds = this.getAcademyLocationIds();
	   var store = grid.getStore();
	   store.getProxy().extraParams={
		   programId:programId,
		   batchId:batchId,
		   periodId:periodId,
		   sectionId:sectionId,
		   status:status,
		   academyLocationIds:academyLocationIds,
		   intakeYearId:intakeYearId
	   }
	   $this.resetPageSetting(store);
	   store.load();
	   grid.config.searchFilterForm = form;
   },
   resetProgramPromotion : function(){
	   var form = this.getProgramPromotionForm();
	   form.getForm().reset();
	   	var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(wheatherSchool) {
			form.down('#periodId').setVisible(false);
		}
	   form.down('#batchId').setDisabled(true);
	   form.down('#periodId').setDisabled(true);
	   form.down('#sectionId').setDisabled(true);
   },
   exportReportWindow : function(){
	   var quicksearchform = this.getCoursesearchattendance();
	   var alIds=[];
	   var academyLocationIds = this.getAcademyLocationIds();
	   if(isNullOrEmpty(academyLocationIds)){
		   alIds.push(this.getCurrentAcademyLocation());
		   academyLocationIds = alIds.join();
	   }
	   var formValues = quicksearchform.getValues();
	   var academicTermId=formValues.academicTerm;
	   var code = 'CourseWiseAttendanceReport';
	   var reportParams =new Object();
	   var courseId=formValues.courseId;
	   var selectedRecords = new Array();
	   var courseIds;
	   if(courseId !=undefined && courseId.length > 0){
		   for(var i in courseId){
			   if(Ext.isObject(courseId[0])){
				   selectedRecords.push(courseId[i].get("id"));
			   }else{
				   selectedRecords.push(courseId[i]);
			   }
		   }
	   }
	   courseIds = selectedRecords.join();
	   reportParams.programId=formValues.programId;
	   reportParams.batchId=formValues.batchId;
	   reportParams.periodId=formValues.periodId;
	   reportParams.sectionId=formValues.courseSectionId;
	   reportParams.courseIds=courseIds;
	   reportParams.periodLabel = getCommonTranslation('PERIOD');
	   reportParams.academyLocationIds=academyLocationIds;
	   reportParams.academicTermId=academicTermId;
	   reportParams.startDate=formValues.startDate;
	   reportParams.endDate=formValues.endDate;
	   reportParams.studentId=formValues.studentId;
	   if(formValues.studentStatusItemId == 'Active'){
	   reportParams.activeStatus = true;
	   } else if (formValues.studentStatusItemId == 'Inactive'){
	   reportParams.activeStatus = false;
	   }else{
	   reportParams.activeStatus = null;
	   }
	   //reportParams.academyLocationId=this.getCurrentAcademyLocation()
	   reportParams.headerName = getAdmissionTranslation('COURSE_ATTENDANCE_REPORT');
	   var reportTitle="";
	   this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.EXPORT_COURSEWISE_ATTENDANCE_REPORT);
   },
	   exportReportWindowOfSectionGroup:function(){
		   var quicksearchform = this.getCoursesearchattendanceofsectiongroup();
		   	var formValues = quicksearchform.getValues();
		   	var alIds=[];
			var academyLocationIds = this.getAcademyLocationIds();
			   if(isNullOrEmpty(academyLocationIds)){
				   		alIds.push(this.getCurrentAcademyLocation());
				   		academyLocationIds = alIds.join();
			   }
		   	var code = 'CourseWiseAttendanceReportOfSectionGroup';
		   	var reportParams =new Object();
		   	var courseId=formValues.courseId;
		 	  var selectedRecords = new Array();
		 	  var courseIds;
		 	  if(courseId !=undefined && courseId.length > 0){
		 		  for(var i in courseId){
		  			 if(Ext.isObject(courseId[0])){
		  				selectedRecords.push(courseId[i].get("id"));
		  			 }else{
		  				selectedRecords.push(courseId[i]);
		  			 }
		  		 }
		 	  }
		 	courseIds = selectedRecords.join();
		 	reportParams.sectionGroupId=formValues.sectionGroupId;
		   	reportParams.programId=formValues.programId;
		    reportParams.batchId=formValues.batchId;
		    reportParams.periodId=formValues.periodId;
		    reportParams.sectionId=formValues.courseSectionId;
		    reportParams.studentId=formValues.sectionGroupStudentId;
		    reportParams.courseIds=courseIds;
		    reportParams.academyLocationIds=academyLocationIds;
			reportParams.academicTermId=formValues.academicTermId;
			reportParams.startDate=formValues.startDate;
			reportParams.endDate=formValues.endDate;
		    reportParams.programLabel = getCommonTranslation('PROGRAM');
		    reportParams.batchLabel = getCommonTranslation('BATCH');
		    reportParams.periodLabel = getCommonTranslation('PERIOD');
		    reportParams.sectionGroupLabel = getCourseTxCommonTranslation('SECTION_GROUP');
		    reportParams.headerName = getAdmissionTranslation('COURSE_ATTENDANCE_REPORT');
		     var reportTitle="";
		    this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.EXPORT_COURSEWISE_ATTENDANCE_REPORT_OF_SECTION_GROUP);  
	   },
	   
	   loadreport:function(){
		   var quicksearchform =  this.getCoursesearchattendance();
		   var reportgrid = this.getCourseattendancegrid();
		   var alIds=[];
		   var academyLocationIds=this.getAcademyLocationIds();
		   if(isNullOrEmpty(academyLocationIds)){
			   alIds.push(this.getCurrentAcademyLocation());
			   academyLocationIds = alIds.join(); 
		   }
		   formValues = quicksearchform.getValues();
		   var courseId=formValues.courseId;
		   var store = reportgrid.getStore();
		   var selectedRecords = new Array();
		   var courseIds;
		   if(courseId !=undefined && courseId.length > 0){
			   for(var i in courseId){
				   if(Ext.isObject(courseId[i])){
					   selectedRecords.push(courseId[i].get("id"));
				   }else{
					   selectedRecords.push(courseId[i]);
				   }
			   }
		   }
		   courseIds = selectedRecords.join();
		   store.getProxy().extraParams = {
			   programId:formValues.programId,
			   batchId:formValues.batchId,
			   periodId:formValues.periodId,
			   sectionId:formValues.sectionId,
			   courseIds:courseIds,
			   startDate:formValues.startDate,
			   endDate:formValues.endDate,
			   academicTermId:formValues.academicTerm,
			   academyLocationIds:academyLocationIds,
			   studentId : formValues.studentId,
			   onlyCurrentRecord:false,
			   studentStatus:formValues.studentStatusItemId
			   
		   };
		   store.load();
		   reportgrid.config.searchFilterForm = quicksearchform;
	   },
	   academyCurrentLocation:function(){
		   var form = this.getCoursesearchattendance();
		   var academyLocationIds = this.getAcademyLocationIds();
		   var store = form.getForm().findField('programId').getStore();
		   store.getProxy().extraParams = {
			   academyLocationIds:academyLocationIds			
		   };
		   store.load();
		   var alinfomodel = Academia.model.authentication.ALInfoModel;
		   var wheatherSchool = alinfomodel.get('wheatherSchool');
		   if(wheatherSchool){
			   form.down('#programBatch_periodId').hide();
		   }
	   },
	   loadreportBySectionGroup: function() {
		    var quicksearchform = this.getCoursesearchattendanceofsectiongroup();
		    var reportgrid = this.getCourseattendancebysectiongroupgrid();
		    var formValues = quicksearchform.getValues();
		    var courseId = formValues.courseId;
		    var studentId = formValues.sectionGroupStudentId;
		    var store = reportgrid.getStore();
		    var selectedRecords = new Array();
		    var courseIds;
		    if (courseId != undefined && courseId.length > 0) {
		        for (var i in courseId) {
		            if (Ext.isObject(courseId[i])) {
		                selectedRecords.push(courseId[i].get("id"));
		            } else {
		                selectedRecords.push(courseId[i]);
		            }
		        }

		    }
		    courseIds = selectedRecords.join();

		    store.getProxy().extraParams = {
		    	sectionGroupId: formValues.sectionGroupId,
		        programId: formValues.programId,
		        batchId: formValues.batchId,
		        periodId: formValues.periodId,
		        //sectionId: formValues.sectionId,
		        courseIds: courseIds,
		        startDate: formValues.startDate,
		        endDate: formValues.endDate,
		        studentId: studentId,
		        studentStatus:formValues.studentStatusItemId
		        
		        //academyLocationId:this.getCurrentAcademyLocation()
		    };
		    store.load();
			reportgrid.config.searchFilterForm = quicksearchform;
		},
	   //******************Disable Export Reports button**********************************
	   disableExportBtnActionPivileges: function(gridReference,permissionsMap) {
		   var associatedAcadLocationIds = new Array();
		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		   buttonsToolBar = gridReference.query('toolbar')[0];
		   var exportReportButton = gridReference.down('#exportReportsId');
		   exportReportButton.setVisible(false);
		   Ext.each(permissionList, function(privilege) {
			   if (privilege === 'EXPORT_REPORTS') {
				   if(!isNullOrEmpty(exportReportButton)){
					   exportReportButton.setVisible(true);
				   }        	
			   }
		   });
	   },
	   
	   facultyWorkloadXlsReportList: function(){

	    	var $this = this;
	    	var form = $this.getGeneralsummarystructure().getForm();
	    	var values = form.getValues();	
	    	var alacademyLocationIds = this.getAcademyLocationIds();	
	    	var code = 'FACULTY_LOAD_REPORT';
	    	var reportParams =new Object();
	    	reportParams.code = code;
	    	reportParams.reportTitle = code;
	    	reportParams.alacademyLocationIds = alacademyLocationIds;
	    	reportParams.facultyId = values.facultyCodeItem;
	    	reportParams.programId = values.programId;
	    	reportParams.batchId = values.batchId;
	    	reportParams.periodId = values.periodId;
	    	reportParams.sectionId = values.sectionId;
	    	reportParams.fromDate = values.fromDate;
	    	reportParams.toDate = values.toDate;
	    	reportParams.headerName = getPersonModuleTranslation('FACULTY_LOAD_REPORT');

	    	var reportTitle="";
	    	$this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.FACULTY_WORKLOAD_GENRATE_XLS_REPORT);

	    },
	    
	    generateCourseRosterReport:function(tempCode) {
        	var $this = this;
        	var form = $this.getCourserosterreportsearchform().getForm(); 
        	var grid = $this.getCourserosterreportgrid();
			var selection = grid.getSelectionModel().getSelection();
        	var formValues = form.getValues();
        	var $this = this;
    	    var window = $this.getGeneratecourserosterreportwin();
    	    var code;
    	    if(tempCode) {
    		   code = tempCode;
    	    } else {
    		   code = window.down('#chooseTemplate').valueModels[0].data.value;
    	    }
        	var batchId=form.findField('batchId').getValue();
        	var programId=form.findField('programId').getValue();
        	var courseId=form.findField('courseId').getValue();
        	var periodId=form.findField('periodId').getValue();
        	var sectionId=form.findField('sectionId').getValue();
//        	var admissionId = form.findField("studentName").getValue();
        	var inTakeYearId = form.findField("intakeYear").getValue();
        	var academicTermId = form.findField("academicTerm").getValue();
        	var facultyId= null;
        	var courseVarientId= form.findField("COURSE_VARIENT_ID").getValue();
        	var studentId= form.findField("STUDENT_ID").getValue();
        	var activeStatus = formValues.STATUS;
        	var academyLocationIds
        	if($this.getCurrentLoggedPortalId()==2){
			   academyLocationIds = $this.getCurrentAcademyLocation();
			   facultyId=this.getCurrentlyLoggedInUser().id;
        	} else {
    		   academyLocationIds = $this.getAcademyLocationIds();
    		   facultyId=form.findField("facultyName").getValue();
    		}
        	var studentIdArray = [];
        	if(selection.length!=0){
			for (var i in selection) {
				studentIdArray.push(selection[i].data.studentId);
			}
        	}
			var studentIds = studentIdArray.join(',');	
        	var reportParams =new Object();
        	reportParams.BATCH_ID=batchId;
        	reportParams.PROGRAM_ID=programId;
        	reportParams.PERIOD_ID=periodId;
        	reportParams.SECTION_ID = sectionId;
        	reportParams.INTAKE_YEAR_ID=inTakeYearId;
        	reportParams.ACADEMIC_TERM_ID=academicTermId;
//        	reportParams.ADMISSION_ID=admissionId;
        	reportParams.COURSE_ID = courseId;
        	reportParams.FACULTY_ID= facultyId;
        	reportParams.COURSE_VARIENT_ID= courseVarientId;
        	reportParams.STUDENT_ID= studentIds;
        	reportParams.ACTIVE_STATUS = activeStatus;
        	reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds+"";
        	if(window != undefined) {
     		   window.close();
        	}
        	var exportUrl = SERVERURL.PATH_GENERATE_COURSE_ROSTER_REPORT;
        	$this.exportJRXMLReport(code,reportParams,'Course Roster Report_'+form.findField('courseId').getRawValue(),'.pdf',exportUrl);
	    },
	    
	    generateSectionRosterReport:function(tempCode) {
        	var $this = this;
        	var form = $this.getSectionrosterreportsearchform().getForm(); 
        	var formValues = form.getValues();
        	var grid = $this.getSectionrosterreportgrid();
			var selection = grid.getSelectionModel().getSelection();
        	var window = $this.getGeneratesectionrosterreportwin();
        	var code;
        	if(tempCode) {
     		   code = tempCode;
     	    } else {
     		   code = window.down('#chooseTemplate').valueModels[0].data.value;
     	    }
        	var studentIdArray = [];
        	if(selection.length!=0){
			for (var i in selection) {
				studentIdArray.push(selection[i].data.studentId);
			}
        	}
			var studentIds = studentIdArray.join(',');
    	    
        	var batchId=form.findField('batchId').getValue();
        	var programId=form.findField('programId').getValue();
        	var programGroupId=form.findField('PROGRAM_GROUP').getValue();
        	var periodId=form.findField('periodId').getValue();
        	var sectionId=form.findField('sectionId').getValue();
        	var inTakeYearId = form.findField("intakeYear").getValue();
        	var facultyId= null;
        	var academyLocationIds;
        	
        	if($this.getCurrentLoggedPortalId()==2){
			   academyLocationIds = $this.getCurrentAcademyLocation();
			   facultyId=this.getCurrentlyLoggedInUser().id;
        	} else {
    		   academyLocationIds = $this.getAcademyLocationIds();
    		   facultyId=form.findField("facultyName").getValue();
    		}
        	var programGroupIds = [];
			Ext.each(programGroupId, function(value) {
    			if(value instanceof Object){
    				programGroupIds.push(value.get('id'));
    			}
			});
			var programIds = [];
			Ext.each(programId, function(value) {
    			if(value instanceof Object){
    				programIds.push(value.get('id'));
    			}
			});
        	var reportParams =new Object();
        	reportParams.BATCH_ID=batchId;
        	reportParams.PROGRAM_IDS=programIds;
        	reportParams.PROGRAM_GROUP_IDS=programGroupIds;
        	reportParams.PERIOD_ID=periodId;
        	reportParams.SECTION_ID=sectionId;
        	reportParams.INTAKE_YEAR_ID=inTakeYearId;
        	reportParams.FACULTY_ID= facultyId;
        	reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds+"";
        	reportParams.STUDENT_ID = studentIds;
        	
        	if(window != undefined) {
      		   window.close();
         	}
        	var exportUrl = SERVERURL.PATH_GENERATE_SECTION_ROSTER_REPORT;
        	$this.exportJRXMLReport(code,reportParams,'Section Roster Report_'+form.findField('sectionId').getRawValue(),'.pdf',exportUrl);
	    },
	    
	    deferForCourseRosterReportGrid : function(grid) {
	    	Ext.defer(function() {
				var portalId = this.getCurrentLoggedPortalId();
					if(portalId == 2) {
						for(var i=grid.columnManager.columns.length-1;i>=0;i--) {
							var column = grid.columnManager.columns[i];
							if(column.dataIndex == 'facultyName'){
//								column.hide();
							}
						}
				   }
			 }, 50, this);
	    },
	    deferForSectionRosterReportGrid : function(grid) {
	    	Ext.defer(function() {
				var portalId = this.getCurrentLoggedPortalId();
					if(portalId == 2) {
						for(var i=grid.columnManager.columns.length-1;i>=0;i--) {
							var column = grid.columnManager.columns[i];
							if(column.dataIndex == 'facultyName'){
								column.hide();
							}
						}
				   }
			 }, 50, this);
	    },
	    /** Disable More Action Privileges button */
	    disableMoreActionPivileges: function(gridReference, permissionsMap) {

	        var associatedAcadLocationIds = new Array();
	        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	        var exportCourseRosterReportButton = gridReference.down('#exportCourseRosterReportsId');
	        exportCourseRosterReportButton.setVisible(false);
	        var sendMessageCourseRosterReportButton = gridReference.down('#sendMessageBtn');
	        exportCourseRosterReportButton.setVisible(false);
	        sendMessageCourseRosterReportButton.setVisible(false);
	        var resetPasswordCourseRosterReportButton = gridReference.down('#resetPasswordBtn');
	        resetPasswordCourseRosterReportButton.setVisible(false);

	        Ext.each(permissionList, function(privilege) {
	            if (privilege === 'GENERATE_COURSE_ROSTER_REPORT') {
	                if (!isNullOrEmpty(exportCourseRosterReportButton)) {
	                	exportCourseRosterReportButton.setVisible(true);
	                }
	            }
	            if (privilege === 'SEND_MESSAGE_COURSE_ROSTER_REPORT') {
	                if (!isNullOrEmpty(sendMessageCourseRosterReportButton)) {
	                	sendMessageCourseRosterReportButton.setVisible(true);
	                }
	            }
	            if (privilege === 'RESETPASSWORD') {
	                if (!isNullOrEmpty(resetPasswordCourseRosterReportButton)) {
	                	resetPasswordCourseRosterReportButton.setVisible(true);
	                }
	            }
	            
	        });
	    },
	    disableMoreActionPivilegesSRR: function(gridReference, permissionsMap) {

	        var associatedAcadLocationIds = new Array();
	        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	        var exportSectionRosterReportButton = gridReference.down('#exportSectionRosterReportsId');
	        exportSectionRosterReportButton.setVisible(false);
	        var sendMessageSectionRosterReportButton = gridReference.down('#sendMessageSectionRRBtn');
	        sendMessageSectionRosterReportButton.setVisible(false);
	        Ext.each(permissionList, function(privilege) {
	            if (privilege === 'GENERATE_SECTION_ROSTER_REPORT') {
	                if (!isNullOrEmpty(exportSectionRosterReportButton)) {
	                	exportSectionRosterReportButton.setVisible(true);
	                }
	            }
	            if (privilege === 'SEND_MESSAGE_SECTION_ROSTER_REPORT') {
	                if (!isNullOrEmpty(sendMessageSectionRosterReportButton)) {
	                	sendMessageSectionRosterReportButton.setVisible(true);
	                }
	            }
	        });
	    },
	    addMoreDetailedOfProgramBatchCourse:function(){
			var $this = this;
			var studentEnrollmentForm=$this.getStudentcourseenrollmentreportsearchform();
			var panelContiner = studentEnrollmentForm.down('#panelIdH');
			var panelItem = new Array();
			panelItem.push({

				 xtype : 'fieldcontainer',
		       	 layout : 'hbox',
		       	 width: '100%',
		       	 scope: $this,
		       	 defaults : {
		       		 labelAlign : 'top',
		       		 width:'226'
		       	 },
		       	 layout : {
		       		 type : 'hbox'
		       	 },
				margin: '0 0 0 0',
				padding: '0 0 0 0',
				 items:[{
			            xtype: 'customcombobox',
			            width: 226,
			            name: 'programItem',
			            store: 'program.ProgramByGroupIdStore',
			            fieldLabel: getCommonTranslation('PROGRAM'),
			            valueField: 'id',
			            displayField: 'valueCode',
			            queryParam: 'qry',
			            minChars: 3,
			            allowBlank: true,
			            typeAhead: false,
			            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			            forceSelection: true,
			            listeners:{
            				select:function(obj,rec,value){
            					var dashboardController=Academia.getApplication().getController('Academia.controller.programCourseDashboard.DashboardController');
            					var programId=rec[0].get('id');
            					var values = obj.up('form').getForm().getValues();
            					var batcheIds = values.BATCH_NAME;
            					//var cleanBatcheIds = Ext.Array.clean(batcheIds);
            					var nextSiblingField = obj.nextSibling();
            					nextSiblingField.setDisabled(false);
            					nextSiblingField.reset();
            					var batchStore = obj.nextSibling().getStore();
            					batchStore.getProxy().extraParams = {
            						id:programId
            					};
            					batchStore.load();
            					var academyLocationIds;
            			        if (portalId == 2) {
            			            academyLocationIds = dashboardController.getCurrentAcademyLocation();
            			        } else {
            			            academyLocationIds = dashboardController.getAcademyLocationIds();
            			        }
            					var studentStore=obj.up('form').down('#studentId').getStore();
            					var programIds = "";
            					var programs = [];
            				       if (!isNullOrEmpty(values.programItem)) {
            				    	   for(var i in values.programItem){
            				    		   if(!isNullOrEmpty(values.programItem[i])){
            				    			   programs.push(values.programItem[i]);
            				    		   }
            				    		 }
            				           if (programs.length === 1) {
            				        	   programIds = programs;
            				            } else {
            				        	   programIds = programs.join(); 
            				           }
            				       }
            					studentStore.getProxy().extraParams = {
            						academyLocationIds: academyLocationIds,
            			        	programGroupId: values.PROGRAM_GROUP,
            			            intakeYearId: values.intakeYear,
            			            academicTermId: values.academicTerm,
            			            programIds:programIds
            					};
            					studentStore.load();
            				},
				        change:function(obj,rec,value){
				        	var nextSiblingField = obj.nextSibling();
				        	nextSiblingField.reset();
        					nextSiblingField.setDisabled(true);
        					
				            }
				 }
			        },
			        {
			            xtype: 'customcombobox',
			            name: 'BATCH_NAME',
			            fieldLabel: getPersonModuleTranslation('BATCH'),
			            disabled: true,
			            editable: false,
			            queryMode: 'local',
			            displayField: 'value',
			            valueField: 'id',
			            width: 226,
			            listeners: {
			                render: function(combo) {
			                    var store = Ext
			                        .create('Academia.store.program.programbatchdetail.BatchStore');
			                    combo.bindStore(store);
			                },
			         select:function(obj,rec,value){
    					var batchId=rec[0].get('id');
    					var values = obj.up('form').getForm().getValues();
    					var periodIds = values.PERIOD_NAME;
    					//var cleanPeriodIds = Ext.Array.clean(periodIds);
    					
    					var nextSiblingField = obj.nextSibling();
    					nextSiblingField.setDisabled(false);
    					nextSiblingField.reset();
    					var periodStore = obj.nextSibling().getStore();
    					periodStore.getProxy().extraParams = {
    						id:batchId
    					};
    					periodStore.load();
    				 },
    				 change:function(obj,rec,value){
				        	var nextSiblingField = obj.nextSibling();
				        	nextSiblingField.reset();
     					   nextSiblingField.setDisabled(true);
     					
				            }
			            }
			        },
			        {
			            xtype: 'customcombobox',
			            disabled: true,
			            editable: false,
			            displayField: 'value',
			            valueField: 'id',
			            queryMode: 'local',
			            width: 226,
			            fieldLabel: getPersonModuleTranslation('PERIOD'),
			            name: 'PERIOD_NAME',
			            listeners: {
			                render: function(combo) {
			                    var store = Ext
			                        .create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
			                    combo.bindStore(store);
			                }
			            }
			        },
			        {
            			xtype: 'button',
            			glyph: ICONGLYPH.DELETEGLYPH,
            			itemId: 'detailedDeleteButton1',
            			width: 'auto',
            			cls: 'CustomBodyBtnReject',
            			tooltip: getCommonTranslation('DELETETOOLTIP'),
            			style:{
							 marginTop:'30px'
						 },
            			listeners:{
            				click:function(obj){
            					var container = obj.up('fieldcontainer');
            					//panelContiner.remove(container);
            					//$this.getMastertimetableDetailedwindow().getForm().isValid();
            					//$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
            				}
            			}
            		},
			        {
						 xtype: 'button',
						 itemId: 'addDetailedBtn1',
						 width: 'auto',
						 cls: 'CustomBodyBtnSettings',
						 width: 'auto',
						 text: getCommonTranslation('ADDBUTTONTEXT'),
						 tooltip: getCommonTranslation('ADD'),
						 style:{
							 marginTop:'30px'
						 }
					}]
			
			});
			panelContiner.add(panelItem);
        	this.hideShowDetails(panelContiner);
        	panelContiner.doLayout();
		},
		deleteMoreDetailedOfProgramBatchCourse: function(deleteButton) {
       	 var this$ = this;
       	var form=this$.getStudentcourseenrollmentreportsearchform();
		var programBatchPeriodPanel = form.down('#panelIdH');
       	 var container = deleteButton.up('fieldcontainer');

       	 if (container != null && programBatchPeriodPanel != null) {
       		 if (programBatchPeriodPanel.items.length > 1) {
       			programBatchPeriodPanel.remove(container);
       			 this$.hideShowDetails(programBatchPeriodPanel);
       		 }
       	 }
        },
		hideShowDetails: function(detailedPanel) {
        	 var this$ = this;
        	 var form = this.getStudentcourseenrollmentreportsearchform();
        	 detailedPanel.items.each(function(item, index, items) {
        		 var addButton = item.getComponent(item.items.length - 1);
        		 if (index == (items - 1)) {
        			 if (addButton != null) {
        				 addButton.show();
        			 }
        		 } else {
        			 if (addButton != null) {
        				 addButton.hide();
        			 }
        		 }
        	 });
         },
         searchDetailedOfStudentCourseEnrollment:function(){
        	 var this$ = this;
        	 var form = this.getStudentcourseenrollmentreportsearchform();
         },
         generateStudentCourseEnrollmentReport: function() {
             var $this = this;
             var code = "StudentCourseEnrollmentReports";
             var studentcourseenrollmentreportsearchform = $this.getStudentcourseenrollmentreportsearchform();
             var formValues = studentcourseenrollmentreportsearchform.getValues();
             var programIds = "";
             if (!isNullOrEmpty(formValues.programItem)) {
                 if (formValues.programItem.constructor === Array) {
                     programIds = formValues.programItem.join();
                 } else {
                     programIds = formValues.programItem;
                 }
             }
             var batchIds = "";
             if (!isNullOrEmpty(formValues.BATCH_NAME)) {
                 if (formValues.BATCH_NAME.constructor === Array) {
                     batchIds = formValues.BATCH_NAME.join();
                 } else {
                     batchIds = formValues.BATCH_NAME;
                 }
             }
             var periodIds = "";
             if (!isNullOrEmpty(formValues.PERIOD_NAME)) {
                 if (formValues.PERIOD_NAME.constructor === Array) {
                     periodIds = formValues.PERIOD_NAME.join();
                 } else {
                     periodIds = formValues.PERIOD_NAME;
                 }
             }
             var intakeYearId = formValues.intakeYear;
             var academicTermId = formValues.academicTerm;
             var programGroupId = formValues.PROGRAM_GROUP;
             var admissionId = formValues.STUDENT_ID;
             var activeStatus = formValues.STATUS;
             
             if(activeStatus=='Active'){
            	 activeStatus=true;
             }
             if(activeStatus=='Inactive'){
            	 activeStatus=false;
             }
             var academyLocationIds
             if ($this.getCurrentLoggedPortalId() == 2) {
                 academyLocationIds = $this.getCurrentAcademyLocation();
             } else {
                 academyLocationIds = $this.getAcademyLocationIds();
             }
             var reportParams = new Object();
             reportParams.PROGRAM_GROUP_ID = programGroupId;
             reportParams.PROGRAM_IDS = programIds+ "";
             reportParams.BATCH_IDS = batchIds+ "";
             reportParams.PERIOD_IDS = periodIds+ "";
             reportParams.INTAKE_YEAR_ID = intakeYearId;
             reportParams.ACADEMIC_TERM_ID = academicTermId;
             reportParams.ADMISSION_ID = admissionId;
             reportParams.ACTIVE_STATUS = activeStatus;
             reportParams.ACADMEMY_LOCATION_IDS = academyLocationIds + "";
             reportParams.courseLabel = getCommonTranslation('COURSE');
             var exportUrl = SERVERURL.PATH_GENERATE_STUDENT_COURSE_ENROLLMENT_REPORT;
             reportParams.headerName = getProgramandcourseTranslation('STUDENT_COURSE_ENROLLMENT_REPORT');
             $this.exportJRXMLReport(code,reportParams,'Student Course Enrollment Report','.vnd.ms-excel',exportUrl);
         },
         
         doAccessDashboardReportTreePnl: function(structure) {
        	 var me = this;
             var treePanel = structure;
             var treePnlRootNode = treePanel.getRootNode();
             
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getPROGRAM_VACANT_SEAT_REPORT_ON_TREE_PERMISSIONS(), "VACANT_SEATS_REPORT"); 
        	// this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getPROGRAM_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS(), "ABSENTEEISM_REPORT"); 
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getPANDCDASHBOARD_PROGRAM_BATCH_REPORT_PRIVILEGES(), "PROGRAM_BATCH_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getPROGRAM_PROMOTION_REPORT_PRIVILEGES(), "PROMOTION_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getCOURSE_POPULARITY_REPORT_ON_TREE_PERMISSIONS(), "COURSE_POPULARITY_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getCOURSE_EXECUTION_REPORT_ON_TREE_PERMISSIONS(), "COURSE_EXECUTION_TRACKER_REPORT");
        	// this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getCOURSE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS(), "COURSE_ABSENTEEISM_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getFACULTY_WORKLOAD_REPORT_PERMISSIONS(), "FACULTY_WORKED_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getCOURSE_ROSTER_REPORT_ON_TREE_PERMISSIONS(), "COURSE_ROSTER_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getSTUDENT_COURSE_ENROLLMENT_REPORT_PERMISSIONS(), "STUDENT_COURSE_ENROLLMENT_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getSTUDENT_COURSE_SECTION_REPORT_PERMISSIONS(), "STUDENT_COURSE_SECTION_REPORT");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getCOURSE_ATTENDANCE_REPORT_PERMISSIONS(), "COURSE_ATTENDANCE_REPORT");
        	// this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getCOURSE_ATTENDANCE_ABSENTEEISM_REPORT_ON_TREE_PERMISSIONS(), "ABSENTEEISM_REPORTS");
        	 this.checkPermissionAndRemoveFromTreePnl(treePnlRootNode,this.getSECTION_ROSTER_REPORT_PERMISSIONS(), "SECTION_ROSTER_REPORT");
        	 
        	 
        	 setTimeout(function(){
            	 me.removeEmptyNode(treePanel);
        	 },500);
         },   
         
         removeEmptyNode: function(treePanel){
        	 var me = this;
        	 var rootNode = treePanel.getRootNode();
        	 
        	 rootNode.eachChild(function(childNode) {
        		 if (childNode && !childNode.hasChildNodes()) {
        			 rootNode.removeChild(childNode);
        		 }
        	 });
         },
         
         doAccessVacantSeatReportView: function(button) {
        	 var privilegesMap=this.getPROGRAM_VACANT_SEAT_REPORT_ON_TREE_PERMISSIONS()
             var associatedAcadLocationIds = new Array();
             associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
             var vacantSeatsReportPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
             var isVacantSeatExportPermission = false;
             Ext.each(vacantSeatsReportPermissionList, function(privilege) {
                 if (privilege == 'EXPORT_TO_PNG') {
                	 isVacantSeatExportPermission = true;
                 }
             });
             if(isVacantSeatExportPermission == false){
            	 var vacantSeatExtraBtn = button;
                 vacantSeatExtraBtn.setVisible(false);
             }
         },
         
         checkPermissionAndRemoveFromTreePnl: function(treePnlRootNode, permissionMap, permissionKey){
        	 var associatedAcadLocationIds = new Array();
             associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	
        	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
        	 var constView = 'VIEW';
        	 if(!isNullOrEmpty(permissionList)){
        		 if(!Ext.Array.contains(permissionList, constView)) {							
    				 var vacantNode = treePnlRootNode.findChild("permissionKey",permissionKey,true);
                	 if(!isNullOrEmpty(vacantNode)){
                		 vacantNode.remove(); 
                	 }
    			 } 
        	 }
         },
         openCourseRosterSendMessageWindow : function() {
  	    	var grid = this.getCourserosterreportgrid();
  	    	if(grid.getSelectionModel().getCount()>0) {
  	    			var recipientIds = [];
  	    			Ext.each(grid.getSelectionModel().getSelection(), function(currentSelectedRecord){
  	    				recipientIds.push(currentSelectedRecord.get('admissionId'));
  	    			});
  	    		
  	    			var $this=this;
  	    			var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
  	    	       	   var structure = Ext.widget('studentsendmessagewindowcourseroster');
  	    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
  	    	       	   /**
  	    	       	    * This is to remove tab from content panel and open same tab again
  	    	       	    */
  	    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
  	    	       	   var getTab=getcontroller.getTab(tabName);
  	    	       	   if(getTab!=null){
  	    	       		   contentPanel.remove(getTab, true);
  	    	       	   }
  	    	       	var formWindowTab = $this.getStudentsendmessagewindowcourseroster();
  	    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
  	    	       	formWindowTab.down("#selectTemplate").setVisible(false);
  	    	       	formWindowTab.down("#messageName").allowBlank=true;   
  	    	       	formWindowTab.down("#messageName").setVisible(false);
  	    	       //	formWindowTab.down("#recipientFieldARItemId").setValue(recipientIds);
  	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
  	    			templateStore.getProxy().extraParams={
  	    				msgRecipientTypeId:2
  	    			};
  	    			templateStore.load();
  	    			
  	    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  	    			   Ext.Ajax.request({
  	    				   method : "GET",
  	    				   type : 'rest',
  	    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
  	    				   headers : {
  	    					   'Content-Type' : 'application/json'
  	    				   },
  	    				   success : function(form,action) {
  	    					   var data = Ext.JSON.decode(form.responseText);
  	    					   formWindowTab.down("#id").setValue(data.id);
  	    					   formWindowTab.down("#code").setValue(data.code);
  	    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
  	    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
  	    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
  	    					   Ext.getBody().unmask();
  	    					   
  	    					   //grid.getStore().reload();
  	    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
  	    				   }

  	    			   });
  	    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
  	    			/*if (!formWindow) {
  	    				Ext.widget('studentsendmessages');
  	    				formWindow = $this.getstudentsendmessages();
  	    			}
  	    			formWindow.show(;*/
  	    		
  	    	} else {
  	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
  	    	}
         },
         
         openSectionRosterSendMessageWindow : function() {
   	    	var grid = this.getSectionrosterreportgrid();
   	    	if(grid.getSelectionModel().getCount()>0) {
   	    			var recipientIds = [];
   	    			Ext.each(grid.getSelectionModel().getSelection(), function(currentSelectedRecord){
   	    				recipientIds.push(currentSelectedRecord.get('admissionId'));
   	    			});
   	    		
   	    			var $this=this;
   	    			var contentPanel = this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
   	    	       	   var structure = Ext.widget('studentsendmessagewindowsectionroster');
   	    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
   	    	       	   /**
   	    	       	    * This is to remove tab from content panel and open same tab again
   	    	       	    */
   	    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
   	    	       	   var getTab=getcontroller.getTab(tabName);
   	    	       	   if(getTab!=null){
   	    	       		   contentPanel.remove(getTab, true);
   	    	       	   }
   	    	       	var formWindowTab = $this.getStudentsendmessagewindowsectionroster();
   	    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
   	    	       	formWindowTab.down("#selectTemplate").setVisible(false);
   	    	       	formWindowTab.down("#messageName").allowBlank=true;   
   	    	       	formWindowTab.down("#messageName").setVisible(false);
   	    	       //	formWindowTab.down("#recipientFieldARItemId").setValue(recipientIds);
   	    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
   	    			templateStore.getProxy().extraParams={
   	    				msgRecipientTypeId:2
   	    			};
   	    			templateStore.load();
   	    			
   	    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   	    			   Ext.Ajax.request({
   	    				   method : "GET",
   	    				   type : 'rest',
   	    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
   	    				   headers : {
   	    					   'Content-Type' : 'application/json'
   	    				   },
   	    				   success : function(form,action) {
   	    					   var data = Ext.JSON.decode(form.responseText);
   	    					   formWindowTab.down("#id").setValue(data.id);
   	    					   formWindowTab.down("#code").setValue(data.code);
   	    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
   	    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
   	    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
   	    					   Ext.getBody().unmask();
   	    					   
   	    					   //grid.getStore().reload();
   	    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
   	    				   }

   	    			   });
   	    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
   	    			/*if (!formWindow) {
   	    				Ext.widget('studentsendmessages');
   	    				formWindow = $this.getstudentsendmessages();
   	    			}
   	    			formWindow.show(;*/
   	    		
   	    	} else {
   	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
   	    	}
          },
         loadCourseRosterStudentScheduleField : function(radio,newValue, oldValue){
           	var adhocMessageForm = radio.up('form');
           	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
           	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
           	var radioValue = radio.getValue().sendingPriority;
           	
           	if(radioValue=='IMMEDIATE'){
           		scheduleDateField.setVisible(false);
           		scheduleDateField.setDisabled(true);
           		scheduleTimeField.setVisible(false);
           		scheduleTimeField.setDisabled(true);    		
           	}
           	else if(radioValue=='SCHEDULE'){
           		scheduleDateField.setVisible(true);
           		scheduleDateField.setDisabled(false);
           		scheduleTimeField.setVisible(true);
           		scheduleTimeField.setDisabled(false);
           	}
           },
           /*Start messaging functions*/
         	
     	  selectCourseRosterMessageType : function(val,nV,oV){

          	 var $this =  this;
          	 var formWin = $this.getStudentsendmessagewindowcourseroster();

          	 //var value = nV.1;
          	 if(nV.messageType==2){
          		 formWin.down("#messageId").hide();
          		 formWin.down("#selectTemplate").allowBlank=true;
          		 formWin.down("#selectTemplate").setVisible(false);     		 
          		 formWin.down("#messageName").allowBlank=true;   
          		 formWin.down("#messageName").setVisible(false);
          		 formWin.down("#msgTempletId").setVisible(true);
          		 formWin.down("#msgTempletId").allowBlank=false;
          		 formWin.down("#msgTempletId").reset();
          		 formWin.down("#subject").setVisible(true);
          		 formWin.down("#subject").allowBlank=false;
          		 formWin.down("#subject").reset();
          		 formWin.down("#discriptionId").setVisible(true);
          		 formWin.down("#discriptionId").reset();
          		 formWin.down('#smsDiscription').reset();
          		 formWin.down('#smsDiscription').hide();
          		 formWin.down('#smsDiscriptionNotice').hide();
          		 formWin.down('#pushNotificationDiscription').hide();
	      		 formWin.down('#pushNotificationDiscriptionNotice').hide();
          	 }else{
          		 formWin.down("#msgTempletId").allowBlank=true;
          		 formWin.down("#msgTempletId").setVisible(false);     		
          		 formWin.down("#messageId").setVisible(true);
          		 formWin.down("#selectTemplate").setVisible(true);     		
          		 formWin.down("#messageName").setVisible(true);
          		 formWin.down("#messageName").reset();
          		 formWin.down("#subject").allowBlank=true;
          		 formWin.down("#subject").setVisible(false);
          		 formWin.down("#discriptionId").setVisible(false);
          		 formWin.down("#messageName").allowBlank=false;  
          		 formWin.down("#selectTemplate").allowBlank=false;
          		 formWin.down("#selectTemplate").reset();
          		 formWin.down("#studentcourserosterDocumentMessageAttachmentGrid").setVisible(false);
          		 formWin.down("#staticUploadFileField").setVisible(false);
          		 formWin.down('#smsDiscription').reset();
          		 formWin.down('#smsDiscription').hide();
          		 formWin.down('#smsDiscriptionNotice').hide();
          		 var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
          		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
          		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
          		 formWin.down('#pushNotificationDiscription').hide();
	      		 formWin.down('#pushNotificationDiscriptionNotice').hide();
          	 }
          	formWin.getForm().checkValidity();
           },
           selectCourseRosterStudentMessageTemp: function(obj,rec){
   	       	var $this =  this;
   	       	 var formWin = $this.getStudentsendmessagewindowcourseroster();
   	       	 var subject = formWin.down('#subject');
	        var smsDiscription = formWin.down('#smsDiscription');
	       	var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
	       	var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
	       	var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
   	       	 if(rec[0].data.value == "SMS")
   	       	 {
   	       		 formWin.down("#subject").allowBlank=true;
   	       		 formWin.down("#subject").hide();
   	       		 formWin.down("#staticUploadFileField").hide();
   	       		 formWin.down("#studentcourserosterDocumentMessageAttachmentGrid").hide();
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#discriptionId').hide();	       		 
   	       		 formWin.down('#subject').reset();
   	       		 formWin.down('#smsDiscription').show();
   	       		 formWin.down('#smsDiscriptionNotice').show();
   	       		 pushNotificationDiscription.hide();
   	       		 pushNotificationDiscriptionNotice.hide();
   	       		 pushNotificationDiscription.reset();
   	       		 formWin.getForm().checkValidity();
   	       	 }
   	       	 //V2D-72177
   	       	 /*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	             subject.show();
	             formWin.down("#staticUploadFileField").hide();
	             this.setAllowBlank (subject,false);
	             formWin.down("#studentcourserosterDocumentMessageAttachmentGrid").hide();
	             formWin.down('#discriptionId').reset();
	             formWin.down('#discriptionId').hide();
	             subject.reset();
	             smsDiscription.reset();
	             smsDiscription.hide();
	             smsDiscriptionNotice.hide();
	             pushNotificationDiscription.reset();
	             pushNotificationDiscription.show();
	             pushNotificationDiscriptionNotice.show();
	             pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
	             formWin.getForm().checkValidity();
	             //formWin.down('#smsDiscription')
	             }*/
   	       	 else
   	       	 {
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#smsDiscription').reset();
   	       		 formWin.down('#smsDiscription').hide();
   	       		 formWin.down('#smsDiscriptionNotice').hide();
   	       		 formWin.down("#staticUploadFileField").show();
   	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
   	       		 formWin.down("#studentcourserosterDocumentMessageAttachmentGrid").show()
   	       		 formWin.down("#subject").show();
   	       		 formWin.down("#subject").allowBlank=false;
   	       		 formWin.down('#discriptionId').show();    		
   	       		 pushNotificationDiscription.hide();
   	       		 pushNotificationDiscriptionNotice.hide();
   	       		 pushNotificationDiscription.reset();
   	       		 formWin.getForm().checkValidity();
   	       	 }
   	       },
   	       
   	    loadSectionRosterStudentScheduleField : function(radio,newValue, oldValue){
           	var adhocMessageForm = radio.up('form');
           	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
           	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
           	var radioValue = radio.getValue().sendingPriority;
           	
           	if(radioValue=='IMMEDIATE'){
           		scheduleDateField.setVisible(false);
           		scheduleDateField.setDisabled(true);
           		scheduleTimeField.setVisible(false);
           		scheduleTimeField.setDisabled(true);    		
           	}
           	else if(radioValue=='SCHEDULE'){
           		scheduleDateField.setVisible(true);
           		scheduleDateField.setDisabled(false);
           		scheduleTimeField.setVisible(true);
           		scheduleTimeField.setDisabled(false);
           	}
           },   
   	    selectSectionRosterMessageType : function(val,nV,oV){

         	 var $this =  this;
         	 var formWin = $this.getStudentsendmessagewindowsectionroster();

         	 //var value = nV.1;
         	 if(nV.messageType==2){
         		 formWin.down("#messageId").hide();
         		 formWin.down("#selectTemplate").allowBlank=true;
         		 formWin.down("#selectTemplate").setVisible(false);     		 
         		 formWin.down("#messageName").allowBlank=true;   
         		 formWin.down("#messageName").setVisible(false);
         		 formWin.down("#msgTempletId").setVisible(true);
         		 formWin.down("#msgTempletId").allowBlank=false;
         		 formWin.down("#msgTempletId").reset();
         		 formWin.down("#subject").setVisible(true);
         		 formWin.down("#subject").allowBlank=false;
         		 formWin.down("#subject").reset();
         		 formWin.down("#discriptionId").setVisible(true);
         		 formWin.down("#discriptionId").reset();
         		 formWin.down('#smsDiscription').reset();
         		 formWin.down('#smsDiscription').hide();
         		 formWin.down('#smsDiscriptionNotice').hide();
         		 formWin.down('#pushNotificationDiscription').hide();
	      		 formWin.down('#pushNotificationDiscriptionNotice').hide();
         	 }else{
         		 formWin.down("#msgTempletId").allowBlank=true;
         		 formWin.down("#msgTempletId").setVisible(false);     		
         		 formWin.down("#messageId").setVisible(true);
         		 formWin.down("#selectTemplate").setVisible(true);     		
         		 formWin.down("#messageName").setVisible(true);
         		 formWin.down("#messageName").reset();
         		 formWin.down("#subject").allowBlank=true;
         		 formWin.down("#subject").setVisible(false);
         		 formWin.down("#discriptionId").setVisible(false);
         		 formWin.down("#messageName").allowBlank=false;  
         		 formWin.down("#selectTemplate").allowBlank=false;
         		 formWin.down("#selectTemplate").reset();
         		 formWin.down("#studentsectionrosterDocumentMessageAttachmentGrid").setVisible(false);
         		 formWin.down("#staticUploadFileField").setVisible(false);
         		 formWin.down('#smsDiscription').reset();
         		 formWin.down('#smsDiscription').hide();
         		 formWin.down('#smsDiscriptionNotice').hide();
         		 var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
         		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
         		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
         		 formWin.down('#pushNotificationDiscription').hide();
	      		 formWin.down('#pushNotificationDiscriptionNotice').hide();
         	 }
         	formWin.getForm().checkValidity();
          },
   	    selectSectionRosterStudentMessageTemp: function(obj,rec){
   	       	var $this =  this;
   	       	 var formWin = $this.getStudentsendmessagewindowsectionroster();
   	        var subject = formWin.down('#subject');
	        var smsDiscription = formWin.down('#smsDiscription');
	       	var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
	       	var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
	       	var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
   	       	 if(rec[0].data.value == "SMS")
   	       	 {
   	       		 formWin.down("#subject").allowBlank=true;
   	       		 formWin.down("#subject").hide();
   	       		 formWin.down("#staticUploadFileField").hide();
   	       		 formWin.down("#studentsectionrosterDocumentMessageAttachmentGrid").hide();
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#discriptionId').hide();	       		 
   	       		 formWin.down('#subject').reset();
   	       		 formWin.down('#smsDiscription').show();
   	       		 formWin.down('#smsDiscriptionNotice').show();
   	       		 pushNotificationDiscription.hide();
   	       		 pushNotificationDiscriptionNotice.hide();
   	       		 pushNotificationDiscription.reset();
   	       		 formWin.getForm().checkValidity();
   	       	 }
   	       	 //V2D-72177
   	       	/* else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	             subject.show();
	             formWin.down("#staticUploadFileField").hide();
	             this.setAllowBlank (subject,false);
	             formWin.down("#studentsectionrosterDocumentMessageAttachmentGrid").hide();
	             formWin.down('#discriptionId').reset();
	             formWin.down('#discriptionId').hide();
	             subject.reset();
	             smsDiscription.reset();
	             smsDiscription.hide();
	             smsDiscriptionNotice.hide();
	             pushNotificationDiscription.reset();
	             pushNotificationDiscription.show();
	             pushNotificationDiscriptionNotice.show();
	             pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
	             formWin.getForm().checkValidity();
	             //formWin.down('#smsDiscription')
	         }*/
   	       	 else{
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#smsDiscription').reset();
   	       		 formWin.down('#smsDiscription').hide();
   	       		 formWin.down('#smsDiscriptionNotice').hide();
   	       		 formWin.down("#staticUploadFileField").show();
   	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
   	       		 formWin.down("#studentsectionrosterDocumentMessageAttachmentGrid").show()
   	       		 formWin.down("#subject").show();
   	       		 formWin.down("#subject").allowBlank=false;
   	       		 formWin.down('#discriptionId').show(); 
   	       		 pushNotificationDiscription.hide();
   	       		 pushNotificationDiscriptionNotice.hide();
   	       		 pushNotificationDiscription.reset();
   	       		 formWin.getForm().checkValidity();
   	       	 }
   	       },
   	 
   	  /**
	        * upload static document file for Student
	        */
	       uploadCourseRosterStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
	    	   var this$ = this;
	    	   var setupForm = fileField.up('studentsendmessagewindowcourseroster');
	    	   var grid = setupForm.down('#studentcourserosterstaticdocumentattachmentgridmessage');
	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	    	   fileField.setRawValue(fileUploadPath);
	    	   var file = fileField.fileInputEl.dom.files[0];
	    	   
	    	   if((file.size / 1048576) <= Academia.config.Runtime.getSendMsgMaxFileSize() ){
	    		   if(!isNullOrEmpty(fileUploadPath)){
	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	    			   if (extension == "gif" || extension == "png" || extension == "bmp"
	    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	    					   || extension == "doc" || extension == "docx" || extension == "txt"
	    						   || extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip" || extension == "xlsx") {
	    				   var entityId = 'student';
	    				   var module = 'messaging';
	    				   var entityType = 'template';
	    				   var documentType = 'DOCUMENT';
	    				   var isTransient = true;
	    				   var this$ = this;
	    				   this$.saveCourseRosterStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
	    					   if(success){
	    						   var path = Ext.JSON.decode(action.response.responseText).path;
	    						   var user = this$.getCurrentlyLoggedInUser();
	    						   var store = grid.getStore();
	    						   var documentStatus = "SUBMITTED";
	    						   var documentType = null;
	    						   if(!isNullOrEmpty(path)){
	    							   store.add({
	    								   id: '',
	    								   name: fileUploadPath,
	    								   path: path ,
	    								   createdBy : {
	    									   id :user.id,
	    									   value : user.value,
	    									   code : user.code
	    								   },
	    								   status : documentStatus,
	    								   documentType : documentType,
	    								   templateConfigDocId: '',
	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

	    							   });
	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
	    						   }

	    						   fileField.reset();
	    					   }

	    				   }, isTransient);
	    			   }else{
	    				   fileField.reset();
	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	    			   }
	    		   }
	    	   }else{
	    		   fileField.reset();
	    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_FILE_LIMIT_ERROR_MSG')+" "+Academia.config.Runtime.getSendMsgMaxFileSize()+" MB.");
	    	   }
	       },
	       saveCourseRosterStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
		       	var submitUrl = '';
		       	var templateTab = this.getContentpanel();
		       	var formWin =  this.getStudentsendmessagewindowcourseroster();
		       	var form = formWin.down('#msgDetailsForm');
		       	var id = form.down('#document_hidden_field');
		           if (isNullOrEmpty(id.getSubmitValue())) {
		               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
		           }
		           var data = new Object();
		           if(!isNullOrEmpty(entityId)){
		           	data.entityId = entityId;
		           }else{
		           	data.entityId = null;
		           }
		           if(!isNullOrEmpty(module)){
		           	data.module = module;
		           }else{
		           	data.module = null;
		           }
		           if(!isNullOrEmpty(entityType)){
		           	data.entityType = entityType;
		           }else{
		           	data.entityType = null;
		           }
		           form.getForm().setValues(data);
		           form.getForm().submit({
		           	method : 'POST',
		           	url : submitUrl,
		           	success : function(form, action){
		           		callBackFunction(true, action, isTransient);
		           		
		           	}
		           });
		       },
		       loadGridWithFileNameMessage:function(grid,value,store){
		    	   grid.bindStore(store);
		       },
		       /**
		    	 * This method is used to getAdmission Ids for Student
		    	 */
		       getStudentReceipientIdsForCourseRosterReport : function(grid){
		    		
		    		if (grid.getSelectionModel().getCount() > 0) {
		    			var records = grid.getSelectionModel().getSelection();
		    			var ids=[];
		    			if(grid.itemId == 'courserosterreportGridId'){
		    				for(var i in records) {
		    					var isNotDuplicate = true;
		    					Ext.each(ids, function(id){
		    						if(records[i].data.admissionId == id) {
		    							isNotDuplicate = false;
		    						}
		    					});
		    					if (isNotDuplicate) {
		    						ids.push(records[i].data.admissionId);
		    					}
		    				}
		    			}			
		    		}
		    		return ids;
		    	},
		    	disableSendMessageRadioButtonSelectionsPivileges: function(searchForm, permissionsMap) {
	        		var academyLocationId = this.getCurrentAcademyLocation();
	        		var associatedAcadLocationIds = new Array();
	        		associatedAcadLocationIds.push(academyLocationId);
	        		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        		var messageTypeRadio=searchForm.getForm().findField('messageTypeGroup');
	        		var adhocMessage, messageTemplate;
	        		messageTypeRadio.setVisible(false);
	        		if((Ext.Array.contains(permissionList, 'ADHOC_MESSAGE'))){
	        			messageTypeRadio.items.items[0].setValue(true);
	        			messageTypeRadio.items.items[1].setValue(false);
	        			adhocMessage=true;
	        		}
	        		if((Ext.Array.contains(permissionList, 'MESSAGE_TEMPLATE'))){
	        			messageTypeRadio.items.items[0].setValue(false);
	        			messageTypeRadio.items.items[1].setValue(true);
	        			messageTemplate=true;
	        		}
	        		if(adhocMessage && messageTemplate){
	        			messageTypeRadio.setVisible(true);
	        			messageTypeRadio.items.items[0].setValue(true);
	        			messageTypeRadio.items.items[1].setValue(false);
	        		}

	        	},
	        	   /**
	 	        * Remove entry from grid
	 	        */
	 	       deleteStudentCourseRosterStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	 	    	   var grid =this.getStudentcourserosterstaticdocumentattachmentgrid();
	 	    	   var panel = this.getContentpanel().getActiveTab();
	 	    	   var tabTitle = panel.title;
	 	    	   var store = grid.getStore();
	 	    	   var templateConfigDocId = record.get('templateConfigDocId');
	 	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	 	    	   if(!(tabTitle == viewTitle)){
	 	    		   if(!isNullOrEmpty(templateConfigDocId)){
	 	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	 	    				   if (btn == 'yes') {
	 	    					   Ext.Ajax.request({
	 	    						   type: 'rest',
	 	    						   url: SERVERURL.STATIC_DOC_DELETE,
	 	    						   method: 'DELETE',
	 	    						   params: {
	 	    							   templateConfigDocId : templateConfigDocId
	 	    						   },
	 	    						   headers: {
	 	    							   'Content-Type': 'application/json'
	 	    						   },
	 	    						   success: function(form, action) {
	 	    							   store.remove(record);
	 	    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	 	    						   }
	 	    					   });
	 	    				   }
	 	    			   });

	 	    		   }else{
	 	    			   store.remove(record);
	 	    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	 	    		   }
	 	    	   }else{
	 	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	 	    	   }

	 	       },
	 	       
	 	      uploadSectionRosterStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
		    	   var this$ = this;
		    	   var setupForm = fileField.up('studentsendmessagewindowsectionroster');
		    	   var grid = setupForm.down('#studentsectionrosterstaticdocumentattachmentgridmessage');
		    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
		    	   var file = fileField.fileInputEl.dom.files[0];
		    	   
		    	   if((file.size / 1048576) <= Academia.config.Runtime.getSendMsgMaxFileSize()){
		    		   if(!isNullOrEmpty(fileUploadPath)){
		    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
		    			   if (extension == "gif" || extension == "png" || extension == "bmp"
		    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
		    					   || extension == "doc" || extension == "docx" || extension == "txt"
		    						   || extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip" || extension == "xlsx") {
		    				   var entityId = 'student';
		    				   var module = 'messaging';
		    				   var entityType = 'template';
		    				   var documentType = 'DOCUMENT';
		    				   var isTransient = true;
		    				   var this$ = this;
		    				   this$.saveSectionRosterStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
		    					   if(success){
		    						   var path = Ext.JSON.decode(action.response.responseText).path;
		    						   var user = this$.getCurrentlyLoggedInUser();
		    						   var store = grid.getStore();
		    						   var documentStatus = "SUBMITTED";
		    						   var documentType = null;
		    						   if(!isNullOrEmpty(path)){
		    							   store.add({
		    								   id: '',
		    								   name: fileUploadPath,
		    								   path: path ,
		    								   createdBy : {
		    									   id :user.id,
		    									   value : user.value,
		    									   code : user.code
		    								   },
		    								   status : documentStatus,
		    								   documentType : documentType,
		    								   templateConfigDocId: '',
		    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

		    							   });
		    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
		    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
		    						   }

		    						   fileField.reset();
		    					   }

		    				   }, isTransient);
		    			   }else{
		    				   fileField.reset();
		    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
		    			   }
		    		   }
		    	   }else{
		    		   fileField.reset();
		    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAX_FILE_LIMIT_ERROR_MSG')+" "+Academia.config.Runtime.getSendMsgMaxFileSize()+" MB.");
		    	   }
		       },
		       saveSectionRosterStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
			       	var submitUrl = '';
			       	var templateTab = this.getContentpanel();
			       	var formWin =  this.getStudentsendmessagewindowsectionroster();
			       	var form = formWin.down('#msgDetailsForm');
			       	var id = form.down('#document_hidden_field');
			           if (isNullOrEmpty(id.getSubmitValue())) {
			               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
			           }
			           var data = new Object();
			           if(!isNullOrEmpty(entityId)){
			           	data.entityId = entityId;
			           }else{
			           	data.entityId = null;
			           }
			           if(!isNullOrEmpty(module)){
			           	data.module = module;
			           }else{
			           	data.module = null;
			           }
			           if(!isNullOrEmpty(entityType)){
			           	data.entityType = entityType;
			           }else{
			           	data.entityType = null;
			           }
			           form.getForm().setValues(data);
			           form.getForm().submit({
			           	method : 'POST',
			           	url : submitUrl,
			           	success : function(form, action){
			           		callBackFunction(true, action, isTransient);
			           		
			           	}
			           });
			       },
			       loadGridWithFileNameMessage:function(grid,value,store){
			    	   grid.bindStore(store);
			       },
	 	       
	 	      getStudentReceipientIdsForSectionRosterReport : function(grid){
		    		
		    		if (grid.getSelectionModel().getCount() > 0) {
		    			var records = grid.getSelectionModel().getSelection();
		    			var ids=[];
		    			if(grid.itemId == 'sectionrosterreportGridId'){
		    				for(var i in records) {
		    					var isNotDuplicate = true;
		    					Ext.each(ids, function(id){
		    						if(records[i].data.admissionId == id) {
		    							isNotDuplicate = false;
		    						}
		    					});
		    					if (isNotDuplicate) {
		    						ids.push(records[i].data.admissionId);
		    					}
		    				}
		    			}			
		    		}
		    		return ids;
		    	},
		    	
	        	
	        	deleteStudentSectionRosterStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
		 	    	   var grid =this.getStudentsectionrosterstaticdocumentattachmentgrid();
		 	    	   var panel = this.getContentpanel().getActiveTab();
		 	    	   var tabTitle = panel.title;
		 	    	   var store = grid.getStore();
		 	    	   var templateConfigDocId = record.get('templateConfigDocId');
		 	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
		 	    	   if(!(tabTitle == viewTitle)){
		 	    		   if(!isNullOrEmpty(templateConfigDocId)){
		 	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
		 	    				   if (btn == 'yes') {
		 	    					   Ext.Ajax.request({
		 	    						   type: 'rest',
		 	    						   url: SERVERURL.STATIC_DOC_DELETE,
		 	    						   method: 'DELETE',
		 	    						   params: {
		 	    							   templateConfigDocId : templateConfigDocId
		 	    						   },
		 	    						   headers: {
		 	    							   'Content-Type': 'application/json'
		 	    						   },
		 	    						   success: function(form, action) {
		 	    							   store.remove(record);
		 	    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
		 	    						   }
		 	    					   });
		 	    				   }
		 	    			   });

		 	    		   }else{
		 	    			   store.remove(record);
		 	    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
		 	    		   }
		 	    	   }else{
		 	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
		 	    	   }

		 	       },
		 	       onChangeCourseSectionAcademicterm: function(form, academicTermId){
		 	    	   var this$=this;
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVarientField = form.down("#courseVariantId");

		 	    	   courseField.reset();
		 	    	   courseVarientField.reset();

		 	    	   courseField.setDisabled(true);
		 	    	   courseVarientField.setDisabled(true);
		 	    	   
		 	    	   if(!isNullOrEmpty(academicTermId)){
		 	    		   courseField.setDisabled(false);
		 	    		   var academyLocationIds ;
		 	    		   var facultyId=null; 
		 	    		   if(this$.getCurrentLoggedPortalId()==2){
		 	    			   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   }else{
		 	    			   academyLocationIds = this.getAcademyLocationIds();
		 	    		   }
		 	    		   var courseStore = courseField.getStore();
		 	    		   courseStore.getProxy().extraParams = {
		 	    			   academyLocationIds: academyLocationIds,
		 	    			   academicTermId:academicTermId
		 	    		   };
		 	    		   courseStore.load({
		 	    			   callback: function(records, operation, success) {
		 	    				   if (success) {
		 	    					   if(records.length == 1){
		 	    						   courseField.setValue(records[0].data.courseId);
		 	    					   }
		 	    				   }
		 	    			   }
		 	    		   });
		 	    	   }
		 	       },
		 	       onChangeAcademicterm : function(form, academicTermId){
		 	    	   var this$=this;
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVarientField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var courseCategoryField =  form.down("#courseCategory");
		 	    	   var intakeYearField =  form.down("#intakeYear");

		 	    	   courseField.reset();
		 	    	   courseVarientField.reset();
		 	    	   programField.reset();
		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();
		 	    	   studentField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();
		 	    	   courseCategoryField.reset();
		 	    	   intakeYearField.reset();

		 	    	   courseVarientField.setDisabled(true);
		 	    	   programField.setDisabled(false);
		 	    	   batchField.setDisabled(true);
		 	    	   periodField.setDisabled(true);
		 	    	   sectionField.setDisabled(true);

		 	    	   var academyLocationIds ;
		 	    	   var facultyId=null; 
		 	    	   if(this$.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    		   facultyField.setVisible(false);
		 	    		   alternateFacultyField.setVisible(false);
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    		   facultyField.setVisible(true);
		 	    		   alternateFacultyField.setVisible(true);
		 	    	   }
		 	    	   var courseStore = courseField.getStore();
		 	    	   courseStore.getProxy().extraParams = {
		 	    		   academyLocationIds: academyLocationIds,
		 	    		   facultyId: facultyId,
		 	    		   sectionType: "ALL",
		 	    		   isCurrentPeriod:false,
		 	    		   academicTermId:academicTermId
		 	    	   };
		 	    	   courseStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1){
		 	    					   courseField.setValue(records[0].data.courseId);
		 	    				   } else{
		 	    					   if(this$.getCurrentLoggedPortalId()!=2) {
		 	    						   var facultyStore = facultyField.getStore();
		 	    						   facultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds
		 	    						   }
		 	    						   facultyStore.load();

		 	    						   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    						   alternateFacultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
			 	    						   isAlternativeFaculty:true
		 	    						   }
		 	    						   alternateFacultyStore.load();
		 	    					   }
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	    	   var programStore = programField.getStore();
		 	    	   programStore.getProxy().extraParams = {
		 	    		   academyLocationIds:academyLocationIds,
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true
		 	    	   }
		 	    	   programStore.load();

		 	    	   var studentStore = studentField.getStore();
		 	    	   studentStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   academyLocationIds:academyLocationIds
		 	    	   }
		 	    	   studentStore.load();
		 	    	   
		 	       },
		 	       onChangeCourseCategory : function(form, courseCategoryId){
		 	    	   var this$=this;
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVarientField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var courseCategoryField =  form.down("#courseCategory");
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var intakeYearField =  form.down("#intakeYear");

		 	    	   courseField.reset();
		 	    	   courseVarientField.reset();
		 	    	   programField.reset();
		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();
		 	    	   studentField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();
		 	    	   intakeYearField.reset();
		 	    	   
		 	    	   courseVarientField.setDisabled(true);
		 	    	   programField.setDisabled(false);
		 	    	   batchField.setDisabled(true);
		 	    	   periodField.setDisabled(true);
		 	    	   sectionField.setDisabled(true);
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var academyLocationIds ;
		 	    	   var facultyId=null; 
		 	    	   if(this$.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    		   var facultyStore = facultyField.getStore();
		 	    		   facultyStore.getProxy().extraParams = {
		 	    			   academicTermId:academicTermId,
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   courseCategoryId:courseCategoryId
		 	    		   }
		 	    		   facultyStore.load();

		 	    		   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    		   alternateFacultyStore.getProxy().extraParams = {
		 	    			   academicTermId:academicTermId,
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   courseCategoryId:courseCategoryId,
		 	    			   isAlternativeFaculty:true
		 	    		   }
		 	    		   alternateFacultyStore.load();
		 	    	   }
		 	    	   var courseStore = courseField.getStore();
		 	    	   courseStore.getProxy().extraParams = {
		 	    		   academyLocationIds: academyLocationIds,
		 	    		   facultyId: facultyId,
		 	    		   sectionType: "ALL",
		 	    		   isCurrentPeriod:false,
		 	    		   academicTermId:academicTermId,
		 	    		   courseCategoryId:courseCategoryId
		 	    	   };
		 	    	   courseStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1){
		 	    					   courseField.setValue(records[0].data.courseId);
		 	    				   } else{
		 	    					   if(this$.getCurrentLoggedPortalId()!=2) {
		 	    						   var facultyStore = facultyField.getStore();
		 	    						   facultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseCategoryId:courseCategoryId
		 	    						   }
		 	    						   facultyStore.load();

		 	    						   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    						   alternateFacultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseCategoryId:courseCategoryId,
		 	    							   isAlternativeFaculty:true
		 	    						   }
		 	    						   alternateFacultyStore.load();
		 	    					   }
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
		 	      onChangeCourseSectionCourseField: function(form, courseId){
		 	    	   var this$=this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   
		 	    	   courseVariantField.reset();
		 	    	   
		 	    	   courseVariantField.setDisabled(false);
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var academyLocationIds ;
		 	    	   var facultyId=null; 
		 	    	   if(this.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    	   }

		 	    	   var courseVariantStore = courseVariantField.getStore();
		 	    	   courseVariantStore.getProxy().extraParams = {
		 	    		   academyLocationIds: academyLocationIds,
		 	    		   academicTermId:academicTermId,
		 	    		   courseId:courseId
		 	    	   };
		 	    	   
		 	    	   courseVariantStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1){
		 	    					   courseVariantField.setValue(records[0].data.id);
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
		 	       courseFieldSelection : function(form, courseId, assignSectionType){
		 	    	   var this$=this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var intakeYearField =  form.down("#intakeYear");
		 	    	  
		 	    	   courseVariantField.reset();
		 	    	   programField.reset();
		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();
		 	    	   studentField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();
		 	    	   intakeYearField.reset();

		 	    	  courseVariantField.setDisabled(false);
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var academyLocationIds ;
		 	    	   var facultyId=null; 
		 	    	   if(this.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    	   }

		 	    	   form.getForm().findField('courseSectionType').setValue(assignSectionType);

		 	    	   if(assignSectionType=='ProgramBatchSection'){
		 	    		   programField.setDisabled(false);
		 	    		   batchField.setDisabled(true);
		 	    		   periodField.setDisabled(true);
		 	    		   sectionField.setDisabled(true);

		 	    		   var programStore = programField.getStore();
		 	    		   programStore.getProxy().extraParams = {
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   academicTermId:academicTermId,
		 	    			   facultyId: facultyId,
		 	    			   isAllProgram:true,
		 	    			   courseId:courseId
		 	    		   }
		 	    		   programStore.load();

		 	    	   }else{
		 	    		   programField.setDisabled(true);
		 	    		   batchField.setDisabled(true);
		 	    		   periodField.setDisabled(true);
		 	    		   sectionField.setDisabled(true);
		 	    	   }
		 	    	   var courseVariantStore = courseVariantField.getStore();
		 	    	   courseVariantStore.getProxy().extraParams = {
		 	    		   academyLocationIds: academyLocationIds,
		 	    		   facultyId: facultyId,
		 	    		   isCurrentPeriod:false,
		 	    		   academicTermId:academicTermId,
		 	    		   courseId:courseId
		 	    	   };
		 	    	   courseVariantStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1){
		 	    					   courseVariantField.setValue(records[0].data.id);
		 	    				   } else {
		 	    					   var studentStore = studentField.getStore();
		 	    					   studentStore.getProxy().extraParams = {
		 	    						   academicTermId:academicTermId,
		 	    						   facultyId: facultyId,
		 	    						   academyLocationIds:academyLocationIds,
		 	    						   courseId:courseId
		 	    					   }
		 	    					   studentStore.load();
		 	    					   if(this$.getCurrentLoggedPortalId()!=2) {
		 	    						   var facultyStore = facultyField.getStore();
		 	    						   facultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseId:courseId
		 	    						   }
		 	    						   facultyStore.load();

		 	    						   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    						   alternateFacultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseId:courseId,
			 	    						   isAlternativeFaculty:true
		 	    						   }
		 	    						   alternateFacultyStore.load();
		 	    					   }
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
		 	       courseVariantSelection : function(form, courseVariantId, assignSectionType) {
		 	    	   var $this = this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var intakeYearField =  form.down("#intakeYear");
		 	    	   
		 	    	   programField.reset();
		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();
		 	    	   studentField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();
		 	    	   intakeYearField.reset();

		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var academyLocationIds ;
		 	    	   var facultyId=null; 
		 	    	   if(this.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    	   }

		 	    	   if(assignSectionType == 'CourseSection') {
		 	    		   programField.setDisabled(true);
		 	    		   batchField.setDisabled(true);
		 	    		   periodField.setDisabled(true);
		 	    		   sectionField.setDisabled(true);

		 	    		   var studentStore = studentField.getStore();
		 	    		   studentStore.getProxy().extraParams = {
		 	    			   academicTermId:academicTermId,
		 	    			   facultyId: facultyId,
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   courseVariantId:courseVariantId
		 	    		   }
		 	    		   studentStore.load();
		 	    		   if(this$.getCurrentLoggedPortalId()!=2) {
		 	    			   var facultyStore = facultyField.getStore();
		 	    			   facultyStore.getProxy().extraParams = {
		 	    				   academicTermId:academicTermId,
		 	    				   academyLocationIds:academyLocationIds,
		 	    				   courseVariantId:courseVariantId
		 	    			   }
		 	    			   facultyStore.load();

		 	    			   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    			   alternateFacultyStore.getProxy().extraParams = {
		 	    				   academicTermId:academicTermId,
		 	    				   academyLocationIds:academyLocationIds,
		 	    				   courseVariantId:courseVariantId,
 	    						   isAlternativeFaculty:true
		 	    			   }
		 	    			   alternateFacultyStore.load();
		 	    		   }
		 	    	   } else {
		 	    		   programField.setDisabled(false);
		 	    		   batchField.setDisabled(true);
		 	    		   periodField.setDisabled(true);
		 	    		   sectionField.setDisabled(true);
		 	    		   var programStore = programField.getStore();
		 	    		   programStore.getProxy().extraParams = {
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   academicTermId:academicTermId,
		 	    			   facultyId: facultyId,
		 	    			   isAllProgram:true,
		 	    			   courseVariantId:courseVariantId
		 	    		   }
		 	    		   programStore.load({
		 	    			   callback: function(records, operation, success) {
		 	    				   if (success) {
		 	    					   if(records.length == 1){
		 	    						   programField.setValue(records[0].data.id);
		 	    					   } else {
		 	    						   var studentStore = studentField.getStore();
		 	    						   studentStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   facultyId: facultyId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseVariantId:courseVariantId
		 	    						   }
		 	    						   studentStore.load();
		 	    						   if(this$.getCurrentLoggedPortalId()!=2) {
		 	    							   var facultyStore = facultyField.getStore();
		 	    							   facultyStore.getProxy().extraParams = {
		 	    								   academicTermId:academicTermId,
		 	    								   academyLocationIds:academyLocationIds,
		 	    								   courseVariantId:courseVariantId
		 	    							   }
		 	    							   facultyStore.load();

		 	    							   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    							   alternateFacultyStore.getProxy().extraParams = {
		 	    								   academicTermId:academicTermId,
		 	    								   academyLocationIds:academyLocationIds,
		 	    								   courseVariantId:courseVariantId,
		 	    								   isAlternativeFaculty:true
		 	    							   }
		 	    							   alternateFacultyStore.load();
		 	    						   }
		 	    					   }
		 	    				   }
		 	    			   }
		 	    		   });
		 	    	   }
		 	       },
		 	       courserosterreportProgramChange : function(form, programId){
		 	    	   var $this=this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var intakeYearField =  form.down("#intakeYear");

		 	    	   batchField.reset();
		 	    	   periodField.reset();
		 	    	   sectionField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();

		 	    	   batchField.setDisabled(false);
		 	    	   periodField.setDisabled(true);
		 	    	   sectionField.setDisabled(true);
		 	    	   
		 	    	   var academyLocationIds ;
		 	    	   var facultyId = null;
		 	    	   if(this.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    	   }

		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var intakeYearId= intakeYearField.getValue();
		 	    	   
		 	    	   var studentId = studentField.getValue();
		 	    	   var batchStore = batchField.getStore();
		 	    	   batchStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   courseVariantId:courseVariantId,
		 	    		   programId:programId,
		 	    		   studentId:studentId,
		 	    		   intakeYearId:intakeYearId
		 	    	   }
		 	    	   batchStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1){
		 	    					   batchField.setValue(records[0].data.id);
		 	    				   } else if(isNullOrEmpty(studentId)){
		 	    					   var studentStore = studentField.getStore();
		 	    					   studentStore.getProxy().extraParams = {
		 	    						   academicTermId:academicTermId,
		 	    						   facultyId: facultyId,
		 	    						   academyLocationIds:academyLocationIds,
		 	    						   courseVariantId:courseVariantId,
		 	    						   programId:programId,
		 	    						   intakeYearId:intakeYearId
		 	    					   }
		 	    					   studentStore.load();
		 	    				   }else if(this$.getCurrentLoggedPortalId() != 2) {
		 	    					   var facultyStore = facultyField.getStore();
		 	    					   facultyStore.getProxy().extraParams = {
		 	    						   academicTermId:academicTermId,
		 	    						   academyLocationIds:academyLocationIds,
		 	    						   courseVariantId:courseVariantId,
		 	    						   programId:programId
		 	    					   }
		 	    					   facultyStore.load();

		 	    					   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    					   alternateFacultyStore.getProxy().extraParams = {
		 	    						   academicTermId:academicTermId,
		 	    						   academyLocationIds:academyLocationIds,
		 	    						   courseVariantId:courseVariantId,
		 	    						   programId:programId,
		 	    						   isAlternativeFaculty:true
		 	    					   }
		 	    					   alternateFacultyStore.load();
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
		 	       courserosterreportBatchChange : function(form, batchId){
		 	    	   var $this=this;
		 	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
		 	    	   var wheatherSchool = alinfomodel.get('wheatherSchool');
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var intakeYearField =  form.down("#intakeYear");
		 	    	   
		 	    	   periodField.reset();
		 	    	   sectionField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();

		 	    	   periodField.setDisabled(false);
		 	    	   sectionField.setDisabled(true);

		 	    	   var academyLocationIds ;
		 	    	   var facultyId = null;
		 	    	   if(this.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    	   }
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var intakeYearId = intakeYearField.getValue();
		 	    	   var studentId = studentField.getValue();
		 	    	   var periodStore = periodField.getStore();
		 	    	   periodStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   batchId:batchId,
		 	    		   studentId:studentId
		 	    	   }
		 	    	   periodStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 0){
		 	    					   if(wheatherSchool) {
		 	    						   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		 	    					   }
		 	    				   } else if(records.length == 1){
		 	    					   periodField.setValue(records[0].data.id);
		 	    					   if(wheatherSchool) {
		 	    						   periodField.setVisible(false);
		 	    					   }
		 	    				   } else {
		 	    					   periodField.setVisible(true);
		 	    					   if(isNullOrEmpty(studentId)) {
		 	    						   var studentStore = studentField.getStore();
		 	    						   studentStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   facultyId: facultyId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseVariantId:courseVariantId,
		 	    							   batchId:batchId,
		 	    							   intakeYearId:intakeYearId
		 	    						   }
		 	    						   studentStore.load();
		 	    					   }
		 	    					   if(this$.getCurrentLoggedPortalId() != 2) {
		 	    						   var facultyStore = facultyField.getStore();
		 	    						   facultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseVariantId:courseVariantId,
		 	    							   batchId:batchId
		 	    						   }
		 	    						   facultyStore.load();

		 	    						   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    						   alternateFacultyStore.getProxy().extraParams = {
		 	    							   academicTermId:academicTermId,
		 	    							   academyLocationIds:academyLocationIds,
		 	    							   courseVariantId:courseVariantId,
		 	    							   batchId:batchId,
		 	    							   isAlternativeFaculty:true
		 	    						   }
		 	    						   alternateFacultyStore.load();
		 	    					   }
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
		 	       periodSelection : function(form, periodId) {
		 	    	   var $this = this;
		 	    	   var academicTermField = form.down('#academicTerm');
		 	    	   var courseField = form.down("#courseItemId");
		 	    	   var courseVariantField = form.down("#courseVariantId");
		 	    	   var programField = form.down("#programItemId");
		 	    	   var batchField = form.down("#batchItemId");
		 	    	   var periodField = form.down("#periodItemId");
		 	    	   var sectionField = form.down("#sectionItemId");
		 	    	   var studentField= form.down("#studentId");
		 	    	   var facultyField = form.down("#facultyItemId"); 
		 	    	   var alternateFacultyField =  form.down("#alternativeFacultyItemId");
		 	    	   var intakeYearField =  form.down("#intakeYear");

		 	    	   sectionField.reset();
		 	    	   facultyField.reset();
		 	    	   alternateFacultyField.reset();

		 	    	   sectionField.setDisabled(false);
		 	    	   var academyLocationIds ;
		 	    	   var facultyId = null;
		 	    	   if(this.getCurrentLoggedPortalId()==2){
		 	    		   academyLocationIds = this.getCurrentAcademyLocation();
		 	    		   facultyId=this.getCurrentlyLoggedInUser().id;
		 	    	   }else{
		 	    		   academyLocationIds = this.getAcademyLocationIds();
		 	    	   }
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var intakeYearId = intakeYearField.getValue();
		 	    	   var studentId = studentField.getValue();
		 	    	   var sectionStore = sectionField.getStore();
		 	    	   sectionStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   periodId:periodId,
		 	    		   courseVariantId:courseVariantId
		 	    	   }
		 	    	   sectionStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1 && !isNullOrEmpty(courseVariantId)) {
		 	    					   sectionField.setValue(records[0].data.id)
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	    	   if(isNullOrEmpty(studentId)) {
		 	    		  var studentStore = studentField.getStore();
			 	    	   studentStore.getProxy().extraParams = {
			 	    		   academicTermId:academicTermId,
			 	    		   facultyId: facultyId,
			 	    		   academyLocationIds:academyLocationIds,
			 	    		   courseVariantId:courseVariantId,
			 	    		   periodId:periodId,
			 	    		   intakeYearId:intakeYearId
			 	    	   }
			 	    	   studentStore.load();
		 	    	   }
		 	    	   if(this$.getCurrentLoggedPortalId() != 2) {
		 	    		   var facultyStore = facultyField.getStore();
		 	    		   facultyStore.getProxy().extraParams = {
		 	    			   academicTermId:academicTermId,
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   courseVariantId:courseVariantId,
		 	    			   periodId:periodId
		 	    		   }
		 	    		   facultyStore.load();

		 	    		   var alternateFacultyStore = alternateFacultyField.getStore();
		 	    		   alternateFacultyStore.getProxy().extraParams = {
		 	    			   academicTermId:academicTermId,
		 	    			   academyLocationIds:academyLocationIds,
		 	    			   courseVariantId:courseVariantId,
		 	    			   periodId:periodId,
		 	    			   isAlternativeFaculty:true
		 	    		   }
		 	    		   alternateFacultyStore.load();
		 	    	   }
		 	       },

		 	       
			 	      /**
			 	       * Open passwordRest window for admin 
			 	       */
			 	      openResetPasswordWindowCR:function(){
			 	   	    var resetPswrdWindowItemId ="StudentListCourseRosterReportResetPass";
			 	          var resetPswrdFormWindow = Ext.widget('adminresetpasswordwindow', {
			 	               itemId: resetPswrdWindowItemId
			 	           });
			 	          resetPswrdFormWindow.show();
			 	   	    
			 	      },
			 	     changePasswordByAdminCR:function(button){
			 	    	var $this = this;
			 	    	var grid = $this.getCourserosterreportgrid();
			 	    	var gridRec=grid.getSelectionModel().getSelection();
			 	    	var window=button.up('window');
			 	    	var form=button.up('form').getForm();
			 			var formValues=form.getValues();
			 			var userIdss = [];
			 			Ext.each(gridRec, function(currentRecord){
			 				userIdss.push(currentRecord.data.studentId);
			 			});
			 			var userIds= [];
			 			userIds=$this.removeDuplicatesFromArray(userIdss);
			 			var data={
			 					  "userIds":userIds.join(','),
			 					  "newPassword":this.encryptPassword(formValues.confirmedPassword)
			 					};
			 			
			 						/**
			 						 * Change password
			 						 */
			 						var pswrdurl = SERVERURL.CHANGE_PASSWORD_BY_ADMIN;
			 						 $this.applyWindowMask(); 
			 						  
			 						Ext.Ajax.request({
			 				            method: "POST",
			 				            type: 'rest',
			 				            url:pswrdurl,
			 				            jsonData:data,
			 				            success: function(response) {
			 				            	$this.hideWindowMask();
			 				            	var mssg = response.responseText;
			 								if (mssg == "SUCCESS") {
			 								    window.close();
			 				            	    showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('ADMIN_PASSWORD_CHANGE_MSG'));
			 								}else if(mssg == "USER_LOCKED"){
			 									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
			 								}else if(mssg.includes("PASSWORD_IN_USE")){
			 									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PASSWORD_IN_USE'));
			 								}else{
			 									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_NOT_FOUND_MSG'));
			 								}
			 				            }
			 						});
			 						
			 					/*}
			 	            }
			 			 });*/
			 	    },
			 	     removeDuplicatesFromArray:function (userIdss) {
			 			    if (!Array.isArray(userIdss)) {
			 			        return undefined;
			 			    }
			 			    var uniqueArray = userIdss.filter(function(elem, pos) {
			 			        return userIdss.indexOf(elem) === pos;
			 			    });
			 			    return uniqueArray;
			 			},
			 			/**
			 		     * This is used to disable extra buttons on Course Roster grid
			 		     */
			 		    disableExtraButton:function(column,selected) {
			 		    	var grid = this.getCourserosterreportgrid();
			 		    	var resetPasswordBtn = grid.down('#resetPasswordBtn');
			 		    	var exportCourseRosterReportsButton = grid.down('#exportCourseRosterReportsId');
			 		    	if(selected.length== 1){ // enable
			 		    		resetPasswordBtn.setDisabled(false);
			 		    	}else{  // disable
			 		    		resetPasswordBtn.setDisabled(true);
			 		    	}
			 		    	if(selected.length>0){ // enable
			 		    		exportCourseRosterReportsButton.setDisabled(false);
			 		    	}else{  // disable
			 		    		exportCourseRosterReportsButton.setDisabled(true);
			 		    	}
			 		    },
			 		    
			 		    loadStudentCourseSectionGridData: function(){
			 		    	var $this = this;

			 		    	var courseGrid = $this.getStudentcoursesectionreportgrid();

			 		    	var searcgfrm = $this.getStudentcoursesectionreportsearchform().getForm();
			 		    	var academicTermId = searcgfrm.findField("academicTerm").getValue();
			 		    	var courseId = searcgfrm.findField("courseId").getValue();
			 		    	var courseVariantId = searcgfrm.findField("COURSE_VARIENT_ID").getValue();
			 		    	var store = courseGrid.getStore();
			 		    	var alinfomodel = Academia.model.authentication.ALInfoModel;
			 		    	var whetherSchool = alinfomodel.get('wheatherSchool');

			 		    	var academyLocationIds ;
			 		    	if(this.getCurrentLoggedPortalId()==2){
			 		    		academyLocationIds = this.getCurrentAcademyLocation();
			 		    	}else{
			 		    		academyLocationIds = this.getAcademyLocationIds();
			 		    	}
			 		    	
			 		    	store.getProxy().extraParams = {
			 		    		academyLocationIds : academyLocationIds,
		 		    			academicTermId:academicTermId,
		 		    			courseId : courseId,
		 		    			courseVariantId : courseVariantId
		 		    		};
			 		    	
			 		    	$this.resetPageSetting(store);
			 		    	store.load();
			 		    },
			 		    getCurrentlyEnrolledCSForStudents : function(record){
			 		    	var $this = this;
			 		    	var formWindow = $this.getStudentcoursesectionenrolledstudentswindow();
			 		    	if (!formWindow) {
			 		    		Ext.widget('studentcoursesectionenrolledstudentswindow');
			 		    		formWindow = $this.getStudentcoursesectionenrolledstudentswindow();
			 		    	}
			 		    	formWindow.show();
			 		    	var windowGrid = formWindow.down('grid');
			 		    	var store1 = windowGrid.getStore();
			 		    	store1.getProxy().extraParams = {
			 		    		courseId : record.data.courseId,
			 		    		sectionId:record.data.id,
			 		    		sort:null
			 		    	};
			 		    	store1.loadPage(1);
			 		    }
});