/**
 * This controller is used for faculty dashboard controller
 * @author Pravin.Surve
 */
Ext.define('Academia.controller.reports.faculty.FacultyDashboardController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['reports.servicerequest.FacultyRequestReportTreeStore', 'reports.servicerequest.ClosureReasonGraphStore', 
             'reports.servicerequest.CountOfRequestStore', 'reports.servicerequest.ServiceLevelGraphStore', 'reports.servicerequest.SystemUsersByAcademyLocationIds',
             'reports.servicerequest.RequestClosureRateStore', 'servicerequest.complaintrequest.ComplaintPersons',
             'servicerequest.ServiceRequestCategory', 'servicerequest.ServiceRequests','common.AcademyStore','common.LocationStore',
             'common.ProgramsByAcademyIdLocationId','common.BatchesByProgramId','servicerequest.servicerequestsettings.CertificateCategories',
             'coursetransaction.sectionmanagement.SectionMultiSelect','reports.servicerequest.ServiceRequestSubCategoryStore',
             'department.DepartmentComboStore','department.SubDepartmentComboStore', 'department.DepartmentAcademyLocationWiseStore',
             'reports.servicerequest.CertificateSubCategoryStore','reports.servicerequest.FreeFormCategoryStore',
             'reports.servicerequest.FreeFormSubCategoryStore','common.LiveSearchCombos', 'servicerequest.common.RequestBy',
             'reports.servicerequest.UnassignedRequestStore', 'reports.servicerequest.FollowupRequestStore'],
             
    views: ['reports.common.DashboardReportTabStructure', 'reports.faculty.FacultyDashboardCommonSearchForm', 
            'reports.faculty.FacultyDashBoardView', 'reports.faculty.FacultyClosureReasonView',
            'reports.common.ColumnChartReport', 'common.LiveSearchCombo','common.NestedJsonCombo',
            'reports.common.BarChartReport', 'reports.common.GroupedBarChart', 'reports.common.PieChartReport',
            'reports.faculty.FacultyServiceLevelView', 'reports.servicerequest.RequestAssignedWindow',
            'reports.faculty.FacultyRequestClosureRateView', 'reports.faculty.FacultyCountRequestView','reports.student.RequestSubRequestTypeFieldContainer',
            'reports.faculty.FacultyFollowUpScheduledSearchForm','reports.faculty.FacultyFollowUpScheduledView', 'reports.servicerequest.FollowupRequestReportGrid',
            'reports.faculty.FacultyUnassignedRequestView','reports.faculty.FacultyUnassignedRequestSearchForm','reports.servicerequest.UnassignedRequestReportGrid'],
            
    
    refs: [{
    	ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'facultyDashboardView',
        selector: 'facultydashboardview'
    }, {
    	ref: 'facultyDashboardReportTabStructure',
    	selector: 'dashboardreporttabstructure[itemId=facultyDashboardReportTabStructure]'
    }, {
        ref: 'organizationunit',
        selector: 'organizationunit'
    }, {
        ref: 'facultyRequestClosureRateSearchForm',
        selector: 'facultydashboardcommonsearchform[itemId=facultyRequestClosureRateSearchForm]'
    }, {
        ref: 'facultyRequestClosureRateChart',
        selector: 'columnchartreport[itemId=facultyRequestClosureRateChart]'
    }, {
        ref: 'facultyCountOfRequestSearchForm',
        selector: 'facultydashboardcommonsearchform[itemId=facultyCountOfRequestSearchForm]'
    }, {
        ref: 'facultyCountOfRequestChart',
        selector: 'columnchartreport[itemId=facultyCountOfRequestChart]'
    }, {
        ref: 'facultyServiceLevelSearch',
        selector: 'facultydashboardcommonsearchform[itemId=facultyServiceLevelSearch]'
    }, {
        ref: 'facultyServiceLevelChart',
        selector: 'groupedbarchart[itemId=facultyServiceLevelChart]'
    }, {
        ref: 'facultyClosureReasonSearch',
        selector: 'facultydashboardcommonsearchform[itemId=facultyClosureReasonSearch]'
    }, {
        ref: 'facultyClosureReasonChart',
        selector: 'barchartreport[itemId=facultyClosureReasonChart]'
    },{
    	ref : 'facultyFollowUpScheduledSearchForm',
    	selector : 'facultyfollowupscheduledsearchform[itemId=facultyFollowUpScheduledSearchForm]'
    },{
    	ref : 'facultyFollowUpSearchResultGrid',
    	selector : 'followuprequestreportgrid[itemId=facultyFollowUpScheduledGrid]'
    },{
    	ref : 'facultyUnassignedRequestSearchForm',
    	selector : 'facultyunassignedrequestsearchform[itemId=facultyUnassignedRequestSearchForm]'
    },{
    	ref : 'facultyUnassignedSearchResultGrid',
    	selector : 'unassignedrequestreportgrid[itemId=facultyUnassignedRequestSearchGrid]'
    }, {
    	ref: 'requestAssignedWindow',
    	selector: 'requestassignedwindow'
    }, {
    	ref: 'assignRequestForm',
    	selector: 'requestassignedwindow form[itemId=assignRequestForm]'
    }],
    config: {
    	FACULTY_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNASSIGNEDREQUEST_PRIVILEGES'),
    	FACULTY_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	FACULTYDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTYDASHBOARD_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	'organizationunit[itemId=facultyDashboardOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getFACULTYDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=facultyDashboardOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
    		'organizationunit[itemId=facultyDashboardOrganizationUnit] multiselectcombofield[itemId=multiselectAcademyLocationId]' : {
    			change: function(combo) {
    				this.searchBtnEnableDisable(combo.getValue());
    			}
    		},
        	'facultydashboardview panel[itemId=facultyReportView] treepanel[itemId=facultyReportTreePanelItemId]': {
        		itemclick : function( treePanel, record, item, index, e, eOpts ) {
					var $this = this;
					var facultyDashboardView = $this.getFacultyDashboardView();
					var treeTab = facultyDashboardView.down('#facultyReportTreePanelItemId');
					var tabDetail = record.data;
					if(!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype) && !isNullOrEmpty(tabDetail.reportXtypeItemId)){
						treeTab.toggleCollapse();
						var facultyDashboardReportTabStructure = $this.getFacultyDashboardReportTabStructure();
						facultyDashboardReportTabStructure.removeAll();
						
						if (facultyDashboardReportTabStructure) {
							facultyDashboardReportTabStructure.add({
										xtype : tabDetail.reportXtype,
										itemId: tabDetail.reportXtypeItemId,
										title: tabDetail.text,
										frame: true
							});
							facultyDashboardReportTabStructure.show();
						} 
						treePanel.getSelectionModel().deselectAll();
					}
					
				}
       	     },
        	'facultydashboardcommonsearchform combo[itemId=departmentCombo]':{
        		focus : function(departmentCombo, records, eOpts) {
        			this.loadDepartmentComboByApplyingMAUFilter(departmentCombo, records, eOpts);
        		},
        		select : function(combo){
        			var form = combo.up('form');
        			this.onSetDepartmentComboValue(form, combo);
        		}
        	},
        	'facultyunassignedrequestsearchform[itemId=facultyUnassignedRequestSearchForm] combo[itemId=departmentCombo]':{
        		focus : function(departmentCombo, records, eOpts) {
        			this.loadDepartmentComboByApplyingMAUFilter(departmentCombo, records, eOpts);
        		},
        		select : function(combo){
        			var form = combo.up('form');
        			this.onSetDepartmentComboValue(form, combo);
        		}
        	},
        	'facultyfollowupscheduledsearchform[itemId=facultyFollowUpScheduledSearchForm] combo[itemId=departmentCombo]':{
        		focus : function(departmentCombo, records, eOpts) {
        			this.loadDepartmentComboByApplyingMAUFilter(departmentCombo, records, eOpts);
        		},
        		select : function(combo){
        			var form = combo.up('form');
        			this.onSetDepartmentComboValue(form, combo);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyCountOfRequestSearchForm]': {
        		beforerender: function(form){
        			form.down('#assigneeCombo').setVisible(true);
        		}
        	},
        	'facultyunassignedrequestsearchform[itemId=facultyUnassignedRequestSearchForm] button[itemId=searchButtonId]':{
        		click: function(){
                	this.loadUnAssignedRequestGridResults();
                }
        	},
        	'unassignedrequestreportgrid[itemId=facultyUnassignedRequestSearchGrid]': {
        		cellclick: function(grid, td, cellIndex, record){
               	 	var searchResultGrid = this.getFacultyUnassignedSearchResultGrid();
               	 	this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);            		
               	 }
        	},
        	'facultyfollowupscheduledsearchform[itemId=facultyFollowUpScheduledSearchForm] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadFollowUpScheduleGridResults();
        		}
        	},
        	'followuprequestreportgrid[itemId=facultyFollowUpScheduledGrid]': {
        		cellclick: function(grid, td, cellIndex, record){
               	 	var searchResultGrid = this.getFacultyFollowUpSearchResultGrid();
               	 	this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);            		
               	 }
        	},
        	'facultydashboardcommonsearchform[itemId=facultyRequestClosureRateSearchForm] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadServiceRequestClosureRateChart();
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyCountOfRequestSearchForm]': {
        		beforerender: function(form){
        			form.down('#startDate').setFieldLabel(getServiceRequestTranslation('RAISED_START_DATE'));
        			form.down('#endDate').setFieldLabel(getServiceRequestTranslation('RAISED_UP_END_DATE'));
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyCountOfRequestSearchForm] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadCountOfRequestChart();
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyServiceLevelSearch]': {
        		beforerender: function(form){
        			form.down('#startDate').setVisible(false);
        			form.down('#endDate').setVisible(false);
        			form.down('#dayLimitField').setVisible(true);
        			form.down('#dayLimitField').setDisabled(false);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyServiceLevelSearch] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadServiceLevelChart();
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyClosureReasonSearch] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadClosureReasonChart();
        		}
        	},
        	/**
             * On reset button click event handling for all dashboard tab
             */
        	'facultyunassignedrequestsearchform[itemId=facultyUnassignedRequestSearchForm] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getFacultyUnassignedRequestSearchForm();
        			form.getForm().reset();
//        			var academyLocationIds = this.getOrganizationUnitAcademyLocationObject();
//        			this.searchBtnEnableDisable(academyLocationIds);
        		}
        	},
        	'facultyfollowupscheduledsearchform[itemId=facultyFollowUpScheduledSearchForm] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getFacultyFollowUpScheduledSearchForm();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'facultyfollowupscheduledsearchform[itemId=facultyFollowUpScheduledSearchForm]': {
        		render : function(){
        			var this$ = this;
            		var academyLocationIds = this$.getOrganizationUnitAcademyLocationObject();
    		    	this.searchBtnEnableDisable(academyLocationIds);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyRequestClosureRateSearchForm] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getFacultyRequestClosureRateSearchForm();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyRequestClosureRateSearchForm]': {
        		render : function(){
        			var this$ = this;
            		var academyLocationIds = this$.getOrganizationUnitAcademyLocationObject();
    		    	this.searchBtnEnableDisable(academyLocationIds);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyCountOfRequestSearchForm]': {
        		render : function(){
        			var this$ = this;
            		var academyLocationIds = this$.getOrganizationUnitAcademyLocationObject();
    		    	this.searchBtnEnableDisable(academyLocationIds);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyServiceLevelSearch]': {
        		render : function(){
        			var this$ = this;
            		var academyLocationIds = this$.getOrganizationUnitAcademyLocationObject();
    		    	this.searchBtnEnableDisable(academyLocationIds);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyClosureReasonSearch]': {
        		render : function(){
        			var this$ = this;
            		var academyLocationIds = this$.getOrganizationUnitAcademyLocationObject();
    		    	this.searchBtnEnableDisable(academyLocationIds);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyCountOfRequestSearchForm] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getFacultyCountOfRequestSearchForm();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyServiceLevelSearch] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getFacultyServiceLevelSearch();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'facultydashboardcommonsearchform[itemId=facultyClosureReasonSearch] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getFacultyClosureReasonSearch();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'requestassignedwindow[itemId=facultyAssignToWindow] form[itemId=assignRequestForm] button[itemId=cancelButtonId]': {
            	click: function(){
            		this.getRequestAssignedWindow().close();
            	}
            },
            'requestassignedwindow[itemId=facultyAssignToWindow] form[itemId=assignRequestForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.submitAssignRequest();
            	}
            },
            'requestassignedwindow[itemId=facultyAssignToWindow] form[itemId=assignRequestForm] combo[itemId=requestAssigneeCombo]': {
            	afterrender: function(combo){
            		this.loadAssigneeCombo(combo);
            	}
            },
            'facultyunassignedrequestsearchform[itemId=facultyUnassignedRequestSearchForm]' : {
            	render : function() {
            		var this$ = this;
            		var academyLocationIds = this$.getOrganizationUnitAcademyLocationObject();
    		    	this.searchBtnEnableDisable(academyLocationIds);
            	}
            },
    		'unassignedrequestreportgrid':{
    			render:function(grid){
    				var structure = this.getFacultyDashboardView();
    				this.getGridHeaderFreezeForEmpLeaveGrids(grid,structure);
    			}
    		},
    		'followuprequestreportgrid':{
    			render:function(grid){
    				var structure = this.getFacultyDashboardView();
    				this.getGridHeaderFreezeForEmpLeaveGrids(grid,structure);
    			}
    		}
            /*'searchresultgrid[itemId=facultyUnassignedRequestSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'UNASSIGNEDREQUEST');
		            }
	        },
	        'searchresultgrid[itemId=facultyUnassignedRequestSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'UNASSIGNEDREQUEST');
	            }
	        },
	        'searchresultgrid[itemId=facultyUnassignedRequestSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'UNASSIGNEDREQUEST');
	            }
	        },
	        'searchresultgrid[itemId=facultyUnassignedRequestSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'UNASSIGNEDREQUEST');
	            }
	        },
	        'searchresultgrid[itemId=facultyFollowUpScheduledGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'FOLLOWUPSCHEDULED');
		            }
	        },
	        'searchresultgrid[itemId=facultyFollowUpScheduledGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'FOLLOWUPSCHEDULED');
	            }
	        },
	        'searchresultgrid[itemId=facultyFollowUpScheduledGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'FOLLOWUPSCHEDULED');
	            }
	        },
	        'searchresultgrid[itemId=facultyFollowUpScheduledGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'FOLLOWUPSCHEDULED');
	            }
	        }*/
        	
        });
    },
    
    /***
	  * This function is to export pdf and xcel
	  *//*
	    
   exportReport : function(exportUrl,filetype,whetherAll,requestType) {
	    	var quickSearchForm=null;	
	    	var searchResultGrid= null;
	    	var pagingtoolbaroptions = null;
	    	var reportTitle = null;
	    	if(requestType == 'UNASSIGNEDREQUEST'){
	    	 quickSearchForm=this.getFacultyUnassignedRequestSearchForm();
	    	 searchResultGrid = this.getFacultyUnassignedSearchResultGrid();
	    	 pagingtoolbaroptions = this.getUnassignedRequestReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("FACULTY_UNASSIGNEDREQUEST");
	    	}
	    	if(requestType == 'FOLLOWUPSCHEDULED'){
	    	 quickSearchForm=this.getFacultyFollowUpScheduledSearchForm();
	    	 searchResultGrid = this.getFacultyFollowUpSearchResultGrid();	
	    	 pagingtoolbaroptions = this.getFollowUpScheduledReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("FACULTY_FOLLOWUPSCHEDULED");
	    	}
	    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	        var formValues = new Array();
	        formValues = searchForm.getValues();        
	        var searchCriteriaString="";
	        for (var key in formValues) {
	        	var value = formValues[key];            
	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                var keyValueJsonObject = me.getJsonObject( key , value);
	    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	            }
	        }
	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        return searchCriteriaString;
	    },
	    
	    gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	    },*/
	    
    /**
     * Clear the combo values
     * @params combo
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    /**
     * Reset dashboard search criteria
     * @parms form search criteria search form
     */
    resetDashboardSearchCriteriaForm: function(form) {
    	
    	form.getForm().reset();
    	var comboToBeResetArray = new Array();
    	comboToBeResetArray.push(form.down('#requestSubCategoryField'));
    	comboToBeResetArray.push(form.down('#certificateSubCategoryField'));
    	comboToBeResetArray.push(form.down('#freeFormCategoryField'));
    	comboToBeResetArray.push(form.down('#freeFormSubCategoryField'));
    	comboToBeResetArray.push(form.down('#subDepartmentCombo'));
    	for(var i= 0; i < comboToBeResetArray.length; i++){
        	if(!isEmpty(comboToBeResetArray[i])){
        		this.clearCombo(comboToBeResetArray[i]);
        	}
        }
    	form.down('#requestSubCategoryField').setVisible(true);
    	form.down('#certificateCategoryField').setVisible(false);
    	form.down('#certificateSubCategoryField').setVisible(false);
    	form.down('#freeFormCategoryField').setVisible(false);
    	form.down('#freeFormSubCategoryField').setVisible(false);
    	var requestStore = form.down('#requestTypeItemId').getStore();
    	requestStore.load({
    		callback: function(records, operation, success) {
				   if (success) {
					   form.down('#requestTypeItemId').setValue(records[1].get('value'));
				   }
    		}
    	});
    	
    },
    
    /**
     * On focus department combo load data according with MAU filter's
     * @param programComboField
     * @param records
     * @param eOpts
     */
    
    loadDepartmentComboByApplyingMAUFilter: function(departmentCombo, records, eOpts){
		var academyLocationIds = this.getAcademyLocationIds();
		var store = departmentCombo.getStore();
		store.load({
			params: {
				academyLocationsIds: academyLocationIds
			}
		});
	},
    
    /**
     * load faculty service request closure graph store
     */
    onSetDepartmentComboValue : function(form, combo){
    	
    	var deparementId = combo.getValue();
    	var subDepartmentCombo = form.down('#subDepartmentCombo');
    	this.clearCombo(subDepartmentCombo);
        var store = subDepartmentCombo.getStore();
        store.load({
        	params : {
        		parentId : deparementId
        	}
        });
        
    },
    
    /**
     * Unassigned request search result
     */
    loadUnAssignedRequestGridResults: function() {
    	var this$= this;
    	var searchCriteriaForm = this$.getFacultyUnassignedRequestSearchForm();
    	var resultGrid = this$.getFacultyUnassignedSearchResultGrid();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(searchCriteriaForm);
    	var submitData = this.getSearchFormValue(formValues);
    	var store = resultGrid.getStore();
    	 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	store.getProxy().extraParams = submitData;
    	resultGrid.down('custompagingtoolbar').moveFirst();
		store.load();
	 	var taskDelay = new Ext.util.DelayedTask(function(){
    		Ext.getBody().unmask();
    	  });
    	taskDelay.delay(1000);
    	/*pdf & excel report header filter*/
    	resultGrid.config.searchFilterForm = searchCriteriaForm;
    	
    },
    /**
     * This method is used to load faculty followed up scheduled search result grid according to search criteria
     * @param model
     * @param records
     */
    loadFollowUpScheduleGridResults: function(model, records) {
    	var this$= this;
    	var searchCriteriaForm = this$.getFacultyFollowUpScheduledSearchForm();
    	var resultGrid = this$.getFacultyFollowUpSearchResultGrid();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(searchCriteriaForm);
    	var submitData = this.getSearchFormValue(formValues);
    	var store = resultGrid.getStore();
    	 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	store.getProxy().extraParams = submitData;
    	resultGrid.down('custompagingtoolbar').moveFirst();
    	store.load();
    	var taskDelay = new Ext.util.DelayedTask(function(){
    		Ext.getBody().unmask();
    	  });
    	taskDelay.delay(1000);
    	/*pdf & excel report header filter*/
    	resultGrid.config.searchFilterForm = searchCriteriaForm;
    },
    /**
     * load faculty request closure graph store
     */
    loadServiceRequestClosureRateChart : function(){
    	var this$= this;
    	var facultyRequestClosureRateSearchForm = this$.getFacultyRequestClosureRateSearchForm();
    	var facultyRequestClosureRateChart = this$.getFacultyRequestClosureRateChart();
    	
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(facultyRequestClosureRateSearchForm);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_REQUEST_CLOSUTRE_RATE,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: submitData,
            success: function(response) {
            	Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		facultyRequestClosureRateChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load faculty count of request graph store
     */
    loadCountOfRequestChart : function(){
    	var this$= this;
    	var facultyCountOfRequestSearchForm = this$.getFacultyCountOfRequestSearchForm();
    	var facultyCountOfRequestChart = this$.getFacultyCountOfRequestChart();
    	
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(facultyCountOfRequestSearchForm);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_REQUEST_COUNT_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: submitData,
            success: function(response) {
            	 Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		facultyCountOfRequestChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load faculty service level Chart store
     */
    loadServiceLevelChart : function(){
    	var this$ = this;
    	var facultyServiceLevelSearch = this$.getFacultyServiceLevelSearch();
    	var facultyServiceLevelChart = this$.getFacultyServiceLevelChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(facultyServiceLevelSearch);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_LEVEL_GRAPH_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData:submitData,
            success: function(response) {
           	  Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		facultyServiceLevelChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load faculty closure reason graph store
     */
    loadClosureReasonChart : function(){
    	var this$ = this;
    	var facultyClosureReasonSearch = this$.getFacultyClosureReasonSearch();
    	var facultyClosureReasonChart = this$.getFacultyClosureReasonChart();
    	
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(facultyClosureReasonSearch);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_REQUEST_CLOSUTRE_REASON,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: submitData,
            success: function(response) {
            	 Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		facultyClosureReasonChart.getStore().loadData(data);
            }
        });
    },
    
    /**
     * Create dashboard search criteria json
     * @params searchCriteriaForm
     */
    createSeachCriteriaDashboardJsonFormat: function(searchCriteriaForm){
    	var formValues = null;
    	if(searchCriteriaForm){
    		formValues = searchCriteriaForm.getValues();
        	for (var key in formValues) {
            	var value = formValues[key];            
                if(isNullOrEmpty(value) || value =='All' || key == 'selectedNameField'){
                	delete formValues[key];
                }
            }
        	var academyLocationIds = this.getAcademyLocationIds();
        	if(!isNullOrEmpty(academyLocationIds)){
        		academyLocationIds = academyLocationIds.toString();
        		var commaIndex = academyLocationIds.indexOf(",");
        		if(commaIndex != -1){
        			var academyLocationArray = academyLocationIds.split(",");
                	formValues.academyLocationIds = academyLocationArray;
        		}else{
        			formValues.academyLocationIds = [academyLocationIds];
        		}
            	
        	}
        	if(!isEmpty(formValues.requesterId)){
        		formValues.requesterId = formValues.requesterId.id;
        	}
        	if(!isEmpty(formValues.assignTo)){
        		formValues.assignTo = formValues.assignTo.id;
        	}
        	delete formValues['requestType'];
        	delete formValues['certificateCategory'];
        	delete formValues['freeFormCategory'];
        	if(isNullOrEmpty(formValues.requesterType)){
        		formValues.requesterType = 'FACULTY';
        	}
        	
    	}
    	return formValues;
    },
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(key) && !isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(key) && !isNullOrEmpty(value) && !isNullOrEmpty(additionalValue)) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    /**
     * Get Service Request controller
     */
    getServiceRequestController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.servicerequest.ServiceRequestController');
    },
    /**
	  * This method is used to open tab after click of RequestId Cell of student track request grid
	  * Required :
	  * @param grid
	  * @param cellIndex
	  * @param record
	  */
   cellclickTrackRequestGrid: function(grid, cellIndex, record) {
	   var this$ = this;
	   var cellDataIndex = grid.columnManager.columns[cellIndex].dataIndex;
	   if (cellDataIndex == "requestId") {
		   var requestId = record.get('serviceRequestId');
		   var requestType = record.get('serviceRequestType');
		   record.data.ID  = record.get('serviceRequestId');
		   record.data.REQUEST_ID  = record.get('requestId');
		   record.data.SERVICE_REQUEST_GROUP  = record.get('serviceRequestGroup');
		   record.data.REQUEST_TYPE_ID  = record.get('requestTypeId');
		   record.data.SERVICE_REQUEST_TYPE  = record.get('serviceRequestType');
		   record.data.REQUESTER  = record.get('requester');
		   record.data.PERSON_ID  = record.get('personId');
		   record.data.PROGRAM_BATCH_ID  = null;
		   record.data.PROGRAM_BATCH_SEAT_CONFIG_ID  = null;
		   record.data.SERVICE_REQUEST_STAGE = record.get('serviceRequestStage');
		   record.data.REQUEST_ASSIGNED_TO= record.get('requestAssignedTo');
		   this$.getServiceRequestController().setRequestData(requestId,record,requestType);  
	   }else if(cellDataIndex == "assignRequest"){
		   var formWindow = this$.getRequestAssignedWindow();
		   if(!formWindow){
			   formWindow = Ext.widget('requestassignedwindow',{
				   itemId:'facultyAssignToWindow'
			   });  
		   }
		   formWindow.show();
		   
	   }
   },
   loadAssigneeCombo: function(combo){
		  var this$ = this;
		  var contentPanel = this$.getContentPanel();
		  var dashboardReportTab = contentPanel.down('#facultyDashboardReportTabStructure');
	 	  var grid = dashboardReportTab.down('grid');
		  if (grid.getSelectionModel().getCount() > 0) {
			  var records = grid.getSelectionModel().getSelection()[0];
			  var academyLocationId =records.get('academyLocationId');
			  combo.getStore().getProxy().extraParams = {
		    		academyLocationId:academyLocationId
		      };   
		  }
   },
   /**
    * assign request to users
    */
   submitAssignRequest: function(){
 	  var this$ = this;
 	  var contentPanel = this$.getContentPanel();
 	  var dashboardReportTab = contentPanel.down('#facultyDashboardReportTabStructure');
 	  var grid = dashboardReportTab.down('grid');
 	  var assignRequestForm = this.getAssignRequestForm();
 	  var formvalues = assignRequestForm.getValues();
 	  var assigneeId = formvalues.assigneeId;
 	  if (grid.getSelectionModel().getCount() > 0) {
		  if(!isNullOrEmpty(assigneeId)){
			  var records = grid.getSelectionModel().getSelection()[0];
			  var serviceRequestId =records.get('serviceRequestId');
			  formvalues.id = serviceRequestId;
	        	  
			  var jsonFormFieldData = Ext.encode(formvalues);
			  Ext.Ajax.request({
                  type: 'rest',
                  url: SERVERURL.COMPLAINT_ASSIGN_SERVICE_REQUEST,
                  method: 'POST',
                  jsonData: jsonFormFieldData,
                  headers: {
                      'Content-Type': 'application/json'
                  },
                  success: function(form, action) {
                	  this$.getRequestAssignedWindow().close();
                      grid.getStore().reload();
                      showSuccessMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getServiceRequestTranslation('REQUEST_ASSIGN_SUCCESS'));
                  }
              });
		  }else{
			   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getServiceRequestTranslation('PLEASE_SELECT_ASSIGNEE'));
		   }
		  
	   }else{
 		   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
 	  
   },
   
   /**
    * This method is used get Search Form Value 
    * @param formValues
    * @author Pritam Patil
    */
   getSearchFormValue : function(formValues){
   	
   	if(formValues.SERVICE_REQUEST_GROUP){
   		formValues.serviceRequestGroup = formValues.SERVICE_REQUEST_GROUP ;
   		delete formValues.SERVICE_REQUEST_GROUP;
   	}
   	if(formValues.CERTIFICATE_ID){
   		formValues.certificateId = formValues.CERTIFICATE_ID ;
   		delete formValues.CERTIFICATE_ID;
   	}
   	if(formValues.CERTIFICATE_CATEGORY){
   		formValues.certificateCategory = formValues.CERTIFICATE_CATEGORY ;
   		delete formValues.CERTIFICATE_CATEGORY;
   	}
   	if(formValues.REQUEST_TYPE_ID){
   		formValues.requestTypeId = formValues.REQUEST_TYPE_ID ;
   		delete formValues.REQUEST_TYPE_ID;
   	}
   	if(formValues.FREE_FORM_REQUEST_CATEGORY){
   		formValues.freeFormRequestCategoryId = formValues.FREE_FORM_REQUEST_CATEGORY ;
   		delete formValues.FREE_FORM_REQUEST_CATEGORY;
   	}
   	if(formValues.FREE_FORM_REQUEST_ID){
   		formValues.freeFormRequestId = formValues.FREE_FORM_REQUEST_ID ;
   		delete formValues.FREE_FORM_REQUEST_ID;
   	}
   	return formValues ;
   },
   searchBtnEnableDisable : function(academyLocationIds) {
			if(Ext.isDefined(this.getFacultyUnassignedRequestSearchForm())) {
				var filter = this.getFacultyUnassignedRequestSearchForm();
				this.searchButtonEnablDisableOfNoMandatoryFieldForm(academyLocationIds, filter);
			} else if(Ext.isDefined(this.getFacultyFollowUpScheduledSearchForm())) {
				var filter = this.getFacultyFollowUpScheduledSearchForm();
				this.searchButtonEnablDisableOfNoMandatoryFieldForm(academyLocationIds, filter);
			} else if(Ext.isDefined(this.getFacultyRequestClosureRateSearchForm())) {
				var filter = this.getFacultyRequestClosureRateSearchForm();
				this.searchButtonEnablDisableOfNoMandatoryFieldForm(academyLocationIds, filter);
			} else if(Ext.isDefined(this.getFacultyCountOfRequestSearchForm())) {
				var filter = this.getFacultyCountOfRequestSearchForm();
				this.searchButtonEnablDisableOfNoMandatoryFieldForm(academyLocationIds, filter);
			} else if(Ext.isDefined(this.getFacultyServiceLevelSearch())) {
				var filter = this.getFacultyServiceLevelSearch();
				this.searchButtonEnablDisableOfNoMandatoryFieldForm(academyLocationIds, filter);
			} else if(Ext.isDefined(this.getFacultyClosureReasonSearch())) {
				var filter = this.getFacultyClosureReasonSearch();
				this.searchButtonEnablDisableOfNoMandatoryFieldForm(academyLocationIds, filter);
			} 
	},
	searchButtonEnablDisableOfNoMandatoryFieldForm : function (academyLocationIds, filter) {
		 if (!isNullOrEmpty(academyLocationIds) && academyLocationIds.length > 0 && !isNullOrEmpty(academyLocationIds[0])){
			    searchBtn = filter.down('#searchButtonId');
				searchBtn.setDisabled(false);
		 } else {
			 searchBtn = filter.down('#searchButtonId');
			 searchBtn.setDisabled(true);
		 }
	},
	getOrganizationUnitAcademyLocationObject : function(){
		var $this = this;
		var form = $this.getOrganizationunit();
		var alCombo = form.down('#multiselectAcademyLocationId');
		var academyLocationIds = alCombo.getValue();
		return academyLocationIds
	}
    
});
