/**
 * This controller is used for Person Detail Report controller
 * @author Trupti.Paoneker
 */
Ext.define('Academia.controller.reports.student.StudentReportController', {
    extend:'Academia.controller.personinfo.common.PersonCommonController',
    alias: "widget.studentreportcontroller",
    stores: ['common.ProgramByAcAndLoIdStore', 'admission.applications.admissionAndMidTermAdmission.MidTermAdmMainCourseGridStore', 
             'program.programbatchdetail.BatchStore', 'organization.academylocations.AcademyStore', 
             'organization.academylocations.LocationStore', 'personinfo.common.services.KYSStatusStore','common.ProgramByAcademyLocationStore',
             'common.SiblingNameComboStore','common.picklist.SelectEmployeeNameComboStore','common.AcademyLocationByAcademyId',
             'coursetransaction.sectionmanagement.SectionMultiSelect','common.SelectNameComboStore','othermasters.communitymaster.CommunityComboStore',
             'enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'
             ,'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameAdmissionCodeBySmartSearch','program.ProgramByGroupIdStore','attendance.SectionAndFacultyByPeriodID'
             ,'feeandpayment.managebill.Student','reports.student.SiblingExportReportTypeStore'],

    views: ['common.NestedJsonCombo','criteriabuilder.grid.SearchResultGrid','reports.student.personaldetail.KysReportView',
            'reports.student.personaldetail.KysReportQuickSearchView', 
            'reports.student.personaldetail.KysReportQuickSearchForm', 'reports.student.personaldetail.ChildrenOfEmployeeReportView', 
            'reports.student.personaldetail.ChildrenOfEmployeeReportQuickSearchView', 'reports.student.personaldetail.ChildrenOfEmployeeQuickSearchForm', 
            'reports.student.personaldetail.SiblingsReportView', 'reports.student.personaldetail.SiblingsReportQuickSearchForm', 
            'reports.student.personaldetail.SiblingsReportQuickSearchView', 'reports.student.StudentCommunityReportQuickSearchForm', 
            'reports.student.StudentCommunityReportQuickSearchView', 'reports.student.StudentCommunityReportView', 
            'reports.student.personaldetail.ExtraCurrActivityReportView', 'reports.student.personaldetail.ExtraCurrActivityReportQuickSearchView', 
            'reports.student.personaldetail.ExtraCurrActivityReportQuickSearchForm','reports.student.personaldetail.SiblingsReportExportWindow'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'kysReportQuickSearch',
        selector: 'kysreportquicksearchform'
    }, {
        ref: 'kysReportResultGrid',
        selector: 'searchresultgrid[itemId=kysReportResultGrid]'
    }, {
        ref: 'kysreportview',
        selector: 'kysreportview'
    }, {
        ref: 'childrenOfEmployeeQuickSearch',
        selector: 'childrenofemployeequicksearchform'
    }, {
        ref: 'childrenOfEmployeeReportResultGrid',
        selector: 'searchresultgrid[itemId=childrenOfEmployeeReportResultGrid]'
    }, {
        ref: 'childrenofemployeereportview',
        selector: 'childrenofemployeereportview'
    }, {
        ref: 'siblingsReportQuickSearch',
        selector: 'siblingsreportquicksearchform'
    }, {
        ref: 'siblingsReportResultGrid',
        selector: 'searchresultgrid[itemId=siblingsReportResultGrid]'
    }, {
        ref: 'siblingsreportview',
        selector: 'siblingsreportview'
    }, {
        ref: 'studentCommunityReportQuickSearch',
        selector: 'studentcommunityreportquicksearchform'
    }, {
        ref: 'studentCommunityReportResultGrid',
        selector: 'searchresultgrid[itemId=studentCommunityReportResultGrid]'
    }, {
        ref: 'studentCommunityReportView',
        selector: 'studentcommunityreportview'
    }, {
        ref: 'extraCurrActivityReportQuickSearch',
        selector: 'extracurractivityreportquicksearchform'
    }, {
        ref: 'extraCurrActivityReportResultGrid',
        selector: 'searchresultgrid[itemId=extraCurrActivityReportResultGrid]'
    }, {
        ref: 'extraCurrActivityReportView',
        selector: 'extracurractivityreportview'
    }, {
        ref: 'siblingsreportexportwindow',
        selector: 'siblingsreportexportwindow'
    }],

    config: {
    	STUDENT_KYSREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_KYSREPORT_PRIVILEGES'),
    	STUDENT_EXTRACURRICULUMREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EXTRACURRICULUMREPORT_PRIVILEGES'),
    	STUDENT_SIBLINGREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SIBLINGREPORT_PRIVILEGES'),
    	STUDENT_EMPLOYEECHILDREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EMPLOYEECHILDREPORT_PRIVILEGES'),
    	STUDENT_COMMUNITYREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COMMUNITYREPORT_PRIVILEGES')
    },
    
    init: function(application) {
        this.control({
        
        	/**
        	 * KYS Report Event
        	 */
        	'kysreportquicksearchform[itemId=kysReportQuickSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadStudentKysReportData();
                }
            },
            'kysreportquicksearchform[itemId=kysReportQuickSearchForm] button#clearSearchBtn':{
            	click: function(button){
            		this.clearSearchForm(button);
            	}
            },
            'kysreportquicksearchform[itemId=kysReportQuickSearchForm] combo[itemId=selectedNameField]': {
                change: this.changeNameFieldConfig

            },
            'kysreportquicksearchform[itemId=kysReportQuickSearchForm] combo[itemId=program]': {
            	render: function(combo) {
                    var academyLocationId = this.getCurrentAcademyLocation();
                    combo.getStore().proxy.extraParams = {
                            academyLocationId: academyLocationId
                    };
                },
            	select: function(programCombo) {
                    var basicSearchForm = this.getKysReportQuickSearch();
                    var batchCombo = basicSearchForm.down('#batch');
                    this.loadDependentCombo(basicSearchForm, batchCombo, programCombo.getValue(), 'id');
                }
            },
            'kysreportquicksearchform[itemId=kysReportQuickSearchForm] combo[itemId=batch]': {
                select: function(batchCombo) {
                	var basicSearchForm = this.getKysReportQuickSearch();
                    var courseCombo = basicSearchForm.down('#course');
                    this.loadDependentCombo(basicSearchForm, courseCombo, batchCombo.getValue(), 'batchId');
                }
            },
            'kysreportquicksearchform[itemId=kysReportQuickSearchForm] combo[itemId=course]': {
                select: function(courseCombo) {
                	var basicSearchForm = this.getKysReportQuickSearch();
                    var sectionCombo = basicSearchForm.down('#section');
                    this.loadDependentCombo(basicSearchForm, sectionCombo, courseCombo.getValue(), 'courseId');
                }
            },

            /**
        	 * Employee Child Report Event
        	 */
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadStudentEmployeeChildReportData();
                }
            },
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] combo[itemId=selectedNameField]': {
            	change: this.changeNameFieldConfig

            },
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] combo[itemId=selectedEmployeeNameField]': {
            	change: this.changeNameFieldEmployeeConfig

            },
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] combo[itemId=program]': {
            	render: function(combo) {
                    var academyLocationId = this.getCurrentAcademyLocation();
                    combo.getStore().proxy.extraParams = {
                            academyLocationId: academyLocationId
                    };
                },
            	select: function(programCombo) {
            		var basicSearchForm = this.getChildrenOfEmployeeQuickSearch();
                    var batchCombo = basicSearchForm.down('#batch');
                    this.loadDependentCombo(basicSearchForm, batchCombo, programCombo.getValue(), 'id');
                }
            },
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] combo[itemId=batch]': {
                select: function(batchCombo) {
                	var basicSearchForm = this.getChildrenOfEmployeeQuickSearch();
                    var courseCombo = basicSearchForm.down('#course');
                    this.loadDependentCombo(basicSearchForm, courseCombo, batchCombo.getValue(), 'batchId');
                }
            },
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] combo[itemId=course]': {
                select: function(courseCombo) {
                	var basicSearchForm = this.getChildrenOfEmployeeQuickSearch();
                    var sectionCombo = basicSearchForm.down('#section');
                    this.loadDependentCombo(basicSearchForm, sectionCombo, courseCombo.getValue(), 'courseId');
                }
            },
            
            'childrenofemployeequicksearchform[itemId=childrenOfEmployeeQuickSearchForm] button#clearSearchBtn':{
            	click: function(button){
            		this.clearSearchForm(button);
            	}
            },
            
            /**
             * Sibling Report
             */
            'siblingsreportquicksearchform':{
            	render : function(obj) {
            		var $this = this;
            		setTimeout(function(){
 		     			Ext.suspendLayouts();
 		     			$this.loadStudentSiblingReportData();
 		     	        Ext.resumeLayouts();
 	     			},100);
            		
            	}
            },
            
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadStudentSiblingReportData();
                }
            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] button[itemId=clearSearchBtn]':{
            	click: function(button){
            		this.clearSearchFormForSiblingsReport(button);
            	}
            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] combo[itemId=selectedNameField]': {
            	change: this.changeNameFieldConfig

            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] combo[itemId=selectedSiblingNameField]': {
            	change:this.changeNameFieldSiblingConfig
            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] combo[itemId=academyLocationId]': {
            	afterrender: function(combo) {
            		var $this = this;
            		var academyLocationId = $this.getCurrentAcademyLocation();
            		setTimeout(function(){
            		combo.getStore().load({
                    	callback: function(records, operation, success) {
            				for(var i in records){
            					if(records[i].data.id==academyLocationId) {
            						combo.setValue(records[i].data.id);
            					}
            				}
                    	}
            		});
            		},150);
                },
                change: function(obj) {
                	var $this = this;
                	var form = obj.up('form');
               	 	var formValues = form.getValues();
               	 	var programCombo = form.down('#program');
               	 	var batchCombo = form.down('#batch');
               	 	var periodCombo = form.down('#period');
               	 	var sectionCombo = form.down('#section');
               	 	var academyLocationId = $this.getCurrentAcademyLocation();
               	 
	               	var academyLocationData=[];
	   		        if(formValues.ACADEMY_LOCATION_ID !="" && formValues.ACADEMY_LOCATION_ID !=null){
	   		        	for(var i in formValues.ACADEMY_LOCATION_ID){
	   		        		if(Ext.isObject(formValues.ACADEMY_LOCATION_ID[i])&& !isNullOrEmpty(formValues.ACADEMY_LOCATION_ID[i])){
	   		        			al = formValues.ACADEMY_LOCATION_ID[i];
	   		        			academyLocationData.push(al.data.id);
	   		        		}else{
	   		        			if(!isNullOrEmpty(formValues.ACADEMY_LOCATION_ID[i])){
	   		        				al = formValues.ACADEMY_LOCATION_ID[i];
	   		        				academyLocationData.push(al);
	   		        			}
	   		        		}
	   		        	}
	   		    	}	
	   		        programCombo.reset();
            	 	batchCombo.reset();
            	 	periodCombo.reset();
            	 	sectionCombo.reset();
            	 	batchCombo.setDisabled(true);
            	 	periodCombo.setDisabled(true);
            	 	sectionCombo.setDisabled(true);
            	 	
            	 	var programStore = programCombo.getStore();
            	 	if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
	               		programStore.getProxy().extraParams = {
	               		    academyLocationIds: academyLocationData.join()
	               		};
	               		programStore.load();
            	 	}
            	 	else{
            	 		programStore.getProxy().extraParams = {
            	 			academyLocationId: academyLocationId
            	 		};
            	 		programStore.load();
            	 	}
                }
            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] combo[itemId=program]': {
            	render: function(combo) {
                    var academyLocationId = this.getCurrentAcademyLocation();
                    combo.getStore().proxy.extraParams = {
                            academyLocationId: academyLocationId
                    };
                    var basicSearchForm = this.getSiblingsReportQuickSearch();
            		
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		if(wheatherSchool){
            		 var period = basicSearchForm.down('#period');
            		 period.setVisible(false);
            		}
                },
            	select: function(programCombo) {
            		var basicSearchForm = this.getSiblingsReportQuickSearch();
                    var batchCombo = basicSearchForm.down('#batch');
                    batchCombo.setDisabled(false);
                    var periodCombo = basicSearchForm.down('#period');
                    periodCombo.setDisabled(true);
                    var sectionCombo = basicSearchForm.down('#section');
                    sectionCombo.setDisabled(true);
                    this.loadDependentComboForSiblingsReport(basicSearchForm, batchCombo, programCombo.getValue(), 'id');
                }
            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] combo[itemId=batch]': {
                select: function(batchCombo) {
                	var basicSearchForm = this.getSiblingsReportQuickSearch();
                    var periodCombo = basicSearchForm.down('#period');
                    periodCombo.setDisabled(false);
                    var sectionCombo = basicSearchForm.down('#section');
                    sectionCombo.setDisabled(true);
                    var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		if(wheatherSchool){
            			var sectionCombo = basicSearchForm.down('#section');
            			sectionCombo.setDisabled(false);
            		}
                    this.loadDependentComboForSiblingsReport(basicSearchForm, periodCombo, batchCombo.getValue(), 'id');
                }
            },
            'siblingsreportquicksearchform[itemId=siblingsReportQuickSearchForm] combo[itemId=period]': {
                select: function(periodCombo) {
                	var basicSearchForm = this.getSiblingsReportQuickSearch();
                    var sectionCombo = basicSearchForm.down('#section');
                    sectionCombo.setDisabled(false);
                    this.loadDependentComboForSiblingsReport(basicSearchForm, sectionCombo, periodCombo.getValue(), 'periodId');
                }
            },
            'searchresultgrid[itemId=siblingsReportResultGrid] button[itemId=exportReportsId]': {
   			 /*click: function(btn) {
   				this.exportXlsStudentSiblingsDetailedReport();
   			 }*/
            click: function(obj) {
          		   this.openSiblingsDetailExportWin();
   			 }
   		 	},
            
            /**
             *  Community Report
             */
   		 	'searchresultgrid[itemId=studentCommunityReportResultGrid] button[itemId=exportReportsId]': {
			 click: function(btn) {
				this.exportXlsStudentCommunityReport();
			 }
		 	},
            
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadStudentCommunityReportData();
                }
            },
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] button[itemId=clearSearchBtn]':{
            	click: function(button){
            		this.clearSearchFormCommunityReport(button);
            	}
            },
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] checkboxfield[itemId=studentsWithOutCommunity]': {
            	change: function(obj) {
            		var this$ = this;
            		var form = obj.up('form');
            		var optInOptOutRadio = form.down('#optInOptOutRadioItemId');
            		var joiningDateFrom = form.down('#DATE_OF_JOINING_FROM');
            		var joiningDateTo = form.down('#DATE_OF_JOINING_TO');
            		var exitDateFrom = form.down('#EXIT_DATE_FROM');
            		var exitDateTo = form.down('#EXIT_DATE_TO');
            		if(!isNullOrEmpty(obj.getValue()) && obj.getValue()==true) {
            			
            			if(optInOptOutRadio.getValue().optInOptOut=="OPT_IN"){
            				joiningDateFrom.reset();
                			joiningDateTo.reset();
                			joiningDateFrom.setMinValue(null);
                			joiningDateFrom.setMaxValue(null);
                			joiningDateTo.setMinValue(null);
                			joiningDateTo.setMaxValue(null);
            				exitDateFrom.setDisabled(true);
                			exitDateTo.setDisabled(true);
                			joiningDateFrom.setDisabled(true);
                			joiningDateTo.setDisabled(true);
                			optInOptOutRadio.setDisabled(true);
        				}
            			else if(optInOptOutRadio.getValue().optInOptOut=="OPT_OUT") {
            				exitDateFrom.setDisabled(true);
                			exitDateTo.setDisabled(true);
                			joiningDateFrom.setDisabled(true);
                			joiningDateTo.setDisabled(true);
                			optInOptOutRadio.setDisabled(true);
                			optInOptOutRadio.setValue({optInOptOut:"OPT_IN"});
            			}
            			else {}
            		}
            		else {
            			exitDateFrom.setDisabled(false);
            			exitDateTo.setDisabled(false);
            			joiningDateFrom.setDisabled(false);
            			joiningDateTo.setDisabled(false);
            			optInOptOutRadio.setDisabled(false);
            		}
            	}
            },
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] radiogroup[itemId=optInOptOutRadioItemId]': {
            	change: function(obj) {
            		var this$ = this;
            		var form = obj.up('form');
            		var joiningDateFrom = form.down('#DATE_OF_JOINING_FROM');
            		var joiningDateTo = form.down('#DATE_OF_JOINING_TO');
            		var exitDateFrom = form.down('#EXIT_DATE_FROM');
            		var exitDateTo = form.down('#EXIT_DATE_TO');
            		if(obj.getValue().optInOptOut=="OPT_IN") {
            			exitDateFrom.setVisible(false);
            			exitDateTo.setVisible(false);
            			joiningDateFrom.setVisible(true);
            			joiningDateTo.setVisible(true);
            			exitDateFrom.reset();
            			exitDateTo.reset();
            			exitDateFrom.setMinValue(null);
            			exitDateFrom.setMaxValue(null);
            			exitDateTo.setMinValue(null);
            			exitDateTo.setMaxValue(null);
            		}
            		else if(obj.getValue().optInOptOut=="OPT_OUT") {
            			joiningDateFrom.setVisible(false);
            			joiningDateTo.setVisible(false);
            			exitDateFrom.setVisible(true);
            			exitDateTo.setVisible(true);
            			joiningDateFrom.reset();
            			joiningDateTo.reset();
            			joiningDateFrom.setMinValue(null);
            			joiningDateFrom.setMaxValue(null);
            			joiningDateTo.setMinValue(null);
            			joiningDateTo.setMaxValue(null);
            		}
            		else {}
            	}
            },
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] combo[itemId=program]': {
            	render: function(combo) {
                    var academyLocationId = this.getCurrentAcademyLocation();
                    var form = combo.up('form');
                    combo.getStore().proxy.extraParams = {
                            academyLocationId: academyLocationId,
                            isCommunityReportScreen :true
                    };
                },
            	select : function(obj, record) {
					var academyLocationIds = this.getCurrentAcademyLocation();
					var form = obj.up('form');
					var program = form.down("#program");
					var batchId = form.down('#batch');
					var period = form.down('#periodId');
					var section = form.down('#section');
					var academicTerm = form.down('#academicTerm');
					var admissionItemId = form.down('#admissionItemId');
					batchId.reset();
					period.reset();
					section.reset();
					batchId.setDisabled(true);
					period.setDisabled(true);
					section.setDisabled(true);
					batchId.setReadOnly(false);
					period.setReadOnly(false);
					section.setReadOnly(false);
					var programId = record[0].get("id");
					var batchIdStore = batchId.getStore();
					batchId.setDisabled(false);
					batchIdStore.getProxy().extraParams = {
						id: programId,
                        isCommunityReportScreen :true,
                        academicTermId:academicTerm.getValue(),
                        admissionId:admissionItemId.getValue()
					};
					batchIdStore.load({
						callback: function(records, operation, success) {
							if(records.length==1){
								batchId.setValue(records[0].get('id'));
								batchId.setDisabled(false);
								batchId.setReadOnly(true);
								var batchIdVal = records[0].get('id');
								if(batchIdVal > 0){	  
									var periodStore = period.getStore();
									period.setDisabled(false);
									periodStore.getProxy().extraParams = {
										id: batchIdVal,
				                        isCommunityReportScreen :true,
				                        academicTermId:academicTerm.getValue(),
				                        admissionId:admissionItemId.getValue()
									};
									periodStore.load({
										callback: function(records, operation, success) {
											if(records.length==1){
												period.setValue(records[0].get('id'));
												period.setDisabled(false);
												period.setReadOnly(true);
												var periodIdVal = records[0].get('id');
												if(periodIdVal> 0){	  
													var sectionStore = section.getStore();
													section.setDisabled(false);
													sectionStore.getProxy().extraParams = {
														batchIds: batchIdVal,
								                        isCommunityReportScreen :true,
								                        academicTermId:academicTerm.getValue(),
								                        admissionId:admissionItemId.getValue()
													};
													sectionStore.load({
														callback: function(records, operation, success) {
															if(records.length==1){
																section.setValue(records[0].get('id'));
																section.setDisabled(false);
																section.setReadOnly(true);
															}
														}
													});
												}
											}else{
												var sectionStore = section.getStore();
												section.setDisabled(false);
												sectionStore.getProxy().extraParams = {
													batchIds: batchIdVal,
							                        isCommunityReportScreen :true,
							                        academicTermId:academicTerm.getValue(),
							                        admissionId:admissionItemId.getValue()
												};
												sectionStore.load({
													callback: function(records, operation, success) {
														if(records.length==1){
															section.setValue(records[0].get('id'));
															section.setDisabled(false);
															section.setReadOnly(true);
														}
													}
												});
											
											}
										}
									});
								}
							}
						}
					});
				}
            },
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] combo[itemId=batch]': {
            	select : function(obj, record) {
				var academyLocationIds = this.getCurrentAcademyLocation();
				var form = obj.up('form');
				var program = form.down('#program');
				var batchId = form.down('#batch');
				var periodId = form.down('#periodId');
				var section = form.down('#section');
				var academicTerm = form.down('#academicTerm');
				var admissionItemId = form.down('#admissionItemId');
				periodId.reset();
				periodId.setReadOnly(false);
				section.reset();
				section.setReadOnly(false);
				var batchIdVal = record[0].get('id');
				if(batchIdVal > 0){	  
					var periodIdStore = periodId.getStore();
					periodId.setDisabled(false);
					periodIdStore.getProxy().extraParams = {
						id: batchIdVal,
                        isCommunityReportScreen :true,
                        academicTermId:academicTerm.getValue(),
                        admissionId:admissionItemId.getValue()
					};
					periodIdStore.load({
						callback: function(records, operation, success) {
							if(records.length==1){
								periodId.setValue(records[0].get('id'));
								periodId.setDisabled(false);
								periodId.setReadOnly(true);
								var periodIdVal = records[0].get('id');
								if(periodIdVal> 0){	  
									var sectionStore = section.getStore();
									section.setDisabled(false);
									sectionStore.getProxy().extraParams = {
										batchIds: batchIdVal,
				                        isCommunityReportScreen :true,
				                        academicTermId:academicTerm.getValue(),
				                        admissionId:admissionItemId.getValue()
									};
									sectionStore.load({
										callback: function(records, operation, success) {
											if(records.length==1){
												section.setValue(records[0].get('id'));
												section.setDisabled(false);
												section.setReadOnly(true);
											}
										}
									});
								}
							}else{
								var sectionStore = section.getStore();
								section.setDisabled(false);
								sectionStore.getProxy().extraParams = {
									batchIds: batchIdVal,
			                        isCommunityReportScreen :true,
			                        academicTermId:academicTerm.getValue(),
			                        admissionId:admissionItemId.getValue()
								};
								sectionStore.load({
									callback: function(records, operation, success) {
										if(records.length==1){
											section.setValue(records[0].get('id'));
											section.setDisabled(false);
											section.setReadOnly(true);
										}
									}
								});
							
							}
						}
					});
				}
			}
            },
            'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] combo[itemId=periodId]': {
            	select : function(obj, record) {
    				var academyLocationIds = this.getCurrentAcademyLocation();
    				var form = obj.up('form');
    				var section = form.down('#section');
    				var academicTerm = form.down('#academicTerm');
    				var admissionItemId = form.down('#admissionItemId');
    				var batchId = form.down('#batch');
    				section.reset();
    				section.setReadOnly(false);
    				var periodIdVal = record[0].get('id');
    				if(periodIdVal > 0){	  
    					var sectionIdStore = section.getStore();
    					section.setDisabled(false);
    					sectionIdStore.getProxy().extraParams = {
    						batchIds: batchId.getValue(),
	                        isCommunityReportScreen :true,
	                        academicTermId:academicTerm.getValue(),
	                        admissionId:admissionItemId.getValue()
    					};
    					sectionIdStore.load({
							callback: function(records, operation, success) {
								if(records.length==1){
									section.setValue(records[0].get('id'));
									section.setDisabled(false);
									section.setReadOnly(true);
								}
							}
						});
    				}
    			}
            },
            
            /**
        	 * Extra Curricular Activity Report Event
        	 */
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm]':{
            	afterrender: function(form){
            		var $this=this;
            		/**
            		 * Set default value of student in case of portal id 3 or student login   
            		 */
            		if($this.getCurrentLoggedPortalId() == 3 || $this.getCurrentLoggedPortalId() == 7){
            		   var getForm=form.getForm();
            		   getForm.findField('selectedNameField').setReadOnly(true); 
            		   var STUDENT_CODEField=getForm.findField('STUDENT_CODE'); 
            		   STUDENT_CODEField.setValue($this.getCurrentlyLoggedInUser().code);
            		   STUDENT_CODEField.setReadOnly(true);
            		   var FIRST_NAMEField=getForm.findField('FIRST_NAME'); 
            		   FIRST_NAMEField.setValue($this.getCurrentlyLoggedInUser().value);
            		   FIRST_NAMEField.setReadOnly(true);
            	    }
            	}
            },
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm] button[itemId=clearSearchBtn]':{
            	click: function(button){
            		//this.clearSearchForm(button);
            		this.clearSearchFormExtraCurricularReprot(button);
            	}
            },
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadStudentExtraCurricularReportData();
                }
            },
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm] combo[itemId=selectedNameField]': {
            	change: this.changeNameFieldConfig

            },
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm] combo[itemId=program]': {
            	render: function(combo) {
                    var academyLocationId = this.getCurrentAcademyLocation();
                    combo.getStore().proxy.extraParams = {
                            academyLocationId: academyLocationId
                    };
                },
            	select: function(programCombo) {
            		var basicSearchForm = this.getExtraCurrActivityReportQuickSearch();
                    var batchCombo = basicSearchForm.down('#batch');
                    batchCombo.setDisabled(false);
                    
                    var periodCombo = basicSearchForm.down('#period');
                    periodCombo.setDisabled(true);
                    periodCombo.reset();
                    
                    var sectionCombo = basicSearchForm.down('#section');
                    sectionCombo.setDisabled(true);
                    sectionCombo.reset();
                    this.loadDependentCombo(basicSearchForm, batchCombo, programCombo.getValue(), 'id');
                }
            },
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm] combo[itemId=batch]': {
                select: function(batchCombo) {
                	var basicSearchForm = this.getExtraCurrActivityReportQuickSearch();
                    var periodCombo = basicSearchForm.down('#period');
                    periodCombo.setDisabled(false);
                    
                    var sectionCombo = basicSearchForm.down('#section');
                    sectionCombo.setDisabled(true);
                    sectionCombo.reset();
                    
                    this.loadDependentCombo(basicSearchForm, periodCombo, batchCombo.getValue(), 'id');
                }
            },
            'extracurractivityreportquicksearchform[itemId=extraCurrActivityReportQuickSearchForm] combo[itemId=period]': {
                select: function(courseCombo) {
                	var basicSearchForm = this.getExtraCurrActivityReportQuickSearch();
                    var sectionCombo = basicSearchForm.down('#section');
                    sectionCombo.setDisabled(false);
                    this.loadDependentCombo(basicSearchForm, sectionCombo, courseCombo.getValue(), 'periodId');
                }
            },
            
            
            /**
             * Add toolbar button
             */
            
            'searchresultgrid[itemId=kysReportResultGrid]':{
            	render: function(grid) {
            		this.gridRenderFunction(grid);
            	},
            
            },
            'searchresultgrid[itemId=childrenOfEmployeeReportResultGrid]': {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=siblingsReportResultGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=studentCommunityReportResultGrid]' : {
            	cellclick: this.cellClickCommunityResultGrid,
            	render: function(grid) {
            		$this = this;
            		$this.gridRenderFunction(grid);
 					setTimeout(function(){
 		     			var form = $this.getStudentCommunityReportQuickSearch();
 		     			var academicTerm = form.down('#academicTerm');
 		     		    var academyLocationId = $this.getCurrentAcademyLocation();
 		     		    academicTerm.getStore().proxy.extraParams = {
 	                    	academyLocationId: academyLocationId
 	                    };
 		     		    academicTerm.getStore().load({
 	                    	callback: function(records, operation, success) {
 	                    		for(var i in records){
 	                    			if(records[i].data.whetherCurrentAcademicTerm==true){
 	                    				academicTerm.setValue(records[i].data.id);
 	                    				break;
 	                    			}
 	   						 	}
 	                    		Ext.suspendLayouts();
 	                    		$this.loadStudentCommunityReportData();
 	                    		Ext.resumeLayouts();
 	                    	}
 	                    });
 	     			},500);
 				}
            },
            'searchresultgrid[itemId=extraCurrActivityReportResultGrid]' : {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            /**
             * Access permission
             */
            'kysreportquicksearchview grid[itemId=kysReportResultGrid]': {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_KYSREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}	
            },
            'childrenofemployeereportquicksearchview grid[itemId=childrenOfEmployeeReportResultGrid]': {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_EMPLOYEECHILDREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}	
            },
            'siblingsreportquicksearchview searchresultgrid[itemId=siblingsReportResultGrid]': {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_SIBLINGREPORT_PERMISSIONS());
 					this.disableSiblingExportLinkActionPivileges(grid, this.getSTUDENT_SIBLINGREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
            },
            'studentcommunityreportquicksearchview grid[itemId=studentCommunityReportResultGrid]': {
            	afterrender : function(grid){
            		var me = this;
            		console.log('perm...',this.getSTUDENT_COMMUNITYREPORT_PERMISSIONS());
 					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_COMMUNITYREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 					me.addDataGridConfigButton(grid,me.getSTUDENT_COMMUNITYREPORT_PERMISSIONS());
 				}
            },
            'studentcommunityreportquicksearchview':{
				afterrender : function(structure){
					var $this = this;
					structure.body.on('scroll', function(e, target) {
						 var grid = structure.down('searchresultgrid');
						 //this.getCBGridHeaderFreeze(grid,structure);
						 $this.getMultipleCBGridHeaderFreezeMultipleStructure(grid,structure, true);
					 });
					
				}
     		},
            'extracurractivityreportquicksearchview grid[itemId=extraCurrActivityReportResultGrid]' : {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_EXTRACURRICULUMREPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
            },
            
            /**
             * Export button for KYS
             */
            'searchresultgrid[itemId=kysReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'KYSREPORT');
	            }
	        },
	        'searchresultgrid[itemId=kysReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'KYSREPORT');
	            }
	        },
	        'searchresultgrid[itemId=kysReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'KYSREPORT');
	            }
	        },
	        'searchresultgrid[itemId=kysReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'KYSREPORT');
	            }
	        },
	        /**
	         *  Export button for children Of Employee 
	         */
	        'searchresultgrid[itemId=childrenOfEmployeeReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'CHILDRENEMPLOYEE');
	            }
	        },
	        'searchresultgrid[itemId=childrenOfEmployeeReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'CHILDRENEMPLOYEE');
	            }
	        },
	        'searchresultgrid[itemId=childrenOfEmployeeReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'CHILDRENEMPLOYEE');
	            }
	        },
	        'searchresultgrid[itemId=childrenOfEmployeeReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'CHILDRENEMPLOYEE');
	            }
	        },
	        /**
	         * Export button for siblings
	         **/
	        'searchresultgrid[itemId=siblingsReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'SIBLINGREPORT');
	            }
	        },
	        'searchresultgrid[itemId=siblingsReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'SIBLINGREPORT');
	            }
	        },
	        'searchresultgrid[itemId=siblingsReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'SIBLINGREPORT');
	            }
	        },
	        'searchresultgrid[itemId=siblingsReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'SIBLINGREPORT');
	            }
	        },
	        /**
	         * Export button for Community
	         */
	        'searchresultgrid[itemId=studentCommunityReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'COMMUNITYREPORT');
	            }
	        },
	        'searchresultgrid[itemId=studentCommunityReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'COMMUNITYREPORT');
	            }
	        },
	        'searchresultgrid[itemId=studentCommunityReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'COMMUNITYREPORT');
	            }
	        },
	        'searchresultgrid[itemId=studentCommunityReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'COMMUNITYREPORT');
	            }
	        },
	        /**
	         * Export button for extraCurrActivity
	         */
	        'searchresultgrid[itemId=extraCurrActivityReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'EXTRACURRREPORT');
	            }
	        },
	        'searchresultgrid[itemId=extraCurrActivityReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'EXTRACURRREPORT');
	            }
	        },
	        'searchresultgrid[itemId=extraCurrActivityReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'EXTRACURRREPORT');
	            }
	        },
	        'searchresultgrid[itemId=extraCurrActivityReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'EXTRACURRREPORT');
	            }
	        },
 		   'extracurractivityreportview': {
 			   render:function(extracurractivityreportview){
 				   this.enableTabforExtraCurrPanel(extracurractivityreportview);
 			   },
 			   afterrender:function(structure){
 				   
 				  var grid = structure.down('searchresultgrid');
   				 this.getGridHeaderFreezeNoPage(grid,structure,true);
 			  }
 		   },
 		  'kysreportview': {
			   render:function(kysreportview){
				   this.enableTabforkysPanel(kysreportview);
			   },
			   afterrender:function(structure){
				   
				  var grid = structure.down('searchresultgrid');
  				 this.getGridHeaderFreezeNoPage(grid,structure,true);
			  }
		   },
		   
		   'siblingsreportview':{
			   render:function(siblingsreportview){
				   this.enableTabforSiblingsReportPanel(siblingsreportview);
			   },
		   afterrender:function(structure)
		   {
			   var grid=structure.down('searchresultgrid');
			   this.getGridHeaderFreezeNoPage(grid,structure,true);
		   }
		   },
		   'childrenofemployeereportview':{
			   render:function(childrenofemployeereportview){
				   this.enableTabforchildrenofemployeereportPanel(childrenofemployeereportview);
			   },
			   afterrender:function(structure)
			   {
				   var grid=structure.down('searchresultgrid');
				   this.getGridHeaderFreezeNoPage(grid,structure,true);
			   }
		   },
		   'studentcommunityreportquicksearchform':{
			   render:function(form){
				   var this$ = this;
				   var alinfomodel = Academia.model.authentication.ALInfoModel;
				   var whetherSchool = alinfomodel.get('wheatherSchool');
				   var period = form.down('#periodId');
				   if(whetherSchool){
					   period.setVisible(false);
				   }
			   }
		   },
           'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] combo[itemId=Program_Group]': {
           	render: function(combo) {
                   var academyLocationId = this.getCurrentAcademyLocation();
                   combo.getStore().proxy.extraParams = {
                           academyLocationId: academyLocationId
                   };
               },
               select: function(obj,record) {
            	   var form = obj.up('form');
            	   var programGroupId=record[0].getId();
            	   var academyLocationIds=this.getCurrentAcademyLocation();
            	   var program = form.down("#program");
				   var batchId = form.down('#batch');
				   var period = form.down('#periodId');
				   var section = form.down('#section');
				   var admissionItemId = form.down('#admissionItemId');
				   var academicTerm = form.down('#academicTerm');
				   program.reset();
				   batchId.reset();
				   period.reset();
				   section.reset();
				   batchId.setDisabled(true);
				   period.setDisabled(true);
				   section.setDisabled(true);
				   batchId.setReadOnly(false);
				   period.setReadOnly(false);
				   section.setReadOnly(false);
				   program.setReadOnly(false);
            	   var programStore = program.getStore();
            	   programStore.getProxy().extraParams ={
            		   academyLocationId:academyLocationIds,
            		   programGroupId:programGroupId,
                       isCommunityReportScreen :true,
                       academicTermId:academicTerm.getValue(),
                       admissionId:admissionItemId.getValue()
            	   };
            	   programStore.load({
  					 callback: function(records, operation, success) {
  						 if(records.length==1){
  							 program.setValue(records[0].get('id'));
  							 program.setReadOnly(true);											
  							 var programId = records[0].get("id");
  							 if(programId > 0){	    	        					  
  								 var batchIdStore = batchId.getStore();
  								 batchIdStore.getProxy().extraParams = {
  								   id: programId,
  			                       isCommunityReportScreen :true,
  			                       academicTermId:academicTerm.getValue(),
  			                       admissionId:admissionItemId.getValue()
  								 };
  								 batchIdStore.load({
  									 callback: function(records, operation, success) {
  										 if(records.length==1){
  											 batchId.setValue(records[0].get('id'));
  											 batchId.setDisabled(false);
  											 batchId.setReadOnly(true);
  											 var batchIdVal = records[0].get('id');
  											 if(batchIdVal > 0){	  
  												 var periodStore = period.getStore();
  												period.setDisabled(false);
  												periodStore.getProxy().extraParams = {
  												   id: batchIdVal,
  							                       isCommunityReportScreen :true,
  							                       academicTermId:academicTerm.getValue(),
  							                       admissionId:admissionItemId.getValue()
  												 };
  												periodStore.load({
  													 callback: function(records, operation, success) {
  														 if(records.length==1){
  															period.setValue(records[0].get('id'));
  															period.setDisabled(false);
  															period.setReadOnly(true);
  															var periodIdVal = records[0].get('id');
  															if(periodIdVal> 0){	  
  				  												var sectionStore = section.getStore();
  				  												section.setDisabled(false);
  				  											    sectionStore.getProxy().extraParams = {
  				  											    	batchIds: batchIdVal,
  				  							                         isCommunityReportScreen :true,
  				  						                             academicTermId:academicTerm.getValue(),
  				  						                             admissionId:admissionItemId.getValue()
  				  												 };
  				  											    sectionStore.load({
  				  													 callback: function(records, operation, success) {
  				  														 if(records.length==1){
  				  															section.setValue(records[0].get('id'));
  				  															section.setDisabled(false);
  				  															section.setReadOnly(true);
  				  														 }
  				  													 }
  				  												 });
  				  											 }
  														 }else{
				  												var sectionStore = section.getStore();
				  												section.setDisabled(false);
				  											    sectionStore.getProxy().extraParams = {
				  											    	batchIds: batchIdVal,
				  							                         isCommunityReportScreen :true,
				  						                             academicTermId:academicTerm.getValue(),
				  						                             admissionId:admissionItemId.getValue()
				  												 };
				  											    sectionStore.load({
				  													 callback: function(records, operation, success) {
				  														 if(records.length==1){
				  															section.setValue(records[0].get('id'));
				  															section.setDisabled(false);
				  															section.setReadOnly(true);
				  														 }
				  													 }
				  												 });
				  											 
  														 }
  													 }
  												 });
  											 }
  										 }
  									 }
  								 });
  							 }
  						 }	
  					 }
            	   });
               }
           },
           'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] customcombobox[itemId=academicTerm]': {
        	   render: function(combo) {
                   var academyLocationId = this.getCurrentAcademyLocation();
                   combo.getStore().proxy.extraParams = {
                           academyLocationId: academyLocationId
                   };
                   combo.getStore().load({
   					 callback: function(records, operation, success) {
   						 for(var i in records){
   							 if(records[i].data.whetherCurrentAcademicTerm==true){
   								 combo.setValue(records[i].data.id);
   							 }
   						 }
   					 }	   
   				  
                   });
               },
               change: function(combo,value){
            	   var form = combo.up('form');
            	   var programGroup = form.down("#Program_Group");
            	   var program = form.down("#program");
            	   var batchId = form.down('#batch');
            	   var period = form.down('#periodId');
            	   var section = form.down('#section');
            	   var ageGroup = form.down('#ageGroup');
            	   var community = form.down('#community');
            	   var admissionField = form.down('#admissionItemId');
            	   
            	   var academyLocationIds = this.getCurrentAcademyLocation();
            	   program.reset();
            	   batchId.reset();
            	   period.reset();
            	   section.reset();
            	   programGroup.reset();
            	   ageGroup.reset();
            	   community.reset();
            	   admissionField.reset();
            	   batchId.setDisabled(true);
            	   program.setReadOnly(false);
            	   period.setDisabled(true);
            	   section.setDisabled(true);
            	   batchId.setReadOnly(false);
            	   period.setReadOnly(false);
            	   section.setReadOnly(false);
            	   programGroup.setReadOnly(false);
            	   var academyLocationId = this.getCurrentAcademyLocation();
            	   
            	   var admissionFieldStore = admissionField.getStore();
            	   admissionFieldStore.getProxy().extraParams ={
            		   academyLocationId:academyLocationIds,
            		   isCommunityReportScreen :true,
            		   academicTermId:value
            	   };
            	   admissionFieldStore.load();
            	   
            	   var programGroupStore = programGroup.getStore();
            	   programGroupStore.getProxy().extraParams ={
            		   academyLocationId:academyLocationIds,
            		   isCommunityReportScreen :true,
            		   academicTermId:value
            	   };
            	   programGroupStore.load();
            	   
            	   var programStore = program.getStore();
            	   programStore.getProxy().extraParams ={
            		   academyLocationId:academyLocationIds,
            		   isCommunityReportScreen :true,
            		   academicTermId:value
            	   };
            	   programStore.load();
            	   
            	   var ageGroupStore = ageGroup.getStore();
            	   ageGroupStore.getProxy().extraParams ={
            		   academyLocationId:academyLocationIds,
            		   academicTermId:value
            	   };
            	   ageGroupStore.load();
            	   
            	   var communityStore = community.getStore();
            	   communityStore.getProxy().extraParams ={
            		   academyLocationId:academyLocationIds,
            		   academicTermId:value
            	   };
            	   communityStore.load();
               }
           },
           'studentcommunityreportquicksearchform[itemId=studentCommunityReportQuickSearchFrom] customcombobox[itemId=admissionItemId]': {
        	   render: function(combo) {
                   var academyLocationId = this.getCurrentAcademyLocation();
                   combo.getStore().proxy.extraParams = {
                           academyLocationId: academyLocationId,
                           isCommunityReportScreen:true
                   };
                   combo.getStore().load();
               },   
        	   select: function(obj,record) {
               	   var form = obj.up('form');
               	   var admissionId=record[0].getId();
               	   var academyLocationIds=this.getCurrentAcademyLocation();
               	   var programGroup = form.down("#Program_Group");
               	   var program = form.down("#program");
   				   var batchId = form.down('#batch');
   				   var period = form.down('#periodId');
   				   var section = form.down('#section');
   				  var academicTerm = form.down('#academicTerm');
   				  var admissionItemId = form.down('#admissionItemId');
   				   programGroup.reset();
   				   program.reset();
   				   batchId.reset();
   				   period.reset();
   				   section.reset();
   				   batchId.setDisabled(true);
   				   period.setDisabled(true);
   				   section.setDisabled(true);
   				   batchId.setReadOnly(false);
				   period.setReadOnly(false);
				   section.setReadOnly(false);
				   programGroup.setReadOnly(false);
				   program.setReadOnly(false);
               	   var programGroupStore = programGroup.getStore();
               	   programGroupStore.getProxy().extraParams ={
               		   academyLocationId:academyLocationIds,
               		   admissionId:admissionId,
	                   isCommunityReportScreen :true,
	                   academicTermId:academicTerm.getValue()
               	   };
               	   programGroupStore.load({
               		   callback: function(records, operation, success) {
               			   if(records.length==1){
               				   programGroup.setValue(records[0].get('id'));
               				   programGroup.setReadOnly(true);											

               				   var programGroupId = records[0].get("id");
               				   if(programGroupId > 0){	    	        					  
               					   var programStore = program.getStore();
               					   	   programStore.getProxy().extraParams = {
               					   	   admissionId: admissionId,
               						   academyLocationId:academyLocationIds,
               		                   isCommunityReportScreen :true,
               		                   academicTermId:academicTerm.getValue()
               					   };
               					   programStore.load({
               						   callback: function(records, operation, success) {
               							   if(records.length==1){
               								   program.setValue(records[0].get('id'));
               								   program.setReadOnly(true);											

               								   var programId = records[0].get("id");
               								   if(programId > 0){	    	        					  
               									   var batchIdStore = batchId.getStore();
               									   batchIdStore.getProxy().extraParams = {
               										   id: programId,
               										   admissionId: admissionId,
               						                   isCommunityReportScreen :true,
               						                   academicTermId:academicTerm.getValue()
               									   };
               									   batchIdStore.load({
               										   callback: function(records, operation, success) {
               											   if(records.length==1){
               												   batchId.setValue(records[0].get('id'));
               												   batchId.setDisabled(false);
               												   batchId.setReadOnly(true);
               												   var batchIdVal = records[0].get('id');
               												   if(batchIdVal > 0){	  
               													   var periodStore = period.getStore();
               													   period.setDisabled(false);
               													   periodStore.getProxy().extraParams = {
               														   id: batchIdVal,
               	               										   admissionId: admissionId,
               	               						                   isCommunityReportScreen :true,
               	               						                   academicTermId:academicTerm.getValue()
               													   };
               													   periodStore.load({
               														   callback: function(records, operation, success) {
               															   if(records.length==1){
               																   period.setValue(records[0].get('id'));
               																   period.setDisabled(false);
               																   period.setReadOnly(true);
               																   var periodIdVal = records[0].get('id');
               																   if(periodIdVal> 0){	  
               																	   var sectionStore = section.getStore();
               																	   section.setDisabled(false);
               																	   sectionStore.getProxy().extraParams = {
               																		   batchIds: batchIdVal,
               					               										   admissionId: admissionId,
               					               						                   isCommunityReportScreen :true,
               					               						                   academicTermId:academicTerm.getValue()
               																	   };
               																	   sectionStore.load({
               																		   callback: function(records, operation, success) {
               																			   if(records.length==1){
               																				   section.setValue(records[0].get('id'));
               																				   section.setDisabled(false);
               																				   section.setReadOnly(true);
               																			   }
               																		   }
               																	   });
               																   }
               															   }
               														   }
               													   });
               												   }
               											   }
               										   }
               									   });
               								   }
               							   }	
               						   }
               					   });
               				   }
               			   }	
               		   }
               	   });
                  }
              },
           'siblingsreportexportwindow button[itemId=exportBtn]': {
        	   click: function(btn) {
        		   this.exportXlsStudentSiblingsDetailedReport();
        	   }
           }
 		   
        });

    },
    enableTabforExtraCurrPanel:function(extracurractivityreportview){
	 	   this.showTabforExtraCurrPanel(extracurractivityreportview);
	    },
	    
	    showTabforExtraCurrPanel : function(extracurractivityreportview) {
	  	   var panelItem = new Array();
	  	   var $this = this;
	  	   var newcont=extracurractivityreportview.items.items.length;
	  	   var insertPosition=newcont+1;
	  		   panelItem.push({
	  			   xtype:'tabpanel',
	  			   itemId:'allVisibleTP',
	  			   plain: true,
	  			   cls:'extraCurrActivityTabCls',
	  			   frame: false,
	  			   border:false,
	  			   defaults: {
	  				   labelAlign: 'top'
	  			   },
	  			   items:[{
	  			        xtype: 'extracurractivityreportquicksearchview',
	  			        title: getCommonTranslation('SEARCH'),
	  					listeners: {
	  	                	activate: function(me, eOpts){
	  	                		var contentPanelMain = $this.getActiveTabfromContentPanel();
	  	                		if(!isNullOrEmpty(contentPanelMain)){
	  	                			contentPanelMain.scrollBy(0,1);
	  	                			contentPanelMain.scrollBy(0,-1);
	  	                		}
	  	                	}
	  	                }
	  			    }, {
	  			        xtype: 'advancedsearchquerybuilder',
	  			        searchConfigCode: CONSTANTS.CB.STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT_CONFIGCODE,
	  			        searchResultViewCode: CONSTANTS.CB.STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT_VIEWCODE,
	  			        permissionMapKey:'STUDENT_EXTRACURRICULUMREPORT_PRIVILEGES',
	  				    gridTitle: getCommonTranslation("STUDENT_EXTRACURRICULUMREPORT_LIST"),
	  			        tabCls: 'right-tab'
	  			    }]
	  		   });

	  		 extracurractivityreportview.insert(insertPosition,panelItem);
	     },
	     
			     
			   
			     enableTabforkysPanel:function(kysreportview){
				 	   this.showTabforkysPanel(kysreportview);
				    },
				    showTabforkysPanel : function(kysreportview) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=kysreportview.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  			        xtype: 'kysreportquicksearchview',
					  			        title: getCommonTranslation('SEARCH')
					  			    }, {
					  			        xtype: 'advancedsearchquerybuilder',
					  			        searchConfigCode: CONSTANTS.CB.STUDENT_KYS_DATA__REPORT_CONFIGCODE,
					  			        searchResultViewCode: CONSTANTS.CB.STUDENT_KYS_DATA__REPORT_VIEWCODE,
					  			        permissionMapKey:'STUDENT_KYSREPORT_PRIVILEGES',
					  				    gridTitle: getCommonTranslation("STUDENT_KYSREPORT_LIST"),
					  			        tabCls: 'right-tab'
					  			    }]
					  		   });

					  		 kysreportview.insert(insertPosition,panelItem);
					     },
					     
					     enableTabforSiblingsReportPanel:function(siblingsreportview){
						 	   this.showTabforSiblingsReportPanel(siblingsreportview);
						    },
						    showTabforSiblingsReportPanel : function(siblingsreportview) {
							  	   var panelItem = new Array();
							  	   var $this = this;
							  	   var newcont=siblingsreportview.items.items.length;
							  	   var insertPosition=newcont+1;
							  		   panelItem.push({
							  			   xtype:'tabpanel',
							  			   itemId:'allVisibleTP',
							  			   plain: true,
							  			   cls:'siblingReportActivityTabCls',
							  			   frame: false,
							  			   border:false,
							  			   defaults: {
							  				   labelAlign: 'top'
							  			   },
							  			   items:[{
							  			        xtype: 'siblingsreportquicksearchview',
							  			        title: getCommonTranslation('SEARCH')
							  			    }, {
							  			        xtype: 'advancedsearchquerybuilder',
							  			        searchConfigCode: CONSTANTS.CB.STUDENT_SIBLING_REPORT_CONFIGCODE,
							  			        searchResultViewCode: CONSTANTS.CB.STUDENT_SIBLING_REPORT_VIEWCODE,
							  			        permissionMapKey:'STUDENT_SIBLINGREPORT_PRIVILEGES',
							  				    gridTitle: getCommonTranslation("STUDENT_SIBLINGREPORT_LIST"),
							  			        tabCls: 'right-tab'
							  			    }]
							  		   });

							  		 siblingsreportview.insert(insertPosition,panelItem);
							     },
					     
							     /*employee children report freeze grid tab */
							     
							     enableTabforchildrenofemployeereportPanel:function(childrenofemployeereportview){
								 	   this.showTabforchildrenofemployeereportPanel(childrenofemployeereportview);
								    },
								    showTabforchildrenofemployeereportPanel : function(childrenofemployeereportview) {
									  	   var panelItem = new Array();
									  	   var $this = this;
									  	   var newcont=childrenofemployeereportview.items.items.length;
									  	   var insertPosition=newcont+1;
									  		   panelItem.push({
									  			   xtype:'tabpanel',
									  			   itemId:'allVisibleTP',
									  			   plain: true,
									  			   style:{overflow:'hidden !important',marginRight:'5px !important',marginLeft:'0px !important'},
									  			   frame: false,
									  			   border:false,
									  			   defaults: {
									  				   labelAlign: 'top'
									  			   },
									  			   items:[{
									  			        xtype: 'childrenofemployeereportquicksearchview',
									  			        title: getCommonTranslation('SEARCH')
									  			    }, {
									  			        xtype: 'advancedsearchquerybuilder',
									  			        searchConfigCode: CONSTANTS.CB.STUDENT_EMPLOYEE_CHILDREN_REPORT_CONFIGCODE,
									  			        searchResultViewCode: CONSTANTS.CB.STUDENT_EMPLOYEE_CHILDREN_REPORT_VIEWCODE,
									  			        permissionMapKey:'STUDENT_EMPLOYEECHILDREPORT_PRIVILEGES',
									  				    gridTitle: getCommonTranslation("STUDENT_EMPLOYEECHILDREPORT_LIST"),
									  			        tabCls: 'right-tab'
									  			    }]
									  		   });

									  		 childrenofemployeereportview.insert(insertPosition,panelItem);
									     },					     
		    
		  
		    
		    /***
			  * This function is to export pdf and xcel
			  */
			    
		   
    
  
    
    /***
	  * This function is to export pdf and xcel
	  */
	    
   exportReport : function(exportUrl,filetype,whetherAll,requestType) {
	    	var quickSearchForm=null;	
	    	var searchResultGrid= null;
	    	var pagingtoolbaroptions = null;
	    	var jsonFormatFormData = null;
	    	var reportTitle = null;
	    	if(requestType == 'KYSREPORT'){
	    	 quickSearchForm=this.getKysReportQuickSearch();
	    	 searchResultGrid = this.getKysReportResultGrid();
	    	 pagingtoolbaroptions = this.getKysReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	     	var reportTitle=getCommonTranslation('STUDENT_KYSREPORT');
	    	}
	    	if(requestType == 'EXTRACURRREPORT'){
	    	 quickSearchForm=this.getExtraCurrActivityReportQuickSearch();
	    	 searchResultGrid = this.getExtraCurrActivityReportResultGrid();	
	    	 pagingtoolbaroptions = this.getExtraCurrActivityReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 jsonFormatFormData=this.createJsonFormatForExtraCurrAtvy(quickSearchForm);
	     	var reportTitle=getCommonTranslation('STUDENT_EXTRACURRREPORT');
	    	}
	    	if(requestType == 'SIBLINGREPORT'){
	    	 quickSearchForm=this.getSiblingsReportQuickSearch();
	    	 searchResultGrid = this.getSiblingsReportResultGrid();
	    	 pagingtoolbaroptions = this.getSiblingsReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 jsonFormatFormData=this.createJsonFormatSiblingGrid(quickSearchForm);
	     	var reportTitle=getCommonTranslation('STUDENT_SIBLINGREPORT');
	    	}
	    	if(requestType == 'CHILDRENEMPLOYEE'){
	    	 quickSearchForm=this.getChildrenOfEmployeeQuickSearch();
	    	 searchResultGrid = this.getChildrenOfEmployeeReportResultGrid();
	    	 pagingtoolbaroptions = this.getChildrenOfEmployeeReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 jsonFormatFormData=this.createJsonFormatChildrenOfEmpGrid(quickSearchForm);
	     	var reportTitle=getCommonTranslation('STUDENT_CHILDRENEMPLOYEE');
	    	}
	    	if(requestType == 'COMMUNITYREPORT'){
	    	 quickSearchForm=this.getStudentCommunityReportQuickSearch();
	    	 searchResultGrid = this.getStudentCommunityReportResultGrid();
	    	 pagingtoolbaroptions = this.getStudentCommunityReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 jsonFormatFormData=this.createJsonFormatForCommunity(quickSearchForm);
	     	var reportTitle=getCommonTranslation('STUDENT_COMMUNITYREPORT');
	    	}
	    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    	//var jsonFormatFormData=this.createJsonFormatForCommunity(quickSearchForm);
	    	//var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
   },
		
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
                if(keyValueJsonObject != undefined && keyValueJsonObject != "") { 
	                searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
                }
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
	    
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     *  @param {Object}
     *            form is the reference of the search form
     *            
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(form, dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(form, dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },
    
    
    
    loadDependentComboForSiblingsReport: function(form, dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdownsForSiblingsReport(form, dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            var alinfomodel = Academia.model.authentication.ALInfoModel;
    		var wheatherSchool = alinfomodel.get('wheatherSchool');
    		if(wheatherSchool){
    			if(dependentCombo.itemId=='period' || dependentCombo.itemId=="period"){
                	//store.reload();
    				var period = form.down('#period');
    				if(comboValue > 0){	    	        					  
               		 var store = period.getStore();
               		 store.getProxy().extraParams = {
               			 id: comboValue
               		 };
                	store.reload({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   if(records.length > 0){
    									   period.setValue(records[0].data.id);
    				                	   var section = form.down('#section');
    				                	   section.clearValue();
    				                	   section.store.removeAll();
    				                	   var periodId = records[0].data.id;
    					                	 if(periodId > 0){	    	        					  
    					                		 var store = section.getStore();
    					                		 store.getProxy().extraParams = {
    					                			 periodId: periodId
    					                		 };
    					                		 store.reload();
    					                	 }
    							   }
    						   }
    					   }
    				    });
    				}
                
    			}else{
    				store.reload();	
    			}
    		}else{
            	store.reload();	
            }
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(form, combo) {
        switch (combo.name) {
        case 'PROGRAM_ID':
            this.clearCombo(combo);
            batchCombo = form.down('combo[name=BATCH_ID]');
            this.clearCombo(batchCombo);
            courseCombo = form.down('combo[name=COURSE_ID]');
            this.clearCombo(courseCombo);
            break;
        case 'BATCH_ID':
            this.clearCombo(combo);
            courseCombo = form.down('combo[name=COURSE_ID]');
            this.clearCombo(courseCombo);
            sectionCombo = form.down('combo[name=SECTION_ID]');
            this.clearCombo(sectionCombo);
            break;
        case 'COURSE_ID':
            this.clearCombo(combo);
            sectionCombo = form.down('combo[name=SECTION_ID]');
            this.clearCombo(sectionCombo);
            break;
        case 'SECTION_ID':
            this.clearCombo(combo);
            break;
        }    
    },
    

    resetOtherDropdownsForSiblingsReport: function(form, combo) {
        switch (combo.name) {
        case 'PROGRAM_ID':
            this.clearCombo(combo);
            batchCombo = form.down('combo[name=BATCH_ID]');
            this.clearCombo(batchCombo);
            periodCombo = form.down('combo[name=PERIOD_ID]');
            this.clearCombo(periodCombo);
            break;
        case 'BATCH_ID':
            this.clearCombo(combo);
            periodCombo = form.down('combo[name=PERIOD_ID]');
            this.clearCombo(periodCombo);
            sectionCombo = form.down('combo[name=SECTION_ID]');
            this.clearCombo(sectionCombo);
            break;
        case 'PERIOD_ID':
            this.clearCombo(combo);
            sectionCombo = form.down('combo[name=SECTION_ID]');
            this.clearCombo(sectionCombo);
            break;
        case 'SECTION_ID':
            this.clearCombo(combo);
            break;
        }    
    },
    
    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
    	if( !isNullOrEmpty(combo) ){
    		combo.clearValue();
            combo.store.removeAll();
    	}
    },
    /**
     * Load student kys report
     */
    loadStudentKysReportData: function() {
    	var masterForm = this.getKysReportQuickSearch();
    	masterForm.down('#searchButtonId').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormat(masterForm);
        var resultGrid = this.getKysReportResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_KYS_DATA__REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,masterForm.down('#searchButtonId'));
        Ext.getBody().unmask();
    },
    /**
     * Load employee child report
     */
    loadStudentEmployeeChildReportData: function() {
        var masterForm = this.getChildrenOfEmployeeQuickSearch();
        masterForm.down('#searchButtonId').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormatChildrenOfEmpGrid(masterForm);
        var resultGrid = this.getChildrenOfEmployeeReportResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_EMPLOYEE_CHILDREN_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, masterForm.down('#searchButtonId'));
        Ext.getBody().unmask();
    },
    /**
     * Load student sibling report
     */
    loadStudentSiblingReportData: function() {
        var masterForm = this.getSiblingsReportQuickSearch();
        var jsonFormatFormData = this.createJsonFormatSiblingGrid(masterForm);
        var resultGrid = this.getSiblingsReportResultGrid();
        var buttonsToolBar = resultGrid.query('toolbar')[0];
        var exportReport = buttonsToolBar.query('#exportReportsId')[0];
        exportReport.setDisabled(false);
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_SIBLING_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
    },
    /**
     * Load student community report
     */
    loadStudentCommunityReportData: function() {
        var masterForm = this.getStudentCommunityReportQuickSearch();
        masterForm.down('#searchButtonId').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormatForCommunity(masterForm);
        var resultGrid = this.getStudentCommunityReportResultGrid();
        var buttonsToolBar = resultGrid.query('toolbar')[0];
        var exportReport = buttonsToolBar.query('#exportReportsId')[0];
        exportReport.setDisabled(false);
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_COMMUNITY_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, masterForm.down('#searchButtonId'));
        Ext.getBody().unmask();
        /*setTimeout(function(){
  			Ext.suspendLayouts();
  			var alinfomodel = Academia.model.authentication.ALInfoModel;
  			var wheatherSchool = alinfomodel.get('wheatherSchool');
  			if(wheatherSchool){
  				for (var j = 0; j < resultGrid.columns.length; j++) {
  					if (resultGrid.columns[j].dataIndex == "periodId") {
  						resultGrid.columns[j].hide();
  					}
  				}
  			}
  	        Ext.resumeLayouts();
			},2000);*/
        
    },
    /**
     * Load student extra curricular report
     */
    loadStudentExtraCurricularReportData: function() {
        var masterForm = this.getExtraCurrActivityReportQuickSearch();
        masterForm.down('#searchButtonId').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormatForExtraCurrAtvy(masterForm);
        var resultGrid = this.getExtraCurrActivityReportResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,masterForm.down('#searchButtonId'));
        Ext.getBody().unmask();
    },
    createJsonFormatForCommunity: function(MasterForm) {
         var formValues = new Array();
         var values = new Object();
         var searchcriteria = new Array();
         var me=this;

         values.configCode = CONSTANTS.CB.STUDENT_COMMUNITY_REPORT_BASIC_CONFIGCODE;
         formValues = MasterForm.getValues();
         
         if( !isNullOrEmpty(formValues.STUDENTS_WITHOUT_COMMUNITY) ){
        	 if( formValues.STUDENTS_WITHOUT_COMMUNITY ){
        		 //formValues.COMMUNITY_ID_SECOND = 0;
        		 var isCommunityObjForCB = {
                     "paramCode": 'STUDENTS_WITHOUT_COMMUNITY',
                     "paramValues": [true]
                 };
        		 me.pushJsonObjectInArray(isCommunityObjForCB, searchcriteria);
        		 delete formValues.optInOptOut;
        	 } else {
        		 var isCommunityObjForCB2 = {
                     "paramCode": 'STUDENTS_WITH_COMMUNITY',
                     "paramValues": [false]
                 };
        		 me.pushJsonObjectInArray(isCommunityObjForCB2, searchcriteria);
        		 delete  formValues.STUDENTS_WITHOUT_COMMUNITY;
        		 if(formValues.optInOptOut=="OPT_IN") {
	        		 var isCommunityObjForCB3 = {
	                         "paramCode": 'COMMUNITY_OPT_IN',
	                         "paramValues": [true]
	                 };
	            	 me.pushJsonObjectInArray(isCommunityObjForCB3, searchcriteria);
	            	 delete formValues.optInOptOut;
        		 }
        		 else if(formValues.optInOptOut=="OPT_OUT") {
        			 var isCommunityObjForCB3 = {
	                         "paramCode": 'COMMUNITY_OPT_OUT',
	                         "paramValues": [true]
	                 };
	            	 me.pushJsonObjectInArray(isCommunityObjForCB3, searchcriteria);
	            	 delete formValues.optInOptOut;
        		 }
        	 }
         } else {
        	 var isCommunityObjForCB3 = {
                 "paramCode": 'STUDENTS_WITH_COMMUNITY',
                 "paramValues": [false]
             };
    		 me.pushJsonObjectInArray(isCommunityObjForCB3, searchcriteria);
    		 delete  formValues.STUDENTS_WITHOUT_COMMUNITY;
    		 if(formValues.optInOptOut=="OPT_IN") {
        		 var isCommunityObjForCB3 = {
                         "paramCode": 'COMMUNITY_OPT_IN',
                         "paramValues": [true]
                 };
            	 me.pushJsonObjectInArray(isCommunityObjForCB3, searchcriteria);
            	 delete formValues.optInOptOut;
    		 }
    		 else if(formValues.optInOptOut=="OPT_OUT") {
    			 var isCommunityObjForCB3 = {
                         "paramCode": 'COMMUNITY_OPT_OUT',
                         "paramValues": [true]
                 };
            	 me.pushJsonObjectInArray(isCommunityObjForCB3, searchcriteria);
            	 delete formValues.optInOptOut;
    		 }
         }
         
         if(!isNullOrEmpty(formValues.AGE_GROUP)){
        	 var splitVal = formValues.AGE_GROUP.split("#");
        	 formValues.AGE_GROUP_FROM_DATE = splitVal[0];
        	 formValues.AGE_GROUP_TO_DATE = splitVal[1];
        	 delete  formValues.AGE_GROUP;
         }
         for (var key in formValues) {
             var value = formValues[key];
             if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField' ) {
                 var keyValueJsonObject = me.getJsonObject(key, value);
                 me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
             }
         }
         
         var academyLocationId = me.getCurrentAcademyLocation();
         var academyLocationObj = me.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
         me.pushJsonObjectInArray(academyLocationObj,searchcriteria);
         
        values.searchCriterias = searchcriteria;
        return values;
    },
    
    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();

    },
    createJsonFormat: function(MasterForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.STUDENT_KYS_DATA__REPORT_CONFIGCODE;
        formValues = MasterForm.getValues();

        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField' ) {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },

    createJsonFormatChildrenOfEmpGrid: function(MasterForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.STUDENT_EMPLOYEE_CHILDREN_REPORT_CONFIGCODE;
        formValues = MasterForm.getValues();


        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField' && key !== 'selectedEmployeeNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }

        var academyLocationId = me.getCurrentAcademyLocation();
        var academyLocationObj = me.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
        me.pushJsonObjectInArray(academyLocationObj,searchcriteria);
        
        values.searchCriterias = searchcriteria;
        return values;
    },

    createJsonFormatSiblingGrid: function(MasterForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.STUDENT_SIBLING_REPORT_BASIC_CONFIGCODE;
        formValues = MasterForm.getValues();


        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField' && key !== 'selectedSiblingNameField' && key !== 'ACADEMY_LOCATION_ID') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }
        var academyLocationData=[];
    	if(!isNullOrEmpty(formValues.ACADEMY_LOCATION_ID) && !isNullOrEmpty(formValues.ACADEMY_LOCATION_ID[0])){
			for(var i in formValues.ACADEMY_LOCATION_ID){
				if(Ext.isObject(formValues.ACADEMY_LOCATION_ID[i])&& !isNullOrEmpty(formValues.ACADEMY_LOCATION_ID[i])){
					al = formValues.ACADEMY_LOCATION_ID[i].get("id");
					academyLocationData.push(al);
				}else{
					if(!isNullOrEmpty(formValues.ACADEMY_LOCATION_ID[i])){
					al = formValues.ACADEMY_LOCATION_ID[i];
					academyLocationData.push(al);
					}
				}
			}
			var academyLocationObj = me.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationData.join());
			me.pushJsonObjectInArray(academyLocationObj,searchcriteria);
		}
    	else{
        var academyLocationId = me.getCurrentAcademyLocation();
        var academyLocationObj = me.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
        me.pushJsonObjectInArray(academyLocationObj,searchcriteria);
        }
        
        values.searchCriterias = searchcriteria;
        
        
        return values;
    },

    createJsonFormatForExtraCurrAtvy: function(MasterForm) {
        var nameValue = MasterForm.down('#selectedNameField');

        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT_BASIC_CONFIGCODE;
        formValues = MasterForm.getValues();


        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }

        var academyLocationId = me.getCurrentAcademyLocation();
        var academyLocationObj = me.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
        me.pushJsonObjectInArray(academyLocationObj,searchcriteria);
        
        values.searchCriterias = searchcriteria;
        return values;
    },

    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /*
     * This function is used for to enable or disable combo
     * 
     */
    enableDisableCombo: function(selectedCombo, searchForm, itemId, params) {
        if (searchForm) {
            var combo = searchForm.down(itemId);
            if (combo) {
                combo.setDisabled(false);
                combo.reset();
                if (!isEmpty(params)) {
                    combo.getStore().removeAll();
                    combo.getStore().load({
                        params: params
                    });
                }
            }
        }
    },
    changeNameFieldConfig: function(combo) {

        var nameField = combo.up('form').down('#selectedName');

        if (nameField != undefined) {

            nameField.setFieldLabel(combo.getRawValue());

            nameField.name = combo.getValue();

            nameField.applyEmptyText();

        }
    },
    changeNameFieldEmployeeConfig: function(combo) {

        var nameField = combo.up('form').down('#selectedEmployeeName');

        if (nameField != undefined) {

            nameField.setFieldLabel(combo.getRawValue());

            nameField.name = combo.getValue();

            nameField.applyEmptyText();

        }
    },
    
    changeNameFieldSiblingConfig: function(combo) {
    	
    	var nameField = combo.up('form').down('#selectedSiblingName');
        if (nameField != undefined) {

            nameField.setFieldLabel(combo.getRawValue());

            nameField.name = combo.getValue();

            nameField.applyEmptyText();

        }
    },
    
    
    /**
     * This method is used to clear fields on User Frequency search Form
     * @param button which is reference of buttton
     */
    clearSearchForm : function(button){
 	   
    	form = button.up('form');
        var comboToBeResetArray = new Array();
        form.getForm().reset();
        comboToBeResetArray.push(form.down('#batch'));
    	comboToBeResetArray.push(form.down('#course'));
    	comboToBeResetArray.push(form.down('#section'));
        
        for(var i= 0; i < comboToBeResetArray.length; i++){
        	if(!isEmpty(comboToBeResetArray[i])){
        		this.clearCombo(comboToBeResetArray[i]);
        	}
        }
        
        var batchCombo = form.down('#batch');
        var url = batchCombo.getStore().getProxy().proxyConfig.api.read;
        batchCombo.getStore().getProxy().api.read = url;
        if(form.itemId=='studentCommunityReportQuickSearchFrom'){
//        	form.down('#batch').getStore().load(); comment due to V2D-41311
        	batchCombo.setDisabled(true);
        }else{
          form.down('#batch').getStore().load(); 
          form.down('#section').getStore().load(); 
       //   form.down('#section').setDisabled(true);  
        }
        
        if(!isNullOrEmpty(form.down('#period'))){
        	form.down('#period').setDisabled(true);	
        }        
    },
    
    clearSearchFormExtraCurricularReprot : function(button){
    	form = button.up('form');
    	form.getForm().reset();
        form.down('#batch').setDisabled(true);
        form.down('#section').setDisabled(true);
        form.down('#period').setDisabled(true);  
    },
    
    clearSearchFormForSiblingsReport : function(button){
  	   
  	    var $this = this;
    	form = button.up('form');
        var comboToBeResetArray = new Array();
        form.getForm().reset();
        
        var academyLocationId = $this.getCurrentAcademyLocation();
        var academyLocationCombo = form.down('#academyLocationId');
        academyLocationCombo.getStore().load({
        	callback: function(records, operation, success) {
				for(var i in records){
					if(records[i].data.id==academyLocationId) {
						academyLocationCombo.setValue(records[i].data.id);
					}
				}
        	}
		});
		var programCombo = form.down('#program');
        programCombo.getStore().proxy.extraParams = {
            academyLocationId: academyLocationId
        };
        programCombo.getStore().load();
		
        var batchCombo = form.down('#batch');
        var periodCombo = form.down('#period');
        var sectionCombo = form.down('#section');
        
        batchCombo.setDisabled(true);
        periodCombo.setDisabled(true);
        sectionCombo.setDisabled(true);
        
        comboToBeResetArray.push(form.down('#batch'));
    	comboToBeResetArray.push(form.down('#period'));
    	comboToBeResetArray.push(form.down('#section'));
        
        for(var i= 0; i < comboToBeResetArray.length; i++){
        	if(!isEmpty(comboToBeResetArray[i])){
        		this.clearCombo(comboToBeResetArray[i]);
        	}
        }
        
        //form.down('#section').setDisabled(true);
        var exportReport = buttonsToolBar.query('#exportReportsId')[0];
        exportReport.setDisabled(true);
        /*form.down('#period').setDisabled(true);*/        
    },
    
	/**
	 * This is used to open student profile on click of student ID of community grid
	 */

    cellClickCommunityResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        if (columnName == "STUDENT_CODE") {
            var tabTitle = record.get('STUDENT_CODE');
            var personId = record.get('PERSON_ID');
            var userId = record.get('ID');
            var programBatchSeatTypeConfigId = record.get('PROG_BATCH_SEAT_CONFIG_ID');
            this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
        }
        //return false; 
    },
    
    exportXlsStudentSiblingsDetailedReport : function() {
			var $this = this;
			var $this = this;
	    	var exportType = $this.getSiblingsreportexportwindow().down("#exportTypeId");
			var form = $this.getSiblingsReportQuickSearch().getForm();
			var values = form.getValues();
			var reportParams = new Object();
			var code;
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			 var academyLocationData=[];
			if(!isNullOrEmpty(values.ACADEMY_LOCATION_ID) && !isNullOrEmpty(values.ACADEMY_LOCATION_ID[0])){
				for(var i in values.ACADEMY_LOCATION_ID){
					if(Ext.isObject(values.ACADEMY_LOCATION_ID[i])&& !isNullOrEmpty(values.ACADEMY_LOCATION_ID[i])){
						al = values.ACADEMY_LOCATION_ID[i].get("id");
						academyLocationData.push(al);
					}else{
						if(!isNullOrEmpty(values.ACADEMY_LOCATION_ID[i])){
						al = values.ACADEMY_LOCATION_ID[i];
						academyLocationData.push(al);
						}
					}
				}
			}
			if(exportType.value == 'STUDENT_SIBLINGS_DETAILED_REPORT') {
	    		var reportHeader = "Student - Siblings Detailed Report";
	    		var reportTitle = "Student - Siblings Detailed Report";
	    		var code = 'STUDENT_SIBLINGS_DETAILED_REPORT';
	    		reportParams.code = code;
	    		reportParams.reportTitle = code;
	    		reportParams.headerName = reportHeader;
	    		reportParams.academyLocationIds = academyLocationData.join();
	    		reportParams.admissionId = values.ADMISSION_ID;
				reportParams.batchId = values.BATCH_ID;
				reportParams.periodId = values.PERIOD_ID;
				reportParams.programId = values.PROGRAM_ID;
				reportParams.sectionId = values.SECTION_ID;
				reportParams.siblingId = values.SIBLING_ID;
				reportParams.intakeYearId = values.INTAKE_YEAR_ID;
				$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.PATH_STUDENT_SIBLINGS_DETAILED_REPORT);
				$this.getSiblingsreportexportwindow().close();
	    	}else if(exportType.value == 'STUDENT_PARENT_WISE_SIBLING_REPORT'){
			
	    		var reportHeader = "Parent Wise Sibling Report";
	    		var reportTitle = "Parent Wise Sibling Report";
	    		var code = 'STUDENT_SIBLINGS_DETAILED_REPORT_SIS';
	    		reportParams.code = code;
	    		reportParams.reportTitle = code;
	    		reportParams.headerName = reportHeader;
			reportParams.admissionId = values.ADMISSION_ID;
			reportParams.batchId = values.BATCH_ID;
			reportParams.periodId = values.PERIOD_ID;
			reportParams.programId = values.PROGRAM_ID;
			reportParams.sectionId = values.SECTION_ID;
			reportParams.siblingId = values.SIBLING_ID;
			reportParams.intakeYearId = values.INTAKE_YEAR_ID;
				$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.PATH_STUDENT_SIBLINGS_DETAILED_REPORT);
				$this.getSiblingsreportexportwindow().close();
	    	}
			
    },
    openSiblingsDetailExportWin: function() {
    	var $this = this;
    	var win = $this.getSiblingsreportexportwindow();
		if(!win){
			win = Ext.widget('siblingsreportexportwindow');
		}
		win.show();
		var  exportTypeIdField = win.down("#exportTypeId");
		var store = exportTypeIdField.getStore();
		
		var academyLocationId=$this.getCurrentAcademyLocation();
		store.on('load', function(records, operation, success){
			var allStoreData = [];
			var associatedAcadLocationIds = new Array();	            
			associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getSTUDENT_SIBLINGREPORT_PERMISSIONS());
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'STUDENT_SIBLINGS_DETAILED_REPORT') {
					allStoreData.push({
						id : 'STUDENT_SIBLINGS_DETAILED_REPORT',
						value : getPersonModuleTranslation('STUDENT_SIBLINGS_DETAILED_REPORT')
					});       		
				}
				if (privilege === 'STUDENT_PARENT_WISE_SIBLING_REPORT') {
					allStoreData.push({
						id : 'STUDENT_PARENT_WISE_SIBLING_REPORT',
						value : getPersonModuleTranslation('STUDENT_PARENT_WISE_SIBLING_REPORT')
					});       		
				}
			});

			store.removeAll();
			store.add(allStoreData);
		}, store, { single : true });
		
		//store.load();
    },
    //******************Disable reset password button**********************************
    disableSiblingExportLinkActionPivileges: function(grid,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = grid.query('toolbar')[0];
    	var exporetReportBtn = grid.down('#exportReportsId');
    	exporetReportBtn.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    	var store = Ext.create('Academia.store.reports.student.SiblingExportReportTypeStore');
       	store.load({
      		callback: function(records, operation, success) {
      			if ( privilege === 'STUDENT_SIBLINGS_DETAILED_REPORT' || privilege === 'STUDENT_PARENT_WISE_SIBLING_REPORT' ){
      				var button = buttonsToolBar.query('#exportReportsId')[0];
      				if(!isNullOrEmpty(button)){
      					exporetReportBtn.setVisible(true);
      				}  
      			}
      		}
      	});	
      });
    },
    clearSearchFormCommunityReport : function(button){
    	form = button.up('form');
        var comboToBeResetArray = new Array();
        form.getForm().reset();
        var programCombo = form.down('#program');
        var batchCombo = form.down('#batch');
        var periodCombo = form.down('#periodId');
        var sectionCombo = form.down('#section');
        var programGroupCombo = form.down('#Program_Group');
        
		var joiningDateFrom = form.down('#DATE_OF_JOINING_FROM');
		var joiningDateTo = form.down('#DATE_OF_JOINING_TO');
    	joiningDateFrom.setMinValue(null);
    	joiningDateFrom.setMaxValue(null);
    	joiningDateTo.setMinValue(null);
    	joiningDateTo.setMaxValue(null);
				
        batchCombo.reset(); 
        periodCombo.reset();
        sectionCombo.reset();
        batchCombo.setDisabled(true); 
        periodCombo.setDisabled(true);
        sectionCombo.setDisabled(true);
        batchCombo.setReadOnly(false); 
        periodCombo.setReadOnly(false); 
        sectionCombo.setReadOnly(false); 
        programCombo.setReadOnly(false); 
        programGroupCombo.setReadOnly(false); 
        var programCombo = form.down('#program');
        var ageGroup=form.down("#ageGroup");
        var community=form.down("#community");
        ageGroup.reset();
        community.reset();
        var academyLocationId = this.getCurrentAcademyLocation();
        var academicTermCombo = form.down('#academicTerm');
        var academicTermComboStore = academicTermCombo.getStore();
        academicTermComboStore.load({
				 callback: function(records, operation, success) {
					 for(var i in records){
						 if(records[i].data.whetherCurrentAcademicTerm==true){
							 academicTermCombo.setValue(records[i].data.id);
						 }
					 }
				 }	   
			  
          });
    },
    exportXlsStudentCommunityReport : function() {
			var $this = this;
			var form = $this.getStudentCommunityReportQuickSearch().getForm();
			var values = form.getValues();
			var reportParams = new Object();
			var reportTitle = "Community Summary Report";
			var code;
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			
			var ageGroupCombo = $this.getStudentCommunityReportQuickSearch().down('#ageGroup');
			
			code = 'COMMUNITY_SUMMARY_REPORT';
			reportParams.headerName = 'Community Summary Report';
			
			reportParams.ADMISSION_ID = values.ADMISSION_ID;
			reportParams.ACADEMIC_TERM_ID = values.ACADEMIC_TERM_ID;
			reportParams.AGE_GROUP = values.AGE_GROUP;
			reportParams.COMMUNITY_ID = values.COMMUNITY_ID;
			reportParams.PROGRAM_GROUP_ID = values.PROGRAM_GROUP_ID;
			reportParams.BATCH_ID = values.BATCH_ID;
			reportParams.PERIOD_ID = values.PERIOD_ID;
			reportParams.PROGRAM_ID = values.PROGRAM_ID;
			reportParams.SECTION_ID = values.SECTION_ID;
			
			if( !isNullOrEmpty(ageGroupCombo.getValue()) ){
				reportParams.AGE_GROUP_ID = ageGroupCombo.valueModels[0].data.id;
			}
			
			$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.PATH_STUDENT_COMMUNITY_SUMMARY_REPORT);
    }
    
    
});