/**
 * @author Trupti.Paoneker
 * This controller is use to handle functionality for OnlineUserReport 
 */
Ext.define('Academia.controller.reports.systemutilization.onlineusers.OnlineUserReportController', {
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['reports.systemutilization.onlineusers.OnlineUserReportModuleWiseSummaryGraphStore',
             'reports.systemutilization.onlineusers.OnlineUserReportGroupWiseSummaryStore', 
             'organization.academylocations.AcademyStore', 'organization.academylocations.LocationStore',
             'securitysetup.unlockUser.userBelongsToStore','common.AcademyStore','common.AcademyLocationByAcademyId',
             'systemusage.UserGroupStore','systemusage.UserNames','common.AllActiveAcademyLocationStore','systemusage.UsersNameStore',
             'criteriabuilder.userquicksearch.QuickSearchCode'
             ],

    views: ['criteriabuilder.grid.SearchResultGrid', 'reports.systemutilization.onlineusers.OnlineUserReportQuickSearchView',
            'reports.systemutilization.onlineusers.OnlineUserReportQuickSearchForm', 'reports.systemutilization.onlineusers.OnlineUserReportListView',
            'reports.systemutilization.onlineusers.OnlineUserReportModuleWiseSummaryGraph',
            'reports.systemutilization.onlineusers.OnlineUserReportGroupWiseSummaryGraph','reports.common.ColumnChartReport','systemUsage.SystemUsageCommonSearchDailyUsageForm'
            ],

    alias: "widget.onlineuserreportcontroller",

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'onlineUserReportQuickSearch',
        selector: 'onlineuserreportquicksearchform'
    }, {
        ref: 'onlineUserReportResultGrid',
        selector: 'searchresultgrid[itemId=onlineUserReportResultGrid]'
    }, {
        ref: 'onlineUserReportListView',
        selector: 'onlineuserreportlistview'
    }, {
        ref: 'onlineUserModuleWiseChart',
        selector: 'columnchartreport[itemId=onlineUserModuleWiseChart]'
    }, {
        ref: 'onlineUserGroupWiseChart',
        selector: 'columnchartreport[itemId=onlineUserGroupWiseChart]'
    },{
        ref: 'onlinesystemusagecommonsearchform',
        selector: 'systemusagecommonsearchdailyusageform[itemId=onlinesystemusagecommonsearchform]'
    }],
    config: {
    	ONLINE_USER_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ONLINE_USER_REPORT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	'systemusagecommonsearchdailyusageform[itemId=onlinesystemusagecommonsearchform] combo[itemId=multiselectAcademyLocationId]':{
        		render : function(obj){
        			var form = obj.up('form');
        			this.setAllAlIds(form,this.getONLINE_USER_REPORT_PERMISSIONS());
        		}
        	},
            'onlineuserreportquicksearchform button[itemId=onlineUserReportListSearchButtonId]': {
                click: this.loadGridAndSearchUsers,
               //render: this.loadGridAndSearchUsers
            },
            
            'onlineuserreportquicksearchview tabpanel[itemId=onlineuserreporttabpanelId]':{
            	tabchange:function(){
            		var masterForm = this.getOnlineUserReportQuickSearch();
            		var jsonFormatFormData = this.createJsonFormat(masterForm);
            		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            		var basicSearchUrl = SERVERURL.EXECUTEBASICSEARCH;
            		var activeTab=this.getActiveTabfromContentPanel().down('tabpanel').getActiveTab();
            		if(activeTab.itemId== 'groupReportPanel' ){
            			jsonFormatFormData.viewCode=CONSTANTS.CB.ONLINE_USER_REPORT_GRAPH_VIEWCODE;
            			var store=activeTab.down('#onlineUserGroupWiseChart').getStore();
            			this.loadChartData(basicSearchUrl+'?page=-1&limit=-1',jsonFormatFormData,store);

            		}else if(activeTab.itemId== 'moduleReportpanel' ){
            			jsonFormatFormData.configCode = CONSTANTS.CB.ONLINE_USER_REPORT_MODULE_CONFIGCODE;
            			jsonFormatFormData.viewCode=CONSTANTS.CB.ONLINE_USER_REPORT_MODULE_VIEWCODE;
            			var store=activeTab.down('#onlineUserModuleWiseChart').getStore();
            			this.loadChartData(basicSearchUrl+'?page=-1&limit=-1',jsonFormatFormData,store);

            		}else if(activeTab.itemId== 'onlineUserReportResultGrid' ){
            			resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.ONLINE_USER_REPORT_VIEWCODE);
            			activeTab.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
            		}
            	}
            },
            
          'onlineuserreportquicksearchform radio':{
         	 focus: this.hideShowCombo
          },
          
          'onlineuserreportquicksearchform button[itemId=resetBtn]': {
              click: this.clearSearchData
          },
         
            'onlineuserreportquicksearchform combo[itemId=academyId]': {
                select: function(obj, record) {
                    var academyId = record[0].get("id");
                    obj.nextSibling().clearValue();
                    var store = this.getStore('common.AcademyLocationByAcademyId');
                    store.getProxy().extraParams = {
                        id: academyId
                    };
                    store.load();
                }
            },
            'searchresultgrid[itemId=onlineUserReportResultGrid]': {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				},
 				afterrender : function(grid) {
                    var me = this;
                    var structure = grid.up('onlineuserreportquicksearchview');
                 //  me.getGridHeaderFreezeForInactiveUser(grid, structure, false);
                    var searchButton =  structure.down('#onlineUserReportListSearchButtonId');
                    me.loadGridAndSearchUsers(searchButton);
                }
            },
            'onlineuserreportquicksearchview grid[itemId=onlineUserReportResultGrid]': {
            	afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getONLINE_USER_REPORT_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
            },
            
           /* 'onlineuserreportquicksearchform combo[itemId=ol_user_name]':{
	           	 focus: this.loadUserNamesCombo
	           },*/
            /**** Export button for online user report ******/
	        'searchresultgrid[itemId=onlineUserReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportOnlineUserReport(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=onlineUserReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportOnlineUserReport(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=onlineUserReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportOnlineUserReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=onlineUserReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportOnlineUserReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        },
	        'onlineuserreportlistview':{
	        	tabchange:function(structure){
	        		var grid = structure.down('#userAdvSearchResultGrid');
	        		grid.getHeader().removeCls('gridFixHeader');
      				grid.dockedItems.items[2].removeCls('gridFixHeader');
      				grid.dockedItems.items[2].setPosition(3,4);
	        	},
	        }
        });

    },
    
	    /***
		  * This function is to export pdf and xcel
		  */
	    
    exportOnlineUserReport : function(exportUrl,filetype,whetherAll,requestType) {
	    	 var quickSearchForm=this.getOnlineUserReportQuickSearch();
	    	 var searchResultGrid = this.getOnlineUserReportResultGrid();	
	    	 var pagingtoolbaroptions = this.getOnlineUserReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	         var reportTitle=getCommonTranslation('ONLINE_USER_REPORT');
	    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	        var formValues = new Array();
	        formValues = searchForm.getValues();        
	        var searchCriteriaString="";
	        for (var key in formValues) {
	        	var value = formValues[key];            
	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                var keyValueJsonObject = me.getJsonObject( key , value);
	    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	            }
	        }
	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        return searchCriteriaString;
	    },
	    
	    gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	    },
	    
    loadGridAndSearchUsers: function(button, records) {
        var masterForm = button.up('#onlineUserReportQuickSearch');
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        var basicSearchUrl = SERVERURL.EXECUTEBASICSEARCH;
        var jsonFormatFormData = this.createJsonFormat(masterForm, records);
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
           
        var activeTab=masterForm.up('onlineuserreportquicksearchview').down('tabpanel').getActiveTab();
        if(activeTab.itemId== 'groupReportPanel' ){
        	jsonFormatFormData.viewCode=CONSTANTS.CB.ONLINE_USER_REPORT_GRAPH_VIEWCODE;
	       	var store=activeTab.down('#onlineUserGroupWiseChart').getStore();
	    	this.loadChartData(basicSearchUrl+'?page=-1&limit=-1',jsonFormatFormData,store);
	        	
        }else if(activeTab.itemId== 'moduleReportpanel' ){
        	jsonFormatFormData.configCode = CONSTANTS.CB.ONLINE_USER_REPORT_MODULE_CONFIGCODE;
        	jsonFormatFormData.viewCode=CONSTANTS.CB.ONLINE_USER_REPORT_MODULE_VIEWCODE;
        	var store=activeTab.down('#onlineUserModuleWiseChart').getStore();
        	this.loadChartData(basicSearchUrl+'?page=-1&limit=-1',jsonFormatFormData,store);
        	
        }else if(activeTab.down('grid') && activeTab.down('grid').itemId== 'onlineUserReportResultGrid' ){
              resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.ONLINE_USER_REPORT_VIEWCODE);
        	activeTab.down('grid').initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        }
        
//        var onlineUserModuleWiseChart = this.getOnlineUserModuleWiseChart();
//        var onlineUserGroupWiseChart = this.getOnlineUserGroupWiseChart();

//        var resultGrid = this.getOnlineUserReportResultGrid();
//        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
//        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.ONLINE_USER_REPORT_VIEWCODE);
//        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        
        
//        resultGrid.getStore().on('load', function(store, records) {
//            onlineUserModuleWiseChart.getStore().loadData(records);
//            onlineUserGroupWiseChart.getStore().loadData(records);
//        });
    	var taskDelay = new Ext.util.DelayedTask(function(){
       		Ext.getBody().unmask();
       	  });
       	taskDelay.delay(1000);
    },
    
    loadChartData:function(viewUrl,jsonFormatFormData,store){
    	 Ext.Ajax.request({
             type: 'rest',
             url: viewUrl,
             method: 'POST',
             headers: {
                 'Content-Type': 'application/json'
             },
             jsonData: jsonFormatFormData,
             success: function(response) {
               data = Ext.decode(response.responseText);
                     store.loadData(data.rows);
             }
         });
    },
    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();

    },
    createJsonFormat: function(MasterForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.ONLINE_USER_REPORT_BASIC_CONFIGCODE;
        values.viewCode = CONSTANTS.CB.ONLINE_USER_REPORT_VIEWCODE;
        formValues = MasterForm.getValues();

//        var academyLocationIds = new Array();
        
    	/*if(formValues.ACADEMY_LOCATION_IDS!=''){
    		Ext.each( formValues.ACADEMY_LOCATION_IDS, function(value) { 
    			academyLocationIds.push(value.data.id);	
    		});
        }*/
        
    	var alData;
		var multiAlArrayData=[];
		if(formValues.ACADEMY_LOCATION_IDS !="" && formValues.ACADEMY_LOCATION_IDS !=null){
			for(var i in formValues.ACADEMY_LOCATION_IDS){
				if(Ext.isObject(formValues.ACADEMY_LOCATION_IDS[0])){
					alData = formValues.ACADEMY_LOCATION_IDS[i].get("id");
					multiAlArrayData.push(alData);
				}else{
					alData = formValues.ACADEMY_LOCATION_IDS[i];
					multiAlArrayData.push(alData);
				}
			}
		}	
		
        var ACADEMY_LOCATION_IDS = this.getJsonObject('ACADEMY_LOCATION_IDS',multiAlArrayData,null,'extraParam');
        this.pushJsonObjectInArray(ACADEMY_LOCATION_IDS, searchcriteria);
        
        if(formValues.USER_BELONGS_TO !== 'all'){
        	 var USER_BELONGS_TO	= this.getJsonObject('USER_BELONGS_TO',formValues.USER_BELONGS_TO);
             this.pushJsonObjectInArray(USER_BELONGS_TO, searchcriteria);
        } 

    	var radioValue = MasterForm.getForm().getValues()['userRadio'];
    	if(radioValue === 'individual'){
    		
    		var userIds = new Array();
        	var userNames = new Array();
        	if(formValues.USER_IDS!=''){
        	
    			Ext.each( formValues.USER_IDS, function(value) {
    				if(value!=''){
    				userIds.push(value.data.id);
    		}
    		});
        	}
        	if(formValues.USER_NAME!=''){
    		
    			Ext.each( formValues.USER_NAME, function(value) {
    				userNames.push(value.data.id);	
    		});
        	}
            	var USER_ID = this.getJsonObject('USER_ID', userIds,null, true);
                this.pushJsonObjectInArray(USER_ID, searchcriteria);
                
                var USER_NAME = this.getJsonObject('USER_NAME', userNames,null,true);
                this.pushJsonObjectInArray(USER_NAME, searchcriteria);
            
    	}else if(radioValue === 'userGroups'){
    		
    		var userGroup = new Array();
    		if(formValues.USER_GROUP!=''){
    			
    			Ext.each( formValues.USER_GROUP, function (value) {
    				userGroup.push(value.data.id);	
    			});
    		}
    		var USER_GROUP = this.getJsonObject('USER_GROUP', userGroup,null,'extraParam');
            this.pushJsonObjectInArray(USER_GROUP, searchcriteria);
    	}

        values.searchCriterias = searchcriteria;
        return values;
    },
    getJsonObject: function(key, value,additionalValue, extraParam) {
    	if(extraParam){
    		 if (value !='' && additionalValue == undefined) {
    	            return {
    	                "paramCode": key,
    	                "paramValues": value
    	            };
    	        }
    	}
    	else if (value !== '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    /**
     * This method is used to hide /show combo on select of User Types
     * @param cmp reference of component
     */
    hideShowCombo : function(cmp){
    	
    	var form = cmp.up('form');
    	var comboField = form.down('#userTypeIndividualFieldContainer');
    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var userIdCmb = comboField.down('#ol_user_id');
    	var userNameCmb = comboField.down('#frequency_user_name');
        var userGroup = userGroupCmb.down('#frequency_user_group');
    	
    	if(cmp.itemId === 'individualRadioBtn'){
    		comboField.setDisabled(false);
    		comboField.setVisible(true);
    		userGroupCmb.setDisabled(true);
    		userGroupCmb.setVisible(false);
    		userGroup.reset();
    	}else if(cmp.itemId === 'userGroupRadioBtn'){
    		userGroupCmb.setDisabled(false);
    		userGroupCmb.setVisible(true);
    		comboField.setDisabled(true);
    		comboField.setVisible(false);
    		userIdCmb.reset();
    		if(!isNullOrEmpty(userNameCmb)){
    		userNameCmb.reset();
    		}
    	}else if(cmp.itemId === 'allRadioBtn'){
    		userGroupCmb.setDisabled(false);
    		userGroupCmb.setVisible(false);
    		comboField.setDisabled(false);
    		comboField.setVisible(false);
    		userIdCmb.reset();
    		userNameCmb.reset();
    		userGroup.reset();
    	}
    },
    
    clearSearchData : function(button){
    	
	   button.up('form').getForm().reset();
	   var masterForm = button.up('#onlineUserReportQuickSearch');
	   	 
	   	 var onlineUserWiseChart = masterForm.up('onlineuserreportquicksearchview').down('#onlineUserModuleWiseChart');
	   	 var onlineUserGroupWise = masterForm.up('onlineuserreportquicksearchview').down('#onlineUserGroupWiseChart');
	   	 
	   	onlineUserWiseChart.getStore().removeAll();
	   	onlineUserGroupWise.getStore().removeAll();
	   	button.up('form').down('#userTypeIndividualFieldContainer').setVisible(false);
		button.up('form').down('#userGroupFieldContainer').setVisible(false);
   },
   
   /**
   * This is used to load user name combo on select of user code
   */
 /* loadUserNamesCombo : function(combo){
 	 
 	var userIdCombo = combo.up('form').down('#ol_user_id');
 	var store = combo.getStore();
	 	var value = userIdCombo.getValue();
		var userCodes = new Array();
		if(value){
			Ext.each(value, function(values) {
				if(values instanceof Object){
					userCodes.push(values.get('code'));
				}else{
					userCodes.push(values);
				}
		});
		userCodes =userCodes.toString();
		store.load({
			params: {
				userCodes: userCodes
			}
		});
		}
  }*/
});