/**
 * @author Priyanshi sharma
 * */

Ext.define('Academia.controller.setup.controlPanel.ControlPanelController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['securitysetup.ModuleStore','securitysetup.SubModuleStore','setup.controlPanel.ControlPanelPrivilegeGridStore'],
    views: ['setup.controlPanel.ControlPanelStructure','setup.controlPanel.ControlPanelPrivilegeGrid'],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
    	ref:'controlpanelprivilegegrid',
    	selector:'controlpanelprivilegegrid'
    }],
    init: function() {
        this.control({
        	'controlpanelprivilegegrid': {            	
                render: function(grid) {
                    grid.store.removeAll();
                    this.setLegacyDataForPrivilege();

                }             
            },
        	'controlpanelprivilegegrid customcombobox[itemId=portalCombo]': {            	
                select: function(combo, records, eOpts) {
                	combo.up().up().down('#btnSearchRolePrivilege').setDisabled(true);
                    this.loadControlPanelModuleCombo(combo, records);
                }             
            },
            'controlpanelprivilegegrid customcombobox[itemId=moduleCombo]': {
                select: function(combo, records, eOpts) {
                    this.loadControlPanelSubModuleCombo(combo, records);
                    combo.up().up().down('#btnSearchRolePrivilege').setDisabled(false);
                }
            },
            'controlpanelprivilegegrid button[itemId=btnSearchRolePrivilege]':{
            	 click: function(button) {
            		 this.searchPrivileges(button);
            	 }
            },
            'controlpanelprivilegegrid button[itemId=btnResetPrivilege]': {
                click: function(button) {
                    this.resetPrivilegeGridComboFilter(button);
                }
            },
            'controlpanelprivilegegrid button[itemId=btnSavePrivilege]': {
                click: function() {
                    this.savePrivileges();
                }
            },
            'controlpanelprivilegegrid button[itemId=btnGrantAllPrivilege]': {
                click: this.grantAllPrivilege
            },
            'controlpanelprivilegegrid button[itemId=btnRevokeAllPrivilege]': {
                click: this.revokeAllPrivilege
            },
        });
    },
    loadControlPanelModuleCombo: function(combo, records) {
    	var this$ = this,
        controlPanelTab = this$.getContentPanel().getActiveTab(),
        privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
        moduleCombo = privilegeGrid.down('#moduleCombo'),
        subModuleCombo = privilegeGrid.down('#subModuleCombo'),
        id = records[0].get('id'),
        moduleStore = moduleCombo.getStore();
        moduleCombo.clearValue();
        subModuleCombo.clearValue();
        subModuleCombo.setDisabled(true);
        if (id != 0) {
        	moduleStore.getProxy().extraParams = {
        		portalId: id
        	}
        }else{
        	moduleStore.getProxy().extraParams={};
        }
        moduleStore.load();
    },
    loadControlPanelSubModuleCombo: function(combo, records) {
    	var this$ = this,
    	controlPanelTab = this$.getContentPanel().getActiveTab(),
    	privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
    	subModuleCombo = privilegeGrid.down('#subModuleCombo'),
    	id = records[0].get('id'),
    	subModuleStore = subModuleCombo.getStore();
    	subModuleCombo.clearValue();
    	if (id == 0) {
    		subModuleCombo.setDisabled(true);
    	}else{
    		subModuleStore.getProxy().extraParams = {
    			moduleId: id
    		};
    		subModuleStore.load();
    		subModuleCombo.setDisabled(false);
    	}
    },
    resetPrivilegeGridComboFilter:function(button){
    	var this$ = this,
    	grid = button.up(),
    	portal = grid.down("#portalCombo"),
        moduleCombo = grid.down("#moduleCombo"),
    	subModuleCombo = grid.down("#subModuleCombo"),
    	controlPanelTab = this$.getContentPanel().getActiveTab(),
    	privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
    	store = privilegeGrid.getStore();
//    	portal.setValue(0);
    	portal.clearValue();
    	moduleCombo.clearValue();
    	moduleCombo.store.getProxy().extraParams = {};
    	moduleCombo.store.load();
    	subModuleCombo.clearValue();
    	subModuleCombo.setDisabled(true);
    	store.clearFilter();
    	grid.down("#btnSearchRolePrivilege").setDisabled(true);
    },
    searchPrivileges:function(button){
    	var this$=this,
    	controlPanelTab = this$.getContentPanel().getActiveTab(),
    	privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
    	portalCombo = privilegeGrid.down('#portalCombo'),
    	moduleCombo = privilegeGrid.down('#moduleCombo'),
    	subModuleCombo = privilegeGrid.down('#subModuleCombo'),
    	store = privilegeGrid.getStore(),
    	count = store.getCount();
    	store.clearFilter();
    	if(count ==0) {
    		store.load({
    			callback:function(){
    				var totalRecord = privilegeGrid.getStore().getCount();
    				privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
    			}
    		});
    	}else{
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	}
    	if(portalCombo.getDisplayValue()!='All'){
    		store.filterGrid(portalCombo.getDisplayValue(), "portal");
    	}
    	if(!isNullOrEmpty(moduleCombo.getRawValue())) {
    		if(moduleCombo.getRawValue() !==getCommonTranslation('ALL_MODULES')){
    			store.filterGrid(moduleCombo.getRawValue(), "module");
    		}
    		privilegeGrid.down('#btnGrantAllPrivilege').setDisabled(false);
    	}
    	if(!isNullOrEmpty(subModuleCombo.getRawValue())) {
    		store.filterGrid(subModuleCombo.getRawValue(), "subModule");
    		privilegeGrid.down('#btnGrantAllPrivilege').setDisabled(false);
    	}
    	button.up('grid').down('#btnGrantAllPrivilege').setDisabled(false);
    	setTimeout(function(){
    		var totalRecord = privilegeGrid.getStore().getCount();
			privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
			Ext.getBody().unmask();
		},2000);
    },
    savePrivileges:function(){
    	var this$ = this,
    	controlPanelTab = this$.getContentPanel().getActiveTab(),
    	privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
    	records = privilegeGrid.getStore().getUpdatedRecords();
    	if(records.length > 0) {        	
    		var featureData = new Array();
    		Ext.each(records, function(obj) {
    			var feature = {
    					"featureId":obj.data.feature.id,
    					"grantedBySysAdmin":obj.data.granted
    			};
    			featureData.push(feature);
    		});
    		var recordsToUpdate = Ext.encode(featureData);
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('You are changing the access of the feature. Are you sure you want to continue'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	    		Ext.Ajax.request({
    	    			type: 'rest',
    	    			method: 'POST',
    	    			url: SERVERURL.PATH_SAVE_CONTROL_PANEL,
    	    			jsonData: recordsToUpdate,
    	    			success: function() {
    	    				Ext.getBody().unmask();
    	    				showSuccessMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('SUCCESS'));
    	    				var store = privilegeGrid.getStore();
    	    				//store.commitChanges();
    	    				store.reload();
    	    			}
    	    		});
    			}
    		});
    	}
    },
    grantAllPrivilege:function(){
    	var this$ = this,
    	controlPanelTab = this$.getContentPanel().getActiveTab(),
    	privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
        store = privilegeGrid.getStore(),
        revokeButton = privilegeGrid.down('#btnRevokeAllPrivilege'),
        grantButton = privilegeGrid.down('#btnGrantAllPrivilege');
        store.suspendEvents();   
        store.each(function(rec) {
        	 rec.set('granted', true);
        });          
        store.resumeEvents();
        privilegeGrid.getView().refresh();
        var totalRecord = privilegeGrid.getStore().getCount();
        privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
        revokeButton.setDisabled(false);
        grantButton.setDisabled(true);
    },
    revokeAllPrivilege: function() {
    	var this$ = this,
    	controlPanelTab = this$.getContentPanel().getActiveTab(),
    	privilegeGrid = controlPanelTab.down('controlpanelprivilegegrid'),
    	store = privilegeGrid.getStore(),
    	revokeButton = privilegeGrid.down('#btnRevokeAllPrivilege'),
    	grantButton = privilegeGrid.down('#btnGrantAllPrivilege');
    	store.suspendEvents();
    	store.each(function(rec) {           
    		rec.set('granted', false); 
    	});
    	store.resumeEvents();
    	privilegeGrid.getView().refresh();
    	var totalRecord = privilegeGrid.getStore().getCount();
        privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
    	revokeButton.setDisabled(true);
    	grantButton.setDisabled(false);
    },
    setLegacyDataForPrivilege:function(){
    	Ext.Ajax.request({
    			type: 'rest',
    			method: 'POST',
    			url: SERVERURL.PATH_UPDATE_FOR_LEGACY_DATA,
    			success: function() {
    				
    			}
    		});
         }
});