/**
 * @author Varsha Gour
 * 
 */
Ext.define('Academia.controller.sgappointment.sgappointment.SGStudentAppointmentController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',
	alias: "widget.sgstudentappointmentcontroller",
	// un-comment the model code if required.
	//models : [''],
	stores: ['sgappointment.sgappointment.SGStudentAppointmentStore', 'common.CountryStore', 'sgappointment.sgappointment.SGVisitorCategoryStore',
	         'hostel.roomallocation.UserSmartSearchByUserType', 'sgappointment.sgappointment.SGAppointeeNameStore',
	         'sgappointment.sgappointment.SGBookingIDStore', 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch', 'sgappointment.sgappointment.SGParentGuardianStore',
	         'enquiry.EnquiryCodeSearchStore', 'sgappointment.sgappointment.SGReasonForVisitStore', 'sgappointment.sgappointment.SGVisitStatus',
	         'feeandpayment.managebill.Student','enquiry.EnquiryCodeSearchStore','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
	         'admission.applications.applicantProfileBase.ApplicantSmartSearchStore','enquiry.EnqIntermediateType','sgappointment.sgappointment.SGFollowUpDetailsStoreForSP','sgappointment.sgappointment.SGAppointmentFlagIdStore'],
	         views: ['sgappointment.sgappointment.SGAppointmentTabStructure', 'sgappointment.sgappointment.SGStudentAppointmentDetailStructure', 'sgappointment.sgappointment.SGAppointmentFilter', 'sgappointment.sgappointment.SGStudentAppointmentDetailGrid',
	                 'sgappointment.sgappointment.SGAppointmentForm', 'sgappointment.sgappointment.SGReasonToMeetGridWin', 'servicerequest.eventcalendar.ViewCalendarWin',
	                 'personinfo.common.course.ScheduleDetails', 'baselayout.contentarea.ContentPanel',
	                 'sgappointment.sgappointment.SGStudentAppointmentDetailFormStructure','sgappointment.sgappointment.SGAppointmentFollowUpStructureForSP','sgappointment.sgappointment.SGFollowUpDetailsGridForSP'
	                 ],
	                 config: {
	                	 STUDENT_APPOINTMENT_MANAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MANAGE_APPOINTMENT_PRIVILEGES'),
	                	 STUDENT_PORTAL_APPOINTMENT_MANAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_MANAGE_APPOINTMENT_PRIVILEGES'),
	                	 FP_STUDENT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_PORTAL_MANAGE_APPOINTMENT_PRIVILEGES'),
	                	 STUDENT_APPOINTMENT_FOLLOWUP_MANAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MANAGE_APPOINTMENT_FOLLOWUP_PRIVILEGES'),
	                	 FP_STUDENT_APPOINTMENT_FOLLOWUP_MANAGE_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FP_STUDENT_MANAGE_APPOINTMENT_FOLLOWUP_PRIVILEGES'),
	                	 SP_STUDENT_APPOINTMENT_FOLLOW_UP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SP_STUDENT_APPOINTMENT_FOLLOW_UP_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'sgstudentappointmentdetailstructure',
	                	 selector: 'sgstudentappointmentdetailstructure'
	                 }, {
	                	 ref: 'sgappointmentfilter',
	                	 selector: 'sgappointmentfilter'
	                 }, {
	                	 ref: 'sgstudentappointmentdetailgrid',
	                	 selector: 'sgstudentappointmentdetailgrid'
	                 }, {
	                	 ref: 'contentPanel',
	                	 selector: 'contentPanel'
	                 }, {
	                	 ref: 'sgreasontomeetgridwin',
	                	 selector: 'sgreasontomeetgridwin'
	                 }, {
	                	 ref: 'sgappointmenttabstructure',
	                	 selector: 'sgappointmenttabstructure'
	                 }, {
	                	 ref: 'viewcalendarwin',
	                	 selector: 'viewcalendarwin'
	                 }, {
	                	 ref: 'scheduledetails',
	                	 selector: 'scheduledetails'
	                 }, {
	                	 ref: 'sgappointmentform',
	                	 selector: 'sgappointmentform[itemId=sgappointmentformstructureItemId]'
	                 }, {
	                	 ref: 'SGStudentAppointmentDetailFormStructure',
	                	 selector: 'SGStudentAppointmentDetailFormStructure'
	                 }, {
	                	 ref: 'studentsearchresultgrid',
	                	 selector: 'searchresultgrid[itemId=StudentSearchResultGrid]'
	                 },{
	                	 ref:'sgappointmentfollowupstructureforsp',
	                	 selector:'sgappointmentfollowupstructureforsp'
	                 }],
	                 init: function() {
	                	 this.isFollowUpBtn=false;
	                	 this.control({


	                		 'sgstudentappointmentdetailgrid ': {
	                			 render: function(grid) {
	                					var  me =this,activeInnerTab,grid,
	                				 contantPanel = me.getContentPanel(),
	            					 studentProfile = contantPanel.getActiveTab(),
	            					 personinfopanel = studentProfile.down('personinfopanel');
	                					if(personinfopanel){
	                						 activeInnerTab = personinfopanel.getActiveTab();
	    	            					 grid = activeInnerTab.down('sgstudentappointmentdetailgrid');
	                					}else{
	                						 grid = me.getSgstudentappointmentdetailgrid();
	                					}
	            					
	                				 var portalId = this.getCurrentLoggedPortalId();
	                				 var associatedAcadLocationIds = new Array();
	                				 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                				 var permissionList;
	                				 if (portalId == 3) {
	                					 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_APPOINTMENT_MANAGE_PERMISSIONS());
	                					 permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_PORTAL_APPOINTMENT_MANAGE_PERMISSIONS());
	                				 } else if (portalId == 2) {
	                					 this.doAccessControlValidation(grid, this.getFP_STUDENT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS());
	                					 permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFP_STUDENT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS());
	                				 } else if (portalId == 1) {
	                					 this.doAccessControlValidation(grid, this.getSTUDENT_APPOINTMENT_MANAGE_PERMISSIONS());
	                					 permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_APPOINTMENT_MANAGE_PERMISSIONS());
	                				 }
	                				 if(permissionList && permissionList.indexOf('FOLLOW_UP_DETAILS')!=-1){
                						 grid.down('#followUpDetailBtnId').setVisible(true);
                					 }
	                				 var personObject = this.getPersonObj();

	                				 Ext.Ajax.request({
	                					 type: 'rest',
	                					 url: SERVERURL.FIND_STUDENT_BY_PERSON_ID,
	                					 params: {
	                						 id: personObject.id,
	                					 },
	                					 method: 'GET',
	                					 async: false,
	                					 success: function(
	                							 form,
	                							 action) {
	                						 var studentData = Ext.JSON
	                						 .decode(form.responseText);
	                						 grid.getStore().getProxy().extraParams = {
	                							 student: studentData.id
	                						 };
	                						 grid.getStore().load();
	                					 }
	                				 });
	                			 },
	                			 cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	                				 var followUpBtn = this.getSgstudentappointmentdetailgrid().down('#followUpDetailBtnId');
	                				 followUpBtn.setDisabled(false);
	                			 }
	                		 },
	                		 'sgstudentappointmentdetailstructure': {
	                			 activate: function(tab, eOpts) {
	                				 var gridStore = Ext.getStore('sgappointment.sgappointment.SGStudentAppointmentStore');
	                				 var grid = this.getSgstudentappointmentdetailgrid().getStore();

	                				 // grid.loadPage(1);
	                				 grid.getProxy().extraParams = {
	                					 page: grid.currentPage,
	                					 limit: grid.pageSize,
	                					 start: ((grid.currentPage - 1) * (grid.pageSize)),
	                				 };
	                				 grid.load({
	                					 callback: function(record, operation, success) {
	                						 if (success) {
	                							 delete grid.getProxy().extraParams.page;
	                							 delete grid.getProxy().extraParams.limit;
	                							 delete grid.getProxy().extraParams.start;
	                							 delete grid.getProxy().extraParams.academyLocationIds;
	                						 }
	                					 }
	                				 });

	                			 }
	                		 },

	                		 'sgstudentappointmentdetailgrid button[itemId=btnDelete]': {
	                			 click: this.deleteSGStudentAppointmentDetailRecord
	                		 },
	                		 'sgstudentappointmentdetailgrid button[itemId=btnAdd]': {
	                			 click: function() {
	                				 this.addSGStudentAppointmentDetailRecord('ADD');
	                				 this.setEntrybyValuebydefault();
	                				 this.setVisitStatusByDefault();
	                				 this.removePlaceHolder();
	                			 }
	                		 },
	                		 'sgstudentappointmentdetailgrid button[itemId=btnEdit]': {
	                			 click: function(obj, record) {
	                				 var $this = this,
	        	                	 contantPanel = $this.getContentPanel(),
	        						 studentProfile = contantPanel.getActiveTab(),
	        						 personinfopanel = studentProfile.down('personinfopanel');
		        						 if(personinfopanel){
	                						 activeInnerTab = personinfopanel.getActiveTab(),
	    	            					 grid = activeInnerTab.down('sgstudentappointmentdetailgrid');
	                					}else{
	                						 grid = $this.getSgstudentappointmentdetailgrid();
	                					}
	        						 if (grid.getSelectionModel().getCount() > 0) {
	                					 var record=grid.getSelectionModel().getSelection()[0];
	                					 if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment == true){
	                						 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("RESCHEDULE_APPOINTMENT_CANT_BE_EDITED"));
	                						 return;
	                					 }else{
	                						 this.editStudentAppointmentDetailRecord(obj, record);
	                					 }
	                				 }else {
	        	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	        	                	 }
	                			 }
	                		 },
	                		 'sgstudentappointmentdetailgrid button[itemId=btnView]': {
	                			 click: this.viewSGStudentAppointmentDetailRecord
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] button[itemId=submitBtn]': {
	                			 click: this.saveSGStudentAppointmentRecord
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId]  button[itemId=resetBtnForm]': {
                  			   click: function(){
                  				   var $this=this;
  	                        	   var filter = $this.getSgappointmentform();
                  				   this.resetSGStudentAppointment(filter);
                  				   this.setEntrybyValuebydefault();
                  				   this.setVisitStatusByDefault();
                  				//   filter.findField('bookingDate').setValue(new Date());
                  			   }
                  		   },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] button[itemId=viewCalendar]': {
	                			 click: this.openViewCalendarWin
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] combo[itemId=personToMeetId]': {
	                			 render: function(obj) {
	                				 var store = obj.getStore();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] combo[itemId=personToMeetFilterItemId]': {
	                			 render: function(obj) {
	                				 var store = obj.getStore();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] combo[itemId=entryById]': {
	                			 render: function(obj) {
	                				 var store = obj.getStore();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] customcombobox[itemId=viewStatusID]': {
	                			 select : function(obj, record){
	                				 var sgForm=this.getSgappointmentform();
	                				 var recVal = record[0].data.value;
	                				 var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
	                				 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                				 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                				 var chkRescheduleAppointment = sgForm.down('#chkRescheduleAppointment');
	                				 if(recVal == "Rescheduled"){
	                					 rescheduleAppointmentFld.setVisible(true);
	                					 this.setAllowBlank(rescheduleAppointmentDateId,false);
	                					 rescheduleAppointmentDateId.reset();
	                					 chkRescheduleAppointment.setValue(true);
	                				 }
	                				 else{
	                					 rescheduleAppointmentFld.setVisible(false);
	                					 this.setAllowBlank(rescheduleAppointmentDateId,true);
	                					 rescheduleAppointmentDateId.reset();
	                				 }
	                				 rescheduleAppointmentTimeId.reset();
	                				 sgForm.getForm().checkValidity();
	                			 }
	                		 },
	                         'sgappointmentform[itemId=sgappointmentformstructureItemId] checkboxfield[itemId=chkRescheduleAppointment]': {
	                        	 change : function(cmp, currentValue, oldValue, eOpts){
	                        		 var sgForm=this.getSgappointmentform();
	                        		 var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
	                        		 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                        		 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                        		 if (currentValue == true) {
	                        			 dateTimeRescheduleAppointmentItemId.setVisible(true);
	                        			 this.setAllowBlank(rescheduleAppointmentDateId,false);
	                        			 rescheduleAppointmentDateId.reset();
	                        		 }
	                        		 else{
	                        			 dateTimeRescheduleAppointmentItemId.setVisible(false);
	                        			 this.setAllowBlank(rescheduleAppointmentDateId,true);
	                        			 rescheduleAppointmentDateId.reset();
	                        		 }
	                        		 rescheduleAppointmentTimeId.reset();
	                        		 sgForm.getForm().checkValidity();
	                        	 }
	                         },
	                         ///////////////////////////////////////////////////////////////////////////////
	                         'sgappointmentform[itemId=sgappointmentformstructureItemId] filefield[itemId=documentUploadFile]' : {
 	                			change: function(DocFile, value, eOpts) {
 	                				value = value.replace('C:\\fakepath\\', '');
 	                				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
 	                				DocFile.setRawValue(newValue);
 	                				var file = DocFile.fileInputEl.dom.files[0];
 	                				var form = DocFile.up().up();
 	                				 var documentUploadFile = form.down('#documentUploadFile');
 	                                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
 	                                    if (!isNullOrEmpty(extension)) { 
	                                            if (!((extension == "png" || extension == "jpeg" || extension == "jpg" || extension == "pdf" ||  extension == "xlsx" || extension == "docx" || extension == "pptx") && (file.size / 1024) <= 10000)) {
	                                            	DocFile.reset();
	                                                showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation('UPLOAD_IMAGE_SIGNATURE'));
	                                            }
	                                            var documentUploadFile = form.down('#documentUploadFile');
	                                            documentUploadFile.setVisible(true);
	                                           // docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
	                                        } 
 	                                    else {
 	                                        if ($this.isValidFileExtension(extension)) {
 	                                            if (file.size / 1024 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT_FOR_STUDENT_DOCUMENT) {
 	                                            	documentUploadFile.setVisible(false);
 	                                            	DocFile.reset();
 	                                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_EXTENDED_ERROR_MSG'));
 	                                            } else {
 	                                                var form = DocFile.up().up();
 	                                                var documentUploadFile = form.down('#documentUploadFile');
 	                                                documentUploadFile.setVisible(true);
 	                                                var docDetails = form.down('#docDetails');
 	                                                docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
 	                                            }
 	                                        } else {
 	                                        	documentUploadFile.setVisible(false);
 	                                        	DocFile.reset();
 	                                            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
 	                                        }
 	                                    }
 	                                    
 	                			}
 	                		},
	                         
	                         
	                		 'scheduledetails[itemId=studentScheduleDetails] radiogroup[itemId=viewCalendarId]': {
	                			 change: function(obj, rec) {
	                				 if (rec.isViewCalendar) {
	                					 this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA);
	                				 } else {
	                					 this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_EVENT_DETAILS);
	                				 }
	                			 }
	                		 },
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] combo#reasonForVisitID' : {
	                			   select : function(obj,record){
	                				   var userGroupName = record[0].get("code");
	              	        		    this.enableOrDisableAdditionalReasonStudent(userGroupName);
	                			   }
	                		   },
	                		   'sgappointmentform[itemId=sgappointmentformstructureItemId] combo[itemId= academyLocationId]': {
								 render: function(obj) {
									 var this$ = this;
									 var studentId = null;
									 var items = this$.getContentPanel().items.items;

									   for (var i = 0; i < items.length; i++) {
										   var item = items[i];
										   if (item.xtype === 'studentprofile' || item.xtype === 'personinfostudentportal') {
											   studentId = item.getUserId();
											   break;
										   }
									   }
									 var store = obj.getStore();
									 store.getProxy().extraParams = {
										 enquiryStudentDetailId: null,
										 applicationId: null,
										 studentId: studentId
									 };
									   store.load();
								 }
							 },
	                		   'sgappointmentform[itemId=sgappointmentformstructureItemId] customcombobox#academyLocationId':{
	        					  select: function(obj, record) {
		                              var this$ = this;
		                              var academyLocationField = obj.up('form').down('#academyLocationId');
	        						  var programComboField = obj.up('form').down('#programId');
	        						  var batchCombo = obj.up("form").down("#batchId");
	        						  var seatCombo = obj.up('form').down('#seatTypeId');
	        						  var alValue = academyLocationField.getValue();
	        						  programComboField.reset();
	        						  programComboField.setDisabled(false);
	        						  seatCombo.reset();
	        						  seatCombo.setDisabled(true);
	        						  seatCombo.allowBlank = true;
	        						  batchCombo.reset();
	        						  batchCombo.setDisabled(true);
	        						  batchCombo.allowBlank=true;

									  var studentId = null;
									  var items = this$.getContentPanel().items.items;

									   for (var i = 0; i < items.length; i++) {
										   var item = items[i];
										   if (item.xtype === 'studentprofile' || item.xtype === 'personinfostudentportal') {
											   studentId = item.getUserId();
											   break;
										   }
									   }
	        						  programComboField.getStore().getProxy().extraParams = {
	        							  academyLocationId:alValue,
	        							  enquiryStudentDetailId: null,
										  applicationId: null,
										  studentId: studentId
	        						  }
	        			    	 	  this$.loadDFRForManageAppointment(academyLocationField);
	        			    	 	  programComboField.getStore().load();
								 }
							 },
	        				  'sgappointmentform[itemId=sgappointmentformstructureItemId] customcombobox#programId': {
	        					  select: function(obj, record) {
		                              var this$ = this;
	        						  var programId = record[0].get("id");
	        						  var batchCombo = obj.up('form').down('#batchId');
	        						  var seatCombo = obj.up('form').down('#seatTypeId');
	        						  batchCombo.reset();
	        						  batchCombo.setDisabled(false);
	        						  seatCombo.reset();
	        						  seatCombo.setDisabled(true);
	        						  seatCombo.allowBlank = true;			
	        						  var academyLocationId = obj.up('form').down("#academyLocationId");
	        			    	 	  this$.loadDFRForManageAppointment(academyLocationId);

									  var studentId = null;
									  var items = this$.getContentPanel().items.items;

									   for (var i = 0; i < items.length; i++) {
										   var item = items[i];
										   if (item.xtype === 'studentprofile' || item.xtype === 'personinfostudentportal') {
											   studentId = item.getUserId();
											   break;
										   }
									   }
	        						  batchCombo.getStore().getProxy().extraParams = {
	        							  programId: programId,
	        							  enquiryStudentDetailId: null,
										  applicationId: null,
										  studentId: studentId
	        						  };
	        						  batchCombo.getStore().load();
									  obj.up('form').isValid();
								 }
							 },
	        				  'sgappointmentform[itemId=sgappointmentformstructureItemId] customcombobox#batchId': {
	        					  select: function(obj, record) {
		                              var this$ = this;
	        						  var batchId = record[0].get("id");
	        						  var seatCombo = obj.up('form').down('#seatTypeId');
	        						  seatCombo.reset();
	        						  seatCombo.setDisabled(false);
	        						  var academyLocationId = obj.up('form').down("#academyLocationId");
	        			    	 	  this$.loadDFRForManageAppointment(academyLocationId);
	        			    	 	  
									  var studentId = null;
									  var items = this$.getContentPanel().items.items;

									   for (var i = 0; i < items.length; i++) {
										   var item = items[i];
										   if (item.xtype === 'studentprofile' || item.xtype === 'personinfostudentportal') {
											   studentId = item.getUserId();
											   break;
										   }
									   }
	        						  seatCombo.getStore().getProxy().extraParams = {
	        							  batchId: batchId,
	        							  enquiryStudentDetailId: null,
										  applicationId: null,
										  studentId: studentId
	        						  };
	        						  seatCombo.getStore().load();
									  obj.up('form').isValid();
								 }
							 },
	                		   'sgappointmentform[itemId=sgappointmentformstructureItemId] datefield[itemId=appointmentId]': {
	                			 change: function(obj,record) {
	                				 var sgForm=this.getSgappointmentform();
	                				 var isAppointeeItemId=sgForm.down("#isAppointeeItemId");
	                				 var currentDate = Ext.Date.format(new Date() ,'Y-m-d');
	                				 var appointmentDate = Ext.Date.format(record ,'Y-m-d');
	                				 if(obj.itemId == 'appointmentId'){
	                					 if(currentDate>appointmentDate){
	                						 isAppointeeItemId.setValue({isAppointee:false});
	                					 }else{
	                						 isAppointeeItemId.setValue({isAppointee:true});
	                					 }
	                				 }
	                			 }
	                		 },
	                		 //////////////////////////////////////////////////////////////////
	                		 'sgappointmentform[itemId=sgappointmentformstructureItemId] displayfield[itemId=pathId]':{  
                  			   afterrender: function(fld){
                  				   fld.el.on("click", function(){
                      				   var documentId= Ext.getCmp(this.id).documentId;
                      				   if(!isNullOrEmpty(documentId)){
                                             Ext.Ajax.request({
                                                 type: 'rest',
                                                 url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
                                                 method: 'GET',
                                                 callback : function(opt, success, response){
                                                     if(response.responseText == 'true') {
                                                         var csvForm = Ext.create('Ext.form.Panel'); 
                                                         csvForm.getForm().submit({
                                                             target: '_blank',
                                                             method:'GET',
                                                             params :{
                                                                 access_token : Ext.Ajax.defaultHeaders.access_token
                                                             },
                                                             headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                                                             url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
                                                             standardSubmit :true
                                                         });
                                                     } else {
                                                         showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
                                                     }
                                                 }
                                             });
                                         }
                      				   
                      				   
                      			   });
                  			   }
                  		   },
	                	   'sgstudentappointmentdetailgrid button[itemId=followUpDetailBtnId]':{
	                		   click:function(){
	                			   this.isFollowUpBtn=true;
	                			   var contentPanel = this.getContentPanel();
	                			   var tabName = getMegaMenuTranslation('SP_APPOINTMENT_FOLLOW_UP');
	                			   var structure = Ext.widget('sgappointmentfollowupstructureforsp', {
	                				   itemId: 'sgappointmentfollowupstructureforspItemId'
	                			   });
	                			   /**
	                			    * This is to remove tab from content panel and open same tab again
	                			    */
	                			   var getcontroller = this.getController('menu.CoreERPNavigationController');
	                			   var getTab = getcontroller.getTab(tabName);
	                			   if (getTab != null) {
	                				   contentPanel.remove(getTab, true);
	                			   }
	                			   openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_SIX);
	                		   }
	                	   },
	                	   'sgfollowupdetailsgridforsp':{
	                		   render:function(grid){
	                			   this.doAccessControlValidation(grid, this.getSP_STUDENT_APPOINTMENT_FOLLOW_UP_PERMISSIONS());
	                		   }
	                	   },
	                	   'sgappointmentfollowupstructureforsp':{
	                		   afterrender:function(structure){
	                			   var appointmentGrid = this.getSgstudentappointmentdetailgrid();
	                			   var grid = structure.down('#sgfollowupdetailsgridforsp');
	                			   var userInfo=this.getCurrentlyLoggedInUserInfoForPortal();
	                			   var store = grid.getStore();
	                			   var appointmentId=null;
	                			   if(appointmentGrid &&  this.isFollowUpBtn){
	                				   var rec = appointmentGrid.getSelectionModel().getSelection();
	                				   appointmentId = rec[0].data.id;
	                			   }
	                			   store.getProxy().extraParams = {
	                				   appointmentId : appointmentId,
	                				   id:userInfo.student.id
	                			   };
	                				   store.load({
	                					   callback:function(records){
	                						   if(records.length>0){
	                							   grid.down('#appointmentField').setValue(records[0].data.sgAppointment.code+" / "+records[0].data.sgAppointment.value);
	                						   }else{
	                							   grid.down('#appointmentField').setValue(rec[0].data.bookingId+" / "+rec[0].data.appointeeName);
	                						   }
	                					   }
	                				   });
	                			   this.isFollowUpBtn=false;
	                		   }
	                	   }, 'sgappointmentform[itemId=sgappointmentformstructureItemId] radiogroup[itemId=flagRelatedRadio]':{
                               change: function(cb, nv, ov){
                                   var $this = this;
                                   var form = $this.getSgappointmentform();
                                   var flagId = form.down("#flagUserId");
                                   flagId.reset();
                                   if(nv.isRelatedToFlag ==  true){
                                       flagId.setVisible(true);
                                       flagId.setDisabled(false)
                                   }
                                   else{
                                      flagId.setVisible(false)
                                      flagId.setDisabled(true);
                                   }
                                   this.loadDFRForIsThisRelatedToFlag(form);
                                   form.getForm().checkValidity();
                               }
                           },
                           'sgappointmentform':{  
                  			   afterrender: function(form){
                  				   this.loadDFRForIsThisRelatedToFlag(form);
                  			   }
                           }
	                	 });
	                 },
	                 setEntrybyValuebydefault: function() {
	                	 var userId = this.getCurrentlyLoggedInUser();
	                	 var sgForm = this.getSgappointmentform();
	                	 var entryByField = sgForm.down("#entryById");
	                	 entryByField.setValue(this.getCurrentlyLoggedInUser().id);
	                	 
	                	/* entryByField.store.load({
	                		 callback: function(operation, success) {
	                			 if (success) {
	                				 entryByField.setValue(userId.id);
	                			 }
	                		 }
	                	 });*/
	                 },
	                 setVisitStatusByDefault: function(){
                  	   var sgForm=this.getSgappointmentform();
                  	   var viewStatusID = sgForm.down("#viewStatusID");
              		   var viewStatusIDStore = viewStatusID.getStore();
              		   viewStatusID.setReadOnly(true);
              		   viewStatusIDStore.load({
              			   callback:function(records,operation,success){
              				   var rec = viewStatusIDStore.findRecord('code','Booked');
              				   if(!isNullOrEmpty(rec)){
              					   var idVal = rec.get('id');
              					   viewStatusID.setValue(idVal);
              				   }
              			   }
              		   });  
                     },

	               /*  deleteSGStudentAppointmentDetailRecord: function() {
	                	 var $this = this;
	                	 var grid = $this.getSgstudentappointmentdetailgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			 if (btn == 'yes') {
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 var records = grid.getSelectionModel().getSelection();
	                				 var id = records[0].get("id");
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url: SERVERURL.SG_APPOINTMENT_DELETE + '?id=' + id,
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {
	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
	                						 $this.resetPageSetting(store);
	                						 grid.getStore().reload();
	                					 }

	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                	 }
	                 },*/
	                 addSGStudentAppointmentDetailRecord: function(openView, submitPortal) {
	                	 var me = this;
	                	 personObjStudentAppointment = me.getPersonObj();
	                	 var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                	 var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
	                	 var structure = Ext.widget('sgappointmentform', {
	                		 itemId: 'sgappointmentformstructureItemId'
	                	 });
	                	 /**
	                	  * This is to remove tab from content panel and open same tab again
	                	  */
	                	 var getcontroller = this.getController('menu.CoreERPNavigationController');
	                	 var getTab = getcontroller.getTab(tabName);
	                	 if (getTab != null) {
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_SEVEN);
	                	 var visitorCategoryIDCombo = Ext.ComponentQuery.query("#visitorCategoryID")[0];
	                	 var visitorCategoryIDComboStore = visitorCategoryIDCombo.getStore();
	                	 visitorCategoryIDComboStore.load({

	                		 callback: function(record) {
	                			 for (var i in record) {
	                				 if (record[i].data.id == 3) {
	                					 var portalId = me.getCurrentLoggedPortalId();
	                					 visitorCategoryIDCombo.setValue(record[i].data.id);
	                					 visitorCategoryIDCombo.resetOriginalValue();
	                					 visitorCategoryIDCombo.setReadOnly(true);
	                					 visitorCategoryIDCombo.setVisible(false);

	                					 var sgForm = me.getSgappointmentform();
	                					 sgForm.down("#bookingId").allowBlank=true;
	                					 sgForm.down("#appointeeNameId").setVisible(false);
	                					 sgForm.down("#facAppointmentId").setVisible(false);
	                					 var applicantNameField =sgForm.down("#applicantNameId");
	                					 applicantNameField.setVisible(false);
	                					 /** *************** */
	                					 var studentNameField = sgForm.down("#studentItemId"); 
	                					 var studentCombo = Ext.ComponentQuery.query("#studentItemId")[0]; // sgForm.down("#studentItemId");
	                					 studentCombo.setVisible(true);
	                					 var entryByField = sgForm.down("#entryById");
            							 var entryByNameItem = sgForm.down("#entryByNameItemId");
	                					 var studentComboStore = studentCombo.getStore();
	                					 var a = personObjStudentAppointment;
	                					 
	                					 
	                					 /*for show hide fuctionality for entry by*/
	                					 if(portalId == 3){
	                						 var entryByNameItem = sgForm.down("#entryByNameItemId");
	                						 var entryByItem = sgForm.down("#entryById");
	                						 if(submitPortal == 3){
	                							 entryByNameItem.setVisible(true);
	                							 entryByItem.setVisible(false);
	                							 entryByItem.allowBlank = true; // uncomment for Bug: V2D-41118

	                						 }else{
	                							 if(openView == 'ADD'){
	                								 entryByNameItem.setVisible(true);
	                								 entryByNameItem.setReadOnly(true);
	                								 entryByItem.setVisible(false);
	                								 entryByItem.allowBlank = true; // uncomment for Bug: V2D-41118
	                							 }else{
	                								 entryByNameItem.setVisible(false);
	                								 entryByNameItem.setReadOnly(true);
	                								 entryByItem.setVisible(true);
	                								// entryByItem.allowBlank = true;  
	                							 }  
	                						 }
	                					 }else{
	                						 // appointeeEmailField.setValue(emailId);
	                						 // mobileNoField.setValue(mobileNo);
	                						 // applicantCombo.setReadOnly(true);
	                						 var entryByNameItem = sgForm.down("#entryByNameItemId");
	                						 var entryByItem = sgForm.down("#entryById");

	                						 if(submitPortal == 3){
	                							 entryByNameItem.setVisible(true);
	                							 entryByNameItem.setReadOnly(true);
	                							 entryByItem.setVisible(false);
	                							 entryByItem.allowBlank = true; // uncomment for Bug: V2D-41118
	                						 }else{
	                							 entryByNameItem.setVisible(false);
	                							 entryByItem.setVisible(true);
	                							// entryByItem.allowBlank = false;
	                						 }
	                					 }


	                					 Ext.Ajax.request({
	                						 type: 'rest',
	                						 url: SERVERURL.FIND_STUDENT_BY_PERSON_ID,
	                						 params: {
	                							 id: a.id,
	                						 },
	                						 method: 'GET',
	                						 async: false,
	                						 success: function(form,action) {
	                							 var studentData = Ext.JSON.decode(form.responseText);

	                							 var leadStore = studentNameField.getStore();
	                							 studentNameField.setReadOnly(true);
	                							 studentComboStore.getProxy().extraParams = {
	                								 studentNameOrCode: studentData.code
	                							 };
	                							 var flagRelatedId = sgForm.down("#flagUserId");
	                                             
	                							 studentComboStore.load({
	                								 callback: function(record) {
	                									 for (var i in record) {
	                										 flagRelatedId.getStore().getProxy().extraParams = {
	          	                                          	   studentId: record[i].data.id
	          	                							 };
	                										 //studentNameField.setValue(me.getCurrentlyLoggedInUser().id);
	                										 studentNameField.setValue(record[i].data.id);
 	                										 entryByNameItem.setValue(me.getCurrentlyLoggedInUser().value);
	                									 }
	                								 }
	                							 });
	                							 var stdMailId = studentData.person.emailId;
	                							 var mobNumber = studentData.person.mobileNumber;
	                							 var mCountryCode = studentData.person.mobileCountryCode;
	                							 var appointeeEmailField = sgForm.down("#appointeeEmailItemId");
	                							 appointeeEmailField.setValue(stdMailId);
	                							 appointeeEmailField.setReadOnly(true);
	                							 var mobileNoField = sgForm.down("#mobileNo");
	                							 mobileNoField.setValue(mobNumber);
	                							 mobileNoField.setReadOnly(true);
	                							 var cellCountryCodeField = sgForm.down("#cellCountryCode");
	                							 cellCountryCodeField.getStore().load({
	                								 callback: function(record) {
	                									 cellCountryCodeField.setValue(mCountryCode);
	                								 }
	                							 });
	                							
	                							 cellCountryCodeField.setReadOnly(true);

	                						 }
	                					 });
	                					 /** *************** */
	                					 var enquiryCombo = sgForm.down("#leadId");
	                					 enquiryCombo.setVisible(false);
	                					 var appointeeNameField = sgForm.down('#appointeeNameId');
	                					 var parentGuardian = sgForm.down("#appointeeNameParentId");
	                					 var EmployeeNameField =sgForm.down("#facAppointmentId");
	                					 var reasonForVisitID = sgForm.down("#reasonForVisitID");
	                					 var visitCatId = record[i].data.id;
		             	    			   var reasonForVisitStore=reasonForVisitID.getStore();
		             	    			   reasonForVisitStore.getProxy().extraParams = {
		             	    				  id : visitCatId,
		             	    				 
		             	    			  };

	                					 appointeeNameField.allowBlank = true;
	                					 parentGuardian.allowBlank = true;
	                					 enquiryCombo.allowBlank = true;
	                					 EmployeeNameField.allowBlank = true;
	                					 applicantNameField.allowBlank = true;
	                					 
	                					 if(openView == 'ADD'){
	                						 var submitPortalData = sgForm.down("#submitPortalId")
	                						 submitPortalData.setValue(portalId);
	                					 }

	                					 var locations = [];
	                					 var academyLocationList = Academia.utilities.accessControl.AccessControlManager
	                					 .getAllocatedAcademyLocations();
	                					 for (var i = 0; i < academyLocationList.length; i++) {
	                						 locations
	                						 .push(academyLocationList[i].id);
	                					 }
	                					 
	                					 var newMandatoryFields = ['studentItemId'];
	                                 	
										 Ext.Ajax.request({
											 url: SERVERURL.COMMON_FORM_FIELD_INFO,
											 method: 'GET',
											 async: false,
											 params: {
												 academyLocationId: me.getCurrentAcademyLocation(),
												 languageCode: 'en'
											 },
											 success: function(response) {
												 var json = JSON.parse(response.responseText);
												 var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
												 fieldInfo.set("formFieldsInfo", json);
												 var academyLocationId = sgForm.down("#academyLocationId");
												 var programId = sgForm.down("#programId");
												 var batchId = sgForm.down("#batchId");
												 var seatTypeId = sgForm.down("#seatTypeId");
												 if (!isNullOrEmpty(json)) {
													 if (!isNullOrEmpty(json.sgappointmentform)) {
														 var sgappointmentformDFRConfig = json.sgappointmentform;
														 for (i in sgappointmentformDFRConfig) {
															 var fieldConfig = sgappointmentformDFRConfig[i];
															 if (newMandatoryFields.includes(fieldConfig.formFieldId)) {
																 if (fieldConfig.isVisible) {
																	 var currentField = sgForm.down("#" + fieldConfig.formFieldId);
																	 currentField.setVisible(true);
																 } else {
																	 var currentField = sgForm.down("#" + fieldConfig.formFieldId);
																	 currentField.setVisible(false);
																 }
															 }
														 }
													 } else {
														 academyLocationId.setVisible(false);
														 academyLocationId.reset();
														 programId.setVisible(false);
														 programId.reset();
														 batchId.setVisible(false);
														 batchId.reset();
														 seatTypeId.setVisible(false);
														 seatTypeId.reset();
													 }
												 }
											 }
										 });
	                				 };
	                			 }
	                		 }
	                	 })
	                 },

	                 editStudentAppointmentDetailRecord: function() {
	                	 var $this = this,activeInnerTab,grid,
	                	 contantPanel = $this.getContentPanel(),
						 studentProfile = contantPanel.getActiveTab(),
						 personinfopanel = studentProfile.down('personinfopanel');
						 if(personinfopanel){
    						 activeInnerTab = personinfopanel.getActiveTab();
        					 grid = activeInnerTab.down('sgstudentappointmentdetailgrid');
    					}else{
    						 grid = $this.getSgstudentappointmentdetailgrid();
    					}
						 if (grid.getSelectionModel().getCount() > 0) {
	                		 var record = grid.getSelectionModel().getSelection()[0];
	                		 var submitPortalRecord = record.data.submitPortalId;
	                		 this.addSGStudentAppointmentDetailRecord('EDIT',submitPortalRecord);
	                		 var sgForm = this.getSgappointmentform();
	                		 var portalId = $this.getCurrentLoggedPortalId();
	                		 var dataModel = new Academia.model.sgappointment.sgappointment.SGAppointmentModel(record.data);
	                		 sgForm.loadRecord(dataModel);
	                		 /////////////////////////////////////////
	                		  if(record.document && record.raw.document.path!='file'){
                                   sgForm.down("#pathId").documentId = record.raw.document.encryptedDocId;
                                  sgForm.down("#pathId").setValue('<a href="#">' + record.raw.document.path + '</a>');
                                  }else{
                                    sgForm.down("#pathId").documentId = null;
                                     sgForm.down("#pathId").setValue(null);
                                 } 
	                		 
	                		 var bookingId = sgForm.down("#bookingId");
	                		 bookingId.setReadOnly(true);
	                		 sgForm.down("#visitTimeId").setValue(timeRender(record.data.visitTime));
	                		 sgForm.down("#outTimeId").setValue(timeRender(record.data.expectedOutTime));
	                		 sgForm.down("#bookingDateId").setValue(dateRender(record.data.bookingDate));
	                		 sgForm.down("#appointmentId").setValue(dateRender(record.data.appointmentDate));
	                		 sgForm.down("#flagUserId").getStore().getProxy().extraParams={
	                			 studentId:record.data.userId
	                		 }
	                				 sgForm.down("#flagUserId").getStore().load({
	                				 callback:function(records){
	                					 sgForm.down("#flagUserId").setValue(record.data.flagUserId);
	                				 }
	                			 })
	                		 var isAppointeeItemId =  sgForm.down("#isAppointeeItemId");
	                		 isAppointeeItemId.setValue({isAppointee:record.data.isAppointeeAppointment});
	                		 
	                		 /* for entry by hide and show*/
	                		 if(!isNullOrEmpty(submitPortalRecord)){
	                			 sgForm.down("#submitPortalId").setValue(submitPortalRecord);
	                		 }else{
	                			 sgForm.down("#submitPortalId").setValue(1);
	                		 }
	                		var academyLocationId=sgForm.down("#academyLocationId");
	                 		var programId = sgForm.down("#programId");
	                 		var batchId = sgForm.down("#batchId");
	                 		var seatTypeId = sgForm.down("#seatTypeId");
                            var studentId = record.data.userId;	
                            academyLocationId.getStore().getProxy().extraParams = {
								 enquiryStudentDetailId: null,
								 applicationId: null,
								 studentId: studentId
	             			}             			
	                 		if(record.data.academyLocation != null){
	                 			programId.setDisabled(false);
	                 			academyLocationId.store.load({
		                        callback: function(recordss, operation, success) {
    							 if (success) {
    								for(i in recordss){
    									if(recordss[i].data.id == record.data.academyLocation.id){
    										academyLocationId.setValue(recordss[i].data.id);
    									}
    								}
    							 }
    						    }
	                 			});
	                 			
	                 			programId.getStore().getProxy().extraParams = {
	               				  academyLocationId:record.data.academyLocation.id,
	               				  enquiryStudentDetailId: null,
	               				  applicationId: null,
								  studentId: studentId
	               			    }
	                 			if(record.data.program != null){
	                 			   batchId.setDisabled(false);
	               			       programId.getStore().load({
	                   			     callback: function(recordss, operation, success) {
    							       if (success) {
    								     for(i in recordss){
    									  if(recordss[i].data.id == record.data.program.id){
    										programId.setValue(recordss[i].data.id);
    									  }
    								     }
    							       }
    						          }
	                   		       });
	               			       
	               			      batchId.getStore().getProxy().extraParams = {
										programId: record.data.program.id,
										enquiryStudentDetailId: null,
										applicationId: null,
										studentId: studentId
	               				  }
	               			      if(record.data.batch != null){
	               			    	 seatTypeId.setDisabled(false);
	               				     batchId.getStore().load({
	               	    			 callback: function(recordss, operation, success) {
    							       if (success) {
    								     for(i in recordss){
    									  if(recordss[i].data.id == record.data.batch.id){
    										batchId.setValue(recordss[i].data.id);
    									  }
    								     }
    							        }
    						         }
	               	    		     });
	               				   seatTypeId.getStore().getProxy().extraParams = {
	               					    batchId: record.data.batch.id,
									    enquiryStudentDetailId: null,
									    applicationId: null,
									    studentId: studentId
	               				   }
	               				  if(record.data.progBatchSeatConfig != null){
	               				      seatTypeId.getStore().load({
	               	    			  callback: function(recordss, operation, success) {
    							        if (success) {
    								      for(i in recordss){
    									    if(recordss[i].data.id == record.data.progBatchSeatConfig.id){
    										   seatTypeId.setValue(recordss[i].data.id);
    									    }
    								      }
    							        }
    						         }
	               	    		     });
	               				   }  
	               			     }else{
	               			    	seatTypeId.setDisabled(true);
	                    			seatTypeId.allowBlank=true;
	               			     }
	                 		    }else{
	                 		    	 batchId.setDisabled(true);
	                     			 batchId.allowBlank=true;
	                     			 seatTypeId.setDisabled(true);
	                     			 seatTypeId.allowBlank=true;
	                 		    }
	                 		}else{
	                 			 programId.setDisabled(true);
	                 			 programId.allowBlank=true;
	                 			 batchId.setDisabled(true);
	                 			 batchId.allowBlank=true;
	                 			 seatTypeId.setDisabled(true);
	                 			 seatTypeId.allowBlank=true;
	                 		}
	                		 var visitorCategory = sgForm.down("#visitorCategoryID");
	                		 if (record.data.visitorCategory != null) {
	                			 visitorCategory.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 visitorCategory.setValue(record.data.visitorCategory.id);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 var entryByField = sgForm.down("#entryById");
	                		// entryByField.setReadOnly(true);
	                		 if(portalId == 3){
	                			 entryByField.setReadOnly(true);
	                		 }else{
	                			 entryByField.setReadOnly(false); 
	                		 }
	                		 /*for entry by hide and show*/
	                		 var entryByNameItem = sgForm.down("#entryByNameItemId");
	                		 if(record.data.submitPortalId == 3){
	                			 entryByNameItem.setVisible(true);
	                			 entryByNameItem.setReadOnly(true);
	                			 entryByField.setVisible(false);
	                			// entryByField.allowBlank = true;
	                			 entryByNameItem.setValue(record.data.appointeeName);
	                		 }else{
	                			 entryByNameItem.setVisible(false);
	                			 // entryByNameItem.setReadOnly(false);
	                			 entryByField.setVisible(true);
	                			 //entryByField.allowBlank = false;
	                			 if (record.data.entryBy != null) {
	                				 entryByField.store.getProxy().extraParam = {
	                					 academyLocationIds: this.getCurrentAcademyLocation()
	                				 }
	                				 entryByField.store.load({
	                					 callback: function(records, operation, success) {
	                						 if (success) {
	                							 entryByField.setValue(record.data.entryBy.id);
	                						 }
	                					 }
	                				 });
	                			 }
	                		 }
	                		 var personToMeetId = sgForm.down("#personToMeetId");
	                		 if (record.data.personToMeet != null) {
	                			 personToMeetId.store.getProxy().extraParam = {
	                				 academyLocationIds: this.getCurrentAcademyLocation()
	                			 }
	                			 personToMeetId.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 //personToMeetId.setRawValue(record.data.personToMeet);
	                						 if(!isNullOrEmpty(record.data.personToMeetId)){
	                							 personToMeetId.setValue(record.data.personToMeetId.id);
	                						 }
	                					 }
	                				 }
	                			 });
	                		 }
	                		 var appointeeNameField = sgForm.getForm().findField('appointeeName');

	                		 var studentNameField = sgForm.down("#leadId");
	                		 var parentGuardian = sgForm.down("#appointeeNameParentId");
	                		 var leadNameField =  sgForm.down("#leadId");
	                		 var empNameField =  sgForm.down("#facAppointmentId");
	                		 var applicantNameField =  sgForm.down("#applicantNameId");
	                		 if (record.data.visitorCategory.id == 1) {
	                			 parentGuardian.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 parentGuardian.setValue(record.data.person.id);
	                					 }
	                				 }
	                			 });
	                			 parentGuardian.setVisible(true);
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;

	                			 studentNameField.setVisible(false);
	                			 studentNameField.allowBlank = true;
	                			 applicantNameField.setVisible(false);
	                			 applicantNameField.setReadOnly(true);
	                			 applicantNameField.allowBlank = true;
	                			 visitorCategory.setReadOnly(false);
	                		 } else if (record.data.visitorCategory.id == 2) {
	                			 studentNameField.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 studentNameField.setValue(record.data.enquiry.id);
	                					 }
	                				 }
	                			 });
	                			 studentNameField.setVisible(false);
	                			 studentNameField.setReadOnly(true);
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;
	                			 parentGuardian.setVisible(false);
	                			 parentGuardian.allowBlank = true;
	                			 leadNameField.setVisible(false);
	                			 leadNameField.setReadOnly(true);
	                			 leadNameField.allowBlank = true;
	                			 applicantNameField.setVisible(false);
	                			 applicantNameField.setReadOnly(true);
	                			 applicantNameField.allowBlank = true;

	                			 visitorCategory.setReadOnly(true);
	                		 } else if(record.data.visitorCategory.id == 3){
	                			 studentNameField.store.load({
	                				 callback : function(records,operation,success) {
	                					 if (success) {
	                						 studentNameField.setValue(record.data.student.id);
	                					 }
	                				 }
	                			 });
	                			 studentNameField.setVisible(true);
	                			 studentNameField.allowBlank = false;
	                			 studentNameField.setReadOnly(true);
	                			 leadNameField.setVisible(false);
	                			 leadNameField.setReadOnly(true);
	                			 leadNameField.allowBlank = true;
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;
	                			 parentGuardian.setVisible(false);
	                			 parentGuardian.allowBlank = true;
	                			 visitorCategory.setReadOnly(true);
	                			 empNameField.setVisible(false);
	                			 empNameField.setReadOnly(true);
	                			 empNameField.allowBlank = true;
	                			 
	                			 applicantNameField.setVisible(false);
	                			 applicantNameField.setReadOnly(true);
	                			 applicantNameField.allowBlank = true;
	                			 
	                		 }else if(record.data.visitorCategory.id == 4){
	                			 empNameField.getStore().load({
	                				 callback : function(records,operation,success) {
	                					 if (success) {
	                						 empNameField.setValue(record.data.staff.id);
	                					 }
	                				 }
	                			 });
	                			 empNameField.setVisible(true);
	                			 empNameField.setReadOnly(true);
	                			 leadNameField.setVisible(false);
	                			 leadNameField.setReadOnly(false);
	                			 leadNameField.allowBlank = true;
	                			 appointeeNameField.setVisible(false);
	                			 appointeeNameField.allowBlank = true;
	                			 parentGuardian.setVisible(false);
	                			 parentGuardian.allowBlank = true;
	                			 studentNameField.setVisible(false);
	                			 studentNameField.allowBlank = true;
	                			 applicantNameField.setVisible(false);
	                			 applicantNameField.setReadOnly(true);
	                			 applicantNameField.allowBlank = true;
	                			 visitorCategory.setReadOnly(true);
	                		 }else {
	                			 parentGuardian.allowBlank = true;
	                			 studentNameField.allowBlank = true;
	                			 visitorCategory.setReadOnly(false);
	                			 leadNameField.allowBlank = true;
	                			 appointeeNameField.allowBlank = true;
	                			 applicantNameField.allowBlank = true;
	                		 }
	                		 var mobileField = sgForm.down("#mobileNo");
	                		 var countryCodeField = sgForm.down("#cellCountryCode");
	                		 var str = record.data.appointeeContactNo;
	                		 var spiltMobileNo;
	                		 if (str != null) {
	                			 spiltMobileNo = str.split("-");
	                		 }
	                		 if (record.data.appointeeContactNo != null) {
	                			 if (spiltMobileNo.length == 2) {
	                				 //countryCodeField.setValue(spiltMobileNo[0]);
	                				 countryCodeField.getStore().load({
	                   					 callback: function(records, operation, success) {
	                   						  if (success) {
	                   							  for(i in records){
	               									  if(records[i].data.value == spiltMobileNo[0]){
	               										countryCodeField.setValue(records[i].data.isdCode);  									  
	                   								  }
	                   							  }
	                   						  }
	                   					  }
	                   				  });
		                			  mobileField.setValue(spiltMobileNo[1]);
	                			  }

	                		 }
	                		 /*added for visit status and reason to visit*/
	                		 var visitStatusCombo = sgForm.down("#viewStatusID");
	                		 var reasonForVisitCombo = sgForm.down("#reasonForVisitID");

	                		 if (record.data.sgReasonForVisit != null) {
	                			 var userGroupName = record.data.sgReasonForVisit.code;
           	        		    this.enableOrDisableAdditionalReasonStudent(userGroupName);
	                			 reasonForVisitCombo.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 reasonForVisitCombo.setValue(record.data.sgReasonForVisit.id);
	                					 }
	                				 }
	                			 });
	                		 }

	                		 if (record.data.sgVisitStatus != null) {
	                			 visitStatusCombo.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 visitStatusCombo.setValue(record.data.sgVisitStatus.id);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 sgForm.down('#resetBtnForm').setVisible(false);
	                		 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                		 var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                		 this.setAllowBlank(rescheduleAppointmentDateId,true);
	                		 if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Completed"){
	                			 sgForm.down('#submitBtn').setVisible(false);
	                			 //var viewStatusID = sgForm.down('#viewStatusID');
	                			 sgForm = sgForm.getForm();
	                			 //viewStatusID.setReadOnly(true);
	                			 toggleReadOnlyFormItems(sgForm, true);
	                		 }
	                		 else if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Rescheduled"){
	                			 var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
	                			 var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
	                			 if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment){
	                				 dateTimeRescheduleAppointmentItemId.setVisible(true);
	                				 var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                				 rescheduleAppointmentDateId.setValue(dateRender(record.data.rescheduleDate));
	                				 if(!isNullOrEmpty(record.data.rescheduleTime)){
	                					 sgForm.down("#rescheduleAppointmentTimeId").setValue(timeRender(record.data.rescheduleTime));
	                				 }
	                			 }
	                			 else{
	                				 dateTimeRescheduleAppointmentItemId.setVisible(false);
	                				 rescheduleAppointmentDateId.reset();
	                				 rescheduleAppointmentTimeId.reset();
	                			 }
	                			 rescheduleAppointmentFld.setVisible(true);
	                		 }
	                		 else{
	                			 rescheduleAppointmentDateId.reset();
	                			 rescheduleAppointmentTimeId.reset();
	                		 }
	                		 
	                		 var enqIntermediateStage = sgForm.down("#enqIntermediateStage");
	                		 // var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
	                		 if (record.data.enqIntermediateType != null) {
	                			 enqIntermediateStage.store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 enqIntermediateStage.setValue(record.data.enqIntermediateType.id);
	                					 }
	                				 }
	                			 });
	                		 }
	                		 
	                	 } else {
	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                	 }
	                 },
	                 viewSGStudentAppointmentDetailRecord: function() {
	                	 var $this = this,activeInnerTab,grid,
	                	 contantPanel = $this.getContentPanel(),
						 studentProfile = contantPanel.getActiveTab(),
						 personinfopanel = studentProfile.down('personinfopanel');
						 if(personinfopanel){
    						 activeInnerTab = personinfopanel.getActiveTab();
        					 grid = activeInnerTab.down('sgstudentappointmentdetailgrid');
    					}else{
    						 grid = $this.getSgstudentappointmentdetailgrid();
    					}
					var sgForm = $this.getSgappointmentform();
	                	 this.editStudentAppointmentDetailRecord();
	                	 if (grid.getSelectionModel().getCount() > 0) {
		                	 var sgForm = this.getSgappointmentform();
		                	 sgForm.down('#submitBtn').setVisible(false);
		                	 sgForm.down('#resetBtnForm').setVisible(false);
		                	 sgForm = sgForm.getForm();
		                	 toggleReadOnlyFormItems(sgForm, true);
	                	 }
	                 },
	                 enableOrDisableAdditionalReasonStudent:function(userGroupName) {
                        	
                  	   var form = this.getActiveTabfromContentPanel().down('sgappointmentform');
                  	   
                     	if(userGroupName == 'Other'){
                 	    	
                 	    	form.down('#additionalReasonToVisitItemId').setDisabled(false);
                 	    	form.down('#additionalReasonToVisitItemId').allowBlank = false;
                 	    } 
                     	else{ form.down('#additionalReasonToVisitItemId').setDisabled(true);
             	    	form.down('#additionalReasonToVisitItemId').allowBlank = true;
             	    	form.down('#additionalReasonToVisitItemId').reset();
                     	}
                     		
                     	
                     	var valid = form.isValid();
                     	if(!valid) {
                     		form.down('#submitBtn').setDisabled(true);
                     	}
                     },
	                 deleteSGStudentAppointmentDetailRecord: function() {
	                	 var $this = this;
	                	 var grid = $this.getSgstudentappointmentdetailgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                			 if (btn == 'yes') {
	                				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				 var records = grid.getSelectionModel().getSelection();
	                				 var id = records[0].get("id");
	                				 Ext.Ajax.request({
	                					 method: "DELETE",
	                					 type: 'rest',
	                					 url: SERVERURL.SG_APPOINTMENT_DELETE + '?id=' + id,
	                					 headers: {
	                						 'Content-Type': 'application/json'
	                					 },
	                					 success: function(form, action) {
	                						 Ext.getBody().unmask();
	                						 showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
	                						 $this.resetPageSetting(grid.getStore());
	                						 grid.getStore().reload();
	                					 }
	                				 });
	                			 }
	                		 });
	                	 } else {
	                		 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                	 }
	                 },
	                 /////////////////////////////////////////////////////////////////
	                 
	                 getDocumentController : function() {
                   		var this$ = this;
                   		return this$.getController('Academia.controller.document.DocumentController');
                   	},
	                 
	                 
	                 saveSGStudentAppointmentRecord: function() {
	                	 // Create required json to Save
	                	 var $this = this;
	                	 var sgForm = $this.getSgappointmentform();
	                	 var academyLocationId = sgForm.down("#academyLocationId");
	              	     var programId = sgForm.down("#programId");
	              	     var batchId = sgForm.down("#batchId");
	              	     var seatTypeId = sgForm.down("#seatTypeId");
	              	     if(!academyLocationId.isVisible()){
	              		     academyLocationId.reset();
	              	     }
	              	     if(!programId.isVisible()){
	              		     programId.reset();
	              	     }
	              	     if(!batchId.isVisible()){
	              		     batchId.reset();
	              	     }
	              	     if(!seatTypeId.isVisible()){
	              		     seatTypeId.reset();
	              	     }
	                	 var parentStore = sgForm.down("#appointeeNameParentId").getStore();
	                	 var sgFormValues = sgForm.getValues();
	                	 var submitUrl, isUpdate = false;
	                	 var contentPanel = $this.getContentPanel();
	                	 var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
	                	 var grid = $this.getSgstudentappointmentdetailgrid();
	                	 var getcontroller = $this.getController('menu.CoreERPNavigationController');
	                	 var portalId = $this.getCurrentLoggedPortalId();
	                	 var submitPortalData = sgForm.down("#submitPortalId").getValue();
	                	 var getTab = getcontroller.getTab(tabName);
	                	 if (isNullOrEmpty(sgFormValues.id)) {
	                		 submitUrl = SERVERURL.SG_APPOINTMENT_SAVE;
	                		 isUpdate = false;
	                	 } else {
	                		 submitUrl = SERVERURL.SG_APPOINTMENT_UPDATE;
	                		 isUpdate = true;
	                	 }
	                	 var visitorCategory = {
	                			 id: sgFormValues.visitorCategory
	                	 };
	                	 /*var entryBy = {
	                			 id: sgFormValues.entryBy
	                	 };*/
	                	 var appointeeName;
	                	 if (sgFormValues.visitorCategory == 1) {
	                		 var str = sgForm.down('#appointeeNameParentId').getRawValue();
	                		 var appointee = str.split("-");
	                		 appointeeName = appointee[0];
	                	 } else if (sgFormValues.visitorCategory == 2) {
	                		 var str = sgForm.down('#leadId').getRawValue();
	                		 appointeeName = str;
	                	 } else if (sgFormValues.visitorCategory == 3) {
	                		 var str = sgForm.down('#studentItemId').getRawValue();
	                		 appointeeName = str;
	                	 }else if(sgFormValues.visitorCategory==4){                        		   
	                		 var str=sgForm.down('#facAppointmentId').getRawValue();
	                		 appointeeName=str;
	                	 }else if(sgFormValues.visitorCategory==5){                        		   
	                		 var str=sgForm.down('#applicantNameId').getRawValue();
	                		 appointeeName=str;
	                	 } else {
	                		 appointeeName = sgFormValues.appointeeName;
	                	 }
	                	 var personId = {
	                			 id: sgFormValues.appointeeNameParent
	                	 };
	                	 var enquiryId = {
	                			 id: sgFormValues.leadId
	                	 };
	                	 var visitStatusId = {
	                			 id: sgFormValues.viewStatusID
	                	 };
	                	 var reasonForVisitId = {
	                			 id: sgFormValues.reasonForVisitID
	                	 };
	                	 var student = {
	                			 id: sgFormValues.studentId
	                	 };
	                	 var staffId={
	                			 id:sgFormValues.facAppointmentId	   
	                	 };
	                	 var application={
	                			 id:sgFormValues.applicantNameId	   
	                	 };
	                	  var academyLocationId={
	              			   id:sgFormValues.academyLocation	  
	              	     };
	               	     var programId={
	              			   id:sgFormValues.program	   
	              	     };
	               	     var batchId={
	              			   id:sgFormValues.batch   
	              	     };
	               	     var seatTypeId={
	              			   id:sgFormValues.seatType	   
	              	     };
	                	 var appointmentFormData = new Academia.model.sgappointment.sgappointment.SGAppointmentModel();
	                	 
	                	 var chkRescheduleAppointment = sgForm.getForm().findField('isRescheduleAppointment');
	                	 if(chkRescheduleAppointment.getValue()){
	                		 appointmentFormData.set("isRescheduleAppointment",chkRescheduleAppointment.getValue());
	                		 appointmentFormData.set("rescheduleDate",sgFormValues.rescheduleDate);
	                		 if(!isNullOrEmpty(sgFormValues.rescheduleTime)){
	                			 appointmentFormData.set("rescheduleTime",sgFormValues.rescheduleTime); 
	                		 }else{
	                			 delete appointmentFormData.data.rescheduleTime;
	                		 }
	                	 }
	                	 appointmentFormData.set("id", sgFormValues.id);
	                	 appointmentFormData.set("visitorCategory", visitorCategory);
	                	 appointmentFormData.set("bookingId", sgFormValues.bookingId);
	                	 appointmentFormData.set("appointeeName", appointeeName);
	                	 appointmentFormData.set("program",programId);
	               	     appointmentFormData.set("batch",batchId);
	               	     appointmentFormData.set("progBatchSeatConfig",seatTypeId);
	               	     appointmentFormData.set("academyLocation",academyLocationId);
	                	 var countryCode = sgFormValues.mobileCountryCode;
	                	 var mobileNo = sgFormValues.appointeeContactNo;
	                	 var mobileNoWithCode;
	                	 if (isNullOrEmpty(countryCode) && isNullOrEmpty(mobileNo)) {
	                		 mobileNoWithCode = null;
	                	 } else {
	                		 mobileNoWithCode = countryCode + '-' + mobileNo;
	                	 }
	                	 /*change for entry by*/ 
	                	 var entryBy;
	                	 if(submitPortalData == 1){
	                		 if(isNullOrEmpty(sgFormValues.entryBy)){
	                			 var userId=this.getCurrentlyLoggedInUser();
	                			 entryBy = {
	                					 id: userId.id
	                			 };
	                		 } else{
	                			 entryBy = {
	                					 id: sgFormValues.entryBy
	                			 };
	                		 }
	                	 }
	                	 if(submitPortalData == 3 || submitPortalData == 2){
	                		 entryBy = {
	                				 id: this.getCurrentlyLoggedInUser().id
	                		 }
	                	 }
	                	 appointmentFormData.set("appointeeContactNo", mobileNoWithCode);
	                	 appointmentFormData.set("bookingDate", sgFormValues.bookingDate);
	                	 appointmentFormData.set("appointmentDate", sgFormValues.appointmentDate);
	                	 appointmentFormData.set("appointeeEmailId", sgFormValues.appointeeEmailId);
	                	 var persontoMeetValue = sgForm.getForm().findField('personToMeet').getRawValue();
	                	 appointmentFormData.set("personToMeet", persontoMeetValue);
	                	 appointmentFormData.set("visitTime", sgFormValues.visitTime);
	                	 appointmentFormData.set("expectedOutTime", sgFormValues.expectedOutTime);
	                	 appointmentFormData.set("reasonToVisit", sgFormValues.reasonToVisit);
	                	 appointmentFormData.set("entryBy", entryBy);
	                	 appointmentFormData.set("submitPortalId", submitPortalData);
	                	 appointmentFormData.set("additionalReasonToVisit",sgFormValues.additionalReasonToVisit);
	                	  appointmentFormData.set("isAppointeeAppointment",sgFormValues.isAppointee);
	                	  appointmentFormData.set("flagUserId",sgFormValues.flagUserId?sgFormValues.flagUserId:null);
	                	  appointmentFormData.set("isRelatedToFlag",sgFormValues.isRelatedToFlag);
	                	 
	                	 var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
	                	 if( !isNullOrEmpty(enqIntermediateStage.getValue()) ){
	                		 var enqIntermediateStage={
	                				 id:enqIntermediateStage.getValue()  
	                		 };
	                		 appointmentFormData.set("enqIntermediateType",enqIntermediateStage);
	                	 }
	                	 delete appointmentFormData.data.enqIntermediateStage;
	                	 if(isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
	                		 delete appointmentFormData.data.enqIntermediateType;
	                	 }
	                	 if (!isNullOrEmpty(visitStatusId.id)) {
	                		 appointmentFormData.set("sgVisitStatus", visitStatusId);
	                	 } else {
	                		 appointmentFormData.set("sgVisitStatus", null);
	                	 }
	                	 if (!isNullOrEmpty(reasonForVisitId.id)) {
	                		 appointmentFormData.set("sgReasonForVisit", reasonForVisitId);
	                	 } else {
	                		 appointmentFormData.set("sgReasonForVisit", null);
	                	 }
	                	 appointmentFormData.set("customData",sgFormValues.customData);
	                	 if (sgFormValues.visitorCategory == 1) { //base category
	                		 appointmentFormData.set("person", personId);
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 } else if (sgFormValues.visitorCategory == 2) {
	                		 appointmentFormData.set("enquiry", enquiryId);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 } else if (sgFormValues.visitorCategory == 3) {
	                		 appointmentFormData.set("student", student);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 }else if(sgFormValues.visitorCategory==4){
	                		 appointmentFormData.set("staff",staffId);
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.application;
	                	 } else {
	                		 delete appointmentFormData.data.person;
	                		 delete appointmentFormData.data.enquiry;
	                		 delete appointmentFormData.data.student;
	                		 delete appointmentFormData.data.staff;
	                		 delete appointmentFormData.data.application;
	                	 }
	                	 if(Ext.isDefined(appointmentFormData.data.entryByName)){
	                		 delete appointmentFormData.data.entryByName;
	                	 }
	                	 if(Ext.isDefined(appointmentFormData.data.personToMeetId)){
	                		 delete appointmentFormData.data.personToMeetId;
	                	 }
	                	 if (isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
	                		 delete appointmentFormData.data.enqIntermediateType;
	                	 }
	                	 if (isNullOrEmpty(appointmentFormData.data.enqIntermediateStage)) {
	                		 delete appointmentFormData.data.enqIntermediateStage;
	                	 }
	                	  if(isNullOrEmpty(appointmentFormData.data.academyLocation.id)){
	              		   delete appointmentFormData.data.academyLocation;
	              	     }
	               	     if(isNullOrEmpty(appointmentFormData.data.program.id)){
	              		   delete appointmentFormData.data.program;
	              	     }
	               	     if(isNullOrEmpty(appointmentFormData.data.batch.id)){
	              		   delete appointmentFormData.data.batch;
	              	     }
	               	     if(isNullOrEmpty(appointmentFormData.data.progBatchSeatConfig.id)){
	              		   delete appointmentFormData.data.progBatchSeatConfig;
	              	     }
	                	/*var formData = Ext.encode(appointmentFormData.data);
	                	 Ext.getBody().mask();
	                	 Ext.Ajax.request({
	                		 type: 'rest',
	                		 url: submitUrl,
	                		 jsonData: formData,
	                		 method: 'POST',
	                		 success: function(frm, action) {
	                			 Ext.getBody().unmask();
	                			 sgForm.getForm().reset();
	                			 if (isUpdate) {
	                				 showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
	                				 if (getTab != null) {
	                					 contentPanel.remove(getTab, true);
	                				 }
	                				 if (grid != undefined) {
	                					 grid.getStore().reload();
	                					 grid.getSelectionModel().deselectAll();
	                				 } else if (sgDetailGrid != undefined) {
	                					 sgDetailGrid.getStore().load();
	                					 sgDetailGrid.getSelectionModel().deselectAll();
	                				 }
	                			 } else {
	                				 showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
	                				 if (getTab != null) {
	                					 contentPanel.remove(getTab, true);
	                				 }
	                				 if (grid != undefined) {
	                					 grid.getStore().load();
	                					 grid.getSelectionModel().deselectAll();
	                				 }
	                			 }
	                		 }
	                	 }); */
	                	 //////////////////////////////////////////////////////////
	                	 var data = new Object();

	                     data.entityId = null;
	                     data.module = 'SGAPPOINTMENT';
	                     data.entityType = 'DOCUMENT';
	                     var documentUploadFile = sgForm.down('#documentUploadFile').getValue();
	                     var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
	                     if(!isNullOrEmpty(documentUploadFile)){
	                    	    sgForm.getForm().submit({
	   	                         method: 'POST',
	   	                         async:false,
	   	                         url: uplaodUrl,
	   	                         success: function(form1, action) {
	   	                             var responseData = Ext.decode(action.response.responseText);
	   	                             var path = responseData.path;
	   	                          
	   	                             var formData = new Object();
	   	                             formData.type ='NEW_DOCUMENT';
	   	                             formData.name = path;
	   	                               formData.documentName=path;
	   	                         

	   	                             $this.getDocumentController().saveDocumentFormValue(false, 'NEW_DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
	   	                                 if(success){
	   	                                     var documentId = Ext.decode(response.responseText);
	   	                                     var saveJson = new Object();
	   	                                     var document = new Object();
	   	                                     document.id = documentId;
	   	                                     appointmentFormData.set("documentId",documentId);
	   	                                     
	   	                                    var formData = Ext.encode(appointmentFormData.data);
	   	                                      Ext.getBody().mask();
	   	                                      Ext.Ajax.request({
	   	                                          type: 'rest',
	   	                                          url: submitUrl,
	   	                                          jsonData: formData,
	   	                                          method: 'POST',
	   	                                          success: function(frm, action) {
	   	                                              Ext.getBody().unmask();
	   	                                              sgForm.getForm().reset();
	   	                                              if (isUpdate) {
	   	                                                  showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
	   	                                                  if (getTab != null) {
	   	                                                      contentPanel.remove(getTab, true);
	   	                                                  }
	   	                                                  if (grid != undefined) {
	   	                                                      grid.getStore().reload();
	   	                                                      grid.getSelectionModel().deselectAll();
	   	                                                  } else if (sgDetailGrid != undefined) {
	   	                                                      sgDetailGrid.getStore().load();
	   	                                                      sgDetailGrid.getSelectionModel().deselectAll();
	   	                                                  }
	   	                                              } else {
	   	                                                  showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
	   	                                                  if (getTab != null) {
	   	                                                      contentPanel.remove(getTab, true);
	   	                                                  }
	   	                                                  if (grid != undefined) {
	   	                                                      grid.getStore().load();
	   	                                                      grid.getSelectionModel().deselectAll();
	   	                                                  }
	   	                                              }
	   	                                          }
	   	                                      });
	   	                                 }
	   	                             });
	   	                         }
	   	                     });
	                     }
	                     else{
	                      var formData = Ext.encode(appointmentFormData.data);
	                         Ext.Ajax.request({
                                    type: 'rest',
                                    url: submitUrl,
                                    jsonData: formData,
                                    method: 'POST',
                                    success: function(frm, action) {
                                        Ext.getBody().unmask();
                                        sgForm.getForm().reset();
                                        if (isUpdate) {
                                            showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
                                            if (getTab != null) {
                                                contentPanel.remove(getTab, true);
                                            }
                                            if (grid != undefined) {
                                                grid.getStore().reload();
                                                grid.getSelectionModel().deselectAll();
                                            } else if (sgDetailGrid != undefined) {
                                                sgDetailGrid.getStore().load();
                                                sgDetailGrid.getSelectionModel().deselectAll();
                                            }
                                        } else {
                                            showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
                                            if (getTab != null) {
                                                contentPanel.remove(getTab, true);
                                            }
                                            if (grid != undefined) {
                                                grid.getStore().load();
                                                grid.getSelectionModel().deselectAll();
                                            }
                                        }
                                    }
                                });
	                     }

	                 },

	                 sendCalendarEventsRequest: function(personId, calenderItemId, submitURL) {
	                	 var this$ = this;
	                	 var sgForm = this$.getSgappointmentform();
	                	 if (!isNullOrEmpty(sgForm) && Ext.isDefined(sgForm)) {
	                	 var id = sgForm.down("#id").getValue();
	                	 var personToMeetId = null;
	                	 var appointmentDateId = sgForm.down("#appointmentId").getValue();
	                	 if (isNullOrEmpty(id)) {
	                		 personToMeetId = sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
	                	 } else {
	                		 var facultyName = sgForm.down("#personToMeetId").getValue();
	                		 var records = sgForm.down("#personToMeetId").getStore().data.items;
	                		 for (var i in sgForm.down("#personToMeetId").getStore().data.items) {
	                			 if (records[i].data.value == facultyName) {
	                				 personToMeetId = records[i].data.id;
	                			 }
	                		 }
	                	 }
	                	
	                	 var personProfile = this.getContentPanelActiveTab();
	                	 var calendar = personProfile.down(calenderItemId);
	                	 var params = new Object();
	                	 calendar.eventStore.getProxy().actionMethods.read = 'GET';
	                	 params.facultyId = personToMeetId;
	                	 calendar.eventStore.removeAll();
	                	 calendar.eventStore.getProxy().url = submitURL;
	                	 calendar.eventStore.getProxy().extraParams = params;
	                	 calendar.eventStore.load();
	                	 }
	                 },
	                 openViewCalendarWin: function() {
	                	 var $this = this;
	                	 var contentpanel = this.getContentPanel();
	                	 var scheduledetails = Ext.widget('scheduledetails');
	                	 var tabName = getServiceRequestTranslation('VIEW_CALENDAR');
	                	 var personToMeetId = null;

	                	 /**
	                	  * This is to remove tab from content panel and open same tab again
	                	  */
	                	 var getcontroller = this.getController('menu.CoreERPNavigationController');
	                	 var getTab = getcontroller.getTab(tabName);
	                	 if (getTab != null) {
	                		 contentPanel.remove(getTab, true);
	                	 }
	                	 openTab(contentpanel, tabName, scheduledetails, contentpanel.activeTab.menuColorCls);
	                	 var sgForm = $this.getSgappointmentform();
	                	 var id = sgForm.down("#id").getValue();

	                	 var appointmentDateId = sgForm.down("#appointmentId").getValue();
	                	 if (isNullOrEmpty(id)) {
	                		 personToMeetId = sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
	                	 } else {
	                		 var facultyName = sgForm.down("#personToMeetId").getValue();
	                		 var records = sgForm.down("#personToMeetId").getStore().data.items;
	                		 for (var i in sgForm.down("#personToMeetId").getStore().data.items) {
	                			 if (records[i].data.value == facultyName) {
	                				 personToMeetId = records[i].data.id;
	                			 }
	                		 }
	                	 }

	                	 var personProfile = this.getContentPanelActiveTab();
	                	 var calendar = personProfile.down('#personViewCalendar');
	                	 var params = new Object();
	                	 calendar.eventStore.getProxy().actionMethods.read = 'GET';
	                	 params.facultyId = personToMeetId;
	                	 calendar.eventStore.removeAll();
	                	 calendar.eventStore.getProxy().url = SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA;
	                	 calendar.eventStore.getProxy().extraParams = params;
	                	 calendar.eventStore.load();
	                 },
	                 loadSGAppointmentGrid: function() {
	                	 var $this = this;
	                	 var grid = $this.getSgappointmentgrid();
	                	 var sgFilter = this.getSgappointmentfilter();
	                	 var sgFilterValues = sgFilter.getValues();
	                	 var personMeetRawValue = sgFilter.down('#personToMeetFilterItemId').getRawValue();
	                	 var store = grid.getStore();
	                	 store.getProxy().extraParams = {
	                		 bookingID: sgFilterValues.bookingID,
	                		 appointeeName: sgFilterValues.appointeeName,
	                		 personTomeet: personMeetRawValue,
	                		 appointmentFromDate: sgFilterValues.appointmentFromDate,
	                		 appointmentToDate: sgFilterValues.appointmentToDate,
	                		 academyLocationIds: this.getCurrentAcademyLocation()
	                	 };
	                	 $this.resetPageSetting(store);
	                	 store.load();

	                 },
	                 resetSGStudentAppointment: function(filter) {
	                	// filter.reset();
	                	 filter.down("#visitTimeId").reset();
	                	 filter.down("#outTimeId").reset();
	                	 filter.down("#personToMeetId").reset();
	                	 filter.down("#reasonForVisitID").reset();
	                	 filter.down("#viewStatusID").reset();
	                	 filter.down("#reasonToVisitItemId").reset();
	                	 filter.down("#appointmentId").reset();
	                	 
	                	 //clearTime( filter.down("#appointmentId"), [clone] );
	                	 
	                 },
	                 
	                 removePlaceHolder:function(){
		     	            var sgappointmentform=this.getSgappointmentform();
		                           Ext.Ajax.request({
		                              type: 'rest',
		                              url: SERVERURL.FIND_BY_ENTITY_ID,                             
		                              method: 'GET',
		                              params: {
		                                  entityId: 31
		                              },
		                              success: function(response,form, action) {
		                                  if(!isNullOrEmpty(response.responseText)){
		                                      var responseObject =  Ext.JSON.decode(response.responseText);                                  
		                                      if(!isEmpty(responseObject)){
		                                          var bookingId = sgappointmentform.down("#bookingId");
		                                          if(responseObject.whetherManualId){
		                                        	  bookingId.setReadOnly(false);
		                                        	  bookingId.emptyText=' ';
		                                        	  bookingId.allowBlank=false;
		                                        	  bookingId.labelSeparator +='<span class="required" style="color:red"> *</span>';
		                                        	  bookingId.setFieldLabel(bookingId.fieldLabel);
		                                        	  bookingId.applyEmptyText();
		                                          }else{
		                                        	  bookingId.setReadOnly(true);
		                                        	  bookingId.allowBlank=true;
		                                        	  bookingId.emptyText= getCommonTranslation('ID_AUTOGENERATE');
		                                        	  bookingId.applyEmptyText();
		     	
		                                         }
		                                      }
		                                  }                                                     
		                              }                
		                          });
		                 },
	                 
	                 loadDFRForIsThisRelatedToFlag: function(form){
					    	var $this = this;
					    	var flagUserId=form.down('#flagUserId');
					    	
					    	Ext.Ajax.request({
					    		type: 'rest',
					    		async: false,
					    		url: SERVERURL.COMMON_FORM_FIELD_INFO,
					    		params: {
					    			screenName: 'sgappointmentform',
					    			academyLocationId: $this.getCurrentAcademyLocation(),
					    			languageCode:'en'
					    		},
					    		method: 'GET',
					    		success: function(res, action) {
					    			var response = Ext.decode(res.responseText);
					    			if( Object.keys(response).length > 0 ){
					    				var records=response.sgappointmentform;
					    				for(i in records){  
					    					if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='flagRelatedRadio' && records[i].isVisible === false){ 
					    						flagUserId.setVisible(false);
					    				    }	
					    					
					    				}
					    			}
					    		}
					    	});
					    },
					    loadDFRForManageAppointment: function(academyLocationId) {
	                      var $this = this;
	                      var form = $this.getSgappointmentform();
	                      var academyLocationId = form.down("#academyLocationId");
	              		  var programId = form.down("#programId");
	              		  var batchId = form.down("#batchId");
	              		  var seatTypeId = form.down("#seatTypeId");

	                      Ext.Ajax.request({
	                          type: 'rest',
	                          async: false,
	                          url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                          params: {
	                              screenName: 'sgappointmentform',
	                              academyLocationId: this.getCurrentAcademyLocation(),
	                              languageCode: 'en'
	                          },
	                          method: 'GET',
	                          success: function(res, action) {
	                              var response = Ext.decode(res.responseText);
	                              if (Object.keys(response).length > 0) {
	                                  var records = response.sgappointmentform;
	                                  for (i in records) {
	                                      var fieldConfig = records[i];
	                                      
	                                        if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'academyLocationId') {
	                                          if (fieldConfig.isMandatory) {
	                                          	academyLocationId.allowBlank = false;
	                                          }else{
	                                          	academyLocationId.allowBlank = true;
	                                          }
	                                          if (fieldConfig.isVisible) {
	                                          	academyLocationId.setVisible(true);
	                                          }else{
	                                          	academyLocationId.setVisible(false);
	                                          	academyLocationId.reset();
	                                          	programId.setVisible(false);
	                                          	programId.reset();
	                                          	batchId.setVisible(false);
	                                          	batchId.reset();
	                                          	seatTypeId.setVisible(false);
	                                          	seatTypeId.reset();
	                                          }
	                                         }
	                                         if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'programId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	programId.allowBlank = false;
	                                              }else{
	                                              	programId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	programId.setVisible(true);
	                                              }else{
	                                              	programId.setVisible(false);
	                                              	programId.reset();
	                                              	batchId.setVisible(false);
	                                              	batchId.reset();
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                        }
	                                       	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'batchId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	batchId.allowBlank = false;
	                                              }else{
	                                              	batchId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	batchId.setVisible(true);
	                                              }else{
	                                              	batchId.setVisible(false);
	                                              	batchId.reset();
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                        }
	                                       	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'seatTypeId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	seatTypeId.allowBlank = false;
	                                              }else{
	                                              	seatTypeId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	seatTypeId.setVisible(true);
	                                              }else{
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                       }
	                                  }
	                              }
	                          }
	                      });
	                  }
						 
});