/**
 * This controller is used for sponsorship listing functionality
 */
Ext.define('Academia.controller.sponsorship.SponsorshipListingController', {
    extend: 'Academia.controller.base.BaseController',
  
    views: ['Academia.view.sponsorship.SponsorshipListing','sponsorship.SponsorshipListingScreen',
            'sponsorship.SponsorshipListingSearchForm','sponsorship.SponsorshipListingPastRecordsSearchForm',
            'sponsorship.SponsorshipListingPastRecordsGrid','sponsorship.SponsorshipListingPastRecords',
            'sponsorship.sponsorshipListing.AddSponsoredStudent', 'sponsorship.sponsorshipListing.SponsorFeeHeadGrid',
            'sponsorship.sponsorshipListing.AddSponsorWindow','sponsorship.sponsorshipListing.AddSponsorSearchForm',
            'sponsorship.sponsorshipListing.ViewSponsorshipsPastDataSearchForm',
            'sponsorship.sponsorshipListing.ViewPastDataAdvanceSearchView','sponsorship.sponsorshipListing.ViewSponsorshipsPastDataView',
            'sponsorship.sponsorshipListing.ConfigureSponsorFeeHeadGrid','sponsorship.SponsorshipAwardeesGrid',
            'sponsorship.SponsorshipAwardeeUploadeDownloadForm','sponsorship.SponsorshipDownloadForm','sponsorship.SponsorshipUploadForm',
            'UploadOptionRadioGroup','sponsorship.SponsorshipUploadListGrid'],

    stores:['sponsorship.SponsorTypes', 'sponsorship.Students',
            'sponsorship.SponsoredStudentsFeeHeads', 'servicerequest.placementrequest.PlacementPrograms',
            'sponsorship.FeePlanStore', 'sponsorship.StageNames', 'sponsorship.FeeHeads','common.ProgramsByAcademyIdLocationId',
            'common.BatchesByProgramId','admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
            'sponsorship.FeePlanSequences', 'sponsorship.ConfiguredSponsorFeeHeads', 'sponsorship.Sponsors',
            'common.UserAccessibleAcademys','organization.academylocations.LocationStore','feeandpayment.managebill.Student',
            'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','sponsorship.SponsorsList',
            'sponsorship.SponsorTypesStore','sponsorship.SponsorshipAwardeesSearchResultStore','feeandpayment.reports.Student',
            'common.AcademyLocationNameSeparated','sponsorship.SponsorsNameCodeStore','sponsorship.SponsorStageNameByFeePlanIdStore',
            'common.ProgramByAcademyLocationStoreWithoutPermission','program.programbatchdetail.BatchStore','enquiry.ProgramBatchSeatTypeStore',
            'importutility.ImportSponsorshipStore','sponsorship.FeePlanTypeStore'],
    
    refs: [{
	    	ref: 'contentPanel',
	        selector: 'contentPanel'
	   	},{
	   		ref: 'sponsorshiplisting',
	   		selector: 'sponsorshiplisting'
	   	},{
	   		ref : 'sponsorshipListForm',
	   		selector : 'sponsorshiplistingsearchform'
	   	},{
	   		ref : 'sponsorshipawardeesgrid',
	   		selector:'sponsorshipawardeesgrid'
		}, {
			ref: 'addSponsoredStudent',
			selector: 'addsponsoredstudent'
		}, {
			ref: 'sponsorFeeHeadGrid',
			selector: 'addsponsoredstudent grid[xtype=sponsorfeeheadgrid]'
		}, {
			ref: 'studentSearchField',
			selector: 'addsponsoredstudent livesearchcombo[name=studentName]'
		},{
			ref: 'viewSponsorshipsPastDataSearchForm',
			selector: 'viewsponsorshipspastdatasearchform[itemId=viewSponsorshipsPastDataSearchForm]'
		},{
			ref: 'sponsorshipPastDataSearchResultGrid',
			selector: 'searchresultgrid[itemId=viewSponsorshipPastDataSearchResultGrid]'
		},{
			ref: 'configureSponsorFeeheadGrid',
			selector: ' addsponsorwindow grid[xtype=configuresponsorfeeheadgrid]'
		},{
			ref: 'sponsorshipawardeeuploadedownloadform',
			selector: 'sponsorshipawardeeuploadedownloadform'
			
		},{
			ref: 'sponsorshipdownloadform',
			selector: 'sponsorshipdownloadform'
		},{
			ref: 'sponsorshipuploadform',
			selector: 'sponsorshipuploadform'
		},{
			ref: 'sponsorshipuploadlistgrid',
			selector: 'sponsorshipuploadlistgrid'
		},{
			ref: 'uploadoptionradiogroup',
			selector: 'uploadoptionradiogroup'
		},{
			ref:'addsponsorsearchform',
			selector:'addsponsorsearchform'
		}],
		config: {
	    	//SPONSORSHIP_LISTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSORSHIP_LISTING_PRIVILEGES'),
			SPONSORED_STUDENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSORED_STUDENT_PRIVILEGES'),
	    	SPONSORSHIP_AWARDEES_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSORSHIP_AWARDEES_LIST_PRIVILEGES'),
	    },
    init: function(application) {
       this.control({
    	   'sponsorshiplisting' : {
       		tabchange: function(view,newTab,oldtab){
    			var master=this.getSponsorshiplisting();
    			var advancesearch = master.down('advancedsearchquerybuilder');
    			var combo1 = advancesearch.down('#loadSavedSearchComboId');
    			combo1.setVisible(false);
    		}
    	},
	    	'sponsorshiplistingsearchform  button[itemId=SponsorshipListSearchBtn]' : {
				click : this.loadSponsorAwardeesGridUsers
			},
			'sponsorshiplistingsearchform  button[itemId=sponsorshipListResetButtonId]' : {
				click:function(){   
					var $this = this;
					var form = $this.getSponsorshipListForm();
					form.getForm().reset();
					var academyLocation = form.down('#academyLocationId');
					academyLocation.onTrigger1Click();
					var studentId = form.down('combo[name=STUDENT_ID]');
					studentId.setDisabled(true);
					var program = form.down('#programNameOrCodeId');
					var department = form.down('#departmentByProgramDepartmentId');
					var subDepartment = form.down('#departmentBySubDepartmentId');
					subDepartment.setDisabled(true);
					delete program.getStore().proxy.extraParams.academyLocationIds;
					delete program.getStore().proxy.extraParams.qry;
					program.getStore().load();
					delete department.getStore().proxy.extraParams.academyLocationIds;
					delete department.getStore().proxy.extraParams.programId;
					delete department.getStore().proxy.extraParams.name;
					department.getStore().load();
				}  
			},
			'sponsorshipawardeesgrid':{
				render:function(grid){
					//this.gridRenderFunction(grid);
					//this.doAccessControlValidation(grid, this.getSPONSORED_STUDENT_PERMISSIONS());
					this.doAccessControlValidation(grid, this.getSPONSORSHIP_AWARDEES_LIST_PERMISSIONS());
				},
				afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getSPONSORSHIP_AWARDEES_LIST_PERMISSIONS());
					},1500);
				}
			},
    	   /*'sponsorshiplistingscreen button[itemId=searchResultGridBtnView]':{
    		   click:function(){
    			   var contentpanel = this.getContentPanel();
    			   var transactionDetailsFormLayout = Ext.widget('sponsorshiplistingpastrecords');   		           
   		           contentpanel.add(transactionDetailsFormLayout);
   		           contentpanel.setActiveTab(transactionDetailsFormLayout);
    		   }
    	   },
    	   'sponsorshiplistingsearchresultgrid': {
    		   render: function(grid){
       			//this.doAccessControlValidation(grid, this.getSPONSORSHIP_LISTING_PERMISSIONS());
       			//var deleteButton = grid.down('#searchResultGridBtnDelete');
               // deleteButton.setVisible(false);
       		}
    	   },
    	  /**
    	   * Listeners for the Sponsorship awardees Listing grid buttons
    	   */
    	   'sponsorshipawardeesgrid button': {
	       		click: function(button) {
	       			if(button.itemId === 'btnAdd') {
	       				this.onSponsorsoredStudentAdd(button);
	       			}else if(button.itemId === 'btnEdit') {
	       				this.onSponsorsoredStudentEdit(button);
	       			}else if(button.itemId === 'btnView') {
	       				this.onSponsorsoredStudentEdit(button);
	       			}else if(button.itemId === 'btnDelete') {
	       				this.onSponsorshipDelete(button);
	       			}
	       		}
       		},
       		'sponsorshipawardeeuploadedownloadform radiogroup[itemId=importDownloadgroupId]':{
	   			   change: function(cb, nv, ov){
                		var $this = this;
                 		var downloadTemplateForm = this.getSponsorshipdownloadform();
                 		var uploadTemplateForm = this.getSponsorshipuploadform();
                 		var grid = this.getSponsorshipuploadlistgrid();
                 		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
                 			uploadTemplateForm.hide();
                 			downloadTemplateForm.show();
                 			grid.setVisible(false);
                 		}else{
              //   			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
                        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
                        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
                        		isUploadAll: false
                        	});
                 			downloadTemplateForm.hide();
                 			uploadTemplateForm.show();
                 			grid.setVisible(true);
                 		}
                 	}
       		 },
       		'sponsorshipdownloadform combo#academyLocation' : {
   			 select : function(obj, record) {
   				 var academyLocationId = record[0].get("id");
   				 var batchField = this.getSponsorshipdownloadform().down("#batch");
   				 batchField.reset();
   				 batchField.setDisabled(true);
   				 var seatTypeField = this.getSponsorshipdownloadform().down("#seatType");
   				 seatTypeField.reset();
   				 seatTypeField.setDisabled(true);
   				 var programField =  this.getSponsorshipdownloadform().down("#program");
   				 programField.clearValue();
   				 programStore  = programField.getStore();
   				 programStore.getProxy().extraParams = {
   					 academyLocationId: academyLocationId
   				 };
   				 programStore.load();

   			 }
   		 },
   		 
   		 'sponsorshipdownloadform multiselectcombofield#program' : {
   			 change : function(obj, record) {
   				 var form = this.getSponsorshipdownloadform();
   				 var batchField = form.down("#batch");
 				
   				 var seatTypeField = form.down("#seatType");
 				
   				 var programId = form.down("#program").getValue();
				 var programsId = [];
				 for(var i in programId){
					 if(Ext.isObject(programId[i])){
						 programsId.push(programId[i].data.id);
					 }else{
						 programsId.push(programId[i]);
					 }
				 } 
				 var programIds = programsId.join();
				 var value = obj.getValue();
				 seatTypeField.reset();
				 batchField.clearValue();
				 if(value.length >0 ){
					 batchField.enable();
						
					 var batchStore = batchField.getStore();
					 batchStore.getProxy().extraParams = {
						 programIds : programIds,
						 screen:'fees'
					 };
					 batchStore.load();
				 }else{
					 seatTypeField.disable();
					 batchField.disable();
				 }			
   			 }
   		 },
   		 
   		 'sponsorshipdownloadform multiselectcombofield#batch' : {
   			 change : function(obj, record) {
   				 var seatTypeField = this.getSponsorshipdownloadform().down("#seatType");
 				
   				 var batch = this.getSponsorshipdownloadform().down("#batch").getValue();
				 var batchId = [];
				 for(var i in batch){
					 if(Ext.isObject(batch[i])){
						 batchId.push(batch[i].data.id);
					 }else{
						 batchId.push(batch[i]);
					 }
				 }
				 var batchIds = batchId.join();
				 var value = obj.getValue();

				 seatTypeField.reset();
				 seatTypeField.clearValue();
					
			   seatTypeFieldStore = seatTypeField.getStore();
			     if(value.length>0 ){
			    	 seatTypeField.enable();
					  
			    	 seatTypeFieldStore.getProxy().extraParams = {
						 batchIds : batchIds,
						 screen : 'seatType',

					 };
					 seatTypeFieldStore.load();
			
			     }else {
			    	 seatTypeField.disable();
			     }
   			 }
     		 },
     		 
     		'sponsorshipdownloadform' : {
				afterrender : function() {
					var $this= this;
					setTimeout(function(){
					 var academyLocationId = $this.getCurrentAcademyLocation();
	   				 var academyLocationField =  $this.getSponsorshipdownloadform().down("#academyLocation");
	   				 var downloadBtn = $this.getSponsorshipdownloadform().down("#downoladBtnId");
	   				 var academyLocationFieldStore=academyLocationField.getStore();
	   				 academyLocationFieldStore.load({
	 					   callback: function(records, operation, success) {
	 							   for(var i in records){
	 								   if(records[i].data.id==academyLocationId){
	 									 academyLocationField.setValue(records[i].data.id);
	 								   }
	 							   }
	 					   }
	 				   });
	   				var programField =  $this.getSponsorshipdownloadform().down("#program");
     				programField.clearValue();
     				programStore  = programField.getStore();
     				 programStore.getProxy().extraParams = {
     					 academyLocationId: academyLocationId
     				 };
     				 programStore.load();
     				 },800);
					
				}
			},
     		'sponsorshipdownloadform button#resetBtn' : {
     			click : function() {
   				 this.getSponsorshipdownloadform().getForm().reset();
   				 var batchField = this.getSponsorshipdownloadform().down("#batch");
   				 batchField.setDisabled(true);
   				 var seatTypeField = this.getSponsorshipdownloadform().down("#seatType");
   				 seatTypeField.setDisabled(true);
   				 var academyLocationId = this.getCurrentAcademyLocation();
   				 var academyLocationField =  this.getSponsorshipdownloadform().down("#academyLocation");
   				 var academyLocationFieldStore=academyLocationField.getStore();
   				 academyLocationFieldStore.load({
 					   callback: function(records, operation, success) {
 							   for(var i in records){
 								   if(records[i].data.id==academyLocationId){
 									 academyLocationField.setValue(records[i].data.id);
 								   }
 							   }
 					   }
 				   });
   				 
     				var programField =  this.getSponsorshipdownloadform().down("#program");
     				programField.clearValue();
     				programStore  = programField.getStore();
     				 programStore.getProxy().extraParams = {
     					 academyLocationId: academyLocationId
     				 };
     				 programStore.load();
   			 }
     		 },
        		'sponsorshipdownloadform button[itemId=downoladBtnId]':{
     			   click:function(obj){
     				   var $this = this;
     				   var form =$this.getSponsorshipdownloadform().getForm();
     				   var value = form.getValues();
     				   var seatTypeArray=new Array();
     				  var batchArray=new Array();
     				 var programeArray=new Array();
    				  
     				   var templateUrl = null;
     				   
     				   Ext.each(value.seatType, function(seatType){
     					   if(!Ext.isDefined(seatType.data)){
     						   seatTypeArray.push(seatType);
     					   }else{
     						   seatTypeArray.push(seatType.data.id);   
     					   }
     					   
     			   	   });
     				   
     				   Ext.each(value.program, function(programRecord){
     					   if(!Ext.isDefined(programRecord.data)){
     						  programeArray.push(programRecord);
     					   }else{
     						  programeArray.push(programRecord.data.id);   
     					   }
     					   
     			   	   });
     				   
     				   Ext.each(value.batch, function(batchRecord){
     					   if(!Ext.isDefined(batchRecord.data)){
     						  batchArray.push(batchRecord);
     					   }else{
     						  batchArray.push(batchRecord.data.id);   
     					   }
     					   
     			   	   });
     				   var seatTypeValue = seatTypeArray.toString();
     				  var programeArrayValue =programeArray.toString();
     				 var batchArrayValue =batchArray.toString();
     				   templateUrl = SERVERURL.DOWNLOAD_TEMPLATE_SPONSOR_AWARDEE
     				   
     				   var csvForm = Ext.create('Ext.form.Panel'); 
     				   csvForm.getForm().submit({
     					   target: '_blank',
     					   method:'POST',
     					   params :{
     						  access_token : Ext.Ajax.defaultHeaders.access_token,
     						  academyLocationId:value.academyLocation,
     						  pbstIdsCommaSeparated :seatTypeValue,
     						  batchIdsCommaSeparated :batchArrayValue,
     						  programIdsCommaSeparated  :programeArrayValue  
     					   },
     					   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
     					   url: templateUrl,
     					   standardSubmit :true
     				   });
     			   }  
     		   },
         		'sponsorshipuploadform button[itemId=uploadId]':{
      			   click:function(obj){
      				   var $this=this;
      				   var importWin=$this.getSponsorshipuploadform()
      				   var grdStore;
      				   var form=$this.getSponsorshipuploadform();
      				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
      				   $this.getHashOfFile(form);
      				   setTimeout(function() {
          				   form.getForm().submit({
          					   method : 'POST',
          					   url : submitUrl,
          					   success : function(form, action){
          						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
          					   },
          					   failure: function(form, action) {
       		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
          					   }
          				   });
      				   },1000);

      				   Ext.defer(function() {
      					   var grid = $this.getSponsorshipuploadlistgrid();
      					   var form = $this.getUploadoptionradiogroup();
      					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
      					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_SPONSORSHIP_UPLOAD');
      				   }, 2000, this);
      			   }  
      		   },
       		 
       		'sponsorshipuploadform button[itemId=resetBtn]':{
  			   click:function(obj){
  				   var $this = this;
  				   var form =$this.getSponsorshipuploadform().getForm();
  				   form.findField('file').reset();
  				   var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
  				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  					   isUploadAll: false
  				   });
  				   form.isValid();
  			   },
  			   render :function(obj){
  				   var $this = this;
  				   var form =$this.getSponsorshipuploadform().getForm();
  				   var combo = form.findField('importUtilityMasterId');
  				   combo.getStore().load({
  					   callback: function(records, operation, success) {
  						   for(var i in records){
  							   if(records[i].data.value=='Bulk Sponsorship Awardee'){
  								   combo.setValue(records[i].data.id);
  								   combo.setReadOnly(true);
  							   }
  						   }
  					   }	   
  				   });
  			   }  
  		   },
  		 'sponsorshipuploadlistgrid':{
			   render:function(obj){
				   var $this = this;
				   var grid = $this.getSponsorshipuploadlistgrid();
				   var form = this.getUploadoptionradiogroup();
				   var isUploadAll = form.items.items[0].getValue().isUploadAll;
				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_SPONSORSHIP_UPLOAD');
			   },
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   if (e.target.tagName == 'A') {
					   var fileType = null;
					   if(cellIndex == 1){
						   fileType = 'successFile';
					   }else if(cellIndex == 6){
						   fileType = 'errorFile';
					   }else if(cellIndex == 7){
						   fileType = 'logFile';
					   }
					   var documentId = record.get("id");
					   if (!isNullOrEmpty(documentId)) {
						   this.getDownloadFile(documentId,fileType);
					   }
				   }
			   }
		   },
  		   'sponsorshipuploadform uploadoptionradiogroup[itemId=sponsorshipUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
  			   change: function( radioGroup, newValue, oldValue, eOpts){
  				   var grid =this.getSponsorshipuploadlistgrid();
  				   var form =this.getUploadoptionradiogroup();
  				   var isUploadAll = newValue.isUploadAll;
  				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_SPONSORSHIP_UPLOAD');
  			   }   
  		   }, 
  		   'sponsorshipuploadlistgrid button[itemId=btnForce]':{
			   click: function(obj) {
				   var grid = this.getSponsorshipuploadlistgrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   if(grid.getSelectionModel().getCount() > 1){
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					   }else{
						   var this$ = this;
						   var id = grid.getSelectionModel().selectionStart.data.id;
						   console.log(id);
						   var urlAppend="?jobName="+id;
						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						   Ext.Ajax.request({
							   url: submitURL,
							   method: 'GET',
							   success: function(response) {
								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
									   //console.log("Manual trigger hit");
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
								   }else if(response.responseText==="SUCCESS"){
									   //console.log("Manual trigger hit");
									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
									   grid.getStore().reload();
								   }
							   }
						   });
					   }
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }  
			   }
		   },

       		/***** Export Buttons************/
           'searchresultgrid[itemId=SponsorshipListGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportSponsorshipList(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=SponsorshipListGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportSponsorshipList(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=SponsorshipListGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportSponsorshipList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=SponsorshipListGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportSponsorshipList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        },
	        /**
	         * Listener to load the fee head grid on selection of the student.
	         */
	        'addsponsoredstudent livesearchcombo': {
	        	select: function(combo) {
	        		this.loadFeeHeadGrid(combo);
	        	}
	        },
	        /**
	         * 
	         */
	        'sponsorfeeheadgrid button':	{
        		click: function(button) {
        			if(button.itemId === 'btnAdd') {
        				this.onFeeHeadGridAdd(button);
        			}else if(button.itemId === 'btnEdit') {
        				this.onFeeHeadGridEdit(button);
        			}else if(button.itemId === 'btnView') {
        				this.onFeeHeadGridEdit(button);
        			}else if(button.itemId === 'btnDelete') {
        				this.onFeeHeadGridDelete(button);
        			}
        		}
        	},
        	'viewsponsorshipspastdatasearchform[itemId=viewSponsorshipsPastDataSearchForm] button[itemId=findButtonId]' : {
				click : this.loadSponsorshipsPastDataGrid
			},
			'viewsponsorshipspastdatasearchform[itemId=viewSponsorshipsPastDataSearchForm]' : {
				render : this.loadSponsorshipsPastDataGrid
			},
			 'sponsorshiplistingsearchform label[itemId=viewSponsorId]': {
	                render: function(component) {
	                    var this$ = this;
	                    component.getEl().on('click', function(e) {
	                        this$.onClickViewDetailsLinkPanel();
	                    });
	                }
	           },
	           'viewsponsorshipspastdatasearchform[itemId=viewSponsorshipsPastDataSearchForm] combo[itemId=program]' : {
					select : this.loadBatchComboStore
				},
				'viewsponsorshipspastdatasearchform[itemId=viewSponsorshipsPastDataSearchForm] combo[itemId=batch]' : {
					select : this.loadPeriodComboStore
				},
				'sponsorshiplistingsearchform multiselectcombofield[itemId=academyLocationId]' : {
					change:function(obj,rec){
						var $this = this;
						var form = $this.getSponsorshipListForm();
						var studentId = form.down('#sponList_studId');
						var program = form.down('#programNameOrCodeId');
						var department = form.down('#departmentByProgramDepartmentId');
						var subDepartment = form.down('#departmentBySubDepartmentId');
						program.reset();
						department.reset();
						subDepartment.reset();
						subDepartment.setDisabled(true);
						if(rec.length>0){
							if(!isNullOrEmpty(rec) && typeof rec[0] !='object') {
								studentId.setDisabled(false);
								var academyLocations=[];
								if(rec.length > 0){
									academyLocations.push(rec);
								}
								studentId.getStore().getProxy().extraParams = {
									academyLocationIds:academyLocations.join()
								};
								studentId.getStore().load();
								program.getStore().getProxy().extraParams = {
									academyLocationIds:academyLocations.join()
								};
								program.getStore().load();
								department.getStore().getProxy().extraParams = {
									academyLocationIds:academyLocations.join()
								};
								department.getStore().load();
							}
						}else{
							studentId.reset();
							studentId.setDisabled(true);
							delete program.getStore().proxy.extraParams.academyLocationIds;
							delete program.getStore().proxy.extraParams.qry;
							program.getStore().load();
							delete department.getStore().proxy.extraParams.academyLocationIds;
							delete department.getStore().proxy.extraParams.programId;
							delete department.getStore().proxy.extraParams.name;
							department.getStore().load();
						}
					}
					//select : this.loadLocationComboStore
				},
        	
        	'addsponsorsearchform customcombobox#programCombo': {
        		change: function(combo, newValue, oldValue, eOpts) {
        			//this.resetOtherSearchFields(combo);
        			this.loadFeePlanCombo(combo, newValue, oldValue, eOpts);
        		}
        	},
        	
        	'addsponsorsearchform customcombobox#feePlanTypeId': {
        		change: function(combo, newVal,OldVal) {
        			combo.getStore().load();
        			//this.resetOtherSearchFields(combo);
        			this.loadFeePlanTypeCombo(combo, newVal,OldVal);
        		}
        	},
        	
        	'addsponsorsearchform customcombobox#feePlan': {
        		change: function(combo, newValue, oldValue, eOpts) {
        			this.loadStageCombo(combo, newValue, oldValue, eOpts);
        		}
        	},
        	
        	'addsponsorsearchform customcombobox#stageName': {
        		change: function(combo, newValue, oldValue, eOpts) {
        			this.loadFeePlanSequenceCombo(combo, newValue, oldValue, eOpts);
        		}
        	},
        	'addsponsorsearchform customcombobox#feePlanSequence': {
        		change: function(combo, newValue, oldValue, eOpts) {
        			this.loadFeeHeadsCombo(combo, newValue, oldValue, eOpts);
        		}
        	},
        	'addsponsorsearchform customcombobox#feeHeads': {
        		change: function(combo, newValue, oldValue, eOpts) {

        			var windowReference = combo.up('window[xtype=addsponsorwindow]');
        			if(windowReference.title == "Add Sponsor")
        			{
        				var grid=combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
        				grid.setDisabled(false);
        				this.loadConfigureSponsoredFeeGrid(combo, newValue, oldValue, eOpts);
        			}else if(windowReference.title == "Edit Sponsored Student")
        			{
        				var grid=combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
        				grid.setDisabled(false);
        				this.loadConfigureSponsoredFeeEditGrid(combo, newValue, oldValue, eOpts);
        			}else if(windowReference.title == "View Sponsor")
        			{
        				var grid=combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
        				grid.setDisabled(false);
        				this.loadConfigureSponsoredFeeEditGrid(combo, newValue, oldValue, eOpts);
        			}
        		}
        	},
        	'addsponsorwindow configuresponsorfeeheadgrid button': {
        		click: function(button) {
        			if(button.itemId === 'btnSave') {
        				this.saveSponsorFeeHeadConfiguration(button);
        			}	
        		}
        		
        	},
        	'addsponsorwindow configuresponsorfeeheadgrid': {
        		edit: function( e, component) {
        			var grid = component.grid;
        			var colIndex = component.colIdx;
        			var record = component.record;
        			if(component.field == "amountType" && component.value == "FIXED_AMOUNT") {
        				var columns = grid.columnManager.getColumns();
        			} else if(component.field == "amountType" && component.value == "PERCENTAGE") {
        			} else if(component.field == "sponsorshipPercentage") {
        				
        				if(record.get('amountType') == "PERCENTAGE") {
        					var totalAmount = record.get('amount');
            				var percentageSponsored = component.value;
            				var sponsoredAmount = (totalAmount * percentageSponsored) / 100;
            				record.set('amountSponsored', sponsoredAmount);
            				grid.down("#btnSave").setDisabled(false);
        				} 
        			} else if(component.field == "amountSponsored") {
        				var validTotal = record.get('amount');
        				var amountSponsoredCheck = record.get('amountSponsored');
        				if(record.get('amountType') == "PERCENTAGE") {
        					/*
        					 * check if user is editing amount sponsored even if the amount type is %
        					 * in this case calculate the amount and set it directly
        					 */
        					var totalAmount = record.get('amount');
        					var percentageSponsored = record.get('sponsorshipPercentage');
        					var sponsoredAmount = (totalAmount * percentageSponsored) / 100;
        					record.set('amountSponsored', sponsoredAmount);
        				}
        				if(record.get('amountType') == "FIXED_AMOUNT") {
        					if(amountSponsoredCheck <= validTotal) {
        						var totalAmount = record.get('amount');
        						var amountSponsored = component.value;
        						var percentageAmount = parseFloat((amountSponsored/totalAmount) * 100).toFixed(2);
        						record.set('sponsorshipPercentage', percentageAmount);
        						grid.down("#btnSave").setDisabled(false);
        					}else {
        						record.set('amountSponsored', 0);
        						showWarningMessage(getCommonTranslation('AMOUNT_SPONSORED'), getCommonTranslation('AMOUNT_SPONSORED_CANNOT_BE_GREATER_THAN_AMOUNT'));
        					}
        				} 

        			}
        			var panel = Ext.ComponentQuery.query('addsponsorwindow')[0];
        			if(!isNullOrEmpty(component.row.scrollHeight)){
        				var getHeight = grid.getHeight()+component.row.scrollHeight;
            			panel.body.scroll('top', getHeight, true); 
        			}
        			grid.setDisabled(false);
        		},
        		beforeedit: function( e, component) {
        			var grid = component.grid;
        			var panel = grid.up('panel[xtype=addsponsorwindow]');
        			if(grid.plugins.length == 0) {
        				return false;
        			}
        			return true;
        		},
        		cellclick:function(View, CellEl, ColIdx, records, RowEl, RowIdx, e,eopts){
        			var $this= this;
        			if(View.up().up().down("hidden#id").getValue()!= "")
        			{
        				if(records.data.isAlreadySponsored == true || records.data.isBillingDatePassed == true || records.data.isBillingDone == true){
        					return false;
        				}
        			}else{
        				if(records.data.isAlreadySponsored == true || records.data.isBillingDatePassed == true){
        					return false;
        				}
        			}
        		}
        		
        	},
        	'addsponsorwindow configuresponsorfeeheadgrid numberfield#amountSponsoredEdit': {
        		blur:function(obj, record){
        			var $this= this;
        			var grid = obj.up().up();
        			var editedRecords = grid.getStore().getUpdatedRecords();
        			if(editedRecords.length == 0)
        			{
        				var toolbar = grid.down('toolbar#buttonToolbar');
        				var buttons = toolbar.items.items;
        				Ext.each(buttons, function(btn) {
        					btn.setDisabled(true);
        				})
        			}else
        			{
        				var toolbar = grid.down('toolbar#buttonToolbar');
        				var buttons = toolbar.items.items;
        				Ext.each(buttons, function(btn) {
        					btn.setDisabled(false);
        				})
        			}
        		}
        	},
            'sponsorshiplistingsearchform  combo[itemId=scholList_scholType]': {
                render: function(combo) {
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            var model = new Academia.model.common.IdValueDataModel();
                            model.set('id', '');
                            model.set('value', 'All');
                            combo.getStore().insert(0,model);
                            //combo.getStore().add(model);
                        }
                    });
                }
            },
			'sponsorshiplistingsearchform' : {
				render : function() {
					var academyLocationIds = this.getCurrentAcademyLocation();
					var studentStore = this.getSponsorshipListForm().getForm().findField('STUDENT_ID')
							.getStore();
					studentStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
					studentStore.load();
				}
			},
			'sponsorshiplistingsearchform combo[itemId=programNameOrCodeId]': {
                select: function(combo) {
                	var $this = this;
					var form = $this.getSponsorshipListForm();
					var studentId = form.down('#sponList_studId');
					var department = form.down('#departmentByProgramDepartmentId');
					var subDepartment = form.down('#departmentBySubDepartmentId');
					department.reset();
					subDepartment.reset();
					subDepartment.setDisabled(true);
					
					departmentStore = department.getStore();
					departmentStore.getProxy().extraParams = {
						programId : combo.getValue()
					};
					departmentStore.load();
                }
            },
            'sponsorshiplistingsearchform combo[itemId=departmentByProgramDepartmentId]': {
                select: function(combo) {
                	var $this = this;
					var form = $this.getSponsorshipListForm();
					var subDepartment = form.down('#departmentBySubDepartmentId');
					var program = form.down('#programNameOrCodeId');
					subDepartment.setDisabled(false);
					subDepartmentStore = subDepartment.getStore();
					if(!isNullOrEmpty(program.getValue())) {
						subDepartmentStore.getProxy().extraParams = {
							programId : program.getValue()
						};
					} else {
						subDepartmentStore.getProxy().extraParams = {
							id : combo.getValue()
						};
					}
					subDepartmentStore.load();
                }
            }
       });
    },
    
    /**** Export function *******/
    
    exportSponsorshipList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getSponsorshipListForm();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('SPONSORSHIP_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    getDownloadFile : function(documentId,fileType){

		   if(!isNullOrEmpty(documentId)){
			   var csvForm = Ext.create('Ext.form.Panel'); 
			   csvForm.getForm().submit({
				   target: '_blank',
				   method:'POST',
				   params :{
					   access_token : Ext.Ajax.defaultHeaders.access_token
				   },
				   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
				   standardSubmit :true
			   });
		   }
	   },

    /* loadGridAndSearchUsers : function(model, records) {
    	var ListForm =this.getSponsorshipListForm();	
		var jsonFormatFormData =this.createJsonFormat(ListForm,records);
		var ResultGrid = this.getSearchResultGrid();
		var viewCode = SERVERURL.SPONSORSHIP_LISTING;
		viewCode = viewCode.concat('?viewCode=SPONSORSHIP_AWARDEES_LISTING');
		ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, viewCode, jsonFormatFormData);
    },*/
    loadSponsorAwardeesGridUsers: function(model, records) {
 	   var $this=this;
	   var form = $this.getSponsorshipListForm();
	   var studentId = form.down("#sponList_studId").getValue();
	   var sponsorId = form.down("#sponList_sponId").getValue();
	   var sponsorType = form.down("#scholList_scholType").getValue();
	   var programId = form.down("#programNameOrCodeId").getValue();
	   var departmentId = form.down("#departmentByProgramDepartmentId").getValue();
	   var subDepartmentId = form.down("#departmentBySubDepartmentId").getValue();
	   if (sponsorType != 'All') {
		   var sponsorTypeVal = sponsorType;
       }
	   var academyLocationId = form.down("#academyLocationId").getValue();
	   var searchJson=[];
	   for(var i in academyLocationId){
		   if(Ext.isObject(academyLocationId[i])){
			   searchJson.push(academyLocationId[i].data.id);
		   }else{
			   searchJson.push(academyLocationId[i]);
		   }
	   }
	   academyLocationIds=searchJson.join();
	   var grid = $this.getSponsorshipawardeesgrid();
	   var store =  grid.getStore();
	   store.getProxy().extraParams = {
		   sponsorId: sponsorId,
		   sponsorType: sponsorTypeVal,
		   academyLocationIds: academyLocationIds,
		   studentId: studentId,
		   programId: programId,
		   departmentId: departmentId,
		   subDepartmentId: subDepartmentId
	   };
	   //$this.resetPageSetting(store);
	  // store.load();
	   store.load();
   },
    
    createJsonFormat:function(ListForm) {
	   	var formValues = new Array(); 
	   	var values=new Object();
		var searchcriteria=new Array();
		
		//values.configCode="AVAILABLE_SPONSORSHIP_LIST";
		values.configCode="SPONSORSHIP_AWARDEES_LISTING";
		
		formValues =ListForm.getValues();
		if(formValues.SPONSOR_ID !=='All') {
			var SPONSORSHIP_ID = this.getJsonObject('SPONSORSHIP_ID',formValues.SPONSOR_ID);
			this.pushJsonObjectInArray(SPONSORSHIP_ID, searchcriteria);
		}
		if(formValues.SPONSOR_NAME !=='All') {
			var SPONSORSHIP_NAME = this.getJsonObject('SPONSORSHIP_NAME',formValues.SPONSOR_NAME);
			this.pushJsonObjectInArray(SPONSORSHIP_NAME, searchcriteria);
		}
		if(formValues.ACADEMY !== "All" && formValues.ACADEMY !=='') { 
			var ACADEMY_ID = this.getJsonFromArray('ACADEMY_ID',formValues.ACADEMY);
			this.pushJsonObjectInArray(ACADEMY_ID, searchcriteria);
		}
		if(formValues.LOCATION !== "All" && formValues.LOCATION !=='') {
			var LOCATION_ID = this.getJsonFromArray('LOCATION_ID',formValues.LOCATION);
			this.pushJsonObjectInArray(LOCATION_ID, searchcriteria);
		}
		if(formValues.STUDENT_ID !=='All') {
			var CODE = this.getJsonObject('CODE',formValues.STUDENT_ID);
			this.pushJsonObjectInArray(CODE, searchcriteria);
		}
		if(formValues.SPONSOR_TYPE !=='All') {
			var SPONSOR_TYPE = this.getJsonObject('SPONSOR_TYPE',formValues.SPONSOR_TYPE);
			this.pushJsonObjectInArray(SPONSOR_TYPE, searchcriteria);
		}
   	 values.searchCriterias=searchcriteria;
		return values;
	}, 
	
	getJsonObject:function(key,value, additionalValue){
		if(value!='' && additionalValue == undefined){
			return {
				"paramCode":key,
				"paramValues":[value]
			};
		} else if (value!= '' && additionalValue != undefined) {
			return {
				"paramCode":key,
				"paramValues":[value, additionalValue]
			};
		}
	},
	
	/**
	 * Method to extract the array of selected ids from the array of objects
     * @author Akshay.Kalbhor  
	 */
	getJsonFromArray:function(key,array){
		if(Ext.isArray(array)) {
			var idArray = new Array();
	    	Ext.each(array, function(arrayObj) {
	    		if(arrayObj != "All" && arrayObj != "" && arrayObj instanceof Object) {
	    			idArray.push(arrayObj.getId());	
	    		} else if(arrayObj != "All" && arrayObj != ""){
	    			idArray.push(arrayObj);
	    		}
	    	});
	    	
	    	return {
	            "paramCode": key,
	            "paramValues": idArray
	        };
		}
	},
	
   /* gridRenderFunction:function(grid){
    	grid.addButtonToolbar();
	},*/
	
	/**
	 * Method to add a new Sponsored Student.
	 * @author akshay.kalbhor
	 */
	onSponsorsoredStudentAdd: function(button) {
		var searchResultGrid = button.up('grid');
		var sponsoredStudentWindow = this.openTab('Add Sponsored Student', 'addsponsoredstudent',CONSTANTS.MENU_COLOR_TEN);
		var feeHeadAddedGrid = sponsoredStudentWindow.down('grid[xtype=sponsorfeeheadgrid]');
		this.doAccessControlValidation(feeHeadAddedGrid, this.getSPONSORED_STUDENT_PERMISSIONS());
		feeHeadAddedGrid.getStore().removeAll(true);
	},
	
	/**
	 * method to load the fee head grid on selection of a student
	 */
	loadFeeHeadGrid: function(combo) {
		var studentId = this.getStudentId();
		var sponsorfeeheadgrid = combo.up('panel').down('grid[xtype=sponsorfeeheadgrid]');
		var store = sponsorfeeheadgrid.getStore();
    	var url = SERVERURL.SPONSORED_STUDENTS_FEE_HEAD;
    	
    	url = url.concat('?studentId='+studentId);
    	store.getProxy().api.read = url;
    	store.load();
	},
	
	/**
	 * method to get the selected studentId.
	 */
	getStudentId: function() {
		var selectedStudentId = this.getStudentSearchField().getValue();
		return selectedStudentId;
	},
	
	/**
	 * function to show the *** Popup on click of Add button on the fee head grid.
	 */
	onFeeHeadGridAdd: function(button) {
		//Show the popup to add a sponsor for the selected student
		var addStudentPanel = button.up('panel[xtype=addsponsoredstudent]');
		var studentId = this.getSelectedStudentId(addStudentPanel);
		if(!isNullOrEmpty(studentId)) {
			var windowReference = this.showWindow('addsponsorwindow');
			windowReference.down('hidden#studentId').setValue(studentId);
			var programCombo = windowReference.down('customcombobox#programCombo');
			this.loadProgramCombo(programCombo, studentId);
			var grid = windowReference.down('configuresponsorfeeheadgrid');
			grid.getStore().removeAll();
		} else {
			showWarningMessage(getCommonTranslation('FEE_HEAD_ADDED'), getCommonTranslation('PLEASE_SELECT_STUDENT'));
		}
	},
	
	/**
	 * function to edit the Sponsor.
	 */
	onFeeHeadGridEdit: function(button) {
		var grid = button.up('grid[xtype=sponsorfeeheadgrid]');
		if(grid.getSelectionModel().getCount()>0){
			var selectedRecord = grid.getSelectionModel().getSelection()[0];
		var addStudentPanel = button.up('panel[xtype=addsponsoredstudent]');
		var studentId = this.getSelectedStudentId(addStudentPanel);
		var windowReference = this.showWindow('addsponsorwindow');
		var configureSponsorForm = windowReference.down('panel[xtype=addsponsorsearchform]').getForm();
		var configureSponsorGrid = windowReference.down('panel[xtype=configuresponsorfeeheadgrid]');
		if(button.itemId === 'btnEdit') {
				windowReference.setTitle(getCommonTranslation('EDIT_SPONSORED_STUDENT'));
		} else if (button.itemId === 'btnView') {
			windowReference.setTitle(getCommonTranslation('VIEW_SPONSOR'));
			configureSponsorGrid.down('toolbar#buttonToolbar').setVisible(false);
			configureSponsorGrid.setDisabled(false);
			configureSponsorGrid.plugins = new Array();
		}
		
		var selectedRecordId = selectedRecord.get('id');
		var feePlanTypeId = selectedRecord.get('feePlanTypeId');
		//Call Find By Id and set the response in the popup
		var response = this.getSponsorData(selectedRecordId,feePlanTypeId);
		
		var form = windowReference.down('panel#addsponsorsearchform');
		var admissionIdField = form.down('hidden#admissionId');
		var studentIdField = form.down('hidden#studentId');
		var idField = form.down('hidden#id');
		var sponsorField = form.down('customcombobox#sponsorId');
		sponsorField.getStore().load();
		var sponsorTypeField = form.down('customcombobox#sponsorType');
		sponsorField.setReadOnly(true);
		var awardeeDatefield = form.down('datefield#awardeeDate');
		awardeeDatefield.setReadOnly(true);
		var programField = form.down('customcombobox#programCombo');
		programField.setReadOnly(true);
		var feePlanField = form.down('customcombobox#feePlan');
		feePlanField.setReadOnly(true);
		var stageNameField = form.down('customcombobox#stageName');
		stageNameField.setReadOnly(true);
		var feePlanSequenceField = form.down('customcombobox#feePlanSequence');
		feePlanSequenceField.setReadOnly(true);
		var feeHeadsField = form.down('customcombobox#feeHeads');
		feeHeadsField.setReadOnly(true);
		var totalAmountField = form.down('textfield#totalAmount');
		var  feePlanType = form.down('#feePlanTypeId');
		feePlanType.setReadOnly(true);
		totalAmountField.setReadOnly(true);
		this.loadProgramCombo(programField, response.studentId);
		
		
		
		idField.setValue(selectedRecordId);
		feePlanType.setValue(response.feePlanTypeId);
		admissionIdField.setValue(response.admissionId);
		studentIdField.setValue(response.studentId);
		sponsorField.setValue(response.sponsorId);
		awardeeDatefield.setValue(dateRender(response.awardedDate));
		programField.setValue(response.programId);
		feePlanField.setValue(response.feePlanId);
		//stageNameField.setValue(response.feeStageHeadConfigurationId);
		setTimeout(function() {
			stageNameField.getStore().getProxy().extraParams = {
		            id: response.feePlanId,
		            feePlanTypeId: response.feePlanTypeId
		        };
			stageNameField.getStore().load({
				 callback: function(records, operation, success) {
					 stageNameField.setValue(response.feePlanRuleStageId);
				 }	   
			 });
			feePlanSequenceField.getStore().load({
					 callback: function(records, operation, success) {
						 feePlanSequenceField.setValue(response.feeSequenceId);
					 }	   
				 });
        },2000);
		var feeHeadId = response.feeHeadId;
		feeHeadsField.setValue(feeHeadId);
		totalAmountField.setValue(response.totalFeeHeadAmount);
		var sponsorshipAwardeeId = form.down('hidden#sponsorshipAwardeeId');
		sponsorshipAwardeeId.setValue(response.sponsorshipAwardeeId);
		
		
		
		//sponsorField.enable();
		feePlanField.enable();
		feePlanSequenceField.enable();
		totalAmountField.enable();
		feeHeadsField.enable();
		stageNameField.enable();
		feePlanType.enable();
		
		var sponsorshipInstallments = response.sponsorshipInstallments;
		
		this.updateConfigureFeeHeadGrid(sponsorshipInstallments, configureSponsorGrid,response);
		configureSponsorGrid.enable();
		 if (button.itemId === 'btnView') {
			 	this.toggleReadOnlyFormItems(form.getForm(), true);
			}
		} else {
			showWarningMessage(getCommonTranslation('FEE_HEAD_ADDED'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	/**
	 * method to delete the record.
	 * 
	 */
	onFeeHeadGridDelete: function(button) {
		var grid = button.up('grid');
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    var url = SERVERURL.SPONSORSHIP_AWARDED_ITEM_DELETE;
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        params: {
                            id: id
                        },
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getCommonTranslation('FEE_HEAD_ADDED'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getCommonTranslation('FEE_HEAD_ADDED'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
	},
	
	updateConfigureFeeHeadGrid: function(sponsorshipInstallments, grid,response) {
		if(!isNullOrEmpty(sponsorshipInstallments)) {
			var store = grid.getStore();
			store.removeAll();
			
			if(sponsorshipInstallments.length > 0){
				var ObjModel = [];
				for(var i = 0; i< sponsorshipInstallments.length; i++){
					   var configureSponsorGridModel = new Academia.model.sponsorship.SponsoredStudentsFeeHead();
					  var  obj = sponsorshipInstallments[i];
					   if(!isNullOrEmpty(obj.amountType)) {
						   configureSponsorGridModel.set('amountType', obj.amountType);	
						}
						if(!isNullOrEmpty(obj.amountSponsored)) {
							configureSponsorGridModel.set('amountSponsored', obj.amountSponsored);
						}
						if(!isNullOrEmpty(obj.amountSponsored)) {
							configureSponsorGridModel.set('sponsorshipPercentage', obj.sponsorshipPercentage);
						}
						if(!isNullOrEmpty(obj.id)) {
							configureSponsorGridModel.set('sponsorshipInstallmentId', obj.id);
						}
						if(!isNullOrEmpty(obj.billingDate)) {
							configureSponsorGridModel.set('billingDate', obj.billingDate);
						}
						if(!isNullOrEmpty(obj.sequence)) {
							configureSponsorGridModel.set('sequence', obj.sequence);
						}
						if(!isNullOrEmpty(obj.dueDate)) {
							configureSponsorGridModel.set('dueDate', obj.dueDate);
						}
						if(!isNullOrEmpty(obj.installmentAmount)) {
							configureSponsorGridModel.set('amount', obj.installmentAmount);
						}
						if(!isNullOrEmpty(obj.id)) {
							configureSponsorGridModel.set('id', obj.id);	
						}
						if(!isNullOrEmpty(obj.feePlanSubmissionScheduleId)) {
							configureSponsorGridModel.set('feePlanSubmissionScheduleId', obj.feePlanSubmissionScheduleId);	
						}
						ObjModel.push(configureSponsorGridModel);
 					
				}
			}
		else {	
		
			  var configureSponsorGridModel = new Academia.model.sponsorship.SponsoredStudentsFeeHead();
			   var ObjModel = [];
			   configureSponsorGridModel.set('amountType' ,response.amountType);
			   configureSponsorGridModel.set('amountSponsored' ,response.amountSponsored);
			   configureSponsorGridModel.set('sponsorshipPercentage' ,response.sponsorshipPercentage);
			   configureSponsorGridModel.set('amount' ,response.totalFeeHeadAmount);
			   ObjModel.push(configureSponsorGridModel);
			   grid.columns[0].destroy();
			   grid.columns[2].destroy();
			   grid.columns[3].destroy();
				 
			}
					
					store.loadRawData(ObjModel, true);
			/*store.load()*/
			/*store.load({callback : function(me,records,success) {
				var windowReference = Ext.ComponentQuery.query('addsponsorwindow')[0];
				if(Ext.isDefined(windowReference))
				{
					if(windowReference.title == "Edit Sponsored Student" || windowReference.title == "View Sponsor")
	    			{
	    				Ext.each(sponsorshipInstallments, function(obj) {
	    					for(var i=0; i< records.length; i++){
	    						var record = records[i];
	    						if(record.get('id') == obj.feePlanSubmissionScheduleId)	{
	    							if(!isNullOrEmpty(obj.amountType)) {
	    								record.set('amountType', obj.amountType);	
	    							}
	    							if(!isNullOrEmpty(obj.amountSponsored)) {
	    								record.set('amountSponsored', obj.amountSponsored);
	    							}
	    							if(!isNullOrEmpty(obj.amountSponsored)) {
	    								record.set('sponsorshipPercentage', obj.sponsorshipPercentage);
	    							}
	    							if(!isNullOrEmpty(obj.id)) {
	    								record.set('sponsorshipInstallmentId', obj.id);
	    							}
	    						}
	    					}
	    					store.commitChanges();
	    				});
	    			}
				}    			
            }
			});*/
			//store.load();
			
		}
	},
	
	/**
	 * method to do a ajax call and set the data in the popup 
	 */
	getSponsorData: function(id,feePlanTypeId) {
		var url = SERVERURL.SPONSORSHIP_AWARDED_FIND_BY_ID;
		var responseObj = new Object();
		Ext.Ajax.request({
            type: 'rest',
            url: url,											 
            method: 'GET',
            async: false,
            params: {
				id: id,
				feePlanTypeId: feePlanTypeId
            },
            success: function(response, success) {
            	responseObj = Ext.decode(response.responseText);
		}
	  	});
		return responseObj;
	},
	
	getSelectedStudentId: function(addStudentPanel) {
		return addStudentPanel.down('livesearchcombo[name=studentName]').getValue()
	},
	
	loadProgramCombo: function(programCombo, studentId) {
		var store = programCombo.getStore();
		 store.getProxy().extraParams = {
			 studentId:studentId
         };
         store.load();
	},
	
	loadFeePlanCombo: function(combo, newValue, oldValue, eOpts) {
		// call to get admission Id
		var store = combo.getStore();
		var studentId = combo.up('form').down('hidden#studentId').getValue();
		var feePlanCombo = combo.up('form').down('customcombobox#feePlan');
		var admissionIdField = combo.up('form').down('hidden#admissionId');
		var url = SERVERURL.FIND_ADMISSION_ID;
		var feePlanType = combo.up('form').down('customcombobox#feePlanTypeId');
		feePlanType.enable();
		var param ={
				programId :combo.getValue(),
				studentId :studentId
	           };
		this.sendGetAjaxRequest(url, 'GET', param, function(opt,success,response){
		  	if(success){
		  	  	if(!isNullOrEmpty(response.responseText)) {
			  		var responseObj = Ext.decode(response.responseText);
			  		admissionIdField.setValue(responseObj);
					admissionId = admissionIdField.getValue();
					/*feePlanCombo.setDisabled(false)
					feePlanCombo.getStore().getProxy().extraParams = {
						id:admissionId
					};
					feePlanCombo.getStore().load();*/
		  	  	}
		  	}
	  	});
	},
	loadFeePlanTypeCombo :function(combo,record){
		var form = this.getAddsponsorsearchform();
		var this$ =this;
		var feePlan = form.down('#feePlan');
		var stageName = form.down('#stageName');
		var feePlanRule = form.down('#feePlanSequence');
		var feeHeads = form.down('#feeHeads');
		var program = form.down('#programCombo');
		var admissionIdField = combo.up('form').down('hidden#admissionId');
		var studentIdFld = form.down('#studentId');
		var totalAmount = form.down('#totalAmount');
		var feePlanSequence = form.down('#feePlanSequence');
		var url = SERVERURL.FIND_ADMISSION_ID;
		
		feePlan.enable();	
		feePlan.reset();
		
		stageName.reset();		
		stageName.disable();
		
		feePlanRule.reset();
		feePlanRule.disable();
		feePlanSequence.clearValue();
		totalAmount.reset();
		feeHeads.reset();
		feeHeads.disable();
		setTimeout(function(){
			var param ={
					programId :program.getValue(),
					studentId :studentIdFld.getValue()
		           };
			this$.sendGetAjaxRequest(url, 'GET', param, function(opt,success,response){
			  	if(success){
			  	  	if(!isNullOrEmpty(response.responseText)) {
				  		var responseObj = Ext.decode(response.responseText);
				  		admissionIdField.setValue(responseObj);
						admissionId = admissionIdField.getValue();
						//feePlanCombo.setDisabled(false)
						feePlan.getStore().getProxy().extraParams = {
							feePlanTypeId: record,
							id:admissionId
						};
						feePlan.getStore().load();
			  	  	}
			  	}
		  	});
		},500);
	
	},
	loadStageCombo: function(combo, newValue, oldValue, eOpts) {
		var feePlanId = combo.getValue();
		var stageCombo = combo.up('form').down('customcombobox#stageName');
		var feePlanSequenceCombo = combo.up('form').down('customcombobox#feePlanSequence');
		var feeHeadsCombo = combo.up('form').down('customcombobox#feeHeads');
		var feePlanTypeId = combo.up('form').down('customcombobox#feePlanTypeId').getValue();
		stageCombo.setDisabled(false);
		stageCombo.getStore().getProxy().extraParams = {
			id:feePlanId,
			feePlanTypeId:feePlanTypeId
		};
		stageCombo.clearValue();
		stageCombo.getStore().load();
		feePlanSequenceCombo.clearValue();
		feeHeadsCombo.clearValue();
		
	},
	
	loadFeePlanSequenceCombo: function(combo, newValue, oldValue, eOpts) {
		var stageId = combo.getValue();
		var feePlanId = combo.up('form').down('customcombobox#feePlan').getValue();
		var admissionId = combo.up('form').down('hidden#admissionId').getValue();
		var feePlanSequenceField = combo.up('form').down('customcombobox#feePlanSequence');
		var feeHeadsCombo = combo.up('form').down('customcombobox#feeHeads');
		feePlanSequenceField.setDisabled(false);
		var store = feePlanSequenceField.getStore();
		store.getProxy().extraParams = {
			feePlanId: feePlanId,
			admissionId :admissionId ,
			stageId :stageId 
		};
		if(feePlanId &&stageId ){
			store.load();
		}
		
	},
	
	loadFeeHeadsCombo: function(combo, newValue, oldValue, eOpts) {
		var this$ = this;
		var feePlanSequenceId = combo.getValue();
		var feeHeadsCombo = combo.up('form').down('customcombobox#feeHeads');
		feeHeadsCombo.setDisabled(false);
		feeHeadsCombo.getStore().getProxy().extraParams = {
			/**
			 * Sending the feeplanRuleId as feePlanSequence Id after the clarification of Nitin Gaikwad in the GoogleSheet API#175
			 */
			feePlanRuleId:feePlanSequenceId
		};
		
	
		
		
		feeHeadsCombo.getStore().load({
			callback:function(record){
				if(record.length == 1){
					feeHeadsCombo.setValue(record[0].data.id);	
					
					/*var windowReference = combo.up('window[xtype=addsponsorwindow]');
					if(windowReference.title == "Add Sponsor")
					{
						var grid=combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
						grid.setDisabled(false);
						this$.loadConfigureSponsoredFeeGrid(combo, newValue, oldValue, eOpts);
					}else if(windowReference.title == "Edit Sponsored Student")
					{
						var grid=combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
						grid.setDisabled(false);
						this$.loadConfigureSponsoredFeeEditGrid(combo, newValue, oldValue, eOpts);
					}else if(windowReference.title == "View Sponsor")
					{
						var grid=combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
						grid.setDisabled(false);
						this$.loadConfigureSponsoredFeeEditGrid(combo, newValue, oldValue, eOpts);
					}
				*/
				}
			}
		});
	},
	
	loadConfigureSponsoredFeeGrid: function(combo, newValue) {
		var configureSponsoredFeeGrid = combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
		var gridStore = configureSponsoredFeeGrid.getStore();
		var feeStageHeadConfigId = combo.up('form').down('hidden#feeStageHeadConfigId').getValue();
		var feePlanTypeId = combo.up('form').down('#feePlanTypeId').getValue();

		var feePlanTypeIdVal = combo.up('form').down('#feePlanTypeId').getRawValue();

		var studentId = combo.up('form').down('hidden#studentId').getValue();
		gridStore.getProxy().extraParams = {
			feeStageHeadConfigId: feeStageHeadConfigId,
			studentId: studentId,
			feePlanTypeId: feePlanTypeId
		};
		var feeTypeVal = combo.up('form').down('#feePlanTypeId').getRawValue();
		if(feeTypeVal == "Courses"){
			configureSponsoredFeeGrid.columns[0].hideable = false;
			configureSponsoredFeeGrid.columns[0].hide();
			configureSponsoredFeeGrid.columns[2].hideable = false;
			configureSponsoredFeeGrid.columns[2].hide();
			configureSponsoredFeeGrid.columns[3].hideable = false;
			configureSponsoredFeeGrid.columns[3].hide();

		}else{
			configureSponsoredFeeGrid.columns[0].hideable = true;

			configureSponsoredFeeGrid.columns[2].hideable = true;

			configureSponsoredFeeGrid.columns[3].hideable = true;

			configureSponsoredFeeGrid.columns[0].show();
			configureSponsoredFeeGrid.columns[2].show();
			configureSponsoredFeeGrid.columns[3].show();
		}
		if(newValue){
			gridStore.load({
				callback: function(records, operation, success) {
					var toolbar = configureSponsoredFeeGrid.down('toolbar#buttonToolbar');
					var buttons = toolbar.items.items;
					Ext.each(buttons, function(btn) {
						if(btn.itemId == 'btnSave') {
							btn.setDisabled(true);
						}
					}) 
				}
			});
		}


		
		//getStore().reload();
	},
	loadConfigureSponsoredFeeEditGrid: function(combo, newValue) {
		var configureSponsoredFeeGrid = combo.up('window[xtype=addsponsorwindow]').down('grid#configuresponsorfeeheadgrid');
		var gridEditStore = configureSponsoredFeeGrid.getStore();
		var feeStageHeadConfigId = combo.up('form').down('hidden#feeStageHeadConfigId').getValue();
		var studentId = combo.up('form').down('hidden#studentId').getValue();
		var sponsorId = combo.up('form').down('#sponsorId').getValue();
		var feeTypeVal = combo.up('form').down('#feePlanTypeId').getRawValue();
	
		/*gridEditStore.getProxy().extraParams = {
			feeStageHeadConfigId: feeStageHeadConfigId,
			sponsorId: sponsorId,
			studentId: studentId
		};
		gridEditStore.load({
			callback: function(records, operation, success) {
				var toolbar = configureSponsoredFeeGrid.down('toolbar#buttonToolbar');
				var buttons = toolbar.items.items;
				Ext.each(buttons, function(btn) {
					if(btn.itemId == 'btnSave') {
						btn.setDisabled(true);
					}
				}) 
			}
		});*/
		/*if(feeTypeVal == "Courses"){
			configureSponsoredFeeGrid.columns[0].destroy();
			configureSponsoredFeeGrid.columns[2].destroy();
			configureSponsoredFeeGrid.columns[3].destroy();
			
		}*/
		//getStore().reload();
	},
	
	saveSponsorFeeHeadConfiguration: function(button) {
		var this$ = this;
		var configurationGrid = button.up('grid');
		var configurationWindow = button.up('window[xtype=addsponsorwindow]');
		var configurationForm = configurationWindow.down('form[xtype=addsponsorsearchform]');
		var formValues = new Object();
		var configFormValues = configurationForm.getValues();
		var sponsorshipAwardedItems = new Array(); 
		formValues.studentId = configFormValues.studentId;
		configFormValues.feeStageHeadConfigurationId = configFormValues.feeStageHeadConfigurationId;
		delete configFormValues.studentId;
		delete configFormValues.SPONSOR_TYPE;
		var totalSponsoredAmount = this.calculateTotalSponsoredAmt();
		configFormValues.totalSponsoredAmount= totalSponsoredAmount;
		var store = configurationGrid.getStore();
//    	var updatedRecords =  store.getUpdatedRecords();
		var updatedRecords =  store.data.items;
    	/*for (var i = 0; i < store.data.items.length; i++) {
    		if(store.data.items[i].data.amountType == '')
    		{
    			showWarningMessage(getCommonTranslation('CONFIGURE_SPONSOR_FEE_HEADS'), getCommonTranslation('PLEASE_SELECT_AMOUNT_TYPE'));
    			return false;
    		}else if(store.data.items[i].data.amountSponsored == '')
    		{
    			showWarningMessage(getCommonTranslation('CONFIGURE_SPONSOR_FEE_HEADS'), getCommonTranslation('PLEASE_FILLED_AMOUNT_SPONSORED'));
    			return false;
    		}else if(store.data.items[i].data.amountType == 'PERCENTAGE' && store.data.items[i].data.sponsorshipPercentage=='')
    			{
    			showWarningMessage(getCommonTranslation('CONFIGURE_SPONSOR_FEE_HEADS'), getCommonTranslation('PLEASE_FILLED_PERCENT_SPONSORED'));
    			return false;
    			}
    	}*/
    	var sponsorshipInstallments = new Array();
    	if(configFormValues.id!=""){
    		formValues.id = configFormValues.sponsorshipAwardeeId;
    		/*Ext.each(store.data.items, function(record) {
        		var updatedRecord = new Object();
        		updatedRecord.amountType = record.get('amountType');
        		updatedRecord.amountSponsored = record.get('amountSponsored');
        		updatedRecord.sponsorshipPercentage = record.get('sponsorshipPercentage');
        		updatedRecord.feePlanSubmissionScheduleId = record.get('feePlanSubmissionScheduleId');
        		updatedRecord.id = record.get('id');
        		sponsorshipInstallments.push(updatedRecord);
        	});*/
    		for(var i in updatedRecords){
				var updatedRecord = new Object();
				updatedRecord.amountType = updatedRecords[i].data.amountType;
				updatedRecord.amountSponsored = updatedRecords[i].data.amountSponsored;
				updatedRecord.sponsorshipPercentage = updatedRecords[i].data.sponsorshipPercentage;
				updatedRecord.feePlanSubmissionScheduleId = updatedRecords[i].data.id;
				updatedRecord.id = updatedRecords[i].data.sponsorshipInstallmentId;
				sponsorshipInstallments.push(updatedRecord);
			}
        	configFormValues.sponsorshipInstallments = sponsorshipInstallments;
        	sponsorshipAwardedItems.push(configFormValues);
        	formValues.sponsorshipAwardedItems = sponsorshipAwardedItems;
    		var submitData = Ext.encode(formValues);
    		var url = SERVERURL.PATH_SPONSORSHIP_UPDATE;
        	this$.applyWindowMask(); 
        	this.sendSaveAjaxRequest(url, 'POST', submitData, function(opt,success,response){
        		this$.hideWindowMask();
    		  	if(success){
    		  		configurationWindow.close();
    		  		this$.getSponsorFeeHeadGrid().getStore().reload();
    		  		showSuccessMessage(getCommonTranslation('CONFIGURE_SPONSOR_FEE_HEADS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
    		  	}
    	  	});
    	}else{
    		if(configurationForm.isValid()) {
    			//Ext.each(store.data.items, function(record) {
    			for(var i in updatedRecords){
    				var updatedRecord = new Object();
        			//V2D-358747 start
    				if(!isNullOrEmpty(updatedRecords[i].data.amountType)){
    				updatedRecord.amountType = updatedRecords[i].data.amountType;
    				}
        			//V2D-358747 end

    				updatedRecord.amountSponsored = updatedRecords[i].data.amountSponsored;
    				updatedRecord.sponsorshipPercentage = updatedRecords[i].data.sponsorshipPercentage;
    				updatedRecord.feePlanSubmissionScheduleId = updatedRecords[i].data.id;
    				updatedRecord.id = updatedRecords[i].data.sponsorshipInstallmentId;
    				sponsorshipInstallments.push(updatedRecord);
    			}
    	    //	});
    	    	configFormValues.sponsorshipInstallments = sponsorshipInstallments;
    	    	sponsorshipAwardedItems.push(configFormValues);
    	    	formValues.sponsorshipAwardedItems = sponsorshipAwardedItems;
    			var submitData = Ext.encode(formValues);
    			
    			//V2D-358747 start
    			
    			/*for(var i=0;i<formValues.sponsorshipAwardedItems.length;i++){
    				for(var j=0;j<formValues.sponsorshipAwardedItems[i].sponsorshipInstallments.length;j++){
    					if(isNullOrEmpty(formValues.sponsorshipAwardedItems[i].sponsorshipInstallments[j].amountType)){
    						return showWarningMessage(getCommonTranslation('ALERT'),"Amount Type can not be empty");
    					}
    				}
    			}*/
    			
    			//V2D-358747 end

    			
        		var url = SERVERURL.CREATE_UPDATE_SPONSORSHIP_AWARDEE;
            	this$.applyWindowMask(); 
            	this.sendSaveAjaxRequest(url, 'POST', submitData, function(opt,success,response){
            		this$.hideWindowMask();
        		  	if(success){
        		  		configurationWindow.close();
        		  		this$.getSponsorFeeHeadGrid().getStore().reload();
        		  		showSuccessMessage(getCommonTranslation('CONFIGURE_SPONSOR_FEE_HEADS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
        		  	}
        	  	});
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));			
        	}
    	}
    	
    	
	},
    
	
	/**
     * This function is used to calculate total Sponsored Amount of grid
     */
	calculateTotalSponsoredAmt: function() {
        var grid = this.getConfigureSponsorFeeheadGrid();
        var store = grid.getStore();
        var data = store.data.items;
        var Total = 0;
        for (var i = 0; i < data.length; i++) {
        	if(!isNullOrEmpty(data[i].data.amountSponsored) && data[i].data.amountSponsored !== "") {
        		Total = Total + parseInt(data[i].data.amountSponsored);	
        	}
        }
        return Total;
    },
    /**
     * This method is used to load sponsorship's past data
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadSponsorshipsPastDataGrid: function(model, records) {
        var searchForm = this.getViewSponsorshipsPastDataSearchForm();
        var jsonFormatFormData = null;
        jsonFormatFormData = this.createSponsorshipPastDataJsonFormat(searchForm, records);
        var resultGrid = this.getSponsorshipPastDataSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.VIEW_SPONSORSHIP_PAST_DATA_VIEWCODE);
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },
    
    /**
     * This method is used to create JSON format of Past data form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createSponsorshipPastDataJsonFormat: function(searchForm) {
    	
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
       
        values.configCode = CONSTANTS.CB.VIEW_SPONSORSHIP_PAST_DATA_BASIC_CONFIGCODE;
        
        formValues = searchForm.getValues();
        
        var STUDENT_ID = this.getJsonObjectForEmpty('STUDENT_ID',"");
        this.pushJsonObjectInEmptyArray(STUDENT_ID, searchcriteria);
        var SPONSOR_ID = this.getJsonObjectForEmpty('SPONSOR_ID',"");
        this.pushJsonObjectInEmptyArray(SPONSOR_ID, searchcriteria);
        
        var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', formValues.PROGRAM_ID);
        this.pushJsonObjectInArray(PROGRAM_ID, searchcriteria);
        
        if(formValues.BATCH_ID !== undefined){
        	var BATCH_ID = this.getJsonObject('BATCH_ID', formValues.BATCH_ID);
            this.pushJsonObjectInArray(BATCH_ID, searchcriteria);
        }
        
        if(formValues.PROG_BATCH_PERIOD_CONFIG_ID !== undefined){
	        var PROG_BATCH_PERIOD_CONFIG_ID = this.getJsonObject('PROG_BATCH_PERIOD_CONFIG_ID', formValues.PROG_BATCH_PERIOD_CONFIG_ID);
	        this.pushJsonObjectInArray(PROG_BATCH_PERIOD_CONFIG_ID, searchcriteria);
        }
        
       /* var USER_ID = this.getJsonObject('USER_ID',formValues.STUDENT_ID);
        this.pushJsonObjectInArray(USER_ID, searchcriteria);*/
        
       /* var SPONSOR_MAIN_ID = this.getJsonObject('SPONSOR_MAIN_ID',formValues.SPONSOR_ID);
        this.pushJsonObjectInArray(SPONSOR_MAIN_ID, searchcriteria);*/
        
        var STUDENT_CODE = this.getJsonObject('STUDENT_CODE', formValues.STUDENT_ID);
        this.pushJsonObjectInArray(STUDENT_CODE, searchcriteria);
        
        var BILLING_DATE_FROM = this.getJsonObject('BILLING_DATE_FROM', formValues.BILLING_DATE_FROM);
        this.pushJsonObjectInArray(BILLING_DATE_FROM, searchcriteria);
        
        var BILLING_DATE_TO = this.getJsonObject('BILLING_DATE_TO', formValues.BILLING_DATE_TO);
        this.pushJsonObjectInArray(BILLING_DATE_TO, searchcriteria);
        
        var STUDENT_NAME = this.getJsonObject('STUDENT_NAME', formValues.STUDENT_NAME);
        this.pushJsonObjectInArray(STUDENT_NAME, searchcriteria);

        var SPONSOR_CODE = this.getJsonObject('SPONSOR_CODE', formValues.SPONSOR_ID);
        this.pushJsonObjectInArray(SPONSOR_CODE, searchcriteria);

        var SPONSOR_NAME = this.getJsonObject('SPONSOR_NAME', formValues.SPONSOR_NAME);
        this.pushJsonObjectInArray(SPONSOR_NAME, searchcriteria);
        
        
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object && !isNullOrEmpty(object.paramValues[0])) {
            array.push(object);
        }
    },
    /**
     * its for null/empty value
     */
    getJsonObjectForEmpty: function(key, value, additionalValue) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
    },
    pushJsonObjectInEmptyArray: function(object, array) {
            array.push(object);
    },
    
    /**
     * This is used to show past data panel on click of viewPastData
     */
    
    onClickViewDetailsLinkPanel: function() {
        this.openTab(getCommonTranslation('SPONSORSHIPS'), 'viewpastdataadvancesearchview',CONSTANTS.MENU_COLOR_TEN);
    },
    /**
     * This method is used to load batch combo 
     * @param cmb reference of combo
     */
    loadBatchComboStore : function(cmb){  	
    	var combo = cmb.up('form').down('#batch');
    	var periodCombo = cmb.up('form').down('#period');
    	combo.setDisabled(false);
    	combo.clearValue();
    	periodCombo.clearValue();
    	periodCombo.setDisabled(true);
    	var store = combo.getStore();
    	store.getProxy().extraParams = {
    		id : cmb.getValue()
       	};  
    	store.load();
    },
    /**
     * This is used to load period combo on select of batch 
     */
    loadPeriodComboStore : function(cmb){
    	var periodCombo = cmb.up('form').down('#period');
	    var periodStore = periodCombo.getStore();
	    periodCombo.setDisabled(false);
	    periodCombo.clearValue();
	    periodStore.getProxy().extraParams = {
	 		id : cmb.getValue()
       	};  
		periodStore.load();
	},
	  /**
     * This method is used to load location combo 
     * @param cmb reference of combo
     */
    loadLocationComboStore : function(cmb){  	
    	var combo = cmb.up('form').down('#LOCATION');
    	combo.setDisabled(false);
    	var store = combo.getStore();
    	store.getProxy().extraParams = {
    		id : cmb.getValue()
       	};  
    	store.load();
    },
    /**
     * This is used to delete selected record of sponsorship listing
     */
    onSponsorshipDelete: function() {
    	var me = this;
        var grid = this.getSponsorshipawardeesgrid();
        if (grid.getSelectionModel().getCount() > 0) {
         showConfirmMessage(getCommonTranslation('DELETE_SPONSORSHIP'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
         if (btn == 'yes') {
		        var records = grid.getSelectionModel().getSelection()[0];
		        var id = records.data.ID;
		        var response = me.getBillGenerationResponse(records);
		        if(response === 'true'){
		        	 Ext.Ajax.request({
				            type: 'rest',
				            method: 'DELETE',
				            url: SERVERURL.CREATE_UPDATE_SPONSORSHIP_AWARDEE + '/'+ id,
				            success: function(form, action) {
				                grid.getStore().reload();
				                showSuccessMessage(getCommonTranslation('DELETE_SPONSORSHIP'), getCommonTranslation('SPONSORSHIP_DELETE_SUCCESS'));
				            }
				     });
		        }else{
		        	showErrorMessage(getCommonTranslation('DELETE_SPONSORSHIP'),getCommonTranslation('DELETE_ERROR'));
		        }
        	}
         });
        } else {
            showWarningMessage(getCommonTranslation('DELETE_SPONSORSHIP'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * This is used to get response of bill generation 
     */
    getBillGenerationResponse :function(record){
    	
 	   var data = null;
 	   Ext.Ajax.request({
            type: 'rest',
            async: false,
            method: 'GET',
            url: SERVERURL.GET_BILL_GENERATED_RESPONSE, 
            params: {
         	   studentId : record.get('STUDENT_ID'),
 	   		   sponsorId : record.get('SPONSORID'),
 	   		   sponsorshipAwardeeItemId : null
            },
            success: function(response, action) {
          	  if(!isNullOrEmpty(response.responseText)){
          		 data = Ext.decode(response.responseText);
          	  }            	  
            }
        });
 	   return data;
    },
    
    onSponsorsoredStudentEdit: function(button) {
    	var grid = button.up('grid');
		if(grid.getSelectionModel().getCount()>0){
			var selectedRecord = grid.getSelectionModel().getSelection()[0];
			var textToShow = selectedRecord.data.studentCode+ ' / ' + selectedRecord.data.studentPrintName;
			var studentId = selectedRecord.data.studentId;
			var sponsoredStudentTab;
			if(button.itemId == 'btnEdit') {
				sponsoredStudentTab = this.openTab(getCommonTranslation('EDIT_SPONSORED_STUDENT'), 'addsponsoredstudent',CONSTANTS.MENU_COLOR_TEN);
				var grid = sponsoredStudentTab.down('panel[xtype=sponsorfeeheadgrid]');
				this.doAccessControlValidation(grid, this.getSPONSORED_STUDENT_PERMISSIONS());				
			} else if (button.itemId == 'btnView') {
				/*
				 * In case of view button is clicked then disable all the buttons other than the view button. 
				 */
				sponsoredStudentTab = this.openTab(getCommonTranslation('VIEW_SPONSORED_STUDENT'), 'addsponsoredstudent',CONSTANTS.MENU_COLOR_TEN);
				var grid = sponsoredStudentTab.down('panel[xtype=sponsorfeeheadgrid]');
				this.doAccessControlValidation(grid, this.getSPONSORED_STUDENT_PERMISSIONS());
				var toolbar = grid.down('toolbar#buttonToolbar');
				var buttons = toolbar.items.items;
				Ext.each(buttons, function(btn) {
					if(btn.itemId != 'btnView') {
						btn.setVisible(false);
					}
				})
			}
			var liveSearchCombo = sponsoredStudentTab.down('combo[xtype=livesearchcombo]');
			var model = Ext.create('Academia.model.common.LiveSearchComboModel');
			model.set('id', studentId);
			model.set('value', textToShow);
			liveSearchCombo.setValue(model);
			liveSearchCombo.setReadOnly(true);
			this.loadFeeHeadGrid(liveSearchCombo);
		} else {
			showWarningMessage(getCommonTranslation('SPONSORSHIP_LISTING'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    
    checkBillGeneration: function() {
    	var url = SERVERURL.GET_BILL_GENERATED_RESPONSE;
    	var param ={
				programId :combo.getValue(),
				studentId :studentId
	           };
    	this.sendGetAjaxRequest(url, 'GET', param, function(opt,success,response){
		  	if(success){
		  	  	if(!isNullOrEmpty(response.responseText)) {
			  		var responseObj = Ext.decode(response.responseText);
			  		admissionIdField.setValue(responseObj)
					admissionId = admissionIdField.getValue();
					feePlanCombo.setDisabled(false)
					feePlanCombo.getStore().getProxy().extraParams = {
						id:admissionId
					};
					feePlanCombo.getStore().load();
		  	  	}
		  	}
	  	});
    },
    
    resetOtherSearchFields: function(combo) {
    	var container = combo.up('panel[xtype=addsponsorsearchform]');
    	var feePlanId= container.down('combo[name=feePlanId]');
    	var feePlanRuleStageId= container.down('combo[name=feePlanRuleStageId]');
    	var feeSequenceId= container.down('combo[name=feeSequenceId]');
    	var feeHeadId= container.down('combo[name=feeHeadId]');
    	var totalFeeHeadAmount = container.down('textfield[name=totalFeeHeadAmount]');
    	
    	switch(combo.name) {
    	case 'programId':
    		this.clearCombo(feePlanId);
    		this.clearCombo(feePlanRuleStageId);
    		this.clearCombo(feeSequenceId);
    		this.clearCombo(feeHeadId);
    		totalFeeHeadAmount.reset();
    		break;
    	case 'feePlanId':
    		this.clearCombo(feePlanRuleStageId);
    		this.clearCombo(feeSequenceId);
    		this.clearCombo(feeHeadId);
    		totalFeeHeadAmount.reset();
    		break;
    	case 'feePlanRuleStageId':
    		this.clearCombo(feeSequenceId);
    		this.clearCombo(feeHeadId);
    		totalFeeHeadAmount.reset();
    		break;
    	case 'feeSequenceId':
    		this.clearCombo(feeHeadId);
    		totalFeeHeadAmount.reset();
    		break;
    	case 'feeHeadId':
    		break;
    	}
    },
    
    /**
	 * function to clear the combo store, clear its existing value
	 *  and remove all the records from the store.
	 *  @param {Object} the reference of the combo whose store should be cleared.
	 */
	clearCombo: function(combo) {
		combo.clearValue();
		combo.store.removeAll();
	}
});
