/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.currentEnrollmentReport.StudentCurrentEnrollmentReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['common.ReligionStore','common.IntakeYearStore','common.AcademicTermStore','common.ProgramForBillStore',
	         'program.ProgramGroupStore','program.ProgramCategoryStore','enquiry.AcademicBatchStore','organization.CityByCountryRegion',
	         'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','organization.CountryRegionStore',
	         'common.CastCategoryStore','common.CountryStore','student.report.StudentDemographicReportStore','common.AcademyLocationNameSeparated',
	         'student.report.StdDemographicReportGridStore','enquiry.studentDetail.GenderStore',
	         'student.studentenrollmentreport.StudentCurrentEnrollmentStore',
	         'student.studentenrollmentreport.StudentSucceedingEnrollmentStore',
	         'admission.applicationFormSale.ProgramGroupComboStore','program.ProgramByGroupIdStore',
	         'student.studentenrollmentreport.StudentCurrentReportStore',
	         'student.studentenrollmentreport.StudentCurrentTotalReportStore',
	         'student.studentenrollmentreport.StudentLeavingReportStore',
	         'student.studentenrollmentreport.StudentLeftReportStore',
	         'student.studentenrollmentreport.StudentRepeatReportStore',
	         'student.studentenrollmentreport.StudentStartingReportStore',
	         'student.studentenrollmentreport.StudentConfirmedReportStore',
	         'student.studentenrollmentreport.StudentProjectedPromotionReportStore',
	         'student.studentenrollmentreport.StudentSucceedingTotalReportStore'],
	         views: ['student.currentEnrollmentReport.StudentCurrentEnrollmentReportTabStructure',
	                 'student.currentEnrollmentReport.StudentCurrentEnrollmentReportStructure','student.currentEnrollmentReport.StudentCurrentEnrollmentReportGrid',
	                 'student.currentEnrollmentReport.StudentCurrentEnrollmentReportFilter','student.succeedingEnrollmentReport.StudentSucceedingEnrollmentReportGrid',
	                 'baselayout.contentarea.ContentPanel','student.succeedingEnrollmentReport.StudentConfirmedReportStructure',
	                 'student.succeedingEnrollmentReport.StudentProjectedPromotionReportStructure','student.succeedingEnrollmentReport.StudentSucceedingTotalReportStructure',
	                 'student.succeedingEnrollmentReport.StudentConfirmedReportGrid','student.succeedingEnrollmentReport.StudentProjectedPromotionReportGrid',
	                 'student.succeedingEnrollmentReport.StudentSucceedingTotalReportGrid',
	                 'student.currentEnrollmentReport.StudentCurrentReportStructure','student.currentEnrollmentReport.StudentCurrentReportGrid',
	                 'student.currentEnrollmentReport.StudentCurrentTotalReportStructure','student.currentEnrollmentReport.StudentCurrentTotalReportGrid',
	                 'student.currentEnrollmentReport.StudentLeavingReportStructure','student.currentEnrollmentReport.StudentLeavingReportGrid',
	                 'student.currentEnrollmentReport.StudentLeftReportStructure','student.currentEnrollmentReport.StudentLeftReportGrid',
	                 'student.currentEnrollmentReport.StudentRepeatReportStructure','student.currentEnrollmentReport.StudentRepeatReportGrid',
	                 'student.currentEnrollmentReport.StudentStartingReportStructure','student.currentEnrollmentReport.StudentStartingReportGrid'],
	                 config : {        	 
	                 },
	                 refs: [{
	                	 ref: 'studentcurrentenrollmentreportfilter',
	                	 selector: 'studentcurrentenrollmentreportfilter'
	                 },{
                   	  	 ref: 'contentpanel',
                   	  	 selector: 'contentpanel'
	                 },{
	                	 ref: 'studentcurrentenrollmentreportgrid',
	                	 selector: 'studentcurrentenrollmentreportgrid'
	                 },/*{
	                	 ref: 'StudentsucceedingenrollmentreportGrid',
	                	 selector: 'contentpanel'
	                 },*/{
	                	 ref: 'studentsucceedingenrollmentreportgrid',
	                	 selector: 'studentsucceedingenrollmentreportgrid'
	                 },{
	                	 ref: 'studentconfirmedreportstructure',
	                	 selector: 'studentconfirmedreportstructure'
	                 },{
	                	 ref: 'studentleftreportgrid',
	                	 selector: 'studentleftreportgrid'
	                 },{
	                	 ref: 'studentcurrentreportgrid',
	                	 selector: 'studentcurrentreportgrid'
	                 },{
	                	 ref: 'studentcurrenttotalreportgrid',
	                	 selector: 'studentcurrenttotalreportgrid'
	                 },{
	                	 ref: 'studentleavingreportgrid',
	                	 selector: 'studentleavingreportgrid'
	                 },{
	                	 ref: 'studentrepeatreportgrid',
	                	 selector: 'studentrepeatreportgrid'
	                 },{
	                	 ref: 'studentstartingreportgrid',
	                	 selector: 'studentstartingreportgrid'
	                 },{
	                	 ref: 'studentconfirmedreportgrid',
	                	 selector: 'studentconfirmedreportgrid'
	                 },{
	                	 ref: 'studentprojectedpromotionreportgrid',
	                	 selector: 'studentprojectedpromotionreportgrid'
	                 },{
	                	 ref: 'studentsucceedingtotalreportgrid',
	                	 selector: 'studentsucceedingtotalreportgrid'
	                 },{
	                	 ref: 'studentleftreportstructure',
	                	 selector: 'studentleftreportstructure'
	                 },{
                		ref: 'studentcurrentreportstructure',
                		selector: 'studentcurrentreportstructure'
                	},{
                		ref: 'studentleavingreportstructure',
                		selector: 'studentleavingreportstructure'
                	},{
                		ref: 'studentrepeatreportstructure',
                		selector: 'studentrepeatreportstructure'
                	},{
                		ref: 'studentstartingreportstructure',
                		selector: 'studentstartingreportstructure'
                	},{
                		ref: 'studentcurrenttotalreportstructure',
                		selector: 'studentcurrenttotalreportstructure'
                	},{
                		ref: 'studentconfirmedreportstructure',
                		selector: 'studentconfirmedreportstructure'
                	},{
                		ref: 'studentprojectedpromotionreportstructure',
                		selector: 'studentprojectedpromotionreportstructure'
                	},{
                		ref: 'studentsucceedingtotalreportstructure',
                		selector: 'studentsucceedingtotalreportstructure'
                	}],
                	config: {
                		CURRENT_STUDENT_ENROLLMENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CURRENT_STUDENT_ENROLLMENT_REPORT_PRIVILEGES'),
                		SUCCEEDING_ENROLLMENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SUCCEEDING_ENROLLMENT_REPORT_PRIVILEGES'),
                		LEFT_STUDENTS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEFT_STUDENTS_REPORT_PRIVILEGES'),
                		CURRENT_STUDENTS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CURRENT_STUDENTS_REPORT_PRIVILEGES'),
                		LEAVING_STUDENTS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LEAVING_STUDENTS_REPORT_PRIVILEGES'),
                		REPEAT_STUDENTS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REPEAT_STUDENTS_REPORT_PRIVILEGES'),
                		STARTING_STUDENTS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STARTING_STUDENTS_REPORT_PRIVILEGES'),
                		CURRENT_TOTAL_ENROLLMENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CURRENT_TOTAL_ENROLLMENT_REPORT_PRIVILEGES'),
                		CONFIRMED_STUDENTS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CONFIRMED_STUDENTS_REPORT_PRIVILEGES'),
                		PROJECTED_PROMOTIONS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROJECTED_PROMOTIONS_REPORT_PRIVILEGES'),
                		SUCCEEDING_TOTAL_ENROLLMENT_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SUCCEEDING_TOTAL_ENROLLMENT_REPORT_PRIVILEGES'),
                	},
	            	
	                 init: function(application) {
	                	 this.control({
	                		 'studentcurrentenrollmentreportfilter' : {
	                			 render: function(obj){
	                				 var academyLocationCombo = obj.down('#academyLocationId');
	                				 var academyLocationId = this.getCurrentAcademyLocation();
	                				 var store = academyLocationCombo.getStore();
	                				 store.load({
	                 					 callback: function(records, operation, success) {
	                 						 for(var i in records){
	                 							 if(records[i].data.id == academyLocationId){
	                 								academyLocationCombo.setValue(records[i].data.id);
	                 							 }
	                 						 }
	                 					 }
	                 				 });
	                				 var succeedingReportGrid = this.getStudentsucceedingenrollmentreportgrid();
	                				 var succeedingReportStore = succeedingReportGrid.getStore();
	                				 succeedingReportStore.proxy.extraParams = {
	                                		 academyLocationId : academyLocationId,
	               							 /*programGroupId : programGroupId,
	               							 programId : programId,*/
	                                 };
	                				 succeedingReportStore.load();
	                                 
	                                 var currentReportGrid = this.getStudentcurrentenrollmentreportgrid();
	                                 var currentReportStore = currentReportGrid.getStore();
	                                 currentReportStore.proxy.extraParams = {
	                                		 academyLocationId : academyLocationId,
	                                		 /*programGroupId : programGroupId,
	               							 programId : programId,*/
	                                 };
	                                 currentReportStore.load();
	                			 }
	                		 },
	                		 'studentcurrentenrollmentreportfilter multiselectcombofield[itemId=academyLocationId]': {
	                			 change :  function(combo) {
	                				 var form = combo.up('studentcurrentenrollmentreportfilter');
	                				 var programGroupCombo = form.down('#programGroup');
	                				 programGroupCombo.reset();
	                         		 var storeProgramGroup = programGroupCombo.getStore();
	                				 var academyLocationId=new Array();
	                	        	   var academyLocationId = combo.getValue();
	                	        	   var alIds = [];
	                	        	   var academyLocationIds = null;
	                	        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
	                	        		   for (var i in academyLocationId) {
	                	        			   if (Ext.isObject(academyLocationId[0])) {
	                	        				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
	                	        					   alIds.push(academyLocationId[i].get("id"));
	                	        				   }else{
	                	        					   alIds.push(academyLocationId[i]);
	                	        				   }
	                	        			   } else {
	                	        				   alIds.push(academyLocationId[i]);
	                	        			   }
	                	        		   }
	                	        		   academyLocationIds = alIds.join();
	                	        	   }else
	                	        	   {
	                	        		   academyLocationIds = academyLocationId;
	                	        	   }


	                	        	   if(academyLocationIds[0]){
	                	        		   storeProgramGroup.getProxy().extraParams = {
	                	        			   academyLocationIds : academyLocationIds
	                	        		   };
	                	        	   }else
	                	        	   {
	                	        		   storeProgramGroup.getProxy().extraParams = {
	                	        			   academyLocationIds : this.getCurrentAcademyLocation()
	                	        		   };
	                	        	   }
	                	        	   storeProgramGroup.load();
	                	        	  
	                	        	   
	                         		 var programCombo = form.down('#programCodeName');
	                         		 programCombo.reset();
	                         		 programCombo.setDisabled(true);
	                         		
	                         	 }
	                		 },
	                		 'studentcurrentenrollmentreportfilter customcombobox[itemId=programGroup]': {
	                			 select: function( combo, selectedProgramGroup, eOpts ) {
	                				 var form = combo.up('studentcurrentenrollmentreportfilter');
	                				 var academyLocationCombo = form.down('#academyLocationId');
	                				 var programCombo = form.down('#programCodeName');
	                				 programCombo.setDisabled(false);
	                				 programCombo.reset();
	                				 var storeProgram = programCombo.getStore();
	                				 var academyLocationId=new Array();
	    							 var academyLocationId = academyLocationCombo.getValue();
	    							 if(academyLocationId.length!=0){
	    								 var alIds = [];
	    								 var academyLocationIds = null;
	    								 if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
	    									 for (var i in academyLocationId) {
	    										 if (Ext.isObject(academyLocationId[0])) {
	    											 if(academyLocationId[i]!=""){
	    											 alIds.push(academyLocationId[i].get("id"));
	    											 }
	    										 } else {
	    											 alIds.push(academyLocationId[i]);
	    										 }
	    									 }
	    									 academyLocationIds = alIds.join();
	    								 }else
	    								 {
	    									 academyLocationIds = academyLocationId;
	    								 } 
	    							 }else{
	    								 academyLocationIds = $this.getCurrentAcademyLocation();
	    							 }
	    							 storeProgram.getProxy().extraParams={
	    								 programGroupId:selectedProgramGroup[0].data.id,
	    								 academyLocationIds:academyLocationIds,
	    								 isEnrollmentStatusReportScreen: true
	    							 };
	                         		 storeProgram.load();
	                         	 }
	                		 },
	                		 'studentcurrentenrollmentreportfilter button[itemId=resetBtn]': {
	                			 click: function(button){
	                				 var obj = button.up('studentcurrentenrollmentreportfilter');
	                				 obj.down('#programGroup').reset();
	                				 obj.down('#programCodeName').reset();
	                				 obj.down('#programCodeName').setDisabled(true);
	                				 var academyLocationCombo = obj.down('#academyLocationId');
	                				 var academyLocationId = this.getCurrentAcademyLocation();
	                				 var store = academyLocationCombo.getStore();
	                				 store.load({
	                 					 callback: function(records, operation, success) {
	                 						 for(var i in records){
	                 							 if(records[i].data.id == academyLocationId){
	                 								academyLocationCombo.setValue(records[i].data.id);
	                 							 }
	                 						 }
	                 					 }
	                 				 });
	                			 }
	                		 },
	                		 'studentcurrentenrollmentreportfilter button[itemId=searchBtn]': {
	                			 click:function(obj){
	                				 var form = obj.up('studentcurrentenrollmentreportfilter');
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var data = form.getValues();
	                				 var academyLocationId = data.academyLocation;
	                				 var programGroupId = data.programGroup;
	                				 var programId = data.programCodeName;
	                				 var alIds = [];
	                				 var academyLocationIds = null;
	                				 if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
	                					 for (var i in academyLocationId) {
	                						 if (Ext.isObject(academyLocationId[i])) {
	                							 if(academyLocationId[i]!=""){
	                								 alIds.push(academyLocationId[i].get("id"));
	                							 }
	                						 } else {
	                							 alIds.push(academyLocationId[i]);
	                						 }
	                					 }
	                					 academyLocationIds = alIds.join();
	                				 }else
	                				 {
	                					 academyLocationIds = academyLocationId;
	                				 }
	                				 var succeedingReportGrid = this.getStudentsucceedingenrollmentreportgrid();
	                				 var succeedingReportStore = succeedingReportGrid.getStore();
	                				 succeedingReportStore.proxy.extraParams = {
	                						 academyLocationIds : academyLocationIds,
	                						 programGroupId : programGroupId,
	                						 programId : programId,
	                				 };
	                				 succeedingReportStore.load({
	                 					 callback: function(records, operation, success) {
	                 						form.down('#searchBtn').setDisabled(false); 
	                 					 }
	                 				 });
	                				 succeedingReportGrid.config.searchFilterForm = obj.up('studentcurrentenrollmentreportfilter');
	                				 var currentReportGrid = this.getStudentcurrentenrollmentreportgrid();
	                				 var currentReportStore = currentReportGrid.getStore();
	                				 currentReportStore.proxy.extraParams = {
	                						 academyLocationIds : academyLocationIds,
	                						 programGroupId : programGroupId,
	                						 programId : programId,
	                				 };
	                				 currentReportStore.load({
	                 					 callback: function(records, operation, success) {
		                 						form.down('#searchBtn').setDisabled(false); 
		                 					 }
		                 				 });
	                				 currentReportGrid.config.searchFilterForm = obj.up('studentcurrentenrollmentreportfilter');
	                			 }
	                		 },
	                		 'studentcurrentenrollmentreporttabstructure':{
		               			   render:function(studentcurrentenrollmentreporttabstructure){
		               				   this.enableTabforStudentCurrentEnrollmentReportPanel(studentcurrentenrollmentreporttabstructure);
		               				   
		               			   },
		               			   afterrender:function(structure) {/*
			               			   var grid=structure.down('studentcurrentenrollmentreportgrid');
			               			   this.getGridHeaderFreeze(grid,structure,true);
			               		   */}
		               		   },
		               		   'studentleftreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getLEFT_STUDENTS_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentcurrentreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getCURRENT_STUDENTS_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentleavingreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getLEAVING_STUDENTS_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentrepeatreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getREPEAT_STUDENTS_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentstartingreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getSTARTING_STUDENTS_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentcurrenttotalreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getCURRENT_TOTAL_ENROLLMENT_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentconfirmedreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getCONFIRMED_STUDENTS_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		 'studentprojectedpromotionreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getPROJECTED_PROMOTIONS_REPORT_PERMISSIONS());
		               			   }
		               		    },
		               		 'studentsucceedingtotalreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getSUCCEEDING_TOTAL_ENROLLMENT_REPORT_PERMISSIONS());	
		               			   }
		               		    },
		               		'studentcurrentenrollmentreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getCURRENT_STUDENT_ENROLLMENT_REPORT_PERMISSIONS());	
		               			   },
			         			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
			         				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
			         				   if(columnName == "leftStudents"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
		             							tabPanelTitle= getCommonTranslation('LEFT_STUDENTS');
		             		        	    	tabPanelItemId= 'studentleftreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentleftreportstructure';
		             		        	    	xtypeItemId = 'studentleftreportstructureItemIdd';
		             							
		             		        	    	this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             		        	    	var selectedBatch = record.data.batchId;
		             		        	    	var gridTab = this.getStudentleftreportgrid();
		             		        	    	this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	var structure = this.getStudentleftreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
		             		        	    	
			                  			   }
			         				   }
			         				  if(columnName == "currentStudents"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
		             							
		             							tabPanelTitle= getCommonTranslation('CURRENT_STUDENTS');
		             		        	    	tabPanelItemId= 'studentcurrentreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentcurrentreportstructure';
		             		        	    	xtypeItemId = 'studentcurrentreportstructureItemIdd';
		             							
		             		        	    	this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             		        	    	var selectedBatch = record.data.batchId;
		             		        	    	var gridTab = this.getStudentcurrentreportgrid();
		             		        	    	this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentcurrentreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
			                  			   }
			         				   }
			         				 if(columnName == "leavingStudents"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
			                  				   	tabPanelTitle= getCommonTranslation('LEAVING_STUDENTS');
		             		        	    	tabPanelItemId= 'studentleavingreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentleavingreportstructure';
		             		        	    	xtypeItemId = 'studentleavingreportstructureItemIdItemIdd';
		             							
		             							this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             							var selectedBatch = record.data.batchId;
		             							var gridTab = this.getStudentleavingreportgrid();
		             		        	    	
		             							/*gridTab.getStore().sorters.add(new Ext.util.Sorter({
		             							    property : 'firstName',
		             							    direction: 'ASC'
		             							}));*/
		             							this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentleavingreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
			                  			   }
			         				   }
			         				if(columnName == "repeatStudents"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
			                  				   	tabPanelTitle= getCommonTranslation('REPEAT_STUDENTS');
		             		        	    	tabPanelItemId= 'studentrepeatreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentrepeatreportstructure';
		             		        	    	xtypeItemId = 'studentrepeatreportstructureItemIdd';
		             							
		             							this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             							var selectedBatch = record.data.batchId;
		             							var gridTab = this.getStudentrepeatreportgrid();
		             		        	    	//this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             							
		             							var structure = this.getStudentrepeatreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);

		             							var store = gridTab.getStore();
						           	       	   	store.proxy.extraParams = {
						                            programId : record.data.programId
						                        }
						           	       	   	store.load();
			                  			   }
			         				   }
			         				if(columnName == "startingStudents"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
			                  				   	tabPanelTitle= getCommonTranslation('STARTING_STUDENTS');
		             		        	    	tabPanelItemId= 'studentstartingreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentstartingreportstructure';
		             		        	    	xtypeItemId = 'studentstartingreportstructureItemIdd';
		             							
		             							this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             							var selectedBatch = record.data.batchId;
		             							var gridTab = this.getStudentstartingreportgrid();
		             		        	    	this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentstartingreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
			                  			   }
			         				   }
			         				if(columnName == "totalCurrentEnrollments"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
			                  				   	tabPanelTitle= getCommonTranslation('CURRENT_TOTAL_ENROLLMENTS');
		             		        	    	tabPanelItemId= 'studentcurrenttotalreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentcurrenttotalreportstructure';
		             		        	    	xtypeItemId = 'studentcurrenttotalreportstructureItemIdd';
		             							
		             							this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             							var selectedBatch = record.data.batchId;
		             							var gridTab = this.getStudentcurrenttotalreportgrid();
		             		        	    	this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentcurrenttotalreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
			                  			   }
			         				   }
			         			   }
			               		},
		               		 'studentsucceedingenrollmentreportgrid':{
		               			   render: function(grid){
		               				   this.doAccessControlValidation(grid, this.getSUCCEEDING_ENROLLMENT_REPORT_PERMISSIONS());
		               			   },
			         			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
			         				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
			         				   if(columnName == "confirmedStudents"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
		             							tabPanelTitle= getCommonTranslation('CONFIRMED_STUDENTS');
		             		        	    	tabPanelItemId= 'studentconfirmedreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentconfirmedreportstructure';
		             		        	    	xtypeItemId = 'studentconfirmedreportstructureItemIdd';
		             							
		             		        	    	this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             		        	    	var selectedBatch = record.data.batchId;
		             		        	    	var gridTab = this.getStudentconfirmedreportgrid();
		             		        	    	this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentconfirmedreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
			                  			   }
			         				   }
			         				  if(columnName == "projectedPromotions"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
		             							
		             							tabPanelTitle= getCommonTranslation('PROJECTED_PROMOTIONS');
		             		        	    	tabPanelItemId= 'studentprojectedpromotionreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentprojectedpromotionreportstructure';
		             		        	    	xtypeItemId = 'studentprojectedpromotionreportstructureItemIdd';
		             							
		             		        	    	this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             		        	    	var selectedBatch = record.data.batchId;
		             		        	    	var gridTab = this.getStudentprojectedpromotionreportgrid();
		             		        	    	//this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentprojectedpromotionreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
		             		        	    	
		             		        	    	var store = gridTab.getStore();
						           	       	   	store.proxy.extraParams = {
						                            programId : record.data.programId
						                        }
						           	       	   	store.load();
			                  			   }
			         				   }
			         				 if(columnName == "totalSucceedingEnrollments"){
			                  			   if(e.target.tagName=='A'){
			                  				   var studentEnrollmentReportTab = grid.up('#studentenrollmentreporttab');
			                  				   
			                  				   	tabPanelTitle= getCommonTranslation('SUCCEEDING_TOTAL_ENROLLMENTS');
		             		        	    	tabPanelItemId= 'studentsucceedingtotalreportstructureItemId';
		             		        	    	tabPanelItemXtype = 'studentsucceedingtotalreportstructure';
		             		        	    	xtypeItemId = 'studentsucceedingtotalreportstructureItemIdd';
		             							
		             							this.addSubTabForEnrollmentReport(grid,tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId);
		             							var selectedBatch = record.data.batchId;
		             							var gridTab = this.getStudentsucceedingtotalreportgrid();
		             		        	    	//this.loadEnrollmentReportDetailTabGrid(gridTab, selectedBatch);
		             		        	    	
		             		        	    	var structure = this.getStudentsucceedingtotalreportstructure();
		             		        	    	this.fillSubTabHeader(structure, record);
		             		        	    	
		             		        	    	var store = gridTab.getStore();
						           	       	   	store.proxy.extraParams = {
						                            programId : record.data.programId,
						                            batchId : record.data.batchId
						                        }
						           	       	   	store.load();
			                  			   }
			         				   }
			         			   }
			               		}
	                	 });
	                 },
	                 
	                 fillSubTabHeader: function(structure, record){
	                	 structure.down('#academyLocationItemId').setValue(record.data.academyLocationName);
	                	 structure.down('#batchItemId').setValue(record.data.batchName);
	                	 structure.down('#programGroupItemId').setValue(record.data.programGroupName);
	                	 structure.down('#programItemId').setValue(record.data.programName);
	                 },
	                 
	                 loadEnrollmentReportDetailTabGrid: function(grid, selectedBatchId){
		        	    	var store = grid.getStore();
		        	    	store.proxy.extraParams = {
                        		 batchId : selectedBatchId
                        	}
		        	    	store.load();
	                 },
	                 
	                 addSubTabForEnrollmentReport: function(grid, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId) {
	                     var me = this;
	                     
		                	var personInfoTabPanel = grid.up('#studentenrollmentreporttab');
		                 	var nTab = personInfoTabPanel.items.findBy( function(tab) {
		                 		return tab.title === getPersonModuleTranslation(tabPanelTitle);
		                 	});
		                 	
		                 	if(!nTab){
		                 		//nTab.close();
		                 		nTab = personInfoTabPanel.add({
			             			 title : tabPanelTitle,
			             			 xtype: tabPanelItemXtype,
			                         itemId : tabPanelItemId,
			                         closable : true,
			                         frame: false,
			         				 border:false,
			                     });
		                 	}
	                     	
	                     personInfoTabPanel.setActiveTab(nTab);
	                 },
	                 
	                 enableTabforStudentCurrentEnrollmentReportPanel:function(studentcurrentenrollmentreporttabstructure)
	                 {
	                	 this.showTabforCurrentEnrollmentReportPanel(studentcurrentenrollmentreporttabstructure);
	                 },
	                 
	                 showTabforCurrentEnrollmentReportPanel : function(studentcurrentenrollmentreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentcurrentenrollmentreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentcurrentenrollmentreportstructure',
					  					itemId : 'studentcurrentenrollmentreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentcurrentenrollmentreporttabstructure.insert(insertPosition,panelItem);
					     },
});
