/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.incidentsReport.StudentIncidentsReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch','feeandpayment.managebill.Student',
	         'common.picklist.AcademyTypeStore','personinfo.common.disciplinaryactivity.DisciplinaryTypeOfIncidentSearchCombo',
	         'Academia.store.attendance.SectionAndFacultyByPeriodID','Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	         'Academia.store.common.CurrentBatchStore','common.AssignedProgramStore',
	         'student.report.StudentPositiveIncidentsReportStore','admission.applicationFormSale.ProgramGroupComboStore',
	         'common.IncidentTypeStore','common.CategoryOfIncidentStore','common.IncidentRatingPositiveStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameAdmissionCodeBySmartSearch',
	         'student.report.StudentNegativeIncidentsReportStore','program.ProgramByGroupIdStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'],
	         views: ['student.incidentsReport.StudentIncidentsReportTabStructure',
	                 'student.incidentsReport.StudentIncidentsReportStructure','student.incidentsReport.StudentIncidentsReportGrid',
	                 'student.incidentsReport.StudentIncidentsReportFilter',
	                 'student.incidentsReport.StudentNegativeIncidentsReportTabStructure',
	                 'student.incidentsReport.StudentNegativeIncidentsReportStructure','student.incidentsReport.StudentNegativeIncidentsReportGrid',
	                 'student.incidentsReport.StudentNegativeIncidentsReportFilter'],
	                 config : {
	                	 
	                	// STUDENT_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INCIDENTS_REPORT_PRIVILEDGE'),
	                	 POSITIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('POSITIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 NEGATIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NEGATIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 FP_POSITIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_POSITIVE_INCIDENTS_REPORT_PRIVILEGES'),
	                	 FP_NEGATIVE_INCIDENTS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_NEGATIVE_INCIDENTS_REPORT_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentincidentsreportfilter',
	                	 selector: 'studentincidentsreportfilter'
	                 },{
	                	 ref: 'studentincidentsreportgrid',
	                	 selector: 'studentincidentsreportgrid'
	                 },{
	                	 ref: 'studentnegativeincidentsreportfilter',
	                	 selector: 'studentnegativeincidentsreportfilter'
	                 },{
	                	 ref: 'studentnegativeincidentsreportgrid',
	                	 selector: 'studentnegativeincidentsreportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		'studentincidentsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.incidentsReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 store.load();
	                				 
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 //period.reset();
	            	                	 period.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentincidentsreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 },
	                			 select: function(combo, newValue, oldValue, eOpts) {
	                				 $this = this;
	         				        var studentIncidentsReport = $this.getStudentincidentsreportfilter();
	        				       /* var userCombo = studentIncidentsReport.down('#userGroupId');
	        				        var userType = userCombo.getValue(); */
	        				       // if (!isNullOrEmpty(userType) && userType == 3) { // userType == 3(Student)
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentIncidentsReport.down('#programGroupCombo');
	        				                    
	        				                    //var programCombo = studentIncidentsReport.down('#programId');
	        				                    //programCombo.setReadOnly(true);
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentIncidentsReport.down('#programId');
	        				                    			// batchCombo.setReadOnly(true);
	        				                    			programCombo.setDisabled(false);
	        				                    			// batchCombo.allowBlank = false;
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};

	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {

	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentIncidentsReport.down('#batchId');
	        				                    						// batchCombo.setReadOnly(true);
	        				                    						batchCombo.setDisabled(false);
	        				                    						// batchCombo.allowBlank = false;
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId
	        				                    						};

	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentIncidentsReport.down('#periodId');
	        				                    									//periodCombo.setReadOnly(true);
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId,
	        				                    										isDiciplinaryOrPositiveReportScreen: true
	        				                    									};

	        				                    									periodComboStore.load({
	        				                    										callback: function(records, operation, success) {
	        				                    											periodCombo.setValue(data[0].programPeriodId);
	        				                    											var sectionCombo = studentIncidentsReport.down('#section');
	        				                    											sectionCombo.setDisabled(false);
	        				                    											var sectionComboStore = sectionCombo.getStore();
	        				                    											sectionComboStore.getProxy().extraParams = {
	        				                    												periodId: data[0].programPeriodId
	        				                    											};
	        				                    											sectionComboStore.load({
	        				                    												callback: function(records, operation, success) {
	        				                    													if (!isNullOrEmpty(data[0].sectionId)) {
	        				                    														//sectionCombo.setValue(data[0].sectionId);
	        				                    													}else {
	        				                    														sectionCombo.emptyText = [ '' ];
	        				                    														sectionCombo.applyEmptyText();
	        				                    														sectionCombo.reset();
	        				                    													}
	        				                    												}
	        				                    											});
	        				                    										}
	        				                    									});
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    }
	                		 },
	                		 'studentincidentsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.incidentsReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentincidentsreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.incidentsReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentincidentsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				var grid =this.getStudentincidentsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentincidentsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 incidentTypeId : values.incidentType,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 sectionId : values.SECTION,
	                					 categoryIncidentType : values.categoryIncidentType,
	                					 startDate : values.startDate,
	                					 endDate : values.endDate
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                                     callback: function(records, operation, success) {
	                                    	 form.down('#searchBtn').setDisabled(false);
	                                   }
	                               });
	                				 grid.config.searchFilterForm = this.getStudentincidentsreportfilter();
	                			 }
	                		 },
	                		 'studentincidentsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form  = this.getStudentincidentsreportfilter();
	                				// var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
	                				 var section = form.down('#section');
	                				 var programGroupCombo = form.down('#programGroupCombo');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
            	                	 section.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 
	                				 var startDate = form.down('#startDate');
	                				 var endDate = form.down('#endDate');
	                				 startDate.setMaxValue(new Date());
	                				 startDate.setMinValue(false);
	                				 endDate.setMaxValue(new Date());
	                				 endDate.setMinValue(false);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 programStore.load();
	                			 }
	                		 },
	                		 'studentincidentsreportfilter [itemId=incidentType]': {
	                         	beforerender : function(combo){
	                         		combo.store.proxy.extraParams = {
	                         				category: 'POSITIVE'
	                                 };
	                             }
	                         },
	                         'studentincidentsreportfilter [itemId=periodId]': {
	                        	 render: function(combo) {
			                         //var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
			                         //combo.bindStore(store);
			                     }
	                         },
	                         'studentincidentsreportgrid ': {
                  			   render: function(grid){
                  				 if (portalId == 2) {
                  					this.doAccessControlValidation(grid, this.getFP_POSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  					this.disableStdPositiveReportExportPivileges(grid, this.getFP_POSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  				 }else{
                  					this.doAccessControlValidation(grid, this.getPOSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  					this.disableStdPositiveReportExportPivileges(grid, this.getPOSITIVE_INCIDENTS_REPORT_PERMISSIONS());
                  				 }
                  			   },
                	         	selectionchange: function(column, selected,grid ){
                 	         		var grid = this.getStudentincidentsreportgrid();
                                	this.disableGridExportButton(column,selected,grid);                	
                                }
                  		   	 },
	                		 'studentnegativeincidentsreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 },
	                			 select: function(combo, newValue, oldValue, eOpts) {
	                				 $this = this;
	         				        var studentNegativeIncidentsReport = $this.getStudentnegativeincidentsreportfilter();
	        				       /* var userCombo = studentIncidentsReport.down('#userGroupId');
	        				        var userType = userCombo.getValue(); */
	        				       // if (!isNullOrEmpty(userType) && userType == 3) { // userType == 3(Student)
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentNegativeIncidentsReport.down('#programGroupCombo');
	        				                    
	        				                    //var programCombo = studentIncidentsReport.down('#programId');
	        				                    //programCombo.setReadOnly(true);
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentNegativeIncidentsReport.down('#programId');
	        				                    			// batchCombo.setReadOnly(true);
	        				                    			programCombo.setDisabled(false);
	        				                    			// batchCombo.allowBlank = false;
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};

	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {

	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentNegativeIncidentsReport.down('#batchId');
	        				                    						// batchCombo.setReadOnly(true);
	        				                    						batchCombo.setDisabled(false);
	        				                    						// batchCombo.allowBlank = false;
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId
	        				                    						};

	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentNegativeIncidentsReport.down('#periodId');
	        				                    									//periodCombo.setReadOnly(true);
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId,
	        				                    										isDiciplinaryOrPositiveReportScreen: true
	        				                    									};

	        				                    									periodComboStore.load({
	        				                    										callback: function(records, operation, success) {
	        				                    											periodCombo.setValue(data[0].programPeriodId);
	        				                    											var sectionCombo = studentNegativeIncidentsReport.down('#section');
	        				                    											sectionCombo.setDisabled(false);
	        				                    											var sectionComboStore = sectionCombo.getStore();
	        				                    											sectionComboStore.getProxy().extraParams = {
	        				                    												periodId: data[0].programPeriodId
	        				                    											};
	        				                    											sectionComboStore.load({
	        				                    												callback: function(records, operation, success) {
	        				                    													if (!isNullOrEmpty(data[0].sectionId)) {
	        				                    														//sectionCombo.setValue(data[0].sectionId);
	        				                    													}else {
	        				                    														sectionCombo.emptyText = [ '' ];
	        				                    														sectionCombo.applyEmptyText();
	        				                    														sectionCombo.reset();
	        				                    													}
	        				                    												}
	        				                    											});
	        				                    										}
	        				                    									});
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    }
	                		 },
                  		   	 'studentnegativeincidentsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.negativeIncidentsReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 store.load();
	                				 
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 //period.reset();
	            	                	 period.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.negativeIncidentsReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.negativeIncidentsReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentnegativeincidentsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentnegativeincidentsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 incidentTypeId : values.incidentType,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 sectionId : values.SECTION,
	                					 startDate : values.startDate,
	                					 endDate : values.endDate
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                                     callback: function(records, operation, success) {
	                                    	 form.down('#searchBtn').setDisabled(false);
	                                   }
	                               });
	                				 grid.config.searchFilterForm = this.getStudentnegativeincidentsreportfilter();
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = this.getStudentnegativeincidentsreportfilter();
	                				 //var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
	                				 var section = form.down('#section');
	                				 var programGroupCombo = form.down('#programGroupCombo');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
            	                	 section.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 
	                				 var startDate = form.down('#startDate');
	                				 var endDate = form.down('#endDate');
	                				 startDate.setMaxValue(new Date());
	                				 startDate.setMinValue(false);
	                				 endDate.setMaxValue(new Date());
	                				 endDate.setMinValue(false);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId,
	                					 isAllProgram:true
	                				 };
	                				 programStore.load();
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportfilter [itemId=incidentType]': {
	                			 beforerender : function(combo){
	                				 combo.store.proxy.extraParams = {
	                						 category: 'NEGATIVE'
	                				 };
	                			 }
	                		 },
	                		 'studentnegativeincidentsreportgrid ': {
	                			 cellclick: function( cell, td, cellIndex) {
	                			       var studentDetailGrid = cell.up('grid');
	                			       var columnName = studentDetailGrid.columnManager.columns[cellIndex].dataIndex;
	                			       if(columnName == 'studentCode') {
	                			            var record = studentDetailGrid.getSelectionModel().getSelection()[0];
	                			            var userId = record.get('studentId');
	                			            var admissionId = record.get('admissionId');
	                			            var personId = record.get('personId');
	                			            var studentCode = record.get('studentCode');
	                			            var programBatchSeatTypeConfigId = record.get('programBatchSeatTypeConfigId');
	                			             if(!isNullOrEmpty(userId)) {
	                			                     var tabTitle = studentCode;
	                			                     var personId = personId;
	                			                     var admissionId=admissionId;	                			                     
	                			                     var programBatchSeatTypeConfigId = programBatchSeatTypeConfigId;
	                			                     Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
	                			                     var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	                			                     var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
	                			                     personController.isProfilePicSaved = false;
	                			                     personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
	                			                     if(Ext.isDefined(studentDetailGrid.up('window'))){
	                			                            studentDetailGrid.up('window').close();
	                			                         }
	                			                 }
	                			        }
	                			},
	                			 render: function(grid){
	                				 if (portalId == 2) {
	                					 this.doAccessControlValidation(grid, this.getFP_NEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	                   				 }else{
	                   					this.doAccessControlValidation(grid, this.getNEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	                   				 }
	                			 },
	                			 afterrender:function(grid){
	               				  var me = this;
	               				  me.addDataGridConfigButton(grid,me.getNEGATIVE_INCIDENTS_REPORT_PERMISSIONS());
	   			    		},
	                	},
	                		  'studentincidentsreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.incidentsReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  'studentnegativeincidentsreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.incidentsNegativeReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  
	                		  'studentincidentsreporttabstructure':{
		               			   render:function(studentincidentsreporttabstructure){
		               				   this.enableTabforstudentincidentReportPanel(studentincidentsreporttabstructure);
		               			   },
		               		   afterrender:function(structure)
		               		   {
		               			   var grid=structure.down('studentincidentsreportgrid');
		               			   this.getGridHeaderFreeze(grid,structure,true);
		               		   }
	                		  },
	                		  'studentincidentsreportgrid button[itemId=exportReportsId]': {
	                			  click: function(obj) {
	                				  this.exportJRXMLPosotiveIncidentReport();
	                			  }
	                		  }
	                	 });
	                 },
	                 
	                 
	                 enableTabforstudentincidentReportPanel:function(studentincidentsreporttabstructure)
	                 {
	                	 this.showTabforstudentincidentReportPanel(studentincidentsreporttabstructure);
	                 },
	                 
	                 showTabforstudentincidentReportPanel : function(studentincidentsreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentincidentsreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',marginLeft:'0px !important'},
					  			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentincidentsreportstructure',
					  					itemId : 'studentincidentsreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentincidentsreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 
	                 
	                 
	                 incidentsReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 incidentsReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var batchId = record[0].get("id");
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
        				 var wheatherSchool = alinfomodel.get('wheatherSchool');
        				 
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 period.bindStore(store);
	                		 store.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length > 0){
										   if(wheatherSchool){
											   period.setValue(records[0].data.id);
											   var form = obj.up('form');
						                	   var section = form.down('#section');
						                	   section.reset();
						                	   section.setDisabled(false);
						                	   var periodId = records[0].data.id;
							                	 if(periodId > 0){	    	        					  
							                		 var store = section.getStore();
							                		 store.getProxy().extraParams = {
							                			 periodId: periodId
							                		 };
							                		 store.load();
							                	 }
										   }
									   }
								   }
							   }
						    });
	                		 
	                	 }
	                 },
	                 incidentsReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 negativeIncidentsReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(true);
	                	 
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 negativeIncidentsReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(true);
	                	 
	                	 var batchId = record[0].get("id");
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');

	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 period.bindStore(store);
	                		 store.load({
	                			 callback: function(records, operation, success) {
	                				 if (success) {
	                					 if(records.length > 0){
	                						 if(wheatherSchool){
	                							 period.setValue(records[0].data.id);
	                							 var form = obj.up('form');
	                							 var section = form.down('#section');
	                							 section.reset();
	                							 section.setDisabled(false);
	                							 var periodId = records[0].data.id;
	                							 if(periodId > 0){	    	        					  
	                								 var store = section.getStore();
	                								 store.getProxy().extraParams = {
	                									 periodId: periodId
	                								 };
	                								 store.load();
	                							 }
	                						 }
	                					 }
	                				 }
	                			 }
	                		 });

	                	 }
	                 },
	                 negativeIncidentsReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#section');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 incidentsReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 var section = form.down('#section');
	                	 program.reset();
	                	 batch.reset();
	                	 period.reset();
	                	 section.reset();
	                	 batch.setDisabled(true);
	                	 period.setDisabled(true);
	                	 section.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationIds: academyLocationId,
	                			 isAllProgram:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 incidentsNegativeReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 var section = form.down('#section');
	                	 program.reset();
	                	 batch.reset();
	                	 period.reset();
	                	 section.reset();
	                	 batch.setDisabled(true);
	                	 period.setDisabled(true);
	                	 section.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationIds: academyLocationId,
	                			 isAllProgram:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 //V2D-54139: Export Report Button Permission
		              disableStdPositiveReportExportPivileges : function(gridReference, permissionsMap) {
		            		var associatedAcadLocationIds = new Array();
		            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		            		var permissionList = Academia.utilities.accessControl.AccessControlManager
		            		.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		            		buttonsToolBar = gridReference.query('toolbar')[0];
		            		var exportReport = buttonsToolBar.query('#exportReportsId')[0];
		            		Ext.each(permissionList, function(privilege) {
		            			if (privilege === 'EXPORTREPORTS') {
		            				if(!isNullOrEmpty(exportReport)){
		            					exportReport.setVisible(true);
		            				}        		
		            			}
		            		});
		            	},
                       	disableGridExportButton:function(column,selected,grid) {
                        	var exportButtonItemId = grid.down('#exportReportsId');
                        	var counter = 0;
                        	var count=selected.length;
                        	if(count>= 1){ // enable
                        		exportButtonItemId.setDisabled(false);
                        	}else{
                        		exportButtonItemId.setDisabled(true);
                        	}
                        },
                        exportJRXMLPosotiveIncidentReport: function() {
                        	var selectedId = 0;
                        	grid = this.getStudentincidentsreportgrid();
                        	if (grid.getSelectionModel().getCount() > 0) {
                        		var record = grid.getSelectionModel().getSelection();
                        		var studenttemp=[];
                        		for(var i in record){
                        			studenttemp.push(record[i].get("incidentId"));
                        		}
                        		selectedId=studenttemp.join();
                        		user=this.getCurrentlyLoggedInUser();
                        		// code to identify jasper
                        		var code ="POSITIVE_INCIDENT_PRINT_REPORT";
                        		var reportParams =new Object();
                        		reportParams.userId=user.code;
                        		reportParams.incidentIdsCommaSeperated = String(selectedId); // convert int into string
                        		var reportTitle=getCommonTranslation('STUDENT_POSITIVE_INCIDENT_REPORT_TITLE');
                        		var exportUrl = SERVERURL.POSITIVE_INCIDENT_PRINT;
                        		this.exportJRXMLReport(code,reportParams,reportTitle,'.zip',exportUrl);
                        		//$this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);
                        	}else{
                        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
                        	}
                        },               
});
