/**
 * @author Vishal Joshi
 */
Ext.define('Academia.controller.student.report.StudentFeePayerReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['student.report.StudentFeePayerReportGridStore','program.ProgramCategoryStore','program.ProgramGroupStore','program.ProgramCodeOrNameSmartSearch',
		'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch', 'feeandpayment.managebill.Student',
		'Academia.store.feeandpayment.reports.Program', 'Academia.store.common.ProgramByAcAndLoIdStore','Academia.store.completion.completionform.SectionByBatch',
		'Academia.store.common.AssignedProgramGroupStore','student.report.StudentFeesRegistrationReportGridStore','Academia.store.common.ProgramForBillStoreFeePayment',
		'Academia.store.student.report.ReRegistrationStatusStore',
		'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore'
		],
	views : ['student.studentFeePayerReport.StudentFeePayerReportFilter','student.studentFeePayerReport.StudentFeePayerReportStructure',
	         'student.studentFeePayerReport.StudentFeePayerReportGrid','student.studentFeePayerReport.StudentFeePayerReportTabStructure',
	         'student.studentFeePayerReport.StudentFeesRegistrationReportStructure','student.studentFeePayerReport.StudentFeesRegistrationReportTabStructure',
	         'student.studentFeePayerReport.StudentFeeRegistrationReport','student.studentFeePayerReport.StudentFeesRegistrationReportGrid',
	         'student.studentFeePayerReport.StudentFeesRegistrationReportSendMessages','messaging.StudentFeesRegistrationReportStaticDocumentAttachmentGrid',
	         'student.studentFeePayerReport.StudentStartRegistrationWin'
	         ],
	refs : [
	        {
	        	ref : 'studentfeepayerreportstructure',
	        	selector : 'studentfeepayerreportstructure'
	        },{
	        	ref : 'studentfeepayerreportfilter',
	        	selector : 'studentfeepayerreportfilter'
	        },{
	        	ref: 'studentfeepayerreportgrid',
	        	selector: 'studentfeepayerreportgrid'
	        },{
	        	ref: 'studenttransferreporttabstructure',
	        	selector: 'studenttransferreporttabstructure'
	        },{
	        	ref: 'contentPanel',
	        	selector: 'contentPanel'
	        },{
	        	ref : 'studentfeesregistrationreporttabstructure',
	        	selector : 'studentfeesregistrationreporttabstructure'
	        },{
	        	ref : 'studentfeesregistrationreportstructure',
	        	selector : 'studentfeesregistrationreportstructure'
	        },{
	        	ref : 'studentfeeregistrationreport',
	        	selector : 'studentfeeregistrationreport'
	        },{
	        	ref : 'studentfeesregistrationreportgrid',
	        	selector : 'studentfeesregistrationreportgrid'
	        },{
	        	ref : 'studentfeesregistrationreportsendmessages',
	        	selector : 'studentfeesregistrationreportsendmessages'
	        },{
	        	ref : 'studentfeesregistrationreportstaticdocumentattachmentgrid',
	        	selector : 'studentfeesregistrationreportstaticdocumentattachmentgrid'
	        },{
	        	ref:'studentstartregistrationwin',
	        	selector:'studentstartregistrationwin'
	        }],

	        config: {
	        	STUDENT_FEESREGISTRATIONREPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEESREGISTRATIONREPORT_PRIVILEGES'),
	        	STUDENT_FEEPAYER_REPORT_PERMISSIONS :  Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEE_PAYER_REPORT_PRIVILEGES')
	        },
	        
	        init : function() {
	        	this.control({
	        		'studentfeepayerreportfilter multiselectcombofield[itemId=multiselectAcademyId]':{
	        			afterrender:function(obj, record){
	        				var $this = this;
	        				var academyLocationId = this.getCurrentAcademyLocation();
	        				obj.getStore().load({
	        					callback: function(record){
	        						obj.select(academyLocationId);
	        					}
	        				});
	        			},
	        			change: function(obj){
	        				var academyIds = this.getSelectedAcademyIds();
	        				if (academyIds != null && academyIds != '') {
	        					this.loadProgramAdmissonAndStudentDetailsOnTheBasisOfAL();
							}
	        			}

	        		},
	        		'studentfeepayerreportfilter customcombobox[itemId=programGroupId]': {
	        			select: function(programGroupCombo, records, eOpts) {
	        				var academyIds = this.getSelectedAcademyIds();
	        				var basicStudentFeePayerSearchForm=this.getStudentfeepayerreportfilter();
	        				var programCombo = basicStudentFeePayerSearchForm.down('#program');
	        				var programStore = programCombo.getStore();
	        				programStore.getProxy().extraParams = {
	        					programGroupId : programGroupCombo.getValue(),
	        					academyLocationIds:academyIds
	        				};
	        				programStore.load();
	        				var batch = basicStudentFeePayerSearchForm.down('#batch');
	        				var section = basicStudentFeePayerSearchForm.down('#section');
	        				this.clearCombo(batch, true);
	        				this.clearCombo(section, true);
	        			}

	        		},
	        		'studentfeepayerreportfilter customcombobox[itemId=program]': {
	        			afterrender : function(combo){
	        				var academyIds = this.getSelectedAcademyIds();
	        				var store = combo.getStore();
	        				store.getProxy().extraParams = {
	        					academyLocationIds:academyIds
	        				};
	        				store.load();
	        			},
	        			select: function(programCombo, records, eOpts) {
	        				var this$ = this;
	        				var basicStudentSearchForm=this.getStudentfeepayerreportfilter();
	        				var batchCombo = basicStudentSearchForm.down('#batch');
	        				this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
	        			}

	        		},
	        		'studentfeepayerreportfilter customcombobox[itemId=batch]': {
	        			afterrender : function(combo){
	        				var academyLocationId = this.getCurrentAcademyLocation();
	        				var store = combo.getStore();
	        				console.log("store : "+store);
	        				store.load();
	        			},
	        			select: function(batchCombo, records, eOpts) {
	        				var this$ = this;
	        				var basicStudentSearchForm=this.getStudentfeepayerreportfilter();
	        				var sectionCombo = basicStudentSearchForm.down('#section');
	        				this$.loadDependentCombo(sectionCombo, batchCombo.getValue(), 'batchIds');
	        			}
	        		},
	        		'studentfeepayerreportfilter button[itemId=btnSearch]': {
	        			click: this.loadStudentFeePayerReportGrid
	        		},
	        		'studentfeepayerreportfilter button[itemId=btnReset]': {
	        			click: this.resetStudentFeePayerReportFilter
	        		},
	        		
	 /* From Here Code Start for Fees Registration Report */
	        		'studentfeeregistrationreport multiselectcombofield[itemId=multiselectAcademyId]':{
	        			afterrender:function(obj, record){
	        				var $this = this;
	        				var academyLocationId = this.getCurrentAcademyLocation();
	        				obj.getStore().load({
	        					callback: function(record){
	        						obj.select(academyLocationId);
	        					}
	        				});
	        				var studentFeesRegistrationGrid=$this.getStudentfeesregistrationreportgrid();
	        				var exportButton= studentFeesRegistrationGrid.down('#exportReportItemId');
	        				exportButton.setDisabled(true);
	        				
	        			},
	        				change: function(obj){
	        				var studentfeeregistrationreport=$this.getStudentfeeregistrationreport();
		        			var intakeYear= studentfeeregistrationreport.down('#intakeYear');
	        				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				if (academyIds != null && academyIds != '') {
	        					this.loadProgramAdmissonAndStudentDetailsOnTheBasisOfALforFeesRegistration();
							}
	        				if (academyIds == null || academyIds == '') {
	        					var studentFeesRegistrationGrid=$this.getStudentfeesregistrationreportgrid();
		        				var exportButton= studentFeesRegistrationGrid.down('#exportReportItemId');
		        				exportButton.setDisabled(true);
	        				}
	        				if(academyIds != null && academyIds != '' &&  intakeYear.getValue()!=null){
	        					var studentFeesRegistrationGrid=$this.getStudentfeesregistrationreportgrid();
		        				var exportButton= studentFeesRegistrationGrid.down('#exportReportItemId');
		        				exportButton.setDisabled(false);
	        				}
	        			}
	        		},
	        		'studentfeeregistrationreport customcombobox[itemId=programGroupId]': {
	        			select: function(programGroupCombo, records, eOpts) {
	        				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				var basicStudentFeePayerSearchForm=this.getStudentfeeregistrationreport();
	        				var filter = $this.getStudentfeeregistrationreport().getForm();
	        	        	var formValue = filter.getValues();

	        				var programCombo = basicStudentFeePayerSearchForm.down('#program');
	        				var programStore = programCombo.getStore();
	        				programStore.getProxy().extraParams = {
	        					programGroupId : programGroupCombo.getValue(),
	        					programCategoryId : formValue.programCategory,
	        					academyLocationIds:academyIds
	        				};
	        				programStore.load();
	        				var batch = basicStudentFeePayerSearchForm.down('#batch');
	        				this.clearCombo(batch, true);
	        				
/*  Code For Reloading Students */
	        				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
	        				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
	        				var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();
	        				var programsCategoryId = [];
	        	        	for(var i in programCategory){
	        	        		if(Ext.isObject(programCategory[i])){
	        	        			programsCategoryId.push(programCategory[i].data.id);
	        	        		}else{
	        	        			programsCategoryId.push(programCategory[i]);
	        	        		}
	        	        	}
	        	        	var programCategoryIds = programsCategoryId.join();
	        				var studentIdNameStore = studentIdNameCombo.getStore();
	        				       				var filter = $this.getStudentfeeregistrationreport().getForm();
	        				    	        	var formValue = filter.getValues();
	        				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				    				if (academyIds != null && academyIds != '') {
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					academyLocationIds: academyIds/*,
	        				    		        		intakeYear : formValue.intakeYear,
	        				    		        		programCategoryId : formValue.programCategory,
	        				    		        		programCategoryId : programCategoryIds,
	        				    		        		programGroupId : formValue.programGroupId,
	        				    		        		programId : formValue.program, 
	        				    		        		batchId : formValue.batch,*/
	        				          				 };
	        				    					studentIdNameStore.load();						
	        				    				}
	        				    				else{
	        				    					var academyLocationId=this.getCurrentAcademyLocation();
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					 academyLocationIds: academyLocationId
	        				          				 };
	        				    					studentIdNameStore.load();
	        				    				}
	        			
	        			}

	        		},
	        		'studentfeeregistrationreport multiselectcombofield[itemId=programCategory]': {
	        			select: function(programCategoryCombo, records, eOpts) {
	        				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				var basicStudentFeePayerSearchForm=this.getStudentfeeregistrationreport();
	        				var filter = $this.getStudentfeeregistrationreport().getForm();
	        	        	var formValue = filter.getValues();
	        	        	var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();
	        				var programsCategoryId = [];
	        	        	for(var i in programCategory){
	        	        		if(Ext.isObject(programCategory[i])){
	        	        			programsCategoryId.push(programCategory[i].data.id);
	        	        		}else{
	        	        			programsCategoryId.push(programCategory[i]);
	        	        		}
	        	        	}
	        	        	var programCategoryIds = programsCategoryId.join();


	        				var programCombo = basicStudentFeePayerSearchForm.down('#program');
	        				var programStore = programCombo.getStore();
	        				programStore.getProxy().extraParams = {
	        					programGroupId : formValue.programGroupId,
	        					programCategoryIds : programCategoryIds,
	        					academyLocationIds:academyIds
	        				};
	        				programStore.load();
	        				var batch = basicStudentFeePayerSearchForm.down('#batch');
	        				this.clearCombo(batch, true);
	        				
/*  Code For Reloading Students */
	        				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
	        				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
	        				var studentIdNameStore = studentIdNameCombo.getStore();
	        				       				var filter = $this.getStudentfeeregistrationreport().getForm();
	        				    	        	var formValue = filter.getValues();
	        				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				    				if (academyIds != null && academyIds != '') {
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					academyLocationIds: academyIds/*,
	        				    		        		intakeYear : formValue.intakeYear,
	        				    		        		programCategoryId : formValue.programCategory,
	        				    		        		programCategoryId : programCategoryIds,
	        				    		        		programGroupId : formValue.programGroupId,
	        				    		        		programId : formValue.program, 
	        				    		        		batchId : formValue.batch,*/
	        				          				 };
	        				    					studentIdNameStore.load();						
	        				    				}
	        				    				else{
	        				    					var academyLocationId=this.getCurrentAcademyLocation();
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					 academyLocationIds: academyLocationId
	        				          				 };
	        				    					studentIdNameStore.load();
	        				    				}
	        			
	        			}

	        		},
	        		
	        		'studentfeeregistrationreport customcombobox[itemId=program]': {
	        			afterrender : function(combo){
	        				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				var store = combo.getStore();
	        				store.getProxy().extraParams = {
	        					academyLocationIds:academyIds
	        				};
	        			},
	        			select: function(programCombo, records, eOpts) {
	        				var this$ = this;
	        				var stuFeeRegistrationReport=this.getStudentfeeregistrationreport();
	        				var batchCombo = stuFeeRegistrationReport.down('#batch');
	        				this$.loadDependentComboForFeesRegitration(batchCombo, programCombo.getValue(), 'id');

/*  Code For Reloading Students */	        				
	        				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
	        				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
	        				var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();
	        				var programsCategoryId = [];
	        	        	for(var i in programCategory){
	        	        		if(Ext.isObject(programCategory[i])){
	        	        			programsCategoryId.push(programCategory[i].data.id);
	        	        		}else{
	        	        			programsCategoryId.push(programCategory[i]);
	        	        		}
	        	        	}
	        	        	var programCategoryIds = programsCategoryId.join();
	        				var studentIdNameStore = studentIdNameCombo.getStore();
	        				       				var filter = $this.getStudentfeeregistrationreport().getForm();
	        				    	        	var formValue = filter.getValues();
	        				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				    				if (academyIds != null && academyIds != '') {
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					academyLocationIds: academyIds/*,
	        				    		        		intakeYear : formValue.intakeYear,
	        				    		        		programCategoryId : formValue.programCategory,
	        				    		        		programCategoryId : programCategoryIds,
	        				    		        		programGroupId : formValue.programGroupId,
	        				    		        		programId : formValue.program, 
	        				    		        		batchId : formValue.batch,*/
	        				          				 };
	        				    					studentIdNameStore.load();						
	        				    				}
	        				    				else{
	        				    					var academyLocationId=this.getCurrentAcademyLocation();
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					 academyLocationIds: academyLocationId
	        				          				 };
	        				    					studentIdNameStore.load();
	        				    				}
	        			
	        			}

	        		},
	        		'studentfeeregistrationreport customcombobox[itemId=intakeYear]': {
	        			select: function(programCombo, records, eOpts) {
/*  Code For Reloading Students */
	        				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
	        				var studentFeesRegistrationGrid=$this.getStudentfeesregistrationreportgrid();
	        				var exportButton= studentFeesRegistrationGrid.down('#exportReportItemId');
	        				exportButton.setDisabled(false);
	        				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
	        				var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();
	        				var programsCategoryId = [];
	        	        	for(var i in programCategory){
	        	        		if(Ext.isObject(programCategory[i])){
	        	        			programsCategoryId.push(programCategory[i].data.id);
	        	        		}else{
	        	        			programsCategoryId.push(programCategory[i]);
	        	        		}
	        	        	}
	        	        	var programCategoryIds = programsCategoryId.join();
	        				var studentIdNameStore = studentIdNameCombo.getStore();
	        				       				var filter = $this.getStudentfeeregistrationreport().getForm();
	        				    	        	var formValue = filter.getValues();
	        				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				    				if (academyIds != null && academyIds != '') {
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					academyLocationIds: academyIds/*,
	        				    		        		intakeYear : formValue.intakeYear,
	        				    		        		programCategoryId : formValue.programCategory, 
	        				    		        		programCategoryId : programCategoryIds, 
	        				    		        		programGroupId : formValue.programGroupId,
	        				    		        		programId : formValue.program, 
	        				    		        		batchId : formValue.batch,*/
	        				          				 };
	        				    											
	        				    				}
	        				    				else{
	        				    					var academyLocationId=this.getCurrentAcademyLocation();
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					 academyLocationIds: academyLocationId
	        				          				 };
	        				    					
	        				    				}
	        			}

	        		},
	        		'studentfeeregistrationreport customcombobox[itemId=batch]': {
	        	
	        			select: function(batchCombo, records, eOpts) {
	        				var this$ = this;
/*  Code For Reloading Students */
	        				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
	        				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
	        				var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();
	        				var programsCategoryId = [];
	        	        	for(var i in programCategory){
	        	        		if(Ext.isObject(programCategory[i])){
	        	        			programsCategoryId.push(programCategory[i].data.id);
	        	        		}else{
	        	        			programsCategoryId.push(programCategory[i]);
	        	        		}
	        	        	}
	        	        	var programCategoryIds = programsCategoryId.join();
	        				var studentIdNameStore = studentIdNameCombo.getStore();
	        				       				var filter = $this.getStudentfeeregistrationreport().getForm();
	        				    	        	var formValue = filter.getValues();
	        				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
	        				    				if (academyIds != null && academyIds != '') {
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					academyLocationIds: academyIds/*,
	        				    		        		intakeYear : formValue.intakeYear,
	        				    		        		programCategoryId : formValue.programCategory, 
	        				    		        		programCategoryId : programCategoryIds,
	        				    		        		programGroupId : formValue.programGroupId,
	        				    		        		programId : formValue.program, 
	        				    		        		batchId : formValue.batch,*/
	        				          				 };
	        				    					studentIdNameStore.load();						
	        				    				}
	        				    				else{
	        				    					var academyLocationId=this.getCurrentAcademyLocation();
	        				    					studentIdNameStore.getProxy().extraParams = {
	        				          					 academyLocationIds: academyLocationId
	        				          				 };
	        				    					studentIdNameStore.load();
	        				    				}
	        			
//	        				var basicStudentSearchForm=this.getStudentfeepayerreportfilter();
//	        				var sectionCombo = basicStudentSearchForm.down('#section');
//	        				this$.loadDependentCombo(sectionCombo, batchCombo.getValue(), 'batchIds');
	        			}
	        		},
	        		'studentfeeregistrationreport customcombobox[itemId=studentIdName]': {
	        		/*	render : function(obj) {
           				 var store = obj.getStore();
           				 var academyLocationId=this.getCurrentAcademyLocation();
           				 store.getProxy().extraParams = {
           					 academyLocationIds: academyLocationId
           				 };
           				 store.load();
           			 },*/
           			/*change: function(obj){
           				var store = obj.getStore();
           				var filter = $this.getStudentfeeregistrationreport().getForm();
        	        	var formValue = filter.getValues();
        				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
        				if (academyIds != null && academyIds != '') {
        					store.getProxy().extraParams = {
              					academyLocationIds: academyIds,
        		        		intakeYear : formValue.intakeYear,
        		        		programCategoryId : formValue.programCategory, 
        		        		programGroupId : formValue.programGroupId,
        		        		programId : formValue.program, 
        		        		batchId : formValue.batch,
              				 };
              				 store.load();						
        				}
        				else{
        					var academyLocationId=this.getCurrentAcademyLocation();
              				 store.getProxy().extraParams = {
              					 academyLocationIds: academyLocationId
              				 };
              				 store.load();
        				}
        			}*/
	        		},
	        		'studentfeeregistrationreport button[itemId=btnSearch]': {
	        			click: this.loadStudentFeeRegistrationReportGrid
	        		},
	        		'studentfeeregistrationreport button[itemId=btnReset]': {
	        			click: this.resetStudentFeesRegistrationReport
	        		},
	        		'studentfeesregistrationreportgrid': {
	       			 render: function(grid){
	       				 
	       				 this.doAccessControlValidation(grid, this.getSTUDENT_FEESREGISTRATIONREPORT_PERMISSIONS());
//	       				 this.disableMoreActionPivileges(grid,this.getSTUDENT_FEESREGISTRATIONREPORT_PERMISSIONS());
	       				this.doAccessControlValidationOfSendMsgBtn(grid, this.getSTUDENT_FEESREGISTRATIONREPORT_PERMISSIONS());
	       				var buttonsToolBar = grid.query('toolbar')[0];
	    		    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	   		    	   var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
	    		    	pdftoolbar.setDisabled(true);
	    		    	exceltoolbar.setDisabled(true);
	       			 },
	       			 selectionchange: function(column, selected,eOpts ){
	       				 var grid = this.getStudentfeesregistrationreportgrid();
	       				 var records = grid.getSelectionModel().getSelection();
	       				 var enableBtn=true;
	       				 Ext.each(records,function(data){
                              if(data.data.registrationStatus!='Pending'){
                            	  enableBtn=false;
                              }
	       				 });
	       				 grid.down('#startRegistrationBtn').setDisabled(!enableBtn);
	       			 }
	        		},
	        		'studentfeesregistrationreportgrid button[itemId=startRegistrationBtn]': {
	        			click:function(obj){
	        				this.doStartRegistrationProcess();
	        			}
	        		},
	        		'studentfeesregistrationreportgrid button[itemId=exportReportItemId]': {
	        			click:function(obj){
	        				this.exportStudentFeeRegistrationReportXLFunction();
	        			}
	        		},
	        		'studentfeesregistrationreportgrid button[itemId=sendMessageBtn]':{
		            	 click:function(){
								this.openStudentFeesRegistrationReportSendMessage();
							}
		             },
	        		'studentfeesregistrationreportstaticdocumentattachmentgrid[itemId=studentFeesRegistrationReportStaticDocumentAttachmentGridMessage] actioncolumn': {
		            	click : function(view, rowIndex, colIndex, item, e, record, row){
		            		this.deleteStudentFeesRegistrationReportStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
		            	}
		            },
		            
		            'studentfeesregistrationreportsendmessages textarea[itemId=feeRegSmsDiscription]':{
            			change : function(val,nV,oV){
            				var studentsendmessage = this.getStudentfeesregistrationreportsendmessages();
            				var smsTextField = studentsendmessage.down('#feeRegSmsDiscription');
            				var smsTextFieldDiscription = studentsendmessage.down('#feeRegSmsDiscriptionNotice');
            				var maxLength = localStorage.getItem('maxLength');
            				var newValue = maxLength - smsTextField.getValue().length;
            				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
            			}
            		},
            		
            		'studentfeesregistrationreportsendmessages textarea[itemId=feeRegPushNotificationDiscription]':{
          	        	change : function(val,nV,oV){
          	        		var studentSendMessages = this.getStudentfeesregistrationreportsendmessages();
          	        		var pushTextField = studentSendMessages.down('#feeRegPushNotificationDiscription');
          	        		var pushTextFieldDiscription = studentSendMessages.down('#feeRegPushNotificationDiscriptionNotice');
          	        		var maxLength = 1000;
          	        		var newValue = maxLength - pushTextField.getValue().length;
          	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
          	        	}
          	        },
          	        
          	      'studentfeesregistrationreportsendmessages radiogroup[itemId=feeRegMessageType]':{
            			change : function(val,nV,oV){
            				this.selectSectionMessageType(val,nV,oV);
            			}
            		},
		            
            		 'studentfeesregistrationreportsendmessages': {
							render: function(grid){
								var this$ = this;
								var docGrid = grid.down('#studentFeesRegistrationReportStaticDocumentAttachmentGridMessage');
								docGrid.getStore().removeAll();
								docGrid.getStore().sync();
							}
						},
		             'studentfeesregistrationreportsendmessages customcombobox[itemId=feeRegMsgTempletId]':{
							select : function(obj,rec){
								this.selectMessageTempForStudentFeesRegistrationReport(obj,rec);
							}
					}
					,'studentfeesregistrationreportsendmessages  filefield[itemId=feeRegStaticUploadFileField]': {
							change: function(fileField, value, eOpts){
								var this$ = this;
								//value = value.replace('C:\\fakepath\\', '');
								var form=this$.getStudentfeesregistrationreportsendmessages();
								var feeRegSubject = form.down('#feeRegSubject').getValue();
								if(isNullOrEmpty(feeRegSubject)){
									form.down('#feeRegSubject').setValue(' ');
								}
								this$.uploadFeeRegStaticDocumentFileMessage(fileField, value, eOpts);
							}
					},
					'studentfeesregistrationreportsendmessages radiogroup#feeRegSendingPriority': {
						change: function( radio, newValue, oldValue, eOpts) {
							this.loadFeeRegReportScheduleField(radio, newValue, oldValue);
						}
		            },
		            
		            'studentfeesregistrationreportsendmessages button[itemId=feeRegAdhocMsgSubmitBtn]':{
            			click: function(obj) {
            				var isForAll = false;
//            				var SearchForm = this.getStudentQuickSearchForm();
//            		        var jsonFormatFormData = this.createJsonFormat(SearchForm);
            				var grid = this.getStudentfeesregistrationreportgrid();
            				var studentsendmessage = this.getStudentfeesregistrationreportsendmessages();
//            				studentsendmessage.down('#feeRegAdhocMsgSubmitBtn').setDisabled(true);
        	    	       	var sendMessageLable = studentsendmessage.down("#feeRegSendMsgCountItemId");
        	    	       	if (sendMessageLable.isVisible()) {
        	    	       		isForAll = true;
							}
            				var formPnl = obj.up('form');
            				var isMySelfChecked = false;
            				var fldValues = formPnl.getForm().getFieldValues();
            				isMySelfChecked = fldValues.feeRegRecieverType;
            				if(fldValues.feeRegRecieverType[0] == false && fldValues.feeRegRecieverType[1]==false ){
          	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
          	        	    	return;
          	        	    }
            				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
            				var wsMsgEventRecipientConfigsUpdated = [];
            				/*var wsMsgEventRecipientConfigsUpdated = [{ 
										                           	 	msgRecipientTypeId: 500,
										                           	 	msgTemplateConfigId: 0,	//formData.id, 
										                           	 	selectiveRecipientIds: [] 
										                            },{ 
										                           	 	msgRecipientTypeId: 600,
										                           	 	msgTemplateConfigId: 0,	//formData.id, 
										                           	 	selectiveRecipientIds: [] 
										                            }];*/
            				
            				var formData = obj.up('form').getValues();
            				
            				var sendMessageToOptions = formData.feeRegRecieverType;
            				var isStudentChecked = false;
            				var isParentChecked = false;
            				var isFeePayerChecked = false;
            				
            				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
            					if(sendMessageToOptions.constructor === Array){
            						if(sendMessageToOptions.length > 0){
            							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
                    						if(current_value == 1 || current_value == '1'){
                    							isStudentChecked = true;
                    						}
        									if(current_value == 2 || current_value == '2'){
        										isParentChecked = true;
        									}
        									if(current_value == 3 || current_value == '3'){
        										isFeePayerChecked = true;
        									}
                    					});
            						}
            					}else{
            						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
            							isStudentChecked = true;
            						}
									if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
										isParentChecked = true;
									}
									if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
										isFeePayerChecked = true;
									}
            					}
            				}
            				
            				//var abc = xyz.c;
            				
            				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
            					//wsMsgEventRecipientConfigsUpdated = [];
            					studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
            				}else{
            					var recipientIds;
            					if(grid.itemId == 'studentfeesregistrationreportgrid'){
            						recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
            						recipientIds = Ext.encode(recipientIds);
            						//typeId = 2;
            						//recipientId = 2;
            					}
            					
            					var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];
            					
            					if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
            						// Ajax Call to get Parent Ids by Admission Ids
            						
            						Ext.Ajax.request({
	            						type: 'rest',
	            						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	            						jsonData: RecipientTypeCodes,
	            						method: 'POST',
	            						success: function(response) {
	            							var RecipientTypeCodesData = Ext.decode(response.responseText);
	            							
	            							Ext.Ajax.request({
	    	            						type: 'rest',
	    	            						url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
	    	            						jsonData: recipientIds,
	    	            						method: 'POST',
	    	            						success: function(response) {
	    	            							// update wsMsgEventRecipientConfigsUpdated with parent ids
	    	            							var wsMsgEventRecipientConfigsParents = {
	    									            									msgRecipientTypeId: 66,
	    													                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    													                           	 	selectiveRecipientIds: []
	    										            							};
	    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	    	            							}
	    	            							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	    	            							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	    	            							
	    	            							// Ajax Call to get Fee Payer Ids by Admission Ids
	    	            							Ext.Ajax.request({
	    	    	            						type: 'rest',
	    	    	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
	    	    	            						jsonData: recipientIds,
	    	    	            						method: 'POST',
	    	    	            						success: function(response) {
	    	    	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	    	    	            							var wsMsgEventRecipientConfigsFeePayer = {
	    			            									msgRecipientTypeId: 67,
	    							                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    							                           	 	selectiveRecipientIds: []
	    				            							};
	    	    	            							
	    	    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	    	    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	    	    	            							}
	    	    	            							
	    	    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	    													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	    	    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
	    	    	            						}
	    	    	            					});
	    	            						}
	    	            					});
	            						}
            						});
            					}else{ // Only one checkbox is selected
            						var urlNew = '';
            						if(isParentChecked) { // If Parent checkbox is selected
            							// url for getting parent ids
            							urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
            						}
            						if(isFeePayerChecked) { // If Fee Payer checkbox is selected
            							// url for getting fee payer ids
            							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
            						}
            						
            						Ext.Ajax.request({
	            						type: 'rest',
	            						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
	            						jsonData: RecipientTypeCodes,
	            						method: 'POST',
	            						success: function(response) {
	            							var RecipientTypeCodesData = Ext.decode(response.responseText);
	            							
	            							Ext.Ajax.request({
	    	            						type: 'rest',
	    	            						url: urlNew,
	    	            						jsonData: recipientIds,
	    	            						method: 'POST',
	    	            						success: function(response) {
	    	            							if(isParentChecked) { // If Parent checkbox is selected
	    	            								// update wsMsgEventRecipientConfigsUpdated with parent ids
	    	            								var wsMsgEventRecipientConfigsParents = {
	    		            									msgRecipientTypeId: 66,
	    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    						                           	 	selectiveRecipientIds: []
	    			            							};
	    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
		    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
		    	            							}
	    												wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	    	                						}
	    	            							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
	    	                							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	    	            								var wsMsgEventRecipientConfigsFeePayer = {
	    		            									msgRecipientTypeId: 67,
	    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
	    						                           	 	selectiveRecipientIds: []
	    			            							};
	    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	    	            									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
		    	            							}
	        	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
	    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	    	                						}
	    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll);
	    	            						}
	    	            					});
	            						}
            						});
            						
            					}
            					//studentsendmessage.sendMessage(obj,grid);
            				}
            				
            			}
            		},
	        		'studentfeepayerreportgrid':{
	        			afterrender : function(grid){
	        				var me = this;
	        				me.addDataGridConfigButton(grid,me.getSTUDENT_FEEPAYER_REPORT_PERMISSIONS());
	                     }
	        		},
	        		'studentstartregistrationwin button[itemId=cancelBtn]':{
            			click : function(grid){
            			 this.getStudentstartregistrationwin().close();
            			}
            		},
            		'studentstartregistrationwin button[itemId=submitBtn]':{
            			click : function(grid){
            			  this.doSaveRegistrationDates();
            			}
            		},
	        	});
	        },
	        /**
	         * Method to load the next combo based on the selection of
	         * the previous combo value.
	         * 
	         * @param {Object}
	         *            dependentCombo is the reference of the next
	         *            dropdown which should be populated with
	         *            values.
	         * @param {Object}
	         *            selectedRecord is the record of the previous
	         *            dropdown which is selected.
	         * @param {Object}
	         *            parameter is the value that should be attached
	         *            in the url.
	         * @param {Object}
	         *            extraParameter (optional) If there is any
	         *            extra parameter to be sent for loading the
	         *            dependent dropdown.
	         * @param {Object}
	         *            extraParamValue (optional) The value of the
	         *            extraParam that is sent for loading the store.
	         */
	        loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
	        	var this$ = this;
	        	this$.resetOtherDropdowns(dependentCombo);
	            dependentCombo.store.removeAll();
	            var store = dependentCombo.getStore();
	            var id = comboValue;
	            if(!isNullOrEmpty(id)){
	            	var url = store.getProxy().proxyConfig.api.read;
	                if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
	                    url = url.concat('?' + parameter + '=' + id);
	                } else {
	                    url = url.concat('?' + parameter + '=' + id);
	                    url = url.concat('&' + extraParameter + '=' + extraParamValue);
	                }
	                store.getProxy().api.read = url;
	                store.reload();
	            }
	        },

	        loadDependentComboForFeesRegitration: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
	        	var this$ = this;
	        	this$.resetOtherDropdownsOfFeesRegistration(dependentCombo);
	            dependentCombo.store.removeAll();
	            var store = dependentCombo.getStore();
	            var id = comboValue;
	            if(!isNullOrEmpty(id)){
	            	var url = store.getProxy().proxyConfig.api.read;
	                if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
	                    url = url.concat('?' + parameter + '=' + id);
	                } else {
	                    url = url.concat('?' + parameter + '=' + id);
	                    url = url.concat('&' + extraParameter + '=' + extraParamValue);
	                }
	                store.getProxy().api.read = url;
	                store.reload();
	            }
	        },

	        /**
	         * code to reset other dropdowns based on the selection of
	         * any dropdown which is previous in the hierarchy. eg: if
	         * all the dropdowns are loaded and the Academy is changed
	         * then subsequent dropdowns should be changed accordingly,
	         * so their value is cleared and reset and reloaded.
	         * 
	         * @param: {Object} combo The reference of the dropdown
	         *         which is the dependent/next combo.
	         */
	        resetOtherDropdowns: function(combo) {
	        	$this = this;
	            switch (combo.name) {
	            case 'batch':
	            	$this.clearCombo(combo, false);
	            	var basicStudentSearchForm=$this.getStudentfeepayerreportfilter();
    				var sectionCombo = basicStudentSearchForm.down('#section');
    				$this.clearCombo(sectionCombo, true);
	                break;
	            case 'section':
	            	$this.clearCombo(combo, false);
	                break;
	            }
	        },
	        resetOtherDropdownsOfFeesRegistration: function(combo) {
	        	$this = this;
	            switch (combo.name) {
	            case 'batch':
	            	$this.clearCombo(combo, false);
	            	var basicStudentSearchForm=$this.getStudentfeeregistrationreport();
//    				var sectionCombo = basicStudentSearchForm.down('#section');
//    				$this.clearCombo(sectionCombo, true);
	                break;
	            case 'section':
//	            	$this.clearCombo(combo, false);
	                break;
	            }
	        },
	        /**
	         * function to clear the combo store, clear its existing
	         * value and remove all the records from the store.
	         * 
	         * @param {Object}
	         *            the reference of the combo whose store should
	         *            be cleared.
	         */
	        clearCombo: function(combo, isDisabled) {
	            combo.clearValue();
	            combo.store.removeAll();
	            combo.setDisabled(isDisabled);
	        },
	        resetStudentFeePayerReportFilter:function(){
	        	 var $this=this;
	        	 var form = this.getStudentfeepayerreportfilter();
	        	 
	        	 var multiselectAcademyId = form.down('#multiselectAcademyId');
	        	 var admissionId = form.down('#admissionId');
	        	 var studentId = form.down('#studentId');
	        	 var intakeYear = form.down('#intakeYear');
	        	 var academicTerm = form.down('#academicTerm');
	        	 var programCategory = form.down('#programCategory'); 
	        	 var programGroupId = form.down('#programGroupId');
	        	 var program = form.down('#program');
	        	 var batch = form.down('#batch');
	 			 var section = form.down('#section');
	 			 var feePayerTypeId = form.down('#feePayerTypeId');

	 			//multiselectAcademyId.reset();
	 			admissionId.reset();
	 			studentId.reset();
	 			intakeYear.reset();
	 			academicTerm.reset();
	 			programGroupId.reset();
	 			program.reset();
	 			batch.reset();
	 			section.reset();
	 			feePayerTypeId.reset();
	 			programCategory.reset();
	 			batch.setDisabled(true);
	 			section.setDisabled(true);
	 			// reload form again after reset 
	 			var academyLocationId = this.getCurrentAcademyLocation();
	 			multiselectAcademyId.getStore().load({
					callback: function(record){
						multiselectAcademyId.select(academyLocationId);
					}
				});
	 			this.loadProgramAdmissonAndStudentDetailsOnTheBasisOfAL();
	        	
	        },
	        resetStudentFeesRegistrationReport:function(){
	        	 var $this=this;
	        	 var form = this.getStudentfeeregistrationreport();
	        	 
	        	 var multiselectAcademyId = form.down('#multiselectAcademyId');
	        	 var intakeYear = form.down('#intakeYear');
	        	 var programCategory = form.down('#programCategory'); 
	        	 var programGroupId = form.down('#programGroupId');
	        	 var program = form.down('#program');
	        	 var batch = form.down('#batch');
	        	 var studentIdName = form.down('#studentIdName');
	        	 var statusField = form.down('#status');
	        	 
	 			//multiselectAcademyId.reset();
	 			intakeYear.reset();
	 			programGroupId.reset();
	 			program.reset();
	 			batch.reset();
	 			studentIdName.reset();
	 			programCategory.reset();
	 			statusField.reset();
	 			batch.setDisabled(true);
	 			// reload form again after reset 
	 			var academyLocationId = this.getCurrentAcademyLocation();
	 			multiselectAcademyId.getStore().load({
					callback: function(record){
						multiselectAcademyId.select(academyLocationId);
					}
				});
	 			

				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
				/*var store = program.getStore();
				store.getProxy().extraParams = {
					academyLocationIds:academyIds
				};
				store.load();*/
				
				/*  Code For Reloading Students */
				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
				var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();

	        	var programsCategoryId = [];
	        	for(var i in programCategory){
	        		if(Ext.isObject(programCategory[i])){
	        			programsCategoryId.push(programCategory[i].data.id);
	        		}else{
	        			programsCategoryId.push(programCategory[i]);
	        		}
	        	}
	        	var programCategoryIds = programsCategoryId.join();
	        		var programStore = program.getStore();
             programStore.getProxy().extraParams={
             academyLocationIds: academyLocationId
             };
        programStore.load();
	        		
	        	
				var studentIdNameStore = studentIdNameCombo.getStore();
				       				var filter = $this.getStudentfeeregistrationreport().getForm();
				    	        	var formValue = filter.getValues();
				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
				    				if (academyIds != null && academyIds != '') {
				    					studentIdNameStore.getProxy().extraParams = {
				          					academyLocationIds: academyIds/*,
				    		        		intakeYear : formValue.intakeYear,
				    		        		programCategoryId : formValue.programCategory, 
				    		        		programCategoryId : programCategoryIds,
				    		        		programGroupId : formValue.programGroupId,
				    		        		programId : formValue.program, 
				    		        		batchId : formValue.batch,*/
				          				 };
				    					studentIdNameStore.load();						
				    				}
				    				else{
				    					var academyLocationId=this.getCurrentAcademyLocation();
				    					studentIdNameStore.getProxy().extraParams = {
				          					 academyLocationIds: academyLocationId
				          				 };
				    					studentIdNameStore.load();
				    				}			

				    				var studentFeesRegistrationGrid=$this.getStudentfeesregistrationreportgrid();
			        				var exportButton= studentFeesRegistrationGrid.down('#exportReportItemId');
			        				exportButton.setDisabled(true);
	 			
//	 			this.loadProgramAdmissonAndStudentDetailsOnTheBasisOfAL();
	        	
	        },
	        loadStudentFeePayerReportGrid:function(){
	        	var $this=this;
	        	var grid = $this.getStudentfeepayerreportgrid();
	        	var form = $this.getStudentfeepayerreportfilter();
	        	var filter = form.getForm();
	        	form.down('#btnSearch').setDisabled(true);
	        	var formValue = filter.getValues();
	        	var multiselectAcademyIdField = $this.getStudentfeepayerreportfilter().down('#multiselectAcademyId');
	        	var academyIdsArray = multiselectAcademyIdField.getValue();
	        	var academyIds;
            	if(typeof academyIdsArray[0]!="object"){
            		var academyIds = academyIdsArray;
            	}
            	else {
            		var academyIdsTempArray = [];
            		Ext.each(academyIdsArray,function(currentAcademyId){
            			academyIdsTempArray.push(currentAcademyId.data.id);
            		});
            		var academyIds = academyIdsTempArray.join(',');
            	}
	        	if(!grid.isHidden())
	        	{
	        		var store = grid.getStore();
		        	store.getProxy().extraParams = {
		        		multiselectAcademyIds : academyIds,
		        		admissionId : formValue.admissionId,
		        		studentId : formValue.studentId,
		        		intakeYear : formValue.intakeYear,
		        		academicTerm : formValue.academicTerm,
		        		programCategoryId : formValue.programCategory, 
		        		programGroupId : formValue.programGroupId,
		        		programId : formValue.program, 
		        		batchId : formValue.batch,
		        		sectionId : formValue.section, 
		        		feePayerType : formValue.feePayerType,
		        		withoutFeePayer:formValue.withoutFeePayer
		        	}
	        	}else{
	        		var store = gridAL.getStore();
		        	store.getProxy().extraParams = {
		        		multiselectAcademyIds : academyIds
		        	}
	        		
	        	}	
	        	$this.resetPageSetting(store);
	        	store.load({
					callback: function(record){
						form.down('#btnSearch').setDisabled(false);
					}
				});
	        	grid.config.searchFilterForm = $this.getStudentfeepayerreportfilter();
	        },	        
	        loadStudentFeeRegistrationReportGrid:function(){
	        	var $this=this;
	        	var grid = $this.getStudentfeesregistrationreportgrid();
	        	var buttonsToolBar = grid.query('toolbar')[0];
		    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
		    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
		    	var form = $this.getStudentfeeregistrationreport();
	        	var filter = form.getForm();
	        	form.down('#btnSearch').setDisabled(true);
	        	var formValue = filter.getValues();
	        	var multiselectAcademyIdField = $this.getStudentfeeregistrationreport().down('#multiselectAcademyId');
	        	var academyIdsArray = multiselectAcademyIdField.getValue();
	        	var academyIds;
	        	var programCategory = $this.getStudentfeeregistrationreport().down("#programCategory").getValue();

	        	var programsCategoryId = [];
	        	for(var i in programCategory){
	        		if(Ext.isObject(programCategory[i])){
	        			programsCategoryId.push(programCategory[i].data.id);
	        		}else{
	        			programsCategoryId.push(programCategory[i]);
	        		}
	        	}
	        	var programCategoryIds = programsCategoryId.join();
	        	
            	if(typeof academyIdsArray[0]!="object"){
            		var academyIds = academyIdsArray;
            	}
            	else {
            		var academyIdsTempArray = [];
            		Ext.each(academyIdsArray,function(currentAcademyId){
            			academyIdsTempArray.push(currentAcademyId.data.id);
            		});
            		var academyIds = academyIdsTempArray.join(',');
            	}
	        	if(!grid.isHidden())
	        	{
	        		var store = grid.getStore();
		        	store.getProxy().extraParams = {
		        		multiselectAcademyIds : academyIds,
		        		intakeYear : formValue.intakeYear,
		        		//programCategoryId : formValue.programCategory,
		        		programCategoryId : programCategoryIds,
		        		programGroupId : formValue.programGroupId,
		        		programId : formValue.program, 
		        		batchId : formValue.batch,
		        		studentIdName : formValue.studentIdName,
		        		registrationStatus : formValue.status,
		        	}
	        	}else{
	        		var store = gridAL.getStore();
		        	store.getProxy().extraParams = {
		        		multiselectAcademyIds : academyIds,
		        		intakeYear : formValue.intakeYear
		        	}
	        		
	        	}	
	        	$this.resetPageSetting(store);
	        	store.load({
	        		callback: function(records, operation, success) {
	        			form.down('#btnSearch').setDisabled(false);
	        			if(records.length>0){
	        				pdftoolbar.setDisabled(false);
	        				exceltoolbar.setDisabled(false);
	        			}
	        		}
	        	});
	       	 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
	         	
	         	grid.config.searchFilterForm = $this.getStudentfeeregistrationreport();
	         	
	            /***************End Code added for show filter data on PDF/Excel Export Report **************/
	        },
	        loadDependntDropDownBoxes: function(combo){
	        	$this = this;
	        	var multiselectAcademyIdField = $this.getStudentfeepayerreportfilter().down('#multiselectAcademyId');
 	        	var academyIdsArray = multiselectAcademyIdField.getValue();
 	        	var academyIds;
             	if(typeof academyIdsArray[0]!="object"){
             		var academyIds = academyIdsArray;
             	}
             	else {
             		var academyIdsTempArray = [];
             		Ext.each(academyIdsArray,function(currentAcademyId){
             			academyIdsTempArray.push(currentAcademyId.data.id);
             		});
             		var academyIds = academyIdsTempArray.join(',');
             	}
                    	var store = combo.getStore();
                    	store.getProxy().extraParams = {
                    		academyLocationIds:academyIds
    	        		};
                    	store.load();
                 },
                 getSelectedAcademyIds:function(){
                	 $this = this;
                	 var multiselectAcademyIdField = $this.getStudentfeepayerreportfilter().down('#multiselectAcademyId');
     	        	var academyIdsArray = multiselectAcademyIdField.getValue();
     	        	var academyIds;
     	        	var academyIdsTempArray = [];
     	        	if (academyIdsArray == null && academyIdsArray == undefined) {
     	        		academyIdsArray = $this.getCurrentAcademyLocation();
					}
     	        	if(typeof academyIdsArray[0]!="object"){
						academyIdsTempArray.push(academyIdsArray);
                	}
                	else {
                		Ext.each(academyIdsArray,function(currentAcademyId){
                			academyIdsTempArray.push(currentAcademyId.data.id);
                		});
                		
                	}
     	        	academyIds = academyIdsTempArray.join(',');
                 	return academyIds;
                 },
                 
                 getSelectedAcademyIdsForFeesRegistration:function(){
                	 $this = this;
                	 var multiselectAcademyIdField = $this.getStudentfeeregistrationreport().down('#multiselectAcademyId');
     	        	var academyIdsArray = multiselectAcademyIdField.getValue();
     	        	var academyIds;
     	        	var academyIdsTempArray = [];
     	        	if (academyIdsArray == null && academyIdsArray == undefined) {
     	        		academyIdsArray = $this.getCurrentAcademyLocation();
					}
     	        	if(typeof academyIdsArray[0]!="object"){
						academyIdsTempArray.push(academyIdsArray);
                	}
                	else {
                		Ext.each(academyIdsArray,function(currentAcademyId){
                			academyIdsTempArray.push(currentAcademyId.data.id);
                		});
                		
                	}
     	        	academyIds = academyIdsTempArray.join(',');
                 	return academyIds;
                 },
                 
                 getSelectedProgramCategoryIdForFeesRegistration:function(){
                	$this = this;
                	var multiselectProgramCategory = $this.getStudentfeeregistrationreport().down('#programCategory');
     	        	var programCategoryIdsArray = multiselectProgramCategory.getValue();
     	        	var programCategoryIds;
     	        	var programCategoryIdsTempArray = [];
     	        	if(!isNullOrEmpty(programCategoryIdsArray)){
     	        	if(typeof programCategoryIdsArray[0]!="object"){
     	        		programCategoryIdsTempArray.push(programCategoryIdsArray);
                	}
                	else {
                		Ext.each(programCategoryIdsArray,function(programCategoryId){
                			programCategoryIdsTempArray.push(programCategoryId.data.id);
                		});
                		
                	}
     	        	}
     	        	programCategoryIds = programCategoryIdsTempArray.join(',');
                 	return programCategoryIds;
                 },
                 
                 loadProgramAdmissonAndStudentDetailsOnTheBasisOfAL: function(){
                	 $this = this;
     				var academyIds = $this.getSelectedAcademyIds();
     				if (academyIds == null || academyIds == '') {
     					academyIds = $this.getCurrentAcademyLocation();
					}
     				var basicStudentFeePayerSearchForm=$this.getStudentfeepayerreportfilter();
     				var programGroupCombo = basicStudentFeePayerSearchForm.down('#programGroupId');
     				var programCombo = basicStudentFeePayerSearchForm.down('#program');
     				var admissionCombo = basicStudentFeePayerSearchForm.down('#admissionId');
     				var studentCombo = basicStudentFeePayerSearchForm.down('#studentId');
     				
     				var programGroupStore = programGroupCombo.getStore();
     				var programComboStore=programCombo.getStore();
     				var admissionComboStore=admissionCombo.getStore();
     				var studentComboStore=studentCombo.getStore();
     				programGroupCombo.clearValue();
     				programCombo.clearValue();
     				admissionCombo.clearValue();
     				studentCombo.clearValue();
     				programGroupStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				programComboStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				studentComboStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				admissionComboStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				programGroupStore.load();
     				programComboStore.load();
     				admissionComboStore.load();
     				studentComboStore.load();
                 },
                 loadProgramAdmissonAndStudentDetailsOnTheBasisOfALforFeesRegistration: function(){
                	 $this = this;
     				var academyIds = $this.getSelectedAcademyIdsForFeesRegistration();
     				if (academyIds == null || academyIds == '') {
     					academyIds = $this.getCurrentAcademyLocation();
					}
     				var stuFeeRegistrationReport=$this.getStudentfeeregistrationreport();
     				var programGroupCombo = stuFeeRegistrationReport.down('#programGroupId');
     				var programCategoryCombo = stuFeeRegistrationReport.down('#programCategory');
     				var programCombo = stuFeeRegistrationReport.down('#program');
     				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
     				
     				var programGroupStore = programGroupCombo.getStore();
     				var programCategoryStore = programCategoryCombo.getStore();
     				var programComboStore=programCombo.getStore();
     				
     				programGroupCombo.clearValue();
     				programCategoryCombo.clearValue();
     				programCombo.clearValue();
     				programGroupStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				programCategoryStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				programComboStore.getProxy().extraParams = {
     					academyLocationIds:academyIds
     				};
     				
/*       			var studentIdNameStore = studentIdNameCombo.getStore();
       				var filter = $this.getStudentfeeregistrationreport().getForm();
    	        	var formValue = filter.getValues();
    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    				if (academyIds != null && academyIds != '') {
    					studentIdNameStore.getProxy().extraParams = {
          					academyLocationIds: academyIds,
    		        		intakeYear : formValue.intakeYear,
    		        		programCategoryId : formValue.programCategory, 
    		        		programGroupId : formValue.programGroupId,
    		        		programId : formValue.program, 
    		        		batchId : formValue.batch,
          				 };
    					studentIdNameStore.load();						
    				}
    				else{
    					var academyLocationId=this.getCurrentAcademyLocation();
    					studentIdNameStore.getProxy().extraParams = {
          					 academyLocationIds: academyLocationId
          				 };
    					studentIdNameStore.load();
    				}
*/    			
     				
                 },
                 exportStudentFeeRegistrationReportXLFunction: function() {
                	 var $this = this;
     	        	 var filter = $this.getStudentfeeregistrationreport().getForm();
     	        	 var formValue = filter.getValues();
     	        	 var academyIds = $this.getSelectedAcademyIdsForFeesRegistration();
     	        	 var programCategoryIds	= $this.getSelectedProgramCategoryIdForFeesRegistration();	
     	        	 if (academyIds == null || academyIds == '') {
     	        		 academyIds = $this.getCurrentAcademyLocation();
     	        	 }
                	 var code = "STUDENT_FEE_REG_REPORT";
                	 var reportParams = new Object();
                	 reportParams.code = code;
                	 var reportTitle="Student Fee Registration Report";
                	 reportParams.reportTitle = reportTitle ;
                	 reportParams.academyLocationIds = academyIds;
                	 reportParams.intakeYear = formValue.intakeYear;
                	 reportParams.programCategoryId = programCategoryIds;
                	 reportParams.programGroupId = formValue.programGroupId;
                	 reportParams.programId = formValue.program;
                	 reportParams.batchId = formValue.batch;
                	 reportParams.studentId = formValue.studentIdName;
                	 reportParams.academyLocationId = $this.getCurrentAcademyLocation();
                	 reportParams.headerName = reportTitle;
                	 $this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.FIND_STUDENT_FEES_REGISTRATION_REPORT_JASPER_VELOCITY);
                 },
                
                 doAccessControlValidationOfSendMsgBtn:function(grid, privilegesMap) {
             		var associatedAcadLIds = new Array();
             		associatedAcadLIds.push(this.getCurrentAcademyLocation());
             		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLIds, privilegesMap);
             		var portalId = this.getCurrentLoggedPortalId();
             		var sendMsgBtn =  grid.down('#sendMessageBtn').setVisible(false);
             		var startRegis = grid.down('#startRegistrationBtn');
             		startRegis.setVisible(false);
             		Ext.each(permissionList, function(privilege) {
             				if(privilege == 'SENDMESSAGE'){
             					sendMsgBtn.setVisible(true);
             				}
             				if(privilege == 'START_REGISTRATION'){
             					startRegis.setVisible(true);
             				}
             		});
             	},
             	
             	deleteStudentFeesRegistrationReportStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
			    	   var grid = view.up('#studentFeesRegistrationReportStaticDocumentAttachmentGridMessage');
			    	   var panel = this.getContentPanel().getActiveTab();
			    	   var tabTitle = panel.title;
			    	   var store = grid.getStore();
			    	   var templateConfigDocId = record.get('templateConfigDocId');
			    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
			    	   if(!(tabTitle == viewTitle)){
			    		   if(!isNullOrEmpty(templateConfigDocId)){
			    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			    				   if (btn == 'yes') {
			    					   Ext.Ajax.request({
			    						   type: 'rest',
			    						   url: SERVERURL.STATIC_DOC_DELETE,
			    						   method: 'DELETE',
			    						   params: {
			    							   templateConfigDocId : templateConfigDocId
			    						   },
			    						   headers: {
			    							   'Content-Type': 'application/json'
			    						   },
			    						   success: function(form, action) {
			    							   store.remove(record);
			    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
			    						   }
			    					   });
			    				   }
			    			   });

			    		   }else{
			    			   store.remove(record);
			    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
			    		   }
			    	   }else{
			    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
			    	   }

			       },
			       
			       selectSectionMessageType : function(val,nV,oV){

				      	 var $this =  this;
				      	 var formWin = $this.getStudentfeesregistrationreportsendmessages();

				      	 //var value = nV.1;
				      	formWin.down('#feeRegRecieverTypeIncludeMySelf').setValue(false);
				      	 if(nV.messageType==2){
				      		 formWin.down("#feeRegMessageId").hide();
				      		 formWin.down("#feeRegSelectTemplate").allowBlank=true;
				      		 formWin.down("#feeRegSelectTemplate").setVisible(false);     		 
				      		 formWin.down("#feeRegMessageName").allowBlank=true;   
				      		 formWin.down("#feeRegMessageName").setVisible(false);
				      		 formWin.down("#feeRegMsgTempletId").setVisible(true);
				      		 formWin.down("#feeRegMsgTempletId").allowBlank=false;
				      		 formWin.down("#feeRegMsgTempletId").reset();
				      		 formWin.down("#feeRegSubject").setVisible(true);
				      		 //formWin.down("#subject").allowBlank=false;
				      		 formWin.down("#feeRegSubject").reset();
				      		 formWin.down("#empDiscriptionId").setVisible(true);
				      		 formWin.down("#empDiscriptionId").reset();
				      		 formWin.down('#feeRegSmsDiscription').reset();
				      		 formWin.down('#feeRegSmsDiscription').hide();
				      		 formWin.down('#feeRegSmsDiscriptionNotice').hide();
				     		 formWin.down('#feeRegPushNotificationDiscription').hide();
				     		 formWin.down('#feeRegPushNotificationDiscriptionNotice').hide();
				     		 formWin.down('#feeRegRecieverTypeIncludeMySelf').setVisible(true);
				      		 this.setAllowBlank (formWin.down("#feeRegSubject"),false);
				      	 }else{
				      		 formWin.down("#feeRegMsgTempletId").allowBlank=true;
				      		 formWin.down("#feeRegMsgTempletId").setVisible(false);     		
				      		 formWin.down("#feeRegMessageId").setVisible(true);
				      		 formWin.down("#feeRegSelectTemplate").setVisible(true);     		
				      		 formWin.down("#feeRegMessageName").setVisible(true);
				      		 formWin.down("#feeRegMessageName").reset();
				      		 //formWin.down("#subject").allowBlank=true;
				      		 this.setAllowBlank (formWin.down("#feeRegSubject"),true);
				      		 formWin.down("#feeRegSubject").setVisible(false);
				      		 formWin.down("#empDiscriptionId").setVisible(false);
				      		 formWin.down("#feeRegMessageName").allowBlank=false;  
				      		 formWin.down("#feeRegSelectTemplate").allowBlank=false;
				      		 formWin.down("#feeRegSelectTemplate").reset();
				      		 formWin.down("#feeRegDocumentMessageAttachmentGrid").setVisible(false);
				      		 formWin.down("#feeRegStaticUploadFileField").setVisible(false);
				      		 formWin.down('#feeRegSmsDiscription').reset();
				      		 formWin.down('#feeRegSmsDiscription').hide();
				      		 formWin.down('#feeRegSmsDiscriptionNotice').hide();
				     		 formWin.down('#feeRegPushNotificationDiscription').hide();
				     		 formWin.down('#feeRegPushNotificationDiscriptionNotice').hide();
				     		 formWin.down('#feeRegRecieverTypeIncludeMySelf').setVisible(false);
				      		 this.setAllowBlank (formWin.down("#feeRegMessageName"),false);
				      		 this.setAllowBlank (formWin.down("#feeRegSelectTemplate"),false);
				      		// var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
				      		// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
				      		 //formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
				      	 }
				       },
				       
				       openStudentFeesRegistrationReportSendMessage:function(obj){

							var grid = this.getStudentfeesregistrationreportgrid();
							if(grid.getSelectionModel().getCount()>0) {
								
								var $this=this;
								var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
								var structure = Ext.widget('studentfeesregistrationreportsendmessages',{
									itemId:'FeeRegReportForStudent'
								});
								var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
								/**
								 * This is to remove tab from content panel and open same tab again
								 */
								var getcontroller=this.getController('menu.CoreERPNavigationController');
								var getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentPanel.remove(getTab, true);
								}
								var formWindowTab = $this.getStudentfeesregistrationreportsendmessages();
								formWindowTab.down("#feeRegSelectTemplate").allowBlank=true;
								formWindowTab.down("#feeRegSelectTemplate").setVisible(false);
								formWindowTab.down("#feeRegMessageName").allowBlank=true;   
								formWindowTab.down("#feeRegMessageName").setVisible(false);
							 var templateStore = formWindowTab.down('#feeRegSelectTemplate').getStore();
								templateStore.getProxy().extraParams={
									msgRecipientTypeId:2
								};
								templateStore.load();

								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=Election539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form,action) {
										var data = Ext.JSON.decode(form.responseText);
										formWindowTab.down("#id").setValue(data.id);
										formWindowTab.down("#code").setValue(data.code);
										formWindowTab.down("#feeRegTemplateConfigName").setValue(data.templateConfigName);
										formWindowTab.down("#feeRegMsgSubCategoryId").setValue(data.msgSubCategoryId);
										formWindowTab.down("#feeRegMsgCategoryId").setValue(data.msgCategoryId);
										Ext.getBody().unmask();

										//grid.getStore().reload();
										//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
									}

								});
								openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_SEVEN);
								/*if (!formWindow) {
							    				Ext.widget('jobapplicationemployeesendmessages');
							    				formWindow = $ this.getElectionvoterpoolsendmessages();
							    			}
							    			formWindow.show(;*/

							} else {
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						},
						
						selectMessageTempForStudentFeesRegistrationReport:function(obj,rec){
							

							var $this =  this;
							var formWin = $this.getStudentfeesregistrationreportsendmessages();
							var empSubject = formWin.down('#feeRegSubject');
							var smsDiscription = formWin.down('#feeRegSmsDiscription');
							var smsDiscriptionNotice = formWin.down('#feeRegSmsDiscriptionNotice');
							var pushNotificationDiscription = formWin.down('#feeRegPushNotificationDiscription');
							var pushNotificationDiscriptionNotice = formWin.down('#feeRegPushNotificationDiscriptionNotice');
							if(rec[0].data.value == "SMS")
							{  
								this.setAllowBlank (formWin.down("#feeRegSubject"),true);
								//formWin.down("#empSubject").allowBlank=true;
								formWin.down("#feeRegSubject").hide();
								formWin.down("#feeRegStaticUploadFileField").hide();
								formWin.down("#feeRegDocumentMessageAttachmentGrid").hide();
								formWin.down('#empDiscriptionId').reset();
								formWin.down('#empDiscriptionId').hide();	       		 
								formWin.down('#feeRegSubject').reset();
								formWin.down('#feeRegSmsDiscription').show();
								formWin.down('#feeRegSmsDiscriptionNotice').show();
								pushNotificationDiscription.hide();
								pushNotificationDiscriptionNotice.hide();
								pushNotificationDiscription.reset();
							}/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
								      		 empSubject.show();
								      		 formWin.down("#empStaticUploadFileField").hide();
								      		 this.setAllowBlank(empSubject,false);
								      		 formWin.down("#VoterPoolStudentDocumentMessageAttachmentGrid").hide();
								      		 formWin.down('#empDiscriptionId').reset();
								      		 formWin.down('#empDiscriptionId').hide();
								      		 empSubject.reset();
								      		 smsDiscription.reset();
								      		 smsDiscription.hide();
								      		 empSmsDiscriptionNotice.hide();
								      		 pushNotificationDiscription.reset();
								      		 pushNotificationDiscription.show();
								      		 pushNotificationDiscriptionNotice.show();
								      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
								      		 //formWin.down('#smsDiscription')
								      	 }*/else{
								      		 formWin.down('#empDiscriptionId').reset();
								      		 formWin.down('#empDiscriptionId').reset();
								      		 formWin.down('#feeRegSmsDiscription').hide();
								      		 formWin.down('#feeRegSmsDiscriptionNotice').hide();
								      		 formWin.down("#feeRegStaticUploadFileField").show();
								      		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
								      		 formWin.down("#feeRegDocumentMessageAttachmentGrid").show();
								      		 formWin.down("#feeRegSubject").reset();
								      		 formWin.down("#feeRegSubject").show();
								      		 this.setAllowBlank (formWin.down("#feeRegSubject"),false);
								      		 //formWin.down("#empSubject").allowBlank=false;
								      		 formWin.down('#empDiscriptionId').show();
								      		pushNotificationDiscription.hide();
								      		pushNotificationDiscriptionNotice.hide();
								      		pushNotificationDiscription.reset();
								      	 }
						
							
						},
						 uploadFeeRegStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
					    	   var this$ = this;
					    	   var setupForm = fileField.up('studentfeesregistrationreportsendmessages');
					    	   var grid = setupForm.down('#studentFeesRegistrationReportStaticDocumentAttachmentGridMessage');
					    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
					    	   fileField.setRawValue(fileUploadPath);
					    	   var file = fileField.fileInputEl.dom.files[0];
					    	   fileField.setRawValue(fileUploadPath);
					    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
					    		   if(!isNullOrEmpty(fileUploadPath)){
					    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
					    			   if (extension == "gif" || extension == "png" || extension == "bmp"
					    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
					    					   || extension == "doc" || extension == "docx" || extension == "txt"
					    						   || extension == "xls" || extension == "csv" || extension == "xml" 
					    							   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
					    				   var entityId = 'student';
					    				   var module = 'messaging';
					    				   var entityType = 'template';
					    				   var documentType = 'DOCUMENT';
					    				   var isTransient = true;
					    				   var this$ = this;
					    				   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
					    				   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
					    					   if(success){
					    						   Ext.getBody().unmask();
					    						   var path = Ext.JSON.decode(action.response.responseText).path;
					    						   var user = this$.getCurrentlyLoggedInUser();
					    						   var store = grid.getStore();
					    						   var documentStatus = "SUBMITTED";
					    						   var documentType = null;
					    						   if(!isNullOrEmpty(path)){
					    							   store.add({
					    								   id: '',
					    								   name: fileUploadPath,
					    								   path: path ,
					    								   createdBy : {
					    									   id :user.id,
					    									   value : user.value,
					    									   code : user.code
					    								   },
					    								   status : documentStatus,
					    								   documentType : documentType,
					    								   templateConfigDocId: '',
					    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

					    							   });
					    							   this$.loadFeeRegGridWithFileNameMessage(grid,fileUploadPath,store);
					    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
					    						   }
					    						   var form=this$.getStudentfeesregistrationreportsendmessages();
					           	            	   var feeRegSubject = form.down('#feeRegSubject').getValue();
					           	            	   if(!isNullOrEmpty(feeRegSubject)){
					           	            		   if(feeRegSubject == ' '){
					           	            			form.down('#feeRegSubject').reset();
					           	            		   }
					           	            	   }
					    						   fileField.reset();
					    					   }

					    				   }, isTransient);
					    			   }else{
					    				   fileField.reset();
					    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					    			   }
					    		   }
					    	   }else{
					    		   fileField.reset();
					    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					    	   }
					       },
					       
					       loadFeeRegReportScheduleField : function(radio,newValue, oldValue){
								var adhocMessageForm = radio.up('form');
								var scheduleDateField = adhocMessageForm.down('#feeRegScheduleDate');
								var scheduleTimeField = adhocMessageForm.down('#feeRegScheduleTime');
								var radioValue = radio.getValue().feeRegSendingPriority;

								if(radioValue=='IMMEDIATE'){
									scheduleDateField.setVisible(false);
									scheduleDateField.setDisabled(true);
									scheduleTimeField.setVisible(false);
									scheduleTimeField.setDisabled(true);    		
								}
								else if(radioValue=='SCHEDULE'){
									scheduleDateField.setVisible(true);
									scheduleDateField.setDisabled(false);
									scheduleTimeField.setVisible(true);
									scheduleTimeField.setDisabled(false);
								}
							},
							saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
						       	var submitUrl = '';
						       	var templateTab = this.getContentPanel();
						       	var formWin =  this.getStudentfeesregistrationreportsendmessages();
						       	var form = formWin.down('#feeRegMsgDetailsForm');
						       	var id = form.down('#feeRegDocument_hidden_field');
						           if (isNullOrEmpty(id.getSubmitValue())) {
						               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
						           }
						           var data = new Object();
						           if(!isNullOrEmpty(entityId)){
						           	data.entityId = entityId;
						           }else{
						           	data.entityId = null;
						           }
						           if(!isNullOrEmpty(module)){
						           	data.module = module;
						           }else{
						           	data.module = null;
						           }
						           if(!isNullOrEmpty(entityType)){
						           	data.entityType = entityType;
						           }else{
						           	data.entityType = null;
						           }
						           form.getForm().setValues(data);
						           form.getForm().submit({
						           	method : 'POST',
						           	url : submitUrl,
						           	success : function(form, action){
						           		callBackFunction(true, action, isTransient);
						           		
						           	}
						           });
						       },
						       loadFeeRegGridWithFileNameMessage:function(grid,value,store){
						    	   grid.bindStore(store);
						       },
						       doStartRegistrationProcess:function(){
						    	   var grid = this.getStudentfeesregistrationreportgrid();
						    	   if(grid.getSelectionModel().getCount()>0) {
						    		   var regWin = this.getStudentstartregistrationwin();
						    		   if (!regWin) {
						    			   Ext.widget('studentstartregistrationwin');
						    			   regWin = this.getStudentstartregistrationwin();
						    		   }
						    		   regWin.show();
						    	   }
						    	   else{
						    		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						    	   }
						       },
						       doSaveRegistrationDates:function(){
						    	   var filter = this.getStudentfeeregistrationreport();
						    	   var grid = this.getStudentfeesregistrationreportgrid();
						    	   var records = grid.getSelectionModel().getSelection();
						    	   var regWin = this.getStudentstartregistrationwin(); 
						    	   var formData = regWin.down('form').getValues();
    							   var stdIds = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'studentId');
    							   var intakeYearId = filter.down('#intakeYear').getValue();
						    	   var json = {
						    			   studentId:stdIds,
						    			   startRegistrationDate:formData.fromDate,
						    			   endRegistrationDate:formData.toDate,
						    			   intakeYearId:intakeYearId
						    	   };
						    	   Ext.Ajax.request({
						    		   type: 'rest',
						    		   url:SERVERURL.PATH_STUDENT_REGISTRATION_SAVE,
						    		   jsonData:Ext.encode(json),
						    		   method: 'POST',
						    		   success: function(response) {
						    			  grid.getSelectionModel().deselectAll();
						    			  regWin.close();
		    							  showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('THE_REGISTRATION_HAS_BEEN_STARTED_SUCCESSFULLY'));
						    		   }
						    	   });
						       },
						       getStudentReceipientIdsForSendingMessages : function(grid){
						    		
						    		if (grid.getSelectionModel().getCount() > 0) {
						    			var records = grid.getSelectionModel().getSelection();
						    			var ids=[];
						    			if(grid.itemId == 'studentfeesregistrationreportgrid'){
						    				for(var i in records) {
						    					ids.push(records[i].data.aId);
						    				}
						    			}			
						    		}
						    		return ids;
						    	},
				       
});

