/**
 * @author Pritam.Patil
 * This controller is used for User Frequency Functionality
 */
Ext.define('Academia.controller.systemusage.SystemUsageController', {
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    views: ['systemUsage.UserFrequencyScreen','systemUsage.UserFrequencySearchForm','systemUsage.UserFrequencyView',
            'systemUsage.SystemUsageCommonSearchForm','systemUsage.AverageTimeSearchForm','systemUsage.AverageTimeScreen',
            'systemUsage.AverageTimeView','systemUsage.DailyUsageView','systemUsage.DailyUsageScreen',
            'systemUsage.DailyUsageSearchForm','systemUsage.UserFrequencyGridWindow',
            'reports.common.SimpleLineChartReport','systemUsage.SystemUsesModuleView',
            'systemUsage.UserFrequencyUsers','systemUsage.SystemUsageSearchPanel','systemUsage.SystemUsageCommonSearchDailyUsageForm','systemUsage.SystemUsageGrid'],

    stores: ['systemusage.YearStore',
             'systemusage.Modules','systemusage.SubMdules',
             'securitysetup.unlockUser.acadamyStore','systemusage.UserNames','systemusage.UserGroupStore',
             'systemusage.SystemUsageFrequency','systemusage.DailyUsageGraphStore','common.AcademyLocationNameSeparated',
             'systemusage.CountOfModuleUsesStore','common.AllActiveAcademyLocationStore','systemusage.UsersNameStore',
             'common.AssignedAcademyLocations','criteriabuilder.userquicksearch.QuickSearchCode','systemusage.UserNamesAndCode','feeandpayment.managebill.StudentNameAndCode','systemusage.UserLoginDetailsStore',
             'reports.userroleprivilege.URPPortalStore','reports.userroleprivilege.URPModuleStore'],
             
             refs: [{
            	 ref: 'dailyusagescreen',
            	 selector: 'dailyusagescreen'
             },{
            	 ref: 'loginFrequencyGrid',
            	 selector: 'loginfrequencygrid[itemId=loginFrequencyForDailyUsagegrid]'
             },{
		        ref: 'basicUserFrequencySearch',
		        selector: 'userfrequencysearchform[itemId=userFrequency_quick_search]'
		 },{
		        ref: 'searchResultGrid',
		        selector: 'searchresultgrid[itemId=userFrequencyGrid]'
		 },{
		        ref: 'moduleUserDetailsGrid',
		        selector: 'searchresultgrid[itemId=moduleUserDetailsGrid]'
		 },{
		        ref: 'averageTimeSearchForm',
		        selector: 'averagetimesearchform[itemId=averageTime_quick_search]'
    	},{
		        ref: 'averageSearchResultGrid',
		        selector: 'searchresultgrid[itemId=averageTimeGrid]'
    	},{
		        ref: 'dailyUsageSearchForm',
		        selector: 'dailyusagesearchform[itemId=dailyUsage_quick_search] '
    	},{
		        ref: 'dailySearchResultGrid',
		        selector: 'searchresultgrid[itemId=dailyUsageGrid]'
    	},{
    		ref: 'userFrequencyGridWindow',
	        selector: 'userfrequencygridwindow'
    	},{
    		ref:'dailyUsageChart',
    		selector:'simplelinechartreport[itemId=dailyUsageChart]'
    	},{
    		ref:'systemusagesearchpanel',
    		selector:'systemusagesearchpanel'
    	},{
    		ref:'systemusagegrid',
    		selector:'systemusagegrid'
    	},{
    		ref:'userfrequencysearchform',
    		selector:'userfrequencysearchform'
    	}],
    	config: {
        	USER_FREQUENCY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_FREQUENCY_PRIVILEGES'),
        	DAILY_USAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DAILY_USAGE_PRIVILEGES'),
        	AVERAGE_TIME_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('AVERAGE_TIME_PRIVILEGES')
        },
    init: function(application) {

        this.control({
        	'systemusagecommonsearchform combo[itemId=multiselectAcademyLocationId]':{
        		render : function(obj){
        			var form = obj.up('form');
        			var form1 = form.up('form');
        			var searchviewForm = this.getAverageTimeSearchForm();
           			searchviewForm.down("#frequency_user_id").setDisabled(true);
        			if(!Ext.isDefined(form1)){
        				form1 = form.up('systemusagesearchpanel').down('averagetimesearchform');
        			}
        			var userFreqPermission = this.getUSER_FREQUENCY_PERMISSIONS();
        			var dailyUsagePermission = this.getDAILY_USAGE_PERMISSIONS();
        			var avgTimePermission = this.getAVERAGE_TIME_PERMISSIONS();
        			
        			var permission = null;
        			if(form1.xtype == 'averagetimesearchform'){
        				permission = avgTimePermission;
        			}else if(form1.xtype == 'userfrequencysearchform'){
        				permission = userFreqPermission;
        			}else if(form1.xtype == 'dailyusagesearchform'){
        				permission = dailyUsagePermission;
        			}
        					
        			this.setAllAlIds(form,permission);

        			var searchviewForm = this.getAverageTimeSearchForm();
        			if(obj.lastSelection.length>0){
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(false);
        			}
        			else{
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(true);
        			}
        			var user = searchviewForm.down('#frequency_user_id');
        			//var student=searchviewForm.down('#studentCodeId');
                   	var academyLocationId=obj.getValue();
                   	if(!isNullOrEmpty(academyLocationId)){
                   		var store = user.getStore();
                   		store.getProxy().extraParams={
           					id:academyLocationId.join(),
           				};
                   		store.load();
                  
                   	} 
        		
        		},
        		change : function(combo,records){
        			var searchviewForm = this.getAverageTimeSearchForm();
        			if(combo.lastSelection.length>0){
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(false);
        			}
        			else{
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(true);
        			}
        			var user = searchviewForm.down('#frequency_user_id');
        			user.lastQuery=null;
        			//var student=searchviewForm.down('#studentCodeId');
                   	var academyLocationId=combo.getValue();
                   	if(!isNullOrEmpty(academyLocationId)){
                   		var store = user.getStore();
                   		store.getProxy().extraParams={
           					id:academyLocationId.join(),
           					userGroup:searchviewForm.down('#frequency_user_group').getValue()
           				};
                   		store.load();
                   	
                   	} 
        		}
        	},
        	'averagetimesearchform[itemId=averageTime_quick_search] multiselectcombofield[itemId=multiselectAcademyLocationId]':{
        		render : function(obj){
        			var form = obj.up('form');
        			var form1 = form.up('form');
        			var searchviewForm = this.getAverageTimeSearchForm();
        			searchviewForm.down("#frequency_user_id").setDisabled(true);
        			var alFields = searchviewForm.down('#multiselectAcademyLocationId');
        			this.setAllowBlank(alFields, false);
        			if(!Ext.isDefined(form1)){
        				form1 = form.up('systemusagesearchpanel').down('averagetimesearchform');
        			}
        			var userFreqPermission = this.getUSER_FREQUENCY_PERMISSIONS();
        			var dailyUsagePermission = this.getDAILY_USAGE_PERMISSIONS();
        			var avgTimePermission = this.getAVERAGE_TIME_PERMISSIONS();
        			
        			var permission = null;
        			if(form1.xtype == 'averagetimesearchform'){
        				permission = avgTimePermission;
        			}
        					
        			this.setAllAlIds(form,permission);

        			var searchviewForm = this.getAverageTimeSearchForm();
        			if(obj.lastSelection.length>0){
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(false);
        			}
        			else{
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(true);
        			}
        			var user = searchviewForm.down('#frequency_user_id');
                   	var academyLocationId=obj.getValue();
                   	if(!isNullOrEmpty(academyLocationId)){
                   		var store = user.getStore();
                   		store.getProxy().extraParams={
           					id:academyLocationId.join(),
           				};
                   		store.load();
                  
                   	} 
        		
        		},
        		change : function(combo,records){
        			var searchviewForm = this.getAverageTimeSearchForm();
        			if(combo.lastSelection.length>0){
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(false);
        			}
        			else{
        				searchviewForm.down("#averageTimeSearchBtn").setDisabled(true);
        			}
        			var user = searchviewForm.down('#frequency_user_id');
        			user.lastQuery=null;
                   	var academyLocationId=combo.getValue();
                   	if(!isNullOrEmpty(academyLocationId)){
                   		var store = user.getStore();
                   		store.getProxy().extraParams={
           					id:academyLocationId.join(),
           					userGroup:searchviewForm.down('#frequency_user_group').getValue()
           				};
                   		store.load();
                   	
                   	} 
        		}
        	},
        	'systemusagecommonsearchdailyusageform combo[itemId=multiselectAcademyLocationId]':{
        		render : function(obj){
        			var form = obj.up('form');
        			var form1 = form.up('form');
        			
        			if(!Ext.isDefined(form1)){
        				form1 = form.up('systemusagesearchpanel').down('averagetimesearchform');
        			}
        			var userFreqPermission = this.getUSER_FREQUENCY_PERMISSIONS();
        			var dailyUsagePermission = this.getDAILY_USAGE_PERMISSIONS();
        			var avgTimePermission = this.getAVERAGE_TIME_PERMISSIONS();
        			
        			var permission = null;
        			if(form1.xtype == 'averagetimesearchform'){
        				permission = avgTimePermission;
        			}else if(form1.xtype == 'userfrequencysearchform'){
        				permission = userFreqPermission;
        			}else if(form1.xtype == 'dailyusagesearchform'){
        				permission = dailyUsagePermission;
        			}
        					
        			this.setAllAlIds(form,permission);
        		},
        
        	},
        	'systemusagecommonsearchform combo[itemId=basic_Year]':{
        		render : this.loadData
        	},
        	
        	/* User Frequency */
        	'userfrequencysearchform[itemId=userFrequency_quick_search] button[itemId=userFrequencySearchBtn]': {
        		click: this.loadActiveGrid,
//        		render: this.loadUserFrequencySearchResultGrid
        	},
            /*'userfrequencysearchform[itemId=userFrequency_quick_search] radiogroup':{
            	 focus: this.hideShowCombo
            },*/
            'userfrequencysearchform[itemId=userFrequency_quick_search] radio':{
            	focus: this.hideShowUserType
           },
            'userfrequencysearchform[itemId=userFrequency_quick_search] button[itemId=userFrequencyClearSearchBtn]':{
           	 	click: this.clearSearchForm
           },
           'userfrequencysearchform[itemId=userFrequency_quick_search] multiselectcombofield[itemId=multiselectAcademyLocationId]':{
           	 render: function(obj){
     			var form = obj.up('form');
     			var userFreqPermission = this.getUSER_FREQUENCY_PERMISSIONS();
     			this.setAllAlIds(form,userFreqPermission);
           	 }
          },
           'userfrequencysearchform[itemId=userFrequency_quick_search] multiselectcombofield[itemId=basic_Modules]':{
             	change: this.loadCombo
            },
           'userfrequencysearchform[itemId=userFrequency_quick_search] combo[itemId=frequency_user_name]':{
             	 focus: this.loadUserNamesCombo
             },
             'userfrequencyscreen searchresultgrid[itemId=userFrequencyGrid]': {
                 cellclick: this.cellClickUserFrequencyGrid,
                 render: function(grid) {
  					this.gridRenderFunction(grid);
  				},
  				afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getUSER_FREQUENCY_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
             },
             'systemusesmoduleview columnchartreport' : {
            	 afterrender: function(chart) {
            		 this.addColumListener(chart);
        		 }
             },
             
             'userfrequencyscreen searchresultgrid#moduleUserDetailsGrid' : {
            	 render:  function(grid) {
            		 this.gridRenderFunction(grid);
            		 this.loadModuleUserDetailsGrid(grid);
        		 },
        		 afterrender : function(grid){
 					this.genericCBGridAccessControlValidation(grid, this.getUSER_FREQUENCY_PERMISSIONS());
 					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
 				}
             },
             
            /* Average Time Functions */
           
           'averagetimesearchform button[itemId=averageTimeSearchBtn]': {
               	 click: this.loadAverageTimeSearchResultGrid,
//               	render: this.loadAverageTimeSearchResultGrid
           },
           'averagetimesearchform radiofield[itemId=allRadioBtn]':{
           	 	 focus: this.hideAllCombo
           },
           'averagetimesearchform radiofield[itemId=individualRadioBtn]':{
             	 focus: this.hideCombo
           },
           'averagetimesearchform radiofield[itemId=userGroupRadioBtn]':{
               	 focus: this.showCombo
           },
           'averagetimesearchform button[itemId=averageTimeClearSearchBtn]':{
          	 	 click: this.clearAvgTimeSearchForm
           },
           'averagetimesearchform[itemId=averageTime_quick_search] radiofield[itemId=studentsRadioBtn]':{
        	     focus: this.hideUser
           },
           'averagetimesearchform[itemId=averageTime_quick_search] radiofield[itemId=otherRadioBtn]':{
        	     focus:this.showUser
           },
           'averagetimesearchform[itemId=averageTime_quick_search] combo[itemId=frequency_user_name]':{
           	 focus: this.loadUserNamesCombo
           },
           'averagetimesearchform combo[itemId=frequency_user_group]':{
        	   change : function(combo,records){
        		   var searchviewForm = this.getAverageTimeSearchForm();
        		   searchviewForm.down("#frequency_user_id").setDisabled(false);
        		   var user = searchviewForm.down("#frequency_user_id");
        		  // var systemUsageCommonSearchForm=this.getSystemusagesearchpanel().down("systemusagecommonsearchform");
        		 //  var systemUsageCommonSearchForm=searchviewForm.down("systemusagecommonsearchform");
        		   var alIds =searchviewForm.getValues().ACADEMY_LOCATION_IDS;
        		   var alIdsids=[];
        		   var academyLocations = null;
        		   user.lastQuery=null;
        		   if(alIds !=undefined && alIds.length > 0){
        			   for(var i in alIds){
        				   if(Ext.isObject(alIds[0])){
        					   alIdsids.push(alIds[i].get("id"));
        				   }else{
        					   alIdsids.push(alIds[i]);
        				   }
        			   }
        			   academyLocations = alIdsids.join();
        		   }
        		   var userGroup=combo.getValue();
        		   if(!isNullOrEmpty(userGroup)){
        			   var store = user.getStore();
        			   store.getProxy().extraParams={
        				   userGroup:userGroup,
        				   id:academyLocations
        			   };
        			   store.load();

        		   } 
        	   }
             },
           
           'systemusagecommonsearchform button[itemId=academylocationclearsearch]':{
        	 	 click: this.academylocationclearsearchForm
         },
            
            /* Daily Usage Functions */
            
            'dailyusagesearchform[itemId=dailyUsage_quick_search] button[itemId=dailyUsageSearchBtn]': {
                click: this.loadClosureReasonChart,
//                render: this.loadClosureReasonChart
            },
            'dailyusagesearchform[itemId=dailyUsage_quick_search]  radio':{
            	 focus: this.hideShowCombo
            },
            'dailyusagesearchform[itemId=dailyUsage_quick_search]  button[itemId=dailyUsageClearSearchBtn]':{
           	 	click: this.clearSearchForm
            },
            'searchresultgrid[itemId=averageTimeGrid]': {
            	render: function(grid) {
  					/*this.gridRenderFunction(grid);
  					this.genericCBGridAccessControlValidation(grid, this.getAVERAGE_TIME_PERMISSIONS());
  					var viewButton = grid.down("#searchResultGridBtnView");
  					viewButton.setVisible(false);*/
  				}
            },
            'averagetimescreen grid[itemId=averageTimeGrid]':{
            	render : function(grid){
 					this.doAccessControlValidation(grid, this.getAVERAGE_TIME_PERMISSIONS());
 					//var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		//viewButton.setVisible(false);
 				}
            },
            //***for ColumnGridFixing***
            'averagetimescreen':{
				afterrender : function(structure){
					//var grid = structure.down('searchresultgrid');
					//this.getCBGridHeaderFreeze(grid,structure);
				}
     		},
            /**** Export button for User Frequency ******/
	        'searchresultgrid[itemId=userFrequencyGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserData(SERVERURL.PDFEXPORT,'pdf',false,'USERFREQUENCY');
	            }
	        },
	        'searchresultgrid[itemId=userFrequencyGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportUserData(SERVERURL.PDFEXPORT,'pdf',true,'USERFREQUENCY');
	            }
	        },
	        'searchresultgrid[itemId=userFrequencyGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserData(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'USERFREQUENCY');
	            }
	        },
	        'searchresultgrid[itemId=userFrequencyGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportUserData(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'USERFREQUENCY');
	            }
	        },
            /**** Export button for User Frequency ******/
	        'searchresultgrid[itemId=moduleUserDetailsGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserData(SERVERURL.PDFEXPORT,'pdf',false,'USERFREQUENCYUSERS');
	            }
	        },
	        'searchresultgrid[itemId=moduleUserDetailsGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportUserData(SERVERURL.PDFEXPORT,'pdf',true,'USERFREQUENCYUSERS');
	            }
	        },
	        'searchresultgrid[itemId=moduleUserDetailsGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserData(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'USERFREQUENCYUSERS');
	            }
	        },
	        'searchresultgrid[itemId=moduleUserDetailsGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportUserData(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'USERFREQUENCYUSERS');
	            }
	        },
	        /**** Export button for Average Time ******/
	        'searchresultgrid[itemId=averageTimeGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserData(SERVERURL.PDFEXPORT,'pdf',false,'AVERAGETIME');
	            }
	        },
	        'searchresultgrid[itemId=averageTimeGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportUserData(SERVERURL.PDFEXPORT,'pdf',true,'AVERAGETIME');
	            }
	        },
	        'searchresultgrid[itemId=averageTimeGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportUserData(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'AVERAGETIME');
	            }
	        },
	        'searchresultgrid[itemId=averageTimeGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportUserData(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'AVERAGETIME');
	            }
	        },
	        'userfrequencysearchform[itemId=userFrequency_quick_search] combo[itemId=portalItemId]':{
	        	render: function(combo) {
	            var searchForm = this.getUserfrequencysearchform();
	            var store = searchForm.down('#portalItemId').getStore();
	            
	        },
	        select: function() {
	            var searchForm = this.getUserfrequencysearchform();
	            var moduleCombo = searchForm.down('#basic_Modules');
	            var subModule = searchForm.down('#basic_MenuOptions');
	            var moduleStore = moduleCombo.getStore();
	            var portalId = searchForm.down('#portalItemId').getValue();
	            moduleStore.getProxy().extraParams = {
	                portalId: portalId
	            };
	            subModule.reset();
	            subModule.setDisabled(true);
	            moduleCombo.reset();
	            moduleStore.load();
	            moduleCombo.setDisabled(false);
	        }
	        },
       });
    },
    
    /***
	  * This function is to export pdf and xcel
	  */
    exportUserData : function(exportUrl,filetype,whetherAll,requestType) {
			var quickSearchForm=null;	
	    	var searchResultGrid= null;
	    	var pagingtoolbaroptions = null;
	    	var reportTitle = null;
	    	if(requestType == 'USERFREQUENCY'){
	    	 quickSearchForm=this.getBasicUserFrequencySearch();
	    	 searchResultGrid = this.getSearchResultGrid();
	    	 pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	         var reportTitle=getCommonTranslation('USER_FREQUENCY');
	    	}
	    	if(requestType == 'USERFREQUENCYUSERS'){
		    	 quickSearchForm=this.getBasicUserFrequencySearch();
		    	 searchResultGrid = this.getModuleUserDetailsGrid();
		    	 pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
		         var reportTitle=getCommonTranslation('MODULE_USER_DETAIL');
		    	}
	    	if(requestType == 'AVERAGETIME'){
	    	 //quickSearchForm=this.getAverageTimeSearchForm();
	    	 quickSearchForm=this.getSystemusagesearchpanel();
	    	 searchResultGrid = this.getAverageSearchResultGrid();	
	    	 pagingtoolbaroptions = this.getAverageSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
	         var reportTitle=getCommonTranslation('AVERAGE_TIME');
	    	}
		   	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
		   	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
		   	if(requestType == 'USERFREQUENCYUSERS'){
		   		jsonFormatFormData.viewCode = CONSTANTS.CB.USER_FREQUENCY_USERS_VIEWCODE;
		    }
		   	var visibleColumns=this.getVisibleColumns(searchResultGrid);
				if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
					jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
				searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
			},
			
			createSearchCriteriaString: function(searchForm) {
		   	var me=this;
		       var formValues = new Array();
		       
		       var averageTimeSearchForm=searchForm.down("averagetimesearchform");
		    	var systemUsageCommonSearchForm=searchForm.down("systemusagecommonsearchform");
		    	
		    	if(!isNullOrEmpty(averageTimeSearchForm)&&!isNullOrEmpty(systemUsageCommonSearchForm)){
		    		formValues["FROM_DATE"]=averageTimeSearchForm.getValues().FROM_DATE;
		    		formValues["TO_DATE"]=averageTimeSearchForm.getValues().TO_DATE;
		    		//formValues["studentCode"]=averageTimeSearchForm.getValues().studentCode;
		    		formValues["USER_IDS"]=averageTimeSearchForm.getValues().USER_IDS;
		    		formValues["USER_GROUP_IDS"]=averageTimeSearchForm.getValues().USER_GROUP_IDS;
		    		formValues["ACADEMY_LOCATION_IDS"]=systemUsageCommonSearchForm.getValues().ACADEMY_LOCATION_IDS;
		    	}
		    	else{
		    		 formValues = searchForm.getValues();
		    	}
		             
		       var searchCriteriaString="";
		       for (var key in formValues) {
		       	var value = formValues[key];            
		           if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'&& key!=""){
		               var keyValueJsonObject = me.getJsonObject( key , value);
		               if(!isNullOrEmpty(averageTimeSearchForm)&&!isNullOrEmpty(systemUsageCommonSearchForm)){
				   	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+value + " ,";
  
		               }
		               else{
		   	               searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
		               }
		               }
		       }
		       searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
		       return searchCriteriaString;
		   },
		   
		   gridRenderFunction:function(grid){
				grid.addButtonToolbar();
		   },
   
		   loadActiveGrid : function(button, jsonFormatFormData) {
			   var tabPanel = button.up('userfrequencyscreen').down('tabpanel');
			   var filter = this.getUserfrequencysearchform();
			   var portalCombo = filter.down('#portalItemId');
		        var moduleCombo = filter.down('#basic_Modules');
		        var portalId = portalCombo.getValue();
		        var moduleId = moduleCombo.getValue();
			   var activeTab= tabPanel.getActiveTab();
			   if(activeTab.itemId=='userFrequencyGrid'){
				   this.loadUserFrequencySearchResultGrid();
			   }else   if(activeTab.itemId=='moduleUserDetailsGrid'){
				   this.loadModuleUserDetailsGrid(activeTab);
			   }
		   },
	   /**
	    * THis is used to load User Frequency search result grid 
	    * @param grid
	    * @param jsonFormatFormData
	    */
	   loadModuleUserDetailsGrid: function(grid, jsonFormatFormData) {
			if(!jsonFormatFormData){
				  	var searchviewForm = this.getBasicUserFrequencySearch();
			        jsonFormatFormData = this.createJsonFormat(searchviewForm);
			}
	        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	        jsonFormatFormData.viewCode =CONSTANTS.CB.USER_FREQUENCY_USERS_VIEWCODE;
	        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.USER_FREQUENCY_USERS_VIEWCODE);
	    
	        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        grid.initialize(SERVERURL.USERQUICKSEARCH,resultViewUrl, jsonFormatFormData);
	    	Ext.getBody().unmask();
	    },
/**
     * THis is used to load User Frequency search result grid 
     * @param model
     * @param records
     */
    loadUserFrequencySearchResultGrid: function(model, records) {
        var searchviewForm = this.getBasicUserFrequencySearch();
        var jsonFormatFormData = this.createJsonFormat(searchviewForm, records);
        var searchResultGrid = this.getSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.USER_FREQUENCY_VIEWCODE);
        jsonFormatFormData.viewCode = "SYSTEM_USAGE_USER_FREQUENCY";
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      
    	searchResultGrid.initialize(SERVERURL.USERQUICKSEARCH,resultViewUrl, jsonFormatFormData);
    	  Ext.getBody().unmask();
    },

    /**
     * THis is used to load Average Time search result grid 
     * @param model
     * @param records
     * @return request according to search criteria
     */
 /*   loadAverageTimeSearchResultGrid: function(model, records) {
       // var searchviewForm = this.getAverageTimeSearchForm();
    	var searchviewForm=this.getSystemusagesearchpanel();
        var jsonFormatFormData = this.createJsonFormat(searchviewForm, records);
        var searchResultGrid = this.getAverageSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.AVERAGE_TIME_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
    },*/
    loadAverageTimeSearchResultGrid: function() {

    	var searchviewForm=this.getSystemusagesearchpanel();
    	var grid = this.getSystemusagegrid();
    	var averageTimeSearchForm=searchviewForm.down("averagetimesearchform");
    	var systemUsageCommonSearchForm=searchviewForm.down("systemusagecommonsearchform");
    	var store = grid.getStore();
    	var alIds =averageTimeSearchForm.getValues().ACADEMY_LOCATION_IDS;
    	var alIdsids=[];
    	var academyLocations = null;
    	if(alIds !=undefined && alIds.length > 0){
    		for(var i in alIds){
    			if(Ext.isObject(alIds[0])){
    				alIdsids.push(alIds[i].get("id"));
    			}else{
    				alIdsids.push(alIds[i]);
    			}
    		}
    		academyLocations = alIdsids.join();
    	}

    	store.getProxy().extraParams = {
    		fromDate:averageTimeSearchForm.getValues().FROM_DATE,
    		toDate:averageTimeSearchForm.getValues().TO_DATE,
    		user:averageTimeSearchForm.getValues().USER_IDS,
    		userGroup:averageTimeSearchForm.getValues().USER_GROUP_IDS,
    		academyLocationIds:academyLocations
    	};
    	this.resetPageSetting(store);
    	store.removeAll();
    	store.load();
    }
    ,
    /**
     * THis is used to load Daily Usage search result grid 
     * @param model
     * @param records
     * @return request according to search criteria
     */
    loadDailyUsageSearchResultGrid: function(model, records) {
        var searchviewForm = this.getDailyUsageSearchForm();
        var jsonFormatFormData = this.createJsonFormat(searchviewForm, records);
        var searchResultGrid = this.getDailySearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.SYSTEM_DAILY_USAGE_VIEWCODE);
        searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },
    
    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(searchviewForm) {
    	var averageTimeSearchForm=searchviewForm.down("averagetimesearchform");
    	var systemUsageCommonSearchForm=searchviewForm.down("systemusagecommonsearchform");
    	var formValues = new Array();
    	if(!isNullOrEmpty(averageTimeSearchForm)&&!isNullOrEmpty(systemUsageCommonSearchForm)){
    		formValues["FROM_DATE"]=averageTimeSearchForm.getValues().FROM_DATE;
    		formValues["TO_DATE"]=averageTimeSearchForm.getValues().TO_DATE;
    	//	formValues["studentCode"]=averageTimeSearchForm.getValues().studentCode;
    		formValues["USER_IDS"]=averageTimeSearchForm.getValues().USER_IDS;
    		formValues["USER_GROUP_IDS"]=averageTimeSearchForm.getValues().USER_GROUP_IDS;
    		formValues["ACADEMY_LOCATION_IDS"]=systemUsageCommonSearchForm.getValues().ACADEMY_LOCATION_IDS;
    	}
    	else{
    		 formValues = searchviewForm.getValues();
    	}
      
        var values = new Object();
        var searchcriteria = new Array();

        if(searchviewForm.itemId === 'userFrequency_quick_search'){
        	 values.configCode = this.getConfigCode(searchviewForm.itemId);
             values.viewCode = this.getConfigCode(searchviewForm.itemId);
        }else{
        	 values.configCode = this.getConfigCode(searchviewForm.itemId);
        }

      //  formValues = searchviewForm.getValues();

      /*  var from_date = formValues.FROM_DATE + ' 00:00:00';
		var to_date = formValues.TO_DATE + ' 23:59:59';
        var ACCESS_TIME_BETWEEN = this.getJsonObject('ACCESS_TIME_BETWEEN', from_date, to_date);
        this.pushJsonObjectInArray(ACCESS_TIME_BETWEEN, searchcriteria);
        */
        
        if(formValues.FROM_DATE){
        	  var from_date = formValues.FROM_DATE + ' 00:00:01';
              var ACCESS_TIME_START_DATE = this.getJsonObject('ACCESS_TIME_START_DATE', from_date); 
              this.pushJsonObjectInArray(ACCESS_TIME_START_DATE, searchcriteria);
        }
        
        if(formValues.TO_DATE){
			var to_date = formValues.TO_DATE + ' 23:59:59';
	        var ACCESS_TIME_END_DATE = this.getJsonObject('ACCESS_TIME_END_DATE', to_date);
	        this.pushJsonObjectInArray(ACCESS_TIME_END_DATE, searchcriteria);
        }
        
    /*    if(!isNullOrEmpty(averageTimeSearchForm)&&!isNullOrEmpty(systemUsageCommonSearchForm)&&formValues.studentCode !="" && formValues.studentCode !=null){
			var studentCode = formValues.studentCode;
	        var USER_IDS = this.getJsonObject('USER_IDS', studentCode);
	        this.pushJsonObjectInArray(USER_IDS, searchcriteria);
        }*/
        
    	if(!isNullOrEmpty(averageTimeSearchForm)&&!isNullOrEmpty(systemUsageCommonSearchForm)&&formValues.USER_IDS !="" && formValues.USER_IDS !=null){
    		multiUserArrayData=[];
    		/*for(var i in formValues.USER_IDS){
				if(Ext.isObject(formValues.USER_IDS[0])){
					userData = formValues.USER_IDS[i].get("id");
					multiUserArrayData.push(userData);
				}else{
					userData = formValues.USER_IDS[i];
					multiUserArrayData.push(userData);
				}
			}*/
    		multiUserArrayData.push(formValues.USER_IDS);
			var USER_IDS = this.getJsonObject('USER_IDS', multiUserArrayData,null, true);
            this.pushJsonObjectInArray(USER_IDS, searchcriteria);
		}
    	
    	
    	
		if(!isNullOrEmpty(averageTimeSearchForm)&&!isNullOrEmpty(systemUsageCommonSearchForm)&&formValues.USER_GROUP_IDS !="" && formValues.USER_GROUP_IDS !=null){
			var multiUserGrpArrayData=[];
			//for(var i in formValues.USER_GROUP_IDS){
				/*if(Ext.isObject(formValues.USER_GROUP_IDS[0])){
					userGrpData = formValues.USER_GROUP_IDS[i].get("id");
					multiUserGrpArrayData.push(userGrpData);
				}else{
					userGrpData = formValues.USER_GROUP_IDS[i];
					multiUserGrpArrayData.push(userGrpData);
				}*/
				multiUserGrpArrayData.push(formValues.USER_GROUP_IDS);
			//}
			var USER_GROUP_IDS = this.getJsonObject('USER_GROUP_IDS', multiUserGrpArrayData,null,true);
            this.pushJsonObjectInArray(USER_GROUP_IDS, searchcriteria);
		}
    	
    	
        var alData;
		var multiAlArrayData=[];
		if(formValues.ACADEMY_LOCATION_IDS !="" && formValues.ACADEMY_LOCATION_IDS !=null){
			for(var i in formValues.ACADEMY_LOCATION_IDS){
				if(Ext.isObject(formValues.ACADEMY_LOCATION_IDS[0])){
					alData = formValues.ACADEMY_LOCATION_IDS[i].get("id");
					multiAlArrayData.push(alData);
				}else{
					alData = formValues.ACADEMY_LOCATION_IDS[i];
					multiAlArrayData.push(alData);
				}
			}
		}	
        
        var ACADEMY_LOCATION_IDS	= this.getJsonObject('ACADEMY_LOCATION_IDS', multiAlArrayData,null,'extraParam');
        this.pushJsonObjectInArray(ACADEMY_LOCATION_IDS, searchcriteria);
       
        if(searchviewForm.itemId === 'userFrequency_quick_search'){
        	
        	 var modulData;
 			var multiModulDataArrayData=[];
 			if(formValues.SYSTEM_MODULES !="" && formValues.SYSTEM_MODULES !=null){
 				for(var i in formValues.SYSTEM_MODULES){
 					if(Ext.isObject(formValues.SYSTEM_MODULES[0])){
 						modulData = formValues.SYSTEM_MODULES[i].get("id");
 						multiModulDataArrayData.push(modulData);
 					}else{
 						modulData = formValues.SYSTEM_MODULES[i];
 						multiModulDataArrayData.push(modulData);
 					}
 				}
 			}	
        	
	        var SYSTEM_MODULES= this.getJsonObject('SYSTEM_MODULES', multiModulDataArrayData.join());
	        this.pushJsonObjectInArray(SYSTEM_MODULES, searchcriteria);
	
	        var SYSTEM_SUB_MODULES= this.getJsonObject('SYSTEM_SUB_MODULES', formValues.SYSTEM_SUB_MODULES);
	        this.pushJsonObjectInArray(SYSTEM_SUB_MODULES, searchcriteria);
	
	        
	       var userData;
			var multiUserArrayData=[];
			if(formValues.USER_IDS !="" && formValues.USER_IDS !=null){
				for(var i in formValues.USER_IDS){
					if(Ext.isObject(formValues.USER_IDS[0])){
						userData = formValues.USER_IDS[i].get("id");
						multiUserArrayData.push(userData);
					}else{
						userData = formValues.USER_IDS[i];
						multiUserArrayData.push(userData);
					}
				}
			}	
			
			var userGrpData;
			var multiUserGrpArrayData=[];
			if(formValues.USER_GROUP_IDS !="" && formValues.USER_GROUP_IDS !=null){
				for(var i in formValues.USER_GROUP_IDS){
					if(Ext.isObject(formValues.USER_GROUP_IDS[0])){
						userGrpData = formValues.USER_GROUP_IDS[i].get("id");
						multiUserGrpArrayData.push(userGrpData);
					}else{
						userGrpData = formValues.USER_GROUP_IDS[i];
						multiUserGrpArrayData.push(userGrpData);
					}
				}
			}	
	        
			
			
//	        var USER_IDS = this.getJsonObject('USER_IDS', multiUserArrayData,null,'extraParam');
//            this.pushJsonObjectInArray(USER_IDS, searchcriteria);
	        
	        var radioValue = searchviewForm.getForm().getValues()['usrRadio'];
//	        this.getParamCode(radioValue,formValues,searchcriteria);

        	
        	if(radioValue === 'individual'){
            	
            	var USER_IDS = this.getJsonObject('USER_IDS', multiUserArrayData,null, true);
                this.pushJsonObjectInArray(USER_IDS, searchcriteria);
                
            }else if(radioValue === 'userGroups'){
            	
            	var USER_GROUP_IDS = this.getJsonObject('USER_GROUP_IDS', multiUserGrpArrayData,null,true);
                this.pushJsonObjectInArray(USER_GROUP_IDS, searchcriteria);
            }
        
        }else if(searchviewForm.itemId === 'dailyUsage_quick_search'){
        	
        	var radioValue = searchviewForm.getForm().getValues()['usrRadio'];
        	if(radioValue === 'individual'){
        		
        		  var userData;
        			var multiUserArrayData=[];
        			if(formValues.USER_IDS !="" && formValues.USER_IDS !=null){
        				for(var i in formValues.USER_IDS){
        					if(Ext.isObject(formValues.USER_IDS[0])){
        						userData = formValues.USER_IDS[i].get("id");
        						multiUserArrayData.push(userData);
        					}else{
        						userData = formValues.USER_IDS[i];
        						multiUserArrayData.push(userData);
        					}
        				}
        			}	
        			
        		var USER_IDS = this.getJsonObject('USER_IDS', multiUserArrayData,null,true);
                this.pushJsonObjectInArray(USER_IDS, searchcriteria);
                
                var USER_NAMES = this.getJsonObject('USER_NAMES', formValues.USER_NAMES);
                this.pushJsonObjectInArray(USER_NAMES, searchcriteria);
                
        	}else if(radioValue === 'userGroups'){
        		
        		var USER_GROUP_IDS = this.getJsonObject('USER_GROUP_IDS', formValues.USER_GROUP_IDS,null,'extraParam');
                this.pushJsonObjectInArray(USER_GROUP_IDS, searchcriteria);
        	}
        }else if(searchviewForm.itemId === 'averageTime_quick_search'){
        	
        	var studRadioValue = searchviewForm.getForm().getValues()['student'];
        	if(studRadioValue === 'Student'){
        		
        		var USER_GROUP_NAME = this.getJsonObject('USER_GROUP_NAME','Student');
                this.pushJsonObjectInArray(USER_GROUP_NAME, searchcriteria);
                
        	}else if (studRadioValue === 'Others'){
        		var radioValue = searchviewForm.getForm().getValues()['userRadio'];
    	        this.getParamCode(radioValue,formValues,searchcriteria);
        	}
        }
        
        values.searchCriterias = searchcriteria;
        return values;
    },

    getJsonObject: function(key, value,additionalValue, extraParam) {
    	if(extraParam){
    		 if (value && value != '' && additionalValue == undefined) {
    	            return {
    	                "paramCode": key,
    	                "paramValues": value
    	            };
    	        }
    	}
    	else if (value && value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value && value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    /**
     * This method is used to set config code according to search form 
     * @param searchform.xtype
     * @return config code
     */
    getConfigCode: function(searchForm){
    	
    	 var code ;
    	 switch(searchForm){
         case 'userFrequency_quick_search' :{
        	 code = CONSTANTS.CB.USER_FREQUENCY_BASIC_CONFIGCODE;
        	 return code;
        	 break;
         }
       /*  case 'averageTime_quick_search' :{
        	 code = CONSTANTS.CB.AVERAGE_TIME_BASIC_CONFIGCODE;
        	 return code;
        	 break;
         }*/
         case 'systemusagesearchpanel' :{
        	 code = CONSTANTS.CB.AVERAGE_TIME_BASIC_CONFIGCODE;
        	 return code;
        	 break;
         }
         case 'dailyUsage_quick_search' :{
        	 code = CONSTANTS.CB.SYSTEM_DAILY_USAGE_BASIC_CONFIGCODE;
        	 return code;
        	 break;
         }
         }
    },
    
    /**
     * This is used to get Param Code of radio button panel
     * @param radioValue
     * @param formValues
     * @param searchcriteria
     * @return return Param code of radio panel
     */
    getParamCode : function(radioValue,formValues,searchcriteria){
    	
    	if(radioValue === 'individual'){
        	
    	var userIds = new Array();
    	var userNames = new Array();
    	if(formValues.USER_IDS!=''){
    	
//			Ext.each( formValues.USER_IDS, function(value) {
//				userIds.push(value.data.id);	
//		});
    	}
    	if(formValues.USER_NAMES!=''){
		
//			Ext.each( formValues.USER_NAMES, function(value) {
//				userNames.push(value.data.id);	
//		});
    	}
    	
    	var userIdData;
		var multiUserIdArrayData=[];
		if(formValues.USER_IDS !="" && formValues.USER_IDS !=null){
			for(var i in formValues.USER_IDS){
				if(Ext.isObject(formValues.USER_IDS[0])){
					userIdData = formValues.USER_IDS[i].get("id");
					multiUserIdArrayData.push(userIdData);
				}else{
					userIdData = formValues.USER_IDS[i];
					multiUserIdArrayData.push(userIdData);
				}
			}
		}
        	var USER_IDS = this.getJsonObject('USER_IDS', multiUserIdArrayData,null, true);
            this.pushJsonObjectInArray(USER_IDS, searchcriteria);
        
            var userNameData;
    		var multiUserNameArrayData=[];
    		if(formValues.USER_NAMES !="" && formValues.USER_NAMES !=null){
    			for(var i in formValues.USER_NAMES){
    				if(Ext.isObject(formValues.USER_NAMES[0])){
    					userNameData = formValues.USER_NAMES[i].get("id");
    					multiUserNameArrayData.push(userNameData);
    				}else{
    					userNameData = formValues.USER_NAMES[i];
    					multiUserNameArrayData.push(userNameData);
    				}
    			}
    		}   
         
            var USER_NAMES = this.getJsonObject('USER_NAMES', multiUserNameArrayData,null,true);
            this.pushJsonObjectInArray(USER_NAMES, searchcriteria);
        	
        }else if(radioValue === 'userGroups'){
        	
        	var userGroupIds = new Array();
        	if(formValues.USER_GROUP_IDS != ''){
        		
//    			Ext.each( formValues.USER_GROUP_IDS, function(value) {
//    				userGroupIds.push(value.data.id);	
//    			});
        	}
        	
        	var USER_GROUP_IDS = this.getJsonObject('USER_GROUP_IDS', formValues.USER_GROUP_IDS,null,true);
            this.pushJsonObjectInArray(USER_GROUP_IDS, searchcriteria);
        }
    },
    
    /**
     * This method is used to hide /show combo on select of User Types
     * @param cmp reference of component
     */
    hideShowCombo : function(cmp){
    	
    	var form = cmp.up('form');
    	var comboField = form.down('#userTypeIndividualFieldContainer');
    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var userIdCmb = comboField.down('#frequency_user_id');
    	var userNameCmb = comboField.down('#frequency_user_name');
        var userGroup = form.down('#frequency_user_group');
    	
    	if(cmp.itemId === 'individualRadioBtn'){
    		comboField.setDisabled(false);
    		comboField.setVisible(true);
    		userGroupCmb.setDisabled(true);
    		userGroupCmb.setVisible(false);
    		userIdCmb.setVisible(true);
    		userIdCmb.setDisabled(false);
    		//userNameCmb.setVisible(true);
    		//userNameCmb.setDisabled(false);
    		userGroup.reset();
    		
    		
    	}else if(cmp.itemId === 'userGroupRadioBtn'){
    		
    		userGroupCmb.setDisabled(false);
    		userGroupCmb.setVisible(true);
    		comboField.setDisabled(true);
    		comboField.setVisible(false);
    		userGroup.setVisible(true);
    		userGroup.setDisabled(false);
    		userIdCmb.reset();
//    		userNameCmb.reset();
    		
    	}else if(cmp.itemId === 'allRadioBtn'){
    		
    		userGroupCmb.setDisabled(false);
    		userGroupCmb.setVisible(false);
    		comboField.setDisabled(false);
    		comboField.setVisible(false);
    		userIdCmb.reset();
//    		userNameCmb.reset();
    		userGroup.reset();
    	}
    },
    hideShowUserType:function(obj){
    	var form = obj.up('form');
    	console.log('form',form);
//    	var comboField = form.down('#userTypeIndividualFieldContainer');
//    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var idividualUser = form.down('#frequency_user_id');
    	console.log('idividualUser',idividualUser);
//    	var userNameCmb = userGroupCmb.down('#frequency_user_name');
        var userGroup = form.down('#frequency_user_group1');
        console.log('userGroup',userGroup);
        
    	
    	if(obj.itemId === 'individualRadioBtn'){
    		
    		idividualUser.setVisible(true);
    		userGroup.setVisible(false);
    		
    	}else {
    		
    		idividualUser.setVisible(false);
    		userGroup.setVisible(true);
    		
    	}
    
    },
    /**
     * This is used to hide all panel on select of 'all' radio button
     *  @param cmp reference of component
     */
    hideAllCombo : function(cmp){
    	
    	var form = cmp.up('form');
    	var comboField = form.down('#userTypeIndividualFieldContainer');
    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var userIdCmb = comboField.down('#frequency_user_id');
    	var userNameCmb = comboField.down('#frequency_user_name');
        var userGroup = userGroupCmb.down('#frequency_user_group');
        
    	userGroupCmb.setDisabled(false);
		userGroupCmb.setVisible(false);
		comboField.setDisabled(false);
		comboField.setVisible(false);
		
		userIdCmb.clearValue();
		userNameCmb.clearValue();
		userGroup.clearValue();
    },
    
    /**
     * THis is used to show individual panel on select of 'individual' radio button
     * @param cmp reference of component
     */
    hideCombo : function(cmp){
    	
    	var form = cmp.up('form');
    	var comboField = form.down('#userTypeIndividualFieldContainer');
    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var userIdCmb = comboField.down('#frequency_user_id');
    	//var userNameCmb = comboField.down('#frequency_user_name');
        var userGroup = userGroupCmb.down('#frequency_user_group');
    	comboField.setDisabled(false);
		comboField.setVisible(true);
		userGroupCmb.setDisabled(true);
		userGroupCmb.setVisible(false);
		userIdCmb.setVisible(true);
		userIdCmb.setDisabled(false);
		//userNameCmb.setVisible(true);
		//userNameCmb.setDisabled(false);
		userIdCmb.clearValue();
		//userNameCmb.clearValue();
		userGroup.clearValue();
    },
    
    /**
     * THis is used to show other panel on select of 'other' radio button
     * @param cmp reference of component
     */
    showCombo : function(cmp){
    	var form = cmp.up('form');
    	var comboField = form.down('#userTypeIndividualFieldContainer');
    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var userIdCmb = comboField.down('#frequency_user_id');
    	var userNameCmb = comboField.down('#frequency_user_name');
        var userGroup = userGroupCmb.down('#frequency_user_group');
    	userGroupCmb.setDisabled(false);
		userGroupCmb.setVisible(true);
		comboField.setDisabled(true);
		comboField.setVisible(false);
		userGroup.setDisabled(false);
		userGroup.setVisible(true);
		userIdCmb.clearValue();
		//userNameCmb.clearValue();
		userGroup.clearValue();
    },
    /**
     * This method is used to clear fields on User Frequency search Form
     * @param button which is reference of buttton
     */
    clearSearchForm : function(button){
    	form = button.up('form').getForm();
 	    form.getFields().each(function(field) {
       		field.reset();	
       		if(field.itemId == 'frequency_user_id' || field.itemId == 'frequency_user_name' || field.itemId=='frequency_user_group'){
        		field.setVisible(false);
        		field.container.setVisible(true);
       		}
       		if(button.up('form').itemId == 'dailyUsage_quick_search'){
       			button.up('form').up('panel').down('#tabpanelId').setVisible(false);
       		}
       		if(field.itemId == 'basic_Modules'){
       			field.setDisabled(true);
       		}
        });
 	    
    },
    
    /**
     * This method is used to clear fields on Avg time search form
     * @param button which is reference of buttton
     */
    clearAvgTimeSearchForm : function(button){
 	   
        form = button.up('form').getForm();
 	    form.getFields().each(function(field) {
       		field.reset();	
       		if(field.itemId == 'frequency_user_id' ){
        		field.setDisabled(true);
        		field.lastQuery=null;
       		}
       		
        });
 	    
    },
    academylocationclearsearchForm: function(button){
    	 var searchviewForm = this.getAverageTimeSearchForm();
    	 searchviewForm.down("#averageTimeSearchBtn").setDisabled(true);
        form = button.up('form').getForm();
 	    form.getFields().each(function(field) {
       		field.reset();	
      
        });
 	    
    },
    
    /**
     * THis method is used to hide user type combo in average Time Search form
     * @param cmp reference of component
     */
    hideUser : function(cmp){
    	
    	var form = cmp.up('averagetimesearchform');
    	var userTypeCmb = form.down('#radioPanelAverage');
    	var comboField = form.down('#userTypeIndividualFieldContainer');
    	var userGroupCmb = form.down('#userGroupFieldContainer');
    	var studentCmb=form.down('[name=studentCode]');
    	form.down('#otherRadioBtn').reset();
    	studentCmb.setVisible(true);
    	userTypeCmb.setDisabled(true);
		userTypeCmb.setVisible(false);
		comboField.setDisabled(true);
		comboField.setVisible(false);
		userGroupCmb.setDisabled(true);
		userGroupCmb.setVisible(false);
		userTypeCmb.down("#individualRadioBtn").reset();
		userTypeCmb.down("#userGroupRadioBtn").reset();
		studentCmb.reset();
    },
    
    /**
     * THis method is used to show user type combo in average Time Search form
     *  @param cmp reference of component
     */
    showUser : function(cmp){
    	
    	var form = cmp.up('averagetimesearchform');
    	var userTypeCmb = form.down('#radioPanelAverage');
        var studentCmb=form.down('[name=studentCode]');
    	form.down("#studentsRadioBtn").reset();
    	studentCmb.setVisible(false);
    	//studentCmb.reset();
    	userTypeCmb.setDisabled(false);
		userTypeCmb.setVisible(true);
    },
    
    /**
     * This is used to hide menu options on select of modules combo
     *  @param ref reference of component
     */
    hideMenu : function(ref){
    	
    	var menuCmb = ref.up('form').down('#basic_MenuOptions');
    	if(ref.value === 'ALL'){
    		menuCmb.setDisabled(true);
    	}else{
    		menuCmb.setDisabled(false);
    	}
    },
    
    /**
     * THis is used to load year combo afer render
     * @param combo reference
     */
    loadData : function(cmb){
    	
    	var records= new Array ();
    	for(var num = 1920 ;num <= 2050;num++){
    		records.push({
                value: num,
                id : num.toString()
            });
    	}
    	var store = cmb.getStore();
    	store.loadData(records);
    },
    
    /**
     * THis is used  to load sub module combo on select Of Module Combo
     * @param combo reference
     */
    loadCombo : function(cmb){
    	var  form = cmb.up('form');
    	var subModuleCmb = form.down('#basic_MenuOptions');
    	var store = subModuleCmb.getStore();
    	var comboVal = cmb.getValue();
    	
    	var val =[];
    	var cmbValus;
		
		if(comboVal !="" && comboVal !=null){
			for(var i in comboVal){
				if(Ext.isObject(comboVal[0])){
					cmbValus = comboVal[i].get("id");
					val.push(cmbValus);
				}else{
					cmbValus = comboVal[i];
					val.push(cmbValus);
				}
			}
		}	
		
		if(val.length == 1){
			subModuleCmb.setDisabled(false);
			store.getProxy().extraParams = {
				moduleId :val.join()
			};
			store.load();
		}else{
			subModuleCmb.setDisabled(true);
		}
		subModuleCmb.reset();
    },
    
    addColumListener:function(chart){
    	var this$ = this;
    	this.initializedEvents=true;
    	   chart.series.items[0].listeners={
               	itemclick: function(item) {
                    this$.barClickUserFrequencyModule(this,item);
                   }
               };
    },
    
    barClickUserFrequencyModule:function(this$,item){
    	var menuId= item.storeItem.get('ID'), displayCode= item.storeItem.get('MODULE_NAME'),jsonFormatFormData = new Object(), 
    	searchCriteria = new Array(),resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL,tabPanel=this$.chart.up('tabpanel');
//    	var tab= this.openTab(displayCode+' : '+getCommonTranslation('USERS_DETAIL'),'userfrequencyusers','',this$.chart.up('tabpanel'));
//        var searchResultGrid = tab.down('#userDetailsGrid');
        
        var MENU_ID = this.getJsonObject('MENU_ID', menuId);
        this.pushJsonObjectInArray(MENU_ID, searchCriteria);
        jsonFormatFormData.searchCriterias=searchCriteria;
        jsonFormatFormData.configCode = "SYSTEM_USAGE_USER_FREQUENCY";
        jsonFormatFormData.viewCode =CONSTANTS.CB.USER_FREQUENCY_USERS_VIEWCODE;
        
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        
    	tabPanel.setActiveTab(1);
    	var userGrid= tabPanel.down('searchresultgrid#moduleUserDetailsGrid');
//    	var userGrid= tabPanel.down('searchresultgrid#moduleUserDetailsGrid');
    	this.loadModuleUserDetailsGrid(userGrid, jsonFormatFormData);
//    	searchResultGrid.initialize(SERVERURL.USERQUICKSEARCH,resultViewUrl, jsonFormatFormData);
    	Ext.getBody().unmask();
    },
    cellClickUserFrequencyGrid:function(grid, td, cellIndex, record){
        var searchResultGrid = grid.up(),this$=this;
        var columnName = searchResultGrid.columnManager.columns[cellIndex].dataIndex;
        // var column=searchResultGrid.columnManager.columns;
        var id = record.get('ID'), tabPanel=grid.up('tabpanel');
        var SYSTEM_MODULES = this.getJsonObject('SYSTEM_MODULES',id);
        var searchviewForm = this.getBasicUserFrequencySearch();
        var jsonFormatFormData = this.createJsonFormat(searchviewForm);
        jsonFormatFormData =this$.getBasicSearchDto(jsonFormatFormData);
        this.pushJsonObjectInArray(SYSTEM_MODULES, jsonFormatFormData.searchCriterias);
        
        if (columnName == "MODULE_NAME") { // 
            var tab= this$.openTab(getCommonTranslation('SUB_MODULE_USER_FREQUENCEY'),'systemusesmoduleview','',tabPanel);
           
           var store = tab.down('#countOfModuleUsesChart').getStore();
           var resultViewUrl = SERVERURL.USERQUICKSEARCH;
           Ext.Ajax.request({
               type: 'rest',
               url: resultViewUrl+'?page=-1&limit=-1',
               method: 'POST',
               headers: {
                   'Content-Type': 'application/json'
               },
               jsonData: jsonFormatFormData,
               success: function(response) {
                data = Ext.decode(response.responseText);
                for(var i = 0 ;i < data.rows.length ;i++){
                	data.rows[i].MODULE_NAME = getMegaMenuTranslation(data.rows[i].MODULE_NAME)
                }
                 store.loadData(data.rows);
               }
           });
        }else if(columnName == "NO_OF_USERS"){
        	tabPanel.setActiveTab(1);
        	var userGrid= tabPanel.down('searchresultgrid#moduleUserDetailsGrid');
        	this.loadModuleUserDetailsGrid(userGrid, jsonFormatFormData);
        }
    },
    
    getBasicSearchDto : function(basicSearchDTO){
//    	var basicSearchDTO= new Object();
    	basicSearchDTO.configCode=CONSTANTS.CB.USER_FREQUENCY_BASIC_CONFIGCODE;
    	basicSearchDTO.viewCode = 'SYSTEM_USAGE_MODULE_USER_LIST';
//    	basicSearchDTO.searchCriterias=searchCriterias;
    	return basicSearchDTO;
    },
    
    loadClosureReasonChart : function(){
    	var dailyUsageView = this.getDailyusagescreen();
    	var searchviewForm = this.getDailyUsageSearchForm();
        var jsonFormatFormData = this.createJsonFormat(searchviewForm);
        var dailyUsageChart = this.getDailyUsageChart();
        var resultViewUrl = SERVERURL.USERQUICKSEARCH;
       /* var jsonFormData = {
                      //configCode: CONSTANTS.CB.SYSTEM_DAILY_USAGE_VIEWCODE,
                            searchCriterias: 
        };*/
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
         Ext.Ajax.request({
             type: 'rest',
             url: resultViewUrl+'?page=-1&limit=-1',
             method: 'POST',
             headers: {
                 'Content-Type': 'application/json'
             },
             jsonData: jsonFormatFormData,
             success: function(response) {
               data = Ext.decode(response.responseText);
	   			Ext.each(data.rows, function(record) {
	       			 var time = minuteToHour(record.SYSTEM_USAGE_IN_MINUTES);
		 			 record.value = time;         			  			 	        			 
		 		 });
		   		 Ext.getBody().unmask();
		   		 var tabPanel = dailyUsageView.down('#tabpanelId');
	             dailyUsageChart.getStore().loadData(data.rows);
	             dailyUsageView.down('#tabpanelId').setVisible(true);
	             tabPanel.setActiveTab(tabPanel.items.items[0]);
//	             tabPanel.items.items[1].setDisabled(true);
             }
         });
     },
     
     /**
      * This is used to load user name combo on select of user code
      */
     loadUserNamesCombo : function(combo){
    	 
    	var userIdCombo = combo.up('form').down('#frequency_user_id');
    	var store = combo.getStore();
	 	var value = userIdCombo.getValue();
		var userCodes = new Array();
		if(value){
			Ext.each(value, function(values) {
				if(values instanceof Object){
					userCodes.push(values.get('code'));
				}else{
					userCodes.push(values);
				}
		});
		userCodes =userCodes.toString();
		store.load({
			params: {
				userCodes: userCodes
			}
		});
		}
     },
     dailyUsageRecordGrid:function(day){
    	 var loginFreGrid = this.getLoginFrequencyGrid();
    	 var store = loginFreGrid.getStore();
    	 var dailyUsageScreen = this.getDailyusagescreen();
    	 
    	 var tabPanel = dailyUsageScreen.down('#tabpanelId');
//    	 tabPanel.items.items[1].setDisabled(false);
    	 tabPanel.setActiveTab(tabPanel.items.items[1]);
    	 
    	 
    	 var date;
    	 if(!isNullOrEmpty(day)){
    		date = day.storeItem.data.DAY;    		 
    	 }
//    	 var sentDate = Ext.Date.format(new Date(date), 'Y-m-d');
    	 
    	 var  dt = Ext.Date.parse(date, "d/m/Y");
		 var sentDate = Ext.Date.format(new Date(dt),CONSTANTS.DATE_FORMAT);
    	 
    	 store.getProxy().extraParams = {
    		 fromDate:sentDate,
			  toDate:sentDate
		  };
    	 store.load();
    	 
     }
});
