/**
 * @author sumit.meena
 */
Ext.define('Academia.controller.transport.route.RouteController', {
	extend: 'Academia.controller.base.BaseController',
	//extend: 'Academia.controller.personinfo.common.PersonInfoController',
	models: ['transport.route.LocationName','common.IdValueDataModel','transport.route.NoOfStopsGridData'],
	stores: ['transport.route.RouteMasterStore','transport.vehicle.VehicleNo','transport.route.RouteName',
	         'transport.route.LocationName','transport.route.RouteStops','transport.route.ResponsiblePerson',
	         'examinationcenters.YesNo','examinationcenters.CenterType','transport.route.NoOfStopsGridData',
	         'campaign.UserByAcademyLocation','transport.route.RouteInfoStore','hostel.roomallocation.UserSmartSearchByUserType',
	         'transport.route.RouteUserTypeStore','transport.route.AllLocationName'],
	views: ['transport.route.RouteSearch','transport.route.RouteStructure','transport.route.RouteMasterGrid','transport.route.RouteForm',
	        'transport.route.NoOfStopsGridWin'],
	config:{
				TRANSPORT_ROUTE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_ROUTE_PRIVILEGES')
	       },         
    refs: [{
    	ref : 'contentPanel',
    	selector : 'contentpanel' 
    },{
    	ref : 'routestructure',
    	selector : 'routestructure' 
    },{
    	ref : 'routesearch',
    	selector : 'routesearch' 
    },{
    	ref : 'routemastergrid',
    	selector : 'routemastergrid' 
    },{
    	ref : 'routeform',
    	selector : 'routeform' 
    },{
    	ref : 'noofstopsgridwin',
    	selector : 'noofstopsgridwin' 
    },{
    	ref : 'noofstopsgrid',
    	selector : 'noofstopsgridwin grid' 
    },{
    	ref : 'noofstopswinForm',
    	selector : 'noofstopsgridwin form' 
    }],
    init: function(application) {
    	this.control({
    		'routesearch button[itemId=SearchBtn]':{
    			click : this.loadRouteMasterGridData
    		},
    		'routemastergrid':{
    			render: function(grid){
      				 this.doAccessControlValidation(grid, this.getTRANSPORT_ROUTE_PERMISSION());
      			 },
    			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				var $this=this;
  			  		var windowGrid = grid.ownerCt;
  			  		var columnName=windowGrid.columnManager.columns[cellIndex].dataIndex;
  			  		if(e.target.tagName=="A"){
        			  if(columnName=='noOfStops'){
        				  $this.openNoOfStopsWindow();
        				  var window=$this.getNoofstopsgridwin();
        				  window.setTitle(record.data.routeName);
        				  var gridStore=$this.getNoofstopsgrid().getStore();
        				  gridStore.getProxy().extraParams = {
        					  routeId : record.data.id
        			    	},
        			      gridStore.load();    
        			  }
        		  }
  			  	}
    		},
    		'routesearch button[itemId=cancelBtn]':{
    			click : function(obj){
    				obj.up('form').getForm().reset();
    				obj.up('form').isValid();
    			}
    		},
    		'routesearch combo[itemId=roundTripItemId]':{
    			select : function(obj,rec){
    				/**
    				 * Set End Location of start location on the bases of round trip. 
    				 */
    				this.setEndLocationByStartLocation(obj);
    			}
    		},
    		'routesearch combo[itemId=startLocationItemId]':{
    			select : function(obj,rec){
    				/**
    				 * Set End Location of start location on the bases of round trip. 
    				 */
    				this.setEndLocationByStartLocation(obj);
    			}
    		},
    		'routesearch':{
    			render : function(obj){
    				this.loadDataOnTheBasesOfAcademyLocation(obj);
    				var grid=this.getRoutemastergrid();
    				var masterGridStore=grid.getStore();
    				if(masterGridStore.getCount()>0){
    					masterGridStore.removeAll();
    				}
    			}
    		},
    		'routemastergrid button[itemId=btnAdd]':{
    			click : function(){
    				this.openRouteFormTab();
    			}
    		},
    		'routemastergrid button[itemId=btnEdit]':{
    			click : function(){
    				this.editRouteFromData("edit");
    			}
    		},
    		'routemastergrid button[itemId=btnView]':{
    			click : function(){
    				this.editRouteFromData("view");
    			}
    		},
    		'routemastergrid button[itemId=btnDelete]':{
    			click : function(){
    				this.deleteRouteFromGrid();
    			}
    		},
    	/*	'routeform':{
    			render:function(obj){
    				var routeform=obj.getForm();
    				var routeNameField=routeform.findField('responsiblePerson');
    				var academyLocationId = this.getCurrentAcademyLocation();
        	    	var routeNameStore =routeNameField.getStore();
        	    	routeNameStore.getProxy().extraParams = {
        	        	academyLocationId : academyLocationId
        	    	},
        	    	routeNameStore.load();	
    		    }
    		},*/
    		'routeform customcombobox[itemId=responsiblePersonItemId]':{
    			render : function(combo){
    				combo.getStore().removeAll();
    				this.loadUserComboData(combo);
    			}
    		},
		    'routeform button[itemId=stopBtn]':{
		    	click: function(obj){
				   this.addMultipleStops(obj);
			    }
 		    },
		    'routeform button[itemId=btnSave]':{
		    	click: function(){
					this.saveRouteData();
			    }
 		     },
		    'routeform button[itemId=btnReset]':{
		    	click: function(obj){
		    		obj.up('form').getForm().reset();
			    }
 		     },
    		'routeform numberfield[itemId=endDistanceItemId]':{
    			blur : function(obj){
    				var form=obj.up('form').getForm();
    				var distanceInKmField=form.findField('endDistance');
    				form.findField('distanceInKm').setValue(distanceInKmField.getValue());
    			}
    		},
    		'routeform combo[itemId=startsFromItemId]':{
    			select : function(obj,rec){
    				var data=rec[0].data.id;
    				var form=obj.up('form').getForm();
    				form.findField('startLocation').setValue(data);
    				/**
    			     * Set End Location from start location on bases of round trip in create form.
    			     */
        		   this.setEndLocationByStartLocationInCreateForm(obj);
    			}
    		},
    		'routeform combo[itemId=endsAtItemId]':{
    			select : function(obj,rec){
    				var data=rec[0].data.id;
    				var form=obj.up('form').getForm();
    				form.findField('endLocation').setValue(data);
    			}
    		},
    		'routeform combo[itemId=userTypeItemId]':{
    			select : function(obj,rec){
    				var data=rec[0].data.id;
    				var form=obj.up('form').getForm();
    				var respPerson=form.findField('responsiblePerson');
    				var respPersonExt=form.findField('responsiblePersonExt');
    				
    				respPerson.setVisible(false);
    				respPersonExt.setVisible(false);
    				
    				respPerson.allowBlank=true;
    				respPersonExt.allowBlank=true;
    				
    				respPerson.reset();
    				respPersonExt.reset();
    				
    				if(data==0){
    					respPersonExt.setVisible(true);
    					this.setAllowBlank(respPersonExt,false);
    				}else {
    					respPerson.setVisible(true);
    					this.setAllowBlank(respPerson,false);
    					respPerson.getStore().load();
    				}
    				form.isValid();
					form.clearInvalid();
    			}
    		},
    		'routeform combo[itemId=roundTripItemId]':{
    			select : function(obj,rec){
				/**
			     * Set End Location from start location on bases of round trip in create form.
			     */
    				this.setEndLocationByStartLocationInCreateForm(obj);
    			}
    		},
    		
    		'routestructure':{
	        	afterrender : function(structure){
	        		var container = structure.items.items[0];
	        		var grid = container.down('routemastergrid');
	        	    this.getGridHeaderFreeze(grid,structure,true);
	        	}
    		}
    	  });
       },
	    /**
	     * Open Route Form Tab
	     */
	    openRouteFormTab:function(){
	    	var me = this;
	    	var getcontroller=this.getController('menu.CoreERPNavigationController'),
	    		tabName =getTransportTranslation('ROUTE_DETAIL'),
	    		contentpanel = me.getContentPanel(),
	    		routeFormTab = Ext.widget('routeform'),
	    		getTab=getcontroller.getTab(tabName);
	    		
	    	if(getTab!=null){
	    		contentpanel.remove(getTab, true);
	    	}
	    	openTab(contentpanel, tabName, routeFormTab,CONSTANTS.MENU_COLOR_ELEVEN);
	    },
	    /**
	     * OpenNo Of Stops Window
	     */
	    openNoOfStopsWindow:function(){
	    	var formWindow = this.getNoofstopsgridwin();
			if (!formWindow) {
				Ext.widget('noofstopsgridwin');
				formWindow = this.getNoofstopsgridwin();
			}
			formWindow.show();
	    },
	    /**
	     * Set End Location from start location on bases of round trip.
	     */
	    setEndLocationByStartLocation:function(obj){
	    	var form=obj.up('form').getForm();
			var startLocationField=form.findField('startLocationId');
			var endLocationField=form.findField('endLocationId');
			var roundTripValue=form.findField('roundTripId').getValue();
			if(roundTripValue=="YES"){
				var startLocationValue=startLocationField.getValue();
				if(!isNullOrEmpty(startLocationValue)){
					endLocationField.setValue(startLocationValue);    
				}
			}else if(roundTripValue=="NO"){
				endLocationField.reset();
			}
	    },
	    /**
	     * Set End Location from start location on bases of round trip in create form.
	     */
	    setEndLocationByStartLocationInCreateForm:function(obj){
	    	var form=obj.up('form').getForm();
			var startFromField=form.findField('startsFrom');
			var endAtField=form.findField('endsAt');
			var endLocationField=form.findField('endLocation');
			var roundTripValue=form.findField('roundTrip').getValue();
			if(roundTripValue=="YES"){
				var startFromValue=startFromField.getValue();
				endAtField.setReadOnly(true); 
				if(!isNullOrEmpty(startFromValue)){
					endAtField.setValue(startFromValue); 
					endLocationField.setValue(startFromValue); 
				}
			}else if(roundTripValue=="NO"){
				endAtField.reset();
				endLocationField.reset();
				endAtField.setReadOnly(false); 
			}
	    },
	    /**
	     * Load Master grid
	     */
	    loadRouteMasterGridData:function(){
	    	var $this=this;
	    	var academyLocationId = $this.getCurrentAcademyLocation();
	    	var routeSearchForm=$this.getRoutesearch().getForm();
	    	var getFormValues=routeSearchForm.getValues();
	    	var routeGrid=$this.getRoutemastergrid();
	    	var respPersonName=routeSearchForm.findField('responsiblePersonRoute');
	    	var roundTripValue = routeSearchForm.findField('roundTripId').getValue();
	    	/*var roundTrip=null;
	    	if(!isNullOrEmpty(roundTripValue)){
	    		if(roundTripValue=='Yes'){
		    		roundTrip = true;
		    	}else if(roundTripValue=='No'){
		    		roundTrip = false;
		    	}
	    	}*/
	    	//var responsiblePersonService=routeSearchForm.findField('responsiblePersonService');
	    	//var vehicleName=routeSearchForm.findField('vehicleName');
	    	var routeName=routeSearchForm.findField('routeName');
	    	 
	    	routeGrid.getStore().getProxy().extraParams = {
	    		//vehicleNumber :vehicleName.getRawValue(),
	    		academyLocationId:academyLocationId,
	    		routeName : routeName.getRawValue(),
	    		startLocation : getFormValues.startLocationId,
	    		endLocation : getFormValues.endLocationId,
	    		stops : getFormValues.stop,
	    		routeDistanceGreater : getFormValues.distanceFrom,
	    		routeDistanceSmaller : getFormValues.distanceTo,
	    		roundTrip : roundTripValue,
	    		//serviceResponsiblePerson : responsiblePersonService.getRawValue(),
	    		//serviceFeePlanId : academyLocationId, Integrate later
	    		//periodFromDate : getFormValues.dateFrom,
	    		//periodTillDate : getFormValues.dateTill,
	    		routeResponsiblePerson:respPersonName.getRawValue(),
	    		//route responsible person parameter
	    	},
	    	$this.resetGridSetting(routeGrid);
	    	routeGrid.getStore().load();
	    },
	    /**
	     * Load combo on the bases of academy location id (it is also used in create route also)
	     */
	    loadDataOnTheBasesOfAcademyLocation:function(obj){
	    	var $this=this;
	    	var academyLocationId = $this.getCurrentAcademyLocation();
	    	var routeSearchForm=obj.getForm();
	    	
	    /*	var vehicleNameField=routeSearchForm.findField('vehicleName');
	    	var vehicleNameStore =vehicleNameField.getStore();
	    	vehicleNameStore.getProxy().extraParams = {
	        	academyLocationId : academyLocationId
	    	},
	    	vehicleNameStore.load();    */
	    	var currentLoggedUser=this.getCurrentlyLoggedInUser();
	    	var url = SERVERURL.FIND_AL_BY_USER_ID;
	    	
	    	 Ext.Ajax.request({
  	      		  type : 'rest',
  	      		  url : url,
  	      		  method : 'GET',
  	      		  params: {
  	      			id : currentLoggedUser.id
    			  },
    			  success : function(form, action) {
    				  var response = Ext.decode(form.responseText);
    				  var alIds = [];
    				  for(var index in response) {
    					  alIds.push(response[index].id);
    				  }
    				  var routeNameField=routeSearchForm.findField('routeName');
    				  var routeNameStore =routeNameField.getStore();
    				  routeNameStore.getProxy().extraParams = {
    					  academyLocationIds : alIds.join()
    				  },
    				  routeNameStore.load();    
    			  }
  	      	  });
	    	
	    	/*var routeNameField=routeSearchForm.findField('routeName');
	    	var routeNameStore =routeNameField.getStore();
	    	routeNameStore.getProxy().extraParams = {
	        	academyLocationIds : academyLocationId
	    	},
	    	routeNameStore.load();    */
	    	
	    	var stopField=routeSearchForm.findField('stop');
	    	var stopStore =stopField.getStore();
	    	stopStore.getProxy().extraParams = {
	    		academyLocationIds : academyLocationId
	    	},
	    	stopStore.load();  
	    	
	    	var responsiblePersonRouteField=routeSearchForm.findField('responsiblePersonRoute');
	    	var responsiblePersonRouteStore =responsiblePersonRouteField.getStore();
	    	responsiblePersonRouteStore.getProxy().extraParams = {
	    		academyLocationId : academyLocationId
	    	},
	    	responsiblePersonRouteStore.load();  
	    	
	    	var startLocationField=routeSearchForm.findField('startLocationId');
	    	var startLocationStore =startLocationField.getStore();
	    	startLocationStore.getProxy().extraParams = {
	    		academyLocationIds : academyLocationId
	    	},
	    	startLocationStore.load();  
	    	
	    },
	    /**
	     * Save route data
	     */
	     saveRouteData:function(){
	    	 var $this = this;
			 var grid = $this.getRoutemastergrid();
		   	 var routeForm = $this.getRouteform();
		   	 var getForm=routeForm.getForm();
		   	 var formValues=getForm.getValues();
		   	 var academyLocationId = $this.getCurrentAcademyLocation();
		   	 var respPersonField=getForm.findField('responsiblePerson');
		     var distanceInKmField=getForm.findField('distanceInKm');
		   	 var roundTripValue=null;
		   	 if(formValues.roundTrip=="YES"){
		   		roundTripValue=true;
		   	 }else if(formValues.roundTrip=="NO"){
		   		roundTripValue=false; 
		   	 }
		   	
		   	var isActiveValue=null;
		   	 if(formValues.isActive=="YES"){
		   		isActiveValue=true;
		   	 }else if(formValues.isActive=="NO"){
		   		isActiveValue=false; 
		   	 }
		   	 
		   	 var routeData={
		   		   "id":formValues.id,
		   		   "academyLocation":{
		   			 "id":academyLocationId  
		   		   },
		   		   "responsiblePersonId":respPersonField.getValue(),
		   		  // "responsiblePersonName":respPersonField.getRawValue(),
		   		   "wsEndLocation":{
		   		      "id":formValues.endsAt
		   		   },
		   		   "wsStartLocation":{
		   		      "id":formValues.startsFrom
		   		   },
		   		   "routeName":formValues.routeName,
		   		   "responsiblePersonNameExt":formValues.responsiblePersonExt,//not found in wire frame
		   		   "whetherRoundTrip":roundTripValue,
		   		   "distance":distanceInKmField.getValue(),
		   		   "whetherActive":isActiveValue,
		   		   "routeBillType":"1",//not found in wire frame
		   		   "feePlanId":1,//not found in wire frame
		   		   "droolsAgenda":"1",//not found in wire frame
		   		   "droolsRuleRemarks":"1"//not found in wire frame
		   		};

		   	 /**
		   	  * Save route call
		   	  */
		    var submitUrl=null;
		   	if(isNullOrEmpty(formValues.id)){
		   		submitUrl=SERVERURL.ROUTE_CREATE_URL;
		   	}else{
		   		submitUrl=SERVERURL.ROUTE_UPDATE_URL;
		   	}

		    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		    
	  		  Ext.Ajax.request({
	      		  type : 'rest',
	      		  url : submitUrl,
	      		  jsonData : routeData,
	      		  method : 'POST',
	      		  success : function(resp, action) {
	      			  var routeId=null;
	      			if(isNullOrEmpty(formValues.id)){
	      				 routeId=resp.responseText;
	      			}else{
	      				 routeId=formValues.id;
	      			}
	      			
	      			 /**
		   		   	  * Json for stop
		   		   	  */
		   		   	var stopContiner = routeForm.down('#stopPanelId');
		           	var stopFieldsCount = stopContiner.items.length;
		           	var stopArray=new Array();
		   	  		 if(stopFieldsCount>2){
		      			  for(var j=1; j<stopContiner.items.length &&  j<stopContiner.items.length; j++){
		      				
		      				var stopPanelContainer=stopContiner.items.items[j];
		      				stopArray.push({
		      					  "routeId":routeId,
		      					  "routeLocation":{
		      						  "id":stopPanelContainer.items.items[0].getValue()//formValues.location[j]
		      					  },
		      					  "distanceOnward": stopPanelContainer.items.items[1].getValue(),
		      					  "stopSeqOnward":j+1,
		      					  "whetherActive": true,
		      					  "id":stopPanelContainer.down('#stopsId').getValue()
		      		           	
		      				  });
		      			  }
		      		    }else{
		      		    	var id=null;
		      		    	if(!isNullOrEmpty(stopContiner.down('#stopsId'))){
		      		    		id=stopContiner.down('#stopsId').getValue()
		      		    	}
		      		    	stopArray.push({
		      					  "routeId":routeId,
		      					  "routeLocation":{
		      						  "id":formValues.location
		      					  },
		      					  "distanceOnward": formValues.distance,
		      					  "stopSeqOnward":1,
		      					  "whetherActive": true,
		      					  "id":id
		      					 
		      				  });
		      		    }
		   	  		 
	      			/**
		   		   	  * Save Stop call
		   		   	  */
		      			var stopSubmitUrl=null;
		    		   	if(isNullOrEmpty(formValues.id)){
		    		   		stopSubmitUrl=SERVERURL.ROUTE_STOP_CREATE_URL;
		    		   	}else{
		    		   		stopSubmitUrl=SERVERURL.ROUTE_STOP_UPDATE_URL;
		    		   	}
		    		   	
		   	  		  Ext.Ajax.request({
		   	      		  type : 'rest',
		   	      		  url : stopSubmitUrl,
		   	      		  jsonData : stopArray,
		   	      		  method : 'POST',
		   	      		  success : function(form, action) {  //formValues.routeName
		   	      			var academyLocationId = $this.getCurrentAcademyLocation();
		   	      			var gridStore=grid.getStore();
		   	      			gridStore.getProxy().extraParams = {
		   	      				//routeName : getForm.findField('routeName').getValue(),
		   	      				//roundTrip:getForm.findField('roundTrip').getValue(),
		   	      				academyLocationId:academyLocationId
	     					};
		   	      			gridStore.load();
		   	      			showSuccessMessage(getTransportTranslation('ROUTE'),getCommonTranslation('SUCCESS'));
		   	      		    getForm.reset();
		   	      		  }
		   	      	  });
		   	  		Ext.getBody().unmask();
	      		  }
	  		  
	      	  });
	     },
	      /**
	       * Edit route Form data 
	       */
	      editRouteFromData:function(mode){
	    	  var $this=this;
		      var grid = $this.getRoutemastergrid();
		      Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
          	 if (grid.getSelectionModel().getCount() > 0) {
          		$this.openRouteFormTab();
          		var routeForm = $this.getRouteform();
    		   	var getForm=routeForm.getForm();
          		var records = grid.getSelectionModel().getSelection()[0];
          		/**
          		 * Load route data
          		 */
          		var serverUrl=SERVERURL.ROUTE_EDIT_URL;
				 Ext.Ajax.request({
          		 method: "GET",
          		 type: 'rest',
          		 url: serverUrl,
          		 headers: {
          			 'Content-Type': 'application/json'
          		 },
          		 params: {
          			 id: records.data.id
          		 },
          		 success: function(f, action) {
          			var data = f.responseText;
          			var  jData=Ext.JSON.decode(data);
          			getForm.findField('id').setValue(jData.id);
          			getForm.findField('routeName').setValue(jData.routeName);
          			getForm.findField('distanceInKm').setValue(jData.distance);
          			var respPersonExtField=getForm.findField('responsiblePersonExt');
          			var responsiblePersonField=getForm.findField('responsiblePerson');
          			
          			responsiblePersonField.allowBlank=true;
          			respPersonExtField.allowBlank=true;
          			responsiblePersonField.setVisible(false);
          			respPersonExtField.setVisible(false);
          			
          			var userTypeValue=null;
          			if(!isNullOrEmpty(jData.responsiblePersonId)){
          				    responsiblePersonField.allowBlank=false;
              				responsiblePersonField.setVisible(true);
              				var userTypeField=getForm.findField('userType');
              				userTypeField.setValue(jData.userTypeId);
              				responsiblePersonField.getStore().load({
                  				callback:function(){
                  					responsiblePersonField.setValue(jData.responsiblePersonId);		
                  				}
                  			});	
          			}else if(!isNullOrEmpty(jData.responsiblePersonNameExt)){
          				var userTypeField=getForm.findField('userType');
          				userTypeField.setValue(0);
          				//respPersonExtField.setFieldLabel(getTransportTranslation('RESPONSIBLE_PERSON')+'<span class="required" style="color:red"> *</span>');
          				//respPersonExtField.allowBlank=false;
          				$this.setAllowBlank(respPersonExtField,false);
          				respPersonExtField.setVisible(true);
          				respPersonExtField.setValue(jData.responsiblePersonNameExt);
          			}
          			
          			var startsFromField=getForm.findField('startsFrom');
          			if(!isNullOrEmpty(jData.wsStartLocation)){
          				startsFromField.getStore().load({
              				callback:function(){
              					startsFromField.setValue(jData.wsStartLocation.id);		
              				}
              			});	
          			}
          			
          			var endsAtField=getForm.findField('endsAt');
          			if(!isNullOrEmpty(jData.wsEndLocation)){
          				endsAtField.getStore().load({
              				callback:function(){
              					endsAtField.setValue(jData.wsEndLocation.id);		
              				}
              			});	
          			}
          			
          			var roundTripField=getForm.findField('roundTrip');
          			if(!isNullOrEmpty(jData.whetherRoundTrip)){
          				var roundTrip=null;
          				if(jData.whetherRoundTrip==true){
          					roundTrip="YES";
          				}else if(jData.whetherRoundTrip==false){
          					roundTrip="NO";
          				}
          				roundTripField.getStore().load({
              				callback:function(){
              					roundTripField.setValue(roundTrip);		
              				}
              			});	
          			}
          			
          			var isActiveField=getForm.findField('isActive');
          			if(!isNullOrEmpty(jData.whetherActive)){
          				var isActiveValue=null;
          				if(jData.whetherActive==true){
          					isActiveValue="YES";
          				}else if(jData.whetherActive==false){
          					isActiveValue="NO";
          				}
          				isActiveField.getStore().load({
              				callback:function(){
              					isActiveField.setValue(isActiveValue);		
              				}
              			});	
          			}
          			
          			/**
	           		 * Load Stop data
	           		 */
	          		var stopServerUrl=SERVERURL.STOP_EDIT_URL;
						 Ext.Ajax.request({
		         		 method: "GET",
		         		 type: 'rest',
		         		 url: stopServerUrl,
		         		 headers: {
		         			 'Content-Type': 'application/json'
		         		 },
		         		 params: {
		         			routeId: jData.id
		         		 },
		         		 success: function(resp, action) {
          			var data = f.responseText;
          			var  jData=Ext.JSON.decode(data);
          			getForm.findField('id').setValue(jData.id);
          			getForm.findField('routeName').setValue(jData.routeName);
          			getForm.findField('distanceInKm').setValue(jData.distance);
          			var respPersonExtField=getForm.findField('responsiblePersonExt');
          			var responsiblePersonField=getForm.findField('responsiblePerson');
          			
          			responsiblePersonField.allowBlank=true;
          			respPersonExtField.allowBlank=true;
          			responsiblePersonField.setVisible(false);
          			respPersonExtField.setVisible(false);
          			
          			
          			var userTypeValue=null;
          			if(!isNullOrEmpty(jData.responsiblePersonId)){
          				    responsiblePersonField.allowBlank=false;
              				responsiblePersonField.setVisible(true);
              				var userTypeField=getForm.findField('userType');
              				userTypeField.setValue(jData.userTypeId);
              				responsiblePersonField.getStore().load({
                  				callback:function(){
                  					responsiblePersonField.setValue(jData.responsiblePersonId);		
                  				}
                  			});	
          			}else if(!isNullOrEmpty(jData.responsiblePersonNameExt)){
          				var userTypeField=getForm.findField('userType');
          				userTypeField.setValue(0);
          				//respPersonExtField.setFieldLabel(getTransportTranslation('RESPONSIBLE_PERSON')+'<span class="required" style="color:red"> *</span>');
          				//respPersonExtField.allowBlank=false;
          				$this.setAllowBlank(respPersonExtField,false);
          				respPersonExtField.setVisible(true);
          				respPersonExtField.setValue(jData.responsiblePersonNameExt);
          			}
          			          			          			
          			var startsFromField=getForm.findField('startsFrom');
          			if(!isNullOrEmpty(jData.wsStartLocation)){
          				startsFromField.getStore().load({
              				callback:function(){
              					startsFromField.setValue(jData.wsStartLocation.id);		
              				}
              			});	
          			}
          			
          			var endsAtField=getForm.findField('endsAt');
          			if(!isNullOrEmpty(jData.wsEndLocation)){
          				endsAtField.getStore().load({
              				callback:function(){
              					endsAtField.setValue(jData.wsEndLocation.id);		
              				}
              			});	
          			}
          			
          			var roundTripField=getForm.findField('roundTrip');
          			if(!isNullOrEmpty(jData.whetherRoundTrip)){
          				var roundTrip=null;
          				if(jData.whetherRoundTrip==true){
          					roundTrip="YES";
          				}else if(jData.whetherRoundTrip==false){
          					roundTrip="NO";
          				}
          				roundTripField.getStore().load({
              				callback:function(){
              					roundTripField.setValue(roundTrip);		
              				}
              			});	
          			}
          			
          			var isActiveField=getForm.findField('isActive');
          			if(!isNullOrEmpty(jData.whetherActive)){
          				var isActiveValue=null;
          				if(jData.whetherActive==true){
          					isActiveValue="YES";
          				}else if(jData.whetherActive==false){
          					isActiveValue="NO";
          				}
          				isActiveField.getStore().load({
              				callback:function(){
              					isActiveField.setValue(isActiveValue);		
              				}
              			});	
          			}
          			
          			/**
	           		 * Load Stop data
	           		 */
	          		var stopServerUrl=SERVERURL.STOP_EDIT_URL;
						 Ext.Ajax.request({
		         		 method: "GET",
		         		 type: 'rest',
		         		 url: stopServerUrl,
		         		 headers: {
		         			 'Content-Type': 'application/json'
		         		 },
		         		 params: {
		         			routeId: jData.id
		         		 },
		         		 success: function(resp, action) {
		         			var data = resp.responseText;
		         			var  stopjData=Ext.JSON.decode(data);
		         		
		         			//if(stopjData.rows.length>0){
		         			var fieldContainerIndex=1;
			         			Ext.Array.each(stopjData.rows,function(value,index){
	               				 var fieldContainer=Ext.ComponentQuery.query('fieldcontainer#stopPanelId')[0];
	               				 /**
	               				  * Load start Location and distance
	               				  * startLocationField is fetch to send in addmultipleStops functionality to create multiple stops.
	               				  */
	               				 var startLocationField=getForm.findField('startLocation');
		               			  if(value.routeStopType=="START"){
		               				    startLocationField.setValue(value.routeLocation.id);
		               					getForm.findField('startDistance').setValue(value.distanceOnward);
		               				 }
		               			 /**
	               				  * Load End Location and distance
	               				  */
		               			  if(value.routeStopType=="END"){
		               					getForm.findField('endLocation').setValue(value.routeLocation.id);
		               					getForm.findField('endDistance').setValue(value.distanceOnward);
		               				 }
	               				
		               				 if(index>=1&&value.routeStopType=="INTERMEDIATE"){
		               					 $this.addMultipleStops(startLocationField);	 
		               					 /**
		               					  * It is used to delay task 
		               					  */
		               					var task = new Ext.util.DelayedTask(function(){

			               					 var currentFieldContainer=fieldContainer.items.items[fieldContainerIndex];
			               					 currentFieldContainer.items.items[0].setValue(value.routeLocation.id);
			               					 currentFieldContainer.items.items[1].setValue(value.distanceOnward);
			               					 currentFieldContainer.items.items[2].setValue(value.id);
			               					fieldContainerIndex=fieldContainerIndex+1;
		               					});
		               					
		               					task.delay(1000);

		               				 }
	               			    });
		         			
		         			//}
		         			/**
		         			 * This functionality is used for view mode 
		         			 */
		         			if(mode=="view"){
				   				 if (routeForm) {
				   					routeForm.down('#btnSave').hide();
				   					routeForm.down('#btnReset').hide();
				   					toggleReadOnlyFormItems(getForm, true);
				   					routeForm.down('#stopBtn').hide();
				   					var stopBtns = Ext.ComponentQuery.query('#stopBtn');
				   					var stopDeleteBtns = Ext.ComponentQuery.query('#stopDeleteBtn');
				   					if(stopBtns.length>0){
				   						stopBtns.forEach(function(obj){
				   							obj.hide();
				   				    	});
				   					}
				   					if(stopDeleteBtns.length>0){
				   						stopDeleteBtns.forEach(function(obj){
				   							obj.hide();
				   				    	});
				   					}
				   				 } 
		         			 }
		         			Ext.getBody().unmask();
		         		 }
		         		});
						 grid.getSelectionModel().deselectAll();	 
          		   }
		         		});
						 grid.getSelectionModel().deselectAll();	 
          		   }
				 });
				 
            }else {
      		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
      	   }
	      },
		  /**
		    * Add multiple stops in panel
		    */
	       addMultipleStops:function(obj){
		   	   var $this = this;
		   	   var stopContiner = $this.getRouteform().down('#stopPanelId');
		   	   var timeFieldsCount = stopContiner.items.length;
		   	   var panelItem = new Array();
		   	   var fieldContainer=obj.up('fieldcontainer');
		   	   var newcont=stopContiner.items.indexOf(fieldContainer);
			   var insertPosition=newcont+1;
		   	   panelItem.push({
		   		   xtype:'fieldcontainer',
		   		   width: '100%',
		   		   layout : 'hbox',
		   		   defaults : {
		   			   width: 226,
		   			   labelAlign : 'top'
		   		   },
		   		   items : [{
						xtype : 'customcombobox',
						name : 'location',		
						store: 'transport.route.LocationName',
						displayField: 'locationName',
						valueField: 'id',
						editable : false,
						allowBlank:false
					},{
						xtype : 'numberfield',
						name : 'distance',	
						minValue : 0,
		                hideTrigger:true,
						allowBlank:false
		   		    },{
	    			    xtype:'hidden',
	    			    name:'stopsId',
	    			    itemId:'stopsId',
		    		},{
		   		    	xtype: 'button',
						itemId: 'stopBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						width:40,
						/*style:{
							marginTop:'30px'
						}*/
			   	   },{
		   			   xtype: 'button',
		   			   glyph: ICONGLYPH.DELETEGLYPH,
		   			   itemId: 'stopDeleteBtn',
		   			   cls: 'CustomBodyBtnReject',
		   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
		   			   width:40,
		   			   /*style:{
		   				   marginTop:'30px'
		   			   },*/
		   			   listeners:{
		   				   click:function(obj){
		   					   var container = obj.up('fieldcontainer');
		   					   var panelContiner = $this.getRouteform().down('#stopPanelId');
		   					   /*if(!isNullOrEmpty(container.down('#stopsId'))){
		   						var id=container.down('#stopsId').getValue();
			   					   if(id>0){
			   						Ext.Ajax.request({
				             			 method: "DELETE",
				             			 type: 'rest',
				             			 url: SERVERURL.DELETE_ROUTE_STOP_URL+'?id='+id,
				             			 headers: {
				             				 'Content-Type': 'application/json'
				             			 },
				             			 success: function(form, action) {
				             				 showSuccessMessage(getTransportTranslation('ROUTE'), getTransportTranslation('ROUTE_SUCCESFULLY_DELETED'));
				             			 }
				             		 }); 
			   					   }
		   					   }*/
		   					   panelContiner.remove(container);
		   					   $this.getRouteform().getForm().checkValidity();
		   					   $this.getRouteform().getForm().isValid();
		   					   $this.getRouteform().getForm().clearInvalid();
		   				   }
		   			   }
		   		   }]
		   	   });
		     	stopContiner.insert(insertPosition,panelItem);
		     	stopContiner.doLayout();
		      },
		      /**
		       * Delete route data from grid 
		       */
		      deleteRouteFromGrid:function(){
		    	  var $this=this;
				  var grid = $this.getRoutemastergrid();

             	 if (grid.getSelectionModel().getCount() > 0) {
             		 var records = grid.getSelectionModel().getSelection()[0];
             			//var timeId=records.data.timeId>0?records.data.timeId:'';
             			var dateId=records.data.id;
             		 
             			showConfirmMessage(getTransportTranslation('ROUTE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
             				 function(btn, text) {
             			 if (btn == 'yes'){
		             		 Ext.Ajax.request({
		             			 method: "DELETE",
		             			 type: 'rest',
		             			 url: SERVERURL.DELETE_ROUTE_URL+'?id='+dateId,
		             			 headers: {
		             				 'Content-Type': 'application/json'
		             			 },
		             			 success: function(form, action) {

		             				if(form.responseText == '0') {
		             					showWarningMessage(getTransportTranslation('ROUTE'),getTransportTranslation('ROUTE_DELETE_MESSAGE'));
		             				} else {
		             					grid.store.reload();
			             				 showSuccessMessage(getTransportTranslation('ROUTE'), getTransportTranslation('ROUTE_SUCCESFULLY_DELETED'));
		             				}
		             			 }
		             		 });
             			 }
             		 });
             	 } else {
             		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
             	 }
		      },
		      loadUserComboData : function(combo) {
					var this$ = this;
						combo.getStore().on('beforeload', function(){
							var routeForm = this$.getRouteform();
							var userTypeCombo = routeForm.down('#userTypeItemId');
							var userType = userTypeCombo.getValue();
							var academyLocationId = this$.getCurrentAcademyLocation();
							var store = combo.getStore();
							if (!isNullOrEmpty(userType)) {
							    if(!isNullOrEmpty(store)) {
							    	store.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										userType: userType
									};
							    }
								return true;
							} else {
								combo.rawValue = '';
								combo.lastValue = '';
								combo.lastQuery = '';
								 if(!isNullOrEmpty(combo.getStore())) {
									 combo.getStore().removeAll();
								 }
								return false;
							}
						});
				}
});
