/**
 * @author Niklesh Tiwane
 */
Ext.define('Academia.controller.users.userProfileLastActivity.UserProfileController', {
	extend: 'Academia.controller.securitysetup.User',
	models:[],
	stores: ['userProfileLastActivity.RecentVisitedProfileStore',
			'userProfileLastActivity.UserProfileFilterStore'],
	views: [
		'userandrole.userProfileLastActivity.UserProfileStructure',
		"userandrole.userProfileLastActivity.RecentVisitedProfile",
		"userandrole.userProfileLastActivity.userProfileFilter",
		"Academia.view.securitysetup.UserBasicDetails"
	],
	refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'},
        {
        ref: 'userprofilestructure',
        selector: 'userprofilestructure'
    	},
    	{
    		ref: 'userprofilefilter',
            selector: 'userprofilefilter'
    	},
    	{
    		ref: 'userbasicdetails',
	        selector: 'userbasicdetails'
    	}, {
    		ref: 'recentvisitedprofile',
    		selector: 'recentvisitedprofile'
    	}],
	init: function(application) {
		this.control({
           'userprofilefilter customcombobox[name=userProfileId]': {
               select: function(combo, records) {
                   var userprofilefilter = this.getUserprofilefilter();
                   //userquicksearch searchresultgrid[itemId=userSearchresultgrid
                   
                   var  profileContainerId = userprofilefilter.down('#profileContainerId')
                   var template = userprofilefilter.down('#userProfileSearchComponent');
                   var profileImage = userprofilefilter.down('#profile_image');
                   if(records.length > 0) {
                       var record = records[0].data;
                       //profileContainerId.show()
                       /*template.update({
                          name: record.get('name'),
                          mobileNo: record.get('mobileNo'),
                          employeeId: record.displayValue,
                          email: record.get('email'),
                          status: record.get('status'),
                          image: record.get('image')
                       });*/
                      /* if(record.get('image')){
                    	   profileImage.setSrc(record.get('image')); 
                       }*/
                   } 
                   var requestData = {"configCode":"USER_LIST","searchCriterias":[{"paramCode":"USER_NAME","paramValues":[record.id]},{"paramCode":"WHETHER_DELETED","paramValues":[false]}]};
                   
                   Ext.getBody().mask(getCommonTranslation('Loading...'), 'x-mask-loading');
                   Ext.Ajax.request({
 						type : 'rest',
 						url : SERVERURL.USERQUICKSEARCH+"?page=1&start=0&limit=100",
 						jsonData : requestData,
 						method : 'POST',
 						success : function(response, action) {
 							 Ext.getBody().unmask();
 							var data = Ext.decode(response.responseText);
 							var record = data.rows[0]
 							
                           Ext.Ajax.request({
                               url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + record.USER_ID + '&userType=' + record.USER_GROUP_NAME +'&portalId=' + portalId + '&isDefaultImageRequired=false',
                               method: 'GET',
                               binary: true,
                               success: function (imageResponse) {
                                   var imageUrl = null;

                                   if (imageResponse.responseBytes && imageResponse.responseBytes.length > 0) {
                                       var blob = new Blob([imageResponse.responseBytes], { type: 'image/jpg' });
                                       imageUrl = window.URL.createObjectURL(blob);
                                   }
                                   
 							template.update({
 		                          name: record.FULL_NAME,
 		                          employeeId: record.USER_ID,
 		                          email: record.PRIMARY_EMAIL_ID,
 		                          status: record.USER_LIST_STATUS,
                                      userGroupName: record.USER_GROUP_NAME,
                                      code: record.CODE,
                                   })     
                                   
                                   if (imageUrl) {
                                       profileImage.el.dom.src = imageUrl;
                                   } else {
                                       var firstName = record.FULL_NAME;
                                       var middleName = record.MIDDLE_NAME;
                                       var lastName = record.LAST_NAME;
                                       var fallbackImg = generateInitialsImage(firstName, middleName, lastName);
                                       profileImage.setSrc(fallbackImg);
                                   }
                            },
                           failure:function(){
  	        				 Ext.getBody().unmask(); 
  	        			 }
 		                       }) 							 
 						}
		  			});
            //   }
		profileContainerId.show();
                   
                   
               },
          },
          'recentvisitedprofile':{
       	   afterrender: function(profile){
       		   Ext.defer(function() {
       			   var storeDataLength = profile.down('dataview').getStore().data.length;
         		        var profileTitle = profile.title;
         		        var NoRecordFoundImg = profile.down('#NoRecordFoundContainer')

         		        if (storeDataLength > 0) {
         		            profile.setTitle(profileTitle + " (" + storeDataLength + ")");
         		        } else {
         		        	NoRecordFoundImg.setVisible(true);
         		        }
       		   }, 200, this);
       	   }
          },
          /*'tabpanel[itemId="recentvisitedprofileItemId"]': {
        	    tabchange: function(tabPanel, newCard, oldCard) {
        	        if (newCard.itemId === 'recentvisitedprofile') {
        	            Ext.defer(function() {
        	                var dataview = newCard.down('dataview');
        	                var store = dataview ? dataview.getStore() : null;
        	                var storeDataLength = store ? store.getCount() : 0;

        	                var profileTitle = newCard.initialConfig.title || newCard.title;
        	                var NoRecordFoundImg = newCard.down('#NoRecordFoundContainer');

        	                if (storeDataLength > 0) {
        	                    newCard.setTitle(profileTitle + " (" + storeDataLength + ")");
        	                    if (NoRecordFoundImg) {
        	                        NoRecordFoundImg.setVisible(false);
        	                    }
        	                } else {
        	                    if (NoRecordFoundImg) {
        	                        NoRecordFoundImg.setVisible(true);
        	                    }
        	                }
        	            }, 200, this);
        	        }
        	    }
        	},*/
           'userprofilefilter component[itemId=userProfileSearchComponent]': {
        	   afterrender: this.getUserProfileInfo 
          },
          'recentvisitedprofile dataview[itemId=recentVisitedProfileDataViewItemId]': {
              afterrender: this.getUserProfileInfo 
         }	
		})		
	},
    getUserProfileInfo: function(view) {
        var el = view.getEl();
        if(el) {
    		el.on('click', function(event, target){
    			if(Ext.fly(target).hasCls('open-profile-link')) {
    				var infoBox, employeeId;
    				var employeeData = {};
    				infoBox = Ext.fly(target).up('.std-info-box') || Ext.fly(target).up('.recentVistedBox');
    				
    				if(infoBox) {
    					employeeId = infoBox.down('.open-profile-link').getAttribute('data-employeeId');
    					var userGroup = target.getAttribute('data-userGroup');
    					var visitedUserId = target.getAttribute('data-visitedUserId');
    					var userGroupName = target.getAttribute('data-userGroupName');
    					var code = target.getAttribute('data-code');
    					
    					employeeData = {
    							CODE: employeeId,
    							USER_GROUP_NAME: userGroup || userGroupName || '' ,
    							USER_ID: visitedUserId || employeeId || ''
    					}
    					
    					if (!Ext.isEmpty(employeeData.CODE)) {
							this.openUserProfilePage(employeeData);
						} else {
							showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('NO_RECORD_FOUND'));
						}
    				}
    			} 
    		}, this, {delegate: 'a.open-profile-link'})
    	}
    },
    openUserProfilePage: function(employeeData){
    	this.openUserDetailViewFromRecentList(employeeData);
    }
});