/**
 * by Vyabha Thakur
 */
Ext.define('Academia.model.admission.applications.applicantProfileBase.ApplicationDocumentAndNotesModel', {
	extend : 'Ext.data.Model',
	fields :['application', 'applicant', 'applicantName','batch', 'period','date','academicTopics', 'academicSubTopics','subCategory', 'category', 'description','id',
	         'programId','academicTopicId','code', 'programName', 'createdAt', 'createdBy', 'updatedAt', 'updatedBy', 'status', 'applicantAcademicTopicDocuments',
	         'applicantAcademicTopicUrl', 'isPublished', 'documents', {
		name: 'documentName',
		convert: function(val, rec) {
			var docs = rec.get('documents');
			if(docs.length > 1) {
				return docs.length;
			}
			else if(docs.length == 0) {
				return "";
			}
			else {
				return rec.get('documents')[0].name;
			}
		}
	}, {
		name: 'urlName',
		convert: function(val, rec) {
			var urls = rec.get('applicantAcademicTopicUrl');
			if(urls.length > 1) {
				return urls.length;
			}
			else if(urls.length == 0) {
				return "";
			}
			else {
				return rec.get('applicantAcademicTopicUrl')[0].name;
			}
		}
	}, {
		name: 'Status',
		convert: function(val, rec) {
			return rec.get('status')
		}
	}]
});