Ext.define('Academia.model.common.IdValueCodeDataModel', {
	extend : 'Ext.data.Model',
	fields : ['eventRemark','feeHeadName','name', 'id','code','isCurrentPeriodOfProgram','whetherCurrentAcademicTerm','academicTermId','academicTermName','whetherAllowed','educationDepartment','doubleValue','name','courseCode','substituteFacultyId', 'courseName','programName','programCode', 'batchName','batchId','courseId','programId','programPeriodName','courseDefinitionName','courseDefinitionId','periodId','campaignName','sequence','projectNumber','parentId','scholarshipAmount','grantedby', 'admissionID','admissionCode','admissionValue','itemCode','year','dublinDescriptorsName','programLearningOutcomeName','eventName','categoryId','personId',{
        name    : 'valueCode', 
        convert : function (v, rec) {
           return rec.get('code') + ' / ' + rec.get('value');
        }
    },{
    	name:'value',
    	sortType:'asUCText'
    },{
        name    : 'displayValue', 
        convert : function (v, rec) {
        	if(!isNullOrEmpty(rec.get('value'))){ 
				return Ext.String.trim(rec.get('value'));
        	}else{
        		 return null;
        	}
          
        },
        
    },{
        name    : 'camelCaseValue', 
        convert : function (v, rec) {
        	if(!isNullOrEmpty(rec.get('value'))){
        		 return rec.get('value').replace(/(?:^\w|[A-Z]|\b\w|\s+)/g, function(match, index) {
         		    if (+match === 0) return "";
         		    return index == 0 ? match.toUpperCase() : match.toLowerCase();
         	 });
        	} else {
        		 return null;
        	}
        }
    },{
        name    : 'codeValue', 
        convert : function (v, rec) {
           return rec.get('value') + ' / ' + rec.get('code');
        }
    },{
        name    : 'valueCode', 
        convert : function (v, rec) {
           return rec.get('code') + ' / ' + rec.get('value');
        }
    },{
        name    : 'valueSecondValue', 
        convert : function (v, rec) {
        	if(rec.get('secondValue')==""){
       		 return rec.get('value');
       	}else{
           return rec.get('value') + ' / ' + rec.get('secondValue');
       	}
        }
    },{
        name    : 'displayCourse', 
        convert : function (v, rec) {
        	if(rec.get('courseCode') && rec.get('courseName')){
        		return rec.get('courseCode') + ' / ' + rec.get('courseName');
        	}
        }
    }, 'secondValue', 'doubleValue', 'check', 'secondCode','secondCheck','sequence','sectionAtComponentLevel','courseId','academyLocation',
    'parentCourseId', 'componentId', 'activeStatus','secondId','location'
    ,'uiDisplayCode' ,'status','customData', {name: 'educationDepartmentValue', mapping: 'educationDepartment.value'}, {name: 'documentStatusCSMValue', mapping: 'documentStatusCSM.value'},
    {name: 'documentTypeValue', mapping: 'documentType.value'},{name: 'documentStatusCSMId', mapping: 'documentStatusCSM.id'},
    {name: 'documentTypeId', mapping: 'documentType.id'},{name: 'admissionConditionValue', mapping: 'admissionCondition.value'},{name: 'admissionConditionId', mapping: 'admissionCondition.id'},{name: 'admissionConditionCode', mapping: 'admissionCondition.code'},
    'conditionCheck','applicationProgramAdmissionDetails','offerType','submissionDate','itemValue','code','displayOtherLanguage','printName','whetherTotalEventWeightageC','conditionSatisfactionDate','datePrefillValue','applicantPerson','person','saqaTrackingNumber',
    {
    	name: 'translatedCode',
    	convert: function(v, rec){
    		return getCompletionModuleTranslation(rec.get('code'));
    	}
    },
    {
    	name: 'translatedValue',
    	convert: function(v, rec){
    		return getCommonTranslation(rec.get('value'));
    	}
    },
    {
    	name: 'coursecodeName',
    	convert: function(v, rec){
    		 return rec.get('courseCode') + ' / ' + rec.get('courseName');
    	}
    },
    {
    	name: 'codeValueOtherLang',
    	convert : function (v, rec) {
            return rec.get('code') + ' / ' + rec.get('value') + ' / ' + rec.get('displayOtherLanguage');
         }
    },{  name:'value',
        sortType:'asUCText'
    }, {
    	name: 'appliedExamMarkEntry',
    	convert : function (v, rec) {
            if(isNullOrEmpty(v)) {
            	return false;
            }
            return v;
         }
    }, 
    {
    	name:'progCodeOrName',
    	convert : function (v, rec) {
            return rec.get('code') + ' / ' + rec.get('value') ;
         }
    		},
    		{
    			name:'programCode'
    		},
    		{
    	    	name:'courseCodeOrName',
    	    	convert : function (v, rec) {
    	            return rec.get('code') + ' / ' + rec.get('value') ;
    	         }
    	    		},
    	    		{
    	    			name:'courseCode'
    	    		}, 'programShortName', {
    	    			name: 'programBatchName',
    	    			convert : function (v, rec) {
    	    				return rec.get('programShortName')+" - "+rec.get('value');
    	    			}
    	    		},
    	    		{
    	    			name: 'randomId',
    	    			convert: function(v, rec){
    	    				return randomString(10);
    	    			}
    	    		},{
						name: 'inactiveReasonValues',
						convert: function(v, rec){
							try{
								if(inactiveReasonCSMObj && Object.keys(inactiveReasonCSMObj).length && !isNullOrEmpty(inactiveReasonCSMObj[rec.get('code')])){
									return inactiveReasonCSMObj[rec.get('code')]
								}
								else{
									return rec.get('value');
								}
							}
							catch(e){
								return rec.get('value');
							}
						}
					},
					{
				    	name: 'studentDisplayVal',
				    	convert : function (v, rec) {
				            return rec.get('code') + ' / ' + rec.get('value') + ' / ' + rec.get('itemValue');
				         }
				    },
				    {
				    	name: 'studentDisplayValue',
				    	convert : function (v, rec) {
				            return rec.get('secondValue') + ' / ' + rec.get('value') + ' / ' + rec.get('code');
				        }
				    }
					,{
					            name: 'studentCodeValueResult',
					            convert: function(v, rec) {
					                var val = rec.get('codeValue');
					                if (val) {
					                    var parts = val.split('/'),
					                        p1 = parts[0] ? parts[0].trim() : '',
					                        p2 = parts[1] ? parts[1].trim() : '';
					                    if (p1 && p2) {
					                        return p2 + ' / ' + p1;
					                    }
					                    return val;
					                }
					                return '';
					            }
					        }]
});